# Sound Open Firmware Tools

This is a collection of open source tools used to develop, test and debug SOF.

## Building and Installing

```bash
mkdir build_tools
cd build_tools
cmake ..
make
make install
```

### sof-logger

sof-logger is used to print logs delivered from FW dma_trace mechanism, by
searching log entries in *.ldc file generated by smex.

Every entry declared in FW is placed in elf output file (e.g. sof-apl) in
.static_log_entries section in a form of struct defined in
sof/src/include/sof/trace.h in sof fw repo.

*.ldc file contains `snd_sof_logs_header` (defined in
rmbox/logger\_convert.c) following by `.static_log_entries` section
incorporated from FW elf file (e.g. sof-apl). `snd_sof_logs_header`
contains basic information about `.static_log_entries` section
like `base_address` and `data_length`.

sof-logger works by reading entry parameters value and entries addresses from
FW dma_trace mechanism and searching suitable entry in *.ldc file by its
address.

```
Usage sof-logger <option(s)> <file(s)>
			Display mailbox contents
-h			help
-l *.ldc_file		Specify the *.ldc file
-i in_file		Get traces from in_file, instead of the default
			"/sys/kernel/debug/sof/etrace"
-o out_file		Specify the output file, instead of default stdout
-t			Get traces from "/sys/kernel/debug/sof/trace", instead
			of the default "/sys/kernel/debug/sof/etrace"
-u baud			Input data from a UART
-r			Less formatted output for chained log processors
-p			Get traces from stdin, instead of the default
			"/sys/kernel/debug/sof/etrace"
-c			Set timestamp clock in MHz
-e			Enable checking firmware version with default verification file
			"/sys/kernel/debug/sof/fw_version"
-v ver_file		Enable checking firmware version with ver_file file,
			instead of default: "/sys/kernel/debug/sof/fw_version"
-s state_name		Take a snapshot of state. Save the debugfs entries in
			state_name.*.txt.
```

**Examples:**

Get traces from "/sys/kernel/debug/sof/etrace" file, verifies fw\_version with
"/sys/kernel/debug/sof/fw_version" and prints logs to stdout

	$ sof-logger -l ldc_file -e

Get traces from "/sys/kernel/debug/sof/etrace" file, verifies fw_version with
`ver_file` file and prints logs to stdout

	$ sof-logger -l ldc_file -v ver_file

Get traces from "/sys/kernel/debug/sof/etrace" file and prints logs to stdout

	$ sof-logger -l ldc_file

Get traces from "/sys/kernel/debug/sof/etrace" file and prints logs to
`out_file` file

	$ sof-logger -l ldc_file -o out_file

Get traces from "/sys/kernel/debug/sof/trace" file and prints logs to stdout

	$ sof-logger -l ldc_file -t

Get traces from "/sys/kernel/debug/sof/trace" file and prints logs to
`out_file` file

	$ sof-logger -l ldc_file -t -o out_file

Get traces from stdin and prints logs to stdout

	$ sof-logger -l ldc_file -p

Get traces from stdin and prints logs to `out_file` file

	$ sof-logger -l ldc_file -p -o out_file

Get traces from trace\_dump file and prints logs to stdout

	$ sof-logger -l ldc_file -i trace_dump

Get traces from trace\_dump file and prints logs to `out_file` file

	$ sof-logger -l ldc_file -i trace_dump -o out_file

`c` flag is intended for defining clock value (in MHz) used to format log
timestamps. By default clock value is set to 19.2 (MHz). Below example
set clock value to 19.9 (MHz).

	$ sof-logger -l ldc_file -i trace_dump -o out_file -c 19.9


### sof-coredump-reader

Tool for processing FW stack dumps. In verbose mode it prints the stack leading
to the core dump including DSP registers and function calls.
It outputs unwrapped gdb command function call addresses to human readable
function call format either to a file or stdout.

```
Usage sof-coredump-reader.py [-h] [-a ARCH] [-c] [-l COLUMNCOUNT] [-v]
				(--stdout | -o OUTFILE) [--stdin | -i INFILE]

-h			show this help message and exit
-a ARCH			determine architecture of dump file; valid archs are: LE64bit, LE32bit
-c			set output to be colourful
-l COLUMNCOUNT		set how many colums to group the output in
-v			increase output verbosity
--stdin			input is from stdin
-i INFILE		path to sys dump bin
--stdout		output is to stdout
-o OUTFILE		output is to FILE
```

**sof-coredump-to-gdb.sh** shows example usage of sof-coredump-reader.py
We read from dump file into sof-coredump-reader.py,
then we pipe its output to xt-gdb, which operates on given elf-file.

    $ ./sof-coredump-to-gdb.sh sof-apl dump_file

### tests

To generate all test configuration files:

```bash
make tests
```

### testbench

The host testbench is meant to serve as a vehicle to test components for
functionality and quality of processed samples.

#### Compilation steps

Run the host-build-all.sh to build the required libraries for the testbench.
It should also build the testbench executable.

#### Running the Testbench

The test can be invoked by running the "testbench" bin in the src/host
directory.

Compile and run using script provided (Recommended):

Set up the input arguments for the test in
**host-testbench.sh** and invoke it to compile the host libraries
and execute the testbench.

Known Limitations:

1. Currently, testbench code supports simple volume topologies only.

2. When setting up arguments, please keep the same file format for input and output files
