<?php

namespace ccxt;

// PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
// https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

class bitlish extends Exchange {

    public function describe () {
        return array_replace_recursive (parent::describe (), array (
            'id' => 'bitlish',
            'name' => 'Bitlish',
            'countries' => array ( 'GB', 'EU', 'RU' ),
            'rateLimit' => 1500,
            'version' => 'v1',
            'has' => array (
                'CORS' => false,
                'fetchTickers' => true,
                'fetchOHLCV' => true,
                'withdraw' => true,
            ),
            'urls' => array (
                'logo' => 'https://user-images.githubusercontent.com/1294454/27766275-dcfc6c30-5ed3-11e7-839d-00a846385d0b.jpg',
                'api' => 'https://bitlish.com/api',
                'www' => 'https://bitlish.com',
                'doc' => 'https://bitlish.com/api',
            ),
            'requiredCredentials' => array (
                'apiKey' => true,
                'secret' => false,
            ),
            'fees' => array (
                'trading' => array (
                    'tierBased' => false,
                    'percentage' => true,
                    'taker' => 0.3 / 100, // anonymous 0.3%, verified 0.2%
                    'maker' => 0,
                ),
                'funding' => array (
                    'tierBased' => false,
                    'percentage' => false,
                    'withdraw' => array (
                        'BTC' => 0.001,
                        'LTC' => 0.001,
                        'DOGE' => 0.001,
                        'ETH' => 0.001,
                        'XMR' => 0,
                        'ZEC' => 0.001,
                        'DASH' => 0.0001,
                        'EUR' => 50,
                    ),
                    'deposit' => array (
                        'BTC' => 0,
                        'LTC' => 0,
                        'DOGE' => 0,
                        'ETH' => 0,
                        'XMR' => 0,
                        'ZEC' => 0,
                        'DASH' => 0,
                        'EUR' => 0,
                    ),
                ),
            ),
            'api' => array (
                'public' => array (
                    'get' => array (
                        'instruments',
                        'ohlcv',
                        'pairs',
                        'tickers',
                        'trades_depth',
                        'trades_history',
                    ),
                    'post' => array (
                        'instruments',
                        'ohlcv',
                        'pairs',
                        'tickers',
                        'trades_depth',
                        'trades_history',
                    ),
                ),
                'private' => array (
                    'post' => array (
                        'accounts_operations',
                        'balance',
                        'cancel_trade',
                        'cancel_trades_by_ids',
                        'cancel_all_trades',
                        'create_bcode',
                        'create_template_wallet',
                        'create_trade',
                        'deposit',
                        'list_accounts_operations_from_ts',
                        'list_active_trades',
                        'list_bcodes',
                        'list_my_matches_from_ts',
                        'list_my_trades',
                        'list_my_trads_from_ts',
                        'list_payment_methods',
                        'list_payments',
                        'redeem_code',
                        'resign',
                        'signin',
                        'signout',
                        'trade_details',
                        'trade_options',
                        'withdraw',
                        'withdraw_by_id',
                    ),
                ),
            ),
        ));
    }

    public function common_currency_code ($currency) {
        if (!$this->substituteCommonCurrencyCodes)
            return $currency;
        if ($currency === 'XBT')
            return 'BTC';
        if ($currency === 'BCC')
            return 'BCH';
        if ($currency === 'DRK')
            return 'DASH';
        if ($currency === 'DSH')
            $currency = 'DASH';
        if ($currency === 'XDG')
            $currency = 'DOGE';
        return $currency;
    }

    public function fetch_markets () {
        $markets = $this->publicGetPairs ();
        $result = array ();
        $keys = is_array ($markets) ? array_keys ($markets) : array ();
        for ($p = 0; $p < count ($keys); $p++) {
            $market = $markets[$keys[$p]];
            $id = $market['id'];
            $symbol = $market['name'];
            list ($base, $quote) = explode ('/', $symbol);
            $base = $this->common_currency_code($base);
            $quote = $this->common_currency_code($quote);
            $symbol = $base . '/' . $quote;
            $result[] = array (
                'id' => $id,
                'symbol' => $symbol,
                'base' => $base,
                'quote' => $quote,
                'info' => $market,
            );
        }
        return $result;
    }

    public function parse_ticker ($ticker, $market) {
        $timestamp = $this->milliseconds ();
        $symbol = null;
        if ($market)
            $symbol = $market['symbol'];
        return array (
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601 ($timestamp),
            'symbol' => $symbol,
            'high' => $this->safe_float($ticker, 'max'),
            'low' => $this->safe_float($ticker, 'min'),
            'bid' => null,
            'ask' => null,
            'vwap' => null,
            'open' => null,
            'close' => null,
            'first' => $this->safe_float($ticker, 'first'),
            'last' => $this->safe_float($ticker, 'last'),
            'change' => null,
            'percentage' => $this->safe_float($ticker, 'prc'),
            'average' => null,
            'baseVolume' => $this->safe_float($ticker, 'sum'),
            'quoteVolume' => null,
            'info' => $ticker,
        );
    }

    public function fetch_tickers ($symbols = null, $params = array ()) {
        $this->load_markets();
        $tickers = $this->publicGetTickers ($params);
        $ids = is_array ($tickers) ? array_keys ($tickers) : array ();
        $result = array ();
        for ($i = 0; $i < count ($ids); $i++) {
            $id = $ids[$i];
            $market = $this->markets_by_id[$id];
            $symbol = $market['symbol'];
            $ticker = $tickers[$id];
            $result[$symbol] = $this->parse_ticker($ticker, $market);
        }
        return $result;
    }

    public function fetch_ticker ($symbol, $params = array ()) {
        $this->load_markets();
        $market = $this->market ($symbol);
        $tickers = $this->publicGetTickers ($params);
        $ticker = $tickers[$market['id']];
        return $this->parse_ticker($ticker, $market);
    }

    public function fetch_ohlcv ($symbol, $timeframe = '1m', $since = null, $limit = null, $params = array ()) {
        $this->load_markets();
        // $market = $this->market ($symbol);
        $now = $this->seconds ();
        $start = $now - 86400 * 30; // last 30 days
        $interval = array ( (string) $start, null );
        return $this->publicPostOhlcv (array_merge (array (
            'time_range' => $interval,
        ), $params));
    }

    public function fetch_order_book ($symbol, $limit = null, $params = array ()) {
        $this->load_markets();
        $orderbook = $this->publicGetTradesDepth (array_merge (array (
            'pair_id' => $this->market_id($symbol),
        ), $params));
        $timestamp = null;
        $last = $this->safe_integer($orderbook, 'last');
        if ($last)
            $timestamp = intval ($last / 1000);
        return $this->parse_order_book($orderbook, $timestamp, 'bid', 'ask', 'price', 'volume');
    }

    public function parse_trade ($trade, $market = null) {
        $side = ($trade['dir'] === 'bid') ? 'buy' : 'sell';
        $symbol = null;
        if ($market)
            $symbol = $market['symbol'];
        $timestamp = intval ($trade['created'] / 1000);
        return array (
            'id' => null,
            'info' => $trade,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601 ($timestamp),
            'symbol' => $symbol,
            'order' => null,
            'type' => null,
            'side' => $side,
            'price' => $trade['price'],
            'amount' => $trade['amount'],
        );
    }

    public function fetch_trades ($symbol, $since = null, $limit = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market ($symbol);
        $response = $this->publicGetTradesHistory (array_merge (array (
            'pair_id' => $market['id'],
        ), $params));
        return $this->parse_trades($response['list'], $market, $since, $limit);
    }

    public function fetch_balance ($params = array ()) {
        $this->load_markets();
        $response = $this->privatePostBalance ();
        $result = array ( 'info' => $response );
        $currencies = is_array ($response) ? array_keys ($response) : array ();
        $balance = array ();
        for ($c = 0; $c < count ($currencies); $c++) {
            $currency = $currencies[$c];
            $account = $response[$currency];
            $currency = strtoupper ($currency);
            // issue #4 bitlish names Dash as DSH, instead of DASH
            if ($currency === 'DSH')
                $currency = 'DASH';
            if ($currency === 'XDG')
                $currency = 'DOGE';
            $balance[$currency] = $account;
        }
        $currencies = is_array ($this->currencies) ? array_keys ($this->currencies) : array ();
        for ($i = 0; $i < count ($currencies); $i++) {
            $currency = $currencies[$i];
            $account = $this->account ();
            if (is_array ($balance) && array_key_exists ($currency, $balance)) {
                $account['free'] = floatval ($balance[$currency]['funds']);
                $account['used'] = floatval ($balance[$currency]['holded']);
                $account['total'] = $this->sum ($account['free'], $account['used']);
            }
            $result[$currency] = $account;
        }
        return $this->parse_balance($result);
    }

    public function sign_in () {
        return $this->privatePostSignin (array (
            'login' => $this->login,
            'passwd' => $this->password,
        ));
    }

    public function create_order ($symbol, $type, $side, $amount, $price = null, $params = array ()) {
        $this->load_markets();
        $order = array (
            'pair_id' => $this->market_id($symbol),
            'dir' => ($side === 'buy') ? 'bid' : 'ask',
            'amount' => $amount,
        );
        if ($type === 'limit')
            $order['price'] = $price;
        $result = $this->privatePostCreateTrade (array_merge ($order, $params));
        return array (
            'info' => $result,
            'id' => $result['id'],
        );
    }

    public function cancel_order ($id, $symbol = null, $params = array ()) {
        $this->load_markets();
        return $this->privatePostCancelTrade (array ( 'id' => $id ));
    }

    public function withdraw ($currency, $amount, $address, $tag = null, $params = array ()) {
        $this->load_markets();
        if ($currency !== 'BTC') {
            // they did not document other types...
            throw new NotSupported ($this->id . ' currently supports BTC withdrawals only, until they document other currencies...');
        }
        $response = $this->privatePostWithdraw (array_merge (array (
            'currency' => strtolower ($currency),
            'amount' => floatval ($amount),
            'account' => $address,
            'payment_method' => 'bitcoin', // they did not document other types...
        ), $params));
        return array (
            'info' => $response,
            'id' => $response['message_id'],
        );
    }

    public function sign ($path, $api = 'public', $method = 'GET', $params = array (), $headers = null, $body = null) {
        $url = $this->urls['api'] . '/' . $this->version . '/' . $path;
        if ($api === 'public') {
            if ($method === 'GET') {
                if ($params)
                    $url .= '?' . $this->urlencode ($params);
            } else {
                $body = $this->json ($params);
                $headers = array ( 'Content-Type' => 'application/json' );
            }
        } else {
            $this->check_required_credentials();
            $body = $this->json (array_merge (array ( 'token' => $this->apiKey ), $params));
            $headers = array ( 'Content-Type' => 'application/json' );
        }
        return array ( 'url' => $url, 'method' => $method, 'body' => $body, 'headers' => $headers );
    }
}
