<?php

namespace ccxt;

// PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
// https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

class zb extends Exchange {

    public function describe () {
        return array_replace_recursive (parent::describe (), array (
            'id' => 'zb',
            'name' => 'ZB',
            'countries' => 'CN',
            'rateLimit' => 1000,
            'version' => 'v1',
            'has' => array (
                'CORS' => false,
                'fetchOHLCV' => true,
                'fetchTickers' => false,
                'fetchOrder' => true,
                'withdraw' => true,
            ),
            'timeframes' => array (
                '1m' => '1min',
                '3m' => '3min',
                '5m' => '5min',
                '15m' => '15min',
                '30m' => '30min',
                '1h' => '1hour',
                '2h' => '2hour',
                '4h' => '4hour',
                '6h' => '6hour',
                '12h' => '12hour',
                '1d' => '1day',
                '3d' => '3day',
                '1w' => '1week',
            ),
            'urls' => array (
                'logo' => 'https://user-images.githubusercontent.com/1294454/32859187-cd5214f0-ca5e-11e7-967d-96568e2e2bd1.jpg',
                'api' => array (
                    'public' => 'http://api.zb.com/data', // no https for public API
                    'private' => 'https://trade.zb.com/api',
                ),
                'www' => 'https://trade.zb.com/api',
                'doc' => 'https://www.zb.com/i/developer',
                'fees' => 'https://www.zb.com/i/rate',
            ),
            'api' => array (
                'public' => array (
                    'get' => array (
                        'markets',
                        'ticker',
                        'depth',
                        'trades',
                        'kline',
                    ),
                ),
                'private' => array (
                    'post' => array (
                        'order',
                        'cancelOrder',
                        'getOrder',
                        'getOrders',
                        'getOrdersNew',
                        'getOrdersIgnoreTradeType',
                        'getUnfinishedOrdersIgnoreTradeType',
                        'getAccountInfo',
                        'getUserAddress',
                        'getWithdrawAddress',
                        'getWithdrawRecord',
                        'getChargeRecord',
                        'getCnyWithdrawRecord',
                        'getCnyChargeRecord',
                        'withdraw',
                    ),
                ),
            ),
            'fees' => array (
                'funding' => array (
                    'withdraw' => array (
                        'BTC' => 0.0001,
                        'BCH' => 0.0006,
                        'LTC' => 0.005,
                        'ETH' => 0.01,
                        'ETC' => 0.01,
                        'BTS' => 3,
                        'EOS' => 1,
                        'QTUM' => 0.01,
                        'HSR' => 0.001,
                        'XRP' => 0.1,
                        'USDT' => '0.1%',
                        'QCASH' => 5,
                        'DASH' => 0.002,
                        'BCD' => 0,
                        'UBTC' => 0,
                        'SBTC' => 0,
                        'INK' => 20,
                        'TV' => 0.1,
                        'BTH' => 0,
                        'BCX' => 0,
                        'LBTC' => 0,
                        'CHAT' => 20,
                        'bitCNY' => 20,
                        'HLC' => 20,
                        'BTP' => 0,
                        'BCW' => 0,
                    ),
                ),
                'trading' => array (
                    'maker' => 0.2 / 100,
                    'taker' => 0.2 / 100,
                ),
            ),
        ));
    }

    public function fetch_markets () {
        $markets = $this->publicGetMarkets ();
        $keys = is_array ($markets) ? array_keys ($markets) : array ();
        $result = array ();
        for ($i = 0; $i < count ($keys); $i++) {
            $id = $keys[$i];
            $market = $markets[$id];
            list ($baseId, $quoteId) = explode ('_', $id);
            $base = $this->common_currency_code(strtoupper ($baseId));
            $quote = $this->common_currency_code(strtoupper ($quoteId));
            $symbol = $base . '/' . $quote;
            $precision = array (
                'amount' => $market['amountScale'],
                'price' => $market['priceScale'],
            );
            $lot = pow (10, -$precision['amount']);
            $result[] = array (
                'id' => $id,
                'symbol' => $symbol,
                'baseId' => $baseId,
                'quoteId' => $quoteId,
                'base' => $base,
                'quote' => $quote,
                'lot' => $lot,
                'active' => true,
                'precision' => $precision,
                'limits' => array (
                    'amount' => array (
                        'min' => $lot,
                        'max' => null,
                    ),
                    'price' => array (
                        'min' => pow (10, -$precision['price']),
                        'max' => null,
                    ),
                    'cost' => array (
                        'min' => 0,
                        'max' => null,
                    ),
                ),
                'info' => $market,
            );
        }
        return $result;
    }

    public function fetch_balance ($params = array ()) {
        $this->load_markets();
        $response = $this->privatePostGetAccountInfo ();
        $balances = $response['result']['coins'];
        $result = array ( 'info' => $balances );
        for ($i = 0; $i < count ($balances); $i++) {
            $balance = $balances[$i];
            $currency = $balance['key'];
            if (is_array ($this->currencies) && array_key_exists ($currency, $this->currencies))
                $currency = $this->currencies[$currency]['code'];
            $account = $this->account ();
            $account['free'] = floatval ($balance['available']);
            $account['used'] = floatval ($balance['freez']);
            $account['total'] = $this->sum ($account['free'], $account['used']);
            $result[$currency] = $account;
        }
        return $this->parse_balance($result);
    }

    public function get_market_field_name () {
        return 'market';
    }

    public function fetch_order_book ($symbol, $limit = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market ($symbol);
        $marketFieldName = $this->get_market_field_name ();
        $request = array ();
        $request[$marketFieldName] = $market['id'];
        $orderbook = $this->publicGetDepth (array_merge ($request, $params));
        $timestamp = $this->milliseconds ();
        $bids = null;
        $asks = null;
        if (is_array ($orderbook) && array_key_exists ('bids', $orderbook))
            $bids = $orderbook['bids'];
        if (is_array ($orderbook) && array_key_exists ('asks', $orderbook))
            $asks = $orderbook['asks'];
        $result = array (
            'bids' => $bids,
            'asks' => $asks,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601 ($timestamp),
        );
        if ($result['bids'])
            $result['bids'] = $this->sort_by($result['bids'], 0, true);
        if ($result['asks'])
            $result['asks'] = $this->sort_by($result['asks'], 0);
        return $result;
    }

    public function fetch_ticker ($symbol, $params = array ()) {
        $this->load_markets();
        $market = $this->market ($symbol);
        $marketFieldName = $this->get_market_field_name ();
        $request = array ();
        $request[$marketFieldName] = $market['id'];
        $response = $this->publicGetTicker (array_merge ($request, $params));
        $ticker = $response['ticker'];
        $timestamp = $this->milliseconds ();
        return array (
            'symbol' => $symbol,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601 ($timestamp),
            'high' => floatval ($ticker['high']),
            'low' => floatval ($ticker['low']),
            'bid' => floatval ($ticker['buy']),
            'ask' => floatval ($ticker['sell']),
            'vwap' => null,
            'open' => null,
            'close' => null,
            'first' => null,
            'last' => floatval ($ticker['last']),
            'change' => null,
            'percentage' => null,
            'average' => null,
            'baseVolume' => floatval ($ticker['vol']),
            'quoteVolume' => null,
            'info' => $ticker,
        );
    }

    public function fetch_ohlcv ($symbol, $timeframe = '1m', $since = null, $limit = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market ($symbol);
        if ($limit === null)
            $limit = 1000;
        $request = array (
            'market' => $market['id'],
            'type' => $this->timeframes[$timeframe],
            'limit' => $limit,
        );
        if ($since !== null)
            $request['since'] = $since;
        $response = $this->publicGetKline (array_merge ($request, $params));
        return $this->parse_ohlcvs($response['data'], $market, $timeframe, $since, $limit);
    }

    public function parse_trade ($trade, $market = null) {
        $timestamp = $trade['date'] * 1000;
        $side = ($trade['trade_type'] === 'bid') ? 'buy' : 'sell';
        return array (
            'info' => $trade,
            'id' => (string) $trade['tid'],
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601 ($timestamp),
            'symbol' => $market['symbol'],
            'type' => null,
            'side' => $side,
            'price' => floatval ($trade['price']),
            'amount' => floatval ($trade['amount']),
        );
    }

    public function fetch_trades ($symbol, $since = null, $limit = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market ($symbol);
        $marketFieldName = $this->get_market_field_name ();
        $request = array ();
        $request[$marketFieldName] = $market['id'];
        $response = $this->publicGetTrades (array_merge ($request, $params));
        return $this->parse_trades($response, $market, $since, $limit);
    }

    public function create_order ($symbol, $type, $side, $amount, $price = null, $params = array ()) {
        $this->load_markets();
        $paramString = '&$price=' . (string) $price;
        $paramString .= '&$amount=' . (string) $amount;
        $tradeType = ($side === 'buy') ? '1' : '0';
        $paramString .= '&$tradeType=' . $tradeType;
        $paramString .= '&currency=' . $this->market_id($symbol);
        $response = $this->privatePostOrder ($paramString);
        return array (
            'info' => $response,
            'id' => $response['id'],
        );
    }

    public function cancel_order ($id, $symbol = null, $params = array ()) {
        $this->load_markets();
        $paramString = '&$id=' . (string) $id;
        if (is_array ($params) && array_key_exists ('currency', $params))
            $paramString .= '&currency=' . $params['currency'];
        return $this->privatePostCancelOrder ($paramString);
    }

    public function fetch_order ($id, $symbol = null, $params = array ()) {
        $this->load_markets();
        $paramString = '&$id=' . (string) $id;
        if (is_array ($params) && array_key_exists ('currency', $params))
            $paramString .= '&currency=' . $params['currency'];
        return $this->privatePostGetOrder ($paramString);
    }

    public function nonce () {
        return $this->milliseconds ();
    }

    public function sign ($path, $api = 'public', $method = 'GET', $params = array (), $headers = null, $body = null) {
        $url = $this->urls['api'][$api];
        if ($api === 'public') {
            $url .= '/' . $this->version . '/' . $path;
            if ($params)
                $url .= '?' . $this->urlencode ($params);
        } else {
            $this->check_required_credentials();
            $nonce = $this->nonce ();
            $auth = 'accesskey=' . $this->apiKey;
            $auth .= '&' . 'method=' . $path;
            $secret = $this->hash ($this->encode ($this->secret), 'sha1');
            $signature = $this->hmac ($this->encode ($auth), $this->encode ($secret), 'md5');
            $suffix = 'sign=' . $signature . '&reqTime=' . (string) $nonce;
            $url .= '/' . $path . '?' . $auth . '&' . $suffix;
        }
        return array ( 'url' => $url, 'method' => $method, 'body' => $body, 'headers' => $headers );
    }

    public function handle_errors ($httpCode, $reason, $url, $method, $headers, $body) {
        if (gettype ($body) != 'string')
            return; // fallback to default error handler
        if (strlen ($body) < 2)
            return; // fallback to default error handler
        if (($body[0] === '{') || ($body[0] === '[')) {
            $response = json_decode ($body, $as_associative_array = true);
            // array ("result":false,"message":)
            if (is_array ($response) && array_key_exists ('result', $response)) {
                $success = $this->safe_value($response, 'result', false);
                if (gettype ($success) == 'string') {
                    if (($success === 'true') || ($success === '1'))
                        $success = true;
                    else
                        $success = false;
                }
                if (!$success)
                    throw new ExchangeError ($this->id . ' ' . $this->json ($response));
            }
        }
    }

    public function request ($path, $api = 'public', $method = 'GET', $params = array (), $headers = null, $body = null) {
        $response = $this->fetch2 ($path, $api, $method, $params, $headers, $body);
        if ($api === 'private')
            if (is_array ($response) && array_key_exists ('code', $response))
                throw new ExchangeError ($this->id . ' ' . $this->json ($response));
        return $response;
    }
}
