# Exchanges By Country

The ccxt library currently supports the following cryptocurrency exchange markets and trading APIs:

|country / region         | logo                                                                                                                         | id                 | name                                                      | ver | doc                                                                                           |
|-------------------------|------------------------------------------------------------------------------------------------------------------------------|--------------------|-----------------------------------------------------------|:---:|:---------------------------------------------------------------------------------------------:|
|Argentina                |  ![southxchange](https://user-images.githubusercontent.com/1294454/27838912-4f94ec8a-60f6-11e7-9e5d-bbf9bd50a559.jpg)        | southxchange       | [SouthXchange](https://www.southxchange.com)              | *   |  [API](https://www.southxchange.com/Home/Api)                                                 |
|Australia                |  ![acx](https://user-images.githubusercontent.com/1294454/30247614-1fe61c74-9621-11e7-9e8c-f1a627afa279.jpg)                 | acx                | [ACX](https://acx.io)                                     | 2   |  [API](https://acx.io/documents/api_v2)                                                       |
|Australia                |  ![btcmarkets](https://user-images.githubusercontent.com/1294454/29142911-0e1acfc2-7d5c-11e7-98c4-07d9532b29d7.jpg)          | btcmarkets         | [BTC Markets](https://btcmarkets.net/)                    | *   |  [API](https://github.com/BTCMarkets/API)                                                     |
|Australia                |  ![coinspot](https://user-images.githubusercontent.com/1294454/28208429-3cacdf9a-6896-11e7-854e-4c79a772a30f.jpg)            | coinspot           | [CoinSpot](https://www.coinspot.com.au)                   | *   |  [API](https://www.coinspot.com.au/api)                                                       |
|Australia                |  ![independentreserve](https://user-images.githubusercontent.com/1294454/30521662-cf3f477c-9bcb-11e7-89bc-d1ac85012eda.jpg)  | independentreserve | [Independent Reserve](https://www.independentreserve.com) | *   |  [API](https://www.independentreserve.com/API)                                                |
|Austria                  |  ![virwox](https://user-images.githubusercontent.com/1294454/27766894-6da9d360-5eea-11e7-90aa-41f2711b7405.jpg)              | virwox             | [VirWoX](https://www.virwox.com)                          | *   |  [API](https://www.virwox.com/developers.php)                                                 |
|Brazil                   |  ![bleutrade](https://user-images.githubusercontent.com/1294454/30303000-b602dbe6-976d-11e7-956d-36c5049c01e7.jpg)           | bleutrade          | [Bleutrade](https://bleutrade.com)                        | 2   |  [API](https://bleutrade.com/help/API)                                                        |
|Brazil                   |  ![braziliex](https://user-images.githubusercontent.com/1294454/34703593-c4498674-f504-11e7-8d14-ff8e44fb78c1.jpg)           | braziliex          | [Braziliex](https://braziliex.com/)                       | *   |  [API](https://braziliex.com/exchange/api.php)                                                |
|Brazil                   |  ![flowbtc](https://user-images.githubusercontent.com/1294454/28162465-cd815d4c-67cf-11e7-8e57-438bea0523a2.jpg)             | flowbtc            | [flowBTC](https://trader.flowbtc.com)                     | 1   |  [API](http://www.flowbtc.com.br/api/)                                                        |
|Brazil                   |  ![foxbit](https://user-images.githubusercontent.com/1294454/27991413-11b40d42-647f-11e7-91ee-78ced874dd09.jpg)              | foxbit             | [FoxBit](https://foxbit.exchange)                         | 1   |  [API](https://blinktrade.com/docs)                                                           |
|Brazil                   |  ![mercado](https://user-images.githubusercontent.com/1294454/27837060-e7c58714-60ea-11e7-9192-f05e86adb83f.jpg)             | mercado            | [Mercado Bitcoin](https://www.mercadobitcoin.com.br)      | 3   |  [API](https://www.mercadobitcoin.com.br/api-doc)                                             |
|British Virgin Islands   |  ![bitfinex](https://user-images.githubusercontent.com/1294454/27766244-e328a50c-5ed2-11e7-947b-041416579bb3.jpg)            | bitfinex           | [Bitfinex](https://www.bitfinex.com)                      | 1   |  [API](https://bitfinex.readme.io/v1/docs)                                                    |
|British Virgin Islands   |  ![bitfinex2](https://user-images.githubusercontent.com/1294454/27766244-e328a50c-5ed2-11e7-947b-041416579bb3.jpg)           | bitfinex2          | [Bitfinex v2](https://www.bitfinex.com)                   | 2   |  [API](https://bitfinex.readme.io/v2/docs)                                                    |
|Bulgaria                 |  ![coingi](https://user-images.githubusercontent.com/1294454/28619707-5c9232a8-7212-11e7-86d6-98fe5d15cc6e.jpg)              | coingi             | [Coingi](https://coingi.com)                              | *   |  [API](http://docs.coingi.apiary.io/)                                                         |
|Canada                   |  ![allcoin](https://user-images.githubusercontent.com/1294454/31561809-c316b37c-b061-11e7-8d5a-b547b4d730eb.jpg)             | allcoin            | [Allcoin](https://www.allcoin.com)                        | 1   |  [API](https://www.allcoin.com/About/APIReference)                                            |
|Canada                   |  ![quadrigacx](https://user-images.githubusercontent.com/1294454/27766825-98a6d0de-5ee7-11e7-9fa4-38e11a2c6f52.jpg)          | quadrigacx         | [QuadrigaCX](https://www.quadrigacx.com)                  | 2   |  [API](https://www.quadrigacx.com/api_info)                                                   |
|Chile                    |  ![chilebit](https://user-images.githubusercontent.com/1294454/27991414-1298f0d8-647f-11e7-9c40-d56409266336.jpg)            | chilebit           | [ChileBit](https://chilebit.net)                          | 1   |  [API](https://blinktrade.com/docs)                                                           |
|China                    |  ![bibox](https://user-images.githubusercontent.com/1294454/34902611-2be8bf1a-f830-11e7-91a2-11b2f292e750.jpg)               | bibox              | [Bibox](https://www.bibox.com)                            | 1   |  [API](https://github.com/Biboxcom/api_reference/wiki/home_en)                                |
|China                    |  ![btcchina](https://user-images.githubusercontent.com/1294454/27766368-465b3286-5ed6-11e7-9a11-0f6467e1d82b.jpg)            | btcchina           | [BTCChina](https://www.btcchina.com)                      | 1   |  [API](https://www.btcchina.com/apidocs)                                                      |
|China                    |  ![chbtc](https://user-images.githubusercontent.com/1294454/28555659-f0040dc2-7109-11e7-9d99-688a438bf9f4.jpg)               | chbtc              | [CHBTC](https://trade.chbtc.com/api)                      | 1   |  [API](https://www.chbtc.com/i/developer)                                                     |
|China                    |  ![coingi](https://user-images.githubusercontent.com/1294454/28619707-5c9232a8-7212-11e7-86d6-98fe5d15cc6e.jpg)              | coingi             | [Coingi](https://coingi.com)                              | *   |  [API](http://docs.coingi.apiary.io/)                                                         |
|China                    |  ![gateio](https://user-images.githubusercontent.com/1294454/31784029-0313c702-b509-11e7-9ccc-bc0da6a0e435.jpg)              | gateio             | [Gate.io](https://gate.io/)                               | 2   |  [API](https://gate.io/api2)                                                                  |
|China                    |  ![huobi](https://user-images.githubusercontent.com/1294454/27766569-15aa7b9a-5edd-11e7-9e7f-44791f4ee49c.jpg)               | huobi              | [Huobi](https://www.huobi.com)                            | 3   |  [API](https://github.com/huobiapi/API_Docs_en/wiki)                                          |
|China                    |  ![huobicny](https://user-images.githubusercontent.com/1294454/27766569-15aa7b9a-5edd-11e7-9e7f-44791f4ee49c.jpg)            | huobicny           | [Huobi CNY](https://www.huobi.com)                        | 1   |  [API](https://github.com/huobiapi/API_Docs/wiki/REST_api_reference)                          |
|China                    |  ![huobipro](https://user-images.githubusercontent.com/1294454/27766569-15aa7b9a-5edd-11e7-9e7f-44791f4ee49c.jpg)            | huobipro           | [Huobi Pro](https://www.huobi.pro)                        | 1   |  [API](https://github.com/huobiapi/API_Docs/wiki/REST_api_reference)                          |
|China                    |  ![jubi](https://user-images.githubusercontent.com/1294454/27766581-9d397d9a-5edd-11e7-8fb9-5d8236c0e692.jpg)                | jubi               | [jubi.com](https://www.jubi.com)                          | 1   |  [API](https://www.jubi.com/help/api.html)                                                    |
|China                    |  ![okcoincny](https://user-images.githubusercontent.com/1294454/27766792-8be9157a-5ee5-11e7-926c-6d69b8d3378d.jpg)           | okcoincny          | [OKCoin CNY](https://www.okcoin.cn)                       | 1   |  [API](https://www.okcoin.cn/rest_getStarted.html)                                            |
|China                    |  ![okcoinusd](https://user-images.githubusercontent.com/1294454/27766791-89ffb502-5ee5-11e7-8a5b-c5950b68ac65.jpg)           | okcoinusd          | [OKCoin USD](https://www.okcoin.com)                      | 1   |  [API](https://www.okcoin.com/rest_getStarted.html)                                           |
|China                    |  ![okex](https://user-images.githubusercontent.com/1294454/32552768-0d6dd3c6-c4a6-11e7-90f8-c043b64756a7.jpg)                | okex               | [OKEX](https://www.okex.com)                              | 1   |  [API](https://www.okex.com/rest_getStarted.html)                                             |
|China                    |  ![qryptos](https://user-images.githubusercontent.com/1294454/30953915-b1611dc0-a436-11e7-8947-c95bd5a42086.jpg)             | qryptos            | [QRYPTOS](https://www.qryptos.com)                        | 2   |  [API](https://developers.quoine.com)                                                         |
|China                    |  ![yunbi](https://user-images.githubusercontent.com/1294454/28570548-4d646c40-7147-11e7-9cf6-839b93e6d622.jpg)               | yunbi              | [YUNBI](https://yunbi.com)                                | 2   |  [API](https://yunbi.com/documents/api/guide)                                                 |
|China                    |  ![zb](https://user-images.githubusercontent.com/1294454/32859187-cd5214f0-ca5e-11e7-967d-96568e2e2bd1.jpg)                  | zb                 | [ZB](https://trade.zb.com/api)                            | 1   |  [API](https://www.zb.com/i/developer)                                                        |
|Cyprus                   |  ![cex](https://user-images.githubusercontent.com/1294454/27766442-8ddc33b0-5ed8-11e7-8b98-f786aef0f3c9.jpg)                 | cex                | [CEX.IO](https://cex.io)                                  | *   |  [API](https://cex.io/cex-api)                                                                |
|Czech Republic           |  ![coinmate](https://user-images.githubusercontent.com/1294454/27811229-c1efb510-606c-11e7-9a36-84ba2ce412d8.jpg)            | coinmate           | [CoinMate](https://coinmate.io)                           | *   |  [API](http://docs.coinmate.apiary.io)                                                        |
|EU                       |  ![bitbay](https://user-images.githubusercontent.com/1294454/27766132-978a7bd8-5ece-11e7-9540-bc96d1e9bbb8.jpg)              | bitbay             | [BitBay](https://bitbay.net)                              | *   |  [API](https://bitbay.net/public-api)                                                         |
|EU                       |  ![bitlish](https://user-images.githubusercontent.com/1294454/27766275-dcfc6c30-5ed3-11e7-839d-00a846385d0b.jpg)             | bitlish            | [Bitlish](https://bitlish.com)                            | 1   |  [API](https://bitlish.com/api)                                                               |
|EU                       |  ![bitmarket](https://user-images.githubusercontent.com/1294454/27767256-a8555200-5ef9-11e7-96fd-469a65e2b0bd.jpg)           | bitmarket          | [BitMarket](https://www.bitmarket.pl)                     | *   |  [API](https://www.bitmarket.net/docs.php?file=api_public.html)                               |
|EU                       |  ![bl3p](https://user-images.githubusercontent.com/1294454/28501752-60c21b82-6feb-11e7-818b-055ee6d0e754.jpg)                | bl3p               | [BL3P](https://bl3p.eu)                                   | 1   |  [API](https://github.com/BitonicNL/bl3p-api/tree/master/docs)                                |
|EU                       |  ![btcx](https://user-images.githubusercontent.com/1294454/27766385-9fdcc98c-5ed6-11e7-8f14-66d5e5cd47e6.jpg)                | btcx               | [BTCX](https://btc-x.is)                                  | 1   |  [API](https://btc-x.is/custom/api-document.html)                                             |
|EU                       |  ![ccex](https://user-images.githubusercontent.com/1294454/27766433-16881f90-5ed8-11e7-92f8-3d92cc747a6c.jpg)                | ccex               | [C-CEX](https://c-cex.com)                                | *   |  [API](https://c-cex.com/?id=api)                                                             |
|EU                       |  ![cex](https://user-images.githubusercontent.com/1294454/27766442-8ddc33b0-5ed8-11e7-8b98-f786aef0f3c9.jpg)                 | cex                | [CEX.IO](https://cex.io)                                  | *   |  [API](https://cex.io/cex-api)                                                                |
|EU                       |  ![coinmate](https://user-images.githubusercontent.com/1294454/27811229-c1efb510-606c-11e7-9a36-84ba2ce412d8.jpg)            | coinmate           | [CoinMate](https://coinmate.io)                           | *   |  [API](http://docs.coinmate.apiary.io)                                                        |
|EU                       |  ![paymium](https://user-images.githubusercontent.com/1294454/27790564-a945a9d4-5ff9-11e7-9d2d-b635763f2f24.jpg)             | paymium            | [Paymium](https://www.paymium.com)                        | 1   |  [API](https://github.com/Paymium/api-documentation)                                          |
|EU                       |  ![virwox](https://user-images.githubusercontent.com/1294454/27766894-6da9d360-5eea-11e7-90aa-41f2711b7405.jpg)              | virwox             | [VirWoX](https://www.virwox.com)                          | *   |  [API](https://www.virwox.com/developers.php)                                                 |
|France                   |  ![paymium](https://user-images.githubusercontent.com/1294454/27790564-a945a9d4-5ff9-11e7-9d2d-b635763f2f24.jpg)             | paymium            | [Paymium](https://www.paymium.com)                        | 1   |  [API](https://github.com/Paymium/api-documentation)                                          |
|Germany                  |  ![ccex](https://user-images.githubusercontent.com/1294454/27766433-16881f90-5ed8-11e7-92f8-3d92cc747a6c.jpg)                | ccex               | [C-CEX](https://c-cex.com)                                | *   |  [API](https://c-cex.com/?id=api)                                                             |
|Hong Kong                |  ![anxpro](https://user-images.githubusercontent.com/1294454/27765983-fd8595da-5ec9-11e7-82e3-adb3ab8c2612.jpg)              | anxpro             | [ANXPro](https://anxpro.com)                              | 2   |  [API](http://docs.anxv2.apiary.io)                                                           |
|Hong Kong                |  ![bitz](https://user-images.githubusercontent.com/1294454/35862606-4f554f14-0b5d-11e8-957d-35058c504b6f.jpg)                | bitz               | [Bit-Z](https://www.bit-z.com/)                           | *   |  [API](https://www.bit-z.com/api.html)                                                        |
|Hong Kong                |  ![gatecoin](https://user-images.githubusercontent.com/1294454/28646817-508457f2-726c-11e7-9eeb-3528d2413a58.jpg)            | gatecoin           | [Gatecoin](https://gatecoin.com)                          | *   |  [API](https://gatecoin.com/api)                                                              |
|Hong Kong                |  ![kucoin](https://user-images.githubusercontent.com/1294454/33795655-b3c46e48-dcf6-11e7-8abe-dc4588ba7901.jpg)              | kucoin             | [Kucoin](https://kucoin.com)                              | 1   |  [API](https://kucoinapidocs.docs.apiary.io)                                                  |
|Hong Kong                |  ![mixcoins](https://user-images.githubusercontent.com/1294454/30237212-ed29303c-9535-11e7-8af8-fcd381cfa20c.jpg)            | mixcoins           | [MixCoins](https://mixcoins.com)                          | 1   |  [API](https://mixcoins.com/help/api/)                                                        |
|Iceland                  |  ![btcx](https://user-images.githubusercontent.com/1294454/27766385-9fdcc98c-5ed6-11e7-8f14-66d5e5cd47e6.jpg)                | btcx               | [BTCX](https://btc-x.is)                                  | 1   |  [API](https://btc-x.is/custom/api-document.html)                                             |
|India                    |  ![coinexchange](https://user-images.githubusercontent.com/1294454/34842303-29c99fca-f71c-11e7-83c1-09d900cb2334.jpg)        | coinexchange       | [CoinExchange](https://www.coinexchange.io)               | *   |  [API](https://coinexchangeio.github.io/slate/)                                               |
|India                    |  ![coinsecure](https://user-images.githubusercontent.com/1294454/27766472-9cbd200a-5ed9-11e7-9551-2267ad7bac08.jpg)          | coinsecure         | [Coinsecure](https://coinsecure.in)                       | 1   |  [API](https://api.coinsecure.in)                                                             |
|Indonesia                |  ![bitcoincoid](https://user-images.githubusercontent.com/1294454/27766138-043c7786-5ecf-11e7-882b-809c14f38b53.jpg)         | bitcoincoid        | [Bitcoin.co.id](https://www.bitcoin.co.id)                | 1.7 |  [API](https://vip.bitcoin.co.id/downloads/BITCOINCOID-API-DOCUMENTATION.pdf)                 |
|Indonesia                |  ![coincheck](https://user-images.githubusercontent.com/1294454/27766464-3b5c3c74-5ed9-11e7-840e-31b32968e1da.jpg)           | coincheck          | [coincheck](https://coincheck.com)                        | *   |  [API](https://coincheck.com/documents/exchange/api)                                          |
|Israel                   |  ![bit2c](https://user-images.githubusercontent.com/1294454/27766119-3593220e-5ece-11e7-8b3a-5a041f6bcc3f.jpg)               | bit2c              | [Bit2C](https://www.bit2c.co.il)                          | *   |  [API](https://www.bit2c.co.il/home/api)                                                      |
|Japan                    |  ![anxpro](https://user-images.githubusercontent.com/1294454/27765983-fd8595da-5ec9-11e7-82e3-adb3ab8c2612.jpg)              | anxpro             | [ANXPro](https://anxpro.com)                              | 2   |  [API](http://docs.anxv2.apiary.io)                                                           |
|Japan                    |  ![binance](https://user-images.githubusercontent.com/1294454/29604020-d5483cdc-87ee-11e7-94c7-d1a8d9169293.jpg)             | binance            | [Binance](https://www.binance.com)                        | *   |  [API](https://github.com/binance-exchange/binance-official-api-docs/blob/master/rest-api.md) |
|Japan                    |  ![bitflyer](https://user-images.githubusercontent.com/1294454/28051642-56154182-660e-11e7-9b0d-6042d1e6edd8.jpg)            | bitflyer           | [bitFlyer](https://bitflyer.jp)                           | 1   |  [API](https://bitflyer.jp/API)                                                               |
|Japan                    |  ![btcbox](https://user-images.githubusercontent.com/1294454/31275803-4df755a8-aaa1-11e7-9abb-11ec2fad9f2d.jpg)              | btcbox             | [BtcBox](https://www.btcbox.co.jp/)                       | 1   |  [API](https://www.btcbox.co.jp/help/asm)                                                     |
|Japan                    |  ![coincheck](https://user-images.githubusercontent.com/1294454/27766464-3b5c3c74-5ed9-11e7-840e-31b32968e1da.jpg)           | coincheck          | [coincheck](https://coincheck.com)                        | *   |  [API](https://coincheck.com/documents/exchange/api)                                          |
|Japan                    |  ![coinexchange](https://user-images.githubusercontent.com/1294454/34842303-29c99fca-f71c-11e7-83c1-09d900cb2334.jpg)        | coinexchange       | [CoinExchange](https://www.coinexchange.io)               | *   |  [API](https://coinexchangeio.github.io/slate/)                                               |
|Japan                    |  ![quoinex](https://user-images.githubusercontent.com/1294454/35047114-0e24ad4a-fbaa-11e7-96a9-69c1a756083b.jpg)             | quoinex            | [QUOINEX](https://quoinex.com/)                           | 2   |  [API](https://developers.quoine.com)                                                         |
|Japan                    |  ![zaif](https://user-images.githubusercontent.com/1294454/27766927-39ca2ada-5eeb-11e7-972f-1b4199518ca6.jpg)                | zaif               | [Zaif](https://zaif.jp)                                   | 1   |  [API](http://techbureau-api-document.readthedocs.io/ja/latest/index.html)                    |
|Malta                    |  ![therock](https://user-images.githubusercontent.com/1294454/27766869-75057fa2-5ee9-11e7-9a6f-13e641fa4707.jpg)             | therock            | [TheRockTrading](https://therocktrading.com)              | 1   |  [API](https://api.therocktrading.com/doc/v1/index.html)                                      |
|Mexico                   |  ![bitso](https://user-images.githubusercontent.com/1294454/27766335-715ce7aa-5ed5-11e7-88a8-173a27bb30fe.jpg)               | bitso              | [Bitso](https://bitso.com)                                | 3   |  [API](https://bitso.com/api_info)                                                            |
|Netherlands              |  ![bl3p](https://user-images.githubusercontent.com/1294454/28501752-60c21b82-6feb-11e7-818b-055ee6d0e754.jpg)                | bl3p               | [BL3P](https://bl3p.eu)                                   | 1   |  [API](https://github.com/BitonicNL/bl3p-api/tree/master/docs)                                |
|New Zealand              |  ![anxpro](https://user-images.githubusercontent.com/1294454/27765983-fd8595da-5ec9-11e7-82e3-adb3ab8c2612.jpg)              | anxpro             | [ANXPro](https://anxpro.com)                              | 2   |  [API](http://docs.anxv2.apiary.io)                                                           |
|New Zealand              |  ![cryptopia](https://user-images.githubusercontent.com/1294454/29484394-7b4ea6e2-84c6-11e7-83e5-1fccf4b2dc81.jpg)           | cryptopia          | [Cryptopia](https://www.cryptopia.co.nz)                  | *   |  [API](https://www.cryptopia.co.nz/Forum/Category/45)                                         |
|New Zealand              |  ![independentreserve](https://user-images.githubusercontent.com/1294454/30521662-cf3f477c-9bcb-11e7-89bc-d1ac85012eda.jpg)  | independentreserve | [Independent Reserve](https://www.independentreserve.com) | *   |  [API](https://www.independentreserve.com/API)                                                |
|New Zealand              |  ![wex](https://user-images.githubusercontent.com/1294454/30652751-d74ec8f8-9e31-11e7-98c5-71469fcef03e.jpg)                 | wex                | [WEX](https://wex.nz)                                     | 3   |  [API](https://wex.nz/api/3/docs)                                                             |
|Pakistan                 |  ![urdubit](https://user-images.githubusercontent.com/1294454/27991453-156bf3ae-6480-11e7-82eb-7295fe1b5bb4.jpg)             | urdubit            | [UrduBit](https://urdubit.com)                            | 1   |  [API](https://blinktrade.com/docs)                                                           |
|Panama                   |  ![_1btcxe](https://user-images.githubusercontent.com/1294454/27766049-2b294408-5ecc-11e7-85cc-adaff013dc1a.jpg)             | _1btcxe            | [1BTCXE](https://1btcxe.com)                              | *   |  [API](https://1btcxe.com/api-docs.php)                                                       |
|Panama                   |  ![coingi](https://user-images.githubusercontent.com/1294454/28619707-5c9232a8-7212-11e7-86d6-98fe5d15cc6e.jpg)              | coingi             | [Coingi](https://coingi.com)                              | *   |  [API](http://docs.coingi.apiary.io/)                                                         |
|Philippines              |  ![btcexchange](https://user-images.githubusercontent.com/1294454/27993052-4c92911a-64aa-11e7-96d8-ec6ac3435757.jpg)         | btcexchange        | [BTCExchange](https://www.btcexchange.ph)                 | *   |  [API](https://github.com/BTCTrader/broker-api-docs)                                          |
|Poland                   |  ![bitbay](https://user-images.githubusercontent.com/1294454/27766132-978a7bd8-5ece-11e7-9540-bc96d1e9bbb8.jpg)              | bitbay             | [BitBay](https://bitbay.net)                              | *   |  [API](https://bitbay.net/public-api)                                                         |
|Poland                   |  ![bitmarket](https://user-images.githubusercontent.com/1294454/27767256-a8555200-5ef9-11e7-96fd-469a65e2b0bd.jpg)           | bitmarket          | [BitMarket](https://www.bitmarket.pl)                     | *   |  [API](https://www.bitmarket.net/docs.php?file=api_public.html)                               |
|Russia                   |  ![bitlish](https://user-images.githubusercontent.com/1294454/27766275-dcfc6c30-5ed3-11e7-839d-00a846385d0b.jpg)             | bitlish            | [Bitlish](https://bitlish.com)                            | 1   |  [API](https://bitlish.com/api)                                                               |
|Russia                   |  ![cex](https://user-images.githubusercontent.com/1294454/27766442-8ddc33b0-5ed8-11e7-8b98-f786aef0f3c9.jpg)                 | cex                | [CEX.IO](https://cex.io)                                  | *   |  [API](https://cex.io/cex-api)                                                                |
|Russia                   |  ![exmo](https://user-images.githubusercontent.com/1294454/27766491-1b0ea956-5eda-11e7-9225-40d67b481b8d.jpg)                | exmo               | [EXMO](https://exmo.me)                                   | 1   |  [API](https://exmo.me/en/api_doc)                                                            |
|Russia                   |  ![getbtc](https://user-images.githubusercontent.com/1294454/33801902-03c43462-dd7b-11e7-992e-077e4cd015b9.jpg)              | getbtc             | [GetBTC](https://getbtc.org)                              | *   |  [API](https://getbtc.org/api-docs.php)                                                       |
|Russia                   |  ![livecoin](https://user-images.githubusercontent.com/1294454/27980768-f22fc424-638a-11e7-89c9-6010a54ff9be.jpg)            | livecoin           | [LiveCoin](https://www.livecoin.net)                      | *   |  [API](https://www.livecoin.net/api?lang=en)                                                  |
|Russia                   |  ![xbtce](https://user-images.githubusercontent.com/1294454/28059414-e235970c-662c-11e7-8c3a-08e31f78684b.jpg)               | xbtce              | [xBTCe](https://www.xbtce.com)                            | 1   |  [API](https://www.xbtce.com/tradeapi)                                                        |
|Russia                   |  ![yobit](https://user-images.githubusercontent.com/1294454/27766910-cdcbfdae-5eea-11e7-9859-03fea873272d.jpg)               | yobit              | [YoBit](https://www.yobit.net)                            | 3   |  [API](https://www.yobit.net/en/api/)                                                         |
|Seychelles               |  ![bitmex](https://user-images.githubusercontent.com/1294454/27766319-f653c6e6-5ed4-11e7-933d-f0bc3699ae8f.jpg)              | bitmex             | [BitMEX](https://www.bitmex.com)                          | 1   |  [API](https://www.bitmex.com/app/apiOverview)                                                |
|Singapore                |  ![anxpro](https://user-images.githubusercontent.com/1294454/27765983-fd8595da-5ec9-11e7-82e3-adb3ab8c2612.jpg)              | anxpro             | [ANXPro](https://anxpro.com)                              | 2   |  [API](http://docs.anxv2.apiary.io)                                                           |
|Singapore                |  ![fybsg](https://user-images.githubusercontent.com/1294454/27766513-3364d56a-5edb-11e7-9e6b-d5898bb89c81.jpg)               | fybsg              | [FYB-SG](https://www.fybsg.com)                           | *   |  [API](http://docs.fyb.apiary.io)                                                             |
|Singapore                |  ![luno](https://user-images.githubusercontent.com/1294454/27766607-8c1a69d8-5ede-11e7-930c-540b5eb9be24.jpg)                | luno               | [luno](https://www.luno.com)                              | 1   |  [API](https://www.luno.com/en/api)                                                           |
|Singapore                |  ![quoinex](https://user-images.githubusercontent.com/1294454/35047114-0e24ad4a-fbaa-11e7-96a9-69c1a756083b.jpg)             | quoinex            | [QUOINEX](https://quoinex.com/)                           | 2   |  [API](https://developers.quoine.com)                                                         |
|South Africa             |  ![luno](https://user-images.githubusercontent.com/1294454/27766607-8c1a69d8-5ede-11e7-930c-540b5eb9be24.jpg)                | luno               | [luno](https://www.luno.com)                              | 1   |  [API](https://www.luno.com/en/api)                                                           |
|South Korea              |  ![bibox](https://user-images.githubusercontent.com/1294454/34902611-2be8bf1a-f830-11e7-91a2-11b2f292e750.jpg)               | bibox              | [Bibox](https://www.bibox.com)                            | 1   |  [API](https://github.com/Biboxcom/api_reference/wiki/home_en)                                |
|South Korea              |  ![bithumb](https://user-images.githubusercontent.com/1294454/30597177-ea800172-9d5e-11e7-804c-b9d4fa9b56b0.jpg)             | bithumb            | [Bithumb](https://www.bithumb.com)                        | *   |  [API](https://www.bithumb.com/u1/US127)                                                      |
|South Korea              |  ![coinexchange](https://user-images.githubusercontent.com/1294454/34842303-29c99fca-f71c-11e7-83c1-09d900cb2334.jpg)        | coinexchange       | [CoinExchange](https://www.coinexchange.io)               | *   |  [API](https://coinexchangeio.github.io/slate/)                                               |
|Spain                    |  ![exmo](https://user-images.githubusercontent.com/1294454/27766491-1b0ea956-5eda-11e7-9225-40d67b481b8d.jpg)                | exmo               | [EXMO](https://exmo.me)                                   | 1   |  [API](https://exmo.me/en/api_doc)                                                            |
|St. Vincent & Grenadines |  ![getbtc](https://user-images.githubusercontent.com/1294454/33801902-03c43462-dd7b-11e7-992e-077e4cd015b9.jpg)              | getbtc             | [GetBTC](https://getbtc.org)                              | *   |  [API](https://getbtc.org/api-docs.php)                                                       |
|Sweden                   |  ![fybse](https://user-images.githubusercontent.com/1294454/27766512-31019772-5edb-11e7-8241-2e675e6797f1.jpg)               | fybse              | [FYB-SE](https://www.fybse.se)                            | *   |  [API](http://docs.fyb.apiary.io)                                                             |
|Switzerland              |  ![lykke](https://user-images.githubusercontent.com/1294454/34487620-3139a7b0-efe6-11e7-90f5-e520cef74451.jpg)               | lykke              | [Lykke](https://www.lykke.com)                            | 1   |  [API](https://hft-api.lykke.com/swagger/ui/)                                                 |
|Switzerland              |  ![vaultoro](https://user-images.githubusercontent.com/1294454/27766880-f205e870-5ee9-11e7-8fe2-0d5b15880752.jpg)            | vaultoro           | [Vaultoro](https://www.vaultoro.com)                      | 1   |  [API](https://api.vaultoro.com)                                                              |
|Taiwan                   |  ![cobinhood](https://user-images.githubusercontent.com/1294454/35755576-dee02e5c-0878-11e8-989f-1595d80ba47f.jpg)           | cobinhood          | [COBINHOOD](https://cobinhood.com)                        | *   |  [API](https://cobinhood.github.io/api-public)                                                |
|Taiwan                   |  ![qryptos](https://user-images.githubusercontent.com/1294454/30953915-b1611dc0-a436-11e7-8947-c95bd5a42086.jpg)             | qryptos            | [QRYPTOS](https://www.qryptos.com)                        | 2   |  [API](https://developers.quoine.com)                                                         |
|Tanzania                 |  ![nova](https://user-images.githubusercontent.com/1294454/30518571-78ca0bca-9b8a-11e7-8840-64b83a4a94b2.jpg)                | nova               | [Novaexchange](https://novaexchange.com)                  | 2   |  [API](https://novaexchange.com/remote/faq)                                                   |
|Thailand                 |  ![bxinth](https://user-images.githubusercontent.com/1294454/27766412-567b1eb4-5ed7-11e7-94a8-ff6a3884f6c5.jpg)              | bxinth             | [BX.in.th](https://bx.in.th)                              | *   |  [API](https://bx.in.th/info/api)                                                             |
|Turkey                   |  ![btcturk](https://user-images.githubusercontent.com/1294454/27992709-18e15646-64a3-11e7-9fa2-b0950ec7712f.jpg)             | btcturk            | [BTCTurk](https://www.btcturk.com)                        | *   |  [API](https://github.com/BTCTrader/broker-api-docs)                                          |
|UK                       |  ![bitlish](https://user-images.githubusercontent.com/1294454/27766275-dcfc6c30-5ed3-11e7-839d-00a846385d0b.jpg)             | bitlish            | [Bitlish](https://bitlish.com)                            | 1   |  [API](https://bitlish.com/api)                                                               |
|UK                       |  ![bitstamp](https://user-images.githubusercontent.com/1294454/27786377-8c8ab57e-5fe9-11e7-8ea4-2b05b6bcceec.jpg)            | bitstamp           | [Bitstamp](https://www.bitstamp.net)                      | 2   |  [API](https://www.bitstamp.net/api)                                                          |
|UK                       |  ![bitstamp1](https://user-images.githubusercontent.com/1294454/27786377-8c8ab57e-5fe9-11e7-8ea4-2b05b6bcceec.jpg)           | bitstamp1          | [Bitstamp v1](https://www.bitstamp.net)                   | 1   |  [API](https://www.bitstamp.net/api)                                                          |
|UK                       |  ![cex](https://user-images.githubusercontent.com/1294454/27766442-8ddc33b0-5ed8-11e7-8b98-f786aef0f3c9.jpg)                 | cex                | [CEX.IO](https://cex.io)                                  | *   |  [API](https://cex.io/cex-api)                                                                |
|UK                       |  ![coinfloor](https://user-images.githubusercontent.com/1294454/28246081-623fc164-6a1c-11e7-913f-bac0d5576c90.jpg)           | coinfloor          | [coinfloor](https://www.coinfloor.co.uk)                  | *   |  [API](https://github.com/coinfloor/api)                                                      |
|UK                       |  ![coinmate](https://user-images.githubusercontent.com/1294454/27811229-c1efb510-606c-11e7-9a36-84ba2ce412d8.jpg)            | coinmate           | [CoinMate](https://coinmate.io)                           | *   |  [API](http://docs.coinmate.apiary.io)                                                        |
|UK                       |  ![dsx](https://user-images.githubusercontent.com/1294454/27990275-1413158a-645a-11e7-931c-94717f7510e3.jpg)                 | dsx                | [DSX](https://dsx.uk)                                     | 3   |  [API](https://api.dsx.uk)                                                                    |
|UK                       |  ![hitbtc](https://user-images.githubusercontent.com/1294454/27766555-8eaec20e-5edc-11e7-9c5b-6dc69fc42f5e.jpg)              | hitbtc             | [HitBTC](https://hitbtc.com)                              | 1   |  [API](https://github.com/hitbtc-com/hitbtc-api/blob/master/APIv1.md)                         |
|UK                       |  ![hitbtc2](https://user-images.githubusercontent.com/1294454/27766555-8eaec20e-5edc-11e7-9c5b-6dc69fc42f5e.jpg)             | hitbtc2            | [HitBTC v2](https://hitbtc.com)                           | 2   |  [API](https://api.hitbtc.com)                                                                |
|UK                       |  ![livecoin](https://user-images.githubusercontent.com/1294454/27980768-f22fc424-638a-11e7-89c9-6010a54ff9be.jpg)            | livecoin           | [LiveCoin](https://www.livecoin.net)                      | *   |  [API](https://www.livecoin.net/api?lang=en)                                                  |
|UK                       |  ![luno](https://user-images.githubusercontent.com/1294454/27766607-8c1a69d8-5ede-11e7-930c-540b5eb9be24.jpg)                | luno               | [luno](https://www.luno.com)                              | 1   |  [API](https://www.luno.com/en/api)                                                           |
|UK                       |  ![mixcoins](https://user-images.githubusercontent.com/1294454/30237212-ed29303c-9535-11e7-8af8-fcd381cfa20c.jpg)            | mixcoins           | [MixCoins](https://mixcoins.com)                          | 1   |  [API](https://mixcoins.com/help/api/)                                                        |
|UK                       |  ![tidex](https://user-images.githubusercontent.com/1294454/30781780-03149dc4-a12e-11e7-82bb-313b269d24d4.jpg)               | tidex              | [Tidex](https://tidex.com)                                | 3   |  [API](https://tidex.com/exchange/public-api)                                                 |
|Ukraine                  |  ![btctradeua](https://user-images.githubusercontent.com/1294454/27941483-79fc7350-62d9-11e7-9f61-ac47f28fcd96.jpg)          | btctradeua         | [BTC Trade UA](https://btc-trade.com.ua)                  | *   |  [API](https://docs.google.com/document/d/1ocYA0yMy_RXd561sfG3qEPZ80kyll36HUxvCRe5GbhE/edit)  |
|Ukraine                  |  ![kuna](https://user-images.githubusercontent.com/1294454/31697638-912824fa-b3c1-11e7-8c36-cf9606eb94ac.jpg)                | kuna               | [Kuna](https://kuna.io)                                   | 2   |  [API](https://kuna.io/documents/api)                                                         |
|Ukraine                  |  ![liqui](https://user-images.githubusercontent.com/1294454/27982022-75aea828-63a0-11e7-9511-ca584a8edd74.jpg)               | liqui              | [Liqui](https://liqui.io)                                 | 3   |  [API](https://liqui.io/api)                                                                  |
|US                       |  ![_1broker](https://user-images.githubusercontent.com/1294454/27766021-420bd9fc-5ecb-11e7-8ed6-56d0081efed2.jpg)            | _1broker           | [1Broker](https://1broker.com)                            | 2   |  [API](https://1broker.com/?c=en/content/api-documentation)                                   |
|US                       |  ![bibox](https://user-images.githubusercontent.com/1294454/34902611-2be8bf1a-f830-11e7-91a2-11b2f292e750.jpg)               | bibox              | [Bibox](https://www.bibox.com)                            | 1   |  [API](https://github.com/Biboxcom/api_reference/wiki/home_en)                                |
|US                       |  ![bittrex](https://user-images.githubusercontent.com/1294454/27766352-cf0b3c26-5ed5-11e7-82b7-f3826b7a97d8.jpg)             | bittrex            | [Bittrex](https://bittrex.com)                            | 1.1 |  [API](https://bittrex.com/Home/Api)                                                          |
|US                       |  ![btcx](https://user-images.githubusercontent.com/1294454/27766385-9fdcc98c-5ed6-11e7-8f14-66d5e5cd47e6.jpg)                | btcx               | [BTCX](https://btc-x.is)                                  | 1   |  [API](https://btc-x.is/custom/api-document.html)                                             |
|US                       |  ![coinexchange](https://user-images.githubusercontent.com/1294454/34842303-29c99fca-f71c-11e7-83c1-09d900cb2334.jpg)        | coinexchange       | [CoinExchange](https://www.coinexchange.io)               | *   |  [API](https://coinexchangeio.github.io/slate/)                                               |
|US                       |  ![coingi](https://user-images.githubusercontent.com/1294454/28619707-5c9232a8-7212-11e7-86d6-98fe5d15cc6e.jpg)              | coingi             | [Coingi](https://coingi.com)                              | *   |  [API](http://docs.coingi.apiary.io/)                                                         |
|US                       |  ![coinmarketcap](https://user-images.githubusercontent.com/1294454/28244244-9be6312a-69ed-11e7-99c1-7c1797275265.jpg)       | coinmarketcap      | [CoinMarketCap](https://coinmarketcap.com)                | 1   |  [API](https://coinmarketcap.com/api)                                                         |
|US                       |  ![gdax](https://user-images.githubusercontent.com/1294454/27766527-b1be41c6-5edb-11e7-95f6-5b496c469e2c.jpg)                | gdax               | [GDAX](https://www.gdax.com)                              | *   |  [API](https://docs.gdax.com)                                                                 |
|US                       |  ![gemini](https://user-images.githubusercontent.com/1294454/27816857-ce7be644-6096-11e7-82d6-3c257263229c.jpg)              | gemini             | [Gemini](https://gemini.com)                              | 1   |  [API](https://docs.gemini.com/rest-api)                                                      |
|US                       |  ![itbit](https://user-images.githubusercontent.com/1294454/27822159-66153620-60ad-11e7-89e7-005f6d7f3de0.jpg)               | itbit              | [itBit](https://www.itbit.com)                            | 1   |  [API](https://api.itbit.com/docs)                                                            |
|US                       |  ![kraken](https://user-images.githubusercontent.com/1294454/27766599-22709304-5ede-11e7-9de1-9f33732e1509.jpg)              | kraken             | [Kraken](https://www.kraken.com)                          | 0   |  [API](https://www.kraken.com/en-us/help/api)                                                 |
|US                       |  ![lakebtc](https://user-images.githubusercontent.com/1294454/28074120-72b7c38a-6660-11e7-92d9-d9027502281d.jpg)             | lakebtc            | [LakeBTC](https://www.lakebtc.com)                        | 2   |  [API](https://www.lakebtc.com/s/api_v2)                                                      |
|US                       |  ![livecoin](https://user-images.githubusercontent.com/1294454/27980768-f22fc424-638a-11e7-89c9-6010a54ff9be.jpg)            | livecoin           | [LiveCoin](https://www.livecoin.net)                      | *   |  [API](https://www.livecoin.net/api?lang=en)                                                  |
|US                       |  ![okcoinusd](https://user-images.githubusercontent.com/1294454/27766791-89ffb502-5ee5-11e7-8a5b-c5950b68ac65.jpg)           | okcoinusd          | [OKCoin USD](https://www.okcoin.com)                      | 1   |  [API](https://www.okcoin.com/rest_getStarted.html)                                           |
|US                       |  ![okex](https://user-images.githubusercontent.com/1294454/32552768-0d6dd3c6-c4a6-11e7-90f8-c043b64756a7.jpg)                | okex               | [OKEX](https://www.okex.com)                              | 1   |  [API](https://www.okex.com/rest_getStarted.html)                                             |
|US                       |  ![poloniex](https://user-images.githubusercontent.com/1294454/27766817-e9456312-5ee6-11e7-9b3c-b628ca5626a5.jpg)            | poloniex           | [Poloniex](https://poloniex.com)                          | *   |  [API](https://poloniex.com/support/api/)                                                     |
|Venezuela                |  ![surbitcoin](https://user-images.githubusercontent.com/1294454/27991511-f0a50194-6481-11e7-99b5-8f02932424cc.jpg)          | surbitcoin         | [SurBitcoin](https://surbitcoin.com)                      | 1   |  [API](https://blinktrade.com/docs)                                                           |
|Vietnam                  |  ![coinexchange](https://user-images.githubusercontent.com/1294454/34842303-29c99fca-f71c-11e7-83c1-09d900cb2334.jpg)        | coinexchange       | [CoinExchange](https://www.coinexchange.io)               | *   |  [API](https://coinexchangeio.github.io/slate/)                                               |
|Vietnam                  |  ![quoinex](https://user-images.githubusercontent.com/1294454/35047114-0e24ad4a-fbaa-11e7-96a9-69c1a756083b.jpg)             | quoinex            | [QUOINEX](https://quoinex.com/)                           | 2   |  [API](https://developers.quoine.com)                                                         |
|Vietnam                  |  ![vbtc](https://user-images.githubusercontent.com/1294454/27991481-1f53d1d8-6481-11e7-884e-21d17e7939db.jpg)                | vbtc               | [VBTC](https://vbtc.exchange)                             | 1   |  [API](https://blinktrade.com/docs)                                                           |

