/*
 * Decompiled with CFR 0.152.
 */
package gridlabd;

import gridlabd.GModule;
import gridlabd.GObject;
import gridlabd.GProperty;
import gridlabd.GridlabD;
import java.util.Enumeration;
import java.util.Hashtable;

public class GClass {
    private String classname;
    private int synctype;
    private long classaddr;
    private long modaddr;
    private boolean inUse;
    private long size;
    private Hashtable<String, GProperty> proptable;
    private Hashtable<Long, GObject> objtable;

    private GClass(String string, long l, long l2, int n) {
        this.classname = new String(string);
        this.classaddr = l;
        this.modaddr = l2;
        this.synctype = n;
        this.proptable = new Hashtable();
        this.objtable = new Hashtable();
    }

    public static GClass BuildClass(String string, GModule gModule, int n) {
        long l = GridlabD.register_class(gModule.GetAddr(), string, n);
        if (l == 0L) {
            GridlabD.error("register_class(" + gModule.GetAddr() + ", " + string + ", " + n + ") failed");
            return null;
        }
        GClass gClass = new GClass(string, l, gModule.GetAddr(), n);
        gModule.AddClass(gClass);
        return gClass;
    }

    public void PutObj(GObject gObject) {
        if (!this.objtable.containsKey(gObject.GetAddr())) {
            this.objtable.put(new Long(gObject.GetAddr()), gObject);
        }
    }

    public String GetClassname() {
        return new String(this.classname);
    }

    public long GetClassAddr() {
        return this.classaddr;
    }

    public long GetModuleAddr() {
        return this.modaddr;
    }

    public int GetSyncType() {
        return this.synctype;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public long GetSize() {
        return this.size;
    }

    public boolean hasProperty(String string) {
        return this.proptable.containsKey(string);
    }

    public GProperty findProperty(String string) {
        return this.proptable.get(string);
    }

    public boolean hasObject(Long l) {
        return this.objtable.containsKey(l);
    }

    public Object getObject(Long l) {
        return this.objtable.get(l);
    }

    public GProperty AddProperty(String string, String string2) {
        GProperty gProperty;
        if (this.inUse) {
            GridlabD.error("Class " + this.classname + " is in use, ignoring AddProperty attempt");
        }
        GridlabD.verbose(this.classname + ".AddProperty(" + string + ", " + string2 + ")");
        long l = 0L;
        Enumeration<GProperty> enumeration = this.proptable.elements();
        while (enumeration.hasMoreElements()) {
            Long l2 = enumeration.nextElement().GetSize();
            l += l2.longValue();
        }
        GridlabD.verbose("\toffset = " + l);
        if (this.proptable.containsKey(string)) {
            GridlabD.error("Property \"" + string + "\" already exists");
            return null;
        }
        long l3 = GridlabD.publish_variable(this.modaddr, this.classaddr, string, string2, l);
        if (0L == l3) {
            GridlabD.error("Unable to GridlabD.publish_variable(" + this.modaddr + ", " + this.classaddr + ", " + string + ", " + string2 + ", " + l + ")");
        }
        if ((gProperty = GProperty.Build(string, string2, l, l3)) == null) {
            GridlabD.error("Unable to GProperty.Build(" + string + ", " + string2 + ", " + l + ", " + l3 + ")");
            return null;
        }
        this.proptable.put(string, gProperty);
        this.size = l + l3;
        return gProperty;
    }

    private native int _GetID(long var1);

    private native long _GetOClass(long var1);

    private native long _GetNext(long var1);

    private native String _GetName(long var1);

    private native long _GetParent(long var1);

    private native void _SetParent(long var1, long var3);

    private native int _GetRank(long var1);

    private native long _GetClock(long var1);

    private native double _GetLatitude(long var1);

    private native double _GetLongitude(long var1);

    private native long _GetInSvc(long var1);

    private native long _GetOutSvc(long var1);

    private native long _GetFlags(long var1);
}

