/** $Id: init.cpp 4738 2014-07-03 00:55:39Z dchassin $
	Copyright (C) 2008 Battelle Memorial Institute

    @file init.cpp
    @addtogroup assert Assertion objects
    @ingroup modules

    The \p assert module implements general purpose assert classes
@{
**/

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <math.h>
#include "gridlabd.h"

#include "assert.h"
#include "double_assert.h"
#include "complex_assert.h"
#include "enum_assert.h"
#include "int_assert.h"

EXPORT CLASS *init(CALLBACKS *fntable, MODULE *module, int argc, char *argv[])
{
	if (set_callback(fntable)==NULL)
	{
		errno = EINVAL;
		return NULL;
	}

	INIT_MMF(assert);

	new g_assert(module);
	new double_assert(module);
	new complex_assert(module);
	new enum_assert(module);
    new int_assert(module);

	/* always return the first class registered */
	return g_assert::oclass;
}


EXPORT int do_kill(void*)
{
	/* if global memory needs to be released, this is a good time to do it */
	return 0;
}

EXPORT int check(){
	/* if any assert objects have bad filenames, they'll fail on init() */
	return 0;
}

/** @} **/