function mpc = case2737sop
%CASE2737SOP    Power flow data for Polish system - summer 2004 off-peak.
%   Please see CASEFORMAT for details on the case file format.
%
%   This case represents the Polish 400, 220 and 110 kV networks during
%   summer 2004 off-peak conditions. Multiple centrally dispatchable
%   generators at a bus have not been aggregated. Generators that are
%   not centrally dispatchable in the Polish energy market are given a
%   cost of zero.
%
%   This data was graciously provided by, and is distributed with the
%   permission of, Roman Korab <roman.korab@polsl.pl>.

%   MATPOWER
%   $Id: case2737sop.m 4738 2014-07-03 00:55:39Z dchassin $

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin	lam_P	lam_Q	mu_Vmax	mu_Vmin
mpc.bus = [
	1	1	0	0	0	0	1	1.0988371	3.1731556	220	1	1.11	0.95	89.4822	0.1770	0.0000	0.0000;
	2	1	0	0	0	0	1	1.1062317	2.1002592	220	1	1.11	0.95	89.8246	-0.0341	0.0000	0.0000;
	3	1	0	0	0	0	1	1.0814038	-12.414419	220	1	1.11	0.95	96.4024	-0.3433	0.0000	0.0000;
	4	1	0	0	0	0	1	1.0978935	-0.2625655	220	1	1.11	0.95	90.7381	0.0166	0.0000	0.0000;
	5	1	0	0	0	0	1	1.0979028	-0.25899449	220	1	1.11	0.95	90.7382	0.0171	0.0000	0.0000;
	6	1	0	0	0	0	1	1.0784645	-6.7111231	220	1	1.11	0.95	93.2099	-0.4768	0.0000	0.0000;
	7	1	0	0	0	0	1	1.0785472	-6.7055016	220	1	1.11	0.95	93.2067	-0.4782	0.0000	0.0000;
	8	1	0	0	0	-50	1	1.0422298	-5.3046136	400	1	1.05	0.95	92.8049	-0.7547	0.0000	0.0000;
	9	1	0	0	0	0	1	1.0422619	-5.3031789	400	1	1.05	0.95	92.8043	-0.7555	0.0000	0.0000;
	10	1	0	0	0	0	1	1.0715408	-6.753116	220	1	1.11	0.95	93.4502	-0.3129	0.0000	0.0000;
	11	1	0	0	0	0	1	1.0715132	-6.7557551	220	1	1.11	0.95	93.4515	-0.3114	0.0000	0.0000;
	12	1	0	0	0	0	1	1.0715104	-6.7512467	220	1	1.11	0.95	93.4509	-0.3098	0.0000	0.0000;
	13	1	0	0	0	0	1	1.07149	-6.755826	220	1	1.11	0.95	93.4514	-0.3099	0.0000	0.0000;
	14	1	0	0	0	-50	1	1.0362421	-4.249135	400	1	1.05	0.95	92.4628	-0.4494	0.0000	0.0000;
	15	1	0	0	0	0	1	1.05	-6.6753466	400	1	1.05	0.95	93.0327	-1.5740	0.0000	0.0000;
	16	1	0	0	0	0	1	1.05	-6.6753466	400	1	1.05	0.95	93.0325	-1.5754	2354.0866	0.0000;
	17	1	0	0	0	0	1	1.075175	-10.326271	220	1	1.11	0.95	95.1052	-0.0880	0.0000	0.0000;
	18	1	0	0	0	0	1	1.0751192	-10.32649	220	1	1.11	0.95	95.1042	-0.0861	0.0000	0.0000;
	19	1	0	0	0	0	1	1.1006118	0.29052844	220	1	1.11	0.95	90.4586	0.0218	0.0000	0.0000;
	20	1	0	0	0	0	1	1.1006331	0.28503371	220	1	1.11	0.95	90.4595	0.0218	0.0000	0.0000;
	21	1	0	0	0	0	1	1.0821751	-7.00751	220	1	1.11	0.95	93.3511	-0.1824	0.0000	0.0000;
	22	1	0	0	0	0	1	1.0821751	-7.00751	220	1	1.11	0.95	93.3511	-0.1824	0.0000	0.0000;
	23	1	0	0	0	0	1	1.0689354	-6.8094961	220	1	1.11	0.95	93.4699	-0.3584	0.0000	0.0000;
	24	1	0	0	0	0	1	1.1024425	0.68972441	220	1	1.11	0.95	90.3797	-0.0309	0.0000	0.0000;
	25	1	0	0	0	-50	1	1.0389197	-6.6165523	400	1	1.05	0.95	93.6600	-0.1245	0.0000	0.0000;
	26	2	48.178	65.087	0	0	1	1.1082562	3.5097454	220	1	1.11	0.95	89.3018	0.0000	0.0000	0.0000;
	27	2	28.145	35.087	0	0	1	1.1074115	2.0773566	220	1	1.11	0.95	89.8497	-0.0653	0.0000	0.0000;
	28	3	0	0	0	0	1	1.0449384	1.77808	400	1	1.05	0.95	90.2156	-0.0851	0.0000	0.0000;
	29	2	44.698	72	0	0	1	1.0449301	1.7863243	400	1	1.05	0.95	90.2126	-0.0850	0.0000	0.0000;
	30	1	0	0	0	0	1	1.0766538	-7.0072863	220	1	1.11	0.95	93.5523	-0.2272	0.0000	0.0000;
	31	1	0	0	0	0	1	1.0464577	0.79967202	400	1	1.05	0.95	90.3745	-0.1567	0.0000	0.0000;
	32	1	0	0	0	0	1	1.0693388	-6.9043214	220	1	1.11	0.95	93.5297	-0.2720	0.0000	0.0000;
	33	1	0	0	0	0	1	1.09915	-1.7078575	220	1	1.11	0.95	91.1525	0.0342	0.0000	0.0000;
	34	1	0	0	0	0	1	1.11	-3.5435543	220	2	1.11	0.95	90.8522	-4.4397	11730.0166	0.0000;
	35	1	0	0	0	0	1	1.0805053	-4.3551196	220	2	1.11	0.95	92.2726	-1.4203	0.0000	0.0000;
	36	1	0	0	0	0	1	1.0969905	-3.9054531	220	2	1.11	0.95	91.8665	-1.7375	0.0000	0.0000;
	37	1	0	0	0	0	1	1.0969464	-3.9069642	220	2	1.11	0.95	91.8676	-1.7350	0.0000	0.0000;
	38	1	0	0	0	0	1	1.1002849	-3.7899499	220	2	1.11	0.95	91.1584	-3.1562	0.0000	0.0000;
	39	1	0	0	0	0	1	1.1070837	-3.9625528	220	2	1.11	0.95	92.1847	-1.1120	0.0000	0.0000;
	40	1	0	0	0	0	1	1.1070251	-3.9655272	220	2	1.11	0.95	92.1859	-1.1109	0.0000	0.0000;
	41	1	0	0	0	0	1	1.0389057	-3.8675125	400	2	1.05	0.95	92.1440	-1.0852	0.0000	0.0000;
	42	2	13	0	0	0	1	1.0843581	-3.6251574	220	2	1.11	0.95	91.7425	-1.1989	0.0000	0.0000;
	43	2	13	0	0	0	1	1.0843882	-3.6162162	220	2	1.11	0.95	91.7398	-1.2022	0.0000	0.0000;
	44	2	25	0	0	0	1	1.0495182	-3.7143296	400	2	1.05	0.95	91.9966	-1.1649	0.0000	0.0000;
	45	1	0	0	0	0	1	1.0495379	-3.7138534	400	2	1.05	0.95	91.9947	-1.1665	0.0000	0.0000;
	46	1	0	0	0	0	1	1.1065925	-4.2521065	220	2	1.11	0.95	92.3785	-1.1117	0.0000	0.0000;
	47	1	0	0	0	0	1	1.0387693	-6.4543224	400	2	1.05	0.95	92.8916	-0.8887	0.0000	0.0000;
	48	1	0	0	0	0	1	1.0387728	-6.4585039	400	2	1.05	0.95	92.8935	-0.8885	0.0000	0.0000;
	49	1	0	0	0	0	1	1.0466528	-3.6073314	400	2	1.05	0.95	91.7028	-1.5086	0.0000	0.0000;
	50	1	0	0	0	0	1	1.1003654	-3.2193348	220	2	1.11	0.95	90.7898	-3.2463	0.0000	0.0000;
	51	1	0	0	0	0	1	1.1003403	-3.2167735	220	2	1.11	0.95	90.7899	-3.2444	0.0000	0.0000;
	52	1	0	0	0	0	1	1.0477994	-4.1910932	400	2	1.05	0.95	92.1922	-1.1842	0.0000	0.0000;
	53	1	0	0	0	0	1	1.0477959	-4.1902534	400	2	1.05	0.95	92.1922	-1.1841	0.0000	0.0000;
	54	1	0	0	0	0	1	1.0977199	-3.6115281	220	2	1.11	0.95	91.8352	-1.3695	0.0000	0.0000;
	55	2	13	0	0	0	1	1.0976897	-3.6048105	220	2	1.11	0.95	91.8311	-1.3710	0.0000	0.0000;
	56	2	13	0	0	0	1	1.045932	-3.7636954	400	2	1.05	0.95	92.0676	-1.1044	0.0000	0.0000;
	57	2	13	0	0	0	1	1.0459153	-3.7671604	400	2	1.05	0.95	92.0690	-1.1042	0.0000	0.0000;
	58	2	67.882	25.273	0	0	1	1.0901945	-3.8334578	220	2	1.11	0.95	91.6559	-1.9664	0.0000	0.0000;
	59	1	0	0	0	0	1	1.0902606	-3.8309695	220	2	1.11	0.95	91.6539	-1.9726	0.0000	0.0000;
	60	1	0	0	0	0	1	1.1032085	-4.3318607	220	2	1.11	0.95	92.3656	-1.1302	0.0000	0.0000;
	61	1	0	0	0	0	1	1.0898541	-4.0841342	220	2	1.11	0.95	92.0242	-1.3236	0.0000	0.0000;
	62	1	0	0	0	0	1	1.0898184	-4.0840559	220	2	1.11	0.95	92.0235	-1.3255	0.0000	0.0000;
	63	1	0	0	0	0	1	1.0375043	-4.6163516	400	2	1.05	0.95	92.3231	-0.9194	0.0000	0.0000;
	64	1	0	0	0	0	1	1.037527	-4.6243476	400	2	1.05	0.95	92.3259	-0.9197	0.0000	0.0000;
	65	1	0	224.802	0	0	1	1.0496172	-4.5991852	750	2	1.05	0.9	92.3232	-0.9027	0.0000	0.0000;
	66	1	0	0	0	0	1	1.1011486	-4.1127983	220	2	1.11	0.95	91.7378	-2.5436	0.0000	0.0000;
	67	1	0	0	0	0	1	1.101794	-4.0223494	220	2	1.11	0.95	91.6777	-2.5875	0.0000	0.0000;
	68	1	0	0	0	0	1	1.0969502	-2.7101621	220	2	1.11	0.95	90.6058	-3.0297	0.0000	0.0000;
	69	1	0	0	0	0	1	1.0999402	-1.5148341	220	3	1.11	0.95	91.1768	-0.2209	0.0000	0.0000;
	70	1	0	0	0	0	1	1.1007297	-4.4938609	220	3	1.11	0.95	92.2721	-0.9226	0.0000	0.0000;
	71	1	0	0	0	0	1	1.1007249	-4.4925157	220	3	1.11	0.95	92.2715	-0.9237	0.0000	0.0000;
	72	1	0	0	0	0	1	1.0862997	-4.3937257	220	3	1.11	0.95	92.3851	0.0114	0.0000	0.0000;
	73	1	0	0	0	0	1	1.086311	-4.3818206	220	3	1.11	0.95	92.3817	0.0111	0.0000	0.0000;
	74	1	0	0	0	0	1	1.0950289	-3.3714802	220	3	1.11	0.95	91.7651	-0.0664	0.0000	0.0000;
	75	1	0	0	0	0	1	1.0950083	-3.3728031	220	3	1.11	0.95	91.7660	-0.0664	0.0000	0.0000;
	76	1	0	0	0	0	1	1.0811849	-8.0356642	220	3	1.11	0.95	94.1814	0.0102	0.0000	0.0000;
	77	1	0	0	0	0	1	1.0811784	-8.0389669	220	3	1.11	0.95	94.1832	0.0103	0.0000	0.0000;
	78	2	27	70	0	0	1	1.0878054	-3.5711162	220	3	1.11	0.95	92.0186	0.0000	0.0000	0.0000;
	79	2	9	21	0	0	1	1.0882992	-4.1560165	220	3	1.11	0.95	92.3156	-0.0433	0.0000	0.0000;
	80	1	4.602	0.91	0	0	1	1.0872711	-4.2559736	220	3	1.11	0.95	92.4187	0.0157	0.0000	0.0000;
	81	1	0	0	0	0	1	1.0872656	-4.2561554	220	3	1.11	0.95	92.4191	0.0155	0.0000	0.0000;
	82	2	18	57	0	0	1	1.038756	-0.65564817	400	3	1.05	0.95	90.7825	-0.1757	0.0000	0.0000;
	83	1	0	0	0	0	1	1.1078773	-2.5120288	220	3	1.11	0.95	91.1798	-0.3557	0.0000	0.0000;
	84	1	0	0	0	0	1	1.0915351	-4.0744547	220	3	1.11	0.95	92.1077	-0.0084	0.0000	0.0000;
	85	1	0	0	0	0	1	1.0914976	-4.0757816	220	3	1.11	0.95	92.1087	-0.0085	0.0000	0.0000;
	86	1	32.969	-8.4	0	0	1	1.1005785	-1.6592085	220	3	1.11	0.95	91.2109	-0.2332	0.0000	0.0000;
	87	1	0	0	0	0	1	1.1005774	-1.6637056	220	3	1.11	0.95	91.2124	-0.2332	0.0000	0.0000;
	88	1	0	0	0	0	1	1.0865034	-3.6181237	220	3	1.11	0.95	91.9702	0.0584	0.0000	0.0000;
	89	1	0	0	0	0	1	1.0864764	-3.6185168	220	3	1.11	0.95	91.9702	0.0584	0.0000	0.0000;
	90	1	0	0	0	0	1	1.100397	-1.2887863	220	3	1.11	0.95	91.0457	-0.2127	0.0000	0.0000;
	91	1	0	0	0	0	1	1.1004123	-1.2922528	220	3	1.11	0.95	91.0462	-0.2136	0.0000	0.0000;
	92	1	0	0	0	0	1	1.0485753	0.0470111	400	3	1.05	0.95	90.7875	-0.2047	0.0000	0.0000;
	93	1	0	0	0	0	1	1.0485662	0.04600424	400	3	1.05	0.95	90.7877	-0.2046	0.0000	0.0000;
	94	1	0	0	0	0	1	1.089866	-3.7168499	220	3	1.11	0.95	91.9405	0.0092	0.0000	0.0000;
	95	1	0	0	0	0	1	1.0898885	-3.7217981	220	3	1.11	0.95	91.9419	0.0092	0.0000	0.0000;
	96	1	0	0	0	0	1	1.1006195	-2.9440143	220	3	1.11	0.95	91.4340	-0.1495	0.0000	0.0000;
	97	1	0	0	0	0	1	1.1006611	-2.9418413	220	3	1.11	0.95	91.4330	-0.1504	0.0000	0.0000;
	98	2	9.938	2.19	0	0	1	1.0911223	-3.8143676	220	3	1.11	0.95	92.1552	-0.1393	0.0000	0.0000;
	99	1	16.652	3.293	0	0	1	1.0911428	-3.8119524	220	3	1.11	0.95	92.1544	-0.1400	0.0000	0.0000;
	100	1	0	0	0	0	1	1.1007054	-4.4923524	220	3	1.11	0.95	92.2715	-0.9232	0.0000	0.0000;
	101	1	0	0	0	0	1	1.1007103	-4.493698	220	3	1.11	0.95	92.2721	-0.9221	0.0000	0.0000;
	102	1	0	0	0	0	1	1.0818145	-7.4626411	220	3	1.11	0.95	93.9537	0.0324	0.0000	0.0000;
	103	1	0	0	0	0	1	1.0818182	-7.4522797	220	3	1.11	0.95	93.9502	0.0325	0.0000	0.0000;
	104	2	14	40	0	0	1	1.0923127	-4.0814397	220	3	1.11	0.95	92.1322	0.0000	0.0000	0.0000;
	105	1	0	0	0	0	1	1.0922038	-4.1003381	220	3	1.11	0.95	92.1397	0.0016	0.0000	0.0000;
	106	2	7	18	0	0	1	1.0901045	-3.3210431	220	3	1.11	0.95	91.7962	0.0000	0.0000	0.0000;
	107	1	0	0	0	0	1	1.0900602	-3.3207564	220	3	1.11	0.95	91.7964	-0.0002	0.0000	0.0000;
	108	1	27.63	5.872	0	0	1	1.0943977	-3.3498601	220	3	1.11	0.95	91.9503	-0.2359	0.0000	0.0000;
	109	1	17.522	3.337	0	0	1	1.0944125	-3.3570878	220	3	1.11	0.95	91.9525	-0.2371	0.0000	0.0000;
	110	1	0	0	0	0	1	1.0856816	-4.6384324	220	3	1.11	0.95	92.6581	-0.1116	0.0000	0.0000;
	111	1	0	0	0	0	1	1.0876704	-4.1208111	220	3	1.11	0.95	92.2667	0.0927	0.0000	0.0000;
	112	1	0	0	0	0	1	1.0876767	-4.12152	220	3	1.11	0.95	92.2672	0.0922	0.0000	0.0000;
	113	1	0	0	0	0	1	1.0866617	-4.2664831	220	3	1.11	0.95	92.4521	0.0044	0.0000	0.0000;
	114	1	0	0	0	0	1	1.0866683	-4.2613941	220	3	1.11	0.95	92.4500	0.0042	0.0000	0.0000;
	115	1	0	0	0	0	1	1.0366664	-2.111324	400	3	1.05	0.95	91.4080	-0.2491	0.0000	0.0000;
	116	1	0	0	0	0	1	1.089168	-3.8412547	220	3	1.11	0.95	92.1785	-0.0890	0.0000	0.0000;
	117	2	8	15	0	0	1	1.0891509	-3.8318891	220	3	1.11	0.95	92.1757	-0.0883	0.0000	0.0000;
	118	1	0	0	0	0	1	1.0883397	-4.4254886	220	3	1.11	0.95	92.4705	-0.1887	0.0000	0.0000;
	119	1	0	0	0	0	1	1.0883542	-4.4242539	220	3	1.11	0.95	92.4696	-0.1896	0.0000	0.0000;
	120	1	0	0	0	0	1	1.0470801	-3.9626713	400	3	1.05	0.95	92.1277	-0.9603	0.0000	0.0000;
	121	1	0	0	0	0	1	1.0471181	-3.9587483	400	3	1.05	0.95	92.1260	-0.9605	0.0000	0.0000;
	122	1	0	0	0	0	1	1.043056	-1.9199464	400	3	1.05	0.95	91.3301	-0.3804	0.0000	0.0000;
	123	1	0	0	0	0	1	1.0431047	-1.9169615	400	3	1.05	0.95	91.3292	-0.3813	0.0000	0.0000;
	124	1	0	0	0	0	1	1.0851196	-4.710497	220	3	1.11	0.95	92.7212	-0.1134	0.0000	0.0000;
	125	1	2.929	0.867	0	0	1	1.0979375	-3.1116592	220	3	1.11	0.95	91.5511	-0.0543	0.0000	0.0000;
	126	2	19.898	27.707	0	0	1	1.0977572	-3.1061652	220	3	1.11	0.95	91.5514	-0.0514	0.0000	0.0000;
	127	2	12.2	25.8	0	0	1	1.03145	-1.7713769	400	3	1.05	0.95	91.2979	-0.1135	0.0000	0.0000;
	128	1	0	0	0	0	1	1.0313793	-1.7757389	400	3	1.05	0.95	91.2999	-0.1129	0.0000	0.0000;
	129	1	0	0	0	0	1	1.1004705	-1.753404	220	3	1.11	0.95	91.2543	-0.2341	0.0000	0.0000;
	130	1	0	0	0	0	1	1.1004246	-1.7541935	220	3	1.11	0.95	91.2542	-0.2333	0.0000	0.0000;
	131	1	0	0	0	0	1	1.0997933	-1.6360908	220	3	1.11	0.95	91.2028	-0.2119	0.0000	0.0000;
	132	2	137	9	0	0	1	1.080568	-8.4583986	220	3	1.11	0.95	94.3690	0.0000	0.0000	0.0000;
	133	2	137	6	0	0	1	1.080567	-8.4631219	220	3	1.11	0.95	94.3708	0.0000	0.0000	0.0000;
	134	1	0.515	1.973	0	0	1	1.1010272	-2.5005347	220	4	1.11	0.95	91.3665	0.0003	0.0000	0.0000;
	135	2	15.242	14.277	0	0	1	1.1010531	-2.4977759	220	4	1.11	0.95	91.3654	-0.0000	0.0000	0.0000;
	136	1	0	0	0	0	1	1.1090223	-2.907547	220	4	1.11	0.95	90.9609	-0.3853	0.0000	0.0000;
	137	1	0	0	0	0	1	1.1084034	-2.2905373	220	4	1.11	0.95	90.6905	-0.2757	0.0000	0.0000;
	138	1	0	0	0	0	1	1.0335809	-2.2051876	400	4	1.05	0.95	91.1851	-0.2239	0.0000	0.0000;
	139	1	0	0	0	0	1	1.0336006	-2.2078	400	4	1.05	0.95	91.1863	-0.2241	0.0000	0.0000;
	140	1	0	0	0	0	1	1.101858	-7.2447288	220	4	1.11	0.95	93.9426	-0.2038	0.0000	0.0000;
	141	1	0	0	0	0	1	1.0937023	-6.1672989	220	4	1.11	0.95	94.2776	0.0247	0.0000	0.0000;
	142	1	0	0	0	0	1	1.0937023	-6.1672989	220	4	1.11	0.95	94.2776	0.0247	0.0000	0.0000;
	143	1	0	0	0	0	1	1.102517	-6.0408918	220	4	1.11	0.95	93.6117	-0.4728	0.0000	0.0000;
	144	1	0	0	0	0	1	1.1064125	-3.4132987	220	4	1.11	0.95	91.1515	-0.2253	0.0000	0.0000;
	145	1	0	0	0	0	1	1.1064125	-3.4132987	220	4	1.11	0.95	91.1515	-0.2253	0.0000	0.0000;
	146	1	7.636	13.257	0	0	1	1.0990818	-4.310413	220	4	1.11	0.95	92.0820	0.0139	0.0000	0.0000;
	147	1	0	0	0	0	1	1.0991439	-4.3087158	220	4	1.11	0.95	92.0799	0.0134	0.0000	0.0000;
	148	2	10.87	14.867	0	0	1	1.0964007	-5.3203788	220	4	1.11	0.95	93.8293	-0.0074	0.0000	0.0000;
	149	1	0	0	0	0	1	1.0964815	-5.3319086	220	4	1.11	0.95	93.8358	-0.0086	0.0000	0.0000;
	150	2	10.989	15	0	0	1	1.0336749	-8.0337652	400	4	1.05	0.95	94.4951	-0.0000	0.0000	0.0000;
	151	2	20.672	21.479	0	0	1	1.0336702	-8.0315014	400	4	1.05	0.95	94.4943	-0.0004	0.0000	0.0000;
	152	1	0	0	0	0	1	1.098391	-6.7794234	220	4	1.11	0.95	93.9336	-0.2218	0.0000	0.0000;
	153	1	0	0	0	0	1	1.1077538	-4.3612447	220	4	1.11	0.95	92.2945	-0.9851	0.0000	0.0000;
	154	1	0	0	0	0	1	1.1077553	-4.3636195	220	4	1.11	0.95	92.2953	-0.9815	0.0000	0.0000;
	155	2	0	0	0	0	1	1.1054692	-0.91838753	220	4	1.11	0.95	90.1696	-0.0449	0.0000	0.0000;
	156	2	13.87	33	0	0	1	1.1054826	-0.91263647	220	4	1.11	0.95	90.1689	-0.0454	0.0000	0.0000;
	157	1	0	0	0	0	1	1.0208966	-0.02424863	400	4	1.05	0.95	90.2541	-0.0039	0.0000	0.0000;
	158	2	9.989	25	0	0	1	1.0208614	-0.01970188	400	4	1.05	0.95	90.2525	-0.0033	0.0000	0.0000;
	159	1	0	0	0	0	1	1.0982403	-6.1687192	220	4	1.11	0.95	94.2231	-0.0428	0.0000	0.0000;
	160	1	0	0	0	0	1	1.0982403	-6.1687192	220	4	1.11	0.95	94.2231	-0.0428	0.0000	0.0000;
	161	1	0	0	0	0	1	1.0381031	-2.850795	400	4	1.05	0.95	91.4175	-0.2802	0.0000	0.0000;
	162	1	0	0	0	0	1	1.0380799	-2.3257801	400	4	1.05	0.95	91.2251	-0.2678	0.0000	0.0000;
	163	1	0	0	0	0	1	1.0380786	-2.3254376	400	4	1.05	0.95	91.2250	-0.2678	0.0000	0.0000;
	164	2	11.664	11	0	0	1	1.1005618	-4.4219209	220	4	1.11	0.95	92.1080	-0.0000	0.0000	0.0000;
	165	2	11.564	10.667	0	0	1	1.1005897	-4.4365739	220	4	1.11	0.95	92.1152	-0.0002	0.0000	0.0000;
	166	1	0	0	0	0	1	1.1005897	-4.4365739	220	4	1.11	0.95	92.1152	-0.0002	0.0000	0.0000;
	167	1	0	0	0	0	1	1.1078578	-11.188191	220	4	1.11	0.95	96.2459	-0.3679	0.0000	0.0000;
	168	1	0	0	0	0	1	1.0930144	-6.2258786	220	4	1.11	0.95	94.3017	0.0429	0.0000	0.0000;
	169	1	0	0	0	0	1	1.1079187	-7.7992584	220	4	1.11	0.95	94.3401	-0.3672	0.0000	0.0000;
	170	1	0	0	0	0	1	1.10792	-7.8048332	220	4	1.11	0.95	94.3422	-0.3673	0.0000	0.0000;
	171	1	0	0	0	0	1	1.0273607	-8.0768261	400	4	1.05	0.95	94.4134	-0.2652	0.0000	0.0000;
	172	1	0	0	0	0	1	1.0273607	-8.0768261	400	4	1.05	0.95	94.4134	-0.2652	0.0000	0.0000;
	173	1	0	0	0	0	1	1.0972304	-4.9313669	220	4	1.11	0.95	92.7843	-0.1592	0.0000	0.0000;
	174	1	0	0	0	0	1	1.0972427	-4.9292116	220	4	1.11	0.95	92.7836	-0.1585	0.0000	0.0000;
	175	1	0	0	0	0	1	1.0936299	-6.2290183	220	4	1.11	0.95	92.8329	-0.0759	0.0000	0.0000;
	176	1	0	0	0	0	1	1.1086642	-2.8518944	220	4	1.11	0.95	90.9932	-0.3999	0.0000	0.0000;
	177	1	0	0	0	0	1	1.1086718	-2.8506968	220	4	1.11	0.95	90.9935	-0.4011	0.0000	0.0000;
	178	1	0	0	0	0	1	1.11	-3.0395622	220	4	1.11	0.95	91.1245	-0.7002	1510.5743	0.0000;
	179	1	0	0	0	0	1	1.11	-3.0395622	220	4	1.11	0.95	91.1245	-0.7002	0.0000	0.0000;
	180	2	3.13	1.5	0	0	1	1.11	-3.4532746	220	4	1.11	0.95	91.8736	-1.4635	3217.2702	0.0000;
	181	1	0	0	0	0	1	1.0976593	-5.2093053	220	4	1.11	0.95	92.8581	-0.3246	0.0000	0.0000;
	182	1	0	0	0	0	1	1.0906174	-11.550683	220	5	1.11	0.95	95.7641	0.0476	0.0000	0.0000;
	183	1	0	0	0	0	1	1.10155	-14.207909	220	5	1.11	0.95	96.9396	-0.0429	0.0000	0.0000;
	184	1	0	0	0	0	1	1.0352196	-13.758822	400	5	1.05	0.95	96.7166	0.0058	0.0000	0.0000;
	185	1	0	0	0	0	1	1.0352336	-13.750658	400	5	1.05	0.95	96.7128	0.0058	0.0000	0.0000;
	186	1	0	0	0	0	1	1.035852	-16.309541	400	5	1.05	0.95	97.9087	-0.0415	0.0000	0.0000;
	187	1	0	0	0	0	1	1.0358756	-16.315051	400	5	1.05	0.95	97.9110	-0.0420	0.0000	0.0000;
	188	1	0	0	0	0	1	1.1013411	-15.79941	220	5	1.11	0.95	98.0998	-0.0701	0.0000	0.0000;
	189	1	0	0	0	0	1	1.1013634	-15.799937	220	5	1.11	0.95	98.1000	-0.0706	0.0000	0.0000;
	190	1	0	0	0	0	1	1.0967955	-13.647542	220	5	1.11	0.95	96.6631	-0.0479	0.0000	0.0000;
	191	1	0	0	0	0	1	1.0967841	-13.641326	220	5	1.11	0.95	96.6619	-0.0478	0.0000	0.0000;
	192	1	0	0	0	0	1	1.0251116	-11.536722	400	5	1.05	0.95	96.1553	0.0868	0.0000	0.0000;
	193	1	0	0	0	0	1	1.0911228	-11.119661	220	5	1.11	0.95	95.6728	0.0611	0.0000	0.0000;
	194	1	0	0	0	0	1	1.091116	-11.118625	220	5	1.11	0.95	95.6729	0.0610	0.0000	0.0000;
	195	1	0	0	0	0	1	1.0431001	-16.235603	400	5	1.05	0.95	98.0356	-0.1232	0.0000	0.0000;
	196	1	0	0	0	0	1	1.043097	-16.2353	400	5	1.05	0.95	98.0359	-0.1231	0.0000	0.0000;
	197	1	0	0	0	0	1	1.0714251	-13.77591	220	5	1.11	0.95	97.5431	-0.0369	0.0000	0.0000;
	198	1	0	0	0	0	1	1.0714109	-13.77467	220	5	1.11	0.95	97.5417	-0.0368	0.0000	0.0000;
	199	1	0	0	0	-117	1	1.0269754	-15.550639	400	5	1.05	0.95	97.4200	0.1085	0.0000	0.0000;
	200	1	0	0	0	0	1	1.0270217	-15.543467	400	5	1.05	0.95	97.4168	0.1079	0.0000	0.0000;
	201	1	0	0	0	0	1	1.0846615	-12.497814	220	5	1.11	0.95	96.6269	0.0765	0.0000	0.0000;
	202	1	0	0	0	0	1	1.0846264	-12.49079	220	5	1.11	0.95	96.6257	0.0767	0.0000	0.0000;
	203	1	0	0	0	0	1	1.0779801	-10.282582	220	5	1.11	0.95	95.7763	0.1786	0.0000	0.0000;
	204	1	0	0	0	0	1	1.0779684	-10.293333	220	5	1.11	0.95	95.7803	0.1786	0.0000	0.0000;
	205	2	400	60	0	0	1	1.0319479	-17.366475	400	5	1.05	0.95	98.1753	-0.0000	0.0000	0.0000;
	206	1	0	0	0	0	1	1.0319774	-17.36237	400	5	1.05	0.95	98.1740	-0.0004	0.0000	0.0000;
	207	1	0	0	0	0	1	1.1045955	-14.772601	220	5	1.11	0.95	97.4145	-0.2154	0.0000	0.0000;
	208	1	0	0	0	0	1	1.1045931	-14.775974	220	5	1.11	0.95	97.4142	-0.2148	0.0000	0.0000;
	209	1	8.114	2	0	0	1	1.0634391	-9.1432073	110	1	1.12	0.95	95.2602	-0.7115	0.0000	0.0000;
	210	1	2.705	0.5	0	0	1	1.0595242	-14.761156	110	1	1.12	0.95	98.3805	-0.5282	0.0000	0.0000;
	211	1	2.705	2	0	0	1	1.0680045	-8.4334738	110	1	1.12	0.95	93.3974	-0.2476	0.0000	0.0000;
	212	1	4.688	4.6	0	0	1	1.0442043	-9.9780513	110	1	1.12	0.95	96.0087	0.4706	0.0000	0.0000;
	213	1	1.623	0.4	0	0	1	1.0563609	1.4988114	110	1	1.12	0.95	90.1198	0.0072	0.0000	0.0000;
	214	1	1.172	0.3	0	0	1	1.0580792	0.73906982	110	1	1.12	0.95	89.9175	0.3503	0.0000	0.0000;
	215	2	6	8.8	0	0	1	1.0804096	-9.1245518	110	1	1.12	0.95	93.5881	-0.9775	0.0000	0.0000;
	216	1	4.959	0.5	0	0	1	1.0822197	-9.0279383	110	1	1.12	0.95	93.4725	-1.0851	0.0000	0.0000;
	217	1	4.057	1	0	0	1	1.0816652	-9.0627133	110	1	1.12	0.95	93.5110	-1.0565	0.0000	0.0000;
	218	1	6.762	1.5	0	0	1	1.0801729	-9.2340483	110	1	1.12	0.95	93.6734	-0.9734	0.0000	0.0000;
	219	1	5.139	2.8	0	0	1	1.0595352	-9.3854604	110	1	1.12	0.95	94.8567	0.1396	0.0000	0.0000;
	220	1	5.41	1.5	0	0	1	1.0582708	-9.4666316	110	1	1.12	0.95	94.6576	0.0251	0.0000	0.0000;
	221	2	0	0	0	0	1	1.1106223	-5.0099381	110	1	1.12	0.95	91.7879	-0.2327	0.0000	0.0000;
	222	2	4.237	1.7	0	0	1	1.0994426	-2.88014	110	1	1.12	0.95	91.9673	0.0000	0.0000	0.0000;
	223	1	6.311	1.4	0	0	1	1.0667973	-8.9699535	110	1	1.12	0.95	93.9255	-0.1823	0.0000	0.0000;
	224	1	0.721	0.1	0	0	1	1.0504958	0.25216002	110	1	1.12	0.95	90.9851	0.0074	0.0000	0.0000;
	225	1	2.074	0.4	0	0	1	1.0727484	-10.756585	110	1	1.12	0.95	95.1407	-0.0081	0.0000	0.0000;
	226	1	1.803	0	0	0	1	1.0658049	-12.521912	110	1	1.12	0.95	96.5717	-0.3691	0.0000	0.0000;
	227	1	7.664	1.5	0	0	1	1.0759769	-9.2268089	110	1	1.12	0.95	94.3854	-1.1315	0.0000	0.0000;
	228	1	2.524	1	0	0	1	1.0670063	-9.1433891	110	1	1.12	0.95	94.0399	-0.1275	0.0000	0.0000;
	229	1	3.246	1	0	0	1	1.0670327	-9.1386718	110	1	1.12	0.95	94.0383	-0.1278	0.0000	0.0000;
	230	1	1.533	0.78	0	0	1	1.1047691	-1.9675502	110	1	1.12	0.95	91.2077	0.0815	0.0000	0.0000;
	231	1	1.533	0.78	0	0	1	1.1025028	-2.8364608	110	1	1.12	0.95	91.7079	0.0697	0.0000	0.0000;
	232	1	3.606	1	0	0	1	1.0617768	-9.0180406	110	1	1.12	0.95	94.1655	-0.0499	0.0000	0.0000;
	233	1	3.246	1	0	0	1	1.0581298	0.76398807	110	1	1.12	0.95	89.8944	0.3547	0.0000	0.0000;
	234	1	8.114	0.5	0	0	1	1.0671641	-4.7879123	110	1	1.12	0.95	92.8043	-0.7724	0.0000	0.0000;
	235	1	22.54	23	0	0	1	1.0400993	1.1035204	110	1	1.12	0.95	90.0587	0.5944	0.0000	0.0000;
	236	1	2.975	0.5	0	0	1	1.0598076	-11.841264	110	1	1.12	0.95	96.7137	-0.0893	0.0000	0.0000;
	237	1	4.057	1.78	0	0	1	1.1063548	-1.8134633	110	1	1.12	0.95	90.7875	0.0600	0.0000	0.0000;
	238	1	2.975	0.6	0	0	1	1.0594281	-11.893654	110	1	1.12	0.95	96.7725	-0.0936	0.0000	0.0000;
	239	1	2.254	1	0	0	1	1.0630405	-10.172291	110	1	1.12	0.95	95.3240	-0.3199	0.0000	0.0000;
	240	2	0	0	0	0	1	1.0586651	-10.018095	110	1	1.12	0.95	95.2580	0.0000	0.0000	0.0000;
	241	1	4.959	0.8	0	0	1	1.0677927	-13.754947	110	1	1.12	0.95	97.4442	0.0319	0.0000	0.0000;
	242	1	2.074	0.83	0	0	1	1.1041633	-2.3992098	110	1	1.12	0.95	91.2599	0.0271	0.0000	0.0000;
	243	1	3.336	0.4	0	0	1	1.1105617	-1.4045479	110	1	1.12	0.95	90.2912	-0.1998	0.0000	0.0000;
	244	1	3.336	0.4	0	0	1	1.1105779	-1.3931101	110	1	1.12	0.95	90.2904	-0.1986	0.0000	0.0000;
	245	1	1.623	1.5	0	0	1	1.0671566	-8.2948353	110	1	1.12	0.95	94.1273	0.0272	0.0000	0.0000;
	246	1	0	0	0	0	1	1.0602751	2.6684546	110	1	1.12	0.95	89.5292	0.0245	0.0000	0.0000;
	247	2	0	5	0	0	1	1.0458785	6.1713406	22	1	1.12	0.95	89.6459	0.0018	0.0000	0.0000;
	248	1	3.606	1	0	0	1	1.0641563	-13.288623	110	1	1.12	0.95	97.2708	-0.4735	0.0000	0.0000;
	249	1	1.352	0	0	0	1	1.0644642	-13.773286	110	1	1.12	0.95	96.6748	-0.2285	0.0000	0.0000;
	250	1	1.352	0	0	0	1	1.0672627	-12.752462	110	1	1.12	0.95	96.5880	-0.4438	0.0000	0.0000;
	251	1	1.352	0	0	0	1	1.0557569	-15.529258	110	1	1.12	0.95	99.9635	-0.9190	0.0000	0.0000;
	252	1	1.984	0.3	0	0	1	1.0728371	-9.0955636	110	1	1.12	0.95	93.9211	-0.1343	0.0000	0.0000;
	253	1	9.016	5	0	0	1	1.0606046	-5.9132576	110	1	1.12	0.95	92.5923	-0.1218	0.0000	0.0000;
	254	1	8.565	4	0	0	1	1.0621711	-9.0866345	110	1	1.12	0.95	94.1885	-0.0400	0.0000	0.0000;
	255	1	5.41	1	0	0	1	1.0598153	-15.516896	110	1	1.12	0.95	98.3593	-0.1944	0.0000	0.0000;
	256	1	7.213	1	0	0	1	1.0683952	-12.244653	110	1	1.12	0.95	96.1385	-0.5324	0.0000	0.0000;
	257	1	2.254	0	0	0	1	1.06844	-12.377538	110	1	1.12	0.95	96.1929	-0.5082	0.0000	0.0000;
	258	1	2.029	0.5	0	0	1	1.0574581	1.8667521	110	1	1.12	0.95	90.0240	0.0118	0.0000	0.0000;
	259	1	2.029	0.5	0	0	1	1.0574535	1.8633465	110	1	1.12	0.95	90.0251	0.0118	0.0000	0.0000;
	260	1	4.418	1.78	0	0	1	1.1001124	-2.3890269	110	1	1.12	0.95	91.6881	0.1817	0.0000	0.0000;
	261	1	2.254	0	0	0	1	1.0561894	-15.7444	110	1	1.12	0.95	100.1731	-1.0187	0.0000	0.0000;
	262	1	4.869	2.1	0	0	1	1.0672339	-8.8338643	110	1	1.12	0.95	93.8790	-0.2318	0.0000	0.0000;
	263	1	0	0	0	0	1	1.0663578	-8.0685318	110	1	1.12	0.95	93.4920	-0.3554	0.0000	0.0000;
	264	1	0.721	0.8	0	0	1	1.0602373	-12.54868	110	1	1.12	0.95	97.0585	-0.0204	0.0000	0.0000;
	265	1	19.835	20	0	0	1	1.0579933	2.2804579	110	1	1.12	0.95	89.6862	0.0503	0.0000	0.0000;
	266	1	31.555	33	0	0	1	1.0483536	0.64828384	110	1	1.12	0.95	89.9849	0.5656	0.0000	0.0000;
	267	1	24.344	0.9	0	0	1	1.0626117	2.5718837	110	1	1.12	0.95	89.5755	-0.0782	0.0000	0.0000;
	268	1	0.902	0	0	0	1	1.0620494	-8.8523377	110	1	1.12	0.95	94.0508	-0.0768	0.0000	0.0000;
	269	1	3.967	0.1	0	0	1	1.0687535	-8.8464726	110	1	1.12	0.95	94.1106	-0.2198	0.0000	0.0000;
	270	1	3.336	1.4	0	0	1	1.0735858	-9.0220168	110	1	1.12	0.95	93.8432	-0.0761	0.0000	0.0000;
	271	1	4.508	1	0	0	1	1.0756255	-9.4207268	110	1	1.12	0.95	94.4927	-1.1138	0.0000	0.0000;
	272	1	4.058	0.5	0	0	1	1.0550882	-15.313103	110	1	1.12	0.95	99.7690	-0.8184	0.0000	0.0000;
	273	1	5.229	1.45	0	0	1	1.0604688	-8.9059181	110	1	1.12	0.95	94.1291	-0.0662	0.0000	0.0000;
	274	1	0.36	0.1	0	0	1	1.0589226	-9.4004367	110	1	1.12	0.95	94.9418	0.1108	0.0000	0.0000;
	275	1	0.09	0.03	0	0	1	1.0664496	-8.7620881	110	1	1.12	0.95	93.7057	-0.2359	0.0000	0.0000;
	276	1	0	0	0	0	1	1.0656964	-8.8974965	110	1	1.12	0.95	93.8232	-0.2324	0.0000	0.0000;
	277	1	6.311	3.59	0	0	1	1.1102271	-1.3882202	110	1	1.12	0.95	90.6921	-0.0018	0.0000	0.0000;
	278	1	0	0	0	0	1	1.1061831	-1.9362589	110	1	1.12	0.95	90.7613	-0.0044	0.0000	0.0000;
	279	1	3.606	1.4	0	0	1	1.1012989	-2.7803264	110	1	1.12	0.95	91.7866	-0.0614	0.0000	0.0000;
	280	1	1.352	0.5	0	0	1	1.0757873	-9.613712	110	1	1.12	0.95	94.1945	-0.7567	0.0000	0.0000;
	281	1	2.705	0	0	0	1	1.0673377	-10.112989	110	1	1.12	0.95	94.9829	-0.2707	0.0000	0.0000;
	282	1	2.705	1	0	0	1	1.0674273	-8.7364977	110	1	1.12	0.95	93.6580	-0.2764	0.0000	0.0000;
	283	1	3.606	1	0	0	1	1.0655353	-8.635639	110	1	1.12	0.95	94.0075	-0.4332	0.0000	0.0000;
	284	1	16.229	16	0	0	1	1.0367171	0.49741921	110	1	1.12	0.95	90.1899	0.7357	0.0000	0.0000;
	285	1	40.572	42	0	0	1	1.0364355	0.49803562	110	1	1.12	0.95	90.1947	0.7387	0.0000	0.0000;
	286	1	0.992	0.3	0	0	1	1.0663208	2.4644553	110	1	1.12	0.95	89.5935	-0.3889	0.0000	0.0000;
	287	1	0	0	0	0	1	1.0593185	2.191025	110	1	1.12	0.95	89.7084	0.0083	0.0000	0.0000;
	288	1	4.779	2.1	0	0	1	1.1098076	-1.3027273	110	1	1.12	0.95	90.6496	0.0407	0.0000	0.0000;
	289	1	4.959	1.2	0	0	1	1.1071623	-1.7679207	110	1	1.12	0.95	91.0719	0.0392	0.0000	0.0000;
	290	1	4.508	1.5	0	0	1	1.0640106	-12.208117	110	1	1.12	0.95	96.4731	-0.2454	0.0000	0.0000;
	291	1	2.705	1	0	0	1	1.0753446	-10.382814	110	1	1.12	0.95	94.5387	-0.7848	0.0000	0.0000;
	292	1	2.524	2	0	0	1	1.0598758	-9.6108902	110	1	1.12	0.95	94.8810	-0.0927	0.0000	0.0000;
	293	1	1.443	0.4	0	0	1	1.1047431	-3.314001	110	1	1.12	0.95	92.0648	0.1369	0.0000	0.0000;
	294	1	9.466	4.2	0	0	1	1.0660674	-8.5863416	110	1	1.12	0.95	93.9546	-0.4454	0.0000	0.0000;
	295	1	7.213	2.5	0	0	1	1.0675095	-8.8077158	110	1	1.12	0.95	93.7591	-0.2593	0.0000	0.0000;
	296	1	2.795	1.13	0	0	1	1.1101307	-1.180001	110	1	1.12	0.95	90.5410	0.0599	0.0000	0.0000;
	297	1	1.406	1.1	0	0	1	1.0655308	-7.3218473	110	1	1.12	0.95	93.2428	-0.3208	0.0000	0.0000;
	298	1	2.164	0.4	0	0	1	1.0667209	-9.1952347	110	1	1.12	0.95	94.4564	-0.2277	0.0000	0.0000;
	299	1	3.787	0.5	0	0	1	1.104218	-3.3461992	110	1	1.12	0.95	92.1149	0.1274	0.0000	0.0000;
	300	1	3.606	0.7	0	0	1	1.1052561	-2.3562983	110	1	1.12	0.95	91.3466	-0.0446	0.0000	0.0000;
	301	1	2.885	1.27	0	0	1	1.1044809	-1.982926	110	1	1.12	0.95	91.1945	0.0934	0.0000	0.0000;
	302	1	4.598	1.85	0	0	1	1.1020999	-2.8626572	110	1	1.12	0.95	91.7399	0.0815	0.0000	0.0000;
	303	1	5.409	1	0	0	1	1.0779137	-9.3797859	110	1	1.12	0.95	94.0152	-0.9574	0.0000	0.0000;
	304	1	0	0	0	0	1	1.1064471	-1.9404173	110	1	1.12	0.95	90.7613	-0.0175	0.0000	0.0000;
	305	1	2.705	1	0	0	1	1.0472103	-0.11118547	110	1	1.12	0.95	91.4196	0.0604	0.0000	0.0000;
	306	1	5.86	2.57	0	0	1	1.1100905	-1.1803039	110	1	1.12	0.95	90.5418	0.0616	0.0000	0.0000;
	307	1	3.877	1.56	0	0	1	1.1041943	-2.3749988	110	1	1.12	0.95	91.2341	0.0289	0.0000	0.0000;
	308	1	5.229	2.11	0	0	1	1.1099847	-1.3353919	110	1	1.12	0.95	90.6608	0.0278	0.0000	0.0000;
	309	1	6.401	2.58	0	0	1	1.1040489	-2.0127486	110	1	1.12	0.95	91.2412	0.1043	0.0000	0.0000;
	310	2	8.934	4.46	0	0	1	1.1062873	-1.8446954	110	1	1.12	0.95	90.9502	0.0545	0.0000	0.0000;
	311	1	0.847	0.56	0	0	1	1.1042669	-1.9987839	110	1	1.12	0.95	91.2336	0.0974	0.0000	0.0000;
	312	2	7.57	3.66	0	0	1	1.1042288	-2.6033881	110	1	1.12	0.95	91.4685	0.0000	0.0000	0.0000;
	313	1	0	0	0	0	1	1.1043265	-1.9937813	110	1	1.12	0.95	91.2118	0.0972	0.0000	0.0000;
	314	2	4.173	2.02	0	0	1	1.1104713	-1.3393921	110	1	1.12	0.95	90.6475	0.0000	0.0000	0.0000;
	315	1	9.025	4.72	0	0	1	1.104729	-1.9575494	110	1	1.12	0.95	90.8803	0.0795	0.0000	0.0000;
	316	1	4.418	0.6	0	0	1	1.104486	-3.1735555	110	1	1.12	0.95	91.9648	0.1127	0.0000	0.0000;
	317	1	1.352	0.5	0	0	1	1.077129	-9.4176267	110	1	1.12	0.95	94.2783	-1.1021	0.0000	0.0000;
	318	1	2.254	1	0	0	1	1.057375	-9.8647569	110	1	1.12	0.95	95.1121	0.0448	0.0000	0.0000;
	319	1	2.254	1.25	0	0	1	1.0573559	-9.9856988	110	1	1.12	0.95	95.2484	0.0456	0.0000	0.0000;
	320	1	3.606	1.25	0	0	1	1.057331	-9.9831188	110	1	1.12	0.95	95.2469	0.0449	0.0000	0.0000;
	321	1	4.057	2	0	0	1	1.0629616	-8.7478262	110	1	1.12	0.95	93.8347	-0.1126	0.0000	0.0000;
	322	1	4.057	1.63	0	0	1	1.1099623	-1.2971315	110	1	1.12	0.95	90.6308	0.0399	0.0000	0.0000;
	323	2	7.213	2.9	0	0	1	1.1098701	-1.4068222	110	1	1.12	0.95	90.7163	0.0092	0.0000	0.0000;
	324	1	4.959	2.5	0	0	1	1.0657965	-10.333349	110	1	1.12	0.95	95.2327	-0.2118	0.0000	0.0000;
	325	1	6.582	2.89	0	0	1	1.1048546	-1.9424859	110	1	1.12	0.95	90.8736	0.0811	0.0000	0.0000;
	326	1	2.344	0.94	0	0	1	1.1060586	-1.8604191	110	1	1.12	0.95	90.9679	0.0608	0.0000	0.0000;
	327	1	2.344	0.94	0	0	1	1.1055952	-1.8957516	110	1	1.12	0.95	91.0288	0.0709	0.0000	0.0000;
	328	1	5.409	2.5	0	0	1	1.0667576	-10.124623	110	1	1.12	0.95	95.0158	-0.2288	0.0000	0.0000;
	329	1	7.663	2	0	0	1	1.0635491	-9.3933582	110	1	1.12	0.95	94.7703	-0.1284	0.0000	0.0000;
	330	1	5.139	2.07	0	0	1	1.1055754	-1.8974257	110	1	1.12	0.95	91.0311	0.0714	0.0000	0.0000;
	331	1	3.606	1.4	0	0	1	1.1052886	-2.2404219	110	1	1.12	0.95	91.2150	0.0282	0.0000	0.0000;
	332	1	2.254	0.8	0	0	1	1.1050919	-2.2900257	110	1	1.12	0.95	91.2640	0.0256	0.0000	0.0000;
	333	1	11.451	4.61	0	0	1	1.1092151	-1.4528193	110	1	1.12	0.95	90.7661	0.0270	0.0000	0.0000;
	334	1	6.312	1	0	0	1	1.0766316	-4.1813476	110	1	1.12	0.95	91.2358	-1.3949	0.0000	0.0000;
	335	1	1.803	0.5	0	0	1	1.0993688	-2.4588033	110	1	1.12	0.95	91.8067	0.1850	0.0000	0.0000;
	336	1	3.606	0.6	0	0	1	1.0630718	-9.4331398	110	1	1.12	0.95	94.8366	-0.1196	0.0000	0.0000;
	337	1	2.164	0.2	0	0	1	1.0728743	-14.369106	110	1	1.12	0.95	97.7331	0.2749	0.0000	0.0000;
	338	1	3.606	1.45	0	0	1	1.1044595	-2.2621139	110	1	1.12	0.95	91.1345	0.0229	0.0000	0.0000;
	339	1	5.41	2.4	0	0	1	1.0587106	-10.191053	110	1	1.12	0.95	95.5832	-0.1120	0.0000	0.0000;
	340	1	4.959	1.65	0	0	1	1.0656452	-8.7989226	110	1	1.12	0.95	93.7713	-0.2043	0.0000	0.0000;
	341	1	4.959	1.65	0	0	1	1.0576934	-9.0327049	110	1	1.12	0.95	94.3870	0.0122	0.0000	0.0000;
	342	1	1.803	0.5	0	0	1	1.0782007	-9.3631259	110	1	1.12	0.95	94.0949	-1.0765	0.0000	0.0000;
	343	1	0	0	0	0	1	1.0703317	-8.5530561	110	1	1.12	0.95	93.4251	-0.3688	0.0000	0.0000;
	344	1	0	0	0	0	1	1.0737921	-8.0385883	110	1	1.12	0.95	93.3132	-0.6707	0.0000	0.0000;
	345	1	7.212	3.5	0	0	1	1.0643095	-7.7077122	110	1	1.12	0.95	93.6870	-0.4323	0.0000	0.0000;
	346	1	6.762	2.5	0	0	1	1.0644199	-7.7113063	110	1	1.12	0.95	93.6798	-0.4305	0.0000	0.0000;
	347	1	0	0	0	0	1	1.0705373	-8.557301	110	1	1.12	0.95	93.4250	-0.3826	0.0000	0.0000;
	348	1	2.704	0.5	0	0	1	1.0589967	-16.690804	110	1	1.12	0.95	99.3010	-0.1319	0.0000	0.0000;
	349	1	3.606	1	0	0	1	1.0603417	-9.2429201	110	1	1.12	0.95	95.2028	0.0308	0.0000	0.0000;
	350	1	3.787	0.5	0	0	1	1.0612656	-13.486876	110	1	1.12	0.95	97.6233	0.0190	0.0000	0.0000;
	351	1	5.5	2.21	0	0	1	1.1101218	-1.1855607	110	1	1.12	0.95	90.5502	0.0586	0.0000	0.0000;
	352	1	4.328	1.2	0	0	1	1.0596705	-9.1918243	110	1	1.12	0.95	94.3243	-0.0028	0.0000	0.0000;
	353	1	0	0	0	0	1	1.0650706	-8.6128648	110	1	1.12	0.95	93.6116	-0.1599	0.0000	0.0000;
	354	1	2.705	1	0	0	1	1.0717473	-10.892622	110	1	1.12	0.95	95.2429	-0.7186	0.0000	0.0000;
	355	1	0	0	0	0	1	1.0664847	-8.5869462	110	1	1.12	0.95	93.6010	-0.2242	0.0000	0.0000;
	356	1	0	0	0	0	1	1.0659608	-8.3970248	110	1	1.12	0.95	93.5053	-0.2143	0.0000	0.0000;
	357	1	0.902	0.3	0	0	1	1.0660313	-8.3876952	110	1	1.12	0.95	93.4984	-0.2141	0.0000	0.0000;
	358	1	0	0	0	0	1	1.0659617	-8.3977241	110	1	1.12	0.95	93.5058	-0.2144	0.0000	0.0000;
	359	1	3.156	1.2	0	0	1	1.0645435	-7.5647944	110	1	1.12	0.95	93.5090	-0.3662	0.0000	0.0000;
	360	1	4.959	1.8	0	0	1	1.0582332	-9.4555362	110	1	1.12	0.95	95.0043	0.1453	0.0000	0.0000;
	361	1	4.327	0.8	0	0	1	1.0712294	-8.1415522	110	1	1.12	0.95	93.4800	-0.1421	0.0000	0.0000;
	362	1	0	0	0	0	1	1.0700208	-8.2539684	110	1	1.12	0.95	93.1689	-0.2897	0.0000	0.0000;
	363	1	0	0	0	0	1	1.0698133	-8.2776053	110	1	1.12	0.95	93.1810	-0.2869	0.0000	0.0000;
	364	1	3.607	0.6	0	0	1	1.0680912	-5.2926755	110	1	1.12	0.95	93.1268	-0.8660	0.0000	0.0000;
	365	1	2.705	0.8	0	0	1	1.0662301	-8.4108586	110	1	1.12	0.95	94.2478	0.0406	0.0000	0.0000;
	366	2	40.572	10	0	0	1	1.072833	-8.9924361	110	1	1.12	0.95	93.8344	0.0000	0.0000	0.0000;
	367	2	40.572	10	0	0	1	1.0685587	-8.0927304	110	1	1.12	0.95	93.4746	0.0000	0.0000	0.0000;
	368	2	40.572	10	0	0	1	1.0758187	-8.8469536	110	1	1.12	0.95	93.6481	0.0000	0.0000	0.0000;
	369	2	40.572	10	0	0	1	1.0722446	-7.7204629	110	1	1.12	0.95	93.3527	-0.0144	0.0000	0.0000;
	370	1	0	0	0	0	1	1.0878394	-8.5627076	110	1	1.12	0.95	93.0280	-1.3279	0.0000	0.0000;
	371	1	5.229	0.8	0	0	1	1.0585279	-10.633875	110	1	1.12	0.95	95.7341	-0.0016	0.0000	0.0000;
	372	1	10.819	0.5	0	0	1	1.0606393	-11.725844	110	1	1.12	0.95	96.5874	-0.0870	0.0000	0.0000;
	373	1	3.156	1	0	0	1	1.0604161	-13.94088	110	1	1.12	0.95	97.7927	-0.0840	0.0000	0.0000;
	374	1	0	0	0	0	1	1.063942	-10.852906	110	1	1.12	0.95	95.8349	-0.2558	0.0000	0.0000;
	375	1	9.016	2.5	0	0	1	1.0570387	-10.065027	110	1	1.12	0.95	95.3985	0.0637	0.0000	0.0000;
	376	1	1.262	0.4	0	0	1	1.1067971	-1.8175327	110	1	1.12	0.95	91.1214	0.0429	0.0000	0.0000;
	377	1	1.533	0.6	0	0	1	1.0994615	-2.5587462	110	1	1.12	0.95	91.0907	-0.1021	0.0000	0.0000;
	378	1	4.508	1	0	0	1	1.0590272	-14.272288	110	1	1.12	0.95	98.5485	-0.6033	0.0000	0.0000;
	379	1	4.057	0.5	0	0	1	1.0613994	-13.202591	110	1	1.12	0.95	97.3305	0.0465	0.0000	0.0000;
	380	1	3.606	1.1	0	0	1	1.067313	-4.678564	110	1	1.12	0.95	92.7192	-0.7607	0.0000	0.0000;
	381	1	3.787	0.8	0	0	1	1.0673826	-4.6867404	110	1	1.12	0.95	92.7161	-0.7620	0.0000	0.0000;
	382	1	1.803	1	0	0	1	1.0574035	-10.071257	110	1	1.12	0.95	95.3714	0.0475	0.0000	0.0000;
	383	1	8.295	2	0	0	1	1.0668044	-8.3647742	110	1	1.12	0.95	94.2166	0.0204	0.0000	0.0000;
	384	1	5.41	1.5	0	0	1	1.0674199	-8.3212446	110	1	1.12	0.95	94.1295	0.0100	0.0000	0.0000;
	385	1	10.82	3.5	0	0	1	1.0583048	-10.518236	110	1	1.12	0.95	95.8158	-0.0842	0.0000	0.0000;
	386	2	0	0	0	0	1	1.0683517	-8.1797938	110	1	1.12	0.95	94.0072	0.0000	0.0000	0.0000;
	387	2	0	0	0	0	1	1.0656811	-10.584421	110	1	1.12	0.95	95.3695	-0.1532	0.0000	0.0000;
	388	1	1.803	0.5	0	0	1	1.0703809	-11.420886	110	1	1.12	0.95	95.6010	-0.6513	0.0000	0.0000;
	389	1	5.59	2.8	0	0	1	1.0677262	-8.7138749	110	1	1.12	0.95	93.6329	-0.2847	0.0000	0.0000;
	390	1	7.303	2.94	0	0	1	1.1026018	-3.1309224	110	1	1.12	0.95	91.9679	0.1219	0.0000	0.0000;
	391	1	3.967	1.7	0	0	1	1.0661828	-8.6787001	110	1	1.12	0.95	93.6862	-0.2085	0.0000	0.0000;
	392	1	6.762	3.42	0	0	1	1.1107837	-1.1334655	110	1	1.12	0.95	90.4900	0.0426	0.0000	0.0000;
	393	1	1.082	0.48	0	0	1	1.1085958	-1.6425374	110	1	1.12	0.95	90.6226	0.0154	0.0000	0.0000;
	394	1	0	0	0	0	1	1.0589117	0.8834572	110	1	1.12	0.95	89.7756	0.3493	0.0000	0.0000;
	395	1	0	0	0	0	1	1.0592778	2.1925895	110	1	1.12	0.95	89.7083	0.0119	0.0000	0.0000;
	396	1	3.156	0.3	0	0	1	1.0732673	-8.0413644	110	1	1.12	0.95	93.5967	-0.1512	0.0000	0.0000;
	397	1	0	0	0	0	1	1.0621309	-9.2642663	110	1	1.12	0.95	94.8806	0.0346	0.0000	0.0000;
	398	1	2.705	1	0	0	1	1.1084427	-2.6964211	110	1	1.12	0.95	91.4807	0.0000	0.0000	0.0000;
	399	1	2.434	0.5	0	0	1	1.0723449	-8.0697274	110	1	1.12	0.95	93.3922	-0.1776	0.0000	0.0000;
	400	1	0	0	0	0	1	1.0751332	-7.7584234	110	1	1.12	0.95	93.3437	-0.1667	0.0000	0.0000;
	401	1	1.713	0.5	0	0	1	1.0739411	-9.0058663	110	1	1.12	0.95	93.8233	-0.0719	0.0000	0.0000;
	402	1	0	0	0	0	1	1.0709806	-8.3702359	110	1	1.12	0.95	93.6750	-0.1956	0.0000	0.0000;
	403	1	2.885	0.8	0	0	1	1.0609655	-9.4183649	110	1	1.12	0.95	94.6917	-0.1528	0.0000	0.0000;
	404	1	2.164	0.2	0	0	1	1.0695942	-5.6138481	110	1	1.12	0.95	93.2794	-0.9372	0.0000	0.0000;
	405	1	19.565	6	0	0	1	1.0696645	-8.719327	110	1	1.12	0.95	93.6256	-0.3251	0.0000	0.0000;
	406	1	17.852	3.8	0	0	1	1.0661786	-8.0634088	110	1	1.12	0.95	93.4921	-0.3387	0.0000	0.0000;
	407	1	4.057	0.4	0	0	1	1.0691305	-0.54906011	110	1	1.12	0.95	90.2190	-0.0682	0.0000	0.0000;
	408	1	3.156	0.3	0	0	1	1.0526355	0.62332972	110	1	1.12	0.95	90.6211	0.0025	0.0000	0.0000;
	409	1	3.606	0.5	0	0	1	1.0630997	-13.251619	110	1	1.12	0.95	97.0086	-0.1289	0.0000	0.0000;
	410	1	4.057	0.5	0	0	1	1.0680288	-0.4274132	110	1	1.12	0.95	90.1838	-0.0168	0.0000	0.0000;
	411	1	4.418	0.7	0	0	1	1.0716119	-8.1252047	110	1	1.12	0.95	93.4576	-0.1570	0.0000	0.0000;
	412	1	5.409	1.5	0	0	1	1.0604145	-6.3477996	110	1	1.12	0.95	92.9440	-0.1637	0.0000	0.0000;
	413	1	2.164	0.5	0	0	1	1.0709396	-8.3695374	110	1	1.12	0.95	93.6750	-0.1933	0.0000	0.0000;
	414	1	0	0	0	0	1	1.0775715	-8.8649288	110	1	1.12	0.95	93.6382	-0.0908	0.0000	0.0000;
	415	1	0	0	0	0	1	1.0707852	-8.1115612	110	1	1.12	0.95	93.4595	-0.1119	0.0000	0.0000;
	416	1	6.312	0.699	0	0	1	1.0533039	0.77124675	110	1	1.12	0.95	90.5301	0.0049	0.0000	0.0000;
	417	1	5.41	2	0	0	1	1.0568398	-10.089044	110	1	1.12	0.95	95.4239	0.0713	0.0000	0.0000;
	418	1	2.254	0.1	0	0	1	1.0720084	-8.097654	110	1	1.12	0.95	93.4239	-0.1690	0.0000	0.0000;
	419	1	8.835	0.7	0	0	1	1.0625752	-9.5162864	110	1	1.12	0.95	94.9371	-0.0419	0.0000	0.0000;
	420	1	1.984	0.3	0	0	1	1.1087231	-2.683684	110	1	1.12	0.95	91.4517	-0.0099	0.0000	0.0000;
	421	1	3.246	0.5	0	0	1	1.0660303	-8.4752998	110	1	1.12	0.95	94.3380	0.0202	0.0000	0.0000;
	422	1	6.672	2.22	0	0	1	1.0601031	-8.9537151	110	1	1.12	0.95	94.2092	-0.0847	0.0000	0.0000;
	423	1	6.672	2.22	0	0	1	1.0600832	-8.9575983	110	1	1.12	0.95	94.2105	-0.0844	0.0000	0.0000;
	424	1	3.155	0.5	0	0	1	1.0618731	-8.915551	110	1	1.12	0.95	94.0985	-0.0673	0.0000	0.0000;
	425	1	5.229	2.3	0	0	1	1.0622327	-8.786263	110	1	1.12	0.95	94.0004	-0.0854	0.0000	0.0000;
	426	1	5.68	2.5	0	0	1	1.0597726	-11.662789	110	1	1.12	0.95	96.5282	-0.0765	0.0000	0.0000;
	427	1	3.786	0.6	0	0	1	1.0578521	-9.6570271	110	1	1.12	0.95	95.5552	0.0305	0.0000	0.0000;
	428	1	6.311	1.2	0	0	1	1.0586523	-9.3020157	110	1	1.12	0.95	94.6421	-0.1741	0.0000	0.0000;
	429	1	3.606	2	0	0	1	1.0630761	-8.6674847	110	1	1.12	0.95	93.8790	-0.1139	0.0000	0.0000;
	430	1	5.68	2.29	0	0	1	1.1096858	-1.2272484	110	1	1.12	0.95	90.5968	0.0668	0.0000	0.0000;
	431	1	0	0	0	0	1	1.1096927	-1.2276346	110	1	1.12	0.95	90.5969	0.0667	0.0000	0.0000;
	432	1	5.229	0.9	0	0	1	1.0562305	1.6073848	110	1	1.12	0.95	90.2688	0.0016	0.0000	0.0000;
	433	1	2.074	0.2	0	0	1	1.0715245	-8.2330798	110	1	1.12	0.95	93.5539	-0.1856	0.0000	0.0000;
	434	1	4.959	1.8	0	0	1	1.0856234	-3.316181	110	1	1.12	0.95	92.1236	0.0388	0.0000	0.0000;
	435	1	4.328	0.8	0	0	1	1.067892	-10.532382	110	1	1.12	0.95	95.3413	-0.0779	0.0000	0.0000;
	436	1	2.975	1.2	0	0	1	1.105817	-1.8374518	110	1	1.12	0.95	91.1158	0.0693	0.0000	0.0000;
	437	1	6.131	2.5	0	0	1	1.051396	-9.7614753	110	1	1.12	0.95	95.3778	0.0735	0.0000	0.0000;
	438	1	4.508	2	0	0	1	1.0514699	-10.259753	110	1	1.12	0.95	96.2636	0.2575	0.0000	0.0000;
	439	1	0	0	0	0	1	1.0562535	1.6049792	110	1	1.12	0.95	90.2706	-0.0002	0.0000	0.0000;
	440	1	9.918	2	0	0	1	1.0933412	-3.631467	110	1	1.12	0.95	92.2773	-0.1611	0.0000	0.0000;
	441	1	4.508	0.5	0	0	1	1.0550616	-15.332863	110	1	1.12	0.95	99.7300	-0.7982	0.0000	0.0000;
	442	1	1.082	0.2	0	0	1	1.0593613	2.4671181	110	1	1.12	0.95	89.6103	0.0314	0.0000	0.0000;
	443	1	1.172	0.3	0	0	1	1.0592746	2.4536233	110	1	1.12	0.95	89.6139	0.0323	0.0000	0.0000;
	444	2	2.254	1	0	0	1	1.0562503	1.6050409	110	1	1.12	0.95	90.2706	0.0000	0.0000	0.0000;
	445	1	1.623	0.1	0	0	1	1.0486981	0.02596318	110	1	1.12	0.95	91.2534	0.0276	0.0000	0.0000;
	446	1	1.623	0.71	0	0	1	1.1072187	-1.7675201	110	1	1.12	0.95	90.8121	0.0399	0.0000	0.0000;
	447	1	6.492	2.61	0	0	1	1.1030077	-2.1140651	110	1	1.12	0.95	91.3775	0.1233	0.0000	0.0000;
	448	1	3.156	0.4	0	0	1	1.1077008	-1.9027064	110	1	1.12	0.95	90.9079	-0.1267	0.0000	0.0000;
	449	1	1.172	0.3	0	0	1	1.0796884	-3.828	110	1	1.12	0.95	92.1801	-0.1915	0.0000	0.0000;
	450	1	3.606	1.5	0	0	1	1.1052294	-2.6197372	110	1	1.12	0.95	91.5542	-0.0051	0.0000	0.0000;
	451	1	0	0	0	0	1	1.0664141	-7.16584	110	1	1.12	0.95	93.0692	-0.3059	0.0000	0.0000;
	452	1	2.904	0	0	0	1	1.0675952	-6.6985089	110	1	1.12	0.95	92.7481	-0.3459	0.0000	0.0000;
	453	2	5.501	0.2	0	0	1	1.0689877	-6.2048001	110	1	1.12	0.95	92.3977	-0.3884	0.0000	0.0000;
	454	1	1.803	0.5	0	0	1	1.0541505	-15.411053	110	1	1.12	0.95	99.9636	-0.8311	0.0000	0.0000;
	455	1	2.704	1.1	0	0	1	1.0580099	-9.9276504	110	1	1.12	0.95	95.4073	0.0173	0.0000	0.0000;
	456	1	7.663	3	0	0	1	1.0653277	-8.3494879	110	1	1.12	0.95	93.6193	-0.2652	0.0000	0.0000;
	457	1	0.902	0.1	0	0	1	1.1105465	-1.4512284	110	1	1.12	0.95	90.3704	-0.1743	0.0000	0.0000;
	458	1	6.762	1.8	0	0	1	1.1031077	-2.2197435	110	1	1.12	0.95	91.5324	0.1059	0.0000	0.0000;
	459	1	4.508	1	0	0	1	1.0617238	-9.6626412	110	1	1.12	0.95	94.5955	-0.0092	0.0000	0.0000;
	460	1	6.671	1.3	0	0	1	1.0722599	-8.1679058	110	1	1.12	0.95	93.4450	-0.6176	0.0000	0.0000;
	461	1	4.057	0.4	0	0	1	1.0668982	-9.2048482	110	1	1.12	0.95	94.4258	-0.2267	0.0000	0.0000;
	462	1	1.984	0.5	0	0	1	1.1039668	-3.3724119	110	1	1.12	0.95	92.1443	0.1316	0.0000	0.0000;
	463	1	8.114	1.5	0	0	1	1.0612041	-8.7983641	110	1	1.12	0.95	95.1332	-0.6107	0.0000	0.0000;
	464	1	4.508	2.5	0	0	1	1.0679561	-4.0682502	110	1	1.12	0.95	91.3274	-0.6366	0.0000	0.0000;
	465	1	4.508	1	0	0	1	1.0690112	-8.9457582	110	1	1.12	0.95	93.8330	-0.1724	0.0000	0.0000;
	466	1	4.508	1.1	0	0	1	1.0690407	-8.9332096	110	1	1.12	0.95	93.8287	-0.1737	0.0000	0.0000;
	467	1	8.836	5.3	0	0	1	1.058772	-8.4292053	110	1	1.12	0.95	94.1669	-0.0214	0.0000	0.0000;
	468	1	7.213	1	0	0	1	1.101421	-2.8144771	110	1	1.12	0.95	91.8146	-0.0389	0.0000	0.0000;
	469	1	3.606	0.4	0	0	1	1.0736963	-10.373396	110	1	1.12	0.95	94.8177	-0.0171	0.0000	0.0000;
	470	1	3.065	1.23	0	0	1	1.1066501	-1.7961785	110	1	1.12	0.95	90.7583	0.0520	0.0000	0.0000;
	471	1	2.344	1	0	0	1	1.0737222	-4.1044427	110	1	1.12	0.95	91.2167	-1.1067	0.0000	0.0000;
	472	1	2.524	1.02	0	0	1	1.1010526	-2.2996866	110	1	1.12	0.95	91.5871	0.1628	0.0000	0.0000;
	473	1	1.082	0.2	0	0	1	1.0692927	-8.6180561	110	1	1.12	0.95	94.1184	-0.1158	0.0000	0.0000;
	474	1	1.803	0.3	0	0	1	1.0514372	0.41433885	110	1	1.12	0.95	90.8262	0.0050	0.0000	0.0000;
	475	1	7.212	0.5	0	0	1	1.0557035	-15.303906	110	1	1.12	0.95	99.5095	-0.7241	0.0000	0.0000;
	476	1	0.902	0.5	0	0	1	1.0640248	-7.7392799	110	1	1.12	0.95	93.7271	-0.4290	0.0000	0.0000;
	477	1	0.902	0.5	0	0	1	1.0685634	-8.4085489	110	1	1.12	0.95	93.7547	-0.5176	0.0000	0.0000;
	478	1	5.409	1	0	0	1	1.0633199	-13.985338	110	1	1.12	0.95	97.0072	-0.2722	0.0000	0.0000;
	479	1	1.984	0.2	0	0	1	1.0718901	-9.1051261	110	1	1.12	0.95	93.9422	-0.1730	0.0000	0.0000;
	480	1	1.082	0.2	0	0	1	1.0706093	-5.7583755	110	1	1.12	0.95	93.3171	-0.9632	0.0000	0.0000;
	481	1	8.114	4	0	0	1	1.0621154	-9.1328468	110	1	1.12	0.95	94.4952	-0.0235	0.0000	0.0000;
	482	1	8.746	3.52	0	0	1	1.1029607	-2.7465116	110	1	1.12	0.95	91.6233	0.0467	0.0000	0.0000;
	483	1	3.606	0.9	0	0	1	1.0650322	-9.1404287	110	1	1.12	0.95	94.2757	-0.0507	0.0000	0.0000;
	484	1	1.352	0.2	0	0	1	1.0703711	-14.08857	110	1	1.12	0.95	97.6124	0.1427	0.0000	0.0000;
	485	1	1.803	0	0	0	1	1.0490697	-9.8607069	110	1	1.12	0.95	95.6178	0.1800	0.0000	0.0000;
	486	2	2.975	0.3	0	0	1	1.0493277	0.07082552	110	1	1.12	0.95	91.1651	0.0153	0.0000	0.0000;
	487	1	2.524	0.3	0	0	1	1.0661505	-2.7875124	110	1	1.12	0.95	91.7329	-0.3936	0.0000	0.0000;
	488	1	3.156	1	0	0	1	1.0482565	-0.00675673	110	1	1.12	0.95	91.3099	0.0377	0.0000	0.0000;
	489	1	3.156	1	0	0	1	1.0656381	-2.8218189	110	1	1.12	0.95	91.7859	-0.3788	0.0000	0.0000;
	490	1	14.876	3.5	0	0	1	1.1114775	-1.2479238	110	1	1.12	0.95	90.1738	-0.1905	0.0000	0.0000;
	491	1	7.664	4.5	0	0	1	1.1082592	-1.124095	110	1	1.12	0.95	90.2892	-0.1541	0.0000	0.0000;
	492	1	1.803	0.6	0	0	1	1.066326	-8.566377	110	1	1.12	0.95	93.6072	-0.2278	0.0000	0.0000;
	493	1	2.705	0.9	0	0	1	1.0661931	-8.6097297	110	1	1.12	0.95	93.6263	-0.2163	0.0000	0.0000;
	494	1	1.803	0.5	0	0	1	1.0801949	-9.1457448	110	1	1.12	0.95	93.6110	-0.9733	0.0000	0.0000;
	495	1	7.664	2.55	0	0	1	1.0619862	-8.7272989	110	1	1.12	0.95	93.9661	-0.1161	0.0000	0.0000;
	496	1	7.664	2.55	0	0	1	1.0620488	-8.7155782	110	1	1.12	0.95	93.9618	-0.1170	0.0000	0.0000;
	497	1	11.27	3.75	0	0	1	1.0648652	-8.6809422	110	1	1.12	0.95	93.7710	-0.2241	0.0000	0.0000;
	498	1	11.27	3.13	0	0	1	1.0582599	-9.3199811	110	1	1.12	0.95	94.4886	0.0293	0.0000	0.0000;
	499	1	1.803	1	0	0	1	1.0588064	-9.9426555	110	1	1.12	0.95	95.1887	-0.0151	0.0000	0.0000;
	500	1	4.508	1.6	0	0	1	1.0619081	-9.6445675	110	1	1.12	0.95	94.5762	-0.0133	0.0000	0.0000;
	501	1	3.876	0.8	0	0	1	1.0559132	-9.3480033	110	1	1.12	0.95	95.2369	-0.0913	0.0000	0.0000;
	502	1	4.508	1.5	0	0	1	1.0599432	-8.9217332	110	1	1.12	0.95	94.2117	-0.0675	0.0000	0.0000;
	503	1	12.622	4.2	0	0	1	1.05708	-9.0136358	110	1	1.12	0.95	94.3749	0.0475	0.0000	0.0000;
	504	1	6.311	2.1	0	0	1	1.0599713	-9.1462917	110	1	1.12	0.95	94.2860	-0.0187	0.0000	0.0000;
	505	1	4.057	1.35	0	0	1	1.0604304	-8.9072035	110	1	1.12	0.95	94.1718	-0.0895	0.0000	0.0000;
	506	1	8.475	2.35	0	0	1	1.0576049	-8.9610357	110	1	1.12	0.95	94.3170	0.0349	0.0000	0.0000;
	507	1	2.254	0.5	0	0	1	1.0558597	-15.937327	110	1	1.12	0.95	100.3724	-1.0674	0.0000	0.0000;
	508	1	22.54	7.5	0	0	1	1.0630229	-8.8669909	110	1	1.12	0.95	93.8684	-0.0949	0.0000	0.0000;
	509	1	45.079	15	0	0	1	1.0652298	-8.6024417	110	1	1.12	0.95	93.5947	-0.1633	0.0000	0.0000;
	510	1	1.172	0.3	0	0	1	1.1062655	-1.5547164	110	1	1.12	0.95	90.5816	-0.1728	0.0000	0.0000;
	511	1	1.172	0.3	0	0	1	1.1062614	-1.5626065	110	1	1.12	0.95	90.5819	-0.1733	0.0000	0.0000;
	512	1	10.549	4.63	0	0	1	1.1049177	-1.9770446	110	1	1.12	0.95	90.8590	0.0552	0.0000	0.0000;
	513	1	0	0	0	0	1	1.1101739	-1.3733172	110	1	1.12	0.95	90.6819	0.0045	0.0000	0.0000;
	514	1	1.803	1	0	0	1	1.058199	-10.013809	110	1	1.12	0.95	95.2614	0.0163	0.0000	0.0000;
	515	1	2.254	0.5	0	0	1	1.0709862	-9.9417994	110	1	1.12	0.95	94.6835	-0.4968	0.0000	0.0000;
	516	1	3.787	1.05	0	0	1	1.0651743	-8.4627906	110	1	1.12	0.95	93.5780	-0.1931	0.0000	0.0000;
	517	1	3.787	1.05	0	0	1	1.0651978	-8.4594207	110	1	1.12	0.95	93.5769	-0.1934	0.0000	0.0000;
	518	1	1.803	0.6	0	0	1	1.058078	-9.3632408	110	1	1.12	0.95	94.5210	0.0255	0.0000	0.0000;
	519	1	0	0	0	0	1	1.0649513	-8.7658208	110	1	1.12	0.95	94.0478	-0.3453	0.0000	0.0000;
	520	1	9.196	2.55	0	0	1	1.0659569	-8.6113426	110	1	1.12	0.95	93.5653	-0.1782	0.0000	0.0000;
	521	1	4.508	1.25	0	0	1	1.064984	-8.4792102	110	1	1.12	0.95	93.5957	-0.1884	0.0000	0.0000;
	522	1	4.508	1.25	0	0	1	1.0657364	-8.6508712	110	1	1.12	0.95	93.6715	-0.2055	0.0000	0.0000;
	523	1	5.049	1.4	0	0	1	1.0535602	-9.6635645	110	1	1.12	0.95	95.1412	-0.0156	0.0000	0.0000;
	524	1	9.467	1	0	0	1	1.105386	-2.0620769	110	1	1.12	0.95	91.1255	-0.2281	0.0000	0.0000;
	525	1	9.918	2.75	0	0	1	1.0657808	-8.6534935	110	1	1.12	0.95	93.7214	-0.2434	0.0000	0.0000;
	526	1	9.918	2.75	0	0	1	1.065807	-8.6483201	110	1	1.12	0.95	93.7197	-0.2437	0.0000	0.0000;
	527	1	8.115	2.25	0	0	1	1.0632008	-8.3764993	110	1	1.12	0.95	93.7743	-0.1923	0.0000	0.0000;
	528	1	18.933	6.3	0	0	1	1.0620926	-8.9315529	110	1	1.12	0.95	94.0572	-0.0765	0.0000	0.0000;
	529	1	5.41	1.8	0	0	1	1.0597655	-9.2706019	110	1	1.12	0.95	94.3738	-0.0358	0.0000	0.0000;
	530	1	3.607	0.8	0	0	1	1.0526303	-9.7141203	110	1	1.12	0.95	95.2451	0.0185	0.0000	0.0000;
	531	1	2.705	0.75	0	0	1	1.0657649	-8.6566329	110	1	1.12	0.95	93.7239	-0.2434	0.0000	0.0000;
	532	1	2.705	0.75	0	0	1	1.0600671	-8.9607694	110	1	1.12	0.95	94.2131	-0.0844	0.0000	0.0000;
	533	1	9.467	3.15	0	0	1	1.0618291	-8.9659901	110	1	1.12	0.95	94.0926	-0.0659	0.0000	0.0000;
	534	1	9.466	3.15	0	0	1	1.0613256	-8.6725661	110	1	1.12	0.95	93.9315	-0.0632	0.0000	0.0000;
	535	1	15.778	5.25	0	0	1	1.0608638	-8.700394	110	1	1.12	0.95	93.9680	-0.0491	0.0000	0.0000;
	536	1	2.254	0.7	0	0	1	1.0706166	-9.0215965	110	1	1.12	0.95	93.8869	-0.1513	0.0000	0.0000;
	537	2	11.557	3.6	0	0	1	1.0632471	-8.8906179	110	1	1.12	0.95	93.9619	-0.1009	0.0000	0.0000;
	538	2	11.961	3.6	0	0	1	1.0620217	-8.5710126	110	1	1.12	0.95	93.8344	-0.0782	0.0000	0.0000;
	539	1	5.41	1.8	0	0	1	1.0616258	-8.5962395	110	1	1.12	0.95	93.8738	-0.0656	0.0000	0.0000;
	540	1	5.41	1.8	0	0	1	1.0628517	-8.915787	110	1	1.12	0.95	94.0013	-0.0883	0.0000	0.0000;
	541	1	9.016	2.5	0	0	1	1.0603377	-9.1071219	110	1	1.12	0.95	94.2500	-0.0314	0.0000	0.0000;
	542	1	8.655	2.4	0	0	1	1.0650936	-8.6763492	110	1	1.12	0.95	93.7589	-0.2299	0.0000	0.0000;
	543	1	8.655	2.4	0	0	1	1.0652193	-8.6697346	110	1	1.12	0.95	93.7535	-0.2310	0.0000	0.0000;
	544	1	10.819	3	0	0	1	1.0621495	-8.9550833	110	1	1.12	0.95	94.0682	-0.0725	0.0000	0.0000;
	545	1	12.803	4.26	0	0	1	1.0614626	-8.9024557	110	1	1.12	0.95	94.2070	-0.1732	0.0000	0.0000;
	546	1	17.581	5.85	0	0	1	1.0659714	-8.6276107	110	1	1.12	0.95	93.7045	-0.2466	0.0000	0.0000;
	547	1	12.622	4.2	0	0	1	1.0598617	-8.9383182	110	1	1.12	0.95	94.2042	-0.0574	0.0000	0.0000;
	548	1	4.779	1.59	0	0	1	1.0659096	-8.6311985	110	1	1.12	0.95	93.6508	-0.2084	0.0000	0.0000;
	549	1	4.778	1.59	0	0	1	1.0680885	-8.8600292	110	1	1.12	0.95	93.7725	-0.2873	0.0000	0.0000;
	550	1	14.426	4	0	0	1	1.0618083	-8.9942044	110	1	1.12	0.95	94.0967	-0.0651	0.0000	0.0000;
	551	1	6.311	2.1	0	0	1	1.0647289	-8.721004	110	1	1.12	0.95	93.7900	-0.1684	0.0000	0.0000;
	552	2	19.835	6.6	0	0	1	1.0582723	-9.3625598	110	1	1.12	0.95	94.5110	0.0144	0.0000	0.0000;
	553	1	0	0	0	0	1	1.058995	-8.9703552	110	1	1.12	0.95	94.2903	-0.0346	0.0000	0.0000;
	554	1	5.409	3	0	0	1	1.0571918	-9.8840514	110	1	1.12	0.95	95.5081	0.1000	0.0000	0.0000;
	555	1	2.705	0.5	0	0	1	1.0612906	-14.91678	110	1	1.12	0.95	97.7876	-0.2064	0.0000	0.0000;
	556	1	6.311	1	0	0	1	1.0679391	-10.07232	110	1	1.12	0.95	94.9647	-0.5277	0.0000	0.0000;
	557	1	2.705	1	0	0	1	1.0565434	-9.9851019	110	1	1.12	0.95	95.6471	0.0785	0.0000	0.0000;
	558	1	0	0	0	0	1	1.0565589	-9.9879671	110	1	1.12	0.95	95.6466	0.0780	0.0000	0.0000;
	559	1	0	0	0	0	1	1.0444362	-9.9853213	110	1	1.12	0.95	96.0089	0.4462	0.0000	0.0000;
	560	2	11.311	3.6	0	0	1	1.0595707	-9.2024482	110	1	1.12	0.95	94.3389	0.0000	0.0000	0.0000;
	561	2	11.312	3.6	0	0	1	1.0601509	-8.9094872	110	1	1.12	0.95	94.1928	-0.0742	0.0000	0.0000;
	562	1	0	0	0	0	1	1.0592776	2.1921618	110	1	1.12	0.95	89.7084	0.0119	0.0000	0.0000;
	563	1	0	0	0	0	1	1.0673712	-9.1345413	110	1	1.12	0.95	94.3541	-0.2302	0.0000	0.0000;
	564	1	0	0	0	0	1	1.0642628	-8.6588409	110	1	1.12	0.95	93.7865	-0.1980	0.0000	0.0000;
	565	1	0	0	0	0	1	1.0625647	2.5821645	110	1	1.12	0.95	89.5688	-0.0748	0.0000	0.0000;
	566	1	0	0	0	0	1	1.0613963	-9.068935	110	1	1.12	0.95	94.3846	-0.2487	0.0000	0.0000;
	567	1	0	0	0	0	1	1.1047532	-1.9650698	110	1	1.12	0.95	91.1685	0.0859	0.0000	0.0000;
	568	1	3.697	0.4	0	0	1	1.0681111	-8.7233415	110	1	1.12	0.95	93.6205	-0.3050	0.0000	0.0000;
	569	1	1.804	1	0	0	1	1.0578732	-9.374695	110	1	1.12	0.95	94.5349	0.0325	0.0000	0.0000;
	570	1	1.803	0.5	0	0	1	1.0613102	-9.0770278	110	1	1.12	0.95	94.3927	-0.2467	0.0000	0.0000;
	571	1	1.803	0.2	0	0	1	1.0649151	-8.7829177	110	1	1.12	0.95	94.5042	0.0172	0.0000	0.0000;
	572	1	6.312	1	0	0	1	1.0662837	-10.214099	110	1	1.12	0.95	95.1915	-0.3741	0.0000	0.0000;
	573	1	4.057	0.4	0	0	1	1.1029906	-2.5113964	110	1	1.12	0.95	91.5394	-0.1485	0.0000	0.0000;
	574	2	7.664	2	0	0	1	1.1044758	-2.5318317	110	1	1.12	0.95	91.4956	0.0000	0.0000	0.0000;
	575	1	4.598	2.33	0	0	1	1.1048167	-1.9649248	110	1	1.12	0.95	91.2047	0.0800	0.0000	0.0000;
	576	1	0	0	0	0	1	1.1025505	-2.8338246	110	1	1.12	0.95	91.7048	0.0682	0.0000	0.0000;
	577	1	2.975	0.8	0	0	1	1.1029463	-2.6820215	110	1	1.12	0.95	91.6619	-0.0136	0.0000	0.0000;
	578	1	0.902	0.2	0	0	1	1.1098061	-1.273161	110	1	1.12	0.95	90.6360	0.0490	0.0000	0.0000;
	579	1	0.902	0.2	0	0	1	1.0580217	0.70619925	110	1	1.12	0.95	89.9478	0.3443	0.0000	0.0000;
	580	1	1.803	0.6	0	0	1	1.0659061	-8.6363964	110	1	1.12	0.95	93.6556	-0.2097	0.0000	0.0000;
	581	1	0.18	0.06	0	0	1	1.0634223	-8.8332875	110	1	1.12	0.95	93.8261	-0.1063	0.0000	0.0000;
	582	1	3.606	1.7	0	0	1	1.082524	-3.5790761	110	1	1.12	0.95	92.1959	-0.0461	0.0000	0.0000;
	583	1	3.787	0.5	0	0	1	1.0693414	-12.33892	110	1	1.12	0.95	96.4500	0.0115	0.0000	0.0000;
	584	1	1.623	0.65	0	0	1	1.1042155	-2.0022553	110	1	1.12	0.95	91.2360	0.0989	0.0000	0.0000;
	585	1	1.803	1	0	0	1	1.055736	-9.1971055	110	1	1.12	0.95	95.1545	-0.0893	0.0000	0.0000;
	586	1	2.705	0.2	0	0	1	1.0651925	-9.3322421	110	1	1.12	0.95	94.6786	-0.2159	0.0000	0.0000;
	587	1	4.508	1.8	0	0	1	1.0584209	-9.443242	110	1	1.12	0.95	94.9841	0.1635	0.0000	0.0000;
	588	1	0	0	0	0	1	1.084878	-2.6608327	110	2	1.12	0.95	90.4363	-2.7894	0.0000	0.0000;
	589	1	1.315	0.143	0	0	1	1.0847165	-2.6710596	110	2	1.12	0.95	90.4438	-2.7948	0.0000	0.0000;
	590	1	1.103	0.477	0	0	1	1.075677	-4.8575651	110	2	1.12	0.95	92.2783	-1.5473	0.0000	0.0000;
	591	1	4.284	0.484	0	0	1	1.0836721	-3.9115871	110	2	1.12	0.95	91.2235	-2.8768	0.0000	0.0000;
	592	1	4.582	0.545	0	0	1	1.0477184	-6.7933701	110	2	1.12	0.95	93.7376	-0.6942	0.0000	0.0000;
	593	1	2.343	0.531	0	0	1	1.0818788	-3.3922237	110	2	1.12	0.95	90.9116	-2.5011	0.0000	0.0000;
	594	1	6.025	0.954	0	0	1	1.0736686	-5.0014842	110	2	1.12	0.95	92.5213	-1.3487	0.0000	0.0000;
	595	1	0	0	0	0	1	1.0735619	-4.9960292	110	2	1.12	0.95	92.5243	-1.3460	0.0000	0.0000;
	596	1	8.146	0.293	0	0	1	1.0843825	-4.0285689	110	2	1.12	0.95	91.3468	-2.8608	0.0000	0.0000;
	597	1	3.394	0.681	0	0	1	1.0722331	-4.2788597	110	2	1.12	0.95	91.9460	-0.5111	0.0000	0.0000;
	598	1	1.187	0.817	0	0	1	1.0712339	-6.450311	110	2	1.12	0.95	93.6631	-0.8591	0.0000	0.0000;
	599	1	4.582	0.409	0	0	1	1.0791168	-4.3000503	110	2	1.12	0.95	91.1797	-2.4060	0.0000	0.0000;
	600	1	2.206	0	0	0	1	1.0795157	-4.2248894	110	2	1.12	0.95	91.1098	-2.3241	0.0000	0.0000;
	601	1	3.394	0	0	0	1	1.0711903	-5.607177	110	2	1.12	0.95	93.1046	-1.2272	0.0000	0.0000;
	602	1	3.267	0.245	0	0	1	1.0851248	-3.1443526	110	2	1.12	0.95	89.1453	-0.7327	0.0000	0.0000;
	603	1	3.556	0	0	0	1	1.0847138	-3.2806356	110	2	1.12	0.95	89.3062	-0.7791	0.0000	0.0000;
	604	1	1.018	0.341	0	0	1	1.0583888	-6.6644721	110	2	1.12	0.95	93.9751	-1.4780	0.0000	0.0000;
	605	1	1.103	0	0	0	1	1.0731658	-4.8759027	110	2	1.12	0.95	92.2901	-1.7461	0.0000	0.0000;
	606	1	6.737	0.777	0	0	1	1.0851786	-3.2345167	110	2	1.12	0.95	90.4105	-2.2985	0.0000	0.0000;
	607	1	5.092	0.681	0	0	1	1.0867547	-5.5992401	110	2	1.12	0.95	92.7823	-1.1627	0.0000	0.0000;
	608	1	1.697	0	0	0	1	1.0873231	-5.486366	110	2	1.12	0.95	92.6845	-1.2123	0.0000	0.0000;
	609	1	3.309	0.627	0	0	1	1.0847669	-3.0024942	110	2	1.12	0.95	90.4856	-2.5710	0.0000	0.0000;
	610	1	2.63	0.817	0	0	1	1.0460738	-6.7710107	110	2	1.12	0.95	93.6580	-0.5770	0.0000	0.0000;
	611	1	10.695	0.066	0	0	1	1.0809779	-4.6686826	110	2	1.12	0.95	91.5886	-2.9830	0.0000	0.0000;
	612	1	10.695	0.066	0	0	1	1.0806102	-4.6867864	110	2	1.12	0.95	91.6494	-2.9823	0.0000	0.0000;
	613	1	3.564	0	0	0	1	1.0819874	-4.573746	110	2	1.12	0.95	91.4287	-2.9825	0.0000	0.0000;
	614	1	0	0	0	0	1	1.0816854	-4.3687637	110	2	1.12	0.95	91.7476	-1.7029	0.0000	0.0000;
	615	1	0	0	0	0	1	1.0807606	-4.4596757	110	2	1.12	0.95	91.9329	-1.5743	0.0000	0.0000;
	616	1	4.328	0.068	0	0	1	1.0819812	-4.58333	110	2	1.12	0.95	91.4322	-2.9839	0.0000	0.0000;
	617	1	1.697	0.341	0	0	1	1.0744413	-5.0289806	110	2	1.12	0.95	92.3028	-1.2340	0.0000	0.0000;
	618	1	0	0	0	0	1	1.0824151	-4.506458	110	2	1.12	0.95	91.3578	-2.9811	0.0000	0.0000;
	619	1	0	0	0	0	1	1.082401	-4.5111327	110	2	1.12	0.95	91.3588	-2.9795	0.0000	0.0000;
	620	1	2.546	0	0	0	1	1.0834858	-5.6331314	110	2	1.12	0.95	92.8341	-1.1638	0.0000	0.0000;
	621	1	4.328	0.341	0	0	1	1.0817996	-4.6016507	110	2	1.12	0.95	91.4578	-2.9830	0.0000	0.0000;
	622	1	3.497	0.484	0	0	1	1.0694002	-4.7243985	110	2	1.12	0.95	92.2478	-1.3987	0.0000	0.0000;
	623	1	2.998	0.017	0	0	1	1.0703654	-4.2925847	110	2	1.12	0.95	91.7480	-0.5999	0.0000	0.0000;
	624	1	0.849	0	0	0	1	1.0689958	-4.8370129	110	2	1.12	0.95	92.6879	-0.8923	0.0000	0.0000;
	625	1	2.377	0	0	0	1	1.0655997	-5.8199663	110	2	1.12	0.95	93.1535	-1.2643	0.0000	0.0000;
	626	1	1.697	0	0	0	1	1.0873667	-5.8537335	110	2	1.12	0.95	93.1050	-0.8716	0.0000	0.0000;
	627	2	0	0	0	0	1	1.0949378	-1.3394386	110	2	1.12	0.95	88.4239	-1.5661	0.0000	0.0000;
	628	1	2.715	1.09	0	0	1	1.0786205	-4.1532285	110	2	1.12	0.95	91.5790	-1.5792	0.0000	0.0000;
	629	1	8.485	1.362	0	0	1	1.0650256	-6.8412096	110	2	1.12	0.95	92.6719	-0.2562	0.0000	0.0000;
	630	1	2.998	0.017	0	0	1	1.0911106	-4.6076653	110	2	1.12	0.95	91.9251	-1.4866	0.0000	0.0000;
	631	1	1.723	0	0	0	1	1.0895425	-3.3293292	110	2	1.12	0.95	90.9506	-2.7522	0.0000	0.0000;
	632	1	7.721	1.703	0	0	1	1.0799535	-3.9369848	110	2	1.12	0.95	91.3226	-1.5996	0.0000	0.0000;
	633	1	5.218	0.114	0	0	1	1.0926732	-4.3339613	110	2	1.12	0.95	91.6026	-1.5412	0.0000	0.0000;
	634	1	4.243	1.226	0	0	1	1.0595347	-6.6112949	110	2	1.12	0.95	93.9020	-0.7485	0.0000	0.0000;
	635	1	1.781	0.681	0	0	1	1.0726499	-4.1091851	110	2	1.12	0.95	90.8260	-2.7427	0.0000	0.0000;
	636	1	3.649	0.954	0	0	1	1.0725974	-4.0919742	110	2	1.12	0.95	90.8128	-2.7348	0.0000	0.0000;
	637	1	6.788	1.362	0	0	1	1.0788255	-4.1434384	110	2	1.12	0.95	91.6366	-1.6356	0.0000	0.0000;
	638	1	3.734	0.477	0	0	1	1.0676859	-5.4375371	110	2	1.12	0.95	93.0166	-1.2803	0.0000	0.0000;
	639	1	2.486	0.095	0	0	1	1.0853589	-3.1642906	110	2	1.12	0.95	89.0599	-0.6722	0.0000	0.0000;
	640	1	4.131	0	0	0	1	1.0444872	-6.7799382	110	2	1.12	0.95	93.6221	-0.5032	0.0000	0.0000;
	641	1	1.697	0.341	0	0	1	1.0736295	-5.4000583	110	2	1.12	0.95	92.6783	-1.3418	0.0000	0.0000;
	642	1	4.497	1.567	0	0	1	1.0891734	-2.9289798	110	2	1.12	0.95	89.4923	-2.0438	0.0000	0.0000;
	643	1	3.988	0.068	0	0	1	1.0694317	-5.4848561	110	2	1.12	0.95	92.3306	-1.8074	0.0000	0.0000;
	644	1	1.697	0	0	0	1	1.0825806	-5.1965179	110	2	1.12	0.95	93.0516	-0.8534	0.0000	0.0000;
	645	1	4.667	0	0	0	1	1.0818426	-5.2804008	110	2	1.12	0.95	93.0391	-0.9010	0.0000	0.0000;
	646	1	3.394	0.681	0	0	1	1.069828	-4.6964672	110	2	1.12	0.95	92.1119	-0.7256	0.0000	0.0000;
	647	1	1.018	0.293	0	0	1	1.0866864	-2.4847447	110	2	1.12	0.95	88.5853	-0.6583	0.0000	0.0000;
	648	1	1.697	0	0	0	1	1.0732564	-4.8682003	110	2	1.12	0.95	91.7767	-1.8075	0.0000	0.0000;
	649	1	2.121	0.341	0	0	1	1.0738756	-3.8545249	110	2	1.12	0.95	90.6062	-2.7243	0.0000	0.0000;
	650	1	0.679	0	0	0	1	1.0807004	-4.4838569	110	2	1.12	0.95	91.8329	-1.8055	0.0000	0.0000;
	651	1	1.885	0.245	0	0	1	1.0726729	-4.8484577	110	2	1.12	0.95	92.2882	-1.7849	0.0000	0.0000;
	652	1	4.275	0.017	0	0	1	1.0774331	-5.6859657	110	2	1.12	0.95	92.8174	-1.0630	0.0000	0.0000;
	653	1	4.92	1.09	0	0	1	1.0711652	-4.426666	110	2	1.12	0.95	92.2054	-1.0391	0.0000	0.0000;
	654	1	2.945	0.531	0	0	1	1.0809723	-4.0971156	110	2	1.12	0.95	91.3677	-2.1326	0.0000	0.0000;
	655	1	0.849	0	0	0	1	1.0758774	-5.6269375	110	2	1.12	0.95	92.7325	-1.0381	0.0000	0.0000;
	656	1	14.425	2.384	0	0	1	1.0763132	-5.6939274	110	2	1.12	0.95	92.8256	-1.0272	0.0000	0.0000;
	657	1	6.788	0	0	0	1	1.0759649	-5.6854149	110	2	1.12	0.95	92.8031	-1.0334	0.0000	0.0000;
	658	1	2.546	0	0	0	1	1.0757903	-5.7001046	110	2	1.12	0.95	92.8025	-1.0488	0.0000	0.0000;
	659	1	0.855	0.003	0	0	1	1.0661071	-6.3451829	110	2	1.12	0.95	93.8431	-0.8087	0.0000	0.0000;
	660	1	2.546	0.477	0	0	1	1.0625439	-6.553491	110	2	1.12	0.95	93.9030	-0.7757	0.0000	0.0000;
	661	1	0.424	0	0	0	1	1.0868165	-5.7376496	110	2	1.12	0.95	93.0071	-1.0742	0.0000	0.0000;
	662	1	2.206	0.341	0	0	1	1.081138	-4.8167879	110	2	1.12	0.95	92.1460	-1.5365	0.0000	0.0000;
	663	1	3.267	0.048	0	0	1	1.0740881	-4.617626	110	2	1.12	0.95	92.0919	-1.9002	0.0000	0.0000;
	664	1	1.697	0	0	0	1	1.0728065	-5.5789959	110	2	1.12	0.95	92.8927	-1.4067	0.0000	0.0000;
	665	2	13	0	0	0	1	1.068571	-3.7077575	110	2	1.12	0.95	90.9661	-0.5354	0.0000	0.0000;
	666	1	0	0	0	0	1	1.0686787	-3.7335396	110	2	1.12	0.95	90.9785	-0.5414	0.0000	0.0000;
	667	1	2.546	0	0	0	1	1.0763312	-5.7425583	110	2	1.12	0.95	92.8573	-1.0581	0.0000	0.0000;
	668	1	13.576	1.362	0	0	1	1.0758315	-5.5834987	110	2	1.12	0.95	92.6811	-1.0406	0.0000	0.0000;
	669	1	4.667	0.681	0	0	1	1.0527338	-6.655479	110	2	1.12	0.95	93.7475	-0.7432	0.0000	0.0000;
	670	1	0	0	0	0	1	1.0449228	-6.6828935	110	2	1.12	0.95	93.5275	-0.4977	0.0000	0.0000;
	671	1	6.025	0.443	0	0	1	1.0523822	-6.6655909	110	2	1.12	0.95	93.7459	-0.7374	0.0000	0.0000;
	672	1	6.448	0.341	0	0	1	1.0534003	-6.6409096	110	2	1.12	0.95	93.7253	-0.7745	0.0000	0.0000;
	673	1	7.183	0.014	0	0	1	1.0472821	-6.7138072	110	2	1.12	0.95	93.6519	-0.5734	0.0000	0.0000;
	674	1	2.546	0.341	0	0	1	1.0675356	-5.2935187	110	2	1.12	0.95	93.2169	-1.0034	0.0000	0.0000;
	675	1	0.849	0.341	0	0	1	1.0674256	-5.2586106	110	2	1.12	0.95	93.1974	-0.9854	0.0000	0.0000;
	676	1	6.279	0.545	0	0	1	1.0798598	-4.4164243	110	2	1.12	0.95	91.3092	-2.9260	0.0000	0.0000;
	677	1	2.546	0	0	0	1	1.0673852	-5.2430505	110	2	1.12	0.95	93.1892	-0.9793	0.0000	0.0000;
	678	1	3.819	1.022	0	0	1	1.0877527	-5.8199972	110	2	1.12	0.95	93.0694	-0.6170	0.0000	0.0000;
	679	1	7.636	0.341	0	0	1	1.0758311	-5.7482175	110	2	1.12	0.95	92.8560	-1.0527	0.0000	0.0000;
	680	1	4.243	1.022	0	0	1	1.0686966	-4.1105871	110	2	1.12	0.95	91.3473	-0.6423	0.0000	0.0000;
	681	1	9.333	2.044	0	0	1	1.0660688	-5.5145313	110	2	1.12	0.95	93.1166	-1.2549	0.0000	0.0000;
	682	1	3.649	0.409	0	0	1	1.067836	-5.4053699	110	2	1.12	0.95	92.5940	-2.2642	0.0000	0.0000;
	683	1	7.417	1.233	0	0	1	1.0850625	-3.742445	110	2	1.12	0.95	91.2073	-2.4877	0.0000	0.0000;
	684	1	3.988	0.531	0	0	1	1.0854392	-3.8550943	110	2	1.12	0.95	91.2727	-2.8255	0.0000	0.0000;
	685	1	4.166	0.102	0	0	1	1.087797	-2.6684327	110	2	1.12	0.95	90.4123	-2.7753	0.0000	0.0000;
	686	2	6.418	0.042	0	0	1	1.0881238	-2.228794	110	2	1.12	0.95	90.0530	-2.7870	0.0000	0.0000;
	687	1	0	0	0	0	1	1.08819	-2.2441059	110	2	1.12	0.95	90.0557	-2.7836	0.0000	0.0000;
	688	1	7.128	0.886	0	0	1	1.0869455	-2.0019733	110	2	1.12	0.95	89.6113	-1.4222	0.0000	0.0000;
	689	1	2.121	0.545	0	0	1	1.054162	-6.8186571	110	2	1.12	0.95	93.9361	-1.1326	0.0000	0.0000;
	690	1	3.478	0.681	0	0	1	1.086241	-2.0988994	110	2	1.12	0.95	89.7136	-1.4055	0.0000	0.0000;
	691	1	3.42	0.035	0	0	1	1.0876203	-3.1156288	110	2	1.12	0.95	90.7658	-2.7317	0.0000	0.0000;
	692	2	4.243	1.362	0	0	1	1.0875515	-3.1130802	110	2	1.12	0.95	90.7605	-2.7235	0.0000	0.0000;
	693	1	3.598	0.361	0	0	1	1.088024	-3.1609761	110	2	1.12	0.95	90.8103	-2.7217	0.0000	0.0000;
	694	1	4.599	0.32	0	0	1	1.0889134	-3.2657637	110	2	1.12	0.95	90.9013	-2.7375	0.0000	0.0000;
	695	1	5.092	0	0	0	1	1.0733819	-5.4146453	110	2	1.12	0.95	92.7493	-1.5456	0.0000	0.0000;
	696	1	2.741	0.436	0	0	1	1.083437	-3.9923464	110	2	1.12	0.95	89.5474	-0.5992	0.0000	0.0000;
	697	1	0	0	0	0	1	1.0896246	-3.2708551	110	2	1.12	0.95	90.9025	-2.7398	0.0000	0.0000;
	698	1	0	0	0	0	1	1.0894817	-3.2715181	110	2	1.12	0.95	90.8956	-2.7420	0.0000	0.0000;
	699	1	1.357	0.272	0	0	1	1.0885836	-3.4732692	110	2	1.12	0.95	90.0385	-2.1515	0.0000	0.0000;
	700	1	5.515	0.395	0	0	1	1.0884113	-3.2285564	110	2	1.12	0.95	90.8753	-2.7451	0.0000	0.0000;
	701	1	3.436	0.422	0	0	1	1.0840009	-2.7284792	110	2	1.12	0.95	90.5501	-2.7869	0.0000	0.0000;
	702	1	5.999	0.211	0	0	1	1.0877995	-3.0218064	110	2	1.12	0.95	90.7068	-2.7617	0.0000	0.0000;
	703	1	0	0	0	0	1	1.0878921	-3.1050956	110	2	1.12	0.95	90.7645	-2.7521	0.0000	0.0000;
	704	1	3.894	0.511	0	0	1	1.0839408	-2.7363777	110	2	1.12	0.95	90.5594	-2.7854	0.0000	0.0000;
	705	1	2.546	0.048	0	0	1	1.0842612	-2.7084756	110	2	1.12	0.95	90.5123	-2.7906	0.0000	0.0000;
	706	1	4.608	0.845	0	0	1	1.0875236	-3.1012861	110	2	1.12	0.95	90.7474	-2.7152	0.0000	0.0000;
	707	1	4.243	0.681	0	0	1	1.0808123	-4.4634104	110	2	1.12	0.95	91.9400	-1.5893	0.0000	0.0000;
	708	1	4.243	1.362	0	0	1	1.0812549	-4.4393536	110	2	1.12	0.95	91.8892	-1.6135	0.0000	0.0000;
	709	1	1.357	0.204	0	0	1	1.0854794	-4.1608803	110	2	1.12	0.95	90.8307	-2.6588	0.0000	0.0000;
	710	1	6.788	1.362	0	0	1	1.0893832	-5.8153022	110	2	1.12	0.95	93.3410	-0.1288	0.0000	0.0000;
	711	1	4.158	0.048	0	0	1	1.080111	-3.8428297	110	2	1.12	0.95	90.4428	-1.1290	0.0000	0.0000;
	712	1	0.594	0	0	0	1	1.0602329	-6.4830619	110	2	1.12	0.95	93.9373	-1.6119	0.0000	0.0000;
	713	1	2.546	0.341	0	0	1	1.0752589	-4.1476502	110	2	1.12	0.95	92.0870	-0.3963	0.0000	0.0000;
	714	1	1.285	0	0	0	1	1.067253	-6.1403316	110	2	1.12	0.95	91.9442	-0.2584	0.0000	0.0000;
	715	1	0	0	0	0	1	1.0787348	-3.7677542	110	2	1.12	0.95	90.5248	-2.8461	0.0000	0.0000;
	716	1	0	0	0	0	1	1.0787707	-3.7632392	110	2	1.12	0.95	90.5260	-2.8493	0.0000	0.0000;
	717	2	23.842	5.245	0	0	1	1.086368	-4.4636475	110	2	1.12	0.95	91.7403	-1.5536	0.0000	0.0000;
	718	1	25.456	5.79	0	0	1	1.0724377	-5.9210489	110	2	1.12	0.95	93.2698	-0.9530	0.0000	0.0000;
	719	1	3.394	0.341	0	0	1	1.0809929	-5.4942683	110	2	1.12	0.95	92.6662	-1.0553	0.0000	0.0000;
	720	1	12.133	2.452	0	0	1	1.0678839	-5.661277	110	2	1.12	0.95	92.5648	-1.8061	0.0000	0.0000;
	721	1	1.952	0.293	0	0	1	1.0757496	-4.3622044	110	2	1.12	0.95	91.8617	-2.0349	0.0000	0.0000;
	722	1	2.206	0.477	0	0	1	1.0769576	-4.4819463	110	2	1.12	0.95	92.0887	-1.3855	0.0000	0.0000;
	723	1	8.825	1.431	0	0	1	1.0649445	-6.47888	110	2	1.12	0.95	93.8871	-0.7770	0.0000	0.0000;
	724	1	2.298	0.681	0	0	1	1.077881	-4.7876696	110	2	1.12	0.95	91.7794	-2.2786	0.0000	0.0000;
	725	1	1.697	0.552	0	0	1	1.0842037	-4.076082	110	2	1.12	0.95	91.3551	-2.8724	0.0000	0.0000;
	726	1	1.273	0	0	0	1	1.0722344	-5.6491011	110	2	1.12	0.95	93.0058	-1.3667	0.0000	0.0000;
	727	1	3.19	0.293	0	0	1	1.0822709	-3.6264978	110	2	1.12	0.95	90.8837	-2.3293	0.0000	0.0000;
	728	1	0.169	0	0	0	1	1.0796273	-4.6508269	110	2	1.12	0.95	91.8776	-1.9685	0.0000	0.0000;
	729	1	0.849	0.341	0	0	1	1.0714004	-5.8488017	110	2	1.12	0.95	93.3207	-0.9715	0.0000	0.0000;
	730	1	3.054	0	0	0	1	1.0774452	-5.1580241	110	2	1.12	0.95	92.4409	-1.4875	0.0000	0.0000;
	731	1	30.546	10.218	0	0	1	1.0741733	-5.3992308	110	2	1.12	0.95	92.6402	-1.4302	0.0000	0.0000;
	732	1	0	0	0	0	1	1.0742658	-5.3839198	110	2	1.12	0.95	92.6343	-1.4280	0.0000	0.0000;
	733	1	0.849	0.341	0	0	1	1.0857152	-4.3392239	110	2	1.12	0.95	91.7324	-1.5846	0.0000	0.0000;
	734	1	67.882	27.249	0	0	1	1.0136623	-6.3437637	110	2	1.12	0.95	92.3048	-1.1404	0.0000	0.0000;
	735	1	0	0	0	0	1	1.0140322	-6.3266659	110	2	1.12	0.95	92.2654	-1.1555	0.0000	0.0000;
	736	1	7.275	0.049	0	0	1	1.0731164	-5.5520254	110	2	1.12	0.95	92.8380	-1.4171	0.0000	0.0000;
	737	1	14.425	0.681	0	0	1	1.0727452	-5.6497241	110	2	1.12	0.95	92.8923	-1.4334	0.0000	0.0000;
	738	1	3.394	0	0	0	1	1.0759215	-4.8312297	110	2	1.12	0.95	92.2523	-1.5511	0.0000	0.0000;
	739	1	3.326	0.245	0	0	1	1.0901729	-3.044686	110	2	1.12	0.95	90.0387	-2.1346	0.0000	0.0000;
	740	1	2.546	0.681	0	0	1	1.070949	-5.5574661	110	2	1.12	0.95	93.0565	-1.2279	0.0000	0.0000;
	741	2	13	0	0	0	1	1.0957407	-3.7458166	110	2	1.12	0.95	90.9383	-1.6087	0.0000	0.0000;
	742	1	0	0	0	0	1	1.0958467	-3.7645625	110	2	1.12	0.95	90.9547	-1.6083	0.0000	0.0000;
	743	1	2.546	0.341	0	0	1	1.0867422	-5.7253826	110	2	1.12	0.95	92.9974	-1.0671	0.0000	0.0000;
	744	1	4.275	0	0	0	1	1.0697425	-4.4951178	110	2	1.12	0.95	91.7200	-0.7956	0.0000	0.0000;
	745	1	2.121	0	0	0	1	1.0712216	-4.7548042	110	2	1.12	0.95	91.9783	-0.9370	0.0000	0.0000;
	746	1	0	0.245	0	0	1	1.0730079	-4.8240048	110	2	1.12	0.95	92.2598	-1.7675	0.0000	0.0000;
	747	1	3.013	0.341	0	0	1	1.0729412	-4.7891488	110	2	1.12	0.95	92.2341	-1.7808	0.0000	0.0000;
	748	1	0.424	0	0	0	1	1.0813782	-3.7113633	110	2	1.12	0.95	91.0070	-2.3328	0.0000	0.0000;
	749	1	2.265	0.341	0	0	1	1.080929	-3.7472743	110	2	1.12	0.95	91.0621	-2.3320	0.0000	0.0000;
	750	1	1.273	0.136	0	0	1	1.0732189	-4.0772682	110	2	1.12	0.95	90.7925	-2.7589	0.0000	0.0000;
	751	1	5.685	1.362	0	0	1	1.0586925	-6.6168869	110	2	1.12	0.95	94.1569	-1.5880	0.0000	0.0000;
	752	1	5.939	1.09	0	0	1	1.0632629	-5.9771267	110	2	1.12	0.95	93.5230	-1.3753	0.0000	0.0000;
	753	1	3.394	0	0	0	1	1.0715376	-4.9996201	110	2	1.12	0.95	92.5652	-1.0753	0.0000	0.0000;
	754	1	1.187	0.681	0	0	1	1.0824991	-4.4207098	110	2	1.12	0.95	91.8498	-1.6126	0.0000	0.0000;
	755	1	10.695	0.028	0	0	1	1.0583786	-6.6774547	110	2	1.12	0.95	94.2389	-1.6039	0.0000	0.0000;
	756	1	3.903	0	0	0	1	1.0602388	-6.4777409	110	2	1.12	0.95	93.9299	-1.6082	0.0000	0.0000;
	757	1	3.224	0.545	0	0	1	1.0588507	-6.5926108	110	2	1.12	0.95	94.1358	-1.5896	0.0000	0.0000;
	758	1	8.485	2.725	0	0	1	1.0726513	-5.1390926	110	2	1.12	0.95	92.4489	-1.1594	0.0000	0.0000;
	759	1	23.758	3.406	0	0	1	1.0801496	-5.4120364	110	2	1.12	0.95	92.5839	-1.0538	0.0000	0.0000;
	760	1	0	0	0	0	1	1.0802484	-5.4038759	110	2	1.12	0.95	92.5831	-1.0517	0.0000	0.0000;
	761	1	6.466	0.777	0	0	1	1.0781416	-4.2661132	110	2	1.12	0.95	91.4023	-1.8410	0.0000	0.0000;
	762	1	5.092	1.362	0	0	1	1.072487	-5.1292777	110	2	1.12	0.95	92.4336	-1.1371	0.0000	0.0000;
	763	1	0.849	0	0	0	1	1.0690166	-4.8319666	110	2	1.12	0.95	92.6832	-0.8919	0.0000	0.0000;
	764	2	4.418	0.074	0	0	1	1.0762578	-3.589181	110	2	1.12	0.95	91.3594	-1.0841	0.0000	0.0000;
	765	1	19.163	0.087	0	0	1	1.0811285	-4.5166132	110	2	1.12	0.95	91.4628	-2.9482	0.0000	0.0000;
	766	1	5.939	1.362	0	0	1	1.0698812	-5.0585403	110	2	1.12	0.95	92.4284	-0.8769	0.0000	0.0000;
	767	1	4.836	0	0	0	1	1.0739399	-4.4738183	110	2	1.12	0.95	92.1104	-1.2158	0.0000	0.0000;
	768	1	2.63	0.817	0	0	1	1.0722759	-5.4210017	110	2	1.12	0.95	93.2378	-1.0807	0.0000	0.0000;
	769	1	5.092	1.362	0	0	1	1.0755833	-5.0125685	110	2	1.12	0.95	92.1819	-1.2887	0.0000	0.0000;
	770	1	0	0	0	0	1	1.0755439	-5.0138867	110	2	1.12	0.95	92.1801	-1.2876	0.0000	0.0000;
	771	1	4.243	0.681	0	0	1	1.0731302	-5.0122685	110	2	1.12	0.95	92.2481	-1.0984	0.0000	0.0000;
	772	1	5.092	1.703	0	0	1	1.0736123	-5.032127	110	2	1.12	0.95	92.2672	-1.1539	0.0000	0.0000;
	773	1	4.243	0.681	0	0	1	1.0700507	-5.0888476	110	2	1.12	0.95	92.4607	-0.9218	0.0000	0.0000;
	774	1	6.843	0.017	0	0	1	1.0934103	-2.0158497	110	2	1.12	0.95	88.8112	-1.6580	0.0000	0.0000;
	775	1	5.405	0.777	0	0	1	1.0676795	-4.5525455	110	2	1.12	0.95	92.0511	-1.0800	0.0000	0.0000;
	776	1	1.866	0.272	0	0	1	1.0710446	-4.8007563	110	2	1.12	0.95	92.4533	-1.1777	0.0000	0.0000;
	777	1	3.139	0.409	0	0	1	1.0736559	-4.6101322	110	2	1.12	0.95	92.2225	-1.2401	0.0000	0.0000;
	778	1	1.273	0	0	0	1	1.0725842	-4.9467422	110	2	1.12	0.95	92.5171	-1.2882	0.0000	0.0000;
	779	1	0	0	0	0	1	1.0696493	-4.3478261	110	2	1.12	0.95	92.1564	-0.9916	0.0000	0.0000;
	780	1	0	0	0	0	1	1.0696614	-4.3555373	110	2	1.12	0.95	92.1587	-0.9914	0.0000	0.0000;
	781	1	1.273	0.341	0	0	1	1.073126	-5.1207492	110	2	1.12	0.95	92.4078	-1.1823	0.0000	0.0000;
	782	1	10.861	0.681	0	0	1	1.0756818	-3.6628569	110	2	1.12	0.95	91.4343	-1.0777	0.0000	0.0000;
	783	1	8.485	1.362	0	0	1	1.0732755	-4.8860084	110	2	1.12	0.95	92.4457	-1.3000	0.0000	0.0000;
	784	1	2.291	0	0	0	1	1.0764125	-5.1898851	110	2	1.12	0.95	92.2915	-1.9457	0.0000	0.0000;
	785	1	2.291	0.545	0	0	1	1.094864	-1.3489392	110	2	1.12	0.95	88.4335	-1.5643	0.0000	0.0000;
	786	1	0.849	0	0	0	1	1.0849939	-5.6346759	110	2	1.12	0.95	92.8246	-1.1815	0.0000	0.0000;
	787	1	0	0	0	0	1	1.0863641	-3.3001648	110	2	1.12	0.95	90.8932	-2.8074	0.0000	0.0000;
	788	1	6.418	0.066	0	0	1	1.085821	-3.3022472	110	2	1.12	0.95	90.8923	-2.8100	0.0000	0.0000;
	789	1	2.546	0.681	0	0	1	1.0716633	-5.4055372	110	2	1.12	0.95	92.8941	-1.2456	0.0000	0.0000;
	790	1	5.092	0.436	0	0	1	1.0853104	-3.2750341	110	2	1.12	0.95	90.8645	-2.8134	0.0000	0.0000;
	791	1	3.394	0.681	0	0	1	1.0855548	-4.865817	110	2	1.12	0.95	92.9627	-0.6936	0.0000	0.0000;
	792	1	2.715	0.681	0	0	1	1.072365	-5.349713	110	2	1.12	0.95	93.1079	-1.1383	0.0000	0.0000;
	793	2	2.731	0.277	0	0	1	1.0536063	-6.7847346	110	2	1.12	0.95	93.8724	-1.0621	0.0000	0.0000;
	794	1	2.97	0.681	0	0	1	1.0555661	-6.6524202	110	2	1.12	0.95	93.7840	-1.1000	0.0000	0.0000;
	795	1	1.273	0.341	0	0	1	1.0818742	-3.5604063	110	2	1.12	0.95	90.5127	-1.8266	0.0000	0.0000;
	796	1	5.648	0	0	0	1	1.0757857	-3.5773178	110	2	1.12	0.95	91.2896	-1.1589	0.0000	0.0000;
	797	1	0	0	0	0	1	1.0553313	-6.8109761	110	2	1.12	0.95	93.9566	-1.2297	0.0000	0.0000;
	798	1	1.697	0	0	0	1	1.0709965	-5.585387	110	2	1.12	0.95	93.0825	-1.2266	0.0000	0.0000;
	799	1	2.546	0.681	0	0	1	1.0688708	-5.4698955	110	2	1.12	0.95	93.2351	-1.1161	0.0000	0.0000;
	800	1	2.546	0.681	0	0	1	1.0710295	-5.5274126	110	2	1.12	0.95	93.0274	-1.2312	0.0000	0.0000;
	801	1	4.497	1.499	0	0	1	1.0713138	-4.8629253	110	2	1.12	0.95	92.4912	-1.2072	0.0000	0.0000;
	802	1	2.546	0.136	0	0	1	1.0934552	-4.2062692	110	2	1.12	0.95	91.4507	-1.5623	0.0000	0.0000;
	803	1	11.031	1.362	0	0	1	1.072211	-5.5974033	110	2	1.12	0.95	92.9570	-1.3477	0.0000	0.0000;
	804	1	0	0	0	0	1	1.0843427	-4.0131339	110	2	1.12	0.95	91.3293	-2.8661	0.0000	0.0000;
	805	1	4.158	0.409	0	0	1	1.0540797	-6.7594102	110	2	1.12	0.95	93.8592	-1.0723	0.0000	0.0000;
	806	1	2.546	0	0	0	1	1.0891617	-5.0846665	110	2	1.12	0.95	92.3365	-1.3564	0.0000	0.0000;
	807	1	4.243	0.681	0	0	1	1.0722288	-5.5941509	110	2	1.12	0.95	92.9481	-1.3464	0.0000	0.0000;
	808	1	16.97	4.769	0	0	1	1.0779203	-4.8302813	110	2	1.12	0.95	91.8217	-2.2562	0.0000	0.0000;
	809	2	20.149	4.851	0	0	1	1.0929948	-2.3565561	110	2	1.12	0.95	88.9478	-1.7147	0.0000	0.0000;
	810	1	3.224	1.09	0	0	1	1.0627062	-5.8956246	110	2	1.12	0.95	93.1893	-1.0437	0.0000	0.0000;
	811	1	0.855	0	0	0	1	1.0718418	-5.621215	110	2	1.12	0.95	93.0655	-1.2068	0.0000	0.0000;
	812	1	7.068	0.954	0	0	1	1.077864	-4.8520835	110	2	1.12	0.95	91.9287	-2.1547	0.0000	0.0000;
	813	1	2.469	0.743	0	0	1	1.0777994	-4.8409161	110	2	1.12	0.95	91.8617	-2.2357	0.0000	0.0000;
	814	1	3.819	0	0	0	1	1.0785079	-3.9957726	110	2	1.12	0.95	90.8109	-2.7278	0.0000	0.0000;
	815	1	2.036	0.136	0	0	1	1.0805003	-3.9904075	110	2	1.12	0.95	90.8968	-2.1302	0.0000	0.0000;
	816	1	4.158	0.272	0	0	1	1.0799817	-4.3039906	110	2	1.12	0.95	91.7374	-1.6721	0.0000	0.0000;
	817	1	3.988	0.068	0	0	1	1.070104	-4.799749	110	2	1.12	0.95	91.8664	-2.6099	0.0000	0.0000;
	818	1	1.866	0.136	0	0	1	1.0706143	-4.6180095	110	2	1.12	0.95	91.6533	-2.6344	0.0000	0.0000;
	819	1	1.952	0.409	0	0	1	1.0792716	-4.0518204	110	2	1.12	0.95	91.4993	-1.6167	0.0000	0.0000;
	820	1	2.377	0.204	0	0	1	1.0734294	-4.0141178	110	2	1.12	0.95	90.7396	-2.7498	0.0000	0.0000;
	821	1	0.51	0.136	0	0	1	1.0702983	-4.8280617	110	2	1.12	0.95	91.8864	-2.6278	0.0000	0.0000;
	822	1	2.036	0	0	0	1	1.0547906	-6.8363003	110	2	1.12	0.95	93.9869	-1.1885	0.0000	0.0000;
	823	1	5.092	1.362	0	0	1	1.0666462	-5.467175	110	2	1.12	0.95	91.7430	-0.3289	0.0000	0.0000;
	824	1	1.383	0.245	0	0	1	1.0897027	-2.6803719	110	2	1.12	0.95	89.3452	-1.6784	0.0000	0.0000;
	825	1	4.166	0.293	0	0	1	1.088832	-1.348231	110	2	1.12	0.95	87.7813	-0.6288	0.0000	0.0000;
	826	1	3.394	0.681	0	0	1	1.0803015	-5.3980887	110	2	1.12	0.95	92.7811	-0.9990	0.0000	0.0000;
	827	1	2.377	0	0	0	1	1.0877758	-3.8395313	110	2	1.12	0.95	90.3613	-2.3798	0.0000	0.0000;
	828	1	2.546	0	0	0	1	1.0738728	-5.6343264	110	2	1.12	0.95	92.9046	-1.1252	0.0000	0.0000;
	829	1	5.092	0	0	0	1	1.09017	-4.3730327	110	2	1.12	0.95	92.7911	-0.5329	0.0000	0.0000;
	830	1	3.996	0.266	0	0	1	1.0842025	-2.7176328	110	2	1.12	0.95	90.5304	-2.7874	0.0000	0.0000;
	831	1	0	0	0	0	1	1.0710125	-5.4743807	110	2	1.12	0.95	93.0246	-1.2409	0.0000	0.0000;
	832	1	0	0	0	0	1	1.0874687	-5.8013853	110	2	1.12	0.95	93.0554	-0.8607	0.0000	0.0000;
	833	1	4.92	0.477	0	0	1	1.0737702	-3.7199282	110	2	1.12	0.95	90.5010	-2.6805	0.0000	0.0000;
	834	1	0.849	0.204	0	0	1	1.0537561	-6.8017331	110	2	1.12	0.95	93.9009	-1.0955	0.0000	0.0000;
	835	1	2.121	0.204	0	0	1	1.084242	-3.561361	110	2	1.12	0.95	90.1177	-2.6410	0.0000	0.0000;
	836	1	1.357	0.681	0	0	1	1.0885514	-2.8755272	110	2	1.12	0.95	89.7900	-2.0422	0.0000	0.0000;
	837	1	3.734	0	0	0	1	1.0760083	-3.7815016	110	2	1.12	0.95	90.5463	-2.7687	0.0000	0.0000;
	838	1	2.801	0	0	0	1	1.0743669	-3.7489665	110	2	1.12	0.95	90.5251	-2.7133	0.0000	0.0000;
	839	1	1.697	0	0	0	1	1.0710873	-5.6012004	110	2	1.12	0.95	93.0969	-1.2243	0.0000	0.0000;
	840	1	3.394	0.681	0	0	1	1.0740226	-5.1800572	110	2	1.12	0.95	92.4618	-1.5649	0.0000	0.0000;
	841	1	0	0	0	0	1	1.1126851	-4.1903331	110	3	1.12	0.95	91.7289	-0.0606	0.0000	0.0000;
	842	1	16.484	0.65	0	0	1	1.1038827	-4.0644753	110	3	1.12	0.95	91.8033	0.0080	0.0000	0.0000;
	843	1	3.35	0.509	0	0	1	1.0797922	-5.4014756	110	3	1.12	0.95	92.5048	-0.7618	0.0000	0.0000;
	844	1	0	0	0	0	1	1.0819579	-5.4498198	110	3	1.12	0.95	92.5395	-0.8848	0.0000	0.0000;
	845	1	35.146	15.25	0	0	1	1.0796068	-5.4048644	110	3	1.12	0.95	92.5239	-0.7511	0.0000	0.0000;
	846	2	0	0	0	0	1	1.0801488	-5.3791108	110	3	1.12	0.95	92.4459	-0.7630	0.0000	0.0000;
	847	1	0.661	0.182	0	0	1	1.0928754	-7.3644916	110	3	1.12	0.95	94.2815	0.0572	0.0000	0.0000;
	848	1	3.007	0.901	0	0	1	1.0928584	-7.3597916	110	3	1.12	0.95	94.2814	0.0575	0.0000	0.0000;
	849	1	2.18	0.446	0	0	1	1.0999783	-5.578946	110	3	1.12	0.95	92.7036	0.0187	0.0000	0.0000;
	850	1	0	0	0	0	1	1.0901972	-4.1639489	110	3	1.12	0.95	92.1622	-0.0122	0.0000	0.0000;
	851	1	4.524	0.885	0	0	1	1.0901471	-4.1639915	110	3	1.12	0.95	92.1623	-0.0123	0.0000	0.0000;
	852	1	3.013	-0.252	0	0	1	1.0952647	-6.6221736	110	3	1.12	0.95	93.5194	0.0479	0.0000	0.0000;
	853	1	2.227	0.779	0	0	1	1.0952619	-6.6178395	110	3	1.12	0.95	93.5196	0.0476	0.0000	0.0000;
	854	1	0	0	0	0	1	1.0952667	-6.6126572	110	3	1.12	0.95	93.5194	0.0472	0.0000	0.0000;
	855	1	4.019	0.278	0	0	1	1.1005949	-2.6857828	110	3	1.12	0.95	91.3806	-0.2247	0.0000	0.0000;
	856	1	2.597	0.325	0	0	1	1.1005954	-2.6904524	110	3	1.12	0.95	91.3809	-0.2251	0.0000	0.0000;
	857	1	0	0	0	0	1	1.1078397	-5.8422931	110	3	1.12	0.95	92.2936	0.1148	0.0000	0.0000;
	858	1	0	0	0	0	1	1.1078669	-5.8371216	110	3	1.12	0.95	92.2925	0.1148	0.0000	0.0000;
	859	1	0.418	0.217	0	0	1	1.107741	-5.8555814	110	3	1.12	0.95	92.3346	0.1470	0.0000	0.0000;
	860	1	3.347	1.517	0	0	1	1.1077249	-5.8519055	110	3	1.12	0.95	92.3361	0.1481	0.0000	0.0000;
	861	1	1.256	0.302	0	0	1	1.0911259	-4.0534204	110	3	1.12	0.95	92.1035	-0.1995	0.0000	0.0000;
	862	1	0	0	0	0	1	1.0911163	-4.0565555	110	3	1.12	0.95	92.1052	-0.1996	0.0000	0.0000;
	863	1	0	0	0	0	1	1.0819735	-5.4500834	110	3	1.12	0.95	92.5395	-0.8856	0.0000	0.0000;
	864	1	6.288	0.933	0	0	1	1.091854	-5.8267568	110	3	1.12	0.95	92.9436	-0.1565	0.0000	0.0000;
	865	1	5.928	0.81	0	0	1	1.0918272	-5.8311604	110	3	1.12	0.95	92.9457	-0.1562	0.0000	0.0000;
	866	1	6.286	1.025	0	0	1	1.1015623	-6.3935571	110	3	1.12	0.95	92.9468	0.2340	0.0000	0.0000;
	867	1	0	0	0	0	1	1.0990752	-6.6356363	110	3	1.12	0.95	93.1177	0.2889	0.0000	0.0000;
	868	1	0	0	0	0	1	1.0990752	-6.6356356	110	3	1.12	0.95	93.1177	0.2889	0.0000	0.0000;
	869	1	3.773	1.063	0	0	1	1.0965193	-3.9548691	110	3	1.12	0.95	91.9136	-0.1643	0.0000	0.0000;
	870	1	1.843	0.618	0	0	1	1.096513	-3.9552845	110	3	1.12	0.95	91.9146	-0.1636	0.0000	0.0000;
	871	1	2.406	-1.058	0	0	1	1.0899096	-5.7047368	110	3	1.12	0.95	92.9052	-0.0303	0.0000	0.0000;
	872	1	1.776	-0.742	0	0	1	1.0899051	-5.6999443	110	3	1.12	0.95	92.9039	-0.0303	0.0000	0.0000;
	873	1	1.088	0.215	0	0	1	1.0824511	-6.3840857	110	3	1.12	0.95	93.4923	-0.5285	0.0000	0.0000;
	874	1	0	0	0	0	1	1.0836039	-5.5895703	110	3	1.12	0.95	92.6178	-0.9379	0.0000	0.0000;
	875	1	0	0	0	0	1	1.0824577	-6.3836969	110	3	1.12	0.95	93.4914	-0.5286	0.0000	0.0000;
	876	1	0.837	0.433	0	0	1	1.1019152	-5.3538312	110	3	1.12	0.95	92.6462	0.0602	0.0000	0.0000;
	877	1	1.339	0.433	0	0	1	1.101909	-5.3537331	110	3	1.12	0.95	92.6477	0.0609	0.0000	0.0000;
	878	2	2.176	2.497	0	0	1	1.1062335	-3.6632305	110	3	1.12	0.95	91.4588	0.0000	0.0000	0.0000;
	879	1	5.19	1.577	0	0	1	1.1041221	-3.9731932	110	3	1.12	0.95	91.7816	0.0124	0.0000	0.0000;
	880	1	3.416	0.512	0	0	1	1.0932296	-6.3479732	110	3	1.12	0.95	93.5643	-0.2699	0.0000	0.0000;
	881	1	1.675	0.384	0	0	1	1.1034746	-2.773489	110	3	1.12	0.95	92.3668	-0.6700	0.0000	0.0000;
	882	1	0	0	0	0	1	1.1037761	-2.7535901	110	3	1.12	0.95	92.3253	-0.6751	0.0000	0.0000;
	883	1	1.892	0.401	0	0	1	1.0823103	-6.8049441	110	3	1.12	0.95	93.8123	-0.9628	0.0000	0.0000;
	884	1	4.529	0.884	0	0	1	1.0823285	-6.8074988	110	3	1.12	0.95	93.8128	-0.9621	0.0000	0.0000;
	885	1	3.012	0.823	0	0	1	1.1032156	-5.3895332	110	3	1.12	0.95	92.3165	-0.0266	0.0000	0.0000;
	886	1	0	0	0	0	1	1.1031939	-5.386406	110	3	1.12	0.95	92.3165	-0.0265	0.0000	0.0000;
	887	1	1.341	0.472	0	0	1	1.0949826	-4.0446956	110	3	1.12	0.95	91.9900	-0.1490	0.0000	0.0000;
	888	1	0.586	0.21	0	0	1	1.0942853	-4.0778174	110	3	1.12	0.95	92.0351	-0.1294	0.0000	0.0000;
	889	1	0	0	0	0	1	1.0950034	-4.0437668	110	3	1.12	0.95	91.9878	-0.1498	0.0000	0.0000;
	890	1	0	0	0	0	1	1.0942944	-4.0774096	110	3	1.12	0.95	92.0342	-0.1297	0.0000	0.0000;
	891	1	0	0	0	0	1	1.1096426	-0.19558924	110	3	1.12	0.95	90.0747	-0.1085	0.0000	0.0000;
	892	1	0.753	0.087	0	0	1	1.1096123	-0.18800951	110	3	1.12	0.95	90.0769	-0.1085	0.0000	0.0000;
	893	1	1.609	0.305	0	0	1	1.0941537	-6.4383255	110	3	1.12	0.95	93.3897	-0.6182	0.0000	0.0000;
	894	1	0	0	0	0	1	1.0943256	-6.4154002	110	3	1.12	0.95	93.3651	-0.6195	0.0000	0.0000;
	895	1	4.103	1.235	0	0	1	1.0912032	-4.1733963	110	3	1.12	0.95	92.1593	-0.0446	0.0000	0.0000;
	896	1	0	0	0	0	1	1.0912651	-4.1716323	110	3	1.12	0.95	92.1587	-0.0446	0.0000	0.0000;
	897	1	3.014	0.388	0	0	1	1.0977617	-3.8479697	110	3	1.12	0.95	91.7469	-0.2230	0.0000	0.0000;
	898	1	1.423	0.085	0	0	1	1.0960627	-4.1094744	110	3	1.12	0.95	92.2275	-0.3488	0.0000	0.0000;
	899	1	0	0	0	0	1	1.0981748	-3.8234374	110	3	1.12	0.95	91.6834	-0.2271	0.0000	0.0000;
	900	1	5.021	1.733	0	0	1	1.1023233	-2.1612193	110	3	1.12	0.95	91.6147	-0.2465	0.0000	0.0000;
	901	2	3	5	0	0	1	1.0998334	-3.1409139	110	3	1.12	0.95	91.2640	0.0000	0.0000	0.0000;
	902	1	4.184	0	0	0	1	1.0978942	-3.8500413	110	3	1.12	0.95	91.8997	-0.0521	0.0000	0.0000;
	903	1	0	0	0	0	1	1.099616	-2.8645493	110	3	1.12	0.95	91.5211	-0.2449	0.0000	0.0000;
	904	1	2.514	1.122	0	0	1	1.0996068	-2.8636993	110	3	1.12	0.95	91.5225	-0.2443	0.0000	0.0000;
	905	1	3.082	0.55	0	0	1	1.082699	-6.8237108	110	3	1.12	0.95	93.8229	-0.9690	0.0000	0.0000;
	906	1	2.779	0.542	0	0	1	1.0827327	-6.8232405	110	3	1.12	0.95	93.8225	-0.9685	0.0000	0.0000;
	907	1	6.118	0.252	0	0	1	1.0915134	-4.4126555	110	3	1.12	0.95	93.2384	-0.2232	0.0000	0.0000;
	908	1	0	0	0	0	1	1.0915134	-4.4126555	110	3	1.12	0.95	93.2385	-0.2232	0.0000	0.0000;
	909	1	3.349	0.715	0	0	1	1.1102126	-4.3830476	110	3	1.12	0.95	91.8822	-0.0144	0.0000	0.0000;
	910	1	1.674	0.498	0	0	1	1.1044642	-4.0387115	110	3	1.12	0.95	91.8547	-0.0187	0.0000	0.0000;
	911	1	1.004	0.13	0	0	1	1.1031486	-5.4049322	110	3	1.12	0.95	92.3323	-0.0281	0.0000	0.0000;
	912	1	0	0	0	0	1	1.103255	-5.3874518	110	3	1.12	0.95	92.3165	-0.0299	0.0000	0.0000;
	913	1	0	0	0	0	1	1.0986121	-5.0142326	110	3	1.12	0.95	92.6005	-0.1397	0.0000	0.0000;
	914	1	7.113	0.867	0	0	1	1.0982346	-4.7764948	110	3	1.12	0.95	92.4082	-0.0093	0.0000	0.0000;
	915	1	9.623	2.167	0	0	1	1.0982001	-4.7775612	110	3	1.12	0.95	92.4114	-0.0076	0.0000	0.0000;
	916	1	8.805	1.82	0	0	1	1.0985333	-5.0184256	110	3	1.12	0.95	92.6105	-0.1376	0.0000	0.0000;
	917	1	4.997	-0.478	0	0	1	1.0932692	-5.7293094	110	3	1.12	0.95	92.8935	-0.2421	0.0000	0.0000;
	918	1	3.817	0.928	0	0	1	1.0932526	-5.7352982	110	3	1.12	0.95	92.8944	-0.2425	0.0000	0.0000;
	919	1	0.502	0.166	0	0	1	1.0913077	-4.0329857	110	3	1.12	0.95	92.0733	-0.1981	0.0000	0.0000;
	920	1	1.172	0.293	0	0	1	1.0912998	-4.0350028	110	3	1.12	0.95	92.0746	-0.1981	0.0000	0.0000;
	921	1	5.355	0.303	0	0	1	1.1028524	-6.1457861	110	3	1.12	0.95	92.7466	0.2621	0.0000	0.0000;
	922	1	1.757	0.13	0	0	1	1.1026695	-6.2470034	110	3	1.12	0.95	92.8215	0.2311	0.0000	0.0000;
	923	1	2.428	0.042	0	0	1	1.0973229	-3.6086351	110	3	1.12	0.95	91.7787	-0.0223	0.0000	0.0000;
	924	1	0	0	0	0	1	1.0972449	-3.601423	110	3	1.12	0.95	91.7766	-0.0156	0.0000	0.0000;
	925	1	0	0	0	0	1	1.097338	-3.606448	110	3	1.12	0.95	91.7763	-0.0223	0.0000	0.0000;
	926	1	0	0	0	0	1	1.097244	-3.6014069	110	3	1.12	0.95	91.7766	-0.0156	0.0000	0.0000;
	927	1	0	0	0	0	1	1.1035268	-2.0357817	110	3	1.12	0.95	91.5562	-0.3342	0.0000	0.0000;
	928	1	1.256	0.12	0	0	1	1.1035265	-2.0387028	110	3	1.12	0.95	91.5575	-0.3345	0.0000	0.0000;
	929	1	4.188	0.965	0	0	1	1.1052464	-4.9319968	110	3	1.12	0.95	92.4090	0.0658	0.0000	0.0000;
	930	1	2.093	0.705	0	0	1	1.1084883	-4.5754776	110	3	1.12	0.95	92.0484	0.0038	0.0000	0.0000;
	931	1	5.028	1.163	0	0	1	1.0819701	-6.5198826	110	3	1.12	0.95	93.8410	-0.4993	0.0000	0.0000;
	932	1	4.864	-1.124	0	0	1	1.0819537	-6.518744	110	3	1.12	0.95	93.8405	-0.5035	0.0000	0.0000;
	933	1	4.862	-0.9	0	0	1	1.0948006	-6.5094873	110	3	1.12	0.95	93.6139	0.0045	0.0000	0.0000;
	934	1	4.435	0.936	0	0	1	1.0947993	-6.5138294	110	3	1.12	0.95	93.6130	0.0052	0.0000	0.0000;
	935	1	1.732	0.31	0	0	1	1.0909682	-7.4180573	110	3	1.12	0.95	94.2785	0.2119	0.0000	0.0000;
	936	1	2.295	0.366	0	0	1	1.0909836	-7.4186764	110	3	1.12	0.95	94.2789	0.2102	0.0000	0.0000;
	937	1	0	0	0	0	1	1.0970719	-3.622353	110	3	1.12	0.95	91.8010	-0.0139	0.0000	0.0000;
	938	1	0	0	0	0	1	1.0970651	-3.6222473	110	3	1.12	0.95	91.8010	-0.0136	0.0000	0.0000;
	939	1	2.185	0.477	0	0	1	1.0964943	-5.4433574	110	3	1.12	0.95	92.4764	-0.2031	0.0000	0.0000;
	940	1	3.478	1.363	0	0	1	1.0965159	-5.4483543	110	3	1.12	0.95	92.4761	-0.2007	0.0000	0.0000;
	941	1	2.512	0.822	0	0	1	1.1091275	-4.4053141	110	3	1.12	0.95	91.9627	0.0465	0.0000	0.0000;
	942	1	0	0	0	0	1	1.1091183	-4.4075698	110	3	1.12	0.95	91.9638	0.0466	0.0000	0.0000;
	943	1	2.092	0.39	0	0	1	1.1089462	-5.6646453	110	3	1.12	0.95	92.1103	0.1136	0.0000	0.0000;
	944	1	2.51	0.173	0	0	1	1.1012736	-6.5531612	110	3	1.12	0.95	92.9269	0.1988	0.0000	0.0000;
	945	1	0	0	0	0	1	1.1090702	-5.6514919	110	3	1.12	0.95	92.0958	0.1116	0.0000	0.0000;
	946	1	2.512	0.605	0	0	1	1.098612	-5.014229	110	3	1.12	0.95	92.6005	-0.1397	0.0000	0.0000;
	947	1	2.093	0.345	0	0	1	1.0982985	-4.7723639	110	3	1.12	0.95	92.3992	-0.0103	0.0000	0.0000;
	948	1	0	0	0	0	1	1.0982461	-3.7685056	110	3	1.12	0.95	91.8267	-0.1554	0.0000	0.0000;
	949	1	0.418	0.036	0	0	1	1.0982754	-3.7651612	110	3	1.12	0.95	91.8259	-0.1556	0.0000	0.0000;
	950	1	1.675	0.527	0	0	1	1.0996185	-2.8366549	110	3	1.12	0.95	91.5357	-0.2341	0.0000	0.0000;
	951	1	0	0	0	0	1	1.0998633	-2.8126149	110	3	1.12	0.95	91.5119	-0.2389	0.0000	0.0000;
	952	1	1.341	0.252	0	0	1	1.1008237	-3.151719	110	3	1.12	0.95	91.2524	0.0732	0.0000	0.0000;
	953	1	0	0	0	0	1	1.1008646	-3.1497133	110	3	1.12	0.95	91.2468	0.0722	0.0000	0.0000;
	954	1	0.837	0.219	0	0	1	1.101911	-5.3432857	110	3	1.12	0.95	92.6627	0.0687	0.0000	0.0000;
	955	1	4.101	0.971	0	0	1	1.1019037	-5.3454561	110	3	1.12	0.95	92.6619	0.0681	0.0000	0.0000;
	956	1	3.959	0.494	0	0	1	1.0917258	-5.920936	110	3	1.12	0.95	93.0736	-0.2440	0.0000	0.0000;
	957	1	1.474	-3.024	0	0	1	1.0917378	-5.9151393	110	3	1.12	0.95	93.0719	-0.2421	0.0000	0.0000;
	958	1	0	0	0	0	1	1.1006127	-2.6860713	110	3	1.12	0.95	91.3806	-0.2256	0.0000	0.0000;
	959	1	0	0	0	0	1	1.1006132	-2.6907147	110	3	1.12	0.95	91.3809	-0.2259	0.0000	0.0000;
	960	1	1.005	0.203	0	0	1	1.0792586	-6.1363	110	3	1.12	0.95	93.1655	-0.9371	0.0000	0.0000;
	961	1	0	0	0	0	1	1.0792431	-6.1400285	110	3	1.12	0.95	93.1666	-0.9374	0.0000	0.0000;
	962	1	1.843	0.175	0	0	1	1.0974142	-3.7856642	110	3	1.12	0.95	91.9730	-0.0376	0.0000	0.0000;
	963	1	0	0	0	0	1	1.0974047	-3.7844022	110	3	1.12	0.95	91.9738	-0.0375	0.0000	0.0000;
	964	1	0	0	0	0	1	1.1023058	-2.2574147	110	3	1.12	0.95	91.7272	-0.2929	0.0000	0.0000;
	965	1	6.945	0	0	0	1	1.1023086	-2.2579806	110	3	1.12	0.95	91.7275	-0.2930	0.0000	0.0000;
	966	1	2.01	0.228	0	0	1	1.0969322	-3.7431006	110	3	1.12	0.95	92.1096	-0.1349	0.0000	0.0000;
	967	1	0	0	0	0	1	1.0969301	-3.7393776	110	3	1.12	0.95	92.1081	-0.1349	0.0000	0.0000;
	968	1	0.837	0.173	0	0	1	1.1090435	-5.6546617	110	3	1.12	0.95	92.0989	0.1119	0.0000	0.0000;
	969	1	0	0	0	0	1	1.1090056	-5.6651385	110	3	1.12	0.95	92.1012	0.1118	0.0000	0.0000;
	970	1	2.277	0.124	0	0	1	1.1017018	-5.6279126	110	3	1.12	0.95	92.5462	-0.0201	0.0000	0.0000;
	971	1	0.636	0.011	0	0	1	1.1017145	-5.6232342	110	3	1.12	0.95	92.5448	-0.0202	0.0000	0.0000;
	972	1	1.423	-0.228	0	0	1	1.0977589	-3.8701423	110	3	1.12	0.95	91.9553	-0.0650	0.0000	0.0000;
	973	1	1.674	-0.37	0	0	1	1.0977562	-3.8703131	110	3	1.12	0.95	91.9565	-0.0650	0.0000	0.0000;
	974	1	2.511	0.585	0	0	1	1.1040068	-3.9836352	110	3	1.12	0.95	91.7194	0.0078	0.0000	0.0000;
	975	1	2.176	0.542	0	0	1	1.1040208	-3.9779533	110	3	1.12	0.95	91.7185	0.0081	0.0000	0.0000;
	976	1	12.554	4.328	0	0	1	1.1085599	-4.4790611	110	3	1.12	0.95	92.0542	0.0506	0.0000	0.0000;
	977	2	0	4	0	0	1	1.1140499	-3.7697166	110	3	1.12	0.95	91.3097	0.0000	0.0000	0.0000;
	978	1	2.093	0.498	0	0	1	1.1008081	-5.5204226	110	3	1.12	0.95	92.5468	0.0081	0.0000	0.0000;
	979	1	4.437	0.975	0	0	1	1.1008038	-5.5197499	110	3	1.12	0.95	92.5467	0.0077	0.0000	0.0000;
	980	1	8.619	0.867	0	0	1	1.1162961	-4.825939	110	3	1.12	0.95	91.3561	0.0169	0.0000	0.0000;
	981	1	0	0	0	0	1	1.1163291	-4.8145231	110	3	1.12	0.95	91.3530	0.0167	0.0000	0.0000;
	982	1	3.767	0.888	0	0	1	1.1014667	-4.3148627	110	3	1.12	0.95	92.0319	0.0070	0.0000	0.0000;
	983	1	0	0.065	0	0	1	1.1014499	-4.3237761	110	3	1.12	0.95	92.0319	0.0059	0.0000	0.0000;
	984	1	1.004	0.217	0	0	1	1.1033577	-2.9388669	110	3	1.12	0.95	92.5590	-0.7563	0.0000	0.0000;
	985	1	0	0	0	0	1	1.1033578	-2.9388278	110	3	1.12	0.95	92.5590	-0.7563	0.0000	0.0000;
	986	1	1.34	0.087	0	0	1	1.1028891	-2.2796967	110	3	1.12	0.95	91.0820	-0.2141	0.0000	0.0000;
	987	1	0	0	0	0	1	1.1028947	-2.2724874	110	3	1.12	0.95	91.0820	-0.2137	0.0000	0.0000;
	988	1	5.355	0.607	0	0	1	1.0970335	-3.942016	110	3	1.12	0.95	91.8785	-0.2017	0.0000	0.0000;
	989	1	3.012	0.823	0	0	1	1.097013	-3.9432669	110	3	1.12	0.95	91.8781	-0.2022	0.0000	0.0000;
	990	1	8.319	1.259	0	0	1	1.0930462	-7.3019509	110	3	1.12	0.95	94.0689	0.1724	0.0000	0.0000;
	991	1	2.26	0.631	0	0	1	1.0930681	-7.2975068	110	3	1.12	0.95	94.0663	0.1733	0.0000	0.0000;
	992	1	2.262	0.536	0	0	1	1.1115355	-4.2743525	110	3	1.12	0.95	91.8055	-0.0360	0.0000	0.0000;
	993	1	0	0	0	0	1	1.1115809	-4.2699597	110	3	1.12	0.95	91.8013	-0.0369	0.0000	0.0000;
	994	1	3.197	0.021	0	0	1	1.0902244	-5.5597614	110	3	1.12	0.95	92.7745	-0.0113	0.0000	0.0000;
	995	1	3.206	0.147	0	0	1	1.0902311	-5.5665718	110	3	1.12	0.95	92.7763	-0.0114	0.0000	0.0000;
	996	1	2.26	0.758	0	0	1	1.1069703	-4.7041736	110	3	1.12	0.95	92.1929	0.0592	0.0000	0.0000;
	997	1	1.34	0.48	0	0	1	1.1096036	-4.4504175	110	3	1.12	0.95	91.9414	-0.0071	0.0000	0.0000;
	998	1	3.951	0.906	0	0	1	1.0904527	-5.461527	110	3	1.12	0.95	92.6702	0.0027	0.0000	0.0000;
	999	1	3.859	0.801	0	0	1	1.0899029	-6.1307246	110	3	1.12	0.95	93.2315	-0.1282	0.0000	0.0000;
	1000	1	13.89	3.38	0	0	1	1.1034502	-4.0423919	110	3	1.12	0.95	91.8548	0.0260	0.0000	0.0000;
	1001	1	0	0	0	0	1	1.1034755	-4.0388005	110	3	1.12	0.95	91.8536	0.0257	0.0000	0.0000;
	1002	2	22.184	51.733	0	0	1	1.1095971	-0.03829323	110	3	1.12	0.95	90.0300	-0.0976	0.0000	0.0000;
	1003	1	5.02	1.734	0	0	1	1.1046554	-1.6825082	110	3	1.12	0.95	91.0799	-0.2024	0.0000	0.0000;
	1004	1	1.759	0.178	0	0	1	1.1032151	-2.2303664	110	3	1.12	0.95	91.7323	-0.3733	0.0000	0.0000;
	1005	1	1.507	-0.197	0	0	1	1.1032133	-2.2289618	110	3	1.12	0.95	91.7316	-0.3732	0.0000	0.0000;
	1006	2	10.199	3.344	0	0	1	1.1137581	-5.0592099	110	3	1.12	0.95	91.5486	0.0654	0.0000	0.0000;
	1007	2	0	0	0	0	1	1.1137457	-5.0656861	110	3	1.12	0.95	91.5495	0.0651	0.0000	0.0000;
	1008	1	0	0	0	0	1	1.1108289	-4.332566	110	3	1.12	0.95	91.8479	-0.0244	0.0000	0.0000;
	1009	1	0	0	0	0	1	1.1108307	-4.3322898	110	3	1.12	0.95	91.8479	-0.0244	0.0000	0.0000;
	1010	1	4.287	1.052	0	0	1	1.0897327	-5.9694856	110	3	1.12	0.95	93.1657	-0.2863	0.0000	0.0000;
	1011	1	1.766	0.802	0	0	1	1.0897041	-5.9743625	110	3	1.12	0.95	93.1682	-0.2880	0.0000	0.0000;
	1012	1	12.673	1.71	0	0	1	1.0816433	-6.1014243	110	3	1.12	0.95	93.1658	-0.7297	0.0000	0.0000;
	1013	1	0	0	0	0	1	1.0816377	-6.0927174	110	3	1.12	0.95	93.1631	-0.7339	0.0000	0.0000;
	1014	2	5.847	2.157	0	0	1	1.1018225	-5.3671261	110	3	1.12	0.95	92.3810	-0.0255	0.0000	0.0000;
	1015	1	24.266	1.733	0	0	1	1.0986216	-6.0335864	110	3	1.12	0.95	92.9217	-0.0211	0.0000	0.0000;
	1016	1	0	0	0	0	1	1.1004701	-5.8051037	110	3	1.12	0.95	92.7190	-0.0111	0.0000	0.0000;
	1017	1	0.587	0.236	0	0	1	1.1049836	-1.8358925	110	3	1.12	0.95	90.7779	-0.1904	0.0000	0.0000;
	1018	1	0	0	0	0	1	1.104985	-1.8358423	110	3	1.12	0.95	90.7778	-0.1904	0.0000	0.0000;
	1019	1	6.694	1.083	0	0	1	1.0927315	-4.1486089	110	3	1.12	0.95	92.1180	-0.0891	0.0000	0.0000;
	1020	1	0	0	0	0	1	1.0928049	-4.1442282	110	3	1.12	0.95	92.1165	-0.0892	0.0000	0.0000;
	1021	1	1.76	0.343	0	0	1	1.0695262	-5.9266465	110	3	1.12	0.95	93.6728	-0.8931	0.0000	0.0000;
	1022	1	0	0	0	0	1	1.069539	-5.9254178	110	3	1.12	0.95	93.6714	-0.8933	0.0000	0.0000;
	1023	1	0.017	0.074	0	0	1	1.1040891	-3.9854267	110	3	1.12	0.95	91.7950	0.0109	0.0000	0.0000;
	1024	1	0	0	0	0	1	1.1040907	-3.9854266	110	3	1.12	0.95	91.7949	0.0108	0.0000	0.0000;
	1025	2	17.995	7.07	0	0	1	1.093252	-7.5013408	110	3	1.12	0.95	94.3556	0.0130	0.0000	0.0000;
	1026	1	0	0	0	0	1	1.0931793	-7.4952227	110	3	1.12	0.95	94.3539	0.0144	0.0000	0.0000;
	1027	1	0	0	0	0	1	1.0931496	-7.4926765	110	3	1.12	0.95	94.3546	0.0149	0.0000	0.0000;
	1028	1	0	0	0	0	1	1.0948492	-6.9682785	110	3	1.12	0.95	93.8733	0.0841	0.0000	0.0000;
	1029	1	0	0	0	0	1	1.0990906	-3.4356749	110	3	1.12	0.95	91.5013	-0.0335	0.0000	0.0000;
	1030	1	0	0	0	0	1	1.0990904	-3.4356717	110	3	1.12	0.95	91.5013	-0.0335	0.0000	0.0000;
	1031	1	0	0	0	0	1	1.1108292	-4.3325701	110	3	1.12	0.95	91.8479	-0.0244	0.0000	0.0000;
	1032	1	0	0	0	0	1	1.1108309	-4.3322938	110	3	1.12	0.95	91.8479	-0.0244	0.0000	0.0000;
	1033	1	0	0	0	0	1	1.0952058	-4.027798	110	3	1.12	0.95	91.9768	-0.1524	0.0000	0.0000;
	1034	1	0	0	0	0	1	1.0952056	-4.0277933	110	3	1.12	0.95	91.9768	-0.1524	0.0000	0.0000;
	1035	1	0	0	0	0	1	1.1102341	-4.3812725	110	3	1.12	0.95	91.8801	-0.0149	0.0000	0.0000;
	1036	1	0	0	0	0	1	1.1015075	-5.5240865	110	3	1.12	0.95	92.5635	0.0031	0.0000	0.0000;
	1037	1	0	0	0	0	1	1.1015047	-5.5273301	110	3	1.12	0.95	92.5649	0.0035	0.0000	0.0000;
	1038	1	0.167	0	0	0	1	1.1178837	-4.6119153	110	3	1.12	0.95	91.1499	0.0006	0.0000	0.0000;
	1039	1	0	0	0	0	1	1.1178825	-4.6123443	110	3	1.12	0.95	91.1500	0.0006	0.0000	0.0000;
	1040	1	0	0	0	0	1	1.1043642	-4.0525231	110	3	1.12	0.95	91.8688	-0.0179	0.0000	0.0000;
	1041	1	0	0	0	0	1	1.1043642	-4.0525221	110	3	1.12	0.95	91.8688	-0.0179	0.0000	0.0000;
	1042	1	1.674	0.173	0	0	1	1.1098537	-4.3771005	110	3	1.12	0.95	91.9474	0.0143	0.0000	0.0000;
	1043	1	0.251	0.13	0	0	1	1.1098608	-4.3773521	110	3	1.12	0.95	91.9475	0.0141	0.0000	0.0000;
	1044	1	0	0	0	0	1	1.1178839	-4.6118707	110	3	1.12	0.95	91.1499	0.0006	0.0000	0.0000;
	1045	1	0	0	0	0	1	1.1178825	-4.612344	110	3	1.12	0.95	91.1500	0.0006	0.0000	0.0000;
	1046	1	5.526	0.368	0	0	1	1.1050429	-4.9602216	110	3	1.12	0.95	92.4381	0.0674	0.0000	0.0000;
	1047	1	0	0	0	0	1	1.1084954	-4.5755897	110	3	1.12	0.95	92.0484	0.0034	0.0000	0.0000;
	1048	1	1.079	0.1	0	0	1	1.0911777	-7.4185291	110	3	1.12	0.95	94.2736	0.1850	0.0000	0.0000;
	1049	1	2.184	0.364	0	0	1	1.0911986	-7.4178209	110	3	1.12	0.95	94.2736	0.1831	0.0000	0.0000;
	1050	1	2.679	0.532	0	0	1	1.1047542	-5.1618123	110	3	1.12	0.95	92.0560	-0.0032	0.0000	0.0000;
	1051	1	1.758	0.402	0	0	1	1.1047771	-5.1538797	110	3	1.12	0.95	92.0523	-0.0026	0.0000	0.0000;
	1052	1	0.167	0.078	0	0	1	1.0911048	-4.0151476	110	3	1.12	0.95	92.0395	-0.1698	0.0000	0.0000;
	1053	1	0	0.035	0	0	1	1.0910795	-4.0164028	110	3	1.12	0.95	92.0395	-0.1690	0.0000	0.0000;
	1054	1	0	0.065	0	0	1	1.1061317	-1.738128	110	3	1.12	0.95	91.0304	-0.2553	0.0000	0.0000;
	1055	1	1.171	0.043	0	0	1	1.1029628	-1.951922	110	3	1.12	0.95	91.3795	-0.2177	0.0000	0.0000;
	1056	1	1.34	0.314	0	0	1	1.0889584	-4.0306405	110	3	1.12	0.95	92.0514	0.0369	0.0000	0.0000;
	1057	1	0	0	0	0	1	1.0889944	-4.0290824	110	3	1.12	0.95	92.0466	0.0359	0.0000	0.0000;
	1058	1	3.1	0.299	0	0	1	1.1036454	-2.5403881	110	3	1.12	0.95	92.1268	-0.5875	0.0000	0.0000;
	1059	1	0	0	0	0	1	1.1036625	-2.5433461	110	3	1.12	0.95	92.1278	-0.5881	0.0000	0.0000;
	1060	1	1.506	0.173	0	0	1	1.0971904	-3.6098022	110	3	1.12	0.95	91.7843	-0.0152	0.0000	0.0000;
	1061	1	1.925	0.26	0	0	1	1.0971933	-3.6071058	110	3	1.12	0.95	91.7828	-0.0148	0.0000	0.0000;
	1062	1	4.351	0.52	0	0	1	1.1039351	-4.1051748	110	3	1.12	0.95	91.9243	-0.0128	0.0000	0.0000;
	1063	1	2.594	0.303	0	0	1	1.1039311	-4.1062708	110	3	1.12	0.95	91.9247	-0.0128	0.0000	0.0000;
	1064	1	1.516	0.038	0	0	1	1.0767243	-6.4032887	110	3	1.12	0.95	93.4461	-0.9270	0.0000	0.0000;
	1065	1	0	0	0	0	1	1.0920952	-4.2014625	110	3	1.12	0.95	92.9680	-0.1112	0.0000	0.0000;
	1066	1	3.521	0.963	0	0	1	1.0920836	-4.1997871	110	3	1.12	0.95	92.9678	-0.1110	0.0000	0.0000;
	1067	1	0	0	0	0	1	1.0949031	-7.1522375	110	3	1.12	0.95	93.8115	0.1795	0.0000	0.0000;
	1068	1	1.255	0.228	0	0	1	1.0949268	-7.1467529	110	3	1.12	0.95	93.8086	0.1804	0.0000	0.0000;
	1069	1	0.335	0.066	0	0	1	1.0949011	-7.1522036	110	3	1.12	0.95	93.8115	0.1796	0.0000	0.0000;
	1070	1	16.066	3.467	0	0	1	1.0990981	-2.3656363	110	3	1.12	0.95	91.8184	-0.1458	0.0000	0.0000;
	1071	1	15.062	2.253	0	0	1	1.099119	-2.3617076	110	3	1.12	0.95	91.8169	-0.1462	0.0000	0.0000;
	1072	1	2.679	0.845	0	0	1	1.1046528	-3.8604957	110	3	1.12	0.95	91.6904	0.0233	0.0000	0.0000;
	1073	1	2.26	0.542	0	0	1	1.1046673	-3.8567514	110	3	1.12	0.95	91.6879	0.0227	0.0000	0.0000;
	1074	1	2.646	0.373	0	0	1	1.0901337	-5.7790572	110	3	1.12	0.95	92.9646	-0.0675	0.0000	0.0000;
	1075	1	2.646	0.235	0	0	1	1.0901518	-5.7828326	110	3	1.12	0.95	92.9652	-0.0678	0.0000	0.0000;
	1076	1	1.172	0.127	0	0	1	1.1051639	-1.774428	110	3	1.12	0.95	91.1069	-0.2284	0.0000	0.0000;
	1077	1	2.094	0.361	0	0	1	1.1051481	-1.7735442	110	3	1.12	0.95	91.1072	-0.2282	0.0000	0.0000;
	1078	1	0	0	0	0	1	1.0831979	-6.8119056	110	3	1.12	0.95	93.8051	-0.9769	0.0000	0.0000;
	1079	1	0	0	0	0	1	1.0831695	-6.811722	110	3	1.12	0.95	93.8046	-0.9778	0.0000	0.0000;
	1080	1	1.843	0.661	0	0	1	1.1038154	-2.3040131	110	3	1.12	0.95	91.8998	-0.5096	0.0000	0.0000;
	1081	1	0.92	0.038	0	0	1	1.1038234	-2.30481	110	3	1.12	0.95	91.9000	-0.5097	0.0000	0.0000;
	1082	1	4.435	0.217	0	0	1	1.0972398	-3.9027734	110	3	1.12	0.95	91.8251	-0.2000	0.0000	0.0000;
	1083	1	0	0	0	0	1	1.0971801	-3.9072815	110	3	1.12	0.95	91.8206	-0.2010	0.0000	0.0000;
	1084	1	0	0	0	0	1	1.0972511	-3.901403	110	3	1.12	0.95	91.8235	-0.2000	0.0000	0.0000;
	1085	1	0	0	0	0	1	1.0971796	-3.9072726	110	3	1.12	0.95	91.8206	-0.2010	0.0000	0.0000;
	1086	1	1.674	0.089	0	0	1	1.1055304	-1.7893986	110	3	1.12	0.95	91.1005	-0.2461	0.0000	0.0000;
	1087	1	0.92	0.038	0	0	1	1.1055436	-1.7881054	110	3	1.12	0.95	91.0995	-0.2462	0.0000	0.0000;
	1088	1	0.837	0.306	0	0	1	1.0815977	-5.4133847	110	3	1.12	0.95	92.4865	-0.8568	0.0000	0.0000;
	1089	1	0.837	0.391	0	0	1	1.0816351	-5.4172764	110	3	1.12	0.95	92.4875	-0.8564	0.0000	0.0000;
	1090	1	0.837	0	0	0	1	1.1038416	-2.71739	110	3	1.12	0.95	90.7022	0.0406	0.0000	0.0000;
	1091	1	0	0	0	0	1	1.1038963	-2.6998602	110	3	1.12	0.95	90.6949	0.0409	0.0000	0.0000;
	1092	1	3.012	0.043	0	0	1	1.1029774	-1.9506634	110	3	1.12	0.95	91.3772	-0.2177	0.0000	0.0000;
	1093	1	1.004	0.217	0	0	1	1.1061328	-1.7381591	110	3	1.12	0.95	91.0304	-0.2554	0.0000	0.0000;
	1094	1	2.512	0.778	0	0	1	1.0836662	-4.9898311	110	3	1.12	0.95	92.0932	-1.0000	0.0000	0.0000;
	1095	1	0	0	0	0	1	1.0837653	-4.9861958	110	3	1.12	0.95	92.0810	-1.0036	0.0000	0.0000;
	1096	1	2.243	0.429	0	0	1	1.0792373	-6.6672031	110	3	1.12	0.95	93.7245	-0.9427	0.0000	0.0000;
	1097	1	1.751	0.348	0	0	1	1.079194	-6.6657772	110	3	1.12	0.95	93.7251	-0.9452	0.0000	0.0000;
	1098	1	0.335	0.043	0	0	1	1.1146764	-4.9451119	110	3	1.12	0.95	91.4725	0.0596	0.0000	0.0000;
	1099	1	0	0	0	0	1	1.1166354	-4.7750528	110	3	1.12	0.95	91.3110	0.0142	0.0000	0.0000;
	1100	1	0	0	0	0	1	1.1146836	-4.9443579	110	3	1.12	0.95	91.4713	0.0596	0.0000	0.0000;
	1101	1	0	0	0	0	1	1.1166344	-4.7750353	110	3	1.12	0.95	91.3110	0.0142	0.0000	0.0000;
	1102	1	0	0	0	0	1	1.0998335	-2.8213736	110	3	1.12	0.95	91.4850	-0.2376	0.0000	0.0000;
	1103	1	3.18	0.52	0	0	1	1.099838	-2.825864	110	3	1.12	0.95	91.4835	-0.2382	0.0000	0.0000;
	1104	1	0	0	0	0	1	1.1065539	-5.9697061	110	3	1.12	0.95	92.3966	0.1332	0.0000	0.0000;
	1105	1	5.862	0.932	0	0	1	1.0965606	-3.6786143	110	3	1.12	0.95	91.8601	-0.0055	0.0000	0.0000;
	1106	1	0	0	0	0	1	1.1065503	-5.9696479	110	3	1.12	0.95	92.3966	0.1334	0.0000	0.0000;
	1107	1	0	0	0	0	1	1.096736	-3.6601672	110	3	1.12	0.95	91.8402	-0.0086	0.0000	0.0000;
	1108	1	0.084	0.065	0	0	1	1.104775	-1.980517	110	3	1.12	0.95	91.3382	-0.2842	0.0000	0.0000;
	1109	1	1.172	-0.327	0	0	1	1.1047686	-1.9825635	110	3	1.12	0.95	91.3395	-0.2843	0.0000	0.0000;
	1110	1	0.837	0.173	0	0	1	1.1049535	-3.8411389	110	3	1.12	0.95	91.6082	0.0053	0.0000	0.0000;
	1111	1	0	0	0	0	1	1.1049319	-3.848121	110	3	1.12	0.95	91.6095	0.0051	0.0000	0.0000;
	1112	1	1.842	0.277	0	0	1	1.1038306	-2.8647308	110	3	1.12	0.95	92.4303	-0.7234	0.0000	0.0000;
	1113	1	1.591	0.366	0	0	1	1.092271	-4.2929636	110	3	1.12	0.95	93.1007	-0.2244	0.0000	0.0000;
	1114	2	4.169	7.947	0	0	1	1.1106157	-4.3424973	110	3	1.12	0.95	91.9086	-0.0133	0.0000	0.0000;
	1115	1	0	0	0	0	1	1.0972702	-3.5980185	110	3	1.12	0.95	91.7729	-0.0158	0.0000	0.0000;
	1116	1	0	0	0	0	1	1.1066155	-5.9527713	110	3	1.12	0.95	92.3794	0.1355	0.0000	0.0000;
	1117	1	3.685	0.637	0	0	1	1.107308	-0.88886662	110	3	1.12	0.95	90.4804	-0.1251	0.0000	0.0000;
	1118	1	3.6	0.514	0	0	1	1.107299	-0.90644565	110	3	1.12	0.95	90.4842	-0.1257	0.0000	0.0000;
	1119	1	2.068	-0.765	0	0	1	1.0826459	-7.7102515	110	3	1.12	0.95	94.6911	0.8308	0.0000	0.0000;
	1120	1	2.303	-0.251	0	0	1	1.0827933	-7.6951922	110	3	1.12	0.95	94.6829	0.8284	0.0000	0.0000;
	1121	1	5.021	1.603	0	0	1	1.0833148	-6.5253075	110	3	1.12	0.95	93.8687	-0.4523	0.0000	0.0000;
	1122	1	0.502	0	0	0	1	1.0834066	-6.5183404	110	3	1.12	0.95	93.8640	-0.4498	0.0000	0.0000;
	1123	1	0	0	0	0	1	1.0998646	-2.8170628	110	3	1.12	0.95	91.4809	-0.2374	0.0000	0.0000;
	1124	1	2.093	0.491	0	0	1	1.0997885	-2.8317531	110	3	1.12	0.95	91.4897	-0.2381	0.0000	0.0000;
	1125	1	0	0	0	0	1	1.0998643	-2.8170554	110	3	1.12	0.95	91.4809	-0.2373	0.0000	0.0000;
	1126	1	0	0	0	0	1	1.0998199	-2.8298854	110	3	1.12	0.95	91.4860	-0.2389	0.0000	0.0000;
	1127	1	1.005	0.126	0	0	1	1.0993325	-2.9062534	110	3	1.12	0.95	91.5576	-0.2489	0.0000	0.0000;
	1128	1	0	0	0	0	1	1.0997654	-2.8553762	110	3	1.12	0.95	91.4956	-0.2471	0.0000	0.0000;
	1129	1	0	0	0	0	1	1.0993416	-2.9051894	110	3	1.12	0.95	91.5564	-0.2491	0.0000	0.0000;
	1130	1	0	0	0	0	1	1.0997654	-2.8553761	110	3	1.12	0.95	91.4956	-0.2471	0.0000	0.0000;
	1131	1	13.432	3.246	0	0	1	1.0989316	-3.6243432	110	3	1.12	0.95	91.4385	-0.2010	0.0000	0.0000;
	1132	1	7.292	0.88	0	0	1	1.0991376	-2.9192981	110	3	1.12	0.95	91.5846	-0.2457	0.0000	0.0000;
	1133	1	6.867	3.209	0	0	1	1.0992885	-2.8699706	110	3	1.12	0.95	91.5305	-0.2241	0.0000	0.0000;
	1134	1	5.274	0.252	0	0	1	1.0993041	-2.8720887	110	3	1.12	0.95	91.5301	-0.2248	0.0000	0.0000;
	1135	1	1.674	0.177	0	0	1	1.0973557	-3.8648683	110	3	1.12	0.95	91.9103	-0.3136	0.0000	0.0000;
	1136	1	1.256	0.522	0	0	1	1.0973634	-3.8680992	110	3	1.12	0.95	91.9103	-0.3134	0.0000	0.0000;
	1137	1	1.423	0.303	0	0	1	1.108525	-4.4823559	110	3	1.12	0.95	92.0579	0.0513	0.0000	0.0000;
	1138	1	59.411	15.471	0	0	1	1.1010158	-6.5388012	110	3	1.12	0.95	92.9261	0.2164	0.0000	0.0000;
	1139	1	0	0	0	0	1	1.1072397	-4.749495	110	3	1.12	0.95	92.2768	0.0383	0.0000	0.0000;
	1140	1	39.831	8.451	0	0	1	1.1059468	-4.8830985	110	3	1.12	0.95	92.4046	0.0635	0.0000	0.0000;
	1141	1	0	0	0	0	1	1.1072396	-4.7494935	110	3	1.12	0.95	92.2768	0.0383	0.0000	0.0000;
	1142	1	0	0	0	0	1	1.1014247	-6.5047026	110	3	1.12	0.95	92.8882	0.2065	0.0000	0.0000;
	1143	1	0	0	0	0	1	1.1065141	-4.8281211	110	3	1.12	0.95	92.3498	0.0518	0.0000	0.0000;
	1144	1	6.694	1.733	0	0	1	1.0975325	-3.8180826	110	3	1.12	0.95	91.8771	-0.1373	0.0000	0.0000;
	1145	1	16.735	1.3	0	0	1	1.09752	-3.8188605	110	3	1.12	0.95	91.8770	-0.1373	0.0000	0.0000;
	1146	1	0	0	0	0	1	1.0975352	-3.8184166	110	3	1.12	0.95	91.8753	-0.1380	0.0000	0.0000;
	1147	1	0.418	0.13	0	0	1	1.0969598	-3.9437579	110	3	1.12	0.95	91.8773	-0.2016	0.0000	0.0000;
	1148	1	0.837	0.087	0	0	1	1.0964149	-3.9888883	110	3	1.12	0.95	91.8740	-0.2042	0.0000	0.0000;
	1149	1	0.837	0	0	0	1	1.103894	-1.9880273	110	3	1.12	0.95	91.5377	-0.3103	0.0000	0.0000;
	1150	1	2.343	0.867	0	0	1	1.1038799	-1.9869447	110	3	1.12	0.95	91.5387	-0.3100	0.0000	0.0000;
	1151	1	0.837	0	0	0	1	1.1107789	-4.2531216	110	3	1.12	0.95	91.7924	0.0168	0.0000	0.0000;
	1152	1	0.669	0.087	0	0	1	1.1107928	-4.2465467	110	3	1.12	0.95	91.7905	0.0168	0.0000	0.0000;
	1153	2	17.017	3.009	0	0	1	1.0883609	-5.9058713	110	3	1.12	0.95	93.1565	-0.0103	0.0000	0.0000;
	1154	2	14.773	2.629	0	0	1	1.0884606	-5.8993048	110	3	1.12	0.95	93.1437	-0.0117	0.0000	0.0000;
	1155	2	17.067	3.019	0	0	1	1.0909653	-5.5620711	110	3	1.12	0.95	92.7739	-0.1178	0.0000	0.0000;
	1156	1	7.566	1.514	0	0	1	1.0885251	-5.9359561	110	3	1.12	0.95	93.1749	-0.0365	0.0000	0.0000;
	1157	1	3.783	0.757	0	0	1	1.0885061	-5.934594	110	3	1.12	0.95	93.1754	-0.0358	0.0000	0.0000;
	1158	1	19.4	6.163	0	0	1	1.0885991	-5.9658348	110	3	1.12	0.95	93.1767	-0.0557	0.0000	0.0000;
	1159	1	1.674	0.817	0	0	1	1.0904348	-5.542585	110	3	1.12	0.95	92.7335	-0.0327	0.0000	0.0000;
	1160	1	7.982	1.459	0	0	1	1.0910694	-5.5718005	110	3	1.12	0.95	92.7812	-0.1323	0.0000	0.0000;
	1161	1	9.601	1.737	0	0	1	1.0884054	-5.9194281	110	3	1.12	0.95	93.1739	-0.0234	0.0000	0.0000;
	1162	1	2.52	0.517	0	0	1	1.0911462	-5.5669794	110	3	1.12	0.95	92.7711	-0.1340	0.0000	0.0000;
	1163	1	6.709	1.68	0	0	1	1.0904173	-5.5457832	110	3	1.12	0.95	92.7372	-0.0329	0.0000	0.0000;
	1164	1	4.622	0.836	0	0	1	1.0891766	-5.9248545	110	3	1.12	0.95	93.1279	-0.0720	0.0000	0.0000;
	1165	1	8.037	1.468	0	0	1	1.0887123	-5.9444871	110	3	1.12	0.95	93.1669	-0.0541	0.0000	0.0000;
	1166	1	8.037	1.468	0	0	1	1.0887506	-5.9431692	110	3	1.12	0.95	93.1650	-0.0551	0.0000	0.0000;
	1167	1	1.668	0.329	0	0	1	1.0916014	-5.5534298	110	3	1.12	0.95	92.7472	-0.1458	0.0000	0.0000;
	1168	1	2.86	0.573	0	0	1	1.0908353	-5.5630432	110	3	1.12	0.95	92.7657	-0.0931	0.0000	0.0000;
	1169	1	0	0	0	0	1	1.0916067	-5.5530706	110	3	1.12	0.95	92.7466	-0.1460	0.0000	0.0000;
	1170	1	0	0	0	0	1	1.090847	-5.5623366	110	3	1.12	0.95	92.7642	-0.0934	0.0000	0.0000;
	1171	1	1.171	0.087	0	0	1	1.1161656	-4.8112363	110	3	1.12	0.95	91.2952	0.0340	0.0000	0.0000;
	1172	1	0.335	0.043	0	0	1	1.1162403	-4.7916198	110	3	1.12	0.95	91.2923	0.0336	0.0000	0.0000;
	1173	1	0	0	0	0	1	1.1024329	-5.2820174	110	3	1.12	0.95	92.6405	0.0699	0.0000	0.0000;
	1174	1	0	0	0	0	1	1.1024329	-5.2820174	110	3	1.12	0.95	92.6405	0.0699	0.0000	0.0000;
	1175	1	1.004	0.173	0	0	1	1.1017524	-5.4002003	110	3	1.12	0.95	92.5563	0.0149	0.0000	0.0000;
	1176	1	0	0	0	0	1	1.1017657	-5.3987825	110	3	1.12	0.95	92.5548	0.0147	0.0000	0.0000;
	1177	1	0	0	0	0	1	1.1023875	-5.2812642	110	3	1.12	0.95	92.6404	0.0724	0.0000	0.0000;
	1178	1	6.783	1.452	0	0	1	1.1013533	-5.5491807	110	3	1.12	0.95	92.5359	0.0028	0.0000	0.0000;
	1179	1	2.93	0.628	0	0	1	1.1016611	-5.4442615	110	3	1.12	0.95	92.6372	0.0341	0.0000	0.0000;
	1180	2	7.339	8.52	0	0	1	1.104965	-3.8641308	110	3	1.12	0.95	91.6538	0.0000	0.0000	0.0000;
	1181	1	0.921	0.39	0	0	1	1.1021658	-5.3506214	110	3	1.12	0.95	92.5990	0.0405	0.0000	0.0000;
	1182	1	0.913	0.329	0	0	1	1.0939907	-6.4209789	110	3	1.12	0.95	93.5317	-0.4654	0.0000	0.0000;
	1183	1	0.561	0.264	0	0	1	1.0939857	-6.421194	110	3	1.12	0.95	93.5322	-0.4647	0.0000	0.0000;
	1184	1	0	0	0	0	1	1.1036809	-4.037655	110	3	1.12	0.95	91.7639	0.0052	0.0000	0.0000;
	1185	1	0	0	0	0	1	1.1036809	-4.037655	110	3	1.12	0.95	91.7639	0.0052	0.0000	0.0000;
	1186	1	0	0	0	0	1	1.1119266	-5.1536176	110	3	1.12	0.95	91.8163	0.1101	0.0000	0.0000;
	1187	1	4.184	0.433	0	0	1	1.1118643	-5.1705411	110	3	1.12	0.95	91.8183	0.1102	0.0000	0.0000;
	1188	1	63.595	12.135	0	0	1	1.021744	-5.7845243	110	3	1.12	0.95	92.1213	0.0935	0.0000	0.0000;
	1189	2	60.237	20.877	0	0	1	1.1043099	-3.9053005	110	3	1.12	0.95	91.7678	0.0267	0.0000	0.0000;
	1190	1	0	0	0	0	1	1.1039218	-4.1075051	110	3	1.12	0.95	91.9259	-0.0127	0.0000	0.0000;
	1191	1	2.514	0.498	0	0	1	1.1101036	-4.3944346	110	3	1.12	0.95	91.8941	-0.0125	0.0000	0.0000;
	1192	1	0	0	0	0	1	1.1039218	-4.1075051	110	3	1.12	0.95	91.9259	-0.0127	0.0000	0.0000;
	1193	1	0.586	0.154	0	0	1	1.0927427	-5.6102996	110	3	1.12	0.95	93.1036	-0.1394	0.0000	0.0000;
	1194	1	0	0	0	0	1	1.0927695	-5.6073931	110	3	1.12	0.95	93.1005	-0.1398	0.0000	0.0000;
	1195	1	7.364	1.3	0	0	1	1.1033556	-6.1295297	110	3	1.12	0.95	92.7434	0.2335	0.0000	0.0000;
	1196	1	0	0.13	0	0	1	1.1033468	-6.1348971	110	3	1.12	0.95	92.7433	0.2330	0.0000	0.0000;
	1197	1	0	0	0	0	1	1.1028874	-6.1420205	110	3	1.12	0.95	92.7595	0.2592	0.0000	0.0000;
	1198	1	0.92	0.282	0	0	1	1.1071818	-5.903779	110	3	1.12	0.95	92.4111	0.1562	0.0000	0.0000;
	1199	1	0.418	0.065	0	0	1	1.1068957	-5.9444522	110	3	1.12	0.95	92.4311	0.1615	0.0000	0.0000;
	1200	1	0	0	0	0	1	1.1071943	-5.9030042	110	3	1.12	0.95	92.4098	0.1559	0.0000	0.0000;
	1201	1	0	0	0	0	1	1.1069001	-5.9440698	110	3	1.12	0.95	92.4305	0.1615	0.0000	0.0000;
	1202	1	1.256	0.302	0	0	1	1.1019756	-5.5016534	110	3	1.12	0.95	92.4675	-0.0090	0.0000	0.0000;
	1203	1	0.167	0.078	0	0	1	1.1019644	-5.5032008	110	3	1.12	0.95	92.4685	-0.0088	0.0000	0.0000;
	1204	1	0.418	0	0	0	1	1.1108269	-4.3330689	110	3	1.12	0.95	91.8483	-0.0244	0.0000	0.0000;
	1205	1	0.838	0.157	0	0	1	1.0951263	-3.6187041	110	3	1.12	0.95	92.1379	-0.4043	0.0000	0.0000;
	1206	1	0.167	0.065	0	0	1	1.0951349	-3.6276414	110	3	1.12	0.95	92.1351	-0.4064	0.0000	0.0000;
	1207	1	0	0	0	0	1	1.0909552	-4.0819155	110	3	1.12	0.95	92.0749	-0.0324	0.0000	0.0000;
	1208	1	1.674	0.043	0	0	1	1.0910027	-4.0821327	110	3	1.12	0.95	92.0749	-0.0322	0.0000	0.0000;
	1209	1	0	0	0	0	1	1.1023928	-5.5223865	110	3	1.12	0.95	92.4444	-0.0240	0.0000	0.0000;
	1210	1	0	0	0	0	1	1.1024045	-5.5174559	110	3	1.12	0.95	92.4430	-0.0240	0.0000	0.0000;
	1211	1	0.753	0.262	0	0	1	1.101251	-5.4522923	110	3	1.12	0.95	92.4722	-0.0079	0.0000	0.0000;
	1212	1	0.586	0.175	0	0	1	1.1012575	-5.4496283	110	3	1.12	0.95	92.4713	-0.0085	0.0000	0.0000;
	1213	1	0.586	0.154	0	0	1	1.1042733	-2.289389	110	3	1.12	0.95	91.2902	-0.2833	0.0000	0.0000;
	1214	1	0.921	0.289	0	0	1	1.1042726	-2.2882453	110	3	1.12	0.95	91.2909	-0.2829	0.0000	0.0000;
	1215	1	1.802	0.575	0	0	1	1.0930121	-6.4023231	110	3	1.12	0.95	93.6225	-0.3287	0.0000	0.0000;
	1216	1	0.813	0.367	0	0	1	1.093005	-6.401582	110	3	1.12	0.95	93.6227	-0.3279	0.0000	0.0000;
	1217	1	0.418	0.152	0	0	1	1.0889396	-4.0718741	110	3	1.12	0.95	92.0894	0.0337	0.0000	0.0000;
	1218	1	0	0	0	0	1	1.0889415	-4.0718141	110	3	1.12	0.95	92.0892	0.0337	0.0000	0.0000;
	1219	1	2.511	0.585	0	0	1	1.1041059	-3.9512076	110	3	1.12	0.95	91.7802	0.0203	0.0000	0.0000;
	1220	1	1.59	0.412	0	0	1	1.1033261	-4.0934013	110	3	1.12	0.95	91.8108	0.0033	0.0000	0.0000;
	1221	1	0.443	-0.05	0	0	1	1.0975762	-6.3719497	110	3	1.12	0.95	93.2634	0.0251	0.0000	0.0000;
	1222	1	0.218	-0.1	0	0	1	1.0975695	-6.3812624	110	3	1.12	0.95	93.2668	0.0264	0.0000	0.0000;
	1223	1	0.335	0.169	0	0	1	1.0916182	-3.9969354	110	3	1.12	0.95	92.0228	-0.1979	0.0000	0.0000;
	1224	1	5.192	1.22	0	0	1	1.0915325	-3.9495713	110	3	1.12	0.95	92.0253	-0.1812	0.0000	0.0000;
	1225	1	1.089	0.174	0	0	1	1.0966508	-5.6626267	110	3	1.12	0.95	92.6254	-0.1511	0.0000	0.0000;
	1226	1	1.702	0.605	0	0	1	1.0966706	-5.6684627	110	3	1.12	0.95	92.6261	-0.1498	0.0000	0.0000;
	1227	1	2.11	0.253	0	0	1	1.093815	-6.4371297	110	3	1.12	0.95	93.5215	-0.5959	0.0000	0.0000;
	1228	1	1.884	0.236	0	0	1	1.0939539	-6.4211649	110	3	1.12	0.95	93.4985	-0.5985	0.0000	0.0000;
	1229	1	0	0	0	0	1	1.0939818	-6.4275909	110	3	1.12	0.95	93.4964	-0.5983	0.0000	0.0000;
	1230	1	0	0	0	0	1	1.0940364	-6.4147871	110	3	1.12	0.95	93.4865	-0.5996	0.0000	0.0000;
	1231	1	3.516	1.192	0	0	1	1.1086938	-4.4834427	110	3	1.12	0.95	92.0622	0.0403	0.0000	0.0000;
	1232	1	0	0	0	0	1	1.1087134	-4.4816063	110	3	1.12	0.95	92.0617	0.0400	0.0000	0.0000;
	1233	1	0	0	0	0	1	1.110233	-4.3812536	110	3	1.12	0.95	91.8801	-0.0148	0.0000	0.0000;
	1234	1	0	0	0	0	1	1.1044763	-4.0377668	110	3	1.12	0.95	91.8536	-0.0190	0.0000	0.0000;
	1235	1	2.26	0.498	0	0	1	1.0998679	-2.8083373	110	3	1.12	0.95	91.5145	-0.2382	0.0000	0.0000;
	1236	1	3.935	0.932	0	0	1	1.0998568	-2.8101996	110	3	1.12	0.95	91.5136	-0.2383	0.0000	0.0000;
	1237	1	1.59	0.368	0	0	1	1.1041053	-3.940887	110	3	1.12	0.95	91.7849	0.0237	0.0000	0.0000;
	1238	1	0.502	0.152	0	0	1	1.1041091	-3.9420927	110	3	1.12	0.95	91.7838	0.0233	0.0000	0.0000;
	1239	1	0	0	0	0	1	1.093977	-4.048126	110	3	1.12	0.95	92.0100	-0.1167	0.0000	0.0000;
	1240	1	0	0	0	0	1	1.093977	-4.048126	110	3	1.12	0.95	92.0100	-0.1166	0.0000	0.0000;
	1241	1	2.253	0.338	0	0	1	1.0978103	-6.1279141	110	3	1.12	0.95	93.0643	-0.0151	0.0000	0.0000;
	1242	1	1.113	0.283	0	0	1	1.0978113	-6.1360375	110	3	1.12	0.95	93.0646	-0.0145	0.0000	0.0000;
	1243	1	0	0	0	0	1	1.1007868	-2.6581582	110	3	1.12	0.95	91.3975	-0.2263	0.0000	0.0000;
	1244	1	3.524	0.544	0	0	1	1.1007931	-2.6557313	110	3	1.12	0.95	91.4004	-0.2256	0.0000	0.0000;
	1245	1	1.757	0.451	0	0	1	1.0747875	-5.2948798	110	3	1.12	0.95	93.2945	-1.0222	0.0000	0.0000;
	1246	1	4.104	0.744	0	0	1	1.0747703	-5.3068708	110	3	1.12	0.95	93.2881	-1.0228	0.0000	0.0000;
	1247	2	16.056	5.97	0	0	1	1.0970369	-3.815987	110	3	1.12	0.95	91.8830	0.0000	0.0000	0.0000;
	1248	1	41.754	7.2	0	0	1	1.1002205	-3.3462272	110	3	1.12	0.95	91.4764	-0.0859	0.0000	0.0000;
	1249	1	8.398	1.782	0	0	1	1.0944955	-6.7138982	110	3	1.12	0.95	93.6486	0.0602	0.0000	0.0000;
	1250	1	4.254	1.08	0	0	1	1.0944914	-6.7229166	110	3	1.12	0.95	93.6499	0.0614	0.0000	0.0000;
	1251	1	0.753	0.087	0	0	1	1.0974086	-3.5980998	110	3	1.12	0.95	91.7690	-0.0232	0.0000	0.0000;
	1252	1	2.259	0.303	0	0	1	1.1103376	-4.3656228	110	3	1.12	0.95	91.9351	-0.0067	0.0000	0.0000;
	1253	1	0	0	0	0	1	1.0974175	-3.5976055	110	3	1.12	0.95	91.7677	-0.0234	0.0000	0.0000;
	1254	1	0	0	0	0	1	1.1103564	-4.3642463	110	3	1.12	0.95	91.9326	-0.0070	0.0000	0.0000;
	1255	1	0	0	0	0	1	1.081049	-5.2299201	110	3	1.12	0.95	92.3200	-0.8166	0.0000	0.0000;
	1256	1	0	0	0	0	1	1.081045	-5.3472779	110	3	1.12	0.95	92.4746	-0.8536	0.0000	0.0000;
	1257	1	2.008	0.217	0	0	1	1.0961909	-5.1850104	110	3	1.12	0.95	92.7785	-0.0655	0.0000	0.0000;
	1258	1	2.008	0.217	0	0	1	1.096194	-5.1842277	110	3	1.12	0.95	92.7782	-0.0655	0.0000	0.0000;
	1259	1	2.681	0.501	0	0	1	1.1179402	-4.6018882	110	3	1.12	0.95	91.1392	0.0012	0.0000	0.0000;
	1260	1	0	0	0	0	1	1.1179458	-4.600346	110	3	1.12	0.95	91.1387	0.0011	0.0000	0.0000;
	1261	1	1.005	0.247	0	0	1	1.1040474	-3.9553899	110	3	1.12	0.95	91.7875	0.0216	0.0000	0.0000;
	1262	1	0	0	0	0	1	1.1041034	-3.9517758	110	3	1.12	0.95	91.7806	0.0203	0.0000	0.0000;
	1263	1	0	0	0	0	1	1.1032905	-2.4186815	110	3	1.12	0.95	91.2627	-0.2815	0.0000	0.0000;
	1264	1	0	0	0	0	1	1.1033035	-2.412475	110	3	1.12	0.95	91.2609	-0.2807	0.0000	0.0000;
	1265	1	0.418	0.128	0	0	1	1.0977826	-3.8625866	110	3	1.12	0.95	91.7037	-0.2295	0.0000	0.0000;
	1266	1	0	0	0	0	1	1.0977933	-3.8601808	110	3	1.12	0.95	91.7027	-0.2297	0.0000	0.0000;
	1267	1	1.592	0.395	0	0	1	1.1022337	-2.2710056	110	3	1.12	0.95	91.8621	-0.3857	0.0000	0.0000;
	1268	1	1.172	0.346	0	0	1	1.1022686	-2.2744581	110	3	1.12	0.95	91.8589	-0.3859	0.0000	0.0000;
	1269	1	3.933	1.517	0	0	1	1.098085	-3.4885431	110	3	1.12	0.95	91.6230	-0.0048	0.0000	0.0000;
	1270	1	1.506	0.087	0	0	1	1.106545	-5.9704509	110	3	1.12	0.95	92.3974	0.1334	0.0000	0.0000;
	1271	1	0	0	0	0	1	1.096736	-3.6601684	110	3	1.12	0.95	91.8402	-0.0086	0.0000	0.0000;
	1272	1	0	0	0	0	1	1.0984074	-3.4749316	110	3	1.12	0.95	91.5899	-0.0171	0.0000	0.0000;
	1273	1	1.256	0.346	0	0	1	1.096267	-3.3160371	110	3	1.12	0.95	91.9571	-0.2132	0.0000	0.0000;
	1274	1	0	0	0	0	1	1.0963263	-3.3106526	110	3	1.12	0.95	91.9514	-0.2144	0.0000	0.0000;
	1275	1	2.688	0.026	0	0	1	1.0896039	-6.1839654	110	3	1.12	0.95	93.3110	-0.1445	0.0000	0.0000;
	1276	1	0	0.026	0	0	1	1.0965774	-5.3240867	110	3	1.12	0.95	92.3962	-0.2349	0.0000	0.0000;
	1277	1	4.773	1.625	0	0	1	1.1109844	-4.1689198	110	3	1.12	0.95	91.7108	0.0283	0.0000	0.0000;
	1278	1	0	0	0	0	1	1.111059	-4.1476923	110	3	1.12	0.95	91.7038	0.0280	0.0000	0.0000;
	1279	1	3.349	0.562	0	0	1	1.0921202	-4.0836578	110	3	1.12	0.95	92.5108	-0.4836	0.0000	0.0000;
	1280	1	1.423	0.215	0	0	1	1.0921222	-4.0781977	110	3	1.12	0.95	92.5128	-0.4821	0.0000	0.0000;
	1281	1	6.276	1.122	0	0	1	1.107811	-5.8450267	110	3	1.12	0.95	92.2967	0.1154	0.0000	0.0000;
	1282	1	0	0	0	0	1	1.107867	-5.8371234	110	3	1.12	0.95	92.2925	0.1148	0.0000	0.0000;
	1283	1	2.762	0.672	0	0	1	1.0972977	-3.7916067	110	3	1.12	0.95	91.8230	-0.1043	0.0000	0.0000;
	1284	1	0	0	0	0	1	1.0972983	-3.7954252	110	3	1.12	0.95	91.8241	-0.1054	0.0000	0.0000;
	1285	1	2.51	1.213	0	0	1	1.0931661	-5.5612103	110	3	1.12	0.95	93.0612	-0.1305	0.0000	0.0000;
	1286	1	0	0	0	0	1	1.094845	-6.9682066	110	3	1.12	0.95	93.8733	0.0843	0.0000	0.0000;
	1287	1	3.267	0.514	0	0	1	1.0922105	-7.3610706	110	3	1.12	0.95	94.1990	0.1156	0.0000	0.0000;
	1288	2	18	42	0	0	1	1.1112497	-4.3463968	110	3	1.12	0.95	91.1209	0.0000	0.0000	0.0000;
	1289	1	0	0	0	0	1	1.1070586	-4.7800062	110	3	1.12	0.95	92.2943	0.0400	0.0000	0.0000;
	1290	1	0.418	0.013	0	0	1	1.0956778	-5.3763802	110	3	1.12	0.95	92.4683	-0.2235	0.0000	0.0000;
	1291	1	0.669	0.05	0	0	1	1.0956559	-5.3786038	110	3	1.12	0.95	92.4691	-0.2239	0.0000	0.0000;
	1292	1	0	0	0	0	1	1.1026934	-2.3611173	110	3	1.12	0.95	91.8879	-0.4354	0.0000	0.0000;
	1293	1	2.18	0.318	0	0	1	1.102681	-2.3612366	110	3	1.12	0.95	91.8889	-0.4354	0.0000	0.0000;
	1294	1	2.01	0.139	0	0	1	1.090704	-4.2026529	110	3	1.12	0.95	92.2983	-0.3042	0.0000	0.0000;
	1295	1	0.669	0.167	0	0	1	1.0907092	-4.2051435	110	3	1.12	0.95	92.3004	-0.3060	0.0000	0.0000;
	1296	1	1.506	0.26	0	0	1	1.1100676	-4.38045	110	3	1.12	0.95	91.9499	0.0019	0.0000	0.0000;
	1297	1	0.92	0.13	0	0	1	1.1100783	-4.3795509	110	3	1.12	0.95	91.9497	0.0018	0.0000	0.0000;
	1298	1	1.674	0.06	0	0	1	1.1010003	-2.2254224	110	3	1.12	0.95	91.7123	-0.2124	0.0000	0.0000;
	1299	1	2.679	0.161	0	0	1	1.1010011	-2.2252239	110	3	1.12	0.95	91.7123	-0.2125	0.0000	0.0000;
	1300	1	0.418	0.122	0	0	1	1.1025419	-5.2550884	110	3	1.12	0.95	92.6318	0.0759	0.0000	0.0000;
	1301	1	3.355	1.506	0	0	1	1.1025241	-5.258852	110	3	1.12	0.95	92.6316	0.0754	0.0000	0.0000;
	1302	1	1.843	0.137	0	0	1	1.0975645	-4.0109108	110	3	1.12	0.95	91.9759	-0.3041	0.0000	0.0000;
	1303	1	0.251	0.058	0	0	1	1.0975674	-4.010995	110	3	1.12	0.95	91.9763	-0.3044	0.0000	0.0000;
	1304	1	3.392	-1.44	0	0	1	1.0914592	-6.6793887	110	3	1.12	0.95	93.6269	-0.8087	0.0000	0.0000;
	1305	1	0	0	0	0	1	1.0914296	-6.6804447	110	3	1.12	0.95	93.6275	-0.8108	0.0000	0.0000;
	1306	1	3.453	-1.268	0	0	1	1.0844866	-6.8652545	110	3	1.12	0.95	93.7855	-1.0802	0.0000	0.0000;
	1307	1	0	0.043	0	0	1	1.0844819	-6.8653564	110	3	1.12	0.95	93.7860	-1.0797	0.0000	0.0000;
	1308	1	2.336	0.462	0	0	1	1.0948122	-5.2958663	110	3	1.12	0.95	92.6958	-0.0622	0.0000	0.0000;
	1309	1	1.248	0.257	0	0	1	1.094794	-5.3009096	110	3	1.12	0.95	92.6954	-0.0631	0.0000	0.0000;
	1310	1	0	0	0	0	1	1.0935598	-4.1115699	110	3	1.12	0.95	92.0772	-0.1096	0.0000	0.0000;
	1311	1	0	0	0	0	1	1.093557	-4.1114886	110	3	1.12	0.95	92.0772	-0.1093	0.0000	0.0000;
	1312	1	0.838	0.108	0	0	1	1.0961534	-4.0897983	110	3	1.12	0.95	92.2081	-0.3473	0.0000	0.0000;
	1313	1	1.258	0.249	0	0	1	1.0961517	-4.0908568	110	3	1.12	0.95	92.2084	-0.3473	0.0000	0.0000;
	1314	1	1.649	0.211	0	0	1	1.0992351	-6.104271	110	3	1.12	0.95	93.0970	0.0777	0.0000	0.0000;
	1315	1	1.976	0.282	0	0	1	1.0992182	-6.120649	110	3	1.12	0.95	93.1001	0.0781	0.0000	0.0000;
	1316	1	0	0	0	0	1	1.1038509	-4.0025761	110	3	1.12	0.95	91.8130	0.0174	0.0000	0.0000;
	1317	1	0.084	0.035	0	0	1	1.1038421	-4.0042953	110	3	1.12	0.95	91.8136	0.0175	0.0000	0.0000;
	1318	1	4.77	1.04	0	0	1	1.0996814	-3.2888201	110	3	1.12	0.95	91.3360	0.0345	0.0000	0.0000;
	1319	1	0	0	0	0	1	1.0996925	-3.2879674	110	3	1.12	0.95	91.3348	0.0342	0.0000	0.0000;
	1320	1	0	0	0	0	1	1.1053823	-4.9606955	110	3	1.12	0.95	92.3242	0.0220	0.0000	0.0000;
	1321	1	0	0	0	0	1	1.1043802	-5.044719	110	3	1.12	0.95	92.4900	0.0661	0.0000	0.0000;
	1322	1	0	0	0	0	1	1.1053782	-4.9605853	110	3	1.12	0.95	92.3242	0.0223	0.0000	0.0000;
	1323	1	0	0	0	0	1	1.1043761	-5.0446088	110	3	1.12	0.95	92.4900	0.0665	0.0000	0.0000;
	1324	1	2.845	0.477	0	0	1	1.1104532	-5.5594411	110	3	1.12	0.95	92.0358	0.0763	0.0000	0.0000;
	1325	1	1.757	0.26	0	0	1	1.110423	-5.5659453	110	3	1.12	0.95	92.0373	0.0764	0.0000	0.0000;
	1326	1	0.586	0.087	0	0	1	1.1000998	-3.3699321	110	3	1.12	0.95	91.4761	-0.0776	0.0000	0.0000;
	1327	1	0	0	0	0	1	1.0981421	-3.643757	110	3	1.12	0.95	91.6982	0.0003	0.0000	0.0000;
	1328	1	0	0	0	0	1	1.1001033	-3.3696296	110	3	1.12	0.95	91.4756	-0.0776	0.0000	0.0000;
	1329	1	0	0	0	0	1	1.098142	-3.6437551	110	3	1.12	0.95	91.6982	0.0003	0.0000	0.0000;
	1330	1	0.686	0.036	0	0	1	1.0898855	-6.1039915	110	3	1.12	0.95	93.2190	-0.1259	0.0000	0.0000;
	1331	1	0	0.035	0	0	1	1.0898772	-6.0980803	110	3	1.12	0.95	93.2171	-0.1256	0.0000	0.0000;
	1332	1	2.18	0.624	0	0	1	1.094851	-3.8937589	110	3	1.12	0.95	92.3714	-0.0126	0.0000	0.0000;
	1333	1	0	0	0	0	1	1.09485	-3.8898622	110	3	1.12	0.95	92.3704	-0.0124	0.0000	0.0000;
	1334	1	2.096	0.445	0	0	1	1.1023896	-2.2364085	110	3	1.12	0.95	91.8152	-0.3739	0.0000	0.0000;
	1335	1	0.838	0.026	0	0	1	1.1023931	-2.2343252	110	3	1.12	0.95	91.8141	-0.3737	0.0000	0.0000;
	1336	1	1.257	0.25	0	0	1	1.1029205	-3.0056338	110	3	1.12	0.95	91.0175	-0.0430	0.0000	0.0000;
	1337	1	1.256	0.041	0	0	1	1.1029238	-3.0112702	110	3	1.12	0.95	91.0176	-0.0435	0.0000	0.0000;
	1338	1	2.596	0.605	0	0	1	1.0838652	-6.5073639	110	3	1.12	0.95	93.8794	-0.4235	0.0000	0.0000;
	1339	1	1.506	-0.504	0	0	1	1.0838489	-6.5087021	110	3	1.12	0.95	93.8787	-0.4257	0.0000	0.0000;
	1340	1	4.693	1.221	0	0	1	1.1097386	-4.3777564	110	3	1.12	0.95	91.9464	0.0213	0.0000	0.0000;
	1341	1	1.506	0.26	0	0	1	1.1052225	-4.9337126	110	3	1.12	0.95	92.4120	0.0663	0.0000	0.0000;
	1342	1	0	0	0	0	1	1.1084886	-4.5754866	110	3	1.12	0.95	92.0484	0.0038	0.0000	0.0000;
	1343	2	18.064	4.757	0	0	1	1.1009083	-2.1352765	110	3	1.12	0.95	91.6105	-0.1612	0.0000	0.0000;
	1344	2	17.981	4.757	0	0	1	1.1009064	-2.1325782	110	3	1.12	0.95	91.6097	-0.1612	0.0000	0.0000;
	1345	1	2.094	0.14	0	0	1	1.0990088	-3.3769367	110	3	1.12	0.95	91.5461	-0.0446	0.0000	0.0000;
	1346	1	1.759	0.397	0	0	1	1.100788	-2.1941298	110	3	1.12	0.95	91.6835	-0.1739	0.0000	0.0000;
	1347	1	0	0	0	0	1	1.099021	-3.3759885	110	3	1.12	0.95	91.5442	-0.0447	0.0000	0.0000;
	1348	1	1.925	0.321	0	0	1	1.0983835	-3.7599133	110	3	1.12	0.95	91.8152	-0.1590	0.0000	0.0000;
	1349	1	5.362	1.008	0	0	1	1.0931126	-4.335006	110	3	1.12	0.95	92.5501	0.0106	0.0000	0.0000;
	1350	1	0.837	0.255	0	0	1	1.0771704	-5.4427226	110	3	1.12	0.95	92.9576	-0.9176	0.0000	0.0000;
	1351	1	0	0	0	0	1	1.0771187	-5.4452157	110	3	1.12	0.95	92.9637	-0.9197	0.0000	0.0000;
	1352	1	3.766	1.511	0	0	1	1.088215	-3.9743758	110	3	1.12	0.95	92.0025	0.0712	0.0000	0.0000;
	1353	2	8.837	16.416	0	0	1	1.1058988	-3.7166211	110	3	1.12	0.95	91.4939	0.0000	0.0000	0.0000;
	1354	1	0	0	0	0	1	1.1125501	-4.188413	110	3	1.12	0.95	91.7289	-0.0544	0.0000	0.0000;
	1355	1	1.164	0.233	0	0	1	1.0945731	-6.2906797	110	3	1.12	0.95	93.2944	-0.5257	0.0000	0.0000;
	1356	1	1.248	0.244	0	0	1	1.0945537	-6.2894973	110	3	1.12	0.95	93.2957	-0.5255	0.0000	0.0000;
	1357	1	5.026	1.096	0	0	1	1.1101638	-4.4598328	110	3	1.12	0.95	91.2628	0.0100	0.0000	0.0000;
	1358	1	3.685	0.836	0	0	1	1.1066375	-4.8211536	110	3	1.12	0.95	92.3306	0.0473	0.0000	0.0000;
	1359	1	0	0	0	0	1	1.1103674	-4.4473275	110	3	1.12	0.95	91.2388	0.0049	0.0000	0.0000;
	1360	1	0	0	0	0	1	1.1067846	-4.8122165	110	3	1.12	0.95	92.3131	0.0435	0.0000	0.0000;
	1361	1	3.351	1.342	0	0	1	1.072648	-5.5194802	110	3	1.12	0.95	93.4751	-0.9582	0.0000	0.0000;
	1362	1	4.688	0.498	0	0	1	1.0726214	-5.5221708	110	3	1.12	0.95	93.4750	-0.9611	0.0000	0.0000;
	1363	1	0	0	0	0	1	1.1069754	-4.7857063	110	3	1.12	0.95	92.3027	0.0421	0.0000	0.0000;
	1364	1	13.388	5.634	0	0	1	1.101887	-6.4747883	110	3	1.12	0.95	92.8458	0.1916	0.0000	0.0000;
	1365	1	2.093	0.055	0	0	1	1.0964717	-4.0281014	110	3	1.12	0.95	92.1444	-0.3437	0.0000	0.0000;
	1366	1	2.345	0.276	0	0	1	1.0964609	-4.0262861	110	3	1.12	0.95	92.1449	-0.3439	0.0000	0.0000;
	1367	1	0.838	0.201	0	0	1	1.1065619	-3.7348554	110	3	1.12	0.95	91.4866	-0.0398	0.0000	0.0000;
	1368	1	0.167	0.122	0	0	1	1.1066413	-3.7356607	110	3	1.12	0.95	91.4853	-0.0417	0.0000	0.0000;
	1369	1	3.267	0.936	0	0	1	1.1099135	-4.317103	110	3	1.12	0.95	91.8625	0.0341	0.0000	0.0000;
	1370	1	0.167	0	0	0	1	1.1099073	-4.323179	110	3	1.12	0.95	91.8665	0.0341	0.0000	0.0000;
	1371	1	0	0	0	0	1	1.1038183	-5.3027513	110	3	1.12	0.95	92.2176	-0.0187	0.0000	0.0000;
	1372	1	3.348	0.455	0	0	1	1.1038851	-5.265803	110	3	1.12	0.95	92.1877	-0.0024	0.0000	0.0000;
	1373	1	0	0	0	0	1	1.1038138	-5.3026109	110	3	1.12	0.95	92.2176	-0.0183	0.0000	0.0000;
	1374	1	0	0	0	0	1	1.1040778	-5.2527457	110	3	1.12	0.95	92.1609	-0.0055	0.0000	0.0000;
	1375	2	7.943	13.795	0	0	1	1.0906395	-5.4343611	110	3	1.12	0.95	92.6570	0.0000	0.0000	0.0000;
	1376	1	0	0	0	0	1	1.0906526	-5.4449031	110	3	1.12	0.95	92.6609	-0.0017	0.0000	0.0000;
	1377	1	2.848	1.074	0	0	1	1.0898348	-6.0175843	110	3	1.12	0.95	93.1795	-0.1190	0.0000	0.0000;
	1378	1	2.933	0.507	0	0	1	1.115148	-4.8986818	110	3	1.12	0.95	91.4075	0.0466	0.0000	0.0000;
	1379	1	1.675	0.264	0	0	1	1.1151074	-4.9080335	110	3	1.12	0.95	91.4094	0.0467	0.0000	0.0000;
	1380	1	3.352	0.213	0	0	1	1.1054364	-4.9402209	110	3	1.12	0.95	92.4040	0.0596	0.0000	0.0000;
	1381	1	0	0	0	0	1	1.1054277	-4.9399389	110	3	1.12	0.95	92.4044	0.0596	0.0000	0.0000;
	1382	1	3.432	1.192	0	0	1	1.1084693	-4.4923201	110	3	1.12	0.95	92.0707	0.0497	0.0000	0.0000;
	1383	1	0	0	0	0	1	1.1084781	-4.4918287	110	3	1.12	0.95	92.0707	0.0495	0.0000	0.0000;
	1384	1	1.223	0.321	0	0	1	1.1012052	-5.6994644	110	3	1.12	0.95	92.6155	-0.0164	0.0000	0.0000;
	1385	1	0.452	0.062	0	0	1	1.1012158	-5.6958491	110	3	1.12	0.95	92.6145	-0.0164	0.0000	0.0000;
	1386	1	1.807	-0.562	0	0	1	1.0904579	-5.9379233	110	3	1.12	0.95	93.0942	-0.1299	0.0000	0.0000;
	1387	1	3.709	-1.616	0	0	1	1.092331	-5.5108355	110	3	1.12	0.95	92.7176	-0.0778	0.0000	0.0000;
	1388	1	0	0	0	0	1	1.0910848	-4.0706739	110	3	1.12	0.95	92.1276	-0.2064	0.0000	0.0000;
	1389	1	0	0	0	0	1	1.0910954	-4.0648526	110	3	1.12	0.95	92.1252	-0.2050	0.0000	0.0000;
	1390	1	2.094	0.49	0	0	1	1.1080823	-4.2915512	110	3	1.12	0.95	91.7349	-0.3274	0.0000	0.0000;
	1391	1	0.837	0.211	0	0	1	1.1079759	-4.3088643	110	3	1.12	0.95	91.7372	-0.3278	0.0000	0.0000;
	1392	1	3.916	-2.726	0	0	1	1.0892071	-6.4361109	110	3	1.12	0.95	93.5752	-0.7596	0.0000	0.0000;
	1393	1	3.229	-0.014	0	0	1	1.089182	-6.4402594	110	3	1.12	0.95	93.5757	-0.7622	0.0000	0.0000;
	1394	1	2.42	0.472	0	0	1	1.08854	-5.9107928	110	3	1.12	0.95	93.1564	-0.0266	0.0000	0.0000;
	1395	1	5.044	0.924	0	0	1	1.0911773	-5.5639705	110	3	1.12	0.95	92.7679	-0.1347	0.0000	0.0000;
	1396	1	1.676	0.39	0	0	1	1.0937864	-3.7728935	110	3	1.12	0.95	91.7702	-0.2377	0.0000	0.0000;
	1397	1	0	0	0	0	1	1.0938402	-3.768432	110	3	1.12	0.95	91.7645	-0.2389	0.0000	0.0000;
	1398	1	4.775	1.009	0	0	1	1.104006	-4.0259601	110	3	1.12	0.95	91.8374	0.0058	0.0000	0.0000;
	1399	1	3.852	0.836	0	0	1	1.1039932	-4.0238438	110	3	1.12	0.95	91.8362	0.0060	0.0000	0.0000;
	1400	1	0.335	0.087	0	0	1	1.104511	-1.8337577	110	3	1.12	0.95	91.2841	-0.2787	0.0000	0.0000;
	1401	1	0	0	0	0	1	1.1036637	-2.0872611	110	3	1.12	0.95	91.5180	-0.3013	0.0000	0.0000;
	1402	1	0	0	0	0	1	1.1045148	-1.8335314	110	3	1.12	0.95	91.2837	-0.2789	0.0000	0.0000;
	1403	1	3.012	0.607	0	0	1	1.1039125	-3.9601505	110	3	1.12	0.95	91.7656	0.0235	0.0000	0.0000;
	1404	1	7.615	3.293	0	0	1	1.1038864	-3.9640932	110	3	1.12	0.95	91.7674	0.0239	0.0000	0.0000;
	1405	1	3.017	0.466	0	0	1	1.0967752	-3.9282314	110	3	1.12	0.95	91.8956	-0.1654	0.0000	0.0000;
	1406	1	0.753	0.128	0	0	1	1.0964977	-3.9511907	110	3	1.12	0.95	91.9300	-0.1527	0.0000	0.0000;
	1407	1	0	0	0	0	1	1.0968542	-3.9232555	110	3	1.12	0.95	91.8850	-0.1670	0.0000	0.0000;
	1408	1	0	0	0	0	1	1.0965171	-3.9499408	110	3	1.12	0.95	91.9274	-0.1531	0.0000	0.0000;
	1409	1	0.653	0.061	0	0	1	1.0981854	-6.2732323	110	3	1.12	0.95	93.2814	0.0791	0.0000	0.0000;
	1410	1	0	0	0	0	1	1.0981731	-6.2886057	110	3	1.12	0.95	93.2841	0.0793	0.0000	0.0000;
	1411	1	3.852	1.125	0	0	1	1.0914974	-7.4076458	110	3	1.12	0.95	94.2518	0.1559	0.0000	0.0000;
	1412	1	3.114	0.626	0	0	1	1.0915332	-7.4045934	110	3	1.12	0.95	94.2510	0.1539	0.0000	0.0000;
	1413	1	0	0	0	0	1	1.0969745	-3.9431274	110	3	1.12	0.95	91.8753	-0.2020	0.0000	0.0000;
	1414	1	0	0	0	0	1	1.0964404	-3.9874024	110	3	1.12	0.95	91.8700	-0.2044	0.0000	0.0000;
	1415	1	0	0	0	0	1	1.0950463	-4.0413681	110	3	1.12	0.95	91.9831	-0.1513	0.0000	0.0000;
	1416	1	0	0	0	0	1	1.0945421	-4.0383615	110	3	1.12	0.95	91.9946	-0.1321	0.0000	0.0000;
	1417	1	6.28	0.498	0	0	1	1.0911847	-4.2370663	110	3	1.12	0.95	92.4129	-0.1871	0.0000	0.0000;
	1418	1	10.472	0.932	0	0	1	1.0911687	-4.2400906	110	3	1.12	0.95	92.4132	-0.1880	0.0000	0.0000;
	1419	1	2.093	0.758	0	0	1	1.0958303	-3.9904874	110	3	1.12	0.95	91.9327	-0.1671	0.0000	0.0000;
	1420	1	1.255	0.238	0	0	1	1.0958041	-3.9934022	110	3	1.12	0.95	91.9335	-0.1671	0.0000	0.0000;
	1421	1	0.837	0.219	0	0	1	1.1112156	-4.2999986	110	3	1.12	0.95	91.8242	-0.0307	0.0000	0.0000;
	1422	1	0.502	0.174	0	0	1	1.111189	-4.303254	110	3	1.12	0.95	91.8249	-0.0306	0.0000	0.0000;
	1423	1	0.167	0.014	0	0	1	1.1042623	-3.9176325	110	3	1.12	0.95	91.7709	0.0251	0.0000	0.0000;
	1424	1	0.301	0.045	0	0	1	1.1042632	-3.9195648	110	3	1.12	0.95	91.7700	0.0247	0.0000	0.0000;
	1425	1	0	0	0	0	1	1.0989368	-3.5637195	110	3	1.12	0.95	91.6883	-0.0923	0.0000	0.0000;
	1426	1	0	0	0	0	1	1.0989366	-3.5637126	110	3	1.12	0.95	91.6883	-0.0923	0.0000	0.0000;
	1427	1	1.138	0.202	0	0	1	1.0928608	-7.4463655	110	3	1.12	0.95	94.3372	0.0384	0.0000	0.0000;
	1428	1	3.736	1.079	0	0	1	1.0928806	-7.4503581	110	3	1.12	0.95	94.3370	0.0380	0.0000	0.0000;
	1429	1	1.482	-0.436	0	0	1	1.0796752	-7.9217145	110	3	1.12	0.95	94.9158	0.9087	0.0000	0.0000;
	1430	1	1.189	0.062	0	0	1	1.0796745	-7.9200203	110	3	1.12	0.95	94.9149	0.9092	0.0000	0.0000;
	1431	1	1.591	0.219	0	0	1	1.1040305	-3.9861394	110	3	1.12	0.95	91.7928	0.0143	0.0000	0.0000;
	1432	1	0	0	0	0	1	1.1040306	-3.9860776	110	3	1.12	0.95	91.7928	0.0143	0.0000	0.0000;
	1433	2	2.072	0.197	0	0	1	1.1038175	-6.2226345	110	3	1.12	0.95	92.7781	0.2234	0.0000	0.0000;
	1434	1	3.347	0.867	0	0	1	1.1043581	-5.9928455	110	3	1.12	0.95	92.6304	0.2263	0.0000	0.0000;
	1435	2	11.537	2.373	0	0	1	1.1132023	-5.3143407	110	3	1.12	0.95	91.7885	0.0337	0.0000	0.0000;
	1436	2	2.919	0.597	0	0	1	1.1138271	-5.236564	110	3	1.12	0.95	91.7124	0.0256	0.0000	0.0000;
	1437	1	0	0	0	0	1	1.1130969	-5.3142783	110	3	1.12	0.95	91.7903	0.0391	0.0000	0.0000;
	1438	1	3.274	0.66	0	0	1	1.0932069	-5.7660472	110	3	1.12	0.95	92.8813	-0.3742	0.0000	0.0000;
	1439	1	4.172	0.819	0	0	1	1.0932059	-5.7735565	110	3	1.12	0.95	92.8828	-0.3772	0.0000	0.0000;
	1440	1	5.11	1.691	0	0	1	1.1038524	-4.0028637	110	3	1.12	0.95	91.8180	0.0175	0.0000	0.0000;
	1441	1	3.35	0.775	0	0	1	1.1038496	-4.0068532	110	3	1.12	0.95	91.8192	0.0174	0.0000	0.0000;
	1442	1	0	0	0	0	1	1.1009927	-5.5201051	110	3	1.12	0.95	92.5451	0.0091	0.0000	0.0000;
	1443	1	0	0	0	0	1	1.1009905	-5.5200626	110	3	1.12	0.95	92.5451	0.0092	0.0000	0.0000;
	1444	1	4.615	1.723	0	0	1	1.1066643	-4.8903839	110	3	1.12	0.95	91.7341	0.0141	0.0000	0.0000;
	1445	1	5.873	1.193	0	0	1	1.1081048	-4.736587	110	3	1.12	0.95	91.5312	0.0161	0.0000	0.0000;
	1446	1	0	0	0	0	1	1.1068667	-4.8678135	110	3	1.12	0.95	91.7268	0.0115	0.0000	0.0000;
	1447	1	0	0	0	0	1	1.1082696	-4.7070134	110	3	1.12	0.95	91.5217	0.0143	0.0000	0.0000;
	1448	1	0.669	0.146	0	0	1	1.0845541	-6.8227368	110	3	1.12	0.95	93.7322	-1.0793	0.0000	0.0000;
	1449	1	0.134	-0.113	0	0	1	1.0845591	-6.824349	110	3	1.12	0.95	93.7331	-1.0791	0.0000	0.0000;
	1450	1	0	0	0	0	1	1.0914237	-4.2068397	110	3	1.12	0.95	92.3143	-0.1919	0.0000	0.0000;
	1451	1	0.084	0.035	0	0	1	1.0914272	-4.2079897	110	3	1.12	0.95	92.3154	-0.1910	0.0000	0.0000;
	1452	1	1.674	0.628	0	0	1	1.0967821	-3.9129828	110	3	1.12	0.95	91.9017	-0.1482	0.0000	0.0000;
	1453	1	1.423	0.282	0	0	1	1.0967818	-3.9118799	110	3	1.12	0.95	91.9024	-0.1473	0.0000	0.0000;
	1454	1	4.021	0.537	0	0	1	1.1032683	-1.4678884	110	3	1.12	0.95	91.4204	-0.2544	0.0000	0.0000;
	1455	1	1.926	0.267	0	0	1	1.1032959	-1.4733139	110	3	1.12	0.95	91.4175	-0.2545	0.0000	0.0000;
	1456	1	0	0.042	0	0	1	1.0836374	-6.8662577	110	3	1.12	0.95	93.8393	-1.0182	0.0000	0.0000;
	1457	1	2.168	-0.589	0	0	1	1.0836504	-6.8673439	110	3	1.12	0.95	93.8394	-1.0186	0.0000	0.0000;
	1458	1	5.86	1.317	0	0	1	1.1046654	-3.8919981	110	3	1.12	0.95	91.6898	0.0066	0.0000	0.0000;
	1459	1	4.185	0.971	0	0	1	1.1046469	-3.8953879	110	3	1.12	0.95	91.6918	0.0071	0.0000	0.0000;
	1460	1	2.597	0.764	0	0	1	1.0818326	-5.1598052	110	3	1.12	0.95	92.2562	-0.8810	0.0000	0.0000;
	1461	1	0	0	0	0	1	1.0818185	-5.1622507	110	3	1.12	0.95	92.2562	-0.8795	0.0000	0.0000;
	1462	1	1.339	0.498	0	0	1	1.0922553	-6.6184355	110	3	1.12	0.95	93.5686	-0.7612	0.0000	0.0000;
	1463	1	0	-0.658	0	0	1	1.092241	-6.6209311	110	3	1.12	0.95	93.5696	-0.7635	0.0000	0.0000;
	1464	1	2.514	0.726	0	0	1	1.0872069	-6.3631627	110	3	1.12	0.95	93.6663	-0.3936	0.0000	0.0000;
	1465	1	4.049	-2.067	0	0	1	1.087228	-6.3597853	110	3	1.12	0.95	93.6663	-0.3914	0.0000	0.0000;
	1466	1	0	0.035	0	0	1	1.103933	-3.9876704	110	3	1.12	0.95	91.8072	0.0179	0.0000	0.0000;
	1467	1	0	0	0	0	1	1.1039333	-3.9876767	110	3	1.12	0.95	91.8072	0.0178	0.0000	0.0000;
	1468	1	1.256	0.128	0	0	1	1.1099896	-4.3826404	110	3	1.12	0.95	91.9526	0.0051	0.0000	0.0000;
	1469	1	0.837	0.124	0	0	1	1.1092955	-4.4433887	110	3	1.12	0.95	92.0222	0.0221	0.0000	0.0000;
	1470	1	0	0	0	0	1	1.109993	-4.3823652	110	3	1.12	0.95	91.9521	0.0050	0.0000	0.0000;
	1471	1	0	0	0	0	1	1.1092979	-4.4432094	110	3	1.12	0.95	92.0219	0.0221	0.0000	0.0000;
	1472	1	3.354	0.61	0	0	1	1.1134536	-5.2341811	110	3	1.12	0.95	91.7258	0.0345	0.0000	0.0000;
	1473	1	4.194	0.773	0	0	1	1.1134516	-5.2358353	110	3	1.12	0.95	91.7262	0.0347	0.0000	0.0000;
	1474	1	1.591	1.582	0	0	1	1.0812984	-5.4701672	110	3	1.12	0.95	92.5967	-0.8861	0.0000	0.0000;
	1475	1	1.674	0.542	0	0	1	1.0813504	-5.4733833	110	3	1.12	0.95	92.5959	-0.8853	0.0000	0.0000;
	1476	1	0.837	0.229	0	0	1	1.1090119	-4.4361238	110	3	1.12	0.95	91.9603	0.0429	0.0000	0.0000;
	1477	1	2.428	0.575	0	0	1	1.1090491	-4.4248386	110	3	1.12	0.95	91.9585	0.0431	0.0000	0.0000;
	1478	1	0	0	0	0	1	1.1144794	-4.9758393	110	3	1.12	0.95	91.4757	0.0556	0.0000	0.0000;
	1479	1	0	0	0	0	1	1.1144415	-4.9845674	110	3	1.12	0.95	91.4774	0.0557	0.0000	0.0000;
	1480	1	0.335	0.085	0	0	1	1.0910734	-4.0739905	110	3	1.12	0.95	92.1308	-0.2068	0.0000	0.0000;
	1481	1	0.586	0.195	0	0	1	1.09105	-4.0701751	110	3	1.12	0.95	92.1307	-0.2043	0.0000	0.0000;
	1482	1	2.512	0.475	0	0	1	1.0953892	-7.0943226	110	3	1.12	0.95	93.7467	0.1845	0.0000	0.0000;
	1483	1	1.423	0.238	0	0	1	1.0953586	-7.1008121	110	3	1.12	0.95	93.7499	0.1838	0.0000	0.0000;
	1484	1	1.759	0.048	0	0	1	1.1026539	-2.3088132	110	3	1.12	0.95	91.8674	-0.4025	0.0000	0.0000;
	1485	1	0.838	-0.039	0	0	1	1.1026583	-2.3084609	110	3	1.12	0.95	91.8671	-0.4025	0.0000	0.0000;
	1486	1	2.428	0.735	0	0	1	1.0932194	-5.5581502	110	3	1.12	0.95	93.0576	-0.1322	0.0000	0.0000;
	1487	1	1.928	0.485	0	0	1	1.0965624	-5.1358791	110	3	1.12	0.95	92.7260	-0.0688	0.0000	0.0000;
	1488	1	3.017	0.952	0	0	1	1.0824589	-6.0222262	110	3	1.12	0.95	93.0210	-0.9137	0.0000	0.0000;
	1489	1	0	0	0	0	1	1.0824517	-6.0167978	110	3	1.12	0.95	93.0196	-0.9145	0.0000	0.0000;
	1490	1	2.936	0.741	0	0	1	1.1013864	-6.5357401	110	3	1.12	0.95	92.9088	0.1983	0.0000	0.0000;
	1491	1	2.094	0.402	0	0	1	1.1063344	-4.8485936	110	3	1.12	0.95	92.3712	0.0545	0.0000	0.0000;
	1492	1	0	0	0	0	1	1.1013941	-6.5346229	110	3	1.12	0.95	92.9084	0.1982	0.0000	0.0000;
	1493	1	1.34	0.043	0	0	1	1.1035546	-2.9101019	110	3	1.12	0.95	92.5038	-0.7396	0.0000	0.0000;
	1494	1	1.004	0.257	0	0	1	1.1035508	-2.9091612	110	3	1.12	0.95	92.5036	-0.7395	0.0000	0.0000;
	1495	1	2.511	0.585	0	0	1	1.1038159	-4.0258393	110	3	1.12	0.95	91.8425	0.0141	0.0000	0.0000;
	1496	1	3.515	0.77	0	0	1	1.1038027	-4.0243891	110	3	1.12	0.95	91.8417	0.0142	0.0000	0.0000;
	1497	1	11.045	2.964	0	0	1	1.090783	-7.2381325	110	3	1.12	0.95	94.1165	0.4190	0.0000	0.0000;
	1498	1	0.025	0.043	0	0	1	1.0908501	-7.2285083	110	3	1.12	0.95	94.1130	0.4194	0.0000	0.0000;
	1499	1	0.921	0.695	0	0	1	1.0834763	-5.0123052	110	3	1.12	0.95	92.1045	-0.9862	0.0000	0.0000;
	1500	1	0	0	0	0	1	1.0835014	-5.0084888	110	3	1.12	0.95	92.1041	-0.9878	0.0000	0.0000;
	1501	1	1.842	0.28	0	0	1	1.1045148	-1.8335314	110	3	1.12	0.95	91.2837	-0.2789	0.0000	0.0000;
	1502	1	1.507	0.151	0	0	1	1.1036637	-2.0872611	110	3	1.12	0.95	91.5180	-0.3013	0.0000	0.0000;
	1503	1	3.187	0.181	0	0	1	1.0968057	-6.793502	110	3	1.12	0.95	93.3463	0.3507	0.0000	0.0000;
	1504	1	0	0	0	0	1	1.0968383	-6.7843615	110	3	1.12	0.95	93.3445	0.3514	0.0000	0.0000;
	1505	1	1.004	0.273	0	0	1	1.0931089	-5.5638765	110	3	1.12	0.95	93.0738	-0.1301	0.0000	0.0000;
	1506	1	2.679	1.096	0	0	1	1.0968614	-5.0767249	110	3	1.12	0.95	92.6421	-0.0567	0.0000	0.0000;
	1507	1	0	0	0	0	1	1.0970858	-5.0621214	110	3	1.12	0.95	92.6244	-0.0634	0.0000	0.0000;
	1508	1	1.506	0.26	0	0	1	1.1078227	-5.8440593	110	3	1.12	0.95	92.2955	0.1151	0.0000	0.0000;
	1509	1	1.757	0.303	0	0	1	1.107847	-5.8391812	110	3	1.12	0.95	92.2947	0.1151	0.0000	0.0000;
	1510	1	0.921	0.114	0	0	1	1.1029747	-2.4646554	110	3	1.12	0.95	91.4676	-0.3210	0.0000	0.0000;
	1511	1	1.089	-0.131	0	0	1	1.1029793	-2.4642186	110	3	1.12	0.95	91.4645	-0.3209	0.0000	0.0000;
	1512	1	2.263	0.802	0	0	1	1.1066185	-4.817824	110	3	1.12	0.95	92.3356	0.0501	0.0000	0.0000;
	1513	1	0	0	0	0	1	1.1081589	-4.739871	110	3	1.12	0.95	91.5594	0.0035	0.0000	0.0000;
	1514	1	5.867	1.011	0	0	1	1.115675	-4.8697417	110	3	1.12	0.95	91.3463	0.0415	0.0000	0.0000;
	1515	1	0	0	0	0	1	1.1170904	-4.7140479	110	3	1.12	0.95	91.2482	0.0106	0.0000	0.0000;
	1516	1	0	0	0	0	1	1.1156825	-4.8675098	110	3	1.12	0.95	91.3463	0.0415	0.0000	0.0000;
	1517	1	0	0	0	0	1	1.1170904	-4.7140479	110	3	1.12	0.95	91.2482	0.0106	0.0000	0.0000;
	1518	1	1.255	-0.167	0	0	1	1.1040303	-1.9784766	110	3	1.12	0.95	91.4987	-0.3043	0.0000	0.0000;
	1519	1	1.423	0.32	0	0	1	1.1040307	-1.9776997	110	3	1.12	0.95	91.4977	-0.3042	0.0000	0.0000;
	1520	1	0	0	0	0	1	1.1055911	-3.0343193	110	3	1.12	0.95	92.5563	-0.8525	0.0000	0.0000;
	1521	1	2.85	-2.295	0	0	1	1.1055911	-3.0343193	110	3	1.12	0.95	92.5563	-0.8525	0.0000	0.0000;
	1522	1	2.935	0.648	0	0	1	1.1048058	-3.8539867	110	3	1.12	0.95	91.6553	0.0155	0.0000	0.0000;
	1523	1	1.925	0.432	0	0	1	1.104826	-3.8467221	110	3	1.12	0.95	91.6525	0.0153	0.0000	0.0000;
	1524	1	0	0	0	0	1	1.0877375	-7.3574807	110	3	1.12	0.95	94.0676	0.6796	0.0000	0.0000;
	1525	1	0	0	0	0	1	1.087782	-7.352213	110	3	1.12	0.95	94.0658	0.6792	0.0000	0.0000;
	1526	1	0	0	0	0	1	1.1127253	-3.9399854	110	3	1.12	0.95	91.4833	0.0145	0.0000	0.0000;
	1527	1	6.113	2.058	0	0	1	1.1127372	-3.933153	110	3	1.12	0.95	91.4813	0.0145	0.0000	0.0000;
	1528	1	0.905	0.387	0	0	1	1.0842395	-6.8953839	110	3	1.12	0.95	93.8321	-1.0681	0.0000	0.0000;
	1529	1	0.318	0.1	0	0	1	1.0842432	-6.8951697	110	3	1.12	0.95	93.8318	-1.0683	0.0000	0.0000;
	1530	1	2.767	0.379	0	0	1	1.1045201	-3.9106436	110	3	1.12	0.95	91.7144	0.0104	0.0000	0.0000;
	1531	1	0	0	0	0	1	1.1045833	-3.9060249	110	3	1.12	0.95	91.7058	0.0094	0.0000	0.0000;
	1532	1	4.184	0.217	0	0	1	1.101032	-2.2212839	110	3	1.12	0.95	91.7086	-0.2140	0.0000	0.0000;
	1533	1	0	0	0	0	1	1.1041875	-1.9638502	110	3	1.12	0.95	91.2890	-0.2450	0.0000	0.0000;
	1534	1	0	0	0	0	1	1.1011666	-2.2107829	110	3	1.12	0.95	91.6877	-0.2149	0.0000	0.0000;
	1535	1	0	0	0	0	1	1.1041858	-1.9637952	110	3	1.12	0.95	91.2890	-0.2449	0.0000	0.0000;
	1536	1	2.463	-0.944	0	0	1	1.0923407	-5.8649218	110	3	1.12	0.95	93.0191	-0.2504	0.0000	0.0000;
	1537	1	1.608	0.16	0	0	1	1.0923261	-5.8684103	110	3	1.12	0.95	93.0193	-0.2508	0.0000	0.0000;
	1538	1	10.827	2.62	0	0	1	1.0986666	-3.4629305	110	3	1.12	0.95	91.5867	0.0835	0.0000	0.0000;
	1539	1	2.343	0.347	0	0	1	1.0972779	-3.6467028	110	3	1.12	0.95	91.8598	0.0602	0.0000	0.0000;
	1540	1	0	0	0	0	1	1.0986947	-3.4605875	110	3	1.12	0.95	91.5840	0.0828	0.0000	0.0000;
	1541	1	14.834	2.626	0	0	1	1.0814817	-6.9261239	110	3	1.12	0.95	94.0227	-0.9403	0.0000	0.0000;
	1542	1	2.924	0.335	0	0	1	1.0899982	-6.0186412	110	3	1.12	0.95	93.1827	-0.1365	0.0000	0.0000;
	1543	1	3.831	0.254	0	0	1	1.0900227	-6.017394	110	3	1.12	0.95	93.1831	-0.1379	0.0000	0.0000;
	1544	1	0.921	0.433	0	0	1	1.0976761	-6.6822274	110	3	1.12	0.95	93.2465	0.3500	0.0000	0.0000;
	1545	1	5.439	0.303	0	0	1	1.0981953	-6.5089398	110	3	1.12	0.95	93.1755	0.4210	0.0000	0.0000;
	1546	1	3.769	0.517	0	0	1	1.1031221	-6.1142872	110	3	1.12	0.95	92.7549	0.2527	0.0000	0.0000;
	1547	1	0	0	0	0	1	1.1031024	-6.118855	110	3	1.12	0.95	92.7548	0.2528	0.0000	0.0000;
	1548	1	0.838	0.201	0	0	1	1.1043922	-3.8927833	110	3	1.12	0.95	91.7475	0.0256	0.0000	0.0000;
	1549	1	0	0.022	0	0	1	1.1043994	-3.8900506	110	3	1.12	0.95	91.7454	0.0252	0.0000	0.0000;
	1550	1	0.335	0.166	0	0	1	1.0908844	-4.1720828	110	3	1.12	0.95	92.1620	-0.0344	0.0000	0.0000;
	1551	1	2.261	0.8	0	0	1	1.0915509	-4.0899699	110	3	1.12	0.95	92.0771	-0.0484	0.0000	0.0000;
	1552	1	0	0	0	0	1	1.0908993	-4.1710998	110	3	1.12	0.95	92.1608	-0.0349	0.0000	0.0000;
	1553	1	0	0	0	0	1	1.0916503	-4.0830236	110	3	1.12	0.95	92.0687	-0.0512	0.0000	0.0000;
	1554	1	1.675	-0.886	0	0	1	1.0914359	-4.1978518	110	3	1.12	0.95	92.2976	-0.1955	0.0000	0.0000;
	1555	1	0	0	0	0	1	1.0914264	-4.1959977	110	3	1.12	0.95	92.2963	-0.1963	0.0000	0.0000;
	1556	1	0.586	0.242	0	0	1	1.1068855	-0.78904735	110	3	1.12	0.95	90.6960	-0.1930	0.0000	0.0000;
	1557	1	0.838	-0.435	0	0	1	1.1069141	-0.79638411	110	3	1.12	0.95	90.6937	-0.1931	0.0000	0.0000;
	1558	1	2.58	-0.322	0	0	1	1.0905035	-5.5468927	110	3	1.12	0.95	92.7469	-0.0183	0.0000	0.0000;
	1559	1	1.356	0.157	0	0	1	1.0905177	-5.5522611	110	3	1.12	0.95	92.7480	-0.0185	0.0000	0.0000;
	1560	1	3.096	0.607	0	0	1	1.0893934	-4.0877603	110	3	1.12	0.95	92.0992	0.0142	0.0000	0.0000;
	1561	1	0	0	0	0	1	1.0896457	-4.06161	110	3	1.12	0.95	92.0702	0.0097	0.0000	0.0000;
	1562	1	0.084	0.022	0	0	1	1.081983	-5.5175134	110	3	1.12	0.95	92.6091	-0.9008	0.0000	0.0000;
	1563	1	0.084	0.065	0	0	1	1.0820395	-5.5200301	110	3	1.12	0.95	92.6080	-0.8999	0.0000	0.0000;
	1564	1	8.627	1.238	0	0	1	1.0964206	-3.9435566	110	3	1.12	0.95	91.9540	-0.1338	0.0000	0.0000;
	1565	1	0	0	0	0	1	1.0968513	-3.8997795	110	3	1.12	0.95	91.8998	-0.1424	0.0000	0.0000;
	1566	1	0	0	0	0	1	1.0965402	-3.9336977	110	3	1.12	0.95	91.9388	-0.1359	0.0000	0.0000;
	1567	1	0	0	0	0	1	1.0968507	-3.8997673	110	3	1.12	0.95	91.8998	-0.1424	0.0000	0.0000;
	1568	1	4.023	0.277	0	0	1	1.101934	-2.4610454	110	3	1.12	0.95	91.8498	-0.3689	0.0000	0.0000;
	1569	1	0.838	0.026	0	0	1	1.1019261	-2.4595188	110	3	1.12	0.95	91.8523	-0.3689	0.0000	0.0000;
	1570	1	0	0	0	0	1	1.0993503	-5.9953943	110	3	1.12	0.95	92.8504	-0.0052	0.0000	0.0000;
	1571	1	0	0	0	0	1	1.0993313	-6.0026248	110	3	1.12	0.95	92.8524	-0.0057	0.0000	0.0000;
	1572	1	3.306	-0.622	0	0	1	1.0904554	-5.9324315	110	3	1.12	0.95	93.0895	-0.1285	0.0000	0.0000;
	1573	1	3.582	-0.072	0	0	1	1.0923014	-5.4992344	110	3	1.12	0.95	92.7081	-0.0736	0.0000	0.0000;
	1574	1	3.437	0.786	0	0	1	1.096858	-3.8116787	110	3	1.12	0.95	91.7124	-0.2152	0.0000	0.0000;
	1575	1	0	0	0	0	1	1.0968858	-3.8048605	110	3	1.12	0.95	91.7110	-0.2145	0.0000	0.0000;
	1576	1	1.834	0.701	0	0	1	1.0894519	-5.7404016	110	3	1.12	0.95	92.9576	-0.3664	0.0000	0.0000;
	1577	1	1.784	0.169	0	0	1	1.0894659	-5.7383865	110	3	1.12	0.95	92.9563	-0.3629	0.0000	0.0000;
	1578	1	1.506	0.347	0	0	1	1.0913176	-4.3957597	110	3	1.12	0.95	93.2492	-0.2111	0.0000	0.0000;
	1579	1	2.092	-0.4	0	0	1	1.091325	-4.3968075	110	3	1.12	0.95	93.2492	-0.2113	0.0000	0.0000;
	1580	1	0.837	0.173	0	0	1	1.1003902	-3.2361012	110	3	1.12	0.95	91.2966	-0.0208	0.0000	0.0000;
	1581	1	2.008	0.563	0	0	1	1.1003448	-3.2514736	110	3	1.12	0.95	91.3030	-0.0215	0.0000	0.0000;
	1582	1	2.344	0.412	0	0	1	1.0811722	-5.3065916	110	3	1.12	0.95	92.3920	-0.8310	0.0000	0.0000;
	1583	1	0.167	0.108	0	0	1	1.0812074	-5.3108882	110	3	1.12	0.95	92.3931	-0.8305	0.0000	0.0000;
	1584	1	0	0	0	0	1	1.1035664	-5.325644	110	3	1.12	0.95	92.2478	-0.0150	0.0000	0.0000;
	1585	1	4.017	0.477	0	0	1	1.1035482	-5.3324486	110	3	1.12	0.95	92.2511	-0.0158	0.0000	0.0000;
	1586	1	1.089	0.127	0	0	1	1.107748	-5.8551997	110	3	1.12	0.95	92.3341	0.1468	0.0000	0.0000;
	1587	1	0	0	0	0	1	1.107774	-5.8490113	110	3	1.12	0.95	92.3328	0.1466	0.0000	0.0000;
	1588	1	2.345	0.363	0	0	1	1.1022405	-5.7802454	110	3	1.12	0.95	92.5869	0.0695	0.0000	0.0000;
	1589	1	1.507	0.093	0	0	1	1.1022199	-5.7978075	110	3	1.12	0.95	92.5903	0.0699	0.0000	0.0000;
	1590	1	1.423	0.484	0	0	1	1.1067078	-4.7834607	110	3	1.12	0.95	92.2066	0.0192	0.0000	0.0000;
	1591	1	2.764	0.939	0	0	1	1.1066757	-4.7916713	110	3	1.12	0.95	92.2070	0.0187	0.0000	0.0000;
	1592	1	2.094	0.166	0	0	1	1.0814047	-4.7922196	110	3	1.12	0.95	92.5730	-1.2203	0.0000	0.0000;
	1593	1	0	0	0	0	1	1.0814272	-4.7787496	110	3	1.12	0.95	92.5789	-1.2198	0.0000	0.0000;
	1594	1	2.513	0.41	0	0	1	1.0985844	-3.48397	110	3	1.12	0.95	91.6079	0.0809	0.0000	0.0000;
	1595	1	1.005	0.169	0	0	1	1.0985792	-3.4747603	110	3	1.12	0.95	91.6063	0.0811	0.0000	0.0000;
	1596	1	1.255	0.217	0	0	1	1.1087844	-4.5435145	110	3	1.12	0.95	92.0215	0.0010	0.0000	0.0000;
	1597	1	0	0	0	0	1	1.108805	-4.5414005	110	3	1.12	0.95	92.0192	0.0006	0.0000	0.0000;
	1598	1	4.186	0.715	0	0	1	1.0951684	-4.0626008	110	3	1.12	0.95	91.9952	-0.1657	0.0000	0.0000;
	1599	1	0	0	0	0	1	1.0951823	-4.0615382	110	3	1.12	0.95	91.9946	-0.1660	0.0000	0.0000;
	1600	1	4.696	0.696	0	0	1	1.0935126	-4.2936689	110	3	1.12	0.95	92.5061	0.0032	0.0000	0.0000;
	1601	1	0	0	0	0	1	1.0935177	-4.2931386	110	3	1.12	0.95	92.5055	0.0031	0.0000	0.0000;
	1602	1	1.758	0.345	0	0	1	1.0823867	-5.5258763	110	3	1.12	0.95	92.5756	-0.8884	0.0000	0.0000;
	1603	1	2.009	0.715	0	0	1	1.0823405	-5.5231078	110	3	1.12	0.95	92.5749	-0.8887	0.0000	0.0000;
	1604	1	2.052	0.594	0	0	1	1.0945589	-6.183823	110	3	1.12	0.95	93.2033	-0.4546	0.0000	0.0000;
	1605	1	2.412	0.683	0	0	1	1.0945742	-6.1864474	110	3	1.12	0.95	93.2025	-0.4548	0.0000	0.0000;
	1606	1	1.607	0.435	0	0	1	1.0966836	-6.5877281	110	3	1.12	0.95	93.5507	0.0808	0.0000	0.0000;
	1607	1	0.753	-0.709	0	0	1	1.0966758	-6.6025018	110	3	1.12	0.95	93.5532	0.0809	0.0000	0.0000;
	1608	1	1.66	0.651	0	0	1	1.0891453	-7.7742052	110	3	1.12	0.95	94.8650	0.0963	0.0000	0.0000;
	1609	1	0	0	0	0	1	1.08914	-7.7738369	110	3	1.12	0.95	94.8646	0.0964	0.0000	0.0000;
	1610	1	1.339	0.429	0	0	1	1.0989631	-3.6193278	110	3	1.12	0.95	91.4372	-0.2013	0.0000	0.0000;
	1611	1	0	0	0	0	1	1.0989661	-3.6192039	110	3	1.12	0.95	91.4368	-0.2014	0.0000	0.0000;
	1612	1	0.586	0.26	0	0	1	1.1065958	-4.7616409	110	3	1.12	0.95	92.2368	0.0602	0.0000	0.0000;
	1613	1	0	0	0	0	1	1.1066209	-4.7519965	110	3	1.12	0.95	92.2356	0.0607	0.0000	0.0000;
	1614	1	0.981	0.189	0	0	1	1.0903399	-5.5521364	110	3	1.12	0.95	92.7580	-0.0139	0.0000	0.0000;
	1615	1	0.88	0.179	0	0	1	1.0903492	-5.557905	110	3	1.12	0.95	92.7592	-0.0142	0.0000	0.0000;
	1616	1	0.671	-0.959	0	0	1	1.1085067	-0.89433505	110	3	1.12	0.95	90.6640	-0.2404	0.0000	0.0000;
	1617	1	0	0	0	0	1	1.1081012	-0.87807182	110	3	1.12	0.95	90.6566	-0.2251	0.0000	0.0000;
	1618	1	0.502	0.238	0	0	1	1.0925197	-4.0725541	110	3	1.12	0.95	92.0487	-0.0766	0.0000	0.0000;
	1619	1	0.335	0.097	0	0	1	1.092576	-4.0710377	110	3	1.12	0.95	92.0481	-0.0766	0.0000	0.0000;
	1620	1	1.842	0.401	0	0	1	1.1136001	-5.2495057	110	3	1.12	0.95	91.7280	0.0326	0.0000	0.0000;
	1621	1	0	0	0	0	1	1.1136209	-5.2392831	110	3	1.12	0.95	91.7259	0.0325	0.0000	0.0000;
	1622	1	0	0	0	0	1	1.1103313	-4.3518379	110	3	1.12	0.95	91.9218	-0.0003	0.0000	0.0000;
	1623	1	0	0	0	0	1	1.1103269	-4.3517402	110	3	1.12	0.95	91.9218	0.0000	0.0000	0.0000;
	1624	1	1.005	0.072	0	0	1	1.0994553	-2.8624043	110	3	1.12	0.95	91.5465	-0.2259	0.0000	0.0000;
	1625	1	1.257	0.207	0	0	1	1.0994434	-2.867486	110	3	1.12	0.95	91.5477	-0.2260	0.0000	0.0000;
	1626	1	4.693	1.643	0	0	1	1.1057637	-4.9145598	110	3	1.12	0.95	92.3793	0.0565	0.0000	0.0000;
	1627	1	0	0	0	0	1	1.10579	-4.9117865	110	3	1.12	0.95	92.3780	0.0562	0.0000	0.0000;
	1628	1	2.513	0.41	0	0	1	1.0988585	-3.4748448	110	3	1.12	0.95	91.5366	-0.0371	0.0000	0.0000;
	1629	1	1.675	0.264	0	0	1	1.0988742	-3.4673339	110	3	1.12	0.95	91.5343	-0.0363	0.0000	0.0000;
	1630	1	0	0	0	0	1	1.09736	-3.890672	110	3	1.12	0.95	91.8086	-0.2037	0.0000	0.0000;
	1631	1	0	0	0	0	1	1.0972665	-3.9011052	110	3	1.12	0.95	91.8138	-0.2028	0.0000	0.0000;
	1632	1	0	0	0	0	1	1.1020485	-3.5034555	110	3	1.12	0.95	91.4958	-0.2514	0.0000	0.0000;
	1633	1	2.595	0.455	0	0	1	1.0892336	-4.1064993	110	3	1.12	0.95	92.1184	0.0211	0.0000	0.0000;
	1634	1	0	0	0	0	1	1.0892756	-4.1082382	110	3	1.12	0.95	92.1189	0.0213	0.0000	0.0000;
	1635	1	4.129	-0.864	0	0	1	1.0896671	-6.1732101	110	3	1.12	0.95	93.2999	-0.1444	0.0000	0.0000;
	1636	1	3.207	-0.496	0	0	1	1.0896651	-6.1704538	110	3	1.12	0.95	93.2990	-0.1443	0.0000	0.0000;
	1637	1	6.798	0.579	0	0	1	1.099097	-2.9244758	110	3	1.12	0.95	91.5974	-0.2271	0.0000	0.0000;
	1638	1	0	0	0	0	1	1.0990985	-2.922327	110	3	1.12	0.95	91.5972	-0.2269	0.0000	0.0000;
	1639	1	6.293	0.551	0	0	1	1.0990917	-2.9226586	110	3	1.12	0.95	91.5976	-0.2266	0.0000	0.0000;
	1640	1	0	0	0	0	1	1.0990959	-2.9201919	110	3	1.12	0.95	91.5976	-0.2266	0.0000	0.0000;
	1641	1	5.446	1.051	0	0	1	1.1073559	-2.4526447	110	3	1.12	0.95	90.2396	0.0296	0.0000	0.0000;
	1642	1	6.697	1.404	0	0	1	1.1093453	-5.7066949	110	3	1.12	0.95	92.1671	0.1128	0.0000	0.0000;
	1643	1	0.586	0.173	0	0	1	1.1135858	-5.2405131	110	3	1.12	0.95	91.7277	0.0329	0.0000	0.0000;
	1644	1	0	0	0	0	1	1.1135971	-5.2396122	110	3	1.12	0.95	91.7267	0.0327	0.0000	0.0000;
	1645	1	4.303	1.016	0	0	1	1.0823584	-6.3937762	110	3	1.12	0.95	93.3427	-0.9099	0.0000	0.0000;
	1646	1	0	0	0	0	1	1.0823475	-6.3887219	110	3	1.12	0.95	93.3414	-0.9107	0.0000	0.0000;
	1647	1	0	0	0	0	1	1.1071599	-4.7631517	110	3	1.12	0.95	92.2842	0.0392	0.0000	0.0000;
	1648	1	0.167	0	0	0	1	1.111249	-4.3468446	110	3	1.12	0.95	91.1214	-0.0001	0.0000	0.0000;
	1649	1	0	0	0	0	1	1.1071596	-4.7631481	110	3	1.12	0.95	92.2842	0.0392	0.0000	0.0000;
	1650	1	1.841	0.173	0	0	1	1.1024339	-5.4110362	110	3	1.12	0.95	92.3011	0.0552	0.0000	0.0000;
	1651	1	4.017	0.693	0	0	1	1.102443	-5.4087113	110	3	1.12	0.95	92.3003	0.0551	0.0000	0.0000;
	1652	1	0.418	0	0	0	1	1.1030077	-6.3366421	110	3	1.12	0.95	92.7371	0.1847	0.0000	0.0000;
	1653	1	0	0	0	0	1	1.1030129	-6.3353449	110	3	1.12	0.95	92.7358	0.1848	0.0000	0.0000;
	1654	1	1.508	0.412	0	0	1	1.0877238	-4.6503244	110	3	1.12	0.95	91.7114	-1.2089	0.0000	0.0000;
	1655	1	0	0	0	0	1	1.0877561	-4.6449384	110	3	1.12	0.95	91.7105	-1.2106	0.0000	0.0000;
	1656	1	3.432	1.192	0	0	1	1.1096929	-4.3774321	110	3	1.12	0.95	91.9508	0.0236	0.0000	0.0000;
	1657	1	1.506	0.542	0	0	1	1.109791	-4.371447	110	3	1.12	0.95	91.9434	0.0207	0.0000	0.0000;
	1658	1	2.092	0.815	0	0	1	1.1030243	-2.7629745	110	3	1.12	0.95	92.3249	-0.6127	0.0000	0.0000;
	1659	1	0	0	0	0	1	1.1030857	-2.7604591	110	3	1.12	0.95	92.3186	-0.6151	0.0000	0.0000;
	1660	1	4.351	0.997	0	0	1	1.0965265	-5.1493001	110	3	1.12	0.95	92.7434	-0.0718	0.0000	0.0000;
	1661	1	8.619	1.69	0	0	1	1.0965066	-5.1500715	110	3	1.12	0.95	92.7432	-0.0714	0.0000	0.0000;
	1662	1	1.509	0.52	0	0	1	1.0806588	-5.4153595	110	3	1.12	0.95	92.5377	-0.8541	0.0000	0.0000;
	1663	1	1.49	0.305	0	0	1	1.0912249	-7.6674013	110	3	1.12	0.95	94.6806	0.0295	0.0000	0.0000;
	1664	1	1.172	0.075	0	0	1	1.0912175	-7.6701066	110	3	1.12	0.95	94.6813	0.0295	0.0000	0.0000;
	1665	1	3.598	0.78	0	0	1	1.0970522	-5.1223405	110	3	1.12	0.95	92.7144	-0.0919	0.0000	0.0000;
	1666	1	2.427	0.433	0	0	1	1.0970905	-5.1185061	110	3	1.12	0.95	92.7136	-0.0924	0.0000	0.0000;
	1667	1	0	0	0	0	1	1.0862955	-6.291195	110	3	1.12	0.95	93.5683	-0.3927	0.0000	0.0000;
	1668	1	0	0	0	0	1	1.0862921	-6.2911357	110	3	1.12	0.95	93.5683	-0.3925	0.0000	0.0000;
	1669	1	1.089	0.257	0	0	1	1.0901321	-4.4152836	110	3	1.12	0.95	92.7254	-0.5450	0.0000	0.0000;
	1670	1	0.167	0.022	0	0	1	1.090135	-4.4156136	110	3	1.12	0.95	92.7236	-0.5455	0.0000	0.0000;
	1671	1	5.032	0.44	0	0	1	1.103844	-2.7169985	110	3	1.12	0.95	90.7018	0.0406	0.0000	0.0000;
	1672	1	3.516	0.628	0	0	1	1.1038963	-2.6998591	110	3	1.12	0.95	90.6949	0.0409	0.0000	0.0000;
	1673	2	16.255	20.3	0	0	1	1.1020249	-5.4136558	110	3	1.12	0.95	92.4325	0.0000	0.0000	0.0000;
	1674	1	0	0	0	0	1	1.0962822	-5.2617492	110	3	1.12	0.95	92.7689	-0.1405	0.0000	0.0000;
	1675	1	4.1	0.303	0	0	1	1.0987002	-4.8333029	110	3	1.12	0.95	92.3519	-0.0636	0.0000	0.0000;
	1676	1	1.758	0.312	0	0	1	1.1002	-2.7521214	110	3	1.12	0.95	91.4494	-0.2302	0.0000	0.0000;
	1677	1	1.507	0.088	0	0	1	1.1002039	-2.7480821	110	3	1.12	0.95	91.4485	-0.2299	0.0000	0.0000;
	1678	1	1.257	0.383	0	0	1	1.1045429	-1.7928899	110	3	1.12	0.95	91.2238	-0.2425	0.0000	0.0000;
	1679	1	0	0	0	0	1	1.10455	-1.7942638	110	3	1.12	0.95	91.2249	-0.2428	0.0000	0.0000;
	1680	1	2.6	0.639	0	0	1	1.0898239	-4.0529966	110	3	1.12	0.95	92.0810	-0.0958	0.0000	0.0000;
	1681	1	2.093	0.491	0	0	1	1.0898469	-4.05257	110	3	1.12	0.95	92.0813	-0.0967	0.0000	0.0000;
	1682	1	0	0	0	0	1	1.0890877	-4.0151088	110	3	1.12	0.95	92.0414	-0.0201	0.0000	0.0000;
	1683	1	0	0	0	0	1	1.1149412	-5.0347779	110	3	1.12	0.95	91.5436	0.0254	0.0000	0.0000;
	1684	1	2.51	0	0	0	1	1.1149198	-5.0429561	110	3	1.12	0.95	91.5457	0.0255	0.0000	0.0000;
	1685	2	10.017	10.997	0	0	1	1.0965301	-5.3229779	110	3	1.12	0.95	92.3962	-0.2313	0.0000	0.0000;
	1686	2	4.418	10.987	0	0	1	1.0965782	-5.2580893	110	3	1.12	0.95	92.2996	-0.1804	0.0000	0.0000;
	1687	1	0.871	0.027	0	0	1	1.0939209	-6.4432217	110	3	1.12	0.95	93.5128	-0.6010	0.0000	0.0000;
	1688	1	2.177	0.054	0	0	1	1.0939203	-6.443296	110	3	1.12	0.95	93.5129	-0.6011	0.0000	0.0000;
	1689	1	1.508	0.124	0	0	1	1.0901137	-4.4308969	110	3	1.12	0.95	92.6207	-0.5496	0.0000	0.0000;
	1690	1	0	0	0	0	1	1.0901176	-4.4250626	110	3	1.12	0.95	92.6212	-0.5465	0.0000	0.0000;
	1691	1	0	0	0	0	1	1.0970204	-5.3329132	110	3	1.12	0.95	92.3349	-0.1692	0.0000	0.0000;
	1692	1	0	0	0	0	1	1.0966984	-5.373303	110	3	1.12	0.95	92.4014	-0.2215	0.0000	0.0000;
	1693	1	0.251	-0.2	0	0	1	1.0975822	-4.0089504	110	3	1.12	0.95	92.0026	-0.3305	0.0000	0.0000;
	1694	1	0.837	0.13	0	0	1	1.1035808	-2.0976931	110	3	1.12	0.95	91.5699	-0.3279	0.0000	0.0000;
	1695	1	1.139	0.371	0	0	1	1.0902082	-7.2830898	110	3	1.12	0.95	94.1751	0.4191	0.0000	0.0000;
	1696	1	2.664	0.352	0	0	1	1.0901421	-7.2932333	110	3	1.12	0.95	94.1762	0.4209	0.0000	0.0000;
	1697	1	2.008	0.433	0	0	1	1.1017446	-5.4267412	110	3	1.12	0.95	92.6318	0.0359	0.0000	0.0000;
	1698	1	0	0	0	0	1	1.1017512	-5.4227161	110	3	1.12	0.95	92.6327	0.0366	0.0000	0.0000;
	1699	1	1.423	0.368	0	0	1	1.1013854	-5.4778467	110	3	1.12	0.95	92.6682	0.0322	0.0000	0.0000;
	1700	1	1.674	0.429	0	0	1	1.1012361	-5.5461456	110	3	1.12	0.95	92.5555	0.0053	0.0000	0.0000;
	1701	1	0	0	0	0	1	1.1015755	-5.4682897	110	3	1.12	0.95	92.6407	0.0286	0.0000	0.0000;
	1702	1	0	0	0	0	1	1.1014665	-5.5349484	110	3	1.12	0.95	92.5227	0.0005	0.0000	0.0000;
	1703	1	5.021	0.693	0	0	1	1.1083602	-4.545574	110	3	1.12	0.95	92.1430	0.0322	0.0000	0.0000;
	1704	1	1.506	0.39	0	0	1	1.1097999	-4.3725325	110	3	1.12	0.95	91.9413	0.0198	0.0000	0.0000;
	1705	1	0	0	0	0	1	1.1085049	-4.5288326	110	3	1.12	0.95	92.1262	0.0301	0.0000	0.0000;
	1706	1	2.059	0.48	0	0	1	1.089831	-5.7447928	110	3	1.12	0.95	93.1585	-0.1382	0.0000	0.0000;
	1707	1	2.111	0.053	0	0	1	1.0898344	-5.7471863	110	3	1.12	0.95	93.1604	-0.1372	0.0000	0.0000;
	1708	1	3.598	0.433	0	0	1	1.1142422	-5.1495431	110	3	1.12	0.95	91.6347	0.0305	0.0000	0.0000;
	1709	1	0.586	0.39	0	0	1	1.1142593	-5.1425285	110	3	1.12	0.95	91.6330	0.0305	0.0000	0.0000;
	1710	1	3.351	1.138	0	0	1	1.109465	-4.409176	110	3	1.12	0.95	91.9891	0.0280	0.0000	0.0000;
	1711	1	2.26	0.841	0	0	1	1.1132783	-3.9243991	110	3	1.12	0.95	91.4763	-0.0093	0.0000	0.0000;
	1712	1	0	0	0	0	1	1.1097036	-4.3983527	110	3	1.12	0.95	91.9635	0.0198	0.0000	0.0000;
	1713	1	0	0	0	0	1	1.1134424	-3.9173666	110	3	1.12	0.95	91.4592	-0.0153	0.0000	0.0000;
	1714	1	6.291	1.466	0	0	1	1.1017068	-5.3974056	110	3	1.12	0.95	92.6156	0.0378	0.0000	0.0000;
	1715	1	0.418	0.13	0	0	1	1.1017086	-5.3975874	110	3	1.12	0.95	92.6140	0.0369	0.0000	0.0000;
	1716	1	2.632	0.455	0	0	1	1.0939405	-6.8629685	110	3	1.12	0.95	93.7702	0.0747	0.0000	0.0000;
	1717	1	0.669	0.128	0	0	1	1.0939313	-6.8527243	110	3	1.12	0.95	93.7700	0.0733	0.0000	0.0000;
	1718	1	2.51	0.217	0	0	1	1.0994533	-3.3804094	110	3	1.12	0.95	91.4455	-0.0284	0.0000	0.0000;
	1719	1	9.205	2.167	0	0	1	1.0997113	-3.2855019	110	3	1.12	0.95	91.3317	0.0344	0.0000	0.0000;
	1720	1	0	0.014	0	0	1	1.1029647	-2.2877853	110	3	1.12	0.95	91.8207	-0.4013	0.0000	0.0000;
	1721	1	0	0	0	0	1	1.1029626	-2.2884787	110	3	1.12	0.95	91.8212	-0.4014	0.0000	0.0000;
	1722	1	1.256	0.302	0	0	1	1.104801	-3.8648626	110	3	1.12	0.95	91.6254	0.0058	0.0000	0.0000;
	1723	1	0.586	0.166	0	0	1	1.1053458	-3.7806732	110	3	1.12	0.95	91.5806	0.0101	0.0000	0.0000;
	1724	1	0	0	0	0	1	1.104804	-3.8646421	110	3	1.12	0.95	91.6251	0.0058	0.0000	0.0000;
	1725	1	0	0	0	0	1	1.1053606	-3.7792958	110	3	1.12	0.95	91.5792	0.0097	0.0000	0.0000;
	1726	1	2.17	0.667	0	0	1	1.0895017	-7.5776072	110	3	1.12	0.95	94.6460	0.1434	0.0000	0.0000;
	1727	1	2.495	0.693	0	0	1	1.0894963	-7.5806279	110	3	1.12	0.95	94.6472	0.1434	0.0000	0.0000;
	1728	1	3.852	0.888	0	0	1	1.1051845	-3.7941118	110	3	1.12	0.95	91.6000	0.0124	0.0000	0.0000;
	1729	1	1.171	0.325	0	0	1	1.1051567	-3.8025466	110	3	1.12	0.95	91.6032	0.0127	0.0000	0.0000;
	1730	1	0.418	0.11	0	0	1	1.0886149	-3.9917313	110	3	1.12	0.95	92.0183	0.0300	0.0000	0.0000;
	1731	1	0	0	0	0	1	1.0885939	-3.9909511	110	3	1.12	0.95	92.0176	0.0309	0.0000	0.0000;
	1732	1	0.251	0.238	0	0	1	1.1038936	-4.1088035	110	3	1.12	0.95	91.9273	-0.0118	0.0000	0.0000;
	1733	1	4.186	0.715	0	0	1	1.1020614	-5.4564213	110	3	1.12	0.95	92.3427	0.0609	0.0000	0.0000;
	1734	1	0	0	0	0	1	1.0990343	-3.7960652	110	3	1.12	0.95	91.7589	-0.2263	0.0000	0.0000;
	1735	1	0	0	0	0	1	1.1037051	-2.0719107	110	3	1.12	0.95	91.5260	-0.3129	0.0000	0.0000;
	1736	1	4.016	-1.88	0	0	1	1.1037084	-2.0748543	110	3	1.12	0.95	91.5263	-0.3129	0.0000	0.0000;
	1737	1	3.014	0.536	0	0	1	1.0969783	-3.8706515	110	3	1.12	0.95	91.8953	-0.1306	0.0000	0.0000;
	1738	1	0.502	0.13	0	0	1	1.0969638	-3.8764572	110	3	1.12	0.95	91.8952	-0.1321	0.0000	0.0000;
	1739	1	2.354	0.767	0	0	1	1.0767788	-6.3978599	110	3	1.12	0.95	93.4365	-0.9268	0.0000	0.0000;
	1740	1	3.487	1.046	0	0	1	1.0768334	-6.397955	110	3	1.12	0.95	93.4355	-0.9243	0.0000	0.0000;
	1741	1	2.01	0.313	0	0	1	1.0997193	-2.8182653	110	3	1.12	0.95	91.5350	-0.2357	0.0000	0.0000;
	1742	1	3.264	0.542	0	0	1	1.0996075	-2.8260708	110	3	1.12	0.95	91.5470	-0.2335	0.0000	0.0000;
	1743	1	5.021	0.867	0	0	1	1.0724831	-5.5331058	110	3	1.12	0.95	93.4955	-0.9549	0.0000	0.0000;
	1744	1	5.021	0.867	0	0	1	1.0724895	-5.5339583	110	3	1.12	0.95	93.4908	-0.9585	0.0000	0.0000;
	1745	1	0.669	0.025	0	0	1	1.102293	-2.2465231	110	3	1.12	0.95	91.7149	-0.2871	0.0000	0.0000;
	1746	1	0.669	0.025	0	0	1	1.1022894	-2.2456898	110	3	1.12	0.95	91.7145	-0.2869	0.0000	0.0000;
	1747	1	1.515	0.505	0	0	1	1.094822	-7.0265442	110	3	1.12	0.95	93.5655	0.3542	0.0000	0.0000;
	1748	1	1.867	0.054	0	0	1	1.094796	-7.0338656	110	3	1.12	0.95	93.5667	0.3534	0.0000	0.0000;
	1749	1	2.948	0.921	0	0	1	1.0844469	-6.5653249	110	3	1.12	0.95	93.4305	-1.0366	0.0000	0.0000;
	1750	1	0.602	0.163	0	0	1	1.0844431	-6.562245	110	3	1.12	0.95	93.4291	-1.0369	0.0000	0.0000;
	1751	1	2.932	0.286	0	0	1	1.0976074	-3.6226473	110	3	1.12	0.95	91.8160	0.0563	0.0000	0.0000;
	1752	1	2.514	0.499	0	0	1	1.0975908	-3.6162983	110	3	1.12	0.95	91.8155	0.0566	0.0000	0.0000;
	1753	1	0	0	0	0	1	1.0938964	-6.2769167	110	3	1.12	0.95	93.4360	-0.2294	0.0000	0.0000;
	1754	1	3.117	0.873	0	0	1	1.0938903	-6.2744892	110	3	1.12	0.95	93.4358	-0.2286	0.0000	0.0000;
	1755	1	2.512	0.136	0	0	1	1.1037115	-1.8596679	110	3	1.12	0.95	91.2574	-0.2122	0.0000	0.0000;
	1756	1	0.92	-0.069	0	0	1	1.1036964	-1.8623633	110	3	1.12	0.95	91.2603	-0.2123	0.0000	0.0000;
	1757	1	1.506	0.087	0	0	1	1.0999589	-6.5946764	110	3	1.12	0.95	93.0401	0.2561	0.0000	0.0000;
	1758	1	0	0	0	0	1	1.099932	-6.5964872	110	3	1.12	0.95	93.0419	0.2568	0.0000	0.0000;
	1759	1	1.088	0.144	0	0	1	1.105516	-1.791674	110	3	1.12	0.95	91.1029	-0.2459	0.0000	0.0000;
	1760	1	2.68	-0.769	0	0	1	1.1055319	-1.7993571	110	3	1.12	0.95	91.1090	-0.2487	0.0000	0.0000;
	1761	1	5.872	0.661	0	0	1	1.0990233	-3.7958811	110	3	1.12	0.95	91.7589	-0.2257	0.0000	0.0000;
	1762	1	0	0	0	0	1	1.0990565	-3.7902521	110	3	1.12	0.95	91.7580	-0.2253	0.0000	0.0000;
	1763	1	2.827	0.582	0	0	1	1.0926775	-5.693367	110	3	1.12	0.95	92.8353	-0.2516	0.0000	0.0000;
	1764	1	2.315	0.477	0	0	1	1.0926356	-5.7008034	110	3	1.12	0.95	92.8386	-0.2531	0.0000	0.0000;
	1765	1	1.255	0.042	0	0	1	1.0819575	-5.4498048	110	3	1.12	0.95	92.5395	-0.8847	0.0000	0.0000;
	1766	1	0	0	0	0	1	1.0798499	-5.3985866	110	3	1.12	0.95	92.4965	-0.7630	0.0000	0.0000;
	1767	1	1.424	0.036	0	0	1	1.1036331	-5.1331101	110	3	1.12	0.95	92.5555	0.0697	0.0000	0.0000;
	1768	1	0.921	0.071	0	0	1	1.1036152	-5.1373948	110	3	1.12	0.95	92.5555	0.0692	0.0000	0.0000;
	1769	1	0	0	0	0	1	1.0904033	-5.7686101	110	3	1.12	0.95	93.3190	-0.1322	0.0000	0.0000;
	1770	1	0	0	0	0	1	1.0904107	-5.7674412	110	3	1.12	0.95	93.3197	-0.1312	0.0000	0.0000;
	1771	1	3.765	0.867	0	0	1	1.1039681	-4.0261326	110	3	1.12	0.95	91.8401	0.0075	0.0000	0.0000;
	1772	1	0	0	0	0	1	1.1039502	-4.0244129	110	3	1.12	0.95	91.8391	0.0077	0.0000	0.0000;
	1773	1	3.181	0.498	0	0	1	1.1059018	-3.7060702	110	3	1.12	0.95	91.4940	0.0032	0.0000	0.0000;
	1774	1	2.511	0.676	0	0	1	1.105905	-3.7043192	110	3	1.12	0.95	91.4939	0.0034	0.0000	0.0000;
	1775	1	1.054	0.409	0	0	1	1.094995	-6.3302751	110	3	1.12	0.95	93.2821	-0.5638	0.0000	0.0000;
	1776	1	0	0	0	0	1	1.0950105	-6.3286774	110	3	1.12	0.95	93.2795	-0.5645	0.0000	0.0000;
	1777	1	15.899	4.767	0	0	1	1.0934634	-4.1197571	110	3	1.12	0.95	92.0818	-0.1082	0.0000	0.0000;
	1778	1	0	0	0	0	1	1.0935257	-4.1137087	110	3	1.12	0.95	92.0798	-0.1086	0.0000	0.0000;
	1779	1	0	0	0	0	1	1.108727	-2.0877465	110	3	1.12	0.95	90.0374	-0.0006	0.0000	0.0000;
	1780	1	0	0	0	0	1	1.1087254	-2.0877216	110	3	1.12	0.95	90.0374	-0.0005	0.0000	0.0000;
	1781	1	1.925	0.648	0	0	1	1.1040811	-4.0368844	110	3	1.12	0.95	91.8542	-0.0001	0.0000	0.0000;
	1782	1	0	0	0	0	1	1.104063	-4.0363943	110	3	1.12	0.95	91.8537	0.0001	0.0000	0.0000;
	1783	1	2.093	0.141	0	0	1	1.0957763	-4.0052108	110	3	1.12	0.95	91.9617	-0.1732	0.0000	0.0000;
	1784	1	2.093	0.412	0	0	1	1.095567	-4.0429792	110	3	1.12	0.95	91.9664	-0.1806	0.0000	0.0000;
	1785	1	0	0	0	0	1	1.0958652	-3.9993006	110	3	1.12	0.95	91.9477	-0.1738	0.0000	0.0000;
	1786	1	0	0	0	0	1	1.0956641	-4.0383433	110	3	1.12	0.95	91.9532	-0.1830	0.0000	0.0000;
	1787	1	1.005	0.169	0	0	1	1.0809866	-5.4162173	110	3	1.12	0.95	92.5700	-0.8832	0.0000	0.0000;
	1788	1	0	0	0	0	1	1.0810262	-5.420022	110	3	1.12	0.95	92.5694	-0.8822	0.0000	0.0000;
	1789	1	1.005	0.126	0	0	1	1.1056194	-1.8465267	110	3	1.12	0.95	91.1630	-0.2714	0.0000	0.0000;
	1790	1	0	0	0	0	1	1.1056226	-1.8440397	110	3	1.12	0.95	91.1616	-0.2713	0.0000	0.0000;
	1791	1	0	0	0	0	1	1.0833346	-5.5851315	110	3	1.12	0.95	92.6179	-0.9235	0.0000	0.0000;
	1792	1	0	0	0	0	1	1.0831989	-5.5950172	110	3	1.12	0.95	92.6238	-0.9206	0.0000	0.0000;
	1793	1	5.021	1.733	0	0	1	1.113621	-3.7917893	110	3	1.12	0.95	91.2972	-0.4195	0.0000	0.0000;
	1794	2	20.073	8.094	0	0	1	1.0975038	-3.4518822	110	3	1.12	0.95	91.3487	-0.3221	0.0000	0.0000;
	1795	2	10.011	8.809	0	0	1	1.107032	-4.8879031	110	3	1.12	0.95	91.7282	0.0000	0.0000	0.0000;
	1796	1	1.759	0.623	0	0	1	1.106977	-4.8991662	110	3	1.12	0.95	91.7313	0.0004	0.0000	0.0000;
	1797	1	2.931	1.029	0	0	1	1.1071037	-4.8528844	110	3	1.12	0.95	91.6839	0.0144	0.0000	0.0000;
	1798	1	3.942	1.382	0	0	1	1.107094	-4.8568982	110	3	1.12	0.95	91.6856	0.0141	0.0000	0.0000;
	1799	1	1.089	0.388	0	0	1	1.1099385	-4.416709	110	3	1.12	0.95	91.9066	-0.0118	0.0000	0.0000;
	1800	1	1.089	0.388	0	0	1	1.1044436	-4.0398365	110	3	1.12	0.95	91.8568	-0.0181	0.0000	0.0000;
	1801	1	0	0	0	0	1	1.1099475	-4.4161679	110	3	1.12	0.95	91.9058	-0.0121	0.0000	0.0000;
	1802	1	3.013	0.455	0	0	1	1.0984713	-3.5378038	110	3	1.12	0.95	91.6010	-0.0466	0.0000	0.0000;
	1803	1	1.255	0.195	0	0	1	1.0984656	-3.5431794	110	3	1.12	0.95	91.6027	-0.0475	0.0000	0.0000;
	1804	1	4.023	0.693	0	0	1	1.1013297	-5.5604215	110	3	1.12	0.95	92.6045	0.0054	0.0000	0.0000;
	1805	1	4.353	0.775	0	0	1	1.1009928	-5.5197966	110	3	1.12	0.95	92.5447	0.0092	0.0000	0.0000;
	1806	1	0	0	0	0	1	1.0817712	-5.8113991	110	3	1.12	0.95	92.8416	-0.9334	0.0000	0.0000;
	1807	1	1.841	0.217	0	0	1	1.0817836	-5.8072182	110	3	1.12	0.95	92.8403	-0.9330	0.0000	0.0000;
	1808	1	1.005	-0.706	0	0	1	1.1040677	-2.3301528	110	3	1.12	0.95	91.9200	-0.5296	0.0000	0.0000;
	1809	1	0	0	0	0	1	1.1040677	-2.3301528	110	3	1.12	0.95	91.9200	-0.5296	0.0000	0.0000;
	1810	1	2.762	0.975	0	0	1	1.1054145	-5.049965	110	3	1.12	0.95	91.9447	0.0126	0.0000	0.0000;
	1811	1	4.103	1.408	0	0	1	1.10535	-5.066621	110	3	1.12	0.95	91.9512	0.0124	0.0000	0.0000;
	1812	1	2.899	0.68	0	0	1	1.0848115	-7.6588042	110	3	1.12	0.95	94.5526	0.6339	0.0000	0.0000;
	1813	1	1.967	0.47	0	0	1	1.0847012	-7.6708678	110	3	1.12	0.95	94.5543	0.6366	0.0000	0.0000;
	1814	1	2.094	0.719	0	0	1	1.0970408	-6.4622494	110	3	1.12	0.95	93.2139	0.0352	0.0000	0.0000;
	1815	1	0	0	0	0	1	1.0972161	-6.4559166	110	3	1.12	0.95	93.1922	0.0287	0.0000	0.0000;
	1816	1	0	0	0	0	1	1.0980384	-3.7834453	110	3	1.12	0.95	91.8403	-0.1502	0.0000	0.0000;
	1817	1	0	0	0	0	1	1.0980384	-3.7834452	110	3	1.12	0.95	91.8403	-0.1502	0.0000	0.0000;
	1818	1	0	0	0	0	1	1.0905047	-5.5386971	110	3	1.12	0.95	92.7285	-0.0350	0.0000	0.0000;
	1819	1	0	0	0	0	1	1.089235	-5.9193085	110	3	1.12	0.95	93.1213	-0.0732	0.0000	0.0000;
	1820	1	3.227	0.769	0	0	1	1.0931081	-7.2612329	110	3	1.12	0.95	94.2078	0.0681	0.0000	0.0000;
	1821	1	1.683	0.23	0	0	1	1.0931141	-7.2677537	110	3	1.12	0.95	94.2085	0.0679	0.0000	0.0000;
	1822	1	2.679	0.908	0	0	1	1.0946576	-4.0376196	110	3	1.12	0.95	91.9951	-0.1355	0.0000	0.0000;
	1823	1	0	0	0	0	1	1.0946835	-4.0362572	110	3	1.12	0.95	91.9950	-0.1354	0.0000	0.0000;
	1824	1	3.207	0.488	0	0	1	1.0911473	-5.4856986	110	3	1.12	0.95	92.7038	-0.0290	0.0000	0.0000;
	1825	1	4.356	0.842	0	0	1	1.0911983	-5.4874005	110	3	1.12	0.95	92.7046	-0.0291	0.0000	0.0000;
	1826	1	2.262	0.492	0	0	1	1.1017156	-2.0365615	110	3	1.12	0.95	91.8285	-0.3260	0.0000	0.0000;
	1827	1	2.514	0.672	0	0	1	1.1016848	-2.0328789	110	3	1.12	0.95	91.8320	-0.3260	0.0000	0.0000;
	1828	1	1.34	0.478	0	0	1	1.1101534	-4.3873158	110	3	1.12	0.95	91.8867	-0.0128	0.0000	0.0000;
	1829	1	2.511	0.845	0	0	1	1.1087751	-4.4454029	110	3	1.12	0.95	92.0096	0.0513	0.0000	0.0000;
	1830	1	0	0	0	0	1	1.1088098	-4.4428856	110	3	1.12	0.95	92.0068	0.0503	0.0000	0.0000;
	1831	1	1.692	0.439	0	0	1	1.0887581	-7.745096	110	3	1.12	0.95	94.8305	0.1276	0.0000	0.0000;
	1832	1	2.531	1.028	0	0	1	1.0887527	-7.744044	110	3	1.12	0.95	94.8299	0.1277	0.0000	0.0000;
	1833	1	2.511	0.602	0	0	1	1.1097001	-3.8017485	110	3	1.12	0.95	91.4368	-0.2199	0.0000	0.0000;
	1834	1	2.932	0.675	0	0	1	1.1097834	-3.8015266	110	3	1.12	0.95	91.4352	-0.2218	0.0000	0.0000;
	1835	1	0	0	0	0	1	1.0980459	-3.5910876	110	3	1.12	0.95	91.7407	-0.0547	0.0000	0.0000;
	1836	1	2.51	0.26	0	0	1	1.0980786	-3.5903213	110	3	1.12	0.95	91.7398	-0.0555	0.0000	0.0000;
	1837	2	13	29	0	0	1	1.1132164	-1.4664297	110	3	1.12	0.95	89.3637	0.0000	0.0000	0.0000;
	1838	1	0	0	0	0	1	1.1137541	-5.1938309	110	3	1.12	0.95	91.6830	0.0293	0.0000	0.0000;
	1839	2	13	29	0	0	1	1.1184062	-4.5310241	110	3	1.12	0.95	91.0674	0.0000	0.0000	0.0000;
	1840	1	0	0	0	0	1	1.1098548	-4.3677557	110	3	1.12	0.95	91.9359	0.0186	0.0000	0.0000;
	1841	1	0.837	0.299	0	0	1	1.1098615	-4.3671905	110	3	1.12	0.95	91.9369	0.0186	0.0000	0.0000;
	1842	1	2.967	0.882	0	0	1	1.0840529	-7.7334804	110	3	1.12	0.95	94.6245	0.6509	0.0000	0.0000;
	1843	1	5.196	1.167	0	0	1	1.0972014	-3.4812072	110	3	1.12	0.95	91.3776	-0.3160	0.0000	0.0000;
	1844	1	2.638	0.843	0	0	1	1.0891921	-6.1391544	110	3	1.12	0.95	93.3984	-0.2888	0.0000	0.0000;
	1845	1	2.555	0.956	0	0	1	1.0891784	-6.1452308	110	3	1.12	0.95	93.3993	-0.2913	0.0000	0.0000;
	1846	1	8.874	1.885	0	0	1	1.1008888	-5.5306615	110	3	1.12	0.95	92.5581	0.0153	0.0000	0.0000;
	1847	1	5.862	0.672	0	0	1	1.1008824	-5.5322827	110	3	1.12	0.95	92.5588	0.0151	0.0000	0.0000;
	1848	1	0	0	0	0	1	1.1091376	-4.4554262	110	3	1.12	0.95	92.0330	0.0263	0.0000	0.0000;
	1849	1	2.514	0.586	0	0	1	1.1091559	-4.4535842	110	3	1.12	0.95	92.0325	0.0261	0.0000	0.0000;
	1850	1	3.35	0.553	0	0	1	1.1060039	-6.0117081	110	3	1.12	0.95	92.5435	0.1797	0.0000	0.0000;
	1851	1	4.105	0.92	0	0	1	1.1059733	-6.0184202	110	3	1.12	0.95	92.5447	0.1799	0.0000	0.0000;
	1852	1	1.91	0.407	0	0	1	1.0945126	-5.4110383	110	3	1.12	0.95	92.8152	-0.1227	0.0000	0.0000;
	1853	1	1.156	0.315	0	0	1	1.0944995	-5.4126522	110	3	1.12	0.95	92.8140	-0.1233	0.0000	0.0000;
	1854	1	3.013	0.672	0	0	1	1.0904599	-5.7636199	110	3	1.12	0.95	93.3194	-0.1294	0.0000	0.0000;
	1855	1	2.094	0.502	0	0	1	1.0904743	-5.7612761	110	3	1.12	0.95	93.3197	-0.1284	0.0000	0.0000;
	1856	1	0	0	0	0	1	1.0987115	-4.8334948	110	3	1.12	0.95	92.3519	-0.0642	0.0000	0.0000;
	1857	1	4.19	1.571	0	0	1	1.1016853	-5.4366448	110	3	1.12	0.95	92.4599	0.0097	0.0000	0.0000;
	1858	1	0	0	0	0	1	1.1108312	-4.3322981	110	3	1.12	0.95	91.8479	-0.0244	0.0000	0.0000;
	1859	1	3.432	-32.05	0	0	1	1.0997016	-2.8802236	110	3	1.12	0.95	91.5058	-0.2545	0.0000	0.0000;
	1860	1	0.753	0.065	0	0	1	1.1002049	-3.5534171	110	3	1.12	0.95	91.2913	-0.2368	0.0000	0.0000;
	1861	1	0	0.035	0	0	1	1.0767764	-6.4008842	110	3	1.12	0.95	93.4417	-0.9261	0.0000	0.0000;
	1862	1	1.013	0.039	0	0	1	1.0767774	-6.4010505	110	3	1.12	0.95	93.4417	-0.9259	0.0000	0.0000;
	1863	1	2.848	0.778	0	0	1	1.0833609	-6.5218439	110	3	1.12	0.95	93.8648	-0.4536	0.0000	0.0000;
	1864	1	1.842	0.542	0	0	1	1.083409	-6.5178912	110	3	1.12	0.95	93.8636	-0.4497	0.0000	0.0000;
	1865	1	0.084	0.031	0	0	1	1.0947834	-3.7155398	110	3	1.12	0.95	91.6585	-0.2657	0.0000	0.0000;
	1866	1	0	0	0	0	1	1.0947395	-3.7228167	110	3	1.12	0.95	91.6618	-0.2650	0.0000	0.0000;
	1867	1	0.502	0.087	0	0	1	1.1031953	-5.394886	110	3	1.12	0.95	92.3217	-0.0272	0.0000	0.0000;
	1868	1	0.335	0.043	0	0	1	1.1031927	-5.3901801	110	3	1.12	0.95	92.3200	-0.0276	0.0000	0.0000;
	1869	1	0	0	0	0	1	1.1015987	-6.3896731	110	3	1.12	0.95	92.9426	0.2333	0.0000	0.0000;
	1870	1	0	0	0	0	1	1.0913212	-4.220272	110	3	1.12	0.95	92.3555	-0.1922	0.0000	0.0000;
	1871	1	0	0	0	0	1	1.0913058	-4.2228386	110	3	1.12	0.95	92.3623	-0.1916	0.0000	0.0000;
	1872	1	0	0	0	0	1	1.0784135	-8.002662	110	3	1.12	0.95	95.0306	0.9437	0.0000	0.0000;
	1873	1	0	0	0	0	1	1.0993116	-3.5515188	110	3	1.12	0.95	91.6650	-0.1082	0.0000	0.0000;
	1874	1	0	0	0	0	1	1.0949982	-4.0407931	110	3	1.12	0.95	91.9895	-0.1481	0.0000	0.0000;
	1875	1	1.341	0.384	0	0	1	1.1075239	-4.6276263	110	3	1.12	0.95	92.1301	0.0556	0.0000	0.0000;
	1876	1	1.675	0.308	0	0	1	1.1093076	-4.4846401	110	3	1.12	0.95	91.9705	-0.0041	0.0000	0.0000;
	1877	1	0	0	0	0	1	1.1075255	-4.6275376	110	3	1.12	0.95	92.1299	0.0556	0.0000	0.0000;
	1878	1	0	0	0	0	1	1.1093093	-4.484523	110	3	1.12	0.95	91.9703	-0.0041	0.0000	0.0000;
	1879	1	1.088	0.217	0	0	1	1.1029124	-2.4657974	110	3	1.12	0.95	91.2757	-0.2773	0.0000	0.0000;
	1880	1	1.674	0.575	0	0	1	1.1029203	-2.4615682	110	3	1.12	0.95	91.2780	-0.2766	0.0000	0.0000;
	1881	1	4.272	0.326	0	0	1	1.1085695	-0.62884265	110	3	1.12	0.95	90.2543	-0.1138	0.0000	0.0000;
	1882	1	2.679	-1.024	0	0	1	1.108558	-0.64887226	110	3	1.12	0.95	90.2589	-0.1143	0.0000	0.0000;
	1883	1	6.108	1.733	0	0	1	1.0976919	-3.6206558	110	3	1.12	0.95	91.7731	-0.0461	0.0000	0.0000;
	1884	1	6.443	1.993	0	0	1	1.0976483	-3.622315	110	3	1.12	0.95	91.7745	-0.0451	0.0000	0.0000;
	1885	1	1.951	0.538	0	0	1	1.096759	-6.0182154	110	3	1.12	0.95	92.9176	-0.1328	0.0000	0.0000;
	1886	1	3.235	0.769	0	0	1	1.0967795	-6.0189574	110	3	1.12	0.95	92.9172	-0.1308	0.0000	0.0000;
	1887	1	3.419	0.528	0	0	1	1.0974512	-5.8557726	110	3	1.12	0.95	92.8189	-0.1020	0.0000	0.0000;
	1888	1	0	0	0	0	1	1.0974843	-5.8580708	110	3	1.12	0.95	92.8177	-0.0997	0.0000	0.0000;
	1889	1	0	0	0	0	1	1.0975789	-4.0083608	110	3	1.12	0.95	92.0020	-0.3299	0.0000	0.0000;
	1890	1	2.848	0.507	0	0	1	1.1035924	-2.0963806	110	3	1.12	0.95	91.5686	-0.3280	0.0000	0.0000;
	1891	1	0.502	0.26	0	0	1	1.1015056	-6.4391002	110	3	1.12	0.95	92.9330	0.2229	0.0000	0.0000;
	1892	1	2.929	0.607	0	0	1	1.1014974	-6.4383558	110	3	1.12	0.95	92.9347	0.2235	0.0000	0.0000;
	1893	1	0	0.028	0	0	1	1.0932517	-5.482687	110	3	1.12	0.95	92.7737	-0.1039	0.0000	0.0000;
	1894	1	1.566	-0.068	0	0	1	1.0932371	-5.4838341	110	3	1.12	0.95	92.7723	-0.1045	0.0000	0.0000;
	1895	1	1.424	0.253	0	0	1	1.1011055	-2.1721843	110	3	1.12	0.95	91.6408	-0.1795	0.0000	0.0000;
	1896	1	0.586	0.065	0	0	1	1.1011287	-2.1771044	110	3	1.12	0.95	91.6420	-0.1800	0.0000	0.0000;
	1897	1	6.067	1.105	0	0	1	1.0909893	-4.0778432	110	3	1.12	0.95	92.1326	-0.2027	0.0000	0.0000;
	1898	1	4.745	0.555	0	0	1	1.0909992	-4.0773309	110	3	1.12	0.95	92.1332	-0.2030	0.0000	0.0000;
	1899	1	0.586	0.217	0	0	1	1.1104585	-4.296083	110	3	1.12	0.95	91.8415	0.0178	0.0000	0.0000;
	1900	1	0	0	0	0	1	1.1104662	-4.2955155	110	3	1.12	0.95	91.8410	0.0176	0.0000	0.0000;
	1901	1	5.857	0.867	0	0	1	1.1034701	-5.2831014	110	3	1.12	0.95	92.1762	0.0407	0.0000	0.0000;
	1902	1	2.427	0.52	0	0	1	1.1034493	-5.2878951	110	3	1.12	0.95	92.1778	0.0409	0.0000	0.0000;
	1903	1	3.519	-0.003	0	0	1	1.0952584	-6.3896874	110	3	1.12	0.95	93.5292	-0.0061	0.0000	0.0000;
	1904	1	0	0	0	0	1	1.0952578	-6.3819935	110	3	1.12	0.95	93.5290	-0.0067	0.0000	0.0000;
	1905	1	0	0.061	0	0	1	1.0910484	-4.0673835	110	3	1.12	0.95	92.1178	-0.2003	0.0000	0.0000;
	1906	1	3.268	0.585	0	0	1	1.0910514	-4.0655261	110	3	1.12	0.95	92.1164	-0.2001	0.0000	0.0000;
	1907	1	1.674	-1	0	0	1	1.1029105	-6.1383873	110	3	1.12	0.95	92.7718	0.2573	0.0000	0.0000;
	1908	1	9.205	2.513	0	0	1	1.1029049	-6.1373062	110	3	1.12	0.95	92.7732	0.2575	0.0000	0.0000;
	1909	1	0	0	0	0	1	1.1029098	-6.1384659	110	3	1.12	0.95	92.7716	0.2574	0.0000	0.0000;
	1910	1	0	0	0	0	1	1.1029098	-6.1384659	110	3	1.12	0.95	92.7716	0.2574	0.0000	0.0000;
	1911	1	1.004	0.176	0	0	1	1.10154	-6.397073	110	3	1.12	0.95	92.9505	0.2340	0.0000	0.0000;
	1912	1	1.256	0.265	0	0	1	1.1178167	-4.6193012	110	3	1.12	0.95	91.1576	0.0017	0.0000	0.0000;
	1913	1	0	0	0	0	1	1.1015903	-6.3907724	110	3	1.12	0.95	92.9436	0.2335	0.0000	0.0000;
	1914	1	5.565	0.914	0	0	1	1.0909427	-4.0635469	110	3	1.12	0.95	92.1314	-0.1959	0.0000	0.0000;
	1915	1	8.621	2.388	0	0	1	1.0909216	-4.0614593	110	3	1.12	0.95	92.1318	-0.1951	0.0000	0.0000;
	1916	1	2.179	0.468	0	0	1	1.0910222	-4.0689688	110	3	1.12	0.95	92.1268	-0.2007	0.0000	0.0000;
	1917	1	3.689	0.862	0	0	1	1.0910196	-4.0688489	110	3	1.12	0.95	92.1261	-0.2005	0.0000	0.0000;
	1918	1	1.172	0.084	0	0	1	1.0903196	-4.3689923	110	3	1.12	0.95	92.5331	-0.4768	0.0000	0.0000;
	1919	1	0	0	0	0	1	1.0903186	-4.3667937	110	3	1.12	0.95	92.5311	-0.4750	0.0000	0.0000;
	1920	1	3.013	0.282	0	0	1	1.1004537	-2.6965934	110	3	1.12	0.95	91.4012	-0.2231	0.0000	0.0000;
	1921	1	0.92	0.271	0	0	1	1.1005415	-2.6934309	110	3	1.12	0.95	91.3872	-0.2236	0.0000	0.0000;
	1922	1	1.507	0.529	0	0	1	1.1088425	-4.6450183	110	3	1.12	0.95	91.4525	0.0071	0.0000	0.0000;
	1923	1	1.758	0.618	0	0	1	1.1088629	-4.6392669	110	3	1.12	0.95	91.4500	0.0073	0.0000	0.0000;
	1924	1	0.084	0.13	0	0	1	1.108509	-4.4906057	110	3	1.12	0.95	92.0696	0.0482	0.0000	0.0000;
	1925	1	0	0	0	0	1	1.108509	-4.4906057	110	3	1.12	0.95	92.0696	0.0482	0.0000	0.0000;
	1926	1	0	0	0	0	1	1.1085102	-4.4905891	110	3	1.12	0.95	92.0695	0.0482	0.0000	0.0000;
	1927	1	5.478	1.398	0	0	1	1.0903799	-7.5092438	110	3	1.12	0.95	94.5018	0.1378	0.0000	0.0000;
	1928	1	4.84	0.583	0	0	1	1.0900513	-7.7503097	110	3	1.12	0.95	94.8502	0.0509	0.0000	0.0000;
	1929	2	9.576	8.745	0	0	1	1.1156421	-2.5340956	110	4	1.12	0.95	91.0044	-0.0000	0.0000	0.0000;
	1930	1	0	0	0	0	1	1.1155572	-2.552596	110	4	1.12	0.95	91.0130	0.0015	0.0000	0.0000;
	1931	1	7.964	5.762	0	0	1	1.1111524	-2.6606827	110	4	1.12	0.95	91.3420	0.2290	0.0000	0.0000;
	1932	1	6.884	4.61	0	0	1	1.1115993	-2.650194	110	4	1.12	0.95	91.3093	0.2055	0.0000	0.0000;
	1933	1	7.554	1.408	0	0	1	1.1030264	-7.8158224	110	4	1.12	0.95	93.7345	-0.0299	0.0000	0.0000;
	1934	1	2.32	2.245	0	0	1	1.1015706	-7.3365699	110	4	1.12	0.95	94.0525	0.2913	0.0000	0.0000;
	1935	1	2.148	-1.238	0	0	1	1.0980077	-7.3735051	110	4	1.12	0.95	94.1637	-0.6971	0.0000	0.0000;
	1936	1	0	0	0	0	1	1.107752	-3.0572635	110	4	1.12	0.95	91.7327	0.1514	0.0000	0.0000;
	1937	1	3.435	1.059	0	0	1	1.1152846	-3.6203906	110	4	1.12	0.95	90.9357	-0.4016	0.0000	0.0000;
	1938	1	0	0	0	0	1	1.1152846	-3.6203906	110	4	1.12	0.95	90.9357	-0.4016	0.0000	0.0000;
	1939	1	2.751	-0.07	0	0	1	1.0897881	-6.9002824	110	4	1.12	0.95	94.7311	-0.0100	0.0000	0.0000;
	1940	1	11.092	4.181	0	0	1	1.1070646	-4.3057123	110	4	1.12	0.95	91.5302	-0.1202	0.0000	0.0000;
	1941	1	4.638	0.914	0	0	1	1.0919393	-6.8850059	110	4	1.12	0.95	94.3709	0.0034	0.0000	0.0000;
	1942	1	3.004	-1.413	0	0	1	1.1031899	-8.5357914	110	4	1.12	0.95	94.2741	-0.2621	0.0000	0.0000;
	1943	1	0	0	0	0	1	1.1031964	-8.542206	110	4	1.12	0.95	94.2732	-0.2625	0.0000	0.0000;
	1944	1	2.319	0.409	0	0	1	1.0923099	-7.2305251	110	4	1.12	0.95	94.4360	-0.2755	0.0000	0.0000;
	1945	2	5.148	-0.188	0	0	1	1.1156569	-1.8176469	110	4	1.12	0.95	90.3827	-0.1674	0.0000	0.0000;
	1946	1	4.269	0.092	0	0	1	1.1156784	-1.821486	110	4	1.12	0.95	90.3809	-0.1673	0.0000	0.0000;
	1947	1	3.178	1.484	0	0	1	1.1156495	-1.9274084	110	4	1.12	0.95	90.3776	-0.1625	0.0000	0.0000;
	1948	2	6.059	1.687	0	0	1	1.1131463	-3.9874421	110	4	1.12	0.95	91.2727	-0.4724	0.0000	0.0000;
	1949	1	1.412	0.313	0	0	1	1.1131429	-3.9879697	110	4	1.12	0.95	91.2729	-0.4724	0.0000	0.0000;
	1950	1	6.61	2.988	0	0	1	1.0997119	-8.6640456	110	4	1.12	0.95	94.6138	-0.1734	0.0000	0.0000;
	1951	1	1.889	0.353	0	0	1	1.1155977	-3.5566765	110	4	1.12	0.95	90.9044	-0.4027	0.0000	0.0000;
	1952	1	1.717	0.356	0	0	1	1.115815	-3.5956766	110	4	1.12	0.95	90.9040	-0.4073	0.0000	0.0000;
	1953	1	3.777	1.427	0	0	1	1.0950679	-8.1110427	110	4	1.12	0.95	94.5995	-0.0339	0.0000	0.0000;
	1954	1	2.491	0.164	0	0	1	1.100257	-6.4630712	110	4	1.12	0.95	93.2033	-0.2623	0.0000	0.0000;
	1955	1	0.042	1.498	0	0	1	1.0913837	-7.9151336	110	4	1.12	0.95	94.7857	-0.4619	0.0000	0.0000;
	1956	1	3.524	0.778	0	0	1	1.1047446	-6.0703986	110	4	1.12	0.95	92.8458	-0.2467	0.0000	0.0000;
	1957	1	0.407	-0.023	0	0	1	1.1068047	-6.2388879	110	4	1.12	0.95	92.7257	-0.8009	0.0000	0.0000;
	1958	1	2.663	0.012	0	0	1	1.1157276	-0.95110006	110	4	1.12	0.95	89.9191	-0.0388	0.0000	0.0000;
	1959	2	1.888	0.101	0	0	1	1.117032	-3.3557491	110	4	1.12	0.95	90.7425	-0.3551	0.0000	0.0000;
	1960	1	0	0	0	0	1	1.100733	-5.0046966	110	4	1.12	0.95	93.2301	0.0001	0.0000	0.0000;
	1961	1	4.206	0.922	0	0	1	1.1056344	-8.7144384	110	4	1.12	0.95	94.6435	-0.6071	0.0000	0.0000;
	1962	1	2.534	-1.677	0	0	1	1.1007981	-6.8603186	110	4	1.12	0.95	93.7092	-0.5761	0.0000	0.0000;
	1963	2	3.523	1.03	0	0	1	1.1125249	-4.2272641	110	4	1.12	0.95	91.6812	-0.6225	0.0000	0.0000;
	1964	1	0	0	0	0	1	1.1125249	-4.2272641	110	4	1.12	0.95	91.6812	-0.6225	0.0000	0.0000;
	1965	2	3.803	3.849	0	0	1	1.1082755	-4.1172292	110	4	1.12	0.95	91.3206	-0.0790	0.0000	0.0000;
	1966	1	0	0	0	0	1	1.1103818	-3.9821339	110	4	1.12	0.95	91.3219	-0.2031	0.0000	0.0000;
	1967	1	1.213	0.083	0	0	1	1.1122009	-3.3558457	110	4	1.12	0.95	91.7501	0.0211	0.0000	0.0000;
	1968	1	7.124	-0.423	0	0	1	1.0903788	-11.010403	110	4	1.12	0.95	96.2616	-0.3120	0.0000	0.0000;
	1969	1	2.663	-0.29	0	0	1	1.0951487	-6.1787097	110	4	1.12	0.95	94.0462	-0.0378	0.0000	0.0000;
	1970	1	0.859	0.182	0	0	1	1.1109959	-4.5330626	110	4	1.12	0.95	91.5733	-0.2246	0.0000	0.0000;
	1971	1	2.578	-0.436	0	0	1	1.0933417	-7.332823	110	4	1.12	0.95	94.4902	-0.1607	0.0000	0.0000;
	1972	1	0.946	0.565	0	0	1	1.1074748	-6.0458274	110	4	1.12	0.95	92.7443	-0.1115	0.0000	0.0000;
	1973	1	2.834	0.239	0	0	1	1.1138173	-3.0523772	110	4	1.12	0.95	90.7149	-0.1937	0.0000	0.0000;
	1974	1	0.686	-2.42	0	0	1	1.102201	-8.3478209	110	4	1.12	0.95	94.2564	-0.1783	0.0000	0.0000;
	1975	1	0	0	0	0	1	1.1171892	-3.276542	110	4	1.12	0.95	90.6534	-0.3293	0.0000	0.0000;
	1976	1	0	0	0	0	1	1.1171892	-3.276542	110	4	1.12	0.95	90.6534	-0.3293	0.0000	0.0000;
	1977	1	0	0	0	0	1	1.1114466	-4.4860145	110	4	1.12	0.95	91.4891	-0.2184	0.0000	0.0000;
	1978	1	0	0	0	0	1	1.1068361	-4.3417546	110	4	1.12	0.95	91.7638	-0.1588	0.0000	0.0000;
	1979	1	0.601	0.083	0	0	1	1.1173099	-1.5856938	110	4	1.12	0.95	90.1419	-0.1541	0.0000	0.0000;
	1980	1	2.32	0.128	0	0	1	1.0909309	-8.2926552	110	4	1.12	0.95	95.3223	-0.2910	0.0000	0.0000;
	1981	1	6.352	1.472	0	0	1	1.1017973	-8.1930237	110	4	1.12	0.95	94.1513	-0.1205	0.0000	0.0000;
	1982	1	1.041	0.883	0	0	1	1.0909468	-7.4523507	110	4	1.12	0.95	94.9762	-0.4274	0.0000	0.0000;
	1983	1	3.948	-1.474	0	0	1	1.1040665	-8.2060689	110	4	1.12	0.95	94.0600	-0.2161	0.0000	0.0000;
	1984	1	1.328	0.576	0	0	1	1.1039459	-8.1997061	110	4	1.12	0.95	94.0561	-0.2141	0.0000	0.0000;
	1985	1	4.293	0.682	0	0	1	1.0879547	-10.919901	110	4	1.12	0.95	97.0241	-0.5170	0.0000	0.0000;
	1986	1	4.726	0.645	0	0	1	1.0911799	-6.6780013	110	4	1.12	0.95	94.3981	0.0452	0.0000	0.0000;
	1987	1	1.787	0.192	0	0	1	1.1052067	-6.4821346	110	4	1.12	0.95	92.9517	-0.7640	0.0000	0.0000;
	1988	1	2.133	0.872	0	0	1	1.1049119	-4.5993437	110	4	1.12	0.95	92.9013	0.1864	0.0000	0.0000;
	1989	1	1.289	-0.071	0	0	1	1.0943892	-8.8374203	110	4	1.12	0.95	95.4669	-0.5700	0.0000	0.0000;
	1990	1	2.75	-0.313	0	0	1	1.0865351	-7.4102056	110	4	1.12	0.95	95.0211	0.0151	0.0000	0.0000;
	1991	1	1.719	2.228	0	0	1	1.0900758	-8.026917	110	4	1.12	0.95	95.1675	-0.1859	0.0000	0.0000;
	1992	2	13.979	8.413	0	0	1	1.1007817	-4.990385	110	4	1.12	0.95	93.2277	0.0000	0.0000	0.0000;
	1993	1	0	0	0	0	1	1.1007817	-4.990385	110	4	1.12	0.95	93.2277	-0.0000	0.0000	0.0000;
	1994	1	1.038	0.036	0	0	1	1.0961325	-8.5880117	110	4	1.12	0.95	95.0226	-0.5728	0.0000	0.0000;
	1995	1	0.937	0.035	0	0	1	1.0961316	-8.5883796	110	4	1.12	0.95	95.0227	-0.5728	0.0000	0.0000;
	1996	1	3.863	-1.05	0	0	1	1.0962651	-9.0316964	110	4	1.12	0.95	95.3699	-0.6256	0.0000	0.0000;
	1997	1	1.289	-0.046	0	0	1	1.1123144	-4.3630411	110	4	1.12	0.95	91.8863	-0.6892	0.0000	0.0000;
	1998	1	9.204	0.198	0	0	1	1.0970963	-7.0251883	110	4	1.12	0.95	94.2498	-0.6225	0.0000	0.0000;
	1999	1	0	0	0	0	1	1.0970963	-7.0251883	110	4	1.12	0.95	94.2498	-0.6225	0.0000	0.0000;
	2000	1	2.756	0.845	0	0	1	1.1136751	-3.9404768	110	4	1.12	0.95	91.2529	-0.4135	0.0000	0.0000;
	2001	1	2.493	0.841	0	0	1	1.113248	-3.992546	110	4	1.12	0.95	91.2747	-0.4852	0.0000	0.0000;
	2002	2	14.089	13.83	0	0	1	1.1031654	-7.8195847	110	4	1.12	0.95	93.7470	-0.0573	0.0000	0.0000;
	2003	1	0	0	0	0	1	1.1018832	-8.3681297	110	4	1.12	0.95	94.2831	-0.1703	0.0000	0.0000;
	2004	1	3.265	1.49	0	0	1	1.0988735	-8.3052732	110	4	1.12	0.95	93.9834	0.0075	0.0000	0.0000;
	2005	1	0	0	0	0	1	1.0941583	-7.7740985	110	4	1.12	0.95	94.8405	-0.2352	0.0000	0.0000;
	2006	1	2.75	0.691	0	0	1	1.1048242	-8.4628938	110	4	1.12	0.95	94.3971	-0.3779	0.0000	0.0000;
	2007	1	2.32	1.383	0	0	1	1.0981957	-8.4729308	110	4	1.12	0.95	94.6261	-0.0534	0.0000	0.0000;
	2008	2	2.014	1.207	0	0	1	1.0809168	-8.6381743	110	4	1.12	0.95	96.6109	0.1572	0.0000	0.0000;
	2009	1	2.919	1.383	0	0	1	1.0915044	-6.9471168	110	4	1.12	0.95	94.4084	0.0127	0.0000	0.0000;
	2010	1	0	0	0	0	1	1.0915038	-6.9531788	110	4	1.12	0.95	94.4106	0.0124	0.0000	0.0000;
	2011	1	4.035	1.478	0	0	1	1.0989481	-7.8398235	110	4	1.12	0.95	93.4065	0.1295	0.0000	0.0000;
	2012	1	5.07	2.575	0	0	1	1.0975371	-8.2337296	110	4	1.12	0.95	93.8455	0.0907	0.0000	0.0000;
	2013	1	5.882	1.832	0	0	1	1.0975609	-8.2455514	110	4	1.12	0.95	93.8516	0.0902	0.0000	0.0000;
	2014	1	3.004	1.152	0	0	1	1.1002475	-7.3635411	110	4	1.12	0.95	93.9754	-0.1598	0.0000	0.0000;
	2015	2	24.136	9.827	0	0	1	1.0973331	-7.0257146	110	4	1.12	0.95	93.6938	-0.3890	0.0000	0.0000;
	2016	1	1.618	0	0	0	1	1.0967656	-7.0812894	110	4	1.12	0.95	93.7394	-0.3769	0.0000	0.0000;
	2017	1	3.266	0.221	0	0	1	1.0811702	-7.5946475	110	4	1.12	0.95	96.0850	0.1181	0.0000	0.0000;
	2018	1	2.406	0.674	0	0	1	1.0960173	-7.1223663	110	4	1.12	0.95	93.8216	-0.3526	0.0000	0.0000;
	2019	1	2.148	1.242	0	0	1	1.096012	-7.1233078	110	4	1.12	0.95	93.8216	-0.3526	0.0000	0.0000;
	2020	1	2.839	0.975	0	0	1	1.1076176	-5.2965893	110	4	1.12	0.95	92.1912	-0.2157	0.0000	0.0000;
	2021	1	5.493	-1.247	0	0	1	1.107044	-8.7916266	110	4	1.12	0.95	94.7477	-0.8297	0.0000	0.0000;
	2022	1	0.859	0.532	0	0	1	1.110798	-4.5478802	110	4	1.12	0.95	91.5886	-0.2196	0.0000	0.0000;
	2023	1	4.297	2.568	0	0	1	1.0981778	-5.3817437	110	4	1.12	0.95	93.5058	0.0297	0.0000	0.0000;
	2024	1	2.32	0.792	0	0	1	1.1143117	-3.8725756	110	4	1.12	0.95	91.2354	-0.4799	0.0000	0.0000;
	2025	1	0	0	0	0	1	1.1143117	-3.8725756	110	4	1.12	0.95	91.2354	-0.4799	0.0000	0.0000;
	2026	1	3.694	0.754	0	0	1	1.0960741	-7.1274165	110	4	1.12	0.95	93.8203	-0.3588	0.0000	0.0000;
	2027	1	2.319	0.38	0	0	1	1.0962719	-7.1191795	110	4	1.12	0.95	93.7981	-0.3658	0.0000	0.0000;
	2028	1	13.219	7.162	0	0	1	1.092927	-7.4838781	110	4	1.12	0.95	94.3114	0.1246	0.0000	0.0000;
	2029	1	1.959	-1.738	0	0	1	1.098495	-7.2922367	110	4	1.12	0.95	94.3234	-0.7747	0.0000	0.0000;
	2030	1	6.705	0.916	0	0	1	1.0908624	-6.9729763	110	4	1.12	0.95	94.4909	0.0298	0.0000	0.0000;
	2031	1	1.375	0.755	0	0	1	1.0964165	-7.0993854	110	4	1.12	0.95	93.7767	-0.3649	0.0000	0.0000;
	2032	1	1.289	0.99	0	0	1	1.080416	-7.8672508	110	4	1.12	0.95	95.8191	0.1064	0.0000	0.0000;
	2033	1	0.175	0.16	0	0	1	1.1098864	-5.3157692	110	4	1.12	0.95	92.0197	-0.2852	0.0000	0.0000;
	2034	1	0	0	0	0	1	1.1098918	-5.3215119	110	4	1.12	0.95	92.0200	-0.2853	0.0000	0.0000;
	2035	1	2.748	0.55	0	0	1	1.08955	-8.2576998	110	4	1.12	0.95	95.3324	0.2351	0.0000	0.0000;
	2036	2	10.07	4.137	0	0	1	1.105388	-6.0543601	110	4	1.12	0.95	92.7770	-0.2909	0.0000	0.0000;
	2037	1	1.983	-9.52	0	0	1	1.1012697	-6.4446091	110	4	1.12	0.95	93.1536	-0.2974	0.0000	0.0000;
	2038	1	22.407	17.919	0	0	1	1.097159	-6.541969	110	4	1.12	0.95	93.3170	-0.1255	0.0000	0.0000;
	2039	1	0	0	0	0	1	1.1056205	-6.1843072	110	4	1.12	0.95	92.8356	-0.2956	0.0000	0.0000;
	2040	2	14.218	9.189	-0.013	-0.04	1	1.1036954	-4.5966014	110	4	1.12	0.95	92.2240	-0.0619	0.0000	0.0000;
	2041	1	2.591	2.04	0	0	1	1.1044836	-4.5854273	110	4	1.12	0.95	92.1812	-0.1102	0.0000	0.0000;
	2042	2	88.535	66.96	0	0	1	1.1175627	-4.5499801	110	4	1.12	0.95	92.1405	-0.0000	0.0000	0.0000;
	2043	1	0	0	0	0	1	1.1175627	-4.5499801	110	4	1.12	0.95	92.1405	-0.0000	0.0000	0.0000;
	2044	1	0.601	0.29	0	0	1	1.1128928	-3.2931251	110	4	1.12	0.95	90.5033	-0.0266	0.0000	0.0000;
	2045	1	1.804	0.886	0	0	1	1.107338	-4.3054191	110	4	1.12	0.95	91.5335	-0.1247	0.0000	0.0000;
	2046	1	4.035	2.896	0	0	1	1.1006061	-7.7932779	110	4	1.12	0.95	94.0013	0.0979	0.0000	0.0000;
	2047	2	3.151	0.106	0	0	1	1.1141381	-3.8360309	110	4	1.12	0.95	91.1329	-0.4032	0.0000	0.0000;
	2048	1	0.967	0.054	0	0	1	1.114137	-3.8363977	110	4	1.12	0.95	91.1330	-0.4032	0.0000	0.0000;
	2049	1	4.242	0.218	0	0	1	1.0949487	-7.8114957	110	4	1.12	0.95	94.6492	-0.6106	0.0000	0.0000;
	2050	1	3.866	0.604	0	0	1	1.0971692	-7.0429033	110	4	1.12	0.95	93.7195	-0.3871	0.0000	0.0000;
	2051	1	3.265	1.42	0	0	1	1.0968723	-2.4333985	110	4	1.12	0.95	92.3458	-0.1284	0.0000	0.0000;
	2052	1	4.811	0.304	0	0	1	1.1164236	-3.4274311	110	4	1.12	0.95	90.7945	-0.3484	0.0000	0.0000;
	2053	1	5.666	1.733	0	0	1	1.1022731	-8.5812428	110	4	1.12	0.95	94.5126	-0.2838	0.0000	0.0000;
	2054	1	17.293	11.64	0	0	1	1.1154176	-4.1700274	110	4	1.12	0.95	89.5591	0.2265	0.0000	0.0000;
	2055	1	5.415	3.014	0	0	1	1.1006946	-5.6507077	110	4	1.12	0.95	92.9231	0.0864	0.0000	0.0000;
	2056	1	0	0	0	0	1	1.1014047	-5.623309	110	4	1.12	0.95	92.8686	0.0667	0.0000	0.0000;
	2057	2	1.968	1.882	0	0	1	1.0844515	-11.754061	110	4	1.12	0.95	97.1670	-0.2583	0.0000	0.0000;
	2058	1	0	0	0	0	1	1.1130036	-2.7022587	110	4	1.12	0.95	91.2490	0.0221	0.0000	0.0000;
	2059	1	2.58	3.789	0	0	1	1.1054827	-4.3118539	110	4	1.12	0.95	91.9755	-0.0547	0.0000	0.0000;
	2060	1	1.717	0.13	0	0	1	1.116783	-3.3704531	110	4	1.12	0.95	90.7302	-0.3400	0.0000	0.0000;
	2061	1	0.859	0.071	0	0	1	1.117091	-3.2910676	110	4	1.12	0.95	90.6695	-0.3295	0.0000	0.0000;
	2062	1	3.984	-1.078	0	0	1	1.1080358	-4.238913	110	4	1.12	0.95	92.5582	0.0750	0.0000	0.0000;
	2063	1	3.436	0.784	0	0	1	1.1154186	-3.5842153	110	4	1.12	0.95	90.9718	-0.3904	0.0000	0.0000;
	2064	2	0.36	0.346	0	0	1	1.1089044	-4.0961273	110	4	1.12	0.95	92.4326	0.0533	0.0000	0.0000;
	2065	1	6.178	3.342	0	0	1	1.1091686	-5.0676841	110	4	1.12	0.95	91.9303	-0.1753	0.0000	0.0000;
	2066	1	7.305	1.309	0	0	1	1.105241	-4.5815912	110	4	1.12	0.95	92.8804	0.1758	0.0000	0.0000;
	2067	1	0	0	0	0	1	1.12	-4.0535259	110	4	1.12	0.95	89.0874	-0.2322	1711.4065	0.0000;
	2068	1	7.468	4.588	0	0	1	1.0980849	-8.0093995	110	4	1.12	0.95	94.4127	0.0568	0.0000	0.0000;
	2069	1	3.866	3.573	0	0	1	1.1103489	-5.2251924	110	4	1.12	0.95	90.5936	0.2354	0.0000	0.0000;
	2070	1	6.652	4.714	0	0	1	1.1150157	-0.88706122	110	4	1.12	0.95	90.7655	0.2439	0.0000	0.0000;
	2071	2	2.901	0.129	0	0	1	1.1125324	-4.2562464	110	4	1.12	0.95	91.7350	-0.6230	0.0000	0.0000;
	2072	1	3.644	0.706	0	0	1	1.1125342	-4.2584021	110	4	1.12	0.95	91.7357	-0.6234	0.0000	0.0000;
	2073	1	8.843	3.761	0	0	1	1.0992975	-8.7963659	110	4	1.12	0.95	94.7900	-0.2530	0.0000	0.0000;
	2074	1	6.528	0.534	0	0	1	1.1057578	-5.4181101	110	4	1.12	0.95	92.4352	-0.2288	0.0000	0.0000;
	2075	1	0	0	0	0	1	1.1033981	-2.3722828	110	4	1.12	0.95	91.8047	-0.4524	0.0000	0.0000;
	2076	1	2.406	-0.675	0	0	1	1.1000076	-7.507245	110	4	1.12	0.95	94.4324	-0.8356	0.0000	0.0000;
	2077	1	0	0	0	0	1	1.1118946	-3.4336111	110	4	1.12	0.95	90.7534	-0.0908	0.0000	0.0000;
	2078	1	0	0	0	0	1	1.1076404	-4.2707181	110	4	1.12	0.95	91.4521	-0.1250	0.0000	0.0000;
	2079	1	0	0	0	0	1	1.0977862	-5.8461515	110	4	1.12	0.95	93.0057	-0.0874	0.0000	0.0000;
	2080	1	10.897	5.336	0	0	1	1.0956998	-6.4554146	110	4	1.12	0.95	93.3133	0.0350	0.0000	0.0000;
	2081	1	10.301	2.305	0	0	1	1.0999163	-5.3496232	110	4	1.12	0.95	92.6348	-0.0767	0.0000	0.0000;
	2082	1	6.185	2.708	0	0	1	1.1034293	-5.4863418	110	4	1.12	0.95	92.4097	-0.0885	0.0000	0.0000;
	2083	1	1.717	1.735	0	0	1	1.1056691	-3.2240518	110	4	1.12	0.95	91.9414	0.1588	0.0000	0.0000;
	2084	1	4.641	1.152	0	0	1	1.0984952	-5.5950719	110	4	1.12	0.95	92.8741	-0.0784	0.0000	0.0000;
	2085	1	3.141	1.245	0	0	1	1.0977774	-5.8459858	110	4	1.12	0.95	93.0057	-0.0869	0.0000	0.0000;
	2086	1	2.579	1.265	0	0	1	1.0986141	-5.7572117	110	4	1.12	0.95	93.0692	0.1418	0.0000	0.0000;
	2087	1	3.267	0.363	0	0	1	1.0886339	-8.2438752	110	4	1.12	0.95	95.7021	-0.1141	0.0000	0.0000;
	2088	1	8.51	4.858	0	0	1	1.098833	-6.8328195	110	4	1.12	0.95	93.9224	-0.6180	0.0000	0.0000;
	2089	1	0	0	0	0	1	1.1151556	-0.88135238	110	4	1.12	0.95	90.7588	0.2391	0.0000	0.0000;
	2090	1	3.607	3.126	0	0	1	1.1093704	-2.9023767	110	4	1.12	0.95	91.5398	0.1552	0.0000	0.0000;
	2091	2	0	0	0	0	1	1.1169676	-4.5591238	110	4	1.12	0.95	92.1462	0.0007	0.0000	0.0000;
	2092	2	3.005	0	0	0	1	1.119368	-4.821888	110	4	1.12	0.95	91.2724	-0.4349	0.0000	0.0000;
	2093	1	0	0	0	0	1	1.1197248	-4.5483652	110	4	1.12	0.95	92.1337	-0.0333	0.0000	0.0000;
	2094	2	2.146	0	0	0	1	1.0238788	-2.5189569	15	4	1.12	0.95	91.6531	-0.1392	0.0000	0.0000;
	2095	1	1.289	0.627	0	0	1	1.1022654	-5.5462773	110	4	1.12	0.95	92.7802	0.0247	0.0000	0.0000;
	2096	1	3.436	0.734	0	0	1	1.1156781	-3.460494	110	4	1.12	0.95	90.9083	-0.3590	0.0000	0.0000;
	2097	2	9.249	7.082	0	0	1	1.098152	-6.3196277	110	4	1.12	0.95	93.1179	-0.0438	0.0000	0.0000;
	2098	1	12.062	3.63	0	0	1	1.0981874	-6.3334588	110	4	1.12	0.95	93.1358	-0.0575	0.0000	0.0000;
	2099	1	12.037	2.305	0	0	1	1.0987264	-5.5835042	110	4	1.12	0.95	92.8483	-0.0860	0.0000	0.0000;
	2100	1	6.009	1.152	0	0	1	1.0989091	-5.6020012	110	4	1.12	0.95	92.8302	-0.0937	0.0000	0.0000;
	2101	1	0.259	0	0	0	1	1.1064614	-3.1688471	110	4	1.12	0.95	91.8698	0.1521	0.0000	0.0000;
	2102	1	1.203	2.206	0	0	1	1.0986665	-5.7769992	110	4	1.12	0.95	92.9252	-0.1064	0.0000	0.0000;
	2103	1	2.089	1.072	0	0	1	1.0986333	-5.7689061	110	4	1.12	0.95	92.9264	-0.1061	0.0000	0.0000;
	2104	1	0	0	0	0	1	1.1018243	-5.0195691	110	4	1.12	0.95	93.2783	-0.0225	0.0000	0.0000;
	2105	1	0.172	0.115	0	0	1	1.1008776	-5.8940824	110	4	1.12	0.95	92.7437	-0.0647	0.0000	0.0000;
	2106	1	0	0	0	0	1	1.1155193	-2.2494414	110	4	1.12	0.95	90.4280	-0.1751	0.0000	0.0000;
	2107	1	0	0	0	0	1	1.1154961	-2.242362	110	4	1.12	0.95	90.4312	-0.1750	0.0000	0.0000;
	2108	1	18.564	14.845	0	0	1	1.0979827	-6.2892036	110	4	1.12	0.95	93.0828	-0.0278	0.0000	0.0000;
	2109	1	9.134	4.472	0	0	1	1.0986283	-5.5840968	110	4	1.12	0.95	92.8355	-0.0782	0.0000	0.0000;
	2110	1	4.3	0.191	0	0	1	1.0992208	-6.1822128	110	4	1.12	0.95	92.9634	-0.0546	0.0000	0.0000;
	2111	1	0.343	2.122	0	0	1	1.1006341	-5.2919889	110	4	1.12	0.95	92.5576	-0.0956	0.0000	0.0000;
	2112	1	0	0	0	0	1	1.1006687	-5.2797843	110	4	1.12	0.95	92.5551	-0.0957	0.0000	0.0000;
	2113	1	3.784	3.406	0	0	1	1.0995045	-6.1160927	110	4	1.12	0.95	92.9256	-0.0531	0.0000	0.0000;
	2114	1	1.897	1.164	0	0	1	1.0995364	-6.1211943	110	4	1.12	0.95	92.9258	-0.0537	0.0000	0.0000;
	2115	1	1.546	5.254	0	0	1	1.0983383	-6.2725589	110	4	1.12	0.95	93.0765	-0.0491	0.0000	0.0000;
	2116	1	0	2.547	0	0	1	1.0988887	-5.5573831	110	4	1.12	0.95	92.8008	-0.0845	0.0000	0.0000;
	2117	1	0.515	0.65	0	0	1	1.0999137	-6.2266156	110	4	1.12	0.95	93.0850	-0.2097	0.0000	0.0000;
	2118	1	3.268	1.537	0	0	1	1.1081409	-2.982659	110	4	1.12	0.95	91.6685	0.0821	0.0000	0.0000;
	2119	2	21.559	10.82	0	0	1	1.0779669	-7.8257085	110	4	1.12	0.95	95.9296	0.3334	0.0000	0.0000;
	2120	1	5.759	4.306	0	0	1	1.0977464	-6.4265488	110	4	1.12	0.95	93.1966	-0.0873	0.0000	0.0000;
	2121	1	3.132	3.596	0	0	1	1.0977709	-6.4270606	110	4	1.12	0.95	93.1968	-0.0884	0.0000	0.0000;
	2122	1	5.156	-1.512	0	0	1	1.099262	-5.9978468	110	4	1.12	0.95	93.0138	-0.1576	0.0000	0.0000;
	2123	1	4.563	1.925	0	0	1	1.0977202	-6.3736166	110	4	1.12	0.95	93.1543	-0.0465	0.0000	0.0000;
	2124	1	0	0	0	0	1	1.0966623	-6.0050096	110	4	1.12	0.95	93.3050	0.1769	0.0000	0.0000;
	2125	1	2.922	0.088	0	0	1	1.0970146	-5.8115447	110	4	1.12	0.95	93.1663	0.1888	0.0000	0.0000;
	2126	1	4.378	2.409	0	0	1	1.1007295	-8.6392499	110	4	1.12	0.95	94.5813	-0.2222	0.0000	0.0000;
	2127	1	15.56	16.049	0	0	1	1.0969189	-5.8084457	110	4	1.12	0.95	93.1673	0.1967	0.0000	0.0000;
	2128	1	0	0	0	0	1	1.1121811	-4.3971592	110	4	1.12	0.95	91.9372	-0.7055	0.0000	0.0000;
	2129	1	1.378	-0.166	0	0	1	1.1121813	-4.3976931	110	4	1.12	0.95	91.9373	-0.7055	0.0000	0.0000;
	2130	1	7.489	2.599	0	0	1	1.1044023	-4.5344152	110	4	1.12	0.95	91.9638	-0.0984	0.0000	0.0000;
	2131	1	4.185	2.847	0	0	1	1.1008938	-5.2610533	110	4	1.12	0.95	92.4898	-0.0862	0.0000	0.0000;
	2132	1	1.289	0.192	0	0	1	1.1049779	-4.7294246	110	4	1.12	0.95	92.3662	-0.2751	0.0000	0.0000;
	2133	1	4.474	2.047	0	0	1	1.1099972	-3.5083424	110	4	1.12	0.95	90.9440	-0.0172	0.0000	0.0000;
	2134	1	2.063	1.374	0	0	1	1.1086323	-2.9628624	110	4	1.12	0.95	91.6179	0.1612	0.0000	0.0000;
	2135	1	0	0	0	0	1	1.1143964	-3.9734484	110	4	1.12	0.95	91.2009	-0.5688	0.0000	0.0000;
	2136	1	2.32	0.702	0	0	1	1.1143895	-3.9743063	110	4	1.12	0.95	91.2011	-0.5687	0.0000	0.0000;
	2137	1	2.75	0.199	0	0	1	1.0920793	-8.5803087	110	4	1.12	0.95	95.4777	-0.4350	0.0000	0.0000;
	2138	1	6.328	3.576	0	0	1	1.1044208	-4.6240785	110	4	1.12	0.95	92.9305	0.2027	0.0000	0.0000;
	2139	1	0	0	0	0	1	1.1097893	-5.0366983	110	4	1.12	0.95	91.8820	-0.1969	0.0000	0.0000;
	2140	1	1.116	-0.232	0	0	1	1.0916406	-6.9400192	110	4	1.12	0.95	94.4045	0.0076	0.0000	0.0000;
	2141	2	4.719	0.815	0	0	1	1.1161747	-1.6101834	110	4	1.12	0.95	90.2223	-0.1181	0.0000	0.0000;
	2142	1	1.204	0.164	0	0	1	1.1153279	-3.6012152	110	4	1.12	0.95	90.9874	-0.3907	0.0000	0.0000;
	2143	1	9.116	3.863	0	0	1	1.1058509	-6.1397189	110	4	1.12	0.95	93.3775	0.2572	0.0000	0.0000;
	2144	1	1.717	-0.052	0	0	1	1.1130074	-4.1401504	110	4	1.12	0.95	91.5918	-0.6360	0.0000	0.0000;
	2145	1	0	0.058	0	0	1	1.113007	-4.1401482	110	4	1.12	0.95	91.5918	-0.6359	0.0000	0.0000;
	2146	1	8.756	-1.053	0	0	1	1.1012345	-7.7071677	110	4	1.12	0.95	94.1546	-0.2188	0.0000	0.0000;
	2147	1	0	0	0	0	1	1.1012345	-7.7071677	110	4	1.12	0.95	94.1546	-0.2188	0.0000	0.0000;
	2148	1	6.529	0.113	0	0	1	1.1051504	-4.6401164	110	4	1.12	0.95	92.1242	-0.1615	0.0000	0.0000;
	2149	1	7.896	3.988	0	0	1	1.1002966	-4.7744768	110	4	1.12	0.95	92.4742	0.0421	0.0000	0.0000;
	2150	1	0	0	0	0	1	1.1054296	-4.5786746	110	4	1.12	0.95	92.0805	-0.1589	0.0000	0.0000;
	2151	1	3.264	0.361	0	0	1	1.1050243	-4.5913229	110	4	1.12	0.95	92.1352	-0.1456	0.0000	0.0000;
	2152	1	5.667	0.644	0	0	1	1.1001258	-7.7973001	110	4	1.12	0.95	94.2497	-0.1903	0.0000	0.0000;
	2153	1	1.264	0.325	0	0	1	1.0903931	-6.7617468	110	4	1.12	0.95	94.3543	0.0146	0.0000	0.0000;
	2154	1	0	0	0	0	1	1.1103904	-5.9854099	110	4	1.12	0.95	92.3243	-0.8709	0.0000	0.0000;
	2155	1	0	0	0	0	1	1.1084087	-5.9159867	110	4	1.12	0.95	92.4376	-0.8257	0.0000	0.0000;
	2156	1	0.343	-0.115	0	0	1	1.0996627	-8.4632745	110	4	1.12	0.95	94.5580	-0.1534	0.0000	0.0000;
	2157	1	0.515	0.288	0	0	1	1.1043943	-5.5180957	110	4	1.12	0.95	92.6036	-0.0269	0.0000	0.0000;
	2158	1	2.405	0.115	0	0	1	1.0931399	-7.2741112	110	4	1.12	0.95	94.2521	-0.2822	0.0000	0.0000;
	2159	1	2.491	0.626	0	0	1	1.0987543	-6.9901608	110	4	1.12	0.95	93.6190	-0.4917	0.0000	0.0000;
	2160	1	3.706	-3.339	0	0	1	1.1105953	-6.1877008	110	4	1.12	0.95	92.6197	-1.0593	0.0000	0.0000;
	2161	1	1.374	0.106	0	0	1	1.1157091	-2.0064554	110	4	1.12	0.95	90.3802	-0.1596	0.0000	0.0000;
	2162	1	3.006	0.217	0	0	1	1.1154347	-3.5762035	110	4	1.12	0.95	90.9674	-0.3920	0.0000	0.0000;
	2163	1	1.719	-1.244	0	0	1	1.0945963	-7.4570513	110	4	1.12	0.95	94.4594	-0.1327	0.0000	0.0000;
	2164	1	3.264	0.944	0	0	1	1.1146986	-3.7041318	110	4	1.12	0.95	91.0841	-0.4307	0.0000	0.0000;
	2165	1	2.49	2.017	0	0	1	1.0915059	-7.974825	110	4	1.12	0.95	94.7376	0.3384	0.0000	0.0000;
	2166	1	1.719	0.905	0	0	1	1.0915036	-7.0587852	110	4	1.12	0.95	94.5232	-0.0286	0.0000	0.0000;
	2167	1	0.343	0.293	0	0	1	1.0747557	-8.1860215	110	4	1.12	0.95	97.2355	0.1398	0.0000	0.0000;
	2168	1	1.72	0.118	0	0	1	1.0987826	-8.9830462	110	4	1.12	0.95	95.2967	-0.7141	0.0000	0.0000;
	2169	1	3.781	-1.308	0	0	1	1.0996322	-8.3465014	110	4	1.12	0.95	94.5437	-0.5454	0.0000	0.0000;
	2170	1	1.289	0.073	0	0	1	1.1157263	-3.5367502	110	4	1.12	0.95	90.9253	-0.3822	0.0000	0.0000;
	2171	1	0.686	0.187	0	0	1	1.1184193	-1.0784492	110	4	1.12	0.95	89.7936	-0.0756	0.0000	0.0000;
	2172	1	2.32	0.761	0	0	1	1.1161323	-0.86199388	110	4	1.12	0.95	89.8143	-0.0231	0.0000	0.0000;
	2173	1	3.606	0.584	0	0	1	1.0775181	-12.333509	110	4	1.12	0.95	98.1627	-0.2703	0.0000	0.0000;
	2174	1	0.515	0.12	0	0	1	1.109833	-13.729724	110	4	1.12	0.95	96.5322	-0.3285	0.0000	0.0000;
	2175	1	4.553	-1.094	0	0	1	1.1034096	-5.2856723	110	4	1.12	0.95	92.5485	-0.1047	0.0000	0.0000;
	2176	2	1.499	0.085	0	0	1	1.1099776	-4.1440135	110	4	1.12	0.95	91.4757	-0.2290	0.0000	0.0000;
	2177	1	0.817	0.084	0	0	1	1.0968156	-2.4382654	110	4	1.12	0.95	92.3552	-0.1283	0.0000	0.0000;
	2178	1	4.555	1.643	0	0	1	1.0905695	-6.7155546	110	4	1.12	0.95	94.3089	0.0191	0.0000	0.0000;
	2179	1	2.235	0.906	0	0	1	1.0924659	-7.0381098	110	4	1.12	0.95	94.1898	0.0086	0.0000	0.0000;
	2180	1	5.323	3.652	0	0	1	1.1033174	-7.6333102	110	4	1.12	0.95	93.6629	0.0570	0.0000	0.0000;
	2181	1	1.46	0.943	0	0	1	1.0917726	-7.2126199	110	4	1.12	0.95	94.4775	-0.2384	0.0000	0.0000;
	2182	1	2.148	0.448	0	0	1	1.0930304	-7.2924658	110	4	1.12	0.95	94.3821	-0.3277	0.0000	0.0000;
	2183	1	2.92	-1.971	0	0	1	1.0937822	-8.0753773	110	4	1.12	0.95	95.2036	-0.3123	0.0000	0.0000;
	2184	1	4.035	4.339	0	0	1	1.1013926	-8.3810489	110	4	1.12	0.95	94.3013	-0.1510	0.0000	0.0000;
	2185	1	1.803	0.576	0	0	1	1.1017673	-8.1054651	110	4	1.12	0.95	94.0740	-0.0932	0.0000	0.0000;
	2186	1	6.009	5.187	0	0	1	1.0975371	-8.2887544	110	4	1.12	0.95	94.4088	0.0182	0.0000	0.0000;
	2187	1	4.206	1.585	0	0	1	1.1016954	-8.3772773	110	4	1.12	0.95	94.2989	-0.1670	0.0000	0.0000;
	2188	1	3.009	1.943	0	0	1	1.1166132	-4.9688657	110	4	1.12	0.95	91.4869	-0.3632	0.0000	0.0000;
	2189	1	4.464	2.42	0	0	1	1.097025	-7.8547806	110	4	1.12	0.95	94.1567	0.1410	0.0000	0.0000;
	2190	1	1.408	-0.602	0	0	1	1.1109352	-6.0548364	110	4	1.12	0.95	92.3771	-0.9144	0.0000	0.0000;
	2191	1	3.955	2.391	0	0	1	1.0767403	-8.9122392	110	4	1.12	0.95	96.9337	0.2891	0.0000	0.0000;
	2192	1	1.289	-0.448	0	0	1	1.0912995	-6.9483313	110	4	1.12	0.95	94.4218	0.0192	0.0000	0.0000;
	2193	1	2.217	-0.726	0	0	1	1.1007403	-7.2416705	110	4	1.12	0.95	94.2033	-0.8247	0.0000	0.0000;
	2194	1	4.04	-1.832	0	0	1	1.1086972	-8.5593815	110	4	1.12	0.95	94.4260	-0.9475	0.0000	0.0000;
	2195	1	4.666	-5.11	0	0	1	1.1009081	-7.3548801	110	4	1.12	0.95	94.3246	-0.8873	0.0000	0.0000;
	2196	1	5.159	3.564	0	0	1	1.1154903	-4.2925838	110	4	1.12	0.95	92.0406	0.0547	0.0000	0.0000;
	2197	1	2.492	-0.57	0	0	1	1.0944208	-7.6020367	110	4	1.12	0.95	94.6404	-0.1926	0.0000	0.0000;
	2198	1	0	0	0	0	1	1.1145677	-4.0194063	110	4	1.12	0.95	91.3197	-0.5604	0.0000	0.0000;
	2199	1	3.438	0.878	0	0	1	1.1145587	-4.0206833	110	4	1.12	0.95	91.3201	-0.5603	0.0000	0.0000;
	2200	1	1.03	-1.141	0	0	1	1.0990025	-9.098313	110	4	1.12	0.95	94.9625	-0.2909	0.0000	0.0000;
	2201	1	3.695	1.479	0	0	1	1.112363	-3.9574858	110	4	1.12	0.95	91.3143	-0.2493	0.0000	0.0000;
	2202	1	5.07	1.261	0	0	1	1.109934	-4.9685969	110	4	1.12	0.95	91.8809	-0.2399	0.0000	0.0000;
	2203	2	1.884	-0.981	0	0	1	1.0849793	-11.795464	110	4	1.12	0.95	97.1973	-0.2951	0.0000	0.0000;
	2204	2	9.285	2.525	0	0	1	1.0978993	-2.3513315	110	4	1.12	0.95	92.2480	-0.1536	0.0000	0.0000;
	2205	1	7.73	2.223	0	0	1	1.1089563	-4.5187615	110	4	1.12	0.95	91.8067	-0.2556	0.0000	0.0000;
	2206	1	2.491	-1.116	0	0	1	1.1066204	-8.7880431	110	4	1.12	0.95	94.7269	-0.7527	0.0000	0.0000;
	2207	1	2.407	0.839	0	0	1	1.1114574	-4.9287934	110	4	1.12	0.95	91.7400	-0.2450	0.0000	0.0000;
	2208	1	3.596	2.443	0	0	1	1.1099547	-5.031091	110	4	1.12	0.95	91.9259	-0.2020	0.0000	0.0000;
	2209	2	10.969	-2.674	0	0	1	1.1110902	-4.9998841	110	4	1.12	0.95	91.8372	-0.2581	0.0000	0.0000;
	2210	1	0	0	0	0	1	1.1117044	-4.9091723	110	4	1.12	0.95	91.7185	-0.2507	0.0000	0.0000;
	2211	1	0	0	0	0	1	1.1115894	-4.9227684	110	4	1.12	0.95	91.7262	-0.2496	0.0000	0.0000;
	2212	1	7.825	2.514	0	0	1	1.1055964	-5.4582577	110	4	1.12	0.95	92.4137	-0.1981	0.0000	0.0000;
	2213	1	0	0	0	0	1	1.1140175	-3.7807688	110	4	1.12	0.95	91.0873	-0.2663	0.0000	0.0000;
	2214	1	0	0	0	0	1	1.1128732	-4.0750121	110	4	1.12	0.95	91.2463	-0.2712	0.0000	0.0000;
	2215	2	2.053	1.959	0	0	1	1.12	-0.75283062	110	4	1.12	0.95	90.3857	0.0000	211.7114	0.0000;
	2216	2	1.991	2.727	0	0	1	1.1199877	-4.0531656	110	4	1.12	0.95	89.2200	0.0000	0.0000	0.0000;
	2217	1	0.515	-2.621	0	0	1	1.1046912	-4.5825033	110	4	1.12	0.95	92.1635	-0.1225	0.0000	0.0000;
	2218	1	1.422	0.138	0	0	1	1.104723	-4.580251	110	4	1.12	0.95	92.1642	-0.1232	0.0000	0.0000;
	2219	1	1.203	0.085	0	0	1	1.1170506	-3.2982118	110	4	1.12	0.95	90.6880	-0.3363	0.0000	0.0000;
	2220	1	3.27	0.822	0	0	1	1.1166881	-3.3099603	110	4	1.12	0.95	90.7102	-0.3176	0.0000	0.0000;
	2221	1	4.039	2.703	0	0	1	1.1137571	-4.6328609	110	4	1.12	0.95	92.3451	0.0701	0.0000	0.0000;
	2222	1	2.15	0.315	0	0	1	1.1149423	-3.7156317	110	4	1.12	0.95	91.0344	-0.4066	0.0000	0.0000;
	2223	1	2.581	0.1	0	0	1	1.1149397	-3.716611	110	4	1.12	0.95	91.0347	-0.4066	0.0000	0.0000;
	2224	1	2.748	-0.9	0	0	1	1.095317	-6.7518316	110	4	1.12	0.95	93.8309	0.1168	0.0000	0.0000;
	2225	1	0.772	0.521	0	0	1	1.1123541	-3.2935155	110	4	1.12	0.95	90.5741	-0.0297	0.0000	0.0000;
	2226	1	2.657	0.519	0	0	1	1.1123634	-3.2989404	110	4	1.12	0.95	90.5753	-0.0302	0.0000	0.0000;
	2227	1	1.717	0.938	0	0	1	1.1013243	-8.4253809	110	4	1.12	0.95	94.3459	-0.1620	0.0000	0.0000;
	2228	1	4.126	2.654	0	0	1	1.1003122	-8.6509064	110	4	1.12	0.95	94.5996	-0.2021	0.0000	0.0000;
	2229	2	6.436	1.383	0	0	1	1.0861307	-11.628778	110	4	1.12	0.95	96.8033	-0.2999	0.0000	0.0000;
	2230	1	3.18	0.443	0	0	1	1.115032	-3.7072404	110	4	1.12	0.95	91.0027	-0.3998	0.0000	0.0000;
	2231	1	0	0.138	0	0	1	1.115031	-3.7072352	110	4	1.12	0.95	91.0027	-0.3997	0.0000	0.0000;
	2232	1	5.667	-0.272	0	0	1	1.0868355	-11.580221	110	4	1.12	0.95	96.7231	-0.3185	0.0000	0.0000;
	2233	1	6.438	1.532	0	0	1	1.101841	-8.3889562	110	4	1.12	0.95	94.3097	-0.1846	0.0000	0.0000;
	2234	1	0	0	0	0	1	1.0868701	-11.425833	110	4	1.12	0.95	96.6136	-0.3369	0.0000	0.0000;
	2235	1	0	0	0	0	1	1.0894763	-11.344444	110	4	1.12	0.95	96.4569	-0.3531	0.0000	0.0000;
	2236	2	18.973	15.507	0	0	1	1.0610254	-6.7190484	110	4	1.12	0.95	94.3481	0.1164	0.0000	0.0000;
	2237	1	12.421	8.764	0	0	1	1.0176478	-6.8507021	110	4	1.12	0.95	94.3587	0.0841	0.0000	0.0000;
	2238	1	0	0	0	0	1	1.1008582	-8.4923163	110	4	1.12	0.95	94.5615	-0.2667	0.0000	0.0000;
	2239	1	0	0	0	0	1	1.1050777	-8.4484998	110	4	1.12	0.95	94.3662	-0.3848	0.0000	0.0000;
	2240	1	6.884	-0.464	0	0	1	1.0990951	-5.5619773	110	4	1.12	0.95	92.8021	-0.0951	0.0000	0.0000;
	2241	1	1.68	0.23	0	0	1	1.0986149	-6.3123917	110	4	1.12	0.95	93.0883	-0.0718	0.0000	0.0000;
	2242	1	2.681	-1.881	0	0	1	1.1094206	-6.093421	110	4	1.12	0.95	92.6023	-0.9829	0.0000	0.0000;
	2243	1	10.301	0	0	0	1	1.0983479	-6.353783	110	4	1.12	0.95	93.1276	-0.0749	0.0000	0.0000;
	2244	1	0.945	-0.842	0	0	1	1.1035181	-6.7066251	110	4	1.12	0.95	93.4590	-0.4921	0.0000	0.0000;
	2245	1	5.5	1.566	0	0	1	1.0895212	-7.0621733	110	4	1.12	0.95	94.6317	0.0725	0.0000	0.0000;
	2246	1	5.323	0.236	0	0	1	1.0886909	-6.8887034	110	4	1.12	0.95	94.7655	0.0869	0.0000	0.0000;
	2247	1	4.12	-1.747	0	0	1	1.0990757	-9.3121063	110	4	1.12	0.95	95.5553	-0.7149	0.0000	0.0000;
	2248	1	0	0	0	0	1	1.0990757	-9.3121063	110	4	1.12	0.95	95.5553	-0.7149	0.0000	0.0000;
	2249	1	1.546	0.176	0	0	1	1.117528	-1.4621932	110	4	1.12	0.95	90.0671	-0.1326	0.0000	0.0000;
	2250	1	2.232	-0.23	0	0	1	1.1007383	-8.2990849	110	4	1.12	0.95	94.0362	-0.0827	0.0000	0.0000;
	2251	1	6.01	4.67	0	0	1	1.1018197	-8.1020603	110	4	1.12	0.95	94.0690	-0.0948	0.0000	0.0000;
	2252	1	0	0	0	0	1	1.0986171	-6.312152	110	4	1.12	0.95	93.0880	-0.0718	0.0000	0.0000;
	2253	1	0	0	0	0	1	1.0991012	-5.5606546	110	4	1.12	0.95	92.8008	-0.0950	0.0000	0.0000;
	2254	2	2.318	0.346	0	0	1	1.0921509	-6.8561427	110	4	1.12	0.95	94.3465	0.0000	0.0000	0.0000;
	2255	1	3.606	3.331	0	0	1	1.0920772	-6.8674923	110	4	1.12	0.95	94.3483	0.0011	0.0000	0.0000;
	2256	1	9.787	3.823	0	0	1	1.0995964	-8.6166588	110	4	1.12	0.95	94.5558	-0.1425	0.0000	0.0000;
	2257	1	6.269	1.445	0	0	1	1.1017434	-8.3688555	110	4	1.12	0.95	94.2959	-0.1707	0.0000	0.0000;
	2258	1	2.059	0.84	0	0	1	1.1092937	-7.3555195	110	4	1.12	0.95	93.0198	-0.1165	0.0000	0.0000;
	2259	1	2.919	0.209	0	0	1	1.0990073	-8.4451243	110	4	1.12	0.95	94.5522	-0.0910	0.0000	0.0000;
	2260	1	8.927	2.912	0	0	1	1.0860797	-11.633091	110	4	1.12	0.95	96.7936	-0.2993	0.0000	0.0000;
	2261	1	3.091	0.576	0	0	1	1.1004934	-8.5265654	110	4	1.12	0.95	94.6074	-0.2604	0.0000	0.0000;
	2262	1	3.692	1.498	0	0	1	1.1029289	-8.3488739	110	4	1.12	0.95	94.2851	-0.2168	0.0000	0.0000;
	2263	1	5.328	-0.701	0	0	1	1.1042747	-4.7661058	110	4	1.12	0.95	92.1052	-0.1352	0.0000	0.0000;
	2264	1	0	0	0	0	1	1.1042425	-4.7777221	110	4	1.12	0.95	92.1069	-0.1349	0.0000	0.0000;
	2265	1	0.86	2.68	0	0	1	1.1052373	-4.4504331	110	4	1.12	0.95	91.8487	-0.1037	0.0000	0.0000;
	2266	2	6.774	3.204	0	0	1	1.1114965	-3.9258664	110	4	1.12	0.95	91.1990	-0.1863	0.0000	0.0000;
	2267	1	4.035	1.498	0	0	1	1.1057338	-7.5720197	110	4	1.12	0.95	93.4140	-0.0411	0.0000	0.0000;
	2268	1	1.203	0.165	0	0	1	1.1095372	-4.2125474	110	4	1.12	0.95	91.6383	-0.2808	0.0000	0.0000;
	2269	1	4.295	1.605	0	0	1	1.1041838	-5.4108757	110	4	1.12	0.95	92.5822	-0.0385	0.0000	0.0000;
	2270	1	2.232	1.097	0	0	1	1.1102896	-3.9288476	110	4	1.12	0.95	91.2743	-0.1789	0.0000	0.0000;
	2271	1	2.491	1.663	0	0	1	1.1073524	-4.1658881	110	4	1.12	0.95	91.4220	-0.0542	0.0000	0.0000;
	2272	1	0.601	0.271	0	0	1	1.1147222	-3.9372575	110	4	1.12	0.95	91.1734	-0.5753	0.0000	0.0000;
	2273	1	2.837	2.228	0	0	1	1.0901331	-7.0771215	110	4	1.12	0.95	94.5421	-0.1042	0.0000	0.0000;
	2274	1	3.096	1.655	0	0	1	1.0904365	-8.2034593	110	4	1.12	0.95	95.0680	0.2394	0.0000	0.0000;
	2275	1	3.176	2.27	0	0	1	1.0904169	-8.2046337	110	4	1.12	0.95	95.0684	0.2397	0.0000	0.0000;
	2276	1	1.89	0.658	0	0	1	1.1154831	-2.1837981	110	4	1.12	0.95	90.4228	-0.1686	0.0000	0.0000;
	2277	1	1.808	1.977	0	0	1	1.1107033	-4.6620409	110	4	1.12	0.95	92.5392	0.1209	0.0000	0.0000;
	2278	1	3.784	2.234	0	0	1	1.0708005	-8.5023306	110	4	1.12	0.95	97.8836	0.1864	0.0000	0.0000;
	2279	2	3.408	0	0	0	1	1.093077	-7.9562747	110	4	1.12	0.95	95.0846	-0.2154	0.0000	0.0000;
	2280	1	6.523	0.278	0	0	1	1.0968744	-9.4975856	110	4	1.12	0.95	95.1603	-0.2707	0.0000	0.0000;
	2281	1	35.196	16.873	0	0	1	1.0971004	-4.9949965	110	4	1.12	0.95	92.2960	0.2331	0.0000	0.0000;
	2282	1	1.46	-1.058	0	0	1	1.1156404	-3.7754295	110	4	1.12	0.95	91.0858	-0.4977	0.0000	0.0000;
	2283	1	2.492	0.262	0	0	1	1.0875239	-7.7063883	110	4	1.12	0.95	95.3246	-0.3152	0.0000	0.0000;
	2284	1	2.834	-0.977	0	0	1	1.0835816	-7.8845352	110	4	1.12	0.95	95.6358	-0.1540	0.0000	0.0000;
	2285	1	3.138	-0.839	0	0	1	1.1095097	-7.3445918	110	4	1.12	0.95	93.4471	-0.9632	0.0000	0.0000;
	2286	1	2.981	-0.071	0	0	1	1.1092712	-7.5139043	110	4	1.12	0.95	93.5900	-0.9664	0.0000	0.0000;
	2287	1	2.581	0.628	0	0	1	1.1136099	-3.9008863	110	4	1.12	0.95	91.1950	-0.3964	0.0000	0.0000;
	2288	1	2.059	0.272	0	0	1	1.1117431	-4.6677264	110	4	1.12	0.95	91.5438	-0.2382	0.0000	0.0000;
	2289	1	0	0	0	0	1	1.1117453	-4.6688005	110	4	1.12	0.95	91.5431	-0.2380	0.0000	0.0000;
	2290	1	1.717	-0.244	0	0	1	1.1148135	-3.8211315	110	4	1.12	0.95	91.1024	-0.4262	0.0000	0.0000;
	2291	1	0	0.069	0	0	1	1.114813	-3.8211289	110	4	1.12	0.95	91.1024	-0.4262	0.0000	0.0000;
	2292	1	0	0	0	0	1	1.0986894	-9.019094	110	4	1.12	0.95	95.0028	-0.3100	0.0000	0.0000;
	2293	1	3.52	2.826	0	0	1	1.098867	-8.3589193	110	4	1.12	0.95	94.5985	-0.1048	0.0000	0.0000;
	2294	2	7.496	-3.611	0	0	1	1.091756	-7.1432129	110	4	1.12	0.95	94.6083	-0.0760	0.0000	0.0000;
	2295	1	6.773	-3.5	0	0	1	1.0914597	-6.992342	110	4	1.12	0.95	94.4758	-0.0227	0.0000	0.0000;
	2296	2	0.859	-0.058	0	0	1	1.1170499	-3.3052916	110	4	1.12	0.95	90.6941	-0.3381	0.0000	0.0000;
	2297	2	1.808	2.019	0	0	1	1.0979728	-7.7839461	110	4	1.12	0.95	94.1965	-0.4520	0.0000	0.0000;
	2298	1	1.717	-0.141	0	0	1	1.1140884	-4.1132056	110	4	1.12	0.95	91.4431	-0.5767	0.0000	0.0000;
	2299	1	2.149	1.668	0	0	1	1.1104317	-5.3861775	110	4	1.12	0.95	92.8579	0.1610	0.0000	0.0000;
	2300	1	10.598	0.467	0	0	1	1.1029935	-6.7003247	110	4	1.12	0.95	93.2395	-0.7072	0.0000	0.0000;
	2301	1	5.586	1.831	0	0	1	1.1098939	-4.2602999	110	4	1.12	0.95	91.4232	-0.3747	0.0000	0.0000;
	2302	1	2.148	0.834	0	0	1	1.114452	-3.8062738	110	4	1.12	0.95	91.0830	-0.4019	0.0000	0.0000;
	2303	1	5.354	-0.579	0	0	1	1.1000703	-6.8815746	110	4	1.12	0.95	93.5142	-0.4403	0.0000	0.0000;
	2304	1	3.606	2.305	0	0	1	1.0985157	-7.9235129	110	4	1.12	0.95	94.3836	-0.0112	0.0000	0.0000;
	2305	1	7.216	-1.202	0	0	1	1.0973789	-9.5978096	110	4	1.12	0.95	95.5683	-0.5156	0.0000	0.0000;
	2306	1	5.161	2.299	0	0	1	1.1032928	-6.6474398	110	4	1.12	0.95	93.2177	0.0035	0.0000	0.0000;
	2307	1	9.357	3.112	0	0	1	1.0888079	-8.2919723	110	4	1.12	0.95	95.3879	0.2651	0.0000	0.0000;
	2308	1	4.464	-1.132	0	0	1	1.0986406	-9.2293866	110	4	1.12	0.95	95.5652	-0.7651	0.0000	0.0000;
	2309	1	8.584	4.291	0	0	1	1.0876431	-8.2153983	110	4	1.12	0.95	95.2814	0.4277	0.0000	0.0000;
	2310	1	6.19	0.438	0	0	1	1.1048876	-4.5553233	110	4	1.12	0.95	91.9092	-0.1056	0.0000	0.0000;
	2311	1	0.687	0.292	0	0	1	1.1095159	-4.8994865	110	4	1.12	0.95	91.8972	-0.2447	0.0000	0.0000;
	2312	1	2.148	-1.171	0	0	1	1.1016758	-5.1851321	110	4	1.12	0.95	92.4398	-0.1177	0.0000	0.0000;
	2313	1	0	0	0	0	1	1.10464	-4.6814342	110	4	1.12	0.95	92.0492	-0.1368	0.0000	0.0000;
	2314	1	6.881	3.6	0	0	1	1.1096928	-3.9899359	110	4	1.12	0.95	91.5616	-0.1952	0.0000	0.0000;
	2315	1	0	0.074	0	0	1	1.1096923	-3.9899331	110	4	1.12	0.95	91.5616	-0.1952	0.0000	0.0000;
	2316	1	2.751	0.978	0	0	1	1.0960528	-7.9180264	110	4	1.12	0.95	94.4621	-0.4730	0.0000	0.0000;
	2317	1	0.859	0.077	0	0	1	1.1157409	-1.8461364	110	4	1.12	0.95	90.4117	-0.1909	0.0000	0.0000;
	2318	1	2.663	0.417	0	0	1	1.1028242	-6.7681205	110	4	1.12	0.95	93.2196	-0.6880	0.0000	0.0000;
	2319	1	9.958	3.815	0	0	1	1.0986596	-8.0852093	110	4	1.12	0.95	94.1935	0.0182	0.0000	0.0000;
	2320	1	0	0	0	0	1	1.1150646	-3.7314757	110	4	1.12	0.95	91.0073	-0.4061	0.0000	0.0000;
	2321	1	5.162	0.177	0	0	1	1.1151897	-3.6941959	110	4	1.12	0.95	90.9503	-0.4131	0.0000	0.0000;
	2322	1	4.897	1.705	0	0	1	1.0693039	-8.8033007	110	4	1.12	0.95	98.2153	0.1754	0.0000	0.0000;
	2323	1	0	0	0	0	1	1.0938099	-8.0812109	110	4	1.12	0.95	95.2095	-0.3168	0.0000	0.0000;
	2324	1	1.976	0.594	0	0	1	1.1110897	-4.0708753	110	4	1.12	0.95	91.3304	-0.2258	0.0000	0.0000;
	2325	1	0.343	0.232	0	0	1	1.0937903	-8.0807885	110	4	1.12	0.95	95.2095	-0.3154	0.0000	0.0000;
	2326	1	4.125	0.758	0	0	1	1.0907053	-7.4674498	110	4	1.12	0.95	94.6996	-0.0686	0.0000	0.0000;
	2327	1	2.839	1.262	0	0	1	1.107282	-4.6573615	110	4	1.12	0.95	92.7710	0.1580	0.0000	0.0000;
	2328	1	2.32	0.282	0	0	1	1.107347	-5.0578641	110	4	1.12	0.95	92.1920	-0.2605	0.0000	0.0000;
	2329	2	5.493	0	0	0	1	1.0918618	-6.8305135	110	4	1.12	0.95	94.3996	0.0000	0.0000	0.0000;
	2330	1	2.476	-0.66	0	0	1	1.1015161	-7.1002552	110	4	1.12	0.95	93.8813	-0.5811	0.0000	0.0000;
	2331	1	1.63	0.972	0	0	1	1.0911743	-6.962719	110	4	1.12	0.95	94.4332	0.0252	0.0000	0.0000;
	2332	2	2.491	0.824	0	0	1	1.0786901	-8.8028992	110	4	1.12	0.95	96.8040	0.2226	0.0000	0.0000;
	2333	1	10.388	-0.182	0	0	1	1.0978965	-9.2931451	110	4	1.12	0.95	95.2651	-0.3794	0.0000	0.0000;
	2334	1	3.699	1.956	0	0	1	1.1106387	-4.4759044	110	4	1.12	0.95	91.4754	-0.2151	0.0000	0.0000;
	2335	1	5.16	2.725	0	0	1	1.115164	-2.7088626	110	4	1.12	0.95	91.1199	0.0224	0.0000	0.0000;
	2336	1	4.721	-0.886	0	0	1	1.087597	-11.196152	110	4	1.12	0.95	96.9376	-0.4744	0.0000	0.0000;
	2337	1	8.594	4.482	0	0	1	1.1157248	-0.54525741	110	4	1.12	0.95	89.6550	0.0273	0.0000	0.0000;
	2338	1	0.859	0	0	0	1	1.1160037	-0.54741922	110	4	1.12	0.95	89.6497	0.0116	0.0000	0.0000;
	2339	1	0.43	0.582	0	0	1	1.1160025	-0.52920143	110	4	1.12	0.95	89.6287	0.0184	0.0000	0.0000;
	2340	1	4.721	1.204	0	0	1	1.1160237	-0.54340627	110	4	1.12	0.95	89.6456	0.0119	0.0000	0.0000;
	2341	1	1.288	1.747	0	0	1	1.1160721	-0.52789591	110	4	1.12	0.95	89.6262	0.0153	0.0000	0.0000;
	2342	1	1.373	1.163	0	0	1	1.1155601	-0.56417506	110	4	1.12	0.95	89.6673	0.0276	0.0000	0.0000;
	2343	1	2.576	1.181	0	0	1	1.1155584	-0.56431798	110	4	1.12	0.95	89.6673	0.0276	0.0000	0.0000;
	2344	2	16.416	23.05	0	0	1	1.1164694	-0.51361312	110	4	1.12	0.95	89.6024	0.0000	0.0000	0.0000;
	2345	1	3.006	3.342	0	0	1	1.1164037	-0.51772812	110	4	1.12	0.95	89.6038	0.0009	0.0000	0.0000;
	2346	1	9.197	4.467	0	0	1	1.0911882	-6.941151	110	4	1.12	0.95	94.4207	0.0252	0.0000	0.0000;
	2347	1	2.662	1.458	0	0	1	1.1087877	-4.7745464	110	4	1.12	0.95	91.8997	-0.2382	0.0000	0.0000;
	2348	1	1.305	0.422	0	0	1	1.1146186	-3.7538786	110	4	1.12	0.95	91.0567	-0.3951	0.0000	0.0000;
	2349	1	4.807	0.835	0	0	1	1.1146089	-3.755679	110	4	1.12	0.95	91.0573	-0.3950	0.0000	0.0000;
	2350	1	6.267	1.139	0	0	1	1.0937857	-9.7930121	110	4	1.12	0.95	95.4175	-0.1677	0.0000	0.0000;
	2351	1	2.919	0.944	0	0	1	1.1174732	-4.5601976	110	4	1.12	0.95	92.1448	0.0013	0.0000	0.0000;
	2352	1	0	0	0	0	1	1.1174732	-4.5601976	110	4	1.12	0.95	92.1448	0.0013	0.0000	0.0000;
	2353	1	4.807	1.385	0	0	1	1.1019595	-8.2770772	110	4	1.12	0.95	94.2240	-0.1530	0.0000	0.0000;
	2354	1	0.515	0.169	0	0	1	1.0987258	-5.4387943	110	4	1.12	0.95	93.5374	-0.0168	0.0000	0.0000;
	2355	2	9.014	8.298	0	0	1	1.1133188	-3.1653517	110	4	1.12	0.95	90.3726	-0.0003	0.0000	0.0000;
	2356	1	3.606	2.199	0	0	1	1.1073645	-4.3221257	110	4	1.12	0.95	91.5694	-0.1310	0.0000	0.0000;
	2357	1	1.031	0.691	0	0	1	1.1153007	-3.3552901	110	4	1.12	0.95	91.4833	0.0389	0.0000	0.0000;
	2358	1	1.203	0.076	0	0	1	1.0934411	-7.3958525	110	4	1.12	0.95	94.5441	-0.1814	0.0000	0.0000;
	2359	1	0	0	0	0	1	1.1157224	-3.6819114	110	4	1.12	0.95	90.9958	-0.4540	0.0000	0.0000;
	2360	1	0	0	0	0	1	1.1157224	-3.6819114	110	4	1.12	0.95	90.9958	-0.4540	0.0000	0.0000;
	2361	2	6.758	0.22	0	0	1	1.1171373	-3.2847777	110	4	1.12	0.95	90.6613	-0.3292	0.0000	0.0000;
	2362	1	2.837	-0.171	0	0	1	1.1171593	-3.2831098	110	4	1.12	0.95	90.6596	-0.3297	0.0000	0.0000;
	2363	1	1.719	1.037	0	0	1	1.103102	-6.9297114	110	4	1.12	0.95	92.3973	0.1650	0.0000	0.0000;
	2364	1	0	0	0	0	1	1.1156624	-1.9276037	110	4	1.12	0.95	90.3776	-0.1631	0.0000	0.0000;
	2365	1	0.43	0	0	0	1	1.1156649	-1.8240384	110	4	1.12	0.95	90.3885	-0.1698	0.0000	0.0000;
	2366	1	5.666	2.08	0	0	1	1.0797061	-12.121608	110	4	1.12	0.95	97.7545	-0.2635	0.0000	0.0000;
	2367	2	3.254	0.369	0	0	1	1.1122586	-4.4872406	110	4	1.12	0.95	91.4572	-0.2627	0.0000	0.0000;
	2368	1	0.852	0.35	0	0	1	1.1122554	-4.4875533	110	4	1.12	0.95	91.4573	-0.2626	0.0000	0.0000;
	2369	1	3.095	1.396	0	0	1	1.1123043	-3.6396545	110	4	1.12	0.95	90.9838	-0.1655	0.0000	0.0000;
	2370	1	3.692	2.443	0	0	1	1.1096448	-4.2231026	110	4	1.12	0.95	91.4325	-0.1877	0.0000	0.0000;
	2371	2	3.18	1.277	0	0	1	1.1054988	-4.4346096	110	4	1.12	0.95	91.7443	-0.0879	0.0000	0.0000;
	2372	1	2.608	0.945	0	0	1	1.1055234	-4.4340016	110	4	1.12	0.95	91.7436	-0.0882	0.0000	0.0000;
	2373	1	6.009	-0.811	0	0	1	1.0963991	-9.7198519	110	4	1.12	0.95	95.7823	-0.6392	0.0000	0.0000;
	2374	1	3.949	1.927	0	0	1	1.1048596	-4.4730683	110	4	1.12	0.95	91.7861	-0.0690	0.0000	0.0000;
	2375	1	3.693	2.332	0	0	1	1.1119252	-3.2337087	110	4	1.12	0.95	90.4549	0.0452	0.0000	0.0000;
	2376	1	2.235	1.673	0	0	1	1.1119226	-3.4023376	110	4	1.12	0.95	90.7136	-0.0691	0.0000	0.0000;
	2377	1	1.719	0.829	0	0	1	1.1074348	-4.2831464	110	4	1.12	0.95	91.4775	-0.1201	0.0000	0.0000;
	2378	1	4.982	-0.772	0	0	1	1.1037193	-2.3657954	110	4	1.12	0.95	91.7230	-0.4279	0.0000	0.0000;
	2379	1	2.491	0	0	0	1	1.1104277	-3.9207839	110	4	1.12	0.95	91.2655	-0.1830	0.0000	0.0000;
	2380	1	3.522	0.879	0	0	1	1.1075432	-4.1573949	110	4	1.12	0.95	91.4121	-0.0606	0.0000	0.0000;
	2381	1	3.52	1.457	0	0	1	1.1015203	-7.268416	110	4	1.12	0.95	93.8199	-0.2022	0.0000	0.0000;
	2382	1	7.211	0.906	0	0	1	1.0977207	-7.641107	110	4	1.12	0.95	93.9585	0.1478	0.0000	0.0000;
	2383	1	7.766	2.915	0	0	1	1.0992981	-7.0105147	110	4	1.12	0.95	93.6017	-0.5186	0.0000	0.0000;
	2384	1	1.375	-1.789	0	0	1	1.0699219	-8.764305	110	4	1.12	0.95	98.1518	0.1547	0.0000	0.0000;
	2385	1	3.778	2.406	0	0	1	1.112398	-3.6656882	110	4	1.12	0.95	91.0103	-0.1801	0.0000	0.0000;
	2386	1	4.294	1.692	0	0	1	1.1110337	-4.1203586	110	4	1.12	0.95	91.3519	-0.2243	0.0000	0.0000;
	2387	1	3.434	0.12	0	0	1	1.1058297	-4.2976718	110	4	1.12	0.95	91.6526	-0.0385	0.0000	0.0000;
	2388	1	3.434	0.484	0	0	1	1.1070593	-4.317401	110	4	1.12	0.95	91.5282	-0.1151	0.0000	0.0000;
	2389	1	3.004	-2.714	0	0	1	1.1097449	-13.710632	110	4	1.12	0.95	96.5163	-0.3192	0.0000	0.0000;
	2390	1	5.066	2.42	0	0	1	1.1062873	-4.3510364	110	4	1.12	0.95	91.6152	-0.0882	0.0000	0.0000;
	2391	1	1.803	0.369	0	0	1	1.1129034	-3.2925402	110	4	1.12	0.95	90.5026	-0.0269	0.0000	0.0000;
	2392	1	5.411	4.195	0	0	1	1.1057606	-4.3016188	110	4	1.12	0.95	91.6571	-0.0364	0.0000	0.0000;
	2393	1	4.293	0.728	0	0	1	1.1120165	-3.434083	110	4	1.12	0.95	90.7972	-0.1044	0.0000	0.0000;
	2394	1	0	0	0	0	1	1.1133225	-3.9878946	110	4	1.12	0.95	91.2681	-0.4874	0.0000	0.0000;
	2395	1	0	0	0	0	1	1.1029769	-4.6292664	110	4	1.12	0.95	92.2852	-0.0467	0.0000	0.0000;
	2396	1	0	0	0	0	1	1.1158244	-1.848587	110	4	1.12	0.95	90.4117	-0.1986	0.0000	0.0000;
	2397	1	0	0	0	0	1	1.1121543	-5.1921751	110	4	1.12	0.95	90.4773	0.1342	0.0000	0.0000;
	2398	1	0	0	0	0	1	1.1151556	-0.88135236	110	4	1.12	0.95	90.7588	0.2391	0.0000	0.0000;
	2399	1	0	0	0	0	1	1.109785	-5.0366167	110	4	1.12	0.95	91.8820	-0.1966	0.0000	0.0000;
	2400	1	0	0	0	0	1	1.0990004	-5.5926516	110	4	1.12	0.95	92.8209	-0.0955	0.0000	0.0000;
	2401	1	0	0	0	0	1	1.1009266	-5.2602293	110	4	1.12	0.95	92.4873	-0.0879	0.0000	0.0000;
	2402	1	0	0	0	0	1	1.105512	-4.5763119	110	4	1.12	0.95	92.0640	-0.1615	0.0000	0.0000;
	2403	1	0	0	0	0	1	1.0931864	-7.270218	110	4	1.12	0.95	94.2447	-0.2825	0.0000	0.0000;
	2404	1	0	0	0	0	1	1.0988371	-6.9855878	110	4	1.12	0.95	93.6092	-0.4941	0.0000	0.0000;
	2405	1	0	0	0	0	1	1.1015599	-7.2921621	110	4	1.12	0.95	93.8252	-0.1999	0.0000	0.0000;
	2406	1	0	0	0	0	1	1.1100412	-4.1368327	110	4	1.12	0.95	91.4637	-0.2281	0.0000	0.0000;
	2407	1	0	0	0	0	1	1.0934624	-7.2190894	110	4	1.12	0.95	94.3114	-0.3284	0.0000	0.0000;
	2408	1	0	0	0	0	1	1.0999944	-5.3452407	110	4	1.12	0.95	92.6253	-0.0789	0.0000	0.0000;
	2409	1	0	0	0	0	1	1.0866808	-11.585316	110	4	1.12	0.95	96.7339	-0.3156	0.0000	0.0000;
	2410	1	0	0	0	0	1	1.1016722	-5.1650253	110	4	1.12	0.95	92.4120	-0.1015	0.0000	0.0000;
	2411	1	0	0	0	0	1	1.0854734	-11.586614	110	4	1.12	0.95	96.8683	-0.3372	0.0000	0.0000;
	2412	1	0	0	0	0	1	1.0996602	-8.6341755	110	4	1.12	0.95	94.5755	-0.1534	0.0000	0.0000;
	2413	1	0	0	0	0	1	1.1046351	-4.6812886	110	4	1.12	0.95	92.0492	-0.1363	0.0000	0.0000;
	2414	1	0	0	0	0	1	1.0912593	-6.7281118	110	4	1.12	0.95	94.4131	0.0341	0.0000	0.0000;
	2415	1	0	0	0	0	1	1.1114665	-4.0904965	110	4	1.12	0.95	91.3207	-0.2359	0.0000	0.0000;
	2416	1	0	0	0	0	1	1.1126838	-4.3446875	110	4	1.12	0.95	91.3825	-0.2757	0.0000	0.0000;
	2417	1	2.581	0.396	0	0	1	1.1026703	-2.1474573	110	4	1.12	0.95	91.8092	-0.3510	0.0000	0.0000;
	2418	1	0.765	0.488	0	0	1	1.1059614	-6.2738067	110	4	1.12	0.95	92.8013	-0.7726	0.0000	0.0000;
	2419	1	3.308	-1.468	0	0	1	1.0979271	-7.615932	110	4	1.12	0.95	94.4455	-0.6746	0.0000	0.0000;
	2420	1	5.415	3.331	0	0	1	1.0858329	-7.1128908	110	4	1.12	0.95	95.1776	0.1429	0.0000	0.0000;
	2421	1	30.007	9.432	0	0	1	1.0922244	-7.9378924	110	4	1.12	0.95	94.7824	-0.5423	0.0000	0.0000;
	2422	1	3.009	0.861	0	0	1	1.1139337	-4.0279301	110	4	1.12	0.95	91.2530	-0.5624	0.0000	0.0000;
	2423	1	0	0.058	0	0	1	1.1139333	-4.0279279	110	4	1.12	0.95	91.2530	-0.5624	0.0000	0.0000;
	2424	1	3.437	1.207	0	0	1	1.1148638	-3.9244096	110	4	1.12	0.95	91.1551	-0.5773	0.0000	0.0000;
	2425	1	0	0.104	0	0	1	1.1148468	-3.9277022	110	4	1.12	0.95	91.1562	-0.5768	0.0000	0.0000;
	2426	1	4.934	0.87	0	0	1	1.1084148	-8.1659275	110	4	1.12	0.95	94.1284	-0.9571	0.0000	0.0000;
	2427	1	3.18	0.416	0	0	1	1.0911246	-6.7376466	110	4	1.12	0.95	94.4325	0.0364	0.0000	0.0000;
	2428	1	12.706	5.192	0	0	1	1.1034988	-7.7412186	110	4	1.12	0.95	93.6484	-0.0078	0.0000	0.0000;
	2429	1	9.619	3.508	0	0	1	1.0893274	-7.0669813	110	4	1.12	0.95	94.6493	0.0832	0.0000	0.0000;
	2430	1	2.475	-1.388	0	0	1	1.1097425	-6.1380423	110	4	1.12	0.95	92.6354	-1.0193	0.0000	0.0000;
	2431	1	5.432	-2.163	0	0	1	1.1102344	-6.2067274	110	4	1.12	0.95	92.6788	-1.0712	0.0000	0.0000;
	2432	2	1.264	0.394	0	0	1	1.110043	-6.163272	110	4	1.12	0.95	92.6431	-1.0430	0.0000	0.0000;
	2433	1	3.693	0.365	0	0	1	1.1177788	-1.3119656	110	4	1.12	0.95	89.9675	-0.1059	0.0000	0.0000;
	2434	1	2.059	2.42	0	0	1	1.1097531	-5.2770918	110	4	1.12	0.95	92.0806	-0.1669	0.0000	0.0000;
	2435	1	1.717	-0.008	0	0	1	1.0990421	-8.7048049	110	4	1.12	0.95	94.9855	-0.6496	0.0000	0.0000;
	2436	1	4.898	3.461	0	0	1	1.1152683	-2.5975533	110	4	1.12	0.95	91.0527	0.0085	0.0000	0.0000;
	2437	1	4.643	2.004	0	0	1	1.084692	-11.700424	110	4	1.12	0.95	97.1182	-0.2564	0.0000	0.0000;
	2438	1	3.006	0.177	0	0	1	1.1114348	-4.0585049	110	4	1.12	0.95	91.4898	-0.2628	0.0000	0.0000;
	2439	2	5.319	-0.576	0	0	1	1.0889985	-10.782272	110	4	1.12	0.95	96.9009	-0.5502	0.0000	0.0000;
	2440	1	1.546	0.143	0	0	1	1.1032543	-6.0973979	110	4	1.12	0.95	92.8816	-0.1931	0.0000	0.0000;
	2441	1	3.094	1.445	0	0	1	1.1142791	-3.7631753	110	4	1.12	0.95	91.0777	-0.3985	0.0000	0.0000;
	2442	1	0	0	0	0	1	1.1142791	-3.7631753	110	4	1.12	0.95	91.0777	-0.3985	0.0000	0.0000;
	2443	1	2.663	0.358	0	0	1	1.1041504	-4.6545948	110	4	1.12	0.95	92.2521	-0.1219	0.0000	0.0000;
	2444	1	0	0	0	0	1	1.1049212	-4.5849584	110	4	1.12	0.95	92.1642	-0.1384	0.0000	0.0000;
	2445	1	0	0	0	0	1	1.1057085	-6.0568201	110	4	1.12	0.95	92.7749	-0.3059	0.0000	0.0000;
	2446	1	0	0	0	0	1	1.1005899	-6.4257329	110	4	1.12	0.95	93.1462	-0.2618	0.0000	0.0000;
	2447	1	1.46	0.702	0	0	1	1.1081407	-4.2990258	110	4	1.12	0.95	91.5095	-0.2318	0.0000	0.0000;
	2448	1	0.43	0.23	0	0	1	1.0922536	-6.9137763	110	4	1.12	0.95	94.3176	-0.0054	0.0000	0.0000;
	2449	2	8.9	2	0	0	1	1.0732686	-17.838735	110	5	1.12	0.95	98.3991	0.0563	0.0000	0.0000;
	2450	1	4	0.8	0	0	1	1.0609959	-16.636608	110	5	1.12	0.95	99.2133	-0.1293	0.0000	0.0000;
	2451	1	7	2	0	0	1	1.1056667	-13.054754	110	5	1.12	0.95	95.8983	0.0769	0.0000	0.0000;
	2452	2	6	3.5	0	0	1	1.1071102	-12.920086	110	5	1.12	0.95	95.6803	0.0541	0.0000	0.0000;
	2453	1	4	1.5	0	0	1	1.0630439	-16.197553	110	5	1.12	0.95	98.6522	-0.0487	0.0000	0.0000;
	2454	2	5	1.5	0	0	1	1.0984722	-16.152437	110	5	1.12	0.95	97.4003	-0.0215	0.0000	0.0000;
	2455	1	0	0	0	0	1	1.0984653	-16.154585	110	5	1.12	0.95	97.4010	-0.0215	0.0000	0.0000;
	2456	1	4	1	0	0	1	1.1064331	-12.978164	110	5	1.12	0.95	95.7561	0.0691	0.0000	0.0000;
	2457	1	6.1	1.4	0	0	1	1.0742929	-14.737321	110	5	1.12	0.95	98.2971	0.2167	0.0000	0.0000;
	2458	1	3.4	1.6	0	0	1	1.0777418	-18.045567	110	5	1.12	0.95	98.8375	0.0954	0.0000	0.0000;
	2459	1	7	2	0	0	1	1.1063778	-13.015779	110	5	1.12	0.95	95.8179	0.0563	0.0000	0.0000;
	2460	2	3.5	0.8	0	0	1	1.0591943	-17.898374	110	5	1.12	0.95	99.8612	0.4512	0.0000	0.0000;
	2461	1	2	1	0	0	1	1.0658785	-15.850006	110	5	1.12	0.95	98.2132	-0.0148	0.0000	0.0000;
	2462	1	4	1.3	0	0	1	1.0757874	-14.787022	110	5	1.12	0.95	98.2221	0.1356	0.0000	0.0000;
	2463	1	1.9	0.7	0	0	1	1.0836416	-15.239996	110	5	1.12	0.95	99.4774	0.1267	0.0000	0.0000;
	2464	1	6	2	0	0	1	1.1053885	-13.067987	110	5	1.12	0.95	95.8842	0.0906	0.0000	0.0000;
	2465	1	5.5	1.5	0	0	1	1.1067112	-12.983803	110	5	1.12	0.95	95.7673	0.0509	0.0000	0.0000;
	2466	1	0	0	0	0	1	1.1077884	-12.897206	110	5	1.12	0.95	95.7761	0.0122	0.0000	0.0000;
	2467	1	0	0	0	0	1	1.1077841	-12.891197	110	5	1.12	0.95	95.7741	0.0124	0.0000	0.0000;
	2468	2	3.5	1	0	0	1	1.0957775	-16.728555	110	5	1.12	0.95	98.1503	-0.2134	0.0000	0.0000;
	2469	1	1.8	0.8	0	0	1	1.0665408	-18.029921	110	5	1.12	0.95	99.2706	0.2384	0.0000	0.0000;
	2470	1	3.7	1.4	0	0	1	1.0842473	-15.127345	110	5	1.12	0.95	99.3566	0.1293	0.0000	0.0000;
	2471	2	5.4	0.9	0	0	1	1.0710351	-18.277497	110	5	1.12	0.95	98.8424	0.1767	0.0000	0.0000;
	2472	1	2.9	0.6	0	0	1	1.0709929	-18.285624	110	5	1.12	0.95	98.8469	0.1786	0.0000	0.0000;
	2473	1	8.5	2.2	0	0	1	1.0900993	-13.161822	110	5	1.12	0.95	97.2888	0.0951	0.0000	0.0000;
	2474	1	10.2	3.2	0	0	1	1.0904779	-12.24963	110	5	1.12	0.95	96.9456	0.1748	0.0000	0.0000;
	2475	1	4	1.5	0	0	1	1.0848695	-15.085366	110	5	1.12	0.95	99.2593	0.1266	0.0000	0.0000;
	2476	1	3.6	0.9	0	0	1	1.0898867	-14.544916	110	5	1.12	0.95	97.1881	0.2541	0.0000	0.0000;
	2477	1	3.5	2	0	0	1	1.0516891	-19.947742	110	5	1.12	0.95	101.2565	0.5127	0.0000	0.0000;
	2478	1	3.2	0.7	0	0	1	1.0527456	-19.889011	110	5	1.12	0.95	101.1770	0.4723	0.0000	0.0000;
	2479	1	6	1	0	0	1	1.0815193	-15.398518	110	5	1.12	0.95	99.8871	0.1157	0.0000	0.0000;
	2480	1	4.9	0.6	0	0	1	1.0721073	-17.944245	110	5	1.12	0.95	98.5216	0.0933	0.0000	0.0000;
	2481	1	2.8	0.5	0	0	1	1.0714151	-20.501266	110	5	1.12	0.95	102.9643	-0.2263	0.0000	0.0000;
	2482	2	1.5	0.2	0	0	1	1.0812705	-15.519386	110	5	1.12	0.95	100.0101	0.0923	0.0000	0.0000;
	2483	2	2	0.5	0	0	1	1.0843781	-17.527092	110	5	1.12	0.95	98.7287	0.0427	0.0000	0.0000;
	2484	2	0.3	0.1	0	0	1	1.095505	-16.70425	110	5	1.12	0.95	97.9569	-0.1522	0.0000	0.0000;
	2485	1	2.8	0.5	0	0	1	1.0657718	-16.297782	110	5	1.12	0.95	98.4365	0.0895	0.0000	0.0000;
	2486	2	2.2	0	0	0	1	1.0712443	-20.544236	110	5	1.12	0.95	103.0401	-0.2506	0.0000	0.0000;
	2487	1	0.3	0.2	0	0	1	1.0913999	-12.642064	110	5	1.12	0.95	96.9493	0.1044	0.0000	0.0000;
	2488	1	4.1	2.4	0	0	1	1.0954318	-10.497415	110	5	1.12	0.95	95.6193	0.2014	0.0000	0.0000;
	2489	2	1.5	1.5	0	0	1	1.0992606	-15.945358	110	5	1.12	0.95	97.1051	0.0167	0.0000	0.0000;
	2490	1	0	0	0	0	1	1.1010027	-15.658236	110	5	1.12	0.95	96.8226	0.0250	0.0000	0.0000;
	2491	1	0	0	0	0	1	1.1009726	-15.668737	110	5	1.12	0.95	96.8256	0.0253	0.0000	0.0000;
	2492	2	10	4.8	0	0	1	1.0579148	-18.152422	110	5	1.12	0.95	100.1642	0.5492	0.0000	0.0000;
	2493	1	9.2	3	0	0	1	1.0578675	-18.154117	110	5	1.12	0.95	100.1682	0.5471	0.0000	0.0000;
	2494	1	5.1	0.4	0	0	1	1.0573327	-18.174434	110	5	1.12	0.95	100.2307	0.5094	0.0000	0.0000;
	2495	1	3.4	0.3	0	0	1	1.0570871	-18.170413	110	5	1.12	0.95	100.2505	0.5984	0.0000	0.0000;
	2496	1	13	5	0	0	1	1.1059252	-13.034381	110	5	1.12	0.95	95.7808	0.0783	0.0000	0.0000;
	2497	1	0	0	0	0	1	1.1074903	-12.926179	110	5	1.12	0.95	95.6660	0.0341	0.0000	0.0000;
	2498	1	0.8	0.1	0	0	1	1.0957178	-16.735189	110	5	1.12	0.95	98.0804	-0.1999	0.0000	0.0000;
	2499	1	0	0	0	0	1	1.0723421	-17.962506	110	5	1.12	0.95	98.5269	0.0519	0.0000	0.0000;
	2500	1	0	0	0	0	1	1.0740162	-17.769515	110	5	1.12	0.95	98.3369	0.0289	0.0000	0.0000;
	2501	2	5.4	1	0	0	1	1.0730973	-17.843815	110	5	1.12	0.95	98.3813	0.0700	0.0000	0.0000;
	2502	1	5.2	0.9	0	0	1	1.0711716	-18.021662	110	5	1.12	0.95	98.6218	0.0976	0.0000	0.0000;
	2503	1	0	0	0	0	1	1.072623	-17.880018	110	5	1.12	0.95	98.4048	0.1212	0.0000	0.0000;
	2504	1	0	0	0	0	1	1.0722871	-17.836283	110	5	1.12	0.95	98.3870	0.1114	0.0000	0.0000;
	2505	1	6.8	1.8	0	0	1	1.0726152	-17.864231	110	5	1.12	0.95	98.4744	0.0755	0.0000	0.0000;
	2506	1	4	0.9	0	0	1	1.0685502	-18.399548	110	5	1.12	0.95	99.0817	0.2514	0.0000	0.0000;
	2507	1	3.6	0.8	0	0	1	1.0685668	-18.396776	110	5	1.12	0.95	99.0824	0.2520	0.0000	0.0000;
	2508	1	3	0.3	0	0	1	1.0655836	-16.234406	110	5	1.12	0.95	98.6771	0.1229	0.0000	0.0000;
	2509	1	5.7	1	0	0	1	1.0912787	-14.654689	110	5	1.12	0.95	97.1256	0.0588	0.0000	0.0000;
	2510	2	5.5	2.2	0	0	1	1.0813641	-4.9622842	110	5	1.12	0.95	93.7160	1.1100	0.0000	0.0000;
	2511	1	3.4	1.7	0	0	1	1.0860868	-13.123603	110	5	1.12	0.95	97.2008	0.2513	0.0000	0.0000;
	2512	1	2.5	0.5	0	0	1	1.0961756	-16.400804	110	5	1.12	0.95	97.7543	0.0047	0.0000	0.0000;
	2513	1	7	1.9	0	0	1	1.068321	-18.401601	110	5	1.12	0.95	99.0990	0.2524	0.0000	0.0000;
	2514	1	6	2.9	0	0	1	1.0684002	-18.408177	110	5	1.12	0.95	99.0935	0.2568	0.0000	0.0000;
	2515	1	0	0	0	0	1	1.092335	-12.998935	110	5	1.12	0.95	97.0466	0.0477	0.0000	0.0000;
	2516	1	0.3	0.2	0	0	1	1.0923548	-12.995952	110	5	1.12	0.95	97.0449	0.0493	0.0000	0.0000;
	2517	1	1	0.4	0	0	1	1.0627246	-16.55885	110	5	1.12	0.95	98.9991	-0.1185	0.0000	0.0000;
	2518	1	0.3	0.1	0	0	1	1.072479	-17.952606	110	5	1.12	0.95	98.5084	0.0551	0.0000	0.0000;
	2519	1	4.9	1.4	0	0	1	1.0911963	-14.664926	110	5	1.12	0.95	97.1361	0.0609	0.0000	0.0000;
	2520	1	0	0	0	0	1	1.0934513	-14.425425	110	5	1.12	0.95	96.8441	0.0097	0.0000	0.0000;
	2521	1	0	0	0	0	1	1.0937004	-14.408494	110	5	1.12	0.95	96.8366	0.0081	0.0000	0.0000;
	2522	1	0	0	0	0	1	1.0935586	-14.400764	110	5	1.12	0.95	96.8429	0.0097	0.0000	0.0000;
	2523	1	1.8	0.2	0	0	1	1.0813967	-15.475418	110	5	1.12	0.95	99.9646	0.0991	0.0000	0.0000;
	2524	1	3	0.5	0	0	1	1.1007695	-16.508666	110	5	1.12	0.95	97.8277	-0.3310	0.0000	0.0000;
	2525	1	7	2	0	0	1	1.0664952	-16.21305	110	5	1.12	0.95	99.1989	0.4093	0.0000	0.0000;
	2526	1	4.2	1.5	0	0	1	1.0827146	-14.716872	110	5	1.12	0.95	97.7294	0.0879	0.0000	0.0000;
	2527	2	8	2.5	0	0	1	1.1064085	-13.018141	110	5	1.12	0.95	95.8365	0.0524	0.0000	0.0000;
	2528	1	4	1	0	0	1	1.1074238	-12.932072	110	5	1.12	0.95	95.6663	0.0350	0.0000	0.0000;
	2529	1	7.5	1.5	0	0	1	1.1074705	-12.925875	110	5	1.12	0.95	95.6660	0.0351	0.0000	0.0000;
	2530	2	29	20	0	0	1	1.0870769	-4.37728	110	5	1.12	0.95	93.0232	0.9912	0.0000	0.0000;
	2531	1	3	1	0	0	1	1.0654989	-15.925947	110	5	1.12	0.95	98.3528	0.0219	0.0000	0.0000;
	2532	1	3.5	0.5	0	0	1	1.0970487	-16.303815	110	5	1.12	0.95	97.6378	-0.0144	0.0000	0.0000;
	2533	1	3.2	1	0	0	1	1.0918668	-12.203188	110	5	1.12	0.95	96.7216	0.1229	0.0000	0.0000;
	2534	1	0.7	0.2	0	0	1	1.0786396	-5.2152258	110	5	1.12	0.95	94.2387	1.0862	0.0000	0.0000;
	2535	1	1	0.4	0	0	1	1.0786417	-5.214949	110	5	1.12	0.95	94.2386	1.0861	0.0000	0.0000;
	2536	1	9.1	1	0	0	1	1.0562161	-19.318319	110	5	1.12	0.95	100.9726	0.3585	0.0000	0.0000;
	2537	1	0	0	0	0	1	1.1020954	-13.490923	110	5	1.12	0.95	96.5475	0.0520	0.0000	0.0000;
	2538	1	5.9	2.1	0	0	1	1.0636226	-18.567945	110	5	1.12	0.95	99.7158	0.2821	0.0000	0.0000;
	2539	1	5.3	0.4	0	0	1	1.070006	-18.137187	110	5	1.12	0.95	98.7665	0.1768	0.0000	0.0000;
	2540	1	5	0	0	0	1	1.0958678	-16.440989	110	5	1.12	0.95	97.7596	0.0285	0.0000	0.0000;
	2541	1	6.4	0.8	0	0	1	1.0688314	-18.407718	110	5	1.12	0.95	99.0647	0.2397	0.0000	0.0000;
	2542	1	1.9	0.8	0	0	1	1.0720317	-17.906794	110	5	1.12	0.95	98.5037	0.0928	0.0000	0.0000;
	2543	1	4	1.5	0	0	1	1.0960946	-16.407075	110	5	1.12	0.95	97.7172	0.0292	0.0000	0.0000;
	2544	1	4.5	1.8	0	0	1	1.100988	-13.60067	110	5	1.12	0.95	96.7216	0.0597	0.0000	0.0000;
	2545	1	5	1.5	0	0	1	1.0985943	-15.908393	110	5	1.12	0.95	97.0805	0.0757	0.0000	0.0000;
	2546	1	3.9	1.2	0	0	1	1.1007222	-13.5772	110	5	1.12	0.95	96.4512	0.1246	0.0000	0.0000;
	2547	2	5.5	4	0	0	1	1.0991414	-15.811359	110	5	1.12	0.95	96.9801	0.0766	0.0000	0.0000;
	2548	2	7.5	2	0	0	1	1.09877	-15.890103	110	5	1.12	0.95	97.0621	0.0719	0.0000	0.0000;
	2549	1	3.4	1.2	0	0	1	1.0872137	-4.2119054	110	5	1.12	0.95	93.0659	0.9803	0.0000	0.0000;
	2550	1	2	0.8	0	0	1	1.0596575	-16.590225	110	5	1.12	0.95	99.2304	-0.1644	0.0000	0.0000;
	2551	1	4	1	0	0	1	1.0854041	-4.4094678	110	5	1.12	0.95	93.2485	1.0325	0.0000	0.0000;
	2552	1	7	1	0	0	1	1.059176	-16.499482	110	5	1.12	0.95	99.1712	-0.1735	0.0000	0.0000;
	2553	1	4.2	0.8	0	0	1	1.0596917	-18.32382	110	5	1.12	0.95	100.1482	0.4125	0.0000	0.0000;
	2554	1	6	1	0	0	1	1.1071378	-12.934015	110	5	1.12	0.95	95.6894	0.0488	0.0000	0.0000;
	2555	2	124.7	73.3	0	0	1	1.0509397	-17.21362	110	5	1.12	0.95	100.2019	1.3811	0.0000	0.0000;
	2556	1	2.8	1.3	0	0	1	1.0889412	-13.395034	110	5	1.12	0.95	97.2719	0.1243	0.0000	0.0000;
	2557	1	3.9	0.8	0	0	1	1.0514298	-17.218686	110	5	1.12	0.95	100.2132	1.3302	0.0000	0.0000;
	2558	1	4.5	1.5	0	0	1	1.0982302	-15.960491	110	5	1.12	0.95	97.1237	0.0811	0.0000	0.0000;
	2559	1	1.9	0.7	0	0	1	1.0846164	-15.036685	110	5	1.12	0.95	97.6411	0.1424	0.0000	0.0000;
	2560	1	4.8	0.8	0	0	1	1.0977241	-8.928284	110	5	1.12	0.95	94.9501	0.2266	0.0000	0.0000;
	2561	1	0	0	0	0	1	1.091332	-13.126953	110	5	1.12	0.95	97.1183	0.0676	0.0000	0.0000;
	2562	1	5.1	3.4	0	0	1	1.0999161	-8.5458992	110	5	1.12	0.95	94.4630	0.0944	0.0000	0.0000;
	2563	1	6.5	2	0	0	1	1.0654349	-16.281943	110	5	1.12	0.95	99.2838	0.3981	0.0000	0.0000;
	2564	2	6	1	0	0	1	1.0785155	-18.002334	110	5	1.12	0.95	99.0897	0.1225	0.0000	0.0000;
	2565	1	4	0.5	0	0	1	1.0782534	-18.048125	110	5	1.12	0.95	99.0940	0.1139	0.0000	0.0000;
	2566	1	0.2	0	0	0	1	1.0730455	-17.086657	110	5	1.12	0.95	98.6763	0.2655	0.0000	0.0000;
	2567	1	7.5	3.6	0	0	1	1.087468	-12.061983	110	5	1.12	0.95	96.5714	0.3093	0.0000	0.0000;
	2568	1	3.3	0.1	0	0	1	1.0721429	-17.972736	110	5	1.12	0.95	98.5445	0.0599	0.0000	0.0000;
	2569	2	4	0.7	0	0	1	1.0630591	-16.528493	110	5	1.12	0.95	98.9412	-0.1208	0.0000	0.0000;
	2570	1	1.8	0.9	0	0	1	1.0884902	-13.885445	110	5	1.12	0.95	97.2686	0.1108	0.0000	0.0000;
	2571	1	5.7	3	0	0	1	1.0757645	-16.557982	110	5	1.12	0.95	98.4568	0.2852	0.0000	0.0000;
	2572	2	19	15	0	0	1	1.08371	-4.6603223	110	5	1.12	0.95	93.3838	1.0805	0.0000	0.0000;
	2573	1	4.5	0.6	0	0	1	1.0527197	-18.00905	110	5	1.12	0.95	100.5431	0.9563	0.0000	0.0000;
	2574	2	4	1	0	0	1	1.0984748	-16.410762	110	5	1.12	0.95	97.8360	-0.2077	0.0000	0.0000;
	2575	1	5.5	0.7	0	0	1	1.0548559	-17.115023	110	5	1.12	0.95	100.1160	1.0593	0.0000	0.0000;
	2576	1	6.3	2.4	0	0	1	1.0698628	-17.818987	110	5	1.12	0.95	98.8518	0.2185	0.0000	0.0000;
	2577	1	2	1	0	0	1	1.0582255	-17.644063	110	5	1.12	0.95	99.8592	0.3265	0.0000	0.0000;
	2578	1	0.7	0.2	0	0	1	1.0916687	-14.621604	110	5	1.12	0.95	97.0812	0.0493	0.0000	0.0000;
	2579	2	6.5	25	0	0	1	1.0775679	-4.8227447	110	5	1.12	0.95	92.2453	1.6056	0.0000	0.0000;
	2580	1	5	1.6	0	0	1	1.072084	-17.977405	110	5	1.12	0.95	98.5499	0.0615	0.0000	0.0000;
	2581	1	6	1	0	0	1	1.0596158	-16.59869	110	5	1.12	0.95	99.1990	-0.1362	0.0000	0.0000;
	2582	1	8	1.5	0	0	1	1.0600566	-17.177486	110	5	1.12	0.95	99.4611	0.2157	0.0000	0.0000;
	2583	2	6.7	3	0	0	1	1.0826244	-4.8144566	110	5	1.12	0.95	93.5506	1.0900	0.0000	0.0000;
	2584	1	5.8	2.2	0	0	1	1.1071064	-13.489774	110	5	1.12	0.95	96.3476	-0.1254	0.0000	0.0000;
	2585	1	4.3	0.5	0	0	1	1.0632145	-14.181405	110	5	1.12	0.95	98.0950	-0.0309	0.0000	0.0000;
	2586	1	6.7	3	0	0	1	1.0689999	-15.748461	110	5	1.12	0.95	98.7775	0.3762	0.0000	0.0000;
	2587	1	2.6	0.6	0	0	1	1.0613089	-18.192086	110	5	1.12	0.95	99.8958	0.3837	0.0000	0.0000;
	2588	1	1.5	0.6	0	0	1	1.105848	-13.075541	110	5	1.12	0.95	95.8625	0.0670	0.0000	0.0000;
	2589	1	2.8	1	0	0	1	1.0835586	-4.7550381	110	5	1.12	0.95	93.3075	1.1067	0.0000	0.0000;
	2590	2	1.2	0.3	0	0	1	1.0978649	-16.450375	110	5	1.12	0.95	97.6554	-0.1462	0.0000	0.0000;
	2591	1	3	0.6	0	0	1	1.0693682	-18.382374	110	5	1.12	0.95	99.0126	0.2236	0.0000	0.0000;
	2592	1	7.1	2.1	0	0	1	1.0709986	-18.014093	110	5	1.12	0.95	98.5822	0.1274	0.0000	0.0000;
	2593	1	0	0	0	0	1	1.0662813	-15.982221	110	5	1.12	0.95	98.3649	-0.0187	0.0000	0.0000;
	2594	1	0	0	0	0	1	1.0663136	-15.98736	110	5	1.12	0.95	98.3596	-0.0193	0.0000	0.0000;
	2595	1	6	1.2	0	0	1	1.0679269	-15.610253	110	5	1.12	0.95	97.9217	-0.0110	0.0000	0.0000;
	2596	1	3.402	0.8	0	0	1	1.0679636	-15.612982	110	5	1.12	0.95	97.9200	-0.0116	0.0000	0.0000;
	2597	1	4.7	1	0	0	1	1.0638478	-15.099105	110	5	1.12	0.95	98.3416	-0.0290	0.0000	0.0000;
	2598	1	6.7	2	0	0	1	1.0712175	-18.022857	110	5	1.12	0.95	98.6212	0.0946	0.0000	0.0000;
	2599	1	6.6	2	0	0	1	1.0652315	-15.839753	110	5	1.12	0.95	98.2796	0.0504	0.0000	0.0000;
	2600	1	4.3	1	0	0	1	1.0780544	-17.996583	110	5	1.12	0.95	98.4882	0.0415	0.0000	0.0000;
	2601	1	4	0.7	0	0	1	1.0676355	-15.638484	110	5	1.12	0.95	97.9654	-0.0045	0.0000	0.0000;
	2602	1	9	0.5	0	0	1	1.0641805	-16.386342	110	5	1.12	0.95	99.1335	0.2048	0.0000	0.0000;
	2603	1	2.3	0.6	0	0	1	1.0634474	-17.018861	110	5	1.12	0.95	98.9755	0.2226	0.0000	0.0000;
	2604	1	1	0.4	0	0	1	1.0965136	-16.629616	110	5	1.12	0.95	98.1142	-0.2177	0.0000	0.0000;
	2605	1	6	1.6	0	0	1	1.1070812	-13.106691	110	5	1.12	0.95	95.9848	-0.0131	0.0000	0.0000;
	2606	1	2.5	0.6	0	0	1	1.0652623	-15.832618	110	5	1.12	0.95	98.2931	0.0461	0.0000	0.0000;
	2607	2	5.1	1	0	0	1	1.0658489	-15.795574	110	5	1.12	0.95	98.1971	0.0349	0.0000	0.0000;
	2608	1	16	3	0	0	1	1.0655063	-15.80967	110	5	1.12	0.95	98.2780	0.0368	0.0000	0.0000;
	2609	1	3.7	1.1	0	0	1	1.0844864	-4.6936471	110	5	1.12	0.95	93.1959	1.0820	0.0000	0.0000;
	2610	1	2.5	1	0	0	1	1.0844843	-4.6843988	110	5	1.12	0.95	93.2052	1.0821	0.0000	0.0000;
	2611	1	6.6	2.6	0	0	1	1.071021	-17.996657	110	5	1.12	0.95	98.5976	0.1198	0.0000	0.0000;
	2612	1	0.1	0.1	0	0	1	1.0708317	-15.934224	110	5	1.12	0.95	98.8382	0.3462	0.0000	0.0000;
	2613	1	1.5	0.4	0	0	1	1.0979533	-16.145662	110	5	1.12	0.95	97.3008	0.0203	0.0000	0.0000;
	2614	1	6.9	3.6	0	0	1	1.098867	-2.8365906	110	5	1.12	0.95	92.0361	0.6507	0.0000	0.0000;
	2615	1	7.7	0.9	0	0	1	1.0569912	-18.048635	110	5	1.12	0.95	100.1865	0.4246	0.0000	0.0000;
	2616	1	0	0	0	0	1	1.0569918	-18.043957	110	5	1.12	0.95	100.1860	0.4232	0.0000	0.0000;
	2617	1	1.8	0.5	0	0	1	1.0706402	-17.585216	110	5	1.12	0.95	98.8470	0.2425	0.0000	0.0000;
	2618	1	2.5	0.6	0	0	1	1.0713276	-17.871614	110	5	1.12	0.95	98.6789	0.1017	0.0000	0.0000;
	2619	1	2.6	1.3	0	0	1	1.0707681	-18.030493	110	5	1.12	0.95	98.6037	0.1343	0.0000	0.0000;
	2620	1	1.3	0.3	0	0	1	1.0584325	-18.036766	110	5	1.12	0.95	100.0339	0.4989	0.0000	0.0000;
	2621	1	3	1	0	0	1	1.1006943	-16.689429	110	5	1.12	0.95	98.0033	-0.3832	0.0000	0.0000;
	2622	1	1.3	0.4	0	0	1	1.0728239	-17.890531	110	5	1.12	0.95	98.4340	0.0654	0.0000	0.0000;
	2623	1	5.1	1.3	0	0	1	1.0716829	-17.959943	110	5	1.12	0.95	98.5183	0.1084	0.0000	0.0000;
	2624	1	1.9	0.1	0	0	1	1.0903244	-12.964536	110	5	1.12	0.95	97.2319	0.1000	0.0000	0.0000;
	2625	1	2	0.5	0	0	1	1.0796111	-5.0933356	110	5	1.12	0.95	93.3659	1.2662	0.0000	0.0000;
	2626	2	1.2	0.4	0	0	1	1.0619443	-17.502658	110	5	1.12	0.95	99.3142	0.3350	0.0000	0.0000;
	2627	1	1.5	0.4	0	0	1	1.1029759	-13.62676	110	5	1.12	0.95	96.7101	-0.0434	0.0000	0.0000;
	2628	1	0.1	0.1	0	0	1	1.0785905	-13.351315	110	5	1.12	0.95	97.7725	0.3243	0.0000	0.0000;
	2629	2	5.6	1.4	0	0	1	1.0713755	-17.951642	110	5	1.12	0.95	98.5383	0.1153	0.0000	0.0000;
	2630	1	2.5	1	0	0	1	1.0881166	-14.53411	110	5	1.12	0.95	97.3020	0.4127	0.0000	0.0000;
	2631	1	3.5	1	0	0	1	1.0985501	-13.865574	110	5	1.12	0.95	96.6933	0.1313	0.0000	0.0000;
	2632	1	6.5	1.5	0	0	1	1.0836442	-4.7086225	110	5	1.12	0.95	93.3512	1.0909	0.0000	0.0000;
	2633	2	26	6.8	0	0	1	1.0722609	-17.986825	110	5	1.12	0.95	98.5501	0.0504	0.0000	0.0000;
	2634	1	0	0	0	0	1	1.0740171	-17.769529	110	5	1.12	0.95	98.3369	0.0288	0.0000	0.0000;
	2635	2	5.4	0.8	0	0	1	1.0531394	-18.070614	110	5	1.12	0.95	100.5425	0.9040	0.0000	0.0000;
	2636	1	5.5	0.7	0	0	1	1.0685384	-18.375579	110	5	1.12	0.95	99.0658	0.2413	0.0000	0.0000;
	2637	1	8	3	0	0	1	1.0714569	-18.356979	110	5	1.12	0.95	98.9205	0.1880	0.0000	0.0000;
	2638	1	2.5	0.5	0	0	1	1.0578237	-16.620759	110	5	1.12	0.95	99.4285	-0.1760	0.0000	0.0000;
	2639	1	0	0	0	0	1	1.107471	-12.925883	110	5	1.12	0.95	95.6660	0.0351	0.0000	0.0000;
	2640	1	9.1	3.3	0	0	1	1.0911035	-12.907625	110	5	1.12	0.95	97.0908	0.0927	0.0000	0.0000;
	2641	1	5.6	2.1	0	0	1	1.0709114	-18.327684	110	5	1.12	0.95	98.8931	0.1892	0.0000	0.0000;
	2642	1	1.6	0.8	0	0	1	1.0984499	-14.094997	110	5	1.12	0.95	97.3765	-0.0346	0.0000	0.0000;
	2643	1	9.5	2.8	0	0	1	1.1055167	-13.055925	110	5	1.12	0.95	95.8614	0.0891	0.0000	0.0000;
	2644	2	5	1.3	0	0	1	1.0721823	-17.845378	110	5	1.12	0.95	98.3972	0.1142	0.0000	0.0000;
	2645	1	5.4	2.7	0	0	1	1.0751756	-13.973666	110	5	1.12	0.95	98.1721	0.3267	0.0000	0.0000;
	2646	1	2.1	0.5	0	0	1	1.0924753	-14.551271	110	5	1.12	0.95	96.9660	0.0310	0.0000	0.0000;
	2647	1	24	9	0	0	1	1.0796486	-4.9970488	110	5	1.12	0.95	93.2722	1.2906	0.0000	0.0000;
	2648	1	3.8	1	0	0	1	1.1063476	-13.02164	110	5	1.12	0.95	95.7895	0.0616	0.0000	0.0000;
	2649	2	33	5.5	0	0	1	1.0768875	-19.643049	110	5	1.12	0.95	101.2204	0.1329	0.0000	0.0000;
	2650	1	12	1	0	0	1	1.0783721	-19.443354	110	5	1.12	0.95	101.0199	0.1108	0.0000	0.0000;
	2651	1	0	0	0	0	1	1.1011324	-16.694638	110	5	1.12	0.95	98.0032	-0.4010	0.0000	0.0000;
	2652	1	5.5	1.5	0	0	1	1.0958003	-16.378324	110	5	1.12	0.95	97.7369	0.0360	0.0000	0.0000;
	2653	1	3.5	1.4	0	0	1	1.0959724	-14.271963	110	5	1.12	0.95	97.6532	-0.0025	0.0000	0.0000;
	2654	2	6.6	1.5	0	0	1	1.095999	-16.489449	110	5	1.12	0.95	97.5746	0.0045	0.0000	0.0000;
	2655	1	3.5	1	0	0	1	1.0965681	-16.162486	110	5	1.12	0.95	97.4104	0.0795	0.0000	0.0000;
	2656	1	1	0	0	0	1	1.0760387	-19.901474	110	5	1.12	0.95	101.8300	-0.0876	0.0000	0.0000;
	2657	1	4.1	1.7	0	0	1	1.0527936	-19.50071	110	5	1.12	0.95	101.4104	0.4865	0.0000	0.0000;
	2658	1	1.7	0.9	0	0	1	1.0566035	-19.458561	110	5	1.12	0.95	100.8533	0.3505	0.0000	0.0000;
	2659	1	3.5	1	0	0	1	1.0961537	-16.260519	110	5	1.12	0.95	97.5074	0.0611	0.0000	0.0000;
	2660	1	4.8	0.5	0	0	1	1.0915173	-16.991702	110	5	1.12	0.95	98.1253	-0.0572	0.0000	0.0000;
	2661	1	0	0	0	0	1	1.0971446	-16.242242	110	5	1.12	0.95	97.3766	0.0321	0.0000	0.0000;
	2662	1	0	0	0	0	1	1.0971454	-16.253445	110	5	1.12	0.95	97.3780	0.0305	0.0000	0.0000;
	2663	2	4.5	1.3	0	0	1	1.0948437	-16.666672	110	5	1.12	0.95	97.8318	-0.0674	0.0000	0.0000;
	2664	1	4.5	0.6	0	0	1	1.0948701	-16.662168	110	5	1.12	0.95	97.8334	-0.0665	0.0000	0.0000;
	2665	1	3	0.6	0	0	1	1.0912714	-14.66418	110	5	1.12	0.95	97.1336	0.0589	0.0000	0.0000;
	2666	1	7.5	1.3	0	0	1	1.0706411	-18.042358	110	5	1.12	0.95	98.6188	0.1368	0.0000	0.0000;
	2667	1	0.1	0	0	0	1	1.0717449	-17.911681	110	5	1.12	0.95	98.4871	0.1105	0.0000	0.0000;
	2668	2	12.6	3.3	0	0	1	1.0571652	-19.49158	110	5	1.12	0.95	100.6888	0.3516	0.0000	0.0000;
	2669	1	4.5	1	0	0	1	1.0949471	-16.631744	110	5	1.12	0.95	97.7917	-0.0436	0.0000	0.0000;
	2670	1	0.1	1	0	0	1	1.0716492	-17.928883	110	5	1.12	0.95	98.5171	0.1056	0.0000	0.0000;
	2671	1	10	1.5	0	0	1	1.0626051	-14.901458	110	5	1.12	0.95	97.8998	0.0948	0.0000	0.0000;
	2672	1	4	1.6	0	0	1	1.0684302	-18.40614	110	5	1.12	0.95	99.0923	0.2561	0.0000	0.0000;
	2673	1	2.8	1	0	0	1	1.1032077	-2.6057652	110	5	1.12	0.95	91.6521	0.4992	0.0000	0.0000;
	2674	1	3.3	1.4	0	0	1	1.0713583	-17.40193	110	5	1.12	0.95	98.7993	0.2605	0.0000	0.0000;
	2675	1	3.4	0.3	0	0	1	1.0609189	-16.708098	110	5	1.12	0.95	99.7007	0.6968	0.0000	0.0000;
	2676	2	83	46	0	0	1	1.0879881	-14.524865	110	5	1.12	0.95	97.3068	0.4293	0.0000	0.0000;
	2677	1	1.8	0.6	0	0	1	1.0921783	-14.553886	110	5	1.12	0.95	97.0130	0.0393	0.0000	0.0000;
	2678	1	2	0.9	0	0	1	1.1050732	-13.306454	110	5	1.12	0.95	96.2886	-0.0121	0.0000	0.0000;
	2679	1	9	2.3	0	0	1	1.0701245	-17.750435	110	5	1.12	0.95	98.8682	0.2205	0.0000	0.0000;
	2680	1	7	2	0	0	1	1.092332	-12.998831	110	5	1.12	0.95	97.0466	0.0481	0.0000	0.0000;
	2681	1	0	0	0	0	1	1.0923791	-12.995253	110	5	1.12	0.95	97.0425	0.0480	0.0000	0.0000;
	2682	1	3	1	0	0	1	1.0686049	-18.405396	110	5	1.12	0.95	99.0795	0.2487	0.0000	0.0000;
	2683	1	6	1.8	0	0	1	1.0914032	-13.016417	110	5	1.12	0.95	97.1231	0.0722	0.0000	0.0000;
	2684	1	4.8	2	0	0	1	1.091435	-12.967057	110	5	1.12	0.95	97.0970	0.0741	0.0000	0.0000;
	2685	2	2.9	1.3	0	0	1	1.0904561	-12.978516	110	5	1.12	0.95	97.2233	0.0928	0.0000	0.0000;
	2686	1	7.3	1.4	0	0	1	1.089515	-12.755715	110	5	1.12	0.95	97.2265	0.1422	0.0000	0.0000;
	2687	1	5.8	1.5	0	0	1	1.0753129	-4.9585681	110	5	1.12	0.95	92.5376	1.6676	0.0000	0.0000;
	2688	1	4.6	1.9	0	0	1	1.0911576	-13.027418	110	5	1.12	0.95	97.1504	0.0818	0.0000	0.0000;
	2689	1	4.5	2	0	0	1	1.0853267	-14.958682	110	5	1.12	0.95	98.8726	0.2172	0.0000	0.0000;
	2690	1	1.4	0.9	0	0	1	1.0900382	-13.105938	110	5	1.12	0.95	97.2894	0.0982	0.0000	0.0000;
	2691	1	6	1	0	0	1	1.0969879	-16.261378	110	5	1.12	0.95	97.4136	0.0320	0.0000	0.0000;
	2692	1	3	0.5	0	0	1	1.0979197	-16.154233	110	5	1.12	0.95	97.4030	0.0231	0.0000	0.0000;
	2693	1	6.6	3.9	0	0	1	1.0870732	-13.631332	110	5	1.12	0.95	97.3418	0.1676	0.0000	0.0000;
	2694	1	9.9	3.2	0	0	1	1.0730116	-18.345477	110	5	1.12	0.95	98.8713	0.1350	0.0000	0.0000;
	2695	1	7.5	1.6	0	0	1	1.0733673	-18.289351	110	5	1.12	0.95	98.8245	0.1417	0.0000	0.0000;
	2696	2	5	1	0	0	1	1.07741	-18.132978	110	5	1.12	0.95	99.0400	0.1142	0.0000	0.0000;
	2697	1	7.7	2.3	0	0	1	1.0687562	-18.31285	110	5	1.12	0.95	98.9662	0.2267	0.0000	0.0000;
	2698	1	4.4	2.7	0	0	1	1.0964099	-11.193081	110	5	1.12	0.95	96.1213	0.0972	0.0000	0.0000;
	2699	1	11.5	7.6	0	0	1	1.0962975	-11.184322	110	5	1.12	0.95	96.1224	0.0974	0.0000	0.0000;
	2700	1	4	1.5	0	0	1	1.0849661	-15.396023	110	5	1.12	0.95	97.6797	0.1610	0.0000	0.0000;
	2701	1	7.6	1.9	0	0	1	1.0952507	-10.584506	110	5	1.12	0.95	95.6761	0.2070	0.0000	0.0000;
	2702	2	9.1	3.4	0	0	1	1.0965218	-10.182545	110	5	1.12	0.95	95.4210	0.1625	0.0000	0.0000;
	2703	1	0	0	0	0	1	1.0965034	-10.206012	110	5	1.12	0.95	95.4181	0.1645	0.0000	0.0000;
	2704	1	9.1	3.2	0	0	1	1.0943761	-10.813149	110	5	1.12	0.95	95.9646	0.1800	0.0000	0.0000;
	2705	1	2.1	0.3	0	0	1	1.0709912	-18.002469	110	5	1.12	0.95	98.5736	0.1301	0.0000	0.0000;
	2706	1	0	0	0	0	1	1.0660127	-15.842096	110	5	1.12	0.95	98.2035	-0.0194	0.0000	0.0000;
	2707	1	0	0	0	0	1	1.0979592	-16.145239	110	5	1.12	0.95	97.3002	0.0202	0.0000	0.0000;
	2708	1	0	0	0	0	1	1.070998	-18.001814	110	5	1.12	0.95	98.5727	0.1300	0.0000	0.0000;
	2709	1	33	11	0	0	1	1.1067091	-12.9523	110	5	1.12	0.95	95.7156	0.0643	0.0000	0.0000;
	2710	1	2	0.5	0	0	1	1.1070417	-12.926351	110	5	1.12	0.95	95.6870	0.0556	0.0000	0.0000;
	2711	1	5.1	1	0	0	1	1.0708241	-18.057449	110	5	1.12	0.95	98.6626	0.1049	0.0000	0.0000;
	2712	1	5.4	1.1	0	0	1	1.0727237	-17.881465	110	5	1.12	0.95	98.4242	0.0781	0.0000	0.0000;
	2713	2	49.8	20.8	0	0	1	1.0945995	-11.282907	110	5	1.12	0.95	96.3591	0.1515	0.0000	0.0000;
	2714	1	32	6.5	0	0	1	1.0945198	-11.291436	110	5	1.12	0.95	96.3767	0.1492	0.0000	0.0000;
	2715	1	3.5	0	0	0	1	1.0714801	-20.496289	110	5	1.12	0.95	102.9552	-0.2279	0.0000	0.0000;
	2716	1	2.4	0.6	0	0	1	1.057597	-18.162469	110	5	1.12	0.95	100.1977	0.5666	0.0000	0.0000;
	2717	2	7.2	2	0	0	1	1.0794779	-5.1522774	110	5	1.12	0.95	94.1060	1.0755	0.0000	0.0000;
	2718	1	0	0	0	0	1	1.0781253	-17.981466	110	5	1.12	0.95	98.4550	0.0386	0.0000	0.0000;
	2719	1	0	0	0	0	1	1.0781573	-17.980957	110	5	1.12	0.95	98.4542	0.0384	0.0000	0.0000;
	2720	1	5	2	0	0	1	1.0912815	-14.538952	110	5	1.12	0.95	97.6135	0.1867	0.0000	0.0000;
	2721	1	0	0	0	0	1	1.1013789	-16.117557	110	5	1.12	0.95	97.3716	-0.2003	0.0000	0.0000;
	2722	1	0	0	0	0	1	1.1014372	-16.109945	110	5	1.12	0.95	97.3687	-0.2018	0.0000	0.0000;
	2723	1	1	0.5	0	0	1	1.1012983	-16.247456	110	5	1.12	0.95	97.5102	-0.2406	0.0000	0.0000;
	2724	2	188.53	43.734	0	0	0	1.0334173	-3.7992597	400	0	1.05	0.95	91.6570	-0.1515	0.0000	0.0000;
	2725	2	288.478	21.932	0	0	0	1.0268533	-4.4037894	400	0	1.05	0.95	92.0539	-0.0920	0.0000	0.0000;
	2726	2	183.5	10.655	0	0	0	1.0751948	-9.2563708	220	0	1.11	0.95	94.9362	0.1142	0.0000	0.0000;
	2727	2	0	0	0	0	0	1.0209262	0.14074228	400	0	1.05	0.95	90.2066	0.0000	0.0000	0.0000;
	2728	2	0	0	0	0	3	1.0616356	0.97338228	220	0	1.11	0.95	89.1329	-1.8785	0.0000	0.0000;
	2729	2	0	0	0	0	0	1.097449	-4.6293857	220	0	1.11	0.95	93.5970	0.0000	0.0000	0.0000;
	2730	2	235.085	142.487	0	0	0	1.028021	-7.8612949	400	0	1.05	0.95	93.2356	-0.7817	0.0000	0.0000;
	2731	2	0	0	0	0	3	1.0910956	0.39167089	110	0	1.12	0.95	86.3177	-0.2699	0.0000	0.0000;
	2732	1	17	6	0	0	2	1.0857378	-7.4968572	110	0	1.12	0.95	94.2325	0.7393	0.0000	0.0000;
	2733	1	0	0	0	0	2	1.0858269	-7.4900686	110	0	1.12	0.95	94.2256	0.7369	0.0000	0.0000;
	2734	1	33	12	0	0	2	1.0845387	-7.5789243	110	0	1.12	0.95	94.3305	0.7757	0.0000	0.0000;
	2735	1	16	6	0	0	2	1.0845545	-7.577281	110	0	1.12	0.95	94.3297	0.7754	0.0000	0.0000;
	2736	1	25	10	0	0	2	1.0741694	-8.2840464	110	0	1.12	0.95	95.3577	1.0860	0.0000	0.0000;
	2737	1	65	26	0	0	2	1.0649446	-8.8659959	110	0	1.12	0.95	96.1335	1.4013	0.0000	0.0000;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf	mu_Pmax	mu_Pmin	mu_Qmax	mu_Qmin
mpc.gen = [
	17	0	0	120	-22	1.07567	241.9	0	210	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	17	0	0	120	-22	1.07567	233.2	0	200	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	26	370	2.61068	190	-19	1.08527	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	13.2018	0.0000	0.0000	0.0000;
	27	360	-19	190	-19	1.08827	407.1	1	360	290	0	0	0	0	0	0	0	0	0	0	0	13.7497	0.0000	0.0000	0.0653;
	27	0	0	190	-19	1.08827	407.1	0	360	290	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	27	0	0	190	-19	1.08827	415.9	0	370	290	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	26	370	2.61068	190	-19	1.08527	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	13.2018	0.0000	0.0000	0.0000;
	28	370	-19	190	-19	1.027	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	14.1156	0.0000	0.0000	0.0851;
	28	0	0	190	-19	1.027	415.9	0	370	290	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	28	0	0	190	-19	1.027	415.9	0	370	290	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	29	0	0	190	-19	1.027	415.9	0	370	290	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	29	370	-19	190	-19	1.027	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	14.1126	0.0000	0.0000	0.0850;
	29	370	-19	190	-19	1.027	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	14.1126	0.0000	0.0000	0.0850;
	42	130	-34	135	-34	1.09086	253.9	1	215	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	10.3075	0.0000	1.1989;
	42	0	0	130	-34	1.09086	242.7	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	42	0	0	145	-34	1.09086	267.7	0	225	110	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	43	0	0	145	-34	1.09091	267.7	0	225	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	43	130	-34	145	-34	1.09091	267.7	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	10.3102	0.0000	1.2022;
	43	0	0	130	-34	1.09091	242.7	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	44	255	-47	363	-47	1.04817	646.5	1	535	255	0	0	0	0	0	0	0	0	0	0	0	0.0000	10.0534	0.0000	1.1649;
	44	0	0	348	-100	1.04817	659.3	0	560	250	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	54	0	0	104	-1	1.09127	247.9	0	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	55	129	-16	130	-16	1.09126	259.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	13.5189	0.0000	1.3710;
	54	0	0	130	-16	1.09127	259.9	0	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	56	129	-16	130	-16	1.03933	259.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	13.2824	0.0000	1.1044;
	57	129	-16	130	-16	1.03932	259.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	13.2810	0.0000	1.1042;
	57	0	0	104	-1	1.03932	247.9	0	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	57	0	0	130	-16	1.03932	259.9	0	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	58	39.7	0	30	0	1.09864	57.7	1	39.7	39.7	0	0	0	0	0	0	0	0	0	0	0	91.6559	0.0000	0.0000	1.9664;
	78	140	21.9558	123	-15	1.06723	256.4	1	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.2914	0.0000	0.0000;
	78	140	4.97652	123	-15	1.06723	256.4	1	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.2914	0.0000	0.0000;
	79	0	0	123	-15	1.07077	252	0	220	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	79	0	0	123	-15	1.07077	256.4	0	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	79	140	-15	123	-15	1.07077	256.4	1	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.9944	0.0000	0.0433;
	82	380	-31	232	-31	1.0186	445.2	1	380	220	0	0	0	0	0	0	0	0	0	0	0	0.7525	0.0000	0.0000	0.1757;
	82	0	0	228	-30	1.0186	434.6	0	370	220	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	98	8.998	0	1	0	1.07416	12	1	8.998	8.998	0	0	0	0	0	0	0	0	0	0	0	92.1552	0.0000	0.0000	0.1393;
	98	5.998	0	1	0	1.07416	6.1	1	5.998	5.998	0	0	0	0	0	0	0	0	0	0	0	92.1552	0.0000	0.0000	0.1393;
	104	134	78.277	123	-15	1.06927	256.4	1	225	134	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.6478	0.0000	0.0000;
	105	0	0	123	-15	1.06917	256.4	0	225	134	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	106	79	3.09041	80	-2	1.06843	144.2	1	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.2938	0.0000	0.0000;
	107	0	0	80	-2	1.0684	144.2	0	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	116	0	0	90	-20	1.07086	150	0	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	117	70	-2	82	-2	1.07082	145.3	1	120	70	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.9443	0.0000	0.0883;
	118	0	0	40	0	1.07063	117	0	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	125	0	0	135	-35	1.0744	253.9	0	215	160	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	126	0	0	140	-35	1.07421	265	0	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	126	215	-35	135	-35	1.07421	253.9	1	215	160	0	0	0	0	0	0	0	0	0	0	0	0.3914	0.0000	0.0000	0.0514;
	127	225	-40	140	-40	1.01239	265	1	225	140	0	0	0	0	0	0	0	0	0	0	0	0.1379	0.0000	0.0000	0.1135;
	127	0	0	137	-40	1.01239	259.2	0	220	160	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	132	0	16.868	40	-38	1.06355	131.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	94.3590	0.0000	0.0000	0.0000;
	132	0	0	40	-38	1.06355	131.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	133	0	0	40	-38	1.06355	131.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	133	0	13.9428	40	-38	1.06355	131.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	94.3608	0.0000	0.0000	0.0000;
	134	0	0	90	0	1.0664	150	0	120	100	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	134	0	0	90	0	1.0664	150	0	120	100	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	135	100	27.1095	90	0	1.06642	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.0646	0.0000	0.0000;
	146	0	0	12	0	1.05776	51.4	0	50	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	146	0	0	12	0	1.05776	51.4	0	50	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	147	0	0	90	0	1.05781	150	0	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	0	0	149	-48	1.09091	267.4	0	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	0	0	149	-48	1.09091	253.4	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	0	0	149	-48	1.09091	253.4	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	90	-48	149	-48	1.09091	267.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	22.1807	0.0000	0.0074;
	150	90	24.8292	123	-23	1.01688	253.8	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	21.5149	0.0000	0.0000;
	151	90	-41.4177	149	-48	1.01688	267.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	21.5157	0.0000	0.0004;
	151	0	0	123	-23	1.01688	253.8	0	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	155	94	-53	149	-53	1.08864	278.3	1	235	94	0	0	0	0	0	0	0	0	0	0	0	0.0000	8.6704	0.0000	0.0449;
	155	0	0	149	-53	1.08864	278.3	0	235	94	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	155	0	0	120	0	1.08864	287.3	0	261	104	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	155	0	0	132	-40	1.08864	292.5	0	261	104	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	156	0	0	120	0	1.08864	287.3	0	261	104	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	156	130	-22	117	-22	1.08864	236	1	205	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	8.6711	0.0000	0.0454;
	156	120	-20	109	-20	1.08864	233.1	1	206	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	8.6711	0.0000	0.0454;
	156	0	0	109	-20	1.08864	233.1	0	206	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	158	120	-20	109	-20	0.99847	233.1	1	206	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	8.5875	0.0000	0.0033;
	164	0	0	104	-23	1.05768	225.4	0	200	150	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	164	200	64.2167	104	-23	1.05768	225.4	1	200	150	0	0	0	0	0	0	0	0	0	0	0	2.8880	0.0000	0.0000	0.0000;
	165	200	75.1437	104	-23	1.05768	225.4	1	200	150	0	0	0	0	0	0	0	0	0	0	0	2.8952	0.0000	0.0000	0.0002;
	165	0	0	104	-23	1.05768	225.4	0	200	150	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	180	120	0	110	0	1.09138	219.5	1	120	120	0	0	0	0	0	0	0	0	0	0	0	91.8736	0.0000	0.0000	1.4635;
	205	0	39.4264	80	-30.001	0.98664	196.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	98.1653	0.0000	0.0000	0.0000;
	205	0	-16.382	80	-30.001	0.98664	196.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	98.1653	0.0000	0.0000	0.0000;
	205	0	0	110	-60	0.98664	210.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	206	0	0	110	-60	0.98669	210.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	215	23	0	20	0	1.09091	58.5	1	23	23	0	0	0	0	0	0	0	0	0	0	0	93.5881	0.0000	0.0000	0.9775;
	215	0	0	20	0	1.09091	53.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	215	0	0	20	0	1.09091	53.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	215	7	0	20	0	1.09091	30.5	1	7	7	0	0	0	0	0	0	0	0	0	0	0	93.5881	0.0000	0.0000	0.9775;
	221	1.55	0	1	0	1.0868	2.3	1	1.55	1.55	0	0	0	0	0	0	0	0	0	0	0	91.7879	0.0000	0.0000	0.2327;
	222	1.55	0.262495	1	0	1.0748	2.3	1	1.55	1.55	0	0	0	0	0	0	0	0	0	0	0	91.9673	0.0000	0.0000	0.0000;
	240	6.3	4.18608	6	0	1.05704	9.8	1	6.3	6.3	0	0	0	0	0	0	0	0	0	0	0	95.2580	0.0000	0.0000	0.0000;
	247	370	-19	190	-19	1.02878	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	13.5459	0.0000	0.0018	0.0000;
	310	0	0	7	0	1.07912	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	310	0	0	7	0	1.07912	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	310	11	7	7	4	1.07912	30.8	1	11	11	0	0	0	0	0	0	0	0	0	0	0	90.9502	0.0000	0.0545	0.0000;
	310	0	0	7	0	1.07912	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	310	0	0	6	0	1.07912	27.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	310	0	0	7	0	1.07912	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	310	0	0	7	0	1.07912	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	311	0	0	15	0	1.07689	36.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	311	0	0	15	0	1.07689	57	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	312	16	11.5985	15	0	1.07487	36.7	1	16	16	0	0	0	0	0	0	0	0	0	0	0	91.4685	0.0000	0.0000	0.0000;
	312	0	0	15	0	1.07487	57	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	314	25	5.94042	20	0	1.08518	53.9	1	25	25	0	0	0	0	0	0	0	0	0	0	0	90.6475	0.0000	0.0000	0.0000;
	314	0	0	20	0	1.08518	53.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	315	0	0	40	0	1.07925	107.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	323	2.5	3	3	0	1.08432	4.1	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	90.7163	0.0000	0.0092	0.0000;
	366	40	6.08732	12	0	1.06091	47.8	1	40	40	0	0	0	0	0	0	0	0	0	0	0	93.8344	0.0000	0.0000	0.0000;
	367	40	5.46894	12	0	1.06011	47.8	1	40	40	0	0	0	0	0	0	0	0	0	0	0	93.4746	0.0000	0.0000	0.0000;
	368	40	4.52361	12	0	1.06213	47.8	1	40	40	0	0	0	0	0	0	0	0	0	0	0	93.6481	0.0000	0.0000	0.0000;
	369	40	0	12	0	1.06706	47.8	1	40	40	0	0	0	0	0	0	0	0	0	0	0	93.3527	0.0000	0.0000	0.0144;
	386	140	-45.4985	138	-47	1.08555	251.3	1	210	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	18.7728	0.0000	0.0000;
	386	0	0	10	0	1.08555	26.9	0	25	12	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	387	10	0	10	0	1.06898	19.7	1	17	10	0	0	0	0	0	0	0	0	0	0	0	0.0000	17.4105	0.0000	0.1532;
	444	1.5	1.56509	2	0	1.03619	3.6	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	90.2706	0.0000	0.0000	0.0000;
	453	5.21	0	2	0	1.0809	6.1	1	5.21	5.21	0	0	0	0	0	0	0	0	0	0	0	92.3977	0.0000	0.0000	0.3884;
	453	0	0	2	0	1.0809	6.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	486	1.4	0.7	0.7	0	1.03025	1.7	1	1.4	1.4	0	0	0	0	0	0	0	0	0	0	0	91.1651	0.0000	0.0153	0.0000;
	537	25	0	14	0	1.06135	53.9	1	25	25	0	0	0	0	0	0	0	0	0	0	0	93.9619	0.0000	0.0000	0.1009;
	537	0	0	14	0	1.06135	34.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	537	0	0	14	0	1.06135	34	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	537	0	0	14	0	1.06135	105.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	537	0	0	14	0	1.06135	105.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	538	20	0	17.5	0	1.06273	36.5	1	20	20	0	0	0	0	0	0	0	0	0	0	0	93.8344	0.0000	0.0000	0.0782;
	538	20	0	17.5	0	1.06273	35.6	1	20	20	0	0	0	0	0	0	0	0	0	0	0	93.8344	0.0000	0.0000	0.0782;
	538	0	0	17.5	0	1.06273	126.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	538	0	0	17.5	0	1.06273	106.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	552	1.4	0.7	0.7	0	1.05556	1.7	1	1.4	1.4	0	0	0	0	0	0	0	0	0	0	0	94.5110	0.0000	0.0144	0.0000;
	560	22.5	2.55494	10	0	1.05752	35.4	1	22.5	22.5	0	0	0	0	0	0	0	0	0	0	0	94.3389	0.0000	0.0000	0.0000;
	560	0	0	5	0	1.05752	28.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	560	0	0	5	0	1.05752	26.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	560	0	0	5	0	1.05752	30.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	560	0	0	5	0	1.05752	34.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	561	22.5	0	10	0	1.0595	35.4	1	22.5	22.5	0	0	0	0	0	0	0	0	0	0	0	94.1928	0.0000	0.0000	0.0742;
	561	0	0	5	0	1.0595	34.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	561	0	0	5	0	1.0595	26.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	561	0	0	5	0	1.0595	34.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	574	1	1.23635	4	0	1.07812	8.9	1	1	1	0	0	0	0	0	0	0	0	0	0	0	91.4956	0.0000	0.0000	0.0000;
	627	76	0	30	0	1.09176	97.7	1	76	76	0	0	0	0	0	0	0	0	0	0	0	88.4239	0.0000	0.0000	1.5661;
	627	30	0	30	0	1.09176	46.8	1	30	30	0	0	0	0	0	0	0	0	0	0	0	88.4239	0.0000	0.0000	1.5661;
	665	130	-34	145	-34	1.09108	267.7	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	11.0839	0.0000	0.5354;
	666	0	0	145	-34	1.09079	267.7	0	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	686	140	0	30	0	1.09115	182.5	1	140	140	0	0	0	0	0	0	0	0	0	0	0	90.0530	0.0000	0.0000	2.7870;
	686	47	0	30	0	1.09115	77.5	1	47	47	0	0	0	0	0	0	0	0	0	0	0	90.0530	0.0000	0.0000	2.7870;
	692	1.98	0	1	0	1.09065	2.7	1	1.98	1.98	0	0	0	0	0	0	0	0	0	0	0	90.7605	0.0000	0.0000	2.7235;
	717	1.32	0	1.3	0	1.08239	10.1	1	1.32	1.32	0	0	0	0	0	0	0	0	0	0	0	91.7403	0.0000	0.0000	1.5536;
	741	129	-16	130	-16	1.09099	259.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	14.4117	0.0000	1.6087;
	764	82	0	30	0	1.06965	105.4	1	82	82	0	0	0	0	0	0	0	0	0	0	0	91.3594	0.0000	0.0000	1.0841;
	793	1	0	0.5	0	1.04724	8.3	1	1	1	0	0	0	0	0	0	0	0	0	0	0	93.8724	0.0000	0.0000	1.0621;
	797	0	0	23	0	1.0493	71.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	797	0	0	23	0	1.0493	71.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	797	0	0	11	0	1.0493	32.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	797	0	0	10	0	1.0493	32.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	808	0	0	10	0	1.07568	125.4	0	125	84	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	809	92	0	10	0	1.09118	125.4	1	125	92	0	0	0	0	0	0	0	0	0	0	0	0.0000	22.6822	0.0000	1.7147;
	846	14.996	0	8.1	0	1.07424	33	1	14.996	14.996	0	0	0	0	0	0	0	0	0	0	0	92.4459	0.0000	0.0000	0.7630;
	846	14.996	0	8.1	0	1.07424	33	1	14.996	14.996	0	0	0	0	0	0	0	0	0	0	0	92.4459	0.0000	0.0000	0.7630;
	846	0	0	0	0	1.07424	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	846	0	0	0	0	1.07424	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	878	34.99	5.31522	41.2	0	1.08146	87.7	1	34.99	34.99	0	0	0	0	0	0	0	0	0	0	0	91.4588	0.0000	0.0000	0.0000;
	901	0	0	45	-10	1.07665	65.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	901	44.988	-8.16076	45	-10	1.07665	71.1	1	44.988	44.988	0	0	0	0	0	0	0	0	0	0	0	91.2640	0.0000	0.0000	0.0000;
	901	0	0	45	-10	1.07665	71.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	976	0	0	110	-40	1.08472	162.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	977	99.973	8.09625	110	-40	1.08973	162.2	1	99.973	99.973	0	0	0	0	0	0	0	0	0	0	0	91.3097	0.0000	0.0000	0.0000;
	981	0	0	0	0	1.08908	16.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1002	225.568	-32	240	-32	1.09091	454.5	1	386	220	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0976;
	1003	0	0	227	-30	1.08396	434.1	0	370	220	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1007	5.998	1.447	1.447	0	1.08685	7.1	1	5.998	5.998	0	0	0	0	0	0	0	0	0	0	0	91.5495	0.0000	0.0651	0.0000;
	1006	3.999	0.447	0.447	0	1.08685	4	1	3.999	3.999	0	0	0	0	0	0	0	0	0	0	0	91.5486	0.0000	0.0654	0.0000;
	1007	3.999	0.447	0.447	0	1.08685	5	1	3.999	3.999	0	0	0	0	0	0	0	0	0	0	0	91.5495	0.0000	0.0651	0.0000;
	1007	0	0	0	0	1.08685	6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1008	0	0	110	-40	1.08742	174.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1014	14.996	0	4.8	0	1.08325	20.6	1	14.996	14.996	0	0	0	0	0	0	0	0	0	0	0	92.3810	0.0000	0.0000	0.0255;
	1014	0	0	0	0	1.08325	12.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1014	0	0	0	0	1.08325	12.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1016	0	0	0	0	1.08029	20	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1016	0	0	0	0	1.08029	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1025	11.997	18	18	9	1.07158	30	1	11.997	11.997	0	0	0	0	0	0	0	0	0	0	0	94.3556	0.0000	0.0130	0.0000;
	1026	0	0	18	9	1.07151	30	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1027	0	0	14	10.5	1.07147	32.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1114	0	0	37.5	16.8	1.08691	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1115	0	0	37.5	7.5	1.0759	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1114	39.989	7.5	37.5	7.5	1.08691	62.5	1	39.989	39.989	0	0	0	0	0	0	0	0	0	0	0	91.9086	0.0000	0.0000	0.0133;
	1116	0	0	37.5	16.8	1.08062	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1153	16.995	0	5.251	0	1.07018	30.5	1	16.995	16.995	0	0	0	0	0	0	0	0	0	0	0	93.1565	0.0000	0.0000	0.0103;
	1153	0	0	0	0	1.07018	6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1154	16.995	0	5.251	0	1.07027	30.5	1	16.995	16.995	0	0	0	0	0	0	0	0	0	0	0	93.1437	0.0000	0.0000	0.0117;
	1154	0	0	0	0	1.07027	25	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1155	15.996	0	5.25	0	1.07285	30.5	1	15.996	15.996	0	0	0	0	0	0	0	0	0	0	0	92.7739	0.0000	0.0000	0.1178;
	1155	0	0	0	0	1.07285	6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1180	59.984	15.5493	52.5	0	1.08018	87.5	1	59.984	59.984	0	0	0	0	0	0	0	0	0	0	0	91.6538	0.0000	0.0000	0.0000;
	1181	0	0	52.5	0	1.08122	87.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1181	0	0	42	16.8	1.08122	65.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1189	49.986	0	0	0	1.07992	50	1	49.986	49.986	0	0	0	0	0	0	0	0	0	0	0	91.7678	0.0000	0.0267	0.0000;
	1247	9.997	0.854507	2	0	1.07484	16.7	1	9.997	9.997	0	0	0	0	0	0	0	0	0	0	0	91.8830	0.0000	0.0000	0.0000;
	1247	0	0	0	0	1.07484	24	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1248	0	0	0	0	1.07711	14.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1248	0	0	0	0	1.07711	14.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1248	0	0	0	0	1.07711	14.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1249	0	0	0	0	1.07345	5.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1249	0	0	0	0	1.07345	5.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1287	0	0	41	-6.5	1.07056	68.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1288	134	46.9566	123	-15	1.09091	260.8	1	230	134	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.6591	0.0000	0.0000;
	1289	0	0	123	-15	1.08328	256.4	0	225	134	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1343	19.995	0	5	0	1.08438	22.6	1	19.995	19.995	0	0	0	0	0	0	0	0	0	0	0	91.6105	0.0000	0.0000	0.1612;
	1344	0	0	0	0	1.0844	12	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1344	24.993	0	5	0	1.0844	32.4	1	24.993	24.993	0	0	0	0	0	0	0	0	0	0	0	91.6097	0.0000	0.0000	0.1612;
	1352	0	0	90	-5	1.06939	142.1	0	110	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1353	79	9.17613	80	-2	1.08122	144.2	1	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.5961	0.0000	0.0000;
	1352	0	0	80	-2	1.06939	144.2	0	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1354	0	0	80	-2	1.08888	144.2	0	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1364	0	0	89	-6	1.07659	153.4	0	125	84	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1364	0	0	89	-6	1.07659	153.4	0	125	84	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1375	79.978	-1.87547	80	-25	1.06873	141.7	1	79.978	79.978	0	0	0	0	0	0	0	0	0	0	0	92.6570	0.0000	0.0000	0.0000;
	1375	0	0	80	-25	1.06873	128.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1376	0	0	80	-25	1.06882	143.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1377	0	0	80	-25	1.07086	136	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1415	0	0	33.5	12	1.07453	36.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1416	0	0	41.2	-13.7	1.07412	68.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1416	0	0	41.2	-13.7	1.07412	68.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1433	9.997	2	2	0	1.07841	12.2	1	9.997	9.997	0	0	0	0	0	0	0	0	0	0	0	92.7781	0.0000	0.2234	0.0000;
	1433	9.997	2	2	0	1.07841	12.2	1	9.997	9.997	0	0	0	0	0	0	0	0	0	0	0	92.7781	0.0000	0.2234	0.0000;
	1434	0	0	0	0	1.07777	4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1434	0	0	0	0	1.07777	4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1436	9.997	3.75	3.75	0	1.08726	15.5	1	9.997	9.997	0	0	0	0	0	0	0	0	0	0	0	91.7124	0.0000	0.0256	0.0000;
	1435	12.996	6.75	6.75	0	1.0867	23.5	1	12.996	12.996	0	0	0	0	0	0	0	0	0	0	0	91.7885	0.0000	0.0337	0.0000;
	1440	0	0	123	-15	1.07916	256.4	0	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1462	0	0	35	-6	1.07644	57.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1462	0	0	35	-6	1.07644	57.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1645	0	0	9.3	1.9	1.07176	17.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1645	0	0	9.3	1.9	1.07176	17.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1645	0	0	9.3	1.9	1.07176	17.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1645	0	0	9.3	2	1.07176	17.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1645	0	0	0	0	1.07176	3.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1645	0	0	0	0	1.07176	4.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1673	55	23.4855	117	-29	1.08464	192.6	1	153	55	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.6875	0.0000	0.0000;
	1674	0	0	82	-2	1.07498	152	0	128	70	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1674	0	0	117	-29	1.07498	192.6	0	153	55	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1675	0	0	82	-2	1.0781	147.8	0	123	70	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1685	80	0	40	0	1.07842	117	1	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.1238	0.0000	0.2313;
	1686	0	0	42	16.8	1.07824	61.6	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1686	0	0	40	0	1.07824	117	0	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1686	0	0	42	16.8	1.07824	61.6	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1686	80	0	40	0	1.07824	117	1	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.2204	0.0000	0.1804;
	1685	0	0	40	16	1.07842	60.2	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1777	0	0	6.6	0.7	1.07307	8.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1794	0	0	0	0	1.08044	25	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1794	19.995	0	4	0	1.08044	25.3	1	19.995	19.995	0	0	0	0	0	0	0	0	0	0	0	91.3487	0.0000	0.0000	0.3221;
	1794	0	0	0	0	1.08044	25	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1794	0	0	0	0	1.08044	25	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1795	37.99	14.004	26	13	1.08673	47.7	1	37.99	37.99	0	0	0	0	0	0	0	0	0	0	0	91.7282	0.0000	0.0000	0.0000;
	1837	160	33.9342	140	-35	1.09091	265	1	225	160	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.7963	0.0000	0.0000;
	1837	0	0	140	-35	1.09091	265	0	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1839	160	-9.48687	140	-35	1.09091	265	1	225	160	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0926	0.0000	0.0000;
	1873	0	0	26	13	1.07795	43.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1873	0	0	8.3	1.5	1.07795	11.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1874	0	0	12	5.8	1.07447	27.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1874	0	0	26	13	1.07447	39.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1907	0	0	0	0	1.07643	32	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1908	0	0	0	0	1.07642	32	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1927	0	0	0	0	1.06864	10.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1927	0	0	0	0	1.06864	10.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1929	100	17.848	90	0	1.08372	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.4256	0.0000	0.0000;
	1930	0	0	90	0	1.08357	150	0	120	100	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1945	1	0	0	0	1.09236	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	90.3827	0.0000	0.0000	0.1674;
	1948	1	0	0	0	1.0931	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	91.2727	0.0000	0.0000	0.4724;
	1959	0.2	0	0	0	1.09823	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	90.7425	0.0000	0.0000	0.3551;
	1963	0.1	0	0	0	1.09246	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	91.6812	0.0000	0.0000	0.6225;
	1965	15	-0.001	15	-0.001	1.08543	52.2	1	15	15	0	0	0	0	0	0	0	0	0	0	0	91.3206	0.0000	0.0000	0.0790;
	1965	0	0	15	0	1.08543	52.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1966	0	0	10	0	1.08751	33.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1992	90	-16.2802	149	-48	1.09091	267.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	22.7823	0.0000	0.0000;
	1998	0	0	8	0	1.07816	27.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1998	0	0	8	0	1.07816	28.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1998	0	0	8	0	1.07816	27.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2002	31	0	15	0	1.07352	57	1	31	31	0	0	0	0	0	0	0	0	0	0	0	93.7470	0.0000	0.0000	0.0573;
	2002	80	0	80	0	1.07352	128.1	1	80	80	0	0	0	0	0	0	0	0	0	0	0	93.7470	0.0000	0.0000	0.0573;
	2003	0	0	90	0	1.07268	150.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2008	0.4	0	0	0	1.07048	0.4	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	96.6109	0.0000	0.1572	0.0000;
	2015	0	0	10	0	1.08218	30.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2015	0	0	10	0	1.08218	30.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2015	20	0	12	0	1.08218	55.8	1	20	20	0	0	0	0	0	0	0	0	0	0	0	93.6938	0.0000	0.0000	0.3890;
	2016	0	0	2	0	1.08171	5.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2016	0	0	2	0	1.08171	6.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2036	9.5	0	0	0	1.0827	10.5	1	9.5	9.5	0	0	0	0	0	0	0	0	0	0	0	92.7770	0.0000	0.0000	0.2909;
	2040	5	0	0	0	1.08125	5.5	1	5	5	0	0	0	0	0	0	0	0	0	0	0	92.2240	0.0000	0.0000	0.0619;
	2042	90	23.7776	90	0	1.08064	150	1	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.2795	0.0000	0.0000;
	2047	0.1	0	0	0	1.09431	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	91.1329	0.0000	0.0000	0.4032;
	2057	1	0	0	0	1.05303	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	97.1670	0.0000	0.0000	0.2583;
	2064	0	0	1	0	1.07503	3.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2064	2	2	2	0	1.07503	4.5	1	2	2	0	0	0	0	0	0	0	0	0	0	0	92.4326	0.0000	0.0533	0.0000;
	2071	0.2	0	0	0	1.09255	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	91.7350	0.0000	0.0000	0.6230;
	2091	0	0	12	0	1.08055	51.4	0	50	25	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2091	30	3.19688	12	0	1.08055	51.4	1	50	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.2738	0.0007	0.0000;
	2092	20	0	10	0	1.09082	29.7	1	28	20	0	0	0	0	0	0	0	0	0	0	0	0.0000	5.1476	0.0000	0.4349;
	2094	30	0	12	0	1.00467	56.3	1	55	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.7669	0.0000	0.1392;
	2097	1.7	0	0	0	1.07518	1.9	1	1.7	1.7	0	0	0	0	0	0	0	0	0	0	0	93.1179	0.0000	0.0000	0.0438;
	2119	3	0	0	0	1.06289	3.3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	95.9296	0.0000	0.3334	0.0000;
	2141	1	0	0	0	1.09277	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	90.2223	0.0000	0.0000	0.1181;
	2176	0.8	0	0	0	1.0869	0.9	1	0.8	0.8	0	0	0	0	0	0	0	0	0	0	0	91.4757	0.0000	0.0000	0.2290;
	2203	0.8	0	0	0	1.05357	0.9	1	0.8	0.8	0	0	0	0	0	0	0	0	0	0	0	97.1973	0.0000	0.0000	0.2951;
	2204	0.2	0	0	0	1.07818	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	92.2480	0.0000	0.0000	0.1536;
	2209	4	0	0	0	1.08693	4.4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	91.8372	0.0000	0.0000	0.2581;
	2215	200	-15.2147	104	-23	1.09091	225.4	1	200	150	0	0	0	0	0	0	0	0	0	0	0	1.1657	0.0000	0.0000	0.0000;
	2216	191.309	20.5641	111	-18	1.09091	228.7	1	200	150	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2229	0.4	0	0	0	1.05507	0.4	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	96.8033	0.0000	0.0000	0.2999;
	2236	9	0	0	0	1.05302	9.9	1	9	9	0	0	0	0	0	0	0	0	0	0	0	94.3481	0.0000	0.1164	0.0000;
	2254	40	9.43289	15	0	1.07949	66.7	1	40	40	0	0	0	0	0	0	0	0	0	0	0	94.3465	0.0000	0.0000	0.0000;
	2255	0	0	15	0	1.07945	66.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2266	1.5	0	0	0	1.08834	1.7	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	91.1990	0.0000	0.0000	0.1863;
	2279	4	0	0	0	1.08284	4.4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	95.0846	0.0000	0.0000	0.2154;
	2294	0.8	0	0	0	1.08001	0.9	1	0.8	0.8	0	0	0	0	0	0	0	0	0	0	0	94.6083	0.0000	0.0000	0.0760;
	2296	0.2	0	0	0	1.09826	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	90.6941	0.0000	0.0000	0.3381;
	2297	0.2	0	0	0	1.08079	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	94.1965	0.0000	0.0000	0.4520;
	2329	0	0	15	0	1.07951	58	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2329	0	0	6	0	1.07951	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2329	2	1.67792	2	0	1.07951	4.5	1	2	2	0	0	0	0	0	0	0	0	0	0	0	94.3996	0.0000	0.0000	0.0000;
	2332	0.1	0	0	0	1.06822	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	96.8040	0.0000	0.2226	0.0000;
	2344	94	21.3438	149	-53	1.09091	278.3	1	235	94	0	0	0	0	0	0	0	0	0	0	0	0.0000	9.2376	0.0000	0.0000;
	2355	0	0	15	0	1.0911	52.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2355	62.5	0.0244651	80	0	1.0911	128.1	1	62.5	62.5	0	0	0	0	0	0	0	0	0	0	0	90.3726	0.0000	0.0000	0.0003;
	2356	0	0	80	0	1.08462	128.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2361	4.1	0	0	0	1.09835	4.5	1	4.1	4.1	0	0	0	0	0	0	0	0	0	0	0	90.6613	0.0000	0.0000	0.3292;
	2367	2.5	0	0	0	1.08903	2.8	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	91.4572	0.0000	0.0000	0.2627;
	2371	0.2	0	0	0	1.0828	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	91.7443	0.0000	0.0000	0.0879;
	2432	3	-0.001	10	-0.001	1.09105	14.5	1	3	3	0	0	0	0	0	0	0	0	0	0	0	92.6431	0.0000	0.0000	1.0430;
	2432	0	0	10	0	1.09105	15.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2439	0.5	0	0	0	1.06145	0.6	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	96.9009	0.0000	0.0000	0.5502;
	2449	0.8	1.7	1.7	0	1.03003	1.9	1	0.8	0.8	0	0	0	0	0	0	0	0	0	0	0	98.3991	0.0000	0.0563	0.0000;
	2452	65	15	15	0	1.06756	71.6	1	65	65	0	0	0	0	0	0	0	0	0	0	0	95.6803	0.0000	0.0541	0.0000;
	2454	0	0	0.2	0	1.06055	0.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	97.4003	0.0000	0.0000	0.0215;
	2460	0.1	0.1	0.1	0	1.0232	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	99.8612	0.0000	0.4512	0.0000;
	2468	0.3	0	0.1	0	1.05596	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	98.1503	0.0000	0.0000	0.2134;
	2471	28	5	5	0	1.02609	28.4	1	28	28	0	0	0	0	0	0	0	0	0	0	0	98.8424	0.0000	0.1767	0.0000;
	2482	0.2	0	0	0	1.0411	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	100.0101	0.0000	0.0923	0.0000;
	2483	0.3	0.1	0.1	0	1.04079	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	98.7287	0.0000	0.0427	0.0000;
	2484	0.3	0	0.1	0	1.0551	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	97.9569	0.0000	0.0000	0.1522;
	2486	0.9	0	0	0	1.03061	1	1	0.9	0.9	0	0	0	0	0	0	0	0	0	0	0	103.0401	0.0000	0.0000	0.2506;
	2489	4	0.3	0.3	0	1.05996	4.4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	97.1051	0.0000	0.0167	0.0000;
	2492	12	3	3	0	1.01993	13.5	1	12	12	0	0	0	0	0	0	0	0	0	0	0	100.1642	0.0000	0.5492	0.0000;
	2501	35	5	5	0	1.02983	40.3	1	35	35	0	0	0	0	0	0	0	0	0	0	0	98.3813	0.0000	0.0700	0.0000;
	2510	0	1.2	1.2	0	1.0509	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	93.7160	0.0000	1.1100	0.0000;
	2527	2.5	1.5	1.5	0	1.06678	3.1	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	95.8365	0.0000	0.0524	0.0000;
	2530	21	19	19	0	1.05685	29.9	1	21	21	0	0	0	0	0	0	0	0	0	0	0	93.0232	0.0000	0.9912	0.0000;
	2547	0.5	0.2	0.2	0	1.06137	0.6	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	96.9801	0.0000	0.0766	0.0000;
	2548	0	0.5	0.5	0	1.06093	0.5	1	0	0	0	0	0	0	0	0	0	0	0	0	0	97.0621	0.0000	0.0719	0.0000;
	2555	37	26	26	0	1.01417	48.3	1	37	37	0	0	0	0	0	0	0	0	0	0	0	100.2019	0.0000	1.3811	0.0000;
	2564	0.2	0.1	0.1	0	1.03318	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	99.0897	0.0000	0.1225	0.0000;
	2569	0.2	0	0	0	1.03624	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	98.9412	0.0000	0.0000	0.1208;
	2572	10	12	12	0	1.05334	16.3	1	10	10	0	0	0	0	0	0	0	0	0	0	0	93.3838	0.0000	1.0805	0.0000;
	2574	0.5	0	0.1	0	1.05946	0.6	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	97.8360	0.0000	0.0000	0.2077;
	2579	0	0.8	0.8	0	1.04697	0.8	1	0	0	0	0	0	0	0	0	0	0	0	0	0	92.2453	0.0000	1.6056	0.0000;
	2583	0	2.5	2.5	0	1.05221	2.5	1	0	0	0	0	0	0	0	0	0	0	0	0	0	93.5506	0.0000	1.0900	0.0000;
	2590	0.5	0	0.1	0	1.05807	0.6	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	97.6554	0.0000	0.0000	0.1462;
	2607	0.2	0.1	0.1	0	1.03891	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	98.1971	0.0000	0.0349	0.0000;
	2626	0.1	0.1	0.1	0	1.02806	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	99.3142	0.0000	0.3350	0.0000;
	2629	0.1	0	0	0	1.02823	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	98.5383	0.0000	0.1153	0.0000;
	2633	10.6	7.9	7.9	0	1.02888	14.1	1	10.6	10.6	0	0	0	0	0	0	0	0	0	0	0	98.5501	0.0000	0.0504	0.0000;
	2635	0.2	0.1	0.1	0	1.01549	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	100.5425	0.0000	0.9040	0.0000;
	2644	0.2	0	0	0	1.02925	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	98.3972	0.0000	0.1142	0.0000;
	2649	0	1.9	1.9	0	1.03685	1.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	101.2204	0.0000	0.1329	0.0000;
	2654	0.7	0	0	0	1.05523	0.8	1	0.7	0.7	0	0	0	0	0	0	0	0	0	0	0	97.5746	0.0000	0.0045	0.0000;
	2663	0.1	0	0	0	1.05409	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	97.8318	0.0000	0.0000	0.0674;
	2668	1	0.1	0.1	0	1.01265	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	100.6888	0.0000	0.3516	0.0000;
	2676	55	35	35	0	1.04986	69.9	1	55	55	0	0	0	0	0	0	0	0	0	0	0	97.3068	0.0000	0.4293	0.0000;
	2685	2	1	1	0	1.05737	2.4	1	2	2	0	0	0	0	0	0	0	0	0	0	0	97.2233	0.0000	0.0928	0.0000;
	2696	0.1	0.1	0.1	0	1.03146	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	99.0400	0.0000	0.1142	0.0000;
	2702	25	2.5	2.5	0	1.06405	26.8	1	25	25	0	0	0	0	0	0	0	0	0	0	0	95.4210	0.0000	0.1625	0.0000;
	2702	25	2.5	2.5	0	1.06405	26.8	1	25	25	0	0	0	0	0	0	0	0	0	0	0	95.4210	0.0000	0.1625	0.0000;
	2702	0	0	0	0	1.06405	26.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2702	0	0	0	0	1.06405	26.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2703	0	0	0	0	1.064	26.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2703	0	0	0	0	1.064	26.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2713	20	14	14	0	1.06085	26.1	1	20	20	0	0	0	0	0	0	0	0	0	0	0	96.3591	0.0000	0.1515	0.0000;
	2717	0	1.2	1.2	0	1.0489	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	94.1060	0.0000	1.0755	0.0000;
	2721	0	0	26	-18	1.06284	56.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2721	0	0	26	-18	1.06284	56.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2721	0	0	26	-18	1.06284	56.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	451	5.8	0	0	0	1.07667	5.8	1	5.8	5.8	0	0	0	0	0	0	0	0	0	0	0	93.0692	0.0000	0.0000	0.3059;
	2150	2.572	0.757	0.757	0.757	1.08261	2.7	1	2.572	2.572	0	0	0	0	0	0	0	0	0	0	0	92.0805	0.0000	0.0000	0.1589;
	1646	2.069	-0.146	-0.146	-0.146	1.07176	2.1	1	2.069	2.069	0	0	0	0	0	0	0	0	0	0	0	93.3414	0.0000	0.0000	0.9107;
	1731	0.6	0.245	0.245	0.245	1.06995	0.6	1	0.6	0.6	0	0	0	0	0	0	0	0	0	0	0	92.0176	0.0000	0.0309	0.0000;
	28	20.153	30	30	30	1.027	36.1	1	20.153	20.153	0	0	0	0	0	0	0	0	0	0	0	90.2156	0.0000	0.0000	0.0851;
	155	4.903	-32.492	-32.492	-32.492	1.08864	32.9	1	4.903	4.903	0	0	0	0	0	0	0	0	0	0	0	90.1696	0.0000	0.0000	0.0449;
	386	7.61	0	0	0	1.08555	7.6	1	7.61	7.61	0	0	0	0	0	0	0	0	0	0	0	94.0072	0.0000	0.0000	0.0000;
	846	0.02	0.02	0.02	0.02	1.07424	0	1	0.02	0.02	0	0	0	0	0	0	0	0	0	0	0	92.4459	0.0000	0.0000	0.7630;
	1007	3.519	0.58	0.58	0.58	1.08685	3.6	1	3.519	3.519	0	0	0	0	0	0	0	0	0	0	0	91.5495	0.0000	0.0651	0.0000;
	1873	9.724	3.466	3.466	3.466	1.07795	10.3	1	9.724	9.724	0	0	0	0	0	0	0	0	0	0	0	91.6650	0.0000	0.0000	0.1082;
	1930	0.618	0.129	0.129	0.129	1.08357	0.6	1	0.618	0.618	0	0	0	0	0	0	0	0	0	0	0	91.0130	0.0000	0.0015	0.0000;
	2724	0	0	0	0	1.0125	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	91.6570	0.0000	0.0000	0.1515;
	2725	0	0	0	0	1.0075	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	92.0539	0.0000	0.0000	0.0920;
	2726	0	0	0	0	1.05455	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	94.9362	0.0000	0.1142	0.0000;
	2727	173.964	-23.1961	0	-83.616	0.9975	174	1	173.964	173.964	0	0	0	0	0	0	0	0	0	0	0	90.2066	0.0000	0.0000	0.0000;
	2728	80	-62.84	14.9	-62.84	1.06364	81.4	1	80	80	0	0	0	0	0	0	0	0	0	0	0	89.1329	0.0000	0.0000	1.8785;
	2729	183.534	-9.67556	0	-54.19	1.08864	183.5	1	183.534	183.534	0	0	0	0	0	0	0	0	0	0	0	93.5970	0.0000	0.0000	0.0000;
	2730	0	0	0	0	1.02	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	93.2356	0.0000	0.0000	0.7817;
	2731	80	-18.08	0	-18.08	1.1	80	1	80	80	0	0	0	0	0	0	0	0	0	0	0	86.3177	0.0000	0.0000	0.2699;
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax	Pf	Qf	Pt	Qt	mu_Sf	mu_St	mu_angmin	mu_angmax
mpc.branch = [
	7	8	0.00064	0.0305	0	400	400	400	1.0435	-0.6	1	-360	360	-123.8322	-24.5064	123.9277	29.0557	0.0000	0.0000	0.0000	0.0000;
	26	28	0.00036	0.02519	0	500	500	500	1.0911	0	1	-360	360	125.6517	-117.4898	-125.5484	124.7145	0.0000	0.0000	0.0000	0.0000;
	27	29	0.00036	0.02519	0	500	500	500	1.0759	0	1	-360	360	20.7686	-64.2700	-20.7531	65.3548	0.0000	0.0000	0.0000	0.0000;
	39	41	0.00034	0.02097	0	500	500	500	1.0793	0	1	-360	360	-9.4688	-64.0902	9.4824	64.9267	0.0000	0.0000	0.0000	0.0000;
	42	45	0.00034	0.02097	0	500	500	500	1.0296	0	1	-360	360	8.4574	18.3353	-8.4562	-18.2583	0.0000	0.0000	0.0000	0.0000;
	54	56	0.00081	0.03	0	400	400	400	1.0501	0	1	-360	360	9.6217	-2.1432	-9.6210	2.1699	0.0000	0.0000	0.0000	0.0000;
	63	65	0.00015	0.01071	0	1250	1250	1250	0.9673	0	1	-360	360	0.0688	229.7148	-0.0000	-224.8020	0.0000	0.0000	0.0000	0.0000;
	64	65	0.00015	0.01071	0	1250	1250	1250	0.9665	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	90	92	0.00075	0.02444	-0.00832	330	330	330	1.0474	0	1	-360	360	-104.6764	13.4642	104.7520	-10.0839	0.0000	0.0000	0.0000	0.0000;
	91	93	0.00075	0.02469	-0.008	330	330	330	1.0445	0	1	-360	360	-103.7203	25.9101	103.7974	-22.4890	0.0000	0.0000	0.0000	0.0000;
	125	128	0.0005	0.02875	-0.016	400	400	400	1.1172	0	1	-360	360	-85.0431	-162.9909	85.2194	174.7507	0.0000	0.0000	0.0000	0.0000;
	149	150	0.00064	0.0305	0	400	400	400	1.077	0	1	-360	360	161.5634	-51.6123	-161.3857	60.0772	0.0000	0.0000	0.0000	0.0000;
	155	157	0.000232	0.023	0	500	500	500	1.0887	0	1	-360	360	-70.5638	-23.1160	70.5762	24.3460	0.0000	0.0000	0.0000	0.0000;
	156	158	0.000232	0.023	0	500	500	500	1.0887	0	1	-360	360	-70.4654	-22.9090	70.4777	24.1338	0.0000	0.0000	0.0000	0.0000;
	169	171	0.00035	0.02375	0	500	500	500	1.0894	0	1	-360	360	20.6552	-44.5831	-20.6470	45.1375	0.0000	0.0000	0.0000	0.0000;
	183	184	0.00059	0.030919	0	400	400	400	1.0584	0	1	-360	360	-26.9450	19.2682	26.9510	-18.9549	0.0000	0.0000	0.0000	0.0000;
	190	192	0.0004	0.03	0	500	500	500	1.0855	3.6	1	-360	360	89.0660	-49.5506	-89.0253	52.6031	0.0000	0.0000	0.0000	0.0000;
	2727	157	0.00031	0.00338	0.0992	1386	1386	1386	0	0	1	-360	360	88.1488	-12.2330	-88.1255	2.1473	0.0000	0.0000	0.0000	0.0000;
	2727	158	0.00031	0.00338	0.0992	1386	1386	1386	0	0	1	-360	360	85.8152	-10.9631	-85.7932	0.8642	0.0000	0.0000	0.0000	0.0000;
	2728	68	0.014341	0.083531	0.126034	385	385	385	0	0	1	-360	360	80.0000	-62.8400	-78.7904	55.2004	0.0000	0.0000	0.0000	0.0000;
	2726	76	0.01219	0.070659	0.117418	412	412	412	0	0	1	-360	360	-35.5004	-9.4040	35.6340	-3.4714	0.0000	0.0000	0.0000	0.0000;
	2726	105	0.011781	0.07087	0.116838	412	412	412	0	0	1	-360	360	-147.9996	-1.2510	150.2348	0.9751	0.0000	0.0000	0.0000	0.0000;
	127	2725	0.001525	0.016837	0.50576	1386	1386	1386	0	0	1	-360	360	289.6819	-18.3436	-288.4780	-21.9320	0.0000	0.0000	0.0000	0.0000;
	2729	148	0.001651	0.015909	0.046948	316	316	316	0	0	1	-360	360	91.0385	-4.4927	-90.9248	-0.0612	0.0000	0.0000	0.0000	0.0000;
	2729	149	0.001651	0.015909	0.046948	316	316	316	0	0	1	-360	360	92.4955	-5.1829	-92.3782	0.6643	0.0000	0.0000	0.0000	0.0000;
	2730	47	0.00188	0.02287	0.6432	831	831	831	0	0	1	-360	360	-117.7105	-71.2178	117.9817	5.8266	0.0000	0.0000	0.0000	0.0000;
	2730	48	0.00188	0.02287	0.6432	831	831	831	0	0	1	-360	360	-117.3745	-71.2692	117.6443	5.8616	0.0000	0.0000	0.0000	0.0000;
	82	2724	0.002769	0.031162	0.89824	1386	1386	1386	0	0	1	-360	360	189.4520	-42.3138	-188.5300	-43.7340	0.0000	0.0000	0.0000	0.0000;
	42	23	0.01345	0.081141	0.141134	339	339	339	0	0	1	-360	360	80.9112	1.1067	-80.1522	-12.8887	0.0000	0.0000	0.0000	0.0000;
	26	90	0.009091	0.062401	0.111417	453	453	453	0	0	1	-360	360	163.0555	-9.7889	-161.0870	9.7131	0.0000	0.0000	0.0000	0.0000;
	27	91	0.00868	0.06405	0.096994	427	427	427	0	0	1	-360	360	111.8605	-5.7155	-110.9749	0.4306	0.0000	0.0000	0.0000	0.0000;
	146	30	0.016961	0.123659	0.196988	316	316	316	0	0	1	-360	360	47.0203	2.6468	-46.6802	-23.4821	0.0000	0.0000	0.0000	0.0000;
	135	33	0.00512	0.02618	0.029621	301	301	301	0	0	1	-360	360	-59.7921	18.3410	59.9603	-21.0662	0.0000	0.0000	0.0000	0.0000;
	134	20	0.01068	0.061961	0.094961	385	385	385	0	0	1	-360	360	-91.8018	13.0786	92.5755	-20.0974	0.0000	0.0000	0.0000	0.0000;
	164	21	0.014651	0.105891	0.170852	316	316	316	0	0	1	-360	360	52.5358	2.6392	-52.1816	-20.4302	0.0000	0.0000	0.0000	0.0000;
	40	109	0.01488	0.08161	0.114805	314	314	314	0	0	1	-360	360	-12.2235	12.3867	12.2874	-25.9460	0.0000	0.0000	0.0000	0.0000;
	39	91	0.011159	0.07231	0.103673	324	324	324	0	0	1	-360	360	-74.8496	17.2411	75.4103	-26.2375	0.0000	0.0000	0.0000	0.0000;
	178	83	0.005517	0.059484	0.170775	316	316	316	0	0	1	-360	360	-18.4998	-4.7562	18.5166	-16.0636	0.0000	0.0000	0.0000	0.0000;
	203	165	0.01176	0.068289	0.102802	324	324	324	0	0	1	-360	360	-176.3179	-2.2636	179.4656	8.3419	0.0000	0.0000	0.0000	0.0000;
	194	165	0.016818	0.089091	0.129935	358	358	358	0	0	1	-360	360	-151.8920	18.4926	155.2483	-16.3171	0.0000	0.0000	0.0000	0.0000;
	193	164	0.013843	0.087025	0.134842	383	383	383	0	0	1	-360	360	-157.3422	14.5843	160.2802	-12.3075	0.0000	0.0000	0.0000	0.0000;
	207	167	0.01676	0.097169	0.148685	269	269	269	0	0	1	-360	360	-76.6690	2.9086	77.4962	-16.3082	0.0000	0.0000	0.0000	0.0000;
	42	10	0.01269	0.074979	0.130196	351	351	351	0	0	1	-360	360	85.6346	-1.3025	-84.8388	-9.1245	0.0000	0.0000	0.0000	0.0000;
	198	18	0.014091	0.10413	0.15972	316	316	316	0	0	1	-360	360	-65.5782	-2.1061	66.1122	-12.3458	0.0000	0.0000	0.0000	0.0000;
	100	54	0.003719	0.0438	0.100962	457	457	457	0	0	1	-360	360	-41.4439	5.2317	41.5006	-16.7631	0.0000	0.0000	0.0000	0.0000;
	162	82	0.00194	0.02056	0.51584	1178	1178	1178	0	0	1	-360	360	-151.6198	-14.6729	152.0368	-36.5318	0.0000	0.0000	0.0000	0.0000;
	44	9	0.0015	0.01506	0.4032	1386	1386	1386	0	0	1	-360	360	204.6783	10.7691	-204.0930	-48.9986	0.0000	0.0000	0.0000	0.0000;
	185	150	0.00294	0.03463	0.9216	693	693	693	0	0	1	-360	360	-303.9216	-3.5531	306.5132	-64.5414	0.0000	0.0000	0.0000	0.0000;
	121	56	0.00169	0.01994	0.50624	831	831	831	0	0	1	-360	360	-18.0382	-19.9642	18.0441	-35.4098	0.0000	0.0000	0.0000	0.0000;
	29	93	0.00137	0.01625	0.41184	1386	1386	1386	0	0	1	-360	360	201.6293	-59.7545	-201.1017	20.8870	0.0000	0.0000	0.0000	0.0000;
	28	123	0.00231	0.02769	0.70144	1386	1386	1386	0	0	1	-360	360	253.1809	-44.3135	-251.8240	-15.8774	0.0000	0.0000	0.0000	0.0000;
	25	192	0.00207	0.02474	0.664	1386	1386	1386	0	0	1	-360	360	372.7822	6.8227	-370.0821	-45.2758	0.0000	0.0000	0.0000	0.0000;
	120	63	0.0015	0.01788	0.4512	831	831	831	0	0	1	-360	360	73.5364	25.5690	-73.4278	-73.2927	0.0000	0.0000	0.0000	0.0000;
	122	63	0.00469	0.05544	1.4048	831	831	831	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	82	31	0.00331	0.03425	0.85888	977	977	977	0	0	1	-360	360	-81.9980	-60.7472	82.2106	-30.4167	0.0000	0.0000	0.0000	0.0000;
	92	28	0.00219	0.02369	0.59584	1178	1178	1178	0	0	1	-360	360	-136.8646	-1.8959	137.2567	-59.1493	0.0000	0.0000	0.0000	0.0000;
	12	4	0.01674	0.09711	0.144232	427	427	427	0	0	1	-360	360	-136.5227	-6.0973	139.2408	4.8932	0.0000	0.0000	0.0000	0.0000;
	30	11	0.0057	0.0407	0.06021	316	316	316	0	0	1	-360	360	-10.3324	11.5832	10.3489	-18.4121	0.0000	0.0000	0.0000	0.0000;
	24	4	0.004419	0.032229	0.049852	383	383	383	0	0	1	-360	360	63.4276	4.3521	-63.2793	-9.3048	0.0000	0.0000	0.0000	0.0000;
	17	7	0.014591	0.11219	0.165528	383	383	383	0	0	1	-360	360	-64.3397	-2.3683	64.8687	-12.7591	0.0000	0.0000	0.0000	0.0000;
	21	10	0.01211	0.087419	0.140166	316	316	316	0	0	1	-360	360	-3.9877	5.5224	4.0088	-21.6241	0.0000	0.0000	0.0000	0.0000;
	26	5	0.009773	0.050516	0.088959	377	377	377	0	0	1	-360	360	157.8139	-8.0706	-155.8317	7.4922	0.0000	0.0000	0.0000	0.0000;
	17	3	0.01068	0.07895	0.245194	274	274	274	0	0	1	-360	360	51.6993	-28.6704	-51.4330	2.1303	0.0000	0.0000	0.0000	0.0000;
	26	19	0.0057	0.039521	0.075533	440	440	440	0	0	1	-360	360	173.5048	-3.3576	-172.1076	3.8313	0.0000	0.0000	0.0000	0.0000;
	27	20	0.0057	0.039521	0.075533	440	440	440	0	0	1	-360	360	97.3916	1.8235	-96.9488	-7.9599	0.0000	0.0000	0.0000	0.0000;
	13	6	0.00525	0.03988	0.061952	316	316	316	0	0	1	-360	360	-4.6469	-21.6824	4.6629	14.6450	0.0000	0.0000	0.0000	0.0000;
	13	12	2.1e-05	0.000207	0	316	316	316	0	0	1	-360	360	-45.0182	-6.0516	45.0186	6.0553	0.0000	0.0000	0.0000	0.0000;
	32	13	0.00093	0.00651	0.011132	316	316	316	0	0	1	-360	360	-49.6387	-28.8240	49.6652	27.7340	0.0000	0.0000	0.0000	0.0000;
	23	11	0.00205	0.01326	0.022429	385	385	385	0	0	1	-360	360	-11.0492	-20.3503	11.0579	17.8377	0.0000	0.0000	0.0000	0.0000;
	33	5	0.007831	0.043	0.04962	301	301	301	0	0	1	-360	360	-67.9618	13.4642	68.2787	-17.7117	0.0000	0.0000	0.0000	0.0000;
	19	4	0.00293	0.01599	0.024781	324	324	324	0	0	1	-360	360	73.9596	4.0106	-73.8266	-6.2790	0.0000	0.0000	0.0000	0.0000;
	26	1	0.00155	0.01169	0.018198	633	633	633	0	0	1	-360	360	71.7962	78.8414	-71.6505	-79.9586	0.0000	0.0000	0.0000	0.0000;
	27	2	0.00155	0.01169	0.018198	633	633	633	0	0	1	-360	360	-2.6605	10.4140	2.6623	-12.6300	0.0000	0.0000	0.0000	0.0000;
	27	24	0.003841	0.028531	0.045883	392	392	392	0	0	1	-360	360	104.4949	3.6610	-104.1516	-6.7127	0.0000	0.0000	0.0000	0.0000;
	25	9	0.00298	0.03418	0.93504	831	831	831	0	0	1	-360	360	-72.8722	-53.4349	73.0191	-46.1297	0.0000	0.0000	0.0000	0.0000;
	28	25	0.00358	0.04262	1.0944	1386	1386	1386	0	0	1	-360	360	372.7651	-49.0134	-368.2055	-15.5146	0.0000	0.0000	0.0000	0.0000;
	14	29	0.00336	0.03977	1.02163	1316	1316	1316	0	0	1	-360	360	-284.8749	-38.3288	287.4228	-42.1393	0.0000	0.0000	0.0000	0.0000;
	8	15	0.00299	0.03675	0.9184	1150	1150	1150	0	0	1	-360	360	69.0528	-76.6826	-68.9018	-21.9682	0.0000	0.0000	0.0000	0.0000;
	8	14	0.00112	0.01329	0.341248	1150	1150	1150	0	0	1	-360	360	-144.5928	41.9870	144.8462	-75.8363	0.0000	0.0000	0.0000	0.0000;
	31	29	0.00075	0.009	0.22848	1150	1150	1150	0	0	1	-360	360	-206.1500	24.2332	206.4503	-45.6133	0.0000	0.0000	0.0000	0.0000;
	62	58	0.010479	0.060969	0.092047	269	269	269	0	0	1	-360	360	-8.3877	-4.6782	8.3940	-6.2216	0.0000	0.0000	0.0000	0.0000;
	60	55	0.00882	0.065641	0.100662	274	274	274	0	0	1	-360	360	-21.7506	6.2209	21.7960	-18.0737	0.0000	0.0000	0.0000	0.0000;
	67	34	0.011219	0.065581	0.098349	274	274	274	0	0	1	-360	360	-17.4212	-16.7108	17.4599	4.9087	0.0000	0.0000	0.0000	0.0000;
	50	34	0.01163	0.07031	0.105802	341	341	341	0	0	1	-360	360	7.1450	-22.6377	-7.1148	9.8971	0.0000	0.0000	0.0000	0.0000;
	58	42	0.00545	0.040211	0.066986	404	404	404	0	0	1	-360	360	-8.3866	12.9990	8.4030	-20.7966	0.0000	0.0000	0.0000	0.0000;
	59	43	0.00545	0.040211	0.066986	404	404	404	0	0	1	-360	360	-8.6994	13.1409	8.7163	-20.9357	0.0000	0.0000	0.0000	0.0000;
	59	34	0.00837	0.04868	0.073481	379	379	379	0	0	1	-360	360	-19.4904	-45.1944	19.6345	37.1386	0.0000	0.0000	0.0000	0.0000;
	68	51	0.003159	0.02076	0.03146	385	385	385	0	0	1	-360	360	47.6139	-26.8234	-47.5380	23.5244	0.0000	0.0000	0.0000	0.0000;
	51	38	0.006979	0.051961	0.079666	316	316	316	0	0	1	-360	360	22.9263	-7.6685	-22.8956	-1.7475	0.0000	0.0000	0.0000	0.0000;
	36	55	0.00374	0.027831	0.042689	274	274	274	0	0	1	-360	360	-22.6564	-2.2209	22.6724	-2.8008	0.0000	0.0000	0.0000	0.0000;
	37	35	0.00769	0.057271	0.087894	316	316	316	0	0	1	-360	360	20.0628	23.5719	-19.9838	-33.4028	0.0000	0.0000	0.0000	0.0000;
	54	37	0.00556	0.04145	0.063598	383	383	383	0	0	1	-360	360	14.9894	-3.7551	-14.9791	-3.8256	0.0000	0.0000	0.0000	0.0000;
	67	36	0.004521	0.03368	0.051691	392	392	392	0	0	1	-360	360	-5.1192	13.2712	5.1302	-19.4370	0.0000	0.0000	0.0000	0.0000;
	67	66	0.00151	0.008781	0.013165	341	341	341	0	0	1	-360	360	22.5404	3.4396	-22.5339	-4.9987	0.0000	0.0000	0.0000	0.0000;
	61	42	0.00574	0.042831	0.065727	404	404	404	0	0	1	-360	360	-19.8604	12.8312	19.8930	-20.3557	0.0000	0.0000	0.0000	0.0000;
	62	43	0.00707	0.045409	0.069309	314	314	314	0	0	1	-360	360	-18.7530	11.9232	18.7893	-19.8814	0.0000	0.0000	0.0000	0.0000;
	61	39	0.01213	0.062151	0.093712	314	314	314	0	0	1	-360	360	-9.6480	-33.8913	9.7394	23.0515	0.0000	0.0000	0.0000	0.0000;
	60	40	0.002479	0.017979	0.027588	316	316	316	0	0	1	-360	360	-45.7702	-18.6468	45.8188	15.6296	0.0000	0.0000	0.0000	0.0000;
	46	39	0.002401	0.01494	0.022525	341	341	341	0	0	1	-360	360	-40.9503	1.6680	40.9833	-4.2219	0.0000	0.0000	0.0000	0.0000;
	49	45	0.00167	0.0189	0.54176	1150	1150	1150	0	0	1	-360	360	9.3221	-46.4655	-9.3165	-12.9835	0.0000	0.0000	0.0000	0.0000;
	57	53	0.00109	0.01277	0.34176	1150	1150	1150	0	0	1	-360	360	61.6274	-39.1224	-61.5854	2.1608	0.0000	0.0000	0.0000	0.0000;
	41	57	0.002259	0.026439	0.70784	1150	1150	1150	0	0	1	-360	360	-9.4824	-64.9267	9.4992	-11.7924	0.0000	0.0000	0.0000	0.0000;
	63	57	0.00094	0.01097	0.29376	1393	1393	1393	0	0	1	-360	360	-152.2099	-81.2289	152.4496	52.1480	0.0000	0.0000	0.0000	0.0000;
	47	64	0.00113	0.01406	0.37488	1386	1386	1386	0	0	1	-360	360	-242.1672	12.3254	242.7925	-44.9486	0.0000	0.0000	0.0000	0.0000;
	52	44	0.00176	0.02144	0.57344	1150	1150	1150	0	0	1	-360	360	-43.0642	-36.1659	43.0943	-26.5280	0.0000	0.0000	0.0000	0.0000;
	96	125	0.004876	0.033616	0.059609	404	404	404	0	0	1	-360	360	11.5511	3.5107	-11.5437	-10.6629	0.0000	0.0000	0.0000	0.0000;
	75	106	0.01093	0.059194	0.08439	246	246	246	0	0	1	-360	360	-0.1418	4.0389	0.1493	-14.0715	0.0000	0.0000	0.0000	0.0000;
	106	94	0.001942	0.013926	0.022845	404	404	404	0	0	1	-360	360	58.0953	-7.3888	-58.0396	5.0745	0.0000	0.0000	0.0000	0.0000;
	79	85	0.004318	0.029752	0.05264	316	316	316	0	0	1	-360	360	-7.1381	-13.7767	7.1441	7.5651	0.0000	0.0000	0.0000	0.0000;
	131	130	0.000661	0.004959	0.007579	379	379	379	0	0	1	-360	360	47.6024	-20.7543	-47.5878	19.9468	0.0000	0.0000	0.0000	0.0000;
	107	131	0.005372	0.040393	0.060055	379	379	379	0	0	1	-360	360	-89.0030	-16.7147	89.3689	12.2664	0.0000	0.0000	0.0000	0.0000;
	91	131	0.000826	0.005248	0.008683	301	301	301	0	0	1	-360	360	137.1001	-8.7212	-136.9714	8.4878	0.0000	0.0000	0.0000	0.0000;
	100	119	0.015888	0.087603	0.116818	314	314	314	0	0	1	-360	360	1.1516	8.2344	-1.1207	-22.0592	0.0000	0.0000	0.0000	0.0000;
	81	113	0.002169	0.014587	0.025749	269	269	269	0	0	1	-360	360	2.0834	2.6698	-2.0830	-5.7093	0.0000	0.0000	0.0000	0.0000;
	116	101	0.017727	0.116777	0.163611	246	246	246	0	0	1	-360	360	9.8393	-21.8969	-9.8026	2.5228	0.0000	0.0000	0.0000	0.0000;
	126	74	0.00593	0.04093	0.072145	404	404	404	0	0	1	-360	360	14.3629	0.9211	-14.3514	-9.5140	0.0000	0.0000	0.0000	0.0000;
	108	90	0.003905	0.028471	0.044983	383	383	383	0	0	1	-360	360	-152.0511	-2.1631	152.8049	2.2417	0.0000	0.0000	0.0000	0.0000;
	118	79	0.008161	0.042417	0.061197	356	356	356	0	0	1	-360	360	-12.6390	-1.0577	12.6505	-6.1311	0.0000	0.0000	0.0000	0.0000;
	119	78	0.008161	0.042417	0.061197	356	356	356	0	0	1	-360	360	-39.7561	5.7423	39.8711	-12.3901	0.0000	0.0000	0.0000	0.0000;
	79	76	0.005186	0.038388	0.058748	453	453	453	0	0	1	-360	360	207.2799	-4.2878	-205.3986	11.3010	0.0000	0.0000	0.0000	0.0000;
	78	73	0.002128	0.014029	0.022603	301	301	301	0	0	1	-360	360	118.3435	-6.8588	-118.0910	5.8518	0.0000	0.0000	0.0000	0.0000;
	114	78	0.004628	0.027748	0.046115	324	324	324	0	0	1	-360	360	-50.6060	1.5739	50.7071	-6.4190	0.0000	0.0000	0.0000	0.0000;
	103	72	0.011219	0.070744	0.115705	246	246	246	0	0	1	-360	360	-87.1542	2.5639	87.8907	-11.5173	0.0000	0.0000	0.0000	0.0000;
	110	117	0.006012	0.041467	0.073636	383	383	383	0	0	1	-360	360	-40.5635	-7.2590	40.6478	-0.8664	0.0000	0.0000	0.0000	0.0000;
	91	69	0.002066	0.012789	0.020551	269	269	269	0	0	1	-360	360	36.4813	-3.0043	-36.4586	0.6578	0.0000	0.0000	0.0000	0.0000;
	86	90	0.001364	0.009731	0.016243	453	453	453	0	0	1	-360	360	-78.5900	12.3424	78.6616	-13.7990	0.0000	0.0000	0.0000	0.0000;
	129	87	0.000579	0.004112	0.007008	404	404	404	0	0	1	-360	360	-45.6107	3.1682	45.6207	-3.9459	0.0000	0.0000	0.0000	0.0000;
	132	76	0.000847	0.00624	0.009544	457	457	457	0	0	1	-360	360	-137.0000	7.8680	137.1367	-7.9763	0.0000	0.0000	0.0000	0.0000;
	133	77	0.000847	0.00626	0.009477	457	457	457	0	0	1	-360	360	-137.0000	7.9428	137.1367	-8.0398	0.0000	0.0000	0.0000	0.0000;
	102	77	0.001591	0.011116	0.019128	453	453	453	0	0	1	-360	360	104.6588	-9.3750	-104.5090	8.1846	0.0000	0.0000	0.0000	0.0000;
	125	104	0.003141	0.021591	0.038391	404	404	404	0	0	1	-360	360	96.2519	13.0844	-96.0044	-15.9869	0.0000	0.0000	0.0000	0.0000;
	126	111	0.004545	0.03157	0.055312	316	316	316	0	0	1	-360	360	70.6429	22.1629	-70.4302	-27.2896	0.0000	0.0000	0.0000	0.0000;
	104	84	0.001446	0.009917	0.017598	316	316	316	0	0	1	-360	360	-0.2121	7.5460	0.2130	-9.6380	0.0000	0.0000	0.0000	0.0000;
	105	95	0.003822	0.026674	0.046154	316	316	316	0	0	1	-360	360	-27.5461	10.7726	27.5762	-16.0561	0.0000	0.0000	0.0000	0.0000;
	112	80	0.007769	0.041281	0.063907	269	269	269	0	0	1	-360	360	6.6883	-3.9623	-6.6854	-3.5798	0.0000	0.0000	0.0000	0.0000;
	89	78	0.004463	0.030413	0.048671	246	246	246	0	0	1	-360	360	-3.8289	-7.0569	3.8301	1.3129	0.0000	0.0000	0.0000	0.0000;
	117	108	0.005888	0.035062	0.052349	246	246	246	0	0	1	-360	360	-30.4584	-14.1680	30.5105	8.2385	0.0000	0.0000	0.0000	0.0000;
	109	99	0.003161	0.023409	0.036165	316	316	316	0	0	1	-360	360	41.8213	7.6339	-41.7726	-11.5919	0.0000	0.0000	0.0000	0.0000;
	116	79	0.001839	0.012603	0.022399	316	316	316	0	0	1	-360	360	51.6833	-1.2192	-51.6419	-1.1521	0.0000	0.0000	0.0000	0.0000;
	107	88	0.001715	0.009607	0.014239	301	301	301	0	0	1	-360	360	69.0138	27.3567	-68.9336	-28.5938	0.0000	0.0000	0.0000	0.0000;
	98	79	0.003409	0.024421	0.039969	246	246	246	0	0	1	-360	360	30.1785	6.1077	-30.1503	-10.6523	0.0000	0.0000	0.0000	0.0000;
	117	78	0.001839	0.012603	0.02239	316	316	316	0	0	1	-360	360	-40.2184	16.2648	40.2482	-18.7128	0.0000	0.0000	0.0000	0.0000;
	83	97	0.005702	0.041488	0.066172	404	404	404	0	0	1	-360	360	24.2504	11.9584	-24.2111	-19.7421	0.0000	0.0000	0.0000	0.0000;
	124	118	0.004587	0.024628	0.036165	314	314	314	0	0	1	-360	360	-25.5966	-11.4908	25.6255	7.3752	0.0000	0.0000	0.0000	0.0000;
	124	110	0.002149	0.013327	0.022109	246	246	246	0	0	1	-360	360	-11.5553	-4.0080	11.5579	1.4193	0.0000	0.0000	0.0000	0.0000;
	100	71	0.000785	0.004876	0.00726	269	269	269	0	0	1	-360	360	0.0000	-0.8796	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	101	70	0.000785	0.004876	0.007241	269	269	269	0	0	1	-360	360	0.0000	-0.8773	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	93	127	0.002413	0.027544	0.767968	831	831	831	0	0	1	-360	360	129.4169	13.5811	-128.9811	-91.6757	0.0000	0.0000	0.0000	0.0000;
	82	127	0.002131	0.024319	0.67744	1386	1386	1386	0	0	1	-360	360	87.9212	-12.2112	-87.7568	-58.4975	0.0000	0.0000	0.0000	0.0000;
	122	115	0.000913	0.0104	0.289888	1150	1150	1150	0	0	1	-360	360	40.0477	44.8588	-40.0034	-75.7004	0.0000	0.0000	0.0000	0.0000;
	123	121	0.003119	0.035631	0.991072	831	831	831	0	0	1	-360	360	107.5345	-73.1329	-107.1925	-31.2104	0.0000	0.0000	0.0000	0.0000;
	115	128	0.000919	0.010512	0.292928	1150	1150	1150	0	0	1	-360	360	-54.5815	41.3416	54.6348	-72.0517	0.0000	0.0000	0.0000	0.0000;
	173	156	0.01545	0.073349	0.126614	427	427	427	0	0	1	-360	360	-112.6408	7.8269	114.2998	-15.3096	0.0000	0.0000	0.0000	0.0000;
	174	155	0.01545	0.073349	0.126614	427	427	427	0	0	1	-360	360	-112.4183	7.8022	114.0706	-15.3160	0.0000	0.0000	0.0000	0.0000;
	176	155	0.01457	0.07955	0.14007	324	324	324	0	0	1	-360	360	-49.3498	5.7606	49.6629	-21.2178	0.0000	0.0000	0.0000	0.0000;
	177	156	0.01457	0.07955	0.14007	324	324	324	0	0	1	-360	360	-49.4698	5.7786	49.7844	-21.2281	0.0000	0.0000	0.0000	0.0000;
	176	144	0.006031	0.04401	0.069793	316	316	316	0	0	1	-360	360	27.5868	-2.2634	-27.5493	-6.0237	0.0000	0.0000	0.0000	0.0000;
	165	140	0.011031	0.08057	0.124127	404	404	404	0	0	1	-360	360	72.3929	-17.3543	-71.9068	5.8518	0.0000	0.0000	0.0000	0.0000;
	137	155	0.005831	0.04231	0.070664	383	383	383	0	0	1	-360	360	-66.9047	13.3964	67.1320	-20.4050	0.0000	0.0000	0.0000	0.0000;
	170	173	0.01849	0.095599	0.159139	305	305	305	0	0	1	-360	360	-58.8398	15.6002	59.4583	-31.7492	0.0000	0.0000	0.0000	0.0000;
	152	174	0.010581	0.053	0.088475	385	385	385	0	0	1	-360	360	-69.9204	12.1866	70.3761	-20.5671	0.0000	0.0000	0.0000	0.0000;
	154	156	0.012521	0.091359	0.145394	453	453	453	0	0	1	-360	360	-78.5011	7.0239	79.1558	-20.0517	0.0000	0.0000	0.0000	0.0000;
	136	137	0.00506	0.036539	0.063598	305	305	305	0	0	1	-360	360	-35.2642	3.0459	35.3173	-10.4798	0.0000	0.0000	0.0000	0.0000;
	148	143	0.01043	0.077891	0.122065	383	383	383	0	0	1	-360	360	18.0553	-18.2410	-18.0167	3.7738	0.0000	0.0000	0.0000	0.0000;
	153	181	0.007702	0.056917	0.086733	316	316	316	0	0	1	-360	360	33.6928	9.9993	-33.6068	-19.9105	0.0000	0.0000	0.0000	0.0000;
	153	180	0.002256	0.016674	0.02541	333	333	333	0	0	1	-360	360	-116.6199	0.2239	116.8700	-1.5000	0.0000	0.0000	0.0000	0.0000;
	175	147	0.009147	0.089554	0.215196	246	246	246	0	0	1	-360	360	-45.1188	-14.2406	45.2746	-10.1018	0.0000	0.0000	0.0000	0.0000;
	175	169	0.00244	0.01318	0.021296	341	341	341	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	169	140	0.00355	0.02593	0.041237	404	404	404	0	0	1	-360	360	-41.2173	29.2280	41.2956	-33.6902	0.0000	0.0000	0.0000	0.0000;
	170	167	0.01312	0.076219	0.116644	324	324	324	0	0	1	-360	360	92.7885	-20.2337	-91.8499	11.3688	0.0000	0.0000	0.0000	0.0000;
	169	152	0.009341	0.05225	0.087701	305	305	305	0	0	1	-360	360	-36.6061	21.7334	36.7640	-31.5229	0.0000	0.0000	0.0000	0.0000;
	146	135	0.006141	0.032521	0.052456	356	356	356	0	0	1	-360	360	-114.5280	13.6565	115.2091	-16.3970	0.0000	0.0000	0.0000	0.0000;
	147	134	0.00438	0.03188	0.050723	453	453	453	0	0	1	-360	360	-118.1800	8.5705	118.6912	-10.9878	0.0000	0.0000	0.0000	0.0000;
	164	147	0.000479	0.00331	0.005711	404	404	404	0	0	1	-360	360	-64.0287	56.1439	64.0575	-56.6355	0.0000	0.0000	0.0000	0.0000;
	165	146	0.000479	0.00331	0.005711	404	404	404	0	0	1	-360	360	-71.6938	60.2628	71.7286	-60.7128	0.0000	0.0000	0.0000	0.0000;
	154	143	0.010539	0.076859	0.122355	316	316	316	0	0	1	-360	360	46.7598	-5.6885	-46.5718	-7.8836	0.0000	0.0000	0.0000	0.0000;
	159	148	0.00469	0.034651	0.053821	383	383	383	0	0	1	-360	360	-49.6987	9.6926	49.8013	-15.4155	0.0000	0.0000	0.0000	0.0000;
	149	141	0.006469	0.0413	0.069212	383	383	383	0	0	1	-360	360	42.4971	-3.1298	-42.3999	-4.5495	0.0000	0.0000	0.0000	0.0000;
	168	141	0.00105	0.007211	0.01028	316	316	316	0	0	1	-360	360	-18.0833	-8.3999	18.0867	7.1944	0.0000	0.0000	0.0000	0.0000;
	168	159	0.006099	0.044831	0.070954	316	316	316	0	0	1	-360	360	-4.3244	-16.3899	4.3329	7.9349	0.0000	0.0000	0.0000	0.0000;
	176	136	0.002211	0.01655	0.024781	316	316	316	0	0	1	-360	360	6.7754	-4.8236	-6.7744	1.7844	0.0000	0.0000	0.0000	0.0000;
	178	177	0.005169	0.036979	0.058951	316	316	316	0	0	1	-360	360	-10.2104	1.8005	10.2160	-9.0150	0.0000	0.0000	0.0000	0.0000;
	181	173	0.002401	0.017789	0.027588	381	381	381	0	0	1	-360	360	-31.8933	5.3681	31.9146	-8.5332	0.0000	0.0000	0.0000	0.0000;
	157	138	0.00274	0.02696	0.70592	977	977	977	0	0	1	-360	360	142.8746	-96.5036	-142.2442	28.2136	0.0000	0.0000	0.0000	0.0000;
	163	139	0.0017	0.01733	0.45632	915	915	915	0	0	1	-360	360	-9.9832	3.2290	9.9970	-52.0502	0.0000	0.0000	0.0000	0.0000;
	161	162	0.00136	0.01574	0.433664	1469	1469	1469	0	0	1	-360	360	-62.2323	-17.5499	62.2816	-28.6126	0.0000	0.0000	0.0000	0.0000;
	171	151	0.00371	0.04326	1.18688	693	693	693	0	0	1	-360	360	-3.2033	-77.3444	3.2113	-48.6060	0.0000	0.0000	0.0000	0.0000;
	188	193	0.01882	0.137581	0.25381	299	299	299	0	0	1	-360	360	-68.4629	5.0639	69.2551	-29.7744	0.0000	0.0000	0.0000	0.0000;
	197	203	0.02756	0.16014	0.242871	269	269	269	0	0	1	-360	360	-43.1910	-9.5526	43.6435	-15.8697	0.0000	0.0000	0.0000	0.0000;
	189	208	0.01905	0.11132	0.167851	269	269	269	0	0	1	-360	360	-19.4764	-9.8681	19.5360	-10.2038	0.0000	0.0000	0.0000	0.0000;
	191	194	0.00795	0.05919	0.090798	316	316	316	0	0	1	-360	360	-85.7696	18.5216	86.2938	-25.4851	0.0000	0.0000	0.0000	0.0000;
	193	182	0.0018	0.021141	0.051498	633	633	633	0	0	1	-360	360	42.2744	-3.8965	-42.2474	-1.9143	0.0000	0.0000	0.0000	0.0000;
	202	204	0.00731	0.055789	0.083635	274	274	274	0	0	1	-360	360	-77.1353	19.6725	77.5426	-26.3429	0.0000	0.0000	0.0000	0.0000;
	190	201	0.00564	0.041961	0.064372	274	274	274	0	0	1	-360	360	-51.6151	35.3538	51.8122	-41.5463	0.0000	0.0000	0.0000	0.0000;
	208	183	0.0057	0.04236	0.129712	366	366	366	0	0	1	-360	360	-26.9048	3.7840	26.9450	-19.2682	0.0000	0.0000	0.0000	0.0000;
	200	184	0.00131	0.01548	0.41152	1150	1150	1150	0	0	1	-360	360	-216.6640	-54.4253	217.2603	17.7180	0.0000	0.0000	0.0000	0.0000;
	186	192	0.00224	0.02583	0.72352	831	831	831	0	0	1	-360	360	-334.5662	47.5245	337.0586	-95.6162	0.0000	0.0000	0.0000	0.0000;
	195	187	0.0021	0.02475	0.65792	1150	1150	1150	0	0	1	-360	360	8.5758	-6.0682	-8.5573	-64.8055	0.0000	0.0000	0.0000	0.0000;
	205	199	0.0015	0.01768	0.46944	831	831	831	0	0	1	-360	360	-185.8845	22.8085	186.4034	-66.4437	0.0000	0.0000	0.0000	0.0000;
	186	205	0.00133	0.01569	0.418208	831	831	831	0	0	1	-360	360	127.0407	-6.2717	-126.8374	-36.0346	0.0000	0.0000	0.0000	0.0000;
	187	206	0.00133	0.01569	0.418208	831	831	831	0	0	1	-360	360	125.9071	-6.2355	-125.7074	-36.1149	0.0000	0.0000	0.0000	0.0000;
	394	1	0.00157	0.06612	0	160	160	160	1.008	0	1	-360	360	-71.5006	-73.6463	71.6505	79.9586	0.0000	0.0000	0.0000	0.0000;
	395	2	0.00157	0.06612	0	160	160	160	0.9641	0	1	-360	360	2.6645	-12.5400	-2.6623	12.6300	0.0000	0.0000	0.0000	0.0000;
	247	246	0.001008	0.047273	0	300	300	300	1	0	1	-360	360	142.6743	-30.5120	-142.4781	39.7114	0.0000	0.0000	0.0000	0.0000;
	247	29	0.00079	0.03678	0	426	426	426	1	0	1	-360	360	227.3257	6.5120	-226.9522	10.8781	0.0000	0.0000	0.0000	0.0000;
	249	3	0.001651	0.06736	0	160	160	160	0.9823	0	1	-360	360	-41.1312	5.0488	41.1554	-4.0637	0.0000	0.0000	0.0000	0.0000;
	250	3	0.001651	0.06736	0	160	160	160	0.9881	0	1	-360	360	-10.2761	-1.8705	10.2776	1.9335	0.0000	0.0000	0.0000	0.0000;
	277	4	0.001651	0.06901	0	160	160	160	1.0185	0	1	-360	360	-34.3367	-11.2159	34.3548	11.9737	0.0000	0.0000	0.0000	0.0000;
	278	5	0.001651	0.06901	0	160	160	160	1.013	0	1	-360	360	-51.0261	-7.3956	51.0630	8.9341	0.0000	0.0000	0.0000	0.0000;
	343	6	0.001651	0.068599	0	160	160	160	1.0061	0	1	-360	360	-54.2506	-20.5713	54.2997	22.6118	0.0000	0.0000	0.0000	0.0000;
	343	6	0.001651	0.068599	0	160	160	160	1.0116	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	344	9	0.0015	0.06188	0	250	250	250	1.0583	0	1	-360	360	-82.5618	-41.3296	82.6860	46.4534	0.0000	0.0000	0.0000	0.0000;
	355	10	0.001651	0.06775	0	160	160	160	1.0069	0	1	-360	360	-54.0257	-17.2044	54.0730	19.1460	0.0000	0.0000	0.0000	0.0000;
	356	11	0.001651	0.06775	0	160	160	160	0.9989	0	1	-360	360	-48.4625	-4.9731	48.4969	6.3850	0.0000	0.0000	0.0000	0.0000;
	357	12	0.001651	0.06775	0	160	160	160	0.9986	0	1	-360	360	-48.3229	-4.4291	48.3570	5.8290	0.0000	0.0000	0.0000	0.0000;
	362	14	0.00087	0.05244	-0.02144	330	330	330	1.062	0	1	-360	360	-139.8414	-46.9415	140.0288	60.4753	0.0000	0.0000	0.0000	0.0000;
	370	15	0.00087	0.05244	-0.02144	330	330	330	1.0464	0	1	-360	360	-68.8609	-17.1641	68.9018	21.9682	0.0000	0.0000	0.0000	0.0000;
	387	17	0.00124	0.068391	0	160	160	160	0.9927	0	1	-360	360	-7.6485	-2.4625	7.6492	2.5008	0.0000	0.0000	0.0000	0.0000;
	386	18	0.00124	0.068391	0	160	160	160	1.0169	0	1	-360	360	61.1793	-37.6829	-61.1213	40.8822	0.0000	0.0000	0.0000	0.0000;
	392	19	0.001651	0.06901	0	160	160	160	1.0147	0	1	-360	360	-43.5731	-7.8264	43.6001	8.9551	0.0000	0.0000	0.0000	0.0000;
	393	20	0.001651	0.06901	0	160	160	160	1.014	0	1	-360	360	-58.8716	-9.2049	58.9206	11.2548	0.0000	0.0000	0.0000	0.0000;
	399	21	0.00155	0.06612	0	160	160	160	0.9933	0	1	-360	360	-32.8303	-3.2557	32.8448	3.8732	0.0000	0.0000	0.0000	0.0000;
	400	21	0.00157	0.06612	0	160	160	160	1	0	1	-360	360	-23.3155	-10.6587	23.3245	11.0346	0.0000	0.0000	0.0000	0.0000;
	405	23	0.001651	0.06901	0	160	160	160	1.0146	0	1	-360	360	-54.9060	-20.1492	54.9568	22.2730	0.0000	0.0000	0.0000	0.0000;
	406	23	0.001651	0.06901	0	160	160	160	1.0044	0	1	-360	360	-36.2238	-10.1000	36.2446	10.9660	0.0000	0.0000	0.0000	0.0000;
	407	24	0.00157	0.067979	0	160	160	160	0.9704	0	1	-360	360	-38.6235	0.2481	38.6428	0.5873	0.0000	0.0000	0.0000	0.0000;
	408	24	0.001651	0.06901	0	160	160	160	0.9558	0	1	-360	360	-2.0810	-1.7690	2.0811	1.7733	0.0000	0.0000	0.0000	0.0000;
	414	25	0.0015	0.06188	0	250	250	250	1.0423	0	1	-360	360	-68.2297	-5.4470	68.2955	8.1592	0.0000	0.0000	0.0000	0.0000;
	466	30	0.001651	0.06818	0	160	160	160	1.0002	0	1	-360	360	-56.9643	-9.9039	57.0127	11.8990	0.0000	0.0000	0.0000	0.0000;
	490	31	0.00137	0.06119	-0.01504	250	250	250	1.0647	0	1	-360	360	-63.8287	-0.8319	63.8799	4.7639	0.0000	0.0000	0.0000	0.0000;
	491	31	0.00137	0.06119	-0.01504	250	250	250	1.0596	0	1	-360	360	-60.0143	2.2423	60.0594	1.4196	0.0000	0.0000	0.0000	0.0000;
	546	32	0.001651	0.06901	0	160	160	160	1.0148	0	1	-360	360	-49.5911	-26.8356	49.6387	28.8240	0.0000	0.0000	0.0000	0.0000;
	575	33	0.001651	0.06901	0	160	160	160	1.0096	0	1	-360	360	-7.9999	-7.5324	8.0015	7.6020	0.0000	0.0000	0.0000	0.0000;
	576	33	0.001651	0.06901	0	160	160	160	1.0026	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	589	34	0.001401	0.0668	0	160	160	160	0.95	0	1	-360	360	30.0205	53.8946	-29.9796	-51.9444	0.0000	0.0000	0.0000	0.0000;
	589	34	0.001401	0.0668	0	160	160	160	1.005	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	594	35	0.00151	0.067151	0	160	160	160	1.0133	0	1	-360	360	-19.9642	-32.5314	19.9838	33.4028	0.0000	0.0000	0.0000	0.0000;
	614	37	0.00157	0.078081	0	160	160	160	0.9874	0	1	-360	360	-12.4403	-1.8074	12.4423	1.9102	0.0000	0.0000	0.0000	0.0000;
	618	38	0.00149	0.066159	0	160	160	160	0.9849	0	1	-360	360	-22.8891	-1.4594	22.8956	1.7475	0.0000	0.0000	0.0000	0.0000;
	666	42	0.00157	0.06775	0	160	160	160	0.9832	0	1	-360	360	-3.1934	4.2003	3.1938	-4.1844	0.0000	0.0000	0.0000	0.0000;
	668	46	0.00163	0.069461	0	160	160	160	0.9716	0	1	-360	360	-40.9279	2.6208	40.9503	-1.6680	0.0000	0.0000	0.0000	0.0000;
	670	48	0.00135	0.06052	0	250	250	250	0.9926	0	1	-360	360	-6.5326	24.3703	6.5404	-24.0226	0.0000	0.0000	0.0000	0.0000;
	697	49	0.00135	0.06052	0	250	250	250	1.0683	0	1	-360	360	9.3498	-45.2247	-9.3221	46.4655	0.0000	0.0000	0.0000	0.0000;
	698	49	0.00153	0.06156	0	250	250	250	1.0472	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	716	50	0.00157	0.066159	0	160	160	160	0.9842	0	1	-360	360	-17.4620	-6.5885	17.4665	6.7803	0.0000	0.0000	0.0000	0.0000;
	732	53	0.0014	0.06235	0	250	250	250	1.0292	0	1	-360	360	-36.6647	-5.4900	36.6823	6.2765	0.0000	0.0000	0.0000	0.0000;
	735	52	0.00139	0.05984	0	250	250	250	0.9828	0	1	-360	360	-67.8990	-24.7913	67.9672	27.7282	0.0000	0.0000	0.0000	0.0000;
	742	55	0.00145	0.068391	0	160	160	160	1.0142	0	1	-360	360	-5.4096	-27.0807	5.4191	27.5275	0.0000	0.0000	0.0000	0.0000;
	760	60	0.001651	0.06775	0	160	160	160	0.984	0	1	-360	360	-33.6306	-7.6637	33.6469	8.3326	0.0000	0.0000	0.0000	0.0000;
	759	60	0.00157	0.06775	0	160	160	160	0.9816	0	1	-360	360	-33.8590	-3.4453	33.8740	4.0933	0.0000	0.0000	0.0000	0.0000;
	770	61	0.00163	0.067831	0	160	160	160	0.9885	0	1	-360	360	-28.4142	-1.8997	28.4254	2.3643	0.0000	0.0000	0.0000	0.0000;
	769	62	0.00143	0.06831	0	160	160	160	0.9937	0	1	-360	360	-28.2125	-10.9165	28.2237	11.4501	0.0000	0.0000	0.0000	0.0000;
	779	63	0.00139	0.0608	0	250	250	250	1.0227	0	1	-360	360	8.6928	14.3467	-8.6893	-14.1903	0.0000	0.0000	0.0000	0.0000;
	780	64	0.0014	0.06235	0	250	250	250	1.0213	0	1	-360	360	8.5420	16.2805	-8.5377	-16.0883	0.0000	0.0000	0.0000	0.0000;
	808	66	0.00163	0.067539	0	160	160	160	0.9819	0	1	-360	360	-22.5267	-4.7020	22.5339	4.9987	0.0000	0.0000	0.0000	0.0000;
	833	68	0.00161	0.06762	0	160	160	160	0.9638	0	1	-360	360	-31.1527	29.3758	31.1765	-28.3771	0.0000	0.0000	0.0000	0.0000;
	855	69	0.00207	0.067771	-0.003001	160	160	160	1.0005	0	1	-360	360	-36.4358	1.7659	36.4586	-0.6578	0.0000	0.0000	0.0000	0.0000;
	885	72	0.001651	0.067979	-0.003194	160	160	160	1.0191	0	1	-360	360	-30.1848	-4.7228	30.1979	5.6410	0.0000	0.0000	0.0000	0.0000;
	902	75	0.00145	0.069211	-0.005324	160	160	160	1.0058	0	1	-360	360	-14.4903	-4.7016	14.4931	5.4746	0.0000	0.0000	0.0000	0.0000;
	1002	82	0.00156	0.06269	-0.00992	250	250	250	1.1098	0	1	-360	360	16.2980	-61.8880	-16.2331	65.5261	0.0000	0.0000	0.0000	0.0000;
	1003	82	0.00156	0.06269	-0.00992	250	250	250	1.0623	0	1	-360	360	-30.8074	3.3484	30.8212	-1.7221	0.0000	0.0000	0.0000	0.0000;
	1092	83	0.001651	0.06694	-0.003098	160	160	160	0.9968	0	1	-360	360	17.8776	-2.4281	-17.8732	2.9863	0.0000	0.0000	0.0000	0.0000;
	1093	83	0.00145	0.066531	-0.003194	160	160	160	0.9985	0	1	-360	360	24.9011	-0.3904	-24.8938	1.1188	0.0000	0.0000	0.0000	0.0000;
	1115	84	0.00145	0.0655	-0.002517	160	160	160	1.0002	0	1	-360	360	15.4010	9.1302	-15.3971	-8.6558	0.0000	0.0000	0.0000	0.0000;
	1114	85	0.00145	0.07045	-0.002517	160	160	160	1.024	0	1	-360	360	-8.0377	-10.3255	8.0399	10.7279	0.0000	0.0000	0.0000	0.0000;
	1188	88	0.00145	0.069831	-0.002323	160	160	160	0.9488	0	1	-360	360	-63.5950	-12.1350	63.6475	14.9327	0.0000	0.0000	0.0000	0.0000;
	1189	89	0.001651	0.067771	-0.002807	160	160	160	1.0287	0	1	-360	360	-9.1079	-20.1000	9.1150	20.7177	0.0000	0.0000	0.0000	0.0000;
	1234	94	0.00145	0.06736	-0.006582	160	160	160	1.02	0	1	-360	360	-10.0513	-10.6800	10.0541	11.5852	0.0000	0.0000	0.0000	0.0000;
	1233	95	0.001651	0.06694	-0.002904	160	160	160	1.0184	0	1	-360	360	-20.4030	1.1882	20.4088	-0.6081	0.0000	0.0000	0.0000	0.0000;
	1248	96	0.00145	0.068391	-0.003194	160	160	160	1.0089	0	1	-360	360	-12.6549	-15.6106	12.6599	16.2297	0.0000	0.0000	0.0000	0.0000;
	1256	100	0.001651	0.06694	-0.002323	160	160	160	0.9776	0	1	-360	360	-26.9015	9.3927	26.9124	-8.6669	0.0000	0.0000	0.0000	0.0000;
	1255	101	0.001651	0.06694	-0.003194	160	160	160	0.9792	0	1	-360	360	-23.1747	6.2690	23.1825	-5.5655	0.0000	0.0000	0.0000	0.0000;
	1287	102	0.00145	0.06756	-0.002226	160	160	160	1.0102	0	1	-360	360	3.0480	-0.8585	-3.0479	1.1248	0.0000	0.0000	0.0000	0.0000;
	1286	103	0.001651	0.06756	-0.003194	160	160	160	1.015	0	1	-360	360	14.4620	-5.1572	-14.4586	5.6679	0.0000	0.0000	0.0000	0.0000;
	1289	104	0.00145	0.066531	-0.002904	160	160	160	1.0185	0	1	-360	360	-21.9343	-7.8922	21.9410	8.5445	0.0000	0.0000	0.0000	0.0000;
	1364	105	0.001651	0.068599	-0.002904	160	160	160	1.0244	0	1	-360	360	-71.4996	-22.6759	71.5800	26.3578	0.0000	0.0000	0.0000	0.0000;
	1352	106	0.00207	0.093599	-0.003388	160	160	160	0.9852	0	1	-360	360	-14.2824	17.6681	14.2910	-16.8697	0.0000	0.0000	0.0000	0.0000;
	1354	107	0.00186	0.092771	-0.003001	160	160	160	1.031	0	1	-360	360	-19.4450	-12.0051	19.4535	12.7775	0.0000	0.0000	0.0000	0.0000;
	1389	108	0.00145	0.067151	-0.002226	160	160	160	0.9988	0	1	-360	360	-22.2729	-2.4694	22.2790	3.0185	0.0000	0.0000	0.0000	0.0000;
	1395	110	0.00145	0.0657	-0.005227	160	160	160	1.0084	0	1	-360	360	-28.9949	-4.7396	29.0056	5.8397	0.0000	0.0000	0.0000	0.0000;
	1433	111	0.00145	0.06756	-0.003485	160	160	160	1.0333	0	1	-360	360	-63.6802	-27.9761	63.7418	31.2518	0.0000	0.0000	0.0000	0.0000;
	1570	113	0.00145	0.06756	-0.002904	160	160	160	1.0142	0	1	-360	360	-52.6542	-2.1916	52.6885	4.1309	0.0000	0.0000	0.0000	0.0000;
	1630	115	0.00156	0.06269	-0.00864	250	250	250	1.0696	0	1	-360	360	-53.0619	-14.9542	53.1071	17.6916	0.0000	0.0000	0.0000	0.0000;
	1632	115	0.00156	0.06294	-0.00864	250	250	250	1.0736	0	1	-360	360	-41.4489	-14.5864	41.4777	16.6672	0.0000	0.0000	0.0000	0.0000;
	1675	116	0.00145	0.06736	-0.002226	160	160	160	1.0117	0	1	-360	360	-30.4931	-4.0660	30.5047	4.8705	0.0000	0.0000	0.0000	0.0000;
	1685	119	0.00145	0.06674	-0.006582	160	160	160	1.0132	0	1	-360	360	-27.8796	-8.7335	27.8903	9.9991	0.0000	0.0000	0.0000	0.0000;
	1791	120	0.00137	0.05988	-0.01504	250	250	250	1.0491	0	1	-360	360	-51.6521	-22.1741	51.6932	25.5951	0.0000	0.0000	0.0000	0.0000;
	1793	122	0.00137	0.06119	-0.00992	250	250	250	1.0838	0	1	-360	360	-57.7459	-23.3609	57.7966	26.6875	0.0000	0.0000	0.0000	0.0000;
	1794	123	0.00156	0.06269	-0.00992	250	250	250	1.0628	0	1	-360	360	-46.4094	-14.9793	46.4444	17.4556	0.0000	0.0000	0.0000	0.0000;
	1819	124	0.001651	0.06694	-0.003001	160	160	160	1.0129	0	1	-360	360	-37.1293	-14.2305	37.1519	15.4988	0.0000	0.0000	0.0000	0.0000;
	1839	125	0.00145	0.068599	-0.002323	160	160	160	1.0544	0	1	-360	360	-43.2384	-55.9760	43.3031	59.3059	0.0000	0.0000	0.0000	0.0000;
	1838	126	0.001651	0.06818	-0.002904	160	160	160	1.0231	0	1	-360	360	-64.1376	-11.7886	64.1969	14.5848	0.0000	0.0000	0.0000	0.0000;
	1859	129	0.00145	0.06756	-0.003775	160	160	160	0.9848	0	1	-360	360	-35.1713	28.1262	35.1947	-26.5705	0.0000	0.0000	0.0000	0.0000;
	1860	130	0.00145	0.0655	-0.002904	160	160	160	1.0018	0	1	-360	360	-57.9632	-1.2778	58.0036	3.4545	0.0000	0.0000	0.0000	0.0000;
	1930	134	0.001651	0.0625	0	160	160	160	1.0168	0	1	-360	360	-1.9357	-6.7971	1.9364	6.8230	0.0000	0.0000	0.0000	0.0000;
	1951	136	0.00145	0.06818	0	160	160	160	1.0053	0	1	-360	360	-20.4142	1.6975	20.4192	-1.4652	0.0000	0.0000	0.0000	0.0000;
	1952	136	0.001651	0.06818	0	160	160	160	1.0045	0	1	-360	360	-21.6130	3.6306	21.6194	-3.3652	0.0000	0.0000	0.0000	0.0000;
	1975	137	0.00151	0.06688	0	160	160	160	1.0066	0	1	-360	360	-31.5750	3.4643	31.5874	-2.9165	0.0000	0.0000	0.0000	0.0000;
	1977	138	0.00153	0.06206	0	250	250	250	1.083	0	1	-360	360	-68.2451	-9.0589	68.3139	11.8516	0.0000	0.0000	0.0000	0.0000;
	1978	139	0.00152	0.06206	0	250	250	250	1.0786	0	1	-360	360	-63.8726	-9.5230	63.9328	11.9808	0.0000	0.0000	0.0000	0.0000;
	1983	140	0.00151	0.06688	0	160	160	160	1.0179	0	1	-360	360	-30.5900	-26.8953	30.6113	27.8384	0.0000	0.0000	0.0000	0.0000;
	2009	141	0.00151	0.06688	0	160	160	160	0.9967	0	1	-360	360	-24.3056	2.9793	24.3131	-2.6449	0.0000	0.0000	0.0000	0.0000;
	2015	143	0.00161	0.066531	0	160	160	160	0.9983	0	1	-360	360	-31.4153	-4.4300	31.4287	4.9843	0.0000	0.0000	0.0000	0.0000;
	2016	143	0.00161	0.066531	0	160	160	160	0.9946	0	1	-360	360	-33.1452	1.4768	33.1597	-0.8746	0.0000	0.0000	0.0000	0.0000;
	2077	144	0.00145	0.06818	0	160	160	160	1.0054	0	1	-360	360	-0.6543	-0.8519	0.6544	0.8526	0.0000	0.0000	0.0000	0.0000;
	2078	144	0.00145	0.06818	0	160	160	160	1.0042	0	1	-360	360	-26.8860	-4.7534	26.8949	5.1711	0.0000	0.0000	0.0000	0.0000;
	2093	146	0.001651	0.06851	0	160	160	160	1.0561	0	1	-360	360	-8.5075	-59.9129	8.5612	62.1447	0.0000	0.0000	0.0000	0.0000;
	2092	147	0.003409	0.231401	0	80	80	80	1.0618	0	1	-360	360	-4.7852	-20.3857	4.7986	21.2987	0.0000	0.0000	0.0000	0.0000;
	2094	2092	0.01124	0.452479	0	80	80	80	0.8976	0	1	-360	360	11.4706	5.3071	-11.4568	-4.7516	0.0000	0.0000	0.0000	0.0000;
	2094	147	0.00562	0.22624	0	80	80	80	0.9407	0	1	-360	360	16.3834	-5.3071	-16.3693	5.8735	0.0000	0.0000	0.0000	0.0000;
	2104	148	0.00163	0.061359	0.004162	160	160	160	1.0179	0	1	-360	360	9.4964	-25.0272	-9.4866	24.9020	0.0000	0.0000	0.0000	0.0000;
	2146	152	0.001651	0.0593	0	160	160	160	1.0125	0	1	-360	360	-33.1363	-18.6122	33.1565	19.3363	0.0000	0.0000	0.0000	0.0000;
	2154	153	0.001651	0.0593	0	160	160	160	0.9994	0	1	-360	360	-58.5862	8.6748	58.6331	-6.9899	0.0000	0.0000	0.0000	0.0000;
	2155	154	0.001651	0.0593	0	160	160	160	0.9988	0	1	-360	360	-55.9926	6.0972	56.0351	-4.5697	0.0000	0.0000	0.0000	0.0000;
	2171	156	0.001651	0.092771	0	160	160	160	1.0143	0	1	-360	360	-3.8603	-3.2394	3.8607	3.2587	0.0000	0.0000	0.0000	0.0000;
	2172	155	0.001651	0.06694	0	160	160	160	1.0073	0	1	-360	360	1.9050	4.2153	-1.9047	-4.2036	0.0000	0.0000	0.0000	0.0000;
	2178	159	0.000289	0.061359	0.004162	160	160	160	0.9898	0	1	-360	360	-18.7906	6.4122	18.7916	-6.7150	0.0000	0.0000	0.0000	0.0000;
	2179	159	0.001651	0.068599	0	160	160	160	0.9889	0	1	-360	360	-26.5629	11.3819	26.5742	-10.9125	0.0000	0.0000	0.0000	0.0000;
	2210	161	0.00101	0.06188	-0.01984	330	330	330	1.0811	0	1	-360	360	-62.1935	-13.0520	62.2323	17.5499	0.0000	0.0000	0.0000	0.0000;
	2213	162	0.00101	0.06188	0	330	330	330	1.0904	0	1	-360	360	-43.9403	-25.8713	43.9654	27.4128	0.0000	0.0000	0.0000	0.0000;
	2214	162	0.00138	0.05931	0	250	250	250	1.0798	0	1	-360	360	-55.3147	-10.8692	55.3560	12.6437	0.0000	0.0000	0.0000	0.0000;
	2215	164	0.00163	0.070331	0	160	160	160	1.0359	0	1	-360	360	107.6052	-28.7818	-107.4322	36.2464	0.0000	0.0000	0.0000	0.0000;
	2234	167	0.001651	0.0593	0	160	160	160	0.9805	0	1	-360	360	-8.5476	1.5138	8.5486	-1.4774	0.0000	0.0000	0.0000	0.0000;
	2235	167	0.001651	0.0593	0	160	160	160	0.9865	0	1	-360	360	-5.8041	-6.3807	5.8052	6.4169	0.0000	0.0000	0.0000	0.0000;
	2236	168	0.00281	0.10601	0	100	100	100	0.9848	0	1	-360	360	-9.9730	-15.5070	9.9812	15.8174	0.0000	0.0000	0.0000	0.0000;
	2237	168	0.00281	0.10601	0	100	100	100	0.9387	0	1	-360	360	-12.4210	-8.7640	12.4265	8.9725	0.0000	0.0000	0.0000	0.0000;
	2239	170	0.001651	0.0593	0	160	160	160	0.9968	0	1	-360	360	-23.2117	2.0123	23.2190	-1.7504	0.0000	0.0000	0.0000	0.0000;
	2238	171	0.00101	0.06188	-0.01984	330	330	330	1.0796	0	1	-360	360	-12.4786	-11.3438	12.4816	13.6061	0.0000	0.0000	0.0000	0.0000;
	2239	171	0.00153	0.06206	0	250	250	250	1.0877	0	1	-360	360	-11.3618	-18.3214	11.3687	18.6008	0.0000	0.0000	0.0000	0.0000;
	2252	173	0.001651	0.066531	0	160	160	160	1.0224	0	1	-360	360	-43.5727	-34.9570	43.6173	36.7549	0.0000	0.0000	0.0000	0.0000;
	2253	174	0.001651	0.06775	0	160	160	160	1.0067	0	1	-360	360	-19.6865	-8.2061	19.6928	8.4647	0.0000	0.0000	0.0000	0.0000;
	2258	175	0.001651	0.052289	0	160	160	160	1.0211	0	1	-360	360	-45.0879	-13.2620	45.1188	14.2406	0.0000	0.0000	0.0000	0.0000;
	2320	176	0.001651	0.06818	0	160	160	160	1.0084	0	1	-360	360	-27.6937	-3.7129	27.7043	4.1482	0.0000	0.0000	0.0000	0.0000;
	2321	177	0.001651	0.06818	0	160	160	160	1.0064	0	1	-360	360	-26.5276	-0.0237	26.5371	0.4144	0.0000	0.0000	0.0000	0.0000;
	2424	178	0.001651	0.06632	0	160	160	160	1.0063	0	1	-360	360	-28.6990	-2.5073	28.7102	2.9557	0.0000	0.0000	0.0000	0.0000;
	2446	181	0.001651	0.06632	0	160	160	160	1.0088	0	1	-360	360	-38.5720	-9.5701	38.5939	10.4501	0.0000	0.0000	0.0000	0.0000;
	2445	181	0.001651	0.06632	0	160	160	160	1.0099	0	1	-360	360	-26.8961	-3.6846	26.9062	4.0923	0.0000	0.0000	0.0000	0.0000;
	2467	182	0.00155	0.065847	0	160	160	160	1.0171	0	1	-360	360	-42.2241	-0.9242	42.2474	1.9143	0.0000	0.0000	0.0000	0.0000;
	2490	185	0.00137	0.059687	0	250	250	250	1.0666	0	1	-360	360	-59.6610	-2.7572	59.7068	4.7552	0.0000	0.0000	0.0000	0.0000;
	2499	186	0.00129	0.064369	0	250	250	250	1.0441	0	1	-360	360	-47.9238	-12.3972	47.9538	13.8925	0.0000	0.0000	0.0000	0.0000;
	2500	187	0.00129	0.064369	0	250	250	250	1.047	0	1	-360	360	-42.1957	-14.6585	42.2202	15.8790	0.0000	0.0000	0.0000	0.0000;
	2503	189	0.0037	0.18657	0	120	120	120	0.9703	0	1	-360	360	-23.6206	3.3499	23.6378	-2.4811	0.0000	0.0000	0.0000	0.0000;
	2504	188	0.001591	0.066942	0	160	160	160	0.9778	0	1	-360	360	-64.2466	-4.9737	64.3015	7.2849	0.0000	0.0000	0.0000	0.0000;
	2520	190	0.00163	0.066715	0	160	160	160	0.9983	0	1	-360	360	-24.4869	-1.6152	24.4950	1.9500	0.0000	0.0000	0.0000	0.0000;
	2522	191	0.00163	0.066715	0	160	160	160	0.9938	0	1	-360	360	-23.8148	6.6184	23.8230	-6.2817	0.0000	0.0000	0.0000	0.0000;
	2521	192	0.00059	0.042063	0	330	330	330	1.1054	0	1	-360	360	-121.9214	-79.2064	122.0488	88.2888	0.0000	0.0000	0.0000	0.0000;
	2528	193	0.001591	0.067355	0	160	160	160	1.0236	0	1	-360	360	-55.7285	-12.6519	55.7729	14.5312	0.0000	0.0000	0.0000	0.0000;
	2529	194	0.001591	0.067355	0	160	160	160	1.0219	0	1	-360	360	-55.5948	-9.7209	55.6380	11.5476	0.0000	0.0000	0.0000	0.0000;
	2594	196	0.00089	0.054113	0	330	330	330	1.0253	0	1	-360	360	8.5767	-6.0133	-8.5758	6.0682	0.0000	0.0000	0.0000	0.0000;
	2595	197	0.00161	0.067562	0	160	160	160	0.9976	0	1	-360	360	-54.3245	0.6751	54.3659	1.0651	0.0000	0.0000	0.0000	0.0000;
	2596	198	0.00161	0.067562	0	160	160	160	1.0033	0	1	-360	360	-54.3602	-8.7853	54.4033	10.5933	0.0000	0.0000	0.0000	0.0000;
	2661	199	0.00059	0.042063	0	330	330	330	1.0673	0	1	-360	360	-30.2525	2.9258	30.2577	-2.5580	0.0000	0.0000	0.0000	0.0000;
	2681	202	0.002771	0.106198	0	100	100	100	1.0124	0	1	-360	360	-9.8433	-5.3852	9.8463	5.5001	0.0000	0.0000	0.0000	0.0000;
	2680	201	0.00157	0.0675	0	160	160	160	1.0168	0	1	-360	360	-15.4691	-16.0736	15.4759	16.3647	0.0000	0.0000	0.0000	0.0000;
	2698	203	0.00161	0.067355	0	160	160	160	1.0308	0	1	-360	360	-27.5709	-21.8209	27.5885	22.5570	0.0000	0.0000	0.0000	0.0000;
	2698	204	0.001651	0.066715	0	160	160	160	1.0303	0	1	-360	360	-27.5238	-21.1887	27.5414	21.8996	0.0000	0.0000	0.0000	0.0000;
	2718	205	0.00137	0.059687	0	250	250	250	1.0476	0	1	-360	360	-19.1960	-4.2506	19.2010	4.4684	0.0000	0.0000	0.0000	0.0000;
	2719	205	0.00137	0.059687	0	250	250	250	1.0496	0	1	-360	360	-19.2217	-7.6646	19.2272	7.9069	0.0000	0.0000	0.0000	0.0000;
	2721	207	0.00155	0.067975	0	160	160	160	0.997	0	1	-360	360	-42.0980	1.7029	42.1206	-0.7142	0.0000	0.0000	0.0000	0.0000;
	2722	208	0.00161	0.067748	0	160	160	160	0.9998	0	1	-360	360	-41.8937	-3.2379	41.9171	4.2234	0.0000	0.0000	0.0000	0.0000;
	2585	350	0.054463	0.101322	0.00968	76	76	76	0	0	1	-360	360	-9.5860	6.7324	9.6558	-7.6948	0.0000	0.0000	0.0000	0.0000;
	2083	293	0.023719	0.06124	0.006241	51	51	51	0	0	1	-360	360	3.2867	0.0197	-3.2846	-0.7766	0.0000	0.0000	0.0000	0.0000;
	2118	316	0.024711	0.06281	0.006411	62	62	62	0	0	1	-360	360	7.8227	2.9879	-7.8081	-3.7353	0.0000	0.0000	0.0000	0.0000;
	1929	420	0.042066	0.108603	0.011069	62	62	62	0	0	1	-360	360	4.9809	4.4934	-4.9634	-5.8175	0.0000	0.0000	0.0000	0.0000;
	2065	221	0.061818	0.105041	0.01014	59	59	59	0	0	1	-360	360	-1.5486	-1.2467	1.5500	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2378	524	0.059256	0.103967	0.010481	59	59	59	0	0	1	-360	360	-5.4494	0.7145	5.4647	-1.9663	0.0000	0.0000	0.0000	0.0000;
	1264	243	0.033058	0.080992	0.01007	120	120	120	0	0	1	-360	360	-26.1893	0.4233	26.3759	-1.2001	0.0000	0.0000	0.0000	0.0000;
	1274	440	0.021488	0.071066	0.007241	90	90	90	0	0	1	-360	360	9.9361	1.1920	-9.9180	-2.0000	0.0000	0.0000	0.0000	0.0000;
	677	381	0.047273	0.083876	0.00786	78	78	78	0	0	1	-360	360	-9.9802	5.2444	10.0350	-6.0428	0.0000	0.0000	0.0000	0.0000;
	629	406	0.074628	0.130248	0.012439	78	78	78	0	0	1	-360	360	13.6784	-9.2871	-13.5068	8.1741	0.0000	0.0000	0.0000	0.0000;
	775	464	0.052231	0.090083	0.008661	78	78	78	0	0	1	-360	360	-8.1296	3.9374	8.1689	-4.8573	0.0000	0.0000	0.0000	0.0000;
	829	1280	0.045446	0.079339	0.008521	90	90	90	0	0	1	-360	360	-6.9627	0.8194	6.9819	-1.8004	0.0000	0.0000	0.0000	0.0000;
	678	1576	0.03719	0.060331	0.006561	58	58	58	0	0	1	-360	360	-3.3451	-1.3879	3.3489	0.6167	0.0000	0.0000	0.0000	0.0000;
	742	1655	0.041322	0.139669	0.01241	90	90	90	0	0	1	-360	360	13.8121	1.6171	-13.7446	-2.8680	0.0000	0.0000	0.0000	0.0000;
	768	1362	0.023967	0.053719	0.008809	51	51	51	0	0	1	-360	360	2.8975	-2.4855	-2.8950	1.4781	0.0000	0.0000	0.0000	0.0000;
	1739	598	0.02438	0.049091	0.004709	76	76	76	0	0	1	-360	360	6.5710	8.6269	-6.5453	-9.1183	0.0000	0.0000	0.0000	0.0000;
	2204	1150	0.035537	0.066124	0.00765	90	90	90	0	0	1	-360	360	-13.1694	-3.2763	13.2228	2.4487	0.0000	0.0000	0.0000	0.0000;
	2417	1149	0.070248	0.120661	0.012901	67	67	67	0	0	1	-360	360	-2.5810	-0.3960	2.5849	-1.1676	0.0000	0.0000	0.0000	0.0000;
	2423	985	0.021488	0.027273	0.005111	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2652	2153	0.068256	0.184298	0.017981	50	50	50	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2486	2358	0.034628	0.060744	0.005711	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2687	2012	0.029174	0.051157	0.004859	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2673	2215	0.03719	0.096686	0.010159	102	102	102	0	0	1	-360	360	-42.1918	-2.8814	42.7373	3.0442	0.0000	0.0000	0.0000	0.0000;
	2609	2216	0.082066	0.200083	0.02217	102	102	102	0	0	1	-360	360	-12.5512	-15.3601	12.7990	13.2701	0.0000	0.0000	0.0000	0.0000;
	2614	2215	0.044628	0.115207	0.012049	102	102	102	0	0	1	-360	360	-40.3264	-4.5568	40.9329	4.6391	0.0000	0.0000	0.0000	0.0000;
	2562	2092	0.041322	0.087603	0.012199	87	87	87	0	0	1	-360	360	-82.9485	16.9332	85.4053	-13.2271	0.0000	0.0000	0.0000	0.0000;
	2560	1934	0.039256	0.107438	0.011081	87	87	87	0	0	1	-360	360	-28.7079	6.3261	28.9923	-6.8876	0.0000	0.0000	0.0000	0.0000;
	2579	2216	0.056281	0.183223	0.01876	123	123	123	0	0	1	-360	360	-15.0701	-21.3485	15.3791	20.0888	0.0000	0.0000	0.0000	0.0000;
	1689	791	0.038843	0.064463	0.00695	58	58	58	0	0	1	-360	360	13.6543	-0.8782	-13.5933	0.1570	0.0000	0.0000	0.0000	0.0000;
	2649	2203	0.023058	0.07438	0.007841	123	123	123	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	665	453	0.046777	0.323967	0.031511	123	123	123	0	0	1	-360	360	15.0760	-3.7784	-14.9812	0.8350	0.0000	0.0000	0.0000	0.0000;
	1292	2075	0.040496	0.050413	0.00719	57	57	57	0	0	1	-360	360	-0.4668	-1.6037	0.4673	0.7296	0.0000	0.0000	0.0000	0.0000;
	524	1214	0.057016	0.113223	0.01232	90	90	90	0	0	1	-360	360	3.8348	-1.5884	-3.8276	0.0988	0.0000	0.0000	0.0000	0.0000;
	665	464	0.016364	0.053141	0.00619	120	120	120	0	0	1	-360	360	12.7010	-2.9854	-12.6769	2.3573	0.0000	0.0000	0.0000	0.0000;
	666	253	0.056612	0.130504	0.013	78	78	78	0	0	1	-360	360	30.4449	-6.7089	-29.9678	6.3352	0.0000	0.0000	0.0000	0.0000;
	511	1018	0.009917	0.029752	0.00356	137	137	137	0	0	1	-360	360	19.0719	-1.7823	-19.0422	1.4362	0.0000	0.0000	0.0000	0.0000;
	2534	2389	0.053331	0.089256	0.009169	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	763	381	0.013967	0.045041	0.00462	123	123	123	0	0	1	-360	360	-4.7585	5.0979	4.7648	-5.6048	0.0000	0.0000	0.0000	0.0000;
	711	334	0.059917	0.101488	0.01089	78	78	78	0	0	1	-360	360	6.6500	-0.8382	-6.6272	-0.3897	0.0000	0.0000	0.0000	0.0000;
	696	453	0.07438	0.130248	0.012359	84	84	84	0	0	1	-360	360	31.3475	-5.9447	-30.7075	5.6338	0.0000	0.0000	0.0000	0.0000;
	2552	255	0.038843	0.126446	0.013	76	76	76	0	0	1	-360	360	-14.0247	3.1740	14.0980	-4.3945	0.0000	0.0000	0.0000	0.0000;
	2585	241	0.037017	0.06719	0.006389	76	76	76	0	0	1	-360	360	-12.6901	-0.5676	12.7428	-0.0620	0.0000	0.0000	0.0000	0.0000;
	729	480	0.01719	0.055703	0.005689	123	123	123	0	0	1	-360	360	-2.5379	1.9809	2.5396	-2.6278	0.0000	0.0000	0.0000	0.0000;
	829	1669	0.01405	0.042984	0.00513	114	114	114	0	0	1	-360	360	1.8707	-0.8194	-1.8702	0.2111	0.0000	0.0000	0.0000	0.0000;
	1769	710	0.021488	0.040496	0.007991	120	120	120	0	0	1	-360	360	3.0029	0.6792	-3.0010	-1.6249	0.0000	0.0000	0.0000	0.0000;
	1707	710	0.019008	0.033876	0.00697	57	57	57	0	0	1	-360	360	3.7893	-1.0861	-3.7870	0.2629	0.0000	0.0000	0.0000	0.0000;
	1593	741	0.047934	0.06281	0.01111	58	58	58	0	0	1	-360	360	-33.2298	0.3723	33.6828	-1.0953	0.0000	0.0000	0.0000	0.0000;
	761	334	0.042314	0.075289	0.007059	78	78	78	0	0	1	-360	360	-0.8091	2.2085	0.8119	-3.0230	0.0000	0.0000	0.0000	0.0000;
	2671	373	0.037273	0.130413	0.010919	69	69	69	0	0	1	-360	360	-12.8877	4.9720	12.9529	-5.9744	0.0000	0.0000	0.0000	0.0000;
	2457	337	0.076859	0.095041	0.010159	69	69	69	0	0	1	-360	360	-3.9157	4.2089	3.9413	-5.3483	0.0000	0.0000	0.0000	0.0000;
	666	471	0.056529	0.185868	0.019079	123	123	123	0	0	1	-360	360	2.8544	-4.8445	-2.8434	2.6914	0.0000	0.0000	0.0000	0.0000;
	713	449	0.028256	0.096686	0.009361	34	34	34	0	0	1	-360	360	-7.4930	-3.2587	7.5086	2.2251	0.0000	0.0000	0.0000	0.0000;
	2540	2332	0.04314	0.071901	0.00741	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	659	1022	0.019008	0.058678	0.00682	90	90	90	0	0	1	-360	360	-14.6972	-1.8097	14.7337	1.1447	0.0000	0.0000	0.0000	0.0000;
	2584	2389	0.030744	0.099173	0.01021	69	69	69	0	0	1	-360	360	3.5262	-4.6551	-3.5191	3.4239	0.0000	0.0000	0.0000	0.0000;
	2581	348	0.021397	0.067603	0.006921	19	19	19	0	0	1	-360	360	2.7054	-0.2722	-2.7040	-0.5000	0.0000	0.0000	0.0000	0.0000;
	1520	2135	0.012397	0.03719	0.004361	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	429	357	0.012231	0.028678	0.00295	133	133	133	0	0	1	-360	360	-20.2635	-2.4321	20.3085	2.2032	0.0000	0.0000	0.0000	0.0000;
	318	220	0.019587	0.063554	0.00659	133	133	133	0	0	1	-360	360	-11.5806	1.7527	11.6049	-2.4112	0.0000	0.0000	0.0000	0.0000;
	566	519	0.00686	0.022066	0.002321	133	133	133	0	0	1	-360	360	-29.5387	-7.9768	29.5955	7.8974	0.0000	0.0000	0.0000	0.0000;
	428	566	0.005537	0.018017	0.001839	133	133	133	0	0	1	-360	360	-27.6949	-7.6633	27.7356	7.5891	0.0000	0.0000	0.0000	0.0000;
	566	570	0.002727	0.009496	0.000999	133	133	133	0	0	1	-360	360	1.8031	0.3877	-1.8030	-0.5000	0.0000	0.0000	0.0000	0.0000;
	347	343	0.023554	0.061066	0.00629	120	120	120	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.7206	0.0000	0.0000	0.0000	0.0000;
	346	344	0.023388	0.061901	0.00629	120	120	120	0	0	1	-360	360	3.9109	-17.9199	-3.8441	17.3779	0.0000	0.0000	0.0000	0.0000;
	389	343	0.015446	0.044876	0.004339	120	120	120	0	0	1	-360	360	-8.2954	-3.5812	8.3062	3.1168	0.0000	0.0000	0.0000	0.0000;
	477	344	0.019669	0.059587	0.005871	120	120	120	0	0	1	-360	360	-13.9911	-5.0531	14.0286	4.4932	0.0000	0.0000	0.0000	0.0000;
	262	405	0.031818	0.058512	0.00559	90	90	90	0	0	1	-360	360	-4.8690	-2.1000	4.8765	1.4756	0.0000	0.0000	0.0000	0.0000;
	263	406	0.032562	0.06124	0.005491	90	90	90	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.6242	0.0000	0.0000	0.0000	0.0000;
	460	344	0.002479	0.007769	0.000871	137	137	137	0	0	1	-360	360	-36.4733	-9.5194	36.5040	9.5151	0.0000	0.0000	0.0000	0.0000;
	481	405	0.040579	0.076124	0.006781	90	90	90	0	0	1	-360	360	-12.7440	-4.0832	12.8073	3.4316	0.0000	0.0000	0.0000	0.0000;
	519	460	0.013967	0.043967	0.00485	137	137	137	0	0	1	-360	360	-29.6857	-8.4060	29.8023	8.2194	0.0000	0.0000	0.0000	0.0000;
	427	349	0.043058	0.07157	0.007541	90	90	90	0	0	1	-360	360	-9.9244	1.9099	9.9643	-2.6893	0.0000	0.0000	0.0000	0.0000;
	371	240	0.027364	0.059917	0.00581	90	90	90	0	0	1	-360	360	-16.6823	7.1588	16.7639	-7.6312	0.0000	0.0000	0.0000	0.0000;
	426	238	0.024554	0.079669	0.00818	133	133	133	0	0	1	-360	360	5.3180	-1.6287	-5.3115	0.7313	0.0000	0.0000	0.0000	0.0000;
	481	274	0.055537	0.121653	0.01065	90	90	90	0	0	1	-360	360	4.6300	0.0832	-4.6192	-1.2574	0.0000	0.0000	0.0000	0.0000;
	463	451	0.111818	0.190744	0.019089	90	90	90	0	0	1	-360	360	-13.7391	4.3215	13.9554	-6.1128	0.0000	0.0000	0.0000	0.0000;
	466	254	0.030826	0.100083	0.010341	133	133	133	0	0	1	-360	360	4.8403	5.2602	-4.8247	-6.3839	0.0000	0.0000	0.0000	0.0000;
	289	277	0.019669	0.064554	0.00652	133	133	133	0	0	1	-360	360	-13.0007	-1.6530	13.0281	0.9415	0.0000	0.0000	0.0000	0.0000;
	304	278	0.020909	0.06876	0.006941	133	133	133	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.8494	0.0000	0.0000	0.0000	0.0000;
	331	393	0.023636	0.077364	0.007889	120	120	120	0	0	1	-360	360	-16.4124	-0.1063	16.4646	-0.6898	0.0000	0.0000	0.0000	0.0000;
	332	331	0.002479	0.008017	0.00082	120	120	120	0	0	1	-360	360	-12.8031	1.2044	12.8064	-1.2937	0.0000	0.0000	0.0000	0.0000;
	335	260	0.04314	0.08281	0.0075	90	90	90	0	0	1	-360	360	-1.8030	-0.5000	1.8042	-0.4048	0.0000	0.0000	0.0000	0.0000;
	377	278	0.02281	0.074463	0.007589	133	133	133	0	0	1	-360	360	-18.9747	-4.4744	19.0457	3.7831	0.0000	0.0000	0.0000	0.0000;
	578	431	0.029339	0.095124	0.00992	133	133	133	0	0	1	-360	360	-0.9020	-0.2000	0.9022	-1.0209	0.0000	0.0000	0.0000	0.0000;
	390	316	0.013719	0.044554	0.00461	133	133	133	0	0	1	-360	360	0.5464	-5.1108	-0.5438	4.5580	0.0000	0.0000	0.0000	0.0000;
	339	239	0.029752	0.076859	0.00795	120	120	120	0	0	1	-360	360	-2.4249	-5.4710	2.4331	4.5977	0.0000	0.0000	0.0000	0.0000;
	386	328	0.031488	0.103471	0.01045	133	133	133	0	0	1	-360	360	34.8467	-8.9203	-34.4926	8.8930	0.0000	0.0000	0.0000	0.0000;
	387	374	0.047364	0.083141	0.007889	90	90	90	0	0	1	-360	360	5.7898	-1.5022	-5.7754	0.6331	0.0000	0.0000	0.0000	0.0000;
	374	290	0.024298	0.079752	0.008049	133	133	133	0	0	1	-360	360	30.8049	-9.5351	-30.5835	9.3506	0.0000	0.0000	0.0000	0.0000;
	391	355	0.006446	0.020248	0.002229	90	90	90	0	0	1	-360	360	-8.6229	1.0360	8.6272	-1.2759	0.0000	0.0000	0.0000	0.0000;
	419	375	0.037017	0.121322	0.0121	133	133	133	0	0	1	-360	360	9.4767	1.3170	-9.4459	-2.5752	0.0000	0.0000	0.0000	0.0000;
	536	466	0.022562	0.073223	0.0075	133	133	133	0	0	1	-360	360	-1.5532	2.3548	1.5552	-3.2067	0.0000	0.0000	0.0000	0.0000;
	586	329	0.059256	0.104554	0.00969	90	90	90	0	0	1	-360	360	1.5933	0.2222	-1.5917	-1.3171	0.0000	0.0000	0.0000	0.0000;
	466	223	0.027438	0.082636	0.009951	133	133	133	0	0	1	-360	360	1.6652	1.7810	-1.6632	-2.9099	0.0000	0.0000	0.0000	0.0000;
	465	479	0.048934	0.155041	0.01573	133	133	133	0	0	1	-360	360	1.3006	-3.2914	-1.2974	1.4990	0.0000	0.0000	0.0000	0.0000;
	455	427	0.023802	0.078099	0.007889	133	133	133	0	0	1	-360	360	-6.1294	1.6562	6.1384	-2.5099	0.0000	0.0000	0.0000	0.0000;
	292	403	0.007107	0.02281	0.00242	133	133	133	0	0	1	-360	360	-16.5295	-0.0212	16.5468	-0.1954	0.0000	0.0000	0.0000	0.0000;
	492	456	0.013719	0.04438	0.0046	137	137	137	0	0	1	-360	360	-8.1623	4.6786	8.1733	-5.1657	0.0000	0.0000	0.0000	0.0000;
	537	295	0.020909	0.052727	0.005801	120	120	120	0	0	1	-360	360	-5.6359	-6.6858	5.6493	6.0610	0.0000	0.0000	0.0000	0.0000;
	273	321	0.011157	0.030413	0.003291	133	133	133	0	0	1	-360	360	-11.8196	-4.5269	11.8353	4.1988	0.0000	0.0000	0.0000	0.0000;
	321	353	0.006686	0.019339	0.002069	137	137	137	0	0	1	-360	360	-15.8923	-6.1988	15.9094	6.0141	0.0000	0.0000	0.0000	0.0000;
	569	518	0.004554	0.014711	0.001539	133	133	133	0	0	1	-360	360	-1.8040	-1.0000	1.8042	0.8283	0.0000	0.0000	0.0000	0.0000;
	211	355	0.006281	0.019339	0.00221	137	137	137	0	0	1	-360	360	16.7431	2.8507	-16.7272	-3.0533	0.0000	0.0000	0.0000	0.0000;
	211	362	0.006198	0.019917	0.002096	137	137	137	0	0	1	-360	360	-19.4481	-4.8507	19.4699	4.6811	0.0000	0.0000	0.0000	0.0000;
	551	355	0.00438	0.010826	0.001191	133	133	133	0	0	1	-360	360	-27.0815	-6.3494	27.1114	6.2881	0.0000	0.0000	0.0000	0.0000;
	560	504	0.007273	0.020661	0.002021	120	120	120	0	0	1	-360	360	-5.3831	-0.2706	5.3850	0.0490	0.0000	0.0000	0.0000	0.0000;
	561	505	0.007273	0.020661	0.002021	120	120	120	0	0	1	-360	360	-0.6421	-1.3217	0.6423	1.0949	0.0000	0.0000	0.0000	0.0000;
	505	495	0.00562	0.017769	0.001951	133	133	133	0	0	1	-360	360	-20.7516	-2.8003	20.7735	2.6498	0.0000	0.0000	0.0000	0.0000;
	496	356	0.007438	0.019008	0.002081	133	133	133	0	0	1	-360	360	-36.1021	-7.7560	36.1919	7.7498	0.0000	0.0000	0.0000	0.0000;
	546	358	0.004298	0.026942	0.002887	120	120	120	0	0	1	-360	360	-16.4906	2.5386	16.5012	-2.8005	0.0000	0.0000	0.0000	0.0000;
	534	356	0.013636	0.033967	0.003751	120	120	120	0	0	1	-360	360	-18.7884	-7.1132	18.8369	6.8096	0.0000	0.0000	0.0000	0.0000;
	528	355	0.010826	0.02719	0.003001	120	120	120	0	0	1	-360	360	-27.4972	-6.3012	27.5734	6.1526	0.0000	0.0000	0.0000	0.0000;
	544	533	0.003876	0.009421	0.00105	120	120	120	0	0	1	-360	360	3.2198	2.2282	-3.2193	-2.3453	0.0000	0.0000	0.0000	0.0000;
	538	564	0.010165	0.025289	0.002708	120	120	120	0	0	1	-360	360	2.6431	-10.6212	-2.6326	10.3413	0.0000	0.0000	0.0000	0.0000;
	492	355	0.00157	0.005124	0.00053	133	133	133	0	0	1	-360	360	6.3593	-5.2786	-6.3584	5.2214	0.0000	0.0000	0.0000	0.0000;
	493	355	0.002066	0.006686	0.000709	133	133	133	0	0	1	-360	360	-7.4847	-2.3764	7.4858	2.2994	0.0000	0.0000	0.0000	0.0000;
	538	527	0.017934	0.048016	0.00522	120	120	120	0	0	1	-360	360	-7.8564	0.0456	7.8662	-0.6087	0.0000	0.0000	0.0000	0.0000;
	541	551	0.01405	0.039669	0.00432	133	133	133	0	0	1	-360	360	-20.7146	-4.5791	20.7705	4.2494	0.0000	0.0000	0.0000	0.0000;
	539	538	0.00438	0.010578	0.0012	120	120	120	0	0	1	-360	360	-5.4100	-1.8000	5.4113	1.6677	0.0000	0.0000	0.0000	0.0000;
	540	537	0.00438	0.010578	0.0012	120	120	120	0	0	1	-360	360	-5.4100	-1.8000	5.4113	1.6674	0.0000	0.0000	0.0000	0.0000;
	561	545	0.007273	0.017603	0.00196	120	120	120	0	0	1	-360	360	-3.4580	-6.5812	3.4615	6.3691	0.0000	0.0000	0.0000	0.0000;
	561	502	0.00124	0.003058	0.000351	120	120	120	0	0	1	-360	360	9.2535	3.4318	-9.2525	-3.4685	0.0000	0.0000	0.0000	0.0000;
	541	504	0.002066	0.006942	0.000699	133	133	133	0	0	1	-360	360	11.6986	2.0791	-11.6960	-2.1490	0.0000	0.0000	0.0000	0.0000;
	519	344	0.01405	0.044463	0.00484	133	133	133	0	0	1	-360	360	-35.7037	-9.9603	35.8733	9.9434	0.0000	0.0000	0.0000	0.0000;
	568	276	0.004876	0.015793	0.00166	120	120	120	0	0	1	-360	360	24.6133	8.6701	-24.5841	-8.7646	0.0000	0.0000	0.0000	0.0000;
	529	276	0.01314	0.034711	0.00364	120	120	120	0	0	1	-360	360	-24.5048	-8.9664	24.5841	8.7646	0.0000	0.0000	0.0000	0.0000;
	343	275	0.008678	0.028256	0.00287	120	120	120	0	0	1	-360	360	17.6021	9.1622	-17.5720	-9.3919	0.0000	0.0000	0.0000	0.0000;
	340	275	0.002066	0.005289	0.00054	120	120	120	0	0	1	-360	360	-17.4749	-9.4049	17.4820	9.3619	0.0000	0.0000	0.0000	0.0000;
	537	340	0.008099	0.019587	0.00219	120	120	120	0	0	1	-360	360	-12.5003	-7.9653	12.5159	7.7549	0.0000	0.0000	0.0000	0.0000;
	553	341	0.012479	0.032149	0.00319	120	120	120	0	0	1	-360	360	4.7420	2.2701	-4.7389	-2.6192	0.0000	0.0000	0.0000	0.0000;
	542	497	0.000413	0.001653	0.008661	109	109	109	0	0	1	-360	360	8.6405	12.0685	-8.6397	-13.0475	0.0000	0.0000	0.0000	0.0000;
	497	564	0.002521	0.007207	0.009269	120	120	120	0	0	1	-360	360	-2.6303	9.2975	2.6326	-10.3413	0.0000	0.0000	0.0000	0.0000;
	534	564	0.001372	0.003545	0.000361	120	120	120	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	357	363	0.012397	0.039174	0.004291	133	133	133	0	0	1	-360	360	-8.0435	-7.9849	8.0571	7.5386	0.0000	0.0000	0.0000	0.0000;
	520	363	0.00438	0.014132	0.001498	133	133	133	0	0	1	-360	360	-51.0693	-13.2073	51.1764	13.3823	0.0000	0.0000	0.0000	0.0000;
	352	508	0.012727	0.03562	0.003531	133	133	133	0	0	1	-360	360	-19.0432	-3.3163	19.0854	3.0367	0.0000	0.0000	0.0000	0.0000;
	560	352	0.000504	0.001488	0.00015	133	133	133	0	0	1	-360	360	-14.7142	-2.1302	14.7152	2.1163	0.0000	0.0000	0.0000	0.0000;
	547	273	0.004207	0.011653	0.001261	133	133	133	0	0	1	-360	360	-6.5886	-3.2131	6.5906	3.0769	0.0000	0.0000	0.0000	0.0000;
	505	422	0.001397	0.005868	0.031039	95	95	95	0	0	1	-360	360	16.0524	0.3555	-16.0491	-3.8311	0.0000	0.0000	0.0000	0.0000;
	355	580	0.005289	0.016942	0.001781	133	133	133	0	0	1	-360	360	6.3134	1.5722	-6.3114	-1.7683	0.0000	0.0000	0.0000	0.0000;
	357	517	0.003967	0.01281	0.00135	133	133	133	0	0	1	-360	360	12.0880	3.1233	-12.0825	-3.2590	0.0000	0.0000	0.0000	0.0000;
	526	546	0.000413	0.001901	0.009929	98	98	98	0	0	1	-360	360	-22.5412	-4.8769	22.5431	3.7577	0.0000	0.0000	0.0000	0.0000;
	533	528	0.003223	0.007934	0.000881	120	120	120	0	0	1	-360	360	-8.5621	-0.0954	8.5642	0.0012	0.0000	0.0000	0.0000	0.0000;
	548	493	0.003141	0.009917	0.001019	133	133	133	0	0	1	-360	360	-4.7790	-1.5900	4.7797	1.4764	0.0000	0.0000	0.0000	0.0000;
	508	581	0.000579	0.001744	0.000179	133	133	133	0	0	1	-360	360	-41.6254	-10.5367	41.6348	10.5449	0.0000	0.0000	0.0000	0.0000;
	544	537	0.00438	0.010661	0.001191	120	120	120	0	0	1	-360	360	-14.0388	-5.2282	14.0475	5.1149	0.0000	0.0000	0.0000	0.0000;
	553	502	0.010174	0.024628	0.002739	120	120	120	0	0	1	-360	360	-4.7420	-2.2701	4.7445	1.9685	0.0000	0.0000	0.0000	0.0000;
	550	533	0.006612	0.022314	0.00218	133	133	133	0	0	1	-360	360	-2.3140	0.4645	2.3144	-0.7092	0.0000	0.0000	0.0000	0.0000;
	550	537	0.005793	0.018934	0.00198	133	133	133	0	0	1	-360	360	-12.1120	-4.4645	12.1205	4.2689	0.0000	0.0000	0.0000	0.0000;
	535	534	0.002314	0.00686	0.000699	133	133	133	0	0	1	-360	360	-9.3203	-4.0357	9.3224	3.9632	0.0000	0.0000	0.0000	0.0000;
	538	535	0.012727	0.041322	0.004221	133	133	133	0	0	1	-360	360	6.4625	0.7545	-6.4577	-1.2143	0.0000	0.0000	0.0000	0.0000;
	520	581	0.003554	0.011397	0.001191	133	133	133	0	0	1	-360	360	41.8733	10.6573	-41.8148	-10.6049	0.0000	0.0000	0.0000	0.0000;
	353	509	0.000504	0.001488	0.00015	133	133	133	0	0	1	-360	360	-15.9094	-6.0141	15.9107	6.0008	0.0000	0.0000	0.0000	0.0000;
	522	580	0.002149	0.006942	0.000731	133	133	133	0	0	1	-360	360	-4.5080	-1.2500	4.5084	1.1683	0.0000	0.0000	0.0000	0.0000;
	521	516	0.002397	0.007851	0.00082	133	133	133	0	0	1	-360	360	-4.5080	-1.2500	4.5085	1.1584	0.0000	0.0000	0.0000	0.0000;
	561	547	0.003554	0.009917	0.00106	133	133	133	0	0	1	-360	360	6.0346	0.8711	-6.0334	-0.9869	0.0000	0.0000	0.0000	0.0000;
	560	220	0.009917	0.029752	0.003161	120	120	120	0	0	1	-360	360	17.0406	-1.1884	-17.0149	0.9112	0.0000	0.0000	0.0000	0.0000;
	538	506	0.013388	0.03876	0.004099	120	120	120	0	0	1	-360	360	21.3785	4.5534	-21.3215	-4.8490	0.0000	0.0000	0.0000	0.0000;
	503	341	0.019669	0.053554	0.005779	120	120	120	0	0	1	-360	360	0.2204	-1.6145	-0.2201	0.9692	0.0000	0.0000	0.0000	0.0000;
	506	503	0.002636	0.008512	0.000891	120	120	120	0	0	1	-360	360	12.8465	2.4990	-12.8424	-2.5855	0.0000	0.0000	0.0000	0.0000;
	545	519	0.008512	0.022066	0.00241	120	120	120	0	0	1	-360	360	-16.2645	-10.6291	16.2928	10.4300	0.0000	0.0000	0.0000	0.0000;
	552	518	0.004628	0.012314	0.001261	120	120	120	0	0	1	-360	360	0.6445	1.3567	-0.6444	-1.4976	0.0000	0.0000	0.0000	0.0000;
	549	405	0.018934	0.063554	0.00649	133	133	133	0	0	1	-360	360	-4.7780	-1.5900	4.7820	0.8620	0.0000	0.0000	0.0000	0.0000;
	527	406	0.016198	0.040174	0.004361	120	120	120	0	0	1	-360	360	-15.9812	-1.6413	16.0181	1.2385	0.0000	0.0000	0.0000	0.0000;
	518	498	0.008678	0.027851	0.002931	133	133	133	0	0	1	-360	360	-2.9628	0.0693	2.9635	-0.3953	0.0000	0.0000	0.0000	0.0000;
	519	403	0.020661	0.066446	0.006979	133	133	133	0	0	1	-360	360	19.5011	0.0389	-19.4318	-0.6046	0.0000	0.0000	0.0000	0.0000;
	546	543	0.000826	0.003719	0.019491	109	109	109	0	0	1	-360	360	25.9576	14.6893	-25.9509	-16.8722	0.0000	0.0000	0.0000	0.0000;
	343	568	0.004132	0.013314	0.001401	120	120	120	0	0	1	-360	360	28.3422	9.0129	-28.3103	-9.0701	0.0000	0.0000	0.0000	0.0000;
	531	525	0.00057	0.002314	0.0121	98	98	98	0	0	1	-360	360	-2.7050	-0.7500	2.7050	-0.6243	0.0000	0.0000	0.0000	0.0000;
	423	532	0.00057	0.002314	0.0121	98	98	98	0	0	1	-360	360	2.7050	-0.6096	-2.7050	-0.7500	0.0000	0.0000	0.0000	0.0000;
	552	529	0.004132	0.010992	0.001169	120	120	120	0	0	1	-360	360	-19.0795	-7.2567	19.0948	7.1664	0.0000	0.0000	0.0000	0.0000;
	509	362	0.003967	0.012727	0.00137	133	133	133	0	0	1	-360	360	-60.9897	-21.0008	61.1351	21.3110	0.0000	0.0000	0.0000	0.0000;
	471	334	0.033223	0.107851	0.011139	133	133	133	0	0	1	-360	360	0.4994	-3.6914	-0.4966	2.4127	0.0000	0.0000	0.0000	0.0000;
	359	297	0.02124	0.069752	0.00704	133	133	133	0	0	1	-360	360	-6.7261	0.1571	6.7346	-0.9276	0.0000	0.0000	0.0000	0.0000;
	412	345	0.068603	0.12	0.01149	90	90	90	0	0	1	-360	360	15.4537	-12.6578	-15.2200	11.7698	0.0000	0.0000	0.0000	0.0000;
	585	467	0.041744	0.076281	0.00695	90	90	90	0	0	1	-360	360	-16.8269	4.7507	16.9428	-5.3158	0.0000	0.0000	0.0000	0.0000;
	523	428	0.013719	0.03719	0.00363	120	120	120	0	0	1	-360	360	-21.3225	-6.7017	21.3839	6.4633	0.0000	0.0000	0.0000	0.0000;
	412	253	0.017769	0.03124	0.002969	90	90	90	0	0	1	-360	360	-20.8627	11.1578	20.9518	-11.3352	0.0000	0.0000	0.0000	0.0000;
	467	451	0.032397	0.095868	0.00967	90	90	90	0	0	1	-360	360	-25.7788	0.0158	25.9709	-0.5391	0.0000	0.0000	0.0000	0.0000;
	382	240	0.015041	0.030752	0.002979	90	90	90	0	0	1	-360	360	-4.4369	-2.3325	4.4402	2.0057	0.0000	0.0000	0.0000	0.0000;
	417	382	0.011818	0.019669	0.002069	90	90	90	0	0	1	-360	360	-2.6330	-1.5621	2.6339	1.3325	0.0000	0.0000	0.0000	0.0000;
	254	232	0.009174	0.029826	0.003071	133	133	133	0	0	1	-360	360	-3.7403	2.3839	3.7420	-2.7248	0.0000	0.0000	0.0000	0.0000;
	424	232	0.007851	0.025446	0.002621	133	133	133	0	0	1	-360	360	7.3520	-2.0073	-7.3480	1.7248	0.0000	0.0000	0.0000	0.0000;
	452	451	0.006364	0.020909	0.00212	133	133	133	0	0	1	-360	360	42.3766	-6.8065	-42.2739	6.9028	0.0000	0.0000	0.0000	0.0000;
	523	437	0.022397	0.039256	0.00372	90	90	90	0	0	1	-360	360	6.1397	2.1032	-6.1310	-2.5000	0.0000	0.0000	0.0000	0.0000;
	558	438	0.078678	0.139339	0.01292	90	90	90	0	0	1	-360	360	4.5236	0.5923	-4.5080	-2.0000	0.0000	0.0000	0.0000	0.0000;
	530	523	0.00595	0.01157	0.001101	90	90	90	0	0	1	-360	360	-10.1277	-3.3088	10.1338	3.1985	0.0000	0.0000	0.0000	0.0000;
	485	212	0.04719	0.082727	0.00785	90	90	90	0	0	1	-360	360	4.7028	3.0580	-4.6880	-3.8922	0.0000	0.0000	0.0000	0.0000;
	429	425	0.004959	0.014207	0.00145	120	120	120	0	0	1	-360	360	16.6575	0.4321	-16.6453	-0.5608	0.0000	0.0000	0.0000	0.0000;
	426	387	0.059256	0.191983	0.01974	133	133	133	0	0	1	-360	360	-10.9980	-0.8713	11.0619	-1.1512	0.0000	0.0000	0.0000	0.0000;
	514	240	0.002893	0.009256	0.000961	133	133	133	0	0	1	-360	360	-0.6920	-5.1656	0.6927	5.0602	0.0000	0.0000	0.0000	0.0000;
	386	384	0.003967	0.012984	0.001319	133	133	133	0	0	1	-360	360	21.9827	0.9024	-21.9659	-0.9977	0.0000	0.0000	0.0000	0.0000;
	571	384	0.017017	0.055124	0.005421	133	133	133	0	0	1	-360	360	-16.5150	0.0187	16.5559	-0.5023	0.0000	0.0000	0.0000	0.0000;
	557	554	0.011066	0.019339	0.001839	90	90	90	0	0	1	-360	360	-9.1969	1.6268	9.2056	-1.8171	0.0000	0.0000	0.0000	0.0000;
	477	294	0.009421	0.030413	0.003151	133	133	133	0	0	1	-360	360	13.0891	4.5531	-13.0731	-4.8604	0.0000	0.0000	0.0000	0.0000;
	421	349	0.060909	0.10124	0.01098	90	90	90	0	0	1	-360	360	13.6730	-2.7598	-13.5703	1.6893	0.0000	0.0000	0.0000	0.0000;
	383	386	0.006777	0.014463	0.001319	133	133	133	0	0	1	-360	360	-25.2307	0.3755	25.2687	-0.4449	0.0000	0.0000	0.0000	0.0000;
	421	383	0.006529	0.012066	0.00129	90	90	90	0	0	1	-360	360	-16.9190	2.2598	16.9357	-2.3755	0.0000	0.0000	0.0000	0.0000;
	387	385	0.039669	0.128603	0.01323	133	133	133	0	0	1	-360	360	0.7968	5.1160	-0.7846	-6.5684	0.0000	0.0000	0.0000	0.0000;
	385	339	0.023141	0.055868	0.00629	120	120	120	0	0	1	-360	360	-10.0354	3.0684	10.0587	-3.7171	0.0000	0.0000	0.0000	0.0000;
	558	339	0.053223	0.135124	0.013741	120	120	120	0	0	1	-360	360	1.9682	-3.2195	-1.9635	1.6944	0.0000	0.0000	0.0000	0.0000;
	501	339	0.039421	0.127686	0.01323	133	133	133	0	0	1	-360	360	11.1354	-6.3940	-11.0803	5.0937	0.0000	0.0000	0.0000	0.0000;
	319	375	0.020174	0.06405	0.006749	133	133	133	0	0	1	-360	360	2.3485	-0.5917	-2.3475	-0.1595	0.0000	0.0000	0.0000	0.0000;
	391	223	0.035289	0.108182	0.010999	90	90	90	0	0	1	-360	360	4.6559	-2.7360	-4.6478	1.5099	0.0000	0.0000	0.0000	0.0000;
	268	425	0.003314	0.010909	0.001101	133	133	133	0	0	1	-360	360	-11.4124	1.6278	11.4163	-1.7392	0.0000	0.0000	0.0000	0.0000;
	268	424	0.003471	0.011322	0.001169	133	133	133	0	0	1	-360	360	10.5104	-1.6278	-10.5070	1.5073	0.0000	0.0000	0.0000	0.0000;
	559	212	0.039091	0.06843	0.00649	90	90	90	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.7078	0.0000	0.0000	0.0000	0.0000;
	560	498	0.006529	0.017364	0.001989	120	120	120	0	0	1	-360	360	14.2457	2.5442	-14.2335	-2.7347	0.0000	0.0000	0.0000	0.0000;
	530	485	0.032893	0.057438	0.00521	90	90	90	0	0	1	-360	360	6.5207	2.5088	-6.5058	-3.0580	0.0000	0.0000	0.0000	0.0000;
	455	240	0.011653	0.042984	0.003901	90	90	90	0	0	1	-360	360	3.4254	-2.7562	-3.4235	2.3263	0.0000	0.0000	0.0000	0.0000;
	294	283	0.009008	0.029174	0.00302	133	133	133	0	0	1	-360	360	3.6071	0.6604	-3.6060	-1.0000	0.0000	0.0000	0.0000	0.0000;
	359	346	0.023141	0.075207	0.007739	133	133	133	0	0	1	-360	360	3.5701	-1.3571	-3.5673	0.4892	0.0000	0.0000	0.0000	0.0000;
	451	297	0.011744	0.037934	0.00392	133	133	133	0	0	1	-360	360	8.1475	-0.2509	-8.1406	-0.1724	0.0000	0.0000	0.0000	0.0000;
	514	319	0.006942	0.022562	0.00234	90	90	90	0	0	1	-360	360	-1.1110	4.1656	1.1122	-4.4235	0.0000	0.0000	0.0000	0.0000;
	499	240	0.003554	0.011397	0.001181	133	133	133	0	0	1	-360	360	12.1782	-2.5418	-12.1733	2.4251	0.0000	0.0000	0.0000	0.0000;
	453	452	0.006364	0.020744	0.002139	133	133	133	0	0	1	-360	360	45.3978	-6.6687	-45.2806	6.8065	0.0000	0.0000	0.0000	0.0000;
	320	318	0.006942	0.02281	0.002299	133	133	133	0	0	1	-360	360	-9.3208	2.5148	9.3266	-2.7527	0.0000	0.0000	0.0000	0.0000;
	571	397	0.019752	0.064793	0.006551	133	133	133	0	0	1	-360	360	14.7120	-0.2187	-14.6743	-0.3985	0.0000	0.0000	0.0000	0.0000;
	554	397	0.031157	0.084628	0.008429	90	90	90	0	0	1	-360	360	-14.6146	-1.1829	14.6743	0.3985	0.0000	0.0000	0.0000	0.0000;
	585	501	0.005372	0.017521	0.001769	133	133	133	0	0	1	-360	360	15.0239	-5.7507	-15.0114	5.5940	0.0000	0.0000	0.0000	0.0000;
	245	386	0.016777	0.056612	0.00575	133	133	133	0	0	1	-360	360	-4.3297	-1.2930	4.3326	0.6472	0.0000	0.0000	0.0000	0.0000;
	365	245	0.02686	0.088099	0.008901	133	133	133	0	0	1	-360	360	-2.7050	-0.8000	2.7067	-0.2070	0.0000	0.0000	0.0000	0.0000;
	345	476	0.027273	0.07157	0.007432	133	133	133	0	0	1	-360	360	0.9022	-0.3411	-0.9020	-0.5000	0.0000	0.0000	0.0000	0.0000;
	499	292	0.013719	0.044711	0.0046	133	133	133	0	0	1	-360	360	-13.9812	1.5418	14.0055	-1.9788	0.0000	0.0000	0.0000	0.0000;
	417	375	0.005446	0.017521	0.00183	133	133	133	0	0	1	-360	360	-2.7770	-0.4379	2.7774	0.2348	0.0000	0.0000	0.0000	0.0000;
	295	405	0.006198	0.017769	0.001909	120	120	120	0	0	1	-360	360	-12.8623	-8.5610	12.8752	8.3800	0.0000	0.0000	0.0000	0.0000;
	456	406	0.010744	0.034207	0.003521	137	137	137	0	0	1	-360	360	-15.8363	2.1657	15.8606	-2.4883	0.0000	0.0000	0.0000	0.0000;
	282	389	0.005702	0.018512	0.001931	133	133	133	0	0	1	-360	360	-2.7050	-1.0000	2.7054	0.7812	0.0000	0.0000	0.0000	0.0000;
	325	315	0.002231	0.007273	0.000731	120	120	120	0	0	1	-360	360	4.5678	0.4621	-4.5674	-0.5500	0.0000	0.0000	0.0000	0.0000;
	314	277	0.003058	0.009587	0.000999	120	120	120	0	0	1	-360	360	10.7678	-0.6627	-10.7650	0.5485	0.0000	0.0000	0.0000	0.0000;
	322	308	0.005793	0.016612	0.001791	120	120	120	0	0	1	-360	360	4.3695	-1.7824	-4.3685	1.5647	0.0000	0.0000	0.0000	0.0000;
	436	277	0.018017	0.046364	0.0047	120	120	120	0	0	1	-360	360	-21.5615	-2.3458	21.6306	1.9467	0.0000	0.0000	0.0000	0.0000;
	512	278	0.004628	0.014876	0.00145	120	120	120	0	0	1	-360	360	-7.9979	-6.9967	8.0021	6.8331	0.0000	0.0000	0.0000	0.0000;
	333	277	0.007107	0.022727	0.00242	133	133	133	0	0	1	-360	360	-6.9709	-2.9045	6.9742	2.6169	0.0000	0.0000	0.0000	0.0000;
	307	242	0.001066	0.00281	0.000329	120	120	120	0	0	1	-360	360	16.4333	-5.0316	-16.4308	4.9982	0.0000	0.0000	0.0000	0.0000;
	312	242	0.009917	0.026364	0.002991	120	120	120	0	0	1	-360	360	-14.3374	5.5150	14.3568	-5.8282	0.0000	0.0000	0.0000	0.0000;
	482	312	0.004628	0.013876	0.00167	120	120	120	0	0	1	-360	360	-22.7475	-2.5671	22.7674	2.4235	0.0000	0.0000	0.0000	0.0000;
	309	313	0.003719	0.011901	0.001251	120	120	120	0	0	1	-360	360	-3.8229	-1.4566	3.8234	1.3057	0.0000	0.0000	0.0000	0.0000;
	584	311	0.000579	0.001983	0.00021	120	120	120	0	0	1	-360	360	-4.2013	-1.6471	4.2014	1.6218	0.0000	0.0000	0.0000	0.0000;
	309	584	0.003058	0.009917	0.001041	120	120	120	0	0	1	-360	360	-2.5781	-1.1234	2.5783	0.9971	0.0000	0.0000	0.0000	0.0000;
	575	311	0.005289	0.016446	0.00189	123	123	123	0	0	1	-360	360	5.0497	1.9552	-5.0484	-2.1818	0.0000	0.0000	0.0000	0.0000;
	567	330	0.007364	0.023876	0.002481	120	120	120	0	0	1	-360	360	-6.5852	-1.9209	6.5880	1.6270	0.0000	0.0000	0.0000	0.0000;
	301	567	0.002149	0.006446	0.000779	120	120	120	0	0	1	-360	360	-6.7087	-2.4765	6.7096	2.3842	0.0000	0.0000	0.0000	0.0000;
	575	567	0.00562	0.018182	0.0019	120	120	120	0	0	1	-360	360	0.1244	0.2314	-0.1243	-0.4632	0.0000	0.0000	0.0000	0.0000;
	446	310	0.004876	0.012397	0.00121	120	120	120	0	0	1	-360	360	14.3626	2.6041	-14.3541	-2.7307	0.0000	0.0000	0.0000	0.0000;
	446	393	0.00595	0.017934	0.002161	120	120	120	0	0	1	-360	360	-15.9856	-3.3141	15.9985	3.0877	0.0000	0.0000	0.0000	0.0000;
	576	482	0.00405	0.012984	0.001341	120	120	120	0	0	1	-360	360	-13.9949	0.8108	14.0015	-0.9529	0.0000	0.0000	0.0000	0.0000;
	575	447	0.007521	0.022636	0.002701	120	120	120	0	0	1	-360	360	15.2672	3.6101	-15.2520	-3.8933	0.0000	0.0000	0.0000	0.0000;
	393	237	0.013876	0.036281	0.003959	120	120	120	0	0	1	-360	360	11.0877	2.3786	-11.0730	-2.8259	0.0000	0.0000	0.0000	0.0000;
	315	237	0.016612	0.047017	0.005051	120	120	120	0	0	1	-360	360	-7.0091	-1.6436	7.0160	1.0459	0.0000	0.0000	0.0000	0.0000;
	326	310	0.005041	0.016124	0.001699	120	120	120	0	0	1	-360	360	-2.3440	-0.9400	2.3443	0.7329	0.0000	0.0000	0.0000	0.0000;
	338	278	0.010578	0.028017	0.003161	120	120	120	0	0	1	-360	360	-23.9282	2.1178	23.9783	-2.3712	0.0000	0.0000	0.0000	0.0000;
	327	310	0.002636	0.008603	0.0009	120	120	120	0	0	1	-360	360	-14.0711	-4.6324	14.0759	4.5377	0.0000	0.0000	0.0000	0.0000;
	330	327	8.3e-05	0.000331	4.1e-05	120	120	120	0	0	1	-360	360	-11.7270	-3.6970	11.7271	3.6924	0.0000	0.0000	0.0000	0.0000;
	338	307	0.003388	0.01124	0.001111	120	120	120	0	0	1	-360	360	20.3222	-3.5678	-20.3103	3.4716	0.0000	0.0000	0.0000	0.0000;
	313	301	0.002231	0.006777	0.00082	120	120	120	0	0	1	-360	360	-3.8234	-1.3057	3.8237	1.2065	0.0000	0.0000	0.0000	0.0000;
	472	260	0.010661	0.032314	0.003831	120	120	120	0	0	1	-360	360	6.2257	0.9219	-6.2222	-1.3752	0.0000	0.0000	0.0000	0.0000;
	447	472	0.015793	0.047851	0.00568	120	120	120	0	0	1	-360	360	8.7600	1.2833	-8.7497	-1.9419	0.0000	0.0000	0.0000	0.0000;
	314	308	0.005702	0.013719	0.001549	120	120	120	0	0	1	-360	360	0.8611	3.4853	-0.8605	-3.6747	0.0000	0.0000	0.0000	0.0000;
	230	575	0.001322	0.004298	0.00045	11	11	11	0	0	1	-360	360	-1.5330	-0.7800	1.5330	0.7252	0.0000	0.0000	0.0000	0.0000;
	288	277	0.01876	0.051984	0.005711	120	120	120	0	0	1	-360	360	2.8440	-2.2711	-2.8422	1.5724	0.0000	0.0000	0.0000	0.0000;
	392	288	0.017107	0.046686	0.005089	120	120	120	0	0	1	-360	360	7.6311	-0.7764	-7.6230	0.1711	0.0000	0.0000	0.0000	0.0000;
	392	351	0.003388	0.010174	0.001229	120	120	120	0	0	1	-360	360	12.0883	3.1301	-12.0840	-3.2688	0.0000	0.0000	0.0000	0.0000;
	231	576	0.001322	0.004298	0.00045	11	11	11	0	0	1	-360	360	-1.5330	-0.7800	1.5330	0.7254	0.0000	0.0000	0.0000	0.0000;
	513	314	0.002562	0.008256	0.00084	120	120	120	0	0	1	-360	360	-9.1962	-1.1956	9.1980	1.0978	0.0000	0.0000	0.0000	0.0000;
	333	323	0.007686	0.024711	0.002611	120	120	120	0	0	1	-360	360	-4.4801	-1.7055	4.4815	1.3885	0.0000	0.0000	0.0000	0.0000;
	513	323	0.002562	0.008182	0.000801	120	120	120	0	0	1	-360	360	9.1962	1.1956	-9.1945	-1.2885	0.0000	0.0000	0.0000	0.0000;
	430	351	0.004793	0.014463	0.00175	120	120	120	0	0	1	-360	360	-6.5822	-1.2691	6.5840	1.0588	0.0000	0.0000	0.0000	0.0000;
	470	393	0.007851	0.025372	0.002669	120	120	120	0	0	1	-360	360	-14.2248	-4.2305	14.2388	3.9484	0.0000	0.0000	0.0000	0.0000;
	470	325	0.009091	0.030579	0.003151	120	120	120	0	0	1	-360	360	11.1598	3.0005	-11.1498	-3.3521	0.0000	0.0000	0.0000	0.0000;
	392	322	0.01281	0.041157	0.004339	120	120	120	0	0	1	-360	360	8.4339	-0.6636	-8.4265	0.1524	0.0000	0.0000	0.0000	0.0000;
	306	392	0.006124	0.019752	0.002081	120	120	120	0	0	1	-360	360	-5.7572	-2.2373	5.7591	1.9867	0.0000	0.0000	0.0000	0.0000;
	296	392	0.011983	0.038603	0.004061	120	120	120	0	0	1	-360	360	-2.8978	-1.2274	2.8987	0.7296	0.0000	0.0000	0.0000	0.0000;
	296	306	0.00562	0.018099	0.001909	120	120	120	0	0	1	-360	360	0.1028	0.0974	-0.1028	-0.3327	0.0000	0.0000	0.0000	0.0000;
	576	390	0.023802	0.072149	0.00855	120	120	120	0	0	1	-360	360	7.8629	-3.1693	-7.8494	2.1708	0.0000	0.0000	0.0000	0.0000;
	512	315	0.003876	0.012562	0.001319	120	120	120	0	0	1	-360	360	-2.5511	2.3667	2.5515	-2.5264	0.0000	0.0000	0.0000	0.0000;
	575	436	0.004959	0.014959	0.001769	120	120	120	0	0	1	-360	360	-18.5724	-1.3195	18.5865	1.1458	0.0000	0.0000	0.0000	0.0000;
	302	576	0.005041	0.015207	0.00181	120	120	120	0	0	1	-360	360	-4.5980	-1.8500	4.5990	1.6331	0.0000	0.0000	0.0000	0.0000;
	487	407	0.03	0.088678	0.00884	120	120	120	0	0	1	-360	360	-45.8393	12.4032	46.4378	-11.6417	0.0000	0.0000	0.0000	0.0000;
	432	259	0.025207	0.082231	0.00841	120	120	120	0	0	1	-360	360	-5.9830	-0.1924	5.9911	-0.7204	0.0000	0.0000	0.0000	0.0000;
	444	432	0.001488	0.004711	0.000489	120	120	120	0	0	1	-360	360	-0.7540	0.6531	0.7540	-0.7076	0.0000	0.0000	0.0000	0.0000;
	416	408	0.00843	0.021397	0.00218	120	120	120	0	0	1	-360	360	12.7083	-1.8199	-12.6958	1.6099	0.0000	0.0000	0.0000	0.0000;
	483	466	0.019504	0.035446	0.003531	90	90	90	0	0	1	-360	360	-13.9952	-4.5225	14.0321	4.1875	0.0000	0.0000	0.0000	0.0000;
	587	219	0.014876	0.026124	0.002461	90	90	90	0	0	1	-360	360	-5.2094	-1.6837	5.2133	1.4146	0.0000	0.0000	0.0000	0.0000;
	587	360	0.022636	0.037686	0.003969	90	90	90	0	0	1	-360	360	0.7014	-0.1163	-0.7013	-0.3281	0.0000	0.0000	0.0000	0.0000;
	574	332	0.014132	0.046529	0.0047	120	120	120	0	0	1	-360	360	-10.5358	1.4743	10.5491	-2.0044	0.0000	0.0000	0.0000	0.0000;
	285	235	0.004405	0.030388	0.003417	183	183	183	0	0	1	-360	360	-38.4616	-6.9061	38.5241	6.9690	0.0000	0.0000	0.0000	0.0000;
	577	468	0.016529	0.053876	0.005501	91	91	91	0	0	1	-360	360	5.6415	1.0632	-5.6369	-1.7164	0.0000	0.0000	0.0000	0.0000;
	574	450	0.017851	0.032727	0.003461	90	90	90	0	0	1	-360	360	3.3431	-4.5734	-3.3387	4.1591	0.0000	0.0000	0.0000	0.0000;
	450	420	0.030331	0.073314	0.00825	120	120	120	0	0	1	-360	360	-0.2673	-5.6591	0.2739	4.6642	0.0000	0.0000	0.0000	0.0000;
	398	420	0.00719	0.012562	0.0012	90	90	90	0	0	1	-360	360	-2.7050	-1.0000	2.7055	0.8533	0.0000	0.0000	0.0000	0.0000;
	574	300	0.017107	0.043636	0.004441	120	120	120	0	0	1	-360	360	-8.0954	0.9410	8.1048	-1.4591	0.0000	0.0000	0.0000	0.0000;
	448	300	0.03124	0.079422	0.00808	120	120	120	0	0	1	-360	360	11.7463	-1.6582	-11.7108	0.7591	0.0000	0.0000	0.0000	0.0000;
	490	457	0.01	0.026281	0.002669	120	120	120	0	0	1	-360	360	15.8764	-2.2387	-15.8557	1.9638	0.0000	0.0000	0.0000	0.0000;
	457	448	0.028017	0.061818	0.00747	120	120	120	0	0	1	-360	360	14.9537	-2.0638	-14.9023	1.2582	0.0000	0.0000	0.0000	0.0000;
	376	289	0.004132	0.013471	0.001389	133	133	133	0	0	1	-360	360	-8.0395	-0.6161	8.0417	0.4530	0.0000	0.0000	0.0000	0.0000;
	380	487	0.02595	0.085124	0.008601	133	133	133	0	0	1	-360	360	-39.7517	13.8142	40.1583	-13.4592	0.0000	0.0000	0.0000	0.0000;
	458	376	0.040413	0.132636	0.01339	133	133	133	0	0	1	-360	360	-6.7620	-1.8000	6.7775	0.2161	0.0000	0.0000	0.0000	0.0000;
	500	459	0.002562	0.00843	0.000871	133	133	133	0	0	1	-360	360	4.5085	0.9034	-4.5080	-1.0000	0.0000	0.0000	0.0000	0.0000;
	279	468	0.014132	0.037273	0.004	90	90	90	0	0	1	-360	360	1.5765	-1.2006	-1.5761	0.7164	0.0000	0.0000	0.0000	0.0000;
	445	486	0.007107	0.012479	0.001191	90	90	90	0	0	1	-360	360	-7.4876	-1.0893	7.4912	0.9647	0.0000	0.0000	0.0000	0.0000;
	488	445	0.005793	0.011744	0.00114	90	90	90	0	0	1	-360	360	-5.8627	-1.1108	5.8646	0.9893	0.0000	0.0000	0.0000	0.0000;
	489	487	0.010496	0.024471	0.002168	69	69	69	0	0	1	-360	360	-3.1560	-1.0000	3.1570	0.7560	0.0000	0.0000	0.0000	0.0000;
	465	329	0.054554	0.094711	0.00914	90	90	90	0	0	1	-360	360	9.7239	0.0786	-9.6786	-1.0391	0.0000	0.0000	0.0000	0.0000;
	434	377	0.060579	0.106033	0.01006	90	90	90	0	0	1	-360	360	-17.2792	-4.7908	17.4417	3.8744	0.0000	0.0000	0.0000	0.0000;
	444	439	0.002727	0.007851	0.000789	120	120	120	0	0	1	-360	360	0.0000	-0.0880	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	486	224	0.011983	0.038934	0.00402	120	120	120	0	0	1	-360	360	-9.0662	-0.5647	9.0752	0.1507	0.0000	0.0000	0.0000	0.0000;
	474	408	0.010744	0.034793	0.003589	114	114	114	0	0	1	-360	360	-11.6078	-0.2140	11.6208	-0.1409	0.0000	0.0000	0.0000	0.0000;
	474	224	0.009826	0.031983	0.003301	114	114	114	0	0	1	-360	360	9.8048	-0.0860	-9.7962	-0.2507	0.0000	0.0000	0.0000	0.0000;
	510	491	0.012984	0.042149	0.004361	133	133	133	0	0	1	-360	360	-21.4162	1.1795	21.4651	-1.5555	0.0000	0.0000	0.0000	0.0000;
	490	244	0.003141	0.009421	0.000961	120	120	120	0	0	1	-360	360	33.0763	-0.4293	-33.0484	0.3942	0.0000	0.0000	0.0000	0.0000;
	442	395	0.003554	0.024207	0.00271	183	183	183	0	0	1	-360	360	21.8033	-2.9345	-21.7880	2.7345	0.0000	0.0000	0.0000	0.0000;
	394	233	0.013719	0.044463	0.00461	120	120	120	0	0	1	-360	360	5.3239	-0.0337	-5.3204	-0.4716	0.0000	0.0000	0.0000	0.0000;
	443	265	0.001636	0.011116	0.001341	183	183	183	0	0	1	-360	360	31.5910	7.5303	-31.5756	-7.5759	0.0000	0.0000	0.0000	0.0000;
	395	213	0.019669	0.063802	0.006599	120	120	120	0	0	1	-360	360	20.7927	-1.8090	-20.7165	1.3175	0.0000	0.0000	0.0000	0.0000;
	234	380	0.003554	0.01157	0.00121	133	133	133	0	0	1	-360	360	-17.5484	3.9651	17.5585	-4.0700	0.0000	0.0000	0.0000	0.0000;
	404	364	0.028678	0.093141	0.009619	120	120	120	0	0	1	-360	360	-5.7893	2.9776	5.8008	-4.0391	0.0000	0.0000	0.0000	0.0000;
	233	214	0.00686	0.022149	0.002289	120	120	120	0	0	1	-360	360	2.0744	-0.5284	-2.0742	0.2729	0.0000	0.0000	0.0000	0.0000;
	416	213	0.022314	0.072479	0.0075	120	120	120	0	0	1	-360	360	-19.0203	1.1209	19.0935	-1.7175	0.0000	0.0000	0.0000	0.0000;
	582	434	0.014711	0.047686	0.004929	120	120	120	0	0	1	-360	360	-12.2999	-3.5043	12.3202	2.9908	0.0000	0.0000	0.0000	0.0000;
	582	449	0.019504	0.063314	0.006539	120	120	120	0	0	1	-360	360	8.6939	1.8043	-8.6806	-2.5251	0.0000	0.0000	0.0000	0.0000;
	579	214	0.020579	0.066942	0.006909	120	120	120	0	0	1	-360	360	-0.9020	-0.2000	0.9022	-0.5729	0.0000	0.0000	0.0000	0.0000;
	360	274	0.008512	0.027934	0.002851	120	120	120	0	0	1	-360	360	-4.2577	-1.4719	4.2592	1.1574	0.0000	0.0000	0.0000	0.0000;
	410	407	0.004876	0.015868	0.001641	120	120	120	0	0	1	-360	360	11.8825	-11.1443	-11.8713	10.9936	0.0000	0.0000	0.0000	0.0000;
	465	229	0.00843	0.027686	0.00279	120	120	120	0	0	1	-360	360	14.8303	2.9881	-14.8134	-3.2507	0.0000	0.0000	0.0000	0.0000;
	410	394	0.035289	0.137017	0.013741	120	120	120	0	0	1	-360	360	-15.9395	10.6443	16.0585	-11.7363	0.0000	0.0000	0.0000	0.0000;
	305	488	0.024298	0.078934	0.008151	120	120	120	0	0	1	-360	360	-2.7050	-1.0000	2.7067	0.1108	0.0000	0.0000	0.0000	0.0000;
	395	265	0.001818	0.012727	0.001421	183	183	183	0	0	1	-360	360	-11.7359	12.2979	11.7406	-12.4241	0.0000	0.0000	0.0000	0.0000;
	394	266	0.001744	0.012066	0.001341	183	183	183	0	0	1	-360	360	50.1181	85.4162	-49.9654	-84.5083	0.0000	0.0000	0.0000	0.0000;
	235	246	0.007884	0.053149	0.005885	183	183	183	0	0	1	-360	360	-61.0641	-29.9690	61.3999	31.5837	0.0000	0.0000	0.0000	0.0000;
	442	246	0.001074	0.00719	0.000944	229	229	229	0	0	1	-360	360	-55.6492	-5.1042	55.6791	5.1982	0.0000	0.0000	0.0000	0.0000;
	284	266	0.002562	0.022727	0.001989	183	183	183	0	0	1	-360	360	-18.3404	-51.1034	18.4104	51.5083	0.0000	0.0000	0.0000	0.0000;
	395	562	8e-06	8.3e-05	0	137	137	137	0	0	1	-360	360	10.0668	-0.6834	-10.0668	0.6835	0.0000	0.0000	0.0000	0.0000;
	562	258	0.019504	0.063141	0.006539	120	120	120	0	0	1	-360	360	10.0668	-0.3954	-10.0492	-0.2801	0.0000	0.0000	0.0000	0.0000;
	228	500	0.035702	0.11719	0.011841	120	120	120	0	0	1	-360	360	9.0433	1.2497	-9.0165	-2.5034	0.0000	0.0000	0.0000	0.0000;
	222	279	0.044297	0.093471	0.00876	90	90	90	0	0	1	-360	360	-2.6870	-1.4375	2.6899	0.3830	0.0000	0.0000	0.0000	0.0000;
	524	491	0.018934	0.062479	0.019319	133	133	133	0	0	1	-360	360	-30.7357	3.3135	30.8852	-5.1868	0.0000	0.0000	0.0000	0.0000;
	336	329	0.010992	0.023223	0.00218	90	90	90	0	0	1	-360	360	-3.6060	-0.6000	3.6073	0.3562	0.0000	0.0000	0.0000	0.0000;
	574	577	0.012149	0.039339	0.004051	120	120	120	0	0	1	-360	360	8.6242	1.3945	-8.6165	-1.8632	0.0000	0.0000	0.0000	0.0000;
	234	364	0.029091	0.09438	0.00976	120	120	120	0	0	1	-360	360	9.4344	-4.4651	-9.4078	3.4391	0.0000	0.0000	0.0000	0.0000;
	219	483	0.033876	0.059339	0.00582	90	90	90	0	0	1	-360	360	-10.3523	-4.2146	10.3892	3.6225	0.0000	0.0000	0.0000	0.0000;
	480	404	0.019826	0.06438	0.00665	120	120	120	0	0	1	-360	360	-3.6216	2.4278	3.6253	-3.1776	0.0000	0.0000	0.0000	0.0000;
	573	524	0.024215	0.079339	0.008027	133	133	133	0	0	1	-360	360	-11.9408	-0.1268	11.9692	-0.7588	0.0000	0.0000	0.0000	0.0000;
	573	279	0.022231	0.07281	0.00735	133	133	133	0	0	1	-360	360	7.8838	-0.2732	-7.8725	-0.5824	0.0000	0.0000	0.0000	0.0000;
	402	413	0.008347	0.026198	0.002921	90	90	90	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.3350	0.0000	0.0000	0.0000	0.0000;
	400	396	0.007603	0.025446	0.00249	133	133	133	0	0	1	-360	360	22.7355	1.0015	-22.7014	-1.1747	0.0000	0.0000	0.0000	0.0000;
	401	366	0.011818	0.03	0.003049	120	120	120	0	0	1	-360	360	0.5735	3.5651	-0.5720	-3.9127	0.0000	0.0000	0.0000	0.0000;
	415	367	0.016198	0.05405	0.005271	133	133	133	0	0	1	-360	360	0.5746	3.9366	-0.5720	-4.5311	0.0000	0.0000	0.0000	0.0000;
	413	269	0.019917	0.06438	0.00667	133	133	133	0	0	1	-360	360	14.5501	-1.1858	-14.5132	0.5416	0.0000	0.0000	0.0000	0.0000;
	563	298	0.010661	0.018678	0.001861	133	133	133	0	0	1	-360	360	6.4722	-0.0802	-6.4683	-0.1248	0.0000	0.0000	0.0000	0.0000;
	563	269	0.015868	0.053876	0.005329	133	133	133	0	0	1	-360	360	-10.5308	0.0863	10.5462	-0.6416	0.0000	0.0000	0.0000	0.0000;
	563	461	0.010744	0.034959	0.003611	133	133	133	0	0	1	-360	360	4.0586	-0.0061	-4.0570	-0.4000	0.0000	0.0000	0.0000	0.0000;
	316	299	0.027016	0.087438	0.009051	133	133	133	0	0	1	-360	360	3.9338	-1.4227	-3.9302	0.3305	0.0000	0.0000	0.0000	0.0000;
	264	238	0.019091	0.062727	0.00634	133	133	133	0	0	1	-360	360	-18.3223	6.7047	18.3877	-7.2017	0.0000	0.0000	0.0000	0.0000;
	379	264	0.019752	0.064959	0.006561	133	133	133	0	0	1	-360	360	-17.5379	6.9749	17.6013	-7.5047	0.0000	0.0000	0.0000	0.0000;
	469	414	0.025041	0.082231	0.00831	133	133	133	0	0	1	-360	360	-35.1694	5.6585	35.4463	-5.7109	0.0000	0.0000	0.0000	0.0000;
	225	469	0.007603	0.022984	0.00272	133	133	133	0	0	1	-360	360	-31.4954	5.9508	31.5634	-6.0585	0.0000	0.0000	0.0000	0.0000;
	401	252	0.023141	0.074132	0.00785	133	133	133	0	0	1	-360	360	2.6725	0.3143	-2.6710	-1.2138	0.0000	0.0000	0.0000	0.0000;
	435	372	0.038843	0.127603	0.012879	133	133	133	0	0	1	-360	360	18.6647	-0.1537	-18.5459	-0.9149	0.0000	0.0000	0.0000	0.0000;
	473	396	0.018347	0.060248	0.006079	133	133	133	0	0	1	-360	360	-19.4843	-1.3718	19.5454	0.8747	0.0000	0.0000	0.0000	0.0000;
	473	419	0.030331	0.099669	0.01006	133	133	133	0	0	1	-360	360	18.4023	1.1718	-18.3117	-2.0170	0.0000	0.0000	0.0000	0.0000;
	462	299	0.009752	0.029504	0.00355	133	133	133	0	0	1	-360	360	-1.9840	-0.5000	1.9843	0.0682	0.0000	0.0000	0.0000	0.0000;
	586	298	0.036777	0.063802	0.006229	90	90	90	0	0	1	-360	360	-4.2983	-0.4222	4.3043	-0.2752	0.0000	0.0000	0.0000	0.0000;
	484	241	0.021397	0.07157	0.006989	133	133	133	0	0	1	-360	360	-7.4701	5.7161	7.4875	-6.4567	0.0000	0.0000	0.0000	0.0000;
	418	399	0.001983	0.006198	0.00069	133	133	133	0	0	1	-360	360	-9.8891	-2.6942	9.8909	2.6206	0.0000	0.0000	0.0000	0.0000;
	433	399	0.00562	0.017107	0.001801	90	90	90	0	0	1	-360	360	-18.7998	0.9607	18.8172	-1.1148	0.0000	0.0000	0.0000	0.0000;
	270	401	0.003058	0.01	0.001031	133	133	133	0	0	1	-360	360	-4.0387	-2.6389	4.0393	2.5220	0.0000	0.0000	0.0000	0.0000;
	400	369	0.009587	0.030992	0.003199	133	133	133	0	0	1	-360	360	0.5801	9.6573	-0.5720	-10.0000	0.0000	0.0000	0.0000	0.0000;
	414	368	0.010661	0.034628	0.003579	133	133	133	0	0	1	-360	360	0.5746	5.0699	-0.5720	-5.4764	0.0000	0.0000	0.0000	0.0000;
	411	361	0.004298	0.012984	0.001571	133	133	133	0	0	1	-360	360	3.2156	2.0033	-3.2150	-2.1819	0.0000	0.0000	0.0000	0.0000;
	371	238	0.091653	0.159008	0.01657	90	90	90	0	0	1	-360	360	11.4533	-7.9588	-11.3055	6.3569	0.0000	0.0000	0.0000	0.0000;
	583	241	0.03124	0.104207	0.010181	133	133	133	0	0	1	-360	360	25.3740	-6.2650	-25.1893	5.7186	0.0000	0.0000	0.0000	0.0000;
	433	413	0.004793	0.016033	0.001561	133	133	133	0	0	1	-360	360	16.7258	-1.1607	-16.7141	1.0208	0.0000	0.0000	0.0000	0.0000;
	372	236	0.009174	0.03	0.00303	133	133	133	0	0	1	-360	360	7.7269	0.4149	-7.7220	-0.7394	0.0000	0.0000	0.0000	0.0000;
	236	238	0.006777	0.022149	0.002241	133	133	133	0	0	1	-360	360	4.7470	0.2394	-4.7457	-0.4866	0.0000	0.0000	0.0000	0.0000;
	299	293	0.016612	0.042984	0.004291	120	120	120	0	0	1	-360	360	-1.8411	-0.8987	1.8416	0.3766	0.0000	0.0000	0.0000	0.0000;
	415	361	0.011322	0.037769	0.003691	133	133	133	0	0	1	-360	360	1.1124	-1.8040	-1.1120	1.3819	0.0000	0.0000	0.0000	0.0000;
	414	401	0.012893	0.041157	0.004431	133	133	133	0	0	1	-360	360	9.0123	6.4332	-8.9983	-6.9014	0.0000	0.0000	0.0000	0.0000;
	435	414	0.043967	0.145289	0.014469	133	133	133	0	0	1	-360	360	-22.9927	-0.6463	23.1965	-0.3453	0.0000	0.0000	0.0000	0.0000;
	415	399	0.024554	0.074298	0.00772	120	120	120	0	0	1	-360	360	-1.6869	-2.1326	1.6882	1.2499	0.0000	0.0000	0.0000	0.0000;
	484	337	0.021653	0.072397	0.007059	133	133	133	0	0	1	-360	360	6.1181	-5.9161	-6.1053	5.1483	0.0000	0.0000	0.0000	0.0000;
	536	270	0.04405	0.133719	0.015851	133	133	133	0	0	1	-360	360	-0.7008	-3.0548	0.7027	1.2389	0.0000	0.0000	0.0000	0.0000;
	350	379	0.018256	0.03157	0.003071	90	90	90	0	0	1	-360	360	-13.4428	7.1948	13.4809	-7.4749	0.0000	0.0000	0.0000	0.0000;
	479	252	0.020496	0.066942	0.006839	133	133	133	0	0	1	-360	360	-0.6866	-1.6990	0.6870	0.9138	0.0000	0.0000	0.0000	0.0000;
	583	225	0.033388	0.10124	0.011991	133	133	133	0	0	1	-360	360	-29.1610	5.7650	29.4214	-6.3508	0.0000	0.0000	0.0000	0.0000;
	418	411	0.002727	0.008182	0.00099	133	133	133	0	0	1	-360	360	7.6351	2.5942	-7.6336	-2.7033	0.0000	0.0000	0.0000	0.0000;
	217	215	0.006942	0.022562	0.002311	133	133	133	0	0	1	-360	360	6.7997	3.7951	-6.7960	-4.0533	0.0000	0.0000	0.0000	0.0000;
	227	370	0.059917	0.116281	0.012981	90	90	90	0	0	1	-360	360	-13.6611	-4.6212	13.7654	3.3041	0.0000	0.0000	0.0000	0.0000;
	227	209	0.100413	0.177364	0.01665	90	90	90	0	0	1	-360	360	2.5484	5.2002	-2.5098	-7.0373	0.0000	0.0000	0.0000	0.0000;
	271	227	0.051984	0.09	0.008891	90	90	90	0	0	1	-360	360	-3.4422	1.0612	3.4487	-2.0791	0.0000	0.0000	0.0000	0.0000;
	280	218	0.028934	0.08719	0.0105	133	133	133	0	0	1	-360	360	-9.5641	-2.8157	9.5881	1.6681	0.0000	0.0000	0.0000	0.0000;
	515	280	0.030331	0.09124	0.010989	133	133	133	0	0	1	-360	360	-8.1921	-3.5218	8.2121	2.3157	0.0000	0.0000	0.0000	0.0000;
	257	256	0.006612	0.019917	0.002401	133	133	133	0	0	1	-360	360	-11.8968	4.0675	11.9060	-4.3137	0.0000	0.0000	0.0000	0.0000;
	572	328	0.026942	0.081901	0.009699	133	133	133	0	0	1	-360	360	-2.1397	-0.4628	2.1408	-0.6372	0.0000	0.0000	0.0000	0.0000;
	374	324	0.02	0.033802	0.003681	90	90	90	0	0	1	-360	360	-25.0295	8.9020	25.1549	-9.1075	0.0000	0.0000	0.0000	0.0000;
	226	290	0.027016	0.082149	0.009731	133	133	133	0	0	1	-360	360	-6.1254	3.8105	6.1389	-4.8731	0.0000	0.0000	0.0000	0.0000;
	378	248	0.049917	0.089669	0.008981	90	90	90	0	0	1	-360	360	-18.9672	4.1827	19.1371	-4.8896	0.0000	0.0000	0.0000	0.0000;
	478	249	0.007851	0.023876	0.002841	133	133	133	0	0	1	-360	360	-17.3355	0.4765	17.3564	-0.7345	0.0000	0.0000	0.0000	0.0000;
	475	210	0.040174	0.117107	0.01446	133	133	133	0	0	1	-360	360	-9.1391	-1.0720	9.1692	-0.4575	0.0000	0.0000	0.0000	0.0000;
	281	328	0.003967	0.012149	0.001379	133	133	133	0	0	1	-360	360	3.2233	3.9650	-3.2224	-4.1192	0.0000	0.0000	0.0000	0.0000;
	250	248	0.022066	0.042727	0.00416	90	90	90	0	0	1	-360	360	22.8472	-4.1605	-22.7431	3.8896	0.0000	0.0000	0.0000	0.0000;
	257	250	0.037364	0.063141	0.00687	90	90	90	0	0	1	-360	360	9.6428	-4.0675	-9.6079	3.3429	0.0000	0.0000	0.0000	0.0000;
	218	215	0.002636	0.008512	0.000881	133	133	133	0	0	1	-360	360	-24.7489	4.6350	24.7633	-4.6915	0.0000	0.0000	0.0000	0.0000;
	572	556	0.039504	0.069091	0.006561	90	90	90	0	0	1	-360	360	-4.1723	-0.5372	4.1783	-0.1993	0.0000	0.0000	0.0000	0.0000;
	556	303	0.035372	0.103314	0.009169	120	120	120	0	0	1	-360	360	-15.1890	-5.5518	15.2684	4.7281	0.0000	0.0000	0.0000	0.0000;
	475	441	0.019752	0.037364	0.00401	90	90	90	0	0	1	-360	360	1.9271	0.5720	-1.9263	-1.0172	0.0000	0.0000	0.0000	0.0000;
	555	249	0.031653	0.095372	0.01148	133	133	133	0	0	1	-360	360	-22.2787	3.4519	22.4229	-4.3143	0.0000	0.0000	0.0000	0.0000;
	409	373	0.040661	0.070661	0.00682	90	90	90	0	0	1	-360	360	16.2131	-5.5621	-16.1089	4.9744	0.0000	0.0000	0.0000	0.0000;
	478	210	0.041397	0.125702	0.01489	133	133	133	0	0	1	-360	360	11.9265	-1.4765	-11.8742	-0.0425	0.0000	0.0000	0.0000	0.0000;
	388	354	0.015703	0.047364	0.005699	133	133	133	0	0	1	-360	360	-21.0112	3.6543	21.0739	-4.1191	0.0000	0.0000	0.0000	0.0000;
	291	218	0.028017	0.084463	0.010159	133	133	133	0	0	1	-360	360	-26.5926	2.3627	26.7661	-3.0199	0.0000	0.0000	0.0000	0.0000;
	261	251	0.026777	0.080496	0.009699	133	133	133	0	0	1	-360	360	-4.5104	1.5366	4.5164	-2.6004	0.0000	0.0000	0.0000	0.0000;
	463	209	0.038603	0.083636	0.00735	90	90	90	0	0	1	-360	360	5.6251	-5.8215	-5.6042	5.0373	0.0000	0.0000	0.0000	0.0000;
	272	251	0.019091	0.061983	0.00644	133	133	133	0	0	1	-360	360	5.8758	-3.2937	-5.8684	2.6004	0.0000	0.0000	0.0000	0.0000;
	378	272	0.067686	0.119008	0.01104	90	90	90	0	0	1	-360	360	14.4592	-5.1827	-14.3205	4.1931	0.0000	0.0000	0.0000	0.0000;
	454	272	0.061066	0.101653	0.011021	90	90	90	0	0	1	-360	360	-1.8030	-0.5000	1.8048	-0.7228	0.0000	0.0000	0.0000	0.0000;
	328	324	0.006124	0.012397	0.001169	90	90	90	0	0	1	-360	360	30.1652	-6.6366	-30.1139	6.6075	0.0000	0.0000	0.0000	0.0000;
	507	261	0.050992	0.154793	0.018329	133	133	133	0	0	1	-360	360	-2.2540	-0.5000	2.2564	-1.5366	0.0000	0.0000	0.0000	0.0000;
	409	290	0.03124	0.094959	0.011251	133	133	133	0	0	1	-360	360	-19.8191	5.0621	19.9366	-5.9774	0.0000	0.0000	0.0000	0.0000;
	556	239	0.029174	0.07438	0.007739	120	120	120	0	0	1	-360	360	4.6997	4.7511	-4.6871	-5.5977	0.0000	0.0000	0.0000	0.0000;
	354	291	0.021653	0.040083	0.00386	90	90	90	0	0	1	-360	360	-23.7789	3.1191	23.8876	-3.3627	0.0000	0.0000	0.0000	0.0000;
	255	555	0.018678	0.056777	0.00673	133	133	133	0	0	1	-360	360	-19.5080	3.3945	19.5737	-3.9519	0.0000	0.0000	0.0000	0.0000;
	256	388	0.026777	0.080578	0.009699	133	133	133	0	0	1	-360	360	-19.1190	3.3137	19.2082	-4.1543	0.0000	0.0000	0.0000	0.0000;
	272	441	0.004298	0.013876	0.00144	133	133	133	0	0	1	-360	360	2.5819	-0.6766	-2.5817	0.5172	0.0000	0.0000	0.0000	0.0000;
	342	215	0.039421	0.120331	0.01413	133	133	133	0	0	1	-360	360	-4.2233	-1.4085	4.2295	-0.2187	0.0000	0.0000	0.0000	0.0000;
	494	215	0.008182	0.025446	0.00289	133	133	133	0	0	1	-360	360	-1.8030	-0.5000	1.8032	0.1635	0.0000	0.0000	0.0000	0.0000;
	317	271	0.043388	0.07157	0.007739	90	90	90	0	0	1	-360	360	1.0672	1.1669	-1.0658	-2.0612	0.0000	0.0000	0.0000	0.0000;
	317	342	0.018256	0.055372	0.006561	133	133	133	0	0	1	-360	360	-2.4192	-1.6669	2.4203	0.9085	0.0000	0.0000	0.0000	0.0000;
	370	303	0.028678	0.088182	0.007831	120	120	120	0	0	1	-360	360	20.7898	5.1554	-20.6774	-5.7281	0.0000	0.0000	0.0000	0.0000;
	370	218	0.025446	0.080992	0.00735	120	120	120	0	0	1	-360	360	18.4450	4.1669	-18.3673	-4.7832	0.0000	0.0000	0.0000	0.0000;
	216	370	0.018182	0.06595	0.007066	133	133	133	0	0	1	-360	360	-15.8184	-5.2158	15.8608	4.5377	0.0000	0.0000	0.0000	0.0000;
	250	226	0.027934	0.084959	0.01006	133	133	133	0	0	1	-360	360	-4.3153	2.6880	4.3224	-3.8105	0.0000	0.0000	0.0000	0.0000;
	515	281	0.023636	0.071488	0.008511	133	133	133	0	0	1	-360	360	5.9381	3.0218	-5.9283	-3.9650	0.0000	0.0000	0.0000	0.0000;
	216	217	0.002231	0.007521	0.000755	133	133	133	0	0	1	-360	360	10.8594	4.7158	-10.8567	-4.7951	0.0000	0.0000	0.0000	0.0000;
	565	246	0.000983	0.004231	0.235708	95	95	95	0	0	1	-360	360	-25.3585	50.1130	25.3991	-76.4934	0.0000	0.0000	0.0000	0.0000;
	565	286	0.016388	0.034405	0.218478	77	77	77	0	0	1	-360	360	1.0133	-24.4097	-0.9920	-0.3000	0.0000	0.0000	0.0000	0.0000;
	565	267	0.000174	0.000744	0.23566	95	95	95	0	0	1	-360	360	24.3451	-25.7033	-24.3440	-0.9000	0.0000	0.0000	0.0000	0.0000;
	287	562	0.015454	0.030083	0.002568	90	90	90	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.2881	0.0000	0.0000	0.0000	0.0000;
	358	356	8e-06	8.3e-05	2.4e-05	137	137	137	0	0	1	-360	360	-16.5012	2.8005	16.5012	-2.8030	0.0000	0.0000	0.0000	0.0000;
	605	840	0.036281	0.094207	0.00974	76	76	76	0	0	1	-360	360	5.3344	-3.5741	-5.3226	2.4821	0.0000	0.0000	0.0000	0.0000;
	795	627	0.030413	0.098934	0.01014	90	90	90	0	0	1	-360	360	-46.1548	0.2090	46.7085	0.3910	0.0000	0.0000	0.0000	0.0000;
	765	591	0.026777	0.086529	0.00885	90	90	90	0	0	1	-360	360	-13.9241	0.6890	13.9689	-1.5813	0.0000	0.0000	0.0000	0.0000;
	836	606	0.022562	0.072893	0.007461	77	77	77	0	0	1	-360	360	10.6976	1.3154	-10.6753	-2.1245	0.0000	0.0000	0.0000	0.0000;
	724	599	0.086777	0.149752	0.01423	58	58	58	0	0	1	-360	360	-5.3223	1.3961	5.3471	-3.0084	0.0000	0.0000	0.0000	0.0000;
	784	731	0.072066	0.138099	0.013211	58	58	58	0	0	1	-360	360	3.1226	-0.6438	-3.1165	-0.8720	0.0000	0.0000	0.0000	0.0000;
	738	732	0.05	0.109091	0.010699	58	58	58	0	0	1	-360	360	9.0831	-3.1001	-9.0448	1.9470	0.0000	0.0000	0.0000	0.0000;
	633	630	0.01124	0.027769	0.002759	58	58	58	0	0	1	-360	360	19.7781	-1.9724	-19.7410	1.7352	0.0000	0.0000	0.0000	0.0000;
	732	730	0.016364	0.053058	0.005421	90	90	90	0	0	1	-360	360	-9.6620	-3.7533	9.6769	3.1743	0.0000	0.0000	0.0000	0.0000;
	725	618	0.041157	0.132893	0.013591	90	90	90	0	0	1	-360	360	6.4721	-1.3190	-6.4573	-0.2283	0.0000	0.0000	0.0000	0.0000;
	737	731	0.023058	0.07157	0.00818	90	90	90	0	0	1	-360	360	-6.9974	-0.3414	7.0072	-0.5706	0.0000	0.0000	0.0000	0.0000;
	737	732	0.023058	0.07157	0.00818	90	90	90	0	0	1	-360	360	-7.4276	-0.3396	7.4387	-0.5688	0.0000	0.0000	0.0000	0.0000;
	752	681	0.020174	0.065289	0.006701	90	90	90	0	0	1	-360	360	-14.0684	-0.5449	14.1037	-0.1004	0.0000	0.0000	0.0000	0.0000;
	797	604	0.048934	0.127769	0.013211	76	76	76	0	0	1	-360	360	-2.7919	-2.1890	2.7962	0.7247	0.0000	0.0000	0.0000	0.0000;
	625	595	0.031983	0.103471	0.01058	90	90	90	0	0	1	-360	360	-16.7934	-3.4954	16.8752	2.5496	0.0000	0.0000	0.0000	0.0000;
	699	824	0.039174	0.126686	0.012959	90	90	90	0	0	1	-360	360	-12.0728	2.0933	12.1237	-3.4660	0.0000	0.0000	0.0000	0.0000;
	794	625	0.038512	0.124628	0.012751	90	90	90	0	0	1	-360	360	-14.3398	-4.6820	14.4164	3.4954	0.0000	0.0000	0.0000	0.0000;
	835	642	0.061397	0.198603	0.020321	90	90	90	0	0	1	-360	360	-6.7397	-1.7669	6.7636	-0.5556	0.0000	0.0000	0.0000	0.0000;
	747	746	0.003719	0.008843	0.00067	76	76	76	0	0	1	-360	360	6.4415	-3.5546	-6.4398	3.4816	0.0000	0.0000	0.0000	0.0000;
	747	622	0.04843	0.08438	0.00809	58	58	58	0	0	1	-360	360	0.7883	3.5852	-0.7811	-4.5010	0.0000	0.0000	0.0000	0.0000;
	790	588	0.012066	0.038934	0.00402	90	90	90	0	0	1	-360	360	-29.1873	10.1879	29.2857	-10.3437	0.0000	0.0000	0.0000	0.0000;
	775	622	0.037603	0.065537	0.006241	58	58	58	0	0	1	-360	360	2.7246	-4.7144	-2.7159	4.0170	0.0000	0.0000	0.0000	0.0000;
	747	663	0.010752	0.028198	0.002909	58	58	58	0	0	1	-360	360	-12.1284	0.1112	12.1421	-0.4103	0.0000	0.0000	0.0000	0.0000;
	721	663	0.012703	0.032967	0.00341	58	58	58	0	0	1	-360	360	15.4353	-0.6884	-15.4091	0.3623	0.0000	0.0000	0.0000	0.0000;
	749	721	0.034851	0.07019	0.006829	58	58	58	0	0	1	-360	360	17.4785	-1.0057	-17.3873	0.3954	0.0000	0.0000	0.0000	0.0000;
	593	749	0.014207	0.046033	0.004709	90	90	90	0	0	1	-360	360	15.0161	-2.6290	-14.9881	2.1691	0.0000	0.0000	0.0000	0.0000;
	705	589	0.00562	0.009917	0.00092	58	58	58	0	0	1	-360	360	-7.9959	-0.4978	7.9990	0.3951	0.0000	0.0000	0.0000	0.0000;
	705	701	0.004463	0.007934	0.00075	58	58	58	0	0	1	-360	360	5.4499	0.4498	-5.4488	-0.5360	0.0000	0.0000	0.0000	0.0000;
	704	701	0.002562	0.008256	0.000849	90	90	90	0	0	1	-360	360	-2.0127	-0.2135	2.0128	0.1140	0.0000	0.0000	0.0000	0.0000;
	830	704	0.013058	0.021653	0.002081	58	58	58	0	0	1	-360	360	1.8817	0.0536	-1.8813	-0.2975	0.0000	0.0000	0.0000	0.0000;
	830	588	0.011744	0.020248	0.001951	58	58	58	0	0	1	-360	360	-5.8777	-0.3196	5.8812	0.0961	0.0000	0.0000	0.0000	0.0000;
	609	588	0.02562	0.08281	0.00847	90	90	90	0	0	1	-360	360	-7.7680	1.7847	7.7823	-2.7353	0.0000	0.0000	0.0000	0.0000;
	609	606	0.029339	0.094793	0.009699	90	90	90	0	0	1	-360	360	4.4590	-2.4117	-4.4532	1.2887	0.0000	0.0000	0.0000	0.0000;
	787	697	0.011322	0.049256	0.004891	90	90	90	0	0	1	-360	360	-2.7377	-6.8503	2.7425	6.2924	0.0000	0.0000	0.0000	0.0000;
	788	787	0.002397	0.007603	0.000779	90	90	90	0	0	1	-360	360	-2.7365	-6.9386	2.7377	6.8503	0.0000	0.0000	0.0000	0.0000;
	790	788	0.002983	0.009587	0.00099	90	90	90	0	0	1	-360	360	3.6830	-6.9843	-3.6815	6.8726	0.0000	0.0000	0.0000	0.0000;
	790	591	0.018843	0.060992	0.006241	90	90	90	0	0	1	-360	360	20.4123	-3.6396	-20.3439	3.1269	0.0000	0.0000	0.0000	0.0000;
	804	591	0.025124	0.081066	0.008301	90	90	90	0	0	1	-360	360	-2.0896	1.0589	2.0911	-2.0296	0.0000	0.0000	0.0000	0.0000;
	804	596	0.004132	0.013223	0.00136	90	90	90	0	0	1	-360	360	2.0896	-1.0589	-2.0894	0.8995	0.0000	0.0000	0.0000	0.0000;
	698	684	0.023141	0.066281	0.006781	90	90	90	0	0	1	-360	360	18.2943	-0.0521	-18.2291	-0.5628	0.0000	0.0000	0.0000	0.0000;
	684	596	0.007769	0.025124	0.00257	90	90	90	0	0	1	-360	360	14.2411	0.0318	-14.2277	-0.2910	0.0000	0.0000	0.0000	0.0000;
	725	596	0.003554	0.01157	0.0012	90	90	90	0	0	1	-360	360	-8.1691	0.7670	8.1711	-0.9015	0.0000	0.0000	0.0000	0.0000;
	693	697	0.010826	0.019174	0.001801	90	90	90	0	0	1	-360	360	5.1071	-12.0619	-5.0916	11.8758	0.0000	0.0000	0.0000	0.0000;
	706	693	0.004554	0.008017	0.00075	58	58	58	0	0	1	-360	360	8.7133	-11.7752	-8.7051	11.7009	0.0000	0.0000	0.0000	0.0000;
	692	691	0.00124	0.003967	0.00044	69	69	69	0	0	1	-360	360	0.6716	-2.1214	-0.6715	2.0694	0.0000	0.0000	0.0000	0.0000;
	703	691	0.003141	0.010248	0.00105	69	69	69	0	0	1	-360	360	2.7488	1.9812	-2.7485	-2.1044	0.0000	0.0000	0.0000	0.0000;
	698	687	0.033223	0.107521	0.010999	90	90	90	0	0	1	-360	360	-17.6287	6.2805	17.7292	-7.2594	0.0000	0.0000	0.0000	0.0000;
	702	685	0.013636	0.044132	0.004521	90	90	90	0	0	1	-360	360	-15.0794	4.4491	15.1081	-4.8909	0.0000	0.0000	0.0000	0.0000;
	697	694	0.013388	0.02686	0.00257	90	90	90	0	0	1	-360	360	0.8376	2.3154	-0.8369	-2.6188	0.0000	0.0000	0.0000	0.0000;
	700	694	0.004628	0.015793	0.001609	90	90	90	0	0	1	-360	360	3.5545	-4.5955	-3.5532	4.4092	0.0000	0.0000	0.0000	0.0000;
	702	700	0.012636	0.040909	0.004179	58	58	58	0	0	1	-360	360	9.0804	-4.6601	-9.0695	4.2005	0.0000	0.0000	0.0000	0.0000;
	698	683	0.019669	0.063636	0.00651	90	90	90	0	0	1	-360	360	16.0892	2.2691	-16.0452	-2.8961	0.0000	0.0000	0.0000	0.0000;
	683	654	0.028256	0.091397	0.009341	90	90	90	0	0	1	-360	360	8.6282	1.6631	-8.6091	-2.6972	0.0000	0.0000	0.0000	0.0000;
	761	654	0.021818	0.070661	0.007231	90	90	90	0	0	1	-360	360	-5.6569	-2.9855	5.6641	2.1662	0.0000	0.0000	0.0000	0.0000;
	711	603	0.058347	0.09876	0.0106	58	58	58	0	0	1	-360	360	-10.8080	0.7902	10.8674	-1.9315	0.0000	0.0000	0.0000	0.0000;
	603	602	0.005702	0.018603	0.00189	90	90	90	0	0	1	-360	360	-14.4234	1.9315	14.4337	-2.1204	0.0000	0.0000	0.0000	0.0000;
	696	602	0.033223	0.107364	0.010989	90	90	90	0	0	1	-360	360	-15.2370	2.4867	15.3055	-3.5574	0.0000	0.0000	0.0000	0.0000;
	739	697	0.063719	0.206124	0.021081	90	90	90	0	0	1	-360	360	2.1595	-1.6258	-2.1569	-0.8700	0.0000	0.0000	0.0000	0.0000;
	706	589	0.013719	0.04438	0.00454	90	90	90	0	0	1	-360	360	-16.2560	11.7102	16.3033	-12.0927	0.0000	0.0000	0.0000	0.0000;
	703	697	0.003802	0.028603	0.00273	183	183	183	0	0	1	-360	360	10.9231	-8.1855	-10.9172	7.9063	0.0000	0.0000	0.0000	0.0000;
	703	698	0.002314	0.024132	0.003729	183	183	183	0	0	1	-360	360	13.4570	-8.6562	-13.4520	8.2656	0.0000	0.0000	0.0000	0.0000;
	703	589	0.004132	0.030661	0.002931	137	137	137	0	0	1	-360	360	-27.1288	14.8605	27.1624	-14.9571	0.0000	0.0000	0.0000	0.0000;
	686	588	0.003967	0.012984	0.001331	90	90	90	0	0	1	-360	360	70.3792	5.8791	-70.2120	-5.4891	0.0000	0.0000	0.0000	0.0000;
	825	602	0.032314	0.10438	0.01068	90	90	90	0	0	1	-360	360	33.6252	-6.6195	-33.3073	6.3847	0.0000	0.0000	0.0000	0.0000;
	825	824	0.040413	0.130579	0.013361	90	90	90	0	0	1	-360	360	19.1421	-7.1968	-19.0032	6.0603	0.0000	0.0000	0.0000	0.0000;
	686	589	0.003967	0.01281	0.001309	90	90	90	0	0	1	-360	360	73.1546	6.4857	-72.9739	-6.0566	0.0000	0.0000	0.0000	0.0000;
	687	685	0.013058	0.042066	0.00431	90	90	90	0	0	1	-360	360	19.3179	-5.1580	-19.2741	4.7889	0.0000	0.0000	0.0000	0.0000;
	727	606	0.030331	0.098099	0.010041	90	90	90	0	0	1	-360	360	-8.3732	-1.1790	8.3915	0.0588	0.0000	0.0000	0.0000	0.0000;
	824	739	0.037934	0.122983	0.012579	90	90	90	0	0	1	-360	360	5.4966	-2.8393	-5.4855	1.3808	0.0000	0.0000	0.0000	0.0000;
	698	694	0.009587	0.031157	0.00318	58	58	58	0	0	1	-360	360	0.2092	1.7341	-0.2089	-2.1104	0.0000	0.0000	0.0000	0.0000;
	703	692	0.005446	0.009587	0.0009	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	696	639	0.026364	0.085207	0.00871	90	90	90	0	0	1	-360	360	-18.8514	3.0219	18.9341	-3.7791	0.0000	0.0000	0.0000	0.0000;
	647	639	0.019174	0.062314	0.006369	90	90	90	0	0	1	-360	360	21.1947	-4.4494	-21.1190	3.9439	0.0000	0.0000	0.0000	0.0000;
	825	647	0.030661	0.099091	0.01014	90	90	90	0	0	1	-360	360	22.3466	-4.9231	-22.2127	4.1564	0.0000	0.0000	0.0000	0.0000;
	639	602	0.031066	0.100413	0.01029	90	90	90	0	0	1	-360	360	-0.3010	-0.2598	0.3011	-0.9519	0.0000	0.0000	0.0000	0.0000;
	747	651	0.019174	0.061983	0.00634	90	90	90	0	0	1	-360	360	1.8856	-0.4828	-1.8850	-0.2450	0.0000	0.0000	0.0000	0.0000;
	593	589	0.029174	0.080744	0.00832	76	76	76	0	0	1	-360	360	-17.3591	2.0980	17.4359	-2.8619	0.0000	0.0000	0.0000	0.0000;
	748	749	0.005207	0.016942	0.00173	90	90	90	0	0	1	-360	360	4.7566	1.3057	-4.7555	-1.5043	0.0000	0.0000	0.0000	0.0000;
	727	748	0.011066	0.035793	0.003659	90	90	90	0	0	1	-360	360	5.1832	0.8860	-5.1806	-1.3057	0.0000	0.0000	0.0000	0.0000;
	631	697	0.020331	0.06562	0.006711	90	90	90	0	0	1	-360	360	-1.7230	0.0000	1.7235	-0.7950	0.0000	0.0000	0.0000	0.0000;
	605	746	0.004959	0.013388	0.001379	76	76	76	0	0	1	-360	360	-6.4374	3.5741	6.4398	-3.7266	0.0000	0.0000	0.0000	0.0000;
	692	706	0.001066	0.008017	0.000179	90	90	90	0	0	1	-360	360	-2.9346	0.7594	2.9347	-0.7799	0.0000	0.0000	0.0000	0.0000;
	765	618	0.031157	0.055041	0.00515	58	58	58	0	0	1	-360	360	-1.3688	-2.0533	1.3701	1.4530	0.0000	0.0000	0.0000	0.0000;
	720	643	0.005124	0.012397	0.001229	58	58	58	0	0	1	-360	360	-28.9186	-1.4072	28.9563	1.3579	0.0000	0.0000	0.0000	0.0000;
	765	619	0.032149	0.055041	0.00515	58	58	58	0	0	1	-360	360	-1.2402	-2.0760	1.2414	1.4756	0.0000	0.0000	0.0000	0.0000;
	765	676	0.019008	0.051157	0.00528	76	76	76	0	0	1	-360	360	-2.6299	3.3533	2.6333	-3.9609	0.0000	0.0000	0.0000	0.0000;
	716	676	0.045793	0.127521	0.013141	76	76	76	0	0	1	-360	360	8.9503	-4.8406	-8.9123	3.4159	0.0000	0.0000	0.0000	0.0000;
	814	715	0.024628	0.044876	0.00423	58	58	58	0	0	1	-360	360	-8.1506	3.7023	8.1679	-4.1628	0.0000	0.0000	0.0000	0.0000;
	814	599	0.058182	0.100413	0.00954	58	58	58	0	0	1	-360	360	4.3316	-3.7023	-4.3172	2.6168	0.0000	0.0000	0.0000	0.0000;
	837	715	0.010174	0.032983	0.003359	90	90	90	0	0	1	-360	360	-3.2761	-8.0783	3.2825	7.7091	0.0000	0.0000	0.0000	0.0000;
	838	833	0.003471	0.009008	0.000939	76	76	76	0	0	1	-360	360	-3.2629	8.3220	3.2653	-8.4240	0.0000	0.0000	0.0000	0.0000;
	838	837	0.006777	0.021901	0.002219	76	76	76	0	0	1	-360	360	0.4619	-8.3220	-0.4579	8.0783	0.0000	0.0000	0.0000	0.0000;
	833	716	0.014959	0.046612	0.004751	58	58	58	0	0	1	-360	360	-1.6483	-11.2637	1.6643	10.7633	0.0000	0.0000	0.0000	0.0000;
	833	818	0.063471	0.113802	0.010699	58	58	58	0	0	1	-360	360	13.3961	-4.9864	-13.2868	3.9525	0.0000	0.0000	0.0000	0.0000;
	720	682	0.044554	0.144132	0.01475	76	76	76	0	0	1	-360	360	-3.2132	0.1956	3.2177	-1.8631	0.0000	0.0000	0.0000	0.0000;
	835	716	0.069091	0.122727	0.01151	58	58	58	0	0	1	-360	360	4.6187	1.5629	-4.6032	-2.8816	0.0000	0.0000	0.0000	0.0000;
	618	611	0.014793	0.030826	0.002979	58	58	58	0	0	1	-360	360	10.7095	-0.2524	-10.6950	-0.0660	0.0000	0.0000	0.0000	0.0000;
	619	612	0.01843	0.033314	0.00326	58	58	58	0	0	1	-360	360	10.7131	-0.2826	-10.6950	-0.0660	0.0000	0.0000	0.0000	0.0000;
	756	720	0.044628	0.078843	0.007381	58	58	58	0	0	1	-360	360	-19.8421	0.6816	19.9989	-1.2404	0.0000	0.0000	0.0000	0.0000;
	756	604	0.03843	0.100744	0.010411	76	76	76	0	0	1	-360	360	3.8193	-0.0892	-3.8142	-1.0657	0.0000	0.0000	0.0000	0.0000;
	752	756	0.037686	0.121901	0.01247	90	90	90	0	0	1	-360	360	8.1294	-0.5451	-8.1074	-0.7894	0.0000	0.0000	0.0000	0.0000;
	709	619	0.055703	0.099504	0.009341	58	58	58	0	0	1	-360	360	6.9366	-1.0532	-6.9138	-0.0035	0.0000	0.0000	0.0000	0.0000;
	827	709	0.040992	0.073636	0.006921	58	58	58	0	0	1	-360	360	8.3181	-1.6224	-8.2936	0.8492	0.0000	0.0000	0.0000	0.0000;
	619	613	0.007934	0.018934	0.001871	58	58	58	0	0	1	-360	360	6.5939	-0.5047	-6.5910	0.2927	0.0000	0.0000	0.0000	0.0000;
	618	616	0.008512	0.027851	0.002851	90	90	90	0	0	1	-360	360	5.6321	-0.1986	-5.6298	-0.1277	0.0000	0.0000	0.0000	0.0000;
	621	616	0.009421	0.030504	0.003119	90	90	90	0	0	1	-360	360	-1.3017	-0.4244	1.3018	0.0597	0.0000	0.0000	0.0000	0.0000;
	621	613	0.007851	0.018347	0.001801	58	58	58	0	0	1	-360	360	-3.0263	0.0834	3.0270	-0.2927	0.0000	0.0000	0.0000	0.0000;
	821	817	0.027769	0.089752	0.009179	90	90	90	0	0	1	-360	360	-0.5100	-0.1360	0.5101	-0.9150	0.0000	0.0000	0.0000	0.0000;
	643	648	0.010826	0.037893	0.003845	58	58	58	0	0	1	-360	360	-32.9443	-1.4259	33.0472	1.3446	0.0000	0.0000	0.0000	0.0000;
	648	795	0.023777	0.076884	0.007865	90	90	90	0	0	1	-360	360	-34.7442	-1.3446	34.9935	1.2376	0.0000	0.0000	0.0000	0.0000;
	600	599	0.008347	0.027016	0.002771	90	90	90	0	0	1	-360	360	5.6141	-0.2981	-5.6119	-0.0174	0.0000	0.0000	0.0000	0.0000;
	815	600	0.01843	0.059504	0.006079	90	90	90	0	0	1	-360	360	7.8299	-0.9757	-7.8201	0.2981	0.0000	0.0000	0.0000	0.0000;
	827	699	0.020661	0.06686	0.006839	90	90	90	0	0	1	-360	360	-10.6951	1.6224	10.7158	-2.3653	0.0000	0.0000	0.0000	0.0000;
	636	833	0.04876	0.157686	0.016129	90	90	90	0	0	1	-360	360	-4.5496	-0.3033	4.5585	-1.5254	0.0000	0.0000	0.0000	0.0000;
	635	636	0.010496	0.033058	0.003381	90	90	90	0	0	1	-360	360	-0.9005	0.2620	0.9006	-0.6507	0.0000	0.0000	0.0000	0.0000;
	750	635	0.026612	0.086033	0.008799	90	90	90	0	0	1	-360	360	0.8807	-0.0692	-0.8805	-0.9430	0.0000	0.0000	0.0000	0.0000;
	820	750	0.017521	0.056777	0.00581	90	90	90	0	0	1	-360	360	2.1544	-0.6003	-2.1537	-0.0668	0.0000	0.0000	0.0000	0.0000;
	833	820	0.037521	0.121397	0.012419	90	90	90	0	0	1	-360	360	4.5385	-1.8048	-4.5314	0.3963	0.0000	0.0000	0.0000	0.0000;
	649	833	0.035537	0.115041	0.019031	58	58	58	0	0	1	-360	360	-2.1210	-0.3410	2.1226	-1.8484	0.0000	0.0000	0.0000	0.0000;
	755	756	0.023802	0.053802	0.005501	58	58	58	0	0	1	-360	360	-7.4292	-0.6681	7.4410	0.0774	0.0000	0.0000	0.0000	0.0000;
	751	755	0.018017	0.031818	0.002979	58	58	58	0	0	1	-360	360	3.2676	-0.9707	-3.2658	0.6401	0.0000	0.0000	0.0000	0.0000;
	757	751	0.001653	0.005372	0.000549	58	58	58	0	0	1	-360	360	8.9538	0.3336	-8.9526	-0.3913	0.0000	0.0000	0.0000	0.0000;
	756	757	0.010826	0.019174	0.001801	58	58	58	0	0	1	-360	360	12.1921	0.7019	-12.1778	-0.8786	0.0000	0.0000	0.0000	0.0000;
	712	756	0.016777	0.029587	0.002771	58	58	58	0	0	1	-360	360	-0.2760	-0.0203	0.2761	-0.2912	0.0000	0.0000	0.0000	0.0000;
	712	756	0.014554	0.025703	0.00241	58	58	58	0	0	1	-360	360	-0.3180	0.0203	0.3180	-0.2912	0.0000	0.0000	0.0000	0.0000;
	817	682	0.083058	0.148678	0.013961	58	58	58	0	0	1	-360	360	6.9047	-2.9814	-6.8667	1.4541	0.0000	0.0000	0.0000	0.0000;
	818	817	0.014132	0.026942	0.00257	58	58	58	0	0	1	-360	360	11.4208	-4.0885	-11.4028	3.8284	0.0000	0.0000	0.0000	0.0000;
	795	815	0.02638	0.085314	0.008729	58	58	58	0	0	1	-360	360	9.8883	-1.7876	-9.8659	0.8397	0.0000	0.0000	0.0000	0.0000;
	638	594	0.03124	0.101066	0.010341	90	90	90	0	0	1	-360	360	-9.6533	-3.8930	9.6819	2.7998	0.0000	0.0000	0.0000	0.0000;
	796	690	0.034876	0.11281	0.011541	90	90	90	0	0	1	-360	360	-27.1104	-1.9120	27.3324	1.2812	0.0000	0.0000	0.0000	0.0000;
	690	688	0.002066	0.006612	0.00068	90	90	90	0	0	1	-360	360	-30.8104	-1.9622	30.8271	1.9353	0.0000	0.0000	0.0000	0.0000;
	785	688	0.019917	0.037107	0.003509	58	58	58	0	0	1	-360	360	38.1991	2.8583	-37.9551	-2.8213	0.0000	0.0000	0.0000	0.0000;
	809	774	0.01719	0.055703	0.005699	90	90	90	0	0	1	-360	360	-11.8676	2.5446	11.8891	-3.1562	0.0000	0.0000	0.0000	0.0000;
	808	724	0.012066	0.020744	0.00198	58	58	58	0	0	1	-360	360	-3.0229	1.8494	3.0243	-2.0771	0.0000	0.0000	0.0000	0.0000;
	808	784	0.05876	0.120248	0.01158	58	58	58	0	0	1	-360	360	5.4293	-1.9552	-5.4136	0.6438	0.0000	0.0000	0.0000	0.0000;
	809	632	0.045207	0.079256	0.006401	58	58	58	0	0	1	-360	360	38.9767	-4.0627	-38.3967	4.3240	0.0000	0.0000	0.0000	0.0000;
	632	628	0.013058	0.024554	0.00198	58	58	58	0	0	1	-360	360	16.4023	-2.9413	-16.3712	2.7691	0.0000	0.0000	0.0000	0.0000;
	738	628	0.044554	0.089256	0.00679	58	58	58	0	0	1	-360	360	-13.5802	3.2233	13.6562	-3.8591	0.0000	0.0000	0.0000	0.0000;
	627	774	0.022066	0.07124	0.007289	90	90	90	0	0	1	-360	360	18.7992	-3.7951	-18.7321	3.1392	0.0000	0.0000	0.0000	0.0000;
	708	707	0.00876	0.014554	0.00152	58	58	58	0	0	1	-360	360	3.9279	0.8355	-3.9266	-1.0111	0.0000	0.0000	0.0000	0.0000;
	813	808	0.003967	0.006942	0.000661	58	58	58	0	0	1	-360	360	-3.1500	-0.1149	3.1503	0.0387	0.0000	0.0000	0.0000	0.0000;
	728	650	0.016198	0.052231	0.005351	76	76	76	0	0	1	-360	360	-6.5634	-0.4850	6.5694	-0.1200	0.0000	0.0000	0.0000	0.0000;
	650	614	0.01595	0.031744	0.00302	58	58	58	0	0	1	-360	360	-7.2484	0.1200	7.2556	-0.4587	0.0000	0.0000	0.0000	0.0000;
	708	614	0.01124	0.019752	0.00173	58	58	58	0	0	1	-360	360	-6.5217	1.2581	6.5260	-1.4530	0.0000	0.0000	0.0000	0.0000;
	708	615	0.010826	0.019091	0.00166	58	58	58	0	0	1	-360	360	2.8443	1.0900	-2.8434	-1.2825	0.0000	0.0000	0.0000	0.0000;
	801	776	0.003719	0.011901	0.00121	90	90	90	0	0	1	-360	360	-8.8394	5.1215	8.8429	-5.2495	0.0000	0.0000	0.0000	0.0000;
	779	776	0.022636	0.07314	0.00748	90	90	90	0	0	1	-360	360	10.7372	-5.7427	-10.7089	4.9775	0.0000	0.0000	0.0000	0.0000;
	809	595	0.136198	0.235124	0.022351	90	90	90	0	0	1	-360	360	21.3558	-4.1426	-20.8268	2.4327	0.0000	0.0000	0.0000	0.0000;
	778	595	0.006124	0.019917	0.00204	90	90	90	0	0	1	-360	360	3.0651	-6.3231	-3.0626	6.0965	0.0000	0.0000	0.0000	0.0000;
	783	595	0.004628	0.014793	0.0016	90	90	90	0	0	1	-360	360	13.0349	-6.2336	-13.0265	6.0759	0.0000	0.0000	0.0000	0.0000;
	783	777	0.007438	0.02405	0.002471	90	90	90	0	0	1	-360	360	-21.5199	4.8716	21.5514	-5.0544	0.0000	0.0000	0.0000	0.0000;
	777	767	0.003223	0.010496	0.001089	90	90	90	0	0	1	-360	360	-24.6904	4.6454	24.7081	-4.7134	0.0000	0.0000	0.0000	0.0000;
	782	779	0.027107	0.087769	0.008981	90	90	90	0	0	1	-360	360	16.4183	1.8967	-16.3537	-2.7211	0.0000	0.0000	0.0000	0.0000;
	780	653	0.009669	0.031488	0.003221	90	90	90	0	0	1	-360	360	2.6952	-6.1180	-2.6916	5.7606	0.0000	0.0000	0.0000	0.0000;
	722	653	0.045446	0.080909	0.00757	58	58	58	0	0	1	-360	360	2.2466	6.0099	-2.2284	-6.8506	0.0000	0.0000	0.0000	0.0000;
	722	615	0.026281	0.046942	0.0044	58	58	58	0	0	1	-360	360	-4.4526	-6.4869	4.4659	5.9985	0.0000	0.0000	0.0000	0.0000;
	754	708	0.010909	0.019256	0.001801	58	58	58	0	0	1	-360	360	4.4972	4.3415	-4.4935	-4.5457	0.0000	0.0000	0.0000	0.0000;
	741	633	0.035207	0.076446	0.007429	90	90	90	0	0	1	-360	360	14.9654	-2.8589	-14.8980	2.1157	0.0000	0.0000	0.0000	0.0000;
	802	742	0.022397	0.072397	0.00741	90	90	90	0	0	1	-360	360	-12.6511	-0.0921	12.6811	-0.6988	0.0000	0.0000	0.0000	0.0000;
	742	717	0.021322	0.06595	0.006711	58	58	58	0	0	1	-360	360	24.5897	7.5314	-24.4712	-7.9637	0.0000	0.0000	0.0000	0.0000;
	717	615	0.076942	0.132562	0.01263	58	58	58	0	0	1	-360	360	1.9492	2.7187	-1.9389	-4.1839	0.0000	0.0000	0.0000	0.0000;
	792	595	0.031818	0.079587	0.008061	76	76	76	0	0	1	-360	360	-8.2452	1.2476	8.2649	-2.1265	0.0000	0.0000	0.0000	0.0000;
	792	768	0.009174	0.022893	0.002321	76	76	76	0	0	1	-360	360	5.5302	-1.9286	-5.5275	1.6685	0.0000	0.0000	0.0000	0.0000;
	810	594	0.023554	0.07562	0.007819	90	90	90	0	0	1	-360	360	-25.7855	-7.6320	25.9349	7.2196	0.0000	0.0000	0.0000	0.0000;
	810	672	0.022231	0.071397	0.007381	90	90	90	0	0	1	-360	360	22.5615	6.5420	-22.4517	-7.0159	0.0000	0.0000	0.0000	0.0000;
	670	592	0.022066	0.059173	0.00611	90	90	90	0	0	1	-360	360	1.5168	-5.8324	-1.5103	5.1811	0.0000	0.0000	0.0000	0.0000;
	793	592	0.025372	0.067364	0.00695	76	76	76	0	0	1	-360	360	3.2539	7.5977	-3.2369	-8.3198	0.0000	0.0000	0.0000	0.0000;
	689	793	0.01405	0.036446	0.00377	76	76	76	0	0	1	-360	360	-1.0311	1.7960	1.0318	-2.2131	0.0000	0.0000	0.0000	0.0000;
	672	634	0.020744	0.067017	0.006861	90	90	90	0	0	1	-360	360	-3.5092	-8.9366	3.5251	8.2225	0.0000	0.0000	0.0000	0.0000;
	660	634	0.009669	0.026198	0.002631	58	58	58	0	0	1	-360	360	7.7808	9.1866	-7.7681	-9.4485	0.0000	0.0000	0.0000	0.0000;
	723	660	0.006198	0.02	0.00204	58	58	58	0	0	1	-360	360	10.3377	9.4678	-10.3268	-9.6636	0.0000	0.0000	0.0000	0.0000;
	816	614	0.015793	0.051066	0.00523	90	90	90	0	0	1	-360	360	1.3437	-4.3222	-1.3413	3.7191	0.0000	0.0000	0.0000	0.0000;
	782	764	0.001744	0.00562	0.000581	90	90	90	0	0	1	-360	360	-27.2793	-2.5777	27.2906	2.5469	0.0000	0.0000	0.0000	0.0000;
	822	797	0.020579	0.036281	0.00339	58	58	58	0	0	1	-360	360	-1.7005	-0.7958	1.7011	0.4195	0.0000	0.0000	0.0000	0.0000;
	834	822	0.028017	0.090496	0.00924	90	90	90	0	0	1	-360	360	0.3360	-1.8213	-0.3355	0.7958	0.0000	0.0000	0.0000	0.0000;
	834	793	0.008678	0.015372	0.00143	90	90	90	0	0	1	-360	360	-1.1850	1.6173	1.1853	-1.7755	0.0000	0.0000	0.0000	0.0000;
	780	594	0.033058	0.10686	0.010941	90	90	90	0	0	1	-360	360	9.9447	-7.6453	-9.9019	6.5271	0.0000	0.0000	0.0000	0.0000;
	809	642	0.032983	0.106686	0.010909	90	90	90	0	0	1	-360	360	11.2959	-0.1732	-11.2606	-1.0114	0.0000	0.0000	0.0000	0.0000;
	728	812	0.020661	0.066777	0.006829	58	58	58	0	0	1	-360	360	6.3944	0.4850	-6.3870	-1.2558	0.0000	0.0000	0.0000	0.0000;
	816	637	0.014793	0.047686	0.004881	90	90	90	0	0	1	-360	360	-5.5017	4.0502	5.5080	-4.5988	0.0000	0.0000	0.0000	0.0000;
	819	637	0.007438	0.01314	0.001229	58	58	58	0	0	1	-360	360	12.3063	-3.3617	-12.2960	3.2368	0.0000	0.0000	0.0000	0.0000;
	819	632	0.008256	0.014628	0.00137	58	58	58	0	0	1	-360	360	-14.2583	2.9527	14.2734	-3.0856	0.0000	0.0000	0.0000	0.0000;
	805	793	0.002562	0.008182	0.00083	90	90	90	0	0	1	-360	360	7.2035	3.7987	-7.2020	-3.8860	0.0000	0.0000	0.0000	0.0000;
	707	615	0.005289	0.016859	0.00173	90	90	90	0	0	1	-360	360	-0.3164	0.3301	0.3164	-0.5321	0.0000	0.0000	0.0000	0.0000;
	780	681	0.038934	0.12595	0.012879	90	90	90	0	0	1	-360	360	17.6290	-2.9500	-17.5215	1.8289	0.0000	0.0000	0.0000	0.0000;
	733	754	0.02157	0.047438	0.00462	58	58	58	0	0	1	-360	360	5.6943	4.5018	-5.6842	-5.0225	0.0000	0.0000	0.0000	0.0000;
	733	741	0.029669	0.066364	0.00649	90	90	90	0	0	1	-360	360	-21.5487	-7.0543	21.6767	6.5686	0.0000	0.0000	0.0000	0.0000;
	681	638	0.009826	0.031818	0.00325	90	90	90	0	0	1	-360	360	-5.9152	-3.7725	5.9193	3.4160	0.0000	0.0000	0.0000	0.0000;
	780	764	0.02438	0.078017	0.008071	90	90	90	0	0	1	-360	360	-20.5179	-2.9621	20.6090	2.3242	0.0000	0.0000	0.0000	0.0000;
	767	764	0.017769	0.057364	0.005871	90	90	90	0	0	1	-360	360	-29.5441	4.7134	29.6825	-4.9452	0.0000	0.0000	0.0000	0.0000;
	802	633	0.008182	0.026446	0.00271	90	90	90	0	0	1	-360	360	10.1051	-0.0439	-10.0981	-0.2573	0.0000	0.0000	0.0000	0.0000;
	670	610	0.012397	0.054132	0.006749	90	90	90	0	0	1	-360	360	2.4678	-3.1529	-2.4663	2.4220	0.0000	0.0000	0.0000	0.0000;
	812	813	0.008512	0.027438	0.00281	58	58	58	0	0	1	-360	360	-0.6810	0.3018	0.6810	-0.6281	0.0000	0.0000	0.0000	0.0000;
	805	794	0.006364	0.020579	0.002101	90	90	90	0	0	1	-360	360	-11.3615	-4.2077	11.3698	4.0010	0.0000	0.0000	0.0000	0.0000;
	610	592	0.017934	0.058016	0.005929	90	90	90	0	0	1	-360	360	-0.1637	-3.2390	0.1651	2.5937	0.0000	0.0000	0.0000	0.0000;
	669	672	0.001488	0.002636	0.000249	58	58	58	0	0	1	-360	360	-19.5045	-15.6243	19.5129	15.6115	0.0000	0.0000	0.0000	0.0000;
	671	669	0.000579	0.001901	0.000191	90	90	90	0	0	1	-360	360	-14.8352	-14.9568	14.8375	14.9433	0.0000	0.0000	0.0000	0.0000;
	836	809	0.028678	0.09281	0.009489	58	58	58	0	0	1	-360	360	-12.0546	-1.9964	12.0903	0.9829	0.0000	0.0000	0.0000	0.0000;
	590	738	0.015703	0.050744	0.005191	90	90	90	0	0	1	-360	360	-1.1030	-0.4770	1.1032	-0.1232	0.0000	0.0000	0.0000	0.0000;
	662	733	0.021322	0.068934	0.00705	90	90	90	0	0	1	-360	360	-14.9634	-2.9033	15.0054	2.2115	0.0000	0.0000	0.0000	0.0000;
	801	778	0.008182	0.026529	0.00271	90	90	90	0	0	1	-360	360	4.3424	-6.6205	-4.3381	6.3231	0.0000	0.0000	0.0000	0.0000;
	673	671	0.011488	0.029669	0.003011	58	58	58	0	0	1	-360	360	-8.7798	-14.7671	8.8102	14.5138	0.0000	0.0000	0.0000	0.0000;
	659	723	0.006198	0.02	0.00204	90	90	90	0	0	1	-360	360	13.8422	1.8067	-13.8316	-2.0040	0.0000	0.0000	0.0000	0.0000;
	730	662	0.018099	0.058512	0.00599	90	90	90	0	0	1	-360	360	-12.7309	-3.1743	12.7574	2.5623	0.0000	0.0000	0.0000	0.0000;
	670	673	0.005702	0.016033	0.00165	90	90	90	0	0	1	-360	360	-1.5852	-14.9011	1.5968	14.7531	0.0000	0.0000	0.0000	0.0000;
	797	689	0.019174	0.049826	0.005159	76	76	76	0	0	1	-360	360	1.0908	1.7695	-1.0899	-2.3410	0.0000	0.0000	0.0000	0.0000;
	796	779	0.023058	0.074628	0.00764	90	90	90	0	0	1	-360	360	21.4624	1.9120	-21.3696	-2.4905	0.0000	0.0000	0.0000	0.0000;
	785	627	0.000157	0.000504	5.1e-05	90	90	90	0	0	1	-360	360	-40.4901	-3.4033	40.4923	3.4042	0.0000	0.0000	0.0000	0.0000;
	598	723	0.030248	0.059314	0.00567	90	90	90	0	0	1	-360	360	5.3583	8.3013	-5.3311	-8.8948	0.0000	0.0000	0.0000	0.0000;
	670	640	0.013587	0.043942	0.004496	137	137	137	0	0	1	-360	360	4.1331	-0.4838	-4.1310	-0.0000	0.0000	0.0000	0.0000	0.0000;
	840	769	0.051901	0.131397	0.013119	76	76	76	0	0	1	-360	360	-2.6578	-0.9788	2.6610	-0.5286	0.0000	0.0000	0.0000	0.0000;
	772	770	0.015207	0.02562	0.002449	58	58	58	0	0	1	-360	360	-4.6138	-5.4969	4.6203	5.2252	0.0000	0.0000	0.0000	0.0000;
	772	771	0.008512	0.01438	0.001549	58	58	58	0	0	1	-360	360	-0.4782	3.7939	0.4794	-3.9704	0.0000	0.0000	0.0000	0.0000;
	771	745	0.027016	0.087603	0.009	90	90	90	0	0	1	-360	360	-4.7224	3.2894	4.7310	-4.2960	0.0000	0.0000	0.0000	0.0000;
	744	680	0.018512	0.06	0.00614	90	90	90	0	0	1	-360	360	-11.1386	4.9931	11.1633	-5.6150	0.0000	0.0000	0.0000	0.0000;
	680	666	0.013719	0.044463	0.00454	90	90	90	0	0	1	-360	360	-15.4063	4.5930	15.4376	-5.0099	0.0000	0.0000	0.0000	0.0000;
	769	762	0.022893	0.051901	0.00506	58	58	58	0	0	1	-360	360	6.1611	3.4111	-6.1508	-3.9717	0.0000	0.0000	0.0000	0.0000;
	773	762	0.025207	0.057438	0.00561	58	58	58	0	0	1	-360	360	-0.4878	-4.6453	0.4919	4.0110	0.0000	0.0000	0.0000	0.0000;
	773	766	0.005793	0.009917	0.00105	90	90	90	0	0	1	-360	360	-3.7552	3.9643	3.7568	-4.0819	0.0000	0.0000	0.0000	0.0000;
	646	623	0.017769	0.057364	0.005871	90	90	90	0	0	1	-360	360	-13.1088	2.7718	13.1370	-3.3532	0.0000	0.0000	0.0000	0.0000;
	666	623	0.020579	0.066124	0.006861	90	90	90	0	0	1	-360	360	14.6381	-7.5911	-14.5902	6.9604	0.0000	0.0000	0.0000	0.0000;
	769	617	0.009008	0.031066	0.002979	90	90	90	0	0	1	-360	360	2.0406	3.1901	-2.0394	-3.5302	0.0000	0.0000	0.0000	0.0000;
	753	617	0.023967	0.083223	0.007991	90	90	90	0	0	1	-360	360	-0.3396	-4.0995	0.3424	3.1892	0.0000	0.0000	0.0000	0.0000;
	763	753	0.023223	0.075207	0.0077	90	90	90	0	0	1	-360	360	3.0605	-4.9619	-3.0544	4.0995	0.0000	0.0000	0.0000	0.0000;
	831	789	0.008843	0.014876	0.0015	58	58	58	0	0	1	-360	360	-8.9055	0.5281	8.9117	-0.6899	0.0000	0.0000	0.0000	0.0000;
	831	601	0.014628	0.025793	0.00242	58	58	58	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	803	769	0.053314	0.133388	0.010641	76	76	76	0	0	1	-360	360	-8.5280	0.1312	8.5620	-1.2734	0.0000	0.0000	0.0000	0.0000;
	770	641	0.040661	0.111157	0.011471	76	76	76	0	0	1	-360	360	6.7806	-1.2678	-6.7643	-0.0122	0.0000	0.0000	0.0000	0.0000;
	807	641	0.027769	0.077686	0.00801	76	76	76	0	0	1	-360	360	-5.0611	-0.5760	5.0673	-0.3288	0.0000	0.0000	0.0000	0.0000;
	807	803	0.002893	0.007769	0.000801	76	76	76	0	0	1	-360	360	0.8181	-0.1050	-0.8181	0.0129	0.0000	0.0000	0.0000	0.0000;
	601	803	0.04	0.061818	0.006759	58	58	58	0	0	1	-360	360	-1.0301	-1.4899	1.0309	0.7149	0.0000	0.0000	0.0000	0.0000;
	799	601	0.038256	0.06562	0.01263	58	58	58	0	0	1	-360	360	1.4784	-5.3566	-1.4705	3.9241	0.0000	0.0000	0.0000	0.0000;
	799	674	0.028934	0.049752	0.00953	58	58	58	0	0	1	-360	360	-4.0244	4.6756	4.0354	-5.7441	0.0000	0.0000	0.0000	0.0000;
	675	674	0.004132	0.007107	0.00137	58	58	58	0	0	1	-360	360	6.5841	-5.5546	-6.5814	5.4031	0.0000	0.0000	0.0000	0.0000;
	803	731	0.069091	0.123802	0.010079	58	58	58	0	0	1	-360	360	-3.1744	-0.5017	3.1804	-0.6483	0.0000	0.0000	0.0000	0.0000;
	803	664	0.039917	0.067934	0.005431	58	58	58	0	0	1	-360	360	-0.8148	-0.7731	0.8151	0.1490	0.0000	0.0000	0.0000	0.0000;
	736	664	0.01281	0.021818	0.00175	58	58	58	0	0	1	-360	360	2.5128	-0.0513	-2.5121	-0.1490	0.0000	0.0000	0.0000	0.0000;
	736	732	0.013223	0.034298	0.003291	58	58	58	0	0	1	-360	360	-9.7878	0.0023	9.7988	-0.3531	0.0000	0.0000	0.0000	0.0000;
	731	695	0.031322	0.101397	0.010379	90	90	90	0	0	1	-360	360	0.5157	0.0802	-0.5155	-1.2763	0.0000	0.0000	0.0000	0.0000;
	734	731	0.002479	0.007934	0.00082	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	734	731	0.002479	0.007934	0.00082	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	735	734	0.000331	0.000579	0.0242	274	274	274	0	0	1	-360	360	67.8990	24.7913	-67.8820	-27.2490	0.0000	0.0000	0.0000	0.0000;
	623	597	0.016281	0.052727	0.005411	90	90	90	0	0	1	-360	360	-1.5448	-3.6242	1.5467	3.0093	0.0000	0.0000	0.0000	0.0000;
	823	665	0.034711	0.112562	0.01158	90	90	90	0	0	1	-360	360	-28.7688	6.8661	29.0386	-7.3111	0.0000	0.0000	0.0000	0.0000;
	823	714	0.015124	0.051322	0.00251	90	90	90	0	0	1	-360	360	23.6768	-8.2281	-23.5936	8.2248	0.0000	0.0000	0.0000	0.0000;
	714	629	0.029496	0.051818	0.004881	90	90	90	0	0	1	-360	360	22.3086	-8.2248	-22.1634	7.9251	0.0000	0.0000	0.0000	0.0000;
	811	601	0.010248	0.018099	0.001699	58	58	58	0	0	1	-360	360	0.4773	3.4904	-0.4761	-3.6833	0.0000	0.0000	0.0000	0.0000;
	828	811	0.03124	0.055124	0.005159	58	58	58	0	0	1	-360	360	1.3355	2.9022	-1.3323	-3.4904	0.0000	0.0000	0.0000	0.0000;
	828	668	0.024463	0.043223	0.004051	58	58	58	0	0	1	-360	360	-3.8815	-2.9022	3.8862	2.4425	0.0000	0.0000	0.0000	0.0000;
	718	668	0.057364	0.100826	0.009489	58	58	58	0	0	1	-360	360	-6.6360	-0.3602	6.6580	-0.6960	0.0000	0.0000	0.0000	0.0000;
	729	718	0.013636	0.070413	0.007279	90	90	90	0	0	1	-360	360	1.6889	-2.3219	-1.6881	1.4895	0.0000	0.0000	0.0000	0.0000;
	655	668	0.003058	0.009826	0.001009	90	90	90	0	0	1	-360	360	-7.9984	2.9362	8.0003	-3.0468	0.0000	0.0000	0.0000	0.0000;
	657	656	0.004463	0.014554	0.001481	90	90	90	0	0	1	-360	360	0.3591	-2.7701	-0.3588	2.5995	0.0000	0.0000	0.0000	0.0000;
	759	656	0.01405	0.045372	0.004649	90	90	90	0	0	1	-360	360	14.0929	4.5292	-14.0662	-4.9835	0.0000	0.0000	0.0000	0.0000;
	658	668	0.007603	0.024554	0.002519	90	90	90	0	0	1	-360	360	-8.8019	2.4088	8.8074	-2.6826	0.0000	0.0000	0.0000	0.0000;
	679	658	0.004463	0.013876	0.00143	90	90	90	0	0	1	-360	360	-6.2542	2.2486	6.2559	-2.4088	0.0000	0.0000	0.0000	0.0000;
	667	679	0.005702	0.018512	0.00189	90	90	90	0	0	1	-360	360	1.3822	2.3721	-1.3818	-2.5896	0.0000	0.0000	0.0000	0.0000;
	759	718	0.021984	0.06843	0.00702	90	90	90	0	0	1	-360	360	17.1961	6.3060	-17.1319	-6.9193	0.0000	0.0000	0.0000	0.0000;
	826	760	0.016198	0.02843	0.002691	58	58	58	0	0	1	-360	360	0.3997	-0.1831	-0.3997	-0.1309	0.0000	0.0000	0.0000	0.0000;
	826	645	0.039174	0.066033	0.003959	58	58	58	0	0	1	-360	360	-3.7937	-0.4979	3.7986	0.0434	0.0000	0.0000	0.0000	0.0000;
	644	645	0.009587	0.020174	0.00196	58	58	58	0	0	1	-360	360	8.4715	-0.1739	-8.4656	-0.0434	0.0000	0.0000	0.0000	0.0000;
	760	719	0.009669	0.03157	0.003221	90	90	90	0	0	1	-360	360	4.6230	-4.1466	-4.6199	3.7805	0.0000	0.0000	0.0000	0.0000;
	719	620	0.047769	0.090579	0.00862	58	58	58	0	0	1	-360	360	1.2259	-4.1215	-1.2200	3.1232	0.0000	0.0000	0.0000	0.0000;
	786	620	0.022727	0.046612	0.004501	58	58	58	0	0	1	-360	360	1.3279	2.5980	-1.3260	-3.1232	0.0000	0.0000	0.0000	0.0000;
	786	607	0.024628	0.059587	0.004961	58	58	58	0	0	1	-360	360	-2.1769	-2.5980	2.1790	2.0181	0.0000	0.0000	0.0000	0.0000;
	608	607	0.005702	0.018512	0.00189	58	58	58	0	0	1	-360	360	12.4278	-0.5888	-12.4203	0.3897	0.0000	0.0000	0.0000	0.0000;
	840	695	0.04719	0.085207	0.00803	76	76	76	0	0	1	-360	360	4.5863	-2.1843	-4.5765	1.2763	0.0000	0.0000	0.0000	0.0000;
	762	758	0.007769	0.016859	0.00165	90	90	90	0	0	1	-360	360	0.5669	-1.4014	-0.5667	1.2118	0.0000	0.0000	0.0000	0.0000;
	781	770	0.016859	0.029826	0.00281	58	58	58	0	0	1	-360	360	-9.1936	-3.6579	9.2078	3.3587	0.0000	0.0000	0.0000	0.0000;
	781	758	0.003554	0.006281	0.005421	58	58	58	0	0	1	-360	360	7.9206	3.3169	-7.9183	-3.9368	0.0000	0.0000	0.0000	0.0000;
	839	601	0.005868	0.010331	0.00097	58	58	58	0	0	1	-360	360	0.4174	-1.3604	-0.4173	1.2492	0.0000	0.0000	0.0000	0.0000;
	839	798	0.003802	0.012397	0.00127	58	58	58	0	0	1	-360	360	-2.1144	1.3604	2.1146	-1.5054	0.0000	0.0000	0.0000	0.0000;
	798	740	0.00405	0.012984	0.001331	90	90	90	0	0	1	-360	360	-3.8116	1.5054	3.8122	-1.6562	0.0000	0.0000	0.0000	0.0000;
	763	624	0.003554	0.01157	0.001191	90	90	90	0	0	1	-360	360	0.8490	-0.1360	-0.8490	-0.0000	0.0000	0.0000	0.0000	0.0000;
	806	608	0.017769	0.057603	0.00589	58	58	58	0	0	1	-360	360	14.1549	-1.1888	-14.1248	0.5888	0.0000	0.0000	0.0000	0.0000;
	630	806	0.017769	0.057603	0.00589	58	58	58	0	0	1	-360	360	16.7430	-1.7522	-16.7009	1.1888	0.0000	0.0000	0.0000	0.0000;
	743	607	0.021744	0.038347	0.003589	58	58	58	0	0	1	-360	360	-5.1429	2.6763	5.1493	-3.0888	0.0000	0.0000	0.0000	0.0000;
	743	832	0.01719	0.05562	0.00568	90	90	90	0	0	1	-360	360	2.1728	-2.4246	-2.1715	1.7576	0.0000	0.0000	0.0000	0.0000;
	832	678	0.01719	0.05562	0.00568	90	90	90	0	0	1	-360	360	0.4740	-1.0375	-0.4739	0.3659	0.0000	0.0000	0.0000	0.0000;
	713	597	0.020744	0.067273	0.00688	90	90	90	0	0	1	-360	360	4.9470	2.9177	-4.9407	-3.6903	0.0000	0.0000	0.0000	0.0000;
	677	675	0.00157	0.003058	0.00029	58	58	58	0	0	1	-360	360	7.4342	-5.2444	-7.4331	5.2136	0.0000	0.0000	0.0000	0.0000;
	789	770	0.038256	0.067521	0.006331	58	58	58	0	0	1	-360	360	-11.4577	0.0089	11.5014	-0.6614	0.0000	0.0000	0.0000	0.0000;
	803	726	0.024876	0.072231	0.00824	90	90	90	0	0	1	-360	360	1.2734	-0.9462	-1.2730	0.0000	0.0000	0.0000	0.0000	0.0000;
	743	661	0.015207	0.049008	0.005019	20	20	20	0	0	1	-360	360	0.4240	-0.5927	-0.4240	0.0000	0.0000	0.0000	0.0000	0.0000;
	831	800	0.000413	0.011901	0.00122	69	69	69	0	0	1	-360	360	8.9055	-0.5281	-8.9052	0.3964	0.0000	0.0000	0.0000	0.0000;
	740	800	0.00281	0.009008	0.00092	69	69	69	0	0	1	-360	360	-6.3582	0.9752	6.3592	-1.0774	0.0000	0.0000	0.0000	0.0000;
	760	652	0.022893	0.074132	0.007579	90	90	90	0	0	1	-360	360	8.2188	1.1413	-8.2051	-1.9790	0.0000	0.0000	0.0000	0.0000;
	744	745	0.019339	0.062636	0.006411	90	90	90	0	0	1	-360	360	6.8636	-4.9931	-6.8520	4.2960	0.0000	0.0000	0.0000	0.0000;
	657	655	0.004554	0.014711	0.0015	90	90	90	0	0	1	-360	360	-7.1471	2.7701	7.1494	-2.9362	0.0000	0.0000	0.0000	0.0000;
	644	791	0.034876	0.064876	0.00614	58	58	58	0	0	1	-360	360	-10.1685	0.1739	10.1993	-0.8380	0.0000	0.0000	0.0000	0.0000;
	766	646	0.020992	0.067851	0.006941	90	90	90	0	0	1	-360	360	-9.6958	2.7199	9.7148	-3.4528	0.0000	0.0000	0.0000	0.0000;
	652	667	0.010826	0.035124	0.003589	69	69	69	0	0	1	-360	360	3.9301	1.9620	-3.9282	-2.3721	0.0000	0.0000	0.0000	0.0000;
	626	832	0.019174	0.059587	0.006103	69	69	69	0	0	1	-360	360	-1.6970	0.0000	1.6975	-0.7202	0.0000	0.0000	0.0000	0.0000;
	1859	1274	0.026281	0.082975	0.009048	114	114	114	0	0	1	-360	360	11.2197	0.4136	-11.1922	-1.4175	0.0000	0.0000	0.0000	0.0000;
	1273	1274	0.002975	0.009669	0.001004	140	140	140	0	0	1	-360	360	-1.2560	-0.3460	1.2560	0.2254	0.0000	0.0000	0.0000	0.0000;
	985	1493	0.036116	0.050413	0.008291	57	57	57	0	0	1	-360	360	-1.0040	-0.2158	1.0043	-0.7932	0.0000	0.0000	0.0000	0.0000;
	984	985	0	8.3e-05	1e-05	29	29	29	0	0	1	-360	360	-1.0040	-0.2170	1.0040	0.2158	0.0000	0.0000	0.0000	0.0000;
	1018	987	0.016198	0.049174	0.00584	114	114	114	0	0	1	-360	360	18.4552	-1.6668	-18.4098	1.0930	0.0000	0.0000	0.0000	0.0000;
	1017	1018	0.000165	0.000248	4.4e-05	90	90	90	0	0	1	-360	360	-0.5870	-0.2360	0.5870	0.2307	0.0000	0.0000	0.0000	0.0000;
	1022	1361	0.016529	0.050413	0.005893	114	114	114	0	0	1	-360	360	-16.4937	-1.4681	16.5332	0.9125	0.0000	0.0000	0.0000	0.0000;
	1021	1022	0.000496	0.001488	0.000172	114	114	114	0	0	1	-360	360	-1.7600	-0.3430	1.7600	0.3234	0.0000	0.0000	0.0000	0.0000;
	1145	901	0.038678	0.099587	0.011081	114	114	114	0	0	1	-360	360	-13.2937	2.0309	13.3528	-3.2164	0.0000	0.0000	0.0000	0.0000;
	1601	1349	0.005372	0.01719	0.001832	114	114	114	0	0	1	-360	360	5.3633	0.7933	-5.3620	-1.0080	0.0000	0.0000	0.0000	0.0000;
	902	1601	0.039091	0.09562	0.010571	114	114	114	0	0	1	-360	360	10.0927	0.2994	-10.0593	-1.4870	0.0000	0.0000	0.0000	0.0000;
	1600	1601	8.3e-05	0.000248	1.9e-05	120	120	120	0	0	1	-360	360	-4.6960	-0.6960	4.6960	0.6937	0.0000	0.0000	0.0000	0.0000;
	1328	1248	0.01595	0.046694	0.004131	114	114	114	0	0	1	-360	360	-1.0325	-0.1733	1.0327	-0.3263	0.0000	0.0000	0.0000	0.0000;
	1718	1328	0.031736	0.094215	0.008361	120	120	120	0	0	1	-360	360	-0.4464	-1.1135	0.4465	0.1027	0.0000	0.0000	0.0000	0.0000;
	1326	1328	0.000496	0.001157	0.000135	29	29	29	0	0	1	-360	360	-0.5860	-0.0870	0.5860	0.0706	0.0000	0.0000	0.0000	0.0000;
	1329	1247	0.01595	0.046694	0.004136	114	114	114	0	0	1	-360	360	7.7437	-0.2838	-7.7358	-0.1912	0.0000	0.0000	0.0000	0.0000;
	1719	1329	0.031736	0.094215	0.008361	120	120	120	0	0	1	-360	360	7.7596	-1.2625	-7.7437	0.3002	0.0000	0.0000	0.0000	0.0000;
	1327	1329	0.000496	0.001157	0.000135	29	29	29	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0163	0.0000	0.0000	0.0000	0.0000;
	1889	1631	0.048182	0.119835	0.013225	114	114	114	0	0	1	-360	360	-1.5199	0.1024	1.5211	-1.6921	0.0000	0.0000	0.0000	0.0000;
	1630	1302	0.040165	0.105785	0.01189	114	114	114	0	0	1	-360	360	2.0187	-1.6920	-2.0170	0.2644	0.0000	0.0000	0.0000	0.0000;
	1015	885	0.011653	0.03595	0.004112	114	114	114	0	0	1	-360	360	-38.3486	-1.6440	38.4907	1.5842	0.0000	0.0000	0.0000	0.0000;
	1014	886	0.011653	0.03595	0.004112	114	114	114	0	0	1	-360	360	-0.2032	-4.3865	0.2049	3.8918	0.0000	0.0000	0.0000	0.0000;
	1218	1633	0.002727	0.008926	0.000886	140	140	140	0	0	1	-360	360	6.3623	-5.5585	-6.3607	5.4587	0.0000	0.0000	0.0000	0.0000;
	1352	1218	0.007603	0.023471	0.002664	114	114	114	0	0	1	-360	360	6.7853	-5.7167	-6.7803	5.4162	0.0000	0.0000	0.0000	0.0000;
	1217	1218	0.000331	0.000413	8.2e-05	90	90	90	0	0	1	-360	360	-0.4180	-0.1520	0.4180	0.1422	0.0000	0.0000	0.0000	0.0000;
	899	1413	0.018182	0.044628	0.004898	120	120	120	0	0	1	-360	360	5.8702	0.2725	-5.8650	-0.8496	0.0000	0.0000	0.0000	0.0000;
	1860	899	0.026033	0.063636	0.007047	120	120	120	0	0	1	-360	360	8.9023	-0.5374	-8.8853	-0.2723	0.0000	0.0000	0.0000	0.0000;
	899	897	0.013884	0.018017	0.003231	90	90	90	0	0	1	-360	360	3.0151	-0.0001	-3.0140	-0.3880	0.0000	0.0000	0.0000	0.0000;
	1265	1414	0.017355	0.048265	0.005145	120	120	120	0	0	1	-360	360	5.7847	0.6687	-5.7797	-1.2742	0.0000	0.0000	0.0000	0.0000;
	1561	1207	0.00686	0.022231	0.002331	140	140	140	0	0	1	-360	360	-0.0779	-6.5324	0.0802	6.2630	0.0000	0.0000	0.0000	0.0000;
	1057	1561	0.004298	0.013388	0.001488	140	140	140	0	0	1	-360	360	3.0204	-6.3541	-3.0186	6.1830	0.0000	0.0000	0.0000	0.0000;
	1352	1057	0.005785	0.017686	0.002079	140	140	140	0	0	1	-360	360	4.3633	-6.3430	-4.3604	6.1052	0.0000	0.0000	0.0000	0.0000;
	1560	1561	0.006033	0.01843	0.002183	140	140	140	0	0	1	-360	360	-3.0960	-0.6070	3.0965	0.3494	0.0000	0.0000	0.0000	0.0000;
	1057	1056	0.002314	0.002893	0.000549	90	90	90	0	0	1	-360	360	1.3400	0.2489	-1.3400	-0.3140	0.0000	0.0000	0.0000	0.0000;
	1712	976	0.005041	0.015372	0.001774	140	140	140	0	0	1	-360	360	12.6253	4.0145	-12.6180	-4.2107	0.0000	0.0000	0.0000	0.0000;
	1354	1712	0.010248	0.031405	0.003628	140	140	140	0	0	1	-360	360	16.0000	4.6648	-15.9768	-5.0416	0.0000	0.0000	0.0000	0.0000;
	1712	1710	0.005124	0.008595	0.000908	90	90	90	0	0	1	-360	360	3.3515	1.0271	-3.3510	-1.1380	0.0000	0.0000	0.0000	0.0000;
	1713	977	0.005041	0.015372	0.001774	140	140	140	0	0	1	-360	360	-20.0704	2.0989	20.0870	-2.2683	0.0000	0.0000	0.0000	0.0000;
	1354	1713	0.010248	0.031405	0.003628	140	140	140	0	0	1	-360	360	-17.7834	2.4614	17.8102	-2.8287	0.0000	0.0000	0.0000	0.0000;
	1713	1711	0.005124	0.008512	0.0009	90	90	90	0	0	1	-360	360	2.2602	0.7298	-2.2600	-0.8410	0.0000	0.0000	0.0000	0.0000;
	1889	1365	0.040165	0.070165	0.007071	90	90	90	0	0	1	-360	360	1.1919	0.6239	-1.1911	-1.4734	0.0000	0.0000	0.0000	0.0000;
	1675	1308	0.022479	0.06562	0.006333	120	120	120	0	0	1	-360	360	15.2587	0.9602	-15.2150	-1.5944	0.0000	0.0000	0.0000	0.0000;
	1674	1852	0.01876	0.055372	0.005322	120	120	120	0	0	1	-360	360	6.1319	1.1136	-6.1257	-1.7338	0.0000	0.0000	0.0000	0.0000;
	1322	1181	0.014628	0.045868	0.005084	140	140	140	0	0	1	-360	360	18.6708	1.5379	-18.6286	-2.0252	0.0000	0.0000	0.0000	0.0000;
	1591	1322	0.006281	0.019752	0.002183	140	140	140	0	0	1	-360	360	18.6888	1.2202	-18.6708	-1.4306	0.0000	0.0000	0.0000	0.0000;
	1322	1320	0.00438	0.00843	0.000879	90	90	90	0	0	1	-360	360	0.0000	-0.1073	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1323	929	0.006281	0.019504	0.002217	140	140	140	0	0	1	-360	360	-12.5786	-0.9997	12.5868	0.7546	0.0000	0.0000	0.0000	0.0000;
	1767	1323	0.005041	0.015454	0.001793	140	140	140	0	0	1	-360	360	-12.5720	-1.3052	12.5786	1.1069	0.0000	0.0000	0.0000	0.0000;
	1323	1321	0.00438	0.00843	0.000879	90	90	90	0	0	1	-360	360	0.0000	-0.1071	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1354	841	0.012479	0.045207	0.00537	114	114	114	0	0	1	-360	360	0.0000	-0.6647	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1353	842	0.012479	0.045207	0.00537	114	114	114	0	0	1	-360	360	16.5118	0.0953	-16.4840	-0.6500	0.0000	0.0000	0.0000	0.0000;
	1422	1008	0.002231	0.008347	0.000983	162	162	162	0	0	1	-360	360	8.2570	2.5269	-8.2556	-2.6432	0.0000	0.0000	0.0000	0.0000;
	993	1009	0.004132	0.01562	0.001878	162	162	162	0	0	1	-360	360	9.3585	2.7519	-9.3553	-2.9716	0.0000	0.0000	0.0000	0.0000;
	1354	993	0.004876	0.016446	0.00198	140	140	140	0	0	1	-360	360	11.6263	2.9940	-11.6206	-3.2196	0.0000	0.0000	0.0000	0.0000;
	993	992	0.00124	0.004463	0.000554	162	162	162	0	0	1	-360	360	2.2621	0.4677	-2.2620	-0.5360	0.0000	0.0000	0.0000	0.0000;
	1398	1234	0.005537	0.017355	0.001919	140	140	140	0	0	1	-360	360	0.4479	-3.2510	-0.4474	3.0184	0.0000	0.0000	0.0000	0.0000;
	1464	1338	0.04157	0.060826	0.010346	57	57	57	0	0	1	-360	360	6.1088	1.1928	-6.0945	-2.3910	0.0000	0.0000	0.0000	0.0000;
	1495	1782	0.003967	0.011983	0.001421	140	140	140	0	0	1	-360	360	1.0093	-2.6969	-1.0091	2.5246	0.0000	0.0000	0.0000	0.0000;
	1668	1864	0.015868	0.048016	0.005704	114	114	114	0	0	1	-360	360	10.6942	2.6711	-10.6776	-3.2922	0.0000	0.0000	0.0000	0.0000;
	1011	1668	0.02157	0.065454	0.007771	114	114	114	0	0	1	-360	360	10.7159	1.7153	-10.6942	-2.5692	0.0000	0.0000	0.0000	0.0000;
	1667	1668	0.002397	0.007273	0.000864	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.1019	0.0000	0.0000	0.0000	0.0000;
	1441	1772	0.002397	0.007355	0.000852	140	140	140	0	0	1	-360	360	4.1455	-2.9122	-4.1450	2.8099	0.0000	0.0000	0.0000	0.0000;
	1388	1294	0.010496	0.031901	0.003782	114	114	114	0	0	1	-360	360	8.1433	-1.5920	-8.1373	1.1602	0.0000	0.0000	0.0000	0.0000;
	1223	1450	0.024793	0.041322	0.004259	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1069	991	0.010826	0.023967	0.003364	114	114	114	0	0	1	-360	360	13.6653	2.0155	-13.6480	-2.3798	0.0000	0.0000	0.0000	0.0000;
	1747	1503	0.008347	0.024959	0.003015	114	114	114	0	0	1	-360	360	-20.2055	-2.0847	20.2341	1.8083	0.0000	0.0000	0.0000	0.0000;
	1120	1433	0.024793	0.083471	0.010285	114	114	114	0	0	1	-360	360	-41.1284	-15.1865	41.5311	15.3127	0.0000	0.0000	0.0000	0.0000;
	1498	1433	0.034876	0.093058	0.01232	120	120	120	0	0	1	-360	360	-24.8470	-6.4223	25.0374	5.4469	0.0000	0.0000	0.0000	0.0000;
	1589	1314	0.008182	0.014628	0.00304	120	120	120	0	0	1	-360	360	43.3775	-1.8379	-43.2506	1.6965	0.0000	0.0000	0.0000	0.0000;
	1751	963	0.056033	0.074711	0.007168	75	75	75	0	0	1	-360	360	3.0590	-2.4219	-3.0528	1.5667	0.0000	0.0000	0.0000	0.0000;
	1751	1333	0.038265	0.051984	0.004753	57	57	57	0	0	1	-360	360	9.7841	-1.6410	-9.7532	1.1120	0.0000	0.0000	0.0000	0.0000;
	1337	1248	0.029256	0.050826	0.004973	90	90	90	0	0	1	-360	360	13.0375	-1.9002	-12.9960	1.3689	0.0000	0.0000	0.0000	0.0000;
	1890	1005	0.019752	0.05124	0.005878	90	90	90	0	0	1	-360	360	5.0630	-1.4869	-5.0586	0.7826	0.0000	0.0000	0.0000	0.0000;
	1484	1268	0.021818	0.065702	0.007795	90	90	90	0	0	1	-360	360	-0.8055	0.4407	0.8058	-1.3873	0.0000	0.0000	0.0000	0.0000;
	1569	1268	0.036281	0.070579	0.007366	90	90	90	0	0	1	-360	360	-4.6104	1.3971	4.6178	-2.2775	0.0000	0.0000	0.0000	0.0000;
	1804	1016	0.019917	0.060579	0.007124	114	114	114	0	0	1	-360	360	8.1795	-1.5403	-8.1683	0.7108	0.0000	0.0000	0.0000	0.0000;
	1212	1014	0.007769	0.023719	0.002798	140	140	140	0	0	1	-360	360	-7.4271	-0.3553	7.4306	0.0267	0.0000	0.0000	0.0000	0.0000;
	849	1805	0.047603	0.060165	0.005242	60	60	60	0	0	1	-360	360	-2.1800	-0.4460	2.1819	-0.1864	0.0000	0.0000	0.0000	0.0000;
	1014	1691	0.052479	0.129917	0.014394	114	114	114	0	0	1	-360	360	0.9368	2.8207	-0.9305	-4.5450	0.0000	0.0000	0.0000	0.0000;
	1887	940	0.032645	0.079091	0.009402	114	114	114	0	0	1	-360	360	-8.7729	4.3912	8.8004	-5.4559	0.0000	0.0000	0.0000	0.0000;
	880	1216	0.023719	0.033388	0.00589	90	90	90	0	0	1	-360	360	2.5733	-1.4433	-2.5717	0.7416	0.0000	0.0000	0.0000	0.0000;
	1176	1715	0.008264	0.026364	0.002848	140	140	140	0	0	1	-360	360	-0.0194	0.0717	0.0194	-0.4174	0.0000	0.0000	0.0000	0.0000;
	1014	1176	0.019917	0.063884	0.00674	114	114	114	0	0	1	-360	360	0.9848	-0.6178	-0.9847	-0.1998	0.0000	0.0000	0.0000	0.0000;
	1175	1176	0.000992	0.003141	0.00037	114	114	114	0	0	1	-360	360	-1.0040	-0.1730	1.0040	0.1281	0.0000	0.0000	0.0000	0.0000;
	1691	1225	0.013554	0.040992	0.004864	114	114	114	0	0	1	-360	360	15.5337	-4.3912	-15.5046	3.8939	0.0000	0.0000	0.0000	0.0000;
	1209	971	0.005372	0.017025	0.001861	114	114	114	0	0	1	-360	360	12.6831	0.2884	-12.6760	-0.4919	0.0000	0.0000	0.0000	0.0000;
	1488	1646	0.020248	0.067934	0.006556	114	114	114	0	0	1	-360	360	10.1897	-3.2084	-10.1704	2.5051	0.0000	0.0000	0.0000	0.0000;
	1739	1806	0.037273	0.119504	0.012681	114	114	114	0	0	1	-360	360	-10.3564	-1.9524	10.3913	0.5873	0.0000	0.0000	0.0000	0.0000;
	1740	961	0.01876	0.059339	0.006437	114	114	114	0	0	1	-360	360	-9.2666	-1.7966	9.2808	1.0934	0.0000	0.0000	0.0000	0.0000;
	1555	1389	0.015868	0.053554	0.005135	114	114	114	0	0	1	-360	360	-4.4937	1.7059	4.4969	-2.3066	0.0000	0.0000	0.0000	0.0000;
	1210	885	0.006777	0.021488	0.002343	114	114	114	0	0	1	-360	360	-12.6832	-0.2895	12.6922	0.0331	0.0000	0.0000	0.0000	0.0000;
	1202	886	0.015372	0.048926	0.005234	114	114	114	0	0	1	-360	360	-5.3322	-1.3816	5.3360	0.7571	0.0000	0.0000	0.0000	0.0000;
	1867	885	0.00686	0.021901	0.002331	114	114	114	0	0	1	-360	360	-0.5020	-0.0870	0.5020	-0.1966	0.0000	0.0000	0.0000	0.0000;
	1868	886	0.00686	0.021901	0.002335	114	114	114	0	0	1	-360	360	-0.3350	-0.0430	0.3350	-0.2412	0.0000	0.0000	0.0000	0.0000;
	1750	1792	0.053058	0.227273	0.025112	114	114	114	0	0	1	-360	360	-8.1261	1.0878	8.1588	-3.8973	0.0000	0.0000	0.0000	0.0000;
	1079	1791	0.049174	0.21124	0.023334	114	114	114	0	0	1	-360	360	-11.2706	1.2975	11.3268	-3.7940	0.0000	0.0000	0.0000	0.0000;
	1545	1430	0.034298	0.10595	0.011374	114	114	114	0	0	1	-360	360	30.6690	8.9227	-30.3753	-9.3641	0.0000	0.0000	0.0000	0.0000;
	1126	1103	0.000496	0.000909	7.7e-05	90	90	90	0	0	1	-360	360	-8.1185	2.2330	8.1188	-2.2418	0.0000	0.0000	0.0000	0.0000;
	1130	1126	0.004132	0.007107	0.000692	90	90	90	0	0	1	-360	360	-6.0239	2.6195	6.0254	-2.7007	0.0000	0.0000	0.0000	0.0000;
	1859	1130	0.004132	0.006942	0.000721	90	90	90	0	0	1	-360	360	-6.0225	2.5312	6.0239	-2.6160	0.0000	0.0000	0.0000	0.0000;
	1124	1126	0.001157	0.002149	0.000194	90	90	90	0	0	1	-360	360	-2.0930	-0.4910	2.0930	0.4677	0.0000	0.0000	0.0000	0.0000;
	1128	1130	8.3e-05	0.000248	2.9e-05	140	140	140	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0035	0.0000	0.0000	0.0000	0.0000;
	986	856	0.017355	0.050165	0.006278	114	114	114	0	0	1	-360	360	17.0696	-1.1824	-17.0279	0.5408	0.0000	0.0000	0.0000	0.0000;
	1263	1235	0.024546	0.061488	0.006486	76	76	76	0	0	1	-360	360	13.7069	0.3206	-13.6690	-1.0124	0.0000	0.0000	0.0000	0.0000;
	1366	1136	0.026612	0.041322	0.006396	90	90	90	0	0	1	-360	360	-6.7673	1.5903	6.7783	-2.3428	0.0000	0.0000	0.0000	0.0000;
	1859	1205	0.031653	0.061735	0.011805	120	120	120	0	0	1	-360	360	23.2834	-4.3397	-23.1381	3.2015	0.0000	0.0000	0.0000	0.0000;
	1860	1135	0.045455	0.05686	0.010803	90	90	90	0	0	1	-360	360	9.7460	-2.9006	-9.7084	1.6433	0.0000	0.0000	0.0000	0.0000;
	1243	855	0.002975	0.009504	0.000997	114	114	114	0	0	1	-360	360	6.2317	0.2135	-6.2308	-0.3312	0.0000	0.0000	0.0000	0.0000;
	1511	1263	0.013471	0.043306	0.004559	114	114	114	0	0	1	-360	360	-2.2609	-0.3659	2.2615	-0.1871	0.0000	0.0000	0.0000	0.0000;
	904	1235	0.008926	0.024793	0.002756	140	140	140	0	0	1	-360	360	-4.5409	0.3125	4.5424	-0.6416	0.0000	0.0000	0.0000	0.0000;
	1280	1206	0.020413	0.039752	0.007577	120	120	120	0	0	1	-360	360	-22.0479	2.6861	22.1327	-3.4270	0.0000	0.0000	0.0000	0.0000;
	1611	1131	8.3e-05	0.000826	7e-06	90	90	90	0	0	1	-360	360	13.4321	3.2464	-13.4320	-3.2460	0.0000	0.0000	0.0000	0.0000;
	1860	1611	0.006529	0.010992	0.001128	90	90	90	0	0	1	-360	360	14.7836	3.5572	-14.7711	-3.6725	0.0000	0.0000	0.0000	0.0000;
	1611	1610	0.000165	0.000248	2.4e-05	90	90	90	0	0	1	-360	360	1.3390	0.4261	-1.3390	-0.4290	0.0000	0.0000	0.0000	0.0000;
	1129	1132	0.002562	0.00438	0.000443	90	90	90	0	0	1	-360	360	7.2931	0.8284	-7.2920	-0.8800	0.0000	0.0000	0.0000	0.0000;
	1859	1129	0.00405	0.006777	0.000707	90	90	90	0	0	1	-360	360	8.3005	0.8396	-8.2981	-0.9211	0.0000	0.0000	0.0000	0.0000;
	1127	1129	0.000744	0.002314	0.000276	76	76	76	0	0	1	-360	360	-1.0050	-0.1260	1.0050	0.0927	0.0000	0.0000	0.0000	0.0000;
	1125	856	0.010826	0.021818	0.002998	90	90	90	0	0	1	-360	360	-11.2993	1.7535	11.3110	-2.0928	0.0000	0.0000	0.0000	0.0000;
	1102	1125	0.000413	0.000744	6.8e-05	90	90	90	0	0	1	-360	360	-11.2988	1.7209	11.2993	-1.7283	0.0000	0.0000	0.0000	0.0000;
	1123	1125	0.00124	0.002149	0.000208	90	90	90	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0252	0.0000	0.0000	0.0000	0.0000;
	1920	855	0.004545	0.007934	0.000833	90	90	90	0	0	1	-360	360	-3.0130	-0.2820	3.0133	0.1818	0.0000	0.0000	0.0000	0.0000;
	1921	856	0.004545	0.007934	0.000833	90	90	90	0	0	1	-360	360	-0.9200	-0.2710	0.9200	0.1702	0.0000	0.0000	0.0000	0.0000;
	1677	855	0.004132	0.010992	0.001735	114	114	114	0	0	1	-360	360	-11.7820	0.4172	11.7868	-0.6147	0.0000	0.0000	0.0000	0.0000;
	1235	1741	0.006777	0.01124	0.001191	29	29	29	0	0	1	-360	360	2.0102	0.1694	-2.0100	-0.3130	0.0000	0.0000	0.0000	0.0000;
	1236	1742	0.006777	0.01124	0.001191	57	57	57	0	0	1	-360	360	3.2646	0.3990	-3.2640	-0.5420	0.0000	0.0000	0.0000	0.0000;
	1574	1417	0.037025	0.06719	0.006691	90	90	90	0	0	1	-360	360	14.0803	1.1493	-14.0185	-1.8381	0.0000	0.0000	0.0000	0.0000;
	1554	1417	0.014876	0.028099	0.002979	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1871	1418	0.007603	0.011735	0.001496	90	90	90	0	0	1	-360	360	2.7340	-0.5850	-2.7335	0.4076	0.0000	0.0000	0.0000	0.0000;
	1870	1871	0.000992	0.001736	0.000165	90	90	90	0	0	1	-360	360	2.7341	-0.6045	-2.7340	0.5850	0.0000	0.0000	0.0000	0.0000;
	1451	1870	0.006198	0.007769	0.001481	90	90	90	0	0	1	-360	360	2.7345	-0.7803	-2.7341	0.6045	0.0000	0.0000	0.0000	0.0000;
	1554	1871	0.007273	0.014545	0.001549	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1223	1870	0.019008	0.033058	0.003151	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1919	1295	0.019091	0.057769	0.006863	114	114	114	0	0	1	-360	360	-5.4533	0.6653	5.4582	-1.4664	0.0000	0.0000	0.0000	0.0000;
	1859	1134	0.007025	0.015703	0.001757	90	90	90	0	0	1	-360	360	0.1269	2.6208	-0.1265	-2.8322	0.0000	0.0000	0.0000	0.0000;
	1133	855	0.010826	0.032727	0.003884	114	114	114	0	0	1	-360	360	-12.0145	-0.6290	12.0275	0.1982	0.0000	0.0000	0.0000	0.0000;
	1624	856	0.008595	0.026033	0.00309	114	114	114	0	0	1	-360	360	-14.0058	-0.3569	14.0197	0.0252	0.0000	0.0000	0.0000	0.0000;
	1690	1279	0.028347	0.06595	0.009854	120	120	120	0	0	1	-360	360	-10.2684	0.5501	10.2939	-1.6640	0.0000	0.0000	0.0000	0.0000;
	1918	1690	0.008595	0.026033	0.003095	114	114	114	0	0	1	-360	360	4.2813	-0.7495	-4.2799	0.3857	0.0000	0.0000	0.0000	0.0000;
	1689	1670	0.015703	0.047686	0.005665	114	114	114	0	0	1	-360	360	-0.6142	-0.1830	0.6142	-0.4901	0.0000	0.0000	0.0000	0.0000;
	1721	1485	0.014711	0.02595	0.002841	57	57	57	0	0	1	-360	360	1.7919	0.1049	-1.7915	-0.4497	0.0000	0.0000	0.0000	0.0000;
	1880	1264	0.003058	0.00843	0.001447	114	114	114	0	0	1	-360	360	-12.5358	-0.5486	12.5397	0.3834	0.0000	0.0000	0.0000	0.0000;
	1365	1312	0.011901	0.036116	0.004264	114	114	114	0	0	1	-360	360	3.5204	-0.4480	-3.5192	-0.0607	0.0000	0.0000	0.0000	0.0000;
	1313	898	0.008843	0.026777	0.003178	114	114	114	0	0	1	-360	360	1.4231	-0.2963	-1.4230	-0.0850	0.0000	0.0000	0.0000	0.0000;
	1720	1004	0.026777	0.063223	0.007267	57	57	57	0	0	1	-360	360	-1.7919	-0.1189	1.7926	-0.7637	0.0000	0.0000	0.0000	0.0000;
	1568	1510	0.031983	0.102397	0.010846	114	114	114	0	0	1	-360	360	-0.2506	-1.7002	0.2509	0.3829	0.0000	0.0000	0.0000	0.0000;
	1264	1213	0.036116	0.11595	0.012221	114	114	114	0	0	1	-360	360	-2.3190	-0.9419	2.3206	-0.5418	0.0000	0.0000	0.0000	0.0000;
	1859	1637	0.023636	0.076942	0.007921	114	114	114	0	0	1	-360	360	1.3513	-0.0296	-1.3509	-0.9265	0.0000	0.0000	0.0000	0.0000;
	1879	1244	0.02281	0.041818	0.008523	120	120	120	0	0	1	-360	360	9.7737	-0.2442	-9.7558	-0.7577	0.0000	0.0000	0.0000	0.0000;
	951	1236	0	0.000826	7e-06	120	120	120	0	0	1	-360	360	-6.1703	0.8721	6.1703	-0.8727	0.0000	0.0000	0.0000	0.0000;
	1859	951	0.009504	0.03	0.003308	120	120	120	0	0	1	-360	360	-4.4934	0.6333	4.4951	-1.0282	0.0000	0.0000	0.0000	0.0000;
	950	951	0.009504	0.032231	0.003073	140	140	140	0	0	1	-360	360	-1.6750	-0.5270	1.6752	0.1561	0.0000	0.0000	0.0000	0.0000;
	1859	903	0.004298	0.013471	0.001493	114	114	114	0	0	1	-360	360	-2.0267	1.2547	2.0269	-1.4346	0.0000	0.0000	0.0000	0.0000;
	1266	1860	0.040579	0.104959	0.011437	120	120	120	0	0	1	-360	360	-6.2027	-0.7970	6.2157	-0.5509	0.0000	0.0000	0.0000	0.0000;
	1860	1575	0.017521	0.031983	0.00311	90	90	90	0	0	1	-360	360	17.5626	1.6445	-17.5175	-1.9374	0.0000	0.0000	0.0000	0.0000;
	1640	1625	0.003141	0.009504	0.001125	114	114	114	0	0	1	-360	360	-11.7401	-0.2018	11.7437	0.0767	0.0000	0.0000	0.0000	0.0000;
	1638	1640	0	0.000826	1e-05	114	114	114	0	0	1	-360	360	-5.4471	0.3473	5.4471	-0.3483	0.0000	0.0000	0.0000	0.0000;
	1639	1640	0	0.000826	1e-05	114	114	114	0	0	1	-360	360	-6.2930	-0.5510	6.2930	0.5501	0.0000	0.0000	0.0000	0.0000;
	1236	1676	0.005537	0.013967	0.002464	114	114	114	0	0	1	-360	360	-8.5136	0.5282	8.5169	-0.8179	0.0000	0.0000	0.0000	0.0000;
	1450	1554	0.002149	0.006033	0.000632	90	90	90	0	0	1	-360	360	-2.8185	0.7453	2.8186	-0.8201	0.0000	0.0000	0.0000	0.0000;
	958	855	0.005455	0.017521	0.001847	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.2237	0.0000	0.0000	0.0000	0.0000;
	959	856	0.004959	0.017521	0.001847	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.2237	0.0000	0.0000	0.0000	0.0000;
	1249	934	0.019008	0.060413	0.006548	114	114	114	0	0	1	-360	360	-6.4561	1.1008	6.4631	-1.8633	0.0000	0.0000	0.0000	0.0000;
	1903	933	0.005041	0.015289	0.001815	114	114	114	0	0	1	-360	360	15.7707	-2.0120	-15.7601	1.8265	0.0000	0.0000	0.0000	0.0000;
	1250	852	0.014215	0.025041	0.002563	90	90	90	0	0	1	-360	360	-7.8138	0.9094	7.8212	-1.2036	0.0000	0.0000	0.0000	0.0000;
	935	1696	0.02157	0.068265	0.007163	114	114	114	0	0	1	-360	360	-3.0705	1.8682	3.0732	-2.7117	0.0000	0.0000	0.0000	0.0000;
	1286	1222	0.015454	0.052066	0.004997	114	114	114	0	0	1	-360	360	-23.2581	0.9962	23.3280	-1.3610	0.0000	0.0000	0.0000	0.0000;
	1820	1286	0.012645	0.030248	0.004257	114	114	114	0	0	1	-360	360	-19.4401	1.6470	19.4805	-2.0599	0.0000	0.0000	0.0000	0.0000;
	1048	936	0.002727	0.007438	0.000806	114	114	114	0	0	1	-360	360	0.9566	2.4488	-0.9565	-2.5443	0.0000	0.0000	0.0000	0.0000;
	1663	1025	0.025372	0.042231	0.00635	90	90	90	0	0	1	-360	360	-8.3229	-0.6038	8.3377	-0.1292	0.0000	0.0000	0.0000	0.0000;
	1872	1429	0.001488	0.004793	0.000494	114	114	114	0	0	1	-360	360	-39.3312	-16.1840	39.3543	16.2010	0.0000	0.0000	0.0000	0.0000;
	1813	1872	0.013223	0.031322	0.003403	90	90	90	0	0	1	-360	360	26.1795	10.5849	-26.0894	-10.7695	0.0000	0.0000	0.0000	0.0000;
	1696	1812	0.008182	0.025041	0.002943	114	114	114	0	0	1	-360	360	34.1047	11.9842	-34.0144	-12.0560	0.0000	0.0000	0.0000	0.0000;
	1927	1726	0.009008	0.015041	0.001619	90	90	90	0	0	1	-360	360	9.7447	0.4397	-9.7375	-0.6200	0.0000	0.0000	0.0000	0.0000;
	1409	1315	0.003306	0.007934	0.000903	120	120	120	0	0	1	-360	360	-39.5813	2.1958	39.6244	-2.2014	0.0000	0.0000	0.0000	0.0000;
	1427	847	0.004711	0.014215	0.001689	114	114	114	0	0	1	-360	360	-10.8492	3.3911	10.8543	-3.5774	0.0000	0.0000	0.0000	0.0000;
	1049	1411	0.002975	0.007025	0.000992	114	114	114	0	0	1	-360	360	-4.2196	-2.9128	4.2203	2.7962	0.0000	0.0000	0.0000	0.0000;
	1716	1287	0.015868	0.042645	0.004371	114	114	114	0	0	1	-360	360	22.8800	-4.2313	-22.8085	3.9012	0.0000	0.0000	0.0000	0.0000;
	1748	1695	0.026116	0.033802	0.0062	90	90	90	0	0	1	-360	360	16.8232	1.5232	-16.7608	-2.1824	0.0000	0.0000	0.0000	0.0000;
	1821	848	0.004132	0.012479	0.001484	114	114	114	0	0	1	-360	360	14.5300	-2.6479	-14.5224	2.4934	0.0000	0.0000	0.0000	0.0000;
	1026	1287	0.008595	0.026529	0.003035	114	114	114	0	0	1	-360	360	-8.3628	6.5322	8.3710	-6.8690	0.0000	0.0000	0.0000	0.0000;
	1497	1696	0.00281	0.009008	0.000975	114	114	114	0	0	1	-360	360	13.7765	3.4108	-13.7717	-3.5115	0.0000	0.0000	0.0000	0.0000;
	1221	1570	0.010331	0.032314	0.003596	114	114	114	0	0	1	-360	360	-23.9894	1.5072	24.0390	-1.7860	0.0000	0.0000	0.0000	0.0000;
	1888	1015	0.020579	0.051488	0.006086	114	114	114	0	0	1	-360	360	5.3538	-4.9196	-5.3454	4.2069	0.0000	0.0000	0.0000	0.0000;
	1241	1015	0.004628	0.008347	0.001747	114	114	114	0	0	1	-360	360	-22.7109	1.8371	22.7308	-2.0119	0.0000	0.0000	0.0000	0.0000;
	1815	1571	0.019174	0.06157	0.00651	114	114	114	0	0	1	-360	360	-15.1814	0.6276	15.2183	-1.2944	0.0000	0.0000	0.0000	0.0000;
	854	1815	0.018017	0.023884	0.004291	90	90	90	0	0	1	-360	360	-13.0614	0.6746	13.0871	-1.1561	0.0000	0.0000	0.0000	0.0000;
	1814	1815	0.006694	0.008347	0.001585	29	29	29	0	0	1	-360	360	-2.0940	-0.7190	2.0943	0.5285	0.0000	0.0000	0.0000	0.0000;
	1885	1226	0.017025	0.051984	0.00611	114	114	114	0	0	1	-360	360	-12.6879	4.0174	12.7134	-4.6745	0.0000	0.0000	0.0000	0.0000;
	1754	1885	0.040909	0.053884	0.009864	90	90	90	0	0	1	-360	360	-9.1114	0.5259	9.1402	-1.6714	0.0000	0.0000	0.0000	0.0000;
	1607	1286	0.006612	0.020661	0.002331	114	114	114	0	0	1	-360	360	36.5017	-1.9848	-36.4283	1.9344	0.0000	0.0000	0.0000	0.0000;
	1927	1286	0.025124	0.076198	0.009039	114	114	114	0	0	1	-360	360	-15.2227	-1.8377	15.2720	0.9083	0.0000	0.0000	0.0000	0.0000;
	1842	1813	0.01438	0.046198	0.004867	114	114	114	0	0	1	-360	360	-2.9670	-0.8820	2.9681	0.3133	0.0000	0.0000	0.0000	0.0000;
	1608	1928	0.02876	0.090165	0.010016	114	114	114	0	0	1	-360	360	-0.8153	-1.4284	0.8156	0.2402	0.0000	0.0000	0.0000	0.0000;
	1286	1028	0.002645	0.008017	0.000949	114	114	114	0	0	1	-360	360	0.0000	-0.1137	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1664	1928	0.019587	0.03124	0.005114	90	90	90	0	0	1	-360	360	5.6609	0.2235	-5.6556	-0.8232	0.0000	0.0000	0.0000	0.0000;
	1250	1717	0.003719	0.009835	0.00098	114	114	114	0	0	1	-360	360	26.2032	-3.7035	-26.1815	3.6437	0.0000	0.0000	0.0000	0.0000;
	1886	1570	0.024215	0.076859	0.008327	114	114	114	0	0	1	-360	360	-1.6383	-3.6531	1.6408	2.6571	0.0000	0.0000	0.0000	0.0000;
	1016	1570	0.007686	0.024711	0.002594	114	114	114	0	0	1	-360	360	16.2476	-0.1972	-16.2309	-0.0628	0.0000	0.0000	0.0000	0.0000;
	1015	1571	0.007686	0.024711	0.002594	114	114	114	0	0	1	-360	360	-3.3029	-2.2840	3.3039	1.9739	0.0000	0.0000	0.0000	0.0000;
	1249	1570	0.019256	0.061983	0.006515	114	114	114	0	0	1	-360	360	-24.5857	-1.1722	24.6829	0.7014	0.0000	0.0000	0.0000	0.0000;
	1429	1119	0.002975	0.013058	0.002154	114	114	114	0	0	1	-360	360	-36.7151	-16.2618	36.7562	16.1902	0.0000	0.0000	0.0000	0.0000;
	1027	1428	0.00405	0.011653	0.00129	114	114	114	0	0	1	-360	360	-5.9732	4.5243	5.9751	-4.6728	0.0000	0.0000	0.0000	0.0000;
	1832	1727	0.020331	0.065372	0.006902	114	114	114	0	0	1	-360	360	-5.0680	-0.0640	5.0724	-0.7404	0.0000	0.0000	0.0000	0.0000;
	1410	1606	0.005124	0.015868	0.00181	114	114	114	0	0	1	-360	360	38.9273	-2.2672	-38.8627	2.2492	0.0000	0.0000	0.0000	0.0000;
	1831	1609	0.01562	0.050248	0.005283	114	114	114	0	0	1	-360	360	0.8450	-1.4030	-0.8447	0.7774	0.0000	0.0000	0.0000	0.0000;
	1242	1904	0.017355	0.024711	0.004378	90	90	90	0	0	1	-360	360	19.3446	-2.4610	-19.2900	2.0124	0.0000	0.0000	0.0000	0.0000;
	1412	1287	0.002893	0.009256	0.000997	114	114	114	0	0	1	-360	360	-11.1863	-4.5478	11.1899	4.4402	0.0000	0.0000	0.0000	0.0000;
	1695	1286	0.021984	0.070909	0.007446	114	114	114	0	0	1	-360	360	-10.4489	-4.3066	10.4718	3.4919	0.0000	0.0000	0.0000	0.0000;
	1753	880	0.016364	0.02157	0.003969	90	90	90	0	0	1	-360	360	5.9944	-1.3992	-5.9893	0.9313	0.0000	0.0000	0.0000	0.0000;
	1016	1384	0.008843	0.028017	0.00303	114	114	114	0	0	1	-360	360	-8.0793	-0.5137	8.0841	0.1617	0.0000	0.0000	0.0000	0.0000;
	1385	970	0.004793	0.014959	0.001658	114	114	114	0	0	1	-360	360	-9.7591	-0.5452	9.7629	0.3559	0.0000	0.0000	0.0000	0.0000;
	1287	990	0.017934	0.044876	0.005385	114	114	114	0	0	1	-360	360	-3.0674	-1.1279	3.0689	0.4889	0.0000	0.0000	0.0000	0.0000;
	945	1007	0.013471	0.042645	0.004646	140	140	140	0	0	1	-360	360	-30.3766	-2.6983	30.4783	2.4463	0.0000	0.0000	0.0000	0.0000;
	968	945	8.3e-05	0.000248	2.4e-05	114	114	114	0	0	1	-360	360	-28.2839	-2.5145	28.2845	2.5132	0.0000	0.0000	0.0000	0.0000;
	943	945	0.004628	0.014132	0.00167	114	114	114	0	0	1	-360	360	-2.0920	-0.3900	2.0922	0.1851	0.0000	0.0000	0.0000	0.0000;
	1641	1336	0.040248	0.070579	0.006735	90	90	90	0	0	1	-360	360	15.6320	-2.2877	-15.5507	1.6078	0.0000	0.0000	0.0000	0.0000;
	953	1641	0.019669	0.040579	0.003599	90	90	90	0	0	1	-360	360	-36.4196	0.0474	36.6349	-0.0420	0.0000	0.0000	0.0000	0.0000;
	1540	953	0.006942	0.018678	0.001767	90	90	90	0	0	1	-360	360	-35.0081	0.2364	35.0786	-0.2605	0.0000	0.0000	0.0000	0.0000;
	1595	1540	0.000661	0.001157	0.000169	90	90	90	0	0	1	-360	360	-24.1777	2.8369	24.1809	-2.8517	0.0000	0.0000	0.0000	0.0000;
	952	953	0.002727	0.003636	0.000322	75	75	75	0	0	1	-360	360	-1.3410	-0.2520	1.3410	0.2130	0.0000	0.0000	0.0000	0.0000;
	1538	1540	0.000165	0.000496	4.4e-05	140	140	140	0	0	1	-360	360	-10.8270	-2.6200	10.8272	2.6152	0.0000	0.0000	0.0000	0.0000;
	1483	1068	0.002149	0.006612	0.000779	114	114	114	0	0	1	-360	360	15.2597	2.1525	-15.2554	-2.2329	0.0000	0.0000	0.0000	0.0000;
	1757	1364	0.012562	0.045041	0.004371	114	114	114	0	0	1	-360	360	-6.4412	-3.1709	6.4464	2.6597	0.0000	0.0000	0.0000	0.0000;
	1869	922	0.01	0.025124	0.002819	120	120	120	0	0	1	-360	360	-12.0005	-0.0745	12.0124	-0.2381	0.0000	0.0000	0.0000	0.0000;
	1892	1869	0.005868	0.020909	0.002072	140	140	140	0	0	1	-360	360	-4.7092	0.6641	4.7103	-0.9115	0.0000	0.0000	0.0000	0.0000;
	1913	1869	8.3e-05	0.000331	3.6e-05	140	140	140	0	0	1	-360	360	-7.2901	-0.9903	7.2902	0.9860	0.0000	0.0000	0.0000	0.0000;
	866	1913	0.000331	0.000992	0.000121	114	114	114	0	0	1	-360	360	-6.2860	-1.0250	6.2861	1.0106	0.0000	0.0000	0.0000	0.0000;
	1911	1913	0.004463	0.013636	0.001619	140	140	140	0	0	1	-360	360	-1.0040	-0.1760	1.0040	-0.0203	0.0000	0.0000	0.0000	0.0000;
	857	1116	0.013967	0.043388	0.004898	140	140	140	0	0	1	-360	360	5.8499	0.9473	-5.8458	-1.5351	0.0000	0.0000	0.0000	0.0000;
	1588	1288	0.02281	0.063967	0.009043	140	140	140	0	0	1	-360	360	-47.2309	1.3682	47.6504	-1.2995	0.0000	0.0000	0.0000	0.0000;
	1434	1546	0.006694	0.017273	0.002389	120	120	120	0	0	1	-360	360	15.6651	1.7014	-15.6514	-1.9572	0.0000	0.0000	0.0000	0.0000;
	1434	1195	0.004545	0.013967	0.001283	120	120	120	0	0	1	-360	360	21.1591	0.9875	-21.1424	-1.0924	0.0000	0.0000	0.0000	0.0000;
	1196	922	0.005702	0.01719	0.002118	140	140	140	0	0	1	-360	360	13.7783	-0.3389	-13.7694	0.1081	0.0000	0.0000	0.0000	0.0000;
	1851	1433	0.013636	0.033967	0.003707	120	120	120	0	0	1	-360	360	13.4667	1.4091	-13.4462	-1.8106	0.0000	0.0000	0.0000	0.0000;
	1201	1433	0.017851	0.04405	0.004825	120	120	120	0	0	1	-360	360	14.2909	1.6918	-14.2605	-2.2066	0.0000	0.0000	0.0000	0.0000;
	1586	1201	0.004876	0.013471	0.001566	120	120	120	0	0	1	-360	360	14.7176	1.5599	-14.7089	-1.7278	0.0000	0.0000	0.0000	0.0000;
	1201	1199	0.000909	0.002066	0.000237	120	120	120	0	0	1	-360	360	0.4180	0.0359	-0.4180	-0.0650	0.0000	0.0000	0.0000	0.0000;
	1434	1187	0.016694	0.045207	0.005467	120	120	120	0	0	1	-360	360	-40.1712	-3.5559	40.3935	3.4867	0.0000	0.0000	0.0000	0.0000;
	1516	1171	0.000826	0.002479	0.000269	114	114	114	0	0	1	-360	360	-50.9125	-4.7630	50.9298	4.7816	0.0000	0.0000	0.0000	0.0000;
	1100	1516	0.002149	0.003884	0.000779	120	120	120	0	0	1	-360	360	-45.0102	-3.7858	45.0455	3.7527	0.0000	0.0000	0.0000	0.0000;
	1186	1100	0.00595	0.010661	0.002222	120	120	120	0	0	1	-360	360	-44.5789	-3.9330	44.6752	3.8303	0.0000	0.0000	0.0000	0.0000;
	1516	1514	0	0.000826	7e-06	114	114	114	0	0	1	-360	360	5.8670	1.0103	-5.8670	-1.0110	0.0000	0.0000	0.0000	0.0000;
	1100	1098	0.002397	0.004876	0.000704	90	90	90	0	0	1	-360	360	0.3350	-0.0445	-0.3350	-0.0430	0.0000	0.0000	0.0000	0.0000;
	1407	1631	0.008926	0.02876	0.003025	114	114	114	0	0	1	-360	360	-1.9207	-1.1580	1.9211	0.7951	0.0000	0.0000	0.0000	0.0000;
	1452	1407	0.004959	0.015868	0.001675	140	140	140	0	0	1	-360	360	1.0965	-0.9416	-1.0965	0.7403	0.0000	0.0000	0.0000	0.0000;
	1405	1407	0.002314	0.003802	0.000404	90	90	90	0	0	1	-360	360	-3.0170	-0.4660	3.0172	0.4177	0.0000	0.0000	0.0000	0.0000;
	1084	1630	0.000826	0.002562	0.000266	114	114	114	0	0	1	-360	360	-9.3360	-1.6704	9.3366	1.6402	0.0000	0.0000	0.0000	0.0000;
	869	1084	0.007934	0.025537	0.002684	140	140	140	0	0	1	-360	360	-4.8992	-1.7795	4.9010	1.4623	0.0000	0.0000	0.0000	0.0000;
	1082	1084	0.000248	0.000661	7.5e-05	114	114	114	0	0	1	-360	360	-4.4350	-0.2170	4.4350	0.2081	0.0000	0.0000	0.0000	0.0000;
	1416	1631	0.008017	0.02438	0.002553	120	120	120	0	0	1	-360	360	-14.2747	-7.6761	14.2921	7.4225	0.0000	0.0000	0.0000	0.0000;
	1415	1630	0.008099	0.025372	0.002633	120	120	120	0	0	1	-360	360	-14.1930	-5.5967	14.2086	5.3292	0.0000	0.0000	0.0000	0.0000;
	1632	1762	0.014463	0.043967	0.005193	114	114	114	0	0	1	-360	360	14.6793	2.3901	-14.6528	-2.9384	0.0000	0.0000	0.0000	0.0000;
	1671	1719	0.010083	0.031901	0.003453	114	114	114	0	0	1	-360	360	38.4901	2.1117	-38.3671	-2.1416	0.0000	0.0000	0.0000	0.0000;
	1191	1233	0.003719	0.011901	0.001251	140	140	140	0	0	1	-360	360	-2.5140	-0.4980	2.5142	0.3444	0.0000	0.0000	0.0000	0.0000;
	1379	1478	0.002231	0.006612	0.000789	114	114	114	0	0	1	-360	360	23.1832	2.7314	-23.1734	-2.8005	0.0000	0.0000	0.0000	0.0000;
	1810	1795	0.009587	0.030744	0.003233	114	114	114	0	0	1	-360	360	-11.9092	-2.2840	11.9207	1.9251	0.0000	0.0000	0.0000	0.0000;
	1437	1620	0.000992	0.003058	0.000346	114	114	114	0	0	1	-360	360	-46.8328	-3.1246	46.8504	3.1361	0.0000	0.0000	0.0000	0.0000;
	1642	1437	0.005785	0.01843	0.001951	114	114	114	0	0	1	-360	360	-48.1800	-7.4212	48.2916	7.5360	0.0000	0.0000	0.0000	0.0000;
	1435	1437	0.000826	0.002397	0.000281	114	114	114	0	0	1	-360	360	1.4590	4.3770	-1.4589	-4.4114	0.0000	0.0000	0.0000	0.0000;
	1837	1641	0.011901	0.036446	0.004262	114	114	114	0	0	1	-360	360	58.0364	-0.8133	-57.7130	1.2787	0.0000	0.0000	0.0000	0.0000;
	1144	948	0.004215	0.013306	0.001433	114	114	114	0	0	1	-360	360	-8.8174	-3.1764	8.8204	3.0134	0.0000	0.0000	0.0000	0.0000;
	1737	1284	0.005207	0.01595	0.001873	140	140	140	0	0	1	-360	360	-9.6015	0.8270	9.6056	-1.0401	0.0000	0.0000	0.0000	0.0000;
	1877	1476	0.004793	0.014628	0.001774	114	114	114	0	0	1	-360	360	-28.6474	-1.9283	28.6796	1.8087	0.0000	0.0000	0.0000	0.0000;
	996	1877	0.001901	0.006116	0.000646	114	114	114	0	0	1	-360	360	-27.2949	-1.5883	27.3064	1.5464	0.0000	0.0000	0.0000	0.0000;
	1875	1877	8.3e-05	0.000165	1.7e-05	114	114	114	0	0	1	-360	360	-1.3410	-0.3840	1.3410	0.3819	0.0000	0.0000	0.0000	0.0000;
	996	1613	0.001405	0.004132	0.000426	114	114	114	0	0	1	-360	360	25.0349	0.8303	-25.0277	-0.8613	0.0000	0.0000	0.0000	0.0000;
	1436	1620	0.001488	0.004628	0.000549	114	114	114	0	0	1	-360	360	7.0780	3.1530	-7.0773	-3.2189	0.0000	0.0000	0.0000	0.0000;
	941	1370	0.006777	0.021984	0.002297	114	114	114	0	0	1	-360	360	-8.4367	-1.4687	8.4407	1.1990	0.0000	0.0000	0.0000	0.0000;
	1085	1419	0.008099	0.020661	0.002323	120	120	120	0	0	1	-360	360	9.7626	3.2044	-9.7555	-3.4655	0.0000	0.0000	0.0000	0.0000;
	1631	1085	0.000496	0.001488	0.000162	114	114	114	0	0	1	-360	360	9.7631	3.1454	-9.7626	-3.1637	0.0000	0.0000	0.0000	0.0000;
	1085	1083	0.000909	0.002893	0.000339	57	57	57	0	0	1	-360	360	0.0000	-0.0408	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1137	976	0.001736	0.005289	0.000617	57	57	57	0	0	1	-360	360	-1.4230	-0.3030	1.4230	0.2273	0.0000	0.0000	0.0000	0.0000;
	1838	1324	0.012975	0.041074	0.004484	140	140	140	0	0	1	-360	360	20.0588	2.3972	-20.0160	-2.8162	0.0000	0.0000	0.0000	0.0000;
	1566	1738	0.003802	0.012149	0.001275	114	114	114	0	0	1	-360	360	-10.0977	-0.7354	10.1009	0.5923	0.0000	0.0000	0.0000	0.0000;
	1408	1566	0.006694	0.021653	0.002268	140	140	140	0	0	1	-360	360	-1.4698	0.2015	1.4699	-0.4737	0.0000	0.0000	0.0000	0.0000;
	870	1408	0.004463	0.014463	0.001517	114	114	114	0	0	1	-360	360	-0.7168	0.0985	0.7168	-0.2809	0.0000	0.0000	0.0000	0.0000;
	1566	1564	0.001157	0.002562	0.000254	90	90	90	0	0	1	-360	360	8.6277	1.2091	-8.6270	-1.2380	0.0000	0.0000	0.0000	0.0000;
	1406	1408	0.002314	0.003802	0.000404	90	90	90	0	0	1	-360	360	-0.7530	-0.1280	0.7530	0.0794	0.0000	0.0000	0.0000	0.0000;
	1737	1146	0.004463	0.014297	0.001515	114	114	114	0	0	1	-360	360	-8.2099	-1.7982	8.2125	1.6241	0.0000	0.0000	0.0000	0.0000;
	1233	1828	0.003306	0.010744	0.001101	140	140	140	0	0	1	-360	360	1.3401	0.3425	-1.3400	-0.4780	0.0000	0.0000	0.0000	0.0000;
	1233	1035	0.001405	0.004463	0.000469	114	114	114	0	0	1	-360	360	0.0000	-0.0579	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1479	1006	0.002397	0.007273	0.000857	140	140	140	0	0	1	-360	360	23.1730	2.7968	-23.1625	-2.8712	0.0000	0.0000	0.0000	0.0000;
	1838	1472	0.003802	0.01157	0.00137	140	140	140	0	0	1	-360	360	7.6711	0.2893	-7.6693	-0.4537	0.0000	0.0000	0.0000	0.0000;
	1621	1839	0.018347	0.056777	0.006459	114	114	114	0	0	1	-360	360	-27.2493	-0.8134	27.3592	0.3490	0.0000	0.0000	0.0000	0.0000;
	1101	981	0.000992	0.002893	0.000349	140	140	140	0	0	1	-360	360	30.1945	1.4197	-30.1872	-1.4419	0.0000	0.0000	0.0000	0.0000;
	1517	1101	0.001488	0.004463	0.00053	140	140	140	0	0	1	-360	360	30.2054	1.3286	-30.1945	-1.3620	0.0000	0.0000	0.0000	0.0000;
	1839	1517	0.004298	0.013388	0.001474	140	140	140	0	0	1	-360	360	30.2368	1.2416	-30.2054	-1.3277	0.0000	0.0000	0.0000	0.0000;
	1101	1099	0.001322	0.003884	0.000462	140	140	140	0	0	1	-360	360	0.0000	-0.0576	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1515	1517	0	0.000826	7e-06	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0009	0.0000	0.0000	0.0000	0.0000;
	1197	921	0.002727	0.008347	0.000973	140	140	140	0	0	1	-360	360	1.0016	0.0754	-1.0016	-0.1936	0.0000	0.0000	0.0000	0.0000;
	1910	1197	0.002231	0.007603	0.000728	140	140	140	0	0	1	-360	360	1.0017	-0.0132	-1.0016	-0.0754	0.0000	0.0000	0.0000	0.0000;
	1907	1910	8.3e-05	0.000165	1.7e-05	140	140	140	0	0	1	-360	360	1.0017	-0.0164	-1.0017	0.0143	0.0000	0.0000	0.0000	0.0000;
	1195	1197	0.003141	0.009669	0.001125	140	140	140	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1909	1910	0	0.000826	1e-05	140	140	140	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0012	0.0000	0.0000	0.0000	0.0000;
	1253	1115	0.001074	0.003388	0.000387	140	140	140	0	0	1	-360	360	1.6075	4.2384	-1.6073	-4.2844	0.0000	0.0000	0.0000	0.0000;
	1835	1253	0.004545	0.013884	0.001614	140	140	140	0	0	1	-360	360	2.3613	4.0997	-2.3605	-4.2916	0.0000	0.0000	0.0000	0.0000;
	1253	1251	0.001157	0.001488	0.000281	90	90	90	0	0	1	-360	360	0.7530	0.0532	-0.7530	-0.0870	0.0000	0.0000	0.0000	0.0000;
	925	1115	0.001074	0.003388	0.000387	140	140	140	0	0	1	-360	360	-4.1173	3.4797	4.1175	-3.5255	0.0000	0.0000	0.0000	0.0000;
	1884	925	0.003884	0.011901	0.001375	114	114	114	0	0	1	-360	360	-1.6888	3.3305	1.6892	-3.4947	0.0000	0.0000	0.0000	0.0000;
	923	925	0.000661	0.001901	0.000225	114	114	114	0	0	1	-360	360	-2.4280	-0.0420	2.4280	0.0150	0.0000	0.0000	0.0000	0.0000;
	1272	1115	0.009339	0.025289	0.002592	120	120	120	0	0	1	-360	360	10.6184	0.8728	-10.6096	-1.1614	0.0000	0.0000	0.0000	0.0000;
	1718	1272	0.005702	0.014545	0.001534	120	120	120	0	0	1	-360	360	14.5624	2.1150	-14.5522	-2.2741	0.0000	0.0000	0.0000	0.0000;
	1272	1269	0.005537	0.009339	0.00097	90	90	90	0	0	1	-360	360	3.9338	1.4013	-3.9330	-1.5170	0.0000	0.0000	0.0000	0.0000;
	1319	1115	0.015041	0.039669	0.004104	120	120	120	0	0	1	-360	360	16.6321	0.2049	-16.5977	-0.6094	0.0000	0.0000	0.0000	0.0000;
	1719	1319	8.3e-05	0.000248	1.9e-05	140	140	140	0	0	1	-360	360	21.4024	1.2372	-21.4021	-1.2386	0.0000	0.0000	0.0000	0.0000;
	1318	1319	0.000165	0.000413	5.3e-05	140	140	140	0	0	1	-360	360	-4.7700	-1.0400	4.7700	1.0336	0.0000	0.0000	0.0000	0.0000;
	1363	1289	0.000496	0.001488	0.000177	140	140	140	0	0	1	-360	360	-9.2317	-3.1192	9.2321	3.0987	0.0000	0.0000	0.0000	0.0000;
	1363	1289	0.000496	0.001488	0.000177	140	140	140	0	0	1	-360	360	-9.2317	-3.1192	9.2321	3.0987	0.0000	0.0000	0.0000	0.0000;
	1141	1114	0.012479	0.038265	0.004414	114	114	114	0	0	1	-360	360	-23.4895	-2.2979	23.5460	1.9286	0.0000	0.0000	0.0000	0.0000;
	1363	1141	0.000909	0.003388	0.00039	114	114	114	0	0	1	-360	360	-23.4853	-2.3460	23.4895	2.3136	0.0000	0.0000	0.0000	0.0000;
	1139	1141	0.000413	0.001322	0.000128	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0157	0.0000	0.0000	0.0000	0.0000;
	1653	1116	0.00876	0.026942	0.003112	114	114	114	0	0	1	-360	360	-31.6656	-4.5412	31.7391	4.3875	0.0000	0.0000	0.0000	0.0000;
	1142	1653	0.003802	0.012066	0.001396	140	140	140	0	0	1	-360	360	-31.2164	-4.7033	31.2476	4.6327	0.0000	0.0000	0.0000	0.0000;
	1364	1142	0.000826	0.002562	0.000293	114	114	114	0	0	1	-360	360	28.2137	10.7732	-28.2075	-10.7894	0.0000	0.0000	0.0000	0.0000;
	1652	1653	0.002066	0.006364	0.000753	140	140	140	0	0	1	-360	360	-0.4180	-0.0000	0.4180	-0.0916	0.0000	0.0000	0.0000	0.0000;
	1138	1142	0.000413	0.001322	0.00016	114	114	114	0	0	1	-360	360	-59.4110	-15.4710	59.4238	15.4927	0.0000	0.0000	0.0000	0.0000;
	1034	1874	0.001488	0.004876	0.000511	84	84	84	0	0	1	-360	360	6.4055	2.6741	-6.4049	-2.7333	0.0000	0.0000	0.0000	0.0000;
	1420	1034	0.004959	0.013223	0.0015	120	120	120	0	0	1	-360	360	6.4074	2.4690	-6.4055	-2.6439	0.0000	0.0000	0.0000	0.0000;
	1033	1034	0.000661	0.002149	0.000252	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0302	0.0000	0.0000	0.0000	0.0000;
	1152	1526	0.011983	0.037107	0.004211	140	140	140	0	0	1	-360	360	-17.8165	-0.2431	17.8473	-0.1819	0.0000	0.0000	0.0000	0.0000;
	1382	976	0.004545	0.013967	0.001619	140	140	140	0	0	1	-360	360	-2.0526	-0.1505	2.0527	-0.0480	0.0000	0.0000	0.0000	0.0000;
	1810	1796	0.004215	0.009752	0.002043	140	140	140	0	0	1	-360	360	-34.2612	-2.9852	34.3020	2.8296	0.0000	0.0000	0.0000	0.0000;
	1612	929	0.005702	0.015041	0.001646	120	120	120	0	0	1	-360	360	24.4412	0.5971	-24.4134	-0.7249	0.0000	0.0000	0.0000	0.0000;
	1341	929	0.001322	0.002645	0.000237	57	57	57	0	0	1	-360	360	-1.5060	-0.2600	1.5060	0.2311	0.0000	0.0000	0.0000	0.0000;
	1342	930	0.001322	0.002645	0.000237	57	57	57	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0291	0.0000	0.0000	0.0000	0.0000;
	1840	1656	0.002893	0.007025	0.000779	120	120	120	0	0	1	-360	360	3.4323	1.0968	-3.4320	-1.1920	0.0000	0.0000	0.0000	0.0000;
	1841	1657	0.002893	0.007025	0.000779	120	120	120	0	0	1	-360	360	1.5061	0.4462	-1.5060	-0.5420	0.0000	0.0000	0.0000	0.0000;
	1623	1114	0.003719	0.009008	0.000999	120	120	120	0	0	1	-360	360	-3.1420	-2.3232	3.1424	2.2011	0.0000	0.0000	0.0000	0.0000;
	1841	1623	0.004628	0.01438	0.001626	140	140	140	0	0	1	-360	360	-3.1414	-2.6807	3.1420	2.4823	0.0000	0.0000	0.0000	0.0000;
	1622	1623	0.002645	0.006116	0.00129	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.1590	0.0000	0.0000	0.0000	0.0000;
	1840	1114	0.008347	0.023471	0.002628	120	120	120	0	0	1	-360	360	-3.1910	-2.6245	3.1921	2.3037	0.0000	0.0000	0.0000	0.0000;
	1254	1114	0.00157	0.004793	0.000566	140	140	140	0	0	1	-360	360	-10.5957	-2.5688	10.5972	2.5035	0.0000	0.0000	0.0000	0.0000;
	1471	1254	0.007438	0.022562	0.00266	140	140	140	0	0	1	-360	360	-8.3321	-2.6156	8.3366	2.3018	0.0000	0.0000	0.0000	0.0000;
	1849	1471	0.000992	0.003306	0.000351	140	140	140	0	0	1	-360	360	-7.4946	-2.5387	7.4951	2.4972	0.0000	0.0000	0.0000	0.0000;
	1254	1252	0.000744	0.001405	0.000293	120	120	120	0	0	1	-360	360	2.2590	0.2670	-2.2590	-0.3030	0.0000	0.0000	0.0000	0.0000;
	1469	1471	0.000248	0.000496	4.6e-05	90	90	90	0	0	1	-360	360	-0.8370	-0.1240	0.8370	0.1183	0.0000	0.0000	0.0000	0.0000;
	1297	1114	0.00876	0.026529	0.003124	140	140	140	0	0	1	-360	360	-3.3791	-1.3241	3.3800	0.9416	0.0000	0.0000	0.0000	0.0000;
	1785	1413	0.010083	0.024546	0.002715	120	120	120	0	0	1	-360	360	-5.8482	-2.7108	5.8516	2.3928	0.0000	0.0000	0.0000	0.0000;
	1823	1785	0.011901	0.029669	0.003277	120	120	120	0	0	1	-360	360	-3.7528	-3.0505	3.7550	2.6629	0.0000	0.0000	0.0000	0.0000;
	1783	1785	0.00438	0.006116	0.000777	75	75	75	0	0	1	-360	360	-2.0930	-0.1410	2.0932	0.0479	0.0000	0.0000	0.0000	0.0000;
	1786	1414	0.010083	0.024546	0.002715	120	120	120	0	0	1	-360	360	-4.9405	-1.5970	4.9427	1.2762	0.0000	0.0000	0.0000	0.0000;
	1599	1786	0.008099	0.021074	0.002386	120	120	120	0	0	1	-360	360	-2.8467	-1.5524	2.8473	1.2678	0.0000	0.0000	0.0000	0.0000;
	1784	1786	0.004132	0.005372	0.000692	75	75	75	0	0	1	-360	360	-2.0930	-0.4120	2.0932	0.3291	0.0000	0.0000	0.0000	0.0000;
	1840	1704	0.002397	0.007355	0.000857	140	140	140	0	0	1	-360	360	1.5060	0.2846	-1.5060	-0.3900	0.0000	0.0000	0.0000	0.0000;
	1233	1008	0.003141	0.013306	0.001379	162	162	162	0	0	1	-360	360	-8.5715	-3.0312	8.5736	2.8699	0.0000	0.0000	0.0000	0.0000;
	1413	1147	0.003058	0.003802	0.000721	90	90	90	0	0	1	-360	360	0.4180	0.0432	-0.4180	-0.1300	0.0000	0.0000	0.0000	0.0000;
	1414	1148	0.003141	0.003884	0.00074	90	90	90	0	0	1	-360	360	0.8370	-0.0020	-0.8370	-0.0870	0.0000	0.0000	0.0000	0.0000;
	1030	1629	0.001074	0.003223	0.000378	140	140	140	0	0	1	-360	360	20.8496	0.4047	-20.8458	-0.4387	0.0000	0.0000	0.0000	0.0000;
	1718	1030	0.001818	0.00562	0.000665	140	140	140	0	0	1	-360	360	20.8562	0.3211	-20.8496	-0.3813	0.0000	0.0000	0.0000	0.0000;
	1030	1029	0.000579	0.001653	0.000194	140	140	140	0	0	1	-360	360	0.0000	-0.0234	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1380	1626	0.003141	0.021405	0.002413	114	114	114	0	0	1	-360	360	-2.7464	-1.4341	2.7466	1.1408	0.0000	0.0000	0.0000	0.0000;
	977	1278	0.004736	0.015008	0.001718	114	114	114	0	0	1	-360	360	55.9024	4.6352	-55.7823	-4.4672	0.0000	0.0000	0.0000	0.0000;
	1840	1370	0.00405	0.012397	0.00143	114	114	114	0	0	1	-360	360	-7.1234	1.7718	7.1251	-1.9426	0.0000	0.0000	0.0000	0.0000;
	889	1415	0.001983	0.006033	0.000697	140	140	140	0	0	1	-360	360	-0.9822	-0.4984	0.9822	0.4149	0.0000	0.0000	0.0000	0.0000;
	1874	889	0.004959	0.015207	0.001752	140	140	140	0	0	1	-360	360	0.3588	-0.2597	-0.3588	0.0496	0.0000	0.0000	0.0000	0.0000;
	889	887	0.001074	0.001818	0.000194	90	90	90	0	0	1	-360	360	1.3410	0.4488	-1.3410	-0.4720	0.0000	0.0000	0.0000	0.0000;
	1240	1416	0.002314	0.007438	0.000811	140	140	140	0	0	1	-360	360	-4.8589	-6.8481	4.8603	6.7553	0.0000	0.0000	0.0000	0.0000;
	1619	1240	0.005702	0.018017	0.001994	140	140	140	0	0	1	-360	360	-4.8555	-7.0779	4.8589	6.8504	0.0000	0.0000	0.0000	0.0000;
	1239	1240	8.3e-05	0.000248	1.9e-05	120	120	120	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0023	0.0000	0.0000	0.0000	0.0000;
	1234	1800	0.001901	0.004628	0.000895	140	140	140	0	0	1	-360	360	1.0890	0.2788	-1.0890	-0.3880	0.0000	0.0000	0.0000	0.0000;
	1801	1233	0.001405	0.004628	0.000489	140	140	140	0	0	1	-360	360	-16.7577	-1.7837	16.7609	1.7341	0.0000	0.0000	0.0000	0.0000;
	930	1801	0.008099	0.022645	0.002439	120	120	120	0	0	1	-360	360	-15.6524	-1.6738	15.6687	1.4192	0.0000	0.0000	0.0000	0.0000;
	1799	1801	0.000496	0.00124	0.000191	140	140	140	0	0	1	-360	360	-1.0890	-0.3880	1.0890	0.3645	0.0000	0.0000	0.0000	0.0000;
	1106	1116	0.007521	0.023058	0.002413	120	120	120	0	0	1	-360	360	-1.5060	0.0309	1.5061	-0.3259	0.0000	0.0000	0.0000	0.0000;
	1270	1106	0.000331	0.001157	0.000116	114	114	114	0	0	1	-360	360	-1.5060	-0.0870	1.5060	0.0728	0.0000	0.0000	0.0000	0.0000;
	1104	1106	0.002397	0.007521	0.000847	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.1037	0.0000	0.0000	0.0000	0.0000;
	1811	1901	0.008099	0.026116	0.002725	140	140	140	0	0	1	-360	360	18.3585	2.1301	-18.3358	-2.3893	0.0000	0.0000	0.0000	0.0000;
	1552	850	0.003636	0.011405	0.001242	140	140	140	0	0	1	-360	360	0.7623	6.3988	-0.7610	-6.5424	0.0000	0.0000	0.0000	0.0000;
	895	1552	0.00157	0.004876	0.000542	140	140	140	0	0	1	-360	360	1.0979	6.4154	-1.0973	-6.4782	0.0000	0.0000	0.0000	0.0000;
	1552	1550	0.002314	0.006942	0.000728	120	120	120	0	0	1	-360	360	0.3350	0.0793	-0.3350	-0.1660	0.0000	0.0000	0.0000	0.0000;
	1777	1020	0.001983	0.005702	0.000617	120	120	120	0	0	1	-360	360	11.9026	8.4524	-11.8990	-8.5159	0.0000	0.0000	0.0000	0.0000;
	890	1778	0.00562	0.017107	0.001919	120	120	120	0	0	1	-360	360	5.4581	3.0103	-5.4563	-3.2343	0.0000	0.0000	0.0000	0.0000;
	1874	890	0.004959	0.015207	0.001752	140	140	140	0	0	1	-360	360	6.0460	2.9930	-6.0441	-3.1971	0.0000	0.0000	0.0000	0.0000;
	890	888	0.001074	0.001818	0.000194	90	90	90	0	0	1	-360	360	0.5860	0.1868	-0.5860	-0.2100	0.0000	0.0000	0.0000	0.0000;
	1234	1771	0.005207	0.016281	0.001805	140	140	140	0	0	1	-360	360	-0.3794	3.4587	0.3800	-3.6771	0.0000	0.0000	0.0000	0.0000;
	1447	1288	0.013388	0.041488	0.004726	140	140	140	0	0	1	-360	360	-19.2309	-1.9863	19.2715	1.5302	0.0000	0.0000	0.0000	0.0000;
	1797	1447	0.007603	0.02405	0.002618	140	140	140	0	0	1	-360	360	-13.3464	-1.2914	13.3576	1.0053	0.0000	0.0000	0.0000	0.0000;
	1447	1445	0.001074	0.010992	0.001752	75	75	75	0	0	1	-360	360	5.8733	0.9810	-5.8730	-1.1930	0.0000	0.0000	0.0000	0.0000;
	1446	1051	0.00876	0.027851	0.00303	140	140	140	0	0	1	-360	360	22.3405	1.1468	-22.3047	-1.4034	0.0000	0.0000	0.0000	0.0000;
	1359	1446	0.011157	0.034463	0.003913	140	140	140	0	0	1	-360	360	27.0224	2.3856	-26.9557	-2.6605	0.0000	0.0000	0.0000	0.0000;
	1288	1359	0.002314	0.007025	0.000816	140	140	140	0	0	1	-360	360	32.0686	3.3702	-32.0491	-3.4116	0.0000	0.0000	0.0000	0.0000;
	1446	1444	0.001058	0.010826	0.001726	75	75	75	0	0	1	-360	360	4.6152	1.5138	-4.6150	-1.7230	0.0000	0.0000	0.0000	0.0000;
	1359	1357	0.003223	0.006033	0.000578	90	90	90	0	0	1	-360	360	5.0267	1.0260	-5.0260	-1.0960	0.0000	0.0000	0.0000	0.0000;
	1777	1415	0.005455	0.016777	0.001914	114	114	114	0	0	1	-360	360	-11.8629	-6.5681	11.8712	6.3644	0.0000	0.0000	0.0000	0.0000;
	1900	1841	0.004215	0.009835	0.001217	120	120	120	0	0	1	-360	360	15.7198	0.0253	-15.7114	-0.1556	0.0000	0.0000	0.0000	0.0000;
	1151	1900	0.002066	0.00562	0.000593	120	120	120	0	0	1	-360	360	16.3103	0.1541	-16.3058	-0.2151	0.0000	0.0000	0.0000	0.0000;
	1899	1900	0.000661	0.002314	0.00022	120	120	120	0	0	1	-360	360	-0.5860	-0.2170	0.5860	0.1899	0.0000	0.0000	0.0000	0.0000;
	1374	1584	0.002893	0.008926	0.001004	140	140	140	0	0	1	-360	360	17.5757	0.5792	-17.5684	-0.6790	0.0000	0.0000	0.0000	0.0000;
	1811	1374	0.00595	0.019174	0.00203	140	140	140	0	0	1	-360	360	20.9456	0.7433	-20.9242	-0.9221	0.0000	0.0000	0.0000	0.0000;
	1374	1372	0.005289	0.008926	0.000927	90	90	90	0	0	1	-360	360	3.3485	0.3429	-3.3480	-0.4550	0.0000	0.0000	0.0000	0.0000;
	1041	1234	0.001405	0.004463	0.000467	120	120	120	0	0	1	-360	360	-7.1982	-0.5355	7.1988	0.4805	0.0000	0.0000	0.0000	0.0000;
	1062	1041	0.005124	0.016033	0.001805	140	140	140	0	0	1	-360	360	-7.1960	-0.7617	7.1982	0.5485	0.0000	0.0000	0.0000	0.0000;
	1040	1041	0.000331	0.001074	0.000107	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0130	0.0000	0.0000	0.0000	0.0000;
	1733	1650	0.006529	0.023884	0.002338	105	105	105	0	0	1	-360	360	-4.1860	-0.7150	4.1870	0.4345	0.0000	0.0000	0.0000	0.0000;
	1902	1651	0.008017	0.026446	0.002645	140	140	140	0	0	1	-360	360	10.0517	1.0012	-10.0450	-1.3007	0.0000	0.0000	0.0000	0.0000;
	1752	1594	0.007273	0.012314	0.001788	90	90	90	0	0	1	-360	360	-20.6329	3.2487	20.6593	-3.4197	0.0000	0.0000	0.0000	0.0000;
	1839	921	0.02405	0.076281	0.008259	140	140	140	0	0	1	-360	360	48.1689	7.7435	-47.7097	-7.3058	0.0000	0.0000	0.0000	0.0000;
	1840	1042	0.003141	0.007769	0.000879	120	120	120	0	0	1	-360	360	2.2281	-0.9395	-2.2280	0.8316	0.0000	0.0000	0.0000	0.0000;
	1470	1043	0.005785	0.016116	0.001876	120	120	120	0	0	1	-360	360	-0.3029	0.9037	0.3030	-1.1346	0.0000	0.0000	0.0000	0.0000;
	1296	1470	0.002066	0.006446	0.000748	140	140	140	0	0	1	-360	360	0.9531	0.9340	-0.9531	-1.0261	0.0000	0.0000	0.0000	0.0000;
	1468	1470	0.000248	0.000496	4.6e-05	90	90	90	0	0	1	-360	360	-1.2560	-0.1280	1.2560	0.1223	0.0000	0.0000	0.0000	0.0000;
	1795	1513	0.007438	0.023967	0.002517	140	140	140	0	0	1	-360	360	-13.5314	-1.1427	13.5426	0.8699	0.0000	0.0000	0.0000	0.0000;
	1512	1289	0.012066	0.038678	0.004075	140	140	140	0	0	1	-360	360	-2.2630	-0.8020	2.2635	0.3045	0.0000	0.0000	0.0000	0.0000;
	1649	1289	0.000496	0.003719	0.000387	152	152	152	0	0	1	-360	360	9.9220	1.6633	-9.9216	-1.7077	0.0000	0.0000	0.0000	0.0000;
	1705	1649	0.008099	0.051653	0.005365	140	140	140	0	0	1	-360	360	9.9286	1.0204	-9.9220	-1.6366	0.0000	0.0000	0.0000	0.0000;
	1841	1705	0.007686	0.023967	0.002698	114	114	114	0	0	1	-360	360	14.9642	1.3378	-14.9501	-1.6257	0.0000	0.0000	0.0000	0.0000;
	1647	1649	0.000579	0.001818	0.000218	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0267	0.0000	0.0000	0.0000	0.0000;
	1703	1705	0.002231	0.007438	0.000726	140	140	140	0	0	1	-360	360	-5.0210	-0.6930	5.0215	0.6054	0.0000	0.0000	0.0000	0.0000;
	1585	886	0.002727	0.008512	0.000956	140	140	140	0	0	1	-360	360	13.5512	0.1999	-13.5471	-0.3034	0.0000	0.0000	0.0000	0.0000;
	1373	885	0.003223	0.010496	0.001104	140	140	140	0	0	1	-360	360	17.8535	0.7541	-17.8451	-0.8609	0.0000	0.0000	0.0000	0.0000;
	1050	1373	0.005289	0.016942	0.001796	140	140	140	0	0	1	-360	360	17.8674	0.4665	-17.8535	-0.6411	0.0000	0.0000	0.0000	0.0000;
	1373	1371	0.005289	0.008926	0.000927	90	90	90	0	0	1	-360	360	0.0000	-0.1129	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1780	1580	0.019256	0.061488	0.006558	140	140	140	0	0	1	-360	360	40.6148	2.3057	-40.3552	-2.2771	0.0000	0.0000	0.0000	0.0000;
	1837	1780	0.010413	0.033471	0.003533	140	140	140	0	0	1	-360	360	40.7549	2.2553	-40.6148	-2.2411	0.0000	0.0000	0.0000	0.0000;
	1779	1780	0.001653	0.005537	0.000525	140	140	140	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0645	0.0000	0.0000	0.0000	0.0000;
	1708	1620	0.004711	0.014628	0.001667	114	114	114	0	0	1	-360	360	14.8394	0.0216	-14.8310	-0.2025	0.0000	0.0000	0.0000	0.0000;
	1492	944	0.004793	0.015785	0.001561	140	140	140	0	0	1	-360	360	2.5102	-0.0155	-2.5100	-0.1730	0.0000	0.0000	0.0000	0.0000;
	1364	1492	0.007438	0.02405	0.002522	114	114	114	0	0	1	-360	360	5.4481	0.4231	-5.4463	-0.7232	0.0000	0.0000	0.0000	0.0000;
	1490	1492	8.3e-05	0.000826	1.9e-05	140	140	140	0	0	1	-360	360	-2.9360	-0.7410	2.9360	0.7387	0.0000	0.0000	0.0000	0.0000;
	1143	1363	0.000744	0.002314	0.00024	114	114	114	0	0	1	-360	360	-41.9376	-8.5791	41.9487	8.5843	0.0000	0.0000	0.0000	0.0000;
	1491	1143	0.006777	0.021736	0.002294	114	114	114	0	0	1	-360	360	-2.0940	-0.4020	2.0942	0.1219	0.0000	0.0000	0.0000	0.0000;
	1140	1143	0.000909	0.003141	0.000298	114	114	114	0	0	1	-360	360	-39.8310	-8.4510	39.8433	8.4571	0.0000	0.0000	0.0000	0.0000;
	1539	1752	0.012397	0.028265	0.002664	90	90	90	0	0	1	-360	360	-2.3430	-0.3470	2.3436	0.0274	0.0000	0.0000	0.0000	0.0000;
	1794	1865	0.009421	0.031157	0.002778	120	120	120	0	0	1	-360	360	18.9252	3.7332	-18.8960	-3.9705	0.0000	0.0000	0.0000	0.0000;
	983	947	0.015124	0.04157	0.004136	120	120	120	0	0	1	-360	360	22.8319	-0.1183	-22.7669	-0.2034	0.0000	0.0000	0.0000	0.0000;
	1391	946	0.015289	0.036612	0.005537	120	120	120	0	0	1	-360	360	45.0179	9.4503	-44.7536	-9.4913	0.0000	0.0000	0.0000	0.0000;
	1432	1180	0.009339	0.031901	0.003243	140	140	140	0	0	1	-360	360	-8.3662	-0.9736	8.3716	0.5964	0.0000	0.0000	0.0000	0.0000;
	1441	1432	0.002149	0.006777	0.000772	140	140	140	0	0	1	-360	360	-6.7744	-0.8472	6.7752	0.7557	0.0000	0.0000	0.0000	0.0000;
	1432	1431	0	8.3e-05	1e-05	140	140	140	0	0	1	-360	360	1.5910	0.2178	-1.5910	-0.2190	0.0000	0.0000	0.0000	0.0000;
	1403	1180	0.005041	0.016364	0.001711	140	140	140	0	0	1	-360	360	-13.4042	-3.0644	13.4120	2.8810	0.0000	0.0000	0.0000	0.0000;
	1731	1352	0.005785	0.014463	0.001636	120	120	120	0	0	1	-360	360	-1.0592	3.1789	1.0598	-3.3713	0.0000	0.0000	0.0000	0.0000;
	1224	1352	0.034132	0.094876	0.009319	120	120	120	0	0	1	-360	360	1.6957	2.6516	-1.6919	-3.7481	0.0000	0.0000	0.0000	0.0000;
	1223	1866	0.011074	0.03281	0.002829	120	120	120	0	0	1	-360	360	-18.7775	-4.1735	18.8118	3.9369	0.0000	0.0000	0.0000	0.0000;
	1224	1915	0.006198	0.016694	0.002616	140	140	140	0	0	1	-360	360	13.5493	-1.1790	-13.5397	0.8934	0.0000	0.0000	0.0000	0.0000;
	1389	1914	0.00124	0.003802	0.000423	140	140	140	0	0	1	-360	360	0.6465	4.1458	-0.6464	-4.1956	0.0000	0.0000	0.0000	0.0000;
	1682	1730	0.007686	0.020909	0.002139	120	120	120	0	0	1	-360	360	-1.2405	2.7922	1.2412	-3.0440	0.0000	0.0000	0.0000	0.0000;
	1680	1682	0.012479	0.037851	0.004477	140	140	140	0	0	1	-360	360	-1.2397	2.2633	1.2405	-2.7922	0.0000	0.0000	0.0000	0.0000;
	1223	1682	0.021901	0.060992	0.005953	120	120	120	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1223	861	0.004876	0.01314	0.001779	120	120	120	0	0	1	-360	360	9.1899	0.5782	-9.1864	-0.7807	0.0000	0.0000	0.0000	0.0000;
	1000	1317	0.006198	0.019504	0.00213	140	140	140	0	0	1	-360	360	-4.4112	-0.9441	4.4122	0.6879	0.0000	0.0000	0.0000	0.0000;
	1223	1052	0.00405	0.013802	0.001314	140	140	140	0	0	1	-360	360	3.6230	2.9204	-3.6222	-3.0743	0.0000	0.0000	0.0000	0.0000;
	1053	1681	0.010248	0.031157	0.003683	140	140	140	0	0	1	-360	360	3.4552	2.9612	-3.4533	-3.3934	0.0000	0.0000	0.0000	0.0000;
	1220	1180	0.009587	0.030826	0.003265	140	140	140	0	0	1	-360	360	-16.0842	-1.0310	16.1046	0.6986	0.0000	0.0000	0.0000	0.0000;
	1458	1180	0.001405	0.004298	0.000472	140	140	140	0	0	1	-360	360	-14.7541	-2.9028	14.7567	2.8532	0.0000	0.0000	0.0000	0.0000;
	979	1211	0.007769	0.023554	0.002773	140	140	140	0	0	1	-360	360	-6.0857	-0.2470	6.0880	-0.0820	0.0000	0.0000	0.0000	0.0000;
	1768	1300	0.008182	0.025537	0.002863	140	140	140	0	0	1	-360	360	10.2269	1.1974	-10.2198	-1.5234	0.0000	0.0000	0.0000	0.0000;
	1905	1897	0.001488	0.004628	0.000542	140	140	140	0	0	1	-360	360	4.6620	-0.1358	-4.6617	0.0721	0.0000	0.0000	0.0000	0.0000;
	1480	1388	0.006281	0.019752	0.002161	140	140	140	0	0	1	-360	360	-0.3350	-0.0850	0.3350	-0.1723	0.0000	0.0000	0.0000	0.0000;
	1481	1389	0.006198	0.019587	0.002139	140	140	140	0	0	1	-360	360	-0.5860	-0.1950	0.5860	-0.0596	0.0000	0.0000	0.0000	0.0000;
	1388	1898	0.000826	0.002479	0.000271	140	140	140	0	0	1	-360	360	6.1506	1.7007	-6.1503	-1.7321	0.0000	0.0000	0.0000	0.0000;
	862	1906	0.000744	0.002397	0.000281	140	140	140	0	0	1	-360	360	7.9304	0.4782	-7.9300	-0.5104	0.0000	0.0000	0.0000	0.0000;
	1916	1389	0.001983	0.005289	0.000702	120	120	120	0	0	1	-360	360	-1.9144	-0.8352	1.9144	0.7518	0.0000	0.0000	0.0000	0.0000;
	1665	1660	0.003471	0.010413	0.001239	140	140	140	0	0	1	-360	360	6.5540	3.2805	-6.5525	-3.4249	0.0000	0.0000	0.0000	0.0000;
	1666	946	0.006446	0.019669	0.002335	140	140	140	0	0	1	-360	360	-12.5791	-4.4944	12.5886	4.2418	0.0000	0.0000	0.0000	0.0000;
	1698	1181	0.004793	0.014711	0.001706	140	140	140	0	0	1	-360	360	-10.3026	0.1545	10.3068	-0.3488	0.0000	0.0000	0.0000	0.0000;
	1203	1178	0.008843	0.027603	0.003083	140	140	140	0	0	1	-360	360	3.9092	1.0014	-3.9080	-1.3718	0.0000	0.0000	0.0000	0.0000;
	1714	1181	0.005041	0.015537	0.001801	140	140	140	0	0	1	-360	360	-6.7284	-1.1786	6.7303	0.9659	0.0000	0.0000	0.0000	0.0000;
	1701	1179	0.003554	0.00876	0.000963	120	120	120	0	0	1	-360	360	-5.3629	1.0426	5.3638	-1.1573	0.0000	0.0000	0.0000	0.0000;
	1804	1701	0.016033	0.046364	0.004455	120	120	120	0	0	1	-360	360	-3.9375	0.5110	3.9397	-1.0453	0.0000	0.0000	0.0000	0.0000;
	1701	1699	0.012645	0.015868	0.003013	90	90	90	0	0	1	-360	360	1.4232	0.0027	-1.4230	-0.3680	0.0000	0.0000	0.0000	0.0000;
	1702	1178	0.004298	0.010496	0.001159	120	120	120	0	0	1	-360	360	2.8753	-0.0597	-2.8750	-0.0802	0.0000	0.0000	0.0000	0.0000;
	1673	1702	0.017273	0.055289	0.005189	120	120	120	0	0	1	-360	360	4.5526	-0.6194	-4.5496	-0.0010	0.0000	0.0000	0.0000	0.0000;
	1702	1700	0.01281	0.016033	0.00304	90	90	90	0	0	1	-360	360	1.6743	0.0607	-1.6740	-0.4290	0.0000	0.0000	0.0000	0.0000;
	1805	1673	0.008926	0.027355	0.003165	140	140	140	0	0	1	-360	360	-8.6487	-1.5161	8.6543	1.1493	0.0000	0.0000	0.0000	0.0000;
	1036	1673	0.009008	0.027603	0.003202	140	140	140	0	0	1	-360	360	-8.2666	0.4471	8.2717	-0.8201	0.0000	0.0000	0.0000	0.0000;
	1674	946	0.008512	0.026198	0.003006	120	120	120	0	0	1	-360	360	-20.8162	-3.1232	20.8475	2.8575	0.0000	0.0000	0.0000	0.0000;
	1675	947	0.008512	0.026198	0.003006	120	120	120	0	0	1	-360	360	-3.9351	2.7848	3.9368	-3.1422	0.0000	0.0000	0.0000	0.0000;
	1856	1675	0.004298	0.01314	0.001559	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.1881	0.0000	0.0000	0.0000	0.0000;
	1857	1673	0.004298	0.01314	0.001556	140	140	140	0	0	1	-360	360	-4.1900	-1.5710	4.1907	1.3842	0.0000	0.0000	0.0000	0.0000;
	1507	1487	0.004959	0.012397	0.001375	120	120	120	0	0	1	-360	360	12.3695	-0.3904	-12.3632	0.2408	0.0000	0.0000	0.0000	0.0000;
	1675	1507	0.010992	0.032231	0.003112	120	120	120	0	0	1	-360	360	15.0695	0.2062	-15.0488	-0.5207	0.0000	0.0000	0.0000	0.0000;
	1506	1507	0.004298	0.013058	0.001544	140	140	140	0	0	1	-360	360	-2.6790	-1.0960	2.6793	0.9111	0.0000	0.0000	0.0000	0.0000;
	1674	1486	0.016033	0.044711	0.004499	120	120	120	0	0	1	-360	360	14.6843	2.0096	-14.6548	-2.4666	0.0000	0.0000	0.0000	0.0000;
	1673	1846	0.006198	0.02	0.00212	140	140	140	0	0	1	-360	360	13.0757	2.0915	-13.0667	-2.3197	0.0000	0.0000	0.0000	0.0000;
	1223	919	0.004545	0.013802	0.001638	140	140	140	0	0	1	-360	360	5.6297	0.5059	-5.6284	-0.6974	0.0000	0.0000	0.0000	0.0000;
	1774	878	0.004132	0.01281	0.00144	140	140	140	0	0	1	-360	360	-7.0313	-0.6536	7.0330	0.4826	0.0000	0.0000	0.0000	0.0000;
	1728	878	0.003471	0.011157	0.001198	140	140	140	0	0	1	-360	360	-25.7620	-2.4209	25.7810	2.3356	0.0000	0.0000	0.0000	0.0000;
	1353	1110	0.004628	0.014297	0.001619	140	140	140	0	0	1	-360	360	18.9606	1.0950	-18.9470	-1.2507	0.0000	0.0000	0.0000	0.0000;
	1725	1073	0.004711	0.014297	0.001699	140	140	140	0	0	1	-360	360	12.0102	1.3072	-12.0045	-1.4975	0.0000	0.0000	0.0000	0.0000;
	1353	1725	0.003554	0.010992	0.001261	140	140	140	0	0	1	-360	360	12.6009	1.2699	-12.5962	-1.4096	0.0000	0.0000	0.0000	0.0000;
	1725	1723	0.00157	0.005372	0.00052	140	140	140	0	0	1	-360	360	0.5860	0.1024	-0.5860	-0.1660	0.0000	0.0000	0.0000	0.0000;
	1531	879	0.002479	0.007686	0.000883	140	140	140	0	0	1	-360	360	18.7885	0.5241	-18.7813	-0.6096	0.0000	0.0000	0.0000	0.0000;
	1353	1531	0.006116	0.018926	0.002142	140	140	140	0	0	1	-360	360	21.5789	0.6182	-21.5556	-0.8077	0.0000	0.0000	0.0000	0.0000;
	1531	1530	0.002066	0.003802	0.000784	120	120	120	0	0	1	-360	360	2.7671	0.2836	-2.7670	-0.3790	0.0000	0.0000	0.0000	0.0000;
	1367	1353	0.002397	0.007355	0.000828	140	140	140	0	0	1	-360	360	-1.8477	10.5284	1.8500	-10.6228	0.0000	0.0000	0.0000	0.0000;
	1001	1441	0.002397	0.007769	0.000823	140	140	140	0	0	1	-360	360	-9.4789	-2.4366	9.4807	2.3424	0.0000	0.0000	0.0000	0.0000;
	1072	1549	0.003719	0.009008	0.001363	120	120	120	0	0	1	-360	360	7.0655	0.1098	-7.0640	-0.2724	0.0000	0.0000	0.0000	0.0000;
	1522	1440	0.006281	0.020083	0.002139	140	140	140	0	0	1	-360	360	15.8732	0.1706	-15.8602	-0.3901	0.0000	0.0000	0.0000	0.0000;
	1262	1219	8.3e-05	0.000248	2.2e-05	140	140	140	0	0	1	-360	360	-4.7175	0.4744	4.7175	-0.4770	0.0000	0.0000	0.0000	0.0000;
	1467	1262	0.007603	0.019587	0.002091	120	120	120	0	0	1	-360	360	-3.7116	0.3559	3.7124	-0.6085	0.0000	0.0000	0.0000	0.0000;
	1440	1467	0.003141	0.00843	0.000857	120	120	120	0	0	1	-360	360	-3.7112	0.2712	3.7116	-0.3746	0.0000	0.0000	0.0000	0.0000;
	1261	1262	0.004545	0.008512	0.000927	90	90	90	0	0	1	-360	360	-1.0050	-0.2470	1.0050	0.1341	0.0000	0.0000	0.0000	0.0000;
	1466	1467	0.000496	0.001322	0.000133	120	120	120	0	0	1	-360	360	-0.0000	-0.0350	0.0000	0.0188	0.0000	0.0000	0.0000	0.0000;
	1238	1219	0.002562	0.006777	0.000944	120	120	120	0	0	1	-360	360	2.5212	-0.9583	-2.5210	0.8437	0.0000	0.0000	0.0000	0.0000;
	1423	1189	0.001653	0.004959	0.00059	140	140	140	0	0	1	-360	360	-5.0820	0.5970	5.0824	-0.6679	0.0000	0.0000	0.0000	0.0000;
	1185	1220	0.003223	0.009752	0.001159	140	140	140	0	0	1	-360	360	12.1509	-0.0652	-12.1470	-0.0641	0.0000	0.0000	0.0000	0.0000;
	974	1185	0.003058	0.009421	0.001058	140	140	140	0	0	1	-360	360	12.1546	-0.1841	-12.1509	0.0667	0.0000	0.0000	0.0000	0.0000;
	1184	1185	0	8.3e-05	1.2e-05	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0015	0.0000	0.0000	0.0000	0.0000;
	1189	1548	0.001405	0.004298	0.000503	140	140	140	0	0	1	-360	360	-6.2255	-0.1091	6.2259	0.0490	0.0000	0.0000	0.0000	0.0000;
	1833	1368	0.010744	0.032727	0.003836	140	140	140	0	0	1	-360	360	-0.8327	10.4115	0.8426	-10.8522	0.0000	0.0000	0.0000	0.0000;
	1219	1459	0.008264	0.026612	0.002807	140	140	140	0	0	1	-360	360	-4.7075	-0.9517	4.7090	0.6143	0.0000	0.0000	0.0000	0.0000;
	1397	1794	0.014711	0.031488	0.005377	120	120	120	0	0	1	-360	360	-22.1483	-2.6429	22.2092	2.1278	0.0000	0.0000	0.0000	0.0000;
	1224	1397	0.009917	0.019669	0.003705	120	120	120	0	0	1	-360	360	-20.4369	-2.6926	20.4722	2.3202	0.0000	0.0000	0.0000	0.0000;
	1397	1396	0.002231	0.006033	0.000564	120	120	120	0	0	1	-360	360	1.6761	0.3227	-1.6760	-0.3900	0.0000	0.0000	0.0000	0.0000;
	876	1181	0.006033	0.020496	0.002176	140	140	140	0	0	1	-360	360	-0.6704	-1.2820	0.6705	1.0181	0.0000	0.0000	0.0000	0.0000;
	877	955	0.003058	0.010661	0.001171	140	140	140	0	0	1	-360	360	-1.5056	0.4160	1.5056	-0.5580	0.0000	0.0000	0.0000	0.0000;
	1177	954	0.006529	0.020909	0.002243	140	140	140	0	0	1	-360	360	6.4459	0.3669	-6.4436	-0.6322	0.0000	0.0000	0.0000	0.0000;
	1301	1177	0.002397	0.007355	0.000876	140	140	140	0	0	1	-360	360	6.4467	-0.1053	-6.4459	0.0013	0.0000	0.0000	0.0000	0.0000;
	1173	1177	0.008678	0.02719	0.00303	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.3682	0.0000	0.0000	0.0000	0.0000;
	1174	1177	0.008347	0.026116	0.002904	140	140	140	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1194	1486	0.004711	0.012149	0.001696	120	120	120	0	0	1	-360	360	-8.7097	-0.7676	8.7127	0.5727	0.0000	0.0000	0.0000	0.0000;
	1855	1194	0.02405	0.043223	0.008981	120	120	120	0	0	1	-360	360	-8.1100	-1.8020	8.1237	0.7563	0.0000	0.0000	0.0000	0.0000;
	1193	1194	0.003471	0.010826	0.001195	140	140	140	0	0	1	-360	360	-0.5860	-0.1540	0.5860	0.0113	0.0000	0.0000	0.0000	0.0000;
	1487	1661	0.001488	0.004463	0.000513	140	140	140	0	0	1	-360	360	6.4181	-0.7980	-6.4175	0.7378	0.0000	0.0000	0.0000	0.0000;
	1486	1285	0.000909	0.002975	0.000329	140	140	140	0	0	1	-360	360	2.5101	1.1739	-2.5100	-1.2130	0.0000	0.0000	0.0000	0.0000;
	1505	1486	0.010331	0.013223	0.00241	90	90	90	0	0	1	-360	360	-1.0040	-0.2730	1.0041	-0.0149	0.0000	0.0000	0.0000	0.0000;
	1487	1258	0.00843	0.025785	0.00304	140	140	140	0	0	1	-360	360	4.0171	0.0721	-4.0160	-0.4340	0.0000	0.0000	0.0000	0.0000;
	1729	1523	0.001488	0.004628	0.00053	140	140	140	0	0	1	-360	360	20.7387	1.2047	-20.7334	-1.2530	0.0000	0.0000	0.0000	0.0000;
	1496	1440	0.001983	0.006116	0.000726	140	140	140	0	0	1	-360	360	-7.0353	1.3418	7.0362	-1.4277	0.0000	0.0000	0.0000	0.0000;
	1724	975	0.00438	0.014545	0.00144	140	140	140	0	0	1	-360	360	16.8519	0.8027	-16.8417	-0.9443	0.0000	0.0000	0.0000	0.0000;
	1111	1724	0.000661	0.001983	0.000232	140	140	140	0	0	1	-360	360	18.1097	1.0754	-18.1079	-1.0985	0.0000	0.0000	0.0000	0.0000;
	1722	1724	0.000165	0.000413	5.1e-05	140	140	140	0	0	1	-360	360	-1.2560	-0.3020	1.2560	0.2958	0.0000	0.0000	0.0000	0.0000;
	1316	879	0.004628	0.014545	0.001592	140	140	140	0	0	1	-360	360	-4.4963	-0.7231	4.4970	0.5314	0.0000	0.0000	0.0000	0.0000;
	1024	879	0.000826	0.002727	0.000257	140	140	140	0	0	1	-360	360	-9.0937	1.4695	9.0942	-1.4989	0.0000	0.0000	0.0000	0.0000;
	1399	1024	0.002562	0.008595	0.00082	140	140	140	0	0	1	-360	360	-9.0749	1.4058	9.0767	-1.4998	0.0000	0.0000	0.0000	0.0000;
	1023	1024	0.000992	0.003058	0.000358	140	140	140	0	0	1	-360	360	-0.0170	-0.0740	0.0170	0.0303	0.0000	0.0000	0.0000	0.0000;
	1805	978	0.005289	0.016198	0.001907	140	140	140	0	0	1	-360	360	0.4444	0.9951	-0.4443	-1.2260	0.0000	0.0000	0.0000	0.0000;
	913	946	0.000826	0.001405	0.000152	90	90	90	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0184	0.0000	0.0000	0.0000	0.0000;
	914	947	0.000826	0.001322	0.000145	90	90	90	0	0	1	-360	360	-7.1130	-0.8670	7.1134	0.8500	0.0000	0.0000	0.0000	0.0000;
	915	947	0.000826	0.001322	0.000145	90	90	90	0	0	1	-360	360	-9.6230	-2.1670	9.6237	2.1506	0.0000	0.0000	0.0000	0.0000;
	916	946	0.000744	0.001157	0.000128	90	90	90	0	0	1	-360	360	-8.8050	-1.8200	8.8055	1.8053	0.0000	0.0000	0.0000	0.0000;
	1353	1773	0.004959	0.015289	0.001769	140	140	140	0	0	1	-360	360	-1.3392	0.3045	1.3393	-0.5206	0.0000	0.0000	0.0000	0.0000;
	1220	982	0.00719	0.017851	0.002134	120	120	120	0	0	1	-360	360	26.6412	0.6831	-26.5992	-0.8383	0.0000	0.0000	0.0000	0.0000;
	1440	1404	0.008017	0.027769	0.002802	140	140	140	0	0	1	-360	360	-2.7766	0.4968	2.7772	-0.8364	0.0000	0.0000	0.0000	0.0000;
	1917	920	0.006033	0.018347	0.002176	140	140	140	0	0	1	-360	360	-3.9536	-0.4948	3.9544	0.2382	0.0000	0.0000	0.0000	0.0000;
	1421	1354	0.007686	0.027273	0.003178	140	140	140	0	0	1	-360	360	-9.5960	-2.9205	9.6022	2.5497	0.0000	0.0000	0.0000	0.0000;
	1697	1179	0.001405	0.00438	0.000506	140	140	140	0	0	1	-360	360	8.2946	-0.5882	-8.2938	0.5293	0.0000	0.0000	0.0000	0.0000;
	1424	1237	0.004876	0.009256	0.001801	120	120	120	0	0	1	-360	360	4.6140	-0.6561	-4.6132	0.4383	0.0000	0.0000	0.0000	0.0000;
	1843	1794	0.003719	0.012645	0.00121	140	140	140	0	0	1	-360	360	-5.1960	-1.1670	5.1969	1.0243	0.0000	0.0000	0.0000	0.0000;
	1804	1037	0.002727	0.008347	0.000956	140	140	140	0	0	1	-360	360	-8.2650	0.3363	8.2665	-0.4476	0.0000	0.0000	0.0000	0.0000;
	1854	1770	0.001157	0.002893	0.000436	120	120	120	0	0	1	-360	360	3.0030	0.6277	-3.0029	-0.6793	0.0000	0.0000	0.0000	0.0000;
	1390	1793	0.007686	0.02405	0.002703	140	140	140	0	0	1	-360	360	-47.9504	-10.1660	48.1006	10.3024	0.0000	0.0000	0.0000	0.0000;
	1834	1793	0.01124	0.032562	0.003272	120	120	120	0	0	1	-360	360	-4.6104	-11.6893	4.6244	11.3255	0.0000	0.0000	0.0000	0.0000;
	1443	1847	0.005868	0.01595	0.00174	120	120	120	0	0	1	-360	360	1.6694	0.0269	-1.6693	-0.2374	0.0000	0.0000	0.0000	0.0000;
	1805	1443	0.000165	0.000331	3.2e-05	120	120	120	0	0	1	-360	360	1.6694	-0.0676	-1.6694	0.0637	0.0000	0.0000	0.0000	0.0000;
	1443	1442	0.001983	0.005207	0.000748	120	120	120	0	0	1	-360	360	0.0000	-0.0906	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1093	1080	0.063554	0.129835	0.012678	90	90	90	0	0	1	-360	360	8.2898	-2.8133	-8.2519	1.3426	0.0000	0.0000	0.0000	0.0000;
	1659	1112	0.030413	0.056942	0.00521	57	57	57	0	0	1	-360	360	2.4296	-3.0541	-2.4263	2.4260	0.0000	0.0000	0.0000	0.0000;
	1896	1659	0.099008	0.200248	0.017475	90	90	90	0	0	1	-360	360	4.5474	-4.3525	-4.5217	2.2820	0.0000	0.0000	0.0000	0.0000;
	1658	1659	0.001983	0.003306	0.000353	19	19	19	0	0	1	-360	360	-2.0920	-0.8150	2.0921	0.7721	0.0000	0.0000	0.0000	0.0000;
	1346	1895	0.016116	0.028512	0.002735	90	90	90	0	0	1	-360	360	-1.7590	-0.3970	1.7594	0.0663	0.0000	0.0000	0.0000	0.0000;
	1746	900	0.022893	0.056694	0.006297	114	114	114	0	0	1	-360	360	-2.7388	0.6599	2.7404	-1.4210	0.0000	0.0000	0.0000	0.0000;
	1736	900	0.024793	0.061322	0.006817	114	114	114	0	0	1	-360	360	3.4376	0.6902	-3.4349	-1.5131	0.0000	0.0000	0.0000	0.0000;
	1896	1070	0.022727	0.072645	0.007749	57	57	57	0	0	1	-360	360	5.8729	0.7800	-5.8661	-1.6961	0.0000	0.0000	0.0000	0.0000;
	1344	900	0.014711	0.045207	0.005198	114	114	114	0	0	1	-360	360	0.1982	-3.8295	-0.1967	3.2033	0.0000	0.0000	0.0000	0.0000;
	1092	1149	0.096446	0.194711	0.017877	90	90	90	0	0	1	-360	360	0.1210	-1.6664	-0.1207	-0.5096	0.0000	0.0000	0.0000	0.0000;
	1347	901	0.015124	0.040496	0.004627	114	114	114	0	0	1	-360	360	-11.4616	1.8215	11.4786	-2.3352	0.0000	0.0000	0.0000	0.0000;
	967	1347	0.037273	0.075454	0.006638	90	90	90	0	0	1	-360	360	-9.3398	1.2068	9.3676	-1.9507	0.0000	0.0000	0.0000	0.0000;
	1345	1347	0.000579	0.000992	8.9e-05	29	29	29	0	0	1	-360	360	-2.0940	-0.1400	2.0940	0.1292	0.0000	0.0000	0.0000	0.0000;
	882	1059	0.018017	0.054711	0.006486	57	57	57	0	0	1	-360	360	-7.2985	2.2526	7.3074	-3.0156	0.0000	0.0000	0.0000	0.0000;
	1112	882	0.012397	0.037603	0.004441	57	57	57	0	0	1	-360	360	-5.6195	1.7482	5.6231	-2.2782	0.0000	0.0000	0.0000	0.0000;
	882	881	0.016529	0.027273	0.002948	19	19	19	0	0	1	-360	360	1.6754	0.0256	-1.6750	-0.3840	0.0000	0.0000	0.0000	0.0000;
	1112	1494	0.014545	0.025124	0.003572	57	57	57	0	0	1	-360	360	3.3497	-0.9259	-3.3483	0.4932	0.0000	0.0000	0.0000	0.0000;
	1248	901	0.00719	0.022149	0.002522	114	114	114	0	0	1	-360	360	-17.1358	7.3681	17.1566	-7.6091	0.0000	0.0000	0.0000	0.0000;
	1247	902	0.00719	0.022231	0.002534	114	114	114	0	0	1	-360	360	1.6768	-4.9243	-1.6752	4.6239	0.0000	0.0000	0.0000	0.0000;
	1093	1087	0.006612	0.021074	0.002248	114	114	114	0	0	1	-360	360	5.4890	1.2351	-5.4873	-1.5045	0.0000	0.0000	0.0000	0.0000;
	1118	1092	0.016364	0.052149	0.005588	140	140	140	0	0	1	-360	360	41.5873	-3.8270	-41.3549	3.8853	0.0000	0.0000	0.0000	0.0000;
	1501	1092	0.019504	0.035537	0.009019	114	114	114	0	0	1	-360	360	7.4043	0.1716	-7.3955	-1.2543	0.0000	0.0000	0.0000	0.0000;
	1054	1093	0.001322	0.002314	0.000242	57	57	57	0	0	1	-360	360	-0.0000	-0.0650	0.0000	0.0354	0.0000	0.0000	0.0000	0.0000;
	1055	1092	0.001322	0.002314	0.000242	57	57	57	0	0	1	-360	360	-1.1710	-0.0430	1.1710	0.0136	0.0000	0.0000	0.0000	0.0000;
	1535	1093	0.02843	0.074132	0.006752	90	90	90	0	0	1	-360	360	-6.6216	-0.7594	6.6319	-0.0385	0.0000	0.0000	0.0000	0.0000;
	1895	1535	0.037769	0.073802	0.00657	90	90	90	0	0	1	-360	360	-6.6076	-1.6016	6.6216	0.8302	0.0000	0.0000	0.0000	0.0000;
	1535	1533	0.003306	0.005455	0.000581	19	19	19	0	0	1	-360	360	0.0000	-0.0708	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1896	1298	0.038182	0.074876	0.00666	90	90	90	0	0	1	-360	360	1.1604	-0.8059	-1.1599	-0.0006	0.0000	0.0000	0.0000	0.0000;
	1534	1092	0.02843	0.074132	0.006752	90	90	90	0	0	1	-360	360	-7.3780	-0.2527	7.3908	-0.5340	0.0000	0.0000	0.0000	0.0000;
	1299	1534	0.005207	0.009835	0.000956	90	90	90	0	0	1	-360	360	-3.1931	-0.2204	3.1936	0.1054	0.0000	0.0000	0.0000	0.0000;
	1534	1532	0.003306	0.005455	0.000581	19	19	19	0	0	1	-360	360	4.1845	0.1474	-4.1840	-0.2170	0.0000	0.0000	0.0000	0.0000;
	1293	1268	0.040496	0.066694	0.007214	57	57	57	0	0	1	-360	360	-1.7132	1.2857	1.7152	-2.1593	0.0000	0.0000	0.0000	0.0000;
	1889	1303	0.025785	0.06843	0.007802	114	114	114	0	0	1	-360	360	0.0770	-0.4805	-0.0770	-0.4594	0.0000	0.0000	0.0000	0.0000;
	1890	1501	0.024463	0.061322	0.006793	114	114	114	0	0	1	-360	360	-8.4311	1.3105	8.4460	-2.1012	0.0000	0.0000	0.0000	0.0000;
	1890	1502	0.024463	0.061322	0.006793	114	114	114	0	0	1	-360	360	-0.3169	-0.4155	0.3169	-0.4118	0.0000	0.0000	0.0000	0.0000;
	928	1335	0.024793	0.065454	0.006614	114	114	114	0	0	1	-360	360	6.1860	-0.8242	-6.1781	0.0403	0.0000	0.0000	0.0000	0.0000;
	1889	1693	0.001653	0.003471	0.00038	90	90	90	0	0	1	-360	360	0.2510	-0.2458	-0.2510	0.2000	0.0000	0.0000	0.0000	0.0000;
	1890	1694	0.001074	0.003471	0.00037	114	114	114	0	0	1	-360	360	0.8370	0.0849	-0.8370	-0.1300	0.0000	0.0000	0.0000	0.0000;
	1826	1267	0.030744	0.050661	0.005474	57	57	57	0	0	1	-360	360	6.6774	-5.4910	-6.6594	4.8560	0.0000	0.0000	0.0000	0.0000;
	1343	1895	0.002314	0.007438	0.000799	114	114	114	0	0	1	-360	360	8.7447	-5.6848	-8.7427	5.5946	0.0000	0.0000	0.0000	0.0000;
	1092	1071	0.01124	0.036116	0.003816	114	114	114	0	0	1	-360	360	25.3226	3.7570	-25.2619	-4.0246	0.0000	0.0000	0.0000	0.0000;
	1334	1267	0.007769	0.021736	0.002362	114	114	114	0	0	1	-360	360	3.2441	-0.5115	-3.2434	0.2264	0.0000	0.0000	0.0000	0.0000;
	1827	1455	0.05	0.082397	0.008901	57	57	57	0	0	1	-360	360	-11.4535	4.3263	11.5173	-5.3030	0.0000	0.0000	0.0000	0.0000;
	1502	965	0.026033	0.065702	0.007335	114	114	114	0	0	1	-360	360	5.5509	-0.3616	-5.5443	-0.5141	0.0000	0.0000	0.0000	0.0000;
	1557	1454	0.042397	0.069917	0.00755	57	57	57	0	0	1	-360	360	17.5792	-5.2304	-17.4644	4.4977	0.0000	0.0000	0.0000	0.0000;
	892	1002	0.00438	0.014876	0.001423	114	114	114	0	0	1	-360	360	-19.8633	5.9024	19.8786	-6.0256	0.0000	0.0000	0.0000	0.0000;
	1109	900	0.032479	0.102314	0.011265	114	114	114	0	0	1	-360	360	4.1348	0.6462	-4.1298	-2.0023	0.0000	0.0000	0.0000	0.0000;
	1578	1065	0.050248	0.08281	0.008956	57	57	57	0	0	1	-360	360	-4.0180	0.8882	4.0257	-1.9430	0.0000	0.0000	0.0000	0.0000;
	1735	1501	0.025372	0.062562	0.006924	114	114	114	0	0	1	-360	360	-7.4536	1.1894	7.4657	-2.0035	0.0000	0.0000	0.0000	0.0000;
	1808	1081	0.013306	0.040413	0.004804	57	57	57	0	0	1	-360	360	-1.0050	0.7060	1.0052	-1.2908	0.0000	0.0000	0.0000	0.0000;
	1002	1093	0.01	0.068512	0.007647	232	232	232	0	0	1	-360	360	52.9472	-1.7998	-52.7194	2.4222	0.0000	0.0000	0.0000	0.0000;
	1003	1755	0.005868	0.040083	0.004518	232	232	232	0	0	1	-360	360	9.5828	0.9372	-9.5783	-1.4574	0.0000	0.0000	0.0000	0.0000;
	1076	1086	0.006281	0.019835	0.00218	114	114	114	0	0	1	-360	360	0.8752	-2.4519	-0.8749	2.1865	0.0000	0.0000	0.0000	0.0000;
	1003	1077	0.009421	0.041736	0.004576	114	114	114	0	0	1	-360	360	4.1429	-2.5149	-4.1412	1.9638	0.0000	0.0000	0.0000	0.0000;
	964	1745	0.005207	0.014215	0.001614	114	114	114	0	0	1	-360	360	-1.4007	0.5141	1.4008	-0.7099	0.0000	0.0000	0.0000	0.0000;
	1760	1086	0.002149	0.007273	0.000758	57	57	57	0	0	1	-360	360	-2.6800	0.7690	2.6801	-0.8611	0.0000	0.0000	0.0000	0.0000;
	1759	1087	0.002149	0.00719	0.000753	57	57	57	0	0	1	-360	360	-1.0880	-0.1440	1.0880	0.0521	0.0000	0.0000	0.0000	0.0000;
	1556	891	0.033058	0.05686	0.006142	90	90	90	0	0	1	-360	360	-19.0035	5.4209	19.1100	-5.9921	0.0000	0.0000	0.0000	0.0000;
	1579	907	0.017769	0.058016	0.005917	57	57	57	0	0	1	-360	360	0.4200	-0.8352	-0.4200	0.1306	0.0000	0.0000	0.0000	0.0000;
	1501	927	0.022479	0.054545	0.00621	114	114	114	0	0	1	-360	360	7.4524	-1.4354	-7.4420	0.7038	0.0000	0.0000	0.0000	0.0000;
	1058	1080	0.014545	0.04405	0.00522	57	57	57	0	0	1	-360	360	-10.4075	2.7162	10.4215	-3.3096	0.0000	0.0000	0.0000	0.0000;
	1521	1112	0.029917	0.096116	0.010188	57	57	57	0	0	1	-360	360	-2.8500	2.2950	2.8541	-3.5253	0.0000	0.0000	0.0000	0.0000;
	1093	1790	0.011157	0.034545	0.003903	114	114	114	0	0	1	-360	360	6.4036	-0.6675	-6.3999	0.2018	0.0000	0.0000	0.0000	0.0000;
	1519	1679	0.034628	0.108843	0.01203	114	114	114	0	0	1	-360	360	-3.4078	-0.1700	3.4112	-1.2863	0.0000	0.0000	0.0000	0.0000;
	1617	1002	0.021074	0.067686	0.007149	114	114	114	0	0	1	-360	360	-24.9108	5.0634	25.0225	-5.5836	0.0000	0.0000	0.0000	0.0000;
	1150	1617	0.030413	0.09438	0.010721	114	114	114	0	0	1	-360	360	-24.0925	2.4158	24.2397	-3.2703	0.0000	0.0000	0.0000	0.0000;
	1616	1617	0.007603	0.036364	0.006795	114	114	114	0	0	1	-360	360	-0.6710	0.9590	0.6711	-1.7930	0.0000	0.0000	0.0000	0.0000;
	1678	1003	0.014711	0.046529	0.005092	114	114	114	0	0	1	-360	360	-4.6682	0.9032	4.6710	-1.5156	0.0000	0.0000	0.0000	0.0000;
	1518	1149	0.010248	0.03124	0.003698	57	57	57	0	0	1	-360	360	0.7298	0.0170	-0.7297	-0.4675	0.0000	0.0000	0.0000	0.0000;
	1756	1092	0.004628	0.031736	0.003586	232	232	232	0	0	1	-360	360	6.1462	1.3901	-6.1447	-1.8161	0.0000	0.0000	0.0000	0.0000;
	1882	1117	0.003388	0.010331	0.00121	114	114	114	0	0	1	-360	360	48.9399	-2.6088	-48.8737	2.6622	0.0000	0.0000	0.0000	0.0000;
	1002	1881	0.003306	0.022479	0.002502	114	114	114	0	0	1	-360	360	55.9771	-3.0230	-55.8927	3.2888	0.0000	0.0000	0.0000	0.0000;
	1501	1002	0.03438	0.110579	0.011626	114	114	114	0	0	1	-360	360	-32.9455	5.0016	33.2606	-5.4130	0.0000	0.0000	0.0000	0.0000;
	1502	1003	0.03438	0.110579	0.011628	114	114	114	0	0	1	-360	360	-7.3748	0.6224	7.3907	-1.9891	0.0000	0.0000	0.0000	0.0000;
	1332	1066	0.053471	0.074876	0.006638	57	57	57	0	0	1	-360	360	7.5731	-1.7366	-7.5467	0.9799	0.0000	0.0000	0.0000	0.0000;
	972	902	0.008678	0.022066	0.002524	114	114	114	0	0	1	-360	360	-1.8886	-0.0819	1.8888	-0.2217	0.0000	0.0000	0.0000	0.0000;
	1789	1108	0.017025	0.053058	0.005936	114	114	114	0	0	1	-360	360	5.3949	-0.3281	-5.3908	-0.3844	0.0000	0.0000	0.0000	0.0000;
	1113	966	0.082314	0.150413	0.014297	57	57	57	0	0	1	-360	360	-7.2928	-0.2101	7.3297	-1.4354	0.0000	0.0000	0.0000	0.0000;
	1150	1080	0.04719	0.089008	0.008707	57	57	57	0	0	1	-360	360	5.9552	-3.5869	-5.9378	2.5587	0.0000	0.0000	0.0000	0.0000;
	962	973	0.058099	0.089008	0.008833	75	75	75	0	0	1	-360	360	1.2098	-1.7418	-1.2084	0.6799	0.0000	0.0000	0.0000	0.0000;
	907	1113	0.013636	0.043967	0.004617	114	114	114	0	0	1	-360	360	-5.6980	-0.3826	5.7018	-0.1559	0.0000	0.0000	0.0000	0.0000;
	1400	1501	0.000826	0.001653	0	229	229	229	0	0	1	-360	360	-0.3350	-0.0870	0.3350	0.0870	0.0000	0.0000	0.0000	0.0000;
	1401	1502	0.000826	0.001653	0	229	229	229	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1402	1501	0.001157	0.002066	0	229	229	229	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1686	957	0.023719	0.058264	0.006457	120	120	120	0	0	1	-360	360	23.4412	-0.6859	-23.3328	0.1792	0.0000	0.0000	0.0000	0.0000;
	1169	1395	0.004132	0.010165	0.001123	120	120	120	0	0	1	-360	360	3.5215	3.1122	-3.5207	-3.2441	0.0000	0.0000	0.0000	0.0000;
	1291	1169	0.03595	0.089835	0.009932	120	120	120	0	0	1	-360	360	5.2001	2.2676	-5.1895	-3.4291	0.0000	0.0000	0.0000	0.0000;
	1167	1169	0.000248	0.000496	0.000102	120	120	120	0	0	1	-360	360	-1.6680	-0.3290	1.6680	0.3169	0.0000	0.0000	0.0000	0.0000;
	1685	917	0.017851	0.041984	0.006072	120	120	120	0	0	1	-360	360	20.2422	-0.3831	-20.1814	-0.2017	0.0000	0.0000	0.0000	0.0000;
	1685	864	0.018182	0.06281	0.0065	114	114	114	0	0	1	-360	360	17.6641	2.7331	-17.6154	-3.3433	0.0000	0.0000	0.0000	0.0000;
	1686	1573	0.025124	0.089339	0.008877	114	114	114	0	0	1	-360	360	6.6004	2.8715	-6.5889	-3.8937	0.0000	0.0000	0.0000	0.0000;
	1685	1276	0.01157	0.025785	0.003778	120	120	120	0	0	1	-360	360	0.0000	-0.4282	0.0000	-0.0260	0.0000	0.0000	0.0000	0.0000;
	1706	1395	0.02438	0.043802	0.009111	120	120	120	0	0	1	-360	360	-7.9594	0.5529	7.9726	-1.6126	0.0000	0.0000	0.0000	0.0000;
	1170	1395	0.004132	0.010165	0.001123	120	120	120	0	0	1	-360	360	-0.9502	-3.2257	0.9505	3.0930	0.0000	0.0000	0.0000	0.0000;
	1818	1170	0.005702	0.017438	0.001672	120	120	120	0	0	1	-360	360	1.9104	-2.8643	-1.9099	2.6670	0.0000	0.0000	0.0000	0.0000;
	1170	1168	0.000331	0.000579	0.000121	120	120	120	0	0	1	-360	360	2.8600	0.5586	-2.8600	-0.5730	0.0000	0.0000	0.0000	0.0000;
	1819	1615	0.019174	0.052562	0.005515	120	120	120	0	0	1	-360	360	-13.3074	2.2630	13.3371	-2.8366	0.0000	0.0000	0.0000	0.0000;
	1818	1163	0.000826	0.002397	0.000315	114	114	114	0	0	1	-360	360	6.7093	1.6436	-6.7090	-1.6800	0.0000	0.0000	0.0000	0.0000;
	1819	1164	0.000909	0.002645	0.00037	114	114	114	0	0	1	-360	360	4.6222	0.7926	-4.6220	-0.8360	0.0000	0.0000	0.0000	0.0000;
	1819	1158	0.001818	0.005537	0.000653	114	114	114	0	0	1	-360	360	19.4063	6.1049	-19.4000	-6.1630	0.0000	0.0000	0.0000	0.0000;
	1818	1159	0.001901	0.005702	0.000673	114	114	114	0	0	1	-360	360	1.6741	0.7372	-1.6740	-0.8170	0.0000	0.0000	0.0000	0.0000;
	1825	1573	0.004628	0.014876	0.001563	114	114	114	0	0	1	-360	360	-0.7863	-7.9397	0.7887	7.7611	0.0000	0.0000	0.0000	0.0000;
	1377	1572	0.008264	0.026612	0.0028	114	114	114	0	0	1	-360	360	-6.7717	-0.5998	6.7749	0.2773	0.0000	0.0000	0.0000	0.0000;
	1819	1156	0.005372	0.01281	0.002529	114	114	114	0	0	1	-360	360	4.4401	4.0249	-4.4384	-4.3207	0.0000	0.0000	0.0000	0.0000;
	1394	1153	0.003471	0.006529	0.000605	90	90	90	0	0	1	-360	360	0.0223	2.9378	-0.0220	-3.0090	0.0000	0.0000	0.0000	0.0000;
	1394	1154	0.003636	0.006446	0.00059	90	90	90	0	0	1	-360	360	-2.2216	2.5597	2.2220	-2.6290	0.0000	0.0000	0.0000	0.0000;
	1395	1155	0.003636	0.006446	0.00059	90	90	90	0	0	1	-360	360	1.0713	2.9492	-1.0710	-3.0190	0.0000	0.0000	0.0000	0.0000;
	1395	1160	0.001074	0.002231	0.000414	114	114	114	0	0	1	-360	360	7.9826	1.4110	-7.9820	-1.4590	0.0000	0.0000	0.0000	0.0000;
	1394	1161	0.001157	0.002066	0.000426	114	114	114	0	0	1	-360	360	9.6019	1.6882	-9.6010	-1.7370	0.0000	0.0000	0.0000	0.0000;
	1819	1166	0.001818	0.005124	0.000716	114	114	114	0	0	1	-360	360	11.8062	6.0668	-11.8035	-6.1441	0.0000	0.0000	0.0000	0.0000;
	1394	1157	0.002479	0.006364	0.001108	114	114	114	0	0	1	-360	360	6.9117	-2.1781	-6.9106	2.0496	0.0000	0.0000	0.0000	0.0000;
	1394	871	0.017934	0.04438	0.004813	120	120	120	0	0	1	-360	360	-9.4254	0.1816	9.4389	-0.7193	0.0000	0.0000	0.0000	0.0000;
	995	872	0.006281	0.019091	0.001994	114	114	114	0	0	1	-360	360	13.6312	-2.7243	-13.6210	2.5183	0.0000	0.0000	0.0000	0.0000;
	1559	1074	0.013223	0.036364	0.003872	114	114	114	0	0	1	-360	360	11.8075	-3.3465	-11.7909	2.9318	0.0000	0.0000	0.0000	0.0000;
	1824	1375	0.003719	0.012066	0.001268	140	140	140	0	0	1	-360	360	-6.7767	6.6092	6.7796	-6.7510	0.0000	0.0000	0.0000	0.0000;
	1542	1377	0.002066	0.006446	0.000748	140	140	140	0	0	1	-360	360	0.4947	2.5595	-0.4946	-2.6479	0.0000	0.0000	0.0000	0.0000;
	957	1543	0.011983	0.034132	0.003741	120	120	120	0	0	1	-360	360	7.2559	2.7209	-7.2497	-3.1486	0.0000	0.0000	0.0000	0.0000;
	1685	1763	0.012314	0.037521	0.004424	114	114	114	0	0	1	-360	360	21.9914	3.8424	-21.9402	-4.2163	0.0000	0.0000	0.0000	0.0000;
	1692	939	0.003884	0.009174	0.001317	120	120	120	0	0	1	-360	360	14.4707	-3.7561	-14.4635	3.6148	0.0000	0.0000	0.0000	0.0000;
	1692	1685	0.000661	0.00438	0.000586	152	152	152	0	0	1	-360	360	-22.9539	7.6540	22.9571	-7.7030	0.0000	0.0000	0.0000	0.0000;
	1691	1686	0.000909	0.006281	0.000755	152	152	152	0	0	1	-360	360	-23.4013	11.0812	23.4063	-11.1370	0.0000	0.0000	0.0000	0.0000;
	1229	1775	0.043223	0.057851	0.005162	57	57	57	0	0	1	-360	360	-3.1743	0.1497	3.1780	-0.7631	0.0000	0.0000	0.0000	0.0000;
	1687	1229	0.009256	0.029752	0.003134	57	57	57	0	0	1	-360	360	-1.0640	-0.0802	1.0640	-0.2945	0.0000	0.0000	0.0000	0.0000;
	1227	1229	0.007686	0.010165	0.000908	75	75	75	0	0	1	-360	360	-2.1100	-0.2530	2.1103	0.1448	0.0000	0.0000	0.0000	0.0000;
	1230	1776	0.034793	0.040248	0.007214	57	57	57	0	0	1	-360	360	-3.8685	0.2680	3.8730	-1.1270	0.0000	0.0000	0.0000	0.0000;
	1688	1230	0.009091	0.029174	0.003078	57	57	57	0	0	1	-360	360	-1.9840	-0.0008	1.9844	-0.3667	0.0000	0.0000	0.0000	0.0000;
	1228	1230	0.004132	0.007438	0.001149	62	62	62	0	0	1	-360	360	-1.8840	-0.2360	1.8841	0.0986	0.0000	0.0000	0.0000	0.0000;
	1692	1604	0.087769	0.169835	0.016066	90	90	90	0	0	1	-360	360	8.4832	-3.8979	-8.4244	2.0830	0.0000	0.0000	0.0000	0.0000;
	1686	1438	0.02	0.046694	0.009535	114	114	114	0	0	1	-360	360	22.1340	-2.0356	-22.0521	1.0836	0.0000	0.0000	0.0000	0.0000;
	1439	1392	0.039339	0.090413	0.018963	114	114	114	0	0	1	-360	360	14.6059	-2.5651	-14.5350	0.4700	0.0000	0.0000	0.0000	0.0000;
	1183	1215	0.043223	0.103058	0.011205	90	90	90	0	0	1	-360	360	0.0436	0.3447	-0.0433	-1.6836	0.0000	0.0000	0.0000	0.0000;
	1775	1355	0.015703	0.024793	0.004015	90	90	90	0	0	1	-360	360	-1.5416	2.6001	1.5430	-3.0791	0.0000	0.0000	0.0000	0.0000;
	1645	883	0.036777	0.09157	0.00974	120	120	120	0	0	1	-360	360	7.9363	-3.6682	-7.9135	2.5839	0.0000	0.0000	0.0000	0.0000;
	1079	1541	0.009339	0.017355	0.001779	90	90	90	0	0	1	-360	360	14.8521	2.4512	-14.8340	-2.6260	0.0000	0.0000	0.0000	0.0000;
	1078	1307	0.032645	0.099504	0.011696	76	76	76	0	0	1	-360	360	0.5805	-2.2738	-0.5797	0.9022	0.0000	0.0000	0.0000	0.0000;
	1605	1356	0.026529	0.034463	0.006389	90	90	90	0	0	1	-360	360	3.9604	-3.3604	-3.9550	2.6020	0.0000	0.0000	0.0000	0.0000;
	1375	994	0.003884	0.012479	0.001309	114	114	114	0	0	1	-360	360	20.0477	-2.6671	-20.0344	2.5543	0.0000	0.0000	0.0000	0.0000;
	1097	1740	0.035785	0.070331	0.00718	90	90	90	0	0	1	-360	360	-4.6640	5.5953	4.6818	-6.3947	0.0000	0.0000	0.0000	0.0000;
	1739	1064	0.003967	0.00719	0.001026	57	57	57	0	0	1	-360	360	1.5161	-0.0808	-1.5160	-0.0380	0.0000	0.0000	0.0000	0.0000;
	1739	1861	0.007107	0.011818	0.001256	90	90	90	0	0	1	-360	360	0.3899	-0.2856	-0.3899	0.1400	0.0000	0.0000	0.0000	0.0000;
	1740	1862	0.007025	0.011653	0.001244	90	90	90	0	0	1	-360	360	0.6231	0.0698	-0.6231	-0.2140	0.0000	0.0000	0.0000	0.0000;
	894	1462	0.019091	0.057934	0.006878	114	114	114	0	0	1	-360	360	7.7613	0.9543	-7.7514	-1.7463	0.0000	0.0000	0.0000	0.0000;
	1776	894	0.006529	0.019835	0.002357	114	114	114	0	0	1	-360	360	9.3754	0.5607	-9.3706	-0.8285	0.0000	0.0000	0.0000	0.0000;
	893	894	0.01	0.030331	0.003603	57	57	57	0	0	1	-360	360	-1.6090	-0.3050	1.6092	-0.1258	0.0000	0.0000	0.0000	0.0000;
	1078	1393	0.038678	0.119669	0.013649	114	114	114	0	0	1	-360	360	-7.3690	-3.8148	7.3899	2.2691	0.0000	0.0000	0.0000	0.0000;
	1078	906	0.002645	0.008182	0.000961	114	114	114	0	0	1	-360	360	4.3700	4.6903	-4.3691	-4.8000	0.0000	0.0000	0.0000	0.0000;
	1844	956	0.01405	0.026033	0.003528	90	90	90	0	0	1	-360	360	-17.8893	-1.1225	17.9273	0.7734	0.0000	0.0000	0.0000	0.0000;
	1572	865	0.012727	0.043388	0.004581	114	114	114	0	0	1	-360	360	-5.3959	-2.1329	5.3993	1.5994	0.0000	0.0000	0.0000	0.0000;
	998	1375	0.002149	0.014711	0.00167	152	152	152	0	0	1	-360	360	-3.9510	-0.9060	3.9513	0.7094	0.0000	0.0000	0.0000	0.0000;
	1290	1685	0.007686	0.020496	0.002246	120	120	120	0	0	1	-360	360	-6.2871	-2.3309	6.2899	2.0687	0.0000	0.0000	0.0000	0.0000;
	1818	1376	0.002645	0.01876	0.001951	152	152	152	0	0	1	-360	360	-10.2938	0.4836	10.2961	-0.6988	0.0000	0.0000	0.0000	0.0000;
	1819	1377	0.002645	0.01876	0.001951	152	152	152	0	0	1	-360	360	10.1618	-5.0216	-10.1590	4.8102	0.0000	0.0000	0.0000	0.0000;
	1894	1573	0.015124	0.041157	0.004104	114	114	114	0	0	1	-360	360	1.4918	1.6921	-1.4910	-2.1802	0.0000	0.0000	0.0000	0.0000;
	918	1536	0.008926	0.023719	0.003146	114	114	114	0	0	1	-360	360	11.3672	-0.2499	-11.3576	-0.1001	0.0000	0.0000	0.0000	0.0000;
	1079	1096	0.04124	0.076446	0.007979	90	90	90	0	0	1	-360	360	-0.6575	5.4631	0.6700	-6.3726	0.0000	0.0000	0.0000	0.0000;
	1394	1165	0.005207	0.012231	0.002452	114	114	114	0	0	1	-360	360	4.2718	-3.4953	-4.2705	3.2079	0.0000	0.0000	0.0000	0.0000;
	1075	1572	0.015207	0.040083	0.004366	120	120	120	0	0	1	-360	360	6.4988	-3.5405	-6.4921	3.0394	0.0000	0.0000	0.0000	0.0000;
	1614	1375	0.004711	0.015289	0.001605	140	140	140	0	0	1	-360	360	-15.1982	2.4671	15.2076	-2.6274	0.0000	0.0000	0.0000	0.0000;
	1456	1078	0.010909	0.035289	0.003691	114	114	114	0	0	1	-360	360	-2.4989	1.9068	2.4999	-2.3368	0.0000	0.0000	0.0000	0.0000;
	1528	1457	0.031901	0.106364	0.011251	114	114	114	0	0	1	-360	360	-0.3307	0.0386	0.3309	-1.3599	0.0000	0.0000	0.0000	0.0000;
	1331	1377	0.001653	0.011157	0.001239	152	152	152	0	0	1	-360	360	-14.5742	2.5100	14.5772	-2.6365	0.0000	0.0000	0.0000	0.0000;
	1449	1306	0.006529	0.020909	0.002214	114	114	114	0	0	1	-360	360	3.7666	-0.9292	-3.7658	0.6714	0.0000	0.0000	0.0000	0.0000;
	1529	1307	0.021984	0.070744	0.007439	114	114	114	0	0	1	-360	360	-0.8923	-0.5256	0.8925	-0.3487	0.0000	0.0000	0.0000	0.0000;
	1776	1691	0.045124	0.233802	0.024389	114	114	114	0	0	1	-360	360	-8.7689	-0.6335	8.7981	-2.1450	0.0000	0.0000	0.0000	0.0000;
	1776	1685	0.045703	0.237025	0.024841	114	114	114	0	0	1	-360	360	-8.6886	-0.4380	8.7178	-2.3934	0.0000	0.0000	0.0000	0.0000;
	1395	1162	0.000826	0.002645	0.000312	140	140	140	0	0	1	-360	360	2.5200	0.4800	-2.5200	-0.5170	0.0000	0.0000	0.0000	0.0000;
	1636	999	0.004298	0.00719	0.01602	120	120	120	0	0	1	-360	360	-10.0242	1.4400	10.0280	-3.3362	0.0000	0.0000	0.0000	0.0000;
	1775	1182	0.058099	0.13124	0.012928	90	90	90	0	0	1	-360	360	1.5188	-0.6083	-1.5176	-0.9377	0.0000	0.0000	0.0000	0.0000;
	1376	1558	0.003884	0.012562	0.001326	114	114	114	0	0	1	-360	360	15.7521	-3.6405	-15.7436	3.5103	0.0000	0.0000	0.0000	0.0000;
	1386	1572	0.001653	0.005793	0	97	97	97	0	0	1	-360	360	-1.8070	0.5620	1.8070	-0.5618	0.0000	0.0000	0.0000	0.0000;
	1387	1573	0.001653	0.005793	0	97	97	97	0	0	1	-360	360	-3.7090	1.6160	3.7092	-1.6152	0.0000	0.0000	0.0000	0.0000;
	884	905	0.003967	0.012149	0.001391	114	114	114	0	0	1	-360	360	1.4925	-3.8692	-1.4919	3.7079	0.0000	0.0000	0.0000	0.0000;
	1577	1395	0.018017	0.054793	0.006483	114	114	114	0	0	1	-360	360	-6.9669	-1.4869	6.9745	0.7391	0.0000	0.0000	0.0000	0.0000;
	1845	1465	0.017851	0.03438	0.004874	90	90	90	0	0	1	-360	360	12.6961	-0.6781	-12.6718	0.1477	0.0000	0.0000	0.0000	0.0000;
	1537	956	0.006777	0.01595	0.002253	114	114	114	0	0	1	-360	360	7.2865	0.8836	-7.2834	-1.1450	0.0000	0.0000	0.0000	0.0000;
	1304	1463	0.006612	0.021074	0.002294	97	97	97	0	0	1	-360	360	-6.4099	-2.1715	6.4124	1.9060	0.0000	0.0000	0.0000	0.0000;
	1853	1893	0.02	0.056529	0.005397	120	120	120	0	0	1	-360	360	3.0597	1.0117	-3.0578	-1.6522	0.0000	0.0000	0.0000	0.0000;
	999	1330	0.000579	0.003884	0.000452	152	152	152	0	0	1	-360	360	-13.8870	2.5352	13.8880	-2.5825	0.0000	0.0000	0.0000	0.0000;
	1309	1394	0.043719	0.115041	0.011948	120	120	120	0	0	1	-360	360	11.6309	0.8743	-11.5806	-2.1658	0.0000	0.0000	0.0000	0.0000;
	1448	1749	0.032562	0.104628	0.011026	114	114	114	0	0	1	-360	360	-4.5696	0.8961	4.5760	-2.1722	0.0000	0.0000	0.0000	0.0000;
	1079	1305	0.049422	0.164628	0.016129	114	114	114	0	0	1	-360	360	-3.0054	-5.4768	3.0179	3.6114	0.0000	0.0000	0.0000	0.0000;
	1010	1764	0.011735	0.03562	0.004228	114	114	114	0	0	1	-360	360	-16.7690	-3.5704	16.7979	3.1547	0.0000	0.0000	0.0000	0.0000;
	1275	1635	0.002645	0.008264	0.0009	120	120	120	0	0	1	-360	360	-2.6880	-0.0260	2.6882	-0.0804	0.0000	0.0000	0.0000	0.0000;
	1791	1765	0.010578	0.029091	0.003349	114	114	114	0	0	1	-360	360	-6.7545	7.3989	6.7638	-7.7659	0.0000	0.0000	0.0000	0.0000;
	1765	863	0.005207	0.015785	0.001868	140	140	140	0	0	1	-360	360	0.0000	-0.2187	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1766	843	0.00157	0.001983	0.00037	90	90	90	0	0	1	-360	360	3.3502	0.4660	-3.3500	-0.5090	0.0000	0.0000	0.0000	0.0000;
	1765	844	0.001488	0.001818	0.000353	90	90	90	0	0	1	-360	360	0.0000	-0.0414	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1766	845	0.000496	0.000579	0.000111	90	90	90	0	0	1	-360	360	35.1522	15.2443	-35.1460	-15.2500	0.0000	0.0000	0.0000	0.0000;
	1766	846	0.001074	0.001322	0.000252	90	90	90	0	0	1	-360	360	-30.0037	-0.0391	30.0120	0.0200	0.0000	0.0000	0.0000	0.0000;
	1792	1766	0.009917	0.030331	0.003557	102	102	102	0	0	1	-360	360	-8.4046	14.5224	8.4290	-14.8642	0.0000	0.0000	0.0000	0.0000;
	931	1863	0.023141	0.028926	0.005498	77	77	77	0	0	1	-360	360	-2.4532	-3.5617	2.4564	2.9213	0.0000	0.0000	0.0000	0.0000;
	1256	1350	0.022149	0.04281	0.008245	102	102	102	0	0	1	-360	360	7.5692	5.3901	-7.5518	-6.3166	0.0000	0.0000	0.0000	0.0000;
	875	932	0.020827	0.026446	0.004884	77	77	77	0	0	1	-360	360	7.4513	-4.0788	-7.4388	3.5226	0.0000	0.0000	0.0000	0.0000;
	1012	875	0.018512	0.058347	0.006326	90	90	90	0	0	1	-360	360	8.5536	-4.5693	-8.5393	3.8740	0.0000	0.0000	0.0000	0.0000;
	873	875	0.000496	0.000826	8.7e-05	90	90	90	0	0	1	-360	360	-1.0880	-0.2150	1.0880	0.2048	0.0000	0.0000	0.0000	0.0000;
	1765	1256	0.006942	0.019091	0.001938	102	102	102	0	0	1	-360	360	-8.0188	7.9840	8.0265	-8.1895	0.0000	0.0000	0.0000	0.0000;
	1787	1256	0.00686	0.010165	0.001747	76	76	76	0	0	1	-360	360	-9.7885	5.8902	9.7963	-6.0829	0.0000	0.0000	0.0000	0.0000;
	1121	1863	0.000496	0.00157	0.000186	57	57	57	0	0	1	-360	360	-5.0210	-1.6030	5.0211	1.5815	0.0000	0.0000	0.0000	0.0000;
	1791	1602	0.005702	0.018512	0.001909	114	114	114	0	0	1	-360	360	-4.4215	6.8001	4.4248	-7.0134	0.0000	0.0000	0.0000	0.0000;
	1791	874	0.021322	0.06843	0.007265	77	77	77	0	0	1	-360	360	0.0000	-0.8527	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1743	1361	0.002562	0.005868	0.000794	57	57	57	0	0	1	-360	360	-5.0210	-0.8670	5.0216	0.7770	0.0000	0.0000	0.0000	0.0000;
	1744	1362	0.001983	0.005041	0.000649	57	57	57	0	0	1	-360	360	-5.0210	-0.8670	5.0214	0.7935	0.0000	0.0000	0.0000	0.0000;
	1122	1864	0.000579	0.001818	0.00022	57	57	57	0	0	1	-360	360	-0.5020	-0.0000	0.5020	-0.0258	0.0000	0.0000	0.0000	0.0000;
	1864	1339	0.005124	0.01562	0.001849	114	114	114	0	0	1	-360	360	-1.9921	-2.5057	1.9925	2.2899	0.0000	0.0000	0.0000	0.0000;
	1475	1562	0.003636	0.011074	0.001314	114	114	114	0	0	1	-360	360	5.5153	-8.0619	-5.5124	7.9170	0.0000	0.0000	0.0000	0.0000;
	1792	1563	0.00595	0.019917	0.001953	114	114	114	0	0	1	-360	360	-5.3397	7.7912	5.3443	-8.0047	0.0000	0.0000	0.0000	0.0000;
	1246	1361	0.01	0.016529	0.001783	76	76	76	0	0	1	-360	360	25.0795	-1.4284	-25.0249	1.3131	0.0000	0.0000	0.0000	0.0000;
	1592	1245	0.023388	0.032562	0.005065	77	77	77	0	0	1	-360	360	31.1350	-0.5461	-30.9411	0.2273	0.0000	0.0000	0.0000	0.0000;
	1603	1089	0.006612	0.021488	0.002222	114	114	114	0	0	1	-360	360	-8.1918	5.9528	8.1977	-6.1938	0.0000	0.0000	0.0000	0.0000;
	1255	1582	0.003636	0.011074	0.001317	114	114	114	0	0	1	-360	360	12.3950	-5.3399	-12.3893	5.2032	0.0000	0.0000	0.0000	0.0000;
	1255	1461	0.008017	0.024215	0.00287	76	76	76	0	0	1	-360	360	-6.1646	-1.5587	6.1673	1.2313	0.0000	0.0000	0.0000	0.0000;
	1499	1460	0.012645	0.037025	0.003359	102	102	102	0	0	1	-360	360	8.7730	1.6272	-8.7644	-1.9956	0.0000	0.0000	0.0000	0.0000;
	1583	1088	0.005868	0.017851	0.00212	114	114	114	0	0	1	-360	360	9.8783	-5.7242	-9.8718	5.4959	0.0000	0.0000	0.0000	0.0000;
	1256	1662	0.027355	0.092066	0.008835	114	114	114	0	0	1	-360	360	1.5095	-0.5104	-1.5090	-0.5200	0.0000	0.0000	0.0000	0.0000;
	1095	1500	0.001736	0.005124	0.000472	102	102	102	0	0	1	-360	360	9.6956	2.2718	-9.6941	-2.3229	0.0000	0.0000	0.0000	0.0000;
	1654	1095	0.02157	0.061322	0.005	102	102	102	0	0	1	-360	360	12.2364	2.4547	-12.2077	-2.9625	0.0000	0.0000	0.0000	0.0000;
	1095	1094	0.003141	0.003884	0.000745	57	57	57	0	0	1	-360	360	2.5122	0.6907	-2.5120	-0.7780	0.0000	0.0000	0.0000	0.0000;
	1807	1791	0.011901	0.037686	0.00409	114	114	114	0	0	1	-360	360	-12.2324	-0.8051	12.2477	0.3741	0.0000	0.0000	0.0000	0.0000;
	1766	1255	0.006777	0.020579	0.001953	102	102	102	0	0	1	-360	360	-16.9277	-0.8070	16.9443	0.6297	0.0000	0.0000	0.0000	0.0000;
	1351	1361	0.025289	0.04719	0.009431	102	102	102	0	0	1	-360	360	6.7147	6.0610	-6.6954	-7.1145	0.0000	0.0000	0.0000	0.0000;
	1788	1474	0.003141	0.009504	0.00113	114	114	114	0	0	1	-360	360	8.7835	-6.0600	-8.7804	5.9371	0.0000	0.0000	0.0000	0.0000;
	960	1792	0.034298	0.109421	0.011715	114	114	114	0	0	1	-360	360	-10.2859	-1.2971	10.3171	0.0272	0.0000	0.0000	0.0000	0.0000;
	1792	1013	0.014545	0.045785	0.005055	114	114	114	0	0	1	-360	360	21.2842	-3.2682	-21.2270	2.8561	0.0000	0.0000	0.0000	0.0000;
	1791	1489	0.019587	0.062975	0.006621	119	119	119	0	0	1	-360	360	13.2372	-2.9340	-13.2068	2.2551	0.0000	0.0000	0.0000	0.0000;
	1839	1172	0.003554	0.011157	0.001258	140	140	140	0	0	1	-360	360	52.5168	5.0210	-52.4377	-4.9298	0.0000	0.0000	0.0000	0.0000;
	1277	1369	0.001983	0.006364	0.000668	114	114	114	0	0	1	-360	360	51.0072	2.8212	-50.9652	-2.7690	0.0000	0.0000	0.0000	0.0000;
	1360	1289	0.000909	0.006446	0.000665	152	152	152	0	0	1	-360	360	-11.1272	-3.1726	11.1282	3.0981	0.0000	0.0000	0.0000	0.0000;
	1627	1360	0.004298	0.030083	0.003228	232	232	232	0	0	1	-360	360	-7.4397	-2.7842	7.4418	2.4044	0.0000	0.0000	0.0000	0.0000;
	1358	1360	0.003141	0.005868	0.000559	90	90	90	0	0	1	-360	360	-3.6850	-0.8360	3.6854	0.7682	0.0000	0.0000	0.0000	0.0000;
	1598	1415	0.009587	0.02595	0.002885	120	120	120	0	0	1	-360	360	-1.3394	0.8373	1.3396	-1.1826	0.0000	0.0000	0.0000	0.0000;
	911	885	0.010413	0.03157	0.003734	140	140	140	0	0	1	-360	360	-1.0040	-0.1300	1.0041	-0.3242	0.0000	0.0000	0.0000	0.0000;
	1628	1802	0.002645	0.007934	0.000941	140	140	140	0	0	1	-360	360	16.6575	-0.2378	-16.6514	0.1424	0.0000	0.0000	0.0000	0.0000;
	912	886	0.010083	0.030579	0.00362	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.4406	0.0000	0.0000	0.0000	0.0000;
	1632	1873	0.012314	0.03157	0.003463	120	120	120	0	0	1	-360	360	6.0288	6.9932	-6.0199	-7.3898	0.0000	0.0000	0.0000	0.0000;
	1567	1453	0.001901	0.006033	0.000632	114	114	114	0	0	1	-360	360	4.1938	-0.1066	-4.1935	0.0315	0.0000	0.0000	0.0000	0.0000;
	1738	1567	0.003554	0.011488	0.001205	114	114	114	0	0	1	-360	360	4.1943	-0.2887	-4.1938	0.1453	0.0000	0.0000	0.0000	0.0000;
	1567	1565	0.001322	0.003223	0.000322	90	90	90	0	0	1	-360	360	0.0000	-0.0387	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	929	1046	0.003471	0.011074	0.001159	140	140	140	0	0	1	-360	360	5.5269	0.2292	-5.5260	-0.3680	0.0000	0.0000	0.0000	0.0000;
	930	1047	0.003388	0.011074	0.001154	140	140	140	0	0	1	-360	360	0.0000	-0.1418	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1839	1378	0.009421	0.029917	0.003214	140	140	140	0	0	1	-360	360	27.8509	3.2942	-27.7916	-3.5066	0.0000	0.0000	0.0000	0.0000;
	1644	1473	0.007107	0.022066	0.002517	140	140	140	0	0	1	-360	360	-0.1213	0.6175	0.1213	-0.9294	0.0000	0.0000	0.0000	0.0000;
	1621	1644	0.000992	0.003058	0.000351	114	114	114	0	0	1	-360	360	0.4648	0.6930	-0.4648	-0.7365	0.0000	0.0000	0.0000	0.0000;
	1643	1644	0.00124	0.003636	0.000436	140	140	140	0	0	1	-360	360	-0.5860	-0.1730	0.5860	0.1190	0.0000	0.0000	0.0000	0.0000;
	1413	989	0.000826	0.002479	0.000295	140	140	140	0	0	1	-360	360	-0.4046	-1.5863	0.4046	1.5509	0.0000	0.0000	0.0000	0.0000;
	1067	1069	0.001818	0.005455	0.000651	29	29	29	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0780	0.0000	0.0000	0.0000	0.0000;
	1553	1208	0.003223	0.010413	0.001079	140	140	140	0	0	1	-360	360	1.7554	6.1814	-1.7542	-6.3063	0.0000	0.0000	0.0000	0.0000;
	1618	1553	0.003719	0.011735	0.001309	140	140	140	0	0	1	-360	360	4.0185	6.7424	-4.0165	-6.8924	0.0000	0.0000	0.0000	0.0000;
	1551	1553	0.002397	0.00719	0.00075	120	120	120	0	0	1	-360	360	-2.2610	-0.8000	2.2611	0.7109	0.0000	0.0000	0.0000	0.0000;
	1761	988	0.01281	0.039008	0.004576	140	140	140	0	0	1	-360	360	8.7806	2.4566	-8.7717	-2.9810	0.0000	0.0000	0.0000	0.0000;
	1923	1288	0.011983	0.038595	0.004056	140	140	140	0	0	1	-360	360	-16.8148	-1.8442	16.8426	1.4340	0.0000	0.0000	0.0000	0.0000;
	1115	1060	0.004959	0.016694	0.001597	140	140	140	0	0	1	-360	360	1.5061	-0.0190	-1.5060	-0.1730	0.0000	0.0000	0.0000	0.0000;
	1115	1061	0.003388	0.010248	0.001217	140	140	140	0	0	1	-360	360	1.9251	0.1138	-1.9250	-0.2600	0.0000	0.0000	0.0000	0.0000;
	1709	1684	0.003388	0.011488	0.001096	140	140	140	0	0	1	-360	360	-19.0236	-0.8469	19.0335	0.7442	0.0000	0.0000	0.0000	0.0000;
	1311	1778	0.000165	0.000496	6.1e-05	140	140	140	0	0	1	-360	360	10.4828	3.4124	-10.4826	-3.4192	0.0000	0.0000	0.0000	0.0000;
	1416	1311	0.005289	0.016198	0.001854	140	140	140	0	0	1	-360	360	10.4881	3.1264	-10.4828	-3.3320	0.0000	0.0000	0.0000	0.0000;
	1310	1311	0.004215	0.007603	0.000673	90	90	90	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0805	0.0000	0.0000	0.0000	0.0000;
	868	1544	0.010992	0.027851	0.003979	120	120	120	0	0	1	-360	360	4.9335	3.3352	-4.9302	-3.8066	0.0000	0.0000	0.0000	0.0000;
	868	1758	0.005785	0.020496	0.002033	114	114	114	0	0	1	-360	360	-4.9335	-3.3235	4.9352	3.0836	0.0000	0.0000	0.0000	0.0000;
	867	868	0.000248	0.000826	9.7e-05	140	140	140	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0117	0.0000	0.0000	0.0000	0.0000;
	926	1115	0.000413	0.00124	0.000133	114	114	114	0	0	1	-360	360	-5.8647	-0.3713	5.8648	0.3556	0.0000	0.0000	0.0000	0.0000;
	938	926	0.002727	0.007686	0.000794	120	120	120	0	0	1	-360	360	-5.8639	-0.5191	5.8647	0.4258	0.0000	0.0000	0.0000	0.0000;
	1107	938	0.00438	0.014132	0.001486	114	114	114	0	0	1	-360	360	-5.8627	-0.8249	5.8639	0.6502	0.0000	0.0000	0.0000	0.0000;
	1271	1107	0.000331	0.001074	0.000123	114	114	114	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0148	0.0000	0.0000	0.0000	0.0000;
	924	926	0.00124	0.003884	0.000452	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0545	0.0000	0.0000	0.0000	0.0000;
	938	937	0.003388	0.011405	0.001089	114	114	114	0	0	1	-360	360	0.0000	-0.1311	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1105	1107	0.002231	0.006942	0.000784	114	114	114	0	0	1	-360	360	-5.8620	-0.9320	5.8627	0.8397	0.0000	0.0000	0.0000	0.0000;
	1426	1836	0.005289	0.016116	0.001871	140	140	140	0	0	1	-360	360	4.8732	4.1397	-4.8713	-4.3599	0.0000	0.0000	0.0000	0.0000;
	1873	1426	0.002397	0.007273	0.000835	140	140	140	0	0	1	-360	360	4.8740	4.0121	-4.8732	-4.1105	0.0000	0.0000	0.0000	0.0000;
	1426	1425	0.000992	0.00124	0.000242	90	90	90	0	0	1	-360	360	0.0000	-0.0292	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1044	1259	0.004959	0.015124	0.001793	140	140	140	0	0	1	-360	360	-1.4231	-0.0614	1.4231	-0.1625	0.0000	0.0000	0.0000	0.0000;
	1718	1581	0.002314	0.007355	0.000784	140	140	140	0	0	1	-360	360	-37.4822	-1.5396	37.5092	1.5304	0.0000	0.0000	0.0000	0.0000;
	1200	1642	0.008182	0.020331	0.002188	120	120	120	0	0	1	-360	360	-21.8591	-3.0157	21.8915	2.8277	0.0000	0.0000	0.0000	0.0000;
	1850	1200	0.004711	0.011735	0.001341	120	120	120	0	0	1	-360	360	-20.9219	-2.8842	20.9391	2.7628	0.0000	0.0000	0.0000	0.0000;
	1198	1200	0.000909	0.002066	0.000237	120	120	120	0	0	1	-360	360	-0.9200	-0.2820	0.9200	0.2529	0.0000	0.0000	0.0000	0.0000;
	1634	851	0.006529	0.020661	0.002234	140	140	140	0	0	1	-360	360	3.7656	-5.9141	-3.7630	5.6571	0.0000	0.0000	0.0000	0.0000;
	1803	1283	0.012314	0.041653	0.003976	140	140	140	0	0	1	-360	360	12.3833	-0.7937	-12.3676	0.3675	0.0000	0.0000	0.0000	0.0000;
	949	1632	0.025868	0.067107	0.007543	120	120	120	0	0	1	-360	360	-9.2385	-3.0500	9.2582	2.1882	0.0000	0.0000	0.0000	0.0000;
	1527	977	0.004959	0.015124	0.001769	140	140	140	0	0	1	-360	360	-23.9605	-1.8782	23.9836	1.7294	0.0000	0.0000	0.0000	0.0000;
	1547	1908	0.001405	0.003471	0.000506	120	120	120	0	0	1	-360	360	11.8823	1.4392	-11.8807	-1.4967	0.0000	0.0000	0.0000	0.0000;
	1848	1232	0.004132	0.012975	0.00144	140	140	140	0	0	1	-360	360	4.9806	1.9525	-4.9796	-2.1265	0.0000	0.0000	0.0000	0.0000;
	1837	1672	0.017603	0.056281	0.005973	140	140	140	0	0	1	-360	360	48.2087	3.4922	-47.8765	-3.1639	0.0000	0.0000	0.0000	0.0000;
	1590	930	0.006364	0.020165	0.002188	114	114	114	0	0	1	-360	360	-22.8761	-2.6463	22.9036	2.4651	0.0000	0.0000	0.0000	0.0000;
	921	1544	0.008595	0.027603	0.002909	140	140	140	0	0	1	-360	360	43.3563	7.1964	-43.2197	-7.1096	0.0000	0.0000	0.0000	0.0000;
	1838	1545	0.026198	0.08405	0.008869	114	114	114	0	0	1	-360	360	36.4076	9.1021	-36.1080	-9.2257	0.0000	0.0000	0.0000	0.0000;
	1683	980	0.006364	0.02124	0.002072	140	140	140	0	0	1	-360	360	-21.5438	-0.7473	21.5676	0.5688	0.0000	0.0000	0.0000	0.0000;
	1632	1348	0.019752	0.052975	0.005779	120	120	120	0	0	1	-360	360	11.4826	3.0149	-11.4593	-3.6520	0.0000	0.0000	0.0000	0.0000;
	1817	1348	0.001901	0.005868	0.00069	114	114	114	0	0	1	-360	360	-9.5327	-3.4092	9.5343	3.3310	0.0000	0.0000	0.0000	0.0000;
	1146	1817	0.002645	0.008678	0.000895	114	114	114	0	0	1	-360	360	-9.5304	-3.5117	9.5327	3.4112	0.0000	0.0000	0.0000	0.0000;
	1816	1817	8.3e-05	0.000165	1.7e-05	90	90	90	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0020	0.0000	0.0000	0.0000	0.0000;
	1260	1839	0.011735	0.037107	0.004029	114	114	114	0	0	1	-360	360	-4.1041	-0.3386	4.1057	-0.1602	0.0000	0.0000	0.0000	0.0000;
	896	1019	0.00562	0.017355	0.001943	120	120	120	0	0	1	-360	360	-5.2009	-7.6510	5.2049	7.4315	0.0000	0.0000	0.0000	0.0000;
	1878	997	0.001901	0.006198	0.000651	114	114	114	0	0	1	-360	360	-12.2797	-1.5366	12.2821	1.4642	0.0000	0.0000	0.0000	0.0000;
	1597	1878	0.003802	0.011983	0.001283	140	140	140	0	0	1	-360	360	-10.6012	-1.3773	10.6047	1.2307	0.0000	0.0000	0.0000	0.0000;
	930	1597	0.002645	0.008182	0.000946	114	114	114	0	0	1	-360	360	-9.3442	-1.3254	9.3462	1.2150	0.0000	0.0000	0.0000	0.0000;
	1876	1878	8.3e-05	0.000165	1.7e-05	140	140	140	0	0	1	-360	360	-1.6750	-0.3080	1.6750	0.3059	0.0000	0.0000	0.0000	0.0000;
	1597	1596	0.00124	0.003802	0.000445	57	57	57	0	0	1	-360	360	1.2550	0.1623	-1.2550	-0.2170	0.0000	0.0000	0.0000	0.0000;
	1369	1477	0.002397	0.007438	0.000859	114	114	114	0	0	1	-360	360	31.9652	2.5749	-31.9452	-2.6186	0.0000	0.0000	0.0000	0.0000;
	1830	942	0.004132	0.013306	0.001411	114	114	114	0	0	1	-360	360	-5.9234	-0.8161	5.9246	0.6464	0.0000	0.0000	0.0000	0.0000;
	976	1830	0.007107	0.023058	0.002403	140	140	140	0	0	1	-360	360	-3.4117	-0.2966	3.4124	0.0034	0.0000	0.0000	0.0000	0.0000;
	1829	1830	0.000744	0.002397	0.000264	114	114	114	0	0	1	-360	360	-2.5110	-0.8450	2.5110	0.8127	0.0000	0.0000	0.0000	0.0000;
	1858	1009	0.000909	0.00281	0.000319	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0394	0.0000	0.0000	0.0000	0.0000;
	1233	1009	0.003141	0.013306	0.001379	162	162	162	0	0	1	-360	360	-8.6172	-3.0350	8.6193	2.8739	0.0000	0.0000	0.0000	0.0000;
	909	1233	0.000413	0.00124	0.000131	140	140	140	0	0	1	-360	360	-3.3490	-0.7150	3.3490	0.6990	0.0000	0.0000	0.0000	0.0000;
	910	1234	0.000413	0.001322	0.000135	140	140	140	0	0	1	-360	360	-1.6740	-0.4980	1.6740	0.4815	0.0000	0.0000	0.0000	0.0000;
	1204	1008	0.000661	0.002562	0.0003	114	114	114	0	0	1	-360	360	-0.4180	-0.0000	0.4180	-0.0370	0.0000	0.0000	0.0000	0.0000;
	1364	1891	0.012893	0.046446	0.004487	114	114	114	0	0	1	-360	360	-1.2779	0.9878	1.2782	-1.5311	0.0000	0.0000	0.0000	0.0000;
	1433	1525	0.019422	0.062397	0.006585	114	114	114	0	0	1	-360	360	42.7404	15.0368	-42.4113	-14.7699	0.0000	0.0000	0.0000	0.0000;
	1524	1544	0.020827	0.067025	0.007069	140	140	140	0	0	1	-360	360	-23.6810	-9.0654	23.7929	8.5814	0.0000	0.0000	0.0000	0.0000;
	1822	1416	0.001736	0.004959	0.00053	120	120	120	0	0	1	-360	360	1.0738	2.1423	-1.0737	-2.2056	0.0000	0.0000	0.0000	0.0000;
	1116	969	0.007603	0.023141	0.002713	140	140	140	0	0	1	-360	360	-27.3994	-2.5265	27.4464	2.3364	0.0000	0.0000	0.0000	0.0000;
	1648	1288	0.001736	0.005372	0.000634	140	140	140	0	0	1	-360	360	-0.1670	0.0000	0.1670	-0.0783	0.0000	0.0000	0.0000	0.0000;
	1045	1912	0.004132	0.012645	0.001498	140	140	140	0	0	1	-360	360	1.2561	0.0780	-1.2560	-0.2650	0.0000	0.0000	0.0000	0.0000;
	1325	858	0.012479	0.039669	0.004279	140	140	140	0	0	1	-360	360	15.4138	2.0772	-15.3892	-2.5253	0.0000	0.0000	0.0000	0.0000;
	1192	1063	0.003471	0.010661	0.001246	140	140	140	0	0	1	-360	360	-0.2510	-0.0906	0.2510	-0.0613	0.0000	0.0000	0.0000	0.0000;
	1732	1192	0.003636	0.013388	0.001203	140	140	140	0	0	1	-360	360	-0.2510	-0.2380	0.2510	0.0914	0.0000	0.0000	0.0000	0.0000;
	1190	1192	0	0.000826	7e-06	140	140	140	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0009	0.0000	0.0000	0.0000	0.0000;
	1513	1922	0.004711	0.015289	0.001605	140	140	140	0	0	1	-360	360	-13.5426	-0.8699	13.5496	0.6957	0.0000	0.0000	0.0000	0.0000;
	1781	1234	0.004463	0.012893	0.001735	140	140	140	0	0	1	-360	360	-0.9159	-3.1726	0.9163	2.9621	0.0000	0.0000	0.0000	0.0000;
	1364	1482	0.027686	0.071488	0.007393	120	120	120	0	0	1	-360	360	19.2813	2.1981	-19.1949	-2.8675	0.0000	0.0000	0.0000	0.0000;
	857	1508	0.000826	0.002645	0.000305	140	140	140	0	0	1	-360	360	1.5060	0.2226	-1.5060	-0.2600	0.0000	0.0000	0.0000	0.0000;
	858	1509	0.000826	0.002645	0.00031	140	140	140	0	0	1	-360	360	1.7570	0.2650	-1.7570	-0.3030	0.0000	0.0000	0.0000	0.0000;
	1873	1883	0.005537	0.016942	0.00196	140	140	140	0	0	1	-360	360	10.8699	6.8437	-10.8623	-7.0569	0.0000	0.0000	0.0000	0.0000;
	1587	1642	0.006116	0.016612	0.001842	120	120	120	0	0	1	-360	360	-19.5718	-3.3626	19.5915	3.1896	0.0000	0.0000	0.0000	0.0000;
	1504	1544	0.003141	0.009421	0.001118	140	140	140	0	0	1	-360	360	-23.4215	-1.9931	23.4359	1.9018	0.0000	0.0000	0.0000	0.0000;
	859	1586	0.000744	0.002314	0.000254	114	114	114	0	0	1	-360	360	-0.4180	-0.2170	0.4180	0.1858	0.0000	0.0000	0.0000	0.0000;
	860	1587	0.000661	0.002149	0.000237	114	114	114	0	0	1	-360	360	-3.3470	-1.5170	3.3471	1.4881	0.0000	0.0000	0.0000	0.0000;
	1090	1671	0.000331	0.000992	0.000121	114	114	114	0	0	1	-360	360	-0.8370	0.0000	0.8370	-0.0147	0.0000	0.0000	0.0000	0.0000;
	1091	1672	0.000331	0.000992	0.000119	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0145	0.0000	0.0000	0.0000	0.0000;
	1281	857	0.000331	0.000992	0.000114	114	114	114	0	0	1	-360	360	-6.2760	-1.1220	6.2761	1.1084	0.0000	0.0000	0.0000	0.0000;
	1282	858	0.000413	0.001322	0.000157	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0193	0.0000	0.0000	0.0000	0.0000;
	1734	1761	0.004298	0.013306	0.001496	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.1806	0.0000	0.0000	0.0000	0.0000;
	1038	1044	0.000165	0.000579	6.5e-05	114	114	114	0	0	1	-360	360	-0.1670	0.0000	0.1670	-0.0082	0.0000	0.0000	0.0000	0.0000;
	1039	1045	0.000165	0.000579	6.8e-05	114	114	114	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0085	0.0000	0.0000	0.0000	0.0000;
	1031	1008	0.000661	0.002149	0.000215	114	114	114	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0266	0.0000	0.0000	0.0000	0.0000;
	1032	1009	0.000661	0.002066	0.00021	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0260	0.0000	0.0000	0.0000	0.0000;
	1233	997	0.003554	0.011405	0.001183	114	114	114	0	0	1	-360	360	13.6275	1.8159	-13.6221	-1.9442	0.0000	0.0000	0.0000	0.0000;
	1798	1796	0.004132	0.013306	0.001396	114	114	114	0	0	1	-360	360	6.4734	-1.1203	-6.4719	0.9539	0.0000	0.0000	0.0000	0.0000;
	1340	1840	0.001488	0.004959	0.000469	114	114	114	0	0	1	-360	360	-4.6930	-1.2210	4.6933	1.1641	0.0000	0.0000	0.0000	0.0000;
	1926	1383	0.000744	0.002479	0.000283	114	114	114	0	0	1	-360	360	1.3794	1.0068	-1.3794	-1.0415	0.0000	0.0000	0.0000	0.0000;
	1231	1926	0.00438	0.013554	0.001541	140	140	140	0	0	1	-360	360	1.4636	0.9343	-1.4634	-1.1234	0.0000	0.0000	0.0000	0.0000;
	1924	1926	0.000331	0.000909	0.000109	114	114	114	0	0	1	-360	360	-0.0840	-0.1300	0.0840	0.1166	0.0000	0.0000	0.0000	0.0000;
	929	1381	0.004876	0.01719	0.001917	114	114	114	0	0	1	-360	360	0.6057	-1.4550	-0.6056	1.2211	0.0000	0.0000	0.0000	0.0000;
	1992	2104	0.000636	0.004826	0.000469	123	123	123	0	0	1	-360	360	9.5002	-25.0556	-9.4964	25.0272	0.0000	0.0000	0.0000	0.0000;
	2308	2168	0.033471	0.058934	0.005779	78	78	78	0	0	1	-360	360	-6.7644	3.2472	6.7807	-3.9162	0.0000	0.0000	0.0000	0.0000;
	2435	2168	0.029587	0.054711	0.005031	78	78	78	0	0	1	-360	360	8.5225	-4.3654	-8.5007	3.7982	0.0000	0.0000	0.0000	0.0000;
	2435	2169	0.033058	0.058603	0.005571	78	78	78	0	0	1	-360	360	-10.2395	4.3734	10.2743	-4.9850	0.0000	0.0000	0.0000	0.0000;
	2273	2181	0.048016	0.102636	0.013441	55	55	55	0	0	1	-360	360	1.5828	-3.2773	-1.5793	1.6851	0.0000	0.0000	0.0000	0.0000;
	2181	1944	0.013802	0.024207	0.002299	55	55	55	0	0	1	-360	360	0.1193	-2.6281	-0.1186	2.3551	0.0000	0.0000	0.0000	0.0000;
	1996	1989	0.056364	0.105207	0.01021	78	78	78	0	0	1	-360	360	-2.1880	2.5199	2.1949	-3.7320	0.0000	0.0000	0.0000	0.0000;
	2381	2039	0.058934	0.123967	0.011969	78	78	78	0	0	1	-360	360	-16.5054	3.6531	16.6471	-4.8129	0.0000	0.0000	0.0000	0.0000;
	1991	1980	0.021744	0.05	0.005009	76	76	76	0	0	1	-360	360	8.6042	-5.8781	-8.5849	5.3266	0.0000	0.0000	0.0000	0.0000;
	2137	1980	0.034711	0.067438	0.006631	76	76	76	0	0	1	-360	360	-6.2460	4.7014	6.2649	-5.4546	0.0000	0.0000	0.0000	0.0000;
	1990	1939	0.019711	0.06676	0.006609	120	120	120	0	0	1	-360	360	-15.9380	-0.9086	15.9805	0.2698	0.0000	0.0000	0.0000	0.0000;
	2275	2438	0.03843	0.06562	0.006609	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2317	1946	0.02486	0.043479	0.00415	120	120	120	0	0	1	-360	360	-0.8590	0.3936	0.8592	-0.9098	0.0000	0.0000	0.0000	0.0000;
	2396	2317	0.022628	0.03957	0.00378	120	120	120	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.4706	0.0000	0.0000	0.0000	0.0000;
	2283	1982	0.022281	0.075446	0.00747	123	123	123	0	0	1	-360	360	-7.7490	-3.0717	7.7616	2.2281	0.0000	0.0000	0.0000	0.0000;
	2318	1987	0.025207	0.082636	0.00847	123	123	123	0	0	1	-360	360	-7.6175	-1.3527	7.6297	0.3602	0.0000	0.0000	0.0000	0.0000;
	2311	2347	0.020661	0.06686	0.006921	82	82	82	0	0	1	-360	360	-3.3204	1.8130	3.3231	-2.6558	0.0000	0.0000	0.0000	0.0000;
	2127	2175	0.059669	0.104554	0.009951	59	59	59	0	0	1	-360	360	-10.8780	-1.1520	10.9368	0.0506	0.0000	0.0000	0.0000	0.0000;
	1962	2446	0.027107	0.046124	0.00445	78	78	78	0	0	1	-360	360	-14.5582	8.8587	14.6243	-9.2855	0.0000	0.0000	0.0000	0.0000;
	2303	2446	0.033661	0.114017	0.011289	123	123	123	0	0	1	-360	360	-7.8979	1.1810	7.9162	-2.4857	0.0000	0.0000	0.0000	0.0000;
	2426	2194	0.024132	0.078512	0.008199	123	123	123	0	0	1	-360	360	9.7190	-3.8528	-9.6983	2.9127	0.0000	0.0000	0.0000	0.0000;
	1996	1994	0.018347	0.062562	0.00605	123	123	123	0	0	1	-360	360	-13.6174	3.9197	13.6486	-4.5407	0.0000	0.0000	0.0000	0.0000;
	2124	2224	0.024967	0.08457	0.008371	105	105	105	0	0	1	-360	360	17.5354	-3.8150	-17.4693	3.0334	0.0000	0.0000	0.0000	0.0000;
	2382	2306	0.022355	0.075727	0.007497	105	105	105	0	0	1	-360	360	-27.6396	-0.1288	27.7813	-0.2991	0.0000	0.0000	0.0000	0.0000;
	2397	2216	0.016537	0.056008	0.005539	105	105	105	0	0	1	-360	360	-44.7682	-2.2395	45.0367	2.4587	0.0000	0.0000	0.0000	0.0000;
	2363	2397	0.026793	0.090719	0.008981	105	105	105	0	0	1	-360	360	-40.5355	1.0401	40.8979	-0.9150	0.0000	0.0000	0.0000	0.0000;
	2363	2011	0.014446	0.048942	0.00484	105	105	105	0	0	1	-360	360	38.8165	-2.0771	-38.6373	2.0977	0.0000	0.0000	0.0000	0.0000;
	2069	2397	0.020421	0.036157	0.003451	105	105	105	0	0	1	-360	360	-3.8660	-3.5730	3.8703	3.1545	0.0000	0.0000	0.0000	0.0000;
	2328	2205	0.032041	0.108521	0.01074	105	105	105	0	0	1	-360	360	-10.2256	0.7686	10.2535	-1.9931	0.0000	0.0000	0.0000	0.0000;
	2330	2244	0.016124	0.05281	0.005411	114	114	114	0	0	1	-360	360	-15.6158	0.3181	15.6482	-0.8695	0.0000	0.0000	0.0000	0.0000;
	2047	2287	0.016603	0.056231	0.005571	10	10	10	0	0	1	-360	360	2.5819	-0.0601	-2.5810	-0.6280	0.0000	0.0000	0.0000	0.0000;
	2218	2132	0.104132	0.168512	0.01897	78	78	78	0	0	1	-360	360	1.2912	-2.1201	-1.2890	-0.1920	0.0000	0.0000	0.0000	0.0000;
	2217	2395	0.033058	0.049587	0.00605	76	76	76	0	0	1	-360	360	3.1515	1.3498	-3.1480	-2.0818	0.0000	0.0000	0.0000	0.0000;
	2395	2078	0.1	0.165289	0.01822	76	76	76	0	0	1	-360	360	-4.7578	-1.3273	4.7765	-0.8678	0.0000	0.0000	0.0000	0.0000;
	2149	2395	0.015703	0.046281	0.005009	76	76	76	0	0	1	-360	360	-7.8960	-3.9880	7.9058	3.4091	0.0000	0.0000	0.0000	0.0000;
	2204	1965	0.033802	0.055372	0.005951	67	67	67	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2204	2051	0.015703	0.046281	0.005009	69	69	69	0	0	1	-360	360	4.0844	0.7513	-4.0820	-1.3477	0.0000	0.0000	0.0000	0.0000;
	2133	2077	0.028934	0.047107	0.0053	78	78	78	0	0	1	-360	360	-4.4740	-2.0470	4.4794	1.4017	0.0000	0.0000	0.0000	0.0000;
	2392	2387	0.000554	0.001818	0.026831	118	118	118	0	0	1	-360	360	-5.4110	-4.1950	5.4112	0.9147	0.0000	0.0000	0.0000	0.0000;
	2324	1966	0.011983	0.040562	0.00401	123	123	123	0	0	1	-360	360	-3.8048	2.8195	3.8071	-3.3063	0.0000	0.0000	0.0000	0.0000;
	2270	2379	0.002661	0.009017	0.000891	123	123	123	0	0	1	-360	360	-2.2320	-1.0970	2.2321	0.9876	0.0000	0.0000	0.0000	0.0000;
	2271	2380	0.002661	0.009017	0.000891	123	123	123	0	0	1	-360	360	-2.4910	-1.6630	2.4912	1.5544	0.0000	0.0000	0.0000	0.0000;
	2377	2078	0.003314	0.005793	0.00061	78	78	78	0	0	1	-360	360	-5.1540	-1.0185	5.1547	0.9450	0.0000	0.0000	0.0000	0.0000;
	2388	2377	0.009917	0.022314	0.00242	78	78	78	0	0	1	-360	360	-3.4340	-0.4840	3.4350	0.1895	0.0000	0.0000	0.0000	0.0000;
	2379	2077	0.02562	0.043802	0.00455	78	78	78	0	0	1	-360	360	-19.4341	7.4698	19.5250	-7.8761	0.0000	0.0000	0.0000	0.0000;
	2379	1966	0.004132	0.006612	0.000731	78	78	78	0	0	1	-360	360	14.7110	-8.4575	-14.7013	8.3828	0.0000	0.0000	0.0000	0.0000;
	2387	2380	0.018182	0.035537	0.003901	78	78	78	0	0	1	-360	360	-8.8452	-1.0347	8.8569	0.5799	0.0000	0.0000	0.0000	0.0000;
	2380	1965	0.004132	0.006612	0.000731	78	78	78	0	0	1	-360	360	-14.8701	-3.0133	14.8778	2.9360	0.0000	0.0000	0.0000	0.0000;
	2415	2214	0.008769	0.029686	0.00294	123	123	123	0	0	1	-360	360	-2.4665	-4.7198	2.4684	4.3625	0.0000	0.0000	0.0000	0.0000;
	2324	2415	0.004446	0.01505	0.001491	123	123	123	0	0	1	-360	360	1.8288	-3.4135	-1.8283	3.2311	0.0000	0.0000	0.0000	0.0000;
	2386	2415	0.004967	0.016827	0.00167	123	123	123	0	0	1	-360	360	-4.2940	-1.6920	4.2948	1.4887	0.0000	0.0000	0.0000	0.0000;
	2266	1965	0.015703	0.047934	0.00515	123	123	123	0	0	1	-360	360	9.9651	3.9006	-9.9503	-4.4895	0.0000	0.0000	0.0000	0.0000;
	2266	2213	0.007438	0.023967	0.00257	123	123	123	0	0	1	-360	360	-15.2391	-7.1046	15.2560	6.8408	0.0000	0.0000	0.0000	0.0000;
	2393	2355	0.015703	0.027273	0.00264	123	123	123	0	0	1	-360	360	-18.2648	5.0928	18.3107	-5.3400	0.0000	0.0000	0.0000	0.0000;
	2385	2213	0.007438	0.02562	0.002781	123	123	123	0	0	1	-360	360	7.0799	-9.2494	-7.0719	8.9323	0.0000	0.0000	0.0000	0.0000;
	2385	2369	0.001653	0.004132	0.000409	123	123	123	0	0	1	-360	360	-10.8579	6.8434	10.8601	-6.8885	0.0000	0.0000	0.0000	0.0000;
	2393	2369	0.009091	0.028099	0.003071	123	123	123	0	0	1	-360	360	13.9718	-5.8208	-13.9551	5.4925	0.0000	0.0000	0.0000	0.0000;
	2370	2214	0.009091	0.029752	0.00319	123	123	123	0	0	1	-360	360	-13.1729	-8.1982	13.1905	7.8617	0.0000	0.0000	0.0000	0.0000;
	2370	2356	0.009091	0.028099	0.003071	123	123	123	0	0	1	-360	360	9.4809	5.7552	-9.4717	-6.1040	0.0000	0.0000	0.0000	0.0000;
	2213	2201	0.023141	0.058678	0.00574	102	102	102	0	0	1	-360	360	6.7124	0.1478	-6.7039	-0.8377	0.0000	0.0000	0.0000	0.0000;
	2334	2214	0.013719	0.044463	0.00439	123	123	123	0	0	1	-360	360	-19.3128	0.1745	19.3543	-0.5826	0.0000	0.0000	0.0000	0.0000;
	2214	2205	0.022314	0.071818	0.00702	123	123	123	0	0	1	-360	360	13.8715	1.3765	-13.8362	-2.1294	0.0000	0.0000	0.0000	0.0000;
	2416	2214	0.024893	0.084322	0.008349	120	120	120	0	0	1	-360	360	-6.4212	1.1450	6.4301	-2.1489	0.0000	0.0000	0.0000	0.0000;
	2367	2416	0.01362	0.046124	0.004569	120	120	120	0	0	1	-360	360	-6.4166	0.5952	6.4212	-1.1450	0.0000	0.0000	0.0000	0.0000;
	2281	2213	0.029496	0.099901	0.009891	123	123	123	0	0	1	-360	360	-28.8168	-10.3905	29.0438	9.9504	0.0000	0.0000	0.0000	0.0000;
	2051	2177	0.007521	0.012562	0.0013	57	57	57	0	0	1	-360	360	0.8170	-0.0723	-0.8170	-0.0840	0.0000	0.0000	0.0000	0.0000;
	2334	2175	0.062149	0.105041	0.01058	78	78	78	0	0	1	-360	360	15.6138	-2.1305	-15.4898	1.0434	0.0000	0.0000	0.0000	0.0000;
	2438	2201	0.039669	0.069421	0.00666	78	78	78	0	0	1	-360	360	-3.0060	-0.1770	3.0089	-0.6413	0.0000	0.0000	0.0000	0.0000;
	2391	2355	0.004959	0.015703	0.000801	78	78	78	0	0	1	-360	360	-16.7675	2.3205	16.7789	-2.3834	0.0000	0.0000	0.0000	0.0000;
	2406	1966	0.01438	0.02405	0.00249	78	78	78	0	0	1	-360	360	-10.8775	4.7974	10.8942	-5.0764	0.0000	0.0000	0.0000	0.0000;
	2205	2406	0.03876	0.064628	0.006679	78	78	78	0	0	1	-360	360	-10.1403	3.8516	10.1785	-4.6102	0.0000	0.0000	0.0000	0.0000;
	2406	2176	0.011653	0.02124	0.00221	78	78	78	0	0	1	-360	360	0.6990	-0.1872	-0.6990	-0.0850	0.0000	0.0000	0.0000	0.0000;
	2078	2045	0.01157	0.019826	0.001941	78	78	78	0	0	1	-360	360	3.5308	-0.4891	-3.5296	0.2530	0.0000	0.0000	0.0000	0.0000;
	2045	2356	0.007942	0.015909	0.001529	78	78	78	0	0	1	-360	360	1.7256	-1.1390	-1.7254	0.9520	0.0000	0.0000	0.0000	0.0000;
	2376	2077	0.003314	0.005793	0.000549	78	78	78	0	0	1	-360	360	9.0094	-4.6470	-9.0067	4.5838	0.0000	0.0000	0.0000	0.0000;
	2376	2226	0.009091	0.017364	0.00165	78	78	78	0	0	1	-360	360	-11.2444	2.9740	11.2544	-3.1590	0.0000	0.0000	0.0000	0.0000;
	2390	2078	0.01157	0.018934	0.002011	78	78	78	0	0	1	-360	360	-10.1205	-1.8384	10.1305	1.6083	0.0000	0.0000	0.0000	0.0000;
	2391	2077	0.01157	0.018934	0.001909	78	78	78	0	0	1	-360	360	14.3635	-2.9460	-14.3434	2.7425	0.0000	0.0000	0.0000	0.0000;
	2391	2044	0.000826	0.002479	0.000271	78	78	78	0	0	1	-360	360	0.6010	0.2564	-0.6010	-0.2900	0.0000	0.0000	0.0000	0.0000;
	2375	2355	0.015231	0.048397	0.00476	123	123	123	0	0	1	-360	360	-3.6930	-2.3320	3.6952	1.7497	0.0000	0.0000	0.0000	0.0000;
	2372	2356	0.01157	0.036364	0.003991	102	102	102	0	0	1	-360	360	-7.5847	-3.4214	7.5911	2.9530	0.0000	0.0000	0.0000	0.0000;
	2371	2374	0.007066	0.02395	0.002369	123	123	123	0	0	1	-360	360	3.9501	1.6413	-3.9490	-1.9270	0.0000	0.0000	0.0000	0.0000;
	2372	2310	0.02562	0.082636	0.00854	123	123	123	0	0	1	-360	360	3.0969	-0.6282	-3.0949	-0.4085	0.0000	0.0000	0.0000	0.0000;
	2310	2265	0.021488	0.069421	0.00711	120	120	120	0	0	1	-360	360	-3.0951	-0.0295	3.0968	-0.8332	0.0000	0.0000	0.0000	0.0000;
	2355	2225	0.009917	0.017364	0.001721	78	78	78	0	0	1	-360	360	14.7012	-2.2998	-14.6835	2.1177	0.0000	0.0000	0.0000	0.0000;
	2390	2371	0.019826	0.033802	0.003291	78	78	78	0	0	1	-360	360	5.0545	-0.5816	-5.0504	0.1862	0.0000	0.0000	0.0000	0.0000;
	2078	1965	0.025612	0.044149	0.004293	78	78	78	0	0	1	-360	360	-6.2604	1.7851	6.2694	-2.2965	0.0000	0.0000	0.0000	0.0000;
	1940	2078	0.005	0.008793	0.00084	78	78	78	0	0	1	-360	360	-9.5500	-1.8682	9.5539	1.7720	0.0000	0.0000	0.0000	0.0000;
	2447	2301	0.028099	0.04876	0.00477	78	78	78	0	0	1	-360	360	-3.0032	-2.5459	3.0065	1.9648	0.0000	0.0000	0.0000	0.0000;
	1940	2447	0.023	0.040273	0.003841	78	78	78	0	0	1	-360	360	-1.5420	-2.3128	1.5432	1.8439	0.0000	0.0000	0.0000	0.0000;
	2347	2205	0.025463	0.084959	0.00635	123	123	123	0	0	1	-360	360	-5.9851	1.1978	5.9931	-1.9521	0.0000	0.0000	0.0000	0.0000;
	2028	2146	0.037711	0.127744	0.012649	123	123	123	0	0	1	-360	360	1.4494	-8.2837	-1.4308	6.8241	0.0000	0.0000	0.0000	0.0000;
	2224	2028	0.028959	0.100876	0.00999	123	123	123	0	0	1	-360	360	14.7213	-2.1334	-14.6684	1.1217	0.0000	0.0000	0.0000	0.0000;
	2247	2239	0.080661	0.142066	0.013479	120	120	120	0	0	1	-360	360	-11.6964	1.2805	11.7907	-2.7516	0.0000	0.0000	0.0000	0.0000;
	2373	1996	0.041157	0.104463	0.01043	102	102	102	0	0	1	-360	360	-11.8858	4.2796	11.9425	-5.3896	0.0000	0.0000	0.0000	0.0000;
	2439	2373	0.058083	0.103752	0.00991	78	78	78	0	0	1	-360	360	-19.4728	2.7437	19.6639	-3.5855	0.0000	0.0000	0.0000	0.0000;
	2382	2189	0.025041	0.042893	0.004281	120	120	120	0	0	1	-360	360	8.5924	-3.4743	-8.5749	2.9887	0.0000	0.0000	0.0000	0.0000;
	2333	2305	0.016612	0.053802	0.005571	91	91	91	0	0	1	-360	360	11.1777	-2.6992	-11.1597	2.0863	0.0000	0.0000	0.0000	0.0000;
	1985	2336	0.015703	0.05157	0.00528	123	123	123	0	0	1	-360	360	10.3417	-2.6802	-10.3268	2.1044	0.0000	0.0000	0.0000	0.0000;
	2234	2336	0.024793	0.081322	0.008339	120	120	120	0	0	1	-360	360	-5.5991	0.2546	5.6058	-1.2184	0.0000	0.0000	0.0000	0.0000;
	2405	2146	0.038909	0.068058	0.006493	78	78	78	0	0	1	-360	360	9.9772	-5.5244	-9.9368	4.8074	0.0000	0.0000	0.0000	0.0000;
	2405	2381	0.001025	0.003471	0.000344	78	78	78	0	0	1	-360	360	-12.9838	5.0740	12.9854	-5.1101	0.0000	0.0000	0.0000	0.0000;
	2405	2014	0.032372	0.058876	0.005827	78	78	78	0	0	1	-360	360	3.0066	0.4504	-3.0040	-1.1520	0.0000	0.0000	0.0000	0.0000;
	2184	2003	0.002917	0.009876	0.00098	102	102	102	0	0	1	-360	360	-4.0350	-4.3390	4.0358	4.2229	0.0000	0.0000	0.0000	0.0000;
	2002	1984	0.006033	0.017851	0.00183	102	102	102	0	0	1	-360	360	39.2033	-18.0335	-39.1112	18.0832	0.0000	0.0000	0.0000	0.0000;
	2350	2013	0.042066	0.141322	0.013939	120	120	120	0	0	1	-360	360	-21.7872	3.0393	21.9594	-4.1343	0.0000	0.0000	0.0000	0.0000;
	2350	1968	0.029917	0.101364	0.010031	120	120	120	0	0	1	-360	360	24.0648	-3.7609	-23.9175	3.0637	0.0000	0.0000	0.0000	0.0000;
	2235	1968	0.011653	0.03957	0.00392	91	91	91	0	0	1	-360	360	-16.7653	2.2707	16.7935	-2.6407	0.0000	0.0000	0.0000	0.0000;
	1950	2228	0.003719	0.012479	0.001159	102	102	102	0	0	1	-360	360	-3.4901	-4.3199	3.4910	4.1828	0.0000	0.0000	0.0000	0.0000;
	1983	1974	0.005372	0.015124	0.001529	102	102	102	0	0	1	-360	360	21.9795	5.7431	-21.9567	-5.8650	0.0000	0.0000	0.0000	0.0000;
	2353	2262	0.004132	0.01405	0.001379	123	123	123	0	0	1	-360	360	7.9205	-10.0102	-7.9150	9.8613	0.0000	0.0000	0.0000	0.0000;
	2003	1974	0.000744	0.002314	0.00024	123	123	123	0	0	1	-360	360	-21.2676	-8.3042	21.2707	8.2850	0.0000	0.0000	0.0000	0.0000;
	2428	2267	0.007107	0.019422	0.002011	102	102	102	0	0	1	-360	360	-20.4513	-5.3098	20.4773	5.1354	0.0000	0.0000	0.0000	0.0000;
	1933	2002	0.004992	0.016909	0.001469	123	123	123	0	0	1	-360	360	0.1883	-1.0521	-0.1883	0.8735	0.0000	0.0000	0.0000	0.0000;
	2409	2234	0.019174	0.063876	0.00598	123	123	123	0	0	1	-360	360	-4.8081	0.7752	4.8120	-1.4683	0.0000	0.0000	0.0000	0.0000;
	2409	2260	0.003802	0.012636	0.001191	123	123	123	0	0	1	-360	360	8.5684	2.5245	-8.5658	-2.6565	0.0000	0.0000	0.0000	0.0000;
	2409	2232	0.001157	0.003802	0.00038	123	123	123	0	0	1	-360	360	-3.7603	-3.2998	3.7606	3.2557	0.0000	0.0000	0.0000	0.0000;
	2437	2057	0.014554	0.053141	0.00523	123	123	123	0	0	1	-360	360	2.0529	-0.3780	-2.0524	-0.2353	0.0000	0.0000	0.0000	0.0000;
	2174	2389	0.020083	0.068182	0.00674	10	10	10	0	0	1	-360	360	-0.5150	-0.1200	0.5151	-0.7099	0.0000	0.0000	0.0000	0.0000;
	2203	2057	0.017107	0.057686	0.00567	123	123	123	0	0	1	-360	360	-1.0840	0.9810	1.0844	-1.6467	0.0000	0.0000	0.0000	0.0000;
	2304	2146	0.031959	0.055893	0.005329	78	78	78	0	0	1	-360	360	-8.4548	-0.8152	8.4738	0.2038	0.0000	0.0000	0.0000	0.0000;
	2304	2068	0.018479	0.032322	0.003081	78	78	78	0	0	1	-360	360	4.8488	-1.4898	-4.8449	1.1249	0.0000	0.0000	0.0000	0.0000;
	2068	2046	0.029008	0.051653	0.004891	78	78	78	0	0	1	-360	360	-8.9907	-0.5888	9.0102	0.0323	0.0000	0.0000	0.0000	0.0000;
	2180	2046	0.016612	0.029496	0.00288	78	78	78	0	0	1	-360	360	13.0696	2.6219	-13.0452	-2.9283	0.0000	0.0000	0.0000	0.0000;
	2260	2229	0.007934	0.026777	0.00264	123	123	123	0	0	1	-360	360	-0.3612	-0.2555	0.3612	-0.0559	0.0000	0.0000	0.0000	0.0000;
	2232	2229	0.008636	0.017298	0.00166	78	78	78	0	0	1	-360	360	6.4003	1.1374	-6.3972	-1.3271	0.0000	0.0000	0.0000	0.0000;
	2200	1943	0.037603	0.067603	0.00651	78	78	78	0	0	1	-360	360	-16.1540	1.8588	16.2368	-2.4991	0.0000	0.0000	0.0000	0.0000;
	2233	2073	0.014132	0.046281	0.004751	123	123	123	0	0	1	-360	360	18.7322	0.1133	-18.6914	-0.5549	0.0000	0.0000	0.0000	0.0000;
	2206	2021	0.01	0.034793	0.00317	120	120	120	0	0	1	-360	360	-0.1542	-1.4969	0.1544	1.1090	0.0000	0.0000	0.0000	0.0000;
	2428	1933	0.006099	0.020653	0.00204	123	123	123	0	0	1	-360	360	7.7453	0.1178	-7.7423	-0.3559	0.0000	0.0000	0.0000	0.0000;
	2152	1953	0.022132	0.07514	0.00742	91	91	91	0	0	1	-360	360	10.0920	4.0078	-10.0697	-4.8261	0.0000	0.0000	0.0000	0.0000;
	2274	1953	0.046777	0.057934	0.00462	91	91	91	0	0	1	-360	360	-6.2720	-3.9251	6.2927	3.3991	0.0000	0.0000	0.0000	0.0000;
	2309	2307	0.053876	0.094298	0.008981	78	78	78	0	0	1	-360	360	0.6871	-2.2662	-0.6856	1.2054	0.0000	0.0000	0.0000	0.0000;
	2194	2021	0.041397	0.083554	0.00786	78	78	78	0	0	1	-360	360	5.6583	-1.0807	-5.6474	0.1380	0.0000	0.0000	0.0000	0.0000;
	2256	2227	0.009678	0.032793	0.00325	123	123	123	0	0	1	-360	360	-12.9078	-2.1602	12.9215	1.8129	0.0000	0.0000	0.0000	0.0000;
	1984	1942	0.011653	0.034628	0.00356	78	78	78	0	0	1	-360	360	19.2780	-4.2337	-19.2410	3.9103	0.0000	0.0000	0.0000	0.0000;
	2250	1984	0.022041	0.074669	0.007391	91	91	91	0	0	1	-360	360	-3.8796	-4.0285	3.8847	3.1476	0.0000	0.0000	0.0000	0.0000;
	2004	2250	0.012141	0.041124	0.00407	91	91	91	0	0	1	-360	360	-1.6453	-4.7430	1.6476	4.2585	0.0000	0.0000	0.0000	0.0000;
	2319	2189	0.040331	0.068934	0.006921	91	91	91	0	0	1	-360	360	-4.0969	4.5985	4.1109	-5.4087	0.0000	0.0000	0.0000	0.0000;
	2373	2247	0.033636	0.085446	0.008741	91	91	91	0	0	1	-360	360	-9.8480	-0.0474	9.8752	-0.9368	0.0000	0.0000	0.0000	0.0000;
	2411	2234	0.016686	0.035289	0.00341	78	78	78	0	0	1	-360	360	-9.3223	-0.0761	9.3346	-0.3002	0.0000	0.0000	0.0000	0.0000;
	2411	2366	0.057603	0.122149	0.01179	78	78	78	0	0	1	-360	360	9.3223	0.0761	-9.2796	-1.3672	0.0000	0.0000	0.0000	0.0000;
	2411	2232	8e-06	8.3e-05	0	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2373	2305	0.035289	0.060331	0.00605	78	78	78	0	0	1	-360	360	-3.9391	0.1643	3.9437	-0.8843	0.0000	0.0000	0.0000	0.0000;
	2035	2146	0.068083	0.124397	0.01294	78	78	78	0	0	1	-360	360	-11.4228	-4.7058	11.5065	3.3061	0.0000	0.0000	0.0000	0.0000;
	2307	2035	0.004298	0.010281	0.00143	78	78	78	0	0	1	-360	360	-8.6714	-4.3174	8.6748	4.1558	0.0000	0.0000	0.0000	0.0000;
	2238	2073	0.016124	0.05405	0.005319	120	120	120	0	0	1	-360	360	11.7900	-0.6292	-11.7715	0.0476	0.0000	0.0000	0.0000	0.0000;
	2382	2165	0.039669	0.069339	0.006631	78	78	78	0	0	1	-360	360	11.8362	2.6971	-11.7869	-3.4054	0.0000	0.0000	0.0000	0.0000;
	2293	2238	0.023967	0.042231	0.004141	78	78	78	0	0	1	-360	360	2.8237	-7.0257	-2.8130	6.5437	0.0000	0.0000	0.0000	0.0000;
	2293	2068	0.046446	0.081744	0.00801	78	78	78	0	0	1	-360	360	-6.3437	4.1997	6.3677	-5.1242	0.0000	0.0000	0.0000	0.0000;
	1961	2239	0.02276	0.077099	0.00763	120	120	120	0	0	1	-360	360	-6.5444	2.2810	6.5538	-3.1815	0.0000	0.0000	0.0000	0.0000;
	2319	2186	0.01124	0.038182	0.00378	91	91	91	0	0	1	-360	360	11.2049	-0.2767	-11.1932	-0.1394	0.0000	0.0000	0.0000	0.0000;
	2308	2247	0.023471	0.057851	0.005929	91	91	91	0	0	1	-360	360	2.3004	-2.1152	-2.2988	1.4033	0.0000	0.0000	0.0000	0.0000;
	2235	2232	0.009826	0.033223	0.003279	123	123	123	0	0	1	-360	360	15.8500	3.8076	-15.8279	-4.1211	0.0000	0.0000	0.0000	0.0000;
	2013	2004	0.013934	0.047207	0.004671	91	91	91	0	0	1	-360	360	1.6214	-3.8104	-1.6197	3.2530	0.0000	0.0000	0.0000	0.0000;
	2012	2011	0.006876	0.023281	0.002299	120	120	120	0	0	1	-360	360	-34.5334	3.5315	34.6023	-3.5757	0.0000	0.0000	0.0000	0.0000;
	2309	2165	0.034298	0.06	0.00574	78	78	78	0	0	1	-360	360	-9.2711	-2.0248	9.2969	1.3884	0.0000	0.0000	0.0000	0.0000;
	2152	2146	0.003893	0.013223	0.0013	91	91	91	0	0	1	-360	360	-15.7590	-4.6518	15.7676	4.5238	0.0000	0.0000	0.0000	0.0000;
	2437	2235	0.060496	0.118182	0.011589	78	78	78	0	0	1	-360	360	-6.6959	-1.6260	6.7195	0.3024	0.0000	0.0000	0.0000	0.0000;
	2292	2073	0.006149	0.020827	0.002062	91	91	91	0	0	1	-360	360	-21.5956	3.0869	21.6199	-3.2537	0.0000	0.0000	0.0000	0.0000;
	2333	2292	0.007587	0.025686	0.002543	91	91	91	0	0	1	-360	360	-21.5657	2.8812	21.5956	-3.0869	0.0000	0.0000	0.0000	0.0000;
	2251	2002	0.00519	0.014132	0.00143	102	102	102	0	0	1	-360	360	-40.7252	4.4821	40.7970	-4.4605	0.0000	0.0000	0.0000	0.0000;
	2366	2173	0.067438	0.118017	0.01126	10	10	10	0	0	1	-360	360	3.6136	-0.7128	-3.6060	-0.5840	0.0000	0.0000	0.0000	0.0000;
	1961	2206	0.014521	0.049174	0.004869	78	78	78	0	0	1	-360	360	2.3384	-3.2030	-2.3368	2.6129	0.0000	0.0000	0.0000	0.0000;
	2251	2185	0.001818	0.004554	0.00046	91	91	91	0	0	1	-360	360	1.8031	0.5203	-1.8030	-0.5760	0.0000	0.0000	0.0000	0.0000;
	2227	2003	0.002587	0.00876	0.000871	123	123	123	0	0	1	-360	360	-14.6385	-2.7509	14.6432	2.6611	0.0000	0.0000	0.0000	0.0000;
	2233	2257	0.001901	0.006033	0.00061	123	123	123	0	0	1	-360	360	-5.9102	3.6096	5.9109	-3.6813	0.0000	0.0000	0.0000	0.0000;
	2228	2126	0.001744	0.004793	0.000479	102	102	102	0	0	1	-360	360	-7.6170	-6.8368	7.6185	6.7829	0.0000	0.0000	0.0000	0.0000;
	2233	1983	0.00686	0.021984	0.00228	123	123	123	0	0	1	-360	360	-19.2600	-5.2549	19.2825	5.0495	0.0000	0.0000	0.0000	0.0000;
	2280	2200	0.017017	0.055124	0.005711	123	123	123	0	0	1	-360	360	-15.0917	0.1338	15.1240	-0.7178	0.0000	0.0000	0.0000	0.0000;
	2267	2258	0.010281	0.021636	0.002101	78	78	78	0	0	1	-360	360	-24.5123	-6.6334	24.5664	6.4895	0.0000	0.0000	0.0000	0.0000;
	2319	2002	0.011256	0.038141	0.00378	91	91	91	0	0	1	-360	360	-17.0660	-8.1368	17.0990	7.7904	0.0000	0.0000	0.0000	0.0000;
	2412	2256	0.003033	0.010289	0.001019	102	102	102	0	0	1	-360	360	-3.1205	1.5406	3.1208	-1.6628	0.0000	0.0000	0.0000	0.0000;
	1950	2412	0.006174	0.017364	0.00174	102	102	102	0	0	1	-360	360	-3.1199	1.3319	3.1205	-1.5406	0.0000	0.0000	0.0000	0.0000;
	2428	2412	4.1e-05	0.000141	1e-05	102	102	102	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2239	2006	0.007314	0.012793	0.00122	78	78	78	0	0	1	-360	360	2.7505	0.5429	-2.7500	-0.6910	0.0000	0.0000	0.0000	0.0000;
	2238	2261	0.009587	0.024744	0.00251	102	102	102	0	0	1	-360	360	3.0918	0.2740	-3.0910	-0.5760	0.0000	0.0000	0.0000	0.0000;
	2239	2262	0.009587	0.024744	0.00251	102	102	102	0	0	1	-360	360	-4.2117	11.0826	4.2230	-11.3593	0.0000	0.0000	0.0000	0.0000;
	2156	2238	0.013438	0.023826	0.00227	78	78	78	0	0	1	-360	360	-0.4068	-5.4247	0.4099	5.1554	0.0000	0.0000	0.0000	0.0000;
	2259	2156	0.006983	0.012793	0.00098	78	78	78	0	0	1	-360	360	-0.0620	-5.6548	0.0638	5.5397	0.0000	0.0000	0.0000	0.0000;
	2239	2053	0.005744	0.019438	0.001919	123	123	123	0	0	1	-360	360	17.6902	10.6168	-17.6701	-10.7824	0.0000	0.0000	0.0000	0.0000;
	2257	2187	0.003388	0.010992	0.00114	123	123	123	0	0	1	-360	360	1.6178	-0.0866	-1.6177	-0.0515	0.0000	0.0000	0.0000	0.0000;
	2187	2003	0.00281	0.009091	0.000939	123	123	123	0	0	1	-360	360	-2.5883	-1.5335	2.5885	1.4202	0.0000	0.0000	0.0000	0.0000;
	2259	2186	0.014752	0.049984	0.004949	78	78	78	0	0	1	-360	360	-5.1782	4.4712	5.1842	-5.0476	0.0000	0.0000	0.0000	0.0000;
	2353	2257	0.00405	0.013388	0.001379	123	123	123	0	0	1	-360	360	13.8042	-2.4687	-13.7977	2.3229	0.0000	0.0000	0.0000	0.0000;
	2439	1985	0.010314	0.017967	0.001711	78	78	78	0	0	1	-360	360	14.6538	-2.1677	-14.6347	1.9982	0.0000	0.0000	0.0000	0.0000;
	2350	2280	0.039504	0.072314	0.007279	78	78	78	0	0	1	-360	360	-8.5446	-0.4175	8.5687	-0.4118	0.0000	0.0000	0.0000	0.0000;
	2251	1981	0.001653	0.005372	0.000549	123	123	123	0	0	1	-360	360	32.9121	-9.6724	-32.8961	9.6578	0.0000	0.0000	0.0000	0.0000;
	2353	1981	0.001818	0.00595	0.000629	123	123	123	0	0	1	-360	360	-26.5317	11.0940	26.5441	-11.1298	0.0000	0.0000	0.0000	0.0000;
	2126	2053	0.00405	0.013314	0.001379	123	123	123	0	0	1	-360	360	-11.9965	-9.1919	12.0041	9.0494	0.0000	0.0000	0.0000	0.0000;
	2259	2007	0.020347	0.035578	0.0034	78	78	78	0	0	1	-360	360	2.3211	0.9746	-2.3200	-1.3830	0.0000	0.0000	0.0000	0.0000;
	2258	2180	0.022719	0.039727	0.00379	78	78	78	0	0	1	-360	360	18.4625	5.9324	-18.3926	-6.2739	0.0000	0.0000	0.0000	0.0000;
	2436	1930	0.001289	0.003744	0.00038	76	76	76	0	0	1	-360	360	-25.9579	0.3183	25.9649	-0.3453	0.0000	0.0000	0.0000	0.0000;
	1967	2436	0.028331	0.073488	0.007451	62	62	62	0	0	1	-360	360	-20.9564	3.1236	21.0599	-3.7793	0.0000	0.0000	0.0000	0.0000;
	2064	1967	0.029669	0.076612	0.007771	62	62	62	0	0	1	-360	360	-19.6481	2.4943	19.7434	-3.2066	0.0000	0.0000	0.0000	0.0000;
	2328	2074	0.028256	0.095702	0.00947	105	105	105	0	0	1	-360	360	7.9056	-1.0506	-7.8912	-0.0599	0.0000	0.0000	0.0000	0.0000;
	2212	2020	0.017289	0.058554	0.005801	105	105	105	0	0	1	-360	360	-6.4621	-2.2544	6.4685	1.5658	0.0000	0.0000	0.0000	0.0000;
	2399	2065	0.007017	0.017521	0.000779	82	82	82	0	0	1	-360	360	4.6309	2.0030	-4.6294	-2.0953	0.0000	0.0000	0.0000	0.0000;
	2399	2210	0.023876	0.067107	0.00621	82	82	82	0	0	1	-360	360	-4.6309	-1.9044	4.6355	1.1512	0.0000	0.0000	0.0000	0.0000;
	2399	2139	0.003554	0.009587	0.000801	82	82	82	0	0	1	-360	360	0.0000	-0.0987	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2020	2211	0.027372	0.092132	0.009121	105	105	105	0	0	1	-360	360	-9.3075	-2.5408	9.3277	1.4858	0.0000	0.0000	0.0000	0.0000;
	2212	2074	0.017917	0.061438	0.006009	105	105	105	0	0	1	-360	360	-1.3629	-0.2596	1.3632	-0.4741	0.0000	0.0000	0.0000	0.0000;
	2211	2127	0.037934	0.097521	0.00999	62	62	62	0	0	1	-360	360	22.4870	7.5073	-22.3115	-8.2743	0.0000	0.0000	0.0000	0.0000;
	2196	2091	0.013223	0.032893	0.00347	76	76	76	0	0	1	-360	360	13.4504	-10.5919	-13.4197	10.2358	0.0000	0.0000	0.0000	0.0000;
	2335	1929	0.005041	0.014132	0.00145	62	62	62	0	0	1	-360	360	-25.0023	5.0973	25.0288	-5.2035	0.0000	0.0000	0.0000	0.0000;
	2157	2434	0.037438	0.096529	0.009891	62	62	62	0	0	1	-360	360	-6.7055	-4.1223	6.7231	2.9555	0.0000	0.0000	0.0000	0.0000;
	2157	2056	0.020174	0.049587	0.00508	62	62	62	0	0	1	-360	360	6.1905	3.8343	-6.1813	-4.4296	0.0000	0.0000	0.0000	0.0000;
	2086	2055	0.015289	0.049669	0.005179	91	91	91	0	0	1	-360	360	-5.4265	-3.2396	5.4313	2.6290	0.0000	0.0000	0.0000	0.0000;
	2092	1972	0.033314	0.079818	0.007831	62	62	62	0	0	1	-360	360	34.3077	2.2236	-33.9928	-2.4400	0.0000	0.0000	0.0000	0.0000;
	2398	2215	0.038141	0.066711	0.00636	48	48	48	0	0	1	-360	360	-6.6524	-4.6855	6.6716	3.9247	0.0000	0.0000	0.0000	0.0000;
	2070	2398	0.000686	0.002347	0.00023	48	48	48	0	0	1	-360	360	-6.6520	-4.7140	6.6524	4.6867	0.0000	0.0000	0.0000	0.0000;
	2089	2398	8.3e-05	0.000141	1e-05	48	48	48	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0012	0.0000	0.0000	0.0000	0.0000;
	2054	2216	0.013636	0.023802	0.00227	69	69	69	0	0	1	-360	360	-17.2930	-11.6400	17.3403	11.4389	0.0000	0.0000	0.0000	0.0000;
	2067	2216	0.008678	0.015124	0.00145	69	69	69	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.1818	0.0000	0.0000	0.0000	0.0000;
	2216	2092	0.005372	0.015446	0.00181	103	103	103	0	0	1	-360	360	98.7632	-29.2375	-98.3091	30.3161	1.6552	0.0000	0.0000	0.0000;
	2095	2055	0.02843	0.052066	0.00498	59	59	59	0	0	1	-360	360	4.6721	0.4756	-4.6668	-1.0702	0.0000	0.0000	0.0000	0.0000;
	2269	2095	0.02843	0.052066	0.00498	59	59	59	0	0	1	-360	360	5.9695	0.5119	-5.9611	-1.1026	0.0000	0.0000	0.0000	0.0000;
	2211	2207	0.003876	0.006686	0.000629	59	59	59	0	0	1	-360	360	2.4072	0.7616	-2.4070	-0.8390	0.0000	0.0000	0.0000	0.0000;
	2210	2209	0.007603	0.018017	0.001791	59	59	59	0	0	1	-360	360	10.5743	-0.7745	-10.5674	0.5696	0.0000	0.0000	0.0000	0.0000;
	2306	1972	0.011686	0.03957	0.003918	105	105	105	0	0	1	-360	360	-32.9423	-1.9999	33.0468	1.8750	0.0000	0.0000	0.0000	0.0000;
	2352	2215	0.003967	0.029174	0.002829	196	196	196	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2351	2042	0.000992	0.007934	0.00077	171	171	171	0	0	1	-360	360	-2.9190	-0.9440	2.9191	0.8485	0.0000	0.0000	0.0000	0.0000;
	2143	1934	0.02676	0.076893	0.00772	87	87	87	0	0	1	-360	360	31.5343	-4.9452	-31.3123	4.6426	0.0000	0.0000	0.0000	0.0000;
	2091	2042	0.000504	0.003967	0.000559	168	168	168	0	0	1	-360	360	-7.0374	-15.8961	7.0386	15.8359	0.0000	0.0000	0.0000	0.0000;
	2093	2042	0.000504	0.003967	0.000559	160	160	160	0	0	1	-360	360	8.5075	59.9129	-8.4927	-59.8668	0.0000	0.0000	0.0000	0.0000;
	1931	1932	0.00276	0.004826	0.00046	69	69	69	0	0	1	-360	360	-7.9640	-5.7620	7.9662	5.7090	0.0000	0.0000	0.0000	0.0000;
	1932	1930	0.013512	0.023488	0.002241	69	69	69	0	0	1	-360	360	-14.8502	-10.3190	14.8856	10.1027	0.0000	0.0000	0.0000	0.0000;
	2101	2083	0.009091	0.026446	0.002691	69	69	69	0	0	1	-360	360	5.0058	1.4315	-5.0037	-1.7547	0.0000	0.0000	0.0000	0.0000;
	2090	1930	0.031983	0.081066	0.008279	69	69	69	0	0	1	-360	360	-10.9451	-4.6293	10.9806	3.6948	0.0000	0.0000	0.0000	0.0000;
	2134	2090	0.006917	0.019223	0.001941	69	69	69	0	0	1	-360	360	-7.3349	-1.7331	7.3381	1.5033	0.0000	0.0000	0.0000	0.0000;
	2064	2062	0.005041	0.014207	0.0015	76	76	76	0	0	1	-360	360	21.2881	-0.8403	-21.2695	0.7083	0.0000	0.0000	0.0000	0.0000;
	1936	2134	0.01395	0.039983	0.00401	69	69	69	0	0	1	-360	360	-5.2687	-0.8424	5.2719	0.3591	0.0000	0.0000	0.0000	0.0000;
	2101	1936	0.01657	0.048901	0.004901	69	69	69	0	0	1	-360	360	-5.2648	-1.4315	5.2687	0.8424	0.0000	0.0000	0.0000	0.0000;
	2056	2055	0.003802	0.012149	0.001229	62	62	62	0	0	1	-360	360	6.1813	4.4296	-6.1795	-4.5728	0.0000	0.0000	0.0000	0.0000;
	1931	1929	0.00157	0.002727	0.000259	39	39	39	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2211	2202	0.017934	0.058182	0.006031	82	82	82	0	0	1	-360	360	2.4395	2.0389	-2.4378	-2.7774	0.0000	0.0000	0.0000	0.0000;
	2269	2210	0.06438	0.113802	0.01096	48	48	48	0	0	1	-360	360	-10.2645	-2.1169	10.3213	0.8718	0.0000	0.0000	0.0000	0.0000;
	2127	2125	0.002397	0.004132	0.00039	67	67	67	0	0	1	-360	360	0.0766	-2.6071	-0.0764	2.5604	0.0000	0.0000	0.0000	0.0000;
	2058	1929	0.014711	0.037364	0.003821	51	51	51	0	0	1	-360	360	-11.1192	-3.7042	11.1353	3.2706	0.0000	0.0000	0.0000	0.0000;
	2118	2058	0.025041	0.063636	0.007241	51	51	51	0	0	1	-360	360	-11.0907	-4.5249	11.1192	3.7042	0.0000	0.0000	0.0000	0.0000;
	2209	2208	0.016612	0.029174	0.002781	39	39	39	0	0	1	-360	360	3.5984	2.1044	-3.5960	-2.4430	0.0000	0.0000	0.0000	0.0000;
	2311	2202	0.01438	0.046529	0.004811	82	82	82	0	0	1	-360	360	2.6334	-2.1050	-2.6322	1.5164	0.0000	0.0000	0.0000	0.0000;
	2357	2196	0.036686	0.094298	0.009849	51	51	51	0	0	1	-360	360	18.7287	-7.9466	-18.6094	7.0279	0.0000	0.0000	0.0000	0.0000;
	2378	2075	0.029826	0.054628	0.00552	59	59	59	0	0	1	-360	360	0.4674	0.0575	-0.4673	-0.7296	0.0000	0.0000	0.0000	0.0000;
	2138	1988	0.003017	0.01	0.001019	82	82	82	0	0	1	-360	360	-6.3280	-3.5760	6.3293	3.4560	0.0000	0.0000	0.0000	0.0000;
	2066	1988	0.001612	0.005289	0.00054	82	82	82	0	0	1	-360	360	8.4635	4.2660	-8.4623	-4.3280	0.0000	0.0000	0.0000	0.0000;
	2066	2062	0.016446	0.042984	0.004431	76	76	76	0	0	1	-360	360	-17.2455	-0.8076	17.2855	0.3697	0.0000	0.0000	0.0000	0.0000;
	2221	2091	0.010331	0.03405	0.00348	76	76	76	0	0	1	-360	360	-7.2224	-8.5230	7.2325	8.1233	0.0000	0.0000	0.0000	0.0000;
	2357	2335	0.022893	0.062149	0.00636	51	51	51	0	0	1	-360	360	-19.7597	7.2556	19.8423	-7.8223	0.0000	0.0000	0.0000	0.0000;
	2125	2086	0.017521	0.05438	0.005641	91	91	91	0	0	1	-360	360	-2.8456	-2.6484	2.8475	1.9746	0.0000	0.0000	0.0000	0.0000;
	2277	2221	0.014628	0.047934	0.00491	82	82	82	0	0	1	-360	360	-3.1778	-6.4090	3.1834	5.8200	0.0000	0.0000	0.0000	0.0000;
	2327	2277	0.022066	0.071488	0.00747	82	82	82	0	0	1	-360	360	-1.3651	-5.3358	1.3698	4.4320	0.0000	0.0000	0.0000	0.0000;
	2327	2066	0.017603	0.056942	0.00575	82	82	82	0	0	1	-360	360	-1.4739	4.0738	1.4770	-4.7674	0.0000	0.0000	0.0000	0.0000;
	2299	2091	0.016223	0.041793	0.00424	87	87	87	0	0	1	-360	360	-42.9816	-0.6335	43.2247	0.7338	0.0000	0.0000	0.0000	0.0000;
	2188	2092	0.009752	0.032066	0.003291	62	62	62	0	0	1	-360	360	-11.8194	-6.1909	11.8332	5.8247	0.0000	0.0000	0.0000	0.0000;
	2434	2188	0.034876	0.094876	0.009721	62	62	62	0	0	1	-360	360	-8.7821	-5.3755	8.8104	4.2479	0.0000	0.0000	0.0000	0.0000;
	2127	2124	0.006529	0.022066	0.002161	91	91	91	0	0	1	-360	360	17.5529	-4.0157	-17.5354	3.8150	0.0000	0.0000	0.0000	0.0000;
	2299	2143	0.013479	0.039289	0.00394	87	87	87	0	0	1	-360	360	40.8326	-1.0345	-40.6503	1.0822	0.0000	0.0000	0.0000	0.0000;
	2299	2090	0.026198	0.08595	0.008809	82	82	82	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2137	1989	0.046686	0.095446	0.00939	76	76	76	0	0	1	-360	360	3.4960	-4.9004	-3.4839	3.8030	0.0000	0.0000	0.0000	0.0000;
	2119	1990	0.033967	0.059422	0.00567	78	78	78	0	0	1	-360	360	-17.4482	-5.8475	17.5461	5.3546	0.0000	0.0000	0.0000	0.0000;
	2297	2015	0.027364	0.091818	0.00907	78	78	78	0	0	1	-360	360	-15.7074	5.0143	15.7705	-5.8956	0.0000	0.0000	0.0000	0.0000;
	2316	2016	0.02719	0.087934	0.009099	123	123	123	0	0	1	-360	360	-18.4311	4.4099	18.5135	-5.2371	0.0000	0.0000	0.0000	0.0000;
	2119	2032	0.029669	0.049256	0.004859	78	78	78	0	0	1	-360	360	-1.1108	-4.9725	1.1167	4.4164	0.0000	0.0000	0.0000	0.0000;
	2316	1994	0.025207	0.081818	0.009169	123	123	123	0	0	1	-360	360	15.6801	-5.3879	-15.6236	4.4697	0.0000	0.0000	0.0000	0.0000;
	2407	2050	0.059446	0.103983	0.00992	76	76	76	0	0	1	-360	360	-4.3511	-1.9980	4.3615	0.8261	0.0000	0.0000	0.0000	0.0000;
	1944	2407	0.018769	0.032818	0.003129	76	76	76	0	0	1	-360	360	-2.2004	-2.7641	2.2023	2.3936	0.0000	0.0000	0.0000	0.0000;
	2182	2407	0.021107	0.071504	0.007081	76	76	76	0	0	1	-360	360	-2.1480	-0.4480	2.1488	-0.3955	0.0000	0.0000	0.0000	0.0000;
	2404	2015	0.024727	0.054	0.00523	78	78	78	0	0	1	-360	360	2.4514	1.6226	-2.4494	-2.2488	0.0000	0.0000	0.0000	0.0000;
	2318	2404	0.053826	0.110008	0.010609	78	78	78	0	0	1	-360	360	4.9545	0.9357	-4.9426	-2.1969	0.0000	0.0000	0.0000	0.0000;
	2159	2404	0.00257	0.004488	0.000431	78	78	78	0	0	1	-360	360	-2.4910	-0.6260	2.4911	0.5742	0.0000	0.0000	0.0000	0.0000;
	2050	2015	0.001397	0.004628	0.00046	76	76	76	0	0	1	-360	360	-8.2275	-1.4301	8.2283	1.3775	0.0000	0.0000	0.0000	0.0000;
	2284	2283	0.026612	0.086612	0.00899	123	123	123	0	0	1	-360	360	-5.2483	-3.8408	5.2570	2.8097	0.0000	0.0000	0.0000	0.0000;
	2297	2169	0.021984	0.073802	0.007359	78	78	78	0	0	1	-360	360	14.0994	-7.0333	-14.0553	6.2930	0.0000	0.0000	0.0000	0.0000;
	2403	2016	0.03224	0.069984	0.006778	78	78	78	0	0	1	-360	360	-6.7814	-2.8626	6.7954	2.0804	0.0000	0.0000	0.0000	0.0000;
	2158	2403	0.001975	0.003455	0.000329	78	78	78	0	0	1	-360	360	-2.4050	-0.1150	2.4051	0.0758	0.0000	0.0000	0.0000	0.0000;
	1990	2403	0.069529	0.121603	0.011602	78	78	78	0	0	1	-360	360	-4.3581	-4.1330	4.3763	2.7868	0.0000	0.0000	0.0000	0.0000;
	2284	2032	0.031488	0.052149	0.00515	76	76	76	0	0	1	-360	360	2.4143	4.8178	-2.4057	-5.4064	0.0000	0.0000	0.0000	0.0000;
	2027	2015	0.010397	0.037041	0.002819	78	78	78	0	0	1	-360	360	-5.7270	-1.6984	5.7300	1.3700	0.0000	0.0000	0.0000	0.0000;
	2026	2027	0.003752	0.006562	0.000629	78	78	78	0	0	1	-360	360	-3.4075	-1.3932	3.4080	1.3184	0.0000	0.0000	0.0000	0.0000;
	2019	2026	0.007107	0.012438	0.001191	78	78	78	0	0	1	-360	360	0.2865	-0.7822	-0.2865	0.6392	0.0000	0.0000	0.0000	0.0000;
	2031	2016	0.004149	0.007256	0.00069	78	78	78	0	0	1	-360	360	-6.2168	-1.7603	6.2183	1.6799	0.0000	0.0000	0.0000	0.0000;
	2018	2031	0.006521	0.011397	0.001089	78	78	78	0	0	1	-360	360	-4.8405	-1.1338	4.8418	1.0053	0.0000	0.0000	0.0000	0.0000;
	2178	1986	0.019826	0.055041	0.005951	76	76	76	0	0	1	-360	360	-1.6398	-0.9722	1.6403	0.2654	0.0000	0.0000	0.0000	0.0000;
	2414	2329	0.010934	0.030479	0.003071	102	102	102	0	0	1	-360	360	5.5064	-4.3094	-5.5021	3.9556	0.0000	0.0000	0.0000	0.0000;
	1986	2414	0.003752	0.010248	0.001031	102	102	102	0	0	1	-360	360	8.6896	-4.0837	-8.6868	3.9689	0.0000	0.0000	0.0000	0.0000;
	2427	2414	0.003826	0.006686	0.000639	102	102	102	0	0	1	-360	360	-3.1800	-0.4160	3.1803	0.3405	0.0000	0.0000	0.0000	0.0000;
	2448	2255	0.011727	0.030521	0.00303	78	78	78	0	0	1	-360	360	-2.5391	1.4276	2.5400	-1.7867	0.0000	0.0000	0.0000	0.0000;
	2448	2179	0.040231	0.102769	0.01021	78	78	78	0	0	1	-360	360	2.1091	-1.6576	-2.1072	0.4441	0.0000	0.0000	0.0000	0.0000;
	2326	2179	0.028603	0.053223	0.00515	76	76	76	0	0	1	-360	360	-14.4949	3.9383	14.5497	-4.4499	0.0000	0.0000	0.0000	0.0000;
	1960	1992	9.1e-05	0.000686	7e-05	120	120	120	0	0	1	-360	360	-44.3792	-1.9441	44.3807	1.9467	0.0000	0.0000	0.0000	0.0000;
	2023	1960	0.005554	0.018182	0.001861	120	120	120	0	0	1	-360	360	-44.2888	-1.8728	44.3792	1.9441	0.0000	0.0000	0.0000	0.0000;
	2254	2009	0.025603	0.078397	0.008061	78	78	78	0	0	1	-360	360	2.4481	-0.3776	-2.4468	-0.5794	0.0000	0.0000	0.0000	0.0000;
	2255	2030	0.006612	0.018256	0.001941	102	102	102	0	0	1	-360	360	12.9509	2.4720	-12.9412	-2.6765	0.0000	0.0000	0.0000	0.0000;
	2331	2009	0.009603	0.024744	0.00251	69	69	69	0	0	1	-360	360	-1.6300	-0.9720	1.6303	0.6738	0.0000	0.0000	0.0000	0.0000;
	2237	2331	0.001711	0.005157	0.00052	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2295	2009	0.006281	0.010578	0.001079	78	78	78	0	0	1	-360	360	-6.7730	3.5000	6.7761	-3.6234	0.0000	0.0000	0.0000	0.0000;
	2429	2010	0.017769	0.03157	0.003011	78	78	78	0	0	1	-360	360	-8.8875	-2.6784	8.9003	2.3431	0.0000	0.0000	0.0000	0.0000;
	2179	2163	0.027058	0.091636	0.00907	78	78	78	0	0	1	-360	360	8.0961	-5.4367	-8.0758	4.4208	0.0000	0.0000	0.0000	0.0000;
	2197	2163	0.020777	0.038017	0.00364	78	78	78	0	0	1	-360	360	-6.3483	2.7564	6.3568	-3.1768	0.0000	0.0000	0.0000	0.0000;
	2197	2005	0.041521	0.074289	0.0071	78	78	78	0	0	1	-360	360	3.8563	-2.1864	-3.8500	1.3473	0.0000	0.0000	0.0000	0.0000;
	2279	2005	0.050174	0.087744	0.008371	78	78	78	0	0	1	-360	360	-3.8435	0.3576	3.8500	-1.3473	0.0000	0.0000	0.0000	0.0000;
	2326	1991	0.044628	0.094207	0.009629	76	76	76	0	0	1	-360	360	10.3699	-4.6963	-10.3232	3.6501	0.0000	0.0000	0.0000	0.0000;
	2384	2278	0.024793	0.080413	0.00832	123	123	123	0	0	1	-360	360	-6.2737	0.3040	6.2824	-1.2291	0.0000	0.0000	0.0000	0.0000;
	2278	2167	0.037686	0.065537	0.006241	78	78	78	0	0	1	-360	360	-10.0664	-1.0049	10.0998	0.3448	0.0000	0.0000	0.0000	0.0000;
	2167	2017	0.065372	0.114876	0.01096	78	78	78	0	0	1	-360	360	-10.4428	-0.6378	10.5046	-0.5274	0.0000	0.0000	0.0000	0.0000;
	2236	2010	0.011438	0.030231	0.003059	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2023	1986	0.020579	0.067603	0.005689	123	123	123	0	0	1	-360	360	39.9918	-0.6952	-39.7188	0.9100	0.0000	0.0000	0.0000	0.0000;
	2420	2246	0.01314	0.025537	0.002461	78	78	78	0	0	1	-360	360	-19.2503	-2.3561	19.2922	2.1465	0.0000	0.0000	0.0000	0.0000;
	2191	2332	0.019471	0.06595	0.006529	123	123	123	0	0	1	-360	360	-3.9550	-2.3910	3.9583	1.6439	0.0000	0.0000	0.0000	0.0000;
	2354	1969	0.021818	0.071066	0.007369	123	123	123	0	0	1	-360	360	21.5727	-1.3963	-21.4885	0.7842	0.0000	0.0000	0.0000	0.0000;
	2346	2255	0.00486	0.016446	0.001631	120	120	120	0	0	1	-360	360	-10.1682	-2.9845	10.1728	2.8056	0.0000	0.0000	0.0000	0.0000;
	1941	2254	0.002281	0.007719	0.00076	123	123	123	0	0	1	-360	360	-7.9711	-0.6821	7.9723	0.5956	0.0000	0.0000	0.0000	0.0000;
	2279	2183	0.023058	0.057364	0.005871	102	102	102	0	0	1	-360	360	3.2664	-3.0030	-3.2630	2.3096	0.0000	0.0000	0.0000	0.0000;
	2140	2010	0.003893	0.01319	0.001307	123	123	123	0	0	1	-360	360	2.2161	0.4010	-2.2160	-0.5562	0.0000	0.0000	0.0000	0.0000;
	1941	2140	0.010107	0.034248	0.00339	123	123	123	0	0	1	-360	360	3.3331	-0.2319	-3.3321	-0.1690	0.0000	0.0000	0.0000	0.0000;
	2192	2009	0.007802	0.026413	0.002621	123	123	123	0	0	1	-360	360	-0.3178	-0.9085	0.3179	0.5965	0.0000	0.0000	0.0000	0.0000;
	2346	2192	0.003174	0.010727	0.00106	123	123	123	0	0	1	-360	360	0.9712	-1.4825	-0.9712	1.3565	0.0000	0.0000	0.0000	0.0000;
	2329	2254	0.00595	0.020157	0.001999	120	120	120	0	0	1	-360	360	2.0091	-2.2777	-2.0086	2.0408	0.0000	0.0000	0.0000	0.0000;
	2245	2030	0.012893	0.033719	0.00333	102	102	102	0	0	1	-360	360	-6.2316	-2.1442	6.2362	1.7605	0.0000	0.0000	0.0000	0.0000;
	2279	2087	0.033967	0.058099	0.00559	72	72	72	0	0	1	-360	360	11.3154	1.4356	-11.2781	-2.0371	0.0000	0.0000	0.0000	0.0000;
	2087	2008	0.069256	0.12157	0.011739	78	78	78	0	0	1	-360	360	8.0111	1.6741	-7.9703	-2.9839	0.0000	0.0000	0.0000	0.0000;
	2420	2017	0.039826	0.069669	0.00666	78	78	78	0	0	1	-360	360	13.8353	-0.9749	-13.7706	0.3064	0.0000	0.0000	0.0000	0.0000;
	2384	2322	0.007521	0.018347	0.00196	78	78	78	0	0	1	-360	360	4.8987	1.4850	-4.8970	-1.7050	0.0000	0.0000	0.0000	0.0000;
	2325	2323	0.007521	0.018347	0.00196	78	78	78	0	0	1	-360	360	0.0000	-0.2345	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2332	2008	0.018182	0.058843	0.00612	123	123	123	0	0	1	-360	360	-6.3493	-2.4679	6.3563	1.7769	0.0000	0.0000	0.0000	0.0000;
	2246	1986	0.009256	0.018603	0.00181	78	78	78	0	0	1	-360	360	-24.6152	-2.3825	24.6629	2.2633	0.0000	0.0000	0.0000	0.0000;
	2273	2178	0.069421	0.140496	0.01368	78	78	78	0	0	1	-360	360	-4.4198	1.0493	4.4332	-2.6485	0.0000	0.0000	0.0000	0.0000;
	2325	2183	0.011066	0.027438	0.00281	102	102	102	0	0	1	-360	360	-0.3430	0.0025	0.3430	-0.3386	0.0000	0.0000	0.0000	0.0000;
	2354	1992	0.012893	0.041984	0.004361	123	123	123	0	0	1	-360	360	-22.0877	1.2273	22.1401	-1.5843	0.0000	0.0000	0.0000	0.0000;
	2294	2166	0.008017	0.021744	0.0022	78	78	78	0	0	1	-360	360	-6.6960	3.6110	6.7000	-3.8624	0.0000	0.0000	0.0000	0.0000;
	2166	2010	0.00843	0.022984	0.002321	78	78	78	0	0	1	-360	360	-8.4190	2.9574	8.4247	-3.2184	0.0000	0.0000	0.0000	0.0000;
	2178	2153	0.022636	0.073554	0.007621	123	123	123	0	0	1	-360	360	1.2643	-0.5802	-1.2640	-0.3250	0.0000	0.0000	0.0000	0.0000;
	1969	1939	0.031802	0.079793	0.00779	123	123	123	0	0	1	-360	360	18.8255	-0.4942	-18.7315	-0.1998	0.0000	0.0000	0.0000	0.0000;
	2179	1971	0.050331	0.133876	0.01203	78	78	78	0	0	1	-360	360	3.7894	-2.8454	-3.7814	1.4297	0.0000	0.0000	0.0000	0.0000;
	2358	1971	0.028512	0.09843	0.008959	123	123	123	0	0	1	-360	360	-1.2030	-0.0760	1.2034	-0.9937	0.0000	0.0000	0.0000	0.0000;
	2279	2178	0.034298	0.245446	0.024079	120	120	120	0	0	1	-360	360	-10.1463	1.2098	10.1779	-3.8544	0.0000	0.0000	0.0000	0.0000;
	2429	2245	0.008182	0.021488	0.00212	102	102	102	0	0	1	-360	360	-0.7315	-0.8296	0.7316	0.5782	0.0000	0.0000	0.0000	0.0000;
	2424	2144	0.04876	0.069421	0.01254	120	120	120	0	0	1	-360	360	5.9150	-1.9401	-5.9008	0.4043	0.0000	0.0000	0.0000	0.0000;
	2272	2425	0.019793	0.036289	0.00348	78	78	78	0	0	1	-360	360	-0.6010	-0.2710	0.6011	-0.1614	0.0000	0.0000	0.0000	0.0000;
	2394	2425	0.023636	0.059917	0.006181	120	120	120	0	0	1	-360	360	-2.8496	-2.0901	2.8517	1.3283	0.0000	0.0000	0.0000	0.0000;
	2394	2001	0.001818	0.004628	0.000469	120	120	120	0	0	1	-360	360	2.4931	0.7831	-2.4930	-0.8410	0.0000	0.0000	0.0000	0.0000;
	1948	2394	0.00405	0.013058	0.00136	120	120	120	0	0	1	-360	360	-0.3564	-1.4754	0.3565	1.3070	0.0000	0.0000	0.0000	0.0000;
	2425	2422	0.022314	0.07557	0.00748	123	123	123	0	0	1	-360	360	3.0107	-0.0043	-3.0090	-0.9190	0.0000	0.0000	0.0000	0.0000;
	2301	2424	0.028347	0.095041	0.00937	123	123	123	0	0	1	-360	360	-8.5925	-3.7958	8.6118	2.7013	0.0000	0.0000	0.0000	0.0000;
	2424	2198	0.030248	0.101653	0.010019	120	120	120	0	0	1	-360	360	1.9511	-0.8768	-1.9501	-0.3649	0.0000	0.0000	0.0000	0.0000;
	2321	2441	0.015703	0.027273	0.00286	69	69	69	0	0	1	-360	360	5.7313	0.2491	-5.7271	-0.5973	0.0000	0.0000	0.0000	0.0000;
	2348	2230	0.012008	0.026711	0.002589	120	120	120	0	0	1	-360	360	-3.7952	-0.1780	3.7966	-0.1407	0.0000	0.0000	0.0000	0.0000;
	2320	2348	0.011273	0.025479	0.002471	78	78	78	0	0	1	-360	360	2.3174	0.7733	-2.3168	-1.0791	0.0000	0.0000	0.0000	0.0000;
	2320	2302	0.008099	0.027422	0.00272	120	120	120	0	0	1	-360	360	6.1193	0.5187	-6.1168	-0.8484	0.0000	0.0000	0.0000	0.0000;
	2320	2314	0.029752	0.042066	0.004039	69	69	69	0	0	1	-360	360	15.5718	3.0047	-15.5112	-3.4188	0.0000	0.0000	0.0000	0.0000;
	2321	2268	0.049587	0.086777	0.009	69	69	69	0	0	1	-360	360	12.8788	-0.5964	-12.8126	-0.4015	0.0000	0.0000	0.0000	0.0000;
	2268	2218	0.042066	0.070248	0.00733	69	69	69	0	0	1	-360	360	11.6096	0.2365	-11.5634	-1.0578	0.0000	0.0000	0.0000	0.0000;
	1948	2321	0.038983	0.103132	0.01043	102	102	102	0	0	1	-360	360	-6.1146	-0.5247	6.1263	-0.7390	0.0000	0.0000	0.0000	0.0000;
	2290	2320	0.014669	0.040397	0.00628	102	102	102	0	0	1	-360	360	-4.4753	0.5457	4.4778	-1.3195	0.0000	0.0000	0.0000	0.0000;
	2314	2059	0.05124	0.081818	0.009489	78	78	78	0	0	1	-360	360	8.6302	-0.2552	-8.5992	-0.8593	0.0000	0.0000	0.0000	0.0000;
	1951	1937	0.006612	0.019826	0.002299	123	123	123	0	0	1	-360	360	6.8100	-0.6483	-6.8075	0.3697	0.0000	0.0000	0.0000	0.0000;
	2320	2222	0.01405	0.027273	0.002781	78	78	78	0	0	1	-360	360	-0.7925	0.7357	0.7927	-1.0811	0.0000	0.0000	0.0000	0.0000;
	2222	1952	0.024793	0.042984	0.00423	78	78	78	0	0	1	-360	360	-5.5237	0.6660	5.5299	-1.1815	0.0000	0.0000	0.0000	0.0000;
	2162	1951	0.032231	0.055372	0.003071	78	78	78	0	0	1	-360	360	-0.7148	-0.1032	0.7149	-0.2787	0.0000	0.0000	0.0000	0.0000;
	2321	1937	0.01762	0.041347	0.00402	78	78	78	0	0	1	-360	360	-3.3707	0.9330	3.3725	-1.4287	0.0000	0.0000	0.0000	0.0000;
	1952	2230	0.011347	0.035091	0.003461	123	123	123	0	0	1	-360	360	6.9810	0.0235	-6.9766	-0.4403	0.0000	0.0000	0.0000	0.0000;
	2359	1952	0.009917	0.020661	0.00218	91	91	91	0	0	1	-360	360	-7.5631	3.0014	7.5684	-3.2617	0.0000	0.0000	0.0000	0.0000;
	2063	1952	0.017529	0.059364	0.005881	123	123	123	0	0	1	-360	360	0.1835	-1.1647	-0.1834	0.4331	0.0000	0.0000	0.0000	0.0000;
	2359	2282	0.009917	0.023141	0.002611	91	91	91	0	0	1	-360	360	7.5631	-3.0014	-7.5579	2.6885	0.0000	0.0000	0.0000	0.0000;
	2282	2198	0.033802	0.080992	0.009271	91	91	91	0	0	1	-360	360	6.0979	-1.6305	-6.0875	0.5026	0.0000	0.0000	0.0000	0.0000;
	2298	2024	0.028099	0.089256	0.00924	114	114	114	0	0	1	-360	360	-5.3909	0.8573	5.3980	-1.9820	0.0000	0.0000	0.0000	0.0000;
	2164	2024	0.01405	0.044628	0.0046	120	120	120	0	0	1	-360	360	7.7250	-1.7392	-7.7180	1.1900	0.0000	0.0000	0.0000	0.0000;
	2298	2198	0.018182	0.041322	0.004649	114	114	114	0	0	1	-360	360	-4.5964	0.4457	4.5996	-1.0157	0.0000	0.0000	0.0000	0.0000;
	2164	1951	0.01157	0.028099	0.00286	102	102	102	0	0	1	-360	360	-10.9890	0.7952	11.0003	-1.1234	0.0000	0.0000	0.0000	0.0000;
	2298	2071	0.024793	0.034711	0.004189	78	78	78	0	0	1	-360	360	8.2704	-1.1620	-8.2565	0.6622	0.0000	0.0000	0.0000	0.0000;
	2072	1963	0.037934	0.066124	0.006411	78	78	78	0	0	1	-360	360	-0.7585	0.0543	0.7588	-0.8473	0.0000	0.0000	0.0000	0.0000;
	1997	2072	0.038529	0.068058	0.0065	78	78	78	0	0	1	-360	360	-2.6674	0.7519	2.6701	-1.5516	0.0000	0.0000	0.0000	0.0000;
	2128	1997	0.025149	0.045496	0.004371	120	120	120	0	0	1	-360	360	-1.3780	0.1660	1.3784	-0.7059	0.0000	0.0000	0.0000	0.0000;
	2144	1963	0.01405	0.044628	0.00484	120	120	120	0	0	1	-360	360	4.1838	-0.4103	-4.1818	-0.1827	0.0000	0.0000	0.0000	0.0000;
	2047	2302	0.008256	0.016529	0.001941	120	120	120	0	0	1	-360	360	-3.9678	-0.2532	3.9688	0.0144	0.0000	0.0000	0.0000	0.0000;
	2000	2290	0.037636	0.097041	0.00984	102	102	102	0	0	1	-360	360	-2.7560	-0.8450	2.7583	-0.3707	0.0000	0.0000	0.0000	0.0000;
	2047	2441	0.01676	0.056777	0.005619	120	120	120	0	0	1	-360	360	-2.6321	0.1534	2.6331	-0.8477	0.0000	0.0000	0.0000	0.0000;
	2135	2425	0.013347	0.045198	0.00447	120	120	120	0	0	1	-360	360	-2.3200	-0.7020	2.3206	0.1488	0.0000	0.0000	0.0000	0.0000;
	2433	2171	0.013173	0.044603	0.004419	123	123	123	0	0	1	-360	360	-10.9365	1.3719	10.9494	-1.8807	0.0000	0.0000	0.0000	0.0000;
	1979	1946	0.042827	0.097868	0.00953	78	78	78	0	0	1	-360	360	5.0874	-0.9477	-5.0785	-0.2199	0.0000	0.0000	0.0000	0.0000;
	2171	1947	0.054893	0.14743	0.01489	102	102	102	0	0	1	-360	360	11.7307	-3.1048	-11.6682	1.4146	0.0000	0.0000	0.0000	0.0000;
	2172	1945	0.049016	0.127529	0.01292	102	102	102	0	0	1	-360	360	14.3739	-5.7776	-14.2829	4.4055	0.0000	0.0000	0.0000	0.0000;
	2344	2171	0.005141	0.035124	0.007899	196	196	196	0	0	1	-360	360	33.4479	-11.4131	-33.3968	10.7756	0.0000	0.0000	0.0000	0.0000;
	2344	2172	0.005141	0.035124	0.007899	196	196	196	0	0	1	-360	360	21.2824	-2.4702	-21.2635	1.6146	0.0000	0.0000	0.0000	0.0000;
	2171	2141	0.032231	0.077686	0.0044	123	123	123	0	0	1	-360	360	13.8911	-2.7378	-13.8398	2.3121	0.0000	0.0000	0.0000	0.0000;
	2172	1958	0.027273	0.068603	0.00666	102	102	102	0	0	1	-360	360	2.6646	-0.8133	-2.6630	-0.0120	0.0000	0.0000	0.0000	0.0000;
	2340	2338	0.003314	0.009917	0.00099	123	123	123	0	0	1	-360	360	0.8590	-0.1232	-0.8590	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2345	2337	0.004132	0.009091	0.000939	123	123	123	0	0	1	-360	360	8.5971	4.3719	-8.5940	-4.4820	0.0000	0.0000	0.0000	0.0000;
	2344	2340	0.004132	0.009917	0.00099	123	123	123	0	0	1	-360	360	7.3485	1.8953	-7.3466	-2.0140	0.0000	0.0000	0.0000	0.0000;
	2344	2341	0.004132	0.010744	0.00099	123	123	123	0	0	1	-360	360	3.9021	2.5666	-3.9013	-2.6881	0.0000	0.0000	0.0000	0.0000;
	2341	2339	0.004132	0.01157	0.001041	123	123	123	0	0	1	-360	360	0.4300	0.4524	-0.4300	-0.5820	0.0000	0.0000	0.0000	0.0000;
	2107	1947	0.010744	0.034711	0.00356	114	114	114	0	0	1	-360	360	-18.1094	4.9450	18.1400	-5.2891	0.0000	0.0000	0.0000	0.0000;
	2365	1945	0.009446	0.028463	0.0028	78	78	78	0	0	1	-360	360	-0.4300	-0.0000	0.4300	-0.3485	0.0000	0.0000	0.0000	0.0000;
	2364	1947	0.004512	0.015289	0.00151	123	123	123	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.1880	0.0000	0.0000	0.0000	0.0000;
	1947	1946	0.006504	0.022017	0.00218	120	120	120	0	0	1	-360	360	-9.6498	2.5784	9.6551	-2.8321	0.0000	0.0000	0.0000	0.0000;
	2249	1979	0.01319	0.044669	0.004419	123	123	123	0	0	1	-360	360	5.6919	-1.4044	-5.6884	0.8647	0.0000	0.0000	0.0000	0.0000;
	2433	2249	0.012603	0.042653	0.004221	123	123	123	0	0	1	-360	360	7.2435	-1.7369	-7.2379	1.2284	0.0000	0.0000	0.0000	0.0000;
	2161	2141	0.02562	0.078512	0.008419	123	123	123	0	0	1	-360	360	-10.0984	2.1475	10.1208	-3.1271	0.0000	0.0000	0.0000	0.0000;
	2276	2161	0.012397	0.041322	0.004189	120	120	120	0	0	1	-360	360	-8.7164	1.7587	8.7244	-2.2535	0.0000	0.0000	0.0000	0.0000;
	1959	1975	0.036686	0.091653	0.009399	102	102	102	0	0	1	-360	360	-1.6880	-0.1010	1.6889	-1.0697	0.0000	0.0000	0.0000	0.0000;
	2361	2061	0.006612	0.015703	0.00165	102	102	102	0	0	1	-360	360	0.8590	-0.1349	-0.8590	-0.0710	0.0000	0.0000	0.0000	0.0000;
	2060	1975	0.005917	0.01857	0.001989	78	78	78	0	0	1	-360	360	-10.7011	0.8521	10.7065	-1.0831	0.0000	0.0000	0.0000	0.0000;
	2361	1975	0.00157	0.005124	0.00053	120	120	120	0	0	1	-360	360	-3.5170	-0.0851	3.5172	0.0195	0.0000	0.0000	0.0000	0.0000;
	2362	1975	0.001529	0.004934	0.000501	120	120	120	0	0	1	-360	360	-2.8370	0.1710	2.8371	-0.2332	0.0000	0.0000	0.0000	0.0000;
	2060	2052	0.005793	0.013223	0.001379	78	78	78	0	0	1	-360	360	8.9841	-0.9821	-8.9803	0.8188	0.0000	0.0000	0.0000	0.0000;
	2096	1975	0.02719	0.049174	0.004779	78	78	78	0	0	1	-360	360	-7.6787	0.5330	7.6918	-1.1052	0.0000	0.0000	0.0000	0.0000;
	2219	1975	0.012901	0.022744	0.0022	78	78	78	0	0	1	-360	360	-1.8620	0.2387	1.8624	-0.5125	0.0000	0.0000	0.0000	0.0000;
	2220	1975	0.012041	0.024719	0.002439	78	78	78	0	0	1	-360	360	-3.2700	-0.8220	3.2711	0.5199	0.0000	0.0000	0.0000	0.0000;
	2170	2052	0.028934	0.05124	0.00469	78	78	78	0	0	1	-360	360	-4.1651	0.5460	4.1693	-1.1228	0.0000	0.0000	0.0000	0.0000;
	2170	2162	0.015703	0.027273	0.002519	78	78	78	0	0	1	-360	360	2.8761	-0.6190	-2.8750	0.3073	0.0000	0.0000	0.0000	0.0000;
	2096	2063	0.018934	0.059504	0.006561	120	120	120	0	0	1	-360	360	4.2427	-1.2670	-4.2399	0.4595	0.0000	0.0000	0.0000	0.0000;
	2162	2063	0.01405	0.023141	0.002321	78	78	78	0	0	1	-360	360	0.5838	-0.4212	-0.5837	0.1325	0.0000	0.0000	0.0000	0.0000;
	2142	2063	0.009	0.030479	0.00302	69	69	69	0	0	1	-360	360	-1.2040	-0.1640	1.2041	-0.2114	0.0000	0.0000	0.0000	0.0000;
	2342	2340	0.009091	0.031397	0.003269	123	123	123	0	0	1	-360	360	-1.7662	-1.3392	1.7665	0.9332	0.0000	0.0000	0.0000	0.0000;
	2343	2341	0.012397	0.040496	0.00416	123	123	123	0	0	1	-360	360	-2.1828	-1.0048	2.1833	0.4886	0.0000	0.0000	0.0000	0.0000;
	2296	2219	0.006364	0.021554	0.00213	91	91	91	0	0	1	-360	360	-0.6590	0.0580	0.6590	-0.3237	0.0000	0.0000	0.0000	0.0000;
	2084	2253	0.010281	0.01795	0.001711	102	102	102	0	0	1	-360	360	-4.6410	-1.1520	4.6429	0.9488	0.0000	0.0000	0.0000	0.0000;
	2080	2252	0.013339	0.033901	0.003429	102	102	102	0	0	1	-360	360	-10.8970	-5.3360	10.9131	4.9642	0.0000	0.0000	0.0000	0.0000;
	2408	2253	0.012488	0.03219	0.00326	102	102	102	0	0	1	-360	360	13.3118	-2.2823	-13.2931	1.9365	0.0000	0.0000	0.0000	0.0000;
	2081	2408	0.000603	0.001033	9.9e-05	102	102	102	0	0	1	-360	360	-10.3010	-2.3050	10.3016	2.2939	0.0000	0.0000	0.0000	0.0000;
	2401	2408	0.004347	0.007603	0.000731	102	102	102	0	0	1	-360	360	23.6334	-0.0418	-23.6134	-0.0117	0.0000	0.0000	0.0000	0.0000;
	2131	2401	0.000397	0.000686	7e-05	102	102	102	0	0	1	-360	360	-4.1850	-2.8470	4.1851	2.8386	0.0000	0.0000	0.0000	0.0000;
	2410	2401	0.002207	0.007463	0.00074	102	102	102	0	0	1	-360	360	27.8327	2.7551	-27.8185	-2.7968	0.0000	0.0000	0.0000	0.0000;
	2312	2410	0.008504	0.014851	0.001421	102	102	102	0	0	1	-360	360	-2.1480	1.1710	2.1484	-1.3426	0.0000	0.0000	0.0000	0.0000;
	2264	2410	0.008198	0.027769	0.002749	102	102	102	0	0	1	-360	360	30.0420	1.2841	-29.9812	-1.4125	0.0000	0.0000	0.0000	0.0000;
	2097	2252	0.00257	0.004488	0.000431	102	102	102	0	0	1	-360	360	-7.5490	-7.0820	7.5513	7.0340	0.0000	0.0000	0.0000	0.0000;
	2079	2085	0.004554	0.012628	0.00127	102	102	102	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.1531	0.0000	0.0000	0.0000	0.0000;
	2098	2252	0.00257	0.004488	0.000431	102	102	102	0	0	1	-360	360	-12.0620	-3.6300	12.0654	3.5839	0.0000	0.0000	0.0000	0.0000;
	2110	2115	0.01176	0.021074	0.002016	78	78	78	0	0	1	-360	360	8.8500	-0.4505	-8.8424	0.2208	0.0000	0.0000	0.0000	0.0000;
	2099	2253	0.00257	0.004488	0.000431	102	102	102	0	0	1	-360	360	-12.0370	-2.3050	12.0402	2.2586	0.0000	0.0000	0.0000	0.0000;
	2440	2114	0.018033	0.061091	0.006048	78	78	78	0	0	1	-360	360	2.5817	5.5842	-2.5755	-6.2967	0.0000	0.0000	0.0000	0.0000;
	2243	2252	0.001537	0.005207	0.00052	123	123	123	0	0	1	-360	360	-17.0296	-0.6759	17.0333	0.6256	0.0000	0.0000	0.0000	0.0000;
	2253	2109	0.002479	0.006612	0.00068	123	123	123	0	0	1	-360	360	9.1361	4.3955	-9.1340	-4.4720	0.0000	0.0000	0.0000	0.0000;
	2252	2108	0.002479	0.006612	0.00068	123	123	123	0	0	1	-360	360	-2.9407	11.6036	2.9437	-11.6777	0.0000	0.0000	0.0000	0.0000;
	2243	2120	0.006967	0.023603	0.00234	123	123	123	0	0	1	-360	360	6.7286	0.6759	-6.7260	-0.9490	0.0000	0.0000	0.0000	0.0000;
	2253	2116	0.002769	0.009372	0.000929	120	120	120	0	0	1	-360	360	0.0001	2.4352	0.0000	-2.5470	0.0000	0.0000	0.0000	0.0000;
	2115	2252	0.002769	0.009372	0.000929	120	120	120	0	0	1	-360	360	7.2964	-5.4748	-7.2945	5.3690	0.0000	0.0000	0.0000	0.0000;
	2240	2253	0.000124	0.000397	4.1e-05	123	123	123	0	0	1	-360	360	-6.8840	0.4640	6.8840	-0.4688	0.0000	0.0000	0.0000	0.0000;
	2241	2252	9.9e-05	0.000314	2.9e-05	123	123	123	0	0	1	-360	360	-1.6800	-0.2300	1.6800	0.2265	0.0000	0.0000	0.0000	0.0000;
	2253	2111	0.005793	0.018182	0.001861	120	120	120	0	0	1	-360	360	-30.9821	0.5663	31.0282	-0.6469	0.0000	0.0000	0.0000	0.0000;
	2402	1978	0.020702	0.070124	0.006941	123	123	123	0	0	1	-360	360	-7.1336	-0.3910	7.1422	-0.4291	0.0000	0.0000	0.0000	0.0000;
	2150	2402	0.003488	0.011802	0.001169	123	123	123	0	0	1	-360	360	-0.6025	-0.6651	0.6025	0.5223	0.0000	0.0000	0.0000	0.0000;
	2148	2402	0.006149	0.020827	0.002059	123	123	123	0	0	1	-360	360	-6.5290	-0.1130	6.5311	-0.1313	0.0000	0.0000	0.0000	0.0000;
	2367	2288	0.024793	0.076859	0.008349	120	120	120	0	0	1	-360	360	4.8106	-1.3142	-4.8058	0.2966	0.0000	0.0000	0.0000	0.0000;
	2289	2033	0.028934	0.08843	0.009731	120	120	120	0	0	1	-360	360	14.9490	-3.0667	-14.8953	2.0302	0.0000	0.0000	0.0000	0.0000;
	2105	2082	0.00676	0.022909	0.00227	120	120	120	0	0	1	-360	360	-38.0035	-1.0507	38.0841	1.0481	0.0000	0.0000	0.0000	0.0000;
	2113	2105	0.003686	0.012496	0.001237	123	123	123	0	0	1	-360	360	-37.7879	-0.9377	37.8315	0.9357	0.0000	0.0000	0.0000	0.0000;
	2113	2108	0.005223	0.017702	0.001752	123	123	123	0	0	1	-360	360	21.5282	3.0251	-21.5077	-3.1673	0.0000	0.0000	0.0000	0.0000;
	2400	2253	0.000612	0.002083	0.00021	120	120	120	0	0	1	-360	360	-31.2532	3.8577	31.2582	-3.8660	0.0000	0.0000	0.0000	0.0000;
	2100	2400	0.001017	0.003471	0.000339	120	120	120	0	0	1	-360	360	-6.0090	-1.1520	6.0093	1.1122	0.0000	0.0000	0.0000	0.0000;
	2103	2400	0.004314	0.013876	0.001159	120	120	120	0	0	1	-360	360	-25.2202	4.9058	25.2439	-4.9698	0.0000	0.0000	0.0000	0.0000;
	2123	2252	0.009421	0.031934	0.003161	120	120	120	0	0	1	-360	360	-4.5630	-1.9250	4.5649	1.5502	0.0000	0.0000	0.0000	0.0000;
	2122	2102	0.006446	0.021868	0.002161	120	120	120	0	0	1	-360	360	-18.7628	8.4350	18.7855	-8.6190	0.0000	0.0000	0.0000	0.0000;
	2106	1973	0.024388	0.063587	0.01204	123	123	123	0	0	1	-360	360	24.9331	-7.1344	-24.8033	5.9770	0.0000	0.0000	0.0000	0.0000;
	2444	2218	0.019016	0.041529	0.008639	78	78	78	0	0	1	-360	360	0.0000	0.0000	0.0000	-1.0545	0.0000	0.0000	0.0000	0.0000;
	2276	2106	0.005793	0.018934	0.001909	76	76	76	0	0	1	-360	360	6.8264	-2.4167	-6.8240	2.1870	0.0000	0.0000	0.0000	0.0000;
	2218	2151	0.015703	0.02562	0.00227	120	120	120	0	0	1	-360	360	0.0906	-1.4930	-0.0904	1.2163	0.0000	0.0000	0.0000	0.0000;
	2151	2150	0.008256	0.012397	0.00128	120	120	120	0	0	1	-360	360	-3.1736	-1.5773	3.1745	1.4221	0.0000	0.0000	0.0000	0.0000;
	2443	2217	0.022091	0.057744	0.005651	76	76	76	0	0	1	-360	360	-2.6630	-0.3580	2.6643	-0.3279	0.0000	0.0000	0.0000	0.0000;
	2040	2217	0.004347	0.007603	0.000721	69	69	69	0	0	1	-360	360	-9.2022	-9.2377	9.2082	9.1604	0.0000	0.0000	0.0000	0.0000;
	2041	2218	0.004347	0.007603	0.000721	69	69	69	0	0	1	-360	360	-2.5910	-2.0400	2.5914	1.9527	0.0000	0.0000	0.0000	0.0000;
	2217	2059	0.046281	0.076859	0.00755	76	76	76	0	0	1	-360	360	-6.0032	2.0342	6.0192	-2.9297	0.0000	0.0000	0.0000	0.0000;
	2037	2446	0.002446	0.008331	0.00083	114	114	114	0	0	1	-360	360	-1.9830	9.5200	1.9849	-9.6141	0.0000	0.0000	0.0000	0.0000;
	2036	2445	0.002446	0.008331	0.00083	114	114	114	0	0	1	-360	360	-0.5700	-4.1370	0.5703	4.0367	0.0000	0.0000	0.0000	0.0000;
	2445	1956	0.006612	0.009091	0.001159	120	120	120	0	0	1	-360	360	7.6599	6.0829	-7.6547	-6.2174	0.0000	0.0000	0.0000	0.0000;
	2440	1956	0.007438	0.023967	0.002439	120	120	120	0	0	1	-360	360	-4.1277	-5.7272	4.1307	5.4394	0.0000	0.0000	0.0000	0.0000;
	2445	2039	0.004959	0.014876	0.00167	120	120	120	0	0	1	-360	360	16.6593	-4.9804	-16.6471	4.8129	0.0000	0.0000	0.0000	0.0000;
	2446	2038	0.004959	0.014876	0.00167	120	120	120	0	0	1	-360	360	22.4408	17.8186	-22.4070	-17.9190	0.0000	0.0000	0.0000	0.0000;
	2446	2121	0.013223	0.042066	0.0046	120	120	120	0	0	1	-360	360	2.1705	6.4144	-2.1651	-6.9531	0.0000	0.0000	0.0000	0.0000;
	2446	2117	0.009091	0.027273	0.002899	120	120	120	0	0	1	-360	360	-13.0563	6.9321	13.0729	-7.2333	0.0000	0.0000	0.0000	0.0000;
	2122	2117	0.009917	0.030579	0.003291	120	120	120	0	0	1	-360	360	13.6068	-6.9230	-13.5879	6.5833	0.0000	0.0000	0.0000	0.0000;
	2445	2244	0.024793	0.080083	0.008301	114	114	114	0	0	1	-360	360	16.6503	-2.5400	-16.5932	1.7115	0.0000	0.0000	0.0000	0.0000;
	1954	2446	0.014992	0.031537	0.0031	78	78	78	0	0	1	-360	360	-2.4910	-0.1640	2.4918	-0.2098	0.0000	0.0000	0.0000	0.0000;
	2445	2034	0.042984	0.102479	0.0105	78	78	78	0	0	1	-360	360	-14.6437	1.0853	14.7201	-2.1917	0.0000	0.0000	0.0000	0.0000;
	2110	2114	0.002868	0.009719	0.000963	114	114	114	0	0	1	-360	360	-13.1500	0.2595	13.1541	-0.3620	0.0000	0.0000	0.0000	0.0000;
	2217	1977	0.03719	0.119008	0.012199	114	114	114	0	0	1	-360	360	-3.3677	-5.9612	3.3795	4.5010	0.0000	0.0000	0.0000	0.0000;
	1973	1978	0.064628	0.109917	0.01059	123	123	123	0	0	1	-360	360	21.9693	-6.2160	-21.7018	5.3654	0.0000	0.0000	0.0000	0.0000;
	1977	1970	0.033223	0.056612	0.00545	120	120	120	0	0	1	-360	360	1.7189	-0.4596	-1.7181	-0.2119	0.0000	0.0000	0.0000	0.0000;
	1978	2130	0.017826	0.060207	0.00596	120	120	120	0	0	1	-360	360	7.4979	1.9005	-7.4890	-2.5990	0.0000	0.0000	0.0000	0.0000;
	2263	1978	0.007587	0.025686	0.002541	120	120	120	0	0	1	-360	360	-35.3706	-0.5892	35.4484	0.5422	0.0000	0.0000	0.0000	0.0000;
	2413	2112	0.012091	0.040959	0.004061	120	120	120	0	0	1	-360	360	31.4702	1.3214	-31.3718	-1.4818	0.0000	0.0000	0.0000	0.0000;
	1978	2413	0.006868	0.023256	0.002299	120	120	120	0	0	1	-360	360	31.5260	1.1170	-31.4702	-1.2092	0.0000	0.0000	0.0000	0.0000;
	2313	2413	0.005529	0.009669	0.00092	120	120	120	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.1122	0.0000	0.0000	0.0000	0.0000;
	2082	1977	0.015703	0.049587	0.005111	120	120	120	0	0	1	-360	360	-44.2691	-3.7561	44.5234	3.9323	0.0000	0.0000	0.0000	0.0000;
	2289	1977	0.004132	0.031397	0.003001	137	137	137	0	0	1	-360	360	-12.2022	2.4980	12.2074	-2.8292	0.0000	0.0000	0.0000	0.0000;
	2281	1977	0.065826	0.222983	0.02208	123	123	123	0	0	1	-360	360	-6.3792	-6.4825	6.4160	3.9145	0.0000	0.0000	0.0000	0.0000;
	2265	1978	0.020661	0.066124	0.006781	120	120	120	0	0	1	-360	360	-3.9568	-1.8468	3.9598	1.0269	0.0000	0.0000	0.0000	0.0000;
	2085	2103	0.016421	0.055628	0.00551	123	123	123	0	0	1	-360	360	-3.1410	-1.0919	3.1424	0.4321	0.0000	0.0000	0.0000	0.0000;
	2022	1970	0.012141	0.041124	0.00407	123	123	123	0	0	1	-360	360	-0.8590	-0.5320	0.8591	0.0299	0.0000	0.0000	0.0000	0.0000;
	2076	2419	0.03124	0.102314	0.010481	123	123	123	0	0	1	-360	360	2.6735	0.7885	-2.6712	-2.0465	0.0000	0.0000	0.0000	0.0000;
	1998	1982	0.044207	0.113669	0.01112	91	91	91	0	0	1	-360	360	8.8337	1.8599	-8.8026	-3.1111	0.0000	0.0000	0.0000	0.0000;
	2088	1998	0.010331	0.018017	0.001721	78	78	78	0	0	1	-360	360	21.4939	-1.7984	-21.4542	1.6603	0.0000	0.0000	0.0000	0.0000;
	2431	2160	0.012562	0.021901	0.00212	78	78	78	0	0	1	-360	360	-2.1961	-0.6999	2.1967	0.4394	0.0000	0.0000	0.0000	0.0000;
	2432	2430	0.010083	0.017364	0.001721	78	78	78	0	0	1	-360	360	-1.5016	2.6880	1.5024	-2.8986	0.0000	0.0000	0.0000	0.0000;
	2242	2155	0.02	0.037438	0.003649	78	78	78	0	0	1	-360	360	-6.6606	6.3479	6.6749	-6.7701	0.0000	0.0000	0.0000	0.0000;
	2430	2242	0.007934	0.015372	0.0015	78	78	78	0	0	1	-360	360	-3.9774	4.2866	3.9796	-4.4669	0.0000	0.0000	0.0000	0.0000;
	2432	2431	0.010826	0.018934	0.00181	78	78	78	0	0	1	-360	360	3.2376	-3.0830	-3.2359	2.8629	0.0000	0.0000	0.0000	0.0000;
	2160	2154	0.028182	0.058182	0.0059	78	78	78	0	0	1	-360	360	-5.9027	2.8996	5.9130	-3.6057	0.0000	0.0000	0.0000	0.0000;
	2029	1998	0.057016	0.113314	0.010909	78	78	78	0	0	1	-360	360	-3.4065	2.4233	3.4165	-3.7183	0.0000	0.0000	0.0000	0.0000;
	2285	2154	0.039339	0.129174	0.013201	123	123	123	0	0	1	-360	360	-20.8387	5.0457	20.9884	-6.1803	0.0000	0.0000	0.0000	0.0000;
	2286	2285	0.00595	0.019174	0.00198	123	123	123	0	0	1	-360	360	-17.6848	4.0144	17.7007	-4.2067	0.0000	0.0000	0.0000	0.0000;
	2154	2088	0.036198	0.063388	0.00612	78	78	78	0	0	1	-360	360	30.2760	2.7892	-30.0039	-3.0596	0.0000	0.0000	0.0000	0.0000;
	2286	2426	0.02743	0.088851	0.00915	123	123	123	0	0	1	-360	360	14.7038	-3.9434	-14.6530	2.9828	0.0000	0.0000	0.0000	0.0000;
	2383	2300	0.040331	0.136612	0.01353	123	123	123	0	0	1	-360	360	-5.2238	-2.2359	5.2336	0.6285	0.0000	0.0000	0.0000	0.0000;
	2421	2049	0.01157	0.039421	0.003901	123	123	123	0	0	1	-360	360	-8.1993	-5.3666	8.2083	4.9310	0.0000	0.0000	0.0000	0.0000;
	2029	1935	0.035066	0.118777	0.011761	123	123	123	0	0	1	-360	360	1.4475	-0.6853	-1.4469	-0.7312	0.0000	0.0000	0.0000	0.0000;
	2155	1935	0.041066	0.139091	0.01377	123	123	123	0	0	1	-360	360	22.7995	0.9943	-22.6246	-2.0778	0.0000	0.0000	0.0000	0.0000;
	2193	1962	0.029496	0.050174	0.00484	78	78	78	0	0	1	-360	360	-11.9775	6.6748	12.0242	-7.1817	0.0000	0.0000	0.0000	0.0000;
	2419	2049	0.011322	0.037438	0.0037	123	123	123	0	0	1	-360	360	12.4673	4.7601	-12.4503	-5.1490	0.0000	0.0000	0.0000	0.0000;
	2418	2155	0.014207	0.046612	0.00477	123	123	123	0	0	1	-360	360	-16.6333	-0.9777	16.6655	0.4986	0.0000	0.0000	0.0000	0.0000;
	2418	2300	0.017769	0.058182	0.005951	123	123	123	0	0	1	-360	360	15.8683	0.4897	-15.8316	-1.0955	0.0000	0.0000	0.0000	0.0000;
	2195	2076	0.022686	0.062207	0.00629	78	78	78	0	0	1	-360	360	5.0844	-0.6349	-5.0795	-0.1135	0.0000	0.0000	0.0000	0.0000;
	2155	1957	0.020992	0.069339	0.006989	123	123	123	0	0	1	-360	360	9.8528	-0.8200	-9.8361	0.0174	0.0000	0.0000	0.0000	0.0000;
	1987	1957	0.017107	0.05562	0.004799	123	123	123	0	0	1	-360	360	-9.4167	-0.5522	9.4291	0.0056	0.0000	0.0000	0.0000	0.0000;
	2419	2330	0.024959	0.084463	0.00847	123	123	123	0	0	1	-360	360	-13.1041	-1.2456	13.1398	0.3419	0.0000	0.0000	0.0000	0.0000;
	2383	2303	0.031744	0.107504	0.010641	123	123	123	0	0	1	-360	360	-2.5422	-0.6791	2.5439	-0.6020	0.0000	0.0000	0.0000	0.0000;
	2190	2154	0.02595	0.085124	0.008741	123	123	123	0	0	1	-360	360	-1.4080	0.6020	1.4087	-1.6780	0.0000	0.0000	0.0000	0.0000;
	2195	2193	0.00943	0.018893	0.001849	78	78	78	0	0	1	-360	360	-9.7504	5.7449	9.7605	-5.9488	0.0000	0.0000	0.0000	0.0000;
	2421	1935	0.017686	0.057438	0.00596	123	123	123	0	0	1	-360	360	-21.8502	-4.5236	21.9235	4.0470	0.0000	0.0000	0.0000	0.0000;
	1955	2421	0.052339	0.091554	0.008729	69	69	69	0	0	1	-360	360	-0.0420	-1.4980	0.0424	0.4582	0.0000	0.0000	0.0000	0.0000;
	2665	2720	0.03562	0.109421	0.011461	69	69	69	0	0	1	-360	360	-2.1530	0.0110	2.1545	-1.3712	0.0000	0.0000	0.0000	0.0000;
	2571	2700	0.036777	0.093967	0.009511	120	120	120	0	0	1	-360	360	-25.3310	-0.9151	25.5349	0.3262	0.0000	0.0000	0.0000	0.0000;
	2676	2630	0.002066	0.007273	0.000699	126	126	126	0	0	1	-360	360	1.9248	-2.5112	-1.9246	2.4290	0.0000	0.0000	0.0000	0.0000;
	2630	2476	0.018512	0.059504	0.00627	126	126	126	0	0	1	-360	360	-0.5754	-3.4290	0.5769	2.6902	0.0000	0.0000	0.0000	0.0000;
	2564	2458	0.021	0.067901	0.00696	123	123	123	0	0	1	-360	360	1.5260	0.3527	-1.5254	-1.1600	0.0000	0.0000	0.0000	0.0000;
	2655	2659	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	2.7781	-1.0819	-2.7758	0.3737	0.0000	0.0000	0.0000	0.0000;
	2454	2721	0.066446	0.17719	0.01791	70	70	70	0	0	1	-360	360	-0.9568	-2.5237	0.9585	0.3612	0.0000	0.0000	0.0000	0.0000;
	2650	2721	0.039835	0.129091	0.013145	114	114	114	0	0	1	-360	360	-53.7129	-1.8591	54.7016	3.5015	0.0000	0.0000	0.0000	0.0000;
	2474	2510	0.033802	0.107438	0.011541	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2577	2616	0.020496	0.06876	0.00688	137	137	137	0	0	1	-360	360	10.9577	-1.7132	-10.9354	1.0184	0.0000	0.0000	0.0000	0.0000;
	2555	2520	0.04	0.129587	0.013291	114	114	114	0	0	1	-360	360	-48.8044	-19.0961	49.7891	20.7579	0.0000	0.0000	0.0000	0.0000;
	2525	2612	0.009917	0.033223	0.004189	107	107	107	0	0	1	-360	360	-19.1639	-8.3978	19.2017	8.0461	0.0000	0.0000	0.0000	0.0000;
	2555	2521	0.040248	0.130248	0.013361	107	107	107	0	0	1	-360	360	-48.8574	-19.0856	49.8500	20.7606	0.0000	0.0000	0.0000	0.0000;
	2614	2549	0.035446	0.087364	0.008821	114	114	114	0	0	1	-360	360	33.4264	0.9568	-33.0978	-1.2007	0.0000	0.0000	0.0000	0.0000;
	2723	2722	0.012636	0.038017	0.00273	114	114	114	0	0	1	-360	360	-7.0136	1.7727	7.0192	-2.0873	0.0000	0.0000	0.0000	0.0000;
	2524	2723	0.033058	0.082636	0.00968	69	69	69	0	0	1	-360	360	-6.0030	1.1258	6.0136	-2.2727	0.0000	0.0000	0.0000	0.0000;
	2586	2525	0.046686	0.081818	0.007739	90	90	90	0	0	1	-360	360	9.9519	-2.8025	-9.9092	1.9950	0.0000	0.0000	0.0000	0.0000;
	2479	2470	0.034132	0.059917	0.00566	48	48	48	0	0	1	-360	360	-9.1016	-0.0484	9.1258	-0.5729	0.0000	0.0000	0.0000	0.0000;
	2492	2587	0.035868	0.058678	0.006459	90	90	90	0	0	1	-360	360	-1.7586	-5.4054	1.7677	4.6952	0.0000	0.0000	0.0000	0.0000;
	2492	2499	0.1	0.159496	0.01597	86	86	86	0	0	1	-360	360	-5.9974	-6.6990	6.0597	4.9864	0.0000	0.0000	0.0000	0.0000;
	2696	2600	0.039504	0.128099	0.013141	137	137	137	0	0	1	-360	360	-2.1229	-0.6474	2.1245	-0.8739	0.0000	0.0000	0.0000	0.0000;
	2587	2469	0.03124	0.056033	0.005629	84	84	84	0	0	1	-360	360	-8.5730	-5.4387	8.6007	4.8512	0.0000	0.0000	0.0000	0.0000;
	2707	2489	0.021397	0.068868	0.007081	69	69	69	0	0	1	-360	360	-6.1605	-0.5769	6.1673	-0.2561	0.0000	0.0000	0.0000	0.0000;
	2691	2707	0.016859	0.054273	0.005581	69	69	69	0	0	1	-360	360	-4.6574	-0.8476	4.6605	0.1853	0.0000	0.0000	0.0000	0.0000;
	2613	2707	0.000256	0.000661	7e-05	69	69	69	0	0	1	-360	360	-1.5000	-0.4000	1.5000	0.3916	0.0000	0.0000	0.0000	0.0000;
	2478	2477	0.012231	0.038603	0.004201	30	30	30	0	0	1	-360	360	3.5017	1.5402	-3.5000	-2.0000	0.0000	0.0000	0.0000	0.0000;
	2603	2485	0.028827	0.093223	0.009564	69	69	69	0	0	1	-360	360	-14.6863	1.4453	14.7423	-2.3482	0.0000	0.0000	0.0000	0.0000;
	2650	2482	0.01824	0.058992	0.00605	123	123	123	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2525	2675	0.024554	0.079917	0.00823	137	137	137	0	0	1	-360	360	13.2814	2.9458	-13.2409	-3.7449	0.0000	0.0000	0.0000	0.0000;
	2470	2689	0.06843	0.09157	0.0084	69	69	69	0	0	1	-360	360	-3.0376	0.5037	3.0435	-1.4842	0.0000	0.0000	0.0000	0.0000;
	2689	2720	0.086529	0.11405	0.010191	57	57	57	0	0	1	-360	360	-7.5435	-0.5158	7.5853	-0.6361	0.0000	0.0000	0.0000	0.0000;
	2572	2551	0.007851	0.019826	0.00203	120	120	120	0	0	1	-360	360	-25.6046	0.8166	25.6485	-0.9446	0.0000	0.0000	0.0000	0.0000;
	2610	2632	0.010331	0.026529	0.002691	109	109	109	0	0	1	-360	360	2.7877	2.1910	-2.7865	-2.5043	0.0000	0.0000	0.0000	0.0000;
	2589	2610	0.022314	0.057016	0.00576	120	120	120	0	0	1	-360	360	-2.8000	-1.0000	2.8016	0.3272	0.0000	0.0000	0.0000	0.0000;
	2588	2648	0.030992	0.079008	0.00801	120	120	120	0	0	1	-360	360	-1.5000	-0.6000	1.5006	-0.3785	0.0000	0.0000	0.0000	0.0000;
	2452	2554	0.002636	0.007521	0.00075	120	120	120	0	0	1	-360	360	3.4016	-1.6447	-3.4013	1.5536	0.0000	0.0000	0.0000	0.0000;
	2546	2528	0.030248	0.06281	0.00061	99	99	99	0	0	1	-360	360	-22.2806	-0.9285	22.4048	1.1119	0.0000	0.0000	0.0000	0.0000;
	2527	2459	0.003314	0.010826	0.001089	137	137	137	0	0	1	-360	360	-0.3387	0.3500	0.3387	-0.4833	0.0000	0.0000	0.0000	0.0000;
	2537	2529	0.04124	0.072314	0.00687	69	69	69	0	0	1	-360	360	-16.0500	0.6261	16.1378	-1.3107	0.0000	0.0000	0.0000	0.0000;
	2527	2467	0.018603	0.056198	0.00581	81	81	81	0	0	1	-360	360	-5.1613	-1.3500	5.1655	0.6506	0.0000	0.0000	0.0000	0.0000;
	2584	2605	0.024793	0.08	0.00823	137	137	137	0	0	1	-360	360	-9.3262	2.4551	9.3456	-3.4014	0.0000	0.0000	0.0000	0.0000;
	2452	2648	0.01314	0.041818	0.004479	137	137	137	0	0	1	-360	360	5.3036	0.0824	-5.3006	-0.6215	0.0000	0.0000	0.0000	0.0000;
	2647	2609	0.009421	0.030661	0.003151	103	103	103	0	0	1	-360	360	-23.2447	-10.0227	23.2962	9.8214	0.0000	0.0000	0.0000	0.0000;
	2647	2579	0.029008	0.09438	0.009661	76	76	76	0	0	1	-360	360	-2.7563	2.6699	2.7608	-3.7792	0.0000	0.0000	0.0000	0.0000;
	2465	2529	0.004207	0.010578	0.00106	120	120	120	0	0	1	-360	360	-12.8401	-2.8965	12.8461	2.7815	0.0000	0.0000	0.0000	0.0000;
	2709	2528	0.007364	0.023802	0.002439	90	90	90	0	0	1	-360	360	-2.5974	-2.6690	2.5981	2.3726	0.0000	0.0000	0.0000	0.0000;
	2709	2452	0.00157	0.004959	0.000511	137	137	137	0	0	1	-360	360	-15.2013	-4.1655	15.2045	4.1130	0.0000	0.0000	0.0000	0.0000;
	2709	2452	0.00157	0.004959	0.000511	137	137	137	0	0	1	-360	360	-15.2013	-4.1655	15.2045	4.1130	0.0000	0.0000	0.0000	0.0000;
	2459	2465	0.003058	0.009917	0.001019	137	137	137	0	0	1	-360	360	-7.3387	-1.5167	7.3401	1.3965	0.0000	0.0000	0.0000	0.0000;
	2583	2572	0.008256	0.026281	0.00286	69	69	69	0	0	1	-360	360	-12.2047	-0.7891	12.2153	0.4870	0.0000	0.0000	0.0000	0.0000;
	2510	2583	0.018099	0.057016	0.0062	69	69	69	0	0	1	-360	360	-5.5000	-1.0000	5.5047	0.2891	0.0000	0.0000	0.0000	0.0000;
	2554	2529	0.00405	0.010578	0.001089	95	95	95	0	0	1	-360	360	-2.5987	-2.5536	2.5992	2.4212	0.0000	0.0000	0.0000	0.0000;
	2456	2452	0.002314	0.007521	0.00077	137	137	137	0	0	1	-360	360	-17.8793	-4.4978	17.8857	4.4244	0.0000	0.0000	0.0000	0.0000;
	2643	2456	0.003967	0.012984	0.001309	137	137	137	0	0	1	-360	360	-13.8727	-3.6362	13.8793	3.4978	0.0000	0.0000	0.0000	0.0000;
	2544	2537	0.008099	0.014207	0.00136	57	57	57	0	0	1	-360	360	-16.0328	0.4913	16.0500	-0.6261	0.0000	0.0000	0.0000	0.0000;
	2653	2544	0.064711	0.113388	0.010769	57	57	57	0	0	1	-360	360	-11.4604	1.1188	11.5328	-2.2913	0.0000	0.0000	0.0000	0.0000;
	2475	2653	0.066612	0.113058	0.01118	69	69	69	0	0	1	-360	360	-15.6957	-1.9584	15.8360	0.8673	0.0000	0.0000	0.0000	0.0000;
	2631	2546	0.013223	0.033058	0.003269	114	114	114	0	0	1	-360	360	-18.3438	-0.0316	18.3806	-0.2715	0.0000	0.0000	0.0000	0.0000;
	2720	2631	0.05686	0.093388	0.00944	114	114	114	0	0	1	-360	360	-14.7399	0.0072	14.8438	-0.9684	0.0000	0.0000	0.0000	0.0000;
	2676	2528	0.037603	0.121653	0.01249	80	80	80	0	0	1	-360	360	-29.9248	-8.4888	30.2283	7.9658	0.0000	0.0000	0.0000	0.0000;
	2687	2579	0.030579	0.053719	0.00508	78	78	78	0	0	1	-360	360	-5.8000	-1.5000	5.8093	0.9277	0.0000	0.0000	0.0000	0.0000;
	2610	2530	0.008512	0.020744	0.002321	114	114	114	0	0	1	-360	360	-30.8046	-0.9683	30.8734	0.8622	0.0000	0.0000	0.0000	0.0000;
	2530	2673	0.040496	0.096686	0.010159	120	120	120	0	0	1	-360	360	-38.8734	-1.8622	39.3918	1.8814	0.0000	0.0000	0.0000	0.0000;
	2464	2643	0.001983	0.006281	0.000651	137	137	137	0	0	1	-360	360	-4.3723	-0.9147	4.3727	0.8362	0.0000	0.0000	0.0000	0.0000;
	2451	2464	0.006529	0.021157	0.0022	137	137	137	0	0	1	-360	360	1.6279	0.8170	-1.6277	-1.0853	0.0000	0.0000	0.0000	0.0000;
	2632	2572	0.009256	0.023802	0.00242	120	120	120	0	0	1	-360	360	-3.7135	1.0043	3.7147	-1.2854	0.0000	0.0000	0.0000	0.0000;
	2717	2609	0.062231	0.104132	0.010721	63	63	63	0	0	1	-360	360	-8.9012	-0.4611	8.9435	-0.7231	0.0000	0.0000	0.0000	0.0000;
	2535	2717	0.047017	0.078512	0.00808	69	69	69	0	0	1	-360	360	-1.7000	-0.6000	1.7012	-0.3389	0.0000	0.0000	0.0000	0.0000;
	2470	2475	0.005446	0.007603	0.00077	69	69	69	0	0	1	-360	360	-11.6893	-0.5401	11.6957	0.4584	0.0000	0.0000	0.0000	0.0000;
	2609	2572	0.016198	0.033802	0.003509	90	90	90	0	0	1	-360	360	-0.6735	2.6082	0.6747	-3.0182	0.0000	0.0000	0.0000	0.0000;
	2625	2466	0.007917	0.025612	0.005261	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2647	2625	0.02781	0.089942	0.01845	114	114	114	0	0	1	-360	360	2.0010	-1.6472	-2.0000	-0.5000	0.0000	0.0000	0.0000	0.0000;
	2451	2467	0.013967	0.044628	0.00462	126	126	126	0	0	1	-360	360	-8.6279	-2.8170	8.6371	2.2807	0.0000	0.0000	0.0000	0.0000;
	2605	2466	0.008678	0.028099	0.00295	88	88	88	0	0	1	-360	360	-15.3456	1.8014	15.3626	-2.1083	0.0000	0.0000	0.0000	0.0000;
	2642	2653	0.016066	0.052793	0.01083	69	69	69	0	0	1	-360	360	7.8850	2.1128	-7.8757	-3.3860	0.0000	0.0000	0.0000	0.0000;
	2627	2642	0.034	0.10995	0.022559	69	69	69	0	0	1	-360	360	9.5110	0.2638	-9.4850	-2.9128	0.0000	0.0000	0.0000	0.0000;
	2496	2528	0.00562	0.018934	0.00189	32	32	32	0	0	1	-360	360	-13.0000	-5.0000	13.0089	4.7984	0.0000	0.0000	0.0000	0.0000;
	2497	2529	0.00562	0.018934	0.00189	32	32	32	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.2318	0.0000	0.0000	0.0000	0.0000;
	2710	2452	0.002149	0.00719	0.000721	57	57	57	0	0	1	-360	360	-2.0000	-0.5000	2.0001	0.4119	0.0000	0.0000	0.0000	0.0000;
	2639	2529	0.000909	0.003058	0.00031	46	46	46	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0380	0.0000	0.0000	0.0000	0.0000;
	2549	2551	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	29.6978	0.0007	-29.6485	-0.0554	0.0000	0.0000	0.0000	0.0000;
	2678	2467	0.020496	0.06876	0.00688	137	137	137	0	0	1	-360	360	-13.0302	-0.8461	13.0588	0.0995	0.0000	0.0000	0.0000	0.0000;
	2463	2470	0.037397	0.120661	0.01272	140	140	140	0	0	1	-360	360	-1.9000	-0.7000	1.9012	-0.7907	0.0000	0.0000	0.0000	0.0000;
	2678	2627	0.019281	0.062364	0.006398	137	137	137	0	0	1	-360	360	11.0302	-0.0539	-11.0110	-0.6638	0.0000	0.0000	0.0000	0.0000;
	2488	2703	0.004959	0.016364	0.00166	114	114	114	0	0	1	-360	360	-36.1573	3.7784	36.2120	-3.7975	0.0000	0.0000	0.0000	0.0000;
	2701	2488	0.001653	0.005372	0.000542	114	114	114	0	0	1	-360	360	-32.0426	6.1611	32.0573	-6.1784	0.0000	0.0000	0.0000	0.0000;
	2533	2702	0.057686	0.145446	0.014999	76	76	76	0	0	1	-360	360	-26.1015	6.4755	26.4574	-7.3738	0.0000	0.0000	0.0000	0.0000;
	2567	2703	0.031983	0.07876	0.00786	90	90	90	0	0	1	-360	360	-46.1642	6.6007	46.7541	-6.0854	0.0000	0.0000	0.0000	0.0000;
	2699	2702	0.01843	0.06	0.006149	137	137	137	0	0	1	-360	360	-32.0376	9.3675	32.2095	-9.5470	0.0000	0.0000	0.0000	0.0000;
	2683	2684	0.005537	0.017934	0.001839	137	137	137	0	0	1	-360	360	-5.2781	1.3288	5.2795	-1.5434	0.0000	0.0000	0.0000	0.0000;
	2586	2457	0.036364	0.120661	0.01181	114	114	114	0	0	1	-360	360	-16.6519	-0.1975	16.7402	-0.8657	0.0000	0.0000	0.0000	0.0000;
	2684	2680	0.003058	0.009917	0.001019	114	114	114	0	0	1	-360	360	3.3090	-10.9503	-3.3057	10.8396	0.0000	0.0000	0.0000	0.0000;
	2511	2567	0.067603	0.119008	0.0112	69	69	69	0	0	1	-360	360	-14.3699	6.4123	14.5169	-7.4763	0.0000	0.0000	0.0000	0.0000;
	2693	2511	0.038678	0.068099	0.006389	69	69	69	0	0	1	-360	360	-10.9108	7.4620	10.9699	-8.1123	0.0000	0.0000	0.0000	0.0000;
	2628	2567	0.050422	0.104868	0.0102	69	69	69	0	0	1	-360	360	-23.8968	2.0490	24.1473	-2.7244	0.0000	0.0000	0.0000	0.0000;
	2645	2628	0.01976	0.051397	0.00515	69	69	69	0	0	1	-360	360	-23.7000	1.8035	23.7968	-2.1490	0.0000	0.0000	0.0000	0.0000;
	2570	2522	0.02781	0.079678	0.008071	69	69	69	0	0	1	-360	360	9.8417	-10.7767	-9.7941	9.9525	0.0000	0.0000	0.0000	0.0000;
	2693	2570	0.014669	0.032388	0.003279	69	69	69	0	0	1	-360	360	11.6710	-10.2000	-11.6417	9.8767	0.0000	0.0000	0.0000	0.0000;
	2462	2526	0.022314	0.072314	0.014929	75	75	75	0	0	1	-360	360	-4.7037	-9.7166	4.7231	8.0405	0.0000	0.0000	0.0000	0.0000;
	2457	2462	0.013223	0.017769	0.001909	62	62	62	0	0	1	-360	360	-0.6954	-8.6260	0.7037	8.4166	0.0000	0.0000	0.0000	0.0000;
	2677	2522	0.008835	0.027917	0.003049	137	137	137	0	0	1	-360	360	-11.9415	-1.7874	11.9522	1.4572	0.0000	0.0000	0.0000	0.0000;
	2509	2677	0.006876	0.021579	0.002398	137	137	137	0	0	1	-360	360	-10.1354	-1.4543	10.1415	1.1874	0.0000	0.0000	0.0000	0.0000;
	2624	2686	0.015537	0.054554	0.005571	137	137	137	0	0	1	-360	360	-6.9109	3.2693	6.9188	-3.9032	0.0000	0.0000	0.0000	0.0000;
	2487	2640	0.008512	0.021744	0.0022	120	120	120	0	0	1	-360	360	22.5354	-7.4065	-22.4954	7.2470	0.0000	0.0000	0.0000	0.0000;
	2640	2684	0.00281	0.007017	0.00059	114	114	114	0	0	1	-360	360	13.3954	-10.5470	-13.3885	10.4937	0.0000	0.0000	0.0000	0.0000;
	2474	2698	0.027686	0.089504	0.009169	95	95	95	0	0	1	-360	360	-24.4567	0.0198	24.5960	-0.6657	0.0000	0.0000	0.0000	0.0000;
	2686	2474	0.021322	0.069421	0.007069	137	137	137	0	0	1	-360	360	-14.2188	2.5032	14.2567	-3.2198	0.0000	0.0000	0.0000	0.0000;
	2698	2704	0.015041	0.041322	0.004259	90	90	90	0	0	1	-360	360	-15.2469	10.7541	15.2912	-11.1436	0.0000	0.0000	0.0000	0.0000;
	2685	2683	0.017769	0.057364	0.005881	137	137	137	0	0	1	-360	360	0.7435	-2.3799	-0.7428	1.6823	0.0000	0.0000	0.0000	0.0000;
	2646	2520	0.007364	0.023802	0.00251	114	114	114	0	0	1	-360	360	-11.3220	-1.1144	11.3299	0.8404	0.0000	0.0000	0.0000	0.0000;
	2665	2578	0.004207	0.010744	0.00121	114	114	114	0	0	1	-360	360	-8.5135	-0.7716	8.5161	0.6341	0.0000	0.0000	0.0000	0.0000;
	2457	2645	0.023314	0.078934	0.007451	69	69	69	0	0	1	-360	360	-18.2291	3.8828	18.3000	-4.5035	0.0000	0.0000	0.0000	0.0000;
	2665	2519	0.002727	0.008256	0.000849	120	120	120	0	0	1	-360	360	0.4648	0.7884	-0.4648	-0.8895	0.0000	0.0000	0.0000	0.0000;
	2519	2509	0.001488	0.004959	0.000479	137	137	137	0	0	1	-360	360	-4.4352	-0.5105	4.4354	0.4543	0.0000	0.0000	0.0000	0.0000;
	2476	2522	0.028678	0.092562	0.009511	57	57	57	0	0	1	-360	360	-4.1769	-3.5902	4.1833	2.4774	0.0000	0.0000	0.0000	0.0000;
	2487	2533	0.013636	0.035537	0.0037	120	120	120	0	0	1	-360	360	-22.8354	7.2065	22.9015	-7.4755	0.0000	0.0000	0.0000	0.0000;
	2683	2680	0.004207	0.013554	0.001401	131	131	131	0	0	1	-360	360	-4.5798	-6.1406	4.5818	5.9801	0.0000	0.0000	0.0000	0.0000;
	2624	2685	0.005289	0.010744	0.001111	90	90	90	0	0	1	-360	360	1.6439	-2.2113	-1.6435	2.0799	0.0000	0.0000	0.0000	0.0000;
	2704	2701	0.009339	0.016529	0.00174	90	90	90	0	0	1	-360	360	-24.3912	7.9436	24.4426	-8.0611	0.0000	0.0000	0.0000	0.0000;
	2703	2560	0.034793	0.10281	0.01045	99	99	99	0	0	1	-360	360	-23.7306	6.3920	23.9079	-7.1261	0.0000	0.0000	0.0000	0.0000;
	2559	2521	0.02124	0.068603	0.00704	99	99	99	0	0	1	-360	360	-21.3278	-8.0687	21.4205	7.5330	0.0000	0.0000	0.0000	0.0000;
	2526	2520	0.031397	0.098843	0.01074	126	126	126	0	0	1	-360	360	-8.9231	-9.5405	8.9657	8.4030	0.0000	0.0000	0.0000	0.0000;
	2561	2680	0.008512	0.02686	0.002899	40	40	40	0	0	1	-360	360	-10.1857	-0.9965	10.1932	0.6744	0.0000	0.0000	0.0000	0.0000;
	2556	2561	0.018099	0.057016	0.0062	40	40	40	0	0	1	-360	360	-10.1697	-1.6827	10.1857	0.9965	0.0000	0.0000	0.0000	0.0000;
	2473	2680	0.01719	0.057769	0.005779	69	69	69	0	0	1	-360	360	-6.5361	-2.6031	6.5430	1.9382	0.0000	0.0000	0.0000	0.0000;
	2562	2702	0.015793	0.040174	0.00408	102	102	102	0	0	1	-360	360	77.8485	-20.3332	-77.0047	21.9875	0.0000	0.0000	0.0000	0.0000;
	2612	2559	0.033636	0.107438	0.010159	107	107	107	0	0	1	-360	360	-19.3017	-8.1461	19.4278	7.3687	0.0000	0.0000	0.0000	0.0000;
	2646	2578	0.008256	0.016529	0.001941	114	114	114	0	0	1	-360	360	9.2220	0.6144	-9.2161	-0.8341	0.0000	0.0000	0.0000	0.0000;
	2698	2713	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	29.8386	6.7703	-29.8000	-6.8000	0.0000	0.0000	0.0000	0.0000;
	2698	2714	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	32.0441	6.4785	-32.0000	-6.5000	0.0000	0.0000	0.0000	0.0000;
	2515	2680	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0872	0.0000	0.0000	0.0000	0.0000;
	2516	2681	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	-0.3000	-0.2000	0.3000	0.1128	0.0000	0.0000	0.0000	0.0000;
	2688	2683	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	-3.7913	-1.1192	3.7919	1.0331	0.0000	0.0000	0.0000	0.0000;
	2690	2624	0.025405	0.082157	0.008429	123	123	123	0	0	1	-360	360	-3.3645	0.1643	3.3670	-1.1579	0.0000	0.0000	0.0000	0.0000;
	2690	2473	0.016364	0.052893	0.005581	122	122	122	0	0	1	-360	360	1.9645	-1.0643	-1.9639	0.4031	0.0000	0.0000	0.0000	0.0000;
	2556	2693	0.020413	0.06843	0.006851	123	123	123	0	0	1	-360	360	7.3697	0.3827	-7.3602	-1.1620	0.0000	0.0000	0.0000	0.0000;
	2688	2683	0.009917	0.034876	0.00407	76	76	76	0	0	1	-360	360	-0.8087	-0.7808	0.8088	0.2963	0.0000	0.0000	0.0000	0.0000;
	2700	2665	0.020174	0.052231	0.00545	120	120	120	0	0	1	-360	360	-29.5349	-1.8262	29.6848	1.5689	0.0000	0.0000	0.0000	0.0000;
	2665	2521	0.009504	0.024554	0.00256	114	114	114	0	0	1	-360	360	-22.4831	-2.1967	22.5238	1.9962	0.0000	0.0000	0.0000	0.0000;
	2669	2654	0.01405	0.023141	0.00234	90	90	90	0	0	1	-360	360	-11.6114	1.9482	11.6277	-2.2022	0.0000	0.0000	0.0000	0.0000;
	2662	2664	0.03286	0.076678	0.00771	69	69	69	0	0	1	-360	360	10.6346	-1.7258	-10.6033	0.8727	0.0000	0.0000	0.0000	0.0000;
	2659	2661	0.042231	0.098959	0.00974	69	69	69	0	0	1	-360	360	-0.7242	-1.3737	0.7246	0.2033	0.0000	0.0000	0.0000	0.0000;
	2663	2721	0.073058	0.191901	0.018319	69	69	69	0	0	1	-360	360	-6.4899	-2.3269	6.5165	0.1877	0.0000	0.0000	0.0000	0.0000;
	2664	2590	0.030909	0.081066	0.007739	69	69	69	0	0	1	-360	360	-6.1284	-2.1619	6.1388	1.2589	0.0000	0.0000	0.0000	0.0000;
	2590	2722	0.042066	0.110744	0.010529	69	69	69	0	0	1	-360	360	-6.8388	-1.5589	6.8555	0.3294	0.0000	0.0000	0.0000	0.0000;
	2660	2663	0.016529	0.033058	0.00242	69	69	69	0	0	1	-360	360	-20.7757	-0.6813	20.8357	0.5119	0.0000	0.0000	0.0000	0.0000;
	2564	2483	0.040496	0.071066	0.00673	90	90	90	0	0	1	-360	360	-14.1069	-1.1934	14.1764	0.5282	0.0000	0.0000	0.0000	0.0000;
	2483	2660	0.046281	0.071066	0.007599	78	78	78	0	0	1	-360	360	-15.8764	-0.9282	15.9757	0.1813	0.0000	0.0000	0.0000	0.0000;
	2663	2669	0.004959	0.008256	0.000849	78	78	78	0	0	1	-360	360	-7.1090	2.8504	7.1114	-2.9482	0.0000	0.0000	0.0000	0.0000;
	2565	2564	0.004132	0.013719	0.001379	137	137	137	0	0	1	-360	360	-6.7793	-0.0957	6.7810	-0.0593	0.0000	0.0000	0.0000	0.0000;
	2661	2691	0.013364	0.029686	0.00296	69	69	69	0	0	1	-360	360	1.3428	-0.2033	-1.3426	-0.1524	0.0000	0.0000	0.0000	0.0000;
	2654	2662	0.008678	0.027769	0.004777	69	69	69	0	0	1	-360	360	-17.5277	0.7022	17.5500	-1.2054	0.0000	0.0000	0.0000	0.0000;
	2574	2722	0.04438	0.078256	0.007391	46	46	46	0	0	1	-360	360	-7.9171	-0.0930	7.9402	-0.7605	0.0000	0.0000	0.0000	0.0000;
	2604	2574	0.056612	0.099826	0.009431	46	46	46	0	0	1	-360	360	-4.4079	-0.2127	4.4171	-0.9070	0.0000	0.0000	0.0000	0.0000;
	2468	2604	0.019752	0.062149	0.006749	90	90	90	0	0	1	-360	360	-3.4060	-0.6176	3.4079	-0.1873	0.0000	0.0000	0.0000	0.0000;
	2498	2468	0.036686	0.064711	0.00611	90	90	90	0	0	1	-360	360	-0.2060	-0.3512	0.2060	-0.3824	0.0000	0.0000	0.0000	0.0000;
	2484	2664	0.035868	0.071322	0.006241	38	38	38	0	0	1	-360	360	-0.5943	0.9000	0.5948	-1.6474	0.0000	0.0000	0.0000	0.0000;
	2696	2565	0.03438	0.060992	0.005689	137	137	137	0	0	1	-360	360	-2.7771	-0.2526	2.7793	-0.4043	0.0000	0.0000	0.0000	0.0000;
	2498	2484	0.035868	0.071322	0.006241	90	90	90	0	0	1	-360	360	-0.5940	0.2512	0.5943	-1.0000	0.0000	0.0000	0.0000	0.0000;
	2482	2523	0.020397	0.06595	0.006771	90	90	90	0	0	1	-360	360	-1.3000	-0.2000	1.3003	-0.5908	0.0000	0.0000	0.0000	0.0000;
	2479	2523	0.014554	0.047471	0.00483	120	120	120	0	0	1	-360	360	3.1016	-0.9516	-3.1003	0.3908	0.0000	0.0000	0.0000	0.0000;
	2502	2611	0.006612	0.015703	0.001689	103	103	103	0	0	1	-360	360	-2.3407	1.9166	2.3413	-2.1091	0.0000	0.0000	0.0000	0.0000;
	2507	2471	0.009826	0.017364	0.0016	137	137	137	0	0	1	-360	360	-16.8981	-5.7041	16.9254	5.5693	0.0000	0.0000	0.0000	0.0000;
	2471	2503	0.030248	0.097521	0.010019	86	86	86	0	0	1	-360	360	-7.9405	0.1727	7.9572	-1.2696	0.0000	0.0000	0.0000	0.0000;
	2539	2504	0.011488	0.034711	0.002931	120	120	120	0	0	1	-360	360	-17.7296	-1.2861	17.7613	1.0455	0.0000	0.0000	0.0000	0.0000;
	2697	2539	0.008256	0.028934	0.00363	120	120	120	0	0	1	-360	360	-12.4184	-1.2618	12.4296	0.8861	0.0000	0.0000	0.0000	0.0000;
	2568	2499	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-5.9799	-3.3965	5.9804	3.3534	0.0000	0.0000	0.0000	0.0000;
	2568	2580	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	2.5001	0.7555	-2.5000	-0.8000	0.0000	0.0000	0.0000	0.0000;
	2568	2580	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	2.5001	0.7555	-2.5000	-0.8000	0.0000	0.0000	0.0000	0.0000;
	2506	2697	0.010826	0.034711	0.003579	137	137	137	0	0	1	-360	360	-4.7162	0.6364	4.7184	-1.0382	0.0000	0.0000	0.0000	0.0000;
	2514	2506	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-4.8853	-2.4357	4.8856	2.3923	0.0000	0.0000	0.0000	0.0000;
	2672	2514	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	1.1148	0.4198	-1.1147	-0.4643	0.0000	0.0000	0.0000	0.0000;
	2507	2672	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	5.1151	1.9764	-5.1148	-2.0198	0.0000	0.0000	0.0000	0.0000;
	2471	2718	0.036686	0.118182	0.01217	95	95	95	0	0	1	-360	360	-6.4201	-5.1176	6.4395	3.7748	0.0000	0.0000	0.0000	0.0000;
	2695	2718	0.017364	0.05686	0.005779	137	137	137	0	0	1	-360	360	-12.5043	-5.4670	12.5319	4.8884	0.0000	0.0000	0.0000	0.0000;
	2679	2500	0.032479	0.108099	0.01445	137	137	137	0	0	1	-360	360	-0.7369	-4.4585	0.7408	2.8106	0.0000	0.0000	0.0000	0.0000;
	2668	2499	0.054554	0.180174	0.0242	99	99	99	0	0	1	-360	360	-17.7873	-4.6475	17.9470	2.4314	0.0000	0.0000	0.0000	0.0000;
	2501	2503	0.019174	0.02595	0.004671	69	69	69	0	0	1	-360	360	2.7508	-0.3391	-2.7495	-0.1968	0.0000	0.0000	0.0000	0.0000;
	2611	2504	0.01405	0.036364	0.003991	103	103	103	0	0	1	-360	360	-8.9413	-0.4909	8.9511	0.0580	0.0000	0.0000	0.0000	0.0000;
	2636	2503	0.035868	0.090083	0.00924	114	114	114	0	0	1	-360	360	-11.1473	-0.8864	11.1864	-0.0744	0.0000	0.0000	0.0000	0.0000;
	2708	2504	0.015	0.047141	0.004661	114	114	114	0	0	1	-360	360	-7.2344	-0.8838	7.2413	0.3702	0.0000	0.0000	0.0000	0.0000;
	2666	2708	0.005248	0.016504	0.001631	114	114	114	0	0	1	-360	360	-5.1331	-0.7750	5.1344	0.5918	0.0000	0.0000	0.0000	0.0000;
	2705	2708	0.000256	0.000661	7e-05	114	114	114	0	0	1	-360	360	-2.1000	-0.3000	2.1000	0.2920	0.0000	0.0000	0.0000	0.0000;
	2637	2694	0.041744	0.073223	0.006921	90	90	90	0	0	1	-360	360	-1.2167	-1.9786	1.2182	1.1854	0.0000	0.0000	0.0000	0.0000;
	2694	2719	0.023058	0.07438	0.00765	137	137	137	0	0	1	-360	360	-11.1182	-4.3854	11.1460	3.5904	0.0000	0.0000	0.0000	0.0000;
	2506	2682	0.000992	0.003471	0.000361	137	137	137	0	0	1	-360	360	2.6597	-2.4647	-2.6596	2.4239	0.0000	0.0000	0.0000	0.0000;
	2619	2666	0.003636	0.010744	0.00106	114	114	114	0	0	1	-360	360	2.3670	0.4040	-2.3669	-0.5250	0.0000	0.0000	0.0000	0.0000;
	2501	2623	0.004628	0.014876	0.00152	137	137	137	0	0	1	-360	360	17.1847	4.7852	-17.1719	-4.9188	0.0000	0.0000	0.0000	0.0000;
	2513	2636	0.003719	0.009339	0.000939	120	120	120	0	0	1	-360	360	-5.6463	-0.2910	5.6473	0.1864	0.0000	0.0000	0.0000	0.0000;
	2507	2513	0.004959	0.012727	0.00128	95	95	95	0	0	1	-360	360	1.3539	1.4633	-1.3537	-1.6090	0.0000	0.0000	0.0000	0.0000;
	2480	2568	0.011157	0.015289	0.002749	114	114	114	0	0	1	-360	360	2.3211	-2.1003	-2.3202	1.7855	0.0000	0.0000	0.0000	0.0000;
	2503	2480	0.011157	0.015289	0.002749	114	114	114	0	0	1	-360	360	7.2265	-1.8091	-7.2211	1.5003	0.0000	0.0000	0.0000	0.0000;
	2504	2667	0.014959	0.043802	0.00445	114	114	114	0	0	1	-360	360	3.4987	-0.1211	-3.4971	-0.3857	0.0000	0.0000	0.0000	0.0000;
	2505	2500	0.007603	0.019826	0.002059	120	120	120	0	0	1	-360	360	-10.9052	-3.5079	10.9138	3.2931	0.0000	0.0000	0.0000	0.0000;
	2576	2504	0.034793	0.111901	0.011761	76	76	76	0	0	1	-360	360	-0.3749	-2.8742	0.3764	1.5299	0.0000	0.0000	0.0000	0.0000;
	2679	2576	0.007017	0.022397	0.002369	123	123	123	0	0	1	-360	360	5.9272	-0.7385	-5.9251	0.4742	0.0000	0.0000	0.0000	0.0000;
	2617	2674	0.00843	0.021488	0.002161	120	120	120	0	0	1	-360	360	-16.0058	2.6051	16.0252	-2.8036	0.0000	0.0000	0.0000	0.0000;
	2679	2617	0.00843	0.021488	0.002161	120	120	120	0	0	1	-360	360	-14.1903	2.8970	14.2058	-3.1051	0.0000	0.0000	0.0000	0.0000;
	2566	2571	0.019917	0.052446	0.005191	120	120	120	0	0	1	-360	360	-19.5641	1.6618	19.6310	-2.0849	0.0000	0.0000	0.0000	0.0000;
	2674	2566	0.011868	0.03176	0.003151	120	120	120	0	0	1	-360	360	-19.3252	1.4036	19.3641	-1.6618	0.0000	0.0000	0.0000	0.0000;
	2622	2501	0.005041	0.016859	0.00174	137	137	137	0	0	1	-360	360	-5.5876	-0.1671	5.5889	-0.0287	0.0000	0.0000	0.0000	0.0000;
	2449	2501	0.003314	0.010909	0.001111	137	137	137	0	0	1	-360	360	1.3257	1.2188	-1.3256	-1.3464	0.0000	0.0000	0.0000	0.0000;
	2667	2629	0.007769	0.024793	0.00257	137	137	137	0	0	1	-360	360	3.3971	0.3857	-3.3963	-0.6782	0.0000	0.0000	0.0000	0.0000;
	2591	2472	0.007107	0.023141	0.00234	124	124	124	0	0	1	-360	360	-9.7422	-4.6425	9.7493	4.3978	0.0000	0.0000	0.0000	0.0000;
	2623	2592	0.003058	0.009917	0.001019	137	137	137	0	0	1	-360	360	12.0719	3.6188	-12.0676	-3.7220	0.0000	0.0000	0.0000	0.0000;
	2641	2637	0.006446	0.020661	0.00213	137	137	137	0	0	1	-360	360	1.7839	-3.5055	-1.7831	3.2638	0.0000	0.0000	0.0000	0.0000;
	2633	2499	0.00124	0.004132	0.000409	137	137	137	0	0	1	-360	360	-11.4146	1.2970	11.4161	-1.3393	0.0000	0.0000	0.0000	0.0000;
	2634	2500	0.00124	0.004132	0.000409	137	137	137	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0472	0.0000	0.0000	0.0000	0.0000;
	2500	2502	0.020744	0.067273	0.00682	137	137	137	0	0	1	-360	360	8.1560	1.6498	-8.1432	-2.3931	0.0000	0.0000	0.0000	0.0000;
	2633	2518	0.005446	0.017364	0.001769	137	137	137	0	0	1	-360	360	-3.9854	-0.1970	3.9861	-0.0040	0.0000	0.0000	0.0000	0.0000;
	2500	2449	0.006124	0.015703	0.001571	120	120	120	0	0	1	-360	360	9.4305	1.3501	-9.4257	-1.5188	0.0000	0.0000	0.0000	0.0000;
	2598	2502	0.001322	0.004207	0.00044	137	137	137	0	0	1	-360	360	-0.1829	1.2021	0.1829	-1.2526	0.0000	0.0000	0.0000	0.0000;
	2499	2598	0.007934	0.022314	0.002149	123	123	123	0	0	1	-360	360	6.5207	2.9654	-6.5171	-3.2021	0.0000	0.0000	0.0000	0.0000;
	2518	2622	0.009091	0.028934	0.002899	137	137	137	0	0	1	-360	360	-4.2861	-0.0960	4.2876	-0.2329	0.0000	0.0000	0.0000	0.0000;
	2629	2670	0.007364	0.023719	0.00242	137	137	137	0	0	1	-360	360	-2.1037	-0.7218	2.1040	0.4449	0.0000	0.0000	0.0000	0.0000;
	2472	2641	0.003314	0.010744	0.001089	137	137	137	0	0	1	-360	360	7.3855	-1.5251	-7.3839	1.4055	0.0000	0.0000	0.0000	0.0000;
	2682	2541	0.002066	0.006942	0.000699	137	137	137	0	0	1	-360	360	-0.3404	-3.4239	0.3406	3.3448	0.0000	0.0000	0.0000	0.0000;
	2695	2637	0.011322	0.036364	0.003751	137	137	137	0	0	1	-360	360	5.0043	3.8670	-5.0002	-4.2852	0.0000	0.0000	0.0000	0.0000;
	2541	2591	0.002893	0.009256	0.000939	137	137	137	0	0	1	-360	360	-6.7406	-4.1448	6.7422	4.0425	0.0000	0.0000	0.0000	0.0000;
	2592	2619	0.002479	0.007438	0.000731	120	120	120	0	0	1	-360	360	4.9676	1.6220	-4.9670	-1.7040	0.0000	0.0000	0.0000	0.0000;
	2542	2505	0.004917	0.023016	0.00236	120	120	120	0	0	1	-360	360	-4.1043	-1.9752	4.1052	1.7079	0.0000	0.0000	0.0000	0.0000;
	2670	2542	0.004917	0.023016	0.00236	120	120	120	0	0	1	-360	360	-2.2040	-1.4449	2.2043	1.1752	0.0000	0.0000	0.0000	0.0000;
	2600	2719	0.001653	0.004959	0.00053	137	137	137	0	0	1	-360	360	-6.4245	-0.1261	6.4251	0.0663	0.0000	0.0000	0.0000	0.0000;
	2478	2668	0.039504	0.124554	0.011761	38	38	38	0	0	1	-360	360	-6.7017	-2.2402	6.7186	0.9846	0.0000	0.0000	0.0000	0.0000;
	2538	2504	0.039504	0.069587	0.00657	72	72	72	0	0	1	-360	360	-21.4565	-1.3008	21.6175	0.8351	0.0000	0.0000	0.0000	0.0000;
	2536	2538	0.053058	0.093554	0.00884	72	72	72	0	0	1	-360	360	-15.4429	0.0062	15.5565	-0.7992	0.0000	0.0000	0.0000	0.0000;
	2658	2536	0.032934	0.106504	0.010926	137	137	137	0	0	1	-360	360	-2.2316	0.4677	2.2334	-1.6812	0.0000	0.0000	0.0000	0.0000;
	2657	2536	0.058066	0.103058	0.00937	76	76	76	0	0	1	-360	360	-4.1000	-1.7000	4.1095	0.6750	0.0000	0.0000	0.0000	0.0000;
	2668	2658	0.024438	0.079025	0.008107	137	137	137	0	0	1	-360	360	-0.5313	0.4629	0.5316	-1.3677	0.0000	0.0000	0.0000	0.0000;
	2458	2718	0.021388	0.069537	0.007289	120	120	120	0	0	1	-360	360	-1.8746	-0.4400	1.8752	-0.4048	0.0000	0.0000	0.0000	0.0000;
	2644	2504	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-4.8000	-1.3000	4.8003	1.2561	0.0000	0.0000	0.0000	0.0000;
	2501	2712	0.004628	0.014876	0.00152	120	120	120	0	0	1	-360	360	5.4012	0.9290	-5.4000	-1.1000	0.0000	0.0000	0.0000	0.0000;
	2502	2711	0.004628	0.014876	0.00152	120	120	120	0	0	1	-360	360	5.1011	0.8292	-5.1000	-1.0000	0.0000	0.0000	0.0000	0.0000;
	2618	2500	0.01281	0.021488	0.00212	78	78	78	0	0	1	-360	360	-12.9323	-5.8085	12.9546	5.6019	0.0000	0.0000	0.0000	0.0000;
	2469	2618	0.026198	0.043967	0.004339	78	78	78	0	0	1	-360	360	-10.4007	-5.6512	10.4323	5.2085	0.0000	0.0000	0.0000	0.0000;
	2581	2453	0.038843	0.12562	0.012901	95	95	95	0	0	1	-360	360	-6.5398	-1.5717	6.5549	0.1672	0.0000	0.0000	0.0000	0.0000;
	2706	2596	0.011653	0.037686	0.00387	137	137	137	0	0	1	-360	360	-12.5764	-1.8254	12.5929	1.4382	0.0000	0.0000	0.0000	0.0000;
	2453	2706	0.021397	0.069174	0.0071	137	137	137	0	0	1	-360	360	-10.5549	-1.6672	10.5763	0.9317	0.0000	0.0000	0.0000	0.0000;
	2461	2706	0.00281	0.009174	0.000939	123	123	123	0	0	1	-360	360	-2.0000	-1.0000	2.0001	0.8937	0.0000	0.0000	0.0000	0.0000;
	2671	2595	0.158017	0.182727	0.016429	46	46	46	0	0	1	-360	360	2.8877	-6.4720	-2.8330	4.6708	0.0000	0.0000	0.0000	0.0000;
	2608	2596	0.009826	0.017521	0.0016	80	80	80	0	0	1	-360	360	-23.3199	-1.9175	23.3672	1.8199	0.0000	0.0000	0.0000	0.0000;
	2508	2593	0.010388	0.050826	0.004939	133	133	133	0	0	1	-360	360	-9.7275	0.2667	9.7362	-0.7854	0.0000	0.0000	0.0000	0.0000;
	2569	2593	0.036033	0.128934	0.012509	69	69	69	0	0	1	-360	360	-8.4530	-0.9612	8.4758	-0.3751	0.0000	0.0000	0.0000	0.0000;
	2485	2595	0.022339	0.074959	0.00748	69	69	69	0	0	1	-360	360	-17.5423	1.8482	17.6039	-2.4931	0.0000	0.0000	0.0000	0.0000;
	2450	2569	0.041397	0.069421	0.00711	69	69	69	0	0	1	-360	360	-3.6474	-1.3756	3.6527	0.5824	0.0000	0.0000	0.0000	0.0000;
	2517	2569	0.033141	0.061157	0.006389	69	69	69	0	0	1	-360	360	-1.0000	-0.4000	1.0003	-0.3212	0.0000	0.0000	0.0000	0.0000;
	2550	2450	0.037686	0.121488	0.01249	69	69	69	0	0	1	-360	360	0.3532	-1.9779	-0.3526	0.5756	0.0000	0.0000	0.0000	0.0000;
	2552	2550	0.019422	0.06281	0.00649	69	69	69	0	0	1	-360	360	2.3545	-1.9019	-2.3532	1.1779	0.0000	0.0000	0.0000	0.0000;
	2597	2593	0.035868	0.115702	0.012199	140	140	140	0	0	1	-360	360	13.1861	-6.8992	-13.1188	5.7325	0.0000	0.0000	0.0000	0.0000;
	2531	2594	0.030248	0.097521	0.01028	140	140	140	0	0	1	-360	360	0.8875	-1.7482	-0.8869	0.5821	0.0000	0.0000	0.0000	0.0000;
	2563	2525	0.009826	0.017273	0.001631	69	69	69	0	0	1	-360	360	-8.7847	-1.6302	8.7916	1.4570	0.0000	0.0000	0.0000	0.0000;
	2602	2563	0.053223	0.093471	0.008821	69	69	69	0	0	1	-360	360	-2.2823	-0.6260	2.2847	-0.3698	0.0000	0.0000	0.0000	0.0000;
	2606	2599	0.006612	0.013719	0.001331	69	69	69	0	0	1	-360	360	0.9296	-0.2839	-0.9296	0.1330	0.0000	0.0000	0.0000	0.0000;
	2599	2607	0.005372	0.017364	0.001791	69	69	69	0	0	1	-360	360	-5.6704	-2.1330	5.6721	1.9352	0.0000	0.0000	0.0000	0.0000;
	2581	2552	0.023388	0.075868	0.007841	34	34	34	0	0	1	-360	360	-2.1656	0.8439	2.1669	-1.7196	0.0000	0.0000	0.0000	0.0000;
	2607	2595	0.01157	0.037686	0.00387	69	69	69	0	0	1	-360	360	-10.5721	-2.8352	10.5842	2.4341	0.0000	0.0000	0.0000	0.0000;
	2582	2594	0.033099	0.111066	0.011059	114	114	114	0	0	1	-360	360	-20.9886	-0.1189	21.1185	-0.6956	0.0000	0.0000	0.0000	0.0000;
	2585	2597	0.028182	0.091157	0.009341	69	69	69	0	0	1	-360	360	17.9760	-6.6648	-17.8861	5.8992	0.0000	0.0000	0.0000	0.0000;
	2602	2508	0.024463	0.043471	0.004039	69	69	69	0	0	1	-360	360	-6.7177	0.1260	6.7275	-0.5667	0.0000	0.0000	0.0000	0.0000;
	2601	2596	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	-4.0000	-0.7000	4.0010	0.5502	0.0000	0.0000	0.0000	0.0000;
	2608	2606	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	3.4303	0.1664	-3.4296	-0.3161	0.0000	0.0000	0.0000	0.0000;
	2582	2577	0.020496	0.06876	0.00688	69	69	69	0	0	1	-360	360	12.9886	-1.3811	-12.9577	0.7132	0.0000	0.0000	0.0000	0.0000;
	2638	2552	0.058182	0.094207	0.00944	84	84	84	0	0	1	-360	360	-2.5000	-0.5000	2.5033	-0.5525	0.0000	0.0000	0.0000	0.0000;
	2593	2595	0.01281	0.042984	0.004281	114	114	114	0	0	1	-360	360	-16.8977	0.7662	16.9300	-1.1453	0.0000	0.0000	0.0000	0.0000;
	2594	2596	0.01281	0.042984	0.004281	114	114	114	0	0	1	-360	360	-17.0038	0.7874	17.0365	-1.1652	0.0000	0.0000	0.0000	0.0000;
	2531	2608	0.014463	0.055537	0.004479	69	69	69	0	0	1	-360	360	-3.8875	0.7482	3.8895	-1.2489	0.0000	0.0000	0.0000	0.0000;
	2454	2491	0.023554	0.062149	0.006389	82	82	82	0	0	1	-360	360	-15.8062	1.2548	15.8555	-1.8974	0.0000	0.0000	0.0000	0.0000;
	2532	2454	0.027603	0.049504	0.004479	69	69	69	0	0	1	-360	360	-6.2443	0.0662	6.2533	-0.5899	0.0000	0.0000	0.0000	0.0000;
	2512	2532	0.039669	0.07157	0.006411	69	69	69	0	0	1	-360	360	-2.7418	-0.2002	2.7443	-0.5662	0.0000	0.0000	0.0000	0.0000;
	2543	2512	0.029826	0.057934	0.005469	69	69	69	0	0	1	-360	360	-0.2418	-0.3573	0.2418	-0.2998	0.0000	0.0000	0.0000	0.0000;
	2548	2490	0.009256	0.030083	0.003071	119	119	119	0	0	1	-360	360	-17.1494	-3.0304	17.1726	2.7342	0.0000	0.0000	0.0000	0.0000;
	2656	2650	0.053141	0.093388	0.008901	69	69	69	0	0	1	-360	360	-8.6433	1.7542	8.6799	-2.7226	0.0000	0.0000	0.0000	0.0000;
	2545	2548	0.001322	0.004207	0.00044	99	99	99	0	0	1	-360	360	-9.6484	-1.5802	9.6494	1.5304	0.0000	0.0000	0.0000	0.0000;
	2547	2491	0.009091	0.029752	0.00302	137	137	137	0	0	1	-360	360	-11.1471	-3.5289	11.1573	3.1968	0.0000	0.0000	0.0000	0.0000;
	2489	2490	0.055041	0.164298	0.016819	69	69	69	0	0	1	-360	360	-3.6673	-0.9439	3.6734	-1.0734	0.0000	0.0000	0.0000	0.0000;
	2715	2486	0.036529	0.064132	0.00605	69	69	69	0	0	1	-360	360	1.3006	-0.6934	-1.3000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2558	2547	0.01595	0.05124	0.0053	137	137	137	0	0	1	-360	360	-6.1421	-0.3527	6.1471	-0.2711	0.0000	0.0000	0.0000	0.0000;
	2558	2545	0.007438	0.023967	0.002461	126	126	126	0	0	1	-360	360	-4.6470	-0.3729	4.6484	0.0802	0.0000	0.0000	0.0000	0.0000;
	2621	2524	0.036686	0.116686	0.012509	69	69	69	0	0	1	-360	360	-3.0001	0.1196	3.0030	-1.6258	0.0000	0.0000	0.0000	0.0000;
	2715	2656	0.083141	0.146281	0.01392	69	69	69	0	0	1	-360	360	-7.6007	0.2243	7.6433	-1.7542	0.0000	0.0000	0.0000	0.0000;
	2692	2490	0.026612	0.089422	0.008949	137	137	137	0	0	1	-360	360	-11.7711	-0.7709	11.8017	-0.2081	0.0000	0.0000	0.0000	0.0000;
	2558	2655	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	6.2891	-0.7745	-6.2781	0.0819	0.0000	0.0000	0.0000	0.0000;
	2540	2543	0.005207	0.014132	0.001401	90	90	90	0	0	1	-360	360	-5.0000	-0.0000	5.0011	-0.1654	0.0000	0.0000	0.0000	0.0000;
	2543	2692	0.01843	0.061901	0.0062	137	137	137	0	0	1	-360	360	-8.7593	-0.9773	8.7711	0.2709	0.0000	0.0000	0.0000	0.0000;
	2481	2715	0.001818	0.003876	0.000271	76	76	76	0	0	1	-360	360	-2.8000	-0.5000	2.8001	0.4692	0.0000	0.0000	0.0000	0.0000;
	2649	2650	0.003471	0.012636	0.001191	123	123	123	0	0	1	-360	360	-33.0000	-3.6000	33.0330	3.5818	0.0000	0.0000	0.0000	0.0000;
	2455	2652	0.037603	0.091744	0.00968	99	99	99	0	0	1	-360	360	5.5097	0.3586	-5.5000	-1.5000	0.0000	0.0000	0.0000	0.0000;
	2621	2651	0.019669	0.086124	0.00924	57	57	57	0	0	1	-360	360	0.0001	-1.1196	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2495	2716	0.003314	0.010578	0.001089	137	137	137	0	0	1	-360	360	-2.7877	-4.2821	2.7885	4.1628	0.0000	0.0000	0.0000	0.0000;
	2635	2495	0.029752	0.095868	0.01007	137	137	137	0	0	1	-360	360	0.6179	-5.0851	-0.6123	3.9821	0.0000	0.0000	0.0000	0.0000;
	2573	2635	0.005124	0.016529	0.00174	137	137	137	0	0	1	-360	360	5.8204	-4.5699	-5.8179	4.3851	0.0000	0.0000	0.0000	0.0000;
	2553	2587	0.033471	0.065289	0.005929	21	21	21	0	0	1	-360	360	-4.2000	-0.8000	4.2053	0.1436	0.0000	0.0000	0.0000	0.0000;
	2460	2620	0.016529	0.031397	0.002899	48	48	48	0	0	1	-360	360	7.8167	-1.6974	-7.8074	1.3901	0.0000	0.0000	0.0000	0.0000;
	2626	2460	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	11.2548	-1.5900	-11.2167	0.9974	0.0000	0.0000	0.0000	0.0000;
	2620	2493	0.016529	0.031397	0.003151	48	48	48	0	0	1	-360	360	6.5074	-1.6901	-6.5008	1.3498	0.0000	0.0000	0.0000	0.0000;
	2603	2626	0.022884	0.074	0.007592	69	69	69	0	0	1	-360	360	12.3863	-2.0453	-12.3548	1.2900	0.0000	0.0000	0.0000	0.0000;
	2716	2492	0.001653	0.005289	0.00053	137	137	137	0	0	1	-360	360	-5.1885	-4.7628	5.1892	4.7058	0.0000	0.0000	0.0000	0.0000;
	2494	2493	0.009091	0.028099	0.00288	133	133	133	0	0	1	-360	360	-1.8670	-1.5691	1.8675	1.2484	0.0000	0.0000	0.0000	0.0000;
	2557	2555	0.00405	0.013314	0.001379	95	95	95	0	0	1	-360	360	0.4059	3.6709	-0.4053	-3.8217	0.0000	0.0000	0.0000	0.0000;
	2575	2557	0.020744	0.066281	0.006989	126	126	126	0	0	1	-360	360	4.3125	3.7169	-4.3059	-4.4709	0.0000	0.0000	0.0000	0.0000;
	2675	2575	0.028347	0.092231	0.009511	137	137	137	0	0	1	-360	360	9.8409	3.4449	-9.8125	-4.4169	0.0000	0.0000	0.0000	0.0000;
	2555	2573	0.040331	0.130413	0.013361	137	137	137	0	0	1	-360	360	10.3672	-5.2966	-10.3204	3.9699	0.0000	0.0000	0.0000	0.0000;
	2615	2494	0.020413	0.066124	0.006781	95	95	95	0	0	1	-360	360	3.2353	-1.9193	-3.2330	1.1691	0.0000	0.0000	0.0000	0.0000;
	2731	825	0.02562	0.084711	0.008477	123	123	123	0	0	1	-360	360	40.0000	-9.0400	-39.6400	9.2232	0.0000	0.0000	0.0000	0.0000;
	2731	825	0.02562	0.084711	0.008477	123	123	123	0	0	1	-360	360	40.0000	-9.0400	-39.6400	9.2232	0.0000	0.0000	0.0000	0.0000;
	2736	1430	0.010413	0.033554	0.003543	114	114	114	0	0	1	-360	360	-25.0000	-10.0000	25.0651	9.7988	0.0000	0.0000	0.0000	0.0000;
	2737	1872	0.009752	0.030496	0.003151	140	140	140	0	0	1	-360	360	-65.0000	-26.0000	65.4206	26.9535	0.0000	0.0000	0.0000	0.0000;
	2733	1524	0.002562	0.008264	0.000874	114	114	114	0	0	1	-360	360	-37.2604	-13.5647	37.2945	13.5716	0.0000	0.0000	0.0000	0.0000;
	2735	2733	0.003058	0.01	0.001048	114	114	114	0	0	1	-360	360	-20.2475	-7.6558	20.2597	7.5722	0.0000	0.0000	0.0000	0.0000;
	2732	2733	0.000248	0.000909	8.5e-05	114	114	114	0	0	1	-360	360	-17.0000	-6.0000	17.0007	5.9925	0.0000	0.0000	0.0000	0.0000;
	2734	1525	0.005702	0.018264	0.001922	114	114	114	0	0	1	-360	360	-28.7525	-10.3443	28.7976	10.2623	0.0000	0.0000	0.0000	0.0000;
	5	4	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	36.4900	1.2855	-36.4898	-1.2832	0.0000	0.0000	0.0000	0.0000;
	7	6	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	58.9635	37.2655	-58.9626	-37.2568	0.0000	0.0000	0.0000	0.0000;
	9	8	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	48.3879	48.6750	-48.3877	-48.6723	0.0000	0.0000	0.0000	0.0000;
	11	10	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-26.7569	-11.6011	26.7570	11.6027	0.0000	0.0000	0.0000	0.0000;
	12	11	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	43.1471	-5.7870	-43.1468	5.7904	0.0000	0.0000	0.0000	0.0000;
	16	15	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	18	17	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-4.9910	-28.5364	4.9911	28.5379	0.0000	0.0000	0.0000	0.0000;
	20	19	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-54.5473	16.8025	54.5479	-16.7970	0.0000	0.0000	0.0000	0.0000;
	22	21	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	29	28	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	247.5049	-38.7257	-247.5013	38.7617	0.0000	0.0000	0.0000	0.0000;
	37	36	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-17.5260	-21.6565	17.5262	21.6578	0.0000	0.0000	0.0000	0.0000;
	40	39	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-33.5953	-28.0162	33.5956	28.0194	0.0000	0.0000	0.0000	0.0000;
	43	42	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	89.4945	6.8170	-89.4930	-6.8029	0.0000	0.0000	0.0000	0.0000;
	45	44	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	17.7727	31.2418	-17.7726	-31.2410	0.0000	0.0000	0.0000	0.0000;
	48	47	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-124.1846	18.1611	124.1855	-18.1519	0.0000	0.0000	0.0000	0.0000;
	51	50	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	24.6117	-15.8559	-24.6116	15.8574	0.0000	0.0000	0.0000	0.0000;
	53	52	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	24.9030	-8.4373	-24.9030	8.4377	0.0000	0.0000	0.0000	0.0000;
	55	54	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	66.1126	-22.6530	-66.1118	22.6614	0.0000	0.0000	0.0000	0.0000;
	57	56	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-107.5762	-17.2331	107.5769	17.2399	0.0000	0.0000	0.0000	0.0000;
	59	58	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	28.1897	32.0535	-28.1894	-32.0504	0.0000	0.0000	0.0000	0.0000;
	62	61	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-1.0829	-18.6952	1.0830	18.6958	0.0000	0.0000	0.0000	0.0000;
	64	63	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-234.2548	61.0369	234.2582	-61.0029	0.0000	0.0000	0.0000	0.0000;
	73	72	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	118.0910	-5.8518	-118.0886	5.8763	0.0000	0.0000	0.0000	0.0000;
	75	74	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-14.3514	-9.5135	14.3514	9.5140	0.0000	0.0000	0.0000	0.0000;
	77	76	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-32.6277	-0.1448	32.6279	0.1467	0.0000	0.0000	0.0000	0.0000;
	79	78	2.1e-05	0.000207	0	876	876	876	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	81	80	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-2.0834	-2.6698	2.0834	2.6698	0.0000	0.0000	0.0000	0.0000;
	85	84	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-15.1840	-18.2929	15.1841	18.2939	0.0000	0.0000	0.0000	0.0000;
	87	86	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-45.6207	3.9459	45.6210	-3.9424	0.0000	0.0000	0.0000	0.0000;
	89	88	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-5.2861	-13.6607	5.2861	13.6611	0.0000	0.0000	0.0000	0.0000;
	91	90	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-34.2966	11.6223	34.2969	-11.6200	0.0000	0.0000	0.0000	0.0000;
	93	92	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-32.1126	-11.9792	32.1126	11.9798	0.0000	0.0000	0.0000	0.0000;
	95	94	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-47.9851	16.6642	47.9855	-16.6597	0.0000	0.0000	0.0000	0.0000;
	97	96	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	24.2111	19.7421	-24.2110	-19.7404	0.0000	0.0000	0.0000	0.0000;
	99	98	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	25.1206	8.2989	-25.1205	-8.2977	0.0000	0.0000	0.0000	0.0000;
	101	100	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-13.3799	3.9199	13.3799	-3.9196	0.0000	0.0000	0.0000	0.0000;
	103	102	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	101.6128	-8.2319	-101.6109	8.2502	0.0000	0.0000	0.0000	0.0000;
	105	104	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-194.2687	-38.1055	194.2755	38.1734	0.0000	0.0000	0.0000	0.0000;
	107	106	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.5358	-23.4195	-0.5357	23.4205	0.0000	0.0000	0.0000	0.0000;
	109	108	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-71.6307	14.9751	71.6316	-14.9659	0.0000	0.0000	0.0000	0.0000;
	112	111	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-6.6883	3.9623	6.6883	-3.9622	0.0000	0.0000	0.0000	0.0000;
	114	113	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	50.6060	-1.5739	-50.6055	1.5784	0.0000	0.0000	0.0000	0.0000;
	117	116	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	92.0289	-18.2303	-92.0273	18.2457	0.0000	0.0000	0.0000	0.0000;
	119	118	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	12.9866	6.3178	-12.9865	-6.3175	0.0000	0.0000	0.0000	0.0000;
	121	120	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	125.2306	51.1746	-125.2296	-51.1641	0.0000	0.0000	0.0000	0.0000;
	123	122	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	97.8451	71.5548	-97.8443	-71.5463	0.0000	0.0000	0.0000	0.0000;
	126	125	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	45.8993	-100.3757	-45.8972	100.3966	0.0000	0.0000	0.0000	0.0000;
	128	127	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-139.8542	-102.6991	139.8560	102.7168	0.0000	0.0000	0.0000	0.0000;
	130	129	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-10.4158	-23.4012	10.4159	23.4023	0.0000	0.0000	0.0000	0.0000;
	135	134	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	29.3410	10.8885	-29.3408	-10.8868	0.0000	0.0000	0.0000	0.0000;
	139	138	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-73.9298	40.0694	73.9302	-40.0652	0.0000	0.0000	0.0000	0.0000;
	142	141	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	145	144	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	147	146	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	20.4185	30.9946	-20.4182	-30.9922	0.0000	0.0000	0.0000	0.0000;
	149	148	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-111.6823	54.0777	111.6849	-54.0513	0.0000	0.0000	0.0000	0.0000;
	151	150	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	66.1167	-14.2907	-66.1164	14.2934	0.0000	0.0000	0.0000	0.0000;
	154	153	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-24.2939	3.2343	24.2940	-3.2333	0.0000	0.0000	0.0000	0.0000;
	156	155	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	59.4947	1.2396	-59.4941	-1.2336	0.0000	0.0000	0.0000	0.0000;
	158	157	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	125.3265	-69.9979	-125.3253	70.0103	0.0000	0.0000	0.0000	0.0000;
	160	159	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	163	162	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	9.9832	-3.2290	-9.9832	3.2290	0.0000	0.0000	0.0000	0.0000;
	165	164	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-146.9771	29.5435	146.9809	-29.5052	0.0000	0.0000	0.0000	0.0000;
	166	165	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	170	169	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-57.1676	6.3838	57.1681	-6.3782	0.0000	0.0000	0.0000	0.0000;
	172	171	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	174	173	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	22.3494	4.3002	-22.3493	-4.2993	0.0000	0.0000	0.0000	0.0000;
	177	176	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	12.7167	2.8220	-12.7167	-2.8217	0.0000	0.0000	0.0000	0.0000;
	179	178	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	185	184	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	244.2148	-1.2022	-244.2113	1.2370	0.0000	0.0000	0.0000	0.0000;
	187	186	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-159.5700	55.1620	159.5717	-55.1453	0.0000	0.0000	0.0000	0.0000;
	189	188	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-4.1614	12.3492	4.1614	-12.3489	0.0000	0.0000	0.0000	0.0000;
	191	190	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	61.9465	-12.2399	-61.9459	12.2467	0.0000	0.0000	0.0000	0.0000;
	194	193	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	9.9602	-4.5552	-9.9602	4.5554	0.0000	0.0000	0.0000	0.0000;
	196	195	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	8.5758	-6.0682	-8.5758	6.0682	0.0000	0.0000	0.0000	0.0000;
	198	197	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	11.1749	-8.4872	-11.1749	8.4875	0.0000	0.0000	0.0000	0.0000;
	200	199	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	216.6640	54.4253	-216.6610	-54.3957	0.0000	0.0000	0.0000	0.0000;
	202	201	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	67.2890	-25.1726	-67.2881	25.1816	0.0000	0.0000	0.0000	0.0000;
	204	203	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-105.0840	4.4433	105.0860	-4.4236	0.0000	0.0000	0.0000	0.0000;
	206	205	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	125.7074	36.1149	-125.7064	-36.1049	0.0000	0.0000	0.0000	0.0000;
	208	207	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-34.5483	2.1964	34.5485	-2.1944	0.0000	0.0000	0.0000	0.0000;
	214	213	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	222	221	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	229	228	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.5674	2.2507	-11.5673	-2.2497	0.0000	0.0000	0.0000	0.0000;
	244	243	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	29.7124	-0.7942	-29.7119	0.8001	0.0000	0.0000	0.0000	0.0000;
	250	249	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	259	258	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.0201	0.2204	8.0202	-0.2199	0.0000	0.0000	0.0000	0.0000;
	266	265	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	283	282	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	285	284	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.1104	-35.0939	2.1114	35.1034	0.0000	0.0000	0.0000	0.0000;
	287	286	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	299	298	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	312	311	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	320	319	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.7148	-3.7648	-5.7147	3.7651	0.0000	0.0000	0.0000	0.0000;
	327	326	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	336	335	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	344	343	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	346	345	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.1056	14.9307	7.1058	-14.9287	0.0000	0.0000	0.0000	0.0000;
	356	355	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	357	356	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	23.0679	6.7875	-23.0675	-6.7833	0.0000	0.0000	0.0000	0.0000;
	363	362	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-59.2336	-20.9209	59.2364	20.9494	0.0000	0.0000	0.0000	0.0000;
	377	376	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	381	380	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.5868	10.8476	18.5871	-10.8442	0.0000	0.0000	0.0000	0.0000;
	387	386	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	395	394	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	406	405	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	408	407	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	423	422	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.3770	-1.6104	9.3771	1.6111	0.0000	0.0000	0.0000	0.0000;
	431	430	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.9022	1.0209	0.9022	-1.0209	0.0000	0.0000	0.0000	0.0000;
	438	437	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	440	439	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	443	442	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-32.7630	-7.8303	32.7639	7.8386	0.0000	0.0000	0.0000	0.0000;
	459	458	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	466	465	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	30.3635	0.7819	-30.3628	-0.7752	0.0000	0.0000	0.0000	0.0000;
	477	476	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	487	486	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	489	488	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	491	490	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	496	495	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.4381	5.2060	-28.4375	-5.1998	0.0000	0.0000	0.0000	0.0000;
	509	508	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	511	510	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.2439	1.4823	20.2442	-1.4795	0.0000	0.0000	0.0000	0.0000;
	517	516	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.2955	2.2090	-8.2955	-2.2084	0.0000	0.0000	0.0000	0.0000;
	519	518	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	522	521	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	526	525	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.6232	2.1269	-12.6230	-2.1257	0.0000	0.0000	0.0000	0.0000;
	532	531	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	534	533	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	538	537	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	540	539	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	543	542	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.2959	14.4722	-17.2955	-14.4685	0.0000	0.0000	0.0000	0.0000;
	549	548	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	553	552	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	558	557	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.4919	2.6272	6.4919	-2.6268	0.0000	0.0000	0.0000	0.0000;
	576	575	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	579	578	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	589	588	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.2621	-18.4644	27.2628	18.4721	0.0000	0.0000	0.0000	0.0000;
	595	594	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.7759	-15.0281	-11.7757	15.0307	0.0000	0.0000	0.0000	0.0000;
	615	614	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	619	618	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.6347	-0.6847	11.6348	0.6857	0.0000	0.0000	0.0000	0.0000;
	666	665	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-60.1816	19.9541	60.1845	-19.9250	0.0000	0.0000	0.0000	0.0000;
	687	686	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.0471	12.4174	37.0482	-12.4068	0.0000	0.0000	0.0000	0.0000;
	698	697	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.5120	-18.4973	3.5123	18.4997	0.0000	0.0000	0.0000	0.0000;
	716	715	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.4505	3.5474	-11.4504	-3.5464	0.0000	0.0000	0.0000	0.0000;
	732	731	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	38.1339	8.2182	-38.1328	-8.2073	0.0000	0.0000	0.0000	0.0000;
	742	741	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-45.6734	18.6311	45.6750	-18.6143	0.0000	0.0000	0.0000	0.0000;
	760	759	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.1885	10.7999	-21.1881	-10.7959	0.0000	0.0000	0.0000	0.0000;
	770	769	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.6959	-4.7550	3.6959	4.7553	0.0000	0.0000	0.0000	0.0000;
	780	779	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.2930	3.3949	18.2932	-3.3924	0.0000	0.0000	0.0000	0.0000;
	809	808	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	848	847	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.5154	-3.3944	-11.5153	3.3954	0.0000	0.0000	0.0000	0.0000;
	851	850	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.7610	-6.5421	0.7610	6.5424	0.0000	0.0000	0.0000	0.0000;
	853	852	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.8343	-1.4548	-10.8342	1.4556	0.0000	0.0000	0.0000	0.0000;
	854	853	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.0614	-0.6746	-13.0613	0.6758	0.0000	0.0000	0.0000	0.0000;
	856	855	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.8199	1.2552	11.8200	-1.2543	0.0000	0.0000	0.0000	0.0000;
	858	857	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.6322	2.2796	-13.6320	-2.2783	0.0000	0.0000	0.0000	0.0000;
	862	861	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.9304	-0.4782	7.9304	0.4787	0.0000	0.0000	0.0000	0.0000;
	865	864	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.3273	-2.4094	11.3274	2.4103	0.0000	0.0000	0.0000	0.0000;
	867	866	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	870	869	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.1262	-0.7165	1.1262	0.7165	0.0000	0.0000	0.0000	0.0000;
	872	871	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.8450	-1.7763	-11.8449	1.7773	0.0000	0.0000	0.0000	0.0000;
	874	873	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	877	876	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.1666	-0.8490	-0.1666	0.8490	0.0000	0.0000	0.0000	0.0000;
	879	878	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	884	883	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.0215	2.9852	6.0215	-2.9849	0.0000	0.0000	0.0000	0.0000;
	886	885	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.6713	-3.6637	-7.6712	3.6642	0.0000	0.0000	0.0000	0.0000;
	892	891	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.1103	-5.9894	-19.1100	5.9921	0.0000	0.0000	0.0000	0.0000;
	896	895	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.2009	7.6510	-5.2009	-7.6504	0.0000	0.0000	0.0000	0.0000;
	898	897	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	901	900	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	902	901	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	900	902	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	904	903	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.0269	-1.4345	-2.0269	1.4346	0.0000	0.0000	0.0000	0.0000;
	906	905	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.5901	4.2580	-1.5901	-4.2579	0.0000	0.0000	0.0000	0.0000;
	908	907	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	912	911	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	918	917	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.1842	-0.6781	15.1844	0.6797	0.0000	0.0000	0.0000	0.0000;
	920	919	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.1264	-0.5312	5.1264	0.5314	0.0000	0.0000	0.0000	0.0000;
	922	921	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	924	923	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	928	927	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.4420	0.7042	7.4420	-0.7038	0.0000	0.0000	0.0000	0.0000;
	930	929	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	932	931	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.5748	-2.3986	-2.5748	2.3987	0.0000	0.0000	0.0000	0.0000;
	934	933	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.8981	0.9273	10.8981	-0.9265	0.0000	0.0000	0.0000	0.0000;
	936	935	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.3385	2.1783	1.3385	-2.1782	0.0000	0.0000	0.0000	0.0000;
	940	939	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.2784	4.0929	12.2785	-4.0918	0.0000	0.0000	0.0000	0.0000;
	942	941	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.9246	-0.6464	5.9247	0.6467	0.0000	0.0000	0.0000	0.0000;
	944	943	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	947	946	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	949	948	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.8205	3.0140	-8.8204	-3.0134	0.0000	0.0000	0.0000	0.0000;
	955	954	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.6066	-0.4130	5.6066	0.4132	0.0000	0.0000	0.0000	0.0000;
	957	956	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.6030	0.1238	-14.6028	-0.1223	0.0000	0.0000	0.0000	0.0000;
	961	960	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.2808	-1.0934	9.2809	1.0941	0.0000	0.0000	0.0000	0.0000;
	963	962	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.0528	-1.5667	-3.0528	1.5668	0.0000	0.0000	0.0000	0.0000;
	965	964	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.4007	0.5141	1.4007	-0.5141	0.0000	0.0000	0.0000	0.0000;
	967	966	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.3398	-1.2068	-9.3397	1.2074	0.0000	0.0000	0.0000	0.0000;
	969	968	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.4464	-2.3364	27.4469	2.3415	0.0000	0.0000	0.0000	0.0000;
	971	970	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.0400	0.4809	-12.0399	-0.4799	0.0000	0.0000	0.0000	0.0000;
	973	972	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.4656	-0.3099	0.4656	0.3099	0.0000	0.0000	0.0000	0.0000;
	975	974	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.6657	0.4023	-14.6656	-0.4009	0.0000	0.0000	0.0000	0.0000;
	977	976	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	979	978	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.6487	-0.7280	-1.6487	0.7280	0.0000	0.0000	0.0000	0.0000;
	981	980	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	30.1872	1.4419	-30.1866	-1.4358	0.0000	0.0000	0.0000	0.0000;
	983	982	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.8319	0.0533	22.8322	-0.0497	0.0000	0.0000	0.0000	0.0000;
	987	986	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.4098	-1.0930	-18.4096	1.0954	0.0000	0.0000	0.0000	0.0000;
	989	988	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4166	-2.3739	3.4167	2.3740	0.0000	0.0000	0.0000	0.0000;
	991	990	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.3880	1.7488	-11.3879	-1.7479	0.0000	0.0000	0.0000	0.0000;
	995	994	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.8372	2.5773	16.8374	-2.5753	0.0000	0.0000	0.0000	0.0000;
	997	996	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	999	998	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1001	1000	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.4789	2.4366	-9.4788	-2.4359	0.0000	0.0000	0.0000	0.0000;
	1002	1003	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1005	1004	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.5516	-0.5856	-3.5516	0.5857	0.0000	0.0000	0.0000	0.0000;
	1007	1006	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.9623	0.0277	16.9625	-0.0258	0.0000	0.0000	0.0000	0.0000;
	1009	1008	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.7360	0.1631	-0.7360	-0.1631	0.0000	0.0000	0.0000	0.0000;
	1011	1010	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.4819	-2.5173	12.4820	2.5184	0.0000	0.0000	0.0000	0.0000;
	1013	1012	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.2270	-2.8561	-21.2266	2.8593	0.0000	0.0000	0.0000	0.0000;
	1015	1014	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1016	1015	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1014	1016	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1020	1019	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.8990	8.5159	-11.8989	-8.5145	0.0000	0.0000	0.0000	0.0000;
	1026	1025	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.3359	-11.0569	-14.3357	11.0592	0.0000	0.0000	0.0000	0.0000;
	1027	1026	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.9732	-4.5243	-5.9732	4.5247	0.0000	0.0000	0.0000	0.0000;
	1037	1036	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.2665	0.4476	8.2666	-0.4471	0.0000	0.0000	0.0000	0.0000;
	1043	1042	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.5540	1.0046	0.5540	-1.0046	0.0000	0.0000	0.0000	0.0000;
	1045	1044	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.2561	-0.0695	1.2561	0.0695	0.0000	0.0000	0.0000	0.0000;
	1047	1046	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1049	1048	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.0356	2.5488	-2.0356	-2.5488	0.0000	0.0000	0.0000	0.0000;
	1051	1050	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.5467	1.0014	-20.5464	-0.9985	0.0000	0.0000	0.0000	0.0000;
	1053	1052	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4552	-2.9962	3.4552	2.9963	0.0000	0.0000	0.0000	0.0000;
	1059	1058	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.3074	3.0156	7.3075	-3.0152	0.0000	0.0000	0.0000	0.0000;
	1061	1060	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1063	1062	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.8450	-0.2417	2.8450	0.2417	0.0000	0.0000	0.0000	0.0000;
	1066	1065	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.0257	-1.9429	-4.0257	1.9430	0.0000	0.0000	0.0000	0.0000;
	1069	1068	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.0003	-2.0035	14.0004	2.0049	0.0000	0.0000	0.0000	0.0000;
	1071	1070	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.1999	1.7716	-10.1999	-1.7709	0.0000	0.0000	0.0000	0.0000;
	1073	1072	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.7445	0.9555	-9.7445	-0.9548	0.0000	0.0000	0.0000	0.0000;
	1075	1074	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.1448	3.3055	9.1449	-3.3048	0.0000	0.0000	0.0000	0.0000;
	1077	1076	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.0472	-2.3248	-2.0472	2.3249	0.0000	0.0000	0.0000	0.0000;
	1079	1078	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0814	-3.7350	-0.0814	3.7351	0.0000	0.0000	0.0000	0.0000;
	1081	1080	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.9252	1.2528	1.9252	-1.2527	0.0000	0.0000	0.0000	0.0000;
	1083	1082	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1087	1086	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.4792	1.4145	-3.4792	-1.4144	0.0000	0.0000	0.0000	0.0000;
	1089	1088	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.0347	5.8028	9.0348	-5.8019	0.0000	0.0000	0.0000	0.0000;
	1093	1092	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1097	1096	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.9130	-5.9433	-2.9130	5.9436	0.0000	0.0000	0.0000	0.0000;
	1103	1102	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.2988	1.7218	11.2988	-1.7209	0.0000	0.0000	0.0000	0.0000;
	1105	1104	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1109	1108	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.3068	-0.3192	5.3068	0.3194	0.0000	0.0000	0.0000	0.0000;
	1111	1110	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.1097	-1.0754	18.1100	1.0777	0.0000	0.0000	0.0000	0.0000;
	1113	1112	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1115	1114	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1116	1115	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1114	1116	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1118	1117	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-45.1873	3.3130	45.1887	-3.2992	0.0000	0.0000	0.0000	0.0000;
	1120	1119	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	38.8254	15.4375	-38.8242	-15.4252	0.0000	0.0000	0.0000	0.0000;
	1124	1123	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1134	1133	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.1475	2.5802	5.1475	-2.5800	0.0000	0.0000	0.0000	0.0000;
	1136	1135	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.0343	1.8208	8.0344	-1.8203	0.0000	0.0000	0.0000	0.0000;
	1139	1138	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1140	1139	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1145	1144	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.1233	-1.4433	2.1234	1.4434	0.0000	0.0000	0.0000	0.0000;
	1146	1145	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.3179	1.8876	-1.3179	-1.8876	0.0000	0.0000	0.0000	0.0000;
	1150	1149	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.5715	-2.1446	-2.5715	2.1447	0.0000	0.0000	0.0000	0.0000;
	1152	1151	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.1475	0.1561	-17.1473	-0.1541	0.0000	0.0000	0.0000	0.0000;
	1157	1156	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.1276	-2.8066	-3.1276	2.8067	0.0000	0.0000	0.0000	0.0000;
	1166	1165	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.7665	4.6761	-3.7665	-4.6759	0.0000	0.0000	0.0000	0.0000;
	1168	1167	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1172	1171	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	52.1027	4.8868	-52.1008	-4.8686	0.0000	0.0000	0.0000	0.0000;
	1174	1173	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1179	1178	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1181	1180	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1183	1182	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.6046	-0.6087	0.6046	0.6087	0.0000	0.0000	0.0000	0.0000;
	1187	1186	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-44.5775	-3.9197	44.5789	3.9330	0.0000	0.0000	0.0000	0.0000;
	1189	1188	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1196	1195	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.7783	0.2089	13.7784	-0.2076	0.0000	0.0000	0.0000	0.0000;
	1203	1202	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.0762	-1.0794	4.0762	1.0796	0.0000	0.0000	0.0000	0.0000;
	1206	1205	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.2997	3.3620	22.3001	-3.3585	0.0000	0.0000	0.0000	0.0000;
	1208	1207	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0802	6.2633	-0.0802	-6.2630	0.0000	0.0000	0.0000	0.0000;
	1210	1209	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.6832	0.2895	-12.6831	-0.2884	0.0000	0.0000	0.0000	0.0000;
	1212	1211	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.8411	0.1803	-6.8410	-0.1800	0.0000	0.0000	0.0000	0.0000;
	1214	1213	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.9066	-0.3878	-2.9066	0.3878	0.0000	0.0000	0.0000	0.0000;
	1216	1215	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.7587	-1.1086	-1.7587	1.1086	0.0000	0.0000	0.0000	0.0000;
	1220	1219	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1222	1221	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.5460	1.4610	23.5464	-1.4572	0.0000	0.0000	0.0000	0.0000;
	1224	1223	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1226	1225	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.4154	4.0695	14.4156	-4.0679	0.0000	0.0000	0.0000	0.0000;
	1232	1231	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.9796	2.1265	-4.9796	-2.1263	0.0000	0.0000	0.0000	0.0000;
	1234	1233	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1236	1235	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.8563	-0.9865	4.8563	0.9867	0.0000	0.0000	0.0000	0.0000;
	1238	1237	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.0232	0.8063	3.0232	-0.8063	0.0000	0.0000	0.0000	0.0000;
	1242	1241	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.4576	2.1780	20.4579	-2.1751	0.0000	0.0000	0.0000	0.0000;
	1244	1243	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.2318	0.2137	-6.2317	-0.2135	0.0000	0.0000	0.0000	0.0000;
	1246	1245	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.1835	0.6844	29.1841	-0.6783	0.0000	0.0000	0.0000	0.0000;
	1248	1247	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1250	1249	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.6434	1.7141	22.6438	-1.7106	0.0000	0.0000	0.0000	0.0000;
	1256	1255	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1258	1257	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.0080	0.2170	-2.0080	-0.2170	0.0000	0.0000	0.0000	0.0000;
	1260	1259	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.1041	0.3386	-4.1041	-0.3385	0.0000	0.0000	0.0000	0.0000;
	1264	1263	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.9686	0.1352	-15.9684	-0.1335	0.0000	0.0000	0.0000	0.0000;
	1266	1265	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.2027	0.7970	-6.2027	-0.7967	0.0000	0.0000	0.0000	0.0000;
	1268	1267	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.3108	5.4781	8.3108	-5.4774	0.0000	0.0000	0.0000	0.0000;
	1270	1269	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1271	1270	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1278	1277	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	55.7823	4.4672	-55.7802	-4.4462	0.0000	0.0000	0.0000	0.0000;
	1280	1279	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.6430	-1.1007	-13.6429	1.1020	0.0000	0.0000	0.0000	0.0000;
	1284	1283	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.6056	1.0401	9.6056	-1.0395	0.0000	0.0000	0.0000	0.0000;
	1287	1286	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1289	1288	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1291	1290	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.8691	-2.3176	5.8691	2.3179	0.0000	0.0000	0.0000	0.0000;
	1293	1292	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.4668	-1.6037	0.4668	1.6037	0.0000	0.0000	0.0000	0.0000;
	1295	1294	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.1272	1.2994	6.1273	-1.2992	0.0000	0.0000	0.0000	0.0000;
	1297	1296	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.4591	1.1941	-2.4591	-1.1940	0.0000	0.0000	0.0000	0.0000;
	1299	1298	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.5141	0.0594	-0.5141	-0.0594	0.0000	0.0000	0.0000	0.0000;
	1301	1300	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.8017	-1.4007	9.8018	1.4014	0.0000	0.0000	0.0000	0.0000;
	1303	1302	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.1740	0.4014	0.1740	-0.4014	0.0000	0.0000	0.0000	0.0000;
	1305	1304	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.0179	-3.6114	3.0179	3.6115	0.0000	0.0000	0.0000	0.0000;
	1307	1306	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.3128	-0.5966	0.3128	0.5966	0.0000	0.0000	0.0000	0.0000;
	1309	1308	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.8789	-1.1313	12.8790	1.1324	0.0000	0.0000	0.0000	0.0000;
	1313	1312	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.6811	0.0473	2.6812	-0.0473	0.0000	0.0000	0.0000	0.0000;
	1315	1314	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-41.6004	1.9194	41.6016	-1.9075	0.0000	0.0000	0.0000	0.0000;
	1317	1316	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.4962	-0.7229	4.4963	0.7231	0.0000	0.0000	0.0000	0.0000;
	1321	1320	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1325	1324	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.1708	-2.3372	17.1710	2.3392	0.0000	0.0000	0.0000	0.0000;
	1331	1330	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.5742	-2.5450	-14.5740	2.5465	0.0000	0.0000	0.0000	0.0000;
	1333	1332	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.7532	-1.1120	-9.7531	1.1126	0.0000	0.0000	0.0000	0.0000;
	1335	1334	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.3401	-0.0663	-5.3401	0.0665	0.0000	0.0000	0.0000	0.0000;
	1337	1336	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.2935	1.8592	14.2937	-1.8578	0.0000	0.0000	0.0000	0.0000;
	1339	1338	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4985	-1.7859	3.4985	1.7860	0.0000	0.0000	0.0000	0.0000;
	1344	1343	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.8138	-0.9275	-6.8137	0.9278	0.0000	0.0000	0.0000	0.0000;
	1346	1345	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1349	1348	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1351	1350	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.7147	-6.0610	6.7148	6.0616	0.0000	0.0000	0.0000	0.0000;
	1353	1352	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1354	1353	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1352	1354	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1356	1355	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.7070	-2.8460	-2.7070	2.8461	0.0000	0.0000	0.0000	0.0000;
	1358	1357	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1362	1361	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.8145	-2.7696	6.8145	2.7700	0.0000	0.0000	0.0000	0.0000;
	1364	1363	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1366	1365	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.4223	-1.8663	-4.4223	1.8664	0.0000	0.0000	0.0000	0.0000;
	1368	1367	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.0096	10.7302	1.0097	-10.7294	0.0000	0.0000	0.0000	0.0000;
	1370	1369	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.7328	0.7436	15.7330	-0.7419	0.0000	0.0000	0.0000	0.0000;
	1376	1375	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.0483	4.3393	26.0488	-4.3344	0.0000	0.0000	0.0000	0.0000;
	1377	1376	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1375	1377	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1379	1378	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.8582	-2.9954	24.8586	2.9996	0.0000	0.0000	0.0000	0.0000;
	1381	1380	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.6056	-1.2211	-0.6056	1.2211	0.0000	0.0000	0.0000	0.0000;
	1383	1382	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.3794	1.0415	-1.3794	-1.0415	0.0000	0.0000	0.0000	0.0000;
	1385	1384	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.3071	0.4832	-9.3071	-0.4827	0.0000	0.0000	0.0000	0.0000;
	1387	1386	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1389	1388	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.6290	-0.0621	-14.6289	0.0636	0.0000	0.0000	0.0000	0.0000;
	1391	1390	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-45.8549	-9.6613	45.8564	9.6760	0.0000	0.0000	0.0000	0.0000;
	1393	1392	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.6189	-2.2551	10.6190	2.2560	0.0000	0.0000	0.0000	0.0000;
	1395	1394	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1399	1398	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.2229	-2.2418	-5.2229	2.2420	0.0000	0.0000	0.0000	0.0000;
	1404	1403	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.3922	-2.4566	10.3922	2.4574	0.0000	0.0000	0.0000	0.0000;
	1410	1409	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-38.9273	2.2672	38.9283	-2.2568	0.0000	0.0000	0.0000	0.0000;
	1412	1411	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.0723	3.9218	-8.0723	-3.9212	0.0000	0.0000	0.0000	0.0000;
	1414	1413	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1416	1415	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1418	1417	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.7385	-1.3396	7.7385	1.3401	0.0000	0.0000	0.0000	0.0000;
	1420	1419	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.6624	-2.7070	7.6625	2.7075	0.0000	0.0000	0.0000	0.0000;
	1422	1421	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.7590	-2.7009	8.7590	2.7015	0.0000	0.0000	0.0000	0.0000;
	1424	1423	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.9150	0.6111	4.9150	-0.6110	0.0000	0.0000	0.0000	0.0000;
	1428	1427	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.7111	3.5938	9.7112	-3.5931	0.0000	0.0000	0.0000	0.0000;
	1430	1429	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.1212	-0.4966	-4.1212	0.4968	0.0000	0.0000	0.0000	0.0000;
	1434	1433	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1439	1438	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.7779	1.7461	18.7781	-1.7436	0.0000	0.0000	0.0000	0.0000;
	1441	1440	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.2018	0.6420	10.2019	-0.6413	0.0000	0.0000	0.0000	0.0000;
	1445	1444	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1449	1448	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.9006	1.0422	3.9006	-1.0421	0.0000	0.0000	0.0000	0.0000;
	1451	1450	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.8185	0.7453	2.8185	-0.7453	0.0000	0.0000	0.0000	0.0000;
	1453	1452	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.7705	-0.3135	-2.7705	0.3136	0.0000	0.0000	0.0000	0.0000;
	1455	1454	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.4433	5.0360	13.4434	-5.0347	0.0000	0.0000	0.0000	0.0000;
	1457	1456	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.4989	1.9489	2.4989	-1.9488	0.0000	0.0000	0.0000	0.0000;
	1459	1458	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.8940	-1.5853	8.8941	1.5858	0.0000	0.0000	0.0000	0.0000;
	1461	1460	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.1673	-1.2313	6.1674	1.2316	0.0000	0.0000	0.0000	0.0000;
	1463	1462	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.4124	-1.2480	6.4124	1.2483	0.0000	0.0000	0.0000	0.0000;
	1465	1464	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.6228	1.9193	-8.6228	-1.9188	0.0000	0.0000	0.0000	0.0000;
	1469	1468	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1473	1472	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.3153	0.1564	4.3153	-0.1563	0.0000	0.0000	0.0000	0.0000;
	1475	1474	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.1893	7.5199	7.1894	-7.5191	0.0000	0.0000	0.0000	0.0000;
	1477	1476	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	29.5172	2.0436	-29.5166	-2.0377	0.0000	0.0000	0.0000	0.0000;
	1479	1478	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.1730	-2.7968	23.1734	2.8005	0.0000	0.0000	0.0000	0.0000;
	1481	1480	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1483	1482	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.6827	-2.3905	16.6829	2.3925	0.0000	0.0000	0.0000	0.0000;
	1485	1484	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.9535	0.4887	-0.9535	-0.4887	0.0000	0.0000	0.0000	0.0000;
	1487	1486	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1489	1488	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.2068	-2.2551	-13.2067	2.2564	0.0000	0.0000	0.0000	0.0000;
	1491	1490	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1494	1493	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.3443	-0.7502	-2.3443	0.7502	0.0000	0.0000	0.0000	0.0000;
	1496	1495	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.5203	-2.1118	-3.5203	2.1119	0.0000	0.0000	0.0000	0.0000;
	1498	1497	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.8220	6.3793	-24.8215	-6.3748	0.0000	0.0000	0.0000	0.0000;
	1500	1499	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.6941	2.3229	-9.6940	-2.3222	0.0000	0.0000	0.0000	0.0000;
	1502	1501	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1504	1503	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	23.4215	1.9931	-23.4211	-1.9893	0.0000	0.0000	0.0000	0.0000;
	1506	1505	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1511	1510	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.1719	0.4969	-1.1719	-0.4969	0.0000	0.0000	0.0000	0.0000;
	1513	1512	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1519	1518	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.9848	-0.1500	-1.9848	0.1500	0.0000	0.0000	0.0000	0.0000;
	1521	1520	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1523	1522	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.8084	0.8210	-18.8082	-0.8186	0.0000	0.0000	0.0000	0.0000;
	1525	1524	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.6136	4.5076	-13.6135	-4.5062	0.0000	0.0000	0.0000	0.0000;
	1527	1526	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.8475	-0.1798	-17.8473	0.1819	0.0000	0.0000	0.0000	0.0000;
	1529	1528	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.5743	0.4256	-0.5743	-0.4256	0.0000	0.0000	0.0000	0.0000;
	1537	1536	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.8945	-1.0436	8.8946	1.0441	0.0000	0.0000	0.0000	0.0000;
	1539	1538	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1543	1542	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.4187	2.8946	-3.4187	-2.8945	0.0000	0.0000	0.0000	0.0000;
	1545	1544	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1547	1546	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.8823	-1.4392	11.8824	1.4402	0.0000	0.0000	0.0000	0.0000;
	1549	1548	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.0640	0.2504	-7.0639	-0.2500	0.0000	0.0000	0.0000	0.0000;
	1555	1554	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.4937	-1.7059	-4.4936	1.7061	0.0000	0.0000	0.0000	0.0000;
	1557	1556	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.4172	5.6654	18.4175	-5.6629	0.0000	0.0000	0.0000	0.0000;
	1559	1558	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.1635	3.1895	13.1636	-3.1883	0.0000	0.0000	0.0000	0.0000;
	1563	1562	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.4283	7.9397	5.4284	-7.9390	0.0000	0.0000	0.0000	0.0000;
	1565	1564	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1569	1568	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.7724	-1.4231	-3.7724	1.4232	0.0000	0.0000	0.0000	0.0000;
	1571	1570	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.5221	-0.6795	18.5224	0.6818	0.0000	0.0000	0.0000	0.0000;
	1573	1572	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1575	1574	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.5175	1.9374	-17.5173	-1.9353	0.0000	0.0000	0.0000	0.0000;
	1577	1576	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.1829	1.3179	-5.1829	-1.3177	0.0000	0.0000	0.0000	0.0000;
	1579	1578	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.5120	1.2352	2.5120	-1.2352	0.0000	0.0000	0.0000	0.0000;
	1581	1580	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-39.5172	-2.0934	39.5182	2.1041	0.0000	0.0000	0.0000	0.0000;
	1583	1582	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.0453	5.6162	10.0453	-5.6152	0.0000	0.0000	0.0000	0.0000;
	1585	1584	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.5682	-0.6769	17.5684	0.6790	0.0000	0.0000	0.0000	0.0000;
	1587	1586	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.2248	1.8745	-16.2246	-1.8727	0.0000	0.0000	0.0000	0.0000;
	1589	1588	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-44.8845	1.7449	44.8859	-1.7312	0.0000	0.0000	0.0000	0.0000;
	1591	1590	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.4528	-2.1592	21.4531	2.1623	0.0000	0.0000	0.0000	0.0000;
	1593	1592	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	33.2298	-0.3723	-33.2290	0.3801	0.0000	0.0000	0.0000	0.0000;
	1595	1594	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	23.1727	-3.0059	-23.1723	3.0097	0.0000	0.0000	0.0000	0.0000;
	1599	1598	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.8467	1.5524	-2.8466	-1.5523	0.0000	0.0000	0.0000	0.0000;
	1603	1602	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.1828	-6.6678	-6.1828	6.6684	0.0000	0.0000	0.0000	0.0000;
	1605	1604	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.3724	2.6774	6.3724	-2.6770	0.0000	0.0000	0.0000	0.0000;
	1607	1606	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.2547	2.6938	37.2557	-2.6842	0.0000	0.0000	0.0000	0.0000;
	1609	1608	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.8447	-0.7774	-0.8447	0.7774	0.0000	0.0000	0.0000	0.0000;
	1613	1612	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.0277	0.8613	-25.0272	-0.8571	0.0000	0.0000	0.0000	0.0000;
	1615	1614	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.2171	2.6576	14.2172	-2.6561	0.0000	0.0000	0.0000	0.0000;
	1619	1618	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.5205	6.9809	-4.5205	-6.9804	0.0000	0.0000	0.0000	0.0000;
	1621	1620	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.7846	0.1204	-26.7841	-0.1157	0.0000	0.0000	0.0000	0.0000;
	1625	1624	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.0007	-0.2837	13.0008	0.2849	0.0000	0.0000	0.0000	0.0000;
	1627	1626	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.4397	2.7842	-7.4396	-2.7838	0.0000	0.0000	0.0000	0.0000;
	1629	1628	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.1708	0.1747	-19.1705	-0.1722	0.0000	0.0000	0.0000	0.0000;
	1631	1630	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.4973	-9.6710	27.4979	9.6768	0.0000	0.0000	0.0000	0.0000;
	1632	1631	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1630	1632	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1634	1633	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.7656	5.9141	3.7657	-5.9137	0.0000	0.0000	0.0000	0.0000;
	1636	1635	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.8172	-0.9440	-6.8172	0.9444	0.0000	0.0000	0.0000	0.0000;
	1638	1637	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.4471	-0.3473	-5.4471	0.3475	0.0000	0.0000	0.0000	0.0000;
	1642	1641	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1646	1645	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.2394	-2.6511	-12.2393	2.6522	0.0000	0.0000	0.0000	0.0000;
	1648	1647	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1651	1650	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.0280	0.6077	-6.0280	-0.6075	0.0000	0.0000	0.0000	0.0000;
	1655	1654	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.7446	2.8680	-13.7444	-2.8667	0.0000	0.0000	0.0000	0.0000;
	1661	1660	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.2015	-2.4278	2.2015	2.4279	0.0000	0.0000	0.0000	0.0000;
	1664	1663	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.8329	-0.2985	6.8329	0.2988	0.0000	0.0000	0.0000	0.0000;
	1666	1665	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.1521	4.0614	-10.1520	-4.0605	0.0000	0.0000	0.0000	0.0000;
	1670	1669	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.7812	0.4681	0.7812	-0.4681	0.0000	0.0000	0.0000	0.0000;
	1672	1671	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	44.3605	2.5504	-44.3591	-2.5370	0.0000	0.0000	0.0000	0.0000;
	1674	1673	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1675	1674	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1673	1675	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1677	1676	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.2750	-0.5052	-10.2749	0.5059	0.0000	0.0000	0.0000	0.0000;
	1679	1678	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4112	1.2863	3.4112	-1.2862	0.0000	0.0000	0.0000	0.0000;
	1681	1680	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.3603	2.9024	-1.3603	-2.9023	0.0000	0.0000	0.0000	0.0000;
	1684	1683	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.5435	-0.7442	21.5438	0.7473	0.0000	0.0000	0.0000	0.0000;
	1686	1685	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1688	1687	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.1930	-0.0532	0.1930	0.0532	0.0000	0.0000	0.0000	0.0000;
	1690	1689	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.5483	-0.9357	-14.5482	0.9372	0.0000	0.0000	0.0000	0.0000;
	1692	1691	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1696	1695	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.0701	-6.1131	26.0706	6.1180	0.0000	0.0000	0.0000	0.0000;
	1698	1697	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.3026	-0.1545	-10.3026	0.1552	0.0000	0.0000	0.0000	0.0000;
	1700	1699	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1704	1703	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1707	1706	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.9003	1.0331	5.9004	-1.0329	0.0000	0.0000	0.0000	0.0000;
	1709	1708	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.4376	0.4569	-18.4374	-0.4546	0.0000	0.0000	0.0000	0.0000;
	1711	1710	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1715	1714	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.4374	0.2874	0.4374	-0.2874	0.0000	0.0000	0.0000	0.0000;
	1717	1716	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.5125	-3.7717	-25.5120	3.7763	0.0000	0.0000	0.0000	0.0000;
	1719	1718	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1721	1720	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.7919	-0.1049	1.7919	0.1049	0.0000	0.0000	0.0000	0.0000;
	1727	1726	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.5674	0.0474	7.5675	-0.0470	0.0000	0.0000	0.0000	0.0000;
	1729	1728	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.9097	-1.5297	21.9100	1.5329	0.0000	0.0000	0.0000	0.0000;
	1731	1730	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.6592	-2.9339	-1.6592	2.9340	0.0000	0.0000	0.0000	0.0000;
	1733	1732	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1736	1735	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.4536	1.1898	7.4536	-1.1894	0.0000	0.0000	0.0000	0.0000;
	1738	1737	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.7973	-0.4337	14.7974	0.4352	0.0000	0.0000	0.0000	0.0000;
	1740	1739	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.4746	7.0755	-0.4746	-7.0751	0.0000	0.0000	0.0000	0.0000;
	1746	1745	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.0698	-0.6849	-2.0698	0.6849	0.0000	0.0000	0.0000	0.0000;
	1748	1747	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.6902	-1.5772	18.6905	1.5797	0.0000	0.0000	0.0000	0.0000;
	1750	1749	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.5241	-1.2508	-7.5240	1.2512	0.0000	0.0000	0.0000	0.0000;
	1752	1751	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.7754	-3.7751	-15.7752	3.7769	0.0000	0.0000	0.0000	0.0000;
	1754	1753	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.9944	-1.3989	-5.9944	1.3992	0.0000	0.0000	0.0000	0.0000;
	1756	1755	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.0662	-1.3211	7.0663	1.3214	0.0000	0.0000	0.0000	0.0000;
	1758	1757	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.9352	-3.0836	4.9352	3.0839	0.0000	0.0000	0.0000	0.0000;
	1762	1761	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.6528	2.9384	-14.6526	-2.9369	0.0000	0.0000	0.0000	0.0000;
	1764	1763	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.1129	-3.6317	19.1132	3.6343	0.0000	0.0000	0.0000	0.0000;
	1766	1765	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1768	1767	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.1479	-1.2684	11.1480	1.2692	0.0000	0.0000	0.0000	0.0000;
	1770	1769	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.0029	0.6793	-3.0029	-0.6792	0.0000	0.0000	0.0000	0.0000;
	1772	1771	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.1450	-2.8099	-4.1450	2.8101	0.0000	0.0000	0.0000	0.0000;
	1774	1773	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.5203	-0.0224	-4.5203	0.0226	0.0000	0.0000	0.0000	0.0000;
	1776	1775	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.2092	1.6378	-4.2092	-1.6376	0.0000	0.0000	0.0000	0.0000;
	1778	1777	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.9389	6.6534	-15.9387	-6.6513	0.0000	0.0000	0.0000	0.0000;
	1782	1781	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.0091	-2.5246	-1.0091	2.5246	0.0000	0.0000	0.0000	0.0000;
	1788	1787	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.7835	6.0600	8.7835	-6.0592	0.0000	0.0000	0.0000	0.0000;
	1790	1789	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.3999	-0.2018	-6.3999	0.2021	0.0000	0.0000	0.0000	0.0000;
	1792	1791	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.0158	-15.1754	26.0165	15.1818	0.0000	0.0000	0.0000	0.0000;
	1793	1794	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1796	1795	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.5891	-4.4065	29.5897	4.4126	0.0000	0.0000	0.0000	0.0000;
	1798	1797	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.4154	-0.2617	10.4154	0.2624	0.0000	0.0000	0.0000	0.0000;
	1803	1802	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.6383	0.5987	13.6384	-0.5974	0.0000	0.0000	0.0000	0.0000;
	1805	1804	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1807	1806	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.3914	0.5881	-10.3913	-0.5873	0.0000	0.0000	0.0000	0.0000;
	1809	1808	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1811	1810	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-43.4072	-4.2814	43.4085	4.2942	0.0000	0.0000	0.0000	0.0000;
	1813	1812	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-31.1146	-11.3683	31.1154	11.3760	0.0000	0.0000	0.0000	0.0000;
	1819	1818	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1821	1820	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.2130	2.4179	16.2131	-2.4160	0.0000	0.0000	0.0000	0.0000;
	1823	1822	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.7528	3.0505	-3.7528	-3.0503	0.0000	0.0000	0.0000	0.0000;
	1825	1824	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.5697	7.0977	3.5697	-7.0972	0.0000	0.0000	0.0000	0.0000;
	1827	1826	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.9395	-4.9983	-8.9394	4.9990	0.0000	0.0000	0.0000	0.0000;
	1829	1828	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1832	1831	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.5370	-0.9640	-2.5370	0.9640	0.0000	0.0000	0.0000	0.0000;
	1834	1833	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.6784	11.0143	-1.6783	-11.0135	0.0000	0.0000	0.0000	0.0000;
	1836	1835	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.3613	4.0999	-2.3613	-4.0997	0.0000	0.0000	0.0000	0.0000;
	1838	1837	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1839	1838	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1837	1839	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1841	1840	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.5455	0.7534	-1.5455	-0.7534	0.0000	0.0000	0.0000	0.0000;
	1845	1844	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.2511	-0.2779	15.2513	0.2795	0.0000	0.0000	0.0000	0.0000;
	1847	1846	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.1927	-0.4346	4.1927	0.4347	0.0000	0.0000	0.0000	0.0000;
	1849	1848	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.9806	1.9527	-4.9806	-1.9525	0.0000	0.0000	0.0000	0.0000;
	1851	1850	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.5717	-2.3291	17.5719	2.3312	0.0000	0.0000	0.0000	0.0000;
	1853	1852	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.2157	-1.3267	4.2157	1.3268	0.0000	0.0000	0.0000	0.0000;
	1855	1854	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.0160	1.3000	-6.0160	-1.2997	0.0000	0.0000	0.0000	0.0000;
	1860	1859	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1862	1861	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.3899	0.1750	0.3899	-0.1750	0.0000	0.0000	0.0000	0.0000;
	1864	1863	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.3256	5.2817	-10.3256	-5.2808	0.0000	0.0000	0.0000	0.0000;
	1866	1865	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.8118	-3.9369	18.8120	3.9395	0.0000	0.0000	0.0000	0.0000;
	1868	1867	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1874	1873	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1880	1879	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.8618	-0.0264	-10.8617	0.0272	0.0000	0.0000	0.0000	0.0000;
	1882	1881	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-51.6189	3.6328	51.6207	-3.6148	0.0000	0.0000	0.0000	0.0000;
	1884	1883	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.7542	-5.3235	4.7543	5.3239	0.0000	0.0000	0.0000	0.0000;
	1886	1885	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.5967	2.8841	1.5967	-2.8840	0.0000	0.0000	0.0000	0.0000;
	1888	1887	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.3538	4.9196	5.3539	-4.9192	0.0000	0.0000	0.0000	0.0000;
	1890	1889	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1892	1891	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.7802	-1.2711	-1.7802	1.2711	0.0000	0.0000	0.0000	0.0000;
	1894	1893	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.0578	-1.6241	3.0578	1.6242	0.0000	0.0000	0.0000	0.0000;
	1896	1895	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.1667	4.3134	12.1668	-4.3123	0.0000	0.0000	0.0000	0.0000;
	1898	1897	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.4053	1.1771	-1.4053	-1.1771	0.0000	0.0000	0.0000	0.0000;
	1902	1901	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.4787	-1.5212	12.4788	1.5223	0.0000	0.0000	0.0000	0.0000;
	1904	1903	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.2900	-2.0124	-19.2897	2.0150	0.0000	0.0000	0.0000	0.0000;
	1906	1905	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.6620	-0.0746	-4.6620	0.0748	0.0000	0.0000	0.0000	0.0000;
	1908	1907	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.6757	-1.0163	-2.6757	1.0164	0.0000	0.0000	0.0000	0.0000;
	1912	1911	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1915	1914	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.9187	-3.2814	-4.9186	3.2816	0.0000	0.0000	0.0000	0.0000;
	1917	1916	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.2646	-0.3672	-0.2646	0.3672	0.0000	0.0000	0.0000	0.0000;
	1919	1918	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.4533	-0.6653	-5.4533	0.6655	0.0000	0.0000	0.0000	0.0000;
	1923	1922	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.0568	1.2262	-15.0566	-1.2247	0.0000	0.0000	0.0000	0.0000;
	1925	1924	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1928	1927	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1930	1929	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-49.2774	-6.5261	49.2791	6.5425	0.0000	0.0000	0.0000	0.0000;
	1938	1937	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1943	1942	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.2368	2.4991	16.2370	-2.4973	0.0000	0.0000	0.0000	0.0000;
	1946	1945	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.7048	3.8698	9.7049	-3.8691	0.0000	0.0000	0.0000	0.0000;
	1949	1948	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.4120	-0.3130	1.4120	0.3130	0.0000	0.0000	0.0000	0.0000;
	1952	1951	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1959	1958	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1964	1963	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1966	1965	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1976	1975	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1978	1977	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1984	1983	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.6204	-17.5731	-14.6200	17.5767	0.0000	0.0000	0.0000	0.0000;
	1993	1992	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1995	1994	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.9370	-0.0350	0.9370	0.0350	0.0000	0.0000	0.0000	0.0000;
	1999	1998	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2001	2000	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2003	2002	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2007	2006	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2010	2009	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.1090	1.4314	15.1091	-1.4298	0.0000	0.0000	0.0000	0.0000;
	2013	2012	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.4628	6.1127	29.4634	-6.1065	0.0000	0.0000	0.0000	0.0000;
	2016	2015	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2019	2018	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.4345	-0.4598	2.4345	0.4598	0.0000	0.0000	0.0000	0.0000;
	2025	2024	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2034	2033	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.7201	2.1917	14.7203	-2.1902	0.0000	0.0000	0.0000	0.0000;
	2039	2038	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2043	2042	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2045	2044	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2048	2047	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.9670	-0.0540	0.9670	0.0540	0.0000	0.0000	0.0000	0.0000;
	2061	2060	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2065	2064	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2070	2069	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2072	2071	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.5555	0.7914	5.5555	-0.7912	0.0000	0.0000	0.0000	0.0000;
	2075	2074	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2078	2077	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2092	2091	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2103	2102	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.9888	-6.4100	-19.9885	6.4130	0.0000	0.0000	0.0000	0.0000;
	2107	2106	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.1094	-4.9450	-18.1091	4.9473	0.0000	0.0000	0.0000	0.0000;
	2109	2108	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2112	2111	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	31.3718	1.4818	-31.3712	-1.4751	0.0000	0.0000	0.0000	0.0000;
	2114	2113	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.4757	5.4946	12.4758	-5.4934	0.0000	0.0000	0.0000	0.0000;
	2121	2120	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.9669	3.3571	0.9670	-3.3570	0.0000	0.0000	0.0000	0.0000;
	2123	2122	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2129	2128	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.3780	0.1660	1.3780	-0.1660	0.0000	0.0000	0.0000	0.0000;
	2131	2130	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2133	2132	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2136	2135	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.3200	-0.7020	2.3200	0.7020	0.0000	0.0000	0.0000	0.0000;
	2139	2138	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2145	2144	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0580	0.0000	0.0580	0.0000	0.0000	0.0000	0.0000;
	2147	2146	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2149	2148	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2155	2154	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2159	2158	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2172	2171	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2177	2176	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2179	2178	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2185	2184	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2199	2198	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4380	-0.8780	3.4380	0.8781	0.0000	0.0000	0.0000	0.0000;
	2208	2207	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2211	2210	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-36.6614	-11.7936	36.6624	11.8035	0.0000	0.0000	0.0000	0.0000;
	2214	2213	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2216	2215	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2218	2217	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.1682	3.6347	-6.1681	-3.6343	0.0000	0.0000	0.0000	0.0000;
	2220	2219	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2223	2222	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.5810	-0.1000	2.5810	0.1000	0.0000	0.0000	0.0000	0.0000;
	2226	2225	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.9114	2.6400	13.9115	-2.6387	0.0000	0.0000	0.0000	0.0000;
	2231	2230	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.1380	0.0000	0.1380	0.0000	0.0000	0.0000	0.0000;
	2235	2234	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2237	2236	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2239	2238	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2248	2247	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2253	2252	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2255	2254	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.2697	-6.8219	29.2703	6.8281	0.0000	0.0000	0.0000	0.0000;
	2259	2258	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2262	2261	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2264	2263	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.0420	-1.2841	30.0426	1.2902	0.0000	0.0000	0.0000	0.0000;
	2275	2274	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.1760	-2.2700	3.1760	2.2701	0.0000	0.0000	0.0000	0.0000;
	2279	2278	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2289	2288	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.7468	0.5686	2.7468	-0.5686	0.0000	0.0000	0.0000	0.0000;
	2291	2290	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0690	0.0000	0.0690	0.0000	0.0000	0.0000	0.0000;
	2295	2294	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2313	2312	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2315	2314	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0740	0.0000	0.0740	0.0000	0.0000	0.0000	0.0000;
	2321	2320	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2343	2342	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.3932	-0.1762	0.3932	0.1762	0.0000	0.0000	0.0000	0.0000;
	2345	2344	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.6031	-7.7139	11.6032	7.7151	0.0000	0.0000	0.0000	0.0000;
	2349	2348	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.8070	-0.8350	4.8070	0.8352	0.0000	0.0000	0.0000	0.0000;
	2352	2351	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2356	2355	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2360	2359	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2362	2361	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2365	2364	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2368	2367	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.8520	-0.3500	0.8520	0.3500	0.0000	0.0000	0.0000	0.0000;
	2370	2369	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2372	2371	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.8797	3.1046	-1.8797	-3.1045	0.0000	0.0000	0.0000	0.0000;
	2375	2374	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2377	2376	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2380	2379	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2386	2385	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2388	2387	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2391	2390	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2423	2422	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0580	0.0000	0.0580	0.0000	0.0000	0.0000	0.0000;
	2425	2424	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.7840	-1.4154	8.7841	1.4159	0.0000	0.0000	0.0000	0.0000;
	2442	2441	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2444	2443	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2446	2445	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2455	2454	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.5097	-0.3586	5.5098	0.3588	0.0000	0.0000	0.0000	0.0000;
	2467	2466	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.3627	-2.1067	-15.3626	2.1083	0.0000	0.0000	0.0000	0.0000;
	2472	2471	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.0348	-3.4727	20.0351	3.4756	0.0000	0.0000	0.0000	0.0000;
	2491	2490	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.0128	-1.2994	27.0133	1.3044	0.0000	0.0000	0.0000	0.0000;
	2493	2492	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.5667	-5.5982	4.5667	5.5986	0.0000	0.0000	0.0000	0.0000;
	2500	2499	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2502	2501	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2504	2503	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2507	2506	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.8291	1.4644	-6.8291	-1.4640	0.0000	0.0000	0.0000	0.0000;
	2521	2520	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	45.5999	28.4061	-45.5979	-28.3861	0.0000	0.0000	0.0000	0.0000;
	2522	2521	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.4733	-20.5055	-17.4728	20.5105	0.0000	0.0000	0.0000	0.0000;
	2529	2528	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.5118	4.5987	-16.5116	-4.5967	0.0000	0.0000	0.0000	0.0000;
	2535	2534	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.7000	0.2000	-0.7000	-0.2000	0.0000	0.0000	0.0000	0.0000;
	2589	2588	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2594	2593	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.8044	5.3394	11.8045	-5.3382	0.0000	0.0000	0.0000	0.0000;
	2596	2595	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.0394	5.3421	6.0394	-5.3417	0.0000	0.0000	0.0000	0.0000;
	2610	2609	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	22.7154	-2.5499	-22.7150	2.5536	0.0000	0.0000	0.0000	0.0000;
	2616	2615	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.9354	-1.0184	-10.9353	1.0193	0.0000	0.0000	0.0000	0.0000;
	2631	2630	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2652	2651	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2662	2661	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.1846	2.9312	28.1851	-2.9257	0.0000	0.0000	0.0000	0.0000;
	2664	2663	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.6369	2.3365	-11.6368	-2.3355	0.0000	0.0000	0.0000	0.0000;
	2681	2680	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.5433	5.2724	-9.5433	-5.2716	0.0000	0.0000	0.0000	0.0000;
	2699	2698	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.5376	-16.9675	-20.5371	16.9724	0.0000	0.0000	0.0000	0.0000;
	2703	2702	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-59.2354	3.4909	59.2378	-3.4667	0.0000	0.0000	0.0000	0.0000;
	2719	2718	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.6506	4.0080	-1.6506	-4.0079	0.0000	0.0000	0.0000	0.0000;
	2722	2721	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.0789	5.7562	-20.0786	-5.7532	0.0000	0.0000	0.0000	0.0000;
	2735	2734	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.2475	1.6558	-4.2475	-1.6557	0.0000	0.0000	0.0000	0.0000;
];

%%-----  OPF Data  -----%%
%% area data
%	area	refbus
mpc.areas = [
	1	18;
];

%% generator cost data
%	1	startup	shutdown	n	x1	y1	...	xn	yn
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	111.63	0;
	2	0	0	3	0	111.63	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
];
