function mpc = case2746wop
%CASE2746WOP    Power flow data for Polish system - winter 2003-04 off-peak.
%   Please see CASEFORMAT for details on the case file format.
%
%   This case represents the Polish 400, 220 and 110 kV networks during
%   winter 2003-04 off-peak conditions. Multiple centrally dispatchable
%   generators at a bus have not been aggregated. Generators that are
%   not centrally dispatchable in the Polish energy market are given a
%   cost of zero.
%
%   This data was graciously provided by, and is distributed with the
%   permission of, Roman Korab <roman.korab@polsl.pl>.

%   MATPOWER
%   $Id: case2746wop.m 4738 2014-07-03 00:55:39Z dchassin $

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin	lam_P	lam_Q	mu_Vmax	mu_Vmin
mpc.bus = [
	1	1	0	0	0	0	1	1.1003396	-5.8041144	220	1	1.11	0.95	91.0752	0.1612	0.0000	0.0000;
	2	1	0	0	0	0	1	1.1039808	-2.5080831	220	1	1.11	0.95	90.2372	0.0981	0.0000	0.0000;
	3	1	0	0	0	0	1	1.0727181	-22.67999	220	1	1.11	0.95	99.4746	0.0556	0.0000	0.0000;
	4	1	0	0	0	0	1	1.0979142	-8.8291158	220	1	1.11	0.95	92.5348	0.2170	0.0000	0.0000;
	5	1	0	0	0	0	1	1.0979424	-8.8358003	220	1	1.11	0.95	92.5362	0.2166	0.0000	0.0000;
	6	1	0	0	0	0	1	1.0787899	-16.503557	220	1	1.11	0.95	95.7776	0.0797	0.0000	0.0000;
	7	1	0	0	0	0	1	1.0788162	-16.497825	220	1	1.11	0.95	95.7746	0.0792	0.0000	0.0000;
	8	1	0	0	0	-50	1	1.029636	-14.94355	400	1	1.05	0.95	95.4057	-0.1452	0.0000	0.0000;
	9	1	0	0	0	0	1	1.0296346	-14.945198	400	1	1.05	0.95	95.4074	-0.1448	0.0000	0.0000;
	10	1	0	0	0	0	1	1.0764851	-16.871989	220	1	1.11	0.95	96.2651	0.1446	0.0000	0.0000;
	11	1	0	0	0	0	1	1.0764187	-16.885088	220	1	1.11	0.95	96.2675	0.1441	0.0000	0.0000;
	12	1	0	0	0	0	1	1.0764286	-16.878588	220	1	1.11	0.95	96.2643	0.1418	0.0000	0.0000;
	13	1	0	0	0	-50	1	1.0247184	-13.167523	400	1	1.05	0.95	94.7302	0.1268	0.0000	0.0000;
	14	1	0	0	0	0	1	1.0248019	-13.162182	400	1	1.05	0.95	94.7274	0.1254	0.0000	0.0000;
	15	1	0	0	0	0	1	1.0390928	-16.217261	400	1	1.05	0.95	95.2293	-1.3509	0.0000	0.0000;
	16	1	0	0	0	0	1	1.0390928	-16.217261	400	1	1.05	0.95	95.2293	-1.3509	0.0000	0.0000;
	17	2	2.302	31	0	0	1	1.1007402	-18.634562	220	1	1.11	0.95	97.2041	-0.0000	0.0000	0.0000;
	18	2	9.7	40	0	0	1	1.1008786	-18.636829	220	1	1.11	0.95	97.2054	0.0000	0.0000	0.0000;
	19	1	0	0	0	0	1	1.0998027	-8.0293797	220	1	1.11	0.95	92.1699	0.2155	0.0000	0.0000;
	20	1	0	0	0	0	1	1.0997938	-8.025711	220	1	1.11	0.95	92.1708	0.2158	0.0000	0.0000;
	21	1	0	0	0	0	1	1.0907944	-18.579546	220	1	1.11	0.95	97.1328	0.0143	0.0000	0.0000;
	22	1	0	0	0	0	1	1.0907944	-18.579546	220	1	1.11	0.95	97.1328	0.0143	0.0000	0.0000;
	23	1	0	0	0	0	1	1.0767644	-16.828683	220	1	1.11	0.95	96.1970	0.0700	0.0000	0.0000;
	24	1	0	0	0	0	1	1.1002404	-5.9666469	220	1	1.11	0.95	91.4932	0.1722	0.0000	0.0000;
	25	1	0	0	0	-50	1	1.0208745	-17.645776	400	1	1.05	0.95	97.1084	0.9915	0.0000	0.0000;
	26	2	28.565	42.054	0	0	1	1.1094364	-5.6168012	220	1	1.11	0.95	90.9717	-0.0000	0.0000	0.0000;
	27	2	85.005	122.06	0	0	1	1.11	-2.2752568	220	1	1.11	0.95	90.1299	0.0000	1246.2206	0.0000;
	28	3	44.783	80	0	0	1	1.048419	-4.412957	400	1	1.05	0.95	91.1767	-0.0000	0.0000	0.0000;
	29	2	60.097	90	0	0	1	1.0484076	-4.4038563	400	1	1.05	0.95	91.1718	-0.0017	0.0000	0.0000;
	30	1	0	0	0	0	1	1.0806119	-18.048309	220	1	1.11	0.95	97.0716	0.1704	0.0000	0.0000;
	31	1	0	0	0	0	1	1.0490196	-5.4090272	400	1	1.05	0.95	91.2070	-0.3208	0.0000	0.0000;
	32	1	0	0	0	0	1	1.0750736	-17.031979	220	1	1.11	0.95	96.3326	0.1655	0.0000	0.0000;
	33	1	0	0	0	0	1	1.1002441	-5.9657856	220	1	1.11	0.95	91.4930	0.1722	0.0000	0.0000;
	34	1	0	0	0	0	1	1.1001336	-11.700376	220	1	1.11	0.95	93.7432	0.1876	0.0000	0.0000;
	35	1	0	0	0	0	1	1.0930028	-14.672176	220	2	1.11	0.95	94.7883	-0.8657	0.0000	0.0000;
	36	1	0	0	0	0	1	1.0813334	-15.095174	220	2	1.11	0.95	95.3394	-0.8172	0.0000	0.0000;
	37	1	0	0	0	0	1	1.090534	-14.116108	220	2	1.11	0.95	94.7038	-1.0768	0.0000	0.0000;
	38	1	0	0	0	0	1	1.0905091	-14.11899	220	2	1.11	0.95	94.7053	-1.0765	0.0000	0.0000;
	39	1	0	0	0	0	1	1.0853026	-15.717887	220	2	1.11	0.95	95.6296	-0.6557	0.0000	0.0000;
	40	1	0	0	0	0	1	1.11	-13.425662	220	2	1.11	0.95	94.1415	-3.4975	20377.2614	0.0000;
	41	1	0	0	0	0	1	1.1099097	-13.42867	220	2	1.11	0.95	94.1434	-3.4837	0.0000	0.0000;
	42	1	0	0	0	0	1	1.026429	-13.487985	400	2	1.05	0.95	94.2405	-2.4059	0.0000	0.0000;
	43	2	12	0	0	0	1	1.0984004	-13.307731	220	2	1.11	0.95	94.2528	-0.6891	0.0000	0.0000;
	44	2	24	0	0	0	1	1.0983481	-13.292422	220	2	1.11	0.95	94.2488	-0.6908	0.0000	0.0000;
	45	2	20	0	0	0	1	1.0325913	-13.232481	400	2	1.05	0.95	94.5600	-0.5862	0.0000	0.0000;
	46	1	0	0	0	0	1	1.032567	-13.234248	400	2	1.05	0.95	94.5595	-0.5865	0.0000	0.0000;
	47	1	0	0	0	0	1	1.1087361	-13.856041	220	2	1.11	0.95	94.4268	-3.3016	0.0000	0.0000;
	48	1	0	0	0	0	1	1.0284578	-17.17828	400	2	1.05	0.95	95.6142	-0.6768	0.0000	0.0000;
	49	1	0	0	0	0	1	1.0284335	-17.183891	400	2	1.05	0.95	95.6169	-0.6759	0.0000	0.0000;
	50	1	0	0	0	0	1	1.0284061	-13.715843	400	2	1.05	0.95	94.6694	-0.6383	0.0000	0.0000;
	51	1	0	0	0	0	1	1.085418	-14.827225	220	2	1.11	0.95	95.0503	-0.6626	0.0000	0.0000;
	52	1	0	0	0	0	1	1.0854171	-14.824059	220	2	1.11	0.95	95.0503	-0.6619	0.0000	0.0000;
	53	1	0	0	0	0	1	1.0367923	-13.975449	400	2	1.05	0.95	94.6640	-1.0822	0.0000	0.0000;
	54	1	0	0	0	0	1	1.0368177	-13.975713	400	2	1.05	0.95	94.6638	-1.0834	0.0000	0.0000;
	55	2	12	0	0	0	1	1.0933675	-13.241702	220	2	1.11	0.95	94.2858	-1.1741	0.0000	0.0000;
	56	2	12	0	0	0	1	1.0933406	-13.24139	220	2	1.11	0.95	94.2831	-1.1766	0.0000	0.0000;
	57	2	12	0	0	0	1	1.0399269	-13.602589	400	2	1.05	0.95	94.4699	-1.2205	0.0000	0.0000;
	58	2	12	0	0	0	1	1.0399116	-13.607331	400	2	1.05	0.95	94.4716	-1.2215	0.0000	0.0000;
	59	2	170.733	62	0	0	1	1.0905288	-14.340794	220	2	1.11	0.95	94.7184	-0.7196	0.0000	0.0000;
	60	1	0	0	0	0	1	1.0905917	-14.3368	220	2	1.11	0.95	94.7166	-0.7200	0.0000	0.0000;
	61	1	0	0	0	0	1	1.1039125	-13.978585	220	2	1.11	0.95	94.4607	-2.8150	0.0000	0.0000;
	62	1	0	0	0	0	1	1.0972139	-14.122428	220	2	1.11	0.95	94.7122	-1.2575	0.0000	0.0000;
	63	1	0	0	0	0	1	1.0971852	-14.124141	220	2	1.11	0.95	94.7125	-1.2535	0.0000	0.0000;
	64	1	0	0	0	0	1	1.0393295	-14.834542	400	2	1.05	0.95	94.8460	-0.9549	0.0000	0.0000;
	65	1	0	0	0	0	1	1.0392873	-14.845309	400	2	1.05	0.95	94.8501	-0.9534	0.0000	0.0000;
	66	1	0	0	0	0	1	1.0885809	-14.851473	220	2	1.11	0.95	95.0154	-0.9744	0.0000	0.0000;
	67	1	0	0	0	0	1	1.089995	-14.701292	220	2	1.11	0.95	94.9206	-0.9983	0.0000	0.0000;
	68	1	0	0	0	0	1	1.0846849	-14.135762	220	2	1.11	0.95	94.7452	-0.5656	0.0000	0.0000;
	69	1	0	0	0	0	1	1.0984623	-9.2101367	220	3	1.11	0.95	92.5536	-0.4363	0.0000	0.0000;
	70	1	6.8	0	0	0	1	1.097636	-14.395557	220	3	1.11	0.95	94.8577	-0.6622	0.0000	0.0000;
	71	1	11.331	2.43	0	0	1	1.0975064	-14.403378	220	3	1.11	0.95	94.8625	-0.6605	0.0000	0.0000;
	72	1	0	0	0	0	1	1.0946558	-13.203738	220	3	1.11	0.95	94.4287	0.0529	0.0000	0.0000;
	73	1	0	0	0	0	1	1.0946671	-13.188287	220	3	1.11	0.95	94.4232	0.0520	0.0000	0.0000;
	74	1	0	0	0	0	1	1.1051601	-10.740817	220	3	1.11	0.95	92.8448	-0.0061	0.0000	0.0000;
	75	1	0	0	0	0	1	1.105133	-10.745835	220	3	1.11	0.95	92.8468	-0.0061	0.0000	0.0000;
	76	1	0	0	0	0	1	1.0977557	-17.582249	220	3	1.11	0.95	96.4839	-0.1590	0.0000	0.0000;
	77	1	0	0	0	0	1	1.0977202	-17.594098	220	3	1.11	0.95	96.4888	-0.1583	0.0000	0.0000;
	78	2	26.999	69.999	0	0	1	1.0964689	-12.136129	220	3	1.11	0.95	93.8755	0.0000	0.0000	0.0000;
	79	2	8.999	20.999	0	0	1	1.0978822	-12.713425	220	3	1.11	0.95	94.1106	-0.1274	0.0000	0.0000;
	80	1	10.085	1.376	0	0	1	1.0931866	-12.507737	220	3	1.11	0.95	94.2409	0.1606	0.0000	0.0000;
	81	1	0	0	0	0	1	1.093188	-12.511077	220	3	1.11	0.95	94.2426	0.1602	0.0000	0.0000;
	82	2	34.999	107.999	0	0	1	1.0444058	-6.4720845	400	3	1.05	0.95	91.2673	-0.2746	0.0000	0.0000;
	83	1	0	0	0	0	1	1.1049043	-10.293455	220	3	1.11	0.95	92.2247	0.1083	0.0000	0.0000;
	84	1	0	0	0	0	1	1.1026824	-11.36773	220	3	1.11	0.95	93.1712	0.0061	0.0000	0.0000;
	85	1	0	0	0	0	1	1.1026432	-11.377001	220	3	1.11	0.95	93.1761	0.0057	0.0000	0.0000;
	86	1	44.148	10.561	0	0	1	1.0984388	-9.2863579	220	3	1.11	0.95	92.5076	-0.3943	0.0000	0.0000;
	87	1	0	0	0	0	1	1.0984259	-9.2914791	220	3	1.11	0.95	92.5093	-0.3942	0.0000	0.0000;
	88	1	0	0	0	0	1	1.0937893	-11.307709	220	3	1.11	0.95	93.2279	0.1169	0.0000	0.0000;
	89	1	0	0	0	0	1	1.0937779	-11.31451	220	3	1.11	0.95	93.2313	0.1172	0.0000	0.0000;
	90	1	0	0	0	0	1	1.1006589	-8.8485145	220	3	1.11	0.95	92.3093	-0.4196	0.0000	0.0000;
	91	1	0	0	0	0	1	1.1006662	-8.8442565	220	3	1.11	0.95	92.3084	-0.4230	0.0000	0.0000;
	92	1	0	0	0	0	1	1.0494747	-6.6627576	400	3	1.05	0.95	91.9021	-0.2194	0.0000	0.0000;
	93	1	0	0	0	0	1	1.0494739	-6.6630247	400	3	1.05	0.95	91.9019	-0.2193	0.0000	0.0000;
	94	1	0	0	0	0	1	1.1018218	-10.698364	220	3	1.11	0.95	92.6759	0.0145	0.0000	0.0000;
	95	1	0	0	0	0	1	1.1018628	-10.698531	220	3	1.11	0.95	92.6753	0.0147	0.0000	0.0000;
	96	1	0	0	0	0	1	1.1057907	-10.479777	220	3	1.11	0.95	92.5431	0.0805	0.0000	0.0000;
	97	1	0	0	0	0	1	1.1057932	-10.478906	220	3	1.11	0.95	92.5417	0.0805	0.0000	0.0000;
	98	1	17.111	6.317	0	0	1	1.0963136	-12.427766	220	3	1.11	0.95	93.9483	-0.3273	0.0000	0.0000;
	99	1	0	0	0	0	1	1.0963094	-12.423739	220	3	1.11	0.95	93.9468	-0.3292	0.0000	0.0000;
	100	1	0	0	0	0	1	1.0976761	-14.377845	220	3	1.11	0.95	94.8491	-0.6629	0.0000	0.0000;
	101	1	0	0	0	0	1	1.0976653	-14.379626	220	3	1.11	0.95	94.8497	-0.6616	0.0000	0.0000;
	102	1	0	0	0	0	1	1.0968926	-16.800572	220	3	1.11	0.95	96.1741	-0.0690	0.0000	0.0000;
	103	1	0	0	0	0	1	1.096839	-16.788467	220	3	1.11	0.95	96.1712	-0.0678	0.0000	0.0000;
	104	2	13.999	39.999	0	0	1	1.1058911	-10.737461	220	3	1.11	0.95	92.7800	0.0000	0.0000	0.0000;
	105	2	0	0	0	0	1	1.1058905	-10.750145	220	3	1.11	0.95	92.7824	-0.0003	0.0000	0.0000;
	106	2	6.999	17.999	0	0	1	1.0998576	-10.553363	220	3	1.11	0.95	92.7163	0.0000	0.0000	0.0000;
	107	2	7.999	14.999	0	0	1	1.0997476	-10.555772	220	3	1.11	0.95	92.7189	0.0002	0.0000	0.0000;
	108	1	52.726	17.138	0	0	1	1.0956641	-11.948298	220	3	1.11	0.95	93.7112	-0.5284	0.0000	0.0000;
	109	1	56.444	10.902	0	0	1	1.095698	-11.961463	220	3	1.11	0.95	93.7153	-0.5333	0.0000	0.0000;
	110	1	0	0	0	0	1	1.093902	-13.568177	220	3	1.11	0.95	94.7342	-0.0907	0.0000	0.0000;
	111	1	0	0	0	0	1	1.0939286	-11.62069	220	3	1.11	0.95	93.5850	0.3044	0.0000	0.0000;
	112	1	0	0	0	0	1	1.0939386	-11.625092	220	3	1.11	0.95	93.5870	0.3038	0.0000	0.0000;
	113	1	0	0	0	0	1	1.0928751	-12.746764	220	3	1.11	0.95	94.3987	0.1266	0.0000	0.0000;
	114	1	0	0	0	0	1	1.0929005	-12.742224	220	3	1.11	0.95	94.3959	0.1257	0.0000	0.0000;
	115	1	0	0	0	0	1	1.040122	-9.1865909	400	3	1.05	0.95	92.5453	-0.1809	0.0000	0.0000;
	116	2	0	0	0	0	1	1.0957717	-12.485668	220	3	1.11	0.95	94.0393	-0.1175	0.0000	0.0000;
	117	2	7.999	14.999	0	0	1	1.0957311	-12.476078	220	3	1.11	0.95	94.0370	-0.1170	0.0000	0.0000;
	118	2	5.499	9.999	0	0	1	1.0999227	-13.165235	220	3	1.11	0.95	94.4918	-0.2638	0.0000	0.0000;
	119	1	0	0	0	0	1	1.0999096	-13.17059	220	3	1.11	0.95	94.4941	-0.2640	0.0000	0.0000;
	120	1	0	0	0	0	1	1.042963	-13.58135	400	3	1.05	0.95	94.4477	-0.9211	0.0000	0.0000;
	121	1	0	0	0	0	1	1.0429996	-13.574265	400	3	1.05	0.95	94.4444	-0.9215	0.0000	0.0000;
	122	1	0	0	0	0	1	1.0434218	-9.342175	400	3	1.05	0.95	92.6467	-0.2911	0.0000	0.0000;
	123	1	0	0	0	0	1	1.0434566	-9.340653	400	3	1.05	0.95	92.6469	-0.2918	0.0000	0.0000;
	124	1	0	0	0	0	1	1.0942312	-13.598007	220	3	1.11	0.95	94.7830	-0.1073	0.0000	0.0000;
	125	2	19.213	21.474	0	0	1	1.11	-9.7385765	220	3	1.11	0.95	92.2959	0.0000	312.7178	0.0000;
	126	2	30.672	33.602	0	0	1	1.1099486	-9.7467082	220	3	1.11	0.95	92.3016	0.0014	0.0000	0.0000;
	127	2	27.999	65.999	0	0	1	1.0401443	-8.1111678	400	3	1.05	0.95	92.1616	-0.1196	0.0000	0.0000;
	128	1	0	0	0	0	1	1.0401433	-8.1210678	400	3	1.05	0.95	92.1654	-0.1198	0.0000	0.0000;
	129	1	0	0	0	0	1	1.0980766	-9.3931842	220	3	1.11	0.95	92.5556	-0.3920	0.0000	0.0000;
	130	1	0	0	0	0	1	1.0980814	-9.3920832	220	3	1.11	0.95	92.5538	-0.3914	0.0000	0.0000;
	131	1	0	0	0	0	1	1.0993526	-9.2111481	220	3	1.11	0.95	92.4642	-0.3832	0.0000	0.0000;
	132	2	271.999	-62.001	0	0	1	1.0990964	-18.413405	220	3	1.11	0.95	96.8483	-0.2373	0.0000	0.0000;
	133	2	266.5	-24.8	0	0	1	1.097002	-18.398163	220	3	1.11	0.95	96.8472	-0.1873	0.0000	0.0000;
	134	2	14.931	12.88	0	0	1	1.1065123	-13.462082	220	4	1.11	0.95	94.6117	-0.0000	0.0000	0.0000;
	135	2	8.013	6.525	0	0	1	1.1064205	-13.470946	220	4	1.11	0.95	94.6144	0.0011	0.0000	0.0000;
	136	1	0	0	0	0	1	1.0815293	-16.24031	220	4	1.11	0.95	95.3127	0.0668	0.0000	0.0000;
	137	1	0	0	0	0	1	1.0845102	-15.737843	220	4	1.11	0.95	95.0213	0.0193	0.0000	0.0000;
	138	1	0	0	0	0	1	1.0450222	-13.350134	400	4	1.05	0.95	93.9007	-0.5766	0.0000	0.0000;
	139	1	0	0	0	0	1	1.0450451	-13.346304	400	4	1.05	0.95	93.8981	-0.5778	0.0000	0.0000;
	140	1	0	0	0	0	1	1.104459	-22.571041	220	4	1.11	0.95	99.9483	-2.0055	0.0000	0.0000;
	141	1	0	0	0	0	1	1.0845379	-24.970176	220	4	1.11	0.95	101.9983	-1.4777	0.0000	0.0000;
	142	1	0	0	0	0	1	1.0845379	-24.970176	220	4	1.11	0.95	101.9983	-1.4777	0.0000	0.0000;
	143	1	0	0	0	0	1	1.0868162	-23.55336	220	4	1.11	0.95	100.4360	-1.3126	0.0000	0.0000;
	144	1	0	0	0	0	1	1.0904594	-14.90911	220	4	1.11	0.95	93.9070	-0.1480	0.0000	0.0000;
	145	1	0	0	0	0	1	1.0904594	-14.90911	220	4	1.11	0.95	93.9070	-0.1480	0.0000	0.0000;
	146	2	55.255	6.955	0	0	1	1.1010599	-16.894759	220	4	1.11	0.95	96.4200	-0.0195	0.0000	0.0000;
	147	2	10.077	8.4	0	0	1	1.1010627	-16.90408	220	4	1.11	0.95	96.4222	-0.0209	0.0000	0.0000;
	148	2	11.5	6.86	0	0	1	1.0847972	-24.077917	220	4	1.11	0.95	101.4573	-1.5655	0.0000	0.0000;
	149	1	4.423	1.347	0	0	1	1.0847555	-24.092279	220	4	1.11	0.95	101.4641	-1.5657	0.0000	0.0000;
	150	2	12.633	6.828	0	0	1	1.0209404	-25.772587	400	4	1.05	0.95	101.8467	-1.7352	0.0000	0.0000;
	151	2	12.397	10.045	0	0	1	1.0209246	-25.77869	400	4	1.05	0.95	101.8493	-1.7356	0.0000	0.0000;
	152	1	0	0	0	0	1	1.0894799	-22.639017	220	4	1.11	0.95	100.3568	-1.5484	0.0000	0.0000;
	153	1	0	0	0	0	1	1.0822243	-21.657901	220	4	1.11	0.95	99.1685	-0.6388	0.0000	0.0000;
	154	1	0	0	0	0	1	1.0822555	-21.651456	220	4	1.11	0.95	99.1650	-0.6388	0.0000	0.0000;
	155	2	33.593	44.976	0	0	1	1.0890716	-14.012337	220	4	1.11	0.95	94.1898	0.0000	0.0000	0.0000;
	156	2	33.832	45.07	0	0	1	1.0889495	-14.067839	220	4	1.11	0.95	94.4125	0.0000	0.0000	0.0000;
	157	1	0	0	0	0	1	1.0890716	-14.012337	220	4	1.11	0.95	94.1898	0.0000	0.0000	0.0000;
	158	1	0	0	0	0	1	1.0340575	-13.036901	400	4	1.05	0.95	94.1427	-0.1131	0.0000	0.0000;
	159	2	8.687	17.49	0	0	1	1.0340329	-13.034686	400	4	1.05	0.95	94.1427	-0.1124	0.0000	0.0000;
	160	1	0	0	0	0	1	1.0842564	-25.032974	220	4	1.11	0.95	102.0466	-1.6448	0.0000	0.0000;
	161	1	0	0	0	0	1	1.0842564	-25.032974	220	4	1.11	0.95	102.0466	-1.6448	0.0000	0.0000;
	162	1	0	0	0	0	1	1.05	-12.564217	400	4	1.05	0.95	93.1599	-2.0147	8269.9647	0.0000;
	163	1	0	0	0	0	1	1.0483545	-11.638085	400	4	1.05	0.95	92.9831	-0.9545	0.0000	0.0000;
	164	1	0	0	0	0	1	1.0483556	-11.644285	400	4	1.05	0.95	92.9864	-0.9533	0.0000	0.0000;
	165	2	5.495	9.587	0	0	1	1.1008249	-17.138713	220	4	1.11	0.95	96.5419	-0.0000	0.0000	0.0000;
	166	2	10.099	4.886	0	0	1	1.1007016	-17.154685	220	4	1.11	0.95	96.5512	0.0012	0.0000	0.0000;
	167	1	14.36	13.623	0	0	1	1.1007966	-17.139982	220	4	1.11	0.95	96.5424	0.0004	0.0000	0.0000;
	168	1	0	0	0	0	1	1.1079282	-28.127364	220	4	1.11	0.95	103.3368	-2.2224	0.0000	0.0000;
	169	1	0	0	0	0	1	1.087324	-25.067011	220	4	1.11	0.95	102.0493	-1.5190	0.0000	0.0000;
	170	1	0	0	0	0	1	1.11	-23.559049	220	4	1.11	0.95	100.5561	-2.7733	11480.4692	0.0000;
	171	1	0	0	0	0	1	1.1098972	-23.558201	220	4	1.11	0.95	100.5570	-2.7618	0.0000	0.0000;
	172	1	0	0	0	0	1	0.96398571	-24.638265	400	4	1.05	0.95	100.9598	-2.1379	0.0000	0.0000;
	173	1	0	0	0	0	1	0.96398571	-24.638265	400	4	1.05	0.95	100.9598	-2.1379	0.0000	0.0000;
	174	1	0	0	0	0	1	1.0696839	-20.949808	220	4	1.11	0.95	99.3692	-0.3413	0.0000	0.0000;
	175	1	0	0	0	0	1	1.0696958	-20.947885	220	4	1.11	0.95	99.3693	-0.3411	0.0000	0.0000;
	176	1	0	0	0	0	1	1.1082501	-23.792603	220	4	1.11	0.95	100.6723	-2.6840	0.0000	0.0000;
	177	1	0	0	0	0	1	1.0859664	-15.678153	220	4	1.11	0.95	94.9201	-0.0123	0.0000	0.0000;
	178	1	0	0	0	0	1	1.0859993	-15.673145	220	4	1.11	0.95	94.9186	-0.0124	0.0000	0.0000;
	179	1	0	0	0	0	1	1.0917114	-14.683654	220	4	1.11	0.95	94.3367	0.0111	0.0000	0.0000;
	180	1	0	0	0	0	1	1.0917114	-14.683654	220	4	1.11	0.95	94.3367	0.0111	0.0000	0.0000;
	181	1	0	0	0	0	1	1.0678356	-21.76123	220	4	1.11	0.95	99.6432	-0.3535	0.0000	0.0000;
	182	1	0	0	0	0	1	1.063868	-24.73491	220	5	1.11	0.95	101.1180	0.8305	0.0000	0.0000;
	183	1	0	0	0	0	1	1.11	-31.694348	220	5	1.11	0.95	104.4421	-1.8081	1861.5694	0.0000;
	184	1	0	0	0	0	1	1.0275404	-31.317799	400	5	1.05	0.95	104.1476	-1.2745	0.0000	0.0000;
	185	1	0	0	0	0	1	1.0275436	-31.310859	400	5	1.05	0.95	104.1440	-1.2754	0.0000	0.0000;
	186	1	0	0	0	0	1	1.0179187	-33.636246	400	5	1.05	0.95	105.1032	0.3110	0.0000	0.0000;
	187	1	0	0	0	0	1	1.0179404	-33.643752	400	5	1.05	0.95	105.1071	0.3094	0.0000	0.0000;
	188	1	0	0	0	0	1	1.0778956	-31.850779	220	5	1.11	0.95	105.5364	-0.0614	0.0000	0.0000;
	189	1	0	0	0	0	1	1.0779468	-31.854197	220	5	1.11	0.95	105.5370	-0.0635	0.0000	0.0000;
	190	1	0	0	0	0	1	1.060876	-26.835974	220	5	1.11	0.95	102.4103	1.1790	0.0000	0.0000;
	191	1	0	0	0	0	1	1.0609263	-26.833741	220	5	1.11	0.95	102.4091	1.1774	0.0000	0.0000;
	192	1	0	0	0	0	1	1.0061829	-26.37235	400	5	1.05	0.95	101.7977	1.2095	0.0000	0.0000;
	193	1	0	0	0	0	1	1.0693967	-24.332532	220	5	1.11	0.95	100.9086	0.8349	0.0000	0.0000;
	194	1	0	0	0	0	1	1.0693881	-24.329742	220	5	1.11	0.95	100.9088	0.8356	0.0000	0.0000;
	195	1	0	0	0	0	1	1.0184099	-32.763078	400	5	1.05	0.95	104.9447	0.3712	0.0000	0.0000;
	196	1	0	0	0	0	1	1.0183911	-32.760735	400	5	1.05	0.95	104.9441	0.3718	0.0000	0.0000;
	197	1	0	0	0	0	1	1.0693764	-26.606702	220	5	1.11	0.95	102.9941	0.7578	0.0000	0.0000;
	198	1	0	0	0	0	1	1.0693398	-26.599683	220	5	1.11	0.95	102.9894	0.7586	0.0000	0.0000;
	199	1	0	0	0	0	1	1.0266211	-32.853512	400	5	1.05	0.95	104.7693	-0.7581	0.0000	0.0000;
	200	1	0	0	0	0	1	1.0266502	-32.840632	400	5	1.05	0.95	104.7640	-0.7604	0.0000	0.0000;
	201	1	0	0	0	0	1	1.0504501	-26.531904	220	5	1.11	0.95	102.9710	1.4267	0.0000	0.0000;
	202	1	0	0	0	0	1	1.0504315	-26.525917	220	5	1.11	0.95	102.9701	1.4270	0.0000	0.0000;
	203	1	0	0	0	0	1	1.0520891	-24.098864	220	5	1.11	0.95	101.7793	1.3935	0.0000	0.0000;
	204	1	0	0	0	0	1	1.0520151	-24.112731	220	5	1.11	0.95	101.7861	1.3950	0.0000	0.0000;
	205	2	619.912	0	0	0	1	1.0176137	-35.925103	400	5	1.05	0.95	105.9174	0.0002	0.0000	0.0000;
	206	2	205.255	0	0	0	1	1.0175965	-35.923079	400	5	1.05	0.95	105.9164	0.0017	0.0000	0.0000;
	207	1	0	0	0	0	1	1.1006654	-32.082795	220	5	1.11	0.95	105.0012	-1.5779	0.0000	0.0000;
	208	1	0	0	0	0	1	1.1006733	-32.085901	220	5	1.11	0.95	105.0011	-1.5767	0.0000	0.0000;
	209	1	5.821	1.5	0	0	1	1.0893953	-19.598542	110	1	1.12	0.95	97.9657	-1.5205	0.0000	0.0000;
	210	1	4.366	0.5	0	0	1	1.0780802	-26.947828	110	1	1.12	0.95	103.1849	0.2755	0.0000	0.0000;
	211	1	7.761	2	0	0	1	1.0946101	-18.29998	110	1	1.12	0.95	96.0243	0.2300	0.0000	0.0000;
	212	1	6.306	5.6	0	0	1	1.043808	-21.64187	110	1	1.12	0.95	101.0962	1.8801	0.0000	0.0000;
	213	1	2.523	0.6	0	0	1	1.0691315	-5.1118202	110	1	1.12	0.95	91.0765	0.2527	0.0000	0.0000;
	214	1	4.851	1.3	0	0	1	1.0831021	-7.6101832	110	1	1.12	0.95	91.6312	0.2877	0.0000	0.0000;
	215	2	19.194	8	0	0	1	1.1183524	-17.842005	110	1	1.12	0.95	94.4391	-2.1719	0.0000	0.0000;
	216	1	14.553	1.5	0	0	1	1.1175586	-18.044515	110	1	1.12	0.95	94.6502	-2.3622	0.0000	0.0000;
	217	1	4.851	1	0	0	1	1.1176337	-18.005824	110	1	1.12	0.95	94.6099	-2.3129	0.0000	0.0000;
	218	1	4.851	1	0	0	1	1.1172392	-18.107849	110	1	1.12	0.95	94.6648	-2.1363	0.0000	0.0000;
	219	2	8.247	1.6	0	0	1	1.0797758	-21.097123	110	1	1.12	0.95	99.1137	0.2069	0.0000	0.0000;
	220	1	5.822	1.5	0	0	1	1.0835093	-19.405697	110	1	1.12	0.95	97.3759	0.5103	0.0000	0.0000;
	221	2	0	0	0	0	1	1.0721998	-16.594249	110	1	1.12	0.95	93.9195	-1.0326	0.0000	0.0000;
	222	2	6.306	1.5	0	0	1	1.0946839	-11.808388	110	1	1.12	0.95	94.1379	-0.3592	0.0000	0.0000;
	223	2	15.523	2.6	0	0	1	1.0853883	-20.402784	110	1	1.12	0.95	97.6954	0.3471	0.0000	0.0000;
	224	1	1.649	0.4	0	0	1	1.0538034	-7.0321268	110	1	1.12	0.95	92.5272	0.3817	0.0000	0.0000;
	225	1	2.425	0.2	0	0	1	1.0754425	-23.07969	110	1	1.12	0.95	99.5630	1.1050	0.0000	0.0000;
	226	1	2.911	0.5	0	0	1	1.0966155	-23.49709	110	1	1.12	0.95	99.4114	-0.3934	0.0000	0.0000;
	227	1	10.672	0.499	0	0	1	1.1065854	-19.005119	110	1	1.12	0.95	96.3484	-2.3882	0.0000	0.0000;
	228	1	6.791	2	0	0	1	1.0818807	-20.892765	110	1	1.12	0.95	98.0529	0.4670	0.0000	0.0000;
	229	2	2.231	1.05	0	0	1	1.1068722	-11.6927	110	1	1.12	0.95	93.6474	0.1449	0.0000	0.0000;
	230	2	2.231	1.05	0	0	1	1.107264	-11.6972	110	1	1.12	0.95	93.6442	0.1324	0.0000	0.0000;
	231	1	11.642	6	0	0	1	1.0775116	-20.614289	110	1	1.12	0.95	98.2694	0.6446	0.0000	0.0000;
	232	1	4.366	1	0	0	1	1.084071	-7.5052918	110	1	1.12	0.95	91.5210	0.2702	0.0000	0.0000;
	233	1	8.732	1	0	0	1	1.0721931	-14.854686	110	1	1.12	0.95	95.3342	-0.9151	0.0000	0.0000;
	234	1	16.493	14	0	0	1	1.0685775	-5.7867467	110	1	1.12	0.95	91.0046	0.4646	0.0000	0.0000;
	235	1	3.978	0.5	0	0	1	1.077336	-23.526478	110	1	1.12	0.95	100.5388	0.2160	0.0000	0.0000;
	236	1	8.926	3.64	0	0	1	1.1110461	-11.05696	110	1	1.12	0.95	92.7618	0.0930	0.0000	0.0000;
	237	1	4.463	0.3	0	0	1	1.0766985	-23.563158	110	1	1.12	0.95	100.5926	0.2108	0.0000	0.0000;
	238	1	5.821	1	0	0	1	1.0885291	-20.919882	110	1	1.12	0.95	98.2355	-0.8153	0.0000	0.0000;
	239	2	4.305	1.175	0	0	1	1.0752469	-21.133952	110	1	1.12	0.95	98.9912	0.4628	0.0000	0.0000;
	240	1	7.471	1	0	0	1	1.061592	-27.435014	110	1	1.12	0.95	103.2622	1.0614	0.0000	0.0000;
	241	1	4.463	1.67	0	0	1	1.1110439	-11.243631	110	1	1.12	0.95	93.0383	0.0889	0.0000	0.0000;
	242	1	6.791	0.7	0	0	1	1.1177729	-8.7603582	110	1	1.12	0.95	90.5300	-2.1839	0.0000	0.0000;
	243	1	0	0	0	0	1	1.1178589	-8.7383321	110	1	1.12	0.95	90.5298	-2.1929	0.0000	0.0000;
	244	1	2.231	1.4	0	0	1	1.0915174	-18.434223	110	1	1.12	0.95	96.4735	0.0294	0.0000	0.0000;
	245	1	0	0	0	0	1	1.0783284	-3.6082787	110	1	1.12	0.95	90.2340	0.1585	0.0000	0.0000;
	246	2	1.982	5	0	0	1	1.0855015	-0.2958284	22	1	1.12	0.95	90.4966	-0.0000	0.0000	0.0000;
	247	1	6.792	1.5	0	0	1	1.093579	-24.555447	110	1	1.12	0.95	100.8349	-0.2724	0.0000	0.0000;
	248	1	1.94	0.5	0	0	1	1.0933423	-25.308525	110	1	1.12	0.95	100.0227	0.2658	0.0000	0.0000;
	249	1	1.94	0.5	0	0	1	1.1018756	-23.685465	110	1	1.12	0.95	99.5626	-0.4745	0.0000	0.0000;
	250	1	2.911	0.5	0	0	1	1.0632486	-28.336295	110	1	1.12	0.95	106.3598	0.1628	0.0000	0.0000;
	251	1	2.814	0.5	0	0	1	1.0844642	-20.775446	110	1	1.12	0.95	97.7534	0.6924	0.0000	0.0000;
	252	1	10.672	7	0	0	1	1.0727626	-16.114865	110	1	1.12	0.95	95.4129	0.6761	0.0000	0.0000;
	253	1	21.345	5	0	0	1	1.0767513	-20.843149	110	1	1.12	0.95	98.4146	0.6450	0.0000	0.0000;
	254	1	8.732	2	0	0	1	1.0684869	-28.559916	110	1	1.12	0.95	103.5618	0.7875	0.0000	0.0000;
	255	1	18.433	1	0	0	1	1.1007103	-22.993531	110	1	1.12	0.95	98.9488	-0.7426	0.0000	0.0000;
	256	1	3.396	0.5	0	0	1	1.1012721	-23.168569	110	1	1.12	0.95	99.0170	-0.6522	0.0000	0.0000;
	257	1	2.425	0.35	0	0	1	1.0709915	-4.861503	110	1	1.12	0.95	91.2042	0.3070	0.0000	0.0000;
	258	1	2.425	0.35	0	0	1	1.0709312	-4.8717295	110	1	1.12	0.95	91.2077	0.3079	0.0000	0.0000;
	259	1	6.791	2.54	0	0	1	1.100147	-12.251615	110	1	1.12	0.95	94.3128	0.3101	0.0000	0.0000;
	260	1	4.851	1	0	0	1	1.0613374	-28.721247	110	1	1.12	0.95	106.8301	0.1382	0.0000	0.0000;
	261	1	2.134	0.5	0	0	1	1.0998302	-18.516798	110	1	1.12	0.95	96.2820	0.0149	0.0000	0.0000;
	262	1	7.276	1.6	0	0	1	1.0867375	-18.241882	110	1	1.12	0.95	96.6175	0.2253	0.0000	0.0000;
	263	1	0.776	0.5	0	0	1	1.0730617	-24.726757	110	1	1.12	0.95	101.2008	0.3817	0.0000	0.0000;
	264	1	41.719	37	0	0	1	1.0760739	-4.0395362	110	1	1.12	0.95	90.3770	0.1907	0.0000	0.0000;
	265	1	43.66	40	0	0	1	1.0767596	-7.2243557	110	1	1.12	0.95	91.3202	0.4168	0.0000	0.0000;
	266	1	2.911	1	0	0	1	1.08214	-20.125961	110	1	1.12	0.95	97.8292	0.5128	0.0000	0.0000;
	267	1	8.247	0.7	0	0	1	1.0804063	-21.053651	110	1	1.12	0.95	98.4136	0.0620	0.0000	0.0000;
	268	1	5.336	1.1	0	0	1	1.0847404	-20.674913	110	1	1.12	0.95	97.6082	0.7979	0.0000	0.0000;
	269	1	7.761	1.5	0	0	1	1.1076506	-19.037162	110	1	1.12	0.95	96.2427	-2.3531	0.0000	0.0000;
	270	1	5.821	1.5	0	0	1	1.0649129	-27.945983	110	1	1.12	0.95	105.9202	0.1894	0.0000	0.0000;
	271	1	10.672	2.75	0	0	1	1.0823726	-19.058545	110	1	1.12	0.95	96.9231	0.5788	0.0000	0.0000;
	272	1	0.098	0	0	0	1	1.0808014	-20.628245	110	1	1.12	0.95	98.9419	0.2870	0.0000	0.0000;
	273	1	0.097	0.03	0	0	1	1.1014805	-17.787678	110	1	1.12	0.95	95.6030	0.0721	0.0000	0.0000;
	274	1	0.097	0.03	0	0	1	1.0939022	-18.352137	110	1	1.12	0.95	96.2892	0.2756	0.0000	0.0000;
	275	1	7.451	3.94	0	0	1	1.1088156	-10.503272	110	1	1.12	0.95	92.5317	0.2934	0.0000	0.0000;
	276	1	4.967	2.63	0	0	1	1.1132525	-10.968029	110	1	1.12	0.95	92.6084	0.0659	0.0000	0.0000;
	277	1	5.239	1.2	0	0	1	1.0978754	-11.570257	110	1	1.12	0.95	93.7387	-0.4277	0.0000	0.0000;
	278	1	1.94	0	0	0	1	1.1095268	-18.963812	110	1	1.12	0.95	95.6635	-1.6148	0.0000	0.0000;
	279	1	5.336	0	0	0	1	1.0947849	-20.321637	110	1	1.12	0.95	97.3622	-0.5540	0.0000	0.0000;
	280	1	10.672	3	0	0	1	1.0948371	-18.2804	110	1	1.12	0.95	96.3241	0.2345	0.0000	0.0000;
	281	1	7.761	1	0	0	1	1.0714759	-19.886669	110	1	1.12	0.95	97.9373	0.5702	0.0000	0.0000;
	282	1	22.314	21	0	0	1	1.068342	-6.8444492	110	1	1.12	0.95	91.3253	0.5187	0.0000	0.0000;
	283	1	15.524	13	0	0	1	1.0682129	-6.8223579	110	1	1.12	0.95	91.3228	0.5189	0.0000	0.0000;
	284	1	7.762	3.17	0	0	1	1.1074929	-10.365018	110	1	1.12	0.95	92.4687	0.3590	0.0000	0.0000;
	285	1	10.672	1.6	0	0	1	1.1037976	-11.2444	110	1	1.12	0.95	93.2850	0.3352	0.0000	0.0000;
	286	1	5.821	0.5	0	0	1	1.0917512	-23.189868	110	1	1.12	0.95	99.1341	-0.2848	0.0000	0.0000;
	287	1	3.396	0	0	0	1	1.1110163	-19.904455	110	1	1.12	0.95	96.0519	-1.6062	0.0000	0.0000;
	288	1	2.425	0.5	0	0	1	1.0745673	-20.662545	110	1	1.12	0.95	98.5944	0.5207	0.0000	0.0000;
	289	1	2.425	0.6	0	0	1	1.099565	-14.075415	110	1	1.12	0.95	95.5458	0.2128	0.0000	0.0000;
	290	1	16.008	6	0	0	1	1.0723554	-19.777479	110	1	1.12	0.95	97.8159	0.5569	0.0000	0.0000;
	291	2	9.702	1	0	0	1	1.1009634	-18.317475	110	1	1.12	0.95	96.0463	0.0000	0.0000	0.0000;
	292	1	5.239	1.96	0	0	1	1.1075243	-10.167008	110	1	1.12	0.95	92.2936	0.3814	0.0000	0.0000;
	293	1	1.94	1.3	0	0	1	1.0793622	-18.725171	110	1	1.12	0.95	97.0862	0.0513	0.0000	0.0000;
	294	2	4.657	0.8	0	0	1	1.0795377	-21.410581	110	1	1.12	0.95	98.8780	0.0223	0.0000	0.0000;
	295	1	6.209	0.9	0	0	1	1.1001007	-13.85187	110	1	1.12	0.95	95.3463	0.2188	0.0000	0.0000;
	296	1	3.881	2	0	0	1	1.1056563	-10.867097	110	1	1.12	0.95	92.8062	-0.7699	0.0000	0.0000;
	297	1	7.276	2.97	0	0	1	1.1045666	-11.749084	110	1	1.12	0.95	93.7143	0.2329	0.0000	0.0000;
	298	1	9.8	3.67	0	0	1	1.1060563	-11.761412	110	1	1.12	0.95	93.7269	0.1723	0.0000	0.0000;
	299	2	9.702	3.5	0	0	1	1.1062355	-19.171947	110	1	1.12	0.95	95.9727	-1.9513	0.0000	0.0000;
	300	1	0	0	0	0	1	1.1135182	-10.972188	110	1	1.12	0.95	92.6084	0.0524	0.0000	0.0000;
	301	1	3.881	0.5	0	0	1	1.0492538	-7.6572148	110	1	1.12	0.95	93.2805	0.4122	0.0000	0.0000;
	302	1	8.15	3.33	0	0	1	1.1075531	-10.162469	110	1	1.12	0.95	92.2890	0.3813	0.0000	0.0000;
	303	1	9.605	3.59	0	0	1	1.1109223	-11.241758	110	1	1.12	0.95	93.0323	0.0962	0.0000	0.0000;
	304	1	13.291	4.97	0	0	1	1.108933	-10.376113	110	1	1.12	0.95	92.4418	0.3139	0.0000	0.0000;
	305	1	14.844	5.55	0	0	1	1.1051559	-11.758363	110	1	1.12	0.95	93.7212	0.2042	0.0000	0.0000;
	306	2	78.068	52.19	0	0	1	1.1019165	-11.609086	110	1	1.12	0.95	93.5638	0.3806	0.0000	0.0000;
	307	2	52.074	20.97	0	0	1	1.1066548	-11.686355	110	1	1.12	0.95	93.6380	0.1551	0.0000	0.0000;
	308	2	18.922	9.47	0	0	1	1.1129305	-11.213197	110	1	1.12	0.95	93.0280	-0.0000	0.0000	0.0000;
	309	1	0	0	0	0	1	1.1047854	-11.752653	110	1	1.12	0.95	93.7168	0.2218	0.0000	0.0000;
	310	2	36.737	19.74	0	0	1	1.1106088	-10.347089	110	1	1.12	0.95	92.3616	0.2446	0.0000	0.0000;
	311	2	29.633	16.42	0	0	1	1.1134899	-11.051498	110	1	1.12	0.95	92.6966	-0.0000	0.0000	0.0000;
	312	1	8.053	0.8	0	0	1	1.1034877	-13.008117	110	1	1.12	0.95	94.6346	0.1839	0.0000	0.0000;
	313	1	1.94	0	0	0	1	1.1118562	-18.815042	110	1	1.12	0.95	95.6571	-2.3571	0.0000	0.0000;
	314	1	0.97	0.501	0	0	1	1.0769668	-20.541498	110	1	1.12	0.95	98.4975	0.5345	0.0000	0.0000;
	315	1	5.578	0.75	0	0	1	1.0748035	-20.952427	110	1	1.12	0.95	98.8890	0.5320	0.0000	0.0000;
	316	1	8.489	1.25	0	0	1	1.0748103	-20.9414	110	1	1.12	0.95	98.8863	0.5324	0.0000	0.0000;
	317	1	12.419	3	0	0	1	1.0860755	-18.860027	110	1	1.12	0.95	96.6204	0.4890	0.0000	0.0000;
	318	1	6.694	2.5	0	0	1	1.1083996	-10.326425	110	1	1.12	0.95	92.4086	0.3403	0.0000	0.0000;
	319	2	12.03	4.5	0	0	1	1.1082845	-10.53425	110	1	1.12	0.95	92.5697	0.3046	0.0000	0.0000;
	320	1	10.672	2.5	0	0	1	1.0930169	-20.629709	110	1	1.12	0.95	97.7216	-0.4276	0.0000	0.0000;
	321	1	11.642	4.75	0	0	1	1.112626	-11.077955	110	1	1.12	0.95	92.7345	0.0297	0.0000	0.0000;
	322	1	11.613	4.74	0	0	1	1.1007043	-11.686497	110	1	1.12	0.95	93.6554	0.4174	0.0000	0.0000;
	323	1	4.977	2.03	0	0	1	1.102099	-11.676436	110	1	1.12	0.95	93.6381	0.3579	0.0000	0.0000;
	324	1	9.702	2.5	0	0	1	1.0938518	-20.383829	110	1	1.12	0.95	97.4484	-0.4707	0.0000	0.0000;
	325	1	14.553	3	0	0	1	1.0737942	-21.544067	110	1	1.12	0.95	99.5146	0.4418	0.0000	0.0000;
	326	1	8.926	3.34	0	0	1	1.1021181	-11.678264	110	1	1.12	0.95	93.6399	0.3570	0.0000	0.0000;
	327	1	5.336	1	0	0	1	1.1059571	-11.303873	110	1	1.12	0.95	93.1252	-0.1838	0.0000	0.0000;
	328	1	2.911	0.6	0	0	1	1.1055599	-11.323435	110	1	1.12	0.95	93.1571	-0.2161	0.0000	0.0000;
	329	1	38.225	14.3	0	0	1	1.1057803	-10.705471	110	1	1.12	0.95	92.7662	0.3788	0.0000	0.0000;
	330	1	11.643	1	0	0	1	1.0859804	-16.225976	110	1	1.12	0.95	95.3538	-0.3071	0.0000	0.0000;
	331	1	0	0	0	0	1	1.1004887	-12.260886	110	1	1.12	0.95	94.3129	0.2796	0.0000	0.0000;
	332	1	6.791	2	0	0	1	1.0726917	-21.612266	110	1	1.12	0.95	99.6450	0.4780	0.0000	0.0000;
	333	1	3.881	0.2	0	0	1	1.0593344	-28.857719	110	1	1.12	0.95	103.8920	1.2644	0.0000	0.0000;
	334	1	8.635	3.23	0	0	1	1.1110863	-11.191564	110	1	1.12	0.95	92.9592	0.0992	0.0000	0.0000;
	335	1	7.276	1.9	0	0	1	1.0849508	-21.150399	110	1	1.12	0.95	98.6731	-0.5334	0.0000	0.0000;
	336	1	14.553	4.5	0	0	1	1.1015885	-17.792705	110	1	1.12	0.95	95.5879	0.0687	0.0000	0.0000;
	337	1	14.553	4.5	0	0	1	1.083528	-18.944977	110	1	1.12	0.95	96.8192	0.5329	0.0000	0.0000;
	338	1	3.396	0	0	0	1	1.1139332	-18.574042	110	1	1.12	0.95	95.3307	-2.3185	0.0000	0.0000;
	339	1	0	0	0	0	1	1.1008446	-17.761724	110	1	1.12	0.95	95.6849	0.0909	0.0000	0.0000;
	340	1	0	0	0	0	1	1.0842971	-18.782705	110	1	1.12	0.95	96.6046	0.2291	0.0000	0.0000;
	341	1	11.642	3.8	0	0	1	1.073945	-18.664244	110	1	1.12	0.95	97.3621	0.3109	0.0000	0.0000;
	342	1	9.703	2.1	0	0	1	1.0740797	-18.669293	110	1	1.12	0.95	97.3525	0.3130	0.0000	0.0000;
	343	1	0	0	0	0	1	1.1010561	-17.765968	110	1	1.12	0.95	95.6849	0.0767	0.0000	0.0000;
	344	1	3.396	0.5	0	0	1	1.0542997	-31.027829	110	1	1.12	0.95	105.8682	0.9275	0.0000	0.0000;
	345	2	5.821	1.5	0	0	1	1.0805191	-19.848102	110	1	1.12	0.95	98.3369	0.2128	0.0000	0.0000;
	346	1	4.754	0.6	0	0	1	1.0663952	-26.429018	110	1	1.12	0.95	102.4938	0.6146	0.0000	0.0000;
	347	1	11.642	4.36	0	0	1	1.1076335	-10.177731	110	1	1.12	0.95	92.3086	0.3725	0.0000	0.0000;
	348	1	6.5	1.68	0	0	1	1.0878083	-18.79695	110	1	1.12	0.95	96.7073	0.4639	0.0000	0.0000;
	349	1	0	0	0	0	1	1.0896252	-18.625591	110	1	1.12	0.95	96.3023	0.4053	0.0000	0.0000;
	350	1	3.396	1	0	0	1	1.1054958	-20.721221	110	1	1.12	0.95	97.2468	-1.3937	0.0000	0.0000;
	351	1	1.941	0.6	0	0	1	1.0945617	-19.011066	110	1	1.12	0.95	96.4093	0.1781	0.0000	0.0000;
	352	1	0	0	0	0	1	1.0921043	-18.473826	110	1	1.12	0.95	96.2072	0.2651	0.0000	0.0000;
	353	1	0	0	0	0	1	1.093979	-18.371381	110	1	1.12	0.95	96.2227	0.2007	0.0000	0.0000;
	354	1	0	0	0	0	1	1.0945446	-19.013417	110	1	1.12	0.95	96.4101	0.1783	0.0000	0.0000;
	355	1	7.761	2.3	0	0	1	1.0755324	-18.829596	110	1	1.12	0.95	97.3595	0.2038	0.0000	0.0000;
	356	1	7.762	1.8	0	0	1	1.0797659	-20.870602	110	1	1.12	0.95	99.0664	0.2884	0.0000	0.0000;
	357	1	7.373	0.6	0	0	1	1.0829974	-20.16673	110	1	1.12	0.95	97.4279	0.1232	0.0000	0.0000;
	358	1	0	0	0	0	1	1.0960009	-18.157786	110	1	1.12	0.95	95.7462	0.2406	0.0000	0.0000;
	359	1	0	0	0	0	1	1.0962998	-18.120349	110	1	1.12	0.95	95.7275	0.2377	0.0000	0.0000;
	360	1	6.307	1.3	0	0	1	1.069361	-15.523968	110	1	1.12	0.95	95.6879	-1.2606	0.0000	0.0000;
	361	1	5.821	1	0	0	1	1.0896917	-18.675157	110	1	1.12	0.95	96.7281	0.0511	0.0000	0.0000;
	362	2	38.808	15	0	0	1	1.0842257	-20.612723	110	1	1.12	0.95	97.5443	0.8758	0.0000	0.0000;
	363	2	38.808	16	0	0	1	1.0811952	-20.042971	110	1	1.12	0.95	97.3376	0.2491	0.0000	0.0000;
	364	2	42.689	12	0	0	1	1.0871808	-20.377048	110	1	1.12	0.95	97.1931	0.9222	0.0000	0.0000;
	365	2	77.616	22	0	0	1	1.0879799	-19.184996	110	1	1.12	0.95	97.1158	0.0480	0.0000	0.0000;
	366	1	0	0	0	0	1	1.12	-17.950873	110	1	1.12	0.95	94.6239	-2.8103	4709.6969	0.0000;
	367	1	4.172	0.5	0	0	1	1.0757767	-21.87254	110	1	1.12	0.95	99.4188	0.4131	0.0000	0.0000;
	368	2	13.582	0.7	0	0	1	1.0785942	-23.418912	110	1	1.12	0.95	100.4026	0.2196	0.0000	0.0000;
	369	1	3.396	1	0	0	1	1.0800174	-26.149138	110	1	1.12	0.95	100.6985	0.2009	0.0000	0.0000;
	370	1	0	0	0	0	1	1.0923596	-21.165948	110	1	1.12	0.95	98.3393	-0.4139	0.0000	0.0000;
	371	1	16.008	7	0	0	1	1.0713728	-21.262002	110	1	1.12	0.95	99.2984	0.6069	0.0000	0.0000;
	372	1	2.911	0.5	0	0	1	1.1033009	-11.334353	110	1	1.12	0.95	93.3758	0.3346	0.0000	0.0000;
	373	1	5.821	1.5	0	0	1	1.1051557	-11.947846	110	1	1.12	0.95	93.2441	0.0819	0.0000	0.0000;
	374	1	6.306	1.5	0	0	1	1.0791374	-26.143118	110	1	1.12	0.95	103.2660	0.0127	0.0000	0.0000;
	375	1	5.433	0.5	0	0	1	1.0697562	-25.911972	110	1	1.12	0.95	101.8131	0.5425	0.0000	0.0000;
	376	1	3.88	0.8	0	0	1	1.0728797	-14.723246	110	1	1.12	0.95	95.2409	-0.8756	0.0000	0.0000;
	377	1	6.791	1	0	0	1	1.0729502	-14.739461	110	1	1.12	0.95	95.2371	-0.8768	0.0000	0.0000;
	378	1	1.94	0.5	0	0	1	1.0730248	-21.229397	110	1	1.12	0.95	99.1891	0.5407	0.0000	0.0000;
	379	1	9.993	2.3	0	0	1	1.0918642	-18.472608	110	1	1.12	0.95	96.4314	0.0342	0.0000	0.0000;
	380	1	10.284	1.8	0	0	1	1.0905356	-18.438231	110	1	1.12	0.95	96.6235	0.0637	0.0000	0.0000;
	381	1	15.524	3.3	0	0	1	1.0875751	-21.150639	110	1	1.12	0.95	98.4993	-0.4392	0.0000	0.0000;
	382	2	0	9.392	0	0	1	1.0932947	-18.223403	110	1	1.12	0.95	96.2545	0.0000	0.0000	0.0000;
	383	2	0	0	0	0	1	1.1017396	-20.208826	110	1	1.12	0.95	97.1015	-0.3317	0.0000	0.0000;
	384	1	1.94	0.5	0	0	1	1.1034736	-21.589272	110	1	1.12	0.95	97.8972	-1.1448	0.0000	0.0000;
	385	1	11.158	2	0	0	1	1.0958819	-18.19391	110	1	1.12	0.95	96.2256	0.2077	0.0000	0.0000;
	386	2	12.71	4.76	0	0	1	1.1033362	-12.633108	110	1	1.12	0.95	94.4187	0.1994	0.0000	0.0000;
	387	1	10.284	1.6	0	0	1	1.0924455	-19.312982	110	1	1.12	0.95	96.6972	0.2158	0.0000	0.0000;
	388	1	6.723	3.16	0	0	1	1.1085863	-10.091216	110	1	1.12	0.95	92.2079	0.3523	0.0000	0.0000;
	389	1	4.143	1.87	0	0	1	1.1112655	-10.928279	110	1	1.12	0.95	92.6283	0.1076	0.0000	0.0000;
	390	1	0	0	0	0	1	1.0868264	-7.2049713	110	1	1.12	0.95	91.2075	0.2204	0.0000	0.0000;
	391	1	0	0	0	0	1	1.0792496	-4.0446048	110	1	1.12	0.95	90.3397	0.1168	0.0000	0.0000;
	392	1	2.134	0.2	0	0	1	1.0853918	-19.481227	110	1	1.12	0.95	97.4275	0.1243	0.0000	0.0000;
	393	1	1.94	0.5	0	0	1	1.0794024	-19.606448	110	1	1.12	0.95	97.9256	0.3168	0.0000	0.0000;
	394	1	4.366	1.3	0	0	1	1.1080332	-11.869399	110	1	1.12	0.95	93.4261	-0.1920	0.0000	0.0000;
	395	2	4.172	0.6	0	0	1	1.0842606	-20.054358	110	1	1.12	0.95	97.2930	0.0918	0.0000	0.0000;
	396	1	0	0	0	0	1	1.0871463	-19.21062	110	1	1.12	0.95	97.1534	0.0825	0.0000	0.0000;
	397	1	3.202	0.4	0	0	1	1.0848765	-20.64638	110	1	1.12	0.95	97.5681	0.8192	0.0000	0.0000;
	398	1	0	0	0	0	1	1.0826608	-20.455221	110	1	1.12	0.95	97.7418	0.0785	0.0000	0.0000;
	399	1	6.791	1.75	0	0	1	1.0745406	-20.439086	110	1	1.12	0.95	98.3954	0.5411	0.0000	0.0000;
	400	1	3.105	0.7	0	0	1	1.0685233	-15.894897	110	1	1.12	0.95	95.7419	-1.6138	0.0000	0.0000;
	401	1	19.889	5	0	0	1	1.1005342	-18.46013	110	1	1.12	0.95	96.1740	0.0065	0.0000	0.0000;
	402	1	30.561	5	0	0	1	1.0896429	-18.046386	110	1	1.12	0.95	96.2294	0.1559	0.0000	0.0000;
	403	1	6.791	1.2	0	0	1	1.0943001	-8.4229871	110	1	1.12	0.95	91.2531	-0.0515	0.0000	0.0000;
	404	1	3.881	1	0	0	1	1.0578075	-6.3829414	110	1	1.12	0.95	91.8672	0.3558	0.0000	0.0000;
	405	1	7.276	1.5	0	0	1	1.0863415	-24.985241	110	1	1.12	0.95	99.6699	-0.0123	0.0000	0.0000;
	406	1	6.791	1	0	0	1	1.0933153	-8.3403579	110	1	1.12	0.95	91.2779	-0.0168	0.0000	0.0000;
	407	1	7.665	0.8	0	0	1	1.0833602	-20.142485	110	1	1.12	0.95	97.3970	0.1114	0.0000	0.0000;
	408	1	8.732	1	0	0	1	1.0716587	-16.74797	110	1	1.12	0.95	96.0233	0.6203	0.0000	0.0000;
	409	1	3.396	0.301	0	0	1	1.0826194	-20.454523	110	1	1.12	0.95	97.7418	0.0809	0.0000	0.0000;
	410	1	0	0	0	0	1	1.0867893	-20.431553	110	1	1.12	0.95	97.2530	0.9258	0.0000	0.0000;
	411	1	0	0	0	0	1	1.0828629	-20.103766	110	1	1.12	0.95	97.3699	0.1487	0.0000	0.0000;
	412	1	21.345	7	0	0	1	1.0584572	-6.253183	110	1	1.12	0.95	91.8424	0.3857	0.0000	0.0000;
	413	1	6.306	1.8	0	0	1	1.0716908	-21.268723	110	1	1.12	0.95	99.3054	0.6006	0.0000	0.0000;
	414	1	3.104	0.5	0	0	1	1.083832	-20.097496	110	1	1.12	0.95	97.3427	0.1009	0.0000	0.0000;
	415	1	12.709	1.1	0	0	1	1.0749483	-20.944888	110	1	1.12	0.95	98.9631	0.4000	0.0000	0.0000;
	416	1	2.425	0.5	0	0	1	1.1084556	-11.847927	110	1	1.12	0.95	93.3786	-0.2054	0.0000	0.0000;
	417	1	7.276	1	0	0	1	1.0903454	-18.653882	110	1	1.12	0.95	96.6766	0.0587	0.0000	0.0000;
	418	1	11.642	3.6	0	0	1	1.0810127	-19.243868	110	1	1.12	0.95	97.1664	0.5777	0.0000	0.0000;
	419	1	12.613	3.9	0	0	1	1.0809708	-19.250793	110	1	1.12	0.95	97.1689	0.5782	0.0000	0.0000;
	420	1	6.015	3	0	0	1	1.0803749	-20.295772	110	1	1.12	0.95	97.9881	0.5653	0.0000	0.0000;
	421	2	9.799	2	0	0	1	1.0840179	-19.948689	110	1	1.12	0.95	97.6622	0.4569	0.0000	0.0000;
	422	1	7.179	0.4	0	0	1	1.0831332	-22.771294	110	1	1.12	0.95	99.7594	0.0563	0.0000	0.0000;
	423	1	6.889	0.6	0	0	1	1.0753508	-20.521584	110	1	1.12	0.95	99.1776	0.3307	0.0000	0.0000;
	424	1	13.582	2.8	0	0	1	1.0665453	-20.506138	110	1	1.12	0.95	98.6677	0.8248	0.0000	0.0000;
	425	1	9.702	2	0	0	1	1.0866775	-19.676002	110	1	1.12	0.95	97.3597	0.3898	0.0000	0.0000;
	426	2	5.433	2	0	0	1	1.1073348	-10.2316	110	1	1.12	0.95	92.3661	0.3703	0.0000	0.0000;
	427	1	5.433	2	0	0	1	1.1073249	-10.233668	110	1	1.12	0.95	92.3668	0.3704	0.0000	0.0000;
	428	1	6.306	0.8	0	0	1	1.0615185	-5.7510027	110	1	1.12	0.95	92.1521	0.5331	0.0000	0.0000;
	429	1	4.269	0.4	0	0	1	1.0832348	-20.278034	110	1	1.12	0.95	97.5530	0.0868	0.0000	0.0000;
	430	1	6.306	0.699	0	0	1	1.0902509	-13.053057	110	1	1.12	0.95	94.8192	0.2650	0.0000	0.0000;
	431	2	6.598	0.8	0	0	1	1.0872862	-22.157649	110	1	1.12	0.95	98.9857	0.2846	0.0000	0.0000;
	432	1	4.269	1.6	0	0	1	1.1067644	-11.430546	110	1	1.12	0.95	93.4445	0.1855	0.0000	0.0000;
	433	1	3.881	1.1	0	0	1	1.0580062	-21.158649	110	1	1.12	0.95	99.6740	1.0871	0.0000	0.0000;
	434	1	6.791	2	0	0	1	1.0741203	-22.076667	110	1	1.12	0.95	100.2852	-0.3237	0.0000	0.0000;
	435	1	0	0	0	0	1	1.0916457	-11.719344	110	1	1.12	0.95	93.4515	-0.5670	0.0000	0.0000;
	436	1	15.524	6	0	0	1	1.0602381	-5.8406448	110	1	1.12	0.95	92.2636	0.5721	0.0000	0.0000;
	437	1	7.277	0.5	0	0	1	1.0651446	-27.972203	110	1	1.12	0.95	105.8381	0.2049	0.0000	0.0000;
	438	1	1.455	0.4	0	0	1	1.0777	-3.8189778	110	1	1.12	0.95	90.3002	0.1632	0.0000	0.0000;
	439	1	1.941	0.6	0	0	1	1.0775948	-3.8351008	110	1	1.12	0.95	90.3036	0.1646	0.0000	0.0000;
	440	2	2.911	0.8	0	0	1	1.061079	-5.7868427	110	1	1.12	0.95	92.1929	0.5449	0.0000	0.0000;
	441	1	2.425	0.6	0	0	1	1.0508462	-7.4351419	110	1	1.12	0.95	93.0131	0.4036	0.0000	0.0000;
	442	1	6.791	2.77	0	0	1	1.1056004	-11.35271	110	1	1.12	0.95	93.1697	0.2721	0.0000	0.0000;
	443	1	11.642	4.36	0	0	1	1.1039311	-11.919643	110	1	1.12	0.95	93.9209	0.2225	0.0000	0.0000;
	444	1	3.881	0.5	0	0	1	1.11139	-9.8216437	110	1	1.12	0.95	91.7875	-1.5018	0.0000	0.0000;
	445	1	2.426	0.401	0	0	1	1.0846466	-13.766138	110	1	1.12	0.95	94.9883	0.1720	0.0000	0.0000;
	446	1	5.336	1.5	0	0	1	1.1043209	-11.585254	110	1	1.12	0.95	93.4433	-0.3520	0.0000	0.0000;
	447	2	9.141	0.5	0	0	1	1.0818988	-18.636852	110	1	1.12	0.95	96.8994	-0.0459	0.0000	0.0000;
	448	1	4.268	0.5	0	0	1	1.0830096	-18.204896	110	1	1.12	0.95	96.5140	-0.0185	0.0000	0.0000;
	449	2	10.769	2.6	0	0	1	1.0844962	-17.734811	110	1	1.12	0.95	96.0842	-0.0000	0.0000	0.0000;
	450	1	7.276	0.5	0	0	1	1.0608163	-28.324835	110	1	1.12	0.95	106.7626	0.1813	0.0000	0.0000;
	451	1	3.008	1	0	0	1	1.0748859	-20.957908	110	1	1.12	0.95	99.1138	0.4217	0.0000	0.0000;
	452	1	14.553	3.5	0	0	1	1.0900577	-18.312268	110	1	1.12	0.95	96.3765	0.2019	0.0000	0.0000;
	453	1	0.97	0.1	0	0	1	1.1177723	-8.8959589	110	1	1.12	0.95	90.6885	-2.0862	0.0000	0.0000;
	454	1	11.157	0.8	0	0	1	1.0991271	-12.03372	110	1	1.12	0.95	94.0839	0.3433	0.0000	0.0000;
	455	1	6.791	1	0	0	1	1.0753977	-21.615742	110	1	1.12	0.95	98.8621	0.5943	0.0000	0.0000;
	456	1	15.523	5	0	0	1	1.0825463	-18.946715	110	1	1.12	0.95	96.8039	0.2941	0.0000	0.0000;
	457	1	3.008	0.3	0	0	1	1.0796352	-21.388457	110	1	1.12	0.95	98.7849	0.0436	0.0000	0.0000;
	458	1	3.591	0.8	0	0	1	1.0996248	-13.899347	110	1	1.12	0.95	95.4019	0.2279	0.0000	0.0000;
	459	1	11.642	0.5	0	0	1	1.0842293	-19.6704	110	1	1.12	0.95	98.2434	-1.1838	0.0000	0.0000;
	460	1	6.791	3	0	0	1	1.0834349	-13.994684	110	1	1.12	0.95	93.5857	0.0145	0.0000	0.0000;
	461	1	10.672	1.1	0	0	1	1.0842068	-20.642545	110	1	1.12	0.95	97.7737	0.4182	0.0000	0.0000;
	462	1	7.275	0.9	0	0	1	1.0842666	-20.621824	110	1	1.12	0.95	97.7676	0.4170	0.0000	0.0000;
	463	2	9.799	2.8	0	0	1	1.0790586	-19.839023	110	1	1.12	0.95	97.8817	-0.0795	0.0000	0.0000;
	464	1	11.642	1.4	0	0	1	1.0982212	-11.686755	110	1	1.12	0.95	93.7970	-0.4164	0.0000	0.0000;
	465	1	4.851	0.6	0	0	1	1.0776859	-22.538597	110	1	1.12	0.95	99.0620	1.0847	0.0000	0.0000;
	466	1	8.344	3.12	0	0	1	1.1112132	-11.044777	110	1	1.12	0.95	92.7307	0.0889	0.0000	0.0000;
	467	1	3.396	1.5	0	0	1	1.0854898	-15.198036	110	1	1.12	0.95	94.5730	-0.1715	0.0000	0.0000;
	468	1	4.463	1.67	0	0	1	1.101218	-12.154892	110	1	1.12	0.95	94.1990	0.2862	0.0000	0.0000;
	469	1	1.455	0.3	0	0	1	1.0814428	-20.059693	110	1	1.12	0.95	98.0293	0.2245	0.0000	0.0000;
	470	1	2.425	0.4	0	0	1	1.0555791	-6.7413075	110	1	1.12	0.95	92.2321	0.3713	0.0000	0.0000;
	471	1	13.583	2	0	0	1	1.0669622	-27.918548	110	1	1.12	0.95	105.3954	0.2611	0.0000	0.0000;
	472	1	0.97	0.5	0	0	1	1.0736507	-18.69777	110	1	1.12	0.95	97.4073	0.3144	0.0000	0.0000;
	473	1	0.97	0	0	0	1	1.0763016	-19.448888	110	1	1.12	0.95	97.4297	0.4488	0.0000	0.0000;
	474	1	6.791	1	0	0	1	1.0904472	-25.63292	110	1	1.12	0.95	100.5974	0.2789	0.0000	0.0000;
	475	1	2.425	0.5	0	0	1	1.0844144	-20.796541	110	1	1.12	0.95	97.8203	0.5903	0.0000	0.0000;
	476	1	1.455	0.3	0	0	1	1.0684016	-16.048917	110	1	1.12	0.95	95.6800	-1.8492	0.0000	0.0000;
	477	1	13.098	4.5	0	0	1	1.0876666	-19.54218	110	1	1.12	0.95	97.8673	0.2898	0.0000	0.0000;
	478	1	11.836	4.43	0	0	1	1.10931	-11.496025	110	1	1.12	0.95	93.3970	0.0919	0.0000	0.0000;
	479	1	7.275	1.7	0	0	1	1.0815505	-20.871016	110	1	1.12	0.95	98.4145	0.3680	0.0000	0.0000;
	480	1	2.134	0.3	0	0	1	1.0603381	-28.18334	110	1	1.12	0.95	103.6176	1.1567	0.0000	0.0000;
	481	1	6.791	1.8	0	0	1	1.050202	-21.479333	110	1	1.12	0.95	100.5288	1.4739	0.0000	0.0000;
	482	2	4.366	0.2	0	0	1	1.0518565	-7.3541678	110	1	1.12	0.95	92.8550	0.3906	0.0000	0.0000;
	483	1	3.396	0.5	0	0	1	1.079358	-11.829066	110	1	1.12	0.95	93.6758	-0.3571	0.0000	0.0000;
	484	1	6.791	1	0	0	1	1.0501952	-7.4985766	110	1	1.12	0.95	93.1185	0.4093	0.0000	0.0000;
	485	1	6.791	1	0	0	1	1.0784862	-11.909054	110	1	1.12	0.95	93.7906	-0.3422	0.0000	0.0000;
	486	1	5.142	1.1	0	0	1	1.12	-8.4934617	110	1	1.12	0.95	90.3207	-2.3304	5192.7476	0.0000;
	487	1	0.582	0.2	0	0	1	1.1165491	-8.5547503	110	1	1.12	0.95	91.1063	-0.6141	0.0000	0.0000;
	488	1	0	0	0	0	1	1.0788274	-11.880317	110	1	1.12	0.95	93.7457	-0.3485	0.0000	0.0000;
	489	1	0	0	0	0	1	1.0788152	-11.883044	110	1	1.12	0.95	93.7466	-0.3484	0.0000	0.0000;
	490	2	1.94	0.6	0	0	1	1.0937004	-18.364827	110	1	1.12	0.95	96.2362	0.1945	0.0000	0.0000;
	491	1	7.276	3.8	0	0	1	1.0932145	-18.422005	110	1	1.12	0.95	96.2828	0.2240	0.0000	0.0000;
	492	1	5.821	0.5	0	0	1	1.1178529	-17.908693	110	1	1.12	0.95	94.5059	-2.1683	0.0000	0.0000;
	493	1	12.613	3.9	0	0	1	1.0849657	-18.932706	110	1	1.12	0.95	96.8502	0.4808	0.0000	0.0000;
	494	1	12.613	3.9	0	0	1	1.0851075	-18.916143	110	1	1.12	0.95	96.8455	0.4797	0.0000	0.0000;
	495	1	9.217	2.85	0	0	1	1.0936724	-18.592715	110	1	1.12	0.95	96.3026	0.1686	0.0000	0.0000;
	496	1	16.494	4.25	0	0	1	1.0849642	-19.008039	110	1	1.12	0.95	97.0561	0.5419	0.0000	0.0000;
	497	1	1.94	0.5	0	0	1	1.0750443	-21.046615	110	1	1.12	0.95	98.9190	0.4763	0.0000	0.0000;
	498	1	5.821	1.6	0	0	1	1.075634	-21.588592	110	1	1.12	0.95	98.8318	0.5900	0.0000	0.0000;
	499	1	5.53	0.5	0	0	1	1.0791928	-20.628894	110	1	1.12	0.95	98.6809	-0.3660	0.0000	0.0000;
	500	1	11.642	3.6	0	0	1	1.0817308	-19.047726	110	1	1.12	0.95	96.9321	0.5870	0.0000	0.0000;
	501	1	13.582	4.2	0	0	1	1.0904475	-18.457676	110	1	1.12	0.95	96.1788	0.3351	0.0000	0.0000;
	502	1	11.642	3.6	0	0	1	1.0870615	-18.862703	110	1	1.12	0.95	96.8270	0.4609	0.0000	0.0000;
	503	1	12.613	3.9	0	0	1	1.0816898	-19.163963	110	1	1.12	0.95	97.0971	0.5643	0.0000	0.0000;
	504	1	11.642	3	0	0	1	1.0920867	-18.328513	110	1	1.12	0.95	96.0363	0.2917	0.0000	0.0000;
	505	1	4.366	1	0	0	1	1.0592577	-29.066416	110	1	1.12	0.95	107.2567	0.1384	0.0000	0.0000;
	506	1	24.255	7.5	0	0	1	1.0899599	-18.629896	110	1	1.12	0.95	96.3894	0.4091	0.0000	0.0000;
	507	1	53.361	16.5	0	0	1	1.0898945	-18.607539	110	1	1.12	0.95	96.2784	0.3990	0.0000	0.0000;
	508	1	0.776	0.2	0	0	1	1.1108665	-9.2757712	110	1	1.12	0.95	91.6127	-0.6040	0.0000	0.0000;
	509	1	1.454	0.3	0	0	1	1.1108156	-9.2899245	110	1	1.12	0.95	91.6133	-0.6054	0.0000	0.0000;
	510	1	15.038	6.14	0	0	1	1.1127293	-11.054854	110	1	1.12	0.95	92.7039	0.0490	0.0000	0.0000;
	511	1	0	0	0	0	1	1.1094464	-10.441095	110	1	1.12	0.95	92.4655	0.2745	0.0000	0.0000;
	512	1	1.94	0.5	0	0	1	1.075064	-21.087087	110	1	1.12	0.95	98.9679	0.4843	0.0000	0.0000;
	513	1	2.425	0.5	0	0	1	1.1011278	-19.770745	110	1	1.12	0.95	96.6561	-1.0279	0.0000	0.0000;
	514	1	7.762	2	0	0	1	1.0905724	-18.608478	110	1	1.12	0.95	96.3560	0.3027	0.0000	0.0000;
	515	1	6.791	1.75	0	0	1	1.0906146	-18.602339	110	1	1.12	0.95	96.3538	0.3022	0.0000	0.0000;
	516	1	5.822	1.8	0	0	1	1.0832653	-19.142776	110	1	1.12	0.95	97.2834	0.5884	0.0000	0.0000;
	517	1	5.822	1.8	0	0	1	1.0766532	-19.578371	110	1	1.12	0.95	97.5751	0.5420	0.0000	0.0000;
	518	1	14.553	3.75	0	0	1	1.0925082	-18.427799	110	1	1.12	0.95	96.1175	0.3397	0.0000	0.0000;
	519	1	8.053	2.08	0	0	1	1.090249	-18.636599	110	1	1.12	0.95	96.3876	0.3107	0.0000	0.0000;
	520	1	8.052	2.08	0	0	1	1.092727	-18.478034	110	1	1.12	0.95	96.3449	0.2319	0.0000	0.0000;
	521	1	10.964	1.5	0	0	1	1.0591594	-21.090964	110	1	1.12	0.95	99.5164	1.0506	0.0000	0.0000;
	522	2	14.553	1.2	0	0	1	1.1028639	-10.216717	110	1	1.12	0.95	92.7133	-0.5925	0.0000	0.0000;
	523	1	29.591	7.63	0	0	1	1.0933646	-18.748844	110	1	1.12	0.95	96.3971	0.1739	0.0000	0.0000;
	524	1	12.127	3.13	0	0	1	1.0941193	-17.941086	110	1	1.12	0.95	95.8495	0.1148	0.0000	0.0000;
	525	1	30.076	9.3	0	0	1	1.0951247	-18.292628	110	1	1.12	0.95	96.1626	0.2163	0.0000	0.0000;
	526	1	9.702	3	0	0	1	1.085309	-18.977544	110	1	1.12	0.95	97.1071	0.5318	0.0000	0.0000;
	527	1	6.015	1	0	0	1	1.0573835	-21.185296	110	1	1.12	0.95	99.7255	1.1222	0.0000	0.0000;
	528	1	4.851	1.25	0	0	1	1.0933281	-18.75408	110	1	1.12	0.95	96.4016	0.1744	0.0000	0.0000;
	529	1	4.851	1.25	0	0	1	1.0809336	-19.256146	110	1	1.12	0.95	97.1737	0.5788	0.0000	0.0000;
	530	1	26.195	8.1	0	0	1	1.0970079	-18.169905	110	1	1.12	0.95	95.9886	0.1732	0.0000	0.0000;
	531	1	5.821	1.8	0	0	1	1.0950043	-18.340733	110	1	1.12	0.95	96.0189	0.1633	0.0000	0.0000;
	532	1	20.374	6.301	0	0	1	1.0954267	-18.280414	110	1	1.12	0.95	95.9369	0.1592	0.0000	0.0000;
	533	2	2.911	0.2	0	0	1	1.0850536	-20.711793	110	1	1.12	0.95	97.7699	0.4967	0.0000	0.0000;
	534	2	74.701	19.8	0	0	1	1.103827	-17.694064	110	1	1.12	0.95	95.3474	-0.0000	0.0000	0.0000;
	535	2	44.221	15.6	0	0	1	1.10249	-17.556058	110	1	1.12	0.95	95.0714	-0.0000	0.0000	0.0000;
	536	1	5.821	1.8	0	0	1	1.1020928	-17.581528	110	1	1.12	0.95	95.1113	0.0119	0.0000	0.0000;
	537	1	8.732	2.7	0	0	1	1.1032282	-17.732111	110	1	1.12	0.95	95.4074	0.0181	0.0000	0.0000;
	538	1	14.553	3.75	0	0	1	1.0872876	-18.848411	110	1	1.12	0.95	96.8206	0.4474	0.0000	0.0000;
	539	1	14.553	3.75	0	0	1	1.0934973	-18.641601	110	1	1.12	0.95	96.3390	0.1710	0.0000	0.0000;
	540	1	15.524	4	0	0	1	1.0935145	-18.660196	110	1	1.12	0.95	96.3428	0.1720	0.0000	0.0000;
	541	1	19.404	5	0	0	1	1.0996145	-17.987181	110	1	1.12	0.95	95.7495	0.1088	0.0000	0.0000;
	542	1	34.927	10.8	0	0	1	1.0772594	-19.422769	110	1	1.12	0.95	97.4490	0.6384	0.0000	0.0000;
	543	1	22.315	6.9	0	0	1	1.0936138	-18.718827	110	1	1.12	0.95	96.3740	0.1693	0.0000	0.0000;
	544	1	14.553	4.5	0	0	1	1.0816486	-19.079413	110	1	1.12	0.95	96.9624	0.5945	0.0000	0.0000;
	545	1	10.672	3.3	0	0	1	1.0926134	-18.467893	110	1	1.12	0.95	96.3373	0.2406	0.0000	0.0000;
	546	1	10.672	3.3	0	0	1	1.096992	-18.755874	110	1	1.12	0.95	96.4976	0.0966	0.0000	0.0000;
	547	1	21.344	5.5	0	0	1	1.0995728	-18.007115	110	1	1.12	0.95	95.7494	0.1078	0.0000	0.0000;
	548	1	11.642	3.6	0	0	1	1.0918395	-18.514147	110	1	1.12	0.95	96.4288	0.2772	0.0000	0.0000;
	549	2	31.046	9.6	0	0	1	1.0832679	-19.131184	110	1	1.12	0.95	97.3005	0.5909	0.0000	0.0000;
	550	1	4.851	1.5	0	0	1	1.0821238	-19.033329	110	1	1.12	0.95	96.9264	0.5733	0.0000	0.0000;
	551	1	12.612	3.5	0	0	1	1.0713972	-20.283034	110	1	1.12	0.95	98.8673	0.5238	0.0000	0.0000;
	552	1	4.366	1	0	0	1	1.0768522	-27.406097	110	1	1.12	0.95	102.3159	0.6374	0.0000	0.0000;
	553	1	11.643	2	0	0	1	1.0936642	-20.491615	110	1	1.12	0.95	97.5393	-1.0965	0.0000	0.0000;
	554	1	4.851	0.8	0	0	1	1.0707701	-20.326048	110	1	1.12	0.95	98.9608	0.5373	0.0000	0.0000;
	555	1	0.97	0.5	0	0	1	1.080751	-21.658349	110	1	1.12	0.95	99.3689	-0.4994	0.0000	0.0000;
	556	1	0	0	0	0	1	1.0440399	-21.64914	110	1	1.12	0.95	101.0967	1.8544	0.0000	0.0000;
	557	2	42.489	16.6	0	0	1	1.0877714	-18.799652	110	1	1.12	0.95	96.7147	0.4648	0.0000	0.0000;
	558	2	35.524	12.8	0	0	1	1.0819125	-19.034173	110	1	1.12	0.95	96.9085	0.5815	0.0000	0.0000;
	559	1	0	0	0	0	1	1.079964	-21.337256	110	1	1.12	0.95	98.7301	0.0419	0.0000	0.0000;
	560	1	0	0	0	0	1	1.0951765	-18.349027	110	1	1.12	0.95	96.0350	0.1518	0.0000	0.0000;
	561	1	0	0	0	0	1	1.0709461	-20.105261	110	1	1.12	0.95	98.1957	0.7013	0.0000	0.0000;
	562	1	0	0	0	0	1	1.1046678	-11.726519	110	1	1.12	0.95	93.6877	0.2341	0.0000	0.0000;
	563	1	9.702	1	0	0	1	1.0973981	-18.063261	110	1	1.12	0.95	95.9955	0.1798	0.0000	0.0000;
	564	1	6.792	1.2	0	0	1	1.0828285	-19.189112	110	1	1.12	0.95	97.3357	0.5970	0.0000	0.0000;
	565	1	3.688	0.2	0	0	1	1.0708395	-20.122563	110	1	1.12	0.95	98.2134	0.7020	0.0000	0.0000;
	566	1	3.396	0.5	0	0	1	1.0851093	-19.022181	110	1	1.12	0.95	97.2731	0.1837	0.0000	0.0000;
	567	1	9.217	1.5	0	0	1	1.0922292	-20.603735	110	1	1.12	0.95	97.7616	-0.7784	0.0000	0.0000;
	568	1	3.202	0.8	0	0	1	1.0998937	-10.97927	110	1	1.12	0.95	93.3019	-0.5032	0.0000	0.0000;
	569	2	9.702	3	0	0	1	1.1037528	-11.375776	110	1	1.12	0.95	93.2788	-0.4106	0.0000	0.0000;
	570	1	9.033	4.25	0	0	1	1.1068147	-11.698975	110	1	1.12	0.95	93.6540	0.1458	0.0000	0.0000;
	571	1	3.871	1.82	0	0	1	1.106993	-11.700072	110	1	1.12	0.95	93.6509	0.1446	0.0000	0.0000;
	572	1	4.851	0.7	0	0	1	1.1010769	-11.558258	110	1	1.12	0.95	93.5490	-0.4109	0.0000	0.0000;
	573	1	0	0	0	0	1	1.1078476	-10.242009	110	1	1.12	0.95	92.3669	0.3435	0.0000	0.0000;
	574	1	5.336	1.2	0	0	1	1.0815897	-7.7768786	110	1	1.12	0.95	91.8052	0.3143	0.0000	0.0000;
	575	1	2.911	0.9	0	0	1	1.0930148	-18.453318	110	1	1.12	0.95	96.3168	0.2248	0.0000	0.0000;
	576	1	0.194	0.06	0	0	1	1.0903064	-18.603315	110	1	1.12	0.95	96.3516	0.3996	0.0000	0.0000;
	577	1	5.336	2	0	0	1	1.087078	-13.423439	110	1	1.12	0.95	94.9646	0.2439	0.0000	0.0000;
	578	1	5.142	0.6	0	0	1	1.0667978	-25.354324	110	1	1.12	0.95	101.6416	1.1297	0.0000	0.0000;
	579	1	4.851	1.82	0	0	1	1.1063614	-11.701817	110	1	1.12	0.95	93.6549	0.1642	0.0000	0.0000;
	580	1	2.134	0.5	0	0	1	1.0786237	-20.508362	110	1	1.12	0.95	98.6324	-0.3398	0.0000	0.0000;
	581	2	5.627	0.7	0	0	1	1.0779816	-21.548066	110	1	1.12	0.95	99.2225	0.0572	0.0000	0.0000;
	582	1	10.187	1.6	0	0	1	1.0787214	-21.077049	110	1	1.12	0.95	99.2552	0.2588	0.0000	0.0000;
	583	1	0	0	0	0	1	1.0955833	-14.830249	110	2	1.12	0.95	94.4070	-0.7798	0.0000	0.0000;
	584	1	5.079	0.75	0	0	1	1.0955902	-14.834155	110	2	1.12	0.95	94.4119	-0.7804	0.0000	0.0000;
	585	1	1.652	0.2	0	0	1	1.0750696	-16.626389	110	2	1.12	0.95	95.9583	-1.1282	0.0000	0.0000;
	586	1	5.21	0.5	0	0	1	1.0877702	-16.159833	110	2	1.12	0.95	95.4763	-0.6973	0.0000	0.0000;
	587	1	5.178	0	0	0	1	1.0298222	-18.303712	110	2	1.12	0.95	97.0103	-0.0953	0.0000	0.0000;
	588	1	3.636	0.1	0	0	1	1.0854379	-15.744206	110	2	1.12	0.95	95.5114	-0.7446	0.0000	0.0000;
	589	1	12.338	0.9	0	0	1	1.0572428	-16.302463	110	2	1.12	0.95	95.6344	-0.6376	0.0000	0.0000;
	590	1	0	0	0	0	1	1.0572048	-16.302287	110	2	1.12	0.95	95.6383	-0.6338	0.0000	0.0000;
	591	1	14.43	3.1	0	0	1	1.0870011	-16.359336	110	2	1.12	0.95	95.6974	-0.6823	0.0000	0.0000;
	592	1	4.958	1	0	0	1	1.0806233	-14.281774	110	2	1.12	0.95	94.6435	-0.0152	0.0000	0.0000;
	593	1	2.754	1	0	0	1	1.0457113	-17.889841	110	2	1.12	0.95	97.3366	-0.2677	0.0000	0.0000;
	594	2	10.355	2.7	0	0	1	1.0726625	-16.497577	110	2	1.12	0.95	95.9622	-0.5658	0.0000	0.0000;
	595	1	3.304	0.5	0	0	1	1.0712401	-16.533026	110	2	1.12	0.95	95.9790	-0.5396	0.0000	0.0000;
	596	1	4.958	0.5	0	0	1	1.0720613	-16.251305	110	2	1.12	0.95	96.0316	-1.4449	0.0000	0.0000;
	597	1	7.05	0	0	0	1	1.0941726	-16.055476	110	2	1.12	0.95	94.4216	-0.2435	0.0000	0.0000;
	598	1	9.032	0	0	0	1	1.0931471	-16.179037	110	2	1.12	0.95	94.5908	-0.2653	0.0000	0.0000;
	599	1	1.873	0	0	0	1	1.0367903	-19.094444	110	2	1.12	0.95	98.7746	-0.3320	0.0000	0.0000;
	600	1	2.534	0	0	0	1	1.0740883	-16.543192	110	2	1.12	0.95	96.6188	-0.8460	0.0000	0.0000;
	601	2	20.708	4.8	0	0	1	1.0748666	-16.448246	110	2	1.12	0.95	96.1134	-0.5785	0.0000	0.0000;
	602	1	11.015	0.5	0	0	1	1.0667379	-16.197944	110	2	1.12	0.95	95.8161	-1.1415	0.0000	0.0000;
	603	1	2.754	0	0	0	1	1.0670323	-16.082999	110	2	1.12	0.95	95.6768	-1.1082	0.0000	0.0000;
	604	1	4.351	0.6	0	0	1	1.0854591	-15.673606	110	2	1.12	0.95	95.2868	-0.6855	0.0000	0.0000;
	605	1	5.287	1.4	0	0	1	1.0284832	-18.196484	110	2	1.12	0.95	96.7811	-0.0187	0.0000	0.0000;
	606	1	0	0	0	0	1	1.0817683	-16.837316	110	2	1.12	0.95	95.9413	-0.5738	0.0000	0.0000;
	607	1	25.403	5	0	0	1	1.0758165	-17.222472	110	2	1.12	0.95	96.7173	-0.4174	0.0000	0.0000;
	608	1	7.379	0	0	0	1	1.0807853	-16.967392	110	2	1.12	0.95	96.0986	-0.5672	0.0000	0.0000;
	609	1	0	0	0	0	1	1.074674	-15.526702	110	2	1.12	0.95	94.8042	-1.0528	0.0000	0.0000;
	610	1	0	0	0	0	1	1.0716585	-15.490615	110	2	1.12	0.95	94.8420	-0.9580	0.0000	0.0000;
	611	1	6.609	0.1	0	0	1	1.0808507	-16.968935	110	2	1.12	0.95	96.0909	-0.5683	0.0000	0.0000;
	612	1	4.958	0	0	0	1	1.0801077	-15.668864	110	2	1.12	0.95	95.1473	-1.1676	0.0000	0.0000;
	613	1	0	0	0	0	1	1.0817186	-16.836053	110	2	1.12	0.95	95.9414	-0.5696	0.0000	0.0000;
	614	1	0	0	0	0	1	1.0816811	-16.849453	110	2	1.12	0.95	95.9461	-0.5686	0.0000	0.0000;
	615	1	5.508	0	0	0	1	1.0686255	-16.070935	110	2	1.12	0.95	95.5678	-1.7682	0.0000	0.0000;
	616	1	8.481	0.9	0	0	1	1.0804005	-17.01457	110	2	1.12	0.95	96.1559	-0.5633	0.0000	0.0000;
	617	1	8.635	0.2	0	0	1	1.0727027	-16.014376	110	2	1.12	0.95	96.3239	-0.4765	0.0000	0.0000;
	618	1	2.203	0.5	0	0	1	1.0809743	-14.242826	110	2	1.12	0.95	94.3212	-0.0956	0.0000	0.0000;
	619	1	2.203	0	0	0	1	1.0741699	-15.06866	110	2	1.12	0.95	95.3357	-0.9631	0.0000	0.0000;
	620	1	4.185	1	0	0	1	1.0467356	-17.404112	110	2	1.12	0.95	96.6225	-0.4868	0.0000	0.0000;
	621	1	2.203	0.5	0	0	1	1.0671659	-16.218013	110	2	1.12	0.95	96.0364	-0.7835	0.0000	0.0000;
	622	2	0	-0.002	0	0	1	1.075489	-14.109034	110	2	1.12	0.95	93.5080	-0.3628	0.0000	0.0000;
	623	1	4.076	0.9	0	0	1	1.067233	-16.751017	110	2	1.12	0.95	96.2830	-0.8179	0.0000	0.0000;
	624	1	19.825	5.5	0	0	1	1.0783559	-17.059895	110	2	1.12	0.95	95.9465	0.6439	0.0000	0.0000;
	625	1	2.754	0.5	0	0	1	1.0694637	-15.132566	110	2	1.12	0.95	94.5864	-0.8738	0.0000	0.0000;
	626	2	7.115	1.8	0	0	1	1.0964038	-15.464596	110	2	1.12	0.95	94.8395	-0.8354	0.0000	0.0000;
	627	1	11.015	2.8	0	0	1	1.0655645	-16.747076	110	2	1.12	0.95	96.3039	-0.7326	0.0000	0.0000;
	628	1	10.575	10.1	0	0	1	1.0708128	-14.8456	110	2	1.12	0.95	94.1843	-0.8024	0.0000	0.0000;
	629	1	8.923	1	0	0	1	1.0366071	-18.166124	110	2	1.12	0.95	97.5714	-0.1525	0.0000	0.0000;
	630	2	8.214	3.4	0	0	1	1.0744137	-16.607103	110	2	1.12	0.95	95.5855	-0.3682	0.0000	0.0000;
	631	2	12.724	4.2	0	0	1	1.0747461	-16.589704	110	2	1.12	0.95	95.5638	-0.3795	0.0000	0.0000;
	632	1	11.015	2	0	0	1	1.0664558	-16.653407	110	2	1.12	0.95	96.0830	-0.7732	0.0000	0.0000;
	633	1	0.22	0	0	0	1	1.0514785	-16.938119	110	2	1.12	0.95	96.4639	-0.4808	0.0000	0.0000;
	634	1	7.05	1.2	0	0	1	1.0946039	-16.066171	110	2	1.12	0.95	94.3379	-0.2059	0.0000	0.0000;
	635	1	2.203	0	0	0	1	1.0279726	-18.007678	110	2	1.12	0.95	96.5258	-0.0056	0.0000	0.0000;
	636	1	5.508	1	0	0	1	1.0777479	-16.210275	110	2	1.12	0.95	95.6947	-1.2646	0.0000	0.0000;
	637	1	7.82	2.4	0	0	1	1.067298	-16.770908	110	2	1.12	0.95	96.2506	-0.5369	0.0000	0.0000;
	638	1	7.159	0.5	0	0	1	1.048355	-18.305704	110	2	1.12	0.95	98.0379	-0.2571	0.0000	0.0000;
	639	1	2.203	0	0	0	1	1.0725282	-14.97008	110	2	1.12	0.95	95.5451	-1.7334	0.0000	0.0000;
	640	1	10.464	0	0	0	1	1.0719327	-15.146065	110	2	1.12	0.95	95.5333	-1.8594	0.0000	0.0000;
	641	1	6.057	1	0	0	1	1.0766755	-15.120448	110	2	1.12	0.95	95.1119	-0.2857	0.0000	0.0000;
	642	1	1.763	0.2	0	0	1	1.0971437	-15.481779	110	2	1.12	0.95	93.8437	-0.1916	0.0000	0.0000;
	643	1	2.975	0.5	0	0	1	1.0520577	-17.775281	110	2	1.12	0.95	97.5310	-0.2597	0.0000	0.0000;
	644	1	3.415	0.1	0	0	1	1.0841572	-16.221974	110	2	1.12	0.95	95.0803	-0.7381	0.0000	0.0000;
	645	1	2.093	0	0	0	1	1.0747823	-15.691019	110	2	1.12	0.95	95.0015	-1.0754	0.0000	0.0000;
	646	1	2.863	0.4	0	0	1	1.0726735	-16.644247	110	2	1.12	0.95	96.8207	-0.7791	0.0000	0.0000;
	647	1	2.203	1	0	0	1	1.0706039	-15.857287	110	2	1.12	0.95	94.8984	-2.3721	0.0000	0.0000;
	648	1	7.6	0.7	0	0	1	1.0633368	-15.448892	110	2	1.12	0.95	94.9200	-0.6822	0.0000	0.0000;
	649	1	3.735	0.75	0	0	1	1.0879113	-16.329623	110	2	1.12	0.95	95.6403	-0.6124	0.0000	0.0000;
	650	1	3.304	0.5	0	0	1	1.0696774	-15.932375	110	2	1.12	0.95	94.8621	-2.3408	0.0000	0.0000;
	651	1	11.015	0	0	0	1	1.0697937	-15.936382	110	2	1.12	0.95	94.9511	-2.3544	0.0000	0.0000;
	652	1	25.334	4	0	0	1	1.0689382	-16.022937	110	2	1.12	0.95	94.9941	-2.3344	0.0000	0.0000;
	653	1	6.057	0	0	0	1	1.069371	-16.023008	110	2	1.12	0.95	94.9526	-2.3512	0.0000	0.0000;
	654	1	0.661	0.2	0	0	1	1.0411445	-17.822602	110	2	1.12	0.95	97.6082	-0.1708	0.0000	0.0000;
	655	2	1.763	0.4	0	0	1	1.038659	-18.072461	110	2	1.12	0.95	97.6114	-0.1649	0.0000	0.0000;
	656	1	0.551	0	0	0	1	1.0666333	-16.270809	110	2	1.12	0.95	96.0129	-1.0154	0.0000	0.0000;
	657	1	3.525	1	0	0	1	1.0795232	-15.541113	110	2	1.12	0.95	94.6666	-1.1603	0.0000	0.0000;
	658	1	5.86	0.9	0	0	1	1.0738861	-16.564827	110	2	1.12	0.95	96.7082	-0.7600	0.0000	0.0000;
	659	1	2.754	1	0	0	1	1.0810715	-16.261569	110	2	1.12	0.95	95.5285	-1.3268	0.0000	0.0000;
	660	2	12	0	0	0	1	1.0871861	-13.109123	110	2	1.12	0.95	92.9239	0.0000	0.0000	0.0000;
	661	2	12.016	0	0	0	1	1.0868326	-13.115333	110	2	1.12	0.95	92.9332	-0.0008	0.0000	0.0000;
	662	1	5.508	0	0	0	1	1.0694276	-16.033643	110	2	1.12	0.95	95.0126	-2.3611	0.0000	0.0000;
	663	1	20.928	3	0	0	1	1.0703021	-15.856268	110	2	1.12	0.95	94.7584	-2.3469	0.0000	0.0000;
	664	1	6.609	1	0	0	1	1.0332461	-18.113533	110	2	1.12	0.95	97.0956	-0.1685	0.0000	0.0000;
	665	1	0	0	0	0	1	1.0281626	-17.95345	110	2	1.12	0.95	96.4711	0.0002	0.0000	0.0000;
	666	1	9.142	0.7	0	0	1	1.0329767	-18.118073	110	2	1.12	0.95	97.0828	-0.1653	0.0000	0.0000;
	667	2	9.362	0	0	0	1	1.0337939	-18.103144	110	2	1.12	0.95	97.0908	-0.1969	0.0000	0.0000;
	668	1	3.636	0	0	0	1	1.0297479	-18.030264	110	2	1.12	0.95	96.7078	-0.0494	0.0000	0.0000;
	669	1	4.958	0	0	0	1	1.0696214	-15.781289	110	2	1.12	0.95	96.2238	-1.1968	0.0000	0.0000;
	670	1	1.101	0	0	0	1	1.0696678	-15.725771	110	2	1.12	0.95	96.1891	-1.1741	0.0000	0.0000;
	671	2	19.497	3.7	0	0	1	1.0806693	-16.768156	110	2	1.12	0.95	95.8939	-0.5902	0.0000	0.0000;
	672	1	6.057	0	0	0	1	1.0696783	-15.700776	110	2	1.12	0.95	96.1754	-1.1650	0.0000	0.0000;
	673	2	6.609	0	0	0	1	1.0686377	-15.983305	110	2	1.12	0.95	95.8719	-0.5444	0.0000	0.0000;
	674	1	12.117	1	0	0	1	1.0690503	-16.074732	110	2	1.12	0.95	95.0249	-2.3526	0.0000	0.0000;
	675	1	14.87	0	0	0	1	1.0836981	-13.90587	110	2	1.12	0.95	93.6791	-0.1635	0.0000	0.0000;
	676	1	12.667	3	0	0	1	1.0494845	-17.132257	110	2	1.12	0.95	96.7238	-0.4220	0.0000	0.0000;
	677	1	5.949	1.1	0	0	1	1.0538392	-18.190116	110	2	1.12	0.95	98.2912	-0.3194	0.0000	0.0000;
	678	1	14.684	2.94	0	0	1	1.0915399	-15.995968	110	2	1.12	0.95	95.3426	-0.7280	0.0000	0.0000;
	679	1	7.225	0.3	0	0	1	1.0894685	-16.139157	110	2	1.12	0.95	95.5126	-0.7282	0.0000	0.0000;
	680	1	7.929	0.6	0	0	1	1.0963512	-14.948606	110	2	1.12	0.95	94.4659	-0.7877	0.0000	0.0000;
	681	2	13.223	1.004	0	0	1	1.0987618	-14.358492	110	2	1.12	0.95	93.9283	-0.7815	0.0000	0.0000;
	682	1	0	0	0	0	1	1.098784	-14.376585	110	2	1.12	0.95	93.9321	-0.7809	0.0000	0.0000;
	683	1	10.575	1.3	0	0	1	1.070197	-14.518007	110	2	1.12	0.95	94.1945	-0.3632	0.0000	0.0000;
	684	1	3.965	0.4	0	0	1	1.0338079	-18.781991	110	2	1.12	0.95	97.9244	-0.3150	0.0000	0.0000;
	685	1	2.754	0.3	0	0	1	1.0698597	-14.558212	110	2	1.12	0.95	94.2282	-0.3747	0.0000	0.0000;
	686	1	3.855	0	0	0	1	1.0963465	-15.23891	110	2	1.12	0.95	94.6603	-0.8128	0.0000	0.0000;
	687	2	16.523	7	0	0	1	1.0962343	-15.237923	110	2	1.12	0.95	94.6651	-0.8043	0.0000	0.0000;
	688	1	5.949	0.7	0	0	1	1.0966626	-15.274023	110	2	1.12	0.95	94.6997	-0.8192	0.0000	0.0000;
	689	1	11.467	1.13	0	0	1	1.0963386	-15.452199	110	2	1.12	0.95	94.8744	-0.8439	0.0000	0.0000;
	690	1	5.508	1	0	0	1	1.0819106	-16.282554	110	2	1.12	0.95	95.5587	-1.2374	0.0000	0.0000;
	691	1	4.958	0.5	0	0	1	1.0930437	-16.585732	110	2	1.12	0.95	94.6585	-0.1901	0.0000	0.0000;
	692	1	0	0	0	0	1	1.098145	-15.32619	110	2	1.12	0.95	94.6883	-0.8788	0.0000	0.0000;
	693	1	0	0	0	0	1	1.0979608	-15.3378	110	2	1.12	0.95	94.6914	-0.8766	0.0000	0.0000;
	694	1	2.313	0.4	0	0	1	1.0920148	-16.319093	110	2	1.12	0.95	95.0537	-0.6755	0.0000	0.0000;
	695	1	13.218	1.8	0	0	1	1.0953793	-15.503089	110	2	1.12	0.95	94.9395	-0.8261	0.0000	0.0000;
	696	1	10.74	1.29	0	0	1	1.0933185	-14.974527	110	2	1.12	0.95	94.7080	-0.7269	0.0000	0.0000;
	697	1	14.65	0.7	0	0	1	1.0949179	-15.384194	110	2	1.12	0.95	94.8594	-0.8045	0.0000	0.0000;
	698	1	0	0	0	0	1	1.0967382	-15.222413	110	2	1.12	0.95	94.6297	-0.8339	0.0000	0.0000;
	699	2	14.716	3.54	0	0	1	1.093058	-14.98951	110	2	1.12	0.95	94.7284	-0.7189	0.0000	0.0000;
	700	1	5.838	0.5	0	0	1	1.0941754	-14.923874	110	2	1.12	0.95	94.5994	-0.7488	0.0000	0.0000;
	701	1	7.82	0.6	0	0	1	1.0963305	-15.230521	110	2	1.12	0.95	94.6622	-0.7979	0.0000	0.0000;
	702	2	6.609	1	0	0	1	1.0719326	-15.509072	110	2	1.12	0.95	94.8669	-0.9548	0.0000	0.0000;
	703	1	6.609	3	0	0	1	1.0726875	-15.491766	110	2	1.12	0.95	94.8235	-0.9802	0.0000	0.0000;
	704	1	1.983	0	0	0	1	1.0859944	-16.772517	110	2	1.12	0.95	95.6901	-0.6906	0.0000	0.0000;
	705	1	11.015	2	0	0	1	1.0684451	-15.558236	110	2	1.12	0.95	96.2559	0.3096	0.0000	0.0000;
	706	1	6.389	0.6	0	0	1	1.0881813	-16.366217	110	2	1.12	0.95	95.2676	-0.3169	0.0000	0.0000;
	707	1	2.093	0	0	0	1	1.03792	-19.151728	110	2	1.12	0.95	99.1822	-0.2384	0.0000	0.0000;
	708	1	5.508	2	0	0	1	1.0813058	-14.170779	110	2	1.12	0.95	94.8878	0.0782	0.0000	0.0000;
	709	1	1.101	0	0	0	1	1.081612	-16.226262	110	2	1.12	0.95	94.8601	0.5977	0.0000	0.0000;
	710	1	0	0	0	0	1	1.0860523	-16.038732	110	2	1.12	0.95	94.9567	-0.8043	0.0000	0.0000;
	711	1	0	0	0	0	1	1.0861173	-16.032247	110	2	1.12	0.95	94.9556	-0.8031	0.0000	0.0000;
	712	2	32.714	6	0	0	1	1.0715056	-15.10253	110	2	1.12	0.95	94.2161	-0.7843	0.0000	0.0000;
	713	1	24.232	1	0	0	1	1.0687825	-16.109697	110	2	1.12	0.95	95.3805	-2.2811	0.0000	0.0000;
	714	1	4.958	1	0	0	1	1.0725439	-15.635588	110	2	1.12	0.95	94.7835	-2.2452	0.0000	0.0000;
	715	1	14.87	4.4	0	0	1	1.0468308	-18.476003	110	2	1.12	0.95	98.2568	-0.2545	0.0000	0.0000;
	716	1	3.636	0.3	0	0	1	1.0755393	-16.482525	110	2	1.12	0.95	96.5598	-0.7484	0.0000	0.0000;
	717	1	4.297	0	0	0	1	1.0681235	-15.545308	110	2	1.12	0.95	94.9875	-0.8765	0.0000	0.0000;
	718	2	13.989	1.7	0	0	1	1.0402155	-17.988458	110	2	1.12	0.95	97.6437	-0.1589	0.0000	0.0000;
	719	1	4.185	0	0	0	1	1.0774898	-16.163936	110	2	1.12	0.95	95.3190	-0.9268	0.0000	0.0000;
	720	1	2.203	1	0	0	1	1.0864983	-16.408547	110	2	1.12	0.95	95.7279	-0.6727	0.0000	0.0000;
	721	1	4.958	1	0	0	1	1.0751438	-16.522585	110	2	1.12	0.95	96.1007	-1.2995	0.0000	0.0000;
	722	2	7.853	1.2	0	0	1	1.0778609	-16.375378	110	2	1.12	0.95	96.1198	-0.6776	0.0000	0.0000;
	723	1	0.22	0	0	0	1	1.0758187	-15.880691	110	2	1.12	0.95	95.1155	-1.0416	0.0000	0.0000;
	724	1	3.856	0.5	0	0	1	1.0683228	-16.13805	110	2	1.12	0.95	95.5868	-2.0406	0.0000	0.0000;
	725	1	4.185	1.4	0	0	1	1.0827653	-15.814514	110	2	1.12	0.95	94.8774	-1.2463	0.0000	0.0000;
	726	1	31.944	7	0	0	1	1.0869001	-15.965052	110	2	1.12	0.95	94.9635	-1.3430	0.0000	0.0000;
	727	1	0	0	0	0	1	1.0867137	-15.958296	110	2	1.12	0.95	94.9605	-1.3420	0.0000	0.0000;
	728	1	1.101	0.5	0	0	1	1.0765997	-15.099906	110	2	1.12	0.95	94.2984	-1.0694	0.0000	0.0000;
	729	1	0	0	0	0	1	1.0892884	-15.880392	110	2	1.12	0.95	94.8529	-1.4077	0.0000	0.0000;
	730	1	0	0	0	0	1	1.0897096	-15.871247	110	2	1.12	0.95	94.8236	-1.4274	0.0000	0.0000;
	731	2	10.464	1	0	0	1	1.0829362	-16.206978	110	2	1.12	0.95	95.3525	-1.3409	0.0000	0.0000;
	732	1	34.145	5	0	0	1	1.0817762	-16.534443	110	2	1.12	0.95	95.5748	-1.2644	0.0000	0.0000;
	733	1	5.398	0	0	0	1	1.075264	-16.584062	110	2	1.12	0.95	95.9170	-1.1254	0.0000	0.0000;
	734	1	6.719	0	0	0	1	1.0975287	-15.758735	110	2	1.12	0.95	94.6954	-0.7552	0.0000	0.0000;
	735	1	4.407	0.5	0	0	1	1.0720974	-16.294334	110	2	1.12	0.95	96.0668	-1.4046	0.0000	0.0000;
	736	2	12	0	0	0	1	1.0785411	-14.196757	110	2	1.12	0.95	93.2272	-0.9490	0.0000	0.0000;
	737	1	0	0	0	0	1	1.0786141	-14.209093	110	2	1.12	0.95	93.2456	-0.9525	0.0000	0.0000;
	738	1	5.761	1	0	0	1	1.0665807	-16.255022	110	2	1.12	0.95	95.9994	-1.0081	0.0000	0.0000;
	739	1	3.856	0	0	0	1	1.0818664	-14.535839	110	2	1.12	0.95	94.2473	-0.3858	0.0000	0.0000;
	740	2	3.304	0.5	0	0	1	1.0803312	-15.070189	110	2	1.12	0.95	94.7195	-0.6066	0.0000	0.0000;
	741	1	3.746	0.1	0	0	1	1.0734901	-16.56144	110	2	1.12	0.95	96.6978	-0.8071	0.0000	0.0000;
	742	1	7.093	0.7	0	0	1	1.0732069	-16.556261	110	2	1.12	0.95	96.7309	-0.7800	0.0000	0.0000;
	743	1	0.551	0.1	0	0	1	1.0796658	-16.25237	110	2	1.12	0.95	96.0223	-0.7206	0.0000	0.0000;
	744	1	2.975	0.1	0	0	1	1.0805125	-16.18911	110	2	1.12	0.95	95.9721	-0.7391	0.0000	0.0000;
	745	1	1.983	0.8	0	0	1	1.0766376	-16.529821	110	2	1.12	0.95	95.4793	-0.4564	0.0000	0.0000;
	746	1	7.379	2	0	0	1	1.0361855	-19.291264	110	2	1.12	0.95	99.4426	-0.2015	0.0000	0.0000;
	747	2	16.853	3.7	0	0	1	1.0427217	-18.079568	110	2	1.12	0.95	97.8471	-0.2746	0.0000	0.0000;
	748	1	4.958	0.5	0	0	1	1.0765658	-15.449249	110	2	1.12	0.95	95.3409	-1.0734	0.0000	0.0000;
	749	1	1.101	0.4	0	0	1	1.073905	-15.386049	110	2	1.12	0.95	94.6537	-1.0086	0.0000	0.0000;
	750	1	6.609	0.2	0	0	1	1.036348	-19.305904	110	2	1.12	0.95	99.4442	-0.2202	0.0000	0.0000;
	751	1	11.015	0.2	0	0	1	1.0380403	-19.135263	110	2	1.12	0.95	99.1523	-0.2344	0.0000	0.0000;
	752	1	6.057	0.3	0	0	1	1.036364	-19.269811	110	2	1.12	0.95	99.4210	-0.2053	0.0000	0.0000;
	753	1	17.624	1.5	0	0	1	1.0769818	-16.006152	110	2	1.12	0.95	95.6592	-1.0431	0.0000	0.0000;
	754	1	17.624	4	0	0	1	1.0738226	-15.416204	110	2	1.12	0.95	94.5802	-2.4126	0.0000	0.0000;
	755	1	0	0	0	0	1	1.0738546	-15.40933	110	2	1.12	0.95	94.5820	-2.4089	0.0000	0.0000;
	756	1	9.362	0.4	0	0	1	1.0857243	-16.458522	110	2	1.12	0.95	95.7431	-0.5155	0.0000	0.0000;
	757	1	12.117	1	0	0	1	1.076651	-16.003828	110	2	1.12	0.95	95.6628	-0.9911	0.0000	0.0000;
	758	1	1.101	0	0	0	1	1.0742354	-15.055882	110	2	1.12	0.95	95.3232	-0.9627	0.0000	0.0000;
	759	2	1.171	0.491	0	0	1	1.0667654	-14.473219	110	2	1.12	0.95	93.9174	-0.6329	0.0000	0.0000;
	760	2	12.888	3	0	0	1	1.0817756	-16.791887	110	2	1.12	0.95	95.9231	-0.5890	0.0000	0.0000;
	761	1	14.319	2	0	0	1	1.0732077	-15.9649	110	2	1.12	0.95	95.8382	-0.5459	0.0000	0.0000;
	762	1	7.929	0.4	0	0	1	1.0606236	-15.610446	110	2	1.12	0.95	94.9967	-0.6215	0.0000	0.0000;
	763	1	5.618	0.9	0	0	1	1.049144	-16.809529	110	2	1.12	0.95	96.9133	-0.3645	0.0000	0.0000;
	764	1	2.203	1	0	0	1	1.0816602	-15.672265	110	2	1.12	0.95	95.0061	-1.1933	0.0000	0.0000;
	765	1	0	0	0	0	1	1.0816459	-15.676223	110	2	1.12	0.95	95.0048	-1.1945	0.0000	0.0000;
	766	1	13.218	2	0	0	1	1.0783828	-15.749808	110	2	1.12	0.95	95.3104	-0.9116	0.0000	0.0000;
	767	1	13.218	2	0	0	1	1.0787347	-15.77842	110	2	1.12	0.95	95.3164	-0.9977	0.0000	0.0000;
	768	1	13.218	2	0	0	1	1.0730141	-16.025579	110	2	1.12	0.95	95.9096	-0.6087	0.0000	0.0000;
	769	1	6.939	2	0	0	1	1.0681184	-15.572631	110	2	1.12	0.95	95.0519	-0.3847	0.0000	0.0000;
	770	1	8.039	1.7	0	0	1	1.075076	-15.301426	110	2	1.12	0.95	95.4655	-0.2155	0.0000	0.0000;
	771	1	2.975	0.8	0	0	1	1.0579843	-16.024411	110	2	1.12	0.95	95.4313	-0.6294	0.0000	0.0000;
	772	1	6.609	0	0	0	1	1.0597948	-15.777459	110	2	1.12	0.95	95.1514	-0.6238	0.0000	0.0000;
	773	1	3.525	0	0	0	1	1.0572138	-16.246991	110	2	1.12	0.95	95.6085	-0.6309	0.0000	0.0000;
	774	1	0	0	0	0	1	1.0622653	-15.306016	110	2	1.12	0.95	94.7826	-0.6863	0.0000	0.0000;
	775	1	0	0	0	0	1	1.0622622	-15.313758	110	2	1.12	0.95	94.7848	-0.6857	0.0000	0.0000;
	776	1	2.203	0	0	0	1	1.0777541	-15.954888	110	2	1.12	0.95	95.5551	-1.0713	0.0000	0.0000;
	777	1	11.676	1.7	0	0	1	1.0662501	-14.553252	110	2	1.12	0.95	94.0004	-0.6323	0.0000	0.0000;
	778	2	4.076	0.2	0	0	1	1.0583239	-16.079052	110	2	1.12	0.95	95.4277	-0.6291	0.0000	0.0000;
	779	1	12.403	11.26	0	0	1	1.0726938	-16.254442	110	2	1.12	0.95	95.7192	-0.6081	0.0000	0.0000;
	780	2	2.863	1	0	0	1	1.075436	-14.114976	110	2	1.12	0.95	93.5136	-0.3631	0.0000	0.0000;
	781	1	2.203	0	0	0	1	1.0676342	-16.158157	110	2	1.12	0.95	95.7364	-1.4985	0.0000	0.0000;
	782	1	0	0	0	0	1	1.0942616	-15.396127	110	2	1.12	0.95	94.8096	-0.7981	0.0000	0.0000;
	783	2	3.856	3	0	0	1	1.0936108	-15.404235	110	2	1.12	0.95	94.8328	-0.7772	0.0000	0.0000;
	784	1	4.958	1	0	0	1	1.0739017	-16.152651	110	2	1.12	0.95	95.8872	-1.3413	0.0000	0.0000;
	785	1	12.779	1.4	0	0	1	1.0929872	-15.428606	110	2	1.12	0.95	94.8717	-0.7646	0.0000	0.0000;
	786	1	6.609	0.5	0	0	1	1.0755489	-14.318557	110	2	1.12	0.95	95.3799	-1.3122	0.0000	0.0000;
	787	1	4.737	0.6	0	0	1	1.0506133	-16.739178	110	2	1.12	0.95	96.6844	-0.4228	0.0000	0.0000;
	788	2	3.878	0	0	0	1	1.0337948	-18.631185	110	2	1.12	0.95	97.6750	-0.2928	0.0000	0.0000;
	789	1	4.847	0.64	0	0	1	1.0357538	-18.477416	110	2	1.12	0.95	97.5563	-0.3267	0.0000	0.0000;
	790	1	3.195	0.3	0	0	1	1.0651874	-16.321201	110	2	1.12	0.95	95.6713	-0.3596	0.0000	0.0000;
	791	1	3.525	1.4	0	0	1	1.064674	-15.084785	110	2	1.12	0.95	94.6420	-0.5532	0.0000	0.0000;
	792	2	0	0	0	0	1	1.0345325	-18.881335	110	2	1.12	0.95	98.1266	-0.3436	0.0000	0.0000;
	793	1	3.304	0	0	0	1	1.0719157	-16.296731	110	2	1.12	0.95	96.0811	-1.4180	0.0000	0.0000;
	794	1	3.304	0.5	0	0	1	1.0703611	-16.037213	110	2	1.12	0.95	96.2297	-1.3257	0.0000	0.0000;
	795	1	3.304	0.5	0	0	1	1.0723703	-16.273406	110	2	1.12	0.95	96.0372	-1.3969	0.0000	0.0000;
	796	1	7.82	1.7	0	0	1	1.0574362	-16.124296	110	2	1.12	0.95	95.5202	-0.6234	0.0000	0.0000;
	797	1	3.084	0.1	0	0	1	1.0728018	-14.705568	110	2	1.12	0.95	93.9607	-0.8454	0.0000	0.0000;
	798	1	12.117	2	0	0	1	1.0766476	-16.351772	110	2	1.12	0.95	95.9043	-1.3201	0.0000	0.0000;
	799	1	0	0	0	0	1	1.087169	-16.332317	110	2	1.12	0.95	95.6661	-0.6875	0.0000	0.0000;
	800	1	5.067	0.6	0	0	1	1.0342392	-18.602879	110	2	1.12	0.95	97.6574	-0.3011	0.0000	0.0000;
	801	1	2.203	0	0	0	1	1.0682091	-15.642099	110	2	1.12	0.95	95.1633	-0.9963	0.0000	0.0000;
	802	1	9.913	1.5	0	0	1	1.0764443	-16.372231	110	2	1.12	0.95	95.9260	-1.3109	0.0000	0.0000;
	803	2	17.195	4.915	0	0	1	1.078452	-16.06958	110	2	1.12	0.95	95.1490	-0.9588	0.0000	0.0000;
	804	2	29.151	8.601	0	0	1	1.0645804	-16.544751	110	2	1.12	0.95	96.0680	-0.4856	0.0000	0.0000;
	805	1	6.389	1.2	0	0	1	1.044219	-17.33952	110	2	1.12	0.95	96.4995	-0.3944	0.0000	0.0000;
	806	1	1.101	1	0	0	1	1.0715253	-16.207872	110	2	1.12	0.95	95.8687	-1.5789	0.0000	0.0000;
	807	1	8.812	0.9	0	0	1	1.0767672	-16.10817	110	2	1.12	0.95	95.2539	-0.9754	0.0000	0.0000;
	808	1	3.525	0.7	0	0	1	1.0779428	-16.083573	110	2	1.12	0.95	95.1920	-0.9529	0.0000	0.0000;
	809	2	5.508	0	0	0	1	1.0813372	-16.271957	110	2	1.12	0.95	95.4058	-0.7594	0.0000	0.0000;
	810	1	3.525	0	0	0	1	1.0686704	-16.512826	110	2	1.12	0.95	95.9162	-0.4808	0.0000	0.0000;
	811	1	7.82	0.6	0	0	1	1.0698129	-16.203602	110	2	1.12	0.95	95.5573	-0.9023	0.0000	0.0000;
	812	1	6.609	0	0	0	1	1.0668885	-17.497306	110	2	1.12	0.95	97.2324	-0.6409	0.0000	0.0000;
	813	1	3.525	0.2	0	0	1	1.0697319	-17.25077	110	2	1.12	0.95	96.8711	-0.6472	0.0000	0.0000;
	814	1	3.195	0.3	0	0	1	1.0659057	-16.708566	110	2	1.12	0.95	96.2085	-0.7529	0.0000	0.0000;
	815	2	6.012	1.8	0	0	1	1.0784049	-16.423002	110	2	1.12	0.95	95.3537	-0.5128	0.0000	0.0000;
	816	1	1.321	0	0	0	1	1.0669835	-17.564284	110	2	1.12	0.95	97.2936	-0.6656	0.0000	0.0000;
	817	1	4.297	0.4	0	0	1	1.0339754	-18.8798	110	2	1.12	0.95	98.0891	-0.3164	0.0000	0.0000;
	818	1	11.015	2	0	0	1	1.0813865	-15.432543	110	2	1.12	0.95	94.4659	0.4514	0.0000	0.0000;
	819	1	2.534	0.4	0	0	1	1.0972383	-15.587248	110	2	1.12	0.95	94.3095	-0.5617	0.0000	0.0000;
	820	1	9.142	0.6	0	0	1	1.1012527	-14.463568	110	2	1.12	0.95	92.9732	-0.1543	0.0000	0.0000;
	821	1	6.057	1	0	0	1	1.0724975	-15.387541	110	2	1.12	0.95	94.9773	-2.2326	0.0000	0.0000;
	822	1	4.737	0.2	0	0	1	1.0892821	-16.625889	110	2	1.12	0.95	95.3737	-0.7167	0.0000	0.0000;
	823	1	3.304	0	0	0	1	1.0705312	-16.054484	110	2	1.12	0.95	95.3174	-2.0193	0.0000	0.0000;
	824	1	6.609	0	0	0	1	1.0809667	-13.394116	110	2	1.12	0.95	94.9493	-0.8582	0.0000	0.0000;
	825	1	8.072	0.52	0	0	1	1.093898	-14.946882	110	2	1.12	0.95	94.6366	-0.7481	0.0000	0.0000;
	826	1	0	0	0	0	1	1.0726267	-16.223575	110	2	1.12	0.95	96.0209	-1.3816	0.0000	0.0000;
	827	1	0	0	0	0	1	1.0676475	-16.153471	110	2	1.12	0.95	95.9671	-0.7881	0.0000	0.0000;
	828	1	7.6	0	0	0	1	1.0842032	-16.012834	110	2	1.12	0.95	94.8892	-0.6801	0.0000	0.0000;
	829	1	1.101	0.3	0	0	1	1.0336559	-18.678808	110	2	1.12	0.95	97.7763	-0.3124	0.0000	0.0000;
	830	1	3.304	0	0	0	1	1.0780461	-16.43226	110	2	1.12	0.95	95.7991	-0.6946	0.0000	0.0000;
	831	1	2.203	0.5	0	0	1	1.07026	-16.538367	110	2	1.12	0.95	96.1393	-0.5478	0.0000	0.0000;
	832	1	6.057	0	0	0	1	1.0847788	-16.085268	110	2	1.12	0.95	94.9844	-0.7451	0.0000	0.0000;
	833	1	5.067	0.2	0	0	1	1.0842449	-16.050483	110	2	1.12	0.95	94.9384	-0.7021	0.0000	0.0000;
	834	2	3.304	1	0	0	1	1.0718425	-16.278352	110	2	1.12	0.95	96.0748	-1.4300	0.0000	0.0000;
	835	1	4.407	1	0	0	1	1.0786532	-16.288126	110	2	1.12	0.95	95.9055	-1.0869	0.0000	0.0000;
	836	1	0	0	0	0	1	1.1004539	-10.510528	110	3	1.12	0.95	92.2126	0.0205	0.0000	0.0000;
	837	1	0.671	0.55	0	0	1	1.0975406	-11.359634	110	3	1.12	0.95	92.3821	0.0043	0.0000	0.0000;
	838	1	4.877	0.39	0	0	1	1.0591282	-16.027542	110	3	1.12	0.95	95.1890	-0.3262	0.0000	0.0000;
	839	1	0	0	0	0	1	1.061774	-16.154877	110	3	1.12	0.95	95.2498	-0.4959	0.0000	0.0000;
	840	2	56.077	30.972	0	0	1	1.0590098	-16.016851	110	3	1.12	0.95	95.1811	-0.3013	0.0000	0.0000;
	841	1	0	0	0	0	1	1.0592076	-16.022906	110	3	1.12	0.95	95.1760	-0.3272	0.0000	0.0000;
	842	1	7.238	1.749	0	0	1	1.0768622	-16.274882	110	3	1.12	0.95	96.4044	0.0591	0.0000	0.0000;
	843	1	0	0	0	0	1	1.0768281	-16.2775	110	3	1.12	0.95	96.4048	0.0596	0.0000	0.0000;
	844	2	3.051	0.802	0	0	1	1.0803363	-15.068669	110	3	1.12	0.95	95.2264	0.0822	0.0000	0.0000;
	845	1	0	0	0	0	1	1.0870552	-11.88581	110	3	1.12	0.95	93.1720	0.0772	0.0000	0.0000;
	846	1	10.218	2.087	0	0	1	1.0870386	-11.883258	110	3	1.12	0.95	93.1722	0.0768	0.0000	0.0000;
	847	1	15.087	2.717	0	0	1	1.0716095	-16.011301	110	3	1.12	0.95	96.1570	0.3536	0.0000	0.0000;
	848	2	0	0	0	0	1	1.0716248	-16.005178	110	3	1.12	0.95	96.1546	0.3529	0.0000	0.0000;
	849	1	0	0	0	0	1	1.0716377	-16.000297	110	3	1.12	0.95	96.1526	0.3522	0.0000	0.0000;
	850	1	6.578	0.725	0	0	1	1.0951231	-11.200976	110	3	1.12	0.95	93.0332	-0.6070	0.0000	0.0000;
	851	1	7.954	1.979	0	0	1	1.0950996	-11.210722	110	3	1.12	0.95	93.0348	-0.6052	0.0000	0.0000;
	852	1	0	0	0	0	1	1.0958615	-13.381108	110	3	1.12	0.95	93.2785	0.2738	0.0000	0.0000;
	853	1	0	0	0	0	1	1.0958581	-13.380859	110	3	1.12	0.95	93.2778	0.2739	0.0000	0.0000;
	854	2	6.79	2.42	0	0	1	1.0869086	-14.073895	110	3	1.12	0.95	93.9545	0.5757	0.0000	0.0000;
	855	1	7.932	2.43	0	0	1	1.0868647	-14.075266	110	3	1.12	0.95	93.9620	0.5762	0.0000	0.0000;
	856	1	7.386	2.444	0	0	1	1.0860033	-12.336912	110	3	1.12	0.95	93.7957	-0.2497	0.0000	0.0000;
	857	1	0	0	0	0	1	1.0859937	-12.341502	110	3	1.12	0.95	93.7976	-0.2516	0.0000	0.0000;
	858	1	0	0	0	0	1	1.0617893	-16.15514	110	3	1.12	0.95	95.2498	-0.4968	0.0000	0.0000;
	859	1	18.254	1.735	0	0	1	1.0719862	-16.010862	110	3	1.12	0.95	95.7542	-0.0378	0.0000	0.0000;
	860	1	15.689	1.264	0	0	1	1.0719678	-16.010363	110	3	1.12	0.95	95.7561	-0.0373	0.0000	0.0000;
	861	1	9.082	1.943	0	0	1	1.0902572	-13.772281	110	3	1.12	0.95	93.7063	0.4320	0.0000	0.0000;
	862	1	0	0	0	0	1	1.088405	-14.056233	110	3	1.12	0.95	93.8243	0.4764	0.0000	0.0000;
	863	1	0	0	0	0	1	1.088405	-14.056232	110	3	1.12	0.95	93.8243	0.4764	0.0000	0.0000;
	864	1	6.819	3.168	0	0	1	1.0893327	-11.982218	110	3	1.12	0.95	93.1794	-0.0066	0.0000	0.0000;
	865	1	5.109	2.237	0	0	1	1.0892974	-11.988835	110	3	1.12	0.95	93.1816	-0.0062	0.0000	0.0000;
	866	1	3.653	-0.511	0	0	1	1.0773467	-14.814384	110	3	1.12	0.95	94.8170	0.0155	0.0000	0.0000;
	867	1	4.505	-0.67	0	0	1	1.0773651	-14.808792	110	3	1.12	0.95	94.8147	0.0154	0.0000	0.0000;
	868	1	2.04	0.563	0	0	1	1.0588094	-17.411115	110	3	1.12	0.95	96.9516	-0.2156	0.0000	0.0000;
	869	1	1.814	0.483	0	0	1	1.0633562	-16.384321	110	3	1.12	0.95	95.4498	-0.6000	0.0000	0.0000;
	870	1	0	0	0	0	1	1.0588233	-17.410395	110	3	1.12	0.95	96.9499	-0.2161	0.0000	0.0000;
	871	1	15.185	8.017	0	0	1	1.088215	-13.041137	110	3	1.12	0.95	93.8271	0.1193	0.0000	0.0000;
	872	1	0	0	0	0	1	1.0881515	-13.045591	110	3	1.12	0.95	93.8330	0.1200	0.0000	0.0000;
	873	2	8.502	4.324	0	0	1	1.100105	-10.923695	110	3	1.12	0.95	91.9612	0.0000	0.0000	0.0000;
	874	1	10.884	3.271	0	0	1	1.0955747	-11.444227	110	3	1.12	0.95	92.5202	0.0595	0.0000	0.0000;
	875	1	6.108	0.936	0	0	1	1.0595595	-17.069559	110	3	1.12	0.95	97.7721	0.3577	0.0000	0.0000;
	876	2	3.178	-0.472	0	0	1	1.0814129	-10.350251	110	3	1.12	0.95	93.8538	-0.2204	0.0000	0.0000;
	877	1	0	0	0	0	1	1.0817365	-10.302583	110	3	1.12	0.95	93.7698	-0.2035	0.0000	0.0000;
	878	1	4.435	1.155	0	0	1	1.0545878	-18.205302	110	3	1.12	0.95	97.6446	-0.4863	0.0000	0.0000;
	879	1	4.557	1.247	0	0	1	1.05459	-18.211005	110	3	1.12	0.95	97.6467	-0.4857	0.0000	0.0000;
	880	1	10.424	4.535	0	0	1	1.0805695	-14.894831	110	3	1.12	0.95	94.7664	0.2172	0.0000	0.0000;
	881	1	0	0	0	0	1	1.0805465	-14.897008	110	3	1.12	0.95	94.7718	0.2180	0.0000	0.0000;
	882	1	2.157	1.058	0	0	1	1.0917916	-11.728796	110	3	1.12	0.95	92.9040	-0.0570	0.0000	0.0000;
	883	1	1.133	0.558	0	0	1	1.0914397	-11.717774	110	3	1.12	0.95	92.9020	-0.0379	0.0000	0.0000;
	884	1	0	0	0	0	1	1.0918302	-11.727452	110	3	1.12	0.95	92.9004	-0.0587	0.0000	0.0000;
	885	1	0	0	0	0	1	1.0914599	-11.717066	110	3	1.12	0.95	92.9001	-0.0388	0.0000	0.0000;
	886	1	0	0	0	0	1	1.1009847	-6.2877727	110	3	1.12	0.95	90.1361	0.0167	0.0000	0.0000;
	887	1	1.36	0.162	0	0	1	1.1009666	-6.2737202	110	3	1.12	0.95	90.1392	0.0159	0.0000	0.0000;
	888	1	4.067	1.144	0	0	1	1.0603905	-18.192157	110	3	1.12	0.95	97.9654	-0.2065	0.0000	0.0000;
	889	1	0	0	0	0	1	1.0610438	-18.134134	110	3	1.12	0.95	97.8951	-0.2228	0.0000	0.0000;
	890	1	9.64	1.903	0	0	1	1.0873064	-11.932669	110	3	1.12	0.95	93.1939	0.0699	0.0000	0.0000;
	891	1	0	0	0	0	1	1.0873603	-11.929909	110	3	1.12	0.95	93.1918	0.0698	0.0000	0.0000;
	892	1	4.422	0.483	0	0	1	1.0949499	-11.96598	110	3	1.12	0.95	93.0096	-0.2722	0.0000	0.0000;
	893	1	2.721	0.239	0	0	1	1.0900393	-12.329718	110	3	1.12	0.95	93.9875	-0.3140	0.0000	0.0000;
	894	1	0	0	0	0	1	1.0955584	-11.929846	110	3	1.12	0.95	92.9147	-0.2784	0.0000	0.0000;
	895	1	7.931	0.809	0	0	1	1.0862199	-8.7131917	110	3	1.12	0.95	92.3392	0.1667	0.0000	0.0000;
	896	2	0.999	2.999	0	0	1	1.0925535	-12.604135	110	3	1.12	0.95	93.1233	0.1059	0.0000	0.0000;
	897	1	9.065	3.24	0	0	1	1.0922526	-12.618177	110	3	1.12	0.95	93.1283	0.1105	0.0000	0.0000;
	898	1	0	0	0	0	1	1.0930604	-11.443492	110	3	1.12	0.95	93.2224	-0.5778	0.0000	0.0000;
	899	1	5.221	1.675	0	0	1	1.0930383	-11.443909	110	3	1.12	0.95	93.2255	-0.5783	0.0000	0.0000;
	900	1	5.161	1.271	0	0	1	1.054617	-18.271893	110	3	1.12	0.95	97.7134	-0.4918	0.0000	0.0000;
	901	1	6.951	1.742	0	0	1	1.0545836	-18.27097	110	3	1.12	0.95	97.7129	-0.4921	0.0000	0.0000;
	902	2	0	0	0	0	1	1.0658514	-14.87065	110	3	1.12	0.95	97.5834	0.4069	0.0000	0.0000;
	903	2	13.286	2.383	0	0	1	1.0658367	-14.872553	110	3	1.12	0.95	97.5845	0.4072	0.0000	0.0000;
	904	1	0	0	0	0	1	1.0682593	-14.726719	110	3	1.12	0.95	97.2068	0.3623	0.0000	0.0000;
	905	1	6.009	2.713	0	0	1	1.0998332	-10.634858	110	3	1.12	0.95	92.2331	0.0330	0.0000	0.0000;
	906	1	3.061	1.498	0	0	1	1.0962577	-11.332723	110	3	1.12	0.95	92.4413	0.0422	0.0000	0.0000;
	907	1	4.193	1.134	0	0	1	1.0798967	-14.955143	110	3	1.12	0.95	94.8379	0.2330	0.0000	0.0000;
	908	1	0	0	0	0	1	1.0806063	-14.898054	110	3	1.12	0.95	94.7718	0.2145	0.0000	0.0000;
	909	1	12.465	2.592	0	0	1	1.0837785	-13.73561	110	3	1.12	0.95	94.5109	0.0683	0.0000	0.0000;
	910	1	0	0	0	0	1	1.0874598	-12.967244	110	3	1.12	0.95	93.8116	0.0159	0.0000	0.0000;
	911	1	0	0	0	0	1	1.0874598	-12.967244	110	3	1.12	0.95	93.8116	0.0159	0.0000	0.0000;
	912	1	12.497	5.022	0	0	1	1.0837677	-13.733342	110	3	1.12	0.95	94.5092	0.0709	0.0000	0.0000;
	913	1	7.141	-0.97	0	0	1	1.0731354	-15.986159	110	3	1.12	0.95	95.7620	-0.1234	0.0000	0.0000;
	914	1	7.845	2.019	0	0	1	1.0731093	-15.992704	110	3	1.12	0.95	95.7642	-0.1231	0.0000	0.0000;
	915	1	4.655	1.517	0	0	1	1.0864026	-12.296796	110	3	1.12	0.95	93.7451	-0.2439	0.0000	0.0000;
	916	1	0	0	0	0	1	1.0863928	-12.299613	110	3	1.12	0.95	93.7468	-0.2450	0.0000	0.0000;
	917	1	22.89	8.019	0	0	1	1.0844806	-14.04502	110	3	1.12	0.95	94.1233	0.6687	0.0000	0.0000;
	918	1	2.945	0	0	0	1	1.0866348	-13.922261	110	3	1.12	0.95	93.9949	0.5839	0.0000	0.0000;
	919	1	4.536	0.887	0	0	1	1.0910057	-12.672481	110	3	1.12	0.95	93.3169	0.0910	0.0000	0.0000;
	920	1	0	0	0	0	1	1.0914781	-12.650087	110	3	1.12	0.95	93.2844	0.0770	0.0000	0.0000;
	921	1	0	0	0	0	1	1.0910484	-12.668608	110	3	1.12	0.95	93.3121	0.0901	0.0000	0.0000;
	922	1	0	0	0	0	1	1.0914772	-12.650071	110	3	1.12	0.95	93.2844	0.0771	0.0000	0.0000;
	923	1	2.383	0.326	0	0	1	1.0860205	-8.989381	110	3	1.12	0.95	92.7673	0.0556	0.0000	0.0000;
	924	1	0	0	0	0	1	1.0860219	-8.9981518	110	3	1.12	0.95	92.7695	0.0558	0.0000	0.0000;
	925	1	13.4	2.937	0	0	1	1.0874663	-12.254321	110	3	1.12	0.95	93.6068	0.2478	0.0000	0.0000;
	926	1	5.784	2.288	0	0	1	1.0968369	-11.087034	110	3	1.12	0.95	92.5780	0.0819	0.0000	0.0000;
	927	1	15.441	1.394	0	0	1	1.0561099	-17.651781	110	3	1.12	0.95	97.7088	-0.1967	0.0000	0.0000;
	928	1	0	0	0	0	1	1.0561108	-17.644955	110	3	1.12	0.95	97.7039	-0.2004	0.0000	0.0000;
	929	1	21.247	4.576	0	0	1	1.0680747	-16.180975	110	3	1.12	0.95	96.4671	0.4034	0.0000	0.0000;
	930	1	0	0	0	0	1	1.0681203	-16.178441	110	3	1.12	0.95	96.4649	0.4034	0.0000	0.0000;
	931	1	11.098	1.669	0	0	1	1.0742957	-16.13262	110	3	1.12	0.95	96.3908	0.2725	0.0000	0.0000;
	932	1	0	0	0	0	1	1.0743855	-16.128869	110	3	1.12	0.95	96.3891	0.2694	0.0000	0.0000;
	933	1	4.306	2.43	0	0	1	1.0899296	-12.75786	110	3	1.12	0.95	93.4206	0.1211	0.0000	0.0000;
	934	1	0	0	0	0	1	1.090311	-12.738046	110	3	1.12	0.95	93.3975	0.1084	0.0000	0.0000;
	935	1	2.427	-0.217	0	0	1	1.0765851	-15.65331	110	3	1.12	0.95	95.2028	-0.1148	0.0000	0.0000;
	936	1	9.144	-1.193	0	0	1	1.0765718	-15.658204	110	3	1.12	0.95	95.2054	-0.1128	0.0000	0.0000;
	937	1	4.763	2.183	0	0	1	1.0949924	-11.224009	110	3	1.12	0.95	92.8457	0.1254	0.0000	0.0000;
	938	1	0	0	0	0	1	1.0950426	-11.213763	110	3	1.12	0.95	92.8430	0.1249	0.0000	0.0000;
	939	1	11.331	1.62	0	0	1	1.0986097	-12.984149	110	3	1.12	0.95	92.8922	0.2467	0.0000	0.0000;
	940	1	4.533	0.972	0	0	1	1.1032235	-12.943145	110	3	1.12	0.95	92.7850	0.0247	0.0000	0.0000;
	941	1	0	0	0	0	1	1.0992833	-12.911513	110	3	1.12	0.95	92.8109	0.2357	0.0000	0.0000;
	942	1	4.308	1.374	0	0	1	1.0839071	-13.728109	110	3	1.12	0.95	94.4943	0.0649	0.0000	0.0000;
	943	1	5.216	1.293	0	0	1	1.0874597	-12.96724	110	3	1.12	0.95	93.8116	0.0159	0.0000	0.0000;
	944	1	6.246	1.875	0	0	1	1.0886848	-12.880597	110	3	1.12	0.95	93.6086	0.1145	0.0000	0.0000;
	945	1	0	0	0	0	1	1.088724	-12.872135	110	3	1.12	0.95	93.6067	0.1137	0.0000	0.0000;
	946	1	4.54	0.805	0	0	1	1.092498	-11.46664	110	3	1.12	0.95	93.3176	-0.5949	0.0000	0.0000;
	947	1	0	0	0	0	1	1.0930771	-11.399267	110	3	1.12	0.95	93.2517	-0.6040	0.0000	0.0000;
	948	1	2.156	0.48	0	0	1	1.0903337	-12.63463	110	3	1.12	0.95	93.4826	0.2386	0.0000	0.0000;
	949	1	0	0	0	0	1	1.090403	-12.631457	110	3	1.12	0.95	93.4733	0.2366	0.0000	0.0000;
	950	1	20.758	0.504	0	0	1	1.0870436	-13.100531	110	3	1.12	0.95	93.9518	0.1426	0.0000	0.0000;
	951	1	0	0	0	0	1	1.0871081	-13.096074	110	3	1.12	0.95	93.9460	0.1419	0.0000	0.0000;
	952	2	9.988	1.351	0	0	1	1.0723286	-16.096771	110	3	1.12	0.95	95.9013	-0.1186	0.0000	0.0000;
	953	1	7.404	-0.036	0	0	1	1.0723816	-16.076166	110	3	1.12	0.95	95.8989	-0.1170	0.0000	0.0000;
	954	1	0	0	0	0	1	1.0951408	-11.201264	110	3	1.12	0.95	93.0332	-0.6080	0.0000	0.0000;
	955	1	3.398	0	0	0	1	1.0949633	-11.239432	110	3	1.12	0.95	93.0603	-0.6061	0.0000	0.0000;
	956	1	2.158	1.728	0	0	1	1.0549191	-17.278377	110	3	1.12	0.95	96.4532	-0.4260	0.0000	0.0000;
	957	1	0	0	0	0	1	1.054895	-17.28491	110	3	1.12	0.95	96.4555	-0.4258	0.0000	0.0000;
	958	2	6.026	0.779	0	0	1	1.0865762	-13.149657	110	3	1.12	0.95	94.1110	0.1938	0.0000	0.0000;
	959	1	0	0	0	0	1	1.0865744	-13.150678	110	3	1.12	0.95	94.1109	0.1941	0.0000	0.0000;
	960	1	0	0	0	0	1	1.0897863	-8.3511956	110	3	1.12	0.95	91.9812	0.0719	0.0000	0.0000;
	961	1	0.566	-0.972	0	0	1	1.0898015	-8.34631	110	3	1.12	0.95	91.9810	0.0716	0.0000	0.0000;
	962	1	2.948	-0.055	0	0	1	1.0811305	-13.778729	110	3	1.12	0.95	95.0796	0.1993	0.0000	0.0000;
	963	1	0	0	0	0	1	1.0811551	-13.771041	110	3	1.12	0.95	95.0756	0.1988	0.0000	0.0000;
	964	1	3.966	2.43	0	0	1	1.0992786	-12.913247	110	3	1.12	0.95	92.8126	0.2354	0.0000	0.0000;
	965	1	0	0	0	0	1	1.0993084	-12.917337	110	3	1.12	0.95	92.8138	0.2348	0.0000	0.0000;
	966	1	6.826	0.202	0	0	1	1.0795209	-15.039735	110	3	1.12	0.95	94.9509	0.2169	0.0000	0.0000;
	967	1	0	0	0	0	1	1.0795319	-15.036768	110	3	1.12	0.95	94.9492	0.2169	0.0000	0.0000;
	968	1	3.401	-0.15	0	0	1	1.0913859	-12.782707	110	3	1.12	0.95	93.3415	0.1088	0.0000	0.0000;
	969	1	4.537	-0.231	0	0	1	1.0913794	-12.78795	110	3	1.12	0.95	93.3429	0.1091	0.0000	0.0000;
	970	1	13.947	4.211	0	0	1	1.0940355	-11.785284	110	3	1.12	0.95	92.7571	0.0582	0.0000	0.0000;
	971	1	0	0	0	0	1	1.0940733	-11.775206	110	3	1.12	0.95	92.7553	0.0581	0.0000	0.0000;
	972	2	20.757	17.363	0	0	1	1.1011389	-10.576607	110	3	1.12	0.95	92.2123	0.0000	0.0000	0.0000;
	973	2	0	3.999	0	0	1	1.1003439	-10.729153	110	3	1.12	0.95	92.3394	0.0000	0.0000	0.0000;
	974	1	13.608	4.13	0	0	1	1.0800652	-15.057224	110	3	1.12	0.95	95.1492	0.1077	0.0000	0.0000;
	975	1	0	0	0	0	1	1.080068	-15.05322	110	3	1.12	0.95	95.1469	0.1076	0.0000	0.0000;
	976	1	20.398	7.289	0	0	1	1.1016474	-12.334034	110	3	1.12	0.95	92.2400	0.2894	0.0000	0.0000;
	977	2	0	0	0	0	1	1.1017834	-12.310584	110	3	1.12	0.95	92.2329	0.2875	0.0000	0.0000;
	978	1	9.864	2.753	0	0	1	1.0908748	-12.268325	110	3	1.12	0.95	93.2308	0.0593	0.0000	0.0000;
	979	1	0	0	0	0	1	1.0908734	-12.28162	110	3	1.12	0.95	93.2312	0.0586	0.0000	0.0000;
	980	1	1.36	-0.648	0	0	1	1.0801992	-10.582913	110	3	1.12	0.95	94.2292	-0.3168	0.0000	0.0000;
	981	1	0	0	0	0	1	1.0801987	-10.582857	110	3	1.12	0.95	94.2292	-0.3168	0.0000	0.0000;
	982	1	5.561	0.446	0	0	1	1.1006824	-10.553623	110	3	1.12	0.95	92.5521	-0.6035	0.0000	0.0000;
	983	1	0	0	0	0	1	1.1007277	-10.540436	110	3	1.12	0.95	92.5518	-0.6019	0.0000	0.0000;
	984	1	6.346	1.053	0	0	1	1.0917795	-12.157287	110	3	1.12	0.95	93.1759	-0.1004	0.0000	0.0000;
	985	1	6.006	1.458	0	0	1	1.0917633	-12.151242	110	3	1.12	0.95	93.1779	-0.1015	0.0000	0.0000;
	986	2	16.645	4.987	0	0	1	1.0822322	-15.266936	110	3	1.12	0.95	95.4434	0.1864	0.0000	0.0000;
	987	1	0	0	0	0	1	1.0822683	-15.250375	110	3	1.12	0.95	95.4409	0.1879	0.0000	0.0000;
	988	1	3.176	1.006	0	0	1	1.1008949	-10.46223	110	3	1.12	0.95	92.1405	0.0173	0.0000	0.0000;
	989	1	0	0	0	0	1	1.1009701	-10.456099	110	3	1.12	0.95	92.1345	0.0155	0.0000	0.0000;
	990	1	7.448	1.035	0	0	1	1.0785166	-14.625694	110	3	1.12	0.95	94.6110	0.0164	0.0000	0.0000;
	991	1	9.922	1.661	0	0	1	1.0784809	-14.637122	110	3	1.12	0.95	94.6153	0.0166	0.0000	0.0000;
	992	1	5.329	2.551	0	0	1	1.0890866	-11.979381	110	3	1.12	0.95	93.4239	0.2326	0.0000	0.0000;
	993	1	3.632	1.771	0	0	1	1.0985639	-10.798576	110	3	1.12	0.95	92.3662	0.0579	0.0000	0.0000;
	994	1	26.291	2.389	0	0	1	1.0792934	-14.599578	110	3	1.12	0.95	94.4696	0.0083	0.0000	0.0000;
	995	1	29.089	3.23	0	0	1	1.074212	-15.670174	110	3	1.12	0.95	95.3563	-0.0109	0.0000	0.0000;
	996	1	12.577	4.291	0	0	1	1.09711	-11.296951	110	3	1.12	0.95	92.3472	0.0258	0.0000	0.0000;
	997	1	0	0	0	0	1	1.0971727	-11.288396	110	3	1.12	0.95	92.3441	0.0249	0.0000	0.0000;
	998	2	28.198	54.86	0	0	1	1.1016481	-6.003408	110	3	1.12	0.95	90.0300	0.0000	0.0000	0.0000;
	999	2	22.533	51.62	0	0	1	1.1012428	-5.6615935	110	3	1.12	0.95	90.0300	-0.0000	0.0000	0.0000;
	1000	1	5.897	0.298	0	0	1	1.0862636	-9.0402283	110	3	1.12	0.95	92.7871	0.0403	0.0000	0.0000;
	1001	1	0	0	0	0	1	1.0862636	-9.0320653	110	3	1.12	0.95	92.7853	0.0401	0.0000	0.0000;
	1002	2	12.229	6.988	0	0	1	1.1018935	-12.384275	110	3	1.12	0.95	92.2917	0.2563	0.0000	0.0000;
	1003	2	0	0	0	0	1	1.1018881	-12.393548	110	3	1.12	0.95	92.2946	0.2562	0.0000	0.0000;
	1004	2	0	3.999	0	0	1	1.1018782	-10.364002	110	3	1.12	0.95	92.0394	0.0000	0.0000	0.0000;
	1005	1	0	0	0	0	1	1.1017744	-10.383729	110	3	1.12	0.95	92.0463	0.0011	0.0000	0.0000;
	1006	1	8.187	1.507	0	0	1	1.0662883	-16.674525	110	3	1.12	0.95	96.5443	-0.1054	0.0000	0.0000;
	1007	2	7.713	1.359	0	0	1	1.066241	-16.684775	110	3	1.12	0.95	96.5496	-0.1065	0.0000	0.0000;
	1008	1	3.52	0.944	0	0	1	1.0610512	-16.85752	110	3	1.12	0.95	96.1284	-0.4161	0.0000	0.0000;
	1009	1	0	0	0	0	1	1.0610602	-16.848395	110	3	1.12	0.95	96.1228	-0.4201	0.0000	0.0000;
	1010	2	0	0	0	0	1	1.0829786	-14.674009	110	3	1.12	0.95	94.6683	0.0754	0.0000	0.0000;
	1011	1	44.194	21.059	0	0	1	1.0730125	-15.657269	110	3	1.12	0.95	95.5479	0.3696	0.0000	0.0000;
	1012	2	0	0	0	0	1	1.0798511	-14.991815	110	3	1.12	0.95	94.9353	0.2023	0.0000	0.0000;
	1013	1	1.475	0.54	0	0	1	1.1068498	-9.7715796	110	3	1.12	0.95	91.9826	-0.5993	0.0000	0.0000;
	1014	1	0	0	0	0	1	1.1068532	-9.7714501	110	3	1.12	0.95	91.9823	-0.5994	0.0000	0.0000;
	1015	1	5.212	1.134	0	0	1	1.0887436	-11.883637	110	3	1.12	0.95	93.1056	0.0352	0.0000	0.0000;
	1016	1	7.592	2.106	0	0	1	1.0888084	-11.878838	110	3	1.12	0.95	93.1029	0.0350	0.0000	0.0000;
	1017	1	2.497	0.645	0	0	1	1.0439894	-17.316297	110	3	1.12	0.95	97.4624	-0.2025	0.0000	0.0000;
	1018	1	0	0	0	0	1	1.0440103	-17.31451	110	3	1.12	0.95	97.4602	-0.2030	0.0000	0.0000;
	1019	1	0	0.081	0	0	1	1.0954585	-11.448074	110	3	1.12	0.95	92.5290	0.0625	0.0000	0.0000;
	1020	1	0	0	0	0	1	1.0954602	-11.448102	110	3	1.12	0.95	92.5290	0.0624	0.0000	0.0000;
	1021	2	15.84	8.3	0	0	1	1.0799924	-16.053327	110	3	1.12	0.95	96.1434	-0.0386	0.0000	0.0000;
	1022	2	0	1.499	0	0	1	1.0800088	-16.048024	110	3	1.12	0.95	96.1425	-0.0389	0.0000	0.0000;
	1023	2	7.899	2.999	0	0	1	1.0799998	-16.053114	110	3	1.12	0.95	96.1437	-0.0388	0.0000	0.0000;
	1024	1	0	0	0	0	1	1.0760859	-16.230998	110	3	1.12	0.95	96.3237	0.1363	0.0000	0.0000;
	1025	1	5.893	1.458	0	0	1	1.0899162	-12.713153	110	3	1.12	0.95	93.3360	0.1846	0.0000	0.0000;
	1026	1	0	0	0	0	1	1.0899694	-12.708858	110	3	1.12	0.95	93.3306	0.1833	0.0000	0.0000;
	1027	1	0	0	0	0	1	1.1018785	-10.364006	110	3	1.12	0.95	92.0394	-0.0000	0.0000	0.0000;
	1028	1	0	0	0	0	1	1.1017746	-10.383733	110	3	1.12	0.95	92.0463	0.0011	0.0000	0.0000;
	1029	1	0	0	0	0	1	1.0929432	-11.635729	110	3	1.12	0.95	92.7948	-0.0844	0.0000	0.0000;
	1030	1	0	0	0	0	1	1.0929429	-11.635724	110	3	1.12	0.95	92.7948	-0.0844	0.0000	0.0000;
	1031	1	0	0	0	0	1	1.0998874	-10.631878	110	3	1.12	0.95	92.2294	0.0312	0.0000	0.0000;
	1032	1	0	0	0	0	1	1.0834574	-14.60333	110	3	1.12	0.95	94.7773	0.0567	0.0000	0.0000;
	1033	1	0	0	0	0	1	1.0834303	-14.595831	110	3	1.12	0.95	94.7774	0.0574	0.0000	0.0000;
	1034	1	0.225	0	0	0	1	1.1055989	-12.036236	110	3	1.12	0.95	91.9236	0.1681	0.0000	0.0000;
	1035	1	0	0	0	0	1	1.1055983	-12.037057	110	3	1.12	0.95	91.9238	0.1681	0.0000	0.0000;
	1036	1	2.72	0.648	0	0	1	1.096032	-11.350577	110	3	1.12	0.95	92.4592	0.0479	0.0000	0.0000;
	1037	1	0	0	0	0	1	1.0960565	-11.347765	110	3	1.12	0.95	92.4582	0.0476	0.0000	0.0000;
	1038	1	1.7	0.405	0	0	1	1.0933885	-11.484344	110	3	1.12	0.95	93.1510	0.1207	0.0000	0.0000;
	1039	1	0.566	0.405	0	0	1	1.0933836	-11.486127	110	3	1.12	0.95	93.1520	0.1207	0.0000	0.0000;
	1040	1	0	0	0	0	1	1.1055992	-12.036174	110	3	1.12	0.95	91.9235	0.1681	0.0000	0.0000;
	1041	1	0	0	0	0	1	1.1055983	-12.037057	110	3	1.12	0.95	91.9238	0.1681	0.0000	0.0000;
	1042	1	13.277	5.953	0	0	1	1.0864417	-12.315721	110	3	1.12	0.95	93.6805	0.2806	0.0000	0.0000;
	1043	1	0	0	0	0	1	1.0968439	-11.087147	110	3	1.12	0.95	92.5780	0.0815	0.0000	0.0000;
	1044	1	4.601	0.745	0	0	1	1.0753788	-16.105554	110	3	1.12	0.95	96.3363	0.2070	0.0000	0.0000;
	1045	1	0	0	0	0	1	1.0754771	-16.099952	110	3	1.12	0.95	96.3339	0.2038	0.0000	0.0000;
	1046	1	9.763	1.805	0	0	1	1.0834129	-14.612681	110	3	1.12	0.95	94.4406	0.2067	0.0000	0.0000;
	1047	1	9.195	1.805	0	0	1	1.0834827	-14.599963	110	3	1.12	0.95	94.4355	0.2071	0.0000	0.0000;
	1048	1	0.339	0.146	0	0	1	1.0869647	-12.187138	110	3	1.12	0.95	93.6206	-0.2088	0.0000	0.0000;
	1049	1	0	0	0	0	1	1.0869479	-12.185093	110	3	1.12	0.95	93.6197	-0.2079	0.0000	0.0000;
	1050	1	7.479	0.081	0	0	1	1.0914332	-8.2302876	110	3	1.12	0.95	91.6218	0.0700	0.0000	0.0000;
	1051	1	0	0	0	0	1	1.0909431	-8.3189519	110	3	1.12	0.95	91.7123	0.0874	0.0000	0.0000;
	1052	1	0.907	0.344	0	0	1	1.0904765	-11.416065	110	3	1.12	0.95	92.7254	0.0009	0.0000	0.0000;
	1053	1	0	0	0	0	1	1.090504	-11.415148	110	3	1.12	0.95	92.7221	-0.0002	0.0000	0.0000;
	1054	1	6.814	0.536	0	0	1	1.0831545	-10.009787	110	3	1.12	0.95	93.3399	-0.1448	0.0000	0.0000;
	1055	1	0	0	0	0	1	1.0831543	-10.014095	110	3	1.12	0.95	93.3431	-0.1450	0.0000	0.0000;
	1056	1	6.913	1.62	0	0	1	1.0911099	-12.687661	110	3	1.12	0.95	93.3212	0.0843	0.0000	0.0000;
	1057	1	7.139	1.053	0	0	1	1.0913439	-12.669371	110	3	1.12	0.95	93.3053	0.0776	0.0000	0.0000;
	1058	1	0	0	0	0	1	1.0954922	-11.383527	110	3	1.12	0.95	92.4983	0.0646	0.0000	0.0000;
	1059	1	9.405	2.349	0	0	1	1.095473	-11.385285	110	3	1.12	0.95	92.4989	0.0648	0.0000	0.0000;
	1060	1	2.054	0.561	0	0	1	1.0509576	-17.74852	110	3	1.12	0.95	96.9868	-0.3665	0.0000	0.0000;
	1061	1	0	0	0	0	1	1.0694555	-14.399702	110	3	1.12	0.95	96.9315	0.4206	0.0000	0.0000;
	1062	1	7.271	1.76	0	0	1	1.0694524	-14.395525	110	3	1.12	0.95	96.9314	0.4207	0.0000	0.0000;
	1063	1	0	0	0	0	1	1.0865065	-14.773546	110	3	1.12	0.95	94.8279	0.1916	0.0000	0.0000;
	1064	1	4.308	0.83	0	0	1	1.0865433	-14.756618	110	3	1.12	0.95	94.8253	0.1930	0.0000	0.0000;
	1065	1	1.021	0.373	0	0	1	1.0865046	-14.773512	110	3	1.12	0.95	94.8279	0.1917	0.0000	0.0000;
	1066	1	10.878	3.401	0	0	1	1.0860924	-8.7633508	110	3	1.12	0.95	92.2259	0.1974	0.0000	0.0000;
	1067	1	11.331	1.296	0	0	1	1.0861414	-8.7572759	110	3	1.12	0.95	92.2231	0.1966	0.0000	0.0000;
	1068	1	8.843	2.836	0	0	1	1.0923942	-11.67283	110	3	1.12	0.95	92.8384	0.1408	0.0000	0.0000;
	1069	1	0	0	0	0	1	1.0925079	-11.662031	110	3	1.12	0.95	92.8322	0.1394	0.0000	0.0000;
	1070	1	6.99	0.892	0	0	1	1.0752536	-15.245288	110	3	1.12	0.95	95.1665	0.0053	0.0000	0.0000;
	1071	1	5.887	0.336	0	0	1	1.0752491	-15.255412	110	3	1.12	0.95	95.1675	0.0050	0.0000	0.0000;
	1072	1	2.04	0.245	0	0	1	1.0962426	-7.0982731	110	3	1.12	0.95	90.7765	0.0565	0.0000	0.0000;
	1073	1	4.54	0.735	0	0	1	1.0962609	-7.0721692	110	3	1.12	0.95	90.7734	0.0559	0.0000	0.0000;
	1074	1	0	0	0	0	1	1.0551427	-18.265116	110	3	1.12	0.95	97.7022	-0.5092	0.0000	0.0000;
	1075	1	0	0	0	0	1	1.0551431	-18.260198	110	3	1.12	0.95	97.6987	-0.5103	0.0000	0.0000;
	1076	2	4.873	2.131	0	0	1	1.0851887	-9.6308654	110	3	1.12	0.95	92.8394	-0.0992	0.0000	0.0000;
	1077	1	3.403	0.278	0	0	1	1.085191	-9.6336418	110	3	1.12	0.95	92.8403	-0.0994	0.0000	0.0000;
	1078	1	9.65	1.972	0	0	1	1.0924386	-11.716506	110	3	1.12	0.95	92.8897	-0.0819	0.0000	0.0000;
	1079	1	0	0	0	0	1	1.0928034	-11.685164	110	3	1.12	0.95	92.8470	-0.0910	0.0000	0.0000;
	1080	1	0	0	0	0	1	1.0924724	-11.713677	110	3	1.12	0.95	92.8859	-0.0826	0.0000	0.0000;
	1081	1	0	0	0	0	1	1.0928028	-11.685155	110	3	1.12	0.95	92.8470	-0.0909	0.0000	0.0000;
	1082	1	4.085	0.214	0	0	1	1.0934258	-7.715964	110	3	1.12	0.95	91.2638	0.0649	0.0000	0.0000;
	1083	1	2.268	0.086	0	0	1	1.0934215	-7.7365152	110	3	1.12	0.95	91.2651	0.0653	0.0000	0.0000;
	1084	1	2.38	0.739	0	0	1	1.0626106	-16.098754	110	3	1.12	0.95	95.1975	-0.5323	0.0000	0.0000;
	1085	1	0	0	0	0	1	1.0626409	-16.104399	110	3	1.12	0.95	95.1991	-0.5321	0.0000	0.0000;
	1086	1	0.453	0	0	0	1	1.0961734	-12.033627	110	3	1.12	0.95	92.5552	0.1258	0.0000	0.0000;
	1087	1	0	0	0	0	1	1.0962443	-12.017976	110	3	1.12	0.95	92.5486	0.1258	0.0000	0.0000;
	1088	1	3.626	0.081	0	0	1	1.0909428	-8.3189427	110	3	1.12	0.95	91.7123	0.0875	0.0000	0.0000;
	1089	1	3.626	1.134	0	0	1	1.0915253	-8.2220065	110	3	1.12	0.95	91.6066	0.0698	0.0000	0.0000;
	1090	1	3.742	0.726	0	0	1	1.0656743	-15.609679	110	3	1.12	0.95	94.6891	-0.6064	0.0000	0.0000;
	1091	1	0	0	0	0	1	1.0658095	-15.60343	110	3	1.12	0.95	94.6697	-0.6100	0.0000	0.0000;
	1092	1	5.308	1.342	0	0	1	1.0513242	-18.121253	110	3	1.12	0.95	97.5627	-0.3864	0.0000	0.0000;
	1093	1	2.236	0.615	0	0	1	1.0512924	-18.118553	110	3	1.12	0.95	97.5621	-0.3886	0.0000	0.0000;
	1094	1	0	0	0	0	1	1.0995563	-12.537712	110	3	1.12	0.95	92.4569	0.3386	0.0000	0.0000;
	1095	1	0	0	0	0	1	1.1024676	-12.249879	110	3	1.12	0.95	92.1631	0.2705	0.0000	0.0000;
	1096	1	0	0	0	0	1	1.0995544	-12.537664	110	3	1.12	0.95	92.4569	0.3388	0.0000	0.0000;
	1097	1	0	0	0	0	1	1.1024666	-12.249862	110	3	1.12	0.95	92.1631	0.2706	0.0000	0.0000;
	1098	1	0	0	0	0	1	1.0935615	-11.387721	110	3	1.12	0.95	93.1838	-0.5743	0.0000	0.0000;
	1099	1	3.859	2.021	0	0	1	1.0935579	-11.391427	110	3	1.12	0.95	93.1805	-0.5746	0.0000	0.0000;
	1100	1	0	0	0	0	1	1.09941	-13.08645	110	3	1.12	0.95	92.9702	0.1773	0.0000	0.0000;
	1101	1	11.343	1.742	0	0	1	1.0884386	-12.913856	110	3	1.12	0.95	93.5902	0.1493	0.0000	0.0000;
	1102	1	0	0	0	0	1	1.0994065	-13.086392	110	3	1.12	0.95	92.9702	0.1775	0.0000	0.0000;
	1103	1	0	0	0	0	1	1.0887795	-12.877613	110	3	1.12	0.95	93.5501	0.1433	0.0000	0.0000;
	1104	1	0.226	0.204	0	0	1	1.0893181	-8.4809978	110	3	1.12	0.95	91.9722	0.0936	0.0000	0.0000;
	1105	1	0.453	-0.039	0	0	1	1.0893067	-8.4832029	110	3	1.12	0.95	91.9737	0.0938	0.0000	0.0000;
	1106	1	1.699	0.404	0	0	1	1.0957385	-11.560913	110	3	1.12	0.95	92.5772	0.0349	0.0000	0.0000;
	1107	1	0	0	0	0	1	1.0956841	-11.573057	110	3	1.12	0.95	92.5797	0.0352	0.0000	0.0000;
	1108	2	4.299	1.679	0	0	1	1.0806321	-10.433898	110	3	1.12	0.95	94.0010	-0.2170	0.0000	0.0000;
	1109	1	3.629	0.629	0	0	1	1.0670211	-14.801148	110	3	1.12	0.95	97.4049	0.3841	0.0000	0.0000;
	1110	2	2.493	1.62	0	0	1	1.0948523	-11.395577	110	3	1.12	0.95	93.0706	0.0685	0.0000	0.0000;
	1111	2	6.908	9.376	0	0	1	1.0916578	-12.635785	110	3	1.12	0.95	93.2673	0.0724	0.0000	0.0000;
	1112	2	0	0	0	0	1	1.0996324	-13.043641	110	3	1.12	0.95	92.9253	0.1796	0.0000	0.0000;
	1113	1	3.629	0.974	0	0	1	1.0972649	-7.0698349	110	3	1.12	0.95	90.6087	0.0639	0.0000	0.0000;
	1114	2	8.148	2.119	0	0	1	1.0972233	-7.090619	110	3	1.12	0.95	90.6134	0.0648	0.0000	0.0000;
	1115	1	10.27	0.012	0	0	1	1.0636456	-16.007359	110	3	1.12	0.95	96.3445	1.2103	0.0000	0.0000;
	1116	1	0	0	0	0	1	1.0638237	-15.98359	110	3	1.12	0.95	96.3311	1.2075	0.0000	0.0000;
	1117	1	11.785	-1.053	0	0	1	1.0566662	-17.699331	110	3	1.12	0.95	97.9330	-0.2190	0.0000	0.0000;
	1118	1	0.679	0	0	0	1	1.0567485	-17.680758	110	3	1.12	0.95	97.9230	-0.2146	0.0000	0.0000;
	1119	1	0	0	0	0	1	1.0908943	-11.751176	110	3	1.12	0.95	92.9431	-0.0220	0.0000	0.0000;
	1120	1	0	0	0	0	1	1.0908929	-11.751144	110	3	1.12	0.95	92.9431	-0.0219	0.0000	0.0000;
	1121	1	7.025	0.08	0	0	1	1.0935126	-11.391504	110	3	1.12	0.95	93.1956	-0.5755	0.0000	0.0000;
	1122	1	0	0	0	0	1	1.0935539	-11.394396	110	3	1.12	0.95	93.1794	-0.5747	0.0000	0.0000;
	1123	1	0	0	0	0	1	1.0935936	-11.384311	110	3	1.12	0.95	93.1822	-0.5756	0.0000	0.0000;
	1124	1	0	0	0	0	1	1.0935537	-11.39439	110	3	1.12	0.95	93.1794	-0.5747	0.0000	0.0000;
	1125	1	2.719	0.08	0	0	1	1.0929611	-11.480951	110	3	1.12	0.95	93.2444	-0.5698	0.0000	0.0000;
	1126	1	0	0	0	0	1	1.0935038	-11.417722	110	3	1.12	0.95	93.1730	-0.5739	0.0000	0.0000;
	1127	1	0	0	0	0	1	1.092981	-11.477956	110	3	1.12	0.95	93.2413	-0.5698	0.0000	0.0000;
	1128	1	0	0	0	0	1	1.0935038	-11.417722	110	3	1.12	0.95	93.1730	-0.5739	0.0000	0.0000;
	1129	2	3.637	0.574	0	0	1	1.1013864	-11.508328	110	3	1.12	0.95	92.3936	-0.4891	0.0000	0.0000;
	1130	1	9.078	0.471	0	0	1	1.0927503	-11.496484	110	3	1.12	0.95	93.2772	-0.5681	0.0000	0.0000;
	1131	1	32.665	1.557	0	0	1	1.0926788	-11.529733	110	3	1.12	0.95	93.3238	-0.5784	0.0000	0.0000;
	1132	1	0	0	0	0	1	1.0926895	-11.525247	110	3	1.12	0.95	93.3209	-0.5785	0.0000	0.0000;
	1133	1	5.217	1.003	0	0	1	1.0939806	-11.966706	110	3	1.12	0.95	93.4603	-0.3772	0.0000	0.0000;
	1134	1	0	0	0	0	1	1.0939692	-11.971489	110	3	1.12	0.95	93.4599	-0.3773	0.0000	0.0000;
	1135	1	4.986	0.972	0	0	1	1.1010154	-10.588304	110	3	1.12	0.95	92.2254	0.0025	0.0000	0.0000;
	1136	1	30.595	6.48	0	0	1	1.1036119	-12.885784	110	3	1.12	0.95	92.7287	0.0230	0.0000	0.0000;
	1137	1	0	0	0	0	1	1.0980686	-11.094535	110	3	1.12	0.95	92.8398	0.0151	0.0000	0.0000;
	1138	1	97.453	27.538	0	0	1	1.0953941	-11.306108	110	3	1.12	0.95	93.0821	0.0852	0.0000	0.0000;
	1139	1	0	0	0	0	1	1.0980685	-11.094534	110	3	1.12	0.95	92.8398	0.0151	0.0000	0.0000;
	1140	1	0	0	0	0	1	1.1038041	-12.868014	110	3	1.12	0.95	92.7094	0.0189	0.0000	0.0000;
	1141	1	0	0	0	0	1	1.0969948	-11.172108	110	3	1.12	0.95	92.9445	0.0460	0.0000	0.0000;
	1142	1	11.784	3.644	0	0	1	1.087946	-12.976172	110	3	1.12	0.95	93.6968	0.1332	0.0000	0.0000;
	1143	1	22.664	0	0	0	1	1.0879613	-12.977645	110	3	1.12	0.95	93.6963	0.1333	0.0000	0.0000;
	1144	1	0	0	0	0	1	1.0879992	-12.969083	110	3	1.12	0.95	93.6941	0.1324	0.0000	0.0000;
	1145	1	0	0	0	0	1	1.091873	-12.125579	110	3	1.12	0.95	93.1619	-0.1062	0.0000	0.0000;
	1146	1	1.7	1.053	0	0	1	1.0923635	-11.91135	110	3	1.12	0.95	93.0539	-0.1581	0.0000	0.0000;
	1147	1	1.699	0	0	0	1	1.0916832	-9.3564327	110	3	1.12	0.95	91.5222	-0.0738	0.0000	0.0000;
	1148	1	5.666	1.296	0	0	1	1.0917357	-9.370204	110	3	1.12	0.95	91.5115	-0.0745	0.0000	0.0000;
	1149	1	1.7	0.729	0	0	1	1.0948681	-11.325034	110	3	1.12	0.95	92.9498	0.1030	0.0000	0.0000;
	1150	1	1.473	0.324	0	0	1	1.0948986	-11.317196	110	3	1.12	0.95	92.9477	0.1027	0.0000	0.0000;
	1151	2	26.498	6.471	0	0	1	1.0745332	-15.037492	110	3	1.12	0.95	95.1794	0.0719	0.0000	0.0000;
	1152	2	22.654	5.554	0	0	1	1.0748797	-15.010371	110	3	1.12	0.95	95.1281	0.0672	0.0000	0.0000;
	1153	2	31.791	7.897	0	0	1	1.0736978	-15.186369	110	3	1.12	0.95	95.0234	0.0510	0.0000	0.0000;
	1154	1	9.658	2.688	0	0	1	1.0748594	-15.048338	110	3	1.12	0.95	95.1594	0.0492	0.0000	0.0000;
	1155	1	4.829	1.344	0	0	1	1.0748388	-15.047109	110	3	1.12	0.95	95.1605	0.0499	0.0000	0.0000;
	1156	1	7.359	3.777	0	0	1	1.0755442	-15.03562	110	3	1.12	0.95	95.0944	0.0142	0.0000	0.0000;
	1157	1	14.064	4.219	0	0	1	1.0763617	-14.895697	110	3	1.12	0.95	94.6381	0.0439	0.0000	0.0000;
	1158	1	11.832	2.972	0	0	1	1.0741722	-15.167807	110	3	1.12	0.95	94.9736	0.0308	0.0000	0.0000;
	1159	1	14.683	3.644	0	0	1	1.0746863	-15.034257	110	3	1.12	0.95	95.1702	0.0627	0.0000	0.0000;
	1160	1	0	0	0	0	1	1.0743522	-15.156279	110	3	1.12	0.95	94.9527	0.0255	0.0000	0.0000;
	1161	1	13.747	5.961	0	0	1	1.0765939	-14.873836	110	3	1.12	0.95	94.6130	0.0389	0.0000	0.0000;
	1162	1	6.202	0.504	0	0	1	1.0757969	-15.026712	110	3	1.12	0.95	95.0817	0.0037	0.0000	0.0000;
	1163	1	3.865	1.076	0	0	1	1.0753925	-15.033569	110	3	1.12	0.95	95.1110	0.0224	0.0000	0.0000;
	1164	1	3.865	1.076	0	0	1	1.0754355	-15.032282	110	3	1.12	0.95	95.1085	0.0212	0.0000	0.0000;
	1165	1	6.017	1.73	0	0	1	1.0742501	-15.215686	110	3	1.12	0.95	95.0066	0.0175	0.0000	0.0000;
	1166	2	0	0	0	0	1	1.0754205	-15.044087	110	3	1.12	0.95	94.7975	0.0251	0.0000	0.0000;
	1167	1	0	0	0	0	1	1.074272	-15.214417	110	3	1.12	0.95	95.0042	0.0168	0.0000	0.0000;
	1168	1	0	0	0	0	1	1.0754159	-15.044369	110	3	1.12	0.95	94.7981	0.0252	0.0000	0.0000;
	1169	1	3.286	0.81	0	0	1	1.102276	-12.325933	110	3	1.12	0.95	92.1533	0.2678	0.0000	0.0000;
	1170	1	0.34	0.081	0	0	1	1.1024386	-12.293765	110	3	1.12	0.95	92.1475	0.2657	0.0000	0.0000;
	1171	1	1.133	0.162	0	0	1	1.0862254	-12.996041	110	3	1.12	0.95	93.9750	0.1845	0.0000	0.0000;
	1172	1	0	0	0	0	1	1.0862265	-12.995816	110	3	1.12	0.95	93.9750	0.1844	0.0000	0.0000;
	1173	1	0.453	0.081	0	0	1	1.0882037	-13.611537	110	3	1.12	0.95	94.0028	0.0415	0.0000	0.0000;
	1174	1	0	0	0	0	1	1.0882096	-13.610877	110	3	1.12	0.95	94.0021	0.0414	0.0000	0.0000;
	1175	1	0	0	0	0	1	1.0862473	-12.988209	110	3	1.12	0.95	93.9672	0.1857	0.0000	0.0000;
	1176	1	6.351	1.903	0	0	1	1.0800945	-15.068179	110	3	1.12	0.95	95.0824	0.1440	0.0000	0.0000;
	1177	1	3.741	1.579	0	0	1	1.0892707	-13.354018	110	3	1.12	0.95	93.8552	0.0490	0.0000	0.0000;
	1178	2	9.626	9.053	0	0	1	1.0971655	-11.401673	110	3	1.12	0.95	92.4216	0.0000	0.0000	0.0000;
	1179	2	11.426	12.41	0	0	1	1.0925614	-12.817864	110	3	1.12	0.95	93.4632	-0.0000	0.0000	0.0000;
	1180	1	1.724	0.478	0	0	1	1.059591	-17.68296	110	3	1.12	0.95	98.0418	0.0516	0.0000	0.0000;
	1181	1	0.895	0.324	0	0	1	1.0595673	-17.680837	110	3	1.12	0.95	98.0445	0.0526	0.0000	0.0000;
	1182	1	0	0	0	0	1	1.0938539	-11.840879	110	3	1.12	0.95	92.7952	0.0516	0.0000	0.0000;
	1183	1	0	0	0	0	1	1.0938539	-11.840879	110	3	1.12	0.95	92.7952	0.0516	0.0000	0.0000;
	1184	1	12.465	4.049	0	0	1	1.0944749	-12.874407	110	3	1.12	0.95	93.0625	0.4775	0.0000	0.0000;
	1185	1	10.199	2.43	0	0	1	1.0943732	-12.897923	110	3	1.12	0.95	93.0655	0.4785	0.0000	0.0000;
	1186	1	101.987	30.777	0	0	1	1.0329513	-14.773651	110	3	1.12	0.95	93.4847	0.2120	0.0000	0.0000;
	1187	2	88.369	41.289	0	0	1	1.0902811	-11.779433	110	3	1.12	0.95	93.0372	0.2009	0.0000	0.0000;
	1188	2	0	0	0	0	1	1.0956506	-11.358707	110	3	1.12	0.95	92.4734	0.0639	0.0000	0.0000;
	1189	1	3.404	1.342	0	0	1	1.099634	-10.648819	110	3	1.12	0.95	92.2487	0.0385	0.0000	0.0000;
	1190	1	0	0	0	0	1	1.0956419	-11.361472	110	3	1.12	0.95	92.4734	0.0639	0.0000	0.0000;
	1191	1	2.837	0.585	0	0	1	1.0754414	-14.931218	110	3	1.12	0.95	95.5063	0.2401	0.0000	0.0000;
	1192	1	0	0	0	0	1	1.075585	-14.916891	110	3	1.12	0.95	95.4899	0.2371	0.0000	0.0000;
	1193	1	18.585	12.878	0	0	1	1.0843173	-14.014226	110	3	1.12	0.95	94.1430	0.6769	0.0000	0.0000;
	1194	1	0	0	0	0	1	1.0844016	-14.00915	110	3	1.12	0.95	94.1403	0.6753	0.0000	0.0000;
	1195	1	0	0	0	0	1	1.0844558	-14.042123	110	3	1.12	0.95	94.1532	0.6639	0.0000	0.0000;
	1196	1	1.7	0.527	0	0	1	1.0861719	-14.161899	110	3	1.12	0.95	94.0836	0.5804	0.0000	0.0000;
	1197	1	0.566	0.121	0	0	1	1.0863484	-14.175879	110	3	1.12	0.95	94.0563	0.5752	0.0000	0.0000;
	1198	1	0	0	0	0	1	1.0861959	-14.16042	110	3	1.12	0.95	94.0811	0.5797	0.0000	0.0000;
	1199	1	0	0	0	0	1	1.0863551	-14.175359	110	3	1.12	0.95	94.0554	0.5751	0.0000	0.0000;
	1200	1	2.72	0.308	0	0	1	1.0801457	-15.029757	110	3	1.12	0.95	94.9935	0.1698	0.0000	0.0000;
	1201	1	0	0	0	0	1	1.0801497	-15.030829	110	3	1.12	0.95	94.9953	0.1695	0.0000	0.0000;
	1202	1	2.267	0.486	0	0	1	1.1018537	-10.366597	110	3	1.12	0.95	92.0417	0.0005	0.0000	0.0000;
	1203	1	2.609	0.678	0	0	1	1.086797	-12.429415	110	3	1.12	0.95	94.0991	-0.6983	0.0000	0.0000;
	1204	1	0	0	0	0	1	1.0868092	-12.440952	110	3	1.12	0.95	94.0955	-0.7006	0.0000	0.0000;
	1205	1	2.833	0.648	0	0	1	1.0903557	-11.577308	110	3	1.12	0.95	92.8313	0.0042	0.0000	0.0000;
	1206	1	0	0	0	0	1	1.0903711	-11.579761	110	3	1.12	0.95	92.8309	0.0046	0.0000	0.0000;
	1207	1	0.226	0.081	0	0	1	1.0799935	-14.97664	110	3	1.12	0.95	94.8703	0.2164	0.0000	0.0000;
	1208	1	0	0	0	0	1	1.0800038	-14.973577	110	3	1.12	0.95	94.8685	0.2164	0.0000	0.0000;
	1209	1	13.05	4.161	0	0	1	1.0806059	-14.936893	110	3	1.12	0.95	94.9921	0.1170	0.0000	0.0000;
	1210	1	0	0	0	0	1	1.0806482	-14.927754	110	3	1.12	0.95	94.9880	0.1163	0.0000	0.0000;
	1211	1	2.836	-1.651	0	0	1	1.1015449	-10.533849	110	3	1.12	0.95	92.8364	-0.8631	0.0000	0.0000;
	1212	1	0	0	0	0	1	1.1015442	-10.531789	110	3	1.12	0.95	92.8374	-0.8614	0.0000	0.0000;
	1213	1	3.315	0.777	0	0	1	1.0581582	-17.302977	110	3	1.12	0.95	98.0740	0.2764	0.0000	0.0000;
	1214	1	2.146	0.577	0	0	1	1.0581369	-17.299057	110	3	1.12	0.95	98.0760	0.2775	0.0000	0.0000;
	1215	1	5.668	1.742	0	0	1	1.0883743	-11.621633	110	3	1.12	0.95	92.9496	0.0499	0.0000	0.0000;
	1216	1	0	0	0	0	1	1.0883981	-11.620778	110	3	1.12	0.95	92.9467	0.0490	0.0000	0.0000;
	1217	1	5.668	1.094	0	0	1	1.0943081	-11.533799	110	3	1.12	0.95	92.6542	0.0860	0.0000	0.0000;
	1218	1	2.947	0.688	0	0	1	1.0936489	-11.898287	110	3	1.12	0.95	92.8364	0.0451	0.0000	0.0000;
	1219	1	1.258	0.429	0	0	1	1.0765741	-15.694887	110	3	1.12	0.95	95.6580	0.2120	0.0000	0.0000;
	1220	1	0	0	0	0	1	1.0765964	-15.702912	110	3	1.12	0.95	95.6631	0.2125	0.0000	0.0000;
	1221	1	3.97	1.287	0	0	1	1.0871484	-12.222637	110	3	1.12	0.95	93.6521	-0.2362	0.0000	0.0000;
	1222	1	6.236	2.002	0	0	1	1.0883249	-12.026797	110	3	1.12	0.95	93.5125	-0.2404	0.0000	0.0000;
	1223	1	5.881	1.235	0	0	1	1.0764816	-15.896226	110	3	1.12	0.95	95.6030	-0.1093	0.0000	0.0000;
	1224	1	0	0	0	0	1	1.0764398	-15.901867	110	3	1.12	0.95	95.6035	-0.1072	0.0000	0.0000;
	1225	1	7.246	0.787	0	0	1	1.0571594	-18.302473	110	3	1.12	0.95	98.6199	-0.1532	0.0000	0.0000;
	1226	2	6.144	0.213	0	0	1	1.0579974	-18.233967	110	3	1.12	0.95	98.5016	-0.1738	0.0000	0.0000;
	1227	1	0	0	0	0	1	1.0577572	-18.267632	110	3	1.12	0.95	98.5219	-0.1633	0.0000	0.0000;
	1228	1	0	0	0	0	1	1.0582088	-18.214701	110	3	1.12	0.95	98.4643	-0.1749	0.0000	0.0000;
	1229	1	6.576	3.036	0	0	1	1.0966871	-11.029424	110	3	1.12	0.95	92.7015	0.0864	0.0000	0.0000;
	1230	1	0	0	0	0	1	1.0966733	-11.036704	110	3	1.12	0.95	92.7040	0.0864	0.0000	0.0000;
	1231	1	0	0	0	0	1	1.0998862	-10.631859	110	3	1.12	0.95	92.2294	0.0313	0.0000	0.0000;
	1232	1	0	0	0	0	1	1.0962872	-11.331087	110	3	1.12	0.95	92.4394	0.0413	0.0000	0.0000;
	1233	1	7.37	1.661	0	0	1	1.0930675	-11.392205	110	3	1.12	0.95	93.2567	-0.6067	0.0000	0.0000;
	1234	1	10.433	1.985	0	0	1	1.0930636	-11.396588	110	3	1.12	0.95	93.2551	-0.6046	0.0000	0.0000;
	1235	1	4.421	1.539	0	0	1	1.0929177	-11.628369	110	3	1.12	0.95	92.7777	0.1228	0.0000	0.0000;
	1236	1	0	0	0	0	1	1.0930141	-11.617122	110	3	1.12	0.95	92.7735	0.1219	0.0000	0.0000;
	1237	1	0	0	0	0	1	1.0910885	-11.647972	110	3	1.12	0.95	92.8333	0.0011	0.0000	0.0000;
	1238	1	0	0	0	0	1	1.0910885	-11.647972	110	3	1.12	0.95	92.8333	0.0011	0.0000	0.0000;
	1239	1	4.274	0.821	0	0	1	1.071935	-15.767742	110	3	1.12	0.95	95.7421	0.3788	0.0000	0.0000;
	1240	1	0	0	0	0	1	1.0719291	-15.776827	110	3	1.12	0.95	95.7440	0.3794	0.0000	0.0000;
	1241	1	5.227	0.472	0	0	1	1.095291	-11.139693	110	3	1.12	0.95	93.0507	-0.6530	0.0000	0.0000;
	1242	1	0	0	0	0	1	1.095292	-11.132492	110	3	1.12	0.95	93.0557	-0.6560	0.0000	0.0000;
	1243	1	6.915	0.979	0	0	1	1.0499366	-16.466908	110	3	1.12	0.95	96.9178	-0.2905	0.0000	0.0000;
	1244	1	0	0	0	0	1	1.0499324	-16.482761	110	3	1.12	0.95	96.9094	-0.2919	0.0000	0.0000;
	1245	2	73.873	32.712	0	0	1	1.0836078	-12.974827	110	3	1.12	0.95	93.6277	0.4402	0.0000	0.0000;
	1246	2	52.114	15.377	0	0	1	1.0929945	-12.317628	110	3	1.12	0.95	92.8382	0.1751	0.0000	0.0000;
	1247	2	23.334	5.858	0	0	1	1.0720536	-16.024286	110	3	1.12	0.95	96.1691	0.3182	0.0000	0.0000;
	1248	1	0	0	0	0	1	1.0721194	-16.023651	110	3	1.12	0.95	96.1705	0.3182	0.0000	0.0000;
	1249	1	1.586	0.405	0	0	1	1.0913566	-12.64815	110	3	1.12	0.95	93.2888	0.0813	0.0000	0.0000;
	1250	1	7.139	1.053	0	0	1	1.0948429	-11.376647	110	3	1.12	0.95	93.0553	0.0745	0.0000	0.0000;
	1251	1	0	0	0	0	1	1.0913787	-12.647231	110	3	1.12	0.95	93.2859	0.0806	0.0000	0.0000;
	1252	1	0	0	0	0	1	1.0949046	-11.372221	110	3	1.12	0.95	93.0471	0.0733	0.0000	0.0000;
	1253	1	0	0	0	0	1	1.0630343	-15.801362	110	3	1.12	0.95	94.9001	-0.4962	0.0000	0.0000;
	1254	1	0	0	0	0	1	1.0606075	-16.022447	110	3	1.12	0.95	95.1336	-0.4254	0.0000	0.0000;
	1255	1	6.459	0.972	0	0	1	1.0803575	-13.961055	110	3	1.12	0.95	94.7938	0.1299	0.0000	0.0000;
	1256	1	0	0	0	0	1	1.0803699	-13.958474	110	3	1.12	0.95	94.7929	0.1298	0.0000	0.0000;
	1257	1	5.562	0.522	0	0	1	1.1056819	-12.018005	110	3	1.12	0.95	91.9045	0.1698	0.0000	0.0000;
	1258	1	0	0	0	0	1	1.1056894	-12.014893	110	3	1.12	0.95	91.9034	0.1698	0.0000	0.0000;
	1259	1	0.34	0.122	0	0	1	1.0943199	-11.532069	110	3	1.12	0.95	92.6536	0.0858	0.0000	0.0000;
	1260	1	0	0	0	0	1	1.0943392	-11.530829	110	3	1.12	0.95	92.6512	0.0853	0.0000	0.0000;
	1261	1	0	0	0	0	1	1.0988091	-10.64461	110	3	1.12	0.95	92.6849	-0.9569	0.0000	0.0000;
	1262	1	0	0	0	0	1	1.0988918	-10.634026	110	3	1.12	0.95	92.6817	-0.9610	0.0000	0.0000;
	1263	1	0.794	0.159	0	0	1	1.0954077	-11.800353	110	3	1.12	0.95	92.8622	-0.2804	0.0000	0.0000;
	1264	1	0	0	0	0	1	1.0954455	-11.797711	110	3	1.12	0.95	92.8611	-0.2810	0.0000	0.0000;
	1265	1	4.54	1.061	0	0	1	1.0818743	-9.8976568	110	3	1.12	0.95	93.7593	0.0038	0.0000	0.0000;
	1266	1	3.29	0.849	0	0	1	1.0819731	-9.9061613	110	3	1.12	0.95	93.7535	0.0035	0.0000	0.0000;
	1267	1	5.666	1.296	0	0	1	1.0905926	-12.665518	110	3	1.12	0.95	93.3135	0.1467	0.0000	0.0000;
	1268	1	3.853	0.081	0	0	1	1.0993942	-13.088494	110	3	1.12	0.95	92.9722	0.1775	0.0000	0.0000;
	1269	1	10.652	3.401	0	0	1	1.0887137	-12.882603	110	3	1.12	0.95	93.5556	0.1450	0.0000	0.0000;
	1270	1	0	0	0	0	1	1.0909864	-12.643339	110	3	1.12	0.95	93.2642	0.1359	0.0000	0.0000;
	1271	1	7.042	2.005	0	0	1	1.0910003	-11.744867	110	3	1.12	0.95	93.4838	-0.5435	0.0000	0.0000;
	1272	1	0	0	0	0	1	1.0913649	-11.714886	110	3	1.12	0.95	93.4516	-0.5525	0.0000	0.0000;
	1273	1	0	0	0	0	1	1.0750576	-15.658297	110	3	1.12	0.95	95.3216	-0.0770	0.0000	0.0000;
	1274	1	0	0	0	0	1	1.0750575	-15.658295	110	3	1.12	0.95	95.3216	-0.0769	0.0000	0.0000;
	1275	1	7.369	1.741	0	0	1	1.0949531	-11.265848	110	3	1.12	0.95	92.8705	0.1171	0.0000	0.0000;
	1276	1	0	0	0	0	1	1.095094	-11.239249	110	3	1.12	0.95	92.8630	0.1155	0.0000	0.0000;
	1277	1	8.504	1.857	0	0	1	1.0829985	-13.036948	110	3	1.12	0.95	94.6142	-0.7841	0.0000	0.0000;
	1278	1	0	0	0	0	1	1.0830032	-13.028859	110	3	1.12	0.95	94.6164	-0.7826	0.0000	0.0000;
	1279	2	18.928	3.872	0	0	1	1.0957924	-13.387489	110	3	1.12	0.95	93.2860	0.2753	0.0000	0.0000;
	1280	1	0	0	0	0	1	1.0958582	-13.380861	110	3	1.12	0.95	93.2778	0.2739	0.0000	0.0000;
	1281	1	9.64	2.146	0	0	1	1.087047	-13.041638	110	3	1.12	0.95	93.7355	0.1869	0.0000	0.0000;
	1282	1	0	0	0	0	1	1.0870527	-13.041844	110	3	1.12	0.95	93.7366	0.1863	0.0000	0.0000;
	1283	1	2.267	0.648	0	0	1	1.0768736	-14.764943	110	3	1.12	0.95	95.3331	0.2044	0.0000	0.0000;
	1284	1	5.257	1.582	0	0	1	1.0760818	-16.230926	110	3	1.12	0.95	96.3237	0.1365	0.0000	0.0000;
	1285	2	10.037	7.677	0	0	1	1.0787624	-15.944666	110	3	1.12	0.95	96.1059	0.0438	0.0000	0.0000;
	1286	2	17.999	41.999	0	0	1	1.098349	-13.165696	110	3	1.12	0.95	92.7800	0.0000	0.0000	0.0000;
	1287	2	11.999	35.999	0	0	1	1.0988083	-11.028192	110	3	1.12	0.95	92.7800	0.0000	0.0000	0.0000;
	1288	1	0.907	0.024	0	0	1	1.0765822	-15.478807	110	3	1.12	0.95	95.0906	-0.1225	0.0000	0.0000;
	1289	1	1.927	0.101	0	0	1	1.0765537	-15.477738	110	3	1.12	0.95	95.0918	-0.1225	0.0000	0.0000;
	1290	1	0	0	0	0	1	1.0794681	-10.477055	110	3	1.12	0.95	94.5133	0.0362	0.0000	0.0000;
	1291	1	4.544	0.599	0	0	1	1.0794379	-10.472835	110	3	1.12	0.95	94.5153	0.0345	0.0000	0.0000;
	1292	1	1.473	0.134	0	0	1	1.0847853	-12.682481	110	3	1.12	0.95	94.0881	-0.4554	0.0000	0.0000;
	1293	1	0	0	0	0	1	1.084788	-12.689877	110	3	1.12	0.95	94.0897	-0.4592	0.0000	0.0000;
	1294	1	5.666	0.324	0	0	1	1.0931675	-11.523103	110	3	1.12	0.95	93.2066	0.1164	0.0000	0.0000;
	1295	1	7.253	2.916	0	0	1	1.0931744	-11.521637	110	3	1.12	0.95	93.2066	0.1163	0.0000	0.0000;
	1296	2	3.391	0.282	0	0	1	1.0845216	-8.9234178	110	3	1.12	0.95	92.4920	0.2041	0.0000	0.0000;
	1297	1	5.331	0.424	0	0	1	1.0845307	-8.9221197	110	3	1.12	0.95	92.4918	0.2040	0.0000	0.0000;
	1298	1	9.656	3.756	0	0	1	1.0859018	-12.939089	110	3	1.12	0.95	93.9697	0.2050	0.0000	0.0000;
	1299	1	0	0	0	0	1	1.0859526	-12.943433	110	3	1.12	0.95	93.9668	0.2042	0.0000	0.0000;
	1300	1	2.949	-0.379	0	0	1	1.091389	-12.044803	110	3	1.12	0.95	93.3824	-0.1762	0.0000	0.0000;
	1301	1	2.385	0.502	0	0	1	1.0913858	-12.046357	110	3	1.12	0.95	93.3837	-0.1761	0.0000	0.0000;
	1302	1	13.348	-1.61	0	0	1	1.0582117	-18.593858	110	3	1.12	0.95	98.2554	-0.3915	0.0000	0.0000;
	1303	1	0	0	0	0	1	1.0581986	-18.592478	110	3	1.12	0.95	98.2539	-0.3932	0.0000	0.0000;
	1304	1	7.282	-0.99	0	0	1	1.0544122	-18.67002	110	3	1.12	0.95	97.9744	-0.5955	0.0000	0.0000;
	1305	1	2.54	-0.536	0	0	1	1.0544112	-18.668207	110	3	1.12	0.95	97.9754	-0.5951	0.0000	0.0000;
	1306	1	2.766	0.76	0	0	1	1.0816427	-14.032411	110	3	1.12	0.95	94.5099	0.0072	0.0000	0.0000;
	1307	1	1.736	0.491	0	0	1	1.0816305	-14.040115	110	3	1.12	0.95	94.5085	0.0066	0.0000	0.0000;
	1308	1	0	0	0	0	1	1.0898156	-11.812624	110	3	1.12	0.95	93.0210	0.0114	0.0000	0.0000;
	1309	1	0	0	0	0	1	1.0898128	-11.812543	110	3	1.12	0.95	93.0210	0.0117	0.0000	0.0000;
	1310	1	2.155	0.241	0	0	1	1.0902736	-12.293716	110	3	1.12	0.95	93.9495	-0.3147	0.0000	0.0000;
	1311	1	0	0	0	0	1	1.0902726	-12.294806	110	3	1.12	0.95	93.9498	-0.3147	0.0000	0.0000;
	1312	1	11.051	4.582	0	0	1	1.0789904	-15.461486	110	3	1.12	0.95	95.6066	0.2269	0.0000	0.0000;
	1313	1	0	0	0	0	1	1.0789848	-15.477983	110	3	1.12	0.95	95.6105	0.2263	0.0000	0.0000;
	1314	1	0.793	0.31	0	0	1	1.0961945	-11.385918	110	3	1.12	0.95	92.4501	0.0457	0.0000	0.0000;
	1315	1	0	0	0	0	1	1.0962172	-11.382146	110	3	1.12	0.95	92.4486	0.0453	0.0000	0.0000;
	1316	1	11.898	3.401	0	0	1	1.0909854	-12.610353	110	3	1.12	0.95	93.2157	0.1665	0.0000	0.0000;
	1317	1	0	0	0	0	1	1.0910163	-12.608256	110	3	1.12	0.95	93.2127	0.1656	0.0000	0.0000;
	1318	1	0	0	0	0	1	1.0940199	-11.950292	110	3	1.12	0.95	93.0441	0.0707	0.0000	0.0000;
	1319	1	0	0	0	0	1	1.0869145	-12.486847	110	3	1.12	0.95	93.7384	0.2319	0.0000	0.0000;
	1320	1	0	0	0	0	1	1.0940158	-11.950181	110	3	1.12	0.95	93.0441	0.0711	0.0000	0.0000;
	1321	1	0	0	0	0	1	1.0869105	-12.486736	110	3	1.12	0.95	93.7384	0.2322	0.0000	0.0000;
	1322	1	7.253	1.62	0	0	1	1.0971782	-13.213253	110	3	1.12	0.95	93.0747	0.2655	0.0000	0.0000;
	1323	1	3.853	0.648	0	0	1	1.0971595	-13.218207	110	3	1.12	0.95	93.0769	0.2656	0.0000	0.0000;
	1324	1	1.133	0.162	0	0	1	1.0923846	-12.435093	110	3	1.12	0.95	92.9828	0.1626	0.0000	0.0000;
	1325	1	0	0	0	0	1	1.0862873	-12.85645	110	3	1.12	0.95	93.4870	0.3360	0.0000	0.0000;
	1326	1	0	0	0	0	1	1.0923914	-12.4345	110	3	1.12	0.95	92.9819	0.1625	0.0000	0.0000;
	1327	1	0	0	0	0	1	1.0862873	-12.856448	110	3	1.12	0.95	93.4870	0.3360	0.0000	0.0000;
	1328	1	4.039	0.464	0	0	1	1.0742986	-15.599186	110	3	1.12	0.95	95.3208	-0.0069	0.0000	0.0000;
	1329	1	5.79	1.23	0	0	1	1.0743101	-15.582504	110	3	1.12	0.95	95.3151	-0.0063	0.0000	0.0000;
	1330	2	0	0	0	0	1	1.0781259	-13.754652	110	3	1.12	0.95	95.4952	0.3259	0.0000	0.0000;
	1331	1	4.544	-0.051	0	0	1	1.0781361	-13.748392	110	3	1.12	0.95	95.4943	0.3256	0.0000	0.0000;
	1332	1	4.773	0.933	0	0	1	1.0823532	-9.7196541	110	3	1.12	0.95	93.5798	0.0277	0.0000	0.0000;
	1333	1	1.134	0.539	0	0	1	1.0823507	-9.7113212	110	3	1.12	0.95	93.5777	0.0275	0.0000	0.0000;
	1334	1	2.837	0.504	0	0	1	1.0944303	-12.192249	110	3	1.12	0.95	92.7294	0.1660	0.0000	0.0000;
	1335	1	3.403	0.521	0	0	1	1.0944211	-12.195595	110	3	1.12	0.95	92.7289	0.1653	0.0000	0.0000;
	1336	1	8.957	-0.087	0	0	1	1.0570094	-17.636558	110	3	1.12	0.95	97.9753	-0.1907	0.0000	0.0000;
	1337	1	0	0	0	0	1	1.057006	-17.638753	110	3	1.12	0.95	97.9716	-0.1928	0.0000	0.0000;
	1338	1	13.178	4.16	0	0	1	1.0932397	-11.490391	110	3	1.12	0.95	93.1467	0.1288	0.0000	0.0000;
	1339	1	5.099	1.296	0	0	1	1.0873731	-12.260034	110	3	1.12	0.95	93.6175	0.2505	0.0000	0.0000;
	1340	1	0	0	0	0	1	1.0968372	-11.087043	110	3	1.12	0.95	92.5780	0.0819	0.0000	0.0000;
	1341	2	22.539	7.441	0	0	1	1.083137	-8.8824374	110	3	1.12	0.95	92.4718	0.2999	0.0000	0.0000;
	1342	2	22.993	7.36	0	0	1	1.0831219	-8.8798974	110	3	1.12	0.95	92.4724	0.3001	0.0000	0.0000;
	1343	1	5.107	0.506	0	0	1	1.0884351	-13.088147	110	3	1.12	0.95	93.7892	0.1469	0.0000	0.0000;
	1344	1	4.198	0.467	0	0	1	1.0830415	-8.9624137	110	3	1.12	0.95	92.5792	0.2756	0.0000	0.0000;
	1345	1	0	0	0	0	1	1.0884668	-13.085838	110	3	1.12	0.95	93.7845	0.1464	0.0000	0.0000;
	1346	1	1.133	0.195	0	0	1	1.0893457	-12.817053	110	3	1.12	0.95	93.5410	0.0979	0.0000	0.0000;
	1347	1	10.216	2.208	0	0	1	1.080005	-13.564946	110	3	1.12	0.95	94.5078	0.4281	0.0000	0.0000;
	1348	1	3.402	0.357	0	0	1	1.0539384	-16.437111	110	3	1.12	0.95	96.1869	-0.3417	0.0000	0.0000;
	1349	1	0	0	0	0	1	1.0538827	-16.444635	110	3	1.12	0.95	96.1940	-0.3413	0.0000	0.0000;
	1350	2	16.164	18.236	0	0	1	1.0906104	-11.326003	110	3	1.12	0.95	92.6562	0.0000	0.0000	0.0000;
	1351	2	9.72	16.102	0	0	1	1.0977102	-11.346553	110	3	1.12	0.95	92.3693	0.0000	0.0000	0.0000;
	1352	2	0	0	0	0	1	1.1003203	-10.508608	110	3	1.12	0.95	92.2126	0.0267	0.0000	0.0000;
	1353	1	3.748	1.041	0	0	1	1.0616217	-17.887589	110	3	1.12	0.95	97.7877	-0.1413	0.0000	0.0000;
	1354	1	3.431	0.941	0	0	1	1.0615999	-17.884058	110	3	1.12	0.95	97.7912	-0.1410	0.0000	0.0000;
	1355	1	6.692	1.886	0	0	1	1.0962033	-13.351715	110	3	1.12	0.95	93.0129	0.0407	0.0000	0.0000;
	1356	1	11.352	2.857	0	0	1	1.0969388	-11.208962	110	3	1.12	0.95	92.9184	0.0417	0.0000	0.0000;
	1357	1	0	0	0	0	1	1.096502	-13.335315	110	3	1.12	0.95	92.9795	0.0314	0.0000	0.0000;
	1358	1	0	0	0	0	1	1.097415	-11.181478	110	3	1.12	0.95	92.8633	0.0280	0.0000	0.0000;
	1359	1	20.426	3.439	0	0	1	1.046942	-16.81382	110	3	1.12	0.95	97.2555	-0.2326	0.0000	0.0000;
	1360	1	0	0	0	0	1	1.0469561	-16.816575	110	3	1.12	0.95	97.2528	-0.2339	0.0000	0.0000;
	1361	1	0	0	0	0	1	1.0983138	-11.067501	110	3	1.12	0.95	92.8245	0.0123	0.0000	0.0000;
	1362	2	31.865	48.48	0	0	1	1.1044693	-12.820828	110	3	1.12	0.95	92.6554	0.0000	0.0000	0.0000;
	1363	1	9.868	0.721	0	0	1	1.0907576	-12.208007	110	3	1.12	0.95	93.8586	-0.3119	0.0000	0.0000;
	1364	1	0	0	0	0	1	1.0907744	-12.203237	110	3	1.12	0.95	93.8590	-0.3118	0.0000	0.0000;
	1365	1	2.27	0.794	0	0	1	1.0979401	-11.421436	110	3	1.12	0.95	92.4161	-0.0242	0.0000	0.0000;
	1366	1	0	0	0	0	1	1.0980045	-11.428149	110	3	1.12	0.95	92.4157	-0.0249	0.0000	0.0000;
	1367	1	10.699	5.44	0	0	1	1.0932629	-11.442562	110	3	1.12	0.95	93.0491	0.1506	0.0000	0.0000;
	1368	1	25.043	4.374	0	0	1	1.0932687	-11.444691	110	3	1.12	0.95	93.0538	0.1506	0.0000	0.0000;
	1369	1	0	0	0	0	1	1.0816684	-14.787069	110	3	1.12	0.95	94.6427	0.2124	0.0000	0.0000;
	1370	1	9.526	3.442	0	0	1	1.0787989	-14.963176	110	3	1.12	0.95	94.8953	0.3294	0.0000	0.0000;
	1371	1	0	0	0	0	1	1.0816639	-14.786929	110	3	1.12	0.95	94.6427	0.2129	0.0000	0.0000;
	1372	1	0	0	0	0	1	1.0795464	-14.930162	110	3	1.12	0.95	94.8128	0.3000	0.0000	0.0000;
	1373	2	22.633	23.616	0	0	1	1.080135	-14.411914	110	3	1.12	0.95	94.3780	0.0000	0.0000	0.0000;
	1374	2	10.653	15.856	0	0	1	1.0800864	-14.415473	110	3	1.12	0.95	94.3771	0.0000	0.0000	0.0000;
	1375	2	8.199	12.999	0	0	1	1.0748875	-15.325644	110	3	1.12	0.95	95.1869	0.0000	0.0000	0.0000;
	1376	1	4.313	0.961	0	0	1	1.1032096	-12.237402	110	3	1.12	0.95	92.1412	0.2320	0.0000	0.0000;
	1377	1	1.814	0.079	0	0	1	1.1031709	-12.246112	110	3	1.12	0.95	92.1440	0.2325	0.0000	0.0000;
	1378	1	0	0.065	0	0	1	1.0898435	-12.031443	110	3	1.12	0.95	93.3609	0.1878	0.0000	0.0000;
	1379	1	0	0.065	0	0	1	1.089771	-12.042127	110	3	1.12	0.95	93.3658	0.1893	0.0000	0.0000;
	1380	1	7.714	3.604	0	0	1	1.0986305	-10.801649	110	3	1.12	0.95	92.4675	0.0563	0.0000	0.0000;
	1381	1	0	0	0	0	1	1.0985768	-10.812794	110	3	1.12	0.95	92.4712	0.0569	0.0000	0.0000;
	1382	1	4.389	1.366	0	0	1	1.0794078	-15.042554	110	3	1.12	0.95	94.9682	0.2174	0.0000	0.0000;
	1383	1	0	0	0	0	1	1.0794135	-15.04236	110	3	1.12	0.95	94.9675	0.2174	0.0000	0.0000;
	1384	1	17.904	-0.974	0	0	1	1.0731408	-15.693572	110	3	1.12	0.95	95.5661	-0.0212	0.0000	0.0000;
	1385	1	24.413	-1.139	0	0	1	1.0772095	-15.202441	110	3	1.12	0.95	95.2015	-0.0659	0.0000	0.0000;
	1386	1	0	0	0	0	1	1.0860367	-12.366285	110	3	1.12	0.95	93.8199	-0.2869	0.0000	0.0000;
	1387	1	0	0	0	0	1	1.0860733	-12.354911	110	3	1.12	0.95	93.8173	-0.2856	0.0000	0.0000;
	1388	1	6.81	2.222	0	0	1	1.0958763	-12.61912	110	3	1.12	0.95	93.2059	-0.1787	0.0000	0.0000;
	1389	1	0	0	0	0	1	1.0957626	-12.64444	110	3	1.12	0.95	93.2083	-0.1782	0.0000	0.0000;
	1390	1	6.859	-0.83	0	0	1	1.0623345	-17.553103	110	3	1.12	0.95	97.5044	-0.4078	0.0000	0.0000;
	1391	1	4.999	-0.011	0	0	1	1.062308	-17.560297	110	3	1.12	0.95	97.5032	-0.4101	0.0000	0.0000;
	1392	1	0.725	0.273	0	0	1	1.074914	-15.021287	110	3	1.12	0.95	95.1422	0.0558	0.0000	0.0000;
	1393	1	4.798	1.244	0	0	1	1.0743518	-15.156272	110	3	1.12	0.95	94.9527	0.0256	0.0000	0.0000;
	1394	1	5.687	1.919	0	0	1	1.0912828	-11.817341	110	3	1.12	0.95	93.2227	-0.2947	0.0000	0.0000;
	1395	1	0	0	0	0	1	1.0915034	-11.802861	110	3	1.12	0.95	93.2030	-0.3012	0.0000	0.0000;
	1396	1	20.543	5.958	0	0	1	1.0950699	-11.4618	110	3	1.12	0.95	92.5579	0.0716	0.0000	0.0000;
	1397	1	0	0	0	0	1	1.095099	-11.460357	110	3	1.12	0.95	92.5563	0.0713	0.0000	0.0000;
	1398	1	0	0	0	0	1	1.0912823	-12.619246	110	3	1.12	0.95	93.2326	0.1282	0.0000	0.0000;
	1399	1	0	0	0	0	1	1.0912774	-12.619094	110	3	1.12	0.95	93.2326	0.1287	0.0000	0.0000;
	1400	1	5.892	0.89	0	0	1	1.0898044	-8.3342148	110	3	1.12	0.95	91.9585	0.0816	0.0000	0.0000;
	1401	1	1.133	0.081	0	0	1	1.0925188	-7.9314614	110	3	1.12	0.95	91.5706	0.0533	0.0000	0.0000;
	1402	1	0	0	0	0	1	1.0898626	-8.3298717	110	3	1.12	0.95	91.9510	0.0805	0.0000	0.0000;
	1403	1	15.865	7.371	0	0	1	1.0964563	-11.393014	110	3	1.12	0.95	92.4312	0.0342	0.0000	0.0000;
	1404	1	0	0	0	0	1	1.0964877	-11.386995	110	3	1.12	0.95	92.4296	0.0338	0.0000	0.0000;
	1405	1	5.107	0.748	0	0	1	1.0900773	-11.95715	110	3	1.12	0.95	93.1469	-0.0367	0.0000	0.0000;
	1406	1	2.834	0.239	0	0	1	1.0886395	-12.074281	110	3	1.12	0.95	93.2741	0.0004	0.0000	0.0000;
	1407	1	0	0	0	0	1	1.0902109	-11.948597	110	3	1.12	0.95	93.1284	-0.0394	0.0000	0.0000;
	1408	1	0	0	0	0	1	1.0887073	-12.069313	110	3	1.12	0.95	93.2638	-0.0004	0.0000	0.0000;
	1409	1	5.767	0.947	0	0	1	1.0779952	-15.640495	110	3	1.12	0.95	95.8127	0.2115	0.0000	0.0000;
	1410	1	0	0	0	0	1	1.0780014	-15.654693	110	3	1.12	0.95	95.8157	0.2107	0.0000	0.0000;
	1411	1	13.631	3.256	0	0	1	1.0766226	-16.065031	110	3	1.12	0.95	96.2537	0.1346	0.0000	0.0000;
	1412	1	0	0	0	0	1	1.0767556	-16.054	110	3	1.12	0.95	96.2495	0.1310	0.0000	0.0000;
	1413	1	0	0	0	0	1	1.0918715	-12.125516	110	3	1.12	0.95	93.1619	-0.1060	0.0000	0.0000;
	1414	1	0	0	0	0	1	1.0924482	-11.909701	110	3	1.12	0.95	93.0456	-0.1631	0.0000	0.0000;
	1415	2	0	0	0	0	1	1.0914318	-11.764622	110	3	1.12	0.95	92.9422	-0.0506	0.0000	0.0000;
	1416	2	3.999	3.999	0	0	1	1.0913109	-11.64626	110	3	1.12	0.95	92.8193	0.0000	0.0000	0.0000;
	1417	1	24.957	3.077	0	0	1	1.0862377	-12.382354	110	3	1.12	0.95	93.9512	-0.2520	0.0000	0.0000;
	1418	1	0	0	0	0	1	1.0862279	-12.380348	110	3	1.12	0.95	93.9502	-0.2531	0.0000	0.0000;
	1419	1	2.268	1.255	0	0	1	1.0925676	-11.678237	110	3	1.12	0.95	92.8461	-0.0778	0.0000	0.0000;
	1420	1	4.307	0.851	0	0	1	1.0925679	-11.677257	110	3	1.12	0.95	92.8459	-0.0779	0.0000	0.0000;
	1421	1	4.308	0.845	0	0	1	1.101395	-10.414044	110	3	1.12	0.95	92.0918	0.0079	0.0000	0.0000;
	1422	1	0	0	0	0	1	1.1014249	-10.409375	110	3	1.12	0.95	92.0895	0.0076	0.0000	0.0000;
	1423	1	1.134	0.223	0	0	1	1.091015	-11.729213	110	3	1.12	0.95	92.9738	0.1820	0.0000	0.0000;
	1424	1	0	0	0	0	1	1.0910977	-11.719641	110	3	1.12	0.95	92.9701	0.1812	0.0000	0.0000;
	1425	1	4.646	1.849	0	0	1	1.0892486	-12.703577	110	3	1.12	0.95	93.4100	0.1507	0.0000	0.0000;
	1426	1	0	0	0	0	1	1.0893118	-12.701675	110	3	1.12	0.95	93.4027	0.1478	0.0000	0.0000;
	1427	1	10.57	2.151	0	0	1	1.0781931	-16.189096	110	3	1.12	0.95	96.3038	0.0143	0.0000	0.0000;
	1428	1	0	0	0	0	1	1.0782695	-16.179379	110	3	1.12	0.95	96.3009	0.0133	0.0000	0.0000;
	1429	2	4.797	-0.473	0	0	1	1.0602036	-16.301408	110	3	1.12	0.95	96.6714	1.2937	0.0000	0.0000;
	1430	1	0	0	0	0	1	1.0599332	-16.334252	110	3	1.12	0.95	96.6886	1.2978	0.0000	0.0000;
	1431	1	0.565	0.308	0	0	1	1.0979017	-11.247267	110	3	1.12	0.95	92.2904	0.0021	0.0000	0.0000;
	1432	1	0	0	0	0	1	1.0979019	-11.247245	110	3	1.12	0.95	92.2904	0.0021	0.0000	0.0000;
	1433	2	2.256	0.394	0	0	1	1.0843468	-14.486866	110	3	1.12	0.95	94.3998	0.5790	0.0000	0.0000;
	1434	2	21.52	8.494	0	0	1	1.0847198	-13.946543	110	3	1.12	0.95	94.1064	0.6748	0.0000	0.0000;
	1435	2	33.986	12.139	0	0	1	1.0941036	-13.275314	110	3	1.12	0.95	93.1424	0.4241	0.0000	0.0000;
	1436	2	4.523	-0.01	0	0	1	1.0960778	-13.109978	110	3	1.12	0.95	92.9589	0.3710	0.0000	0.0000;
	1437	1	0	0	0	0	1	1.0944181	-13.255344	110	3	1.12	0.95	93.1164	0.4144	0.0000	0.0000;
	1438	1	9.419	2.59	0	0	1	1.0713366	-16.43363	110	3	1.12	0.95	96.3807	-0.2581	0.0000	0.0000;
	1439	1	11.268	3.145	0	0	1	1.0712913	-16.448242	110	3	1.12	0.95	96.3820	-0.2601	0.0000	0.0000;
	1440	2	23.028	38.205	0	0	1	1.0982505	-11.190982	110	3	1.12	0.95	92.2500	0.0000	0.0000	0.0000;
	1441	1	7.718	2.016	0	0	1	1.0980895	-11.212682	110	3	1.12	0.95	92.2587	0.0021	0.0000	0.0000;
	1442	1	0	0	0	0	1	1.0809513	-15.039268	110	3	1.12	0.95	95.1373	0.0672	0.0000	0.0000;
	1443	1	0	0	0	0	1	1.0809492	-15.039225	110	3	1.12	0.95	95.1373	0.0674	0.0000	0.0000;
	1444	2	8.969	1.961	0	0	1	1.0886408	-14.103923	110	3	1.12	0.95	93.8461	0.1450	0.0000	0.0000;
	1445	1	8.41	2.345	0	0	1	1.0881013	-14.086671	110	3	1.12	0.95	93.7924	0.2124	0.0000	0.0000;
	1446	1	0	0	0	0	1	1.0888152	-14.073283	110	3	1.12	0.95	93.8359	0.1430	0.0000	0.0000;
	1447	1	0	0	0	0	1	1.0884111	-14.043114	110	3	1.12	0.95	93.7778	0.2085	0.0000	0.0000;
	1448	1	2.622	0.379	0	0	1	1.0544924	-18.632697	110	3	1.12	0.95	97.8968	-0.5891	0.0000	0.0000;
	1449	1	2.131	0.296	0	0	1	1.0544914	-18.634933	110	3	1.12	0.95	97.8991	-0.5888	0.0000	0.0000;
	1450	1	0.226	0.211	0	0	1	1.0863226	-12.339177	110	3	1.12	0.95	93.8668	-0.2468	0.0000	0.0000;
	1451	1	0	0	0	0	1	1.0863287	-12.339081	110	3	1.12	0.95	93.8667	-0.2465	0.0000	0.0000;
	1452	1	7.483	1.903	0	0	1	1.0890685	-12.056064	110	3	1.12	0.95	93.2458	-0.0145	0.0000	0.0000;
	1453	1	0	0	0	0	1	1.0890527	-12.059018	110	3	1.12	0.95	93.2468	-0.0143	0.0000	0.0000;
	1454	1	7.943	1.106	0	0	1	1.0840545	-8.5367546	110	3	1.12	0.95	92.9114	0.1848	0.0000	0.0000;
	1455	1	3.517	0.279	0	0	1	1.084081	-8.5466998	110	3	1.12	0.95	92.9069	0.1852	0.0000	0.0000;
	1456	1	4.82	0.677	0	0	1	1.0542114	-18.510292	110	3	1.12	0.95	97.9280	-0.5337	0.0000	0.0000;
	1457	1	5.126	-0.461	0	0	1	1.0542129	-18.506947	110	3	1.12	0.95	97.9274	-0.5335	0.0000	0.0000;
	1458	1	17.344	5.249	0	0	1	1.0964081	-11.44707	110	3	1.12	0.95	92.4866	0.0217	0.0000	0.0000;
	1459	1	0	0	0	0	1	1.096359	-11.450154	110	3	1.12	0.95	92.4894	0.0225	0.0000	0.0000;
	1460	1	4.312	1.62	0	0	1	1.0636379	-15.760782	110	3	1.12	0.95	94.8556	-0.5265	0.0000	0.0000;
	1461	1	0	0	0	0	1	1.0636255	-15.762257	110	3	1.12	0.95	94.8559	-0.5260	0.0000	0.0000;
	1462	2	1.576	0.454	0	0	1	1.0589149	-18.479207	110	3	1.12	0.95	98.1751	-0.3464	0.0000	0.0000;
	1463	1	0.816	-0.208	0	0	1	1.0589068	-18.4839	110	3	1.12	0.95	98.1756	-0.3484	0.0000	0.0000;
	1464	1	5.483	0.735	0	0	1	1.0621714	-17.182221	110	3	1.12	0.95	97.3892	-0.1653	0.0000	0.0000;
	1465	1	8.281	-1.006	0	0	1	1.062183	-17.173939	110	3	1.12	0.95	97.3909	-0.1632	0.0000	0.0000;
	1466	1	0.907	0.231	0	0	1	1.0970654	-11.296218	110	3	1.12	0.95	92.3703	0.0256	0.0000	0.0000;
	1467	1	0	0	0	0	1	1.0970722	-11.2957	110	3	1.12	0.95	92.3696	0.0254	0.0000	0.0000;
	1468	1	2.04	0.327	0	0	1	1.0931822	-11.517378	110	3	1.12	0.95	93.1976	0.1180	0.0000	0.0000;
	1469	1	1.361	0.235	0	0	1	1.095812	-11.188644	110	3	1.12	0.95	92.8540	0.0858	0.0000	0.0000;
	1470	1	0	0	0	0	1	1.0931883	-11.516932	110	3	1.12	0.95	93.1968	0.1179	0.0000	0.0000;
	1471	1	0	0	0	0	1	1.0958162	-11.18835	110	3	1.12	0.95	92.8535	0.0857	0.0000	0.0000;
	1472	1	8.868	0.756	0	0	1	1.0986584	-12.974973	110	3	1.12	0.95	92.8069	0.2735	0.0000	0.0000;
	1473	1	5.906	0.473	0	0	1	1.0985845	-12.981966	110	3	1.12	0.95	92.8094	0.2748	0.0000	0.0000;
	1474	1	8.048	2.997	0	0	1	1.0605536	-16.216494	110	3	1.12	0.95	95.3778	-0.4951	0.0000	0.0000;
	1475	1	0	0	0	0	1	1.0606338	-16.219009	110	3	1.12	0.95	95.3770	-0.4949	0.0000	0.0000;
	1476	1	2.381	1.156	0	0	1	1.0918203	-11.613136	110	3	1.12	0.95	93.1686	0.1823	0.0000	0.0000;
	1477	1	4.309	2.047	0	0	1	1.0918793	-11.597073	110	3	1.12	0.95	93.1687	0.1819	0.0000	0.0000;
	1478	1	0	0	0	0	1	1.1025775	-12.308066	110	3	1.12	0.95	92.2140	0.2436	0.0000	0.0000;
	1479	1	0	0	0	0	1	1.1025402	-12.316076	110	3	1.12	0.95	92.2165	0.2441	0.0000	0.0000;
	1480	1	0.226	0.078	0	0	1	1.0860326	-12.368604	110	3	1.12	0.95	93.8221	-0.2874	0.0000	0.0000;
	1481	1	2.039	0.688	0	0	1	1.0858555	-12.372622	110	3	1.12	0.95	93.8373	-0.2801	0.0000	0.0000;
	1482	1	5.104	1.374	0	0	1	1.0876289	-14.590013	110	3	1.12	0.95	94.6887	0.1943	0.0000	0.0000;
	1483	1	1.813	1.418	0	0	1	1.0875681	-14.609248	110	3	1.12	0.95	94.6921	0.1933	0.0000	0.0000;
	1484	1	4.309	-0.651	0	0	1	1.0828659	-9.671241	110	3	1.12	0.95	93.5740	-0.0124	0.0000	0.0000;
	1485	1	0	0	0	0	1	1.0828596	-9.6665831	110	3	1.12	0.95	93.5734	-0.0125	0.0000	0.0000;
	1486	1	4.762	1.454	0	0	1	1.0769102	-14.761893	110	3	1.12	0.95	95.3297	0.2034	0.0000	0.0000;
	1487	1	3.407	1.356	0	0	1	1.0810646	-13.880059	110	3	1.12	0.95	94.7041	0.1188	0.0000	0.0000;
	1488	1	6.359	1.384	0	0	1	1.0610575	-16.923552	110	3	1.12	0.95	96.0218	-0.5553	0.0000	0.0000;
	1489	1	0	0	0	0	1	1.0610652	-16.915864	110	3	1.12	0.95	96.0191	-0.5563	0.0000	0.0000;
	1490	1	3.976	0.969	0	0	1	1.1035359	-12.912957	110	3	1.12	0.95	92.7523	0.0184	0.0000	0.0000;
	1491	1	6.815	1.41	0	0	1	1.0963206	-11.23857	110	3	1.12	0.95	93.0160	0.0595	0.0000	0.0000;
	1492	1	0	0	0	0	1	1.1035461	-12.911448	110	3	1.12	0.95	92.7518	0.0183	0.0000	0.0000;
	1493	1	3.29	-0.047	0	0	1	1.0801252	-10.529097	110	3	1.12	0.95	94.1543	-0.2538	0.0000	0.0000;
	1494	2	2.371	0.249	0	0	1	1.080116	-10.527142	110	3	1.12	0.95	94.1537	-0.2536	0.0000	0.0000;
	1495	1	18.708	4.799	0	0	1	1.0972344	-11.271846	110	3	1.12	0.95	92.3423	0.0231	0.0000	0.0000;
	1496	1	0	0	0	0	1	1.0973155	-11.261588	110	3	1.12	0.95	92.3380	0.0222	0.0000	0.0000;
	1497	1	23.149	9.727	0	0	1	1.0684631	-15.949372	110	3	1.12	0.95	96.3578	0.7779	0.0000	0.0000;
	1498	1	0	0	0	0	1	1.0685348	-15.935748	110	3	1.12	0.95	96.3527	0.7784	0.0000	0.0000;
	1499	1	1.247	0.039	0	0	1	1.0655122	-15.628795	110	3	1.12	0.95	94.6961	-0.5997	0.0000	0.0000;
	1500	1	0	0	0	0	1	1.065539	-15.625057	110	3	1.12	0.95	94.6951	-0.6004	0.0000	0.0000;
	1501	1	3.175	0.942	0	0	1	1.0898626	-8.3298717	110	3	1.12	0.95	91.9510	0.0805	0.0000	0.0000;
	1502	1	2.494	0.292	0	0	1	1.0925286	-7.9305946	110	3	1.12	0.95	91.5692	0.0532	0.0000	0.0000;
	1503	1	3.292	0.282	0	0	1	1.0793515	-14.815656	110	3	1.12	0.95	94.7429	0.7285	0.0000	0.0000;
	1504	1	0	0	0	0	1	1.0793803	-14.796784	110	3	1.12	0.95	94.7423	0.7293	0.0000	0.0000;
	1505	1	2.834	1.482	0	0	1	1.0764733	-14.77356	110	3	1.12	0.95	95.3780	0.2263	0.0000	0.0000;
	1506	1	10.208	2.373	0	0	1	1.0814694	-13.831389	110	3	1.12	0.95	94.6281	0.1028	0.0000	0.0000;
	1507	1	0	0	0	0	1	1.0821513	-13.770934	110	3	1.12	0.95	94.5569	0.0868	0.0000	0.0000;
	1508	1	3.739	0.81	0	0	1	1.0958142	-13.385514	110	3	1.12	0.95	93.2833	0.2748	0.0000	0.0000;
	1509	1	8.273	1.62	0	0	1	1.095757	-13.390667	110	3	1.12	0.95	93.2886	0.2760	0.0000	0.0000;
	1510	1	3.857	-0.512	0	0	1	1.0950536	-10.635735	110	3	1.12	0.95	93.0481	-0.8265	0.0000	0.0000;
	1511	1	0	0	0	0	1	1.0951225	-10.635206	110	3	1.12	0.95	93.0420	-0.8278	0.0000	0.0000;
	1512	1	1.474	0.726	0	0	1	1.0984772	-11.052505	110	3	1.12	0.95	92.8074	0.0089	0.0000	0.0000;
	1513	1	2.495	1.237	0	0	1	1.0871008	-14.201352	110	3	1.12	0.95	93.9384	0.2196	0.0000	0.0000;
	1514	1	7.489	0.642	0	0	1	1.1013875	-12.418291	110	3	1.12	0.95	92.2403	0.2882	0.0000	0.0000;
	1515	1	0	0	0	0	1	1.1035002	-12.156051	110	3	1.12	0.95	92.0588	0.2452	0.0000	0.0000;
	1516	1	0	0	0	0	1	1.1013924	-12.415367	110	3	1.12	0.95	92.2402	0.2882	0.0000	0.0000;
	1517	1	0	0	0	0	1	1.1035002	-12.156051	110	3	1.12	0.95	92.0588	0.2452	0.0000	0.0000;
	1518	2	4.991	0.17	0	0	1	1.0923425	-8.8605675	110	3	1.12	0.95	91.3811	-0.0495	0.0000	0.0000;
	1519	2	4.299	0.792	0	0	1	1.0923118	-8.8461599	110	3	1.12	0.95	91.3855	-0.0491	0.0000	0.0000;
	1520	2	0	0	0	0	1	1.0803931	-10.680214	110	3	1.12	0.95	94.2333	-0.2762	0.0000	0.0000;
	1521	2	9.861	-0.656	0	0	1	1.0803916	-10.68103	110	3	1.12	0.95	94.2335	-0.2762	0.0000	0.0000;
	1522	1	5.217	1.613	0	0	1	1.0987199	-11.090791	110	3	1.12	0.95	92.1386	0.0140	0.0000	0.0000;
	1523	1	0	0	0	0	1	1.0987379	-11.084736	110	3	1.12	0.95	92.1360	0.0141	0.0000	0.0000;
	1524	1	0	0	0	0	1	1.0651387	-15.789649	110	3	1.12	0.95	96.1222	1.1955	0.0000	0.0000;
	1525	1	0	0	0	0	1	1.0651953	-15.783933	110	3	1.12	0.95	96.1181	1.1945	0.0000	0.0000;
	1526	1	0	0	0	0	1	1.0979896	-10.948616	110	3	1.12	0.95	92.5721	0.0543	0.0000	0.0000;
	1527	1	9.982	4.576	0	0	1	1.0980208	-10.940223	110	3	1.12	0.95	92.5699	0.0539	0.0000	0.0000;
	1528	1	2.884	0.743	0	0	1	1.0539528	-18.683749	110	3	1.12	0.95	98.0356	-0.5738	0.0000	0.0000;
	1529	1	0.668	0.149	0	0	1	1.0539587	-18.683818	110	3	1.12	0.95	98.0352	-0.5741	0.0000	0.0000;
	1530	1	5.116	1.708	0	0	1	1.0958829	-11.435742	110	3	1.12	0.95	92.5068	0.0516	0.0000	0.0000;
	1531	1	0	0	0	0	1	1.096037	-11.428101	110	3	1.12	0.95	92.4905	0.0463	0.0000	0.0000;
	1532	1	7.932	1.458	0	0	1	1.0847442	-8.9026346	110	3	1.12	0.95	92.4659	0.2007	0.0000	0.0000;
	1533	1	0	0	0	0	1	1.0883425	-8.5734106	110	3	1.12	0.95	91.9638	0.1346	0.0000	0.0000;
	1534	1	0	0	0	0	1	1.0850576	-8.8838647	110	3	1.12	0.95	92.4246	0.1933	0.0000	0.0000;
	1535	1	0	0	0	0	1	1.0883408	-8.5733556	110	3	1.12	0.95	91.9638	0.1347	0.0000	0.0000;
	1536	1	5.265	-0.422	0	0	1	1.0724386	-16.090401	110	3	1.12	0.95	95.8896	-0.1232	0.0000	0.0000;
	1537	1	2.178	0.299	0	0	1	1.0724323	-16.091606	110	3	1.12	0.95	95.8901	-0.1231	0.0000	0.0000;
	1538	1	0	0	0	0	1	1.0875388	-12.991701	110	3	1.12	0.95	93.9033	0.2655	0.0000	0.0000;
	1539	1	4.986	1.134	0	0	1	1.0841639	-13.285731	110	3	1.12	0.95	94.4186	0.3021	0.0000	0.0000;
	1540	1	0	0	0	0	1	1.0875388	-12.991701	110	3	1.12	0.95	93.9033	0.2655	0.0000	0.0000;
	1541	1	3.922	1.061	0	0	1	1.0546374	-18.290619	110	3	1.12	0.95	97.7624	-0.4947	0.0000	0.0000;
	1542	1	7.322	1.495	0	0	1	1.0742265	-15.473598	110	3	1.12	0.95	95.3264	-0.0104	0.0000	0.0000;
	1543	2	6.952	0.696	0	0	1	1.0742357	-15.489316	110	3	1.12	0.95	95.3298	-0.0114	0.0000	0.0000;
	1544	1	1.133	0.405	0	0	1	1.0852513	-14.338392	110	3	1.12	0.95	94.2420	0.5785	0.0000	0.0000;
	1545	1	0	0	0	0	1	1.0852481	-14.34382	110	3	1.12	0.95	94.2427	0.5785	0.0000	0.0000;
	1546	2	15.289	8.495	0	0	1	1.0806556	-14.580866	110	3	1.12	0.95	94.5723	0.7250	0.0000	0.0000;
	1547	2	14.154	6.063	0	0	1	1.077697	-14.631748	110	3	1.12	0.95	94.7536	0.8895	0.0000	0.0000;
	1548	1	11.357	2.9	0	0	1	1.0843409	-14.056082	110	3	1.12	0.95	94.1980	0.6611	0.0000	0.0000;
	1549	1	0	0.065	0	0	1	1.0843791	-14.056593	110	3	1.12	0.95	94.1962	0.6604	0.0000	0.0000;
	1550	1	1.587	0.588	0	0	1	1.0908638	-11.748225	110	3	1.12	0.95	92.9845	0.1855	0.0000	0.0000;
	1551	1	0	0	0	0	1	1.0909504	-11.740813	110	3	1.12	0.95	92.9795	0.1845	0.0000	0.0000;
	1552	1	3.973	1.942	0	0	1	1.0869305	-11.935511	110	3	1.12	0.95	93.2087	0.0821	0.0000	0.0000;
	1553	1	0	0.081	0	0	1	1.0904387	-11.613271	110	3	1.12	0.95	92.8480	0.0047	0.0000	0.0000;
	1554	1	0	0	0	0	1	1.0871364	-11.924268	110	3	1.12	0.95	93.1941	0.0752	0.0000	0.0000;
	1555	1	0	0	0	0	1	1.0904411	-11.613313	110	3	1.12	0.95	92.8480	0.0046	0.0000	0.0000;
	1556	1	5.107	1.404	0	0	1	1.0862246	-12.354889	110	3	1.12	0.95	93.8851	-0.2468	0.0000	0.0000;
	1557	1	0	0	0	0	1	1.0862247	-12.354924	110	3	1.12	0.95	93.8842	-0.2477	0.0000	0.0000;
	1558	1	0.794	0.288	0	0	1	1.0934244	-7.3329632	110	3	1.12	0.95	91.4036	0.0723	0.0000	0.0000;
	1559	1	1.817	-1.051	0	0	1	1.0934447	-7.3467632	110	3	1.12	0.95	91.4004	0.0729	0.0000	0.0000;
	1560	1	4.664	-0.169	0	0	1	1.0787996	-14.657324	110	3	1.12	0.95	94.5863	0.0021	0.0000	0.0000;
	1561	1	2.53	0.308	0	0	1	1.0787795	-14.671258	110	3	1.12	0.95	94.5886	0.0020	0.0000	0.0000;
	1562	1	0	0	0	0	1	1.0904981	-11.477205	110	3	1.12	0.95	92.7647	-0.0019	0.0000	0.0000;
	1563	1	0	0	0	0	1	1.0904762	-11.476828	110	3	1.12	0.95	92.7647	-0.0007	0.0000	0.0000;
	1564	1	1.36	0.331	0	0	1	1.0615838	-16.266416	110	3	1.12	0.95	95.3916	-0.5342	0.0000	0.0000;
	1565	1	0	0	0	0	1	1.0616665	-16.268362	110	3	1.12	0.95	95.3906	-0.5341	0.0000	0.0000;
	1566	1	16.451	2.704	0	0	1	1.0877546	-12.179047	110	3	1.12	0.95	93.3875	0.0134	0.0000	0.0000;
	1567	1	0	0	0	0	1	1.0888461	-12.079727	110	3	1.12	0.95	93.2695	-0.0102	0.0000	0.0000;
	1568	1	0	0	0	0	1	1.087993	-12.160149	110	3	1.12	0.95	93.3574	0.0084	0.0000	0.0000;
	1569	1	0	0	0	0	1	1.0888455	-12.079715	110	3	1.12	0.95	93.2695	-0.0101	0.0000	0.0000;
	1570	1	7.033	0.24	0	0	1	1.0861272	-10.40032	110	3	1.12	0.95	93.7140	-0.4429	0.0000	0.0000;
	1571	1	0	0	0	0	1	1.0860548	-10.396416	110	3	1.12	0.95	93.7188	-0.4413	0.0000	0.0000;
	1572	1	0	0	0	0	1	1.0771743	-15.34543	110	3	1.12	0.95	95.2014	0.2611	0.0000	0.0000;
	1573	1	0	0	0	0	1	1.077067	-15.362804	110	3	1.12	0.95	95.2077	0.2628	0.0000	0.0000;
	1574	1	7.506	-0.277	0	0	1	1.0733644	-15.641177	110	3	1.12	0.95	95.5170	-0.0185	0.0000	0.0000;
	1575	1	14.769	0.25	0	0	1	1.0775236	-15.131697	110	3	1.12	0.95	95.1355	-0.0629	0.0000	0.0000;
	1576	1	7.27	0.455	0	0	1	1.0957978	-11.873008	110	3	1.12	0.95	93.0201	-0.4218	0.0000	0.0000;
	1577	1	0	0	0	0	1	1.0958582	-11.862981	110	3	1.12	0.95	93.0178	-0.4205	0.0000	0.0000;
	1578	1	4.084	0.136	0	0	1	1.0717575	-15.668696	110	3	1.12	0.95	95.4177	-0.2415	0.0000	0.0000;
	1579	1	4.119	0.216	0	0	1	1.0717618	-15.662838	110	3	1.12	0.95	95.4162	-0.2378	0.0000	0.0000;
	1580	2	5.769	1.286	0	0	1	1.0654889	-14.83605	110	3	1.12	0.95	97.6532	0.4140	0.0000	0.0000;
	1581	1	4.306	-0.486	0	0	1	1.0654983	-14.838265	110	3	1.12	0.95	97.6526	0.4137	0.0000	0.0000;
	1582	1	0	0	0	0	1	1.0921063	-12.484887	110	3	1.12	0.95	93.0792	0.1573	0.0000	0.0000;
	1583	1	4.533	0.081	0	0	1	1.0920407	-12.499526	110	3	1.12	0.95	93.0851	0.1571	0.0000	0.0000;
	1584	1	7.938	0.566	0	0	1	1.0626681	-15.939749	110	3	1.12	0.95	95.0426	-0.5084	0.0000	0.0000;
	1585	1	0	0	0	0	1	1.0626923	-15.946373	110	3	1.12	0.95	95.0446	-0.5081	0.0000	0.0000;
	1586	1	4.533	0.972	0	0	1	1.0796902	-14.939847	110	3	1.12	0.95	94.8228	0.2692	0.0000	0.0000;
	1587	1	9.065	3.564	0	0	1	1.0797166	-14.938738	110	3	1.12	0.95	94.8230	0.2670	0.0000	0.0000;
	1588	1	2.382	0.58	0	0	1	1.0869385	-14.074662	110	3	1.12	0.95	93.9548	0.5739	0.0000	0.0000;
	1589	1	0	0	0	0	1	1.0869607	-14.067775	110	3	1.12	0.95	93.9535	0.5736	0.0000	0.0000;
	1590	1	6.017	0.875	0	0	1	1.0831113	-15.075327	110	3	1.12	0.95	94.9444	0.1966	0.0000	0.0000;
	1591	1	5.331	0.729	0	0	1	1.0830526	-15.098174	110	3	1.12	0.95	94.9505	0.1970	0.0000	0.0000;
	1592	1	2.835	1.408	0	0	1	1.0946155	-11.557709	110	3	1.12	0.95	92.8660	0.1031	0.0000	0.0000;
	1593	1	8.061	3.893	0	0	1	1.0946158	-11.57569	110	3	1.12	0.95	92.8643	0.1029	0.0000	0.0000;
	1594	2	2.6	0.361	0	0	1	1.0589709	-15.707672	110	3	1.12	0.95	95.7411	-0.4896	0.0000	0.0000;
	1595	1	0	0	0	0	1	1.0589925	-15.68838	110	3	1.12	0.95	95.7484	-0.4885	0.0000	0.0000;
	1596	1	5.221	0.916	0	0	1	1.0872362	-13.02903	110	3	1.12	0.95	93.9492	0.2684	0.0000	0.0000;
	1597	1	2.495	0.252	0	0	1	1.0872755	-13.013873	110	3	1.12	0.95	93.9449	0.2680	0.0000	0.0000;
	1598	1	3.739	0.729	0	0	1	1.0971748	-11.017648	110	3	1.12	0.95	92.5326	0.0786	0.0000	0.0000;
	1599	1	0	0	0	0	1	1.0972413	-11.011297	110	3	1.12	0.95	92.5254	0.0772	0.0000	0.0000;
	1600	1	9.072	2.146	0	0	1	1.0907077	-11.910466	110	3	1.12	0.95	93.1035	-0.0659	0.0000	0.0000;
	1601	1	0	0	0	0	1	1.0907296	-11.91146	110	3	1.12	0.95	93.1035	-0.0664	0.0000	0.0000;
	1602	1	10.235	2.996	0	0	1	1.080834	-13.485413	110	3	1.12	0.95	94.4191	0.4099	0.0000	0.0000;
	1603	1	0	0	0	0	1	1.0808487	-13.48429	110	3	1.12	0.95	94.4177	0.4095	0.0000	0.0000;
	1604	1	9.069	1.333	0	0	1	1.0628931	-16.268083	110	3	1.12	0.95	95.3463	-0.5640	0.0000	0.0000;
	1605	1	0	0	0	0	1	1.0628644	-16.262455	110	3	1.12	0.95	95.3446	-0.5642	0.0000	0.0000;
	1606	1	4.379	0.268	0	0	1	1.0634877	-17.635059	110	3	1.12	0.95	97.4663	-0.1383	0.0000	0.0000;
	1607	1	6.434	0.555	0	0	1	1.0634954	-17.642687	110	3	1.12	0.95	97.4642	-0.1385	0.0000	0.0000;
	1608	1	7.632	-0.378	0	0	1	1.0769898	-15.934705	110	3	1.12	0.95	96.0735	0.1771	0.0000	0.0000;
	1609	1	0	0	0	0	1	1.0769987	-15.945774	110	3	1.12	0.95	96.0755	0.1762	0.0000	0.0000;
	1610	1	2.665	0.911	0	0	1	1.0677877	-16.984288	110	3	1.12	0.95	97.5653	0.2872	0.0000	0.0000;
	1611	1	0	0	0	0	1	1.0677651	-16.987486	110	3	1.12	0.95	97.5656	0.2875	0.0000	0.0000;
	1612	1	3.742	0.963	0	0	1	1.1013804	-11.510026	110	3	1.12	0.95	92.3949	-0.4890	0.0000	0.0000;
	1613	1	0	0	0	0	1	1.1013882	-11.509663	110	3	1.12	0.95	92.3939	-0.4892	0.0000	0.0000;
	1614	1	0	0	0	0	1	1.0887277	-12.050171	110	3	1.12	0.95	93.4600	0.2358	0.0000	0.0000;
	1615	1	2.039	0.486	0	0	1	1.0887383	-12.039105	110	3	1.12	0.95	93.4618	0.2362	0.0000	0.0000;
	1616	1	2.204	0.586	0	0	1	1.0790022	-14.573831	110	3	1.12	0.95	94.5445	0.0071	0.0000	0.0000;
	1617	1	2.762	0.75	0	0	1	1.0789816	-14.581818	110	3	1.12	0.95	94.5471	0.0071	0.0000	0.0000;
	1618	1	0	0	0	0	1	1.0980272	-7.41348	110	3	1.12	0.95	90.6199	-0.0505	0.0000	0.0000;
	1619	1	0	0	0	0	1	1.0978915	-7.4119996	110	3	1.12	0.95	90.6199	-0.0458	0.0000	0.0000;
	1620	1	4.76	0.527	0	0	1	1.0904996	-11.650959	110	3	1.12	0.95	92.8681	0.0051	0.0000	0.0000;
	1621	1	2.494	0.263	0	0	1	1.0905205	-11.651524	110	3	1.12	0.95	92.8671	0.0055	0.0000	0.0000;
	1622	1	4.651	0.797	0	0	1	1.0957506	-13.127562	110	3	1.12	0.95	92.9810	0.3820	0.0000	0.0000;
	1623	1	0	0	0	0	1	1.0958937	-13.104388	110	3	1.12	0.95	92.9749	0.3797	0.0000	0.0000;
	1624	1	1.586	0.324	0	0	1	1.0942856	-11.425763	110	3	1.12	0.95	93.1040	0.0920	0.0000	0.0000;
	1625	1	0	0	0	0	1	1.0943377	-11.421434	110	3	1.12	0.95	93.0975	0.0910	0.0000	0.0000;
	1626	1	6.472	0.716	0	0	1	1.0938154	-11.383522	110	3	1.12	0.95	93.1960	-0.5904	0.0000	0.0000;
	1627	1	0	0	0	0	1	1.0938082	-11.386539	110	3	1.12	0.95	93.1962	-0.5904	0.0000	0.0000;
	1628	1	13.416	6.68	0	0	1	1.0919719	-11.758451	110	3	1.12	0.95	93.1911	0.1414	0.0000	0.0000;
	1629	1	0	0	0	0	1	1.0921045	-11.742738	110	3	1.12	0.95	93.1845	0.1390	0.0000	0.0000;
	1630	1	7.384	1.776	0	0	1	1.0893964	-12.767649	110	3	1.12	0.95	93.3951	0.1916	0.0000	0.0000;
	1631	1	5.676	1.019	0	0	1	1.0894573	-12.75695	110	3	1.12	0.95	93.3904	0.1913	0.0000	0.0000;
	1632	1	0	0	0	0	1	1.0929103	-11.675759	110	3	1.12	0.95	92.8431	-0.0930	0.0000	0.0000;
	1633	1	0	0	0	0	1	1.0928174	-11.685553	110	3	1.12	0.95	92.8471	-0.0916	0.0000	0.0000;
	1634	1	0	0	0	0	1	1.0954896	-12.211513	110	3	1.12	0.95	92.8001	-0.0590	0.0000	0.0000;
	1635	1	4.535	0.931	0	0	1	1.0878705	-11.710811	110	3	1.12	0.95	93.0262	0.0599	0.0000	0.0000;
	1636	1	0	0.078	0	0	1	1.0878645	-11.717375	110	3	1.12	0.95	93.0273	0.0605	0.0000	0.0000;
	1637	1	10.446	-0.494	0	0	1	1.074312	-15.706085	110	3	1.12	0.95	95.4082	-0.0524	0.0000	0.0000;
	1638	1	11.059	-0.303	0	0	1	1.0742775	-15.707473	110	3	1.12	0.95	95.4085	-0.0516	0.0000	0.0000;
	1639	1	7.261	0.746	0	0	1	1.0935567	-11.426984	110	3	1.12	0.95	93.2235	-0.5874	0.0000	0.0000;
	1640	1	0	0	0	0	1	1.0935649	-11.423971	110	3	1.12	0.95	93.2233	-0.5874	0.0000	0.0000;
	1641	1	0	0	0	0	1	1.0935672	-11.420946	110	3	1.12	0.95	93.2241	-0.5874	0.0000	0.0000;
	1642	1	0	0	0	0	1	1.0935672	-11.420946	110	3	1.12	0.95	93.2241	-0.5874	0.0000	0.0000;
	1643	1	8.511	2.532	0	0	1	1.0989243	-11.820087	110	3	1.12	0.95	92.1924	0.1293	0.0000	0.0000;
	1644	1	17.578	3.435	0	0	1	1.0889194	-13.875165	110	3	1.12	0.95	93.7276	0.5293	0.0000	0.0000;
	1645	1	0	0	0	0	1	1.096228	-13.089586	110	3	1.12	0.95	92.9545	0.3665	0.0000	0.0000;
	1646	1	0	0	0	0	1	1.0962271	-13.08957	110	3	1.12	0.95	92.9545	0.3666	0.0000	0.0000;
	1647	2	5.67	1.787	0	0	1	1.0600077	-17.357426	110	3	1.12	0.95	96.4656	-0.5343	0.0000	0.0000;
	1648	2	0	0	0	0	1	1.0600114	-17.352236	110	3	1.12	0.95	96.4637	-0.5352	0.0000	0.0000;
	1649	1	0.226	0	0	0	1	1.0985682	-11.053814	110	3	1.12	0.95	92.7946	0.0042	0.0000	0.0000;
	1650	1	0.566	0	0	0	1	1.0983419	-13.167172	110	3	1.12	0.95	92.7815	-0.0001	0.0000	0.0000;
	1651	1	0	0	0	0	1	1.0985692	-11.053616	110	3	1.12	0.95	92.7944	0.0042	0.0000	0.0000;
	1652	1	10.312	2.916	0	0	1	1.0713469	-15.594171	110	3	1.12	0.95	95.5507	0.5694	0.0000	0.0000;
	1653	1	4.193	2.834	0	0	1	1.0713976	-15.587073	110	3	1.12	0.95	95.5481	0.5687	0.0000	0.0000;
	1654	1	1.699	0.648	0	0	1	1.1023929	-12.933342	110	3	1.12	0.95	92.7866	0.0706	0.0000	0.0000;
	1655	1	0	0	0	0	1	1.1024596	-12.928831	110	3	1.12	0.95	92.7813	0.0687	0.0000	0.0000;
	1656	1	2.267	-0.075	0	0	1	1.0700873	-15.235001	110	3	1.12	0.95	94.2242	-0.7422	0.0000	0.0000;
	1657	1	0	0	0	0	1	1.070119	-15.228798	110	3	1.12	0.95	94.2225	-0.7429	0.0000	0.0000;
	1658	1	6.804	0.931	0	0	1	1.0933696	-11.483698	110	3	1.12	0.95	93.1468	0.1231	0.0000	0.0000;
	1659	1	6.235	0.931	0	0	1	1.0934511	-11.473642	110	3	1.12	0.95	93.1427	0.1222	0.0000	0.0000;
	1660	1	3.399	0.47	0	0	1	1.0809329	-10.183143	110	3	1.12	0.95	93.7829	-0.1300	0.0000	0.0000;
	1661	1	0	0	0	0	1	1.081009	-10.17807	110	3	1.12	0.95	93.7721	-0.1315	0.0000	0.0000;
	1662	1	16.998	4.86	0	0	1	1.0809313	-13.90304	110	3	1.12	0.95	94.7246	0.1254	0.0000	0.0000;
	1663	1	0	0	0	0	1	1.0809389	-13.899443	110	3	1.12	0.95	94.7239	0.1245	0.0000	0.0000;
	1664	1	2.952	0.754	0	0	1	1.0596183	-16.157408	110	3	1.12	0.95	95.2684	-0.4137	0.0000	0.0000;
	1665	1	6.613	0.732	0	0	1	1.0752022	-16.390179	110	3	1.12	0.95	96.8273	0.0660	0.0000	0.0000;
	1666	1	0	0	0	0	1	1.0751831	-16.394473	110	3	1.12	0.95	96.8279	0.0662	0.0000	0.0000;
	1667	1	8.16	2.268	0	0	1	1.0816425	-13.8696	110	3	1.12	0.95	94.6747	0.1118	0.0000	0.0000;
	1668	1	0	0	0	0	1	1.0817075	-13.863292	110	3	1.12	0.95	94.6720	0.1117	0.0000	0.0000;
	1669	1	0	0	0	0	1	1.0609593	-17.260837	110	3	1.12	0.95	97.3381	-0.1766	0.0000	0.0000;
	1670	1	0	0	0	0	1	1.060956	-17.260777	110	3	1.12	0.95	97.3381	-0.1764	0.0000	0.0000;
	1671	1	1.359	0.517	0	0	1	1.0812259	-13.437256	110	3	1.12	0.95	94.8499	-0.8787	0.0000	0.0000;
	1672	1	0	0	0	0	1	1.0812365	-13.437433	110	3	1.12	0.95	94.8474	-0.8793	0.0000	0.0000;
	1673	1	0	0	0	0	1	1.0961747	-12.033412	110	3	1.12	0.95	92.5549	0.1258	0.0000	0.0000;
	1674	1	9.3	1.175	0	0	1	1.0962442	-12.017975	110	3	1.12	0.95	92.5486	0.1258	0.0000	0.0000;
	1675	2	19.646	19.486	0	0	1	1.0832823	-14.86934	110	3	1.12	0.95	94.9560	0.0000	0.0000	0.0000;
	1676	2	14.999	18.999	0	0	1	1.0842538	-14.001483	110	3	1.12	0.95	94.5443	0.0000	0.0000	0.0000;
	1677	2	3.286	1.134	0	0	1	1.0862987	-13.336703	110	3	1.12	0.95	94.0554	-0.0277	0.0000	0.0000;
	1678	1	6.237	0.878	0	0	1	1.0940427	-11.309227	110	3	1.12	0.95	93.1515	-0.6045	0.0000	0.0000;
	1679	1	0	0	0	0	1	1.0940798	-11.30137	110	3	1.12	0.95	93.1495	-0.6037	0.0000	0.0000;
	1680	1	2.724	0.584	0	0	1	1.098108	-6.6491104	110	3	1.12	0.95	90.4735	-0.0058	0.0000	0.0000;
	1681	1	0	0	0	0	1	1.0981289	-6.665089	110	3	1.12	0.95	90.4697	-0.0062	0.0000	0.0000;
	1682	1	9.44	3.22	0	0	1	1.0865499	-12.095496	110	3	1.12	0.95	93.5344	-0.1375	0.0000	0.0000;
	1683	1	0	0	0	0	1	1.08657	-12.097561	110	3	1.12	0.95	93.5354	-0.1384	0.0000	0.0000;
	1684	1	0	0	0	0	1	1.0881433	-11.832635	110	3	1.12	0.95	93.2460	-0.1083	0.0000	0.0000;
	1685	1	7.932	2.43	0	0	1	1.09838	-12.730934	110	3	1.12	0.95	92.6201	0.3494	0.0000	0.0000;
	1686	1	0	0	0	0	1	1.0983385	-12.743756	110	3	1.12	0.95	92.6235	0.3500	0.0000	0.0000;
	1687	2	8.597	10.476	0	0	1	1.0772172	-15.506692	110	3	1.12	0.95	95.0709	-0.1442	0.0000	0.0000;
	1688	2	14.365	19.706	0	0	1	1.0818089	-15.436331	110	3	1.12	0.95	95.1394	-0.3498	0.0000	0.0000;
	1689	1	3.679	-0.103	0	0	1	1.0575026	-18.310088	110	3	1.12	0.95	98.5678	-0.1645	0.0000	0.0000;
	1690	1	5.642	1.012	0	0	1	1.0575009	-18.309701	110	3	1.12	0.95	98.5677	-0.1645	0.0000	0.0000;
	1691	1	3.406	0.404	0	0	1	1.0816697	-13.452703	110	3	1.12	0.95	94.7037	-0.8984	0.0000	0.0000;
	1692	1	0	0	0	0	1	1.0816632	-13.441327	110	3	1.12	0.95	94.7057	-0.8930	0.0000	0.0000;
	1693	1	0	0	0	0	1	1.0809312	-15.524023	110	3	1.12	0.95	95.2161	-0.3138	0.0000	0.0000;
	1694	1	0	0	0	0	1	1.0771279	-15.588238	110	3	1.12	0.95	95.0930	-0.1347	0.0000	0.0000;
	1695	1	1.133	0	0	0	1	1.0910148	-12.098648	110	3	1.12	0.95	93.5187	-0.1894	0.0000	0.0000;
	1696	1	4.759	1.62	0	0	1	1.0887584	-8.5167038	110	3	1.12	0.95	92.2157	0.0682	0.0000	0.0000;
	1697	1	12.506	2.799	0	0	1	1.0685804	-15.993341	110	3	1.12	0.95	96.4078	0.7419	0.0000	0.0000;
	1698	1	0	0	0	0	1	1.0685092	-16.001186	110	3	1.12	0.95	96.4064	0.7441	0.0000	0.0000;
	1699	1	9.065	2.106	0	0	1	1.0898455	-13.249733	110	3	1.12	0.95	93.7823	0.0421	0.0000	0.0000;
	1700	1	0	0	0	0	1	1.0898951	-13.226655	110	3	1.12	0.95	93.7814	0.0415	0.0000	0.0000;
	1701	1	3.4	0.931	0	0	1	1.0875342	-13.57168	110	3	1.12	0.95	94.1061	0.0732	0.0000	0.0000;
	1702	1	3.968	1.53	0	0	1	1.0797934	-15.076153	110	3	1.12	0.95	95.1578	0.1483	0.0000	0.0000;
	1703	1	0	0	0	0	1	1.0880394	-13.550166	110	3	1.12	0.95	94.0376	0.0580	0.0000	0.0000;
	1704	1	0	0	0	0	1	1.0804651	-15.05342	110	3	1.12	0.95	95.0747	0.1200	0.0000	0.0000;
	1705	1	8.726	2.025	0	0	1	1.0946322	-11.426964	110	3	1.12	0.95	93.0520	0.0813	0.0000	0.0000;
	1706	1	3.853	1.215	0	0	1	1.0934438	-11.474264	110	3	1.12	0.95	93.1304	0.1235	0.0000	0.0000;
	1707	1	0	0	0	0	1	1.0949449	-11.398051	110	3	1.12	0.95	93.0217	0.0744	0.0000	0.0000;
	1708	1	6.365	0.905	0	0	1	1.0697516	-15.489414	110	3	1.12	0.95	95.8918	0.1969	0.0000	0.0000;
	1709	1	5.405	0.612	0	0	1	1.0697309	-15.493499	110	3	1.12	0.95	95.8968	0.2002	0.0000	0.0000;
	1710	1	2.267	0.81	0	0	1	1.0970564	-12.931702	110	3	1.12	0.95	92.7881	0.3688	0.0000	0.0000;
	1711	1	2.267	0.81	0	0	1	1.0970902	-12.919723	110	3	1.12	0.95	92.7849	0.3684	0.0000	0.0000;
	1712	1	5.561	2.532	0	0	1	1.1000498	-10.594663	110	3	1.12	0.95	92.2844	0.0390	0.0000	0.0000;
	1713	1	3.061	1.571	0	0	1	1.0998751	-10.678451	110	3	1.12	0.95	92.3372	0.0267	0.0000	0.0000;
	1714	1	0	0	0	0	1	1.1005024	-10.578049	110	3	1.12	0.95	92.2410	0.0197	0.0000	0.0000;
	1715	1	0	0	0	0	1	1.1001351	-10.669792	110	3	1.12	0.95	92.3133	0.0148	0.0000	0.0000;
	1716	1	10.676	2.205	0	0	1	1.0904105	-13.153489	110	3	1.12	0.95	93.7218	0.0272	0.0000	0.0000;
	1717	1	0	0	0	0	1	1.0903977	-13.16724	110	3	1.12	0.95	93.7212	0.0270	0.0000	0.0000;
	1718	1	5.515	1.06	0	0	1	1.0732214	-16.02931	110	3	1.12	0.95	96.1872	0.2697	0.0000	0.0000;
	1719	1	0	0	0	0	1	1.0731415	-16.029949	110	3	1.12	0.95	96.1855	0.2693	0.0000	0.0000;
	1720	1	2.267	0	0	0	1	1.0910171	-12.610204	110	3	1.12	0.95	93.2126	0.1656	0.0000	0.0000;
	1721	1	11.331	0.81	0	0	1	1.0910282	-12.606798	110	3	1.12	0.95	93.2108	0.1658	0.0000	0.0000;
	1722	1	2.84	0.686	0	0	1	1.0838872	-9.5030371	110	3	1.12	0.95	93.3305	0.0116	0.0000	0.0000;
	1723	1	0	0	0	0	1	1.0838958	-9.5077051	110	3	1.12	0.95	93.3311	0.0117	0.0000	0.0000;
	1724	1	5.451	1.752	0	0	1	1.0954069	-11.602241	110	3	1.12	0.95	92.6093	0.0403	0.0000	0.0000;
	1725	1	4.085	1.282	0	0	1	1.0952009	-11.504193	110	3	1.12	0.95	92.5907	0.0667	0.0000	0.0000;
	1726	1	0	0	0	0	1	1.0954217	-11.601304	110	3	1.12	0.95	92.6079	0.0398	0.0000	0.0000;
	1727	1	0	0	0	0	1	1.0953209	-11.49465	110	3	1.12	0.95	92.5807	0.0637	0.0000	0.0000;
	1728	1	9.839	2.502	0	0	1	1.0662263	-17.09544	110	3	1.12	0.95	97.5648	0.3592	0.0000	0.0000;
	1729	1	0	0	0	0	1	1.0662238	-17.096401	110	3	1.12	0.95	97.5661	0.3593	0.0000	0.0000;
	1730	1	8.502	2.673	0	0	1	1.0989998	-11.045163	110	3	1.12	0.95	92.0954	0.0141	0.0000	0.0000;
	1731	1	0	0	0	0	1	1.0989822	-11.051219	110	3	1.12	0.95	92.0979	0.0140	0.0000	0.0000;
	1732	1	2.948	0.927	0	0	1	1.0893739	-11.551355	110	3	1.12	0.95	92.9267	-0.0415	0.0000	0.0000;
	1733	1	0	0	0	0	1	1.0893773	-11.539458	110	3	1.12	0.95	92.9227	-0.0402	0.0000	0.0000;
	1734	1	2.268	1.175	0	0	1	1.0954318	-11.374053	110	3	1.12	0.95	92.4862	0.0701	0.0000	0.0000;
	1735	1	7.371	2.146	0	0	1	1.0704473	-15.675564	110	3	1.12	0.95	95.6327	0.5919	0.0000	0.0000;
	1736	1	0	0	0	0	1	1.0923747	-12.344036	110	3	1.12	0.95	93.1749	-0.0751	0.0000	0.0000;
	1737	1	10.426	0.324	0	0	1	1.0869484	-8.6822475	110	3	1.12	0.95	92.3523	0.1156	0.0000	0.0000;
	1738	1	0	0	0	0	1	1.0869448	-8.6827648	110	3	1.12	0.95	92.3516	0.1157	0.0000	0.0000;
	1739	1	11.345	2.423	0	0	1	1.0871312	-13.046929	110	3	1.12	0.95	93.7579	0.1665	0.0000	0.0000;
	1740	1	0	0	0	0	1	1.0884403	-12.118938	110	3	1.12	0.95	93.3119	-0.0016	0.0000	0.0000;
	1741	1	5.289	1.888	0	0	1	1.0510696	-17.741897	110	3	1.12	0.95	96.9725	-0.3700	0.0000	0.0000;
	1742	2	6.463	1.841	0	0	1	1.0511105	-17.742083	110	3	1.12	0.95	96.9722	-0.3680	0.0000	0.0000;
	1743	1	3.176	0.76	0	0	1	1.0927997	-11.407088	110	3	1.12	0.95	93.2899	-0.5994	0.0000	0.0000;
	1744	1	7.711	1.661	0	0	1	1.0924214	-11.433004	110	3	1.12	0.95	93.3360	-0.5879	0.0000	0.0000;
	1745	1	9.065	2.43	0	0	1	1.0465862	-16.838437	110	3	1.12	0.95	97.2965	-0.2218	0.0000	0.0000;
	1746	1	7.932	1.62	0	0	1	1.0467294	-16.835838	110	3	1.12	0.95	97.2805	-0.2283	0.0000	0.0000;
	1747	1	0	0	0	0	1	1.0890851	-8.4336303	110	3	1.12	0.95	92.0575	0.0870	0.0000	0.0000;
	1748	1	1.815	0.065	0	0	1	1.0890686	-8.4385126	110	3	1.12	0.95	92.0578	0.0872	0.0000	0.0000;
	1749	2	8.549	1.715	0	0	1	1.076296	-15.34969	110	3	1.12	0.95	95.1513	0.7336	0.0000	0.0000;
	1750	1	0	0	0	0	1	1.0762913	-15.364268	110	3	1.12	0.95	95.1504	0.7325	0.0000	0.0000;
	1751	1	7.262	1.81	0	0	1	1.0563237	-18.200647	110	3	1.12	0.95	97.2538	-0.5569	0.0000	0.0000;
	1752	1	0.759	0.135	0	0	1	1.0563404	-18.19426	110	3	1.12	0.95	97.2503	-0.5573	0.0000	0.0000;
	1753	1	4.54	0.149	0	0	1	1.0849827	-13.231901	110	3	1.12	0.95	94.3208	0.2823	0.0000	0.0000;
	1754	1	5.676	1.025	0	0	1	1.0849895	-13.22299	110	3	1.12	0.95	94.3187	0.2824	0.0000	0.0000;
	1755	1	6.978	5.718	0	0	1	1.0616215	-16.856096	110	3	1.12	0.95	97.3824	0.3981	0.0000	0.0000;
	1756	1	0	0	0	0	1	1.0616606	-16.846033	110	3	1.12	0.95	97.3822	0.3982	0.0000	0.0000;
	1757	1	5.901	0.276	0	0	1	1.0950744	-7.1962502	110	3	1.12	0.95	90.9917	0.0665	0.0000	0.0000;
	1758	1	2.835	-0.02	0	0	1	1.0949885	-7.2258111	110	3	1.12	0.95	91.0062	0.0674	0.0000	0.0000;
	1759	1	0	0	0	0	1	1.0933168	-13.642676	110	3	1.12	0.95	93.4380	0.3395	0.0000	0.0000;
	1760	2	1.35	2.824	0	0	1	1.0931699	-13.658958	110	3	1.12	0.95	93.4427	0.3420	0.0000	0.0000;
	1761	1	2.608	0.12	0	0	1	1.0933653	-7.7454249	110	3	1.12	0.95	91.2737	0.0656	0.0000	0.0000;
	1762	1	8.061	-0.39	0	0	1	1.0932962	-7.7445107	110	3	1.12	0.95	91.2903	0.0635	0.0000	0.0000;
	1763	1	7.383	0.382	0	0	1	1.0923638	-12.343852	110	3	1.12	0.95	93.1749	-0.0745	0.0000	0.0000;
	1764	1	9.092	0.991	0	0	1	1.0923961	-12.344468	110	3	1.12	0.95	93.1711	-0.0735	0.0000	0.0000;
	1765	1	0	0	0	0	1	1.0716799	-16.097423	110	3	1.12	0.95	95.8183	-0.1217	0.0000	0.0000;
	1766	1	0	0	0	0	1	1.0716158	-16.110938	110	3	1.12	0.95	95.8247	-0.1224	0.0000	0.0000;
	1767	1	2.267	0.482	0	0	1	1.0617736	-16.154862	110	3	1.12	0.95	95.2498	-0.4958	0.0000	0.0000;
	1768	1	0	0	0	0	1	1.0592074	-16.022898	110	3	1.12	0.95	95.1760	-0.3272	0.0000	0.0000;
	1769	1	3.404	0.126	0	0	1	1.0864205	-12.670377	110	3	1.12	0.95	93.8451	0.2217	0.0000	0.0000;
	1770	1	0	0	0	0	1	1.0864372	-12.678461	110	3	1.12	0.95	93.8436	0.2214	0.0000	0.0000;
	1771	1	1.132	0.231	-1.089	0	1	1.0696148	-15.425246	110	3	1.12	0.95	96.2694	0.3997	0.0000	0.0000;
	1772	1	0	0	0	0	1	1.0696156	-15.422625	110	3	1.12	0.95	96.2719	0.4011	0.0000	0.0000;
	1773	1	0	0	0	0	1	1.0971674	-11.263683	110	3	1.12	0.95	92.3341	0.0278	0.0000	0.0000;
	1774	2	10.415	5.903	0	0	1	1.0971963	-11.259861	110	3	1.12	0.95	92.3313	0.0275	0.0000	0.0000;
	1775	1	9.068	1.466	0	0	1	1.0987271	-11.152418	110	3	1.12	0.95	92.1798	0.0052	0.0000	0.0000;
	1776	1	0	0	0	0	1	1.098755	-11.138535	110	3	1.12	0.95	92.1759	0.0051	0.0000	0.0000;
	1777	1	12.64	2.257	0	0	1	1.0620747	-17.976056	110	3	1.12	0.95	97.7534	-0.1841	0.0000	0.0000;
	1778	1	0	0	0	0	1	1.0620197	-17.976968	110	3	1.12	0.95	97.7618	-0.1828	0.0000	0.0000;
	1779	2	26.969	7.938	0	0	1	1.0896679	-11.831779	110	3	1.12	0.95	93.0332	0.0128	0.0000	0.0000;
	1780	1	0	0	0	0	1	1.0897655	-11.81762	110	3	1.12	0.95	93.0273	0.0121	0.0000	0.0000;
	1781	1	2.493	0.324	0	0	1	1.0965607	-11.312526	110	3	1.12	0.95	92.4067	0.0368	0.0000	0.0000;
	1782	1	0	0	0	0	1	1.0965906	-11.308705	110	3	1.12	0.95	92.4040	0.0366	0.0000	0.0000;
	1783	1	6.572	1.296	0	0	1	1.1012807	-11.448447	110	3	1.12	0.95	91.9105	0.0774	0.0000	0.0000;
	1784	1	0	0	0	0	1	1.1014429	-11.432245	110	3	1.12	0.95	91.8940	0.0742	0.0000	0.0000;
	1785	1	5.218	2.427	0	0	1	1.0965393	-11.315268	110	3	1.12	0.95	92.4061	0.0390	0.0000	0.0000;
	1786	1	0	0	0	0	1	1.0965714	-11.312183	110	3	1.12	0.95	92.4042	0.0387	0.0000	0.0000;
	1787	1	6.238	1.317	0	0	1	1.0908318	-11.989542	110	3	1.12	0.95	93.1195	-0.0404	0.0000	0.0000;
	1788	1	6.803	1.336	0	0	1	1.0908184	-11.96022	110	3	1.12	0.95	93.1691	-0.0944	0.0000	0.0000;
	1789	1	0	0	0	0	1	1.0911535	-11.973857	110	3	1.12	0.95	93.0768	-0.0491	0.0000	0.0000;
	1790	1	0	0	0	0	1	1.0911399	-11.945204	110	3	1.12	0.95	93.1251	-0.1028	0.0000	0.0000;
	1791	1	4.079	0.89	0	0	1	1.0601836	-16.13546	110	3	1.12	0.95	95.3225	-0.4766	0.0000	0.0000;
	1792	1	0	0	0	0	1	1.060235	-16.141248	110	3	1.12	0.95	95.3228	-0.4761	0.0000	0.0000;
	1793	1	1.133	0.314	0	0	1	1.0906249	-8.337961	110	3	1.12	0.95	91.7639	0.0769	0.0000	0.0000;
	1794	1	0	0	0	0	1	1.0906361	-8.3352114	110	3	1.12	0.95	91.7622	0.0767	0.0000	0.0000;
	1795	1	0	0	0	0	1	1.0637671	-16.322227	110	3	1.12	0.95	95.3859	-0.6023	0.0000	0.0000;
	1796	1	0	0	0	0	1	1.0635076	-16.33688	110	3	1.12	0.95	95.3973	-0.5963	0.0000	0.0000;
	1797	1	6.8	3.24	0	0	1	1.1033566	-11.838739	110	3	1.12	0.95	92.5343	-0.3327	0.0000	0.0000;
	1798	2	10.189	5.66	0	0	1	1.0975048	-11.368377	110	3	1.12	0.95	92.6281	-0.4214	0.0000	0.0000;
	1799	2	12.997	10.583	0	0	1	1.0835211	-14.580846	110	3	1.12	0.95	94.3658	0.2664	0.0000	0.0000;
	1800	1	4.655	2.315	0	0	1	1.0833742	-14.594949	110	3	1.12	0.95	94.3697	0.2681	0.0000	0.0000;
	1801	1	11.705	5.789	0	0	1	1.0837887	-14.467417	110	3	1.12	0.95	94.2522	0.2950	0.0000	0.0000;
	1802	1	10.015	5.119	0	0	1	1.083747	-14.478298	110	3	1.12	0.95	94.2559	0.2947	0.0000	0.0000;
	1803	1	2.949	1.412	0	0	1	1.0993267	-10.715022	110	3	1.12	0.95	92.2848	0.0423	0.0000	0.0000;
	1804	1	3.405	1.675	0	0	1	1.0961597	-11.337132	110	3	1.12	0.95	92.4494	0.0460	0.0000	0.0000;
	1805	1	0	0	0	0	1	1.0993558	-10.713618	110	3	1.12	0.95	92.2826	0.0412	0.0000	0.0000;
	1806	1	5.896	1.336	0	0	1	1.0886528	-12.839597	110	3	1.12	0.95	93.4877	0.1996	0.0000	0.0000;
	1807	1	3.968	1.336	0	0	1	1.088625	-12.845122	110	3	1.12	0.95	93.4905	0.1995	0.0000	0.0000;
	1808	1	6.926	0.972	0	0	1	1.0834696	-14.515078	110	3	1.12	0.95	94.7231	0.0753	0.0000	0.0000;
	1809	1	8.504	1.53	0	0	1	1.0809467	-15.039015	110	3	1.12	0.95	95.1369	0.0677	0.0000	0.0000;
	1810	1	3.175	0.107	0	0	1	1.0605729	-16.716078	110	3	1.12	0.95	95.8155	-0.5520	0.0000	0.0000;
	1811	1	0	0	0	0	1	1.0606084	-16.707411	110	3	1.12	0.95	95.8125	-0.5524	0.0000	0.0000;
	1812	1	3.403	-0.692	0	0	1	1.0851358	-9.7068669	110	3	1.12	0.95	92.9116	-0.1197	0.0000	0.0000;
	1813	1	0	0	0	0	1	1.0851358	-9.7068669	110	3	1.12	0.95	92.9116	-0.1197	0.0000	0.0000;
	1814	1	8.166	3.767	0	0	1	1.0804663	-14.806315	110	3	1.12	0.95	94.6894	0.3333	0.0000	0.0000;
	1815	1	5.669	2.713	0	0	1	1.080323	-14.829134	110	3	1.12	0.95	94.6981	0.3337	0.0000	0.0000;
	1816	1	10.923	2.581	0	0	1	1.0631498	-16.312212	110	3	1.12	0.95	96.7041	0.9989	0.0000	0.0000;
	1817	1	0	0	0	0	1	1.0630517	-16.319311	110	3	1.12	0.95	96.7029	1.0017	0.0000	0.0000;
	1818	1	4.629	1.196	0	0	1	1.0733183	-15.876604	110	3	1.12	0.95	95.8239	0.3441	0.0000	0.0000;
	1819	1	0	0	0	0	1	1.073693	-15.86107	110	3	1.12	0.95	95.7722	0.3318	0.0000	0.0000;
	1820	1	2.157	0.644	0	0	1	1.0887455	-12.881743	110	3	1.12	0.95	93.6091	0.1134	0.0000	0.0000;
	1821	1	0	0	0	0	1	1.0887481	-12.881596	110	3	1.12	0.95	93.6089	0.1133	0.0000	0.0000;
	1822	1	0	0	0	0	1	1.0768317	-14.85998	110	3	1.12	0.95	94.5944	0.0309	0.0000	0.0000;
	1823	1	0	0	0	0	1	1.0758612	-15.01881	110	3	1.12	0.95	95.0724	0.0030	0.0000	0.0000;
	1824	1	11.513	2.193	0	0	1	1.0760851	-16.31412	110	3	1.12	0.95	96.4438	0.0886	0.0000	0.0000;
	1825	1	0	0	0	0	1	1.0761205	-16.311506	110	3	1.12	0.95	96.4434	0.0880	0.0000	0.0000;
	1826	1	5.216	2.426	0	0	1	1.0911563	-11.700642	110	3	1.12	0.95	92.8627	-0.0004	0.0000	0.0000;
	1827	1	0	0	0	0	1	1.0911932	-11.707321	110	3	1.12	0.95	92.8622	-0.0001	0.0000	0.0000;
	1828	1	9.32	1.199	0	0	1	1.0782916	-14.797764	110	3	1.12	0.95	94.7907	-0.0139	0.0000	0.0000;
	1829	1	14.304	2.4	0	0	1	1.0782849	-14.820195	110	3	1.12	0.95	94.7996	-0.0139	0.0000	0.0000;
	1830	1	0	0	0	0	1	1.0791237	-9.5195664	110	3	1.12	0.95	93.7963	0.2324	0.0000	0.0000;
	1831	1	11.844	5.851	0	0	1	1.0790436	-9.5156349	110	3	1.12	0.95	93.8028	0.2327	0.0000	0.0000;
	1832	1	3.859	1.854	0	0	1	1.0995955	-10.648701	110	3	1.12	0.95	92.2488	0.0403	0.0000	0.0000;
	1833	1	6.235	2.876	0	0	1	1.0964983	-11.055969	110	3	1.12	0.95	92.6869	0.0964	0.0000	0.0000;
	1834	1	0	0	0	0	1	1.0965197	-11.054256	110	3	1.12	0.95	92.6859	0.0960	0.0000	0.0000;
	1835	1	10.22	3.579	0	0	1	1.065471	-17.168654	110	3	1.12	0.95	97.7234	0.3635	0.0000	0.0000;
	1836	1	0	0	0	0	1	1.0654796	-17.167725	110	3	1.12	0.95	97.7221	0.3634	0.0000	0.0000;
	1837	1	13.725	4.168	0	0	1	1.0994089	-11.728522	110	3	1.12	0.95	92.5878	-0.1431	0.0000	0.0000;
	1838	1	0	0	0	0	1	1.0995122	-11.729976	110	3	1.12	0.95	92.5857	-0.1443	0.0000	0.0000;
	1839	1	3.513	0.81	0	0	1	1.0903217	-12.683718	110	3	1.12	0.95	93.3528	0.1138	0.0000	0.0000;
	1840	1	0	0	0	0	1	1.0902797	-12.685054	110	3	1.12	0.95	93.3541	0.1142	0.0000	0.0000;
	1841	2	17.533	31.025	0	0	1	1.1074873	-10.76675	110	3	1.12	0.95	91.1600	0.0000	0.0000	0.0000;
	1842	1	0	0	0	0	1	1.1005234	-12.839838	110	3	1.12	0.95	92.6427	0.2183	0.0000	0.0000;
	1843	2	12.999	28.999	0	0	1	1.1065323	-11.874656	110	3	1.12	0.95	91.7595	0.1706	0.0000	0.0000;
	1844	1	0	0.065	0	0	1	1.0936065	-11.462021	110	3	1.12	0.95	93.1160	0.1191	0.0000	0.0000;
	1845	1	2.042	0.981	0	0	1	1.0936729	-11.453883	110	3	1.12	0.95	93.1145	0.1182	0.0000	0.0000;
	1846	1	5.006	1.224	0	0	1	1.0619588	-16.429756	110	3	1.12	0.95	96.8306	1.0264	0.0000	0.0000;
	1847	2	7.026	2.172	0	0	1	1.0971332	-11.387682	110	3	1.12	0.95	92.6496	-0.4096	0.0000	0.0000;
	1848	1	9.942	1.451	0	0	1	1.0663761	-16.657693	110	3	1.12	0.95	96.7610	-0.0982	0.0000	0.0000;
	1849	2	5.871	1.288	0	0	1	1.0663541	-16.671648	110	3	1.12	0.95	96.7613	-0.1003	0.0000	0.0000;
	1850	1	20.75	5.021	0	0	1	1.0810605	-15.047918	110	3	1.12	0.95	95.1506	0.0582	0.0000	0.0000;
	1851	1	0	0	0	0	1	1.0810544	-15.047594	110	3	1.12	0.95	95.1502	0.0582	0.0000	0.0000;
	1852	2	0	0	0	0	1	1.0959707	-11.150916	110	3	1.12	0.95	92.8227	0.0871	0.0000	0.0000;
	1853	1	3.405	1.675	0	0	1	1.0959495	-11.15936	110	3	1.12	0.95	92.8255	0.0872	0.0000	0.0000;
	1854	1	10.218	2.087	0	0	1	1.084744	-14.316691	110	3	1.12	0.95	94.2725	0.6050	0.0000	0.0000;
	1855	1	9.083	2.605	0	0	1	1.08473	-14.323929	110	3	1.12	0.95	94.2733	0.6051	0.0000	0.0000;
	1856	1	4.13	0.392	0	0	1	1.0802603	-14.607519	110	3	1.12	0.95	94.9826	-0.0058	0.0000	0.0000;
	1857	1	3.191	0.619	0	0	1	1.0802463	-14.614933	110	3	1.12	0.95	94.9817	-0.0067	0.0000	0.0000;
	1858	1	18.377	2.517	-1.089	0	1	1.0696688	-15.413212	110	3	1.12	0.95	96.2731	0.4033	0.0000	0.0000;
	1859	1	0	0	0	0	1	1.0697019	-15.403604	110	3	1.12	0.95	96.2730	0.4025	0.0000	0.0000;
	1860	1	0	0	0	0	1	1.0863099	-13.336895	110	3	1.12	0.95	94.0554	-0.0283	0.0000	0.0000;
	1861	1	11.357	2.127	0	0	1	1.0825835	-14.937977	110	3	1.12	0.95	95.0351	0.0143	0.0000	0.0000;
	1862	1	0	0	0	0	1	1.1017749	-10.383738	110	3	1.12	0.95	92.0463	0.0011	0.0000	0.0000;
	1863	1	8.957	-1.013	0	0	1	1.0934448	-11.440449	110	3	1.12	0.95	93.1675	-0.5726	0.0000	0.0000;
	1864	1	1.247	0.121	0	0	1	1.1015569	-11.512207	110	3	1.12	0.95	92.3900	-0.5034	0.0000	0.0000;
	1865	2	4.523	1.132	0	0	1	1.051029	-17.749611	110	3	1.12	0.95	96.9866	-0.3713	0.0000	0.0000;
	1866	1	1.373	-1.375	0	0	1	1.0510395	-17.749738	110	3	1.12	0.95	96.9865	-0.3714	0.0000	0.0000;
	1867	1	11.339	2.467	0	0	1	1.0567057	-17.689565	110	3	1.12	0.95	97.9229	-0.2180	0.0000	0.0000;
	1868	1	0	0	0	0	1	1.056752	-17.680121	110	3	1.12	0.95	97.9223	-0.2146	0.0000	0.0000;
	1869	1	0.566	0.218	0	0	1	1.0926147	-11.783628	110	3	1.12	0.95	93.1000	-0.3352	0.0000	0.0000;
	1870	1	0	0	0	0	1	1.0925329	-11.795104	110	3	1.12	0.95	93.1048	-0.3349	0.0000	0.0000;
	1871	1	0.794	0.486	0	0	1	1.0804482	-14.902187	110	3	1.12	0.95	94.7753	0.2212	0.0000	0.0000;
	1872	1	1.813	0.729	0	0	1	1.0803112	-14.914502	110	3	1.12	0.95	94.7921	0.2246	0.0000	0.0000;
	1873	1	0	0	0	0	1	1.0903165	-13.766513	110	3	1.12	0.95	93.7000	0.4308	0.0000	0.0000;
	1874	1	0	0	0	0	1	1.0863952	-12.339939	110	3	1.12	0.95	93.8656	-0.2483	0.0000	0.0000;
	1875	1	0	0	0	0	1	1.0863653	-12.346024	110	3	1.12	0.95	93.8765	-0.2485	0.0000	0.0000;
	1876	1	0	0	0	0	1	1.0583958	-16.457433	110	3	1.12	0.95	96.8616	1.3356	0.0000	0.0000;
	1877	2	27.196	14.579	0	0	1	1.0890877	-12.694761	110	3	1.12	0.95	93.4071	0.1568	0.0000	0.0000;
	1878	2	1.999	6.499	0	0	1	1.0930536	-11.620215	110	3	1.12	0.95	92.7795	-0.0861	0.0000	0.0000;
	1879	1	3.406	0.94	0	0	1	1.089785	-11.877933	110	3	1.12	0.95	93.3604	0.2207	0.0000	0.0000;
	1880	1	5.108	1.405	0	0	1	1.0980082	-10.88053	110	3	1.12	0.95	92.4294	0.0672	0.0000	0.0000;
	1881	1	0	0	0	0	1	1.089789	-11.877699	110	3	1.12	0.95	93.3599	0.2206	0.0000	0.0000;
	1882	1	0	0	0	0	1	1.0980142	-10.880183	110	3	1.12	0.95	92.4287	0.0670	0.0000	0.0000;
	1883	1	7.595	1.518	0	0	1	1.0982496	-10.74881	110	3	1.12	0.95	92.7298	-0.9108	0.0000	0.0000;
	1884	1	0	0	0	0	1	1.098261	-10.738666	110	3	1.12	0.95	92.7339	-0.9139	0.0000	0.0000;
	1885	2	9.184	0.27	0	0	1	1.0991855	-6.7693723	110	3	1.12	0.95	90.3362	0.0386	0.0000	0.0000;
	1886	1	7.376	-0.555	0	0	1	1.0991313	-6.7944111	110	3	1.12	0.95	90.3423	0.0397	0.0000	0.0000;
	1887	1	8.612	2.916	0	0	1	1.0890895	-12.759293	110	3	1.12	0.95	93.4478	0.1499	0.0000	0.0000;
	1888	1	17.904	6.155	0	0	1	1.0891297	-12.758903	110	3	1.12	0.95	93.4464	0.1496	0.0000	0.0000;
	1889	1	12.631	3.016	0	0	1	1.0720942	-16.23148	110	3	1.12	0.95	95.9302	0.1307	0.0000	0.0000;
	1890	1	0	0	0	0	1	1.072113	-16.222058	110	3	1.12	0.95	95.9287	0.1324	0.0000	0.0000;
	1891	1	4.741	0.325	0	0	1	1.0740295	-15.734632	110	3	1.12	0.95	95.5135	0.1672	0.0000	0.0000;
	1892	1	0	0	0	0	1	1.0740119	-15.733767	110	3	1.12	0.95	95.5142	0.1694	0.0000	0.0000;
	1893	1	4.428	1.711	0	0	1	1.0910312	-12.096737	110	3	1.12	0.95	93.5158	-0.1893	0.0000	0.0000;
	1894	1	0	0	0	0	1	1.0888563	-8.5095499	110	3	1.12	0.95	92.2077	0.0655	0.0000	0.0000;
	1895	1	2.153	1.215	0	0	1	1.0940552	-13.504503	110	3	1.12	0.95	93.4109	0.3195	0.0000	0.0000;
	1896	1	4.986	2.673	0	0	1	1.0939272	-13.516997	110	3	1.12	0.95	93.4161	0.3217	0.0000	0.0000;
	1897	1	6.188	1.289	0	0	1	1.0776432	-15.037518	110	3	1.12	0.95	95.2222	-0.0284	0.0000	0.0000;
	1898	1	4.821	0.002	0	0	1	1.0776471	-15.041185	110	3	1.12	0.95	95.2201	-0.0295	0.0000	0.0000;
	1899	1	2.156	0.316	0	0	1	1.0837474	-8.9063972	110	3	1.12	0.95	92.4719	0.2677	0.0000	0.0000;
	1900	1	1.133	0.203	0	0	1	1.0838064	-8.9096501	110	3	1.12	0.95	92.4704	0.2668	0.0000	0.0000;
	1901	1	16.716	3.758	0	0	1	1.0858265	-12.378146	110	3	1.12	0.95	93.8319	-0.2724	0.0000	0.0000;
	1902	1	0	0	0	0	1	1.0858676	-12.374863	110	3	1.12	0.95	93.8312	-0.2749	0.0000	0.0000;
	1903	1	0.678	0.323	0	0	1	1.0944431	-11.373668	110	3	1.12	0.95	93.0058	0.1088	0.0000	0.0000;
	1904	1	0	0	0	0	1	1.0944538	-11.373015	110	3	1.12	0.95	93.0051	0.1085	0.0000	0.0000;
	1905	1	10.992	0.324	0	0	1	1.0749866	-15.317251	110	3	1.12	0.95	95.2474	0.4641	0.0000	0.0000;
	1906	1	7.819	1.539	0	0	1	1.0748946	-15.329068	110	3	1.12	0.95	95.2516	0.4655	0.0000	0.0000;
	1907	1	7.204	-0.196	0	0	1	1.0686577	-16.066857	110	3	1.12	0.95	96.3613	0.3908	0.0000	0.0000;
	1908	1	0	0	0	0	1	1.0686666	-16.057762	110	3	1.12	0.95	96.3594	0.3902	0.0000	0.0000;
	1909	1	3.358	0.993	0	0	1	1.0859025	-12.359371	110	3	1.12	0.95	93.8129	-0.2592	0.0000	0.0000;
	1910	1	0	0	0	0	1	1.0859124	-12.354782	110	3	1.12	0.95	93.8111	-0.2573	0.0000	0.0000;
	1911	2	19.254	1.61	0	0	1	1.0845405	-14.061382	110	3	1.12	0.95	94.1878	0.6510	0.0000	0.0000;
	1912	2	15.855	0.8	0	0	1	1.0845334	-14.061384	110	3	1.12	0.95	94.1897	0.6512	0.0000	0.0000;
	1913	1	0	0	0	0	1	1.0845401	-14.060934	110	3	1.12	0.95	94.1868	0.6515	0.0000	0.0000;
	1914	1	0	0	0	0	1	1.0845401	-14.060934	110	3	1.12	0.95	94.1868	0.6515	0.0000	0.0000;
	1915	1	2.268	0.095	0	0	1	1.0902096	-13.783159	110	3	1.12	0.95	93.7177	0.4310	0.0000	0.0000;
	1916	1	2.268	0.095	0	0	1	1.1055131	-12.050493	110	3	1.12	0.95	91.9380	0.1681	0.0000	0.0000;
	1917	1	0	0	0	0	1	1.0903024	-13.768248	110	3	1.12	0.95	93.7015	0.4310	0.0000	0.0000;
	1918	1	11.933	2.928	0	0	1	1.0862493	-12.313017	110	3	1.12	0.95	93.7872	-0.2725	0.0000	0.0000;
	1919	1	0	0	0	0	1	1.086281	-12.299433	110	3	1.12	0.95	93.7851	-0.2702	0.0000	0.0000;
	1920	1	11.361	3.446	0	0	1	1.0858694	-12.363435	110	3	1.12	0.95	93.8277	-0.2688	0.0000	0.0000;
	1921	1	0	0	0	0	1	1.0858811	-12.360627	110	3	1.12	0.95	93.8260	-0.2678	0.0000	0.0000;
	1922	1	1.701	0.224	0	0	1	1.0825788	-13.225687	110	3	1.12	0.95	94.5317	-0.7609	0.0000	0.0000;
	1923	1	0	0	0	0	1	1.082581	-13.218308	110	3	1.12	0.95	94.5301	-0.7572	0.0000	0.0000;
	1924	1	1.7	0.688	0	0	1	1.0950063	-11.206034	110	3	1.12	0.95	93.0451	-0.6026	0.0000	0.0000;
	1925	1	11.227	1.721	0	0	1	1.094512	-11.24967	110	3	1.12	0.95	93.1132	-0.5935	0.0000	0.0000;
	1926	1	3.288	1.58	0	0	1	1.0896476	-13.944339	110	3	1.12	0.95	93.6507	0.1796	0.0000	0.0000;
	1927	1	4.31	2.097	0	0	1	1.0897415	-13.928658	110	3	1.12	0.95	93.6447	0.1789	0.0000	0.0000;
	1928	1	3.738	1.376	0	0	1	1.0981944	-10.853783	110	3	1.12	0.95	92.5154	0.0636	0.0000	0.0000;
	1929	1	0	0	0	0	1	1.0981537	-10.86352	110	3	1.12	0.95	92.5186	0.0641	0.0000	0.0000;
	1930	2	19.923	4.178	0	0	1	1.0676088	-17.014798	110	3	1.12	0.95	97.3583	0.3276	0.0000	0.0000;
	1931	1	0	0	0	0	1	1.0727509	-16.542667	110	3	1.12	0.95	97.1436	0.1413	0.0000	0.0000;
	1932	2	7.86	6.44	0	0	1	1.1177457	-11.889665	110	4	1.12	0.95	92.8246	0.0000	0.0000	0.0000;
	1933	2	1.546	3.551	0	0	1	1.1143591	-12.273879	110	4	1.12	0.95	93.5807	-0.0000	0.0000	0.0000;
	1934	1	6.379	1.859	0	0	1	1.1171542	-11.939576	110	4	1.12	0.95	92.9258	0.0083	0.0000	0.0000;
	1935	1	12.005	2.39	0	0	1	1.1163517	-12.016177	110	4	1.12	0.95	93.0778	0.0151	0.0000	0.0000;
	1936	1	8.397	0.53	0	0	1	1.0700491	-24.683811	110	4	1.12	0.95	100.4713	-1.9927	0.0000	0.0000;
	1937	1	4.334	0.921	0	0	1	1.075601	-20.07812	110	4	1.12	0.95	99.1404	1.0095	0.0000	0.0000;
	1938	1	0	0	0	0	1	1.0671967	-24.916125	110	4	1.12	0.95	101.2511	-1.3778	0.0000	0.0000;
	1939	1	4.516	-0.679	0	0	1	1.0549404	-25.270878	110	4	1.12	0.95	101.9316	-0.8117	0.0000	0.0000;
	1940	1	0.46	-0.369	0	0	1	1.1004092	-14.440199	110	4	1.12	0.95	95.7238	0.2025	0.0000	0.0000;
	1941	1	5.248	0.542	0	0	1	1.0757489	-17.713021	110	4	1.12	0.95	95.5826	0.0866	0.0000	0.0000;
	1942	1	0	0.059	0	0	1	1.0757484	-17.713019	110	4	1.12	0.95	95.5826	0.0866	0.0000	0.0000;
	1943	1	4.056	-0.203	0	0	1	1.0594429	-25.409379	110	4	1.12	0.95	102.7416	-1.4550	0.0000	0.0000;
	1944	1	10.876	1.234	0	0	1	1.0783753	-14.998892	110	4	1.12	0.95	94.1023	-0.3108	0.0000	0.0000;
	1945	1	8.844	1.254	0	0	1	1.0530066	-25.380662	110	4	1.12	0.95	101.7902	-1.4626	0.0000	0.0000;
	1946	1	5.394	-0.249	0	0	1	1.0698677	-25.081449	110	4	1.12	0.95	100.6777	-1.9305	0.0000	0.0000;
	1947	1	0	0	0	0	1	1.0698744	-25.092412	110	4	1.12	0.95	100.6771	-1.9297	0.0000	0.0000;
	1948	1	6.082	1.657	0	0	1	1.0655568	-25.006466	110	4	1.12	0.95	102.0073	-1.6010	0.0000	0.0000;
	1949	2	3.017	0.102	0	0	1	1.0832249	-15.351646	110	4	1.12	0.95	94.7326	-0.2983	0.0000	0.0000;
	1950	1	5.536	0.176	0	0	1	1.083216	-15.357535	110	4	1.12	0.95	94.7330	-0.2988	0.0000	0.0000;
	1951	1	6.451	0.488	0	0	1	1.0823933	-15.443272	110	4	1.12	0.95	94.7820	-0.3006	0.0000	0.0000;
	1952	2	1.626	-0.555	0	0	1	1.0791545	-17.070768	110	4	1.12	0.95	95.0267	-0.0697	0.0000	0.0000;
	1953	1	3.686	0.424	0	0	1	1.0791484	-17.072249	110	4	1.12	0.95	95.0272	-0.0696	0.0000	0.0000;
	1954	1	15.469	0.696	0	0	1	1.0685334	-25.227914	110	4	1.12	0.95	101.0075	-2.1581	0.0000	0.0000;
	1955	1	3.871	0.585	0	0	1	1.0746342	-17.905008	110	4	1.12	0.95	95.7515	0.1399	0.0000	0.0000;
	1956	1	2.948	0.347	0	0	1	1.0738096	-17.955633	110	4	1.12	0.95	95.7871	0.1530	0.0000	0.0000;
	1957	1	5.127	0.459	0	0	1	1.0481394	-21.815387	110	4	1.12	0.95	100.8725	-1.1109	0.0000	0.0000;
	1958	1	7.467	0.741	0	0	1	1.0486746	-24.490006	110	4	1.12	0.95	100.3743	-0.2473	0.0000	0.0000;
	1959	1	1.109	-0.956	0	0	1	1.0488893	-26.160933	110	4	1.12	0.95	102.9413	-0.9258	0.0000	0.0000;
	1960	1	6.452	0.486	0	0	1	1.0552035	-22.47285	110	4	1.12	0.95	99.5816	-0.3486	0.0000	0.0000;
	1961	1	0.645	-0.029	0	0	1	1.0703902	-23.452408	110	4	1.12	0.95	99.6555	-0.8824	0.0000	0.0000;
	1962	2	5.805	-0.115	0	0	1	1.0835389	-14.813407	110	4	1.12	0.95	94.3885	-0.0851	0.0000	0.0000;
	1963	1	3.226	0.342	0	0	1	1.0792061	-17.681956	110	4	1.12	0.95	95.3217	-0.0039	0.0000	0.0000;
	1964	1	0	0	0	0	1	1.0688765	-23.637077	110	4	1.12	0.95	100.9424	-1.5963	0.0000	0.0000;
	1965	1	3.359	-0.054	0	0	1	1.0706662	-25.732764	110	4	1.12	0.95	101.3512	-2.2462	0.0000	0.0000;
	1966	1	4.054	-1.218	0	0	1	1.0490496	-24.907614	110	4	1.12	0.95	101.1042	-0.6082	0.0000	0.0000;
	1967	2	4.606	-0.027	0	0	1	1.0714354	-17.878291	110	4	1.12	0.95	96.4317	-0.0598	0.0000	0.0000;
	1968	1	0	0.045	0	0	1	1.0714351	-17.87829	110	4	1.12	0.95	96.4317	-0.0598	0.0000	0.0000;
	1969	2	1.865	4.133	0	0	1	1.0816473	-13.399441	110	4	1.12	0.95	92.8959	-0.1672	0.0000	0.0000;
	1970	2	0	0	0	0	1	1.0829452	-14.253947	110	4	1.12	0.95	92.7919	-0.5673	0.0000	0.0000;
	1971	1	1.845	-0.474	0	0	1	1.1075206	-13.63376	110	4	1.12	0.95	94.9015	0.0285	0.0000	0.0000;
	1972	1	11.934	0.145	0	0	1	1.0541846	-28.318733	110	4	1.12	0.95	103.5394	-2.0422	0.0000	0.0000;
	1973	1	4.426	-0.382	0	0	1	1.0638642	-24.79794	110	4	1.12	0.95	101.9971	-1.5470	0.0000	0.0000;
	1974	1	2.674	0.398	0	0	1	1.0735721	-17.958377	110	4	1.12	0.95	95.0538	-0.2307	0.0000	0.0000;
	1975	1	3.78	-0.299	0	0	1	1.0667619	-26.556184	110	4	1.12	0.95	102.5197	-2.1028	0.0000	0.0000;
	1976	1	2.305	0.081	0	0	1	1.0792855	-21.838369	110	4	1.12	0.95	98.4261	-0.1182	0.0000	0.0000;
	1977	1	5.623	0.551	0	0	1	1.0786234	-15.710571	110	4	1.12	0.95	94.7587	-0.3653	0.0000	0.0000;
	1978	1	0.707	-0.591	0	0	1	1.0716118	-24.42856	110	4	1.12	0.95	100.1743	-1.9367	0.0000	0.0000;
	1979	1	0	0	0	0	1	1.080132	-17.532924	110	4	1.12	0.95	95.1281	0.0079	0.0000	0.0000;
	1980	1	0	0	0	0	1	1.080132	-17.532924	110	4	1.12	0.95	95.1281	0.0079	0.0000	0.0000;
	1981	1	0	0	0	0	1	1.0749621	-17.841527	110	4	1.12	0.95	94.8227	-0.2388	0.0000	0.0000;
	1982	1	0	0	0	0	1	1.0762242	-15.566618	110	4	1.12	0.95	94.1237	-0.2061	0.0000	0.0000;
	1983	1	2.762	-0.392	0	0	1	1.0834501	-15.386465	110	4	1.12	0.95	94.7560	-0.2662	0.0000	0.0000;
	1984	1	3.318	-0.08	0	0	1	1.0578567	-27.329468	110	4	1.12	0.95	103.8505	-2.0228	0.0000	0.0000;
	1985	1	9.459	0.212	0	0	1	1.0698582	-24.786666	110	4	1.12	0.95	100.5734	-1.9783	0.0000	0.0000;
	1986	1	1.475	0.319	0	0	1	1.0546012	-25.439632	110	4	1.12	0.95	102.8312	-1.0269	0.0000	0.0000;
	1987	1	6.809	-0.309	0	0	1	1.0721384	-24.500538	110	4	1.12	0.95	100.2112	-1.9491	0.0000	0.0000;
	1988	1	1.659	0.159	0	0	1	1.0720845	-24.512849	110	4	1.12	0.95	100.2145	-1.9455	0.0000	0.0000;
	1989	1	6.63	0.761	0	0	1	1.0506885	-28.479722	110	4	1.12	0.95	104.4857	-2.1104	0.0000	0.0000;
	1990	1	7.466	0.396	0	0	1	1.0580563	-25.492897	110	4	1.12	0.95	102.2706	-1.5809	0.0000	0.0000;
	1991	1	2.672	-0.299	0	0	1	1.0716132	-23.643847	110	4	1.12	0.95	99.8688	-1.0219	0.0000	0.0000;
	1992	1	3.133	-0.252	0	0	1	1.0976348	-15.710503	110	4	1.12	0.95	96.8491	0.0475	0.0000	0.0000;
	1993	1	3.132	0.047	0	0	1	1.0595189	-27.339864	110	4	1.12	0.95	103.6844	-2.1175	0.0000	0.0000;
	1994	1	6.081	-0.032	0	0	1	1.0569099	-25.774891	110	4	1.12	0.95	103.0366	-1.3574	0.0000	0.0000;
	1995	1	3.045	1.718	0	0	1	1.0581313	-27.148476	110	4	1.12	0.95	103.6523	-1.9510	0.0000	0.0000;
	1996	2	6.438	4.809	0	0	1	1.0689279	-23.620601	110	4	1.12	0.95	100.9400	-1.5959	0.0000	0.0000;
	1997	1	0	0	0	0	1	1.0689279	-23.620601	110	4	1.12	0.95	100.9400	-1.5959	0.0000	0.0000;
	1998	1	1.381	0.092	0	0	1	1.0637161	-26.512357	110	4	1.12	0.95	102.5879	-1.8768	0.0000	0.0000;
	1999	1	2.718	-0.291	0	0	1	1.0637162	-26.513506	110	4	1.12	0.95	102.5883	-1.8768	0.0000	0.0000;
	2000	1	4.862	-0.26	0	0	1	1.0621675	-27.020471	110	4	1.12	0.95	103.0323	-2.0436	0.0000	0.0000;
	2001	1	2.304	0.002	0	0	1	1.0663175	-18.562745	110	4	1.12	0.95	97.4306	-0.0562	0.0000	0.0000;
	2002	2	5.159	0.713	0	0	1	1.0582674	-24.686322	110	4	1.12	0.95	101.7295	-0.8684	0.0000	0.0000;
	2003	1	0	0	0	0	1	1.0582674	-24.686322	110	4	1.12	0.95	101.7295	-0.8684	0.0000	0.0000;
	2004	1	4.701	0.507	0	0	1	1.075604	-17.974718	110	4	1.12	0.95	95.6914	-0.0293	0.0000	0.0000;
	2005	1	5.161	0.583	0	0	1	1.0789853	-17.040337	110	4	1.12	0.95	95.0312	-0.0657	0.0000	0.0000;
	2006	2	13.233	10.33	0	0	1	1.0712903	-24.378414	110	4	1.12	0.95	100.1632	-1.9062	0.0000	0.0000;
	2007	2	13.822	9.062	0	0	1	1.0715161	-24.416714	110	4	1.12	0.95	100.1690	-1.9346	0.0000	0.0000;
	2008	1	4.871	0.375	0	0	1	1.0700203	-24.962747	110	4	1.12	0.95	100.7360	-1.4871	0.0000	0.0000;
	2009	1	1.841	0.476	0	0	1	1.0629873	-27.519139	110	4	1.12	0.95	103.4192	-2.0424	0.0000	0.0000;
	2010	1	9.471	0.806	0	0	1	1.0727282	-25.113858	110	4	1.12	0.95	100.8012	-2.3216	0.0000	0.0000;
	2011	1	7.004	1.381	0	0	1	1.0635891	-25.645408	110	4	1.12	0.95	101.7470	-1.9405	0.0000	0.0000;
	2012	2	3.014	0.335	0	0	1	1.0561479	-28.737314	110	4	1.12	0.95	105.4353	-2.3904	0.0000	0.0000;
	2013	1	0.828	0.213	0	0	1	1.0497604	-25.657159	110	4	1.12	0.95	102.0318	-1.4919	0.0000	0.0000;
	2014	1	0	0	0	0	1	1.0495682	-25.666162	110	4	1.12	0.95	102.0342	-1.4894	0.0000	0.0000;
	2015	1	8.663	0.016	0	0	1	1.0721882	-24.504653	110	4	1.12	0.95	100.3549	-1.1030	0.0000	0.0000;
	2016	2	10.218	0.587	0	0	1	1.0697951	-24.953548	110	4	1.12	0.95	100.7751	-1.2746	0.0000	0.0000;
	2017	1	3.408	0.532	0	0	1	1.0697788	-24.966345	110	4	1.12	0.95	100.7793	-1.2805	0.0000	0.0000;
	2018	2	0.047	-0.215	0	0	1	1.0575051	-23.059913	110	4	1.12	0.95	100.0588	-1.0837	0.0000	0.0000;
	2019	2	0	0	0	0	1	1.0773241	-23.682665	110	4	1.12	0.95	99.9233	-1.4818	0.0000	0.0000;
	2020	2	2.486	0.478	0	0	1	1.0699014	-24.548891	110	4	1.12	0.95	100.7258	-1.3528	0.0000	0.0000;
	2021	1	10.144	0.721	0	0	1	1.0440706	-27.076358	110	4	1.12	0.95	105.2321	-1.6716	0.0000	0.0000;
	2022	1	4.056	0.357	0	0	1	1.0708004	-24.480354	110	4	1.12	0.95	100.6635	-1.3857	0.0000	0.0000;
	2023	1	5.164	0.672	0	0	1	1.0708206	-24.475068	110	4	1.12	0.95	100.6650	-1.3853	0.0000	0.0000;
	2024	1	3.964	0.787	0	0	1	1.0744785	-16.628949	110	4	1.12	0.95	94.0783	-1.0637	0.0000	0.0000;
	2025	1	8.309	-0.381	0	0	1	1.0681509	-26.23922	110	4	1.12	0.95	101.8650	-2.1212	0.0000	0.0000;
	2026	1	1.567	0.527	0	0	1	1.0732826	-17.988655	110	4	1.12	0.95	95.0849	-0.2249	0.0000	0.0000;
	2027	1	6.452	1.227	0	0	1	1.066112	-24.072056	110	4	1.12	0.95	101.2703	-1.5800	0.0000	0.0000;
	2028	1	5.073	0.823	0	0	1	1.0719254	-18.173549	110	4	1.12	0.95	96.2451	0.0950	0.0000	0.0000;
	2029	1	0	0.026	0	0	1	1.0719253	-18.173548	110	4	1.12	0.95	96.2451	0.0950	0.0000	0.0000;
	2030	1	10.142	0.184	0	0	1	1.0722474	-24.369593	110	4	1.12	0.95	100.4981	-1.4221	0.0000	0.0000;
	2031	1	4.883	0.11	0	0	1	1.0733625	-24.281098	110	4	1.12	0.95	100.3454	-1.4423	0.0000	0.0000;
	2032	2	14.279	0.469	0	0	1	1.0565483	-21.935339	110	4	1.12	0.95	99.4857	-1.1001	0.0000	0.0000;
	2033	1	3.781	-0.926	0	0	1	1.0564711	-25.113186	110	4	1.12	0.95	102.0833	-0.9115	0.0000	0.0000;
	2034	1	11.256	0.34	0	0	1	1.0513179	-25.578208	110	4	1.12	0.95	102.0596	-1.4519	0.0000	0.0000;
	2035	1	2.86	0.877	0	0	1	1.0701509	-24.527575	110	4	1.12	0.95	100.7140	-1.3622	0.0000	0.0000;
	2036	1	2.946	0.77	0	0	1	1.0501413	-26.258119	110	4	1.12	0.95	103.9839	-1.1352	0.0000	0.0000;
	2037	1	3.15	0.674	0	0	1	1.0665958	-20.21602	110	4	1.12	0.95	96.8834	-0.2533	0.0000	0.0000;
	2038	1	1.528	0.133	0	0	1	1.066611	-20.233462	110	4	1.12	0.95	96.8860	-0.2528	0.0000	0.0000;
	2039	1	6.454	-0.213	0	0	1	1.0481572	-24.197958	110	4	1.12	0.95	101.8767	-0.7403	0.0000	0.0000;
	2040	2	1.193	-3.471	0	0	1	1.0573565	-22.37395	110	4	1.12	0.95	99.4095	-0.4830	0.0000	0.0000;
	2041	1	4.681	-0.638	0	0	1	1.049861	-24.393051	110	4	1.12	0.95	100.1919	-0.2662	0.0000	0.0000;
	2042	1	45.829	17.293	0	0	1	1.0452783	-24.683309	110	4	1.12	0.95	100.5857	-0.1051	0.0000	0.0000;
	2043	1	23.119	4.036	0	0	1	1.0553626	-22.652953	110	4	1.12	0.95	99.7207	-0.4886	0.0000	0.0000;
	2044	2	4.63	0.186	0	0	1	1.0681954	-17.813568	110	4	1.12	0.95	96.3319	-0.1965	0.0000	0.0000;
	2045	1	2.808	0.159	0	0	1	1.0680589	-17.826026	110	4	1.12	0.95	96.3567	-0.1963	0.0000	0.0000;
	2046	2	10.602	4.978	0	0	1	1.1075062	-15.782547	110	4	1.12	0.95	95.7661	-0.0000	0.0000	0.0000;
	2047	1	82.092	30.429	0	0	1	1.1072177	-15.813072	110	4	1.12	0.95	95.7767	0.0039	0.0000	0.0000;
	2048	1	2.487	0.468	0	0	1	1.0835152	-13.494147	110	4	1.12	0.95	92.2211	-0.2266	0.0000	0.0000;
	2049	1	3.132	0.584	0	0	1	1.0821084	-14.546988	110	4	1.12	0.95	93.3235	-0.3434	0.0000	0.0000;
	2050	1	4.243	0.509	0	0	1	1.0631856	-24.887434	110	4	1.12	0.95	101.3626	-2.1271	0.0000	0.0000;
	2051	2	8.146	0.797	0	0	1	1.076429	-17.709411	110	4	1.12	0.95	95.4536	-0.0017	0.0000	0.0000;
	2052	1	2.117	0.065	0	0	1	1.0764269	-17.710274	110	4	1.12	0.95	95.4538	-0.0017	0.0000	0.0000;
	2053	1	7.659	0.596	0	0	1	1.0485088	-25.856844	110	4	1.12	0.95	102.6364	-0.8134	0.0000	0.0000;
	2054	1	6.265	0.333	0	0	1	1.0770657	-23.741318	110	4	1.12	0.95	99.9703	-1.4860	0.0000	0.0000;
	2055	1	1.012	0.189	0	0	1	1.0802055	-14.667779	110	4	1.12	0.95	93.2708	-0.6101	0.0000	0.0000;
	2056	1	10.141	0.047	0	0	1	1.0781976	-17.796835	110	4	1.12	0.95	95.4481	0.0074	0.0000	0.0000;
	2057	1	9.99	0.599	0	0	1	1.0706909	-25.25347	110	4	1.12	0.95	100.9364	-2.2589	0.0000	0.0000;
	2058	1	4.788	-0.531	0	0	1	1.1001579	-19.782443	110	4	1.12	0.95	95.8364	-0.0143	0.0000	0.0000;
	2059	2	11.904	0.833	0	0	1	1.0702339	-18.724765	110	4	1.12	0.95	96.6076	-0.9084	0.0000	0.0000;
	2060	1	3.78	-0.758	0	0	1	1.0714238	-18.82585	110	4	1.12	0.95	96.6115	-0.8742	0.0000	0.0000;
	2061	2	0.023	-0.266	0	0	1	1.0510057	-29.182904	110	4	1.12	0.95	104.5408	-2.3548	0.0000	0.0000;
	2062	1	4.798	1.487	0	0	1	1.1135447	-12.236604	110	4	1.12	0.95	93.3585	0.0591	0.0000	0.0000;
	2063	2	8.907	1.074	0	0	1	1.0684793	-17.981881	110	4	1.12	0.95	96.4726	-0.0919	0.0000	0.0000;
	2064	1	1.841	-0.471	0	0	1	1.0791414	-17.695094	110	4	1.12	0.95	95.2984	0.0042	0.0000	0.0000;
	2065	1	2.766	0.079	0	0	1	1.079845	-17.576283	110	4	1.12	0.95	95.1802	0.0074	0.0000	0.0000;
	2066	1	9.867	0.37	0	0	1	1.0997815	-15.146074	110	4	1.12	0.95	96.3630	0.0607	0.0000	0.0000;
	2067	2	5.977	-0.131	0	0	1	1.0749394	-17.997838	110	4	1.12	0.95	95.8576	0.0752	0.0000	0.0000;
	2068	2	3.259	2.853	0	0	1	1.100819	-14.90404	110	4	1.12	0.95	96.1490	0.0622	0.0000	0.0000;
	2069	1	7.922	2.493	0	0	1	1.0713405	-16.602474	110	4	1.12	0.95	93.9698	-0.9737	0.0000	0.0000;
	2070	1	9.306	0.644	0	0	1	1.0978261	-15.68162	110	4	1.12	0.95	96.8189	0.0464	0.0000	0.0000;
	2071	1	11.063	1.672	0	0	1	1.0995154	-19.796914	110	4	1.12	0.95	95.8852	0.0220	0.0000	0.0000;
	2072	2	10.125	-0.202	0	0	1	1.0600882	-24.749146	110	4	1.12	0.95	101.4712	-1.9105	0.0000	0.0000;
	2073	1	2.301	0.59	0	0	1	1.0910935	-21.170811	110	4	1.12	0.95	97.1877	-0.2341	0.0000	0.0000;
	2074	1	5.53	0.473	0	0	1	1.1138644	-15.998552	110	4	1.12	0.95	95.5669	-0.0338	0.0000	0.0000;
	2075	1	9.955	0.611	0	0	1	1.0677983	-18.355667	110	4	1.12	0.95	97.0619	-0.0013	0.0000	0.0000;
	2076	2	10.663	1.327	-0.013	-0.09	1	1.0677831	-18.356679	110	4	1.12	0.95	97.0653	-0.0017	0.0000	0.0000;
	2077	1	17.77	1.343	0	0	1	1.0654896	-25.798514	110	4	1.12	0.95	101.6097	-2.0611	0.0000	0.0000;
	2078	1	12.073	-0.026	0	0	1	1.0732439	-16.813826	110	4	1.12	0.95	94.5649	-0.9986	0.0000	0.0000;
	2079	1	11.967	4.6	0	0	1	1.0778812	-10.81254	110	4	1.12	0.95	95.0483	0.0327	0.0000	0.0000;
	2080	1	3.411	-1.249	0	0	1	1.0494032	-25.570326	110	4	1.12	0.95	102.2419	-0.9801	0.0000	0.0000;
	2081	1	0	0	0	0	1	1.0800592	-13.778938	110	4	1.12	0.95	92.8576	-0.2440	0.0000	0.0000;
	2082	1	0	0	0	0	1	1.0793955	-14.833827	110	4	1.12	0.95	93.8964	-0.3293	0.0000	0.0000;
	2083	2	31.367	9.021	0	0	1	1.0314873	-25.777803	110	4	1.12	0.95	101.3616	0.3640	0.0000	0.0000;
	2084	1	6.739	1.381	0	0	1	1.0454375	-23.333166	110	4	1.12	0.95	99.9390	-0.0086	0.0000	0.0000;
	2085	1	11.045	2.549	0	0	1	1.0408688	-25.254927	110	4	1.12	0.95	100.6938	-0.0152	0.0000	0.0000;
	2086	1	5.249	1.461	0	0	1	1.0573601	-20.647415	110	4	1.12	0.95	97.5385	0.0434	0.0000	0.0000;
	2087	1	3.684	0.374	0	0	1	1.0993219	-14.323389	110	4	1.12	0.95	95.7395	0.2035	0.0000	0.0000;
	2088	1	5.898	1.415	0	0	1	1.0441726	-24.884232	110	4	1.12	0.95	100.2019	-0.0679	0.0000	0.0000;
	2089	1	2.06	0.531	0	0	1	1.0335735	-25.647917	110	4	1.12	0.95	101.1662	0.2853	0.0000	0.0000;
	2090	1	2.948	0.588	0	0	1	1.0681753	-18.511299	110	4	1.12	0.95	96.5316	-0.9324	0.0000	0.0000;
	2091	1	4.612	-0.124	0	0	1	1.0594992	-28.219531	110	4	1.12	0.95	104.4972	-2.2130	0.0000	0.0000;
	2092	1	9.123	0.99	0	0	1	1.0600287	-24.445894	110	4	1.12	0.95	101.3143	-0.8174	0.0000	0.0000;
	2093	1	1.38	-0.69	0	0	1	1.1139079	-15.99282	110	4	1.12	0.95	95.5612	-0.0344	0.0000	0.0000;
	2094	1	6.724	0.909	0	0	1	1.1013272	-14.457356	110	4	1.12	0.95	95.6329	0.2241	0.0000	0.0000;
	2095	2	0	0	0	0	1	1.1070614	-15.711784	110	4	1.12	0.95	95.7692	-0.0000	0.0000	0.0000;
	2096	2	0	0	0	0	1	1.0970983	-20.1415	110	4	1.12	0.95	96.0986	0.0000	0.0000	0.0000;
	2097	1	0	0	0	0	1	1.1068207	-15.840591	110	4	1.12	0.95	95.8216	0.0057	0.0000	0.0000;
	2098	2	3.909	2.759	0	0	1	1.0318235	-16.105791	15	4	1.12	0.95	96.1590	-0.0000	0.0000	0.0000;
	2099	1	1.845	0.578	0	0	1	1.0702559	-18.254186	110	4	1.12	0.95	96.1128	-0.9526	0.0000	0.0000;
	2100	1	9.237	0.155	0	0	1	1.0763377	-17.866101	110	4	1.12	0.95	95.7338	0.0412	0.0000	0.0000;
	2101	2	27.59	9.7	0	0	1	1.045691	-23.264278	110	4	1.12	0.95	99.8855	0.0075	0.0000	0.0000;
	2102	1	10.296	3.399	0	0	1	1.0462886	-23.241514	110	4	1.12	0.95	99.8231	-0.0222	0.0000	0.0000;
	2103	1	1.03	0.266	0	0	1	1.0449451	-24.837873	110	4	1.12	0.95	100.0955	-0.0918	0.0000	0.0000;
	2104	1	8.423	2.443	0	0	1	1.0444134	-24.87936	110	4	1.12	0.95	100.1545	-0.0758	0.0000	0.0000;
	2105	1	2.213	0.567	0	0	1	1.0995661	-14.382208	110	4	1.12	0.95	95.7551	0.2040	0.0000	0.0000;
	2106	1	6.356	2.362	0	0	1	1.0424709	-25.004856	110	4	1.12	0.95	100.4075	-0.0122	0.0000	0.0000;
	2107	1	0.375	0.213	0	0	1	1.0424984	-25.001043	110	4	1.12	0.95	100.4114	-0.0119	0.0000	0.0000;
	2108	1	0	0	0	0	1	1.0690404	-23.655847	110	4	1.12	0.95	100.9907	-1.6005	0.0000	0.0000;
	2109	1	1.288	0.698	0	0	1	1.0511665	-21.914146	110	4	1.12	0.95	98.6673	0.0738	0.0000	0.0000;
	2110	1	0	0	0	0	1	1.0809493	-15.590009	110	4	1.12	0.95	94.8436	-0.3262	0.0000	0.0000;
	2111	1	0	0	0	0	1	1.0809704	-15.586463	110	4	1.12	0.95	94.8443	-0.3249	0.0000	0.0000;
	2112	1	67.381	31.498	0	0	1	1.044746	-23.182946	110	4	1.12	0.95	99.8083	0.0927	0.0000	0.0000;
	2113	1	27.143	6.638	0	0	1	1.043917	-24.921435	110	4	1.12	0.95	100.2141	-0.0627	0.0000	0.0000;
	2114	1	4.152	1.807	0	0	1	1.0476956	-22.78306	110	4	1.12	0.95	99.3655	0.0612	0.0000	0.0000;
	2115	1	9.222	2.66	0	0	1	1.0440225	-24.916047	110	4	1.12	0.95	100.1886	-0.0656	0.0000	0.0000;
	2116	1	2.76	0.531	0	0	1	1.0747817	-15.801324	110	4	1.12	0.95	94.3522	-0.1989	0.0000	0.0000;
	2117	1	9.6	4.374	0	0	1	1.0481121	-22.604188	110	4	1.12	0.95	99.2798	0.0660	0.0000	0.0000;
	2118	1	0	0	0	0	1	1.0481811	-22.616511	110	4	1.12	0.95	99.2823	0.0646	0.0000	0.0000;
	2119	1	11.243	8.924	0	0	1	1.0457945	-23.121386	110	4	1.12	0.95	99.7722	0.0195	0.0000	0.0000;
	2120	1	10.204	1.646	0	0	1	1.0445669	-24.883653	110	4	1.12	0.95	100.1424	-0.0848	0.0000	0.0000;
	2121	1	1.933	0.68	0	0	1	1.0467869	-24.634419	110	4	1.12	0.95	100.3214	-0.1587	0.0000	0.0000;
	2122	1	5.074	0.442	0	0	1	1.1080002	-12.70025	110	4	1.12	0.95	94.0945	0.1185	0.0000	0.0000;
	2123	2	18.576	3.805	0	0	1	1.0500437	-26.23389	110	4	1.12	0.95	104.0019	-1.1415	0.0000	0.0000;
	2124	1	2.946	1.064	0	0	1	1.0475821	-23.723101	110	4	1.12	0.95	99.9678	-0.1129	0.0000	0.0000;
	2125	1	0.562	0.266	0	0	1	1.0476665	-23.734663	110	4	1.12	0.95	99.9637	-0.1132	0.0000	0.0000;
	2126	1	8.855	2.408	0	0	1	1.0436382	-24.902045	110	4	1.12	0.95	100.4469	-0.0527	0.0000	0.0000;
	2127	1	4.774	0.85	0	0	1	1.0460487	-23.298321	110	4	1.12	0.95	99.8568	-0.0263	0.0000	0.0000;
	2128	2	5.926	-0.054	0	0	1	1.06518	-18.609438	110	4	1.12	0.95	96.6931	-0.9554	0.0000	0.0000;
	2129	1	3.688	0.697	0	0	1	1.066463	-18.193339	110	4	1.12	0.95	96.3526	-0.9522	0.0000	0.0000;
	2130	1	14.409	1.147	0	0	1	1.0692019	-25.322867	110	4	1.12	0.95	101.0482	-2.2113	0.0000	0.0000;
	2131	1	6.544	1.366	0	0	1	1.0665264	-18.158453	110	4	1.12	0.95	96.3039	-0.9465	0.0000	0.0000;
	2132	1	0	0.029	0	0	1	1.0656555	-18.639847	110	4	1.12	0.95	97.5701	-0.0663	0.0000	0.0000;
	2133	1	3.23	-0.018	0	0	1	1.0656532	-18.641195	110	4	1.12	0.95	97.5706	-0.0663	0.0000	0.0000;
	2134	1	7.288	3.373	0	0	1	1.0733082	-15.757474	110	4	1.12	0.95	94.3347	-0.1176	0.0000	0.0000;
	2135	1	1.498	0.213	0	0	1	1.0402953	-25.307106	110	4	1.12	0.95	100.8001	-0.0122	0.0000	0.0000;
	2136	2	2.273	-0.471	0	0	1	1.0699756	-17.953687	110	4	1.12	0.95	96.4532	-0.4699	0.0000	0.0000;
	2137	1	5.721	0.714	0	0	1	1.0783442	-13.905741	110	4	1.12	0.95	93.1212	-0.2247	0.0000	0.0000;
	2138	1	3.689	0.808	0	0	1	1.1008213	-14.473334	110	4	1.12	0.95	95.6895	0.2205	0.0000	0.0000;
	2139	1	0	0.041	0	0	1	1.0796121	-16.793053	110	4	1.12	0.95	94.8284	-0.0512	0.0000	0.0000;
	2140	1	5.071	0.363	0	0	1	1.0796055	-16.795099	110	4	1.12	0.95	94.8291	-0.0512	0.0000	0.0000;
	2141	1	5.436	0.139	0	0	1	1.0578052	-27.4519	110	4	1.12	0.95	103.9734	-2.0909	0.0000	0.0000;
	2142	1	8.48	0.829	0	0	1	1.0973315	-15.74974	110	4	1.12	0.95	96.8903	0.0513	0.0000	0.0000;
	2143	1	5.805	2.496	0	0	1	1.0716254	-16.565507	110	4	1.12	0.95	93.9197	-0.9739	0.0000	0.0000;
	2144	1	0.92	0.263	0	0	1	1.0504966	-25.591134	110	4	1.12	0.95	101.9708	-1.4817	0.0000	0.0000;
	2145	2	9.818	-0.154	0	0	1	1.0819366	-15.421847	110	4	1.12	0.95	94.8511	-0.2329	0.0000	0.0000;
	2146	1	1.843	0.086	0	0	1	1.07481	-18.02609	110	4	1.12	0.95	95.8852	0.0739	0.0000	0.0000;
	2147	1	30.462	5.579	0	0	1	1.0852944	-18.015146	110	4	1.12	0.95	97.9188	0.6937	0.0000	0.0000;
	2148	1	2.762	-0.006	0	0	1	1.0728331	-17.462311	110	4	1.12	0.95	96.1669	-0.0805	0.0000	0.0000;
	2149	1	0	0.026	0	0	1	1.0728329	-17.46231	110	4	1.12	0.95	96.1669	-0.0805	0.0000	0.0000;
	2150	1	14.674	0.757	0	0	1	1.0549166	-23.374264	110	4	1.12	0.95	100.6146	-1.2485	0.0000	0.0000;
	2151	1	24.616	1.752	0	0	1	1.0548836	-23.384664	110	4	1.12	0.95	100.6178	-1.2483	0.0000	0.0000;
	2152	1	10.876	0.665	0	0	1	1.0699965	-17.293475	110	4	1.12	0.95	95.5936	-0.1186	0.0000	0.0000;
	2153	1	10.296	-0.266	0	0	1	1.0681002	-17.57896	110	4	1.12	0.95	96.3741	-0.3029	0.0000	0.0000;
	2154	1	9.397	0.446	0	0	1	1.070236	-17.39098	110	4	1.12	0.95	95.6500	-0.1178	0.0000	0.0000;
	2155	1	8.661	0.251	0	0	1	1.0690398	-17.566706	110	4	1.12	0.95	95.9670	-0.1451	0.0000	0.0000;
	2156	1	7.781	0.163	0	0	1	1.053642	-23.187991	110	4	1.12	0.95	100.6983	-1.2309	0.0000	0.0000;
	2157	1	2.763	0.068	0	0	1	1.0615488	-25.762326	110	4	1.12	0.95	102.4456	-1.7524	0.0000	0.0000;
	2158	1	0	0	0	0	1	1.0698725	-23.32724	110	4	1.12	0.95	99.2915	-0.7206	0.0000	0.0000;
	2159	1	0	0	0	0	1	1.0685373	-23.183936	110	4	1.12	0.95	99.3677	-0.6872	0.0000	0.0000;
	2160	1	0.089	0	0	0	1	1.0659406	-25.531256	110	4	1.12	0.95	101.4732	-2.0478	0.0000	0.0000;
	2161	1	0.553	-0.505	0	0	1	1.0759706	-19.164991	110	4	1.12	0.95	96.6333	-0.7719	0.0000	0.0000;
	2162	1	3.037	0.053	0	0	1	1.0654347	-25.079056	110	4	1.12	0.95	101.5783	-1.3853	0.0000	0.0000;
	2163	1	2.394	-0.031	0	0	1	1.0759141	-23.78001	110	4	1.12	0.95	100.0446	-1.4170	0.0000	0.0000;
	2164	1	5.991	-1.596	0	0	1	1.0721718	-23.225866	110	4	1.12	0.95	99.1544	-0.8769	0.0000	0.0000;
	2165	1	3.688	-0.172	0	0	1	1.0809983	-15.609528	110	4	1.12	0.95	94.9418	-0.2942	0.0000	0.0000;
	2166	1	4.147	-0.14	0	0	1	1.0751769	-17.97772	110	4	1.12	0.95	95.8243	0.0680	0.0000	0.0000;
	2167	1	2.767	-0.35	0	0	1	1.0653645	-26.925735	110	4	1.12	0.95	102.6384	-1.9445	0.0000	0.0000;
	2168	1	7.188	1.369	0	0	1	1.072879	-18.066346	110	4	1.12	0.95	96.0405	0.1329	0.0000	0.0000;
	2169	1	3.094	14.899	0	0	1	1.0484709	-24.158791	110	4	1.12	0.95	101.4735	0.1153	0.0000	0.0000;
	2170	1	3.872	0.45	0	0	1	1.0488562	-25.765552	110	4	1.12	0.95	102.1599	-1.4868	0.0000	0.0000;
	2171	1	0.276	0.134	0	0	1	1.0386256	-27.849857	110	4	1.12	0.95	106.6966	-1.8751	0.0000	0.0000;
	2172	1	2.863	0.105	0	0	1	1.0657809	-26.289359	110	4	1.12	0.95	102.5434	-2.1091	0.0000	0.0000;
	2173	1	6.911	-0.116	0	0	1	1.0715315	-25.531126	110	4	1.12	0.95	101.4202	-1.8583	0.0000	0.0000;
	2174	1	1.381	0.034	0	0	1	1.0761674	-17.928972	110	4	1.12	0.95	95.7149	0.0404	0.0000	0.0000;
	2175	1	2.761	-0.163	0	0	1	1.0849266	-14.92145	110	4	1.12	0.95	94.3042	-0.1346	0.0000	0.0000;
	2176	1	2.302	0.347	0	0	1	1.0846101	-14.622557	110	4	1.12	0.95	94.1478	-0.0637	0.0000	0.0000;
	2177	1	3.802	-0.208	0	0	1	1.044221	-30.143074	110	4	1.12	0.95	105.8781	-2.4493	0.0000	0.0000;
	2178	1	1.991	0.552	0	0	1	1.0902465	-27.529071	110	4	1.12	0.95	103.0687	0.3305	0.0000	0.0000;
	2179	1	7.185	0.608	0	0	1	1.0714831	-16.939745	110	4	1.12	0.95	95.1570	-0.7643	0.0000	0.0000;
	2180	2	6.329	0.251	0	0	1	1.0802891	-14.661955	110	4	1.12	0.95	93.2588	-0.6115	0.0000	0.0000;
	2181	2	5.895	0.514	0	0	1	1.0618894	-25.654871	110	4	1.12	0.95	102.3385	-1.7376	0.0000	0.0000;
	2182	1	4.798	1.081	0	0	1	1.0655411	-26.183109	110	4	1.12	0.95	102.1336	-1.8661	0.0000	0.0000;
	2183	1	9.016	0.799	0	0	1	1.0656379	-24.903455	110	4	1.12	0.95	101.1795	-2.2519	0.0000	0.0000;
	2184	1	1.841	0.225	0	0	1	1.0648066	-25.12349	110	4	1.12	0.95	102.1516	-1.6345	0.0000	0.0000;
	2185	1	3.963	0.097	0	0	1	1.0674962	-24.90616	110	4	1.12	0.95	101.7535	-1.6128	0.0000	0.0000;
	2186	1	3.777	-0.225	0	0	1	1.059687	-28.146673	110	4	1.12	0.95	104.2137	-2.0698	0.0000	0.0000;
	2187	1	7.867	2.132	0	0	1	1.0711102	-24.452477	110	4	1.12	0.95	100.2065	-1.9247	0.0000	0.0000;
	2188	1	3.314	2.124	0	0	1	1.0696558	-24.715644	110	4	1.12	0.95	100.5264	-1.9459	0.0000	0.0000;
	2189	1	7.16	1.475	0	0	1	1.0653013	-25.194038	110	4	1.12	0.95	101.1837	-1.8288	0.0000	0.0000;
	2190	1	6.188	0.362	0	0	1	1.0707931	-24.599992	110	4	1.12	0.95	100.3554	-1.9527	0.0000	0.0000;
	2191	1	4.424	0.288	0	0	1	1.0935574	-20.105896	110	4	1.12	0.95	96.2965	-0.1405	0.0000	0.0000;
	2192	1	6.63	0.457	0	0	1	1.0628662	-24.404078	110	4	1.12	0.95	100.7810	-1.0017	0.0000	0.0000;
	2193	1	2.952	-0.181	0	0	1	1.0696954	-23.461894	110	4	1.12	0.95	99.4212	-0.7508	0.0000	0.0000;
	2194	1	1.842	0.496	0	0	1	1.0551642	-28.97789	110	4	1.12	0.95	105.6788	-2.4134	0.0000	0.0000;
	2195	1	5.351	-0.165	0	0	1	1.0511148	-25.591735	110	4	1.12	0.95	101.9816	-1.4737	0.0000	0.0000;
	2196	1	4.24	-1.331	0	0	1	1.0485009	-25.358646	110	4	1.12	0.95	101.8974	-0.9068	0.0000	0.0000;
	2197	1	6.551	-0.441	0	0	1	1.0669203	-26.25698	110	4	1.12	0.95	101.9915	-1.9043	0.0000	0.0000;
	2198	1	6.82	-2.441	0	0	1	1.0485966	-25.472572	110	4	1.12	0.95	102.0786	-0.9707	0.0000	0.0000;
	2199	1	6.73	1.384	0	0	1	1.10779	-15.18729	110	4	1.12	0.95	95.3872	0.0367	0.0000	0.0000;
	2200	1	4.611	-0.23	0	0	1	1.0641705	-27.190402	110	4	1.12	0.95	103.0091	-1.9957	0.0000	0.0000;
	2201	1	0	0.059	0	0	1	1.0742928	-17.839191	110	4	1.12	0.95	95.8583	0.0184	0.0000	0.0000;
	2202	1	3.688	0.405	0	0	1	1.0742869	-17.840687	110	4	1.12	0.95	95.8588	0.0184	0.0000	0.0000;
	2203	1	8.131	-0.162	0	0	1	1.0627936	-26.042306	110	4	1.12	0.95	102.0882	-1.9139	0.0000	0.0000;
	2204	1	3.685	0.515	0	0	1	1.0749586	-16.04003	110	4	1.12	0.95	94.0582	-0.3343	0.0000	0.0000;
	2205	1	4.696	-0.083	0	0	1	1.0765725	-16.164352	110	4	1.12	0.95	93.6586	-1.0462	0.0000	0.0000;
	2206	2	2.317	-0.209	0	0	1	1.0511102	-29.220957	110	4	1.12	0.95	104.5740	-2.3711	0.0000	0.0000;
	2207	2	10.227	0.344	0	0	1	1.0852333	-11.678924	110	4	1.12	0.95	92.3463	-0.1154	0.0000	0.0000;
	2208	1	15.292	1.273	0	0	1	1.0775071	-15.347085	110	4	1.12	0.95	93.7667	-0.7249	0.0000	0.0000;
	2209	2	8.551	-0.267	0	0	1	1.069051	-26.077737	110	4	1.12	0.95	101.6995	-2.1795	0.0000	0.0000;
	2210	1	5.435	0.75	0	0	1	1.0768162	-16.180004	110	4	1.12	0.95	93.4376	-1.1036	0.0000	0.0000;
	2211	1	10.321	0.805	0	0	1	1.0738039	-16.43992	110	4	1.12	0.95	93.8776	-1.0798	0.0000	0.0000;
	2212	2	10.45	0.911	0	0	1	1.0755791	-16.295861	110	4	1.12	0.95	93.6046	-1.0975	0.0000	0.0000;
	2213	1	0	0	0	0	1	1.0770754	-16.14055	110	4	1.12	0.95	93.3897	-1.1141	0.0000	0.0000;
	2214	1	0	0	0	0	1	1.0770562	-16.163418	110	4	1.12	0.95	93.4043	-1.1080	0.0000	0.0000;
	2215	1	5.989	0.335	0	0	1	1.0734756	-16.809856	110	4	1.12	0.95	94.3992	-1.0368	0.0000	0.0000;
	2216	1	0	0	0	0	1	1.0808277	-14.133498	110	4	1.12	0.95	92.7914	-0.4018	0.0000	0.0000;
	2217	1	0	0	0	0	1	1.0832124	-14.565781	110	4	1.12	0.95	92.8218	-0.5868	0.0000	0.0000;
	2218	2	3.72	4.847	0	0	1	1.1158989	-15.768952	110	4	1.12	0.95	95.1574	-0.0000	0.0000	0.0000;
	2219	2	2.248	4.658	0	0	1	1.1006073	-19.724205	110	4	1.12	0.95	95.7330	0.0000	0.0000	0.0000;
	2220	1	4.604	0.678	0	0	1	1.0681906	-17.815297	110	4	1.12	0.95	96.3346	-0.1976	0.0000	0.0000;
	2221	1	10.578	0.797	0	0	1	1.0681816	-17.815561	110	4	1.12	0.95	96.3361	-0.1972	0.0000	0.0000;
	2222	1	5.18	0.356	0	0	1	1.0791728	-17.621062	110	4	1.12	0.95	95.2951	0.0094	0.0000	0.0000;
	2223	1	4.681	1.275	0	0	1	1.0793499	-17.583086	110	4	1.12	0.95	95.2202	0.0303	0.0000	0.0000;
	2224	1	6.819	0.677	0	0	1	1.1048825	-15.83984	110	4	1.12	0.95	96.0719	0.0029	0.0000	0.0000;
	2225	1	2.486	0.289	0	0	1	1.0757936	-17.791657	110	4	1.12	0.95	95.5205	0.0565	0.0000	0.0000;
	2226	1	3.318	0.09	0	0	1	1.0757904	-17.793011	110	4	1.12	0.95	95.5210	0.0565	0.0000	0.0000;
	2227	1	3.625	-0.189	0	0	1	1.0607513	-20.213601	110	4	1.12	0.95	98.0670	-1.0116	0.0000	0.0000;
	2228	1	1.473	0.106	0	0	1	1.0827811	-13.475725	110	4	1.12	0.95	92.3569	-0.2343	0.0000	0.0000;
	2229	1	2.393	0.24	0	0	1	1.0827632	-13.487331	110	4	1.12	0.95	92.3606	-0.2340	0.0000	0.0000;
	2230	1	8.854	0.92	0	0	1	1.0708034	-24.552977	110	4	1.12	0.95	100.3115	-1.9595	0.0000	0.0000;
	2231	2	11.543	0.37	0	0	1	1.0689134	-25.313026	110	4	1.12	0.95	101.0533	-2.1937	0.0000	0.0000;
	2232	2	9.994	0.456	0	0	1	1.0501111	-29.079286	110	4	1.12	0.95	104.1634	-2.1558	0.0000	0.0000;
	2233	1	8.842	0.66	0	0	1	1.0740637	-17.939358	110	4	1.12	0.95	95.7655	0.1103	0.0000	0.0000;
	2234	1	0	0.063	0	0	1	1.0740633	-17.939355	110	4	1.12	0.95	95.7655	0.1103	0.0000	0.0000;
	2235	1	9.911	0.041	0	0	1	1.0507996	-28.992569	110	4	1.12	0.95	104.0337	-2.1557	0.0000	0.0000;
	2236	1	8.044	0.266	0	0	1	1.0699852	-24.842723	110	4	1.12	0.95	100.5991	-1.9780	0.0000	0.0000;
	2237	1	0	0	0	0	1	1.0515948	-28.711987	110	4	1.12	0.95	103.6865	-2.1051	0.0000	0.0000;
	2238	1	0	0	0	0	1	1.0533365	-28.610222	110	4	1.12	0.95	103.6236	-2.1364	0.0000	0.0000;
	2239	2	35.034	2.364	0	0	1	1.040771	-25.676073	110	4	1.12	0.95	102.1696	-1.0904	0.0000	0.0000;
	2240	1	13.438	0.215	0	0	1	1.0415807	-25.60911	110	4	1.12	0.95	102.1087	-1.1073	0.0000	0.0000;
	2241	1	0	0	0	0	1	1.067059	-25.529092	110	4	1.12	0.95	101.4196	-2.1677	0.0000	0.0000;
	2242	1	0	0	0	0	1	1.0734623	-25.056249	110	4	1.12	0.95	100.6849	-2.3307	0.0000	0.0000;
	2243	1	3.317	0.457	0	0	1	1.0449752	-24.836435	110	4	1.12	0.95	100.0914	-0.0928	0.0000	0.0000;
	2244	1	2.152	0	0	0	1	1.0466843	-23.222234	110	4	1.12	0.95	99.7753	-0.0380	0.0000	0.0000;
	2245	1	3.965	-1.393	0	0	1	1.0719017	-23.10985	110	4	1.12	0.95	99.0789	-0.8421	0.0000	0.0000;
	2246	1	7.085	1.009	0	0	1	1.0467222	-23.327769	110	4	1.12	0.95	99.8261	-0.0493	0.0000	0.0000;
	2247	1	1.656	0.15	0	0	1	1.0538976	-23.67649	110	4	1.12	0.95	100.6406	-0.6185	0.0000	0.0000;
	2248	1	11.806	0.965	0	0	1	1.0479708	-25.874857	110	4	1.12	0.95	102.4770	-1.4347	0.0000	0.0000;
	2249	1	7.269	-0.08	0	0	1	1.0548899	-25.847233	110	4	1.12	0.95	102.8863	-1.5731	0.0000	0.0000;
	2250	1	6.719	-0.401	0	0	1	1.063278	-26.600993	110	4	1.12	0.95	102.8652	-2.2593	0.0000	0.0000;
	2251	1	0	0	0	0	1	1.063278	-26.600993	110	4	1.12	0.95	102.8652	-2.2593	0.0000	0.0000;
	2252	1	3.224	0.363	0	0	1	1.0834188	-15.330285	110	4	1.12	0.95	94.7007	-0.2230	0.0000	0.0000;
	2253	1	3.89	-0.457	0	0	1	1.0707369	-24.858679	110	4	1.12	0.95	100.6000	-1.6641	0.0000	0.0000;
	2254	1	15.912	1.695	0	0	1	1.0698014	-24.709997	110	4	1.12	0.95	100.5164	-1.9523	0.0000	0.0000;
	2255	1	0	0	0	0	1	1.0466863	-23.22188	110	4	1.12	0.95	99.7749	-0.0380	0.0000	0.0000;
	2256	1	0	0	0	0	1	1.0449809	-24.835774	110	4	1.12	0.95	100.0907	-0.0929	0.0000	0.0000;
	2257	2	0	0	0	0	1	1.053842	-25.29934	110	4	1.12	0.95	101.7144	-1.4626	0.0000	0.0000;
	2258	2	13.856	6.95	0	0	1	1.0538014	-25.311709	110	4	1.12	0.95	101.7152	-1.4622	0.0000	0.0000;
	2259	1	12.818	0.891	0	0	1	1.0691804	-24.922183	110	4	1.12	0.95	100.7048	-2.0673	0.0000	0.0000;
	2260	1	8.047	0.404	0	0	1	1.0701554	-24.788259	110	4	1.12	0.95	100.5460	-1.9771	0.0000	0.0000;
	2261	1	12.2	0.141	0	0	1	1.0710332	-24.751103	110	4	1.12	0.95	100.5850	-2.4392	0.0000	0.0000;
	2262	1	7.454	-0.496	0	0	1	1.0653287	-25.53163	110	4	1.12	0.95	101.4998	-1.9827	0.0000	0.0000;
	2263	1	11.669	-0.67	0	0	1	1.0503219	-29.078179	110	4	1.12	0.95	104.1328	-2.1590	0.0000	0.0000;
	2264	1	14.322	0.537	0	0	1	1.065674	-25.705745	110	4	1.12	0.95	101.6516	-2.1607	0.0000	0.0000;
	2265	1	8.281	0.69	0	0	1	1.0710999	-24.952229	110	4	1.12	0.95	100.6674	-2.1064	0.0000	0.0000;
	2266	1	8.662	1.07	0	0	1	1.0741276	-17.948455	110	4	1.12	0.95	94.9299	-0.2272	0.0000	0.0000;
	2267	1	5.914	0.266	0	0	1	1.0394892	-25.443982	110	4	1.12	0.95	100.9431	-0.0082	0.0000	0.0000;
	2268	1	5.258	1.255	0	0	1	1.0760763	-15.53252	110	4	1.12	0.95	94.1583	-0.2264	0.0000	0.0000;
	2269	2	12.994	0.679	0	0	1	1.0805773	-13.95929	110	4	1.12	0.95	92.9057	-0.3214	0.0000	0.0000;
	2270	1	9.105	0.779	0	0	1	1.0694865	-24.912667	110	4	1.12	0.95	100.7709	-2.2523	0.0000	0.0000;
	2271	1	2.946	0.414	0	0	1	1.0730069	-17.606692	110	4	1.12	0.95	95.8108	-0.1484	0.0000	0.0000;
	2272	1	7.828	0.321	0	0	1	1.0708516	-17.73596	110	4	1.12	0.95	95.5331	-1.0059	0.0000	0.0000;
	2273	1	2.76	0.028	0	0	1	1.0822144	-14.231133	110	4	1.12	0.95	92.8638	-0.5252	0.0000	0.0000;
	2274	1	6.356	0.321	0	0	1	1.080363	-13.513286	110	4	1.12	0.95	93.1015	-0.1587	0.0000	0.0000;
	2275	1	1.381	0.348	0	0	1	1.0799993	-16.704599	110	4	1.12	0.95	94.7627	-0.0499	0.0000	0.0000;
	2276	1	4.795	0.886	0	0	1	1.0626976	-25.500406	110	4	1.12	0.95	102.4578	-1.7133	0.0000	0.0000;
	2277	2	12.072	-0.438	0	0	1	1.0552775	-20.350317	110	4	1.12	0.95	98.8745	-0.7164	0.0000	0.0000;
	2278	1	5.159	-0.353	0	0	1	1.0551857	-20.330112	110	4	1.12	0.95	98.8833	-0.7169	0.0000	0.0000;
	2279	1	5.349	1.499	0	0	1	1.0806313	-15.628006	110	4	1.12	0.95	94.9085	-0.3090	0.0000	0.0000;
	2280	1	2.491	0.232	0	0	1	1.1027864	-15.868074	110	4	1.12	0.95	96.3435	0.0024	0.0000	0.0000;
	2281	1	3.143	0.586	0	0	1	1.0351564	-28.26973	110	4	1.12	0.95	107.5275	-1.9514	0.0000	0.0000;
	2282	2	8.997	0.026	0	0	1	1.0620867	-27.817467	110	4	1.12	0.95	103.7583	-2.0668	0.0000	0.0000;
	2283	1	8.574	0.113	0	0	1	1.0613722	-26.563604	110	4	1.12	0.95	102.3630	-1.8725	0.0000	0.0000;
	2284	1	35.67	8.889	0	0	1	1.0626441	-15.788817	110	4	1.12	0.95	94.5139	0.0534	0.0000	0.0000;
	2285	2	4.499	0.339	0	0	1	1.079158	-16.460266	110	4	1.12	0.95	93.9412	-0.4229	0.0000	0.0000;
	2286	1	2.026	0.478	0	0	1	1.0735243	-17.980389	110	4	1.12	0.95	95.9065	0.0983	0.0000	0.0000;
	2287	1	3.409	0.323	0	0	1	1.0528843	-25.871146	110	4	1.12	0.95	103.3451	-1.0892	0.0000	0.0000;
	2288	1	5.067	-0.31	0	0	1	1.0512363	-26.207592	110	4	1.12	0.95	103.7937	-1.1409	0.0000	0.0000;
	2289	1	5.721	-1.98	0	0	1	1.068453	-25.090896	110	4	1.12	0.95	100.9340	-1.3340	0.0000	0.0000;
	2290	1	4.149	-0.938	0	0	1	1.0681056	-25.289882	110	4	1.12	0.95	101.1223	-1.4056	0.0000	0.0000;
	2291	1	4.618	0.281	0	0	1	1.0757352	-17.83824	110	4	1.12	0.95	95.5801	-0.0025	0.0000	0.0000;
	2292	1	2.67	0.241	0	0	1	1.0743934	-18.154078	110	4	1.12	0.95	95.0177	-0.2537	0.0000	0.0000;
	2293	1	0	0	0	0	1	1.0744074	-18.164243	110	4	1.12	0.95	95.0166	-0.2522	0.0000	0.0000;
	2294	1	1.853	-0.148	0	0	1	1.0772013	-17.747969	110	4	1.12	0.95	95.3994	-0.0265	0.0000	0.0000;
	2295	1	0	0.034	0	0	1	1.077201	-17.747968	110	4	1.12	0.95	95.3994	-0.0265	0.0000	0.0000;
	2296	1	5.394	0.95	0	0	1	1.06379	-25.338536	110	4	1.12	0.95	101.5853	-2.0741	0.0000	0.0000;
	2297	2	5.998	0.087	0	0	1	1.048519	-25.816648	110	4	1.12	0.95	102.2243	-1.4873	0.0000	0.0000;
	2298	1	5.4	0.088	0	0	1	1.0494342	-25.686775	110	4	1.12	0.95	102.0931	-1.4915	0.0000	0.0000;
	2299	2	3.035	0.074	0	0	1	1.0790214	-17.650224	110	4	1.12	0.95	95.3236	0.0089	0.0000	0.0000;
	2300	2	1.561	0.041	0	0	1	1.0741755	-24.736104	110	4	1.12	0.95	100.7794	-1.6975	0.0000	0.0000;
	2301	1	2.763	-0.044	0	0	1	1.0713968	-18.16311	110	4	1.12	0.95	96.4147	0.0157	0.0000	0.0000;
	2302	2	3.572	0.554	0	0	1	1.0964785	-16.437005	110	4	1.12	0.95	96.6485	0.3691	0.0000	0.0000;
	2303	1	11.796	-0.448	0	0	1	1.0614074	-24.339764	110	4	1.12	0.95	100.4451	-0.6904	0.0000	0.0000;
	2304	2	10.909	0.552	0	0	1	1.0755775	-16.097536	110	4	1.12	0.95	95.0842	-0.2380	0.0000	0.0000;
	2305	1	4.149	1.028	0	0	1	1.0767611	-17.692662	110	4	1.12	0.95	95.3858	0.0037	0.0000	0.0000;
	2306	1	5.897	-1.243	0	0	1	1.0531289	-24.850548	110	4	1.12	0.95	100.7244	-0.5116	0.0000	0.0000;
	2307	1	4.685	0.161	0	0	1	1.0576632	-24.297939	110	4	1.12	0.95	101.2583	-1.6705	0.0000	0.0000;
	2308	2	13.832	-0.308	0	0	1	1.0610879	-27.058566	110	4	1.12	0.95	102.8468	-2.1255	0.0000	0.0000;
	2309	1	6.463	0.244	0	0	1	1.0728788	-22.660256	110	4	1.12	0.95	99.2077	-0.2492	0.0000	0.0000;
	2310	1	0	0.04	0	0	1	1.0807135	-16.687905	110	4	1.12	0.95	94.7184	-0.0760	0.0000	0.0000;
	2311	1	0.553	0.322	0	0	1	1.0713186	-18.168813	110	4	1.12	0.95	96.4216	0.0180	0.0000	0.0000;
	2312	2	4.829	0.618	0	0	1	1.0479286	-24.228884	110	4	1.12	0.95	101.8977	-0.6938	0.0000	0.0000;
	2313	1	6.1	-0.132	0	0	1	1.0636924	-26.543286	110	4	1.12	0.95	102.8922	-2.2022	0.0000	0.0000;
	2314	2	16.402	0.201	0	0	1	1.0457748	-24.449504	110	4	1.12	0.95	102.1602	-0.2204	0.0000	0.0000;
	2315	2	7.066	0.955	0	0	1	1.0772676	-15.321181	110	4	1.12	0.95	94.0130	-0.2635	0.0000	0.0000;
	2316	1	1.382	0.311	0	0	1	1.0765076	-16.052005	110	4	1.12	0.95	93.7569	-0.9801	0.0000	0.0000;
	2317	1	7.1	0.732	0	0	1	1.0393132	-25.410395	110	4	1.12	0.95	100.9654	0.0004	0.0000	0.0000;
	2318	1	12.916	0.213	0	0	1	1.0745261	-15.80855	110	4	1.12	0.95	94.4144	-0.2032	0.0000	0.0000;
	2319	1	9.686	1.766	0	0	1	1.0724165	-17.856166	110	4	1.12	0.95	95.9864	0.0077	0.0000	0.0000;
	2320	1	0	0.044	0	0	1	1.0724162	-17.856164	110	4	1.12	0.95	95.9864	0.0077	0.0000	0.0000;
	2321	1	4.61	0.332	0	0	1	1.0662445	-25.666324	110	4	1.12	0.95	101.7960	-1.6246	0.0000	0.0000;
	2322	1	0.183	0.026	0	0	1	1.0834394	-15.369446	110	4	1.12	0.95	94.7402	-0.3253	0.0000	0.0000;
	2323	1	4.426	-0.035	0	0	1	1.0732649	-23.803764	110	4	1.12	0.95	100.0691	-1.1825	0.0000	0.0000;
	2324	1	10.785	0.633	0	0	1	1.0664224	-24.804149	110	4	1.12	0.95	100.8074	-1.7333	0.0000	0.0000;
	2325	2	2.159	0.174	0	0	1	1.0776881	-17.609241	110	4	1.12	0.95	95.2410	-0.0010	0.0000	0.0000;
	2326	2	0	0	0	0	1	1.0797691	-17.208814	110	4	1.12	0.95	94.9510	-0.0462	0.0000	0.0000;
	2327	1	4.442	0.22	0	0	1	1.0335717	-28.679857	110	4	1.12	0.95	107.9782	-1.9946	0.0000	0.0000;
	2328	1	4.499	0.25	0	0	1	1.058411	-28.28935	110	4	1.12	0.95	104.4193	-2.0566	0.0000	0.0000;
	2329	1	3.5	0.061	0	0	1	1.0823817	-14.518915	110	4	1.12	0.95	92.9161	-0.5748	0.0000	0.0000;
	2330	1	2.945	0.71	0	0	1	1.0587553	-28.247685	110	4	1.12	0.95	104.3593	-2.0584	0.0000	0.0000;
	2331	1	8.759	1.264	0	0	1	1.0609917	-26.678629	110	4	1.12	0.95	102.9980	-1.8798	0.0000	0.0000;
	2332	2	6.397	0.407	0	0	1	1.0998161	-15.820344	110	4	1.12	0.95	96.6640	0.0203	0.0000	0.0000;
	2333	1	3.872	-0.283	0	0	1	1.0752977	-16.233428	110	4	1.12	0.95	94.2833	-0.9001	0.0000	0.0000;
	2334	2	0	0	0	0	1	1.0560583	-25.22985	110	4	1.12	0.95	101.7496	-1.4849	0.0000	0.0000;
	2335	1	3.781	-0.943	0	0	1	1.0522797	-24.452012	110	4	1.12	0.95	101.3538	-0.7249	0.0000	0.0000;
	2336	1	4.143	1.081	0	0	1	1.0428804	-25.622774	110	4	1.12	0.95	102.1082	-1.1599	0.0000	0.0000;
	2337	2	4.054	-0.194	0	0	1	1.0555875	-28.916727	110	4	1.12	0.95	105.6163	-2.4169	0.0000	0.0000;
	2338	1	14.586	0.008	0	0	1	1.0625283	-26.549574	110	4	1.12	0.95	102.3536	-2.0905	0.0000	0.0000;
	2339	1	6.181	1.146	0	0	1	1.0811452	-15.334454	110	4	1.12	0.95	93.2172	-0.5977	0.0000	0.0000;
	2340	1	8.306	1.678	0	0	1	1.116411	-12.211823	110	4	1.12	0.95	93.0792	0.0211	0.0000	0.0000;
	2341	1	5.394	-0.353	0	0	1	1.0508755	-28.663705	110	4	1.12	0.95	104.2664	-2.1287	0.0000	0.0000;
	2342	1	14.748	5.588	0	0	1	1.0801385	-14.670543	110	4	1.12	0.95	94.2629	0.0385	0.0000	0.0000;
	2343	1	0	0.373	0	0	1	1.0808213	-14.649355	110	4	1.12	0.95	94.2233	0.0061	0.0000	0.0000;
	2344	1	0.276	-0.53	0	0	1	1.0810958	-14.648287	110	4	1.12	0.95	94.2124	-0.0075	0.0000	0.0000;
	2345	1	4.143	0.27	0	0	1	1.0808502	-14.649867	110	4	1.12	0.95	94.2233	0.0044	0.0000	0.0000;
	2346	1	2.76	-0.243	0	0	1	1.0810431	-14.645525	110	4	1.12	0.95	94.2106	-0.0036	0.0000	0.0000;
	2347	1	7.821	1.17	0	0	1	1.0802957	-14.72962	110	4	1.12	0.95	94.3000	0.0097	0.0000	0.0000;
	2348	1	1.84	0.271	0	0	1	1.0803023	-14.728615	110	4	1.12	0.95	94.2996	0.0096	0.0000	0.0000;
	2349	2	33.903	26.202	0	0	1	1.0812716	-14.605355	110	4	1.12	0.95	94.1608	0.0000	0.0000	0.0000;
	2350	1	12.547	5.204	0	0	1	1.0811689	-14.615982	110	4	1.12	0.95	94.1644	0.0014	0.0000	0.0000;
	2351	1	16.416	1.491	0	0	1	1.0517899	-25.53487	110	4	1.12	0.95	101.9314	-1.4643	0.0000	0.0000;
	2352	1	5.346	0.56	0	0	1	1.0764605	-15.841099	110	4	1.12	0.95	93.8533	-0.8719	0.0000	0.0000;
	2353	1	1.751	0.343	0	0	1	1.0753751	-17.812778	110	4	1.12	0.95	95.5635	0.0666	0.0000	0.0000;
	2354	1	5.438	1.283	0	0	1	1.0753611	-17.814953	110	4	1.12	0.95	95.5642	0.0668	0.0000	0.0000;
	2355	1	10.697	0.342	0	0	1	1.0594858	-26.945966	110	4	1.12	0.95	102.6991	-1.7879	0.0000	0.0000;
	2356	1	5.153	2.177	0	0	1	1.1091113	-15.793316	110	4	1.12	0.95	95.6446	0.0038	0.0000	0.0000;
	2357	1	0	0	0	0	1	1.1092983	-15.792318	110	4	1.12	0.95	95.6313	0.0043	0.0000	0.0000;
	2358	1	11.758	0.351	0	0	1	1.0700946	-24.843472	110	4	1.12	0.95	100.6077	-2.0074	0.0000	0.0000;
	2359	1	1.841	-0.311	0	0	1	1.0670966	-24.084967	110	4	1.12	0.95	101.3563	-1.5866	0.0000	0.0000;
	2360	2	9.172	1.06	0	0	1	1.0854715	-13.217976	110	4	1.12	0.95	91.8846	-0.2345	0.0000	0.0000;
	2361	2	3.78	0	0	0	1	1.0842391	-14.296135	110	4	1.12	0.95	92.8915	-0.3685	0.0000	0.0000;
	2362	1	1.29	0.425	0	0	1	1.1129232	-13.411479	110	4	1.12	0.95	93.9730	0.0469	0.0000	0.0000;
	2363	1	0.737	-0.687	0	0	1	1.0676687	-26.609855	110	4	1.12	0.95	102.5543	-2.1617	0.0000	0.0000;
	2364	1	5.304	0.106	0	0	1	1.0734401	-17.996484	110	4	1.12	0.95	95.8883	0.1248	0.0000	0.0000;
	2365	1	0	0	0	0	1	1.0734401	-17.996484	110	4	1.12	0.95	95.8883	0.1248	0.0000	0.0000;
	2366	2	15.821	0.011	0	0	1	1.0800119	-17.554889	110	4	1.12	0.95	95.1504	0.0076	0.0000	0.0000;
	2367	2	0	0	0	0	1	1.0801631	-17.529773	110	4	1.12	0.95	95.1247	0.0073	0.0000	0.0000;
	2368	1	2.765	0.293	0	0	1	1.0784889	-23.355608	110	4	1.12	0.95	99.2603	-0.7642	0.0000	0.0000;
	2369	1	0	0	0	0	1	1.0824058	-15.443467	110	4	1.12	0.95	94.7820	-0.3012	0.0000	0.0000;
	2370	2	0	0	0	0	1	1.0842186	-15.279698	110	4	1.12	0.95	94.6451	-0.3263	0.0000	0.0000;
	2371	1	9.192	0.141	0	0	1	1.0457586	-29.878564	110	4	1.12	0.95	105.4024	-2.3451	0.0000	0.0000;
	2372	2	5.806	0.053	0	0	1	1.0776116	-17.070967	110	4	1.12	0.95	94.3027	-0.3680	0.0000	0.0000;
	2373	1	0.727	-0.273	0	0	1	1.0776131	-17.071275	110	4	1.12	0.95	94.3028	-0.3681	0.0000	0.0000;
	2374	1	6.736	0.743	0	0	1	1.0803964	-13.994506	110	4	1.12	0.95	92.7779	-0.3326	0.0000	0.0000;
	2375	1	6.721	0.86	0	0	1	1.083367	-14.473475	110	4	1.12	0.95	92.9081	-0.4704	0.0000	0.0000;
	2376	2	6.725	0.511	0	0	1	1.080039	-14.854663	110	4	1.12	0.95	93.6224	-0.3121	0.0000	0.0000;
	2377	1	5.16	0.277	0	0	1	1.0800695	-14.848701	110	4	1.12	0.95	93.6166	-0.3130	0.0000	0.0000;
	2378	1	6.276	0.246	0	0	1	1.0601244	-27.272894	110	4	1.12	0.95	103.2162	-2.1868	0.0000	0.0000;
	2379	1	6.26	0.888	0	0	1	1.079462	-14.925741	110	4	1.12	0.95	93.6927	-0.3036	0.0000	0.0000;
	2380	1	6.998	0.596	0	0	1	1.0849213	-13.296785	110	4	1.12	0.95	91.9601	-0.2295	0.0000	0.0000;
	2381	1	4.056	0.603	0	0	1	1.0806718	-13.713833	110	4	1.12	0.95	92.7401	-0.2389	0.0000	0.0000;
	2382	1	3.688	0.481	0	0	1	1.0790458	-14.859452	110	4	1.12	0.95	93.9473	-0.3238	0.0000	0.0000;
	2383	1	16.872	2.533	0	0	1	1.0827356	-10.879111	110	4	1.12	0.95	94.7847	-0.1173	0.0000	0.0000;
	2384	1	7.182	0	0	0	1	1.0822803	-14.218928	110	4	1.12	0.95	92.8524	-0.5251	0.0000	0.0000;
	2385	1	5.807	1.687	0	0	1	1.0805421	-13.48551	110	4	1.12	0.95	93.0747	-0.1598	0.0000	0.0000;
	2386	2	5.055	0.344	0	0	1	1.0556759	-23.150016	110	4	1.12	0.95	100.3058	-1.0160	0.0000	0.0000;
	2387	1	11.404	-0.02	0	0	1	1.062183	-24.007836	110	4	1.12	0.95	100.4674	-0.5394	0.0000	0.0000;
	2388	1	9.776	0.72	0	0	1	1.0554609	-24.932464	110	4	1.12	0.95	100.9081	-0.6091	0.0000	0.0000;
	2389	1	3.781	-0.537	0	0	1	1.0339157	-28.636626	110	4	1.12	0.95	107.9138	-1.9962	0.0000	0.0000;
	2390	1	9.941	0.949	0	0	1	1.080275	-14.031475	110	4	1.12	0.95	92.8059	-0.3419	0.0000	0.0000;
	2391	1	11.696	1.045	0	0	1	1.0815994	-14.684977	110	4	1.12	0.95	93.0284	-0.5685	0.0000	0.0000;
	2392	1	5.706	1.17	0	0	1	1.0782196	-13.753714	110	4	1.12	0.95	93.5110	-0.1775	0.0000	0.0000;
	2393	1	5.89	0.86	0	0	1	1.0783547	-14.920656	110	4	1.12	0.95	94.0410	-0.3122	0.0000	0.0000;
	2394	1	4.798	-2.996	0	0	1	1.0907086	-27.465129	110	4	1.12	0.95	102.9986	0.3250	0.0000	0.0000;
	2395	1	6.258	0.85	0	0	1	1.0791416	-14.876912	110	4	1.12	0.95	93.8709	-0.3160	0.0000	0.0000;
	2396	1	2.3	0.701	0	0	1	1.0835445	-13.491321	110	4	1.12	0.95	92.2179	-0.2272	0.0000	0.0000;
	2397	1	9.299	1.508	0	0	1	1.0781727	-13.762061	110	4	1.12	0.95	93.5192	-0.1776	0.0000	0.0000;
	2398	1	7.731	0.336	0	0	1	1.0816154	-13.656761	110	4	1.12	0.95	92.5463	-0.2838	0.0000	0.0000;
	2399	1	0	0	0	0	1	1.0671967	-24.916124	110	4	1.12	0.95	101.2511	-1.3778	0.0000	0.0000;
	2400	1	0	0	0	0	1	1.0790961	-17.02908	110	4	1.12	0.95	95.0159	-0.0674	0.0000	0.0000;
	2401	1	0	0	0	0	1	1.0693844	-17.335586	110	4	1.12	0.95	96.1038	-0.2895	0.0000	0.0000;
	2402	1	0	0	0	0	1	1.0835204	-15.371897	110	4	1.12	0.95	94.7402	-0.3335	0.0000	0.0000;
	2403	1	0	0	0	0	1	1.0916518	-21.134569	110	4	1.12	0.95	97.1113	-0.2469	0.0000	0.0000;
	2404	1	0	0	0	0	1	1.1139081	-15.992704	110	4	1.12	0.95	95.5610	-0.0343	0.0000	0.0000;
	2405	1	0	0	0	0	1	1.0720372	-16.542094	110	4	1.12	0.95	93.8869	-0.9878	0.0000	0.0000;
	2406	1	0	0	0	0	1	1.044576	-24.8653	110	4	1.12	0.95	100.1388	-0.0803	0.0000	0.0000;
	2407	1	0	0	0	0	1	1.0403024	-25.306606	110	4	1.12	0.95	100.7990	-0.0124	0.0000	0.0000;
	2408	1	0	0	0	0	1	1.0707301	-17.181879	110	4	1.12	0.95	95.4825	-0.1244	0.0000	0.0000;
	2409	1	0	0	0	0	1	1.0654921	-25.073795	110	4	1.12	0.95	101.5678	-1.3854	0.0000	0.0000;
	2410	1	0	0	0	0	1	1.0759689	-23.774622	110	4	1.12	0.95	100.0342	-1.4168	0.0000	0.0000;
	2411	1	0	0	0	0	1	1.0557339	-23.157215	110	4	1.12	0.95	100.3114	-1.0324	0.0000	0.0000;
	2412	1	0	0	0	0	1	1.0809511	-14.601995	110	4	1.12	0.95	93.1514	-0.6145	0.0000	0.0000;
	2413	1	0	0	0	0	1	1.068078	-24.76051	110	4	1.12	0.95	101.6125	-1.6015	0.0000	0.0000;
	2414	1	0	0	0	0	1	1.0409581	-25.249705	110	4	1.12	0.95	100.6814	-0.0180	0.0000	0.0000;
	2415	1	0	0	0	0	1	1.0507388	-28.999387	110	4	1.12	0.95	104.0405	-2.1547	0.0000	0.0000;
	2416	1	0	0	0	0	1	1.0399882	-25.357454	110	4	1.12	0.95	100.8526	-0.0101	0.0000	0.0000;
	2417	1	0	0	0	0	1	1.0507985	-28.992548	110	4	1.12	0.95	104.0339	-2.1557	0.0000	0.0000;
	2418	1	0	0	0	0	1	1.0691052	-24.973081	110	4	1.12	0.95	100.7643	-2.1052	0.0000	0.0000;
	2419	1	0	0	0	0	1	1.0752057	-15.747052	110	4	1.12	0.95	94.2981	-0.2047	0.0000	0.0000;
	2420	1	0	0	0	0	1	1.0574367	-25.445118	110	4	1.12	0.95	102.1615	-1.5555	0.0000	0.0000;
	2421	1	0	0	0	0	1	1.0822853	-14.590954	110	4	1.12	0.95	92.9380	-0.5760	0.0000	0.0000;
	2422	1	0	0	0	0	1	1.0793016	-16.366916	110	4	1.12	0.95	93.8847	-0.4295	0.0000	0.0000;
	2423	1	3.813	0.44	0	0	1	1.0895766	-9.5890738	110	4	1.12	0.95	91.9354	-0.1076	0.0000	0.0000;
	2424	1	2.397	0.341	0	0	1	1.0652028	-23.72852	110	4	1.12	0.95	99.8771	-0.6871	0.0000	0.0000;
	2425	1	4.334	-0.916	0	0	1	1.0497592	-25.507249	110	4	1.12	0.95	102.2848	-0.8441	0.0000	0.0000;
	2426	1	7.372	1.727	0	0	1	1.0512726	-26.238827	110	4	1.12	0.95	103.5951	-1.5651	0.0000	0.0000;
	2427	1	36.512	3.969	0	0	1	1.0481905	-26.068848	110	4	1.12	0.95	102.8345	-0.7867	0.0000	0.0000;
	2428	1	4.518	0.499	0	0	1	1.0793001	-16.848196	110	4	1.12	0.95	94.8824	-0.0509	0.0000	0.0000;
	2429	1	0	0.026	0	0	1	1.0792999	-16.848195	110	4	1.12	0.95	94.8824	-0.0509	0.0000	0.0000;
	2430	1	5.994	0.705	0	0	1	1.0802879	-16.672333	110	4	1.12	0.95	94.7172	-0.0545	0.0000	0.0000;
	2431	1	0	0.05	0	0	1	1.0803013	-16.681398	110	4	1.12	0.95	94.7184	-0.0545	0.0000	0.0000;
	2432	1	9.592	0.677	0	0	1	1.0663924	-26.006348	110	4	1.12	0.95	101.7947	-1.6740	0.0000	0.0000;
	2433	1	4.702	0.238	0	0	1	1.0572537	-25.460833	110	4	1.12	0.95	102.1935	-1.5541	0.0000	0.0000;
	2434	1	15.117	1.227	0	0	1	1.0691065	-24.971738	110	4	1.12	0.95	100.7636	-2.1053	0.0000	0.0000;
	2435	1	22.562	2.678	0	0	1	1.0469116	-25.935117	110	4	1.12	0.95	102.5692	-1.4351	0.0000	0.0000;
	2436	1	4.518	-1.727	0	0	1	1.0733172	-23.041729	110	4	1.12	0.95	98.9110	-0.8806	0.0000	0.0000;
	2437	1	9.219	-1.209	0	0	1	1.0734036	-23.111656	110	4	1.12	0.95	98.9598	-0.9019	0.0000	0.0000;
	2438	2	0	0	0	0	1	1.0751498	-22.918817	110	4	1.12	0.95	98.6243	-0.8986	0.0000	0.0000;
	2439	1	7.37	0.506	0	0	1	1.0837104	-15.20866	110	4	1.12	0.95	94.5828	-0.1790	0.0000	0.0000;
	2440	1	4.493	1.115	0	0	1	1.0840197	-19.754095	110	4	1.12	0.95	96.6072	-0.4650	0.0000	0.0000;
	2441	1	2.947	0.071	0	0	1	1.068167	-25.968794	110	4	1.12	0.95	102.0933	-1.9998	0.0000	0.0000;
	2442	1	5.721	0.821	0	0	1	1.1139872	-12.348375	110	4	1.12	0.95	93.6467	0.0036	0.0000	0.0000;
	2443	1	8.858	0.659	0	0	1	1.0502533	-29.182332	110	4	1.12	0.95	104.5505	-2.3176	0.0000	0.0000;
	2444	1	3.41	0.087	0	0	1	1.0638746	-18.286563	110	4	1.12	0.95	96.5911	-0.4568	0.0000	0.0000;
	2445	2	6.638	0.295	0	0	1	1.0516282	-28.350244	110	4	1.12	0.95	104.3872	-2.1249	0.0000	0.0000;
	2446	2	7.122	0.363	0	0	1	1.0530219	-22.549131	110	4	1.12	0.95	99.5384	-0.2290	0.0000	0.0000;
	2447	1	4.884	1.084	0	0	1	1.0776003	-17.414177	110	4	1.12	0.95	95.2861	-0.0165	0.0000	0.0000;
	2448	1	0	0	0	0	1	1.0776003	-17.414177	110	4	1.12	0.95	95.2861	-0.0165	0.0000	0.0000;
	2449	1	7.846	0.896	0	0	1	1.0662458	-18.036824	110	4	1.12	0.95	96.6272	-0.1750	0.0000	0.0000;
	2450	1	9.921	1.062	0	0	1	1.0661831	-18.017376	110	4	1.12	0.95	96.6550	-0.1778	0.0000	0.0000;
	2451	1	0	0	0	0	1	1.0567605	-22.428517	110	4	1.12	0.95	99.4687	-0.4680	0.0000	0.0000;
	2452	1	0	0	0	0	1	1.0499159	-24.371911	110	4	1.12	0.95	100.1713	-0.2632	0.0000	0.0000;
	2453	1	5.352	0.655	0	0	1	1.0764208	-15.552035	110	4	1.12	0.95	94.6513	-0.2695	0.0000	0.0000;
	2454	1	0.183	0.106	0	0	1	1.056606	-25.517029	110	4	1.12	0.95	101.8124	-1.5617	0.0000	0.0000;
	2455	2	10.676	2.086	0	0	1	1.0623364	-34.099522	110	5	1.12	0.95	105.5771	0.3577	0.0000	0.0000;
	2456	1	7.269	2	0	0	1	1.053683	-31.402338	110	5	1.12	0.95	106.1477	0.8652	0.0000	0.0000;
	2457	1	14.067	2	0	0	1	1.0914935	-26.214048	110	5	1.12	0.95	101.3583	0.8276	0.0000	0.0000;
	2458	2	22.507	19	0	0	1	1.0952371	-25.75975	110	5	1.12	0.95	100.4832	0.9235	0.0000	0.0000;
	2459	2	5.622	4	0	0	1	1.0952518	-25.75725	110	5	1.12	0.95	100.4813	0.9234	0.0000	0.0000;
	2460	1	6.23	1.5	0	0	1	1.0588239	-30.481356	110	5	1.12	0.95	104.9632	0.8772	0.0000	0.0000;
	2461	2	10.188	1	0	0	1	1.1091708	-34.530257	110	5	1.12	0.95	105.2732	-1.3846	0.0000	0.0000;
	2462	2	7.018	0.9	0	0	1	1.1091678	-34.53297	110	5	1.12	0.95	105.2741	-1.3847	0.0000	0.0000;
	2463	1	6.188	1	0	0	1	1.0940744	-25.893605	110	5	1.12	0.95	100.6934	0.9206	0.0000	0.0000;
	2464	1	6.999	1.8	0	0	1	1.0525012	-29.6235	110	5	1.12	0.95	105.3206	1.4728	0.0000	0.0000;
	2465	1	4.083	0.835	0	0	1	1.0662949	-36.322718	110	5	1.12	0.95	107.2351	0.0908	0.0000	0.0000;
	2466	1	13.504	1.5	0	0	1	1.0918501	-26.321801	110	5	1.12	0.95	101.2752	0.8591	0.0000	0.0000;
	2467	2	5.297	0.6	0	0	1	1.0534252	-33.425534	110	5	1.12	0.95	106.5908	0.8633	0.0000	0.0000;
	2468	1	3.115	1	0	0	1	1.0622718	-30.045471	110	5	1.12	0.95	104.3095	0.8329	0.0000	0.0000;
	2469	1	6.788	1.2	0	0	1	1.05399	-29.668957	110	5	1.12	0.95	105.1859	1.4041	0.0000	0.0000;
	2470	1	2.251	0.5	0	0	1	1.0537607	-32.052906	110	5	1.12	0.95	109.9062	0.7435	0.0000	0.0000;
	2471	1	13.504	2	0	0	1	1.0919323	-26.147297	110	5	1.12	0.95	101.1282	0.8941	0.0000	0.0000;
	2472	1	6.751	1	0	0	1	1.0925776	-26.249008	110	5	1.12	0.95	101.1102	0.8767	0.0000	0.0000;
	2473	1	0	0	0	0	1	1.0928181	-26.060793	110	5	1.12	0.95	101.5174	0.6435	0.0000	0.0000;
	2474	1	0	0	0	0	1	1.0930129	-26.063883	110	5	1.12	0.95	101.5030	0.6469	0.0000	0.0000;
	2475	2	7.775	1	0	0	1	1.0996476	-35.001177	110	5	1.12	0.95	106.5643	-1.3689	0.0000	0.0000;
	2476	1	3.559	0.73	0	0	1	1.0560807	-34.283229	110	5	1.12	0.95	106.6809	0.5060	0.0000	0.0000;
	2477	1	5.628	1	0	0	1	1.0543268	-31.908858	110	5	1.12	0.95	109.7356	0.7575	0.0000	0.0000;
	2478	2	20.619	4.068	0	0	1	1.0587091	-35.399385	110	5	1.12	0.95	106.4870	0.4077	0.0000	0.0000;
	2479	2	6.071	1.252	0	0	1	1.0587221	-35.404694	110	5	1.12	0.95	106.4870	0.4092	0.0000	0.0000;
	2480	2	8.588	3.2	0	0	1	1.048948	-28.128099	110	5	1.12	0.95	104.0469	1.6520	0.0000	0.0000;
	2481	1	11.03	3.7	0	0	1	1.0525197	-26.349672	110	5	1.12	0.95	103.3610	1.5886	0.0000	0.0000;
	2482	1	7.877	1	0	0	1	1.0554607	-31.771295	110	5	1.12	0.95	109.4631	0.7805	0.0000	0.0000;
	2483	1	8.909	3.6	0	0	1	1.0706952	-29.005639	110	5	1.12	0.95	103.4173	1.3440	0.0000	0.0000;
	2484	1	5.064	1	0	0	1	1.0418681	-36.742047	110	5	1.12	0.95	109.2405	0.6275	0.0000	0.0000;
	2485	1	4.291	0.835	0	0	1	1.0427501	-36.643929	110	5	1.12	0.95	109.1137	0.6079	0.0000	0.0000;
	2486	1	10.554	1	0	0	1	1.0492945	-33.301482	110	5	1.12	0.95	111.6715	0.4504	0.0000	0.0000;
	2487	1	11.408	2.295	0	0	1	1.0602293	-34.51095	110	5	1.12	0.95	105.9630	0.3902	0.0000	0.0000;
	2488	1	3.397	0.5	0	0	1	1.0439129	-37.694411	110	5	1.12	0.95	116.3790	-0.2500	0.0000	0.0000;
	2489	2	2.777	0.3	0	0	1	1.0561788	-35.031448	110	5	1.12	0.95	112.1354	0.1327	0.0000	0.0000;
	2490	2	2.777	0.5	0	0	1	1.080823	-35.782955	110	5	1.12	0.95	107.0337	-0.3970	0.0000	0.0000;
	2491	2	0.555	0.1	0	0	1	1.1008946	-34.884903	110	5	1.12	0.95	105.9963	-1.2292	0.0000	0.0000;
	2492	1	6.23	1.5	0	0	1	1.0602381	-30.856048	110	5	1.12	0.95	104.6697	0.8823	0.0000	0.0000;
	2493	2	4.528	0	0	0	1	1.0426019	-37.847134	110	5	1.12	0.95	116.7191	-0.2767	0.0000	0.0000;
	2494	1	0.954	0.2	0	0	1	1.0497357	-27.817674	110	5	1.12	0.95	103.8642	1.6453	0.0000	0.0000;
	2495	1	6.999	4.7	0	0	1	1.0579412	-25.228291	110	5	1.12	0.95	102.0303	1.5964	0.0000	0.0000;
	2496	2	5.094	0.5	0	0	1	1.1084521	-34.441961	110	5	1.12	0.95	105.0763	-1.2121	0.0000	0.0000;
	2497	1	0	0	0	0	1	1.1126729	-34.03645	110	5	1.12	0.95	104.5225	-1.2984	0.0000	0.0000;
	2498	1	0	0	0	0	1	1.1126462	-34.050178	110	5	1.12	0.95	104.5285	-1.2990	0.0000	0.0000;
	2499	2	6.23	2.6	0	0	1	1.0523731	-33.899319	110	5	1.12	0.95	107.0157	0.8102	0.0000	0.0000;
	2500	1	6.23	2.6	0	0	1	1.0522916	-33.897813	110	5	1.12	0.95	107.0237	0.8102	0.0000	0.0000;
	2501	1	9.553	0.2	0	0	1	1.0509703	-33.923504	110	5	1.12	0.95	107.1964	0.8280	0.0000	0.0000;
	2502	1	8.307	0.7	0	0	1	1.0507428	-33.950403	110	5	1.12	0.95	107.1914	0.8910	0.0000	0.0000;
	2503	1	9.003	2	0	0	1	1.0930201	-26.226716	110	5	1.12	0.95	100.9439	0.9108	0.0000	0.0000;
	2504	1	4.722	0.8	0	0	1	1.0934795	-26.18138	110	5	1.12	0.95	100.9065	0.8981	0.0000	0.0000;
	2505	1	1.666	0.4	0	0	1	1.1001079	-34.975637	110	5	1.12	0.95	106.3383	-1.3085	0.0000	0.0000;
	2506	1	0	0	0	0	1	1.0627788	-34.23718	110	5	1.12	0.95	105.5928	0.3287	0.0000	0.0000;
	2507	1	0	0	0	0	1	1.0618816	-34.146678	110	5	1.12	0.95	105.6974	0.3589	0.0000	0.0000;
	2508	2	34.959	6.989	0	0	1	1.0631058	-34.015073	110	5	1.12	0.95	105.4432	0.3430	0.0000	0.0000;
	2509	2	10.153	1.982	0	0	1	1.0663748	-33.767439	110	5	1.12	0.95	105.0542	0.2584	0.0000	0.0000;
	2510	1	0	0	0	0	1	1.0596905	-34.622992	110	5	1.12	0.95	106.0392	0.3966	0.0000	0.0000;
	2511	1	0	0	0	0	1	1.0618984	-34.134314	110	5	1.12	0.95	105.6646	0.3244	0.0000	0.0000;
	2512	1	14.339	2.817	0	0	1	1.0597197	-34.34515	110	5	1.12	0.95	105.9998	0.4053	0.0000	0.0000;
	2513	1	6.802	1.356	0	0	1	1.0550801	-35.54313	110	5	1.12	0.95	106.9253	0.5197	0.0000	0.0000;
	2514	1	4.501	0.939	0	0	1	1.0551041	-35.540805	110	5	1.12	0.95	106.9251	0.5204	0.0000	0.0000;
	2515	1	4.154	1	0	0	1	1.0583832	-31.235434	110	5	1.12	0.95	105.4979	0.7196	0.0000	0.0000;
	2516	1	6.681	1.6	0	0	1	1.0707275	-29.318825	110	5	1.12	0.95	103.3674	1.2779	0.0000	0.0000;
	2517	2	6.751	1.2	0	0	1	1.0598061	-24.815791	110	5	1.12	0.95	102.6819	1.3076	0.0000	0.0000;
	2518	1	5.516	2.5	0	0	1	1.0536047	-28.149553	110	5	1.12	0.95	104.0492	1.6768	0.0000	0.0000;
	2519	1	4.528	0.5	0	0	1	1.1065961	-34.895121	110	5	1.12	0.95	105.7569	-1.3707	0.0000	0.0000;
	2520	1	11.723	2.295	0	0	1	1.0542732	-35.556022	110	5	1.12	0.95	107.0162	0.5403	0.0000	0.0000;
	2521	1	9.944	1.982	0	0	1	1.0549294	-35.558781	110	5	1.12	0.95	106.9451	0.5238	0.0000	0.0000;
	2522	2	1.697	0.2	0	0	1	1.0514883	-28.073198	110	5	1.12	0.95	103.8117	1.5605	0.0000	0.0000;
	2523	1	1.696	0.7	0	0	1	1.0513304	-28.067378	110	5	1.12	0.95	103.8261	1.5762	0.0000	0.0000;
	2524	1	3.115	1	0	0	1	1.0537642	-31.508004	110	5	1.12	0.95	106.1936	0.8054	0.0000	0.0000;
	2525	1	0.209	0	0	0	1	1.0628365	-34.169676	110	5	1.12	0.95	105.5490	0.3349	0.0000	0.0000;
	2526	1	9.757	3.6	0	0	1	1.0705932	-29.342957	110	5	1.12	0.95	103.3966	1.2798	0.0000	0.0000;
	2527	1	0	0	0	0	1	1.0740929	-28.905316	110	5	1.12	0.95	102.8135	1.2106	0.0000	0.0000;
	2528	1	0	0	0	0	1	1.0744349	-28.896976	110	5	1.12	0.95	102.8070	1.2055	0.0000	0.0000;
	2529	1	0	0	0	0	1	1.0741655	-28.880749	110	5	1.12	0.95	102.8123	1.2074	0.0000	0.0000;
	2530	1	2.777	1	0	0	1	1.0517582	-34.065855	110	5	1.12	0.95	111.9130	0.3279	0.0000	0.0000;
	2531	1	6.225	1	0	0	1	1.1028144	-34.921141	110	5	1.12	0.95	106.4664	-1.5177	0.0000	0.0000;
	2532	1	11.423	2.5	0	0	1	1.0504814	-31.335047	110	5	1.12	0.95	106.2971	1.4285	0.0000	0.0000;
	2533	1	6.469	2.1	0	0	1	1.0613637	-29.47403	110	5	1.12	0.95	104.3425	1.3508	0.0000	0.0000;
	2534	2	22.508	5	0	0	1	1.0916067	-26.33328	110	5	1.12	0.95	101.3766	0.8317	0.0000	0.0000;
	2535	1	9.003	1	0	0	1	1.0938109	-26.150106	110	5	1.12	0.95	100.8559	0.8922	0.0000	0.0000;
	2536	1	5.627	1	0	0	1	1.0938414	-26.140402	110	5	1.12	0.95	100.8604	0.8913	0.0000	0.0000;
	2537	2	38.263	24	0	0	1	1.0771532	-22.084489	110	5	1.12	0.95	100.5941	0.8511	0.0000	0.0000;
	2538	1	4.662	1	0	0	1	1.0621831	-30.349731	110	5	1.12	0.95	104.6345	0.7281	0.0000	0.0000;
	2539	1	2.264	0	0	0	1	1.1079512	-34.715274	110	5	1.12	0.95	105.5333	-1.3969	0.0000	0.0000;
	2540	1	5.409	1.7	0	0	1	1.0507571	-27.34134	110	5	1.12	0.95	103.5704	1.6512	0.0000	0.0000;
	2541	1	1.125	0.2	0	0	1	1.0645295	-23.618823	110	5	1.12	0.95	103.0510	0.8558	0.0000	0.0000;
	2542	1	1.35	0.3	0	0	1	1.0645319	-23.618361	110	5	1.12	0.95	103.0508	0.8557	0.0000	0.0000;
	2543	1	8.268	1.669	0	0	1	1.0452523	-35.879377	110	5	1.12	0.95	108.8196	0.5250	0.0000	0.0000;
	2544	1	0	0	0	0	1	1.0851825	-27.405715	110	5	1.12	0.95	102.7428	0.8936	0.0000	0.0000;
	2545	1	8.688	1.773	0	0	1	1.0524519	-35.040133	110	5	1.12	0.95	107.3811	0.4747	0.0000	0.0000;
	2546	1	8.581	1.669	0	0	1	1.0575767	-34.802597	110	5	1.12	0.95	106.3677	0.4397	0.0000	0.0000;
	2547	1	3.962	0.5	0	0	1	1.1064688	-34.939424	110	5	1.12	0.95	105.7256	-1.3351	0.0000	0.0000;
	2548	1	7.849	1.565	0	0	1	1.0554104	-35.56749	110	5	1.12	0.95	106.8896	0.5065	0.0000	0.0000;
	2549	1	3.35	0.626	0	0	1	1.059216	-34.421048	110	5	1.12	0.95	106.0623	0.4081	0.0000	0.0000;
	2550	1	6.792	1	0	0	1	1.1067082	-34.914235	110	5	1.12	0.95	105.6912	-1.3387	0.0000	0.0000;
	2551	1	6.19	0.5	0	0	1	1.0847021	-27.601609	110	5	1.12	0.95	102.8711	0.8990	0.0000	0.0000;
	2552	1	10.188	1	0	0	1	1.1096443	-34.44498	110	5	1.12	0.95	104.9746	-1.2704	0.0000	0.0000;
	2553	1	5.627	1	0	0	1	1.0838037	-27.42705	110	5	1.12	0.95	102.2937	1.1280	0.0000	0.0000;
	2554	2	12.453	0	0	0	1	1.1109226	-34.313198	110	5	1.12	0.95	104.8166	-1.2929	0.0000	0.0000;
	2555	2	14.716	1	0	0	1	1.109839	-34.419598	110	5	1.12	0.95	104.9458	-1.2721	0.0000	0.0000;
	2556	1	4.502	1	0	0	1	1.0711163	-22.854362	110	5	1.12	0.95	100.9931	0.9961	0.0000	0.0000;
	2557	1	3.115	1	0	0	1	1.0550415	-30.965388	110	5	1.12	0.95	105.8343	0.8996	0.0000	0.0000;
	2558	1	9.003	1.6	0	0	1	1.069504	-23.014175	110	5	1.12	0.95	101.3330	1.0372	0.0000	0.0000;
	2559	1	11.423	2	0	0	1	1.0563128	-30.638923	110	5	1.12	0.95	105.5548	0.9156	0.0000	0.0000;
	2560	1	4.154	0	0	0	1	1.0517139	-34.419166	110	5	1.12	0.95	107.4833	0.5861	0.0000	0.0000;
	2561	1	9.003	1	0	0	1	1.0945376	-25.935585	110	5	1.12	0.95	100.6547	0.9140	0.0000	0.0000;
	2562	2	127.209	63	0	0	1	1.0440217	-32.042413	110	5	1.12	0.95	106.5849	1.9532	0.0000	0.0000;
	2563	1	4.879	0.8	0	0	1	1.0535928	-28.461137	110	5	1.12	0.95	104.0640	1.5521	0.0000	0.0000;
	2564	1	7.061	0.9	0	0	1	1.0439847	-32.097513	110	5	1.12	0.95	106.6785	1.9181	0.0000	0.0000;
	2565	1	6.791	1	0	0	1	1.1094076	-34.478892	110	5	1.12	0.95	105.0127	-1.2710	0.0000	0.0000;
	2566	2	3.606	1.3	0	0	1	1.0661041	-29.734016	110	5	1.12	0.95	103.9900	1.3102	0.0000	0.0000;
	2567	1	7.106	1.6	0	0	1	1.0647309	-22.785784	110	5	1.12	0.95	100.7820	1.3416	0.0000	0.0000;
	2568	1	1.06	0.2	0	0	1	1.0520714	-28.20862	110	5	1.12	0.95	103.9099	1.5624	0.0000	0.0000;
	2569	1	7.788	2	0	0	1	1.0501173	-31.415584	110	5	1.12	0.95	106.4189	1.3754	0.0000	0.0000;
	2570	2	11.665	1	0	0	1	1.0688737	-36.339923	110	5	1.12	0.95	107.6442	0.0515	0.0000	0.0000;
	2571	1	5.554	1	0	0	1	1.0682263	-36.384842	110	5	1.12	0.95	107.6421	0.0515	0.0000	0.0000;
	2572	1	0.523	0.104	0	0	1	1.0556361	-33.148073	110	5	1.12	0.95	106.1850	0.9083	0.0000	0.0000;
	2573	1	11.559	3.4	0	0	1	1.0540134	-27.095046	110	5	1.12	0.95	103.3557	1.6953	0.0000	0.0000;
	2574	1	10.258	2.086	0	0	1	1.0622628	-34.321718	110	5	1.12	0.95	105.6464	0.3406	0.0000	0.0000;
	2575	1	8.697	2.9	0	0	1	1.0680268	-23.563937	110	5	1.12	0.95	100.3463	1.1962	0.0000	0.0000;
	2576	2	7.268	2	0	0	1	1.0551195	-31.420854	110	5	1.12	0.95	105.9935	0.7634	0.0000	0.0000;
	2577	1	0.742	0.1	0	0	1	1.0616854	-28.70517	110	5	1.12	0.95	103.6954	1.3910	0.0000	0.0000;
	2578	1	8.268	1.669	0	0	1	1.0571518	-32.346442	110	5	1.12	0.95	105.7875	1.0695	0.0000	0.0000;
	2579	2	18.006	14.5	0	0	1	1.0684846	-23.162658	110	5	1.12	0.95	101.6196	1.0755	0.0000	0.0000;
	2580	2	11.816	8	0	0	1	1.0684786	-23.172465	110	5	1.12	0.95	101.6227	1.0773	0.0000	0.0000;
	2581	1	7.891	0.3	0	0	1	1.0444691	-33.608897	110	5	1.12	0.95	107.5710	1.3906	0.0000	0.0000;
	2582	2	6.665	1	0	0	1	1.1047333	-34.380712	110	5	1.12	0.95	105.9122	-1.4531	0.0000	0.0000;
	2583	2	6.231	0.2	0	0	1	1.0454469	-32.131181	110	5	1.12	0.95	106.8484	1.7192	0.0000	0.0000;
	2584	1	10.049	1.982	0	0	1	1.0552975	-34.235819	110	5	1.12	0.95	106.5043	0.6113	0.0000	0.0000;
	2585	1	3.635	1.5	0	0	1	1.0512816	-33.078509	110	5	1.12	0.95	106.8725	0.8338	0.0000	0.0000;
	2586	1	3.288	1	0	0	1	1.0712602	-29.277481	110	5	1.12	0.95	103.3086	1.2626	0.0000	0.0000;
	2587	2	9.565	2	0	0	1	1.081799	-22.605206	110	5	1.12	0.95	99.7276	0.6362	0.0000	0.0000;
	2588	1	10.384	2	0	0	1	1.0550651	-30.910847	110	5	1.12	0.95	105.7259	0.9220	0.0000	0.0000;
	2589	1	8.827	1	0	0	1	1.0543376	-32.39042	110	5	1.12	0.95	106.3897	0.7487	0.0000	0.0000;
	2590	2	13.504	2	0	0	1	1.0646969	-23.806429	110	5	1.12	0.95	102.0923	1.1718	0.0000	0.0000;
	2591	1	7.877	2	0	0	1	1.0891455	-27.083264	110	5	1.12	0.95	102.6313	0.5290	0.0000	0.0000;
	2592	1	6.749	1	0	0	1	1.0595149	-27.844871	110	5	1.12	0.95	104.0030	0.8027	0.0000	0.0000;
	2593	1	10.5	2.9	0	0	1	1.0498811	-30.857891	110	5	1.12	0.95	105.9949	1.5658	0.0000	0.0000;
	2594	1	6.749	0	0	0	1	1.0528358	-34.273149	110	5	1.12	0.95	107.2104	0.6067	0.0000	0.0000;
	2595	1	2.813	0.6	0	0	1	1.0928729	-26.047775	110	5	1.12	0.95	100.8501	0.9525	0.0000	0.0000;
	2596	1	4.501	0.6	0	0	1	1.0729206	-22.809459	110	5	1.12	0.95	101.2714	0.9165	0.0000	0.0000;
	2597	2	1.666	0.4	0	0	1	1.1052269	-34.401846	110	5	1.12	0.95	105.3971	-1.2961	0.0000	0.0000;
	2598	1	7.849	1.565	0	0	1	1.0561203	-35.546194	110	5	1.12	0.95	106.8048	0.4841	0.0000	0.0000;
	2599	1	12.456	2.504	0	0	1	1.0597628	-34.356801	110	5	1.12	0.95	105.8811	0.4121	0.0000	0.0000;
	2600	1	0	0	0	0	1	1.0624243	-30.772201	110	5	1.12	0.95	105.0586	0.5683	0.0000	0.0000;
	2601	1	0	0	0	0	1	1.0625839	-30.789281	110	5	1.12	0.95	105.0563	0.5646	0.0000	0.0000;
	2602	1	7.745	1.565	0	0	1	1.062188	-34.329365	110	5	1.12	0.95	105.6555	0.3424	0.0000	0.0000;
	2603	2	9.865	1.5	0	0	1	1.0646035	-29.728075	110	5	1.12	0.95	103.8662	0.7929	0.0000	0.0000;
	2604	1	0	0	0	0	1	1.0648753	-29.731235	110	5	1.12	0.95	103.8616	0.7895	0.0000	0.0000;
	2605	1	5.194	1.5	0	0	1	1.0595493	-29.269305	110	5	1.12	0.95	104.6260	0.7227	0.0000	0.0000;
	2606	1	14.13	2.817	0	0	1	1.0656092	-33.865592	110	5	1.12	0.95	105.1596	0.2748	0.0000	0.0000;
	2607	1	10.384	2	0	0	1	1.0614916	-30.057072	110	5	1.12	0.95	104.3975	0.8418	0.0000	0.0000;
	2608	1	6.802	1.356	0	0	1	1.0644482	-36.191339	110	5	1.12	0.95	106.6993	0.1287	0.0000	0.0000;
	2609	1	5.711	1	0	0	1	1.0644012	-29.767751	110	5	1.12	0.95	103.9319	0.8010	0.0000	0.0000;
	2610	1	14.538	1	0	0	1	1.0533652	-31.512462	110	5	1.12	0.95	106.2593	0.9375	0.0000	0.0000;
	2611	1	3.532	1.5	0	0	1	1.0571558	-31.981275	110	5	1.12	0.95	105.3912	0.9298	0.0000	0.0000;
	2612	1	2.223	0.3	0	0	1	1.1008162	-34.809601	110	5	1.12	0.95	106.5026	-1.4024	0.0000	0.0000;
	2613	1	16.319	3	0	0	1	1.0904226	-26.481975	110	5	1.12	0.95	101.9893	0.6446	0.0000	0.0000;
	2614	1	5.297	1	0	0	1	1.0617807	-30.032158	110	5	1.12	0.95	104.3843	0.8253	0.0000	0.0000;
	2615	2	8.827	1.5	0	0	1	1.0620568	-30.002576	110	5	1.12	0.95	104.2882	0.8346	0.0000	0.0000;
	2616	2	16.097	7.5	0	0	1	1.0625101	-29.973216	110	5	1.12	0.95	104.3052	0.7982	0.0000	0.0000;
	2617	2	9.003	1.3	0	0	1	1.074077	-22.69429	110	5	1.12	0.95	101.0831	0.9051	0.0000	0.0000;
	2618	1	4.501	1	0	0	1	1.0740019	-22.684835	110	5	1.12	0.95	101.0906	0.9051	0.0000	0.0000;
	2619	1	12.037	2.399	0	0	1	1.064242	-33.939174	110	5	1.12	0.95	105.3495	0.2987	0.0000	0.0000;
	2620	1	0.106	0.1	0	0	1	1.054174	-30.955967	110	5	1.12	0.95	105.7634	1.4040	0.0000	0.0000;
	2621	1	2.222	0.5	0	0	1	1.1069604	-34.472848	110	5	1.12	0.95	105.1508	-1.1433	0.0000	0.0000;
	2622	1	7.423	2	0	0	1	1.0819951	-21.657467	110	5	1.12	0.95	98.8742	0.6566	0.0000	0.0000;
	2623	1	8.827	3	0	0	1	1.0495467	-33.654479	110	5	1.12	0.95	107.2098	0.8796	0.0000	0.0000;
	2624	1	0	0	0	0	1	1.049546	-33.647812	110	5	1.12	0.95	107.2107	0.8791	0.0000	0.0000;
	2625	1	2.931	0.626	0	0	1	1.0546901	-33.899244	110	5	1.12	0.95	106.4938	0.7367	0.0000	0.0000;
	2626	1	3.768	0.73	0	0	1	1.0596202	-34.217461	110	5	1.12	0.95	106.0807	0.4136	0.0000	0.0000;
	2627	1	4.082	0.835	0	0	1	1.0593589	-34.397304	110	5	1.12	0.95	105.9400	0.4180	0.0000	0.0000;
	2628	1	0.831	0	0	0	1	1.0528342	-33.669722	110	5	1.12	0.95	106.8207	0.8323	0.0000	0.0000;
	2629	1	4.528	0.5	0	0	1	1.0989179	-35.614225	110	5	1.12	0.95	107.2378	-1.5319	0.0000	0.0000;
	2630	1	4.187	0.835	0	0	1	1.06283	-34.093553	110	5	1.12	0.95	105.5059	0.3438	0.0000	0.0000;
	2631	1	8.268	1.669	0	0	1	1.0608618	-34.243417	110	5	1.12	0.95	105.7354	0.3905	0.0000	0.0000;
	2632	1	5.834	1.3	0	0	1	1.0478334	-27.911111	110	5	1.12	0.95	104.1351	1.6874	0.0000	0.0000;
	2633	1	4.501	0.6	0	0	1	1.089183	-25.510744	110	5	1.12	0.95	101.4518	0.6781	0.0000	0.0000;
	2634	2	1.246	1	0	0	1	1.0561096	-32.750162	110	5	1.12	0.95	105.8096	0.9254	0.0000	0.0000;
	2635	1	1.801	0.3	0	0	1	1.0845799	-27.710846	110	5	1.12	0.95	103.3568	0.7133	0.0000	0.0000;
	2636	1	0.106	0.1	0	0	1	1.0501623	-28.424403	110	5	1.12	0.95	104.7992	1.5831	0.0000	0.0000;
	2637	2	14.13	2.817	0	0	1	1.058554	-34.492999	110	5	1.12	0.95	106.1357	0.4125	0.0000	0.0000;
	2638	1	5.628	1.5	0	0	1	1.071506	-28.846183	110	5	1.12	0.95	103.4979	1.3366	0.0000	0.0000;
	2639	1	7.315	1.5	0	0	1	1.0806722	-28.017547	110	5	1.12	0.95	102.7375	1.1949	0.0000	0.0000;
	2640	1	9.003	1.5	0	0	1	1.0705307	-22.989561	110	5	1.12	0.95	101.4484	1.0067	0.0000	0.0000;
	2641	2	6.908	1.356	0	0	1	1.0628094	-34.212783	110	5	1.12	0.95	105.5727	0.3322	0.0000	0.0000;
	2642	1	0	0	0	0	1	1.0618825	-34.146692	110	5	1.12	0.95	105.6974	0.3589	0.0000	0.0000;
	2643	1	10.696	1.1	0	0	1	1.0448796	-33.737411	110	5	1.12	0.95	107.6111	1.3209	0.0000	0.0000;
	2644	1	11.408	2.295	0	0	1	1.0542664	-35.51471	110	5	1.12	0.95	106.9987	0.5396	0.0000	0.0000;
	2645	1	14.339	2.817	0	0	1	1.0578997	-36.00293	110	5	1.12	0.95	106.9144	0.3867	0.0000	0.0000;
	2646	1	4.154	1	0	0	1	1.0553527	-30.741449	110	5	1.12	0.95	105.6818	0.9378	0.0000	0.0000;
	2647	1	0	0	0	0	1	1.093842	-26.14041	110	5	1.12	0.95	100.8604	0.8913	0.0000	0.0000;
	2648	1	14.423	3.5	0	0	1	1.0491594	-28.098756	110	5	1.12	0.95	104.0358	1.6409	0.0000	0.0000;
	2649	1	10.885	2.191	0	0	1	1.0580762	-35.646257	110	5	1.12	0.95	106.6775	0.4112	0.0000	0.0000;
	2650	1	2.588	0.5	0	0	1	1.0778236	-28.881496	110	5	1.12	0.95	104.7299	0.7750	0.0000	0.0000;
	2651	1	12.38	2	0	0	1	1.0924167	-26.088504	110	5	1.12	0.95	101.0127	0.9076	0.0000	0.0000;
	2652	2	8.896	1.773	0	0	1	1.0595322	-34.638113	110	5	1.12	0.95	106.0575	0.4008	0.0000	0.0000;
	2653	1	9.438	2.4	0	0	1	1.0491348	-29.051258	110	5	1.12	0.95	105.2956	1.5619	0.0000	0.0000;
	2654	1	4.56	1.4	0	0	1	1.0724596	-29.144988	110	5	1.12	0.95	103.0766	1.2473	0.0000	0.0000;
	2655	1	9.565	2.5	0	0	1	1.0778508	-23.343186	110	5	1.12	0.95	100.9892	0.8200	0.0000	0.0000;
	2656	1	6.751	1.5	0	0	1	1.0937603	-25.943051	110	5	1.12	0.95	100.6992	0.9451	0.0000	0.0000;
	2657	2	36.225	5.3	0	0	1	1.0588858	-36.032468	110	5	1.12	0.95	112.4846	0.0000	0.0000	0.0000;
	2658	1	9.056	0	0	0	1	1.0605778	-35.806291	110	5	1.12	0.95	112.2329	-0.0299	0.0000	0.0000;
	2659	1	7.923	1	0	0	1	1.0971319	-35.934351	110	5	1.12	0.95	107.4982	-1.5171	0.0000	0.0000;
	2660	1	0	0	0	0	1	1.1096605	-34.543402	110	5	1.12	0.95	105.2736	-1.4230	0.0000	0.0000;
	2661	1	5.628	1	0	0	1	1.0744599	-29.369779	110	5	1.12	0.95	105.3086	0.8279	0.0000	0.0000;
	2662	2	14.441	1	0	0	1	1.1045307	-34.571392	110	5	1.12	0.95	105.1728	-1.0593	0.0000	0.0000;
	2663	1	3.963	0	0	0	1	1.1077532	-34.571883	110	5	1.12	0.95	105.2195	-1.2300	0.0000	0.0000;
	2664	1	2.264	0.5	0	0	1	1.0536916	-36.611851	110	5	1.12	0.95	113.9809	-0.1344	0.0000	0.0000;
	2665	1	5.893	0.73	0	0	1	1.0417327	-36.192177	110	5	1.12	0.95	109.5142	0.5555	0.0000	0.0000;
	2666	2	2.407	0.522	0	0	1	1.0463115	-36.034774	110	5	1.12	0.95	108.6220	0.5178	0.0000	0.0000;
	2667	1	4.999	0.5	0	0	1	1.1068692	-34.532802	110	5	1.12	0.95	105.2048	-1.1475	0.0000	0.0000;
	2668	1	5.554	1	0	0	1	1.0947841	-35.165928	110	5	1.12	0.95	106.0685	-0.9455	0.0000	0.0000;
	2669	1	0	0	0	0	1	1.1070091	-34.239907	110	5	1.12	0.95	104.8362	-1.0134	0.0000	0.0000;
	2670	1	0	0	0	0	1	1.1069429	-34.257791	110	5	1.12	0.95	104.8428	-1.0173	0.0000	0.0000;
	2671	2	7.775	0.5	0	0	1	1.1012651	-34.783558	110	5	1.12	0.95	105.6425	-1.1109	0.0000	0.0000;
	2672	1	7.776	0.5	0	0	1	1.1013098	-34.777917	110	5	1.12	0.95	105.6454	-1.1100	0.0000	0.0000;
	2673	1	4.454	1.2	0	0	1	1.0708674	-29.34768	110	5	1.12	0.95	103.3998	1.2650	0.0000	0.0000;
	2674	1	14.339	2.817	0	0	1	1.0589848	-34.434762	110	5	1.12	0.95	105.9980	0.4215	0.0000	0.0000;
	2675	1	0.523	0.104	0	0	1	1.0597307	-34.367716	110	5	1.12	0.95	105.9793	0.3798	0.0000	0.0000;
	2676	2	14.548	2.921	0	0	1	1.0472461	-36.047882	110	5	1.12	0.95	108.3619	0.5377	0.0000	0.0000;
	2677	1	7.775	1	0	0	1	1.1018135	-34.748535	110	5	1.12	0.95	105.5684	-1.0918	0.0000	0.0000;
	2678	1	0.209	0	0	0	1	1.0589474	-34.458521	110	5	1.12	0.95	106.0931	0.4074	0.0000	0.0000;
	2679	1	14.538	2	0	0	1	1.0655544	-28.046672	110	5	1.12	0.95	103.3981	0.5299	0.0000	0.0000;
	2680	1	4.71	0.939	0	0	1	1.0549715	-35.554516	110	5	1.12	0.95	106.9408	0.5232	0.0000	0.0000;
	2681	1	3.939	0.8	0	0	1	1.0953504	-18.961935	110	5	1.12	0.95	97.7499	0.5408	0.0000	0.0000;
	2682	1	4.501	0.939	0	0	1	1.0548168	-33.623098	110	5	1.12	0.95	106.4023	0.8139	0.0000	0.0000;
	2683	1	6.335	0.3	0	0	1	1.0475957	-31.849854	110	5	1.12	0.95	106.7214	1.5485	0.0000	0.0000;
	2684	2	81.027	4	0	0	1	1.0717792	-28.807445	110	5	1.12	0.95	103.4875	1.3321	0.0000	0.0000;
	2685	1	3.289	0.6	0	0	1	1.0720719	-29.146915	110	5	1.12	0.95	103.1477	1.2502	0.0000	0.0000;
	2686	1	3.94	1	0	0	1	1.0881395	-26.985512	110	5	1.12	0.95	102.5240	0.6996	0.0000	0.0000;
	2687	1	14.026	2.817	0	0	1	1.0548981	-34.144609	110	5	1.12	0.95	106.5365	0.6526	0.0000	0.0000;
	2688	2	44.543	12.8	0	0	1	1.0513698	-28.073362	110	5	1.12	0.95	103.8194	1.5714	0.0000	0.0000;
	2689	1	0	0	0	0	1	1.0514571	-28.062535	110	5	1.12	0.95	103.8100	1.5699	0.0000	0.0000;
	2690	1	5.443	1.043	0	0	1	1.0551349	-35.557334	110	5	1.12	0.95	106.9203	0.5166	0.0000	0.0000;
	2691	1	9.757	2.2	0	0	1	1.0496745	-28.148881	110	5	1.12	0.95	104.0115	1.6172	0.0000	0.0000;
	2692	1	25.029	5.1	0	0	1	1.0495743	-28.141908	110	5	1.12	0.95	104.0142	1.6206	0.0000	0.0000;
	2693	2	7.635	2.2	0	0	1	1.0478368	-27.965472	110	5	1.12	0.95	104.1579	1.6784	0.0000	0.0000;
	2694	1	11.03	3.6	0	0	1	1.0478489	-27.385298	110	5	1.12	0.95	104.0215	1.7038	0.0000	0.0000;
	2695	1	7.314	1.5	0	0	1	1.0791219	-22.77997	110	5	1.12	0.95	100.1158	0.7015	0.0000	0.0000;
	2696	1	8.909	2.2	0	0	1	1.0492505	-28.17417	110	5	1.12	0.95	104.0743	1.6309	0.0000	0.0000;
	2697	1	6.751	1.5	0	0	1	1.0585212	-30.962256	110	5	1.12	0.95	107.9030	1.1114	0.0000	0.0000;
	2698	1	2.228	1.1	0	0	1	1.0481967	-28.078823	110	5	1.12	0.95	104.1259	1.6731	0.0000	0.0000;
	2699	1	7.775	1	0	0	1	1.1059987	-34.437442	110	5	1.12	0.95	105.1463	-1.0810	0.0000	0.0000;
	2700	1	3.963	0	0	0	1	1.1090346	-34.626274	110	5	1.12	0.95	105.2822	-1.3351	0.0000	0.0000;
	2701	1	10.075	3.6	0	0	1	1.0565145	-28.588473	110	5	1.12	0.95	104.0323	1.5438	0.0000	0.0000;
	2702	1	15.596	3.13	0	0	1	1.0579744	-36.386568	110	5	1.12	0.95	107.2755	0.2669	0.0000	0.0000;
	2703	1	13.084	2.608	0	0	1	1.0591858	-36.206601	110	5	1.12	0.95	106.9834	0.3112	0.0000	0.0000;
	2704	2	4.443	1	0	0	1	1.0663727	-36.40226	110	5	1.12	0.95	107.4517	0.1549	0.0000	0.0000;
	2705	1	13.397	2.712	0	0	1	1.0555642	-35.241362	110	5	1.12	0.95	106.7246	0.4992	0.0000	0.0000;
	2706	2	31.816	24	0	0	1	1.0579666	-25.829445	110	5	1.12	0.95	102.4633	1.5124	0.0000	0.0000;
	2707	1	42.422	34	0	0	1	1.0576636	-25.835025	110	5	1.12	0.95	102.4682	1.5177	0.0000	0.0000;
	2708	1	7.877	1.6	0	0	1	1.064492	-30.538273	110	5	1.12	0.95	104.4309	1.2435	0.0000	0.0000;
	2709	1	14.211	3.8	0	0	1	1.0554723	-25.507746	110	5	1.12	0.95	102.4721	1.6457	0.0000	0.0000;
	2710	2	19.726	4.7	0	0	1	1.0602696	-25.020081	110	5	1.12	0.95	101.6952	1.5129	0.0000	0.0000;
	2711	2	0	0	0	0	1	1.0602234	-25.03895	110	5	1.12	0.95	101.6976	1.5163	0.0000	0.0000;
	2712	1	12.62	3.6	0	0	1	1.0549297	-25.676404	110	5	1.12	0.95	102.6483	1.6270	0.0000	0.0000;
	2713	1	3.663	0.73	0	0	1	1.0595469	-34.379948	110	5	1.12	0.95	105.9402	0.3998	0.0000	0.0000;
	2714	1	0	0	0	0	1	1.062436	-30.032315	110	5	1.12	0.95	104.2929	0.8279	0.0000	0.0000;
	2715	1	0	0	0	0	1	1.1069685	-34.47222	110	5	1.12	0.95	105.1498	-1.1436	0.0000	0.0000;
	2716	1	0	0	0	0	1	1.0595603	-34.378807	110	5	1.12	0.95	105.9384	0.3994	0.0000	0.0000;
	2717	1	28.134	4	0	0	1	1.0948422	-25.824329	110	5	1.12	0.95	100.5528	0.9253	0.0000	0.0000;
	2718	1	1.125	0.5	0	0	1	1.095185	-25.763144	110	5	1.12	0.95	100.4874	0.9252	0.0000	0.0000;
	2719	1	6.385	1.252	0	0	1	1.0659345	-33.812597	110	5	1.12	0.95	105.1093	0.2685	0.0000	0.0000;
	2720	1	9.734	1.982	0	0	1	1.0624155	-34.084077	110	5	1.12	0.95	105.5283	0.3597	0.0000	0.0000;
	2721	1	29.695	4.4	0	0	1	1.0560998	-25.940327	110	5	1.12	0.95	102.7650	1.5588	0.0000	0.0000;
	2722	1	34.998	5.5	0	0	1	1.0560293	-25.954953	110	5	1.12	0.95	102.7711	1.5598	0.0000	0.0000;
	2723	1	5.66	0	0	0	1	1.0439901	-37.687953	110	5	1.12	0.95	116.3658	-0.2519	0.0000	0.0000;
	2724	1	7.477	2.8	0	0	1	1.0516605	-33.928449	110	5	1.12	0.95	107.0905	0.8431	0.0000	0.0000;
	2725	2	15.755	3.2	0	0	1	1.0656576	-23.521219	110	5	1.12	0.95	102.8358	0.8513	0.0000	0.0000;
	2726	1	0	0	0	0	1	1.0644942	-36.162207	110	5	1.12	0.95	106.6490	0.1269	0.0000	0.0000;
	2727	1	0	0	0	0	1	1.0645097	-36.166443	110	5	1.12	0.95	106.6479	0.1267	0.0000	0.0000;
	2728	1	6.188	1.8	0	0	1	1.0705094	-29.42748	110	5	1.12	0.95	104.4698	1.3479	0.0000	0.0000;
	2729	2	0	0	0	0	1	1.1103799	-33.817838	110	5	1.12	0.95	104.9866	-1.5011	0.0000	0.0000;
	2730	2	0	0	0	0	1	1.1103045	-33.8206	110	5	1.12	0.95	104.9976	-1.5005	0.0000	0.0000;
	2731	1	1.697	0.5	0	0	1	1.1081287	-34.187204	110	5	1.12	0.95	105.4250	-1.5032	0.0000	0.0000;
	2732	1	227.15	76.249	0	0	0	1.0245849	-11.217395	400	0	1.05	0.95	92.6305	-0.0286	0.0000	0.0000;
	2733	1	330.835	93.095	0	0	0	1.0248791	-10.670069	400	0	1.05	0.95	92.9799	0.0862	0.0000	0.0000;
	2734	1	0	0	0	0	0	1.1052161	-13.022031	220	0	1.11	0.95	93.9590	0.0000	0.0000	0.0000;
	2735	2	0	0	0	0	0	1.0322427	-12.9631	400	0	1.05	0.95	94.1240	-0.0812	0.0000	0.0000;
	2736	2	0	0	0	0	3	1.0859733	-8.9521512	220	0	1.11	0.95	91.9853	0.0000	0.0000	0.0000;
	2737	2	0	0	0	0	0	1.0846846	-24.054571	220	0	1.11	0.95	101.4513	-1.5643	0.0000	0.0000;
	2738	1	289.047	210.24	0	0	0	1.0088631	-18.931421	400	0	1.05	0.95	96.0836	-0.4298	0.0000	0.0000;
	2739	2	0	0	0	0	0	1.0266697	-32.830847	400	0	1.05	0.95	104.7603	-0.7604	0.0000	0.0000;
	2740	2	0	0	0	0	3	1.107855	-12.837365	110	0	1.12	0.95	91.4408	-0.0000	0.0000	0.0000;
	2741	1	33	12	0	0	2	1.061364	-16.055025	110	0	1.12	0.95	96.4527	1.3169	0.0000	0.0000;
	2742	1	33	12	0	0	2	1.0613071	-16.060769	110	0	1.12	0.95	96.4568	1.3179	0.0000	0.0000;
	2743	1	50	12	0	0	2	1.0345794	-20.173961	110	0	1.12	0.95	101.1069	1.5965	0.0000	0.0000;
	2744	1	51	14	0	0	2	1.0310914	-20.226447	110	0	1.12	0.95	101.2980	1.8480	0.0000	0.0000;
	2745	1	25	10	0	0	2	1.0543212	-16.711998	110	0	1.12	0.95	97.1624	1.4874	0.0000	0.0000;
	2746	1	68	26	0	0	2	1.0443603	-17.401831	110	0	1.12	0.95	98.0994	1.8294	0.0000	0.0000;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf	mu_Pmax	mu_Pmin	mu_Qmax	mu_Qmin
mpc.gen = [
	17	140	-10	120	-10	1.09088	233.2	1	200	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	15.5759	0.0000	0.0000;
	18	140	91.8892	120	-10	1.09091	233.2	1	200	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	15.5746	0.0000	0.0000;
	26	0	0	220	-10	1.09091	430.5	0	370	290	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	26	360	104.419	220	-10	1.09091	421.9	1	360	290	0	0	0	0	0	0	0	0	0	0	0	14.8717	0.0000	0.0000	0.0000;
	27	360	-10	220	-10	1.09091	421.9	1	360	290	0	0	0	0	0	0	0	0	0	0	0	14.0299	0.0000	0.0000	0.0000;
	27	370	80.9866	220	-10	1.09091	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	14.0299	0.0000	0.0000	0.0000;
	27	370	81.5609	220	-10	1.09091	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	14.0299	0.0000	0.0000	0.0000;
	28	0	0	220	-10	1.0325	430.5	0	370	290	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	28	370	-3.4539	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	15.0767	0.0000	0.0000	0.0000;
	28	370	-3.4539	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	15.0767	0.0000	0.0000	0.0000;
	29	370	-10	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	15.0718	0.0000	0.0000	0.0017;
	29	370	-10	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	15.0718	0.0000	0.0000	0.0017;
	29	370	-10	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	15.0718	0.0000	0.0000	0.0017;
	43	135	-20	120	-20	1.09091	246.2	1	215	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.7972	0.0000	0.6891;
	43	0	0	120	-20	1.09091	275.3	0	247.8	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	43	0	0	120	-20	1.09091	275.3	0	247.8	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	44	135	-20	120	-20	1.09096	255	1	225	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.8012	0.0000	0.6908;
	44	135	-20	120	-20	1.09096	255	1	225	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.8012	0.0000	0.6908;
	44	0	0	120	-20	1.09096	255	0	225	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	45	0	0	350	-40	1.0325	610.3	0	500	350	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	45	350	-40	350	-40	1.0325	610.3	1	500	350	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.4900	0.0000	0.5862;
	55	130	-20	120	-20	1.09121	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	11.0642	0.0000	1.1741;
	56	130	-20	120	-20	1.09115	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	11.0669	0.0000	1.1766;
	56	0	0	120	-20	1.09115	255	0	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	57	130	-20	120	-20	1.03336	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	10.8801	0.0000	1.2205;
	58	0	0	120	-20	1.03337	255	0	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	58	130	-20	120	-20	1.03337	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	10.8784	0.0000	1.2215;
	58	0	0	120	-20	1.03337	255	0	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	59	63	0	28.8	0	1.08415	69.3	1	63	63	0	0	0	0	0	0	0	0	0	0	0	94.7184	0.0000	0.0000	0.7196;
	78	140	5	105	5	1.09091	248.3	1	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.4345	0.0000	0.0000;
	78	140	50.0711	105	5	1.09091	248.3	1	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.4345	0.0000	0.0000;
	79	0	0	105	5	1.09034	243.8	0	220	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	79	0	0	105	5	1.09034	248.3	0	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	79	140	5	105	5	1.09034	248.3	1	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.1994	0.0000	0.1274;
	82	380	-37	192	-37	1.02993	425.8	1	380	220	0	0	0	0	0	0	0	0	0	0	0	1.2373	0.0000	0.0000	0.2746;
	82	370	-27.698	174	-27.698	1.02993	408.9	1	370	220	0	0	0	0	0	0	0	0	0	0	0	1.2373	0.0000	0.0000	0.2746;
	104	190.653	24.9606	113	-48	1.09091	251.8	1	225	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	105	0	0	113	-48	1.09091	251.8	0	225	134	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	106	79	38.0238	90	-5	1.09091	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.3737	0.0000	0.0000;
	107	79	-5	90	-5	1.09091	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.3711	0.0002	0.0000;
	116	0	0	90	-20	1.09042	150	0	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	117	70	-20	90	-20	1.09046	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.0830	0.0000	0.1170;
	118	80	33	68	33	1.089	129.3	1	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	5.0282	0.0000	0.2638;
	125	215	52.0648	113	-11	1.09091	242.9	1	215	160	0	0	0	0	0	0	0	0	0	0	0	1.1359	0.0000	0.0000	0.0000;
	126	225	84	84	-5	1.09082	240.2	1	225	140	0	0	0	0	0	0	0	0	0	0	0	1.1416	0.0000	0.0014	0.0000;
	126	0	0	80	-5	1.09082	229.4	0	215	160	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	127	225	-7.5	79	-7.5	1.02869	238.5	1	225	140	0	0	0	0	0	0	0	0	0	0	0	1.0016	0.0000	0.0000	0.1196;
	127	220	-10	100	-10	1.02869	241.7	1	220	160	0	0	0	0	0	0	0	0	0	0	0	1.0016	0.0000	0.0000	0.1196;
	132	0	0	0	0	1.09091	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	132	0	0	0	0	1.09091	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	133	0	0	0	0	1.09091	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	133	0	0	0	0	1.09091	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	134	0	0	90	0	1.08882	150	0	120	102	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	134	120	60.3687	90.001	0	1.08882	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	2.1817	0.0000	0.0000	0.0000;
	135	0	0	90	0	1.08867	150	0	120	102	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	146	50	-0.001	12	-0.001	1.09012	51.4	1	50	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0195;
	146	34.2659	-0.001	12	-0.001	1.09012	51.4	1	50	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0195;
	147	0	0	90	0	1.09011	150	0	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	90	0	120	0	1.09091	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	14.5527	0.0000	1.5655;
	148	0	0	120	0	1.09091	237.5	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	0	0	120	0	1.09091	237.5	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	90	0	120	0	1.09091	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	14.5527	0.0000	1.5655;
	150	90	0	120	0	1.03246	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	14.1633	0.0000	1.7352;
	151	90	0	120	0	1.0325	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	14.1607	0.0000	1.7356;
	151	0	0	120	0	1.0325	252.4	0	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	155	94	24.7759	120	0	1.09091	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.6502	0.0000	0.0000;
	155	94	24.7759	120	0	1.09091	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.6502	0.0000	0.0000;
	155	0	0	120	0	1.09091	237.5	0	205	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	155	104	0	120	0	1.09091	287.3	1	261	104	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.6502	0.0000	0.0000;
	156	0	0	120	0	1.09091	237.5	0	205	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	156	130	0	120	0	1.09091	237.5	1	205	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.4275	0.0000	0.0000;
	156	120	48.0433	120	0	1.09091	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.4275	0.0000	0.0000;
	156	120	0	120	0	1.09091	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.4275	0.0000	0.0000;
	159	120	0	120	0	1.00535	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.6973	0.0000	0.1124;
	165	200	64.1328	120	0	1.09084	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	7.3219	0.0000	0.0000	0.0000;
	165	0	0	120	0	1.09084	233.2	0	200	150	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	166	200	0	120	0	1.09091	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	7.3312	0.0000	0.0012	0.0000;
	165	0	0	120	0	1.09084	233.2	0	200	150	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	205	0	73.1915	80	-30	1.0325	196.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	105.9074	0.0000	0.0002	0.0000;
	205	0	-30	80	-30	1.0325	196.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	105.9074	0.0000	0.0002	0.0000;
	205	0	-30	80	-30	1.0325	196.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	105.9074	0.0000	0.0002	0.0000;
	206	0	-30	80	-30	1.0325	196.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	105.9064	0.0000	0.0017	0.0000;
	215	37.079	0	20	0	1.08646	58.5	1	37.079	37.079	0	0	0	0	0	0	0	0	0	0	0	94.4391	0.0000	0.0000	2.1719;
	215	33.708	0	20	0	1.08646	53.9	1	33.708	33.708	0	0	0	0	0	0	0	0	0	0	0	94.4391	0.0000	0.0000	2.1719;
	215	33.708	0	20	0	1.08646	53.9	1	33.708	33.708	0	0	0	0	0	0	0	0	0	0	0	94.4391	0.0000	0.0000	2.1719;
	215	15.506	0	20	0	1.08646	30.5	1	15.506	15.506	0	0	0	0	0	0	0	0	0	0	0	94.4391	0.0000	0.0000	2.1719;
	229	5.5	1.5	1.5	0	1.06367	7.3	1	5.5	5.5	0	0	0	0	0	0	0	0	0	0	0	93.6474	0.0000	0.1449	0.0000;
	230	5.5	7	7	0	1.06392	10	1	5.5	5.5	0	0	0	0	0	0	0	0	0	0	0	93.6442	0.0000	0.1324	0.0000;
	239	3	8	8	0	1.03337	15.4	1	3	3	0	0	0	0	0	0	0	0	0	0	0	98.9912	0.0000	0.4628	0.0000;
	246	370	135.153	220	-14	1.03502	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	14.3966	0.0000	0.0000	0.0000;
	291	2	1.18695	2	0	1.06439	3.2	1	2	2	0	0	0	0	0	0	0	0	0	0	0	96.0463	0.0000	0.0000	0.0000;
	294	2	2	2	0	1.05278	4.8	1	2	2	0	0	0	0	0	0	0	0	0	0	0	98.8780	0.0000	0.0223	0.0000;
	306	9.167	7	7	0	1.05332	24	1	9.167	9.167	0	0	0	0	0	0	0	0	0	0	0	93.5638	0.0000	0.3806	0.0000;
	306	16.296	7	7	0	1.05332	27.9	1	16.296	16.296	0	0	0	0	0	0	0	0	0	0	0	93.5638	0.0000	0.3806	0.0000;
	306	11.204	7.617	7.617	6	1.05332	31	1	11.204	11.204	0	0	0	0	0	0	0	0	0	0	0	93.5638	0.0000	0.3806	0.0000;
	306	9.167	7	7	0	1.05332	26.9	1	9.167	9.167	0	0	0	0	0	0	0	0	0	0	0	93.5638	0.0000	0.3806	0.0000;
	306	9.167	7.929	7.929	0	1.05332	28.1	1	9.167	9.167	0	0	0	0	0	0	0	0	0	0	0	93.5638	0.0000	0.3806	0.0000;
	307	36.5	15	15	0	1.05854	57	1	36.5	36.5	0	0	0	0	0	0	0	0	0	0	0	93.6380	0.0000	0.1551	0.0000;
	307	36.5	15	15	0	1.05854	57	1	36.5	36.5	0	0	0	0	0	0	0	0	0	0	0	93.6380	0.0000	0.1551	0.0000;
	308	32	15	15	0	1.067	36.7	1	32	32	0	0	0	0	0	0	0	0	0	0	0	93.0280	0.0000	0.0000	0.0000;
	308	40	13.385	16.829	0	1.067	57.5	1	40	40	0	0	0	0	0	0	0	0	0	0	0	93.0280	0.0000	0.0000	0.0000;
	310	35	20	20	0	1.07303	53.9	1	35	35	0	0	0	0	0	0	0	0	0	0	0	92.3616	0.0000	0.2446	0.0000;
	310	75	25.599	25.599	0	1.07303	103.2	1	75	75	0	0	0	0	0	0	0	0	0	0	0	92.3616	0.0000	0.2446	0.0000;
	311	45	36.9252	40	0	1.06272	64	1	45	45	0	0	0	0	0	0	0	0	0	0	0	92.6966	0.0000	0.0000	0.0000;
	319	2	3	3	0	1.07001	4.1	1	2	2	0	0	0	0	0	0	0	0	0	0	0	92.5697	0.0000	0.3046	0.0000;
	345	1	1	1	0	1.04796	1.9	1	1	1	0	0	0	0	0	0	0	0	0	0	0	98.3369	0.0000	0.2128	0.0000;
	362	40	12	12	0	1.08888	47.8	1	40	40	0	0	0	0	0	0	0	0	0	0	0	97.5443	0.0000	0.8758	0.0000;
	363	40	12	12	0	1.06039	47.8	1	40	40	0	0	0	0	0	0	0	0	0	0	0	97.3376	0.0000	0.2491	0.0000;
	364	0	0	12	0	1.1049	47.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	364	46	12	12	0	1.1049	71	1	46	46	0	0	0	0	0	0	0	0	0	0	0	97.1931	0.0000	0.9222	0.0000;
	365	40	12	12	0	1.06981	47.8	1	40	40	0	0	0	0	0	0	0	0	0	0	0	97.1158	0.0000	0.0480	0.0000;
	365	40	12	12	0	1.06981	47.8	1	40	40	0	0	0	0	0	0	0	0	0	0	0	97.1158	0.0000	0.0480	0.0000;
	368	1	1	1	0	1.07107	1.9	1	1	1	0	0	0	0	0	0	0	0	0	0	0	100.4026	0.0000	0.2196	0.0000;
	382	15	10	10	0	1.08182	55.9	1	55	15	0	0	0	0	0	0	0	0	0	0	0	0.0000	16.5255	0.0000	0.0000;
	382	120	39.2284	120	-10	1.08182	255.9	1	226	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	16.5255	0.0000	0.0000;
	383	15	0	10	0	1.10054	55.9	1	55	15	0	0	0	0	0	0	0	0	0	0	0	0.0000	15.6785	0.0000	0.3317;
	386	2.5	2	2	0	1.05805	4.8	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	94.4187	0.0000	0.1994	0.0000;
	395	1	1	1	0	1.06558	1.9	1	1	1	0	0	0	0	0	0	0	0	0	0	0	97.2930	0.0000	0.0918	0.0000;
	421	4	4	4	0	1.04857	7.7	1	4	4	0	0	0	0	0	0	0	0	0	0	0	97.6622	0.0000	0.4569	0.0000;
	426	3	3	3	0	1.07431	4.5	1	3	3	0	0	0	0	0	0	0	0	0	0	0	92.3661	0.0000	0.3703	0.0000;
	431	5	8	8	0	1.08943	13.6	1	5	5	0	0	0	0	0	0	0	0	0	0	0	98.9857	0.0000	0.2846	0.0000;
	440	2	2	2	0	1.0288	3.6	1	2	2	0	0	0	0	0	0	0	0	0	0	0	92.1929	0.0000	0.5449	0.0000;
	447	3.5	0	20	0	1.0498	21.3	1	3.5	3.5	0	0	0	0	0	0	0	0	0	0	0	96.8994	0.0000	0.0000	0.0459;
	447	3.5	0	20	0	1.0498	21.3	1	3.5	3.5	0	0	0	0	0	0	0	0	0	0	0	96.8994	0.0000	0.0000	0.0459;
	463	0	0	2	0	1.0465	4	1	0	0	0	0	0	0	0	0	0	0	0	0	0	97.8817	0.0000	0.0000	0.0795;
	482	1.4	0.7	0.7	0	1.02656	1.7	1	1.4	1.4	0	0	0	0	0	0	0	0	0	0	0	92.8550	0.0000	0.3906	0.0000;
	490	3	3	3	0	1.05535	5.3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	96.2362	0.0000	0.1945	0.0000;
	522	0	0	1	0	1.06929	1.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	92.7133	0.0000	0.0000	0.5925;
	533	0.5	1	1	0	1.07198	1.9	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	97.7699	0.0000	0.4967	0.0000;
	534	35.89	14	14	0	1.06429	53.9	1	35.89	35.89	0	0	0	0	0	0	0	0	0	0	0	95.3474	0.0000	0.0000	0.0000;
	534	22.086	9.23653	14	0	1.06429	34.9	1	22.086	22.086	0	0	0	0	0	0	0	0	0	0	0	95.3474	0.0000	0.0000	0.0000;
	534	22.086	9.23653	14	0	1.06429	34.9	1	22.086	22.086	0	0	0	0	0	0	0	0	0	0	0	95.3474	0.0000	0.0000	0.0000;
	534	72.469	11.4277	14	0	1.06429	105.9	1	72.469	72.469	0	0	0	0	0	0	0	0	0	0	0	95.3474	0.0000	0.0000	0.0000;
	534	72.469	11.4277	14	0	1.06429	105.9	1	72.469	72.469	0	0	0	0	0	0	0	0	0	0	0	95.3474	0.0000	0.0000	0.0000;
	535	24.573	14.7746	17.5	0	1.05783	36.5	1	24.573	24.573	0	0	0	0	0	0	0	0	0	0	0	95.0714	0.0000	0.0000	0.0000;
	535	23.805	14.8864	17.5	0	1.05783	35.6	1	23.805	23.805	0	0	0	0	0	0	0	0	0	0	0	95.0714	0.0000	0.0000	0.0000;
	535	95.99	15.7424	17.5	0	1.05783	126.2	1	95.99	95.99	0	0	0	0	0	0	0	0	0	0	0	95.0714	0.0000	0.0000	0.0000;
	535	80.631	8.02398	17.5	0	1.05783	106.4	1	80.631	80.631	0	0	0	0	0	0	0	0	0	0	0	95.0714	0.0000	0.0000	0.0000;
	549	1	0.7	0.7	0	1.0394	1.7	1	1	1	0	0	0	0	0	0	0	0	0	0	0	97.3005	0.0000	0.5909	0.0000;
	557	25.724	5.051	5.051	0	1.04037	34.4	1	25.724	25.724	0	0	0	0	0	0	0	0	0	0	0	96.7147	0.0000	0.4648	0.0000;
	557	21.184	5.051	5.051	0	1.04037	28.5	1	21.184	21.184	0	0	0	0	0	0	0	0	0	0	0	96.7147	0.0000	0.4648	0.0000;
	557	19.671	5	5	0	1.04037	26.5	1	19.671	19.671	0	0	0	0	0	0	0	0	0	0	0	96.7147	0.0000	0.4648	0.0000;
	557	22.697	5.051	5.051	0	1.04037	30.4	1	22.697	22.697	0	0	0	0	0	0	0	0	0	0	0	96.7147	0.0000	0.4648	0.0000;
	557	25.724	5.051	5.051	0	1.04037	34.4	1	25.724	25.724	0	0	0	0	0	0	0	0	0	0	0	96.7147	0.0000	0.4648	0.0000;
	558	31.032	5.064	5.064	0	1.03685	34.4	1	31.032	31.032	0	0	0	0	0	0	0	0	0	0	0	96.9085	0.0000	0.5815	0.0000;
	558	31.032	5.064	5.064	0	1.03685	34.4	1	31.032	31.032	0	0	0	0	0	0	0	0	0	0	0	96.9085	0.0000	0.5815	0.0000;
	558	22.817	5	5	0	1.03685	26.5	1	22.817	22.817	0	0	0	0	0	0	0	0	0	0	0	96.9085	0.0000	0.5815	0.0000;
	558	30.119	5.064	5.064	0	1.03685	34.4	1	30.119	30.119	0	0	0	0	0	0	0	0	0	0	0	96.9085	0.0000	0.5815	0.0000;
	581	3	3	3	0	1.0494	5.3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	99.2225	0.0000	0.0572	0.0000;
	594	2.07	0	1.08	0	1.06495	4.4	1	2.07	2.07	0	0	0	0	0	0	0	0	0	0	0	95.9622	0.0000	0.0000	0.5658;
	601	4.05	0	1.8	0	1.06191	4.4	1	4.05	4.05	0	0	0	0	0	0	0	0	0	0	0	96.1134	0.0000	0.0000	0.5785;
	622	110	-0.001	30	-0.001	1.0778	114	1	110	110	0	0	0	0	0	0	0	0	0	0	0	93.5080	0.0000	0.0000	0.3628;
	622	0	0	30	0	1.0778	65.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	626	2.25	0	0.9	0	1.07287	2.4	1	2.25	2.25	0	0	0	0	0	0	0	0	0	0	0	94.8395	0.0000	0.0000	0.8354;
	630	4.5	0	2.52	0	1.06945	5.2	1	4.5	4.5	0	0	0	0	0	0	0	0	0	0	0	95.5855	0.0000	0.0000	0.3682;
	631	5.4	0	2.52	0	1.06942	6	1	5.4	5.4	0	0	0	0	0	0	0	0	0	0	0	95.5638	0.0000	0.0000	0.3795;
	655	0.81	0	0.36	0	1.03169	0.9	1	0.81	0.81	0	0	0	0	0	0	0	0	0	0	0	97.6114	0.0000	0.0000	0.1649;
	660	135	31.0861	120	-20	1.08206	255	1	225	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	9.1261	0.0000	0.0000;
	661	135	-20	120	-20	1.08182	255	1	225	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	9.1168	0.0000	0.0008;
	667	1.89	0	0.72	0	1.03727	2	1	1.89	1.89	0	0	0	0	0	0	0	0	0	0	0	97.0908	0.0000	0.0000	0.1969;
	671	7.65	0	2.7	0	1.06812	8.6	1	7.65	7.65	0	0	0	0	0	0	0	0	0	0	0	95.8939	0.0000	0.0000	0.5902;
	673	2.7	0	0.9	0	1.06495	4.4	1	2.7	2.7	0	0	0	0	0	0	0	0	0	0	0	95.8719	0.0000	0.0000	0.5444;
	681	190	0	30	0	1.08024	192.4	1	190	190	0	0	0	0	0	0	0	0	0	0	0	93.9283	0.0000	0.0000	0.7815;
	681	24.998	0	30	0	1.08024	77.5	1	24.998	24.998	0	0	0	0	0	0	0	0	0	0	0	93.9283	0.0000	0.0000	0.7815;
	687	9	0	4.5	0	1.07512	10.1	1	9	9	0	0	0	0	0	0	0	0	0	0	0	94.6651	0.0000	0.0000	0.8043;
	699	5.4	0	2.7	0	1.0746	6	1	5.4	5.4	0	0	0	0	0	0	0	0	0	0	0	94.7284	0.0000	0.0000	0.7189;
	702	0.9	0	0.9	0	1.0721	1.3	1	0.9	0.9	0	0	0	0	0	0	0	0	0	0	0	94.8669	0.0000	0.0000	0.9548;
	712	9	0	2	0	1.07103	9.2	1	9	9	0	0	0	0	0	0	0	0	0	0	0	94.2161	0.0000	0.0000	0.7843;
	718	1.44	0	0.36	0	1.03111	1.5	1	1.44	1.44	0	0	0	0	0	0	0	0	0	0	0	97.6437	0.0000	0.0000	0.1589;
	722	2.25	0	0.9	0	1.06069	2.4	1	2.25	2.25	0	0	0	0	0	0	0	0	0	0	0	96.1198	0.0000	0.0000	0.6776;
	731	1.35	0	0.45	0	1.06199	4.3	1	1.35	1.35	0	0	0	0	0	0	0	0	0	0	0	95.3525	0.0000	0.0000	1.3409;
	736	130	-20	120	-20	1.08182	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	12.1228	0.0000	0.9490;
	740	1.8	0	0	0	1.06599	4.3	1	1.8	1.8	0	0	0	0	0	0	0	0	0	0	0	94.7195	0.0000	0.0000	0.6066;
	747	4.68	0	2.7	0	1.04853	5.4	1	4.68	4.68	0	0	0	0	0	0	0	0	0	0	0	97.8471	0.0000	0.0000	0.2746;
	759	90	0	30	0	1.0699	105.2	1	90	90	0	0	0	0	0	0	0	0	0	0	0	93.9174	0.0000	0.0000	0.6329;
	760	0	0	0	0	1.06824	1.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	778	9	0	30	0	1.05918	31.3	1	9	9	0	0	0	0	0	0	0	0	0	0	0	95.4277	0.0000	0.0000	0.6291;
	780	1.26	0	0.63	0	1.07776	1.4	1	1.26	1.26	0	0	0	0	0	0	0	0	0	0	0	93.5136	0.0000	0.0000	0.3631;
	783	6	0	3	0	1.07336	6.7	1	6	6	0	0	0	0	0	0	0	0	0	0	0	94.8328	0.0000	0.0000	0.7772;
	788	2	0	1	0	1.04756	95.9	1	2	2	0	0	0	0	0	0	0	0	0	0	0	97.6750	0.0000	0.0000	0.2928;
	792	0	0	23	0	1.05369	71.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	792	0	0	23	0	1.05369	71.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	792	0	0	11	0	1.05369	23.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	792	0	0	10	0	1.05369	23.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	803	0	0	10	0	1.08195	55.9	1	55	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	16.4810	0.0000	0.9588;
	804	0	0	10	0	1.07278	120.4	1	120	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	15.5620	0.0000	0.4856;
	809	0	0	0	0	1.07004	3.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	815	2.7	0	1.62	0	1.07164	3.1	1	2.7	2.7	0	0	0	0	0	0	0	0	0	0	0	95.3537	0.0000	0.0000	0.5128;
	834	0.9	0	0	0	1.05238	1.5	1	0.9	0.9	0	0	0	0	0	0	0	0	0	0	0	96.0748	0.0000	0.0000	1.4300;
	840	25	0	5.592	0	1.05932	51.3	1	25	25	0	0	0	0	0	0	0	0	0	0	0	95.1811	0.0000	0.0000	0.3013;
	840	25	0	5.592	0	1.05932	51.3	1	25	25	0	0	0	0	0	0	0	0	0	0	0	95.1811	0.0000	0.0000	0.3013;
	844	1.9	0.311	0.311	0	1.07659	3.5	1	1.9	1.9	0	0	0	0	0	0	0	0	0	0	0	95.2264	0.0000	0.0822	0.0000;
	848	3.011	0.011	0.011	0	1.05907	5.6	1	3.011	3.011	0	0	0	0	0	0	0	0	0	0	0	96.1546	0.0000	0.3529	0.0000;
	854	7	0.932	0.932	0	1.06201	14.5	1	7	7	0	0	0	0	0	0	0	0	0	0	0	93.9545	0.0000	0.5757	0.0000;
	873	68	7.82938	41.2	0	1.08182	87.7	1	68	68	0	0	0	0	0	0	0	0	0	0	0	91.9612	0.0000	0.0000	0.0000;
	876	0	0	0	0	1.0397	1.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	896	0	0	45	-10	1.06882	65.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	896	0	0	45	-10	1.06882	71.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	896	40	45	45	-10	1.06882	71.1	1	40	40	0	0	0	0	0	0	0	0	0	0	0	93.1233	0.0000	0.1059	0.0000;
	902	0.111	0.011	0.011	0	1.0143	0.3	1	0.111	0.111	0	0	0	0	0	0	0	0	0	0	0	97.5834	0.0000	0.4069	0.0000;
	903	0	0	0	0	1.01428	2.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	952	2.6	0	0.414	0	1.06079	3	1	2.6	2.6	0	0	0	0	0	0	0	0	0	0	0	95.9013	0.0000	0.0000	0.1186;
	958	0	0	0	0	1.04967	2.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	972	27	32	32	5	1.08182	54	1	27	27	0	0	0	0	0	0	0	0	0	0	0	92.2123	0.0000	0.0000	0.0000;
	972	0	0	32	5	1.08182	42.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	972	3	6.66458	7	1	1.08182	11.4	1	3	3	0	0	0	0	0	0	0	0	0	0	0	92.2123	0.0000	0.0000	0.0000;
	972	80	-0.742783	110	-40	1.08182	162.2	1	80	80	0	0	0	0	0	0	0	0	0	0	0	92.2123	0.0000	0.0000	0.0000;
	973	80	24.9465	110	-40	1.081	162.2	1	80	80	0	0	0	0	0	0	0	0	0	0	0	92.3394	0.0000	0.0000	0.0000;
	977	13.511	2.385	2.385	0	1.07617	13.7	1	13.511	13.511	0	0	0	0	0	0	0	0	0	0	0	92.2329	0.0000	0.2875	0.0000;
	986	5.1	0.828	0.828	0	1.06838	10.2	1	5.1	5.1	0	0	0	0	0	0	0	0	0	0	0	95.4434	0.0000	0.1864	0.0000;
	998	298.619	49.4135	172	-59	1.08182	422.6	1	386	220	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	999	291.954	45.5602	172	-59	1.08182	408	1	370	220	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1002	14.999	2.38	2.38	0	1.07543	17.8	1	14.999	14.999	0	0	0	0	0	0	0	0	0	0	0	92.2917	0.0000	0.2563	0.0000;
	1004	110	21.9066	110	-40	1.08182	174.1	1	110	110	0	0	0	0	0	0	0	0	0	0	0	92.0394	0.0000	0.0000	0.0000;
	1007	1	0	0.104	0	1.05246	2.5	1	1	1	0	0	0	0	0	0	0	0	0	0	0	96.5496	0.0000	0.0000	0.1065;
	1010	15.011	3.325	3.325	0	1.07605	51.6	1	15.011	15.011	0	0	0	0	0	0	0	0	0	0	0	94.6683	0.0000	0.0754	0.0000;
	1012	15	2.07	2.07	0	1.07258	32.9	1	15	15	0	0	0	0	0	0	0	0	0	0	0	94.9353	0.0000	0.2023	0.0000;
	1021	20	9	18	9	1.07091	30	1	20	20	0	0	0	0	0	0	0	0	0	0	0	96.1434	0.0000	0.0000	0.0386;
	1022	19.998	9	18	9	1.07091	30	1	19.998	19.998	0	0	0	0	0	0	0	0	0	0	0	96.1425	0.0000	0.0000	0.0389;
	1023	19.998	10.5	14	10.5	1.07084	32.2	1	19.998	19.998	0	0	0	0	0	0	0	0	0	0	0	96.1437	0.0000	0.0000	0.0388;
	1076	1	0	0	0	1.04784	3.2	1	1	1	0	0	0	0	0	0	0	0	0	0	0	92.8394	0.0000	0.0000	0.0992;
	1108	1	0	0	0	1.03858	3	1	1	1	0	0	0	0	0	0	0	0	0	0	0	94.0010	0.0000	0.0000	0.2170;
	1110	0	0	37.5	16.8	1.0762	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1111	0	0	37.5	7.5	1.07209	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1111	40	37.5	37.5	7.5	1.07209	62.5	1	40	40	0	0	0	0	0	0	0	0	0	0	0	93.2673	0.0000	0.0724	0.0000;
	1112	0	0	37.5	16.8	1.0749	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1114	4	0	0	0	1.07459	7.6	1	4	4	0	0	0	0	0	0	0	0	0	0	0	90.6134	0.0000	0.0648	0.0000;
	1129	6.999	0	1.139	0	1.07939	7.8	1	6.999	6.999	0	0	0	0	0	0	0	0	0	0	0	92.3936	0.0000	0.0000	0.4891;
	1151	20	3.625	3.625	0	1.06903	36.2	1	20	20	0	0	0	0	0	0	0	0	0	0	0	95.1794	0.0000	0.0719	0.0000;
	1152	25	3.625	3.625	0	1.06926	55.1	1	25	25	0	0	0	0	0	0	0	0	0	0	0	95.1281	0.0000	0.0672	0.0000;
	1153	20	3.624	3.624	0	1.07173	36.2	1	20	20	0	0	0	0	0	0	0	0	0	0	0	95.0234	0.0000	0.0510	0.0000;
	1178	0	0	42	16.8	1.08155	65.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1178	0	0	42	16.8	1.08155	65.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1178	60	26.5161	52.5	0	1.08155	87.5	1	60	60	0	0	0	0	0	0	0	0	0	0	0	92.4216	0.0000	0.0000	0.0000;
	1179	60	10.6967	52.5	0	1.08009	87.5	1	60	60	0	0	0	0	0	0	0	0	0	0	0	93.4632	0.0000	0.0000	0.0000;
	1179	45	26.5537	42	15.857	1.08009	65.3	1	45	45	0	0	0	0	0	0	0	0	0	0	0	93.4632	0.0000	0.0000	0.0000;
	1187	15	2.762	2.762	0	1.07567	22.2	1	15	15	0	0	0	0	0	0	0	0	0	0	0	93.0372	0.0000	0.2009	0.0000;
	1187	17	2.762	2.762	0	1.07567	50.1	1	17	17	0	0	0	0	0	0	0	0	0	0	0	93.0372	0.0000	0.2009	0.0000;
	1188	7.01	1.149	1.149	0	1.07815	9.4	1	7.01	7.01	0	0	0	0	0	0	0	0	0	0	0	92.4734	0.0000	0.0639	0.0000;
	1226	1	0	0.207	0	1.03771	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	98.5016	0.0000	0.0000	0.1738;
	1245	25	0	0	0	1.05668	53.2	1	25	25	0	0	0	0	0	0	0	0	0	0	0	93.6277	0.0000	0.4402	0.0000;
	1246	20	0	0	0	1.06963	31.2	1	20	20	0	0	0	0	0	0	0	0	0	0	0	92.8382	0.0000	0.1751	0.0000;
	1247	5	0	0	0	1.06049	11.6	1	5	5	0	0	0	0	0	0	0	0	0	0	0	96.1691	0.0000	0.3182	0.0000;
	1279	4.5	1.036	1.036	0	1.07062	5.6	1	4.5	4.5	0	0	0	0	0	0	0	0	0	0	0	93.2860	0.0000	0.2753	0.0000;
	1285	50	41	41	-6.5	1.07109	68.6	1	50	50	0	0	0	0	0	0	0	0	0	0	0	96.1059	0.0000	0.0438	0.0000;
	1286	228.97	78.4934	113	-48	1.08182	256.3	1	230	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1287	193.864	100.193	113	-48	1.08164	251.8	1	225	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1296	0.2	0	0	0	1.05518	0.5	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	92.4920	0.0000	0.2041	0.0000;
	1330	2.011	0.011	0.011	0	1.02889	3.5	1	2.011	2.011	0	0	0	0	0	0	0	0	0	0	0	95.4952	0.0000	0.3259	0.0000;
	1341	20	0	0	0	1.05157	32	1	20	20	0	0	0	0	0	0	0	0	0	0	0	92.4718	0.0000	0.2999	0.0000;
	1342	20	0	0	0	1.05156	34	1	20	20	0	0	0	0	0	0	0	0	0	0	0	92.4724	0.0000	0.3001	0.0000;
	1350	0	0	90	-5	1.08182	142.1	0	110	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1350	79	12.344	90	-5	1.08182	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.4338	0.0000	0.0000;
	1351	79	31.4683	90	-5	1.08182	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	1.7207	0.0000	0.0000;
	1352	0	0	90	-5	1.08208	150	0	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1362	76	56.9569	85	-21	1.08182	151.2	1	125	76	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.1246	0.0000	0.0000;
	1362	76	56.9569	85	-21	1.08182	151.2	1	125	76	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.1246	0.0000	0.0000;
	1373	90	16.1317	80	-25	1.07336	141.7	1	90	90	0	0	0	0	0	0	0	0	0	0	0	94.3780	0.0000	0.0000	0.0000;
	1373	90	16.1317	80	-25	1.07336	128.1	1	90	90	0	0	0	0	0	0	0	0	0	0	0	94.3780	0.0000	0.0000	0.0000;
	1374	90	21.2812	80	-25	1.07346	143.4	1	90	90	0	0	0	0	0	0	0	0	0	0	0	94.3771	0.0000	0.0000	0.0000;
	1375	90	6.12069	80	-25	1.06982	136	1	90	90	0	0	0	0	0	0	0	0	0	0	0	95.1869	0.0000	0.0000	0.0000;
	1415	0	0	33.5	12	1.07071	36.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1416	0	0	41.2	-13.7	1.07309	68.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1416	50	-1.78784	41.2	-13.7	1.07309	68.7	1	50	50	0	0	0	0	0	0	0	0	0	0	0	92.8193	0.0000	0.0000	0.0000;
	1429	2	0	0	0	1.03432	4.5	1	2	2	0	0	0	0	0	0	0	0	0	0	0	96.6714	0.0000	1.2937	0.0000;
	1433	14.999	0	0	0	1.06274	20	1	14.999	14.999	0	0	0	0	0	0	0	0	0	0	0	94.3998	0.0000	0.5790	0.0000;
	1434	4	0.69	0.69	0	1.05913	4.1	1	4	4	0	0	0	0	0	0	0	0	0	0	0	94.1064	0.0000	0.6748	0.0000;
	1435	13.999	4.66	4.66	0	1.06873	30.4	1	13.999	13.999	0	0	0	0	0	0	0	0	0	0	0	93.1424	0.0000	0.4241	0.0000;
	1436	13.999	4.66	4.66	0	1.07073	19.3	1	13.999	13.999	0	0	0	0	0	0	0	0	0	0	0	92.9589	0.0000	0.3710	0.0000;
	1440	140	69.743	105	5	1.08182	248.3	1	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.0600	0.0000	0.0000;
	1444	3	0.69	0.69	0	1.0759	3.1	1	3	3	0	0	0	0	0	0	0	0	0	0	0	93.8461	0.0000	0.1450	0.0000;
	1462	0	0	35	-6	1.05055	57.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1462	0	0	35	-6	1.05055	57.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1462	1	0	0	0	1.05055	2.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	98.1751	0.0000	0.0000	0.3464;
	1494	0.4	0	0	0	1.03727	0.8	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	94.1537	0.0000	0.0000	0.2536;
	1518	0	0	0	0	1.06183	2.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1519	0.3	0	0	0	1.06186	0.9	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	91.3855	0.0000	0.0000	0.0491;
	1520	2.011	0	0.011	0	1.03584	4.7	1	2.011	2.011	0	0	0	0	0	0	0	0	0	0	0	94.2333	0.0000	0.0000	0.2762;
	1521	3	0	0	0	1.03584	6.4	1	3	3	0	0	0	0	0	0	0	0	0	0	0	94.2335	0.0000	0.0000	0.2762;
	1543	1.8	0	0.276	0	1.0679	3	1	1.8	1.8	0	0	0	0	0	0	0	0	0	0	0	95.3298	0.0000	0.0000	0.0114;
	1546	3.2	0.552	0.552	0	1.05601	3.2	1	3.2	3.2	0	0	0	0	0	0	0	0	0	0	0	94.5723	0.0000	0.7250	0.0000;
	1547	3.2	0.552	0.552	0	1.05921	3.2	1	3.2	3.2	0	0	0	0	0	0	0	0	0	0	0	94.7536	0.0000	0.8895	0.0000;
	1580	1	0	0	0	1.01083	2.3	1	1	1	0	0	0	0	0	0	0	0	0	0	0	97.6532	0.0000	0.4140	0.0000;
	1594	1	0	0.062	0	1.05234	2.5	1	1	1	0	0	0	0	0	0	0	0	0	0	0	95.7411	0.0000	0.0000	0.4896;
	1647	0	0	9.3	1.9	1.051	16.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1647	10	1.256	9.3	1.256	1.051	16.8	1	10	10	0	0	0	0	0	0	0	0	0	0	0	96.4656	0.0000	0.0000	0.5343;
	1647	0	0	9.3	1.9	1.051	16.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1647	0	0	9.3	2	1.051	16.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1647	1.2	0	0.644	0	1.051	8	1	1.2	1.2	0	0	0	0	0	0	0	0	0	0	0	96.4656	0.0000	0.0000	0.5343;
	1675	55	39.4713	115	-70	1.08182	191.4	1	153	55	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.1640	0.0000	0.0000;
	1676	0	0	90	-20	1.08182	156.5	0	128	70	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1676	55	31.1718	115	-70	1.08182	191.4	1	153	55	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.5757	0.0000	0.0000;
	1677	0	0	90	5	1.07956	152.4	0	123	70	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1687	80	32.447	55	32.447	1.07109	123	1	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.4491	0.0000	0.1442;
	1687	0.3	0	0.552	0	1.07109	1.7	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	95.0709	0.0000	0.0000	0.1442;
	1688	0	0	42	16.8	1.07082	61.6	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1688	0	0	55	33	1.07082	123	0	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1688	0	0	42	16.8	1.07082	61.6	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1688	80	32.169	68	32.169	1.07082	129.3	1	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.3806	0.0000	0.3498;
	1688	30	16	40	16	1.07082	60.2	1	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.3806	0.0000	0.3498;
	1742	0.4	0	0.106	0	1.03613	0.5	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	96.9722	0.0000	0.0000	0.3680;
	1749	1	0	0	0	1.0531	2.5	1	1	1	0	0	0	0	0	0	0	0	0	0	0	95.1513	0.0000	0.7336	0.0000;
	1760	2.7	0.69	0.69	0	1.06925	2.8	1	2.7	2.7	0	0	0	0	0	0	0	0	0	0	0	93.4427	0.0000	0.3420	0.0000;
	1774	4.3	0.622	0.622	0	1.08082	8.5	1	4.3	4.3	0	0	0	0	0	0	0	0	0	0	0	92.3313	0.0000	0.0275	0.0000;
	1779	0	0	6.6	0.7	1.07004	8.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1798	15	0	3.625	0	1.08429	25.6	1	15	15	0	0	0	0	0	0	0	0	0	0	0	92.6281	0.0000	0.0000	0.4214;
	1799	32	26	26	13	1.06944	47.7	1	32	32	0	0	0	0	0	0	0	0	0	0	0	94.3658	0.0000	0.2664	0.0000;
	1841	0	0	83	-5	1.08182	239.8	0	225	160	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1841	174.543	49.743	113	-11	1.08182	251.8	1	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1843	225	76	76	-8	1.08133	237.5	1	225	160	0	0	0	0	0	0	0	0	0	0	0	0.5995	0.0000	0.1706	0.0000;
	1847	3.2	0	0.518	0	1.08378	3.6	1	3.2	3.2	0	0	0	0	0	0	0	0	0	0	0	92.6496	0.0000	0.0000	0.4096;
	1849	0.5	0	0.104	0	1.05074	6.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	96.7613	0.0000	0.0000	0.1003;
	1852	3.011	0.539	0.539	0	1.07681	5	1	3.011	3.011	0	0	0	0	0	0	0	0	0	0	0	92.8227	0.0000	0.0871	0.0000;
	1865	3.6	0	0.518	0	1.03598	12	1	3.6	3.6	0	0	0	0	0	0	0	0	0	0	0	96.9866	0.0000	0.0000	0.3713;
	1877	0	0	26	13	1.06856	43.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1877	0	0	8.3	1.5	1.06856	11.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1878	20	5.8	12	5.8	1.07254	27.7	1	20	20	0	0	0	0	0	0	0	0	0	0	0	92.7795	0.0000	0.0000	0.0861;
	1878	19.998	10.965	26	10.965	1.07254	39.7	1	19.998	19.998	0	0	0	0	0	0	0	0	0	0	0	92.7795	0.0000	0.0000	0.0861;
	1885	1	0	0	0	1.0771	1.8	1	1	1	0	0	0	0	0	0	0	0	0	0	0	90.3362	0.0000	0.0386	0.0000;
	1911	15	4.97	4.97	0	1.05998	32.4	1	15	15	0	0	0	0	0	0	0	0	0	0	0	94.1878	0.0000	0.6510	0.0000;
	1912	15	4.97	4.97	0	1.05993	32.4	1	15	15	0	0	0	0	0	0	0	0	0	0	0	94.1897	0.0000	0.6512	0.0000;
	1930	9.999	1.657	1.657	0	1.04471	21.1	1	9.999	9.999	0	0	0	0	0	0	0	0	0	0	0	97.3583	0.0000	0.3276	0.0000;
	1932	120	12.8078	90	0	1.08182	150	1	120	102	0	0	0	0	0	0	0	0	0	0	0	0.3946	0.0000	0.0000	0.0000;
	1933	120	29.7951	90	0	1.08182	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	1.1507	0.0000	0.0000	0.0000;
	1969	50	0	15	0	1.07636	52.2	1	50	50	0	0	0	0	0	0	0	0	0	0	0	92.8959	0.0000	0.0000	0.1672;
	1969	0	0	15	0	1.07636	52.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1970	30	0	10	0	1.07328	33.5	1	30	30	0	0	0	0	0	0	0	0	0	0	0	92.7919	0.0000	0.0000	0.5673;
	1996	90	0	120	0	1.08182	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	15.0700	0.0000	1.5959;
	2002	0	0	8	0	1.0804	27.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2002	0	0	8	0	1.0804	28.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2002	0	0	8	0	1.0804	27.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2006	40	0	15	0	1.07164	57	1	40	40	0	0	0	0	0	0	0	0	0	0	0	100.1632	0.0000	0.0000	1.9062;
	2006	90	0	80	0	1.07164	128.1	1	90	90	0	0	0	0	0	0	0	0	0	0	0	100.1632	0.0000	0.0000	1.9062;
	2007	100	0	90	0	1.07136	150.4	1	100	100	0	0	0	0	0	0	0	0	0	0	0	100.1690	0.0000	0.0000	1.9346;
	2019	25	0	10	0	1.08182	30.2	1	25	25	0	0	0	0	0	0	0	0	0	0	0	99.9233	0.0000	0.0000	1.4818;
	2019	0	0	10	0	1.08182	30.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2019	50	0	12	0	1.08182	55.8	1	50	50	0	0	0	0	0	0	0	0	0	0	0	99.9233	0.0000	0.0000	1.4818;
	2020	5	0	2	0	1.07576	5.4	1	5	5	0	0	0	0	0	0	0	0	0	0	0	100.7258	0.0000	0.0000	1.3528;
	2020	0	0	2	0	1.07576	6.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2046	90	44.877	90	0	1.08091	150	1	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.6539	0.0000	0.0000;
	2068	0	0	1	0	1.0521	3.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2068	4	2	2	0	1.0521	4.5	1	4	4	0	0	0	0	0	0	0	0	0	0	0	96.1490	0.0000	0.0622	0.0000;
	2095	25	1.97748	12	0	1.08091	51.4	1	50	25	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.6508	0.0000	0.0000;
	2095	30	1.97748	12	0	1.08091	51.4	1	50	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.6508	0.0000	0.0000;
	2096	20	4.40118	10.008	0	1.08183	29.7	1	28	20	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.3214	0.0000	0.0000;
	2098	30	0.59374	12	0	1.03199	56.3	1	55	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.2610	0.0000	0.0000;
	2218	200	57.4505	120	0	1.08182	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	5.9374	0.0000	0.0000	0.0000;
	2219	200	16.4631	120	0	1.08182	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	6.5130	0.0000	0.0000	0.0000;
	2257	50.1	0	15	0	1.07394	66.7	1	50.1	50.1	0	0	0	0	0	0	0	0	0	0	0	101.7144	0.0000	0.0000	1.4626;
	2258	50	0	15	0	1.07396	66.7	1	50	50	0	0	0	0	0	0	0	0	0	0	0	101.7152	0.0000	0.0000	1.4622;
	2334	20	0	15	0	1.07375	58	1	20	20	0	0	0	0	0	0	0	0	0	0	0	101.7496	0.0000	0.0000	1.4849;
	2334	0	0	6	0	1.07375	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2334	0	0	2	0	1.07375	4.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2349	94	12.1766	120	0	1.08182	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.6792	0.0000	0.0000;
	2360	44.2	0	15	0	1.08182	52.2	1	44.2	44.2	0	0	0	0	0	0	0	0	0	0	0	91.8846	0.0000	0.0000	0.2345;
	2360	70	0	80	0	1.08182	128.1	1	70	70	0	0	0	0	0	0	0	0	0	0	0	91.8846	0.0000	0.0000	0.2345;
	2361	80	0	80	0	1.08182	128.1	1	80	80	0	0	0	0	0	0	0	0	0	0	0	92.8915	0.0000	0.0000	0.3685;
	2438	8	0	10	0	1.08182	14.5	1	8	8	0	0	0	0	0	0	0	0	0	0	0	98.6243	0.0000	0.0000	0.8986;
	2438	8	0	10	0	1.08182	15.6	1	8	8	0	0	0	0	0	0	0	0	0	0	0	98.6243	0.0000	0.0000	0.8986;
	2458	36.485	15	15	0	1.1181	52.2	1	36.485	36.485	0	0	0	0	0	0	0	0	0	0	0	100.4832	0.0000	0.9235	0.0000;
	2458	40.138	1	1	0	1.1181	55	1	40.138	40.138	0	0	0	0	0	0	0	0	0	0	0	100.4832	0.0000	0.9235	0.0000;
	2458	53.376	1	1	0	1.1181	53.4	1	53.376	53.376	0	0	0	0	0	0	0	0	0	0	0	100.4832	0.0000	0.9235	0.0000;
	2459	21.461	5	5	0	1.11811	55.2	1	21.461	21.461	0	0	0	0	0	0	0	0	0	0	0	100.4813	0.0000	0.9234	0.0000;
	2459	28.539	1	1	0	1.11811	32	1	28.539	28.539	0	0	0	0	0	0	0	0	0	0	0	100.4813	0.0000	0.9234	0.0000;
	2478	50	5	5	0	1.10904	55.2	1	50	50	0	0	0	0	0	0	0	0	0	0	0	106.4870	0.0000	0.4077	0.0000;
	2479	50	5	5	0	1.10892	55.2	1	50	50	0	0	0	0	0	0	0	0	0	0	0	106.4870	0.0000	0.4092	0.0000;
	2491	0.4	0	0.1	0	1.11489	0.6	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	105.9963	0.0000	0.0000	1.2292;
	2508	0	0	1	0	1.1185	22	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2508	55	7.5	7.5	0	1.1185	55.5	1	55	55	0	0	0	0	0	0	0	0	0	0	0	105.4432	0.0000	0.3430	0.0000;
	2508	55	7.5	7.5	0	1.1185	55.5	1	55	55	0	0	0	0	0	0	0	0	0	0	0	105.4432	0.0000	0.3430	0.0000;
	2509	50	7.5	7.5	0	1.12179	55.5	1	50	50	0	0	0	0	0	0	0	0	0	0	0	105.0542	0.0000	0.2584	0.0000;
	2509	50	7.5	7.5	0	1.12179	55.5	1	50	50	0	0	0	0	0	0	0	0	0	0	0	105.0542	0.0000	0.2584	0.0000;
	2579	11	10	10	0	1.03332	17.9	1	11	11	0	0	0	0	0	0	0	0	0	0	0	101.6196	0.0000	1.0755	0.0000;
	2580	6.5	6.5	6.5	0	1.03327	16.2	1	6.5	6.5	0	0	0	0	0	0	0	0	0	0	0	101.6227	0.0000	1.0773	0.0000;
	2590	0	0	0	0	1.03102	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	102.0923	0.0000	1.1718	0.0000;
	2617	0	0	0	0	1.0358	2.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	101.0831	0.0000	0.9051	0.0000;
	2637	0.6	0	0	0	1.11521	0.7	1	0.6	0.6	0	0	0	0	0	0	0	0	0	0	0	106.1357	0.0000	0.4125	0.0000;
	2710	25.5	2.5	2.5	0	1.06077	25.6	1	25.5	25.5	0	0	0	0	0	0	0	0	0	0	0	101.6952	0.0000	1.5129	0.0000;
	2710	25.5	2.5	2.5	0	1.06077	25.6	1	25.5	25.5	0	0	0	0	0	0	0	0	0	0	0	101.6952	0.0000	1.5129	0.0000;
	2710	0	0	2	0	1.06077	25.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2710	0	0	2	0	1.06077	25.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2711	0	0	2	0	1.06074	25.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2711	0	0	2	0	1.06074	25.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2729	0	0	22	8	1.11813	54.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2730	0	0	22	8	1.11813	54.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2729	0	0	22	-2.5	1.11813	54.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	219	1.7	6	6	0	1.04401	6.2	1	1.7	1.7	0	0	0	0	0	0	0	0	0	0	0	99.1137	0.0000	0.2069	0.0000;
	221	0.5	0	1	0	1.06307	1.1	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	93.9195	0.0000	0.0000	1.0326;
	222	0.5	0	0.2	0	1.04886	0.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	94.1379	0.0000	0.0000	0.3592;
	223	0	1	1	0	1.05723	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	97.6954	0.0000	0.3471	0.0000;
	299	6	0	5	0	1.08358	7.8	1	6	6	0	0	0	0	0	0	0	0	0	0	0	95.9727	0.0000	0.0000	1.9513;
	449	10	1.20803	3	0	1.05503	10.4	1	10	10	0	0	0	0	0	0	0	0	0	0	0	96.0842	0.0000	0.0000	0.0000;
	569	4	0	4	0	1.06309	5.7	1	4	4	0	0	0	0	0	0	0	0	0	0	0	93.2788	0.0000	0.0000	0.4106;
	1003	1.7	0.21	0.21	0.021	1.07543	1.7	1	1.7	1.7	0	0	0	0	0	0	0	0	0	0	0	92.2946	0.0000	0.2562	0.0000;
	1032	0.002	0.002	0.002	0.002	1.07866	0	1	0.002	0.002	0	0	0	0	0	0	0	0	0	0	0	94.7773	0.0000	0.0567	0.0000;
	1949	1.2	0	0	0	1.07317	1.2	1	1.2	1.2	0	0	0	0	0	0	0	0	0	0	0	94.7326	0.0000	0.0000	0.2983;
	1952	1.7	0	0	0	1.07251	1.7	1	1.7	1.7	0	0	0	0	0	0	0	0	0	0	0	95.0267	0.0000	0.0000	0.0697;
	1962	0.3	0	0	0	1.08502	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	94.3885	0.0000	0.0000	0.0851;
	1967	0.1	0	0	0	1.05972	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	96.4317	0.0000	0.0000	0.0598;
	2012	1.2	0	0	0	1.03086	1.2	1	1.2	1.2	0	0	0	0	0	0	0	0	0	0	0	105.4353	0.0000	0.0000	2.3904;
	2016	2.6	0	0	0	1.051	2.6	1	2.6	2.6	0	0	0	0	0	0	0	0	0	0	0	100.7751	0.0000	0.0000	1.2746;
	2018	3	0	0	0	1.04212	3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	100.0588	0.0000	0.0000	1.0837;
	2032	3	0	0	0	1.03305	3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	99.4857	0.0000	0.0000	1.1001;
	2040	15	0	0	0	1.05578	15	1	15	15	0	0	0	0	0	0	0	0	0	0	0	99.4095	0.0000	0.0000	0.4830;
	2044	5	0	0	0	1.06127	5	1	5	5	0	0	0	0	0	0	0	0	0	0	0	96.3319	0.0000	0.0000	0.1965;
	2051	2.1	0	0	0	1.07001	2.1	1	2.1	2.1	0	0	0	0	0	0	0	0	0	0	0	95.4536	0.0000	0.0000	0.0017;
	2059	3.6	0	0	0	1.04574	3.6	1	3.6	3.6	0	0	0	0	0	0	0	0	0	0	0	96.6076	0.0000	0.0000	0.9084;
	2061	1.5	0	0	0	1.04949	1.5	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	104.5408	0.0000	0.0000	2.3548;
	2063	1.4	0	0	0	1.05712	1.4	1	1.4	1.4	0	0	0	0	0	0	0	0	0	0	0	96.4726	0.0000	0.0000	0.0919;
	2067	0.5	0	0	0	1.07198	0.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	95.8576	0.0000	0.0752	0.0000;
	2072	3	0	0	0	1.04986	3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	101.4712	0.0000	0.0000	1.9105;
	2083	9	0	0	0	1.04244	9	1	9	9	0	0	0	0	0	0	0	0	0	0	0	101.3616	0.0000	0.3640	0.0000;
	2101	4	0	0	0	1.04605	4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	99.8855	0.0000	0.0075	0.0000;
	2123	2.7	0	0	0	1.04855	2.7	1	2.7	2.7	0	0	0	0	0	0	0	0	0	0	0	104.0019	0.0000	0.0000	1.1415;
	2128	3	0	0	0	1.04323	3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	96.6931	0.0000	0.0000	0.9554;
	2136	1.6	0	0	0	1.04786	1.6	1	1.6	1.6	0	0	0	0	0	0	0	0	0	0	0	96.4532	0.0000	0.0000	0.4699;
	2145	1.9	0	0	0	1.0758	1.9	1	1.9	1.9	0	0	0	0	0	0	0	0	0	0	0	94.8511	0.0000	0.0000	0.2329;
	2180	1.5	0	0	0	1.06795	1.5	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	93.2588	0.0000	0.0000	0.6115;
	2181	0.2	0	0	0	1.07336	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	102.3385	0.0000	0.0000	1.7376;
	2206	1.2	0	0	0	1.04968	1.2	1	1.2	1.2	0	0	0	0	0	0	0	0	0	0	0	104.5740	0.0000	0.0000	2.3711;
	2207	0.3	0	0	0	1.04865	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	92.3463	0.0000	0.0000	0.1154;
	2209	4	0	0	0	1.05717	4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	101.6995	0.0000	0.0000	2.1795;
	2212	2.8	0	0	0	1.06636	2.8	1	2.8	2.8	0	0	0	0	0	0	0	0	0	0	0	93.6046	0.0000	0.0000	1.0975;
	2231	1.5	0	0	0	1.06151	1.5	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	101.0533	0.0000	0.0000	2.1937;
	2232	0.3	0	0	0	1.05098	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	104.1634	0.0000	0.0000	2.1558;
	2239	13	0	0	0	0.99231	13	1	13	13	0	0	0	0	0	0	0	0	0	0	0	102.1696	0.0000	0.0000	1.0904;
	2269	4	0	0	0	1.07639	4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	92.9057	0.0000	0.0000	0.3214;
	2277	2.4	0	0	0	1.01011	2.4	1	2.4	2.4	0	0	0	0	0	0	0	0	0	0	0	98.8745	0.0000	0.0000	0.7164;
	2297	1.5	0	0	0	1.07266	1.5	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	102.2243	0.0000	0.0000	1.4873;
	2299	0.3	0	0	0	1.0814	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	95.3236	0.0000	0.0089	0.0000;
	2300	0.3	0	0	0	1.07214	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	100.7794	0.0000	0.0000	1.6975;
	2302	1	0	0	0	1.07181	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	96.6485	0.0000	0.3691	0.0000;
	2304	3	0	0	0	1.06581	3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	95.0842	0.0000	0.0000	0.2380;
	2308	2	0	0	0	1.04692	2	1	2	2	0	0	0	0	0	0	0	0	0	0	0	102.8468	0.0000	0.0000	2.1255;
	2312	3.5	0	0	0	1.02597	3.5	1	3.5	3.5	0	0	0	0	0	0	0	0	0	0	0	101.8977	0.0000	0.0000	0.6938;
	2314	3	0	0	0	1.0241	3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	102.1602	0.0000	0.0000	0.2204;
	2315	1.6	0	0	0	1.06976	1.6	1	1.6	1.6	0	0	0	0	0	0	0	0	0	0	0	94.0130	0.0000	0.0000	0.2635;
	2325	2.4	0	0	0	1.07332	2.4	1	2.4	2.4	0	0	0	0	0	0	0	0	0	0	0	95.2410	0.0000	0.0000	0.0010;
	2332	2.8	0	0	0	1.05511	2.8	1	2.8	2.8	0	0	0	0	0	0	0	0	0	0	0	96.6640	0.0000	0.0203	0.0000;
	2337	0.2	0	0	0	1.02946	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	105.6163	0.0000	0.0000	2.4169;
	2366	9.9	0	0	0	1.08283	9.9	1	9.9	9.9	0	0	0	0	0	0	0	0	0	0	0	95.1504	0.0000	0.0076	0.0000;
	2372	4.2	0	0	0	1.08166	4.2	1	4.2	4.2	0	0	0	0	0	0	0	0	0	0	0	94.3027	0.0000	0.0000	0.3680;
	2376	0.3	0	0	0	1.07318	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	93.6224	0.0000	0.0000	0.3121;
	2386	1	0	0	0	1.04505	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	100.3058	0.0000	0.0000	1.0160;
	2445	0.5	0	0	0	1.04422	0.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	104.3872	0.0000	0.0000	2.1249;
	2446	3	0	0	0	1.04948	3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	99.5384	0.0000	0.0000	0.2290;
	2455	0.8	0	0	0	1.11825	0.8	1	0.8	0.8	0	0	0	0	0	0	0	0	0	0	0	105.5771	0.0000	0.3577	0.0000;
	2461	0.1	0	0.2	0	1.1165	0.2	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	105.2732	0.0000	0.0000	1.3846;
	2462	0	0	0.2	0	1.11651	0.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	105.2741	0.0000	0.0000	1.3847;
	2467	0.3	0.3	0.3	0	1.08649	0.4	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	106.5908	0.0000	0.8633	0.0000;
	2475	0.3	0	0.1	0	1.11163	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	106.5643	0.0000	0.0000	1.3689;
	2480	4.5	0.9	0.9	0	1.06103	4.6	1	4.5	4.5	0	0	0	0	0	0	0	0	0	0	0	104.0469	0.0000	1.6520	0.0000;
	2489	0.2	0	0	0	1.01677	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	112.1354	0.0000	0.1327	0.0000;
	2490	0.3	0	0.1	0	1.11163	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	107.0337	0.0000	0.0000	0.3970;
	2499	26	9	9	0	1.08665	27.5	1	26	26	0	0	0	0	0	0	0	0	0	0	0	107.0157	0.0000	0.8102	0.0000;
	2517	0	1.2	1.2	0	1.02922	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	102.6819	0.0000	1.3076	0.0000;
	2522	2.5	1.3	1.3	0	1.06734	2.8	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	103.8117	0.0000	1.5605	0.0000;
	2534	10	3.5	3.5	0	1.11476	10.6	1	10	10	0	0	0	0	0	0	0	0	0	0	0	101.3766	0.0000	0.8317	0.0000;
	2537	31	25	25	0	1.03967	39.8	1	31	31	0	0	0	0	0	0	0	0	0	0	0	100.5941	0.0000	0.8511	0.0000;
	2554	0.5	0	0.2	0	1.11711	0.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	104.8166	0.0000	0.0000	1.2929;
	2555	0	0	0.5	0	1.11649	0.5	1	0	0	0	0	0	0	0	0	0	0	0	0	0	104.9458	0.0000	0.0000	1.2721;
	2562	56	37	37	0	1.09032	67.1	1	56	56	0	0	0	0	0	0	0	0	0	0	0	106.5849	0.0000	1.9532	0.0000;
	2566	1.5	0.2	0.2	0	1.10697	1.5	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	103.9900	0.0000	1.3102	0.0000;
	2570	0.1	0.1	0.1	0	1.11164	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	107.6442	0.0000	0.0515	0.0000;
	2576	0.3	0.1	0.1	0	1.09301	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	105.9935	0.0000	0.7634	0.0000;
	2582	0.4	0	0.1	0	1.11366	0.4	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	105.9122	0.0000	0.0000	1.4531;
	2583	0	1.1	1.1	0	1.08594	1.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	106.8484	0.0000	1.7192	0.0000;
	2587	0	0.8	0.8	0	1.0451	0.8	1	0	0	0	0	0	0	0	0	0	0	0	0	0	99.7276	0.0000	0.6362	0.0000;
	2597	0.5	0	0.1	0	1.11584	0.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	105.3971	0.0000	0.0000	1.2961;
	2603	0.2	0	0	0	1.10887	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	103.8662	0.0000	0.7929	0.0000;
	2615	0.3	0.1	0.1	0	1.10442	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	104.2882	0.0000	0.8346	0.0000;
	2616	11	6.5	6.5	0	1.10645	12.8	1	11	11	0	0	0	0	0	0	0	0	0	0	0	104.3052	0.0000	0.7982	0.0000;
	2634	0.1	0.1	0.1	0	1.08913	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	105.8096	0.0000	0.9254	0.0000;
	2641	13.3	0	0	0	1.11892	13.3	1	13.3	13.3	0	0	0	0	0	0	0	0	0	0	0	105.5727	0.0000	0.3322	0.0000;
	2652	1.2	0	0	0	1.1151	1.2	1	1.2	1.2	0	0	0	0	0	0	0	0	0	0	0	106.0575	0.0000	0.4008	0.0000;
	2657	0	1.07493	1.9	0	1.05853	1.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	112.4846	0.0000	0.0000	0.0000;
	2662	0.6	0	0	0	1.11845	0.6	1	0.6	0.6	0	0	0	0	0	0	0	0	0	0	0	105.1728	0.0000	0.0000	1.0593;
	2666	0.1	0	0	0	1.08198	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	108.6220	0.0000	0.5178	0.0000;
	2671	0.1	0	0	0	1.11471	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	105.6425	0.0000	0.0000	1.1109;
	2676	3.7	0	0	0	1.08374	3.7	1	3.7	3.7	0	0	0	0	0	0	0	0	0	0	0	108.3619	0.0000	0.5377	0.0000;
	2684	46	0	0	0	1.10943	46	1	46	46	0	0	0	0	0	0	0	0	0	0	0	103.4875	0.0000	1.3321	0.0000;
	2688	15.7	8.6	8.6	0	1.06715	17.9	1	15.7	15.7	0	0	0	0	0	0	0	0	0	0	0	103.8194	0.0000	1.5714	0.0000;
	2693	4.5	0.9	0.9	0	1.0558	4.6	1	4.5	4.5	0	0	0	0	0	0	0	0	0	0	0	104.1579	0.0000	1.6784	0.0000;
	2704	0.1	0.1	0.1	0	1.11419	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	107.4517	0.0000	0.1549	0.0000;
	2706	23	15	15	0	1.06216	27.5	1	23	23	0	0	0	0	0	0	0	0	0	0	0	102.4633	0.0000	1.5124	0.0000;
	2725	2.8	2.9	2.9	0	1.01991	4	1	2.8	2.8	0	0	0	0	0	0	0	0	0	0	0	102.8358	0.0000	0.8513	0.0000;
	1166	1.109	0.217	0.217	0.217	1.07138	1.1	1	1.109	1.109	0	0	0	0	0	0	0	0	0	0	0	94.7975	0.0000	0.0251	0.0000;
	1648	0.431	0.821	0.821	0.821	1.05101	0.9	1	0.431	0.431	0	0	0	0	0	0	0	0	0	0	0	96.4637	0.0000	0.0000	0.5352;
	2326	2.113	-0.46	-0.46	-0.46	1.07744	2.2	1	2.113	2.113	0	0	0	0	0	0	0	0	0	0	0	94.9510	0.0000	0.0000	0.0462;
	2367	1.379	0.225	0.225	0.225	1.08292	1.4	1	1.379	1.379	0	0	0	0	0	0	0	0	0	0	0	95.1247	0.0000	0.0073	0.0000;
	2370	5.8	1.699	1.699	1.699	1.07223	6	1	5.8	5.8	0	0	0	0	0	0	0	0	0	0	0	94.6451	0.0000	0.0000	0.3263;
	2076	0.2	0	0	0	1.05826	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	97.0653	0.0000	0.0000	0.0017;
	2282	10	0	0	0	1.05159	10	1	10	10	0	0	0	0	0	0	0	0	0	0	0	103.7583	0.0000	0.0000	2.0668;
	2285	5	0	0	0	1.07824	5	1	5	5	0	0	0	0	0	0	0	0	0	0	0	93.9412	0.0000	0.0000	0.4229;
	2493	0	0	1	0	1.03026	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	116.7191	0.0000	0.0000	0.2767;
	2496	1	0	0.3	0	1.11765	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	105.0763	0.0000	0.0000	1.2121;
	382	0.084	-9.392	-9.392	-9.392	1.08182	9.4	1	0.084	0.084	0	0	0	0	0	0	0	0	0	0	0	96.2545	0.0000	0.0000	0.0000;
	383	6.012	10.538	10.538	10.538	1.10054	12.1	1	6.012	6.012	0	0	0	0	0	0	0	0	0	0	0	97.1015	0.0000	0.0000	0.3317;
	1012	2.277	-0.8	-0.8	-0.8	1.07258	2.4	1	2.277	2.277	0	0	0	0	0	0	0	0	0	0	0	94.9353	0.0000	0.2023	0.0000;
	1970	5.588	3.717	3.717	3.717	1.07328	6.7	1	5.588	5.588	0	0	0	0	0	0	0	0	0	0	0	92.7919	0.0000	0.0000	0.5673;
	2019	5.619	-4.571	-4.571	-4.571	1.08182	7.2	1	5.619	5.619	0	0	0	0	0	0	0	0	0	0	0	99.9233	0.0000	0.0000	1.4818;
	2095	1.645	4.62	4.62	4.62	1.08091	4.9	1	1.645	1.645	0	0	0	0	0	0	0	0	0	0	0	95.7692	0.0000	0.0000	0.0000;
	2096	1.707	-1.725	-1.725	-1.725	1.08183	2.4	1	1.707	1.707	0	0	0	0	0	0	0	0	0	0	0	96.0986	0.0000	0.0000	0.0000;
	2257	1.291	0.159	0.159	0.159	1.07394	1.3	1	1.291	1.291	0	0	0	0	0	0	0	0	0	0	0	101.7144	0.0000	0.0000	1.4626;
	2438	19.344	0.761	0.761	0.761	1.08182	19.4	1	19.344	19.344	0	0	0	0	0	0	0	0	0	0	0	98.6243	0.0000	0.0000	0.8986;
	2732	0	0	0	0	1.01	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	92.6305	0.0000	0.0000	0.0286;
	2733	0	0	0	0	1.0175	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	92.9799	0.0000	0.0862	0.0000;
	2734	68.958	-9.21288	0	-34.853	1.077	69	1	68.958	68.958	0	0	0	0	0	0	0	0	0	0	0	93.9590	0.0000	0.0000	0.0000;
	2735	69.456	-126.98	0	-126.98	1.005	69.5	1	69.456	69.456	0	0	0	0	0	0	0	0	0	0	0	94.1240	0.0000	0.0000	0.0812;
	2736	125	-21.4501	120	-37.01	1.09091	173.3	1	125	125	0	0	0	0	0	0	0	0	0	0	0	91.9853	0.0000	0.0000	0.0000;
	2737	7.669	-7.568	0	-7.568	1.08864	7.7	1	7.669	7.669	0	0	0	0	0	0	0	0	0	0	0	101.4513	0.0000	0.0000	1.5643;
	2738	0	0	0	0	1.005	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	96.0836	0.0000	0.0000	0.4298;
	2739	200	0	0	0	1.04437	200	1	200	200	0	0	0	0	0	0	0	0	0	0	0	104.7603	0.0000	0.0000	0.7604;
	2740	80	-6.80645	0	-9.06	1.1	80	1	80	80	0	0	0	0	0	0	0	0	0	0	0	91.4408	0.0000	0.0000	0.0000;
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax	Pf	Qf	Pt	Qt	mu_Sf	mu_St	mu_angmin	mu_angmax
mpc.branch = [
	7	8	0.00064	0.0305	0	400	400	400	1.0435	-0.6	1	-360	360	-130.7862	19.5085	130.8909	-14.5189	0.0000	0.0000	0.0000	0.0000;
	26	28	0.00036	0.02519	0	500	500	500	1.0627	0	1	-360	360	-91.5187	-16.1344	91.5472	18.1304	0.0000	0.0000	0.0000	0.0000;
	27	29	0.00036	0.02519	0	500	500	500	1.0623	0	1	-360	360	161.3265	-13.9254	-161.2400	19.9751	0.0000	0.0000	0.0000	0.0000;
	40	42	0.00034	0.02097	0	500	500	500	1.1011	0	1	-360	360	3.9348	-88.3422	-3.9086	89.9559	0.0000	0.0000	0.0000	0.0000;
	43	46	0.00034	0.02097	0	500	500	500	1.0733	0	1	-360	360	-7.1846	-44.4992	7.1912	44.9060	0.0000	0.0000	0.0000	0.0000;
	55	57	0.00081	0.03	0	400	400	400	1.0547	0	1	-360	360	22.3163	-11.7790	-22.3115	11.9568	0.0000	0.0000	0.0000	0.0000;
	90	92	0.00075	0.02444	-0.00832	330	330	330	1.0508	0	1	-360	360	-171.5483	0.1816	171.7494	7.2889	0.0000	0.0000	0.0000	0.0000;
	91	93	0.00075	0.02469	-0.008	330	330	330	1.0499	0	1	-360	360	-169.4920	3.9745	169.6881	3.3624	0.0000	0.0000	0.0000	0.0000;
	125	128	0.0005	0.02875	-0.016	400	400	400	1.0677	0	1	-360	360	-106.1437	2.3444	106.1958	2.3832	0.0000	0.0000	0.0000	0.0000;
	149	150	0.00064	0.0305	0	400	400	400	1.0568	0	1	-360	360	101.1188	17.7763	-101.0548	-14.7247	0.0000	0.0000	0.0000	0.0000;
	155	158	0.000232	0.023	0	500	500	500	1.049	0	1	-360	360	-79.2580	20.2632	79.2724	-18.8351	0.0000	0.0000	0.0000	0.0000;
	156	159	0.000232	0.023	0	500	500	500	1.0479	0	1	-360	360	-83.9890	24.8754	84.0054	-23.2412	0.0000	0.0000	0.0000	0.0000;
	170	172	0.00035	0.02375	0	500	500	500	1.195	0	1	-360	360	68.9814	-137.6853	-68.8852	144.2135	0.0000	0.0000	0.0000	0.0000;
	183	184	0.00059	0.03093	0	400	400	400	1.0847	0	1	-360	360	-22.5991	-13.4751	22.6030	13.6796	0.0000	0.0000	0.0000	0.0000;
	190	192	0.0004	0.03	0	500	500	500	1.0485	0	1	-360	360	-27.2002	19.4303	27.2046	-19.1028	0.0000	0.0000	0.0000	0.0000;
	2735	158	0.00031	0.00338	0.0992	1386	1386	1386	0	0	1	-360	360	35.2997	-63.9175	-35.2861	53.4775	0.0000	0.0000	0.0000	0.0000;
	2735	159	0.00031	0.00338	0.0992	1386	1386	1386	0	0	1	-360	360	34.1563	-63.0625	-34.1432	52.6170	0.0000	0.0000	0.0000	0.0000;
	2736	68	0.014341	0.083531	0.126034	415	415	415	0	0	1	-360	360	125.0000	-21.4501	-123.0761	17.8102	0.0000	0.0000	0.0000	0.0000;
	2734	76	0.01219	0.070659	0.117418	412	412	412	0	0	1	-360	360	135.4377	-13.4321	-133.6032	9.8196	0.0000	0.0000	0.0000	0.0000;
	2734	105	0.011781	0.07087	0.116838	412	412	412	0	0	1	-360	360	-66.4797	4.2193	66.9183	-15.8608	0.0000	0.0000	0.0000	0.0000;
	2739	200	1e-05	9e-05	0	924	924	924	0	0	1	-360	360	200.0000	0.0000	-199.9962	0.0342	0.0000	0.0000	0.0000	0.0000;
	128	2732	0.0015	0.01469	0.40384	1386	1386	1386	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	127	2733	0.001419	0.014675	0.4896	1386	1386	1386	0	0	1	-360	360	332.3747	56.8229	-330.8350	-93.0950	0.0000	0.0000	0.0000	0.0000;
	2737	148	0.001651	0.015909	0.046948	373	373	373	0	0	1	-360	360	2.9029	-3.8299	-2.9027	-1.6930	0.0000	0.0000	0.0000	0.0000;
	2737	149	0.001651	0.015909	0.046948	373	373	373	0	0	1	-360	360	4.7661	-3.7381	-4.7658	-1.7827	0.0000	0.0000	0.0000	0.0000;
	2738	48	0.00188	0.02287	0.6432	831	831	831	0	0	1	-360	360	-144.7495	-105.1483	145.2334	44.2856	0.0000	0.0000	0.0000	0.0000;
	2738	49	0.00188	0.02287	0.6432	831	831	831	0	0	1	-360	360	-144.2975	-105.0917	144.7788	44.1994	0.0000	0.0000	0.0000	0.0000;
	82	2732	0.003519	0.039313	1.0336	1621	1621	1621	0	0	1	-360	360	228.8957	-14.8715	-227.1500	-76.2490	0.0000	0.0000	0.0000	0.0000;
	43	23	0.01345	0.081141	0.141134	339	339	339	0	0	1	-360	360	92.2926	8.2273	-91.3117	-19.0057	0.0000	0.0000	0.0000	0.0000;
	26	90	0.009091	0.062401	0.111417	457	457	457	0	0	1	-360	360	110.6951	-4.2660	-109.7896	-3.1242	0.0000	0.0000	0.0000	0.0000;
	27	91	0.00868	0.06405	0.096994	457	457	457	0	0	1	-360	360	218.1000	-6.8325	-214.7490	19.7099	0.0000	0.0000	0.0000	0.0000;
	146	30	0.016961	0.123659	0.196988	373	373	373	0	0	1	-360	360	21.4901	3.5136	-21.3921	-26.2411	0.0000	0.0000	0.0000	0.0000;
	135	34	0.00512	0.02618	0.029621	335	335	335	0	0	1	-360	360	-132.9404	52.9750	133.8050	-52.1590	0.0000	0.0000	0.0000	0.0000;
	134	20	0.01068	0.061961	0.094961	415	415	415	0	0	1	-360	360	-177.2180	45.5648	180.1877	-39.8918	0.0000	0.0000	0.0000	0.0000;
	165	21	0.014651	0.105891	0.170852	373	373	373	0	0	1	-360	360	29.4420	-3.6395	-29.3318	-16.0800	0.0000	0.0000	0.0000	0.0000;
	41	109	0.01488	0.08161	0.114805	347	347	347	0	0	1	-360	360	-33.4310	18.8410	33.6471	-31.6187	0.0000	0.0000	0.0000	0.0000;
	40	91	0.011159	0.07231	0.103673	362	362	362	0	0	1	-360	360	-128.8438	33.2233	130.4895	-35.2264	0.0000	0.0000	0.0000	0.0000;
	179	83	0.008616	0.077645	0.122239	373	373	373	0	0	1	-360	360	-119.0080	-8.0704	120.0319	2.5516	0.0000	0.0000	0.0000	0.0000;
	203	166	0.01176	0.068289	0.102802	362	362	362	0	0	1	-360	360	-209.5644	-32.0546	214.3043	47.6610	0.0000	0.0000	0.0000	0.0000;
	194	166	0.016818	0.089091	0.129935	400	400	400	0	0	1	-360	360	-164.3078	-3.6528	168.2802	9.3951	0.0000	0.0000	0.0000	0.0000;
	193	165	0.013843	0.087025	0.134842	427	427	427	0	0	1	-360	360	-169.5575	-8.7106	173.0377	14.7085	0.0000	0.0000	0.0000	0.0000;
	207	168	0.01676	0.097169	0.148685	274	274	274	0	0	1	-360	360	-84.9454	0.4080	85.9559	-12.6812	0.0000	0.0000	0.0000	0.0000;
	43	12	0.01269	0.074979	0.130196	377	377	377	0	0	1	-360	360	101.2786	10.2537	-100.1652	-19.0721	0.0000	0.0000	0.0000	0.0000;
	198	18	0.014091	0.10413	0.15972	373	373	373	0	0	1	-360	360	-156.6517	-9.4214	159.6757	12.9579	0.0000	0.0000	0.0000	0.0000;
	100	55	0.003719	0.0438	0.100962	457	457	457	0	0	1	-360	360	-52.9870	9.7533	53.0814	-20.7587	0.0000	0.0000	0.0000	0.0000;
	163	82	0.00194	0.02056	0.51584	1316	1316	1316	0	0	1	-360	360	-471.3721	57.8972	475.4255	-71.4202	0.0000	0.0000	0.0000	0.0000;
	45	9	0.0015	0.01506	0.4032	1386	1386	1386	0	0	1	-360	360	211.2389	-19.1083	-210.6111	-17.4564	0.0000	0.0000	0.0000	0.0000;
	185	151	0.00294	0.03463	0.9216	693	693	693	0	0	1	-360	360	-287.1034	9.4706	289.4927	-78.0093	0.0000	0.0000	0.0000	0.0000;
	121	57	0.00169	0.01994	0.50624	831	831	831	0	0	1	-360	360	4.0224	-11.8035	-4.0183	-43.0574	0.0000	0.0000	0.0000	0.0000;
	29	93	0.00137	0.01625	0.41184	1386	1386	1386	0	0	1	-360	360	264.8891	-46.5822	-264.0074	11.7266	0.0000	0.0000	0.0000	0.0000;
	28	123	0.00231	0.02769	0.70144	1386	1386	1386	0	0	1	-360	360	339.7898	-33.5056	-337.3628	-14.1397	0.0000	0.0000	0.0000	0.0000;
	25	192	0.00207	0.02474	0.664	831	831	831	0	0	1	-360	360	634.5786	20.9920	-626.5189	7.1223	0.0000	0.0000	0.0000	0.0000;
	120	64	0.0015	0.01788	0.4512	831	831	831	0	0	1	-360	360	133.5512	-13.0992	-133.3034	-32.8571	0.0000	0.0000	0.0000	0.0000;
	122	65	0.00469	0.05544	1.4048	831	831	831	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	82	31	0.00331	0.03425	0.85888	1150	1150	1150	0	0	1	-360	360	-60.0926	-54.5537	60.2040	-38.3937	0.0000	0.0000	0.0000	0.0000;
	92	28	0.00219	0.02369	0.59584	1316	1316	1316	0	0	1	-360	360	-180.0255	-7.9135	180.6822	-50.5420	0.0000	0.0000	0.0000	0.0000;
	10	4	0.01674	0.09711	0.144232	461	461	461	0	0	1	-360	360	-167.3435	8.7064	171.4308	-2.0450	0.0000	0.0000	0.0000	0.0000;
	30	11	0.0057	0.0407	0.06021	373	373	373	0	0	1	-360	360	-55.2915	15.9508	55.4592	-21.7567	0.0000	0.0000	0.0000	0.0000;
	33	4	0.004419	0.032229	0.049852	392	392	392	0	0	1	-360	360	185.4744	-15.8175	-184.2125	18.9979	0.0000	0.0000	0.0000	0.0000;
	17	7	0.014591	0.11219	0.165528	427	427	427	0	0	1	-360	360	-35.9629	16.8957	36.2059	-34.6873	0.0000	0.0000	0.0000	0.0000;
	21	10	0.01211	0.087419	0.140166	373	373	373	0	0	1	-360	360	-36.7637	15.2051	36.9577	-30.2649	0.0000	0.0000	0.0000	0.0000;
	26	5	0.009773	0.050516	0.088959	377	377	377	0	0	1	-360	360	135.9321	-2.7241	-134.4644	-0.5259	0.0000	0.0000	0.0000	0.0000;
	17	3	0.01068	0.07895	0.122597	274	274	274	0	0	1	-360	360	109.2998	20.5830	-108.1777	-26.7683	0.0000	0.0000	0.0000	0.0000;
	26	19	0.0057	0.039521	0.075533	480	480	480	0	0	1	-360	360	131.5232	6.1613	-130.7166	-9.7862	0.0000	0.0000	0.0000	0.0000;
	27	20	0.0057	0.039521	0.075533	480	480	480	0	0	1	-360	360	309.4384	-5.0762	-305.0083	26.5683	0.0000	0.0000	0.0000	0.0000;
	11	6	0.00525	0.03988	0.061952	373	373	373	0	0	1	-360	360	-19.8790	-7.3080	19.8975	0.2547	0.0000	0.0000	0.0000	0.0000;
	32	11	0.00093	0.00651	0.011132	373	373	373	0	0	1	-360	360	-47.7604	-15.9750	47.7806	14.8285	0.0000	0.0000	0.0000	0.0000;
	23	12	0.00205	0.01326	0.022429	415	415	415	0	0	1	-360	360	7.8477	0.2168	-7.8466	-2.8091	0.0000	0.0000	0.0000	0.0000;
	34	5	0.007831	0.043	0.04962	335	335	335	0	0	1	-360	360	-134.2697	30.5649	135.5091	-29.7529	0.0000	0.0000	0.0000	0.0000;
	19	4	0.00293	0.01599	0.024781	362	362	362	0	0	1	-360	360	104.4125	-6.9046	-104.1477	5.3574	0.0000	0.0000	0.0000	0.0000;
	26	1	0.00155	0.01169	0.018198	747	747	747	0	0	1	-360	360	44.8033	79.3287	-44.6966	-80.7450	0.0000	0.0000	0.0000	0.0000;
	27	2	0.00155	0.01169	0.018198	747	747	747	0	0	1	-360	360	49.3175	49.5813	-49.2545	-51.3368	0.0000	0.0000	0.0000	0.0000;
	27	33	0.003841	0.028531	0.045883	392	392	392	0	0	1	-360	360	276.8127	6.7403	-274.4211	5.4207	0.0000	0.0000	0.0000	0.0000;
	24	33	2e-06	2.1e-05	0	392	392	392	0	0	1	-360	360	-88.9466	-10.3954	88.9467	10.3967	0.0000	0.0000	0.0000	0.0000;
	25	9	0.00298	0.03417	0.93504	831	831	831	0	0	1	-360	360	-145.8140	-58.7632	146.4249	-32.5209	0.0000	0.0000	0.0000	0.0000;
	28	25	0.00358	0.04262	1.0944	1386	1386	1386	0	0	1	-360	360	582.0373	25.3995	-570.7654	-8.3829	0.0000	0.0000	0.0000	0.0000;
	14	29	0.00336	0.03977	1.02163	1316	1316	1316	0	0	1	-360	360	-410.9030	-48.2572	416.3057	2.4121	0.0000	0.0000	0.0000	0.0000;
	8	15	0.00299	0.03675	0.9184	1358	1358	1358	0	0	1	-360	360	62.2043	-79.5192	-62.0684	-17.0724	0.0000	0.0000	0.0000	0.0000;
	8	14	0.00112	0.01329	0.341248	1358	1358	1358	0	0	1	-360	360	-241.6128	43.5618	242.2696	-71.7752	0.0000	0.0000	0.0000	0.0000;
	31	29	0.00063	0.00749	0.392256	1358	1358	1358	0	0	1	-360	360	-254.8746	10.6866	255.2524	-49.3346	0.0000	0.0000	0.0000	0.0000;
	63	59	0.010479	0.060969	0.092047	316	316	316	0	0	1	-360	360	9.2100	4.8694	-9.1932	-15.7853	0.0000	0.0000	0.0000	0.0000;
	61	56	0.00882	0.065641	0.100662	274	274	274	0	0	1	-360	360	-20.8710	14.6025	20.9337	-26.2863	0.0000	0.0000	0.0000	0.0000;
	67	35	0.011219	0.065581	0.098349	274	274	274	0	0	1	-360	360	-1.7278	-10.5456	1.7301	-1.1576	0.0000	0.0000	0.0000	0.0000;
	51	35	0.01163	0.07031	0.105802	377	377	377	0	0	1	-360	360	-6.3288	-16.8885	6.3440	4.4279	0.0000	0.0000	0.0000	0.0000;
	59	43	0.00545	0.040211	0.066986	446	446	446	0	0	1	-360	360	-55.5158	-17.3221	55.6652	10.4004	0.0000	0.0000	0.0000	0.0000;
	60	44	0.00545	0.040211	0.066986	446	446	446	0	0	1	-360	360	-56.0510	-16.9280	56.2027	10.0227	0.0000	0.0000	0.0000	0.0000;
	60	35	0.00837	0.04868	0.073481	419	419	419	0	0	1	-360	360	13.0265	-11.9692	-13.0105	3.3032	0.0000	0.0000	0.0000	0.0000;
	68	52	0.003159	0.02076	0.03146	415	415	415	0	0	1	-360	360	66.0756	-15.3216	-65.9535	12.4201	0.0000	0.0000	0.0000	0.0000;
	52	39	0.006979	0.051961	0.079666	373	373	373	0	0	1	-360	360	34.8072	-8.8532	-34.7344	0.0104	0.0000	0.0000	0.0000	0.0000;
	37	56	0.00374	0.027831	0.042689	274	274	274	0	0	1	-360	360	-65.6291	-4.2180	65.7647	0.1367	0.0000	0.0000	0.0000	0.0000;
	38	36	0.00769	0.057271	0.087894	373	373	373	0	0	1	-360	360	36.8014	7.6028	-36.7032	-17.2362	0.0000	0.0000	0.0000	0.0000;
	55	38	0.00556	0.04145	0.063598	427	427	427	0	0	1	-360	360	44.3018	-1.8668	-44.2103	-5.0344	0.0000	0.0000	0.0000	0.0000;
	67	37	0.004521	0.03368	0.051691	392	392	392	0	0	1	-360	360	-35.6137	0.1493	35.6624	-5.9312	0.0000	0.0000	0.0000	0.0000;
	67	66	0.00151	0.008781	0.013165	377	377	377	0	0	1	-360	360	37.3415	10.3963	-37.3222	-11.8461	0.0000	0.0000	0.0000	0.0000;
	62	43	0.00574	0.042831	0.065727	446	446	446	0	0	1	-360	360	-39.6658	-1.3958	39.7411	-5.9634	0.0000	0.0000	0.0000	0.0000;
	63	44	0.00707	0.045409	0.069309	347	347	347	0	0	1	-360	360	-37.9955	-0.7859	38.0809	-7.0176	0.0000	0.0000	0.0000	0.0000;
	62	40	0.01213	0.062151	0.093712	347	347	347	0	0	1	-360	360	-27.1721	-22.7653	27.2760	11.8838	0.0000	0.0000	0.0000	0.0000;
	61	41	0.002479	0.017979	0.027588	373	373	373	0	0	1	-360	360	-69.1257	-28.6567	69.2377	26.0888	0.0000	0.0000	0.0000	0.0000;
	47	40	0.002401	0.01494	0.022525	377	377	377	0	0	1	-360	360	-61.7512	-0.6084	61.8257	-1.7003	0.0000	0.0000	0.0000	0.0000;
	50	46	0.00167	0.0189	0.54176	1358	1358	1358	0	0	1	-360	360	-48.8272	-46.7763	48.8700	-10.2688	0.0000	0.0000	0.0000	0.0000;
	58	54	0.00109	0.01277	0.34176	1358	1358	1358	0	0	1	-360	360	56.0421	2.1059	-56.0062	-38.5337	0.0000	0.0000	0.0000	0.0000;
	42	58	0.002259	0.026439	0.70784	1358	1358	1358	0	0	1	-360	360	3.9086	-89.9559	-3.8488	15.0949	0.0000	0.0000	0.0000	0.0000;
	64	58	0.00094	0.01097	0.29376	1552	1552	1552	0	0	1	-360	360	-209.7505	-1.1477	210.1353	-26.1123	0.0000	0.0000	0.0000	0.0000;
	48	65	0.00113	0.01406	0.37488	831	831	831	0	0	1	-360	360	-313.2957	-67.5605	314.3687	40.8390	0.0000	0.0000	0.0000	0.0000;
	53	45	0.00176	0.02144	0.57344	1358	1358	1358	0	0	1	-360	360	-62.6245	-4.9449	62.6996	-55.5314	0.0000	0.0000	0.0000	0.0000;
	96	125	0.004876	0.033616	0.059609	446	446	446	0	0	1	-360	360	-48.1843	-10.1963	48.2786	3.5297	0.0000	0.0000	0.0000	0.0000;
	75	106	0.01093	0.059194	0.08439	290	290	290	0	0	1	-360	360	-4.9098	5.6138	4.9223	-15.8036	0.0000	0.0000	0.0000	0.0000;
	106	94	0.001942	0.013926	0.022845	446	446	446	0	0	1	-360	360	19.4845	-19.5852	-19.4730	16.8986	0.0000	0.0000	0.0000	0.0000;
	79	85	0.004318	0.029752	0.05264	373	373	373	0	0	1	-360	360	-95.2797	-5.8053	95.6052	1.6753	0.0000	0.0000	0.0000	0.0000;
	131	130	0.000661	0.004959	0.007579	419	419	419	0	0	1	-360	360	79.2436	17.2802	-79.2075	-17.9246	0.0000	0.0000	0.0000	0.0000;
	107	131	0.005372	0.040393	0.060055	419	419	419	0	0	1	-360	360	-68.7681	7.4136	68.9836	-13.0541	0.0000	0.0000	0.0000	0.0000;
	91	131	0.000826	0.005248	0.008683	305	305	305	0	0	1	-360	360	148.3776	4.1301	-148.2272	-4.2261	0.0000	0.0000	0.0000	0.0000;
	100	119	0.015888	0.087603	0.116818	347	347	347	0	0	1	-360	360	-28.5502	-4.3522	28.6586	-9.1539	0.0000	0.0000	0.0000	0.0000;
	81	113	0.002169	0.014587	0.025749	316	316	316	0	0	1	-360	360	33.3135	-4.0787	-33.2932	1.1387	0.0000	0.0000	0.0000	0.0000;
	116	101	0.017727	0.116777	0.163611	290	290	290	0	0	1	-360	360	33.0940	-16.0605	-32.9265	-2.5155	0.0000	0.0000	0.0000	0.0000;
	126	74	0.00593	0.04093	0.072145	446	446	446	0	0	1	-360	360	52.8347	1.3381	-52.6987	-9.2494	0.0000	0.0000	0.0000	0.0000;
	108	90	0.003905	0.028471	0.044983	427	427	427	0	0	1	-360	360	-226.5703	15.3509	228.2507	-8.5238	0.0000	0.0000	0.0000	0.0000;
	118	79	0.008161	0.042417	0.061197	385	385	385	0	0	1	-360	360	-20.6498	5.6509	20.6845	-12.8608	0.0000	0.0000	0.0000	0.0000;
	119	78	0.008161	0.042417	0.061197	385	385	385	0	0	1	-360	360	-47.7570	14.8721	47.9342	-21.3320	0.0000	0.0000	0.0000	0.0000;
	79	76	0.005186	0.038388	0.058748	492	492	492	0	0	1	-360	360	263.2402	-27.4118	-260.2342	42.5825	0.0000	0.0000	0.0000	0.0000;
	78	73	0.002128	0.014029	0.022603	335	335	335	0	0	1	-360	360	155.8728	-9.4785	-155.4415	9.6084	0.0000	0.0000	0.0000	0.0000;
	114	78	0.004628	0.027748	0.046115	362	362	362	0	0	1	-360	360	-46.6883	-8.7799	46.7742	3.7686	0.0000	0.0000	0.0000	0.0000;
	103	72	0.011219	0.070744	0.115705	290	290	290	0	0	1	-360	360	-102.4757	15.9969	103.5042	-23.4041	0.0000	0.0000	0.0000	0.0000;
	110	117	0.006012	0.041467	0.073636	427	427	427	0	0	1	-360	360	-54.5690	-0.7936	54.7192	-6.9962	0.0000	0.0000	0.0000	0.0000;
	91	69	0.002066	0.012789	0.020551	316	316	316	0	0	1	-360	360	61.8492	7.9232	-61.7825	-9.9952	0.0000	0.0000	0.0000	0.0000;
	86	90	0.001364	0.009731	0.016243	457	457	457	0	0	1	-360	360	-96.5049	-12.1544	96.6115	10.9518	0.0000	0.0000	0.0000	0.0000;
	129	87	0.000579	0.004112	0.007008	446	446	446	0	0	1	-360	360	-52.3432	-2.3405	52.3564	1.5887	0.0000	0.0000	0.0000	0.0000;
	132	76	0.000847	0.00624	0.009544	457	457	457	0	0	1	-360	360	-271.9990	62.0010	272.5453	-59.1289	0.0000	0.0000	0.0000	0.0000;
	133	77	0.000847	0.00626	0.009477	457	457	457	0	0	1	-360	360	-266.5000	24.8000	267.0045	-22.2130	0.0000	0.0000	0.0000	0.0000;
	102	77	0.001591	0.011116	0.019128	492	492	492	0	0	1	-360	360	146.0071	-29.1756	-145.7149	28.9146	0.0000	0.0000	0.0000	0.0000;
	125	104	0.003141	0.021591	0.038391	446	446	446	0	0	1	-360	360	100.1925	5.0498	-99.9353	-7.9937	0.0000	0.0000	0.0000	0.0000;
	126	111	0.004545	0.03157	0.055312	373	373	373	0	0	1	-360	360	131.4510	36.0470	-130.7560	-37.9368	0.0000	0.0000	0.0000	0.0000;
	104	84	0.001446	0.009917	0.017598	373	373	373	0	0	1	-360	360	137.6563	15.3724	-137.4290	-15.9598	0.0000	0.0000	0.0000	0.0000;
	105	95	0.003822	0.026674	0.046154	373	373	373	0	0	1	-360	360	-1.6875	14.1204	1.6965	-19.6813	0.0000	0.0000	0.0000	0.0000;
	112	80	0.007769	0.041281	0.063907	316	316	316	0	0	1	-360	360	43.5239	-9.6780	-43.3987	2.7008	0.0000	0.0000	0.0000	0.0000;
	89	78	0.004463	0.030413	0.048671	290	290	290	0	0	1	-360	360	54.0214	-20.1107	-53.9015	15.0907	0.0000	0.0000	0.0000	0.0000;
	117	108	0.005888	0.035062	0.052349	290	290	290	0	0	1	-360	360	-30.6174	2.3538	30.6648	-8.3561	0.0000	0.0000	0.0000	0.0000;
	109	99	0.003161	0.023409	0.036165	373	373	373	0	0	1	-360	360	40.3024	-10.3080	-40.2579	6.2935	0.0000	0.0000	0.0000	0.0000;
	116	79	0.001839	0.012603	0.022399	373	373	373	0	0	1	-360	360	34.5420	-24.6586	-34.5154	22.1462	0.0000	0.0000	0.0000	0.0000;
	107	88	0.001715	0.009607	0.014239	335	335	335	0	0	1	-360	360	171.2218	37.8583	-170.7848	-37.1232	0.0000	0.0000	0.0000	0.0000;
	98	79	0.003409	0.024421	0.039969	290	290	290	0	0	1	-360	360	23.1466	-12.6134	-23.1284	7.9327	0.0000	0.0000	0.0000	0.0000;
	117	78	0.001839	0.012603	0.02239	373	373	373	0	0	1	-360	360	-56.2729	0.6195	56.3214	-2.9766	0.0000	0.0000	0.0000	0.0000;
	83	97	0.005702	0.041488	0.066172	446	446	446	0	0	1	-360	360	9.0381	-7.6332	-9.0337	-0.4196	0.0000	0.0000	0.0000	0.0000;
	124	118	0.004587	0.024628	0.036165	347	347	347	0	0	1	-360	360	-40.2017	-19.8258	40.2755	15.8697	0.0000	0.0000	0.0000	0.0000;
	124	110	0.002149	0.013327	0.022109	290	290	290	0	0	1	-360	360	-4.1329	2.0470	4.1334	-4.6903	0.0000	0.0000	0.0000	0.0000;
	100	71	0.000785	0.004876	0.00726	316	316	316	0	0	1	-360	360	11.3319	1.5607	-11.3310	-2.4300	0.0000	0.0000	0.0000	0.0000;
	101	70	0.000785	0.004876	0.007241	316	316	316	0	0	1	-360	360	6.8003	-0.8705	-6.8000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	93	127	0.002413	0.027544	0.767968	831	831	831	0	0	1	-360	360	102.5953	-14.4645	-102.3478	-66.5446	0.0000	0.0000	0.0000	0.0000;
	82	127	0.002462	0.028525	0.7616	1621	1621	1621	0	0	1	-360	360	109.5970	-33.8369	-109.3245	-45.7423	0.0000	0.0000	0.0000	0.0000;
	122	115	0.000913	0.0104	0.289888	1358	1358	1358	0	0	1	-360	360	-25.2345	19.5784	25.2504	-50.8594	0.0000	0.0000	0.0000	0.0000;
	123	121	0.003119	0.035631	0.991072	831	831	831	0	0	1	-360	360	224.6121	-63.9412	-223.1641	-27.3769	0.0000	0.0000	0.0000	0.0000;
	115	128	0.000919	0.010512	0.292928	1358	1358	1358	0	0	1	-360	360	-189.7889	2.3104	190.0976	-30.4694	0.0000	0.0000	0.0000	0.0000;
	174	156	0.01545	0.073349	0.126614	461	461	461	0	0	1	-360	360	-185.5633	15.1897	190.2809	-7.5445	0.0000	0.0000	0.0000	0.0000;
	175	155	0.01545	0.073349	0.126614	461	461	461	0	0	1	-360	360	-186.9938	15.5098	191.7851	-7.5160	0.0000	0.0000	0.0000	0.0000;
	177	155	0.01457	0.07955	0.14007	362	362	362	0	0	1	-360	360	-42.4564	-4.0937	42.6812	-11.2447	0.0000	0.0000	0.0000	0.0000;
	178	156	0.01457	0.07955	0.14007	362	362	362	0	0	1	-360	360	-40.9050	-4.2118	41.1137	-11.2133	0.0000	0.0000	0.0000	0.0000;
	177	144	0.006031	0.04401	0.069793	373	373	373	0	0	1	-360	360	-36.9079	-9.9019	36.9792	2.1578	0.0000	0.0000	0.0000	0.0000;
	166	140	0.011031	0.08057	0.124127	446	446	446	0	0	1	-360	360	140.0187	-25.0856	-138.2055	23.2388	0.0000	0.0000	0.0000	0.0000;
	137	155	0.005831	0.04231	0.070664	427	427	427	0	0	1	-360	360	-83.9009	-3.0196	84.2499	-2.7939	0.0000	0.0000	0.0000	0.0000;
	171	174	0.01849	0.095599	0.159139	305	305	305	0	0	1	-360	360	-45.5357	46.9790	46.3309	-61.7743	0.0000	0.0000	0.0000	0.0000;
	152	175	0.010581	0.053	0.088475	415	415	415	0	0	1	-360	360	-54.4140	47.2384	54.9235	-54.9989	0.0000	0.0000	0.0000	0.0000;
	154	156	0.012521	0.091359	0.145394	457	457	457	0	0	1	-360	360	-166.6531	17.6781	169.6953	-12.6152	0.0000	0.0000	0.0000	0.0000;
	136	137	0.00506	0.036539	0.063598	305	305	305	0	0	1	-360	360	-28.8032	-8.4306	28.8401	1.2371	0.0000	0.0000	0.0000	0.0000;
	148	143	0.01043	0.077891	0.122065	427	427	427	0	0	1	-360	360	-13.9749	-8.0594	13.9923	-6.2020	0.0000	0.0000	0.0000	0.0000;
	153	181	0.007711	0.056961	0.088378	373	373	373	0	0	1	-360	360	7.2276	21.1872	-7.1784	-31.0381	0.0000	0.0000	0.0000	0.0000;
	171	147	0.018599	0.09638	0.140941	290	290	290	0	0	1	-360	360	-138.1689	36.6974	141.3621	-37.3745	0.0000	0.0000	0.0000	0.0000;
	176	170	0.00244	0.01318	0.021296	377	377	377	0	0	1	-360	360	-39.4057	-8.6489	39.4377	6.2016	0.0000	0.0000	0.0000	0.0000;
	170	140	0.00355	0.02593	0.041237	446	446	446	0	0	1	-360	360	-76.7434	32.3879	76.9482	-35.9472	0.0000	0.0000	0.0000	0.0000;
	171	168	0.01312	0.076219	0.116644	362	362	362	0	0	1	-360	360	126.1622	-20.9065	-124.4469	16.5276	0.0000	0.0000	0.0000	0.0000;
	170	152	0.009341	0.05225	0.087701	305	305	305	0	0	1	-360	360	-28.4090	43.5673	28.6520	-52.8158	0.0000	0.0000	0.0000	0.0000;
	146	135	0.006141	0.032521	0.052456	385	385	385	0	0	1	-360	360	-218.1061	26.5395	220.5603	-19.9324	0.0000	0.0000	0.0000	0.0000;
	147	134	0.00438	0.03188	0.050723	457	457	457	0	0	1	-360	360	-226.8000	16.1589	228.6718	-8.7151	0.0000	0.0000	0.0000	0.0000;
	165	147	0.000479	0.00331	0.005711	446	446	446	0	0	1	-360	360	-147.9587	13.4784	148.0460	-13.5675	0.0000	0.0000	0.0000	0.0000;
	166	146	0.000479	0.00331	0.005711	446	446	446	0	0	1	-360	360	-164.3318	11.9155	164.4392	-11.8658	0.0000	0.0000	0.0000	0.0000;
	154	143	0.010539	0.076859	0.122355	373	373	373	0	0	1	-360	360	49.1013	-19.4773	-48.8708	6.7672	0.0000	0.0000	0.0000	0.0000;
	160	148	0.00469	0.034651	0.053821	427	427	427	0	0	1	-360	360	-55.7232	3.1579	55.8486	-8.5613	0.0000	0.0000	0.0000	0.0000;
	149	141	0.006469	0.0413	0.069212	427	427	427	0	0	1	-360	360	42.7384	-9.8604	-42.6361	2.3707	0.0000	0.0000	0.0000	0.0000;
	169	141	0.00105	0.007211	0.01028	373	373	373	0	0	1	-360	360	-21.0745	44.4955	21.0965	-45.5566	0.0000	0.0000	0.0000	0.0000;
	169	160	0.006099	0.044831	0.070954	373	373	373	0	0	1	-360	360	-0.5400	3.3197	0.5429	-11.6633	0.0000	0.0000	0.0000	0.0000;
	177	136	0.002211	0.01655	0.024781	373	373	373	0	0	1	-360	360	72.2750	18.3413	-72.1698	-20.4637	0.0000	0.0000	0.0000	0.0000;
	179	178	0.005169	0.036979	0.058951	373	373	373	0	0	1	-360	360	56.6829	5.9047	-56.5397	-11.8696	0.0000	0.0000	0.0000	0.0000;
	181	174	0.002401	0.017789	0.027588	381	381	381	0	0	1	-360	360	-90.6893	0.2156	90.8625	-2.0832	0.0000	0.0000	0.0000	0.0000;
	158	138	0.00274	0.02696	0.70592	1150	1150	1150	0	0	1	-360	360	17.4641	-81.5116	-17.4072	5.7847	0.0000	0.0000	0.0000	0.0000;
	164	139	0.0017	0.01733	0.45632	915	915	915	0	0	1	-360	360	188.1958	-20.7215	-187.6477	-23.6845	0.0000	0.0000	0.0000	0.0000;
	162	163	0.00136	0.01574	0.433664	1621	1621	1621	0	0	1	-360	360	-111.1804	-2.4087	111.3386	-43.4971	0.0000	0.0000	0.0000	0.0000;
	172	151	0.00371	0.04326	1.18688	693	693	693	0	0	1	-360	360	34.1845	-184.5076	-33.4698	75.8419	0.0000	0.0000	0.0000	0.0000;
	188	193	0.02738	0.142539	0.200473	351	351	351	0	0	1	-360	360	-99.5667	20.8586	102.1519	-30.5095	0.0000	0.0000	0.0000	0.0000;
	197	203	0.02756	0.16014	0.242871	274	274	274	0	0	1	-360	360	-27.8149	3.1169	28.0710	-28.9572	0.0000	0.0000	0.0000	0.0000;
	189	208	0.01905	0.11132	0.167851	274	274	274	0	0	1	-360	360	0.5302	-31.8407	-0.4502	12.3891	0.0000	0.0000	0.0000	0.0000;
	191	194	0.00795	0.05919	0.090798	373	373	373	0	0	1	-360	360	-84.0178	-7.1616	84.5167	0.5741	0.0000	0.0000	0.0000	0.0000;
	193	182	0.0018	0.021141	0.051498	747	747	747	0	0	1	-360	360	39.8966	21.7589	-39.8619	-27.2107	0.0000	0.0000	0.0000	0.0000;
	202	204	0.00731	0.055789	0.083635	274	274	274	0	0	1	-360	360	-82.1525	4.9250	82.6056	-10.7089	0.0000	0.0000	0.0000	0.0000;
	190	201	0.00564	0.041961	0.064372	274	274	274	0	0	1	-360	360	-10.3589	24.1668	10.4029	-31.0128	0.0000	0.0000	0.0000	0.0000;
	208	183	0.0057	0.04236	0.129712	366	366	366	0	0	1	-360	360	-22.5542	-28.9892	22.5991	13.4751	0.0000	0.0000	0.0000	0.0000;
	200	184	0.00131	0.01548	0.41152	1358	1358	1358	0	0	1	-360	360	-180.1104	-9.9421	180.5153	-28.6856	0.0000	0.0000	0.0000	0.0000;
	186	192	0.00224	0.02583	0.72352	831	831	831	0	0	1	-360	360	-490.8964	83.1594	496.4206	-93.5671	0.0000	0.0000	0.0000	0.0000;
	195	187	0.0021	0.02475	0.65792	1358	1358	1358	0	0	1	-360	360	64.1234	-37.1325	-64.0400	-30.0894	0.0000	0.0000	0.0000	0.0000;
	205	199	0.0015	0.01768	0.46944	831	831	831	0	0	1	-360	360	-318.0130	-40.6806	319.4818	8.9485	0.0000	0.0000	0.0000	0.0000;
	186	205	0.00133	0.01569	0.418208	831	831	831	0	0	1	-360	360	262.3945	-36.6627	-261.5079	3.8025	0.0000	0.0000	0.0000	0.0000;
	187	206	0.00133	0.01569	0.418208	831	831	831	0	0	1	-360	360	261.3239	-36.3644	-260.4446	3.4173	0.0000	0.0000	0.0000	0.0000;
	390	1	0.00157	0.06612	0	160	160	160	1.0336	0	1	-360	360	-44.5861	-76.0935	44.6966	80.7450	0.0000	0.0000	0.0000	0.0000;
	391	2	0.00157	0.06612	0	160	160	160	1.0059	0	1	-360	360	-49.1893	-48.5909	49.2545	51.3368	0.0000	0.0000	0.0000	0.0000;
	246	245	0.001008	0.047273	0	300	300	300	1	0	1	-360	360	143.4467	17.5487	-143.2680	-9.1699	0.0000	0.0000	0.0000	0.0000;
	246	28	0.00079	0.03678	0	426	426	426	1	0	1	-360	360	224.5713	112.6045	-224.1482	-92.9046	0.0000	0.0000	0.0000	0.0000;
	248	3	0.001651	0.06736	0	160	160	160	1.026	0	1	-360	360	-78.0106	-7.5559	78.0999	11.1998	0.0000	0.0000	0.0000	0.0000;
	249	3	0.001651	0.06736	0	160	160	160	1.0369	0	1	-360	360	-30.0613	-14.8970	30.0777	15.5685	0.0000	0.0000	0.0000	0.0000;
	275	4	0.001651	0.06901	0	160	160	160	1.0098	0	1	-360	360	-50.9855	2.2407	51.0211	-0.7501	0.0000	0.0000	0.0000	0.0000;
	276	5	0.001651	0.06901	0	160	160	160	1.0192	0	1	-360	360	-64.8041	-6.2584	64.8628	8.7104	0.0000	0.0000	0.0000	0.0000;
	339	6	0.001651	0.068599	0	160	160	160	1.0254	0	1	-360	360	-37.2358	-6.8896	37.2563	7.7431	0.0000	0.0000	0.0000	0.0000;
	339	7	0.001651	0.068599	0	160	160	160	1.0251	0	1	-360	360	-37.4053	-6.3191	37.4259	7.1751	0.0000	0.0000	0.0000	0.0000;
	340	9	0.0015	0.06188	0	250	250	250	1.0824	0	1	-360	360	-112.4920	-38.7167	112.7036	47.4447	0.0000	0.0000	0.0000	0.0000;
	351	11	0.001651	0.06775	0	160	160	160	1.029	0	1	-360	360	-63.1159	-17.1977	63.1783	19.7599	0.0000	0.0000	0.0000	0.0000;
	352	11	0.001651	0.06775	0	160	160	160	1.0237	0	1	-360	360	-47.3175	-13.3740	47.3526	14.8134	0.0000	0.0000	0.0000	0.0000;
	353	12	0.001651	0.06775	0	160	160	160	1.0305	0	1	-360	360	-44.4662	-21.5952	44.5020	23.0642	0.0000	0.0000	0.0000	0.0000;
	359	13	0.00087	0.05244	-0.02144	330	330	330	1.104	0	1	-360	360	-168.3587	-48.9201	168.6308	67.5046	0.0000	0.0000	0.0000	0.0000;
	366	15	0.00087	0.05244	-0.02144	330	330	330	1.0863	0	1	-360	360	-62.0353	-12.7813	62.0684	17.0724	0.0000	0.0000	0.0000	0.0000;
	383	17	0.00124	0.068391	0	160	160	160	0.9992	0	1	-360	360	-48.6709	4.5141	48.6952	-3.1700	0.0000	0.0000	0.0000	0.0000;
	382	18	0.00124	0.068391	0	160	160	160	0.973	0	1	-360	360	13.7263	37.2407	-13.7108	-36.3875	0.0000	0.0000	0.0000	0.0000;
	388	19	0.001651	0.06901	0	160	160	160	1.013	0	1	-360	360	-62.8915	-5.9810	62.9465	8.2808	0.0000	0.0000	0.0000	0.0000;
	389	20	0.001651	0.06901	0	160	160	160	1.0231	0	1	-360	360	-88.0654	-17.0254	88.1780	21.7310	0.0000	0.0000	0.0000	0.0000;
	395	21	0.00155	0.06612	0	160	160	160	0.9955	0	1	-360	360	-46.2691	-1.0637	46.2971	2.2576	0.0000	0.0000	0.0000	0.0000;
	396	21	0.00157	0.06612	0	160	160	160	0.9961	0	1	-360	360	-19.7932	1.6016	19.7984	-1.3827	0.0000	0.0000	0.0000	0.0000;
	401	23	0.001651	0.06901	0	160	160	160	1.0307	0	1	-360	360	-47.7215	-12.1877	47.7567	13.6562	0.0000	0.0000	0.0000	0.0000;
	402	23	0.001651	0.06901	0	160	160	160	1.0154	0	1	-360	360	-35.6888	-4.3581	35.7073	5.1327	0.0000	0.0000	0.0000	0.0000;
	403	24	0.00157	0.067979	0	160	160	160	0.999	0	1	-360	360	-76.0837	-4.4733	76.1598	7.7644	0.0000	0.0000	0.0000	0.0000;
	404	24	0.001651	0.06901	0	160	160	160	0.963	0	1	-360	360	-12.7845	-2.5338	12.7868	2.6310	0.0000	0.0000	0.0000	0.0000;
	410	25	0.0015	0.06188	0	250	250	250	1.0608	0	1	-360	360	-81.9036	9.9687	82.0009	-5.9551	0.0000	0.0000	0.0000	0.0000;
	462	30	0.001651	0.06818	0	160	160	160	1.0095	0	1	-360	360	-76.5989	-6.7951	76.6836	10.2903	0.0000	0.0000	0.0000	0.0000;
	486	31	0.00137	0.06119	-0.01504	250	250	250	1.0735	0	1	-360	360	-96.3539	-4.1245	96.4711	11.0032	0.0000	0.0000	0.0000	0.0000;
	487	31	0.00137	0.06119	-0.01504	250	250	250	1.0736	0	1	-360	360	-98.0763	-9.5608	98.1995	16.7040	0.0000	0.0000	0.0000	0.0000;
	543	32	0.001651	0.07107	0	160	160	160	1.0276	0	1	-360	360	-47.7242	-14.4155	47.7604	15.9750	0.0000	0.0000	0.0000	0.0000;
	570	34	0.001651	0.06901	0	160	160	160	1.012	0	1	-360	360	-0.2007	-10.1726	0.2021	10.2323	0.0000	0.0000	0.0000	0.0000;
	571	34	0.001651	0.06901	0	160	160	160	1.0128	0	1	-360	360	-0.2608	-11.2882	0.2625	11.3618	0.0000	0.0000	0.0000	0.0000;
	584	35	0.001401	0.0668	0	160	160	160	0.9988	0	1	-360	360	-4.9357	6.6114	4.9364	-6.5736	0.0000	0.0000	0.0000	0.0000;
	584	35	0.001401	0.0668	0	160	160	160	1.0417	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	589	36	0.00151	0.067151	0	160	160	160	0.9878	0	1	-360	360	-36.6820	-16.2920	36.7032	17.2362	0.0000	0.0000	0.0000	0.0000;
	609	38	0.00157	0.078081	0	160	160	160	0.9906	0	1	-360	360	-37.3563	-6.6241	37.3755	7.5790	0.0000	0.0000	0.0000	0.0000;
	613	39	0.00149	0.066159	0	160	160	160	0.9969	0	1	-360	360	-34.7191	0.6881	34.7344	-0.0104	0.0000	0.0000	0.0000	0.0000;
	661	43	0.00157	0.06775	0	160	160	160	0.9669	0	1	-360	360	7.1038	42.4602	-7.0808	-41.4665	0.0000	0.0000	0.0000	0.0000;
	663	47	0.00163	0.069461	0	160	160	160	0.9659	0	1	-360	360	-61.7007	1.5465	61.7512	0.6084	0.0000	0.0000	0.0000	0.0000;
	665	49	0.00135	0.06052	0	250	250	250	0.9881	0	1	-360	360	-23.2693	21.5026	23.2818	-20.9415	0.0000	0.0000	0.0000	0.0000;
	692	50	0.00135	0.06052	0	250	250	250	1.0975	0	1	-360	360	-48.7688	-44.1600	48.8272	46.7763	0.0000	0.0000	0.0000	0.0000;
	693	50	0.00153	0.06156	0	250	250	250	1.0768	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	711	51	0.00157	0.066159	0	160	160	160	1.0085	0	1	-360	360	-37.4538	-12.4316	37.4749	13.3199	0.0000	0.0000	0.0000	0.0000;
	727	54	0.0014	0.06235	0	250	250	250	1.0459	0	1	-360	360	-59.6385	6.0641	59.6851	-3.9887	0.0000	0.0000	0.0000	0.0000;
	730	53	0.00139	0.05984	0	250	250	250	1.0798	0	1	-360	360	-58.8714	-44.2778	58.9455	47.4662	0.0000	0.0000	0.0000	0.0000;
	737	56	0.00145	0.068391	0	160	160	160	0.9985	0	1	-360	360	-29.5864	-19.8107	29.6021	20.5538	0.0000	0.0000	0.0000	0.0000;
	755	61	0.001651	0.06775	0	160	160	160	0.9776	0	1	-360	360	-44.8645	-7.2072	44.8928	8.3666	0.0000	0.0000	0.0000	0.0000;
	754	61	0.00157	0.06775	0	160	160	160	0.9761	0	1	-360	360	-45.0773	-4.5386	45.1040	5.6876	0.0000	0.0000	0.0000	0.0000;
	765	62	0.00163	0.067831	0	160	160	160	0.9921	0	1	-360	360	-48.0455	-9.4284	48.0784	10.7965	0.0000	0.0000	0.0000	0.0000;
	764	63	0.00143	0.06831	0	160	160	160	0.9913	0	1	-360	360	-47.5170	-7.9486	47.5448	9.2802	0.0000	0.0000	0.0000	0.0000;
	774	64	0.00139	0.0608	0	250	250	250	1.0203	0	1	-360	360	-14.5659	3.4420	14.5687	-3.3164	0.0000	0.0000	0.0000	0.0000;
	775	65	0.0014	0.06235	0	250	250	250	1.0201	0	1	-360	360	-14.1075	3.7034	14.1102	-3.5811	0.0000	0.0000	0.0000	0.0000;
	803	66	0.00163	0.067539	0	160	160	160	0.9977	0	1	-360	360	-37.3011	-10.9722	37.3222	11.8461	0.0000	0.0000	0.0000	0.0000;
	828	68	0.00161	0.06762	0	160	160	160	0.9984	0	1	-360	360	-56.9559	4.3595	57.0005	-2.4886	0.0000	0.0000	0.0000	0.0000;
	850	69	0.00207	0.067771	-0.003001	160	160	160	1.003	0	1	-360	360	-61.7154	-7.4373	61.7825	9.9952	0.0000	0.0000	0.0000	0.0000;
	880	72	0.001651	0.067979	-0.003194	160	160	160	0.9951	0	1	-360	360	-51.8935	-11.7398	51.9332	13.7539	0.0000	0.0000	0.0000	0.0000;
	897	75	0.00145	0.069211	-0.005324	160	160	160	0.9903	0	1	-360	360	-57.5685	-1.0950	57.6080	3.6308	0.0000	0.0000	0.0000	0.0000;
	998	82	0.00156	0.06269	-0.00992	250	250	250	1.0546	0	1	-360	360	14.2367	0.5892	-14.2338	0.6095	0.0000	0.0000	0.0000	0.0000;
	999	82	0.00156	0.06269	-0.00992	250	250	250	1.0545	0	1	-360	360	24.5994	0.0541	-24.5908	1.3758	0.0000	0.0000	0.0000	0.0000;
	1088	83	0.001651	0.06694	-0.003098	160	160	160	0.989	0	1	-360	360	62.6450	-3.3239	-62.5916	5.8673	0.0000	0.0000	0.0000	0.0000;
	1089	83	0.00145	0.066531	-0.003194	160	160	160	0.9859	0	1	-360	360	66.5309	3.5854	-66.4784	-0.7857	0.0000	0.0000	0.0000	0.0000;
	1111	84	0.00145	0.0655	-0.002517	160	160	160	0.9927	0	1	-360	360	-41.0505	-3.4242	41.0708	4.6489	0.0000	0.0000	0.0000	0.0000;
	1110	85	0.00145	0.07045	-0.002517	160	160	160	0.9984	0	1	-360	360	-0.7503	-9.2630	0.7513	9.6196	0.0000	0.0000	0.0000	0.0000;
	1186	88	0.00145	0.069831	-0.002323	160	160	160	0.9652	0	1	-360	360	-101.9870	-30.7770	102.1308	37.9727	0.0000	0.0000	0.0000	0.0000;
	1187	89	0.001651	0.067771	-0.002807	160	160	160	1.0079	0	1	-360	360	-14.6238	-18.5932	14.6318	19.2530	0.0000	0.0000	0.0000	0.0000;
	1232	94	0.00145	0.06736	-0.006582	160	160	160	0.9976	0	1	-360	360	-19.9410	-3.8619	19.9460	4.8908	0.0000	0.0000	0.0000	0.0000;
	1231	95	0.001651	0.06694	-0.002904	160	160	160	0.9969	0	1	-360	360	2.1697	2.4675	-2.1696	-2.1090	0.0000	0.0000	0.0000	0.0000;
	1246	96	0.00145	0.068391	-0.003194	160	160	160	0.9944	0	1	-360	360	-57.1778	-8.3356	57.2180	10.6157	0.0000	0.0000	0.0000	0.0000;
	1254	100	0.001651	0.06694	-0.002323	160	160	160	0.9607	0	1	-360	360	-51.6493	12.6768	51.6875	-10.8440	0.0000	0.0000	0.0000	0.0000;
	1253	101	0.001651	0.06694	-0.003194	160	160	160	0.9726	0	1	-360	360	-44.6159	-5.7491	44.6439	7.2675	0.0000	0.0000	0.0000	0.0000;
	1285	102	0.00145	0.06756	-0.002226	160	160	160	0.9768	0	1	-360	360	27.0371	11.9457	-27.0268	-11.1938	0.0000	0.0000	0.0000	0.0000;
	1284	103	0.001651	0.06756	-0.003194	160	160	160	0.9943	0	1	-360	360	16.5191	-23.4856	-16.5073	24.3454	0.0000	0.0000	0.0000	0.0000;
	1287	104	0.00145	0.066531	-0.002904	160	160	160	0.9884	0	1	-360	360	-9.1590	10.1729	9.1612	-9.7169	0.0000	0.0000	0.0000	0.0000;
	1362	105	0.001651	0.068599	-0.002904	160	160	160	0.9927	0	1	-360	360	-64.4802	13.7520	64.5381	-10.9885	0.0000	0.0000	0.0000	0.0000;
	1350	106	0.00207	0.093599	-0.003388	160	160	160	0.9916	0	1	-360	360	-17.4163	0.7499	17.4215	-0.1052	0.0000	0.0000	0.0000	0.0000;
	1352	107	0.00186	0.092771	-0.003001	160	160	160	0.9929	0	1	-360	360	1.2821	10.2017	-1.2806	-9.7589	0.0000	0.0000	0.0000	0.0000;
	1387	108	0.00145	0.067151	-0.002226	160	160	160	0.9951	0	1	-360	360	-12.7804	-6.4781	12.7829	6.8610	0.0000	0.0000	0.0000	0.0000;
	1393	110	0.00145	0.0657	-0.005227	160	160	160	0.9851	0	1	-360	360	-50.4044	-3.4489	50.4356	5.4838	0.0000	0.0000	0.0000	0.0000;
	1433	111	0.00145	0.06756	-0.003485	160	160	160	1.0183	0	1	-360	360	-87.1124	-41.6408	87.2318	47.6114	0.0000	0.0000	0.0000	0.0000;
	1572	113	0.00145	0.06756	-0.002904	160	160	160	0.9898	0	1	-360	360	-79.9028	-3.6419	79.9811	7.6373	0.0000	0.0000	0.0000	0.0000;
	1632	115	0.00156	0.06269	-0.00864	250	250	250	1.0654	0	1	-360	360	-74.4159	-19.4258	74.5039	23.8820	0.0000	0.0000	0.0000	0.0000;
	1634	115	0.00156	0.06294	-0.00864	250	250	250	1.0682	0	1	-360	360	-89.9094	-18.6885	90.0347	24.6670	0.0000	0.0000	0.0000	0.0000;
	1677	116	0.00145	0.06736	-0.002226	160	160	160	0.9969	0	1	-360	360	-26.5247	-9.0137	26.5343	9.7262	0.0000	0.0000	0.0000	0.0000;
	1687	119	0.00145	0.06674	-0.006582	160	160	160	0.9769	0	1	-360	360	-73.9073	8.0719	73.9732	-4.2430	0.0000	0.0000	0.0000	0.0000;
	1795	120	0.00137	0.05988	-0.01504	250	250	250	1.0496	0	1	-360	360	-85.4621	-45.1721	85.5877	52.2512	0.0000	0.0000	0.0000	0.0000;
	1797	122	0.00137	0.06119	-0.00992	250	250	250	1.0774	0	1	-360	360	-76.7177	-28.4088	76.8055	33.3910	0.0000	0.0000	0.0000	0.0000;
	1798	123	0.00156	0.06269	-0.00992	250	250	250	1.0672	0	1	-360	360	-61.1173	-21.5411	61.1795	25.1084	0.0000	0.0000	0.0000	0.0000;
	1823	124	0.001651	0.06694	-0.003001	160	160	160	0.9933	0	1	-360	360	-44.3032	-16.1511	44.3345	17.7788	0.0000	0.0000	0.0000	0.0000;
	1843	125	0.00145	0.068599	-0.002323	160	160	160	0.9973	0	1	-360	360	-66.8771	2.0591	66.9299	0.7213	0.0000	0.0000	0.0000	0.0000;
	1842	126	0.001651	0.06818	-0.002904	160	160	160	1.0091	0	1	-360	360	-96.4322	-25.8743	96.5707	31.9455	0.0000	0.0000	0.0000	0.0000;
	1863	129	0.00145	0.06756	-0.003775	160	160	160	0.9979	0	1	-360	360	-63.6507	-1.0147	63.6996	3.7494	0.0000	0.0000	0.0000	0.0000;
	1864	130	0.00145	0.0655	-0.002904	160	160	160	1.0123	0	1	-360	360	-67.7925	-13.5225	67.8511	16.5154	0.0000	0.0000	0.0000	0.0000;
	1933	134	0.001651	0.0625	0	160	160	160	0.9917	0	1	-360	360	42.0546	30.2758	-42.0195	-28.9467	0.0000	0.0000	0.0000	0.0000;
	1955	136	0.00145	0.06818	0	160	160	160	1.0028	0	1	-360	360	-49.6769	-13.7297	49.7104	15.3066	0.0000	0.0000	0.0000	0.0000;
	1956	136	0.001651	0.06818	0	160	160	160	1.0011	0	1	-360	360	-51.2228	-11.9484	51.2625	13.5877	0.0000	0.0000	0.0000	0.0000;
	1979	137	0.00151	0.06688	0	160	160	160	0.9972	0	1	-360	360	-55.0219	-0.0568	55.0609	1.7825	0.0000	0.0000	0.0000	0.0000;
	1981	138	0.00153	0.06206	0	250	250	250	1.0396	0	1	-360	360	-136.5834	-9.6910	136.8517	20.5745	0.0000	0.0000	0.0000	0.0000;
	1982	139	0.00152	0.06206	0	250	250	250	1.0285	0	1	-360	360	-68.1375	5.3307	68.2023	-2.6833	0.0000	0.0000	0.0000	0.0000;
	1987	140	0.00151	0.06688	0	160	160	160	0.9777	0	1	-360	360	-61.2089	-10.5625	61.2573	12.7084	0.0000	0.0000	0.0000	0.0000;
	2013	141	0.00151	0.06688	0	160	160	160	0.9925	0	1	-360	360	-21.5097	-41.8616	21.5396	43.1859	0.0000	0.0000	0.0000	0.0000;
	2019	143	0.00161	0.066531	0	160	160	160	0.9927	0	1	-360	360	-4.0615	-2.5113	4.0618	2.5241	0.0000	0.0000	0.0000	0.0000;
	2020	143	0.00161	0.066531	0	160	160	160	0.983	0	1	-360	360	-30.8036	3.6296	30.8166	-3.0893	0.0000	0.0000	0.0000	0.0000;
	2081	144	0.00145	0.06818	0	160	160	160	0.9832	0	1	-360	360	34.9223	12.5949	-34.9057	-11.8163	0.0000	0.0000	0.0000	0.0000;
	2082	144	0.00145	0.06818	0	160	160	160	0.9953	0	1	-360	360	2.0747	-9.6025	-2.0735	9.6585	0.0000	0.0000	0.0000	0.0000;
	2097	146	0.001651	0.06851	0	160	160	160	0.9966	0	1	-360	360	33.1968	14.9256	-33.1791	-14.1897	0.0000	0.0000	0.0000	0.0000;
	2096	147	0.003409	0.231401	0	80	80	80	1.0213	0	1	-360	360	-29.0322	-11.1949	29.0608	13.1362	0.0000	0.0000	0.0000	0.0000;
	2098	2096	0.01124	0.452479	0	80	80	80	0.9412	0	1	-360	360	18.7074	0.0002	-18.6747	1.3174	0.0000	0.0000	0.0000	0.0000;
	2098	147	0.00562	0.22624	0	80	80	80	0.9407	0	1	-360	360	7.3836	-2.1654	-7.3808	2.2768	0.0000	0.0000	0.0000	0.0000;
	2108	148	0.00163	0.061359	0.004162	160	160	160	0.9874	0	1	-360	360	13.9919	-4.3149	-13.9890	3.9371	0.0000	0.0000	0.0000	0.0000;
	2150	152	0.001651	0.0593	0	160	160	160	0.9712	0	1	-360	360	-25.7523	-5.2303	25.7620	5.5774	0.0000	0.0000	0.0000	0.0000;
	2158	153	0.001651	0.0593	0	160	160	160	0.9833	0	1	-360	360	-57.4805	13.0577	57.5290	-11.3172	0.0000	0.0000	0.0000	0.0000;
	2159	154	0.001651	0.0593	0	160	160	160	0.9837	0	1	-360	360	-52.7542	9.5226	52.7944	-8.0784	0.0000	0.0000	0.0000	0.0000;
	2175	156	0.001651	0.092771	0	160	160	160	1.0039	0	1	-360	360	-19.0607	-9.1163	19.0671	9.4709	0.0000	0.0000	0.0000	0.0000;
	2176	155	0.001651	0.06694	0	160	160	160	0.9994	0	1	-360	360	-18.9433	-5.6452	18.9487	5.8672	0.0000	0.0000	0.0000	0.0000;
	2181	160	0.000289	0.061359	0.004162	160	160	160	0.9813	0	1	-360	360	-20.7707	-3.8887	20.7718	3.6334	0.0000	0.0000	0.0000	0.0000;
	2182	160	0.001651	0.068599	0	160	160	160	0.9858	0	1	-360	360	-34.3915	-4.1673	34.4084	4.8720	0.0000	0.0000	0.0000	0.0000;
	2213	162	0.00101	0.06188	-0.01984	330	330	330	1.0256	0	1	-360	360	-111.0672	6.7179	111.1804	2.4087	0.0000	0.0000	0.0000	0.0000;
	2216	163	0.00101	0.06188	0	330	330	330	1.036	0	1	-360	360	-77.0457	-5.6893	77.1011	9.0828	0.0000	0.0000	0.0000	0.0000;
	2217	163	0.00138	0.05931	0	250	250	250	1.0316	0	1	-360	360	-94.6218	7.6290	94.7346	-2.7817	0.0000	0.0000	0.0000	0.0000;
	2218	165	0.00163	0.070331	0	160	160	160	0.9941	0	1	-360	360	42.7905	34.1215	-42.7517	-32.4497	0.0000	0.0000	0.0000	0.0000;
	2237	168	0.001651	0.0593	0	160	160	160	0.9473	0	1	-360	360	-21.0286	4.8411	21.0348	-4.6171	0.0000	0.0000	0.0000	0.0000;
	2238	168	0.001651	0.0593	0	160	160	160	0.9513	0	1	-360	360	-17.4521	-0.6232	17.4562	0.7707	0.0000	0.0000	0.0000	0.0000;
	2239	169	0.00281	0.10601	0	100	100	100	0.9376	0	1	-360	360	-11.4635	24.0882	11.4797	-23.4759	0.0000	0.0000	0.0000	0.0000;
	2240	169	0.00281	0.10601	0	100	100	100	0.9376	0	1	-360	360	-10.1182	24.9626	10.1347	-24.3393	0.0000	0.0000	0.0000	0.0000;
	2242	171	0.001651	0.0593	0	160	160	160	0.9642	0	1	-360	360	-54.2351	8.6899	54.2753	-7.2466	0.0000	0.0000	0.0000	0.0000;
	2241	172	0.00101	0.06188	-0.01984	330	330	330	1.1183	0	1	-360	360	-23.3478	-13.6048	23.3562	15.9434	0.0000	0.0000	0.0000	0.0000;
	2242	172	0.00153	0.06206	0	250	250	250	1.1322	0	1	-360	360	-11.3326	-23.8688	11.3444	24.3508	0.0000	0.0000	0.0000	0.0000;
	2255	174	0.001651	0.066531	0	160	160	160	1.0098	0	1	-360	360	-67.2777	-48.6291	67.3835	52.8962	0.0000	0.0000	0.0000	0.0000;
	2256	175	0.001651	0.06775	0	160	160	160	0.9971	0	1	-360	360	-112.8542	-26.9560	113.0566	35.2601	0.0000	0.0000	0.0000	0.0000;
	2261	176	0.001651	0.052289	0	160	160	160	0.9704	0	1	-360	360	-39.3839	-7.9560	39.4057	8.6489	0.0000	0.0000	0.0000	0.0000;
	2325	177	0.001651	0.06818	0	160	160	160	0.9971	0	1	-360	360	-58.1506	-5.8029	58.1988	7.7963	0.0000	0.0000	0.0000	0.0000;
	2326	178	0.001651	0.06818	0	160	160	160	0.9968	0	1	-360	360	-46.3043	-2.6846	46.3345	3.9347	0.0000	0.0000	0.0000	0.0000;
	2430	179	0.001651	0.06632	0	160	160	160	0.991	0	1	-360	360	-62.2712	-0.0016	62.3251	2.1658	0.0000	0.0000	0.0000	0.0000;
	2452	181	0.001651	0.06632	0	160	160	160	0.9982	0	1	-360	360	-77.6817	-21.6599	77.7787	25.5584	0.0000	0.0000	0.0000	0.0000;
	2451	181	0.001651	0.06632	0	160	160	160	0.9929	0	1	-360	360	-20.0827	-5.0133	20.0889	5.2641	0.0000	0.0000	0.0000	0.0000;
	2474	182	0.00155	0.065849	0	160	160	160	1.0442	0	1	-360	360	-39.8300	-25.8555	39.8619	27.2107	0.0000	0.0000	0.0000	0.0000;
	2497	185	0.00137	0.05969	0	250	250	250	1.0862	0	1	-360	360	-83.8907	-1.5064	83.9826	5.5108	0.0000	0.0000	0.0000	0.0000;
	2506	186	0.00129	0.06437	0	250	250	250	1.0508	0	1	-360	360	-16.9709	-9.7847	16.9757	10.0262	0.0000	0.0000	0.0000	0.0000;
	2507	187	0.00129	0.06437	0	250	250	250	1.0498	0	1	-360	360	-14.2357	-9.7151	14.2394	9.9020	0.0000	0.0000	0.0000	0.0000;
	2510	189	0.0037	0.18657	0	120	120	120	0.9861	0	1	-360	360	-30.0048	-0.5730	30.0336	2.0279	0.0000	0.0000	0.0000	0.0000;
	2511	188	0.001591	0.06694	0	160	160	160	0.9904	0	1	-360	360	-68.9362	-6.1615	69.0025	8.9509	0.0000	0.0000	0.0000	0.0000;
	2527	190	0.00163	0.066711	0	160	160	160	1.0008	0	1	-360	360	-61.0796	22.5748	61.1396	-20.1192	0.0000	0.0000	0.0000	0.0000;
	2529	191	0.00163	0.066711	0	160	160	160	1.003	0	1	-360	360	-60.3804	18.6410	60.4372	-16.3183	0.0000	0.0000	0.0000	0.0000;
	2528	192	0.00059	0.04206	0	330	330	330	1.1164	0	1	-360	360	-102.7671	-96.5211	102.8937	105.5477	0.0000	0.0000	0.0000	0.0000;
	2535	193	0.001591	0.06736	0	160	160	160	1.0294	0	1	-360	360	-53.7096	-8.6172	53.7513	10.3825	0.0000	0.0000	0.0000	0.0000;
	2536	194	0.001591	0.06736	0	160	160	160	1.0293	0	1	-360	360	-53.5074	-8.4064	53.5487	10.1562	0.0000	0.0000	0.0000	0.0000;
	2601	196	0.00089	0.05411	0	330	330	330	1.0628	0	1	-360	360	64.1709	-34.2646	-64.1237	37.1292	0.0000	0.0000	0.0000	0.0000;
	2603	197	0.00161	0.06756	0	160	160	160	0.9788	0	1	-360	360	-92.9297	34.2245	93.0631	-28.6238	0.0000	0.0000	0.0000	0.0000;
	2604	198	0.00161	0.06756	0	160	160	160	1.0166	0	1	-360	360	-91.2678	-29.2631	91.4026	34.9195	0.0000	0.0000	0.0000	0.0000;
	2669	199	0.00059	0.04206	0	330	330	330	1.0787	0	1	-360	360	-60.5957	0.5929	60.6162	0.8737	0.0000	0.0000	0.0000	0.0000;
	2689	202	0.002771	0.1062	0	100	100	100	1.011	0	1	-360	360	-27.8226	-9.1132	27.8445	9.9548	0.0000	0.0000	0.0000	0.0000;
	2688	201	0.00157	0.0675	0	160	160	160	1.0111	0	1	-360	360	-43.8733	-14.7888	43.9044	16.1270	0.0000	0.0000	0.0000	0.0000;
	2706	203	0.00161	0.06736	0	160	160	160	1.0288	0	1	-360	360	-49.3271	-34.2555	49.3820	36.5525	0.0000	0.0000	0.0000	0.0000;
	2706	204	0.001651	0.066711	0	160	160	160	1.0277	0	1	-360	360	-49.4473	-32.9133	49.5023	35.1344	0.0000	0.0000	0.0000	0.0000;
	2726	205	0.00137	0.05969	0	250	250	250	1.0516	0	1	-360	360	-7.3453	-8.8769	7.3471	8.9543	0.0000	0.0000	0.0000	0.0000;
	2727	205	0.00137	0.05969	0	250	250	250	1.0508	0	1	-360	360	-7.4496	-7.6294	7.4511	7.6955	0.0000	0.0000	0.0000	0.0000;
	2729	207	0.00155	0.067979	0	160	160	160	1.013	0	1	-360	360	-53.8556	-5.2888	53.8934	6.9457	0.0000	0.0000	0.0000	0.0000;
	2730	208	0.00161	0.06775	0	160	160	160	1.0143	0	1	-360	360	-54.0162	-7.5628	54.0562	9.2447	0.0000	0.0000	0.0000	0.0000;
	2592	346	0.054463	0.101322	0.00968	90	90	90	0	0	1	-360	360	-24.2352	5.6295	24.5387	-6.1587	0.0000	0.0000	0.0000	0.0000;
	2087	289	0.023719	0.06124	0.006241	102	102	102	0	0	1	-360	360	-7.5691	2.1366	7.5816	-2.8588	0.0000	0.0000	0.0000	0.0000;
	2122	312	0.024711	0.06281	0.006411	111	111	111	0	0	1	-360	360	11.7793	2.9608	-11.7491	-3.6678	0.0000	0.0000	0.0000	0.0000;
	1932	416	0.042066	0.108603	0.011069	108	108	108	0	0	1	-360	360	2.4978	7.9027	-2.4708	-9.2046	0.0000	0.0000	0.0000	0.0000;
	2069	221	0.061818	0.105041	0.01014	87	87	87	0	0	1	-360	360	-0.4997	-1.1642	0.5000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2383	522	0.059256	0.103967	0.010481	87	87	87	0	0	1	-360	360	-19.0072	-10.6665	19.2409	9.8247	0.0000	0.0000	0.0000	0.0000;
	1262	242	0.033058	0.080992	0.01007	120	120	120	0	0	1	-360	360	-51.1843	-4.5234	51.9057	5.0537	0.0000	0.0000	0.0000	0.0000;
	1272	435	0.021488	0.071066	0.007241	90	90	90	0	0	1	-360	360	0.0000	-0.8625	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	672	377	0.047273	0.083876	0.007739	90	90	90	0	0	1	-360	360	-19.1252	6.3562	19.2954	-6.9424	0.0000	0.0000	0.0000	0.0000;
	624	402	0.074628	0.130248	0.012439	90	90	90	0	0	1	-360	360	7.7199	-14.3575	-7.5623	13.1708	0.0000	0.0000	0.0000	0.0000;
	770	460	0.052231	0.090083	0.008661	90	90	90	0	0	1	-360	360	-26.2509	5.0807	26.5764	-5.5282	0.0000	0.0000	0.0000	0.0000;
	824	1278	0.045446	0.079339	0.008521	69	69	69	0	0	1	-360	360	-8.2664	1.4926	8.2945	-2.4410	0.0000	0.0000	0.0000	0.0000;
	673	1578	0.03719	0.060331	0.006561	58	58	58	0	0	1	-360	360	-10.0094	0.2981	10.0421	-0.9963	0.0000	0.0000	0.0000	0.0000;
	737	1657	0.041322	0.139669	0.01241	137	137	137	0	0	1	-360	360	15.3437	1.4299	-15.2585	-2.5741	0.0000	0.0000	0.0000	0.0000;
	763	1360	0.023967	0.053719	0.008809	69	69	69	0	0	1	-360	360	1.7997	2.9854	-1.7964	-3.9455	0.0000	0.0000	0.0000	0.0000;
	1741	593	0.02438	0.049091	0.004709	90	90	90	0	0	1	-360	360	9.2107	6.6454	-9.1815	-7.1041	0.0000	0.0000	0.0000	0.0000;
	2207	1148	0.035537	0.066124	0.00765	90	90	90	0	0	1	-360	360	-59.8471	22.4961	61.0867	-21.0958	0.0000	0.0000	0.0000	0.0000;
	2423	1147	0.070248	0.120661	0.012901	67	67	67	0	0	1	-360	360	-3.8130	-0.4400	3.8217	-1.0797	0.0000	0.0000	0.0000	0.0000;
	2429	981	0.021488	0.027273	0.005111	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2660	2157	0.068256	0.184298	0.017981	50	50	50	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2493	2363	0.034628	0.060744	0.005711	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2695	2016	0.029174	0.051157	0.004859	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2681	2218	0.03719	0.096686	0.010159	120	120	120	0	0	1	-360	360	-68.4820	4.4152	69.9435	-1.8576	0.0000	0.0000	0.0000	0.0000;
	2617	2218	0.082066	0.200083	0.02217	120	120	120	0	0	1	-360	360	-68.1754	8.6038	71.5512	-3.0324	0.0000	0.0000	0.0000	0.0000;
	2622	2219	0.044628	0.115207	0.012049	120	120	120	0	0	1	-360	360	-36.0107	-3.6475	36.5084	3.4971	0.0000	0.0000	0.0000	0.0000;
	2575	2096	0.041322	0.087603	0.012199	120	120	120	0	0	1	-360	360	-78.0702	3.0723	80.2833	0.1895	0.0000	0.0000	0.0000	0.0000;
	2567	1937	0.039256	0.107438	0.011081	120	120	120	0	0	1	-360	360	-47.5131	7.1500	48.3158	-6.2223	0.0000	0.0000	0.0000	0.0000;
	2587	2219	0.056281	0.183223	0.01876	137	137	137	0	0	1	-360	360	-32.7320	-1.3270	33.2473	0.7705	0.0000	0.0000	0.0000	0.0000;
	1691	786	0.038843	0.064463	0.00695	58	58	58	0	0	1	-360	360	24.6391	-4.7766	-24.4312	4.3130	0.0000	0.0000	0.0000	0.0000;
	2657	2206	0.023058	0.07438	0.007841	137	137	137	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	660	449	0.046777	0.323967	0.031511	133	133	133	0	0	1	-360	360	29.0463	-3.9681	-28.7106	2.5774	0.0000	0.0000	0.0000	0.0000;
	1290	2079	0.040496	0.050413	0.00719	57	57	57	0	0	1	-360	360	9.8922	-4.9277	-9.8511	4.1422	0.0000	0.0000	0.0000	0.0000;
	522	1212	0.057016	0.113223	0.01232	90	90	90	0	0	1	-360	360	5.2296	-2.0811	-5.2160	0.6115	0.0000	0.0000	0.0000	0.0000;
	660	460	0.016364	0.053141	0.00619	120	120	120	0	0	1	-360	360	33.5238	-2.7496	-33.3674	2.5282	0.0000	0.0000	0.0000	0.0000;
	661	252	0.056612	0.130504	0.01307	90	90	90	0	0	1	-360	360	44.0702	-6.9478	-43.1211	7.6118	0.0000	0.0000	0.0000	0.0000;
	509	1014	0.009917	0.029752	0.00356	137	137	137	0	0	1	-360	360	35.7391	2.8075	-35.6358	-2.9350	0.0000	0.0000	0.0000	0.0000;
	2541	2394	0.053331	0.089256	0.009169	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	758	377	0.013967	0.045041	0.00462	137	137	137	0	0	1	-360	360	-12.0143	6.5633	12.0374	-7.0212	0.0000	0.0000	0.0000	0.0000;
	706	330	0.059917	0.101488	0.01089	90	90	90	0	0	1	-360	360	-1.0788	2.3554	1.0840	-3.6336	0.0000	0.0000	0.0000	0.0000;
	691	449	0.07438	0.130248	0.012359	90	90	90	0	0	1	-360	360	16.9307	-3.0507	-16.7489	1.9040	0.0000	0.0000	0.0000	0.0000;
	2559	254	0.038843	0.126446	0.013	76	76	76	0	0	1	-360	360	-32.2790	-0.3920	32.6417	0.1055	0.0000	0.0000	0.0000	0.0000;
	2592	240	0.037017	0.06719	0.006389	76	76	76	0	0	1	-360	360	-10.5527	2.2227	10.5916	-2.8706	0.0000	0.0000	0.0000	0.0000;
	724	476	0.01719	0.055703	0.005689	137	137	137	0	0	1	-360	360	-2.9524	0.4378	2.9538	-1.0826	0.0000	0.0000	0.0000	0.0000;
	824	1671	0.01405	0.042984	0.00513	69	69	69	0	0	1	-360	360	1.6574	-1.4926	-1.6569	0.8945	0.0000	0.0000	0.0000	0.0000;
	1771	705	0.021488	0.040496	0.007991	120	120	120	0	0	1	-360	360	6.3936	-0.7524	-6.3859	-0.1463	0.0000	0.0000	0.0000	0.0000;
	1709	705	0.019008	0.033876	0.00697	69	69	69	0	0	1	-360	360	4.6330	1.0641	-4.6291	-1.8537	0.0000	0.0000	0.0000	0.0000;
	1595	736	0.047934	0.06281	0.01111	90	90	90	0	0	1	-360	360	-45.5120	1.7667	46.3998	-1.8726	0.0000	0.0000	0.0000	0.0000;
	756	330	0.042314	0.075289	0.00702	90	90	90	0	0	1	-360	360	-4.9826	2.0301	4.9937	-2.8382	0.0000	0.0000	0.0000	0.0000;
	2679	369	0.096686	0.119008	0.012579	76	76	76	0	0	1	-360	360	-25.3666	7.4751	25.9716	-8.1781	0.0000	0.0000	0.0000	0.0000;
	2464	333	0.076859	0.095041	0.010159	69	69	69	0	0	1	-360	360	-13.1280	2.5915	13.2545	-3.5678	0.0000	0.0000	0.0000	0.0000;
	661	467	0.056529	0.185868	0.019079	133	133	133	0	0	1	-360	360	21.4494	-6.4459	-21.2157	4.9635	0.0000	0.0000	0.0000	0.0000;
	708	445	0.028256	0.096686	0.009361	34	34	34	0	0	1	-360	360	-8.8905	-1.6550	8.9099	0.6235	0.0000	0.0000	0.0000	0.0000;
	2547	2337	0.04314	0.071901	0.00741	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	654	1018	0.019008	0.058678	0.00682	137	137	137	0	0	1	-360	360	-16.3363	-0.0898	16.3831	-0.5070	0.0000	0.0000	0.0000	0.0000;
	2591	2394	0.030744	0.099173	0.01021	69	69	69	0	0	1	-360	360	6.8054	-4.4053	-6.7897	3.2432	0.0000	0.0000	0.0000	0.0000;
	2588	344	0.021397	0.067603	0.006921	13	13	13	0	0	1	-360	360	3.3982	-0.2629	-3.3960	-0.5000	0.0000	0.0000	0.0000	0.0000;
	1520	2139	0.012397	0.03719	0.004361	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	425	354	0.012231	0.028678	0.00295	133	133	133	0	0	1	-360	360	-51.2378	-7.8540	51.5158	8.1550	0.0000	0.0000	0.0000	0.0000;
	314	220	0.019587	0.063554	0.00659	133	133	133	0	0	1	-360	360	-36.2571	0.0661	36.4792	-0.1146	0.0000	0.0000	0.0000	0.0000;
	561	517	0.00686	0.022066	0.002321	133	133	133	0	0	1	-360	360	-51.6066	-11.5684	51.7737	11.8384	0.0000	0.0000	0.0000	0.0000;
	424	561	0.005537	0.018017	0.001839	133	133	133	0	0	1	-360	360	-47.8009	-11.3102	47.9182	11.4819	0.0000	0.0000	0.0000	0.0000;
	561	565	0.002727	0.009496	0.000999	133	133	133	0	0	1	-360	360	3.6883	0.0865	-3.6880	-0.2000	0.0000	0.0000	0.0000	0.0000;
	343	339	0.023554	0.061066	0.00629	120	120	120	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.7623	0.0000	0.0000	0.0000	0.0000;
	342	340	0.023388	0.061901	0.00629	120	120	120	0	0	1	-360	360	-2.6017	-17.1050	2.6599	16.5265	0.0000	0.0000	0.0000	0.0000;
	385	339	0.015446	0.044876	0.004339	120	120	120	0	0	1	-360	360	-21.8358	-4.7872	21.8998	4.4495	0.0000	0.0000	0.0000	0.0000;
	473	340	0.019669	0.059587	0.005871	120	120	120	0	0	1	-360	360	-24.7935	-6.4654	24.9043	6.1157	0.0000	0.0000	0.0000	0.0000;
	261	401	0.031818	0.058512	0.00559	90	90	90	0	0	1	-360	360	-2.1340	-0.5000	2.1352	-0.1744	0.0000	0.0000	0.0000	0.0000;
	262	402	0.032562	0.06124	0.005491	90	90	90	0	0	1	-360	360	-7.2760	-1.6000	7.2910	0.9781	0.0000	0.0000	0.0000	0.0000;
	456	340	0.002479	0.007769	0.000871	137	137	137	0	0	1	-360	360	-46.3019	-9.6093	46.3492	9.6552	0.0000	0.0000	0.0000	0.0000;
	477	401	0.040579	0.076124	0.006781	90	90	90	0	0	1	-360	360	-30.6393	-2.1736	30.9624	1.9679	0.0000	0.0000	0.0000	0.0000;
	517	456	0.013967	0.043967	0.00485	137	137	137	0	0	1	-360	360	-30.6631	-4.8102	30.7789	4.6093	0.0000	0.0000	0.0000	0.0000;
	423	345	0.043058	0.07157	0.007541	90	90	90	0	0	1	-360	360	-17.3923	2.3741	17.5078	-3.0582	0.0000	0.0000	0.0000	0.0000;
	367	239	0.027364	0.059917	0.00581	90	90	90	0	0	1	-360	360	-20.1708	9.9872	20.2922	-10.3934	0.0000	0.0000	0.0000	0.0000;
	422	237	0.024554	0.079669	0.00818	133	133	133	0	0	1	-360	360	20.9769	1.9433	-20.8836	-2.5944	0.0000	0.0000	0.0000	0.0000;
	477	272	0.055537	0.121653	0.01065	90	90	90	0	0	1	-360	360	17.5413	-2.3264	-17.3955	1.3938	0.0000	0.0000	0.0000	0.0000;
	459	447	0.111818	0.190744	0.019089	90	90	90	0	0	1	-360	360	-7.6341	4.7780	7.7226	-6.8662	0.0000	0.0000	0.0000	0.0000;
	462	253	0.030826	0.100083	0.010341	133	133	133	0	0	1	-360	360	6.4085	5.5688	-6.3878	-6.7087	0.0000	0.0000	0.0000	0.0000;
	285	275	0.019669	0.064554	0.00652	133	133	133	0	0	1	-360	360	-24.7884	-1.2658	24.8877	0.7938	0.0000	0.0000	0.0000	0.0000;
	300	276	0.020909	0.06876	0.006941	133	133	133	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.8603	0.0000	0.0000	0.0000	0.0000;
	327	389	0.023636	0.077364	0.007889	120	120	120	0	0	1	-360	360	-11.6358	-4.4819	11.6651	3.6081	0.0000	0.0000	0.0000	0.0000;
	328	327	0.002479	0.008017	0.00082	120	120	120	0	0	1	-360	360	-6.2988	-3.5788	6.2998	3.4819	0.0000	0.0000	0.0000	0.0000;
	331	259	0.04314	0.08281	0.0075	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0001	-0.9078	0.0000	0.0000	0.0000	0.0000;
	373	276	0.02281	0.074463	0.007589	133	133	133	0	0	1	-360	360	-29.1278	-3.3163	29.2878	2.9048	0.0000	0.0000	0.0000	0.0000;
	573	427	0.029339	0.095124	0.00992	133	133	133	0	0	1	-360	360	0.0000	0.0000	0.0001	-1.2166	0.0000	0.0000	0.0000	0.0000;
	386	312	0.013719	0.044554	0.00461	133	133	133	0	0	1	-360	360	16.2477	-5.6003	-16.2148	5.1459	0.0000	0.0000	0.0000	0.0000;
	335	238	0.029752	0.076859	0.00795	120	120	120	0	0	1	-360	360	-7.0727	-2.7688	7.0867	1.8661	0.0000	0.0000	0.0000	0.0000;
	382	324	0.031488	0.103471	0.01045	133	133	133	0	0	1	-360	360	39.9423	-12.5465	-39.4846	12.8010	0.0000	0.0000	0.0000	0.0000;
	383	370	0.047364	0.083141	0.007889	90	90	90	0	0	1	-360	360	23.6883	-1.3418	-23.4691	0.7772	0.0000	0.0000	0.0000	0.0000;
	370	286	0.024298	0.079752	0.008049	133	133	133	0	0	1	-360	360	48.8182	-13.5871	-48.2980	14.3349	0.0000	0.0000	0.0000	0.0000;
	387	354	0.006446	0.020248	0.002229	90	90	90	0	0	1	-360	360	-31.2850	-1.4178	31.3379	1.3176	0.0000	0.0000	0.0000	0.0000;
	415	371	0.037017	0.121322	0.0121	133	133	133	0	0	1	-360	360	5.6948	0.7459	-5.6837	-2.1032	0.0000	0.0000	0.0000	0.0000;
	533	462	0.022562	0.073223	0.0075	133	133	133	0	0	1	-360	360	-1.9755	1.3353	1.9768	-2.2133	0.0000	0.0000	0.0000	0.0000;
	581	325	0.059256	0.104554	0.00969	90	90	90	0	0	1	-360	360	1.7935	2.7378	-1.7863	-3.8468	0.0000	0.0000	0.0000	0.0000;
	462	223	0.027438	0.082636	0.009951	133	133	133	0	0	1	-360	360	-5.3408	-0.2730	5.3475	-0.8780	0.0000	0.0000	0.0000	0.0000;
	461	475	0.048934	0.155041	0.01573	133	133	133	0	0	1	-360	360	1.8127	-1.6391	-1.8111	-0.2053	0.0000	0.0000	0.0000	0.0000;
	451	423	0.023802	0.078099	0.007889	133	133	133	0	0	1	-360	360	-10.4792	2.1410	10.5033	-2.9741	0.0000	0.0000	0.0000	0.0000;
	288	399	0.007107	0.02281	0.00242	133	133	133	0	0	1	-360	360	-17.9488	5.6174	17.9707	-5.8266	0.0000	0.0000	0.0000	0.0000;
	490	452	0.013719	0.04438	0.0046	137	137	137	0	0	1	-360	360	0.2840	8.6154	-0.2750	-9.1345	0.0000	0.0000	0.0000	0.0000;
	534	291	0.020909	0.052727	0.005801	120	120	120	0	0	1	-360	360	23.7707	-3.6486	-23.6718	3.1928	0.0000	0.0000	0.0000	0.0000;
	271	317	0.011157	0.030413	0.003291	133	133	133	0	0	1	-360	360	-16.0571	-7.4573	16.0867	7.1510	0.0000	0.0000	0.0000	0.0000;
	317	349	0.006686	0.019339	0.002069	137	137	137	0	0	1	-360	360	-28.5057	-10.1510	28.5575	10.0559	0.0000	0.0000	0.0000	0.0000;
	564	516	0.004554	0.014711	0.001539	133	133	133	0	0	1	-360	360	-6.7920	-1.2000	6.7938	1.0254	0.0000	0.0000	0.0000	0.0000;
	211	353	0.006281	0.019339	0.00221	137	137	137	0	0	1	-360	360	8.0310	0.8362	-8.0275	-1.0902	0.0000	0.0000	0.0000	0.0000;
	211	358	0.006198	0.019917	0.002096	137	137	137	0	0	1	-360	360	-15.7920	-2.8362	15.8053	2.6274	0.0000	0.0000	0.0000	0.0000;
	548	353	0.00438	0.010826	0.001191	133	133	133	0	0	1	-360	360	-31.1134	-9.0256	31.1520	8.9786	0.0000	0.0000	0.0000	0.0000;
	557	502	0.007273	0.020661	0.002021	120	120	120	0	0	1	-360	360	6.7755	1.2368	-6.7725	-1.4674	0.0000	0.0000	0.0000	0.0000;
	558	503	0.007273	0.020661	0.002021	120	120	120	0	0	1	-360	360	11.7862	-3.0864	-11.7771	2.8759	0.0000	0.0000	0.0000	0.0000;
	503	493	0.00562	0.017769	0.001951	133	133	133	0	0	1	-360	360	-29.9528	-10.5295	30.0011	10.4533	0.0000	0.0000	0.0000	0.0000;
	494	352	0.007438	0.019008	0.002081	133	133	133	0	0	1	-360	360	-55.2285	-18.2675	55.4420	18.5664	0.0000	0.0000	0.0000	0.0000;
	543	354	0.004298	0.026942	0.002887	120	120	120	0	0	1	-360	360	21.6979	-7.3531	-21.6791	7.1251	0.0000	0.0000	0.0000	0.0000;
	531	352	0.013636	0.033967	0.003751	120	120	120	0	0	1	-360	360	10.2786	5.0071	-10.2634	-5.4180	0.0000	0.0000	0.0000	0.0000;
	525	353	0.010826	0.02719	0.003001	120	120	120	0	0	1	-360	360	6.8148	1.7252	-6.8103	-2.0733	0.0000	0.0000	0.0000	0.0000;
	541	530	0.003876	0.009421	0.00105	120	120	120	0	0	1	-360	360	45.6488	11.6442	-45.5776	-11.5978	0.0000	0.0000	0.0000	0.0000;
	535	560	0.010165	0.025289	0.002708	120	120	120	0	0	1	-360	360	68.0761	4.8121	-67.6864	-4.1697	0.0000	0.0000	0.0000	0.0000;
	490	353	0.00157	0.005124	0.00053	133	133	133	0	0	1	-360	360	0.7760	-6.2154	-0.7754	6.1536	0.0000	0.0000	0.0000	0.0000;
	491	353	0.002066	0.006686	0.000709	133	133	133	0	0	1	-360	360	-17.9513	-6.9886	17.9577	6.9246	0.0000	0.0000	0.0000	0.0000;
	535	524	0.017934	0.048016	0.00522	120	120	120	0	0	1	-360	360	21.1333	11.0662	-21.0483	-11.4682	0.0000	0.0000	0.0000	0.0000;
	538	548	0.01405	0.039669	0.00432	133	133	133	0	0	1	-360	360	-19.4230	-5.8015	19.4714	5.4256	0.0000	0.0000	0.0000	0.0000;
	536	535	0.00438	0.010578	0.0012	120	120	120	0	0	1	-360	360	-5.8210	-1.8000	5.8223	1.6574	0.0000	0.0000	0.0000	0.0000;
	537	534	0.00438	0.010578	0.0012	120	120	120	0	0	1	-360	360	-8.7320	-2.7000	8.7350	2.5611	0.0000	0.0000	0.0000	0.0000;
	558	542	0.007273	0.017603	0.00196	120	120	120	0	0	1	-360	360	48.5036	8.5965	-48.3527	-8.4597	0.0000	0.0000	0.0000	0.0000;
	558	500	0.00124	0.003058	0.000351	120	120	120	0	0	1	-360	360	10.0139	2.3485	-10.0128	-2.3868	0.0000	0.0000	0.0000	0.0000;
	538	502	0.002066	0.006942	0.000699	133	133	133	0	0	1	-360	360	4.8700	2.0515	-4.8695	-2.1326	0.0000	0.0000	0.0000	0.0000;
	517	340	0.01405	0.044463	0.00484	133	133	133	0	0	1	-360	360	-38.3954	-6.4044	38.5787	6.4192	0.0000	0.0000	0.0000	0.0000;
	563	274	0.004876	0.015793	0.00166	120	120	120	0	0	1	-360	360	41.8616	11.3631	-41.7853	-11.3153	0.0000	0.0000	0.0000	0.0000;
	526	274	0.01314	0.034711	0.00364	120	120	120	0	0	1	-360	360	-41.4830	-11.1750	41.6883	11.2853	0.0000	0.0000	0.0000	0.0000;
	339	273	0.008678	0.028256	0.00287	120	120	120	0	0	1	-360	360	1.0812	-2.9829	-1.0806	2.6370	0.0000	0.0000	0.0000	0.0000;
	336	273	0.002066	0.005289	0.00054	120	120	120	0	0	1	-360	360	-0.9835	2.6019	0.9836	-2.6670	0.0000	0.0000	0.0000	0.0000;
	534	336	0.008099	0.019587	0.00219	120	120	120	0	0	1	-360	360	13.5851	6.8731	-13.5695	-7.1019	0.0000	0.0000	0.0000	0.0000;
	550	337	0.012479	0.032149	0.00319	120	120	120	0	0	1	-360	360	-6.4806	-2.3933	6.4856	2.0322	0.0000	0.0000	0.0000	0.0000;
	539	495	0.000413	0.001653	0.008661	109	109	109	0	0	1	-360	360	-60.8208	3.1356	60.8336	-4.1201	0.0000	0.0000	0.0000	0.0000;
	495	560	0.002521	0.007207	0.009269	120	120	120	0	0	1	-360	360	-70.0506	1.2701	70.1541	-2.0844	0.0000	0.0000	0.0000	0.0000;
	531	560	0.001372	0.003545	0.000361	120	120	120	0	0	1	-360	360	2.4682	-6.2959	-2.4677	6.2540	0.0000	0.0000	0.0000	0.0000;
	352	359	0.012397	0.039174	0.004291	133	133	133	0	0	1	-360	360	-20.4867	-5.4109	20.5331	5.0438	0.0000	0.0000	0.0000	0.0000;
	518	359	0.00438	0.014132	0.001498	133	133	133	0	0	1	-360	360	-49.7455	-13.8606	49.8432	13.9966	0.0000	0.0000	0.0000	0.0000;
	348	506	0.012727	0.03562	0.003531	133	133	133	0	0	1	-360	360	-10.6840	-2.9481	10.6971	2.5661	0.0000	0.0000	0.0000	0.0000;
	557	348	0.000504	0.001488	0.00015	133	133	133	0	0	1	-360	360	-4.1839	-1.2857	4.1840	1.2681	0.0000	0.0000	0.0000	0.0000;
	544	271	0.004207	0.011653	0.001261	133	133	133	0	0	1	-360	360	-5.3833	-4.8497	5.3851	4.7073	0.0000	0.0000	0.0000	0.0000;
	503	418	0.001397	0.005868	0.031039	95	95	95	0	0	1	-360	360	29.1168	3.7535	-29.1063	-7.3389	0.0000	0.0000	0.0000	0.0000;
	353	575	0.005289	0.016942	0.001781	133	133	133	0	0	1	-360	360	10.9699	2.7019	-10.9642	-2.8967	0.0000	0.0000	0.0000	0.0000;
	352	515	0.003967	0.01281	0.00135	133	133	133	0	0	1	-360	360	22.6257	5.6365	-22.6076	-5.7389	0.0000	0.0000	0.0000	0.0000;
	523	543	0.000413	0.001901	0.009929	98	98	98	0	0	1	-360	360	-34.4421	-7.4340	34.4464	6.2664	0.0000	0.0000	0.0000	0.0000;
	530	525	0.003223	0.007934	0.000881	120	120	120	0	0	1	-360	360	36.9306	11.0174	-36.8908	-11.0252	0.0000	0.0000	0.0000	0.0000;
	545	491	0.003141	0.009917	0.001019	133	133	133	0	0	1	-360	360	-10.6720	-3.3000	10.6753	3.1886	0.0000	0.0000	0.0000	0.0000;
	506	576	0.000579	0.001744	0.000179	133	133	133	0	0	1	-360	360	-34.9521	-10.0661	34.9585	10.0643	0.0000	0.0000	0.0000	0.0000;
	541	534	0.00438	0.010661	0.001191	120	120	120	0	0	1	-360	360	-65.0528	-16.6442	65.2160	16.8970	0.0000	0.0000	0.0000	0.0000;
	550	500	0.010174	0.024628	0.002739	120	120	120	0	0	1	-360	360	1.6296	0.8933	-1.6292	-1.2132	0.0000	0.0000	0.0000	0.0000;
	547	530	0.006612	0.022314	0.00218	133	133	133	0	0	1	-360	360	17.5680	7.3237	-17.5480	-7.5195	0.0000	0.0000	0.0000	0.0000;
	547	534	0.005793	0.018934	0.00198	133	133	133	0	0	1	-360	360	-38.9120	-12.8237	38.9922	12.8458	0.0000	0.0000	0.0000	0.0000;
	532	531	0.002314	0.00686	0.000699	133	133	133	0	0	1	-360	360	18.5744	0.4470	-18.5678	-0.5111	0.0000	0.0000	0.0000	0.0000;
	535	532	0.012727	0.041322	0.004221	133	133	133	0	0	1	-360	360	39.1138	6.7752	-38.9484	-6.7480	0.0000	0.0000	0.0000	0.0000;
	518	576	0.003554	0.011397	0.001191	133	133	133	0	0	1	-360	360	35.1925	10.1106	-35.1525	-10.1243	0.0000	0.0000	0.0000	0.0000;
	349	507	0.000504	0.001488	0.00015	133	133	133	0	0	1	-360	360	-28.5575	-10.0559	28.5614	10.0495	0.0000	0.0000	0.0000	0.0000;
	520	575	0.002149	0.006942	0.000731	133	133	133	0	0	1	-360	360	-8.0520	-2.0800	8.0532	1.9967	0.0000	0.0000	0.0000	0.0000;
	519	514	0.002397	0.007851	0.00082	133	133	133	0	0	1	-360	360	-8.0530	-2.0800	8.0544	1.9870	0.0000	0.0000	0.0000	0.0000;
	558	544	0.003554	0.009917	0.00106	133	133	133	0	0	1	-360	360	9.1723	-0.4666	-9.1697	0.3497	0.0000	0.0000	0.0000	0.0000;
	557	220	0.009917	0.029752	0.003161	120	120	120	0	0	1	-360	360	42.4525	1.4667	-42.3012	-1.3854	0.0000	0.0000	0.0000	0.0000;
	535	504	0.013388	0.03876	0.004099	120	120	120	0	0	1	-360	360	46.6325	13.5167	-46.3721	-13.2564	0.0000	0.0000	0.0000	0.0000;
	501	337	0.019669	0.053554	0.005779	120	120	120	0	0	1	-360	360	21.1191	6.0688	-21.0386	-6.5322	0.0000	0.0000	0.0000	0.0000;
	504	501	0.002636	0.008512	0.000891	120	120	120	0	0	1	-360	360	34.7301	10.2564	-34.7011	-10.2688	0.0000	0.0000	0.0000	0.0000;
	542	517	0.008512	0.022066	0.00241	120	120	120	0	0	1	-360	360	13.4257	-2.3403	-13.4121	2.0959	0.0000	0.0000	0.0000	0.0000;
	549	516	0.004628	0.012314	0.001261	120	120	120	0	0	1	-360	360	1.6972	-0.6882	-1.6970	0.5406	0.0000	0.0000	0.0000	0.0000;
	546	401	0.018934	0.063554	0.00649	133	133	133	0	0	1	-360	360	-10.6720	-3.3000	10.6913	2.5810	0.0000	0.0000	0.0000	0.0000;
	524	402	0.016198	0.040174	0.004361	120	120	120	0	0	1	-360	360	8.9213	8.3382	-8.9005	-8.8066	0.0000	0.0000	0.0000	0.0000;
	516	496	0.008678	0.027851	0.002931	133	133	133	0	0	1	-360	360	-10.9188	-3.3660	10.9284	3.0523	0.0000	0.0000	0.0000	0.0000;
	517	399	0.020661	0.066446	0.006979	133	133	133	0	0	1	-360	360	24.8750	-4.5197	-24.7617	4.0766	0.0000	0.0000	0.0000	0.0000;
	543	540	0.000826	0.003719	0.019491	109	109	109	0	0	1	-360	360	-30.7351	8.6022	30.7423	-10.9007	0.0000	0.0000	0.0000	0.0000;
	339	563	0.004132	0.013314	0.001401	120	120	120	0	0	1	-360	360	51.6600	12.5044	-51.5636	-12.3631	0.0000	0.0000	0.0000	0.0000;
	528	523	0.00057	0.002314	0.0121	98	98	98	0	0	1	-360	360	-4.8510	-1.2500	4.8511	-0.1960	0.0000	0.0000	0.0000	0.0000;
	419	529	0.00057	0.002314	0.0121	98	98	98	0	0	1	-360	360	4.8511	-0.1634	-4.8510	-1.2500	0.0000	0.0000	0.0000	0.0000;
	549	526	0.004132	0.010992	0.001169	120	120	120	0	0	1	-360	360	-31.7432	-8.2118	31.7810	8.1750	0.0000	0.0000	0.0000	0.0000;
	507	358	0.003967	0.012727	0.00137	133	133	133	0	0	1	-360	360	-81.9224	-26.5495	82.1699	27.1801	0.0000	0.0000	0.0000	0.0000;
	467	330	0.033223	0.107851	0.011139	133	133	133	0	0	1	-360	360	17.8197	-6.4635	-17.7206	5.4718	0.0000	0.0000	0.0000	0.0000;
	355	293	0.02124	0.069752	0.00704	133	133	133	0	0	1	-360	360	-4.4208	-4.9636	4.4282	4.1707	0.0000	0.0000	0.0000	0.0000;
	408	341	0.068603	0.12	0.01149	90	90	90	0	0	1	-360	360	23.5223	-15.6128	-23.0583	15.1022	0.0000	0.0000	0.0000	0.0000;
	580	463	0.041744	0.076281	0.00695	90	90	90	0	0	1	-360	360	-13.9317	6.7088	14.0195	-7.3573	0.0000	0.0000	0.0000	0.0000;
	521	424	0.013719	0.03719	0.00363	120	120	120	0	0	1	-360	360	-34.0685	-8.5126	34.2189	8.5102	0.0000	0.0000	0.0000	0.0000;
	408	252	0.017769	0.03124	0.002969	90	90	90	0	0	1	-360	360	-32.2543	14.6128	32.4491	-14.6118	0.0000	0.0000	0.0000	0.0000;
	463	447	0.032397	0.095868	0.00967	90	90	90	0	0	1	-360	360	-23.8185	4.5573	23.9837	-5.1976	0.0000	0.0000	0.0000	0.0000;
	378	239	0.015041	0.030752	0.002979	90	90	90	0	0	1	-360	360	-8.1016	-3.9573	8.1121	3.6349	0.0000	0.0000	0.0000	0.0000;
	413	378	0.011818	0.019669	0.002069	90	90	90	0	0	1	-360	360	-6.1564	-3.6865	6.1616	3.4573	0.0000	0.0000	0.0000	0.0000;
	253	231	0.009174	0.029826	0.003071	133	133	133	0	0	1	-360	360	-14.9572	1.7087	14.9752	-2.0065	0.0000	0.0000	0.0000	0.0000;
	420	231	0.007851	0.025446	0.002621	133	133	133	0	0	1	-360	360	26.6661	3.8469	-26.6172	-3.9935	0.0000	0.0000	0.0000	0.0000;
	448	447	0.006364	0.020909	0.00212	133	133	133	0	0	1	-360	360	40.3127	-6.4802	-40.2223	6.5287	0.0000	0.0000	0.0000	0.0000;
	521	433	0.022397	0.039256	0.00372	90	90	90	0	0	1	-360	360	3.8842	0.6888	-3.8810	-1.1000	0.0000	0.0000	0.0000	0.0000;
	555	434	0.078678	0.139339	0.01292	90	90	90	0	0	1	-360	360	6.8235	0.5577	-6.7910	-2.0000	0.0000	0.0000	0.0000	0.0000;
	527	521	0.00595	0.01157	0.001101	90	90	90	0	0	1	-360	360	-19.1986	-6.4049	19.2203	6.3239	0.0000	0.0000	0.0000	0.0000;
	481	212	0.04719	0.082727	0.00785	90	90	90	0	0	1	-360	360	6.3319	4.0775	-6.3060	-4.8928	0.0000	0.0000	0.0000	0.0000;
	425	421	0.004959	0.014207	0.00145	120	120	120	0	0	1	-360	360	41.5358	5.8540	-41.4619	-5.8130	0.0000	0.0000	0.0000	0.0000;
	422	383	0.059256	0.191983	0.01974	133	133	133	0	0	1	-360	360	-28.1559	-2.3433	28.5570	1.2869	0.0000	0.0000	0.0000	0.0000;
	512	239	0.002893	0.009256	0.000961	133	133	133	0	0	1	-360	360	8.7027	-4.8948	-8.7002	4.7917	0.0000	0.0000	0.0000	0.0000;
	382	379	0.003967	0.012984	0.001319	133	133	133	0	0	1	-360	360	39.9656	-0.1569	-39.9126	0.1729	0.0000	0.0000	0.0000	0.0000;
	566	380	0.017017	0.055124	0.005421	133	133	133	0	0	1	-360	360	-22.9541	-3.8034	23.0320	3.4143	0.0000	0.0000	0.0000	0.0000;
	554	551	0.011066	0.019339	0.001839	90	90	90	0	0	1	-360	360	-4.8510	-0.8000	4.8533	0.5931	0.0000	0.0000	0.0000	0.0000;
	473	290	0.009421	0.030413	0.003151	133	133	133	0	0	1	-360	360	23.8235	6.4654	-23.7738	-6.6685	0.0000	0.0000	0.0000	0.0000;
	417	345	0.060909	0.10124	0.01098	90	90	90	0	0	1	-360	360	22.5943	-3.4106	-22.3288	2.5582	0.0000	0.0000	0.0000	0.0000;
	380	382	0.006777	0.014463	0.001319	133	133	133	0	0	1	-360	360	-33.3160	-5.2143	33.3808	5.1952	0.0000	0.0000	0.0000	0.0000;
	417	379	0.006529	0.012066	0.00129	90	90	90	0	0	1	-360	360	-29.8703	2.4106	29.9196	-2.4729	0.0000	0.0000	0.0000	0.0000;
	383	381	0.039669	0.128603	0.01323	133	133	133	0	0	1	-360	360	17.4375	6.0787	-17.3226	-7.2918	0.0000	0.0000	0.0000	0.0000;
	381	335	0.023141	0.055868	0.00629	120	120	120	0	0	1	-360	360	1.7986	3.9918	-1.7943	-4.7234	0.0000	0.0000	0.0000	0.0000;
	555	335	0.053223	0.135124	0.013741	120	120	120	0	0	1	-360	360	-7.7935	-1.0577	7.8212	-0.4832	0.0000	0.0000	0.0000	0.0000;
	499	335	0.039421	0.127686	0.01323	133	133	133	0	0	1	-360	360	6.2590	-7.5314	-6.2302	6.0754	0.0000	0.0000	0.0000	0.0000;
	315	371	0.020174	0.06405	0.006749	133	133	133	0	0	1	-360	360	10.4944	2.0881	-10.4741	-2.8008	0.0000	0.0000	0.0000	0.0000;
	387	223	0.035289	0.108182	0.010999	90	90	90	0	0	1	-360	360	21.0010	-0.1822	-20.8705	-0.7220	0.0000	0.0000	0.0000	0.0000;
	266	421	0.003314	0.010909	0.001101	133	133	133	0	0	1	-360	360	-35.6252	-7.8183	35.6629	7.8130	0.0000	0.0000	0.0000	0.0000;
	266	420	0.003471	0.011322	0.001169	133	133	133	0	0	1	-360	360	32.7142	6.8183	-32.6811	-6.8469	0.0000	0.0000	0.0000	0.0000;
	556	212	0.039091	0.06843	0.00649	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.7072	0.0000	0.0000	0.0000	0.0000;
	557	496	0.006529	0.017364	0.001989	120	120	120	0	0	1	-360	360	27.4670	7.1861	-27.4224	-7.3023	0.0000	0.0000	0.0000	0.0000;
	527	481	0.032893	0.057438	0.00521	90	90	90	0	0	1	-360	360	13.1836	5.4049	-13.1229	-5.8775	0.0000	0.0000	0.0000	0.0000;
	451	239	0.011653	0.042984	0.003901	90	90	90	0	0	1	-360	360	7.4712	-3.1410	-7.4648	2.7140	0.0000	0.0000	0.0000	0.0000;
	290	281	0.009008	0.029174	0.00302	133	133	133	0	0	1	-360	360	7.7658	0.6685	-7.7610	-1.0000	0.0000	0.0000	0.0000	0.0000;
	355	342	0.023141	0.075207	0.007739	133	133	133	0	0	1	-360	360	-3.3402	2.6636	3.3444	-3.5441	0.0000	0.0000	0.0000	0.0000;
	447	293	0.011744	0.037934	0.00392	133	133	133	0	0	1	-360	360	6.3750	5.0350	-6.3682	-5.4707	0.0000	0.0000	0.0000	0.0000;
	512	315	0.006942	0.022562	0.00234	90	90	90	0	0	1	-360	360	-10.6427	4.3948	10.6507	-4.6390	0.0000	0.0000	0.0000	0.0000;
	497	239	0.003554	0.011397	0.001181	133	133	133	0	0	1	-360	360	13.5511	-6.1925	-13.5443	6.0778	0.0000	0.0000	0.0000	0.0000;
	449	448	0.006364	0.020744	0.002139	133	133	133	0	0	1	-360	360	44.6905	-5.8733	-44.5807	5.9802	0.0000	0.0000	0.0000	0.0000;
	316	314	0.006942	0.02281	0.002299	133	133	133	0	0	1	-360	360	-35.2126	0.5459	35.2871	-0.5671	0.0000	0.0000	0.0000	0.0000;
	566	393	0.019752	0.064793	0.006551	133	133	133	0	0	1	-360	360	19.5581	3.3034	-19.4916	-3.8527	0.0000	0.0000	0.0000	0.0000;
	551	393	0.031157	0.084628	0.008429	90	90	90	0	0	1	-360	360	-17.4653	-4.0931	17.5516	3.3527	0.0000	0.0000	0.0000	0.0000;
	580	499	0.005372	0.017521	0.001769	133	133	133	0	0	1	-360	360	11.7977	-7.2088	-11.7890	7.0314	0.0000	0.0000	0.0000	0.0000;
	244	382	0.016777	0.056612	0.00575	133	133	133	0	0	1	-360	360	-8.0597	-1.3666	8.0690	0.7118	0.0000	0.0000	0.0000	0.0000;
	361	244	0.02686	0.088099	0.008901	133	133	133	0	0	1	-360	360	-5.8210	-1.0000	5.8287	-0.0334	0.0000	0.0000	0.0000	0.0000;
	341	472	0.027273	0.07157	0.007432	133	133	133	0	0	1	-360	360	0.9702	-0.3563	-0.9700	-0.5000	0.0000	0.0000	0.0000	0.0000;
	497	288	0.013719	0.044711	0.0046	133	133	133	0	0	1	-360	360	-15.4911	5.6925	15.5238	-6.1174	0.0000	0.0000	0.0000	0.0000;
	413	371	0.005446	0.017521	0.00183	133	133	133	0	0	1	-360	360	-0.1496	1.8865	0.1498	-2.0960	0.0000	0.0000	0.0000	0.0000;
	291	401	0.006198	0.017769	0.001909	120	120	120	0	0	1	-360	360	15.9698	-3.0059	-15.9564	2.8131	0.0000	0.0000	0.0000	0.0000;
	452	402	0.010744	0.034207	0.003521	137	137	137	0	0	1	-360	360	-14.2780	5.6345	14.2995	-5.9842	0.0000	0.0000	0.0000	0.0000;
	280	385	0.005702	0.018512	0.001931	133	133	133	0	0	1	-360	360	-10.6720	-3.0000	10.6778	2.7872	0.0000	0.0000	0.0000	0.0000;
	321	311	0.002231	0.007273	0.000731	120	120	120	0	0	1	-360	360	-10.8952	-9.9180	10.8991	9.8402	0.0000	0.0000	0.0000	0.0000;
	310	275	0.003058	0.009587	0.000999	120	120	120	0	0	1	-360	360	37.8100	8.6999	-37.7726	-8.7059	0.0000	0.0000	0.0000	0.0000;
	318	304	0.005793	0.016612	0.001791	120	120	120	0	0	1	-360	360	4.6152	-5.2759	-4.6129	5.0623	0.0000	0.0000	0.0000	0.0000;
	432	275	0.018017	0.046364	0.0047	120	120	120	0	0	1	-360	360	-38.7519	10.2210	38.9890	-10.1876	0.0000	0.0000	0.0000	0.0000;
	510	276	0.004628	0.014876	0.00145	120	120	120	0	0	1	-360	360	-12.6124	-0.0694	12.6183	-0.0910	0.0000	0.0000	0.0000	0.0000;
	329	275	0.007107	0.022727	0.00242	133	133	133	0	0	1	-360	360	-21.5399	-8.1462	21.5706	7.9476	0.0000	0.0000	0.0000	0.0000;
	303	241	0.001066	0.00281	0.000329	120	120	120	0	0	1	-360	360	-0.3392	-4.6985	0.3394	4.6583	0.0000	0.0000	0.0000	0.0000;
	308	241	0.009917	0.026364	0.002991	120	120	120	0	0	1	-360	360	4.8073	5.9715	-4.8024	-6.3283	0.0000	0.0000	0.0000	0.0000;
	478	308	0.004628	0.013876	0.00167	120	120	120	0	0	1	-360	360	-48.1773	-12.8696	48.2707	12.9435	0.0000	0.0000	0.0000	0.0000;
	305	309	0.003719	0.011901	0.001251	120	120	120	0	0	1	-360	360	0.0479	3.3491	-0.0476	-3.5007	0.0000	0.0000	0.0000	0.0000;
	579	307	0.000579	0.001983	0.00021	120	120	120	0	0	1	-360	360	-19.7505	-10.6163	19.7528	10.5986	0.0000	0.0000	0.0000	0.0000;
	305	579	0.003058	0.009917	0.001041	120	120	120	0	0	1	-360	360	-14.8919	-8.8991	14.8995	8.7963	0.0000	0.0000	0.0000	0.0000;
	570	307	0.005289	0.016446	0.00189	123	123	123	0	0	1	-360	360	-1.1730	1.3376	1.1732	-1.5686	0.0000	0.0000	0.0000	0.0000;
	562	326	0.007364	0.023876	0.002481	120	120	120	0	0	1	-360	360	-0.5989	11.8316	0.6076	-12.1055	0.0000	0.0000	0.0000	0.0000;
	297	562	0.002149	0.006446	0.000779	120	120	120	0	0	1	-360	360	-7.2286	0.6302	7.2296	-0.7225	0.0000	0.0000	0.0000	0.0000;
	570	562	0.00562	0.018182	0.0019	120	120	120	0	0	1	-360	360	6.6383	10.9015	-6.6307	-11.1092	0.0000	0.0000	0.0000	0.0000;
	442	306	0.004876	0.012397	0.00121	120	120	120	0	0	1	-360	360	49.3071	13.4854	-49.2027	-13.3676	0.0000	0.0000	0.0000	0.0000;
	442	389	0.00595	0.017934	0.002161	120	120	120	0	0	1	-360	360	-56.0981	-16.2554	56.2639	16.4898	0.0000	0.0000	0.0000	0.0000;
	571	478	0.00405	0.012984	0.001341	120	120	120	0	0	1	-360	360	-36.2955	-8.4572	36.3413	8.4396	0.0000	0.0000	0.0000	0.0000;
	570	443	0.007521	0.022636	0.002701	120	120	120	0	0	1	-360	360	22.9526	6.3481	-22.9176	-6.5729	0.0000	0.0000	0.0000	0.0000;
	389	236	0.013876	0.036281	0.003959	120	120	120	0	0	1	-360	360	6.8948	-2.2008	-6.8890	1.7271	0.0000	0.0000	0.0000	0.0000;
	311	236	0.016612	0.047017	0.005051	120	120	120	0	0	1	-360	360	2.0410	4.7536	-2.0370	-5.3671	0.0000	0.0000	0.0000	0.0000;
	322	306	0.005041	0.016124	0.001699	120	120	120	0	0	1	-360	360	-11.6130	-4.7400	11.6195	4.5548	0.0000	0.0000	0.0000	0.0000;
	334	276	0.010578	0.028017	0.003161	120	120	120	0	0	1	-360	360	-17.9032	-1.9924	17.9309	1.6749	0.0000	0.0000	0.0000	0.0000;
	323	306	0.002636	0.008603	0.0009	120	120	120	0	0	1	-360	360	-14.5107	6.7400	14.5162	-6.8311	0.0000	0.0000	0.0000	0.0000;
	326	323	8.3e-05	0.000331	4.1e-05	120	120	120	0	0	1	-360	360	-9.5336	8.7655	9.5337	-8.7700	0.0000	0.0000	0.0000	0.0000;
	334	303	0.003388	0.01124	0.001111	120	120	120	0	0	1	-360	360	9.2682	-1.2376	-9.2658	1.1085	0.0000	0.0000	0.0000	0.0000;
	309	297	0.002231	0.006777	0.00082	120	120	120	0	0	1	-360	360	0.0476	3.5007	-0.0474	-3.6002	0.0000	0.0000	0.0000	0.0000;
	468	259	0.010661	0.032314	0.003831	120	120	120	0	0	1	-360	360	6.7953	1.1809	-6.7911	-1.6322	0.0000	0.0000	0.0000	0.0000;
	443	468	0.015793	0.047851	0.00568	120	120	120	0	0	1	-360	360	11.2756	2.2129	-11.2583	-2.8509	0.0000	0.0000	0.0000	0.0000;
	310	304	0.005702	0.013719	0.001549	120	120	120	0	0	1	-360	360	8.6862	9.8609	-8.6781	-10.0323	0.0000	0.0000	0.0000	0.0000;
	229	570	0.001322	0.004298	0.00045	11	11	11	0	0	1	-360	360	3.2690	0.4500	-3.2689	-0.5048	0.0000	0.0000	0.0000	0.0000;
	284	275	0.01876	0.051984	0.005711	120	120	120	0	0	1	-360	360	4.1457	-4.6575	-4.1402	3.9713	0.0000	0.0000	0.0000	0.0000;
	388	284	0.017107	0.046686	0.005089	120	120	120	0	0	1	-360	360	11.9279	-2.0572	-11.9077	1.4875	0.0000	0.0000	0.0000	0.0000;
	388	347	0.003388	0.010174	0.001229	120	120	120	0	0	1	-360	360	19.5215	3.8182	-19.5105	-3.9363	0.0000	0.0000	0.0000	0.0000;
	230	571	0.001322	0.004298	0.00045	11	11	11	0	0	1	-360	360	3.2690	5.9500	-3.2685	-6.0035	0.0000	0.0000	0.0000	0.0000;
	511	310	0.002562	0.008256	0.00084	120	120	120	0	0	1	-360	360	-26.7509	-7.3500	26.7669	7.2981	0.0000	0.0000	0.0000	0.0000;
	329	319	0.007686	0.024711	0.002611	120	120	120	0	0	1	-360	360	-16.6851	-6.1538	16.7048	5.8973	0.0000	0.0000	0.0000	0.0000;
	511	319	0.002562	0.008182	0.000801	120	120	120	0	0	1	-360	360	26.7509	7.3500	-26.7348	-7.3973	0.0000	0.0000	0.0000	0.0000;
	426	347	0.004793	0.014463	0.00175	120	120	120	0	0	1	-360	360	-7.8661	0.2164	7.8685	-0.4237	0.0000	0.0000	0.0000	0.0000;
	466	389	0.007851	0.025372	0.002669	120	120	120	0	0	1	-360	360	-9.0930	2.4303	9.0987	-2.7416	0.0000	0.0000	0.0000	0.0000;
	466	321	0.009091	0.030579	0.003151	120	120	120	0	0	1	-360	360	0.7490	-5.5503	-0.7468	5.1680	0.0000	0.0000	0.0000	0.0000;
	388	318	0.01281	0.041157	0.004339	120	120	120	0	0	1	-360	360	11.3235	-3.2631	-11.3092	2.7759	0.0000	0.0000	0.0000	0.0000;
	302	388	0.006124	0.019752	0.002081	120	120	120	0	0	1	-360	360	-8.6897	-3.2217	8.6939	2.9798	0.0000	0.0000	0.0000	0.0000;
	292	388	0.011983	0.038603	0.004061	120	120	120	0	0	1	-360	360	-4.6993	-1.8342	4.7017	1.3433	0.0000	0.0000	0.0000	0.0000;
	292	302	0.00562	0.018099	0.001909	120	120	120	0	0	1	-360	360	-0.5397	-0.1258	0.5397	-0.1083	0.0000	0.0000	0.0000	0.0000;
	571	386	0.023802	0.072149	0.00855	120	120	120	0	0	1	-360	360	26.5968	-3.4630	-26.4577	2.8403	0.0000	0.0000	0.0000	0.0000;
	510	311	0.003876	0.012562	0.001319	120	120	120	0	0	1	-360	360	-2.4256	-6.0706	2.4269	5.9114	0.0000	0.0000	0.0000	0.0000;
	570	432	0.004959	0.014959	0.001769	120	120	120	0	0	1	-360	360	-34.4292	11.7663	34.4829	-11.8210	0.0000	0.0000	0.0000	0.0000;
	298	571	0.005041	0.015207	0.00181	120	120	120	0	0	1	-360	360	-9.8000	-3.6700	9.8045	3.4619	0.0000	0.0000	0.0000	0.0000;
	483	403	0.03	0.088678	0.00884	120	120	120	0	0	1	-360	360	-75.8140	9.2990	77.3189	-5.8949	0.0000	0.0000	0.0000	0.0000;
	428	258	0.025207	0.082231	0.00841	120	120	120	0	0	1	-360	360	-22.7516	-5.4877	22.8730	4.9278	0.0000	0.0000	0.0000	0.0000;
	440	428	0.001488	0.004711	0.000489	120	120	120	0	0	1	-360	360	-16.4417	-4.7306	16.4456	4.6877	0.0000	0.0000	0.0000	0.0000;
	412	404	0.00843	0.021397	0.00218	120	120	120	0	0	1	-360	360	11.3592	-1.3699	-11.3493	1.1507	0.0000	0.0000	0.0000	0.0000;
	479	462	0.019504	0.035446	0.003531	90	90	90	0	0	1	-360	360	-14.5319	-0.4667	14.5671	0.1167	0.0000	0.0000	0.0000	0.0000;
	582	219	0.014876	0.026124	0.002461	90	90	90	0	0	1	-360	360	-0.6924	-4.1023	0.6944	3.8193	0.0000	0.0000	0.0000	0.0000;
	582	356	0.022636	0.037686	0.003969	90	90	90	0	0	1	-360	360	-9.4946	2.5023	9.5136	-2.9330	0.0000	0.0000	0.0000	0.0000;
	569	328	0.014132	0.046529	0.0047	120	120	120	0	0	1	-360	360	-3.3852	-3.5439	3.3878	2.9788	0.0000	0.0000	0.0000	0.0000;
	283	234	0.004405	0.030388	0.003417	183	183	183	0	0	1	-360	360	-66.5878	8.7890	66.7621	-7.9768	0.0000	0.0000	0.0000	0.0000;
	572	464	0.016529	0.053876	0.005501	91	91	91	0	0	1	-360	360	6.2387	3.5946	-6.2313	-4.2356	0.0000	0.0000	0.0000	0.0000;
	569	446	0.017851	0.032727	0.003461	90	90	90	0	0	1	-360	360	9.6994	-7.3926	-9.6780	7.0099	0.0000	0.0000	0.0000	0.0000;
	446	416	0.030331	0.073314	0.00825	120	120	120	0	0	1	-360	360	4.3420	-8.5099	-4.3214	7.5499	0.0000	0.0000	0.0000	0.0000;
	394	416	0.00719	0.012562	0.0012	90	90	90	0	0	1	-360	360	-4.3660	-1.3000	4.3672	1.1547	0.0000	0.0000	0.0000	0.0000;
	569	296	0.017107	0.043636	0.004441	120	120	120	0	0	1	-360	360	-23.1199	4.0890	23.1976	-4.4326	0.0000	0.0000	0.0000	0.0000;
	444	296	0.03124	0.079422	0.00808	120	120	120	0	0	1	-360	360	27.2682	-2.9436	-27.0786	2.4326	0.0000	0.0000	0.0000	0.0000;
	486	453	0.01	0.026281	0.002669	120	120	120	0	0	1	-360	360	32.4256	-2.8942	-32.3411	2.7819	0.0000	0.0000	0.0000	0.0000;
	453	444	0.028017	0.061818	0.00747	120	120	120	0	0	1	-360	360	31.3711	-2.8819	-31.1492	2.4436	0.0000	0.0000	0.0000	0.0000;
	372	285	0.004132	0.013471	0.001389	133	133	133	0	0	1	-360	360	-14.1096	0.1871	14.1164	-0.3342	0.0000	0.0000	0.0000	0.0000;
	376	483	0.02595	0.085124	0.008601	133	133	133	0	0	1	-360	360	-64.6410	12.7812	65.6228	-10.5568	0.0000	0.0000	0.0000	0.0000;
	454	372	0.040413	0.132636	0.01339	133	133	133	0	0	1	-360	360	-11.1570	-0.8000	11.1986	-0.6871	0.0000	0.0000	0.0000	0.0000;
	498	455	0.002562	0.00843	0.000871	133	133	133	0	0	1	-360	360	6.7920	0.9027	-6.7910	-1.0000	0.0000	0.0000	0.0000	0.0000;
	277	464	0.014132	0.037273	0.004	90	90	90	0	0	1	-360	360	5.4152	-3.3060	-5.4107	2.8356	0.0000	0.0000	0.0000	0.0000;
	441	482	0.007107	0.012479	0.001191	90	90	90	0	0	1	-360	360	-13.1063	-1.0990	13.1175	0.9870	0.0000	0.0000	0.0000	0.0000;
	484	441	0.005793	0.011744	0.00114	90	90	90	0	0	1	-360	360	-10.6753	-0.6127	10.6813	0.4990	0.0000	0.0000	0.0000	0.0000;
	488	483	0.006446	0.016124	0.001389	90	90	90	0	0	1	-360	360	-6.7927	-0.9130	6.7953	0.7578	0.0000	0.0000	0.0000	0.0000;
	489	485	0.00405	0.008347	0.000779	69	69	69	0	0	1	-360	360	6.7926	0.9127	-6.7910	-1.0000	0.0000	0.0000	0.0000	0.0000;
	461	325	0.054554	0.094711	0.00914	90	90	90	0	0	1	-360	360	19.7436	0.1624	-19.5625	-0.9121	0.0000	0.0000	0.0000	0.0000;
	430	373	0.060579	0.106033	0.01006	90	90	90	0	0	1	-360	360	-23.0345	-2.5518	23.3068	1.8163	0.0000	0.0000	0.0000	0.0000;
	440	436	0.002727	0.007851	0.000789	120	120	120	0	0	1	-360	360	15.5307	5.9306	-15.5240	-6.0000	0.0000	0.0000	0.0000	0.0000;
	482	224	0.011983	0.038934	0.00402	120	120	120	0	0	1	-360	360	-16.0835	-0.4870	16.1115	0.1325	0.0000	0.0000	0.0000	0.0000;
	470	404	0.010744	0.034793	0.003589	114	114	114	0	0	1	-360	360	-20.2134	-0.6562	20.2528	0.3831	0.0000	0.0000	0.0000	0.0000;
	470	224	0.009826	0.031983	0.003301	114	114	114	0	0	1	-360	360	17.7884	0.2562	-17.7605	-0.5325	0.0000	0.0000	0.0000	0.0000;
	508	487	0.012984	0.042149	0.004361	133	133	133	0	0	1	-360	360	-37.9701	-3.3169	38.1227	3.2716	0.0000	0.0000	0.0000	0.0000;
	486	243	0.003141	0.009421	0.000961	120	120	120	0	0	1	-360	360	58.7864	5.9187	-58.6990	-5.7767	0.0000	0.0000	0.0000	0.0000;
	438	391	0.003554	0.024207	0.00271	183	183	183	0	0	1	-360	360	17.5361	-9.5936	-17.5240	9.3610	0.0000	0.0000	0.0000	0.0000;
	390	232	0.013719	0.044463	0.00461	120	120	120	0	0	1	-360	360	14.5897	1.9975	-14.5643	-2.4586	0.0000	0.0000	0.0000	0.0000;
	439	264	0.001636	0.011116	0.001341	183	183	183	0	0	1	-360	360	38.5660	9.0553	-38.5438	-9.0604	0.0000	0.0000	0.0000	0.0000;
	391	213	0.019669	0.063802	0.006599	120	120	120	0	0	1	-360	360	35.6674	6.0489	-35.4456	-6.0909	0.0000	0.0000	0.0000	0.0000;
	233	376	0.003554	0.01157	0.00121	133	133	133	0	0	1	-360	360	-22.6201	0.5415	22.6360	-0.6292	0.0000	0.0000	0.0000	0.0000;
	400	360	0.028678	0.093141	0.009619	120	120	120	0	0	1	-360	360	-7.5174	0.8301	7.5321	-1.8816	0.0000	0.0000	0.0000	0.0000;
	232	214	0.00686	0.022149	0.002289	120	120	120	0	0	1	-360	360	10.1983	1.4586	-10.1921	-1.7073	0.0000	0.0000	0.0000	0.0000;
	412	213	0.022314	0.072479	0.0075	120	120	120	0	0	1	-360	360	-32.7042	-5.6301	32.9226	5.4909	0.0000	0.0000	0.0000	0.0000;
	577	430	0.014711	0.047686	0.004929	120	120	120	0	0	1	-360	360	-16.6933	-2.3229	16.7285	1.8528	0.0000	0.0000	0.0000	0.0000;
	577	445	0.019504	0.063314	0.006539	120	120	120	0	0	1	-360	360	11.3573	0.3229	-11.3359	-1.0245	0.0000	0.0000	0.0000	0.0000;
	574	214	0.020579	0.066942	0.006909	120	120	120	0	0	1	-360	360	-5.3360	-1.2000	5.3411	0.4073	0.0000	0.0000	0.0000	0.0000;
	356	272	0.008512	0.027934	0.002851	120	120	120	0	0	1	-360	360	-17.2756	1.1330	17.2975	-1.3938	0.0000	0.0000	0.0000	0.0000;
	406	403	0.004876	0.015868	0.001641	120	120	120	0	0	1	-360	360	8.0323	-9.3446	-8.0262	9.1682	0.0000	0.0000	0.0000	0.0000;
	461	228	0.00843	0.027686	0.00279	120	120	120	0	0	1	-360	360	19.4821	3.0537	-19.4542	-3.2892	0.0000	0.0000	0.0000	0.0000;
	406	390	0.035289	0.137017	0.013741	120	120	120	0	0	1	-360	360	-14.8233	8.3446	14.9130	-9.6292	0.0000	0.0000	0.0000	0.0000;
	301	484	0.024298	0.078934	0.008151	120	120	120	0	0	1	-360	360	-3.8810	-0.5000	3.8843	-0.3873	0.0000	0.0000	0.0000	0.0000;
	390	265	0.001818	0.012727	0.001421	183	183	183	0	0	1	-360	360	15.0835	83.7252	-14.9719	-83.1101	0.0000	0.0000	0.0000	0.0000;
	391	264	0.001744	0.012066	0.001341	183	183	183	0	0	1	-360	360	3.1870	27.8659	-3.1752	-27.9396	0.0000	0.0000	0.0000	0.0000;
	234	245	0.007884	0.053149	0.005885	183	183	183	0	0	1	-360	360	-83.2551	-6.0232	83.7359	8.5864	0.0000	0.0000	0.0000	0.0000;
	438	245	0.001074	0.00719	0.000944	229	229	229	0	0	1	-360	360	-59.4993	-0.4740	59.5320	0.5835	0.0000	0.0000	0.0000	0.0000;
	282	265	0.002562	0.022727	0.001989	183	183	183	0	0	1	-360	360	28.7476	-42.8114	-28.6881	43.1101	0.0000	0.0000	0.0000	0.0000;
	391	257	0.019504	0.063141	0.006539	133	133	133	0	0	1	-360	360	27.8589	5.3151	-27.7235	-5.6326	0.0000	0.0000	0.0000	0.0000;
	228	498	0.035702	0.11719	0.011841	120	120	120	0	0	1	-360	360	12.6632	1.2892	-12.6130	-2.5027	0.0000	0.0000	0.0000	0.0000;
	222	277	0.044297	0.093471	0.00876	90	90	90	0	0	1	-360	360	-5.8060	-1.5000	5.8188	0.4742	0.0000	0.0000	0.0000	0.0000;
	522	487	0.018934	0.062479	0.019319	133	133	133	0	0	1	-360	360	-58.8281	-6.6751	59.3716	6.0892	0.0000	0.0000	0.0000	0.0000;
	332	325	0.010992	0.023223	0.00218	90	90	90	0	0	1	-360	360	-6.7910	-2.0000	6.7957	1.7589	0.0000	0.0000	0.0000	0.0000;
	569	572	0.012149	0.039339	0.004051	120	120	120	0	0	1	-360	360	11.1037	3.8475	-11.0897	-4.2946	0.0000	0.0000	0.0000	0.0000;
	233	360	0.029091	0.09438	0.00976	120	120	120	0	0	1	-360	360	13.8881	-1.5415	-13.8391	0.5816	0.0000	0.0000	0.0000	0.0000;
	219	479	0.033876	0.059339	0.00582	90	90	90	0	0	1	-360	360	-7.2414	0.5807	7.2569	-1.2333	0.0000	0.0000	0.0000	0.0000;
	476	400	0.019826	0.06438	0.00665	120	120	120	0	0	1	-360	360	-4.4088	0.7826	4.4124	-1.5301	0.0000	0.0000	0.0000	0.0000;
	568	522	0.024215	0.079339	0.008027	133	133	133	0	0	1	-360	360	-19.7259	1.5528	19.8046	-2.2686	0.0000	0.0000	0.0000	0.0000;
	568	277	0.022231	0.07281	0.00735	133	133	133	0	0	1	-360	360	16.5239	-2.3528	-16.4730	1.6318	0.0000	0.0000	0.0000	0.0000;
	398	409	0.008347	0.026198	0.002921	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.3424	0.0000	0.0000	0.0000	0.0000;
	396	392	0.007603	0.025446	0.00249	133	133	133	0	0	1	-360	360	22.1763	0.7741	-22.1446	-0.9618	0.0000	0.0000	0.0000	0.0000;
	397	362	0.011818	0.03	0.003049	120	120	120	0	0	1	-360	360	-1.1911	2.6437	1.1920	-3.0000	0.0000	0.0000	0.0000	0.0000;
	411	363	0.016198	0.05405	0.005271	133	133	133	0	0	1	-360	360	-1.1899	3.3899	1.1920	-4.0000	0.0000	0.0000	0.0000	0.0000;
	409	267	0.019917	0.06438	0.00667	133	133	133	0	0	1	-360	360	18.4170	-2.2676	-18.3588	1.6757	0.0000	0.0000	0.0000	0.0000;
	559	294	0.010661	0.018678	0.001861	133	133	133	0	0	1	-360	360	7.0885	-1.6848	-7.0837	1.4763	0.0000	0.0000	0.0000	0.0000;
	559	267	0.015868	0.053876	0.005329	133	133	133	0	0	1	-360	360	-10.0973	1.8031	10.1118	-2.3757	0.0000	0.0000	0.0000	0.0000;
	559	457	0.010744	0.034959	0.003611	133	133	133	0	0	1	-360	360	3.0088	-0.1183	-3.0080	-0.3000	0.0000	0.0000	0.0000	0.0000;
	312	295	0.027016	0.087438	0.009051	133	133	133	0	0	1	-360	360	19.9109	-2.2781	-19.8223	1.4662	0.0000	0.0000	0.0000	0.0000;
	263	237	0.019091	0.062727	0.00634	133	133	133	0	0	1	-360	360	-35.8598	4.7072	36.0773	-4.7253	0.0000	0.0000	0.0000	0.0000;
	375	263	0.019752	0.064959	0.006561	133	133	133	0	0	1	-360	360	-34.8687	5.1617	35.0838	-5.2072	0.0000	0.0000	0.0000	0.0000;
	465	410	0.025041	0.082231	0.00831	133	133	133	0	0	1	-360	360	-50.9788	4.0741	51.5436	-3.1927	0.0000	0.0000	0.0000	0.0000;
	225	465	0.007603	0.022984	0.00272	133	133	133	0	0	1	-360	360	-45.9872	4.7840	46.1278	-4.6741	0.0000	0.0000	0.0000	0.0000;
	397	251	0.023141	0.074132	0.00785	133	133	133	0	0	1	-360	360	3.4303	-0.9254	-3.4280	0.0093	0.0000	0.0000	0.0000	0.0000;
	431	368	0.038843	0.127603	0.012879	133	133	133	0	0	1	-360	360	20.6395	0.5849	-20.4989	-1.6336	0.0000	0.0000	0.0000	0.0000;
	469	392	0.018347	0.060248	0.006079	133	133	133	0	0	1	-360	360	-19.9481	-1.2700	20.0106	0.7618	0.0000	0.0000	0.0000	0.0000;
	469	415	0.030331	0.099669	0.01006	133	133	133	0	0	1	-360	360	18.4931	0.9700	-18.4038	-1.8459	0.0000	0.0000	0.0000	0.0000;
	458	295	0.009752	0.029504	0.00355	133	133	133	0	0	1	-360	360	-3.5910	-0.8000	3.5921	0.3738	0.0000	0.0000	0.0000	0.0000;
	581	294	0.036777	0.063802	0.006229	90	90	90	0	0	1	-360	360	-4.4205	-0.4378	4.4267	-0.2763	0.0000	0.0000	0.0000	0.0000;
	480	240	0.021397	0.07157	0.006989	133	133	133	0	0	1	-360	360	-19.3289	3.6621	19.4031	-4.2006	0.0000	0.0000	0.0000	0.0000;
	414	395	0.001983	0.006198	0.00069	133	133	133	0	0	1	-360	360	-15.1221	-2.6902	15.1260	2.6216	0.0000	0.0000	0.0000	0.0000;
	429	395	0.00562	0.017107	0.001801	90	90	90	0	0	1	-360	360	-26.1017	2.0261	26.1346	-2.1376	0.0000	0.0000	0.0000	0.0000;
	268	397	0.003058	0.01	0.001031	133	133	133	0	0	1	-360	360	-5.7717	0.2299	5.7725	-0.3484	0.0000	0.0000	0.0000	0.0000;
	396	365	0.009587	0.030992	0.003199	133	133	133	0	0	1	-360	360	-2.3832	-2.3757	2.3840	2.0000	0.0000	0.0000	0.0000	0.0000;
	410	364	0.010661	0.034628	0.003579	133	133	133	0	0	1	-360	360	-3.3100	-0.4197	3.3110	-0.0000	0.0000	0.0000	0.0000	0.0000;
	407	357	0.004298	0.012984	0.001571	133	133	133	0	0	1	-360	360	4.3496	1.4960	-4.3488	-1.6779	0.0000	0.0000	0.0000	0.0000;
	367	237	0.091653	0.159008	0.01657	90	90	90	0	0	1	-360	360	15.9988	-10.4872	-15.7242	9.0443	0.0000	0.0000	0.0000	0.0000;
	578	240	0.03124	0.104207	0.010181	133	133	133	0	0	1	-360	360	37.8670	-5.8854	-37.4657	6.0712	0.0000	0.0000	0.0000	0.0000;
	429	409	0.004793	0.016033	0.001561	133	133	133	0	0	1	-360	360	21.8327	-2.4261	-21.8130	2.3089	0.0000	0.0000	0.0000	0.0000;
	368	235	0.009174	0.03	0.00303	133	133	133	0	0	1	-360	360	7.9169	1.9336	-7.9116	-2.2683	0.0000	0.0000	0.0000	0.0000;
	235	237	0.006777	0.022149	0.002241	133	133	133	0	0	1	-360	360	3.9336	1.7683	-3.9325	-2.0246	0.0000	0.0000	0.0000	0.0000;
	295	289	0.016612	0.042984	0.004291	120	120	120	0	0	1	-360	360	10.0212	-2.7400	-10.0066	2.2588	0.0000	0.0000	0.0000	0.0000;
	411	357	0.011322	0.037769	0.003691	133	133	133	0	0	1	-360	360	3.0252	-1.5072	-3.0242	1.0779	0.0000	0.0000	0.0000	0.0000;
	410	397	0.012893	0.041157	0.004431	133	133	133	0	0	1	-360	360	11.2278	1.2922	-11.2138	-1.7699	0.0000	0.0000	0.0000	0.0000;
	431	410	0.043967	0.145289	0.014469	133	133	133	0	0	1	-360	360	-22.2375	6.6151	22.4421	-7.6485	0.0000	0.0000	0.0000	0.0000;
	411	395	0.024554	0.074298	0.00772	120	120	120	0	0	1	-360	360	-1.8353	-1.8826	1.8365	0.9797	0.0000	0.0000	0.0000	0.0000;
	480	333	0.021653	0.072397	0.007059	133	133	133	0	0	1	-360	360	17.1949	-3.9621	-17.1355	3.3678	0.0000	0.0000	0.0000	0.0000;
	533	268	0.04405	0.133719	0.015851	133	133	133	0	0	1	-360	360	-0.4355	-0.5353	0.4357	-1.3299	0.0000	0.0000	0.0000	0.0000;
	346	375	0.018256	0.03157	0.003071	90	90	90	0	0	1	-360	360	-29.2927	5.5587	29.4357	-5.6617	0.0000	0.0000	0.0000	0.0000;
	475	251	0.020496	0.066942	0.006839	133	133	133	0	0	1	-360	360	-0.6139	-0.2947	0.6140	-0.5093	0.0000	0.0000	0.0000	0.0000;
	578	225	0.033388	0.10124	0.011991	133	133	133	0	0	1	-360	360	-43.0090	5.2854	43.5622	-4.9840	0.0000	0.0000	0.0000	0.0000;
	414	407	0.002727	0.008182	0.00099	133	133	133	0	0	1	-360	360	12.0181	2.1902	-12.0146	-2.2960	0.0000	0.0000	0.0000	0.0000;
	217	215	0.006942	0.022562	0.002311	133	133	133	0	0	1	-360	360	-15.4640	1.0763	15.4774	-1.3217	0.0000	0.0000	0.0000	0.0000;
	227	366	0.059917	0.116281	0.012981	90	90	90	0	0	1	-360	360	-20.6206	-2.7549	20.8305	1.5534	0.0000	0.0000	0.0000	0.0000;
	227	209	0.100413	0.177364	0.01665	90	90	90	0	0	1	-360	360	9.9446	4.1121	-9.8419	-5.9380	0.0000	0.0000	0.0000	0.0000;
	269	227	0.051984	0.09	0.008891	90	90	90	0	0	1	-360	360	-0.0032	0.7676	0.0040	-1.8561	0.0000	0.0000	0.0000	0.0000;
	278	218	0.028934	0.08719	0.0105	133	133	133	0	0	1	-360	360	-22.0185	-2.9953	22.1337	2.0409	0.0000	0.0000	0.0000	0.0000;
	513	278	0.030331	0.09124	0.010989	133	133	133	0	0	1	-360	360	-19.9758	-4.0291	20.0785	2.9953	0.0000	0.0000	0.0000	0.0000;
	256	255	0.006612	0.019917	0.002401	133	133	133	0	0	1	-360	360	-15.8101	8.2371	15.8276	-8.4755	0.0000	0.0000	0.0000	0.0000;
	567	324	0.026942	0.081901	0.009699	133	133	133	0	0	1	-360	360	-5.6912	-0.8595	5.6986	-0.2771	0.0000	0.0000	0.0000	0.0000;
	370	320	0.02	0.033802	0.003681	90	90	90	0	0	1	-360	360	-25.3491	12.8099	25.4853	-13.0193	0.0000	0.0000	0.0000	0.0000;
	226	286	0.027016	0.082149	0.009731	133	133	133	0	0	1	-360	360	-5.1186	7.6126	5.1395	-8.7138	0.0000	0.0000	0.0000	0.0000;
	374	247	0.049917	0.089669	0.008981	90	90	90	0	0	1	-360	360	-35.0088	2.0912	35.5371	-2.2021	0.0000	0.0000	0.0000	0.0000;
	474	248	0.007851	0.023876	0.002841	133	133	133	0	0	1	-360	360	-29.4127	-3.6393	29.4706	3.4767	0.0000	0.0000	0.0000	0.0000;
	471	210	0.040174	0.117107	0.01446	133	133	133	0	0	1	-360	360	-17.9542	-4.6525	18.0732	3.3358	0.0000	0.0000	0.0000	0.0000;
	279	324	0.003967	0.012149	0.001379	133	133	133	0	0	1	-360	360	12.1516	4.3639	-12.1460	-4.5121	0.0000	0.0000	0.0000	0.0000;
	249	247	0.022066	0.042727	0.00416	90	90	90	0	0	1	-360	360	42.6599	-0.5629	-42.3291	0.7021	0.0000	0.0000	0.0000	0.0000;
	256	249	0.037364	0.063141	0.00687	90	90	90	0	0	1	-360	360	12.4141	-8.7371	-12.3453	8.0197	0.0000	0.0000	0.0000	0.0000;
	218	215	0.002636	0.008512	0.000881	133	133	133	0	0	1	-360	360	-66.2279	6.0041	66.3213	-5.8126	0.0000	0.0000	0.0000	0.0000;
	567	553	0.039504	0.069091	0.006561	90	90	90	0	0	1	-360	360	-3.5258	-0.6405	3.5299	-0.1359	0.0000	0.0000	0.0000	0.0000;
	553	299	0.035372	0.103314	0.009169	120	120	120	0	0	1	-360	360	-28.1230	-3.9170	28.3603	3.5006	0.0000	0.0000	0.0000	0.0000;
	471	437	0.019752	0.037364	0.00401	90	90	90	0	0	1	-360	360	4.3712	2.6525	-4.3665	-3.0992	0.0000	0.0000	0.0000	0.0000;
	552	248	0.031653	0.095372	0.01148	133	133	133	0	0	1	-360	360	-46.0202	-3.1839	46.6001	3.5791	0.0000	0.0000	0.0000	0.0000;
	405	369	0.040661	0.070661	0.00682	90	90	90	0	0	1	-360	360	29.6883	-7.4210	-29.3676	7.1781	0.0000	0.0000	0.0000	0.0000;
	474	210	0.041397	0.125702	0.01489	133	133	133	0	0	1	-360	360	22.6217	2.6393	-22.4392	-3.8358	0.0000	0.0000	0.0000	0.0000;
	384	350	0.015703	0.047364	0.005699	133	133	133	0	0	1	-360	360	-36.4743	7.3297	36.6535	-7.4846	0.0000	0.0000	0.0000	0.0000;
	287	218	0.028017	0.084463	0.010159	133	133	133	0	0	1	-360	360	-43.7377	6.4178	44.1831	-6.3359	0.0000	0.0000	0.0000	0.0000;
	260	250	0.026777	0.080496	0.009699	133	133	133	0	0	1	-360	360	-9.2257	0.0343	9.2460	-1.0678	0.0000	0.0000	0.0000	0.0000;
	459	209	0.038603	0.083636	0.00735	90	90	90	0	0	1	-360	360	-4.0079	-5.2780	4.0209	4.4380	0.0000	0.0000	0.0000	0.0000;
	270	250	0.019091	0.061983	0.00644	133	133	133	0	0	1	-360	360	12.1821	-1.2154	-12.1570	0.5678	0.0000	0.0000	0.0000	0.0000;
	374	270	0.067686	0.119008	0.01104	90	90	90	0	0	1	-360	360	28.7028	-3.5912	-28.2189	3.1732	0.0000	0.0000	0.0000	0.0000;
	450	270	0.061066	0.101653	0.011021	90	90	90	0	0	1	-360	360	-7.2760	-0.5000	7.3047	-0.6972	0.0000	0.0000	0.0000	0.0000;
	324	320	0.006124	0.012397	0.001169	90	90	90	0	0	1	-360	360	36.2300	-10.5118	-36.1573	10.5193	0.0000	0.0000	0.0000	0.0000;
	505	260	0.050992	0.154793	0.018329	133	133	133	0	0	1	-360	360	-4.3660	-1.0000	4.3747	-1.0343	0.0000	0.0000	0.0000	0.0000;
	405	286	0.03124	0.094959	0.011251	133	133	133	0	0	1	-360	360	-36.9643	5.9210	37.3374	-6.1211	0.0000	0.0000	0.0000	0.0000;
	553	238	0.029174	0.07438	0.007739	120	120	120	0	0	1	-360	360	12.9501	2.0529	-12.9077	-2.8661	0.0000	0.0000	0.0000	0.0000;
	350	287	0.021653	0.040083	0.00386	90	90	90	0	0	1	-360	360	-40.0495	6.4846	40.3417	-6.4178	0.0000	0.0000	0.0000	0.0000;
	254	552	0.018678	0.056777	0.00673	133	133	133	0	0	1	-360	360	-41.3737	-2.1055	41.6542	2.1839	0.0000	0.0000	0.0000	0.0000;
	255	384	0.026777	0.080578	0.009699	133	133	133	0	0	1	-360	360	-34.2606	7.4755	34.5343	-7.8297	0.0000	0.0000	0.0000	0.0000;
	270	437	0.004298	0.013876	0.00144	133	133	133	0	0	1	-360	360	2.9111	-2.7606	-2.9105	2.5992	0.0000	0.0000	0.0000	0.0000;
	338	215	0.039421	0.120331	0.01413	133	133	133	0	0	1	-360	360	-13.1303	-0.5816	13.1851	-1.0114	0.0000	0.0000	0.0000	0.0000;
	492	215	0.008182	0.025446	0.00289	133	133	133	0	0	1	-360	360	-5.8210	-0.5000	5.8232	0.1457	0.0000	0.0000	0.0000	0.0000;
	313	269	0.043388	0.07157	0.007739	90	90	90	0	0	1	-360	360	7.7802	1.3515	-7.7578	-2.2676	0.0000	0.0000	0.0000	0.0000;
	313	338	0.018256	0.055372	0.006561	133	133	133	0	0	1	-360	360	-9.7202	-1.3515	9.7343	0.5816	0.0000	0.0000	0.0000	0.0000;
	366	299	0.028678	0.088182	0.007831	120	120	120	0	0	1	-360	360	32.3132	6.8016	-32.0623	-7.0006	0.0000	0.0000	0.0000	0.0000;
	366	218	0.025446	0.080992	0.00735	120	120	120	0	0	1	-360	360	4.9459	1.8086	-4.9399	-2.7092	0.0000	0.0000	0.0000	0.0000;
	216	366	0.018182	0.06595	0.007066	133	133	133	0	0	1	-360	360	-3.9421	-3.4890	3.9457	2.6176	0.0000	0.0000	0.0000	0.0000;
	249	226	0.027934	0.084959	0.01006	133	133	133	0	0	1	-360	360	-2.1933	6.9403	2.2076	-8.1126	0.0000	0.0000	0.0000	0.0000;
	513	279	0.023636	0.071488	0.008511	133	133	133	0	0	1	-360	360	17.5508	3.5291	-17.4876	-4.3639	0.0000	0.0000	0.0000	0.0000;
	216	217	0.002231	0.007521	0.000755	133	133	133	0	0	1	-360	360	-10.6109	1.9890	10.6130	-2.0763	0.0000	0.0000	0.0000	0.0000;
	354	351	8e-06	8.3e-05	2.4e-05	137	137	137	0	0	1	-360	360	-61.1746	-16.5978	61.1749	16.5977	0.0000	0.0000	0.0000	0.0000;
	600	835	0.036281	0.094207	0.00974	137	137	137	0	0	1	-360	360	-6.5091	-3.2475	6.5247	2.1595	0.0000	0.0000	0.0000	0.0000;
	790	622	0.030413	0.098934	0.01014	137	137	137	0	0	1	-360	360	-43.7103	2.6332	44.2252	-2.1200	0.0000	0.0000	0.0000	0.0000;
	760	586	0.026777	0.086529	0.00885	137	137	137	0	0	1	-360	360	-15.7836	-3.0452	15.8421	2.1927	0.0000	0.0000	0.0000	0.0000;
	831	601	0.022562	0.072893	0.007461	137	137	137	0	0	1	-360	360	-4.1753	-5.8967	4.1846	5.0686	0.0000	0.0000	0.0000	0.0000;
	719	594	0.086777	0.149752	0.01423	76	76	76	0	0	1	-360	360	4.8769	-0.1656	-4.8588	-1.4478	0.0000	0.0000	0.0000	0.0000;
	779	726	0.072066	0.138099	0.013211	109	109	109	0	0	1	-360	360	-7.8730	-7.6757	7.9418	6.2671	0.0000	0.0000	0.0000	0.0000;
	733	727	0.05	0.109091	0.010699	109	109	109	0	0	1	-360	360	-13.9178	-5.4611	14.0117	4.4157	0.0000	0.0000	0.0000	0.0000;
	628	625	0.01124	0.027769	0.002759	109	109	109	0	0	1	-360	360	19.5749	-2.8273	-19.5366	2.6059	0.0000	0.0000	0.0000	0.0000;
	727	725	0.016364	0.053058	0.005421	137	137	137	0	0	1	-360	360	-2.8025	8.6380	2.8147	-9.2363	0.0000	0.0000	0.0000	0.0000;
	720	613	0.041157	0.132893	0.013591	137	137	137	0	0	1	-360	360	7.1324	0.9213	-7.1137	-2.4580	0.0000	0.0000	0.0000	0.0000;
	732	726	0.023058	0.07157	0.00818	168	168	168	0	0	1	-360	360	-17.0274	-2.6564	17.0855	1.8748	0.0000	0.0000	0.0000	0.0000;
	732	727	0.023058	0.07157	0.00818	168	168	168	0	0	1	-360	360	-17.1176	-2.3436	17.1760	1.5634	0.0000	0.0000	0.0000	0.0000;
	747	676	0.020174	0.065289	0.006701	137	137	137	0	0	1	-360	360	-28.2777	-2.1984	28.4267	1.9473	0.0000	0.0000	0.0000	0.0000;
	792	599	0.048934	0.127769	0.013211	137	137	137	0	0	1	-360	360	2.1143	-3.3390	-2.1091	1.9357	0.0000	0.0000	0.0000	0.0000;
	620	590	0.031983	0.103471	0.01058	137	137	137	0	0	1	-360	360	-21.7044	-4.2638	21.8459	3.5506	0.0000	0.0000	0.0000	0.0000;
	694	819	0.039174	0.126686	0.012959	137	137	137	0	0	1	-360	360	-12.2752	-1.4024	12.3249	0.0101	0.0000	0.0000	0.0000	0.0000;
	789	620	0.038512	0.124628	0.012751	137	137	137	0	0	1	-360	360	-17.4060	-4.2793	17.5194	3.2638	0.0000	0.0000	0.0000	0.0000;
	830	637	0.061397	0.198603	0.020321	137	137	137	0	0	1	-360	360	4.7746	3.1874	-4.7525	-5.4541	0.0000	0.0000	0.0000	0.0000;
	742	741	0.003719	0.008843	0.00067	137	137	137	0	0	1	-360	360	-0.2276	-3.3798	0.2279	3.3034	0.0000	0.0000	0.0000	0.0000;
	742	617	0.04843	0.08438	0.00809	91	91	91	0	0	1	-360	360	-9.4028	5.6331	9.4556	-6.4724	0.0000	0.0000	0.0000	0.0000;
	785	583	0.012066	0.038934	0.00402	137	137	137	0	0	1	-360	360	-31.3178	2.3452	31.4175	-2.5047	0.0000	0.0000	0.0000	0.0000;
	770	617	0.037603	0.065537	0.006241	109	109	109	0	0	1	-360	360	18.2119	-6.7807	-18.0906	6.2724	0.0000	0.0000	0.0000	0.0000;
	742	658	0.010752	0.028198	0.002909	109	109	109	0	0	1	-360	360	-0.3270	-2.6278	0.3276	2.2940	0.0000	0.0000	0.0000	0.0000;
	716	658	0.012703	0.032967	0.00341	109	109	109	0	0	1	-360	360	6.1928	2.8137	-6.1876	-3.1940	0.0000	0.0000	0.0000	0.0000;
	744	716	0.034851	0.07019	0.006829	109	109	109	0	0	1	-360	360	9.8601	2.3832	-9.8288	-3.1137	0.0000	0.0000	0.0000	0.0000;
	588	744	0.014207	0.046033	0.004709	137	137	137	0	0	1	-360	360	21.3573	4.8218	-21.2991	-5.1858	0.0000	0.0000	0.0000	0.0000;
	700	584	0.00562	0.009917	0.00092	76	76	76	0	0	1	-360	360	-21.0162	-3.7407	21.0376	3.6681	0.0000	0.0000	0.0000	0.0000;
	700	696	0.004463	0.007934	0.00075	46	46	46	0	0	1	-360	360	15.1782	3.2407	-15.1692	-3.3144	0.0000	0.0000	0.0000	0.0000;
	699	696	0.002562	0.008256	0.000849	137	137	137	0	0	1	-360	360	-4.4287	-2.1243	4.4292	2.0244	0.0000	0.0000	0.0000	0.0000;
	825	699	0.013058	0.021653	0.002081	109	109	109	0	0	1	-360	360	4.8901	1.1715	-4.8873	-1.4157	0.0000	0.0000	0.0000	0.0000;
	825	583	0.011744	0.020248	0.001951	109	109	109	0	0	1	-360	360	-12.9621	-1.6915	12.9788	1.4866	0.0000	0.0000	0.0000	0.0000;
	604	583	0.02562	0.08281	0.00847	137	137	137	0	0	1	-360	360	-22.9940	-6.5003	23.1168	5.8899	0.0000	0.0000	0.0000	0.0000;
	604	601	0.029339	0.094793	0.009699	137	137	137	0	0	1	-360	360	18.6430	5.9003	-18.5460	-6.7186	0.0000	0.0000	0.0000	0.0000;
	782	692	0.011322	0.049256	0.004891	137	137	137	0	0	1	-360	360	-4.7116	-7.8352	4.7191	7.2800	0.0000	0.0000	0.0000	0.0000;
	783	782	0.002397	0.007603	0.000779	137	137	137	0	0	1	-360	360	-4.7099	-7.9231	4.7116	7.8352	0.0000	0.0000	0.0000	0.0000;
	785	783	0.002983	0.009587	0.00099	137	137	137	0	0	1	-360	360	-6.8521	-5.0356	6.8539	4.9231	0.0000	0.0000	0.0000	0.0000;
	785	586	0.018843	0.060992	0.006241	137	137	137	0	0	1	-360	360	25.3909	1.2904	-25.2888	-1.7019	0.0000	0.0000	0.0000	0.0000;
	799	586	0.025124	0.081066	0.008301	137	137	137	0	0	1	-360	360	-4.2328	0.0216	4.2367	-0.9908	0.0000	0.0000	0.0000	0.0000;
	799	591	0.004132	0.013223	0.00136	137	137	137	0	0	1	-360	360	4.2328	-0.0216	-4.2322	-0.1371	0.0000	0.0000	0.0000	0.0000;
	693	679	0.023141	0.066281	0.006781	137	137	137	0	0	1	-360	360	26.9312	4.4331	-26.7874	-4.8326	0.0000	0.0000	0.0000	0.0000;
	679	591	0.007769	0.025124	0.00257	137	137	137	0	0	1	-360	360	19.5624	4.5326	-19.5359	-4.7513	0.0000	0.0000	0.0000	0.0000;
	720	591	0.003554	0.01157	0.0012	137	137	137	0	0	1	-360	360	-9.3354	-1.9213	9.3382	1.7884	0.0000	0.0000	0.0000	0.0000;
	688	692	0.010826	0.019174	0.001801	137	137	137	0	0	1	-360	360	0.7071	-8.9838	-0.6999	8.7796	0.0000	0.0000	0.0000	0.0000;
	701	688	0.004554	0.008017	0.00075	109	109	109	0	0	1	-360	360	6.6604	-8.3664	-6.6561	8.2838	0.0000	0.0000	0.0000	0.0000;
	687	686	0.00124	0.003967	0.00044	137	137	137	0	0	1	-360	360	-0.4070	-2.9993	0.4071	2.9467	0.0000	0.0000	0.0000	0.0000;
	698	686	0.003141	0.010248	0.00105	137	137	137	0	0	1	-360	360	4.2628	2.8227	-4.2621	-2.9467	0.0000	0.0000	0.0000	0.0000;
	693	682	0.033223	0.107521	0.010999	137	137	137	0	0	1	-360	360	-17.3748	4.0230	17.4641	-5.0611	0.0000	0.0000	0.0000	0.0000;
	697	680	0.013636	0.044132	0.004521	137	137	137	0	0	1	-360	360	-19.8573	2.3876	19.9030	-2.7825	0.0000	0.0000	0.0000	0.0000;
	692	689	0.013388	0.02686	0.00257	137	137	137	0	0	1	-360	360	10.8491	1.8335	-10.8356	-2.1158	0.0000	0.0000	0.0000	0.0000;
	695	689	0.004628	0.015793	0.001609	137	137	137	0	0	1	-360	360	-8.0144	-4.3983	8.0176	4.2160	0.0000	0.0000	0.0000	0.0000;
	697	695	0.012636	0.040909	0.004179	109	109	109	0	0	1	-360	360	5.2073	-3.0876	-5.2036	2.5983	0.0000	0.0000	0.0000	0.0000;
	693	678	0.019669	0.063636	0.00651	137	137	137	0	0	1	-360	360	22.9076	3.7298	-22.8192	-4.2240	0.0000	0.0000	0.0000	0.0000;
	678	649	0.028256	0.091397	0.009341	137	137	137	0	0	1	-360	360	8.1352	1.2840	-8.1187	-2.3399	0.0000	0.0000	0.0000	0.0000;
	756	649	0.021818	0.070661	0.007231	137	137	137	0	0	1	-360	360	-4.3794	-2.4301	4.3837	1.5899	0.0000	0.0000	0.0000	0.0000;
	706	598	0.058347	0.09876	0.0106	109	109	109	0	0	1	-360	360	-5.3102	-2.9554	5.3268	1.7226	0.0000	0.0000	0.0000	0.0000;
	598	597	0.005702	0.018603	0.00189	137	137	137	0	0	1	-360	360	-14.3588	-1.7226	14.3687	1.5290	0.0000	0.0000	0.0000	0.0000;
	691	597	0.033223	0.107364	0.010989	137	137	137	0	0	1	-360	360	-9.7193	1.2495	9.7466	-2.4757	0.0000	0.0000	0.0000	0.0000;
	734	692	0.063719	0.206124	0.021081	137	137	137	0	0	1	-360	360	-4.1171	-0.3085	4.1265	-2.2017	0.0000	0.0000	0.0000	0.0000;
	701	584	0.013719	0.04438	0.00454	137	137	137	0	0	1	-360	360	-16.5554	6.7383	16.5923	-7.1643	0.0000	0.0000	0.0000	0.0000;
	698	692	0.003802	0.028603	0.00273	183	183	183	0	0	1	-360	360	6.7905	-6.4540	-6.7878	6.1456	0.0000	0.0000	0.0000	0.0000;
	698	693	0.002314	0.024132	0.003729	183	183	183	0	0	1	-360	360	9.4306	-6.6748	-9.4280	6.2519	0.0000	0.0000	0.0000	0.0000;
	698	584	0.004132	0.030661	0.002931	137	137	137	0	0	1	-360	360	-25.5264	7.4602	25.5508	-7.6314	0.0000	0.0000	0.0000	0.0000;
	681	583	0.003967	0.012984	0.001331	137	137	137	0	0	1	-360	360	77.4258	3.4762	-77.2284	-2.9904	0.0000	0.0000	0.0000	0.0000;
	820	597	0.032314	0.10438	0.01068	137	137	137	0	0	1	-360	360	31.5011	-2.4843	-31.2358	2.0544	0.0000	0.0000	0.0000	0.0000;
	820	819	0.040413	0.130579	0.013361	137	137	137	0	0	1	-360	360	17.5673	-2.6835	-17.4633	1.4051	0.0000	0.0000	0.0000	0.0000;
	681	584	0.003967	0.01281	0.001309	137	137	137	0	0	1	-360	360	78.9669	2.9949	-78.7617	-2.4898	0.0000	0.0000	0.0000	0.0000;
	682	680	0.013058	0.042066	0.00431	137	137	137	0	0	1	-360	360	27.9168	-2.4285	-27.8320	2.1825	0.0000	0.0000	0.0000	0.0000;
	722	601	0.030331	0.098099	0.010041	137	137	137	0	0	1	-360	360	2.2997	1.9967	-2.2966	-3.1499	0.0000	0.0000	0.0000	0.0000;
	819	734	0.037934	0.122983	0.012579	137	137	137	0	0	1	-360	360	2.6044	-1.8152	-2.6019	0.3085	0.0000	0.0000	0.0000	0.0000;
	693	689	0.009587	0.031157	0.00318	109	109	109	0	0	1	-360	360	8.6557	2.8692	-8.6490	-3.2301	0.0000	0.0000	0.0000	0.0000;
	698	687	0.005446	0.009587	0.0009	137	137	137	0	0	1	-360	360	5.0425	2.8458	-5.0409	-2.9514	0.0000	0.0000	0.0000	0.0000;
	691	634	0.026364	0.085207	0.00871	137	137	137	0	0	1	-360	360	-12.1694	1.3012	12.2028	-2.2353	0.0000	0.0000	0.0000	0.0000;
	642	634	0.019174	0.062314	0.006369	137	137	137	0	0	1	-360	360	19.2416	-1.7320	-19.1824	1.1597	0.0000	0.0000	0.0000	0.0000;
	820	642	0.030661	0.099091	0.01014	137	137	137	0	0	1	-360	360	21.1182	-2.3902	-21.0046	1.5320	0.0000	0.0000	0.0000	0.0000;
	634	597	0.031066	0.100413	0.01029	137	137	137	0	0	1	-360	360	-0.0704	-0.1244	0.0705	-1.1078	0.0000	0.0000	0.0000	0.0000;
	742	646	0.019174	0.061983	0.00634	137	137	137	0	0	1	-360	360	2.8644	-0.3255	-2.8630	-0.4000	0.0000	0.0000	0.0000	0.0000;
	588	584	0.029174	0.080744	0.00832	137	137	137	0	0	1	-360	360	-24.9933	-4.9218	25.1528	4.3739	0.0000	0.0000	0.0000	0.0000;
	743	744	0.005207	0.016942	0.00173	137	137	137	0	0	1	-360	360	-8.4605	-2.8929	8.4640	2.7026	0.0000	0.0000	0.0000	0.0000;
	722	743	0.011066	0.035793	0.003659	137	137	137	0	0	1	-360	360	-7.9027	-3.1967	7.9095	2.7929	0.0000	0.0000	0.0000	0.0000;
	626	692	0.020331	0.06562	0.006711	137	137	137	0	0	1	-360	360	-4.8650	-1.8000	4.8693	1.0060	0.0000	0.0000	0.0000	0.0000;
	600	741	0.004959	0.013388	0.001379	137	137	137	0	0	1	-360	360	3.9751	3.2475	-3.9739	-3.4034	0.0000	0.0000	0.0000	0.0000;
	687	701	0.001066	0.008017	0.000179	137	137	137	0	0	1	-360	360	-2.0750	-1.0493	2.0751	1.0281	0.0000	0.0000	0.0000	0.0000;
	760	613	0.031157	0.055041	0.00515	109	109	109	0	0	1	-360	360	1.2894	-0.9186	-1.2889	0.3169	0.0000	0.0000	0.0000	0.0000;
	715	638	0.005124	0.012397	0.001229	109	109	109	0	0	1	-360	360	-27.0031	-1.7378	27.0373	1.6856	0.0000	0.0000	0.0000	0.0000;
	760	614	0.032149	0.055041	0.00515	109	109	109	0	0	1	-360	360	1.6740	-1.0922	-1.6731	0.4912	0.0000	0.0000	0.0000	0.0000;
	760	671	0.019008	0.051157	0.00528	137	137	137	0	0	1	-360	360	-0.0678	2.0559	0.0687	-2.6707	0.0000	0.0000	0.0000	0.0000;
	711	671	0.045793	0.127521	0.013141	137	137	137	0	0	1	-360	360	11.9714	-0.3580	-11.9157	-1.0293	0.0000	0.0000	0.0000	0.0000;
	809	710	0.024628	0.044876	0.00423	76	76	76	0	0	1	-360	360	-12.9696	-4.4695	13.0088	4.0441	0.0000	0.0000	0.0000	0.0000;
	809	594	0.058182	0.100413	0.00954	76	76	76	0	0	1	-360	360	7.4616	4.4695	-7.4213	-5.5065	0.0000	0.0000	0.0000	0.0000;
	832	710	0.010174	0.032983	0.003359	137	137	137	0	0	1	-360	360	-3.8284	-3.2041	3.8305	2.8150	0.0000	0.0000	0.0000	0.0000;
	833	828	0.003471	0.009008	0.000939	137	137	137	0	0	1	-360	360	-7.2965	3.2621	7.2984	-3.3676	0.0000	0.0000	0.0000	0.0000;
	833	832	0.006777	0.021901	0.002219	137	137	137	0	0	1	-360	360	2.2295	-3.4621	-2.2286	3.2041	0.0000	0.0000	0.0000	0.0000;
	828	711	0.014959	0.046612	0.004751	76	76	76	0	0	1	-360	360	-0.5194	-4.5648	0.5217	4.0128	0.0000	0.0000	0.0000	0.0000;
	828	813	0.063471	0.113802	0.010699	109	109	109	0	0	1	-360	360	22.7601	0.7018	-22.4795	-1.4396	0.0000	0.0000	0.0000	0.0000;
	715	677	0.044554	0.144132	0.01475	76	76	76	0	0	1	-360	360	-4.9195	-4.3681	4.9345	2.7894	0.0000	0.0000	0.0000	0.0000;
	830	711	0.069091	0.122727	0.01151	109	109	109	0	0	1	-360	360	-8.0786	-3.1874	8.1212	1.9154	0.0000	0.0000	0.0000	0.0000;
	613	606	0.014793	0.030826	0.002979	109	109	109	0	0	1	-360	360	0.0000	-0.3486	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	614	607	0.01843	0.033314	0.00326	109	109	109	0	0	1	-360	360	25.5094	4.8131	-25.4030	-5.0000	0.0000	0.0000	0.0000	0.0000;
	751	715	0.044628	0.078843	0.007381	76	76	76	0	0	1	-360	360	-16.9324	-2.2956	17.0527	1.7059	0.0000	0.0000	0.0000	0.0000;
	751	599	0.03843	0.100744	0.010411	137	137	137	0	0	1	-360	360	-0.2354	0.8170	0.2361	-1.9357	0.0000	0.0000	0.0000	0.0000;
	747	751	0.037686	0.121901	0.01247	137	137	137	0	0	1	-360	360	16.1047	-1.5016	-16.0146	0.4433	0.0000	0.0000	0.0000	0.0000;
	704	614	0.055703	0.099504	0.009341	76	76	76	0	0	1	-360	360	3.2140	2.3586	-3.2051	-3.4401	0.0000	0.0000	0.0000	0.0000;
	822	704	0.040992	0.073636	0.006921	76	76	76	0	0	1	-360	360	5.2077	1.5591	-5.1970	-2.3586	0.0000	0.0000	0.0000	0.0000;
	614	608	0.007934	0.018934	0.001871	109	109	109	0	0	1	-360	360	12.6400	-0.2756	-12.6291	0.0827	0.0000	0.0000	0.0000	0.0000;
	613	611	0.008512	0.027851	0.002851	137	137	137	0	0	1	-360	360	9.8497	0.2052	-9.8426	-0.5154	0.0000	0.0000	0.0000	0.0000;
	616	611	0.009421	0.030504	0.003119	137	137	137	0	0	1	-360	360	-3.2327	-0.7768	3.2336	0.4154	0.0000	0.0000	0.0000	0.0000;
	616	608	0.007851	0.018347	0.001801	109	109	109	0	0	1	-360	360	-5.2483	-0.1232	5.2501	-0.0827	0.0000	0.0000	0.0000	0.0000;
	816	812	0.027769	0.089752	0.009179	137	137	137	0	0	1	-360	360	-1.3210	-0.0000	1.3215	-1.0433	0.0000	0.0000	0.0000	0.0000;
	638	643	0.009421	0.030413	0.00311	109	109	109	0	0	1	-360	360	-34.1963	-2.1856	34.2969	2.1674	0.0000	0.0000	0.0000	0.0000;
	643	790	0.031397	0.078182	0.007749	137	137	137	0	0	1	-360	360	-37.2719	-2.6674	37.6674	2.7838	0.0000	0.0000	0.0000	0.0000;
	595	594	0.008347	0.027016	0.002771	137	137	137	0	0	1	-360	360	-3.9926	-4.5644	3.9952	4.2543	0.0000	0.0000	0.0000	0.0000;
	810	595	0.01843	0.059504	0.006079	137	137	137	0	0	1	-360	360	-0.6854	-4.7499	0.6886	4.0644	0.0000	0.0000	0.0000	0.0000;
	822	694	0.020661	0.06686	0.006839	137	137	137	0	0	1	-360	360	-9.9447	-1.7591	9.9622	1.0024	0.0000	0.0000	0.0000	0.0000;
	631	828	0.04876	0.157686	0.016129	137	137	137	0	0	1	-360	360	-8.5993	-4.6807	8.6364	2.9213	0.0000	0.0000	0.0000	0.0000;
	630	631	0.010496	0.033058	0.003381	137	137	137	0	0	1	-360	360	-1.2751	-0.8704	1.2753	0.4807	0.0000	0.0000	0.0000	0.0000;
	745	630	0.026612	0.086033	0.008799	137	137	137	0	0	1	-360	360	2.4412	1.5192	-2.4389	-2.5296	0.0000	0.0000	0.0000	0.0000;
	815	745	0.017521	0.056777	0.00581	137	137	137	0	0	1	-360	360	4.4278	1.6561	-4.4242	-2.3192	0.0000	0.0000	0.0000	0.0000;
	828	815	0.037521	0.121397	0.012419	137	137	137	0	0	1	-360	360	7.7615	2.0743	-7.7398	-3.4561	0.0000	0.0000	0.0000	0.0000;
	644	828	0.035537	0.115041	0.019031	109	109	109	0	0	1	-360	360	-3.4150	-0.1000	3.4188	-2.1246	0.0000	0.0000	0.0000	0.0000;
	750	751	0.023802	0.053802	0.005501	109	109	109	0	0	1	-360	360	-6.1830	-0.8107	6.1916	0.2383	0.0000	0.0000	0.0000	0.0000;
	746	750	0.018017	0.031818	0.002979	109	109	109	0	0	1	-360	360	0.4261	-0.9304	-0.4260	0.6107	0.0000	0.0000	0.0000	0.0000;
	752	746	0.001653	0.005372	0.000549	109	109	109	0	0	1	-360	360	7.8060	1.0137	-7.8051	-1.0696	0.0000	0.0000	0.0000	0.0000;
	751	752	0.010826	0.019174	0.001801	76	76	76	0	0	1	-360	360	13.8826	1.1546	-13.8630	-1.3137	0.0000	0.0000	0.0000	0.0000;
	707	751	0.016777	0.029587	0.002771	109	109	109	0	0	1	-360	360	-0.9728	-0.0192	0.9729	-0.2791	0.0000	0.0000	0.0000	0.0000;
	707	751	0.014554	0.025703	0.00241	109	109	109	0	0	1	-360	360	-1.1202	0.0192	1.1204	-0.2786	0.0000	0.0000	0.0000	0.0000;
	812	677	0.083058	0.148678	0.013961	76	76	76	0	0	1	-360	360	10.9794	2.4912	-10.8835	-3.8894	0.0000	0.0000	0.0000	0.0000;
	813	812	0.014132	0.026942	0.00257	109	109	109	0	0	1	-360	360	18.9545	1.2396	-18.9099	-1.4479	0.0000	0.0000	0.0000	0.0000;
	790	810	0.02638	0.085314	0.008729	137	137	137	0	0	1	-360	360	2.8478	-5.7170	-2.8396	4.7499	0.0000	0.0000	0.0000	0.0000;
	633	589	0.03124	0.101066	0.010341	137	137	137	0	0	1	-360	360	-12.8116	-2.5410	12.8591	1.5450	0.0000	0.0000	0.0000	0.0000;
	791	685	0.034876	0.11281	0.011541	137	137	137	0	0	1	-360	360	-9.8390	-2.4638	9.8698	1.2488	0.0000	0.0000	0.0000	0.0000;
	685	683	0.002066	0.006612	0.00068	137	137	137	0	0	1	-360	360	-12.6238	-1.5488	12.6267	1.4803	0.0000	0.0000	0.0000	0.0000;
	780	683	0.019917	0.037107	0.003509	76	76	76	0	0	1	-360	360	23.2965	2.5530	-23.2017	-2.7803	0.0000	0.0000	0.0000	0.0000;
	804	769	0.01719	0.055703	0.005699	137	137	137	0	0	1	-360	360	-33.4447	3.5302	33.6166	-3.6212	0.0000	0.0000	0.0000	0.0000;
	803	719	0.012066	0.020744	0.00198	76	76	76	0	0	1	-360	360	9.0705	-0.3810	-9.0619	0.1656	0.0000	0.0000	0.0000	0.0000;
	803	779	0.05876	0.120248	0.01158	109	109	109	0	0	1	-360	360	4.5448	2.2751	-4.5300	-3.5843	0.0000	0.0000	0.0000	0.0000;
	804	627	0.045207	0.079256	0.006401	109	109	109	0	0	1	-360	360	3.2485	-3.5285	-3.2403	2.8168	0.0000	0.0000	0.0000	0.0000;
	627	623	0.013058	0.024554	0.00198	109	109	109	0	0	1	-360	360	-2.7535	-5.8889	2.7582	5.6726	0.0000	0.0000	0.0000	0.0000;
	733	623	0.044554	0.089256	0.00679	109	109	109	0	0	1	-360	360	6.8674	5.8599	-6.8342	-6.5726	0.0000	0.0000	0.0000	0.0000;
	622	769	0.022066	0.07124	0.007289	137	137	137	0	0	1	-360	360	40.8745	-1.4289	-40.5556	1.6212	0.0000	0.0000	0.0000	0.0000;
	703	702	0.00876	0.014554	0.00152	109	109	109	0	0	1	-360	360	4.2105	2.9428	-4.2085	-3.1142	0.0000	0.0000	0.0000	0.0000;
	808	803	0.003967	0.006942	0.000661	109	109	109	0	0	1	-360	360	-6.4888	-4.2364	6.4908	4.1631	0.0000	0.0000	0.0000	0.0000;
	723	645	0.016198	0.052231	0.005351	76	76	76	0	0	1	-360	360	-6.0780	3.7221	6.0854	-4.3167	0.0000	0.0000	0.0000	0.0000;
	645	609	0.01595	0.031744	0.00302	76	76	76	0	0	1	-360	360	-8.1784	4.3167	8.1905	-4.6417	0.0000	0.0000	0.0000	0.0000;
	703	609	0.01124	0.019752	0.00173	109	109	109	0	0	1	-360	360	-1.9486	-9.7778	1.9581	9.5951	0.0000	0.0000	0.0000	0.0000;
	703	610	0.010826	0.019091	0.00166	109	109	109	0	0	1	-360	360	2.3895	4.3312	-2.3871	-4.5178	0.0000	0.0000	0.0000	0.0000;
	796	771	0.003719	0.011901	0.00121	137	137	137	0	0	1	-360	360	-16.3126	0.1746	16.3215	-0.2817	0.0000	0.0000	0.0000	0.0000;
	774	771	0.022636	0.07314	0.00748	137	137	137	0	0	1	-360	360	19.3718	-0.0790	-19.2965	-0.5183	0.0000	0.0000	0.0000	0.0000;
	804	590	0.136198	0.235124	0.022351	137	137	137	0	0	1	-360	360	-0.0665	2.1157	0.0802	-4.6076	0.0000	0.0000	0.0000	0.0000;
	773	590	0.006124	0.019917	0.00204	137	137	137	0	0	1	-360	360	4.9621	-1.5895	-4.9607	1.3662	0.0000	0.0000	0.0000	0.0000;
	778	590	0.004628	0.014793	0.0016	137	137	137	0	0	1	-360	360	29.1384	-1.1424	-29.1033	1.0758	0.0000	0.0000	0.0000	0.0000;
	778	772	0.007438	0.02405	0.002471	137	137	137	0	0	1	-360	360	-24.2144	0.9424	24.2535	-1.0934	0.0000	0.0000	0.0000	0.0000;
	772	762	0.003223	0.010496	0.001089	137	137	137	0	0	1	-360	360	-30.8625	1.0934	30.8898	-1.1267	0.0000	0.0000	0.0000	0.0000;
	777	774	0.027107	0.087769	0.008981	137	137	137	0	0	1	-360	360	16.8741	-0.7698	-16.8062	-0.0275	0.0000	0.0000	0.0000	0.0000;
	775	648	0.009669	0.031488	0.003221	137	137	137	0	0	1	-360	360	6.7171	-5.8595	-6.7104	5.5172	0.0000	0.0000	0.0000	0.0000;
	717	648	0.045446	0.080909	0.00757	109	109	109	0	0	1	-360	360	0.9034	5.3820	-0.8896	-6.2172	0.0000	0.0000	0.0000	0.0000;
	717	610	0.026281	0.046942	0.0044	109	109	109	0	0	1	-360	360	-5.2004	-5.3820	5.2126	4.9003	0.0000	0.0000	0.0000	0.0000;
	749	703	0.010909	0.019256	0.001801	109	109	109	0	0	1	-360	360	11.2725	0.3101	-11.2604	-0.4962	0.0000	0.0000	0.0000	0.0000;
	736	628	0.035207	0.076446	0.007429	137	137	137	0	0	1	-360	360	18.2940	2.1430	-18.1908	-2.7768	0.0000	0.0000	0.0000	0.0000;
	797	737	0.022397	0.072397	0.00741	137	137	137	0	0	1	-360	360	-15.0547	-4.3219	15.1018	3.6166	0.0000	0.0000	0.0000	0.0000;
	737	712	0.021322	0.06595	0.006711	109	109	109	0	0	1	-360	360	28.2048	2.3296	-28.0577	-2.6501	0.0000	0.0000	0.0000	0.0000;
	712	610	0.076942	0.132562	0.01263	109	109	109	0	0	1	-360	360	4.3437	-3.3499	-4.3264	1.9294	0.0000	0.0000	0.0000	0.0000;
	787	590	0.031818	0.079587	0.008061	137	137	137	0	0	1	-360	360	-12.1605	-4.2440	12.2073	3.4656	0.0000	0.0000	0.0000	0.0000;
	787	763	0.009174	0.022893	0.002321	137	137	137	0	0	1	-360	360	7.4235	3.6440	-7.4177	-3.8854	0.0000	0.0000	0.0000	0.0000;
	805	589	0.023554	0.07562	0.007819	137	137	137	0	0	1	-360	360	-29.1249	-9.0998	29.3244	8.8769	0.0000	0.0000	0.0000	0.0000;
	805	667	0.022231	0.071397	0.007381	137	137	137	0	0	1	-360	360	22.7359	7.8998	-22.6164	-8.3130	0.0000	0.0000	0.0000	0.0000;
	665	587	0.022066	0.059173	0.00611	137	137	137	0	0	1	-360	360	8.6702	-6.4062	-8.6468	5.8220	0.0000	0.0000	0.0000	0.0000;
	788	587	0.025372	0.067364	0.00695	137	137	137	0	0	1	-360	360	-5.8911	7.9699	5.9159	-8.6441	0.0000	0.0000	0.0000	0.0000;
	684	788	0.01405	0.036446	0.00377	137	137	137	0	0	1	-360	360	-6.7038	2.4300	6.7106	-2.8152	0.0000	0.0000	0.0000	0.0000;
	667	629	0.020744	0.067017	0.006861	137	137	137	0	0	1	-360	360	0.3785	-4.8224	-0.3746	4.0997	0.0000	0.0000	0.0000	0.0000;
	655	629	0.009669	0.026198	0.002631	109	109	109	0	0	1	-360	360	8.5572	4.8403	-8.5484	-5.0997	0.0000	0.0000	0.0000	0.0000;
	718	655	0.006198	0.02	0.00204	109	109	109	0	0	1	-360	360	9.5169	5.0416	-9.5102	-5.2403	0.0000	0.0000	0.0000	0.0000;
	811	609	0.015793	0.051066	0.00523	137	137	137	0	0	1	-360	360	-27.1060	-1.9429	27.2077	1.6707	0.0000	0.0000	0.0000	0.0000;
	777	759	0.001744	0.00562	0.000581	137	137	137	0	0	1	-360	360	-28.5501	-0.9302	28.5626	0.9045	0.0000	0.0000	0.0000	0.0000;
	817	792	0.020579	0.036281	0.00339	109	109	109	0	0	1	-360	360	-0.6216	-1.4164	0.6220	1.0543	0.0000	0.0000	0.0000	0.0000;
	829	817	0.028017	0.090496	0.00924	137	137	137	0	0	1	-360	360	3.6796	-1.9905	-3.6754	1.0164	0.0000	0.0000	0.0000	0.0000;
	829	788	0.008678	0.015372	0.00143	137	137	137	0	0	1	-360	360	-4.7806	1.6905	4.7827	-1.8396	0.0000	0.0000	0.0000	0.0000;
	775	589	0.033058	0.10686	0.010941	137	137	137	0	0	1	-360	360	18.0038	-1.0408	-17.9088	0.1191	0.0000	0.0000	0.0000	0.0000;
	804	637	0.032983	0.106686	0.010909	137	137	137	0	0	1	-360	360	3.0741	-4.2722	-3.0675	3.0541	0.0000	0.0000	0.0000	0.0000;
	723	807	0.020661	0.066777	0.006829	109	109	109	0	0	1	-360	360	5.8580	-3.7221	-5.8499	2.9572	0.0000	0.0000	0.0000	0.0000;
	811	632	0.014793	0.047686	0.004881	137	137	137	0	0	1	-360	360	19.2860	1.3429	-19.2376	-1.7437	0.0000	0.0000	0.0000	0.0000;
	814	632	0.007438	0.01314	0.001229	109	109	109	0	0	1	-360	360	-8.2181	0.1243	8.2226	-0.2563	0.0000	0.0000	0.0000	0.0000;
	814	627	0.008256	0.014628	0.00137	109	109	109	0	0	1	-360	360	5.0231	-0.4243	-5.0213	0.2720	0.0000	0.0000	0.0000	0.0000;
	800	788	0.002562	0.008182	0.00083	137	137	137	0	0	1	-360	360	7.4818	3.2314	-7.4802	-3.3150	0.0000	0.0000	0.0000	0.0000;
	702	610	0.005289	0.016859	0.00173	137	137	137	0	0	1	-360	360	-1.5005	2.1142	1.5009	-2.3119	0.0000	0.0000	0.0000	0.0000;
	775	676	0.038934	0.12595	0.012879	137	137	137	0	0	1	-360	360	28.8050	1.5916	-28.5169	-2.0954	0.0000	0.0000	0.0000	0.0000;
	728	749	0.02157	0.047438	0.00462	109	109	109	0	0	1	-360	360	12.4021	0.2390	-12.3735	-0.7101	0.0000	0.0000	0.0000	0.0000;
	728	736	0.029669	0.066364	0.00649	137	137	137	0	0	1	-360	360	-24.0774	7.4562	24.2415	-7.8428	0.0000	0.0000	0.0000	0.0000;
	676	633	0.009826	0.031818	0.00325	137	137	137	0	0	1	-360	360	-12.5768	-2.8519	12.5916	2.5410	0.0000	0.0000	0.0000	0.0000;
	775	759	0.02438	0.078017	0.008071	137	137	137	0	0	1	-360	360	-21.1130	0.1674	21.2094	-0.7735	0.0000	0.0000	0.0000	0.0000;
	762	759	0.017769	0.057364	0.005871	137	137	137	0	0	1	-360	360	-38.8188	0.7267	39.0570	-0.6220	0.0000	0.0000	0.0000	0.0000;
	797	628	0.008182	0.026446	0.00271	137	137	137	0	0	1	-360	360	11.9707	4.2219	-11.9591	-4.4959	0.0000	0.0000	0.0000	0.0000;
	665	605	0.012397	0.054132	0.006749	137	137	137	0	0	1	-360	360	7.7445	-2.7215	-7.7368	2.0414	0.0000	0.0000	0.0000	0.0000;
	807	808	0.008512	0.027438	0.00281	109	109	109	0	0	1	-360	360	-2.9621	-3.8572	2.9638	3.5364	0.0000	0.0000	0.0000	0.0000;
	800	789	0.006364	0.020579	0.002101	137	137	137	0	0	1	-360	360	-12.5488	-3.8314	12.5590	3.6393	0.0000	0.0000	0.0000	0.0000;
	605	587	0.017934	0.058016	0.005929	137	137	137	0	0	1	-360	360	2.4498	-3.4414	-2.4471	2.8221	0.0000	0.0000	0.0000	0.0000;
	664	667	0.001488	0.002636	0.000249	109	109	109	0	0	1	-360	360	-14.7605	-13.1524	14.7659	13.1354	0.0000	0.0000	0.0000	0.0000;
	666	664	0.000579	0.001901	0.000191	137	137	137	0	0	1	-360	360	-8.1503	-12.1690	8.1515	12.1524	0.0000	0.0000	0.0000	0.0000;
	831	804	0.028678	0.09281	0.009489	109	109	109	0	0	1	-360	360	1.9723	5.3967	-1.9625	-6.4461	0.0000	0.0000	0.0000	0.0000;
	585	733	0.015703	0.050744	0.005191	137	137	137	0	0	1	-360	360	-1.6520	-0.2000	1.6524	-0.3989	0.0000	0.0000	0.0000	0.0000;
	657	728	0.021322	0.068934	0.00705	137	137	137	0	0	1	-360	360	-10.5426	7.4785	10.5743	-8.1952	0.0000	0.0000	0.0000	0.0000;
	796	773	0.008182	0.026529	0.00271	137	137	137	0	0	1	-360	360	8.4926	-1.8746	-8.4871	1.5895	0.0000	0.0000	0.0000	0.0000;
	668	666	0.011488	0.029669	0.003011	109	109	109	0	0	1	-360	360	1.0063	-11.7514	-0.9917	11.4690	0.0000	0.0000	0.0000	0.0000;
	654	718	0.006198	0.02	0.00204	137	137	137	0	0	1	-360	360	15.6753	-0.1102	-15.6612	-0.0654	0.0000	0.0000	0.0000	0.0000;
	725	657	0.018099	0.058512	0.00599	137	137	137	0	0	1	-360	360	-6.9997	7.8363	7.0176	-8.4785	0.0000	0.0000	0.0000	0.0000;
	665	668	0.005702	0.016033	0.00165	137	137	137	0	0	1	-360	360	4.6510	-11.9016	-4.6423	11.7514	0.0000	0.0000	0.0000	0.0000;
	792	684	0.019174	0.049826	0.005159	76	76	76	0	0	1	-360	360	-2.7363	2.2847	2.7388	-2.8300	0.0000	0.0000	0.0000	0.0000;
	791	774	0.023058	0.074628	0.00764	137	137	137	0	0	1	-360	360	6.3140	1.0638	-6.3054	-1.9001	0.0000	0.0000	0.0000	0.0000;
	780	622	0.000157	0.000504	5.1e-05	137	137	137	0	0	1	-360	360	-24.8995	-3.5530	24.9003	3.5499	0.0000	0.0000	0.0000	0.0000;
	593	718	0.030248	0.059314	0.00567	137	137	137	0	0	1	-360	360	6.4275	6.1041	-6.4046	-6.6762	0.0000	0.0000	0.0000	0.0000;
	665	635	0.013587	0.043942	0.004496	137	137	137	0	0	1	-360	360	2.2036	-0.4732	-2.2030	-0.0000	0.0000	0.0000	0.0000	0.0000;
	835	764	0.051901	0.131397	0.013119	137	137	137	0	0	1	-360	360	-9.0820	0.4070	9.1194	-1.8429	0.0000	0.0000	0.0000	0.0000;
	767	765	0.015207	0.02562	0.002449	109	109	109	0	0	1	-360	360	-11.3841	-5.6361	11.4050	5.3855	0.0000	0.0000	0.0000	0.0000;
	767	766	0.008512	0.01438	0.001549	109	109	109	0	0	1	-360	360	-1.8339	3.6361	1.8352	-3.8141	0.0000	0.0000	0.0000	0.0000;
	766	740	0.027016	0.087603	0.009	137	137	137	0	0	1	-360	360	-15.0532	1.8141	15.1071	-2.6878	0.0000	0.0000	0.0000	0.0000;
	739	675	0.018512	0.06	0.00614	137	137	137	0	0	1	-360	360	-20.5139	2.7855	20.5820	-3.2845	0.0000	0.0000	0.0000	0.0000;
	675	661	0.013719	0.044463	0.00454	137	137	137	0	0	1	-360	360	-35.4520	3.2845	35.6003	-3.3386	0.0000	0.0000	0.0000	0.0000;
	764	757	0.022893	0.051901	0.00506	109	109	109	0	0	1	-360	360	14.7385	3.6802	-14.6930	-4.1661	0.0000	0.0000	0.0000	0.0000;
	768	757	0.025207	0.057438	0.00561	109	109	109	0	0	1	-360	360	-3.1403	-5.7389	3.1489	5.1104	0.0000	0.0000	0.0000	0.0000;
	768	761	0.005793	0.009917	0.00105	137	137	137	0	0	1	-360	360	-10.0777	3.7389	10.0835	-3.8498	0.0000	0.0000	0.0000	0.0000;
	641	618	0.017769	0.057364	0.005871	137	137	137	0	0	1	-360	360	-30.5690	1.2980	30.7126	-1.5176	0.0000	0.0000	0.0000	0.0000;
	661	618	0.020579	0.066124	0.006861	137	137	137	0	0	1	-360	360	34.7035	-1.2323	-34.4935	1.1009	0.0000	0.0000	0.0000	0.0000;
	764	612	0.009008	0.031066	0.002979	137	137	137	0	0	1	-360	360	1.2399	4.8714	-1.2378	-5.2123	0.0000	0.0000	0.0000	0.0000;
	748	612	0.023967	0.083223	0.007991	137	137	137	0	0	1	-360	360	3.7297	-6.1086	-3.7202	5.2123	0.0000	0.0000	0.0000	0.0000;
	758	748	0.023223	0.075207	0.0077	137	137	137	0	0	1	-360	360	8.7102	-6.4264	-8.6877	5.6086	0.0000	0.0000	0.0000	0.0000;
	826	784	0.008843	0.014876	0.0015	109	109	109	0	0	1	-360	360	-11.1179	-2.6646	11.1279	2.5086	0.0000	0.0000	0.0000	0.0000;
	826	596	0.014628	0.025793	0.00242	109	109	109	0	0	1	-360	360	2.6417	0.7143	-2.6408	-0.9909	0.0000	0.0000	0.0000	0.0000;
	798	764	0.053314	0.133388	0.010641	144	144	144	0	0	1	-360	360	-10.3010	-0.4840	10.3498	-0.6330	0.0000	0.0000	0.0000	0.0000;
	765	636	0.040661	0.111157	0.011471	137	137	137	0	0	1	-360	360	9.8599	-0.4391	-9.8261	-0.8057	0.0000	0.0000	0.0000	0.0000;
	802	636	0.027769	0.077686	0.00801	137	137	137	0	0	1	-360	360	-4.3136	-0.7225	4.3181	-0.1943	0.0000	0.0000	0.0000	0.0000;
	802	798	0.002893	0.007769	0.000801	137	137	137	0	0	1	-360	360	-5.5994	-0.7775	5.6002	0.6868	0.0000	0.0000	0.0000	0.0000;
	596	798	0.04	0.061818	0.006759	109	109	109	0	0	1	-360	360	-1.3186	-7.4860	1.3367	6.7338	0.0000	0.0000	0.0000	0.0000;
	794	596	0.038256	0.06562	0.01263	109	109	109	0	0	1	-360	360	3.6753	-5.6273	-3.6628	4.1995	0.0000	0.0000	0.0000	0.0000;
	794	669	0.028934	0.049752	0.00953	109	109	109	0	0	1	-360	360	-6.9793	5.1273	6.9998	-6.1832	0.0000	0.0000	0.0000	0.0000;
	670	669	0.004132	0.007107	0.00137	109	109	109	0	0	1	-360	360	11.9643	-6.3286	-11.9578	6.1832	0.0000	0.0000	0.0000	0.0000;
	798	726	0.069091	0.123802	0.010079	109	109	109	0	0	1	-360	360	-8.6497	-4.6516	8.7042	3.5696	0.0000	0.0000	0.0000	0.0000;
	798	659	0.039917	0.067934	0.005431	109	109	109	0	0	1	-360	360	-5.0665	-4.3468	5.0810	3.7392	0.0000	0.0000	0.0000	0.0000;
	731	659	0.01281	0.021818	0.00175	109	109	109	0	0	1	-360	360	7.8441	4.5499	-7.8350	-4.7392	0.0000	0.0000	0.0000	0.0000;
	731	727	0.013223	0.034298	0.003291	109	109	109	0	0	1	-360	360	-16.9581	-5.5499	16.9937	5.2550	0.0000	0.0000	0.0000	0.0000;
	726	690	0.031322	0.101397	0.010379	137	137	137	0	0	1	-360	360	7.3800	2.4733	-7.3630	-3.6389	0.0000	0.0000	0.0000	0.0000;
	729	726	0.002479	0.007934	0.00082	90	90	90	0	0	1	-360	360	29.4280	23.5616	-29.3982	-23.5636	0.0000	0.0000	0.0000	0.0000;
	729	726	0.002479	0.007934	0.00082	90	90	90	0	0	1	-360	360	29.4280	23.5616	-29.3982	-23.5636	0.0000	0.0000	0.0000	0.0000;
	730	729	0.000331	0.000579	0.0242	274	274	274	0	0	1	-360	360	58.8714	44.2778	-58.8559	-47.1233	0.0000	0.0000	0.0000	0.0000;
	618	592	0.016281	0.052727	0.005411	137	137	137	0	0	1	-360	360	1.5779	-0.0833	-1.5775	-0.5476	0.0000	0.0000	0.0000	0.0000;
	818	660	0.034711	0.112562	0.01158	137	137	137	0	0	1	-360	360	-39.9931	6.9425	40.4851	-6.7085	0.0000	0.0000	0.0000	0.0000;
	818	709	0.015124	0.051322	0.00251	137	137	137	0	0	1	-360	360	28.9781	-8.9425	-28.8595	9.0515	0.0000	0.0000	0.0000	0.0000;
	709	624	0.029496	0.051818	0.004881	137	137	137	0	0	1	-360	360	27.7585	-9.0515	-27.5449	8.8575	0.0000	0.0000	0.0000	0.0000;
	806	596	0.010248	0.018099	0.001699	109	109	109	0	0	1	-360	360	2.2836	-4.5617	-2.2814	4.3706	0.0000	0.0000	0.0000	0.0000;
	823	806	0.03124	0.055124	0.005159	109	109	109	0	0	1	-360	360	3.3918	-4.1409	-3.3846	3.5617	0.0000	0.0000	0.0000	0.0000;
	823	663	0.024463	0.043223	0.004051	109	109	109	0	0	1	-360	360	-6.6958	4.1409	6.7094	-4.5810	0.0000	0.0000	0.0000	0.0000;
	713	663	0.057364	0.100826	0.009489	109	109	109	0	0	1	-360	360	-4.4787	0.4065	4.4892	-1.4734	0.0000	0.0000	0.0000	0.0000;
	724	713	0.013636	0.070413	0.007279	137	137	137	0	0	1	-360	360	-0.9036	-0.9378	0.9037	0.1073	0.0000	0.0000	0.0000	0.0000;
	650	663	0.003058	0.009826	0.001009	137	137	137	0	0	1	-360	360	-16.0362	-1.8572	16.0432	1.7640	0.0000	0.0000	0.0000	0.0000;
	652	651	0.004463	0.014554	0.001481	137	137	137	0	0	1	-360	360	-12.6083	-2.4924	12.6147	2.3440	0.0000	0.0000	0.0000	0.0000;
	754	651	0.01405	0.045372	0.004649	137	137	137	0	0	1	-360	360	23.6988	2.0331	-23.6297	-2.3440	0.0000	0.0000	0.0000	0.0000;
	653	663	0.007603	0.024554	0.002519	137	137	137	0	0	1	-360	360	-13.5187	0.0070	13.5308	-0.2560	0.0000	0.0000	0.0000	0.0000;
	674	653	0.004463	0.013876	0.00143	137	137	137	0	0	1	-360	360	-7.4595	-0.1498	7.4617	-0.0070	0.0000	0.0000	0.0000	0.0000;
	662	674	0.005702	0.018512	0.00189	137	137	137	0	0	1	-360	360	4.6586	0.6377	-4.6575	-0.8502	0.0000	0.0000	0.0000	0.0000;
	754	713	0.021984	0.06843	0.00702	137	137	137	0	0	1	-360	360	20.7394	0.9644	-20.6570	-1.5138	0.0000	0.0000	0.0000	0.0000;
	821	755	0.016198	0.02843	0.002691	109	109	109	0	0	1	-360	360	-1.0389	-4.6821	1.0419	4.3775	0.0000	0.0000	0.0000	0.0000;
	821	640	0.039174	0.066033	0.003959	109	109	109	0	0	1	-360	360	-5.0181	3.6821	5.0319	-4.1140	0.0000	0.0000	0.0000	0.0000;
	639	640	0.009587	0.020174	0.00196	109	109	109	0	0	1	-360	360	15.5174	-4.2941	-15.4959	4.1140	0.0000	0.0000	0.0000	0.0000;
	755	714	0.009669	0.03157	0.003221	137	137	137	0	0	1	-360	360	14.4273	-0.1180	-14.4099	-0.1960	0.0000	0.0000	0.0000	0.0000;
	714	615	0.047769	0.090579	0.00862	109	109	109	0	0	1	-360	360	9.4519	-0.8040	-9.4148	-0.1135	0.0000	0.0000	0.0000	0.0000;
	781	615	0.022727	0.046612	0.004501	109	109	109	0	0	1	-360	360	-3.9037	-0.6208	3.9068	0.1135	0.0000	0.0000	0.0000	0.0000;
	781	602	0.024628	0.059587	0.004961	109	109	109	0	0	1	-360	360	1.7007	0.6208	-1.6999	-1.1838	0.0000	0.0000	0.0000	0.0000;
	603	602	0.005702	0.018512	0.00189	109	109	109	0	0	1	-360	360	11.7470	-2.0165	-11.7399	1.8244	0.0000	0.0000	0.0000	0.0000;
	835	690	0.04719	0.085207	0.00803	109	109	109	0	0	1	-360	360	-1.8497	-3.5664	1.8550	2.6389	0.0000	0.0000	0.0000	0.0000;
	757	753	0.007769	0.016859	0.00165	137	137	137	0	0	1	-360	360	-0.5729	-1.9443	0.5732	1.7535	0.0000	0.0000	0.0000	0.0000;
	776	765	0.016859	0.029826	0.00281	109	109	109	0	0	1	-360	360	-20.4106	-2.6426	20.4719	2.4237	0.0000	0.0000	0.0000	0.0000;
	776	753	0.003554	0.006281	0.005421	109	109	109	0	0	1	-360	360	18.2076	2.6426	-18.1972	-3.2535	0.0000	0.0000	0.0000	0.0000;
	834	596	0.005868	0.010331	0.00097	109	109	109	0	0	1	-360	360	-4.9442	0.4839	4.9455	-0.5932	0.0000	0.0000	0.0000	0.0000;
	834	793	0.003802	0.012397	0.00127	109	109	109	0	0	1	-360	360	2.5402	-1.4839	-2.5399	1.3389	0.0000	0.0000	0.0000	0.0000;
	793	735	0.00405	0.012984	0.001331	137	137	137	0	0	1	-360	360	-0.7641	-1.3389	0.7642	1.1861	0.0000	0.0000	0.0000	0.0000;
	758	619	0.003554	0.01157	0.001191	137	137	137	0	0	1	-360	360	2.2031	-0.1369	-2.2030	0.0000	0.0000	0.0000	0.0000	0.0000;
	801	603	0.017769	0.057603	0.00589	109	109	109	0	0	1	-360	360	14.5347	-2.5787	-14.5010	2.0165	0.0000	0.0000	0.0000	0.0000;
	625	801	0.017769	0.057603	0.00589	109	109	109	0	0	1	-360	360	16.7826	-3.1059	-16.7377	2.5787	0.0000	0.0000	0.0000	0.0000;
	738	602	0.021744	0.038347	0.003589	109	109	109	0	0	1	-360	360	-2.4235	0.7345	2.4248	-1.1406	0.0000	0.0000	0.0000	0.0000;
	738	827	0.01719	0.05562	0.00568	137	137	137	0	0	1	-360	360	-3.8885	-1.1637	3.8909	0.5246	0.0000	0.0000	0.0000	0.0000;
	827	673	0.01719	0.05562	0.00568	137	137	137	0	0	1	-360	360	-6.0948	-0.3318	6.1004	-0.2981	0.0000	0.0000	0.0000	0.0000;
	708	592	0.020744	0.067273	0.00688	137	137	137	0	0	1	-360	360	3.3825	-0.3450	-3.3805	-0.4524	0.0000	0.0000	0.0000	0.0000;
	672	670	0.00157	0.003058	0.00029	69	69	69	0	0	1	-360	360	13.0682	-6.3562	-13.0653	6.3286	0.0000	0.0000	0.0000	0.0000;
	784	765	0.038256	0.067521	0.006331	109	109	109	0	0	1	-360	360	-16.0859	-3.5086	16.1750	2.9305	0.0000	0.0000	0.0000	0.0000;
	798	721	0.024876	0.072231	0.00824	137	137	137	0	0	1	-360	360	4.9633	0.0617	-4.9580	-1.0000	0.0000	0.0000	0.0000	0.0000;
	738	656	0.015207	0.049008	0.005019	20	20	20	0	0	1	-360	360	0.5511	-0.5708	-0.5510	0.0000	0.0000	0.0000	0.0000	0.0000;
	826	795	0.000413	0.011901	0.00122	69	69	69	0	0	1	-360	360	8.4761	1.9503	-8.4759	-2.0827	0.0000	0.0000	0.0000	0.0000;
	735	795	0.00281	0.009008	0.00092	69	69	69	0	0	1	-360	360	-5.1712	-1.6861	5.1719	1.5827	0.0000	0.0000	0.0000	0.0000;
	755	647	0.022893	0.074132	0.007579	137	137	137	0	0	1	-360	360	12.4101	0.4868	-12.3794	-1.2586	0.0000	0.0000	0.0000	0.0000;
	739	740	0.019339	0.062636	0.006411	137	137	137	0	0	1	-360	360	16.6579	-2.7855	-16.6111	2.1878	0.0000	0.0000	0.0000	0.0000;
	652	650	0.004554	0.014711	0.0015	137	137	137	0	0	1	-360	360	-12.7257	-1.5076	12.7322	1.3572	0.0000	0.0000	0.0000	0.0000;
	639	786	0.034876	0.064876	0.00614	109	109	109	0	0	1	-360	360	-17.7204	4.2941	17.8222	-4.8130	0.0000	0.0000	0.0000	0.0000;
	761	641	0.020992	0.067851	0.006941	137	137	137	0	0	1	-360	360	-24.4025	1.8498	24.5120	-2.2980	0.0000	0.0000	0.0000	0.0000;
	647	662	0.010826	0.035124	0.003589	69	69	69	0	0	1	-360	360	10.1764	0.2586	-10.1666	-0.6377	0.0000	0.0000	0.0000	0.0000;
	621	827	0.019174	0.059587	0.006103	69	69	69	0	0	1	-360	360	-2.2030	-0.5000	2.2038	-0.1928	0.0000	0.0000	0.0000	0.0000;
	1863	1272	0.026281	0.082975	0.009048	114	114	114	0	0	1	-360	360	7.0544	-0.0178	-7.0434	-1.0272	0.0000	0.0000	0.0000	0.0000;
	1271	1272	0.002975	0.009669	0.001004	140	140	140	0	0	1	-360	360	-7.0420	-2.0050	7.0433	1.8898	0.0000	0.0000	0.0000	0.0000;
	981	1493	0.036116	0.050413	0.008291	57	57	57	0	0	1	-360	360	-1.3600	0.6491	1.3610	-1.6151	0.0000	0.0000	0.0000	0.0000;
	980	981	0	8.3e-05	1e-05	29	29	29	0	0	1	-360	360	-1.3600	0.6480	1.3600	-0.6491	0.0000	0.0000	0.0000	0.0000;
	1014	983	0.016198	0.049174	0.00584	114	114	114	0	0	1	-360	360	34.1607	2.4004	-34.0054	-2.6404	0.0000	0.0000	0.0000	0.0000;
	1013	1014	0.000165	0.000248	4.4e-05	90	90	90	0	0	1	-360	360	-1.4750	-0.5400	1.4750	0.5347	0.0000	0.0000	0.0000	0.0000;
	1018	1359	0.016529	0.050413	0.005893	114	114	114	0	0	1	-360	360	-18.8801	-0.1194	18.9342	-0.3598	0.0000	0.0000	0.0000	0.0000;
	1017	1018	0.000496	0.001488	0.000172	114	114	114	0	0	1	-360	360	-2.4970	-0.6450	2.4970	0.6264	0.0000	0.0000	0.0000	0.0000;
	1143	896	0.038678	0.099587	0.011081	114	114	114	0	0	1	-360	360	-8.4456	-2.3672	8.4699	1.1125	0.0000	0.0000	0.0000	0.0000;
	1603	1347	0.005372	0.01719	0.001832	114	114	114	0	0	1	-360	360	10.2210	2.0102	-10.2160	-2.2080	0.0000	0.0000	0.0000	0.0000;
	897	1603	0.039091	0.09562	0.010571	114	114	114	0	0	1	-360	360	20.6025	4.1144	-20.4561	-5.0042	0.0000	0.0000	0.0000	0.0000;
	1602	1603	8.3e-05	0.000248	1.9e-05	120	120	120	0	0	1	-360	360	-10.2350	-2.9960	10.2351	2.9940	0.0000	0.0000	0.0000	0.0000;
	1326	1246	0.01595	0.046694	0.004131	114	114	114	0	0	1	-360	360	-5.1008	0.0902	5.1043	-0.5732	0.0000	0.0000	0.0000	0.0000;
	1720	1326	0.031736	0.094215	0.008361	120	120	120	0	0	1	-360	360	-3.9636	-0.7480	3.9678	-0.2360	0.0000	0.0000	0.0000	0.0000;
	1324	1326	0.000496	0.001157	0.000135	29	29	29	0	0	1	-360	360	-1.1330	-0.1620	1.1330	0.1458	0.0000	0.0000	0.0000	0.0000;
	1327	1245	0.01595	0.046694	0.004136	114	114	114	0	0	1	-360	360	6.5726	3.7497	-6.5646	-4.2131	0.0000	0.0000	0.0000	0.0000;
	1721	1327	0.031736	0.094215	0.008361	120	120	120	0	0	1	-360	360	6.5871	2.7856	-6.5726	-3.7337	0.0000	0.0000	0.0000	0.0000;
	1325	1327	0.000496	0.001157	0.000135	29	29	29	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0160	0.0000	0.0000	0.0000	0.0000;
	1893	1633	0.048182	0.119835	0.013225	114	114	114	0	0	1	-360	360	-6.7005	0.3064	6.7192	-1.8368	0.0000	0.0000	0.0000	0.0000;
	1632	1300	0.040165	0.105785	0.01189	114	114	114	0	0	1	-360	360	6.8769	-1.7260	-6.8606	0.3506	0.0000	0.0000	0.0000	0.0000;
	1011	880	0.011653	0.03595	0.004112	114	114	114	0	0	1	-360	360	-45.3682	-7.8011	45.5823	7.9849	0.0000	0.0000	0.0000	0.0000;
	1010	881	0.011653	0.03595	0.004112	114	114	114	0	0	1	-360	360	13.6206	2.6950	-13.6013	-3.1166	0.0000	0.0000	0.0000	0.0000;
	1216	1635	0.002727	0.008926	0.000886	140	140	140	0	0	1	-360	360	20.8678	0.0213	-20.8577	-0.0933	0.0000	0.0000	0.0000	0.0000;
	1350	1216	0.007603	0.023471	0.002664	114	114	114	0	0	1	-360	360	26.5812	1.5774	-26.5359	-1.7537	0.0000	0.0000	0.0000	0.0000;
	1215	1216	0.000331	0.000413	8.2e-05	90	90	90	0	0	1	-360	360	-5.6680	-1.7420	5.6681	1.7324	0.0000	0.0000	0.0000	0.0000;
	894	1413	0.018182	0.044628	0.004898	120	120	120	0	0	1	-360	360	11.0186	4.2835	-10.9971	-4.8165	0.0000	0.0000	0.0000	0.0000;
	1864	894	0.026033	0.063636	0.007047	120	120	120	0	0	1	-360	360	15.4980	3.6662	-15.4429	-4.3819	0.0000	0.0000	0.0000	0.0000;
	894	892	0.013884	0.018017	0.003231	90	90	90	0	0	1	-360	360	4.4243	0.0984	-4.4220	-0.4830	0.0000	0.0000	0.0000	0.0000;
	1263	1414	0.017355	0.048265	0.005145	120	120	120	0	0	1	-360	360	6.3303	4.1365	-6.3217	-4.7281	0.0000	0.0000	0.0000	0.0000;
	1563	1205	0.00686	0.022231	0.002331	140	140	140	0	0	1	-360	360	8.7329	-2.2339	-8.7283	1.9719	0.0000	0.0000	0.0000	0.0000;
	1053	1563	0.004298	0.013388	0.001488	140	140	140	0	0	1	-360	360	8.7359	-2.6611	-8.7329	2.4935	0.0000	0.0000	0.0000	0.0000;
	1350	1053	0.005785	0.017686	0.002079	140	140	140	0	0	1	-360	360	9.6478	-2.6149	-9.6429	2.3824	0.0000	0.0000	0.0000	0.0000;
	1562	1563	0.006033	0.01843	0.002183	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.2596	0.0000	0.0000	0.0000	0.0000;
	1053	1052	0.002314	0.002893	0.000549	90	90	90	0	0	1	-360	360	0.9070	0.2787	-0.9070	-0.3440	0.0000	0.0000	0.0000	0.0000;
	1714	972	0.005041	0.015372	0.001774	140	140	140	0	0	1	-360	360	-1.5283	-4.1627	1.5291	3.9501	0.0000	0.0000	0.0000	0.0000;
	1352	1714	0.010248	0.031405	0.003628	140	140	140	0	0	1	-360	360	4.0360	-2.1720	-4.0343	1.7379	0.0000	0.0000	0.0000	0.0000;
	1714	1712	0.005124	0.008595	0.000908	90	90	90	0	0	1	-360	360	5.5626	2.4248	-5.5610	-2.5320	0.0000	0.0000	0.0000	0.0000;
	1715	973	0.005041	0.015372	0.001774	140	140	140	0	0	1	-360	360	6.9252	-3.8686	-6.9227	3.6617	0.0000	0.0000	0.0000	0.0000;
	1352	1715	0.010248	0.031405	0.003628	140	140	140	0	0	1	-360	360	9.9958	-2.8171	-9.9867	2.4057	0.0000	0.0000	0.0000	0.0000;
	1715	1713	0.005124	0.008512	0.0009	90	90	90	0	0	1	-360	360	3.0615	1.4629	-3.0610	-1.5710	0.0000	0.0000	0.0000	0.0000;
	1893	1363	0.040165	0.070165	0.007071	90	90	90	0	0	1	-360	360	2.6656	-1.5182	-2.6628	0.6816	0.0000	0.0000	0.0000	0.0000;
	1677	1306	0.022479	0.06562	0.006333	120	120	120	0	0	1	-360	360	21.8617	-0.0230	-21.7707	-0.4553	0.0000	0.0000	0.0000	0.0000;
	1676	1856	0.01876	0.055372	0.005322	84	84	84	0	0	1	-360	360	22.4825	0.0083	-22.4018	-0.3934	0.0000	0.0000	0.0000	0.0000;
	1320	1179	0.014628	0.045868	0.005084	140	140	140	0	0	1	-360	360	36.9099	-8.3078	-36.7356	8.2467	0.0000	0.0000	0.0000	0.0000;
	1593	1320	0.006281	0.019752	0.002183	140	140	140	0	0	1	-360	360	36.9852	-8.4374	-36.9099	8.4129	0.0000	0.0000	0.0000	0.0000;
	1320	1318	0.00438	0.00843	0.000879	90	90	90	0	0	1	-360	360	0.0000	-0.1051	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1321	925	0.006281	0.019504	0.002217	140	140	140	0	0	1	-360	360	-23.1618	4.2802	23.1914	-4.4505	0.0000	0.0000	0.0000	0.0000;
	1769	1321	0.005041	0.015454	0.001793	140	140	140	0	0	1	-360	360	-23.1382	4.0370	23.1618	-4.1764	0.0000	0.0000	0.0000	0.0000;
	1321	1319	0.00438	0.00843	0.000879	90	90	90	0	0	1	-360	360	0.0000	-0.1038	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1352	836	0.012479	0.045207	0.00537	114	114	114	0	0	1	-360	360	0.0000	-0.6502	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1351	837	0.012479	0.045207	0.00537	114	114	114	0	0	1	-360	360	0.6711	-0.0968	-0.6710	-0.5500	0.0000	0.0000	0.0000	0.0000;
	1422	1004	0.002231	0.008347	0.000983	162	162	162	0	0	1	-360	360	-12.2372	-2.7650	12.2401	2.6566	0.0000	0.0000	0.0000	0.0000;
	989	1005	0.004132	0.01562	0.001878	162	162	162	0	0	1	-360	360	-10.5676	-2.9810	10.5716	2.7686	0.0000	0.0000	0.0000	0.0000;
	1352	989	0.004876	0.016446	0.00198	140	140	140	0	0	1	-360	360	-7.3891	-2.2735	7.3914	2.0417	0.0000	0.0000	0.0000	0.0000;
	989	988	0.00124	0.004463	0.000554	162	162	162	0	0	1	-360	360	3.1761	0.9392	-3.1760	-1.0060	0.0000	0.0000	0.0000	0.0000;
	1396	1232	0.005537	0.017355	0.001919	140	140	140	0	0	1	-360	360	-16.5417	-2.5002	16.5546	2.3102	0.0000	0.0000	0.0000	0.0000;
	1464	1336	0.04157	0.060826	0.010346	90	90	90	0	0	1	-360	360	14.2027	-1.2181	-14.1283	0.1655	0.0000	0.0000	0.0000	0.0000;
	1495	1786	0.003967	0.011983	0.001421	140	140	140	0	0	1	-360	360	8.1824	3.2793	-8.1798	-3.4424	0.0000	0.0000	0.0000	0.0000;
	1670	1868	0.015868	0.048016	0.005704	114	114	114	0	0	1	-360	360	18.1929	3.0185	-18.1446	-3.5120	0.0000	0.0000	0.0000	0.0000;
	1007	1670	0.02157	0.065454	0.007771	114	114	114	0	0	1	-360	360	18.2575	2.2382	-18.1929	-2.9212	0.0000	0.0000	0.0000	0.0000;
	1669	1670	0.002397	0.007273	0.000864	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0972	0.0000	0.0000	0.0000	0.0000;
	1441	1774	0.002397	0.007355	0.000852	140	140	140	0	0	1	-360	360	16.1230	8.0360	-16.1165	-8.1188	0.0000	0.0000	0.0000	0.0000;
	1386	1292	0.010496	0.031901	0.003782	114	114	114	0	0	1	-360	360	19.6714	-2.3787	-19.6366	2.0390	0.0000	0.0000	0.0000	0.0000;
	1221	1450	0.024793	0.041322	0.004259	90	90	90	0	0	1	-360	360	5.2354	-1.2146	-5.2295	0.7215	0.0000	0.0000	0.0000	0.0000;
	1065	987	0.010826	0.023967	0.003364	114	114	114	0	0	1	-360	360	41.1824	0.5729	-41.0268	-0.6240	0.0000	0.0000	0.0000	0.0000;
	1749	1503	0.008347	0.024959	0.003015	114	114	114	0	0	1	-360	360	-42.9207	1.2055	43.0535	-1.1585	0.0000	0.0000	0.0000	0.0000;
	1116	1433	0.024793	0.083471	0.010285	114	114	114	0	0	1	-360	360	-40.1811	-14.3318	40.5763	14.4754	0.0000	0.0000	0.0000	0.0000;
	1498	1433	0.034876	0.093058	0.01232	120	120	120	0	0	1	-360	360	-33.4407	-5.9285	33.7906	5.4345	0.0000	0.0000	0.0000	0.0000;
	1591	1312	0.008182	0.014628	0.00304	120	120	120	0	0	1	-360	360	51.4674	1.2718	-51.2825	-1.2964	0.0000	0.0000	0.0000	0.0000;
	1753	959	0.056033	0.074711	0.007168	75	75	75	0	0	1	-360	360	-2.5404	-0.8265	2.5436	-0.0143	0.0000	0.0000	0.0000	0.0000;
	1753	1331	0.038265	0.051984	0.004753	57	57	57	0	0	1	-360	360	20.0221	-0.6362	-19.8918	0.2573	0.0000	0.0000	0.0000	0.0000;
	1335	1246	0.029256	0.050826	0.004973	90	90	90	0	0	1	-360	360	5.0956	-0.1537	-5.0893	-0.4301	0.0000	0.0000	0.0000	0.0000;
	1894	1001	0.019752	0.05124	0.005878	90	90	90	0	0	1	-360	360	20.2087	-2.5330	-20.1399	2.0163	0.0000	0.0000	0.0000	0.0000;
	1484	1266	0.021818	0.065702	0.007795	90	90	90	0	0	1	-360	360	7.0299	-1.3050	-7.0206	0.4198	0.0000	0.0000	0.0000	0.0000;
	1571	1266	0.036281	0.070579	0.007366	90	90	90	0	0	1	-360	360	-8.6896	10.3744	8.7488	-11.1249	0.0000	0.0000	0.0000	0.0000;
	1808	1012	0.019917	0.060579	0.007124	114	114	114	0	0	1	-360	360	16.4423	0.7145	-16.3962	-1.4079	0.0000	0.0000	0.0000	0.0000;
	1210	1010	0.007769	0.023719	0.002798	140	140	140	0	0	1	-360	360	-22.8608	-3.2450	22.8962	3.0257	0.0000	0.0000	0.0000	0.0000;
	844	1809	0.047603	0.060165	0.005242	60	60	60	0	0	1	-360	360	-1.1510	-0.4910	1.1516	-0.1204	0.0000	0.0000	0.0000	0.0000;
	1010	1693	0.052479	0.129917	0.014394	114	114	114	0	0	1	-360	360	12.1191	-3.9338	-12.0491	2.4220	0.0000	0.0000	0.0000	0.0000;
	1891	936	0.032645	0.079091	0.009402	114	114	114	0	0	1	-360	360	-2.8833	-2.8032	2.8871	1.7253	0.0000	0.0000	0.0000	0.0000;
	875	1214	0.023719	0.033388	0.00589	90	90	90	0	0	1	-360	360	11.0832	-3.6624	-11.0549	3.0419	0.0000	0.0000	0.0000	0.0000;
	1174	1717	0.008264	0.026364	0.002848	140	140	140	0	0	1	-360	360	-34.2706	1.6773	34.3528	-1.7530	0.0000	0.0000	0.0000	0.0000;
	1010	1174	0.019917	0.063884	0.00674	114	114	114	0	0	1	-360	360	-33.6250	1.5381	33.8176	-1.7145	0.0000	0.0000	0.0000	0.0000;
	1173	1174	0.000992	0.003141	0.00037	114	114	114	0	0	1	-360	360	-0.4530	-0.0810	0.4530	0.0372	0.0000	0.0000	0.0000	0.0000;
	1693	1223	0.013554	0.040992	0.004864	114	114	114	0	0	1	-360	360	20.1379	4.8507	-20.0878	-5.2651	0.0000	0.0000	0.0000	0.0000;
	1207	967	0.005372	0.017025	0.001861	114	114	114	0	0	1	-360	360	7.3773	0.4957	-7.3747	-0.7047	0.0000	0.0000	0.0000	0.0000;
	1488	1648	0.020248	0.067934	0.006556	114	114	114	0	0	1	-360	360	11.8365	-2.2167	-11.8107	1.5660	0.0000	0.0000	0.0000	0.0000;
	1741	1810	0.037273	0.119504	0.012681	114	114	114	0	0	1	-360	360	-17.5527	-3.4348	17.6592	2.3625	0.0000	0.0000	0.0000	0.0000;
	1742	957	0.01876	0.059339	0.006437	114	114	114	0	0	1	-360	360	-15.4647	-2.1107	15.5058	1.5270	0.0000	0.0000	0.0000	0.0000;
	1557	1387	0.015868	0.053554	0.005135	114	114	114	0	0	1	-360	360	0.0832	-0.0205	-0.0832	-0.5853	0.0000	0.0000	0.0000	0.0000;
	1208	880	0.006777	0.021488	0.002343	114	114	114	0	0	1	-360	360	-7.6033	-0.5771	7.6067	0.3144	0.0000	0.0000	0.0000	0.0000;
	1200	881	0.015372	0.048926	0.005234	114	114	114	0	0	1	-360	360	-5.2817	0.4756	5.2855	-1.0746	0.0000	0.0000	0.0000	0.0000;
	1871	880	0.00686	0.021901	0.002331	114	114	114	0	0	1	-360	360	-0.7940	-0.4860	0.7940	0.2141	0.0000	0.0000	0.0000	0.0000;
	1872	881	0.00686	0.021901	0.002335	114	114	114	0	0	1	-360	360	-1.8130	-0.7290	1.8132	0.4571	0.0000	0.0000	0.0000	0.0000;
	1752	1796	0.053058	0.227273	0.025112	162	162	162	0	0	1	-360	360	-15.8733	-0.7669	15.9933	-1.5403	0.0000	0.0000	0.0000	0.0000;
	1075	1795	0.049174	0.21124	0.023334	114	114	114	0	0	1	-360	360	-17.9294	-1.1289	18.0714	-0.8802	0.0000	0.0000	0.0000	0.0000;
	1546	1429	0.034298	0.10595	0.011374	114	114	114	0	0	1	-360	360	35.6433	9.1455	-35.2419	-9.2089	0.0000	0.0000	0.0000	0.0000;
	1124	1099	0.000496	0.000909	7.7e-05	90	90	90	0	0	1	-360	360	-5.4548	2.4663	5.4550	-2.4753	0.0000	0.0000	0.0000	0.0000;
	1128	1124	0.004132	0.007107	0.000692	90	90	90	0	0	1	-360	360	-5.4536	2.3625	5.4548	-2.4432	0.0000	0.0000	0.0000	0.0000;
	1863	1128	0.004132	0.006942	0.000721	90	90	90	0	0	1	-360	360	-5.4524	2.2749	5.4536	-2.3591	0.0000	0.0000	0.0000	0.0000;
	1122	1124	0.001157	0.002149	0.000194	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0232	0.0000	0.0000	0.0000	0.0000;
	1126	1128	8.3e-05	0.000248	2.9e-05	140	140	140	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0035	0.0000	0.0000	0.0000	0.0000;
	982	851	0.017355	0.050165	0.006278	114	114	114	0	0	1	-360	360	28.4437	2.1864	-28.3268	-2.6054	0.0000	0.0000	0.0000	0.0000;
	1261	1233	0.024546	0.061488	0.006486	76	76	76	0	0	1	-360	360	25.5736	-0.1737	-25.4406	-0.2722	0.0000	0.0000	0.0000	0.0000;
	1364	1134	0.026612	0.041322	0.006396	90	90	90	0	0	1	-360	360	-12.0842	-1.0079	12.1169	0.2955	0.0000	0.0000	0.0000	0.0000;
	1863	1203	0.031653	0.061735	0.011805	120	120	120	0	0	1	-360	360	31.2046	-4.6437	-30.9427	3.7517	0.0000	0.0000	0.0000	0.0000;
	1864	1133	0.045455	0.05686	0.010803	90	90	90	0	0	1	-360	360	17.4483	0.1406	-17.3340	-1.2995	0.0000	0.0000	0.0000	0.0000;
	1241	850	0.002975	0.009504	0.000997	114	114	114	0	0	1	-360	360	12.8477	-2.1402	-12.8435	2.0341	0.0000	0.0000	0.0000	0.0000;
	1511	1261	0.013471	0.043306	0.004559	114	114	114	0	0	1	-360	360	-2.2283	-8.9029	2.2372	8.3830	0.0000	0.0000	0.0000	0.0000;
	899	1233	0.008926	0.024793	0.002756	140	140	140	0	0	1	-360	360	-3.8901	1.1089	3.8914	-1.4348	0.0000	0.0000	0.0000	0.0000;
	1278	1204	0.020413	0.039752	0.007577	120	120	120	0	0	1	-360	360	-28.1916	3.8191	28.3331	-4.4354	0.0000	0.0000	0.0000	0.0000;
	1613	1129	8.3e-05	0.000826	7e-06	90	90	90	0	0	1	-360	360	-3.3620	0.5732	3.3620	-0.5740	0.0000	0.0000	0.0000	0.0000;
	1864	1613	0.006529	0.010992	0.001128	90	90	90	0	0	1	-360	360	0.3802	1.3967	-0.3800	-1.5333	0.0000	0.0000	0.0000	0.0000;
	1613	1612	0.000165	0.000248	2.4e-05	90	90	90	0	0	1	-360	360	3.7420	0.9601	-3.7420	-0.9630	0.0000	0.0000	0.0000	0.0000;
	1127	1130	0.002562	0.00438	0.000443	90	90	90	0	0	1	-360	360	9.0798	0.4211	-9.0780	-0.4710	0.0000	0.0000	0.0000	0.0000;
	1863	1127	0.00405	0.006777	0.000707	90	90	90	0	0	1	-360	360	11.8035	0.3918	-11.7988	-0.4683	0.0000	0.0000	0.0000	0.0000;
	1125	1127	0.000744	0.002314	0.000276	76	76	76	0	0	1	-360	360	-2.7190	-0.0800	2.7190	0.0472	0.0000	0.0000	0.0000	0.0000;
	1123	851	0.010826	0.021818	0.002998	90	90	90	0	0	1	-360	360	-16.3398	0.4053	16.3640	-0.7156	0.0000	0.0000	0.0000	0.0000;
	1098	1123	0.000413	0.000744	6.8e-05	90	90	90	0	0	1	-360	360	-9.3140	0.4537	9.3143	-0.4613	0.0000	0.0000	0.0000	0.0000;
	1121	1123	0.00124	0.002149	0.000208	90	90	90	0	0	1	-360	360	-7.0250	-0.0800	7.0255	0.0560	0.0000	0.0000	0.0000	0.0000;
	1924	850	0.004545	0.007934	0.000833	90	90	90	0	0	1	-360	360	-1.7000	-0.6880	1.7001	0.5884	0.0000	0.0000	0.0000	0.0000;
	1925	851	0.004545	0.007934	0.000833	90	90	90	0	0	1	-360	360	-11.2270	-1.7210	11.2319	1.6297	0.0000	0.0000	0.0000	0.0000;
	1679	850	0.004132	0.010992	0.001735	114	114	114	0	0	1	-360	360	-20.1501	-2.8972	20.1644	2.7273	0.0000	0.0000	0.0000	0.0000;
	1233	1743	0.006777	0.01124	0.001191	29	29	29	0	0	1	-360	360	3.1766	0.6188	-3.1760	-0.7600	0.0000	0.0000	0.0000	0.0000;
	1234	1744	0.006777	0.01124	0.001191	57	57	57	0	0	1	-360	360	7.7145	1.5247	-7.7110	-1.6610	0.0000	0.0000	0.0000	0.0000;
	1576	1417	0.037025	0.06719	0.006691	90	90	90	0	0	1	-360	360	18.7002	4.9551	-18.5835	-5.5398	0.0000	0.0000	0.0000	0.0000;
	1556	1417	0.014876	0.028099	0.002979	78	78	78	0	0	1	-360	360	1.5515	-1.0471	-1.5511	0.6964	0.0000	0.0000	0.0000	0.0000;
	1875	1418	0.007603	0.011735	0.001496	90	90	90	0	0	1	-360	360	4.8241	-1.9401	-4.8224	1.7663	0.0000	0.0000	0.0000	0.0000;
	1874	1875	0.000992	0.001736	0.000165	90	90	90	0	0	1	-360	360	6.2491	-1.7118	-6.2487	1.6930	0.0000	0.0000	0.0000	0.0000;
	1451	1874	0.006198	0.007769	0.001481	90	90	90	0	0	1	-360	360	-0.3143	-0.7663	0.3143	0.5915	0.0000	0.0000	0.0000	0.0000;
	1556	1875	0.007273	0.014545	0.001549	90	90	90	0	0	1	-360	360	-1.4245	-0.4296	1.4246	0.2471	0.0000	0.0000	0.0000	0.0000;
	1221	1874	0.019008	0.033058	0.003151	90	90	90	0	0	1	-360	360	6.5706	-1.4799	-6.5634	1.1203	0.0000	0.0000	0.0000	0.0000;
	1923	1293	0.019091	0.057769	0.006863	114	114	114	0	0	1	-360	360	-18.1093	1.5329	18.1633	-2.1754	0.0000	0.0000	0.0000	0.0000;
	1863	1132	0.007025	0.015703	0.001757	90	90	90	0	0	1	-360	360	11.3471	0.0868	-11.3395	-0.2798	0.0000	0.0000	0.0000	0.0000;
	1131	850	0.010826	0.032727	0.003884	114	114	114	0	0	1	-360	360	-21.3256	-1.2781	21.3669	0.9382	0.0000	0.0000	0.0000	0.0000;
	1626	851	0.008595	0.026033	0.00309	114	114	114	0	0	1	-360	360	-14.1130	-0.9002	14.1274	0.5735	0.0000	0.0000	0.0000	0.0000;
	1692	1277	0.028347	0.06595	0.009854	120	120	120	0	0	1	-360	360	-11.3598	2.1605	11.3928	-3.2379	0.0000	0.0000	0.0000	0.0000;
	1922	1692	0.008595	0.026033	0.003095	114	114	114	0	0	1	-360	360	16.4081	-1.7592	-16.3881	1.4571	0.0000	0.0000	0.0000	0.0000;
	1691	1672	0.015703	0.047686	0.005665	114	114	114	0	0	1	-360	360	-0.2977	0.7495	0.2979	-1.4115	0.0000	0.0000	0.0000	0.0000;
	1723	1485	0.014711	0.02595	0.002841	57	57	57	0	0	1	-360	360	11.3557	-2.2591	-11.3390	1.9551	0.0000	0.0000	0.0000	0.0000;
	1884	1262	0.003058	0.00843	0.001447	114	114	114	0	0	1	-360	360	-25.7334	1.0531	25.7502	-1.1814	0.0000	0.0000	0.0000	0.0000;
	1363	1310	0.011901	0.036116	0.004264	114	114	114	0	0	1	-360	360	4.8789	-0.3958	-4.8766	-0.1041	0.0000	0.0000	0.0000	0.0000;
	1311	893	0.008843	0.026777	0.003178	114	114	114	0	0	1	-360	360	2.7216	-0.1370	-2.7210	-0.2390	0.0000	0.0000	0.0000	0.0000;
	1722	1000	0.026777	0.063223	0.007267	57	57	57	0	0	1	-360	360	-14.1958	1.5721	14.2426	-2.3172	0.0000	0.0000	0.0000	0.0000;
	1570	1510	0.031983	0.102397	0.010846	114	114	114	0	0	1	-360	360	1.6565	-10.6156	-1.6287	9.4143	0.0000	0.0000	0.0000	0.0000;
	1262	1211	0.036116	0.11595	0.012221	114	114	114	0	0	1	-360	360	-2.3773	-2.5102	2.3800	1.0393	0.0000	0.0000	0.0000	0.0000;
	1863	1639	0.023636	0.076942	0.007921	114	114	114	0	0	1	-360	360	-0.3784	-0.5163	0.3784	-0.4308	0.0000	0.0000	0.0000	0.0000;
	1883	1242	0.02281	0.041818	0.008523	120	120	120	0	0	1	-360	360	18.1379	-2.5757	-18.0749	1.6660	0.0000	0.0000	0.0000	0.0000;
	947	1234	0	0.000826	7e-06	120	120	120	0	0	1	-360	360	-6.7587	1.7950	6.7587	-1.7955	0.0000	0.0000	0.0000	0.0000;
	1863	947	0.009504	0.03	0.003308	120	120	120	0	0	1	-360	360	-2.2163	1.8455	2.2170	-2.2386	0.0000	0.0000	0.0000	0.0000;
	946	947	0.009504	0.032231	0.003073	140	140	140	0	0	1	-360	360	-4.5400	-0.8050	4.5417	0.4436	0.0000	0.0000	0.0000	0.0000;
	1863	898	0.004298	0.013471	0.001493	114	114	114	0	0	1	-360	360	1.3312	2.6065	-1.3309	-2.7840	0.0000	0.0000	0.0000	0.0000;
	1264	1864	0.040579	0.104959	0.011437	120	120	120	0	0	1	-360	360	-7.1244	-4.2960	7.1460	2.9716	0.0000	0.0000	0.0000	0.0000;
	1864	1577	0.017521	0.031983	0.00311	90	90	90	0	0	1	-360	360	26.0731	5.2264	-25.9707	-5.4149	0.0000	0.0000	0.0000	0.0000;
	1642	1627	0.003141	0.009504	0.001125	114	114	114	0	0	1	-360	360	-7.6394	-0.3137	7.6410	0.1838	0.0000	0.0000	0.0000	0.0000;
	1640	1642	0	0.000826	1e-05	114	114	114	0	0	1	-360	360	-7.6394	-0.3156	7.6394	0.3149	0.0000	0.0000	0.0000	0.0000;
	1641	1642	0	0.000826	1e-05	114	114	114	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0012	0.0000	0.0000	0.0000	0.0000;
	1234	1678	0.005537	0.013967	0.002464	114	114	114	0	0	1	-360	360	-13.9036	-2.2878	13.9128	2.0164	0.0000	0.0000	0.0000	0.0000;
	1450	1556	0.002149	0.006033	0.000632	90	90	90	0	0	1	-360	360	5.3178	-0.1663	-5.3172	0.0932	0.0000	0.0000	0.0000	0.0000;
	954	850	0.005455	0.017521	0.001847	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.2215	0.0000	0.0000	0.0000	0.0000;
	955	851	0.004959	0.017521	0.001847	114	114	114	0	0	1	-360	360	-3.3980	0.0000	3.3985	-0.2197	0.0000	0.0000	0.0000	0.0000;
	1247	930	0.019008	0.060413	0.006548	114	114	114	0	0	1	-360	360	6.6405	4.5210	-6.6292	-5.2351	0.0000	0.0000	0.0000	0.0000;
	1907	929	0.005041	0.015289	0.001815	114	114	114	0	0	1	-360	360	14.6273	-0.8370	-14.6178	0.6585	0.0000	0.0000	0.0000	0.0000;
	1248	847	0.014215	0.025041	0.002563	90	90	90	0	0	1	-360	360	0.1894	1.9285	-0.1889	-2.2220	0.0000	0.0000	0.0000	0.0000;
	931	1698	0.02157	0.068265	0.007163	114	114	114	0	0	1	-360	360	-0.8897	8.9786	0.9063	-9.7483	0.0000	0.0000	0.0000	0.0000;
	1284	1220	0.015454	0.052066	0.004997	114	114	114	0	0	1	-360	360	-19.1091	4.4136	19.1608	-4.8184	0.0000	0.0000	0.0000	0.0000;
	1824	1284	0.012645	0.030248	0.004257	114	114	114	0	0	1	-360	360	-4.7261	1.7449	4.7290	-2.2310	0.0000	0.0000	0.0000	0.0000;
	1044	932	0.002727	0.007438	0.000806	114	114	114	0	0	1	-360	360	10.2136	10.5700	-10.2085	-10.6492	0.0000	0.0000	0.0000	0.0000;
	1665	1021	0.025372	0.042231	0.00635	90	90	90	0	0	1	-360	360	-17.2409	-2.1571	17.3068	1.5294	0.0000	0.0000	0.0000	0.0000;
	1876	1430	0.001488	0.004793	0.000494	114	114	114	0	0	1	-360	360	-55.4901	-16.6992	55.5347	16.7874	0.0000	0.0000	0.0000	0.0000;
	1817	1876	0.013223	0.031322	0.003403	90	90	90	0	0	1	-360	360	13.0152	10.1256	-12.9830	-10.4319	0.0000	0.0000	0.0000	0.0000;
	1698	1816	0.008182	0.025041	0.002943	114	114	114	0	0	1	-360	360	29.0212	13.2852	-28.9479	-13.3950	0.0000	0.0000	0.0000	0.0000;
	1930	1728	0.009008	0.015041	0.001619	90	90	90	0	0	1	-360	360	12.1683	2.4402	-12.1560	-2.6041	0.0000	0.0000	0.0000	0.0000;
	1409	1313	0.003306	0.007934	0.000903	120	120	120	0	0	1	-360	360	-40.1841	3.3032	40.2304	-3.2972	0.0000	0.0000	0.0000	0.0000;
	1427	842	0.004711	0.014215	0.001689	114	114	114	0	0	1	-360	360	14.0363	5.3540	-14.0271	-5.5224	0.0000	0.0000	0.0000	0.0000;
	1045	1411	0.002975	0.007025	0.000992	114	114	114	0	0	1	-360	360	-14.8148	-11.3175	14.8237	11.2237	0.0000	0.0000	0.0000	0.0000;
	1718	1285	0.015868	0.042645	0.004371	114	114	114	0	0	1	-360	360	-8.0797	-11.1870	8.1052	10.7495	0.0000	0.0000	0.0000	0.0000;
	1750	1697	0.026116	0.033802	0.0062	90	90	90	0	0	1	-360	360	35.3708	-2.9295	-35.0872	2.5834	0.0000	0.0000	0.0000	0.0000;
	1825	843	0.004132	0.012479	0.001484	114	114	114	0	0	1	-360	360	-6.7869	-3.9384	6.7891	3.7730	0.0000	0.0000	0.0000	0.0000;
	1022	1285	0.008595	0.026529	0.003035	114	114	114	0	0	1	-360	360	-5.6799	6.7445	5.6858	-7.0798	0.0000	0.0000	0.0000	0.0000;
	1497	1698	0.00281	0.009008	0.000975	114	114	114	0	0	1	-360	360	10.2908	-3.8068	-10.2879	3.7050	0.0000	0.0000	0.0000	0.0000;
	1219	1572	0.010331	0.032314	0.003596	114	114	114	0	0	1	-360	360	-20.4191	4.3866	20.4581	-4.6815	0.0000	0.0000	0.0000	0.0000;
	1892	1011	0.020579	0.051488	0.006086	114	114	114	0	0	1	-360	360	-1.8577	2.4781	1.8597	-3.1744	0.0000	0.0000	0.0000	0.0000;
	1239	1011	0.004628	0.008347	0.001747	114	114	114	0	0	1	-360	360	-26.1787	0.6031	26.2063	-0.7542	0.0000	0.0000	0.0000	0.0000;
	1819	1573	0.019174	0.06157	0.00651	114	114	114	0	0	1	-360	360	-16.5399	-1.0373	16.5855	0.4309	0.0000	0.0000	0.0000	0.0000;
	849	1819	0.018017	0.023884	0.004291	90	90	90	0	0	1	-360	360	-11.8874	-0.4867	11.9096	0.0224	0.0000	0.0000	0.0000	0.0000;
	1818	1819	0.006694	0.008347	0.001585	29	29	29	0	0	1	-360	360	-4.6290	-1.1960	4.6303	1.0150	0.0000	0.0000	0.0000	0.0000;
	1889	1224	0.017025	0.051984	0.00611	114	114	114	0	0	1	-360	360	-14.1742	-4.6346	14.2067	4.0286	0.0000	0.0000	0.0000	0.0000;
	1756	1889	0.040909	0.053884	0.009864	90	90	90	0	0	1	-360	360	-24.2140	-2.6079	24.4283	1.7675	0.0000	0.0000	0.0000	0.0000;
	1609	1284	0.006612	0.020661	0.002331	114	114	114	0	0	1	-360	360	26.7308	-3.8399	-26.6892	3.6995	0.0000	0.0000	0.0000	0.0000;
	1930	1284	0.025124	0.076198	0.009039	114	114	114	0	0	1	-360	360	-22.0923	-4.9612	22.2042	4.2623	0.0000	0.0000	0.0000	0.0000;
	1846	1817	0.01438	0.046198	0.004867	114	114	114	0	0	1	-360	360	-5.0060	-1.2240	5.0093	0.6852	0.0000	0.0000	0.0000	0.0000;
	1610	1931	0.02876	0.090165	0.010016	114	114	114	0	0	1	-360	360	-10.5784	-3.0368	10.6082	1.9827	0.0000	0.0000	0.0000	0.0000;
	1284	1024	0.002645	0.008017	0.000949	114	114	114	0	0	1	-360	360	0.0000	-0.1098	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1666	1931	0.019587	0.03124	0.005114	90	90	90	0	0	1	-360	360	10.6278	1.4242	-10.6082	-1.9827	0.0000	0.0000	0.0000	0.0000;
	1248	1719	0.003719	0.009835	0.00098	114	114	114	0	0	1	-360	360	-2.5611	-10.2296	2.5646	10.1263	0.0000	0.0000	0.0000	0.0000;
	1890	1572	0.024215	0.076859	0.008327	114	114	114	0	0	1	-360	360	-22.8855	-0.1526	22.9959	-0.4587	0.0000	0.0000	0.0000	0.0000;
	1012	1572	0.007686	0.024711	0.002594	114	114	114	0	0	1	-360	360	29.8318	2.3569	-29.7727	-2.4687	0.0000	0.0000	0.0000	0.0000;
	1011	1573	0.007686	0.024711	0.002594	114	114	114	0	0	1	-360	360	-26.8918	-9.3292	26.9457	9.2027	0.0000	0.0000	0.0000	0.0000;
	1247	1572	0.019256	0.061983	0.006515	114	114	114	0	0	1	-360	360	-22.6029	-2.0784	22.6890	1.6032	0.0000	0.0000	0.0000	0.0000;
	1429	1115	0.002975	0.013058	0.002154	114	114	114	0	0	1	-360	360	-48.1626	-16.9803	48.2315	17.0399	0.0000	0.0000	0.0000	0.0000;
	1023	1428	0.00405	0.011653	0.00129	114	114	114	0	0	1	-360	360	24.6298	7.4258	-24.6068	-7.5098	0.0000	0.0000	0.0000	0.0000;
	1836	1729	0.020331	0.065372	0.006902	114	114	114	0	0	1	-360	360	-2.3160	-0.8829	2.3170	0.1021	0.0000	0.0000	0.0000	0.0000;
	1410	1608	0.005124	0.015868	0.00181	114	114	114	0	0	1	-360	360	34.4163	-4.2587	-34.3633	4.2127	0.0000	0.0000	0.0000	0.0000;
	1835	1611	0.01562	0.050248	0.005283	114	114	114	0	0	1	-360	360	-7.9040	-2.6961	7.9134	2.1253	0.0000	0.0000	0.0000	0.0000;
	1240	1908	0.017355	0.024711	0.004378	90	90	90	0	0	1	-360	360	21.9043	-1.4275	-21.8316	1.0295	0.0000	0.0000	0.0000	0.0000;
	1412	1285	0.002893	0.009256	0.000997	114	114	114	0	0	1	-360	360	-28.4555	-14.4869	28.4809	14.4524	0.0000	0.0000	0.0000	0.0000;
	1697	1284	0.021984	0.070909	0.007446	114	114	114	0	0	1	-360	360	2.9413	-12.6275	-2.9109	11.8690	0.0000	0.0000	0.0000	0.0000;
	1755	875	0.016364	0.02157	0.003969	90	90	90	0	0	1	-360	360	17.2355	-3.1144	-17.1912	2.7264	0.0000	0.0000	0.0000	0.0000;
	1012	1382	0.008843	0.028017	0.00303	114	114	114	0	0	1	-360	360	3.8415	0.3211	-3.8403	-0.6706	0.0000	0.0000	0.0000	0.0000;
	1383	966	0.004793	0.014959	0.001658	114	114	114	0	0	1	-360	360	-0.5487	-0.6954	0.5487	0.5023	0.0000	0.0000	0.0000	0.0000;
	1285	986	0.017934	0.044876	0.005385	114	114	114	0	0	1	-360	360	-29.3459	3.2552	29.4806	-3.5468	0.0000	0.0000	0.0000	0.0000;
	941	1003	0.013471	0.042645	0.004646	140	140	140	0	0	1	-360	360	-25.2431	1.0950	25.3143	-1.4323	0.0000	0.0000	0.0000	0.0000;
	964	941	8.3e-05	0.000248	2.4e-05	114	114	114	0	0	1	-360	360	-13.9069	2.5261	13.9070	-2.5286	0.0000	0.0000	0.0000	0.0000;
	939	941	0.004628	0.014132	0.00167	114	114	114	0	0	1	-360	360	-11.3310	-1.6200	11.3360	1.4336	0.0000	0.0000	0.0000	0.0000;
	1643	1334	0.040248	0.070579	0.006735	90	90	90	0	0	1	-360	360	11.3789	0.1376	-11.3356	-0.8718	0.0000	0.0000	0.0000	0.0000;
	949	1643	0.019669	0.040579	0.003599	90	90	90	0	0	1	-360	360	-42.7314	-2.1027	43.0341	2.2959	0.0000	0.0000	0.0000	0.0000;
	1540	949	0.006942	0.018678	0.001767	90	90	90	0	0	1	-360	360	-40.4790	-1.6112	40.5753	1.6609	0.0000	0.0000	0.0000	0.0000;
	1597	1540	0.000661	0.001157	0.000169	90	90	90	0	0	1	-360	360	-40.4698	-1.6204	40.4790	1.6164	0.0000	0.0000	0.0000	0.0000;
	948	949	0.002727	0.003636	0.000322	75	75	75	0	0	1	-360	360	-2.1560	-0.4800	2.1561	0.4419	0.0000	0.0000	0.0000	0.0000;
	1538	1540	0.000165	0.000496	4.4e-05	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0052	0.0000	0.0000	0.0000	0.0000;
	1483	1064	0.002149	0.006612	0.000779	114	114	114	0	0	1	-360	360	46.5521	1.7408	-46.5127	-1.7116	0.0000	0.0000	0.0000	0.0000;
	1759	1362	0.012562	0.045041	0.004371	114	114	114	0	0	1	-360	360	-42.6127	-15.1720	42.8269	15.4122	0.0000	0.0000	0.0000	0.0000;
	1873	918	0.01	0.025124	0.002819	120	120	120	0	0	1	-360	360	16.5615	9.2356	-16.5310	-9.4930	0.0000	0.0000	0.0000	0.0000;
	1896	1873	0.005868	0.020909	0.002072	140	140	140	0	0	1	-360	360	27.9564	10.9751	-27.9120	-11.0641	0.0000	0.0000	0.0000	0.0000;
	1917	1873	8.3e-05	0.000331	3.6e-05	140	140	140	0	0	1	-360	360	-11.3504	-1.8325	11.3505	1.8285	0.0000	0.0000	0.0000	0.0000;
	861	1917	0.000331	0.000992	0.000121	114	114	114	0	0	1	-360	360	-9.0820	-1.9430	9.0822	1.9293	0.0000	0.0000	0.0000	0.0000;
	1915	1917	0.004463	0.013636	0.001619	140	140	140	0	0	1	-360	360	-2.2680	-0.0950	2.2682	-0.0969	0.0000	0.0000	0.0000	0.0000;
	852	1112	0.013967	0.043388	0.004898	140	140	140	0	0	1	-360	360	-17.5863	-4.1091	17.6239	3.6358	0.0000	0.0000	0.0000	0.0000;
	1590	1286	0.02281	0.063967	0.009043	140	140	140	0	0	1	-360	360	-62.8177	-2.8985	63.5861	3.9773	0.0000	0.0000	0.0000	0.0000;
	1434	1548	0.006694	0.017273	0.002389	120	120	120	0	0	1	-360	360	12.1245	-2.4480	-12.1158	2.1894	0.0000	0.0000	0.0000	0.0000;
	1434	1193	0.004545	0.013967	0.001283	120	120	120	0	0	1	-360	360	9.9167	-0.1710	-9.9129	0.0318	0.0000	0.0000	0.0000	0.0000;
	1194	918	0.005702	0.01719	0.002118	140	140	140	0	0	1	-360	360	-13.5726	-9.7021	13.5860	9.4930	0.0000	0.0000	0.0000	0.0000;
	1855	1433	0.013636	0.033967	0.003707	120	120	120	0	0	1	-360	360	8.9086	-2.5569	-8.8988	2.1453	0.0000	0.0000	0.0000	0.0000;
	1433	1545	0.008595	0.021405	0.002282	120	120	120	0	0	1	-360	360	-13.3929	0.6946	13.4061	-0.9303	0.0000	0.0000	0.0000	0.0000;
	1199	1544	0.009256	0.022645	0.002543	120	120	120	0	0	1	-360	360	14.5559	-0.7832	-14.5392	0.5241	0.0000	0.0000	0.0000	0.0000;
	1588	1199	0.004876	0.013471	0.001566	120	120	120	0	0	1	-360	360	15.1313	-0.8489	-15.1219	0.6902	0.0000	0.0000	0.0000	0.0000;
	1199	1197	0.000909	0.002066	0.000237	120	120	120	0	0	1	-360	360	0.5660	0.0930	-0.5660	-0.1210	0.0000	0.0000	0.0000	0.0000;
	1434	1185	0.016694	0.045207	0.005467	120	120	120	0	0	1	-360	360	-49.6738	-4.7010	50.0266	5.0074	0.0000	0.0000	0.0000	0.0000;
	1516	1169	0.000826	0.002479	0.000269	114	114	114	0	0	1	-360	360	-80.5481	-12.3637	80.5933	12.4668	0.0000	0.0000	0.0000	0.0000;
	1096	1516	0.002149	0.003884	0.000779	120	120	120	0	0	1	-360	360	-72.9621	-11.6412	73.0591	11.7222	0.0000	0.0000	0.0000	0.0000;
	1184	1096	0.00595	0.010661	0.002222	120	120	120	0	0	1	-360	360	-72.6932	-11.5118	72.9621	11.7263	0.0000	0.0000	0.0000	0.0000;
	1516	1514	0	0.000826	7e-06	114	114	114	0	0	1	-360	360	7.4890	0.6415	-7.4890	-0.6420	0.0000	0.0000	0.0000	0.0000;
	1096	1094	0.002397	0.004876	0.000704	90	90	90	0	0	1	-360	360	0.0000	-0.0851	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1407	1633	0.008926	0.02876	0.003025	114	114	114	0	0	1	-360	360	-20.1319	-3.7684	20.1633	3.5092	0.0000	0.0000	0.0000	0.0000;
	1452	1407	0.004959	0.015868	0.001675	140	140	140	0	0	1	-360	360	-15.0145	-3.2349	15.0243	3.0675	0.0000	0.0000	0.0000	0.0000;
	1405	1407	0.002314	0.003802	0.000404	90	90	90	0	0	1	-360	360	-5.1070	-0.7480	5.1075	0.7008	0.0000	0.0000	0.0000	0.0000;
	1080	1632	0.000826	0.002562	0.000266	114	114	114	0	0	1	-360	360	-33.3891	-7.9106	33.3973	7.9041	0.0000	0.0000	0.0000	0.0000;
	864	1080	0.007934	0.025537	0.002684	140	140	140	0	0	1	-360	360	-23.6990	-6.1379	23.7389	5.9471	0.0000	0.0000	0.0000	0.0000;
	1078	1080	0.000248	0.000661	7.5e-05	114	114	114	0	0	1	-360	360	-9.6500	-1.9720	9.6502	1.9636	0.0000	0.0000	0.0000	0.0000;
	1416	1633	0.008017	0.02438	0.002553	120	120	120	0	0	1	-360	360	1.0268	-7.2316	-1.0234	6.9376	0.0000	0.0000	0.0000	0.0000;
	1415	1632	0.008099	0.025372	0.002633	120	120	120	0	0	1	-360	360	-8.4583	-3.8112	8.4640	3.5152	0.0000	0.0000	0.0000	0.0000;
	1634	1764	0.014463	0.043967	0.005193	114	114	114	0	0	1	-360	360	7.9894	4.7756	-7.9786	-5.3642	0.0000	0.0000	0.0000	0.0000;
	1673	1721	0.010083	0.031901	0.003453	114	114	114	0	0	1	-360	360	39.2456	5.2607	-39.1138	-5.2569	0.0000	0.0000	0.0000	0.0000;
	1189	1231	0.003719	0.011901	0.001251	140	140	140	0	0	1	-360	360	-3.4040	-1.3420	3.4044	1.1920	0.0000	0.0000	0.0000	0.0000;
	1377	1478	0.002231	0.006612	0.000789	114	114	114	0	0	1	-360	360	20.8619	2.8232	-20.8537	-2.8950	0.0000	0.0000	0.0000	0.0000;
	1814	1799	0.009587	0.030744	0.003233	114	114	114	0	0	1	-360	360	-16.6996	-5.6877	16.7250	5.3906	0.0000	0.0000	0.0000	0.0000;
	1437	1622	0.000992	0.003058	0.000346	114	114	114	0	0	1	-360	360	-93.1053	-17.4181	93.1796	17.6056	0.0000	0.0000	0.0000	0.0000;
	1644	1437	0.005785	0.01843	0.001951	114	114	114	0	0	1	-360	360	-72.8520	-9.3578	73.1152	9.9636	0.0000	0.0000	0.0000	0.0000;
	1435	1437	0.000826	0.002397	0.000281	114	114	114	0	0	1	-360	360	-19.9870	-7.4790	19.9901	7.4545	0.0000	0.0000	0.0000	0.0000;
	1841	1643	0.011901	0.036446	0.004262	114	114	114	0	0	1	-360	360	63.3163	5.6485	-62.9240	-4.9655	0.0000	0.0000	0.0000	0.0000;
	1142	944	0.004215	0.013306	0.001433	114	114	114	0	0	1	-360	360	-15.2301	-1.2886	15.2384	1.1451	0.0000	0.0000	0.0000	0.0000;
	1739	1282	0.005207	0.01595	0.001873	140	140	140	0	0	1	-360	360	-0.4363	0.5672	0.4363	-0.7884	0.0000	0.0000	0.0000	0.0000;
	1058	1036	0.005455	0.017107	0.001917	140	140	140	0	0	1	-360	360	-4.6639	-2.0834	4.6650	1.8570	0.0000	0.0000	0.0000	0.0000;
	1881	1476	0.004793	0.014628	0.001774	114	114	114	0	0	1	-360	360	-38.3693	-2.5790	38.4289	2.5500	0.0000	0.0000	0.0000	0.0000;
	992	1881	0.001901	0.006116	0.000646	114	114	114	0	0	1	-360	360	-34.9437	-1.6546	34.9633	1.6410	0.0000	0.0000	0.0000	0.0000;
	1879	1881	8.3e-05	0.000165	1.7e-05	114	114	114	0	0	1	-360	360	-3.4060	-0.9400	3.4060	0.9380	0.0000	0.0000	0.0000	0.0000;
	992	1615	0.001405	0.004132	0.000426	114	114	114	0	0	1	-360	360	29.6147	-0.8964	-29.6043	0.8765	0.0000	0.0000	0.0000	0.0000;
	1436	1622	0.001488	0.004628	0.000549	114	114	114	0	0	1	-360	360	9.4760	4.6700	-9.4746	-4.7317	0.0000	0.0000	0.0000	0.0000;
	937	1368	0.006777	0.021984	0.002297	114	114	114	0	0	1	-360	360	21.5824	1.8355	-21.5559	-2.0243	0.0000	0.0000	0.0000	0.0000;
	1081	1419	0.008099	0.020661	0.002323	120	120	120	0	0	1	-360	360	-0.1819	1.1771	0.1821	-1.4542	0.0000	0.0000	0.0000	0.0000;
	1633	1081	0.000496	0.001488	0.000162	114	114	114	0	0	1	-360	360	-0.1819	1.1173	0.1819	-1.1366	0.0000	0.0000	0.0000	0.0000;
	1081	1079	0.000909	0.002893	0.000339	57	57	57	0	0	1	-360	360	0.0000	-0.0405	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1135	972	0.001736	0.005289	0.000617	57	57	57	0	0	1	-360	360	-4.9860	-0.9720	4.9864	0.8983	0.0000	0.0000	0.0000	0.0000;
	1842	1322	0.012975	0.041074	0.004484	140	140	140	0	0	1	-360	360	20.0129	2.4319	-19.9692	-2.8350	0.0000	0.0000	0.0000	0.0000;
	1568	1740	0.003802	0.012149	0.001275	114	114	114	0	0	1	-360	360	-7.5269	-1.7236	7.5288	1.5787	0.0000	0.0000	0.0000	0.0000;
	1408	1568	0.006694	0.021653	0.002268	140	140	140	0	0	1	-360	360	8.9314	0.7024	-8.9269	-0.9563	0.0000	0.0000	0.0000	0.0000;
	865	1408	0.004463	0.014463	0.001517	114	114	114	0	0	1	-360	360	11.7708	0.7308	-11.7656	-0.8938	0.0000	0.0000	0.0000	0.0000;
	1568	1566	0.001157	0.002562	0.000254	90	90	90	0	0	1	-360	360	16.4537	2.6799	-16.4510	-2.7040	0.0000	0.0000	0.0000	0.0000;
	1406	1408	0.002314	0.003802	0.000404	90	90	90	0	0	1	-360	360	-2.8340	-0.2390	2.8342	0.1914	0.0000	0.0000	0.0000	0.0000;
	1739	1143	0.004463	0.014297	0.001515	114	114	114	0	0	1	-360	360	-10.9087	-2.9902	10.9135	2.8264	0.0000	0.0000	0.0000	0.0000;
	1231	1832	0.003306	0.010744	0.001101	140	140	140	0	0	1	-360	360	3.8595	1.7224	-3.8590	-1.8540	0.0000	0.0000	0.0000	0.0000;
	1231	1031	0.001405	0.004463	0.000469	114	114	114	0	0	1	-360	360	0.0000	-0.0568	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1479	1002	0.002397	0.007273	0.000857	140	140	140	0	0	1	-360	360	20.8534	2.8920	-20.8447	-2.9695	0.0000	0.0000	0.0000	0.0000;
	1842	1472	0.003802	0.01157	0.00137	140	140	140	0	0	1	-360	360	27.5146	8.6448	-27.4884	-8.7308	0.0000	0.0000	0.0000	0.0000;
	1623	1843	0.018347	0.056777	0.006459	114	114	114	0	0	1	-360	360	-47.3673	-5.1239	47.7135	5.4119	0.0000	0.0000	0.0000	0.0000;
	1097	977	0.000992	0.002893	0.000349	140	140	140	0	0	1	-360	360	47.8193	9.6460	-47.7999	-9.6317	0.0000	0.0000	0.0000	0.0000;
	1517	1097	0.001488	0.004463	0.00053	140	140	140	0	0	1	-360	360	47.8484	9.6127	-47.8193	-9.5899	0.0000	0.0000	0.0000	0.0000;
	1843	1517	0.004298	0.013388	0.001474	140	140	140	0	0	1	-360	360	47.9324	9.6935	-47.8484	-9.6118	0.0000	0.0000	0.0000	0.0000;
	1097	1095	0.001322	0.003884	0.000462	140	140	140	0	0	1	-360	360	0.0000	-0.0562	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1515	1517	0	0.000826	7e-06	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0009	0.0000	0.0000	0.0000	0.0000;
	1195	917	0.002727	0.008347	0.000973	140	140	140	0	0	1	-360	360	0.5483	-0.5589	-0.5483	0.4445	0.0000	0.0000	0.0000	0.0000;
	1914	1195	0.002231	0.007603	0.000728	140	140	140	0	0	1	-360	360	-4.3506	2.4372	4.3510	-2.5212	0.0000	0.0000	0.0000	0.0000;
	1911	1914	8.3e-05	0.000165	1.7e-05	140	140	140	0	0	1	-360	360	-4.3506	2.4341	4.3506	-2.4361	0.0000	0.0000	0.0000	0.0000;
	1193	1195	0.003141	0.009669	0.001125	140	140	140	0	0	1	-360	360	4.9003	-3.2097	-4.8994	3.0801	0.0000	0.0000	0.0000	0.0000;
	1913	1914	0	0.000826	1e-05	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0011	0.0000	0.0000	0.0000	0.0000;
	1251	1111	0.001074	0.003388	0.000387	140	140	140	0	0	1	-360	360	-8.9727	-6.1673	8.9737	6.1246	0.0000	0.0000	0.0000	0.0000;
	1839	1251	0.004545	0.013884	0.001614	140	140	140	0	0	1	-360	360	-7.3832	-5.9774	7.3867	5.7957	0.0000	0.0000	0.0000	0.0000;
	1251	1249	0.001157	0.001488	0.000281	90	90	90	0	0	1	-360	360	1.5860	0.3716	-1.5860	-0.4050	0.0000	0.0000	0.0000	0.0000;
	921	1111	0.001074	0.003388	0.000387	140	140	140	0	0	1	-360	360	-23.9492	-12.0457	23.9557	12.0200	0.0000	0.0000	0.0000	0.0000;
	1888	921	0.003884	0.011901	0.001375	114	114	114	0	0	1	-360	360	-19.3967	-11.2981	19.4131	11.1851	0.0000	0.0000	0.0000	0.0000;
	919	921	0.000661	0.001901	0.000225	114	114	114	0	0	1	-360	360	-4.5360	-0.8870	4.5361	0.8605	0.0000	0.0000	0.0000	0.0000;
	1270	1111	0.009339	0.025289	0.002592	120	120	120	0	0	1	-360	360	-1.4878	-2.5015	1.4884	2.1945	0.0000	0.0000	0.0000	0.0000;
	1720	1270	0.005702	0.014545	0.001534	120	120	120	0	0	1	-360	360	4.1807	-1.4986	-4.1798	1.3184	0.0000	0.0000	0.0000	0.0000;
	1270	1267	0.005537	0.009339	0.00097	90	90	90	0	0	1	-360	360	5.6676	1.1832	-5.6660	-1.2960	0.0000	0.0000	0.0000	0.0000;
	1399	1111	0.009339	0.025289	0.002592	120	120	120	0	0	1	-360	360	0.6742	-2.0447	-0.6739	1.7368	0.0000	0.0000	0.0000	0.0000;
	1317	1399	0.005702	0.01438	0.001513	120	120	120	0	0	1	-360	360	0.6744	-2.3385	-0.6742	2.1591	0.0000	0.0000	0.0000	0.0000;
	1721	1317	8.3e-05	0.000248	1.9e-05	140	140	140	0	0	1	-360	360	12.5728	1.0547	-12.5727	-1.0567	0.0000	0.0000	0.0000	0.0000;
	1399	1398	0.005537	0.009256	0.000961	90	90	90	0	0	1	-360	360	0.0000	-0.1144	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1316	1317	0.000165	0.000413	5.3e-05	140	140	140	0	0	1	-360	360	-11.8980	-3.4010	11.8982	3.3952	0.0000	0.0000	0.0000	0.0000;
	1361	1287	0.000496	0.001488	0.000177	140	140	140	0	0	1	-360	360	-61.0388	-16.1528	61.0552	16.1806	0.0000	0.0000	0.0000	0.0000;
	1361	1287	0.000496	0.001488	0.000177	140	140	140	0	0	1	-360	360	-61.0388	-16.1528	61.0552	16.1806	0.0000	0.0000	0.0000	0.0000;
	1139	1110	0.012479	0.038265	0.004414	114	114	114	0	0	1	-360	360	17.6543	3.2490	-17.6208	-3.6768	0.0000	0.0000	0.0000	0.0000;
	1361	1139	0.000909	0.003388	0.00039	114	114	114	0	0	1	-360	360	17.6567	3.1956	-17.6543	-3.2335	0.0000	0.0000	0.0000	0.0000;
	1137	1139	0.000413	0.001322	0.000128	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0155	0.0000	0.0000	0.0000	0.0000;
	1655	1112	0.00876	0.026942	0.003112	114	114	114	0	0	1	-360	360	11.5588	7.6300	-11.5447	-7.9641	0.0000	0.0000	0.0000	0.0000;
	1140	1655	0.003802	0.012066	0.001396	140	140	140	0	0	1	-360	360	13.2654	8.0407	-13.2578	-8.1867	0.0000	0.0000	0.0000	0.0000;
	1362	1140	0.000826	0.002562	0.000293	114	114	114	0	0	1	-360	360	43.8782	14.5211	-43.8637	-14.5119	0.0000	0.0000	0.0000	0.0000;
	1654	1655	0.002066	0.006364	0.000753	140	140	140	0	0	1	-360	360	-1.6990	-0.6480	1.6991	0.5567	0.0000	0.0000	0.0000	0.0000;
	1136	1140	0.000413	0.001322	0.00016	114	114	114	0	0	1	-360	360	-30.5950	-6.4800	30.5983	6.4712	0.0000	0.0000	0.0000	0.0000;
	1030	1878	0.001488	0.004876	0.000511	84	84	84	0	0	1	-360	360	-6.7590	-0.4477	6.7596	0.3886	0.0000	0.0000	0.0000	0.0000;
	1420	1030	0.004959	0.013223	0.0015	120	120	120	0	0	1	-360	360	-6.7571	-0.6519	6.7590	0.4778	0.0000	0.0000	0.0000	0.0000;
	1029	1030	0.000661	0.002149	0.000252	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0301	0.0000	0.0000	0.0000	0.0000;
	1782	1773	0.003306	0.010413	0.001147	140	140	140	0	0	1	-360	360	-9.9985	-2.9656	10.0015	2.8370	0.0000	0.0000	0.0000	0.0000;
	1150	1526	0.011983	0.037107	0.004211	140	140	140	0	0	1	-360	360	-21.5203	-2.3560	21.5670	1.9945	0.0000	0.0000	0.0000	0.0000;
	1380	972	0.004545	0.013967	0.001619	140	140	140	0	0	1	-360	360	-36.5484	-7.8674	36.6010	7.8331	0.0000	0.0000	0.0000	0.0000;
	1814	1800	0.004215	0.009752	0.002043	140	140	140	0	0	1	-360	360	-49.0131	-11.0708	49.1042	11.0424	0.0000	0.0000	0.0000	0.0000;
	1614	925	0.005702	0.015041	0.001646	120	120	120	0	0	1	-360	360	27.5647	-1.3678	-27.5281	1.2696	0.0000	0.0000	0.0000	0.0000;
	1339	925	0.001322	0.002645	0.000237	57	57	57	0	0	1	-360	360	-5.0990	-1.2960	5.0993	1.2686	0.0000	0.0000	0.0000	0.0000;
	1340	926	0.001322	0.002645	0.000237	57	57	57	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0285	0.0000	0.0000	0.0000	0.0000;
	1844	1658	0.002893	0.007025	0.000779	120	120	120	0	0	1	-360	360	6.8051	0.8406	-6.8040	-0.9310	0.0000	0.0000	0.0000	0.0000;
	1845	1659	0.002893	0.007025	0.000779	120	120	120	0	0	1	-360	360	6.2360	0.8401	-6.2350	-0.9310	0.0000	0.0000	0.0000	0.0000;
	1625	1110	0.003719	0.009008	0.000999	120	120	120	0	0	1	-360	360	-7.3330	-3.2829	7.3350	3.1679	0.0000	0.0000	0.0000	0.0000;
	1845	1625	0.004628	0.01438	0.001626	140	140	140	0	0	1	-360	360	-5.7452	-3.3026	5.7469	3.1132	0.0000	0.0000	0.0000	0.0000;
	1624	1625	0.002645	0.006116	0.00129	140	140	140	0	0	1	-360	360	-1.5860	-0.3240	1.5861	0.1697	0.0000	0.0000	0.0000	0.0000;
	1844	1110	0.008347	0.023471	0.002628	120	120	120	0	0	1	-360	360	-7.0831	-3.4393	7.0873	3.1366	0.0000	0.0000	0.0000	0.0000;
	1252	1110	0.00157	0.004793	0.000566	140	140	140	0	0	1	-360	360	9.5608	-1.9684	-9.5595	1.9043	0.0000	0.0000	0.0000	0.0000;
	1471	1252	0.007438	0.022562	0.00266	140	140	140	0	0	1	-360	360	16.7175	-1.2163	-16.7001	0.9499	0.0000	0.0000	0.0000	0.0000;
	1853	1471	0.000992	0.003306	0.000351	140	140	140	0	0	1	-360	360	18.0812	-1.0199	-18.0785	0.9868	0.0000	0.0000	0.0000	0.0000;
	1252	1250	0.000744	0.001405	0.000293	120	120	120	0	0	1	-360	360	7.1393	1.0185	-7.1390	-1.0530	0.0000	0.0000	0.0000	0.0000;
	1469	1471	0.000248	0.000496	4.6e-05	90	90	90	0	0	1	-360	360	-1.3610	-0.2350	1.3610	0.2295	0.0000	0.0000	0.0000	0.0000;
	1295	1110	0.00876	0.026529	0.003124	140	140	140	0	0	1	-360	360	-11.0057	-3.4557	11.0153	3.1110	0.0000	0.0000	0.0000	0.0000;
	1789	1413	0.010083	0.024546	0.002715	120	120	120	0	0	1	-360	360	9.8771	-7.3937	-9.8644	7.1011	0.0000	0.0000	0.0000	0.0000;
	1827	1789	0.011901	0.029669	0.003277	120	120	120	0	0	1	-360	360	16.1466	-6.4824	-16.1166	6.1671	0.0000	0.0000	0.0000	0.0000;
	1787	1789	0.00438	0.006116	0.000777	75	75	75	0	0	1	-360	360	-6.2380	-1.3170	6.2395	1.2266	0.0000	0.0000	0.0000	0.0000;
	1790	1414	0.010083	0.024546	0.002715	120	120	120	0	0	1	-360	360	-4.6185	-4.0794	4.6216	3.7633	0.0000	0.0000	0.0000	0.0000;
	1601	1790	0.008099	0.021074	0.002386	120	120	120	0	0	1	-360	360	2.1871	-3.1052	-2.1862	2.8236	0.0000	0.0000	0.0000	0.0000;
	1788	1790	0.004132	0.005372	0.000692	75	75	75	0	0	1	-360	360	-6.8030	-1.3360	6.8047	1.2558	0.0000	0.0000	0.0000	0.0000;
	1844	1706	0.002397	0.007355	0.000857	140	140	140	0	0	1	-360	360	3.8533	1.1136	-3.8530	-1.2150	0.0000	0.0000	0.0000	0.0000;
	1231	1004	0.003141	0.013306	0.001379	162	162	162	0	0	1	-360	360	-43.9934	-6.0664	44.0446	6.1160	0.0000	0.0000	0.0000	0.0000;
	1413	1145	0.003058	0.003802	0.000721	90	90	90	0	0	1	-360	360	0.0000	-0.0860	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1414	1146	0.003141	0.003884	0.00074	90	90	90	0	0	1	-360	360	1.7001	0.9648	-1.7000	-1.0530	0.0000	0.0000	0.0000	0.0000;
	1026	1631	0.001074	0.003223	0.000378	140	140	140	0	0	1	-360	360	33.0311	6.2988	-33.0208	-6.3129	0.0000	0.0000	0.0000	0.0000;
	1720	1026	0.001818	0.00562	0.000665	140	140	140	0	0	1	-360	360	38.9483	7.7296	-38.9243	-7.7343	0.0000	0.0000	0.0000	0.0000;
	1026	1025	0.000579	0.001653	0.000194	140	140	140	0	0	1	-360	360	5.8932	1.4355	-5.8930	-1.4580	0.0000	0.0000	0.0000	0.0000;
	1378	1628	0.003141	0.021405	0.002413	114	114	114	0	0	1	-360	360	-27.4793	-6.8851	27.5005	6.7422	0.0000	0.0000	0.0000	0.0000;
	973	1276	0.006446	0.020661	0.002164	114	114	114	0	0	1	-360	360	55.3307	10.7957	-55.1613	-10.5136	0.0000	0.0000	0.0000	0.0000;
	1844	1368	0.00405	0.012397	0.00143	114	114	114	0	0	1	-360	360	-1.7560	3.4691	1.7565	-3.6385	0.0000	0.0000	0.0000	0.0000;
	884	1415	0.001983	0.006033	0.000697	140	140	140	0	0	1	-360	360	13.7047	2.6668	-13.7015	-2.7400	0.0000	0.0000	0.0000	0.0000;
	1878	884	0.004959	0.015207	0.001752	140	140	140	0	0	1	-360	360	15.8728	3.5265	-15.8618	-3.7018	0.0000	0.0000	0.0000	0.0000;
	884	882	0.001074	0.001818	0.000194	90	90	90	0	0	1	-360	360	2.1571	1.0350	-2.1570	-1.0580	0.0000	0.0000	0.0000	0.0000;
	1238	1416	0.002314	0.007438	0.000811	140	140	140	0	0	1	-360	360	-1.3617	-2.8877	1.3619	2.7918	0.0000	0.0000	0.0000	0.0000;
	1621	1238	0.005702	0.018017	0.001994	140	140	140	0	0	1	-360	360	-1.3612	-3.1257	1.3617	2.8900	0.0000	0.0000	0.0000	0.0000;
	1237	1238	8.3e-05	0.000248	1.9e-05	120	120	120	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0023	0.0000	0.0000	0.0000	0.0000;
	1232	1804	0.001901	0.004628	0.000895	140	140	140	0	0	1	-360	360	3.4052	1.5679	-3.4050	-1.6750	0.0000	0.0000	0.0000	0.0000;
	1805	1231	0.001405	0.004628	0.000489	140	140	140	0	0	1	-360	360	-37.6310	-1.1792	37.6475	1.1744	0.0000	0.0000	0.0000	0.0000;
	926	1805	0.008099	0.022645	0.002439	120	120	120	0	0	1	-360	360	-34.6013	0.1410	34.6819	-0.2098	0.0000	0.0000	0.0000	0.0000;
	1803	1805	0.000496	0.00124	0.000191	140	140	140	0	0	1	-360	360	-2.9490	-1.4120	2.9490	1.3890	0.0000	0.0000	0.0000	0.0000;
	1102	1112	0.007521	0.023058	0.002413	120	120	120	0	0	1	-360	360	-3.8530	0.0353	3.8540	-0.3241	0.0000	0.0000	0.0000	0.0000;
	1268	1102	0.000331	0.001157	0.000116	114	114	114	0	0	1	-360	360	-3.8530	-0.0810	3.8530	0.0671	0.0000	0.0000	0.0000	0.0000;
	1100	1102	0.002397	0.007521	0.000847	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.1024	0.0000	0.0000	0.0000	0.0000;
	1815	1905	0.008099	0.026116	0.002725	140	140	140	0	0	1	-360	360	40.8508	9.4084	-40.7286	-9.3310	0.0000	0.0000	0.0000	0.0000;
	1554	845	0.003636	0.011405	0.001242	140	140	140	0	0	1	-360	360	-6.0884	2.6449	6.0898	-2.7873	0.0000	0.0000	0.0000	0.0000;
	890	1554	0.00157	0.004876	0.000542	140	140	140	0	0	1	-360	360	-2.1147	4.4389	2.1151	-4.5020	0.0000	0.0000	0.0000	0.0000;
	1554	1552	0.002314	0.006942	0.000728	120	120	120	0	0	1	-360	360	3.9734	1.8571	-3.9730	-1.9420	0.0000	0.0000	0.0000	0.0000;
	1779	1016	0.001983	0.005702	0.000617	120	120	120	0	0	1	-360	360	20.3424	9.3189	-20.3340	-9.3680	0.0000	0.0000	0.0000	0.0000;
	1120	1780	0.003719	0.011322	0.001266	120	120	120	0	0	1	-360	360	14.2183	6.1235	-14.2108	-6.2511	0.0000	0.0000	0.0000	0.0000;
	885	1120	0.001901	0.005785	0.000653	140	140	140	0	0	1	-360	360	14.2221	5.9896	-14.2183	-6.0558	0.0000	0.0000	0.0000	0.0000;
	1878	885	0.004959	0.015207	0.001752	140	140	140	0	0	1	-360	360	15.3667	6.3509	-15.3551	-6.5246	0.0000	0.0000	0.0000	0.0000;
	885	883	0.001074	0.001818	0.000194	90	90	90	0	0	1	-360	360	1.1330	0.5350	-1.1330	-0.5580	0.0000	0.0000	0.0000	0.0000;
	1119	1120	0.001983	0.004545	0.000569	120	120	120	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0677	0.0000	0.0000	0.0000	0.0000;
	1232	1781	0.001901	0.005868	0.000658	140	140	140	0	0	1	-360	360	-7.5044	-2.7169	7.5054	2.6409	0.0000	0.0000	0.0000	0.0000;
	1447	1286	0.013388	0.041488	0.004726	140	140	140	0	0	1	-360	360	-47.4842	-10.6903	47.7513	10.9529	0.0000	0.0000	0.0000	0.0000;
	1801	1447	0.007603	0.02405	0.002618	140	140	140	0	0	1	-360	360	-38.9707	-8.5293	39.0735	8.5458	0.0000	0.0000	0.0000	0.0000;
	1447	1445	0.001074	0.010992	0.001752	75	75	75	0	0	1	-360	360	8.4107	2.1445	-8.4100	-2.3450	0.0000	0.0000	0.0000	0.0000;
	1446	1047	0.00876	0.027851	0.00303	140	140	140	0	0	1	-360	360	41.4487	7.8093	-41.3171	-7.7481	0.0000	0.0000	0.0000	0.0000;
	1357	1446	0.011157	0.034463	0.003913	140	140	140	0	0	1	-360	360	47.6367	9.0873	-47.4181	-8.8791	0.0000	0.0000	0.0000	0.0000;
	1286	1357	0.002314	0.007025	0.000816	140	140	140	0	0	1	-360	360	54.3891	10.9873	-54.3300	-10.9062	0.0000	0.0000	0.0000	0.0000;
	1446	1444	0.001058	0.010826	0.001726	75	75	75	0	0	1	-360	360	5.9693	1.0699	-5.9690	-1.2710	0.0000	0.0000	0.0000	0.0000;
	1357	1355	0.003223	0.006033	0.000578	90	90	90	0	0	1	-360	360	6.6933	1.8189	-6.6920	-1.8860	0.0000	0.0000	0.0000	0.0000;
	1779	1415	0.005455	0.016777	0.001914	114	114	114	0	0	1	-360	360	-10.8820	-8.0279	10.8903	7.8258	0.0000	0.0000	0.0000	0.0000;
	1904	1845	0.004215	0.009835	0.001217	120	120	120	0	0	1	-360	360	17.6632	1.0587	-17.6521	-1.1787	0.0000	0.0000	0.0000	0.0000;
	1149	1904	0.002066	0.00562	0.000593	120	120	120	0	0	1	-360	360	18.3470	1.3002	-18.3412	-1.3553	0.0000	0.0000	0.0000	0.0000;
	1903	1904	0.000661	0.002314	0.00022	120	120	120	0	0	1	-360	360	-0.6780	-0.3230	0.6780	0.2966	0.0000	0.0000	0.0000	0.0000;
	1372	1586	0.002893	0.008926	0.001004	140	140	140	0	0	1	-360	360	1.4876	-2.2798	-1.4874	2.1633	0.0000	0.0000	0.0000	0.0000;
	1815	1372	0.00595	0.019174	0.00203	140	140	140	0	0	1	-360	360	11.0245	0.8454	-11.0183	-1.0621	0.0000	0.0000	0.0000	0.0000;
	1372	1370	0.005289	0.008926	0.000927	90	90	90	0	0	1	-360	360	9.5306	3.3419	-9.5260	-3.4420	0.0000	0.0000	0.0000	0.0000;
	1037	1232	0.001653	0.005289	0.000557	120	120	120	0	0	1	-360	360	-7.3851	-2.5054	7.3859	2.4412	0.0000	0.0000	0.0000	0.0000;
	1735	1652	0.006529	0.023884	0.002338	105	105	105	0	0	1	-360	360	-7.3710	-2.1460	7.3743	1.8901	0.0000	0.0000	0.0000	0.0000;
	1906	1653	0.008017	0.026446	0.002645	140	140	140	0	0	1	-360	360	21.9169	7.4611	-21.8796	-7.6425	0.0000	0.0000	0.0000	0.0000;
	1754	1596	0.007273	0.012314	0.001788	90	90	90	0	0	1	-360	360	-32.6868	-0.5415	32.7528	0.4423	0.0000	0.0000	0.0000	0.0000;
	1843	917	0.02405	0.076281	0.008259	140	140	140	0	0	1	-360	360	63.6870	12.5320	-62.8570	-10.8905	0.0000	0.0000	0.0000	0.0000;
	1844	1038	0.003141	0.007769	0.000879	120	120	120	0	0	1	-360	360	6.2212	0.5023	-6.2202	-0.6049	0.0000	0.0000	0.0000	0.0000;
	1470	1039	0.005785	0.016116	0.001876	120	120	120	0	0	1	-360	360	-3.9534	-0.0168	3.9542	-0.2053	0.0000	0.0000	0.0000	0.0000;
	1294	1470	0.002066	0.006446	0.000748	140	140	140	0	0	1	-360	360	-1.9134	0.2156	1.9134	-0.3047	0.0000	0.0000	0.0000	0.0000;
	1468	1470	0.000248	0.000496	4.6e-05	90	90	90	0	0	1	-360	360	-2.0400	-0.3270	2.0400	0.3215	0.0000	0.0000	0.0000	0.0000;
	1799	1513	0.007438	0.023967	0.002517	140	140	140	0	0	1	-360	360	-34.2428	-5.5964	34.3190	5.5454	0.0000	0.0000	0.0000	0.0000;
	1512	1287	0.012066	0.038678	0.004075	140	140	140	0	0	1	-360	360	-1.4740	-0.7260	1.4742	0.2349	0.0000	0.0000	0.0000	0.0000;
	1651	1287	0.000496	0.003719	0.000387	152	152	152	0	0	1	-360	360	-15.0755	-5.0720	15.0766	5.0330	0.0000	0.0000	0.0000	0.0000;
	1707	1651	0.008099	0.051653	0.005365	140	140	140	0	0	1	-360	360	-14.8328	-5.6367	14.8495	5.0983	0.0000	0.0000	0.0000	0.0000;
	1845	1707	0.007686	0.023967	0.002698	114	114	114	0	0	1	-360	360	-6.1019	-4.0064	6.1053	3.6937	0.0000	0.0000	0.0000	0.0000;
	1649	1651	0.000579	0.001818	0.000218	140	140	140	0	0	1	-360	360	-0.2260	0.0000	0.2260	-0.0263	0.0000	0.0000	0.0000	0.0000;
	1705	1707	0.002231	0.007438	0.000726	140	140	140	0	0	1	-360	360	-8.7260	-2.0250	8.7275	1.9430	0.0000	0.0000	0.0000	0.0000;
	1587	881	0.002727	0.008512	0.000956	140	140	140	0	0	1	-360	360	-12.1106	-6.6994	12.1150	6.6018	0.0000	0.0000	0.0000	0.0000;
	1371	880	0.003223	0.010496	0.001104	140	140	140	0	0	1	-360	360	22.3350	4.3747	-22.3207	-4.4572	0.0000	0.0000	0.0000	0.0000;
	1046	1371	0.005289	0.016942	0.001796	140	140	140	0	0	1	-360	360	22.3583	4.1306	-22.3350	-4.2663	0.0000	0.0000	0.0000	0.0000;
	1371	1369	0.005289	0.008926	0.000927	90	90	90	0	0	1	-360	360	0.0000	-0.1084	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1784	1582	0.019256	0.061488	0.006558	140	140	140	0	0	1	-360	360	37.5937	4.8840	-37.3649	-4.9424	0.0000	0.0000	0.0000	0.0000;
	1841	1784	0.010413	0.033471	0.003533	140	140	140	0	0	1	-360	360	44.3367	6.2351	-44.1663	-6.1183	0.0000	0.0000	0.0000	0.0000;
	1783	1784	0.001653	0.005537	0.000525	140	140	140	0	0	1	-360	360	-6.5720	-1.2960	6.5726	1.2344	0.0000	0.0000	0.0000	0.0000;
	1710	1622	0.004711	0.014628	0.001667	114	114	114	0	0	1	-360	360	28.3233	0.6195	-28.2919	-0.7224	0.0000	0.0000	0.0000	0.0000;
	1492	940	0.004793	0.015785	0.001561	140	140	140	0	0	1	-360	360	4.5338	0.7847	-4.5330	-0.9720	0.0000	0.0000	0.0000	0.0000;
	1362	1492	0.007438	0.02405	0.002522	114	114	114	0	0	1	-360	360	8.5144	1.4589	-8.5099	-1.7515	0.0000	0.0000	0.0000	0.0000;
	1490	1492	8.3e-05	0.000826	1.9e-05	140	140	140	0	0	1	-360	360	-3.9760	-0.9690	3.9760	0.9668	0.0000	0.0000	0.0000	0.0000;
	1141	1361	0.000744	0.002314	0.00024	114	114	114	0	0	1	-360	360	-104.3484	-28.9134	104.4209	29.1100	0.0000	0.0000	0.0000	0.0000;
	1491	1141	0.006777	0.021736	0.002294	114	114	114	0	0	1	-360	360	-6.8150	-1.4100	6.8177	1.1428	0.0000	0.0000	0.0000	0.0000;
	1138	1141	0.000909	0.003141	0.000298	114	114	114	0	0	1	-360	360	-97.4530	-27.5380	97.5307	27.7706	0.0000	0.0000	0.0000	0.0000;
	1539	1754	0.012397	0.028265	0.002664	90	90	90	0	0	1	-360	360	-4.9860	-1.1340	4.9887	0.8268	0.0000	0.0000	0.0000	0.0000;
	1798	1869	0.009421	0.031157	0.002778	120	120	120	0	0	1	-360	360	30.3570	7.9798	-30.2798	-8.0574	0.0000	0.0000	0.0000	0.0000;
	979	943	0.015124	0.04157	0.004136	120	120	120	0	0	1	-360	360	33.0995	-3.1258	-32.9592	3.0208	0.0000	0.0000	0.0000	0.0000;
	1389	942	0.015289	0.036612	0.005537	120	120	120	0	0	1	-360	360	65.0662	8.5585	-64.5171	-7.9012	0.0000	0.0000	0.0000	0.0000;
	1432	1178	0.009339	0.031901	0.003243	140	140	140	0	0	1	-360	360	10.0611	-0.5929	-10.0532	0.2291	0.0000	0.0000	0.0000	0.0000;
	1441	1432	0.002149	0.006777	0.000772	140	140	140	0	0	1	-360	360	10.6281	-0.3727	-10.6261	0.2860	0.0000	0.0000	0.0000	0.0000;
	1432	1431	0	8.3e-05	1e-05	140	140	140	0	0	1	-360	360	0.5650	0.3068	-0.5650	-0.3080	0.0000	0.0000	0.0000	0.0000;
	1403	1178	0.005041	0.016364	0.001711	140	140	140	0	0	1	-360	360	-0.3224	-4.7559	0.3234	4.5530	0.0000	0.0000	0.0000	0.0000;
	1733	1350	0.005785	0.014463	0.001636	120	120	120	0	0	1	-360	360	-29.5658	2.4983	29.6088	-2.5854	0.0000	0.0000	0.0000	0.0000;
	1222	1350	0.034132	0.094876	0.009319	120	120	120	0	0	1	-360	360	-14.3532	2.0835	14.4146	-3.0191	0.0000	0.0000	0.0000	0.0000;
	1221	1870	0.011074	0.03281	0.002829	120	120	120	0	0	1	-360	360	-29.6253	-7.9086	29.7131	7.8329	0.0000	0.0000	0.0000	0.0000;
	1222	1919	0.006198	0.016694	0.002616	140	140	140	0	0	1	-360	360	33.9887	0.6301	-33.9282	-0.7765	0.0000	0.0000	0.0000	0.0000;
	1387	1918	0.00124	0.003802	0.000423	140	140	140	0	0	1	-360	360	-21.9892	2.1254	21.9944	-2.1596	0.0000	0.0000	0.0000	0.0000;
	1684	1732	0.007686	0.020909	0.002139	120	120	120	0	0	1	-360	360	-26.5706	3.3046	26.6172	-3.4315	0.0000	0.0000	0.0000	0.0000;
	1682	1684	0.012479	0.037851	0.004477	140	140	140	0	0	1	-360	360	-14.2758	-0.0988	14.2974	-0.3652	0.0000	0.0000	0.0000	0.0000;
	1221	1684	0.021901	0.060992	0.005953	120	120	120	0	0	1	-360	360	-12.2441	2.3162	12.2732	-2.9394	0.0000	0.0000	0.0000	0.0000;
	1221	856	0.004876	0.01314	0.001779	120	120	120	0	0	1	-360	360	18.8467	2.3928	-18.8318	-2.5626	0.0000	0.0000	0.0000	0.0000;
	996	1315	0.006198	0.019504	0.00213	140	140	140	0	0	1	-360	360	9.7793	1.7929	-9.7742	-2.0330	0.0000	0.0000	0.0000	0.0000;
	1221	1048	0.00405	0.013802	0.001314	140	140	140	0	0	1	-360	360	-4.4931	2.6890	4.4940	-2.8411	0.0000	0.0000	0.0000	0.0000;
	1049	1683	0.010248	0.031157	0.003683	140	140	140	0	0	1	-360	360	-4.8331	2.6948	4.8358	-3.1214	0.0000	0.0000	0.0000	0.0000;
	1218	1178	0.009587	0.030826	0.003265	140	140	140	0	0	1	-360	360	-34.2590	-1.8709	34.3533	1.7824	0.0000	0.0000	0.0000	0.0000;
	1458	1178	0.001405	0.004298	0.000472	140	140	140	0	0	1	-360	360	-25.7414	-10.9275	25.7506	10.8986	0.0000	0.0000	0.0000	0.0000;
	975	1209	0.007769	0.023554	0.002773	140	140	140	0	0	1	-360	360	-9.8040	0.6156	9.8105	-0.9197	0.0000	0.0000	0.0000	0.0000;
	1770	1298	0.008182	0.025537	0.002863	140	140	140	0	0	1	-360	360	19.7340	-4.1659	-19.7058	3.9158	0.0000	0.0000	0.0000	0.0000;
	1909	1901	0.001488	0.004628	0.000542	140	140	140	0	0	1	-360	360	8.0868	-0.8458	-8.0860	0.7845	0.0000	0.0000	0.0000	0.0000;
	1480	1386	0.006281	0.019752	0.002161	140	140	140	0	0	1	-360	360	-0.2260	-0.0780	0.2260	-0.1769	0.0000	0.0000	0.0000	0.0000;
	1481	1387	0.006198	0.019587	0.002139	140	140	140	0	0	1	-360	360	-2.0390	-0.6880	2.0392	0.4365	0.0000	0.0000	0.0000	0.0000;
	1386	1902	0.000826	0.002479	0.000271	140	140	140	0	0	1	-360	360	8.6308	4.5132	-8.6301	-4.5431	0.0000	0.0000	0.0000	0.0000;
	857	1910	0.000744	0.002397	0.000281	140	140	140	0	0	1	-360	360	11.4457	0.1177	-11.4449	-0.1481	0.0000	0.0000	0.0000	0.0000;
	1920	1387	0.001983	0.005289	0.000702	120	120	120	0	0	1	-360	360	-4.2844	-2.6199	4.2848	2.5383	0.0000	0.0000	0.0000	0.0000;
	1667	1662	0.003471	0.010413	0.001239	140	140	140	0	0	1	-360	360	8.1146	4.6123	-8.1120	-4.7493	0.0000	0.0000	0.0000	0.0000;
	1668	942	0.006446	0.019669	0.002335	140	140	140	0	0	1	-360	360	-16.2748	-6.8825	16.2919	6.6609	0.0000	0.0000	0.0000	0.0000;
	1700	1179	0.004793	0.014711	0.001706	140	140	140	0	0	1	-360	360	-57.9677	-0.7611	58.1033	0.9741	0.0000	0.0000	0.0000	0.0000;
	1201	1176	0.008843	0.027603	0.003083	140	140	140	0	0	1	-360	360	2.5617	-0.7836	-2.5612	0.4256	0.0000	0.0000	0.0000	0.0000;
	1716	1179	0.005041	0.015537	0.001801	140	140	140	0	0	1	-360	360	-45.0296	-0.4602	45.1156	0.5107	0.0000	0.0000	0.0000	0.0000;
	1703	1177	0.003554	0.00876	0.000963	120	120	120	0	0	1	-360	360	-45.0698	3.0123	45.1310	-2.9755	0.0000	0.0000	0.0000	0.0000;
	1808	1703	0.016033	0.046364	0.004455	120	120	120	0	0	1	-360	360	-41.4318	3.7476	41.6685	-3.5885	0.0000	0.0000	0.0000	0.0000;
	1703	1701	0.012645	0.015868	0.003013	90	90	90	0	0	1	-360	360	3.4013	0.5761	-3.4000	-0.9310	0.0000	0.0000	0.0000	0.0000;
	1704	1176	0.004298	0.010496	0.001159	120	120	120	0	0	1	-360	360	3.7905	2.1951	-3.7898	-2.3286	0.0000	0.0000	0.0000	0.0000;
	1675	1704	0.017273	0.055289	0.005189	120	120	120	0	0	1	-360	360	7.7707	2.7986	-7.7604	-3.3729	0.0000	0.0000	0.0000	0.0000;
	1704	1702	0.01281	0.016033	0.00304	90	90	90	0	0	1	-360	360	3.9699	1.1778	-3.9680	-1.5300	0.0000	0.0000	0.0000	0.0000;
	1809	1675	0.008926	0.027355	0.003165	140	140	140	0	0	1	-360	360	-14.1728	-4.7708	14.1897	4.4520	0.0000	0.0000	0.0000	0.0000;
	1032	1675	0.009008	0.027603	0.003202	140	140	140	0	0	1	-360	360	18.0570	-5.3477	-18.0299	5.0548	0.0000	0.0000	0.0000	0.0000;
	1676	942	0.008512	0.026198	0.003006	120	120	120	0	0	1	-360	360	-18.9227	7.4580	18.9528	-7.7184	0.0000	0.0000	0.0000	0.0000;
	1677	943	0.008512	0.026198	0.003006	120	120	120	0	0	1	-360	360	-27.6866	4.0986	27.7432	-4.2794	0.0000	0.0000	0.0000	0.0000;
	1860	1677	0.004298	0.01314	0.001559	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.1839	0.0000	0.0000	0.0000	0.0000;
	1861	1675	0.004298	0.01314	0.001556	140	140	140	0	0	1	-360	360	-11.3570	-2.1270	11.3619	1.9594	0.0000	0.0000	0.0000	0.0000;
	1507	1487	0.004959	0.012397	0.001375	120	120	120	0	0	1	-360	360	18.7712	1.9139	-18.7561	-2.0370	0.0000	0.0000	0.0000	0.0000;
	1677	1507	0.010992	0.032231	0.003112	120	120	120	0	0	1	-360	360	29.0636	3.9880	-28.9833	-4.1184	0.0000	0.0000	0.0000	0.0000;
	1506	1507	0.004298	0.013058	0.001544	140	140	140	0	0	1	-360	360	-10.2080	-2.3730	10.2120	2.2045	0.0000	0.0000	0.0000	0.0000;
	1676	1486	0.016033	0.044711	0.004499	120	120	120	0	0	1	-360	360	36.4412	4.7066	-36.2567	-4.7174	0.0000	0.0000	0.0000	0.0000;
	1675	1850	0.006198	0.02	0.00212	140	140	140	0	0	1	-360	360	20.0616	5.7204	-20.0385	-5.8943	0.0000	0.0000	0.0000	0.0000;
	1221	915	0.004545	0.013802	0.001638	140	140	140	0	0	1	-360	360	11.7397	1.9180	-11.7343	-2.0950	0.0000	0.0000	0.0000	0.0000;
	1776	873	0.004132	0.01281	0.00144	140	140	140	0	0	1	-360	360	-35.4110	-0.1772	35.4540	0.1362	0.0000	0.0000	0.0000	0.0000;
	1730	873	0.003471	0.011157	0.001198	140	140	140	0	0	1	-360	360	-24.0271	-3.4596	24.0440	3.3691	0.0000	0.0000	0.0000	0.0000;
	1351	1106	0.004628	0.014297	0.001619	140	140	140	0	0	1	-360	360	32.9417	4.4361	-32.8993	-4.4996	0.0000	0.0000	0.0000	0.0000;
	1727	1069	0.004711	0.014297	0.001699	140	140	140	0	0	1	-360	360	28.4718	12.1027	-28.4341	-12.1916	0.0000	0.0000	0.0000	0.0000;
	1351	1727	0.003554	0.010992	0.001261	140	140	140	0	0	1	-360	360	32.5936	13.2847	-32.5570	-13.3231	0.0000	0.0000	0.0000	0.0000;
	1727	1725	0.00157	0.005372	0.00052	140	140	140	0	0	1	-360	360	4.0852	1.2204	-4.0850	-1.2820	0.0000	0.0000	0.0000	0.0000;
	1531	874	0.002479	0.007686	0.000883	140	140	140	0	0	1	-360	360	5.9094	4.6346	-5.9082	-4.7370	0.0000	0.0000	0.0000	0.0000;
	1351	1531	0.006116	0.018926	0.002142	140	140	140	0	0	1	-360	360	11.0340	6.0167	-11.0259	-6.2494	0.0000	0.0000	0.0000	0.0000;
	1531	1530	0.002066	0.003802	0.000784	120	120	120	0	0	1	-360	360	5.1165	1.6147	-5.1160	-1.7080	0.0000	0.0000	0.0000	0.0000;
	1365	1351	0.002397	0.007355	0.000828	140	140	140	0	0	1	-360	360	-18.3448	9.3727	18.3533	-9.4465	0.0000	0.0000	0.0000	0.0000;
	997	1441	0.002397	0.007769	0.000823	140	140	140	0	0	1	-360	360	-22.3567	-6.0876	22.3673	6.0231	0.0000	0.0000	0.0000	0.0000;
	1068	1551	0.003719	0.009008	0.001363	120	120	120	0	0	1	-360	360	19.5904	9.3490	-19.5757	-9.4757	0.0000	0.0000	0.0000	0.0000;
	1522	1440	0.006281	0.020083	0.002139	140	140	140	0	0	1	-360	360	10.3048	-0.7750	-10.2993	0.5346	0.0000	0.0000	0.0000	0.0000;
	1260	1217	8.3e-05	0.000248	2.2e-05	140	140	140	0	0	1	-360	360	26.6536	4.8535	-26.6531	-4.8546	0.0000	0.0000	0.0000	0.0000;
	1467	1260	0.007603	0.019587	0.002091	120	120	120	0	0	1	-360	360	27.0413	4.7363	-26.9936	-4.8645	0.0000	0.0000	0.0000	0.0000;
	1440	1467	0.003141	0.00843	0.000857	120	120	120	0	0	1	-360	360	27.9693	4.9045	-27.9483	-4.9513	0.0000	0.0000	0.0000	0.0000;
	1259	1260	0.004545	0.008512	0.000927	90	90	90	0	0	1	-360	360	-0.3400	-0.1220	0.3400	0.0110	0.0000	0.0000	0.0000	0.0000;
	1466	1467	0.000496	0.001322	0.000133	120	120	120	0	0	1	-360	360	-0.9070	-0.2310	0.9070	0.2150	0.0000	0.0000	0.0000	0.0000;
	1236	1217	0.002562	0.006777	0.000944	120	120	120	0	0	1	-360	360	-29.3548	-9.8106	29.3753	9.7519	0.0000	0.0000	0.0000	0.0000;
	1423	1187	0.001653	0.004959	0.00059	140	140	140	0	0	1	-360	360	23.7704	8.1982	-23.7616	-8.2421	0.0000	0.0000	0.0000	0.0000;
	1183	1218	0.003223	0.009752	0.001159	140	140	140	0	0	1	-360	360	11.7676	-1.6529	-11.7638	1.5257	0.0000	0.0000	0.0000	0.0000;
	970	1183	0.003058	0.009421	0.001058	140	140	140	0	0	1	-360	360	11.7712	-1.7698	-11.7676	1.6544	0.0000	0.0000	0.0000	0.0000;
	1182	1183	0	8.3e-05	1.2e-05	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0014	0.0000	0.0000	0.0000	0.0000;
	1187	1550	0.001405	0.004298	0.000503	140	140	140	0	0	1	-360	360	-17.9836	-8.9297	17.9884	8.8844	0.0000	0.0000	0.0000	0.0000;
	1837	1366	0.010744	0.032727	0.003836	140	140	140	0	0	1	-360	360	-16.0427	9.8031	16.0746	-10.1692	0.0000	0.0000	0.0000	0.0000;
	1217	1459	0.008264	0.026612	0.002807	140	140	140	0	0	1	-360	360	-8.3902	-5.9914	8.3974	5.6778	0.0000	0.0000	0.0000	0.0000;
	1395	1798	0.014711	0.031488	0.005377	120	120	120	0	0	1	-360	360	-31.6169	-6.2437	31.7446	5.8730	0.0000	0.0000	0.0000	0.0000;
	1222	1395	0.009917	0.019669	0.003705	120	120	120	0	0	1	-360	360	-25.8715	-4.7157	25.9292	4.3901	0.0000	0.0000	0.0000	0.0000;
	1395	1394	0.002231	0.006033	0.000564	120	120	120	0	0	1	-360	360	5.6877	1.8537	-5.6870	-1.9190	0.0000	0.0000	0.0000	0.0000;
	871	1179	0.006033	0.020496	0.002176	140	140	140	0	0	1	-360	360	-27.0418	-15.2018	27.0907	15.1090	0.0000	0.0000	0.0000	0.0000;
	872	951	0.003058	0.010661	0.001171	140	140	140	0	0	1	-360	360	11.8567	7.1834	-11.8517	-7.3046	0.0000	0.0000	0.0000	0.0000;
	1175	950	0.006529	0.020909	0.002243	140	140	140	0	0	1	-360	360	8.9135	-7.0416	-8.9064	6.7992	0.0000	0.0000	0.0000	0.0000;
	1299	1175	0.002397	0.007355	0.000876	140	140	140	0	0	1	-360	360	10.0497	-7.6730	-10.0465	7.5796	0.0000	0.0000	0.0000	0.0000;
	1171	1175	0.008678	0.02719	0.00303	140	140	140	0	0	1	-360	360	-0.5636	-0.0861	0.5637	-0.2713	0.0000	0.0000	0.0000	0.0000;
	1172	1175	0.008347	0.026116	0.002904	140	140	140	0	0	1	-360	360	-0.5694	-0.0759	0.5694	-0.2666	0.0000	0.0000	0.0000	0.0000;
	1192	1486	0.004711	0.012149	0.001696	120	120	120	0	0	1	-360	360	-26.3644	-1.5730	26.3928	1.4497	0.0000	0.0000	0.0000	0.0000;
	1859	1192	0.02405	0.043223	0.008981	120	120	120	0	0	1	-360	360	-23.4115	-1.9510	23.5272	1.1255	0.0000	0.0000	0.0000	0.0000;
	1191	1192	0.003471	0.010826	0.001195	140	140	140	0	0	1	-360	360	-2.8370	-0.5850	2.8372	0.4475	0.0000	0.0000	0.0000	0.0000;
	1487	1663	0.001488	0.004463	0.000513	140	140	140	0	0	1	-360	360	8.8871	0.0543	-8.8861	-0.1112	0.0000	0.0000	0.0000	0.0000;
	1486	1283	0.000909	0.002975	0.000329	140	140	140	0	0	1	-360	360	2.2670	0.6100	-2.2670	-0.6480	0.0000	0.0000	0.0000	0.0000;
	1505	1486	0.010331	0.013223	0.00241	90	90	90	0	0	1	-360	360	-2.8340	-1.4820	2.8349	1.2037	0.0000	0.0000	0.0000	0.0000;
	1487	1256	0.00843	0.025785	0.00304	140	140	140	0	0	1	-360	360	6.4621	0.6267	-6.4590	-0.9723	0.0000	0.0000	0.0000	0.0000;
	1731	1523	0.001488	0.004628	0.00053	140	140	140	0	0	1	-360	360	15.5250	0.7849	-15.5220	-0.8397	0.0000	0.0000	0.0000	0.0000;
	1496	1440	0.001983	0.006116	0.000726	140	140	140	0	0	1	-360	360	-26.8909	-8.0837	26.9039	8.0362	0.0000	0.0000	0.0000	0.0000;
	1726	971	0.00438	0.014545	0.00144	140	140	140	0	0	1	-360	360	25.7431	2.3543	-25.7187	-2.4458	0.0000	0.0000	0.0000	0.0000;
	1107	1726	0.000661	0.001983	0.000232	140	140	140	0	0	1	-360	360	31.1996	4.0888	-31.1941	-4.1003	0.0000	0.0000	0.0000	0.0000;
	1724	1726	0.000165	0.000413	5.1e-05	140	140	140	0	0	1	-360	360	-5.4510	-1.7520	5.4510	1.7460	0.0000	0.0000	0.0000	0.0000;
	1314	874	0.004628	0.014545	0.001592	140	140	140	0	0	1	-360	360	8.9811	1.7223	-8.9779	-1.9034	0.0000	0.0000	0.0000	0.0000;
	1020	874	0.000826	0.002727	0.000257	140	140	140	0	0	1	-360	360	-4.0019	-3.3996	4.0021	3.3694	0.0000	0.0000	0.0000	0.0000;
	1397	1020	0.002562	0.008595	0.00082	140	140	140	0	0	1	-360	360	-4.0013	-3.4580	4.0019	3.3616	0.0000	0.0000	0.0000	0.0000;
	1019	1020	0.000992	0.003058	0.000358	140	140	140	0	0	1	-360	360	0.0000	-0.0810	0.0000	0.0380	0.0000	0.0000	0.0000	0.0000;
	1809	974	0.005289	0.016198	0.001907	140	140	140	0	0	1	-360	360	3.8057	4.5286	-3.8040	-4.7463	0.0000	0.0000	0.0000	0.0000;
	909	942	0.000826	0.001405	0.000152	90	90	90	0	0	1	-360	360	-12.4650	-2.5920	12.4661	2.5760	0.0000	0.0000	0.0000	0.0000;
	910	943	0.000826	0.001322	0.000145	90	90	90	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0172	0.0000	0.0000	0.0000	0.0000;
	911	943	0.000826	0.001322	0.000145	90	90	90	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0172	0.0000	0.0000	0.0000	0.0000;
	912	942	0.000744	0.001157	0.000128	90	90	90	0	0	1	-360	360	-12.4970	-5.0220	12.4981	5.0087	0.0000	0.0000	0.0000	0.0000;
	1351	1775	0.004959	0.015289	0.001769	140	140	140	0	0	1	-360	360	-26.3136	1.1721	26.3422	-1.2974	0.0000	0.0000	0.0000	0.0000;
	1218	978	0.00719	0.017851	0.002134	120	120	120	0	0	1	-360	360	43.0758	-0.3428	-42.9643	0.3651	0.0000	0.0000	0.0000	0.0000;
	1440	1404	0.008017	0.027769	0.002802	140	140	140	0	0	1	-360	360	15.5592	2.3366	-15.5427	-2.6169	0.0000	0.0000	0.0000	0.0000;
	1921	916	0.006033	0.018347	0.002176	140	140	140	0	0	1	-360	360	-7.0766	-0.8264	7.0792	0.5776	0.0000	0.0000	0.0000	0.0000;
	1421	1352	0.007686	0.027273	0.003178	140	140	140	0	0	1	-360	360	7.9291	1.9189	-7.9248	-2.2889	0.0000	0.0000	0.0000	0.0000;
	1699	1177	0.001405	0.00438	0.000506	140	140	140	0	0	1	-360	360	48.9003	-1.3683	-48.8720	1.3965	0.0000	0.0000	0.0000	0.0000;
	1424	1235	0.004876	0.009256	0.001801	120	120	120	0	0	1	-360	360	-24.9049	-8.4260	24.9331	8.2649	0.0000	0.0000	0.0000	0.0000;
	1847	1798	0.003719	0.012645	0.00121	140	140	140	0	0	1	-360	360	-3.8260	-2.1720	3.8266	2.0283	0.0000	0.0000	0.0000	0.0000;
	1808	1033	0.002727	0.008347	0.000956	140	140	140	0	0	1	-360	360	18.0635	-5.4341	-18.0552	5.3472	0.0000	0.0000	0.0000	0.0000;
	1858	1772	0.001157	0.002893	0.000436	120	120	120	0	0	1	-360	360	6.2802	-0.5700	-6.2798	0.5212	0.0000	0.0000	0.0000	0.0000;
	1388	1797	0.007686	0.02405	0.002703	140	140	140	0	0	1	-360	360	-71.8792	-10.8102	72.2171	11.5407	0.0000	0.0000	0.0000	0.0000;
	1838	1797	0.01124	0.032562	0.003272	120	120	120	0	0	1	-360	360	2.3176	-13.9725	-2.2994	13.6281	0.0000	0.0000	0.0000	0.0000;
	1443	1851	0.005868	0.01595	0.00174	120	120	120	0	0	1	-360	360	0.7116	-1.0764	-0.7115	0.8733	0.0000	0.0000	0.0000	0.0000;
	1809	1443	0.000165	0.000331	3.2e-05	120	120	120	0	0	1	-360	360	0.7116	-1.1675	-0.7116	1.1638	0.0000	0.0000	0.0000	0.0000;
	1443	1442	0.001983	0.005207	0.000748	120	120	120	0	0	1	-360	360	0.0000	-0.0874	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1089	1076	0.063554	0.129835	0.012678	90	90	90	0	0	1	-360	360	20.3078	-5.0929	-20.0777	4.0610	0.0000	0.0000	0.0000	0.0000;
	1661	1108	0.030413	0.056942	0.00521	57	57	57	0	0	1	-360	360	7.4327	-3.5384	-7.4156	2.9618	0.0000	0.0000	0.0000	0.0000;
	1900	1661	0.101736	0.200661	0.017431	90	90	90	0	0	1	-360	360	10.9489	-4.9209	-10.8319	3.1094	0.0000	0.0000	0.0000	0.0000;
	1660	1661	0.001983	0.003306	0.000353	19	19	19	0	0	1	-360	360	-3.3990	-0.4700	3.3992	0.4290	0.0000	0.0000	0.0000	0.0000;
	1344	1899	0.016116	0.028512	0.002735	90	90	90	0	0	1	-360	360	-4.1980	-0.4670	4.2004	0.1503	0.0000	0.0000	0.0000	0.0000;
	1748	895	0.022893	0.056694	0.006297	114	114	114	0	0	1	-360	360	10.5090	0.8793	-10.4873	-1.5706	0.0000	0.0000	0.0000	0.0000;
	1738	895	0.024793	0.061322	0.006817	114	114	114	0	0	1	-360	360	1.3254	0.3465	-1.3249	-1.1502	0.0000	0.0000	0.0000	0.0000;
	1900	1066	0.022727	0.072645	0.007749	57	57	57	0	0	1	-360	360	-4.7389	-2.3776	4.7440	1.4817	0.0000	0.0000	0.0000	0.0000;
	1342	895	0.014711	0.045207	0.005198	114	114	114	0	0	1	-360	360	-9.0280	-4.7787	9.0407	4.2063	0.0000	0.0000	0.0000	0.0000;
	1088	1147	0.096446	0.194711	0.017877	90	90	90	0	0	1	-360	360	8.7680	-5.7214	-8.6881	3.7537	0.0000	0.0000	0.0000	0.0000;
	1345	897	0.015124	0.040496	0.004627	114	114	114	0	0	1	-360	360	-24.3323	-1.2646	24.4080	0.9172	0.0000	0.0000	0.0000	0.0000;
	963	1345	0.037273	0.075454	0.006638	90	90	90	0	0	1	-360	360	-19.1085	-1.3139	19.2252	0.7690	0.0000	0.0000	0.0000	0.0000;
	1343	1345	0.000579	0.000992	8.9e-05	29	29	29	0	0	1	-360	360	-5.1070	-0.5060	5.1071	0.4956	0.0000	0.0000	0.0000	0.0000;
	877	1055	0.018017	0.054711	0.006486	57	57	57	0	0	1	-360	360	-10.5529	0.3197	10.5701	-1.0273	0.0000	0.0000	0.0000	0.0000;
	1108	877	0.012397	0.037603	0.004441	57	57	57	0	0	1	-360	360	-7.3676	-0.9961	7.3734	0.4947	0.0000	0.0000	0.0000	0.0000;
	877	876	0.016529	0.027273	0.002948	19	19	19	0	0	1	-360	360	3.1795	-0.8144	-3.1780	0.4720	0.0000	0.0000	0.0000	0.0000;
	1108	1494	0.014545	0.025124	0.003572	57	57	57	0	0	1	-360	360	6.6278	-1.8199	-6.6220	1.4129	0.0000	0.0000	0.0000	0.0000;
	1246	896	0.00719	0.022149	0.002522	114	114	114	0	0	1	-360	360	25.0488	-6.0381	-25.0089	5.8598	0.0000	0.0000	0.0000	0.0000;
	1245	897	0.00719	0.022231	0.002534	114	114	114	0	0	1	-360	360	-42.3084	-28.4989	42.4672	28.6901	0.0000	0.0000	0.0000	0.0000;
	1089	1083	0.006612	0.021074	0.002248	114	114	114	0	0	1	-360	360	-46.4338	4.8156	46.5548	-4.6982	0.0000	0.0000	0.0000	0.0000;
	1114	1088	0.016364	0.052149	0.005588	140	140	140	0	0	1	-360	360	48.7199	-1.8823	-48.3970	2.2426	0.0000	0.0000	0.0000	0.0000;
	1501	1088	0.019504	0.035537	0.009019	114	114	114	0	0	1	-360	360	-1.8877	-2.8123	1.8891	1.7426	0.0000	0.0000	0.0000	0.0000;
	1050	1089	0.001322	0.002314	0.000242	57	57	57	0	0	1	-360	360	-7.4790	-0.0810	7.4796	0.0533	0.0000	0.0000	0.0000	0.0000;
	1051	1088	0.001322	0.002314	0.000242	57	57	57	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0288	0.0000	0.0000	0.0000	0.0000;
	1535	1089	0.02843	0.074132	0.006752	90	90	90	0	0	1	-360	360	-10.1197	-1.1640	10.1444	0.4264	0.0000	0.0000	0.0000	0.0000;
	1899	1535	0.037769	0.073802	0.00657	90	90	90	0	0	1	-360	360	-10.0862	-1.9423	10.1197	1.2328	0.0000	0.0000	0.0000	0.0000;
	1535	1533	0.003306	0.005455	0.000581	19	19	19	0	0	1	-360	360	0.0000	-0.0688	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1900	1296	0.038182	0.074876	0.00666	90	90	90	0	0	1	-360	360	-0.1195	-1.3653	0.1199	0.5831	0.0000	0.0000	0.0000	0.0000;
	1534	1088	0.02843	0.074132	0.006752	90	90	90	0	0	1	-360	360	-16.5791	-2.5757	16.6466	1.9525	0.0000	0.0000	0.0000	0.0000;
	1297	1534	0.005207	0.009835	0.000956	90	90	90	0	0	1	-360	360	-8.6419	-1.2892	8.6452	1.1831	0.0000	0.0000	0.0000	0.0000;
	1534	1532	0.003306	0.005455	0.000581	19	19	19	0	0	1	-360	360	7.9338	1.3926	-7.9320	-1.4580	0.0000	0.0000	0.0000	0.0000;
	1291	1266	0.040496	0.066694	0.007214	57	57	57	0	0	1	-360	360	-14.4363	4.3278	14.5166	-5.0381	0.0000	0.0000	0.0000	0.0000;
	1893	1301	0.025785	0.06843	0.007802	114	114	114	0	0	1	-360	360	-1.5261	-0.4540	1.5266	-0.4737	0.0000	0.0000	0.0000	0.0000;
	1894	1501	0.024463	0.061322	0.006793	114	114	114	0	0	1	-360	360	-5.8472	0.1526	5.8543	-0.9409	0.0000	0.0000	0.0000	0.0000;
	1894	1502	0.024463	0.061322	0.006793	114	114	114	0	0	1	-360	360	-19.1208	0.8035	19.1965	-1.4218	0.0000	0.0000	0.0000	0.0000;
	924	1333	0.024793	0.065454	0.006614	114	114	114	0	0	1	-360	360	21.6116	-2.3459	-21.5126	1.8298	0.0000	0.0000	0.0000	0.0000;
	1893	1695	0.001653	0.003471	0.00038	90	90	90	0	0	1	-360	360	1.1330	-0.0452	-1.1330	0.0000	0.0000	0.0000	0.0000	0.0000;
	1894	1696	0.001074	0.003471	0.00037	114	114	114	0	0	1	-360	360	4.7592	1.5768	-4.7590	-1.6200	0.0000	0.0000	0.0000	0.0000;
	1830	1265	0.030744	0.050661	0.005474	57	57	57	0	0	1	-360	360	8.5378	-11.3086	-8.4866	10.7537	0.0000	0.0000	0.0000	0.0000;
	1341	1899	0.002314	0.007438	0.000799	114	114	114	0	0	1	-360	360	3.4960	-10.0226	-3.4938	9.9359	0.0000	0.0000	0.0000	0.0000;
	1088	1067	0.01124	0.036116	0.003816	114	114	114	0	0	1	-360	360	27.0258	5.9616	-26.9532	-6.1806	0.0000	0.0000	0.0000	0.0000;
	1332	1265	0.007769	0.021736	0.002362	114	114	114	0	0	1	-360	360	15.6053	-3.3048	-15.5885	3.0752	0.0000	0.0000	0.0000	0.0000;
	1831	1455	0.05	0.082397	0.008901	57	57	57	0	0	1	-360	360	-20.3819	5.4561	20.5756	-6.1781	0.0000	0.0000	0.0000	0.0000;
	1502	961	0.026033	0.065702	0.007335	114	114	114	0	0	1	-360	360	12.9334	-0.9800	-12.8969	0.1989	0.0000	0.0000	0.0000	0.0000;
	1559	1454	0.042397	0.069917	0.00755	57	57	57	0	0	1	-360	360	32.4162	-5.0569	-32.0361	4.7888	0.0000	0.0000	0.0000	0.0000;
	887	998	0.00438	0.014876	0.001423	114	114	114	0	0	1	-360	360	-36.7387	5.7785	36.7887	-5.7812	0.0000	0.0000	0.0000	0.0000;
	1105	895	0.032479	0.102314	0.011265	114	114	114	0	0	1	-360	360	5.1676	0.9869	-5.1595	-2.2945	0.0000	0.0000	0.0000	0.0000;
	1580	1061	0.050248	0.08281	0.008956	57	57	57	0	0	1	-360	360	-9.9051	0.4381	9.9489	-1.3865	0.0000	0.0000	0.0000	0.0000;
	1737	1501	0.025372	0.062562	0.006924	114	114	114	0	0	1	-360	360	-11.7514	-0.6705	11.7810	-0.0765	0.0000	0.0000	0.0000	0.0000;
	1812	1077	0.013306	0.040413	0.004804	57	57	57	0	0	1	-360	360	-3.4030	0.6920	3.4044	-1.2534	0.0000	0.0000	0.0000	0.0000;
	998	1089	0.01	0.068512	0.007647	232	232	232	0	0	1	-360	360	69.0416	7.0514	-68.6441	-5.2482	0.0000	0.0000	0.0000	0.0000;
	999	1757	0.005868	0.040083	0.004518	232	232	232	0	0	1	-360	360	81.4693	5.8261	-81.1464	-4.1650	0.0000	0.0000	0.0000	0.0000;
	1072	1082	0.006281	0.019835	0.00218	114	114	114	0	0	1	-360	360	63.7936	-4.4126	-63.5799	4.8260	0.0000	0.0000	0.0000	0.0000;
	999	1073	0.009421	0.041736	0.004576	114	114	114	0	0	1	-360	360	70.7659	-2.2304	-70.3766	3.4027	0.0000	0.0000	0.0000	0.0000;
	960	1747	0.005207	0.014215	0.001614	114	114	114	0	0	1	-360	360	12.3308	0.7721	-12.3241	-0.9454	0.0000	0.0000	0.0000	0.0000;
	1762	1082	0.002149	0.007273	0.000758	57	57	57	0	0	1	-360	360	-8.0610	0.3900	8.0622	-0.4766	0.0000	0.0000	0.0000	0.0000;
	1761	1083	0.002149	0.00719	0.000753	57	57	57	0	0	1	-360	360	-2.6080	-0.1200	2.6081	0.0304	0.0000	0.0000	0.0000	0.0000;
	1558	886	0.033058	0.05686	0.006142	90	90	90	0	0	1	-360	360	-35.0280	5.8115	35.3778	-5.9493	0.0000	0.0000	0.0000	0.0000;
	1581	902	0.017769	0.058016	0.005917	57	57	57	0	0	1	-360	360	0.8301	-1.2383	-0.8298	0.5671	0.0000	0.0000	0.0000	0.0000;
	1501	923	0.022479	0.054545	0.00621	114	114	114	0	0	1	-360	360	24.1058	-2.4827	-23.9950	2.0166	0.0000	0.0000	0.0000	0.0000;
	1054	1076	0.014545	0.04405	0.00522	57	57	57	0	0	1	-360	360	-17.3842	0.4905	17.4217	-0.9904	0.0000	0.0000	0.0000	0.0000;
	1521	1108	0.029917	0.096116	0.010188	57	57	57	0	0	1	-360	360	-4.8500	0.6560	4.8564	-1.8248	0.0000	0.0000	0.0000	0.0000;
	1089	1794	0.011157	0.034545	0.003903	114	114	114	0	0	1	-360	360	6.9892	0.3264	-6.9846	-0.7768	0.0000	0.0000	0.0000	0.0000;
	1519	1681	0.034628	0.108843	0.01203	114	114	114	0	0	1	-360	360	-39.5422	6.8231	40.0125	-6.7878	0.0000	0.0000	0.0000	0.0000;
	1619	998	0.021074	0.067686	0.007149	114	114	114	0	0	1	-360	360	-41.6204	6.9745	41.9329	-6.8356	0.0000	0.0000	0.0000	0.0000;
	1148	1619	0.030413	0.09438	0.010721	114	114	114	0	0	1	-360	360	-41.1757	6.2505	41.6204	-6.1554	0.0000	0.0000	0.0000	0.0000;
	1618	1619	0.007603	0.036364	0.006795	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.8191	0.0000	0.0000	0.0000	0.0000;
	1680	999	0.014711	0.046529	0.005092	114	114	114	0	0	1	-360	360	-42.7376	6.1926	42.9656	-6.0872	0.0000	0.0000	0.0000	0.0000;
	1518	1147	0.010248	0.03124	0.003698	57	57	57	0	0	1	-360	360	30.5513	-7.7942	-30.4662	7.6127	0.0000	0.0000	0.0000	0.0000;
	1758	1088	0.004628	0.031736	0.003586	232	232	232	0	0	1	-360	360	72.4065	3.8698	-72.2035	-2.9062	0.0000	0.0000	0.0000	0.0000;
	1886	1113	0.003388	0.010331	0.00121	114	114	114	0	0	1	-360	360	56.5887	1.3580	-56.4989	-1.2299	0.0000	0.0000	0.0000	0.0000;
	998	1885	0.003306	0.022479	0.002502	114	114	114	0	0	1	-360	360	72.2940	1.7667	-72.1515	-1.1010	0.0000	0.0000	0.0000	0.0000;
	1501	999	0.03438	0.110579	0.011626	114	114	114	0	0	1	-360	360	-48.9207	4.4799	49.6211	-3.6224	0.0000	0.0000	0.0000	0.0000;
	1502	998	0.03438	0.110579	0.011628	114	114	114	0	0	1	-360	360	-35.7570	2.0287	36.1274	-2.2369	0.0000	0.0000	0.0000	0.0000;
	1330	1062	0.053471	0.074876	0.006638	57	57	57	0	0	1	-360	360	17.3586	-0.1970	-17.2200	-0.3743	0.0000	0.0000	0.0000	0.0000;
	968	896	0.008678	0.022066	0.002524	114	114	114	0	0	1	-360	360	-16.5439	0.6072	16.5638	-0.8573	0.0000	0.0000	0.0000	0.0000;
	1793	1104	0.017025	0.053058	0.005936	114	114	114	0	0	1	-360	360	5.8516	0.4625	-5.8466	-1.1522	0.0000	0.0000	0.0000	0.0000;
	904	962	0.070661	0.127355	0.012286	57	57	57	0	0	1	-360	360	-15.9997	-2.4961	16.1602	1.3663	0.0000	0.0000	0.0000	0.0000;
	1109	904	0.011653	0.023141	0.002011	57	57	57	0	0	1	-360	360	-7.3962	-2.0952	7.4022	1.8779	0.0000	0.0000	0.0000	0.0000;
	904	903	0.026777	0.036198	0.00318	57	57	57	0	0	1	-360	360	8.5975	0.6182	-8.5800	-0.9567	0.0000	0.0000	0.0000	0.0000;
	1148	1076	0.04719	0.089008	0.008707	57	57	57	0	0	1	-360	360	8.0558	3.2541	-8.0244	-4.2266	0.0000	0.0000	0.0000	0.0000;
	958	969	0.058099	0.089008	0.008833	75	75	75	0	0	1	-360	360	-8.5696	-0.7647	8.6057	-0.2274	0.0000	0.0000	0.0000	0.0000;
	902	1109	0.013512	0.042818	0.004598	114	114	114	0	0	1	-360	360	-3.7652	-1.9826	3.7672	1.4662	0.0000	0.0000	0.0000	0.0000;
	1400	1501	0.000826	0.001653	0	229	229	229	0	0	1	-360	360	-5.8920	-0.8900	5.8922	0.8905	0.0000	0.0000	0.0000	0.0000;
	1401	1502	0.000826	0.001653	0	229	229	229	0	0	1	-360	360	-1.1330	-0.0810	1.1330	0.0810	0.0000	0.0000	0.0000	0.0000;
	1402	1501	0.001157	0.002066	0	229	229	229	0	0	1	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1688	953	0.023719	0.058264	0.006457	120	120	120	0	0	1	-360	360	25.2298	6.9794	-25.0898	-7.3846	0.0000	0.0000	0.0000	0.0000;
	1167	1393	0.004132	0.010165	0.001123	120	120	120	0	0	1	-360	360	-10.1804	3.2357	10.1845	-3.3552	0.0000	0.0000	0.0000	0.0000;
	1289	1167	0.03595	0.089835	0.009932	120	120	120	0	0	1	-360	360	-4.1519	3.8340	4.1633	-4.9541	0.0000	0.0000	0.0000	0.0000;
	1165	1167	0.000248	0.000496	0.000102	120	120	120	0	0	1	-360	360	-6.0170	-1.7300	6.0171	1.7184	0.0000	0.0000	0.0000	0.0000;
	1687	913	0.017851	0.041984	0.006072	120	120	120	0	0	1	-360	360	23.3196	0.3018	-23.2359	-0.8068	0.0000	0.0000	0.0000	0.0000;
	1687	859	0.018182	0.06281	0.0065	114	114	114	0	0	1	-360	360	17.3420	3.6453	-17.2923	-4.2244	0.0000	0.0000	0.0000	0.0000;
	1688	1575	0.025124	0.089339	0.008877	114	114	114	0	0	1	-360	360	-5.0717	6.1144	5.0867	-7.0959	0.0000	0.0000	0.0000	0.0000;
	1687	1274	0.010826	0.023967	0.003577	120	120	120	0	0	1	-360	360	14.2665	3.0717	-14.2465	-3.4417	0.0000	0.0000	0.0000	0.0000;
	1274	1637	0.003719	0.007686	0.00136	120	120	120	0	0	1	-360	360	14.2465	3.4613	-14.2396	-3.6040	0.0000	0.0000	0.0000	0.0000;
	1273	1274	0.000496	0.001405	0.000169	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0196	0.0000	0.0000	0.0000	0.0000;
	1708	1393	0.02438	0.043802	0.009111	120	120	120	0	0	1	-360	360	-16.4030	-2.5819	16.4613	1.6393	0.0000	0.0000	0.0000	0.0000;
	1168	1393	0.004132	0.010165	0.001123	120	120	120	0	0	1	-360	360	22.9853	1.8709	-22.9663	-1.9539	0.0000	0.0000	0.0000	0.0000;
	1822	1168	0.005702	0.017438	0.001672	120	120	120	0	0	1	-360	360	21.9001	1.5188	-21.8764	-1.6399	0.0000	0.0000	0.0000	0.0000;
	1168	1166	0.000331	0.000579	0.000121	120	120	120	0	0	1	-360	360	-1.1090	-0.2310	1.1090	0.2170	0.0000	0.0000	0.0000	0.0000;
	1823	1617	0.019174	0.052562	0.005515	120	120	120	0	0	1	-360	360	-16.9014	-0.4767	16.9487	-0.0338	0.0000	0.0000	0.0000	0.0000;
	1822	1161	0.000826	0.002397	0.000315	114	114	114	0	0	1	-360	360	13.7486	5.9292	-13.7470	-5.9610	0.0000	0.0000	0.0000	0.0000;
	1823	1162	0.000909	0.002645	0.00037	114	114	114	0	0	1	-360	360	6.2023	0.4620	-6.2020	-0.5040	0.0000	0.0000	0.0000	0.0000;
	1823	1156	0.001818	0.005537	0.000653	114	114	114	0	0	1	-360	360	7.3601	3.7047	-7.3590	-3.7770	0.0000	0.0000	0.0000	0.0000;
	1822	1157	0.001901	0.005702	0.000673	114	114	114	0	0	1	-360	360	14.0675	4.1516	-14.0640	-4.2190	0.0000	0.0000	0.0000	0.0000;
	1829	1575	0.004628	0.014876	0.001563	114	114	114	0	0	1	-360	360	40.3136	-6.9995	-40.2470	7.0319	0.0000	0.0000	0.0000	0.0000;
	1375	1574	0.008264	0.026612	0.0028	114	114	114	0	0	1	-360	360	23.5367	-1.2537	-23.4970	1.0585	0.0000	0.0000	0.0000	0.0000;
	1823	1154	0.005372	0.01281	0.002529	114	114	114	0	0	1	-360	360	6.9577	5.3510	-6.9540	-5.6348	0.0000	0.0000	0.0000	0.0000;
	1392	1151	0.003471	0.006529	0.000605	90	90	90	0	0	1	-360	360	6.4995	2.7790	-6.4980	-2.8460	0.0000	0.0000	0.0000	0.0000;
	1392	1152	0.003636	0.006446	0.00059	90	90	90	0	0	1	-360	360	-2.3457	1.8613	2.3460	-1.9290	0.0000	0.0000	0.0000	0.0000;
	1393	1153	0.003636	0.006446	0.00059	90	90	90	0	0	1	-360	360	11.7960	4.2137	-11.7910	-4.2730	0.0000	0.0000	0.0000	0.0000;
	1393	1158	0.001074	0.002231	0.000414	114	114	114	0	0	1	-360	360	11.8334	2.9271	-11.8320	-2.9720	0.0000	0.0000	0.0000	0.0000;
	1392	1159	0.001157	0.002066	0.000426	114	114	114	0	0	1	-360	360	14.6853	3.5989	-14.6830	-3.6440	0.0000	0.0000	0.0000	0.0000;
	1823	1164	0.001818	0.005124	0.000716	114	114	114	0	0	1	-360	360	7.5327	6.2241	-7.5312	-6.3027	0.0000	0.0000	0.0000	0.0000;
	1392	1155	0.002479	0.006364	0.001108	114	114	114	0	0	1	-360	360	7.5342	-1.7274	-7.5330	1.6026	0.0000	0.0000	0.0000	0.0000;
	1392	866	0.017934	0.04438	0.004813	120	120	120	0	0	1	-360	360	-10.1410	-2.0552	10.1575	1.5385	0.0000	0.0000	0.0000	0.0000;
	991	867	0.006281	0.019091	0.001994	114	114	114	0	0	1	-360	360	18.3338	0.1824	-18.3156	-0.3589	0.0000	0.0000	0.0000	0.0000;
	1561	1070	0.013223	0.036364	0.003872	114	114	114	0	0	1	-360	360	31.6368	-1.1091	-31.5229	0.9729	0.0000	0.0000	0.0000	0.0000;
	1828	1373	0.003719	0.012066	0.001268	140	140	140	0	0	1	-360	360	-63.9397	3.3791	64.0709	-3.1013	0.0000	0.0000	0.0000	0.0000;
	1542	1375	0.002066	0.006446	0.000748	140	140	140	0	0	1	-360	360	-45.1294	3.4667	45.1661	-3.4386	0.0000	0.0000	0.0000	0.0000;
	953	1543	0.011983	0.034132	0.003741	120	120	120	0	0	1	-360	360	-32.5405	5.5613	32.6544	-5.6681	0.0000	0.0000	0.0000	0.0000;
	1687	1765	0.012314	0.037521	0.004424	114	114	114	0	0	1	-360	360	33.3958	4.8441	-33.2747	-4.9858	0.0000	0.0000	0.0000	0.0000;
	1694	935	0.003884	0.009174	0.001317	120	120	120	0	0	1	-360	360	14.4652	0.1802	-14.4582	-0.3164	0.0000	0.0000	0.0000	0.0000;
	1694	1687	0.000661	0.00438	0.000586	152	152	152	0	0	1	-360	360	-37.1815	3.4100	37.1895	-3.4253	0.0000	0.0000	0.0000	0.0000;
	1693	1688	0.000909	0.006281	0.000755	152	152	152	0	0	1	-360	360	-30.0478	-10.7773	30.0557	10.7437	0.0000	0.0000	0.0000	0.0000;
	1227	1778	0.043223	0.057851	0.005162	57	57	57	0	0	1	-360	360	-10.0467	-0.5510	10.0858	0.0233	0.0000	0.0000	0.0000	0.0000;
	1689	1227	0.009256	0.029752	0.003134	57	57	57	0	0	1	-360	360	-2.7964	-0.2091	2.7971	-0.1394	0.0000	0.0000	0.0000	0.0000;
	1225	1227	0.007686	0.010165	0.000908	75	75	75	0	0	1	-360	360	-7.2460	-0.7870	7.2496	0.6903	0.0000	0.0000	0.0000	0.0000;
	1228	1777	0.034793	0.040248	0.007214	57	57	57	0	0	1	-360	360	-11.6730	-0.4527	11.7154	-0.3091	0.0000	0.0000	0.0000	0.0000;
	1690	1228	0.009091	0.029174	0.003078	57	57	57	0	0	1	-360	360	-6.5246	-0.6999	6.5280	0.3666	0.0000	0.0000	0.0000	0.0000;
	1226	1228	0.004132	0.007438	0.001149	62	62	62	0	0	1	-360	360	-5.1440	-0.2130	5.1450	0.0861	0.0000	0.0000	0.0000	0.0000;
	1694	1606	0.087769	0.169835	0.016066	90	90	90	0	0	1	-360	360	22.7163	-3.5903	-22.3206	2.5154	0.0000	0.0000	0.0000	0.0000;
	1688	1438	0.02	0.046694	0.009535	114	114	114	0	0	1	-360	360	45.4213	4.6255	-45.0641	-4.8968	0.0000	0.0000	0.0000	0.0000;
	1439	1390	0.039339	0.090413	0.018963	114	114	114	0	0	1	-360	360	24.3762	-0.8474	-24.1725	-0.8426	0.0000	0.0000	0.0000	0.0000;
	1181	1213	0.043223	0.103058	0.011205	90	90	90	0	0	1	-360	360	-5.5763	3.1822	5.5938	-4.3966	0.0000	0.0000	0.0000	0.0000;
	1778	1353	0.015703	0.024793	0.004015	90	90	90	0	0	1	-360	360	-4.2898	4.2009	4.2951	-4.6452	0.0000	0.0000	0.0000	0.0000;
	1647	878	0.036777	0.09157	0.00974	120	120	120	0	0	1	-360	360	17.7716	-1.2771	-17.6680	0.4460	0.0000	0.0000	0.0000	0.0000;
	1075	1541	0.009339	0.017355	0.001779	90	90	90	0	0	1	-360	360	3.9234	0.8656	-3.9220	-1.0610	0.0000	0.0000	0.0000	0.0000;
	1074	1305	0.032645	0.099504	0.011696	76	76	76	0	0	1	-360	360	7.3396	-2.2557	-7.3231	1.0049	0.0000	0.0000	0.0000	0.0000;
	1607	1354	0.026529	0.034463	0.006389	90	90	90	0	0	1	-360	360	11.5073	-3.3408	-11.4742	2.6626	0.0000	0.0000	0.0000	0.0000;
	1373	990	0.003884	0.012479	0.001309	114	114	114	0	0	1	-360	360	35.7472	2.8691	-35.7043	-2.8841	0.0000	0.0000	0.0000	0.0000;
	1093	1742	0.035785	0.070331	0.00718	90	90	90	0	0	1	-360	360	-8.0770	4.0187	8.1044	-4.7582	0.0000	0.0000	0.0000	0.0000;
	1741	1060	0.003967	0.00719	0.001026	57	57	57	0	0	1	-360	360	2.0542	0.4479	-2.0540	-0.5610	0.0000	0.0000	0.0000	0.0000;
	1741	1865	0.007107	0.011818	0.001256	90	90	90	0	0	1	-360	360	1.0840	-0.3597	-1.0839	0.2211	0.0000	0.0000	0.0000	0.0000;
	1742	1866	0.007025	0.011653	0.001244	90	90	90	0	0	1	-360	360	1.2122	-0.1592	-1.2121	0.0219	0.0000	0.0000	0.0000	0.0000;
	889	1462	0.019091	0.057934	0.006878	114	114	114	0	0	1	-360	360	11.7055	-0.3102	-11.6822	-0.3920	0.0000	0.0000	0.0000	0.0000;
	1777	889	0.006529	0.019835	0.002357	114	114	114	0	0	1	-360	360	15.7884	0.2113	-15.7740	-0.4331	0.0000	0.0000	0.0000	0.0000;
	888	889	0.01	0.030331	0.003603	57	57	57	0	0	1	-360	360	-4.0670	-1.1440	4.0685	0.7433	0.0000	0.0000	0.0000	0.0000;
	1074	1391	0.038678	0.119669	0.013649	114	114	114	0	0	1	-360	360	-12.2602	-3.0442	12.3143	1.6814	0.0000	0.0000	0.0000	0.0000;
	1074	900	0.002645	0.008182	0.000961	114	114	114	0	0	1	-360	360	3.4401	5.6132	-3.4391	-5.7168	0.0000	0.0000	0.0000	0.0000;
	1848	952	0.01405	0.026033	0.003528	90	90	90	0	0	1	-360	360	-43.4051	-0.9482	43.6379	0.9761	0.0000	0.0000	0.0000	0.0000;
	1574	860	0.012727	0.043388	0.004581	114	114	114	0	0	1	-360	360	16.6817	-1.6469	-16.6507	1.2254	0.0000	0.0000	0.0000	0.0000;
	994	1373	0.002149	0.014711	0.00167	152	152	152	0	0	1	-360	360	-26.2910	-2.3890	26.3038	2.2823	0.0000	0.0000	0.0000	0.0000;
	1288	1687	0.007686	0.020496	0.002246	120	120	120	0	0	1	-360	360	1.3179	-3.9591	-1.3168	3.7016	0.0000	0.0000	0.0000	0.0000;
	1822	1374	0.002645	0.01876	0.001951	152	152	152	0	0	1	-360	360	-49.7162	-11.5996	49.7756	11.7939	0.0000	0.0000	0.0000	0.0000;
	1823	1375	0.002645	0.01876	0.001951	152	152	152	0	0	1	-360	360	33.1518	0.8860	-33.1267	-0.9333	0.0000	0.0000	0.0000	0.0000;
	1898	1575	0.015124	0.041157	0.004104	114	114	114	0	0	1	-360	360	4.0325	-1.3935	-4.0302	0.9231	0.0000	0.0000	0.0000	0.0000;
	914	1536	0.008926	0.023719	0.003146	114	114	114	0	0	1	-360	360	8.2497	-0.2440	-8.2444	-0.1040	0.0000	0.0000	0.0000	0.0000;
	1075	1092	0.04124	0.076446	0.007979	90	90	90	0	0	1	-360	360	-0.5214	5.1124	0.5329	-5.9761	0.0000	0.0000	0.0000	0.0000;
	1392	1163	0.005207	0.012231	0.002452	114	114	114	0	0	1	-360	360	0.1997	-4.4319	-0.1988	4.1504	0.0000	0.0000	0.0000	0.0000;
	1071	1574	0.015207	0.040083	0.004366	120	120	120	0	0	1	-360	360	18.6455	-2.2053	-18.5993	1.8232	0.0000	0.0000	0.0000	0.0000;
	1616	1373	0.004711	0.015289	0.001605	140	140	140	0	0	1	-360	360	-21.9150	-1.3049	21.9345	1.1812	0.0000	0.0000	0.0000	0.0000;
	1457	1074	0.010909	0.035289	0.003691	114	114	114	0	0	1	-360	360	-12.9193	1.0394	12.9359	-1.3964	0.0000	0.0000	0.0000	0.0000;
	1528	1456	0.031901	0.106364	0.011251	114	114	114	0	0	1	-360	360	-2.9706	0.0147	2.9733	-1.2559	0.0000	0.0000	0.0000	0.0000;
	1329	1375	0.001653	0.011157	0.001239	152	152	152	0	0	1	-360	360	-46.1943	1.3162	46.2249	-1.2528	0.0000	0.0000	0.0000	0.0000;
	1449	1304	0.006529	0.020909	0.002214	114	114	114	0	0	1	-360	360	3.0810	-0.6850	-3.0804	0.4406	0.0000	0.0000	0.0000	0.0000;
	1529	1305	0.021984	0.070744	0.007439	114	114	114	0	0	1	-360	360	-0.5814	-0.9067	0.5815	0.0803	0.0000	0.0000	0.0000	0.0000;
	1777	1693	0.045124	0.233802	0.024389	114	114	114	0	0	1	-360	360	-21.7634	-5.2914	21.9590	3.5046	0.0000	0.0000	0.0000	0.0000;
	1777	1687	0.045703	0.237025	0.024841	114	114	114	0	0	1	-360	360	-21.2292	-3.6446	21.4138	1.7599	0.0000	0.0000	0.0000	0.0000;
	1393	1160	0.000826	0.002645	0.000312	140	140	140	0	0	1	-360	360	0.0000	-0.0360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1638	995	0.004298	0.00719	0.01602	120	120	120	0	0	1	-360	360	-7.2654	4.4008	7.2685	-6.2445	0.0000	0.0000	0.0000	0.0000;
	1778	1180	0.058099	0.13124	0.012928	90	90	90	0	0	1	-360	360	-2.9472	2.5523	2.9572	-3.9844	0.0000	0.0000	0.0000	0.0000;
	1374	1560	0.003884	0.012562	0.001326	114	114	114	0	0	1	-360	360	38.8819	-0.9534	-38.8316	0.9618	0.0000	0.0000	0.0000	0.0000;
	1384	1574	0.001653	0.005793	0	97	97	97	0	0	1	-360	360	-17.9040	0.9740	17.9086	-0.9578	0.0000	0.0000	0.0000	0.0000;
	1385	1575	0.001653	0.005793	0	97	97	97	0	0	1	-360	360	-24.4130	1.1390	24.4215	-1.1092	0.0000	0.0000	0.0000	0.0000;
	879	901	0.003967	0.012149	0.001391	114	114	114	0	0	1	-360	360	8.6759	-2.8494	-8.6729	2.7037	0.0000	0.0000	0.0000	0.0000;
	1579	1393	0.018017	0.054793	0.006483	114	114	114	0	0	1	-360	360	-18.2453	0.6429	18.2976	-1.2301	0.0000	0.0000	0.0000	0.0000;
	1849	1465	0.017851	0.03438	0.004874	90	90	90	0	0	1	-360	360	28.0913	-1.7990	-27.9670	1.4862	0.0000	0.0000	0.0000	0.0000;
	1537	952	0.006777	0.01595	0.002253	114	114	114	0	0	1	-360	360	0.8014	0.2269	-0.8013	-0.4859	0.0000	0.0000	0.0000	0.0000;
	1302	1463	0.006612	0.021074	0.002294	97	97	97	0	0	1	-360	360	-10.2839	-0.3823	10.2901	0.1451	0.0000	0.0000	0.0000	0.0000;
	1857	1897	0.02	0.056529	0.005397	120	120	120	0	0	1	-360	360	15.0806	-0.6199	-15.0416	0.1019	0.0000	0.0000	0.0000	0.0000;
	995	1328	0.000579	0.003884	0.000452	152	152	152	0	0	1	-360	360	-36.3575	3.0145	36.3641	-3.0219	0.0000	0.0000	0.0000	0.0000;
	1307	1392	0.043719	0.115041	0.011948	120	120	120	0	0	1	-360	360	17.2684	-0.7982	-17.1570	-0.2976	0.0000	0.0000	0.0000	0.0000;
	1448	1751	0.032562	0.104628	0.011026	114	114	114	0	0	1	-360	360	-7.8340	0.0098	7.8521	-1.1798	0.0000	0.0000	0.0000	0.0000;
	1075	1303	0.049422	0.164628	0.016129	114	114	114	0	0	1	-360	360	3.0720	-3.7670	-3.0641	1.9922	0.0000	0.0000	0.0000	0.0000;
	1006	1766	0.011735	0.03562	0.004228	114	114	114	0	0	1	-360	360	-33.1579	-5.1088	33.2739	4.9776	0.0000	0.0000	0.0000	0.0000;
	1795	1767	0.010578	0.029091	0.003349	114	114	114	0	0	1	-360	360	-7.6703	9.9058	7.6853	-10.2428	0.0000	0.0000	0.0000	0.0000;
	1767	858	0.005207	0.015785	0.001868	140	140	140	0	0	1	-360	360	0.0000	-0.2106	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1768	838	0.00157	0.001983	0.00037	90	90	90	0	0	1	-360	360	4.8773	0.3489	-4.8770	-0.3900	0.0000	0.0000	0.0000	0.0000;
	1767	839	0.001488	0.001818	0.000353	90	90	90	0	0	1	-360	360	0.0000	-0.0398	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1768	840	0.000496	0.000579	0.000111	90	90	90	0	0	1	-360	360	6.0814	30.9647	-6.0770	-30.9720	0.0000	0.0000	0.0000	0.0000;
	1768	841	0.001074	0.001322	0.000252	90	90	90	0	0	1	-360	360	0.0000	-0.0282	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1796	1768	0.009917	0.030331	0.003557	120	120	120	0	0	1	-360	360	-13.9164	19.4830	13.9674	-19.7278	0.0000	0.0000	0.0000	0.0000;
	927	1867	0.023141	0.028926	0.005498	90	90	90	0	0	1	-360	360	0.4908	-2.8735	-0.4894	2.2616	0.0000	0.0000	0.0000	0.0000;
	1254	1348	0.022149	0.04281	0.008245	120	120	120	0	0	1	-360	360	21.6782	4.9116	-21.5800	-5.6434	0.0000	0.0000	0.0000	0.0000;
	870	928	0.020827	0.026446	0.004884	90	90	90	0	0	1	-360	360	15.9799	-1.9627	-15.9320	1.4776	0.0000	0.0000	0.0000	0.0000;
	1008	870	0.018512	0.058347	0.006326	90	90	90	0	0	1	-360	360	18.0741	-1.9496	-18.0200	1.4095	0.0000	0.0000	0.0000	0.0000;
	868	870	0.000496	0.000826	8.7e-05	90	90	90	0	0	1	-360	360	-2.0400	-0.5630	2.0400	0.5533	0.0000	0.0000	0.0000	0.0000;
	1767	1254	0.006942	0.019091	0.001938	120	120	120	0	0	1	-360	360	-9.9523	10.0112	9.9647	-10.1954	0.0000	0.0000	0.0000	0.0000;
	1791	1254	0.00686	0.010165	0.001747	76	76	76	0	0	1	-360	360	-17.0315	6.9956	17.0522	-7.1612	0.0000	0.0000	0.0000	0.0000;
	1117	1867	0.000496	0.00157	0.000186	57	57	57	0	0	1	-360	360	-11.7850	1.0530	11.7856	-1.0718	0.0000	0.0000	0.0000	0.0000;
	1795	1604	0.005702	0.018512	0.001909	114	114	114	0	0	1	-360	360	-3.8577	6.1056	3.8604	-6.3127	0.0000	0.0000	0.0000	0.0000;
	1795	869	0.021322	0.06843	0.007265	140	140	140	0	0	1	-360	360	1.8146	-0.3368	-1.8140	-0.4830	0.0000	0.0000	0.0000	0.0000;
	1745	1359	0.002562	0.005868	0.000794	57	57	57	0	0	1	-360	360	-9.0650	-2.4300	9.0671	2.3477	0.0000	0.0000	0.0000	0.0000;
	1746	1360	0.001983	0.005041	0.000649	57	57	57	0	0	1	-360	360	-7.9320	-1.6200	7.9332	1.5519	0.0000	0.0000	0.0000	0.0000;
	1118	1868	0.000579	0.001818	0.00022	57	57	57	0	0	1	-360	360	-0.6790	0.0000	0.6790	-0.0246	0.0000	0.0000	0.0000	0.0000;
	1868	1337	0.005124	0.01562	0.001849	114	114	114	0	0	1	-360	360	-5.1700	-0.1241	5.1712	-0.0787	0.0000	0.0000	0.0000	0.0000;
	1475	1564	0.003636	0.011074	0.001314	114	114	114	0	0	1	-360	360	4.8978	-10.7776	-4.8933	10.6433	0.0000	0.0000	0.0000	0.0000;
	1796	1565	0.00595	0.019917	0.001953	114	114	114	0	0	1	-360	360	-3.5263	10.7778	3.5332	-10.9752	0.0000	0.0000	0.0000	0.0000;
	1244	1359	0.01	0.016529	0.001783	76	76	76	0	0	1	-360	360	36.5916	-3.1298	-36.4693	3.1359	0.0000	0.0000	0.0000	0.0000;
	1594	1243	0.023388	0.032562	0.005065	90	90	90	0	0	1	-360	360	43.9105	-2.1430	-43.5076	2.1407	0.0000	0.0000	0.0000	0.0000;
	1605	1085	0.006612	0.021488	0.002222	114	114	114	0	0	1	-360	360	-12.9295	4.9783	12.9408	-5.1925	0.0000	0.0000	0.0000	0.0000;
	1253	1584	0.003636	0.011074	0.001317	114	114	114	0	0	1	-360	360	23.2904	-4.1770	-23.2724	4.0831	0.0000	0.0000	0.0000	0.0000;
	1253	1461	0.008017	0.024215	0.00287	76	76	76	0	0	1	-360	360	-3.6460	-1.5494	3.6471	1.2281	0.0000	0.0000	0.0000	0.0000;
	1499	1460	0.012645	0.037025	0.003359	120	120	120	0	0	1	-360	360	7.9670	2.4906	-7.9591	-2.8482	0.0000	0.0000	0.0000	0.0000;
	1585	1084	0.005868	0.017851	0.00212	114	114	114	0	0	1	-360	360	15.3342	-4.6510	-15.3209	4.4520	0.0000	0.0000	0.0000	0.0000;
	1254	1664	0.027355	0.092066	0.008835	114	114	114	0	0	1	-360	360	2.9541	-0.2318	-2.9520	-0.7540	0.0000	0.0000	0.0000	0.0000;
	1091	1500	0.001736	0.005124	0.000472	120	120	120	0	0	1	-360	360	9.2155	2.4808	-9.2141	-2.5303	0.0000	0.0000	0.0000	0.0000;
	1656	1091	0.02157	0.061322	0.005	120	120	120	0	0	1	-360	360	12.9913	2.6474	-12.9579	-3.1226	0.0000	0.0000	0.0000	0.0000;
	1091	1090	0.003141	0.003884	0.000745	57	57	57	0	0	1	-360	360	3.7424	0.6418	-3.7420	-0.7260	0.0000	0.0000	0.0000	0.0000;
	1811	1795	0.011901	0.037686	0.00409	114	114	114	0	0	1	-360	360	-20.8345	-2.4727	20.8810	2.1584	0.0000	0.0000	0.0000	0.0000;
	1768	1253	0.006777	0.020579	0.001953	120	120	120	0	0	1	-360	360	-24.9261	-11.5574	24.9716	11.4756	0.0000	0.0000	0.0000	0.0000;
	1349	1359	0.025289	0.04719	0.009431	120	120	120	0	0	1	-360	360	18.1777	5.2837	-18.0948	-6.1695	0.0000	0.0000	0.0000	0.0000;
	1792	1474	0.003141	0.009504	0.00113	114	114	114	0	0	1	-360	360	12.9523	-7.8873	-12.9459	7.7795	0.0000	0.0000	0.0000	0.0000;
	956	1796	0.034298	0.109421	0.011715	114	114	114	0	0	1	-360	360	-17.6640	-3.2568	17.7623	2.2559	0.0000	0.0000	0.0000	0.0000;
	1796	1009	0.014545	0.045785	0.005055	114	114	114	0	0	1	-360	360	21.6549	-1.3823	-21.5944	1.0021	0.0000	0.0000	0.0000	0.0000;
	1795	1489	0.019587	0.062975	0.006621	120	120	120	0	0	1	-360	360	18.2536	-1.3916	-18.1957	0.8303	0.0000	0.0000	0.0000	0.0000;
	1843	1170	0.003554	0.011157	0.001258	140	140	140	0	0	1	-360	360	84.4369	13.9208	-84.2242	-13.4068	0.0000	0.0000	0.0000	0.0000;
	1275	1367	0.001983	0.006364	0.000668	114	114	114	0	0	1	-360	360	61.1680	10.0666	-61.1044	-9.9425	0.0000	0.0000	0.0000	0.0000;
	1358	1287	0.000909	0.006446	0.000665	152	152	152	0	0	1	-360	360	-52.3400	-16.3111	52.3626	16.3916	0.0000	0.0000	0.0000	0.0000;
	1629	1358	0.004298	0.030083	0.003228	232	232	232	0	0	1	-360	360	-40.9178	-13.4351	40.9844	13.5147	0.0000	0.0000	0.0000	0.0000;
	1356	1358	0.003141	0.005868	0.000559	90	90	90	0	0	1	-360	360	-11.3520	-2.8570	11.3556	2.7964	0.0000	0.0000	0.0000	0.0000;
	1600	1415	0.009587	0.02595	0.002885	120	120	120	0	0	1	-360	360	-11.2591	0.9591	11.2694	-1.2746	0.0000	0.0000	0.0000	0.0000;
	907	880	0.010413	0.03157	0.003734	140	140	140	0	0	1	-360	360	-4.1930	-1.1340	4.1946	0.7033	0.0000	0.0000	0.0000	0.0000;
	1630	1806	0.002645	0.007934	0.000941	140	140	140	0	0	1	-360	360	19.9603	3.5125	-19.9511	-3.5967	0.0000	0.0000	0.0000	0.0000;
	908	881	0.010083	0.030579	0.00362	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.4227	0.0000	0.0000	0.0000	0.0000;
	1634	1877	0.012314	0.03157	0.003463	120	120	120	0	0	1	-360	360	35.2311	8.3993	-35.0962	-8.4665	0.0000	0.0000	0.0000	0.0000;
	1569	1453	0.001901	0.006033	0.000632	114	114	114	0	0	1	-360	360	-7.5305	-1.4034	7.5315	1.3315	0.0000	0.0000	0.0000	0.0000;
	1740	1569	0.003554	0.011488	0.001205	114	114	114	0	0	1	-360	360	-7.5288	-1.5787	7.5305	1.4416	0.0000	0.0000	0.0000	0.0000;
	1569	1567	0.001322	0.003223	0.000322	90	90	90	0	0	1	-360	360	0.0000	-0.0382	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	925	1042	0.003471	0.011074	0.001159	140	140	140	0	0	1	-360	360	13.2832	5.8358	-13.2770	-5.9530	0.0000	0.0000	0.0000	0.0000;
	926	1043	0.003388	0.011074	0.001154	140	140	140	0	0	1	-360	360	0.0000	-0.1389	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1843	1376	0.009421	0.029917	0.003214	140	140	140	0	0	1	-360	360	27.0467	3.6567	-26.9892	-3.8667	0.0000	0.0000	0.0000	0.0000;
	1646	1473	0.007107	0.022066	0.002517	140	140	140	0	0	1	-360	360	-12.7012	-7.7618	12.7142	7.4990	0.0000	0.0000	0.0000	0.0000;
	1623	1646	0.000992	0.003058	0.000351	114	114	114	0	0	1	-360	360	-12.6994	-7.8506	12.7012	7.8141	0.0000	0.0000	0.0000	0.0000;
	1645	1646	0.00124	0.003636	0.000436	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0523	0.0000	0.0000	0.0000	0.0000;
	1413	985	0.000826	0.002479	0.000295	140	140	140	0	0	1	-360	360	20.8615	-2.1987	-20.8584	2.1726	0.0000	0.0000	0.0000	0.0000;
	1063	1065	0.001818	0.005455	0.000651	29	29	29	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0769	0.0000	0.0000	0.0000	0.0000;
	1555	1206	0.003223	0.010413	0.001079	140	140	140	0	0	1	-360	360	-5.8941	2.4955	5.8952	-2.6202	0.0000	0.0000	0.0000	0.0000;
	1620	1555	0.003719	0.011735	0.001309	140	140	140	0	0	1	-360	360	-5.8928	2.3356	5.8941	-2.4873	0.0000	0.0000	0.0000	0.0000;
	1553	1555	0.002397	0.00719	0.00075	120	120	120	0	0	1	-360	360	-0.0000	-0.0810	0.0000	-0.0082	0.0000	0.0000	0.0000	0.0000;
	1763	984	0.01281	0.039008	0.004576	140	140	140	0	0	1	-360	360	-8.4964	4.1695	8.5062	-4.6852	0.0000	0.0000	0.0000	0.0000;
	1927	1286	0.011983	0.038595	0.004056	140	140	140	0	0	1	-360	360	-44.4689	-10.4622	44.6790	10.6533	0.0000	0.0000	0.0000	0.0000;
	1111	1056	0.004959	0.016694	0.001597	140	140	140	0	0	1	-360	360	6.9151	1.4368	-6.9130	-1.6200	0.0000	0.0000	0.0000	0.0000;
	1111	1057	0.003388	0.010248	0.001217	140	140	140	0	0	1	-360	360	7.1405	0.9124	-7.1390	-1.0530	0.0000	0.0000	0.0000	0.0000;
	1711	1686	0.003388	0.011488	0.001096	140	140	140	0	0	1	-360	360	-32.8580	-2.2460	32.8885	2.2174	0.0000	0.0000	0.0000	0.0000;
	1309	1780	0.000165	0.000496	6.1e-05	140	140	140	0	0	1	-360	360	22.2203	2.9827	-22.2196	-2.9877	0.0000	0.0000	0.0000	0.0000;
	1416	1309	0.005289	0.016198	0.001854	140	140	140	0	0	1	-360	360	22.2426	2.7507	-22.2203	-2.9027	0.0000	0.0000	0.0000	0.0000;
	1308	1309	0.004215	0.007603	0.000673	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0799	0.0000	0.0000	0.0000	0.0000;
	863	1546	0.010992	0.027851	0.003979	120	120	120	0	0	1	-360	360	43.8594	12.9161	-43.6648	-12.8911	0.0000	0.0000	0.0000	0.0000;
	863	1760	0.005785	0.020496	0.002033	114	114	114	0	0	1	-360	360	-43.8594	-12.9046	43.9613	13.0239	0.0000	0.0000	0.0000	0.0000;
	862	863	0.000248	0.000826	9.7e-05	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0115	0.0000	0.0000	0.0000	0.0000;
	922	1111	0.000413	0.00124	0.000133	114	114	114	0	0	1	-360	360	-26.3404	-7.1312	26.3430	7.1231	0.0000	0.0000	0.0000	0.0000;
	934	922	0.002727	0.007686	0.000794	120	120	120	0	0	1	-360	360	-26.3233	-7.2314	26.3404	7.1851	0.0000	0.0000	0.0000	0.0000;
	1103	934	0.00438	0.014132	0.001486	114	114	114	0	0	1	-360	360	-21.9978	-5.0443	22.0166	4.9285	0.0000	0.0000	0.0000	0.0000;
	1269	1103	0.000331	0.001074	0.000123	114	114	114	0	0	1	-360	360	-10.6520	-3.4010	10.6523	3.3875	0.0000	0.0000	0.0000	0.0000;
	920	922	0.00124	0.003884	0.000452	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0539	0.0000	0.0000	0.0000	0.0000;
	934	933	0.003388	0.011405	0.001089	114	114	114	0	0	1	-360	360	4.3067	2.3029	-4.3060	-2.4300	0.0000	0.0000	0.0000	0.0000;
	1101	1103	0.002231	0.006942	0.000784	114	114	114	0	0	1	-360	360	-11.3430	-1.7420	11.3455	1.6568	0.0000	0.0000	0.0000	0.0000;
	1929	1229	0.004711	0.014463	0.00165	140	140	140	0	0	1	-360	360	25.0884	2.8992	-25.0635	-3.0214	0.0000	0.0000	0.0000	0.0000;
	1426	1840	0.005289	0.016116	0.001871	140	140	140	0	0	1	-360	360	-3.8683	-5.3835	3.8702	5.1671	0.0000	0.0000	0.0000	0.0000;
	1877	1426	0.002397	0.007273	0.000835	140	140	140	0	0	1	-360	360	0.7782	-3.6611	-0.7779	3.5629	0.0000	0.0000	0.0000	0.0000;
	1426	1425	0.000992	0.00124	0.000242	90	90	90	0	0	1	-360	360	4.6462	1.8205	-4.6460	-1.8490	0.0000	0.0000	0.0000	0.0000;
	1040	1257	0.004959	0.015124	0.001793	140	140	140	0	0	1	-360	360	-2.4932	0.1038	2.4934	-0.3222	0.0000	0.0000	0.0000	0.0000;
	1720	1583	0.002314	0.007355	0.000784	140	140	140	0	0	1	-360	360	-32.8096	-4.8770	32.8309	4.8516	0.0000	0.0000	0.0000	0.0000;
	1198	1644	0.008182	0.020331	0.002188	120	120	120	0	0	1	-360	360	-29.9419	-2.5583	30.0045	2.4551	0.0000	0.0000	0.0000	0.0000;
	1854	1198	0.004711	0.011735	0.001341	120	120	120	0	0	1	-360	360	-28.2099	-2.1374	28.2419	2.0592	0.0000	0.0000	0.0000	0.0000;
	1196	1198	0.000909	0.002066	0.000237	120	120	120	0	0	1	-360	360	-1.7000	-0.5270	1.7000	0.4991	0.0000	0.0000	0.0000	0.0000;
	1636	846	0.006529	0.020661	0.002234	140	140	140	0	0	1	-360	360	16.3226	-0.9175	-16.3078	0.7000	0.0000	0.0000	0.0000	0.0000;
	1807	1281	0.012314	0.041653	0.003976	140	140	140	0	0	1	-360	360	10.0870	0.9233	-10.0763	-1.3576	0.0000	0.0000	0.0000	0.0000;
	945	1634	0.025868	0.067107	0.007543	120	120	120	0	0	1	-360	360	-21.4847	-3.0234	21.5869	2.3888	0.0000	0.0000	0.0000	0.0000;
	1527	973	0.004959	0.015124	0.001769	140	140	140	0	0	1	-360	360	-31.5493	-6.5737	31.5920	6.4900	0.0000	0.0000	0.0000	0.0000;
	1549	1912	0.001405	0.003471	0.000506	120	120	120	0	0	1	-360	360	0.7588	-5.1546	-0.7584	5.0959	0.0000	0.0000	0.0000	0.0000;
	1852	1230	0.004132	0.012975	0.00144	140	140	140	0	0	1	-360	360	-18.4755	-0.1192	18.4873	-0.0169	0.0000	0.0000	0.0000	0.0000;
	1841	1674	0.017603	0.056281	0.005973	140	140	140	0	0	1	-360	360	49.3567	6.8344	-48.9997	-6.4179	0.0000	0.0000	0.0000	0.0000;
	1592	926	0.006364	0.020165	0.002188	114	114	114	0	0	1	-360	360	-47.8826	3.1223	48.0050	-2.9973	0.0000	0.0000	0.0000	0.0000;
	917	1546	0.008595	0.027603	0.002909	140	140	140	0	0	1	-360	360	40.5153	2.4270	-40.3948	-2.3810	0.0000	0.0000	0.0000	0.0000;
	1842	1547	0.026198	0.08405	0.008869	114	114	114	0	0	1	-360	360	48.9047	14.7977	-48.3365	-14.0269	0.0000	0.0000	0.0000	0.0000;
	1434	1546	0.040248	0.129587	0.013608	140	140	140	0	0	1	-360	360	10.1127	-0.4840	-10.0776	-0.9984	0.0000	0.0000	0.0000	0.0000;
	1685	976	0.006364	0.02124	0.002072	140	140	140	0	0	1	-360	360	-40.8212	-4.6548	40.9102	4.7011	0.0000	0.0000	0.0000	0.0000;
	1634	1346	0.019752	0.052975	0.005779	120	120	120	0	0	1	-360	360	25.1019	3.1248	-24.9962	-3.5310	0.0000	0.0000	0.0000	0.0000;
	1821	1346	0.001901	0.005868	0.00069	114	114	114	0	0	1	-360	360	-23.8539	-3.3891	23.8632	3.3360	0.0000	0.0000	0.0000	0.0000;
	1144	1821	0.002645	0.008678	0.000895	114	114	114	0	0	1	-360	360	-21.6862	-2.8181	21.6969	2.7471	0.0000	0.0000	0.0000	0.0000;
	1820	1821	8.3e-05	0.000165	1.7e-05	90	90	90	0	0	1	-360	360	-2.1570	-0.6440	2.1570	0.6420	0.0000	0.0000	0.0000	0.0000;
	1258	1843	0.011735	0.037107	0.004029	114	114	114	0	0	1	-360	360	-8.0555	-0.2002	8.0617	-0.2731	0.0000	0.0000	0.0000	0.0000;
	891	1015	0.00562	0.017355	0.001943	120	120	120	0	0	1	-360	360	-7.5253	-6.3426	7.5299	6.1265	0.0000	0.0000	0.0000	0.0000;
	1882	993	0.001901	0.006198	0.000651	114	114	114	0	0	1	-360	360	-28.0595	-1.1522	28.0720	1.1142	0.0000	0.0000	0.0000	0.0000;
	1599	1882	0.003802	0.011983	0.001283	140	140	140	0	0	1	-360	360	-22.9349	0.1486	22.9515	-0.2508	0.0000	0.0000	0.0000	0.0000;
	926	1599	0.002645	0.008182	0.000946	114	114	114	0	0	1	-360	360	-19.1876	0.7357	19.1957	-0.8245	0.0000	0.0000	0.0000	0.0000;
	1880	1882	8.3e-05	0.000165	1.7e-05	140	140	140	0	0	1	-360	360	-5.1080	-1.4050	5.1080	1.4030	0.0000	0.0000	0.0000	0.0000;
	1599	1598	0.00124	0.003802	0.000445	57	57	57	0	0	1	-360	360	3.7391	0.6758	-3.7390	-0.7290	0.0000	0.0000	0.0000	0.0000;
	1367	1477	0.002397	0.007438	0.000859	114	114	114	0	0	1	-360	360	45.1617	5.7912	-45.1201	-5.7647	0.0000	0.0000	0.0000	0.0000;
	1834	938	0.004132	0.013306	0.001411	114	114	114	0	0	1	-360	360	26.3704	3.9327	-26.3459	-4.0234	0.0000	0.0000	0.0000	0.0000;
	972	1834	0.007107	0.023058	0.002403	140	140	140	0	0	1	-360	360	46.1265	7.8773	-45.9981	-7.7506	0.0000	0.0000	0.0000	0.0000;
	1833	1834	0.000744	0.002397	0.000264	114	114	114	0	0	1	-360	360	-1.6458	-0.4844	1.6458	0.4528	0.0000	0.0000	0.0000	0.0000;
	1862	1005	0.000909	0.00281	0.000319	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0388	0.0000	0.0000	0.0000	0.0000;
	1231	1005	0.003141	0.013306	0.001379	162	162	162	0	0	1	-360	360	-40.8306	-5.9687	40.8748	5.9887	0.0000	0.0000	0.0000	0.0000;
	905	1231	0.000413	0.00124	0.000131	140	140	140	0	0	1	-360	360	-6.0090	-2.7130	6.0091	2.6976	0.0000	0.0000	0.0000	0.0000;
	906	1232	0.000413	0.001322	0.000135	140	140	140	0	0	1	-360	360	-3.0610	-1.4980	3.0610	1.4818	0.0000	0.0000	0.0000	0.0000;
	1202	1004	0.000661	0.002562	0.0003	114	114	114	0	0	1	-360	360	-2.2670	-0.4860	2.2670	0.4497	0.0000	0.0000	0.0000	0.0000;
	1362	1895	0.012893	0.046446	0.004487	114	114	114	0	0	1	-360	360	35.2519	14.8905	-35.0962	-14.8719	0.0000	0.0000	0.0000	0.0000;
	1433	1525	0.019422	0.062397	0.006585	114	114	114	0	0	1	-360	360	47.7802	18.4970	-47.3442	-17.8570	0.0000	0.0000	0.0000	0.0000;
	1524	1547	0.020827	0.067025	0.007069	140	140	140	0	0	1	-360	360	-37.1176	-8.4750	37.3825	8.5159	0.0000	0.0000	0.0000	0.0000;
	1826	1416	0.001736	0.004959	0.00053	120	120	120	0	0	1	-360	360	-21.3628	4.0543	21.3697	-4.0977	0.0000	0.0000	0.0000	0.0000;
	1112	965	0.007603	0.023141	0.002713	140	140	140	0	0	1	-360	360	-9.9332	4.6524	9.9408	-4.9570	0.0000	0.0000	0.0000	0.0000;
	1650	1286	0.001736	0.005372	0.000634	140	140	140	0	0	1	-360	360	-0.5660	-0.0000	0.5660	-0.0765	0.0000	0.0000	0.0000	0.0000;
	1041	1916	0.004132	0.012645	0.001498	140	140	140	0	0	1	-360	360	2.2682	-0.0876	-2.2680	-0.0950	0.0000	0.0000	0.0000	0.0000;
	1323	853	0.012479	0.039669	0.004279	140	140	140	0	0	1	-360	360	8.8631	0.5659	-8.8549	-1.0542	0.0000	0.0000	0.0000	0.0000;
	1190	1059	0.003471	0.010661	0.001246	140	140	140	0	0	1	-360	360	4.7418	0.1182	-4.7412	-0.2658	0.0000	0.0000	0.0000	0.0000;
	1734	1190	0.003636	0.013388	0.001203	140	140	140	0	0	1	-360	360	-2.2680	-1.1750	2.2682	1.0314	0.0000	0.0000	0.0000	0.0000;
	1188	1190	0	0.000826	7e-06	140	140	140	0	0	1	-360	360	7.0100	1.1490	-7.0100	-1.1495	0.0000	0.0000	0.0000	0.0000;
	1513	1926	0.004711	0.015289	0.001605	140	140	140	0	0	1	-360	360	-36.8140	-6.7824	36.8698	6.7735	0.0000	0.0000	0.0000	0.0000;
	1785	1232	0.004463	0.012893	0.001735	140	140	140	0	0	1	-360	360	2.9617	1.0149	-2.9614	-1.2224	0.0000	0.0000	0.0000	0.0000;
	1362	1482	0.027686	0.071488	0.007393	120	120	120	0	0	1	-360	360	54.1438	5.3991	-53.4707	-4.5492	0.0000	0.0000	0.0000	0.0000;
	852	1508	0.000826	0.002645	0.000305	140	140	140	0	0	1	-360	360	3.7391	0.7737	-3.7390	-0.8100	0.0000	0.0000	0.0000	0.0000;
	853	1509	0.000826	0.002645	0.00031	140	140	140	0	0	1	-360	360	8.2735	1.5844	-8.2730	-1.6200	0.0000	0.0000	0.0000	0.0000;
	1877	1887	0.005537	0.016942	0.00196	140	140	140	0	0	1	-360	360	7.1220	-2.4514	-7.1194	2.2269	0.0000	0.0000	0.0000	0.0000;
	1589	1644	0.006116	0.016612	0.001842	120	120	120	0	0	1	-360	360	-25.2360	-3.5945	25.2695	3.4677	0.0000	0.0000	0.0000	0.0000;
	1504	1546	0.003141	0.009421	0.001118	140	140	140	0	0	1	-360	360	-46.3471	0.8613	46.4050	-0.8179	0.0000	0.0000	0.0000	0.0000;
	854	1588	0.000744	0.002314	0.000254	114	114	114	0	0	1	-360	360	0.2100	-1.4880	-0.2100	1.4580	0.0000	0.0000	0.0000	0.0000;
	855	1589	0.000661	0.002149	0.000237	114	114	114	0	0	1	-360	360	-7.9320	-2.4300	7.9324	2.4032	0.0000	0.0000	0.0000	0.0000;
	1086	1673	0.000331	0.000992	0.000121	114	114	114	0	0	1	-360	360	-0.4530	-0.0000	0.4530	-0.0145	0.0000	0.0000	0.0000	0.0000;
	1087	1674	0.000331	0.000992	0.000119	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0143	0.0000	0.0000	0.0000	0.0000;
	1279	852	0.000331	0.000992	0.000114	114	114	114	0	0	1	-360	360	-14.4280	-2.8360	14.4286	2.8241	0.0000	0.0000	0.0000	0.0000;
	1280	853	0.000413	0.001322	0.000157	114	114	114	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0189	0.0000	0.0000	0.0000	0.0000;
	1736	1763	0.004298	0.013306	0.001496	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.1785	0.0000	0.0000	0.0000	0.0000;
	1034	1040	0.000165	0.000579	6.5e-05	114	114	114	0	0	1	-360	360	-0.2250	0.0000	0.2250	-0.0080	0.0000	0.0000	0.0000	0.0000;
	1035	1041	0.000165	0.000579	6.8e-05	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0083	0.0000	0.0000	0.0000	0.0000;
	1027	1004	0.000661	0.002149	0.000215	114	114	114	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0262	0.0000	0.0000	0.0000	0.0000;
	1028	1005	0.000661	0.002066	0.00021	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0256	0.0000	0.0000	0.0000	0.0000;
	1231	993	0.003554	0.011405	0.001183	114	114	114	0	0	1	-360	360	31.7338	2.8380	-31.7040	-2.8852	0.0000	0.0000	0.0000	0.0000;
	1802	1800	0.004132	0.013306	0.001396	114	114	114	0	0	1	-360	360	17.2502	-2.3839	-17.2395	2.2543	0.0000	0.0000	0.0000	0.0000;
	1338	1844	0.001488	0.004959	0.000469	114	114	114	0	0	1	-360	360	-13.1780	-4.1600	13.1804	4.1118	0.0000	0.0000	0.0000	0.0000;
	1928	1381	0.000992	0.003141	0.000365	114	114	114	0	0	1	-360	360	-28.8269	-4.2796	28.8339	4.2576	0.0000	0.0000	0.0000	0.0000;
	925	1379	0.004876	0.01719	0.001917	114	114	114	0	0	1	-360	360	-27.4458	-6.8605	27.4787	6.7495	0.0000	0.0000	0.0000	0.0000;
	1116	1524	0.004628	0.02157	0.003942	114	114	114	0	0	1	-360	360	-18.3231	-2.7472	18.3371	2.3657	0.0000	0.0000	0.0000	0.0000;
	1834	1276	0.009091	0.029752	0.003151	114	114	114	0	0	1	-360	360	13.3927	0.9937	-13.3790	-1.3273	0.0000	0.0000	0.0000	0.0000;
	1833	1834	8.3e-05	0.000826	0.000169	114	114	114	0	0	1	-360	360	-4.5892	-2.3916	4.5892	2.3714	0.0000	0.0000	0.0000	0.0000;
	1996	2108	0.000636	0.004826	0.000469	137	137	137	0	0	1	-360	360	13.9931	-4.3594	-13.9919	4.3149	0.0000	0.0000	0.0000	0.0000;
	2313	2172	0.033471	0.058934	0.005779	90	90	90	0	0	1	-360	360	-8.0565	0.4982	8.0759	-1.1192	0.0000	0.0000	0.0000	0.0000;
	2441	2172	0.029587	0.054711	0.005031	90	90	90	0	0	1	-360	360	10.9706	-1.5285	-10.9389	1.0142	0.0000	0.0000	0.0000	0.0000;
	2441	2173	0.033058	0.058603	0.005571	90	90	90	0	0	1	-360	360	-13.9176	1.4575	13.9746	-1.9940	0.0000	0.0000	0.0000	0.0000;
	2276	2184	0.048016	0.102636	0.013441	63	63	63	0	0	1	-360	360	-6.7794	0.2528	6.7993	-1.7310	0.0000	0.0000	0.0000	0.0000;
	2184	1948	0.013802	0.024207	0.002299	63	63	63	0	0	1	-360	360	-8.6403	1.5060	8.6498	-1.7503	0.0000	0.0000	0.0000	0.0000;
	2000	1993	0.056364	0.105207	0.01021	90	90	90	0	0	1	-360	360	5.7532	-0.9674	-5.7365	-0.1506	0.0000	0.0000	0.0000	0.0000;
	2386	2043	0.058934	0.123967	0.011969	90	90	90	0	0	1	-360	360	-6.2429	2.6015	6.2691	-3.8798	0.0000	0.0000	0.0000	0.0000;
	1995	1984	0.021744	0.05	0.005009	76	76	76	0	0	1	-360	360	6.1638	-2.3686	-6.1555	1.8268	0.0000	0.0000	0.0000	0.0000;
	2141	1984	0.034711	0.067438	0.006631	76	76	76	0	0	1	-360	360	-2.8344	1.0108	2.8375	-1.7468	0.0000	0.0000	0.0000	0.0000;
	1994	1943	0.019711	0.06676	0.006609	120	120	120	0	0	1	-360	360	-10.9216	-1.1206	10.9428	0.4522	0.0000	0.0000	0.0000	0.0000;
	2278	2444	0.03843	0.06562	0.006609	90	90	90	0	0	1	-360	360	-51.0425	16.6408	52.0416	-15.6768	0.0000	0.0000	0.0000	0.0000;
	2322	1950	0.02486	0.043479	0.00415	120	120	120	0	0	1	-360	360	-0.1830	0.4177	0.1831	-0.9046	0.0000	0.0000	0.0000	0.0000;
	2402	2322	0.022628	0.03957	0.00378	120	120	120	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.4437	0.0000	0.0000	0.0000	0.0000;
	2287	1986	0.022281	0.075446	0.00747	137	137	137	0	0	1	-360	360	-10.8344	0.4313	10.8581	-1.1805	0.0000	0.0000	0.0000	0.0000;
	2323	1991	0.025207	0.082636	0.00847	137	137	137	0	0	1	-360	360	-2.9538	2.5637	2.9577	-3.5249	0.0000	0.0000	0.0000	0.0000;
	2316	2352	0.020661	0.06686	0.006921	126	126	126	0	0	1	-360	360	-5.7991	1.4785	5.8057	-2.2591	0.0000	0.0000	0.0000	0.0000;
	2131	2179	0.059669	0.104554	0.009951	87	87	87	0	0	1	-360	360	-19.6056	5.8141	19.8286	-6.5605	0.0000	0.0000	0.0000	0.0000;
	1966	2452	0.027107	0.046124	0.00445	90	90	90	0	0	1	-360	360	-17.4098	8.1209	17.5017	-8.4547	0.0000	0.0000	0.0000	0.0000;
	2306	2452	0.033661	0.114017	0.011289	137	137	137	0	0	1	-360	360	-6.6365	4.3348	6.6574	-5.5125	0.0000	0.0000	0.0000	0.0000;
	2432	2197	0.024132	0.078512	0.008199	137	137	137	0	0	1	-360	360	5.5944	-2.8890	-5.5865	1.9818	0.0000	0.0000	0.0000	0.0000;
	2000	1998	0.018347	0.062562	0.00605	137	137	137	0	0	1	-360	360	-15.4380	1.6281	15.4774	-2.1773	0.0000	0.0000	0.0000	0.0000;
	2128	2227	0.024967	0.08457	0.008371	137	137	137	0	0	1	-360	360	36.0600	-5.0188	-35.7693	5.0576	0.0000	0.0000	0.0000	0.0000;
	2387	2309	0.022355	0.075727	0.007497	137	137	137	0	0	1	-360	360	-36.5145	-4.2297	36.7816	4.2799	0.0000	0.0000	0.0000	0.0000;
	2403	2219	0.016537	0.056008	0.005539	140	140	140	0	0	1	-360	360	-53.1295	-1.4482	53.5214	2.1098	0.0000	0.0000	0.0000	0.0000;
	2368	2403	0.026793	0.090719	0.008981	140	140	140	0	0	1	-360	360	-50.2460	-0.3558	50.8276	1.2675	0.0000	0.0000	0.0000	0.0000;
	2368	2015	0.014446	0.048942	0.00484	137	137	137	0	0	1	-360	360	47.4810	0.0628	-47.2010	0.3262	0.0000	0.0000	0.0000	0.0000;
	2073	2403	0.020421	0.036157	0.003451	140	140	140	0	0	1	-360	360	-2.3010	-0.5900	2.3019	0.1806	0.0000	0.0000	0.0000	0.0000;
	2333	2208	0.032041	0.108521	0.01074	137	137	137	0	0	1	-360	360	-15.7512	1.9683	15.8219	-2.9735	0.0000	0.0000	0.0000	0.0000;
	2335	2247	0.016124	0.05281	0.005411	114	114	114	0	0	1	-360	360	-26.8461	4.8656	26.9549	-5.1093	0.0000	0.0000	0.0000	0.0000;
	2051	2291	0.016603	0.056231	0.005571	10	10	10	0	0	1	-360	360	4.6211	-0.3537	-4.6180	-0.2810	0.0000	0.0000	0.0000	0.0000;
	2221	2136	0.104132	0.168512	0.01897	90	90	90	0	0	1	-360	360	0.6756	-2.6349	-0.6730	0.4710	0.0000	0.0000	0.0000	0.0000;
	2220	2401	0.033058	0.049587	0.00605	76	76	76	0	0	1	-360	360	-14.5023	6.8322	14.5781	-7.4095	0.0000	0.0000	0.0000	0.0000;
	2401	2082	0.1	0.165289	0.01822	76	76	76	0	0	1	-360	360	-24.8888	8.2045	25.5052	-9.2889	0.0000	0.0000	0.0000	0.0000;
	2153	2401	0.015703	0.046281	0.005009	76	76	76	0	0	1	-360	360	-10.2960	0.2660	10.3106	-0.7951	0.0000	0.0000	0.0000	0.0000;
	2207	1969	0.033802	0.055372	0.005951	67	67	67	0	0	1	-360	360	49.9201	-22.8401	-49.0597	23.5510	0.0000	0.0000	0.0000	0.0000;
	2137	2081	0.028934	0.047107	0.0053	90	90	90	0	0	1	-360	360	-5.7210	-0.7140	5.7292	0.1101	0.0000	0.0000	0.0000	0.0000;
	2397	2392	0.000554	0.001818	0.026831	118	118	118	0	0	1	-360	360	-9.2990	-1.5080	9.2994	-1.6097	0.0000	0.0000	0.0000	0.0000;
	2329	1970	0.011983	0.040562	0.00401	137	137	137	0	0	1	-360	360	-12.6913	2.0420	12.7083	-2.4545	0.0000	0.0000	0.0000	0.0000;
	2273	2384	0.002661	0.009017	0.000891	137	137	137	0	0	1	-360	360	-2.7600	-0.0280	2.7602	-0.0757	0.0000	0.0000	0.0000	0.0000;
	2274	2385	0.002661	0.009017	0.000891	137	137	137	0	0	1	-360	360	-6.3560	-0.3210	6.3569	0.2202	0.0000	0.0000	0.0000	0.0000;
	2382	2082	0.003314	0.005793	0.00061	90	90	90	0	0	1	-360	360	-9.5810	-1.0662	9.5836	0.9998	0.0000	0.0000	0.0000	0.0000;
	2393	2382	0.009917	0.022314	0.00242	90	90	90	0	0	1	-360	360	-5.8900	-0.8600	5.8930	0.5852	0.0000	0.0000	0.0000	0.0000;
	2384	2081	0.02562	0.043802	0.00455	90	90	90	0	0	1	-360	360	-12.8434	12.8125	12.9169	-13.2186	0.0000	0.0000	0.0000	0.0000;
	2384	1970	0.004132	0.006612	0.000731	90	90	90	0	0	1	-360	360	2.9012	-12.7368	-2.8953	12.6607	0.0000	0.0000	0.0000	0.0000;
	2392	2385	0.018182	0.035537	0.003901	90	90	90	0	0	1	-360	360	-15.0054	0.4397	15.0407	-0.8252	0.0000	0.0000	0.0000	0.0000;
	2385	1969	0.004132	0.006612	0.000731	90	90	90	0	0	1	-360	360	-27.2046	-1.0819	27.2308	1.0385	0.0000	0.0000	0.0000	0.0000;
	2421	2217	0.008769	0.029686	0.00294	137	137	137	0	0	1	-360	360	-2.5139	-2.8091	2.5149	2.4678	0.0000	0.0000	0.0000	0.0000;
	2329	2421	0.004446	0.01505	0.001491	137	137	137	0	0	1	-360	360	9.1913	-2.1030	-9.1879	1.9398	0.0000	0.0000	0.0000	0.0000;
	2391	2421	0.004967	0.016827	0.00167	137	137	137	0	0	1	-360	360	-11.6960	-1.0450	11.7018	0.8693	0.0000	0.0000	0.0000	0.0000;
	2269	1969	0.015703	0.047934	0.00515	137	137	137	0	0	1	-360	360	-22.1956	4.6746	22.2652	-5.0641	0.0000	0.0000	0.0000	0.0000;
	2269	2216	0.007438	0.023967	0.00257	137	137	137	0	0	1	-360	360	13.2016	-5.3536	-13.1888	5.0948	0.0000	0.0000	0.0000	0.0000;
	2398	2360	0.015703	0.027273	0.00264	137	137	137	0	0	1	-360	360	-31.3182	2.7105	31.4509	-2.7899	0.0000	0.0000	0.0000	0.0000;
	2390	2216	0.007438	0.02562	0.002781	137	137	137	0	0	1	-360	360	6.8621	-4.4779	-6.8579	4.1677	0.0000	0.0000	0.0000	0.0000;
	2390	2374	0.001653	0.004132	0.000409	137	137	137	0	0	1	-360	360	-16.8031	3.5289	16.8073	-3.5662	0.0000	0.0000	0.0000	0.0000;
	2398	2374	0.009091	0.028099	0.003071	137	137	137	0	0	1	-360	360	23.5872	-3.0465	-23.5433	2.8232	0.0000	0.0000	0.0000	0.0000;
	2375	2217	0.009091	0.029752	0.00319	137	137	137	0	0	1	-360	360	5.9707	-1.4434	-5.9678	1.0785	0.0000	0.0000	0.0000	0.0000;
	2375	2361	0.009091	0.028099	0.003071	137	137	137	0	0	1	-360	360	-12.6917	0.5834	12.7042	-0.9054	0.0000	0.0000	0.0000	0.0000;
	2216	2204	0.023141	0.058678	0.00574	120	120	120	0	0	1	-360	360	61.0719	-12.5131	-60.3037	13.7941	0.0000	0.0000	0.0000	0.0000;
	2339	2217	0.013719	0.044463	0.00439	137	137	137	0	0	1	-360	360	-33.6129	5.3252	33.7491	-5.3977	0.0000	0.0000	0.0000	0.0000;
	2217	2208	0.022314	0.071818	0.00702	137	137	137	0	0	1	-360	360	22.6908	1.2942	-22.5923	-1.7967	0.0000	0.0000	0.0000	0.0000;
	2422	2217	0.024893	0.084322	0.008349	120	120	120	0	0	1	-360	360	-41.2578	7.3727	41.6348	-7.0719	0.0000	0.0000	0.0000	0.0000;
	2372	2422	0.01362	0.046124	0.004569	120	120	120	0	0	1	-360	360	-29.5205	4.6937	29.6256	-4.8692	0.0000	0.0000	0.0000	0.0000;
	2285	2422	0.004537	0.015372	0.00152	120	120	120	0	0	1	-360	360	-11.6268	2.3451	11.6323	-2.5035	0.0000	0.0000	0.0000	0.0000;
	2284	2216	0.029496	0.099901	0.009891	137	137	137	0	0	1	-360	360	-35.6700	-8.8890	36.0205	8.9399	0.0000	0.0000	0.0000	0.0000;
	2055	2180	0.007521	0.012562	0.0013	57	57	57	0	0	1	-360	360	-1.0120	-0.1890	1.0121	0.0375	0.0000	0.0000	0.0000	0.0000;
	2339	2179	0.062149	0.105041	0.01058	90	90	90	0	0	1	-360	360	27.4319	-6.4712	-27.0136	5.9525	0.0000	0.0000	0.0000	0.0000;
	2444	2204	0.039669	0.069421	0.00666	90	90	90	0	0	1	-360	360	-55.4516	15.5898	56.6187	-14.3091	0.0000	0.0000	0.0000	0.0000;
	2396	2360	0.004959	0.015703	0.000801	90	90	90	0	0	1	-360	360	-36.2875	-1.7994	36.3432	1.8818	0.0000	0.0000	0.0000	0.0000;
	2412	1970	0.01438	0.02405	0.00249	90	90	90	0	0	1	-360	360	-25.6886	6.3421	25.7750	-6.4892	0.0000	0.0000	0.0000	0.0000;
	2208	2412	0.03876	0.064628	0.006679	90	90	90	0	0	1	-360	360	-19.7016	5.8385	19.8441	-6.3788	0.0000	0.0000	0.0000	0.0000;
	2412	2180	0.011653	0.02124	0.00221	90	90	90	0	0	1	-360	360	5.8445	0.0367	-5.8411	-0.2885	0.0000	0.0000	0.0000	0.0000;
	2082	2049	0.01157	0.019826	0.001941	90	90	90	0	0	1	-360	360	-28.3979	1.7638	28.4783	-1.8526	0.0000	0.0000	0.0000	0.0000;
	2049	2361	0.007942	0.015909	0.001529	90	90	90	0	0	1	-360	360	-31.6103	1.2686	31.6782	-1.3121	0.0000	0.0000	0.0000	0.0000;
	2381	2081	0.003314	0.005793	0.000549	90	90	90	0	0	1	-360	360	22.1798	-1.2787	-22.1658	1.2391	0.0000	0.0000	0.0000	0.0000;
	2381	2229	0.009091	0.017364	0.00165	90	90	90	0	0	1	-360	360	-26.2358	0.6757	26.2894	-0.7664	0.0000	0.0000	0.0000	0.0000;
	2395	2082	0.01157	0.018934	0.002011	90	90	90	0	0	1	-360	360	-4.0115	0.8888	4.0132	-1.1203	0.0000	0.0000	0.0000	0.0000;
	2396	2081	0.01157	0.018934	0.001909	90	90	90	0	0	1	-360	360	31.5005	0.6621	-31.4026	-0.7255	0.0000	0.0000	0.0000	0.0000;
	2396	2048	0.000826	0.002479	0.000271	90	90	90	0	0	1	-360	360	2.4870	0.4363	-2.4870	-0.4680	0.0000	0.0000	0.0000	0.0000;
	2380	2360	0.006967	0.023603	0.00234	137	137	137	0	0	1	-360	360	-6.9980	-0.5960	7.0009	0.3303	0.0000	0.0000	0.0000	0.0000;
	2377	2361	0.01157	0.036364	0.003991	120	120	120	0	0	1	-360	360	-31.7372	-2.3694	31.8376	2.2175	0.0000	0.0000	0.0000	0.0000;
	2376	2379	0.007066	0.02395	0.002369	137	137	137	0	0	1	-360	360	6.2624	0.6200	-6.2600	-0.8880	0.0000	0.0000	0.0000	0.0000;
	2377	2315	0.02562	0.082636	0.00854	137	137	137	0	0	1	-360	360	11.6419	-0.3975	-11.6122	-0.5001	0.0000	0.0000	0.0000	0.0000;
	2315	2268	0.021488	0.069421	0.00711	120	120	120	0	0	1	-360	360	6.1462	-0.4549	-6.1392	-0.3467	0.0000	0.0000	0.0000	0.0000;
	2360	2228	0.009917	0.017364	0.001721	90	90	90	0	0	1	-360	360	30.2329	-0.4821	-30.1560	0.4146	0.0000	0.0000	0.0000	0.0000;
	2395	2376	0.019826	0.033802	0.003291	90	90	90	0	0	1	-360	360	-2.2465	-1.7388	2.2477	1.3574	0.0000	0.0000	0.0000	0.0000;
	2082	1969	0.028934	0.047107	0.005271	90	90	90	0	0	1	-360	360	-47.0012	24.1785	47.6987	-23.6583	0.0000	0.0000	0.0000	0.0000;
	1944	2082	0.005	0.008793	0.00084	90	90	90	0	0	1	-360	360	-34.1700	6.9246	34.2223	-6.9304	0.0000	0.0000	0.0000	0.0000;
	2453	2304	0.028099	0.04876	0.00477	90	90	90	0	0	1	-360	360	17.8222	-8.5776	-17.7285	8.1880	0.0000	0.0000	0.0000	0.0000;
	1944	2453	0.023	0.040273	0.003841	90	90	90	0	0	1	-360	360	23.2940	-8.1586	-23.1742	7.9226	0.0000	0.0000	0.0000	0.0000;
	2352	2208	0.025463	0.084959	0.00635	137	137	137	0	0	1	-360	360	-11.1517	1.6991	11.1800	-2.3413	0.0000	0.0000	0.0000	0.0000;
	2032	2150	0.037711	0.127744	0.012649	137	137	137	0	0	1	-360	360	20.5946	-5.1610	-20.4446	4.2592	0.0000	0.0000	0.0000	0.0000;
	2227	2032	0.028959	0.100876	0.00999	137	137	137	0	0	1	-360	360	32.1443	-4.8686	-31.8736	4.6920	0.0000	0.0000	0.0000	0.0000;
	2250	2242	0.080661	0.142066	0.013479	120	120	120	0	0	1	-360	360	-19.5258	2.9939	19.8079	-4.0357	0.0000	0.0000	0.0000	0.0000;
	2378	2000	0.041157	0.104463	0.01043	120	120	120	0	0	1	-360	360	-4.8144	-0.7523	4.8229	-0.4006	0.0000	0.0000	0.0000	0.0000;
	2445	2378	0.058083	0.103752	0.00991	90	90	90	0	0	1	-360	360	-18.9724	1.6514	19.1640	-2.4141	0.0000	0.0000	0.0000	0.0000;
	2387	2192	0.025041	0.042893	0.004281	120	120	120	0	0	1	-360	360	12.8662	-9.3818	-12.8109	8.9932	0.0000	0.0000	0.0000	0.0000;
	2338	2308	0.016612	0.053802	0.005571	91	91	91	0	0	1	-360	360	17.8206	-2.8895	-17.7729	2.4159	0.0000	0.0000	0.0000	0.0000;
	1989	2341	0.015703	0.05157	0.00528	137	137	137	0	0	1	-360	360	6.1887	-2.5457	-6.1826	1.9829	0.0000	0.0000	0.0000	0.0000;
	2237	2341	0.024793	0.081322	0.008339	120	120	120	0	0	1	-360	360	-0.7881	0.7098	0.7886	-1.6299	0.0000	0.0000	0.0000	0.0000;
	2411	2150	0.03843	0.070413	0.00652	90	90	90	0	0	1	-360	360	5.1367	-1.9300	-5.1267	1.2221	0.0000	0.0000	0.0000	0.0000;
	2411	2386	0.002066	0.003636	0.000339	90	90	90	0	0	1	-360	360	-2.1876	2.9082	2.1879	-2.9455	0.0000	0.0000	0.0000	0.0000;
	2411	2018	0.04843	0.07405	0.00689	90	90	90	0	0	1	-360	360	-2.9491	-0.9782	2.9530	0.2150	0.0000	0.0000	0.0000	0.0000;
	2187	2007	0.002917	0.009876	0.00098	120	120	120	0	0	1	-360	360	-7.8670	-2.1320	7.8687	2.0252	0.0000	0.0000	0.0000	0.0000;
	2006	1988	0.006033	0.017851	0.00183	120	120	120	0	0	1	-360	360	12.1082	-8.9455	-12.0964	8.7703	0.0000	0.0000	0.0000	0.0000;
	2355	2017	0.042066	0.141322	0.013939	120	120	120	0	0	1	-360	360	-27.4288	0.1442	27.7111	-0.7759	0.0000	0.0000	0.0000	0.0000;
	2355	1972	0.029917	0.101364	0.010031	120	120	120	0	0	1	-360	360	25.8723	-2.3419	-25.6931	1.8288	0.0000	0.0000	0.0000	0.0000;
	2238	1972	0.011653	0.03957	0.00392	91	91	91	0	0	1	-360	360	-13.7389	1.6070	13.7591	-1.9738	0.0000	0.0000	0.0000	0.0000;
	1954	2231	0.003719	0.012479	0.001159	120	120	120	0	0	1	-360	360	11.5990	-6.7668	-11.5931	6.6540	0.0000	0.0000	0.0000	0.0000;
	1987	1978	0.005372	0.015124	0.001529	120	120	120	0	0	1	-360	360	-7.2949	6.2418	7.2993	-6.4053	0.0000	0.0000	0.0000	0.0000;
	2358	2265	0.004132	0.01405	0.001379	137	137	137	0	0	1	-360	360	12.1836	-11.3050	-12.1737	11.1806	0.0000	0.0000	0.0000	0.0000;
	2007	1978	0.000744	0.002314	0.00024	137	137	137	0	0	1	-360	360	8.0070	-7.0215	-8.0063	6.9963	0.0000	0.0000	0.0000	0.0000;
	2434	2270	0.007107	0.019422	0.002011	120	120	120	0	0	1	-360	360	-6.0269	0.0021	6.0291	-0.2259	0.0000	0.0000	0.0000	0.0000;
	1936	2006	0.004992	0.016909	0.001469	137	137	137	0	0	1	-360	360	-35.3453	2.5916	35.4001	-2.5744	0.0000	0.0000	0.0000	0.0000;
	2415	2237	0.019174	0.063876	0.00598	137	137	137	0	0	1	-360	360	-8.3415	0.7875	8.3538	-1.4072	0.0000	0.0000	0.0000	0.0000;
	2415	2263	0.003802	0.012636	0.001191	137	137	137	0	0	1	-360	360	11.9722	-0.1924	-11.9673	0.0774	0.0000	0.0000	0.0000	0.0000;
	2415	2235	0.001157	0.003802	0.00038	137	137	137	0	0	1	-360	360	-3.6307	-0.5951	3.6308	0.5536	0.0000	0.0000	0.0000	0.0000;
	2443	2061	0.014554	0.053141	0.00523	137	137	137	0	0	1	-360	360	-0.3595	-1.6769	0.3598	1.1006	0.0000	0.0000	0.0000	0.0000;
	2178	2394	0.020083	0.068182	0.00674	10	10	10	0	0	1	-360	360	-1.9910	-0.5520	1.9917	-0.2472	0.0000	0.0000	0.0000	0.0000;
	2206	2061	0.017107	0.057686	0.00567	137	137	137	0	0	1	-360	360	-1.1170	0.2090	1.1172	-0.8346	0.0000	0.0000	0.0000	0.0000;
	2307	2150	0.031959	0.055893	0.005329	90	90	90	0	0	1	-360	360	-21.9000	17.6810	22.1294	-17.8744	0.0000	0.0000	0.0000	0.0000;
	2307	2072	0.018479	0.032322	0.003081	90	90	90	0	0	1	-360	360	17.2150	-17.8420	-17.1145	17.6724	0.0000	0.0000	0.0000	0.0000;
	2072	2050	0.029008	0.051653	0.004891	90	90	90	0	0	1	-360	360	1.2924	-7.3511	-1.2790	6.8237	0.0000	0.0000	0.0000	0.0000;
	2183	2050	0.016612	0.029496	0.00288	90	90	90	0	0	1	-360	360	2.9728	7.0221	-2.9640	-7.3327	0.0000	0.0000	0.0000	0.0000;
	2263	2232	0.007934	0.026777	0.00264	137	137	137	0	0	1	-360	360	0.2983	0.5926	-0.2982	-0.8836	0.0000	0.0000	0.0000	0.0000;
	2235	2232	0.008636	0.017298	0.00166	90	90	90	0	0	1	-360	360	9.4027	-0.5969	-9.3958	0.4276	0.0000	0.0000	0.0000	0.0000;
	2203	1947	0.037603	0.067603	0.00651	90	90	90	0	0	1	-360	360	-25.9255	3.1524	26.1534	-3.4829	0.0000	0.0000	0.0000	0.0000;
	2236	2077	0.014132	0.046281	0.004751	137	137	137	0	0	1	-360	360	40.5849	-1.9285	-40.3813	2.0539	0.0000	0.0000	0.0000	0.0000;
	2209	2025	0.01	0.034793	0.00317	120	120	120	0	0	1	-360	360	9.2818	-0.0702	-9.2743	-0.2656	0.0000	0.0000	0.0000	0.0000;
	2434	1936	0.006099	0.020653	0.00204	137	137	137	0	0	1	-360	360	-26.9092	3.0208	26.9483	-3.1216	0.0000	0.0000	0.0000	0.0000;
	2156	1957	0.022132	0.07514	0.00742	91	91	91	0	0	1	-360	360	-30.1901	16.6181	30.4296	-16.6243	0.0000	0.0000	0.0000	0.0000;
	2277	1957	0.046777	0.057934	0.00462	91	91	91	0	0	1	-360	360	36.2097	-15.8674	-35.5566	16.1653	0.0000	0.0000	0.0000	0.0000;
	2314	2312	0.053876	0.094298	0.008981	90	90	90	0	0	1	-360	360	-4.3988	-0.3578	4.4084	-0.6097	0.0000	0.0000	0.0000	0.0000;
	2197	2025	0.041397	0.083554	0.00786	90	90	90	0	0	1	-360	360	-0.9645	-1.5408	0.9653	0.6466	0.0000	0.0000	0.0000	0.0000;
	2259	2230	0.009678	0.032793	0.00325	137	137	137	0	0	1	-360	360	-22.1111	1.1205	22.1527	-1.3518	0.0000	0.0000	0.0000	0.0000;
	1988	1946	0.011653	0.034628	0.00356	90	90	90	0	0	1	-360	360	31.6508	-3.8294	-31.5479	3.7269	0.0000	0.0000	0.0000	0.0000;
	2253	1988	0.022041	0.074669	0.007391	91	91	91	0	0	1	-360	360	-9.0525	0.3440	9.0684	-1.1387	0.0000	0.0000	0.0000	0.0000;
	2008	2253	0.012141	0.041124	0.00407	91	91	91	0	0	1	-360	360	-5.1597	-0.5697	5.1625	0.1130	0.0000	0.0000	0.0000	0.0000;
	2324	2192	0.040331	0.068934	0.006921	91	91	91	0	0	1	-360	360	-6.1380	8.7391	6.1809	-9.4502	0.0000	0.0000	0.0000	0.0000;
	2378	2250	0.033636	0.085446	0.008741	91	91	91	0	0	1	-360	360	-14.6968	1.4724	14.7626	-2.2905	0.0000	0.0000	0.0000	0.0000;
	2417	2237	0.016686	0.035289	0.00341	90	90	90	0	0	1	-360	360	-13.4332	3.8298	13.4629	-4.1437	0.0000	0.0000	0.0000	0.0000;
	2417	2371	0.057603	0.122149	0.01179	90	90	90	0	0	1	-360	360	13.0944	-2.3829	-13.0034	1.2803	0.0000	0.0000	0.0000	0.0000;
	2417	2235	8e-06	8.3e-05	0	90	90	90	0	0	1	-360	360	0.3388	-1.4469	-0.3388	1.4469	0.0000	0.0000	0.0000	0.0000;
	2378	2308	0.035289	0.060331	0.00605	90	90	90	0	0	1	-360	360	-5.9289	1.4480	5.9409	-2.1079	0.0000	0.0000	0.0000	0.0000;
	2039	2150	0.068083	0.124397	0.01294	90	90	90	0	0	1	-360	360	-12.1927	0.3587	12.2855	-1.6198	0.0000	0.0000	0.0000	0.0000;
	2312	2039	0.004298	0.010281	0.00143	90	90	90	0	0	1	-360	360	-5.7374	-0.0083	5.7387	-0.1457	0.0000	0.0000	0.0000	0.0000;
	2241	2077	0.016124	0.05405	0.005319	120	120	120	0	0	1	-360	360	9.9381	-0.1458	-9.9242	-0.4121	0.0000	0.0000	0.0000	0.0000;
	2387	2169	0.039669	0.069339	0.006631	90	90	90	0	0	1	-360	360	12.2443	13.6316	-12.1226	-14.1574	0.0000	0.0000	0.0000	0.0000;
	2296	2241	0.023967	0.042231	0.004141	90	90	90	0	0	1	-360	360	3.2332	-10.2890	-3.2096	9.8606	0.0000	0.0000	0.0000	0.0000;
	2296	2072	0.046446	0.081744	0.00801	90	90	90	0	0	1	-360	360	-8.6272	9.3390	8.6971	-10.1193	0.0000	0.0000	0.0000	0.0000;
	1965	2242	0.02276	0.077099	0.00763	120	120	120	0	0	1	-360	360	-17.2162	0.8660	17.2754	-1.5425	0.0000	0.0000	0.0000	0.0000;
	2324	2189	0.01124	0.038182	0.00378	91	91	91	0	0	1	-360	360	19.4992	-2.7550	-19.4610	2.4554	0.0000	0.0000	0.0000	0.0000;
	2313	2250	0.023471	0.057851	0.005929	91	91	91	0	0	1	-360	360	1.9565	-0.3662	-1.9558	-0.3024	0.0000	0.0000	0.0000	0.0000;
	2238	2235	0.009826	0.033223	0.003279	137	137	137	0	0	1	-360	360	22.6513	1.2358	-22.6057	-1.4445	0.0000	0.0000	0.0000	0.0000;
	2017	2008	0.013934	0.047207	0.004671	91	91	91	0	0	1	-360	360	-0.2886	-0.7292	0.2887	0.1947	0.0000	0.0000	0.0000	0.0000;
	2016	2015	0.006876	0.023281	0.002299	120	120	120	0	0	1	-360	360	-38.4492	0.3793	38.5380	-0.3422	0.0000	0.0000	0.0000	0.0000;
	2314	2169	0.034298	0.06	0.00574	90	90	90	0	0	1	-360	360	-9.0032	0.1568	9.0286	-0.7416	0.0000	0.0000	0.0000	0.0000;
	2156	2150	0.003893	0.013223	0.0013	91	91	91	0	0	1	-360	360	22.4091	-16.7811	-22.3817	16.7297	0.0000	0.0000	0.0000	0.0000;
	2443	2238	0.060496	0.118182	0.011589	90	90	90	0	0	1	-360	360	-8.4985	1.0179	8.5396	-2.2196	0.0000	0.0000	0.0000	0.0000;
	2338	2077	0.013719	0.044463	0.0046	91	91	91	0	0	1	-360	360	-32.4066	2.8815	32.5354	-2.9848	0.0000	0.0000	0.0000	0.0000;
	2254	2006	0.00519	0.014132	0.00143	120	120	120	0	0	1	-360	360	-44.9577	5.2939	45.0507	-5.2046	0.0000	0.0000	0.0000	0.0000;
	2371	2177	0.067438	0.118017	0.01126	10	10	10	0	0	1	-360	360	3.8114	-1.4213	-3.8020	0.2080	0.0000	0.0000	0.0000	0.0000;
	1965	2209	0.014521	0.049174	0.004869	90	90	90	0	0	1	-360	360	13.8572	-0.8120	-13.8328	0.3372	0.0000	0.0000	0.0000	0.0000;
	2254	2188	0.001818	0.004554	0.00046	91	91	91	0	0	1	-360	360	3.3142	2.0720	-3.3140	-2.1240	0.0000	0.0000	0.0000	0.0000;
	2230	2007	0.002587	0.00876	0.000871	137	137	137	0	0	1	-360	360	-31.0067	0.4318	31.0284	-0.4583	0.0000	0.0000	0.0000	0.0000;
	2236	2260	0.001901	0.006033	0.00061	137	137	137	0	0	1	-360	360	-17.2755	2.3969	17.2805	-2.4507	0.0000	0.0000	0.0000	0.0000;
	2231	2130	0.001744	0.004793	0.000479	120	120	120	0	0	1	-360	360	1.5501	-7.0240	-1.5493	6.9714	0.0000	0.0000	0.0000	0.0000;
	2236	1987	0.00686	0.021984	0.00228	137	137	137	0	0	1	-360	360	-31.3535	-0.7344	31.4124	0.6617	0.0000	0.0000	0.0000	0.0000;
	2283	2203	0.017017	0.055124	0.005711	137	137	137	0	0	1	-360	360	-17.7457	2.5041	17.7945	-2.9904	0.0000	0.0000	0.0000	0.0000;
	2270	2261	0.010281	0.021636	0.002101	90	90	90	0	0	1	-360	360	-15.1341	-0.5531	15.1547	0.3559	0.0000	0.0000	0.0000	0.0000;
	2324	2006	0.011256	0.038141	0.00378	91	91	91	0	0	1	-360	360	-24.1463	-6.6171	24.2080	6.3945	0.0000	0.0000	0.0000	0.0000;
	2418	2259	0.003033	0.010289	0.001019	120	120	120	0	0	1	-360	360	-9.2907	1.9031	9.2931	-2.0115	0.0000	0.0000	0.0000	0.0000;
	1954	2418	0.006174	0.017364	0.00174	120	120	120	0	0	1	-360	360	-27.0680	6.0708	27.1096	-6.1524	0.0000	0.0000	0.0000	0.0000;
	2434	2418	4.1e-05	0.000141	1e-05	120	120	120	0	0	1	-360	360	17.8190	-4.2500	-17.8189	4.2493	0.0000	0.0000	0.0000	0.0000;
	2242	2010	0.007314	0.012793	0.00122	90	90	90	0	0	1	-360	360	9.4767	0.6756	-9.4710	-0.8060	0.0000	0.0000	0.0000	0.0000;
	2241	2264	0.009587	0.024744	0.00251	120	120	120	0	0	1	-360	360	14.3393	0.2964	-14.3220	-0.5370	0.0000	0.0000	0.0000	0.0000;
	2242	2265	0.009587	0.024744	0.00251	120	120	120	0	0	1	-360	360	-3.8800	11.6150	3.8927	-11.8706	0.0000	0.0000	0.0000	0.0000;
	2160	2241	0.013438	0.023826	0.00227	90	90	90	0	0	1	-360	360	-2.2777	-3.8478	2.2799	3.5936	0.0000	0.0000	0.0000	0.0000;
	2262	2160	0.006983	0.012793	0.00098	90	90	90	0	0	1	-360	360	-2.1875	-3.9569	2.1887	3.8478	0.0000	0.0000	0.0000	0.0000;
	2242	2057	0.005744	0.019438	0.001919	137	137	137	0	0	1	-360	360	22.8876	8.4665	-22.8578	-8.5863	0.0000	0.0000	0.0000	0.0000;
	2260	2190	0.003388	0.010992	0.00114	137	137	137	0	0	1	-360	360	-33.0151	3.9603	33.0479	-3.9848	0.0000	0.0000	0.0000	0.0000;
	2190	2007	0.00281	0.009091	0.000939	137	137	137	0	0	1	-360	360	-39.2359	3.6228	39.2739	-3.6074	0.0000	0.0000	0.0000	0.0000;
	2262	2189	0.014752	0.049984	0.004949	90	90	90	0	0	1	-360	360	-12.2796	3.4413	12.3010	-3.9304	0.0000	0.0000	0.0000	0.0000;
	2358	2260	0.00405	0.013388	0.001379	137	137	137	0	0	1	-360	360	-7.6854	1.7630	7.6876	-1.9137	0.0000	0.0000	0.0000	0.0000;
	2445	1989	0.010314	0.017967	0.001711	90	90	90	0	0	1	-360	360	12.8344	-1.9464	-12.8187	1.7847	0.0000	0.0000	0.0000	0.0000;
	2355	2283	0.039504	0.072314	0.007279	90	90	90	0	0	1	-360	360	-9.1405	1.8557	9.1717	-2.6171	0.0000	0.0000	0.0000	0.0000;
	2254	1985	0.001653	0.005372	0.000549	137	137	137	0	0	1	-360	360	25.7315	-9.0609	-25.7207	9.0329	0.0000	0.0000	0.0000	0.0000;
	2358	1985	0.001818	0.00595	0.000629	137	137	137	0	0	1	-360	360	-16.2562	9.1910	16.2617	-9.2449	0.0000	0.0000	0.0000	0.0000;
	2130	2057	0.00405	0.013314	0.001379	137	137	137	0	0	1	-360	360	-12.8597	-8.1184	12.8678	7.9873	0.0000	0.0000	0.0000	0.0000;
	2262	2011	0.020347	0.035578	0.0034	90	90	90	0	0	1	-360	360	7.0131	1.0116	-7.0040	-1.3810	0.0000	0.0000	0.0000	0.0000;
	2261	2183	0.022719	0.039727	0.00379	90	90	90	0	0	1	-360	360	12.0291	7.4591	-11.9888	-7.8211	0.0000	0.0000	0.0000	0.0000;
	2442	1933	0.001289	0.003744	0.00038	114	114	114	0	0	1	-360	360	-41.9408	3.3797	41.9592	-3.3734	0.0000	0.0000	0.0000	0.0000;
	1971	2442	0.028331	0.073488	0.007451	108	108	108	0	0	1	-360	360	-35.9172	4.0665	36.2198	-4.2007	0.0000	0.0000	0.0000	0.0000;
	2068	1971	0.029669	0.076612	0.007771	108	108	108	0	0	1	-360	360	-33.7890	3.3762	34.0722	-3.5925	0.0000	0.0000	0.0000	0.0000;
	2333	2078	0.028256	0.095702	0.00947	137	137	137	0	0	1	-360	360	11.8792	-1.6853	-11.8444	0.7103	0.0000	0.0000	0.0000	0.0000;
	2215	2024	0.017289	0.058554	0.005801	137	137	137	0	0	1	-360	360	-6.2176	-0.3271	6.2234	-0.3223	0.0000	0.0000	0.0000	0.0000;
	2405	2069	0.007017	0.017521	0.000779	126	126	126	0	0	1	-360	360	7.4258	1.2480	-7.4223	-1.3288	0.0000	0.0000	0.0000	0.0000;
	2405	2213	0.023876	0.067107	0.00621	126	126	126	0	0	1	-360	360	-13.2320	-3.6553	13.2706	3.0468	0.0000	0.0000	0.0000	0.0000;
	2405	2143	0.003554	0.009587	0.000801	126	126	126	0	0	1	-360	360	5.8062	2.4073	-5.8050	-2.4960	0.0000	0.0000	0.0000	0.0000;
	2024	2214	0.027372	0.092132	0.009121	140	140	140	0	0	1	-360	360	-10.1874	-0.4647	10.2120	-0.5081	0.0000	0.0000	0.0000	0.0000;
	2215	2078	0.017917	0.061438	0.006009	137	137	137	0	0	1	-360	360	0.2286	-0.0079	-0.2286	-0.6843	0.0000	0.0000	0.0000	0.0000;
	2214	2131	0.037934	0.097521	0.00999	108	108	108	0	0	1	-360	360	39.7878	-3.7127	-39.2669	3.9042	0.0000	0.0000	0.0000	0.0000;
	2199	2095	0.013223	0.032893	0.00347	114	114	114	0	0	1	-360	360	30.2853	-9.7778	-30.1767	9.6226	0.0000	0.0000	0.0000	0.0000;
	2340	1932	0.005041	0.014132	0.00145	108	108	108	0	0	1	-360	360	-47.3357	6.3914	47.4281	-6.3134	0.0000	0.0000	0.0000	0.0000;
	2161	2440	0.037438	0.096529	0.009891	108	108	108	0	0	1	-360	360	7.7958	-12.5042	-7.7301	11.5200	0.0000	0.0000	0.0000	0.0000;
	2161	2060	0.020174	0.049587	0.00508	108	108	108	0	0	1	-360	360	-8.3488	13.0092	8.3918	-13.4892	0.0000	0.0000	0.0000	0.0000;
	2090	2059	0.015289	0.049669	0.005179	91	91	91	0	0	1	-360	360	6.5926	-6.7359	-6.5812	6.1808	0.0000	0.0000	0.0000	0.0000;
	2096	1976	0.033314	0.079818	0.007831	108	108	108	0	0	1	-360	360	46.3451	5.3197	-45.7413	-4.8005	0.0000	0.0000	0.0000	0.0000;
	2404	2218	0.038141	0.066711	0.00636	81	81	81	0	0	1	-360	360	-6.9102	0.2461	6.9250	-1.0108	0.0000	0.0000	0.0000	0.0000;
	2074	2404	0.000686	0.002347	0.00023	81	81	81	0	0	1	-360	360	-5.5300	-0.4730	5.5302	0.4451	0.0000	0.0000	0.0000	0.0000;
	2093	2404	8.3e-05	0.000141	1e-05	81	81	81	0	0	1	-360	360	-1.3800	0.6900	1.3800	-0.6912	0.0000	0.0000	0.0000	0.0000;
	2058	2219	0.013636	0.023802	0.00227	69	69	69	0	0	1	-360	360	-4.7880	0.5310	4.7906	-0.8013	0.0000	0.0000	0.0000	0.0000;
	2071	2219	0.008678	0.015124	0.00145	69	69	69	0	0	1	-360	360	-11.0630	-1.6720	11.0720	1.5122	0.0000	0.0000	0.0000	0.0000;
	2219	2096	0.005372	0.015446	0.00181	204	204	204	0	0	1	-360	360	58.6124	4.7167	-58.4590	-4.4943	0.0000	0.0000	0.0000	0.0000;
	2099	2059	0.02843	0.052066	0.00498	87	87	87	0	0	1	-360	360	13.9687	-7.7931	-13.9063	7.3370	0.0000	0.0000	0.0000	0.0000;
	2272	2099	0.02843	0.052066	0.00498	87	87	87	0	0	1	-360	360	15.8897	-7.6467	-15.8137	7.2151	0.0000	0.0000	0.0000	0.0000;
	2214	2210	0.003876	0.006686	0.000629	87	87	87	0	0	1	-360	360	5.4360	0.6788	-5.4350	-0.7500	0.0000	0.0000	0.0000	0.0000;
	2213	2212	0.007603	0.018017	0.001791	87	87	87	0	0	1	-360	360	18.0078	1.2651	-17.9864	-1.4219	0.0000	0.0000	0.0000	0.0000;
	2309	1976	0.011686	0.03957	0.003918	137	137	137	0	0	1	-360	360	-43.2446	-4.5239	43.4363	4.7195	0.0000	0.0000	0.0000	0.0000;
	2357	2218	0.003967	0.029174	0.002829	274	274	274	0	0	1	-360	360	-5.0498	-24.5856	5.0699	24.3827	0.0000	0.0000	0.0000	0.0000;
	2356	2046	0.000992	0.007934	0.00077	171	171	171	0	0	1	-360	360	-0.1036	22.4044	0.1077	-22.4664	0.0000	0.0000	0.0000	0.0000;
	2147	1937	0.02676	0.076893	0.00772	120	120	120	0	0	1	-360	360	53.2986	-4.3382	-52.6498	5.3013	0.0000	0.0000	0.0000	0.0000;
	2095	2046	0.000504	0.003967	0.000559	274	274	274	0	0	1	-360	360	36.0156	-17.0020	-36.0091	16.9848	0.0000	0.0000	0.0000	0.0000;
	2097	2046	0.000504	0.003967	0.000559	160	160	160	0	0	1	-360	360	-33.1968	-14.9256	33.2022	14.8999	0.0000	0.0000	0.0000	0.0000;
	1934	1935	0.00276	0.004826	0.00046	69	69	69	0	0	1	-360	360	34.0458	-0.9031	-34.0201	0.8906	0.0000	0.0000	0.0000	0.0000;
	1935	1933	0.013512	0.023488	0.002241	69	69	69	0	0	1	-360	360	22.0151	-3.2806	-21.9615	3.0951	0.0000	0.0000	0.0000	0.0000;
	2105	2087	0.009091	0.026446	0.002691	111	111	111	0	0	1	-360	360	-3.8835	2.1898	3.8851	-2.5106	0.0000	0.0000	0.0000	0.0000;
	2094	1933	0.031983	0.081066	0.008279	111	111	111	0	0	1	-360	360	-55.5797	4.8208	56.4017	-3.7533	0.0000	0.0000	0.0000	0.0000;
	2138	2094	0.006917	0.019223	0.001941	111	111	111	0	0	1	-360	360	-2.4801	-2.1220	2.4807	1.8883	0.0000	0.0000	0.0000	0.0000;
	2068	2066	0.005041	0.014207	0.0015	114	114	114	0	0	1	-360	360	34.5300	-4.2292	-34.4797	4.1894	0.0000	0.0000	0.0000	0.0000;
	1940	2138	0.01395	0.039983	0.00401	111	111	111	0	0	1	-360	360	1.2093	-1.7985	-1.2089	1.3140	0.0000	0.0000	0.0000	0.0000;
	2105	1940	0.01657	0.048901	0.004901	111	111	111	0	0	1	-360	360	1.6705	-2.7568	-1.6693	2.1675	0.0000	0.0000	0.0000	0.0000;
	2060	2059	0.003802	0.012149	0.001229	119	119	119	0	0	1	-360	360	-12.1718	14.2472	12.1835	-14.3508	0.0000	0.0000	0.0000	0.0000;
	1934	1932	0.00157	0.002727	0.000259	77	77	77	0	0	1	-360	360	-40.4248	-0.9559	40.4454	0.9593	0.0000	0.0000	0.0000	0.0000;
	2214	2205	0.017934	0.058182	0.006031	126	126	126	0	0	1	-360	360	0.2817	0.4587	-0.2816	-1.1576	0.0000	0.0000	0.0000	0.0000;
	2272	2213	0.06438	0.113802	0.01096	81	81	81	0	0	1	-360	360	-23.7177	7.3257	24.0691	-7.9688	0.0000	0.0000	0.0000	0.0000;
	2131	2129	0.002397	0.004132	0.00039	90	90	90	0	0	1	-360	360	13.2535	-6.0668	-13.2490	6.0301	0.0000	0.0000	0.0000	0.0000;
	2062	1932	0.014711	0.037364	0.003821	102	102	102	0	0	1	-360	360	-21.7110	-4.1482	21.7688	3.8192	0.0000	0.0000	0.0000	0.0000;
	2122	2062	0.025041	0.063636	0.007241	102	102	102	0	0	1	-360	360	-16.8533	-3.4028	16.9130	2.6612	0.0000	0.0000	0.0000	0.0000;
	2212	2211	0.016612	0.029174	0.002781	77	77	77	0	0	1	-360	360	10.3364	0.5109	-10.3210	-0.8050	0.0000	0.0000	0.0000	0.0000;
	2316	2205	0.01438	0.046529	0.004811	126	126	126	0	0	1	-360	360	4.4171	-1.7895	-4.4144	1.2406	0.0000	0.0000	0.0000	0.0000;
	2362	2199	0.036686	0.094298	0.009849	102	102	102	0	0	1	-360	360	37.4491	-8.4931	-37.0153	8.3938	0.0000	0.0000	0.0000	0.0000;
	2383	2079	0.029826	0.054628	0.00552	87	87	87	0	0	1	-360	360	2.1352	8.1335	-2.1159	-8.7422	0.0000	0.0000	0.0000	0.0000;
	2142	1992	0.003017	0.01	0.001019	126	126	126	0	0	1	-360	360	-8.4800	-0.8290	8.4818	0.7123	0.0000	0.0000	0.0000	0.0000;
	2070	1992	0.001612	0.005289	0.00054	126	126	126	0	0	1	-360	360	11.6166	0.4012	-11.6148	-0.4603	0.0000	0.0000	0.0000	0.0000;
	2070	2066	0.016446	0.042984	0.004431	114	114	114	0	0	1	-360	360	-24.5278	4.2462	24.6127	-4.5594	0.0000	0.0000	0.0000	0.0000;
	2224	2095	0.010331	0.03405	0.00348	114	114	114	0	0	1	-360	360	-9.3138	-4.4478	9.3227	4.0513	0.0000	0.0000	0.0000	0.0000;
	2362	2340	0.022893	0.062149	0.00636	102	102	102	0	0	1	-360	360	-38.7391	8.0681	39.0297	-8.0694	0.0000	0.0000	0.0000	0.0000;
	2129	2090	0.017521	0.05438	0.005641	91	91	91	0	0	1	-360	360	9.5610	-6.7271	-9.5406	6.1479	0.0000	0.0000	0.0000	0.0000;
	2280	2224	0.014628	0.047934	0.00491	126	126	126	0	0	1	-360	360	-2.4921	-4.3601	2.4948	3.7708	0.0000	0.0000	0.0000	0.0000;
	2332	2280	0.022066	0.071488	0.00747	126	126	126	0	0	1	-360	360	0.0027	-5.0219	0.0011	4.1281	0.0000	0.0000	0.0000	0.0000;
	2332	2070	0.017603	0.056942	0.00575	126	126	126	0	0	1	-360	360	-3.5997	4.6149	3.6052	-5.2914	0.0000	0.0000	0.0000	0.0000;
	2302	2095	0.016223	0.041793	0.00424	120	120	120	0	0	1	-360	360	-41.2360	-11.7804	41.4834	11.9030	0.0000	0.0000	0.0000	0.0000;
	2191	2096	0.009752	0.032066	0.003291	108	108	108	0	0	1	-360	360	-1.2332	-11.8965	1.2445	11.5388	0.0000	0.0000	0.0000	0.0000;
	2440	2191	0.034876	0.094876	0.009721	108	108	108	0	0	1	-360	360	3.2371	-12.6350	-3.1908	11.6085	0.0000	0.0000	0.0000	0.0000;
	2131	2128	0.006529	0.022066	0.002161	91	91	91	0	0	1	-360	360	39.0750	-5.0175	-38.9860	5.0728	0.0000	0.0000	0.0000	0.0000;
	2302	2147	0.013479	0.039289	0.00394	120	120	120	0	0	1	-360	360	84.5636	3.1125	-83.7606	-1.2408	0.0000	0.0000	0.0000	0.0000;
	2302	2094	0.026198	0.08595	0.008809	126	126	126	0	0	1	-360	360	-45.8996	8.1139	46.3750	-7.6181	0.0000	0.0000	0.0000	0.0000;
	2141	1993	0.046686	0.095446	0.00939	76	76	76	0	0	1	-360	360	-2.6016	-1.1498	2.6045	0.1036	0.0000	0.0000	0.0000	0.0000;
	2123	1994	0.033967	0.059422	0.00567	90	90	90	0	0	1	-360	360	-16.4788	-2.9662	16.5646	2.4871	0.0000	0.0000	0.0000	0.0000;
	2300	2019	0.027364	0.091818	0.00907	90	90	90	0	0	1	-360	360	-22.2313	2.6316	22.3509	-3.2800	0.0000	0.0000	0.0000	0.0000;
	2321	2020	0.02719	0.087934	0.009099	137	137	137	0	0	1	-360	360	-24.2736	2.8010	24.4172	-3.3748	0.0000	0.0000	0.0000	0.0000;
	2123	2036	0.029669	0.049256	0.004859	90	90	90	0	0	1	-360	360	0.6028	-0.8388	-0.6026	0.3032	0.0000	0.0000	0.0000	0.0000;
	2321	1998	0.025207	0.081818	0.009169	137	137	137	0	0	1	-360	360	19.6636	-3.1330	-19.5764	2.3762	0.0000	0.0000	0.0000	0.0000;
	2413	2054	0.059446	0.103983	0.00992	76	76	76	0	0	1	-360	360	-18.7336	1.0872	18.9179	-1.9060	0.0000	0.0000	0.0000	0.0000;
	1948	2413	0.018769	0.032818	0.003129	76	76	76	0	0	1	-360	360	-14.7318	0.0933	14.7676	-0.3867	0.0000	0.0000	0.0000	0.0000;
	2185	2413	0.021107	0.071504	0.007081	76	76	76	0	0	1	-360	360	-3.9630	-0.0970	3.9659	-0.7004	0.0000	0.0000	0.0000	0.0000;
	2410	2019	0.024727	0.054	0.00523	90	90	90	0	0	1	-360	360	-3.8691	-1.2285	3.8725	0.6297	0.0000	0.0000	0.0000	0.0000;
	2323	2410	0.053826	0.110008	0.010609	90	90	90	0	0	1	-360	360	-1.4722	-2.5287	1.4750	1.3091	0.0000	0.0000	0.0000	0.0000;
	2163	2410	0.00257	0.004488	0.000431	90	90	90	0	0	1	-360	360	-2.3940	0.0310	2.3941	-0.0806	0.0000	0.0000	0.0000	0.0000;
	2054	2019	0.001397	0.004628	0.00046	76	76	76	0	0	1	-360	360	-25.1829	1.5730	25.1905	-1.6009	0.0000	0.0000	0.0000	0.0000;
	2288	2287	0.026612	0.086612	0.00899	137	137	137	0	0	1	-360	360	-7.4121	-0.1976	7.4254	-0.7543	0.0000	0.0000	0.0000	0.0000;
	2300	2173	0.021984	0.073802	0.007359	90	90	90	0	0	1	-360	360	20.9703	-2.6726	-20.8856	2.1100	0.0000	0.0000	0.0000	0.0000;
	2399	2020	0.020149	0.048843	0.00476	90	90	90	0	0	1	-360	360	-14.8705	0.0019	14.9096	-0.4505	0.0000	0.0000	0.0000	0.0000;
	1938	2399	0.000397	0.000694	6.5e-05	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0074	0.0000	0.0000	0.0000	0.0000;
	2409	2399	0.012091	0.021141	0.002018	90	90	90	0	0	1	-360	360	-14.8470	-0.1940	14.8705	0.0056	0.0000	0.0000	0.0000	0.0000;
	2162	2409	0.001975	0.003455	0.000329	90	90	90	0	0	1	-360	360	-3.0370	-0.0530	3.0372	0.0159	0.0000	0.0000	0.0000	0.0000;
	1994	2409	0.069529	0.121603	0.011602	90	90	90	0	0	1	-360	360	-11.7240	-1.3345	11.8099	0.1781	0.0000	0.0000	0.0000	0.0000;
	2288	2036	0.031488	0.052149	0.00515	76	76	76	0	0	1	-360	360	2.3451	0.5076	-2.3434	-1.0732	0.0000	0.0000	0.0000	0.0000;
	2031	2019	0.010397	0.037041	0.002819	90	90	90	0	0	1	-360	360	-33.1670	-2.1626	33.2666	2.1915	0.0000	0.0000	0.0000	0.0000;
	2030	2031	0.003752	0.006562	0.000629	90	90	90	0	0	1	-360	360	-28.2578	-2.0792	28.2840	2.0526	0.0000	0.0000	0.0000	0.0000;
	2023	2030	0.007107	0.012438	0.001191	90	90	90	0	0	1	-360	360	-18.0952	-1.9960	18.1158	1.8952	0.0000	0.0000	0.0000	0.0000;
	2035	2020	0.004149	0.007256	0.00069	90	90	90	0	0	1	-360	360	6.0106	0.2056	-6.0093	-0.2823	0.0000	0.0000	0.0000	0.0000;
	2022	2035	0.006521	0.011397	0.001089	90	90	90	0	0	1	-360	360	8.8751	0.9657	-8.8706	-1.0826	0.0000	0.0000	0.0000	0.0000;
	2181	1990	0.019826	0.055041	0.005951	76	76	76	0	0	1	-360	360	-2.7474	8.0574	2.7611	-8.6879	0.0000	0.0000	0.0000	0.0000;
	2420	2334	0.010934	0.030479	0.003071	120	120	120	0	0	1	-360	360	-10.6679	8.4632	10.6864	-8.7548	0.0000	0.0000	0.0000	0.0000;
	1990	2420	0.003752	0.010248	0.001031	120	120	120	0	0	1	-360	360	-5.9615	8.5257	5.9652	-8.6311	0.0000	0.0000	0.0000	0.0000;
	2433	2420	0.003826	0.006686	0.000639	120	120	120	0	0	1	-360	360	-4.7020	-0.2380	4.7028	0.1679	0.0000	0.0000	0.0000	0.0000;
	2454	2258	0.011727	0.030521	0.00303	90	90	90	0	0	1	-360	360	-8.1328	12.6886	8.1572	-12.9626	0.0000	0.0000	0.0000	0.0000;
	2454	2182	0.040231	0.102769	0.01021	90	90	90	0	0	1	-360	360	7.9498	-12.7946	-7.8732	11.8408	0.0000	0.0000	0.0000	0.0000;
	2331	2182	0.028603	0.053223	0.00515	76	76	76	0	0	1	-360	360	-18.0021	0.3951	18.0846	-0.8239	0.0000	0.0000	0.0000	0.0000;
	1964	1996	9.1e-05	0.000686	7e-05	120	120	120	0	0	1	-360	360	-48.1117	-1.6305	48.1135	1.6364	0.0000	0.0000	0.0000	0.0000;
	2027	1964	0.005554	0.018182	0.001861	120	120	120	0	0	1	-360	360	-47.9990	-1.4737	48.1117	1.6305	0.0000	0.0000	0.0000	0.0000;
	2257	2013	0.025603	0.078397	0.008061	90	90	90	0	0	1	-360	360	9.5906	1.9344	-9.5680	-2.7572	0.0000	0.0000	0.0000	0.0000;
	2258	2034	0.006612	0.018256	0.001941	120	120	120	0	0	1	-360	360	29.5641	3.5865	-29.5113	-3.6556	0.0000	0.0000	0.0000	0.0000;
	2336	2013	0.009603	0.024744	0.00251	69	69	69	0	0	1	-360	360	-7.4729	-26.2326	7.5380	26.1255	0.0000	0.0000	0.0000	0.0000;
	2240	2336	0.001711	0.005157	0.00052	69	69	69	0	0	1	-360	360	-3.3198	-25.1776	3.3299	25.1516	0.0000	0.0000	0.0000	0.0000;
	2298	2013	0.006281	0.010578	0.001079	90	90	90	0	0	1	-360	360	-5.4000	-0.0880	5.4017	-0.0281	0.0000	0.0000	0.0000	0.0000;
	2435	2014	0.017769	0.03157	0.003011	90	90	90	0	0	1	-360	360	-16.1566	0.1572	16.1990	-0.4127	0.0000	0.0000	0.0000	0.0000;
	2182	2167	0.027058	0.091636	0.00907	90	90	90	0	0	1	-360	360	14.8524	-4.5910	-14.7958	3.7528	0.0000	0.0000	0.0000	0.0000;
	2200	2167	0.020777	0.038017	0.00364	90	90	90	0	0	1	-360	360	-12.0005	3.0421	12.0288	-3.4028	0.0000	0.0000	0.0000	0.0000;
	2200	2009	0.041521	0.074289	0.0071	90	90	90	0	0	1	-360	360	7.3895	-2.8121	-7.3673	2.0485	0.0000	0.0000	0.0000	0.0000;
	2282	2009	0.050174	0.087744	0.008371	90	90	90	0	0	1	-360	360	-5.5109	1.6065	5.5263	-2.5245	0.0000	0.0000	0.0000	0.0000;
	2331	1995	0.044628	0.094207	0.009629	76	76	76	0	0	1	-360	360	9.2431	-1.6591	-9.2088	0.6506	0.0000	0.0000	0.0000	0.0000;
	2389	2281	0.024793	0.080413	0.00832	137	137	137	0	0	1	-360	360	-8.2244	0.5231	8.2403	-1.3620	0.0000	0.0000	0.0000	0.0000;
	2281	2171	0.037686	0.065537	0.006241	90	90	90	0	0	1	-360	360	-11.3833	0.7760	11.4293	-1.3670	0.0000	0.0000	0.0000	0.0000;
	2171	2021	0.065372	0.114876	0.01096	90	90	90	0	0	1	-360	360	-11.7053	1.2330	11.7903	-2.2721	0.0000	0.0000	0.0000	0.0000;
	2239	2014	0.011438	0.030231	0.003059	69	69	69	0	0	1	-360	360	-10.5705	-26.4522	10.6553	26.3421	0.0000	0.0000	0.0000	0.0000;
	2027	1990	0.020579	0.067603	0.005689	137	137	137	0	0	1	-360	360	41.5470	0.2467	-41.2344	0.1384	0.0000	0.0000	0.0000	0.0000;
	2426	2249	0.01314	0.025537	0.002461	90	90	90	0	0	1	-360	360	-29.4835	0.2452	29.5868	-0.3173	0.0000	0.0000	0.0000	0.0000;
	2194	2337	0.019471	0.06595	0.006529	137	137	137	0	0	1	-360	360	-1.8420	-0.4960	1.8426	-0.2292	0.0000	0.0000	0.0000	0.0000;
	2359	1973	0.021818	0.071066	0.007369	137	137	137	0	0	1	-360	360	19.5620	-1.4479	-19.4885	0.8509	0.0000	0.0000	0.0000	0.0000;
	2351	2258	0.00486	0.016446	0.001631	120	120	120	0	0	1	-360	360	-27.6233	-4.7412	27.6578	4.6770	0.0000	0.0000	0.0000	0.0000;
	1945	2257	0.002281	0.007719	0.00076	137	137	137	0	0	1	-360	360	-21.8593	-4.9641	21.8696	4.9147	0.0000	0.0000	0.0000	0.0000;
	2282	2186	0.023058	0.057364	0.005871	120	120	120	0	0	1	-360	360	11.2538	-0.3793	-11.2279	-0.2171	0.0000	0.0000	0.0000	0.0000;
	2144	2014	0.003893	0.01319	0.001307	137	137	137	0	0	1	-360	360	12.0784	3.7651	-12.0728	-3.8900	0.0000	0.0000	0.0000	0.0000;
	1945	2144	0.010107	0.034248	0.00339	137	137	137	0	0	1	-360	360	13.0153	3.7101	-12.9984	-4.0281	0.0000	0.0000	0.0000	0.0000;
	2195	2013	0.007802	0.026413	0.002621	137	137	137	0	0	1	-360	360	5.8524	3.5191	-5.8490	-3.7969	0.0000	0.0000	0.0000	0.0000;
	2351	2195	0.003174	0.010727	0.00106	137	137	137	0	0	1	-360	360	11.2073	3.2502	-11.2034	-3.3541	0.0000	0.0000	0.0000	0.0000;
	2334	2257	0.00595	0.020157	0.001999	120	120	120	0	0	1	-360	360	9.3136	8.7548	-9.3048	-8.9474	0.0000	0.0000	0.0000	0.0000;
	2248	2034	0.012893	0.033719	0.00333	120	120	120	0	0	1	-360	360	-18.2150	-3.5771	18.2553	3.3156	0.0000	0.0000	0.0000	0.0000;
	2282	2091	0.033967	0.058099	0.00559	82	82	82	0	0	1	-360	360	12.2109	-2.6764	-12.1643	2.1270	0.0000	0.0000	0.0000	0.0000;
	2091	2012	0.069256	0.12157	0.011739	90	90	90	0	0	1	-360	360	7.5523	-2.0030	-7.5160	0.7531	0.0000	0.0000	0.0000	0.0000;
	2426	2021	0.039826	0.069669	0.00666	90	90	90	0	0	1	-360	360	22.1115	-1.9722	-21.9343	1.5511	0.0000	0.0000	0.0000	0.0000;
	2389	2327	0.007521	0.018347	0.00196	90	90	90	0	0	1	-360	360	4.4434	0.0139	-4.4420	-0.2200	0.0000	0.0000	0.0000	0.0000;
	2330	2328	0.007521	0.018347	0.00196	90	90	90	0	0	1	-360	360	4.5004	0.0337	-4.4990	-0.2500	0.0000	0.0000	0.0000	0.0000;
	2337	2012	0.018182	0.058843	0.00612	137	137	137	0	0	1	-360	360	-5.6966	0.4232	5.7020	-1.0881	0.0000	0.0000	0.0000	0.0000;
	2249	1990	0.009256	0.018603	0.00181	90	90	90	0	0	1	-360	360	-36.8558	0.3973	36.9688	-0.3722	0.0000	0.0000	0.0000	0.0000;
	2276	2181	0.069421	0.140496	0.01368	90	90	90	0	0	1	-360	360	1.9844	-1.1388	-1.9819	-0.3999	0.0000	0.0000	0.0000	0.0000;
	2330	2186	0.011066	0.027438	0.00281	120	120	120	0	0	1	-360	360	-7.4454	-0.7437	7.4509	0.4421	0.0000	0.0000	0.0000	0.0000;
	2359	1996	0.012893	0.041984	0.004361	137	137	137	0	0	1	-360	360	-21.4030	1.7589	21.4553	-2.0860	0.0000	0.0000	0.0000	0.0000;
	2297	2170	0.008017	0.021744	0.0022	90	90	90	0	0	1	-360	360	-4.4980	-0.0870	4.4995	-0.1509	0.0000	0.0000	0.0000	0.0000;
	2170	2014	0.00843	0.022984	0.002321	90	90	90	0	0	1	-360	360	-8.3715	-0.2991	8.3768	0.0582	0.0000	0.0000	0.0000	0.0000;
	2181	2157	0.022636	0.073554	0.007621	137	137	137	0	0	1	-360	360	2.7646	-0.7860	-2.7630	-0.0680	0.0000	0.0000	0.0000	0.0000;
	1973	1943	0.031802	0.079793	0.00779	137	137	137	0	0	1	-360	360	15.0625	-0.4689	-14.9988	-0.2492	0.0000	0.0000	0.0000	0.0000;
	2182	1975	0.050331	0.133876	0.01203	90	90	90	0	0	1	-360	360	4.5297	-3.3395	-4.5175	2.0047	0.0000	0.0000	0.0000	0.0000;
	2363	1975	0.028512	0.09843	0.008959	137	137	137	0	0	1	-360	360	-0.7370	0.6870	0.7375	-1.7057	0.0000	0.0000	0.0000	0.0000;
	2282	2181	0.034298	0.245446	0.024079	120	120	120	0	0	1	-360	360	-16.9507	1.4232	17.0404	-3.4968	0.0000	0.0000	0.0000	0.0000;
	2435	2248	0.008182	0.021488	0.00212	120	120	120	0	0	1	-360	360	-6.4054	-2.8352	6.4090	2.6121	0.0000	0.0000	0.0000	0.0000;
	2430	2148	0.04876	0.069421	0.01254	120	120	120	0	0	1	-360	360	20.9443	-3.6833	-20.7574	2.4960	0.0000	0.0000	0.0000	0.0000;
	2275	2431	0.019793	0.036289	0.00348	90	90	90	0	0	1	-360	360	-1.3810	-0.3480	1.3813	-0.0574	0.0000	0.0000	0.0000	0.0000;
	2400	2431	0.023636	0.059917	0.006181	120	120	120	0	0	1	-360	360	-10.9450	1.8231	10.9703	-2.4796	0.0000	0.0000	0.0000	0.0000;
	2400	2005	0.001818	0.004628	0.000469	120	120	120	0	0	1	-360	360	5.1614	0.5294	-5.1610	-0.5830	0.0000	0.0000	0.0000	0.0000;
	1952	2400	0.00405	0.013058	0.00136	120	120	120	0	0	1	-360	360	-5.7823	2.1985	5.7836	-2.3525	0.0000	0.0000	0.0000	0.0000;
	2431	2428	0.022314	0.07557	0.00748	137	137	137	0	0	1	-360	360	4.5219	-0.3339	-4.5180	-0.5250	0.0000	0.0000	0.0000	0.0000;
	2304	2430	0.028347	0.095041	0.00937	137	137	137	0	0	1	-360	360	9.8195	-8.7400	-9.7794	7.7857	0.0000	0.0000	0.0000	0.0000;
	2430	2201	0.030248	0.101653	0.010019	120	120	120	0	0	1	-360	360	23.1644	-0.8695	-23.0253	0.1743	0.0000	0.0000	0.0000	0.0000;
	2431	2310	0.027273	0.091653	0.00901	137	137	137	0	0	1	-360	360	0.0001	-1.0117	0.0000	-0.0400	0.0000	0.0000	0.0000	0.0000;
	2326	2447	0.015703	0.027273	0.00286	69	69	69	0	0	1	-360	360	15.2095	-0.3097	-15.1784	0.0310	0.0000	0.0000	0.0000	0.0000;
	2353	2233	0.012008	0.026711	0.002589	120	120	120	0	0	1	-360	360	9.9253	0.6783	-9.9150	-0.9545	0.0000	0.0000	0.0000	0.0000;
	2325	2353	0.011273	0.025479	0.002471	90	90	90	0	0	1	-360	360	17.1434	2.0838	-17.1144	-2.3045	0.0000	0.0000	0.0000	0.0000;
	2325	2305	0.008099	0.027422	0.00272	120	120	120	0	0	1	-360	360	6.6579	1.5232	-6.6546	-1.8277	0.0000	0.0000	0.0000	0.0000;
	2325	2319	0.029752	0.042066	0.004039	69	69	69	0	0	1	-360	360	14.2713	3.2025	-14.2161	-3.5913	0.0000	0.0000	0.0000	0.0000;
	2326	2271	0.049587	0.086777	0.009	69	69	69	0	0	1	-360	360	10.6278	1.8488	-10.5774	-2.8033	0.0000	0.0000	0.0000	0.0000;
	2271	2221	0.042066	0.070248	0.00733	69	69	69	0	0	1	-360	360	7.6314	2.3893	-7.6072	-3.1891	0.0000	0.0000	0.0000	0.0000;
	1952	2326	0.038983	0.103132	0.01043	120	120	120	0	0	1	-360	360	2.1702	-2.0676	-2.1680	0.8583	0.0000	0.0000	0.0000	0.0000;
	2294	2325	0.014669	0.040397	0.00628	120	120	120	0	0	1	-360	360	-6.5612	0.7285	6.5668	-1.4422	0.0000	0.0000	0.0000	0.0000;
	2319	2063	0.05124	0.081818	0.009489	90	90	90	0	0	1	-360	360	4.5301	1.7813	-4.5186	-2.8501	0.0000	0.0000	0.0000	0.0000;
	1955	1941	0.006612	0.019826	0.002299	137	137	137	0	0	1	-360	360	-19.3858	0.3229	19.4073	-0.5241	0.0000	0.0000	0.0000	0.0000;
	2325	2225	0.01405	0.027273	0.002781	90	90	90	0	0	1	-360	360	13.7522	0.2617	-13.7293	-0.5396	0.0000	0.0000	0.0000	0.0000;
	2225	1956	0.024793	0.042984	0.00423	90	90	90	0	0	1	-360	360	7.9253	0.1605	-7.9118	-0.6258	0.0000	0.0000	0.0000	0.0000;
	2166	1955	0.032231	0.055372	0.003071	90	90	90	0	0	1	-360	360	-1.5191	1.7621	1.5208	-2.1141	0.0000	0.0000	0.0000	0.0000;
	2326	1941	0.01762	0.041347	0.00402	90	90	90	0	0	1	-360	360	24.7479	-0.1728	-24.6553	-0.0769	0.0000	0.0000	0.0000	0.0000;
	1956	2233	0.011347	0.035091	0.003461	137	137	137	0	0	1	-360	360	-1.0729	-0.6302	1.0730	0.2315	0.0000	0.0000	0.0000	0.0000;
	2364	1956	0.009917	0.020661	0.00218	91	91	91	0	0	1	-360	360	-3.9810	-0.1326	3.9824	-0.1159	0.0000	0.0000	0.0000	0.0000;
	2067	1956	0.017529	0.059364	0.005881	137	137	137	0	0	1	-360	360	-0.7616	1.9315	0.7625	-2.6073	0.0000	0.0000	0.0000	0.0000;
	2364	2286	0.009917	0.023141	0.002611	91	91	91	0	0	1	-360	360	-1.3230	0.0266	1.3231	-0.3271	0.0000	0.0000	0.0000	0.0000;
	2286	2201	0.033802	0.080992	0.009271	91	91	91	0	0	1	-360	360	-3.3491	-0.1509	3.3525	-0.9104	0.0000	0.0000	0.0000	0.0000;
	2301	2028	0.028099	0.089256	0.00924	114	114	114	0	0	1	-360	360	0.0315	-1.1748	-0.0314	0.1140	0.0000	0.0000	0.0000	0.0000;
	2168	2028	0.01405	0.044628	0.0046	120	120	120	0	0	1	-360	360	5.0447	0.4440	-5.0416	-0.9630	0.0000	0.0000	0.0000	0.0000;
	2301	2201	0.018182	0.041322	0.004649	114	114	114	0	0	1	-360	360	-15.9445	-0.7155	15.9848	0.2720	0.0000	0.0000	0.0000	0.0000;
	2168	1955	0.01157	0.028099	0.00286	120	120	120	0	0	1	-360	360	-12.2327	-1.8130	12.2480	1.5204	0.0000	0.0000	0.0000	0.0000;
	2311	2301	0.007438	0.023141	0.002401	114	114	114	0	0	1	-360	360	-0.5530	-0.3220	0.5530	0.0465	0.0000	0.0000	0.0000	0.0000;
	2301	2075	0.024793	0.034711	0.004189	90	90	90	0	0	1	-360	360	12.5969	1.8877	-12.5617	-2.3176	0.0000	0.0000	0.0000	0.0000;
	2076	1967	0.037934	0.066124	0.006411	90	90	90	0	0	1	-360	360	-13.3885	1.4776	13.4493	-2.1051	0.0000	0.0000	0.0000	0.0000;
	2001	2076	0.038529	0.068058	0.0065	90	90	90	0	0	1	-360	360	-5.5363	0.4794	5.5470	-1.2007	0.0000	0.0000	0.0000	0.0000;
	2132	2001	0.025149	0.045496	0.004371	120	120	120	0	0	1	-360	360	-3.2300	-0.0111	3.2323	-0.4814	0.0000	0.0000	0.0000	0.0000;
	2148	1967	0.01405	0.044628	0.00484	120	120	120	0	0	1	-360	360	17.9954	-2.5160	-17.9553	2.0871	0.0000	0.0000	0.0000	0.0000;
	2051	2305	0.008256	0.016529	0.001941	120	120	120	0	0	1	-360	360	-2.5051	-1.0236	2.5056	0.7997	0.0000	0.0000	0.0000	0.0000;
	2004	2294	0.037636	0.097041	0.00984	120	120	120	0	0	1	-360	360	-4.7010	-0.5070	4.7082	-0.6145	0.0000	0.0000	0.0000	0.0000;
	2051	2447	0.01676	0.056777	0.005619	120	120	120	0	0	1	-360	360	-10.2790	0.5153	10.2944	-1.1150	0.0000	0.0000	0.0000	0.0000;
	2139	2431	0.013347	0.045198	0.00447	120	120	120	0	0	1	-360	360	-5.0710	-0.4042	5.0740	-0.1071	0.0000	0.0000	0.0000	0.0000;
	2439	2175	0.013173	0.044603	0.004419	137	137	137	0	0	1	-360	360	-12.9472	0.6427	12.9661	-1.0982	0.0000	0.0000	0.0000	0.0000;
	1983	1950	0.042827	0.097868	0.00953	90	90	90	0	0	1	-360	360	-0.4129	-0.1193	0.4131	-0.9988	0.0000	0.0000	0.0000	0.0000;
	2175	1951	0.054893	0.14743	0.01489	120	120	120	0	0	1	-360	360	6.9915	-1.5822	-6.9684	-0.1046	0.0000	0.0000	0.0000	0.0000;
	2176	1949	0.049016	0.127529	0.01292	120	120	120	0	0	1	-360	360	10.6334	-3.5942	-10.5829	2.2075	0.0000	0.0000	0.0000	0.0000;
	2349	2175	0.005141	0.035124	0.007899	229	229	229	0	0	1	-360	360	16.4344	-14.0678	-16.4144	13.2780	0.0000	0.0000	0.0000	0.0000;
	2349	2176	0.005141	0.035124	0.007899	232	232	232	0	0	1	-360	360	-0.4912	-10.6672	0.4958	9.7722	0.0000	0.0000	0.0000	0.0000;
	2175	2145	0.032231	0.077686	0.0044	137	137	137	0	0	1	-360	360	12.7566	-1.3183	-12.7117	0.9100	0.0000	0.0000	0.0000	0.0000;
	2176	1962	0.027273	0.068603	0.00666	120	120	120	0	0	1	-360	360	5.5121	-0.8798	-5.5050	0.1150	0.0000	0.0000	0.0000	0.0000;
	2345	2343	0.003314	0.009917	0.00099	137	137	137	0	0	1	-360	360	0.0000	0.2574	0.0000	-0.3730	0.0000	0.0000	0.0000	0.0000;
	2350	2342	0.004132	0.009091	0.000939	137	137	137	0	0	1	-360	360	14.7568	5.4977	-14.7480	-5.5880	0.0000	0.0000	0.0000	0.0000;
	2349	2345	0.004132	0.009917	0.00099	137	137	137	0	0	1	-360	360	9.4332	0.6098	-9.4301	-0.7179	0.0000	0.0000	0.0000	0.0000;
	2349	2346	0.004132	0.010744	0.00099	137	137	137	0	0	1	-360	360	7.4162	-0.6079	-7.4142	0.4973	0.0000	0.0000	0.0000	0.0000;
	2346	2344	0.004132	0.01157	0.001041	137	137	137	0	0	1	-360	360	0.2760	-0.6516	-0.2760	0.5300	0.0000	0.0000	0.0000	0.0000;
	2111	1951	0.010744	0.034711	0.00356	114	114	114	0	0	1	-360	360	-8.9364	-1.8626	8.9440	1.4706	0.0000	0.0000	0.0000	0.0000;
	2370	1949	0.009446	0.028463	0.0028	90	90	90	0	0	1	-360	360	5.8000	1.6990	-5.7970	-2.0188	0.0000	0.0000	0.0000	0.0000;
	2369	1951	0.004512	0.015289	0.00151	137	137	137	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.1769	0.0000	0.0000	0.0000	0.0000;
	1951	1950	0.006504	0.022017	0.00218	120	120	120	0	0	1	-360	360	-8.4265	-1.6771	8.4306	1.4353	0.0000	0.0000	0.0000	0.0000;
	2252	1983	0.01319	0.044669	0.004419	137	137	137	0	0	1	-360	360	2.3497	-1.0277	-2.3491	0.5113	0.0000	0.0000	0.0000	0.0000;
	2439	2252	0.012603	0.042653	0.004221	137	137	137	0	0	1	-360	360	5.5772	-1.1487	-5.5737	0.6647	0.0000	0.0000	0.0000	0.0000;
	2165	2145	0.02562	0.078512	0.008419	137	137	137	0	0	1	-360	360	-4.7887	-0.2132	4.7937	-0.7560	0.0000	0.0000	0.0000	0.0000;
	2279	2165	0.012397	0.041322	0.004189	120	120	120	0	0	1	-360	360	-1.1005	-0.8740	1.1007	0.3852	0.0000	0.0000	0.0000	0.0000;
	1963	1979	0.036686	0.091653	0.009399	120	120	120	0	0	1	-360	360	-3.2260	-0.3420	3.2293	-0.7454	0.0000	0.0000	0.0000	0.0000;
	2366	2065	0.006612	0.015703	0.00165	120	120	120	0	0	1	-360	360	2.7664	-0.1124	-2.7660	-0.0790	0.0000	0.0000	0.0000	0.0000;
	2064	1979	0.005917	0.01857	0.001989	90	90	90	0	0	1	-360	360	-17.7861	-0.1795	17.8022	-0.0019	0.0000	0.0000	0.0000	0.0000;
	2366	1979	0.00157	0.005124	0.00053	120	120	120	0	0	1	-360	360	-8.6874	0.1014	8.6885	-0.1600	0.0000	0.0000	0.0000	0.0000;
	2367	1979	0.001529	0.004934	0.000501	120	120	120	0	0	1	-360	360	1.3790	0.2250	-1.3790	-0.2834	0.0000	0.0000	0.0000	0.0000;
	2064	2056	0.005793	0.013223	0.001379	90	90	90	0	0	1	-360	360	15.9451	0.6505	-15.9324	-0.7820	0.0000	0.0000	0.0000	0.0000;
	2100	1979	0.02719	0.049174	0.004779	90	90	90	0	0	1	-360	360	-14.0290	-0.7848	14.0752	0.3128	0.0000	0.0000	0.0000	0.0000;
	2222	1979	0.012901	0.022744	0.0022	90	90	90	0	0	1	-360	360	-7.9154	-0.1834	7.9223	-0.0608	0.0000	0.0000	0.0000	0.0000;
	2223	1979	0.012041	0.024719	0.002439	90	90	90	0	0	1	-360	360	-4.6810	-1.2750	4.6834	0.9955	0.0000	0.0000	0.0000	0.0000;
	2174	2056	0.028934	0.05124	0.00469	90	90	90	0	0	1	-360	360	-5.7828	-1.2640	5.7914	0.7350	0.0000	0.0000	0.0000	0.0000;
	2174	2166	0.015703	0.027273	0.002519	90	90	90	0	0	1	-360	360	4.4018	1.2300	-4.3989	-1.5165	0.0000	0.0000	0.0000	0.0000;
	2100	2067	0.018934	0.059504	0.006561	120	120	120	0	0	1	-360	360	4.7920	0.6298	-4.7880	-1.3765	0.0000	0.0000	0.0000	0.0000;
	2166	2067	0.01405	0.023141	0.002321	90	90	90	0	0	1	-360	360	1.7710	-0.1057	-1.7706	-0.1619	0.0000	0.0000	0.0000	0.0000;
	2146	2067	0.009	0.030479	0.00302	69	69	69	0	0	1	-360	360	-1.8430	-0.0860	1.8433	-0.2620	0.0000	0.0000	0.0000	0.0000;
	2347	2345	0.009091	0.031397	0.003269	137	137	137	0	0	1	-360	360	-5.2849	-0.5647	5.2871	0.1905	0.0000	0.0000	0.0000	0.0000;
	2348	2346	0.012397	0.040496	0.00416	137	137	137	0	0	1	-360	360	-4.3761	-0.8763	4.3782	0.3973	0.0000	0.0000	0.0000	0.0000;
	2299	2222	0.006364	0.021554	0.00213	91	91	91	0	0	1	-360	360	-2.7350	-0.0740	2.7354	-0.1726	0.0000	0.0000	0.0000	0.0000;
	2088	2256	0.010281	0.01795	0.001711	114	114	114	0	0	1	-360	360	-5.8980	-1.4150	5.9014	1.2343	0.0000	0.0000	0.0000	0.0000;
	2084	2255	0.013339	0.033901	0.003429	114	114	114	0	0	1	-360	360	-6.7390	-1.3810	6.7447	1.0203	0.0000	0.0000	0.0000	0.0000;
	2414	2256	0.012488	0.03219	0.00326	114	114	114	0	0	1	-360	360	-25.5763	-3.1755	25.6528	3.0179	0.0000	0.0000	0.0000	0.0000;
	2085	2414	0.000603	0.001033	9.9e-05	114	114	114	0	0	1	-360	360	-11.0450	-2.5490	11.0457	2.5395	0.0000	0.0000	0.0000	0.0000;
	2407	2414	0.004347	0.007603	0.000731	114	114	114	0	0	1	-360	360	-14.5221	-0.7003	14.5306	0.6360	0.0000	0.0000	0.0000	0.0000;
	2135	2407	0.000397	0.000686	7e-05	114	114	114	0	0	1	-360	360	-1.4980	-0.2130	1.4980	0.2054	0.0000	0.0000	0.0000	0.0000;
	2416	2407	0.002207	0.007463	0.00074	114	114	114	0	0	1	-360	360	-13.0207	-0.5633	13.0241	0.4949	0.0000	0.0000	0.0000	0.0000;
	2317	2416	0.008504	0.014851	0.001421	114	114	114	0	0	1	-360	360	-7.1000	-0.7320	7.1040	0.5855	0.0000	0.0000	0.0000	0.0000;
	2267	2416	0.008198	0.027769	0.002749	114	114	114	0	0	1	-360	360	-5.9140	-0.2660	5.9167	-0.0222	0.0000	0.0000	0.0000	0.0000;
	2101	2255	0.00257	0.004488	0.000431	114	114	114	0	0	1	-360	360	-23.5900	-9.7000	23.6053	9.6795	0.0000	0.0000	0.0000	0.0000;
	2083	2089	0.004554	0.012628	0.00127	114	114	114	0	0	1	-360	360	-22.3670	-9.0210	22.3918	8.9544	0.0000	0.0000	0.0000	0.0000;
	2102	2255	0.00257	0.004488	0.000431	114	114	114	0	0	1	-360	360	-10.2960	-3.3990	10.2988	3.3566	0.0000	0.0000	0.0000	0.0000;
	2114	2119	0.01176	0.021074	0.002016	90	90	90	0	0	1	-360	360	27.4700	-5.8985	-27.3856	5.8290	0.0000	0.0000	0.0000	0.0000;
	2103	2256	0.00257	0.004488	0.000431	114	114	114	0	0	1	-360	360	-1.0300	-0.2660	1.0300	0.2190	0.0000	0.0000	0.0000	0.0000;
	2446	2118	0.018033	0.061091	0.006048	90	90	90	0	0	1	-360	360	4.2204	6.7642	-4.2093	-7.3942	0.0000	0.0000	0.0000	0.0000;
	2246	2255	0.001537	0.005207	0.00052	137	137	137	0	0	1	-360	360	-35.5649	11.2283	35.5844	-11.2192	0.0000	0.0000	0.0000	0.0000;
	2256	2113	0.002479	0.006612	0.00068	137	137	137	0	0	1	-360	360	27.1608	6.6112	-27.1430	-6.6380	0.0000	0.0000	0.0000	0.0000;
	2255	2112	0.002479	0.006612	0.00068	137	137	137	0	0	1	-360	360	0.2470	30.5922	-0.2258	-30.6099	0.0000	0.0000	0.0000	0.0000;
	2246	2124	0.006967	0.023603	0.00234	137	137	137	0	0	1	-360	360	28.4799	-12.2373	-28.4190	12.1870	0.0000	0.0000	0.0000	0.0000;
	2256	2120	0.002769	0.009372	0.000929	120	120	120	0	0	1	-360	360	10.2067	1.5537	-10.2040	-1.6460	0.0000	0.0000	0.0000	0.0000;
	2119	2255	0.002769	0.009372	0.000929	120	120	120	0	0	1	-360	360	16.1426	-14.7530	-16.1305	14.6921	0.0000	0.0000	0.0000	0.0000;
	2243	2256	0.000124	0.000397	4.1e-05	137	137	137	0	0	1	-360	360	-3.3170	-0.4570	3.3170	0.4526	0.0000	0.0000	0.0000	0.0000;
	2244	2255	9.9e-05	0.000314	2.9e-05	137	137	137	0	0	1	-360	360	-2.1520	-0.0000	2.1520	-0.0032	0.0000	0.0000	0.0000	0.0000;
	2256	2115	0.005793	0.018182	0.001861	120	120	120	0	0	1	-360	360	9.2269	2.4722	-9.2220	-2.6600	0.0000	0.0000	0.0000	0.0000;
	2408	1982	0.020702	0.070124	0.006941	137	137	137	0	0	1	-360	360	-44.7082	5.0652	45.0746	-4.6242	0.0000	0.0000	0.0000	0.0000;
	2154	2408	0.003488	0.011802	0.001169	137	137	137	0	0	1	-360	360	-33.7902	5.5027	33.8259	-5.5158	0.0000	0.0000	0.0000	0.0000;
	2152	2408	0.006149	0.020827	0.002059	137	137	137	0	0	1	-360	360	-10.8760	-0.6650	10.8824	0.4506	0.0000	0.0000	0.0000	0.0000;
	2372	2292	0.024793	0.076859	0.008349	120	120	120	0	0	1	-360	360	27.1875	-4.4737	-27.0263	4.0068	0.0000	0.0000	0.0000	0.0000;
	2293	2037	0.028934	0.08843	0.009731	120	120	120	0	0	1	-360	360	44.9603	-4.9508	-44.4488	5.3989	0.0000	0.0000	0.0000	0.0000;
	2109	2086	0.00676	0.022909	0.00227	120	120	120	0	0	1	-360	360	-106.0549	3.9374	106.7441	-1.8543	0.0000	0.0000	0.0000	0.0000;
	2117	2109	0.003686	0.012504	0.001239	137	137	137	0	0	1	-360	360	-104.4001	5.7434	104.7669	-4.6354	0.0000	0.0000	0.0000	0.0000;
	2117	2112	0.004959	0.016529	0.001769	137	137	137	0	0	1	-360	360	67.3601	1.3774	-67.1552	-0.8881	0.0000	0.0000	0.0000	0.0000;
	2406	2256	0.000612	0.002083	0.00021	120	120	120	0	0	1	-360	360	-30.3528	-11.3980	30.3587	11.3951	0.0000	0.0000	0.0000	0.0000;
	2104	2406	0.001017	0.003471	0.000339	120	120	120	0	0	1	-360	360	-8.4230	-2.4430	8.4237	2.4085	0.0000	0.0000	0.0000	0.0000;
	2106	2406	0.004314	0.013876	0.001159	120	120	120	0	0	1	-360	360	-21.9068	-9.0442	21.9291	8.9895	0.0000	0.0000	0.0000	0.0000;
	2127	2255	0.009421	0.031934	0.003161	120	120	120	0	0	1	-360	360	-4.7740	-0.8500	4.7760	0.5107	0.0000	0.0000	0.0000	0.0000;
	2126	2107	0.006446	0.021868	0.002161	120	120	120	0	0	1	-360	360	9.3866	2.5625	-9.3810	-2.7785	0.0000	0.0000	0.0000	0.0000;
	2110	1977	0.024388	0.063587	0.01204	137	137	137	0	0	1	-360	360	4.6869	1.4571	-4.6814	-2.8463	0.0000	0.0000	0.0000	0.0000;
	2450	2221	0.019016	0.041529	0.008639	90	90	90	0	0	1	-360	360	-9.9210	-1.0620	9.9375	0.1142	0.0000	0.0000	0.0000	0.0000;
	2279	2110	0.005793	0.018934	0.001909	76	76	76	0	0	1	-360	360	-4.2485	-0.6250	4.2494	0.4049	0.0000	0.0000	0.0000	0.0000;
	2221	2155	0.015703	0.02562	0.00227	120	120	120	0	0	1	-360	360	-15.6480	5.9254	15.6868	-6.1214	0.0000	0.0000	0.0000	0.0000;
	2155	2154	0.008256	0.012397	0.00128	120	120	120	0	0	1	-360	360	-24.3478	5.8704	24.3932	-5.9487	0.0000	0.0000	0.0000	0.0000;
	2449	2220	0.022091	0.057744	0.005651	76	76	76	0	0	1	-360	360	-7.8460	-0.8960	7.8580	0.2838	0.0000	0.0000	0.0000	0.0000;
	2044	2220	0.004347	0.007603	0.000721	69	69	69	0	0	1	-360	360	0.3700	-0.1860	-0.3700	0.1037	0.0000	0.0000	0.0000	0.0000;
	2045	2221	0.004347	0.007603	0.000721	69	69	69	0	0	1	-360	360	-2.8080	-0.1590	2.8083	0.0772	0.0000	0.0000	0.0000	0.0000;
	2220	2063	0.046281	0.076859	0.00755	76	76	76	0	0	1	-360	360	2.9940	-2.6286	-2.9884	1.7761	0.0000	0.0000	0.0000	0.0000;
	2041	2452	0.002446	0.008331	0.00083	114	114	114	0	0	1	-360	360	-4.6810	0.6380	4.6815	-0.7278	0.0000	0.0000	0.0000	0.0000;
	2040	2451	0.002446	0.008331	0.00083	114	114	114	0	0	1	-360	360	13.8070	3.4710	-13.8026	-3.5486	0.0000	0.0000	0.0000	0.0000;
	2451	1960	0.006612	0.009091	0.001159	120	120	120	0	0	1	-360	360	14.8185	7.2608	-14.8023	-7.3678	0.0000	0.0000	0.0000	0.0000;
	2446	1960	0.007438	0.023967	0.002439	120	120	120	0	0	1	-360	360	-8.3424	-7.1272	8.3503	6.8818	0.0000	0.0000	0.0000	0.0000;
	2451	2043	0.004959	0.014876	0.00167	120	120	120	0	0	1	-360	360	29.4266	0.0853	-29.3881	-0.1562	0.0000	0.0000	0.0000	0.0000;
	2452	2042	0.004959	0.014876	0.00167	120	120	120	0	0	1	-360	360	45.9377	17.4360	-45.8290	-17.2930	0.0000	0.0000	0.0000	0.0000;
	2452	2125	0.013223	0.042066	0.0046	120	120	120	0	0	1	-360	360	-24.8144	13.3225	24.9103	-13.5232	0.0000	0.0000	0.0000	0.0000;
	2452	2121	0.009091	0.027273	0.002899	120	120	120	0	0	1	-360	360	20.2432	5.1806	-20.2070	-5.3908	0.0000	0.0000	0.0000	0.0000;
	2126	2121	0.009917	0.030579	0.003291	120	120	120	0	0	1	-360	360	-18.2416	-4.9705	18.2740	4.7108	0.0000	0.0000	0.0000	0.0000;
	2451	2247	0.024793	0.080083	0.008301	114	114	114	0	0	1	-360	360	28.8002	-5.2723	-28.6109	4.9593	0.0000	0.0000	0.0000	0.0000;
	1958	2452	0.014992	0.031537	0.0031	90	90	90	0	0	1	-360	360	-7.4670	-0.7410	7.4746	0.4158	0.0000	0.0000	0.0000	0.0000;
	2451	2038	0.042984	0.102479	0.0105	90	90	90	0	0	1	-360	360	-39.1601	6.4881	39.7696	-6.2186	0.0000	0.0000	0.0000	0.0000;
	2114	2118	0.002868	0.009719	0.000963	114	114	114	0	0	1	-360	360	-31.6220	4.0915	31.6486	-4.1073	0.0000	0.0000	0.0000	0.0000;
	2220	1981	0.03719	0.119008	0.012199	114	114	114	0	0	1	-360	360	-1.3279	-6.3589	1.3390	4.9933	0.0000	0.0000	0.0000	0.0000;
	1977	1982	0.064628	0.109917	0.01059	137	137	137	0	0	1	-360	360	-0.9416	2.2953	0.9468	-3.5158	0.0000	0.0000	0.0000	0.0000;
	1981	1974	0.033223	0.056612	0.00545	120	120	120	0	0	1	-360	360	4.2465	-0.1632	-4.2413	-0.4569	0.0000	0.0000	0.0000	0.0000;
	1982	2134	0.017826	0.060207	0.00596	120	120	120	0	0	1	-360	360	7.2976	2.7170	-7.2880	-3.3730	0.0000	0.0000	0.0000	0.0000;
	2266	1981	0.007587	0.025686	0.002541	120	120	120	0	0	1	-360	360	-8.6620	-1.0700	8.6670	0.7935	0.0000	0.0000	0.0000	0.0000;
	2419	2116	0.012091	0.040959	0.004061	120	120	120	0	0	1	-360	360	2.7608	0.0645	-2.7600	-0.5310	0.0000	0.0000	0.0000	0.0000;
	1982	2419	0.006868	0.023256	0.002299	120	120	120	0	0	1	-360	360	15.6994	-0.0314	-15.6848	-0.1852	0.0000	0.0000	0.0000	0.0000;
	2318	2419	0.005529	0.009669	0.00092	120	120	120	0	0	1	-360	360	-12.9160	-0.2130	12.9240	0.1207	0.0000	0.0000	0.0000	0.0000;
	2086	1981	0.015703	0.049587	0.005111	120	120	120	0	0	1	-360	360	-111.9931	0.3933	113.7547	4.5888	0.0000	0.0000	0.0000	0.0000;
	2293	1981	0.004132	0.031397	0.003001	137	137	137	0	0	1	-360	360	-20.6045	0.6986	20.6197	-0.9295	0.0000	0.0000	0.0000	0.0000;
	2285	1981	0.065826	0.222983	0.02208	137	137	137	0	0	1	-360	360	12.1278	-2.6841	-12.0435	0.4080	0.0000	0.0000	0.0000	0.0000;
	2268	1982	0.020661	0.066124	0.006781	120	120	120	0	0	1	-360	360	0.8812	-0.9083	-0.8810	0.1236	0.0000	0.0000	0.0000	0.0000;
	2089	2106	0.016421	0.055628	0.00551	137	137	137	0	0	1	-360	360	-24.4518	-9.4854	24.5567	9.2470	0.0000	0.0000	0.0000	0.0000;
	2026	1974	0.012141	0.041124	0.00407	137	137	137	0	0	1	-360	360	-1.5670	-0.5270	1.5673	0.0589	0.0000	0.0000	0.0000	0.0000;
	2080	2425	0.03124	0.102314	0.010481	137	137	137	0	0	1	-360	360	-1.1861	-0.5794	1.1865	-0.5739	0.0000	0.0000	0.0000	0.0000;
	2002	1986	0.044207	0.113669	0.01112	91	91	91	0	0	1	-360	360	12.3945	-1.9448	-12.3331	0.8615	0.0000	0.0000	0.0000	0.0000;
	2092	2002	0.010331	0.018017	0.001721	90	90	90	0	0	1	-360	360	24.1585	-3.5312	-24.1037	3.4336	0.0000	0.0000	0.0000	0.0000;
	2437	2164	0.012562	0.021901	0.00212	90	90	90	0	0	1	-360	360	10.4919	-0.0924	-10.4799	-0.1307	0.0000	0.0000	0.0000	0.0000;
	2438	2436	0.010083	0.017364	0.001721	90	90	90	0	0	1	-360	360	15.5964	2.2071	-15.5747	-2.3683	0.0000	0.0000	0.0000	0.0000;
	2245	2159	0.02	0.037438	0.003649	90	90	90	0	0	1	-360	360	7.0821	5.6423	-7.0674	-6.0328	0.0000	0.0000	0.0000	0.0000;
	2436	2245	0.007934	0.015372	0.0015	90	90	90	0	0	1	-360	360	11.0567	4.0953	-11.0471	-4.2493	0.0000	0.0000	0.0000	0.0000;
	2438	2437	0.010826	0.018934	0.00181	90	90	90	0	0	1	-360	360	19.7476	-1.4461	-19.7109	1.3014	0.0000	0.0000	0.0000	0.0000;
	2164	2158	0.028182	0.058182	0.0059	90	90	90	0	0	1	-360	360	4.4889	1.7267	-4.4829	-2.3911	0.0000	0.0000	0.0000	0.0000;
	2033	2002	0.057016	0.113314	0.010909	90	90	90	0	0	1	-360	360	-6.5271	1.0281	6.5503	-2.2018	0.0000	0.0000	0.0000	0.0000;
	2289	2158	0.039339	0.129174	0.013201	137	137	137	0	0	1	-360	360	-25.1343	6.1460	25.3684	-6.8863	0.0000	0.0000	0.0000	0.0000;
	2290	2289	0.00595	0.019174	0.00198	137	137	137	0	0	1	-360	360	-19.3928	4.0061	19.4133	-4.1660	0.0000	0.0000	0.0000	0.0000;
	2158	2092	0.036198	0.063388	0.00612	90	90	90	0	0	1	-360	360	33.6410	-2.6057	-33.2815	2.5412	0.0000	0.0000	0.0000	0.0000;
	2290	2432	0.02743	0.088851	0.00915	137	137	137	0	0	1	-360	360	15.2438	-3.0681	-15.1864	2.2120	0.0000	0.0000	0.0000	0.0000;
	2388	2303	0.040331	0.136612	0.01353	137	137	137	0	0	1	-360	360	-9.0384	-2.6357	9.0693	1.2244	0.0000	0.0000	0.0000	0.0000;
	2427	2053	0.01157	0.039421	0.003901	137	137	137	0	0	1	-360	360	-9.7212	1.8115	9.7315	-2.2049	0.0000	0.0000	0.0000	0.0000;
	2033	1939	0.035066	0.118777	0.011761	137	137	137	0	0	1	-360	360	2.7461	-0.1021	-2.7437	-1.2004	0.0000	0.0000	0.0000	0.0000;
	2159	1939	0.041066	0.139091	0.01377	137	137	137	0	0	1	-360	360	30.1291	1.3014	-29.8011	-1.7426	0.0000	0.0000	0.0000	0.0000;
	2196	1966	0.029496	0.050174	0.00484	90	90	90	0	0	1	-360	360	-13.2961	6.4719	13.3558	-6.9029	0.0000	0.0000	0.0000	0.0000;
	2425	2053	0.011322	0.037438	0.0037	137	137	137	0	0	1	-360	360	17.4220	-1.9120	-17.3905	1.6089	0.0000	0.0000	0.0000	0.0000;
	2424	2159	0.014207	0.046612	0.00477	137	137	137	0	0	1	-360	360	-23.3310	-0.6695	23.3992	0.3503	0.0000	0.0000	0.0000	0.0000;
	2424	2303	0.017769	0.058182	0.005951	137	137	137	0	0	1	-360	360	20.9340	0.3285	-20.8653	-0.7764	0.0000	0.0000	0.0000	0.0000;
	2198	2080	0.022686	0.062207	0.00629	90	90	90	0	0	1	-360	360	2.2269	-2.5151	-2.2249	1.8284	0.0000	0.0000	0.0000	0.0000;
	2159	1961	0.020992	0.069339	0.006989	137	137	137	0	0	1	-360	360	6.2934	-5.1415	-6.2819	4.3799	0.0000	0.0000	0.0000	0.0000;
	1991	1961	0.017107	0.05562	0.004799	137	137	137	0	0	1	-360	360	-5.6297	3.8239	5.6369	-4.3509	0.0000	0.0000	0.0000	0.0000;
	2425	2335	0.024959	0.084463	0.00847	137	137	137	0	0	1	-360	360	-22.9425	3.4019	23.0651	-3.9226	0.0000	0.0000	0.0000	0.0000;
	2388	2306	0.031744	0.107504	0.010641	137	137	137	0	0	1	-360	360	-0.7376	1.9157	0.7395	-3.0918	0.0000	0.0000	0.0000	0.0000;
	2193	2158	0.02595	0.085124	0.008741	137	137	137	0	0	1	-360	360	-2.9520	0.1810	2.9541	-1.1745	0.0000	0.0000	0.0000	0.0000;
	2198	2196	0.00943	0.018893	0.001849	90	90	90	0	0	1	-360	360	-9.0469	4.9561	9.0561	-5.1409	0.0000	0.0000	0.0000	0.0000;
	2427	1939	0.017686	0.057438	0.00596	137	137	137	0	0	1	-360	360	-27.9014	-3.8676	28.0287	3.6220	0.0000	0.0000	0.0000	0.0000;
	1959	2427	0.052339	0.091554	0.008729	69	69	69	0	0	1	-360	360	-1.1090	0.9560	1.1106	-1.9129	0.0000	0.0000	0.0000	0.0000;
	2673	2728	0.03562	0.109421	0.011461	69	69	69	0	0	1	-360	360	1.4228	-0.7690	-1.4221	-0.5430	0.0000	0.0000	0.0000	0.0000;
	2578	2708	0.036777	0.093967	0.009511	120	120	120	0	0	1	-360	360	-35.3685	5.6495	35.7927	-5.6359	0.0000	0.0000	0.0000	0.0000;
	2684	2638	0.002066	0.007273	0.000699	126	126	126	0	0	1	-360	360	10.9386	0.8832	-10.9365	-0.9559	0.0000	0.0000	0.0000	0.0000;
	2638	2483	0.018512	0.059504	0.00627	126	126	126	0	0	1	-360	360	5.3085	-0.5441	-5.3039	-0.1606	0.0000	0.0000	0.0000	0.0000;
	2570	2465	0.021	0.067901	0.00696	123	123	123	0	0	1	-360	360	0.6859	3.4498	-0.6831	-4.2340	0.0000	0.0000	0.0000	0.0000;
	2663	2667	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	-0.4053	1.3444	0.4061	-2.0697	0.0000	0.0000	0.0000	0.0000;
	2461	2729	0.066446	0.17719	0.01791	70	70	70	0	0	1	-360	360	-7.8080	1.1232	7.8436	-3.2341	0.0000	0.0000	0.0000	0.0000;
	2658	2730	0.076612	0.131818	0.013	78	78	78	0	0	1	-360	360	-40.2866	-16.7894	41.5677	17.4612	0.0000	0.0000	0.0000	0.0000;
	2481	2517	0.033802	0.107438	0.011541	69	69	69	0	0	1	-360	360	-27.2256	1.1603	27.4528	-1.7256	0.0000	0.0000	0.0000	0.0000;
	2585	2624	0.020496	0.06876	0.00688	137	137	137	0	0	1	-360	360	15.3911	-2.2351	-15.3465	1.6254	0.0000	0.0000	0.0000	0.0000;
	2562	2527	0.04	0.129587	0.013291	114	114	114	0	0	1	-360	360	-49.6990	-8.3137	50.6266	9.8278	0.0000	0.0000	0.0000	0.0000;
	2532	2620	0.009917	0.033223	0.004189	107	107	107	0	0	1	-360	360	-23.4288	-4.8402	23.4800	4.5480	0.0000	0.0000	0.0000	0.0000;
	2562	2528	0.040248	0.130248	0.013361	107	107	107	0	0	1	-360	360	-49.6476	-8.4672	50.5799	9.9849	0.0000	0.0000	0.0000	0.0000;
	2622	2556	0.035446	0.087364	0.008821	114	114	114	0	0	1	-360	360	28.5877	1.6475	-28.3389	-2.0565	0.0000	0.0000	0.0000	0.0000;
	2731	2730	0.012636	0.038017	0.00273	114	114	114	0	0	1	-360	360	-20.5260	0.3791	20.5693	-0.5844	0.0000	0.0000	0.0000	0.0000;
	2531	2731	0.033058	0.082636	0.00968	69	69	69	0	0	1	-360	360	-18.7335	-0.0652	18.8290	-0.8791	0.0000	0.0000	0.0000	0.0000;
	2593	2532	0.046686	0.081818	0.007739	90	90	90	0	0	1	-360	360	8.1569	-5.8045	-8.1165	5.0218	0.0000	0.0000	0.0000	0.0000;
	2486	2477	0.034132	0.059917	0.00566	48	48	48	0	0	1	-360	360	-37.4350	12.7460	37.9223	-12.5168	0.0000	0.0000	0.0000	0.0000;
	2499	2594	0.035868	0.058678	0.006459	90	90	90	0	0	1	-360	360	8.6173	-6.4148	-8.5814	5.7580	0.0000	0.0000	0.0000	0.0000;
	2499	2506	0.1	0.159496	0.01597	86	86	86	0	0	1	-360	360	-0.1163	-7.6650	0.1579	5.9451	0.0000	0.0000	0.0000	0.0000;
	2704	2608	0.039504	0.128099	0.013141	137	137	137	0	0	1	-360	360	-2.5259	1.6399	2.5301	-3.1179	0.0000	0.0000	0.0000	0.0000;
	2594	2476	0.03124	0.056033	0.005629	84	84	84	0	0	1	-360	360	-2.3269	-5.1117	2.3349	4.5002	0.0000	0.0000	0.0000	0.0000;
	2715	2496	0.021397	0.068868	0.007081	69	69	69	0	0	1	-360	360	-1.5338	-2.3418	1.5348	1.4764	0.0000	0.0000	0.0000	0.0000;
	2699	2715	0.016859	0.054273	0.005581	69	69	69	0	0	1	-360	360	0.6890	-2.5313	-0.6883	1.8504	0.0000	0.0000	0.0000	0.0000;
	2621	2715	0.000256	0.000661	7e-05	69	69	69	0	0	1	-360	360	-2.2220	-0.5000	2.2220	0.4914	0.0000	0.0000	0.0000	0.0000;
	2485	2484	0.012231	0.038603	0.004201	30	30	30	0	0	1	-360	360	5.0670	0.5529	-5.0640	-1.0000	0.0000	0.0000	0.0000	0.0000;
	2611	2492	0.028827	0.093223	0.009564	69	69	69	0	0	1	-360	360	-22.4712	3.1506	22.6049	-3.7900	0.0000	0.0000	0.0000	0.0000;
	2658	2489	0.01824	0.058992	0.00605	123	123	123	0	0	1	-360	360	-21.1568	14.2835	21.2640	-14.6143	0.0000	0.0000	0.0000	0.0000;
	2532	2683	0.024554	0.079917	0.00823	137	137	137	0	0	1	-360	360	12.3858	-0.4108	-12.3517	-0.3839	0.0000	0.0000	0.0000	0.0000;
	2477	2697	0.06843	0.09157	0.0084	69	69	69	0	0	1	-360	360	-15.1557	6.1958	15.3245	-6.9075	0.0000	0.0000	0.0000	0.0000;
	2697	2728	0.086529	0.11405	0.010191	57	57	57	0	0	1	-360	360	-22.0755	5.4075	22.4794	-6.0299	0.0000	0.0000	0.0000	0.0000;
	2579	2558	0.007851	0.019826	0.00203	120	120	120	0	0	1	-360	360	-14.7860	0.2651	14.8011	-0.4591	0.0000	0.0000	0.0000	0.0000;
	2618	2640	0.010331	0.026529	0.002691	109	109	109	0	0	1	-360	360	24.7874	4.3064	-24.7305	-4.4699	0.0000	0.0000	0.0000	0.0000;
	2596	2618	0.022314	0.057016	0.00576	120	120	120	0	0	1	-360	360	-4.5010	-0.6000	4.5049	-0.0536	0.0000	0.0000	0.0000	0.0000;
	2595	2656	0.030992	0.079008	0.00801	120	120	120	0	0	1	-360	360	-2.8130	-0.6000	2.8151	-0.3522	0.0000	0.0000	0.0000	0.0000;
	2458	2561	0.002636	0.007521	0.00075	120	120	120	0	0	1	-360	360	46.7678	-6.1782	-46.7189	6.2278	0.0000	0.0000	0.0000	0.0000;
	2553	2535	0.030248	0.06281	0.00061	99	99	99	0	0	1	-360	360	-40.7096	2.7701	41.1384	-1.9520	0.0000	0.0000	0.0000	0.0000;
	2534	2466	0.003314	0.010826	0.001089	137	137	137	0	0	1	-360	360	-2.7035	-1.6915	2.7038	1.5626	0.0000	0.0000	0.0000	0.0000;
	2544	2536	0.04124	0.072314	0.00687	69	69	69	0	0	1	-360	360	-32.7712	5.6907	33.1603	-5.8239	0.0000	0.0000	0.0000	0.0000;
	2534	2474	0.018603	0.056198	0.00581	81	81	81	0	0	1	-360	360	-9.8045	0.1915	9.8195	-0.8393	0.0000	0.0000	0.0000	0.0000;
	2591	2613	0.024793	0.08	0.00823	137	137	137	0	0	1	-360	360	-14.6824	2.4053	14.7292	-3.2317	0.0000	0.0000	0.0000	0.0000;
	2459	2656	0.01314	0.041818	0.004479	137	137	137	0	0	1	-360	360	9.5762	0.6434	-9.5661	-1.1478	0.0000	0.0000	0.0000	0.0000;
	2655	2617	0.009421	0.030661	0.003151	103	103	103	0	0	1	-360	360	-35.2792	24.1657	35.4282	-24.0455	0.0000	0.0000	0.0000	0.0000;
	2655	2587	0.029008	0.09438	0.009661	76	76	76	0	0	1	-360	360	-15.7764	-0.1187	15.8386	-0.8054	0.0000	0.0000	0.0000	0.0000;
	2472	2536	0.004207	0.010578	0.00106	120	120	120	0	0	1	-360	360	-22.9658	-3.9637	22.9849	3.8851	0.0000	0.0000	0.0000	0.0000;
	2717	2535	0.007364	0.023802	0.002439	90	90	90	0	0	1	-360	360	27.4712	-3.8197	-27.4240	3.6801	0.0000	0.0000	0.0000	0.0000;
	2717	2458	0.00157	0.004959	0.000511	137	137	137	0	0	1	-360	360	-27.2765	-0.0953	27.2862	0.0648	0.0000	0.0000	0.0000	0.0000;
	2717	2459	0.00157	0.004959	0.000511	137	137	137	0	0	1	-360	360	-28.3287	-0.0850	28.3392	0.0570	0.0000	0.0000	0.0000	0.0000;
	2466	2472	0.003058	0.009917	0.001019	137	137	137	0	0	1	-360	360	-16.2078	-3.0626	16.2148	2.9637	0.0000	0.0000	0.0000	0.0000;
	2590	2580	0.008256	0.026281	0.00286	69	69	69	0	0	1	-360	360	-47.8970	-0.1708	48.0641	0.3773	0.0000	0.0000	0.0000	0.0000;
	2517	2590	0.018099	0.057016	0.0062	69	69	69	0	0	1	-360	360	-34.2038	1.7256	34.3930	-1.8292	0.0000	0.0000	0.0000	0.0000;
	2561	2536	0.00405	0.010578	0.001089	95	95	95	0	0	1	-360	360	37.7159	-7.2278	-37.6661	7.2275	0.0000	0.0000	0.0000	0.0000;
	2463	2458	0.002314	0.007521	0.00077	137	137	137	0	0	1	-360	360	-38.7461	-4.9955	38.7756	4.9991	0.0000	0.0000	0.0000	0.0000;
	2651	2463	0.003967	0.012984	0.001309	137	137	137	0	0	1	-360	360	-32.5224	-4.0352	32.5581	3.9955	0.0000	0.0000	0.0000	0.0000;
	2551	2544	0.003612	0.011661	0.0012	137	137	137	0	0	1	-360	360	-32.7373	5.6588	32.7712	-5.6907	0.0000	0.0000	0.0000	0.0000;
	2661	2551	0.068984	0.121207	0.011449	57	57	57	0	0	1	-360	360	-26.1164	5.5814	26.5473	-6.1588	0.0000	0.0000	0.0000	0.0000;
	2462	2660	0.037603	0.091744	0.00968	99	99	99	0	0	1	-360	360	0.0001	-1.1911	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2629	2659	0.019669	0.086124	0.00924	57	57	57	0	0	1	-360	360	7.9333	-0.0689	-7.9230	-1.0000	0.0000	0.0000	0.0000	0.0000;
	2482	2661	0.066612	0.113058	0.01118	69	69	69	0	0	1	-360	360	-38.5722	5.2473	39.4824	-4.9705	0.0000	0.0000	0.0000	0.0000;
	2639	2553	0.013223	0.033058	0.003269	114	114	114	0	0	1	-360	360	-34.9426	3.7371	35.0826	-3.7701	0.0000	0.0000	0.0000	0.0000;
	2728	2639	0.05686	0.093388	0.00944	114	114	114	0	0	1	-360	360	-27.2453	4.7729	27.6276	-5.2371	0.0000	0.0000	0.0000	0.0000;
	2684	2535	0.037603	0.121653	0.01249	80	80	80	0	0	1	-360	360	-45.9656	-4.8832	46.6630	5.6747	0.0000	0.0000	0.0000	0.0000;
	2695	2587	0.030579	0.053719	0.00508	78	78	78	0	0	1	-360	360	-7.3140	-1.5000	7.3284	0.9324	0.0000	0.0000	0.0000	0.0000;
	2618	2537	0.008512	0.020744	0.002321	114	114	114	0	0	1	-360	360	-55.6349	6.6871	55.8668	-6.3906	0.0000	0.0000	0.0000	0.0000;
	2537	2681	0.040496	0.096686	0.010159	120	120	120	0	0	1	-360	360	-63.1298	7.3906	64.5430	-5.2152	0.0000	0.0000	0.0000	0.0000;
	2711	2567	0.034793	0.10281	0.01045	99	99	99	0	0	1	-360	360	-39.8856	9.1114	40.4071	-8.7500	0.0000	0.0000	0.0000	0.0000;
	2471	2651	0.001983	0.006281	0.000651	137	137	137	0	0	1	-360	360	-20.1356	-2.0913	20.1424	2.0352	0.0000	0.0000	0.0000	0.0000;
	2457	2471	0.006529	0.021157	0.0022	137	137	137	0	0	1	-360	360	-6.6292	-0.3456	6.6316	0.0913	0.0000	0.0000	0.0000	0.0000;
	2640	2579	0.009256	0.023802	0.00242	120	120	120	0	0	1	-360	360	15.7275	2.9699	-15.7068	-3.1934	0.0000	0.0000	0.0000	0.0000;
	2725	2617	0.062231	0.104132	0.010721	63	63	63	0	0	1	-360	360	-15.4325	0.1124	15.5633	-1.1207	0.0000	0.0000	0.0000	0.0000;
	2542	2725	0.047017	0.078512	0.00808	69	69	69	0	0	1	-360	360	-2.4750	-0.5000	2.4775	-0.4124	0.0000	0.0000	0.0000	0.0000;
	2477	2482	0.005446	0.007603	0.00077	69	69	69	0	0	1	-360	360	-30.6472	6.2286	30.6952	-6.2473	0.0000	0.0000	0.0000	0.0000;
	2617	2580	0.016198	0.033802	0.003509	90	90	90	0	0	1	-360	360	30.0220	3.3181	-29.8937	-3.4531	0.0000	0.0000	0.0000	0.0000;
	2633	2473	0.007917	0.025612	0.005261	114	114	114	0	0	1	-360	360	36.4221	-26.8160	-36.2867	26.6279	0.0000	0.0000	0.0000	0.0000;
	2655	2633	0.02781	0.089942	0.01845	114	114	114	0	0	1	-360	360	41.4906	-26.5470	-40.9231	26.2160	0.0000	0.0000	0.0000	0.0000;
	2457	2474	0.013967	0.044628	0.00462	126	126	126	0	0	1	-360	360	-7.4378	-1.6544	7.4446	1.1246	0.0000	0.0000	0.0000	0.0000;
	2613	2473	0.008678	0.028099	0.00295	88	88	88	0	0	1	-360	360	-31.0482	0.2317	31.1186	-0.3554	0.0000	0.0000	0.0000	0.0000;
	2650	2661	0.016066	0.052793	0.01083	69	69	69	0	0	1	-360	360	19.0443	0.5222	-18.9940	-1.6109	0.0000	0.0000	0.0000	0.0000;
	2635	2650	0.034	0.10995	0.022559	69	69	69	0	0	1	-360	360	21.7693	-1.1720	-21.6323	-1.0222	0.0000	0.0000	0.0000	0.0000;
	2503	2535	0.00562	0.018934	0.00189	32	32	32	0	0	1	-360	360	-9.0030	-2.0000	9.0070	1.7874	0.0000	0.0000	0.0000	0.0000;
	2504	2536	0.00562	0.018934	0.00189	32	32	32	0	0	1	-360	360	-4.7220	-0.8000	4.7231	0.5775	0.0000	0.0000	0.0000	0.0000;
	2718	2458	0.002149	0.00719	0.000721	57	57	57	0	0	1	-360	360	-1.1250	-0.5000	1.1250	0.4136	0.0000	0.0000	0.0000	0.0000;
	2647	2536	0.000909	0.003058	0.00031	46	46	46	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0371	0.0000	0.0000	0.0000	0.0000;
	2556	2558	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	23.8369	1.0565	-23.8041	-1.1409	0.0000	0.0000	0.0000	0.0000;
	2686	2474	0.020496	0.06876	0.00688	137	137	137	0	0	1	-360	360	-27.6016	0.3318	27.7336	-0.7073	0.0000	0.0000	0.0000	0.0000;
	2470	2477	0.037397	0.120661	0.01272	140	140	140	0	0	1	-360	360	-2.2510	-0.5000	2.2527	-0.9076	0.0000	0.0000	0.0000	0.0000;
	2686	2635	0.019281	0.062364	0.006398	137	137	137	0	0	1	-360	360	23.6616	-1.3318	-23.5703	0.8720	0.0000	0.0000	0.0000	0.0000;
	2495	2711	0.005702	0.010174	0.000939	69	69	69	0	0	1	-360	360	-37.8197	-2.5251	37.8929	2.5504	0.0000	0.0000	0.0000	0.0000;
	2709	2495	0.009669	0.017017	0.0016	90	90	90	0	0	1	-360	360	-30.7382	2.1413	30.8207	-2.1749	0.0000	0.0000	0.0000	0.0000;
	2540	2710	0.057686	0.145446	0.014999	76	76	76	0	0	1	-360	360	-28.9470	4.4091	29.3991	-4.9402	0.0000	0.0000	0.0000	0.0000;
	2573	2711	0.031983	0.07876	0.00786	90	90	90	0	0	1	-360	360	-46.2777	10.9592	46.9317	-10.2272	0.0000	0.0000	0.0000	0.0000;
	2707	2710	0.01843	0.06	0.006149	137	137	137	0	0	1	-360	360	-25.5274	3.0924	25.6368	-3.4261	0.0000	0.0000	0.0000	0.0000;
	2691	2692	0.005537	0.017934	0.001839	137	137	137	0	0	1	-360	360	-0.5174	0.6446	0.5174	-0.8471	0.0000	0.0000	0.0000	0.0000;
	2593	2464	0.036364	0.120661	0.01181	114	114	114	0	0	1	-360	360	-18.6569	2.9045	18.7760	-3.8146	0.0000	0.0000	0.0000	0.0000;
	2692	2688	0.003058	0.009917	0.001019	114	114	114	0	0	1	-360	360	-17.5040	-13.6530	17.5176	13.5848	0.0000	0.0000	0.0000	0.0000;
	2518	2573	0.067603	0.119008	0.0112	69	69	69	0	0	1	-360	360	-13.0711	6.5996	13.2069	-7.6043	0.0000	0.0000	0.0000	0.0000;
	2701	2518	0.038678	0.068099	0.006389	69	69	69	0	0	1	-360	360	-7.5085	8.4704	7.5551	-9.0996	0.0000	0.0000	0.0000	0.0000;
	2636	2573	0.050422	0.104868	0.0102	69	69	69	0	0	1	-360	360	-21.2844	6.0988	21.5118	-6.7549	0.0000	0.0000	0.0000	0.0000;
	2653	2636	0.01976	0.051397	0.00515	69	69	69	0	0	1	-360	360	-21.0918	5.8567	21.1784	-6.1988	0.0000	0.0000	0.0000	0.0000;
	2577	2529	0.02781	0.079678	0.008071	69	69	69	0	0	1	-360	360	-1.2619	-16.6370	1.3269	15.9028	0.0000	0.0000	0.0000	0.0000;
	2701	2577	0.014669	0.032388	0.003279	69	69	69	0	0	1	-360	360	-0.4835	-16.8244	0.5199	16.5370	0.0000	0.0000	0.0000	0.0000;
	2469	2533	0.022314	0.072314	0.014929	75	75	75	0	0	1	-360	360	-7.8308	-9.1511	7.8570	7.5660	0.0000	0.0000	0.0000	0.0000;
	2464	2469	0.013223	0.017769	0.001909	62	62	62	0	0	1	-360	360	-1.0350	-8.1524	1.0428	7.9511	0.0000	0.0000	0.0000	0.0000;
	2685	2529	0.008835	0.027917	0.003049	137	137	137	0	0	1	-360	360	-19.7178	-1.9304	19.7479	1.6744	0.0000	0.0000	0.0000	0.0000;
	2516	2685	0.006876	0.021579	0.002398	137	137	137	0	0	1	-360	360	-16.4125	-1.5546	16.4288	1.3304	0.0000	0.0000	0.0000	0.0000;
	2632	2694	0.015537	0.054554	0.005571	137	137	137	0	0	1	-360	360	-17.0698	4.6108	17.1145	-5.0656	0.0000	0.0000	0.0000	0.0000;
	2494	2648	0.008512	0.021744	0.0022	120	120	120	0	0	1	-360	360	22.5112	-6.0905	-22.4693	5.9553	0.0000	0.0000	0.0000	0.0000;
	2648	2692	0.00281	0.007017	0.00059	114	114	114	0	0	1	-360	360	8.0463	-9.4553	-8.0424	9.4000	0.0000	0.0000	0.0000	0.0000;
	2481	2706	0.027686	0.089504	0.009169	95	95	95	0	0	1	-360	360	-12.1034	-3.1180	12.1417	2.2208	0.0000	0.0000	0.0000	0.0000;
	2694	2481	0.021322	0.069421	0.007069	137	137	137	0	0	1	-360	360	-28.1445	1.4656	28.2990	-1.7423	0.0000	0.0000	0.0000	0.0000;
	2706	2712	0.015041	0.041322	0.004259	90	90	90	0	0	1	-360	360	-3.8681	8.9545	3.8815	-9.3932	0.0000	0.0000	0.0000	0.0000;
	2693	2691	0.017769	0.057364	0.005881	137	137	137	0	0	1	-360	360	4.6545	-5.1116	-4.6472	4.4881	0.0000	0.0000	0.0000	0.0000;
	2654	2527	0.007364	0.023802	0.00251	114	114	114	0	0	1	-360	360	-20.5421	-1.1060	20.5692	0.9045	0.0000	0.0000	0.0000	0.0000;
	2673	2586	0.004207	0.010744	0.00121	114	114	114	0	0	1	-360	360	-12.6698	0.9840	12.6757	-1.1077	0.0000	0.0000	0.0000	0.0000;
	2464	2653	0.023314	0.078934	0.007451	69	69	69	0	0	1	-360	360	-11.6120	7.5755	11.6538	-8.2567	0.0000	0.0000	0.0000	0.0000;
	2673	2526	0.002727	0.008256	0.000849	120	120	120	0	0	1	-360	360	0.0270	3.4981	-0.0267	-3.5946	0.0000	0.0000	0.0000	0.0000;
	2526	2516	0.001488	0.004959	0.000479	137	137	137	0	0	1	-360	360	-9.7303	-0.0054	9.7315	-0.0454	0.0000	0.0000	0.0000	0.0000;
	2483	2529	0.028678	0.092562	0.009511	57	57	57	0	0	1	-360	360	-3.6051	-3.4394	3.6104	2.3628	0.0000	0.0000	0.0000	0.0000;
	2494	2540	0.013636	0.035537	0.0037	120	120	120	0	0	1	-360	360	-23.4652	5.8905	23.5380	-6.1091	0.0000	0.0000	0.0000	0.0000;
	2691	2688	0.004207	0.013554	0.001401	131	131	131	0	0	1	-360	360	-13.5041	-9.0086	13.5141	8.8862	0.0000	0.0000	0.0000	0.0000;
	2632	2693	0.005289	0.010744	0.001111	90	90	90	0	0	1	-360	360	7.7931	-3.9261	-7.7895	3.8116	0.0000	0.0000	0.0000	0.0000;
	2712	2709	0.009339	0.016529	0.00174	90	90	90	0	0	1	-360	360	-16.5015	5.7932	16.5272	-5.9413	0.0000	0.0000	0.0000	0.0000;
	2566	2528	0.02124	0.068603	0.00704	99	99	99	0	0	1	-360	360	-25.8655	-5.1601	25.9947	4.7712	0.0000	0.0000	0.0000	0.0000;
	2533	2527	0.031397	0.098843	0.01074	126	126	126	0	0	1	-360	360	-14.3260	-9.6660	14.4061	8.6937	0.0000	0.0000	0.0000	0.0000;
	2568	2688	0.008512	0.02686	0.002899	95	95	95	0	0	1	-360	360	-8.0396	5.1471	8.0468	-5.4452	0.0000	0.0000	0.0000	0.0000;
	2563	2568	0.018099	0.057016	0.0062	95	95	95	0	0	1	-360	360	-6.9676	4.6978	6.9796	-5.3471	0.0000	0.0000	0.0000	0.0000;
	2480	2688	0.01719	0.057769	0.005779	69	69	69	0	0	1	-360	360	-2.8773	-3.8583	2.8805	3.2319	0.0000	0.0000	0.0000	0.0000;
	2575	2710	0.015793	0.040174	0.00408	120	120	120	0	0	1	-360	360	69.3732	-5.9723	-68.7023	7.2169	0.0000	0.0000	0.0000	0.0000;
	2620	2566	0.033636	0.107438	0.010159	107	107	107	0	0	1	-360	360	-23.5860	-4.6480	23.7595	4.0601	0.0000	0.0000	0.0000	0.0000;
	2654	2586	0.008256	0.016529	0.001941	114	114	114	0	0	1	-360	360	15.9821	-0.2940	-15.9637	0.1077	0.0000	0.0000	0.0000	0.0000;
	2706	2721	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	32.3946	4.9444	-32.3470	-4.9547	0.0000	0.0000	0.0000	0.0000;
	2706	2721	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	32.3946	4.9444	-32.3470	-4.9547	0.0000	0.0000	0.0000	0.0000;
	2522	2688	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	0.8030	1.1000	-0.8029	-1.1807	0.0000	0.0000	0.0000	0.0000;
	2523	2689	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	-1.6960	-0.7000	1.6961	0.6194	0.0000	0.0000	0.0000	0.0000;
	2696	2691	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	-7.2840	-1.1629	7.2864	1.0861	0.0000	0.0000	0.0000	0.0000;
	2698	2632	0.025397	0.082157	0.008429	123	123	123	0	0	1	-360	360	-3.4395	1.0695	3.4427	-1.9846	0.0000	0.0000	0.0000	0.0000;
	2698	2480	0.016364	0.052893	0.005581	140	140	140	0	0	1	-360	360	1.2115	-2.1695	-1.2107	1.5583	0.0000	0.0000	0.0000	0.0000;
	2563	2701	0.020413	0.06843	0.006851	123	123	123	0	0	1	-360	360	2.0886	-5.4978	-2.0830	4.7540	0.0000	0.0000	0.0000	0.0000;
	2696	2691	0.009917	0.034876	0.00407	76	76	76	0	0	1	-360	360	-1.6250	-1.0371	1.6253	0.5898	0.0000	0.0000	0.0000	0.0000;
	2708	2673	0.020174	0.052231	0.00545	120	120	120	0	0	1	-360	360	-43.6697	4.0359	44.0126	-3.7694	0.0000	0.0000	0.0000	0.0000;
	2673	2528	0.009504	0.024554	0.00256	114	114	114	0	0	1	-360	360	-37.2465	-1.1438	37.3616	1.1464	0.0000	0.0000	0.0000	0.0000;
	2677	2662	0.01405	0.023141	0.00234	90	90	90	0	0	1	-360	360	-17.6086	-2.3637	17.6451	2.1389	0.0000	0.0000	0.0000	0.0000;
	2670	2672	0.03286	0.076678	0.00771	69	69	69	0	0	1	-360	360	15.1613	1.2280	-15.0989	-2.0223	0.0000	0.0000	0.0000	0.0000;
	2667	2669	0.042231	0.098959	0.00974	69	69	69	0	0	1	-360	360	-5.4051	1.5697	5.4168	-2.7358	0.0000	0.0000	0.0000	0.0000;
	2671	2729	0.073058	0.191901	0.018319	69	69	69	0	0	1	-360	360	-11.0894	-2.0293	11.1640	-0.0150	0.0000	0.0000	0.0000	0.0000;
	2672	2597	0.030909	0.081066	0.007739	69	69	69	0	0	1	-360	360	-10.3651	-1.8065	10.3929	0.9375	0.0000	0.0000	0.0000	0.0000;
	2597	2729	0.042066	0.110744	0.010529	69	69	69	0	0	1	-360	360	-11.5589	-1.3375	11.6051	0.1669	0.0000	0.0000	0.0000	0.0000;
	2668	2671	0.016529	0.033058	0.00242	69	69	69	0	0	1	-360	360	-28.0240	-7.5151	28.1398	7.4549	0.0000	0.0000	0.0000	0.0000;
	2570	2490	0.040496	0.071066	0.00673	90	90	90	0	0	1	-360	360	-19.6268	-7.0960	19.7793	6.5861	0.0000	0.0000	0.0000	0.0000;
	2490	2668	0.046281	0.071066	0.007599	78	78	78	0	0	1	-360	360	-22.2563	-7.0861	22.4700	6.5151	0.0000	0.0000	0.0000	0.0000;
	2671	2677	0.004959	0.008256	0.000849	78	78	78	0	0	1	-360	360	-9.8296	-1.4600	9.8336	1.3637	0.0000	0.0000	0.0000	0.0000;
	2571	2570	0.004132	0.013719	0.001379	137	137	137	0	0	1	-360	360	-7.3736	-2.8962	7.3759	2.7462	0.0000	0.0000	0.0000	0.0000;
	2669	2699	0.022752	0.045	0.004593	78	78	78	0	0	1	-360	360	8.4779	-2.0661	-8.4640	1.5313	0.0000	0.0000	0.0000	0.0000;
	2662	2670	0.006347	0.021851	0.002877	78	78	78	0	0	1	-360	360	-31.4861	-3.1389	31.5381	2.9662	0.0000	0.0000	0.0000	0.0000;
	2582	2729	0.04438	0.078256	0.007391	46	46	46	0	0	1	-360	360	-15.0396	0.1826	15.1220	-0.9439	0.0000	0.0000	0.0000	0.0000;
	2612	2582	0.056612	0.099826	0.009431	46	46	46	0	0	1	-360	360	-8.7388	0.0990	8.7746	-1.1826	0.0000	0.0000	0.0000	0.0000;
	2475	2612	0.019752	0.062149	0.006749	90	90	90	0	0	1	-360	360	-6.5088	-0.3962	6.5158	-0.3990	0.0000	0.0000	0.0000	0.0000;
	2505	2475	0.036686	0.064711	0.00611	90	90	90	0	0	1	-360	360	0.9665	-0.1349	-0.9662	-0.6038	0.0000	0.0000	0.0000	0.0000;
	2491	2672	0.035868	0.071322	0.006241	38	38	38	0	0	1	-360	360	-2.7895	0.3867	2.7920	-1.1385	0.0000	0.0000	0.0000	0.0000;
	2704	2571	0.03438	0.060992	0.005689	137	137	137	0	0	1	-360	360	-1.8171	-2.5399	1.8196	1.8962	0.0000	0.0000	0.0000	0.0000;
	2505	2491	0.035868	0.071322	0.006241	90	90	90	0	0	1	-360	360	-2.6325	-0.2651	2.6345	-0.4867	0.0000	0.0000	0.0000	0.0000;
	2489	2530	0.020397	0.06595	0.006771	90	90	90	0	0	1	-360	360	-23.8410	14.3143	23.9844	-14.6029	0.0000	0.0000	0.0000	0.0000;
	2486	2530	0.014554	0.047471	0.00483	120	120	120	0	0	1	-360	360	26.8810	-13.7460	-26.7614	13.6029	0.0000	0.0000	0.0000	0.0000;
	2509	2619	0.006612	0.015703	0.001689	103	103	103	0	0	1	-360	360	23.5924	4.4864	-23.5588	-4.5984	0.0000	0.0000	0.0000	0.0000;
	2514	2478	0.009826	0.017364	0.0016	137	137	137	0	0	1	-360	360	-21.4086	-9.8602	21.4575	9.7679	0.0000	0.0000	0.0000	0.0000;
	2478	2510	0.030248	0.097521	0.010019	86	86	86	0	0	1	-360	360	-14.4920	2.9737	14.5521	-3.9041	0.0000	0.0000	0.0000	0.0000;
	2546	2511	0.011488	0.034711	0.002931	120	120	120	0	0	1	-360	360	-37.8730	-0.5770	38.0204	0.6931	0.0000	0.0000	0.0000	0.0000;
	2705	2546	0.008256	0.028934	0.00363	120	120	120	0	0	1	-360	360	-29.2286	0.9089	29.2920	-1.0920	0.0000	0.0000	0.0000	0.0000;
	2574	2506	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-40.6249	-1.0700	40.6431	1.0865	0.0000	0.0000	0.0000	0.0000;
	2574	2602	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	3.8727	0.7391	-3.8725	-0.7825	0.0000	0.0000	0.0000	0.0000;
	2574	2602	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	3.8727	0.7391	-3.8725	-0.7825	0.0000	0.0000	0.0000	0.0000;
	2513	2705	0.010826	0.034711	0.003579	137	137	137	0	0	1	-360	360	-15.8061	3.3040	15.8316	-3.6209	0.0000	0.0000	0.0000	0.0000;
	2521	2513	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-7.8088	-1.5259	7.8095	1.4849	0.0000	0.0000	0.0000	0.0000;
	2680	2521	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	2.1353	0.4129	-2.1352	-0.4561	0.0000	0.0000	0.0000	0.0000;
	2514	2680	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	6.8458	1.3103	-6.8453	-1.3519	0.0000	0.0000	0.0000	0.0000;
	2478	2726	0.036686	0.118182	0.01217	95	95	95	0	0	1	-360	360	10.1365	-8.9265	-10.0806	7.7349	0.0000	0.0000	0.0000	0.0000;
	2703	2726	0.017364	0.05686	0.005779	137	137	137	0	0	1	-360	360	-4.1674	-8.9395	4.1815	8.3343	0.0000	0.0000	0.0000	0.0000;
	2687	2507	0.032479	0.108099	0.01445	137	137	137	0	0	1	-360	360	-1.8437	-7.0650	1.8562	5.4877	0.0000	0.0000	0.0000	0.0000;
	2676	2506	0.054554	0.180174	0.0242	99	99	99	0	0	1	-360	360	-20.2981	-3.9010	20.5063	1.8950	0.0000	0.0000	0.0000	0.0000;
	2508	2511	0.019174	0.02595	0.004671	69	69	69	0	0	1	-360	360	8.2250	-1.3853	-8.2133	0.8739	0.0000	0.0000	0.0000	0.0000;
	2619	2511	0.01405	0.036364	0.003991	103	103	103	0	0	1	-360	360	11.5218	2.1994	-11.5046	-2.6058	0.0000	0.0000	0.0000	0.0000;
	2644	2510	0.035868	0.090083	0.00924	114	114	114	0	0	1	-360	360	-18.7897	0.7701	18.9042	-1.5149	0.0000	0.0000	0.0000	0.0000;
	2716	2511	0.015	0.047141	0.004661	114	114	114	0	0	1	-360	360	-10.7607	-2.0713	10.7766	1.5968	0.0000	0.0000	0.0000	0.0000;
	2674	2716	0.005248	0.016504	0.001631	114	114	114	0	0	1	-360	360	-7.0952	-1.5244	7.0977	1.3491	0.0000	0.0000	0.0000	0.0000;
	2713	2716	0.000256	0.000661	7e-05	114	114	114	0	0	1	-360	360	-3.6630	-0.7300	3.6630	0.7222	0.0000	0.0000	0.0000	0.0000;
	2645	2702	0.041744	0.073223	0.006921	90	90	90	0	0	1	-360	360	7.6924	-4.8464	-7.6630	4.1234	0.0000	0.0000	0.0000	0.0000;
	2702	2727	0.023058	0.07438	0.00765	137	137	137	0	0	1	-360	360	-7.9330	-7.2534	7.9556	6.4647	0.0000	0.0000	0.0000	0.0000;
	2513	2690	0.000992	0.003471	0.000361	137	137	137	0	0	1	-360	360	6.9109	-3.6583	-6.9104	3.6201	0.0000	0.0000	0.0000	0.0000;
	2627	2674	0.003636	0.010744	0.00106	114	114	114	0	0	1	-360	360	7.2455	1.1789	-7.2438	-1.2926	0.0000	0.0000	0.0000	0.0000;
	2508	2631	0.004628	0.014876	0.00152	137	137	137	0	0	1	-360	360	32.1141	6.0200	-32.0704	-6.0507	0.0000	0.0000	0.0000	0.0000;
	2520	2644	0.003719	0.009339	0.000939	120	120	120	0	0	1	-360	360	-7.3796	2.9661	7.3817	-3.0651	0.0000	0.0000	0.0000	0.0000;
	2514	2520	0.004959	0.012727	0.00128	95	95	95	0	0	1	-360	360	4.3454	5.1240	-4.3434	-5.2611	0.0000	0.0000	0.0000	0.0000;
	2487	2574	0.011157	0.015289	0.002749	114	114	114	0	0	1	-360	360	-22.5704	2.2547	22.6216	-2.4943	0.0000	0.0000	0.0000	0.0000;
	2510	2487	0.011157	0.015289	0.002749	114	114	114	0	0	1	-360	360	-11.1482	4.2604	11.1624	-4.5497	0.0000	0.0000	0.0000	0.0000;
	2511	2675	0.014959	0.043802	0.00445	114	114	114	0	0	1	-360	360	10.9863	1.2737	-10.9700	-1.7267	0.0000	0.0000	0.0000	0.0000;
	2512	2507	0.007603	0.019826	0.002059	120	120	120	0	0	1	-360	360	-20.9919	-3.5867	21.0225	3.4349	0.0000	0.0000	0.0000	0.0000;
	2584	2511	0.034793	0.111901	0.011761	76	76	76	0	0	1	-360	360	-3.3822	-5.8268	3.3942	4.5472	0.0000	0.0000	0.0000	0.0000;
	2687	2584	0.007017	0.022397	0.002369	123	123	123	0	0	1	-360	360	6.6706	-4.0964	-6.6668	3.8448	0.0000	0.0000	0.0000	0.0000;
	2625	2682	0.00843	0.021488	0.002161	120	120	120	0	0	1	-360	360	-21.8162	7.8764	21.8571	-8.0125	0.0000	0.0000	0.0000	0.0000;
	2687	2625	0.00843	0.021488	0.002161	120	120	120	0	0	1	-360	360	-18.8528	8.3444	18.8852	-8.5024	0.0000	0.0000	0.0000	0.0000;
	2572	2578	0.019917	0.052446	0.005191	120	120	120	0	0	1	-360	360	-26.9608	7.1071	27.1005	-7.3185	0.0000	0.0000	0.0000	0.0000;
	2682	2572	0.011868	0.03176	0.003151	120	120	120	0	0	1	-360	360	-26.3581	7.0735	26.4378	-7.2111	0.0000	0.0000	0.0000	0.0000;
	2630	2508	0.005041	0.016859	0.00174	137	137	137	0	0	1	-360	360	-8.9020	0.8309	8.9056	-1.0155	0.0000	0.0000	0.0000	0.0000;
	2455	2508	0.003314	0.010909	0.001111	137	137	137	0	0	1	-360	360	-16.0504	-2.6685	16.0582	2.5686	0.0000	0.0000	0.0000	0.0000;
	2675	2637	0.007769	0.024793	0.00257	137	137	137	0	0	1	-360	360	10.4470	1.6227	-10.4393	-1.8862	0.0000	0.0000	0.0000	0.0000;
	2598	2479	0.007107	0.023141	0.00234	124	124	124	0	0	1	-360	360	-14.2331	-7.6185	14.2495	7.4105	0.0000	0.0000	0.0000	0.0000;
	2631	2599	0.003058	0.009917	0.001019	137	137	137	0	0	1	-360	360	23.8024	4.3817	-23.7865	-4.4446	0.0000	0.0000	0.0000	0.0000;
	2649	2645	0.006446	0.020661	0.00213	137	137	137	0	0	1	-360	360	31.0201	-8.7884	-30.9604	8.7415	0.0000	0.0000	0.0000	0.0000;
	2641	2506	0.00124	0.004132	0.000409	137	137	137	0	0	1	-360	360	10.8950	-2.5042	-10.8936	2.4625	0.0000	0.0000	0.0000	0.0000;
	2642	2507	0.00124	0.004132	0.000409	137	137	137	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0461	0.0000	0.0000	0.0000	0.0000;
	2507	2509	0.020744	0.067273	0.00682	137	137	137	0	0	1	-360	360	-12.1606	-3.6902	12.1898	3.0127	0.0000	0.0000	0.0000	0.0000;
	2641	2525	0.005446	0.017364	0.001769	137	137	137	0	0	1	-360	360	-4.5030	1.1482	4.5041	-1.3446	0.0000	0.0000	0.0000	0.0000;
	2507	2455	0.006124	0.015703	0.001571	120	120	120	0	0	1	-360	360	-6.1723	-0.7543	6.1744	0.5825	0.0000	0.0000	0.0000	0.0000;
	2606	2509	0.001322	0.004207	0.00044	137	137	137	0	0	1	-360	360	-47.6514	-4.3994	47.6781	4.4341	0.0000	0.0000	0.0000	0.0000;
	2506	2606	0.007934	0.022314	0.002149	123	123	123	0	0	1	-360	360	-33.4427	-1.6044	33.5214	1.5824	0.0000	0.0000	0.0000	0.0000;
	2525	2630	0.009091	0.028934	0.002899	137	137	137	0	0	1	-360	360	-4.7131	1.3446	4.7150	-1.6659	0.0000	0.0000	0.0000	0.0000;
	2637	2678	0.007364	0.023719	0.00242	137	137	137	0	0	1	-360	360	-3.0907	-0.9308	3.0914	0.6617	0.0000	0.0000	0.0000	0.0000;
	2479	2649	0.003314	0.010744	0.001089	137	137	137	0	0	1	-360	360	41.9584	-6.5467	-41.9051	6.5974	0.0000	0.0000	0.0000	0.0000;
	2690	2548	0.002066	0.006942	0.000699	137	137	137	0	0	1	-360	360	1.4674	-4.6631	-1.4670	4.5867	0.0000	0.0000	0.0000	0.0000;
	2703	2645	0.011322	0.036364	0.003751	137	137	137	0	0	1	-360	360	-8.9166	6.3315	8.9290	-6.7122	0.0000	0.0000	0.0000	0.0000;
	2548	2598	0.002893	0.009256	0.000939	137	137	137	0	0	1	-360	360	-6.3820	-6.1517	6.3841	6.0535	0.0000	0.0000	0.0000	0.0000;
	2599	2627	0.002479	0.007438	0.000731	120	120	120	0	0	1	-360	360	11.3305	1.9406	-11.3275	-2.0139	0.0000	0.0000	0.0000	0.0000;
	2549	2512	0.004917	0.023016	0.00236	120	120	120	0	0	1	-360	360	-6.6509	-1.0253	6.6529	0.7697	0.0000	0.0000	0.0000	0.0000;
	2678	2549	0.004917	0.023016	0.00236	120	120	120	0	0	1	-360	360	-3.3004	-0.6617	3.3009	0.3993	0.0000	0.0000	0.0000	0.0000;
	2608	2727	0.001653	0.004959	0.00053	137	137	137	0	0	1	-360	360	-9.3321	1.7619	9.3334	-1.8180	0.0000	0.0000	0.0000	0.0000;
	2485	2676	0.039504	0.124554	0.011761	38	38	38	0	0	1	-360	360	-9.3580	-1.3879	9.3900	0.2045	0.0000	0.0000	0.0000	0.0000;
	2545	2511	0.039504	0.069587	0.00657	72	72	72	0	0	1	-360	360	-25.2493	-0.1164	25.4767	-0.2173	0.0000	0.0000	0.0000	0.0000;
	2543	2545	0.053058	0.093554	0.00884	72	72	72	0	0	1	-360	360	-16.4293	0.9169	16.5613	-1.6566	0.0000	0.0000	0.0000	0.0000;
	2666	2543	0.032934	0.106504	0.010931	137	137	137	0	0	1	-360	360	-2.2472	1.1409	2.2497	-2.3286	0.0000	0.0000	0.0000	0.0000;
	2665	2543	0.058066	0.103058	0.00937	76	76	76	0	0	1	-360	360	-5.8930	-0.7300	5.9116	-0.2573	0.0000	0.0000	0.0000	0.0000;
	2676	2666	0.024438	0.079017	0.008109	137	137	137	0	0	1	-360	360	0.0601	0.7754	-0.0598	-1.6629	0.0000	0.0000	0.0000	0.0000;
	2465	2726	0.021388	0.069537	0.007289	120	120	120	0	0	1	-360	360	-3.3999	3.3990	3.4048	-4.2104	0.0000	0.0000	0.0000	0.0000;
	2652	2510	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-7.6960	-1.7730	7.6967	1.7315	0.0000	0.0000	0.0000	0.0000;
	2508	2720	0.004628	0.014876	0.00152	120	120	120	0	0	1	-360	360	9.7380	1.8233	-9.7340	-1.9820	0.0000	0.0000	0.0000	0.0000;
	2509	2719	0.004628	0.014876	0.00152	120	120	120	0	0	1	-360	360	6.3867	1.0848	-6.3850	-1.2520	0.0000	0.0000	0.0000	0.0000;
	2626	2507	0.01281	0.021488	0.00212	78	78	78	0	0	1	-360	360	-9.6759	-5.4982	9.6899	5.2831	0.0000	0.0000	0.0000	0.0000;
	2476	2626	0.026198	0.043967	0.004339	78	78	78	0	0	1	-360	360	-5.8939	-5.2302	5.9079	4.7682	0.0000	0.0000	0.0000	0.0000;
	2588	2460	0.03905	0.126281	0.012971	95	95	95	0	0	1	-360	360	-6.9318	-1.6940	6.9490	0.3005	0.0000	0.0000	0.0000	0.0000;
	2714	2604	0.011653	0.037686	0.00387	137	137	137	0	0	1	-360	360	-16.3278	-2.0051	16.3556	1.6573	0.0000	0.0000	0.0000	0.0000;
	2460	2714	0.021397	0.069174	0.0071	137	137	137	0	0	1	-360	360	-13.1790	-1.8005	13.2125	1.1102	0.0000	0.0000	0.0000	0.0000;
	2468	2714	0.00281	0.009174	0.000939	123	123	123	0	0	1	-360	360	-3.1150	-1.0000	3.1153	0.8949	0.0000	0.0000	0.0000	0.0000;
	2679	2603	0.158017	0.182727	0.016429	46	46	46	0	0	1	-360	360	10.8286	-9.4751	-10.5638	7.9175	0.0000	0.0000	0.0000	0.0000;
	2616	2604	0.009826	0.017521	0.0016	80	80	80	0	0	1	-360	360	-26.8421	0.6784	26.9049	-0.7474	0.0000	0.0000	0.0000	0.0000;
	2515	2600	0.010388	0.050826	0.004939	133	133	133	0	0	1	-360	360	-18.8059	-4.7756	18.8406	4.3898	0.0000	0.0000	0.0000	0.0000;
	2576	2600	0.036033	0.128934	0.012509	69	69	69	0	0	1	-360	360	-10.6647	-3.6379	10.7044	2.3773	0.0000	0.0000	0.0000	0.0000;
	2492	2603	0.022339	0.074959	0.00748	69	69	69	0	0	1	-360	360	-28.8349	2.2900	29.0016	-2.5750	0.0000	0.0000	0.0000	0.0000;
	2456	2576	0.041397	0.069421	0.00711	69	69	69	0	0	1	-360	360	-0.5773	-2.2308	0.5787	1.4426	0.0000	0.0000	0.0000	0.0000;
	2524	2576	0.033141	0.061157	0.006389	69	69	69	0	0	1	-360	360	-3.1150	-1.0000	3.1180	0.2952	0.0000	0.0000	0.0000	0.0000;
	2557	2456	0.037686	0.121488	0.01249	69	69	69	0	0	1	-360	360	6.7071	-1.5693	-6.6917	0.2308	0.0000	0.0000	0.0000	0.0000;
	2559	2557	0.019422	0.06281	0.00649	69	69	69	0	0	1	-360	360	9.8391	-1.2377	-9.8221	0.5693	0.0000	0.0000	0.0000	0.0000;
	2605	2600	0.035868	0.115702	0.012199	140	140	140	0	0	1	-360	360	22.6301	-9.9982	-22.4388	9.2422	0.0000	0.0000	0.0000	0.0000;
	2538	2601	0.030248	0.097521	0.01028	140	140	140	0	0	1	-360	360	7.9855	-3.4594	-7.9662	2.3614	0.0000	0.0000	0.0000	0.0000;
	2569	2532	0.009826	0.017273	0.001631	69	69	69	0	0	1	-360	360	-7.7308	2.1010	7.7365	-2.2708	0.0000	0.0000	0.0000	0.0000;
	2610	2569	0.053223	0.093471	0.008821	69	69	69	0	0	1	-360	360	0.0635	3.1363	-0.0572	-4.1010	0.0000	0.0000	0.0000	0.0000;
	2614	2607	0.006612	0.013719	0.001331	69	69	69	0	0	1	-360	360	3.7742	0.3441	-3.7734	-0.4924	0.0000	0.0000	0.0000	0.0000;
	2607	2615	0.005372	0.017364	0.001791	69	69	69	0	0	1	-360	360	-6.6106	-1.5076	6.6128	1.3128	0.0000	0.0000	0.0000	0.0000;
	2588	2559	0.023388	0.075868	0.007841	34	34	34	0	0	1	-360	360	-6.8504	-0.0431	6.8603	-0.7986	0.0000	0.0000	0.0000	0.0000;
	2615	2603	0.01157	0.037686	0.00387	69	69	69	0	0	1	-360	360	-15.1398	-2.7128	15.1639	2.3539	0.0000	0.0000	0.0000	0.0000;
	2589	2601	0.033099	0.111066	0.011059	114	114	114	0	0	1	-360	360	-27.9205	0.2717	28.1528	-0.7310	0.0000	0.0000	0.0000	0.0000;
	2592	2605	0.028182	0.091157	0.009341	69	69	69	0	0	1	-360	360	28.0389	-8.8521	-27.8241	8.4982	0.0000	0.0000	0.0000	0.0000;
	2610	2515	0.024463	0.043471	0.004039	69	69	69	0	0	1	-360	360	-14.6015	-4.1363	14.6519	3.7756	0.0000	0.0000	0.0000	0.0000;
	2609	2604	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	-5.7110	-1.0000	5.7130	0.8532	0.0000	0.0000	0.0000	0.0000;
	2616	2614	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	9.0762	1.2042	-9.0712	-1.3441	0.0000	0.0000	0.0000	0.0000;
	2589	2585	0.020496	0.06876	0.00688	69	69	69	0	0	1	-360	360	19.0935	-1.2717	-19.0261	0.7351	0.0000	0.0000	0.0000	0.0000;
	2646	2559	0.015678	0.050702	0.005201	84	84	84	0	0	1	-360	360	-4.1540	-1.0000	4.1565	0.4283	0.0000	0.0000	0.0000	0.0000;
	2600	2603	0.01281	0.042984	0.004281	114	114	114	0	0	1	-360	360	-45.3936	8.3370	45.6358	-8.0085	0.0000	0.0000	0.0000	0.0000;
	2601	2604	0.01281	0.042984	0.004281	114	114	114	0	0	1	-360	360	-46.0715	8.2729	46.3206	-7.9217	0.0000	0.0000	0.0000	0.0000;
	2538	2616	0.014463	0.055537	0.004479	69	69	69	0	0	1	-360	360	-12.6475	2.4594	12.6690	-2.8825	0.0000	0.0000	0.0000	0.0000;
	2461	2498	0.023554	0.062149	0.006389	82	82	82	0	0	1	-360	360	-16.5809	-0.2417	16.6336	-0.4079	0.0000	0.0000	0.0000	0.0000;
	2539	2461	0.027603	0.049504	0.004479	69	69	69	0	0	1	-360	360	-7.2705	1.0622	7.2828	-1.5907	0.0000	0.0000	0.0000	0.0000;
	2519	2539	0.039669	0.07157	0.006411	69	69	69	0	0	1	-360	360	-4.9983	0.2911	5.0065	-1.0622	0.0000	0.0000	0.0000	0.0000;
	2550	2519	0.029826	0.057934	0.005469	69	69	69	0	0	1	-360	360	-0.4702	0.1215	0.4703	-0.7911	0.0000	0.0000	0.0000	0.0000;
	2555	2497	0.009256	0.030083	0.003071	119	119	119	0	0	1	-360	360	-27.9895	-1.9403	28.0486	1.7531	0.0000	0.0000	0.0000	0.0000;
	2664	2658	0.053141	0.093388	0.008901	69	69	69	0	0	1	-360	360	-15.9977	0.9577	16.1212	-1.7353	0.0000	0.0000	0.0000	0.0000;
	2552	2555	0.001322	0.004207	0.00044	99	99	99	0	0	1	-360	360	-13.2716	-0.9885	13.2735	0.9403	0.0000	0.0000	0.0000	0.0000;
	2554	2498	0.009091	0.029752	0.00302	137	137	137	0	0	1	-360	360	-19.2294	-0.7026	19.2567	0.4185	0.0000	0.0000	0.0000	0.0000;
	2496	2497	0.055041	0.164298	0.016819	69	69	69	0	0	1	-360	360	-5.6288	-1.9764	5.6434	-0.0545	0.0000	0.0000	0.0000	0.0000;
	2723	2493	0.036529	0.064132	0.00605	69	69	69	0	0	1	-360	360	4.5349	-0.6464	-4.5280	0.0000	0.0000	0.0000	0.0000	0.0000;
	2565	2554	0.01595	0.05124	0.0053	137	137	137	0	0	1	-360	360	-7.2694	-1.3334	7.2764	0.7026	0.0000	0.0000	0.0000	0.0000;
	2565	2552	0.007438	0.023967	0.002461	126	126	126	0	0	1	-360	360	-3.0830	-0.2896	3.0836	-0.0115	0.0000	0.0000	0.0000	0.0000;
	2629	2531	0.036686	0.116686	0.012509	69	69	69	0	0	1	-360	360	-12.4613	-0.4311	12.5085	-0.9348	0.0000	0.0000	0.0000	0.0000;
	2723	2664	0.083141	0.146281	0.01392	69	69	69	0	0	1	-360	360	-13.5921	0.1755	13.7337	-1.4577	0.0000	0.0000	0.0000	0.0000;
	2700	2497	0.026612	0.089422	0.008949	137	137	137	0	0	1	-360	360	-14.2636	-0.7449	14.3076	-0.2115	0.0000	0.0000	0.0000	0.0000;
	2565	2663	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	3.5614	0.6230	-3.5577	-1.3444	0.0000	0.0000	0.0000	0.0000;
	2547	2550	0.005207	0.014132	0.001401	90	90	90	0	0	1	-360	360	-3.9620	-0.5000	3.9627	0.3302	0.0000	0.0000	0.0000	0.0000;
	2550	2700	0.01843	0.061901	0.0062	137	137	137	0	0	1	-360	360	-10.2845	-1.4518	10.3006	0.7449	0.0000	0.0000	0.0000	0.0000;
	2488	2723	0.001818	0.003876	0.000271	76	76	76	0	0	1	-360	360	-3.3970	-0.5000	3.3972	0.4709	0.0000	0.0000	0.0000	0.0000;
	2657	2658	0.003471	0.012636	0.001191	123	123	123	0	0	1	-360	360	-36.2250	-4.2251	36.2662	4.2412	0.0000	0.0000	0.0000	0.0000;
	2502	2724	0.003314	0.010578	0.001089	137	137	137	0	0	1	-360	360	-6.2451	-7.2181	6.2478	7.1064	0.0000	0.0000	0.0000	0.0000;
	2643	2502	0.029752	0.095868	0.01007	137	137	137	0	0	1	-360	360	2.0765	-7.5766	-2.0619	6.5181	0.0000	0.0000	0.0000	0.0000;
	2581	2643	0.005124	0.016529	0.00174	137	137	137	0	0	1	-360	360	12.7822	-6.6352	-12.7725	6.4766	0.0000	0.0000	0.0000	0.0000;
	2560	2594	0.033471	0.065289	0.005929	21	21	21	0	0	1	-360	360	-4.1540	0.0000	4.1593	-0.6463	0.0000	0.0000	0.0000	0.0000;
	2467	2628	0.016529	0.031397	0.002899	48	48	48	0	0	1	-360	360	12.6185	-4.7890	-12.5916	4.5186	0.0000	0.0000	0.0000	0.0000;
	2634	2467	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	17.7161	-4.9524	-17.6155	4.4890	0.0000	0.0000	0.0000	0.0000;
	2628	2500	0.016529	0.031397	0.003151	48	48	48	0	0	1	-360	360	11.7606	-4.5186	-11.7371	4.2140	0.0000	0.0000	0.0000	0.0000;
	2611	2634	0.022884	0.074	0.007592	69	69	69	0	0	1	-360	360	18.9392	-4.6506	-18.8621	4.0524	0.0000	0.0000	0.0000	0.0000;
	2724	2499	0.001653	0.005289	0.00053	137	137	137	0	0	1	-360	360	-13.7248	-9.9064	13.7291	9.8615	0.0000	0.0000	0.0000	0.0000;
	2501	2500	0.009091	0.028099	0.00288	133	133	133	0	0	1	-360	360	-3.0449	-4.1157	3.0469	3.8035	0.0000	0.0000	0.0000	0.0000;
	2564	2562	0.00405	0.013314	0.001379	95	95	95	0	0	1	-360	360	-7.2859	1.8541	7.2880	-1.9975	0.0000	0.0000	0.0000	0.0000;
	2583	2564	0.020744	0.066281	0.006989	126	126	126	0	0	1	-360	360	-0.2238	1.9948	0.2249	-2.7541	0.0000	0.0000	0.0000	0.0000;
	2683	2583	0.028347	0.092231	0.009511	137	137	137	0	0	1	-360	360	6.0167	0.0839	-6.0072	-1.0948	0.0000	0.0000	0.0000	0.0000;
	2562	2581	0.040331	0.130413	0.013361	137	137	137	0	0	1	-360	360	20.8496	-7.2216	-20.6732	6.3352	0.0000	0.0000	0.0000	0.0000;
	2623	2501	0.020413	0.066124	0.006781	95	95	95	0	0	1	-360	360	6.5193	-4.6272	-6.5081	3.9157	0.0000	0.0000	0.0000	0.0000;
	2743	1955	0.057868	0.101322	0.00967	90	90	90	0	0	1	-360	360	-50.0000	-12.0000	51.4229	13.4154	0.0000	0.0000	0.0000	0.0000;
	2744	1956	0.057868	0.101322	0.00967	90	90	90	0	0	1	-360	360	-51.0000	-14.0000	52.5147	15.5806	0.0000	0.0000	0.0000	0.0000;
	2740	820	0.02562	0.084711	0.008477	123	123	123	0	0	1	-360	360	40.0000	-3.4032	-39.6643	3.4790	0.0000	0.0000	0.0000	0.0000;
	2740	820	0.02562	0.084711	0.008477	123	123	123	0	0	1	-360	360	40.0000	-3.4032	-39.6643	3.4790	0.0000	0.0000	0.0000	0.0000;
	2745	1430	0.010413	0.033554	0.003543	140	140	140	0	0	1	-360	360	-25.0000	-10.0000	25.0676	9.8217	0.0000	0.0000	0.0000	0.0000;
	2746	1876	0.009752	0.030496	0.003151	140	140	140	0	0	1	-360	360	-68.0000	-26.0000	68.4731	27.1311	0.0000	0.0000	0.0000	0.0000;
	2742	1524	0.005702	0.018264	0.001922	57	57	57	0	0	1	-360	360	-33.0000	-12.0000	33.0623	11.9823	0.0000	0.0000	0.0000	0.0000;
	2741	1525	0.005702	0.018264	0.001922	57	57	57	0	0	1	-360	360	-33.0000	-12.0000	33.0623	11.9823	0.0000	0.0000	0.0000	0.0000;
	5	4	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-65.9074	21.5685	65.9083	-21.5602	0.0000	0.0000	0.0000	0.0000;
	7	6	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	57.1544	8.0037	-57.1538	-7.9978	0.0000	0.0000	0.0000	0.0000;
	9	8	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-48.5174	2.5326	48.5175	-2.5312	0.0000	0.0000	0.0000	0.0000;
	11	10	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-130.3827	-21.5273	130.3858	21.5585	0.0000	0.0000	0.0000	0.0000;
	12	11	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	63.5098	-1.1830	-63.5091	1.1902	0.0000	0.0000	0.0000	0.0000;
	14	13	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	168.6334	120.0324	-168.6308	-120.0069	0.0000	0.0000	0.0000	0.0000;
	16	15	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	18	17	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-15.6648	75.3188	15.6658	-75.3087	0.0000	0.0000	0.0000	0.0000;
	20	19	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	36.6426	-8.4076	-36.6424	8.4100	0.0000	0.0000	0.0000	0.0000;
	22	21	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	29	28	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	274.6957	-46.4703	-274.6913	46.5145	0.0000	0.0000	0.0000	0.0000;
	38	37	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-29.9666	-10.1474	29.9668	10.1492	0.0000	0.0000	0.0000	0.0000;
	41	40	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-35.8068	-44.9299	35.8073	44.9354	0.0000	0.0000	0.0000	0.0000;
	44	43	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	151.7164	-43.0051	-151.7121	43.0477	0.0000	0.0000	0.0000	0.0000;
	46	45	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-56.0612	-34.6372	56.0615	34.6397	0.0000	0.0000	0.0000	0.0000;
	49	48	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-168.0606	-23.2579	168.0623	23.2749	0.0000	0.0000	0.0000	0.0000;
	52	51	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	31.1463	-3.5669	-31.1461	3.5686	0.0000	0.0000	0.0000	0.0000;
	54	53	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-3.6789	42.5224	3.6790	-42.5214	0.0000	0.0000	0.0000	0.0000;
	56	55	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	1.6995	-14.4041	-1.6995	14.4045	0.0000	0.0000	0.0000	0.0000;
	58	57	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-144.3286	-11.0885	144.3298	11.1006	0.0000	0.0000	0.0000	0.0000;
	60	59	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	43.0245	28.8972	-43.0240	-28.8926	0.0000	0.0000	0.0000	0.0000;
	63	62	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-18.7593	-13.3637	18.7594	13.3646	0.0000	0.0000	0.0000	0.0000;
	65	64	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-328.4789	-37.2579	328.4852	37.3211	0.0000	0.0000	0.0000	0.0000;
	73	72	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	155.4415	-9.6084	-155.4374	9.6502	0.0000	0.0000	0.0000	0.0000;
	75	74	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-52.6982	-9.2446	52.6987	9.2494	0.0000	0.0000	0.0000	0.0000;
	77	76	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-121.2896	-6.7015	121.2921	6.7268	0.0000	0.0000	0.0000	0.0000;
	79	78	2.1e-05	0.000207	0	876	876	876	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	81	80	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-33.3135	4.0787	33.3137	-4.0768	0.0000	0.0000	0.0000	0.0000;
	85	84	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-96.3565	-11.2949	96.3581	11.3109	0.0000	0.0000	0.0000	0.0000;
	87	86	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-52.3564	-1.5887	52.3569	1.5934	0.0000	0.0000	0.0000	0.0000;
	89	88	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-68.6532	0.8577	68.6540	-0.8496	0.0000	0.0000	0.0000	0.0000;
	91	90	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	43.5248	-0.5113	-43.5244	0.5145	0.0000	0.0000	0.0000	0.0000;
	93	92	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-8.2760	-0.6245	8.2760	0.6246	0.0000	0.0000	0.0000	0.0000;
	95	94	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.4731	21.7902	-0.4730	-21.7894	0.0000	0.0000	0.0000	0.0000;
	97	96	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	9.0337	0.4196	-9.0336	-0.4195	0.0000	0.0000	0.0000	0.0000;
	99	98	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	40.2579	-6.2935	-40.2576	6.2964	0.0000	0.0000	0.0000	0.0000;
	101	100	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-18.5177	-3.8816	18.5178	3.8822	0.0000	0.0000	0.0000	0.0000;
	103	102	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	118.9831	-40.3423	-118.9804	40.3694	0.0000	0.0000	0.0000	0.0000;
	105	104	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-129.7690	12.7289	129.7719	-12.7001	0.0000	0.0000	0.0000	0.0000;
	107	106	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-30.1720	-55.5120	30.1727	55.5188	0.0000	0.0000	0.0000	0.0000;
	109	108	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-130.3935	31.0248	130.3966	-30.9938	0.0000	0.0000	0.0000	0.0000;
	112	111	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-43.5239	9.6780	43.5242	-9.6746	0.0000	0.0000	0.0000	0.0000;
	114	113	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	46.6883	8.7799	-46.6879	-8.7760	0.0000	0.0000	0.0000	0.0000;
	117	116	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	94.1720	-30.9761	-94.1703	30.9930	0.0000	0.0000	0.0000	0.0000;
	119	118	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-54.8748	-1.4753	54.8753	1.4804	0.0000	0.0000	0.0000	0.0000;
	121	120	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	219.1417	39.1804	-219.1389	-39.1519	0.0000	0.0000	0.0000	0.0000;
	123	122	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	51.5712	52.9725	-51.5709	-52.9694	0.0000	0.0000	0.0000	0.0000;
	126	125	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-86.5283	-18.9325	86.5297	18.9457	0.0000	0.0000	0.0000	0.0000;
	128	127	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-296.2934	28.0862	296.2986	-28.0350	0.0000	0.0000	0.0000	0.0000;
	130	129	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	11.3564	1.4092	-11.3564	-1.4090	0.0000	0.0000	0.0000	0.0000;
	135	134	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-95.6329	-39.5676	95.6347	39.5857	0.0000	0.0000	0.0000	0.0000;
	139	138	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	119.4454	26.3678	-119.4445	-26.3592	0.0000	0.0000	0.0000	0.0000;
	142	141	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	145	144	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	147	146	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-94.3651	10.9700	94.3666	-10.9547	0.0000	0.0000	0.0000	0.0000;
	149	148	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-143.5144	-7.4803	143.5180	7.5166	0.0000	0.0000	0.0000	0.0000;
	151	150	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-178.4199	-7.8776	178.4218	7.8967	0.0000	0.0000	0.0000	0.0000;
	154	153	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	64.7573	9.8776	-64.7565	-9.8700	0.0000	0.0000	0.0000	0.0000;
	157	155	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	159	158	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	61.4508	-46.8658	-61.4504	46.8693	0.0000	0.0000	0.0000	0.0000;
	161	160	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	164	163	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-188.1958	20.7215	188.1978	-20.7011	0.0000	0.0000	0.0000	0.0000;
	166	165	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-168.3703	-48.7720	168.3756	48.8244	0.0000	0.0000	0.0000	0.0000;
	167	165	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-14.3600	-13.6230	14.3601	13.6237	0.0000	0.0000	0.0000	0.0000;
	171	170	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	3.2672	-55.5234	-3.2666	55.5286	0.0000	0.0000	0.0000	0.0000;
	173	172	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	175	174	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	19.0137	4.2290	-19.0136	-4.2283	0.0000	0.0000	0.0000	0.0000;
	178	177	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	51.1102	12.1467	-51.1097	-12.1419	0.0000	0.0000	0.0000	0.0000;
	180	179	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	185	184	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	203.1208	-14.9814	-203.1183	15.0060	0.0000	0.0000	0.0000	0.0000;
	187	186	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-211.5233	56.5518	211.5262	-56.5229	0.0000	0.0000	0.0000	0.0000;
	189	188	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-30.5638	29.8128	30.5642	-29.8095	0.0000	0.0000	0.0000	0.0000;
	191	190	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	23.5807	23.4799	-23.5805	-23.4778	0.0000	0.0000	0.0000	0.0000;
	194	193	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	26.2424	-7.0775	-26.2422	7.0789	0.0000	0.0000	0.0000	0.0000;
	196	195	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	64.1237	-37.1292	-64.1234	37.1325	0.0000	0.0000	0.0000	0.0000;
	198	197	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	65.2491	-25.4980	-65.2482	25.5069	0.0000	0.0000	0.0000	0.0000;
	200	199	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	380.1066	9.9079	-380.0980	-9.8222	0.0000	0.0000	0.0000	0.0000;
	202	201	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	54.3080	-14.8799	-54.3074	14.8858	0.0000	0.0000	0.0000	0.0000;
	204	203	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-132.1079	-24.4255	132.1113	24.4592	0.0000	0.0000	0.0000	0.0000;
	206	205	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	55.1896	-33.4173	-55.1893	33.4198	0.0000	0.0000	0.0000	0.0000;
	208	207	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-31.0518	7.3554	31.0520	-7.3537	0.0000	0.0000	0.0000	0.0000;
	214	213	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	222	221	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	243	242	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	58.6990	5.7767	-58.6967	-5.7537	0.0000	0.0000	0.0000	0.0000;
	249	248	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	258	257	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.2980	-5.2778	25.2985	5.2826	0.0000	0.0000	0.0000	0.0000;
	265	264	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	281	280	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	283	282	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	51.0638	-21.7890	-51.0616	21.8114	0.0000	0.0000	0.0000	0.0000;
	295	294	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	316	315	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.7236	-1.7959	-26.7231	1.8010	0.0000	0.0000	0.0000	0.0000;
	323	322	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	332	331	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	340	339	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	342	341	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.4457	18.5491	10.4460	-18.5459	0.0000	0.0000	0.0000	0.0000;
	352	351	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	359	358	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	97.9824	29.8796	-97.9752	-29.8075	0.0000	0.0000	0.0000	0.0000;
	377	376	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-38.1239	12.9637	38.1250	-12.9520	0.0000	0.0000	0.0000	0.0000;
	383	382	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	391	390	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	404	403	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	419	418	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.4641	-3.7366	17.4643	3.7389	0.0000	0.0000	0.0000	0.0000;
	427	426	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.4331	-0.7834	5.4331	0.7836	0.0000	0.0000	0.0000	0.0000;
	434	433	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	439	438	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-40.5070	-9.6553	40.5082	9.6676	0.0000	0.0000	0.0000	0.0000;
	462	461	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	51.7122	2.6958	-51.7104	-2.6770	0.0000	0.0000	0.0000	0.0000;
	473	472	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	483	482	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	485	484	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	487	486	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	489	488	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.7926	-0.9127	6.7927	0.9130	0.0000	0.0000	0.0000	0.0000;
	494	493	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	42.6155	14.3675	-42.6141	-14.3533	0.0000	0.0000	0.0000	0.0000;
	507	506	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	509	508	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.1931	-3.1075	37.1941	3.1169	0.0000	0.0000	0.0000	0.0000;
	515	514	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.8166	3.9889	-15.8164	-3.9870	0.0000	0.0000	0.0000	0.0000;
	517	516	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	520	519	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	529	528	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	531	530	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	535	534	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	537	536	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	540	539	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-46.2663	6.9007	46.2678	-6.8856	0.0000	0.0000	0.0000	0.0000;
	546	545	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	550	549	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	555	554	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	571	570	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.4475	23.9300	0.4479	-23.9261	0.0000	0.0000	0.0000	0.0000;
	574	573	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	584	583	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.7152	1.8820	9.7153	-1.8814	0.0000	0.0000	0.0000	0.0000;
	590	589	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0693	-4.8507	0.0694	4.8509	0.0000	0.0000	0.0000	0.0000;
	610	609	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	614	613	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.2712	-1.5886	33.2720	1.5964	0.0000	0.0000	0.0000	0.0000;
	661	660	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.9432	-44.4956	19.9448	44.5122	0.0000	0.0000	0.0000	0.0000;
	682	681	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-45.3809	7.4896	45.3823	-7.4751	0.0000	0.0000	0.0000	0.0000;
	693	692	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-31.6916	-21.3070	31.6926	21.3170	0.0000	0.0000	0.0000	0.0000;
	711	710	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.8395	6.8614	-16.8393	-6.8591	0.0000	0.0000	0.0000	0.0000;
	727	726	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.2596	-25.9363	-14.2590	25.9424	0.0000	0.0000	0.0000	0.0000;
	737	736	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.0639	12.4347	29.0646	-12.4276	0.0000	0.0000	0.0000	0.0000;
	755	754	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.9851	2.4610	-16.9849	-2.4589	0.0000	0.0000	0.0000	0.0000;
	765	764	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.8663	-0.8722	9.8664	0.8729	0.0000	0.0000	0.0000	0.0000;
	775	774	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.3055	1.4378	18.3057	-1.4353	0.0000	0.0000	0.0000	0.0000;
	804	803	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	843	842	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.7891	-3.7730	6.7891	3.7734	0.0000	0.0000	0.0000	0.0000;
	846	845	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.0898	-2.7870	-6.0898	2.7873	0.0000	0.0000	0.0000	0.0000;
	848	847	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.8983	0.4966	-14.8981	-0.4950	0.0000	0.0000	0.0000	0.0000;
	849	848	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.8874	0.4867	-11.8873	-0.4856	0.0000	0.0000	0.0000	0.0000;
	851	850	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.7489	-0.6415	24.7494	0.6457	0.0000	0.0000	0.0000	0.0000;
	853	852	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.5814	-0.5112	-0.5814	0.5113	0.0000	0.0000	0.0000	0.0000;
	857	856	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.4457	-0.1177	11.4458	0.1186	0.0000	0.0000	0.0000	0.0000;
	860	859	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.9617	-2.4894	-0.9617	2.4894	0.0000	0.0000	0.0000	0.0000;
	862	861	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	865	864	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.8798	-2.9678	16.8800	2.9699	0.0000	0.0000	0.0000	0.0000;
	867	866	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.8106	1.0289	-13.8105	-1.0275	0.0000	0.0000	0.0000	0.0000;
	869	868	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	872	871	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.8567	-7.1834	11.8568	7.1848	0.0000	0.0000	0.0000	0.0000;
	874	873	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	879	878	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.2329	1.6024	13.2330	-1.6010	0.0000	0.0000	0.0000	0.0000;
	881	880	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.6124	-2.4450	5.6125	2.4453	0.0000	0.0000	0.0000	0.0000;
	887	886	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	35.3787	-5.9405	-35.3778	5.9493	0.0000	0.0000	0.0000	0.0000;
	891	890	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.5253	6.3426	-7.5253	-6.3419	0.0000	0.0000	0.0000	0.0000;
	893	892	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	896	895	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	897	896	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-38.9743	-35.8667	38.9762	35.8861	0.0000	0.0000	0.0000	0.0000;
	895	897	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	899	898	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.3309	-2.7839	1.3309	2.7840	0.0000	0.0000	0.0000	0.0000;
	901	900	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.7219	-4.4457	-1.7219	4.4458	0.0000	0.0000	0.0000	0.0000;
	903	902	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.7060	-1.4263	4.7060	1.4265	0.0000	0.0000	0.0000	0.0000;
	908	907	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	914	913	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.0947	-1.7750	16.0949	1.7768	0.0000	0.0000	0.0000	0.0000;
	916	915	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.0792	-0.5776	7.0793	0.5780	0.0000	0.0000	0.0000	0.0000;
	918	917	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	920	919	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	924	923	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.6116	2.3459	21.6120	-2.3426	0.0000	0.0000	0.0000	0.0000;
	926	925	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	928	927	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.9320	-1.4776	-15.9318	1.4795	0.0000	0.0000	0.0000	0.0000;
	930	929	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.6292	5.2351	-6.6292	-5.2345	0.0000	0.0000	0.0000	0.0000;
	932	931	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.2085	10.6492	-10.2083	-10.6476	0.0000	0.0000	0.0000	0.0000;
	936	935	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.0311	-0.5323	12.0312	0.5334	0.0000	0.0000	0.0000	0.0000;
	938	937	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.3459	4.0234	-26.3454	-4.0185	0.0000	0.0000	0.0000	0.0000;
	940	939	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	943	942	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	945	944	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.4847	3.0234	-21.4844	-3.0201	0.0000	0.0000	0.0000	0.0000;
	951	950	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.8517	7.3046	-11.8516	-7.3032	0.0000	0.0000	0.0000	0.0000;
	953	952	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	50.2264	1.8594	-50.2246	-1.8412	0.0000	0.0000	0.0000	0.0000;
	957	956	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.5058	-1.5270	15.5060	1.5288	0.0000	0.0000	0.0000	0.0000;
	959	958	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.5436	0.0143	2.5436	-0.0143	0.0000	0.0000	0.0000	0.0000;
	961	960	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.3309	0.7731	-12.3308	-0.7721	0.0000	0.0000	0.0000	0.0000;
	963	962	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.1085	1.3139	-19.1082	-1.3113	0.0000	0.0000	0.0000	0.0000;
	965	964	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.9408	4.9570	9.9409	-4.9561	0.0000	0.0000	0.0000	0.0000;
	967	966	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.3747	0.7047	-7.3747	-0.7043	0.0000	0.0000	0.0000	0.0000;
	969	968	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.1427	0.4584	13.1429	-0.4572	0.0000	0.0000	0.0000	0.0000;
	971	970	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.7187	2.4458	-25.7182	-2.4412	0.0000	0.0000	0.0000	0.0000;
	973	972	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	975	974	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.8040	-0.6156	-9.8040	0.6163	0.0000	0.0000	0.0000	0.0000;
	977	976	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	61.3109	12.0167	-61.3082	-11.9901	0.0000	0.0000	0.0000	0.0000;
	979	978	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.0995	3.1258	33.1003	-3.1181	0.0000	0.0000	0.0000	0.0000;
	983	982	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	34.0054	2.6404	-34.0047	-2.6324	0.0000	0.0000	0.0000	0.0000;
	985	984	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.8524	-3.6306	-14.8522	3.6322	0.0000	0.0000	0.0000	0.0000;
	987	986	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	41.0268	0.6240	-41.0256	-0.6122	0.0000	0.0000	0.0000	0.0000;
	991	990	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.2558	-1.8434	28.2563	1.8491	0.0000	0.0000	0.0000	0.0000;
	993	992	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	995	994	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	997	996	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	22.3567	6.0876	-22.3563	-6.0839	0.0000	0.0000	0.0000	0.0000;
	998	999	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1001	1000	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.1399	-2.0163	-20.1396	2.0192	0.0000	0.0000	0.0000	0.0000;
	1003	1002	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.6143	1.6423	23.6147	-1.6385	0.0000	0.0000	0.0000	0.0000;
	1005	1004	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-51.4464	-8.6930	51.4483	8.7115	0.0000	0.0000	0.0000	0.0000;
	1007	1006	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.9705	-3.5972	24.9709	3.6018	0.0000	0.0000	0.0000	0.0000;
	1009	1008	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.5944	-1.0021	-21.5941	1.0056	0.0000	0.0000	0.0000	0.0000;
	1011	1010	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1012	1011	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1010	1012	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1016	1015	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.7420	7.2620	-12.7419	-7.2605	0.0000	0.0000	0.0000	0.0000;
	1022	1021	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.1469	0.8307	-13.1468	-0.8294	0.0000	0.0000	0.0000	0.0000;
	1023	1022	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.5308	0.0752	12.5309	-0.0741	0.0000	0.0000	0.0000	0.0000;
	1033	1032	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.0552	-5.3472	-18.0550	5.3497	0.0000	0.0000	0.0000	0.0000;
	1037	1036	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.3851	2.5054	-7.3850	-2.5050	0.0000	0.0000	0.0000	0.0000;
	1039	1038	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.5202	-0.1997	4.5202	0.1999	0.0000	0.0000	0.0000	0.0000;
	1041	1040	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.2682	0.0958	2.2682	-0.0958	0.0000	0.0000	0.0000	0.0000;
	1043	1042	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1045	1044	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.8148	11.3175	-14.8146	-11.3150	0.0000	0.0000	0.0000	0.0000;
	1047	1046	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	32.1221	5.9431	-32.1213	-5.9356	0.0000	0.0000	0.0000	0.0000;
	1049	1048	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.8331	-2.6948	-4.8330	2.6951	0.0000	0.0000	0.0000	0.0000;
	1055	1054	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.5701	1.0273	10.5702	-1.0265	0.0000	0.0000	0.0000	0.0000;
	1057	1056	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1059	1058	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.6638	-2.0832	4.6639	2.0834	0.0000	0.0000	0.0000	0.0000;
	1062	1061	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.9490	-1.3857	-9.9489	1.3865	0.0000	0.0000	0.0000	0.0000;
	1065	1064	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-42.2034	-0.8691	42.2047	0.8816	0.0000	0.0000	0.0000	0.0000;
	1067	1066	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.6222	4.8846	-15.6220	-4.8827	0.0000	0.0000	0.0000	0.0000;
	1069	1068	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.4341	12.1916	-28.4334	-12.1850	0.0000	0.0000	0.0000	0.0000;
	1071	1070	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.5325	1.8693	24.5329	-1.8649	0.0000	0.0000	0.0000	0.0000;
	1073	1072	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	65.8366	-4.1377	-65.8336	4.1676	0.0000	0.0000	0.0000	0.0000;
	1075	1074	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.4555	-1.0822	-11.4554	1.0831	0.0000	0.0000	0.0000	0.0000;
	1077	1076	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.8074	0.9754	6.8074	-0.9750	0.0000	0.0000	0.0000	0.0000;
	1079	1078	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1083	1082	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-51.4309	4.5818	51.4327	-4.5634	0.0000	0.0000	0.0000	0.0000;
	1085	1084	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.9408	5.1925	12.9409	-5.1910	0.0000	0.0000	0.0000	0.0000;
	1089	1088	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1093	1092	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.8410	-4.6337	-5.8409	4.6341	0.0000	0.0000	0.0000	0.0000;
	1099	1098	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.3140	0.4543	9.3140	-0.4537	0.0000	0.0000	0.0000	0.0000;
	1101	1100	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1105	1104	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.6206	-0.9479	5.6206	0.9482	0.0000	0.0000	0.0000	0.0000;
	1107	1106	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-31.1996	-4.0888	31.2003	4.0956	0.0000	0.0000	0.0000	0.0000;
	1109	1108	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1111	1110	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1112	1111	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1110	1112	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1114	1113	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-52.8679	-0.2367	52.8699	0.2559	0.0000	0.0000	0.0000	0.0000;
	1116	1115	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	58.5043	17.0790	-58.5015	-17.0519	0.0000	0.0000	0.0000	0.0000;
	1122	1121	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1132	1131	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.3395	0.2798	-11.3394	-0.2789	0.0000	0.0000	0.0000	0.0000;
	1134	1133	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.1169	-0.2955	12.1170	0.2965	0.0000	0.0000	0.0000	0.0000;
	1137	1136	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1138	1137	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1143	1142	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4461	2.3556	3.4461	-2.3554	0.0000	0.0000	0.0000	0.0000;
	1144	1143	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.6862	2.8181	-21.6859	-2.8148	0.0000	0.0000	0.0000	0.0000;
	1148	1147	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.6328	10.2952	33.6336	-10.2867	0.0000	0.0000	0.0000	0.0000;
	1150	1149	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.0473	2.0320	-20.0470	-2.0292	0.0000	0.0000	0.0000	0.0000;
	1155	1154	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.7040	-2.9466	-2.7040	2.9468	0.0000	0.0000	0.0000	0.0000;
	1164	1163	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.6662	5.2267	-3.6662	-5.2264	0.0000	0.0000	0.0000	0.0000;
	1166	1165	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1170	1169	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	83.8842	13.3258	-83.8793	-13.2768	0.0000	0.0000	0.0000	0.0000;
	1172	1171	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.5694	0.0759	-0.5694	-0.0759	0.0000	0.0000	0.0000	0.0000;
	1177	1176	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1179	1178	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1181	1180	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.6813	-3.5062	-4.6812	3.5064	0.0000	0.0000	0.0000	0.0000;
	1185	1184	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-60.2256	-7.4374	60.2282	7.4628	0.0000	0.0000	0.0000	0.0000;
	1187	1186	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1194	1193	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.5726	9.7021	-13.5724	-9.7002	0.0000	0.0000	0.0000	0.0000;
	1201	1200	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.5617	0.7836	2.5617	-0.7836	0.0000	0.0000	0.0000	0.0000;
	1204	1203	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.3331	4.4354	28.3337	-4.4297	0.0000	0.0000	0.0000	0.0000;
	1206	1205	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.8952	2.6202	5.8953	-2.6199	0.0000	0.0000	0.0000	0.0000;
	1208	1207	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.6033	0.5771	-7.6033	-0.5767	0.0000	0.0000	0.0000	0.0000;
	1210	1209	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	22.8608	3.2450	-22.8605	-3.2413	0.0000	0.0000	0.0000	0.0000;
	1212	1211	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.2160	-0.6115	-5.2160	0.6117	0.0000	0.0000	0.0000	0.0000;
	1214	1213	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.9089	-3.6189	-8.9088	3.6196	0.0000	0.0000	0.0000	0.0000;
	1218	1217	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1220	1219	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.1608	4.8184	19.1611	-4.8156	0.0000	0.0000	0.0000	0.0000;
	1222	1221	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1224	1223	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.2067	-4.0286	14.2068	4.0301	0.0000	0.0000	0.0000	0.0000;
	1230	1229	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.4873	0.0169	18.4875	-0.0146	0.0000	0.0000	0.0000	0.0000;
	1232	1231	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1234	1233	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.0026	0.5737	11.0027	-0.5728	0.0000	0.0000	0.0000	0.0000;
	1236	1235	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	29.3548	9.8106	-29.3541	-9.8039	0.0000	0.0000	0.0000	0.0000;
	1240	1239	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.9043	1.4275	21.9047	-1.4241	0.0000	0.0000	0.0000	0.0000;
	1242	1241	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.0749	-1.6660	-18.0747	1.6682	0.0000	0.0000	0.0000	0.0000;
	1244	1243	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-36.5916	3.1298	36.5926	-3.1197	0.0000	0.0000	0.0000	0.0000;
	1246	1245	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1248	1247	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.3717	8.3011	-2.3716	-8.3006	0.0000	0.0000	0.0000	0.0000;
	1254	1253	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1256	1255	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.4590	0.9723	-6.4590	-0.9720	0.0000	0.0000	0.0000	0.0000;
	1258	1257	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.0555	0.2002	-8.0554	-0.1998	0.0000	0.0000	0.0000	0.0000;
	1262	1261	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.8114	8.2150	-27.8109	-8.2093	0.0000	0.0000	0.0000	0.0000;
	1264	1263	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.1244	4.2960	-7.1243	-4.2955	0.0000	0.0000	0.0000	0.0000;
	1266	1265	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.5347	14.8942	19.5352	-14.8900	0.0000	0.0000	0.0000	0.0000;
	1268	1267	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1269	1268	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1276	1275	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	68.5403	11.8409	-68.5370	-11.8076	0.0000	0.0000	0.0000	0.0000;
	1278	1277	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.8971	-1.3781	-19.8968	1.3809	0.0000	0.0000	0.0000	0.0000;
	1282	1281	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.4363	0.7884	0.4363	-0.7884	0.0000	0.0000	0.0000	0.0000;
	1285	1284	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1287	1286	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1289	1288	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.2249	-3.9350	-2.2249	3.9351	0.0000	0.0000	0.0000	0.0000;
	1291	1290	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.8923	-4.9268	-9.8922	4.9277	0.0000	0.0000	0.0000	0.0000;
	1293	1292	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.1633	2.1754	18.1636	-2.1730	0.0000	0.0000	0.0000	0.0000;
	1295	1294	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.7527	0.5397	-3.7526	-0.5396	0.0000	0.0000	0.0000	0.0000;
	1297	1296	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.3109	0.8652	-3.3109	-0.8651	0.0000	0.0000	0.0000	0.0000;
	1299	1298	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.0497	7.6730	10.0498	-7.6718	0.0000	0.0000	0.0000	0.0000;
	1301	1300	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.9116	-0.0283	3.9116	0.0284	0.0000	0.0000	0.0000	0.0000;
	1303	1302	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.0641	-1.9922	-3.0641	1.9923	0.0000	0.0000	0.0000	0.0000;
	1305	1304	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.2016	-0.5493	-4.2016	0.5494	0.0000	0.0000	0.0000	0.0000;
	1307	1306	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.0044	0.3072	19.0047	-0.3047	0.0000	0.0000	0.0000	0.0000;
	1311	1310	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.7216	0.1370	2.7216	-0.1369	0.0000	0.0000	0.0000	0.0000;
	1313	1312	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-40.2304	3.2972	40.2315	-3.2856	0.0000	0.0000	0.0000	0.0000;
	1315	1314	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.7742	2.0330	-9.7741	-2.0323	0.0000	0.0000	0.0000	0.0000;
	1319	1318	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1323	1322	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.7161	-1.2139	12.7162	1.2150	0.0000	0.0000	0.0000	0.0000;
	1329	1328	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	40.4043	-2.5462	-40.4031	2.5579	0.0000	0.0000	0.0000	0.0000;
	1331	1330	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.3478	-0.2063	-15.3476	0.2080	0.0000	0.0000	0.0000	0.0000;
	1333	1332	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.3786	-2.3688	-20.3783	2.3718	0.0000	0.0000	0.0000	0.0000;
	1335	1334	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.4986	-0.3673	8.4986	0.3678	0.0000	0.0000	0.0000	0.0000;
	1337	1336	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.1712	0.0787	5.1713	-0.0785	0.0000	0.0000	0.0000	0.0000;
	1342	1341	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.0350	-2.5813	-6.0350	2.5816	0.0000	0.0000	0.0000	0.0000;
	1344	1343	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1347	1346	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1349	1348	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.1777	-5.2837	18.1780	5.2864	0.0000	0.0000	0.0000	0.0000;
	1351	1350	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1352	1351	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1350	1352	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1354	1353	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.0432	-3.6036	-8.0431	3.6042	0.0000	0.0000	0.0000	0.0000;
	1356	1355	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1360	1359	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.1368	2.3936	6.1368	-2.3933	0.0000	0.0000	0.0000	0.0000;
	1362	1361	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1364	1363	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.0842	1.0079	-12.0841	-1.0068	0.0000	0.0000	0.0000	0.0000;
	1366	1365	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.0746	10.1692	16.0748	-10.1667	0.0000	0.0000	0.0000	0.0000;
	1368	1367	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.2437	1.2888	5.2437	-1.2886	0.0000	0.0000	0.0000	0.0000;
	1374	1373	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.3105	-5.4153	9.3106	5.4161	0.0000	0.0000	0.0000	0.0000;
	1375	1374	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1373	1375	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1377	1376	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.6759	-2.9022	22.6762	2.9057	0.0000	0.0000	0.0000	0.0000;
	1379	1378	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.4787	-6.8145	27.4793	6.8201	0.0000	0.0000	0.0000	0.0000;
	1381	1380	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.8339	-4.2576	28.8344	4.2634	0.0000	0.0000	0.0000	0.0000;
	1383	1382	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.5487	0.6954	-0.5487	-0.6954	0.0000	0.0000	0.0000	0.0000;
	1385	1384	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1387	1386	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.5287	1.9633	-28.5282	-1.9575	0.0000	0.0000	0.0000	0.0000;
	1389	1388	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-65.0662	-8.5585	65.0692	8.5882	0.0000	0.0000	0.0000	0.0000;
	1391	1390	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.3133	-1.6704	17.3135	1.6726	0.0000	0.0000	0.0000	0.0000;
	1393	1392	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1397	1396	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.0013	3.4580	-4.0013	-3.4578	0.0000	0.0000	0.0000	0.0000;
	1404	1403	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.5427	2.6169	-15.5426	-2.6151	0.0000	0.0000	0.0000	0.0000;
	1410	1409	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.4163	4.2587	34.4171	-4.2502	0.0000	0.0000	0.0000	0.0000;
	1412	1411	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.4555	14.4869	-28.4547	-14.4797	0.0000	0.0000	0.0000	0.0000;
	1414	1413	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1416	1415	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1418	1417	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.8224	-1.7663	-4.8224	1.7664	0.0000	0.0000	0.0000	0.0000;
	1420	1419	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.4501	-0.1991	-2.4501	0.1992	0.0000	0.0000	0.0000	0.0000;
	1422	1421	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.2372	2.7650	-12.2371	-2.7639	0.0000	0.0000	0.0000	0.0000;
	1424	1423	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.9049	8.4260	-24.9044	-8.4212	0.0000	0.0000	0.0000	0.0000;
	1428	1427	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.6068	7.5098	-24.6063	-7.5050	0.0000	0.0000	0.0000	0.0000;
	1430	1429	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-80.6023	-26.6092	80.6076	26.6622	0.0000	0.0000	0.0000	0.0000;
	1434	1433	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1439	1438	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-35.6442	-2.2976	35.6451	2.3068	0.0000	0.0000	0.0000	0.0000;
	1441	1440	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-56.8364	-15.7024	56.8388	15.7262	0.0000	0.0000	0.0000	0.0000;
	1445	1444	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1449	1448	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.2120	0.3890	5.2120	-0.3888	0.0000	0.0000	0.0000	0.0000;
	1451	1450	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.3143	0.7663	-0.3143	-0.7662	0.0000	0.0000	0.0000	0.0000;
	1453	1452	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.5315	-1.3315	7.5315	1.3319	0.0000	0.0000	0.0000	0.0000;
	1455	1454	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.0926	5.8991	24.0931	-5.8948	0.0000	0.0000	0.0000	0.0000;
	1457	1456	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.7933	-0.5784	-7.7933	0.5789	0.0000	0.0000	0.0000	0.0000;
	1459	1458	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.3974	-5.6778	8.3974	5.6785	0.0000	0.0000	0.0000	0.0000;
	1461	1460	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.6471	-1.2281	3.6471	1.2282	0.0000	0.0000	0.0000	0.0000;
	1463	1462	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.1061	0.0629	11.1062	-0.0620	0.0000	0.0000	0.0000	0.0000;
	1465	1464	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.6860	-0.4802	-19.6857	0.4831	0.0000	0.0000	0.0000	0.0000;
	1469	1468	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1473	1472	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.6202	-7.9720	18.6204	7.9748	0.0000	0.0000	0.0000	0.0000;
	1475	1474	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.8978	10.7776	4.8979	-10.7765	0.0000	0.0000	0.0000	0.0000;
	1477	1476	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	40.8111	3.7177	-40.8099	-3.7060	0.0000	0.0000	0.0000	0.0000;
	1479	1478	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.8534	-2.8920	20.8537	2.8950	0.0000	0.0000	0.0000	0.0000;
	1481	1480	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1483	1482	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-48.3651	-3.1588	48.3667	3.1752	0.0000	0.0000	0.0000	0.0000;
	1485	1484	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.3390	-1.9551	-11.3389	1.9560	0.0000	0.0000	0.0000	0.0000;
	1487	1486	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1489	1488	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.1957	-0.8303	-18.1955	0.8327	0.0000	0.0000	0.0000	0.0000;
	1491	1490	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1494	1493	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.6510	-1.6619	-4.6510	1.6621	0.0000	0.0000	0.0000	0.0000;
	1496	1495	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.8909	8.0837	-26.8904	-8.0783	0.0000	0.0000	0.0000	0.0000;
	1498	1497	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	33.4407	5.9285	-33.4398	-5.9202	0.0000	0.0000	0.0000	0.0000;
	1500	1499	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.2141	2.5303	-9.2140	-2.5296	0.0000	0.0000	0.0000	0.0000;
	1502	1501	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1504	1503	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	46.3471	-0.8613	-46.3455	0.8765	0.0000	0.0000	0.0000	0.0000;
	1506	1505	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1511	1510	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.2283	8.9029	-2.2283	-8.9023	0.0000	0.0000	0.0000	0.0000;
	1513	1512	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1519	1518	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	35.5432	-7.6151	-35.5423	7.6242	0.0000	0.0000	0.0000	0.0000;
	1521	1520	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.0110	0.0000	2.0110	0.0000	0.0000	0.0000	0.0000	0.0000;
	1523	1522	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.5220	0.8397	-15.5218	-0.8380	0.0000	0.0000	0.0000	0.0000;
	1525	1524	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.2820	5.8747	-14.2818	-5.8730	0.0000	0.0000	0.0000	0.0000;
	1527	1526	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.5673	1.9977	-21.5670	-1.9945	0.0000	0.0000	0.0000	0.0000;
	1529	1528	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0866	0.7577	0.0866	-0.7577	0.0000	0.0000	0.0000	0.0000;
	1537	1536	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.9794	-0.5259	2.9794	0.5260	0.0000	0.0000	0.0000	0.0000;
	1539	1538	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1543	1542	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.8064	4.9721	37.8074	-4.9617	0.0000	0.0000	0.0000	0.0000;
	1545	1544	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.4061	0.9303	13.4062	-0.9291	0.0000	0.0000	0.0000	0.0000;
	1547	1546	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1549	1548	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.7588	5.0896	0.7588	-5.0894	0.0000	0.0000	0.0000	0.0000;
	1551	1550	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.5757	9.4757	-19.5754	-9.4724	0.0000	0.0000	0.0000	0.0000;
	1557	1556	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0832	0.0205	0.0832	-0.0205	0.0000	0.0000	0.0000	0.0000;
	1559	1558	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.2332	6.1079	34.2340	-6.0995	0.0000	0.0000	0.0000	0.0000;
	1561	1560	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.1668	0.8011	34.1676	-0.7928	0.0000	0.0000	0.0000	0.0000;
	1565	1564	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.5332	10.9752	3.5333	-10.9743	0.0000	0.0000	0.0000	0.0000;
	1567	1566	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1571	1570	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.6896	-10.3744	-8.6895	10.3756	0.0000	0.0000	0.0000	0.0000;
	1573	1572	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-43.5311	-9.6335	43.5325	9.6477	0.0000	0.0000	0.0000	0.0000;
	1575	1574	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1577	1576	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.9707	5.4149	-25.9702	-5.4101	0.0000	0.0000	0.0000	0.0000;
	1579	1578	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.1263	-0.8589	-14.1261	0.8603	0.0000	0.0000	0.0000	0.0000;
	1581	1580	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.1361	1.7243	5.1361	-1.7241	0.0000	0.0000	0.0000	0.0000;
	1583	1582	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.3639	-4.9326	37.3649	4.9424	0.0000	0.0000	0.0000	0.0000;
	1585	1584	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.3342	4.6510	15.3344	-4.6491	0.0000	0.0000	0.0000	0.0000;
	1587	1586	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.0456	3.1354	-3.0456	-3.1353	0.0000	0.0000	0.0000	0.0000;
	1589	1588	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.3036	1.1912	-17.3034	-1.1891	0.0000	0.0000	0.0000	0.0000;
	1591	1590	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-56.7984	-2.0008	56.8007	2.0235	0.0000	0.0000	0.0000	0.0000;
	1593	1592	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-45.0462	4.5444	45.0476	-4.5303	0.0000	0.0000	0.0000	0.0000;
	1595	1594	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	45.5120	-1.7667	-45.5105	1.7820	0.0000	0.0000	0.0000	0.0000;
	1597	1596	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	37.9748	1.3684	-37.9738	-1.3583	0.0000	0.0000	0.0000	0.0000;
	1601	1600	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.1871	3.1052	2.1871	-3.1051	0.0000	0.0000	0.0000	0.0000;
	1605	1604	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.9295	-4.9783	-12.9294	4.9797	0.0000	0.0000	0.0000	0.0000;
	1607	1606	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.9413	2.7858	17.9416	-2.7834	0.0000	0.0000	0.0000	0.0000;
	1609	1608	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.7308	3.8399	26.7313	-3.8347	0.0000	0.0000	0.0000	0.0000;
	1611	1610	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.9134	-2.1253	7.9134	2.1258	0.0000	0.0000	0.0000	0.0000;
	1615	1614	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.5653	-1.3625	-27.5647	1.3678	0.0000	0.0000	0.0000	0.0000;
	1617	1616	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.7107	-0.7162	19.7110	0.7189	0.0000	0.0000	0.0000	0.0000;
	1621	1620	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.1328	2.8627	1.1328	-2.8626	0.0000	0.0000	0.0000	0.0000;
	1623	1622	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	60.0667	12.9745	-60.0641	-12.9485	0.0000	0.0000	0.0000	0.0000;
	1627	1626	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.6410	-0.1838	7.6410	0.1842	0.0000	0.0000	0.0000	0.0000;
	1629	1628	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	40.9178	13.4351	-40.9165	-13.4222	0.0000	0.0000	0.0000	0.0000;
	1631	1630	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.3448	5.2939	-27.3443	-5.2885	0.0000	0.0000	0.0000	0.0000;
	1633	1632	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.6772	-9.7272	25.6777	9.7325	0.0000	0.0000	0.0000	0.0000;
	1634	1633	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1632	1634	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1636	1635	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.3226	0.8395	16.3227	-0.8377	0.0000	0.0000	0.0000	0.0000;
	1638	1637	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.7936	-4.0978	3.7936	4.0980	0.0000	0.0000	0.0000	0.0000;
	1640	1639	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.6394	0.3156	-7.6394	-0.3152	0.0000	0.0000	0.0000	0.0000;
	1644	1643	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1648	1647	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.2417	-0.7450	-12.2416	0.7461	0.0000	0.0000	0.0000	0.0000;
	1650	1649	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1653	1652	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.6866	4.8085	-17.6863	-4.8061	0.0000	0.0000	0.0000	0.0000;
	1657	1656	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.2585	2.5741	-15.2583	-2.5724	0.0000	0.0000	0.0000	0.0000;
	1663	1662	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.8861	0.1112	-8.8860	-0.1107	0.0000	0.0000	0.0000	0.0000;
	1666	1665	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.6278	-1.4242	10.6279	1.4251	0.0000	0.0000	0.0000	0.0000;
	1668	1667	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.2748	6.8825	-16.2746	-6.8803	0.0000	0.0000	0.0000	0.0000;
	1672	1671	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.2979	1.4115	0.2979	-1.4115	0.0000	0.0000	0.0000	0.0000;
	1674	1673	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	39.6997	5.2572	-39.6986	-5.2462	0.0000	0.0000	0.0000	0.0000;
	1676	1675	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1677	1676	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1675	1677	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1679	1678	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.1501	2.8972	-20.1498	-2.8944	0.0000	0.0000	0.0000	0.0000;
	1681	1680	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-40.0125	6.7878	40.0136	-6.7766	0.0000	0.0000	0.0000	0.0000;
	1683	1682	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.8358	3.1214	4.8358	-3.1212	0.0000	0.0000	0.0000	0.0000;
	1686	1685	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-32.8885	-2.2174	32.8892	2.2248	0.0000	0.0000	0.0000	0.0000;
	1688	1687	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1690	1689	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.8826	-0.3121	-0.8826	0.3121	0.0000	0.0000	0.0000	0.0000;
	1692	1691	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.7479	-3.6176	-27.7473	3.6231	0.0000	0.0000	0.0000	0.0000;
	1694	1693	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1698	1697	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.6396	-7.2419	19.6400	7.2450	0.0000	0.0000	0.0000	0.0000;
	1700	1699	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	57.9677	0.7611	-57.9653	-0.7377	0.0000	0.0000	0.0000	0.0000;
	1702	1701	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1706	1705	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1709	1708	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.0380	-1.6761	10.0380	1.6769	0.0000	0.0000	0.0000	0.0000;
	1711	1710	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	30.5910	1.4360	-30.5903	-1.4295	0.0000	0.0000	0.0000	0.0000;
	1713	1712	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1717	1716	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.3528	1.7530	34.3536	-1.7448	0.0000	0.0000	0.0000	0.0000;
	1719	1718	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.5646	-10.1263	2.5647	10.1270	0.0000	0.0000	0.0000	0.0000;
	1721	1720	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.6230	0.6065	-8.6229	-0.6060	0.0000	0.0000	0.0000	0.0000;
	1723	1722	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.3557	2.2591	11.3558	-2.2581	0.0000	0.0000	0.0000	0.0000;
	1729	1728	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.3170	-0.1021	2.3170	0.1021	0.0000	0.0000	0.0000	0.0000;
	1731	1730	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.5250	-0.7849	15.5251	0.7866	0.0000	0.0000	0.0000	0.0000;
	1733	1732	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	29.5658	-2.4983	-29.5652	2.5045	0.0000	0.0000	0.0000	0.0000;
	1735	1734	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1738	1737	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.3254	-0.3465	1.3254	0.3465	0.0000	0.0000	0.0000	0.0000;
	1740	1739	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1742	1741	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0851	5.1871	-0.0851	-5.1869	0.0000	0.0000	0.0000	0.0000;
	1748	1747	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.3240	-0.9443	12.3241	0.9454	0.0000	0.0000	0.0000	0.0000;
	1750	1749	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-35.3708	2.9295	35.3717	-2.9205	0.0000	0.0000	0.0000	0.0000;
	1752	1751	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.1143	0.6319	-15.1141	-0.6302	0.0000	0.0000	0.0000	0.0000;
	1754	1753	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	22.0220	-1.3103	-22.0217	1.3137	0.0000	0.0000	0.0000	0.0000;
	1756	1755	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.2140	2.6079	-24.2135	-2.6036	0.0000	0.0000	0.0000	0.0000;
	1758	1757	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-75.2415	-3.8498	75.2454	3.8890	0.0000	0.0000	0.0000	0.0000;
	1760	1759	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-42.6113	-15.1579	42.6127	15.1720	0.0000	0.0000	0.0000	0.0000;
	1764	1763	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.1134	4.3732	1.1134	-4.3731	0.0000	0.0000	0.0000	0.0000;
	1766	1765	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.2739	-4.9776	33.2747	4.9858	0.0000	0.0000	0.0000	0.0000;
	1768	1767	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1770	1769	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.7340	4.1659	19.7342	-4.1630	0.0000	0.0000	0.0000	0.0000;
	1772	1771	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.2798	-0.5212	-6.2797	0.5214	0.0000	0.0000	0.0000	0.0000;
	1774	1773	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.0015	2.8378	-10.0015	-2.8370	0.0000	0.0000	0.0000	0.0000;
	1776	1775	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	35.4110	0.1772	-35.4102	-0.1686	0.0000	0.0000	0.0000	0.0000;
	1778	1777	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.8487	-6.7765	2.8487	6.7769	0.0000	0.0000	0.0000	0.0000;
	1780	1779	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.4304	9.2388	-36.4294	-9.2290	0.0000	0.0000	0.0000	0.0000;
	1782	1781	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.9985	2.9656	-9.9984	-2.9649	0.0000	0.0000	0.0000	0.0000;
	1786	1785	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.1798	3.4424	-8.1797	-3.4419	0.0000	0.0000	0.0000	0.0000;
	1792	1791	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.9523	7.8873	12.9525	-7.8856	0.0000	0.0000	0.0000	0.0000;
	1794	1793	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.9846	0.7768	-6.9846	-0.7765	0.0000	0.0000	0.0000	0.0000;
	1796	1795	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.9677	-29.5940	37.9694	29.6110	0.0000	0.0000	0.0000	0.0000;
	1797	1798	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1800	1799	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-36.5197	-15.6117	36.5208	15.6228	0.0000	0.0000	0.0000	0.0000;
	1802	1801	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.2652	-2.7351	27.2657	2.7403	0.0000	0.0000	0.0000	0.0000;
	1807	1806	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.0550	-2.2593	14.0551	2.2607	0.0000	0.0000	0.0000	0.0000;
	1809	1808	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1811	1810	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.8345	2.4727	-20.8342	-2.4695	0.0000	0.0000	0.0000	0.0000;
	1813	1812	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1815	1814	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-57.5443	-12.9669	57.5467	12.9915	0.0000	0.0000	0.0000	0.0000;
	1817	1816	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.0246	-10.8108	18.0249	10.8140	0.0000	0.0000	0.0000	0.0000;
	1823	1822	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1825	1824	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.7869	3.9384	-6.7869	-3.9379	0.0000	0.0000	0.0000	0.0000;
	1827	1826	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.1466	6.4824	16.1468	-6.4803	0.0000	0.0000	0.0000	0.0000;
	1829	1828	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-54.6176	4.5995	54.6197	-4.5781	0.0000	0.0000	0.0000	0.0000;
	1831	1830	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.5379	-11.3071	-8.5378	11.3086	0.0000	0.0000	0.0000	0.0000;
	1833	1832	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1836	1835	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.3160	0.8829	-2.3160	-0.8829	0.0000	0.0000	0.0000	0.0000;
	1838	1837	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.3176	13.9725	2.3177	-13.9711	0.0000	0.0000	0.0000	0.0000;
	1840	1839	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.8702	-5.1671	3.8702	5.1674	0.0000	0.0000	0.0000	0.0000;
	1842	1841	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1843	1842	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1841	1843	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1845	1844	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.2213	6.6666	-21.2210	-6.6632	0.0000	0.0000	0.0000	0.0000;
	1849	1848	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.4623	0.5110	33.4631	-0.5028	0.0000	0.0000	0.0000	0.0000;
	1851	1850	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.7115	-0.8733	-0.7115	0.8733	0.0000	0.0000	0.0000	0.0000;
	1853	1852	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.4862	-0.6551	21.4865	0.6582	0.0000	0.0000	0.0000	0.0000;
	1855	1854	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.9916	-0.0481	17.9919	0.0504	0.0000	0.0000	0.0000	0.0000;
	1857	1856	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.2716	0.0009	18.2718	0.0014	0.0000	0.0000	0.0000	0.0000;
	1859	1858	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	23.4115	1.9510	-23.4112	-1.9470	0.0000	0.0000	0.0000	0.0000;
	1864	1863	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1866	1865	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.1609	1.3531	0.1609	-1.3531	0.0000	0.0000	0.0000	0.0000;
	1868	1867	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	22.6356	3.6607	-22.6352	-3.6568	0.0000	0.0000	0.0000	0.0000;
	1870	1869	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.7131	-7.8329	29.7138	7.8394	0.0000	0.0000	0.0000	0.0000;
	1872	1871	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1878	1877	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1884	1883	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.7334	-1.0531	-25.7329	1.0577	0.0000	0.0000	0.0000	0.0000;
	1886	1885	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-63.9647	-0.8030	63.9675	0.8310	0.0000	0.0000	0.0000	0.0000;
	1888	1887	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.4927	5.1431	-1.4926	-5.1429	0.0000	0.0000	0.0000	0.0000;
	1890	1889	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	22.8855	0.1526	-22.8851	-0.1489	0.0000	0.0000	0.0000	0.0000;
	1892	1891	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.8577	-2.4781	-1.8577	2.4782	0.0000	0.0000	0.0000	0.0000;
	1894	1893	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1896	1895	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-32.9424	-13.6481	32.9432	13.6569	0.0000	0.0000	0.0000	0.0000;
	1898	1897	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.8535	1.3915	8.8536	-1.3909	0.0000	0.0000	0.0000	0.0000;
	1900	1899	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.2234	8.4608	7.2235	-8.4599	0.0000	0.0000	0.0000	0.0000;
	1902	1901	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.6301	4.5431	-8.6300	-4.5425	0.0000	0.0000	0.0000	0.0000;
	1906	1905	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.7359	-9.0001	29.7366	9.0070	0.0000	0.0000	0.0000	0.0000;
	1908	1907	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.8316	-1.0295	-21.8313	1.0330	0.0000	0.0000	0.0000	0.0000;
	1910	1909	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.4449	0.1481	-11.4448	-0.1472	0.0000	0.0000	0.0000	0.0000;
	1912	1911	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0966	-0.9259	0.0966	0.9259	0.0000	0.0000	0.0000	0.0000;
	1916	1915	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1919	1918	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	33.9282	0.7765	-33.9274	-0.7684	0.0000	0.0000	0.0000	0.0000;
	1921	1920	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.0766	0.8264	-7.0766	-0.8261	0.0000	0.0000	0.0000	0.0000;
	1923	1922	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.1093	-1.5329	-18.1091	1.5352	0.0000	0.0000	0.0000	0.0000;
	1927	1926	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	40.1589	8.3652	-40.1578	-8.3535	0.0000	0.0000	0.0000	0.0000;
	1929	1928	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.0884	-2.8992	25.0889	2.9036	0.0000	0.0000	0.0000	0.0000;
	1931	1930	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1933	1932	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1942	1941	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0590	0.0000	0.0590	0.0000	0.0000	0.0000	0.0000;
	1947	1946	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.1534	3.4829	26.1539	-3.4779	0.0000	0.0000	0.0000	0.0000;
	1950	1949	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.5628	0.2922	14.5630	-0.2907	0.0000	0.0000	0.0000	0.0000;
	1953	1952	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.6860	-0.4240	3.6860	0.4241	0.0000	0.0000	0.0000	0.0000;
	1956	1955	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1963	1962	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1968	1967	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0450	0.0000	0.0450	0.0000	0.0000	0.0000	0.0000;
	1970	1969	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1980	1979	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1982	1981	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1988	1987	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.2817	-3.9612	30.2824	3.9679	0.0000	0.0000	0.0000	0.0000;
	1997	1996	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1999	1998	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.7180	0.2910	2.7180	-0.2909	0.0000	0.0000	0.0000	0.0000;
	2003	2002	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2005	2004	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2007	2006	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2011	2010	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2014	2013	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.1583	-22.0977	23.1591	22.1053	0.0000	0.0000	0.0000	0.0000;
	2017	2016	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.8305	0.9731	30.8312	-0.9663	0.0000	0.0000	0.0000	0.0000;
	2020	2019	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2023	2022	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.9312	1.3240	-12.9311	-1.3227	0.0000	0.0000	0.0000	0.0000;
	2029	2028	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0260	0.0000	0.0260	0.0000	0.0000	0.0000	0.0000;
	2038	2037	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-41.2976	6.0856	41.2988	-6.0729	0.0000	0.0000	0.0000	0.0000;
	2043	2042	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2047	2046	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-82.0920	-30.4290	82.0972	30.4807	0.0000	0.0000	0.0000	0.0000;
	2049	2048	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2052	2051	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.1170	-0.0650	2.1170	0.0650	0.0000	0.0000	0.0000	0.0000;
	2065	2064	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2069	2068	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2074	2073	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2076	2075	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.6067	-1.7066	2.6067	1.7066	0.0000	0.0000	0.0000	0.0000;
	2079	2078	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2082	2081	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2096	2095	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2107	2106	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.0060	2.5655	-9.0059	-2.5648	0.0000	0.0000	0.0000	0.0000;
	2111	2110	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.9364	1.8626	-8.9363	-1.8620	0.0000	0.0000	0.0000	0.0000;
	2113	2112	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2116	2115	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2118	2117	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.4393	11.5014	27.4400	-11.4948	0.0000	0.0000	0.0000	0.0000;
	2125	2124	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.4723	13.2572	25.4730	-13.2510	0.0000	0.0000	0.0000	0.0000;
	2127	2126	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2133	2132	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.2300	0.0180	3.2300	-0.0179	0.0000	0.0000	0.0000	0.0000;
	2135	2134	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2137	2136	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2140	2139	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.0710	-0.3630	5.0710	0.3632	0.0000	0.0000	0.0000	0.0000;
	2143	2142	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2149	2148	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0260	0.0000	0.0260	0.0000	0.0000	0.0000	0.0000;
	2151	2150	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.6160	-1.7520	24.6165	1.7565	0.0000	0.0000	0.0000	0.0000;
	2153	2152	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2159	2158	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2163	2162	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2176	2175	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2182	2181	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2188	2187	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2202	2201	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.6880	-0.4050	3.6880	0.4051	0.0000	0.0000	0.0000	0.0000;
	2211	2210	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2214	2213	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-55.7175	3.0832	55.7197	-3.0611	0.0000	0.0000	0.0000	0.0000;
	2217	2216	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2219	2218	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2221	2220	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.7442	-1.0897	0.7442	1.0897	0.0000	0.0000	0.0000	0.0000;
	2223	2222	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2226	2225	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.3180	-0.0900	3.3180	0.0901	0.0000	0.0000	0.0000	0.0000;
	2229	2228	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.6824	0.5264	28.6830	-0.5206	0.0000	0.0000	0.0000	0.0000;
	2234	2233	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0630	0.0000	0.0630	0.0000	0.0000	0.0000	0.0000;
	2238	2237	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2240	2239	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2242	2241	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2251	2250	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2256	2255	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2258	2257	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.2350	-2.2509	29.2357	2.2573	0.0000	0.0000	0.0000	0.0000;
	2262	2261	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2265	2264	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2267	2266	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2278	2277	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	45.8835	-16.2878	-45.8817	16.3054	0.0000	0.0000	0.0000	0.0000;
	2282	2281	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2285	2284	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2293	2292	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.3558	4.2522	24.3563	-4.2478	0.0000	0.0000	0.0000	0.0000;
	2295	2294	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0340	0.0000	0.0340	0.0000	0.0000	0.0000	0.0000;
	2298	2297	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2311	2310	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2318	2317	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2320	2319	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0440	0.0000	0.0440	0.0000	0.0000	0.0000	0.0000;
	2326	2325	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2348	2347	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.5361	0.6053	-2.5361	-0.6053	0.0000	0.0000	0.0000	0.0000;
	2350	2349	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.3038	-10.7017	27.3044	10.7078	0.0000	0.0000	0.0000	0.0000;
	2354	2353	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.4380	-1.2830	5.4380	1.2832	0.0000	0.0000	0.0000	0.0000;
	2357	2356	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.0498	24.5856	-5.0494	-24.5814	0.0000	0.0000	0.0000	0.0000;
	2361	2360	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2365	2364	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2367	2366	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2370	2369	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2373	2372	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.7270	0.2730	0.7270	-0.2730	0.0000	0.0000	0.0000	0.0000;
	2375	2374	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2377	2376	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.9353	2.4899	-14.9352	-2.4883	0.0000	0.0000	0.0000	0.0000;
	2380	2379	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2382	2381	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2385	2384	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2391	2390	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2393	2392	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2396	2395	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2429	2428	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0260	0.0000	0.0260	0.0000	0.0000	0.0000	0.0000;
	2431	2430	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.9476	3.9397	21.9479	-3.9362	0.0000	0.0000	0.0000	0.0000;
	2448	2447	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2450	2449	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2452	2451	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2459	2458	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.4626	1.2996	-6.4626	-1.2993	0.0000	0.0000	0.0000	0.0000;
	2462	2461	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.0181	0.2911	7.0181	-0.2908	0.0000	0.0000	0.0000	0.0000;
	2474	2473	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.1676	26.2775	5.1681	-26.2725	0.0000	0.0000	0.0000	0.0000;
	2479	2478	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.2790	2.8842	12.2791	-2.8830	0.0000	0.0000	0.0000	0.0000;
	2498	2497	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-35.8903	-0.0107	35.8911	0.0193	0.0000	0.0000	0.0000	0.0000;
	2500	2499	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.4602	-10.6175	-2.4601	10.6184	0.0000	0.0000	0.0000	0.0000;
	2507	2506	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2509	2508	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2511	2510	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2514	2513	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.7163	2.4869	-5.7163	-2.4866	0.0000	0.0000	0.0000	0.0000;
	2528	2527	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.5240	42.0177	-24.5223	-42.0008	0.0000	0.0000	0.0000	0.0000;
	2529	2528	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	35.6951	-38.5811	-35.6932	38.6009	0.0000	0.0000	0.0000	0.0000;
	2536	2535	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.6782	1.5773	-24.6777	-1.5730	0.0000	0.0000	0.0000	0.0000;
	2542	2541	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.1250	0.2000	-1.1250	-0.2000	0.0000	0.0000	0.0000	0.0000;
	2580	2579	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.4864	1.5758	23.4868	-1.5717	0.0000	0.0000	0.0000	0.0000;
	2596	2595	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2601	2600	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-38.2859	24.3614	38.2874	-24.3463	0.0000	0.0000	0.0000	0.0000;
	2604	2603	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.0262	35.4216	4.0272	-35.4124	0.0000	0.0000	0.0000	0.0000;
	2618	2617	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.8416	-11.9399	-21.8412	11.9443	0.0000	0.0000	0.0000	0.0000;
	2624	2623	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.3465	-1.6254	-15.3463	1.6272	0.0000	0.0000	0.0000	0.0000;
	2639	2638	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2660	2659	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2670	2669	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-46.6994	-4.1942	46.7009	4.2091	0.0000	0.0000	0.0000	0.0000;
	2672	2671	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.8960	4.4673	-14.8958	-4.4656	0.0000	0.0000	0.0000	0.0000;
	2689	2688	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.1264	8.4938	-26.1259	-8.4882	0.0000	0.0000	0.0000	0.0000;
	2707	2706	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.8946	-37.0924	16.8958	37.1047	0.0000	0.0000	0.0000	0.0000;
	2711	2710	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-44.9390	-1.4346	44.9404	1.4495	0.0000	0.0000	0.0000	0.0000;
	2722	2721	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.9980	-5.5000	34.9989	5.5093	0.0000	0.0000	0.0000	0.0000;
	2727	2726	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.8394	2.9827	9.8395	-2.9819	0.0000	0.0000	0.0000	0.0000;
	2730	2729	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.1208	-9.3140	8.1209	9.3150	0.0000	0.0000	0.0000	0.0000;
];

%%-----  OPF Data  -----%%
%% area data
%	area	refbus
mpc.areas = [
	1	18;
];

%% generator cost data
%	1	startup	shutdown	n	x1	y1	...	xn	yn
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	111.63	0;
	2	0	0	3	0	111.63	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
];
