function mpc = case2746_wp
%CASE2746WP  Power flow data for Polish system - winter 2003-04 evening peak.
%   Please see CASEFORMAT for details on the case file format.
%
%   This case represents the Polish 400, 220 and 110 kV networks during
%   winter 2003-04 evening peak conditions. Multiple centrally
%   dispatchable generators at a bus have not been aggregated.
%   Generators that are not centrally dispatchable in the Polish
%   energy market are given a cost of zero.
%
%   This data was graciously provided by, and is distributed with the
%   permission of, Roman Korab <roman.korab@polsl.pl>.

%   MATPOWER
%   $Id: case2746wp.m 4738 2014-07-03 00:55:39Z dchassin $

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin	lam_P	lam_Q	mu_Vmax	mu_Vmin
mpc.bus = [
	1	1	0	0	0	0	1	1.1003391	-0.61480726	220	1	1.11	0.95	98.3658	0.1938	0.0000	0.0000;
	2	1	0	0	0	0	1	1.1017662	1.2131549	220	1	1.11	0.95	97.9988	0.1556	0.0000	0.0000;
	3	1	0	0	0	0	1	1.0645289	-26.339776	220	1	1.11	0.95	113.5931	0.8243	0.0000	0.0000;
	4	1	0	0	0	0	1	1.0850159	-6.0862751	220	1	1.11	0.95	101.3462	0.7470	0.0000	0.0000;
	5	1	0	0	0	0	1	1.0850783	-6.0889889	220	1	1.11	0.95	101.3481	0.7457	0.0000	0.0000;
	6	1	0	0	0	0	1	1.059595	-17.220536	220	1	1.11	0.95	106.5828	1.2223	0.0000	0.0000;
	7	1	0	0	0	0	1	1.0597417	-17.210267	220	1	1.11	0.95	106.5743	1.2187	0.0000	0.0000;
	8	1	0	0	0	0	1	1.0286868	-13.591482	400	1	1.05	0.95	105.2553	0.6873	0.0000	0.0000;
	9	1	0	0	0	0	1	1.0287027	-13.586305	400	1	1.05	0.95	105.2527	0.6857	0.0000	0.0000;
	10	1	0	0	0	0	1	1.0408993	-17.565546	220	1	1.11	0.95	107.7378	1.8165	0.0000	0.0000;
	11	1	0	0	0	0	1	1.0407987	-17.552694	220	1	1.11	0.95	107.7369	1.8191	0.0000	0.0000;
	12	1	0	0	0	0	1	1.0408325	-17.544154	220	1	1.11	0.95	107.7347	1.8184	0.0000	0.0000;
	13	1	0	0	0	0	1	1.027382	-11.769431	400	1	1.05	0.95	104.4075	1.0389	0.0000	0.0000;
	14	1	0	0	0	0	1	1.0274267	-11.759591	400	1	1.05	0.95	104.4018	1.0365	0.0000	0.0000;
	15	1	0	0	0	0	1	1.0277821	-16.636616	400	1	1.05	0.95	106.1196	0.0526	0.0000	0.0000;
	16	1	0	0	0	0	1	1.0277821	-16.636616	400	1	1.05	0.95	106.1196	0.0526	0.0000	0.0000;
	17	2	11	40	0	0	1	1.1051114	-21.25728	220	1	1.11	0.95	109.5314	0.0007	0.0000	0.0000;
	18	2	14	40	0	0	1	1.1051329	-21.256172	220	1	1.11	0.95	109.5301	0.0000	0.0000	0.0203;
	19	1	0	0	0	0	1	1.0899007	-4.9335602	220	1	1.11	0.95	100.6721	0.6066	0.0000	0.0000;
	20	1	0	0	0	0	1	1.0899369	-4.9324552	220	1	1.11	0.95	100.6736	0.6058	0.0000	0.0000;
	21	1	0	0	0	0	1	1.0605639	-19.1108	220	1	1.11	0.95	108.3430	1.3062	0.0000	0.0000;
	22	1	0	0	0	0	1	1.0604975	-19.112544	220	1	1.11	0.95	108.3441	1.3075	0.0000	0.0000;
	23	1	0	0	0	0	1	1.0441797	-17.458847	220	1	1.11	0.95	107.6600	1.7291	0.0000	0.0000;
	24	1	0	0	0	0	1	1.091933	-2.8028486	220	1	1.11	0.95	99.8073	0.5296	0.0000	0.0000;
	25	1	0	0	0	0	1	1.0154431	-13.879116	400	1	1.05	0.95	105.4805	0.4745	0.0000	0.0000;
	26	2	46.738	72.054	0	0	1	1.11	-0.25095024	220	1	1.11	0.95	98.1840	0.0000	1871.2524	0.0000;
	27	2	85.493	122.06	0	0	1	1.11	1.4731337	220	1	1.11	0.95	97.8808	0.0000	2497.9903	0.0000;
	28	3	60	110	0	0	1	1.0460529	0	400	1	1.05	0.95	98.8168	-0.1638	0.0000	0.0000;
	29	2	60.097	90	0	0	1	1.0460925	0.00572232	400	1	1.05	0.95	98.8125	-0.1626	0.0000	0.0000;
	30	1	0	0	0	0	1	1.048206	-18.395467	220	1	1.11	0.95	108.2832	1.5095	0.0000	0.0000;
	31	1	0	0	0	0	1	1.045761	-1.4350337	400	1	1.05	0.95	98.9272	-0.4853	0.0000	0.0000;
	32	1	0	0	0	0	1	1.0385822	-17.912484	220	1	1.11	0.95	107.9744	1.8681	0.0000	0.0000;
	33	1	0	0	0	0	1	1.0919388	-2.8017966	220	1	1.11	0.95	99.8069	0.5295	0.0000	0.0000;
	34	1	0	0	0	0	1	1.0925699	-9.5096398	220	1	1.11	0.95	103.0266	0.5256	0.0000	0.0000;
	35	1	0	0	0	0	1	1.0894807	-13.144346	220	2	1.11	0.95	104.6817	0.0239	0.0000	0.0000;
	36	1	0	0	0	0	1	1.0925005	-12.843932	220	2	1.11	0.95	104.6851	-0.0233	0.0000	0.0000;
	37	1	0	0	0	0	1	1.0970263	-11.092748	220	2	1.11	0.95	103.5611	-0.0732	0.0000	0.0000;
	38	1	0	0	0	0	1	1.0970174	-11.097136	220	2	1.11	0.95	103.5634	-0.0730	0.0000	0.0000;
	39	1	0	0	0	0	1	1.0760617	-15.995023	220	2	1.11	0.95	106.6792	-0.1631	0.0000	0.0000;
	40	1	0	0	0	0	1	1.1040849	-9.3848203	220	2	1.11	0.95	102.8022	-0.2150	0.0000	0.0000;
	41	1	0	0	0	0	1	1.1040405	-9.3830473	220	2	1.11	0.95	102.8019	-0.2146	0.0000	0.0000;
	42	1	0	0	0	0	1	1.0435696	-9.7361406	400	2	1.05	0.95	102.8310	-0.3182	0.0000	0.0000;
	43	2	11.436	0	0	0	1	1.1099957	-9.8167066	220	2	1.11	0.95	102.8898	0.0019	0.0000	0.0000;
	44	2	24	0	0	0	1	1.11	-9.7892115	220	2	1.11	0.95	102.8801	0.0000	1267.4360	0.0000;
	45	2	20	0	0	0	1	1.0486321	-10.600385	400	2	1.05	0.95	103.5574	0.0000	0.0000	0.0000;
	46	1	0	0	0	0	1	1.048661	-10.601895	400	2	1.05	0.95	103.5562	-0.0017	0.0000	0.0000;
	47	1	0	0	0	0	1	1.1003191	-9.9747468	220	2	1.11	0.95	103.2216	-0.1332	0.0000	0.0000;
	48	1	0	0	0	0	1	1.0353007	-15.497399	400	2	1.05	0.95	104.6752	-0.3477	0.0000	0.0000;
	49	1	0	0	0	0	1	1.0352697	-15.506312	400	2	1.05	0.95	104.6797	-0.3469	0.0000	0.0000;
	50	1	0	0	0	0	1	1.05	-11.729501	400	2	1.05	0.95	103.9640	-0.4380	2649.8675	0.0000;
	51	1	0	0	0	0	1	1.0831843	-14.831927	220	2	1.11	0.95	106.0233	-0.1063	0.0000	0.0000;
	52	1	0	0	0	0	1	1.0831697	-14.83156	220	2	1.11	0.95	106.0243	-0.1064	0.0000	0.0000;
	53	1	0	0	0	0	1	1.0439979	-11.198006	400	2	1.05	0.95	103.5431	-0.2198	0.0000	0.0000;
	54	1	0	0	0	0	1	1.0439983	-11.196343	400	2	1.05	0.95	103.5419	-0.2206	0.0000	0.0000;
	55	2	12	0	0	0	1	1.1026056	-9.4089303	220	2	1.11	0.95	102.6793	-0.1306	0.0000	0.0000;
	56	2	11.436	0	0	0	1	1.1025184	-9.405703	220	2	1.11	0.95	102.6756	-0.1282	0.0000	0.0000;
	57	2	12	0	0	0	1	1.0456443	-10.170777	400	2	1.05	0.95	102.9624	-0.4555	0.0000	0.0000;
	58	2	11.436	0	0	0	1	1.0456662	-10.175736	400	2	1.05	0.95	102.9649	-0.4554	0.0000	0.0000;
	59	2	167.518	60	0	0	1	1.1017247	-11.30084	220	2	1.11	0.95	103.6382	0.0447	0.0000	0.0000;
	60	1	0	0	0	0	1	1.1017324	-11.300903	220	2	1.11	0.95	103.6376	0.0440	0.0000	0.0000;
	61	1	0	0	0	0	1	1.1005278	-10.134063	220	2	1.11	0.95	103.1603	-0.1600	0.0000	0.0000;
	62	1	0	0	0	0	1	1.1036005	-11.047572	220	2	1.11	0.95	103.6562	0.0311	0.0000	0.0000;
	63	1	0	0	0	0	1	1.1035983	-11.050757	220	2	1.11	0.95	103.6568	0.0317	0.0000	0.0000;
	64	1	0	0	0	0	1	1.0468475	-11.759437	400	2	1.05	0.95	103.3469	-0.6450	0.0000	0.0000;
	65	1	0	0	0	0	1	1.046831	-11.771438	400	2	1.05	0.95	103.3508	-0.6455	0.0000	0.0000;
	66	1	0	0	0	0	1	1.0893159	-12.668676	220	2	1.11	0.95	104.3236	-0.0107	0.0000	0.0000;
	67	1	0	0	0	0	1	1.0914437	-12.423754	220	2	1.11	0.95	104.1800	-0.0365	0.0000	0.0000;
	68	1	0	0	0	0	1	1.083607	-14.320478	220	2	1.11	0.95	105.8181	-0.0576	0.0000	0.0000;
	69	1	0	0	0	0	1	1.1005323	-4.4705794	220	3	1.11	0.95	100.1491	-0.1679	0.0000	0.0000;
	70	1	7.123	0	0	0	1	1.0980231	-9.7009113	220	3	1.11	0.95	103.0168	0.0335	0.0000	0.0000;
	71	1	8.31	0.933	0	0	1	1.0979915	-9.703589	220	3	1.11	0.95	103.0192	0.0343	0.0000	0.0000;
	72	1	0	0	0	0	1	1.1059097	-4.3482203	220	3	1.11	0.95	99.8543	0.0998	0.0000	0.0000;
	73	1	0	0	0	0	1	1.1059616	-4.339125	220	3	1.11	0.95	99.8509	0.0987	0.0000	0.0000;
	74	1	0	0	0	0	1	1.1013537	-4.7646624	220	3	1.11	0.95	100.0408	0.1135	0.0000	0.0000;
	75	1	0	0	0	0	1	1.1013148	-4.7687846	220	3	1.11	0.95	100.0426	0.1140	0.0000	0.0000;
	76	1	0	0	0	0	1	1.1084923	-3.4136449	220	3	1.11	0.95	99.5287	0.0371	0.0000	0.0000;
	77	1	0	0	0	0	1	1.1084612	-3.4216098	220	3	1.11	0.95	99.5330	0.0382	0.0000	0.0000;
	78	2	27	70	0	0	1	1.11	-3.7286027	220	3	1.11	0.95	99.5068	0.0000	748.3478	0.0000;
	79	2	9	21	0	0	1	1.1091061	-3.9026747	220	3	1.11	0.95	99.6306	0.0011	0.0000	0.0000;
	80	1	10.328	2.61	0	0	1	1.0984814	-5.1340225	220	3	1.11	0.95	100.4225	0.2765	0.0000	0.0000;
	81	1	0	0	0	0	1	1.0984976	-5.1327611	220	3	1.11	0.95	100.4220	0.2763	0.0000	0.0000;
	82	2	35	108	0	0	1	1.0434596	-3.6593665	400	3	1.05	0.95	99.2008	0.0000	0.0000	0.0000;
	83	1	0	0	0	0	1	1.1085008	-6.506818	220	3	1.11	0.95	100.5192	0.3124	0.0000	0.0000;
	84	1	0	0	0	0	1	1.1065315	-3.9305775	220	3	1.11	0.95	99.4386	0.0554	0.0000	0.0000;
	85	1	0	0	0	0	1	1.1065344	-3.9324762	220	3	1.11	0.95	99.4405	0.0558	0.0000	0.0000;
	86	1	37.893	12.351	0	0	1	1.1011233	-4.342548	220	3	1.11	0.95	99.9812	-0.1367	0.0000	0.0000;
	87	1	0	0	0	0	1	1.1010914	-4.3484899	220	3	1.11	0.95	99.9832	-0.1370	0.0000	0.0000;
	88	1	0	0	0	0	1	1.1040285	-3.8682504	220	3	1.11	0.95	99.3740	0.0877	0.0000	0.0000;
	89	1	0	0	0	0	1	1.1040076	-3.8696159	220	3	1.11	0.95	99.3753	0.0883	0.0000	0.0000;
	90	1	0	0	0	0	1	1.1043527	-3.8990518	220	3	1.11	0.95	99.7690	-0.1565	0.0000	0.0000;
	91	1	0	0	0	0	1	1.1043307	-3.904573	220	3	1.11	0.95	99.7716	-0.1564	0.0000	0.0000;
	92	1	0	0	0	0	1	1.0455896	-2.2785277	400	3	1.05	0.95	99.4873	-0.2606	0.0000	0.0000;
	93	1	0	0	0	0	1	1.0455942	-2.2803837	400	3	1.05	0.95	99.4875	-0.2610	0.0000	0.0000;
	94	1	0	0	0	0	1	1.1078409	-3.6402286	220	3	1.11	0.95	99.0458	0.0213	0.0000	0.0000;
	95	1	0	0	0	0	1	1.1078802	-3.6395637	220	3	1.11	0.95	99.0452	0.0211	0.0000	0.0000;
	96	1	0	0	0	0	1	1.1052279	-5.5721529	220	3	1.11	0.95	100.2120	0.1872	0.0000	0.0000;
	97	1	0	0	0	0	1	1.1052541	-5.5767843	220	3	1.11	0.95	100.2128	0.1879	0.0000	0.0000;
	98	1	16.027	7.274	0	0	1	1.1054331	-4.6685289	220	3	1.11	0.95	100.0477	-0.0303	0.0000	0.0000;
	99	1	7.764	0.258	0	0	1	1.1054199	-4.6735493	220	3	1.11	0.95	100.0498	-0.0308	0.0000	0.0000;
	100	1	0	0	0	0	1	1.098073	-9.6845182	220	3	1.11	0.95	103.0080	0.0336	0.0000	0.0000;
	101	1	0	0	0	0	1	1.0980546	-9.6842434	220	3	1.11	0.95	103.0072	0.0341	0.0000	0.0000;
	102	1	0	0	0	0	1	1.1036484	-4.4810497	220	3	1.11	0.95	100.1615	0.1646	0.0000	0.0000;
	103	1	0	0	0	0	1	1.1035819	-4.4911311	220	3	1.11	0.95	100.1660	0.1662	0.0000	0.0000;
	104	2	14	40	0	0	1	1.11	-3.3754895	220	3	1.11	0.95	99.0705	0.0000	851.4354	0.0000;
	105	2	14	40	0	0	1	1.1099947	-3.3760543	220	3	1.11	0.95	99.0679	0.0010	0.0000	0.0000;
	106	2	7	18	0	0	1	1.1076732	-3.5666718	220	3	1.11	0.95	99.1312	-0.0000	0.0000	0.0000;
	107	2	8	15	0	0	1	1.1075967	-3.5663387	220	3	1.11	0.95	99.1331	0.0009	0.0000	0.0000;
	108	1	1.044	0	0	0	1	1.1033476	-5.1479288	220	3	1.11	0.95	100.3152	-0.0853	0.0000	0.0000;
	109	1	1.259	0	0	0	1	1.1033898	-5.1544483	220	3	1.11	0.95	100.3166	-0.0846	0.0000	0.0000;
	110	1	0	0	0	0	1	1.1035377	-6.3893921	220	3	1.11	0.95	101.1866	0.0199	0.0000	0.0000;
	111	1	0	0	0	0	1	1.0950251	-5.1667375	220	3	1.11	0.95	100.4766	0.3798	0.0000	0.0000;
	112	1	0	0	0	0	1	1.095049	-5.1665381	220	3	1.11	0.95	100.4764	0.3794	0.0000	0.0000;
	113	1	0	0	0	0	1	1.0995271	-5.044646	220	3	1.11	0.95	100.3684	0.2578	0.0000	0.0000;
	114	1	0	0	0	0	1	1.0995945	-5.0347076	220	3	1.11	0.95	100.3643	0.2564	0.0000	0.0000;
	115	1	0	0	0	0	1	1.0439081	-5.9525365	400	3	1.05	0.95	100.4302	-1.3328	0.0000	0.0000;
	116	2	0	0	0	0	1	1.1077452	-4.3817951	220	3	1.11	0.95	99.8878	0.0005	0.0000	0.0000;
	117	2	8	15	0	0	1	1.1077753	-4.3750278	220	3	1.11	0.95	99.8858	0.0000	0.0000	0.0000;
	118	2	5.5	10	0	0	1	1.1078928	-5.7187611	220	3	1.11	0.95	100.8745	-0.0648	0.0000	0.0000;
	119	1	0	0	0	0	1	1.1078551	-5.7307042	220	3	1.11	0.95	100.8794	-0.0642	0.0000	0.0000;
	120	1	0	0	0	0	1	1.0486473	-10.372175	400	3	1.05	0.95	102.8601	-0.8607	0.0000	0.0000;
	121	1	0	0	0	0	1	1.048686	-10.364416	400	3	1.05	0.95	102.8559	-0.8627	0.0000	0.0000;
	122	1	0	0	0	0	1	1.0499922	-6.1506754	400	3	1.05	0.95	100.5772	-2.3753	0.0000	0.0000;
	123	1	0	0	0	0	1	1.05	-6.1454067	400	3	1.05	0.95	100.5753	-2.3844	29819.5951	0.0000;
	124	1	0	0	0	0	1	1.1038618	-6.4994385	220	3	1.11	0.95	101.3365	-0.0037	0.0000	0.0000;
	125	2	18.343	21.865	0	0	1	1.1083176	-3.9535039	220	3	1.11	0.95	99.5430	0.0000	0.0000	0.0000;
	126	2	28.469	34.292	0	0	1	1.1082749	-3.9550628	220	3	1.11	0.95	99.5460	0.0025	0.0000	0.0000;
	127	2	28	66	0	0	1	1.0426336	-5.1240534	400	3	1.05	0.95	100.0312	-0.6133	0.0000	0.0000;
	128	1	0	0	0	0	1	1.0426497	-5.1264675	400	3	1.05	0.95	100.0321	-0.6163	0.0000	0.0000;
	129	1	0	0	0	0	1	1.1003489	-4.4658462	220	3	1.11	0.95	100.0378	-0.1398	0.0000	0.0000;
	130	1	0	0	0	0	1	1.1003745	-4.4621846	220	3	1.11	0.95	100.0349	-0.1397	0.0000	0.0000;
	131	1	0	0	0	0	1	1.1026419	-4.1537245	220	3	1.11	0.95	99.8703	-0.1381	0.0000	0.0000;
	132	2	3	18	0	0	1	1.11	-2.6939208	220	3	1.11	0.95	99.1843	0.0000	860.4661	0.0000;
	133	2	2	6	0	0	1	1.11	-3.0673769	220	3	1.11	0.95	99.3612	0.0000	428.7704	0.0000;
	134	2	15.447	12.88	0	0	1	1.11	-10.714442	220	4	1.11	0.95	103.4466	0.0000	532.4155	0.0000;
	135	2	5.255	-0.357	0	0	1	1.1098762	-10.723949	220	4	1.11	0.95	103.4495	0.0024	0.0000	0.0000;
	136	1	0	0	0	0	1	1.0804168	-12.976961	220	4	1.11	0.95	102.4302	0.8590	0.0000	0.0000;
	137	1	0	0	0	0	1	1.0862695	-11.160281	220	4	1.11	0.95	101.2356	0.6887	0.0000	0.0000;
	138	1	0	0	0	0	1	1.0208082	-9.8994847	400	4	1.05	0.95	101.1353	0.6360	0.0000	0.0000;
	139	1	0	0	0	0	1	1.0208188	-9.9009404	400	4	1.05	0.95	101.1362	0.6358	0.0000	0.0000;
	140	1	0	0	0	0	1	1.0929466	-21.517302	220	4	1.11	0.95	110.4019	0.4199	0.0000	0.0000;
	141	1	0	0	0	0	1	1.0936734	-27.850208	220	4	1.11	0.95	114.1140	0.4044	0.0000	0.0000;
	142	1	0	0	0	0	1	1.0936734	-27.850208	220	4	1.11	0.95	114.1140	0.4044	0.0000	0.0000;
	143	1	0	0	0	0	1	1.0979678	-24.81337	220	4	1.11	0.95	111.2129	0.8957	0.0000	0.0000;
	144	1	0	0	0	0	1	1.0967448	-13.511963	220	4	1.11	0.95	101.8406	0.4787	0.0000	0.0000;
	145	1	0	0	0	0	1	1.0967448	-13.511963	220	4	1.11	0.95	101.8406	0.4787	0.0000	0.0000;
	146	2	10.954	-0.465	0	0	1	1.1096665	-13.527397	220	4	1.11	0.95	104.8461	0.0247	0.0000	0.0000;
	147	2	10.812	-0.465	0	0	1	1.1096461	-13.538207	220	4	1.11	0.95	104.8485	0.0260	0.0000	0.0000;
	148	2	11.5	6.86	0	0	1	1.11	-25.675039	220	4	1.11	0.95	112.2754	0.0000	1722.1892	0.0000;
	149	1	1.634	3.038	0	0	1	1.1099958	-25.669786	220	4	1.11	0.95	112.2713	0.0006	0.0000	0.0000;
	150	2	8.087	-0.38	0	0	1	1.0367199	-22.19321	400	4	1.05	0.95	111.2998	-0.2377	0.0000	0.0000;
	151	2	16.174	-0.76	0	0	1	1.0367522	-22.189004	400	4	1.05	0.95	111.2966	-0.2386	0.0000	0.0000;
	152	1	0	0	0	0	1	1.0577636	-21.642084	220	4	1.11	0.95	111.0636	1.8396	0.0000	0.0000;
	153	1	0	0	0	0	1	1.0746088	-20.259864	220	4	1.11	0.95	108.1496	1.8476	0.0000	0.0000;
	154	1	0	0	0	0	1	1.0746911	-20.253562	220	4	1.11	0.95	108.1448	1.8458	0.0000	0.0000;
	155	2	30.555	-3.555	0	0	1	1.11	-7.0014325	220	4	1.11	0.95	98.9764	0.0000	6606.4137	0.0000;
	156	2	14.679	-3.566	0	0	1	1.11	-8.0966014	220	4	1.11	0.95	99.5878	0.0000	8240.7403	0.0000;
	157	1	0	0	0	0	1	1.11	-7.0014325	220	4	1.11	0.95	98.9764	0.0000	0.0000	0.0000;
	158	1	0	0	0	0	1	1.0349647	-6.6407189	400	4	1.05	0.95	99.4370	0.1499	0.0000	0.0000;
	159	2	7.385	-1.783	0	0	1	1.0350106	-6.6353335	400	4	1.05	0.95	99.4353	0.1487	0.0000	0.0000;
	160	1	0	0	0	0	1	1.0920139	-28.060831	220	4	1.11	0.95	114.3792	0.4216	0.0000	0.0000;
	161	1	0	0	0	0	1	1.0920139	-28.060831	220	4	1.11	0.95	114.3792	0.4216	0.0000	0.0000;
	162	1	0	0	0	0	1	1.0178137	-10.878788	400	4	1.05	0.95	101.7681	0.8220	0.0000	0.0000;
	163	1	0	0	0	0	1	1.0249576	-9.3400021	400	4	1.05	0.95	101.0197	0.5666	0.0000	0.0000;
	164	1	0	0	0	0	1	1.024957	-9.3420899	400	4	1.05	0.95	101.0201	0.5666	0.0000	0.0000;
	165	2	4.293	-8.964	0	0	1	1.11	-13.624283	220	4	1.11	0.95	104.8666	0.0000	2151.3956	0.0000;
	166	2	23.077	7.176	0	0	1	1.1099978	-13.642791	220	4	1.11	0.95	104.8772	0.0020	0.0000	0.0000;
	167	1	0	0	0	0	1	1.11	-13.624283	220	4	1.11	0.95	104.8666	0.0000	0.0000	0.0000;
	168	1	0	0	0	0	1	1.080865	-26.369943	220	4	1.11	0.95	113.8019	0.1600	0.0000	0.0000;
	169	1	0	0	0	0	1	1.0928314	-27.962378	220	4	1.11	0.95	114.2024	0.4189	0.0000	0.0000;
	170	1	0	0	0	0	1	1.0863977	-22.458467	220	4	1.11	0.95	111.1430	0.5568	0.0000	0.0000;
	171	1	0	0	0	0	1	1.0863007	-22.451991	220	4	1.11	0.95	111.1408	0.5584	0.0000	0.0000;
	172	1	0	0	0	0	1	1.0057335	-23.496497	400	4	1.05	0.95	111.4856	0.4789	0.0000	0.0000;
	173	1	0	0	0	0	1	1.0057335	-23.496497	400	4	1.05	0.95	111.4856	0.4789	0.0000	0.0000;
	174	1	0	0	0	0	1	1.0476566	-17.892455	220	4	1.11	0.95	107.7998	2.5845	0.0000	0.0000;
	175	1	0	0	0	0	1	1.0476686	-17.885603	220	4	1.11	0.95	107.7990	2.5843	0.0000	0.0000;
	176	1	0	0	0	0	1	1.084794	-22.987556	220	4	1.11	0.95	111.4317	0.5802	0.0000	0.0000;
	177	1	0	0	0	0	1	1.0867231	-12.489339	220	4	1.11	0.95	102.1816	0.7107	0.0000	0.0000;
	178	1	0	0	0	0	1	1.0867623	-12.483073	220	4	1.11	0.95	102.1813	0.7101	0.0000	0.0000;
	179	1	0	0	0	0	1	1.0899616	-11.958749	220	4	1.11	0.95	102.2825	0.6845	0.0000	0.0000;
	180	1	0	0	0	0	1	1.0899616	-11.958749	220	4	1.11	0.95	102.2825	0.6845	0.0000	0.0000;
	181	1	0	0	0	0	1	1.0449477	-19.418635	220	4	1.11	0.95	108.4654	2.6634	0.0000	0.0000;
	182	1	0	0	0	0	1	1.0474502	-21.786143	220	5	1.11	0.95	109.5467	-0.0766	0.0000	0.0000;
	183	1	0	0	0	0	1	1.11	-23.407235	220	5	1.11	0.95	110.9010	-1.5077	3341.3081	0.0000;
	184	1	0	0	0	0	1	1.0362829	-21.672063	400	5	1.05	0.95	110.5637	-0.5762	0.0000	0.0000;
	185	1	0	0	0	0	1	1.036306	-21.676526	400	5	1.05	0.95	110.5665	-0.5760	0.0000	0.0000;
	186	1	0	0	0	0	1	1.0181489	-21.198101	400	5	1.05	0.95	109.9911	0.0207	0.0000	0.0000;
	187	1	0	0	0	0	1	1.0181684	-21.2021	400	5	1.05	0.95	109.9940	0.0207	0.0000	0.0000;
	188	1	0	0	0	0	1	1.0217282	-25.032232	220	5	1.11	0.95	112.0495	0.4732	0.0000	0.0000;
	189	1	0	0	0	0	1	1.021804	-25.03367	220	5	1.11	0.95	112.0501	0.4725	0.0000	0.0000;
	190	1	0	0	0	0	1	1.0716712	-22.614136	220	5	1.11	0.95	109.8131	-0.4616	0.0000	0.0000;
	191	1	0	0	0	0	1	1.0715551	-22.615617	220	5	1.11	0.95	109.8138	-0.4625	0.0000	0.0000;
	192	1	0	0	0	0	1	0.99118643	-19.908396	400	5	1.05	0.95	108.9619	0.0646	0.0000	0.0000;
	193	1	0	0	0	0	1	1.0567984	-20.966479	220	5	1.11	0.95	109.2100	0.0979	0.0000	0.0000;
	194	1	0	0	0	0	1	1.056876	-20.962637	220	5	1.11	0.95	109.2090	0.0981	0.0000	0.0000;
	195	1	0	0	0	0	1	1.0075635	-23.167247	400	5	1.05	0.95	111.1787	0.1111	0.0000	0.0000;
	196	1	0	0	0	0	1	1.0075162	-23.172128	400	5	1.05	0.95	111.1820	0.1117	0.0000	0.0000;
	197	1	0	0	0	0	1	1.0630659	-25.644346	220	5	1.11	0.95	112.6796	0.3221	0.0000	0.0000;
	198	1	0	0	0	0	1	1.0631118	-25.637578	220	5	1.11	0.95	112.6765	0.3220	0.0000	0.0000;
	199	1	0	0	0	0	1	1.0382243	-19.747847	400	5	1.05	0.95	109.5722	-0.3075	0.0000	0.0000;
	200	1	0	0	0	0	1	1.0382491	-19.742409	400	5	1.05	0.95	109.5718	-0.3087	0.0000	0.0000;
	201	1	0	0	0	0	1	1.0487566	-23.702354	220	5	1.11	0.95	111.4262	0.5281	0.0000	0.0000;
	202	1	0	0	0	0	1	1.0487178	-23.700417	220	5	1.11	0.95	111.4280	0.5310	0.0000	0.0000;
	203	1	0	0	0	0	1	1.0503208	-21.85558	220	5	1.11	0.95	110.7768	1.0775	0.0000	0.0000;
	204	1	0	0	0	0	1	1.0502407	-21.8697	220	5	1.11	0.95	110.7830	1.0769	0.0000	0.0000;
	205	2	0	0	0	0	1	1.0249085	-19.761423	400	5	1.05	0.95	109.4371	0.0004	0.0000	0.0000;
	206	2	0	0	0	0	1	1.0249172	-19.76116	400	5	1.05	0.95	109.4373	0.0000	0.0000	0.0000;
	207	1	0	0	0	0	1	1.0798658	-25.344948	220	5	1.11	0.95	112.2907	-0.8014	0.0000	0.0000;
	208	1	0	0	0	0	1	1.0798892	-25.338969	220	5	1.11	0.95	112.2865	-0.8038	0.0000	0.0000;
	209	1	8.101	1.5	0	0	1	1.0817848	-23.535002	110	1	1.12	0.95	112.0290	-0.1334	0.0000	0.0000;
	210	1	8.101	1	0	0	1	1.076992	-32.083839	110	1	1.12	0.95	120.3339	1.5128	0.0000	0.0000;
	211	1	9.114	2	0	0	1	1.0847673	-20.8153	110	1	1.12	0.95	107.5431	2.2480	0.0000	0.0000;
	212	1	8.911	7.8	0	0	1	1.0158576	-25.93094	110	1	1.12	0.95	117.0338	5.2337	0.0000	0.0000;
	213	1	4.05	1	0	0	1	1.0739576	-1.9748493	110	1	1.12	0.95	99.1423	0.4609	0.0000	0.0000;
	214	1	9.619	2.5	0	0	1	1.090974	-3.7881561	110	1	1.12	0.95	99.3438	0.4814	0.0000	0.0000;
	215	2	51.981	24.3	0	0	1	1.1081869	-22.026489	110	1	1.12	0.95	107.6029	0.0000	0.0000	0.0000;
	216	1	22.276	2.5	0	0	1	1.1096931	-21.983135	110	1	1.12	0.95	107.4659	-0.2070	0.0000	0.0000;
	217	1	10.126	2	0	0	1	1.1090725	-22.019259	110	1	1.12	0.95	107.5290	-0.1504	0.0000	0.0000;
	218	1	11.138	2	0	0	1	1.1081886	-22.233282	110	1	1.12	0.95	107.8125	-0.0143	0.0000	0.0000;
	219	2	13.163	2.5	0	0	1	1.0770515	-23.881925	110	1	1.12	0.95	112.3679	1.5862	0.0000	0.0000;
	220	1	9.114	2.25	0	0	1	1.0673511	-22.880155	110	1	1.12	0.95	110.7514	2.7143	0.0000	0.0000;
	221	2	0	0	0	0	1	1.094225	-17.684155	110	1	1.12	0.95	103.9522	1.5232	0.0000	0.0000;
	222	2	11.138	2.4	0	0	1	1.0749255	-10.666613	110	1	1.12	0.95	104.6575	0.0483	0.0000	0.0000;
	223	2	17.214	3.1	0	0	1	1.0868619	-22.774723	110	1	1.12	0.95	109.6738	1.7235	0.0000	0.0000;
	224	1	1.519	0.4	0	0	1	1.0544634	-4.6228451	110	1	1.12	0.95	101.4993	0.8091	0.0000	0.0000;
	225	1	5.265	0.8	0	0	1	1.1039848	-23.103048	110	1	1.12	0.95	109.1465	0.1974	0.0000	0.0000;
	226	1	5.569	0.5	0	0	1	1.0978409	-27.540011	110	1	1.12	0.95	114.0974	0.5400	0.0000	0.0000;
	227	1	19.239	2	0	0	1	1.0975432	-22.886404	110	1	1.12	0.95	109.8932	-0.3936	0.0000	0.0000;
	228	1	11.138	2	0	0	1	1.0874769	-23.183685	110	1	1.12	0.95	109.9471	1.5913	0.0000	0.0000;
	229	2	2.633	1.03	0	0	1	1.0988186	-10.72873	110	1	1.12	0.95	103.1419	0.5625	0.0000	0.0000;
	230	2	2.633	1.03	0	0	1	1.099005	-10.723963	110	1	1.12	0.95	103.1379	0.5598	0.0000	0.0000;
	231	1	16.201	6	0	0	1	1.0753426	-23.328745	110	1	1.12	0.95	110.7937	2.1783	0.0000	0.0000;
	232	1	10.126	1.1	0	0	1	1.0926534	-3.6203307	110	1	1.12	0.95	99.1497	0.4447	0.0000	0.0000;
	233	1	9.619	1.5	0	0	1	1.0697437	-12.912459	110	1	1.12	0.95	105.0936	0.7011	0.0000	0.0000;
	234	1	22.277	17	0	0	1	1.0757912	-1.9367456	110	1	1.12	0.95	98.5048	0.5968	0.0000	0.0000;
	235	1	8.607	0.6	0	0	1	1.0864098	-25.948393	110	1	1.12	0.95	113.0900	0.4104	0.0000	0.0000;
	236	1	13.568	4.41	0	0	1	1.1023431	-9.8979079	110	1	1.12	0.95	101.9269	0.5930	0.0000	0.0000;
	237	1	7.695	0.8	0	0	1	1.0851688	-26.097362	110	1	1.12	0.95	113.3063	0.4526	0.0000	0.0000;
	238	1	10.126	1.5	0	0	1	1.0884007	-25.044356	110	1	1.12	0.95	112.1482	0.2544	0.0000	0.0000;
	239	2	4.493	1.175	0	0	1	1.0667379	-24.6879	110	1	1.12	0.95	112.9996	2.2671	0.0000	0.0000;
	240	1	13.872	0.6	0	0	1	1.0882562	-27.355993	110	1	1.12	0.95	113.8467	0.2846	0.0000	0.0000;
	241	1	7.594	2.19	0	0	1	1.1010965	-10.359606	110	1	1.12	0.95	102.5643	0.6251	0.0000	0.0000;
	242	1	10.632	0.4	0	0	1	1.1173341	-5.5827549	110	1	1.12	0.95	98.0259	-3.4396	0.0000	0.0000;
	243	1	0	0	0	0	1	1.117449	-5.5593178	110	1	1.12	0.95	98.0236	-3.4588	0.0000	0.0000;
	244	1	3.038	1.4	0	0	1	1.1138427	-22.272115	110	1	1.12	0.95	109.1819	0.0384	0.0000	0.0000;
	245	1	0	0	0	0	1	1.0813296	0.0903759	110	1	1.12	0.95	97.7998	0.3046	0.0000	0.0000;
	246	2	1.982	5	0	0	1	1.0769806	3.8426518	22	1	1.12	0.95	98.0779	0.0000	0.0000	0.0000;
	247	1	11.138	1.5	0	0	1	1.0890704	-29.263024	110	1	1.12	0.95	116.3804	0.9888	0.0000	0.0000;
	248	1	3.038	0.5	0	0	1	1.1065519	-29.31365	110	1	1.12	0.95	114.7312	1.0420	0.0000	0.0000;
	249	1	3.038	0.5	0	0	1	1.1006223	-28.024538	110	1	1.12	0.95	114.0965	0.6239	0.0000	0.0000;
	250	1	4.05	0.5	0	0	1	1.0502189	-34.428294	110	1	1.12	0.95	125.9132	1.6173	0.0000	0.0000;
	251	1	4.86	0.3	0	0	1	1.1030705	-21.806445	110	1	1.12	0.95	108.0353	0.6194	0.0000	0.0000;
	252	1	19.239	7	0	0	1	1.0878504	-17.342146	110	1	1.12	0.95	105.9358	1.3582	0.0000	0.0000;
	253	1	22.276	4	0	0	1	1.0767828	-23.437364	110	1	1.12	0.95	110.7940	2.0738	0.0000	0.0000;
	254	1	16.201	2	0	0	1	1.0864099	-31.343286	110	1	1.12	0.95	117.7698	1.3001	0.0000	0.0000;
	255	1	24.302	1.5	0	0	1	1.0941665	-27.568	110	1	1.12	0.95	113.9228	0.7667	0.0000	0.0000;
	256	1	5.569	1	0	0	1	1.0955445	-27.69593	110	1	1.12	0.95	113.9625	0.7960	0.0000	0.0000;
	257	1	4.303	0.6	0	0	1	1.0734811	-1.9364021	110	1	1.12	0.95	99.5800	0.4730	0.0000	0.0000;
	258	1	4.303	0.6	0	0	1	1.07341	-1.9531142	110	1	1.12	0.95	99.5862	0.4743	0.0000	0.0000;
	259	1	11.24	3.24	0	0	1	1.0876217	-11.70769	110	1	1.12	0.95	104.4389	0.8626	0.0000	0.0000;
	260	1	7.088	1	0	0	1	1.0468844	-35.030404	110	1	1.12	0.95	126.8275	1.6079	0.0000	0.0000;
	261	1	2.633	1.2	0	0	1	1.0957525	-21.024587	110	1	1.12	0.95	108.0961	1.7503	0.0000	0.0000;
	262	1	11.341	1.8	0	0	1	1.0809573	-20.805908	110	1	1.12	0.95	108.6858	1.9691	0.0000	0.0000;
	263	1	2.329	1.1	0	0	1	1.0840531	-26.816307	110	1	1.12	0.95	113.9400	0.4602	0.0000	0.0000;
	264	1	40.503	34	0	0	1	1.0812759	-0.49888515	110	1	1.12	0.95	98.0373	0.3063	0.0000	0.0000;
	265	1	38.479	33	0	0	1	1.0881063	-3.1108038	110	1	1.12	0.95	98.6688	0.5269	0.0000	0.0000;
	266	1	6.075	1	0	0	1	1.0778791	-22.899078	110	1	1.12	0.95	110.3697	2.1459	0.0000	0.0000;
	267	1	13.67	0.7	0	0	1	1.0841717	-23.703578	110	1	1.12	0.95	111.0193	1.3673	0.0000	0.0000;
	268	1	9.923	1.8	0	0	1	1.1070834	-21.305706	110	1	1.12	0.95	107.3870	0.4119	0.0000	0.0000;
	269	1	13.163	1.5	0	0	1	1.0957912	-23.212633	110	1	1.12	0.95	110.2340	-0.2786	0.0000	0.0000;
	270	1	10.125	1.5	0	0	1	1.0531865	-33.833782	110	1	1.12	0.95	125.0794	1.6235	0.0000	0.0000;
	271	1	18.227	4.5	0	0	1	1.0678305	-22.10534	110	1	1.12	0.95	109.4598	2.8328	0.0000	0.0000;
	272	1	0.304	0.1	0	0	1	1.0753844	-23.528093	110	1	1.12	0.95	112.3207	1.8325	0.0000	0.0000;
	273	1	0.506	0.15	0	0	1	1.1004103	-20.688428	110	1	1.12	0.95	107.4478	1.4364	0.0000	0.0000;
	274	1	0.202	0.06	0	0	1	1.0907468	-21.086827	110	1	1.12	0.95	108.0793	1.8793	0.0000	0.0000;
	275	1	12.88	5.8	0	0	1	1.1032707	-9.4048413	110	1	1.12	0.95	101.6324	0.7997	0.0000	0.0000;
	276	1	8.587	3.87	0	0	1	1.1054521	-9.7355844	110	1	1.12	0.95	101.6205	0.6453	0.0000	0.0000;
	277	1	9.619	1.2	0	0	1	1.0808162	-10.213237	110	1	1.12	0.95	103.8088	-0.0938	0.0000	0.0000;
	278	1	3.038	0.5	0	0	1	1.1047777	-23.124463	110	1	1.12	0.95	109.1708	0.0833	0.0000	0.0000;
	279	1	8.101	0	0	0	1	1.0996948	-24.402518	110	1	1.12	0.95	111.2609	0.2832	0.0000	0.0000;
	280	1	15.188	2	0	0	1	1.0977501	-20.765594	110	1	1.12	0.95	107.7341	1.5358	0.0000	0.0000;
	281	1	9.62	2	0	0	1	1.0731324	-22.384778	110	1	1.12	0.95	109.8008	2.1396	0.0000	0.0000;
	282	1	17.213	13.999	0	0	1	1.0789836	-2.8167993	110	1	1.12	0.95	98.7273	0.6171	0.0000	0.0000;
	283	1	16.202	13	0	0	1	1.0787699	-2.7998144	110	1	1.12	0.95	98.7273	0.6176	0.0000	0.0000;
	284	1	13.771	4.47	0	0	1	1.1028698	-9.2097636	110	1	1.12	0.95	101.4883	0.8583	0.0000	0.0000;
	285	1	15.189	4	0	0	1	1.0944803	-10.459164	110	1	1.12	0.95	102.8630	0.9682	0.0000	0.0000;
	286	1	10.126	1	0	0	1	1.0961235	-26.842822	110	1	1.12	0.95	113.8097	0.4902	0.0000	0.0000;
	287	1	5.063	0	0	0	1	1.1021121	-24.303756	110	1	1.12	0.95	109.9705	0.3685	0.0000	0.0000;
	288	1	3.037	2.5	0	0	1	1.0660203	-23.989307	110	1	1.12	0.95	112.0713	2.4301	0.0000	0.0000;
	289	1	4.05	0.501	0	0	1	1.0902044	-12.850003	110	1	1.12	0.95	105.7921	0.3637	0.0000	0.0000;
	290	1	21.77	6.7	0	0	1	1.0744392	-22.253492	110	1	1.12	0.95	109.6254	2.1057	0.0000	0.0000;
	291	2	15.999	1.6	0	0	1	1.0967354	-21.080597	110	1	1.12	0.95	108.0721	1.6229	0.0000	0.0000;
	292	1	8.202	2.37	0	0	1	1.1049272	-8.8771718	110	1	1.12	0.95	101.0950	0.8335	0.0000	0.0000;
	293	1	5.366	1	0	0	1	1.0850724	-21.892008	110	1	1.12	0.95	109.5035	0.3113	0.0000	0.0000;
	294	2	7.493	0.3	0	0	1	1.081483	-24.234003	110	1	1.12	0.95	111.8991	1.2777	0.0000	0.0000;
	295	1	13.163	0.4	0	0	1	1.0898002	-12.783476	110	1	1.12	0.95	105.6598	0.4190	0.0000	0.0000;
	296	1	6.582	1.5	0	0	1	1.0952139	-9.1123479	110	1	1.12	0.95	102.0099	-0.9808	0.0000	0.0000;
	297	1	10.328	3.36	0	0	1	1.0945644	-10.920415	110	1	1.12	0.95	103.3988	0.7171	0.0000	0.0000;
	298	1	14.885	4.7	0	0	1	1.0974807	-10.825888	110	1	1.12	0.95	103.2775	0.6095	0.0000	0.0000;
	299	2	15.188	4	0	0	1	1.1047419	-22.813814	110	1	1.12	0.95	108.7371	-0.1596	0.0000	0.0000;
	300	1	0	0	0	0	1	1.1057159	-9.7397428	110	1	1.12	0.95	101.6206	0.6306	0.0000	0.0000;
	301	1	5.569	1.2	0	0	1	1.0459164	-5.5659239	110	1	1.12	0.95	102.7966	0.9675	0.0000	0.0000;
	302	1	10.835	3.52	0	0	1	1.105023	-8.866215	110	1	1.12	0.95	101.0821	0.8318	0.0000	0.0000;
	303	1	13.062	3.77	0	0	1	1.101004	-10.34548	110	1	1.12	0.95	102.5415	0.6394	0.0000	0.0000;
	304	1	25.719	7.42	0	0	1	1.1028984	-9.3723973	110	1	1.12	0.95	101.6417	0.8263	0.0000	0.0000;
	305	1	25.72	7.42	0	0	1	1.0950208	-10.964685	110	1	1.12	0.95	103.4445	0.6832	0.0000	0.0000;
	306	2	97.275	54.72	0	0	1	1.0901957	-10.808597	110	1	1.12	0.95	103.3043	0.9479	0.0000	0.0000;
	307	2	62.22	22.54	0	0	1	1.0970189	-10.854078	110	1	1.12	0.95	103.3021	0.6146	0.0000	0.0000;
	308	2	35.918	13.2	0	0	1	1.1031309	-10.406483	110	1	1.12	0.95	102.6465	0.4584	0.0000	0.0000;
	309	1	0	0	0	0	1	1.0947324	-10.936698	110	1	1.12	0.95	103.4159	0.7040	0.0000	0.0000;
	310	2	39.452	17.47	0	0	1	1.1048567	-9.3160316	110	1	1.12	0.95	101.5140	0.7376	0.0000	0.0000;
	311	2	30.853	15.45	0	0	1	1.1050457	-9.9290164	110	1	1.12	0.95	101.8647	0.5093	0.0000	0.0000;
	312	1	15.492	0.8	0	0	1	1.0938205	-11.83344	110	1	1.12	0.95	104.4747	0.4784	0.0000	0.0000;
	313	1	2.531	0.5	0	0	1	1.0998331	-23.035657	110	1	1.12	0.95	109.4912	-0.2293	0.0000	0.0000;
	314	1	3.038	1	0	0	1	1.0641801	-24.139728	110	1	1.12	0.95	112.4006	2.5679	0.0000	0.0000;
	315	1	8.606	2.1	0	0	1	1.0635573	-24.569602	110	1	1.12	0.95	112.9465	2.4907	0.0000	0.0000;
	316	1	11.644	2.6	0	0	1	1.0634985	-24.559774	110	1	1.12	0.95	112.9410	2.4915	0.0000	0.0000;
	317	1	13.67	3.6	0	0	1	1.072301	-21.509098	110	1	1.12	0.95	108.4887	2.7675	0.0000	0.0000;
	318	1	13.366	3.85	0	0	1	1.1030991	-9.2646453	110	1	1.12	0.95	101.5184	0.8431	0.0000	0.0000;
	319	2	19.138	5.52	0	0	1	1.1019686	-9.5603564	110	1	1.12	0.95	101.8157	0.8166	0.0000	0.0000;
	320	1	17.214	3	0	0	1	1.0987647	-24.629363	110	1	1.12	0.95	111.6814	0.3189	0.0000	0.0000;
	321	1	18.732	6.09	0	0	1	1.1039557	-9.9668549	110	1	1.12	0.95	101.9241	0.5424	0.0000	0.0000;
	322	1	19.138	6.22	0	0	1	1.0883997	-10.942705	110	1	1.12	0.95	103.4777	1.0039	0.0000	0.0000;
	323	1	8.202	2.66	0	0	1	1.090503	-10.898082	110	1	1.12	0.95	103.4043	0.9139	0.0000	0.0000;
	324	1	15.189	3	0	0	1	1.0996087	-24.436772	110	1	1.12	0.95	111.3398	0.3025	0.0000	0.0000;
	325	1	20.251	3	0	0	1	1.0737136	-24.30529	110	1	1.12	0.95	112.7873	1.7339	0.0000	0.0000;
	326	1	17.821	5.14	0	0	1	1.0905322	-10.90023	110	1	1.12	0.95	103.4063	0.9125	0.0000	0.0000;
	327	1	9.619	2	0	0	1	1.0946826	-10.011184	110	1	1.12	0.95	102.5690	0.0690	0.0000	0.0000;
	328	1	4.557	1	0	0	1	1.0941208	-10.012186	110	1	1.12	0.95	102.6237	0.0094	0.0000	0.0000;
	329	1	51.743	14.92	0	0	1	1.0993207	-9.7433323	110	1	1.12	0.95	102.0508	0.9030	0.0000	0.0000;
	330	1	18.53	2	0	0	1	1.0865399	-17.486714	110	1	1.12	0.95	105.9280	-0.5061	0.0000	0.0000;
	331	1	0	0	0	0	1	1.0879595	-11.716962	110	1	1.12	0.95	104.4392	0.8288	0.0000	0.0000;
	332	1	13.163	3	0	0	1	1.0717376	-24.44176	110	1	1.12	0.95	113.0812	1.7989	0.0000	0.0000;
	333	1	6.075	0.5	0	0	1	1.0827711	-27.877945	110	1	1.12	0.95	114.6003	0.1579	0.0000	0.0000;
	334	1	16.809	4.85	0	0	1	1.1013502	-10.228285	110	1	1.12	0.95	102.3864	0.6624	0.0000	0.0000;
	335	1	9.113	2.5	0	0	1	1.0868846	-25.157472	110	1	1.12	0.95	112.4376	0.2464	0.0000	0.0000;
	336	1	18.226	5.4	0	0	1	1.0994453	-20.801044	110	1	1.12	0.95	107.6080	1.4490	0.0000	0.0000;
	337	1	18.226	5.4	0	0	1	1.066255	-22.67966	110	1	1.12	0.95	110.3789	2.6976	0.0000	0.0000;
	338	1	5.063	0	0	0	1	1.1022955	-22.813937	110	1	1.12	0.95	109.0050	-0.1773	0.0000	0.0000;
	339	1	0	0	0	0	1	1.1046819	-20.080211	110	1	1.12	0.95	106.7792	1.3767	0.0000	0.0000;
	340	1	0	0	0	0	1	1.0899742	-20.95313	110	1	1.12	0.95	107.7844	1.6077	0.0000	0.0000;
	341	1	18.733	5.5	0	0	1	1.0772887	-21.092738	110	1	1.12	0.95	109.4133	1.4229	0.0000	0.0000;
	342	1	16.809	3.9	0	0	1	1.077443	-21.101352	110	1	1.12	0.95	109.3971	1.4246	0.0000	0.0000;
	343	1	0	0	0	0	1	1.104894	-20.084456	110	1	1.12	0.95	106.7794	1.3609	0.0000	0.0000;
	344	1	6.075	0.5	0	0	1	1.0790817	-31.857635	110	1	1.12	0.95	118.5272	1.2808	0.0000	0.0000;
	345	2	12.151	3	0	0	1	1.0861626	-23.816386	110	1	1.12	0.95	112.3142	1.2420	0.0000	0.0000;
	346	1	8.708	0.701	0	0	1	1.0837149	-27.683007	110	1	1.12	0.95	114.7570	0.3664	0.0000	0.0000;
	347	1	19.138	5.52	0	0	1	1.1047753	-8.9093232	110	1	1.12	0.95	101.1426	0.8301	0.0000	0.0000;
	348	1	13.67	3.38	0	0	1	1.0706795	-22.140036	110	1	1.12	0.95	109.6964	2.7288	0.0000	0.0000;
	349	1	0	0	0	0	1	1.0765157	-21.012451	110	1	1.12	0.95	107.7242	2.6691	0.0000	0.0000;
	350	1	7.088	0.5	0	0	1	1.0966724	-25.228438	110	1	1.12	0.95	111.6195	0.4333	0.0000	0.0000;
	351	1	0	0	0	0	1	1.0893232	-21.600643	110	1	1.12	0.95	108.4609	1.9379	0.0000	0.0000;
	352	1	3.038	0.9	0	0	1	1.0841394	-21.283946	110	1	1.12	0.95	108.0735	2.1134	0.0000	0.0000;
	353	1	0	0	0	0	1	1.0868245	-21.20399	110	1	1.12	0.95	108.1935	2.0011	0.0000	0.0000;
	354	1	0	0	0	0	1	1.089301	-21.605022	110	1	1.12	0.95	108.4630	1.9381	0.0000	0.0000;
	355	1	10.429	2	0	0	1	1.0799102	-21.692406	110	1	1.12	0.95	109.6804	0.8694	0.0000	0.0000;
	356	1	11.138	1.5	0	0	1	1.0746149	-23.79664	110	1	1.12	0.95	112.5531	1.8065	0.0000	0.0000;
	357	1	14.581	1	0	0	1	1.0900619	-22.462541	110	1	1.12	0.95	109.2991	1.4546	0.0000	0.0000;
	358	1	0	0	0	0	1	1.0834692	-20.333486	110	1	1.12	0.95	106.7756	2.4568	0.0000	0.0000;
	359	1	0	0	0	0	1	1.0836043	-20.27189	110	1	1.12	0.95	106.7364	2.4501	0.0000	0.0000;
	360	1	6.076	1.5	0	0	1	1.0696922	-13.29816	110	1	1.12	0.95	105.3093	0.5272	0.0000	0.0000;
	361	1	8.303	1.2	0	0	1	1.1113018	-22.60262	110	1	1.12	0.95	109.5774	0.0717	0.0000	0.0000;
	362	2	45.566	19	0	0	1	1.1055075	-21.252842	110	1	1.12	0.95	107.3954	0.5000	0.0000	0.0000;
	363	2	45.566	15	0	0	1	1.0873463	-22.632272	110	1	1.12	0.95	109.5339	1.5579	0.0000	0.0000;
	364	2	91.131	30	0	0	1	1.115818	-20.193035	110	1	1.12	0.95	106.0017	0.0000	0.0000	0.0000;
	365	2	84.043	29	0	0	1	1.09759	-20.899867	110	1	1.12	0.95	108.6493	1.5359	0.0000	0.0000;
	366	1	0	0	0	0	1	1.12	-21.005477	110	1	1.12	0.95	106.2670	-0.7703	3444.8290	0.0000;
	367	1	8.101	0.2	0	0	1	1.0708508	-25.23416	110	1	1.12	0.95	113.3718	1.8153	0.0000	0.0000;
	368	2	18.53	1	0	0	1	1.088919	-25.623534	110	1	1.12	0.95	112.6460	0.3449	0.0000	0.0000;
	369	1	3.544	1	0	0	1	1.0901821	-28.306573	110	1	1.12	0.95	115.9121	0.7321	0.0000	0.0000;
	370	1	0	0	0	0	1	1.0995801	-24.915271	110	1	1.12	0.95	112.1730	0.2227	0.0000	0.0000;
	371	1	24.302	8	0	0	1	1.0615905	-24.878097	110	1	1.12	0.95	113.5010	2.5301	0.0000	0.0000;
	372	1	2.531	0.5	0	0	1	1.0936863	-10.590083	110	1	1.12	0.95	103.0131	0.9729	0.0000	0.0000;
	373	1	6.582	2.2	0	0	1	1.0994776	-11.030491	110	1	1.12	0.95	102.5457	0.7289	0.0000	0.0000;
	374	1	11.139	1.5	0	0	1	1.0698819	-31.467296	110	1	1.12	0.95	120.6664	1.4519	0.0000	0.0000;
	375	1	10.328	0.5	0	0	1	1.0836943	-27.491302	110	1	1.12	0.95	114.5057	0.4396	0.0000	0.0000;
	376	1	7.088	1.2	0	0	1	1.0701677	-12.81106	110	1	1.12	0.95	105.0030	0.7161	0.0000	0.0000;
	377	1	9.114	1.3	0	0	1	1.0702383	-12.831608	110	1	1.12	0.95	104.9983	0.7164	0.0000	0.0000;
	378	1	2.025	0.5	0	0	1	1.0637976	-24.822909	110	1	1.12	0.95	113.3161	2.4066	0.0000	0.0000;
	379	1	15.695	3.7	0	0	1	1.1127726	-22.298836	110	1	1.12	0.95	109.1494	0.0994	0.0000	0.0000;
	380	1	9.113	1.9	0	0	1	1.1131504	-22.223433	110	1	1.12	0.95	109.3070	0.0744	0.0000	0.0000;
	381	1	19.239	4.7	0	0	1	1.092277	-25.000436	110	1	1.12	0.95	111.9328	0.1970	0.0000	0.0000;
	382	2	0	30	0	0	1	1.1161726	-21.985043	110	1	1.12	0.95	108.8466	0.0000	0.0414	0.0000;
	383	2	0	0	0	0	1	1.1151454	-23.505648	110	1	1.12	0.95	109.5735	-0.1108	0.0000	0.0000;
	384	1	2.025	0.5	0	0	1	1.0954716	-26.123985	110	1	1.12	0.95	112.5042	0.5710	0.0000	0.0000;
	385	1	12.657	3	0	0	1	1.0988595	-20.637147	110	1	1.12	0.95	107.5722	1.5153	0.0000	0.0000;
	386	2	17.315	4.99	0	0	1	1.0938673	-11.590562	110	1	1.12	0.95	104.2076	0.5520	0.0000	0.0000;
	387	1	15.189	2.1	0	0	1	1.087938	-21.910671	110	1	1.12	0.95	108.8104	1.9230	0.0000	0.0000;
	388	1	15.381	6.02	0	0	1	1.1063153	-8.7633723	110	1	1.12	0.95	100.9555	0.7957	0.0000	0.0000;
	389	1	8.414	3.17	0	0	1	1.103239	-9.6641711	110	1	1.12	0.95	101.6544	0.5745	0.0000	0.0000;
	390	1	0	0	0	0	1	1.0976274	-3.0748063	110	1	1.12	0.95	98.5317	0.3486	0.0000	0.0000;
	391	1	0	0	0	0	1	1.085193	-0.57505785	110	1	1.12	0.95	98.0340	0.2180	0.0000	0.0000;
	392	1	2.025	0.3	0	0	1	1.0955769	-21.279088	110	1	1.12	0.95	109.0705	1.5623	0.0000	0.0000;
	393	1	2.531	0.5	0	0	1	1.1004817	-23.653171	110	1	1.12	0.95	111.0935	0.3628	0.0000	0.0000;
	394	1	7.088	1.4	0	0	1	1.1004924	-10.070298	110	1	1.12	0.95	102.3792	-0.1352	0.0000	0.0000;
	395	2	8.405	0.8	0	0	1	1.0923712	-22.168086	110	1	1.12	0.95	108.9058	1.4237	0.0000	0.0000;
	396	1	0	0	0	0	1	1.0996865	-20.797534	110	1	1.12	0.95	108.4971	1.4487	0.0000	0.0000;
	397	1	5.974	0.9	0	0	1	1.1081876	-21.181542	110	1	1.12	0.95	107.2327	0.3569	0.0000	0.0000;
	398	1	0	0	0	0	1	1.0890962	-22.769789	110	1	1.12	0.95	109.7300	1.4095	0.0000	0.0000;
	399	1	8.101	2	0	0	1	1.066483	-23.672925	110	1	1.12	0.95	111.6370	2.4583	0.0000	0.0000;
	400	1	5.569	1	0	0	1	1.0716387	-13.400832	110	1	1.12	0.95	105.1941	0.3328	0.0000	0.0000;
	401	1	26.53	6	0	0	1	1.0969793	-20.964261	110	1	1.12	0.95	107.9407	1.6986	0.0000	0.0000;
	402	1	44.755	6.5	0	0	1	1.0852281	-20.490214	110	1	1.12	0.95	107.9784	1.8723	0.0000	0.0000;
	403	1	12.151	2.2	0	0	1	1.098145	-5.5228496	110	1	1.12	0.95	99.5139	0.5193	0.0000	0.0000;
	404	1	8.101	1.2	0	0	1	1.0622074	-3.6291426	110	1	1.12	0.95	100.3514	0.6671	0.0000	0.0000;
	405	1	11.138	1	0	0	1	1.0922774	-27.883292	110	1	1.12	0.95	115.0644	0.6779	0.0000	0.0000;
	406	1	10.125	1.5	0	0	1	1.0977283	-5.3331316	110	1	1.12	0.95	99.4459	0.5148	0.0000	0.0000;
	407	1	14.277	0.4	0	0	1	1.0907927	-22.377065	110	1	1.12	0.95	109.1826	1.4420	0.0000	0.0000;
	408	1	10.126	2	0	0	1	1.0837336	-18.224435	110	1	1.12	0.95	106.9076	1.4401	0.0000	0.0000;
	409	1	3.544	0.301	0	0	1	1.0890545	-22.769091	110	1	1.12	0.95	109.7299	1.4121	0.0000	0.0000;
	410	1	0	0	0	0	1	1.12	-20.114085	110	1	1.12	0.95	105.8513	-0.1975	2792.9374	0.0000;
	411	1	0	0	0	0	1	1.0898451	-22.450382	110	1	1.12	0.95	109.2904	1.4724	0.0000	0.0000;
	412	1	26.327	5.999	0	0	1	1.0628965	-3.4532053	110	1	1.12	0.95	100.2782	0.6735	0.0000	0.0000;
	413	1	9.113	2.5	0	0	1	1.0619563	-24.885422	110	1	1.12	0.95	113.5171	2.5124	0.0000	0.0000;
	414	1	5.569	0.399	0	0	1	1.0916341	-22.26741	110	1	1.12	0.95	109.0345	1.4323	0.0000	0.0000;
	415	1	20.555	0.8	0	0	1	1.0718642	-24.051357	110	1	1.12	0.95	112.4872	2.1558	0.0000	0.0000;
	416	1	4.05	0.8	0	0	1	1.1011073	-10.03271	110	1	1.12	0.95	102.2933	-0.1513	0.0000	0.0000;
	417	1	8.708	2	0	0	1	1.1095089	-22.499373	110	1	1.12	0.95	109.5311	0.2270	0.0000	0.0000;
	418	1	19.239	5.7	0	0	1	1.0665206	-22.538422	110	1	1.12	0.95	110.0641	2.7637	0.0000	0.0000;
	419	1	19.239	5.7	0	0	1	1.066464	-22.547485	110	1	1.12	0.95	110.0686	2.7648	0.0000	0.0000;
	420	1	7.088	4.1	0	0	1	1.076654	-23.053999	110	1	1.12	0.95	110.5339	2.1755	0.0000	0.0000;
	421	2	16.201	1.7	0	0	1	1.0793351	-22.718916	110	1	1.12	0.95	110.1731	2.1108	0.0000	0.0000;
	422	1	14.48	2	0	0	1	1.0912175	-25.711145	110	1	1.12	0.95	112.6656	0.3348	0.0000	0.0000;
	423	1	11.543	0.2	0	0	1	1.0747462	-24.422506	110	1	1.12	0.95	113.4685	1.8455	0.0000	0.0000;
	424	1	20.758	5	0	0	1	1.0524975	-24.039847	110	1	1.12	0.95	112.2426	3.1358	0.0000	0.0000;
	425	1	11.138	2	0	0	1	1.0817006	-22.395335	110	1	1.12	0.95	109.7557	2.0794	0.0000	0.0000;
	426	2	8.252	2.4	0	0	1	1.1041286	-8.9992914	110	1	1.12	0.95	101.2521	0.8344	0.0000	0.0000;
	427	1	8.252	2.4	0	0	1	1.1041135	-9.0024504	110	1	1.12	0.95	101.2533	0.8346	0.0000	0.0000;
	428	1	11.138	2	0	0	1	1.0612731	-3.4151272	110	1	1.12	0.95	101.2579	0.7042	0.0000	0.0000;
	429	1	7.898	0.5	0	0	1	1.0903496	-22.509101	110	1	1.12	0.95	109.3869	1.4205	0.0000	0.0000;
	430	1	10.632	0.8	0	0	1	1.0873007	-12.639282	110	1	1.12	0.95	104.9386	0.6953	0.0000	0.0000;
	431	2	11.341	0.8	0	0	1	1.1055765	-23.213181	110	1	1.12	0.95	109.5608	-0.0000	0.0000	0.0000;
	432	1	9.417	2.72	0	0	1	1.09887	-10.457492	110	1	1.12	0.95	102.8911	0.6430	0.0000	0.0000;
	433	1	5.569	2	0	0	1	1.0375139	-25.153637	110	1	1.12	0.95	114.3218	3.7519	0.0000	0.0000;
	434	1	8.101	2	0	0	1	1.0743751	-26.261117	110	1	1.12	0.95	114.6550	0.5071	0.0000	0.0000;
	435	1	0	0	0	0	1	1.0914761	-8.0302426	110	1	1.12	0.95	101.1523	-0.4060	0.0000	0.0000;
	436	1	21.839	3.559	0	0	1	1.0599827	-3.5566949	110	1	1.12	0.95	101.4372	0.7290	0.0000	0.0000;
	437	1	11.138	0.5	0	0	1	1.0538287	-33.860159	110	1	1.12	0.95	124.9651	1.6367	0.0000	0.0000;
	438	1	2.025	0.5	0	0	1	1.0818069	-0.21294692	110	1	1.12	0.95	97.9207	0.2932	0.0000	0.0000;
	439	1	5.064	1.2	0	0	1	1.0817739	-0.23455298	110	1	1.12	0.95	97.9265	0.2943	0.0000	0.0000;
	440	2	6.075	0.999	0	0	1	1.0608061	-3.4742098	110	1	1.12	0.95	101.3275	0.7112	0.0000	0.0000;
	441	1	4.557	0.8	0	0	1	1.0488406	-5.2564271	110	1	1.12	0.95	102.3647	0.9103	0.0000	0.0000;
	442	1	8.101	2.63	0	0	1	1.0954622	-10.366368	110	1	1.12	0.95	102.5950	0.8012	0.0000	0.0000;
	443	1	19.239	5.55	0	0	1	1.0940037	-11.121322	110	1	1.12	0.95	103.6666	0.7007	0.0000	0.0000;
	444	1	6.075	1	0	0	1	1.1046703	-7.4195557	110	1	1.12	0.95	100.2359	-2.2201	0.0000	0.0000;
	445	1	3.544	0.5	0	0	1	1.0883556	-13.483084	110	1	1.12	0.95	105.0389	0.5765	0.0000	0.0000;
	446	1	9.113	2	0	0	1	1.0934603	-10.060684	110	1	1.12	0.95	102.8507	-0.2918	0.0000	0.0000;
	447	2	15.925	1.2	0	0	1	1.0885828	-21.903819	110	1	1.12	0.95	109.2894	0.0001	0.0000	0.0000;
	448	1	8.303	0.5	0	0	1	1.0890906	-21.217575	110	1	1.12	0.95	108.5780	-0.0397	0.0000	0.0000;
	449	2	19.441	5.2	0	0	1	1.0903299	-20.455105	110	1	1.12	0.95	107.7719	-0.0999	0.0000	0.0000;
	450	1	5.063	0.5	0	0	1	1.0503357	-34.103769	110	1	1.12	0.95	125.7987	1.6134	0.0000	0.0000;
	451	1	7.594	1.4	0	0	1	1.0687786	-24.69344	110	1	1.12	0.95	113.3019	2.1456	0.0000	0.0000;
	452	1	24.302	4	0	0	1	1.0838249	-21.010364	110	1	1.12	0.95	108.3663	1.9665	0.0000	0.0000;
	453	1	2.228	0.2	0	0	1	1.1158042	-5.9466149	110	1	1.12	0.95	98.3589	-3.2734	0.0000	0.0000;
	454	1	17.72	1	0	0	1	1.0866279	-11.71919	110	1	1.12	0.95	104.3104	1.0156	0.0000	0.0000;
	455	1	10.632	1.5	0	0	1	1.0774173	-24.309969	110	1	1.12	0.95	111.4107	1.8234	0.0000	0.0000;
	456	1	21.264	10	0	0	1	1.0860049	-21.240085	110	1	1.12	0.95	108.2009	1.7774	0.0000	0.0000;
	457	1	4.861	0.2	0	0	1	1.0819729	-24.213466	110	1	1.12	0.95	111.7344	1.3101	0.0000	0.0000;
	458	1	6.38	0.8	0	0	1	1.089068	-12.871572	110	1	1.12	0.95	105.7721	0.4296	0.0000	0.0000;
	459	1	17.214	2	0	0	1	1.0781476	-23.532496	110	1	1.12	0.95	112.3049	-0.0723	0.0000	0.0000;
	460	1	11.645	4	0	0	1	1.1079386	-13.981857	110	1	1.12	0.95	102.8682	0.1183	0.0000	0.0000;
	461	1	16.201	2.2	0	0	1	1.09099	-22.786422	110	1	1.12	0.95	109.4377	1.5100	0.0000	0.0000;
	462	1	11.138	2	0	0	1	1.0910686	-22.757884	110	1	1.12	0.95	109.4267	1.5100	0.0000	0.0000;
	463	2	17.213	4.1	0	0	1	1.0824579	-23.648535	110	1	1.12	0.95	111.1153	0.2129	0.0000	0.0000;
	464	1	18.733	3	0	0	1	1.0815029	-10.409803	110	1	1.12	0.95	103.8752	-0.1406	0.0000	0.0000;
	465	1	8.809	0.8	0	0	1	1.1069959	-22.515885	110	1	1.12	0.95	108.4547	0.1423	0.0000	0.0000;
	466	1	13.568	3.91	0	0	1	1.1025777	-9.8833732	110	1	1.12	0.95	101.8774	0.5849	0.0000	0.0000;
	467	1	5.569	1.5	0	0	1	1.0965149	-15.940939	110	1	1.12	0.95	104.5649	-0.2505	0.0000	0.0000;
	468	1	8.404	2.42	0	0	1	1.0893596	-11.543008	110	1	1.12	0.95	104.2223	0.8205	0.0000	0.0000;
	469	1	3.24	0.3	0	0	1	1.0862273	-22.371927	110	1	1.12	0.95	110.4072	1.8080	0.0000	0.0000;
	470	1	4.05	0.4	0	0	1	1.0579265	-4.1795533	110	1	1.12	0.95	100.9867	0.7462	0.0000	0.0000;
	471	1	21.264	2	0	0	1	1.057564	-33.742044	110	1	1.12	0.95	124.2037	1.6440	0.0000	0.0000;
	472	1	1.013	0.5	0	0	1	1.0769861	-21.127612	110	1	1.12	0.95	109.4675	1.4274	0.0000	0.0000;
	473	1	1.013	0	0	0	1	1.0795427	-21.819931	110	1	1.12	0.95	109.0324	1.9452	0.0000	0.0000;
	474	1	12.151	1	0	0	1	1.1009506	-29.861214	110	1	1.12	0.95	115.7588	1.1508	0.0000	0.0000;
	475	1	4.962	0.5	0	0	1	1.0991473	-22.216206	110	1	1.12	0.95	108.5752	0.8667	0.0000	0.0000;
	476	1	2.531	0.5	0	0	1	1.0740571	-13.293692	110	1	1.12	0.95	104.9109	0.1958	0.0000	0.0000;
	477	1	18.226	5.5	0	0	1	1.0816113	-22.305058	110	1	1.12	0.95	110.6164	2.0126	0.0000	0.0000;
	478	1	17.214	4.96	0	0	1	1.100223	-10.622107	110	1	1.12	0.95	102.9756	0.5357	0.0000	0.0000;
	479	1	9.114	2	0	0	1	1.0845465	-23.264912	110	1	1.12	0.95	110.7130	1.5868	0.0000	0.0000;
	480	1	4.658	0.4	0	0	1	1.0851971	-27.69859	110	1	1.12	0.95	114.3185	0.2148	0.0000	0.0000;
	481	1	11.138	2	0	0	1	1.025482	-25.700033	110	1	1.12	0.95	116.0129	4.4517	0.0000	0.0000;
	482	2	7.594	1	0	0	1	1.0504927	-5.135625	110	1	1.12	0.95	102.0959	0.8760	0.0000	0.0000;
	483	1	7.088	1	0	0	1	1.0778438	-9.5551781	110	1	1.12	0.95	102.9145	0.8292	0.0000	0.0000;
	484	1	9.873	1.5	0	0	1	1.0477871	-5.345681	110	1	1.12	0.95	102.5349	0.9304	0.0000	0.0000;
	485	1	9.873	1.5	0	0	1	1.0765487	-9.6713079	110	1	1.12	0.95	103.1038	0.8560	0.0000	0.0000;
	486	1	4.051	1.1	0	0	1	1.12	-5.3020181	110	1	1.12	0.95	97.7355	-3.7217	9039.0289	0.0000;
	487	1	1.519	0.6	0	0	1	1.1102332	-5.3581443	110	1	1.12	0.95	99.0518	-0.4676	0.0000	0.0000;
	488	1	0	0	0	0	1	1.0770516	-9.629522	110	1	1.12	0.95	103.0300	0.8451	0.0000	0.0000;
	489	1	0	0	0	0	1	1.0770332	-9.6334957	110	1	1.12	0.95	103.0315	0.8453	0.0000	0.0000;
	490	2	2.025	0.6	0	0	1	1.0866462	-21.182608	110	1	1.12	0.95	108.2075	1.9900	0.0000	0.0000;
	491	1	8.101	8.8	0	0	1	1.0855319	-21.269419	110	1	1.12	0.95	108.2914	2.0555	0.0000	0.0000;
	492	1	8.101	0.5	0	0	1	1.1075127	-22.121489	110	1	1.12	0.95	107.7193	0.0048	0.0000	0.0000;
	493	1	22.277	6.6	0	0	1	1.0725075	-22.055817	110	1	1.12	0.95	109.4159	2.5593	0.0000	0.0000;
	494	1	22.277	6.6	0	0	1	1.072729	-22.028586	110	1	1.12	0.95	109.4030	2.5551	0.0000	0.0000;
	495	1	29.365	8.7	0	0	1	1.0839021	-21.894604	110	1	1.12	0.95	108.8974	2.0106	0.0000	0.0000;
	496	1	34.428	8.5	0	0	1	1.0674284	-22.482471	110	1	1.12	0.95	110.3110	2.8057	0.0000	0.0000;
	497	1	2.025	0.5	0	0	1	1.0665205	-24.554909	110	1	1.12	0.95	112.8215	2.3040	0.0000	0.0000;
	498	1	9.113	2	0	0	1	1.0777838	-24.267579	110	1	1.12	0.95	111.3557	1.8158	0.0000	0.0000;
	499	1	9.62	1	0	0	1	1.0806412	-24.626718	110	1	1.12	0.95	112.4463	0.1530	0.0000	0.0000;
	500	1	10.126	3	0	0	1	1.0675758	-22.315593	110	1	1.12	0.95	109.7970	2.7740	0.0000	0.0000;
	501	1	42.528	12.6	0	0	1	1.0715612	-22.535167	110	1	1.12	0.95	110.0731	2.4144	0.0000	0.0000;
	502	1	18.226	5.4	0	0	1	1.070653	-22.233799	110	1	1.12	0.95	109.8584	2.6792	0.0000	0.0000;
	503	1	17.214	5.1	0	0	1	1.0675624	-22.422167	110	1	1.12	0.95	109.9400	2.7357	0.0000	0.0000;
	504	1	22.276	5.5	0	0	1	1.0743905	-22.346379	110	1	1.12	0.95	109.8031	2.3099	0.0000	0.0000;
	505	1	7.088	1	0	0	1	1.043364	-35.605875	110	1	1.12	0.95	127.7067	1.6216	0.0000	0.0000;
	506	1	25.314	7.5	0	0	1	1.0750437	-21.335498	110	1	1.12	0.95	108.3074	2.6978	0.0000	0.0000;
	507	1	55.691	16.5	0	0	1	1.0768364	-20.97435	110	1	1.12	0.95	107.6668	2.6612	0.0000	0.0000;
	508	1	2.025	0.501	0	0	1	1.1051173	-6.0529168	110	1	1.12	0.95	99.6077	-0.4430	0.0000	0.0000;
	509	1	3.544	0.7	0	0	1	1.1050778	-6.0659983	110	1	1.12	0.95	99.6086	-0.4440	0.0000	0.0000;
	510	1	23.593	7.67	0	0	1	1.1043139	-9.9084657	110	1	1.12	0.95	101.8380	0.5987	0.0000	0.0000;
	511	1	0	0	0	0	1	1.1034109	-9.4386945	110	1	1.12	0.95	101.6646	0.7772	0.0000	0.0000;
	512	1	2.025	0.5	0	0	1	1.0657552	-24.659753	110	1	1.12	0.95	112.9928	2.3342	0.0000	0.0000;
	513	1	4.05	0.5	0	0	1	1.1016089	-23.920583	110	1	1.12	0.95	110.4400	0.1900	0.0000	0.0000;
	514	1	13.163	3.25	0	0	1	1.0815442	-21.517093	110	1	1.12	0.95	108.3787	2.1889	0.0000	0.0000;
	515	1	12.151	3	0	0	1	1.0816134	-21.506695	110	1	1.12	0.95	108.3739	2.1877	0.0000	0.0000;
	516	1	7.088	2.1	0	0	1	1.0679239	-22.552475	110	1	1.12	0.95	110.4714	2.7656	0.0000	0.0000;
	517	1	7.088	2.1	0	0	1	1.0705745	-22.50033	110	1	1.12	0.95	110.0283	2.4346	0.0000	0.0000;
	518	1	22.277	5.5	0	0	1	1.0783669	-20.890275	110	1	1.12	0.95	107.6360	2.6077	0.0000	0.0000;
	519	1	13.163	3.25	0	0	1	1.0810195	-21.563978	110	1	1.12	0.95	108.4411	2.2041	0.0000	0.0000;
	520	1	13.164	3.25	0	0	1	1.0845595	-21.398581	110	1	1.12	0.95	108.4577	2.0687	0.0000	0.0000;
	521	1	20.758	3.8	0	0	1	1.0393985	-25.0589	110	1	1.12	0.95	114.0419	3.6605	0.0000	0.0000;
	522	2	25.314	2.5	0	0	1	1.0912397	-7.7388705	110	1	1.12	0.95	101.7872	-0.2246	0.0000	0.0000;
	523	1	50.629	12.5	0	0	1	1.0839257	-21.912454	110	1	1.12	0.95	108.8616	2.0282	0.0000	0.0000;
	524	1	21.264	5.25	0	0	1	1.0860077	-20.992884	110	1	1.12	0.95	108.2990	1.8193	0.0000	0.0000;
	525	1	54.679	16.2	0	0	1	1.0850968	-21.686974	110	1	1.12	0.95	109.0182	1.9443	0.0000	0.0000;
	526	1	15.189	4.5	0	0	1	1.0735571	-22.200275	110	1	1.12	0.95	109.9178	2.5455	0.0000	0.0000;
	527	1	11.138	1.5	0	0	1	1.0365255	-25.221818	110	1	1.12	0.95	114.4680	3.7981	0.0000	0.0000;
	528	1	3.038	0.75	0	0	1	1.0839088	-21.915872	110	1	1.12	0.95	108.8650	2.0283	0.0000	0.0000;
	529	1	3.038	0.75	0	0	1	1.0664465	-22.551009	110	1	1.12	0.95	110.0723	2.7649	0.0000	0.0000;
	530	1	46.578	13.8	0	0	1	1.0873763	-21.64238	110	1	1.12	0.95	108.9229	1.8253	0.0000	0.0000;
	531	1	10.125	3	0	0	1	1.0831344	-21.573096	110	1	1.12	0.95	108.5268	2.0304	0.0000	0.0000;
	532	1	34.428	10.2	0	0	1	1.0833896	-21.600002	110	1	1.12	0.95	108.5593	2.0037	0.0000	0.0000;
	533	2	5.67	0.5	0	0	1	1.0966233	-22.367736	110	1	1.12	0.95	108.8685	1.0847	0.0000	0.0000;
	534	2	89.009	23.701	0	0	1	1.0979802	-21.069235	110	1	1.12	0.95	107.9674	1.4176	0.0000	0.0000;
	535	2	59.092	19.8	0	0	1	1.0928562	-21.12968	110	1	1.12	0.95	107.8909	1.6074	0.0000	0.0000;
	536	1	11.138	3.3	0	0	1	1.0920964	-21.179454	110	1	1.12	0.95	107.9824	1.6341	0.0000	0.0000;
	537	1	17.214	5.1	0	0	1	1.0968069	-21.145394	110	1	1.12	0.95	108.1072	1.4586	0.0000	0.0000;
	538	1	29.365	7.25	0	0	1	1.0713767	-22.198899	110	1	1.12	0.95	109.8165	2.6431	0.0000	0.0000;
	539	1	25.315	6.25	0	0	1	1.0837837	-21.912625	110	1	1.12	0.95	108.9023	2.0187	0.0000	0.0000;
	540	1	25.315	6.25	0	0	1	1.0838138	-21.911786	110	1	1.12	0.95	108.8946	2.0201	0.0000	0.0000;
	541	1	35.44	8.75	0	0	1	1.0912754	-21.448831	110	1	1.12	0.95	108.6087	1.6689	0.0000	0.0000;
	542	1	48.604	14.4	0	0	1	1.0659634	-22.590077	110	1	1.12	0.95	110.2604	2.7311	0.0000	0.0000;
	543	1	44.553	13.2	0	0	1	1.0843278	-21.86499	110	1	1.12	0.95	108.8169	2.0187	0.0000	0.0000;
	544	1	15.695	4.65	0	0	1	1.0673488	-22.237075	110	1	1.12	0.95	109.6706	2.8166	0.0000	0.0000;
	545	1	16.202	4.8	0	0	1	1.0846285	-21.340367	110	1	1.12	0.95	108.3907	2.0847	0.0000	0.0000;
	546	1	16.202	4.8	0	0	1	1.0915652	-21.416983	110	1	1.12	0.95	108.5277	1.8642	0.0000	0.0000;
	547	1	41.516	10.25	0	0	1	1.0909476	-21.519575	110	1	1.12	0.95	108.6543	1.6690	0.0000	0.0000;
	548	1	19.239	5.7	0	0	1	1.0822841	-21.482646	110	1	1.12	0.95	108.6981	2.1909	0.0000	0.0000;
	549	2	47.591	14.1	0	0	1	1.0692294	-22.485666	110	1	1.12	0.95	110.3849	2.7098	0.0000	0.0000;
	550	1	4.05	1.2	0	0	1	1.0666331	-22.499797	110	1	1.12	0.95	110.1043	2.7503	0.0000	0.0000;
	551	1	16.708	3.1	0	0	1	1.0915285	-24.481836	110	1	1.12	0.95	112.3780	0.5824	0.0000	0.0000;
	552	1	5.569	1.5	0	0	1	1.0930027	-30.669619	110	1	1.12	0.95	116.7588	1.2396	0.0000	0.0000;
	553	1	16.201	2.5	0	0	1	1.0930216	-24.58093	110	1	1.12	0.95	111.3073	0.2227	0.0000	0.0000;
	554	1	5.063	1	0	0	1	1.0908567	-24.524208	110	1	1.12	0.95	112.4849	0.6013	0.0000	0.0000;
	555	1	1.013	0.5	0	0	1	1.0819768	-25.753387	110	1	1.12	0.95	113.3891	0.2988	0.0000	0.0000;
	556	1	0	0	0	0	1	1.0160832	-25.93821	110	1	1.12	0.95	117.0351	5.2040	0.0000	0.0000;
	557	2	54.348	19.9	0	0	1	1.0706214	-22.164366	110	1	1.12	0.95	109.7380	2.7262	0.0000	0.0000;
	558	2	49.364	16.7	0	0	1	1.0678891	-22.278967	110	1	1.12	0.95	109.7338	2.7695	0.0000	0.0000;
	559	1	0	0	0	0	1	1.082453	-24.130272	110	1	1.12	0.95	111.6309	1.3100	0.0000	0.0000;
	560	1	0	0	0	0	1	1.0857666	-21.723249	110	1	1.12	0.95	108.7006	1.9279	0.0000	0.0000;
	561	1	0	0	0	0	1	1.0602783	-23.368104	110	1	1.12	0.95	111.2757	2.8384	0.0000	0.0000;
	562	1	0	0	0	0	1	1.0948009	-10.876399	110	1	1.12	0.95	103.3433	0.7173	0.0000	0.0000;
	563	1	11.645	1.8	0	0	1	1.0979133	-20.575579	110	1	1.12	0.95	107.4180	1.6181	0.0000	0.0000;
	564	1	10.126	1.5	0	0	1	1.0672963	-22.624122	110	1	1.12	0.95	110.5681	2.7792	0.0000	0.0000;
	565	1	5.57	1	0	0	1	1.0600503	-23.393754	110	1	1.12	0.95	111.3085	2.8440	0.0000	0.0000;
	566	1	4.455	0.5	0	0	1	1.106908	-22.939432	110	1	1.12	0.95	110.2006	0.2142	0.0000	0.0000;
	567	1	18.227	3	0	0	1	1.0927537	-24.843064	110	1	1.12	0.95	111.8824	0.2602	0.0000	0.0000;
	568	1	6.582	1.5	0	0	1	1.0846389	-9.1414639	110	1	1.12	0.95	102.9677	-0.1227	0.0000	0.0000;
	569	2	15.189	1.5	0	0	1	1.0917409	-9.9217063	110	1	1.12	0.95	102.8329	-0.3538	0.0000	0.0000;
	570	1	13.396	5.24	0	0	1	1.0986158	-10.734109	110	1	1.12	0.95	103.1508	0.5717	0.0000	0.0000;
	571	1	5.741	2.25	0	0	1	1.0988021	-10.72934	110	1	1.12	0.95	103.1468	0.5689	0.0000	0.0000;
	572	1	7.594	0.6	0	0	1	1.0869072	-10.209979	110	1	1.12	0.95	103.3632	-0.2612	0.0000	0.0000;
	573	1	0	0	0	0	1	1.1046346	-9.0107917	110	1	1.12	0.95	101.2535	0.8051	0.0000	0.0000;
	574	1	7.088	1.5	0	0	1	1.0889564	-4.0061698	110	1	1.12	0.95	99.5925	0.5209	0.0000	0.0000;
	575	1	7.088	2.1	0	0	1	1.0850259	-21.357441	110	1	1.12	0.95	108.4024	2.0552	0.0000	0.0000;
	576	1	0.304	0.09	0	0	1	1.0754991	-21.276556	110	1	1.12	0.95	108.2142	2.6863	0.0000	0.0000;
	577	1	7.615	2	0	0	1	1.0868033	-13.097026	110	1	1.12	0.95	105.0983	0.6651	0.0000	0.0000;
	578	1	11.24	0.8	0	0	1	1.0934618	-25.467389	110	1	1.12	0.95	111.9107	0.3036	0.0000	0.0000;
	579	1	5.772	1.66	0	0	1	1.0966418	-10.876812	110	1	1.12	0.95	103.3296	0.6268	0.0000	0.0000;
	580	1	2.228	0.5	0	0	1	1.0802911	-24.471182	110	1	1.12	0.95	112.3482	0.1381	0.0000	0.0000;
	581	2	9.923	0.9	0	0	1	1.0783901	-24.409698	110	1	1.12	0.95	112.5024	1.3177	0.0000	0.0000;
	582	1	17.72	1.5	0	0	1	1.0744065	-23.978556	110	1	1.12	0.95	112.7623	1.6949	0.0000	0.0000;
	583	1	0	0	0	0	1	1.0903167	-14.909063	110	2	1.12	0.95	104.3913	-0.0856	0.0000	0.0000;
	584	1	9.82	1.5	0	0	1	1.0903947	-14.903205	110	2	1.12	0.95	104.3915	-0.0868	0.0000	0.0000;
	585	1	3.036	0.6	0	0	1	1.0714349	-15.668392	110	2	1.12	0.95	106.2719	0.1876	0.0000	0.0000;
	586	1	8.251	1	0	0	1	1.081422	-16.642691	110	2	1.12	0.95	106.1252	-0.0897	0.0000	0.0000;
	587	1	11.412	0.2	0	0	1	1.0600887	-16.77334	110	2	1.12	0.95	106.2697	0.1142	0.0000	0.0000;
	588	1	7.538	0.4	0	0	1	1.0796977	-16.067232	110	2	1.12	0.95	106.2574	0.0641	0.0000	0.0000;
	589	1	20.103	0	0	0	1	1.0724151	-14.898957	110	2	1.12	0.95	105.1642	0.0382	0.0000	0.0000;
	590	1	0	0	0	0	1	1.0723909	-14.905249	110	2	1.12	0.95	105.1716	0.0395	0.0000	0.0000;
	591	1	20.94	4	0	0	1	1.079368	-16.873902	110	2	1.12	0.95	106.3919	-0.0867	0.0000	0.0000;
	592	1	6.282	1	0	0	1	1.0957152	-13.938723	110	2	1.12	0.95	104.2524	0.3598	0.0000	0.0000;
	593	1	4.815	1.6	0	0	1	1.0497493	-16.175487	110	2	1.12	0.95	107.9200	0.6924	0.0000	0.0000;
	594	2	16.125	3.7	0	0	1	1.0743078	-16.563897	110	2	1.12	0.95	107.2664	0.0405	0.0000	0.0000;
	595	1	6.072	0.5	0	0	1	1.0733651	-16.657511	110	2	1.12	0.95	107.3554	0.0483	0.0000	0.0000;
	596	1	8.376	1	0	0	1	1.0709913	-14.38472	110	2	1.12	0.95	105.9283	0.3450	0.0000	0.0000;
	597	1	10.994	0.5	0	0	1	1.0956621	-17.410493	110	2	1.12	0.95	104.0686	-1.4901	0.0000	0.0000;
	598	1	15.181	1.2	0	0	1	1.0938665	-17.603462	110	2	1.12	0.95	104.3917	-1.4125	0.0000	0.0000;
	599	1	3.454	0.2	0	0	1	1.0612723	-17.495617	110	2	1.12	0.95	107.9601	0.1707	0.0000	0.0000;
	600	1	4.606	0	0	0	1	1.0733488	-16.391723	110	2	1.12	0.95	107.3952	0.2552	0.0000	0.0000;
	601	2	36.017	6.8	0	0	1	1.0700414	-17.017134	110	2	1.12	0.95	107.4639	0.1573	0.0000	0.0000;
	602	1	14.657	2	0	0	1	1.0755578	-12.677755	110	2	1.12	0.95	104.5941	0.0785	0.0000	0.0000;
	603	1	5.235	0	0	0	1	1.0763235	-12.670694	110	2	1.12	0.95	104.4468	0.0855	0.0000	0.0000;
	604	1	7.643	0.9	0	0	1	1.079775	-16.049079	110	2	1.12	0.95	105.9973	0.0512	0.0000	0.0000;
	605	1	10.051	0.6	0	0	1	1.0586114	-16.862291	110	2	1.12	0.95	106.2555	0.1515	0.0000	0.0000;
	606	1	0	0	0	0	1	1.0814129	-17.524782	110	2	1.12	0.95	106.9014	-0.3488	0.0000	0.0000;
	607	1	24.636	5	0	0	1	1.0755623	-17.900532	110	2	1.12	0.95	107.7437	-0.1766	0.0000	0.0000;
	608	1	10.365	0	0	0	1	1.0801881	-17.697572	110	2	1.12	0.95	107.1334	-0.3483	0.0000	0.0000;
	609	1	0	0	0	0	1	1.0856101	-13.595348	110	2	1.12	0.95	103.7714	-0.0611	0.0000	0.0000;
	610	1	0	0	0	0	1	1.0829672	-13.576517	110	2	1.12	0.95	103.9014	-0.0061	0.0000	0.0000;
	611	1	11.412	0	0	0	1	1.0801973	-17.716907	110	2	1.12	0.95	107.1409	-0.3486	0.0000	0.0000;
	612	1	5.235	0	0	0	1	1.0833182	-13.78653	110	2	1.12	0.95	104.2799	0.2653	0.0000	0.0000;
	613	1	0	0	0	0	1	1.0813632	-17.52352	110	2	1.12	0.95	106.9014	-0.3441	0.0000	0.0000;
	614	1	0	0	0	0	1	1.0812954	-17.539882	110	2	1.12	0.95	106.9060	-0.3457	0.0000	0.0000;
	615	1	7.329	0	0	0	1	1.0771847	-12.636072	110	2	1.12	0.95	104.4886	-0.0386	0.0000	0.0000;
	616	1	9.109	0.3	0	0	1	1.0798114	-17.756401	110	2	1.12	0.95	107.2108	-0.3485	0.0000	0.0000;
	617	1	12.596	1	0	0	1	1.0791039	-16.132681	110	2	1.12	0.95	107.0158	0.2945	0.0000	0.0000;
	618	1	4.188	1	0	0	1	1.1001047	-13.817863	110	2	1.12	0.95	103.6963	0.2638	0.0000	0.0000;
	619	1	3.141	0	0	0	1	1.0721124	-13.234528	110	2	1.12	0.95	105.0554	0.6048	0.0000	0.0000;
	620	1	8.899	0.7	0	0	1	1.0681223	-15.849678	110	2	1.12	0.95	105.9129	0.0180	0.0000	0.0000;
	621	1	2.618	0.5	0	0	1	1.0781702	-11.864153	110	2	1.12	0.95	104.1514	0.0295	0.0000	0.0000;
	622	2	0	-0.002	0	0	1	1.0860482	-13.868615	110	2	1.12	0.95	104.0950	0.0001	0.0000	0.0000;
	623	1	6.282	1.4	0	0	1	1.0690284	-15.89258	110	2	1.12	0.95	106.6386	0.2456	0.0000	0.0000;
	624	1	20.94	8	0	0	1	1.0867577	-18.490334	110	2	1.12	0.95	106.2301	1.8268	0.0000	0.0000;
	625	1	3.664	1	0	0	1	1.0828676	-12.217616	110	2	1.12	0.95	103.0850	0.1534	0.0000	0.0000;
	626	2	9.591	2.52	0	0	1	1.0858207	-15.493512	110	2	1.12	0.95	104.7709	-0.0510	0.0000	0.0000;
	627	1	12.041	2.9	0	0	1	1.0691314	-15.903449	110	2	1.12	0.95	106.6206	0.2426	0.0000	0.0000;
	628	1	5.655	6.3	0	0	1	1.0853574	-12.041492	110	2	1.12	0.95	102.6085	0.1596	0.0000	0.0000;
	629	1	13.088	1	0	0	1	1.04819	-16.986831	110	2	1.12	0.95	108.2839	0.5134	0.0000	0.0000;
	630	2	10.994	3.3	0	0	1	1.0760556	-17.766184	110	2	1.12	0.95	107.4721	0.0013	0.0000	0.0000;
	631	2	17.485	4.7	0	0	1	1.0763064	-17.727849	110	2	1.12	0.95	107.4263	0.0001	0.0000	0.0000;
	632	1	11.517	2.5	0	0	1	1.0717743	-15.61312	110	2	1.12	0.95	106.0421	0.2315	0.0000	0.0000;
	633	1	0.209	0	0	0	1	1.0682443	-15.885285	110	2	1.12	0.95	106.3588	0.0336	0.0000	0.0000;
	634	1	7.538	1.5	0	0	1	1.0971442	-17.395944	110	2	1.12	0.95	103.8528	-1.4779	0.0000	0.0000;
	635	1	4.711	0.5	0	0	1	1.057794	-16.774286	110	2	1.12	0.95	106.1016	0.1726	0.0000	0.0000;
	636	1	5.235	1	0	0	1	1.0779565	-14.468431	110	2	1.12	0.95	105.1616	0.2720	0.0000	0.0000;
	637	1	13.297	4.5	0	0	1	1.0677862	-16.90579	110	2	1.12	0.95	107.6081	0.1122	0.0000	0.0000;
	638	1	13.506	0.4	0	0	1	1.0552952	-18.658466	110	2	1.12	0.95	110.0763	0.1827	0.0000	0.0000;
	639	1	3.141	0	0	0	1	1.0765915	-11.337385	110	2	1.12	0.95	104.0352	-0.2195	0.0000	0.0000;
	640	1	10.47	0	0	0	1	1.0769173	-11.543949	110	2	1.12	0.95	104.0821	-0.1952	0.0000	0.0000;
	641	1	7.329	1	0	0	1	1.090092	-14.424574	110	2	1.12	0.95	104.6834	0.3536	0.0000	0.0000;
	642	1	3.036	0.9	0	0	1	1.1003144	-16.485486	110	2	1.12	0.95	102.9821	-1.8268	0.0000	0.0000;
	643	1	4.815	0.2	0	0	1	1.0587217	-18.085108	110	2	1.12	0.95	109.4341	0.1903	0.0000	0.0000;
	644	1	5.235	0.1	0	0	1	1.0842575	-17.064488	110	2	1.12	0.95	106.5879	-0.2363	0.0000	0.0000;
	645	1	2.618	0	0	0	1	1.0849838	-13.875107	110	2	1.12	0.95	104.1235	-0.1031	0.0000	0.0000;
	646	1	2.827	0.8	0	0	1	1.0721364	-16.636081	110	2	1.12	0.95	107.7165	0.2819	0.0000	0.0000;
	647	1	3.141	1	0	0	1	1.0791783	-12.678921	110	2	1.12	0.95	103.9488	0.0045	0.0000	0.0000;
	648	1	12.877	1.8	0	0	1	1.0818751	-13.711176	110	2	1.12	0.95	103.8393	-0.1868	0.0000	0.0000;
	649	1	5.571	0.44	0	0	1	1.0808595	-17.219319	110	2	1.12	0.95	106.2877	-0.1908	0.0000	0.0000;
	650	1	4.188	1	0	0	1	1.0797482	-12.861525	110	2	1.12	0.95	103.9012	0.0301	0.0000	0.0000;
	651	1	16.752	0	0	0	1	1.0794735	-12.766965	110	2	1.12	0.95	103.9821	-0.0139	0.0000	0.0000;
	652	1	27.222	4	0	0	1	1.0787812	-12.9077	110	2	1.12	0.95	104.0513	0.0235	0.0000	0.0000;
	653	1	10.47	2.5	0	0	1	1.0779723	-13.007559	110	2	1.12	0.95	104.0979	0.0726	0.0000	0.0000;
	654	1	0	0	0	0	1	1.0476078	-16.377328	110	2	1.12	0.95	108.4009	0.6854	0.0000	0.0000;
	655	2	2.303	0.4	0	0	1	1.0476235	-16.78644	110	2	1.12	0.95	108.3971	0.5878	0.0000	0.0000;
	656	1	0.524	0	0	0	1	1.0770512	-12.414206	110	2	1.12	0.95	104.3598	0.0432	0.0000	0.0000;
	657	1	5.445	1.8	0	0	1	1.0821862	-13.763827	110	2	1.12	0.95	103.9638	0.1033	0.0000	0.0000;
	658	1	4.188	0.7	0	0	1	1.0727403	-16.634229	110	2	1.12	0.95	107.6113	0.2385	0.0000	0.0000;
	659	1	3.664	1	0	0	1	1.0764237	-14.780968	110	2	1.12	0.95	105.2718	0.2075	0.0000	0.0000;
	660	2	12	0	0	0	1	1.1183677	-12.873709	110	2	1.12	0.95	101.7527	0.0003	0.0000	0.0000;
	661	2	12	0	0	0	1	1.1181386	-12.858585	110	2	1.12	0.95	101.7567	0.0000	0.0000	0.0000;
	662	1	8.899	1	0	0	1	1.0774875	-12.974614	110	2	1.12	0.95	104.1733	0.0585	0.0000	0.0000;
	663	1	28.269	3	0	0	1	1.0805923	-12.811844	110	2	1.12	0.95	103.7780	0.0297	0.0000	0.0000;
	664	1	6.282	1.2	0	0	1	1.0530013	-17.042859	110	2	1.12	0.95	107.3407	0.3120	0.0000	0.0000;
	665	1	0	0	0	0	1	1.0585041	-16.670082	110	2	1.12	0.95	105.9797	0.1659	0.0000	0.0000;
	666	1	15.286	1.8	0	0	1	1.0530751	-17.043706	110	2	1.12	0.95	107.3102	0.3079	0.0000	0.0000;
	667	2	18.637	1	0	0	1	1.0530148	-17.032618	110	2	1.12	0.95	107.3682	0.3096	0.0000	0.0000;
	668	1	6.911	0.6	0	0	1	1.0563671	-16.837953	110	2	1.12	0.95	106.4825	0.2212	0.0000	0.0000;
	669	1	9.423	2	0	0	1	1.0636749	-14.102894	110	2	1.12	0.95	106.6723	0.6333	0.0000	0.0000;
	670	1	2.094	0	0	0	1	1.0637526	-14.042248	110	2	1.12	0.95	106.6208	0.6459	0.0000	0.0000;
	671	2	26.698	3.2	0	0	1	1.0780397	-17.473998	110	2	1.12	0.95	107.1164	-0.1078	0.0000	0.0000;
	672	1	9.423	1	0	0	1	1.063789	-14.013519	110	2	1.12	0.95	106.5976	0.6507	0.0000	0.0000;
	673	2	6.282	0	0	0	1	1.0805503	-11.101085	110	2	1.12	0.95	103.6981	0.0168	0.0000	0.0000;
	674	1	15.705	3	0	0	1	1.0771936	-13.051344	110	2	1.12	0.95	104.2006	0.0793	0.0000	0.0000;
	675	1	25.128	1.5	0	0	1	1.1088247	-13.58046	110	2	1.12	0.95	102.8073	0.0688	0.0000	0.0000;
	676	1	22.511	3.5	0	0	1	1.0667861	-16.19025	110	2	1.12	0.95	106.7327	0.0379	0.0000	0.0000;
	677	1	11.307	1.3	0	0	1	1.0553001	-19.153483	110	2	1.12	0.95	110.9234	0.1339	0.0000	0.0000;
	678	1	20.752	5.94	0	0	1	1.0811209	-16.451251	110	2	1.12	0.95	105.6872	-0.0305	0.0000	0.0000;
	679	1	11.882	0.2	0	0	1	1.0809306	-16.553192	110	2	1.12	0.95	106.0506	-0.0917	0.0000	0.0000;
	680	1	13.192	1	0	0	1	1.0877039	-15.179547	110	2	1.12	0.95	104.6335	-0.0312	0.0000	0.0000;
	681	2	12.57	1.004	0	0	1	1.0929179	-14.440173	110	2	1.12	0.95	103.8516	-0.0759	0.0000	0.0000;
	682	1	0	0	0	0	1	1.0928693	-14.461042	110	2	1.12	0.95	103.8563	-0.0765	0.0000	0.0000;
	683	1	12.145	1.6	0	0	1	1.0826133	-14.084613	110	2	1.12	0.95	104.4838	0.0275	0.0000	0.0000;
	684	1	7.329	1.3	0	0	1	1.0687097	-16.122194	110	2	1.12	0.95	105.6878	0.0312	0.0000	0.0000;
	685	1	4.188	0.4	0	0	1	1.0825045	-14.086754	110	2	1.12	0.95	104.4766	0.0185	0.0000	0.0000;
	686	1	3.664	0	0	0	1	1.0879262	-15.267377	110	2	1.12	0.95	104.5872	-0.0843	0.0000	0.0000;
	687	2	17.799	6	0	0	1	1.0877222	-15.275378	110	2	1.12	0.95	104.6035	-0.0758	0.0000	0.0000;
	688	1	7.329	0.8	0	0	1	1.087782	-15.2987	110	2	1.12	0.95	104.6268	-0.0894	0.0000	0.0000;
	689	1	19.924	2.05	0	0	1	1.0856059	-15.565449	110	2	1.12	0.95	104.9519	-0.0706	0.0000	0.0000;
	690	1	8.899	2	0	0	1	1.0776111	-15.199889	110	2	1.12	0.95	105.4888	0.2483	0.0000	0.0000;
	691	1	9.318	1.3	0	0	1	1.0961528	-18.327185	110	2	1.12	0.95	104.5619	-1.0153	0.0000	0.0000;
	692	1	0	0	0	0	1	1.0883824	-15.298403	110	2	1.12	0.95	104.5268	-0.1282	0.0000	0.0000;
	693	1	0	0	0	0	1	1.0883067	-15.32503	110	2	1.12	0.95	104.5396	-0.1247	0.0000	0.0000;
	694	1	4.188	1	0	0	1	1.0884145	-17.199343	110	2	1.12	0.95	105.4013	-1.2039	0.0000	0.0000;
	695	1	19.788	2.8	0	0	1	1.0843643	-15.697518	110	2	1.12	0.95	105.1206	-0.0388	0.0000	0.0000;
	696	1	18.228	1.62	0	0	1	1.0870591	-15.12922	110	2	1.12	0.95	104.9063	-0.0133	0.0000	0.0000;
	697	1	21.117	2.52	0	0	1	1.0842815	-15.659685	110	2	1.12	0.95	105.1331	-0.0096	0.0000	0.0000;
	698	1	0	0	0	0	1	1.0885479	-15.228305	110	2	1.12	0.95	104.5256	-0.1053	0.0000	0.0000;
	699	2	18.951	3.74	0	0	1	1.0867563	-15.147554	110	2	1.12	0.95	104.9331	-0.0030	0.0000	0.0000;
	700	1	9.004	0.6	0	0	1	1.0883085	-15.047152	110	2	1.12	0.95	104.7175	-0.0432	0.0000	0.0000;
	701	1	10.365	0.9	0	0	1	1.0878853	-15.271775	110	2	1.12	0.95	104.6098	-0.0784	0.0000	0.0000;
	702	2	6.464	0	0	0	1	1.0830988	-13.586872	110	2	1.12	0.95	103.9180	0.0016	0.0000	0.0000;
	703	1	8.376	4	0	0	1	1.0835304	-13.557618	110	2	1.12	0.95	103.8609	0.0085	0.0000	0.0000;
	704	1	3.978	0.2	0	0	1	1.0831971	-17.637508	110	2	1.12	0.95	106.5648	-0.7596	0.0000	0.0000;
	705	1	14.134	2	0	0	1	1.0786533	-9.3119316	110	2	1.12	0.95	102.8508	0.3317	0.0000	0.0000;
	706	1	13.223	0.4	0	0	1	1.0870386	-17.878445	110	2	1.12	0.95	105.8338	-1.0100	0.0000	0.0000;
	707	1	1.988	0	0	0	1	1.0519413	-18.849559	110	2	1.12	0.95	110.1560	0.2565	0.0000	0.0000;
	708	1	7.853	2	0	0	1	1.0914704	-13.89438	110	2	1.12	0.95	104.7375	0.4720	0.0000	0.0000;
	709	1	1.047	0	0	0	1	1.0968395	-17.281695	110	2	1.12	0.95	104.4266	1.3659	0.0000	0.0000;
	710	1	0	0	0	0	1	1.0840929	-16.533926	110	2	1.12	0.95	106.1476	-0.1480	0.0000	0.0000;
	711	1	0	0	0	0	1	1.0841197	-16.525273	110	2	1.12	0.95	106.1419	-0.1475	0.0000	0.0000;
	712	2	50.674	11.3	0	0	1	1.0820961	-13.062446	110	2	1.12	0.95	103.2569	0.2418	0.0000	0.0000;
	713	1	15.705	0.5	0	0	1	1.0789038	-12.799135	110	2	1.12	0.95	104.2117	-0.0204	0.0000	0.0000;
	714	1	5.235	0.5	0	0	1	1.0822512	-12.187432	110	2	1.12	0.95	103.6131	-0.1155	0.0000	0.0000;
	715	1	17.589	1.6	0	0	1	1.0541497	-18.807175	110	2	1.12	0.95	110.2940	0.1771	0.0000	0.0000;
	716	1	4.502	0.4	0	0	1	1.0731538	-16.662722	110	2	1.12	0.95	107.5091	0.1987	0.0000	0.0000;
	717	1	8.794	0.8	0	0	1	1.0811819	-13.752985	110	2	1.12	0.95	104.1389	-0.0689	0.0000	0.0000;
	718	2	24.185	2.3	0	0	1	1.0470676	-16.625257	110	2	1.12	0.95	108.4955	0.6479	0.0000	0.0000;
	719	1	7.643	0	0	0	1	1.0863113	-14.954088	110	2	1.12	0.95	104.8765	-0.1004	0.0000	0.0000;
	720	1	2.094	1	0	0	1	1.0794476	-16.936703	110	2	1.12	0.95	106.4450	-0.1060	0.0000	0.0000;
	721	1	7.853	1	0	0	1	1.0714194	-15.029806	110	2	1.12	0.95	106.0742	0.3293	0.0000	0.0000;
	722	2	10.994	1.9	0	0	1	1.0725746	-16.873954	110	2	1.12	0.95	107.3366	0.1394	0.0000	0.0000;
	723	1	0.105	0	0	0	1	1.0855671	-14.2377	110	2	1.12	0.95	104.3372	-0.0973	0.0000	0.0000;
	724	1	3.141	0	0	0	1	1.0764521	-13.129787	110	2	1.12	0.95	104.5877	0.0828	0.0000	0.0000;
	725	1	7.12	0.4	0	0	1	1.080959	-14.283217	110	2	1.12	0.95	104.3929	0.1043	0.0000	0.0000;
	726	1	34.549	8	0	0	1	1.0807317	-14.59388	110	2	1.12	0.95	104.5865	0.1129	0.0000	0.0000;
	727	1	0	0	0	0	1	1.0808544	-14.567293	110	2	1.12	0.95	104.5720	0.1088	0.0000	0.0000;
	728	1	1.047	0.5	0	0	1	1.0855182	-12.982194	110	2	1.12	0.95	103.2550	0.0485	0.0000	0.0000;
	729	1	104.699	40	0	0	1	1.0019369	-14.575665	110	2	1.12	0.95	103.8806	-0.0748	0.0000	0.0000;
	730	1	0	0	0	0	1	1.0025064	-14.548428	110	2	1.12	0.95	103.8091	-0.1013	0.0000	0.0000;
	731	2	9.423	1	0	0	1	1.0778816	-14.753859	110	2	1.12	0.95	105.0460	0.1633	0.0000	0.0000;
	732	1	26.175	2	0	0	1	1.0776098	-15.03543	110	2	1.12	0.95	105.1261	0.1372	0.0000	0.0000;
	733	1	9.109	0.6	0	0	1	1.0720238	-15.593909	110	2	1.12	0.95	106.1832	0.1786	0.0000	0.0000;
	734	1	11.202	0	0	0	1	1.0915769	-16.352034	110	2	1.12	0.95	104.6303	-1.1265	0.0000	0.0000;
	735	1	4.711	0.5	0	0	1	1.0721468	-14.462982	110	2	1.12	0.95	105.9004	0.3578	0.0000	0.0000;
	736	2	12	0	0	0	1	1.0929368	-11.604279	110	2	1.12	0.95	101.5872	0.0000	0.0000	0.0000;
	737	1	0	0	0	0	1	1.0929277	-11.605452	110	2	1.12	0.95	101.6067	-0.0017	0.0000	0.0000;
	738	1	7.853	1	0	0	1	1.0769928	-12.399335	110	2	1.12	0.95	104.3455	0.0512	0.0000	0.0000;
	739	1	3.664	1	0	0	1	1.1010418	-13.869458	110	2	1.12	0.95	103.4633	0.1152	0.0000	0.0000;
	740	2	5.235	0.5	0	0	1	1.0937163	-14.068267	110	2	1.12	0.95	104.0360	0.1510	0.0000	0.0000;
	741	1	6.596	0.1	0	0	1	1.0729775	-16.505912	110	2	1.12	0.95	107.5461	0.2630	0.0000	0.0000;
	742	1	12.323	0.6	0	0	1	1.0728949	-16.552961	110	2	1.12	0.95	107.6141	0.2659	0.0000	0.0000;
	743	1	1.571	0.5	0	0	1	1.0743493	-16.676046	110	2	1.12	0.95	107.1207	0.1321	0.0000	0.0000;
	744	1	6.387	0.3	0	0	1	1.0752967	-16.569867	110	2	1.12	0.95	107.0042	0.1264	0.0000	0.0000;
	745	1	3.454	0.8	0	0	1	1.0773947	-17.64751	110	2	1.12	0.95	107.3226	-0.0358	0.0000	0.0000;
	746	1	7.015	2	0	0	1	1.0495374	-19.034267	110	2	1.12	0.95	110.5463	0.3168	0.0000	0.0000;
	747	2	23.243	-4	0	0	1	1.0616434	-17.521092	110	2	1.12	0.95	108.3433	0.0000	0.0000	0.0000;
	748	1	8.376	1	0	0	1	1.0764775	-13.655027	110	2	1.12	0.95	104.8639	0.4368	0.0000	0.0000;
	749	1	2.512	0.7	0	0	1	1.084103	-13.403642	110	2	1.12	0.95	103.6748	0.0301	0.0000	0.0000;
	750	1	11.517	1.5	0	0	1	1.0492463	-19.075203	110	2	1.12	0.95	110.6064	0.3153	0.0000	0.0000;
	751	1	18.846	2	0	0	1	1.0520512	-18.834246	110	2	1.12	0.95	110.1251	0.2609	0.0000	0.0000;
	752	1	9.423	0.6	0	0	1	1.0497594	-19.009554	110	2	1.12	0.95	110.5189	0.3110	0.0000	0.0000;
	753	1	25.128	3.5	0	0	1	1.080155	-14.352884	110	2	1.12	0.95	105.0767	0.3325	0.0000	0.0000;
	754	1	12.564	3	0	0	1	1.0838056	-11.955485	110	2	1.12	0.95	103.3463	-0.1314	0.0000	0.0000;
	755	1	0	0	0	0	1	1.0837786	-11.948292	110	2	1.12	0.95	103.3509	-0.1333	0.0000	0.0000;
	756	1	15.81	0.6	0	0	1	1.0815416	-17.614237	110	2	1.12	0.95	106.5289	-0.3013	0.0000	0.0000;
	757	1	16.752	1	0	0	1	1.080379	-14.417447	110	2	1.12	0.95	105.1008	0.3355	0.0000	0.0000;
	758	1	2.094	0.5	0	0	1	1.0722092	-13.216293	110	2	1.12	0.95	105.0346	0.6053	0.0000	0.0000;
	759	2	1.114	0.491	0	0	1	1.0844595	-13.003134	110	2	1.12	0.95	103.0227	-0.0969	0.0000	0.0000;
	760	2	13.715	3.4	0	0	1	1.0796092	-17.443854	110	2	1.12	0.95	106.9277	-0.1716	0.0000	0.0000;
	761	1	15.705	3	0	0	1	1.0799274	-14.916155	110	2	1.12	0.95	105.5969	0.4316	0.0000	0.0000;
	762	1	17.066	1.4	0	0	1	1.0758962	-14.367706	110	2	1.12	0.95	104.5617	-0.0101	0.0000	0.0000;
	763	1	9.528	2.3	0	0	1	1.0560298	-15.190453	110	2	1.12	0.95	107.2410	0.6316	0.0000	0.0000;
	764	1	2.094	1	0	0	1	1.0861233	-13.753437	110	2	1.12	0.95	103.9795	0.2119	0.0000	0.0000;
	765	1	0	0	0	0	1	1.0861343	-13.757381	110	2	1.12	0.95	103.9770	0.2125	0.0000	0.0000;
	766	1	16.752	3	0	0	1	1.0838887	-14.218551	110	2	1.12	0.95	104.7068	0.2167	0.0000	0.0000;
	767	1	15.705	3	0	0	1	1.0836585	-14.115733	110	2	1.12	0.95	104.5977	0.2436	0.0000	0.0000;
	768	1	17.799	4	0	0	1	1.0790652	-14.905304	110	2	1.12	0.95	105.6456	0.4550	0.0000	0.0000;
	769	1	7.874	2	0	0	1	1.07564	-15.318912	110	2	1.12	0.95	105.8712	0.0711	0.0000	0.0000;
	770	1	11.202	1.5	0	0	1	1.0885237	-15.411288	110	2	1.12	0.95	105.6904	0.2847	0.0000	0.0000;
	771	1	6.702	1.2	0	0	1	1.0743056	-14.628824	110	2	1.12	0.95	104.8536	-0.0328	0.0000	0.0000;
	772	1	13.297	0	0	0	1	1.0750113	-14.532419	110	2	1.12	0.95	104.7441	-0.0072	0.0000	0.0000;
	773	1	5.759	0	0	0	1	1.0725487	-14.883321	110	2	1.12	0.95	105.1470	0.0191	0.0000	0.0000;
	774	1	0	0	0	0	1	1.0835813	-13.493281	110	2	1.12	0.95	103.5336	-0.2623	0.0000	0.0000;
	775	1	0	0	0	0	1	1.0835545	-13.50129	110	2	1.12	0.95	103.5369	-0.2611	0.0000	0.0000;
	776	1	2.618	0.5	0	0	1	1.0811155	-14.255452	110	2	1.12	0.95	104.8980	0.3133	0.0000	0.0000;
	777	1	18.637	4.1	0	0	1	1.0839492	-13.07777	110	2	1.12	0.95	103.1070	-0.0964	0.0000	0.0000;
	778	2	8.376	1	0	0	1	1.0738602	-14.751087	110	2	1.12	0.95	104.9867	0.0000	0.0000	0.0000;
	779	1	7.538	7.4	0	0	1	1.079208	-14.770531	110	2	1.12	0.95	104.9178	0.3328	0.0000	0.0000;
	780	2	2.931	0.8	0	0	1	1.0860154	-13.871981	110	2	1.12	0.95	104.0981	-0.0003	0.0000	0.0000;
	781	1	3.141	1	0	0	1	1.0759903	-12.691337	110	2	1.12	0.95	104.6071	0.0266	0.0000	0.0000;
	782	1	0	0	0	0	1	1.0861394	-15.586103	110	2	1.12	0.95	104.9396	-0.0570	0.0000	0.0000;
	783	2	7.329	3	0	0	1	1.0856973	-15.629591	110	2	1.12	0.95	105.0189	-0.0445	0.0000	0.0000;
	784	1	8.376	0.5	0	0	1	1.0752315	-14.315854	110	2	1.12	0.95	105.5572	0.3512	0.0000	0.0000;
	785	1	20.856	3	0	0	1	1.0854375	-15.682509	110	2	1.12	0.95	105.1109	-0.0444	0.0000	0.0000;
	786	1	7.329	1	0	0	1	1.077014	-10.545513	110	2	1.12	0.95	103.5592	-0.2595	0.0000	0.0000;
	787	1	8.794	1.2	0	0	1	1.058988	-15.203664	110	2	1.12	0.95	106.8931	0.5081	0.0000	0.0000;
	788	2	7.182	0	0	0	1	1.065961	-16.39075	110	2	1.12	0.95	106.0440	0.0268	0.0000	0.0000;
	789	1	9.841	0.2	0	0	1	1.0656841	-16.423845	110	2	1.12	0.95	106.1723	0.0198	0.0000	0.0000;
	790	1	4.92	0.6	0	0	1	1.0717403	-16.439446	110	2	1.12	0.95	107.0102	0.1307	0.0000	0.0000;
	791	1	7.538	2.3	0	0	1	1.0816786	-13.887001	110	2	1.12	0.95	104.0931	-0.1188	0.0000	0.0000;
	792	2	0	0	0	0	1	1.0742092	-15.583129	110	2	1.12	0.95	104.9467	0.0000	0.0000	0.0000;
	793	1	4.711	0.5	0	0	1	1.0714913	-14.457655	110	2	1.12	0.95	105.9479	0.3536	0.0000	0.0000;
	794	1	5.235	0	0	0	1	1.0663515	-14.309817	110	2	1.12	0.95	106.5134	0.4692	0.0000	0.0000;
	795	1	6.282	0.5	0	0	1	1.0727563	-14.446053	110	2	1.12	0.95	105.8428	0.3587	0.0000	0.0000;
	796	1	17.799	2.8	0	0	1	1.0731331	-14.776971	110	2	1.12	0.95	105.0281	-0.0043	0.0000	0.0000;
	797	1	5.863	0.5	0	0	1	1.0870705	-11.979564	110	2	1.12	0.95	102.3999	0.1168	0.0000	0.0000;
	798	1	17.799	5.5	0	0	1	1.0736105	-14.753797	110	2	1.12	0.95	105.7107	0.3030	0.0000	0.0000;
	799	1	0	0	0	0	1	1.0797157	-16.842417	110	2	1.12	0.95	106.3541	-0.0907	0.0000	0.0000;
	800	1	5.131	0.9	0	0	1	1.0657534	-16.414634	110	2	1.12	0.95	106.0981	0.0273	0.0000	0.0000;
	801	1	3.664	0.5	0	0	1	1.0793347	-12.496172	110	2	1.12	0.95	103.8222	0.1194	0.0000	0.0000;
	802	1	12.041	1.5	0	0	1	1.0736526	-14.768862	110	2	1.12	0.95	105.7175	0.3049	0.0000	0.0000;
	803	2	16.343	4.915	0	0	1	1.0887228	-14.651616	110	2	1.12	0.95	104.3857	-0.1110	0.0000	0.0000;
	804	2	27.709	8.601	0	0	1	1.0698488	-16.262372	110	2	1.12	0.95	107.0271	0.0329	0.0000	0.0000;
	805	1	12.25	1.8	0	0	1	1.0605949	-16.209984	110	2	1.12	0.95	106.5522	0.2189	0.0000	0.0000;
	806	1	1.571	1.5	0	0	1	1.0720387	-14.156232	110	2	1.12	0.95	105.6376	0.3205	0.0000	0.0000;
	807	1	15.705	2.4	0	0	1	1.0859587	-14.690119	110	2	1.12	0.95	104.6054	-0.0673	0.0000	0.0000;
	808	1	7.958	1.5	0	0	1	1.0878247	-14.674242	110	2	1.12	0.95	104.4798	-0.0835	0.0000	0.0000;
	809	2	8.062	0	0	0	1	1.0800365	-16.675138	110	2	1.12	0.95	106.7411	-0.1194	0.0000	0.0000;
	810	1	6.387	0	0	0	1	1.0723259	-16.684096	110	2	1.12	0.95	107.3433	0.0655	0.0000	0.0000;
	811	1	14.868	0.9	0	0	1	1.0771662	-14.812004	110	2	1.12	0.95	105.1403	0.1142	0.0000	0.0000;
	812	1	12.041	0.3	0	0	1	1.0636098	-18.676455	110	2	1.12	0.95	110.0544	-0.0797	0.0000	0.0000;
	813	1	7.329	0.2	0	0	1	1.0667221	-18.385835	110	2	1.12	0.95	109.5152	-0.0881	0.0000	0.0000;
	814	1	4.711	0.7	0	0	1	1.0703102	-15.765565	110	2	1.12	0.95	106.3503	0.2415	0.0000	0.0000;
	815	2	9.423	1.8	0	0	1	1.0788203	-17.472293	110	2	1.12	0.95	107.1130	-0.0595	0.0000	0.0000;
	816	1	2.408	0.6	0	0	1	1.06291	-18.784841	110	2	1.12	0.95	110.1845	-0.0751	0.0000	0.0000;
	817	1	4.292	0	0	0	1	1.0709944	-15.85165	110	2	1.12	0.95	105.4695	0.0111	0.0000	0.0000;
	818	1	13.088	1	0	0	1	1.1013201	-16.100889	110	2	1.12	0.95	103.8483	0.9859	0.0000	0.0000;
	819	1	5.445	0.8	0	0	1	1.0952342	-16.279827	110	2	1.12	0.95	103.9639	-1.5867	0.0000	0.0000;
	820	1	12.354	1.5	0	0	1	1.1067987	-14.906941	110	2	1.12	0.95	101.4773	-2.4319	0.0000	0.0000;
	821	1	8.899	2	0	0	1	1.0804532	-11.906998	110	2	1.12	0.95	103.7546	-0.1220	0.0000	0.0000;
	822	1	7.853	0.2	0	0	1	1.085601	-17.55141	110	2	1.12	0.95	106.0224	-1.0084	0.0000	0.0000;
	823	1	3.141	0.5	0	0	1	1.0763712	-13.437865	110	2	1.12	0.95	104.6672	0.1669	0.0000	0.0000;
	824	1	10.47	0	0	0	1	1.0795488	-9.6273751	110	2	1.12	0.95	102.8960	-0.3373	0.0000	0.0000;
	825	1	12.145	1.26	0	0	1	1.0878328	-15.082745	110	2	1.12	0.95	104.7800	-0.0347	0.0000	0.0000;
	826	1	0	0	0	0	1	1.0734591	-14.377498	110	2	1.12	0.95	105.7880	0.3805	0.0000	0.0000;
	827	1	0	0	0	0	1	1.078717	-11.788675	110	2	1.12	0.95	104.0614	0.0244	0.0000	0.0000;
	828	1	14.029	1	0	0	1	1.0849085	-16.753518	110	2	1.12	0.95	106.2530	-0.1725	0.0000	0.0000;
	829	1	2.303	0.5	0	0	1	1.0668837	-16.33016	110	2	1.12	0.95	105.9273	0.0120	0.0000	0.0000;
	830	1	5.235	0	0	0	1	1.076777	-16.863041	110	2	1.12	0.95	107.1508	-0.0679	0.0000	0.0000;
	831	1	4.606	1	0	0	1	1.0693784	-16.779092	110	2	1.12	0.95	107.3805	0.1050	0.0000	0.0000;
	832	1	10.785	0.6	0	0	1	1.0838452	-16.750514	110	2	1.12	0.95	106.3252	-0.1569	0.0000	0.0000;
	833	1	9.004	0	0	0	1	1.084413	-16.780072	110	2	1.12	0.95	106.3120	-0.1667	0.0000	0.0000;
	834	2	2.618	1	0	0	1	1.0710738	-14.424239	110	2	1.12	0.95	105.9599	0.3467	0.0000	0.0000;
	835	1	6.282	1	0	0	1	1.0773519	-15.362901	110	2	1.12	0.95	105.9806	0.2230	0.0000	0.0000;
	836	1	0	0	0	0	1	1.1101373	-3.9328437	110	3	1.12	0.95	98.5825	0.0284	0.0000	0.0000;
	837	1	1.067	0.279	0	0	1	1.0923648	-4.3316876	110	3	1.12	0.95	98.5760	-0.0008	0.0000	0.0000;
	838	1	4.755	2.994	0	0	1	1.0751614	-12.800077	110	3	1.12	0.95	103.6724	0.2551	0.0000	0.0000;
	839	1	0	0	0	0	1	1.0755736	-13.113764	110	3	1.12	0.95	103.8635	0.1669	0.0000	0.0000;
	840	2	61.119	35.107	0	0	1	1.0751788	-12.793392	110	3	1.12	0.95	103.6599	0.2636	0.0000	0.0000;
	841	1	0	0	0	0	1	1.0752858	-12.797724	110	3	1.12	0.95	103.6589	0.2467	0.0000	0.0000;
	842	1	15.621	3.927	0	0	1	1.0931426	-8.4528307	110	3	1.12	0.95	101.5289	0.3830	0.0000	0.0000;
	843	1	0	0	0	0	1	1.0930861	-8.451664	110	3	1.12	0.95	101.5286	0.3844	0.0000	0.0000;
	844	2	4.266	1.191	0	0	1	1.1077648	-6.6127087	110	3	1.12	0.95	99.4756	0.1390	0.0000	0.0000;
	845	1	0	0	0	0	1	1.0712017	-7.6210686	110	3	1.12	0.95	100.6768	0.0870	0.0000	0.0000;
	846	1	9.752	2.726	0	0	1	1.0712274	-7.6043647	110	3	1.12	0.95	100.6725	0.0881	0.0000	0.0000;
	847	1	23.487	4.71	0	0	1	1.086029	-8.633899	110	3	1.12	0.95	101.8882	0.7225	0.0000	0.0000;
	848	2	0	-0.01	0	0	1	1.0860662	-8.6285654	110	3	1.12	0.95	101.8848	0.7220	0.0000	0.0000;
	849	1	0	0	0	0	1	1.0861011	-8.62444	110	3	1.12	0.95	101.8819	0.7215	0.0000	0.0000;
	850	1	10.461	1.322	0	0	1	1.094584	-7.5818288	110	3	1.12	0.95	100.7711	-0.4832	0.0000	0.0000;
	851	1	13.118	4.684	0	0	1	1.0945254	-7.5968397	110	3	1.12	0.95	100.7756	-0.4806	0.0000	0.0000;
	852	1	0	0	0	0	1	1.0991359	-6.7161784	110	3	1.12	0.95	100.0857	0.4206	0.0000	0.0000;
	853	1	0	0	0	0	1	1.099111	-6.7214879	110	3	1.12	0.95	100.0862	0.4203	0.0000	0.0000;
	854	2	9.487	2.788	0	0	1	1.0866003	-7.9282847	110	3	1.12	0.95	101.2757	0.8021	0.0000	0.0000;
	855	1	8.31	3.731	0	0	1	1.0865372	-7.9276259	110	3	1.12	0.95	101.2816	0.8041	0.0000	0.0000;
	856	1	4.042	1.467	0	0	1	1.0848998	-7.5190117	110	3	1.12	0.95	100.6088	-0.6046	0.0000	0.0000;
	857	1	0	0	0	0	1	1.0849401	-7.5218091	110	3	1.12	0.95	100.6087	-0.6017	0.0000	0.0000;
	858	1	0	0	0	0	1	1.0755891	-13.114027	110	3	1.12	0.95	103.8636	0.1660	0.0000	0.0000;
	859	1	27.425	3.9	0	0	1	1.0866251	-10.64271	110	3	1.12	0.95	102.9835	0.1063	0.0000	0.0000;
	860	1	23.973	2.947	0	0	1	1.0866052	-10.64464	110	3	1.12	0.95	102.9867	0.1058	0.0000	0.0000;
	861	1	19.062	4.94	0	0	1	1.0959641	-6.9104215	110	3	1.12	0.95	100.2757	0.6043	0.0000	0.0000;
	862	1	0	0	0	0	1	1.0956342	-7.1936272	110	3	1.12	0.95	100.3365	0.5984	0.0000	0.0000;
	863	1	0	0	0	0	1	1.0956342	-7.1936266	110	3	1.12	0.95	100.3365	0.5984	0.0000	0.0000;
	864	1	11.917	3.087	0	0	1	1.0676698	-8.739841	110	3	1.12	0.95	101.7086	-0.2045	0.0000	0.0000;
	865	1	8.333	2.375	0	0	1	1.067615	-8.7494649	110	3	1.12	0.95	101.7121	-0.2038	0.0000	0.0000;
	866	1	11.906	-1.139	0	0	1	1.0905765	-9.3349367	110	3	1.12	0.95	102.0031	0.0062	0.0000	0.0000;
	867	1	12.397	-1.439	0	0	1	1.0906001	-9.3332475	110	3	1.12	0.95	102.0005	0.0066	0.0000	0.0000;
	868	1	3.92	1.115	0	0	1	1.060227	-14.052007	110	3	1.12	0.95	106.6534	0.5256	0.0000	0.0000;
	869	1	3.802	0.556	0	0	1	1.0746339	-13.482913	110	3	1.12	0.95	104.4022	0.0419	0.0000	0.0000;
	870	1	0	0	0	0	1	1.0602539	-14.050636	110	3	1.12	0.95	106.6497	0.5245	0.0000	0.0000;
	871	1	13.772	18.559	0	0	1	1.1011023	-6.107445	110	3	1.12	0.95	99.8034	0.2549	0.0000	0.0000;
	872	1	0	0	0	0	1	1.1009836	-6.1200755	110	3	1.12	0.95	99.8132	0.2554	0.0000	0.0000;
	873	2	22.579	8.825	0	0	1	1.0947851	-3.9963039	110	3	1.12	0.95	98.2406	-0.0000	0.0000	0.0000;
	874	1	11.996	3.954	0	0	1	1.0912948	-4.3836104	110	3	1.12	0.95	98.7064	0.0631	0.0000	0.0000;
	875	1	10.768	3.623	0	0	1	1.0553286	-11.452263	110	3	1.12	0.95	106.2700	1.7714	0.0000	0.0000;
	876	2	6.073	-0.564	0	0	1	1.0773069	-7.8677761	110	3	1.12	0.95	105.3982	0.2892	0.0000	0.0000;
	877	1	0	0	0	0	1	1.0780538	-7.7800724	110	3	1.12	0.95	105.2152	0.3110	0.0000	0.0000;
	878	1	8.573	2.356	0	0	1	1.0567724	-15.611365	110	3	1.12	0.95	107.6465	0.3917	0.0000	0.0000;
	879	1	7.827	2.276	0	0	1	1.0567309	-15.618678	110	3	1.12	0.95	107.6504	0.3924	0.0000	0.0000;
	880	1	8.785	3.17	0	0	1	1.1024362	-7.2670613	110	3	1.12	0.95	99.9463	0.2985	0.0000	0.0000;
	881	1	0	0	0	0	1	1.1024114	-7.2715694	110	3	1.12	0.95	99.9499	0.2992	0.0000	0.0000;
	882	1	4.285	1.218	0	0	1	1.0716897	-8.1764126	110	3	1.12	0.95	101.1137	-0.1766	0.0000	0.0000;
	883	1	1.187	0.361	0	0	1	1.0715145	-8.0999796	110	3	1.12	0.95	101.0502	-0.1345	0.0000	0.0000;
	884	1	0	0	0	0	1	1.0717532	-8.173173	110	3	1.12	0.95	101.1056	-0.1789	0.0000	0.0000;
	885	1	0	0	0	0	1	1.0715323	-8.0990902	110	3	1.12	0.95	101.0479	-0.1351	0.0000	0.0000;
	886	1	0	0	0	0	1	1.1178331	-2.7476351	110	3	1.12	0.95	98.5449	0.0306	0.0000	0.0000;
	887	1	1.781	0.28	0	0	1	1.1178709	-2.728158	110	3	1.12	0.95	98.5488	0.0311	0.0000	0.0000;
	888	1	6.185	1.941	0	0	1	1.0705626	-13.063987	110	3	1.12	0.95	105.8399	0.3677	0.0000	0.0000;
	889	1	0	0	0	0	1	1.071633	-12.978961	110	3	1.12	0.95	105.7246	0.3352	0.0000	0.0000;
	890	1	15.451	2.845	0	0	1	1.0695435	-7.9361541	110	3	1.12	0.95	100.9897	0.0614	0.0000	0.0000;
	891	1	0	0	0	0	1	1.0695729	-7.9437809	110	3	1.12	0.95	100.9906	0.0595	0.0000	0.0000;
	892	1	7.845	0.836	0	0	1	1.0795897	-8.036952	110	3	1.12	0.95	100.9402	-0.2953	0.0000	0.0000;
	893	1	3.683	0.463	0	0	1	1.0631168	-9.2275189	110	3	1.12	0.95	103.6077	-0.0901	0.0000	0.0000;
	894	1	0	0	0	0	1	1.0807074	-7.9719589	110	3	1.12	0.95	100.7525	-0.3110	0.0000	0.0000;
	895	1	5.936	0.933	0	0	1	1.0914417	-5.7533684	110	3	1.12	0.95	101.8299	0.5318	0.0000	0.0000;
	896	2	1	3	0	0	1	1.090161	-7.6466098	110	3	1.12	0.95	100.5192	0.1987	0.0000	0.0000;
	897	1	9.497	2.798	0	0	1	1.0898579	-7.6606549	110	3	1.12	0.95	100.5247	0.2066	0.0000	0.0000;
	898	1	0	0	0	0	1	1.0930632	-7.7954691	110	3	1.12	0.95	100.9381	-0.4556	0.0000	0.0000;
	899	1	10.481	2.476	0	0	1	1.0930071	-7.8019339	110	3	1.12	0.95	100.9435	-0.4566	0.0000	0.0000;
	900	1	9.859	2.676	0	0	1	1.0562292	-15.675495	110	3	1.12	0.95	107.7420	0.4001	0.0000	0.0000;
	901	1	13.243	3.591	0	0	1	1.0562095	-15.676877	110	3	1.12	0.95	107.7415	0.4004	0.0000	0.0000;
	902	2	0	-0.01	0	0	1	1.0393257	-11.776029	110	3	1.12	0.95	109.5441	1.2633	0.0000	0.0000;
	903	2	15.707	0.63	0	0	1	1.0393082	-11.782887	110	3	1.12	0.95	109.5471	1.2634	0.0000	0.0000;
	904	1	0	0	0	0	1	1.0473168	-11.115516	110	3	1.12	0.95	108.2026	1.0875	0.0000	0.0000;
	905	1	11.29	2.938	0	0	1	1.1094774	-4.0612361	110	3	1.12	0.95	98.5929	0.0606	0.0000	0.0000;
	906	1	6.295	1.725	0	0	1	1.0934345	-4.261138	110	3	1.12	0.95	98.6193	-0.0012	0.0000	0.0000;
	907	1	3.562	1.772	0	0	1	1.1016563	-7.3125207	110	3	1.12	0.95	100.0080	0.3253	0.0000	0.0000;
	908	1	0	0	0	0	1	1.1024724	-7.2726151	110	3	1.12	0.95	99.9499	0.2955	0.0000	0.0000;
	909	1	11.634	2.798	0	0	1	1.0881022	-6.6933581	110	3	1.12	0.95	100.2553	-0.1101	0.0000	0.0000;
	910	1	0	0	0	0	1	1.0923506	-5.8439086	110	3	1.12	0.95	99.6879	-0.0512	0.0000	0.0000;
	911	1	0	0	0	0	1	1.0923506	-5.8439086	110	3	1.12	0.95	99.6879	-0.0512	0.0000	0.0000;
	912	1	13.093	5.782	0	0	1	1.0880757	-6.6918164	110	3	1.12	0.95	100.2555	-0.1067	0.0000	0.0000;
	913	1	13.661	-1.584	0	0	1	1.0870044	-10.640486	110	3	1.12	0.95	103.1087	0.1093	0.0000	0.0000;
	914	1	12.985	2.734	0	0	1	1.086952	-10.653589	110	3	1.12	0.95	103.1111	0.1098	0.0000	0.0000;
	915	1	6.9	2.468	0	0	1	1.0845371	-7.5125098	110	3	1.12	0.95	100.6092	-0.5992	0.0000	0.0000;
	916	1	0	0	0	0	1	1.0845616	-7.5139654	110	3	1.12	0.95	100.6095	-0.5972	0.0000	0.0000;
	917	1	16.146	6.808	0	0	1	1.088972	-7.5683441	110	3	1.12	0.95	101.1007	0.7869	0.0000	0.0000;
	918	1	2.967	0	0	0	1	1.0913358	-7.193097	110	3	1.12	0.95	100.7558	0.7650	0.0000	0.0000;
	919	1	7.371	1.955	0	0	1	1.0920213	-7.2013416	110	3	1.12	0.95	99.9068	0.0171	0.0000	0.0000;
	920	1	0	0	0	0	1	1.092852	-7.149217	110	3	1.12	0.95	99.8398	0.0085	0.0000	0.0000;
	921	1	0	0	0	0	1	1.0920997	-7.1952271	110	3	1.12	0.95	99.8986	0.0150	0.0000	0.0000;
	922	1	0	0	0	0	1	1.092851	-7.1492009	110	3	1.12	0.95	99.8398	0.0086	0.0000	0.0000;
	923	1	5.12	0.809	0	0	1	1.0875118	-6.1000229	110	3	1.12	0.95	102.3743	0.4848	0.0000	0.0000;
	924	1	0	0	0	0	1	1.0874678	-6.1121071	110	3	1.12	0.95	102.3767	0.4839	0.0000	0.0000;
	925	1	15.233	4.781	0	0	1	1.0945112	-5.8103234	110	3	1.12	0.95	100.1873	0.3958	0.0000	0.0000;
	926	1	7.727	3.382	0	0	1	1.1070296	-4.5031314	110	3	1.12	0.95	98.9289	0.1147	0.0000	0.0000;
	927	1	22.5	2.432	0	0	1	1.0561343	-14.08433	110	3	1.12	0.95	107.4118	0.6818	0.0000	0.0000;
	928	1	0	0	0	0	1	1.0562131	-14.080804	110	3	1.12	0.95	107.3996	0.6794	0.0000	0.0000;
	929	1	24.136	6.557	0	0	1	1.0829901	-8.9017106	110	3	1.12	0.95	102.2480	0.8089	0.0000	0.0000;
	930	1	0	0	0	0	1	1.0830316	-8.8963745	110	3	1.12	0.95	102.2447	0.8080	0.0000	0.0000;
	931	1	19.728	3.946	0	0	1	1.0887519	-8.2917672	110	3	1.12	0.95	101.5457	0.6426	0.0000	0.0000;
	932	1	0	0	0	0	1	1.0888917	-8.275213	110	3	1.12	0.95	101.5380	0.6400	0.0000	0.0000;
	933	1	0.95	0.56	0	0	1	1.0914315	-7.2528635	110	3	1.12	0.95	99.9820	0.0506	0.0000	0.0000;
	934	1	0	0	0	0	1	1.0915127	-7.2484594	110	3	1.12	0.95	99.9766	0.0477	0.0000	0.0000;
	935	1	3.563	-0.465	0	0	1	1.0941225	-9.8010999	110	3	1.12	0.95	101.9229	0.0354	0.0000	0.0000;
	936	1	15.666	-1.776	0	0	1	1.0940589	-9.8016083	110	3	1.12	0.95	101.9287	0.0361	0.0000	0.0000;
	937	1	8.319	2.14	0	0	1	1.1032154	-4.7029515	110	3	1.12	0.95	99.3528	0.1752	0.0000	0.0000;
	938	1	0	0	0	0	1	1.1032937	-4.6903051	110	3	1.12	0.95	99.3492	0.1742	0.0000	0.0000;
	939	1	13.06	2.611	0	0	1	1.1027545	-6.2439349	110	3	1.12	0.95	99.6068	0.3859	0.0000	0.0000;
	940	1	6.529	1.306	0	0	1	1.1151516	-5.3671235	110	3	1.12	0.95	98.6176	0.0469	0.0000	0.0000;
	941	1	0	0	0	0	1	1.1036253	-6.1625116	110	3	1.12	0.95	99.5067	0.3665	0.0000	0.0000;
	942	1	6.059	2.048	0	0	1	1.0882266	-6.6865644	110	3	1.12	0.95	100.2390	-0.1140	0.0000	0.0000;
	943	1	6.773	1.955	0	0	1	1.0923505	-5.8439051	110	3	1.12	0.95	99.6879	-0.0512	0.0000	0.0000;
	944	1	2.97	0.583	0	0	1	1.0872042	-7.7433563	110	3	1.12	0.95	100.6018	-0.2515	0.0000	0.0000;
	945	1	0	0	0	0	1	1.0872197	-7.7404067	110	3	1.12	0.95	100.6010	-0.2536	0.0000	0.0000;
	946	1	7.856	1.958	0	0	1	1.0905205	-7.9780091	110	3	1.12	0.95	101.2419	-0.4492	0.0000	0.0000;
	947	1	0	0	0	0	1	1.0917321	-7.864271	110	3	1.12	0.95	101.1169	-0.4777	0.0000	0.0000;
	948	1	4.405	1.321	0	0	1	1.0768339	-8.3028616	110	3	1.12	0.95	102.2924	0.9017	0.0000	0.0000;
	949	1	0	0	0	0	1	1.0769894	-8.2967027	110	3	1.12	0.95	102.2709	0.8954	0.0000	0.0000;
	950	1	33.05	1.932	0	0	1	1.098724	-6.284173	110	3	1.12	0.95	100.0586	0.2900	0.0000	0.0000;
	951	1	0	0	0	0	1	1.098843	-6.2715043	110	3	1.12	0.95	100.0488	0.2896	0.0000	0.0000;
	952	2	15.515	2.322	0	0	1	1.0847197	-10.902024	110	3	1.12	0.95	103.3417	0.1705	0.0000	0.0000;
	953	1	10.812	0.127	0	0	1	1.08481	-10.868196	110	3	1.12	0.95	103.3379	0.1693	0.0000	0.0000;
	954	1	0	0	0	0	1	1.0946017	-7.5821173	110	3	1.12	0.95	100.7711	-0.4842	0.0000	0.0000;
	955	1	3.561	0	0	0	1	1.0943816	-7.6269456	110	3	1.12	0.95	100.8048	-0.4815	0.0000	0.0000;
	956	1	4.646	3.092	0	0	1	1.059719	-14.937244	110	3	1.12	0.95	106.2730	0.5223	0.0000	0.0000;
	957	1	0	0	0	0	1	1.0596781	-14.947871	110	3	1.12	0.95	106.2775	0.5234	0.0000	0.0000;
	958	2	8.828	1.836	0	0	1	1.0738204	-8.844889	110	3	1.12	0.95	102.8731	0.7600	0.0000	0.0000;
	959	1	0	0	0	0	1	1.0738057	-8.8494184	110	3	1.12	0.95	102.8727	0.7609	0.0000	0.0000;
	960	1	0	0	0	0	1	1.0957324	-5.3968196	110	3	1.12	0.95	101.4160	0.3893	0.0000	0.0000;
	961	1	3.562	-1.119	0	0	1	1.0957576	-5.3911602	110	3	1.12	0.95	101.4153	0.3890	0.0000	0.0000;
	962	1	5.471	0.601	0	0	1	1.0684564	-9.5690711	110	3	1.12	0.95	104.2212	0.6994	0.0000	0.0000;
	963	1	0	0	0	0	1	1.0685088	-9.5562559	110	3	1.12	0.95	104.2134	0.6976	0.0000	0.0000;
	964	1	3.562	2.238	0	0	1	1.1036416	-6.1619568	110	3	1.12	0.95	99.5060	0.3659	0.0000	0.0000;
	965	1	0	0	0	0	1	1.1037038	-6.1583492	110	3	1.12	0.95	99.5051	0.3653	0.0000	0.0000;
	966	1	11.18	0.914	0	0	1	1.1004239	-7.4675069	110	3	1.12	0.95	100.2132	0.3307	0.0000	0.0000;
	967	1	0	0	0	0	1	1.1004492	-7.4632425	110	3	1.12	0.95	100.2108	0.3304	0.0000	0.0000;
	968	1	7.492	0.776	0	0	1	1.0865137	-8.022221	110	3	1.12	0.95	101.0134	0.2976	0.0000	0.0000;
	969	1	8.922	0.931	0	0	1	1.0864699	-8.0337646	110	3	1.12	0.95	101.0155	0.2990	0.0000	0.0000;
	970	1	19.368	6.342	0	0	1	1.0902415	-4.7596972	110	3	1.12	0.95	98.9456	0.0858	0.0000	0.0000;
	971	1	0	0	0	0	1	1.0902415	-4.7501973	110	3	1.12	0.95	98.9448	0.0840	0.0000	0.0000;
	972	2	23.169	19.513	0	0	1	1.1102599	-4.056482	110	3	1.12	0.95	98.6627	0.0000	0.0000	0.0000;
	973	2	0	4	0	0	1	1.1090712	-4.2794349	110	3	1.12	0.95	98.8641	0.0000	0.0000	0.0000;
	974	1	18.179	5.969	0	0	1	1.1063237	-6.8100268	110	3	1.12	0.95	99.5661	0.1730	0.0000	0.0000;
	975	1	0	0	0	0	1	1.106305	-6.8168086	110	3	1.12	0.95	99.5667	0.1731	0.0000	0.0000;
	976	1	22.557	10.259	0	0	1	1.1013014	-6.2415207	110	3	1.12	0.95	99.5315	0.4464	0.0000	0.0000;
	977	2	0	-0.01	0	0	1	1.1014658	-6.2167098	110	3	1.12	0.95	99.5236	0.4439	0.0000	0.0000;
	978	1	10.691	3.45	0	0	1	1.0907295	-5.1876962	110	3	1.12	0.95	99.2825	0.0470	0.0000	0.0000;
	979	1	0	0	0	0	1	1.0908149	-5.199099	110	3	1.12	0.95	99.2800	0.0483	0.0000	0.0000;
	980	1	2.374	-0.56	0	0	1	1.074642	-8.3068797	110	3	1.12	0.95	106.0566	0.1940	0.0000	0.0000;
	981	1	0	0	0	0	1	1.0746416	-8.3067824	110	3	1.12	0.95	106.0566	0.1940	0.0000	0.0000;
	982	1	8.448	1.251	0	0	1	1.097559	-7.136534	110	3	1.12	0.95	100.4628	-0.4511	0.0000	0.0000;
	983	1	0	0	0	0	1	1.0975868	-7.1256804	110	3	1.12	0.95	100.4627	-0.4500	0.0000	0.0000;
	984	1	6.649	1.399	0	0	1	1.0769031	-8.1376043	110	3	1.12	0.95	101.0594	-0.2103	0.0000	0.0000;
	985	1	6.055	1.585	0	0	1	1.0768473	-8.137083	110	3	1.12	0.95	101.0592	-0.2115	0.0000	0.0000;
	986	2	20.679	6.687	0	0	1	1.0976853	-7.2590221	110	3	1.12	0.95	100.5243	0.4563	0.0000	0.0000;
	987	1	0	0	0	0	1	1.0977024	-7.2467999	110	3	1.12	0.95	100.5260	0.4566	0.0000	0.0000;
	988	1	0	0.075	0	0	1	1.1110052	-3.8713425	110	3	1.12	0.95	98.4825	0.0162	0.0000	0.0000;
	989	1	0	0	0	0	1	1.1110068	-3.871366	110	3	1.12	0.95	98.4825	0.0161	0.0000	0.0000;
	990	1	15.041	2.46	0	0	1	1.0918211	-9.1666951	110	3	1.12	0.95	101.7684	0.0217	0.0000	0.0000;
	991	1	20.054	2.089	0	0	1	1.0917695	-9.1812594	110	3	1.12	0.95	101.7756	0.0214	0.0000	0.0000;
	992	1	9.624	2.471	0	0	1	1.0958786	-5.5684947	110	3	1.12	0.95	100.0576	0.3604	0.0000	0.0000;
	993	1	5.828	1.752	0	0	1	1.1082155	-4.2412168	110	3	1.12	0.95	98.7469	0.0899	0.0000	0.0000;
	994	1	26.27	4.551	0	0	1	1.0931951	-9.0461668	110	3	1.12	0.95	101.4916	0.0166	0.0000	0.0000;
	995	1	26.902	4.316	0	0	1	1.091771	-10.074462	110	3	1.12	0.95	102.3057	0.0244	0.0000	0.0000;
	996	1	18.282	6.527	0	0	1	1.0938675	-4.1242784	110	3	1.12	0.95	98.3931	0.0342	0.0000	0.0000;
	997	1	0	0	0	0	1	1.093964	-4.1109146	110	3	1.12	0.95	98.3878	0.0334	0.0000	0.0000;
	998	2	29.872	56.529	0	0	1	1.12	-2.3664833	110	3	1.12	0.95	98.3782	0.0000	179.8618	0.0000;
	999	2	22.749	51.865	0	0	1	1.12	-2.0164086	110	3	1.12	0.95	98.3973	0.0000	325.1372	0.0000;
	1000	1	9.632	1.11	0	0	1	1.087058	-6.2509694	110	3	1.12	0.95	102.5009	0.4873	0.0000	0.0000;
	1001	1	0	0	0	0	1	1.0870973	-6.2389099	110	3	1.12	0.95	102.4983	0.4879	0.0000	0.0000;
	1002	2	19.58	10.193	0	0	1	1.1032745	-6.0107095	110	3	1.12	0.95	99.3287	0.4157	0.0000	0.0000;
	1003	2	0	0	0	0	1	1.1033033	-6.0111296	110	3	1.12	0.95	99.3293	0.4156	0.0000	0.0000;
	1004	2	0	4	0	0	1	1.1120262	-3.794691	110	3	1.12	0.95	98.3878	-0.0000	0.0000	0.0000;
	1005	1	0	0	0	0	1	1.1118887	-3.8135016	110	3	1.12	0.95	98.3949	0.0018	0.0000	0.0000;
	1006	1	9.934	2.341	0	0	1	1.0759482	-11.677912	110	3	1.12	0.95	104.3696	0.4692	0.0000	0.0000;
	1007	2	10.199	2.088	0	0	1	1.0758592	-11.697101	110	3	1.12	0.95	104.3781	0.4706	0.0000	0.0000;
	1008	1	6.554	1.875	0	0	1	1.0677364	-13.749683	110	3	1.12	0.95	105.4162	0.2821	0.0000	0.0000;
	1009	1	0	0	0	0	1	1.0678372	-13.741931	110	3	1.12	0.95	105.4027	0.2793	0.0000	0.0000;
	1010	2	0	-0.01	0	0	1	1.1053237	-7.0723151	110	3	1.12	0.95	99.7431	0.1650	0.0000	0.0000;
	1011	1	46.302	22.383	0	0	1	1.0909756	-8.3983943	110	3	1.12	0.95	101.1527	0.5971	0.0000	0.0000;
	1012	2	0	-0.01	0	0	1	1.1004372	-7.4055625	110	3	1.12	0.95	100.1896	0.3372	0.0000	0.0000;
	1013	1	2.499	0.858	0	0	1	1.1019982	-6.4849891	110	3	1.12	0.95	99.9585	-0.4394	0.0000	0.0000;
	1014	1	0	0	0	0	1	1.1020038	-6.4847634	110	3	1.12	0.95	99.9578	-0.4396	0.0000	0.0000;
	1015	1	4.868	1.492	0	0	1	1.069527	-8.1144988	110	3	1.12	0.95	101.1265	-0.0101	0.0000	0.0000;
	1016	1	7.123	1.679	0	0	1	1.0695703	-8.1201584	110	3	1.12	0.95	101.1267	-0.0122	0.0000	0.0000;
	1017	1	5.002	1.543	0	0	1	1.049166	-15.648309	110	3	1.12	0.95	108.0918	0.8092	0.0000	0.0000;
	1018	1	0	0	0	0	1	1.0492114	-15.644832	110	3	1.12	0.95	108.0869	0.8077	0.0000	0.0000;
	1019	1	0.023	0.14	0	0	1	1.091208	-4.393371	110	3	1.12	0.95	98.7242	0.0654	0.0000	0.0000;
	1020	1	0	0	0	0	1	1.0912115	-4.3933938	110	3	1.12	0.95	98.7241	0.0652	0.0000	0.0000;
	1021	2	26.881	8.08	0	0	1	1.0982527	-8.2327141	110	3	1.12	0.95	101.1905	0.1737	0.0000	0.0000;
	1022	2	0	1.5	0	0	1	1.0982549	-8.2167898	110	3	1.12	0.95	101.1863	0.1737	0.0000	0.0000;
	1023	2	7.9	3	0	0	1	1.0982059	-8.2246302	110	3	1.12	0.95	101.1893	0.1746	0.0000	0.0000;
	1024	1	0	0	0	0	1	1.0942438	-8.0609058	110	3	1.12	0.95	101.0015	0.5063	0.0000	0.0000;
	1025	1	5.818	1.585	0	0	1	1.0865457	-7.6319217	110	3	1.12	0.95	100.5352	0.3340	0.0000	0.0000;
	1026	1	0	0	0	0	1	1.0866006	-7.6276966	110	3	1.12	0.95	100.5294	0.3324	0.0000	0.0000;
	1027	1	0	0	0	0	1	1.1120265	-3.7946951	110	3	1.12	0.95	98.3878	-0.0000	0.0000	0.0000;
	1028	1	0	0	0	0	1	1.1118889	-3.8135056	110	3	1.12	0.95	98.3949	0.0018	0.0000	0.0000;
	1029	1	0	0	0	0	1	1.0727616	-8.0981828	110	3	1.12	0.95	101.0008	-0.2193	0.0000	0.0000;
	1030	1	0	0	0	0	1	1.0727613	-8.098178	110	3	1.12	0.95	101.0008	-0.2193	0.0000	0.0000;
	1031	1	0	0	0	0	1	1.1095533	-4.0553044	110	3	1.12	0.95	98.5854	0.0586	0.0000	0.0000;
	1032	1	0	0	0	0	1	1.1090135	-6.4366688	110	3	1.12	0.95	99.3051	0.0896	0.0000	0.0000;
	1033	1	0	0	0	0	1	1.108925	-6.4457231	110	3	1.12	0.95	99.3114	0.0902	0.0000	0.0000;
	1034	1	0.236	0	0	0	1	1.1052294	-6.0303577	110	3	1.12	0.95	99.2857	0.2900	0.0000	0.0000;
	1035	1	0	0	0	0	1	1.105227	-6.0319079	110	3	1.12	0.95	99.2862	0.2900	0.0000	0.0000;
	1036	1	2.85	0.746	0	0	1	1.0930303	-4.2903207	110	3	1.12	0.95	98.6508	0.0106	0.0000	0.0000;
	1037	1	0	0	0	0	1	1.0930738	-4.2855575	110	3	1.12	0.95	98.6491	0.0100	0.0000	0.0000;
	1038	1	1.781	0.373	0	0	1	1.1001226	-4.8623306	110	3	1.12	0.95	99.6072	0.2732	0.0000	0.0000;
	1039	1	0.594	0.466	0	0	1	1.1000753	-4.8628856	110	3	1.12	0.95	99.6082	0.2739	0.0000	0.0000;
	1040	1	0	0	0	0	1	1.1052297	-6.0302933	110	3	1.12	0.95	99.2856	0.2900	0.0000	0.0000;
	1041	1	0	0	0	0	1	1.1052269	-6.0319075	110	3	1.12	0.95	99.2862	0.2900	0.0000	0.0000;
	1042	1	22.596	5.736	0	0	1	1.0932176	-5.9207298	110	3	1.12	0.95	100.3206	0.4295	0.0000	0.0000;
	1043	1	0	0	0	0	1	1.1070367	-4.5032435	110	3	1.12	0.95	98.9290	0.1143	0.0000	0.0000;
	1044	1	9.688	1.949	0	0	1	1.090931	-8.1399896	110	3	1.12	0.95	101.3227	0.5713	0.0000	0.0000;
	1045	1	0	0	0	0	1	1.091093	-8.1197079	110	3	1.12	0.95	101.3137	0.5684	0.0000	0.0000;
	1046	1	10.825	2.544	0	0	1	1.1046948	-7.0826784	110	3	1.12	0.95	99.7085	0.2729	0.0000	0.0000;
	1047	1	9.872	2.171	0	0	1	1.104764	-7.0726779	110	3	1.12	0.95	99.7041	0.2728	0.0000	0.0000;
	1048	1	0.355	0.168	0	0	1	1.0838737	-7.3359802	110	3	1.12	0.95	100.4342	-0.5543	0.0000	0.0000;
	1049	1	0	0	0	0	1	1.0837999	-7.3303695	110	3	1.12	0.95	100.4322	-0.5527	0.0000	0.0000;
	1050	1	12.584	0.933	0	0	1	1.0998343	-4.8799703	110	3	1.12	0.95	100.4311	0.3896	0.0000	0.0000;
	1051	1	0	0.14	0	0	1	1.1004118	-4.950284	110	3	1.12	0.95	100.5093	0.3611	0.0000	0.0000;
	1052	1	3.924	1.329	0	0	1	1.0795577	-6.4819251	110	3	1.12	0.95	99.5124	0.0152	0.0000	0.0000;
	1053	1	0	0	0	0	1	1.0796766	-6.4778209	110	3	1.12	0.95	99.4969	0.0100	0.0000	0.0000;
	1054	1	11.198	0.625	0	0	1	1.0810823	-7.1544022	110	3	1.12	0.95	104.4470	0.3809	0.0000	0.0000;
	1055	1	0	0	0	0	1	1.081078	-7.1635825	110	3	1.12	0.95	104.4510	0.3805	0.0000	0.0000;
	1056	1	5.461	0.839	0	0	1	1.0926969	-7.1750492	110	3	1.12	0.95	99.8644	0.0089	0.0000	0.0000;
	1057	1	6.529	1.026	0	0	1	1.0927666	-7.1636296	110	3	1.12	0.95	99.8561	0.0081	0.0000	0.0000;
	1058	1	0	0	0	0	1	1.0919444	-4.3591657	110	3	1.12	0.95	98.7375	0.0456	0.0000	0.0000;
	1059	1	13.891	5.129	0	0	1	1.0919071	-4.362826	110	3	1.12	0.95	98.7389	0.0462	0.0000	0.0000;
	1060	1	3.594	1.288	0	0	1	1.0533279	-15.70758	110	3	1.12	0.95	107.2590	0.6789	0.0000	0.0000;
	1061	1	0	0	0	0	1	1.0405378	-11.160545	110	3	1.12	0.95	108.7652	1.5295	0.0000	0.0000;
	1062	1	13.593	4.022	0	0	1	1.0405246	-11.154655	110	3	1.12	0.95	108.7654	1.5300	0.0000	0.0000;
	1063	1	0	0	0	0	1	1.1005589	-6.888946	110	3	1.12	0.95	100.1502	0.4157	0.0000	0.0000;
	1064	1	4.514	0.863	0	0	1	1.1005759	-6.8763068	110	3	1.12	0.95	100.1519	0.4160	0.0000	0.0000;
	1065	1	1.07	0.43	0	0	1	1.100557	-6.8889121	110	3	1.12	0.95	100.1502	0.4158	0.0000	0.0000;
	1066	1	6.173	2.425	0	0	1	1.0942347	-5.5273415	110	3	1.12	0.95	101.2954	0.5078	0.0000	0.0000;
	1067	1	14.247	1.679	0	0	1	1.0942953	-5.5192128	110	3	1.12	0.95	101.2901	0.5065	0.0000	0.0000;
	1068	1	10.097	3.824	0	0	1	1.0893613	-4.6437583	110	3	1.12	0.95	99.0467	0.0788	0.0000	0.0000;
	1069	1	0	0	0	0	1	1.0894067	-4.6335818	110	3	1.12	0.95	99.0402	0.0771	0.0000	0.0000;
	1070	1	15.428	2.775	0	0	1	1.0883247	-9.951766	110	3	1.12	0.95	102.5091	0.0864	0.0000	0.0000;
	1071	1	12.048	1.834	0	0	1	1.0883446	-9.9617277	110	3	1.12	0.95	102.5093	0.0871	0.0000	0.0000;
	1072	1	5.113	1.322	0	0	1	1.1084876	-3.7127966	110	3	1.12	0.95	99.4336	0.2291	0.0000	0.0000;
	1073	1	9.049	2.383	0	0	1	1.1085985	-3.6824356	110	3	1.12	0.95	99.4290	0.2277	0.0000	0.0000;
	1074	1	0	0	0	0	1	1.056935	-15.626019	110	3	1.12	0.95	107.6835	0.3737	0.0000	0.0000;
	1075	1	0	0	0	0	1	1.0569986	-15.611798	110	3	1.12	0.95	107.6723	0.3725	0.0000	0.0000;
	1076	2	7.73	3.573	0	0	1	1.085149	-6.4199422	110	3	1.12	0.95	103.5395	0.4197	0.0000	0.0000;
	1077	1	4.041	0.336	0	0	1	1.0851449	-6.4239777	110	3	1.12	0.95	103.5411	0.4196	0.0000	0.0000;
	1078	1	14.286	4.48	0	0	1	1.0721084	-8.3198867	110	3	1.12	0.95	101.2165	-0.3144	0.0000	0.0000;
	1079	1	0	0	0	0	1	1.0726255	-8.2566102	110	3	1.12	0.95	101.1429	-0.3198	0.0000	0.0000;
	1080	1	0	0	0	0	1	1.072169	-8.3157318	110	3	1.12	0.95	101.2103	-0.3163	0.0000	0.0000;
	1081	1	0	0	0	0	1	1.072625	-8.2566014	110	3	1.12	0.95	101.1429	-0.3198	0.0000	0.0000;
	1082	1	6.304	0.432	0	0	1	1.1033286	-4.3870518	110	3	1.12	0.95	100.0489	0.3231	0.0000	0.0000;
	1083	1	4.161	0.712	0	0	1	1.1032586	-4.4085943	110	3	1.12	0.95	100.0505	0.3238	0.0000	0.0000;
	1084	1	4.513	1.624	0	0	1	1.0767798	-12.910768	110	3	1.12	0.95	103.7638	0.1168	0.0000	0.0000;
	1085	1	0	0	0	0	1	1.0767701	-12.921735	110	3	1.12	0.95	103.7684	0.1165	0.0000	0.0000;
	1086	1	4.749	1.865	0	0	1	1.0949722	-6.8658091	110	3	1.12	0.95	99.6204	0.2164	0.0000	0.0000;
	1087	1	0	0	0	0	1	1.0951142	-6.846666	110	3	1.12	0.95	99.6111	0.2160	0.0000	0.0000;
	1088	1	6.173	0.093	0	0	1	1.1004144	-4.9503624	110	3	1.12	0.95	100.5093	0.3608	0.0000	0.0000;
	1089	1	8.547	3.357	0	0	1	1.1000049	-4.8667545	110	3	1.12	0.95	100.4033	0.3876	0.0000	0.0000;
	1090	1	5.465	1.022	0	0	1	1.0810913	-12.574125	110	3	1.12	0.95	103.1917	0.0860	0.0000	0.0000;
	1091	1	0	0	0	0	1	1.0812852	-12.565226	110	3	1.12	0.95	103.1614	0.0806	0.0000	0.0000;
	1092	1	10.059	2.72	0	0	1	1.051061	-15.91349	110	3	1.12	0.95	108.0380	0.6754	0.0000	0.0000;
	1093	1	5.553	1.748	0	0	1	1.051055	-15.913142	110	3	1.12	0.95	108.0342	0.6745	0.0000	0.0000;
	1094	1	0	0	0	0	1	1.0999402	-6.3705777	110	3	1.12	0.95	99.7038	0.4975	0.0000	0.0000;
	1095	1	0	0	0	0	1	1.1022458	-6.1518957	110	3	1.12	0.95	99.4432	0.4218	0.0000	0.0000;
	1096	1	0	0	0	0	1	1.0999383	-6.3705293	110	3	1.12	0.95	99.7038	0.4977	0.0000	0.0000;
	1097	1	0	0	0	0	1	1.1022448	-6.1518782	110	3	1.12	0.95	99.4432	0.4218	0.0000	0.0000;
	1098	1	4.162	2.236	0	0	1	1.0938946	-7.6925896	110	3	1.12	0.95	100.8453	-0.4503	0.0000	0.0000;
	1099	1	0	0	0	0	1	1.0939196	-7.6923207	110	3	1.12	0.95	100.8420	-0.4502	0.0000	0.0000;
	1100	1	0	0	0	0	1	1.1056939	-6.1171561	110	3	1.12	0.95	99.4428	0.2805	0.0000	0.0000;
	1101	1	17.239	2.658	0	0	1	1.0887899	-7.4832749	110	3	1.12	0.95	100.2556	0.1177	0.0000	0.0000;
	1102	1	0	0	0	0	1	1.1056904	-6.1170979	110	3	1.12	0.95	99.4428	0.2807	0.0000	0.0000;
	1103	1	0	0	0	0	1	1.0893102	-7.428276	110	3	1.12	0.95	100.1904	0.1077	0.0000	0.0000;
	1104	1	0.237	0.234	0	0	1	1.0963379	-5.3080827	110	3	1.12	0.95	101.0915	0.4304	0.0000	0.0000;
	1105	1	0.713	-0.136	0	0	1	1.0963197	-5.3121307	110	3	1.12	0.95	101.0945	0.4308	0.0000	0.0000;
	1106	1	4.273	0.372	0	0	1	1.0910578	-4.5397389	110	3	1.12	0.95	98.7784	0.0465	0.0000	0.0000;
	1107	1	0	0	0	0	1	1.091039	-4.551431	110	3	1.12	0.95	98.7801	0.0486	0.0000	0.0000;
	1108	2	7.001	-0.048	0	0	1	1.0761949	-8.0834616	110	3	1.12	0.95	105.6046	0.2895	0.0000	0.0000;
	1109	1	7.132	-0.925	0	0	1	1.0436734	-11.400213	110	3	1.12	0.95	108.8846	1.1513	0.0000	0.0000;
	1110	2	2.612	1.865	0	0	1	1.1024337	-4.6806138	110	3	1.12	0.95	99.4174	0.1920	0.0000	0.0000;
	1111	2	7.071	9.645	0	0	1	1.0930587	-7.1330844	110	3	1.12	0.95	99.8191	0.0027	0.0000	0.0000;
	1112	2	0	0	0	0	1	1.1058938	-6.0751179	110	3	1.12	0.95	99.3958	0.2839	0.0000	0.0000;
	1113	1	0.95	0.495	0	0	1	1.1118311	-3.5741908	110	3	1.12	0.95	99.1005	0.1551	0.0000	0.0000;
	1114	2	5.69	2.111	0	0	1	1.111724	-3.5965531	110	3	1.12	0.95	99.1063	0.1567	0.0000	0.0000;
	1115	1	18.5	1.743	0	0	1	1.0643531	-9.7860303	110	3	1.12	0.95	103.7615	1.5806	0.0000	0.0000;
	1116	1	0	0	0	0	1	1.0645075	-9.7679169	110	3	1.12	0.95	103.7507	1.5769	0.0000	0.0000;
	1117	1	14.365	6.249	0	0	1	1.0569731	-13.813782	110	3	1.12	0.95	107.2454	0.7748	0.0000	0.0000;
	1118	1	0.713	0	0	0	1	1.057193	-13.784977	110	3	1.12	0.95	107.2349	0.7689	0.0000	0.0000;
	1119	1	0	0	0	0	1	1.0710259	-8.1100197	110	3	1.12	0.95	101.0747	-0.1062	0.0000	0.0000;
	1120	1	0	0	0	0	1	1.0710245	-8.1099874	110	3	1.12	0.95	101.0747	-0.1061	0.0000	0.0000;
	1121	1	5.341	0.092	0	0	1	1.0938378	-7.6967189	110	3	1.12	0.95	100.8571	-0.4513	0.0000	0.0000;
	1122	1	0	0	0	0	1	1.093951	-7.692652	110	3	1.12	0.95	100.8377	-0.4506	0.0000	0.0000;
	1123	1	0	0	0	0	1	1.0938999	-7.6912707	110	3	1.12	0.95	100.8460	-0.4515	0.0000	0.0000;
	1124	1	0	0	0	0	1	1.0939508	-7.6926456	110	3	1.12	0.95	100.8377	-0.4506	0.0000	0.0000;
	1125	1	0	0	0	0	1	1.0942738	-7.7101905	110	3	1.12	0.95	100.7963	-0.4555	0.0000	0.0000;
	1126	1	0	0	0	0	1	1.0941921	-7.69544	110	3	1.12	0.95	100.8038	-0.4539	0.0000	0.0000;
	1127	1	0	0	0	0	1	1.0942734	-7.7101846	110	3	1.12	0.95	100.7963	-0.4555	0.0000	0.0000;
	1128	1	0	0	0	0	1	1.0941921	-7.6954399	110	3	1.12	0.95	100.8038	-0.4539	0.0000	0.0000;
	1129	2	0.714	0.511	0	0	1	1.0878799	-7.5022696	110	3	1.12	0.95	99.9954	-0.4292	0.0000	0.0000;
	1130	1	3.802	0.273	0	0	1	1.0941745	-7.7178516	110	3	1.12	0.95	100.8125	-0.4544	0.0000	0.0000;
	1131	1	14.252	0.983	0	0	1	1.0938882	-7.732143	110	3	1.12	0.95	100.8655	-0.4614	0.0000	0.0000;
	1132	1	0	0	0	0	1	1.0939034	-7.7302602	110	3	1.12	0.95	100.8629	-0.4612	0.0000	0.0000;
	1133	1	9.751	2.436	0	0	1	1.0715333	-8.4684827	110	3	1.12	0.95	102.4189	-0.1584	0.0000	0.0000;
	1134	1	0	0	0	0	1	1.0715105	-8.4793359	110	3	1.12	0.95	102.4180	-0.1604	0.0000	0.0000;
	1135	1	4.274	1.679	0	0	1	1.1101149	-4.065667	110	3	1.12	0.95	98.6746	0.0046	0.0000	0.0000;
	1136	1	32.054	9.325	0	0	1	1.1157545	-5.300095	110	3	1.12	0.95	98.5422	0.0361	0.0000	0.0000;
	1137	1	0	0	0	0	1	1.1071817	-4.2135428	110	3	1.12	0.95	99.0651	0.0840	0.0000	0.0000;
	1138	1	103.286	29.843	0	0	1	1.1044698	-4.4174611	110	3	1.12	0.95	99.3267	0.1599	0.0000	0.0000;
	1139	1	0	0	0	0	1	1.1071816	-4.2135413	110	3	1.12	0.95	99.0651	0.0840	0.0000	0.0000;
	1140	1	0	0	0	0	1	1.1159836	-5.2823627	110	3	1.12	0.95	98.5212	0.0300	0.0000	0.0000;
	1141	1	0	0	0	0	1	1.1061713	-4.2780563	110	3	1.12	0.95	99.1733	0.1152	0.0000	0.0000;
	1142	1	13.059	4.662	0	0	1	1.0869312	-7.7709018	110	3	1.12	0.95	100.6365	-0.2123	0.0000	0.0000;
	1143	1	0	0	0	0	1	1.0869664	-7.7676317	110	3	1.12	0.95	100.6351	-0.2108	0.0000	0.0000;
	1144	1	0	0	0	0	1	1.0869776	-7.7655947	110	3	1.12	0.95	100.6344	-0.2134	0.0000	0.0000;
	1145	1	0	0	0	0	1	1.0767669	-8.1267104	110	3	1.12	0.95	101.0477	-0.2103	0.0000	0.0000;
	1146	1	1.663	0.466	0	0	1	1.0738059	-8.292198	110	3	1.12	0.95	101.1937	-0.2118	0.0000	0.0000;
	1147	1	5.935	0	0	0	1	1.0971419	-5.329761	110	3	1.12	0.95	101.6127	0.3000	0.0000	0.0000;
	1148	1	11.873	-0.093	0	0	1	1.0971003	-5.336233	110	3	1.12	0.95	101.6145	0.3009	0.0000	0.0000;
	1149	1	1.187	0.373	0	0	1	1.1022069	-4.7676551	110	3	1.12	0.95	99.4522	0.1929	0.0000	0.0000;
	1150	1	2.374	0.839	0	0	1	1.1022594	-4.7620283	110	3	1.12	0.95	99.4504	0.1924	0.0000	0.0000;
	1151	2	18.701	5.037	0	0	1	1.0901955	-9.1377875	110	3	1.12	0.95	101.8651	0.0583	0.0000	0.0000;
	1152	2	17.406	4.737	0	0	1	1.0904248	-9.1188251	110	3	1.12	0.95	101.8255	0.0564	0.0000	0.0000;
	1153	2	18.605	5.019	0	0	1	1.0917431	-9.0531796	110	3	1.12	0.95	101.3782	0.0795	0.0000	0.0000;
	1154	1	15.582	4.532	0	0	1	1.0897683	-9.2011644	110	3	1.12	0.95	101.9351	0.0739	0.0000	0.0000;
	1155	1	7.791	2.266	0	0	1	1.0897561	-9.1970156	110	3	1.12	0.95	101.9358	0.0730	0.0000	0.0000;
	1156	1	10.146	4.509	0	0	1	1.0904652	-9.2088894	110	3	1.12	0.95	101.8898	0.0542	0.0000	0.0000;
	1157	1	13.925	4.814	0	0	1	1.0914289	-9.1163098	110	3	1.12	0.95	101.5139	0.0630	0.0000	0.0000;
	1158	1	1.045	0.447	0	0	1	1.091662	-9.0579403	110	3	1.12	0.95	101.3887	0.0820	0.0000	0.0000;
	1159	1	1.33	0.521	0	0	1	1.0901157	-9.1425063	110	3	1.12	0.95	101.8755	0.0608	0.0000	0.0000;
	1160	1	0	0	0	0	1	1.0916814	-9.0570447	110	3	1.12	0.95	101.3868	0.0812	0.0000	0.0000;
	1161	1	12.245	4.694	0	0	1	1.0917256	-9.0947444	110	3	1.12	0.95	101.4860	0.0541	0.0000	0.0000;
	1162	1	6.32	0.687	0	0	1	1.0907926	-9.1935013	110	3	1.12	0.95	101.8680	0.0413	0.0000	0.0000;
	1163	1	7.805	2.219	0	0	1	1.090271	-9.1976228	110	3	1.12	0.95	101.9026	0.0541	0.0000	0.0000;
	1164	1	7.805	2.219	0	0	1	1.0903205	-9.1978157	110	3	1.12	0.95	101.8996	0.0545	0.0000	0.0000;
	1165	1	2.997	0.899	0	0	1	1.0918206	-9.1303782	110	3	1.12	0.95	101.4488	0.0753	0.0000	0.0000;
	1166	1	1.76	0.528	0	0	1	1.0916952	-9.0722131	110	3	1.12	0.95	101.4267	0.0683	0.0000	0.0000;
	1167	1	0	0	0	0	1	1.0918314	-9.1297703	110	3	1.12	0.95	101.4475	0.0749	0.0000	0.0000;
	1168	1	0	0	0	0	1	1.0917033	-9.0718064	110	3	1.12	0.95	101.4257	0.0680	0.0000	0.0000;
	1169	1	3.681	1.119	0	0	1	1.1025503	-6.1802001	110	3	1.12	0.95	99.4007	0.4126	0.0000	0.0000;
	1170	1	0.356	0.093	0	0	1	1.1027243	-6.149437	110	3	1.12	0.95	99.3938	0.4095	0.0000	0.0000;
	1171	1	0.474	0.187	0	0	1	1.0966259	-6.2621232	110	3	1.12	0.95	100.1970	0.3447	0.0000	0.0000;
	1172	1	0	0	0	0	1	1.0966259	-6.2621232	110	3	1.12	0.95	100.1970	0.3447	0.0000	0.0000;
	1173	1	0.474	0.093	0	0	1	1.1074127	-6.322865	110	3	1.12	0.95	99.4812	0.0692	0.0000	0.0000;
	1174	1	0	0	0	0	1	1.1074189	-6.3222021	110	3	1.12	0.95	99.4805	0.0691	0.0000	0.0000;
	1175	1	0	0	0	0	1	1.0966647	-6.256003	110	3	1.12	0.95	100.1899	0.3447	0.0000	0.0000;
	1176	1	10.934	3.404	0	0	1	1.1056102	-6.9089496	110	3	1.12	0.95	99.6531	0.2029	0.0000	0.0000;
	1177	1	7.84	2.285	0	0	1	1.1079146	-6.0461504	110	3	1.12	0.95	99.3735	0.0590	0.0000	0.0000;
	1178	2	9.681	9.119	0	0	1	1.0945034	-4.2592396	110	3	1.12	0.95	98.4789	-0.0000	0.0000	0.0000;
	1179	2	11.519	12.532	0	0	1	1.1094675	-5.7396191	110	3	1.12	0.95	99.2113	-0.0000	0.0000	0.0000;
	1180	1	3.685	0.961	0	0	1	1.0587599	-12.514093	110	3	1.12	0.95	106.7014	1.1390	0.0000	0.0000;
	1181	1	2.342	0.858	0	0	1	1.0586896	-12.511436	110	3	1.12	0.95	106.7074	1.1405	0.0000	0.0000;
	1182	1	0	0	0	0	1	1.0908691	-4.7916795	110	3	1.12	0.95	98.9448	0.0726	0.0000	0.0000;
	1183	1	0	0	0	0	1	1.0908691	-4.7916795	110	3	1.12	0.95	98.9448	0.0726	0.0000	0.0000;
	1184	1	15.434	6.528	0	0	1	1.0951747	-6.6619912	110	3	1.12	0.95	100.2929	0.6629	0.0000	0.0000;
	1185	1	13.06	3.731	0	0	1	1.0950898	-6.6811481	110	3	1.12	0.95	100.2956	0.6644	0.0000	0.0000;
	1186	1	56.987	16.788	0	0	1	1.0359161	-5.7483923	110	3	1.12	0.95	99.5179	0.1357	0.0000	0.0000;
	1187	2	90.209	40.084	0	0	1	1.0887069	-4.7481234	110	3	1.12	0.95	99.2364	0.0831	0.0000	0.0000;
	1188	2	0	-0.01	0	0	1	1.0921612	-4.3399364	110	3	1.12	0.95	98.7141	0.0400	0.0000	0.0000;
	1189	1	7.736	1.759	0	0	1	1.109112	-4.0952369	110	3	1.12	0.95	98.6316	0.0687	0.0000	0.0000;
	1190	1	0	0	0	0	1	1.0921486	-4.3427193	110	3	1.12	0.95	98.7141	0.0400	0.0000	0.0000;
	1191	1	2.973	0.864	0	0	1	1.0845021	-7.9496699	110	3	1.12	0.95	101.1132	0.3053	0.0000	0.0000;
	1192	1	0	0	0	0	1	1.0846765	-7.9353343	110	3	1.12	0.95	101.0953	0.3005	0.0000	0.0000;
	1193	1	17.808	12.777	0	0	1	1.0884017	-7.385424	110	3	1.12	0.95	101.0172	0.8622	0.0000	0.0000;
	1194	1	0	0	0	0	1	1.0884946	-7.3757361	110	3	1.12	0.95	101.0130	0.8606	0.0000	0.0000;
	1195	1	0	0	0	0	1	1.0889788	-7.600995	110	3	1.12	0.95	101.1650	0.7661	0.0000	0.0000;
	1196	1	4.751	1.073	0	0	1	1.0857897	-8.0409812	110	3	1.12	0.95	101.4465	0.8039	0.0000	0.0000;
	1197	1	0.594	0.14	0	0	1	1.0867104	-7.9710122	110	3	1.12	0.95	101.2965	0.7928	0.0000	0.0000;
	1198	1	0	0	0	0	1	1.0858496	-8.0366787	110	3	1.12	0.95	101.4389	0.8022	0.0000	0.0000;
	1199	1	0	0	0	0	1	1.0867178	-7.9704723	110	3	1.12	0.95	101.2955	0.7926	0.0000	0.0000;
	1200	1	2.376	0.352	0	0	1	1.1043326	-7.0624556	110	3	1.12	0.95	99.7840	0.2372	0.0000	0.0000;
	1201	1	0	0	0	0	1	1.104352	-7.0578946	110	3	1.12	0.95	99.7836	0.2368	0.0000	0.0000;
	1202	1	1.424	0.373	0	0	1	1.1120096	-3.7962728	110	3	1.12	0.95	98.3893	0.0004	0.0000	0.0000;
	1203	1	4.637	1.212	0	0	1	1.0860474	-8.6910163	110	3	1.12	0.95	101.9250	-0.3578	0.0000	0.0000;
	1204	1	0	0	0	0	1	1.0860463	-8.7022199	110	3	1.12	0.95	101.9214	-0.3586	0.0000	0.0000;
	1205	1	6.529	1.865	0	0	1	1.0750109	-7.1914998	110	3	1.12	0.95	100.2112	0.0216	0.0000	0.0000;
	1206	1	0	0	0	0	1	1.0749886	-7.2056074	110	3	1.12	0.95	100.2146	0.0208	0.0000	0.0000;
	1207	1	0.119	0.093	0	0	1	1.101326	-7.3791014	110	3	1.12	0.95	100.0954	0.3158	0.0000	0.0000;
	1208	1	0	0	0	0	1	1.1013506	-7.3747908	110	3	1.12	0.95	100.0931	0.3156	0.0000	0.0000;
	1209	1	13.079	4.6	0	0	1	1.1048828	-7.0078606	110	3	1.12	0.95	99.7391	0.1968	0.0000	0.0000;
	1210	1	0	0	0	0	1	1.1049062	-7.0097467	110	3	1.12	0.95	99.7379	0.1963	0.0000	0.0000;
	1211	1	4.875	-1.02	0	0	1	1.0940053	-7.7428153	110	3	1.12	0.95	101.4238	-0.7590	0.0000	0.0000;
	1212	1	0	0	0	0	1	1.0939938	-7.7431573	110	3	1.12	0.95	101.4248	-0.7562	0.0000	0.0000;
	1213	1	9.551	2.279	0	0	1	1.0528134	-11.897731	110	3	1.12	0.95	106.9364	1.6385	0.0000	0.0000;
	1214	1	3.379	1.148	0	0	1	1.0527678	-11.890025	110	3	1.12	0.95	106.9402	1.6398	0.0000	0.0000;
	1215	1	7.722	2.565	0	0	1	1.0764603	-6.825992	110	3	1.12	0.95	99.8932	0.0678	0.0000	0.0000;
	1216	1	0	0	0	0	1	1.0764939	-6.8248328	110	3	1.12	0.95	99.8888	0.0664	0.0000	0.0000;
	1217	1	7.485	1.632	0	0	1	1.091908	-4.4154877	110	3	1.12	0.95	98.7588	0.0507	0.0000	0.0000;
	1218	1	4.038	0.979	0	0	1	1.0915048	-4.8247802	110	3	1.12	0.95	98.9443	0.0592	0.0000	0.0000;
	1219	1	2.066	0.587	0	0	1	1.0947581	-8.0187744	110	3	1.12	0.95	100.8583	0.4869	0.0000	0.0000;
	1220	1	0	0	0	0	1	1.0947549	-8.0194845	110	3	1.12	0.95	100.8600	0.4873	0.0000	0.0000;
	1221	1	4.159	1.482	0	0	1	1.0848157	-7.4416288	110	3	1.12	0.95	100.5233	-0.6329	0.0000	0.0000;
	1222	1	7.129	2.508	0	0	1	1.0853283	-7.304549	110	3	1.12	0.95	100.4265	-0.6539	0.0000	0.0000;
	1223	1	13.102	3.889	0	0	1	1.0862866	-9.980038	110	3	1.12	0.95	102.4857	0.4182	0.0000	0.0000;
	1224	1	0	0	0	0	1	1.0862048	-9.9823447	110	3	1.12	0.95	102.4859	0.4205	0.0000	0.0000;
	1225	1	9.896	1.658	0	0	1	1.0629706	-13.353003	110	3	1.12	0.95	107.0793	0.5204	0.0000	0.0000;
	1226	2	9.254	0.964	0	0	1	1.0640676	-13.2756	110	3	1.12	0.95	106.9314	0.4813	0.0000	0.0000;
	1227	1	0	0	0	0	1	1.0638401	-13.308291	110	3	1.12	0.95	106.9344	0.4968	0.0000	0.0000;
	1228	1	0	0	0	0	1	1.0644302	-13.245795	110	3	1.12	0.95	106.8665	0.4765	0.0000	0.0000;
	1229	1	11.049	2.844	0	0	1	1.1050162	-4.488087	110	3	1.12	0.95	99.1813	0.1287	0.0000	0.0000;
	1230	1	0	0	0	0	1	1.1049764	-4.4933899	110	3	1.12	0.95	99.1833	0.1291	0.0000	0.0000;
	1231	1	0	0	0	0	1	1.1095522	-4.0552855	110	3	1.12	0.95	98.5854	0.0587	0.0000	0.0000;
	1232	1	0	0	0	0	1	1.093479	-4.2574891	110	3	1.12	0.95	98.6150	-0.0023	0.0000	0.0000;
	1233	1	8.911	2.658	0	0	1	1.0917109	-7.8635294	110	3	1.12	0.95	101.1236	-0.4833	0.0000	0.0000;
	1234	1	17.593	3.777	0	0	1	1.0917006	-7.8664356	110	3	1.12	0.95	101.1212	-0.4794	0.0000	0.0000;
	1235	1	4.157	1.586	0	0	1	1.0908139	-4.5376254	110	3	1.12	0.95	98.9092	0.0648	0.0000	0.0000;
	1236	1	0	0	0	0	1	1.0908679	-4.5239834	110	3	1.12	0.95	98.9046	0.0645	0.0000	0.0000;
	1237	1	0	0	0	0	1	1.0720114	-7.8030873	110	3	1.12	0.95	100.7702	-0.0285	0.0000	0.0000;
	1238	1	0	0	0	0	1	1.0720114	-7.8030872	110	3	1.12	0.95	100.7702	-0.0285	0.0000	0.0000;
	1239	1	9.08	1.884	0	0	1	1.0890351	-8.5280791	110	3	1.12	0.95	101.4219	0.6473	0.0000	0.0000;
	1240	1	0	0	0	0	1	1.0889856	-8.5384178	110	3	1.12	0.95	101.4247	0.6478	0.0000	0.0000;
	1241	1	8.348	2.261	0	0	1	1.0942961	-7.594253	110	3	1.12	0.95	100.8536	-0.5575	0.0000	0.0000;
	1242	1	0	0	0	0	1	1.0942996	-7.5923083	110	3	1.12	0.95	100.8598	-0.5634	0.0000	0.0000;
	1243	1	12.715	2.272	0	0	1	1.0553791	-14.476525	110	3	1.12	0.95	107.1633	0.8414	0.0000	0.0000;
	1244	1	0	0	0	0	1	1.055382	-14.495386	110	3	1.12	0.95	107.1541	0.8388	0.0000	0.0000;
	1245	2	82.621	44.944	0	0	1	1.0785088	-8.0349359	110	3	1.12	0.95	101.1239	0.7031	0.0000	0.0000;
	1246	2	43.204	11.74	0	0	1	1.0916227	-7.3781638	110	3	1.12	0.95	100.2662	0.2133	0.0000	0.0000;
	1247	2	34.755	9.168	0	0	1	1.0875022	-8.5300555	110	3	1.12	0.95	101.6871	0.6789	0.0000	0.0000;
	1248	1	0	0	0	0	1	1.0875584	-8.5213841	110	3	1.12	0.95	101.6857	0.6779	0.0000	0.0000;
	1249	1	1.663	0.466	0	0	1	1.092494	-7.1683713	110	3	1.12	0.95	99.8664	0.0063	0.0000	0.0000;
	1250	1	6.529	1.026	0	0	1	1.1025009	-4.6808748	110	3	1.12	0.95	99.4188	0.1890	0.0000	0.0000;
	1251	1	0	0	0	0	1	1.0925177	-7.1674333	110	3	1.12	0.95	99.8632	0.0055	0.0000	0.0000;
	1252	1	0	0	0	0	1	1.1025578	-4.6769046	110	3	1.12	0.95	99.4108	0.1878	0.0000	0.0000;
	1253	1	0	0	0	0	1	1.0799271	-12.424259	110	3	1.12	0.95	103.1688	0.1139	0.0000	0.0000;
	1254	1	0	0	0	0	1	1.0757993	-12.932759	110	3	1.12	0.95	103.5761	0.2508	0.0000	0.0000;
	1255	1	6.529	0.932	0	0	1	1.0858095	-6.8795792	110	3	1.12	0.95	100.5999	0.0243	0.0000	0.0000;
	1256	1	0	0	0	0	1	1.0858215	-6.8769944	110	3	1.12	0.95	100.5990	0.0241	0.0000	0.0000;
	1257	1	9.524	0.484	0	0	1	1.1054048	-5.9987378	110	3	1.12	0.95	99.2495	0.2914	0.0000	0.0000;
	1258	1	0	0	0	0	1	1.1054168	-5.9933517	110	3	1.12	0.95	99.2475	0.2914	0.0000	0.0000;
	1259	1	0.831	0.332	0	0	1	1.0918785	-4.4143885	110	3	1.12	0.95	98.7613	0.0524	0.0000	0.0000;
	1260	1	0	0	0	0	1	1.0919347	-4.4115936	110	3	1.12	0.95	98.7550	0.0503	0.0000	0.0000;
	1261	1	0	0	0	0	1	1.0955188	-7.4217737	110	3	1.12	0.95	100.8814	-1.0778	0.0000	0.0000;
	1262	1	0	0	0	0	1	1.0956111	-7.4110789	110	3	1.12	0.95	100.8752	-1.0883	0.0000	0.0000;
	1263	1	0.95	0.276	0	0	1	1.0783262	-8.0598994	110	3	1.12	0.95	100.8417	-0.2933	0.0000	0.0000;
	1264	1	0	0	0	0	1	1.07838	-8.054984	110	3	1.12	0.95	100.8397	-0.2926	0.0000	0.0000;
	1265	1	7.259	1.943	0	0	1	1.0768825	-7.2943847	110	3	1.12	0.95	103.7548	0.5300	0.0000	0.0000;
	1266	1	7.259	1.935	0	0	1	1.0769397	-7.3062429	110	3	1.12	0.95	103.7454	0.5256	0.0000	0.0000;
	1267	1	3.442	0.839	0	0	1	1.0900157	-7.3572053	110	3	1.12	0.95	100.1671	0.1808	0.0000	0.0000;
	1268	1	3.799	0	0	0	1	1.1056791	-6.1191591	110	3	1.12	0.95	99.4448	0.2807	0.0000	0.0000;
	1269	1	11.634	5.503	0	0	1	1.0892207	-7.4334346	110	3	1.12	0.95	100.1969	0.1108	0.0000	0.0000;
	1270	1	0	0	0	0	1	1.0902575	-7.3437937	110	3	1.12	0.95	100.1349	0.1735	0.0000	0.0000;
	1271	1	8.693	2.981	0	0	1	1.090699	-8.0620657	110	3	1.12	0.95	101.1958	-0.3756	0.0000	0.0000;
	1272	1	0	0	0	0	1	1.0911953	-8.0257843	110	3	1.12	0.95	101.1524	-0.3903	0.0000	0.0000;
	1273	1	0	0	0	0	1	1.0926319	-10.019163	110	3	1.12	0.95	102.2422	-0.0034	0.0000	0.0000;
	1274	1	0	0	0	0	1	1.0926317	-10.019161	110	3	1.12	0.95	102.2422	-0.0034	0.0000	0.0000;
	1275	1	11.288	2.47	0	0	1	1.1023383	-4.8241335	110	3	1.12	0.95	99.4568	0.1890	0.0000	0.0000;
	1276	1	0	0	0	0	1	1.1025061	-4.8017665	110	3	1.12	0.95	99.4501	0.1866	0.0000	0.0000;
	1277	1	7.844	1.768	0	0	1	1.0816946	-9.2657027	110	3	1.12	0.95	102.5109	-0.3156	0.0000	0.0000;
	1278	1	4.871	1.115	0	0	1	1.0816996	-9.2599025	110	3	1.12	0.95	102.5136	-0.3150	0.0000	0.0000;
	1279	2	20.186	5.192	0	0	1	1.0990554	-6.722979	110	3	1.12	0.95	100.0944	0.4227	0.0000	0.0000;
	1280	1	0	0	0	0	1	1.0991111	-6.7214898	110	3	1.12	0.95	100.0862	0.4203	0.0000	0.0000;
	1281	1	13.668	3.87	0	0	1	1.0753485	-8.5774826	110	3	1.12	0.95	101.6432	0.6509	0.0000	0.0000;
	1282	1	0	0	0	0	1	1.0752907	-8.5855474	110	3	1.12	0.95	101.6464	0.6518	0.0000	0.0000;
	1283	1	2.374	0.746	0	0	1	1.0859897	-7.6594319	110	3	1.12	0.95	100.8131	0.2660	0.0000	0.0000;
	1284	1	9.863	3.221	0	0	1	1.0942397	-8.060834	110	3	1.12	0.95	101.0015	0.5065	0.0000	0.0000;
	1285	2	11.443	8.008	0	0	1	1.0976411	-7.6396575	110	3	1.12	0.95	100.6391	0.3641	0.0000	0.0000;
	1286	2	18	42	0	0	1	1.1189541	-5.8458789	110	3	1.12	0.95	98.1775	0.0000	0.0000	0.0000;
	1287	2	12	36	0	0	1	1.1080911	-4.1287696	110	3	1.12	0.95	98.9921	0.0624	0.0000	0.0000;
	1288	1	2.257	0.039	0	0	1	1.0944972	-9.6467272	110	3	1.12	0.95	101.7837	0.0082	0.0000	0.0000;
	1289	1	2.851	0.408	0	0	1	1.0944511	-9.6439633	110	3	1.12	0.95	101.7855	0.0068	0.0000	0.0000;
	1290	1	0	0	0	0	1	1.0702574	-8.0286423	110	3	1.12	0.95	104.7221	0.6535	0.0000	0.0000;
	1291	1	6.554	1.512	0	0	1	1.0702455	-8.0227576	110	3	1.12	0.95	104.7262	0.6540	0.0000	0.0000;
	1292	1	2.496	1.042	0	0	1	1.0836827	-8.1372259	110	3	1.12	0.95	101.1859	-0.4931	0.0000	0.0000;
	1293	1	2.257	0.472	0	0	1	1.083706	-8.1511005	110	3	1.12	0.95	101.1876	-0.4898	0.0000	0.0000;
	1294	1	6.055	9.699	0	0	1	1.0988842	-4.8479157	110	3	1.12	0.95	99.6330	0.3377	0.0000	0.0000;
	1295	1	8.429	4.943	0	0	1	1.0989234	-4.845065	110	3	1.12	0.95	99.6325	0.3369	0.0000	0.0000;
	1296	2	6.764	0.699	0	0	1	1.0910231	-5.868785	110	3	1.12	0.95	101.8359	0.5427	0.0000	0.0000;
	1297	1	11.897	1.374	0	0	1	1.0910437	-5.8644441	110	3	1.12	0.95	101.8347	0.5425	0.0000	0.0000;
	1298	1	10.474	4.812	0	0	1	1.0958424	-6.2430516	110	3	1.12	0.95	100.2394	0.3669	0.0000	0.0000;
	1299	1	0	0	0	0	1	1.0959257	-6.2434817	110	3	1.12	0.95	100.2342	0.3666	0.0000	0.0000;
	1300	1	3.922	-0.132	0	0	1	1.0683317	-8.7967347	110	3	1.12	0.95	102.1898	-0.2470	0.0000	0.0000;
	1301	1	3.097	0.714	0	0	1	1.0683161	-8.7993726	110	3	1.12	0.95	102.1929	-0.2459	0.0000	0.0000;
	1302	1	11.886	-2.25	0	0	1	1.0749971	-13.4427	110	3	1.12	0.95	105.8175	0.0188	0.0000	0.0000;
	1303	1	0	0	0	0	1	1.0749522	-13.45372	110	3	1.12	0.95	105.8184	0.0189	0.0000	0.0000;
	1304	1	17.163	-0.768	0	0	1	1.0524334	-16.668445	110	3	1.12	0.95	108.6771	0.3361	0.0000	0.0000;
	1305	1	6.243	-0.652	0	0	1	1.0524361	-16.661982	110	3	1.12	0.95	108.6775	0.3363	0.0000	0.0000;
	1306	1	5.337	1.581	0	0	1	1.0912743	-7.3947588	110	3	1.12	0.95	100.6792	0.0133	0.0000	0.0000;
	1307	1	3.333	0.957	0	0	1	1.091317	-7.4075137	110	3	1.12	0.95	100.6766	0.0154	0.0000	0.0000;
	1308	1	0	0	0	0	1	1.0700653	-8.1239019	110	3	1.12	0.95	101.1187	-0.0482	0.0000	0.0000;
	1309	1	0	0	0	0	1	1.0700626	-8.1238207	110	3	1.12	0.95	101.1187	-0.0479	0.0000	0.0000;
	1310	1	4.76	0.944	0	0	1	1.0634986	-9.1772743	110	3	1.12	0.95	103.5477	-0.0948	0.0000	0.0000;
	1311	1	0	0	0	0	1	1.0634949	-9.1788123	110	3	1.12	0.95	103.5482	-0.0948	0.0000	0.0000;
	1312	1	8.311	3.257	0	0	1	1.0974408	-7.6736797	110	3	1.12	0.95	100.6316	0.4896	0.0000	0.0000;
	1313	1	0	0	0	0	1	1.0973968	-7.685644	110	3	1.12	0.95	100.6344	0.4892	0.0000	0.0000;
	1314	1	0	0.074	0	0	1	1.0923879	-4.2756013	110	3	1.12	0.95	98.5735	0.0504	0.0000	0.0000;
	1315	1	0	0	0	0	1	1.0924229	-4.2692099	110	3	1.12	0.95	98.5707	0.0505	0.0000	0.0000;
	1316	1	11.991	3.824	0	0	1	1.0888674	-7.4338615	110	3	1.12	0.95	100.2949	0.2687	0.0000	0.0000;
	1317	1	0	0	0	0	1	1.0889001	-7.4317723	110	3	1.12	0.95	100.2916	0.2676	0.0000	0.0000;
	1318	1	0	0	0	0	1	1.1072512	-5.1678132	110	3	1.12	0.95	99.1526	0.0832	0.0000	0.0000;
	1319	1	0	0	0	0	1	1.0948672	-5.9646675	110	3	1.12	0.95	100.2227	0.3839	0.0000	0.0000;
	1320	1	0	0	0	0	1	1.1072471	-5.167703	110	3	1.12	0.95	99.1526	0.0836	0.0000	0.0000;
	1321	1	0	0	0	0	1	1.0948631	-5.9645572	110	3	1.12	0.95	100.2227	0.3843	0.0000	0.0000;
	1322	1	7.123	1.492	0	0	1	1.0984082	-6.8143303	110	3	1.12	0.95	100.1119	0.4123	0.0000	0.0000;
	1323	1	6.173	1.492	0	0	1	1.0984008	-6.8147298	110	3	1.12	0.95	100.1135	0.4130	0.0000	0.0000;
	1324	1	1.187	0.187	0	0	1	1.0907386	-7.4204942	110	3	1.12	0.95	100.2988	0.2224	0.0000	0.0000;
	1325	1	0	0	0	0	1	1.0821665	-7.8381908	110	3	1.12	0.95	100.8429	0.5454	0.0000	0.0000;
	1326	1	0	0	0	0	1	1.0907459	-7.4198756	110	3	1.12	0.95	100.2978	0.2223	0.0000	0.0000;
	1327	1	0	0	0	0	1	1.0821664	-7.8381889	110	3	1.12	0.95	100.8429	0.5454	0.0000	0.0000;
	1328	1	0	1.364	0	0	1	1.0919383	-10.003676	110	3	1.12	0.95	102.2624	0.0210	0.0000	0.0000;
	1329	1	0.002	2.146	0	0	1	1.0919702	-9.9886886	110	3	1.12	0.95	102.2559	0.0200	0.0000	0.0000;
	1330	2	0	-0.01	0	0	1	1.0549441	-10.127851	110	3	1.12	0.95	106.1350	1.2513	0.0000	0.0000;
	1331	1	8.348	-0.619	0	0	1	1.0549701	-10.117203	110	3	1.12	0.95	106.1332	1.2505	0.0000	0.0000;
	1332	1	5.597	1.405	0	0	1	1.0787417	-7.0590711	110	3	1.12	0.95	103.5098	0.5402	0.0000	0.0000;
	1333	1	2.258	0.46	0	0	1	1.0787826	-7.0477811	110	3	1.12	0.95	103.5077	0.5414	0.0000	0.0000;
	1334	1	5.359	1.197	0	0	1	1.0903279	-7.3596258	110	3	1.12	0.95	100.3912	0.3656	0.0000	0.0000;
	1335	1	4.756	0.833	0	0	1	1.0903387	-7.3613246	110	3	1.12	0.95	100.3908	0.3643	0.0000	0.0000;
	1336	1	19.971	-0.66	0	0	1	1.0573895	-13.702617	110	3	1.12	0.95	107.3787	0.7415	0.0000	0.0000;
	1337	1	0	0	0	0	1	1.057396	-13.706574	110	3	1.12	0.95	107.3686	0.7410	0.0000	0.0000;
	1338	1	15.242	5.768	0	0	1	1.1002192	-4.8895781	110	3	1.12	0.95	99.6193	0.2576	0.0000	0.0000;
	1339	1	6.292	1.679	0	0	1	1.0943949	-5.8172298	110	3	1.12	0.95	100.2014	0.3995	0.0000	0.0000;
	1340	1	0	0	0	0	1	1.10703	-4.5031404	110	3	1.12	0.95	98.9290	0.1146	0.0000	0.0000;
	1341	2	23.021	7.73	0	0	1	1.0877026	-6.006528	110	3	1.12	0.95	102.1150	0.6864	0.0000	0.0000;
	1342	2	23.022	7.731	0	0	1	1.0876862	-6.0044069	110	3	1.12	0.95	102.1152	0.6865	0.0000	0.0000;
	1343	1	10.362	1.987	0	0	1	1.0818547	-8.4520209	110	3	1.12	0.95	101.8004	0.4164	0.0000	0.0000;
	1344	1	9.645	0.133	0	0	1	1.0870482	-6.1407472	110	3	1.12	0.95	102.3663	0.6490	0.0000	0.0000;
	1345	1	0	0	0	0	1	1.0819283	-8.4475518	110	3	1.12	0.95	101.7899	0.4144	0.0000	0.0000;
	1346	1	1.187	0.224	0	0	1	1.0873777	-7.7242999	110	3	1.12	0.95	100.5796	-0.2648	0.0000	0.0000;
	1347	1	11.895	2.729	0	0	1	1.0727189	-8.8852193	110	3	1.12	0.95	102.5065	0.7472	0.0000	0.0000;
	1348	1	5.232	0.572	0	0	1	1.0640296	-13.909167	110	3	1.12	0.95	105.5596	0.5648	0.0000	0.0000;
	1349	1	0	0	0	0	1	1.063965	-13.92677	110	3	1.12	0.95	105.5661	0.5674	0.0000	0.0000;
	1350	2	16.315	18.569	0	0	1	1.082487	-6.0942349	110	3	1.12	0.95	99.0892	-0.0114	0.0000	0.0000;
	1351	2	9.612	16.269	0	0	1	1.0924696	-4.308281	110	3	1.12	0.95	98.5540	0.0000	0.0000	0.0000;
	1352	2	0	0	0	0	1	1.1100026	-3.9309237	110	3	1.12	0.95	98.5825	0.0350	0.0000	0.0000;
	1353	1	6.173	1.97	0	0	1	1.0682182	-12.853237	110	3	1.12	0.95	105.9754	0.5444	0.0000	0.0000;
	1354	1	6.413	2.043	0	0	1	1.0681775	-12.850501	110	3	1.12	0.95	105.9811	0.5449	0.0000	0.0000;
	1355	1	7.251	1.705	0	0	1	1.116889	-6.0143455	110	3	1.12	0.95	98.4043	0.0452	0.0000	0.0000;
	1356	1	15.946	4.036	0	0	1	1.1056324	-4.3874159	110	3	1.12	0.95	99.2007	0.1230	0.0000	0.0000;
	1357	1	0	0	0	0	1	1.1171885	-5.9967283	110	3	1.12	0.95	98.3674	0.0367	0.0000	0.0000;
	1358	1	0	0	0	0	1	1.106298	-4.3494736	110	3	1.12	0.95	99.1192	0.1025	0.0000	0.0000;
	1359	1	30.927	8.362	0	0	1	1.0519798	-14.893848	110	3	1.12	0.95	107.6416	0.8753	0.0000	0.0000;
	1360	1	0	0	0	0	1	1.0520319	-14.90075	110	3	1.12	0.95	107.6342	0.8742	0.0000	0.0000;
	1361	1	0	0	0	0	1	1.1075472	-4.1717964	110	3	1.12	0.95	99.0426	0.0772	0.0000	0.0000;
	1362	2	30.247	48.529	0	0	1	1.117122	-5.1950649	110	3	1.12	0.95	98.4207	0.0000	0.0000	0.0000;
	1363	1	21.766	1.437	0	0	1	1.0647222	-9.0278402	110	3	1.12	0.95	103.3643	-0.1128	0.0000	0.0000;
	1364	1	0	0	0	0	1	1.0647487	-9.0169356	110	3	1.12	0.95	103.3652	-0.1108	0.0000	0.0000;
	1365	1	2.974	1.129	0	0	1	1.0921094	-4.5108379	110	3	1.12	0.95	98.7293	-0.0923	0.0000	0.0000;
	1366	1	0	0	0	0	1	1.0921715	-4.5313763	110	3	1.12	0.95	98.7333	-0.0996	0.0000	0.0000;
	1367	1	15.272	5.055	0	0	1	1.1006713	-4.9545243	110	3	1.12	0.95	99.6022	0.2373	0.0000	0.0000;
	1368	1	13.772	2.892	0	0	1	1.1006749	-4.9448622	110	3	1.12	0.95	99.6043	0.2371	0.0000	0.0000;
	1369	1	0	0	0	0	1	1.1033157	-7.1967873	110	3	1.12	0.95	99.8560	0.2876	0.0000	0.0000;
	1370	1	10.932	3.124	0	0	1	1.0996758	-7.5035819	110	3	1.12	0.95	100.2651	0.3998	0.0000	0.0000;
	1371	1	0	0	0	0	1	1.1033112	-7.1966468	110	3	1.12	0.95	99.8560	0.2881	0.0000	0.0000;
	1372	1	0	0	0	0	1	1.1004509	-7.4650667	110	3	1.12	0.95	100.1687	0.3727	0.0000	0.0000;
	1373	2	22.255	23.864	0	0	1	1.0943159	-8.8656605	110	3	1.12	0.95	101.3958	0.0000	0.0000	0.0000;
	1374	2	9.922	15.593	0	0	1	1.0943994	-8.867489	110	3	1.12	0.95	101.3914	0.0000	0.0000	0.0000;
	1375	2	8.2	13	0	0	1	1.0928063	-9.7882676	110	3	1.12	0.95	102.1324	0.0000	0.0000	0.0000;
	1376	1	7.736	1.759	0	0	1	1.1039013	-5.9765583	110	3	1.12	0.95	99.2753	0.3878	0.0000	0.0000;
	1377	1	4.756	1.211	0	0	1	1.1038649	-5.9803051	110	3	1.12	0.95	99.2772	0.3888	0.0000	0.0000;
	1378	1	0	0.075	0	0	1	1.0971882	-5.5309049	110	3	1.12	0.95	99.8556	0.3230	0.0000	0.0000;
	1379	1	0	0.075	0	0	1	1.0971105	-5.5441699	110	3	1.12	0.95	99.8623	0.3251	0.0000	0.0000;
	1380	1	11.528	3.031	0	0	1	1.1075176	-4.2787965	110	3	1.12	0.95	98.9379	0.0687	0.0000	0.0000;
	1381	1	0	0	0	0	1	1.107449	-4.2884785	110	3	1.12	0.95	98.9415	0.0695	0.0000	0.0000;
	1382	1	4.193	1.249	0	0	1	1.100218	-7.4638061	110	3	1.12	0.95	100.2271	0.3381	0.0000	0.0000;
	1383	1	0	0	0	0	1	1.1002295	-7.4638855	110	3	1.12	0.95	100.2264	0.3380	0.0000	0.0000;
	1384	1	16.962	-1.727	0	0	1	1.0889087	-10.298929	110	3	1.12	0.95	102.7368	0.0227	0.0000	0.0000;
	1385	1	24.803	-3.13	0	0	1	1.0898101	-9.4874739	110	3	1.12	0.95	102.1452	0.0001	0.0000	0.0000;
	1386	1	0	0	0	0	1	1.0856019	-7.5451338	110	3	1.12	0.95	100.6170	-0.5856	0.0000	0.0000;
	1387	1	0	0	0	0	1	1.0856578	-7.5289567	110	3	1.12	0.95	100.6134	-0.5865	0.0000	0.0000;
	1388	1	11.428	4.169	0	0	1	1.0902378	-6.3926371	110	3	1.12	0.95	100.1130	-0.6941	0.0000	0.0000;
	1389	1	0	0	0	0	1	1.0902331	-6.399045	110	3	1.12	0.95	100.1060	-0.6841	0.0000	0.0000;
	1390	1	13.744	-1.331	0	0	1	1.0625973	-13.973303	110	3	1.12	0.95	107.1598	0.3691	0.0000	0.0000;
	1391	1	9.962	-0.423	0	0	1	1.0626015	-13.988502	110	3	1.12	0.95	107.1563	0.3681	0.0000	0.0000;
	1392	1	2.127	0.668	0	0	1	1.0901392	-9.1414579	110	3	1.12	0.95	101.8729	0.0598	0.0000	0.0000;
	1393	1	7.716	2.132	0	0	1	1.0916809	-9.0570373	110	3	1.12	0.95	101.3868	0.0812	0.0000	0.0000;
	1394	1	7.275	2.726	0	0	1	1.0866076	-7.2876063	110	3	1.12	0.95	100.3874	-0.9119	0.0000	0.0000;
	1395	1	0	0	0	0	1	1.0869066	-7.2692286	110	3	1.12	0.95	100.3605	-0.9218	0.0000	0.0000;
	1396	1	30.821	9.658	0	0	1	1.090942	-4.4272376	110	3	1.12	0.95	98.7822	0.0725	0.0000	0.0000;
	1397	1	0	0	0	0	1	1.0909554	-4.424202	110	3	1.12	0.95	98.7792	0.0718	0.0000	0.0000;
	1398	1	0	0	0	0	1	1.0904791	-7.3245771	110	3	1.12	0.95	100.1114	0.1671	0.0000	0.0000;
	1399	1	0	0	0	0	1	1.0904743	-7.3244247	110	3	1.12	0.95	100.1114	0.1676	0.0000	0.0000;
	1400	1	5.935	0.559	0	0	1	1.0965468	-5.2066081	110	3	1.12	0.95	101.1657	0.3877	0.0000	0.0000;
	1401	1	2.137	0.839	0	0	1	1.1002758	-4.831352	110	3	1.12	0.95	100.7314	0.3335	0.0000	0.0000;
	1402	1	0	0	0	0	1	1.0965999	-5.202154	110	3	1.12	0.95	101.1574	0.3869	0.0000	0.0000;
	1403	1	16.741	10.166	0	0	1	1.0934924	-4.2186459	110	3	1.12	0.95	98.4694	0.0514	0.0000	0.0000;
	1404	1	0	0	0	0	1	1.0935256	-4.2109914	110	3	1.12	0.95	98.4675	0.0507	0.0000	0.0000;
	1405	1	6.662	1.594	0	0	1	1.0684156	-8.6727186	110	3	1.12	0.95	101.6374	-0.2237	0.0000	0.0000;
	1406	1	2.732	0.742	0	0	1	1.066565	-8.8597976	110	3	1.12	0.95	101.8452	-0.1813	0.0000	0.0000;
	1407	1	0	0	0	0	1	1.0686158	-8.6618331	110	3	1.12	0.95	101.6100	-0.2301	0.0000	0.0000;
	1408	1	0	0	0	0	1	1.0666499	-8.8554048	110	3	1.12	0.95	101.8339	-0.1843	0.0000	0.0000;
	1409	1	7.621	1.361	0	0	1	1.0962698	-7.7972243	110	3	1.12	0.95	100.7874	0.5025	0.0000	0.0000;
	1410	1	0	0	0	0	1	1.0962415	-7.8062526	110	3	1.12	0.95	100.7890	0.5020	0.0000	0.0000;
	1411	1	21.505	5.959	0	0	1	1.0935668	-7.9652643	110	3	1.12	0.95	101.0326	0.4839	0.0000	0.0000;
	1412	1	0	0	0	0	1	1.0937905	-7.9367764	110	3	1.12	0.95	101.0205	0.4800	0.0000	0.0000;
	1413	1	0	0	0	0	1	1.0767654	-8.1266472	110	3	1.12	0.95	101.0477	-0.2101	0.0000	0.0000;
	1414	1	0	0	0	0	1	1.0738698	-8.289649	110	3	1.12	0.95	101.1845	-0.2141	0.0000	0.0000;
	1415	2	0	0	0	0	1	1.0714162	-8.2055172	110	3	1.12	0.95	101.1459	-0.1691	0.0000	0.0000;
	1416	2	4	4	0	0	1	1.0716588	-7.8883421	110	3	1.12	0.95	100.8451	-0.0406	0.0000	0.0000;
	1417	1	29.12	4.477	0	0	1	1.0775998	-8.3554817	110	3	1.12	0.95	101.7067	-0.3726	0.0000	0.0000;
	1418	1	0	0	0	0	1	1.0776358	-8.3493701	110	3	1.12	0.95	101.7049	-0.3734	0.0000	0.0000;
	1419	1	3.326	2.938	0	0	1	1.0721146	-8.1996109	110	3	1.12	0.95	101.1135	-0.2378	0.0000	0.0000;
	1420	1	7.603	1.166	0	0	1	1.0721096	-8.1965777	110	3	1.12	0.95	101.1132	-0.2365	0.0000	0.0000;
	1421	1	5.939	1.187	0	0	1	1.1113797	-3.8474223	110	3	1.12	0.95	98.4508	0.0106	0.0000	0.0000;
	1422	1	0	0	0	0	1	1.1114231	-3.8424137	110	3	1.12	0.95	98.4478	0.0104	0.0000	0.0000;
	1423	1	1.663	0.36	0	0	1	1.0892288	-4.6806548	110	3	1.12	0.95	99.1581	0.0797	0.0000	0.0000;
	1424	1	0	0	0	0	1	1.0892687	-4.6685896	110	3	1.12	0.95	99.1540	0.0797	0.0000	0.0000;
	1425	1	4.868	2.129	0	0	1	1.088045	-7.431173	110	3	1.12	0.95	100.2185	0.0227	0.0000	0.0000;
	1426	1	0	0	0	0	1	1.0881135	-7.4292674	110	3	1.12	0.95	100.2103	0.0192	0.0000	0.0000;
	1427	1	19.013	4.043	0	0	1	1.0952196	-8.3873161	110	3	1.12	0.95	101.4187	0.2867	0.0000	0.0000;
	1428	1	0	0	0	0	1	1.095361	-8.3751109	110	3	1.12	0.95	101.4140	0.2843	0.0000	0.0000;
	1429	2	9.894	0.259	0	0	1	1.0619313	-9.9398845	110	3	1.12	0.95	103.9656	1.6712	0.0000	0.0000;
	1430	1	0	0	0	0	1	1.0616995	-9.9638953	110	3	1.12	0.95	103.9783	1.6765	0.0000	0.0000;
	1431	1	0.949	0.265	0	0	1	1.0951945	-4.041966	110	3	1.12	0.95	98.2938	0.0014	0.0000	0.0000;
	1432	1	0	0	0	0	1	1.0951947	-4.0419286	110	3	1.12	0.95	98.2938	0.0014	0.0000	0.0000;
	1433	2	2.363	0.455	0	0	1	1.0870415	-8.094659	110	3	1.12	0.95	101.3528	0.7636	0.0000	0.0000;
	1434	2	20.173	8.85	0	0	1	1.0884765	-7.4419902	110	3	1.12	0.95	101.0815	0.8378	0.0000	0.0000;
	1435	2	35.606	13.979	0	0	1	1.0933463	-7.2057844	110	3	1.12	0.95	100.5096	0.6077	0.0000	0.0000;
	1436	2	7.113	-0.01	0	0	1	1.0953204	-7.0523818	110	3	1.12	0.95	100.3259	0.5432	0.0000	0.0000;
	1437	1	0	0	0	0	1	1.0936678	-7.183827	110	3	1.12	0.95	100.4790	0.5975	0.0000	0.0000;
	1438	1	17.199	5.425	0	0	1	1.0763752	-11.570142	110	3	1.12	0.95	104.5247	0.4550	0.0000	0.0000;
	1439	1	18.96	6.181	0	0	1	1.0763175	-11.598487	110	3	1.12	0.95	104.5264	0.4553	0.0000	0.0000;
	1440	2	37.237	41.301	0	0	1	1.095548	-3.9597545	110	3	1.12	0.95	98.2333	-0.0000	0.0000	0.0000;
	1441	1	9.158	2.601	0	0	1	1.0953844	-3.9926248	110	3	1.12	0.95	98.2472	0.0017	0.0000	0.0000;
	1442	1	0	0	0	0	1	1.109038	-6.5538578	110	3	1.12	0.95	99.2897	0.1055	0.0000	0.0000;
	1443	1	0	0	0	0	1	1.1090359	-6.5538153	110	3	1.12	0.95	99.2897	0.1056	0.0000	0.0000;
	1444	2	9.755	2.196	0	0	1	1.1096696	-6.6687936	110	3	1.12	0.95	99.1763	0.1812	0.0000	0.0000;
	1445	1	5.828	1.452	0	0	1	1.1085239	-6.7977958	110	3	1.12	0.95	99.2929	0.2276	0.0000	0.0000;
	1446	1	0	0	0	0	1	1.1098405	-6.6353062	110	3	1.12	0.95	99.1646	0.1793	0.0000	0.0000;
	1447	1	0	0	0	0	1	1.1087138	-6.7686056	110	3	1.12	0.95	99.2825	0.2252	0.0000	0.0000;
	1448	1	3.831	0.59	0	0	1	1.0526289	-16.64354	110	3	1.12	0.95	108.5703	0.3484	0.0000	0.0000;
	1449	1	3.566	0.473	0	0	1	1.0526196	-16.645962	110	3	1.12	0.95	108.5741	0.3485	0.0000	0.0000;
	1450	1	0.238	0.243	0	0	1	1.0803655	-8.2050861	110	3	1.12	0.95	101.3137	-0.4688	0.0000	0.0000;
	1451	1	0	0	0	0	1	1.0803319	-8.2111924	110	3	1.12	0.95	101.3154	-0.4680	0.0000	0.0000;
	1452	1	12.596	2.751	0	0	1	1.0668924	-8.8344295	110	3	1.12	0.95	101.8121	-0.1909	0.0000	0.0000;
	1453	1	0	0.14	0	0	1	1.0668711	-8.8386898	110	3	1.12	0.95	101.8136	-0.1906	0.0000	0.0000;
	1454	1	12.85	2.142	0	0	1	1.0854333	-5.6565503	110	3	1.12	0.95	102.7451	0.6651	0.0000	0.0000;
	1455	1	5.946	0.791	0	0	1	1.0854305	-5.6696686	110	3	1.12	0.95	102.7387	0.6634	0.0000	0.0000;
	1456	1	8.691	1.526	0	0	1	1.0543971	-16.119163	110	3	1.12	0.95	108.2243	0.3682	0.0000	0.0000;
	1457	1	9.357	-1.258	0	0	1	1.0544159	-16.111875	110	3	1.12	0.95	108.2222	0.3681	0.0000	0.0000;
	1458	1	19.716	6.79	0	0	1	1.093701	-4.3114176	110	3	1.12	0.95	98.5574	0.0205	0.0000	0.0000;
	1459	1	0	0	0	0	1	1.0936625	-4.3149055	110	3	1.12	0.95	98.5610	0.0207	0.0000	0.0000;
	1460	1	7.626	-4.167	0	0	1	1.0806737	-12.549391	110	3	1.12	0.95	103.2387	0.0628	0.0000	0.0000;
	1461	1	0	0	0	0	1	1.0806361	-12.545807	110	3	1.12	0.95	103.2392	0.0629	0.0000	0.0000;
	1462	2	4.015	4.483	0	0	1	1.077608	-13.020936	110	3	1.12	0.95	105.4259	-0.0000	0.0000	0.0000;
	1463	1	1.819	-0.369	0	0	1	1.0775726	-13.037633	110	3	1.12	0.95	105.4290	-0.0003	0.0000	0.0000;
	1464	1	8.678	1.453	0	0	1	1.0672744	-12.739543	110	3	1.12	0.95	105.9655	0.4869	0.0000	0.0000;
	1465	1	10.598	-1.573	0	0	1	1.0672911	-12.723621	110	3	1.12	0.95	105.9708	0.4873	0.0000	0.0000;
	1466	1	0.831	0.358	0	0	1	1.0944486	-4.0980492	110	3	1.12	0.95	98.3883	0.0164	0.0000	0.0000;
	1467	1	0	0	0	0	1	1.0944566	-4.0976066	110	3	1.12	0.95	98.3877	0.0161	0.0000	0.0000;
	1468	1	3.09	0.68	0	0	1	1.0991491	-4.8587475	110	3	1.12	0.95	99.6352	0.3225	0.0000	0.0000;
	1469	1	1.782	0.276	0	0	1	1.1037422	-4.5933226	110	3	1.12	0.95	99.3008	0.1578	0.0000	0.0000;
	1470	1	0	0	0	0	1	1.0991591	-4.8581005	110	3	1.12	0.95	99.6339	0.3223	0.0000	0.0000;
	1471	1	0	0	0	0	1	1.1037475	-4.5929388	110	3	1.12	0.95	99.3001	0.1577	0.0000	0.0000;
	1472	1	13.134	4.838	0	0	1	1.0973544	-6.8637333	110	3	1.12	0.95	100.1131	0.4540	0.0000	0.0000;
	1473	1	11.93	4.074	0	0	1	1.0972691	-6.8740507	110	3	1.12	0.95	100.1171	0.4564	0.0000	0.0000;
	1474	1	18.061	6.006	0	0	1	1.0732784	-13.228748	110	3	1.12	0.95	104.1337	0.2122	0.0000	0.0000;
	1475	1	0	0	0	0	1	1.0733333	-13.232151	110	3	1.12	0.95	104.1357	0.2105	0.0000	0.0000;
	1476	1	3.564	1.332	0	0	1	1.0988986	-5.1657244	110	3	1.12	0.95	99.7659	0.2834	0.0000	0.0000;
	1477	1	9.629	2.544	0	0	1	1.0989662	-5.147353	110	3	1.12	0.95	99.7662	0.2823	0.0000	0.0000;
	1478	1	0	0	0	0	1	1.1035972	-5.9938731	110	3	1.12	0.95	99.3014	0.4011	0.0000	0.0000;
	1479	1	0	0	0	0	1	1.1035728	-5.995816	110	3	1.12	0.95	99.3026	0.4019	0.0000	0.0000;
	1480	1	0.356	0.09	0	0	1	1.0855881	-7.5486664	110	3	1.12	0.95	100.6208	-0.5861	0.0000	0.0000;
	1481	1	2.732	0.979	0	0	1	1.0853478	-7.5524057	110	3	1.12	0.95	100.6418	-0.5777	0.0000	0.0000;
	1482	1	8.323	2.608	0	0	1	1.1013526	-6.7461986	110	3	1.12	0.95	100.0713	0.4053	0.0000	0.0000;
	1483	1	3.444	2.565	0	0	1	1.101302	-6.7617695	110	3	1.12	0.95	100.0708	0.4055	0.0000	0.0000;
	1484	1	9.04	0.443	0	0	1	1.0788095	-7.0841123	110	3	1.12	0.95	103.6474	0.5403	0.0000	0.0000;
	1485	1	0	0	0	0	1	1.0788274	-7.077576	110	3	1.12	0.95	103.6469	0.5412	0.0000	0.0000;
	1486	1	6.536	1.582	0	0	1	1.0860295	-7.6563215	110	3	1.12	0.95	100.8094	0.2649	0.0000	0.0000;
	1487	1	4.644	2.109	0	0	1	1.0865083	-6.7983162	110	3	1.12	0.95	100.5050	0.0132	0.0000	0.0000;
	1488	1	10.601	2.568	0	0	1	1.0715224	-14.070082	110	3	1.12	0.95	105.1515	0.0582	0.0000	0.0000;
	1489	1	0	0	0	0	1	1.0715395	-14.060841	110	3	1.12	0.95	105.1470	0.0576	0.0000	0.0000;
	1490	1	5.959	2.209	0	0	1	1.115583	-5.3245108	110	3	1.12	0.95	98.5687	0.0380	0.0000	0.0000;
	1491	1	4.756	1.116	0	0	1	1.1056876	-4.3233846	110	3	1.12	0.95	99.2258	0.1260	0.0000	0.0000;
	1492	1	0	0	0	0	1	1.1156038	-5.3223275	110	3	1.12	0.95	98.5679	0.0377	0.0000	0.0000;
	1493	1	4.399	0.355	0	0	1	1.0749526	-8.2287954	110	3	1.12	0.95	105.8976	0.2636	0.0000	0.0000;
	1494	2	4.508	0.383	0	0	1	1.0749489	-8.2259715	110	3	1.12	0.95	105.8965	0.2637	0.0000	0.0000;
	1495	1	16.512	4.407	0	0	1	1.0945146	-4.0763	110	3	1.12	0.95	98.3698	0.0156	0.0000	0.0000;
	1496	1	0	0	0	0	1	1.0945829	-4.0619989	110	3	1.12	0.95	98.3634	0.0149	0.0000	0.0000;
	1497	1	13.795	2.862	0	0	1	1.0778304	-8.9280538	110	3	1.12	0.95	102.5181	1.0409	0.0000	0.0000;
	1498	1	0	0	0	0	1	1.0778755	-8.9203258	110	3	1.12	0.95	102.5155	1.0399	0.0000	0.0000;
	1499	1	3.09	1.958	0	0	1	1.0810723	-12.569592	110	3	1.12	0.95	103.1810	0.0829	0.0000	0.0000;
	1500	1	0	0	0	0	1	1.0810982	-12.568727	110	3	1.12	0.95	103.1789	0.0831	0.0000	0.0000;
	1501	1	6.18	0.04	0	0	1	1.0965999	-5.202154	110	3	1.12	0.95	101.1574	0.3869	0.0000	0.0000;
	1502	1	4.398	0.959	0	0	1	1.1003045	-4.8300085	110	3	1.12	0.95	100.7285	0.3324	0.0000	0.0000;
	1503	1	9.306	1.077	0	0	1	1.0842589	-8.151724	110	3	1.12	0.95	101.5878	0.9351	0.0000	0.0000;
	1504	1	0	0	0	0	1	1.0842921	-8.1346809	110	3	1.12	0.95	101.5878	0.9349	0.0000	0.0000;
	1505	1	4.156	1.987	0	0	1	1.0854091	-7.6737686	110	3	1.12	0.95	100.8831	0.2976	0.0000	0.0000;
	1506	1	13.311	3.852	0	0	1	1.0871954	-6.7512989	110	3	1.12	0.95	100.4543	0.0161	0.0000	0.0000;
	1507	1	0	0	0	0	1	1.0881742	-6.6749483	110	3	1.12	0.95	100.3571	-0.0114	0.0000	0.0000;
	1508	1	3.918	0.933	0	0	1	1.0990844	-6.7207343	110	3	1.12	0.95	100.0911	0.4219	0.0000	0.0000;
	1509	1	8.667	1.865	0	0	1	1.0990014	-6.7316363	110	3	1.12	0.95	100.0982	0.4228	0.0000	0.0000;
	1510	1	8.211	0.996	0	0	1	1.0901803	-7.6311334	110	3	1.12	0.95	101.7096	-0.7648	0.0000	0.0000;
	1511	1	0	0	0	0	1	1.0902621	-7.6264408	110	3	1.12	0.95	101.6987	-0.7698	0.0000	0.0000;
	1512	1	1.901	0.559	0	0	1	1.107776	-4.1613489	110	3	1.12	0.95	99.0292	0.0684	0.0000	0.0000;
	1513	1	2.615	0.762	0	0	1	1.1068021	-6.973914	110	3	1.12	0.95	99.5077	0.2555	0.0000	0.0000;
	1514	1	11.897	0.971	0	0	1	1.101653	-6.2692153	110	3	1.12	0.95	99.4930	0.4378	0.0000	0.0000;
	1515	1	0	0	0	0	1	1.1034252	-6.0517124	110	3	1.12	0.95	99.3231	0.3886	0.0000	0.0000;
	1516	1	0	0	0	0	1	1.1016602	-6.2645735	110	3	1.12	0.95	99.4929	0.4378	0.0000	0.0000;
	1517	1	0	0	0	0	1	1.1034252	-6.0517124	110	3	1.12	0.95	99.3231	0.3886	0.0000	0.0000;
	1518	2	9.156	-0.846	0	0	1	1.0997533	-4.9991034	110	3	1.12	0.95	101.3055	0.2526	0.0000	0.0000;
	1519	2	7.598	0.272	0	0	1	1.0997826	-4.9865935	110	3	1.12	0.95	101.3033	0.2525	0.0000	0.0000;
	1520	2	0	-0.01	0	0	1	1.0735905	-8.5426144	110	3	1.12	0.95	106.1379	0.2872	0.0000	0.0000;
	1521	2	14.624	0.477	0	0	1	1.0735889	-8.5434401	110	3	1.12	0.95	106.1382	0.2872	0.0000	0.0000;
	1522	1	8.322	2.79	0	0	1	1.0940233	-4.0621438	110	3	1.12	0.95	98.3368	0.0322	0.0000	0.0000;
	1523	1	0	0	0	0	1	1.0940065	-4.0635565	110	3	1.12	0.95	98.3367	0.0317	0.0000	0.0000;
	1524	1	0	0	0	0	1	1.0718457	-8.9744159	110	3	1.12	0.95	102.5964	1.3076	0.0000	0.0000;
	1525	1	0	0	0	0	1	1.0718755	-8.9744051	110	3	1.12	0.95	102.5956	1.3072	0.0000	0.0000;
	1526	1	0	0	0	0	1	1.106207	-4.4935742	110	3	1.12	0.95	99.1227	0.0781	0.0000	0.0000;
	1527	1	15.214	3.964	0	0	1	1.1062643	-4.4870732	110	3	1.12	0.95	99.1206	0.0775	0.0000	0.0000;
	1528	1	5.73	1.518	0	0	1	1.0520959	-16.589179	110	3	1.12	0.95	108.6678	0.3692	0.0000	0.0000;
	1529	1	1.093	0.223	0	0	1	1.0521031	-16.590401	110	3	1.12	0.95	108.6676	0.3690	0.0000	0.0000;
	1530	1	4.762	1.441	0	0	1	1.0913595	-4.3806819	110	3	1.12	0.95	98.6927	0.0531	0.0000	0.0000;
	1531	1	0	0	0	0	1	1.0914983	-4.37336	110	3	1.12	0.95	98.6764	0.0484	0.0000	0.0000;
	1532	1	0.95	0	0	0	1	1.0923796	-5.7657393	110	3	1.12	0.95	101.6392	0.5129	0.0000	0.0000;
	1533	1	0	0	0	0	1	1.095188	-5.4447241	110	3	1.12	0.95	101.1105	0.4865	0.0000	0.0000;
	1534	1	0	0	0	0	1	1.0924066	-5.7631963	110	3	1.12	0.95	101.6338	0.5131	0.0000	0.0000;
	1535	1	0	0	0	0	1	1.0951862	-5.4446691	110	3	1.12	0.95	101.1105	0.4867	0.0000	0.0000;
	1536	1	11.201	-0.898	0	0	1	1.0850879	-10.880352	110	3	1.12	0.95	103.3561	0.1427	0.0000	0.0000;
	1537	1	6.003	1.013	0	0	1	1.0850657	-10.883824	110	3	1.12	0.95	103.3550	0.1430	0.0000	0.0000;
	1538	1	0	0	0	0	1	1.0715272	-8.8682039	110	3	1.12	0.95	103.0867	1.0112	0.0000	0.0000;
	1539	1	5.818	1.212	0	0	1	1.0662662	-9.2927051	110	3	1.12	0.95	103.9643	1.1044	0.0000	0.0000;
	1540	1	0	0	0	0	1	1.0715272	-8.8682037	110	3	1.12	0.95	103.0867	1.0112	0.0000	0.0000;
	1541	1	5.535	1.595	0	0	1	1.0562632	-15.653928	110	3	1.12	0.95	107.7728	0.3997	0.0000	0.0000;
	1542	1	9.663	1.969	0	0	1	1.0911378	-10.001349	110	3	1.12	0.95	102.3625	0.0380	0.0000	0.0000;
	1543	2	10.915	1.982	0	0	1	1.0910647	-10.025426	110	3	1.12	0.95	102.3683	0.0401	0.0000	0.0000;
	1544	1	1.187	0.466	0	0	1	1.0868035	-8.0394745	110	3	1.12	0.95	101.3355	0.7789	0.0000	0.0000;
	1545	1	0	0	0	0	1	1.0868223	-8.0412131	110	3	1.12	0.95	101.3344	0.7790	0.0000	0.0000;
	1546	2	17.798	10.249	0	0	1	1.08553	-7.9406587	110	3	1.12	0.95	101.4287	0.9147	0.0000	0.0000;
	1547	2	5.925	3.72	0	0	1	1.0832048	-7.9740062	110	3	1.12	0.95	101.4098	0.9465	0.0000	0.0000;
	1548	1	20.259	6.045	0	0	1	1.0884302	-7.625291	110	3	1.12	0.95	101.2437	0.7779	0.0000	0.0000;
	1549	1	0	0	0	0	1	1.0885303	-7.625376	110	3	1.12	0.95	101.2406	0.7762	0.0000	0.0000;
	1550	1	2.138	0.737	0	0	1	1.0888432	-4.7191978	110	3	1.12	0.95	99.1873	0.0822	0.0000	0.0000;
	1551	1	0	0	0	0	1	1.088853	-4.7129001	110	3	1.12	0.95	99.1821	0.0810	0.0000	0.0000;
	1552	1	7.021	2.093	0	0	1	1.0696225	-7.8746601	110	3	1.12	0.95	100.9375	0.0816	0.0000	0.0000;
	1553	1	0	0.093	0	0	1	1.0740065	-7.3839591	110	3	1.12	0.95	100.3853	0.0128	0.0000	0.0000;
	1554	1	0	0	0	0	1	1.0699076	-7.852634	110	3	1.12	0.95	100.9088	0.0732	0.0000	0.0000;
	1555	1	0	0	0	0	1	1.0740099	-7.3840183	110	3	1.12	0.95	100.3853	0.0125	0.0000	0.0000;
	1556	1	8.927	-0.492	0	0	1	1.0808461	-8.1622044	110	3	1.12	0.95	101.2582	-0.4841	0.0000	0.0000;
	1557	1	0	0	0	0	1	1.0808843	-8.1523747	110	3	1.12	0.95	101.2552	-0.4849	0.0000	0.0000;
	1558	1	1.664	0.535	0	0	1	1.1027639	-4.100687	110	3	1.12	0.95	100.4786	0.3257	0.0000	0.0000;
	1559	1	3.092	-0.619	0	0	1	1.1027348	-4.1198193	110	3	1.12	0.95	100.4745	0.3247	0.0000	0.0000;
	1560	1	10.743	-0.634	0	0	1	1.0924442	-9.218792	110	3	1.12	0.95	101.7292	0.0298	0.0000	0.0000;
	1561	1	7.247	1.837	0	0	1	1.0924115	-9.2375627	110	3	1.12	0.95	101.7326	0.0314	0.0000	0.0000;
	1562	1	0	0	0	0	1	1.0779223	-6.7462738	110	3	1.12	0.95	99.7718	0.0134	0.0000	0.0000;
	1563	1	0	0	0	0	1	1.0779006	-6.7458965	110	3	1.12	0.95	99.7718	0.0147	0.0000	0.0000;
	1564	1	2.019	0.577	0	0	1	1.0738853	-13.287485	110	3	1.12	0.95	104.1951	0.1506	0.0000	0.0000;
	1565	1	0	0	0	0	1	1.0739451	-13.290071	110	3	1.12	0.95	104.1967	0.1489	0.0000	0.0000;
	1566	1	22.95	3.948	0	0	1	1.0651338	-9.0135003	110	3	1.12	0.95	102.0322	-0.1532	0.0000	0.0000;
	1567	1	0	0	0	0	1	1.0665956	-8.8687946	110	3	1.12	0.95	101.8487	-0.1852	0.0000	0.0000;
	1568	1	0	0	0	0	1	1.0654778	-8.9861134	110	3	1.12	0.95	101.9846	-0.1613	0.0000	0.0000;
	1569	1	0	0	0	0	1	1.066595	-8.8687824	110	3	1.12	0.95	101.8487	-0.1851	0.0000	0.0000;
	1570	1	11.653	1.463	0	0	1	1.0802385	-7.7135726	110	3	1.12	0.95	103.2343	-0.0378	0.0000	0.0000;
	1571	1	0	0	0	0	1	1.0801808	-7.7103317	110	3	1.12	0.95	103.2427	-0.0330	0.0000	0.0000;
	1572	1	0	0	0	0	1	1.0953071	-7.9617843	110	3	1.12	0.95	100.7313	0.4739	0.0000	0.0000;
	1573	1	0	0	0	0	1	1.0951722	-7.9839526	110	3	1.12	0.95	100.7384	0.4763	0.0000	0.0000;
	1574	1	13.547	-1.401	0	0	1	1.0890747	-10.250073	110	3	1.12	0.95	102.6882	0.0276	0.0000	0.0000;
	1575	1	20.339	0.474	0	0	1	1.0900207	-9.415672	110	3	1.12	0.95	102.0746	0.0089	0.0000	0.0000;
	1576	1	13.112	2.073	0	0	1	1.0829529	-7.9164878	110	3	1.12	0.95	100.8047	-0.3904	0.0000	0.0000;
	1577	1	0	0	0	0	1	1.0829943	-7.905701	110	3	1.12	0.95	100.8006	-0.3904	0.0000	0.0000;
	1578	1	6.837	0.77	0	0	1	1.0868561	-10.208006	110	3	1.12	0.95	102.3244	0.1005	0.0000	0.0000;
	1579	1	7.496	0.661	0	0	1	1.0868457	-10.194185	110	3	1.12	0.95	102.3250	0.1003	0.0000	0.0000;
	1580	2	8.182	2.415	0	0	1	1.0362245	-11.806594	110	3	1.12	0.95	109.8413	1.4047	0.0000	0.0000;
	1581	1	8.429	0.466	0	0	1	1.0362561	-11.8094	110	3	1.12	0.95	109.8396	1.4038	0.0000	0.0000;
	1582	1	0	0	0	0	1	1.0902116	-7.306243	110	3	1.12	0.95	100.1486	0.2589	0.0000	0.0000;
	1583	1	5.342	0.933	0	0	1	1.0901156	-7.3223902	110	3	1.12	0.95	100.1549	0.2581	0.0000	0.0000;
	1584	1	5.702	1.306	0	0	1	1.0785344	-12.623285	110	3	1.12	0.95	103.4169	0.1207	0.0000	0.0000;
	1585	1	0	0	0	0	1	1.0785095	-12.636012	110	3	1.12	0.95	103.4222	0.1206	0.0000	0.0000;
	1586	1	3.442	0.56	0	0	1	1.1010514	-7.3971785	110	3	1.12	0.95	100.0918	0.3477	0.0000	0.0000;
	1587	1	11.397	4.57	0	0	1	1.1010852	-7.3893967	110	3	1.12	0.95	100.0896	0.3460	0.0000	0.0000;
	1588	1	6.305	1.69	0	0	1	1.0866476	-7.9260057	110	3	1.12	0.95	101.2725	0.8003	0.0000	0.0000;
	1589	1	0	0	0	0	1	1.0866613	-7.9201534	110	3	1.12	0.95	101.2719	0.7998	0.0000	0.0000;
	1590	1	10.841	2.699	0	0	1	1.1012311	-7.4084106	110	3	1.12	0.95	100.1276	0.4066	0.0000	0.0000;
	1591	1	6.062	1.797	0	0	1	1.1011397	-7.4257566	110	3	1.12	0.95	100.1324	0.4071	0.0000	0.0000;
	1592	1	4.515	1.278	0	0	1	1.10618	-4.9050762	110	3	1.12	0.95	99.1315	0.1242	0.0000	0.0000;
	1593	1	12.734	3.782	0	0	1	1.1062227	-4.9191808	110	3	1.12	0.95	99.1274	0.1248	0.0000	0.0000;
	1594	2	2.724	0.418	0	0	1	1.0672242	-13.505996	110	3	1.12	0.95	105.3554	0.6081	0.0000	0.0000;
	1595	1	0	0	0	0	1	1.0672562	-13.481392	110	3	1.12	0.95	105.3622	0.6097	0.0000	0.0000;
	1596	1	10.363	2.835	0	0	1	1.0709574	-8.9271899	110	3	1.12	0.95	103.1739	1.0228	0.0000	0.0000;
	1597	1	4.875	0.831	0	0	1	1.0710524	-8.90294	110	3	1.12	0.95	103.1644	1.0211	0.0000	0.0000;
	1598	1	6.528	1.398	0	0	1	1.1070378	-4.4563978	110	3	1.12	0.95	98.9116	0.1151	0.0000	0.0000;
	1599	1	0	0	0	0	1	1.107158	-4.445591	110	3	1.12	0.95	98.8984	0.1123	0.0000	0.0000;
	1600	1	14.856	3.218	0	0	1	1.0705865	-8.3833866	110	3	1.12	0.95	101.3738	-0.1417	0.0000	0.0000;
	1601	1	0	0	0	0	1	1.0706227	-8.3828808	110	3	1.12	0.95	101.3734	-0.1408	0.0000	0.0000;
	1602	1	15.032	4.925	0	0	1	1.0737135	-8.7921657	110	3	1.12	0.95	102.3924	0.7221	0.0000	0.0000;
	1603	1	0	0	0	0	1	1.0737364	-8.7905157	110	3	1.12	0.95	102.3902	0.7213	0.0000	0.0000;
	1604	1	13.424	3.399	0	0	1	1.0753889	-13.220932	110	3	1.12	0.95	104.1063	0.0917	0.0000	0.0000;
	1605	1	0	0	0	0	1	1.0753995	-13.209958	110	3	1.12	0.95	104.1017	0.0921	0.0000	0.0000;
	1606	1	8.1	1.459	0	0	1	1.0699215	-12.569968	110	3	1.12	0.95	105.6516	0.5473	0.0000	0.0000;
	1607	1	11.944	2.131	0	0	1	1.069921	-12.580161	110	3	1.12	0.95	105.6489	0.5474	0.0000	0.0000;
	1608	1	14.587	0.774	0	0	1	1.0949429	-7.9770927	110	3	1.12	0.95	100.9541	0.5072	0.0000	0.0000;
	1609	1	0	0	0	0	1	1.0949303	-7.9803973	110	3	1.12	0.95	100.9536	0.5066	0.0000	0.0000;
	1610	1	6.127	1.825	0	0	1	1.072586	-9.9585826	110	3	1.12	0.95	104.1362	1.0495	0.0000	0.0000;
	1611	1	0	0	0	0	1	1.0725427	-9.9644725	110	3	1.12	0.95	104.1369	1.0501	0.0000	0.0000;
	1612	1	7.01	1.669	0	0	1	1.0878646	-7.5055126	110	3	1.12	0.95	99.9982	-0.4288	0.0000	0.0000;
	1613	1	0	0	0	0	1	1.087879	-7.5048047	110	3	1.12	0.95	99.9962	-0.4293	0.0000	0.0000;
	1614	1	0	0	0	0	1	1.0955585	-5.6321002	110	3	1.12	0.95	100.0830	0.3687	0.0000	0.0000;
	1615	1	2.85	0.746	0	0	1	1.0955646	-5.6224802	110	3	1.12	0.95	100.0865	0.3685	0.0000	0.0000;
	1616	1	2.858	0.837	0	0	1	1.0931769	-8.9741119	110	3	1.12	0.95	101.5331	0.0186	0.0000	0.0000;
	1617	1	4.2	1.268	0	0	1	1.0931481	-8.9791459	110	3	1.12	0.95	101.5356	0.0187	0.0000	0.0000;
	1618	1	0	0	0	0	1	1.1110563	-3.6051514	110	3	1.12	0.95	99.6817	0.1180	0.0000	0.0000;
	1619	1	0	0	0	0	1	1.110919	-3.6036711	110	3	1.12	0.95	99.6817	0.1232	0.0000	0.0000;
	1620	1	7.722	0.979	0	0	1	1.0728773	-7.5852626	110	3	1.12	0.95	100.5830	0.0029	0.0000	0.0000;
	1621	1	4.156	0.583	0	0	1	1.0728682	-7.5962589	110	3	1.12	0.95	100.5853	0.0019	0.0000	0.0000;
	1622	1	12.017	2.623	0	0	1	1.0949398	-7.0627793	110	3	1.12	0.95	100.3433	0.5604	0.0000	0.0000;
	1623	1	0	0	0	0	1	1.0950749	-7.0375386	110	3	1.12	0.95	100.3363	0.5574	0.0000	0.0000;
	1624	1	1.9	0.373	0	0	1	1.1016197	-4.7541271	110	3	1.12	0.95	99.5076	0.2159	0.0000	0.0000;
	1625	1	0	0	0	0	1	1.1016817	-4.7490093	110	3	1.12	0.95	99.4993	0.2146	0.0000	0.0000;
	1626	1	10.359	2.274	0	0	1	1.0930059	-7.7797703	110	3	1.12	0.95	100.9653	-0.4484	0.0000	0.0000;
	1627	1	0	0	0	0	1	1.0930078	-7.7816869	110	3	1.12	0.95	100.9651	-0.4483	0.0000	0.0000;
	1628	1	25.528	8.504	0	0	1	1.0995195	-5.1912511	110	3	1.12	0.95	99.6248	0.2602	0.0000	0.0000;
	1629	1	0	0	0	0	1	1.0996803	-5.1683682	110	3	1.12	0.95	99.6146	0.2569	0.0000	0.0000;
	1630	1	9.526	1.898	0	0	1	1.0852321	-7.7491109	110	3	1.12	0.95	100.6657	0.3689	0.0000	0.0000;
	1631	1	9.525	0.953	0	0	1	1.0854026	-7.7260243	110	3	1.12	0.95	100.6570	0.3662	0.0000	0.0000;
	1632	1	0	0	0	0	1	1.072847	-8.2570499	110	3	1.12	0.95	101.1381	-0.3346	0.0000	0.0000;
	1633	1	0	0	0	0	1	1.0726624	-8.260476	110	3	1.12	0.95	101.1445	-0.3250	0.0000	0.0000;
	1634	1	0	0	0	0	1	1.0895371	-7.5078548	110	3	1.12	0.95	100.2513	-0.4629	0.0000	0.0000;
	1635	1	7.128	1.073	0	0	1	1.0747484	-7.0741833	110	3	1.12	0.95	100.1407	0.0782	0.0000	0.0000;
	1636	1	0	0.09	0	0	1	1.0746919	-7.0947117	110	3	1.12	0.95	100.1463	0.0777	0.0000	0.0000;
	1637	1	18.917	-1.519	0	0	1	1.0916497	-10.117741	110	3	1.12	0.95	102.4007	-0.0029	0.0000	0.0000;
	1638	1	19.048	-0.92	0	0	1	1.0916252	-10.120895	110	3	1.12	0.95	102.4007	-0.0035	0.0000	0.0000;
	1639	1	8.084	0.974	0	0	1	1.0929337	-7.8081907	110	3	1.12	0.95	100.9791	-0.4471	0.0000	0.0000;
	1640	1	0	0	0	0	1	1.0929328	-7.8062794	110	3	1.12	0.95	100.9793	-0.4472	0.0000	0.0000;
	1641	1	0	0	0	0	1	1.0929284	-7.8043915	110	3	1.12	0.95	100.9802	-0.4473	0.0000	0.0000;
	1642	1	0	0	0	0	1	1.0929284	-7.8043915	110	3	1.12	0.95	100.9802	-0.4473	0.0000	0.0000;
	1643	1	19.063	9.444	0	0	1	1.093164	-7.0193387	110	3	1.12	0.95	99.8716	0.4797	0.0000	0.0000;
	1644	1	13.067	3.022	0	0	1	1.0885576	-7.7472292	110	3	1.12	0.95	101.0597	0.7381	0.0000	0.0000;
	1645	1	0	0	0	0	1	1.0953486	-7.0177274	110	3	1.12	0.95	100.3094	0.5447	0.0000	0.0000;
	1646	1	0	0	0	0	1	1.0953478	-7.017712	110	3	1.12	0.95	100.3094	0.5448	0.0000	0.0000;
	1647	2	9.785	3.539	0	0	1	1.0707294	-14.497571	110	3	1.12	0.95	105.6886	0.0000	0.0000	0.0000;
	1648	1	0.783	-0.815	0	0	1	1.0707293	-14.492984	110	3	1.12	0.95	105.6859	-0.0003	0.0000	0.0000;
	1649	1	0.237	0	0	0	1	1.1077711	-4.1680583	110	3	1.12	0.95	99.0146	0.0688	0.0000	0.0000;
	1650	1	0.594	0	0	0	1	1.1189468	-5.8473707	110	3	1.12	0.95	98.1791	-0.0001	0.0000	0.0000;
	1651	1	0	0	0	0	1	1.1077721	-4.1678535	110	3	1.12	0.95	99.0144	0.0688	0.0000	0.0000;
	1652	1	10.804	3.544	0	0	1	1.0910624	-8.2001186	110	3	1.12	0.95	101.0378	0.6763	0.0000	0.0000;
	1653	1	4.511	2.984	0	0	1	1.0911117	-8.1935548	110	3	1.12	0.95	101.0353	0.6755	0.0000	0.0000;
	1654	1	2.018	0.839	0	0	1	1.1127104	-5.5389558	110	3	1.12	0.95	98.7981	0.1133	0.0000	0.0000;
	1655	1	0	0	0	0	1	1.1127932	-5.5337711	110	3	1.12	0.95	98.7915	0.1106	0.0000	0.0000;
	1656	1	4.04	-0.224	0	0	1	1.0849881	-12.367492	110	3	1.12	0.95	102.7420	0.0227	0.0000	0.0000;
	1657	1	0	0	0	0	1	1.085022	-12.362808	110	3	1.12	0.95	102.7385	0.0229	0.0000	0.0000;
	1658	1	8.318	2.005	0	0	1	1.1003404	-4.8828224	110	3	1.12	0.95	99.6215	0.2528	0.0000	0.0000;
	1659	1	8.316	2.471	0	0	1	1.1003999	-4.8712312	110	3	1.12	0.95	99.6190	0.2536	0.0000	0.0000;
	1660	1	6.173	0.728	0	0	1	1.0777476	-7.7704306	110	3	1.12	0.95	105.0760	0.3737	0.0000	0.0000;
	1661	1	0	0	0	0	1	1.0778829	-7.7610579	110	3	1.12	0.95	105.0537	0.3712	0.0000	0.0000;
	1662	1	15.435	4.85	0	0	1	1.0861997	-6.825769	110	3	1.12	0.95	100.5186	0.0103	0.0000	0.0000;
	1663	1	0	0	0	0	1	1.0862308	-6.8212503	110	3	1.12	0.95	100.5192	0.0119	0.0000	0.0000;
	1664	1	4.712	1.458	0	0	1	1.0737788	-13.135058	110	3	1.12	0.95	103.8099	0.2990	0.0000	0.0000;
	1665	1	12.022	1.854	0	0	1	1.0880888	-8.827208	110	3	1.12	0.95	102.5568	0.5084	0.0000	0.0000;
	1666	1	0	0	0	0	1	1.0880371	-8.8354374	110	3	1.12	0.95	102.5584	0.5093	0.0000	0.0000;
	1667	1	9.972	3.078	0	0	1	1.0865009	-6.8092517	110	3	1.12	0.95	100.4606	-0.0208	0.0000	0.0000;
	1668	1	0	0	0	0	1	1.0865484	-6.8038889	110	3	1.12	0.95	100.4564	-0.0236	0.0000	0.0000;
	1669	1	0	0	0	0	1	1.0651577	-12.896277	110	3	1.12	0.95	106.0090	0.6517	0.0000	0.0000;
	1670	1	0	0	0	0	1	1.0651544	-12.896218	110	3	1.12	0.95	106.0090	0.6519	0.0000	0.0000;
	1671	1	1.424	0.596	0	0	1	1.08026	-9.5903083	110	3	1.12	0.95	102.6942	-0.3315	0.0000	0.0000;
	1672	1	0	0	0	0	1	1.0802734	-9.5889293	110	3	1.12	0.95	102.6909	-0.3317	0.0000	0.0000;
	1673	1	0	0	0	0	1	1.0950033	-6.863852	110	3	1.12	0.95	99.6178	0.2153	0.0000	0.0000;
	1674	1	12.359	1.259	0	0	1	1.0951141	-6.8466649	110	3	1.12	0.95	99.6111	0.2160	0.0000	0.0000;
	1675	2	20.105	19.653	0	0	1	1.1133112	-6.1619921	110	3	1.12	0.95	98.8533	-0.0000	0.0000	0.0000;
	1676	2	15	19	0	0	1	1.0942052	-6.3880056	110	3	1.12	0.95	99.5185	0.0000	0.0000	0.0000;
	1677	2	3.681	1.492	0	0	1	1.094518	-6.1630735	110	3	1.12	0.95	99.7977	-0.1223	0.0000	0.0000;
	1678	1	13.551	3.272	0	0	1	1.0928403	-7.7505978	110	3	1.12	0.95	100.9757	-0.4704	0.0000	0.0000;
	1679	1	0	0	0	0	1	1.0929015	-7.7382903	110	3	1.12	0.95	100.9722	-0.4694	0.0000	0.0000;
	1680	1	5.478	1.22	0	0	1	1.113113	-2.9717464	110	3	1.12	0.95	99.3393	0.1083	0.0000	0.0000;
	1681	1	0	0	0	0	1	1.1130768	-2.9869095	110	3	1.12	0.95	99.3424	0.1088	0.0000	0.0000;
	1682	1	10.483	3.905	0	0	1	1.0817366	-7.0735401	110	3	1.12	0.95	100.1975	-0.3509	0.0000	0.0000;
	1683	1	0	0	0	0	1	1.0818131	-7.0791968	110	3	1.12	0.95	100.1996	-0.3526	0.0000	0.0000;
	1684	1	0	0	0	0	1	1.0817862	-6.5943199	110	3	1.12	0.95	99.6895	-0.1846	0.0000	0.0000;
	1685	1	7.123	1.865	0	0	1	1.0978582	-6.6538584	110	3	1.12	0.95	99.9506	0.5150	0.0000	0.0000;
	1686	1	0	0	0	0	1	1.0978076	-6.6676104	110	3	1.12	0.95	99.9543	0.5157	0.0000	0.0000;
	1687	2	8.721	10.55	0	0	1	1.0954547	-9.7108753	110	3	1.12	0.95	101.7843	0.0000	0.0000	0.0000;
	1688	2	16.498	20.376	0	0	1	1.0954466	-9.6577511	110	3	1.12	0.95	101.9510	0.0000	0.0000	0.0000;
	1689	1	5.408	-0.433	0	0	1	1.0635769	-13.374408	110	3	1.12	0.95	107.0152	0.4866	0.0000	0.0000;
	1690	1	7.651	0.76	0	0	1	1.063576	-13.373921	110	3	1.12	0.95	107.0151	0.4865	0.0000	0.0000;
	1691	1	3.687	0.425	0	0	1	1.081258	-9.5143658	110	3	1.12	0.95	102.4278	-0.3244	0.0000	0.0000;
	1692	1	0	0	0	0	1	1.0812218	-9.5001203	110	3	1.12	0.95	102.4305	-0.3268	0.0000	0.0000;
	1693	1	0	0	0	0	1	1.0939424	-9.6769706	110	3	1.12	0.95	102.0527	0.0440	0.0000	0.0000;
	1694	1	0	0	0	0	1	1.0949653	-9.79045	110	3	1.12	0.95	101.8241	0.0101	0.0000	0.0000;
	1695	1	2.493	0.093	0	0	1	1.0667534	-8.9063258	110	3	1.12	0.95	102.5585	-0.1701	0.0000	0.0000;
	1696	1	4.511	2.425	0	0	1	1.0934175	-5.5136704	110	3	1.12	0.95	101.6013	0.4377	0.0000	0.0000;
	1697	1	19.499	5.73	0	0	1	1.0776774	-8.9387185	110	3	1.12	0.95	102.5393	1.0507	0.0000	0.0000;
	1698	1	0	0	0	0	1	1.0775903	-8.9511813	110	3	1.12	0.95	102.5417	1.0518	0.0000	0.0000;
	1699	1	6.767	1.585	0	0	1	1.1081488	-5.9886958	110	3	1.12	0.95	99.3485	0.0486	0.0000	0.0000;
	1700	1	0	0	0	0	1	1.108165	-5.9755456	110	3	1.12	0.95	99.3511	0.0472	0.0000	0.0000;
	1701	1	2.969	1.073	0	0	1	1.1072244	-6.1504221	110	3	1.12	0.95	99.4730	0.0885	0.0000	0.0000;
	1702	1	3.563	0.736	0	0	1	1.1064237	-6.829018	110	3	1.12	0.95	99.5830	0.1757	0.0000	0.0000;
	1703	1	0	0	0	0	1	1.1076909	-6.1336607	110	3	1.12	0.95	99.4120	0.0703	0.0000	0.0000;
	1704	1	0	0	0	0	1	1.106916	-6.8055887	110	3	1.12	0.95	99.5086	0.1642	0.0000	0.0000;
	1705	1	8.547	1.585	0	0	1	1.1027016	-4.7307293	110	3	1.12	0.95	99.4018	0.1766	0.0000	0.0000;
	1706	1	4.868	1.772	0	0	1	1.1004631	-4.8728456	110	3	1.12	0.95	99.6010	0.2503	0.0000	0.0000;
	1707	1	0	0	0	0	1	1.1029786	-4.7024009	110	3	1.12	0.95	99.3705	0.1709	0.0000	0.0000;
	1708	1	11.73	1.947	0	0	1	1.0821458	-9.393133	110	3	1.12	0.95	102.6013	0.2389	0.0000	0.0000;
	1709	1	9.577	-0.247	0	0	1	1.0820629	-9.3969174	110	3	1.12	0.95	102.6093	0.2372	0.0000	0.0000;
	1710	1	3.356	0.933	0	0	1	1.0963423	-6.8679256	110	3	1.12	0.95	100.1410	0.5410	0.0000	0.0000;
	1711	1	3.562	0.933	0	0	1	1.0963832	-6.8555176	110	3	1.12	0.95	100.1378	0.5405	0.0000	0.0000;
	1712	1	9.397	2.449	0	0	1	1.1090821	-4.0890623	110	3	1.12	0.95	98.7645	0.0423	0.0000	0.0000;
	1713	1	4.75	1.436	0	0	1	1.1088122	-4.2016288	110	3	1.12	0.95	98.8360	0.0288	0.0000	0.0000;
	1714	1	0	0	0	0	1	1.1097019	-4.0571708	110	3	1.12	0.95	98.6872	0.0226	0.0000	0.0000;
	1715	1	0	0	0	0	1	1.1091377	-4.1860871	110	3	1.12	0.95	98.7969	0.0174	0.0000	0.0000;
	1716	1	10.109	1.8	0	0	1	1.1082426	-5.9958856	110	3	1.12	0.95	99.3684	0.0339	0.0000	0.0000;
	1717	1	0	0	0	0	1	1.1082561	-6.0054782	110	3	1.12	0.95	99.3649	0.0347	0.0000	0.0000;
	1718	1	6.114	1.129	0	0	1	1.0892731	-8.3672744	110	3	1.12	0.95	101.5151	0.6237	0.0000	0.0000;
	1719	1	0	0	0	0	1	1.0892028	-8.3798325	110	3	1.12	0.95	101.5166	0.6248	0.0000	0.0000;
	1720	1	2.374	0	0	0	1	1.0888381	-7.4418132	110	3	1.12	0.95	100.2963	0.2696	0.0000	0.0000;
	1721	1	10.685	0.933	0	0	1	1.0888931	-7.4323758	110	3	1.12	0.95	100.2925	0.2687	0.0000	0.0000;
	1722	1	4.41	1.2	0	0	1	1.0811832	-6.8693323	110	3	1.12	0.95	103.3010	0.5291	0.0000	0.0000;
	1723	1	0	0	0	0	1	1.0811674	-6.8758645	110	3	1.12	0.95	103.3015	0.5282	0.0000	0.0000;
	1724	1	5.71	2.017	0	0	1	1.0908531	-4.5805704	110	3	1.12	0.95	98.8092	0.0553	0.0000	0.0000;
	1725	1	4.994	1.792	0	0	1	1.0908039	-4.4745273	110	3	1.12	0.95	98.7929	0.0438	0.0000	0.0000;
	1726	1	0	0	0	0	1	1.0908694	-4.5795946	110	3	1.12	0.95	98.8077	0.0547	0.0000	0.0000;
	1727	1	0	0	0	0	1	1.0909625	-4.4629423	110	3	1.12	0.95	98.7798	0.0392	0.0000	0.0000;
	1728	1	19.796	5.109	0	0	1	1.0697284	-10.167559	110	3	1.12	0.95	104.1537	1.1774	0.0000	0.0000;
	1729	1	0	0	0	0	1	1.0697209	-10.169283	110	3	1.12	0.95	104.1561	1.1776	0.0000	0.0000;
	1730	1	19.251	6.248	0	0	1	1.0938582	-4.0719457	110	3	1.12	0.95	98.3408	0.0325	0.0000	0.0000;
	1731	1	0	0	0	0	1	1.0938755	-4.0705352	110	3	1.12	0.95	98.3410	0.0330	0.0000	0.0000;
	1732	1	4.755	0.926	0	0	1	1.081943	-6.3252983	110	3	1.12	0.95	99.3760	-0.0811	0.0000	0.0000;
	1733	1	0	0	0	0	1	1.0819115	-6.3136133	110	3	1.12	0.95	99.3718	-0.0802	0.0000	0.0000;
	1734	1	2.732	0.793	0	0	1	1.0919692	-4.3590319	110	3	1.12	0.95	98.7306	0.0443	0.0000	0.0000;
	1735	1	6.177	1.539	0	0	1	1.0903851	-8.2667695	110	3	1.12	0.95	101.1081	0.6923	0.0000	0.0000;
	1736	1	0	0	0	0	1	1.0807044	-8.0738925	110	3	1.12	0.95	100.9546	-0.2920	0.0000	0.0000;
	1737	1	20.894	2.612	0	0	1	1.0910503	-5.7798462	110	3	1.12	0.95	101.9501	0.5030	0.0000	0.0000;
	1738	1	0	0	0	0	1	1.0910563	-5.7794763	110	3	1.12	0.95	101.9489	0.5031	0.0000	0.0000;
	1739	1	20.224	5.655	0	0	1	1.0734821	-8.73133	110	3	1.12	0.95	101.8360	0.7043	0.0000	0.0000;
	1740	1	0	0	0	0	1	1.0660614	-8.9259258	110	3	1.12	0.95	101.9143	-0.1740	0.0000	0.0000;
	1741	1	11.04	4.018	0	0	1	1.0535473	-15.696759	110	3	1.12	0.95	107.2311	0.6693	0.0000	0.0000;
	1742	2	11.474	3.333	0	0	1	1.0535497	-15.694174	110	3	1.12	0.95	107.2333	0.6699	0.0000	0.0000;
	1743	1	5.352	1.428	0	0	1	1.0912387	-7.8880374	110	3	1.12	0.95	101.1847	-0.4678	0.0000	0.0000;
	1744	1	13.192	3.031	0	0	1	1.0905752	-7.9281372	110	3	1.12	0.95	101.2721	-0.4453	0.0000	0.0000;
	1745	1	11.873	2.798	0	0	1	1.0515367	-14.926278	110	3	1.12	0.95	107.7020	0.8893	0.0000	0.0000;
	1746	1	9.497	2.798	0	0	1	1.0517203	-14.922706	110	3	1.12	0.95	107.6716	0.8851	0.0000	0.0000;
	1747	1	0	0	0	0	1	1.0947864	-5.4906047	110	3	1.12	0.95	101.5208	0.4137	0.0000	0.0000;
	1748	1	4.165	0.181	0	0	1	1.09476	-5.4962638	110	3	1.12	0.95	101.5215	0.4140	0.0000	0.0000;
	1749	2	13.27	1.818	0	0	1	1.0819235	-8.557437	110	3	1.12	0.95	101.8747	0.9731	0.0000	0.0000;
	1750	1	0	0	0	0	1	1.081928	-8.565907	110	3	1.12	0.95	101.8713	0.9728	0.0000	0.0000;
	1751	1	13.755	3.558	0	0	1	1.0562157	-16.138111	110	3	1.12	0.95	107.5810	0.3797	0.0000	0.0000;
	1752	1	1.294	0.229	0	0	1	1.0562623	-16.128358	110	3	1.12	0.95	107.5742	0.3790	0.0000	0.0000;
	1753	1	11.318	1.558	0	0	1	1.0671967	-9.2307003	110	3	1.12	0.95	103.8348	1.0799	0.0000	0.0000;
	1754	1	8.93	2.34	0	0	1	1.0672247	-9.2165274	110	3	1.12	0.95	103.8294	1.0795	0.0000	0.0000;
	1755	1	10.883	11.784	0	0	1	1.0595283	-11.074517	110	3	1.12	0.95	105.4562	1.7534	0.0000	0.0000;
	1756	1	0	0	0	0	1	1.0596261	-11.056915	110	3	1.12	0.95	105.4554	1.7516	0.0000	0.0000;
	1757	1	11.904	1.927	0	0	1	1.1080978	-3.7623757	110	3	1.12	0.95	99.6269	0.2332	0.0000	0.0000;
	1758	1	5.229	0.456	0	0	1	1.107918	-3.7945437	110	3	1.12	0.95	99.6449	0.2363	0.0000	0.0000;
	1759	1	0	0	0	0	1	1.1019966	-6.6064613	110	3	1.12	0.95	99.7786	0.4206	0.0000	0.0000;
	1760	2	12.455	1.482	0	0	1	1.1018198	-6.6338317	110	3	1.12	0.95	99.7866	0.4235	0.0000	0.0000;
	1761	1	4.753	0.743	0	0	1	1.1031206	-4.4239778	110	3	1.12	0.95	100.0674	0.3263	0.0000	0.0000;
	1762	1	12.022	0.823	0	0	1	1.1030429	-4.4274281	110	3	1.12	0.95	100.0919	0.3259	0.0000	0.0000;
	1763	1	10.719	1.533	0	0	1	1.0806936	-8.0737084	110	3	1.12	0.95	100.9546	-0.2914	0.0000	0.0000;
	1764	1	13.112	2.263	0	0	1	1.0807798	-8.0672715	110	3	1.12	0.95	100.9524	-0.2905	0.0000	0.0000;
	1765	1	0	0	0	0	1	1.0854469	-10.700992	110	3	1.12	0.95	103.0876	0.2539	0.0000	0.0000;
	1766	1	0	0	0	0	1	1.0853287	-10.723863	110	3	1.12	0.95	103.0974	0.2561	0.0000	0.0000;
	1767	1	2.374	0.555	0	0	1	1.0755733	-13.113749	110	3	1.12	0.95	103.8635	0.1670	0.0000	0.0000;
	1768	1	0	0	0	0	1	1.0752857	-12.797716	110	3	1.12	0.95	103.6589	0.2467	0.0000	0.0000;
	1769	1	3.922	0.34	0	0	1	1.0950904	-6.0860747	110	3	1.12	0.95	100.2523	0.3777	0.0000	0.0000;
	1770	1	0	0	0	0	1	1.095132	-6.0904673	110	3	1.12	0.95	100.2487	0.3781	0.0000	0.0000;
	1771	1	2.97	1.053	0	0	1	1.077849	-8.9461821	110	3	1.12	0.95	102.6016	0.3878	0.0000	0.0000;
	1772	1	0	0	0	0	1	1.0777955	-8.9391424	110	3	1.12	0.95	102.6055	0.3860	0.0000	0.0000;
	1773	1	0	0	0	0	1	1.0945929	-4.08918	110	3	1.12	0.95	98.3790	0.0068	0.0000	0.0000;
	1774	2	8.537	3.068	0	0	1	1.0946156	-4.0806138	110	3	1.12	0.95	98.3734	0.0068	0.0000	0.0000;
	1775	1	13.068	2.341	0	0	1	1.0932977	-4.186077	110	3	1.12	0.95	98.4333	0.0082	0.0000	0.0000;
	1776	1	0	0	0	0	1	1.0933409	-4.1743454	110	3	1.12	0.95	98.4299	0.0086	0.0000	0.0000;
	1777	1	23.441	4.853	0	0	1	1.070152	-12.90649	110	3	1.12	0.95	105.7520	0.4382	0.0000	0.0000;
	1778	1	0	0	0	0	1	1.0700102	-12.911088	110	3	1.12	0.95	105.7676	0.4405	0.0000	0.0000;
	1779	2	37.753	11.006	0	0	1	1.0699177	-8.1453786	110	3	1.12	0.95	101.1333	-0.0468	0.0000	0.0000;
	1780	1	0	0	0	0	1	1.0700122	-8.1310233	110	3	1.12	0.95	101.1273	-0.0481	0.0000	0.0000;
	1781	1	2.85	0.56	0	0	1	1.0938286	-4.2047468	110	3	1.12	0.95	98.5368	0.0020	0.0000	0.0000;
	1782	1	0	0	0	0	1	1.093852	-4.1961777	110	3	1.12	0.95	98.5312	0.0021	0.0000	0.0000;
	1783	1	8.667	1.959	0	0	1	1.1021024	-6.1889981	110	3	1.12	0.95	98.8390	0.1253	0.0000	0.0000;
	1784	1	0	0	0	0	1	1.1023293	-6.167867	110	3	1.12	0.95	98.8155	0.1201	0.0000	0.0000;
	1785	1	11.178	2.887	0	0	1	1.0936464	-4.1981729	110	3	1.12	0.95	98.5265	0.0168	0.0000	0.0000;
	1786	1	0	0	0	0	1	1.0936698	-4.1902215	110	3	1.12	0.95	98.5224	0.0167	0.0000	0.0000;
	1787	1	9.511	2.449	0	0	1	1.0732499	-8.1239868	110	3	1.12	0.95	101.1452	-0.0921	0.0000	0.0000;
	1788	1	8.315	1.725	0	0	1	1.071207	-8.401788	110	3	1.12	0.95	101.4150	-0.1490	0.0000	0.0000;
	1789	1	0	0	0	0	1	1.0737751	-8.1003038	110	3	1.12	0.95	101.0722	-0.1106	0.0000	0.0000;
	1790	1	0	0	0	0	1	1.0716124	-8.3829693	110	3	1.12	0.95	101.3544	-0.1613	0.0000	0.0000;
	1791	1	5.935	1.211	0	0	1	1.0738616	-13.094425	110	3	1.12	0.95	103.9745	0.2307	0.0000	0.0000;
	1792	1	0	0	0	0	1	1.0738569	-13.105004	110	3	1.12	0.95	103.9792	0.2300	0.0000	0.0000;
	1793	1	0.474	0.076	0	0	1	1.0986066	-5.0494007	110	3	1.12	0.95	100.6822	0.4001	0.0000	0.0000;
	1794	1	0	0	0	0	1	1.0986226	-5.0450702	110	3	1.12	0.95	100.6791	0.3997	0.0000	0.0000;
	1795	1	0	0	0	0	1	1.0754779	-13.355377	110	3	1.12	0.95	104.2555	0.0363	0.0000	0.0000;
	1796	1	0	0	0	0	1	1.0751649	-13.368325	110	3	1.12	0.95	104.2735	0.0459	0.0000	0.0000;
	1797	1	8.31	4.663	0	0	1	1.0928524	-6.0867557	110	3	1.12	0.95	99.9746	-1.0886	0.0000	0.0000;
	1798	2	13.05	12.114	0	0	1	1.0909689	-7.1143082	110	3	1.12	0.95	100.0993	-1.3841	0.0000	0.0000;
	1799	2	17.049	10.819	0	0	1	1.1032299	-7.331348	110	3	1.12	0.95	99.9387	0.3147	0.0000	0.0000;
	1800	1	8.214	2.478	0	0	1	1.1030864	-7.344321	110	3	1.12	0.95	99.9428	0.3164	0.0000	0.0000;
	1801	1	18.465	5.748	0	0	1	1.1035445	-7.2488774	110	3	1.12	0.95	99.8494	0.3298	0.0000	0.0000;
	1802	1	13.715	4.363	0	0	1	1.1034976	-7.2592654	110	3	1.12	0.95	99.8532	0.3298	0.0000	0.0000;
	1803	1	4.757	1.686	0	0	1	1.1090413	-4.141022	110	3	1.12	0.95	98.6448	0.0718	0.0000	0.0000;
	1804	1	5.828	1.737	0	0	1	1.0933064	-4.2688823	110	3	1.12	0.95	98.6333	0.0030	0.0000	0.0000;
	1805	1	0	0	0	0	1	1.1090813	-4.1386618	110	3	1.12	0.95	98.6410	0.0705	0.0000	0.0000;
	1806	1	8.911	2.845	0	0	1	1.0829606	-7.9219124	110	3	1.12	0.95	100.8940	0.4382	0.0000	0.0000;
	1807	1	6.534	2.285	0	0	1	1.0828408	-7.9378275	110	3	1.12	0.95	100.9000	0.4401	0.0000	0.0000;
	1808	1	9.044	1.772	0	0	1	1.1076105	-6.5288881	110	3	1.12	0.95	99.4491	0.1177	0.0000	0.0000;
	1809	1	7.84	2.228	0	0	1	1.1090099	-6.5556298	110	3	1.12	0.95	99.2929	0.1063	0.0000	0.0000;
	1810	1	8.808	3.686	0	0	1	1.0684813	-14.033343	110	3	1.12	0.95	105.1114	0.2563	0.0000	0.0000;
	1811	1	0	0	0	0	1	1.0685701	-14.018055	110	3	1.12	0.95	105.1052	0.2541	0.0000	0.0000;
	1812	1	5.945	-0.235	0	0	1	1.084606	-6.5442903	110	3	1.12	0.95	103.6823	0.4076	0.0000	0.0000;
	1813	1	0	0	0	0	1	1.084606	-6.5442903	110	3	1.12	0.95	103.6823	0.4076	0.0000	0.0000;
	1814	1	9.743	2.565	0	0	1	1.1004419	-7.5034647	110	3	1.12	0.95	100.2104	0.3955	0.0000	0.0000;
	1815	1	12.123	3.124	0	0	1	1.100289	-7.520001	110	3	1.12	0.95	100.2173	0.3967	0.0000	0.0000;
	1816	1	18.279	4.248	0	0	1	1.0684087	-9.616026	110	3	1.12	0.95	103.3894	1.3719	0.0000	0.0000;
	1817	1	0	0	0	0	1	1.0682584	-9.6325668	110	3	1.12	0.95	103.3944	1.3745	0.0000	0.0000;
	1818	1	9.449	2.832	0	0	1	1.0877918	-8.5592211	110	3	1.12	0.95	101.6174	0.6751	0.0000	0.0000;
	1819	1	0	0	0	0	1	1.0885836	-8.5299277	110	3	1.12	0.95	101.5079	0.6434	0.0000	0.0000;
	1820	1	2.497	0.466	0	0	1	1.0871725	-7.7451408	110	3	1.12	0.95	100.6076	-0.2430	0.0000	0.0000;
	1821	1	0	0	0	0	1	1.0871751	-7.7449594	110	3	1.12	0.95	100.6072	-0.2431	0.0000	0.0000;
	1822	1	0	0	0	0	1	1.091921	-9.0824961	110	3	1.12	0.95	101.4687	0.0475	0.0000	0.0000;
	1823	1	0	0	0	0	1	1.0908614	-9.1857443	110	3	1.12	0.95	101.8581	0.0402	0.0000	0.0000;
	1824	1	21.589	5.376	0	0	1	1.0922232	-8.4220436	110	3	1.12	0.95	101.5142	0.4438	0.0000	0.0000;
	1825	1	0	0	0	0	1	1.092281	-8.4232198	110	3	1.12	0.95	101.5144	0.4424	0.0000	0.0000;
	1826	1	10.818	2.793	0	0	1	1.0717121	-7.9382273	110	3	1.12	0.95	100.9023	-0.0405	0.0000	0.0000;
	1827	1	0	0	0	0	1	1.0717846	-7.9414402	110	3	1.12	0.95	100.9030	-0.0384	0.0000	0.0000;
	1828	1	13.354	2.653	0	0	1	1.0914012	-9.1988098	110	3	1.12	0.95	101.8064	0.0298	0.0000	0.0000;
	1829	1	18.582	4.304	0	0	1	1.091327	-9.2171236	110	3	1.12	0.95	101.8152	0.0295	0.0000	0.0000;
	1830	1	0	0	0	0	1	1.0759309	-6.8199819	110	3	1.12	0.95	103.8154	0.8012	0.0000	0.0000;
	1831	1	13.128	7.016	0	0	1	1.075863	-6.8142584	110	3	1.12	0.95	103.8249	0.8040	0.0000	0.0000;
	1832	1	5.828	1.737	0	0	1	1.1092167	-4.0818663	110	3	1.12	0.95	98.6163	0.0675	0.0000	0.0000;
	1833	1	10.576	2.751	0	0	1	1.1052633	-4.5072513	110	3	1.12	0.95	99.1531	0.1256	0.0000	0.0000;
	1834	1	0	0	0	0	1	1.1053938	-4.4963182	110	3	1.12	0.95	99.1403	0.1223	0.0000	0.0000;
	1835	1	18.907	5.964	0	0	1	1.0683347	-10.299694	110	3	1.12	0.95	104.4621	1.1954	0.0000	0.0000;
	1836	1	0	0	0	0	1	1.0683482	-10.297999	110	3	1.12	0.95	104.4597	1.1951	0.0000	0.0000;
	1837	1	12.836	4.333	0	0	1	1.0912366	-5.3917766	110	3	1.12	0.95	99.4591	-0.5412	0.0000	0.0000;
	1838	1	0	0	0	0	1	1.0913437	-5.4073299	110	3	1.12	0.95	99.4612	-0.5494	0.0000	0.0000;
	1839	1	3.681	0.933	0	0	1	1.0903821	-7.2974333	110	3	1.12	0.95	100.0369	0.0161	0.0000	0.0000;
	1840	1	0	0	0	0	1	1.0903031	-7.3046031	110	3	1.12	0.95	100.0403	0.0139	0.0000	0.0000;
	1841	2	17.749	30.865	0	0	1	1.1103181	-5.4295842	110	3	1.12	0.95	97.9643	-0.0000	0.0000	0.0000;
	1842	1	0	0	0	0	1	1.1001643	-6.6669408	110	3	1.12	0.95	99.8510	0.3506	0.0000	0.0000;
	1843	2	13	29	0	0	1	1.1068942	-5.7512978	110	3	1.12	0.95	98.9789	0.2912	0.0000	0.0000;
	1844	1	0	0.075	0	0	1	1.1006841	-4.8578586	110	3	1.12	0.95	99.5817	0.2434	0.0000	0.0000;
	1845	1	4.756	1.401	0	0	1	1.1007734	-4.8469149	110	3	1.12	0.95	99.5792	0.2420	0.0000	0.0000;
	1846	1	10.28	2.84	0	0	1	1.0657522	-9.8530208	110	3	1.12	0.95	103.6755	1.4460	0.0000	0.0000;
	1847	2	8.672	3.616	0	0	1	1.0903711	-7.1412861	110	3	1.12	0.95	100.1320	-1.3629	0.0000	0.0000;
	1848	1	15.651	3.04	0	0	1	1.0744753	-11.831361	110	3	1.12	0.95	104.8473	0.3984	0.0000	0.0000;
	1849	2	9.398	2.292	0	0	1	1.0744377	-11.855191	110	3	1.12	0.95	104.8450	0.3983	0.0000	0.0000;
	1850	1	21.383	5.596	0	0	1	1.1100405	-6.4586916	110	3	1.12	0.95	99.1790	0.0809	0.0000	0.0000;
	1851	1	0	0	0	0	1	1.1100162	-6.4635809	110	3	1.12	0.95	99.1801	0.0813	0.0000	0.0000;
	1852	2	0	-0.01	0	0	1	1.1039817	-4.5713441	110	3	1.12	0.95	99.2799	0.1531	0.0000	0.0000;
	1853	1	6.424	1.865	0	0	1	1.1039327	-4.577788	110	3	1.12	0.95	99.2824	0.1536	0.0000	0.0000;
	1854	1	17.864	3.088	0	0	1	1.0845978	-8.1791742	110	3	1.12	0.95	101.6189	0.8307	0.0000	0.0000;
	1855	1	14.881	3.378	0	0	1	1.084605	-8.1823098	110	3	1.12	0.95	101.6177	0.8309	0.0000	0.0000;
	1856	1	8.75	1.746	0	0	1	1.0893939	-7.7957883	110	3	1.12	0.95	100.8164	0.0987	0.0000	0.0000;
	1857	1	5.049	1.116	0	0	1	1.0894354	-7.8126779	110	3	1.12	0.95	100.8171	0.1010	0.0000	0.0000;
	1858	1	25.324	2.898	0	0	1	1.0777397	-8.9107961	110	3	1.12	0.95	102.5917	0.3856	0.0000	0.0000;
	1859	1	0	0	0	0	1	1.0777276	-8.8935463	110	3	1.12	0.95	102.5918	0.3833	0.0000	0.0000;
	1860	1	0	0	0	0	1	1.0945292	-6.1632654	110	3	1.12	0.95	99.7977	-0.1230	0.0000	0.0000;
	1861	1	14.282	2.915	0	0	1	1.1124254	-6.2432113	110	3	1.12	0.95	98.9514	0.0195	0.0000	0.0000;
	1862	1	0	0	0	0	1	1.1118892	-3.8135099	110	3	1.12	0.95	98.3949	0.0018	0.0000	0.0000;
	1863	1	15.687	0.232	0	0	1	1.0944232	-7.698138	110	3	1.12	0.95	100.7706	-0.4565	0.0000	0.0000;
	1864	1	2.969	0.14	0	0	1	1.0881357	-7.5076146	110	3	1.12	0.95	99.9881	-0.4522	0.0000	0.0000;
	1865	2	4.264	1.184	0	0	1	1.0534077	-15.705208	110	3	1.12	0.95	107.2564	0.6724	0.0000	0.0000;
	1866	1	2.864	0.111	0	0	1	1.0534074	-15.705596	110	3	1.12	0.95	107.2568	0.6724	0.0000	0.0000;
	1867	1	18.663	4.519	0	0	1	1.0571332	-13.803802	110	3	1.12	0.95	107.2314	0.7687	0.0000	0.0000;
	1868	1	0	0	0	0	1	1.0571967	-13.784308	110	3	1.12	0.95	107.2341	0.7689	0.0000	0.0000;
	1869	1	0.356	0.154	0	0	1	1.0880689	-7.2759321	110	3	1.12	0.95	100.2910	-1.0312	0.0000	0.0000;
	1870	1	0	0	0	0	1	1.0880118	-7.280597	110	3	1.12	0.95	100.2912	-1.0239	0.0000	0.0000;
	1871	1	0.831	0.56	0	0	1	1.1023014	-7.274289	110	3	1.12	0.95	99.9558	0.3033	0.0000	0.0000;
	1872	1	2.968	2.332	0	0	1	1.1017911	-7.2951445	110	3	1.12	0.95	99.9838	0.3242	0.0000	0.0000;
	1873	1	0	0	0	0	1	1.0961003	-6.8986388	110	3	1.12	0.95	100.2617	0.6007	0.0000	0.0000;
	1874	1	0	0	0	0	1	1.0792415	-8.2608025	110	3	1.12	0.95	101.4790	-0.4298	0.0000	0.0000;
	1875	1	0	0	0	0	1	1.0790522	-8.2724161	110	3	1.12	0.95	101.5049	-0.4234	0.0000	0.0000;
	1876	1	0	0	0	0	1	1.0605838	-10.037384	110	3	1.12	0.95	104.0918	1.7201	0.0000	0.0000;
	1877	2	27.305	20.984	0	0	1	1.087362	-7.4707448	110	3	1.12	0.95	100.2677	0.0136	0.0000	0.0000;
	1878	2	2	6.5	0	0	1	1.0729487	-8.0618592	110	3	1.12	0.95	100.9678	-0.2126	0.0000	0.0000;
	1879	1	6.912	1.335	0	0	1	1.096596	-5.4633567	110	3	1.12	0.95	99.9930	0.3421	0.0000	0.0000;
	1880	1	9.048	1.859	0	0	1	1.1076855	-4.3276822	110	3	1.12	0.95	98.8165	0.1015	0.0000	0.0000;
	1881	1	0	0	0	0	1	1.0966032	-5.4628649	110	3	1.12	0.95	99.9920	0.3419	0.0000	0.0000;
	1882	1	0	0	0	0	1	1.107695	-4.3270555	110	3	1.12	0.95	98.8153	0.1012	0.0000	0.0000;
	1883	1	12.479	1.069	0	0	1	1.0951163	-7.4880793	110	3	1.12	0.95	100.9020	-1.0037	0.0000	0.0000;
	1884	1	0	0	0	0	1	1.0951296	-7.4812108	110	3	1.12	0.95	100.9066	-1.0096	0.0000	0.0000;
	1885	2	17.256	2.377	0	0	1	1.1146387	-3.2731278	110	3	1.12	0.95	98.7919	0.0914	0.0000	0.0000;
	1886	1	13.207	1.277	0	0	1	1.1145067	-3.3007395	110	3	1.12	0.95	98.7995	0.0933	0.0000	0.0000;
	1887	1	8.667	4.104	0	0	1	1.0890587	-7.3827058	110	3	1.12	0.95	100.1426	0.0456	0.0000	0.0000;
	1888	1	14.602	4.477	0	0	1	1.0891561	-7.3745117	110	3	1.12	0.95	100.1384	0.0484	0.0000	0.0000;
	1889	1	20.158	5.475	0	0	1	1.0801512	-10.067055	110	3	1.12	0.95	102.6446	0.7960	0.0000	0.0000;
	1890	1	0	0	0	0	1	1.0802161	-10.04417	110	3	1.12	0.95	102.6413	0.7951	0.0000	0.0000;
	1891	1	11.412	2.032	0	0	1	1.0905666	-9.1213901	110	3	1.12	0.95	101.6974	0.4087	0.0000	0.0000;
	1892	1	0	0	0	0	1	1.0905184	-9.1110618	110	3	1.12	0.95	101.6993	0.4096	0.0000	0.0000;
	1893	1	7.856	2.541	0	0	1	1.0667943	-8.9020285	110	3	1.12	0.95	102.5511	-0.1703	0.0000	0.0000;
	1894	1	0	0	0	0	1	1.0935381	-5.5074044	110	3	1.12	0.95	101.5929	0.4332	0.0000	0.0000;
	1895	1	2.255	1.212	0	0	1	1.1019001	-6.4003497	110	3	1.12	0.95	99.7271	0.4435	0.0000	0.0000;
	1896	1	6.411	2.611	0	0	1	1.1017236	-6.4225409	110	3	1.12	0.95	99.7357	0.4464	0.0000	0.0000;
	1897	1	7.584	1.758	0	0	1	1.0883638	-8.9054667	110	3	1.12	0.95	101.7554	0.0693	0.0000	0.0000;
	1898	1	7.729	-0.576	0	0	1	1.0884373	-8.9173583	110	3	1.12	0.95	101.7543	0.0709	0.0000	0.0000;
	1899	1	4.642	0.668	0	0	1	1.0884736	-6.0073585	110	3	1.12	0.95	102.0943	0.6491	0.0000	0.0000;
	1900	1	2.018	0.326	0	0	1	1.0885429	-6.0074268	110	3	1.12	0.95	102.0920	0.6483	0.0000	0.0000;
	1901	1	7.597	2.369	0	0	1	1.0852975	-7.5473787	110	3	1.12	0.95	100.6243	-0.5881	0.0000	0.0000;
	1902	1	0	0	0	0	1	1.0853686	-7.5461897	110	3	1.12	0.95	100.6228	-0.5855	0.0000	0.0000;
	1903	1	1.423	0.372	0	0	1	1.1016691	-4.8006574	110	3	1.12	0.95	99.4986	0.2099	0.0000	0.0000;
	1904	1	0	0	0	0	1	1.1016852	-4.7992149	110	3	1.12	0.95	99.4971	0.2095	0.0000	0.0000;
	1905	1	8.547	2.611	0	0	1	1.0946463	-7.9391862	110	3	1.12	0.95	100.7333	0.5667	0.0000	0.0000;
	1906	1	7.36	1.865	0	0	1	1.094553	-7.9502296	110	3	1.12	0.95	100.7375	0.5681	0.0000	0.0000;
	1907	1	15.662	1.964	0	0	1	1.0838163	-8.8291184	110	3	1.12	0.95	102.1783	0.7872	0.0000	0.0000;
	1908	1	0	0	0	0	1	1.0838687	-8.8187375	110	3	1.12	0.95	102.1755	0.7868	0.0000	0.0000;
	1909	1	2.615	0.742	0	0	1	1.0850671	-7.534164	110	3	1.12	0.95	100.6159	-0.5943	0.0000	0.0000;
	1910	1	0	0	0	0	1	1.0850271	-7.5313687	110	3	1.12	0.95	100.6160	-0.5973	0.0000	0.0000;
	1911	2	18.391	0.923	0	0	1	1.0889933	-7.631	110	3	1.12	0.95	101.2220	0.7488	0.0000	0.0000;
	1912	2	17.799	-1.875	0	0	1	1.0889604	-7.632398	110	3	1.12	0.95	101.2256	0.7492	0.0000	0.0000;
	1913	1	0	0	0	0	1	1.0889953	-7.630325	110	3	1.12	0.95	101.2204	0.7495	0.0000	0.0000;
	1914	1	0	0	0	0	1	1.0889953	-7.630325	110	3	1.12	0.95	101.2204	0.7495	0.0000	0.0000;
	1915	1	4.753	0.626	0	0	1	1.0958067	-6.9319753	110	3	1.12	0.95	100.3011	0.6056	0.0000	0.0000;
	1916	1	4.159	0.144	0	0	1	1.1050653	-6.0564762	110	3	1.12	0.95	99.3144	0.2903	0.0000	0.0000;
	1917	1	0	0	0	0	1	1.0960662	-6.9021825	110	3	1.12	0.95	100.2650	0.6015	0.0000	0.0000;
	1918	1	14.732	4.234	0	0	1	1.0853227	-7.5097026	110	3	1.12	0.95	100.6096	-0.5923	0.0000	0.0000;
	1919	1	0	0	0	0	1	1.0852818	-7.5008271	110	3	1.12	0.95	100.6101	-0.5970	0.0000	0.0000;
	1920	1	16.561	5.682	0	0	1	1.0849795	-7.5545643	110	3	1.12	0.95	100.6540	-0.5731	0.0000	0.0000;
	1921	1	0	0	0	0	1	1.084957	-7.5531204	110	3	1.12	0.95	100.6536	-0.5751	0.0000	0.0000;
	1922	1	3.326	0.311	0	0	1	1.0817986	-9.1144402	110	3	1.12	0.95	102.0779	-0.3732	0.0000	0.0000;
	1923	1	0	0	0	0	1	1.081772	-9.1014908	110	3	1.12	0.95	102.0764	-0.3763	0.0000	0.0000;
	1924	1	3.206	1.166	0	0	1	1.0943699	-7.5915684	110	3	1.12	0.95	100.7954	-0.4747	0.0000	0.0000;
	1925	1	17.235	-0.163	0	0	1	1.0938239	-7.6627431	110	3	1.12	0.95	100.9065	-0.4821	0.0000	0.0000;
	1926	1	9.039	2.592	0	0	1	1.109276	-6.7295021	110	3	1.12	0.95	99.2164	0.2114	0.0000	0.0000;
	1927	1	6.657	1.914	0	0	1	1.1093792	-6.7123931	110	3	1.12	0.95	99.2095	0.2104	0.0000	0.0000;
	1928	1	0.593	0	0	0	1	1.1070305	-4.323181	110	3	1.12	0.95	98.9833	0.0795	0.0000	0.0000;
	1929	1	0	0	0	0	1	1.1069622	-4.3326391	110	3	1.12	0.95	98.9868	0.0803	0.0000	0.0000;
	1930	2	42.058	8.524	0	0	1	1.0725364	-10.012183	110	3	1.12	0.95	103.7196	1.0964	0.0000	0.0000;
	1931	1	0	0	0	0	1	1.0828281	-9.1076024	110	3	1.12	0.95	103.2208	0.7164	0.0000	0.0000;
	1932	2	7.86	6.44	0	0	1	1.117506	-9.4334661	110	4	1.12	0.95	100.7135	0.0000	0.0000	0.0000;
	1933	2	5.825	0.699	0	0	1	1.1115892	-10.632365	110	4	1.12	0.95	102.9825	-0.0000	0.0000	0.0000;
	1934	1	4.756	2	0	0	1	1.1092683	-10.721353	110	4	1.12	0.95	103.2284	0.1071	0.0000	0.0000;
	1935	1	5.129	2.5	0	0	1	1.1094724	-10.713201	110	4	1.12	0.95	103.2063	0.0979	0.0000	0.0000;
	1936	1	16.853	4.408	0	0	1	1.0931234	-25.706552	110	4	1.12	0.95	111.8001	0.1979	0.0000	0.0000;
	1937	1	4.649	0.758	0	0	1	1.0834867	-18.495746	110	4	1.12	0.95	108.2753	0.9942	0.0000	0.0000;
	1938	1	0	0	0	0	1	1.0919802	-27.636209	110	4	1.12	0.95	113.0494	1.0191	0.0000	0.0000;
	1939	1	8.921	0.4	0	0	1	1.070169	-25.083009	110	4	1.12	0.95	112.4590	2.4862	0.0000	0.0000;
	1940	1	0.284	0.101	0	0	1	1.0950687	-12.343361	110	4	1.12	0.95	105.2950	0.2762	0.0000	0.0000;
	1941	1	0	0.112	0	0	1	1.1024415	-15.586793	110	4	1.12	0.95	102.7586	0.9970	0.0000	0.0000;
	1942	1	10.42	0.487	0	0	1	1.10243	-15.590833	110	4	1.12	0.95	102.7602	0.9971	0.0000	0.0000;
	1943	1	26.48	6.562	0	0	1	1.0799393	-30.02214	110	4	1.12	0.95	117.3324	0.7387	0.0000	0.0000;
	1944	1	11.188	2.518	0	0	1	1.1083985	-14.811638	110	4	1.12	0.95	102.0140	0.5865	0.0000	0.0000;
	1945	1	19.549	6.064	0	0	1	1.0959982	-30.566013	110	4	1.12	0.95	115.1620	0.5937	0.0000	0.0000;
	1946	1	8.331	-0.386	0	0	1	1.0910221	-26.21445	110	4	1.12	0.95	112.1386	0.2796	0.0000	0.0000;
	1947	1	0	0	0	0	1	1.0909932	-26.227193	110	4	1.12	0.95	112.1409	0.2787	0.0000	0.0000;
	1948	1	9.918	5.936	0	0	1	1.0833581	-28.178685	110	4	1.12	0.95	114.7960	1.2847	0.0000	0.0000;
	1949	2	7.255	0.928	0	0	1	1.106609	-10.88041	110	4	1.12	0.95	100.6174	0.4124	0.0000	0.0000;
	1950	1	7.122	0.487	0	0	1	1.1066268	-10.890081	110	4	1.12	0.95	100.6155	0.4134	0.0000	0.0000;
	1951	1	11.86	2.844	0	0	1	1.1057224	-11.109245	110	4	1.12	0.95	100.7129	0.4795	0.0000	0.0000;
	1952	2	4.981	-4.966	0	0	1	1.1024925	-15.906038	110	4	1.12	0.95	103.0956	0.7771	0.0000	0.0000;
	1953	1	6.165	0.883	0	0	1	1.1024813	-15.908405	110	4	1.12	0.95	103.0966	0.7772	0.0000	0.0000;
	1954	1	25.184	3.759	0	0	1	1.0855634	-26.478793	110	4	1.12	0.95	112.5362	0.6100	0.0000	0.0000;
	1955	1	5.691	1.533	0	0	1	1.1016113	-15.658207	110	4	1.12	0.95	102.8592	1.0373	0.0000	0.0000;
	1956	1	4.742	-0.045	0	0	1	1.1000746	-15.911549	110	4	1.12	0.95	103.0122	1.0963	0.0000	0.0000;
	1957	1	8.805	2.665	0	0	1	1.048413	-26.850522	110	4	1.12	0.95	114.8668	2.7640	0.0000	0.0000;
	1958	1	8.062	1.424	0	0	1	1.0686174	-22.596065	110	4	1.12	0.95	109.5359	3.0567	0.0000	0.0000;
	1959	1	2.569	-1.055	0	0	1	1.0554309	-26.145627	110	4	1.12	0.95	114.4102	2.7540	0.0000	0.0000;
	1960	1	20.212	3.718	0	0	1	1.0717002	-21.384788	110	4	1.12	0.95	108.7267	2.9550	0.0000	0.0000;
	1961	1	1.138	0.041	0	0	1	1.0945578	-23.698677	110	4	1.12	0.95	109.4029	1.8253	0.0000	0.0000;
	1962	2	5.797	0.251	0	0	1	1.1178528	-9.0039498	110	4	1.12	0.95	98.9256	0.0548	0.0000	0.0000;
	1963	1	5.694	1.303	0	0	1	1.1074988	-14.919323	110	4	1.12	0.95	101.7332	0.9301	0.0000	0.0000;
	1964	1	0	0	0	0	1	1.11768	-27.334664	110	4	1.12	0.95	112.3803	0.0047	0.0000	0.0000;
	1965	1	5.681	0.3	0	0	1	1.0830992	-26.713163	110	4	1.12	0.95	112.8317	0.8749	0.0000	0.0000;
	1966	1	5.689	0.462	0	0	1	1.060671	-23.649416	110	4	1.12	0.95	111.6799	2.9683	0.0000	0.0000;
	1967	2	7.691	-0.979	0	0	1	1.0902847	-17.28308	110	4	1.12	0.95	105.7195	0.6339	0.0000	0.0000;
	1968	1	4.171	-2.297	0	0	1	1.090299	-17.284833	110	4	1.12	0.95	105.7201	0.6335	0.0000	0.0000;
	1969	2	5.792	2.836	0	0	1	1.1113027	-14.249029	110	4	1.12	0.95	101.2561	0.6418	0.0000	0.0000;
	1970	2	8.064	0.038	0	0	1	1.1075698	-14.788037	110	4	1.12	0.95	101.9103	0.5751	0.0000	0.0000;
	1971	1	3.423	-0.736	0	0	1	1.0960604	-12.695105	110	4	1.12	0.95	105.4265	0.3269	0.0000	0.0000;
	1972	1	20.924	3.511	0	0	1	1.0675372	-28.354339	110	4	1.12	0.95	114.7192	0.5021	0.0000	0.0000;
	1973	1	19.541	-0.845	0	0	1	1.0942951	-29.380573	110	4	1.12	0.95	115.6467	0.3546	0.0000	0.0000;
	1974	1	2.466	0.933	0	0	1	1.1110118	-16.566416	110	4	1.12	0.95	102.9675	1.4401	0.0000	0.0000;
	1975	1	21.255	0.589	0	0	1	1.0767878	-33.051861	110	4	1.12	0.95	120.2685	0.2679	0.0000	0.0000;
	1976	1	2.656	0.148	0	0	1	1.0933565	-22.172274	110	4	1.12	0.95	109.6502	0.8673	0.0000	0.0000;
	1977	1	8.538	1.455	0	0	1	1.1050183	-12.371624	110	4	1.12	0.95	101.1821	0.7343	0.0000	0.0000;
	1978	1	0.757	-2.2	0	0	1	1.0987824	-25.676681	110	4	1.12	0.95	111.4823	0.0323	0.0000	0.0000;
	1979	1	0	0	0	0	1	1.1099952	-14.688513	110	4	1.12	0.95	101.3794	0.8828	0.0000	0.0000;
	1980	1	0	0	0	0	1	1.1099952	-14.688513	110	4	1.12	0.95	101.3794	0.8828	0.0000	0.0000;
	1981	1	0	0	0	0	1	1.1132027	-16.455259	110	4	1.12	0.95	102.6821	1.3621	0.0000	0.0000;
	1982	1	0	0	0	0	1	1.1084903	-13.370362	110	4	1.12	0.95	101.5237	0.7554	0.0000	0.0000;
	1983	1	2.368	-0.75	0	0	1	1.1111105	-10.755263	110	4	1.12	0.95	100.2592	0.1529	0.0000	0.0000;
	1984	1	6.264	-0.445	0	0	1	1.073955	-31.699054	110	4	1.12	0.95	118.3265	0.8143	0.0000	0.0000;
	1985	1	18.84	3.435	0	0	1	1.0924498	-25.945259	110	4	1.12	0.95	111.9786	0.2904	0.0000	0.0000;
	1986	1	2.374	0.972	0	0	1	1.0880186	-26.024757	110	4	1.12	0.95	112.9772	1.2324	0.0000	0.0000;
	1987	1	9.664	-0.12	0	0	1	1.0953817	-25.520821	110	4	1.12	0.95	111.3610	0.2915	0.0000	0.0000;
	1988	1	2.752	0.6	0	0	1	1.0954172	-25.543396	110	4	1.12	0.95	111.3761	0.2863	0.0000	0.0000;
	1989	1	13.16	2.744	0	0	1	1.0623721	-29.559708	110	4	1.12	0.95	116.4297	0.8398	0.0000	0.0000;
	1990	1	14.909	3.435	0	0	1	1.0924479	-30.394637	110	4	1.12	0.95	115.7071	0.7479	0.0000	0.0000;
	1991	1	4.267	-0.316	0	0	1	1.0951237	-24.293699	110	4	1.12	0.95	109.8707	1.6864	0.0000	0.0000;
	1992	1	6.183	0.651	0	0	1	1.076971	-15.387201	110	4	1.12	0.95	108.4375	0.7033	0.0000	0.0000;
	1993	1	3.694	-0.809	0	0	1	1.0737275	-30.940201	110	4	1.12	0.95	117.6998	0.5768	0.0000	0.0000;
	1994	1	9.22	-0.99	0	0	1	1.0777036	-29.789701	110	4	1.12	0.95	117.4170	0.7000	0.0000	0.0000;
	1995	1	5.328	5.523	0	0	1	1.07557	-31.662873	110	4	1.12	0.95	118.0152	0.9602	0.0000	0.0000;
	1996	2	9.601	2.328	0	0	1	1.1178384	-27.307492	110	4	1.12	0.95	112.3703	0.0000	0.0000	0.0000;
	1997	1	0	0	0	0	1	1.1178384	-27.307492	110	4	1.12	0.95	112.3703	-0.0000	0.0000	0.0000;
	1998	1	3.032	-0.276	0	0	1	1.0794086	-29.556816	110	4	1.12	0.95	115.7138	0.7294	0.0000	0.0000;
	1999	1	8.647	-1.371	0	0	1	1.0794125	-29.560386	110	4	1.12	0.95	115.7153	0.7292	0.0000	0.0000;
	2000	1	10.888	-0.919	0	0	1	1.0752375	-30.053999	110	4	1.12	0.95	116.4880	0.6598	0.0000	0.0000;
	2001	1	3.798	-0.686	0	0	1	1.0865799	-17.866848	110	4	1.12	0.95	106.6623	0.5542	0.0000	0.0000;
	2002	2	0.078	0.362	0	0	1	1.0996721	-23.702519	110	4	1.12	0.95	109.7231	1.2469	0.0000	0.0000;
	2003	1	0	0	0	0	1	1.0996721	-23.702519	110	4	1.12	0.95	109.7231	1.2469	0.0000	0.0000;
	2004	1	8.352	0.325	0	0	1	1.0955713	-16.586166	110	4	1.12	0.95	103.8453	1.0607	0.0000	0.0000;
	2005	1	9.115	1.231	0	0	1	1.1016841	-15.946542	110	4	1.12	0.95	103.1603	0.8008	0.0000	0.0000;
	2006	2	12.476	2.595	0	0	1	1.0985647	-25.575345	110	4	1.12	0.95	111.4765	0.0000	0.0000	0.0000;
	2007	2	10.581	9.121	0	0	1	1.0992681	-25.697731	110	4	1.12	0.95	111.4979	0.0000	0.0000	0.0000;
	2008	1	7.113	2.028	0	0	1	1.082122	-26.138559	110	4	1.12	0.95	112.6073	0.6683	0.0000	0.0000;
	2009	1	2.557	1.196	0	0	1	1.0758253	-33.73563	110	4	1.12	0.95	118.7814	1.0384	0.0000	0.0000;
	2010	1	17.457	5	0	0	1	1.0894772	-25.660132	110	4	1.12	0.95	111.6302	0.6987	0.0000	0.0000;
	2011	1	11.008	3.8	0	0	1	1.0786191	-26.631602	110	4	1.12	0.95	113.3718	0.6940	0.0000	0.0000;
	2012	2	8.984	2.246	0	0	1	1.0524248	-35.886326	110	4	1.12	0.95	123.6485	1.4787	0.0000	0.0000;
	2013	1	0.852	0.4	0	0	1	1.0968398	-30.487806	110	4	1.12	0.95	114.8963	0.5948	0.0000	0.0000;
	2014	1	0.947	0.4	0	0	1	1.0967238	-30.508725	110	4	1.12	0.95	114.9068	0.5968	0.0000	0.0000;
	2015	1	15.623	2.419	0	0	1	1.0801241	-25.554715	110	4	1.12	0.95	112.2709	0.8472	0.0000	0.0000;
	2016	2	21.219	4.747	0	0	1	1.078015	-26.119229	110	4	1.12	0.95	112.8195	0.8260	0.0000	0.0000;
	2017	1	8.24	1.942	0	0	1	1.0780628	-26.131907	110	4	1.12	0.95	112.8209	0.8250	0.0000	0.0000;
	2018	2	10.012	0.2	0	0	1	1.0624984	-24.288763	110	4	1.12	0.95	112.1405	2.4959	0.0000	0.0000;
	2019	2	0	10.2	0	0	1	1.1003395	-25.766481	110	4	1.12	0.95	110.8259	1.0071	0.0000	0.0000;
	2020	2	0.284	-0.6	0	0	1	1.0955899	-26.832872	110	4	1.12	0.95	111.8641	1.0311	0.0000	0.0000;
	2021	1	16.338	3.513	0	0	1	1.0610272	-32.667952	110	4	1.12	0.95	121.4065	1.7289	0.0000	0.0000;
	2022	1	6.073	0.394	0	0	1	1.0947847	-26.760946	110	4	1.12	0.95	111.8759	1.0963	0.0000	0.0000;
	2023	1	7.214	0.955	0	0	1	1.0947522	-26.756073	110	4	1.12	0.95	111.8784	1.0960	0.0000	0.0000;
	2024	1	6.661	1.399	0	0	1	1.0884414	-18.019698	110	4	1.12	0.95	104.5887	1.6461	0.0000	0.0000;
	2025	1	14.865	0.789	0	0	1	1.0762407	-27.596549	110	4	1.12	0.95	113.9804	1.1216	0.0000	0.0000;
	2026	1	2.561	1.248	0	0	1	1.1103622	-16.609709	110	4	1.12	0.95	103.0219	1.4615	0.0000	0.0000;
	2027	1	11.389	4.674	0	0	1	1.1110683	-28.038548	110	4	1.12	0.95	113.1598	0.2230	0.0000	0.0000;
	2028	1	5.694	-0.826	0	0	1	1.0969594	-16.551298	110	4	1.12	0.95	104.0955	0.9041	0.0000	0.0000;
	2029	1	6.169	-0.534	0	0	1	1.0969588	-16.553747	110	4	1.12	0.95	104.0964	0.9040	0.0000	0.0000;
	2030	1	15.429	2.487	0	0	1	1.095465	-26.627544	110	4	1.12	0.95	111.6846	1.1063	0.0000	0.0000;
	2031	1	7.873	1.481	0	0	1	1.096516	-26.515802	110	4	1.12	0.95	111.4729	1.0941	0.0000	0.0000;
	2032	2	29.61	6.932	0	0	1	1.0562655	-24.04585	110	4	1.12	0.95	112.0992	2.5517	0.0000	0.0000;
	2033	1	8.452	-0.115	0	0	1	1.0824585	-24.579635	110	4	1.12	0.95	111.7627	1.9731	0.0000	0.0000;
	2034	1	18.343	3.672	0	0	1	1.0928465	-30.806812	110	4	1.12	0.95	115.6264	0.6901	0.0000	0.0000;
	2035	1	4.278	3.233	0	0	1	1.0950508	-26.810184	110	4	1.12	0.95	111.8893	1.0715	0.0000	0.0000;
	2036	1	5.401	0.303	0	0	1	1.0754587	-29.61071	110	4	1.12	0.95	117.4491	0.8936	0.0000	0.0000;
	2037	1	3.515	1.159	0	0	1	1.0935469	-19.03273	110	4	1.12	0.95	105.1720	2.1089	0.0000	0.0000;
	2038	1	0.5	0.14	0	0	1	1.0934997	-19.051293	110	4	1.12	0.95	105.1754	2.1127	0.0000	0.0000;
	2039	1	12.024	-1.252	0	0	1	1.0511419	-26.448089	110	4	1.12	0.95	115.7450	2.3434	0.0000	0.0000;
	2040	2	9.375	-3.464	0	0	1	1.0747783	-21.279473	110	4	1.12	0.95	108.4013	2.7646	0.0000	0.0000;
	2041	1	1.535	-0.673	0	0	1	1.0701397	-22.485322	110	4	1.12	0.95	109.2985	3.0144	0.0000	0.0000;
	2042	1	46.543	23.756	0	0	1	1.0646311	-22.76724	110	4	1.12	0.95	109.7739	3.2668	0.0000	0.0000;
	2043	1	7.58	4.259	0	0	1	1.0729649	-21.652765	110	4	1.12	0.95	108.7378	2.8103	0.0000	0.0000;
	2044	2	8.971	-2.022	0	0	1	1.0911938	-16.554068	110	4	1.12	0.95	104.7777	1.2737	0.0000	0.0000;
	2045	1	0.921	0.168	0	0	1	1.0909663	-16.542604	110	4	1.12	0.95	104.7823	1.2881	0.0000	0.0000;
	2046	2	7.84	4.922	0	0	1	1.106318	-13.43992	110	4	1.12	0.95	104.4976	0.0767	0.0000	0.0000;
	2047	1	87.168	57	0	0	1	1.1058267	-13.471452	110	4	1.12	0.95	104.5100	0.0848	0.0000	0.0000;
	2048	1	7.016	3.025	0	0	1	1.1166253	-13.620145	110	4	1.12	0.95	100.2923	0.1568	0.0000	0.0000;
	2049	1	1.028	0.616	0	0	1	1.1157899	-14.50985	110	4	1.12	0.95	101.3307	0.2162	0.0000	0.0000;
	2050	1	7.101	3.015	0	0	1	1.0746415	-25.730424	110	4	1.12	0.95	112.9463	1.1573	0.0000	0.0000;
	2051	2	13.22	1	0	0	1	1.0989139	-15.992728	110	4	1.12	0.95	103.1438	1.0648	0.0000	0.0000;
	2052	1	3.412	1.184	0	0	1	1.0989024	-15.994019	110	4	1.12	0.95	103.1444	1.0650	0.0000	0.0000;
	2053	1	11.874	2.74	0	0	1	1.0534101	-25.834217	110	4	1.12	0.95	114.1800	2.9569	0.0000	0.0000;
	2054	1	11.574	-0.694	0	0	1	1.1000205	-25.870847	110	4	1.12	0.95	110.9117	1.0166	0.0000	0.0000;
	2055	1	0.332	0.199	0	0	1	1.101912	-15.247395	110	4	1.12	0.95	102.6420	0.8256	0.0000	0.0000;
	2056	1	12.809	2.872	0	0	1	1.1061117	-15.123097	110	4	1.12	0.95	101.9272	0.9761	0.0000	0.0000;
	2057	1	16.947	4.251	0	0	1	1.0871556	-26.099001	110	4	1.12	0.95	112.0477	0.6790	0.0000	0.0000;
	2058	1	11.518	-1.621	0	0	1	1.1189682	-19.323367	110	4	1.12	0.95	105.9590	-0.0400	0.0000	0.0000;
	2059	2	21.243	2.846	0	0	1	1.0755883	-20.12947	110	4	1.12	0.95	108.5091	1.7356	0.0000	0.0000;
	2060	1	8.166	-0.003	0	0	1	1.0769601	-20.166943	110	4	1.12	0.95	108.4828	1.6787	0.0000	0.0000;
	2061	2	2.215	-1.357	0	0	1	1.0640505	-29.41339	110	4	1.12	0.95	116.5388	-0.0720	0.0000	0.0000;
	2062	1	3.698	1.8	0	0	1	1.1106412	-10.05556	110	4	1.12	0.95	101.6877	0.1771	0.0000	0.0000;
	2063	2	15.973	2.583	0	0	1	1.0868224	-16.7704	110	4	1.12	0.95	105.3639	1.3740	0.0000	0.0000;
	2064	1	4.267	0.241	0	0	1	1.1078529	-14.958396	110	4	1.12	0.95	101.6736	0.9330	0.0000	0.0000;
	2065	1	3.798	0.226	0	0	1	1.1092359	-14.748562	110	4	1.12	0.95	101.4634	0.9012	0.0000	0.0000;
	2066	1	16.334	1.659	0	0	1	1.0800638	-14.889222	110	4	1.12	0.95	108.0190	0.6142	0.0000	0.0000;
	2067	2	10.158	1.514	0	0	1	1.099974	-15.700864	110	4	1.12	0.95	102.9785	1.1007	0.0000	0.0000;
	2068	2	18.829	1.539	0	0	1	1.0818007	-14.630975	110	4	1.12	0.95	107.7622	0.5763	0.0000	0.0000;
	2069	1	11.85	4.495	0	0	1	1.0923999	-17.661711	110	4	1.12	0.95	104.0062	1.6987	0.0000	0.0000;
	2070	1	13.753	2.154	0	0	1	1.0774753	-15.338693	110	4	1.12	0.95	108.3764	0.6902	0.0000	0.0000;
	2071	1	23.341	5.619	0	0	1	1.1174358	-19.326687	110	4	1.12	0.95	106.0370	0.0822	0.0000	0.0000;
	2072	2	17.492	0.297	0	0	1	1.070335	-25.867446	110	4	1.12	0.95	113.2874	1.4011	0.0000	0.0000;
	2073	1	2.368	1.11	0	0	1	1.105995	-21.069485	110	4	1.12	0.95	107.6778	0.4206	0.0000	0.0000;
	2074	1	17.065	5.1	0	0	1	1.1098622	-13.059444	110	4	1.12	0.95	104.1822	0.3937	0.0000	0.0000;
	2075	2	17.757	-0.955	0	0	1	1.0885516	-17.52145	110	4	1.12	0.95	106.0108	0.6973	0.0000	0.0000;
	2076	1	3.436	1.4	0	0	1	1.0885495	-17.523772	110	4	1.12	0.95	106.0141	0.6967	0.0000	0.0000;
	2077	1	29.161	10.604	0	0	1	1.0799358	-27.057631	110	4	1.12	0.95	113.3422	0.7123	0.0000	0.0000;
	2078	1	21.839	5.31	0	0	1	1.0808424	-18.342971	110	4	1.12	0.95	105.4219	1.7337	0.0000	0.0000;
	2079	1	12.763	4.6	0	0	1	1.0661988	-8.4329019	110	4	1.12	0.95	105.3447	0.7286	0.0000	0.0000;
	2080	1	8.162	-0.402	0	0	1	1.051761	-25.381794	110	4	1.12	0.95	114.4285	2.7888	0.0000	0.0000;
	2081	1	0	0	0	0	1	1.1125574	-13.79169	110	4	1.12	0.95	100.8241	0.3767	0.0000	0.0000;
	2082	1	0	0	0	0	1	1.1103134	-14.673676	110	4	1.12	0.95	101.7534	0.5274	0.0000	0.0000;
	2083	2	26.49	7.157	0	0	1	1.0612661	-22.461537	110	4	1.12	0.95	109.5234	3.5225	0.0000	0.0000;
	2084	1	2.21	1.457	0	0	1	1.0668064	-21.055393	110	4	1.12	0.95	108.3123	3.2882	0.0000	0.0000;
	2085	1	3.62	2.69	0	0	1	1.0666193	-22.151161	110	4	1.12	0.95	109.2135	3.2744	0.0000	0.0000;
	2086	1	5.495	3.75	0	0	1	1.0851517	-18.903768	110	4	1.12	0.95	105.7685	2.6048	0.0000	0.0000;
	2087	1	7.108	0.005	0	0	1	1.0915913	-12.823842	110	4	1.12	0.95	105.8082	0.2898	0.0000	0.0000;
	2088	1	5.689	2.642	0	0	1	1.0716282	-21.770389	110	4	1.12	0.95	108.5765	3.0980	0.0000	0.0000;
	2089	1	0.675	0.56	0	0	1	1.0627319	-22.384971	110	4	1.12	0.95	109.3839	3.4540	0.0000	0.0000;
	2090	1	5.789	1.927	0	0	1	1.0738663	-19.985561	110	4	1.12	0.95	108.3716	1.8676	0.0000	0.0000;
	2091	1	7.693	0.718	0	0	1	1.0642796	-34.902701	110	4	1.12	0.95	121.1009	1.2924	0.0000	0.0000;
	2092	1	11.949	2.895	0	0	1	1.0980552	-23.56983	110	4	1.12	0.95	109.6119	1.4369	0.0000	0.0000;
	2093	1	1.419	1.2	0	0	1	1.1100727	-13.042486	110	4	1.12	0.95	104.1624	0.3879	0.0000	0.0000;
	2094	1	10.242	3.112	0	0	1	1.098731	-11.826418	110	4	1.12	0.95	104.6945	0.2672	0.0000	0.0000;
	2095	2	0	0.8	0	0	1	1.1066497	-13.425393	110	4	1.12	0.95	104.4718	0.0789	0.0000	0.0000;
	2096	2	0.097	-3.027	0	0	1	1.1164225	-19.499666	110	4	1.12	0.95	105.8053	0.2527	0.0000	0.0000;
	2097	1	0	0	0	0	1	1.1054934	-13.440719	110	4	1.12	0.95	104.5185	0.0868	0.0000	0.0000;
	2098	2	3.567	2.768	0	0	1	1.0540233	-11.988415	15	4	1.12	0.95	104.8266	0.0850	0.0000	0.0000;
	2099	1	3.329	1.754	0	0	1	1.0767668	-19.675295	110	4	1.12	0.95	107.8822	1.8390	0.0000	0.0000;
	2100	1	14.282	4.799	0	0	1	1.1016839	-15.299977	110	4	1.12	0.95	102.6132	1.0926	0.0000	0.0000;
	2101	2	32.858	21.719	0	0	1	1.0659227	-21.05878	110	4	1.12	0.95	108.3903	3.3653	0.0000	0.0000;
	2102	1	3.376	3.587	0	0	1	1.0672527	-21.029181	110	4	1.12	0.95	108.2691	3.2716	0.0000	0.0000;
	2103	1	0.339	0.281	0	0	1	1.0725814	-21.732951	110	4	1.12	0.95	108.4622	3.0473	0.0000	0.0000;
	2104	1	2.762	2.578	0	0	1	1.0719651	-21.775385	110	4	1.12	0.95	108.5181	3.0726	0.0000	0.0000;
	2105	1	7.303	-0.941	0	0	1	1.0926394	-12.718942	110	4	1.12	0.95	105.7022	0.2713	0.0000	0.0000;
	2106	1	7.774	6.361	0	0	1	1.0689154	-22.019575	110	4	1.12	0.95	108.8535	3.1925	0.0000	0.0000;
	2107	1	0.123	0.225	0	0	1	1.0689137	-22.026446	110	4	1.12	0.95	108.8560	3.1929	0.0000	0.0000;
	2108	1	0	0	0	0	1	1.1165703	-27.180232	110	4	1.12	0.95	112.3177	0.0299	0.0000	0.0000;
	2109	1	1.42	1.416	0	0	1	1.0744201	-20.030463	110	4	1.12	0.95	107.1023	3.0411	0.0000	0.0000;
	2110	1	10.721	7.14	0	0	1	1.1036056	-11.603979	110	4	1.12	0.95	100.9645	0.6319	0.0000	0.0000;
	2111	1	0	0	0	0	1	1.1036111	-11.592648	110	4	1.12	0.95	100.9672	0.6291	0.0000	0.0000;
	2112	1	55.997	50.192	0	0	1	1.0648968	-21.008738	110	4	1.12	0.95	108.3051	3.4279	0.0000	0.0000;
	2113	1	8.899	7.006	0	0	1	1.0719647	-21.753233	110	4	1.12	0.95	108.5053	3.0810	0.0000	0.0000;
	2114	1	8.339	4.531	0	0	1	1.0678758	-20.790094	110	4	1.12	0.95	107.9534	3.2919	0.0000	0.0000;
	2115	1	9.49	6.446	0	0	1	1.07101	-21.800263	110	4	1.12	0.95	108.5738	3.1219	0.0000	0.0000;
	2116	1	0.906	0.56	0	0	1	1.1079502	-13.441582	110	4	1.12	0.95	101.6023	0.7626	0.0000	0.0000;
	2117	1	9.97	7.05	0	0	1	1.068933	-20.648141	110	4	1.12	0.95	107.8367	3.2510	0.0000	0.0000;
	2118	1	0	0	0	0	1	1.0689218	-20.667636	110	4	1.12	0.95	107.8432	3.2524	0.0000	0.0000;
	2119	1	13.942	17.07	0	0	1	1.0660383	-20.983294	110	4	1.12	0.95	108.2743	3.3397	0.0000	0.0000;
	2120	1	3.346	1.737	0	0	1	1.0723667	-21.74582	110	4	1.12	0.95	108.4797	3.0556	0.0000	0.0000;
	2121	1	2.367	1.9	0	0	1	1.0689281	-22.365021	110	4	1.12	0.95	109.2020	3.1177	0.0000	0.0000;
	2122	1	6.846	2.8	0	0	1	1.1007009	-11.034149	110	4	1.12	0.95	103.2238	0.3918	0.0000	0.0000;
	2123	2	34.043	-2.331	0	0	1	1.0727187	-30.11916	110	4	1.12	0.95	118.4282	0.7136	0.0000	0.0000;
	2124	1	6.449	7.791	0	0	1	1.0668394	-21.657467	110	4	1.12	0.95	108.7411	3.2587	0.0000	0.0000;
	2125	1	0.184	0.281	0	0	1	1.0669532	-21.671827	110	4	1.12	0.95	108.7404	3.2585	0.0000	0.0000;
	2126	1	7.876	3.844	0	0	1	1.0682458	-22.210379	110	4	1.12	0.95	109.0563	3.1935	0.0000	0.0000;
	2127	1	1.565	0.897	0	0	1	1.067131	-21.047906	110	4	1.12	0.95	108.2827	3.2678	0.0000	0.0000;
	2128	2	14.491	1.765	0	0	1	1.0706513	-20.242061	110	4	1.12	0.95	108.5462	2.0910	0.0000	0.0000;
	2129	1	4.743	0.374	0	0	1	1.0736355	-19.680662	110	4	1.12	0.95	108.0119	1.9713	0.0000	0.0000;
	2130	1	19.219	3.866	0	0	1	1.0854751	-26.361468	110	4	1.12	0.95	112.3820	0.6763	0.0000	0.0000;
	2131	1	14.435	3.253	0	0	1	1.0738264	-19.645836	110	4	1.12	0.95	107.9419	1.9861	0.0000	0.0000;
	2132	1	0.662	-0.636	0	0	1	1.0856537	-17.996035	110	4	1.12	0.95	106.9115	0.5185	0.0000	0.0000;
	2133	1	4.749	0.106	0	0	1	1.0856493	-17.997939	110	4	1.12	0.95	106.9122	0.5186	0.0000	0.0000;
	2134	1	5.217	4.682	0	0	1	1.1052948	-13.481251	110	4	1.12	0.95	101.6825	0.8875	0.0000	0.0000;
	2135	1	0.491	0.225	0	0	1	1.0652096	-22.235195	110	4	1.12	0.95	109.4346	3.3237	0.0000	0.0000;
	2136	2	12.667	2.6	0	0	1	1.0782641	-17.339057	110	4	1.12	0.95	106.8408	1.6112	0.0000	0.0000;
	2137	1	1.875	0.754	0	0	1	1.1118887	-13.826885	110	4	1.12	0.95	100.9132	0.3972	0.0000	0.0000;
	2138	1	6.361	2.151	0	0	1	1.0970277	-12.029209	110	4	1.12	0.95	104.9452	0.2861	0.0000	0.0000;
	2139	1	3.506	-0.339	0	0	1	1.1006665	-15.951263	110	4	1.12	0.95	103.1541	0.8635	0.0000	0.0000;
	2140	1	4.742	-0.453	0	0	1	1.1006663	-15.953134	110	4	1.12	0.95	103.1549	0.8635	0.0000	0.0000;
	2141	1	6.256	0.278	0	0	1	1.0729811	-31.512286	110	4	1.12	0.95	118.3072	0.6950	0.0000	0.0000;
	2142	1	13.669	3.692	0	0	1	1.0762497	-15.449352	110	4	1.12	0.95	108.5164	0.7244	0.0000	0.0000;
	2143	1	1.903	2.634	0	0	1	1.0932008	-17.57819	110	4	1.12	0.95	103.8740	1.6861	0.0000	0.0000;
	2144	1	2.084	0.221	0	0	1	1.0964738	-30.534185	110	4	1.12	0.95	114.9891	0.5957	0.0000	0.0000;
	2145	2	15.037	1.813	0	0	1	1.1094543	-10.806008	110	4	1.12	0.95	100.4634	0.2841	0.0000	0.0000;
	2146	1	3.324	1.255	0	0	1	1.0994043	-15.744292	110	4	1.12	0.95	103.0314	1.1179	0.0000	0.0000;
	2147	1	8.147	2.654	0	0	1	1.0902349	-16.249767	110	4	1.12	0.95	106.8411	0.7160	0.0000	0.0000;
	2148	1	6.166	0.625	0	0	1	1.0906491	-16.849533	110	4	1.12	0.95	105.3703	0.6996	0.0000	0.0000;
	2149	1	5.215	0.59	0	0	1	1.0906407	-16.851586	110	4	1.12	0.95	105.3711	0.6997	0.0000	0.0000;
	2150	1	27.079	2.284	0	0	1	1.0647998	-24.900942	110	4	1.12	0.95	112.2703	2.2593	0.0000	0.0000;
	2151	1	8.071	1.849	0	0	1	1.0647792	-24.904235	110	4	1.12	0.95	112.2719	2.2596	0.0000	0.0000;
	2152	1	18.984	3.988	0	0	1	1.0926718	-15.868457	110	4	1.12	0.95	103.8626	1.3321	0.0000	0.0000;
	2153	1	3.376	-0.281	0	0	1	1.0956049	-16.274976	110	4	1.12	0.95	104.2294	1.0044	0.0000	0.0000;
	2154	1	15.651	2.455	0	0	1	1.0932533	-15.984373	110	4	1.12	0.95	103.8985	1.3417	0.0000	0.0000;
	2155	1	15.658	4.66	0	0	1	1.0912925	-16.218386	110	4	1.12	0.95	104.3565	1.3652	0.0000	0.0000;
	2156	1	16.3	1.222	0	0	1	1.061684	-25.280717	110	4	1.12	0.95	112.7669	2.3505	0.0000	0.0000;
	2157	1	5.561	1.111	0	0	1	1.0938134	-30.150917	110	4	1.12	0.95	115.4256	0.6252	0.0000	0.0000;
	2158	1	0	0	0	0	1	1.0978071	-22.784828	110	4	1.12	0.95	108.4092	1.9222	0.0000	0.0000;
	2159	1	0	0	0	0	1	1.093764	-22.912666	110	4	1.12	0.95	108.7809	2.0064	0.0000	0.0000;
	2160	1	0.473	-0.4	0	0	1	1.0828531	-26.374013	110	4	1.12	0.95	112.7105	0.5603	0.0000	0.0000;
	2161	1	2.469	0.163	0	0	1	1.0838243	-20.145699	110	4	1.12	0.95	108.0860	1.3701	0.0000	0.0000;
	2162	1	4.452	0.44	0	0	1	1.0893208	-27.999289	110	4	1.12	0.95	113.7969	0.9867	0.0000	0.0000;
	2163	1	4.355	0.595	0	0	1	1.0982574	-25.60282	110	4	1.12	0.95	110.8447	1.1595	0.0000	0.0000;
	2164	1	12.341	-0.906	0	0	1	1.098292	-23.254717	110	4	1.12	0.95	109.1280	1.4706	0.0000	0.0000;
	2165	1	7.6	2.524	0	0	1	1.1043815	-11.393365	110	4	1.12	0.95	100.9305	0.5295	0.0000	0.0000;
	2166	1	6.164	0.324	0	0	1	1.1008431	-15.641507	110	4	1.12	0.95	102.8704	1.0686	0.0000	0.0000;
	2167	1	4.084	-0.003	0	0	1	1.0860802	-32.664354	110	4	1.12	0.95	117.0154	0.7243	0.0000	0.0000;
	2168	1	0	0.144	0	0	1	1.0994466	-16.004745	110	4	1.12	0.95	103.4081	0.9796	0.0000	0.0000;
	2169	1	6.532	4.276	0	0	1	1.0606622	-26.254807	110	4	1.12	0.95	114.9106	1.9078	0.0000	0.0000;
	2170	1	8.166	2.948	0	0	1	1.0953225	-30.617294	110	4	1.12	0.95	115.0852	0.6412	0.0000	0.0000;
	2171	1	0.473	0.256	0	0	1	1.0486305	-33.761628	110	4	1.12	0.95	124.2436	1.9030	0.0000	0.0000;
	2172	1	5.143	0.535	0	0	1	1.074159	-28.589099	110	4	1.12	0.95	115.6518	0.8421	0.0000	0.0000;
	2173	1	11.768	1.305	0	0	1	1.0832714	-27.975652	110	4	1.12	0.95	113.9362	0.9547	0.0000	0.0000;
	2174	1	3.036	1.164	0	0	1	1.10229	-15.482814	110	4	1.12	0.95	102.5900	1.0510	0.0000	0.0000;
	2175	1	3.789	0.221	0	0	1	1.12	-9.815599	110	4	1.12	0.95	99.1819	-0.0797	580.3170	0.0000;
	2176	1	2.844	1.177	0	0	1	1.119024	-8.8385833	110	4	1.12	0.95	98.7011	0.0613	0.0000	0.0000;
	2177	1	6.155	0.193	0	0	1	1.0540931	-30.435207	110	4	1.12	0.95	118.5258	0.0670	0.0000	0.0000;
	2178	1	1.93	0.645	0	0	1	1.1092429	-26.572136	110	4	1.12	0.95	112.3749	-1.0495	0.0000	0.0000;
	2179	1	13.946	3.815	0	0	1	1.0835776	-17.859267	110	4	1.12	0.95	105.7093	1.7948	0.0000	0.0000;
	2180	2	11.531	2.786	0	0	1	1.1019483	-15.245853	110	4	1.12	0.95	102.6377	0.8240	0.0000	0.0000;
	2181	2	10.358	2.729	0	0	1	1.0954107	-29.962412	110	4	1.12	0.95	115.1787	0.5950	0.0000	0.0000;
	2182	1	10.416	3.005	0	0	1	1.0954578	-31.080455	110	4	1.12	0.95	115.5940	0.4824	0.0000	0.0000;
	2183	1	14.012	-0.254	0	0	1	1.0789121	-25.570469	110	4	1.12	0.95	112.5192	0.9323	0.0000	0.0000;
	2184	1	3.175	-0.486	0	0	1	1.0833942	-28.442266	110	4	1.12	0.95	115.0787	1.1935	0.0000	0.0000;
	2185	1	6.759	-0.531	0	0	1	1.0860902	-27.959408	110	4	1.12	0.95	114.3280	1.1525	0.0000	0.0000;
	2186	1	4.833	-0.651	0	0	1	1.0690432	-34.623191	110	4	1.12	0.95	120.0344	1.2176	0.0000	0.0000;
	2187	1	11.361	5.977	0	0	1	1.0984339	-25.74278	110	4	1.12	0.95	111.5592	0.0320	0.0000	0.0000;
	2188	1	5.587	1.4	0	0	1	1.0932315	-25.895384	110	4	1.12	0.95	111.9414	0.2475	0.0000	0.0000;
	2189	1	10.604	3.39	0	0	1	1.0838997	-26.387018	110	4	1.12	0.95	112.8254	0.4468	0.0000	0.0000;
	2190	1	14.012	4.081	0	0	1	1.0959293	-25.855272	110	4	1.12	0.95	111.7411	0.1417	0.0000	0.0000;
	2191	1	8.73	2.017	0	0	1	1.1108881	-19.717611	110	4	1.12	0.95	106.2320	0.3958	0.0000	0.0000;
	2192	1	8.805	-0.1	0	0	1	1.0796757	-25.897828	110	4	1.12	0.95	112.9770	0.8324	0.0000	0.0000;
	2193	1	4.702	0.112	0	0	1	1.0970096	-22.980363	110	4	1.12	0.95	108.6425	1.9039	0.0000	0.0000;
	2194	1	2.844	1.375	0	0	1	1.0499114	-36.25813	110	4	1.12	0.95	124.1684	1.5103	0.0000	0.0000;
	2195	1	12.46	2.263	0	0	1	1.0948157	-30.691645	110	4	1.12	0.95	115.2475	0.6333	0.0000	0.0000;
	2196	1	18.794	-0.086	0	0	1	1.0523981	-24.797673	110	4	1.12	0.95	113.9673	2.8157	0.0000	0.0000;
	2197	1	12.818	0.711	0	0	1	1.0734582	-27.651884	110	4	1.12	0.95	114.2730	1.4342	0.0000	0.0000;
	2198	1	12.432	-2.516	0	0	1	1.0516204	-25.041685	110	4	1.12	0.95	114.3093	2.7617	0.0000	0.0000;
	2199	1	15.114	3.468	0	0	1	1.1057864	-12.990737	110	4	1.12	0.95	104.1509	0.1589	0.0000	0.0000;
	2200	1	19.004	2.324	0	0	1	1.0797805	-33.247332	110	4	1.12	0.95	118.1352	0.8863	0.0000	0.0000;
	2201	1	9.865	3.656	0	0	1	1.0946512	-16.775735	110	4	1.12	0.95	104.3062	0.9649	0.0000	0.0000;
	2202	1	8.549	-0.016	0	0	1	1.0946449	-16.779114	110	4	1.12	0.95	104.3075	0.9649	0.0000	0.0000;
	2203	1	13.065	-1.061	0	0	1	1.0794983	-27.264683	110	4	1.12	0.95	114.1731	0.3295	0.0000	0.0000;
	2204	1	9.296	2.58	0	0	1	1.1066399	-13.906133	110	4	1.12	0.95	101.4572	0.7339	0.0000	0.0000;
	2205	1	15.835	2.884	0	0	1	1.0944528	-17.376854	110	4	1.12	0.95	103.8356	1.4839	0.0000	0.0000;
	2206	2	4.763	-0.971	0	0	1	1.0642407	-29.516893	110	4	1.12	0.95	116.6500	-0.1173	0.0000	0.0000;
	2207	2	19.289	7.201	0	0	1	1.0868114	-5.8179983	110	4	1.12	0.95	102.7774	0.7300	0.0000	0.0000;
	2208	1	23.707	6.117	0	0	1	1.0972332	-15.924856	110	4	1.12	0.95	103.2668	1.1432	0.0000	0.0000;
	2209	2	15.002	-0.044	0	0	1	1.0786748	-27.310712	110	4	1.12	0.95	113.6043	1.0182	0.0000	0.0000;
	2210	1	11.852	2.212	0	0	1	1.0983126	-17.268532	110	4	1.12	0.95	103.3983	1.4911	0.0000	0.0000;
	2211	1	20.076	-0.284	0	0	1	1.0929907	-17.803748	110	4	1.12	0.95	104.4097	1.5054	0.0000	0.0000;
	2212	2	22.276	3.459	0	0	1	1.0959352	-17.520022	110	4	1.12	0.95	103.8134	1.5157	0.0000	0.0000;
	2213	1	0	0	0	0	1	1.0990967	-17.199401	110	4	1.12	0.95	103.2893	1.4723	0.0000	0.0000;
	2214	1	0	0	0	0	1	1.0988634	-17.234914	110	4	1.12	0.95	103.3176	1.4762	0.0000	0.0000;
	2215	1	11.765	2.525	0	0	1	1.0832547	-18.340757	110	4	1.12	0.95	105.1907	1.7221	0.0000	0.0000;
	2216	1	0	0	0	0	1	1.1112899	-13.493179	110	4	1.12	0.95	100.8331	0.6343	0.0000	0.0000;
	2217	1	0	0	0	0	1	1.1134727	-14.325029	110	4	1.12	0.95	101.0485	0.7339	0.0000	0.0000;
	2218	2	7.852	2.297	0	0	1	1.12	-12.577558	110	4	1.12	0.95	102.9725	0.0000	793.3383	0.0000;
	2219	2	8.29	0.99	0	0	1	1.12	-19.18704	110	4	1.12	0.95	105.6935	0.0000	724.9255	0.0000;
	2220	1	6.633	0.437	0	0	1	1.0910886	-16.546195	110	4	1.12	0.95	104.7701	1.2899	0.0000	0.0000;
	2221	1	3.467	0.841	0	0	1	1.0910117	-16.539495	110	4	1.12	0.95	104.7751	1.2871	0.0000	0.0000;
	2222	1	6.381	2.562	0	0	1	1.1083232	-14.781674	110	4	1.12	0.95	101.5992	0.9349	0.0000	0.0000;
	2223	1	1.535	1.346	0	0	1	1.1095622	-14.699466	110	4	1.12	0.95	101.4105	0.9070	0.0000	0.0000;
	2224	1	11.481	2.975	0	0	1	1.0995283	-13.947989	110	4	1.12	0.95	105.3471	0.2515	0.0000	0.0000;
	2225	1	1.893	0.49	0	0	1	1.1005623	-15.912949	110	4	1.12	0.95	102.9691	1.0446	0.0000	0.0000;
	2226	1	6.169	0.667	0	0	1	1.1005527	-15.915334	110	4	1.12	0.95	102.9701	1.0447	0.0000	0.0000;
	2227	1	6.912	0.731	0	0	1	1.0626263	-22.12781	110	4	1.12	0.95	110.3717	2.3518	0.0000	0.0000;
	2228	1	2.555	0.5	0	0	1	1.116067	-13.598846	110	4	1.12	0.95	100.4434	0.1876	0.0000	0.0000;
	2229	1	3.408	1.052	0	0	1	1.1159887	-13.608884	110	4	1.12	0.95	100.4455	0.1904	0.0000	0.0000;
	2230	1	11.194	2.28	0	0	1	1.0968064	-25.859058	110	4	1.12	0.95	111.7020	0.0969	0.0000	0.0000;
	2231	2	15.239	2.944	0	0	1	1.0852414	-26.414348	110	4	1.12	0.95	112.4597	0.6623	0.0000	0.0000;
	2232	2	16.482	3.972	0	0	1	1.0653844	-28.815584	110	4	1.12	0.95	115.1009	0.4232	0.0000	0.0000;
	2233	1	14.51	0.364	0	0	1	1.0983604	-16.180638	110	4	1.12	0.95	103.3504	1.0766	0.0000	0.0000;
	2234	1	12.796	-0.192	0	0	1	1.0983522	-16.185668	110	4	1.12	0.95	103.3524	1.0766	0.0000	0.0000;
	2235	1	14.596	-0.015	0	0	1	1.0667173	-28.688265	110	4	1.12	0.95	114.8662	0.3985	0.0000	0.0000;
	2236	1	16.758	3.222	0	0	1	1.0917088	-26.021264	110	4	1.12	0.95	112.0060	0.3385	0.0000	0.0000;
	2237	1	0	0	0	0	1	1.0693977	-28.187409	110	4	1.12	0.95	114.2214	0.4384	0.0000	0.0000;
	2238	1	0	0	0	0	1	1.0694713	-28.147675	110	4	1.12	0.95	114.2435	0.3889	0.0000	0.0000;
	2239	2	31.671	5.455	0	0	1	1.0112355	-28.602815	110	4	1.12	0.95	114.2808	0.4536	0.0000	0.0000;
	2240	1	16.151	5.455	0	0	1	1.0111109	-28.780848	110	4	1.12	0.95	114.3023	0.4542	0.0000	0.0000;
	2241	1	0	0	0	0	1	1.0846526	-26.176394	110	4	1.12	0.95	112.2728	0.5953	0.0000	0.0000;
	2242	1	0	0	0	0	1	1.0912292	-25.569869	110	4	1.12	0.95	111.3879	0.6299	0.0000	0.0000;
	2243	1	7.119	1.681	0	0	1	1.0725859	-21.733824	110	4	1.12	0.95	108.4623	3.0464	0.0000	0.0000;
	2244	1	0.705	0	0	0	1	1.0674832	-21.026278	110	4	1.12	0.95	108.2519	3.2533	0.0000	0.0000;
	2245	1	6.644	-1.935	0	0	1	1.0979175	-23.158673	110	4	1.12	0.95	108.9886	1.4895	0.0000	0.0000;
	2246	1	8.142	2.72	0	0	1	1.0671593	-21.156051	110	4	1.12	0.95	108.3616	3.2618	0.0000	0.0000;
	2247	1	19.637	7.131	0	0	1	1.0594851	-23.422321	110	4	1.12	0.95	111.3046	3.1299	0.0000	0.0000;
	2248	1	20.816	5.323	0	0	1	1.0887802	-31.062313	110	4	1.12	0.95	116.1602	0.8361	0.0000	0.0000;
	2249	1	30.836	6.279	0	0	1	1.0837111	-31.003762	110	4	1.12	0.95	117.1125	1.0586	0.0000	0.0000;
	2250	1	13.443	0.854	0	0	1	1.0712199	-28.509611	110	4	1.12	0.95	115.9217	0.7515	0.0000	0.0000;
	2251	1	0	0	0	0	1	1.0712199	-28.509611	110	4	1.12	0.95	115.9217	0.7515	0.0000	0.0000;
	2252	1	6.636	0.336	0	0	1	1.1125457	-10.625781	110	4	1.12	0.95	100.0950	0.0995	0.0000	0.0000;
	2253	1	5.87	-1.9	0	0	1	1.0870352	-26.010802	110	4	1.12	0.95	112.2544	0.4958	0.0000	0.0000;
	2254	1	20.829	8.466	0	0	1	1.0933816	-25.884385	110	4	1.12	0.95	111.9223	0.2428	0.0000	0.0000;
	2255	1	0	0	0	0	1	1.0674838	-21.026167	110	4	1.12	0.95	108.2517	3.2533	0.0000	0.0000;
	2256	1	0	0	0	0	1	1.0726003	-21.732521	110	4	1.12	0.95	108.4605	3.0459	0.0000	0.0000;
	2257	2	16.818	11.033	0	0	1	1.096708	-30.507576	110	4	1.12	0.95	115.1140	0.5673	0.0000	0.0000;
	2258	2	7.287	2.995	0	0	1	1.0966771	-30.518887	110	4	1.12	0.95	115.1157	0.5679	0.0000	0.0000;
	2259	1	16.473	6.644	0	0	1	1.0892379	-26.301958	110	4	1.12	0.95	112.2727	0.4193	0.0000	0.0000;
	2260	1	12.88	2.866	0	0	1	1.0927336	-25.979731	110	4	1.12	0.95	111.9480	0.2872	0.0000	0.0000;
	2261	1	19.03	2.205	0	0	1	1.0874717	-25.079815	110	4	1.12	0.95	111.3249	0.6437	0.0000	0.0000;
	2262	1	9.373	-0.605	0	0	1	1.0818878	-26.475293	110	4	1.12	0.95	112.9323	0.5488	0.0000	0.0000;
	2263	1	17.137	-3.989	0	0	1	1.0662231	-28.812467	110	4	1.12	0.95	115.0388	0.3832	0.0000	0.0000;
	2264	1	19.125	4.2	0	0	1	1.0820238	-26.388452	110	4	1.12	0.95	112.6299	0.6724	0.0000	0.0000;
	2265	1	8.047	2.1	0	0	1	1.0911543	-25.855474	110	4	1.12	0.95	111.8357	0.4348	0.0000	0.0000;
	2266	1	13.375	1.91	0	0	1	1.1118812	-16.608132	110	4	1.12	0.95	102.8585	1.3858	0.0000	0.0000;
	2267	1	1.938	0.281	0	0	1	1.0641191	-22.34968	110	4	1.12	0.95	109.5860	3.3535	0.0000	0.0000;
	2268	1	20.776	3.946	0	0	1	1.1037495	-14.391642	110	4	1.12	0.95	102.3407	0.7315	0.0000	0.0000;
	2269	2	23.308	2.579	0	0	1	1.1101852	-13.87521	110	4	1.12	0.95	101.1190	0.6576	0.0000	0.0000;
	2270	1	16.001	1.2	0	0	1	1.0868571	-25.498289	110	4	1.12	0.95	111.8727	0.4998	0.0000	0.0000;
	2271	1	5.213	1.266	0	0	1	1.0967357	-16.047644	110	4	1.12	0.95	103.7771	1.1326	0.0000	0.0000;
	2272	1	16.603	3.489	0	0	1	1.0794717	-19.153801	110	4	1.12	0.95	107.0748	1.8647	0.0000	0.0000;
	2273	1	22.364	3.046	0	0	1	1.1059929	-14.842959	110	4	1.12	0.95	102.0860	0.5943	0.0000	0.0000;
	2274	1	2.083	0.339	0	0	1	1.1088789	-14.367067	110	4	1.12	0.95	101.5660	0.7315	0.0000	0.0000;
	2275	1	2.277	0.799	0	0	1	1.1006323	-15.801894	110	4	1.12	0.95	103.0390	0.9079	0.0000	0.0000;
	2276	1	8.835	2.981	0	0	1	1.0854167	-29.316069	110	4	1.12	0.95	115.5967	1.0369	0.0000	0.0000;
	2277	2	24.534	2.243	0	0	1	1.0316995	-27.788338	110	4	1.12	0.95	118.3426	3.1312	0.0000	0.0000;
	2278	1	11.39	0.932	0	0	1	1.0316829	-27.793363	110	4	1.12	0.95	118.3453	3.1314	0.0000	0.0000;
	2279	1	5.499	2.376	0	0	1	1.10342	-11.567603	110	4	1.12	0.95	100.9894	0.6130	0.0000	0.0000;
	2280	1	5.229	2.406	0	0	1	1.0921847	-14.447595	110	4	1.12	0.95	106.3077	0.4153	0.0000	0.0000;
	2281	2	16.878	2.18	0	0	1	1.0413956	-34.36731	110	4	1.12	0.95	125.8696	2.0144	0.0000	0.0000;
	2282	1	7.027	2.542	0	0	1	1.0725427	-34.2131	110	4	1.12	0.95	119.3131	1.1790	0.0000	0.0000;
	2283	1	13.632	-1.054	0	0	1	1.07548	-27.755198	110	4	1.12	0.95	114.5887	0.3417	0.0000	0.0000;
	2284	2	46.207	20.833	0	0	1	1.0817689	-15.027795	110	4	1.12	0.95	102.8446	1.7721	0.0000	0.0000;
	2285	1	10.037	2.292	0	0	1	1.1051463	-17.46871	110	4	1.12	0.95	103.8521	1.5002	0.0000	0.0000;
	2286	1	3.033	0.939	0	0	1	1.097225	-16.260545	110	4	1.12	0.95	103.5789	1.0824	0.0000	0.0000;
	2287	1	4.928	-1.04	0	0	1	1.0842601	-27.480613	110	4	1.12	0.95	114.4976	1.1539	0.0000	0.0000;
	2288	1	9.2	0.48	0	0	1	1.0799402	-28.932584	110	4	1.12	0.95	116.0643	1.0751	0.0000	0.0000;
	2289	1	14.73	-1.659	0	0	1	1.0824731	-25.799703	110	4	1.12	0.95	112.0612	1.7756	0.0000	0.0000;
	2290	1	7.216	-0.517	0	0	1	1.0807477	-26.108474	110	4	1.12	0.95	112.4431	1.7520	0.0000	0.0000;
	2291	1	7.139	2.115	0	0	1	1.0969156	-16.169492	110	4	1.12	0.95	103.3545	1.1183	0.0000	0.0000;
	2292	1	3.692	0.899	0	0	1	1.1093392	-16.943721	110	4	1.12	0.95	102.9367	1.4239	0.0000	0.0000;
	2293	1	0	0	0	0	1	1.1093686	-16.950107	110	4	1.12	0.95	102.9351	1.4271	0.0000	0.0000;
	2294	1	6.003	1.846	0	0	1	1.0982309	-16.195451	110	4	1.12	0.95	103.2879	1.0736	0.0000	0.0000;
	2295	1	6.576	2.115	0	0	1	1.09821	-16.19795	110	4	1.12	0.95	103.2890	1.0739	0.0000	0.0000;
	2296	1	8.047	4.482	0	0	1	1.0776147	-26.153118	110	4	1.12	0.95	112.8670	0.9842	0.0000	0.0000;
	2297	2	4.719	0.13	0	0	1	1.0951237	-30.645541	110	4	1.12	0.95	115.1277	0.6412	0.0000	0.0000;
	2298	1	2.896	0.1	0	0	1	1.0966705	-30.502293	110	4	1.12	0.95	114.9314	0.5952	0.0000	0.0000;
	2299	2	4.666	0.217	0	0	1	1.1080899	-14.819287	110	4	1.12	0.95	101.6401	0.9360	0.0000	0.0000;
	2300	2	4.287	0.298	0	0	1	1.0905277	-27.057377	110	4	1.12	0.95	112.6246	0.9926	0.0000	0.0000;
	2301	1	4.932	-1.347	0	0	1	1.0933928	-17.115209	110	4	1.12	0.95	104.8804	0.8402	0.0000	0.0000;
	2302	2	13.122	3.095	0	0	1	1.0959917	-14.97547	110	4	1.12	0.95	105.9479	0.4793	0.0000	0.0000;
	2303	1	20.214	2.934	0	0	1	1.0772568	-24.172598	110	4	1.12	0.95	110.6594	2.4776	0.0000	0.0000;
	2304	2	17.533	2.773	0	0	1	1.0992525	-15.626575	110	4	1.12	0.95	103.3096	0.8693	0.0000	0.0000;
	2305	1	7.029	3.821	0	0	1	1.0996846	-15.956913	110	4	1.12	0.95	103.0117	1.0563	0.0000	0.0000;
	2306	1	9.198	-0.296	0	0	1	1.0675393	-23.764287	110	4	1.12	0.95	110.6679	2.9125	0.0000	0.0000;
	2307	1	10.036	1.7	0	0	1	1.0669342	-25.61062	110	4	1.12	0.95	113.1591	1.7483	0.0000	0.0000;
	2308	2	23.847	1.824	0	0	1	1.0691884	-29.073452	110	4	1.12	0.95	115.8066	0.8679	0.0000	0.0000;
	2309	1	12.961	1.494	0	0	1	1.0860423	-23.480417	110	4	1.12	0.95	110.9190	1.0354	0.0000	0.0000;
	2310	1	15.565	-1.129	0	0	1	1.0986861	-16.465518	110	4	1.12	0.95	103.7092	0.8172	0.0000	0.0000;
	2311	1	0.568	0.607	0	0	1	1.0932561	-17.119856	110	4	1.12	0.95	104.8880	0.8465	0.0000	0.0000;
	2312	2	13.063	3.5	0	0	1	1.0506334	-26.507862	110	4	1.12	0.95	115.8551	2.3654	0.0000	0.0000;
	2313	1	8.899	-0.197	0	0	1	1.0717404	-28.67891	110	4	1.12	0.95	116.0358	0.7825	0.0000	0.0000;
	2314	2	26.011	3.998	0	0	1	1.0511763	-26.740169	110	4	1.12	0.95	116.2869	2.2383	0.0000	0.0000;
	2315	2	15.348	2.05	0	0	1	1.105042	-14.820669	110	4	1.12	0.95	102.4217	0.5752	0.0000	0.0000;
	2316	1	1.708	0.704	0	0	1	1.0939648	-17.153555	110	4	1.12	0.95	103.8389	1.4301	0.0000	0.0000;
	2317	1	22.983	5.76	0	0	1	1.0616621	-22.471559	110	4	1.12	0.95	109.9530	3.4513	0.0000	0.0000;
	2318	1	4.234	0.225	0	0	1	1.1079379	-13.444688	110	4	1.12	0.95	101.6229	0.7577	0.0000	0.0000;
	2319	1	15.198	2.941	0	0	1	1.0899485	-16.493759	110	4	1.12	0.95	104.7195	1.3149	0.0000	0.0000;
	2320	1	15.199	2.845	0	0	1	1.0899154	-16.499704	110	4	1.12	0.95	104.7220	1.3154	0.0000	0.0000;
	2321	1	8.642	0.341	0	0	1	1.0861274	-28.416243	110	4	1.12	0.95	114.0750	0.9039	0.0000	0.0000;
	2322	1	0.949	1.084	0	0	1	1.1062691	-10.905118	110	4	1.12	0.95	100.6547	0.4288	0.0000	0.0000;
	2323	1	7.309	0.786	0	0	1	1.0963159	-24.993937	110	4	1.12	0.95	110.3451	1.5215	0.0000	0.0000;
	2324	1	21.586	2.822	0	0	1	1.0875597	-26.13882	110	4	1.12	0.95	112.5138	0.3051	0.0000	0.0000;
	2325	2	3.475	0.52	0	0	1	1.1020767	-15.814065	110	4	1.12	0.95	102.7477	0.9958	0.0000	0.0000;
	2326	1	1.817	2.276	0	0	1	1.1062281	-15.241215	110	4	1.12	0.95	102.1768	0.8906	0.0000	0.0000;
	2327	1	7.365	1.234	0	0	1	1.0383463	-34.920826	110	4	1.12	0.95	126.6920	2.0118	0.0000	0.0000;
	2328	1	7.722	1.3	0	0	1	1.0668363	-34.814074	110	4	1.12	0.95	120.3928	1.2799	0.0000	0.0000;
	2329	1	5.495	0.415	0	0	1	1.1098183	-14.645333	110	4	1.12	0.95	101.5848	0.6580	0.0000	0.0000;
	2330	1	1.987	0.817	0	0	1	1.0675858	-34.747298	110	4	1.12	0.95	120.2669	1.2603	0.0000	0.0000;
	2331	1	12.34	4.101	0	0	1	1.0850121	-31.45572	110	4	1.12	0.95	116.9369	0.7984	0.0000	0.0000;
	2332	2	10.235	0.6	0	0	1	1.0834443	-15.039475	110	4	1.12	0.95	107.5665	0.5725	0.0000	0.0000;
	2333	1	7.787	1.958	0	0	1	1.0868425	-17.387015	110	4	1.12	0.95	104.6150	1.5010	0.0000	0.0000;
	2334	2	5.792	1	0	0	1	1.0976667	-30.393137	110	4	1.12	0.95	115.1706	0.5062	0.0000	0.0000;
	2335	1	7.599	-0.44	0	0	1	1.0566761	-24.342884	110	4	1.12	0.95	112.4958	3.0488	0.0000	0.0000;
	2336	1	6.155	3.09	0	0	1	1.0956359	-30.54696	110	4	1.12	0.95	115.0111	0.6498	0.0000	0.0000;
	2337	2	6.853	-0.781	0	0	1	1.0510777	-36.171009	110	4	1.12	0.95	124.0385	1.4631	0.0000	0.0000;
	2338	1	22.532	3.058	0	0	1	1.0727594	-28.228065	110	4	1.12	0.95	114.7944	0.8435	0.0000	0.0000;
	2339	1	10.553	4.047	0	0	1	1.1060005	-15.486115	110	4	1.12	0.95	101.8649	1.0816	0.0000	0.0000;
	2340	1	14.548	1.797	0	0	1	1.115607	-9.8216828	110	4	1.12	0.95	101.1001	0.0424	0.0000	0.0000;
	2341	1	10.226	0.595	0	0	1	1.0641475	-29.189037	110	4	1.12	0.95	115.7725	0.6933	0.0000	0.0000;
	2342	1	13.273	9.523	0	0	1	1.1184376	-9.1653945	110	4	1.12	0.95	98.9289	0.0645	0.0000	0.0000;
	2343	1	20.861	16.54	0	0	1	1.1149962	-9.2759371	110	4	1.12	0.95	99.1210	0.2185	0.0000	0.0000;
	2344	1	0.947	0.02	0	0	1	1.119134	-9.1558793	110	4	1.12	0.95	98.8999	0.0301	0.0000	0.0000;
	2345	1	6.627	6.069	0	0	1	1.1170827	-9.2058894	110	4	1.12	0.95	99.0103	0.1309	0.0000	0.0000;
	2346	1	2.84	2.063	0	0	1	1.1191643	-9.1507816	110	4	1.12	0.95	98.8937	0.0304	0.0000	0.0000;
	2347	1	1.893	0.013	0	0	1	1.1177571	-9.2035706	110	4	1.12	0.95	98.9846	0.0929	0.0000	0.0000;
	2348	1	0.947	1.005	0	0	1	1.1177737	-9.2026289	110	4	1.12	0.95	98.9839	0.0924	0.0000	0.0000;
	2349	2	22.303	33.91	0	0	1	1.1198572	-9.1225845	110	4	1.12	0.95	98.8400	0.0000	0.0000	0.0000;
	2350	1	3.272	10.554	0	0	1	1.1196975	-9.1280814	110	4	1.12	0.95	98.8422	0.0026	0.0000	0.0000;
	2351	1	31.344	7.603	0	0	1	1.0945571	-30.713787	110	4	1.12	0.95	115.3131	0.6357	0.0000	0.0000;
	2352	1	9.961	2.919	0	0	1	1.0936227	-16.777775	110	4	1.12	0.95	103.7801	1.3513	0.0000	0.0000;
	2353	1	2.368	0.659	0	0	1	1.0995097	-16.038295	110	4	1.12	0.95	103.1254	1.0624	0.0000	0.0000;
	2354	1	6.164	2.247	0	0	1	1.0994882	-16.040622	110	4	1.12	0.95	103.1264	1.0628	0.0000	0.0000;
	2355	1	19.03	2.52	0	0	1	1.0710764	-27.860795	110	4	1.12	0.95	114.6628	0.6208	0.0000	0.0000;
	2356	1	16.616	3.939	0	0	1	1.1050661	-13.547132	110	4	1.12	0.95	104.5498	0.1000	0.0000	0.0000;
	2357	1	13.917	9.7	0	0	1	1.1049831	-13.552152	110	4	1.12	0.95	104.5518	0.1014	0.0000	0.0000;
	2358	1	20.26	4.604	0	0	1	1.0919184	-25.961937	110	4	1.12	0.95	111.9755	0.3312	0.0000	0.0000;
	2359	1	3.602	-0.338	0	0	1	1.1089142	-28.115359	110	4	1.12	0.95	113.6221	0.1416	0.0000	0.0000;
	2360	2	17.432	14.222	0	0	1	1.12	-13.3996	110	4	1.12	0.95	99.9850	0.0000	973.9517	0.0000;
	2361	2	10.618	8	0	0	1	1.12	-14.364116	110	4	1.12	0.95	101.0392	0.0000	765.9967	0.0000;
	2362	1	3.891	1.248	0	0	1	1.1110034	-11.136881	110	4	1.12	0.95	102.3406	0.1395	0.0000	0.0000;
	2363	1	3.223	-0.611	0	0	1	1.0710954	-33.49722	110	4	1.12	0.95	121.9523	0.0569	0.0000	0.0000;
	2364	1	2.021	2.495	0	0	1	1.0983296	-16.081316	110	4	1.12	0.95	103.3127	1.1096	0.0000	0.0000;
	2365	1	0	0	0	0	1	1.0983296	-16.081316	110	4	1.12	0.95	103.3127	1.1096	0.0000	0.0000;
	2366	2	26.352	6.364	0	0	1	1.10948	-14.72118	110	4	1.12	0.95	101.4211	0.8997	0.0000	0.0000;
	2367	1	13.971	5.328	0	0	1	1.109567	-14.716813	110	4	1.12	0.95	101.4156	0.8965	0.0000	0.0000;
	2368	1	4.938	1.465	0	0	1	1.0880512	-24.020102	110	4	1.12	0.95	110.6874	0.7805	0.0000	0.0000;
	2369	1	0	2.107	0	0	1	1.1054437	-11.104983	110	4	1.12	0.95	100.7129	0.4947	0.0000	0.0000;
	2370	1	4.259	2.3	0	0	1	1.1056968	-10.927758	110	4	1.12	0.95	100.6845	0.4460	0.0000	0.0000;
	2371	1	15.811	-0.934	0	0	1	1.0575709	-30.046868	110	4	1.12	0.95	117.6418	0.1230	0.0000	0.0000;
	2372	2	10.128	0.35	0	0	1	1.1102728	-16.178614	110	4	1.12	0.95	102.4001	1.1590	0.0000	0.0000;
	2373	1	3.462	-0.413	0	0	1	1.1102733	-16.17996	110	4	1.12	0.95	102.4006	1.1590	0.0000	0.0000;
	2374	1	16.508	4.201	0	0	1	1.1088886	-13.892656	110	4	1.12	0.95	101.1880	0.5723	0.0000	0.0000;
	2375	1	2.203	0.908	0	0	1	1.1166675	-14.357315	110	4	1.12	0.95	101.0627	0.3650	0.0000	0.0000;
	2376	2	9.502	1.315	0	0	1	1.1099553	-14.916041	110	4	1.12	0.95	102.0286	0.3436	0.0000	0.0000;
	2377	1	4.645	0.885	0	0	1	1.1100637	-14.90365	110	4	1.12	0.95	102.0221	0.3414	0.0000	0.0000;
	2378	1	16.096	1.275	0	0	1	1.0682583	-29.421597	110	4	1.12	0.95	116.4585	0.7225	0.0000	0.0000;
	2379	1	25.305	4.694	0	0	1	1.1073446	-15.183581	110	4	1.12	0.95	102.3300	0.3993	0.0000	0.0000;
	2380	1	2.294	0.629	0	0	1	1.1197555	-13.422802	110	4	1.12	0.95	100.0105	0.0054	0.0000	0.0000;
	2381	1	14.242	4.218	0	0	1	1.1129823	-13.770429	110	4	1.12	0.95	100.7784	0.3441	0.0000	0.0000;
	2382	1	1.208	0.508	0	0	1	1.1101633	-14.680462	110	4	1.12	0.95	101.7707	0.5334	0.0000	0.0000;
	2383	1	22.938	4.485	0	0	1	1.069218	-8.5606232	110	4	1.12	0.95	104.9593	0.5490	0.0000	0.0000;
	2384	1	16.588	2.146	0	0	1	1.1067763	-14.752301	110	4	1.12	0.95	101.9848	0.5806	0.0000	0.0000;
	2385	1	1.904	1.78	0	0	1	1.108952	-14.358669	110	4	1.12	0.95	101.5566	0.7303	0.0000	0.0000;
	2386	2	9.494	1.16	0	0	1	1.065338	-23.994596	110	4	1.12	0.95	111.4548	2.5274	0.0000	0.0000;
	2387	1	19.977	0.442	0	0	1	1.0765388	-25.551199	110	4	1.12	0.95	112.8303	1.2001	0.0000	0.0000;
	2388	1	18.151	5.149	0	0	1	1.0666173	-24.458713	110	4	1.12	0.95	111.3477	2.8722	0.0000	0.0000;
	2389	1	3.889	-1.11	0	0	1	1.0390798	-34.853574	110	4	1.12	0.95	126.5569	1.9908	0.0000	0.0000;
	2390	1	34.49	6.156	0	0	1	1.1087031	-13.89053	110	4	1.12	0.95	101.2001	0.5941	0.0000	0.0000;
	2391	1	3.835	1.103	0	0	1	1.1105626	-14.581932	110	4	1.12	0.95	101.4551	0.6958	0.0000	0.0000;
	2392	1	22.062	8.224	0	0	1	1.0991636	-14.925928	110	4	1.12	0.95	102.7783	1.0602	0.0000	0.0000;
	2393	1	1.93	0.908	0	0	1	1.1098382	-14.696988	110	4	1.12	0.95	101.8028	0.5460	0.0000	0.0000;
	2394	1	9.171	-1.769	0	0	1	1.1097345	-26.51304	110	4	1.12	0.95	112.3065	-1.0573	0.0000	0.0000;
	2395	1	18.937	5.02	0	0	1	1.108398	-14.852245	110	4	1.12	0.95	102.0874	0.5182	0.0000	0.0000;
	2396	1	0.754	0.74	0	0	1	1.116744	-13.613295	110	4	1.12	0.95	100.2829	0.1528	0.0000	0.0000;
	2397	1	17.058	5.34	0	0	1	1.0990161	-14.939662	110	4	1.12	0.95	102.7949	1.0639	0.0000	0.0000;
	2398	1	14.109	4.032	0	0	1	1.1125052	-13.7038	110	4	1.12	0.95	100.8652	0.3765	0.0000	0.0000;
	2399	1	0	0	0	0	1	1.0919802	-27.636208	110	4	1.12	0.95	113.0494	1.0191	0.0000	0.0000;
	2400	1	0	0	0	0	1	1.1018851	-15.927664	110	4	1.12	0.95	103.1316	0.7970	0.0000	0.0000;
	2401	1	0	0	0	0	1	1.0958441	-16.196054	110	4	1.12	0.95	104.1346	1.0203	0.0000	0.0000;
	2402	1	0	0	0	0	1	1.1063519	-10.907569	110	4	1.12	0.95	100.6547	0.4202	0.0000	0.0000;
	2403	1	0	0	0	0	1	1.1067263	-21.038	110	4	1.12	0.95	107.5921	0.3879	0.0000	0.0000;
	2404	1	0	0	0	0	1	1.1100753	-13.042439	110	4	1.12	0.95	104.1622	0.3877	0.0000	0.0000;
	2405	1	0	0	0	0	1	1.0934894	-17.573851	110	4	1.12	0.95	103.8617	1.6694	0.0000	0.0000;
	2406	1	0	0	0	0	1	1.0720741	-21.771902	110	4	1.12	0.95	108.5122	3.0672	0.0000	0.0000;
	2407	1	0	0	0	0	1	1.0652128	-22.235069	110	4	1.12	0.95	109.4342	3.3236	0.0000	0.0000;
	2408	1	0	0	0	0	1	1.094482	-15.690421	110	4	1.12	0.95	103.6512	1.2883	0.0000	0.0000;
	2409	1	0	0	0	0	1	1.0894149	-27.992265	110	4	1.12	0.95	113.7798	0.9851	0.0000	0.0000;
	2410	1	0	0	0	0	1	1.0983826	-25.594232	110	4	1.12	0.95	110.8237	1.1567	0.0000	0.0000;
	2411	1	0	0	0	0	1	1.0652074	-24.051261	110	4	1.12	0.95	111.5231	2.5108	0.0000	0.0000;
	2412	1	0	0	0	0	1	1.1034904	-15.163934	110	4	1.12	0.95	102.4449	0.7699	0.0000	0.0000;
	2413	1	0	0	0	0	1	1.0867891	-27.715089	110	4	1.12	0.95	114.0418	1.1908	0.0000	0.0000;
	2414	1	0	0	0	0	1	1.0666658	-22.150093	110	4	1.12	0.95	109.2091	3.2711	0.0000	0.0000;
	2415	1	0	0	0	0	1	1.0667342	-28.69394	110	4	1.12	0.95	114.8761	0.3965	0.0000	0.0000;
	2416	1	0	0	0	0	1	1.0643012	-22.322974	110	4	1.12	0.95	109.5519	3.3510	0.0000	0.0000;
	2417	1	0	0	0	0	1	1.0668645	-28.606259	110	4	1.12	0.95	114.9847	0.3648	0.0000	0.0000;
	2418	1	0	0	0	0	1	1.0879377	-26.369501	110	4	1.12	0.95	112.3580	0.4825	0.0000	0.0000;
	2419	1	0	0	0	0	1	1.108164	-13.426018	110	4	1.12	0.95	101.5837	0.7561	0.0000	0.0000;
	2420	1	0	0	0	0	1	1.0934528	-30.425841	110	4	1.12	0.95	115.6202	0.6926	0.0000	0.0000;
	2421	1	0	0	0	0	1	1.1108857	-14.55427	110	4	1.12	0.95	101.4231	0.6874	0.0000	0.0000;
	2422	1	0	0	0	0	1	1.1114858	-15.525266	110	4	1.12	0.95	101.9182	1.0069	0.0000	0.0000;
	2423	1	4.065	0.44	0	0	1	1.0948911	-5.5748749	110	4	1.12	0.95	102.1007	0.2625	0.0000	0.0000;
	2424	1	2.085	0.622	0	0	1	1.0862117	-23.494654	110	4	1.12	0.95	109.6388	2.2246	0.0000	0.0000;
	2425	1	8.73	-0.569	0	0	1	1.0536879	-25.475455	110	4	1.12	0.95	113.9317	2.9304	0.0000	0.0000;
	2426	1	7.585	3.466	0	0	1	1.0767047	-31.501479	110	4	1.12	0.95	118.3149	1.3100	0.0000	0.0000;
	2427	1	38.548	11.667	0	0	1	1.0553722	-25.983152	110	4	1.12	0.95	114.1206	2.9237	0.0000	0.0000;
	2428	1	8.551	1.475	0	0	1	1.0974759	-16.303197	110	4	1.12	0.95	103.5600	0.9293	0.0000	0.0000;
	2429	1	6.645	-0.121	0	0	1	1.0974718	-16.305814	110	4	1.12	0.95	103.5610	0.9292	0.0000	0.0000;
	2430	1	11.401	4.084	0	0	1	1.1012657	-15.746286	110	4	1.12	0.95	102.9528	0.8874	0.0000	0.0000;
	2431	1	10.447	4.02	0	0	1	1.1012359	-15.768337	110	4	1.12	0.95	102.9611	0.8877	0.0000	0.0000;
	2432	1	15.004	3.63	0	0	1	1.0739426	-27.218415	110	4	1.12	0.95	113.8128	1.6688	0.0000	0.0000;
	2433	1	8.929	1.49	0	0	1	1.0930513	-30.451797	110	4	1.12	0.95	115.6870	0.7035	0.0000	0.0000;
	2434	1	25.279	9.75	0	0	1	1.088214	-25.712989	110	4	1.12	0.95	112.0054	0.3927	0.0000	0.0000;
	2435	1	35.067	7.544	0	0	1	1.0887527	-31.029427	110	4	1.12	0.95	116.1606	0.8458	0.0000	0.0000;
	2436	1	7.119	-2.288	0	0	1	1.0998074	-23.200204	110	4	1.12	0.95	108.9716	1.3185	0.0000	0.0000;
	2437	1	18.051	0.833	0	0	1	1.0993852	-23.301722	110	4	1.12	0.95	109.1554	1.3031	0.0000	0.0000;
	2438	2	0	1.5	0	0	1	1.1022135	-23.183563	110	4	1.12	0.95	108.8196	1.1464	0.0000	0.0000;
	2439	1	15.182	3.99	0	0	1	1.1146059	-10.370602	110	4	1.12	0.95	99.8035	0.0510	0.0000	0.0000;
	2440	1	1.473	1.177	0	0	1	1.0973059	-19.966274	110	4	1.12	0.95	107.1721	0.8600	0.0000	0.0000;
	2441	1	5.215	0.561	0	0	1	1.077727	-28.364141	110	4	1.12	0.95	114.9984	0.9009	0.0000	0.0000;
	2442	1	9.866	2.972	0	0	1	1.1106897	-10.745991	110	4	1.12	0.95	103.1049	0.0235	0.0000	0.0000;
	2443	1	14.246	0.904	0	0	1	1.0628867	-29.298364	110	4	1.12	0.95	116.4375	0.0252	0.0000	0.0000;
	2444	1	6.736	0.946	0	0	1	1.1038721	-14.115409	110	4	1.12	0.95	101.9090	0.7722	0.0000	0.0000;
	2445	2	6.552	0.6	0	0	1	1.0627988	-29.582914	110	4	1.12	0.95	116.5347	0.8197	0.0000	0.0000;
	2446	2	26.174	3.99	0	0	1	1.0693233	-21.355194	110	4	1.12	0.95	108.7028	3.0844	0.0000	0.0000;
	2447	1	7.681	-0.432	0	0	1	1.1016852	-15.600408	110	4	1.12	0.95	102.8752	0.9854	0.0000	0.0000;
	2448	1	6.352	1.521	0	0	1	1.101669	-15.602827	110	4	1.12	0.95	102.8762	0.9857	0.0000	0.0000;
	2449	1	23.1	8.489	0	0	1	1.0819661	-17.106125	110	4	1.12	0.95	105.7179	1.6355	0.0000	0.0000;
	2450	1	3.253	1.121	0	0	1	1.0902122	-16.599004	110	4	1.12	0.95	104.8874	1.3087	0.0000	0.0000;
	2451	1	0	0	0	0	1	1.0741737	-21.335674	110	4	1.12	0.95	108.4743	2.7821	0.0000	0.0000;
	2452	1	0	0	0	0	1	1.0701187	-22.478042	110	4	1.12	0.95	109.2907	3.0180	0.0000	0.0000;
	2453	1	9.123	2.673	0	0	1	1.1027767	-15.26048	110	4	1.12	0.95	102.7900	0.7648	0.0000	0.0000;
	2454	1	0.38	0.2	0	0	1	1.0964975	-30.654034	110	4	1.12	0.95	115.2294	0.5391	0.0000	0.0000;
	2455	2	11.865	2.3	0	0	1	1.1141973	-26.306599	110	5	1.12	0.95	111.1414	0.3185	0.0000	0.0000;
	2456	1	12.274	2	0	0	1	1.0872872	-30.826463	110	5	1.12	0.95	117.3739	0.9643	0.0000	0.0000;
	2457	1	21.479	5.5	0	0	1	1.1137436	-24.474061	110	5	1.12	0.95	109.9969	-0.3562	0.0000	0.0000;
	2458	2	21.479	20	0	0	1	1.1179277	-23.503841	110	5	1.12	0.95	108.8222	-0.0001	0.0000	0.0000;
	2459	2	5.505	4	0	0	1	1.1179533	-23.499808	110	5	1.12	0.95	108.8204	0.0000	0.0000	0.0000;
	2460	1	11.251	2.5	0	0	1	1.0954767	-29.957951	110	5	1.12	0.95	115.8374	0.8104	0.0000	0.0000;
	2461	2	17.389	0.5	0	0	1	1.1033487	-25.988057	110	5	1.12	0.95	112.2073	-0.5318	0.0000	0.0000;
	2462	2	7.671	-0.114	0	0	1	1.1033526	-25.991092	110	5	1.12	0.95	112.2084	-0.5320	0.0000	0.0000;
	2463	1	10.229	2.5	0	0	1	1.1161209	-23.754455	110	5	1.12	0.95	109.1313	-0.0227	0.0000	0.0000;
	2464	1	12.172	3.5	0	0	1	1.08093	-27.766795	110	5	1.12	0.95	114.5132	0.2898	0.0000	0.0000;
	2465	1	9.001	1.8	0	0	1	1.1066229	-24.028544	110	5	1.12	0.95	110.2462	0.2452	0.0000	0.0000;
	2466	1	21.479	4	0	0	1	1.1155288	-24.232346	110	5	1.12	0.95	109.7423	-0.2190	0.0000	0.0000;
	2467	2	8.183	1.3	0	0	1	1.0870516	-29.111377	110	5	1.12	0.95	116.3210	0.5564	0.0000	0.0000;
	2468	1	5.626	2	0	0	1	1.107003	-28.717114	110	5	1.12	0.95	114.1208	0.4404	0.0000	0.0000;
	2469	1	10.331	2.8	0	0	1	1.084805	-27.633569	110	5	1.12	0.95	113.8881	0.0693	0.0000	0.0000;
	2470	1	46.028	1.2	0	0	1	1.007339	-34.020845	110	5	1.12	0.95	131.9566	3.0725	0.0000	0.0000;
	2471	1	22.502	6	0	0	1	1.1131391	-24.256643	110	5	1.12	0.95	109.7465	-0.1307	0.0000	0.0000;
	2472	1	14.32	3	0	0	1	1.1167795	-24.044865	110	5	1.12	0.95	109.5161	-0.1689	0.0000	0.0000;
	2473	1	0	0	0	0	1	1.12	-24.512174	110	5	1.12	0.95	109.9934	-0.9763	3317.3944	0.0000;
	2474	1	0	0	0	0	1	1.1197302	-24.522979	110	5	1.12	0.95	110.0019	-0.9586	0.0000	0.0000;
	2475	2	12.274	1	0	0	1	1.1004946	-26.552693	110	5	1.12	0.95	113.6018	-0.5383	0.0000	0.0000;
	2476	1	5.115	1	0	0	1	1.1006084	-27.353911	110	5	1.12	0.95	113.4368	0.5020	0.0000	0.0000;
	2477	1	7.672	2	0	0	1	1.0265615	-30.953706	110	5	1.12	0.95	127.2422	2.7583	0.0000	0.0000;
	2478	2	25.367	5	0	0	1	1.1033944	-25.849107	110	5	1.12	0.95	111.7249	0.4513	0.0000	0.0000;
	2479	2	10.74	2.1	0	0	1	1.1032793	-25.84428	110	5	1.12	0.95	111.7358	0.4505	0.0000	0.0000;
	2480	2	13.194	4.2	0	0	1	1.0722327	-26.650197	110	5	1.12	0.95	113.0377	0.9521	0.0000	0.0000;
	2481	1	17.695	4.1	0	0	1	1.067092	-25.982752	110	5	1.12	0.95	113.1604	1.4134	0.0000	0.0000;
	2482	1	12.274	3.6	0	0	1	1.0291137	-30.78835	110	5	1.12	0.95	126.6281	2.7249	0.0000	0.0000;
	2483	1	12.887	3.2	0	0	1	1.1121453	-25.440907	110	5	1.12	0.95	110.6100	-0.9082	0.0000	0.0000;
	2484	1	9.717	2.5	0	0	1	1.067808	-30.718488	110	5	1.12	0.95	118.3120	1.6480	0.0000	0.0000;
	2485	1	7.263	1.4	0	0	1	1.0697432	-30.544205	110	5	1.12	0.95	118.0551	1.5872	0.0000	0.0000;
	2486	1	14.32	2	0	0	1	1.0188013	-31.679766	110	5	1.12	0.95	129.1993	2.8199	0.0000	0.0000;
	2487	1	15.855	3.1	0	0	1	1.1112742	-26.285843	110	5	1.12	0.95	111.5959	0.2877	0.0000	0.0000;
	2488	1	5.626	0	0	0	1	1.0628698	-33.541254	110	5	1.12	0.95	123.8360	-0.1177	0.0000	0.0000;
	2489	2	4.091	0.5	0	0	1	1.0180824	-32.052006	110	5	1.12	0.95	129.7235	2.7240	0.0000	0.0000;
	2490	2	4.091	0.6	0	0	1	1.1034784	-24.853999	110	5	1.12	0.95	111.2836	-0.0105	0.0000	0.0000;
	2491	2	0.511	0.1	0	0	1	1.1043346	-25.39987	110	5	1.12	0.95	111.8328	-0.3210	0.0000	0.0000;
	2492	1	9.206	1.5	0	0	1	1.1053518	-28.561134	110	5	1.12	0.95	114.2323	0.3073	0.0000	0.0000;
	2493	1	6.648	0	0	0	1	1.0662255	-33.623571	110	5	1.12	0.95	123.1099	-0.0526	0.0000	0.0000;
	2494	1	1.228	0.4	0	0	1	1.0732412	-26.253279	110	5	1.12	0.95	112.8375	0.9689	0.0000	0.0000;
	2495	1	7.569	2.3	0	0	1	1.0774497	-23.983554	110	5	1.12	0.95	111.4653	1.2592	0.0000	0.0000;
	2496	2	9.717	0.5	0	0	1	1.1030883	-24.657751	110	5	1.12	0.95	110.8458	-0.1774	0.0000	0.0000;
	2497	1	0	0	0	0	1	1.1049157	-24.904641	110	5	1.12	0.95	110.9332	-0.3389	0.0000	0.0000;
	2498	1	0	0	0	0	1	1.1049277	-24.926529	110	5	1.12	0.95	110.9404	-0.3378	0.0000	0.0000;
	2499	2	6.138	1.2	0	0	1	1.0859036	-28.894127	110	5	1.12	0.95	116.2785	0.5818	0.0000	0.0000;
	2500	1	6.138	1.2	0	0	1	1.0859323	-28.900235	110	5	1.12	0.95	116.2770	0.5841	0.0000	0.0000;
	2501	1	17.286	1.9	0	0	1	1.0847836	-29.221187	110	5	1.12	0.95	116.5420	0.6134	0.0000	0.0000;
	2502	1	12.274	1.9	0	0	1	1.0837923	-29.096072	110	5	1.12	0.95	116.4792	0.5816	0.0000	0.0000;
	2503	1	16.366	4	0	0	1	1.1178304	-23.914439	110	5	1.12	0.95	109.2625	-0.1017	0.0000	0.0000;
	2504	1	7.866	2	0	0	1	1.1185799	-23.845559	110	5	1.12	0.95	109.1829	-0.1213	0.0000	0.0000;
	2505	2	2.046	0.5	0	0	1	1.1031967	-25.946637	110	5	1.12	0.95	112.5822	-0.4204	0.0000	0.0000;
	2506	1	0	0	0	0	1	1.1148294	-26.05732	110	5	1.12	0.95	110.8829	0.3444	0.0000	0.0000;
	2507	1	0	0	0	0	1	1.1149663	-26.052566	110	5	1.12	0.95	110.7460	0.3406	0.0000	0.0000;
	2508	2	41.016	8	0	0	1	1.1144835	-26.427601	110	5	1.12	0.95	111.2918	0.3019	0.0000	0.0000;
	2509	2	15.24	3	0	0	1	1.1177101	-26.006876	110	5	1.12	0.95	110.7684	0.1973	0.0000	0.0000;
	2510	1	0	0	0	0	1	1.1105479	-26.328275	110	5	1.12	0.95	111.8448	0.1721	0.0000	0.0000;
	2511	1	0	0	0	0	1	1.1138325	-26.784435	110	5	1.12	0.95	112.0269	0.0455	0.0000	0.0000;
	2512	1	23.423	4.6	0	0	1	1.1121405	-26.34565	110	5	1.12	0.95	111.2592	0.3668	0.0000	0.0000;
	2513	1	7.467	1.5	0	0	1	1.0980828	-26.513385	110	5	1.12	0.95	112.8104	0.5348	0.0000	0.0000;
	2514	1	4.603	0.9	0	0	1	1.0980429	-26.502232	110	5	1.12	0.95	112.8162	0.5344	0.0000	0.0000;
	2515	1	5.626	1.5	0	0	1	1.1079226	-28.435051	110	5	1.12	0.95	113.4151	-0.1139	0.0000	0.0000;
	2516	1	8.898	3.2	0	0	1	1.1132486	-25.487097	110	5	1.12	0.95	110.6025	-1.1726	0.0000	0.0000;
	2517	2	8.694	2	0	0	1	1.0693416	-20.347909	110	5	1.12	0.95	111.7483	1.2459	0.0000	0.0000;
	2518	1	8.694	2.8	0	0	1	1.0810294	-26.070794	110	5	1.12	0.95	112.9368	0.4434	0.0000	0.0000;
	2519	2	6.137	0	0	0	1	1.0997439	-26.103993	110	5	1.12	0.95	112.4760	-0.3840	0.0000	0.0000;
	2520	1	21.99	4.3	0	0	1	1.0970114	-26.689427	110	5	1.12	0.95	113.0539	0.5580	0.0000	0.0000;
	2521	1	18.412	3.6	0	0	1	1.0977981	-26.536735	110	5	1.12	0.95	112.8469	0.5413	0.0000	0.0000;
	2522	2	1.023	0.3	0	0	1	1.078093	-26.304843	110	5	1.12	0.95	112.4518	0.7164	0.0000	0.0000;
	2523	1	0.614	0.4	0	0	1	1.0780228	-26.289685	110	5	1.12	0.95	112.4592	0.7331	0.0000	0.0000;
	2524	1	3.58	1	0	0	1	1.0974612	-30.084768	110	5	1.12	0.95	115.4800	0.6696	0.0000	0.0000;
	2525	1	0.205	0	0	0	1	1.1145683	-26.188846	110	5	1.12	0.95	111.0310	0.3348	0.0000	0.0000;
	2526	1	15.035	5.8	0	0	1	1.1129231	-25.513632	110	5	1.12	0.95	110.6490	-1.1512	0.0000	0.0000;
	2527	1	0	0	0	0	1	1.1199029	-25.011554	110	5	1.12	0.95	109.8180	-1.4924	0.0000	0.0000;
	2528	1	0	0	0	0	1	1.12	-24.991321	110	5	1.12	0.95	109.8045	-1.5156	10978.4142	0.0000;
	2529	1	0	0	0	0	1	1.1199467	-24.989879	110	5	1.12	0.95	109.8118	-1.4968	0.0000	0.0000;
	2530	1	4.091	0.5	0	0	1	1.0181849	-31.89832	110	5	1.12	0.95	129.5108	2.7795	0.0000	0.0000;
	2531	2	8.694	0	0	0	1	1.1008837	-28.349017	110	5	1.12	0.95	115.0403	-0.7235	0.0000	0.0000;
	2532	1	21.479	4	0	0	1	1.0861714	-28.715327	110	5	1.12	0.95	114.8269	0.1116	0.0000	0.0000;
	2533	1	7.262	2.7	0	0	1	1.0979232	-26.640213	110	5	1.12	0.95	112.3194	-0.5226	0.0000	0.0000;
	2534	2	28.639	8	0	0	1	1.1151943	-24.336122	110	5	1.12	0.95	109.8629	-0.2972	0.0000	0.0000;
	2535	1	10.229	2	0	0	1	1.1193137	-23.78253	110	5	1.12	0.95	109.1025	-0.1400	0.0000	0.0000;
	2536	1	7.16	1.5	0	0	1	1.1192943	-23.782242	110	5	1.12	0.95	109.1061	-0.1397	0.0000	0.0000;
	2537	2	31.708	22	0	0	1	1.0793361	-18.619876	110	5	1.12	0.95	109.7199	1.1274	0.0000	0.0000;
	2538	1	11.251	1.5	0	0	1	1.1128745	-28.160406	110	5	1.12	0.95	113.3889	0.1622	0.0000	0.0000;
	2539	1	0	0	0	0	1	1.1020472	-26.040372	110	5	1.12	0.95	112.3172	-0.4909	0.0000	0.0000;
	2540	1	7.467	2.9	0	0	1	1.0730902	-25.857111	110	5	1.12	0.95	112.6730	1.0608	0.0000	0.0000;
	2541	1	1.534	0.5	0	0	1	1.0584007	-20.412447	110	5	1.12	0.95	113.4688	1.6323	0.0000	0.0000;
	2542	1	2.046	0.6	0	0	1	1.0584058	-20.41182	110	5	1.12	0.95	113.4685	1.6322	0.0000	0.0000;
	2543	1	20.15	3.9	0	0	1	1.0765471	-29.558524	110	5	1.12	0.95	117.8460	1.2716	0.0000	0.0000;
	2544	2	0	0	0	0	1	1.1075964	-24.821636	110	5	1.12	0.95	111.2233	0.3553	0.0000	0.0000;
	2545	1	14.012	2.7	0	0	1	1.094049	-28.192163	110	5	1.12	0.95	115.0621	0.7082	0.0000	0.0000;
	2546	1	13.194	2.6	0	0	1	1.1057137	-26.934802	110	5	1.12	0.95	112.6424	0.2930	0.0000	0.0000;
	2547	1	8.694	1.1	0	0	1	1.0986865	-26.034805	110	5	1.12	0.95	112.3392	-0.2572	0.0000	0.0000;
	2548	1	12.478	2.4	0	0	1	1.0985039	-26.431604	110	5	1.12	0.95	112.6577	0.5352	0.0000	0.0000;
	2549	2	3.58	0.7	0	0	1	1.1119757	-26.452414	110	5	1.12	0.95	111.4124	0.3446	0.0000	0.0000;
	2550	2	0	2.2	0	0	1	1.0992296	-25.979024	110	5	1.12	0.95	112.2555	-0.2670	0.0000	0.0000;
	2551	1	8.694	2	0	0	1	1.1053183	-25.120091	110	5	1.12	0.95	111.5537	0.4440	0.0000	0.0000;
	2552	2	16.877	0	0	0	1	1.1012141	-25.356039	110	5	1.12	0.95	111.5494	-0.3037	0.0000	0.0000;
	2553	1	7.671	2	0	0	1	1.106993	-25.03394	110	5	1.12	0.95	110.9074	0.1514	0.0000	0.0000;
	2554	2	18.923	1.4	0	0	1	1.1023372	-25.235483	110	5	1.12	0.95	111.3625	-0.3118	0.0000	0.0000;
	2555	2	17.389	1.6	0	0	1	1.1014606	-25.32694	110	5	1.12	0.95	111.5051	-0.3047	0.0000	0.0000;
	2556	1	5.115	1.8	0	0	1	1.0770037	-19.951434	110	5	1.12	0.95	110.6360	1.1024	0.0000	0.0000;
	2557	1	6.138	2	0	0	1	1.0809472	-31.639915	110	5	1.12	0.95	118.3459	1.2231	0.0000	0.0000;
	2558	1	12.274	2.5	0	0	1	1.0749099	-19.924883	110	5	1.12	0.95	110.8714	1.1697	0.0000	0.0000;
	2559	1	17.389	3.5	0	0	1	1.0793645	-31.882758	110	5	1.12	0.95	118.6021	1.3116	0.0000	0.0000;
	2560	1	4.909	0	0	0	1	1.0904595	-28.476538	110	5	1.12	0.95	115.5397	0.4988	0.0000	0.0000;
	2561	1	11.251	2.5	0	0	1	1.1182716	-23.639327	110	5	1.12	0.95	108.9647	-0.0470	0.0000	0.0000;
	2562	2	130.924	58	0	0	1	1.0828502	-28.3498	110	5	1.12	0.95	114.4497	0.0000	0.0000	0.0000;
	2563	1	6.955	2.3	0	0	1	1.0823771	-26.313141	110	5	1.12	0.95	112.5310	0.3513	0.0000	0.0000;
	2564	1	12.069	1.7	0	0	1	1.0821037	-28.512851	110	5	1.12	0.95	114.6460	0.0129	0.0000	0.0000;
	2565	2	12.274	0.5	0	0	1	1.1009255	-25.330209	110	5	1.12	0.95	111.5702	-0.2961	0.0000	0.0000;
	2566	2	3.478	1	0	0	1	1.1082393	-26.23166	110	5	1.12	0.95	111.4438	-0.9288	0.0000	0.0000;
	2567	1	9.921	3.8	0	0	1	1.0770141	-21.431339	110	5	1.12	0.95	110.1861	1.2317	0.0000	0.0000;
	2568	1	1.023	0.2	0	0	1	1.0793424	-26.31856	110	5	1.12	0.95	112.4987	0.6064	0.0000	0.0000;
	2569	1	11.251	3	0	0	1	1.0866422	-28.809541	110	5	1.12	0.95	114.9839	0.1417	0.0000	0.0000;
	2570	2	15.855	1	0	0	1	1.10446	-24.649581	110	5	1.12	0.95	110.9787	0.1214	0.0000	0.0000;
	2571	2	8.183	1	0	0	1	1.1044579	-24.633633	110	5	1.12	0.95	110.9778	0.1256	0.0000	0.0000;
	2572	1	0.614	0.1	0	0	1	1.1014552	-27.292622	110	5	1.12	0.95	112.8645	-0.0758	0.0000	0.0000;
	2573	1	17.286	4.4	0	0	1	1.0757701	-25.591106	110	5	1.12	0.95	112.9043	0.9900	0.0000	0.0000;
	2574	1	13.398	2.6	0	0	1	1.1139758	-26.145601	110	5	1.12	0.95	111.0274	0.3455	0.0000	0.0000;
	2575	1	12.581	3.5	0	0	1	1.0875277	-22.540593	110	5	1.12	0.95	109.9129	1.0471	0.0000	0.0000;
	2576	2	9.206	2.5	0	0	1	1.0988866	-29.990437	110	5	1.12	0.95	115.2503	0.6295	0.0000	0.0000;
	2577	1	0.716	0.3	0	0	1	1.0980336	-25.79605	110	5	1.12	0.95	111.4473	-0.5203	0.0000	0.0000;
	2578	1	12.581	2.5	0	0	1	1.1013619	-27.100245	110	5	1.12	0.95	112.7305	-0.2824	0.0000	0.0000;
	2579	2	20.968	17	0	0	1	1.0732605	-19.787068	110	5	1.12	0.95	111.0150	1.2090	0.0000	0.0000;
	2580	2	10.638	8	0	0	1	1.0732065	-19.786196	110	5	1.12	0.95	111.0233	1.2085	0.0000	0.0000;
	2581	1	13.501	1.5	0	0	1	1.0777698	-29.492996	110	5	1.12	0.95	116.5041	0.4028	0.0000	0.0000;
	2582	2	11.763	1.2	0	0	1	1.1065995	-26.918904	110	5	1.12	0.95	113.5116	-0.7382	0.0000	0.0000;
	2583	2	12.172	1.4	0	0	1	1.0813624	-28.946702	110	5	1.12	0.95	115.1628	0.0200	0.0000	0.0000;
	2584	1	12.069	2.4	0	0	1	1.1043622	-27.356775	110	5	1.12	0.95	112.7325	0.1857	0.0000	0.0000;
	2585	1	4.602	2.5	0	0	1	1.0915817	-29.251887	110	5	1.12	0.95	115.7545	0.5669	0.0000	0.0000;
	2586	1	2.25	0.9	0	0	1	1.1142903	-25.423035	110	5	1.12	0.95	110.5104	-1.2066	0.0000	0.0000;
	2587	2	12.274	4	0	0	1	1.0847992	-20.130707	110	5	1.12	0.95	109.6181	0.9245	0.0000	0.0000;
	2588	1	16.878	5.5	0	0	1	1.0803537	-31.656811	110	5	1.12	0.95	118.2537	1.2749	0.0000	0.0000;
	2589	1	14.831	3.5	0	0	1	1.0986574	-28.941375	110	5	1.12	0.95	114.9265	0.4351	0.0000	0.0000;
	2590	2	15.854	3.5	0	0	1	1.0710604	-20.103965	110	5	1.12	0.95	111.4304	1.2278	0.0000	0.0000;
	2591	1	12.274	3	0	0	1	1.1105551	-25.9643	110	5	1.12	0.95	111.7028	-0.9205	0.0000	0.0000;
	2592	1	12.786	2	0	0	1	1.0884911	-27.854782	110	5	1.12	0.95	114.5481	0.1637	0.0000	0.0000;
	2593	1	15.547	5.3	0	0	1	1.0797691	-28.627236	110	5	1.12	0.95	115.1778	0.4552	0.0000	0.0000;
	2594	1	9.921	0.2	0	0	1	1.0917594	-28.31661	110	5	1.12	0.95	115.2179	0.5208	0.0000	0.0000;
	2595	1	3.58	1	0	0	1	1.1145561	-23.838458	110	5	1.12	0.95	109.2863	0.0691	0.0000	0.0000;
	2596	1	5.626	1	0	0	1	1.0740801	-19.38974	110	5	1.12	0.95	110.6775	1.2280	0.0000	0.0000;
	2597	2	3.58	0.5	0	0	1	1.1086145	-25.686985	110	5	1.12	0.95	111.8072	-0.4981	0.0000	0.0000;
	2598	1	11.865	2.3	0	0	1	1.0995208	-26.298463	110	5	1.12	0.95	112.4367	0.5210	0.0000	0.0000;
	2599	1	22.912	4.5	0	0	1	1.1089828	-27.029373	110	5	1.12	0.95	112.1375	0.3767	0.0000	0.0000;
	2600	1	0	0	0	0	1	1.1174156	-27.701837	110	5	1.12	0.95	112.6847	0.0161	0.0000	0.0000;
	2601	1	0	0	0	0	1	1.1172774	-27.719717	110	5	1.12	0.95	112.6984	0.0199	0.0000	0.0000;
	2602	1	13.092	2.6	0	0	1	1.1138556	-26.157361	110	5	1.12	0.95	111.0421	0.3484	0.0000	0.0000;
	2603	2	16.365	3	0	0	1	1.1149782	-27.92596	110	5	1.12	0.95	113.0464	0.1636	0.0000	0.0000;
	2604	1	0	0	0	0	1	1.1150011	-27.928003	110	5	1.12	0.95	113.0420	0.1652	0.0000	0.0000;
	2605	1	9.206	2.5	0	0	1	1.0993491	-27.999311	110	5	1.12	0.95	113.9896	0.1366	0.0000	0.0000;
	2606	1	18.923	3.7	0	0	1	1.1169582	-26.04441	110	5	1.12	0.95	110.8231	0.2253	0.0000	0.0000;
	2607	1	21.479	5.5	0	0	1	1.1095948	-28.328313	110	5	1.12	0.95	113.7621	0.3188	0.0000	0.0000;
	2608	1	8.081	1.6	0	0	1	1.1110215	-23.164198	110	5	1.12	0.95	109.2235	0.3048	0.0000	0.0000;
	2609	1	10.228	2	0	0	1	1.1141574	-27.986873	110	5	1.12	0.95	113.1656	0.1885	0.0000	0.0000;
	2610	1	24.036	3.5	0	0	1	1.0967558	-28.870009	110	5	1.12	0.95	114.6685	0.0562	0.0000	0.0000;
	2611	1	5.729	2.6	0	0	1	1.0960848	-28.961146	110	5	1.12	0.95	115.2699	0.4503	0.0000	0.0000;
	2612	1	4.091	0.5	0	0	1	1.1026229	-26.748332	110	5	1.12	0.95	113.6271	-0.5684	0.0000	0.0000;
	2613	1	22.502	4.5	0	0	1	1.1154691	-25.091115	110	5	1.12	0.95	110.6833	-0.9107	0.0000	0.0000;
	2614	1	7.16	2	0	0	1	1.1106681	-28.248753	110	5	1.12	0.95	113.6397	0.2801	0.0000	0.0000;
	2615	2	16.366	4	0	0	1	1.1104737	-28.271872	110	5	1.12	0.95	113.6289	0.2935	0.0000	0.0000;
	2616	2	16.366	2.5	0	0	1	1.1123979	-28.129469	110	5	1.12	0.95	113.4304	0.2185	0.0000	0.0000;
	2617	2	10.228	2	0	0	1	1.0756342	-19.245638	110	5	1.12	0.95	110.4262	1.1979	0.0000	0.0000;
	2618	1	6.137	1.5	0	0	1	1.0756072	-19.238044	110	5	1.12	0.95	110.4301	1.1976	0.0000	0.0000;
	2619	1	20.559	4	0	0	1	1.1152235	-26.337708	110	5	1.12	0.95	111.3349	0.1816	0.0000	0.0000;
	2620	1	0.102	0.1	0	0	1	1.0912343	-28.122897	110	5	1.12	0.95	114.0379	-0.1189	0.0000	0.0000;
	2621	1	3.069	0.5	0	0	1	1.1035188	-24.245031	110	5	1.12	0.95	110.4560	-0.0797	0.0000	0.0000;
	2622	1	11.251	3	0	0	1	1.0928034	-19.872923	110	5	1.12	0.95	108.8408	0.6836	0.0000	0.0000;
	2623	1	12.376	2.5	0	0	1	1.0863959	-29.432252	110	5	1.12	0.95	116.4111	0.6245	0.0000	0.0000;
	2624	1	0	0	0	0	1	1.0864498	-29.429647	110	5	1.12	0.95	116.4053	0.6248	0.0000	0.0000;
	2625	1	2.25	0.4	0	0	1	1.1024148	-27.384914	110	5	1.12	0.95	112.8418	0.1268	0.0000	0.0000;
	2626	1	5.216	1	0	0	1	1.1097055	-26.508661	110	5	1.12	0.95	111.7031	0.4161	0.0000	0.0000;
	2627	1	9.922	1.9	0	0	1	1.1083728	-27.107554	110	5	1.12	0.95	112.2654	0.3712	0.0000	0.0000;
	2628	1	2.148	0.5	0	0	1	1.086306	-29.021656	110	5	1.12	0.95	116.3344	0.5727	0.0000	0.0000;
	2629	1	7.16	1.5	0	0	1	1.0918853	-29.457297	110	5	1.12	0.95	116.4730	-0.5661	0.0000	0.0000;
	2630	1	6.138	1.2	0	0	1	1.1142314	-26.368724	110	5	1.12	0.95	111.2350	0.3188	0.0000	0.0000;
	2631	1	14.524	2.8	0	0	1	1.1107776	-26.825751	110	5	1.12	0.95	111.8486	0.3579	0.0000	0.0000;
	2632	1	7.672	3.2	0	0	1	1.0670135	-26.783296	110	5	1.12	0.95	113.5068	1.2098	0.0000	0.0000;
	2633	1	6.648	1.5	0	0	1	1.0741723	-19.939821	110	5	1.12	0.95	110.8318	1.1889	0.0000	0.0000;
	2634	2	2.659	1.6	0	0	1	1.0910087	-29.096923	110	5	1.12	0.95	115.8491	0.4874	0.0000	0.0000;
	2635	1	3.068	0.5	0	0	1	1.0982144	-26.224984	110	5	1.12	0.95	113.5102	0.0899	0.0000	0.0000;
	2636	1	0.102	0.1	0	0	1	1.0738143	-26.848883	110	5	1.12	0.95	114.3088	0.6756	0.0000	0.0000;
	2637	2	16.365	3.2	0	0	1	1.1112029	-26.74393	110	5	1.12	0.95	111.8377	0.2795	0.0000	0.0000;
	2638	1	8.183	2.5	0	0	1	1.1104794	-25.396474	110	5	1.12	0.95	110.7164	-0.6009	0.0000	0.0000;
	2639	1	9.717	2.5	0	0	1	1.1031987	-25.594623	110	5	1.12	0.95	111.4792	0.2128	0.0000	0.0000;
	2640	1	16.365	4	0	0	1	1.0731776	-19.620178	110	5	1.12	0.95	110.8964	1.2411	0.0000	0.0000;
	2641	2	11.455	2.2	0	0	1	1.1147397	-26.078591	110	5	1.12	0.95	110.9068	0.3466	0.0000	0.0000;
	2642	1	0	0	0	0	1	1.1149672	-26.052581	110	5	1.12	0.95	110.7460	0.3405	0.0000	0.0000;
	2643	1	14.217	2.1	0	0	1	1.0778888	-29.530067	110	5	1.12	0.95	116.6268	0.4421	0.0000	0.0000;
	2644	1	21.684	4.2	0	0	1	1.0973375	-26.73661	110	5	1.12	0.95	113.0776	0.5452	0.0000	0.0000;
	2645	1	25.06	4.9	0	0	1	1.1005281	-25.385204	110	5	1.12	0.95	111.5583	0.5248	0.0000	0.0000;
	2646	1	6.138	1.5	0	0	1	1.0779049	-32.02677	110	5	1.12	0.95	118.8059	1.3523	0.0000	0.0000;
	2647	1	0	0	0	0	1	1.1192949	-23.78225	110	5	1.12	0.95	109.1061	-0.1398	0.0000	0.0000;
	2648	1	25.059	7.1	0	0	1	1.0734371	-26.483242	110	5	1.12	0.95	112.9228	0.9095	0.0000	0.0000;
	2649	1	16.57	3.2	0	0	1	1.101802	-25.739844	110	5	1.12	0.95	111.7442	0.4880	0.0000	0.0000;
	2650	1	4.091	1	0	0	1	1.0815033	-27.350669	110	5	1.12	0.95	116.2377	0.9328	0.0000	0.0000;
	2651	1	21.479	4.5	0	0	1	1.1137021	-24.131922	110	5	1.12	0.95	109.5917	-0.0838	0.0000	0.0000;
	2652	2	13.501	2.6	0	0	1	1.1103146	-26.35041	110	5	1.12	0.95	111.8726	0.1779	0.0000	0.0000;
	2653	1	15.035	4.7	0	0	1	1.0736192	-27.436446	110	5	1.12	0.95	114.7844	0.5770	0.0000	0.0000;
	2654	1	6.035	1.9	0	0	1	1.1166277	-25.283227	110	5	1.12	0.95	110.1815	-1.3317	0.0000	0.0000;
	2655	1	10.229	3.5	0	0	1	1.0762719	-19.649489	110	5	1.12	0.95	110.4646	1.1610	0.0000	0.0000;
	2656	1	8.183	2	0	0	1	1.1159104	-23.71533	110	5	1.12	0.95	109.0910	0.0412	0.0000	0.0000;
	2657	2	33.754	5.5	0	0	1	1.0676211	-31.327501	110	5	1.12	0.95	121.8758	0.0271	0.0000	0.0000;
	2658	2	14.831	1	0	0	1	1.0691437	-31.119554	110	5	1.12	0.95	121.6255	0.0000	0.0000	0.0000;
	2659	2	13.297	2	0	0	1	1.088284	-29.995706	110	5	1.12	0.95	116.9775	-0.5065	0.0000	0.0000;
	2660	1	0	0	0	0	1	1.1038428	-26.001524	110	5	1.12	0.95	112.2082	-0.5729	0.0000	0.0000;
	2661	1	8.694	2	0	0	1	1.0738129	-27.790449	110	5	1.12	0.95	117.4390	1.3386	0.0000	0.0000;
	2662	2	21.479	1	0	0	1	1.1083243	-24.055266	110	5	1.12	0.95	109.6933	0.0467	0.0000	0.0000;
	2663	2	5.626	0	0	0	1	1.1015754	-24.975008	110	5	1.12	0.95	111.2011	-0.1981	0.0000	0.0000;
	2664	1	3.58	0.5	0	0	1	1.065841	-32.171496	110	5	1.12	0.95	122.7279	-0.0792	0.0000	0.0000;
	2665	1	9.615	1.9	0	0	1	1.0699821	-30.012027	110	5	1.12	0.95	119.0242	1.4495	0.0000	0.0000;
	2666	2	4.705	0.9	0	0	1	1.0776808	-29.657238	110	5	1.12	0.95	117.2807	1.2956	0.0000	0.0000;
	2667	2	8.183	0.5	0	0	1	1.1035784	-24.436185	110	5	1.12	0.95	110.4878	-0.0653	0.0000	0.0000;
	2668	1	7.16	1	0	0	1	1.1036431	-24.929941	110	5	1.12	0.95	111.3189	-0.1318	0.0000	0.0000;
	2669	1	0	0	0	0	1	1.1084718	-23.253607	110	5	1.12	0.95	109.0222	0.0913	0.0000	0.0000;
	2670	1	0	0	0	0	1	1.1086121	-23.296378	110	5	1.12	0.95	109.0299	0.0953	0.0000	0.0000;
	2671	2	11.251	0.5	0	0	1	1.1049772	-24.854176	110	5	1.12	0.95	111.1101	-0.1929	0.0000	0.0000;
	2672	1	11.251	0.5	0	0	1	1.1050193	-24.855897	110	5	1.12	0.95	111.1080	-0.1923	0.0000	0.0000;
	2673	1	6.853	2.3	0	0	1	1.1131457	-25.507211	110	5	1.12	0.95	110.6618	-1.1415	0.0000	0.0000;
	2674	1	23.218	4.5	0	0	1	1.1079816	-27.173849	110	5	1.12	0.95	112.3860	0.3507	0.0000	0.0000;
	2675	1	0.921	0.2	0	0	1	1.1121437	-26.765031	110	5	1.12	0.95	111.9149	0.1974	0.0000	0.0000;
	2676	2	26.185	5.1	0	0	1	1.0794184	-29.548587	110	5	1.12	0.95	116.6267	1.3214	0.0000	0.0000;
	2677	2	11.251	1	0	0	1	1.1054028	-24.674624	110	5	1.12	0.95	110.8154	-0.1214	0.0000	0.0000;
	2678	1	0.205	0	0	0	1	1.1117496	-26.596628	110	5	1.12	0.95	111.5963	0.3179	0.0000	0.0000;
	2679	1	21.48	3	0	0	1	1.086953	-28.852633	110	5	1.12	0.95	117.3471	0.7152	0.0000	0.0000;
	2680	1	7.058	1.4	0	0	1	1.0978551	-26.526015	110	5	1.12	0.95	112.8399	0.5394	0.0000	0.0000;
	2681	1	6.137	1.3	0	0	1	1.0979918	-15.680766	110	5	1.12	0.95	106.2747	0.7224	0.0000	0.0000;
	2682	1	8.797	1.7	0	0	1	1.1014782	-27.397371	110	5	1.12	0.95	112.9295	0.0582	0.0000	0.0000;
	2683	1	7.978	0.8	0	0	1	1.083058	-28.990749	110	5	1.12	0.95	115.1889	0.0639	0.0000	0.0000;
	2684	2	51.142	1	0	0	1	1.1105627	-25.365674	110	5	1.12	0.95	110.6991	-0.5718	0.0000	0.0000;
	2685	1	4.705	1.7	0	0	1	1.1158526	-25.293608	110	5	1.12	0.95	110.2857	-1.3041	0.0000	0.0000;
	2686	1	6.138	1.3	0	0	1	1.1077301	-25.500186	110	5	1.12	0.95	111.9045	-0.3820	0.0000	0.0000;
	2687	1	22.4	4.4	0	0	1	1.1035506	-27.350256	110	5	1.12	0.95	112.7189	0.1930	0.0000	0.0000;
	2688	2	43.982	14.1	0	0	1	1.0779117	-26.306244	110	5	1.12	0.95	112.4661	0.7323	0.0000	0.0000;
	2689	1	0	0	0	0	1	1.0780757	-26.288308	110	5	1.12	0.95	112.4533	0.7296	0.0000	0.0000;
	2690	1	6.444	1.3	0	0	1	1.0981534	-26.492814	110	5	1.12	0.95	112.7686	0.5364	0.0000	0.0000;
	2691	1	14.421	4.6	0	0	1	1.0743437	-26.522164	110	5	1.12	0.95	112.8397	0.8625	0.0000	0.0000;
	2692	1	30.685	7.8	0	0	1	1.074602	-26.479959	110	5	1.12	0.95	112.8118	0.8510	0.0000	0.0000;
	2693	2	12.786	4.4	0	0	1	1.0677322	-26.780687	110	5	1.12	0.95	113.4381	1.1596	0.0000	0.0000;
	2694	1	15.752	5.2	0	0	1	1.0643197	-26.654654	110	5	1.12	0.95	113.6659	1.3846	0.0000	0.0000;
	2695	1	10.229	3	0	0	1	1.0805519	-20.35889	110	5	1.12	0.95	110.2160	1.0853	0.0000	0.0000;
	2696	1	15.956	4.4	0	0	1	1.0735633	-26.564228	110	5	1.12	0.95	112.9549	0.8923	0.0000	0.0000;
	2697	1	11.251	3	0	0	1	1.0502198	-29.308777	110	5	1.12	0.95	121.8225	2.0355	0.0000	0.0000;
	2698	1	3.682	1.6	0	0	1	1.0696044	-26.757482	110	5	1.12	0.95	113.2957	1.0698	0.0000	0.0000;
	2699	2	11.251	1	0	0	1	1.1042576	-23.837995	110	5	1.12	0.95	110.0522	-0.0000	0.0000	0.0000;
	2700	1	5.115	0.5	0	0	1	1.1011412	-25.628728	110	5	1.12	0.95	111.8142	-0.2988	0.0000	0.0000;
	2701	1	14.421	5.3	0	0	1	1.0882878	-26.087144	110	5	1.12	0.95	112.3021	0.0013	0.0000	0.0000;
	2702	1	23.013	4.5	0	0	1	1.1037463	-24.598865	110	5	1.12	0.95	110.4824	0.5574	0.0000	0.0000;
	2703	1	22.502	4.4	0	0	1	1.1024272	-24.716406	110	5	1.12	0.95	110.8854	0.5128	0.0000	0.0000;
	2704	2	8.183	0.6	0	0	1	1.1072136	-24.320105	110	5	1.12	0.95	110.4003	0.1581	0.0000	0.0000;
	2705	1	22.093	4.3	0	0	1	1.1007021	-26.903216	110	5	1.12	0.95	112.9226	0.4281	0.0000	0.0000;
	2706	2	35.8	21.8	0	0	1	1.0784699	-24.382785	110	5	1.12	0.95	111.5118	1.2141	0.0000	0.0000;
	2707	1	46.028	30.2	0	0	1	1.0781987	-24.391762	110	5	1.12	0.95	111.5206	1.2187	0.0000	0.0000;
	2708	1	10.74	3	0	0	1	1.106974	-26.228067	110	5	1.12	0.95	111.6319	-0.7754	0.0000	0.0000;
	2709	1	22.912	5.8	0	0	1	1.0741319	-24.286001	110	5	1.12	0.95	111.9908	1.3666	0.0000	0.0000;
	2710	2	16.979	4.1	0	0	1	1.0801296	-23.753449	110	5	1.12	0.95	111.0680	1.1686	0.0000	0.0000;
	2711	2	0	0	0	0	1	1.0800271	-23.771827	110	5	1.12	0.95	111.0746	1.1690	0.0000	0.0000;
	2712	1	18.616	5.2	0	0	1	1.0737995	-24.418675	110	5	1.12	0.95	112.0753	1.3639	0.0000	0.0000;
	2713	1	6.444	1.3	0	0	1	1.1091451	-27.109335	110	5	1.12	0.95	112.3413	0.2790	0.0000	0.0000;
	2714	1	0	0	0	0	1	1.1073069	-28.695541	110	5	1.12	0.95	114.0910	0.4301	0.0000	0.0000;
	2715	1	0	0	0	0	1	1.1035289	-24.244136	110	5	1.12	0.95	110.4545	-0.0799	0.0000	0.0000;
	2716	1	0	0	0	0	1	1.1091677	-27.107506	110	5	1.12	0.95	112.3382	0.2784	0.0000	0.0000;
	2717	1	24.548	4	0	0	1	1.1178341	-23.552463	110	5	1.12	0.95	108.8788	-0.0088	0.0000	0.0000;
	2718	1	2.046	1	0	0	1	1.1178269	-23.509645	110	5	1.12	0.95	108.8299	0.0035	0.0000	0.0000;
	2719	1	13.399	2.6	0	0	1	1.1168199	-26.093043	110	5	1.12	0.95	110.8793	0.2182	0.0000	0.0000;
	2720	1	15.343	3	0	0	1	1.1134559	-26.526775	110	5	1.12	0.95	111.4205	0.3265	0.0000	0.0000;
	2721	1	28.64	5.2	0	0	1	1.0766576	-24.484045	110	5	1.12	0.95	111.8147	1.2672	0.0000	0.0000;
	2722	1	33.754	5.7	0	0	1	1.0765879	-24.497601	110	5	1.12	0.95	111.8207	1.2682	0.0000	0.0000;
	2723	1	9.206	0	0	0	1	1.0629655	-33.530181	110	5	1.12	0.95	123.8136	-0.1177	0.0000	0.0000;
	2724	1	15.956	2.8	0	0	1	1.0849488	-28.987291	110	5	1.12	0.95	116.3805	0.5878	0.0000	0.0000;
	2725	2	20.457	5.7	0	0	1	1.060479	-20.283879	110	5	1.12	0.95	113.1192	1.5676	0.0000	0.0000;
	2726	1	0	0	0	0	1	1.1113484	-23.114224	110	5	1.12	0.95	109.1545	0.3091	0.0000	0.0000;
	2727	1	0	0	0	0	1	1.111353	-23.101479	110	5	1.12	0.95	109.1500	0.3076	0.0000	0.0000;
	2728	2	13.297	4.5	0	0	1	1.0930825	-26.830035	110	5	1.12	0.95	113.3630	0.2567	0.0000	0.0000;
	2729	2	0	0	0	0	1	1.1144112	-26.64157	110	5	1.12	0.95	112.5051	-0.8873	0.0000	0.0000;
	2730	1	0	0	0	0	1	1.1144785	-26.666052	110	5	1.12	0.95	112.5043	-0.8820	0.0000	0.0000;
	2731	1	2.557	0	0	0	1	1.1105406	-27.227072	110	5	1.12	0.95	113.2384	-0.8334	0.0000	0.0000;
	2732	1	308.77	58.253	0	0	0	1.024589	-10.171068	400	0	1.05	0.95	101.3062	0.2792	0.0000	0.0000;
	2733	1	634.064	13.272	0	0	0	1.0318117	-10.095616	400	0	1.05	0.95	101.6395	-0.5097	0.0000	0.0000;
	2734	1	270.638	-4.386	0	0	0	1.096897	-7.9612319	220	0	1.11	0.95	102.0327	0.0513	0.0000	0.0000;
	2735	2	0	0	0	0	0	1.0354197	-6.4805364	400	0	1.05	0.95	99.3850	0.1463	0.0000	0.0000;
	2736	2	0	0	0	0	3	1.1022541	-9.3640024	220	0	1.11	0.95	102.7280	0.0001	0.0000	0.0000;
	2737	1	79.598	28.646	0	0	0	1.1077476	-25.95865	220	0	1.11	0.95	112.3937	0.0356	0.0000	0.0000;
	2738	1	465.184	158.547	0	0	0	1.0194361	-18.344001	400	0	1.05	0.95	105.5286	-0.1372	0.0000	0.0000;
	2739	2	0	0	0	0	0	1.0382852	-19.722478	400	0	1.05	0.95	109.5644	-0.3087	0.0000	0.0000;
	2740	2	0	0	0	0	3	1.12	-12.563351	110	0	1.12	0.95	98.9223	-3.4783	2948.4091	0.0000;
	2741	1	33	12	0	0	2	1.0680686	-9.24212	110	0	1.12	0.95	102.9486	1.4363	0.0000	0.0000;
	2742	1	33	12	0	0	2	1.0680387	-9.2421457	110	0	1.12	0.95	102.9495	1.4367	0.0000	0.0000;
	2743	1	55	13	0	0	2	1.0586709	-18.042505	110	0	1.12	0.95	109.0046	2.7031	0.0000	0.0000;
	2744	1	54	14	0	0	2	1.0566997	-18.225049	110	0	1.12	0.95	109.0821	2.8748	0.0000	0.0000;
	2745	1	25	10	0	0	2	1.0560972	-10.340383	110	0	1.12	0.95	104.4904	1.8814	0.0000	0.0000;
	2746	1	65	26	0	0	2	1.0468764	-10.930355	110	0	1.12	0.95	105.3672	2.2502	0.0000	0.0000;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf	mu_Pmax	mu_Pmin	mu_Qmax	mu_Qmin
mpc.gen = [
	17	140	119.976	120	-10	1.09088	233.2	1	200	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.2486	0.0007	0.0000;
	18	140	43.0475	120	-10	1.09091	233.2	1	200	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.2499	0.0000	0.0000;
	26	370	-10	220	-10	1.09091	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.0840	0.0000	0.0000	0.0000;
	26	360	210.554	220	-10	1.09091	421.9	1	360	290	0	0	0	0	0	0	0	0	0	0	0	22.0840	0.0000	0.0000	0.0000;
	27	360	45.0036	220	-10	1.09091	421.9	1	360	290	0	0	0	0	0	0	0	0	0	0	0	21.7808	0.0000	0.0000	0.0000;
	27	370	219.914	220	-10	1.09091	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	21.7808	0.0000	0.0000	0.0000;
	27	370	-10	220	-10	1.09091	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	21.7808	0.0000	0.0000	0.0000;
	28	370	-10	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.7168	0.0000	0.0000	0.1638;
	28	370	-10	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.7168	0.0000	0.0000	0.1638;
	28	370	-10	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.7168	0.0000	0.0000	0.1638;
	29	370	-10	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.7125	0.0000	0.0000	0.1626;
	29	370	-10	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.7125	0.0000	0.0000	0.1626;
	29	370	-10	220	-10	1.0325	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.7125	0.0000	0.0000	0.1626;
	43	215	119.977	120	-20	1.09091	246.2	1	215	135	0	0	0	0	0	0	0	0	0	0	0	0.8398	0.0000	0.0019	0.0000;
	43	0	0	120	-20	1.09091	275.3	0	247.8	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	43	247.8	20.7197	120	-20	1.09091	275.3	1	247.8	135	0	0	0	0	0	0	0	0	0	0	0	0.8398	0.0000	0.0019	0.0000;
	44	225	-12.294	120	-20	1.09096	255	1	225	135	0	0	0	0	0	0	0	0	0	0	0	0.8301	0.0000	0.0000	0.0000;
	44	225	-2.43726	120	-20	1.09096	255	1	225	135	0	0	0	0	0	0	0	0	0	0	0	0.8301	0.0000	0.0000	0.0000;
	44	0	0	120	-20	1.09096	255	0	225	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	45	0	0	350	-40	1.0325	610.3	0	500	350	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	45	500	22.4277	350	-40	1.0325	610.3	1	500	350	0	0	0	0	0	0	0	0	0	0	0	1.5074	0.0000	0.0000	0.0000;
	55	130	-20	120	-20	1.09121	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.6707	0.0000	0.1306;
	56	130	-20.001	120	-20.001	1.09115	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.6744	0.0000	0.1282;
	56	130	-20.001	120	-20.001	1.09115	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.6744	0.0000	0.1282;
	57	130	-20	120	-20	1.03336	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.3876	0.0000	0.4555;
	58	0	0	120	-20	1.03337	255	0	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	58	130	-20.006	120	-20.006	1.03337	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.3851	0.0000	0.4554;
	58	130	-20.006	120	-20.006	1.03337	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	2.3851	0.0000	0.4554;
	59	78.5	33.64	33.64	0	1.08415	85.4	1	78.5	78.5	0	0	0	0	0	0	0	0	0	0	0	103.6382	0.0000	0.0447	0.0000;
	78	225	8.24513	105	5	1.09091	248.3	1	225	140	0	0	0	0	0	0	0	0	0	0	0	4.1968	0.0000	0.0000	0.0000;
	78	225	105	105	5	1.09091	248.3	1	225	140	0	0	0	0	0	0	0	0	0	0	0	4.1968	0.0000	0.0000	0.0000;
	79	0	0	105	5	1.09034	243.8	0	220	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	79	0	0	105	5	1.09034	248.3	0	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	79	225	16.5743	105	5	1.09034	248.3	1	225	140	0	0	0	0	0	0	0	0	0	0	0	4.3206	0.0000	0.0011	0.0000;
	82	380	-16.9664	192	-37	1.02993	425.8	1	380	220	0	0	0	0	0	0	0	0	0	0	0	9.1708	0.0000	0.0000	0.0000;
	82	370	-4.67553	174	-19	1.02993	408.9	1	370	220	0	0	0	0	0	0	0	0	0	0	0	9.1708	0.0000	0.0000	0.0000;
	104	225	46.9887	113	-48	1.09091	251.8	1	225	134	0	0	0	0	0	0	0	0	0	0	0	6.2905	0.0000	0.0000	0.0000;
	105	225	6.24023	113	-48	1.09091	251.8	1	225	134	0	0	0	0	0	0	0	0	0	0	0	6.2879	0.0000	0.0010	0.0000;
	106	120	71.0379	90	-5	1.09091	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0	5.0412	0.0000	0.0000	0.0000;
	107	120	-4.95126	90	-5	1.09091	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0	5.0431	0.0000	0.0009	0.0000;
	116	0	0	90	-20	1.09042	150	0	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	117	120	16.5064	90	-20	1.09046	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0	2.7658	0.0000	0.0000	0.0000;
	118	110	33	68	33	1.089	129.3	1	110	80	0	0	0	0	0	0	0	0	0	0	0	1.3545	0.0000	0.0000	0.0648;
	125	215	35.04	113	-11	1.09091	242.9	1	215	160	0	0	0	0	0	0	0	0	0	0	0	8.3830	0.0000	0.0000	0.0000;
	126	225	84	84	-5	1.09082	240.2	1	225	140	0	0	0	0	0	0	0	0	0	0	0	8.3860	0.0000	0.0025	0.0000;
	126	0	0	80	-5	1.09082	229.4	0	215	160	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	127	225	-7.498	79	-7.498	1.02869	238.5	1	225	140	0	0	0	0	0	0	0	0	0	0	0	8.8712	0.0000	0.0000	0.6133;
	127	220	-10	100	-10	1.02869	241.7	1	220	160	0	0	0	0	0	0	0	0	0	0	0	8.8712	0.0000	0.0000	0.6133;
	132	125	-3.67769	40	-38	1.09091	131.2	1	125	74	0	0	0	0	0	0	0	0	0	0	0	99.1743	0.0000	0.0000	0.0000;
	132	125	15.9334	40	-38	1.09091	131.2	1	125	74	0	0	0	0	0	0	0	0	0	0	0	99.1743	0.0000	0.0000	0.0000;
	133	0	0	40	-38	1.09091	131.2	0	125	74	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	133	125	16.4325	40	-38	1.09091	131.2	1	125	74	0	0	0	0	0	0	0	0	0	0	0	99.3512	0.0000	0.0000	0.0000;
	134	0	0	90	0	1.08882	150	0	120	102	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	134	120	66.904	90	0	1.08882	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	11.0166	0.0000	0.0000	0.0000;
	135	0	0	90	0	1.08867	150	0	120	102	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	146	50	12	12	0	1.09012	51.4	1	50	30	0	0	0	0	0	0	0	0	0	0	0	8.4261	0.0000	0.0247	0.0000;
	146	50	12	12	0	1.09012	51.4	1	50	30	0	0	0	0	0	0	0	0	0	0	0	8.4261	0.0000	0.0247	0.0000;
	147	0	0	90	0	1.09011	150	0	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	90	37.8554	120	0	1.09091	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.7346	0.0000	0.0000;
	148	0	0	120	0	1.09091	237.5	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	0	0	120	0	1.09091	237.5	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	148	90	0.151315	120	0	1.09091	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.7346	0.0000	0.0000;
	150	90	0	120	0	1.03246	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.7102	0.0000	0.2377;
	151	90	0	120	0	1.0325	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.7134	0.0000	0.2386;
	151	90	0	120	0	1.0325	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.7134	0.0000	0.2386;
	155	235	0.232319	120	0	1.09091	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0	0.1364	0.0000	0.0000	0.0000;
	155	235	11.1041	120	0	1.09091	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0	0.1364	0.0000	0.0000	0.0000;
	155	0	0	120	0	1.09091	237.5	0	205	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	155	261	0	120	0	1.09091	287.3	1	261	104	0	0	0	0	0	0	0	0	0	0	0	0.1364	0.0000	0.0000	0.0000;
	156	0	0	120	0	1.09091	237.5	0	205	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	156	205	12.5903	120	0	1.09091	237.5	1	205	130	0	0	0	0	0	0	0	0	0	0	0	0.7478	0.0000	0.0000	0.0000;
	156	206	10.0689	120	0	1.09091	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0	0.7478	0.0000	0.0000	0.0000;
	156	206	5.87534	120	0	1.09091	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0	0.7478	0.0000	0.0000	0.0000;
	159	206	120	120	0	1.00535	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0	0.5953	0.0000	0.1487	0.0000;
	165	200	-0.009	120	-0.009	1.09084	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	15.6466	0.0000	0.0000	0.0000;
	165	200	9.20043	120	-0.009	1.09084	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	15.6466	0.0000	0.0000	0.0000;
	166	200	119.931	120	0	1.09091	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	15.6572	0.0000	0.0020	0.0000;
	166	200	27.8129	120	0	1.09091	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	15.6572	0.0000	0.0020	0.0000;
	205	179	-54.0932	110	-60	1.0325	210.1	1	179	140	0	0	0	0	0	0	0	0	0	0	0	109.4271	0.0000	0.0004	0.0000;
	205	179	-50.3535	110	-60	1.0325	210.1	1	179	140	0	0	0	0	0	0	0	0	0	0	0	109.4271	0.0000	0.0004	0.0000;
	205	0	0	110	-60	1.0325	210.1	0	179	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	206	179	23.1183	110	-60	1.0325	210.1	1	179	140	0	0	0	0	0	0	0	0	0	0	0	109.4273	0.0000	0.0000	0.0000;
	215	37.079	0	20	0	1.08646	58.5	1	37.079	37.079	0	0	0	0	0	0	0	0	0	0	0	107.6029	0.0000	0.0000	0.0000;
	215	33.708	5.8236	20	0	1.08646	53.9	1	33.708	33.708	0	0	0	0	0	0	0	0	0	0	0	107.6029	0.0000	0.0000	0.0000;
	215	33.708	0	20	0	1.08646	53.9	1	33.708	33.708	0	0	0	0	0	0	0	0	0	0	0	107.6029	0.0000	0.0000	0.0000;
	215	15.506	0	20	0	1.08646	30.5	1	15.506	15.506	0	0	0	0	0	0	0	0	0	0	0	107.6029	0.0000	0.0000	0.0000;
	239	4	8	8	0	1.03337	15.4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	112.9996	0.0000	2.2671	0.0000;
	246	370	89.8042	220	-14	1.03502	430.5	1	370	290	0	0	0	0	0	0	0	0	0	0	0	21.9779	0.0000	0.0000	0.0000;
	291	2	2	2	0	1.06439	3.2	1	2	2	0	0	0	0	0	0	0	0	0	0	0	108.0721	0.0000	1.6229	0.0000;
	294	3	2	2	0	1.05278	4.8	1	3	3	0	0	0	0	0	0	0	0	0	0	0	111.8991	0.0000	1.2777	0.0000;
	306	9.167	7	7	0	1.05332	24	1	9.167	9.167	0	0	0	0	0	0	0	0	0	0	0	103.3043	0.0000	0.9479	0.0000;
	306	16.296	7	7	0	1.05332	27.9	1	16.296	16.296	0	0	0	0	0	0	0	0	0	0	0	103.3043	0.0000	0.9479	0.0000;
	306	11.204	7.616	7.616	6	1.05332	31	1	11.204	11.204	0	0	0	0	0	0	0	0	0	0	0	103.3043	0.0000	0.9479	0.0000;
	306	9.167	7	7	0	1.05332	26.9	1	9.167	9.167	0	0	0	0	0	0	0	0	0	0	0	103.3043	0.0000	0.9479	0.0000;
	306	9.167	7.928	7.928	0	1.05332	28.1	1	9.167	9.167	0	0	0	0	0	0	0	0	0	0	0	103.3043	0.0000	0.9479	0.0000;
	307	36.5	15	15	0	1.05854	57	1	36.5	36.5	0	0	0	0	0	0	0	0	0	0	0	103.3021	0.0000	0.6146	0.0000;
	307	36.5	15	15	0	1.05854	57	1	36.5	36.5	0	0	0	0	0	0	0	0	0	0	0	103.3021	0.0000	0.6146	0.0000;
	308	32	15	15	0	1.067	36.7	1	32	32	0	0	0	0	0	0	0	0	0	0	0	102.6465	0.0000	0.4584	0.0000;
	308	40	17.596	17.596	0	1.067	57.7	1	40	40	0	0	0	0	0	0	0	0	0	0	0	102.6465	0.0000	0.4584	0.0000;
	310	35	20	20	0	1.07303	53.9	1	35	35	0	0	0	0	0	0	0	0	0	0	0	101.5140	0.0000	0.7376	0.0000;
	310	75	27.247	27.247	0	1.07303	103.6	1	75	75	0	0	0	0	0	0	0	0	0	0	0	101.5140	0.0000	0.7376	0.0000;
	311	45	40	40	0	1.06272	64	1	45	45	0	0	0	0	0	0	0	0	0	0	0	101.8647	0.0000	0.5093	0.0000;
	362	37.8	12	12	0	1.08888	47.8	1	37.8	37.8	0	0	0	0	0	0	0	0	0	0	0	107.3954	0.0000	0.5000	0.0000;
	363	37.8	12	12	0	1.06039	47.8	1	37.8	37.8	0	0	0	0	0	0	0	0	0	0	0	109.5339	0.0000	1.5579	0.0000;
	364	37.8	11.8318	12	0	1.1049	47.8	1	37.8	37.8	0	0	0	0	0	0	0	0	0	0	0	106.0017	0.0000	0.0000	0.0000;
	364	45	7.03822	12	0	1.1049	71	1	45	45	0	0	0	0	0	0	0	0	0	0	0	106.0017	0.0000	0.0000	0.0000;
	365	37.8	12	12	0	1.06981	47.8	1	37.8	37.8	0	0	0	0	0	0	0	0	0	0	0	108.6493	0.0000	1.5359	0.0000;
	365	37.8	12	12	0	1.06981	47.8	1	37.8	37.8	0	0	0	0	0	0	0	0	0	0	0	108.6493	0.0000	1.5359	0.0000;
	382	15	0.0149313	10	0	1.08182	55.9	1	55	15	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.9334	0.0000	0.0000;
	382	120	84.8598	120	-10	1.08182	255.9	1	226	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.9334	0.0000	0.0000;
	383	15	0	10	0	1.10054	55.9	1	55	15	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.2065	0.0000	0.1108;
	386	3	2	2	0	1.05805	4.8	1	3	3	0	0	0	0	0	0	0	0	0	0	0	104.2076	0.0000	0.5520	0.0000;
	421	4	4	4	0	1.04857	7.7	1	4	4	0	0	0	0	0	0	0	0	0	0	0	110.1731	0.0000	2.1108	0.0000;
	431	7	5.90765	8	0	1.08943	13.6	1	7	7	0	0	0	0	0	0	0	0	0	0	0	109.5608	0.0000	0.0000	0.0000;
	440	2.5	2	2	0	1.0288	3.6	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	101.3275	0.0000	0.7112	0.0000;
	447	3.5	17.0797	20	0	1.0498	21.3	1	3.5	3.5	0	0	0	0	0	0	0	0	0	0	0	109.2894	0.0000	0.0000	0.0000;
	447	3.5	0.691168	20	0	1.0498	21.3	1	3.5	3.5	0	0	0	0	0	0	0	0	0	0	0	109.2894	0.0000	0.0000	0.0000;
	463	0	2	2	0	1.0465	4	1	0	0	0	0	0	0	0	0	0	0	0	0	0	111.1153	0.0000	0.2129	0.0000;
	482	1.4	0.7	0.7	0	1.02656	1.7	1	1.4	1.4	0	0	0	0	0	0	0	0	0	0	0	102.0959	0.0000	0.8760	0.0000;
	490	3.5	3	3	0	1.05535	5.3	1	3.5	3.5	0	0	0	0	0	0	0	0	0	0	0	108.2075	0.0000	1.9900	0.0000;
	522	0	0	1	0	1.06929	1.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	101.7872	0.0000	0.0000	0.2246;
	533	0.5	1	1	0	1.07198	1.9	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	108.8685	0.0000	1.0847	0.0000;
	534	35.89	14	14	0	1.06429	53.9	1	35.89	35.89	0	0	0	0	0	0	0	0	0	0	0	107.9674	0.0000	1.4176	0.0000;
	534	22.086	14	14	0	1.06429	34.9	1	22.086	22.086	0	0	0	0	0	0	0	0	0	0	0	107.9674	0.0000	1.4176	0.0000;
	534	22.086	14	14	0	1.06429	34.9	1	22.086	22.086	0	0	0	0	0	0	0	0	0	0	0	107.9674	0.0000	1.4176	0.0000;
	534	72.469	24.001	24.001	0	1.06429	107.7	1	72.469	72.469	0	0	0	0	0	0	0	0	0	0	0	107.9674	0.0000	1.4176	0.0000;
	534	72.469	24.001	24.001	0	1.06429	107.7	1	72.469	72.469	0	0	0	0	0	0	0	0	0	0	0	107.9674	0.0000	1.4176	0.0000;
	535	24.573	17.5	17.5	0	1.05783	36.5	1	24.573	24.573	0	0	0	0	0	0	0	0	0	0	0	107.8909	0.0000	1.6074	0.0000;
	535	23.805	17.5	17.5	0	1.05783	35.6	1	23.805	23.805	0	0	0	0	0	0	0	0	0	0	0	107.8909	0.0000	1.6074	0.0000;
	535	95.99	28.002	28.002	0	1.05783	128.1	1	95.99	95.99	0	0	0	0	0	0	0	0	0	0	0	107.8909	0.0000	1.6074	0.0000;
	535	80.631	28.002	28.002	0	1.05783	108.7	1	80.631	80.631	0	0	0	0	0	0	0	0	0	0	0	107.8909	0.0000	1.6074	0.0000;
	549	1.4	0.7	0.7	0	1.0394	1.7	1	1.4	1.4	0	0	0	0	0	0	0	0	0	0	0	110.3849	0.0000	2.7098	0.0000;
	557	25.724	5.052	5.052	0	1.04037	34.4	1	25.724	25.724	0	0	0	0	0	0	0	0	0	0	0	109.7380	0.0000	2.7262	0.0000;
	557	21.184	5.052	5.052	0	1.04037	28.5	1	21.184	21.184	0	0	0	0	0	0	0	0	0	0	0	109.7380	0.0000	2.7262	0.0000;
	557	19.671	5	5	0	1.04037	26.5	1	19.671	19.671	0	0	0	0	0	0	0	0	0	0	0	109.7380	0.0000	2.7262	0.0000;
	557	22.697	5.052	5.052	0	1.04037	30.4	1	22.697	22.697	0	0	0	0	0	0	0	0	0	0	0	109.7380	0.0000	2.7262	0.0000;
	557	25.724	5.052	5.052	0	1.04037	34.4	1	25.724	25.724	0	0	0	0	0	0	0	0	0	0	0	109.7380	0.0000	2.7262	0.0000;
	558	31.032	5.064	5.064	0	1.03685	34.4	1	31.032	31.032	0	0	0	0	0	0	0	0	0	0	0	109.7338	0.0000	2.7695	0.0000;
	558	31.032	5.064	5.064	0	1.03685	34.4	1	31.032	31.032	0	0	0	0	0	0	0	0	0	0	0	109.7338	0.0000	2.7695	0.0000;
	558	22.817	5	5	0	1.03685	26.5	1	22.817	22.817	0	0	0	0	0	0	0	0	0	0	0	109.7338	0.0000	2.7695	0.0000;
	558	30.119	5.064	5.064	0	1.03685	34.4	1	30.119	30.119	0	0	0	0	0	0	0	0	0	0	0	109.7338	0.0000	2.7695	0.0000;
	594	2.58	1.35	1.35	0	1.06495	4.5	1	2.58	2.58	0	0	0	0	0	0	0	0	0	0	0	107.2664	0.0000	0.0405	0.0000;
	601	5.05	2.24	2.24	0	1.06191	5.5	1	5.05	5.05	0	0	0	0	0	0	0	0	0	0	0	107.4639	0.0000	0.1573	0.0000;
	622	110	5.34319	30	0	1.0778	114	1	110	110	0	0	0	0	0	0	0	0	0	0	0	104.0950	0.0000	0.0000	0.0000;
	622	0	0	30	0	1.0778	65.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	626	2.8	0	1.12	0	1.07287	3	1	2.8	2.8	0	0	0	0	0	0	0	0	0	0	0	104.7709	0.0000	0.0000	0.0510;
	630	5.61	1.79205	3.14	0	1.06945	6.4	1	5.61	5.61	0	0	0	0	0	0	0	0	0	0	0	107.4721	0.0000	0.0013	0.0000;
	631	6.73	1.9289	3.14	0	1.06942	7.4	1	6.73	6.73	0	0	0	0	0	0	0	0	0	0	0	107.4263	0.0000	0.0001	0.0000;
	655	1.23	0.45	0.45	0	1.03169	1.3	1	1.23	1.23	0	0	0	0	0	0	0	0	0	0	0	108.3971	0.0000	0.5878	0.0000;
	660	135	44.7218	120	-20	1.08206	255	1	225	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.2973	0.0003	0.0000;
	661	135	38.2967	120	-20	1.08182	255	1	225	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.2933	0.0000	0.0000;
	667	1.91	1.01	1.01	0	1.03727	2.2	1	1.91	1.91	0	0	0	0	0	0	0	0	0	0	0	107.3682	0.0000	0.3096	0.0000;
	671	9.53	0	3.36	0	1.06812	10.1	1	9.53	9.53	0	0	0	0	0	0	0	0	0	0	0	107.1164	0.0000	0.0000	0.1078;
	673	3.36	1.12	1.12	0	1.06495	4.4	1	3.36	3.36	0	0	0	0	0	0	0	0	0	0	0	103.6981	0.0000	0.0168	0.0000;
	681	190	0	30	0	1.08024	192.4	1	190	190	0	0	0	0	0	0	0	0	0	0	0	103.8516	0.0000	0.0000	0.0759;
	681	24.998	0	30	0	1.08024	77.5	1	24.998	24.998	0	0	0	0	0	0	0	0	0	0	0	103.8516	0.0000	0.0000	0.0759;
	687	11.21	0	5.61	0	1.07512	12.5	1	11.21	11.21	0	0	0	0	0	0	0	0	0	0	0	104.6035	0.0000	0.0000	0.0758;
	699	6.73	0	3.36	0	1.0746	7.5	1	6.73	6.73	0	0	0	0	0	0	0	0	0	0	0	104.9331	0.0000	0.0000	0.0030;
	702	1.12	0.400483	1.12	0	1.0721	1.6	1	1.12	1.12	0	0	0	0	0	0	0	0	0	0	0	103.9180	0.0000	0.0016	0.0000;
	712	10	4	4	0	1.07103	10.8	1	10	10	0	0	0	0	0	0	0	0	0	0	0	103.2569	0.0000	0.2418	0.0000;
	718	1.57	1.12	1.12	0	1.03111	1.9	1	1.57	1.57	0	0	0	0	0	0	0	0	0	0	0	108.4955	0.0000	0.6479	0.0000;
	722	2.8	1.12	1.12	0	1.06069	3	1	2.8	2.8	0	0	0	0	0	0	0	0	0	0	0	107.3366	0.0000	0.1394	0.0000;
	731	1.68	0.56	0.56	0	1.06199	4.3	1	1.68	1.68	0	0	0	0	0	0	0	0	0	0	0	105.0460	0.0000	0.1633	0.0000;
	736	130	-1.98744	120	-20	1.08182	255	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.7628	0.0000	0.0000;
	740	2.24	0	0	0	1.06599	4.3	1	2.24	2.24	0	0	0	0	0	0	0	0	0	0	0	104.0360	0.0000	0.1510	0.0000;
	747	5.83	0.996481	3.36	0	1.04853	6.7	1	5.83	5.83	0	0	0	0	0	0	0	0	0	0	0	108.3433	0.0000	0.0000	0.0000;
	759	90	0	30	0	1.0699	105.2	1	90	90	0	0	0	0	0	0	0	0	0	0	0	103.0227	0.0000	0.0000	0.0969;
	760	0	0	0	0	1.06824	1.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	778	12.34	5.04875	30	0	1.05918	32.4	1	12.34	12.34	0	0	0	0	0	0	0	0	0	0	0	104.9867	0.0000	0.0000	0.0000;
	780	1.68	0.9	0.9	0	1.07776	1.9	1	1.68	1.68	0	0	0	0	0	0	0	0	0	0	0	104.0981	0.0000	0.0000	0.0003;
	783	6	0	3	0	1.07336	6.7	1	6	6	0	0	0	0	0	0	0	0	0	0	0	105.0189	0.0000	0.0000	0.0445;
	788	2	1	1	0	1.04756	95.9	1	2	2	0	0	0	0	0	0	0	0	0	0	0	106.0440	0.0000	0.0268	0.0000;
	792	68	2.71865	23	0	1.05369	71.8	1	68	0	0	0	0	0	0	0	0	0	0	0	0	104.9367	0.0000	0.0000	0.0000;
	792	0	0	23	0	1.05369	71.8	0	68	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	792	0	0	11	0	1.05369	23.7	0	21	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	792	0	0	10	0	1.05369	23.3	0	21	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	803	0	-0.002	10	-0.002	1.08195	55.9	1	55	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.2443	0.0000	0.1110;
	804	0	10	10	0	1.07278	120.4	1	120	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.6029	0.0329	0.0000;
	809	0	0	0	0	1.07004	3.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	815	3.36	0	2.02	0	1.07164	3.9	1	3.36	3.36	0	0	0	0	0	0	0	0	0	0	0	107.1130	0.0000	0.0000	0.0595;
	834	1.12	0	0	0	1.05238	1.5	1	1.12	1.12	0	0	0	0	0	0	0	0	0	0	0	105.9599	0.0000	0.3467	0.0000;
	840	30	8.1	8.1	0	1.05932	51.6	1	30	30	0	0	0	0	0	0	0	0	0	0	0	103.6599	0.0000	0.2636	0.0000;
	840	30	8.1	8.1	0	1.05932	51.6	1	30	30	0	0	0	0	0	0	0	0	0	0	0	103.6599	0.0000	0.2636	0.0000;
	844	1.9	0.45	0.45	0	1.07659	3.5	1	1.9	1.9	0	0	0	0	0	0	0	0	0	0	0	99.4756	0.0000	0.1390	0.0000;
	848	3.01	0	0	0	1.05907	5.6	1	3.01	3.01	0	0	0	0	0	0	0	0	0	0	0	101.8848	0.0000	0.7220	0.0000;
	854	7	1.35	1.35	0	1.06201	14.6	1	7	7	0	0	0	0	0	0	0	0	0	0	0	101.2757	0.0000	0.8021	0.0000;
	873	68	15.6845	41.2	0	1.08182	87.7	1	68	68	0	0	0	0	0	0	0	0	0	0	0	98.2406	0.0000	0.0000	0.0000;
	876	0	0	0	0	1.0397	1.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	896	0	0	45	-10	1.06882	65.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	896	0	0	45	-10	1.06882	71.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	896	55	45	45	-10	1.06882	71.1	1	55	55	0	0	0	0	0	0	0	0	0	0	0	100.5192	0.0000	0.1987	0.0000;
	902	0.111	0	0	0	1.0143	0.3	1	0.111	0.111	0	0	0	0	0	0	0	0	0	0	0	109.5441	0.0000	1.2633	0.0000;
	903	0	0	0	0	1.01428	2.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	952	2.6	0.6	0.6	0	1.06079	3	1	2.6	2.6	0	0	0	0	0	0	0	0	0	0	0	103.3417	0.0000	0.1705	0.0000;
	958	0	0	0	0	1.04967	2.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	972	27	5.21474	32	5	1.08182	54	1	27	27	0	0	0	0	0	0	0	0	0	0	0	98.6627	0.0000	0.0000	0.0000;
	972	0	0	32	5	1.08182	42.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	972	3	1.21277	7	1	1.08182	11.4	1	3	3	0	0	0	0	0	0	0	0	0	0	0	98.6627	0.0000	0.0000	0.0000;
	972	80	37.7001	110	-40	1.08182	162.2	1	80	80	0	0	0	0	0	0	0	0	0	0	0	98.6627	0.0000	0.0000	0.0000;
	973	80	34.0164	110	-40	1.081	162.2	1	80	80	0	0	0	0	0	0	0	0	0	0	0	98.8641	0.0000	0.0000	0.0000;
	977	13.511	3.438	3.438	0	1.07617	13.9	1	13.511	13.511	0	0	0	0	0	0	0	0	0	0	0	99.5236	0.0000	0.4439	0.0000;
	986	5.1	1.2	1.2	0	1.06838	10.3	1	5.1	5.1	0	0	0	0	0	0	0	0	0	0	0	100.5243	0.0000	0.4563	0.0000;
	998	386	138.351	172	-59	1.08182	422.6	1	386	220	0	0	0	0	0	0	0	0	0	0	0	8.3482	0.0000	0.0000	0.0000;
	999	370	128.821	172	-59	1.08182	408	1	370	220	0	0	0	0	0	0	0	0	0	0	0	8.3673	0.0000	0.0000	0.0000;
	1002	14.999	3.447	3.447	0	1.07543	17.9	1	14.999	14.999	0	0	0	0	0	0	0	0	0	0	0	99.3287	0.0000	0.4157	0.0000;
	1004	110	32.3109	110	-40	1.08182	174.1	1	110	110	0	0	0	0	0	0	0	0	0	0	0	98.3878	0.0000	0.0000	0.0000;
	1007	1	0.15	0.15	0	1.05246	2.5	1	1	1	0	0	0	0	0	0	0	0	0	0	0	104.3781	0.0000	0.4706	0.0000;
	1010	25.011	4.8	4.8	0	1.07605	51.7	1	25.011	25.011	0	0	0	0	0	0	0	0	0	0	0	99.7431	0.0000	0.1650	0.0000;
	1012	20	2.998	2.998	0	1.07258	32.9	1	20	20	0	0	0	0	0	0	0	0	0	0	0	100.1896	0.0000	0.3372	0.0000;
	1021	20	18	18	9	1.07091	30	1	20	20	0	0	0	0	0	0	0	0	0	0	0	101.1905	0.0000	0.1737	0.0000;
	1022	19.998	18	18	9	1.07091	30	1	19.998	19.998	0	0	0	0	0	0	0	0	0	0	0	101.1863	0.0000	0.1737	0.0000;
	1023	19.998	14	14	10.498	1.07084	32.2	1	19.998	19.998	0	0	0	0	0	0	0	0	0	0	0	101.1893	0.0000	0.1746	0.0000;
	1076	1	0	0	0	1.04784	3.2	1	1	1	0	0	0	0	0	0	0	0	0	0	0	103.5395	0.0000	0.4197	0.0000;
	1108	1	0	0	0	1.03858	3	1	1	1	0	0	0	0	0	0	0	0	0	0	0	105.6046	0.0000	0.2895	0.0000;
	1110	0	0	37.5	16.8	1.0762	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1111	0	0	37.5	7.5	1.07209	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1111	50	37.5	37.5	7.5	1.07209	62.5	1	50	50	0	0	0	0	0	0	0	0	0	0	0	99.8191	0.0000	0.0027	0.0000;
	1112	0	0	37.5	16.8	1.0749	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1114	4	0	0	0	1.07459	7.6	1	4	4	0	0	0	0	0	0	0	0	0	0	0	99.1063	0.0000	0.1567	0.0000;
	1129	6.999	0	1.65	0	1.07939	7.9	1	6.999	6.999	0	0	0	0	0	0	0	0	0	0	0	99.9954	0.0000	0.0000	0.4292;
	1151	20	5.251	5.251	0	1.06903	36.4	1	20	20	0	0	0	0	0	0	0	0	0	0	0	101.8651	0.0000	0.0583	0.0000;
	1152	25	5.251	5.251	0	1.06926	55.3	1	25	25	0	0	0	0	0	0	0	0	0	0	0	101.8255	0.0000	0.0564	0.0000;
	1153	20	5.25	5.25	0	1.07173	36.4	1	20	20	0	0	0	0	0	0	0	0	0	0	0	101.3782	0.0000	0.0795	0.0000;
	1178	0	0	42	16.8	1.08155	65.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1178	0	0	42	16.8	1.08155	65.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1178	60	27.9301	52.5	0	1.08155	87.5	1	60	60	0	0	0	0	0	0	0	0	0	0	0	98.4789	0.0000	0.0000	0.0000;
	1179	60	10.4256	52.5	0	1.08009	87.5	1	60	60	0	0	0	0	0	0	0	0	0	0	0	99.2113	0.0000	0.0000	0.0000;
	1179	45	42	42	16.8	1.08009	65.3	1	45	45	0	0	0	0	0	0	0	0	0	0	0	99.2113	0.0000	0.0000	0.0000;
	1187	9.999	4	4	0	1.07567	22.4	1	9.999	9.999	0	0	0	0	0	0	0	0	0	0	0	99.2364	0.0000	0.0831	0.0000;
	1187	9.999	4	4	0	1.07567	50.2	1	9.999	9.999	0	0	0	0	0	0	0	0	0	0	0	99.2364	0.0000	0.0831	0.0000;
	1188	7.01	1.648	1.648	0	1.07815	9.4	1	7.01	7.01	0	0	0	0	0	0	0	0	0	0	0	98.7141	0.0000	0.0400	0.0000;
	1226	1	0.3	0.3	0	1.03771	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	106.9314	0.0000	0.4813	0.0000;
	1245	25	0	0	0	1.05668	53.2	1	25	25	0	0	0	0	0	0	0	0	0	0	0	101.1239	0.0000	0.7031	0.0000;
	1246	15	0	0	0	1.06963	31.2	1	15	15	0	0	0	0	0	0	0	0	0	0	0	100.2662	0.0000	0.2133	0.0000;
	1247	5	0	0	0	1.06049	11.6	1	5	5	0	0	0	0	0	0	0	0	0	0	0	101.6871	0.0000	0.6789	0.0000;
	1279	4.5	1.5	1.5	0	1.07062	5.7	1	4.5	4.5	0	0	0	0	0	0	0	0	0	0	0	100.0944	0.0000	0.4227	0.0000;
	1285	50	41	41	-6.5	1.07109	68.6	1	50	50	0	0	0	0	0	0	0	0	0	0	0	100.6391	0.0000	0.3641	0.0000;
	1286	230	86.9512	113	-48	1.08182	256.3	1	230	134	0	0	0	0	0	0	0	0	0	0	0	5.3975	0.0000	0.0000	0.0000;
	1287	225	113	113	-48	1.08164	251.8	1	225	134	0	0	0	0	0	0	0	0	0	0	0	6.2121	0.0000	0.0624	0.0000;
	1296	0.2	0	0	0	1.05518	0.5	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	101.8359	0.0000	0.5427	0.0000;
	1330	2.011	0	0	0	1.02889	3.5	1	2.011	2.011	0	0	0	0	0	0	0	0	0	0	0	106.1350	0.0000	1.2513	0.0000;
	1341	15	0	0	0	1.05157	32	1	15	15	0	0	0	0	0	0	0	0	0	0	0	102.1150	0.0000	0.6864	0.0000;
	1342	15	0	0	0	1.05156	34	1	15	15	0	0	0	0	0	0	0	0	0	0	0	102.1152	0.0000	0.6865	0.0000;
	1350	0	0	90	-5	1.08182	142.1	0	110	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1350	120	-5	90	-5	1.08182	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0	4.9992	0.0000	0.0000	0.0114;
	1351	120	11.0157	90	-5	1.08182	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0	4.4640	0.0000	0.0000	0.0000;
	1352	0	0	90	-5	1.08208	150	0	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1362	125	66.4578	85	-21	1.08182	151.2	1	125	84	0	0	0	0	0	0	0	0	0	0	0	5.6407	0.0000	0.0000	0.0000;
	1362	125	85	85	-21	1.08182	151.2	1	125	84	0	0	0	0	0	0	0	0	0	0	0	5.6407	0.0000	0.0000	0.0000;
	1373	90	55.3497	80	-25	1.07336	141.7	1	90	90	0	0	0	0	0	0	0	0	0	0	0	101.3958	0.0000	0.0000	0.0000;
	1373	90	-21.5292	80	-25	1.07336	128.1	1	90	90	0	0	0	0	0	0	0	0	0	0	0	101.3958	0.0000	0.0000	0.0000;
	1374	90	36.9631	80	-25	1.07346	143.4	1	90	90	0	0	0	0	0	0	0	0	0	0	0	101.3914	0.0000	0.0000	0.0000;
	1375	90	45.6106	80	-25	1.06982	136	1	90	90	0	0	0	0	0	0	0	0	0	0	0	102.1324	0.0000	0.0000	0.0000;
	1415	0	0	33.5	12	1.07071	36.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1416	0	0	41.2	-13.7	1.07309	68.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1416	55	-13.7	41.2	-13.7	1.07309	68.7	1	55	55	0	0	0	0	0	0	0	0	0	0	0	100.8451	0.0000	0.0000	0.0406;
	1429	2	0	0	0	1.03432	4.5	1	2	2	0	0	0	0	0	0	0	0	0	0	0	103.9656	0.0000	1.6712	0.0000;
	1433	14.999	0	0	0	1.06274	20	1	14.999	14.999	0	0	0	0	0	0	0	0	0	0	0	101.3528	0.0000	0.7636	0.0000;
	1434	4	1	1	0	1.05913	4.1	1	4	4	0	0	0	0	0	0	0	0	0	0	0	101.0815	0.0000	0.8378	0.0000;
	1435	13.999	6.75	6.75	0	1.06873	30.8	1	13.999	13.999	0	0	0	0	0	0	0	0	0	0	0	100.5096	0.0000	0.6077	0.0000;
	1436	13.999	6.75	6.75	0	1.07073	19.9	1	13.999	13.999	0	0	0	0	0	0	0	0	0	0	0	100.3259	0.0000	0.5432	0.0000;
	1440	225	67.7659	105	5	1.08182	248.3	1	225	140	0	0	0	0	0	0	0	0	0	0	0	2.9233	0.0000	0.0000	0.0000;
	1444	3	1	1	0	1.0759	3.2	1	3	3	0	0	0	0	0	0	0	0	0	0	0	99.1763	0.0000	0.1812	0.0000;
	1462	46	14.9167	35	-6	1.05055	57.8	1	46	3	0	0	0	0	0	0	0	0	0	0	0	105.4159	0.0000	0.0000	0.0000;
	1462	0	0	35	-6	1.05055	57.8	0	46	3	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1462	1	0.152073	0.419	0	1.05055	2.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	105.4259	0.0000	0.0000	0.0000;
	1494	0.4	0	0	0	1.03727	0.8	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	105.8965	0.0000	0.2637	0.0000;
	1518	0	0	0	0	1.06183	2.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1519	0.3	0	0	0	1.06186	0.9	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	101.3033	0.0000	0.2525	0.0000;
	1520	2.011	0	0	0	1.03584	4.7	1	2.011	2.011	0	0	0	0	0	0	0	0	0	0	0	106.1379	0.0000	0.2872	0.0000;
	1521	3	0	0	0	1.03584	6.4	1	3	3	0	0	0	0	0	0	0	0	0	0	0	106.1382	0.0000	0.2872	0.0000;
	1543	1.8	0.4	0.4	0	1.0679	3	1	1.8	1.8	0	0	0	0	0	0	0	0	0	0	0	102.3683	0.0000	0.0401	0.0000;
	1546	3.2	0.8	0.8	0	1.05601	3.3	1	3.2	3.2	0	0	0	0	0	0	0	0	0	0	0	101.4287	0.0000	0.9147	0.0000;
	1547	3.2	0.8	0.8	0	1.05921	3.3	1	3.2	3.2	0	0	0	0	0	0	0	0	0	0	0	101.4098	0.0000	0.9465	0.0000;
	1580	1	0	0	0	1.01083	2.3	1	1	1	0	0	0	0	0	0	0	0	0	0	0	109.8413	0.0000	1.4047	0.0000;
	1594	1	0.09	0.09	0	1.05234	2.5	1	1	1	0	0	0	0	0	0	0	0	0	0	0	105.3554	0.0000	0.6081	0.0000;
	1647	11.999	7.90052	9.3	1.9	1.051	16.8	1	11.999	11.999	0	0	0	0	0	0	0	0	0	0	0	105.6886	0.0000	0.0000	0.0000;
	1647	11.999	2.07679	9.3	1.9	1.051	16.8	1	11.999	11.999	0	0	0	0	0	0	0	0	0	0	0	105.6886	0.0000	0.0000	0.0000;
	1647	0	0	9.3	1.9	1.051	16.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1647	0	0	9.3	2	1.051	16.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1647	1.2	0.0669994	1.644	0	1.051	8.2	1	1.2	1.2	0	0	0	0	0	0	0	0	0	0	0	105.6886	0.0000	0.0000	0.0000;
	1675	153	50.0841	115	-70	1.08182	191.4	1	153	55	0	0	0	0	0	0	0	0	0	0	0	1.7333	0.0000	0.0000	0.0000;
	1676	0	0	90	-20	1.08182	156.5	0	128	70	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1676	153	26.5642	115	-70	1.08182	191.4	1	153	55	0	0	0	0	0	0	0	0	0	0	0	2.3985	0.0000	0.0000	0.0000;
	1677	0	0	90	5	1.07956	152.4	0	123	70	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1687	110	51.8348	55	33	1.07109	123	1	110	80	0	0	0	0	0	0	0	0	0	0	0	2.2643	0.0000	0.0000	0.0000;
	1687	0.3	0.0597469	0.605	0	1.07109	1.7	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	101.7843	0.0000	0.0000	0.0000;
	1688	0	0	42	16.8	1.07082	61.6	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1688	0	0	55	33	1.07082	123	0	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1688	0	0	42	16.8	1.07082	61.6	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1688	110	45.9332	68	33	1.07082	129.3	1	110	80	0	0	0	0	0	0	0	0	0	0	0	2.4310	0.0000	0.0000	0.0000;
	1688	45	16.3382	40	16	1.07082	60.2	1	45	30	0	0	0	0	0	0	0	0	0	0	0	2.4310	0.0000	0.0000	0.0000;
	1742	0.4	0.154	0.154	0	1.03613	0.5	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	107.2333	0.0000	0.6699	0.0000;
	1749	1	0	0	0	1.0531	2.5	1	1	1	0	0	0	0	0	0	0	0	0	0	0	101.8747	0.0000	0.9731	0.0000;
	1760	2.7	1	1	0	1.06925	2.9	1	2.7	2.7	0	0	0	0	0	0	0	0	0	0	0	99.7866	0.0000	0.4235	0.0000;
	1774	4.3	0.901	0.901	0	1.08082	8.5	1	4.3	4.3	0	0	0	0	0	0	0	0	0	0	0	98.3734	0.0000	0.0068	0.0000;
	1779	0	0	6.6	0.7	1.07004	8.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1798	15	0	5.25	0	1.08429	25.8	1	15	15	0	0	0	0	0	0	0	0	0	0	0	100.0993	0.0000	0.0000	1.3841;
	1799	32	26	26	13	1.06944	47.7	1	32	32	0	0	0	0	0	0	0	0	0	0	0	99.9387	0.0000	0.3147	0.0000;
	1841	0	0	83	-5	1.08182	239.8	0	225	160	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1841	225	74.9121	113	-11	1.08182	251.8	1	225	140	0	0	0	0	0	0	0	0	0	0	0	6.8043	0.0000	0.0000	0.0000;
	1843	225	76	76	-8	1.08133	237.5	1	225	160	0	0	0	0	0	0	0	0	0	0	0	7.8189	0.0000	0.2912	0.0000;
	1847	3.2	0	0.75	0	1.08378	3.6	1	3.2	3.2	0	0	0	0	0	0	0	0	0	0	0	100.1320	0.0000	0.0000	1.3629;
	1849	0.5	0.15	0.15	0	1.05074	6.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	104.8450	0.0000	0.3983	0.0000;
	1852	3.011	0.765	0.765	0	1.07681	5.1	1	3.011	3.011	0	0	0	0	0	0	0	0	0	0	0	99.2799	0.0000	0.1531	0.0000;
	1865	3.6	0.75	0.75	0	1.03598	12	1	3.6	3.6	0	0	0	0	0	0	0	0	0	0	0	107.2564	0.0000	0.6724	0.0000;
	1877	0	0	26	13	1.06856	43.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1877	0	0	8.3	1.5	1.06856	11.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1878	20	5.8	12	5.8	1.07254	27.7	1	20	20	0	0	0	0	0	0	0	0	0	0	0	100.9678	0.0000	0.0000	0.2126;
	1878	19.998	10.963	26	10.963	1.07254	39.7	1	19.998	19.998	0	0	0	0	0	0	0	0	0	0	0	100.9678	0.0000	0.0000	0.2126;
	1885	1	0	0	0	1.0771	1.8	1	1	1	0	0	0	0	0	0	0	0	0	0	0	98.7919	0.0000	0.0914	0.0000;
	1911	15	7.199	7.199	0	1.05998	32.8	1	15	15	0	0	0	0	0	0	0	0	0	0	0	101.2220	0.0000	0.7488	0.0000;
	1912	15	7.199	7.199	0	1.05993	32.8	1	15	15	0	0	0	0	0	0	0	0	0	0	0	101.2256	0.0000	0.7492	0.0000;
	1930	9.999	2.4	2.4	0	1.04471	21.1	1	9.999	9.999	0	0	0	0	0	0	0	0	0	0	0	103.7196	0.0000	1.0964	0.0000;
	1932	120	16.3921	90	0	1.08182	150	1	120	102	0	0	0	0	0	0	0	0	0	0	0	8.2835	0.0000	0.0000	0.0000;
	1933	120	64.9808	90	0	1.08182	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	10.5525	0.0000	0.0000	0.0000;
	1969	50	15	15	0	1.07636	52.2	1	50	50	0	0	0	0	0	0	0	0	0	0	0	101.2561	0.0000	0.6418	0.0000;
	1969	0	0	15	0	1.07636	52.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1970	30	10.001	10.001	0	1.07328	33.5	1	30	30	0	0	0	0	0	0	0	0	0	0	0	101.9103	0.0000	0.5751	0.0000;
	1996	90	62.8223	120	0	1.08182	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	3.6397	0.0000	0.0000;
	2002	26.1	8	8	0	1.0804	27.3	1	26.1	0	0	0	0	0	0	0	0	0	0	0	0	109.7131	0.0000	1.2469	0.0000;
	2002	27.3	8.172	8.172	0	1.0804	28.5	1	27.3	0	0	0	0	0	0	0	0	0	0	0	0	109.7131	0.0000	1.2469	0.0000;
	2002	0	0	8	0	1.0804	27.3	0	26.1	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2006	40	10.5184	20.335	0	1.07164	58.6	1	40	40	0	0	0	0	0	0	0	0	0	0	0	111.4765	0.0000	0.0000	0.0000;
	2006	90	79.9176	80	0	1.07164	128.1	1	90	90	0	0	0	0	0	0	0	0	0	0	0	111.4765	0.0000	0.0000	0.0000;
	2007	100	85.9252	90	0	1.07136	150.4	1	100	100	0	0	0	0	0	0	0	0	0	0	0	111.4979	0.0000	0.0000	0.0000;
	2019	25	10	10	0	1.08182	30.2	1	25	25	0	0	0	0	0	0	0	0	0	0	0	110.8259	0.0000	1.0071	0.0000;
	2019	0	0	10	0	1.08182	30.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2019	50	12	12	0	1.08182	55.8	1	50	50	0	0	0	0	0	0	0	0	0	0	0	110.8259	0.0000	1.0071	0.0000;
	2020	5	2.003	2.003	0	1.07576	5.4	1	5	5	0	0	0	0	0	0	0	0	0	0	0	111.8641	0.0000	1.0311	0.0000;
	2020	0	0	2	0	1.07576	6.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2046	120	90	90	0	1.08091	150	1	120	90	0	0	0	0	0	0	0	0	0	0	0	8.0776	0.0000	0.0767	0.0000;
	2068	0	0	1	0	1.0521	3.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2068	4	2	2	0	1.0521	4.5	1	4	4	0	0	0	0	0	0	0	0	0	0	0	107.7622	0.0000	0.5763	0.0000;
	2095	50	12	12	0	1.08091	51.4	1	50	25	0	0	0	0	0	0	0	0	0	0	0	8.0518	0.0000	0.0789	0.0000;
	2095	50	12	12	0	1.08091	51.4	1	50	30	0	0	0	0	0	0	0	0	0	0	0	8.0518	0.0000	0.0789	0.0000;
	2096	28	10	10	0	1.08183	29.7	1	28	20	0	0	0	0	0	0	0	0	0	0	0	9.3853	0.0000	0.2527	0.0000;
	2098	55	12	12	0	1.03199	56.3	1	55	30	0	0	0	0	0	0	0	0	0	0	0	8.4066	0.0000	0.0850	0.0000;
	2218	200	65.423	120	0	1.08182	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	13.7525	0.0000	0.0000	0.0000;
	2219	200	53.2837	120	0	1.08182	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0	16.4735	0.0000	0.0000	0.0000;
	2257	50.1	15.001	15.001	0	1.07394	66.7	1	50.1	50.1	0	0	0	0	0	0	0	0	0	0	0	115.1140	0.0000	0.5673	0.0000;
	2258	50	15	15	0	1.07396	66.7	1	50	50	0	0	0	0	0	0	0	0	0	0	0	115.1157	0.0000	0.5679	0.0000;
	2334	25	15	15	0	1.07375	58	1	25	25	0	0	0	0	0	0	0	0	0	0	0	115.1706	0.0000	0.5062	0.0000;
	2334	0	0	6	0	1.07375	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2334	0	0	2	0	1.07375	4.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2349	98.3629	76.1412	120	0	1.08182	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2360	44.8	14.2226	15	0	1.08182	52.2	1	44.8	44.8	0	0	0	0	0	0	0	0	0	0	0	99.9850	0.0000	0.0000	0.0000;
	2360	70	33.7051	80	0	1.08182	128.1	1	70	70	0	0	0	0	0	0	0	0	0	0	0	99.9850	0.0000	0.0000	0.0000;
	2361	80	54.0281	80	0	1.08182	128.1	1	80	80	0	0	0	0	0	0	0	0	0	0	0	101.0392	0.0000	0.0000	0.0000;
	2438	10	10	10	0	1.08182	14.5	1	10	10	0	0	0	0	0	0	0	0	0	0	0	108.8196	0.0000	1.1464	0.0000;
	2438	10	10	10	0	1.08182	15.6	1	10	10	0	0	0	0	0	0	0	0	0	0	0	108.8196	0.0000	1.1464	0.0000;
	2458	39.294	0.0497695	15	0	1.1181	52.2	1	39.294	39.294	0	0	0	0	0	0	0	0	0	0	0	108.8222	0.0000	0.0000	0.0000;
	2458	43.224	0.87039	1	0	1.1181	55	1	43.224	43.224	0	0	0	0	0	0	0	0	0	0	0	108.8222	0.0000	0.0000	0.0000;
	2458	57.482	0.753623	1	0	1.1181	57.5	1	57.482	57.482	0	0	0	0	0	0	0	0	0	0	0	108.8222	0.0000	0.0000	0.0000;
	2459	21.458	3.5186	5	0	1.11811	55.2	1	21.458	21.458	0	0	0	0	0	0	0	0	0	0	0	108.8204	0.0000	0.0000	0.0000;
	2459	28.538	0.117237	1	0	1.11811	32	1	28.538	28.538	0	0	0	0	0	0	0	0	0	0	0	108.8204	0.0000	0.0000	0.0000;
	2478	50	10	10	0	1.10904	55.9	1	50	50	0	0	0	0	0	0	0	0	0	0	0	111.7249	0.0000	0.4513	0.0000;
	2479	50	10	10	0	1.10892	55.9	1	50	50	0	0	0	0	0	0	0	0	0	0	0	111.7358	0.0000	0.4505	0.0000;
	2491	0.9	0	0.1	0	1.11489	0.9	1	0.9	0.9	0	0	0	0	0	0	0	0	0	0	0	111.8328	0.0000	0.0000	0.3210;
	2496	0.4	0	3.3	0	1.11765	11.5	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	110.8458	0.0000	0.0000	0.1774;
	2508	0	0	1	0	1.1185	22	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2508	55	10	10	0	1.1185	55.9	1	55	55	0	0	0	0	0	0	0	0	0	0	0	111.2918	0.0000	0.3019	0.0000;
	2508	55	10	10	0	1.1185	55.9	1	55	55	0	0	0	0	0	0	0	0	0	0	0	111.2918	0.0000	0.3019	0.0000;
	2509	50	10	10	0	1.12179	55.9	1	50	50	0	0	0	0	0	0	0	0	0	0	0	110.7684	0.0000	0.1973	0.0000;
	2509	50	10	10	0	1.12179	55.9	1	50	50	0	0	0	0	0	0	0	0	0	0	0	110.7684	0.0000	0.1973	0.0000;
	2579	16.5	16.5	16.5	0	1.03332	23.3	1	16.5	16.5	0	0	0	0	0	0	0	0	0	0	0	111.0150	0.0000	1.2090	0.0000;
	2580	7.5	8	8	0	1.03327	11.5	1	7.5	7.5	0	0	0	0	0	0	0	0	0	0	0	111.0233	0.0000	1.2085	0.0000;
	2590	0	2.5	2.5	0	1.03102	2.5	1	0	0	0	0	0	0	0	0	0	0	0	0	0	111.4304	0.0000	1.2278	0.0000;
	2617	0	0	0	0	1.0358	1.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.4262	0.0000	1.1979	0.0000;
	2637	3.9	0	0	0	1.11521	3.9	1	3.9	3.9	0	0	0	0	0	0	0	0	0	0	0	111.8377	0.0000	0.2795	0.0000;
	2710	12.75	2	2	0	1.06077	25.1	1	12.75	12.75	0	0	0	0	0	0	0	0	0	0	0	111.0680	0.0000	1.1686	0.0000;
	2710	12.75	2	2	0	1.06077	25.1	1	12.75	12.75	0	0	0	0	0	0	0	0	0	0	0	111.0680	0.0000	1.1686	0.0000;
	2710	12.75	2	2	0	1.06077	25.1	1	12.75	12.75	0	0	0	0	0	0	0	0	0	0	0	111.0680	0.0000	1.1686	0.0000;
	2710	12.75	2	2	0	1.06077	25.1	1	12.75	12.75	0	0	0	0	0	0	0	0	0	0	0	111.0680	0.0000	1.1686	0.0000;
	2711	0	0	2	0	1.06074	25.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2711	0	0	2	0	1.06074	25.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2729	0	0	22	8	1.11813	54.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2729	0	0	22	8	1.11813	54.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2729	0	0	22	-2.5	1.11813	54.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	219	1.7	6	6	0	1.04401	6.2	1	1.7	1.7	0	0	0	0	0	0	0	0	0	0	0	112.3679	0.0000	1.5862	0.0000;
	221	0.5	1	1	0	1.06307	1.1	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	103.9522	0.0000	1.5232	0.0000;
	222	0.5	0.2	0.2	0	1.04886	0.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	104.6575	0.0000	0.0483	0.0000;
	223	0	1	1	0	1.05723	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	109.6738	0.0000	1.7235	0.0000;
	229	6.5	5	5	0	1.06367	8.2	1	6.5	6.5	0	0	0	0	0	0	0	0	0	0	0	103.1419	0.0000	0.5625	0.0000;
	230	6.5	5	5	0	1.06392	8.2	1	6.5	6.5	0	0	0	0	0	0	0	0	0	0	0	103.1379	0.0000	0.5598	0.0000;
	299	6	0	5	0	1.08358	7.8	1	6	6	0	0	0	0	0	0	0	0	0	0	0	108.7371	0.0000	0.0000	0.1596;
	319	2.5	3	3	0	1.07001	3.9	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	101.8157	0.0000	0.8166	0.0000;
	345	1.5	1	1	0	1.04796	1.8	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	112.3142	0.0000	1.2420	0.0000;
	368	1.5	1	1	0	1.07107	1.8	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	112.6460	0.0000	0.3449	0.0000;
	395	1.5	1	1	0	1.06558	1.8	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	108.9058	0.0000	1.4237	0.0000;
	426	3.1	3	3	0	1.07431	4.3	1	3.1	3.1	0	0	0	0	0	0	0	0	0	0	0	101.2521	0.0000	0.8344	0.0000;
	449	14	0	4	0	1.05503	14.6	1	14	14	0	0	0	0	0	0	0	0	0	0	0	107.7719	0.0000	0.0000	0.0999;
	569	3	0	4	0	1.06309	5	1	3	3	0	0	0	0	0	0	0	0	0	0	0	102.8329	0.0000	0.0000	0.3538;
	581	4	3	3	0	1.0494	5	1	4	4	0	0	0	0	0	0	0	0	0	0	0	112.5024	0.0000	1.3177	0.0000;
	1003	5.934	0.709	0.709	0.709	1.07543	6	1	5.934	5.934	0	0	0	0	0	0	0	0	0	0	0	99.3293	0.0000	0.4156	0.0000;
	1032	0.002	0.002	0.002	0.002	1.07866	0	1	0.002	0.002	0	0	0	0	0	0	0	0	0	0	0	99.3051	0.0000	0.0896	0.0000;
	1949	2.5	0	0	0	1.07317	2.5	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	100.6174	0.0000	0.4124	0.0000;
	1952	2.5	0	0	0	1.07251	2.5	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	103.0956	0.0000	0.7771	0.0000;
	1962	0.6	0	0	0	1.08502	0.6	1	0.6	0.6	0	0	0	0	0	0	0	0	0	0	0	98.9256	0.0000	0.0548	0.0000;
	1967	0.2	0	0	0	1.05972	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	105.7195	0.0000	0.6339	0.0000;
	2012	1.9	0	0	0	1.03086	1.9	1	1.9	1.9	0	0	0	0	0	0	0	0	0	0	0	123.6485	0.0000	1.4787	0.0000;
	2016	3.5	0	0	0	1.051	3.5	1	3.5	3.5	0	0	0	0	0	0	0	0	0	0	0	112.8195	0.0000	0.8260	0.0000;
	2018	3.8	0	0	0	1.04212	3.8	1	3.8	3.8	0	0	0	0	0	0	0	0	0	0	0	112.1405	0.0000	2.4959	0.0000;
	2032	3.8	0	0	0	1.03305	3.8	1	3.8	3.8	0	0	0	0	0	0	0	0	0	0	0	112.0992	0.0000	2.5517	0.0000;
	2040	24	0	0	0	1.05578	24	1	24	24	0	0	0	0	0	0	0	0	0	0	0	108.4013	0.0000	2.7646	0.0000;
	2044	8	0	0	0	1.06127	8	1	8	8	0	0	0	0	0	0	0	0	0	0	0	104.7777	0.0000	1.2737	0.0000;
	2051	3.2	0	0	0	1.07001	3.2	1	3.2	3.2	0	0	0	0	0	0	0	0	0	0	0	103.1438	0.0000	1.0648	0.0000;
	2059	4.6	0	0	0	1.04574	4.6	1	4.6	4.6	0	0	0	0	0	0	0	0	0	0	0	108.5091	0.0000	1.7356	0.0000;
	2061	2	0	0	0	1.04949	2	1	2	2	0	0	0	0	0	0	0	0	0	0	0	116.5388	0.0000	0.0000	0.0720;
	2063	2	0	0	0	1.05712	2	1	2	2	0	0	0	0	0	0	0	0	0	0	0	105.3639	0.0000	1.3740	0.0000;
	2067	0.7	0	0	0	1.07198	0.7	1	0.7	0.7	0	0	0	0	0	0	0	0	0	0	0	102.9785	0.0000	1.1007	0.0000;
	2072	3.8	0	0	0	1.04986	3.8	1	3.8	3.8	0	0	0	0	0	0	0	0	0	0	0	113.2874	0.0000	1.4011	0.0000;
	2075	0.3	0	0	0	1.05826	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	106.0108	0.0000	0.6973	0.0000;
	2083	12	0	0	0	1.04244	12	1	12	12	0	0	0	0	0	0	0	0	0	0	0	109.5234	0.0000	3.5225	0.0000;
	2101	6	0	0	0	1.04605	6	1	6	6	0	0	0	0	0	0	0	0	0	0	0	108.3903	0.0000	3.3653	0.0000;
	2123	3.9	0	0	0	1.04855	3.9	1	3.9	3.9	0	0	0	0	0	0	0	0	0	0	0	118.4282	0.0000	0.7136	0.0000;
	2128	4.2	0	0	0	1.04323	4.2	1	4.2	4.2	0	0	0	0	0	0	0	0	0	0	0	108.5462	0.0000	2.0910	0.0000;
	2136	2	0	0	0	1.04786	2	1	2	2	0	0	0	0	0	0	0	0	0	0	0	106.8408	0.0000	1.6112	0.0000;
	2145	2.8	0	0	0	1.0758	2.8	1	2.8	2.8	0	0	0	0	0	0	0	0	0	0	0	100.4634	0.0000	0.2841	0.0000;
	2180	2.2	0	0	0	1.06795	2.2	1	2.2	2.2	0	0	0	0	0	0	0	0	0	0	0	102.6377	0.0000	0.8240	0.0000;
	2181	0.2	0	0	0	1.07336	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	115.1787	0.0000	0.5950	0.0000;
	2206	1.6	0	0	0	1.04968	1.6	1	1.6	1.6	0	0	0	0	0	0	0	0	0	0	0	116.6500	0.0000	0.0000	0.1173;
	2207	0.5	0	0	0	1.04865	0.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	102.7774	0.0000	0.7300	0.0000;
	2209	7	0	0	0	1.05717	7	1	7	7	0	0	0	0	0	0	0	0	0	0	0	113.6043	0.0000	1.0182	0.0000;
	2212	3.8	0	0	0	1.06636	3.8	1	3.8	3.8	0	0	0	0	0	0	0	0	0	0	0	103.8134	0.0000	1.5157	0.0000;
	2231	2.5	0	0	0	1.06151	2.5	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	112.4597	0.0000	0.6623	0.0000;
	2232	0.4	0	0	0	1.05098	0.4	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	115.1009	0.0000	0.4232	0.0000;
	2239	19	0	0	0	0.99231	19	1	19	19	0	0	0	0	0	0	0	0	0	0	0	114.2808	0.0000	0.4536	0.0000;
	2269	5	0	0	0	1.07639	5	1	5	5	0	0	0	0	0	0	0	0	0	0	0	101.1190	0.0000	0.6576	0.0000;
	2277	3	0	0	0	1.01011	3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	118.3426	0.0000	3.1312	0.0000;
	2281	10	0	0	0	1.01323	10	1	10	10	0	0	0	0	0	0	0	0	0	0	0	125.8696	0.0000	2.0144	0.0000;
	2284	8	0	0	0	1.04758	8	1	8	8	0	0	0	0	0	0	0	0	0	0	0	102.8446	0.0000	1.7721	0.0000;
	2297	2	0	0	0	1.07266	2	1	2	2	0	0	0	0	0	0	0	0	0	0	0	115.1277	0.0000	0.6412	0.0000;
	2299	0.9	0	0	0	1.0814	0.9	1	0.9	0.9	0	0	0	0	0	0	0	0	0	0	0	101.6401	0.0000	0.9360	0.0000;
	2300	0.7	0	0	0	1.07214	0.7	1	0.7	0.7	0	0	0	0	0	0	0	0	0	0	0	112.6246	0.0000	0.9926	0.0000;
	2302	1.5	0	0	0	1.07181	1.5	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	105.9479	0.0000	0.4793	0.0000;
	2304	4	0	0	0	1.06581	4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	103.3096	0.0000	0.8693	0.0000;
	2308	2.5	0	0	0	1.04692	2.5	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	115.8066	0.0000	0.8679	0.0000;
	2312	5	0	0	0	1.02597	5	1	5	5	0	0	0	0	0	0	0	0	0	0	0	115.8551	0.0000	2.3654	0.0000;
	2314	3.7	0	0	0	1.0241	3.7	1	3.7	3.7	0	0	0	0	0	0	0	0	0	0	0	116.2869	0.0000	2.2383	0.0000;
	2315	4	0	0	0	1.06976	4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	102.4217	0.0000	0.5752	0.0000;
	2325	3.6	0	0	0	1.07332	3.6	1	3.6	3.6	0	0	0	0	0	0	0	0	0	0	0	102.7477	0.0000	0.9958	0.0000;
	2332	3.9	0	0	0	1.05511	3.9	1	3.9	3.9	0	0	0	0	0	0	0	0	0	0	0	107.5665	0.0000	0.5725	0.0000;
	2337	0.5	0	0	0	1.02946	0.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	124.0385	0.0000	1.4631	0.0000;
	2366	14.5	0	0	0	1.08283	14.5	1	14.5	14.5	0	0	0	0	0	0	0	0	0	0	0	101.4211	0.0000	0.8997	0.0000;
	2372	4.6	0	0	0	1.08166	4.6	1	4.6	4.6	0	0	0	0	0	0	0	0	0	0	0	102.4001	0.0000	1.1590	0.0000;
	2376	0.7	0	0	0	1.07318	0.7	1	0.7	0.7	0	0	0	0	0	0	0	0	0	0	0	102.0286	0.0000	0.3436	0.0000;
	2386	1.5	0	0	0	1.04505	1.5	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	111.4548	0.0000	2.5274	0.0000;
	2445	1	0	0	0	1.04422	1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	116.5347	0.0000	0.8197	0.0000;
	2446	5	0	0	0	1.04948	5	1	5	5	0	0	0	0	0	0	0	0	0	0	0	108.7028	0.0000	3.0844	0.0000;
	2455	0.8	0	0	0	1.11825	0.8	1	0.8	0.8	0	0	0	0	0	0	0	0	0	0	0	111.1414	0.0000	0.3185	0.0000;
	2461	0.1	0	2.6	0	1.1165	2.6	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	112.2073	0.0000	0.0000	0.5318;
	2462	0	0	0.91	0	1.11651	0.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	112.2084	0.0000	0.0000	0.5320;
	2467	1.6	0.2	0.2	0	1.08649	1.6	1	1.6	1.6	0	0	0	0	0	0	0	0	0	0	0	116.3210	0.0000	0.5564	0.0000;
	2475	0.3	0	2.4	0	1.11163	2.4	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	113.6018	0.0000	0.0000	0.5383;
	2480	4.5	0.9	0.9	0	1.06103	4.6	1	4.5	4.5	0	0	0	0	0	0	0	0	0	0	0	113.0377	0.0000	0.9521	0.0000;
	2489	0.2	1.2	1.2	0	1.01677	1.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	129.7235	0.0000	2.7240	0.0000;
	2490	0.3	0	0.1	0	1.11163	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	111.2836	0.0000	0.0000	0.0105;
	2499	24	6	6	0	1.08665	24.7	1	24	24	0	0	0	0	0	0	0	0	0	0	0	116.2785	0.0000	0.5818	0.0000;
	2505	5.4	0	1.6	0	1.11455	5.6	1	5.4	5.4	0	0	0	0	0	0	0	0	0	0	0	112.5822	0.0000	0.0000	0.4204;
	2517	0	1.2	1.2	0	1.02922	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	111.7483	0.0000	1.2459	0.0000;
	2519	0	0	2	0	1.11529	2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	112.4760	0.0000	0.0000	0.3840;
	2522	2.5	1.9	1.9	0	1.06734	3.1	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	112.4518	0.0000	0.7164	0.0000;
	2531	0	0	1.4	0	1.10749	1.4	1	0	0	0	0	0	0	0	0	0	0	0	0	0	115.0403	0.0000	0.0000	0.7235;
	2534	12.5	0	4.5	0	1.11476	13.3	1	12.5	12.5	0	0	0	0	0	0	0	0	0	0	0	109.8629	0.0000	0.0000	0.2972;
	2537	30	23	23	0	1.03967	37.8	1	30	30	0	0	0	0	0	0	0	0	0	0	0	109.7199	0.0000	1.1274	0.0000;
	2544	25	4	4	0	1.10649	25.3	1	25	25	0	0	0	0	0	0	0	0	0	0	0	111.2233	0.0000	0.3553	0.0000;
	2549	7	0	0	0	1.11603	7	1	7	7	0	0	0	0	0	0	0	0	0	0	0	111.4124	0.0000	0.3446	0.0000;
	2550	0	0	1.2	0	1.11482	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	112.2555	0.0000	0.0000	0.2670;
	2552	0	0	3.6	0	1.11639	3.6	1	0	0	0	0	0	0	0	0	0	0	0	0	0	111.5494	0.0000	0.0000	0.3037;
	2554	0.5	0	3.6	0	1.11711	3.6	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	111.3625	0.0000	0.0000	0.3118;
	2555	1.8	0	1.8	0	1.11649	2.5	1	1.8	1.8	0	0	0	0	0	0	0	0	0	0	0	111.5051	0.0000	0.0000	0.3047;
	2562	57	30.3555	51	0	1.09032	76.5	1	57	57	0	0	0	0	0	0	0	0	0	0	0	114.4497	0.0000	0.0000	0.0000;
	2565	0	0	1.1	0	1.11614	1.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	111.5702	0.0000	0.0000	0.2961;
	2566	1.5	0	0.2	0	1.10697	1.5	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	111.4438	0.0000	0.0000	0.9288;
	2570	0.1	1.7	1.7	0	1.11164	1.7	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	110.9787	0.0000	0.1214	0.0000;
	2571	0	0.8	0.8	0	1.11169	0.8	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.9778	0.0000	0.1256	0.0000;
	2576	0.3	0.1	0.1	0	1.09301	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	115.2503	0.0000	0.6295	0.0000;
	2582	0.4	0	1.8	0	1.11366	1.8	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	113.5116	0.0000	0.0000	0.7382;
	2583	0	1.1	1.1	0	1.08594	1.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	115.1628	0.0000	0.0200	0.0000;
	2587	0	0.8	0.8	0	1.0451	0.8	1	0	0	0	0	0	0	0	0	0	0	0	0	0	109.6181	0.0000	0.9245	0.0000;
	2597	0.5	0	0.1	0	1.11584	0.5	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	111.8072	0.0000	0.0000	0.4981;
	2603	0.2	0	0	0	1.10887	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	113.0464	0.0000	0.1636	0.0000;
	2615	2.5	0.3	0.3	0	1.10442	2.5	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	113.6289	0.0000	0.2935	0.0000;
	2616	12	3	3	0	1.10645	12.4	1	12	12	0	0	0	0	0	0	0	0	0	0	0	113.4304	0.0000	0.2185	0.0000;
	2634	0.1	0.1	0.1	0	1.08913	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	115.8491	0.0000	0.4874	0.0000;
	2641	13.4	0	0	0	1.11892	13.4	1	13.4	13.4	0	0	0	0	0	0	0	0	0	0	0	110.9068	0.0000	0.3466	0.0000;
	2652	1.2	0	0	0	1.1151	1.2	1	1.2	1.2	0	0	0	0	0	0	0	0	0	0	0	111.8726	0.0000	0.1779	0.0000;
	2657	0	1.9	1.9	0	1.05853	1.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	121.8758	0.0000	0.0271	0.0000;
	2658	0	1.77032	2	0	1.06006	2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	121.6255	0.0000	0.0000	0.0000;
	2659	0	0	1.2	0	1.09723	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	116.9775	0.0000	0.0000	0.5065;
	2662	0.7	4.8	4.8	0	1.11845	4.9	1	0.7	0.7	0	0	0	0	0	0	0	0	0	0	0	109.6933	0.0000	0.0467	0.0000;
	2663	0	0	1.2	0	1.11611	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	111.2011	0.0000	0.0000	0.1981;
	2666	0.1	0	0	0	1.08198	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	117.2807	0.0000	1.2956	0.0000;
	2667	0	0	1.4	0	1.11666	1.4	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.4878	0.0000	0.0000	0.0653;
	2671	0	0	3.9	0	1.11471	3.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	111.1101	0.0000	0.0000	0.1929;
	2676	3.7	0	0	0	1.08374	3.7	1	3.7	3.7	0	0	0	0	0	0	0	0	0	0	0	116.6267	0.0000	1.3214	0.0000;
	2677	0	0	2.3	0	1.11536	2.3	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.8154	0.0000	0.0000	0.1214;
	2684	32	0	0	0	1.10943	32	1	32	32	0	0	0	0	0	0	0	0	0	0	0	110.6991	0.0000	0.0000	0.5718;
	2688	16.6	8.3	8.3	0	1.06715	18.6	1	16.6	16.6	0	0	0	0	0	0	0	0	0	0	0	112.4661	0.0000	0.7323	0.0000;
	2693	4.3	0.9	0.9	0	1.0558	4.4	1	4.3	4.3	0	0	0	0	0	0	0	0	0	0	0	113.4381	0.0000	1.1596	0.0000;
	2699	0	0.322441	1.2	0	1.11596	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.0522	0.0000	0.0000	0.0000;
	2704	0.1	1.2	1.2	0	1.11419	1.2	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	110.4003	0.0000	0.1581	0.0000;
	2706	22.8	12	12	0	1.06216	25.8	1	22.8	22.8	0	0	0	0	0	0	0	0	0	0	0	111.5118	0.0000	1.2141	0.0000;
	2725	2.7	2.8	2.8	0	1.01991	3.9	1	2.7	2.7	0	0	0	0	0	0	0	0	0	0	0	113.1192	0.0000	1.5676	0.0000;
	2728	6.7	2	2	0	1.09239	7	1	6.7	6.7	0	0	0	0	0	0	0	0	0	0	0	113.3630	0.0000	0.2567	0.0000;
	383	6.275	10.538	10.538	10.538	1.10054	12.3	1	6.275	6.275	0	0	0	0	0	0	0	0	0	0	0	109.5735	0.0000	0.0000	0.1108;
	1012	2.384	0.943	0.943	0.943	1.07258	2.6	1	2.384	2.384	0	0	0	0	0	0	0	0	0	0	0	100.1896	0.0000	0.3372	0.0000;
	2019	9.647	13.288	13.288	13.288	1.08182	16.4	1	9.647	9.647	0	0	0	0	0	0	0	0	0	0	0	110.8259	0.0000	1.0071	0.0000;
	2095	0.024	7.81	7.81	7.81	1.08091	7.8	1	0.024	0.024	0	0	0	0	0	0	0	0	0	0	0	104.4718	0.0000	0.0789	0.0000;
	2438	5.196	-1.442	-1.442	-1.442	1.08182	5.4	1	5.196	5.196	0	0	0	0	0	0	0	0	0	0	0	108.8196	0.0000	1.1464	0.0000;
	2732	0	0	0	0	1.01	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	101.3062	0.0000	0.2792	0.0000;
	2733	0	0	0	0	1.0175	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	101.6395	0.0000	0.0000	0.5097;
	2734	0	0	0	0	1.077	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	102.0327	0.0000	0.0513	0.0000;
	2735	175.274	0	0	-45.745	1.005	175.3	1	175.274	175.274	0	0	0	0	0	0	0	0	0	0	0	99.3850	0.0000	0.1463	0.0000;
	2736	125	0.836445	120	0	1.09091	173.3	1	125	125	0	0	0	0	0	0	0	0	0	0	0	102.7280	0.0000	0.0000	0.0000;
	2737	0	0	0	0	1.08864	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	112.3937	0.0000	0.0356	0.0000;
	2738	0	0	0	0	1.005	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	105.5286	0.0000	0.0000	0.1372;
	2739	400	0	0	0	1.04437	400	1	400	400	0	0	0	0	0	0	0	0	0	0	0	109.5644	0.0000	0.0000	0.3087;
	2740	120	0	3.62	0	1.1	120.1	1	120	120	0	0	0	0	0	0	0	0	0	0	0	98.9223	0.0000	0.0000	3.4783;
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax	Pf	Qf	Pt	Qt	mu_Sf	mu_St	mu_angmin	mu_angmax
mpc.branch = [
	7	8	0.00064	0.0305	0	400	400	400	1.0435	-0.6	1	-360	360	-252.5909	-29.0796	252.9920	48.1971	0.0000	0.0000	0.0000	0.0000;
	26	28	0.00036	0.02519	0	500	500	500	1.0565	0	1	-360	360	-18.8306	19.5216	18.8330	-19.3537	0.0000	0.0000	0.0000	0.0000;
	27	29	0.00036	0.02519	0	500	500	500	1.0566	0	1	-360	360	111.9773	18.2096	-111.9353	-15.2717	0.0000	0.0000	0.0000	0.0000;
	40	42	0.00034	0.02097	0	500	500	500	1.068	0	1	-360	360	30.7556	-48.6741	-30.7451	49.3246	0.0000	0.0000	0.0000	0.0000;
	43	46	0.00034	0.02097	0	500	500	500	1.0569	0	1	-360	360	72.0962	7.4679	-72.0800	-6.4692	0.0000	0.0000	0.0000	0.0000;
	55	57	0.00081	0.03	0	400	400	400	1.0765	0	1	-360	360	45.4647	-74.1132	-45.4064	76.2752	0.0000	0.0000	0.0000	0.0000;
	90	92	0.00075	0.02444	-0.00832	330	330	330	1.0631	0	1	-360	360	-126.3921	-22.6948	126.5069	27.3378	0.0000	0.0000	0.0000	0.0000;
	91	93	0.00075	0.02469	-0.008	330	330	330	1.0632	0	1	-360	360	-125.3894	-23.1779	125.5026	27.7726	0.0000	0.0000	0.0000	0.0000;
	125	128	0.0005	0.02875	-0.016	400	400	400	1.0639	0	1	-360	360	77.2668	-3.0864	-77.2392	6.4101	0.0000	0.0000	0.0000	0.0000;
	149	150	0.00064	0.0305	0	400	400	400	1.0826	0	1	-360	360	-211.9088	-27.6683	212.1869	40.9200	0.0000	0.0000	0.0000	0.0000;
	155	158	0.000232	0.023	0	500	500	500	1.089	0	1	-360	360	-29.5722	-69.1038	29.5848	70.3546	0.0000	0.0000	0.0000	0.0000;
	156	159	0.000232	0.023	0	500	500	500	1.0893	0	1	-360	360	-117.6252	-68.2436	117.6664	72.3398	0.0000	0.0000	0.0000	0.0000;
	170	172	0.00035	0.02375	0	500	500	500	1.1049	0	1	-360	360	74.0521	-93.5082	-74.0006	97.0033	0.0000	0.0000	0.0000	0.0000;
	183	184	0.00059	0.03093	0	400	400	400	1.091	0	1	-360	360	-104.3332	-58.4802	104.4147	62.7545	0.0000	0.0000	0.0000	0.0000;
	190	192	0.0004	0.03	0	500	500	500	1.1321	0	1	-360	360	-149.4449	-135.1382	149.6261	148.7293	0.0000	0.0000	0.0000	0.0000;
	2735	158	0.00031	0.00338	0.0992	1386	1386	1386	0	0	1	-360	360	89.1770	0.5655	-89.1539	-10.9442	0.0000	0.0000	0.0000	0.0000;
	2735	159	0.00031	0.00338	0.0992	1386	1386	1386	0	0	1	-360	360	86.0970	-0.5655	-86.0755	-9.8311	0.0000	0.0000	0.0000	0.0000;
	2736	68	0.014341	0.083531	0.126034	415	415	415	0	0	1	-360	360	125.0000	0.8364	-123.1472	-5.1002	0.0000	0.0000	0.0000	0.0000;
	2734	76	0.01219	0.070659	0.117418	412	412	412	0	0	1	-360	360	-134.6018	3.5748	136.4489	-7.1461	0.0000	0.0000	0.0000	0.0000;
	2734	105	0.011781	0.07087	0.116838	412	412	412	0	0	1	-360	360	-136.0362	0.8112	137.8542	-4.1013	0.0000	0.0000	0.0000	0.0000;
	2739	200	9e-06	9.4e-05	0	924	924	924	0	0	1	-360	360	400.0000	0.0000	-399.9861	0.1391	0.0000	0.0000	0.0000	0.0000;
	128	2732	0.0015	0.01469	0.40384	1386	1386	1386	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	127	2733	0.001419	0.014675	0.4896	1386	1386	1386	0	0	1	-360	360	639.4238	16.0375	-634.0640	-13.2720	0.0000	0.0000	0.0000	0.0000;
	2737	148	0.001651	0.015909	0.046948	373	373	373	0	0	1	-360	360	-39.4502	-14.3755	39.4729	8.8216	0.0000	0.0000	0.0000	0.0000;
	2737	149	0.001651	0.015909	0.046948	373	373	373	0	0	1	-360	360	-40.1478	-14.2705	40.1712	8.7236	0.0000	0.0000	0.0000	0.0000;
	2738	48	0.00188	0.02287	0.6432	831	831	831	0	0	1	-360	360	-232.9557	-79.2948	233.9754	23.8074	0.0000	0.0000	0.0000	0.0000;
	2738	49	0.00188	0.02287	0.6432	831	831	831	0	0	1	-360	360	-232.2283	-79.2522	233.2419	23.6915	0.0000	0.0000	0.0000	0.0000;
	82	2732	0.003519	0.039313	1.0336	1621	1621	1621	0	0	1	-360	360	311.9662	-16.5606	-308.7700	-58.2530	0.0000	0.0000	0.0000	0.0000;
	43	23	0.01345	0.081141	0.141134	339	339	339	0	0	1	-360	360	201.4527	60.6344	-196.4976	-47.1311	0.0000	0.0000	0.0000	0.0000;
	26	90	0.009091	0.062401	0.111417	457	457	457	0	0	1	-360	360	124.3978	-10.9606	-123.2548	5.1485	0.0000	0.0000	0.0000	0.0000;
	27	91	0.00868	0.06405	0.096994	457	457	457	0	0	1	-360	360	178.5607	-11.9243	-176.3121	16.6276	0.0000	0.0000	0.0000	0.0000;
	146	30	0.016961	0.123659	0.196988	373	373	373	0	0	1	-360	360	86.2302	34.5901	-84.9053	-47.8810	0.0000	0.0000	0.0000	0.0000;
	135	34	0.00512	0.02618	0.029621	335	335	335	0	0	1	-360	360	-80.5277	88.3333	81.1350	-88.8199	0.0000	0.0000	0.0000	0.0000;
	134	20	0.01068	0.061961	0.094961	415	415	415	0	0	1	-360	360	-183.3544	71.6296	186.7888	-63.1947	0.0000	0.0000	0.0000	0.0000;
	165	21	0.014651	0.105891	0.170852	373	373	373	0	0	1	-360	360	112.0246	30.8897	-110.3284	-38.7641	0.0000	0.0000	0.0000	0.0000;
	41	109	0.01488	0.08161	0.114805	347	347	347	0	0	1	-360	360	-105.6520	17.2108	107.0862	-23.3303	0.0000	0.0000	0.0000	0.0000;
	40	91	0.011159	0.07231	0.103673	362	362	362	0	0	1	-360	360	-156.1834	25.1157	158.5069	-22.7003	0.0000	0.0000	0.0000	0.0000;
	179	83	0.008616	0.077645	0.122239	373	373	373	0	0	1	-360	360	-148.1283	-9.8099	149.7201	9.3834	0.0000	0.0000	0.0000	0.0000;
	203	166	0.01176	0.068289	0.102802	362	362	362	0	0	1	-360	360	-249.2762	-37.0192	256.0052	64.0894	0.0000	0.0000	0.0000	0.0000;
	194	166	0.016818	0.089091	0.129935	400	400	400	0	0	1	-360	360	-171.5262	-27.1634	176.0158	35.6844	0.0000	0.0000	0.0000	0.0000;
	193	165	0.013843	0.087025	0.134842	427	427	427	0	0	1	-360	360	-176.3181	-33.0367	180.2521	41.9314	0.0000	0.0000	0.0000	0.0000;
	207	168	0.01676	0.097169	0.148685	274	274	274	0	0	1	-360	360	20.7130	-13.1600	-20.6484	-3.8200	0.0000	0.0000	0.0000	0.0000;
	43	12	0.01269	0.074979	0.130196	377	377	377	0	0	1	-360	360	220.5637	71.0314	-214.9094	-52.6963	0.0000	0.0000	0.0000	0.0000;
	198	18	0.014091	0.10413	0.15972	373	373	373	0	0	1	-360	360	-89.9084	-36.4634	91.0101	25.8253	0.0000	0.0000	0.0000	0.0000;
	100	55	0.003719	0.0438	0.100962	457	457	457	0	0	1	-360	360	-14.1560	-16.2162	14.1653	4.1023	0.0000	0.0000	0.0000	0.0000;
	163	82	0.00194	0.02056	0.51584	1316	1316	1316	0	0	1	-360	360	-516.5911	-45.0415	521.5252	42.1547	0.0000	0.0000	0.0000	0.0000;
	45	9	0.0015	0.01506	0.4032	1386	1386	1386	0	0	1	-360	360	384.0984	88.0683	-381.9202	-109.7012	0.0000	0.0000	0.0000	0.0000;
	185	151	0.00294	0.03463	0.9216	693	693	693	0	0	1	-360	360	27.4490	-53.0282	-27.4280	-45.7408	0.0000	0.0000	0.0000	0.0000;
	121	57	0.00169	0.01994	0.50624	831	831	831	0	0	1	-360	360	-17.1041	-10.3586	17.1133	-45.0451	0.0000	0.0000	0.0000	0.0000;
	29	93	0.00137	0.01625	0.41184	1386	1386	1386	0	0	1	-360	360	267.3184	-36.5057	-266.4214	2.0994	0.0000	0.0000	0.0000	0.0000;
	28	123	0.00231	0.02769	0.70144	1386	1386	1386	0	0	1	-360	360	422.3525	-65.7273	-418.5710	34.0134	0.0000	0.0000	0.0000	0.0000;
	25	192	0.00207	0.02474	0.664	831	831	831	0	0	1	-360	360	434.4905	51.4777	-430.5531	-71.2709	0.0000	0.0000	0.0000	0.0000;
	120	64	0.0015	0.01788	0.4512	831	831	831	0	0	1	-360	360	148.6316	-24.9220	-148.3302	-21.0177	0.0000	0.0000	0.0000	0.0000;
	122	65	0.00469	0.05544	1.4048	831	831	831	0	0	1	-360	360	194.1085	-78.3397	-192.5057	-57.1242	0.0000	0.0000	0.0000	0.0000;
	82	31	0.00331	0.03425	0.85888	1150	1150	1150	0	0	1	-360	360	-122.9534	-39.4862	123.4145	-49.4637	0.0000	0.0000	0.0000	0.0000;
	92	28	0.00219	0.02369	0.59584	1316	1316	1316	0	0	1	-360	360	-181.8529	-14.1539	182.5221	-43.7760	0.0000	0.0000	0.0000	0.0000;
	11	4	0.01674	0.09711	0.144232	461	461	461	0	0	1	-360	360	-228.5533	7.4047	236.6613	23.3287	0.0000	0.0000	0.0000	0.0000;
	30	12	0.0057	0.0407	0.06021	373	373	373	0	0	1	-360	360	-36.4118	21.0777	36.5114	-26.9354	0.0000	0.0000	0.0000	0.0000;
	33	4	0.004419	0.032229	0.049852	392	392	392	0	0	1	-360	360	210.6975	-2.3704	-209.0521	8.4638	0.0000	0.0000	0.0000	0.0000;
	17	7	0.014591	0.11219	0.165528	427	427	427	0	0	1	-360	360	-66.3982	45.8214	67.2986	-58.3004	0.0000	0.0000	0.0000	0.0000;
	22	10	0.01211	0.087419	0.140166	373	373	373	0	0	1	-360	360	-30.1542	20.5302	30.3390	-34.6711	0.0000	0.0000	0.0000	0.0000;
	26	5	0.009773	0.050516	0.088959	377	377	377	0	0	1	-360	360	246.2864	14.0007	-241.4451	0.3071	0.0000	0.0000	0.0000	0.0000;
	17	3	0.01068	0.07895	0.122597	274	274	274	0	0	1	-360	360	137.9583	36.5162	-136.1247	-37.3934	0.0000	0.0000	0.0000	0.0000;
	26	19	0.0057	0.039521	0.075533	480	480	480	0	0	1	-360	360	254.2276	25.3469	-251.1958	-13.4665	0.0000	0.0000	0.0000	0.0000;
	27	20	0.0057	0.039521	0.075533	480	480	480	0	0	1	-360	360	345.2337	21.0123	-339.6890	8.2893	0.0000	0.0000	0.0000	0.0000;
	10	6	0.00525	0.03988	0.061952	373	373	373	0	0	1	-360	360	-22.6774	-49.1176	22.8038	43.2437	0.0000	0.0000	0.0000	0.0000;
	32	10	0.00093	0.00651	0.011132	373	373	373	0	0	1	-360	360	-103.6693	-22.4553	103.7661	21.9294	0.0000	0.0000	0.0000	0.0000;
	23	11	0.00205	0.01326	0.022429	415	415	415	0	0	1	-360	360	17.1317	22.7643	-17.1154	-25.0962	0.0000	0.0000	0.0000	0.0000;
	34	5	0.007831	0.043	0.04962	335	335	335	0	0	1	-360	360	-155.0004	49.2120	156.7550	-45.4597	0.0000	0.0000	0.0000	0.0000;
	19	4	0.00293	0.01599	0.024781	362	362	362	0	0	1	-360	360	150.1180	5.8152	-149.5608	-5.7051	0.0000	0.0000	0.0000	0.0000;
	26	1	0.00155	0.01169	0.018198	747	747	747	0	0	1	-360	360	77.1807	80.5910	-77.0218	-81.6151	0.0000	0.0000	0.0000	0.0000;
	27	2	0.00155	0.01169	0.018198	747	747	747	0	0	1	-360	360	56.8477	69.6332	-56.7440	-71.0772	0.0000	0.0000	0.0000	0.0000;
	27	33	0.003841	0.028531	0.045883	392	392	392	0	0	1	-360	360	321.8876	35.9266	-318.6108	-17.1481	0.0000	0.0000	0.0000	0.0000;
	24	33	2e-06	2.1e-05	0	392	392	392	0	0	1	-360	360	-107.9131	-19.5164	107.9133	19.5185	0.0000	0.0000	0.0000	0.0000;
	25	9	0.00298	0.03417	0.93504	831	831	831	0	0	1	-360	360	-18.9121	-85.9218	18.9636	-11.1698	0.0000	0.0000	0.0000	0.0000;
	28	25	0.00358	0.04262	1.0944	1386	1386	1386	0	0	1	-360	360	605.9794	37.1152	-593.6575	-6.7220	0.0000	0.0000	0.0000	0.0000;
	14	29	0.00336	0.03977	1.02163	1316	1316	1316	0	0	1	-360	360	-546.4254	0.7984	556.0246	2.9993	0.0000	0.0000	0.0000	0.0000;
	8	15	0.00299	0.03675	0.9184	1358	1358	1358	0	0	1	-360	360	152.3571	-54.3937	-151.7003	-34.6324	0.0000	0.0000	0.0000	0.0000;
	8	14	0.00112	0.01329	0.341248	1358	1358	1358	0	0	1	-360	360	-251.2724	16.9381	251.9536	-44.9213	0.0000	0.0000	0.0000	0.0000;
	31	29	0.00063	0.00749	0.392256	1358	1358	1358	0	0	1	-360	360	-364.6549	9.2122	365.4264	-42.9520	0.0000	0.0000	0.0000	0.0000;
	63	59	0.010479	0.060969	0.092047	316	316	316	0	0	1	-360	360	9.0239	-3.7460	-9.0166	-7.4032	0.0000	0.0000	0.0000	0.0000;
	61	56	0.00882	0.065641	0.100662	274	274	274	0	0	1	-360	360	-23.5018	-6.1259	23.5420	-5.7886	0.0000	0.0000	0.0000	0.0000;
	67	35	0.011219	0.065581	0.098349	274	274	274	0	0	1	-360	360	22.7219	-6.3346	-22.6732	-5.0758	0.0000	0.0000	0.0000	0.0000;
	51	35	0.01163	0.07031	0.105802	377	377	377	0	0	1	-360	360	-49.5574	-6.9814	49.8009	-4.0325	0.0000	0.0000	0.0000	0.0000;
	59	43	0.00545	0.040211	0.066986	446	446	446	0	0	1	-360	360	-80.2283	-14.8320	80.5225	8.8107	0.0000	0.0000	0.0000	0.0000;
	60	44	0.00545	0.040211	0.066986	446	446	446	0	0	1	-360	360	-81.6587	-14.5907	81.9631	8.6443	0.0000	0.0000	0.0000	0.0000;
	60	35	0.00837	0.04868	0.073481	419	419	419	0	0	1	-360	360	81.8856	10.4659	-81.4078	-16.5080	0.0000	0.0000	0.0000	0.0000;
	68	52	0.003159	0.02076	0.03146	415	415	415	0	0	1	-360	360	49.6625	-6.8965	-49.5955	3.6445	0.0000	0.0000	0.0000	0.0000;
	52	39	0.006979	0.051961	0.079666	373	373	373	0	0	1	-360	360	46.7557	4.3260	-46.6208	-12.6078	0.0000	0.0000	0.0000	0.0000;
	37	56	0.00374	0.027831	0.042689	274	274	274	0	0	1	-360	360	-128.2840	-5.0956	128.7956	3.7396	0.0000	0.0000	0.0000	0.0000;
	38	36	0.00769	0.057271	0.087894	373	373	373	0	0	1	-360	360	63.9300	-4.2485	-63.6688	-4.3402	0.0000	0.0000	0.0000	0.0000;
	55	38	0.00556	0.04145	0.063598	427	427	427	0	0	1	-360	360	86.5757	0.6529	-86.2320	-5.7831	0.0000	0.0000	0.0000	0.0000;
	67	37	0.004521	0.03368	0.051691	392	392	392	0	0	1	-360	360	-83.3760	-9.0200	83.6412	4.8061	0.0000	0.0000	0.0000	0.0000;
	67	66	0.00151	0.008781	0.013165	377	377	377	0	0	1	-360	360	60.6541	15.3546	-60.6042	-16.6294	0.0000	0.0000	0.0000	0.0000;
	62	43	0.00574	0.042831	0.065727	446	446	446	0	0	1	-360	360	-62.4361	-11.4540	62.6224	4.7928	0.0000	0.0000	0.0000	0.0000;
	63	44	0.00707	0.045409	0.069309	347	347	347	0	0	1	-360	360	-60.2530	-9.7435	60.4656	2.6181	0.0000	0.0000	0.0000	0.0000;
	62	40	0.01213	0.062151	0.093712	347	347	347	0	0	1	-360	360	-54.8058	4.9554	55.1163	-14.7831	0.0000	0.0000	0.0000	0.0000;
	61	41	0.002479	0.017979	0.027588	373	373	373	0	0	1	-360	360	-89.7564	-10.2140	89.9228	8.0687	0.0000	0.0000	0.0000	0.0000;
	47	40	0.002401	0.01494	0.022525	377	377	377	0	0	1	-360	360	-85.8907	-14.8642	86.0406	13.0606	0.0000	0.0000	0.0000	0.0000;
	50	46	0.00167	0.0189	0.54176	1358	1358	1358	0	0	1	-360	360	-113.0094	-11.3118	113.2080	-46.0928	0.0000	0.0000	0.0000	0.0000;
	58	54	0.00109	0.01277	0.34176	1358	1358	1358	0	0	1	-360	360	152.4410	-16.6830	-152.2093	-17.9116	0.0000	0.0000	0.0000	0.0000;
	42	58	0.002259	0.026439	0.70784	1358	1358	1358	0	0	1	-360	360	30.7451	-49.3246	-30.7231	-27.6591	0.0000	0.0000	0.0000	0.0000;
	64	58	0.00094	0.01097	0.29376	1552	1552	1552	0	0	1	-360	360	-272.4882	22.3376	273.1377	-46.9138	0.0000	0.0000	0.0000	0.0000;
	48	65	0.00113	0.01406	0.37488	831	831	831	0	0	1	-360	360	-503.1827	-48.2593	505.8604	40.9446	0.0000	0.0000	0.0000	0.0000;
	53	45	0.00176	0.02144	0.57344	1358	1358	1358	0	0	1	-360	360	-54.7199	-49.0466	54.7734	-13.0812	0.0000	0.0000	0.0000	0.0000;
	96	125	0.004876	0.033616	0.059609	446	446	446	0	0	1	-360	360	-102.0465	2.4568	102.4637	-6.8827	0.0000	0.0000	0.0000	0.0000;
	75	106	0.01093	0.059194	0.08439	290	290	290	0	0	1	-360	360	-43.8408	-8.3992	44.0150	-0.9525	0.0000	0.0000	0.0000	0.0000;
	106	94	0.001942	0.013926	0.022845	446	446	446	0	0	1	-360	360	10.9155	-4.2512	-10.9135	1.4623	0.0000	0.0000	0.0000	0.0000;
	79	85	0.004318	0.029752	0.05264	373	373	373	0	0	1	-360	360	3.4641	5.8470	-3.4608	-12.2845	0.0000	0.0000	0.0000	0.0000;
	131	130	0.000661	0.004959	0.007579	419	419	419	0	0	1	-360	360	136.0801	32.1682	-135.9736	-32.2891	0.0000	0.0000	0.0000	0.0000;
	107	131	0.005372	0.040393	0.060055	419	419	419	0	0	1	-360	360	32.2537	5.7722	-32.2042	-12.7347	0.0000	0.0000	0.0000	0.0000;
	91	131	0.000826	0.005248	0.008683	305	305	305	0	0	1	-360	360	103.9516	18.8573	-103.8759	-19.4334	0.0000	0.0000	0.0000	0.0000;
	100	119	0.015888	0.087603	0.116818	347	347	347	0	0	1	-360	360	-94.2742	1.0991	95.4540	-8.8053	0.0000	0.0000	0.0000	0.0000;
	81	113	0.002169	0.014587	0.025749	316	316	316	0	0	1	-360	360	-13.5853	-7.2757	13.5892	4.1920	0.0000	0.0000	0.0000	0.0000;
	116	101	0.017727	0.116777	0.163611	290	290	290	0	0	1	-360	360	96.1159	-10.9794	-94.7812	-0.1300	0.0000	0.0000	0.0000	0.0000;
	126	74	0.00593	0.04093	0.072145	446	446	446	0	0	1	-360	360	43.9727	8.2375	-43.8716	-16.3459	0.0000	0.0000	0.0000	0.0000;
	108	90	0.003905	0.028471	0.044983	427	427	427	0	0	1	-360	360	-91.9430	6.9941	92.2172	-10.4760	0.0000	0.0000	0.0000	0.0000;
	118	79	0.008161	0.042417	0.061197	385	385	385	0	0	1	-360	360	-88.8462	11.6246	89.3867	-16.3347	0.0000	0.0000	0.0000	0.0000;
	119	78	0.008161	0.042417	0.061197	385	385	385	0	0	1	-360	360	-98.3786	11.3403	99.0373	-15.4422	0.0000	0.0000	0.0000	0.0000;
	79	76	0.005186	0.038388	0.058748	492	492	492	0	0	1	-360	360	-26.5940	1.8693	26.6251	-8.8619	0.0000	0.0000	0.0000	0.0000;
	78	73	0.002128	0.014029	0.022603	335	335	335	0	0	1	-360	360	95.9560	16.5011	-95.7915	-18.1910	0.0000	0.0000	0.0000	0.0000;
	114	78	0.004628	0.027748	0.046115	362	362	362	0	0	1	-360	360	-104.0558	-25.5243	104.4900	22.4988	0.0000	0.0000	0.0000	0.0000;
	103	72	0.011219	0.070744	0.115705	290	290	290	0	0	1	-360	360	-4.7584	-9.9173	4.7613	-4.1862	0.0000	0.0000	0.0000	0.0000;
	110	117	0.006012	0.041467	0.073636	427	427	427	0	0	1	-360	360	-102.8338	0.9709	103.3574	-6.3618	0.0000	0.0000	0.0000	0.0000;
	91	69	0.002066	0.012789	0.020551	316	316	316	0	0	1	-360	360	96.7235	16.3832	-96.5597	-17.8672	0.0000	0.0000	0.0000	0.0000;
	86	90	0.001364	0.009731	0.016243	457	457	457	0	0	1	-360	360	-99.8310	-23.1625	99.9486	22.0267	0.0000	0.0000	0.0000	0.0000;
	129	87	0.000579	0.004112	0.007008	446	446	446	0	0	1	-360	360	-61.9184	-11.5195	61.9373	10.8048	0.0000	0.0000	0.0000	0.0000;
	132	76	0.000847	0.00624	0.009544	457	457	457	0	0	1	-360	360	247.0000	-5.7443	-246.5804	7.6609	0.0000	0.0000	0.0000	0.0000;
	133	77	0.000847	0.00626	0.009477	457	457	457	0	0	1	-360	360	123.0000	10.4325	-122.8951	-10.8236	0.0000	0.0000	0.0000	0.0000;
	102	77	0.001591	0.011116	0.019128	492	492	492	0	0	1	-360	360	-205.8434	-17.6074	206.4004	19.1588	0.0000	0.0000	0.0000	0.0000;
	125	104	0.003141	0.021591	0.038391	446	446	446	0	0	1	-360	360	-57.4790	-2.3434	57.5635	-1.7988	0.0000	0.0000	0.0000	0.0000;
	126	111	0.004545	0.03157	0.055312	373	373	373	0	0	1	-360	360	86.3189	31.5481	-85.9979	-36.0321	0.0000	0.0000	0.0000	0.0000;
	104	84	0.001446	0.009917	0.017598	373	373	373	0	0	1	-360	360	123.1118	20.3640	-122.9285	-21.2685	0.0000	0.0000	0.0000	0.0000;
	105	95	0.003822	0.026674	0.046154	373	373	373	0	0	1	-360	360	22.0191	2.8493	-22.0030	-8.4131	0.0000	0.0000	0.0000	0.0000;
	112	80	0.007769	0.041281	0.063907	316	316	316	0	0	1	-360	360	-3.2519	-12.3242	3.2572	4.6653	0.0000	0.0000	0.0000	0.0000;
	89	78	0.004463	0.030413	0.048671	290	290	290	0	0	1	-360	360	-12.8307	-22.8238	12.8511	16.9988	0.0000	0.0000	0.0000	0.0000;
	117	108	0.005888	0.035062	0.052349	290	290	290	0	0	1	-360	360	48.0704	3.0212	-47.9576	-8.7484	0.0000	0.0000	0.0000	0.0000;
	109	99	0.003161	0.023409	0.036165	373	373	373	0	0	1	-360	360	-44.1933	-5.6188	44.2443	1.5856	0.0000	0.0000	0.0000	0.0000;
	116	79	0.001839	0.012603	0.022399	373	373	373	0	0	1	-360	360	-81.4775	-1.1070	81.5770	-0.9632	0.0000	0.0000	0.0000	0.0000;
	107	88	0.001715	0.009607	0.014239	335	335	335	0	0	1	-360	360	72.1427	27.5623	-72.0587	-28.8326	0.0000	0.0000	0.0000	0.0000;
	98	79	0.003409	0.024421	0.039969	290	290	290	0	0	1	-360	360	-68.0358	-9.1221	68.1662	5.1558	0.0000	0.0000	0.0000	0.0000;
	117	78	0.001839	0.012603	0.02239	373	373	373	0	0	1	-360	360	-110.4825	-4.1874	110.6655	2.6887	0.0000	0.0000	0.0000	0.0000;
	83	97	0.005702	0.041488	0.066172	446	446	446	0	0	1	-360	360	-45.8217	11.2965	45.9301	-18.6153	0.0000	0.0000	0.0000	0.0000;
	124	118	0.004587	0.024628	0.036165	347	347	347	0	0	1	-360	360	-68.5588	-7.0415	68.7366	3.5735	0.0000	0.0000	0.0000	0.0000;
	124	110	0.002149	0.013327	0.022109	290	290	290	0	0	1	-360	360	-16.6871	4.0450	16.6926	-6.7046	0.0000	0.0000	0.0000	0.0000;
	100	71	0.000785	0.004876	0.00726	316	316	316	0	0	1	-360	360	8.3105	0.0605	-8.3100	-0.9330	0.0000	0.0000	0.0000	0.0000;
	101	70	0.000785	0.004876	0.007241	316	316	316	0	0	1	-360	360	7.1233	-0.8709	-7.1230	-0.0000	0.0000	0.0000	0.0000	0.0000;
	93	127	0.002413	0.027544	0.767968	831	831	831	0	0	1	-360	360	196.2646	-43.0577	-195.4145	-30.9594	0.0000	0.0000	0.0000	0.0000;
	82	127	0.002462	0.028525	0.7616	1621	1621	1621	0	0	1	-360	360	97.1337	-45.5795	-96.9200	-34.8022	0.0000	0.0000	0.0000	0.0000;
	122	115	0.000913	0.0104	0.289888	1358	1358	1358	0	0	1	-360	360	-30.8147	48.2123	30.8567	-79.5091	0.0000	0.0000	0.0000	0.0000;
	123	121	0.003119	0.035631	0.991072	831	831	831	0	0	1	-360	360	226.6870	-62.2278	-225.2318	-30.2750	0.0000	0.0000	0.0000	0.0000;
	115	128	0.000919	0.010512	0.292928	1358	1358	1358	0	0	1	-360	360	-146.9616	10.4551	147.1496	-40.1875	0.0000	0.0000	0.0000	0.0000;
	174	156	0.01545	0.073349	0.126614	461	461	461	0	0	1	-360	360	-271.5796	-15.6732	281.9727	50.2647	0.0000	0.0000	0.0000	0.0000;
	175	155	0.01545	0.073349	0.126614	461	461	461	0	0	1	-360	360	-298.8560	-4.5062	311.4292	49.4474	0.0000	0.0000	0.0000	0.0000;
	177	155	0.01457	0.07955	0.14007	362	362	362	0	0	1	-360	360	-144.7149	-6.6130	147.2991	3.8217	0.0000	0.0000	0.0000	0.0000;
	178	156	0.01457	0.07955	0.14007	362	362	362	0	0	1	-360	360	-117.0554	-14.1359	118.7500	6.4875	0.0000	0.0000	0.0000	0.0000;
	177	144	0.006031	0.04401	0.069793	373	373	373	0	0	1	-360	360	44.1712	-34.4889	-44.0244	27.2410	0.0000	0.0000	0.0000	0.0000;
	166	140	0.011031	0.08057	0.124127	446	446	446	0	0	1	-360	360	207.5601	1.6251	-203.6953	11.5426	0.0000	0.0000	0.0000	0.0000;
	137	155	0.005831	0.04231	0.070664	427	427	427	0	0	1	-360	360	-210.0478	-28.6450	212.2575	36.1573	0.0000	0.0000	0.0000	0.0000;
	171	174	0.01849	0.095599	0.159139	305	305	305	0	0	1	-360	360	-82.3342	54.2136	84.0302	-63.5676	0.0000	0.0000	0.0000	0.0000;
	152	175	0.010581	0.053	0.088475	415	415	415	0	0	1	-360	360	-127.0078	45.0452	128.7696	-46.0252	0.0000	0.0000	0.0000	0.0000;
	154	156	0.012521	0.091359	0.145394	457	457	457	0	0	1	-360	360	-271.5530	16.5666	279.6146	24.9036	0.0000	0.0000	0.0000	0.0000;
	136	137	0.00506	0.036539	0.063598	305	305	305	0	0	1	-360	360	-102.0405	-5.2726	102.4920	1.0685	0.0000	0.0000	0.0000	0.0000;
	148	143	0.01043	0.077891	0.122065	427	427	427	0	0	1	-360	360	-20.8371	12.5941	20.9081	-26.9413	0.0000	0.0000	0.0000	0.0000;
	153	181	0.007711	0.056961	0.088378	373	373	373	0	0	1	-360	360	-20.9553	53.9043	21.2172	-61.8982	0.0000	0.0000	0.0000	0.0000;
	171	147	0.018599	0.09638	0.140941	290	290	290	0	0	1	-360	360	-188.9181	16.9335	194.6438	-4.2560	0.0000	0.0000	0.0000	0.0000;
	176	170	0.00244	0.01318	0.021296	377	377	377	0	0	1	-360	360	-82.1290	1.1338	82.2690	-2.8875	0.0000	0.0000	0.0000	0.0000;
	170	140	0.00355	0.02593	0.041237	446	446	446	0	0	1	-360	360	-77.4368	-18.6535	77.6250	15.1322	0.0000	0.0000	0.0000	0.0000;
	171	168	0.01312	0.076219	0.116644	362	362	362	0	0	1	-360	360	104.1263	-13.4584	-102.9160	6.7935	0.0000	0.0000	0.0000	0.0000;
	170	152	0.009341	0.05225	0.087701	305	305	305	0	0	1	-360	360	-20.0132	58.1625	20.3624	-66.2910	0.0000	0.0000	0.0000	0.0000;
	146	135	0.006141	0.032521	0.052456	385	385	385	0	0	1	-360	360	-178.1545	34.2261	179.8072	-31.9336	0.0000	0.0000	0.0000	0.0000;
	147	134	0.00438	0.03188	0.050723	457	457	457	0	0	1	-360	360	-186.3411	25.9387	187.6064	-22.9774	0.0000	0.0000	0.0000	0.0000;
	165	147	0.000479	0.00331	0.005711	446	446	446	0	0	1	-360	360	-53.0671	19.2448	53.0795	-19.8623	0.0000	0.0000	0.0000	0.0000;
	166	146	0.000479	0.00331	0.005711	446	446	446	0	0	1	-360	360	-71.8214	21.2351	71.8433	-21.7875	0.0000	0.0000	0.0000	0.0000;
	154	143	0.010539	0.076859	0.122355	373	373	373	0	0	1	-360	360	116.0718	-50.6696	-114.6689	46.4596	0.0000	0.0000	0.0000	0.0000;
	160	148	0.00469	0.034651	0.053821	427	427	427	0	0	1	-360	360	-150.1317	-36.5389	151.0618	36.8864	0.0000	0.0000	0.0000	0.0000;
	149	141	0.006469	0.0413	0.069212	427	427	427	0	0	1	-360	360	116.1888	23.5343	-115.4394	-27.1532	0.0000	0.0000	0.0000	0.0000;
	169	141	0.00105	0.007211	0.01028	373	373	373	0	0	1	-360	360	-33.5912	-8.4539	33.6016	7.2971	0.0000	0.0000	0.0000	0.0000;
	169	160	0.006099	0.044831	0.070954	373	373	373	0	0	1	-360	360	4.7577	-2.8875	-4.7565	-5.5709	0.0000	0.0000	0.0000	0.0000;
	177	136	0.002211	0.01655	0.024781	373	373	373	0	0	1	-360	360	64.7879	31.5489	-64.6889	-33.7175	0.0000	0.0000	0.0000	0.0000;
	179	178	0.005169	0.036979	0.058951	373	373	373	0	0	1	-360	360	30.0624	1.8600	-30.0218	-8.5527	0.0000	0.0000	0.0000	0.0000;
	181	174	0.002401	0.017789	0.027588	381	381	381	0	0	1	-360	360	-162.7907	6.7350	163.3749	-5.4267	0.0000	0.0000	0.0000	0.0000;
	158	138	0.00274	0.02696	0.70592	1150	1150	1150	0	0	1	-360	360	226.5913	-0.1544	-225.2417	-61.1535	0.0000	0.0000	0.0000	0.0000;
	164	139	0.0017	0.01733	0.45632	915	915	915	0	0	1	-360	360	60.7320	-5.1644	-60.6666	-41.9138	0.0000	0.0000	0.0000	0.0000;
	162	163	0.00136	0.01574	0.433664	1621	1621	1621	0	0	1	-360	360	-180.4187	-50.6789	180.8565	10.5040	0.0000	0.0000	0.0000	0.0000;
	172	151	0.00371	0.04326	1.18688	693	693	693	0	0	1	-360	360	-60.6829	-126.3087	60.9791	5.9499	0.0000	0.0000	0.0000	0.0000;
	188	193	0.02738	0.142539	0.200473	351	351	351	0	0	1	-360	360	-56.1017	-22.9195	56.9678	5.7702	0.0000	0.0000	0.0000	0.0000;
	198	203	0.02756	0.16014	0.242871	274	274	274	0	0	1	-360	360	-42.9960	3.6849	43.5207	-27.7572	0.0000	0.0000	0.0000	0.0000;
	189	208	0.01905	0.11132	0.167851	274	274	274	0	0	1	-360	360	-3.7304	-61.4264	4.2389	45.8487	0.0000	0.0000	0.0000	0.0000;
	191	194	0.00795	0.05919	0.090798	373	373	373	0	0	1	-360	360	-50.6024	28.9548	50.8605	-37.3169	0.0000	0.0000	0.0000	0.0000;
	193	182	0.0018	0.021141	0.051498	747	747	747	0	0	1	-360	360	78.3604	37.7203	-78.2349	-41.9468	0.0000	0.0000	0.0000	0.0000;
	202	204	0.00731	0.055789	0.083635	274	274	274	0	0	1	-360	360	-62.2442	1.7015	62.5044	-8.9277	0.0000	0.0000	0.0000	0.0000;
	190	201	0.00564	0.041961	0.064372	274	274	274	0	0	1	-360	360	57.7581	47.5462	-57.4653	-52.6046	0.0000	0.0000	0.0000	0.0000;
	208	183	0.0057	0.04236	0.129712	366	366	366	0	0	1	-360	360	-103.6252	-68.7729	104.3332	58.4802	0.0000	0.0000	0.0000	0.0000;
	200	184	0.00131	0.01548	0.41152	1358	1358	1358	0	0	1	-360	360	233.8116	-24.8373	-233.1472	-11.5875	0.0000	0.0000	0.0000	0.0000;
	186	192	0.00224	0.02583	0.72352	831	831	831	0	0	1	-360	360	-78.0480	76.5358	78.4606	-144.8197	0.0000	0.0000	0.0000	0.0000;
	195	187	0.0021	0.02475	0.65792	1358	1358	1358	0	0	1	-360	360	-144.5516	-61.8651	145.0006	-0.3408	0.0000	0.0000	0.0000	0.0000;
	205	199	0.0015	0.01768	0.46944	831	831	831	0	0	1	-360	360	-7.9181	-101.1754	8.0026	52.2149	0.0000	0.0000	0.0000	0.0000;
	186	205	0.00133	0.01569	0.418208	831	831	831	0	0	1	-360	360	-169.0757	-49.1178	169.4521	9.9172	0.0000	0.0000	0.0000	0.0000;
	187	206	0.00133	0.01569	0.418208	831	831	831	0	0	1	-360	360	-169.5644	-48.9947	169.9429	9.8167	0.0000	0.0000	0.0000	0.0000;
	390	1	0.00157	0.06612	0	160	160	160	1.0442	0	1	-360	360	-76.8585	-74.7378	77.0218	81.6151	0.0000	0.0000	0.0000	0.0000;
	391	2	0.00157	0.06612	0	160	160	160	1.0249	0	1	-360	360	-56.6370	-66.5716	56.7440	71.0772	0.0000	0.0000	0.0000	0.0000;
	246	245	0.001008	0.047273	0	300	300	300	1	0	1	-360	360	161.0474	-8.0618	-160.8214	18.6590	0.0000	0.0000	0.0000	0.0000;
	246	29	0.00079	0.03678	0	426	426	426	1	0	1	-360	360	206.9706	92.8660	-206.6201	-76.5477	0.0000	0.0000	0.0000	0.0000;
	248	3	0.001651	0.06736	0	160	160	160	1.0513	0	1	-360	360	-86.6525	-14.2989	86.7674	18.9882	0.0000	0.0000	0.0000	0.0000;
	249	3	0.001651	0.06736	0	160	160	160	1.0457	0	1	-360	360	-49.3169	-16.7558	49.3573	18.4052	0.0000	0.0000	0.0000	0.0000;
	275	4	0.001651	0.06901	0	160	160	160	1.0219	0	1	-360	360	-98.3360	-3.2979	98.4731	9.0300	0.0000	0.0000	0.0000	0.0000;
	276	5	0.001651	0.06901	0	160	160	160	1.0243	0	1	-360	360	-108.0030	-3.1151	108.1684	10.0320	0.0000	0.0000	0.0000	0.0000;
	339	6	0.001651	0.068599	0	160	160	160	1.0565	0	1	-360	360	-80.9944	-17.3186	81.0980	21.6227	0.0000	0.0000	0.0000	0.0000;
	339	7	0.001651	0.068599	0	160	160	160	1.0569	0	1	-360	360	-81.2829	-18.1311	81.3877	22.4860	0.0000	0.0000	0.0000	0.0000;
	340	9	0.0015	0.06188	0	250	250	250	1.1267	0	1	-360	360	-208.0881	-77.5123	208.8784	110.1154	0.0000	0.0000	0.0000	0.0000;
	351	11	0.001651	0.06775	0	160	160	160	1.0633	0	1	-360	360	-111.5356	-18.0988	111.7365	26.3412	0.0000	0.0000	0.0000	0.0000;
	352	11	0.001651	0.06775	0	160	160	160	1.0833	0	1	-360	360	-101.3502	-53.4193	101.5665	62.2984	0.0000	0.0000	0.0000	0.0000;
	353	12	0.001651	0.06775	0	160	160	160	1.0919	0	1	-360	360	-99.1056	-61.2209	99.3317	70.4998	0.0000	0.0000	0.0000	0.0000;
	359	13	0.00087	0.05244	-0.02144	330	330	330	1.0685	0	1	-360	360	-293.7367	2.1591	294.4666	44.0704	0.0000	0.0000	0.0000	0.0000;
	366	15	0.00087	0.05244	-0.02144	330	330	330	1.1063	0	1	-360	360	-151.5015	-20.4199	151.7003	34.6324	0.0000	0.0000	0.0000	0.0000;
	383	17	0.00124	0.068391	0	160	160	160	1.0135	0	1	-360	360	-69.8443	-5.1024	69.8945	7.8728	0.0000	0.0000	0.0000	0.0000;
	382	18	0.00124	0.068391	0	160	160	160	0.9918	0	1	-360	360	-22.5189	33.9073	22.5351	-33.0127	0.0000	0.0000	0.0000	0.0000;
	388	19	0.001651	0.06901	0	160	160	160	1.0297	0	1	-360	360	-113.7607	-17.5653	113.9502	25.4861	0.0000	0.0000	0.0000	0.0000;
	389	20	0.001651	0.06901	0	160	160	160	1.033	0	1	-360	360	-139.7361	-24.8811	140.0277	37.0698	0.0000	0.0000	0.0000	0.0000;
	395	21	0.00155	0.06612	0	160	160	160	1.0339	0	1	-360	360	-90.4326	-1.8109	90.5462	6.6564	0.0000	0.0000	0.0000	0.0000;
	396	22	0.00157	0.06612	0	160	160	160	1.0443	0	1	-360	360	-49.8994	-10.0302	49.9361	11.5750	0.0000	0.0000	0.0000	0.0000;
	401	23	0.001651	0.06901	0	160	160	160	1.0607	0	1	-360	360	-95.9120	-9.7000	96.0554	15.6959	0.0000	0.0000	0.0000	0.0000;
	402	23	0.001651	0.06901	0	160	160	160	1.0449	0	1	-360	360	-83.2042	-4.2303	83.3104	8.6709	0.0000	0.0000	0.0000	0.0000;
	403	24	0.00157	0.067979	0	160	160	160	1.0128	0	1	-360	360	-82.8426	-8.3355	82.9351	12.3439	0.0000	0.0000	0.0000	0.0000;
	404	24	0.001651	0.06901	0	160	160	160	0.9771	0	1	-360	360	-24.9686	-6.7816	24.9779	7.1725	0.0000	0.0000	0.0000	0.0000;
	410	25	0.0015	0.06188	0	250	250	250	1.1272	0	1	-360	360	-177.5932	-21.1180	178.0792	41.1661	0.0000	0.0000	0.0000	0.0000;
	462	30	0.001651	0.06818	0	160	160	160	1.0574	0	1	-360	360	-121.0852	-17.2247	121.3171	26.8033	0.0000	0.0000	0.0000	0.0000;
	486	31	0.00137	0.06119	-0.01504	250	250	250	1.0808	0	1	-360	360	-119.6512	-8.4912	119.8350	18.3276	0.0000	0.0000	0.0000	0.0000;
	487	31	0.00137	0.06119	-0.01504	250	250	250	1.0735	0	1	-360	360	-121.2152	-11.8011	121.4054	21.9239	0.0000	0.0000	0.0000	0.0000;
	543	32	0.001651	0.07107	0	160	160	160	1.0589	0	1	-360	360	-103.4971	-15.0419	103.6693	22.4553	0.0000	0.0000	0.0000	0.0000;
	570	34	0.001651	0.06901	0	160	160	160	1.0174	0	1	-360	360	-36.9790	-18.5989	37.0033	19.6128	0.0000	0.0000	0.0000	0.0000;
	571	34	0.001651	0.06901	0	160	160	160	1.0178	0	1	-360	360	-36.8377	-18.9784	36.8620	19.9951	0.0000	0.0000	0.0000	0.0000;
	584	35	0.001401	0.0668	0	160	160	160	1.0157	0	1	-360	360	-54.2376	-23.5889	54.2801	25.6163	0.0000	0.0000	0.0000	0.0000;
	584	35	0.001401	0.0668	0	160	160	160	1.0417	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	589	36	0.00151	0.067151	0	160	160	160	0.9842	0	1	-360	360	-63.6173	-2.0489	63.6688	4.3402	0.0000	0.0000	0.0000	0.0000;
	609	38	0.00157	0.078081	0	160	160	160	0.9962	0	1	-360	360	-66.8846	-7.3410	66.9445	10.3177	0.0000	0.0000	0.0000	0.0000;
	613	39	0.00149	0.066159	0	160	160	160	1.0125	0	1	-360	360	-46.5908	-11.2751	46.6208	12.6078	0.0000	0.0000	0.0000	0.0000;
	661	43	0.00157	0.06775	0	160	160	160	0.9864	0	1	-360	360	-97.5242	44.2165	97.6643	-38.1704	0.0000	0.0000	0.0000	0.0000;
	663	47	0.00163	0.069461	0	160	160	160	0.9905	0	1	-360	360	-85.7884	-10.5050	85.8907	14.8642	0.0000	0.0000	0.0000	0.0000;
	665	49	0.00135	0.06052	0	250	250	250	1.0231	0	1	-360	360	-35.9448	0.0128	35.9611	0.7177	0.0000	0.0000	0.0000	0.0000;
	692	50	0.00135	0.06052	0	250	250	250	1.0425	0	1	-360	360	-112.8514	-4.2310	113.0094	11.3118	0.0000	0.0000	0.0000	0.0000;
	693	50	0.00153	0.06156	0	250	250	250	1.0768	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	711	51	0.00157	0.066159	0	160	160	160	1.0006	0	1	-360	360	-52.3604	2.5379	52.3972	-0.9893	0.0000	0.0000	0.0000	0.0000;
	727	54	0.0014	0.06235	0	250	250	250	1.0482	0	1	-360	360	-101.8830	-15.9368	102.0230	22.1724	0.0000	0.0000	0.0000	0.0000;
	730	53	0.00139	0.05984	0	250	250	250	0.9841	0	1	-360	360	-104.7401	-37.6411	104.9060	44.7844	0.0000	0.0000	0.0000	0.0000;
	737	56	0.00145	0.068391	0	160	160	160	0.9978	0	1	-360	360	-67.9633	-8.7234	68.0200	11.3996	0.0000	0.0000	0.0000	0.0000;
	755	61	0.001651	0.06775	0	160	160	160	0.9893	0	1	-360	360	-56.4808	-5.8608	56.5251	7.6811	0.0000	0.0000	0.0000	0.0000;
	754	61	0.00157	0.06775	0	160	160	160	0.9898	0	1	-360	360	-56.6904	-6.8164	56.7331	8.6588	0.0000	0.0000	0.0000	0.0000;
	765	62	0.00163	0.067831	0	160	160	160	0.9889	0	1	-360	360	-84.5905	-4.5637	84.6875	8.5992	0.0000	0.0000	0.0000	0.0000;
	764	63	0.00143	0.06831	0	160	160	160	0.9904	0	1	-360	360	-83.6993	-7.3774	83.7833	11.3872	0.0000	0.0000	0.0000	0.0000;
	774	64	0.00139	0.0608	0	250	250	250	1.0397	0	1	-360	360	-54.4290	-5.8908	54.4673	7.5685	0.0000	0.0000	0.0000	0.0000;
	775	65	0.0014	0.06235	0	250	250	250	1.0396	0	1	-360	360	-52.9522	-5.5875	52.9887	7.2147	0.0000	0.0000	0.0000	0.0000;
	803	66	0.00163	0.067539	0	160	160	160	1.0093	0	1	-360	360	-60.5499	-14.3815	60.6042	16.6294	0.0000	0.0000	0.0000	0.0000;
	828	68	0.00161	0.06762	0	160	160	160	1.0083	0	1	-360	360	-73.4087	-8.8041	73.4847	11.9967	0.0000	0.0000	0.0000	0.0000;
	850	69	0.00207	0.067771	-0.003001	160	160	160	1.0047	0	1	-360	360	-96.3950	-12.1153	96.5597	17.8672	0.0000	0.0000	0.0000	0.0000;
	880	72	0.001651	0.067979	-0.003194	160	160	160	1.0092	0	1	-360	360	-90.9101	-17.0964	91.0286	22.3611	0.0000	0.0000	0.0000	0.0000;
	897	75	0.00145	0.069211	-0.005324	160	160	160	1.0034	0	1	-360	360	-87.6129	-19.3741	87.7121	24.7413	0.0000	0.0000	0.0000	0.0000;
	998	82	0.00156	0.06269	-0.00992	250	250	250	1.0507	0	1	-360	360	40.9681	38.1950	-40.9256	-35.3840	0.0000	0.0000	0.0000	0.0000;
	999	82	0.00156	0.06269	-0.00992	250	250	250	1.0508	0	1	-360	360	51.8023	38.1502	-51.7461	-34.7864	0.0000	0.0000	0.0000	0.0000;
	1088	83	0.001651	0.06694	-0.003098	160	160	160	0.988	0	1	-360	360	50.2947	8.3214	-50.2602	-6.5382	0.0000	0.0000	0.0000	0.0000;
	1089	83	0.00145	0.066531	-0.003194	160	160	160	0.9837	0	1	-360	360	53.6746	16.2067	-53.6382	-14.1417	0.0000	0.0000	0.0000	0.0000;
	1111	84	0.00145	0.0655	-0.002517	160	160	160	1.0007	0	1	-360	360	-103.5006	-18.3470	103.6350	24.7196	0.0000	0.0000	0.0000	0.0000;
	1110	85	0.00145	0.07045	-0.002517	160	160	160	1.0015	0	1	-360	360	-22.7472	-8.1849	22.7542	8.8327	0.0000	0.0000	0.0000	0.0000;
	1186	88	0.00145	0.069831	-0.002323	160	160	160	0.9488	0	1	-360	360	-56.9870	-16.7880	57.0300	19.1381	0.0000	0.0000	0.0000	0.0000;
	1187	89	0.001651	0.067771	-0.002807	160	160	160	1.0045	0	1	-360	360	-27.8346	-31.1684	27.8593	32.5177	0.0000	0.0000	0.0000	0.0000;
	1232	94	0.00145	0.06736	-0.006582	160	160	160	0.9972	0	1	-360	360	-19.8135	-17.4900	19.8220	18.6888	0.0000	0.0000	0.0000	0.0000;
	1231	95	0.001651	0.06694	-0.002904	160	160	160	0.9952	0	1	-360	360	-13.0902	12.2685	13.0944	-11.7388	0.0000	0.0000	0.0000	0.0000;
	1246	96	0.00145	0.068391	-0.003194	160	160	160	0.9968	0	1	-360	360	-56.0756	-13.8620	56.1160	16.1543	0.0000	0.0000	0.0000	0.0000;
	1254	100	0.001651	0.06694	-0.002323	160	160	160	0.9822	0	1	-360	360	-101.7822	0.9368	101.9248	5.1238	0.0000	0.0000	0.0000	0.0000;
	1253	101	0.001651	0.06694	-0.003194	160	160	160	0.9894	0	1	-360	360	-85.7502	-6.3945	85.8527	10.9335	0.0000	0.0000	0.0000	0.0000;
	1285	102	0.00145	0.06756	-0.002226	160	160	160	0.9901	0	1	-360	360	-99.5063	13.1394	99.6252	-7.3310	0.0000	0.0000	0.0000	0.0000;
	1284	103	0.001651	0.06756	-0.003194	160	160	160	1.0106	0	1	-360	360	-110.7915	-26.9563	110.9747	34.8354	0.0000	0.0000	0.0000	0.0000;
	1287	104	0.00145	0.066531	-0.002904	160	160	160	0.991	0	1	-360	360	-24.2116	14.6136	24.2208	-13.8304	0.0000	0.0000	0.0000	0.0000;
	1362	105	0.001651	0.068599	-0.002904	160	160	160	0.9899	0	1	-360	360	-57.1743	32.9570	57.2306	-30.2539	0.0000	0.0000	0.0000	0.0000;
	1350	106	0.00207	0.093599	-0.003388	160	160	160	0.9902	0	1	-360	360	-57.3706	-14.1863	57.4312	17.3366	0.0000	0.0000	0.0000	0.0000;
	1352	107	0.00186	0.092771	-0.003001	160	160	160	0.9928	0	1	-360	360	-8.2382	12.9260	8.2416	-12.3836	0.0000	0.0000	0.0000	0.0000;
	1387	108	0.00145	0.067151	-0.002226	160	160	160	1.0009	0	1	-360	360	-74.6263	-26.8351	74.7039	30.6950	0.0000	0.0000	0.0000	0.0000;
	1393	110	0.00145	0.0657	-0.005227	160	160	160	0.9921	0	1	-360	360	-86.0525	-1.0798	86.1412	5.7336	0.0000	0.0000	0.0000	0.0000;
	1433	111	0.00145	0.06756	-0.003485	160	160	160	1.0202	0	1	-360	360	-89.1254	-42.1552	89.2498	48.3561	0.0000	0.0000	0.0000	0.0000;
	1572	113	0.00145	0.06756	-0.002904	160	160	160	1.0079	0	1	-360	360	-90.3611	-16.1426	90.4647	21.3127	0.0000	0.0000	0.0000	0.0000;
	1632	115	0.00156	0.06269	-0.00864	250	250	250	1.0559	0	1	-360	360	-69.0785	-41.6788	69.1774	46.5710	0.0000	0.0000	0.0000	0.0000;
	1634	115	0.00156	0.06294	-0.00864	250	250	250	1.0575	0	1	-360	360	-46.8890	-20.0018	46.9275	22.4829	0.0000	0.0000	0.0000	0.0000;
	1677	116	0.00145	0.06736	-0.002226	160	160	160	0.9998	0	1	-360	360	-56.3727	-18.8536	56.4155	21.1122	0.0000	0.0000	0.0000	0.0000;
	1687	119	0.00145	0.06674	-0.006582	160	160	160	0.9905	0	1	-360	360	-127.3391	4.4226	127.5316	5.2407	0.0000	0.0000	0.0000	0.0000;
	1795	120	0.00137	0.05988	-0.01504	250	250	250	1.0629	0	1	-360	360	-93.5394	-56.8644	93.7009	65.5212	0.0000	0.0000	0.0000	0.0000;
	1797	122	0.00137	0.06119	-0.00992	250	250	250	1.0564	0	1	-360	360	1.3947	-25.6316	-1.3859	27.1017	0.0000	0.0000	0.0000	0.0000;
	1798	123	0.00156	0.06269	-0.00992	250	250	250	1.0578	0	1	-360	360	-29.9485	-29.1047	29.9745	31.2252	0.0000	0.0000	0.0000	0.0000;
	1823	124	0.001651	0.06694	-0.003001	160	160	160	0.9898	0	1	-360	360	-85.1473	1.3650	85.2459	2.9966	0.0000	0.0000	0.0000	0.0000;
	1843	125	0.00145	0.068599	-0.002323	160	160	160	1.0013	0	1	-360	360	-56.0858	-2.3672	56.1232	4.4211	0.0000	0.0000	0.0000	0.0000;
	1842	126	0.001651	0.06818	-0.002904	160	160	160	1.01	0	1	-360	360	-84.4128	-26.1446	84.5216	30.9876	0.0000	0.0000	0.0000	0.0000;
	1863	129	0.00145	0.06756	-0.003775	160	160	160	1.0061	0	1	-360	360	-100.2236	-14.9970	100.3496	21.3161	0.0000	0.0000	0.0000	0.0000;
	1864	130	0.00145	0.0655	-0.002904	160	160	160	1.0007	0	1	-360	360	-97.4222	-16.7262	97.5422	22.4899	0.0000	0.0000	0.0000	0.0000;
	1933	134	0.001651	0.0625	0	160	160	160	0.9763	0	1	-360	360	4.2705	52.0072	-4.2358	-50.6945	0.0000	0.0000	0.0000	0.0000;
	1955	136	0.00145	0.06818	0	160	160	160	1.03	0	1	-360	360	-79.5727	-13.4884	79.6552	17.3706	0.0000	0.0000	0.0000	0.0000;
	1956	136	0.001651	0.06818	0	160	160	160	1.0312	0	1	-360	360	-86.9603	-16.9180	87.0741	21.6195	0.0000	0.0000	0.0000	0.0000;
	1979	137	0.00151	0.06688	0	160	160	160	1.0376	0	1	-360	360	-107.3980	-20.5886	107.5558	27.5764	0.0000	0.0000	0.0000	0.0000;
	1981	138	0.00153	0.06206	0	250	250	250	1.1425	0	1	-360	360	-184.4024	-57.9552	185.0046	82.3810	0.0000	0.0000	0.0000	0.0000;
	1982	139	0.00152	0.06206	0	250	250	250	1.0991	0	1	-360	360	-100.7488	-14.3667	100.9035	20.6850	0.0000	0.0000	0.0000	0.0000;
	1987	140	0.00151	0.06688	0	160	160	160	0.9866	0	1	-360	360	-125.8603	35.9719	126.0703	-26.6748	0.0000	0.0000	0.0000	0.0000;
	2013	141	0.00151	0.06688	0	160	160	160	1.0141	0	1	-360	360	-81.7483	-15.8908	81.8378	19.8561	0.0000	0.0000	0.0000	0.0000;
	2019	143	0.00161	0.066531	0	160	160	160	0.9899	0	1	-360	360	-29.9406	23.7359	29.9596	-22.9498	0.0000	0.0000	0.0000	0.0000;
	2020	143	0.00161	0.066531	0	160	160	160	1	0	1	-360	360	-63.7466	-1.1786	63.8011	3.4316	0.0000	0.0000	0.0000	0.0000;
	2081	144	0.00145	0.06818	0	160	160	160	1.0026	0	1	-360	360	-8.2642	21.1645	8.2702	-20.8787	0.0000	0.0000	0.0000	0.0000;
	2082	144	0.00145	0.06818	0	160	160	160	1.009	0	1	-360	360	-35.7383	7.1099	35.7542	-6.3624	0.0000	0.0000	0.0000	0.0000;
	2097	146	0.001651	0.06851	0	160	160	160	0.984	0	1	-360	360	3.2973	22.5945	-3.2905	-22.3115	0.0000	0.0000	0.0000	0.0000;
	2096	147	0.003409	0.231401	0	80	80	80	1.0081	0	1	-360	360	-55.1173	2.6393	55.2020	3.1055	0.0000	0.0000	0.0000	0.0000;
	2098	2096	0.01124	0.452479	0	80	80	80	0.9355	0	1	-360	360	36.4410	4.0442	-36.3219	0.7472	0.0000	0.0000	0.0000	0.0000;
	2098	147	0.00562	0.22624	0	80	80	80	0.9407	0	1	-360	360	14.9920	5.1878	-14.9808	-4.7342	0.0000	0.0000	0.0000	0.0000;
	2108	148	0.00163	0.061359	0.004162	160	160	160	0.9892	0	1	-360	360	-52.6641	36.2443	52.7166	-34.7880	0.0000	0.0000	0.0000	0.0000;
	2150	152	0.001651	0.0593	0	160	160	160	1.0181	0	1	-360	360	-106.4710	-14.9787	106.6455	21.2458	0.0000	0.0000	0.0000	0.0000;
	2158	153	0.001651	0.0593	0	160	160	160	1.0127	0	1	-360	360	-85.9451	21.5996	86.0554	-17.6371	0.0000	0.0000	0.0000	0.0000;
	2159	154	0.001651	0.0593	0	160	160	160	1.0168	0	1	-360	360	-90.2633	6.3706	90.3802	-2.1742	0.0000	0.0000	0.0000	0.0000;
	2175	156	0.001651	0.092771	0	160	160	160	1.0235	0	1	-360	360	-39.5831	-17.2440	39.6088	18.6882	0.0000	0.0000	0.0000	0.0000;
	2176	155	0.001651	0.06694	0	160	160	160	1.0054	0	1	-360	360	-58.9844	7.3404	59.0314	-5.4312	0.0000	0.0000	0.0000	0.0000;
	2181	160	0.000289	0.061359	0.004162	160	160	160	1.0126	0	1	-360	360	-63.9641	-16.9052	63.9749	18.7042	0.0000	0.0000	0.0000	0.0000;
	2182	160	0.001651	0.068599	0	160	160	160	1.0167	0	1	-360	360	-90.7913	-18.3359	90.9133	23.4056	0.0000	0.0000	0.0000	0.0000;
	2213	162	0.00101	0.06188	-0.01984	330	330	330	1.1081	0	1	-360	360	-180.0773	-27.7591	180.4187	50.6789	0.0000	0.0000	0.0000	0.0000;
	2216	163	0.00101	0.06188	0	330	330	330	1.1014	0	1	-360	360	-121.3592	-19.6541	121.5091	28.8408	0.0000	0.0000	0.0000	0.0000;
	2217	163	0.00138	0.05931	0	250	250	250	1.0911	0	1	-360	360	-153.1822	2.5089	153.4933	10.8590	0.0000	0.0000	0.0000	0.0000;
	2218	165	0.00163	0.070331	0	160	160	160	0.9771	0	1	-360	360	34.4026	58.5044	-34.3454	-56.0385	0.0000	0.0000	0.0000	0.0000;
	2237	168	0.001651	0.0593	0	160	160	160	0.9886	0	1	-360	360	-62.4131	4.3063	62.4683	-2.3228	0.0000	0.0000	0.0000	0.0000;
	2238	168	0.001651	0.0593	0	160	160	160	0.9895	0	1	-360	360	-61.0434	2.5455	61.0961	-0.6506	0.0000	0.0000	0.0000	0.0000;
	2239	169	0.00281	0.10601	0	100	100	100	0.9302	0	1	-360	360	-12.6710	-5.4550	12.6755	5.6257	0.0000	0.0000	0.0000	0.0000;
	2240	169	0.00281	0.10601	0	100	100	100	0.9302	0	1	-360	360	-16.1510	-5.4550	16.1579	5.7157	0.0000	0.0000	0.0000	0.0000;
	2242	171	0.001651	0.0593	0	160	160	160	1.0042	0	1	-360	360	-108.0897	6.7031	108.2536	-0.8139	0.0000	0.0000	0.0000	0.0000;
	2241	172	0.00101	0.06188	-0.01984	330	330	330	1.0921	0	1	-360	360	-75.7526	-16.2104	75.8144	21.9777	0.0000	0.0000	0.0000	0.0000;
	2242	172	0.00153	0.06206	0	250	250	250	1.0902	0	1	-360	360	-58.8159	-5.1685	58.8691	7.3277	0.0000	0.0000	0.0000	0.0000;
	2255	174	0.001651	0.066531	0	160	160	160	1.0737	0	1	-360	360	-87.4525	-75.3959	87.6752	84.3702	0.0000	0.0000	0.0000	0.0000;
	2256	175	0.001651	0.06775	0	160	160	160	1.0563	0	1	-360	360	-106.3753	-42.2147	106.5851	50.8211	0.0000	0.0000	0.0000	0.0000;
	2261	176	0.001651	0.052289	0	160	160	160	1.0025	0	1	-360	360	-82.0344	4.1315	82.1290	-1.1338	0.0000	0.0000	0.0000	0.0000;
	2325	177	0.001651	0.06818	0	160	160	160	1.0279	0	1	-360	360	-99.5327	-17.6907	99.6794	23.7527	0.0000	0.0000	0.0000	0.0000;
	2326	178	0.001651	0.06818	0	160	160	160	1.0229	0	1	-360	360	-83.0553	-4.4484	83.1529	8.4815	0.0000	0.0000	0.0000	0.0000;
	2430	179	0.001651	0.06632	0	160	160	160	1.0143	0	1	-360	360	-117.8714	-0.1329	118.0659	7.9499	0.0000	0.0000	0.0000	0.0000;
	2452	181	0.001651	0.06632	0	160	160	160	1.0527	0	1	-360	360	-86.4553	-39.1555	86.5992	44.9370	0.0000	0.0000	0.0000	0.0000;
	2451	181	0.001651	0.06632	0	160	160	160	1.0347	0	1	-360	360	-54.9271	-8.3271	54.9743	10.2262	0.0000	0.0000	0.0000	0.0000;
	2473	182	0.00155	0.065849	0	160	160	160	1.0969	0	1	-360	360	-78.1236	-37.2172	78.2349	41.9468	0.0000	0.0000	0.0000	0.0000;
	2497	185	0.00137	0.05969	0	250	250	250	1.067	0	1	-360	360	-101.1515	3.8535	101.2824	1.8500	0.0000	0.0000	0.0000	0.0000;
	2506	186	0.00129	0.06437	0	250	250	250	1.1036	0	1	-360	360	-135.4289	-4.0421	135.6610	15.6216	0.0000	0.0000	0.0000	0.0000;
	2507	187	0.00129	0.06437	0	250	250	250	1.0973	0	1	-360	360	-135.7949	5.2264	136.0257	6.2873	0.0000	0.0000	0.0000	0.0000;
	2510	189	0.0037	0.18657	0	120	120	120	1.1338	0	1	-360	360	-12.5530	-21.8236	12.5774	23.0562	0.0000	0.0000	0.0000	0.0000;
	2511	188	0.001591	0.06694	0	160	160	160	1.1351	0	1	-360	360	-47.1630	-57.4463	47.2543	61.2866	0.0000	0.0000	0.0000	0.0000;
	2527	190	0.00163	0.066711	0	160	160	160	1.0633	0	1	-360	360	-71.4078	-25.9149	71.4926	29.3854	0.0000	0.0000	0.0000	0.0000;
	2529	191	0.00163	0.066711	0	160	160	160	1.0634	0	1	-360	360	-70.7125	-25.8362	70.7958	29.2450	0.0000	0.0000	0.0000	0.0000;
	2528	192	0.00059	0.04206	0	330	330	330	1.1604	0	1	-360	360	-202.1930	-47.8693	202.4664	67.3614	0.0000	0.0000	0.0000	0.0000;
	2535	193	0.001591	0.06736	0	160	160	160	1.0755	0	1	-360	360	-80.7132	-20.9508	80.8153	25.2753	0.0000	0.0000	0.0000	0.0000;
	2536	194	0.001591	0.06736	0	160	160	160	1.0777	0	1	-360	360	-80.7349	-24.3066	80.8397	28.7458	0.0000	0.0000	0.0000	0.0000;
	2600	196	0.00089	0.05411	0	330	330	330	1.1448	0	1	-360	360	-144.3333	-48.6726	144.5501	61.8498	0.0000	0.0000	0.0000	0.0000;
	2603	197	0.00161	0.06756	0	160	160	160	1.0598	0	1	-360	360	-66.2450	-14.1948	66.3118	16.9963	0.0000	0.0000	0.0000	0.0000;
	2604	198	0.00161	0.06756	0	160	160	160	1.059	0	1	-360	360	-66.5252	-12.9741	66.5919	15.7736	0.0000	0.0000	0.0000	0.0000;
	2669	199	0.00059	0.04206	0	330	330	330	1.0552	0	1	-360	360	-158.0291	37.5909	158.1702	-27.5331	0.0000	0.0000	0.0000	0.0000;
	2689	202	0.002771	0.1062	0	100	100	100	1.048	0	1	-360	360	-46.3141	-17.1475	46.3779	19.5952	0.0000	0.0000	0.0000	0.0000;
	2688	201	0.00157	0.0675	0	160	160	160	1.048	0	1	-360	360	-73.2407	-27.4049	73.3315	31.3066	0.0000	0.0000	0.0000	0.0000;
	2706	203	0.00161	0.06736	0	160	160	160	1.051	0	1	-360	360	-71.3550	-33.5216	71.4500	37.4973	0.0000	0.0000	0.0000	0.0000;
	2706	204	0.001651	0.066711	0	160	160	160	1.05	0	1	-360	360	-71.7009	-32.2625	71.7976	36.1716	0.0000	0.0000	0.0000	0.0000;
	2726	205	0.00137	0.05969	0	250	250	250	1.084	0	1	-360	360	-102.8177	5.9238	102.9559	0.0995	0.0000	0.0000	0.0000	0.0000;
	2727	205	0.00137	0.05969	0	250	250	250	1.084	0	1	-360	360	-102.4300	5.9645	102.5672	0.0134	0.0000	0.0000	0.0000	0.0000;
	2729	207	0.00155	0.067979	0	160	160	160	1.0441	0	1	-360	360	-38.7845	-18.3146	38.8096	19.4123	0.0000	0.0000	0.0000	0.0000;
	2730	208	0.00161	0.06775	0	160	160	160	1.0424	0	1	-360	360	-39.8373	-15.5810	39.8630	16.6655	0.0000	0.0000	0.0000	0.0000;
	2592	346	0.054463	0.101322	0.00968	90	90	90	0	0	1	-360	360	-0.5660	4.8670	0.5798	-5.9833	0.0000	0.0000	0.0000	0.0000;
	2087	289	0.023719	0.06124	0.006241	102	102	102	0	0	1	-360	360	1.6042	1.4791	-1.6030	-2.2187	0.0000	0.0000	0.0000	0.0000;
	2122	312	0.024711	0.06281	0.006411	111	111	111	0	0	1	-360	360	27.3270	1.1046	-27.1742	-1.4881	0.0000	0.0000	0.0000	0.0000;
	1932	416	0.042066	0.108603	0.011069	108	108	108	0	0	1	-360	360	16.0080	10.0442	-15.8829	-11.0834	0.0000	0.0000	0.0000	0.0000;
	2069	221	0.061818	0.105041	0.01014	87	87	87	0	0	1	-360	360	-0.4985	-2.2096	0.5000	1.0000	0.0000	0.0000	0.0000	0.0000;
	2383	522	0.059256	0.103967	0.010481	87	87	87	0	0	1	-360	360	-21.8421	-10.6823	22.1421	9.9855	0.0000	0.0000	0.0000	0.0000;
	1262	242	0.033058	0.080992	0.01007	120	120	120	0	0	1	-360	360	-51.3487	-8.2619	52.0910	8.8476	0.0000	0.0000	0.0000	0.0000;
	1272	435	0.021488	0.071066	0.007241	90	90	90	0	0	1	-360	360	0.0000	-0.8623	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	672	377	0.047273	0.083876	0.007739	90	90	90	0	0	1	-360	360	-24.6238	5.5493	24.8920	-5.9545	0.0000	0.0000	0.0000	0.0000;
	624	402	0.074628	0.130248	0.012439	90	90	90	0	0	1	-360	360	24.5777	-12.9890	-24.1011	12.3538	0.0000	0.0000	0.0000	0.0000;
	770	460	0.052231	0.090083	0.008661	90	90	90	0	0	1	-360	360	-34.9937	-3.2669	35.5369	3.1589	0.0000	0.0000	0.0000	0.0000;
	824	1278	0.045446	0.079339	0.008521	69	69	69	0	0	1	-360	360	-8.3568	1.3941	8.3855	-2.3391	0.0000	0.0000	0.0000	0.0000;
	673	1578	0.03719	0.060331	0.006561	58	58	58	0	0	1	-360	360	-26.9255	5.1575	27.1662	-5.5375	0.0000	0.0000	0.0000	0.0000;
	737	1657	0.041322	0.139669	0.01241	137	137	137	0	0	1	-360	360	12.0225	1.9624	-11.9700	-3.2565	0.0000	0.0000	0.0000	0.0000;
	763	1360	0.023967	0.053719	0.008809	69	69	69	0	0	1	-360	360	-5.7869	9.9763	5.8176	-10.8861	0.0000	0.0000	0.0000	0.0000;
	1741	593	0.02438	0.049091	0.004709	90	90	90	0	0	1	-360	360	18.3778	-1.1588	-18.3034	0.7877	0.0000	0.0000	0.0000	0.0000;
	2207	1148	0.035537	0.066124	0.00765	90	90	90	0	0	1	-360	360	-18.7890	-7.2010	18.9089	6.5120	0.0000	0.0000	0.0000	0.0000;
	2423	1147	0.070248	0.120661	0.012901	67	67	67	0	0	1	-360	360	-4.0650	-0.4400	4.0747	-1.0930	0.0000	0.0000	0.0000	0.0000;
	2429	981	0.021488	0.027273	0.005111	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2660	2157	0.068256	0.184298	0.017981	50	50	50	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2493	2363	0.034628	0.060744	0.005711	69	69	69	0	0	1	-360	360	-6.8050	-4.9889	6.8257	4.3730	0.0000	0.0000	0.0000	0.0000;
	2695	2016	0.029174	0.051157	0.004859	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2681	2218	0.03719	0.096686	0.010159	120	120	120	0	0	1	-360	360	-67.7294	2.3115	69.1471	0.1247	0.0000	0.0000	0.0000	0.0000;
	2617	2218	0.082066	0.200083	0.02217	120	120	120	0	0	1	-360	360	-66.7907	6.3346	69.9961	-1.1926	0.0000	0.0000	0.0000	0.0000;
	2622	2219	0.044628	0.115207	0.012049	120	120	120	0	0	1	-360	360	-19.7218	-18.8011	19.9893	18.0166	0.0000	0.0000	0.0000	0.0000;
	2575	2096	0.041322	0.087603	0.012199	120	120	120	0	0	1	-360	360	-73.2298	-0.0982	75.1036	2.5889	0.0000	0.0000	0.0000	0.0000;
	2567	1937	0.039256	0.107438	0.011081	120	120	120	0	0	1	-360	360	-50.7056	12.8211	51.6370	-11.5650	0.0000	0.0000	0.0000	0.0000;
	2587	2219	0.056281	0.183223	0.01876	137	137	137	0	0	1	-360	360	-15.8040	-17.0005	16.0444	15.5024	0.0000	0.0000	0.0000	0.0000;
	1691	786	0.038843	0.064463	0.00695	58	58	58	0	0	1	-360	360	27.1264	-9.3406	-26.8554	8.9809	0.0000	0.0000	0.0000	0.0000;
	2657	2206	0.023058	0.07438	0.007841	137	137	137	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	660	449	0.046777	0.323967	0.031511	133	133	133	0	0	1	-360	360	50.4795	3.7100	-49.5144	-0.8698	0.0000	0.0000	0.0000	0.0000;
	1290	2079	0.040496	0.050413	0.00719	57	57	57	0	0	1	-360	360	13.9413	-2.9379	-13.8703	2.2058	0.0000	0.0000	0.0000	0.0000;
	522	1212	0.057016	0.113223	0.01232	90	90	90	0	0	1	-360	360	-1.0034	-2.8827	1.0061	1.4172	0.0000	0.0000	0.0000	0.0000;
	660	460	0.016364	0.053141	0.00619	120	120	120	0	0	1	-360	360	47.4848	7.3754	-47.1819	-7.1589	0.0000	0.0000	0.0000	0.0000;
	661	252	0.056612	0.130504	0.01307	90	90	90	0	0	1	-360	360	71.8378	-3.1770	-69.4985	6.9792	0.0000	0.0000	0.0000	0.0000;
	509	1014	0.009917	0.029752	0.00356	137	137	137	0	0	1	-360	360	30.3824	1.1822	-30.3073	-1.3903	0.0000	0.0000	0.0000	0.0000;
	2541	2394	0.053331	0.089256	0.009169	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	758	377	0.013967	0.045041	0.00462	137	137	137	0	0	1	-360	360	-14.2613	8.9059	14.2962	-9.3234	0.0000	0.0000	0.0000	0.0000;
	706	330	0.059917	0.101488	0.01089	90	90	90	0	0	1	-360	360	-5.6545	3.2563	5.6784	-4.5020	0.0000	0.0000	0.0000	0.0000;
	691	449	0.07438	0.130248	0.012359	90	90	90	0	0	1	-360	360	28.0755	-11.2422	-27.5193	10.7390	0.0000	0.0000	0.0000	0.0000;
	2559	254	0.038843	0.126446	0.013	76	76	76	0	0	1	-360	360	-9.6553	-3.7642	9.6894	2.3507	0.0000	0.0000	0.0000	0.0000;
	2592	240	0.037017	0.06719	0.006389	76	76	76	0	0	1	-360	360	-11.5850	6.4512	11.6415	-7.1054	0.0000	0.0000	0.0000	0.0000;
	724	476	0.01719	0.055703	0.005689	137	137	137	0	0	1	-360	360	6.7279	2.2311	-6.7202	-2.8640	0.0000	0.0000	0.0000	0.0000;
	824	1671	0.01405	0.042984	0.00513	69	69	69	0	0	1	-360	360	-2.1132	-1.3941	2.1138	0.7978	0.0000	0.0000	0.0000	0.0000;
	1771	705	0.021488	0.040496	0.007991	120	120	120	0	0	1	-360	360	13.4384	-9.6769	-13.3893	8.8404	0.0000	0.0000	0.0000	0.0000;
	1709	705	0.019008	0.033876	0.00697	69	69	69	0	0	1	-360	360	0.7626	10.0588	-0.7447	-10.8404	0.0000	0.0000	0.0000	0.0000;
	1595	736	0.047934	0.06281	0.01111	90	90	90	0	0	1	-360	360	-59.0061	1.7586	60.4737	-1.1319	0.0000	0.0000	0.0000	0.0000;
	756	330	0.042314	0.075289	0.00702	90	90	90	0	0	1	-360	360	-5.7051	-4.3805	5.7226	3.5866	0.0000	0.0000	0.0000	0.0000;
	2679	369	0.096686	0.119008	0.012579	76	76	76	0	0	1	-360	360	-7.1377	2.1518	7.1862	-3.5826	0.0000	0.0000	0.0000	0.0000;
	2464	333	0.076859	0.095041	0.010159	69	69	69	0	0	1	-360	360	0.4217	-3.0262	-0.4177	1.8421	0.0000	0.0000	0.0000	0.0000;
	661	467	0.056529	0.185868	0.019079	133	133	133	0	0	1	-360	360	36.3535	1.7136	-35.7521	-2.0760	0.0000	0.0000	0.0000	0.0000;
	708	445	0.028256	0.096686	0.009361	34	34	34	0	0	1	-360	360	-7.1703	5.0858	7.1901	-6.1302	0.0000	0.0000	0.0000	0.0000;
	2547	2337	0.04314	0.071901	0.00741	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	654	1018	0.019008	0.058678	0.00682	137	137	137	0	0	1	-360	360	-22.4676	4.1942	22.5586	-4.6627	0.0000	0.0000	0.0000	0.0000;
	2591	2394	0.030744	0.099173	0.01021	69	69	69	0	0	1	-360	360	11.1340	-3.1052	-11.1016	1.9515	0.0000	0.0000	0.0000	0.0000;
	2588	344	0.021397	0.067603	0.006921	13	13	13	0	0	1	-360	360	6.0818	-0.2854	-6.0750	-0.5000	0.0000	0.0000	0.0000	0.0000;
	1520	2139	0.012397	0.03719	0.004361	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	425	354	0.012231	0.028678	0.00295	133	133	133	0	0	1	-360	360	-58.1543	-3.6463	58.5091	4.1306	0.0000	0.0000	0.0000	0.0000;
	314	220	0.019587	0.063554	0.00659	133	133	133	0	0	1	-360	360	-37.2519	6.2298	37.4994	-6.1751	0.0000	0.0000	0.0000	0.0000;
	561	517	0.00686	0.022066	0.002321	133	133	133	0	0	1	-360	360	-84.8991	-22.6221	85.3698	23.8727	0.0000	0.0000	0.0000	0.0000;
	424	561	0.005537	0.018017	0.001839	133	133	133	0	0	1	-360	360	-78.9949	-20.8520	79.3283	21.7317	0.0000	0.0000	0.0000	0.0000;
	561	565	0.002727	0.009496	0.000999	133	133	133	0	0	1	-360	360	5.5708	0.8904	-5.5700	-1.0000	0.0000	0.0000	0.0000	0.0000;
	343	339	0.023554	0.061066	0.00629	120	120	120	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.7676	0.0000	0.0000	0.0000	0.0000;
	342	340	0.023388	0.061901	0.00629	120	120	120	0	0	1	-360	360	-11.5045	-17.8236	11.5926	17.3181	0.0000	0.0000	0.0000	0.0000;
	385	339	0.015446	0.044876	0.004339	120	120	120	0	0	1	-360	360	-27.8561	-4.8030	27.9580	4.5723	0.0000	0.0000	0.0000	0.0000;
	473	340	0.019669	0.059587	0.005871	120	120	120	0	0	1	-360	360	-32.4964	-8.2880	32.6853	8.1694	0.0000	0.0000	0.0000	0.0000;
	261	401	0.031818	0.058512	0.00559	90	90	90	0	0	1	-360	360	-2.6330	-1.2000	2.6350	0.5318	0.0000	0.0000	0.0000	0.0000;
	262	402	0.032562	0.06124	0.005491	90	90	90	0	0	1	-360	360	-11.3410	-1.8000	11.3775	1.2244	0.0000	0.0000	0.0000	0.0000;
	456	340	0.002479	0.007769	0.000871	137	137	137	0	0	1	-360	360	-85.2747	-28.1334	85.4441	28.5612	0.0000	0.0000	0.0000	0.0000;
	477	401	0.040579	0.076124	0.006781	90	90	90	0	0	1	-360	360	-37.2879	-1.9289	37.7710	2.0306	0.0000	0.0000	0.0000	0.0000;
	517	456	0.013967	0.043967	0.00485	137	137	137	0	0	1	-360	360	-63.4853	-17.0433	64.0107	18.1334	0.0000	0.0000	0.0000	0.0000;
	423	345	0.043058	0.07157	0.007541	90	90	90	0	0	1	-360	360	-20.2014	-5.3343	20.3625	4.7217	0.0000	0.0000	0.0000	0.0000;
	367	239	0.027364	0.059917	0.00581	90	90	90	0	0	1	-360	360	-12.2291	12.6891	12.3053	-13.1861	0.0000	0.0000	0.0000	0.0000;
	422	237	0.024554	0.079669	0.00818	133	133	133	0	0	1	-360	360	11.4912	4.2901	-11.4593	-5.1551	0.0000	0.0000	0.0000	0.0000;
	477	272	0.055537	0.121653	0.01065	90	90	90	0	0	1	-360	360	19.0619	-3.5711	-18.8853	2.7191	0.0000	0.0000	0.0000	0.0000;
	459	447	0.111818	0.190744	0.019089	90	90	90	0	0	1	-360	360	-15.4802	2.3156	15.7220	-4.1436	0.0000	0.0000	0.0000	0.0000;
	462	253	0.030826	0.100083	0.010341	133	133	133	0	0	1	-360	360	17.1190	9.7682	-17.0152	-10.6461	0.0000	0.0000	0.0000	0.0000;
	285	275	0.019669	0.064554	0.00652	133	133	133	0	0	1	-360	360	-35.5618	-4.1418	35.7718	4.0437	0.0000	0.0000	0.0000	0.0000;
	300	276	0.020909	0.06876	0.006941	133	133	133	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.8483	0.0000	0.0000	0.0000	0.0000;
	327	389	0.023636	0.077364	0.007889	120	120	120	0	0	1	-360	360	-12.0226	-8.8781	12.0650	8.0642	0.0000	0.0000	0.0000	0.0000;
	328	327	0.002479	0.008017	0.00082	120	120	120	0	0	1	-360	360	-2.4025	-6.9727	2.4036	6.8781	0.0000	0.0000	0.0000	0.0000;
	331	259	0.04314	0.08281	0.0075	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0001	-0.8873	0.0000	0.0000	0.0000	0.0000;
	373	276	0.02281	0.074463	0.007589	133	133	133	0	0	1	-360	360	-36.0758	2.1875	36.3227	-2.3039	0.0000	0.0000	0.0000	0.0000;
	573	427	0.029339	0.095124	0.00992	133	133	133	0	0	1	-360	360	0.0000	0.0000	0.0001	-1.2096	0.0000	0.0000	0.0000	0.0000;
	386	312	0.013719	0.044554	0.00461	133	133	133	0	0	1	-360	360	10.4371	-3.3506	-10.4235	2.8431	0.0000	0.0000	0.0000	0.0000;
	335	238	0.029752	0.076859	0.00795	120	120	120	0	0	1	-360	360	-3.3634	-1.3085	3.3664	0.3759	0.0000	0.0000	0.0000	0.0000;
	382	324	0.031488	0.103471	0.01045	133	133	133	0	0	1	-360	360	51.7203	2.5637	-51.0416	-1.6161	0.0000	0.0000	0.0000	0.0000;
	383	370	0.047364	0.083141	0.007889	90	90	90	0	0	1	-360	360	36.5629	0.0039	-36.0537	-0.0774	0.0000	0.0000	0.0000	0.0000;
	370	286	0.024298	0.079752	0.008049	133	133	133	0	0	1	-360	360	48.0825	-9.5146	-47.6015	10.1232	0.0000	0.0000	0.0000	0.0000;
	387	354	0.006446	0.020248	0.002229	90	90	90	0	0	1	-360	360	-30.4421	2.3200	30.4929	-2.4245	0.0000	0.0000	0.0000	0.0000;
	415	371	0.037017	0.121322	0.0121	133	133	133	0	0	1	-360	360	14.9411	3.9206	-14.8623	-5.0392	0.0000	0.0000	0.0000	0.0000;
	533	462	0.022562	0.073223	0.0075	133	133	133	0	0	1	-360	360	12.5136	4.0501	-12.4804	-4.8398	0.0000	0.0000	0.0000	0.0000;
	581	325	0.059256	0.104554	0.00969	90	90	90	0	0	1	-360	360	0.5425	3.9544	-0.5319	-5.0578	0.0000	0.0000	0.0000	0.0000;
	462	223	0.027438	0.082636	0.009951	133	133	133	0	0	1	-360	360	2.0410	4.2844	-2.0345	-5.4450	0.0000	0.0000	0.0000	0.0000;
	461	475	0.048934	0.155041	0.01573	133	133	133	0	0	1	-360	360	-8.6366	-3.9120	8.6709	2.1344	0.0000	0.0000	0.0000	0.0000;
	451	423	0.023802	0.078099	0.007889	133	133	133	0	0	1	-360	360	-8.6366	-5.9687	8.6584	5.1343	0.0000	0.0000	0.0000	0.0000;
	288	399	0.007107	0.02281	0.00242	133	133	133	0	0	1	-360	360	-25.6791	5.7776	25.7225	-5.9133	0.0000	0.0000	0.0000	0.0000;
	490	452	0.013719	0.04438	0.0046	137	137	137	0	0	1	-360	360	-5.3293	8.2958	5.3411	-8.7993	0.0000	0.0000	0.0000	0.0000;
	534	291	0.020909	0.052727	0.005801	120	120	120	0	0	1	-360	360	1.2796	1.7351	-1.2786	-2.4310	0.0000	0.0000	0.0000	0.0000;
	271	317	0.011157	0.030413	0.003291	133	133	133	0	0	1	-360	360	-39.5406	-1.1746	39.6937	1.2150	0.0000	0.0000	0.0000	0.0000;
	317	349	0.006686	0.019339	0.002069	137	137	137	0	0	1	-360	360	-53.3637	-4.8150	53.5306	5.0588	0.0000	0.0000	0.0000	0.0000;
	564	516	0.004554	0.014711	0.001539	133	133	133	0	0	1	-360	360	-10.1260	-1.5000	10.1302	1.3381	0.0000	0.0000	0.0000	0.0000;
	211	353	0.006281	0.019339	0.00221	137	137	137	0	0	1	-360	360	34.0613	-22.5915	-33.9724	22.6046	0.0000	0.0000	0.0000	0.0000;
	211	358	0.006198	0.019917	0.002096	137	137	137	0	0	1	-360	360	-43.1753	20.5915	43.2961	-20.4496	0.0000	0.0000	0.0000	0.0000;
	548	353	0.00438	0.010826	0.001191	133	133	133	0	0	1	-360	360	-61.1424	-20.5927	61.2979	20.8371	0.0000	0.0000	0.0000	0.0000;
	557	502	0.007273	0.020661	0.002021	120	120	120	0	0	1	-360	360	5.9320	-2.3633	-5.9295	2.1389	0.0000	0.0000	0.0000	0.0000;
	558	503	0.007273	0.020661	0.002021	120	120	120	0	0	1	-360	360	12.8044	-2.9167	-12.7935	2.7175	0.0000	0.0000	0.0000	0.0000;
	503	493	0.00562	0.017769	0.001951	133	133	133	0	0	1	-360	360	-45.9591	-15.1544	46.0744	15.2957	0.0000	0.0000	0.0000	0.0000;
	494	352	0.007438	0.019008	0.002081	133	133	133	0	0	1	-360	360	-90.6321	-28.5327	91.2153	29.7808	0.0000	0.0000	0.0000	0.0000;
	543	354	0.004298	0.026942	0.002887	120	120	120	0	0	1	-360	360	-22.5045	-16.5502	22.5328	16.3867	0.0000	0.0000	0.0000	0.0000;
	531	352	0.013636	0.033967	0.003751	120	120	120	0	0	1	-360	360	-16.1177	3.0901	16.1492	-3.4521	0.0000	0.0000	0.0000	0.0000;
	525	353	0.010826	0.02719	0.003001	120	120	120	0	0	1	-360	360	-33.8746	6.5710	33.9843	-6.6494	0.0000	0.0000	0.0000	0.0000;
	541	530	0.003876	0.009421	0.00105	120	120	120	0	0	1	-360	360	52.3037	23.6546	-52.1963	-23.5183	0.0000	0.0000	0.0000	0.0000;
	535	560	0.010165	0.025289	0.002708	120	120	120	0	0	1	-360	360	52.5354	9.6102	-52.2924	-9.3269	0.0000	0.0000	0.0000	0.0000;
	490	353	0.00157	0.005124	0.00053	133	133	133	0	0	1	-360	360	6.8043	-5.8958	-6.8032	5.8367	0.0000	0.0000	0.0000	0.0000;
	491	353	0.002066	0.006686	0.000709	133	133	133	0	0	1	-360	360	-24.3106	-13.5041	24.3241	13.4642	0.0000	0.0000	0.0000	0.0000;
	535	524	0.017934	0.048016	0.00522	120	120	120	0	0	1	-360	360	-0.0676	15.3078	0.1043	-15.8292	0.0000	0.0000	0.0000	0.0000;
	538	548	0.01405	0.039669	0.00432	133	133	133	0	0	1	-360	360	-41.6653	-14.7213	41.9034	14.8927	0.0000	0.0000	0.0000	0.0000;
	536	535	0.00438	0.010578	0.0012	120	120	120	0	0	1	-360	360	-11.1380	-3.3000	11.1429	3.1687	0.0000	0.0000	0.0000	0.0000;
	537	534	0.00438	0.010578	0.0012	120	120	120	0	0	1	-360	360	-17.2140	-5.1000	17.2257	4.9837	0.0000	0.0000	0.0000	0.0000;
	558	542	0.007273	0.017603	0.00196	120	120	120	0	0	1	-360	360	34.1494	-2.4432	-34.0747	2.4009	0.0000	0.0000	0.0000	0.0000;
	558	500	0.00124	0.003058	0.000351	120	120	120	0	0	1	-360	360	24.2807	1.0854	-24.2743	-1.1096	0.0000	0.0000	0.0000	0.0000;
	538	502	0.002066	0.006942	0.000699	133	133	133	0	0	1	-360	360	12.3003	7.4713	-12.2965	-7.5389	0.0000	0.0000	0.0000	0.0000;
	517	340	0.01405	0.044463	0.00484	133	133	133	0	0	1	-360	360	-77.5731	-21.5191	78.3661	23.4637	0.0000	0.0000	0.0000	0.0000;
	563	274	0.004876	0.015793	0.00166	120	120	120	0	0	1	-360	360	75.8981	26.5891	-75.6363	-25.9398	0.0000	0.0000	0.0000	0.0000;
	526	274	0.01314	0.034711	0.00364	120	120	120	0	0	1	-360	360	-74.7306	-24.4472	75.4343	25.8798	0.0000	0.0000	0.0000	0.0000;
	339	273	0.008678	0.028256	0.00287	120	120	120	0	0	1	-360	360	46.4860	2.4908	-46.3319	-2.3377	0.0000	0.0000	0.0000	0.0000;
	336	273	0.002066	0.005289	0.00054	120	120	120	0	0	1	-360	360	-45.7900	-2.1611	45.8259	2.1877	0.0000	0.0000	0.0000	0.0000;
	534	336	0.008099	0.019587	0.00219	120	120	120	0	0	1	-360	360	-27.5124	3.0992	27.5640	-3.2389	0.0000	0.0000	0.0000	0.0000;
	550	337	0.012479	0.032149	0.00319	120	120	120	0	0	1	-360	360	10.0802	-2.8224	-10.0683	2.4903	0.0000	0.0000	0.0000	0.0000;
	539	495	0.000413	0.001653	0.008661	109	109	109	0	0	1	-360	360	-22.8650	-2.5546	22.8668	1.5445	0.0000	0.0000	0.0000	0.0000;
	495	560	0.002521	0.007207	0.009269	120	120	120	0	0	1	-360	360	-52.2318	-10.2445	52.2924	9.3269	0.0000	0.0000	0.0000	0.0000;
	531	560	0.001372	0.003545	0.000361	120	120	120	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	352	359	0.012397	0.039174	0.004291	133	133	133	0	0	1	-360	360	-47.5867	16.7557	47.8561	-16.4086	0.0000	0.0000	0.0000	0.0000;
	518	359	0.00438	0.014132	0.001498	133	133	133	0	0	1	-360	360	-92.5826	-10.8746	92.9099	11.7554	0.0000	0.0000	0.0000	0.0000;
	348	506	0.012727	0.03562	0.003531	133	133	133	0	0	1	-360	360	-44.2923	2.8239	44.5111	-2.6179	0.0000	0.0000	0.0000	0.0000;
	557	348	0.000504	0.001488	0.00015	133	133	133	0	0	1	-360	360	-30.6180	6.1993	30.6223	-6.2039	0.0000	0.0000	0.0000	0.0000;
	544	271	0.004207	0.011653	0.001261	133	133	133	0	0	1	-360	360	-21.2965	3.2292	21.3136	-3.3254	0.0000	0.0000	0.0000	0.0000;
	503	418	0.001397	0.005868	0.031039	95	95	95	0	0	1	-360	360	41.5386	7.3369	-41.5164	-10.7778	0.0000	0.0000	0.0000	0.0000;
	353	575	0.005289	0.016942	0.001781	133	133	133	0	0	1	-360	360	20.2750	5.1277	-20.2554	-5.2748	0.0000	0.0000	0.0000	0.0000;
	352	515	0.003967	0.01281	0.00135	133	133	133	0	0	1	-360	360	38.5345	9.4350	-38.4813	-9.4216	0.0000	0.0000	0.0000	0.0000;
	523	543	0.000413	0.001901	0.009929	98	98	98	0	0	1	-360	360	-53.6670	-11.8286	53.6776	10.7102	0.0000	0.0000	0.0000	0.0000;
	530	525	0.003223	0.007934	0.000881	120	120	120	0	0	1	-360	360	20.8304	22.7310	-20.8044	-22.7710	0.0000	0.0000	0.0000	0.0000;
	545	491	0.003141	0.009917	0.001019	133	133	133	0	0	1	-360	360	-16.2020	-4.8000	16.2096	4.7041	0.0000	0.0000	0.0000	0.0000;
	506	576	0.000579	0.001744	0.000179	133	133	133	0	0	1	-360	360	-69.8251	-4.8821	69.8497	4.9354	0.0000	0.0000	0.0000	0.0000;
	541	534	0.00438	0.010661	0.001191	120	120	120	0	0	1	-360	360	-87.7437	-32.4046	88.0653	33.0448	0.0000	0.0000	0.0000	0.0000;
	550	500	0.010174	0.024628	0.002739	120	120	120	0	0	1	-360	360	-14.1302	1.6224	14.1483	-1.8904	0.0000	0.0000	0.0000	0.0000;
	547	530	0.006612	0.022314	0.00218	133	133	133	0	0	1	-360	360	15.2343	12.8290	-15.2121	-13.0127	0.0000	0.0000	0.0000	0.0000;
	547	534	0.005793	0.018934	0.00198	133	133	133	0	0	1	-360	360	-56.7503	-23.0790	56.9327	23.4381	0.0000	0.0000	0.0000	0.0000;
	532	531	0.002314	0.00686	0.000699	133	133	133	0	0	1	-360	360	-5.9913	6.0122	5.9927	-6.0901	0.0000	0.0000	0.0000	0.0000;
	535	532	0.012727	0.041322	0.004221	133	133	133	0	0	1	-360	360	28.5520	16.0869	-28.4367	-16.2122	0.0000	0.0000	0.0000	0.0000;
	518	576	0.003554	0.011397	0.001191	133	133	133	0	0	1	-360	360	70.3056	5.3746	-70.1537	-5.0254	0.0000	0.0000	0.0000	0.0000;
	349	507	0.000504	0.001488	0.00015	133	133	133	0	0	1	-360	360	-53.5306	-5.0588	53.5432	5.0785	0.0000	0.0000	0.0000	0.0000;
	520	575	0.002149	0.006942	0.000731	133	133	133	0	0	1	-360	360	-13.1640	-3.2500	13.1674	3.1748	0.0000	0.0000	0.0000	0.0000;
	519	514	0.002397	0.007851	0.00082	133	133	133	0	0	1	-360	360	-13.1630	-3.2500	13.1668	3.1664	0.0000	0.0000	0.0000	0.0000;
	558	544	0.003554	0.009917	0.00106	133	133	133	0	0	1	-360	360	-5.5986	7.7665	5.6015	-7.8792	0.0000	0.0000	0.0000	0.0000;
	557	220	0.009917	0.029752	0.003161	120	120	120	0	0	1	-360	360	46.8040	-3.7144	-46.6134	3.9251	0.0000	0.0000	0.0000	0.0000;
	535	504	0.013388	0.03876	0.004099	120	120	120	0	0	1	-360	360	73.7442	27.0305	-73.0512	-25.5056	0.0000	0.0000	0.0000	0.0000;
	501	337	0.019669	0.053554	0.005779	120	120	120	0	0	1	-360	360	8.1791	7.2883	-8.1577	-7.8903	0.0000	0.0000	0.0000	0.0000;
	504	501	0.002636	0.008512	0.000891	120	120	120	0	0	1	-360	360	50.7752	20.0056	-50.7071	-19.8883	0.0000	0.0000	0.0000	0.0000;
	542	517	0.008512	0.022066	0.00241	120	120	120	0	0	1	-360	360	-14.5293	-16.8009	14.5659	16.6207	0.0000	0.0000	0.0000	0.0000;
	549	516	0.004628	0.012314	0.001261	120	120	120	0	0	1	-360	360	13.2091	6.3051	-13.2004	-6.4259	0.0000	0.0000	0.0000	0.0000;
	546	401	0.018934	0.063554	0.00649	133	133	133	0	0	1	-360	360	-16.2020	-4.8000	16.2468	4.1732	0.0000	0.0000	0.0000	0.0000;
	524	402	0.016198	0.040174	0.004361	120	120	120	0	0	1	-360	360	-21.3683	10.5792	21.4471	-10.8976	0.0000	0.0000	0.0000	0.0000;
	516	496	0.008678	0.027851	0.002931	133	133	133	0	0	1	-360	360	-4.0178	2.9878	4.0198	-3.3155	0.0000	0.0000	0.0000	0.0000;
	517	399	0.020661	0.066446	0.006979	133	133	133	0	0	1	-360	360	34.0347	-4.0310	-33.8235	3.9133	0.0000	0.0000	0.0000	0.0000;
	543	540	0.000826	0.003719	0.019491	109	109	109	0	0	1	-360	360	27.7710	7.6819	-27.7650	-9.9456	0.0000	0.0000	0.0000	0.0000;
	339	563	0.004132	0.013314	0.001401	120	120	120	0	0	1	-360	360	87.8333	29.1541	-87.5431	-28.3891	0.0000	0.0000	0.0000	0.0000;
	528	523	0.00057	0.002314	0.0121	98	98	98	0	0	1	-360	360	-3.0380	-0.7500	3.0380	-0.6714	0.0000	0.0000	0.0000	0.0000;
	419	529	0.00057	0.002314	0.0121	98	98	98	0	0	1	-360	360	3.0380	-0.6260	-3.0380	-0.7500	0.0000	0.0000	0.0000	0.0000;
	549	526	0.004132	0.010992	0.001169	120	120	120	0	0	1	-360	360	-59.4001	-19.7051	59.5416	19.9472	0.0000	0.0000	0.0000	0.0000;
	507	358	0.003967	0.012727	0.00137	133	133	133	0	0	1	-360	360	-109.2342	-21.5785	109.6582	22.7791	0.0000	0.0000	0.0000	0.0000;
	467	330	0.033223	0.107851	0.011139	133	133	133	0	0	1	-360	360	30.1831	0.5760	-29.9309	-1.0846	0.0000	0.0000	0.0000	0.0000;
	355	293	0.02124	0.069752	0.00704	133	133	133	0	0	1	-360	360	3.1314	-9.3462	-3.1151	8.5749	0.0000	0.0000	0.0000	0.0000;
	408	341	0.068603	0.12	0.01149	90	90	90	0	0	1	-360	360	39.7256	-16.3463	-38.6603	16.8681	0.0000	0.0000	0.0000	0.0000;
	580	463	0.041744	0.076281	0.00695	90	90	90	0	0	1	-360	360	-18.1631	6.6233	18.2988	-7.1882	0.0000	0.0000	0.0000	0.0000;
	521	424	0.013719	0.03719	0.00363	120	120	120	0	0	1	-360	360	-57.7850	-15.0240	58.2369	15.8520	0.0000	0.0000	0.0000	0.0000;
	408	252	0.017769	0.03124	0.002969	90	90	90	0	0	1	-360	360	-49.8516	14.3463	50.2595	-13.9792	0.0000	0.0000	0.0000	0.0000;
	463	447	0.032397	0.095868	0.00967	90	90	90	0	0	1	-360	360	-35.5118	5.0882	35.8693	-5.1697	0.0000	0.0000	0.0000	0.0000;
	378	239	0.015041	0.030752	0.002979	90	90	90	0	0	1	-360	360	-11.0271	-4.9360	11.0463	4.6372	0.0000	0.0000	0.0000	0.0000;
	413	378	0.011818	0.019669	0.002069	90	90	90	0	0	1	-360	360	-8.9914	-4.6521	9.0021	4.4360	0.0000	0.0000	0.0000	0.0000;
	253	231	0.009174	0.029826	0.003071	133	133	133	0	0	1	-360	360	-5.2608	6.6461	5.2666	-6.9826	0.0000	0.0000	0.0000	0.0000;
	420	231	0.007851	0.025446	0.002621	133	133	133	0	0	1	-360	360	21.4990	-1.1844	-21.4676	0.9826	0.0000	0.0000	0.0000	0.0000;
	448	447	0.006364	0.020909	0.00212	133	133	133	0	0	1	-360	360	63.0034	-16.2485	-62.7765	16.7427	0.0000	0.0000	0.0000	0.0000;
	521	433	0.022397	0.039256	0.00372	90	90	90	0	0	1	-360	360	5.5761	1.6114	-5.5690	-2.0000	0.0000	0.0000	0.0000	0.0000;
	555	434	0.078678	0.139339	0.01292	90	90	90	0	0	1	-360	360	8.1468	0.5792	-8.1010	-2.0000	0.0000	0.0000	0.0000	0.0000;
	527	521	0.00595	0.01157	0.001101	90	90	90	0	0	1	-360	360	-31.3912	-9.6153	31.4508	9.6126	0.0000	0.0000	0.0000	0.0000;
	481	212	0.04719	0.082727	0.00785	90	90	90	0	0	1	-360	360	8.9680	6.4122	-8.9110	-7.1301	0.0000	0.0000	0.0000	0.0000;
	425	421	0.004959	0.014207	0.00145	120	120	120	0	0	1	-360	360	47.0163	1.6463	-46.9225	-1.5468	0.0000	0.0000	0.0000	0.0000;
	422	383	0.059256	0.191983	0.01974	133	133	133	0	0	1	-360	360	-25.9712	-6.2901	26.3199	5.0171	0.0000	0.0000	0.0000	0.0000;
	512	239	0.002893	0.009256	0.000961	133	133	133	0	0	1	-360	360	2.2762	-12.0788	-2.2724	11.9818	0.0000	0.0000	0.0000	0.0000;
	382	379	0.003967	0.012984	0.001319	133	133	133	0	0	1	-360	360	56.1266	12.1414	-56.0216	-11.9613	0.0000	0.0000	0.0000	0.0000;
	566	380	0.017017	0.055124	0.005421	133	133	133	0	0	1	-360	360	-28.9856	-3.7449	29.1039	3.4602	0.0000	0.0000	0.0000	0.0000;
	554	551	0.011066	0.019339	0.001839	90	90	90	0	0	1	-360	360	-5.0630	-1.0000	5.0655	0.7853	0.0000	0.0000	0.0000	0.0000;
	473	290	0.009421	0.030413	0.003151	133	133	133	0	0	1	-360	360	31.4834	8.2880	-31.3975	-8.3761	0.0000	0.0000	0.0000	0.0000;
	417	345	0.060909	0.10124	0.01098	90	90	90	0	0	1	-360	360	31.5291	6.2554	-31.0135	-6.7217	0.0000	0.0000	0.0000	0.0000;
	380	382	0.006777	0.014463	0.001319	133	133	133	0	0	1	-360	360	-38.2169	-5.3602	38.2983	5.3701	0.0000	0.0000	0.0000	0.0000;
	417	379	0.006529	0.012066	0.00129	90	90	90	0	0	1	-360	360	-40.2371	-8.2554	40.3266	8.2613	0.0000	0.0000	0.0000	0.0000;
	383	381	0.039669	0.128603	0.01323	133	133	133	0	0	1	-360	360	28.2365	10.6194	-27.9404	-11.2713	0.0000	0.0000	0.0000	0.0000;
	381	335	0.023141	0.055868	0.00629	120	120	120	0	0	1	-360	360	8.7014	6.5713	-8.6773	-7.2600	0.0000	0.0000	0.0000	0.0000;
	555	335	0.053223	0.135124	0.013741	120	120	120	0	0	1	-360	360	-9.1598	-1.0792	9.1980	-0.4398	0.0000	0.0000	0.0000	0.0000;
	499	335	0.039421	0.127686	0.01323	133	133	133	0	0	1	-360	360	6.3011	-7.9623	-6.2703	6.5083	0.0000	0.0000	0.0000	0.0000;
	315	371	0.020174	0.06405	0.006749	133	133	133	0	0	1	-360	360	9.5779	-0.1068	-9.5615	-0.6032	0.0000	0.0000	0.0000	0.0000;
	387	223	0.035289	0.108182	0.010999	90	90	90	0	0	1	-360	360	15.2531	-4.4200	-15.1795	3.3450	0.0000	0.0000	0.0000	0.0000;
	266	421	0.003314	0.010909	0.001101	133	133	133	0	0	1	-360	360	-34.6867	-3.8606	34.7215	3.8468	0.0000	0.0000	0.0000	0.0000;
	266	420	0.003471	0.011322	0.001169	133	133	133	0	0	1	-360	360	28.6117	2.8606	-28.5870	-2.9156	0.0000	0.0000	0.0000	0.0000;
	556	212	0.039091	0.06843	0.00649	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.6699	0.0000	0.0000	0.0000	0.0000;
	557	496	0.006529	0.017364	0.001989	120	120	120	0	0	1	-360	360	38.5340	5.1864	-38.4478	-5.1845	0.0000	0.0000	0.0000	0.0000;
	527	481	0.032893	0.057438	0.00521	90	90	90	0	0	1	-360	360	20.2532	8.1153	-20.1060	-8.4122	0.0000	0.0000	0.0000	0.0000;
	451	239	0.011653	0.042984	0.003901	90	90	90	0	0	1	-360	360	1.0426	4.5687	-1.0401	-5.0044	0.0000	0.0000	0.0000	0.0000;
	290	281	0.009008	0.029174	0.00302	133	133	133	0	0	1	-360	360	9.6275	1.6761	-9.6200	-2.0000	0.0000	0.0000	0.0000	0.0000;
	355	342	0.023141	0.075207	0.007739	133	133	133	0	0	1	-360	360	-13.5604	7.3462	13.6090	-8.0888	0.0000	0.0000	0.0000	0.0000;
	447	293	0.011744	0.037934	0.00392	133	133	133	0	0	1	-360	360	2.2601	9.1415	-2.2509	-9.5749	0.0000	0.0000	0.0000	0.0000;
	512	315	0.006942	0.022562	0.00234	90	90	90	0	0	1	-360	360	-4.3012	11.5788	4.3107	-11.8131	0.0000	0.0000	0.0000	0.0000;
	497	239	0.003554	0.011397	0.001181	133	133	133	0	0	1	-360	360	20.5474	-8.4815	-20.5320	8.3965	0.0000	0.0000	0.0000	0.0000;
	449	448	0.006364	0.020744	0.002139	133	133	133	0	0	1	-360	360	71.5927	-15.0692	-71.3064	15.7485	0.0000	0.0000	0.0000	0.0000;
	316	314	0.006942	0.02281	0.002299	133	133	133	0	0	1	-360	360	-34.1390	7.2156	34.2139	-7.2298	0.0000	0.0000	0.0000	0.0000;
	566	393	0.019752	0.064793	0.006551	133	133	133	0	0	1	-360	360	24.5306	3.2449	-24.4314	-3.7177	0.0000	0.0000	0.0000	0.0000;
	551	393	0.031157	0.084628	0.008429	90	90	90	0	0	1	-360	360	-21.7735	-3.8853	21.9004	3.2177	0.0000	0.0000	0.0000	0.0000;
	580	499	0.005372	0.017521	0.001769	133	133	133	0	0	1	-360	360	15.9351	-7.1233	-15.9211	6.9623	0.0000	0.0000	0.0000	0.0000;
	244	382	0.016777	0.056612	0.00575	133	133	133	0	0	1	-360	360	-11.3561	-1.5477	11.3737	0.8924	0.0000	0.0000	0.0000	0.0000;
	361	244	0.02686	0.088099	0.008901	133	133	133	0	0	1	-360	360	-8.3030	-1.2000	8.3181	0.1477	0.0000	0.0000	0.0000	0.0000;
	341	472	0.027273	0.07157	0.007432	133	133	133	0	0	1	-360	360	1.0132	-0.3616	-1.0130	-0.5000	0.0000	0.0000	0.0000	0.0000;
	497	288	0.013719	0.044711	0.0046	133	133	133	0	0	1	-360	360	-22.5724	7.9815	22.6421	-8.2776	0.0000	0.0000	0.0000	0.0000;
	413	371	0.005446	0.017521	0.00183	133	133	133	0	0	1	-360	360	-0.1216	2.1521	0.1218	-2.3575	0.0000	0.0000	0.0000	0.0000;
	291	401	0.006198	0.017769	0.001909	120	120	120	0	0	1	-360	360	-12.7204	2.8310	12.7292	-3.0356	0.0000	0.0000	0.0000	0.0000;
	452	402	0.010744	0.034207	0.003521	137	137	137	0	0	1	-360	360	-29.6431	4.7993	29.7258	-4.9503	0.0000	0.0000	0.0000	0.0000;
	280	385	0.005702	0.018512	0.001931	133	133	133	0	0	1	-360	360	-15.1880	-2.0000	15.1991	1.8030	0.0000	0.0000	0.0000	0.0000;
	321	311	0.002231	0.007273	0.000731	120	120	120	0	0	1	-360	360	-14.7632	-12.0570	14.7699	11.9894	0.0000	0.0000	0.0000	0.0000;
	310	275	0.003058	0.009587	0.000999	120	120	120	0	0	1	-360	360	23.1847	10.8375	-23.1683	-10.9077	0.0000	0.0000	0.0000	0.0000;
	318	304	0.005793	0.016612	0.001791	120	120	120	0	0	1	-360	360	12.6983	-3.1917	-12.6901	2.9972	0.0000	0.0000	0.0000	0.0000;
	432	275	0.018017	0.046364	0.0047	120	120	120	0	0	1	-360	360	-45.1084	7.2563	45.4205	-7.0229	0.0000	0.0000	0.0000	0.0000;
	510	276	0.004628	0.014876	0.00145	120	120	120	0	0	1	-360	360	-24.9622	-0.7344	24.9858	0.6335	0.0000	0.0000	0.0000	0.0000;
	329	275	0.007107	0.022727	0.00242	133	133	133	0	0	1	-360	360	-34.1344	-8.4844	34.2070	8.4231	0.0000	0.0000	0.0000	0.0000;
	303	241	0.001066	0.00281	0.000329	120	120	120	0	0	1	-360	360	8.0976	-6.7130	-8.0967	6.6757	0.0000	0.0000	0.0000	0.0000;
	308	241	0.009917	0.026364	0.002991	120	120	120	0	0	1	-360	360	-0.4965	8.5188	0.5027	-8.8657	0.0000	0.0000	0.0000	0.0000;
	478	308	0.004628	0.013876	0.00167	120	120	120	0	0	1	-360	360	-36.5230	-10.9136	36.5785	10.8772	0.0000	0.0000	0.0000	0.0000;
	305	309	0.003719	0.011901	0.001251	120	120	120	0	0	1	-360	360	-3.7263	3.7450	3.7272	-3.8921	0.0000	0.0000	0.0000	0.0000;
	579	307	0.000579	0.001983	0.00021	120	120	120	0	0	1	-360	360	-27.7811	-12.7502	27.7856	12.7403	0.0000	0.0000	0.0000	0.0000;
	305	579	0.003058	0.009917	0.001041	120	120	120	0	0	1	-360	360	-21.9937	-11.1650	22.0091	11.0902	0.0000	0.0000	0.0000	0.0000;
	570	307	0.005289	0.016446	0.00189	123	123	123	0	0	1	-360	360	17.0195	5.0957	-17.0056	-5.2803	0.0000	0.0000	0.0000	0.0000;
	562	326	0.007364	0.023876	0.002481	120	120	120	0	0	1	-360	360	7.4116	17.1394	-7.3899	-17.3651	0.0000	0.0000	0.0000	0.0000;
	297	562	0.002149	0.006446	0.000779	120	120	120	0	0	1	-360	360	-14.0558	0.6288	14.0593	-0.7115	0.0000	0.0000	0.0000	0.0000;
	570	562	0.00562	0.018182	0.0019	120	120	120	0	0	1	-360	360	21.5051	16.3097	-21.4710	-16.4279	0.0000	0.0000	0.0000	0.0000;
	442	306	0.004876	0.012397	0.00121	120	120	120	0	0	1	-360	360	80.3439	15.1512	-80.0722	-14.6049	0.0000	0.0000	0.0000	0.0000;
	442	389	0.00595	0.017934	0.002161	120	120	120	0	0	1	-360	360	-88.4449	-17.7812	88.8482	18.7356	0.0000	0.0000	0.0000	0.0000;
	571	478	0.00405	0.012984	0.001341	120	120	120	0	0	1	-360	360	-19.2953	-6.0717	19.3090	5.9536	0.0000	0.0000	0.0000	0.0000;
	570	443	0.007521	0.022636	0.002701	120	120	120	0	0	1	-360	360	39.0491	9.3684	-38.9484	-9.3900	0.0000	0.0000	0.0000	0.0000;
	389	236	0.013876	0.036281	0.003959	120	120	120	0	0	1	-360	360	12.8477	-2.4025	-12.8284	1.9717	0.0000	0.0000	0.0000	0.0000;
	311	236	0.016612	0.047017	0.005051	120	120	120	0	0	1	-360	360	0.7447	5.7809	-0.7396	-6.3817	0.0000	0.0000	0.0000	0.0000;
	322	306	0.005041	0.016124	0.001699	120	120	120	0	0	1	-360	360	-19.1380	-6.2200	19.1552	6.0734	0.0000	0.0000	0.0000	0.0000;
	334	276	0.010578	0.028017	0.003161	120	120	120	0	0	1	-360	360	-37.9814	-1.8147	38.1074	1.7637	0.0000	0.0000	0.0000	0.0000;
	323	306	0.002636	0.008603	0.0009	120	120	120	0	0	1	-360	360	-18.6333	9.5692	18.6430	-9.6445	0.0000	0.0000	0.0000	0.0000;
	326	323	8.3e-05	0.000331	4.1e-05	120	120	120	0	0	1	-360	360	-10.4311	12.2251	10.4313	-12.2292	0.0000	0.0000	0.0000	0.0000;
	334	303	0.003388	0.01124	0.001111	120	120	120	0	0	1	-360	360	21.1724	-3.0353	-21.1596	2.9430	0.0000	0.0000	0.0000	0.0000;
	309	297	0.002231	0.006777	0.00082	120	120	120	0	0	1	-360	360	-3.7272	3.8921	3.7278	-3.9888	0.0000	0.0000	0.0000	0.0000;
	468	259	0.010661	0.032314	0.003831	120	120	120	0	0	1	-360	360	11.2519	1.9346	-11.2401	-2.3527	0.0000	0.0000	0.0000	0.0000;
	443	468	0.015793	0.047851	0.00568	120	120	120	0	0	1	-360	360	19.7094	3.8400	-19.6559	-4.3546	0.0000	0.0000	0.0000	0.0000;
	310	304	0.005702	0.013719	0.001549	120	120	120	0	0	1	-360	360	13.0418	10.2596	-13.0289	-10.4172	0.0000	0.0000	0.0000	0.0000;
	229	570	0.001322	0.004298	0.00045	11	11	11	0	0	1	-360	360	3.8670	3.9700	-3.8667	-4.0232	0.0000	0.0000	0.0000	0.0000;
	284	275	0.01876	0.051984	0.005711	120	120	120	0	0	1	-360	360	6.7838	-3.6324	-6.7751	2.9618	0.0000	0.0000	0.0000	0.0000;
	388	284	0.017107	0.046686	0.005089	120	120	120	0	0	1	-360	360	20.6143	0.3789	-20.5548	-0.8376	0.0000	0.0000	0.0000	0.0000;
	388	347	0.003388	0.010174	0.001229	120	120	120	0	0	1	-360	360	32.5796	5.8597	-32.5492	-5.9188	0.0000	0.0000	0.0000	0.0000;
	230	571	0.001322	0.004298	0.00045	11	11	11	0	0	1	-360	360	3.8670	3.9700	-3.8667	-4.0233	0.0000	0.0000	0.0000	0.0000;
	511	310	0.002562	0.008256	0.00084	120	120	120	0	0	1	-360	360	-34.2952	-8.6975	34.3215	8.6799	0.0000	0.0000	0.0000	0.0000;
	329	319	0.007686	0.024711	0.002611	120	120	120	0	0	1	-360	360	-17.6086	-6.4356	17.6308	6.1907	0.0000	0.0000	0.0000	0.0000;
	511	319	0.002562	0.008182	0.000801	120	120	120	0	0	1	-360	360	34.2952	8.6975	-34.2688	-8.7107	0.0000	0.0000	0.0000	0.0000;
	426	347	0.004793	0.014463	0.00175	120	120	120	0	0	1	-360	360	-13.4041	-0.5909	13.4112	0.3988	0.0000	0.0000	0.0000	0.0000;
	466	389	0.007851	0.025372	0.002669	120	120	120	0	0	1	-360	360	-17.5408	2.4270	17.5611	-2.6861	0.0000	0.0000	0.0000	0.0000;
	466	321	0.009091	0.030579	0.003151	120	120	120	0	0	1	-360	360	3.9728	-6.3370	-3.9688	5.9670	0.0000	0.0000	0.0000	0.0000;
	388	318	0.01281	0.041157	0.004339	120	120	120	0	0	1	-360	360	26.1358	0.3586	-26.0643	-0.6583	0.0000	0.0000	0.0000	0.0000;
	302	388	0.006124	0.019752	0.002081	120	120	120	0	0	1	-360	360	-12.1773	-3.5717	12.1853	3.3432	0.0000	0.0000	0.0000	0.0000;
	292	388	0.011983	0.038603	0.004061	120	120	120	0	0	1	-360	360	-6.8598	-2.0855	6.8647	1.6050	0.0000	0.0000	0.0000	0.0000;
	292	302	0.00562	0.018099	0.001909	120	120	120	0	0	1	-360	360	-1.3422	-0.2845	1.3423	0.0517	0.0000	0.0000	0.0000	0.0000;
	571	386	0.023802	0.072149	0.00855	120	120	120	0	0	1	-360	360	24.8741	-1.0184	-24.7521	0.3606	0.0000	0.0000	0.0000	0.0000;
	510	311	0.003876	0.012562	0.001319	120	120	120	0	0	1	-360	360	1.3692	-6.9356	-1.3676	6.7796	0.0000	0.0000	0.0000	0.0000;
	570	432	0.004959	0.014959	0.001769	120	120	120	0	0	1	-360	360	-35.6351	9.9326	35.6914	-9.9763	0.0000	0.0000	0.0000	0.0000;
	298	571	0.005041	0.015207	0.00181	120	120	120	0	0	1	-360	360	-14.8850	-4.7000	14.8952	4.5123	0.0000	0.0000	0.0000	0.0000;
	483	403	0.03	0.088678	0.00884	120	120	120	0	0	1	-360	360	-90.7075	8.8019	92.8546	-3.5018	0.0000	0.0000	0.0000	0.0000;
	428	258	0.025207	0.082231	0.00841	120	120	120	0	0	1	-360	360	-36.5725	-4.4758	36.8754	4.5060	0.0000	0.0000	0.0000	0.0000;
	440	428	0.001488	0.004711	0.000489	120	120	120	0	0	1	-360	360	-25.4259	-2.5035	25.4345	2.4758	0.0000	0.0000	0.0000	0.0000;
	412	404	0.00843	0.021397	0.00218	120	120	120	0	0	1	-360	360	15.2017	-2.6641	-15.1840	2.4629	0.0000	0.0000	0.0000	0.0000;
	479	462	0.019504	0.035446	0.003531	90	90	90	0	0	1	-360	360	-31.0493	-2.9480	31.2104	2.8229	0.0000	0.0000	0.0000	0.0000;
	582	219	0.014876	0.026124	0.002461	90	90	90	0	0	1	-360	360	-10.3163	-5.1393	10.3333	4.8843	0.0000	0.0000	0.0000	0.0000;
	582	356	0.022636	0.037686	0.003969	90	90	90	0	0	1	-360	360	-7.4037	3.6393	7.4174	-4.0748	0.0000	0.0000	0.0000	0.0000;
	569	328	0.014132	0.046529	0.0047	120	120	120	0	0	1	-360	360	2.1597	-6.5171	-2.1545	5.9727	0.0000	0.0000	0.0000	0.0000;
	283	234	0.004405	0.030388	0.003417	183	183	183	0	0	1	-360	360	-54.7782	18.7491	54.9054	-18.2684	0.0000	0.0000	0.0000	0.0000;
	572	464	0.016529	0.053876	0.005501	91	91	91	0	0	1	-360	360	10.0156	7.5182	-9.9929	-8.0910	0.0000	0.0000	0.0000	0.0000;
	569	446	0.017851	0.032727	0.003461	90	90	90	0	0	1	-360	360	4.4123	-8.3379	-4.3995	7.9483	0.0000	0.0000	0.0000	0.0000;
	446	416	0.030331	0.073314	0.00825	120	120	120	0	0	1	-360	360	-4.7135	-9.9483	4.7418	9.0234	0.0000	0.0000	0.0000	0.0000;
	394	416	0.00719	0.012562	0.0012	90	90	90	0	0	1	-360	360	-7.0880	-1.4000	7.0911	1.2599	0.0000	0.0000	0.0000	0.0000;
	569	296	0.017107	0.043636	0.004441	120	120	120	0	0	1	-360	360	-36.4089	5.5936	36.6041	-5.6267	0.0000	0.0000	0.0000	0.0000;
	444	296	0.03124	0.079422	0.00808	120	120	120	0	0	1	-360	360	43.6773	-3.8553	-43.1861	4.1267	0.0000	0.0000	0.0000	0.0000;
	486	453	0.01	0.026281	0.002669	120	120	120	0	0	1	-360	360	52.7735	-2.0660	-52.5512	2.3167	0.0000	0.0000	0.0000	0.0000;
	453	444	0.028017	0.061818	0.00747	120	120	120	0	0	1	-360	360	50.3232	-2.5167	-49.7523	2.8553	0.0000	0.0000	0.0000	0.0000;
	372	285	0.004132	0.013471	0.001389	133	133	133	0	0	1	-360	360	-20.3585	-0.2614	20.3728	0.1418	0.0000	0.0000	0.0000	0.0000;
	376	483	0.02595	0.085124	0.008601	133	133	133	0	0	1	-360	360	-72.4980	14.1458	73.7375	-11.0720	0.0000	0.0000	0.0000	0.0000;
	454	372	0.040413	0.132636	0.01339	133	133	133	0	0	1	-360	360	-17.7200	-1.0000	17.8275	-0.2386	0.0000	0.0000	0.0000	0.0000;
	498	455	0.002562	0.00843	0.000871	133	133	133	0	0	1	-360	360	10.6345	1.4072	-10.6320	-1.5000	0.0000	0.0000	0.0000	0.0000;
	277	464	0.014132	0.037273	0.004	90	90	90	0	0	1	-360	360	8.7527	-5.5252	-8.7401	5.0910	0.0000	0.0000	0.0000	0.0000;
	441	482	0.007107	0.012479	0.001191	90	90	90	0	0	1	-360	360	-20.0188	-2.5302	20.0451	2.4451	0.0000	0.0000	0.0000	0.0000;
	484	441	0.005793	0.011744	0.00114	90	90	90	0	0	1	-360	360	-15.4490	-1.8296	15.4618	1.7302	0.0000	0.0000	0.0000	0.0000;
	488	483	0.006446	0.016124	0.001389	90	90	90	0	0	1	-360	360	-9.8766	-1.4175	9.8821	1.2701	0.0000	0.0000	0.0000	0.0000;
	489	485	0.00405	0.008347	0.000779	69	69	69	0	0	1	-360	360	9.8765	1.4168	-9.8730	-1.5000	0.0000	0.0000	0.0000	0.0000;
	461	325	0.054554	0.094711	0.00914	90	90	90	0	0	1	-360	360	33.4117	0.5464	-32.8995	-0.7280	0.0000	0.0000	0.0000	0.0000;
	430	373	0.060579	0.106033	0.01006	90	90	90	0	0	1	-360	360	-29.0507	3.9603	29.4938	-4.3875	0.0000	0.0000	0.0000	0.0000;
	440	436	0.002727	0.007851	0.000789	120	120	120	0	0	1	-360	360	21.8509	3.5045	-21.8390	-3.5590	0.0000	0.0000	0.0000	0.0000;
	482	224	0.011983	0.038934	0.00402	120	120	120	0	0	1	-360	360	-26.2391	-2.7451	26.3145	2.5450	0.0000	0.0000	0.0000	0.0000;
	470	404	0.010744	0.034793	0.003589	114	114	114	0	0	1	-360	360	-31.9527	-3.2018	32.0515	3.1187	0.0000	0.0000	0.0000	0.0000;
	470	224	0.009826	0.031983	0.003301	114	114	114	0	0	1	-360	360	27.9027	2.8018	-27.8335	-2.9450	0.0000	0.0000	0.0000	0.0000;
	508	487	0.012984	0.042149	0.004361	133	133	133	0	0	1	-360	360	-35.9522	-2.3910	36.0901	2.3036	0.0000	0.0000	0.0000	0.0000;
	486	243	0.003141	0.009421	0.000961	120	120	120	0	0	1	-360	360	62.8267	9.4572	-62.7257	-9.2742	0.0000	0.0000	0.0000	0.0000;
	438	391	0.003554	0.024207	0.00271	183	183	183	0	0	1	-360	360	27.8432	-19.2819	-27.8085	19.1997	0.0000	0.0000	0.0000	0.0000;
	390	232	0.013719	0.044463	0.00461	120	120	120	0	0	1	-360	360	26.9431	3.8102	-26.8586	-4.0891	0.0000	0.0000	0.0000	0.0000;
	439	264	0.001636	0.011116	0.001341	183	183	183	0	0	1	-360	360	48.2317	-2.2198	-48.1991	2.2844	0.0000	0.0000	0.0000	0.0000;
	391	213	0.019669	0.063802	0.006599	120	120	120	0	0	1	-360	360	46.2836	4.9978	-45.9210	-4.5907	0.0000	0.0000	0.0000	0.0000;
	233	376	0.003554	0.01157	0.00121	133	133	133	0	0	1	-360	360	-17.0968	1.2774	17.1059	-1.3862	0.0000	0.0000	0.0000	0.0000;
	400	360	0.028678	0.093141	0.009619	120	120	120	0	0	1	-360	360	-1.3841	2.1154	1.3863	-3.2108	0.0000	0.0000	0.0000	0.0000;
	232	214	0.00686	0.022149	0.002289	120	120	120	0	0	1	-360	360	16.7326	2.9891	-16.7159	-3.2082	0.0000	0.0000	0.0000	0.0000;
	412	213	0.022314	0.072479	0.0075	120	120	120	0	0	1	-360	360	-41.5287	-3.3349	41.8710	3.5907	0.0000	0.0000	0.0000	0.0000;
	577	430	0.014711	0.047686	0.004929	120	120	120	0	0	1	-360	360	-18.3740	4.3227	18.4187	-4.7603	0.0000	0.0000	0.0000	0.0000;
	577	445	0.019504	0.063314	0.006539	120	120	120	0	0	1	-360	360	10.7590	-6.3227	-10.7341	5.6302	0.0000	0.0000	0.0000	0.0000;
	574	214	0.020579	0.066942	0.006909	120	120	120	0	0	1	-360	360	-7.0880	-1.5000	7.0969	0.7082	0.0000	0.0000	0.0000	0.0000;
	356	272	0.008512	0.027934	0.002851	120	120	120	0	0	1	-360	360	-18.5554	2.5748	18.5813	-2.8191	0.0000	0.0000	0.0000	0.0000;
	406	403	0.004876	0.015868	0.001641	120	120	120	0	0	1	-360	360	22.1868	-9.7580	-22.1631	9.6373	0.0000	0.0000	0.0000	0.0000;
	461	228	0.00843	0.027686	0.00279	120	120	120	0	0	1	-360	360	31.0775	4.3184	-31.0077	-4.4202	0.0000	0.0000	0.0000	0.0000;
	406	390	0.035289	0.137017	0.013741	120	120	120	0	0	1	-360	360	-32.3118	8.2580	32.6417	-8.6326	0.0000	0.0000	0.0000	0.0000;
	301	484	0.024298	0.078934	0.008151	120	120	120	0	0	1	-360	360	-5.5690	-1.2000	5.5760	0.3296	0.0000	0.0000	0.0000	0.0000;
	390	265	0.001818	0.012727	0.001421	183	183	183	0	0	1	-360	360	17.2737	79.5602	-17.1735	-79.0282	0.0000	0.0000	0.0000	0.0000;
	391	264	0.001744	0.012066	0.001341	183	183	183	0	0	1	-360	360	-7.6757	36.2684	7.6961	-36.2844	0.0000	0.0000	0.0000	0.0000;
	234	245	0.007884	0.053149	0.005885	183	183	183	0	0	1	-360	360	-77.1824	1.2684	77.5884	0.7839	0.0000	0.0000	0.0000	0.0000;
	438	245	0.001074	0.00719	0.000944	229	229	229	0	0	1	-360	360	-83.1659	19.7816	83.2330	-19.4429	0.0000	0.0000	0.0000	0.0000;
	282	265	0.002562	0.022727	0.001989	183	183	183	0	0	1	-360	360	21.3615	-45.7658	-21.3055	46.0282	0.0000	0.0000	0.0000	0.0000;
	391	257	0.019504	0.063141	0.006539	133	133	133	0	0	1	-360	360	45.8376	6.1056	-45.4827	-5.7183	0.0000	0.0000	0.0000	0.0000;
	228	498	0.035702	0.11719	0.011841	120	120	120	0	0	1	-360	360	19.8697	2.4202	-19.7475	-3.4072	0.0000	0.0000	0.0000	0.0000;
	222	277	0.044297	0.093471	0.00876	90	90	90	0	0	1	-360	360	-10.6380	-2.2000	10.6825	1.2761	0.0000	0.0000	0.0000	0.0000;
	522	487	0.018934	0.062479	0.019319	133	133	133	0	0	1	-360	360	-82.5168	-7.6437	83.6061	8.8975	0.0000	0.0000	0.0000	0.0000;
	332	325	0.010992	0.023223	0.00218	90	90	90	0	0	1	-360	360	-13.1630	-3.0000	13.1804	2.7858	0.0000	0.0000	0.0000	0.0000;
	569	572	0.012149	0.039339	0.004051	120	120	120	0	0	1	-360	360	17.6479	7.7614	-17.6096	-8.1182	0.0000	0.0000	0.0000	0.0000;
	233	360	0.029091	0.09438	0.00976	120	120	120	0	0	1	-360	360	7.4778	-2.7774	-7.4623	1.7108	0.0000	0.0000	0.0000	0.0000;
	219	479	0.033876	0.059339	0.00582	90	90	90	0	0	1	-360	360	-21.7963	-1.3843	21.9353	0.9480	0.0000	0.0000	0.0000	0.0000;
	476	400	0.019826	0.06438	0.00665	120	120	120	0	0	1	-360	360	4.1892	2.3640	-4.1849	-3.1154	0.0000	0.0000	0.0000	0.0000;
	568	522	0.024215	0.079339	0.008027	133	133	133	0	0	1	-360	360	-35.7991	1.8770	36.0641	-1.9591	0.0000	0.0000	0.0000	0.0000;
	568	277	0.022231	0.07281	0.00735	133	133	133	0	0	1	-360	360	29.2171	-3.3770	-29.0542	3.0491	0.0000	0.0000	0.0000	0.0000;
	398	409	0.008347	0.026198	0.002921	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.3464	0.0000	0.0000	0.0000	0.0000;
	396	392	0.007603	0.025446	0.00249	133	133	133	0	0	1	-360	360	41.4489	5.3920	-41.3390	-5.3241	0.0000	0.0000	0.0000	0.0000;
	397	362	0.011818	0.03	0.003049	120	120	120	0	0	1	-360	360	7.7763	6.6526	-7.7660	-7.0000	0.0000	0.0000	0.0000	0.0000;
	411	363	0.016198	0.05405	0.005271	133	133	133	0	0	1	-360	360	7.7753	2.4063	-7.7660	-3.0000	0.0000	0.0000	0.0000	0.0000;
	409	267	0.019917	0.06438	0.00667	133	133	133	0	0	1	-360	360	29.6990	-1.0799	-29.5508	0.7714	0.0000	0.0000	0.0000	0.0000;
	559	294	0.010661	0.018678	0.001861	133	133	133	0	0	1	-360	360	10.9834	-0.7464	-10.9724	0.5479	0.0000	0.0000	0.0000	0.0000;
	559	267	0.015868	0.053876	0.005329	133	133	133	0	0	1	-360	360	-15.8466	0.9623	15.8808	-1.4714	0.0000	0.0000	0.0000	0.0000;
	559	457	0.010744	0.034959	0.003611	133	133	133	0	0	1	-360	360	4.8632	-0.2158	-4.8610	-0.2000	0.0000	0.0000	0.0000	0.0000;
	312	295	0.027016	0.087438	0.009051	133	133	133	0	0	1	-360	360	22.1057	-2.1550	-21.9948	1.4351	0.0000	0.0000	0.0000	0.0000;
	263	237	0.019091	0.062727	0.00634	133	133	133	0	0	1	-360	360	-22.0327	4.5525	22.1155	-5.0264	0.0000	0.0000	0.0000	0.0000;
	375	263	0.019752	0.064959	0.006561	133	133	133	0	0	1	-360	360	-19.6338	5.1118	19.7037	-5.6525	0.0000	0.0000	0.0000	0.0000;
	465	410	0.025041	0.082231	0.00831	133	133	133	0	0	1	-360	360	-62.3322	2.2908	63.1278	-0.7088	0.0000	0.0000	0.0000	0.0000;
	225	465	0.007603	0.022984	0.00272	133	133	133	0	0	1	-360	360	-53.3450	3.2973	53.5232	-3.0908	0.0000	0.0000	0.0000	0.0000;
	397	251	0.023141	0.074132	0.00785	133	133	133	0	0	1	-360	360	18.5911	1.4622	-18.5253	-2.2109	0.0000	0.0000	0.0000	0.0000;
	431	368	0.038843	0.127603	0.012879	133	133	133	0	0	1	-360	360	40.5667	2.1313	-40.0410	-1.9551	0.0000	0.0000	0.0000	0.0000;
	469	392	0.018347	0.060248	0.006079	133	133	133	0	0	1	-360	360	-39.0733	-4.9572	39.3140	5.0241	0.0000	0.0000	0.0000	0.0000;
	469	415	0.030331	0.099669	0.01006	133	133	133	0	0	1	-360	360	35.8333	4.6572	-35.4961	-4.7206	0.0000	0.0000	0.0000	0.0000;
	458	295	0.009752	0.029504	0.00355	133	133	133	0	0	1	-360	360	-6.3800	-0.8000	6.3834	0.3889	0.0000	0.0000	0.0000	0.0000;
	581	294	0.036777	0.063802	0.006229	90	90	90	0	0	1	-360	360	-6.4655	-1.8544	6.4794	1.1521	0.0000	0.0000	0.0000	0.0000;
	480	240	0.021397	0.07157	0.006989	133	133	133	0	0	1	-360	360	-10.3219	-1.9347	10.3417	1.1755	0.0000	0.0000	0.0000	0.0000;
	414	395	0.001983	0.006198	0.00069	133	133	133	0	0	1	-360	360	-34.0126	-2.1108	34.0319	2.0890	0.0000	0.0000	0.0000	0.0000;
	429	395	0.00562	0.017107	0.001801	90	90	90	0	0	1	-360	360	-41.1857	0.6611	41.2659	-0.6314	0.0000	0.0000	0.0000	0.0000;
	268	397	0.003058	0.01	0.001031	133	133	133	0	0	1	-360	360	-27.7236	-3.7808	27.7431	3.7182	0.0000	0.0000	0.0000	0.0000;
	396	365	0.009587	0.030992	0.003199	133	133	133	0	0	1	-360	360	8.4505	4.6381	-8.4430	-5.0000	0.0000	0.0000	0.0000	0.0000;
	410	364	0.010661	0.034628	0.003579	133	133	133	0	0	1	-360	360	8.3471	10.7351	-8.3310	-11.1300	0.0000	0.0000	0.0000	0.0000;
	407	357	0.004298	0.012984	0.001571	133	133	133	0	0	1	-360	360	14.1480	1.3739	-14.1407	-1.5386	0.0000	0.0000	0.0000	0.0000;
	367	237	0.091653	0.159008	0.01657	90	90	90	0	0	1	-360	360	4.1281	-12.8891	-4.0006	11.1847	0.0000	0.0000	0.0000	0.0000;
	578	240	0.03124	0.104207	0.010181	133	133	133	0	0	1	-360	360	36.2036	-5.3793	-35.8552	5.3300	0.0000	0.0000	0.0000	0.0000;
	429	409	0.004793	0.016033	0.001561	133	133	133	0	0	1	-360	360	33.2877	-1.1611	-33.2430	1.1253	0.0000	0.0000	0.0000	0.0000;
	368	235	0.009174	0.03	0.00303	133	133	133	0	0	1	-360	360	23.0110	1.9551	-22.9697	-2.1784	0.0000	0.0000	0.0000	0.0000;
	235	237	0.006777	0.022149	0.002241	133	133	133	0	0	1	-360	360	14.3627	1.5784	-14.3507	-1.8033	0.0000	0.0000	0.0000	0.0000;
	295	289	0.016612	0.042984	0.004291	120	120	120	0	0	1	-360	360	2.4484	-2.2239	-2.4470	1.7177	0.0000	0.0000	0.0000	0.0000;
	411	357	0.011322	0.037769	0.003691	133	133	133	0	0	1	-360	360	0.4404	-0.9768	-0.4403	0.5386	0.0000	0.0000	0.0000	0.0000;
	410	397	0.012893	0.041157	0.004431	133	133	133	0	0	1	-360	360	60.4798	13.4450	-60.0845	-12.7330	0.0000	0.0000	0.0000	0.0000;
	431	410	0.043967	0.145289	0.014469	133	133	133	0	0	1	-360	360	-44.9077	2.9764	45.6385	-2.3533	0.0000	0.0000	0.0000	0.0000;
	411	395	0.024554	0.074298	0.00772	120	120	120	0	0	1	-360	360	-8.2157	-1.4295	8.2298	0.5532	0.0000	0.0000	0.0000	0.0000;
	480	333	0.021653	0.072397	0.007059	133	133	133	0	0	1	-360	360	5.6639	1.5347	-5.6573	-2.3421	0.0000	0.0000	0.0000	0.0000;
	533	268	0.04405	0.133719	0.015851	133	133	133	0	0	1	-360	360	-17.6836	-3.5501	17.8006	1.9808	0.0000	0.0000	0.0000	0.0000;
	346	375	0.018256	0.03157	0.003071	90	90	90	0	0	1	-360	360	-9.2878	5.2823	9.3058	-5.6118	0.0000	0.0000	0.0000	0.0000;
	475	251	0.020496	0.066942	0.006839	133	133	133	0	0	1	-360	360	-13.6329	-2.6344	13.6653	1.9109	0.0000	0.0000	0.0000	0.0000;
	578	225	0.033388	0.10124	0.011991	133	133	133	0	0	1	-360	360	-47.4436	4.5793	48.0800	-4.0973	0.0000	0.0000	0.0000	0.0000;
	414	407	0.002727	0.008182	0.00099	133	133	133	0	0	1	-360	360	28.4436	1.7118	-28.4250	-1.7739	0.0000	0.0000	0.0000	0.0000;
	217	215	0.006942	0.022562	0.002311	133	133	133	0	0	1	-360	360	1.8516	3.6414	-1.8506	-3.9222	0.0000	0.0000	0.0000	0.0000;
	227	366	0.059917	0.116281	0.012981	90	90	90	0	0	1	-360	360	-35.8166	-2.9530	36.4570	2.5998	0.0000	0.0000	0.0000	0.0000;
	227	209	0.100413	0.177364	0.01665	90	90	90	0	0	1	-360	360	9.9376	3.1655	-9.8408	-4.9715	0.0000	0.0000	0.0000	0.0000;
	269	227	0.051984	0.09	0.008891	90	90	90	0	0	1	-360	360	-6.6197	1.1782	6.6400	-2.2125	0.0000	0.0000	0.0000	0.0000;
	278	218	0.028934	0.08719	0.0105	133	133	133	0	0	1	-360	360	-20.9145	2.1475	21.0200	-3.1150	0.0000	0.0000	0.0000	0.0000;
	513	278	0.030331	0.09124	0.010989	133	133	133	0	0	1	-360	360	-17.7961	1.5519	17.8765	-2.6475	0.0000	0.0000	0.0000	0.0000;
	256	255	0.006612	0.019917	0.002401	133	133	133	0	0	1	-360	360	-9.8333	10.7147	9.8451	-10.9669	0.0000	0.0000	0.0000	0.0000;
	567	324	0.026942	0.081901	0.009699	133	133	133	0	0	1	-360	360	-12.0917	-5.7107	12.1306	4.6635	0.0000	0.0000	0.0000	0.0000;
	370	320	0.02	0.033802	0.003681	90	90	90	0	0	1	-360	360	-12.0288	9.5920	12.0687	-9.9693	0.0000	0.0000	0.0000	0.0000;
	226	286	0.027016	0.082149	0.009731	133	133	133	0	0	1	-360	360	-15.3714	6.8725	15.4368	-7.8445	0.0000	0.0000	0.0000	0.0000;
	374	247	0.049917	0.089669	0.008981	90	90	90	0	0	1	-360	360	-47.4757	3.9818	48.4675	-3.2469	0.0000	0.0000	0.0000	0.0000;
	474	248	0.007851	0.023876	0.002841	133	133	133	0	0	1	-360	360	-51.5993	-8.7998	51.7766	8.9928	0.0000	0.0000	0.0000	0.0000;
	471	210	0.040174	0.117107	0.01446	133	133	133	0	0	1	-360	360	-30.4410	-7.5035	30.7900	6.8735	0.0000	0.0000	0.0000	0.0000;
	279	324	0.003967	0.012149	0.001379	133	133	133	0	0	1	-360	360	5.6078	-1.1335	-5.6067	0.9700	0.0000	0.0000	0.0000	0.0000;
	249	247	0.022066	0.042727	0.00416	90	90	90	0	0	1	-360	360	60.2672	-0.9642	-59.6055	1.7469	0.0000	0.0000	0.0000	0.0000;
	256	249	0.037364	0.063141	0.00687	90	90	90	0	0	1	-360	360	4.2643	-11.7147	-4.2188	10.9631	0.0000	0.0000	0.0000	0.0000;
	218	215	0.002636	0.008512	0.000881	133	133	133	0	0	1	-360	360	-47.4793	14.7676	47.5324	-14.7043	0.0000	0.0000	0.0000	0.0000;
	567	553	0.039504	0.069091	0.006561	90	90	90	0	0	1	-360	360	-6.1353	2.7107	6.1509	-3.4669	0.0000	0.0000	0.0000	0.0000;
	553	299	0.035372	0.103314	0.009169	120	120	120	0	0	1	-360	360	-35.8896	-0.1039	36.2711	0.1106	0.0000	0.0000	0.0000	0.0000;
	471	437	0.019752	0.037364	0.00401	90	90	90	0	0	1	-360	360	9.1770	5.5035	-9.1564	-5.9113	0.0000	0.0000	0.0000	0.0000;
	552	248	0.031653	0.095372	0.01148	133	133	133	0	0	1	-360	360	-31.5680	-5.3815	31.8379	4.8060	0.0000	0.0000	0.0000	0.0000;
	405	369	0.040661	0.070661	0.00682	90	90	90	0	0	1	-360	360	10.7727	-3.3209	-10.7302	2.5826	0.0000	0.0000	0.0000	0.0000;
	474	210	0.041397	0.125702	0.01489	133	133	133	0	0	1	-360	360	39.4483	7.7998	-38.8910	-7.8735	0.0000	0.0000	0.0000	0.0000;
	384	350	0.015703	0.047364	0.005699	133	133	133	0	0	1	-360	360	-36.4555	9.2767	36.6415	-9.4004	0.0000	0.0000	0.0000	0.0000;
	287	218	0.028017	0.084463	0.010159	133	133	133	0	0	1	-360	360	-49.1518	8.7018	49.7290	-8.2023	0.0000	0.0000	0.0000	0.0000;
	260	250	0.026777	0.080496	0.009699	133	133	133	0	0	1	-360	360	-14.1995	-0.0694	14.2488	-0.8488	0.0000	0.0000	0.0000	0.0000;
	459	209	0.038603	0.083636	0.00735	90	90	90	0	0	1	-360	360	-1.7338	-4.3156	1.7398	3.4715	0.0000	0.0000	0.0000	0.0000;
	270	250	0.019091	0.061983	0.00644	133	133	133	0	0	1	-360	360	18.3569	-0.8726	-18.2988	0.3488	0.0000	0.0000	0.0000	0.0000;
	374	270	0.067686	0.119008	0.01104	90	90	90	0	0	1	-360	360	36.3367	-5.4818	-35.5420	5.6349	0.0000	0.0000	0.0000	0.0000;
	450	270	0.061066	0.101653	0.011021	90	90	90	0	0	1	-360	360	-5.0630	-0.5000	5.0772	-0.6955	0.0000	0.0000	0.0000	0.0000;
	324	320	0.006124	0.012397	0.001169	90	90	90	0	0	1	-360	360	29.3287	-7.0174	-29.2827	6.9693	0.0000	0.0000	0.0000	0.0000;
	505	260	0.050992	0.154793	0.018329	133	133	133	0	0	1	-360	360	-7.0880	-1.0000	7.1115	-0.9306	0.0000	0.0000	0.0000	0.0000;
	405	286	0.03124	0.094959	0.011251	133	133	133	0	0	1	-360	360	-21.9107	2.3209	22.0387	-3.2787	0.0000	0.0000	0.0000	0.0000;
	553	238	0.029174	0.07438	0.007739	120	120	120	0	0	1	-360	360	13.5377	1.0708	-13.4924	-1.8759	0.0000	0.0000	0.0000	0.0000;
	350	287	0.021653	0.040083	0.00386	90	90	90	0	0	1	-360	360	-43.7295	8.9004	44.0888	-8.7018	0.0000	0.0000	0.0000	0.0000;
	254	552	0.018678	0.056777	0.00673	133	133	133	0	0	1	-360	360	-25.8904	-4.3507	25.9990	3.8815	0.0000	0.0000	0.0000	0.0000;
	255	384	0.026777	0.080578	0.009699	133	133	133	0	0	1	-360	360	-34.1471	9.4669	34.4305	-9.7767	0.0000	0.0000	0.0000	0.0000;
	270	437	0.004298	0.013876	0.00144	133	133	133	0	0	1	-360	360	1.9830	-5.5668	-1.9816	5.4113	0.0000	0.0000	0.0000	0.0000;
	338	215	0.039421	0.120331	0.01413	133	133	133	0	0	1	-360	360	-14.1675	-1.5180	14.2328	-0.0089	0.0000	0.0000	0.0000	0.0000;
	492	215	0.008182	0.025446	0.00289	133	133	133	0	0	1	-360	360	-8.1010	-0.5000	8.1054	0.1590	0.0000	0.0000	0.0000	0.0000;
	313	269	0.043388	0.07157	0.007739	90	90	90	0	0	1	-360	360	6.5605	1.7739	-6.5433	-2.6782	0.0000	0.0000	0.0000	0.0000;
	313	338	0.018256	0.055372	0.006561	133	133	133	0	0	1	-360	360	-9.0915	-2.2739	9.1045	1.5180	0.0000	0.0000	0.0000	0.0000;
	366	299	0.028678	0.088182	0.007831	120	120	120	0	0	1	-360	360	45.9477	4.6443	-45.4591	-4.1106	0.0000	0.0000	0.0000	0.0000;
	366	218	0.025446	0.080992	0.00735	120	120	120	0	0	1	-360	360	34.6582	5.3353	-34.4077	-5.4503	0.0000	0.0000	0.0000	0.0000;
	216	366	0.018182	0.06595	0.007066	133	133	133	0	0	1	-360	360	-34.2568	-8.0592	34.4386	7.8405	0.0000	0.0000	0.0000	0.0000;
	249	226	0.027934	0.084959	0.01006	133	133	133	0	0	1	-360	360	-9.7695	6.2569	9.8024	-7.3725	0.0000	0.0000	0.0000	0.0000;
	513	279	0.023636	0.071488	0.008511	133	133	133	0	0	1	-360	360	13.7461	-2.0519	-13.7088	1.1335	0.0000	0.0000	0.0000	0.0000;
	216	217	0.002231	0.007521	0.000755	133	133	133	0	0	1	-360	360	11.9808	5.5592	-11.9776	-5.6414	0.0000	0.0000	0.0000	0.0000;
	354	351	8e-06	8.3e-05	2.4e-05	137	137	137	0	0	1	-360	360	-111.5348	-18.0928	111.5356	18.0988	0.0000	0.0000	0.0000	0.0000;
	600	835	0.036281	0.094207	0.00974	137	137	137	0	0	1	-360	360	-20.6566	3.0311	20.7950	-3.7980	0.0000	0.0000	0.0000	0.0000;
	790	622	0.030413	0.098934	0.01014	137	137	137	0	0	1	-360	360	-52.2358	1.1600	52.9591	0.0125	0.0000	0.0000	0.0000	0.0000;
	760	586	0.026777	0.086529	0.00885	137	137	137	0	0	1	-360	360	-17.8189	2.8685	17.8945	-3.6575	0.0000	0.0000	0.0000	0.0000;
	831	601	0.022562	0.072893	0.007461	137	137	137	0	0	1	-360	360	5.6808	-3.1441	-5.6730	2.3157	0.0000	0.0000	0.0000	0.0000;
	719	594	0.086777	0.149752	0.01423	76	76	76	0	0	1	-360	360	20.3003	-3.5881	-19.9918	2.4599	0.0000	0.0000	0.0000	0.0000;
	779	726	0.072066	0.138099	0.013211	109	109	109	0	0	1	-360	360	-2.5333	-0.6340	2.5373	-0.8992	0.0000	0.0000	0.0000	0.0000;
	733	727	0.05	0.109091	0.010699	109	109	109	0	0	1	-360	360	-18.9488	-0.4371	19.1051	-0.4617	0.0000	0.0000	0.0000	0.0000;
	628	625	0.01124	0.027769	0.002759	109	109	109	0	0	1	-360	360	14.5704	3.6916	-14.5487	-3.9623	0.0000	0.0000	0.0000	0.0000;
	727	725	0.016364	0.053058	0.005421	137	137	137	0	0	1	-360	360	-10.0219	2.5883	10.0372	-3.1722	0.0000	0.0000	0.0000	0.0000;
	720	613	0.041157	0.132893	0.013591	137	137	137	0	0	1	-360	360	7.7819	-4.7118	-7.7550	3.2120	0.0000	0.0000	0.0000	0.0000;
	732	726	0.023058	0.07157	0.00818	168	168	168	0	0	1	-360	360	-12.7187	-1.0294	12.7509	0.1767	0.0000	0.0000	0.0000	0.0000;
	732	727	0.023058	0.07157	0.00818	168	168	168	0	0	1	-360	360	-13.4563	-0.9706	13.4923	0.1296	0.0000	0.0000	0.0000	0.0000;
	747	676	0.020174	0.065289	0.006701	137	137	137	0	0	1	-360	360	-39.0038	3.7795	39.2792	-3.6472	0.0000	0.0000	0.0000	0.0000;
	792	599	0.048934	0.127769	0.013211	137	137	137	0	0	1	-360	360	29.7671	-0.7890	-29.3913	0.2639	0.0000	0.0000	0.0000	0.0000;
	620	590	0.031983	0.103471	0.01058	137	137	137	0	0	1	-360	360	-17.8561	0.6598	17.9460	-1.5811	0.0000	0.0000	0.0000	0.0000;
	694	819	0.039174	0.126686	0.012959	137	137	137	0	0	1	-360	360	-15.4021	-1.7429	15.4808	0.4528	0.0000	0.0000	0.0000	0.0000;
	789	620	0.038512	0.124628	0.012751	137	137	137	0	0	1	-360	360	-8.9299	-0.0036	8.9571	-1.3598	0.0000	0.0000	0.0000	0.0000;
	830	637	0.061397	0.198603	0.020321	137	137	137	0	0	1	-360	360	1.7698	3.1496	-1.7582	-5.4486	0.0000	0.0000	0.0000	0.0000;
	742	741	0.003719	0.008843	0.00067	137	137	137	0	0	1	-360	360	-9.4399	2.9335	9.4431	-3.0032	0.0000	0.0000	0.0000	0.0000;
	742	617	0.04843	0.08438	0.00809	91	91	91	0	0	1	-360	360	-10.9630	-2.0312	11.0146	1.1844	0.0000	0.0000	0.0000	0.0000;
	785	583	0.012066	0.038934	0.00402	137	137	137	0	0	1	-360	360	-41.2044	-0.7927	41.3783	0.8782	0.0000	0.0000	0.0000	0.0000;
	770	617	0.037603	0.065537	0.006241	109	109	109	0	0	1	-360	360	23.7917	1.7669	-23.6106	-2.1844	0.0000	0.0000	0.0000	0.0000;
	742	658	0.010752	0.028198	0.002909	109	109	109	0	0	1	-360	360	5.2516	-1.5775	-5.2489	1.2499	0.0000	0.0000	0.0000	0.0000;
	716	658	0.012703	0.032967	0.00341	109	109	109	0	0	1	-360	360	-1.0604	1.5586	1.0609	-1.9499	0.0000	0.0000	0.0000	0.0000;
	744	716	0.034851	0.07019	0.006829	109	109	109	0	0	1	-360	360	3.4459	1.1792	-3.4416	-1.9586	0.0000	0.0000	0.0000	0.0000;
	588	744	0.014207	0.046033	0.004709	137	137	137	0	0	1	-360	360	23.1371	3.0047	-23.0705	-3.3358	0.0000	0.0000	0.0000	0.0000;
	700	584	0.00562	0.009917	0.00092	76	76	76	0	0	1	-360	360	-32.5586	-4.4601	32.6098	4.4413	0.0000	0.0000	0.0000	0.0000;
	700	696	0.004463	0.007934	0.00075	46	46	46	0	0	1	-360	360	23.5546	3.8601	-23.5331	-3.9107	0.0000	0.0000	0.0000	0.0000;
	699	696	0.002562	0.008256	0.000849	137	137	137	0	0	1	-360	360	-5.3044	-2.3887	5.3051	2.2907	0.0000	0.0000	0.0000	0.0000;
	825	699	0.013058	0.021653	0.002081	109	109	109	0	0	1	-360	360	6.9220	1.1144	-6.9166	-1.3513	0.0000	0.0000	0.0000	0.0000;
	825	583	0.011744	0.020248	0.001951	109	109	109	0	0	1	-360	360	-19.0670	-2.3744	19.1036	2.2061	0.0000	0.0000	0.0000	0.0000;
	604	583	0.02562	0.08281	0.00847	137	137	137	0	0	1	-360	360	-29.6162	-4.7952	29.8130	4.4341	0.0000	0.0000	0.0000	0.0000;
	604	601	0.029339	0.094793	0.009699	137	137	137	0	0	1	-360	360	21.9732	3.8952	-21.8467	-4.6072	0.0000	0.0000	0.0000	0.0000;
	782	692	0.011322	0.049256	0.004891	137	137	137	0	0	1	-360	360	-12.5194	-2.3265	12.5349	1.8155	0.0000	0.0000	0.0000	0.0000;
	783	782	0.002397	0.007603	0.000779	137	137	137	0	0	1	-360	360	-12.5161	-2.4079	12.5194	2.3265	0.0000	0.0000	0.0000	0.0000;
	785	783	0.002983	0.009587	0.00099	137	137	137	0	0	1	-360	360	-11.1840	0.4857	11.1871	-0.5921	0.0000	0.0000	0.0000	0.0000;
	785	586	0.018843	0.060992	0.006241	137	137	137	0	0	1	-360	360	31.5324	-2.6930	-31.3725	2.4779	0.0000	0.0000	0.0000	0.0000;
	799	586	0.025124	0.081066	0.008301	137	137	137	0	0	1	-360	360	-5.2210	-1.1296	5.2269	0.1796	0.0000	0.0000	0.0000	0.0000;
	799	591	0.004132	0.013223	0.00136	137	137	137	0	0	1	-360	360	5.2210	1.1296	-5.2200	-1.2848	0.0000	0.0000	0.0000	0.0000;
	693	679	0.023141	0.066281	0.006781	137	137	137	0	0	1	-360	360	37.8044	-1.0812	-37.5251	1.0836	0.0000	0.0000	0.0000	0.0000;
	679	591	0.007769	0.025124	0.00257	137	137	137	0	0	1	-360	360	25.6431	-1.2836	-25.5993	1.1254	0.0000	0.0000	0.0000	0.0000;
	720	591	0.003554	0.01157	0.0012	137	137	137	0	0	1	-360	360	-9.8759	3.7118	9.8793	-3.8405	0.0000	0.0000	0.0000	0.0000;
	688	692	0.010826	0.019174	0.001801	137	137	137	0	0	1	-360	360	-1.4827	-2.6756	1.4835	2.4639	0.0000	0.0000	0.0000	0.0000;
	701	688	0.004554	0.008017	0.00075	109	109	109	0	0	1	-360	360	5.8478	-1.9619	-5.8463	1.8756	0.0000	0.0000	0.0000	0.0000;
	687	686	0.00124	0.003967	0.00044	137	137	137	0	0	1	-360	360	-5.3877	-3.9360	5.3881	3.8853	0.0000	0.0000	0.0000	0.0000;
	698	686	0.003141	0.010248	0.00105	137	137	137	0	0	1	-360	360	9.0547	3.7693	-9.0521	-3.8853	0.0000	0.0000	0.0000	0.0000;
	693	682	0.033223	0.107521	0.010999	137	137	137	0	0	1	-360	360	-16.4934	-0.0475	16.5698	-1.0134	0.0000	0.0000	0.0000	0.0000;
	697	680	0.013636	0.044132	0.004521	137	137	137	0	0	1	-360	360	-22.7877	-1.5393	22.8481	1.2017	0.0000	0.0000	0.0000	0.0000;
	692	689	0.013388	0.02686	0.00257	137	137	137	0	0	1	-360	360	20.9335	0.7115	-20.8839	-0.9157	0.0000	0.0000	0.0000	0.0000;
	695	689	0.004628	0.015793	0.001609	137	137	137	0	0	1	-360	360	-18.1176	-3.2905	18.1310	3.1465	0.0000	0.0000	0.0000	0.0000;
	697	695	0.012636	0.040909	0.004179	109	109	109	0	0	1	-360	360	1.6707	-0.9807	-1.6704	0.4905	0.0000	0.0000	0.0000	0.0000;
	693	678	0.019669	0.063636	0.00651	137	137	137	0	0	1	-360	360	36.7395	0.9049	-36.5151	-0.9448	0.0000	0.0000	0.0000	0.0000;
	678	649	0.028256	0.091397	0.009341	137	137	137	0	0	1	-360	360	15.7631	-4.9952	-15.6983	4.1135	0.0000	0.0000	0.0000	0.0000;
	756	649	0.021818	0.070661	0.007231	137	137	137	0	0	1	-360	360	-10.1049	3.7805	10.1273	-4.5535	0.0000	0.0000	0.0000	0.0000;
	706	598	0.058347	0.09876	0.0106	109	109	109	0	0	1	-360	360	-7.5685	-3.6563	7.6014	2.4514	0.0000	0.0000	0.0000	0.0000;
	598	597	0.005702	0.018603	0.00189	137	137	137	0	0	1	-360	360	-22.7824	-3.6514	22.8077	3.5075	0.0000	0.0000	0.0000	0.0000;
	691	597	0.033223	0.107364	0.010989	137	137	137	0	0	1	-360	360	-16.1508	4.9817	16.2317	-6.0400	0.0000	0.0000	0.0000	0.0000;
	734	692	0.063719	0.206124	0.021081	137	137	137	0	0	1	-360	360	-9.1693	3.3678	9.2257	-5.6899	0.0000	0.0000	0.0000	0.0000;
	701	584	0.013719	0.04438	0.00454	137	137	137	0	0	1	-360	360	-17.4141	-0.9814	17.4493	0.5568	0.0000	0.0000	0.0000	0.0000;
	698	692	0.003802	0.028603	0.00273	183	183	183	0	0	1	-360	360	5.0622	-0.2015	-5.0614	-0.1157	0.0000	0.0000	0.0000	0.0000;
	698	693	0.002314	0.024132	0.003729	183	183	183	0	0	1	-360	360	8.3159	0.0767	-8.3146	-0.5044	0.0000	0.0000	0.0000	0.0000;
	698	584	0.004132	0.030661	0.002931	137	137	137	0	0	1	-360	360	-22.4329	-3.6446	22.4509	3.4300	0.0000	0.0000	0.0000	0.0000;
	681	583	0.003967	0.012984	0.001331	137	137	137	0	0	1	-360	360	74.9009	-0.7607	-74.7146	1.2120	0.0000	0.0000	0.0000	0.0000;
	820	597	0.032314	0.10438	0.01068	137	137	137	0	0	1	-360	360	49.9595	-3.2030	-49.2994	4.0401	0.0000	0.0000	0.0000	0.0000;
	820	819	0.040413	0.130579	0.013361	137	137	137	0	0	1	-360	360	23.1415	2.0882	-22.9620	-3.1280	0.0000	0.0000	0.0000	0.0000;
	681	584	0.003967	0.01281	0.001309	137	137	137	0	0	1	-360	360	74.7714	-1.4017	-74.5857	1.8454	0.0000	0.0000	0.0000	0.0000;
	682	680	0.013058	0.042066	0.00431	137	137	137	0	0	1	-360	360	36.1839	2.1525	-36.0401	-2.2017	0.0000	0.0000	0.0000	0.0000;
	722	601	0.030331	0.098099	0.010041	137	137	137	0	0	1	-360	360	3.4512	1.1288	-3.4473	-2.2685	0.0000	0.0000	0.0000	0.0000;
	819	734	0.037934	0.122983	0.012579	137	137	137	0	0	1	-360	360	2.0362	1.8752	-2.0327	-3.3678	0.0000	0.0000	0.0000	0.0000;
	693	689	0.009587	0.031157	0.00318	109	109	109	0	0	1	-360	360	17.1964	3.9875	-17.1710	-4.2808	0.0000	0.0000	0.0000	0.0000;
	698	687	0.005446	0.009587	0.0009	137	137	137	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	691	634	0.026364	0.085207	0.00871	137	137	137	0	0	1	-360	360	-21.2427	4.9605	21.3483	-5.6666	0.0000	0.0000	0.0000	0.0000;
	642	634	0.019174	0.062314	0.006369	137	137	137	0	0	1	-360	360	29.7630	-3.7011	-29.6210	3.3938	0.0000	0.0000	0.0000	0.0000;
	820	642	0.030661	0.099091	0.01014	137	137	137	0	0	1	-360	360	33.0744	-3.1460	-32.7990	2.8011	0.0000	0.0000	0.0000	0.0000;
	634	597	0.031066	0.100413	0.01029	137	137	137	0	0	1	-360	360	0.7347	0.7728	-0.7340	-2.0077	0.0000	0.0000	0.0000	0.0000;
	742	646	0.019174	0.061983	0.00634	137	137	137	0	0	1	-360	360	2.8284	0.0751	-2.8270	-0.8000	0.0000	0.0000	0.0000	0.0000;
	588	584	0.029174	0.080744	0.00832	137	137	137	0	0	1	-360	360	-30.6751	-3.4047	30.9127	3.0828	0.0000	0.0000	0.0000	0.0000;
	743	744	0.005207	0.016942	0.00173	137	137	137	0	0	1	-360	360	-13.2295	-2.0302	13.2376	1.8566	0.0000	0.0000	0.0000	0.0000;
	722	743	0.011066	0.035793	0.003659	137	137	137	0	0	1	-360	360	-11.6452	-1.9088	11.6585	1.5302	0.0000	0.0000	0.0000	0.0000;
	626	692	0.020331	0.06562	0.006711	137	137	137	0	0	1	-360	360	-6.7910	-2.5200	6.7997	1.7551	0.0000	0.0000	0.0000	0.0000;
	600	741	0.004959	0.013388	0.001379	137	137	137	0	0	1	-360	360	16.0506	-3.0311	-16.0391	2.9032	0.0000	0.0000	0.0000	0.0000;
	687	701	0.001066	0.008017	0.000179	137	137	137	0	0	1	-360	360	-1.2013	-2.0640	1.2014	2.0432	0.0000	0.0000	0.0000	0.0000;
	760	613	0.031157	0.055041	0.00515	109	109	109	0	0	1	-360	360	0.7594	-4.1685	-0.7553	3.5746	0.0000	0.0000	0.0000	0.0000;
	715	638	0.005124	0.012397	0.001229	109	109	109	0	0	1	-360	360	-23.3200	-0.1392	23.3451	0.0631	0.0000	0.0000	0.0000	0.0000;
	760	614	0.032149	0.055041	0.00515	109	109	109	0	0	1	-360	360	1.2113	-4.3121	-1.2065	3.7192	0.0000	0.0000	0.0000	0.0000;
	760	671	0.019008	0.051157	0.00528	137	137	137	0	0	1	-360	360	2.1332	2.2121	-2.1314	-2.8219	0.0000	0.0000	0.0000	0.0000;
	711	671	0.045793	0.127521	0.013141	137	137	137	0	0	1	-360	360	15.1257	-0.9094	-15.0366	-0.3781	0.0000	0.0000	0.0000	0.0000;
	809	710	0.024628	0.044876	0.00423	76	76	76	0	0	1	-360	360	-9.0563	-5.0314	9.0784	4.5764	0.0000	0.0000	0.0000	0.0000;
	809	594	0.058182	0.100413	0.00954	76	76	76	0	0	1	-360	360	0.9943	5.0314	-0.9782	-6.1105	0.0000	0.0000	0.0000	0.0000;
	832	710	0.010174	0.032983	0.003359	137	137	137	0	0	1	-360	360	-12.5185	2.8756	12.5329	-3.2236	0.0000	0.0000	0.0000	0.0000;
	833	828	0.003471	0.009008	0.000939	137	137	137	0	0	1	-360	360	-7.2714	-3.2174	7.2732	3.1118	0.0000	0.0000	0.0000	0.0000;
	833	832	0.006777	0.021901	0.002219	137	137	137	0	0	1	-360	360	-1.7326	3.2174	1.7335	-3.4756	0.0000	0.0000	0.0000	0.0000;
	828	711	0.014959	0.046612	0.004751	76	76	76	0	0	1	-360	360	-8.5734	4.3278	8.5854	-4.8491	0.0000	0.0000	0.0000	0.0000;
	828	813	0.063471	0.113802	0.010699	109	109	109	0	0	1	-360	360	29.6460	0.5861	-29.1713	-0.9733	0.0000	0.0000	0.0000	0.0000;
	715	677	0.044554	0.144132	0.01475	76	76	76	0	0	1	-360	360	4.0248	-2.8909	-4.0165	1.2766	0.0000	0.0000	0.0000	0.0000;
	830	711	0.069091	0.122727	0.01151	109	109	109	0	0	1	-360	360	-7.0048	-3.1496	7.0377	1.8644	0.0000	0.0000	0.0000	0.0000;
	613	606	0.014793	0.030826	0.002979	109	109	109	0	0	1	-360	360	0.0000	-0.3484	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	614	607	0.01843	0.033314	0.00326	109	109	109	0	0	1	-360	360	24.7364	4.8023	-24.6360	-5.0000	0.0000	0.0000	0.0000	0.0000;
	751	715	0.044628	0.078843	0.007381	76	76	76	0	0	1	-360	360	-1.7037	-2.2442	1.7062	1.4301	0.0000	0.0000	0.0000	0.0000;
	751	599	0.03843	0.100744	0.010411	137	137	137	0	0	1	-360	360	-25.7078	-0.0967	25.9373	-0.4639	0.0000	0.0000	0.0000	0.0000;
	747	751	0.037686	0.121901	0.01247	137	137	137	0	0	1	-360	360	21.5908	1.2169	-21.4337	-2.1016	0.0000	0.0000	0.0000	0.0000;
	704	614	0.055703	0.099504	0.009341	76	76	76	0	0	1	-360	360	-0.6440	1.8844	0.6470	-2.9732	0.0000	0.0000	0.0000	0.0000;
	822	704	0.040992	0.073636	0.006921	76	76	76	0	0	1	-360	360	3.3389	1.2793	-3.3340	-2.0844	0.0000	0.0000	0.0000	0.0000;
	614	608	0.007934	0.018934	0.001871	109	109	109	0	0	1	-360	360	16.7045	-0.7619	-16.6856	0.5887	0.0000	0.0000	0.0000	0.0000;
	613	611	0.008512	0.027851	0.002851	137	137	137	0	0	1	-360	360	14.2185	0.0384	-14.2038	-0.3233	0.0000	0.0000	0.0000	0.0000;
	616	611	0.009421	0.030504	0.003119	137	137	137	0	0	1	-360	360	-2.7911	-0.6850	2.7918	0.3233	0.0000	0.0000	0.0000	0.0000;
	616	608	0.007851	0.018347	0.001801	109	109	109	0	0	1	-360	360	-6.3179	0.3850	6.3206	-0.5887	0.0000	0.0000	0.0000	0.0000;
	816	812	0.027769	0.089752	0.009179	137	137	137	0	0	1	-360	360	-2.4080	-0.6000	2.4094	-0.4331	0.0000	0.0000	0.0000	0.0000;
	638	643	0.009421	0.030413	0.00311	109	109	109	0	0	1	-360	360	-36.8511	-0.4631	36.9660	0.4866	0.0000	0.0000	0.0000	0.0000;
	643	790	0.031397	0.078182	0.007749	137	137	137	0	0	1	-360	360	-41.7810	-0.6866	42.2699	1.0249	0.0000	0.0000	0.0000	0.0000;
	595	594	0.008347	0.027016	0.002771	137	137	137	0	0	1	-360	360	-7.4208	-1.6068	7.4249	1.3007	0.0000	0.0000	0.0000	0.0000;
	810	595	0.01843	0.059504	0.006079	137	137	137	0	0	1	-360	360	-1.3482	-1.8045	1.3488	1.1068	0.0000	0.0000	0.0000	0.0000;
	822	694	0.020661	0.06686	0.006839	137	137	137	0	0	1	-360	360	-11.1919	-1.4793	11.2141	0.7429	0.0000	0.0000	0.0000	0.0000;
	631	828	0.04876	0.157686	0.016129	137	137	137	0	0	1	-360	360	-13.1201	-2.6416	13.1938	0.9964	0.0000	0.0000	0.0000	0.0000;
	630	631	0.010496	0.033058	0.003381	137	137	137	0	0	1	-360	360	-2.3646	-0.2605	2.3651	-0.1295	0.0000	0.0000	0.0000	0.0000;
	745	630	0.026612	0.086033	0.008799	137	137	137	0	0	1	-360	360	3.0216	0.2345	-3.0194	-1.2475	0.0000	0.0000	0.0000	0.0000;
	815	745	0.017521	0.056777	0.00581	137	137	137	0	0	1	-360	360	6.4820	0.3799	-6.4756	-1.0345	0.0000	0.0000	0.0000	0.0000;
	828	815	0.037521	0.121397	0.012419	137	137	137	0	0	1	-360	360	12.5965	0.8927	-12.5450	-2.1799	0.0000	0.0000	0.0000	0.0000;
	644	828	0.035537	0.115041	0.019031	109	109	109	0	0	1	-360	360	-5.2350	-0.1000	5.2436	-2.1108	0.0000	0.0000	0.0000	0.0000;
	750	751	0.023802	0.053802	0.005501	109	109	109	0	0	1	-360	360	-9.2333	-1.6700	9.2521	1.1053	0.0000	0.0000	0.0000	0.0000;
	746	750	0.018017	0.031818	0.002979	109	109	109	0	0	1	-360	360	2.2846	-0.4965	-2.2837	0.1700	0.0000	0.0000	0.0000	0.0000;
	752	746	0.001653	0.005372	0.000549	109	109	109	0	0	1	-360	360	9.3009	1.4473	-9.2996	-1.5035	0.0000	0.0000	0.0000	0.0000;
	751	752	0.010826	0.019174	0.001801	76	76	76	0	0	1	-360	360	18.7587	1.9101	-18.7239	-2.0473	0.0000	0.0000	0.0000	0.0000;
	707	751	0.016777	0.029587	0.002771	109	109	109	0	0	1	-360	360	-0.9240	-0.0198	0.9241	-0.2867	0.0000	0.0000	0.0000	0.0000;
	707	751	0.014554	0.025703	0.00241	109	109	109	0	0	1	-360	360	-1.0640	0.0198	1.0642	-0.2862	0.0000	0.0000	0.0000	0.0000;
	812	677	0.083058	0.148678	0.013961	76	76	76	0	0	1	-360	360	7.3325	1.0848	-7.2905	-2.5766	0.0000	0.0000	0.0000	0.0000;
	813	812	0.014132	0.026942	0.00257	109	109	109	0	0	1	-360	360	21.8423	0.7733	-21.7829	-0.9517	0.0000	0.0000	0.0000	0.0000;
	790	810	0.02638	0.085314	0.008729	137	137	137	0	0	1	-360	360	5.0459	-2.7849	-5.0388	1.8045	0.0000	0.0000	0.0000	0.0000;
	633	589	0.03124	0.101066	0.010341	137	137	137	0	0	1	-360	360	-19.0069	1.0446	19.1066	-1.9069	0.0000	0.0000	0.0000	0.0000;
	791	685	0.034876	0.11281	0.011541	137	137	137	0	0	1	-360	360	3.0813	-2.4134	-3.0776	1.0741	0.0000	0.0000	0.0000	0.0000;
	685	683	0.002066	0.006612	0.00068	137	137	137	0	0	1	-360	360	-1.1104	-1.4741	1.1105	1.3946	0.0000	0.0000	0.0000	0.0000;
	780	683	0.019917	0.037107	0.003509	76	76	76	0	0	1	-360	360	13.2867	2.6401	-13.2555	-2.9946	0.0000	0.0000	0.0000	0.0000;
	804	769	0.01719	0.055703	0.005699	137	137	137	0	0	1	-360	360	-34.1142	-0.6412	34.2890	0.5518	0.0000	0.0000	0.0000	0.0000;
	803	719	0.012066	0.020744	0.00198	76	76	76	0	0	1	-360	360	28.0246	-3.6825	-27.9433	3.5881	0.0000	0.0000	0.0000	0.0000;
	803	779	0.05876	0.120248	0.01158	109	109	109	0	0	1	-360	360	5.0361	5.4696	-5.0047	-6.7660	0.0000	0.0000	0.0000	0.0000;
	804	627	0.045207	0.079256	0.006401	109	109	109	0	0	1	-360	360	-6.3924	4.2765	6.4170	-4.9654	0.0000	0.0000	0.0000	0.0000;
	627	623	0.013058	0.024554	0.00198	109	109	109	0	0	1	-360	360	-0.5025	0.6024	0.5026	-0.8285	0.0000	0.0000	0.0000	0.0000;
	733	623	0.044554	0.089256	0.00679	109	109	109	0	0	1	-360	360	6.8026	-0.1708	-6.7846	-0.5715	0.0000	0.0000	0.0000	0.0000;
	622	769	0.022066	0.07124	0.007289	137	137	137	0	0	1	-360	360	42.5029	2.7976	-42.1630	-2.5518	0.0000	0.0000	0.0000	0.0000;
	703	702	0.00876	0.014554	0.00152	109	109	109	0	0	1	-360	360	4.4422	0.4509	-4.4408	-0.6267	0.0000	0.0000	0.0000	0.0000;
	808	803	0.003967	0.006942	0.000661	109	109	109	0	0	1	-360	360	-11.1401	-7.7449	11.1463	7.6774	0.0000	0.0000	0.0000	0.0000;
	723	645	0.016198	0.052231	0.005351	76	76	76	0	0	1	-360	360	-12.6627	4.8694	12.6885	-5.4166	0.0000	0.0000	0.0000	0.0000;
	645	609	0.01595	0.031744	0.00302	76	76	76	0	0	1	-360	360	-15.3065	5.4166	15.3424	-5.7007	0.0000	0.0000	0.0000	0.0000;
	703	609	0.01124	0.019752	0.00173	109	109	109	0	0	1	-360	360	-1.9412	-10.4046	1.9517	10.2196	0.0000	0.0000	0.0000	0.0000;
	703	610	0.010826	0.019091	0.00166	109	109	109	0	0	1	-360	360	2.9057	1.4512	-2.9047	-1.6442	0.0000	0.0000	0.0000	0.0000;
	796	771	0.003719	0.011901	0.00121	137	137	137	0	0	1	-360	360	-25.8205	-2.5413	25.8422	2.4713	0.0000	0.0000	0.0000	0.0000;
	774	771	0.022636	0.07314	0.00748	137	137	137	0	0	1	-360	360	32.7540	3.4784	-32.5442	-3.6713	0.0000	0.0000	0.0000	0.0000;
	804	590	0.136198	0.235124	0.022351	137	137	137	0	0	1	-360	360	-9.0955	2.9697	9.2155	-5.3270	0.0000	0.0000	0.0000	0.0000;
	773	590	0.006124	0.019917	0.00204	137	137	137	0	0	1	-360	360	2.2579	0.0384	-2.2577	-0.2722	0.0000	0.0000	0.0000	0.0000;
	778	590	0.004628	0.014793	0.0016	137	137	137	0	0	1	-360	360	22.1252	3.6793	-22.1050	-3.7989	0.0000	0.0000	0.0000	0.0000;
	778	772	0.007438	0.02405	0.002471	137	137	137	0	0	1	-360	360	-18.1612	0.3695	18.1825	-0.5859	0.0000	0.0000	0.0000	0.0000;
	772	762	0.003223	0.010496	0.001089	137	137	137	0	0	1	-360	360	-31.4795	0.5859	31.5071	-0.6218	0.0000	0.0000	0.0000	0.0000;
	777	774	0.027107	0.087769	0.008981	137	137	137	0	0	1	-360	360	8.9977	-2.8170	-8.9779	1.8266	0.0000	0.0000	0.0000	0.0000;
	775	648	0.009669	0.031488	0.003221	137	137	137	0	0	1	-360	360	14.0914	1.2877	-14.0749	-1.6114	0.0000	0.0000	0.0000	0.0000;
	717	648	0.045446	0.080909	0.00757	109	109	109	0	0	1	-360	360	-1.1973	-0.6958	1.1979	-0.1886	0.0000	0.0000	0.0000	0.0000;
	717	610	0.026281	0.046942	0.0044	109	109	109	0	0	1	-360	360	-7.5967	-0.1042	7.6097	-0.3878	0.0000	0.0000	0.0000	0.0000;
	749	703	0.010909	0.019256	0.001801	109	109	109	0	0	1	-360	360	13.8024	-4.6795	-13.7827	4.5026	0.0000	0.0000	0.0000	0.0000;
	736	628	0.035207	0.076446	0.007429	137	137	137	0	0	1	-360	360	13.9032	4.0347	-13.8403	-4.7794	0.0000	0.0000	0.0000	0.0000;
	797	737	0.022397	0.072397	0.00741	137	137	137	0	0	1	-360	360	-12.2527	-5.4073	12.2858	4.6340	0.0000	0.0000	0.0000	0.0000;
	737	712	0.021322	0.06595	0.006711	109	109	109	0	0	1	-360	360	46.7050	3.0289	-46.3135	-2.6117	0.0000	0.0000	0.0000	0.0000;
	712	610	0.076942	0.132562	0.01263	109	109	109	0	0	1	-360	360	5.6395	-4.6883	-5.6084	3.2618	0.0000	0.0000	0.0000	0.0000;
	787	590	0.031818	0.079587	0.008061	137	137	137	0	0	1	-360	360	-12.5484	-13.2500	12.6396	12.5624	0.0000	0.0000	0.0000	0.0000;
	787	763	0.009174	0.022893	0.002321	137	137	137	0	0	1	-360	360	3.7544	12.0500	-3.7411	-12.2763	0.0000	0.0000	0.0000	0.0000;
	805	589	0.023554	0.07562	0.007819	137	137	137	0	0	1	-360	360	-35.9652	-5.4219	36.2413	5.4188	0.0000	0.0000	0.0000	0.0000;
	805	667	0.022231	0.071397	0.007381	137	137	137	0	0	1	-360	360	23.7152	3.6219	-23.6009	-4.0790	0.0000	0.0000	0.0000	0.0000;
	665	587	0.022066	0.059173	0.00611	137	137	137	0	0	1	-360	360	2.0733	-3.9470	-2.0699	3.2705	0.0000	0.0000	0.0000	0.0000;
	788	587	0.025372	0.067364	0.00695	137	137	137	0	0	1	-360	360	12.8871	4.0811	-12.8455	-4.7561	0.0000	0.0000	0.0000	0.0000;
	684	788	0.01405	0.036446	0.00377	137	137	137	0	0	1	-360	360	15.4717	1.9146	-15.4417	-2.2663	0.0000	0.0000	0.0000	0.0000;
	667	629	0.020744	0.067017	0.006861	137	137	137	0	0	1	-360	360	0.9405	6.9101	-0.9304	-7.6347	0.0000	0.0000	0.0000	0.0000;
	655	629	0.009669	0.026198	0.002631	109	109	109	0	0	1	-360	360	12.1747	-6.8774	-12.1576	6.6347	0.0000	0.0000	0.0000	0.0000;
	718	655	0.006198	0.02	0.00204	109	109	109	0	0	1	-360	360	13.2604	-7.1102	-13.2477	6.9274	0.0000	0.0000	0.0000	0.0000;
	811	609	0.015793	0.051066	0.00523	137	137	137	0	0	1	-360	360	-49.2596	-2.3638	49.5905	2.8221	0.0000	0.0000	0.0000	0.0000;
	777	759	0.001744	0.00562	0.000581	137	137	137	0	0	1	-360	360	-27.6347	-1.2830	27.6461	1.2513	0.0000	0.0000	0.0000	0.0000;
	817	792	0.020579	0.036281	0.00339	109	109	109	0	0	1	-360	360	-15.3014	-0.9706	15.3435	0.6548	0.0000	0.0000	0.0000	0.0000;
	829	817	0.028017	0.090496	0.00924	137	137	137	0	0	1	-360	360	-10.9792	-1.9290	11.0094	0.9706	0.0000	0.0000	0.0000	0.0000;
	829	788	0.008678	0.015372	0.00143	137	137	137	0	0	1	-360	360	8.6762	1.4290	-8.6703	-1.5812	0.0000	0.0000	0.0000	0.0000;
	775	589	0.033058	0.10686	0.010941	137	137	137	0	0	1	-360	360	27.4876	2.4731	-27.2721	-3.0480	0.0000	0.0000	0.0000	0.0000;
	804	637	0.032983	0.106686	0.010909	137	137	137	0	0	1	-360	360	11.5780	-2.0680	-11.5388	0.9486	0.0000	0.0000	0.0000	0.0000;
	723	807	0.020661	0.066777	0.006829	109	109	109	0	0	1	-360	360	12.5577	-4.8694	-12.5266	4.1649	0.0000	0.0000	0.0000	0.0000;
	811	632	0.014793	0.047686	0.004881	137	137	137	0	0	1	-360	360	34.3916	1.4638	-34.2404	-1.5400	0.0000	0.0000	0.0000	0.0000;
	814	632	0.007438	0.01314	0.001229	109	109	109	0	0	1	-360	360	-22.6900	0.8782	22.7234	-0.9600	0.0000	0.0000	0.0000	0.0000;
	814	627	0.008256	0.014628	0.00137	109	109	109	0	0	1	-360	360	17.9790	-1.5782	-17.9555	1.4630	0.0000	0.0000	0.0000	0.0000;
	800	788	0.002562	0.008182	0.00083	137	137	137	0	0	1	-360	360	-6.0421	-0.8580	6.0430	0.7664	0.0000	0.0000	0.0000	0.0000;
	702	610	0.005289	0.016859	0.00173	137	137	137	0	0	1	-360	360	-0.9032	1.0272	0.9033	-1.2299	0.0000	0.0000	0.0000	0.0000;
	775	676	0.038934	0.12595	0.012879	137	137	137	0	0	1	-360	360	43.6560	1.1853	-43.0227	-0.6257	0.0000	0.0000	0.0000	0.0000;
	728	749	0.02157	0.047438	0.00462	109	109	109	0	0	1	-360	360	16.3665	-4.4084	-16.3144	3.9795	0.0000	0.0000	0.0000	0.0000;
	728	736	0.029669	0.066364	0.00649	137	137	137	0	0	1	-360	360	-40.1569	5.9530	40.5730	-5.7922	0.0000	0.0000	0.0000	0.0000;
	676	633	0.009826	0.031818	0.00325	137	137	137	0	0	1	-360	360	-18.7674	0.7729	18.7979	-1.0446	0.0000	0.0000	0.0000	0.0000;
	775	759	0.02438	0.078017	0.008071	137	137	137	0	0	1	-360	360	-12.2719	2.1612	12.3046	-3.0048	0.0000	0.0000	0.0000	0.0000;
	762	759	0.017769	0.057364	0.005871	137	137	137	0	0	1	-360	360	-48.5731	-0.7782	48.9353	1.2625	0.0000	0.0000	0.0000	0.0000;
	797	628	0.008182	0.026446	0.00271	137	137	137	0	0	1	-360	360	6.3897	4.9073	-6.3851	-5.2122	0.0000	0.0000	0.0000	0.0000;
	665	605	0.012397	0.054132	0.006749	137	137	137	0	0	1	-360	360	6.5551	-2.0775	-6.5500	1.3433	0.0000	0.0000	0.0000	0.0000;
	807	808	0.008512	0.027438	0.00281	109	109	109	0	0	1	-360	360	-3.1784	-6.5649	3.1821	6.2449	0.0000	0.0000	0.0000	0.0000;
	800	789	0.006364	0.020579	0.002101	137	137	137	0	0	1	-360	360	0.9111	-0.0420	-0.9111	-0.1964	0.0000	0.0000	0.0000	0.0000;
	605	587	0.017934	0.058016	0.005929	137	137	137	0	0	1	-360	360	-3.5010	-1.9433	3.5034	1.2856	0.0000	0.0000	0.0000	0.0000;
	664	667	0.001488	0.002636	0.000249	109	109	109	0	0	1	-360	360	-5.9328	2.7945	5.9334	-2.8212	0.0000	0.0000	0.0000	0.0000;
	666	664	0.000579	0.001901	0.000191	137	137	137	0	0	1	-360	360	0.3493	3.9736	-0.3492	-3.9945	0.0000	0.0000	0.0000	0.0000;
	831	804	0.028678	0.09281	0.009489	109	109	109	0	0	1	-360	360	-10.2868	2.1441	10.3152	-3.1380	0.0000	0.0000	0.0000	0.0000;
	585	733	0.015703	0.050744	0.005191	137	137	137	0	0	1	-360	360	-3.0360	-0.6000	3.0373	0.0079	0.0000	0.0000	0.0000	0.0000;
	657	728	0.021322	0.068934	0.00705	137	137	137	0	0	1	-360	360	-22.6493	1.5205	22.7434	-2.0445	0.0000	0.0000	0.0000	0.0000;
	796	773	0.008182	0.026529	0.00271	137	137	137	0	0	1	-360	360	8.0215	-0.2587	-8.0169	-0.0384	0.0000	0.0000	0.0000	0.0000;
	668	666	0.011488	0.029669	0.003011	109	109	109	0	0	1	-360	360	15.6638	5.5125	-15.6353	-5.7736	0.0000	0.0000	0.0000	0.0000;
	654	718	0.006198	0.02	0.00204	137	137	137	0	0	1	-360	360	22.4676	-4.1942	-22.4381	4.0654	0.0000	0.0000	0.0000	0.0000;
	725	657	0.018099	0.058512	0.00599	137	137	137	0	0	1	-360	360	-17.1572	2.7722	17.2043	-3.3205	0.0000	0.0000	0.0000	0.0000;
	665	668	0.005702	0.016033	0.00165	137	137	137	0	0	1	-360	360	22.6027	6.0064	-22.5748	-6.1125	0.0000	0.0000	0.0000	0.0000;
	792	684	0.019174	0.049826	0.005159	76	76	76	0	0	1	-360	360	22.8895	2.8528	-22.8007	-3.2146	0.0000	0.0000	0.0000	0.0000;
	791	774	0.023058	0.074628	0.00764	137	137	137	0	0	1	-360	360	-10.6193	0.1134	10.6416	-0.9367	0.0000	0.0000	0.0000	0.0000;
	780	622	0.000157	0.000504	5.1e-05	137	137	137	0	0	1	-360	360	-14.5377	-2.5401	14.5380	2.5350	0.0000	0.0000	0.0000	0.0000;
	593	718	0.030248	0.059314	0.00567	137	137	137	0	0	1	-360	360	13.4884	-2.3877	-13.4373	1.8647	0.0000	0.0000	0.0000	0.0000;
	665	635	0.013587	0.043942	0.004496	137	137	137	0	0	1	-360	360	4.7137	0.0053	-4.7110	-0.5000	0.0000	0.0000	0.0000	0.0000;
	835	764	0.051901	0.131397	0.013119	137	137	137	0	0	1	-360	360	-23.9738	1.8676	24.2339	-2.7442	0.0000	0.0000	0.0000	0.0000;
	767	765	0.015207	0.02562	0.002449	109	109	109	0	0	1	-360	360	-25.8046	4.7905	25.8940	-4.9281	0.0000	0.0000	0.0000	0.0000;
	767	766	0.008512	0.01438	0.001549	109	109	109	0	0	1	-360	360	10.0996	-7.7905	-10.0879	7.6283	0.0000	0.0000	0.0000	0.0000;
	766	740	0.027016	0.087603	0.009	137	137	137	0	0	1	-360	360	-6.6641	-10.6283	6.6978	9.6705	0.0000	0.0000	0.0000	0.0000;
	739	675	0.018512	0.06	0.00614	137	137	137	0	0	1	-360	360	-13.3875	-10.4979	13.4305	9.8878	0.0000	0.0000	0.0000	0.0000;
	675	661	0.013719	0.044463	0.00454	137	137	137	0	0	1	-360	360	-38.5585	-11.3878	38.7382	11.4072	0.0000	0.0000	0.0000	0.0000;
	764	757	0.022893	0.051901	0.00506	109	109	109	0	0	1	-360	360	26.4287	0.2171	-26.2931	-0.5034	0.0000	0.0000	0.0000	0.0000;
	768	757	0.025207	0.057438	0.00561	109	109	109	0	0	1	-360	360	-15.3722	4.0248	15.4275	-4.5528	0.0000	0.0000	0.0000	0.0000;
	768	761	0.005793	0.009917	0.00105	137	137	137	0	0	1	-360	360	-2.4268	-8.0248	2.4302	7.9083	0.0000	0.0000	0.0000	0.0000;
	641	618	0.017769	0.057364	0.005871	137	137	137	0	0	1	-360	360	-25.5433	-11.3467	25.6589	11.0160	0.0000	0.0000	0.0000	0.0000;
	661	618	0.020579	0.066124	0.006861	137	137	137	0	0	1	-360	360	37.1201	18.7746	-36.8326	-18.6948	0.0000	0.0000	0.0000	0.0000;
	764	612	0.009008	0.031066	0.002979	137	137	137	0	0	1	-360	360	4.6413	8.2864	-4.6342	-8.6124	0.0000	0.0000	0.0000	0.0000;
	748	612	0.023967	0.083223	0.007991	137	137	137	0	0	1	-360	360	0.6178	-9.4855	-0.6008	8.6124	0.0000	0.0000	0.0000	0.0000;
	758	748	0.023223	0.075207	0.0077	137	137	137	0	0	1	-360	360	9.0259	-9.2700	-8.9938	8.4855	0.0000	0.0000	0.0000	0.0000;
	826	784	0.008843	0.014876	0.0015	109	109	109	0	0	1	-360	360	-11.7840	-5.8670	11.7972	5.7160	0.0000	0.0000	0.0000	0.0000;
	826	596	0.014628	0.025793	0.00242	109	109	109	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	798	764	0.053314	0.133388	0.010641	144	144	144	0	0	1	-360	360	-16.5850	-3.9225	16.7173	3.0126	0.0000	0.0000	0.0000	0.0000;
	765	636	0.040661	0.111157	0.011471	137	137	137	0	0	1	-360	360	14.1327	2.2254	-14.0610	-3.3723	0.0000	0.0000	0.0000	0.0000;
	802	636	0.027769	0.077686	0.00801	137	137	137	0	0	1	-360	360	-8.8054	-3.2419	8.8260	2.3723	0.0000	0.0000	0.0000	0.0000;
	802	798	0.002893	0.007769	0.000801	137	137	137	0	0	1	-360	360	-3.2356	1.7419	3.2359	-1.8333	0.0000	0.0000	0.0000	0.0000;
	596	798	0.04	0.061818	0.006759	109	109	109	0	0	1	-360	360	6.3935	-9.0236	-6.3532	8.3086	0.0000	0.0000	0.0000	0.0000;
	794	596	0.038256	0.06562	0.01263	109	109	109	0	0	1	-360	360	-1.5820	-7.3343	1.5976	5.9186	0.0000	0.0000	0.0000	0.0000;
	794	669	0.028934	0.049752	0.00953	109	109	109	0	0	1	-360	360	-3.6530	7.3343	3.6722	-8.3823	0.0000	0.0000	0.0000	0.0000;
	670	669	0.004132	0.007107	0.00137	109	109	109	0	0	1	-360	360	13.1030	-6.5239	-13.0952	6.3823	0.0000	0.0000	0.0000	0.0000;
	798	726	0.069091	0.123802	0.010079	109	109	109	0	0	1	-360	360	-4.6210	-4.1739	4.6415	3.0412	0.0000	0.0000	0.0000	0.0000;
	798	659	0.039917	0.067934	0.005431	109	109	109	0	0	1	-360	360	-1.3422	-3.9701	1.3474	3.3515	0.0000	0.0000	0.0000	0.0000;
	731	659	0.01281	0.021818	0.00175	109	109	109	0	0	1	-360	360	5.0162	4.1566	-5.0114	-4.3515	0.0000	0.0000	0.0000	0.0000;
	731	727	0.013223	0.034298	0.003291	109	109	109	0	0	1	-360	360	-12.7592	-4.5966	12.7799	4.2669	0.0000	0.0000	0.0000	0.0000;
	726	690	0.031322	0.101397	0.010379	137	137	137	0	0	1	-360	360	12.0458	-0.9369	-12.0069	-0.1459	0.0000	0.0000	0.0000	0.0000;
	729	726	0.002479	0.007934	0.00082	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	729	726	0.002479	0.007934	0.00082	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	730	729	0.000331	0.000579	0.0242	274	274	274	0	0	1	-360	360	104.7401	37.6411	-104.6990	-40.0000	0.0000	0.0000	0.0000	0.0000;
	618	592	0.016281	0.052727	0.005411	137	137	137	0	0	1	-360	360	6.9857	6.6788	-6.9725	-7.2884	0.0000	0.0000	0.0000	0.0000;
	818	660	0.034711	0.112562	0.01158	137	137	137	0	0	1	-360	360	-60.4588	2.9970	61.5087	-1.0185	0.0000	0.0000	0.0000	0.0000;
	818	709	0.015124	0.051322	0.00251	137	137	137	0	0	1	-360	360	47.3708	-3.9970	-47.0891	4.6496	0.0000	0.0000	0.0000	0.0000;
	709	624	0.029496	0.051818	0.004881	137	137	137	0	0	1	-360	360	46.0421	-4.6496	-45.5177	4.9890	0.0000	0.0000	0.0000	0.0000;
	806	596	0.010248	0.018099	0.001699	109	109	109	0	0	1	-360	360	21.8376	-6.2082	-21.7917	6.0942	0.0000	0.0000	0.0000	0.0000;
	823	806	0.03124	0.055124	0.005159	109	109	109	0	0	1	-360	360	23.5643	-5.0287	-23.4086	4.7082	0.0000	0.0000	0.0000	0.0000;
	823	663	0.024463	0.043223	0.004051	109	109	109	0	0	1	-360	360	-26.7053	4.5287	26.8607	-4.7254	0.0000	0.0000	0.0000	0.0000;
	713	663	0.057364	0.100826	0.009489	109	109	109	0	0	1	-360	360	-0.5828	-2.0274	0.5840	0.9234	0.0000	0.0000	0.0000	0.0000;
	724	713	0.013636	0.070413	0.007279	137	137	137	0	0	1	-360	360	-9.8689	-2.2311	9.8808	1.4468	0.0000	0.0000	0.0000	0.0000;
	650	663	0.003058	0.009826	0.001009	137	137	137	0	0	1	-360	360	-12.0169	-5.5895	12.0215	5.4865	0.0000	0.0000	0.0000	0.0000;
	652	651	0.004463	0.014554	0.001481	137	137	137	0	0	1	-360	360	-19.3963	0.7538	19.4108	-0.8791	0.0000	0.0000	0.0000	0.0000;
	754	651	0.01405	0.045372	0.004649	137	137	137	0	0	1	-360	360	36.3206	-0.9133	-36.1628	0.8791	0.0000	0.0000	0.0000	0.0000;
	653	663	0.007603	0.024554	0.002519	137	137	137	0	0	1	-360	360	-18.0296	-6.0380	18.0531	5.8205	0.0000	0.0000	0.0000	0.0000;
	674	653	0.004463	0.013876	0.00143	137	137	137	0	0	1	-360	360	-7.5569	-3.6956	7.5596	3.5380	0.0000	0.0000	0.0000	0.0000;
	662	674	0.005702	0.018512	0.00189	137	137	137	0	0	1	-360	360	8.1514	-0.9043	-8.1481	0.6956	0.0000	0.0000	0.0000	0.0000;
	754	713	0.021984	0.06843	0.00702	137	137	137	0	0	1	-360	360	25.1211	-0.5339	-25.0030	0.0806	0.0000	0.0000	0.0000	0.0000;
	821	755	0.016198	0.02843	0.002691	109	109	109	0	0	1	-360	360	-3.1946	-10.9739	3.2122	10.6898	0.0000	0.0000	0.0000	0.0000;
	821	640	0.039174	0.066033	0.003959	109	109	109	0	0	1	-360	360	-5.7044	8.9739	5.7438	-9.3682	0.0000	0.0000	0.0000	0.0000;
	639	640	0.009587	0.020174	0.00196	109	109	109	0	0	1	-360	360	16.2429	-9.5341	-16.2138	9.3682	0.0000	0.0000	0.0000	0.0000;
	755	714	0.009669	0.03157	0.003221	137	137	137	0	0	1	-360	360	15.6541	0.2922	-15.6339	-0.6041	0.0000	0.0000	0.0000	0.0000;
	714	615	0.047769	0.090579	0.00862	109	109	109	0	0	1	-360	360	10.3989	0.1041	-10.3546	-1.0251	0.0000	0.0000	0.0000	0.0000;
	781	615	0.022727	0.046612	0.004501	109	109	109	0	0	1	-360	360	-3.0235	-1.5424	3.0256	1.0251	0.0000	0.0000	0.0000	0.0000;
	781	602	0.024628	0.059587	0.004961	109	109	109	0	0	1	-360	360	-0.1175	0.5424	0.1177	-1.1162	0.0000	0.0000	0.0000	0.0000;
	603	602	0.005702	0.018512	0.00189	109	109	109	0	0	1	-360	360	1.9564	3.7400	-1.9555	-3.9558	0.0000	0.0000	0.0000	0.0000;
	835	690	0.04719	0.085207	0.00803	109	109	109	0	0	1	-360	360	-3.1031	0.9304	3.1079	-1.8541	0.0000	0.0000	0.0000	0.0000;
	757	753	0.007769	0.016859	0.00165	137	137	137	0	0	1	-360	360	-5.8863	4.0563	5.8898	-4.2414	0.0000	0.0000	0.0000	0.0000;
	776	765	0.016859	0.029826	0.00281	109	109	109	0	0	1	-360	360	-33.6651	0.8226	33.8287	-0.8630	0.0000	0.0000	0.0000	0.0000;
	776	753	0.003554	0.006281	0.005421	109	109	109	0	0	1	-360	360	31.0471	-1.3226	-31.0178	0.7414	0.0000	0.0000	0.0000	0.0000;
	834	596	0.005868	0.010331	0.00097	109	109	109	0	0	1	-360	360	-5.4224	3.8819	5.4247	-3.9892	0.0000	0.0000	0.0000	0.0000;
	834	793	0.003802	0.012397	0.00127	109	109	109	0	0	1	-360	360	3.9244	-4.8819	-3.9231	4.7403	0.0000	0.0000	0.0000	0.0000;
	793	735	0.00405	0.012984	0.001331	137	137	137	0	0	1	-360	360	-0.7879	-5.2403	0.7888	5.0904	0.0000	0.0000	0.0000	0.0000;
	758	619	0.003554	0.01157	0.001191	137	137	137	0	0	1	-360	360	3.1413	-0.1359	-3.1410	0.0000	0.0000	0.0000	0.0000	0.0000;
	801	603	0.017769	0.057603	0.00589	109	109	109	0	0	1	-360	360	7.2011	3.0872	-7.1914	-3.7400	0.0000	0.0000	0.0000	0.0000;
	625	801	0.017769	0.057603	0.00589	109	109	109	0	0	1	-360	360	10.8847	2.9623	-10.8651	-3.5872	0.0000	0.0000	0.0000	0.0000;
	738	602	0.021744	0.038347	0.003589	109	109	109	0	0	1	-360	360	12.8521	-3.4297	-12.8192	3.0720	0.0000	0.0000	0.0000	0.0000;
	738	827	0.01719	0.05562	0.00568	137	137	137	0	0	1	-360	360	-21.2291	3.0118	21.2976	-3.4502	0.0000	0.0000	0.0000	0.0000;
	827	673	0.01719	0.05562	0.00568	137	137	137	0	0	1	-360	360	-23.9167	3.6565	24.0035	-4.0375	0.0000	0.0000	0.0000	0.0000;
	708	592	0.020744	0.067273	0.00688	137	137	137	0	0	1	-360	360	-0.6827	-7.0858	0.6905	6.2884	0.0000	0.0000	0.0000	0.0000;
	672	670	0.00157	0.003058	0.00029	69	69	69	0	0	1	-360	360	15.2008	-6.5493	-15.1970	6.5239	0.0000	0.0000	0.0000	0.0000;
	784	765	0.038256	0.067521	0.006331	109	109	109	0	0	1	-360	360	-20.1732	-6.2160	20.3192	5.7343	0.0000	0.0000	0.0000	0.0000;
	798	721	0.024876	0.072231	0.00824	137	137	137	0	0	1	-360	360	7.8664	0.0911	-7.8530	-1.0000	0.0000	0.0000	0.0000	0.0000;
	738	656	0.015207	0.049008	0.005019	20	20	20	0	0	1	-360	360	0.5240	-0.5821	-0.5240	0.0000	0.0000	0.0000	0.0000	0.0000;
	826	795	0.000413	0.011901	0.00122	69	69	69	0	0	1	-360	360	11.7840	5.8670	-11.7833	-5.9895	0.0000	0.0000	0.0000	0.0000;
	735	795	0.00281	0.009008	0.00092	69	69	69	0	0	1	-360	360	-5.4998	-5.5904	5.5013	5.4895	0.0000	0.0000	0.0000	0.0000;
	755	647	0.022893	0.074132	0.007579	137	137	137	0	0	1	-360	360	20.2989	0.1401	-20.2185	-0.7663	0.0000	0.0000	0.0000	0.0000;
	739	740	0.019339	0.062636	0.006411	137	137	137	0	0	1	-360	360	9.7235	9.4979	-9.6928	-10.1705	0.0000	0.0000	0.0000	0.0000;
	652	650	0.004554	0.014711	0.0015	137	137	137	0	0	1	-360	360	-7.8257	-4.7538	7.8289	4.5895	0.0000	0.0000	0.0000	0.0000;
	639	786	0.034876	0.064876	0.00614	109	109	109	0	0	1	-360	360	-19.3839	9.5341	19.5264	-9.9809	0.0000	0.0000	0.0000	0.0000;
	761	641	0.020992	0.067851	0.006941	137	137	137	0	0	1	-360	360	-18.1352	-10.9083	18.2143	10.3467	0.0000	0.0000	0.0000	0.0000;
	647	662	0.010826	0.035124	0.003589	69	69	69	0	0	1	-360	360	17.0775	-0.2337	-17.0504	-0.0957	0.0000	0.0000	0.0000	0.0000;
	621	827	0.019174	0.059587	0.006103	69	69	69	0	0	1	-360	360	-2.6180	-0.5000	2.6191	-0.2063	0.0000	0.0000	0.0000	0.0000;
	1863	1272	0.026281	0.082975	0.009048	114	114	114	0	0	1	-360	360	8.7123	0.9796	-8.6951	-2.0061	0.0000	0.0000	0.0000	0.0000;
	1271	1272	0.002975	0.009669	0.001004	140	140	140	0	0	1	-360	360	-8.6930	-2.9810	8.6951	2.8683	0.0000	0.0000	0.0000	0.0000;
	981	1493	0.036116	0.050413	0.008291	57	57	57	0	0	1	-360	360	-2.3740	0.5611	2.3761	-1.5159	0.0000	0.0000	0.0000	0.0000;
	980	981	0	8.3e-05	1e-05	29	29	29	0	0	1	-360	360	-2.3740	0.5600	2.3740	-0.5611	0.0000	0.0000	0.0000	0.0000;
	1014	983	0.016198	0.049174	0.00584	114	114	114	0	0	1	-360	360	27.8083	0.5376	-27.7051	-0.9305	0.0000	0.0000	0.0000	0.0000;
	1013	1014	0.000165	0.000248	4.4e-05	90	90	90	0	0	1	-360	360	-2.4990	-0.8580	2.4990	0.8527	0.0000	0.0000	0.0000	0.0000;
	1018	1359	0.016529	0.050413	0.005893	114	114	114	0	0	1	-360	360	-27.5607	3.1382	27.6766	-3.4353	0.0000	0.0000	0.0000	0.0000;
	1017	1018	0.000496	0.001488	0.000172	114	114	114	0	0	1	-360	360	-5.0020	-1.5430	5.0021	1.5245	0.0000	0.0000	0.0000	0.0000;
	1143	896	0.038678	0.099587	0.011081	114	114	114	0	0	1	-360	360	-3.3597	-2.8339	3.3650	1.5344	0.0000	0.0000	0.0000	0.0000;
	1603	1347	0.005372	0.01719	0.001832	114	114	114	0	0	1	-360	360	11.9019	2.5402	-11.8950	-2.7290	0.0000	0.0000	0.0000	0.0000;
	897	1603	0.039091	0.09562	0.010571	114	114	114	0	0	1	-360	360	27.1960	6.8670	-26.9341	-7.4635	0.0000	0.0000	0.0000	0.0000;
	1602	1603	8.3e-05	0.000248	1.9e-05	120	120	120	0	0	1	-360	360	-15.0320	-4.9250	15.0322	4.9233	0.0000	0.0000	0.0000	0.0000;
	1326	1246	0.01595	0.046694	0.004131	114	114	114	0	0	1	-360	360	-2.2887	-1.5113	2.2896	1.0221	0.0000	0.0000	0.0000	0.0000;
	1720	1326	0.031736	0.094215	0.008361	120	120	120	0	0	1	-360	360	-1.1005	-2.3297	1.1017	1.3404	0.0000	0.0000	0.0000	0.0000;
	1324	1326	0.000496	0.001157	0.000135	29	29	29	0	0	1	-360	360	-1.1870	-0.1870	1.1870	0.1709	0.0000	0.0000	0.0000	0.0000;
	1327	1245	0.01595	0.046694	0.004136	114	114	114	0	0	1	-360	360	10.2837	4.7365	-10.2659	-5.1671	0.0000	0.0000	0.0000	0.0000;
	1721	1327	0.031736	0.094215	0.008361	120	120	120	0	0	1	-360	360	10.3172	3.8348	-10.2837	-4.7206	0.0000	0.0000	0.0000	0.0000;
	1325	1327	0.000496	0.001157	0.000135	29	29	29	0	0	1	-360	360	0.0000	-0.0000	-0.0000	-0.0159	0.0000	0.0000	0.0000	0.0000;
	1893	1633	0.048182	0.119835	0.013225	114	114	114	0	0	1	-360	360	-10.9915	-1.4973	11.0429	0.1117	0.0000	0.0000	0.0000	0.0000;
	1632	1300	0.040165	0.105785	0.01189	114	114	114	0	0	1	-360	360	10.4551	-0.0266	-10.4168	-1.2353	0.0000	0.0000	0.0000	0.0000;
	1011	880	0.011653	0.03595	0.004112	114	114	114	0	0	1	-360	360	-69.7847	-11.7518	70.2744	12.7681	0.0000	0.0000	0.0000	0.0000;
	1010	881	0.011653	0.03595	0.004112	114	114	114	0	0	1	-360	360	13.2990	4.4127	-13.2801	-4.8553	0.0000	0.0000	0.0000	0.0000;
	1216	1635	0.002727	0.008926	0.000886	140	140	140	0	0	1	-360	360	57.5118	3.5504	-57.4337	-3.3971	0.0000	0.0000	0.0000	0.0000;
	1350	1216	0.007603	0.023471	0.002664	114	114	114	0	0	1	-360	360	65.5155	6.6647	-65.2340	-6.1061	0.0000	0.0000	0.0000	0.0000;
	1215	1216	0.000331	0.000413	8.2e-05	90	90	90	0	0	1	-360	360	-7.7220	-2.5650	7.7222	2.5557	0.0000	0.0000	0.0000	0.0000;
	894	1413	0.018182	0.044628	0.004898	120	120	120	0	0	1	-360	360	9.3763	5.4493	-9.3575	-5.9731	0.0000	0.0000	0.0000	0.0000;
	1864	894	0.026033	0.063636	0.007047	120	120	120	0	0	1	-360	360	17.3016	5.2675	-17.2287	-5.9179	0.0000	0.0000	0.0000	0.0000;
	894	892	0.013884	0.018017	0.003231	90	90	90	0	0	1	-360	360	7.8524	0.4686	-7.8450	-0.8360	0.0000	0.0000	0.0000	0.0000;
	1263	1414	0.017355	0.048265	0.005145	120	120	120	0	0	1	-360	360	11.6955	5.4710	-11.6702	-5.9962	0.0000	0.0000	0.0000	0.0000;
	1563	1205	0.00686	0.022231	0.002331	140	140	140	0	0	1	-360	360	41.0044	1.3812	-40.9050	-1.3291	0.0000	0.0000	0.0000	0.0000;
	1053	1563	0.004298	0.013388	0.001488	140	140	140	0	0	1	-360	360	41.0667	1.1482	-41.0044	-1.1276	0.0000	0.0000	0.0000	0.0000;
	1350	1053	0.005785	0.017686	0.002079	140	140	140	0	0	1	-360	360	45.0917	2.4786	-44.9910	-2.4136	0.0000	0.0000	0.0000	0.0000;
	1562	1563	0.006033	0.01843	0.002183	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.2536	0.0000	0.0000	0.0000	0.0000;
	1053	1052	0.002314	0.002893	0.000549	90	90	90	0	0	1	-360	360	3.9243	1.2654	-3.9240	-1.3290	0.0000	0.0000	0.0000	0.0000;
	1714	972	0.005041	0.015372	0.001774	140	140	140	0	0	1	-360	360	-1.2798	-3.7176	1.2804	3.5009	0.0000	0.0000	0.0000	0.0000;
	1352	1714	0.010248	0.031405	0.003628	140	140	140	0	0	1	-360	360	8.1269	-1.8031	-8.1212	1.3737	0.0000	0.0000	0.0000	0.0000;
	1714	1712	0.005124	0.008595	0.000908	90	90	90	0	0	1	-360	360	9.4009	2.3439	-9.3970	-2.4490	0.0000	0.0000	0.0000	0.0000;
	1715	973	0.005041	0.015372	0.001774	140	140	140	0	0	1	-360	360	11.9167	-3.5271	-11.9104	3.3281	0.0000	0.0000	0.0000	0.0000;
	1352	1715	0.010248	0.031405	0.003628	140	140	140	0	0	1	-360	360	16.6913	-2.5743	-16.6677	2.2001	0.0000	0.0000	0.0000	0.0000;
	1715	1713	0.005124	0.008512	0.0009	90	90	90	0	0	1	-360	360	4.7510	1.3270	-4.7500	-1.4360	0.0000	0.0000	0.0000	0.0000;
	1893	1363	0.040165	0.070165	0.007071	90	90	90	0	0	1	-360	360	4.0373	0.4408	-4.0313	-1.2335	0.0000	0.0000	0.0000	0.0000;
	1677	1306	0.022479	0.06562	0.006333	120	120	120	0	0	1	-360	360	36.8044	-7.1564	-36.5416	7.1671	0.0000	0.0000	0.0000	0.0000;
	1676	1856	0.01876	0.055372	0.005322	84	84	84	0	0	1	-360	360	50.5299	-7.2809	-50.1222	7.8498	0.0000	0.0000	0.0000	0.0000;
	1320	1179	0.014628	0.045868	0.005084	140	140	140	0	0	1	-360	360	22.7524	-12.7945	-22.6720	12.4218	0.0000	0.0000	0.0000	0.0000;
	1593	1320	0.006281	0.019752	0.002183	140	140	140	0	0	1	-360	360	22.7876	-13.0588	-22.7524	12.9022	0.0000	0.0000	0.0000	0.0000;
	1320	1318	0.00438	0.00843	0.000879	90	90	90	0	0	1	-360	360	0.0000	-0.1077	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1321	925	0.006281	0.019504	0.002217	140	140	140	0	0	1	-360	360	-14.4020	6.5032	14.4152	-6.7279	0.0000	0.0000	0.0000	0.0000;
	1769	1321	0.005041	0.015454	0.001793	140	140	140	0	0	1	-360	360	-14.3916	6.2147	14.4020	-6.3979	0.0000	0.0000	0.0000	0.0000;
	1321	1319	0.00438	0.00843	0.000879	90	90	90	0	0	1	-360	360	0.0000	-0.1053	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1352	836	0.012479	0.045207	0.00537	114	114	114	0	0	1	-360	360	0.0000	-0.6617	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1351	837	0.012479	0.045207	0.00537	114	114	114	0	0	1	-360	360	1.0671	-0.3614	-1.0670	-0.2790	0.0000	0.0000	0.0000	0.0000;
	1422	1004	0.002231	0.008347	0.000983	162	162	162	0	0	1	-360	360	-13.5127	-4.4746	13.5164	4.3668	0.0000	0.0000	0.0000	0.0000;
	989	1005	0.004132	0.01562	0.001878	162	162	162	0	0	1	-360	360	-9.0146	-3.9996	9.0178	3.7798	0.0000	0.0000	0.0000	0.0000;
	1352	989	0.004876	0.016446	0.00198	140	140	140	0	0	1	-360	360	-9.0107	-4.2241	9.0146	3.9930	0.0000	0.0000	0.0000	0.0000;
	989	988	0.00124	0.004463	0.000554	162	162	162	0	0	1	-360	360	0.0000	0.0066	0.0000	-0.0750	0.0000	0.0000	0.0000	0.0000;
	1396	1232	0.005537	0.017355	0.001919	140	140	140	0	0	1	-360	360	-23.0917	-8.6642	23.1199	8.5237	0.0000	0.0000	0.0000	0.0000;
	1464	1336	0.04157	0.060826	0.010346	90	90	90	0	0	1	-360	360	29.4580	-3.1151	-29.1390	2.4143	0.0000	0.0000	0.0000	0.0000;
	1495	1786	0.003967	0.011983	0.001421	140	140	140	0	0	1	-360	360	20.2074	0.9606	-20.1939	-1.0897	0.0000	0.0000	0.0000	0.0000;
	1670	1868	0.015868	0.048016	0.005704	114	114	114	0	0	1	-360	360	38.1136	5.0155	-37.9064	-5.0309	0.0000	0.0000	0.0000	0.0000;
	1007	1670	0.02157	0.065454	0.007771	114	114	114	0	0	1	-360	360	38.3936	4.8765	-38.1136	-4.9174	0.0000	0.0000	0.0000	0.0000;
	1669	1670	0.002397	0.007273	0.000864	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0980	0.0000	0.0000	0.0000	0.0000;
	1441	1774	0.002397	0.007355	0.000852	140	140	140	0	0	1	-360	360	26.0092	2.9420	-25.9955	-3.0022	0.0000	0.0000	0.0000	0.0000;
	1386	1292	0.010496	0.031901	0.003782	114	114	114	0	0	1	-360	360	36.3842	-5.4658	-36.2639	5.3866	0.0000	0.0000	0.0000	0.0000;
	1221	1450	0.024793	0.041322	0.004259	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1065	987	0.010826	0.023967	0.003364	114	114	114	0	0	1	-360	360	31.1040	-1.0476	-31.0175	0.8328	0.0000	0.0000	0.0000	0.0000;
	1749	1503	0.008347	0.024959	0.003015	114	114	114	0	0	1	-360	360	-32.9429	0.8354	33.0204	-0.9575	0.0000	0.0000	0.0000	0.0000;
	1116	1433	0.024793	0.083471	0.010285	114	114	114	0	0	1	-360	360	-44.8804	-15.3985	45.3692	15.8535	0.0000	0.0000	0.0000	0.0000;
	1498	1433	0.034876	0.093058	0.01232	120	120	120	0	0	1	-360	360	-19.3552	-3.9479	19.4708	2.8128	0.0000	0.0000	0.0000	0.0000;
	1591	1312	0.008182	0.014628	0.00304	120	120	120	0	0	1	-360	360	39.1235	5.8541	-39.0178	-6.0324	0.0000	0.0000	0.0000	0.0000;
	1753	959	0.056033	0.074711	0.007168	75	75	75	0	0	1	-360	360	-11.0478	-1.5290	11.1085	0.7884	0.0000	0.0000	0.0000	0.0000;
	1753	1331	0.038265	0.051984	0.004753	57	57	57	0	0	1	-360	360	33.8402	0.1796	-33.4554	-0.1920	0.0000	0.0000	0.0000	0.0000;
	1335	1246	0.029256	0.050826	0.004973	90	90	90	0	0	1	-360	360	-0.6739	-2.6621	0.6754	2.0727	0.0000	0.0000	0.0000	0.0000;
	1894	1001	0.019752	0.05124	0.005878	90	90	90	0	0	1	-360	360	30.4643	1.8398	-30.3102	-2.1389	0.0000	0.0000	0.0000	0.0000;
	1484	1266	0.021818	0.065702	0.007795	90	90	90	0	0	1	-360	360	7.0969	0.2732	-7.0873	-1.1501	0.0000	0.0000	0.0000	0.0000;
	1571	1266	0.036281	0.070579	0.007366	90	90	90	0	0	1	-360	360	-7.1610	8.2528	7.2004	-9.0331	0.0000	0.0000	0.0000	0.0000;
	1808	1012	0.019917	0.060579	0.007124	114	114	114	0	0	1	-360	360	31.7428	2.4774	-31.5778	-2.8441	0.0000	0.0000	0.0000	0.0000;
	1210	1010	0.007769	0.023719	0.002798	140	140	140	0	0	1	-360	360	4.5037	-3.5874	-4.5017	3.2519	0.0000	0.0000	0.0000	0.0000;
	844	1809	0.047603	0.060165	0.005242	60	60	60	0	0	1	-360	360	-2.3660	-0.7410	2.3682	0.0999	0.0000	0.0000	0.0000	0.0000;
	1010	1693	0.052479	0.129917	0.014394	114	114	114	0	0	1	-360	360	40.0590	-6.4163	-39.3566	6.4147	0.0000	0.0000	0.0000	0.0000;
	1891	936	0.032645	0.079091	0.009402	114	114	114	0	0	1	-360	360	13.6417	-10.8989	-13.5613	9.9720	0.0000	0.0000	0.0000	0.0000;
	875	1214	0.023719	0.033388	0.00589	90	90	90	0	0	1	-360	360	20.7637	-6.8876	-20.6627	6.3753	0.0000	0.0000	0.0000	0.0000;
	1174	1717	0.008264	0.026364	0.002848	140	140	140	0	0	1	-360	360	-24.4146	4.0334	24.4560	-4.2511	0.0000	0.0000	0.0000	0.0000;
	1010	1174	0.019917	0.063884	0.00674	114	114	114	0	0	1	-360	360	-23.8453	3.5616	23.9406	-4.0810	0.0000	0.0000	0.0000	0.0000;
	1173	1174	0.000992	0.003141	0.00037	114	114	114	0	0	1	-360	360	-0.4740	-0.0930	0.4740	0.0476	0.0000	0.0000	0.0000	0.0000;
	1693	1223	0.013554	0.040992	0.004864	114	114	114	0	0	1	-360	360	19.9246	13.5925	-19.8578	-13.9685	0.0000	0.0000	0.0000	0.0000;
	1207	967	0.005372	0.017025	0.001861	114	114	114	0	0	1	-360	360	11.1374	2.0525	-11.1317	-2.2600	0.0000	0.0000	0.0000	0.0000;
	1488	1648	0.020248	0.067934	0.006556	114	114	114	0	0	1	-360	360	11.8035	-2.5973	-11.7780	1.9305	0.0000	0.0000	0.0000	0.0000;
	1741	1810	0.037273	0.119504	0.012681	114	114	114	0	0	1	-360	360	-28.5489	-4.5683	28.8276	4.0343	0.0000	0.0000	0.0000	0.0000;
	1742	957	0.01876	0.059339	0.006437	114	114	114	0	0	1	-360	360	-25.3606	-3.0606	25.4705	2.6897	0.0000	0.0000	0.0000	0.0000;
	1557	1387	0.015868	0.053554	0.005135	114	114	114	0	0	1	-360	360	-24.5061	-2.5436	24.5884	2.2186	0.0000	0.0000	0.0000	0.0000;
	1208	880	0.006777	0.021488	0.002343	114	114	114	0	0	1	-360	360	-11.2565	-2.1464	11.2638	1.8851	0.0000	0.0000	0.0000	0.0000;
	1200	881	0.015372	0.048926	0.005234	114	114	114	0	0	1	-360	360	9.5106	1.0459	-9.4989	-1.6461	0.0000	0.0000	0.0000	0.0000;
	1871	880	0.00686	0.021901	0.002331	114	114	114	0	0	1	-360	360	-0.8310	-0.5600	0.8310	0.2769	0.0000	0.0000	0.0000	0.0000;
	1872	881	0.00686	0.021901	0.002335	114	114	114	0	0	1	-360	360	-2.9680	-2.3320	2.9688	2.0508	0.0000	0.0000	0.0000	0.0000;
	1752	1796	0.053058	0.227273	0.025112	162	162	162	0	0	1	-360	360	-24.6345	-3.8553	24.9260	2.2514	0.0000	0.0000	0.0000	0.0000;
	1075	1795	0.049174	0.21124	0.023334	114	114	114	0	0	1	-360	360	-22.0483	-5.0003	22.2683	3.2924	0.0000	0.0000	0.0000	0.0000;
	1546	1429	0.034298	0.10595	0.011374	114	114	114	0	0	1	-360	360	41.6350	10.6928	-41.0929	-10.3295	0.0000	0.0000	0.0000	0.0000;
	1124	1099	0.000496	0.000909	7.7e-05	90	90	90	0	0	1	-360	360	1.0004	3.1979	-1.0003	-3.2071	0.0000	0.0000	0.0000	0.0000;
	1128	1124	0.004132	0.007107	0.000692	90	90	90	0	0	1	-360	360	1.0007	3.0925	-1.0004	-3.1747	0.0000	0.0000	0.0000	0.0000;
	1863	1128	0.004132	0.006942	0.000721	90	90	90	0	0	1	-360	360	1.0011	3.0033	-1.0007	-3.0891	0.0000	0.0000	0.0000	0.0000;
	1122	1124	0.001157	0.002149	0.000194	90	90	90	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0232	0.0000	0.0000	0.0000	0.0000;
	1126	1128	8.3e-05	0.000248	2.9e-05	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0035	0.0000	0.0000	0.0000	0.0000;
	982	851	0.017355	0.050165	0.006278	114	114	114	0	0	1	-360	360	19.2565	-0.3258	-19.2031	-0.2739	0.0000	0.0000	0.0000	0.0000;
	1261	1233	0.024546	0.061488	0.006486	76	76	76	0	0	1	-360	360	15.2913	0.3489	-15.2434	-1.0045	0.0000	0.0000	0.0000	0.0000;
	1364	1134	0.026612	0.041322	0.006396	90	90	90	0	0	1	-360	360	-26.1869	-0.7997	26.3479	0.3200	0.0000	0.0000	0.0000	0.0000;
	1863	1203	0.031653	0.061735	0.011805	120	120	120	0	0	1	-360	360	32.5629	-2.2652	-32.2821	1.4099	0.0000	0.0000	0.0000	0.0000;
	1864	1133	0.045455	0.05686	0.010803	90	90	90	0	0	1	-360	360	36.6171	2.1489	-36.0994	-2.7610	0.0000	0.0000	0.0000	0.0000;
	1241	850	0.002975	0.009504	0.000997	114	114	114	0	0	1	-360	360	-3.4338	-2.2989	3.4343	2.1808	0.0000	0.0000	0.0000	0.0000;
	1511	1261	0.013471	0.043306	0.004559	114	114	114	0	0	1	-360	360	-12.7314	-9.5272	12.7595	9.0728	0.0000	0.0000	0.0000	0.0000;
	899	1233	0.008926	0.024793	0.002756	140	140	140	0	0	1	-360	360	6.4023	3.2474	-6.3983	-3.5654	0.0000	0.0000	0.0000	0.0000;
	1278	1204	0.020413	0.039752	0.007577	120	120	120	0	0	1	-360	360	-27.5115	1.9963	27.6445	-2.6273	0.0000	0.0000	0.0000	0.0000;
	1613	1129	8.3e-05	0.000826	7e-06	90	90	90	0	0	1	-360	360	-6.2850	0.5104	6.2850	-0.5110	0.0000	0.0000	0.0000	0.0000;
	1864	1613	0.006529	0.010992	0.001128	90	90	90	0	0	1	-360	360	0.7254	2.0436	-0.7251	-2.1767	0.0000	0.0000	0.0000	0.0000;
	1613	1612	0.000165	0.000248	2.4e-05	90	90	90	0	0	1	-360	360	7.0101	1.6662	-7.0100	-1.6690	0.0000	0.0000	0.0000	0.0000;
	1127	1130	0.002562	0.00438	0.000443	90	90	90	0	0	1	-360	360	3.8023	0.2205	-3.8020	-0.2730	0.0000	0.0000	0.0000	0.0000;
	1863	1127	0.00405	0.006777	0.000707	90	90	90	0	0	1	-360	360	3.8028	0.1037	-3.8023	-0.1875	0.0000	0.0000	0.0000	0.0000;
	1125	1127	0.000744	0.002314	0.000276	76	76	76	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0330	0.0000	0.0000	0.0000	0.0000;
	1123	851	0.010826	0.021818	0.002998	90	90	90	0	0	1	-360	360	-8.5030	0.9114	8.5097	-1.2570	0.0000	0.0000	0.0000	0.0000;
	1098	1123	0.000413	0.000744	6.8e-05	90	90	90	0	0	1	-360	360	-3.1617	0.9710	3.1617	-0.9791	0.0000	0.0000	0.0000	0.0000;
	1121	1123	0.00124	0.002149	0.000208	90	90	90	0	0	1	-360	360	-5.3410	-0.0920	5.3413	0.0676	0.0000	0.0000	0.0000	0.0000;
	1924	850	0.004545	0.007934	0.000833	90	90	90	0	0	1	-360	360	-3.2060	-1.1660	3.2064	1.0670	0.0000	0.0000	0.0000	0.0000;
	1925	851	0.004545	0.007934	0.000833	90	90	90	0	0	1	-360	360	-17.2350	0.1630	17.2463	-0.2430	0.0000	0.0000	0.0000	0.0000;
	1679	850	0.004132	0.010992	0.001735	114	114	114	0	0	1	-360	360	-31.5369	-4.9365	31.5722	4.8226	0.0000	0.0000	0.0000	0.0000;
	1233	1743	0.006777	0.01124	0.001191	29	29	29	0	0	1	-360	360	5.3537	1.2890	-5.3520	-1.4280	0.0000	0.0000	0.0000	0.0000;
	1234	1744	0.006777	0.01124	0.001191	57	57	57	0	0	1	-360	360	13.2024	2.9065	-13.1920	-3.0310	0.0000	0.0000	0.0000	0.0000;
	1576	1417	0.037025	0.06719	0.006691	90	90	90	0	0	1	-360	360	13.8764	0.6402	-13.8153	-1.3101	0.0000	0.0000	0.0000	0.0000;
	1556	1417	0.014876	0.028099	0.002979	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1875	1418	0.007603	0.011735	0.001496	90	90	90	0	0	1	-360	360	15.3209	3.0193	-15.3049	-3.1686	0.0000	0.0000	0.0000	0.0000;
	1874	1875	0.000992	0.001736	0.000165	90	90	90	0	0	1	-360	360	15.3230	3.0038	-15.3209	-3.0193	0.0000	0.0000	0.0000	0.0000;
	1451	1874	0.006198	0.007769	0.001481	90	90	90	0	0	1	-360	360	15.3359	2.8474	-15.3230	-3.0038	0.0000	0.0000	0.0000	0.0000;
	1556	1875	0.007273	0.014545	0.001549	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1221	1874	0.019008	0.033058	0.003151	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1923	1293	0.019091	0.057769	0.006863	114	114	114	0	0	1	-360	360	-31.3418	6.6136	31.5100	-6.9089	0.0000	0.0000	0.0000	0.0000;
	1863	1132	0.007025	0.015703	0.001757	90	90	90	0	0	1	-360	360	4.9124	1.3208	-4.9108	-1.5277	0.0000	0.0000	0.0000	0.0000;
	1131	850	0.010826	0.032727	0.003884	114	114	114	0	0	1	-360	360	-9.3412	0.5445	9.3491	-0.9856	0.0000	0.0000	0.0000	0.0000;
	1626	851	0.008595	0.026033	0.00309	114	114	114	0	0	1	-360	360	-15.1220	-1.5481	15.1386	1.2286	0.0000	0.0000	0.0000	0.0000;
	1692	1277	0.028347	0.06595	0.009854	120	120	120	0	0	1	-360	360	-6.4000	1.4145	6.4109	-2.5416	0.0000	0.0000	0.0000	0.0000;
	1922	1692	0.008595	0.026033	0.003095	114	114	114	0	0	1	-360	360	28.0150	-6.9318	-27.9540	6.7545	0.0000	0.0000	0.0000	0.0000;
	1691	1672	0.015703	0.047686	0.005665	114	114	114	0	0	1	-360	360	3.5397	0.7378	-3.5379	-1.3939	0.0000	0.0000	0.0000	0.0000;
	1723	1485	0.014711	0.02595	0.002841	57	57	57	0	0	1	-360	360	16.1700	0.4448	-16.1370	-0.7181	0.0000	0.0000	0.0000	0.0000;
	1884	1262	0.003058	0.00843	0.001447	114	114	114	0	0	1	-360	360	-17.3980	-0.0205	17.4058	-0.1319	0.0000	0.0000	0.0000	0.0000;
	1363	1310	0.011901	0.036116	0.004264	114	114	114	0	0	1	-360	360	8.4516	0.5912	-8.4441	-1.0511	0.0000	0.0000	0.0000	0.0000;
	1311	893	0.008843	0.026777	0.003178	114	114	114	0	0	1	-360	360	3.6841	0.1070	-3.6830	-0.4630	0.0000	0.0000	0.0000	0.0000;
	1722	1000	0.026777	0.063223	0.007267	57	57	57	0	0	1	-360	360	-20.5802	-1.6467	20.6775	1.0224	0.0000	0.0000	0.0000	0.0000;
	1570	1510	0.031983	0.102397	0.010846	114	114	114	0	0	1	-360	360	-4.4921	-9.7167	4.5202	8.5294	0.0000	0.0000	0.0000	0.0000;
	1262	1211	0.036116	0.11595	0.012221	114	114	114	0	0	1	-360	360	5.8915	-1.0339	-5.8811	-0.3973	0.0000	0.0000	0.0000	0.0000;
	1863	1639	0.023636	0.076942	0.007921	114	114	114	0	0	1	-360	360	3.3240	0.6260	-3.3216	-1.5655	0.0000	0.0000	0.0000	0.0000;
	1883	1242	0.02281	0.041818	0.008523	120	120	120	0	0	1	-360	360	4.9188	-1.0506	-4.9142	0.0377	0.0000	0.0000	0.0000	0.0000;
	947	1234	0	0.000826	7e-06	120	120	120	0	0	1	-360	360	5.4484	4.1474	-5.4484	-4.1480	0.0000	0.0000	0.0000	0.0000;
	1863	947	0.009504	0.03	0.003308	120	120	120	0	0	1	-360	360	13.3262	5.4142	-13.3096	-5.7571	0.0000	0.0000	0.0000	0.0000;
	946	947	0.009504	0.032231	0.003073	140	140	140	0	0	1	-360	360	-7.8560	-1.9580	7.8612	1.6097	0.0000	0.0000	0.0000	0.0000;
	1863	898	0.004298	0.013471	0.001493	114	114	114	0	0	1	-360	360	16.8949	5.5827	-16.8835	-5.7256	0.0000	0.0000	0.0000	0.0000;
	1264	1864	0.040579	0.104959	0.011437	120	120	120	0	0	1	-360	360	-12.6457	-5.7484	12.7105	4.5739	0.0000	0.0000	0.0000	0.0000;
	1864	1577	0.017521	0.031983	0.00311	90	90	90	0	0	1	-360	360	27.0987	2.5523	-26.9889	-2.7183	0.0000	0.0000	0.0000	0.0000;
	1642	1627	0.003141	0.009504	0.001125	114	114	114	0	0	1	-360	360	-4.7624	0.5935	4.7630	-0.7261	0.0000	0.0000	0.0000	0.0000;
	1640	1642	0	0.000826	1e-05	114	114	114	0	0	1	-360	360	-4.7624	0.5914	4.7624	-0.5924	0.0000	0.0000	0.0000	0.0000;
	1641	1642	0	0.000826	1e-05	114	114	114	0	0	1	-360	360	0.0000	-0.0000	-0.0000	-0.0012	0.0000	0.0000	0.0000	0.0000;
	1234	1678	0.005537	0.013967	0.002464	114	114	114	0	0	1	-360	360	-17.9701	-1.9132	17.9852	1.6574	0.0000	0.0000	0.0000	0.0000;
	1450	1556	0.002149	0.006033	0.000632	90	90	90	0	0	1	-360	360	-15.5741	-3.0921	15.5787	3.0314	0.0000	0.0000	0.0000	0.0000;
	954	850	0.005455	0.017521	0.001847	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.2212	0.0000	0.0000	0.0000	0.0000;
	955	851	0.004959	0.017521	0.001847	114	114	114	0	0	1	-360	360	-3.5610	-0.0000	3.5615	-0.2193	0.0000	0.0000	0.0000	0.0000;
	1247	930	0.019008	0.060413	0.006548	114	114	114	0	0	1	-360	360	13.6571	3.4032	-13.6248	-4.0719	0.0000	0.0000	0.0000	0.0000;
	1907	929	0.005041	0.015289	0.001815	114	114	114	0	0	1	-360	360	10.5164	2.2887	-10.5114	-2.4866	0.0000	0.0000	0.0000	0.0000;
	1248	847	0.014215	0.025041	0.002563	90	90	90	0	0	1	-360	360	9.8607	0.9025	-9.8489	-1.1843	0.0000	0.0000	0.0000	0.0000;
	931	1698	0.02157	0.068265	0.007163	114	114	114	0	0	1	-360	360	23.1309	10.1820	-23.0130	-10.6495	0.0000	0.0000	0.0000	0.0000;
	1284	1220	0.015454	0.052066	0.004997	114	114	114	0	0	1	-360	360	-1.8212	-0.8408	1.8217	0.2437	0.0000	0.0000	0.0000	0.0000;
	1824	1284	0.012645	0.030248	0.004257	114	114	114	0	0	1	-360	360	-23.7670	2.4788	23.8277	-2.8424	0.0000	0.0000	0.0000	0.0000;
	1044	932	0.002727	0.007438	0.000806	114	114	114	0	0	1	-360	360	42.9071	14.1741	-42.8603	-14.1422	0.0000	0.0000	0.0000	0.0000;
	1665	1021	0.025372	0.042231	0.00635	90	90	90	0	0	1	-360	360	-33.0660	-6.5455	33.3085	6.1902	0.0000	0.0000	0.0000	0.0000;
	1876	1430	0.001488	0.004793	0.000494	114	114	114	0	0	1	-360	360	-34.4658	-13.9979	34.4841	14.0012	0.0000	0.0000	0.0000	0.0000;
	1817	1876	0.013223	0.031322	0.003403	90	90	90	0	0	1	-360	360	31.1016	12.9409	-30.9695	-13.0135	0.0000	0.0000	0.0000	0.0000;
	1698	1816	0.008182	0.025041	0.002943	114	114	114	0	0	1	-360	360	59.9583	20.0593	-59.6762	-19.5346	0.0000	0.0000	0.0000	0.0000;
	1930	1728	0.009008	0.015041	0.001619	90	90	90	0	0	1	-360	360	24.0631	5.5468	-24.0153	-5.6527	0.0000	0.0000	0.0000	0.0000;
	1409	1313	0.003306	0.007934	0.000903	120	120	120	0	0	1	-360	360	-30.6800	-2.8148	30.7061	2.7688	0.0000	0.0000	0.0000	0.0000;
	1427	842	0.004711	0.014215	0.001689	114	114	114	0	0	1	-360	360	13.4577	11.4474	-13.4453	-11.6123	0.0000	0.0000	0.0000	0.0000;
	1045	1411	0.002975	0.007025	0.000992	114	114	114	0	0	1	-360	360	-52.5972	-16.1441	52.6728	16.2043	0.0000	0.0000	0.0000	0.0000;
	1718	1285	0.015868	0.042645	0.004371	114	114	114	0	0	1	-360	360	-38.1863	-7.1985	38.3877	7.2173	0.0000	0.0000	0.0000	0.0000;
	1750	1697	0.026116	0.033802	0.0062	90	90	90	0	0	1	-360	360	20.6726	-2.6564	-20.5761	2.0584	0.0000	0.0000	0.0000	0.0000;
	1825	843	0.004132	0.012479	0.001484	114	114	114	0	0	1	-360	360	2.1780	-7.8552	-2.1757	7.6849	0.0000	0.0000	0.0000	0.0000;
	1022	1285	0.008595	0.026529	0.003035	114	114	114	0	0	1	-360	360	-40.6101	15.7460	40.7457	-15.6933	0.0000	0.0000	0.0000	0.0000;
	1497	1698	0.00281	0.009008	0.000975	114	114	114	0	0	1	-360	360	5.5599	1.0832	-5.5591	-1.1939	0.0000	0.0000	0.0000	0.0000;
	1219	1572	0.010331	0.032314	0.003596	114	114	114	0	0	1	-360	360	-3.8877	-0.8308	3.8890	0.4037	0.0000	0.0000	0.0000	0.0000;
	1892	1011	0.020579	0.051488	0.006086	114	114	114	0	0	1	-360	360	-25.0542	8.8620	25.1775	-9.2775	0.0000	0.0000	0.0000	0.0000;
	1239	1011	0.004628	0.008347	0.001747	114	114	114	0	0	1	-360	360	-35.3630	-5.7773	35.4130	5.6600	0.0000	0.0000	0.0000	0.0000;
	1819	1573	0.019174	0.06157	0.00651	114	114	114	0	0	1	-360	360	-20.1017	-5.6868	20.1716	5.1352	0.0000	0.0000	0.0000	0.0000;
	849	1819	0.018017	0.023884	0.004291	90	90	90	0	0	1	-360	360	-10.6283	-3.5179	10.6472	3.0357	0.0000	0.0000	0.0000	0.0000;
	1818	1819	0.006694	0.008347	0.001585	29	29	29	0	0	1	-360	360	-9.4490	-2.8320	9.4545	2.6511	0.0000	0.0000	0.0000	0.0000;
	1889	1224	0.017025	0.051984	0.00611	114	114	114	0	0	1	-360	360	-6.7334	-10.7273	6.7557	10.0785	0.0000	0.0000	0.0000	0.0000;
	1756	1889	0.040909	0.053884	0.009864	90	90	90	0	0	1	-360	360	-42.5639	-8.2844	43.2458	8.0534	0.0000	0.0000	0.0000	0.0000;
	1609	1284	0.006612	0.020661	0.002331	114	114	114	0	0	1	-360	360	8.4488	0.8224	-8.4448	-1.0891	0.0000	0.0000	0.0000	0.0000;
	1930	1284	0.025124	0.076198	0.009039	114	114	114	0	0	1	-360	360	-56.1221	-11.6708	56.8372	12.7785	0.0000	0.0000	0.0000	0.0000;
	1846	1817	0.01438	0.046198	0.004867	114	114	114	0	0	1	-360	360	-10.2800	-2.8400	10.2942	2.3316	0.0000	0.0000	0.0000	0.0000;
	1610	1931	0.02876	0.090165	0.010016	114	114	114	0	0	1	-360	360	-20.8504	-5.9671	20.9663	5.1673	0.0000	0.0000	0.0000	0.0000;
	1284	1024	0.002645	0.008017	0.000949	114	114	114	0	0	1	-360	360	0.0000	-0.1136	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1666	1931	0.019587	0.03124	0.005114	90	90	90	0	0	1	-360	360	21.0437	4.6882	-20.9663	-5.1673	0.0000	0.0000	0.0000	0.0000;
	1248	1719	0.003719	0.009835	0.00098	114	114	114	0	0	1	-360	360	-32.0381	-6.0898	32.0715	6.0621	0.0000	0.0000	0.0000	0.0000;
	1890	1572	0.024215	0.076859	0.008327	114	114	114	0	0	1	-360	360	-56.6727	-2.8238	57.3403	3.9577	0.0000	0.0000	0.0000	0.0000;
	1012	1572	0.007686	0.024711	0.002594	114	114	114	0	0	1	-360	360	49.7190	7.4542	-49.5584	-7.2506	0.0000	0.0000	0.0000	0.0000;
	1011	1573	0.007686	0.024711	0.002594	114	114	114	0	0	1	-360	360	-37.1078	-7.0137	37.1998	6.9994	0.0000	0.0000	0.0000	0.0000;
	1247	1572	0.019256	0.061983	0.006515	114	114	114	0	0	1	-360	360	-21.2351	-7.3875	21.3165	6.8735	0.0000	0.0000	0.0000	0.0000;
	1429	1115	0.002975	0.013058	0.002154	114	114	114	0	0	1	-360	360	-26.3555	-13.7805	26.3788	13.6391	0.0000	0.0000	0.0000	0.0000;
	1023	1428	0.00405	0.011653	0.00129	114	114	114	0	0	1	-360	360	32.5152	15.4696	-32.4716	-15.4993	0.0000	0.0000	0.0000	0.0000;
	1836	1729	0.020331	0.065372	0.006902	114	114	114	0	0	1	-360	360	-4.2159	-1.3217	4.2192	0.5436	0.0000	0.0000	0.0000	0.0000;
	1410	1608	0.005124	0.015868	0.00181	114	114	114	0	0	1	-360	360	23.0586	1.4501	-23.0359	-1.5969	0.0000	0.0000	0.0000	0.0000;
	1835	1611	0.01562	0.050248	0.005283	114	114	114	0	0	1	-360	360	-14.6911	-4.6425	14.7232	4.1405	0.0000	0.0000	0.0000	0.0000;
	1240	1908	0.017355	0.024711	0.004378	90	90	90	0	0	1	-360	360	26.2825	3.8884	-26.1788	-4.2576	0.0000	0.0000	0.0000	0.0000;
	1412	1285	0.002893	0.009256	0.000997	114	114	114	0	0	1	-360	360	-74.1820	-22.2047	74.3269	22.5487	0.0000	0.0000	0.0000	0.0000;
	1697	1284	0.021984	0.070909	0.007446	114	114	114	0	0	1	-360	360	-30.3098	-16.0118	30.5297	15.8427	0.0000	0.0000	0.0000	0.0000;
	1755	875	0.016364	0.02157	0.003969	90	90	90	0	0	1	-360	360	31.6795	-3.5134	-31.5317	3.2646	0.0000	0.0000	0.0000	0.0000;
	1012	1382	0.008843	0.028017	0.00303	114	114	114	0	0	1	-360	360	4.2428	-0.6591	-4.2415	0.2965	0.0000	0.0000	0.0000	0.0000;
	1383	966	0.004793	0.014959	0.001658	114	114	114	0	0	1	-360	360	0.0485	-1.5455	-0.0484	1.3451	0.0000	0.0000	0.0000	0.0000;
	1285	986	0.017934	0.044876	0.005385	114	114	114	0	0	1	-360	360	-15.3970	5.7798	15.4378	-6.3264	0.0000	0.0000	0.0000	0.0000;
	941	1003	0.013471	0.042645	0.004646	140	140	140	0	0	1	-360	360	-6.6173	2.6508	6.6231	-3.1982	0.0000	0.0000	0.0000	0.0000;
	964	941	8.3e-05	0.000248	2.4e-05	114	114	114	0	0	1	-360	360	6.4495	5.0763	-6.4494	-5.0791	0.0000	0.0000	0.0000	0.0000;
	939	941	0.004628	0.014132	0.00167	114	114	114	0	0	1	-360	360	-13.0600	-2.6110	13.0667	2.4283	0.0000	0.0000	0.0000	0.0000;
	1643	1334	0.040248	0.070579	0.006735	90	90	90	0	0	1	-360	360	9.4716	-1.3811	-9.4411	0.6319	0.0000	0.0000	0.0000	0.0000;
	949	1643	0.019669	0.040579	0.003599	90	90	90	0	0	1	-360	360	-68.9393	-8.9998	69.7584	10.2658	0.0000	0.0000	0.0000	0.0000;
	1540	949	0.006942	0.018678	0.001767	90	90	90	0	0	1	-360	360	-64.2809	-7.2389	64.5338	7.7155	0.0000	0.0000	0.0000	0.0000;
	1597	1540	0.000661	0.001157	0.000169	90	90	90	0	0	1	-360	360	-64.2568	-7.2212	64.2809	7.2439	0.0000	0.0000	0.0000	0.0000;
	948	949	0.002727	0.003636	0.000322	75	75	75	0	0	1	-360	360	-4.4050	-1.3210	4.4055	1.2843	0.0000	0.0000	0.0000	0.0000;
	1538	1540	0.000165	0.000496	4.4e-05	140	140	140	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0050	0.0000	0.0000	0.0000	0.0000;
	1483	1064	0.002149	0.006612	0.000779	114	114	114	0	0	1	-360	360	36.7126	0.1526	-36.6887	-0.1736	0.0000	0.0000	0.0000	0.0000;
	1759	1362	0.012562	0.045041	0.004371	114	114	114	0	0	1	-360	360	-71.8242	-16.4109	72.3848	17.8828	0.0000	0.0000	0.0000	0.0000;
	1873	918	0.01	0.025124	0.002819	120	120	120	0	0	1	-360	360	28.2865	9.4214	-28.2123	-9.5721	0.0000	0.0000	0.0000	0.0000;
	1896	1873	0.005868	0.020909	0.002072	140	140	140	0	0	1	-360	360	52.2469	15.0412	-52.1039	-14.7815	0.0000	0.0000	0.0000	0.0000;
	1917	1873	8.3e-05	0.000331	3.6e-05	140	140	140	0	0	1	-360	360	-23.8169	-5.3628	23.8173	5.3601	0.0000	0.0000	0.0000	0.0000;
	861	1917	0.000331	0.000992	0.000121	114	114	114	0	0	1	-360	360	-19.0620	-4.9400	19.0631	4.9287	0.0000	0.0000	0.0000	0.0000;
	1915	1917	0.004463	0.013636	0.001619	140	140	140	0	0	1	-360	360	-4.7530	-0.6260	4.7538	0.4341	0.0000	0.0000	0.0000	0.0000;
	852	1112	0.013967	0.043388	0.004898	140	140	140	0	0	1	-360	360	-33.3436	-6.5066	33.4765	6.3243	0.0000	0.0000	0.0000	0.0000;
	1590	1286	0.02281	0.063967	0.009043	140	140	140	0	0	1	-360	360	-56.0279	-10.3644	56.6365	10.9566	0.0000	0.0000	0.0000	0.0000;
	1434	1548	0.006694	0.017273	0.002389	120	120	120	0	0	1	-360	360	19.1880	-7.2506	-19.1643	7.0287	0.0000	0.0000	0.0000	0.0000;
	1434	1193	0.004545	0.013967	0.001283	120	120	120	0	0	1	-360	360	-7.3993	2.9196	7.4017	-3.0640	0.0000	0.0000	0.0000	0.0000;
	1194	918	0.005702	0.01719	0.002118	140	140	140	0	0	1	-360	360	-25.2103	-9.7181	25.2453	9.5721	0.0000	0.0000	0.0000	0.0000;
	1855	1433	0.013636	0.033967	0.003707	120	120	120	0	0	1	-360	360	-7.2615	-5.0790	7.2703	4.6639	0.0000	0.0000	0.0000	0.0000;
	1433	1545	0.008595	0.021405	0.002282	120	120	120	0	0	1	-360	360	-4.0478	2.6064	4.0495	-2.8717	0.0000	0.0000	0.0000	0.0000;
	1199	1544	0.009256	0.022645	0.002543	120	120	120	0	0	1	-360	360	5.2392	-2.6994	-5.2365	2.4055	0.0000	0.0000	0.0000	0.0000;
	1588	1199	0.004876	0.013471	0.001566	120	120	120	0	0	1	-360	360	5.8349	-2.7676	-5.8332	2.5874	0.0000	0.0000	0.0000	0.0000;
	1199	1197	0.000909	0.002066	0.000237	120	120	120	0	0	1	-360	360	0.5940	0.1120	-0.5940	-0.1400	0.0000	0.0000	0.0000	0.0000;
	1434	1185	0.016694	0.045207	0.005467	120	120	120	0	0	1	-360	360	-35.9100	-2.7537	36.0926	2.5963	0.0000	0.0000	0.0000	0.0000;
	1516	1169	0.000826	0.002479	0.000269	114	114	114	0	0	1	-360	360	-76.7778	-13.9214	76.8193	14.0132	0.0000	0.0000	0.0000	0.0000;
	1096	1516	0.002149	0.003884	0.000779	120	120	120	0	0	1	-360	360	-64.8033	-12.9046	64.8808	12.9503	0.0000	0.0000	0.0000	0.0000;
	1184	1096	0.00595	0.010661	0.002222	120	120	120	0	0	1	-360	360	-64.5883	-12.8722	64.8033	12.9898	0.0000	0.0000	0.0000	0.0000;
	1516	1514	0	0.000826	7e-06	114	114	114	0	0	1	-360	360	11.8970	0.9711	-11.8970	-0.9710	0.0000	0.0000	0.0000	0.0000;
	1096	1094	0.002397	0.004876	0.000704	90	90	90	0	0	1	-360	360	0.0000	-0.0852	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1407	1633	0.008926	0.02876	0.003025	114	114	114	0	0	1	-360	360	-29.6947	-5.8951	29.7661	5.7787	0.0000	0.0000	0.0000	0.0000;
	1452	1407	0.004959	0.015868	0.001675	140	140	140	0	0	1	-360	360	-23.0078	-4.4601	23.0317	4.3457	0.0000	0.0000	0.0000	0.0000;
	1405	1407	0.002314	0.003802	0.000404	90	90	90	0	0	1	-360	360	-6.6620	-1.5940	6.6629	1.5494	0.0000	0.0000	0.0000	0.0000;
	1080	1632	0.000826	0.002562	0.000266	114	114	114	0	0	1	-360	360	-49.9329	-12.2567	49.9519	12.2850	0.0000	0.0000	0.0000	0.0000;
	864	1080	0.007934	0.025537	0.002684	140	140	140	0	0	1	-360	360	-35.5543	-7.7950	35.6464	7.7840	0.0000	0.0000	0.0000	0.0000;
	1078	1080	0.000248	0.000661	7.5e-05	114	114	114	0	0	1	-360	360	-14.2860	-4.4800	14.2865	4.4727	0.0000	0.0000	0.0000	0.0000;
	1416	1633	0.008017	0.02438	0.002553	120	120	120	0	0	1	-360	360	26.3561	-13.1250	-26.2959	13.0147	0.0000	0.0000	0.0000	0.0000;
	1415	1632	0.008099	0.025372	0.002633	120	120	120	0	0	1	-360	360	1.9481	-6.8133	-1.9447	6.5213	0.0000	0.0000	0.0000	0.0000;
	1634	1764	0.014463	0.043967	0.005193	114	114	114	0	0	1	-360	360	30.0755	11.6275	-29.9479	-11.8513	0.0000	0.0000	0.0000	0.0000;
	1673	1721	0.010083	0.031901	0.003453	114	114	114	0	0	1	-360	360	39.7982	8.3719	-39.6588	-8.3427	0.0000	0.0000	0.0000	0.0000;
	1189	1231	0.003719	0.011901	0.001251	140	140	140	0	0	1	-360	360	-7.7360	-1.7590	7.7379	1.6111	0.0000	0.0000	0.0000	0.0000;
	1377	1478	0.002231	0.006612	0.000789	114	114	114	0	0	1	-360	360	5.2715	2.6428	-5.2708	-2.7370	0.0000	0.0000	0.0000	0.0000;
	1814	1799	0.009587	0.030744	0.003233	114	114	114	0	0	1	-360	360	-13.6423	-5.9034	13.6596	5.5664	0.0000	0.0000	0.0000	0.0000;
	1437	1622	0.000992	0.003058	0.000346	114	114	114	0	0	1	-360	360	-88.1869	-16.8282	88.2537	16.9928	0.0000	0.0000	0.0000	0.0000;
	1644	1437	0.005785	0.01843	0.001951	114	114	114	0	0	1	-360	360	-66.3573	-9.1570	66.5763	9.6223	0.0000	0.0000	0.0000	0.0000;
	1435	1437	0.000826	0.002397	0.000281	114	114	114	0	0	1	-360	360	-21.6070	-7.2290	21.6106	7.2058	0.0000	0.0000	0.0000	0.0000;
	1841	1643	0.011901	0.036446	0.004262	114	114	114	0	0	1	-360	360	99.2877	20.8577	-98.2930	-18.3287	0.0000	0.0000	0.0000	0.0000;
	1142	944	0.004215	0.013306	0.001433	114	114	114	0	0	1	-360	360	-4.5220	-0.8810	4.5227	0.7141	0.0000	0.0000	0.0000	0.0000;
	1739	1282	0.005207	0.01595	0.001873	140	140	140	0	0	1	-360	360	-20.2240	-5.6550	20.2439	5.4997	0.0000	0.0000	0.0000	0.0000;
	1058	1036	0.005455	0.017107	0.001917	140	140	140	0	0	1	-360	360	-9.6139	-3.9748	9.6188	3.7615	0.0000	0.0000	0.0000	0.0000;
	1881	1476	0.004793	0.014628	0.001774	114	114	114	0	0	1	-360	360	-43.6391	-2.9040	43.7154	2.9229	0.0000	0.0000	0.0000	0.0000;
	992	1881	0.001901	0.006116	0.000646	114	114	114	0	0	1	-360	360	-36.7057	-1.5799	36.7271	1.5710	0.0000	0.0000	0.0000	0.0000;
	1879	1881	8.3e-05	0.000165	1.7e-05	114	114	114	0	0	1	-360	360	-6.9120	-1.3350	6.9120	1.3330	0.0000	0.0000	0.0000	0.0000;
	992	1615	0.001405	0.004132	0.000426	114	114	114	0	0	1	-360	360	27.0817	-0.8911	-27.0732	0.8652	0.0000	0.0000	0.0000	0.0000;
	1436	1622	0.001488	0.004628	0.000549	114	114	114	0	0	1	-360	360	6.8860	6.7600	-6.8848	-6.8223	0.0000	0.0000	0.0000	0.0000;
	937	1368	0.006777	0.021984	0.002297	114	114	114	0	0	1	-360	360	24.9005	4.9828	-24.8645	-5.1449	0.0000	0.0000	0.0000	0.0000;
	1081	1419	0.008099	0.020661	0.002323	120	120	120	0	0	1	-360	360	-3.8976	4.0466	3.8999	-4.3079	0.0000	0.0000	0.0000	0.0000;
	1633	1081	0.000496	0.001488	0.000162	114	114	114	0	0	1	-360	360	-3.8974	3.9894	3.8976	-4.0077	0.0000	0.0000	0.0000	0.0000;
	1081	1079	0.000909	0.002893	0.000339	57	57	57	0	0	1	-360	360	0.0000	-0.0390	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1135	972	0.001736	0.005289	0.000617	57	57	57	0	0	1	-360	360	-4.2740	-1.6790	4.2743	1.6038	0.0000	0.0000	0.0000	0.0000;
	1842	1322	0.012975	0.041074	0.004484	140	140	140	0	0	1	-360	360	8.2354	1.8405	-8.2276	-2.3579	0.0000	0.0000	0.0000	0.0000;
	1568	1740	0.003802	0.012149	0.001275	114	114	114	0	0	1	-360	360	-10.4027	-1.9296	10.4064	1.7967	0.0000	0.0000	0.0000	0.0000;
	1408	1568	0.006694	0.021653	0.002268	140	140	140	0	0	1	-360	360	12.5624	1.7748	-12.5529	-2.0018	0.0000	0.0000	0.0000	0.0000;
	865	1408	0.004463	0.014463	0.001517	114	114	114	0	0	1	-360	360	15.3039	2.3288	-15.2945	-2.4711	0.0000	0.0000	0.0000	0.0000;
	1568	1566	0.001157	0.002562	0.000254	90	90	90	0	0	1	-360	360	22.9555	3.9314	-22.9500	-3.9480	0.0000	0.0000	0.0000	0.0000;
	1406	1408	0.002314	0.003802	0.000404	90	90	90	0	0	1	-360	360	-2.7320	-0.7420	2.7322	0.6963	0.0000	0.0000	0.0000	0.0000;
	1739	1143	0.004463	0.014297	0.001515	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1231	1832	0.003306	0.010744	0.001101	140	140	140	0	0	1	-360	360	5.8290	1.6047	-5.8280	-1.7370	0.0000	0.0000	0.0000	0.0000;
	1231	1031	0.001405	0.004463	0.000469	114	114	114	0	0	1	-360	360	0.0000	-0.0578	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1479	1002	0.002397	0.007273	0.000857	140	140	140	0	0	1	-360	360	5.2708	2.7367	-5.2701	-2.8389	0.0000	0.0000	0.0000	0.0000;
	1842	1472	0.003802	0.01157	0.00137	140	140	140	0	0	1	-360	360	40.2877	13.4596	-40.2310	-13.4523	0.0000	0.0000	0.0000	0.0000;
	1623	1843	0.018347	0.056777	0.006459	114	114	114	0	0	1	-360	360	-49.9043	-6.5194	50.2911	6.9334	0.0000	0.0000	0.0000	0.0000;
	1097	977	0.000992	0.002893	0.000349	140	140	140	0	0	1	-360	360	51.6130	11.9951	-51.5901	-11.9706	0.0000	0.0000	0.0000	0.0000;
	1517	1097	0.001488	0.004463	0.00053	140	140	140	0	0	1	-360	360	51.6474	11.9776	-51.6130	-11.9390	0.0000	0.0000	0.0000	0.0000;
	1843	1517	0.004298	0.013388	0.001474	140	140	140	0	0	1	-360	360	51.7465	12.1055	-51.6474	-11.9767	0.0000	0.0000	0.0000	0.0000;
	1097	1095	0.001322	0.003884	0.000462	140	140	140	0	0	1	-360	360	0.0000	-0.0562	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1515	1517	0	0.000826	7e-06	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0009	0.0000	0.0000	0.0000	0.0000;
	1195	917	0.002727	0.008347	0.000973	140	140	140	0	0	1	-360	360	-7.2880	2.4155	7.2893	-2.5267	0.0000	0.0000	0.0000	0.0000;
	1914	1195	0.002231	0.007603	0.000728	140	140	140	0	0	1	-360	360	-7.2869	2.3329	7.2880	-2.4155	0.0000	0.0000	0.0000	0.0000;
	1911	1914	8.3e-05	0.000165	1.7e-05	140	140	140	0	0	1	-360	360	-7.2868	2.3298	7.2869	-2.3317	0.0000	0.0000	0.0000	0.0000;
	1193	1195	0.003141	0.009669	0.001125	140	140	140	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1913	1914	0	0.000826	1e-05	140	140	140	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0012	0.0000	0.0000	0.0000	0.0000;
	1251	1111	0.001074	0.003388	0.000387	140	140	140	0	0	1	-360	360	-24.2213	-9.7780	24.2274	9.7511	0.0000	0.0000	0.0000	0.0000;
	1839	1251	0.004545	0.013884	0.001614	140	140	140	0	0	1	-360	360	-22.5355	-9.4681	22.5582	9.3454	0.0000	0.0000	0.0000	0.0000;
	1251	1249	0.001157	0.001488	0.000281	90	90	90	0	0	1	-360	360	1.6630	0.4325	-1.6630	-0.4660	0.0000	0.0000	0.0000	0.0000;
	921	1111	0.001074	0.003388	0.000387	140	140	140	0	0	1	-360	360	-43.6176	-17.0785	43.6374	17.0946	0.0000	0.0000	0.0000	0.0000;
	1888	921	0.003884	0.011901	0.001375	114	114	114	0	0	1	-360	360	-36.1959	-15.1587	36.2463	15.1494	0.0000	0.0000	0.0000	0.0000;
	919	921	0.000661	0.001901	0.000225	114	114	114	0	0	1	-360	360	-7.3710	-1.9550	7.3713	1.9291	0.0000	0.0000	0.0000	0.0000;
	1270	1111	0.009339	0.025289	0.002592	120	120	120	0	0	1	-360	360	-19.1642	-5.1213	19.1950	4.8958	0.0000	0.0000	0.0000	0.0000;
	1720	1270	0.005702	0.014545	0.001534	120	120	120	0	0	1	-360	360	-15.7088	-4.5461	15.7216	4.3966	0.0000	0.0000	0.0000	0.0000;
	1270	1267	0.005537	0.009339	0.00097	90	90	90	0	0	1	-360	360	3.4426	0.7247	-3.4420	-0.8390	0.0000	0.0000	0.0000	0.0000;
	1399	1111	0.009339	0.025289	0.002592	120	120	120	0	0	1	-360	360	-17.4640	-4.8225	17.4896	4.5831	0.0000	0.0000	0.0000	0.0000;
	1317	1399	0.005702	0.01438	0.001513	120	120	120	0	0	1	-360	360	-17.4481	-5.0764	17.4640	4.9367	0.0000	0.0000	0.0000	0.0000;
	1721	1317	8.3e-05	0.000248	1.9e-05	140	140	140	0	0	1	-360	360	-5.4569	-1.2604	5.4569	1.2582	0.0000	0.0000	0.0000	0.0000;
	1399	1398	0.005537	0.009256	0.000961	90	90	90	0	0	1	-360	360	0.0000	-0.1142	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1316	1317	0.000165	0.000413	5.3e-05	140	140	140	0	0	1	-360	360	-11.9910	-3.8240	11.9912	3.8182	0.0000	0.0000	0.0000	0.0000;
	1361	1287	0.000496	0.001488	0.000177	140	140	140	0	0	1	-360	360	-67.8983	-17.8445	67.9183	17.8826	0.0000	0.0000	0.0000	0.0000;
	1361	1287	0.000496	0.001488	0.000177	140	140	140	0	0	1	-360	360	-67.8983	-17.8445	67.9183	17.8826	0.0000	0.0000	0.0000	0.0000;
	1139	1110	0.012479	0.038265	0.004414	114	114	114	0	0	1	-360	360	27.5846	4.5773	-27.5047	-4.8712	0.0000	0.0000	0.0000	0.0000;
	1361	1139	0.000909	0.003388	0.00039	114	114	114	0	0	1	-360	360	27.5904	4.5354	-27.5846	-4.5616	0.0000	0.0000	0.0000	0.0000;
	1137	1139	0.000413	0.001322	0.000128	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0157	0.0000	0.0000	0.0000	0.0000;
	1655	1112	0.00876	0.026942	0.003112	114	114	114	0	0	1	-360	360	47.4694	13.0730	-47.2975	-12.9274	0.0000	0.0000	0.0000	0.0000;
	1140	1655	0.003802	0.012066	0.001396	140	140	140	0	0	1	-360	360	49.5684	13.9026	-49.4875	-13.8190	0.0000	0.0000	0.0000	0.0000;
	1362	1140	0.000826	0.002562	0.000293	114	114	114	0	0	1	-360	360	81.6739	23.3312	-81.6261	-23.2196	0.0000	0.0000	0.0000	0.0000;
	1654	1655	0.002066	0.006364	0.000753	140	140	140	0	0	1	-360	360	-2.0180	-0.8390	2.0181	0.7461	0.0000	0.0000	0.0000	0.0000;
	1136	1140	0.000413	0.001322	0.00016	114	114	114	0	0	1	-360	360	-32.0540	-9.3250	32.0577	9.3169	0.0000	0.0000	0.0000	0.0000;
	1030	1878	0.001488	0.004876	0.000511	84	84	84	0	0	1	-360	360	-14.8384	0.3798	14.8412	-0.4292	0.0000	0.0000	0.0000	0.0000;
	1420	1030	0.004959	0.013223	0.0015	120	120	120	0	0	1	-360	360	-14.8289	0.2035	14.8384	-0.3508	0.0000	0.0000	0.0000	0.0000;
	1029	1030	0.000661	0.002149	0.000252	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0290	0.0000	0.0000	0.0000	0.0000;
	1782	1773	0.003306	0.010413	0.001147	140	140	140	0	0	1	-360	360	-21.7451	-0.9280	21.7582	0.8319	0.0000	0.0000	0.0000	0.0000;
	1150	1526	0.011983	0.037107	0.004211	140	140	140	0	0	1	-360	360	-17.3606	-6.3395	17.3940	5.9294	0.0000	0.0000	0.0000	0.0000;
	1380	972	0.004545	0.013967	0.001619	140	140	140	0	0	1	-360	360	-37.2682	-9.6494	37.3230	9.6189	0.0000	0.0000	0.0000	0.0000;
	1814	1800	0.004215	0.009752	0.002043	140	140	140	0	0	1	-360	360	-39.9817	-12.6362	40.0428	12.5296	0.0000	0.0000	0.0000	0.0000;
	1614	925	0.005702	0.015041	0.001646	120	120	120	0	0	1	-360	360	24.2227	-1.6153	-24.1948	1.4918	0.0000	0.0000	0.0000	0.0000;
	1339	925	0.001322	0.002645	0.000237	57	57	57	0	0	1	-360	360	-6.2920	-1.6790	6.2925	1.6515	0.0000	0.0000	0.0000	0.0000;
	1340	926	0.001322	0.002645	0.000237	57	57	57	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0291	0.0000	0.0000	0.0000	0.0000;
	1844	1658	0.002893	0.007025	0.000779	120	120	120	0	0	1	-360	360	8.3197	1.9149	-8.3180	-2.0050	0.0000	0.0000	0.0000	0.0000;
	1845	1659	0.002893	0.007025	0.000779	120	120	120	0	0	1	-360	360	8.3178	2.3810	-8.3160	-2.4710	0.0000	0.0000	0.0000	0.0000;
	1625	1110	0.003719	0.009008	0.000999	120	120	120	0	0	1	-360	360	-16.9909	-2.2325	16.9999	2.1329	0.0000	0.0000	0.0000	0.0000;
	1845	1625	0.004628	0.01438	0.001626	140	140	140	0	0	1	-360	360	-15.0820	-2.1856	15.0909	2.0159	0.0000	0.0000	0.0000	0.0000;
	1624	1625	0.002645	0.006116	0.00129	140	140	140	0	0	1	-360	360	-1.9000	-0.3730	1.9001	0.2166	0.0000	0.0000	0.0000	0.0000;
	1844	1110	0.008347	0.023471	0.002628	120	120	120	0	0	1	-360	360	-16.7798	-2.3715	16.7996	2.1081	0.0000	0.0000	0.0000	0.0000;
	1252	1110	0.00157	0.004793	0.000566	140	140	140	0	0	1	-360	360	2.3273	2.0588	-2.3272	-2.1272	0.0000	0.0000	0.0000	0.0000;
	1471	1252	0.007438	0.022562	0.00266	140	140	140	0	0	1	-360	360	8.8619	2.7421	-8.8566	-3.0497	0.0000	0.0000	0.0000	0.0000;
	1853	1471	0.000992	0.003306	0.000351	140	140	140	0	0	1	-360	360	10.6449	2.9731	-10.6439	-3.0125	0.0000	0.0000	0.0000	0.0000;
	1252	1250	0.000744	0.001405	0.000293	120	120	120	0	0	1	-360	360	6.5293	0.9909	-6.5290	-1.0260	0.0000	0.0000	0.0000	0.0000;
	1469	1471	0.000248	0.000496	4.6e-05	90	90	90	0	0	1	-360	360	-1.7820	-0.2760	1.7820	0.2704	0.0000	0.0000	0.0000	0.0000;
	1295	1110	0.00876	0.026529	0.003124	140	140	140	0	0	1	-360	360	-16.1425	-9.3801	16.1676	9.0775	0.0000	0.0000	0.0000	0.0000;
	1789	1413	0.010083	0.024546	0.002715	120	120	120	0	0	1	-360	360	-2.7444	-12.1101	2.7576	11.8282	0.0000	0.0000	0.0000	0.0000;
	1827	1789	0.011901	0.029669	0.003277	120	120	120	0	0	1	-360	360	6.7851	-10.0855	-6.7702	9.7456	0.0000	0.0000	0.0000	0.0000;
	1787	1789	0.00438	0.006116	0.000777	75	75	75	0	0	1	-360	360	-9.5110	-2.4490	9.5147	2.3646	0.0000	0.0000	0.0000	0.0000;
	1790	1414	0.010083	0.024546	0.002715	120	120	120	0	0	1	-360	360	-9.9954	-5.8995	10.0071	5.6155	0.0000	0.0000	0.0000	0.0000;
	1601	1790	0.008099	0.021074	0.002386	120	120	120	0	0	1	-360	360	-1.6763	-4.5203	1.6778	4.2506	0.0000	0.0000	0.0000	0.0000;
	1788	1790	0.004132	0.005372	0.000692	75	75	75	0	0	1	-360	360	-8.3150	-1.7250	8.3176	1.6489	0.0000	0.0000	0.0000	0.0000;
	1844	1706	0.002397	0.007355	0.000857	140	140	140	0	0	1	-360	360	4.8685	1.6699	-4.8680	-1.7720	0.0000	0.0000	0.0000	0.0000;
	1231	1004	0.003141	0.013306	0.001379	162	162	162	0	0	1	-360	360	-44.5413	-10.1072	44.5944	10.1623	0.0000	0.0000	0.0000	0.0000;
	1413	1145	0.003058	0.003802	0.000721	90	90	90	0	0	1	-360	360	0.0000	-0.0836	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1414	1146	0.003141	0.003884	0.00074	90	90	90	0	0	1	-360	360	1.6631	0.3807	-1.6630	-0.4660	0.0000	0.0000	0.0000	0.0000;
	1026	1631	0.001074	0.003223	0.000378	140	140	140	0	0	1	-360	360	68.6491	17.5358	-68.6034	-17.4433	0.0000	0.0000	0.0000	0.0000;
	1720	1026	0.001818	0.00562	0.000665	140	140	140	0	0	1	-360	360	74.5582	19.3010	-74.4672	-19.0985	0.0000	0.0000	0.0000	0.0000;
	1026	1025	0.000579	0.001653	0.000194	140	140	140	0	0	1	-360	360	5.8182	1.5627	-5.8180	-1.5850	0.0000	0.0000	0.0000	0.0000;
	1378	1628	0.003141	0.021405	0.002413	114	114	114	0	0	1	-360	360	-34.4084	-6.9482	34.4405	6.8758	0.0000	0.0000	0.0000	0.0000;
	973	1276	0.006446	0.020661	0.002164	114	114	114	0	0	1	-360	360	59.2552	16.8664	-59.0560	-16.4926	0.0000	0.0000	0.0000	0.0000;
	1844	1368	0.00405	0.012397	0.00143	114	114	114	0	0	1	-360	360	13.4366	-4.3823	-13.4300	4.2294	0.0000	0.0000	0.0000	0.0000;
	884	1415	0.001983	0.006033	0.000697	140	140	140	0	0	1	-360	360	11.4736	2.1775	-11.4713	-2.2504	0.0000	0.0000	0.0000	0.0000;
	1878	884	0.004959	0.015207	0.001752	140	140	140	0	0	1	-360	360	15.7700	3.2064	-15.7588	-3.3736	0.0000	0.0000	0.0000	0.0000;
	884	882	0.001074	0.001818	0.000194	90	90	90	0	0	1	-360	360	4.2852	1.1961	-4.2850	-1.2180	0.0000	0.0000	0.0000	0.0000;
	1238	1416	0.002314	0.007438	0.000811	140	140	140	0	0	1	-360	360	22.4006	-1.9167	-22.3904	1.8563	0.0000	0.0000	0.0000	0.0000;
	1621	1238	0.005702	0.018017	0.001994	140	140	140	0	0	1	-360	360	22.4257	-2.0690	-22.4006	1.9190	0.0000	0.0000	0.0000	0.0000;
	1237	1238	8.3e-05	0.000248	1.9e-05	120	120	120	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0022	0.0000	0.0000	0.0000	0.0000;
	1232	1804	0.001901	0.004628	0.000895	140	140	140	0	0	1	-360	360	5.8286	1.6314	-5.8280	-1.7370	0.0000	0.0000	0.0000	0.0000;
	1805	1231	0.001405	0.004628	0.000489	140	140	140	0	0	1	-360	360	-38.5566	0.4180	38.5736	-0.4222	0.0000	0.0000	0.0000	0.0000;
	926	1805	0.008099	0.022645	0.002439	120	120	120	0	0	1	-360	360	-33.7240	1.9922	33.7995	-2.0807	0.0000	0.0000	0.0000	0.0000;
	1803	1805	0.000496	0.00124	0.000191	140	140	140	0	0	1	-360	360	-4.7570	-1.6860	4.7571	1.6627	0.0000	0.0000	0.0000	0.0000;
	1102	1112	0.007521	0.023058	0.002413	120	120	120	0	0	1	-360	360	-3.7990	0.1176	3.7999	-0.4099	0.0000	0.0000	0.0000	0.0000;
	1268	1102	0.000331	0.001157	0.000116	114	114	114	0	0	1	-360	360	-3.7990	-0.0000	3.7990	-0.0141	0.0000	0.0000	0.0000	0.0000;
	1100	1102	0.002397	0.007521	0.000847	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.1036	0.0000	0.0000	0.0000	0.0000;
	1815	1905	0.008099	0.026116	0.002725	140	140	140	0	0	1	-360	360	37.5414	12.0894	-37.4371	-12.0812	0.0000	0.0000	0.0000	0.0000;
	1554	845	0.003636	0.011405	0.001242	140	140	140	0	0	1	-360	360	-40.3556	0.7383	40.4073	-0.7183	0.0000	0.0000	0.0000	0.0000;
	890	1554	0.00157	0.004876	0.000542	140	140	140	0	0	1	-360	360	-33.3182	2.7368	33.3335	-2.7512	0.0000	0.0000	0.0000	0.0000;
	1554	1552	0.002314	0.006942	0.000728	120	120	120	0	0	1	-360	360	7.0221	2.0129	-7.0210	-2.0930	0.0000	0.0000	0.0000	0.0000;
	1779	1016	0.001983	0.005702	0.000617	120	120	120	0	0	1	-360	360	-5.8567	8.5224	5.8586	-8.5876	0.0000	0.0000	0.0000	0.0000;
	1120	1780	0.003719	0.011322	0.001266	120	120	120	0	0	1	-360	360	6.1934	7.4692	-6.1903	-7.6048	0.0000	0.0000	0.0000	0.0000;
	885	1120	0.001901	0.005785	0.000653	140	140	140	0	0	1	-360	360	6.1949	7.3336	-6.1934	-7.4039	0.0000	0.0000	0.0000	0.0000;
	1878	885	0.004959	0.015207	0.001752	140	140	140	0	0	1	-360	360	7.3868	7.4858	-7.3819	-7.6724	0.0000	0.0000	0.0000	0.0000;
	885	883	0.001074	0.001818	0.000194	90	90	90	0	0	1	-360	360	1.1870	0.3388	-1.1870	-0.3610	0.0000	0.0000	0.0000	0.0000;
	1119	1120	0.001983	0.004545	0.000569	120	120	120	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0652	0.0000	0.0000	0.0000	0.0000;
	1232	1781	0.001901	0.005868	0.000658	140	140	140	0	0	1	-360	360	-18.8891	-0.4260	18.8948	0.3647	0.0000	0.0000	0.0000	0.0000;
	1447	1286	0.013388	0.041488	0.004726	140	140	140	0	0	1	-360	360	-51.4985	-10.6499	51.7990	10.9949	0.0000	0.0000	0.0000	0.0000;
	1801	1447	0.007603	0.02405	0.002618	140	140	140	0	0	1	-360	360	-45.5355	-9.3044	45.6702	9.4101	0.0000	0.0000	0.0000	0.0000;
	1447	1445	0.001074	0.010992	0.001752	75	75	75	0	0	1	-360	360	5.8283	1.2399	-5.8280	-1.4520	0.0000	0.0000	0.0000	0.0000;
	1446	1047	0.00876	0.027851	0.00303	140	140	140	0	0	1	-360	360	36.4069	8.7198	-36.3070	-8.7736	0.0000	0.0000	0.0000	0.0000;
	1357	1446	0.011157	0.034463	0.003913	140	140	140	0	0	1	-360	360	43.3391	9.7685	-43.1623	-9.7074	0.0000	0.0000	0.0000	0.0000;
	1286	1357	0.002314	0.007025	0.000816	140	140	140	0	0	1	-360	360	50.6414	11.4534	-50.5916	-11.4040	0.0000	0.0000	0.0000	0.0000;
	1446	1444	0.001058	0.010826	0.001726	75	75	75	0	0	1	-360	360	6.7554	0.9876	-6.7550	-1.1960	0.0000	0.0000	0.0000	0.0000;
	1357	1355	0.003223	0.006033	0.000578	90	90	90	0	0	1	-360	360	7.2524	1.6355	-7.2510	-1.7050	0.0000	0.0000	0.0000	0.0000;
	1779	1415	0.005455	0.016777	0.001914	114	114	114	0	0	1	-360	360	3.6774	-10.8575	-3.6713	10.6569	0.0000	0.0000	0.0000	0.0000;
	1904	1845	0.004215	0.009835	0.001217	120	120	120	0	0	1	-360	360	12.3727	4.8424	-12.3666	-4.9757	0.0000	0.0000	0.0000	0.0000;
	1149	1904	0.002066	0.00562	0.000593	120	120	120	0	0	1	-360	360	13.7994	5.1258	-13.7957	-5.1877	0.0000	0.0000	0.0000	0.0000;
	1903	1904	0.000661	0.002314	0.00022	120	120	120	0	0	1	-360	360	-1.4230	-0.3720	1.4230	0.3453	0.0000	0.0000	0.0000	0.0000;
	1372	1586	0.002893	0.008926	0.001004	140	140	140	0	0	1	-360	360	-16.7243	-2.0346	16.7311	1.9338	0.0000	0.0000	0.0000	0.0000;
	1815	1372	0.00595	0.019174	0.00203	140	140	140	0	0	1	-360	360	-5.7850	0.7463	5.7867	-0.9867	0.0000	0.0000	0.0000	0.0000;
	1372	1370	0.005289	0.008926	0.000927	90	90	90	0	0	1	-360	360	10.9376	3.0213	-10.9320	-3.1240	0.0000	0.0000	0.0000	0.0000;
	1037	1232	0.001653	0.005289	0.000557	120	120	120	0	0	1	-360	360	-12.4689	-4.5087	12.4713	4.4499	0.0000	0.0000	0.0000	0.0000;
	1735	1652	0.006529	0.023884	0.002338	105	105	105	0	0	1	-360	360	-6.1770	-1.5390	6.1792	1.2689	0.0000	0.0000	0.0000	0.0000;
	1906	1653	0.008017	0.026446	0.002645	140	140	140	0	0	1	-360	360	21.5295	7.5988	-21.4944	-7.7991	0.0000	0.0000	0.0000	0.0000;
	1754	1596	0.007273	0.012314	0.001788	90	90	90	0	0	1	-360	360	-48.8631	-3.4745	49.0162	3.5295	0.0000	0.0000	0.0000	0.0000;
	1843	917	0.02405	0.076281	0.008259	140	140	140	0	0	1	-360	360	53.2602	9.5034	-52.6838	-8.6706	0.0000	0.0000	0.0000	0.0000;
	1844	1038	0.003141	0.007769	0.000879	120	120	120	0	0	1	-360	360	3.8102	6.3625	-3.8087	-6.4653	0.0000	0.0000	0.0000	0.0000;
	1470	1039	0.005785	0.016116	0.001876	120	120	120	0	0	1	-360	360	-1.4320	-5.8482	1.4337	5.6260	0.0000	0.0000	0.0000	0.0000;
	1294	1470	0.002066	0.006446	0.000748	140	140	140	0	0	1	-360	360	1.6585	-5.2624	-1.6580	5.1737	0.0000	0.0000	0.0000	0.0000;
	1468	1470	0.000248	0.000496	4.6e-05	90	90	90	0	0	1	-360	360	-3.0900	-0.6800	3.0900	0.6745	0.0000	0.0000	0.0000	0.0000;
	1799	1513	0.007438	0.023967	0.002517	140	140	140	0	0	1	-360	360	-33.6174	-6.0642	33.6886	5.9863	0.0000	0.0000	0.0000	0.0000;
	1512	1287	0.012066	0.038678	0.004075	140	140	140	0	0	1	-360	360	-1.9010	-0.5590	1.9014	0.0599	0.0000	0.0000	0.0000	0.0000;
	1651	1287	0.000496	0.003719	0.000387	152	152	152	0	0	1	-360	360	-23.3653	-6.4009	23.3677	6.3711	0.0000	0.0000	0.0000	0.0000;
	1707	1651	0.008099	0.051653	0.005365	140	140	140	0	0	1	-360	360	-23.0900	-6.8388	23.1283	6.4276	0.0000	0.0000	0.0000	0.0000;
	1845	1707	0.007686	0.023967	0.002698	114	114	114	0	0	1	-360	360	-14.5264	-5.6175	14.5416	5.3375	0.0000	0.0000	0.0000	0.0000;
	1649	1651	0.000579	0.001818	0.000218	140	140	140	0	0	1	-360	360	-0.2370	0.0000	0.2370	-0.0267	0.0000	0.0000	0.0000	0.0000;
	1705	1707	0.002231	0.007438	0.000726	140	140	140	0	0	1	-360	360	-8.5470	-1.5850	8.5484	1.5013	0.0000	0.0000	0.0000	0.0000;
	1587	881	0.002727	0.008512	0.000956	140	140	140	0	0	1	-360	360	-31.5703	-7.0666	31.5939	7.0240	0.0000	0.0000	0.0000	0.0000;
	1371	880	0.003223	0.010496	0.001104	140	140	140	0	0	1	-360	360	15.5982	4.3490	-15.5912	-4.4606	0.0000	0.0000	0.0000	0.0000;
	1046	1371	0.005289	0.016942	0.001796	140	140	140	0	0	1	-360	360	15.6095	4.0536	-15.5982	-4.2362	0.0000	0.0000	0.0000	0.0000;
	1371	1369	0.005289	0.008926	0.000927	90	90	90	0	0	1	-360	360	0.0000	-0.1128	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1784	1582	0.019256	0.061488	0.006558	140	140	140	0	0	1	-360	360	41.6677	8.6623	-41.3796	-8.5304	0.0000	0.0000	0.0000	0.0000;
	1841	1784	0.010413	0.033471	0.003533	140	140	140	0	0	1	-360	360	50.5621	10.8561	-50.3358	-10.5611	0.0000	0.0000	0.0000	0.0000;
	1783	1784	0.001653	0.005537	0.000525	140	140	140	0	0	1	-360	360	-8.6670	-1.9590	8.6681	1.8988	0.0000	0.0000	0.0000	0.0000;
	1710	1622	0.004711	0.014628	0.001667	114	114	114	0	0	1	-360	360	28.3667	1.3232	-28.3351	-1.4252	0.0000	0.0000	0.0000	0.0000;
	1492	940	0.004793	0.015785	0.001561	140	140	140	0	0	1	-360	360	6.5307	1.1174	-6.5290	-1.3060	0.0000	0.0000	0.0000	0.0000;
	1362	1492	0.007438	0.02405	0.002522	114	114	114	0	0	1	-360	360	12.4996	3.0421	-12.4897	-3.3243	0.0000	0.0000	0.0000	0.0000;
	1490	1492	8.3e-05	0.000826	1.9e-05	140	140	140	0	0	1	-360	360	-5.9590	-2.2090	5.9590	2.2069	0.0000	0.0000	0.0000	0.0000;
	1141	1361	0.000744	0.002314	0.00024	114	114	114	0	0	1	-360	360	-108.1294	-30.9438	108.2063	31.1536	0.0000	0.0000	0.0000	0.0000;
	1491	1141	0.006777	0.021736	0.002294	114	114	114	0	0	1	-360	360	-4.7560	-1.1160	4.7573	0.8396	0.0000	0.0000	0.0000	0.0000;
	1138	1141	0.000909	0.003141	0.000298	114	114	114	0	0	1	-360	360	-103.2860	-29.8430	103.3721	30.1042	0.0000	0.0000	0.0000	0.0000;
	1539	1754	0.012397	0.028265	0.002664	90	90	90	0	0	1	-360	360	-5.8180	-1.2120	5.8218	0.9175	0.0000	0.0000	0.0000	0.0000;
	1798	1869	0.009421	0.031157	0.002778	120	120	120	0	0	1	-360	360	12.6643	6.1744	-12.6484	-6.4517	0.0000	0.0000	0.0000	0.0000;
	979	943	0.015124	0.04157	0.004136	120	120	120	0	0	1	-360	360	27.2504	-14.0080	-27.1319	13.8408	0.0000	0.0000	0.0000	0.0000;
	1389	942	0.015289	0.036612	0.005537	120	120	120	0	0	1	-360	360	15.9859	-0.9891	-15.9530	0.4110	0.0000	0.0000	0.0000	0.0000;
	1432	1178	0.009339	0.031901	0.003243	140	140	140	0	0	1	-360	360	13.7739	-1.8264	-13.7589	1.4889	0.0000	0.0000	0.0000	0.0000;
	1441	1432	0.002149	0.006777	0.000772	140	140	140	0	0	1	-360	360	14.7268	-1.6428	-14.7229	1.5626	0.0000	0.0000	0.0000	0.0000;
	1432	1431	0	8.3e-05	1e-05	140	140	140	0	0	1	-360	360	0.9490	0.2638	-0.9490	-0.2650	0.0000	0.0000	0.0000	0.0000;
	1403	1178	0.005041	0.016364	0.001711	140	140	140	0	0	1	-360	360	2.8322	-7.7291	-2.8294	7.5334	0.0000	0.0000	0.0000	0.0000;
	1733	1350	0.005785	0.014463	0.001636	120	120	120	0	0	1	-360	360	-28.1925	6.9355	28.2343	-7.0228	0.0000	0.0000	0.0000	0.0000;
	1222	1350	0.034132	0.094876	0.009319	120	120	120	0	0	1	-360	360	-22.0353	10.9050	22.2141	-11.5032	0.0000	0.0000	0.0000	0.0000;
	1221	1870	0.011074	0.03281	0.002829	120	120	120	0	0	1	-360	360	-12.2742	-6.5768	12.2923	6.2964	0.0000	0.0000	0.0000	0.0000;
	1222	1919	0.006198	0.016694	0.002616	140	140	140	0	0	1	-360	360	21.3545	-7.7387	-21.3274	7.5034	0.0000	0.0000	0.0000	0.0000;
	1387	1918	0.00124	0.003802	0.000423	140	140	140	0	0	1	-360	360	-6.5932	11.6969	6.5951	-11.7409	0.0000	0.0000	0.0000	0.0000;
	1684	1732	0.007686	0.020909	0.002139	120	120	120	0	0	1	-360	360	-23.3969	7.7259	23.4369	-7.8674	0.0000	0.0000	0.0000	0.0000;
	1682	1684	0.012479	0.037851	0.004477	140	140	140	0	0	1	-360	360	-23.3326	7.3970	23.3969	-7.7259	0.0000	0.0000	0.0000	0.0000;
	1221	1684	0.021901	0.060992	0.005953	120	120	120	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1221	856	0.004876	0.01314	0.001779	120	120	120	0	0	1	-360	360	10.4085	-4.6535	-10.4031	4.4586	0.0000	0.0000	0.0000	0.0000;
	996	1315	0.006198	0.019504	0.00213	140	140	140	0	0	1	-360	360	16.4204	2.7756	-16.4059	-2.9848	0.0000	0.0000	0.0000	0.0000;
	1221	1048	0.00405	0.013802	0.001314	140	140	140	0	0	1	-360	360	-12.4594	10.9970	12.4690	-11.1190	0.0000	0.0000	0.0000	0.0000;
	1049	1683	0.010248	0.031157	0.003683	140	140	140	0	0	1	-360	360	-12.8242	10.9490	12.8494	-11.3041	0.0000	0.0000	0.0000	0.0000;
	1218	1178	0.009587	0.030826	0.003265	140	140	140	0	0	1	-360	360	-37.8358	1.1437	37.9512	-1.1628	0.0000	0.0000	0.0000	0.0000;
	1458	1178	0.001405	0.004298	0.000472	140	140	140	0	0	1	-360	360	-28.9450	-10.9738	28.9562	10.9517	0.0000	0.0000	0.0000	0.0000;
	975	1209	0.007769	0.023554	0.002773	140	140	140	0	0	1	-360	360	17.6025	0.7336	-17.5828	-1.0128	0.0000	0.0000	0.0000	0.0000;
	1770	1298	0.008182	0.025537	0.002863	140	140	140	0	0	1	-360	360	10.4695	-6.5558	-10.4593	6.2442	0.0000	0.0000	0.0000	0.0000;
	1909	1901	0.001488	0.004628	0.000542	140	140	140	0	0	1	-360	360	3.7455	-6.6371	-3.7448	6.5755	0.0000	0.0000	0.0000	0.0000;
	1480	1386	0.006281	0.019752	0.002161	140	140	140	0	0	1	-360	360	-0.3560	-0.0900	0.3560	-0.1647	0.0000	0.0000	0.0000	0.0000;
	1481	1387	0.006198	0.019587	0.002139	140	140	140	0	0	1	-360	360	-2.7320	-0.9790	2.7324	0.7283	0.0000	0.0000	0.0000	0.0000;
	1386	1902	0.000826	0.002479	0.000271	140	140	140	0	0	1	-360	360	3.8529	8.9153	-3.8523	-8.9452	0.0000	0.0000	0.0000	0.0000;
	857	1910	0.000744	0.002397	0.000281	140	140	140	0	0	1	-360	360	6.3611	-5.9261	-6.3606	5.8946	0.0000	0.0000	0.0000	0.0000;
	1920	1387	0.001983	0.005289	0.000702	120	120	120	0	0	1	-360	360	-13.3000	-8.9660	13.3043	8.8949	0.0000	0.0000	0.0000	0.0000;
	1667	1662	0.003471	0.010413	0.001239	140	140	140	0	0	1	-360	360	3.8834	1.7755	-3.8829	-1.9201	0.0000	0.0000	0.0000	0.0000;
	1668	942	0.006446	0.019669	0.002335	140	140	140	0	0	1	-360	360	-13.8556	-4.8550	13.8672	4.6146	0.0000	0.0000	0.0000	0.0000;
	1700	1179	0.004793	0.014711	0.001706	140	140	140	0	0	1	-360	360	-33.9806	1.2263	34.0257	-1.2975	0.0000	0.0000	0.0000	0.0000;
	1201	1176	0.008843	0.027603	0.003083	140	140	140	0	0	1	-360	360	-11.8867	-1.3988	11.8970	1.0547	0.0000	0.0000	0.0000	0.0000;
	1716	1179	0.005041	0.015537	0.001801	140	140	140	0	0	1	-360	360	-34.5654	2.4469	34.6147	-2.5163	0.0000	0.0000	0.0000	0.0000;
	1703	1177	0.003554	0.00876	0.000963	120	120	120	0	0	1	-360	360	-19.3527	4.9790	19.3642	-5.0686	0.0000	0.0000	0.0000	0.0000;
	1808	1703	0.016033	0.046364	0.004455	120	120	120	0	0	1	-360	360	-16.3438	5.2496	16.3827	-5.6837	0.0000	0.0000	0.0000	0.0000;
	1703	1701	0.012645	0.015868	0.003013	90	90	90	0	0	1	-360	360	2.9700	0.7047	-2.9690	-1.0730	0.0000	0.0000	0.0000	0.0000;
	1704	1176	0.004298	0.010496	0.001159	120	120	120	0	0	1	-360	360	22.8500	4.3632	-22.8310	-4.4587	0.0000	0.0000	0.0000	0.0000;
	1675	1704	0.017273	0.055289	0.005189	120	120	120	0	0	1	-360	360	26.5155	4.4129	-26.4144	-4.7287	0.0000	0.0000	0.0000	0.0000;
	1704	1702	0.01281	0.016033	0.00304	90	90	90	0	0	1	-360	360	3.5644	0.3654	-3.5630	-0.7360	0.0000	0.0000	0.0000	0.0000;
	1809	1675	0.008926	0.027355	0.003165	140	140	140	0	0	1	-360	360	-33.1357	-6.7143	33.2184	6.5771	0.0000	0.0000	0.0000	0.0000;
	1032	1675	0.009008	0.027603	0.003202	140	140	140	0	0	1	-360	360	-24.4567	-9.4309	24.5068	9.1890	0.0000	0.0000	0.0000	0.0000;
	1676	942	0.008512	0.026198	0.003006	120	120	120	0	0	1	-360	360	28.7789	15.5012	-28.7025	-15.6241	0.0000	0.0000	0.0000	0.0000;
	1677	943	0.008512	0.026198	0.003006	120	120	120	0	0	1	-360	360	-20.3121	15.5461	20.3589	-15.7612	0.0000	0.0000	0.0000	0.0000;
	1860	1677	0.004298	0.01314	0.001559	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.1867	0.0000	0.0000	0.0000	0.0000;
	1861	1675	0.004298	0.01314	0.001556	140	140	140	0	0	1	-360	360	-14.2820	-2.9150	14.2894	2.7448	0.0000	0.0000	0.0000	0.0000;
	1507	1487	0.004959	0.012397	0.001375	120	120	120	0	0	1	-360	360	22.7531	5.4628	-22.7302	-5.5679	0.0000	0.0000	0.0000	0.0000;
	1677	1507	0.010992	0.032231	0.003112	120	120	120	0	0	1	-360	360	36.1993	9.1586	-36.0711	-9.1532	0.0000	0.0000	0.0000	0.0000;
	1506	1507	0.004298	0.013058	0.001544	140	140	140	0	0	1	-360	360	-13.3110	-3.8520	13.3180	3.6905	0.0000	0.0000	0.0000	0.0000;
	1676	1486	0.016033	0.044711	0.004499	120	120	120	0	0	1	-360	360	58.6912	-0.6561	-58.2299	1.4079	0.0000	0.0000	0.0000	0.0000;
	1675	1850	0.006198	0.02	0.00212	140	140	140	0	0	1	-360	360	34.3650	7.5073	-34.3030	-7.5693	0.0000	0.0000	0.0000	0.0000;
	1221	915	0.004545	0.013802	0.001638	140	140	140	0	0	1	-360	360	10.1662	-1.2487	-10.1621	1.0682	0.0000	0.0000	0.0000	0.0000;
	1776	873	0.004132	0.01281	0.00144	140	140	140	0	0	1	-360	360	-29.8876	-2.7259	29.9187	2.6500	0.0000	0.0000	0.0000	0.0000;
	1730	873	0.003471	0.011157	0.001198	140	140	140	0	0	1	-360	360	-15.4948	-4.3288	15.5023	4.2095	0.0000	0.0000	0.0000	0.0000;
	1351	1106	0.004628	0.014297	0.001619	140	140	140	0	0	1	-360	360	33.6645	-0.1381	-33.6205	0.0809	0.0000	0.0000	0.0000	0.0000;
	1727	1069	0.004711	0.014297	0.001699	140	140	140	0	0	1	-360	360	25.8719	3.2832	-25.8450	-3.4033	0.0000	0.0000	0.0000	0.0000;
	1351	1727	0.003554	0.010992	0.001261	140	140	140	0	0	1	-360	360	30.8955	4.9545	-30.8663	-5.0145	0.0000	0.0000	0.0000	0.0000;
	1727	1725	0.00157	0.005372	0.00052	140	140	140	0	0	1	-360	360	4.9944	1.7313	-4.9940	-1.7920	0.0000	0.0000	0.0000	0.0000;
	1531	874	0.002479	0.007686	0.000883	140	140	140	0	0	1	-360	360	3.3554	1.7540	-3.3551	-1.8583	0.0000	0.0000	0.0000	0.0000;
	1351	1531	0.006116	0.018926	0.002142	140	140	140	0	0	1	-360	360	8.1216	2.8589	-8.1178	-3.1024	0.0000	0.0000	0.0000	0.0000;
	1531	1530	0.002066	0.003802	0.000784	120	120	120	0	0	1	-360	360	4.7624	1.3484	-4.7620	-1.4410	0.0000	0.0000	0.0000	0.0000;
	1365	1351	0.002397	0.007355	0.000828	140	140	140	0	0	1	-360	360	-53.3862	12.0995	53.4465	-12.0134	0.0000	0.0000	0.0000	0.0000;
	997	1441	0.002397	0.007769	0.000823	140	140	140	0	0	1	-360	360	-34.7032	-9.3116	34.7291	9.2967	0.0000	0.0000	0.0000	0.0000;
	1068	1551	0.003719	0.009008	0.001363	120	120	120	0	0	1	-360	360	15.7475	-0.4254	-15.7397	0.2827	0.0000	0.0000	0.0000	0.0000;
	1522	1440	0.006281	0.020083	0.002139	140	140	140	0	0	1	-360	360	-12.0784	-4.6467	12.0871	4.4182	0.0000	0.0000	0.0000	0.0000;
	1260	1217	8.3e-05	0.000248	2.2e-05	140	140	140	0	0	1	-360	360	32.9386	0.7617	-32.9379	-0.7621	0.0000	0.0000	0.0000	0.0000;
	1467	1260	0.007603	0.019587	0.002091	120	120	120	0	0	1	-360	360	33.8424	0.9209	-33.7696	-0.9833	0.0000	0.0000	0.0000	0.0000;
	1440	1467	0.003141	0.00843	0.000857	120	120	120	0	0	1	-360	360	34.7050	1.2449	-34.6734	-1.2629	0.0000	0.0000	0.0000	0.0000;
	1259	1260	0.004545	0.008512	0.000927	90	90	90	0	0	1	-360	360	-0.8310	-0.3320	0.8310	0.2215	0.0000	0.0000	0.0000	0.0000;
	1466	1467	0.000496	0.001322	0.000133	120	120	120	0	0	1	-360	360	-0.8310	-0.3580	0.8310	0.3421	0.0000	0.0000	0.0000	0.0000;
	1236	1217	0.002562	0.006777	0.000944	120	120	120	0	0	1	-360	360	-34.6484	-3.6685	34.6745	3.6252	0.0000	0.0000	0.0000	0.0000;
	1423	1187	0.001653	0.004959	0.00059	140	140	140	0	0	1	-360	360	28.7886	1.8488	-28.7770	-1.8841	0.0000	0.0000	0.0000	0.0000;
	1183	1218	0.003223	0.009752	0.001159	140	140	140	0	0	1	-360	360	4.2406	-8.5804	-4.2381	8.4498	0.0000	0.0000	0.0000	0.0000;
	970	1183	0.003058	0.009421	0.001058	140	140	140	0	0	1	-360	360	4.2429	-8.7003	-4.2406	8.5819	0.0000	0.0000	0.0000	0.0000;
	1182	1183	0	8.3e-05	1.2e-05	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0014	0.0000	0.0000	0.0000	0.0000;
	1187	1550	0.001405	0.004298	0.000503	140	140	140	0	0	1	-360	360	-13.5994	0.9685	13.6016	-1.0214	0.0000	0.0000	0.0000	0.0000;
	1837	1366	0.010744	0.032727	0.003836	140	140	140	0	0	1	-360	360	-50.1662	13.5339	50.4103	-13.2474	0.0000	0.0000	0.0000	0.0000;
	1217	1459	0.008264	0.026612	0.002807	140	140	140	0	0	1	-360	360	-9.2217	-4.4951	9.2289	4.1831	0.0000	0.0000	0.0000	0.0000;
	1395	1798	0.014711	0.031488	0.005377	120	120	120	0	0	1	-360	360	-13.7303	-7.9117	13.7609	7.3396	0.0000	0.0000	0.0000	0.0000;
	1222	1395	0.009917	0.019669	0.003705	120	120	120	0	0	1	-360	360	-6.4481	-5.6743	6.4541	5.2492	0.0000	0.0000	0.0000	0.0000;
	1395	1394	0.002231	0.006033	0.000564	120	120	120	0	0	1	-360	360	7.2761	2.6625	-7.2750	-2.7260	0.0000	0.0000	0.0000	0.0000;
	871	1179	0.006033	0.020496	0.002176	140	140	140	0	0	1	-360	360	-47.3536	-31.0111	47.5126	31.2856	0.0000	0.0000	0.0000	0.0000;
	872	951	0.003058	0.010661	0.001171	140	140	140	0	0	1	-360	360	33.5807	12.4433	-33.5483	-12.4721	0.0000	0.0000	0.0000	0.0000;
	1175	950	0.006529	0.020909	0.002243	140	140	140	0	0	1	-360	360	-0.4913	-10.7819	0.4974	10.5313	0.0000	0.0000	0.0000	0.0000;
	1299	1175	0.002397	0.007355	0.000876	140	140	140	0	0	1	-360	360	-0.0148	-11.0571	0.0172	10.9592	0.0000	0.0000	0.0000	0.0000;
	1171	1175	0.008678	0.02719	0.00303	140	140	140	0	0	1	-360	360	-0.4740	-0.1870	0.4740	-0.1773	0.0000	0.0000	0.0000	0.0000;
	1172	1175	0.008347	0.026116	0.002904	140	140	140	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1192	1486	0.004711	0.012149	0.001696	120	120	120	0	0	1	-360	360	-45.0795	5.4156	45.1621	-5.4024	0.0000	0.0000	0.0000	0.0000;
	1859	1192	0.02405	0.043223	0.008981	120	120	120	0	0	1	-360	360	-41.7373	5.7529	42.1062	-6.1398	0.0000	0.0000	0.0000	0.0000;
	1191	1192	0.003471	0.010826	0.001195	140	140	140	0	0	1	-360	360	-2.9730	-0.8640	2.9733	0.7242	0.0000	0.0000	0.0000	0.0000;
	1487	1663	0.001488	0.004463	0.000513	140	140	140	0	0	1	-360	360	11.5540	2.8757	-11.5522	-2.9309	0.0000	0.0000	0.0000	0.0000;
	1486	1283	0.000909	0.002975	0.000329	140	140	140	0	0	1	-360	360	2.3740	0.7073	-2.3740	-0.7460	0.0000	0.0000	0.0000	0.0000;
	1505	1486	0.010331	0.013223	0.00241	90	90	90	0	0	1	-360	360	-4.1560	-1.9870	4.1578	1.7052	0.0000	0.0000	0.0000	0.0000;
	1487	1256	0.00843	0.025785	0.00304	140	140	140	0	0	1	-360	360	6.5321	0.5832	-6.5290	-0.9323	0.0000	0.0000	0.0000	0.0000;
	1731	1523	0.001488	0.004628	0.00053	140	140	140	0	0	1	-360	360	-3.7562	-1.9193	3.7564	1.8565	0.0000	0.0000	0.0000	0.0000;
	1496	1440	0.001983	0.006116	0.000726	140	140	140	0	0	1	-360	360	-36.7204	-5.3771	36.7432	5.3603	0.0000	0.0000	0.0000	0.0000;
	1726	971	0.00438	0.014545	0.00144	140	140	140	0	0	1	-360	360	23.6321	-2.4567	-23.6113	2.3544	0.0000	0.0000	0.0000	0.0000;
	1107	1726	0.000661	0.001983	0.000232	140	140	140	0	0	1	-360	360	29.3469	-0.4589	-29.3421	0.4456	0.0000	0.0000	0.0000	0.0000;
	1724	1726	0.000165	0.000413	5.1e-05	140	140	140	0	0	1	-360	360	-5.7100	-2.0170	5.7101	2.0111	0.0000	0.0000	0.0000	0.0000;
	1314	874	0.004628	0.014545	0.001592	140	140	140	0	0	1	-360	360	16.4058	2.9089	-16.3950	-3.0648	0.0000	0.0000	0.0000	0.0000;
	1020	874	0.000826	0.002727	0.000257	140	140	140	0	0	1	-360	360	-7.7536	-0.9983	7.7540	0.9691	0.0000	0.0000	0.0000	0.0000;
	1397	1020	0.002562	0.008595	0.00082	140	140	140	0	0	1	-360	360	-7.7293	-0.9942	7.7306	0.9009	0.0000	0.0000	0.0000	0.0000;
	1019	1020	0.000992	0.003058	0.000358	140	140	140	0	0	1	-360	360	-0.0230	-0.1400	0.0230	0.0973	0.0000	0.0000	0.0000	0.0000;
	1809	974	0.005289	0.016198	0.001907	140	140	140	0	0	1	-360	360	35.8389	6.6459	-35.7817	-6.7047	0.0000	0.0000	0.0000	0.0000;
	909	942	0.000826	0.001405	0.000152	90	90	90	0	0	1	-360	360	-11.6340	-2.7980	11.6350	2.7816	0.0000	0.0000	0.0000	0.0000;
	910	943	0.000826	0.001322	0.000145	90	90	90	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0173	0.0000	0.0000	0.0000	0.0000;
	911	943	0.000826	0.001322	0.000145	90	90	90	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0173	0.0000	0.0000	0.0000	0.0000;
	912	942	0.000744	0.001157	0.000128	90	90	90	0	0	1	-360	360	-13.0930	-5.7820	13.0943	5.7688	0.0000	0.0000	0.0000	0.0000;
	1351	1775	0.004959	0.015289	0.001769	140	140	140	0	0	1	-360	360	-16.8072	-0.5538	16.8189	0.3787	0.0000	0.0000	0.0000	0.0000;
	1218	978	0.00719	0.017851	0.002134	120	120	120	0	0	1	-360	360	38.0360	-10.5725	-37.9421	10.5515	0.0000	0.0000	0.0000	0.0000;
	1440	1404	0.008017	0.027769	0.002802	140	140	140	0	0	1	-360	360	19.5995	2.1940	-19.5735	-2.4396	0.0000	0.0000	0.0000	0.0000;
	1921	916	0.006033	0.018347	0.002176	140	140	140	0	0	1	-360	360	-3.2610	3.2839	3.2621	-3.5364	0.0000	0.0000	0.0000	0.0000;
	1421	1352	0.007686	0.027273	0.003178	140	140	140	0	0	1	-360	360	7.5736	3.2862	-7.5693	-3.6629	0.0000	0.0000	0.0000	0.0000;
	1699	1177	0.001405	0.00438	0.000506	140	140	140	0	0	1	-360	360	27.2128	-2.8190	-27.2042	2.7836	0.0000	0.0000	0.0000	0.0000;
	1424	1235	0.004876	0.009256	0.001801	120	120	120	0	0	1	-360	360	-30.4523	-2.2153	30.4906	2.0741	0.0000	0.0000	0.0000	0.0000;
	1847	1798	0.003719	0.012645	0.00121	140	140	140	0	0	1	-360	360	-5.4720	-3.6160	5.4733	3.4766	0.0000	0.0000	0.0000	0.0000;
	1808	1033	0.002727	0.008347	0.000956	140	140	140	0	0	1	-360	360	-24.4430	-9.4990	24.4583	9.4283	0.0000	0.0000	0.0000	0.0000;
	1858	1772	0.001157	0.002893	0.000436	120	120	120	0	0	1	-360	360	16.4121	-8.6635	-16.4087	8.6215	0.0000	0.0000	0.0000	0.0000;
	1388	1797	0.007686	0.02405	0.002703	140	140	140	0	0	1	-360	360	-27.4141	-3.1817	27.4633	3.0135	0.0000	0.0000	0.0000	0.0000;
	1838	1797	0.01124	0.032562	0.003272	120	120	120	0	0	1	-360	360	37.3290	-17.8788	-37.1680	17.9551	0.0000	0.0000	0.0000	0.0000;
	1443	1851	0.005868	0.01595	0.00174	120	120	120	0	0	1	-360	360	-12.9117	-2.1642	12.9199	1.9721	0.0000	0.0000	0.0000	0.0000;
	1809	1443	0.000165	0.000331	3.2e-05	120	120	120	0	0	1	-360	360	-12.9115	-2.2596	12.9117	2.2561	0.0000	0.0000	0.0000	0.0000;
	1443	1442	0.001983	0.005207	0.000748	120	120	120	0	0	1	-360	360	0.0000	-0.0920	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1089	1076	0.063554	0.129835	0.012678	90	90	90	0	0	1	-360	360	25.2063	-0.1813	-24.8724	-0.6501	0.0000	0.0000	0.0000	0.0000;
	1661	1108	0.030413	0.056942	0.00521	57	57	57	0	0	1	-360	360	10.2601	-2.5551	-10.2312	2.0048	0.0000	0.0000	0.0000	0.0000;
	1900	1661	0.101736	0.200661	0.017431	90	90	90	0	0	1	-360	360	16.6775	-3.4316	-16.4338	1.8670	0.0000	0.0000	0.0000	0.0000;
	1660	1661	0.001983	0.003306	0.000353	19	19	19	0	0	1	-360	360	-6.1730	-0.7280	6.1737	0.6881	0.0000	0.0000	0.0000	0.0000;
	1344	1899	0.016116	0.028512	0.002735	90	90	90	0	0	1	-360	360	-9.6450	-0.1330	9.6577	-0.1681	0.0000	0.0000	0.0000	0.0000;
	1748	895	0.022893	0.056694	0.006297	114	114	114	0	0	1	-360	360	10.3635	1.8669	-10.3420	-2.5661	0.0000	0.0000	0.0000	0.0000;
	1738	895	0.024793	0.061322	0.006817	114	114	114	0	0	1	-360	360	-0.9987	-0.6874	0.9990	-0.1238	0.0000	0.0000	0.0000	0.0000;
	1900	1066	0.022727	0.072645	0.007749	57	57	57	0	0	1	-360	360	-14.9278	-4.2601	14.9733	3.4826	0.0000	0.0000	0.0000	0.0000;
	1342	895	0.014711	0.045207	0.005198	114	114	114	0	0	1	-360	360	-13.0555	-5.0696	13.0795	4.5263	0.0000	0.0000	0.0000	0.0000;
	1088	1147	0.096446	0.194711	0.017877	90	90	90	0	0	1	-360	360	4.0379	-1.2194	-4.0249	-0.9126	0.0000	0.0000	0.0000	0.0000;
	1345	897	0.015124	0.040496	0.004627	114	114	114	0	0	1	-360	360	-41.9476	-5.5155	42.1785	5.5882	0.0000	0.0000	0.0000	0.0000;
	963	1345	0.037273	0.075454	0.006638	90	90	90	0	0	1	-360	360	-31.2625	-3.6525	31.5850	3.5381	0.0000	0.0000	0.0000	0.0000;
	1343	1345	0.000579	0.000992	8.9e-05	29	29	29	0	0	1	-360	360	-10.3620	-1.9870	10.3626	1.9775	0.0000	0.0000	0.0000	0.0000;
	877	1055	0.018017	0.054711	0.006486	57	57	57	0	0	1	-360	360	-22.4117	1.1676	22.4899	-1.6859	0.0000	0.0000	0.0000	0.0000;
	1108	877	0.012397	0.037603	0.004441	57	57	57	0	0	1	-360	360	-16.3049	-0.1589	16.3334	-0.2700	0.0000	0.0000	0.0000	0.0000;
	877	876	0.016529	0.027273	0.002948	19	19	19	0	0	1	-360	360	6.0783	-0.8975	-6.0730	0.5640	0.0000	0.0000	0.0000	0.0000;
	1108	1494	0.014545	0.025124	0.003572	57	57	57	0	0	1	-360	360	10.8982	-1.1649	-10.8831	0.7776	0.0000	0.0000	0.0000	0.0000;
	1246	896	0.00719	0.022149	0.002522	114	114	114	0	0	1	-360	360	24.9066	-0.9728	-24.8691	0.7882	0.0000	0.0000	0.0000	0.0000;
	1245	897	0.00719	0.022231	0.002534	114	114	114	0	0	1	-360	360	-47.3551	-39.7769	47.5908	40.2078	0.0000	0.0000	0.0000	0.0000;
	1089	1083	0.006612	0.021074	0.002248	114	114	114	0	0	1	-360	360	-46.7196	-2.2781	46.8391	2.3862	0.0000	0.0000	0.0000	0.0000;
	1114	1088	0.016364	0.052149	0.005588	140	140	140	0	0	1	-360	360	57.5310	6.3672	-57.0868	-5.6352	0.0000	0.0000	0.0000	0.0000;
	1501	1088	0.019504	0.035537	0.009019	114	114	114	0	0	1	-360	360	-16.4189	-3.2689	16.4638	2.2624	0.0000	0.0000	0.0000	0.0000;
	1050	1089	0.001322	0.002314	0.000242	57	57	57	0	0	1	-360	360	-12.5840	-0.9330	12.5857	0.9068	0.0000	0.0000	0.0000	0.0000;
	1051	1088	0.001322	0.002314	0.000242	57	57	57	0	0	1	-360	360	0.0000	-0.1400	0.0000	0.1107	0.0000	0.0000	0.0000	0.0000;
	1535	1089	0.02843	0.074132	0.006752	90	90	90	0	0	1	-360	360	-16.6419	-1.0589	16.7077	0.4169	0.0000	0.0000	0.0000	0.0000;
	1899	1535	0.037769	0.073802	0.00657	90	90	90	0	0	1	-360	360	-16.5540	-1.7399	16.6419	1.1285	0.0000	0.0000	0.0000	0.0000;
	1535	1533	0.003306	0.005455	0.000581	19	19	19	0	0	1	-360	360	0.0000	-0.0697	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1900	1296	0.038182	0.074876	0.00666	90	90	90	0	0	1	-360	360	-4.5033	-1.6991	4.5103	0.9221	0.0000	0.0000	0.0000	0.0000;
	1534	1088	0.02843	0.074132	0.006752	90	90	90	0	0	1	-360	360	-23.9449	-2.8571	24.0829	2.4053	0.0000	0.0000	0.0000	0.0000;
	1297	1534	0.005207	0.009835	0.000956	90	90	90	0	0	1	-360	360	-22.9714	-2.9959	22.9949	2.9263	0.0000	0.0000	0.0000	0.0000;
	1534	1532	0.003306	0.005455	0.000581	19	19	19	0	0	1	-360	360	0.9500	-0.0693	-0.9500	0.0000	0.0000	0.0000	0.0000	0.0000;
	1291	1266	0.040496	0.066694	0.007214	57	57	57	0	0	1	-360	360	-20.4954	1.4244	20.6451	-2.0093	0.0000	0.0000	0.0000	0.0000;
	1893	1301	0.025785	0.06843	0.007802	114	114	114	0	0	1	-360	360	-3.3949	-1.5345	3.3978	0.6530	0.0000	0.0000	0.0000	0.0000;
	1894	1501	0.024463	0.061322	0.006793	114	114	114	0	0	1	-360	360	-10.8575	-1.5072	10.8819	0.7537	0.0000	0.0000	0.0000	0.0000;
	1894	1502	0.024463	0.061322	0.006793	114	114	114	0	0	1	-360	360	-24.1180	-2.7141	24.2381	2.1977	0.0000	0.0000	0.0000	0.0000;
	924	1333	0.024793	0.065454	0.006614	114	114	114	0	0	1	-360	360	30.4547	2.7416	-30.2582	-2.9988	0.0000	0.0000	0.0000	0.0000;
	1893	1695	0.001653	0.003471	0.00038	90	90	90	0	0	1	-360	360	2.4931	0.0500	-2.4930	-0.0930	0.0000	0.0000	0.0000	0.0000;
	1894	1696	0.001074	0.003471	0.00037	114	114	114	0	0	1	-360	360	4.5112	2.3815	-4.5110	-2.4250	0.0000	0.0000	0.0000	0.0000;
	1830	1265	0.030744	0.050661	0.005474	57	57	57	0	0	1	-360	360	12.9781	-10.1351	-12.9078	9.6168	0.0000	0.0000	0.0000	0.0000;
	1341	1899	0.002314	0.007438	0.000799	114	114	114	0	0	1	-360	360	-2.9875	-10.3916	2.9898	10.3043	0.0000	0.0000	0.0000	0.0000;
	1088	1067	0.01124	0.036116	0.003816	114	114	114	0	0	1	-360	360	35.5163	7.5245	-35.3936	-7.5899	0.0000	0.0000	0.0000	0.0000;
	1332	1265	0.007769	0.021736	0.002362	114	114	114	0	0	1	-360	360	22.4026	1.1282	-22.3690	-1.3085	0.0000	0.0000	0.0000	0.0000;
	1831	1455	0.05	0.082397	0.008901	57	57	57	0	0	1	-360	360	-26.1063	3.1172	26.4064	-3.6621	0.0000	0.0000	0.0000	0.0000;
	1502	961	0.026033	0.065702	0.007335	114	114	114	0	0	1	-360	360	18.1712	0.0587	-18.1001	-0.7637	0.0000	0.0000	0.0000	0.0000;
	1559	1454	0.042397	0.069917	0.00755	57	57	57	0	0	1	-360	360	45.9390	-0.4121	-45.2032	0.7217	0.0000	0.0000	0.0000	0.0000;
	887	998	0.00438	0.014876	0.001423	114	114	114	0	0	1	-360	360	-53.1782	-0.2625	53.2773	0.4210	0.0000	0.0000	0.0000	0.0000;
	1105	895	0.032479	0.102314	0.011265	114	114	114	0	0	1	-360	360	9.6992	1.5056	-9.6725	-2.7694	0.0000	0.0000	0.0000	0.0000;
	1580	1061	0.050248	0.08281	0.008956	57	57	57	0	0	1	-360	360	-13.0874	2.1458	13.1708	-2.9741	0.0000	0.0000	0.0000	0.0000;
	1737	1501	0.025372	0.062562	0.006924	114	114	114	0	0	1	-360	360	-19.8953	-1.9246	19.9801	1.3054	0.0000	0.0000	0.0000	0.0000;
	1812	1077	0.013306	0.040413	0.004804	57	57	57	0	0	1	-360	360	-5.9450	0.2350	5.9490	-0.7881	0.0000	0.0000	0.0000	0.0000;
	998	1089	0.01	0.068512	0.007647	232	232	232	0	0	1	-360	360	81.7256	21.9905	-81.1529	-19.0090	0.0000	0.0000	0.0000	0.0000;
	999	1757	0.005868	0.040083	0.004518	232	232	232	0	0	1	-360	360	97.3311	20.1631	-96.8684	-17.5632	0.0000	0.0000	0.0000	0.0000;
	1072	1082	0.006281	0.019835	0.00218	114	114	114	0	0	1	-360	360	74.3686	5.5750	-74.0842	-4.9436	0.0000	0.0000	0.0000	0.0000;
	999	1073	0.009421	0.041736	0.004576	114	114	114	0	0	1	-360	360	89.1420	11.4442	-88.5349	-9.3228	0.0000	0.0000	0.0000	0.0000;
	960	1747	0.005207	0.014215	0.001614	114	114	114	0	0	1	-360	360	14.5380	1.8812	-14.5286	-2.0493	0.0000	0.0000	0.0000	0.0000;
	1762	1082	0.002149	0.007273	0.000758	57	57	57	0	0	1	-360	360	-12.0220	-0.8230	12.0246	0.7395	0.0000	0.0000	0.0000	0.0000;
	1761	1083	0.002149	0.00719	0.000753	57	57	57	0	0	1	-360	360	-4.7530	-0.7430	4.7534	0.6528	0.0000	0.0000	0.0000	0.0000;
	1558	886	0.033058	0.05686	0.006142	90	90	90	0	0	1	-360	360	-50.6966	0.4798	51.3955	-0.0349	0.0000	0.0000	0.0000	0.0000;
	1581	902	0.017769	0.058016	0.005917	57	57	57	0	0	1	-360	360	-2.5236	-5.0272	2.5283	4.4054	0.0000	0.0000	0.0000	0.0000;
	1501	923	0.022479	0.054545	0.00621	114	114	114	0	0	1	-360	360	35.8178	3.4050	-35.5753	-3.5572	0.0000	0.0000	0.0000	0.0000;
	1054	1076	0.014545	0.04405	0.00522	57	57	57	0	0	1	-360	360	-33.6883	1.0573	33.8298	-1.2412	0.0000	0.0000	0.0000	0.0000;
	1521	1108	0.029917	0.096116	0.010188	57	57	57	0	0	1	-360	360	-9.6130	-0.4670	9.6370	-0.6330	0.0000	0.0000	0.0000	0.0000;
	1089	1794	0.011157	0.034545	0.003903	114	114	114	0	0	1	-360	360	11.1512	0.5809	-11.1396	-1.0170	0.0000	0.0000	0.0000	0.0000;
	1519	1681	0.034628	0.108843	0.01203	114	114	114	0	0	1	-360	360	-39.3206	-0.9658	39.7633	0.8844	0.0000	0.0000	0.0000	0.0000;
	1619	998	0.021074	0.067686	0.007149	114	114	114	0	0	1	-360	360	-40.2913	-2.3722	40.5691	2.3751	0.0000	0.0000	0.0000	0.0000;
	1148	1619	0.030413	0.09438	0.010721	114	114	114	0	0	1	-360	360	-39.8875	-3.2647	40.2913	3.2109	0.0000	0.0000	0.0000	0.0000;
	1618	1619	0.007603	0.036364	0.006795	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.8387	0.0000	0.0000	0.0000	0.0000;
	1680	999	0.014711	0.046529	0.005092	114	114	114	0	0	1	-360	360	-45.2423	-2.1150	45.4857	2.2501	0.0000	0.0000	0.0000	0.0000;
	1518	1147	0.010248	0.03124	0.003698	57	57	57	0	0	1	-360	360	22.8659	1.5328	-22.8213	-1.8431	0.0000	0.0000	0.0000	0.0000;
	1758	1088	0.004628	0.031736	0.003586	232	232	232	0	0	1	-360	360	79.7304	15.1299	-79.4819	-13.8627	0.0000	0.0000	0.0000	0.0000;
	1886	1113	0.003388	0.010331	0.00121	114	114	114	0	0	1	-360	360	60.2748	9.1564	-60.1734	-8.9971	0.0000	0.0000	0.0000	0.0000;
	998	1885	0.003306	0.022479	0.002502	114	114	114	0	0	1	-360	360	89.9600	14.0209	-89.7415	-12.8470	0.0000	0.0000	0.0000	0.0000;
	1501	999	0.03438	0.110579	0.011626	114	114	114	0	0	1	-360	360	-62.3762	-2.7947	63.4898	4.9484	0.0000	0.0000	0.0000	0.0000;
	1502	998	0.03438	0.110579	0.011628	114	114	114	0	0	1	-360	360	-48.9443	-4.0544	49.6278	4.8195	0.0000	0.0000	0.0000	0.0000;
	1330	1062	0.053471	0.074876	0.006638	57	57	57	0	0	1	-360	360	27.1180	0.8163	-26.7640	-1.0493	0.0000	0.0000	0.0000	0.0000;
	968	896	0.008678	0.022066	0.002524	114	114	114	0	0	1	-360	360	-36.5537	-3.6180	36.6528	3.5710	0.0000	0.0000	0.0000	0.0000;
	1793	1104	0.017025	0.053058	0.005936	114	114	114	0	0	1	-360	360	10.6656	0.9401	-10.6493	-1.6044	0.0000	0.0000	0.0000	0.0000;
	904	962	0.070661	0.127355	0.012286	57	57	57	0	0	1	-360	360	-25.3704	-3.6618	25.7908	3.0443	0.0000	0.0000	0.0000	0.0000;
	1109	904	0.011653	0.023141	0.002011	57	57	57	0	0	1	-360	360	-25.3005	-3.7428	25.3704	3.6618	0.0000	0.0000	0.0000	0.0000;
	904	903	0.026777	0.036198	0.00318	57	57	57	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1148	1076	0.04719	0.089008	0.008707	57	57	57	0	0	1	-360	360	25.9419	0.6923	-25.6775	-1.2302	0.0000	0.0000	0.0000	0.0000;
	958	969	0.058099	0.089008	0.008833	75	75	75	0	0	1	-360	360	-19.9366	-2.6253	20.1391	1.9050	0.0000	0.0000	0.0000	0.0000;
	902	1109	0.013512	0.042818	0.004598	114	114	114	0	0	1	-360	360	-18.1245	-5.0273	18.1685	4.6678	0.0000	0.0000	0.0000	0.0000;
	1400	1501	0.000826	0.001653	0	229	229	229	0	0	1	-360	360	-5.9350	-0.5590	5.9352	0.5595	0.0000	0.0000	0.0000	0.0000;
	1401	1502	0.000826	0.001653	0	229	229	229	0	0	1	-360	360	-2.1370	-0.8390	2.1370	0.8391	0.0000	0.0000	0.0000	0.0000;
	1402	1501	0.001157	0.002066	0	229	229	229	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1688	953	0.023719	0.058264	0.006457	120	120	120	0	0	1	-360	360	44.1029	2.1119	-43.7172	-1.9318	0.0000	0.0000	0.0000	0.0000;
	1167	1393	0.004132	0.010165	0.001123	120	120	120	0	0	1	-360	360	-12.2067	6.5209	12.2134	-6.6384	0.0000	0.0000	0.0000	0.0000;
	1289	1167	0.03595	0.089835	0.009932	120	120	120	0	0	1	-360	360	-9.1701	6.3200	9.2097	-7.4079	0.0000	0.0000	0.0000	0.0000;
	1165	1167	0.000248	0.000496	0.000102	120	120	120	0	0	1	-360	360	-2.9970	-0.8990	2.9970	0.8869	0.0000	0.0000	0.0000	0.0000;
	1687	913	0.017851	0.041984	0.006072	120	120	120	0	0	1	-360	360	47.0444	2.0550	-46.7143	-2.0017	0.0000	0.0000	0.0000	0.0000;
	1687	859	0.018182	0.06281	0.0065	114	114	114	0	0	1	-360	360	32.6178	5.8181	-32.4508	-6.0149	0.0000	0.0000	0.0000	0.0000;
	1688	1575	0.025124	0.089339	0.008877	114	114	114	0	0	1	-360	360	-3.4962	7.1156	3.5110	-8.1229	0.0000	0.0000	0.0000	0.0000;
	1687	1274	0.010826	0.023967	0.003577	120	120	120	0	0	1	-360	360	27.1850	0.4805	-27.1183	-0.7609	0.0000	0.0000	0.0000	0.0000;
	1274	1637	0.003719	0.007686	0.00136	120	120	120	0	0	1	-360	360	27.1183	0.7811	-27.0954	-0.8959	0.0000	0.0000	0.0000	0.0000;
	1273	1274	0.000496	0.001405	0.000169	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0202	0.0000	0.0000	0.0000	0.0000;
	1708	1393	0.02438	0.043802	0.009111	120	120	120	0	0	1	-360	360	-22.0697	-11.7603	22.1974	10.9132	0.0000	0.0000	0.0000	0.0000;
	1168	1393	0.004132	0.010165	0.001123	120	120	120	0	0	1	-360	360	-2.5096	1.1938	2.5099	-1.3270	0.0000	0.0000	0.0000	0.0000;
	1822	1168	0.005702	0.017438	0.001672	120	120	120	0	0	1	-360	360	-0.7495	1.5085	0.7496	-1.7074	0.0000	0.0000	0.0000	0.0000;
	1168	1166	0.000331	0.000579	0.000121	120	120	120	0	0	1	-360	360	1.7600	0.5136	-1.7600	-0.5280	0.0000	0.0000	0.0000	0.0000;
	1823	1617	0.019174	0.052562	0.005515	120	120	120	0	0	1	-360	360	-8.7429	-1.8699	8.7556	1.2470	0.0000	0.0000	0.0000	0.0000;
	1822	1161	0.000826	0.002397	0.000315	114	114	114	0	0	1	-360	360	12.2462	4.6600	-12.2450	-4.6940	0.0000	0.0000	0.0000	0.0000;
	1823	1162	0.000909	0.002645	0.00037	114	114	114	0	0	1	-360	360	6.3203	0.6438	-6.3200	-0.6870	0.0000	0.0000	0.0000	0.0000;
	1823	1156	0.001818	0.005537	0.000653	114	114	114	0	0	1	-360	360	10.1479	4.4370	-10.1460	-4.5090	0.0000	0.0000	0.0000	0.0000;
	1822	1157	0.001901	0.005702	0.000673	114	114	114	0	0	1	-360	360	13.9285	4.7442	-13.9250	-4.8140	0.0000	0.0000	0.0000	0.0000;
	1829	1575	0.004628	0.014876	0.001563	114	114	114	0	0	1	-360	360	27.9970	0.8274	-27.9665	-0.9154	0.0000	0.0000	0.0000	0.0000;
	1375	1574	0.008264	0.026612	0.0028	114	114	114	0	0	1	-360	360	37.2571	3.7314	-37.1600	-3.7519	0.0000	0.0000	0.0000	0.0000;
	1823	1154	0.005372	0.01281	0.002529	114	114	114	0	0	1	-360	360	5.4439	6.8753	-5.4403	-7.1674	0.0000	0.0000	0.0000	0.0000;
	1392	1151	0.003471	0.006529	0.000605	90	90	90	0	0	1	-360	360	-1.2989	-0.2858	1.2990	0.2140	0.0000	0.0000	0.0000	0.0000;
	1392	1152	0.003636	0.006446	0.00059	90	90	90	0	0	1	-360	360	-7.5922	-0.5811	7.5940	0.5140	0.0000	0.0000	0.0000	0.0000;
	1393	1153	0.003636	0.006446	0.00059	90	90	90	0	0	1	-360	360	-1.3949	-0.3013	1.3950	0.2310	0.0000	0.0000	0.0000	0.0000;
	1393	1158	0.001074	0.002231	0.000414	114	114	114	0	0	1	-360	360	1.0450	0.3977	-1.0450	-0.4470	0.0000	0.0000	0.0000	0.0000;
	1392	1159	0.001157	0.002066	0.000426	114	114	114	0	0	1	-360	360	1.3300	0.4704	-1.3300	-0.5210	0.0000	0.0000	0.0000	0.0000;
	1823	1164	0.001818	0.005124	0.000716	114	114	114	0	0	1	-360	360	7.9732	8.6451	-7.9711	-8.7243	0.0000	0.0000	0.0000	0.0000;
	1392	1155	0.002479	0.006364	0.001108	114	114	114	0	0	1	-360	360	17.9395	-0.4831	-17.9327	0.3687	0.0000	0.0000	0.0000	0.0000;
	1392	866	0.017934	0.04438	0.004813	120	120	120	0	0	1	-360	360	7.4084	-4.3387	-7.3976	3.7931	0.0000	0.0000	0.0000	0.0000;
	991	867	0.006281	0.019091	0.001994	114	114	114	0	0	1	-360	360	16.9206	1.0239	-16.9054	-1.2153	0.0000	0.0000	0.0000	0.0000;
	1561	1070	0.013223	0.036364	0.003872	114	114	114	0	0	1	-360	360	40.0187	-2.2520	-39.8408	2.2809	0.0000	0.0000	0.0000	0.0000;
	1828	1373	0.003719	0.012066	0.001268	140	140	140	0	0	1	-360	360	-59.9345	-7.7997	60.0486	8.0181	0.0000	0.0000	0.0000	0.0000;
	1542	1375	0.002066	0.006446	0.000748	140	140	140	0	0	1	-360	360	-70.5546	-5.5453	70.6415	5.7273	0.0000	0.0000	0.0000	0.0000;
	953	1543	0.011983	0.034132	0.003741	120	120	120	0	0	1	-360	360	-51.5037	-1.6414	51.7740	1.9685	0.0000	0.0000	0.0000	0.0000;
	1687	1765	0.012314	0.037521	0.004424	114	114	114	0	0	1	-360	360	58.2337	10.3146	-57.8742	-9.7453	0.0000	0.0000	0.0000	0.0000;
	1694	935	0.003884	0.009174	0.001317	120	120	120	0	0	1	-360	360	5.6707	7.5807	-5.6678	-7.7315	0.0000	0.0000	0.0000	0.0000;
	1694	1687	0.000661	0.00438	0.000586	152	152	152	0	0	1	-360	360	-38.9870	-6.3580	38.9956	6.3448	0.0000	0.0000	0.0000	0.0000;
	1693	1688	0.000909	0.006281	0.000755	152	152	152	0	0	1	-360	360	-9.9825	-24.7974	9.9879	24.7443	0.0000	0.0000	0.0000	0.0000;
	1227	1778	0.043223	0.057851	0.005162	57	57	57	0	0	1	-360	360	-14.1718	-1.0029	14.2487	0.5182	0.0000	0.0000	0.0000	0.0000;
	1689	1227	0.009256	0.029752	0.003134	57	57	57	0	0	1	-360	360	-4.2675	0.2118	4.2690	-0.5616	0.0000	0.0000	0.0000	0.0000;
	1225	1227	0.007686	0.010165	0.000908	75	75	75	0	0	1	-360	360	-9.8960	-1.6580	9.9028	1.5644	0.0000	0.0000	0.0000	0.0000;
	1228	1777	0.034793	0.040248	0.007214	57	57	57	0	0	1	-360	360	-17.0542	-0.7486	17.1436	0.0302	0.0000	0.0000	0.0000	0.0000;
	1690	1228	0.009091	0.029174	0.003078	57	57	57	0	0	1	-360	360	-8.7915	-0.5388	8.7977	0.2103	0.0000	0.0000	0.0000	0.0000;
	1226	1228	0.004132	0.007438	0.001149	62	62	62	0	0	1	-360	360	-8.2540	-0.6640	8.2565	0.5383	0.0000	0.0000	0.0000	0.0000;
	1694	1606	0.087769	0.169835	0.016066	90	90	90	0	0	1	-360	360	33.3163	-1.2227	-32.5037	0.9124	0.0000	0.0000	0.0000	0.0000;
	1688	1438	0.02	0.046694	0.009535	114	114	114	0	0	1	-360	360	87.9074	7.9236	-86.6074	-6.0129	0.0000	0.0000	0.0000	0.0000;
	1439	1390	0.039339	0.090413	0.018963	114	114	114	0	0	1	-360	360	50.4450	-5.6274	-49.5739	5.4605	0.0000	0.0000	0.0000	0.0000;
	1181	1213	0.043223	0.103058	0.011205	90	90	90	0	0	1	-360	360	-7.6762	8.6901	7.7324	-9.8049	0.0000	0.0000	0.0000	0.0000;
	1778	1353	0.015703	0.024793	0.004015	90	90	90	0	0	1	-360	360	0.1747	7.3957	-0.1668	-7.8420	0.0000	0.0000	0.0000	0.0000;
	1647	878	0.036777	0.09157	0.00974	120	120	120	0	0	1	-360	360	26.4079	5.3889	-26.1729	-5.9059	0.0000	0.0000	0.0000	0.0000;
	1075	1541	0.009339	0.017355	0.001779	90	90	90	0	0	1	-360	360	5.5378	1.4015	-5.5350	-1.5950	0.0000	0.0000	0.0000	0.0000;
	1074	1305	0.032645	0.099504	0.011696	76	76	76	0	0	1	-360	360	19.7171	-2.1605	-19.6029	1.2078	0.0000	0.0000	0.0000	0.0000;
	1607	1354	0.026529	0.034463	0.006389	90	90	90	0	0	1	-360	360	12.4592	-4.5067	-12.4193	3.8285	0.0000	0.0000	0.0000	0.0000;
	1373	990	0.003884	0.012479	0.001309	114	114	114	0	0	1	-360	360	52.1057	5.7125	-52.0165	-5.5825	0.0000	0.0000	0.0000	0.0000;
	1093	1742	0.035785	0.070331	0.00718	90	90	90	0	0	1	-360	360	-6.2819	-0.9170	6.2948	0.1472	0.0000	0.0000	0.0000	0.0000;
	1741	1060	0.003967	0.00719	0.001026	57	57	57	0	0	1	-360	360	3.5945	1.1751	-3.5940	-1.2880	0.0000	0.0000	0.0000	0.0000;
	1741	1865	0.007107	0.011818	0.001256	90	90	90	0	0	1	-360	360	1.5670	0.2332	-1.5668	-0.3723	0.0000	0.0000	0.0000	0.0000;
	1742	1866	0.007025	0.011653	0.001244	90	90	90	0	0	1	-360	360	1.9614	0.0350	-1.9612	-0.1727	0.0000	0.0000	0.0000	0.0000;
	889	1462	0.019091	0.057934	0.006878	114	114	114	0	0	1	-360	360	-1.9679	-10.7983	1.9866	10.0606	0.0000	0.0000	0.0000	0.0000;
	1777	889	0.006529	0.019835	0.002357	114	114	114	0	0	1	-360	360	4.2267	-9.5118	-4.2207	9.2598	0.0000	0.0000	0.0000	0.0000;
	888	889	0.01	0.030331	0.003603	57	57	57	0	0	1	-360	360	-6.1850	-1.9410	6.1886	1.5385	0.0000	0.0000	0.0000	0.0000;
	1074	1391	0.038678	0.119669	0.013649	114	114	114	0	0	1	-360	360	-25.6347	2.9015	25.8669	-3.7160	0.0000	0.0000	0.0000	0.0000;
	1074	900	0.002645	0.008182	0.000961	114	114	114	0	0	1	-360	360	13.3376	4.7584	-13.3328	-4.8509	0.0000	0.0000	0.0000	0.0000;
	1848	952	0.01405	0.026033	0.003528	90	90	90	0	0	1	-360	360	-73.6606	-2.1432	74.3214	2.9563	0.0000	0.0000	0.0000	0.0000;
	1574	860	0.012727	0.043388	0.004581	114	114	114	0	0	1	-360	360	18.9860	0.4223	-18.9472	-0.8323	0.0000	0.0000	0.0000	0.0000;
	994	1373	0.002149	0.014711	0.00167	152	152	152	0	0	1	-360	360	-26.2700	-4.5510	26.2828	4.4386	0.0000	0.0000	0.0000	0.0000;
	1288	1687	0.007686	0.020496	0.002246	120	120	120	0	0	1	-360	360	4.0620	-6.7676	-4.0581	6.5087	0.0000	0.0000	0.0000	0.0000;
	1822	1374	0.002645	0.01876	0.001951	152	152	152	0	0	1	-360	360	-25.4252	-10.9127	25.4421	10.7996	0.0000	0.0000	0.0000	0.0000;
	1823	1375	0.002645	0.01876	0.001951	152	152	152	0	0	1	-360	360	64.0049	-20.0963	-63.9050	20.5726	0.0000	0.0000	0.0000	0.0000;
	1898	1575	0.015124	0.041157	0.004104	114	114	114	0	0	1	-360	360	20.7677	-11.9532	-20.6952	11.6637	0.0000	0.0000	0.0000	0.0000;
	914	1536	0.008926	0.023719	0.003146	114	114	114	0	0	1	-360	360	20.0676	0.8439	-20.0371	-1.1339	0.0000	0.0000	0.0000	0.0000;
	1075	1092	0.04124	0.076446	0.007979	90	90	90	0	0	1	-360	360	9.3662	2.7316	-9.3301	-3.5511	0.0000	0.0000	0.0000	0.0000;
	1392	1163	0.005207	0.012231	0.002452	114	114	114	0	0	1	-360	360	7.6423	-4.5693	-7.6389	4.2860	0.0000	0.0000	0.0000	0.0000;
	1071	1574	0.015207	0.040083	0.004366	120	120	120	0	0	1	-360	360	12.3643	-6.8943	-12.3391	6.4434	0.0000	0.0000	0.0000	0.0000;
	1616	1373	0.004711	0.015289	0.001605	140	140	140	0	0	1	-360	360	-15.8137	-3.3532	15.8240	3.1946	0.0000	0.0000	0.0000	0.0000;
	1457	1074	0.010909	0.035289	0.003691	114	114	114	0	0	1	-360	360	-26.5351	0.5843	26.6043	-0.7719	0.0000	0.0000	0.0000	0.0000;
	1528	1456	0.031901	0.106364	0.011251	114	114	114	0	0	1	-360	360	-8.4662	-0.3247	8.4869	-0.8544	0.0000	0.0000	0.0000	0.0000;
	1329	1375	0.001653	0.011157	0.001239	152	152	152	0	0	1	-360	360	-37.7865	-2.5930	37.8064	2.5793	0.0000	0.0000	0.0000	0.0000;
	1449	1304	0.006529	0.020909	0.002214	114	114	114	0	0	1	-360	360	2.1611	0.1401	-2.1608	-0.3845	0.0000	0.0000	0.0000	0.0000;
	1529	1305	0.021984	0.070744	0.007439	114	114	114	0	0	1	-360	360	1.6432	-1.4164	-1.6425	0.5951	0.0000	0.0000	0.0000	0.0000;
	1777	1693	0.045124	0.233802	0.024389	114	114	114	0	0	1	-360	360	-29.0735	-5.8794	29.4145	4.7902	0.0000	0.0000	0.0000	0.0000;
	1777	1687	0.045703	0.237025	0.024841	114	114	114	0	0	1	-360	360	-28.5635	-6.5698	28.8997	5.4003	0.0000	0.0000	0.0000	0.0000;
	1393	1160	0.000826	0.002645	0.000312	140	140	140	0	0	1	-360	360	0.0000	-0.0372	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1638	995	0.004298	0.00719	0.01602	120	120	120	0	0	1	-360	360	-10.8697	3.3344	10.8746	-5.2355	0.0000	0.0000	0.0000	0.0000;
	1778	1180	0.058099	0.13124	0.012928	90	90	90	0	0	1	-360	360	-1.5981	9.1606	1.6491	-10.5099	0.0000	0.0000	0.0000	0.0000;
	1374	1560	0.003884	0.012562	0.001326	114	114	114	0	0	1	-360	360	58.1198	-0.8378	-58.0102	1.0336	0.0000	0.0000	0.0000	0.0000;
	1384	1574	0.001653	0.005793	0	97	97	97	0	0	1	-360	360	-16.9620	1.7270	16.9661	-1.7128	0.0000	0.0000	0.0000	0.0000;
	1385	1575	0.001653	0.005793	0	97	97	97	0	0	1	-360	360	-24.8030	3.1300	24.8117	-3.0995	0.0000	0.0000	0.0000	0.0000;
	879	901	0.003967	0.012149	0.001391	114	114	114	0	0	1	-360	360	9.7726	1.2715	-9.7692	-1.4162	0.0000	0.0000	0.0000	0.0000;
	1579	1393	0.018017	0.054793	0.006483	114	114	114	0	0	1	-360	360	-41.5001	4.0983	41.7658	-4.0593	0.0000	0.0000	0.0000	0.0000;
	1849	1465	0.017851	0.03438	0.004874	90	90	90	0	0	1	-360	360	49.1092	-3.0629	-48.7351	3.2245	0.0000	0.0000	0.0000	0.0000;
	1537	952	0.006777	0.01595	0.002253	114	114	114	0	0	1	-360	360	2.8330	1.0183	-2.8325	-1.2823	0.0000	0.0000	0.0000	0.0000;
	1302	1463	0.006612	0.021074	0.002294	97	97	97	0	0	1	-360	360	-39.0908	-0.8692	39.1782	0.8822	0.0000	0.0000	0.0000	0.0000;
	1857	1897	0.02	0.056529	0.005397	120	120	120	0	0	1	-360	360	36.3220	-10.7244	-36.0814	10.7644	0.0000	0.0000	0.0000	0.0000;
	995	1328	0.000579	0.003884	0.000452	152	152	152	0	0	1	-360	360	-37.7766	0.9195	37.7835	-0.9269	0.0000	0.0000	0.0000	0.0000;
	1307	1392	0.043719	0.115041	0.011948	120	120	120	0	0	1	-360	360	27.8709	-9.7124	-27.5560	9.1196	0.0000	0.0000	0.0000	0.0000;
	1448	1751	0.032562	0.104628	0.011026	114	114	114	0	0	1	-360	360	-9.5581	-1.2034	9.5851	0.0642	0.0000	0.0000	0.0000	0.0000;
	1075	1303	0.049422	0.164628	0.016129	114	114	114	0	0	1	-360	360	-26.8807	-3.8690	27.2043	3.1138	0.0000	0.0000	0.0000	0.0000;
	1006	1766	0.011735	0.03562	0.004228	114	114	114	0	0	1	-360	360	-57.5282	-9.1721	57.8718	9.7211	0.0000	0.0000	0.0000	0.0000;
	1795	1767	0.010578	0.029091	0.003349	114	114	114	0	0	1	-360	360	-14.9125	4.9118	14.9352	-5.2368	0.0000	0.0000	0.0000	0.0000;
	1767	858	0.005207	0.015785	0.001868	140	140	140	0	0	1	-360	360	0.0000	-0.2161	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1768	838	0.00157	0.001983	0.00037	90	90	90	0	0	1	-360	360	4.7554	2.9517	-4.7550	-2.9940	0.0000	0.0000	0.0000	0.0000;
	1767	839	0.001488	0.001818	0.000353	90	90	90	0	0	1	-360	360	0.0000	-0.0409	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1768	840	0.000496	0.000579	0.000111	90	90	90	0	0	1	-360	360	1.1205	18.8959	-1.1190	-18.9070	0.0000	0.0000	0.0000	0.0000;
	1768	841	0.001074	0.001322	0.000252	90	90	90	0	0	1	-360	360	0.0000	-0.0291	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1796	1768	0.009917	0.030331	0.003557	120	120	120	0	0	1	-360	360	-34.3642	10.7916	34.4759	-10.8613	0.0000	0.0000	0.0000	0.0000;
	927	1867	0.023141	0.028926	0.005498	90	90	90	0	0	1	-360	360	-13.2799	6.7161	13.3267	-7.2715	0.0000	0.0000	0.0000	0.0000;
	1254	1348	0.022149	0.04281	0.008245	120	120	120	0	0	1	-360	360	48.1731	4.5646	-47.7242	-4.6406	0.0000	0.0000	0.0000	0.0000;
	870	928	0.020827	0.026446	0.004884	90	90	90	0	0	1	-360	360	9.2508	8.6413	-9.2202	-9.1494	0.0000	0.0000	0.0000	0.0000;
	1008	870	0.018512	0.058347	0.006326	90	90	90	0	0	1	-360	360	13.2140	9.1663	-13.1709	-9.7467	0.0000	0.0000	0.0000	0.0000;
	868	870	0.000496	0.000826	8.7e-05	90	90	90	0	0	1	-360	360	-3.9200	-1.1150	3.9201	1.1053	0.0000	0.0000	0.0000	0.0000;
	1767	1254	0.006942	0.019091	0.001938	120	120	120	0	0	1	-360	360	-17.3092	4.9388	17.3287	-5.1094	0.0000	0.0000	0.0000	0.0000;
	1791	1254	0.00686	0.010165	0.001747	76	76	76	0	0	1	-360	360	-31.5038	0.7335	31.5629	-0.8477	0.0000	0.0000	0.0000	0.0000;
	1117	1867	0.000496	0.00157	0.000186	57	57	57	0	0	1	-360	360	-14.3650	-6.2490	14.3661	6.2316	0.0000	0.0000	0.0000	0.0000;
	1795	1604	0.005702	0.018512	0.001909	114	114	114	0	0	1	-360	360	-13.2389	4.5020	13.2486	-4.6914	0.0000	0.0000	0.0000	0.0000;
	1795	869	0.021322	0.06843	0.007265	140	140	140	0	0	1	-360	360	3.8047	-0.2750	-3.8020	-0.5560	0.0000	0.0000	0.0000	0.0000;
	1745	1359	0.002562	0.005868	0.000794	57	57	57	0	0	1	-360	360	-11.8730	-2.7980	11.8764	2.7181	0.0000	0.0000	0.0000	0.0000;
	1746	1360	0.001983	0.005041	0.000649	57	57	57	0	0	1	-360	360	-9.4970	-2.7980	9.4988	2.7307	0.0000	0.0000	0.0000	0.0000;
	1118	1868	0.000579	0.001818	0.00022	57	57	57	0	0	1	-360	360	-0.7130	-0.0000	0.7130	-0.0246	0.0000	0.0000	0.0000	0.0000;
	1868	1337	0.005124	0.01562	0.001849	114	114	114	0	0	1	-360	360	-9.1640	1.5604	9.1679	-1.7550	0.0000	0.0000	0.0000	0.0000;
	1475	1564	0.003636	0.011074	0.001314	114	114	114	0	0	1	-360	360	7.4893	-7.8799	-7.4856	7.7397	0.0000	0.0000	0.0000	0.0000;
	1796	1565	0.00595	0.019917	0.001953	114	114	114	0	0	1	-360	360	-5.4616	8.1087	5.4666	-8.3174	0.0000	0.0000	0.0000	0.0000;
	1244	1359	0.01	0.016529	0.001783	76	76	76	0	0	1	-360	360	43.8887	-4.7668	-43.7138	4.8579	0.0000	0.0000	0.0000	0.0000;
	1594	1243	0.023388	0.032562	0.005065	90	90	90	0	0	1	-360	360	57.2796	-2.1119	-56.6052	2.4803	0.0000	0.0000	0.0000	0.0000;
	1605	1085	0.006612	0.021488	0.002222	114	114	114	0	0	1	-360	360	-26.6731	1.2873	26.7139	-1.4120	0.0000	0.0000	0.0000	0.0000;
	1253	1584	0.003636	0.011074	0.001317	114	114	114	0	0	1	-360	360	37.0223	1.4110	-36.9794	-1.4340	0.0000	0.0000	0.0000	0.0000;
	1253	1461	0.008017	0.024215	0.00287	76	76	76	0	0	1	-360	360	8.2738	-6.0577	-8.2667	5.7442	0.0000	0.0000	0.0000	0.0000;
	1499	1460	0.012645	0.037025	0.003359	120	120	120	0	0	1	-360	360	-0.6404	1.1862	0.6406	-1.5779	0.0000	0.0000	0.0000	0.0000;
	1585	1084	0.005868	0.017851	0.00212	114	114	114	0	0	1	-360	360	31.2768	0.1211	-31.2274	-0.2171	0.0000	0.0000	0.0000	0.0000;
	1254	1664	0.027355	0.092066	0.008835	114	114	114	0	0	1	-360	360	4.7175	0.4558	-4.7120	-1.4580	0.0000	0.0000	0.0000	0.0000;
	1091	1500	0.001736	0.005124	0.000472	120	120	120	0	0	1	-360	360	2.4499	3.0899	-2.4497	-3.1443	0.0000	0.0000	0.0000	0.0000;
	1656	1091	0.02157	0.061322	0.005	120	120	120	0	0	1	-360	360	7.9299	3.4794	-7.9157	-4.0258	0.0000	0.0000	0.0000	0.0000;
	1091	1090	0.003141	0.003884	0.000745	57	57	57	0	0	1	-360	360	5.4658	0.9359	-5.4650	-1.0220	0.0000	0.0000	0.0000	0.0000;
	1811	1795	0.011901	0.037686	0.00409	114	114	114	0	0	1	-360	360	-37.6367	-7.7310	37.7902	7.7470	0.0000	0.0000	0.0000	0.0000;
	1768	1253	0.006777	0.020579	0.001953	120	120	120	0	0	1	-360	360	-40.3518	-10.9572	40.4542	11.0412	0.0000	0.0000	0.0000	0.0000;
	1349	1359	0.025289	0.04719	0.009431	120	120	120	0	0	1	-360	360	42.4908	4.0553	-42.0828	-4.3495	0.0000	0.0000	0.0000	0.0000;
	1792	1474	0.003141	0.009504	0.00113	114	114	114	0	0	1	-360	360	25.5683	-1.9492	-25.5504	1.8731	0.0000	0.0000	0.0000	0.0000;
	956	1796	0.034298	0.109421	0.011715	114	114	114	0	0	1	-360	360	-30.1170	-5.7865	30.4021	5.3610	0.0000	0.0000	0.0000	0.0000;
	1796	1009	0.014545	0.045785	0.005055	114	114	114	0	0	1	-360	360	19.8330	10.6680	-19.7684	-11.0450	0.0000	0.0000	0.0000	0.0000;
	1795	1489	0.019587	0.062975	0.006621	120	120	120	0	0	1	-360	360	22.4905	-0.5133	-22.4048	0.0257	0.0000	0.0000	0.0000	0.0000;
	1843	1170	0.003554	0.011157	0.001258	140	140	140	0	0	1	-360	360	81.0586	15.7383	-80.8608	-15.2708	0.0000	0.0000	0.0000	0.0000;
	1275	1367	0.001983	0.006364	0.000668	114	114	114	0	0	1	-360	360	47.7655	13.9970	-47.7250	-13.9483	0.0000	0.0000	0.0000	0.0000;
	1358	1287	0.000909	0.006446	0.000665	152	152	152	0	0	1	-360	360	-76.0601	-19.9461	76.1060	20.1901	0.0000	0.0000	0.0000	0.0000;
	1629	1358	0.004298	0.030083	0.003228	232	232	232	0	0	1	-360	360	-59.9711	-15.4060	60.1071	15.9655	0.0000	0.0000	0.0000	0.0000;
	1356	1358	0.003141	0.005868	0.000559	90	90	90	0	0	1	-360	360	-15.9460	-4.0360	15.9529	3.9806	0.0000	0.0000	0.0000	0.0000;
	1600	1415	0.009587	0.02595	0.002885	120	120	120	0	0	1	-360	360	-13.1798	1.3021	13.1945	-1.5932	0.0000	0.0000	0.0000	0.0000;
	907	880	0.010413	0.03157	0.003734	140	140	140	0	0	1	-360	360	-3.5620	-1.7720	3.5633	1.3224	0.0000	0.0000	0.0000	0.0000;
	1630	1806	0.002645	0.007934	0.000941	140	140	140	0	0	1	-360	360	49.5497	14.5659	-49.4898	-14.4967	0.0000	0.0000	0.0000	0.0000;
	908	881	0.010083	0.030579	0.00362	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.4400	0.0000	0.0000	0.0000	0.0000;
	1634	1877	0.012314	0.03157	0.003463	120	120	120	0	0	1	-360	360	0.4320	7.1334	-0.4264	-7.5293	0.0000	0.0000	0.0000	0.0000;
	1569	1453	0.001901	0.006033	0.000632	114	114	114	0	0	1	-360	360	-10.4099	-1.6343	10.4117	1.5683	0.0000	0.0000	0.0000	0.0000;
	1740	1569	0.003554	0.011488	0.001205	114	114	114	0	0	1	-360	360	-10.4064	-1.7967	10.4099	1.6709	0.0000	0.0000	0.0000	0.0000;
	1569	1567	0.001322	0.003223	0.000322	90	90	90	0	0	1	-360	360	0.0000	-0.0366	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	925	1042	0.003471	0.011074	0.001159	140	140	140	0	0	1	-360	360	22.6118	5.6476	-22.5960	-5.7360	0.0000	0.0000	0.0000	0.0000;
	926	1043	0.003388	0.011074	0.001154	140	140	140	0	0	1	-360	360	0.0000	-0.1415	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1843	1376	0.009421	0.029917	0.003214	140	140	140	0	0	1	-360	360	17.7902	5.3055	-17.7635	-5.6136	0.0000	0.0000	0.0000	0.0000;
	1646	1473	0.007107	0.022066	0.002517	140	140	140	0	0	1	-360	360	-15.1516	-4.7910	15.1664	4.5347	0.0000	0.0000	0.0000	0.0000;
	1623	1646	0.000992	0.003058	0.000351	114	114	114	0	0	1	-360	360	-15.1495	-4.8789	15.1516	4.8433	0.0000	0.0000	0.0000	0.0000;
	1645	1646	0.00124	0.003636	0.000436	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0523	0.0000	0.0000	0.0000	0.0000;
	1413	985	0.000826	0.002479	0.000295	140	140	140	0	0	1	-360	360	6.5999	-5.7715	-6.5994	5.7389	0.0000	0.0000	0.0000	0.0000;
	1063	1065	0.001818	0.005455	0.000651	29	29	29	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0789	0.0000	0.0000	0.0000	0.0000;
	1555	1206	0.003223	0.010413	0.001079	140	140	140	0	0	1	-360	360	-34.3422	0.5263	34.3752	-0.5444	0.0000	0.0000	0.0000	0.0000;
	1620	1555	0.003719	0.011735	0.001309	140	140	140	0	0	1	-360	360	-34.3042	0.5019	34.3422	-0.5327	0.0000	0.0000	0.0000	0.0000;
	1553	1555	0.002397	0.00719	0.00075	120	120	120	0	0	1	-360	360	-0.0000	-0.0930	0.0000	0.0065	0.0000	0.0000	0.0000	0.0000;
	1763	984	0.01281	0.039008	0.004576	140	140	140	0	0	1	-360	360	6.1167	8.2273	-6.1047	-8.7233	0.0000	0.0000	0.0000	0.0000;
	1927	1286	0.011983	0.038595	0.004056	140	140	140	0	0	1	-360	360	-52.0535	-11.2417	52.3290	11.6258	0.0000	0.0000	0.0000	0.0000;
	1111	1056	0.004959	0.016694	0.001597	140	140	140	0	0	1	-360	360	5.4623	0.6525	-5.4610	-0.8390	0.0000	0.0000	0.0000	0.0000;
	1111	1057	0.003388	0.010248	0.001217	140	140	140	0	0	1	-360	360	6.5302	0.8843	-6.5290	-1.0260	0.0000	0.0000	0.0000	0.0000;
	1711	1686	0.003388	0.011488	0.001096	140	140	140	0	0	1	-360	360	-35.2854	-3.1962	35.3208	3.1841	0.0000	0.0000	0.0000	0.0000;
	1309	1780	0.000165	0.000496	6.1e-05	140	140	140	0	0	1	-360	360	29.3856	1.0726	-29.3844	-1.0758	0.0000	0.0000	0.0000	0.0000;
	1416	1309	0.005289	0.016198	0.001854	140	140	140	0	0	1	-360	360	29.4255	0.9053	-29.3856	-0.9956	0.0000	0.0000	0.0000	0.0000;
	1308	1309	0.004215	0.007603	0.000673	90	90	90	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0770	0.0000	0.0000	0.0000	0.0000;
	863	1546	0.010992	0.027851	0.003979	120	120	120	0	0	1	-360	360	61.8698	15.4553	-61.4967	-14.9832	0.0000	0.0000	0.0000	0.0000;
	863	1760	0.005785	0.020496	0.002033	114	114	114	0	0	1	-360	360	-61.8698	-15.4437	62.0656	15.8919	0.0000	0.0000	0.0000	0.0000;
	862	863	0.000248	0.000826	9.7e-05	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0116	0.0000	0.0000	0.0000	0.0000;
	922	1111	0.000413	0.00124	0.000133	114	114	114	0	0	1	-360	360	-29.8844	-8.3466	29.8877	8.3407	0.0000	0.0000	0.0000	0.0000;
	934	922	0.002727	0.007686	0.000794	120	120	120	0	0	1	-360	360	-29.8624	-8.4333	29.8844	8.4007	0.0000	0.0000	0.0000	0.0000;
	1103	934	0.00438	0.014132	0.001486	114	114	114	0	0	1	-360	360	-28.8792	-8.0727	28.9123	8.0029	0.0000	0.0000	0.0000	0.0000;
	1269	1103	0.000331	0.001074	0.000123	114	114	114	0	0	1	-360	360	-11.6340	-5.5030	11.6345	5.4899	0.0000	0.0000	0.0000	0.0000;
	920	922	0.00124	0.003884	0.000452	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0540	0.0000	0.0000	0.0000	0.0000;
	934	933	0.003388	0.011405	0.001089	114	114	114	0	0	1	-360	360	0.9500	0.4304	-0.9500	-0.5600	0.0000	0.0000	0.0000	0.0000;
	1101	1103	0.002231	0.006942	0.000784	114	114	114	0	0	1	-360	360	-17.2390	-2.6580	17.2447	2.5828	0.0000	0.0000	0.0000	0.0000;
	1929	1229	0.004711	0.014463	0.00165	140	140	140	0	0	1	-360	360	25.1405	6.6358	-25.1145	-6.7578	0.0000	0.0000	0.0000	0.0000;
	1426	1840	0.005289	0.016116	0.001871	140	140	140	0	0	1	-360	360	-18.8350	-8.6958	18.8542	8.5322	0.0000	0.0000	0.0000	0.0000;
	1877	1426	0.002397	0.007273	0.000835	140	140	140	0	0	1	-360	360	-13.9620	-6.6792	13.9668	6.5951	0.0000	0.0000	0.0000	0.0000;
	1426	1425	0.000992	0.00124	0.000242	90	90	90	0	0	1	-360	360	4.8682	2.1006	-4.8680	-2.1290	0.0000	0.0000	0.0000	0.0000;
	1040	1257	0.004959	0.015124	0.001793	140	140	140	0	0	1	-360	360	-4.3956	0.0533	4.3964	-0.2700	0.0000	0.0000	0.0000	0.0000;
	1720	1583	0.002314	0.007355	0.000784	140	140	140	0	0	1	-360	360	-36.0099	-7.5941	36.0363	7.5850	0.0000	0.0000	0.0000	0.0000;
	1198	1644	0.008182	0.020331	0.002188	120	120	120	0	0	1	-360	360	-30.2608	-2.3399	30.3247	2.2401	0.0000	0.0000	0.0000	0.0000;
	1854	1198	0.004711	0.011735	0.001341	120	120	120	0	0	1	-360	360	-25.4836	-1.3874	25.5096	1.2945	0.0000	0.0000	0.0000	0.0000;
	1196	1198	0.000909	0.002066	0.000237	120	120	120	0	0	1	-360	360	-4.7510	-1.0730	4.7512	1.0454	0.0000	0.0000	0.0000	0.0000;
	1636	846	0.006529	0.020661	0.002234	140	140	140	0	0	1	-360	360	50.3039	2.2160	-50.1605	-2.0195	0.0000	0.0000	0.0000	0.0000;
	1807	1281	0.012314	0.041653	0.003976	140	140	140	0	0	1	-360	360	34.0436	9.3542	-33.9122	-9.3728	0.0000	0.0000	0.0000	0.0000;
	945	1634	0.025868	0.067107	0.007543	120	120	120	0	0	1	-360	360	-7.4928	-1.2975	7.5052	0.4363	0.0000	0.0000	0.0000	0.0000;
	1527	973	0.004959	0.015124	0.001769	140	140	140	0	0	1	-360	360	-32.6082	-9.8957	32.6552	9.8219	0.0000	0.0000	0.0000	0.0000;
	1549	1912	0.001405	0.003471	0.000506	120	120	120	0	0	1	-360	360	-1.0948	-13.0749	1.0968	13.0200	0.0000	0.0000	0.0000	0.0000;
	1852	1230	0.004132	0.012975	0.00144	140	140	140	0	0	1	-360	360	-14.0581	-4.0652	14.0653	3.9123	0.0000	0.0000	0.0000	0.0000;
	1841	1674	0.017603	0.056281	0.005973	140	140	140	0	0	1	-360	360	57.4012	12.3334	-56.9077	-11.4818	0.0000	0.0000	0.0000	0.0000;
	1592	926	0.006364	0.020165	0.002188	114	114	114	0	0	1	-360	360	-40.0375	7.9897	40.1243	-7.9825	0.0000	0.0000	0.0000	0.0000;
	917	1546	0.008595	0.027603	0.002909	140	140	140	0	0	1	-360	360	29.2484	4.3893	-29.1849	-4.5292	0.0000	0.0000	0.0000	0.0000;
	1842	1547	0.026198	0.08405	0.008869	114	114	114	0	0	1	-360	360	35.8897	10.8444	-35.5829	-10.9171	0.0000	0.0000	0.0000	0.0000;
	1434	1546	0.040248	0.129587	0.013608	140	140	140	0	0	1	-360	360	7.9483	-0.7653	-7.9269	-0.7735	0.0000	0.0000	0.0000	0.0000;
	1685	976	0.006364	0.02124	0.002072	140	140	140	0	0	1	-360	360	-42.4446	-5.0578	42.5410	5.1291	0.0000	0.0000	0.0000	0.0000;
	1634	1346	0.019752	0.052975	0.005779	120	120	120	0	0	1	-360	360	8.8763	0.8046	-8.8630	-1.4535	0.0000	0.0000	0.0000	0.0000;
	1821	1346	0.001901	0.005868	0.00069	114	114	114	0	0	1	-360	360	-7.6750	-1.3081	7.6760	1.2295	0.0000	0.0000	0.0000	0.0000;
	1144	1821	0.002645	0.008678	0.000895	114	114	114	0	0	1	-360	360	-5.1774	-0.9478	5.1780	0.8440	0.0000	0.0000	0.0000	0.0000;
	1820	1821	8.3e-05	0.000165	1.7e-05	90	90	90	0	0	1	-360	360	-2.4970	-0.4660	2.4970	0.4640	0.0000	0.0000	0.0000	0.0000;
	1258	1843	0.011735	0.037107	0.004029	114	114	114	0	0	1	-360	360	-13.9205	-0.2153	13.9391	-0.2189	0.0000	0.0000	0.0000	0.0000;
	891	1015	0.00562	0.017355	0.001943	120	120	120	0	0	1	-360	360	17.8669	-5.5844	-17.8497	5.4151	0.0000	0.0000	0.0000	0.0000;
	1882	993	0.001901	0.006198	0.000651	114	114	114	0	0	1	-360	360	-29.7216	-0.2056	29.7353	0.1703	0.0000	0.0000	0.0000	0.0000;
	1599	1882	0.003802	0.011983	0.001283	140	140	140	0	0	1	-360	360	-20.6602	1.5361	20.6735	-1.6514	0.0000	0.0000	0.0000	0.0000;
	926	1599	0.002645	0.008182	0.000946	114	114	114	0	0	1	-360	360	-14.1273	2.7788	14.1318	-2.8809	0.0000	0.0000	0.0000	0.0000;
	1880	1882	8.3e-05	0.000165	1.7e-05	140	140	140	0	0	1	-360	360	-9.0480	-1.8590	9.0481	1.8570	0.0000	0.0000	0.0000	0.0000;
	1599	1598	0.00124	0.003802	0.000445	57	57	57	0	0	1	-360	360	6.5285	1.3448	-6.5280	-1.3980	0.0000	0.0000	0.0000	0.0000;
	1367	1477	0.002397	0.007438	0.000859	114	114	114	0	0	1	-360	360	56.9751	6.9127	-56.9099	-6.8143	0.0000	0.0000	0.0000	0.0000;
	1834	938	0.004132	0.013306	0.001411	114	114	114	0	0	1	-360	360	33.2594	7.0846	-33.2203	-7.1306	0.0000	0.0000	0.0000	0.0000;
	972	1834	0.007107	0.023058	0.002403	140	140	140	0	0	1	-360	360	43.9533	9.8910	-43.8361	-9.8057	0.0000	0.0000	0.0000	0.0000;
	1833	1834	0.000744	0.002397	0.000264	114	114	114	0	0	1	-360	360	-10.5760	-2.7510	10.5767	2.7211	0.0000	0.0000	0.0000	0.0000;
	1862	1005	0.000909	0.00281	0.000319	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0395	0.0000	0.0000	0.0000	0.0000;
	1231	1005	0.003141	0.013306	0.001379	162	162	162	0	0	1	-360	360	-41.3995	-9.7149	41.4455	9.7400	0.0000	0.0000	0.0000	0.0000;
	905	1231	0.000413	0.00124	0.000131	140	140	140	0	0	1	-360	360	-11.2900	-2.9380	11.2905	2.9233	0.0000	0.0000	0.0000	0.0000;
	906	1232	0.000413	0.001322	0.000135	140	140	140	0	0	1	-360	360	-6.2950	-1.7250	6.2951	1.7093	0.0000	0.0000	0.0000	0.0000;
	1202	1004	0.000661	0.002562	0.0003	114	114	114	0	0	1	-360	360	-1.4240	-0.3730	1.4240	0.3359	0.0000	0.0000	0.0000	0.0000;
	1362	1895	0.012893	0.046446	0.004487	114	114	114	0	0	1	-360	360	61.3463	19.8894	-60.9155	-18.8897	0.0000	0.0000	0.0000	0.0000;
	1433	1525	0.019422	0.062397	0.006585	114	114	114	0	0	1	-360	360	33.6989	15.7635	-33.4693	-15.7934	0.0000	0.0000	0.0000	0.0000;
	1524	1547	0.020827	0.067025	0.007069	140	140	140	0	0	1	-360	360	-32.6537	-8.1607	32.8579	7.9971	0.0000	0.0000	0.0000	0.0000;
	1826	1416	0.001736	0.004959	0.00053	120	120	120	0	0	1	-360	360	-17.6032	7.2914	17.6087	-7.3366	0.0000	0.0000	0.0000	0.0000;
	1112	965	0.007603	0.023141	0.002713	140	140	140	0	0	1	-360	360	10.0210	7.0130	-10.0116	-7.3153	0.0000	0.0000	0.0000	0.0000;
	1650	1286	0.001736	0.005372	0.000634	140	140	140	0	0	1	-360	360	-0.5940	0.0000	0.5940	-0.0794	0.0000	0.0000	0.0000	0.0000;
	1041	1916	0.004132	0.012645	0.001498	140	140	140	0	0	1	-360	360	4.1596	-0.0372	-4.1590	-0.1440	0.0000	0.0000	0.0000	0.0000;
	1323	853	0.012479	0.039669	0.004279	140	140	140	0	0	1	-360	360	-5.0684	-0.6261	5.0711	0.1181	0.0000	0.0000	0.0000	0.0000;
	1190	1059	0.003471	0.010661	0.001246	140	140	140	0	0	1	-360	360	4.2778	1.0080	-4.2772	-1.1549	0.0000	0.0000	0.0000	0.0000;
	1734	1190	0.003636	0.013388	0.001203	140	140	140	0	0	1	-360	360	-2.7320	-0.7930	2.7322	0.6505	0.0000	0.0000	0.0000	0.0000;
	1188	1190	0	0.000826	7e-06	140	140	140	0	0	1	-360	360	7.0100	1.6580	-7.0100	-1.6585	0.0000	0.0000	0.0000	0.0000;
	1513	1926	0.004711	0.015289	0.001605	140	140	140	0	0	1	-360	360	-36.3036	-6.7483	36.3560	6.7213	0.0000	0.0000	0.0000	0.0000;
	1785	1232	0.004463	0.012893	0.001735	140	140	140	0	0	1	-360	360	9.0156	-1.8001	-9.0124	1.6017	0.0000	0.0000	0.0000	0.0000;
	1362	1482	0.027686	0.071488	0.007393	120	120	120	0	0	1	-360	360	49.0226	5.8263	-48.4807	-5.3367	0.0000	0.0000	0.0000	0.0000;
	852	1508	0.000826	0.002645	0.000305	140	140	140	0	0	1	-360	360	3.9181	0.8965	-3.9180	-0.9330	0.0000	0.0000	0.0000	0.0000;
	853	1509	0.000826	0.002645	0.00031	140	140	140	0	0	1	-360	360	8.6675	1.8293	-8.6670	-1.8650	0.0000	0.0000	0.0000	0.0000;
	1877	1887	0.005537	0.016942	0.00196	140	140	140	0	0	1	-360	360	-12.9166	-6.7755	12.9265	6.5736	0.0000	0.0000	0.0000	0.0000;
	1589	1644	0.006116	0.016612	0.001842	120	120	120	0	0	1	-360	360	-22.9376	-4.0365	22.9656	3.8949	0.0000	0.0000	0.0000	0.0000;
	1504	1546	0.003141	0.009421	0.001118	140	140	140	0	0	1	-360	360	-42.3276	-0.1321	42.3755	0.1441	0.0000	0.0000	0.0000	0.0000;
	854	1588	0.000744	0.002314	0.000254	114	114	114	0	0	1	-360	360	-2.4870	-1.4380	2.4871	1.4082	0.0000	0.0000	0.0000	0.0000;
	855	1589	0.000661	0.002149	0.000237	114	114	114	0	0	1	-360	360	-8.3100	-3.7310	8.3105	3.7045	0.0000	0.0000	0.0000	0.0000;
	1086	1673	0.000331	0.000992	0.000121	114	114	114	0	0	1	-360	360	-4.7490	-1.8650	4.7491	1.8507	0.0000	0.0000	0.0000	0.0000;
	1087	1674	0.000331	0.000992	0.000119	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0142	0.0000	0.0000	0.0000	0.0000;
	1279	852	0.000331	0.000992	0.000114	114	114	114	0	0	1	-360	360	-15.6860	-3.6920	15.6867	3.6804	0.0000	0.0000	0.0000	0.0000;
	1280	853	0.000413	0.001322	0.000157	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0190	0.0000	0.0000	0.0000	0.0000;
	1736	1763	0.004298	0.013306	0.001496	114	114	114	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.1747	0.0000	0.0000	0.0000	0.0000;
	1034	1040	0.000165	0.000579	6.5e-05	114	114	114	0	0	1	-360	360	-0.2360	-0.0000	0.2360	-0.0080	0.0000	0.0000	0.0000	0.0000;
	1035	1041	0.000165	0.000579	6.8e-05	114	114	114	0	0	1	-360	360	0.0000	-0.0000	-0.0000	-0.0083	0.0000	0.0000	0.0000	0.0000;
	1027	1004	0.000661	0.002149	0.000215	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0266	0.0000	0.0000	0.0000	0.0000;
	1028	1005	0.000661	0.002066	0.00021	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0260	0.0000	0.0000	0.0000	0.0000;
	1231	993	0.003554	0.011405	0.001183	114	114	114	0	0	1	-360	360	35.6000	1.8946	-35.5633	-1.9223	0.0000	0.0000	0.0000	0.0000;
	1802	1800	0.004132	0.013306	0.001396	114	114	114	0	0	1	-360	360	13.3550	-0.8116	-13.3489	0.6612	0.0000	0.0000	0.0000	0.0000;
	1338	1844	0.001488	0.004959	0.000469	114	114	114	0	0	1	-360	360	-15.2420	-5.7680	15.2453	5.7220	0.0000	0.0000	0.0000	0.0000;
	1928	1381	0.000992	0.003141	0.000365	114	114	114	0	0	1	-360	360	-25.7340	-6.6404	25.7397	6.6137	0.0000	0.0000	0.0000	0.0000;
	925	1379	0.004876	0.01719	0.001917	114	114	114	0	0	1	-360	360	-34.3577	-6.8440	34.4075	6.7897	0.0000	0.0000	0.0000	0.0000;
	1116	1524	0.004628	0.02157	0.003942	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1834	1276	0.009091	0.029752	0.003151	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1833	1834	8.3e-05	0.000826	0.000169	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1996	2108	0.000636	0.004826	0.000469	137	137	137	0	0	1	-360	360	-52.6432	36.3438	52.6641	-36.2443	0.0000	0.0000	0.0000	0.0000;
	2313	2172	0.033471	0.058934	0.005779	90	90	90	0	0	1	-360	360	-4.2029	-2.3408	4.2092	1.6866	0.0000	0.0000	0.0000	0.0000;
	2441	2172	0.029587	0.054711	0.005031	90	90	90	0	0	1	-360	360	9.3756	1.6824	-9.3522	-2.2216	0.0000	0.0000	0.0000	0.0000;
	2441	2173	0.033058	0.058603	0.005571	90	90	90	0	0	1	-360	360	-14.5906	-2.2434	14.6522	1.7023	0.0000	0.0000	0.0000	0.0000;
	2276	2184	0.048016	0.102636	0.013441	63	63	63	0	0	1	-360	360	-13.4630	7.7788	13.5668	-9.1374	0.0000	0.0000	0.0000	0.0000;
	2184	1948	0.013802	0.024207	0.002299	63	63	63	0	0	1	-360	360	-16.7418	9.6234	16.7860	-9.8158	0.0000	0.0000	0.0000	0.0000;
	2000	1993	0.056364	0.105207	0.01021	90	90	90	0	0	1	-360	360	13.8845	-6.3542	-13.7744	5.3811	0.0000	0.0000	0.0000	0.0000;
	2386	2043	0.058934	0.123967	0.011969	90	90	90	0	0	1	-360	360	-32.9746	9.2126	33.5901	-9.2863	0.0000	0.0000	0.0000	0.0000;
	1995	1984	0.021744	0.05	0.005009	76	76	76	0	0	1	-360	360	2.4976	2.0988	-2.4953	-2.6723	0.0000	0.0000	0.0000	0.0000;
	2141	1984	0.034711	0.067438	0.006631	76	76	76	0	0	1	-360	360	3.7766	-3.8659	-3.7687	3.1173	0.0000	0.0000	0.0000	0.0000;
	1994	1943	0.019711	0.06676	0.006609	120	120	120	0	0	1	-360	360	5.5291	-5.6109	-5.5193	4.8750	0.0000	0.0000	0.0000	0.0000;
	2278	2444	0.03843	0.06562	0.006609	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2322	1950	0.02486	0.043479	0.00415	120	120	120	0	0	1	-360	360	-0.9490	-0.6214	0.9492	0.1137	0.0000	0.0000	0.0000	0.0000;
	2402	2322	0.022628	0.03957	0.00378	120	120	120	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.4626	0.0000	0.0000	0.0000	0.0000;
	2287	1986	0.022281	0.075446	0.00747	137	137	137	0	0	1	-360	360	-37.8699	5.8480	38.1491	-5.7835	0.0000	0.0000	0.0000	0.0000;
	2323	1991	0.025207	0.082636	0.00847	137	137	137	0	0	1	-360	360	-15.7727	5.9923	15.8337	-6.8091	0.0000	0.0000	0.0000	0.0000;
	2316	2352	0.020661	0.06686	0.006921	126	126	126	0	0	1	-360	360	-10.5441	3.4426	10.5658	-4.2002	0.0000	0.0000	0.0000	0.0000;
	2131	2179	0.059669	0.104554	0.009951	87	87	87	0	0	1	-360	360	-30.2503	7.2162	30.7552	-7.4894	0.0000	0.0000	0.0000	0.0000;
	1966	2452	0.027107	0.046124	0.00445	90	90	90	0	0	1	-360	360	-46.6577	5.9591	47.1915	-5.5559	0.0000	0.0000	0.0000	0.0000;
	2306	2452	0.033661	0.114017	0.011289	137	137	137	0	0	1	-360	360	-21.2752	3.4752	21.4139	-4.2950	0.0000	0.0000	0.0000	0.0000;
	2432	2197	0.024132	0.078512	0.008199	137	137	137	0	0	1	-360	360	10.3476	-2.9486	-10.3240	2.0805	0.0000	0.0000	0.0000	0.0000;
	2000	1998	0.018347	0.062562	0.00605	137	137	137	0	0	1	-360	360	-16.7400	-2.5393	16.7852	1.9914	0.0000	0.0000	0.0000	0.0000;
	2128	2227	0.024967	0.08457	0.008371	137	137	137	0	0	1	-360	360	43.6762	-2.4857	-43.2599	2.9437	0.0000	0.0000	0.0000	0.0000;
	2387	2309	0.022355	0.075727	0.007497	137	137	137	0	0	1	-360	360	-54.7108	3.2148	55.2907	-2.1268	0.0000	0.0000	0.0000	0.0000;
	2403	2219	0.016537	0.056008	0.005539	140	140	140	0	0	1	-360	360	-72.5609	-3.9888	73.2736	5.7158	0.0000	0.0000	0.0000	0.0000;
	2368	2403	0.026793	0.090719	0.008981	140	140	140	0	0	1	-360	360	-69.1109	-0.7208	70.1919	3.2993	0.0000	0.0000	0.0000	0.0000;
	2368	2015	0.014446	0.048942	0.00484	137	137	137	0	0	1	-360	360	64.1729	-0.7442	-63.6703	1.8780	0.0000	0.0000	0.0000	0.0000;
	2073	2403	0.020421	0.036157	0.003451	140	140	140	0	0	1	-360	360	-2.3680	-1.1100	2.3691	0.6895	0.0000	0.0000	0.0000	0.0000;
	2333	2208	0.032041	0.108521	0.01074	137	137	137	0	0	1	-360	360	-28.5205	-2.2620	28.7419	1.7309	0.0000	0.0000	0.0000	0.0000;
	2335	2247	0.016124	0.05281	0.005411	114	114	114	0	0	1	-360	360	-32.6482	4.3191	32.8052	-4.4106	0.0000	0.0000	0.0000	0.0000;
	2051	2291	0.016603	0.056231	0.005571	10	10	10	0	0	1	-360	360	7.1465	1.4688	-7.1390	-2.1150	0.0000	0.0000	0.0000	0.0000;
	2221	2136	0.104132	0.168512	0.01897	90	90	90	0	0	1	-360	360	10.7709	0.5363	-10.6670	-2.6000	0.0000	0.0000	0.0000	0.0000;
	2220	2401	0.033058	0.049587	0.00605	76	76	76	0	0	1	-360	360	-15.0100	-0.7721	15.0726	0.1427	0.0000	0.0000	0.0000	0.0000;
	2401	2082	0.1	0.165289	0.01822	76	76	76	0	0	1	-360	360	-18.4502	0.7352	18.7364	-2.4792	0.0000	0.0000	0.0000	0.0000;
	2153	2401	0.015703	0.046281	0.005009	76	76	76	0	0	1	-360	360	-3.3760	0.2810	3.3775	-0.8779	0.0000	0.0000	0.0000	0.0000;
	2207	1969	0.033802	0.055372	0.005951	67	67	67	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2137	2081	0.028934	0.047107	0.0053	90	90	90	0	0	1	-360	360	-1.8750	-0.7540	1.8759	0.0998	0.0000	0.0000	0.0000	0.0000;
	2397	2392	0.000554	0.001818	0.026831	118	118	118	0	0	1	-360	360	-17.0580	-5.3400	17.0594	2.1035	0.0000	0.0000	0.0000	0.0000;
	2329	1970	0.011983	0.040562	0.00401	137	137	137	0	0	1	-360	360	8.6160	3.3690	-8.6075	-3.8332	0.0000	0.0000	0.0000	0.0000;
	2273	2384	0.002661	0.009017	0.000891	137	137	137	0	0	1	-360	360	-22.3640	-3.0460	22.3751	2.9745	0.0000	0.0000	0.0000	0.0000;
	2274	2385	0.002661	0.009017	0.000891	137	137	137	0	0	1	-360	360	-2.0830	-0.3390	2.0831	0.2298	0.0000	0.0000	0.0000	0.0000;
	2382	2082	0.003314	0.005793	0.00061	90	90	90	0	0	1	-360	360	-3.1383	-1.1186	3.1386	1.0440	0.0000	0.0000	0.0000	0.0000;
	2393	2382	0.009917	0.022314	0.00242	90	90	90	0	0	1	-360	360	-1.9300	-0.9080	1.9303	0.6106	0.0000	0.0000	0.0000	0.0000;
	2384	2081	0.02562	0.043802	0.00455	90	90	90	0	0	1	-360	360	-41.3102	9.6713	41.6878	-9.5859	0.0000	0.0000	0.0000	0.0000;
	2384	1970	0.004132	0.006612	0.000731	90	90	90	0	0	1	-360	360	2.3471	-14.7918	-2.3396	14.7142	0.0000	0.0000	0.0000	0.0000;
	2392	2385	0.018182	0.035537	0.003901	90	90	90	0	0	1	-360	360	-39.1214	-10.3275	39.3670	10.3321	0.0000	0.0000	0.0000	0.0000;
	2385	1969	0.004132	0.006612	0.000731	90	90	90	0	0	1	-360	360	-43.3541	-12.3419	43.4224	12.3610	0.0000	0.0000	0.0000	0.0000;
	2421	2217	0.008769	0.029686	0.00294	137	137	137	0	0	1	-360	360	-17.9543	-4.5254	17.9786	4.2438	0.0000	0.0000	0.0000	0.0000;
	2329	2421	0.004446	0.01505	0.001491	137	137	137	0	0	1	-360	360	-14.1110	-3.7840	14.1187	3.6263	0.0000	0.0000	0.0000	0.0000;
	2391	2421	0.004967	0.016827	0.00167	137	137	137	0	0	1	-360	360	-3.8350	-1.1030	3.8356	0.8991	0.0000	0.0000	0.0000	0.0000;
	2269	1969	0.015703	0.047934	0.00515	137	137	137	0	0	1	-360	360	14.4158	-7.5733	-14.3826	7.0392	0.0000	0.0000	0.0000	0.0000;
	2269	2216	0.007438	0.023967	0.00257	137	137	137	0	0	1	-360	360	-32.7238	4.9943	32.7900	-5.0980	0.0000	0.0000	0.0000	0.0000;
	2398	2360	0.015703	0.027273	0.00264	137	137	137	0	0	1	-360	360	-31.4096	-12.5873	31.5543	12.5098	0.0000	0.0000	0.0000	0.0000;
	2390	2216	0.007438	0.02562	0.002781	137	137	137	0	0	1	-360	360	-33.7253	-1.4586	33.7942	1.3534	0.0000	0.0000	0.0000	0.0000;
	2390	2374	0.001653	0.004132	0.000409	137	137	137	0	0	1	-360	360	-0.7647	-4.6974	0.7650	4.6479	0.0000	0.0000	0.0000	0.0000;
	2398	2374	0.009091	0.028099	0.003071	137	137	137	0	0	1	-360	360	17.3006	8.5553	-17.2730	-8.8489	0.0000	0.0000	0.0000	0.0000;
	2375	2217	0.009091	0.029752	0.00319	137	137	137	0	0	1	-360	360	1.1974	11.4268	-1.1874	-11.7908	0.0000	0.0000	0.0000	0.0000;
	2375	2361	0.009091	0.028099	0.003071	137	137	137	0	0	1	-360	360	-3.4004	-12.3348	3.4120	11.9866	0.0000	0.0000	0.0000	0.0000;
	2216	2204	0.023141	0.058678	0.00574	120	120	120	0	0	1	-360	360	16.0966	2.1586	-16.0469	-2.7385	0.0000	0.0000	0.0000	0.0000;
	2339	2217	0.013719	0.044463	0.00439	137	137	137	0	0	1	-360	360	-56.3217	-0.9085	56.6775	1.5210	0.0000	0.0000	0.0000	0.0000;
	2217	2208	0.022314	0.071818	0.00702	137	137	137	0	0	1	-360	360	50.6347	9.6734	-50.1548	-8.9868	0.0000	0.0000	0.0000	0.0000;
	2422	2217	0.024893	0.084322	0.008349	120	120	120	0	0	1	-360	360	-28.9028	5.7197	29.0789	-6.1563	0.0000	0.0000	0.0000	0.0000;
	2372	2422	0.01362	0.046124	0.004569	120	120	120	0	0	1	-360	360	-28.8074	5.4788	28.9028	-5.7197	0.0000	0.0000	0.0000	0.0000;
	2285	2422	0.004537	0.015372	0.00152	120	120	120	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2284	2216	0.029496	0.099901	0.009891	137	137	137	0	0	1	-360	360	-38.2070	-20.8330	38.6783	21.2400	0.0000	0.0000	0.0000	0.0000;
	2055	2180	0.007521	0.012562	0.0013	57	57	57	0	0	1	-360	360	-0.3320	-0.1990	0.3320	0.0412	0.0000	0.0000	0.0000	0.0000;
	2339	2179	0.062149	0.105041	0.01058	90	90	90	0	0	1	-360	360	45.7687	-3.1385	-44.7012	3.6744	0.0000	0.0000	0.0000	0.0000;
	2444	2204	0.039669	0.069421	0.00666	90	90	90	0	0	1	-360	360	-6.7360	-0.9460	6.7509	0.1585	0.0000	0.0000	0.0000	0.0000;
	2396	2360	0.004959	0.015703	0.000801	90	90	90	0	0	1	-360	360	-33.6475	-12.5250	33.6987	12.5870	0.0000	0.0000	0.0000	0.0000;
	2412	1970	0.01438	0.02405	0.00249	90	90	90	0	0	1	-360	360	-32.7563	0.8258	32.8831	-0.9181	0.0000	0.0000	0.0000	0.0000;
	2208	2412	0.03876	0.064628	0.006679	90	90	90	0	0	1	-360	360	-22.9111	2.8808	23.0836	-3.4020	0.0000	0.0000	0.0000	0.0000;
	2412	2180	0.011653	0.02124	0.00221	90	90	90	0	0	1	-360	360	9.6727	2.5761	-9.6630	-2.8272	0.0000	0.0000	0.0000	0.0000;
	2082	2049	0.01157	0.019826	0.001941	90	90	90	0	0	1	-360	360	-26.6676	-15.2007	26.7557	15.1112	0.0000	0.0000	0.0000	0.0000;
	2049	2361	0.007942	0.015909	0.001529	90	90	90	0	0	1	-360	360	-27.7837	-15.7272	27.8485	15.6660	0.0000	0.0000	0.0000	0.0000;
	2381	2081	0.003314	0.005793	0.000549	90	90	90	0	0	1	-360	360	9.4945	2.6988	-9.4919	-2.7623	0.0000	0.0000	0.0000	0.0000;
	2381	2229	0.009091	0.017364	0.00165	90	90	90	0	0	1	-360	360	-23.7365	-6.9168	23.7813	6.7973	0.0000	0.0000	0.0000	0.0000;
	2395	2082	0.01157	0.018934	0.002011	90	90	90	0	0	1	-360	360	-19.7246	0.7485	19.7614	-0.9359	0.0000	0.0000	0.0000	0.0000;
	2396	2081	0.01157	0.018934	0.001909	90	90	90	0	0	1	-360	360	25.8771	8.7927	-25.8076	-8.9162	0.0000	0.0000	0.0000	0.0000;
	2396	2048	0.000826	0.002479	0.000271	90	90	90	0	0	1	-360	360	7.0164	2.9924	-7.0160	-3.0250	0.0000	0.0000	0.0000	0.0000;
	2380	2360	0.006967	0.023603	0.00234	137	137	137	0	0	1	-360	360	-2.2940	-0.6290	2.2943	0.3366	0.0000	0.0000	0.0000	0.0000;
	2377	2361	0.01157	0.036364	0.003991	120	120	120	0	0	1	-360	360	-37.9554	-18.3499	38.1215	18.3756	0.0000	0.0000	0.0000	0.0000;
	2376	2379	0.007066	0.02395	0.002369	137	137	137	0	0	1	-360	360	25.3431	4.5319	-25.3050	-4.6940	0.0000	0.0000	0.0000	0.0000;
	2377	2315	0.02562	0.082636	0.00854	137	137	137	0	0	1	-360	360	-0.0529	6.2374	0.0624	-7.2544	0.0000	0.0000	0.0000	0.0000;
	2315	2268	0.021488	0.069421	0.00711	120	120	120	0	0	1	-360	360	-11.4104	5.2044	11.4390	-5.9795	0.0000	0.0000	0.0000	0.0000;
	2360	2228	0.009917	0.017364	0.001721	90	90	90	0	0	1	-360	360	29.8207	8.2724	-29.7448	-8.3546	0.0000	0.0000	0.0000	0.0000;
	2395	2376	0.019826	0.033802	0.003291	90	90	90	0	0	1	-360	360	0.7876	-5.7685	-0.7825	5.3723	0.0000	0.0000	0.0000	0.0000;
	2082	1969	0.028934	0.047107	0.005271	90	90	90	0	0	1	-360	360	-15.1031	6.6918	15.1682	-7.2362	0.0000	0.0000	0.0000	0.0000;
	1944	2082	0.005	0.008793	0.00084	90	90	90	0	0	1	-360	360	-35.8198	-3.7806	35.8726	3.7700	0.0000	0.0000	0.0000	0.0000;
	2453	2304	0.028099	0.04876	0.00477	90	90	90	0	0	1	-360	360	15.3948	-1.1406	-15.3399	0.6577	0.0000	0.0000	0.0000	0.0000;
	1944	2453	0.023	0.040273	0.003841	90	90	90	0	0	1	-360	360	24.6318	1.2626	-24.5178	-1.5324	0.0000	0.0000	0.0000	0.0000;
	2352	2208	0.025463	0.084959	0.00635	137	137	137	0	0	1	-360	360	-20.5268	1.2812	20.6171	-1.7419	0.0000	0.0000	0.0000	0.0000;
	2032	2150	0.037711	0.127744	0.012649	137	137	137	0	0	1	-360	360	10.1966	-10.6743	-10.1278	9.4844	0.0000	0.0000	0.0000	0.0000;
	2227	2032	0.028959	0.100876	0.00999	137	137	137	0	0	1	-360	360	36.3479	-3.6747	-36.0066	3.7423	0.0000	0.0000	0.0000	0.0000;
	2250	2242	0.080661	0.142066	0.013479	120	120	120	0	0	1	-360	360	-37.9247	6.7544	38.9756	-6.4796	0.0000	0.0000	0.0000	0.0000;
	2378	2000	0.041157	0.104463	0.01043	120	120	120	0	0	1	-360	360	8.0942	-10.8543	-8.0326	9.8125	0.0000	0.0000	0.0000	0.0000;
	2445	2378	0.058083	0.103752	0.00991	90	90	90	0	0	1	-360	360	-4.7277	-3.5012	4.7436	2.4045	0.0000	0.0000	0.0000	0.0000;
	2387	2192	0.025041	0.042893	0.004281	120	120	120	0	0	1	-360	360	8.8201	-13.2209	-8.7669	12.8144	0.0000	0.0000	0.0000	0.0000;
	2338	2308	0.016612	0.053802	0.005571	91	91	91	0	0	1	-360	360	30.7891	-2.4746	-30.6516	2.2810	0.0000	0.0000	0.0000	0.0000;
	1989	2341	0.015703	0.05157	0.00528	137	137	137	0	0	1	-360	360	-13.9852	0.3488	14.0125	-0.8562	0.0000	0.0000	0.0000	0.0000;
	2237	2341	0.024793	0.081322	0.008339	120	120	120	0	0	1	-360	360	24.3672	-0.7880	-24.2385	0.2612	0.0000	0.0000	0.0000	0.0000;
	2411	2150	0.03843	0.070413	0.00652	90	90	90	0	0	1	-360	360	18.7388	-9.8032	-18.5897	9.3369	0.0000	0.0000	0.0000	0.0000;
	2411	2386	0.002066	0.003636	0.000339	90	90	90	0	0	1	-360	360	-24.9673	10.3576	24.9806	-10.3726	0.0000	0.0000	0.0000	0.0000;
	2411	2018	0.04843	0.07405	0.00689	90	90	90	0	0	1	-360	360	6.2286	-0.5544	-6.2120	-0.2000	0.0000	0.0000	0.0000	0.0000;
	2187	2007	0.002917	0.009876	0.00098	120	120	120	0	0	1	-360	360	-11.3610	-5.9770	11.3650	5.8721	0.0000	0.0000	0.0000	0.0000;
	2006	1988	0.006033	0.017851	0.00183	120	120	120	0	0	1	-360	360	2.5020	18.4152	-2.4845	-18.5837	0.0000	0.0000	0.0000	0.0000;
	2355	2017	0.042066	0.141322	0.013939	120	120	120	0	0	1	-360	360	-23.9907	1.4185	24.2035	-2.3130	0.0000	0.0000	0.0000	0.0000;
	2355	1972	0.029917	0.101364	0.010031	120	120	120	0	0	1	-360	360	9.9647	0.2651	-9.9387	-1.3237	0.0000	0.0000	0.0000	0.0000;
	2238	1972	0.011653	0.03957	0.00392	91	91	91	0	0	1	-360	360	10.9981	1.7830	-10.9853	-2.1873	0.0000	0.0000	0.0000	0.0000;
	1954	2231	0.003719	0.012479	0.001159	120	120	120	0	0	1	-360	360	-8.9842	5.4155	8.9877	-5.5403	0.0000	0.0000	0.0000	0.0000;
	1987	1978	0.005372	0.015124	0.001529	120	120	120	0	0	1	-360	360	11.4639	-28.7642	-11.4212	28.7004	0.0000	0.0000	0.0000	0.0000;
	2358	2265	0.004132	0.01405	0.001379	137	137	137	0	0	1	-360	360	-12.8914	9.6624	12.9004	-9.7960	0.0000	0.0000	0.0000	0.0000;
	2007	1978	0.000744	0.002314	0.00024	137	137	137	0	0	1	-360	360	-10.6592	26.4870	10.6642	-26.5004	0.0000	0.0000	0.0000	0.0000;
	2434	2270	0.007107	0.019422	0.002011	120	120	120	0	0	1	-360	360	-17.6572	13.9883	17.6879	-14.1423	0.0000	0.0000	0.0000	0.0000;
	1936	2006	0.004992	0.016909	0.001469	137	137	137	0	0	1	-360	360	-24.5065	-28.0110	24.5642	28.0299	0.0000	0.0000	0.0000	0.0000;
	2415	2237	0.019174	0.063876	0.00598	137	137	137	0	0	1	-360	360	-15.6889	-0.0092	15.7304	-0.5347	0.0000	0.0000	0.0000	0.0000;
	2415	2263	0.003802	0.012636	0.001191	137	137	137	0	0	1	-360	360	18.2700	-1.2302	-18.2588	1.1320	0.0000	0.0000	0.0000	0.0000;
	2415	2235	0.001157	0.003802	0.00038	137	137	137	0	0	1	-360	360	-2.5811	1.2394	2.5812	-1.2823	0.0000	0.0000	0.0000	0.0000;
	2443	2061	0.014554	0.053141	0.00523	137	137	137	0	0	1	-360	360	3.3826	-3.5452	-3.3798	2.9641	0.0000	0.0000	0.0000	0.0000;
	2178	2394	0.020083	0.068182	0.00674	10	10	10	0	0	1	-360	360	-1.9300	-0.6450	1.9306	-0.1825	0.0000	0.0000	0.0000	0.0000;
	2206	2061	0.017107	0.057686	0.00567	137	137	137	0	0	1	-360	360	-3.1630	0.9710	3.1648	-1.6071	0.0000	0.0000	0.0000	0.0000;
	2307	2150	0.031959	0.055893	0.005329	90	90	90	0	0	1	-360	360	-17.1498	13.7330	17.2877	-14.0972	0.0000	0.0000	0.0000	0.0000;
	2307	2072	0.018479	0.032322	0.003081	90	90	90	0	0	1	-360	360	7.1138	-15.4330	-7.0678	15.1616	0.0000	0.0000	0.0000	0.0000;
	2072	2050	0.029008	0.051653	0.004891	90	90	90	0	0	1	-360	360	-7.8558	-4.7857	7.8765	4.2601	0.0000	0.0000	0.0000	0.0000;
	2183	2050	0.016612	0.029496	0.00288	90	90	90	0	0	1	-360	360	15.0171	7.0114	-14.9775	-7.2751	0.0000	0.0000	0.0000	0.0000;
	2263	2232	0.007934	0.026777	0.00264	137	137	137	0	0	1	-360	360	1.1218	2.8570	-1.1211	-3.1545	0.0000	0.0000	0.0000	0.0000;
	2235	2232	0.008636	0.017298	0.00166	90	90	90	0	0	1	-360	360	14.9780	0.6630	-14.9609	-0.8175	0.0000	0.0000	0.0000	0.0000;
	2203	1947	0.037603	0.067603	0.00651	90	90	90	0	0	1	-360	360	-31.7664	-0.7795	32.0920	0.5983	0.0000	0.0000	0.0000	0.0000;
	2236	2077	0.014132	0.046281	0.004751	137	137	137	0	0	1	-360	360	50.0188	12.6309	-49.7024	-12.1547	0.0000	0.0000	0.0000	0.0000;
	2209	2025	0.01	0.034793	0.00317	120	120	120	0	0	1	-360	360	17.3898	2.4052	-17.3632	-2.6808	0.0000	0.0000	0.0000	0.0000;
	2434	1936	0.006099	0.020653	0.00204	137	137	137	0	0	1	-360	360	-7.6218	-23.7383	7.6535	23.6030	0.0000	0.0000	0.0000	0.0000;
	2156	1957	0.022132	0.07514	0.00742	91	91	91	0	0	1	-360	360	42.5741	6.3488	-42.2093	-5.9359	0.0000	0.0000	0.0000	0.0000;
	2277	1957	0.046777	0.057934	0.00462	91	91	91	0	0	1	-360	360	-32.9241	-3.1760	33.4043	3.2709	0.0000	0.0000	0.0000	0.0000;
	2314	2312	0.053876	0.094298	0.008981	90	90	90	0	0	1	-360	360	-3.3151	2.0128	3.3235	-2.9899	0.0000	0.0000	0.0000	0.0000;
	2197	2025	0.041397	0.083554	0.00786	90	90	90	0	0	1	-360	360	-2.4940	-2.7915	2.4982	1.8918	0.0000	0.0000	0.0000	0.0000;
	2259	2230	0.009678	0.032793	0.00325	137	137	137	0	0	1	-360	360	-32.6997	-15.5729	32.8062	15.5455	0.0000	0.0000	0.0000	0.0000;
	1988	1946	0.011653	0.034628	0.00356	90	90	90	0	0	1	-360	360	40.5837	0.2693	-40.4238	-0.2194	0.0000	0.0000	0.0000	0.0000;
	2253	1988	0.022041	0.074669	0.007391	91	91	91	0	0	1	-360	360	-15.2653	-8.0800	15.3197	7.3841	0.0000	0.0000	0.0000	0.0000;
	2008	2253	0.012141	0.041124	0.00407	91	91	91	0	0	1	-360	360	-9.3755	-10.3917	9.3953	9.9800	0.0000	0.0000	0.0000	0.0000;
	2324	2192	0.040331	0.068934	0.006921	91	91	91	0	0	1	-360	360	0.0905	11.9913	-0.0381	-12.7144	0.0000	0.0000	0.0000	0.0000;
	2378	2250	0.033636	0.085446	0.008741	91	91	91	0	0	1	-360	360	-19.6603	3.7076	19.7794	-4.4053	0.0000	0.0000	0.0000	0.0000;
	2417	2237	0.016686	0.035289	0.00341	90	90	90	0	0	1	-360	360	-22.2417	2.7506	22.3154	-2.9836	0.0000	0.0000	0.0000	0.0000;
	2417	2371	0.057603	0.122149	0.01179	90	90	90	0	0	1	-360	360	22.2417	-2.7506	-21.9891	1.9558	0.0000	0.0000	0.0000	0.0000;
	2417	2235	8e-06	8.3e-05	0	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2378	2308	0.035289	0.060331	0.00605	90	90	90	0	0	1	-360	360	-9.2735	3.4671	9.3046	-4.1050	0.0000	0.0000	0.0000	0.0000;
	2039	2150	0.068083	0.124397	0.01294	90	90	90	0	0	1	-360	360	-23.4156	0.8877	23.7550	-1.7159	0.0000	0.0000	0.0000	0.0000;
	2312	2039	0.004298	0.010281	0.00143	90	90	90	0	0	1	-360	360	-11.3865	-0.5101	11.3916	0.3643	0.0000	0.0000	0.0000	0.0000;
	2241	2077	0.016124	0.05405	0.005319	120	120	120	0	0	1	-360	360	33.2704	-0.5162	-33.1187	0.4017	0.0000	0.0000	0.0000	0.0000;
	2387	2169	0.039669	0.069339	0.006631	90	90	90	0	0	1	-360	360	25.9137	9.5641	-25.6500	-9.8603	0.0000	0.0000	0.0000	0.0000;
	2296	2241	0.023967	0.042231	0.004141	90	90	90	0	0	1	-360	360	-6.8584	-14.3065	6.9089	13.9116	0.0000	0.0000	0.0000	0.0000;
	2296	2072	0.046446	0.081744	0.00801	90	90	90	0	0	1	-360	360	-1.1886	9.8245	1.2315	-10.6729	0.0000	0.0000	0.0000	0.0000;
	1965	2242	0.02276	0.077099	0.00763	120	120	120	0	0	1	-360	360	-31.1538	-2.3667	31.3428	2.1051	0.0000	0.0000	0.0000	0.0000;
	2324	2189	0.01124	0.038182	0.00378	91	91	91	0	0	1	-360	360	15.1394	5.7738	-15.1142	-6.1338	0.0000	0.0000	0.0000	0.0000;
	2313	2250	0.023471	0.057851	0.005929	91	91	91	0	0	1	-360	360	-4.6961	2.5378	4.7023	-3.2032	0.0000	0.0000	0.0000	0.0000;
	2238	2235	0.009826	0.033223	0.003279	137	137	137	0	0	1	-360	360	32.2445	-0.7063	-32.1551	0.6343	0.0000	0.0000	0.0000	0.0000;
	2017	2008	0.013934	0.047207	0.004671	91	91	91	0	0	1	-360	360	-2.2530	-8.8765	2.2625	8.3637	0.0000	0.0000	0.0000	0.0000;
	2016	2015	0.006876	0.023281	0.002299	120	120	120	0	0	1	-360	360	-47.9102	4.4934	48.0473	-4.2970	0.0000	0.0000	0.0000	0.0000;
	2314	2169	0.034298	0.06	0.00574	90	90	90	0	0	1	-360	360	-18.9959	-6.0108	19.1180	5.5843	0.0000	0.0000	0.0000	0.0000;
	2156	2150	0.003893	0.013223	0.0013	91	91	91	0	0	1	-360	360	-58.8741	-7.5708	58.9958	7.8371	0.0000	0.0000	0.0000	0.0000;
	2443	2238	0.060496	0.118182	0.011589	90	90	90	0	0	1	-360	360	-17.6286	2.6412	17.8008	-3.6222	0.0000	0.0000	0.0000	0.0000;
	2338	2077	0.013719	0.044463	0.0046	91	91	91	0	0	1	-360	360	-53.3211	-0.5834	53.6600	1.1490	0.0000	0.0000	0.0000	0.0000;
	2254	2006	0.00519	0.014132	0.00143	120	120	120	0	0	1	-360	360	-53.3320	-20.4761	53.4735	20.6897	0.0000	0.0000	0.0000	0.0000;
	2371	2177	0.067438	0.118017	0.01126	10	10	10	0	0	1	-360	360	6.1781	-1.0218	-6.1550	-0.1930	0.0000	0.0000	0.0000	0.0000;
	1965	2209	0.014521	0.049174	0.004869	90	90	90	0	0	1	-360	360	25.4728	2.0667	-25.3918	-2.3612	0.0000	0.0000	0.0000	0.0000;
	2254	2188	0.001818	0.004554	0.00046	91	91	91	0	0	1	-360	360	5.5875	1.3463	-5.5870	-1.4000	0.0000	0.0000	0.0000	0.0000;
	2230	2007	0.002587	0.00876	0.000871	137	137	137	0	0	1	-360	360	-44.0002	-17.8255	44.0486	17.8844	0.0000	0.0000	0.0000	0.0000;
	2236	2260	0.001901	0.006033	0.00061	137	137	137	0	0	1	-360	360	-18.3530	-12.7942	18.3610	12.7468	0.0000	0.0000	0.0000	0.0000;
	2231	2130	0.001744	0.004793	0.000479	120	120	120	0	0	1	-360	360	-21.7267	2.5963	21.7338	-2.6332	0.0000	0.0000	0.0000	0.0000;
	2236	1987	0.00686	0.021984	0.00228	137	137	137	0	0	1	-360	360	-48.4238	-3.0586	48.5592	3.2201	0.0000	0.0000	0.0000	0.0000;
	2283	2203	0.017017	0.055124	0.005711	137	137	137	0	0	1	-360	360	-18.6496	-2.3359	18.7014	1.8405	0.0000	0.0000	0.0000	0.0000;
	2270	2261	0.010281	0.021636	0.002101	90	90	90	0	0	1	-360	360	-33.6889	12.9423	33.8025	-12.9515	0.0000	0.0000	0.0000	0.0000;
	2324	2006	0.011256	0.038141	0.00378	91	91	91	0	0	1	-360	360	-36.8159	-20.5871	36.9844	20.7062	0.0000	0.0000	0.0000	0.0000;
	2418	2259	0.003033	0.010289	0.001019	120	120	120	0	0	1	-360	360	-16.2179	-9.0197	16.2267	8.9289	0.0000	0.0000	0.0000	0.0000;
	1954	2418	0.006174	0.017364	0.00174	120	120	120	0	0	1	-360	360	-16.1998	-9.1745	16.2179	9.0197	0.0000	0.0000	0.0000	0.0000;
	2434	2418	4.1e-05	0.000141	1e-05	120	120	120	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2242	2010	0.007314	0.012793	0.00122	90	90	90	0	0	1	-360	360	17.4773	4.8905	-17.4570	-5.0000	0.0000	0.0000	0.0000	0.0000;
	2241	2264	0.009587	0.024744	0.00251	120	120	120	0	0	1	-360	360	19.1563	3.9863	-19.1250	-4.2000	0.0000	0.0000	0.0000	0.0000;
	2242	2265	0.009587	0.024744	0.00251	120	120	120	0	0	1	-360	360	20.9877	-7.8908	-20.9474	7.6960	0.0000	0.0000	0.0000	0.0000;
	2160	2241	0.013438	0.023826	0.00227	90	90	90	0	0	1	-360	360	-16.3861	0.9595	16.4170	-1.1713	0.0000	0.0000	0.0000	0.0000;
	2262	2160	0.006983	0.012793	0.00098	90	90	90	0	0	1	-360	360	-15.8980	0.4723	15.9131	-0.5595	0.0000	0.0000	0.0000	0.0000;
	2242	2057	0.005744	0.019438	0.001919	137	137	137	0	0	1	-360	360	58.1221	5.8402	-57.9575	-5.5106	0.0000	0.0000	0.0000	0.0000;
	2260	2190	0.003388	0.010992	0.00114	137	137	137	0	0	1	-360	360	-30.5491	-22.3941	30.5898	22.3894	0.0000	0.0000	0.0000	0.0000;
	2190	2007	0.00281	0.009091	0.000939	137	137	137	0	0	1	-360	360	-44.6018	-26.4704	44.6646	26.5606	0.0000	0.0000	0.0000	0.0000;
	2262	2189	0.014752	0.049984	0.004949	90	90	90	0	0	1	-360	360	-4.5065	-3.3115	4.5102	2.7438	0.0000	0.0000	0.0000	0.0000;
	2358	2260	0.00405	0.013388	0.001379	137	137	137	0	0	1	-360	360	0.6934	-6.9406	-0.6918	6.7813	0.0000	0.0000	0.0000	0.0000;
	2445	1989	0.010314	0.017967	0.001711	90	90	90	0	0	1	-360	360	-0.8243	2.9012	0.8252	-3.0928	0.0000	0.0000	0.0000	0.0000;
	2355	2283	0.039504	0.072314	0.007279	90	90	90	0	0	1	-360	360	-5.0041	-4.2036	5.0176	3.3899	0.0000	0.0000	0.0000	0.0000;
	2254	1985	0.001653	0.005372	0.000549	137	137	137	0	0	1	-360	360	26.9155	10.6638	-26.9039	-10.6917	0.0000	0.0000	0.0000	0.0000;
	2358	1985	0.001818	0.00595	0.000629	137	137	137	0	0	1	-360	360	-8.0621	-7.3259	8.0639	7.2567	0.0000	0.0000	0.0000	0.0000;
	2130	2057	0.00405	0.013314	0.001379	137	137	137	0	0	1	-360	360	-40.9528	-1.2328	41.0105	1.2596	0.0000	0.0000	0.0000	0.0000;
	2262	2011	0.020347	0.035578	0.0034	90	90	90	0	0	1	-360	360	11.0315	3.4443	-11.0080	-3.8000	0.0000	0.0000	0.0000	0.0000;
	2261	2183	0.022719	0.039727	0.00379	90	90	90	0	0	1	-360	360	29.2019	6.6149	-29.0291	-6.7574	0.0000	0.0000	0.0000	0.0000;
	2442	1933	0.001289	0.003744	0.00038	114	114	114	0	0	1	-360	360	-66.6619	-3.6860	66.7085	3.7743	0.0000	0.0000	0.0000	0.0000;
	1971	2442	0.028331	0.073488	0.007451	108	108	108	0	0	1	-360	360	-56.0548	0.3013	56.7959	0.7140	0.0000	0.0000	0.0000	0.0000;
	2068	1971	0.029669	0.076612	0.007771	108	108	108	0	0	1	-360	360	-51.9475	0.4109	52.6318	0.4347	0.0000	0.0000	0.0000	0.0000;
	2333	2078	0.028256	0.095702	0.00947	137	137	137	0	0	1	-360	360	20.7335	0.3040	-20.6305	-1.0675	0.0000	0.0000	0.0000	0.0000;
	2215	2024	0.017289	0.058554	0.005801	137	137	137	0	0	1	-360	360	-12.9760	-6.0726	13.0057	5.4891	0.0000	0.0000	0.0000	0.0000;
	2405	2069	0.007017	0.017521	0.000779	126	126	126	0	0	1	-360	360	11.3593	2.2120	-11.3515	-2.2854	0.0000	0.0000	0.0000	0.0000;
	2405	2213	0.023876	0.067107	0.00621	126	126	126	0	0	1	-360	360	-13.2626	-4.7511	13.3016	4.1143	0.0000	0.0000	0.0000	0.0000;
	2405	2143	0.003554	0.009587	0.000801	126	126	126	0	0	1	-360	360	1.9033	2.5391	-1.9030	-2.6340	0.0000	0.0000	0.0000	0.0000;
	2024	2214	0.027372	0.092132	0.009121	140	140	140	0	0	1	-360	360	-19.6667	-6.8881	19.7654	6.1293	0.0000	0.0000	0.0000	0.0000;
	2215	2078	0.017917	0.061438	0.006009	137	137	137	0	0	1	-360	360	1.2110	3.5476	-1.2085	-4.2425	0.0000	0.0000	0.0000	0.0000;
	2214	2131	0.037934	0.097521	0.00999	108	108	108	0	0	1	-360	360	54.1037	7.6342	-53.1628	-6.3944	0.0000	0.0000	0.0000	0.0000;
	2199	2095	0.013223	0.032893	0.00347	114	114	114	0	0	1	-360	360	23.3290	-12.3860	-23.2541	12.1476	0.0000	0.0000	0.0000	0.0000;
	2340	1932	0.005041	0.014132	0.00145	108	108	108	0	0	1	-360	360	-57.7044	5.7064	57.8407	-5.5052	0.0000	0.0000	0.0000	0.0000;
	2161	2440	0.037438	0.096529	0.009891	108	108	108	0	0	1	-360	360	-8.4549	-12.4328	8.5224	11.4306	0.0000	0.0000	0.0000	0.0000;
	2161	2060	0.020174	0.049587	0.00508	108	108	108	0	0	1	-360	360	5.9859	12.2698	-5.9526	-12.7809	0.0000	0.0000	0.0000	0.0000;
	2090	2059	0.015289	0.049669	0.005179	91	91	91	0	0	1	-360	360	4.2905	-5.3350	-4.2847	4.7557	0.0000	0.0000	0.0000	0.0000;
	2096	1976	0.033314	0.079818	0.007831	108	108	108	0	0	1	-360	360	72.7888	3.0579	-71.3693	-0.6130	0.0000	0.0000	0.0000	0.0000;
	2404	2218	0.038141	0.066711	0.00636	81	81	81	0	0	1	-360	360	-18.4858	-6.2765	18.6023	5.6895	0.0000	0.0000	0.0000	0.0000;
	2074	2404	0.000686	0.002347	0.00023	81	81	81	0	0	1	-360	360	-17.0650	-5.1000	17.0668	5.0777	0.0000	0.0000	0.0000	0.0000;
	2093	2404	8.3e-05	0.000141	1e-05	81	81	81	0	0	1	-360	360	-1.4190	-1.2000	1.4190	1.1988	0.0000	0.0000	0.0000	0.0000;
	2058	2219	0.013636	0.023802	0.00227	69	69	69	0	0	1	-360	360	-11.5180	1.6210	11.5328	-1.8797	0.0000	0.0000	0.0000	0.0000;
	2071	2219	0.008678	0.015124	0.00145	69	69	69	0	0	1	-360	360	-23.3410	-5.6190	23.3810	5.5073	0.0000	0.0000	0.0000	0.0000;
	2219	2096	0.005372	0.015446	0.00181	204	204	204	0	0	1	-360	360	47.4890	9.4314	-47.3885	-9.3688	0.0000	0.0000	0.0000	0.0000;
	2099	2059	0.02843	0.052066	0.00498	87	87	87	0	0	1	-360	360	14.6372	-5.7739	-14.5773	5.3068	0.0000	0.0000	0.0000	0.0000;
	2272	2099	0.02843	0.052066	0.00498	87	87	87	0	0	1	-360	360	18.0499	-4.4455	-17.9662	4.0199	0.0000	0.0000	0.0000	0.0000;
	2214	2210	0.003876	0.006686	0.000629	87	87	87	0	0	1	-360	360	11.8567	2.1441	-11.8520	-2.2120	0.0000	0.0000	0.0000	0.0000;
	2213	2212	0.007603	0.018017	0.001791	87	87	87	0	0	1	-360	360	38.7029	2.9495	-38.6081	-2.9404	0.0000	0.0000	0.0000	0.0000;
	2309	1976	0.011686	0.03957	0.003918	137	137	137	0	0	1	-360	360	-68.2517	0.6328	68.7133	0.4650	0.0000	0.0000	0.0000	0.0000;
	2357	2218	0.003967	0.029174	0.002829	274	274	274	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2356	2046	0.000992	0.007934	0.00077	171	171	171	0	0	1	-360	360	-30.5332	-13.6409	30.5423	13.6194	0.0000	0.0000	0.0000	0.0000;
	2147	1937	0.02676	0.076893	0.00772	120	120	120	0	0	1	-360	360	57.0371	-9.5608	-56.2860	10.8070	0.0000	0.0000	0.0000	0.0000;
	2095	2046	0.000504	0.003967	0.000559	274	274	274	0	0	1	-360	360	8.8577	8.0940	-8.8571	-8.1578	0.0000	0.0000	0.0000	0.0000;
	2097	2046	0.000504	0.003967	0.000559	160	160	160	0	0	1	-360	360	-3.2973	-22.5945	3.2995	22.5430	0.0000	0.0000	0.0000	0.0000;
	1934	1935	0.00276	0.004826	0.00046	69	69	69	0	0	1	-360	360	-4.7560	-2.0000	4.7566	1.9445	0.0000	0.0000	0.0000	0.0000;
	1935	1933	0.013512	0.023488	0.002241	69	69	69	0	0	1	-360	360	-9.8856	-4.4445	9.8984	4.1903	0.0000	0.0000	0.0000	0.0000;
	2105	2087	0.009091	0.026446	0.002691	111	111	111	0	0	1	-360	360	8.7181	1.1803	-8.7122	-1.4841	0.0000	0.0000	0.0000	0.0000;
	2094	1933	0.031983	0.081066	0.008279	111	111	111	0	0	1	-360	360	-33.0046	-4.5785	33.2976	4.3099	0.0000	0.0000	0.0000	0.0000;
	2138	2094	0.006917	0.019223	0.001941	111	111	111	0	0	1	-360	360	-22.7328	-1.6175	22.7626	1.4665	0.0000	0.0000	0.0000	0.0000;
	2068	2066	0.005041	0.014207	0.0015	114	114	114	0	0	1	-360	360	37.1185	0.0501	-37.0591	-0.0582	0.0000	0.0000	0.0000	0.0000;
	1940	2138	0.01395	0.039983	0.00401	111	111	111	0	0	1	-360	360	-16.3407	0.1409	16.3718	-0.5335	0.0000	0.0000	0.0000	0.0000;
	2105	1940	0.01657	0.048901	0.004901	111	111	111	0	0	1	-360	360	-16.0211	-0.2393	16.0567	-0.2419	0.0000	0.0000	0.0000	0.0000;
	2060	2059	0.003802	0.012149	0.001229	119	119	119	0	0	1	-360	360	-2.2134	12.7839	2.2190	-12.9085	0.0000	0.0000	0.0000	0.0000;
	1934	1932	0.00157	0.002727	0.000259	77	77	77	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2214	2205	0.017934	0.058182	0.006031	126	126	126	0	0	1	-360	360	7.0231	5.8075	-7.0101	-6.4907	0.0000	0.0000	0.0000	0.0000;
	2272	2213	0.06438	0.113802	0.01096	81	81	81	0	0	1	-360	360	-34.6529	0.9565	35.3177	-1.0818	0.0000	0.0000	0.0000	0.0000;
	2131	2129	0.002397	0.004132	0.00039	90	90	90	0	0	1	-360	360	14.8449	-3.6664	-14.8400	3.6299	0.0000	0.0000	0.0000	0.0000;
	2062	1932	0.014711	0.037364	0.003821	102	102	102	0	0	1	-360	360	-38.1148	-5.4391	38.2913	5.4131	0.0000	0.0000	0.0000	0.0000;
	2122	2062	0.025041	0.063636	0.007241	102	102	102	0	0	1	-360	360	-34.1730	-3.9046	34.4168	3.6391	0.0000	0.0000	0.0000	0.0000;
	2212	2211	0.016612	0.029174	0.002781	77	77	77	0	0	1	-360	360	20.1321	-0.5186	-20.0760	0.2840	0.0000	0.0000	0.0000	0.0000;
	2316	2205	0.01438	0.046529	0.004811	126	126	126	0	0	1	-360	360	8.8361	-4.1466	-8.8249	3.6067	0.0000	0.0000	0.0000	0.0000;
	2362	2199	0.036686	0.094298	0.009849	102	102	102	0	0	1	-360	360	38.9136	-8.9184	-38.4430	8.9180	0.0000	0.0000	0.0000	0.0000;
	2383	2079	0.029826	0.054628	0.00552	87	87	87	0	0	1	-360	360	-1.0959	6.1973	1.1073	-6.8058	0.0000	0.0000	0.0000	0.0000;
	2142	1992	0.003017	0.01	0.001019	126	126	126	0	0	1	-360	360	-13.6690	-3.6920	13.6742	3.5912	0.0000	0.0000	0.0000	0.0000;
	2070	1992	0.001612	0.005289	0.00054	126	126	126	0	0	1	-360	360	19.8629	4.1983	-19.8572	-4.2422	0.0000	0.0000	0.0000	0.0000;
	2070	2066	0.016446	0.042984	0.004431	114	114	114	0	0	1	-360	360	-20.6643	1.2441	20.7251	-1.6008	0.0000	0.0000	0.0000	0.0000;
	2224	2095	0.010331	0.03405	0.00348	114	114	114	0	0	1	-360	360	-36.1945	-12.0767	36.3185	12.0619	0.0000	0.0000	0.0000	0.0000;
	2362	2340	0.022893	0.062149	0.00636	102	102	102	0	0	1	-360	360	-42.8046	7.6704	43.1564	-7.5034	0.0000	0.0000	0.0000	0.0000;
	2129	2090	0.017521	0.05438	0.005641	91	91	91	0	0	1	-360	360	10.0970	-4.0039	-10.0795	3.4080	0.0000	0.0000	0.0000	0.0000;
	2280	2224	0.014628	0.047934	0.00491	126	126	126	0	0	1	-360	360	-24.6289	-9.4142	24.7135	9.1017	0.0000	0.0000	0.0000	0.0000;
	2332	2280	0.022066	0.071488	0.00747	126	126	126	0	0	1	-360	360	-19.3200	-7.6334	19.3999	7.0082	0.0000	0.0000	0.0000	0.0000;
	2332	2070	0.017603	0.056942	0.00575	126	126	126	0	0	1	-360	360	12.9850	7.0334	-12.9516	-7.5965	0.0000	0.0000	0.0000	0.0000;
	2302	2095	0.016223	0.041793	0.00424	120	120	120	0	0	1	-360	360	-77.2937	2.8612	78.1019	-1.2934	0.0000	0.0000	0.0000	0.0000;
	2191	2096	0.009752	0.032066	0.003291	108	108	108	0	0	1	-360	360	-18.7962	-13.6321	18.8384	13.3626	0.0000	0.0000	0.0000	0.0000;
	2440	2191	0.034876	0.094876	0.009721	108	108	108	0	0	1	-360	360	-9.9954	-12.6076	10.0662	11.6151	0.0000	0.0000	0.0000	0.0000;
	2131	2128	0.006529	0.022066	0.002161	91	91	91	0	0	1	-360	360	54.1332	-0.4084	-53.9672	0.7207	0.0000	0.0000	0.0000	0.0000;
	2302	2147	0.013479	0.039289	0.00394	120	120	120	0	0	1	-360	360	65.6717	-5.9562	-65.1841	6.9068	0.0000	0.0000	0.0000	0.0000;
	2302	2094	0.026198	0.08595	0.008809	126	126	126	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2141	1993	0.046686	0.095446	0.00939	76	76	76	0	0	1	-360	360	-10.0326	3.5879	10.0804	-4.5721	0.0000	0.0000	0.0000	0.0000;
	2123	1994	0.033967	0.059422	0.00567	90	90	90	0	0	1	-360	360	-12.2953	-2.2648	12.3410	1.6893	0.0000	0.0000	0.0000	0.0000;
	2300	2019	0.027364	0.091818	0.00907	90	90	90	0	0	1	-360	360	-30.1392	-2.8791	30.3495	2.4962	0.0000	0.0000	0.0000	0.0000;
	2321	2020	0.02719	0.087934	0.009099	137	137	137	0	0	1	-360	360	-37.2815	-0.1799	37.6019	0.1332	0.0000	0.0000	0.0000	0.0000;
	2123	2036	0.029669	0.049256	0.004859	90	90	90	0	0	1	-360	360	-17.8477	4.5958	17.9360	-5.0099	0.0000	0.0000	0.0000	0.0000;
	2321	1998	0.025207	0.081818	0.009169	137	137	137	0	0	1	-360	360	28.6395	-0.1611	-28.4643	-0.3449	0.0000	0.0000	0.0000	0.0000;
	2413	2054	0.059446	0.103983	0.00992	76	76	76	0	0	1	-360	360	-33.5880	5.3828	34.1737	-5.5442	0.0000	0.0000	0.0000	0.0000;
	1948	2413	0.018769	0.032818	0.003129	76	76	76	0	0	1	-360	360	-26.7040	3.8798	26.8207	-4.0442	0.0000	0.0000	0.0000	0.0000;
	2185	2413	0.021107	0.071504	0.007081	76	76	76	0	0	1	-360	360	-6.7590	0.5310	6.7673	-1.3386	0.0000	0.0000	0.0000	0.0000;
	2410	2019	0.024727	0.054	0.00523	90	90	90	0	0	1	-360	360	4.0593	-6.1446	-4.0489	5.5352	0.0000	0.0000	0.0000	0.0000;
	2323	2410	0.053826	0.110008	0.010609	90	90	90	0	0	1	-360	360	8.4637	-6.7783	-8.4147	5.6009	0.0000	0.0000	0.0000	0.0000;
	2163	2410	0.00257	0.004488	0.000431	90	90	90	0	0	1	-360	360	-4.3550	-0.5950	4.3554	0.5437	0.0000	0.0000	0.0000	0.0000;
	2054	2019	0.001397	0.004628	0.00046	76	76	76	0	0	1	-360	360	-45.7477	6.2382	45.7723	-6.2123	0.0000	0.0000	0.0000	0.0000;
	2288	2287	0.026612	0.086612	0.00899	137	137	137	0	0	1	-360	360	-32.6921	4.5682	32.9419	-4.8080	0.0000	0.0000	0.0000	0.0000;
	2300	2173	0.021984	0.073802	0.007359	90	90	90	0	0	1	-360	360	26.5522	2.5811	-26.4202	-3.0073	0.0000	0.0000	0.0000	0.0000;
	2399	2020	0.020149	0.048843	0.00476	90	90	90	0	0	1	-360	360	-32.1075	5.1319	32.2867	-5.2671	0.0000	0.0000	0.0000	0.0000;
	1938	2399	0.000397	0.000694	6.5e-05	90	90	90	0	0	1	-360	360	0.0000	-0.0000	-0.0000	-0.0078	0.0000	0.0000	0.0000	0.0000;
	2409	2399	0.012091	0.021141	0.002018	90	90	90	0	0	1	-360	360	-32.0005	5.0712	32.1075	-5.1241	0.0000	0.0000	0.0000	0.0000;
	2162	2409	0.001975	0.003455	0.000329	90	90	90	0	0	1	-360	360	-4.4520	-0.4400	4.4523	0.4015	0.0000	0.0000	0.0000	0.0000;
	1994	2409	0.069529	0.121603	0.011602	90	90	90	0	0	1	-360	360	-27.0901	4.9116	27.5481	-5.4727	0.0000	0.0000	0.0000	0.0000;
	2288	2036	0.031488	0.052149	0.00515	76	76	76	0	0	1	-360	360	23.4921	-5.0482	-23.3370	4.7069	0.0000	0.0000	0.0000	0.0000;
	2031	2019	0.010397	0.037041	0.002819	90	90	90	0	0	1	-360	360	-42.3595	0.6798	42.5147	-0.4669	0.0000	0.0000	0.0000	0.0000;
	2030	2031	0.003752	0.006562	0.000629	90	90	90	0	0	1	-360	360	-34.4492	2.1504	34.4865	-2.1608	0.0000	0.0000	0.0000	0.0000;
	2023	2030	0.007107	0.012438	0.001191	90	90	90	0	0	1	-360	360	-18.9976	4.5342	19.0202	-4.6374	0.0000	0.0000	0.0000	0.0000;
	2035	2020	0.004149	0.007256	0.00069	90	90	90	0	0	1	-360	360	1.4289	-8.9932	-1.4260	8.9154	0.0000	0.0000	0.0000	0.0000;
	2022	2035	0.006521	0.011397	0.001089	90	90	90	0	0	1	-360	360	5.7105	-5.8844	-5.7069	5.7602	0.0000	0.0000	0.0000	0.0000;
	2181	1990	0.019826	0.055041	0.005951	76	76	76	0	0	1	-360	360	16.4172	-0.3123	-16.3726	-0.2761	0.0000	0.0000	0.0000	0.0000;
	2420	2334	0.010934	0.030479	0.003071	120	120	120	0	0	1	-360	360	-6.7959	-12.8623	6.8149	12.5464	0.0000	0.0000	0.0000	0.0000;
	1990	2420	0.003752	0.010248	0.001031	120	120	120	0	0	1	-360	360	2.1400	-11.5554	-2.1357	11.4440	0.0000	0.0000	0.0000	0.0000;
	2433	2420	0.003826	0.006686	0.000639	120	120	120	0	0	1	-360	360	-8.9290	-1.4900	8.9316	1.4182	0.0000	0.0000	0.0000	0.0000;
	2454	2258	0.011727	0.030521	0.00303	90	90	90	0	0	1	-360	360	-8.3103	2.3766	8.3176	-2.7217	0.0000	0.0000	0.0000	0.0000;
	2454	2182	0.040231	0.102769	0.01021	90	90	90	0	0	1	-360	360	7.9303	-2.5766	-7.9079	1.4072	0.0000	0.0000	0.0000	0.0000;
	2331	2182	0.028603	0.053223	0.00515	76	76	76	0	0	1	-360	360	-20.2084	-10.6895	20.3339	10.3108	0.0000	0.0000	0.0000	0.0000;
	1964	1996	9.1e-05	0.000686	7e-05	120	120	120	0	0	1	-360	360	-88.2441	-14.0884	88.2499	14.1235	0.0000	0.0000	0.0000	0.0000;
	2027	1964	0.005554	0.018182	0.001861	120	120	120	0	0	1	-360	360	-87.8889	-13.1568	88.2441	14.0884	0.0000	0.0000	0.0000	0.0000;
	2257	2013	0.025603	0.078397	0.008061	90	90	90	0	0	1	-360	360	-0.5328	-0.4951	0.5329	-0.4744	0.0000	0.0000	0.0000	0.0000;
	2258	2034	0.006612	0.018256	0.001941	120	120	120	0	0	1	-360	360	36.5587	9.7375	-36.4799	-9.7525	0.0000	0.0000	0.0000	0.0000;
	2336	2013	0.009603	0.024744	0.00251	69	69	69	0	0	1	-360	360	-6.1550	-3.0900	6.1587	2.7980	0.0000	0.0000	0.0000	0.0000;
	2240	2336	0.001711	0.005157	0.00052	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2298	2013	0.006281	0.010578	0.001079	90	90	90	0	0	1	-360	360	-2.8960	-0.1000	2.8964	-0.0291	0.0000	0.0000	0.0000	0.0000;
	2435	2014	0.017769	0.03157	0.003011	90	90	90	0	0	1	-360	360	-37.7865	-6.2446	38.0060	6.2752	0.0000	0.0000	0.0000	0.0000;
	2182	2167	0.027058	0.091636	0.00907	90	90	90	0	0	1	-360	360	36.1886	0.4766	-35.8931	-0.5550	0.0000	0.0000	0.0000	0.0000;
	2200	2167	0.020777	0.038017	0.00364	90	90	90	0	0	1	-360	360	-31.6307	-0.6585	31.8091	0.5580	0.0000	0.0000	0.0000	0.0000;
	2200	2009	0.041521	0.074289	0.0071	90	90	90	0	0	1	-360	360	12.6267	-1.6655	-12.5694	0.9433	0.0000	0.0000	0.0000	0.0000;
	2282	2009	0.050174	0.087744	0.008371	90	90	90	0	0	1	-360	360	-9.9678	1.2515	10.0124	-2.1393	0.0000	0.0000	0.0000	0.0000;
	2331	1995	0.044628	0.094207	0.009629	76	76	76	0	0	1	-360	360	7.8684	6.5885	-7.8256	-7.6218	0.0000	0.0000	0.0000	0.0000;
	2389	2281	0.024793	0.080413	0.00832	137	137	137	0	0	1	-360	360	-11.2579	0.0780	11.2870	-0.8837	0.0000	0.0000	0.0000	0.0000;
	2281	2171	0.037686	0.065537	0.006241	90	90	90	0	0	1	-360	360	-18.1650	-1.2963	18.2800	0.8146	0.0000	0.0000	0.0000	0.0000;
	2171	2021	0.065372	0.114876	0.01096	90	90	90	0	0	1	-360	360	-18.7530	-1.0706	18.9622	0.2187	0.0000	0.0000	0.0000	0.0000;
	2239	2014	0.011438	0.030231	0.003059	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2027	1990	0.020579	0.067603	0.005689	137	137	137	0	0	1	-360	360	76.4999	8.4828	-75.5114	-5.9259	0.0000	0.0000	0.0000	0.0000;
	2426	2249	0.01314	0.025537	0.002461	90	90	90	0	0	1	-360	360	-43.3300	-7.2149	43.5485	7.3524	0.0000	0.0000	0.0000	0.0000;
	2194	2337	0.019471	0.06595	0.006529	137	137	137	0	0	1	-360	360	-2.8440	-1.3750	2.8456	0.6599	0.0000	0.0000	0.0000	0.0000;
	2359	1973	0.021818	0.071066	0.007369	137	137	137	0	0	1	-360	360	40.9724	10.1958	-40.6544	-10.0544	0.0000	0.0000	0.0000	0.0000;
	2351	2258	0.00486	0.016446	0.001631	120	120	120	0	0	1	-360	360	-26.6568	-6.2882	26.6872	6.1952	0.0000	0.0000	0.0000	0.0000;
	1945	2257	0.002281	0.007719	0.00076	137	137	137	0	0	1	-360	360	-17.3429	-4.9899	17.3491	4.9195	0.0000	0.0000	0.0000	0.0000;
	2282	2186	0.023058	0.057364	0.005871	120	120	120	0	0	1	-360	360	14.5983	0.3887	-14.5555	-0.9554	0.0000	0.0000	0.0000	0.0000;
	2144	2014	0.003893	0.01319	0.001307	137	137	137	0	0	1	-360	360	-4.2905	-0.8892	4.2912	0.7342	0.0000	0.0000	0.0000	0.0000;
	1945	2144	0.010107	0.034248	0.00339	137	137	137	0	0	1	-360	360	-2.2061	-1.0741	2.2065	0.6682	0.0000	0.0000	0.0000	0.0000;
	2195	2013	0.007802	0.026413	0.002621	137	137	137	0	0	1	-360	360	-17.1478	-3.4529	17.1677	3.2054	0.0000	0.0000	0.0000	0.0000;
	2351	2195	0.003174	0.010727	0.00106	137	137	137	0	0	1	-360	360	-4.6872	-1.3148	4.6878	1.1899	0.0000	0.0000	0.0000	0.0000;
	2334	2257	0.00595	0.020157	0.001999	120	120	120	0	0	1	-360	360	12.3931	1.4536	-12.3854	-1.6681	0.0000	0.0000	0.0000	0.0000;
	2248	2034	0.012893	0.033719	0.00333	120	120	120	0	0	1	-360	360	-18.0971	-6.3727	18.1369	6.0805	0.0000	0.0000	0.0000	0.0000;
	2282	2091	0.033967	0.058099	0.00559	82	82	82	0	0	1	-360	360	24.3313	0.8500	-24.1561	-1.1884	0.0000	0.0000	0.0000	0.0000;
	2091	2012	0.069256	0.12157	0.011739	90	90	90	0	0	1	-360	360	16.4631	0.4704	-16.2966	-1.4931	0.0000	0.0000	0.0000	0.0000;
	2426	2021	0.039826	0.069669	0.00666	90	90	90	0	0	1	-360	360	35.7450	3.7489	-35.3002	-3.7317	0.0000	0.0000	0.0000	0.0000;
	2389	2327	0.007521	0.018347	0.00196	90	90	90	0	0	1	-360	360	7.3689	1.0320	-7.3650	-1.2340	0.0000	0.0000	0.0000	0.0000;
	2330	2328	0.007521	0.018347	0.00196	90	90	90	0	0	1	-360	360	7.7260	1.0866	-7.7220	-1.3000	0.0000	0.0000	0.0000	0.0000;
	2337	2012	0.018182	0.058843	0.00612	137	137	137	0	0	1	-360	360	-9.1986	0.1211	9.2126	-0.7529	0.0000	0.0000	0.0000	0.0000;
	2249	1990	0.009256	0.018603	0.00181	90	90	90	0	0	1	-360	360	-74.3845	-13.6314	74.8350	14.3225	0.0000	0.0000	0.0000	0.0000;
	2276	2181	0.069421	0.140496	0.01368	90	90	90	0	0	1	-360	360	4.6280	-10.7598	-4.5570	9.2769	0.0000	0.0000	0.0000	0.0000;
	2330	2186	0.011066	0.027438	0.00281	120	120	120	0	0	1	-360	360	-9.7130	-1.9036	9.7225	1.6064	0.0000	0.0000	0.0000	0.0000;
	2359	1996	0.012893	0.041984	0.004361	137	137	137	0	0	1	-360	360	-44.5744	-9.8578	44.7923	10.0270	0.0000	0.0000	0.0000	0.0000;
	2297	2170	0.008017	0.021744	0.0022	90	90	90	0	0	1	-360	360	-2.7190	-0.1300	2.7195	-0.1325	0.0000	0.0000	0.0000	0.0000;
	2170	2014	0.00843	0.022984	0.002321	90	90	90	0	0	1	-360	360	-10.8855	-2.8155	10.8943	2.5608	0.0000	0.0000	0.0000	0.0000;
	2181	2157	0.022636	0.073554	0.007621	137	137	137	0	0	1	-360	360	5.5669	0.2172	-5.5610	-1.1110	0.0000	0.0000	0.0000	0.0000;
	1973	1943	0.031802	0.079793	0.00779	137	137	137	0	0	1	-360	360	21.1134	10.8994	-20.9607	-11.4370	0.0000	0.0000	0.0000	0.0000;
	2182	1975	0.050331	0.133876	0.01203	90	90	90	0	0	1	-360	360	31.7608	3.1362	-31.3314	-3.4134	0.0000	0.0000	0.0000	0.0000;
	2363	1975	0.028512	0.09843	0.008959	137	137	137	0	0	1	-360	360	-10.0487	-3.7620	10.0764	2.8244	0.0000	0.0000	0.0000	0.0000;
	2282	2181	0.034298	0.245446	0.024079	120	120	120	0	0	1	-360	360	-35.9888	-5.0322	36.3790	4.9945	0.0000	0.0000	0.0000	0.0000;
	2435	2248	0.008182	0.021488	0.00212	120	120	120	0	0	1	-360	360	2.7195	-1.2994	-2.7189	1.0497	0.0000	0.0000	0.0000	0.0000;
	2430	2148	0.04876	0.069421	0.01254	120	120	120	0	0	1	-360	360	30.3796	-4.9360	-30.0015	3.9680	0.0000	0.0000	0.0000	0.0000;
	2275	2431	0.019793	0.036289	0.00348	90	90	90	0	0	1	-360	360	-2.2770	-0.7990	2.2779	0.3789	0.0000	0.0000	0.0000	0.0000;
	2400	2431	0.023636	0.059917	0.006181	120	120	120	0	0	1	-360	360	-4.4630	2.5871	4.4686	-3.3229	0.0000	0.0000	0.0000	0.0000;
	2400	2005	0.001818	0.004628	0.000469	120	120	120	0	0	1	-360	360	9.1163	1.1772	-9.1150	-1.2310	0.0000	0.0000	0.0000	0.0000;
	1952	2400	0.00405	0.013058	0.00136	120	120	120	0	0	1	-360	360	4.6545	3.6029	-4.6533	-3.7643	0.0000	0.0000	0.0000	0.0000;
	2431	2428	0.022314	0.07557	0.00748	137	137	137	0	0	1	-360	360	15.2390	0.5957	-15.1960	-1.3543	0.0000	0.0000	0.0000	0.0000;
	2304	2430	0.028347	0.095041	0.00937	137	137	137	0	0	1	-360	360	1.8069	-3.4307	-1.8042	2.3054	0.0000	0.0000	0.0000	0.0000;
	2430	2201	0.030248	0.101653	0.010019	120	120	120	0	0	1	-360	360	21.5843	0.3271	-21.4679	-1.1437	0.0000	0.0000	0.0000	0.0000;
	2431	2310	0.027273	0.091653	0.00901	137	137	137	0	0	1	-360	360	15.6204	-2.0330	-15.5650	1.1290	0.0000	0.0000	0.0000	0.0000;
	2326	2447	0.015703	0.027273	0.00286	69	69	69	0	0	1	-360	360	29.0455	1.6163	-28.9368	-1.7762	0.0000	0.0000	0.0000	0.0000;
	2353	2233	0.012008	0.026711	0.002589	120	120	120	0	0	1	-360	360	11.1184	-0.4100	-11.1061	0.1246	0.0000	0.0000	0.0000	0.0000;
	2325	2353	0.011273	0.025479	0.002471	90	90	90	0	0	1	-360	360	19.6869	2.2795	-19.6504	-2.4963	0.0000	0.0000	0.0000	0.0000;
	2325	2305	0.008099	0.027422	0.00272	120	120	120	0	0	1	-360	360	12.7502	5.6965	-12.7371	-5.9817	0.0000	0.0000	0.0000	0.0000;
	2325	2319	0.029752	0.042066	0.004039	69	69	69	0	0	1	-360	360	37.6536	5.0986	-37.2993	-5.0829	0.0000	0.0000	0.0000	0.0000;
	2326	2271	0.049587	0.086777	0.009	69	69	69	0	0	1	-360	360	20.1062	0.1994	-19.9422	-1.0043	0.0000	0.0000	0.0000	0.0000;
	2271	2221	0.042066	0.070248	0.00733	69	69	69	0	0	1	-360	360	14.7292	-0.2617	-14.6533	-0.4887	0.0000	0.0000	0.0000	0.0000;
	1952	2326	0.038983	0.103132	0.01043	120	120	120	0	0	1	-360	360	-13.3005	0.4799	13.3576	-1.6008	0.0000	0.0000	0.0000	0.0000;
	2294	2325	0.014669	0.040397	0.00628	120	120	120	0	0	1	-360	360	-20.9529	-3.1589	21.0073	2.5484	0.0000	0.0000	0.0000	0.0000;
	2319	2063	0.05124	0.081818	0.009489	90	90	90	0	0	1	-360	360	6.9021	-0.7048	-6.8815	-0.3864	0.0000	0.0000	0.0000	0.0000;
	1955	1941	0.006612	0.019826	0.002299	137	137	137	0	0	1	-360	360	-8.2538	-1.9953	8.2577	1.7278	0.0000	0.0000	0.0000	0.0000;
	2325	2225	0.01405	0.027273	0.002781	90	90	90	0	0	1	-360	360	8.5597	1.5478	-8.5509	-1.8679	0.0000	0.0000	0.0000	0.0000;
	2225	1956	0.024793	0.042984	0.00423	90	90	90	0	0	1	-360	360	0.4889	0.7106	-0.4886	-1.2224	0.0000	0.0000	0.0000	0.0000;
	2166	1955	0.032231	0.055372	0.003071	90	90	90	0	0	1	-360	360	-0.1871	-1.6042	0.1877	1.2327	0.0000	0.0000	0.0000	0.0000;
	2326	1941	0.01762	0.041347	0.00402	90	90	90	0	0	1	-360	360	18.7290	1.9574	-18.6778	-2.3275	0.0000	0.0000	0.0000	0.0000;
	1956	2233	0.011347	0.035091	0.003461	137	137	137	0	0	1	-360	360	16.2247	-0.0441	-16.2000	-0.2977	0.0000	0.0000	0.0000	0.0000;
	2364	1956	0.009917	0.020661	0.00218	91	91	91	0	0	1	-360	360	-17.6913	-0.8899	17.7171	0.6802	0.0000	0.0000	0.0000	0.0000;
	2067	1956	0.017529	0.059364	0.005881	137	137	137	0	0	1	-360	360	6.8474	-2.5502	-6.8399	1.8639	0.0000	0.0000	0.0000	0.0000;
	2364	2286	0.009917	0.023141	0.002611	91	91	91	0	0	1	-360	360	15.6703	-1.6051	-15.6499	1.3379	0.0000	0.0000	0.0000	0.0000;
	2286	2201	0.033802	0.080992	0.009271	91	91	91	0	0	1	-360	360	12.6169	-2.2769	-12.5714	1.2725	0.0000	0.0000	0.0000	0.0000;
	2301	2028	0.028099	0.089256	0.00924	114	114	114	0	0	1	-360	360	-13.2656	-0.6801	13.3070	-0.2968	0.0000	0.0000	0.0000	0.0000;
	2168	2028	0.01405	0.044628	0.0046	120	120	120	0	0	1	-360	360	25.2444	-1.9750	-25.1700	1.6565	0.0000	0.0000	0.0000	0.0000;
	2301	2201	0.018182	0.041322	0.004649	114	114	114	0	0	1	-360	360	-15.5864	3.3013	15.6253	-3.7693	0.0000	0.0000	0.0000	0.0000;
	2168	1955	0.01157	0.028099	0.00286	120	120	120	0	0	1	-360	360	-25.2444	1.8310	25.3058	-2.0283	0.0000	0.0000	0.0000	0.0000;
	2311	2301	0.007438	0.023141	0.002401	114	114	114	0	0	1	-360	360	-0.5680	-0.6070	0.5680	0.3201	0.0000	0.0000	0.0000	0.0000;
	2301	2075	0.024793	0.034711	0.004189	90	90	90	0	0	1	-360	360	23.3520	-1.5944	-23.2385	1.2546	0.0000	0.0000	0.0000	0.0000;
	2076	1967	0.037934	0.066124	0.006411	90	90	90	0	0	1	-360	360	-6.8991	0.7373	6.9147	-1.4709	0.0000	0.0000	0.0000	0.0000;
	2001	2076	0.038529	0.068058	0.0065	90	90	90	0	0	1	-360	360	-9.2154	1.7199	9.2446	-2.4372	0.0000	0.0000	0.0000	0.0000;
	2132	2001	0.025149	0.045496	0.004371	120	120	120	0	0	1	-360	360	-5.4110	0.5298	5.4174	-1.0339	0.0000	0.0000	0.0000	0.0000;
	2148	1967	0.01405	0.044628	0.00484	120	120	120	0	0	1	-360	360	18.6205	-5.1832	-18.5767	4.7467	0.0000	0.0000	0.0000	0.0000;
	2051	2305	0.008256	0.016529	0.001941	120	120	120	0	0	1	-360	360	-5.7055	-2.3901	5.7081	2.1607	0.0000	0.0000	0.0000	0.0000;
	2004	2294	0.037636	0.097041	0.00984	120	120	120	0	0	1	-360	360	-8.3520	-0.3250	8.3739	-0.8025	0.0000	0.0000	0.0000	0.0000;
	2051	2447	0.01676	0.056777	0.005619	120	120	120	0	0	1	-360	360	-14.8730	-1.2628	14.9038	0.6869	0.0000	0.0000	0.0000	0.0000;
	2139	2431	0.013347	0.045198	0.00447	120	120	120	0	0	1	-360	360	-8.2480	0.7918	8.2556	-1.3078	0.0000	0.0000	0.0000	0.0000;
	2439	2175	0.013173	0.044603	0.004419	137	137	137	0	0	1	-360	360	-28.5615	-5.1870	28.6505	4.9369	0.0000	0.0000	0.0000	0.0000;
	1983	1950	0.042827	0.097868	0.00953	90	90	90	0	0	1	-360	360	4.3520	2.6012	-4.3419	-3.7499	0.0000	0.0000	0.0000	0.0000;
	2175	1951	0.054893	0.14743	0.01489	120	120	120	0	0	1	-360	360	20.2721	2.5788	-20.0868	-3.9254	0.0000	0.0000	0.0000	0.0000;
	2176	1949	0.049016	0.127529	0.01292	120	120	120	0	0	1	-360	360	33.9978	-2.3659	-33.5444	1.9455	0.0000	0.0000	0.0000	0.0000;
	2349	2175	0.005141	0.035124	0.007899	229	229	229	0	0	1	-360	360	42.2567	-6.8738	-42.1819	6.3946	0.0000	0.0000	0.0000	0.0000;
	2349	2176	0.005141	0.035124	0.007899	232	232	232	0	0	1	-360	360	-16.9268	4.6822	16.9396	-5.5843	0.0000	0.0000	0.0000	0.0000;
	2175	2145	0.032231	0.077686	0.0044	137	137	137	0	0	1	-360	360	29.0534	3.1127	-28.8336	-3.1295	0.0000	0.0000	0.0000	0.0000;
	2176	1962	0.027273	0.068603	0.00666	120	120	120	0	0	1	-360	360	5.2029	-0.5672	-5.1970	-0.2510	0.0000	0.0000	0.0000	0.0000;
	2345	2343	0.003314	0.009917	0.00099	137	137	137	0	0	1	-360	360	20.8798	16.4731	-20.8610	-16.5400	0.0000	0.0000	0.0000	0.0000;
	2350	2342	0.004132	0.009091	0.000939	137	137	137	0	0	1	-360	360	13.2818	9.4247	-13.2730	-9.5230	0.0000	0.0000	0.0000	0.0000;
	2349	2345	0.004132	0.009917	0.00099	137	137	137	0	0	1	-360	360	26.7544	20.1325	-26.7174	-20.1675	0.0000	0.0000	0.0000	0.0000;
	2349	2346	0.004132	0.010744	0.00099	137	137	137	0	0	1	-360	360	7.4214	4.3072	-7.4189	-4.4248	0.0000	0.0000	0.0000	0.0000;
	2346	2344	0.004132	0.01157	0.001041	137	137	137	0	0	1	-360	360	0.9470	-0.1103	-0.9470	-0.0200	0.0000	0.0000	0.0000	0.0000;
	2111	1951	0.010744	0.034711	0.00356	114	114	114	0	0	1	-360	360	-28.9282	2.1497	29.0025	-2.3440	0.0000	0.0000	0.0000	0.0000;
	2370	1949	0.009446	0.028463	0.0028	90	90	90	0	0	1	-360	360	-4.2590	-2.3000	4.2608	1.9627	0.0000	0.0000	0.0000	0.0000;
	2369	1951	0.004512	0.015289	0.00151	137	137	137	0	0	1	-360	360	0.0000	-2.1070	0.0001	1.9229	0.0000	0.0000	0.0000	0.0000;
	1951	1950	0.006504	0.022017	0.00218	120	120	120	0	0	1	-360	360	-20.7758	1.5025	20.7989	-1.6911	0.0000	0.0000	0.0000	0.0000;
	2252	1983	0.01319	0.044669	0.004419	137	137	137	0	0	1	-360	360	6.7251	1.3222	-6.7200	-1.8512	0.0000	0.0000	0.0000	0.0000;
	2439	2252	0.012603	0.042653	0.004221	137	137	137	0	0	1	-360	360	13.3795	1.1970	-13.3611	-1.6582	0.0000	0.0000	0.0000	0.0000;
	2165	2145	0.02562	0.078512	0.008419	137	137	137	0	0	1	-360	360	-16.5385	-2.1703	16.5966	1.3165	0.0000	0.0000	0.0000	0.0000;
	2279	2165	0.012397	0.041322	0.004189	120	120	120	0	0	1	-360	360	-8.9304	-0.1297	8.9385	-0.3537	0.0000	0.0000	0.0000	0.0000;
	1963	1979	0.036686	0.091653	0.009399	120	120	120	0	0	1	-360	360	-5.6940	-1.3030	5.7039	0.1721	0.0000	0.0000	0.0000	0.0000;
	2366	2065	0.006612	0.015703	0.00165	120	120	120	0	0	1	-360	360	3.7988	0.0247	-3.7980	-0.2260	0.0000	0.0000	0.0000	0.0000;
	2064	1979	0.005917	0.01857	0.001989	90	90	90	0	0	1	-360	360	-31.9922	-2.6352	32.0419	2.5464	0.0000	0.0000	0.0000	0.0000;
	2366	1979	0.00157	0.005124	0.00053	120	120	120	0	0	1	-360	360	-15.6508	-6.3887	15.6544	6.3353	0.0000	0.0000	0.0000	0.0000;
	2367	1979	0.001529	0.004934	0.000501	120	120	120	0	0	1	-360	360	-13.9710	-5.3280	13.9738	5.2753	0.0000	0.0000	0.0000	0.0000;
	2064	2056	0.005793	0.013223	0.001379	90	90	90	0	0	1	-360	360	27.7252	2.3942	-27.6886	-2.4798	0.0000	0.0000	0.0000	0.0000;
	2100	1979	0.02719	0.049174	0.004779	90	90	90	0	0	1	-360	360	-28.1502	-3.2037	28.3296	2.9437	0.0000	0.0000	0.0000	0.0000;
	2222	1979	0.012901	0.022744	0.0022	90	90	90	0	0	1	-360	360	-10.1477	-2.5200	10.1591	2.2694	0.0000	0.0000	0.0000	0.0000;
	2223	1979	0.012041	0.024719	0.002439	90	90	90	0	0	1	-360	360	-1.5350	-1.3460	1.5354	1.0463	0.0000	0.0000	0.0000	0.0000;
	2174	2056	0.028934	0.05124	0.00469	90	90	90	0	0	1	-360	360	-14.8273	-0.0869	14.8796	-0.3922	0.0000	0.0000	0.0000	0.0000;
	2174	2166	0.015703	0.027273	0.002519	90	90	90	0	0	1	-360	360	11.7913	-1.0771	-11.7732	0.8028	0.0000	0.0000	0.0000	0.0000;
	2100	2067	0.018934	0.059504	0.006561	120	120	120	0	0	1	-360	360	13.8682	-1.5953	-13.8380	0.8953	0.0000	0.0000	0.0000	0.0000;
	2166	2067	0.01405	0.023141	0.002321	90	90	90	0	0	1	-360	360	5.7963	0.4774	-5.7924	-0.7519	0.0000	0.0000	0.0000	0.0000;
	2146	2067	0.009	0.030479	0.00302	69	69	69	0	0	1	-360	360	-3.3240	-1.2550	3.3249	0.8928	0.0000	0.0000	0.0000	0.0000;
	2347	2345	0.009091	0.031397	0.003269	137	137	137	0	0	1	-360	360	0.7898	1.9678	-0.7895	-2.3746	0.0000	0.0000	0.0000	0.0000;
	2348	2346	0.012397	0.040496	0.00416	137	137	137	0	0	1	-360	360	-3.6299	-2.9858	3.6319	2.4721	0.0000	0.0000	0.0000	0.0000;
	2299	2222	0.006364	0.021554	0.00213	91	91	91	0	0	1	-360	360	-3.7660	-0.2170	3.7667	-0.0420	0.0000	0.0000	0.0000	0.0000;
	2088	2256	0.010281	0.01795	0.001711	114	114	114	0	0	1	-360	360	-5.6890	-2.6420	5.6925	2.4514	0.0000	0.0000	0.0000	0.0000;
	2084	2255	0.013339	0.033901	0.003429	114	114	114	0	0	1	-360	360	-2.2100	-1.4570	2.2108	1.0684	0.0000	0.0000	0.0000	0.0000;
	2414	2256	0.012488	0.03219	0.00326	114	114	114	0	0	1	-360	360	-29.1135	-8.4617	29.2141	8.3479	0.0000	0.0000	0.0000	0.0000;
	2085	2414	0.000603	0.001033	9.9e-05	114	114	114	0	0	1	-360	360	-3.6200	-2.6900	3.6201	2.6789	0.0000	0.0000	0.0000	0.0000;
	2407	2414	0.004347	0.007603	0.000731	114	114	114	0	0	1	-360	360	-25.4673	-5.8201	25.4934	5.7828	0.0000	0.0000	0.0000	0.0000;
	2135	2407	0.000397	0.000686	7e-05	114	114	114	0	0	1	-360	360	-0.4910	-0.2250	0.4910	0.2170	0.0000	0.0000	0.0000	0.0000;
	2416	2407	0.002207	0.007463	0.00074	114	114	114	0	0	1	-360	360	-24.9636	-5.6439	24.9763	5.6031	0.0000	0.0000	0.0000	0.0000;
	2317	2416	0.008504	0.014851	0.001421	114	114	114	0	0	1	-360	360	-22.9830	-5.7600	23.0253	5.6733	0.0000	0.0000	0.0000	0.0000;
	2267	2416	0.008198	0.027769	0.002749	114	114	114	0	0	1	-360	360	-1.9380	-0.2810	1.9383	-0.0294	0.0000	0.0000	0.0000	0.0000;
	2101	2255	0.00257	0.004488	0.000431	114	114	114	0	0	1	-360	360	-26.8580	-21.7190	26.8850	21.7171	0.0000	0.0000	0.0000	0.0000;
	2083	2089	0.004554	0.012628	0.00127	114	114	114	0	0	1	-360	360	-14.4900	-7.1570	14.5005	7.0429	0.0000	0.0000	0.0000	0.0000;
	2102	2255	0.00257	0.004488	0.000431	114	114	114	0	0	1	-360	360	-3.3760	-3.5870	3.3765	3.5389	0.0000	0.0000	0.0000	0.0000;
	2114	2119	0.01176	0.021074	0.002016	90	90	90	0	0	1	-360	360	17.8647	-0.7422	-17.8317	0.5718	0.0000	0.0000	0.0000	0.0000;
	2103	2256	0.00257	0.004488	0.000431	114	114	114	0	0	1	-360	360	-0.3390	-0.2810	0.3390	0.2314	0.0000	0.0000	0.0000	0.0000;
	2446	2118	0.018033	0.061091	0.006048	90	90	90	0	0	1	-360	360	-20.4250	6.5210	20.4982	-6.9642	0.0000	0.0000	0.0000	0.0000;
	2246	2255	0.001537	0.005207	0.00052	137	137	137	0	0	1	-360	360	-47.4130	7.3736	47.4441	-7.3276	0.0000	0.0000	0.0000	0.0000;
	2256	2113	0.002479	0.006612	0.00068	137	137	137	0	0	1	-360	360	8.9018	6.9352	-8.8990	-7.0060	0.0000	0.0000	0.0000	0.0000;
	2255	2112	0.002479	0.006612	0.00068	137	137	137	0	0	1	-360	360	9.1478	38.3018	-9.1139	-38.2890	0.0000	0.0000	0.0000	0.0000;
	2246	2124	0.006967	0.023603	0.00234	137	137	137	0	0	1	-360	360	39.2710	-10.0936	-39.1706	10.1674	0.0000	0.0000	0.0000	0.0000;
	2256	2120	0.002769	0.009372	0.000929	120	120	120	0	0	1	-360	360	3.3463	1.6313	-3.3460	-1.7370	0.0000	0.0000	0.0000	0.0000;
	2119	2255	0.002769	0.009372	0.000929	120	120	120	0	0	1	-360	360	3.8897	-17.6418	-3.8818	17.5628	0.0000	0.0000	0.0000	0.0000;
	2243	2256	0.000124	0.000397	4.1e-05	137	137	137	0	0	1	-360	360	-7.1190	-1.6810	7.1191	1.6765	0.0000	0.0000	0.0000	0.0000;
	2244	2255	9.9e-05	0.000314	2.9e-05	137	137	137	0	0	1	-360	360	-0.7050	0.0000	0.7050	-0.0033	0.0000	0.0000	0.0000	0.0000;
	2256	2115	0.005793	0.018182	0.001861	120	120	120	0	0	1	-360	360	9.4966	6.2529	-9.4900	-6.4460	0.0000	0.0000	0.0000	0.0000;
	2408	1982	0.020702	0.070124	0.006941	137	137	137	0	0	1	-360	360	-69.9748	-0.2028	70.8211	2.2271	0.0000	0.0000	0.0000	0.0000;
	2154	2408	0.003488	0.011802	0.001169	137	137	137	0	0	1	-360	360	-50.8955	3.7217	50.9715	-3.6044	0.0000	0.0000	0.0000	0.0000;
	2152	2408	0.006149	0.020827	0.002059	137	137	137	0	0	1	-360	360	-18.9840	-3.9880	19.0033	3.8072	0.0000	0.0000	0.0000	0.0000;
	2372	2292	0.024793	0.076859	0.008349	120	120	120	0	0	1	-360	360	19.8174	-5.4159	-19.7336	4.6474	0.0000	0.0000	0.0000	0.0000;
	2293	2037	0.028934	0.08843	0.009731	120	120	120	0	0	1	-360	360	51.1678	3.4141	-50.5485	-2.7019	0.0000	0.0000	0.0000	0.0000;
	2109	2086	0.00676	0.022909	0.00227	120	120	120	0	0	1	-360	360	-105.4512	-18.3599	106.1219	20.3679	0.0000	0.0000	0.0000	0.0000;
	2117	2109	0.003686	0.012504	0.001239	137	137	137	0	0	1	-360	360	-103.6764	-15.8825	104.0312	16.9439	0.0000	0.0000	0.0000	0.0000;
	2117	2112	0.004959	0.016529	0.001769	137	137	137	0	0	1	-360	360	46.9853	12.0423	-46.8831	-11.9030	0.0000	0.0000	0.0000	0.0000;
	2406	2256	0.000612	0.002083	0.00021	120	120	120	0	0	1	-360	360	-42.2554	-14.6761	42.2660	14.6881	0.0000	0.0000	0.0000	0.0000;
	2104	2406	0.001017	0.003471	0.000339	120	120	120	0	0	1	-360	360	-2.7620	-2.5780	2.7621	2.5395	0.0000	0.0000	0.0000	0.0000;
	2106	2406	0.004314	0.013876	0.001159	120	120	120	0	0	1	-360	360	-39.4291	-12.0632	39.4933	12.1366	0.0000	0.0000	0.0000	0.0000;
	2127	2255	0.009421	0.031934	0.003161	120	120	120	0	0	1	-360	360	-1.5650	-0.8970	1.5652	0.5378	0.0000	0.0000	0.0000	0.0000;
	2126	2107	0.006446	0.021868	0.002161	120	120	120	0	0	1	-360	360	-16.3001	1.4460	16.3152	-1.6413	0.0000	0.0000	0.0000	0.0000;
	2110	1977	0.024388	0.063587	0.01204	137	137	137	0	0	1	-360	360	21.6372	-11.3118	-21.5211	10.1464	0.0000	0.0000	0.0000	0.0000;
	2450	2221	0.019016	0.041529	0.008639	90	90	90	0	0	1	-360	360	-3.2530	-1.1210	3.2548	0.0972	0.0000	0.0000	0.0000	0.0000;
	2279	2110	0.005793	0.018934	0.001909	76	76	76	0	0	1	-360	360	3.4314	-2.2463	-3.4306	2.0164	0.0000	0.0000	0.0000	0.0000;
	2221	2155	0.015703	0.02562	0.00227	120	120	120	0	0	1	-360	360	-19.4329	10.6527	19.4981	-10.8166	0.0000	0.0000	0.0000	0.0000;
	2155	2154	0.008256	0.012397	0.00128	120	120	120	0	0	1	-360	360	-35.1561	6.1566	35.2445	-6.1767	0.0000	0.0000	0.0000	0.0000;
	2449	2220	0.022091	0.057744	0.005651	76	76	76	0	0	1	-360	360	-23.1000	-8.4890	23.2133	8.1179	0.0000	0.0000	0.0000	0.0000;
	2044	2220	0.004347	0.007603	0.000721	69	69	69	0	0	1	-360	360	-0.9710	2.0220	0.9712	-2.1075	0.0000	0.0000	0.0000	0.0000;
	2045	2221	0.004347	0.007603	0.000721	69	69	69	0	0	1	-360	360	-0.9210	-0.1680	0.9210	0.0822	0.0000	0.0000	0.0000	0.0000;
	2220	2063	0.046281	0.076859	0.00755	76	76	76	0	0	1	-360	360	7.1124	1.3359	-7.0915	-2.1966	0.0000	0.0000	0.0000	0.0000;
	2041	2452	0.002446	0.008331	0.00083	114	114	114	0	0	1	-360	360	-1.5350	0.6730	1.5351	-0.7679	0.0000	0.0000	0.0000	0.0000;
	2040	2451	0.002446	0.008331	0.00083	114	114	114	0	0	1	-360	360	14.6250	3.4640	-14.6202	-3.5435	0.0000	0.0000	0.0000	0.0000;
	2451	1960	0.006612	0.009091	0.001159	120	120	120	0	0	1	-360	360	21.0045	13.8888	-20.9680	-13.9721	0.0000	0.0000	0.0000	0.0000;
	2446	1960	0.007438	0.023967	0.002439	120	120	120	0	0	1	-360	360	-0.7490	-10.5110	0.7560	10.2541	0.0000	0.0000	0.0000	0.0000;
	2451	2043	0.004959	0.014876	0.00167	120	120	120	0	0	1	-360	360	41.2442	-4.9974	-41.1701	5.0273	0.0000	0.0000	0.0000	0.0000;
	2452	2042	0.004959	0.014876	0.00167	120	120	120	0	0	1	-360	360	46.6623	23.9236	-46.5430	-23.7560	0.0000	0.0000	0.0000	0.0000;
	2452	2125	0.013223	0.042066	0.0046	120	120	120	0	0	1	-360	360	-32.3760	18.2350	32.5366	-18.2495	0.0000	0.0000	0.0000	0.0000;
	2452	2121	0.009091	0.027273	0.002899	120	120	120	0	0	1	-360	360	-6.0422	6.5279	6.0486	-6.8401	0.0000	0.0000	0.0000	0.0000;
	2126	2121	0.009917	0.030579	0.003291	120	120	120	0	0	1	-360	360	8.4241	-5.2900	-8.4156	4.9401	0.0000	0.0000	0.0000	0.0000;
	2451	2247	0.024793	0.080083	0.008301	114	114	114	0	0	1	-360	360	53.0508	3.7413	-52.4422	-2.7204	0.0000	0.0000	0.0000	0.0000;
	1958	2452	0.014992	0.031537	0.0031	90	90	90	0	0	1	-360	360	-8.0620	-1.4240	8.0707	1.0879	0.0000	0.0000	0.0000	0.0000;
	2451	2038	0.042984	0.102479	0.0105	90	90	90	0	0	1	-360	360	-45.7522	-0.7621	46.5320	1.3876	0.0000	0.0000	0.0000	0.0000;
	2114	2118	0.002868	0.009719	0.000963	114	114	114	0	0	1	-360	360	-26.2037	-3.7888	26.2213	3.7385	0.0000	0.0000	0.0000	0.0000;
	2220	1981	0.03719	0.119008	0.012199	114	114	114	0	0	1	-360	360	-7.2475	-18.7347	7.3653	17.6294	0.0000	0.0000	0.0000	0.0000;
	1977	1982	0.064628	0.109917	0.01059	137	137	137	0	0	1	-360	360	12.9831	-11.6014	-12.8303	10.5640	0.0000	0.0000	0.0000	0.0000;
	1981	1974	0.033223	0.056612	0.00545	120	120	120	0	0	1	-360	360	5.0350	1.0198	-5.0277	-1.6814	0.0000	0.0000	0.0000	0.0000;
	1982	2134	0.017826	0.060207	0.00596	120	120	120	0	0	1	-360	360	5.2237	3.9743	-5.2170	-4.6820	0.0000	0.0000	0.0000	0.0000;
	2266	1981	0.007587	0.025686	0.002541	120	120	120	0	0	1	-360	360	-13.3750	-1.9100	13.3862	1.6333	0.0000	0.0000	0.0000	0.0000;
	2419	2116	0.012091	0.040959	0.004061	120	120	120	0	0	1	-360	360	0.9061	0.0617	-0.9060	-0.5600	0.0000	0.0000	0.0000	0.0000;
	1982	2419	0.006868	0.023256	0.002299	120	120	120	0	0	1	-360	360	5.1424	-0.1022	-5.1409	-0.1752	0.0000	0.0000	0.0000	0.0000;
	2318	2419	0.005529	0.009669	0.00092	120	120	120	0	0	1	-360	360	-4.2340	-0.2250	4.2348	0.1135	0.0000	0.0000	0.0000	0.0000;
	2086	1981	0.015703	0.049587	0.005111	120	120	120	0	0	1	-360	360	-111.6169	-24.1179	113.3538	28.9854	0.0000	0.0000	0.0000	0.0000;
	2293	1981	0.004132	0.031397	0.003001	137	137	137	0	0	1	-360	360	-35.1264	-8.9625	35.1704	8.9263	0.0000	0.0000	0.0000	0.0000;
	2285	1981	0.065826	0.222983	0.02208	137	137	137	0	0	1	-360	360	-10.0370	-2.2920	10.0918	-0.2389	0.0000	0.0000	0.0000	0.0000;
	2268	1982	0.020661	0.066124	0.006781	120	120	120	0	0	1	-360	360	-32.2150	2.0335	32.3920	-2.2966	0.0000	0.0000	0.0000	0.0000;
	2089	2106	0.016421	0.055628	0.00551	137	137	137	0	0	1	-360	360	-15.1755	-7.6029	15.2167	7.1165	0.0000	0.0000	0.0000	0.0000;
	2026	1974	0.012141	0.041124	0.00407	137	137	137	0	0	1	-360	360	-2.5610	-1.2480	2.5617	0.7484	0.0000	0.0000	0.0000	0.0000;
	2080	2425	0.03124	0.102314	0.010481	137	137	137	0	0	1	-360	360	1.0668	-2.8849	-1.0650	1.7293	0.0000	0.0000	0.0000	0.0000;
	2002	1986	0.044207	0.113669	0.01112	91	91	91	0	0	1	-360	360	41.1475	-4.5365	-40.5231	4.8115	0.0000	0.0000	0.0000	0.0000;
	2092	2002	0.010331	0.018017	0.001721	90	90	90	0	0	1	-360	360	7.4361	-14.2042	-7.4144	14.0344	0.0000	0.0000	0.0000	0.0000;
	2437	2164	0.012562	0.021901	0.00212	90	90	90	0	0	1	-360	360	-1.0340	5.9546	1.0380	-6.2037	0.0000	0.0000	0.0000	0.0000;
	2438	2436	0.010083	0.017364	0.001721	90	90	90	0	0	1	-360	360	8.1491	10.4374	-8.1344	-10.6206	0.0000	0.0000	0.0000	0.0000;
	2245	2159	0.02	0.037438	0.003649	90	90	90	0	0	1	-360	360	-5.6398	15.0032	5.6835	-15.3596	0.0000	0.0000	0.0000	0.0000;
	2436	2245	0.007934	0.015372	0.0015	90	90	90	0	0	1	-360	360	1.0154	12.9086	-1.0042	-13.0682	0.0000	0.0000	0.0000	0.0000;
	2438	2437	0.010826	0.018934	0.00181	90	90	90	0	0	1	-360	360	17.0469	6.6206	-17.0170	-6.7876	0.0000	0.0000	0.0000	0.0000;
	2164	2158	0.028182	0.058182	0.0059	90	90	90	0	0	1	-360	360	-13.3790	7.1097	13.4338	-7.7078	0.0000	0.0000	0.0000	0.0000;
	2033	2002	0.057016	0.113314	0.010909	90	90	90	0	0	1	-360	360	-19.3850	-7.2058	19.5888	6.3121	0.0000	0.0000	0.0000	0.0000;
	2289	2158	0.039339	0.129174	0.013201	137	137	137	0	0	1	-360	360	-47.5051	2.1173	48.2655	-1.1892	0.0000	0.0000	0.0000	0.0000;
	2290	2289	0.00595	0.019174	0.00198	137	137	137	0	0	1	-360	360	-32.7205	0.4025	32.7751	-0.4583	0.0000	0.0000	0.0000	0.0000;
	2158	2092	0.036198	0.063388	0.00612	90	90	90	0	0	1	-360	360	19.5389	-11.7777	-19.3851	11.3092	0.0000	0.0000	0.0000	0.0000;
	2290	2432	0.02743	0.088851	0.00915	137	137	137	0	0	1	-360	360	25.5045	0.1145	-25.3516	-0.6814	0.0000	0.0000	0.0000	0.0000;
	2388	2303	0.040331	0.136612	0.01353	137	137	137	0	0	1	-360	360	-6.1163	-7.2604	6.1445	5.8012	0.0000	0.0000	0.0000	0.0000;
	2427	2053	0.01157	0.039421	0.003901	137	137	137	0	0	1	-360	360	-5.3273	6.6085	5.3351	-7.0157	0.0000	0.0000	0.0000	0.0000;
	2033	1939	0.035066	0.118777	0.011761	137	137	137	0	0	1	-360	360	10.9330	7.3208	-10.8780	-8.4971	0.0000	0.0000	0.0000	0.0000;
	2159	1939	0.041066	0.139091	0.01377	137	137	137	0	0	1	-360	360	34.5172	8.1433	-34.0806	-8.2767	0.0000	0.0000	0.0000	0.0000;
	2196	1966	0.029496	0.050174	0.00484	90	90	90	0	0	1	-360	360	-40.5187	6.6462	40.9687	-6.4211	0.0000	0.0000	0.0000	0.0000;
	2425	2053	0.011322	0.037438	0.0037	137	137	137	0	0	1	-360	360	17.2413	-4.5797	-17.2091	4.2757	0.0000	0.0000	0.0000	0.0000;
	2424	2159	0.014207	0.046612	0.00477	137	137	137	0	0	1	-360	360	-28.5606	-9.0445	28.6681	8.8304	0.0000	0.0000	0.0000	0.0000;
	2424	2303	0.017769	0.058182	0.005951	137	137	137	0	0	1	-360	360	26.4756	8.4225	-26.3585	-8.7352	0.0000	0.0000	0.0000	0.0000;
	2198	2080	0.022686	0.062207	0.00629	90	90	90	0	0	1	-360	360	9.2490	-3.9272	-9.2288	3.2869	0.0000	0.0000	0.0000	0.0000;
	2159	1961	0.020992	0.069339	0.006989	137	137	137	0	0	1	-360	360	21.3945	-7.9847	-21.3042	7.4465	0.0000	0.0000	0.0000	0.0000;
	1991	1961	0.017107	0.05562	0.004799	137	137	137	0	0	1	-360	360	-20.1007	7.1251	20.1662	-7.4875	0.0000	0.0000	0.0000	0.0000;
	2425	2335	0.024959	0.084463	0.00847	137	137	137	0	0	1	-360	360	-24.9063	3.4194	25.0492	-3.8791	0.0000	0.0000	0.0000	0.0000;
	2388	2306	0.031744	0.107504	0.010641	137	137	137	0	0	1	-360	360	-12.0347	2.1114	12.0772	-3.1792	0.0000	0.0000	0.0000	0.0000;
	2193	2158	0.02595	0.085124	0.008741	137	137	137	0	0	1	-360	360	-4.7020	-0.1120	4.7068	-0.9249	0.0000	0.0000	0.0000	0.0000;
	2198	2196	0.00943	0.018893	0.001849	90	90	90	0	0	1	-360	360	-21.6810	6.4432	21.7247	-6.5602	0.0000	0.0000	0.0000	0.0000;
	2427	1939	0.017686	0.057438	0.00596	137	137	137	0	0	1	-360	360	-35.7939	-16.2556	36.0376	16.3738	0.0000	0.0000	0.0000	0.0000;
	1959	2427	0.052339	0.091554	0.008729	69	69	69	0	0	1	-360	360	-2.5690	1.0550	2.5732	-2.0199	0.0000	0.0000	0.0000	0.0000;
	2673	2728	0.03562	0.109421	0.011461	69	69	69	0	0	1	-360	360	29.3062	10.4566	-29.0235	-10.9828	0.0000	0.0000	0.0000	0.0000;
	2578	2708	0.036777	0.093967	0.009511	120	120	120	0	0	1	-360	360	-19.3077	0.5523	19.4211	-1.4220	0.0000	0.0000	0.0000	0.0000;
	2684	2638	0.002066	0.007273	0.000699	126	126	126	0	0	1	-360	360	8.7701	-1.2589	-8.7688	1.1773	0.0000	0.0000	0.0000	0.0000;
	2638	2483	0.018512	0.059504	0.00627	126	126	126	0	0	1	-360	360	0.5858	-3.6773	-0.5841	2.9083	0.0000	0.0000	0.0000	0.0000;
	2570	2465	0.021	0.067901	0.00696	123	123	123	0	0	1	-360	360	-18.7702	1.9681	18.8318	-2.6195	0.0000	0.0000	0.0000	0.0000;
	2663	2667	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	-15.2045	4.1379	15.2738	-4.7234	0.0000	0.0000	0.0000	0.0000;
	2461	2729	0.066446	0.17719	0.01791	70	70	70	0	0	1	-360	360	4.6891	-9.6920	-4.6368	7.6294	0.0000	0.0000	0.0000	0.0000;
	2658	2730	0.076612	0.131818	0.013	78	78	78	0	0	1	-360	360	-67.2561	4.3050	70.3049	-0.6096	0.0000	0.0000	0.0000	0.0000;
	2481	2517	0.033802	0.107438	0.011541	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2585	2624	0.020496	0.06876	0.00688	137	137	137	0	0	1	-360	360	7.1469	5.6150	-7.1319	-6.3805	0.0000	0.0000	0.0000	0.0000;
	2562	2527	0.04	0.129587	0.013291	114	114	114	0	0	1	-360	360	-58.0304	-12.2407	59.2240	14.4949	0.0000	0.0000	0.0000	0.0000;
	2532	2620	0.009917	0.033223	0.004189	107	107	107	0	0	1	-360	360	-38.3543	-5.1598	38.4800	5.0843	0.0000	0.0000	0.0000	0.0000;
	2562	2528	0.040248	0.130248	0.013361	107	107	107	0	0	1	-360	360	-58.0552	-12.1299	59.2563	14.3955	0.0000	0.0000	0.0000	0.0000;
	2622	2556	0.035446	0.087364	0.008821	114	114	114	0	0	1	-360	360	8.4708	15.8011	-8.3703	-16.5919	0.0000	0.0000	0.0000	0.0000;
	2731	2730	0.012636	0.038017	0.00273	114	114	114	0	0	1	-360	360	-32.1024	-0.8452	32.2080	0.8251	0.0000	0.0000	0.0000	0.0000;
	2531	2731	0.033058	0.082636	0.00968	69	69	69	0	0	1	-360	360	-29.3108	-1.4424	29.5454	0.8452	0.0000	0.0000	0.0000	0.0000;
	2593	2532	0.046686	0.081818	0.007739	90	90	90	0	0	1	-360	360	-1.9737	-7.7724	1.9967	6.9051	0.0000	0.0000	0.0000	0.0000;
	2486	2477	0.034132	0.059917	0.00566	48	48	48	0	0	1	-360	360	-22.3143	-0.6372	22.4781	0.3327	0.0000	0.0000	0.0000	0.0000;
	2500	2594	0.035868	0.058678	0.006459	90	90	90	0	0	1	-360	360	-19.7348	1.0030	19.8538	-1.5741	0.0000	0.0000	0.0000	0.0000;
	2499	2506	0.1	0.159496	0.01597	86	86	86	0	0	1	-360	360	-35.4095	2.4958	36.4829	-2.7178	0.0000	0.0000	0.0000	0.0000;
	2704	2608	0.039504	0.128099	0.013141	137	137	137	0	0	1	-360	360	-18.5617	1.8228	18.6749	-3.0721	0.0000	0.0000	0.0000	0.0000;
	2594	2476	0.03124	0.056033	0.005629	84	84	84	0	0	1	-360	360	-34.6906	2.0666	35.0076	-2.1746	0.0000	0.0000	0.0000	0.0000;
	2715	2496	0.021397	0.068868	0.007081	69	69	69	0	0	1	-360	360	11.8497	-3.3607	-11.8235	2.5830	0.0000	0.0000	0.0000	0.0000;
	2699	2715	0.016859	0.054273	0.005581	69	69	69	0	0	1	-360	360	14.9510	-3.4455	-14.9187	2.8692	0.0000	0.0000	0.0000	0.0000;
	2621	2715	0.000256	0.000661	7e-05	69	69	69	0	0	1	-360	360	-3.0690	-0.5000	3.0690	0.4915	0.0000	0.0000	0.0000	0.0000;
	2485	2484	0.012231	0.038603	0.004201	30	30	30	0	0	1	-360	360	9.7277	2.0538	-9.7170	-2.5000	0.0000	0.0000	0.0000	0.0000;
	2611	2492	0.028827	0.093223	0.009564	69	69	69	0	0	1	-360	360	-11.3477	-7.9297	11.3916	6.9128	0.0000	0.0000	0.0000	0.0000;
	2658	2489	0.01824	0.058992	0.00605	123	123	123	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2532	2683	0.024554	0.079917	0.00823	137	137	137	0	0	1	-360	360	7.6583	1.4100	-7.6453	-2.3360	0.0000	0.0000	0.0000	0.0000;
	2477	2697	0.06843	0.09157	0.0084	69	69	69	0	0	1	-360	360	-34.1714	-0.9439	34.9298	1.0529	0.0000	0.0000	0.0000	0.0000;
	2697	2728	0.086529	0.11405	0.010191	57	57	57	0	0	1	-360	360	-46.1808	-4.0529	47.8635	5.1000	0.0000	0.0000	0.0000	0.0000;
	2579	2558	0.007851	0.019826	0.00203	120	120	120	0	0	1	-360	360	9.0481	-12.6119	-9.0319	12.4186	0.0000	0.0000	0.0000	0.0000;
	2618	2640	0.010331	0.026529	0.002691	109	109	109	0	0	1	-360	360	28.5623	-1.3307	-28.4894	1.2075	0.0000	0.0000	0.0000	0.0000;
	2596	2618	0.022314	0.057016	0.00576	120	120	120	0	0	1	-360	360	-5.6260	-1.0000	5.6322	0.3505	0.0000	0.0000	0.0000	0.0000;
	2595	2656	0.030992	0.079008	0.00801	120	120	120	0	0	1	-360	360	-3.5800	-1.0000	3.5833	0.0120	0.0000	0.0000	0.0000	0.0000;
	2458	2561	0.002636	0.007521	0.00075	120	120	120	0	0	1	-360	360	33.4243	-16.8294	-33.3948	16.8198	0.0000	0.0000	0.0000	0.0000;
	2553	2535	0.030248	0.06281	0.00061	99	99	99	0	0	1	-360	360	-43.2773	-0.4399	43.7397	1.3244	0.0000	0.0000	0.0000	0.0000;
	2534	2466	0.003314	0.010826	0.001089	137	137	137	0	0	1	-360	360	-19.9881	2.6245	19.9989	-2.7245	0.0000	0.0000	0.0000	0.0000;
	2544	2536	0.04124	0.072314	0.00687	69	69	69	0	0	1	-360	360	-31.0553	-0.3460	31.3795	0.0627	0.0000	0.0000	0.0000	0.0000;
	2534	2474	0.018603	0.056198	0.00581	81	81	81	0	0	1	-360	360	3.8491	-10.6245	-3.8311	9.9532	0.0000	0.0000	0.0000	0.0000;
	2591	2613	0.024793	0.08	0.00823	137	137	137	0	0	1	-360	360	-23.4080	0.1052	23.5183	-0.7692	0.0000	0.0000	0.0000	0.0000;
	2459	2656	0.01314	0.041818	0.004479	137	137	137	0	0	1	-360	360	11.7812	1.5007	-11.7663	-2.0120	0.0000	0.0000	0.0000	0.0000;
	2655	2617	0.009421	0.030661	0.003151	103	103	103	0	0	1	-360	360	-23.6621	9.4206	23.7152	-9.6128	0.0000	0.0000	0.0000	0.0000;
	2655	2587	0.029008	0.09438	0.009661	76	76	76	0	0	1	-360	360	6.7744	-12.3222	-6.7283	11.3444	0.0000	0.0000	0.0000	0.0000;
	2472	2536	0.004207	0.010578	0.00106	120	120	120	0	0	1	-360	360	-55.8402	-4.2858	55.9460	4.4192	0.0000	0.0000	0.0000	0.0000;
	2717	2535	0.007364	0.023802	0.002439	90	90	90	0	0	1	-360	360	17.3144	-12.4153	-17.2878	12.1958	0.0000	0.0000	0.0000	0.0000;
	2717	2458	0.00157	0.004959	0.000511	137	137	137	0	0	1	-360	360	-20.0418	4.2142	20.0471	-4.2614	0.0000	0.0000	0.0000	0.0000;
	2717	2459	0.00157	0.004959	0.000511	137	137	137	0	0	1	-360	360	-21.8205	4.2011	21.8267	-4.2453	0.0000	0.0000	0.0000	0.0000;
	2466	2472	0.003058	0.009917	0.001019	137	137	137	0	0	1	-360	360	-41.4779	-1.2755	41.5202	1.2858	0.0000	0.0000	0.0000	0.0000;
	2590	2580	0.008256	0.026281	0.00286	69	69	69	0	0	1	-360	360	-24.5600	-1.1277	24.6035	0.9373	0.0000	0.0000	0.0000	0.0000;
	2517	2590	0.018099	0.057016	0.0062	69	69	69	0	0	1	-360	360	-8.6940	-0.8000	8.7060	0.1277	0.0000	0.0000	0.0000	0.0000;
	2561	2536	0.00405	0.010578	0.001089	95	95	95	0	0	1	-360	360	22.1438	-19.3198	-22.1160	19.2564	0.0000	0.0000	0.0000	0.0000;
	2463	2458	0.002314	0.007521	0.00077	137	137	137	0	0	1	-360	360	-73.7850	-4.0004	73.8864	4.2340	0.0000	0.0000	0.0000	0.0000;
	2651	2463	0.003967	0.012984	0.001309	137	137	137	0	0	1	-360	360	-63.4273	-1.2419	63.5560	1.5004	0.0000	0.0000	0.0000	0.0000;
	2551	2544	0.003612	0.011661	0.0012	137	137	137	0	0	1	-360	360	-55.9622	-4.1924	56.0553	4.3460	0.0000	0.0000	0.0000	0.0000;
	2661	2551	0.068984	0.121207	0.011449	57	57	57	0	0	1	-360	360	-46.0019	-1.3270	47.2682	2.1924	0.0000	0.0000	0.0000	0.0000;
	2462	2660	0.037603	0.091744	0.00968	99	99	99	0	0	1	-360	360	0.0001	-1.1787	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2629	2659	0.019669	0.086124	0.00924	57	57	57	0	0	1	-360	360	13.3267	1.0322	-13.2970	-2.0000	0.0000	0.0000	0.0000	0.0000;
	2482	2661	0.066612	0.113058	0.01118	69	69	69	0	0	1	-360	360	-55.1569	-7.4445	57.0999	9.5057	0.0000	0.0000	0.0000	0.0000;
	2639	2553	0.013223	0.033058	0.003269	114	114	114	0	0	1	-360	360	-35.4693	1.5034	35.6063	-1.5601	0.0000	0.0000	0.0000	0.0000;
	2728	2639	0.05686	0.093388	0.00944	114	114	114	0	0	1	-360	360	-25.4370	3.3828	25.7523	-4.0034	0.0000	0.0000	0.0000	0.0000;
	2684	2535	0.037603	0.121653	0.01249	80	80	80	0	0	1	-360	360	-27.9121	0.2589	28.1500	-1.0420	0.0000	0.0000	0.0000	0.0000;
	2695	2587	0.030579	0.053719	0.00508	78	78	78	0	0	1	-360	360	-10.2290	-3.0000	10.2583	2.4561	0.0000	0.0000	0.0000	0.0000;
	2618	2537	0.008512	0.020744	0.002321	114	114	114	0	0	1	-360	360	-58.3547	4.8025	58.6071	-4.4570	0.0000	0.0000	0.0000	0.0000;
	2537	2681	0.040496	0.096686	0.010159	120	120	120	0	0	1	-360	360	-60.3151	5.4570	61.5924	-3.6115	0.0000	0.0000	0.0000	0.0000;
	2711	2567	0.034793	0.10281	0.01045	99	99	99	0	0	1	-360	360	-40.2087	17.1072	40.7846	-16.6211	0.0000	0.0000	0.0000	0.0000;
	2471	2651	0.001983	0.006281	0.000651	137	137	137	0	0	1	-360	360	-41.9200	3.2670	41.9483	-3.2581	0.0000	0.0000	0.0000	0.0000;
	2457	2471	0.006529	0.021157	0.0022	137	137	137	0	0	1	-360	360	-19.3937	9.0729	19.4180	-9.2670	0.0000	0.0000	0.0000	0.0000;
	2640	2579	0.009256	0.023802	0.00242	120	120	120	0	0	1	-360	360	12.1244	-5.2075	-12.1105	4.9644	0.0000	0.0000	0.0000	0.0000;
	2725	2617	0.062231	0.104132	0.010721	63	63	63	0	0	1	-360	360	-21.3426	-3.1023	21.5981	2.3069	0.0000	0.0000	0.0000	0.0000;
	2542	2725	0.047017	0.078512	0.00808	69	69	69	0	0	1	-360	360	-3.5800	-1.1000	3.5856	0.2023	0.0000	0.0000	0.0000	0.0000;
	2477	2482	0.005446	0.007603	0.00077	69	69	69	0	0	1	-360	360	-42.7876	-3.7927	42.8829	3.8445	0.0000	0.0000	0.0000	0.0000;
	2617	2580	0.016198	0.033802	0.003509	90	90	90	0	0	1	-360	360	29.2724	-6.3534	-29.1471	6.2098	0.0000	0.0000	0.0000	0.0000;
	2633	2473	0.007917	0.025612	0.005261	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2655	2633	0.02781	0.089942	0.01845	114	114	114	0	0	1	-360	360	6.6587	-0.5984	-6.6480	-1.5000	0.0000	0.0000	0.0000	0.0000;
	2457	2474	0.013967	0.044628	0.00462	126	126	126	0	0	1	-360	360	-2.0853	-14.5729	2.1087	14.0718	0.0000	0.0000	0.0000	0.0000;
	2613	2473	0.008678	0.028099	0.00295	88	88	88	0	0	1	-360	360	-46.0203	-3.7308	46.1689	3.8434	0.0000	0.0000	0.0000	0.0000;
	2650	2661	0.016066	0.052793	0.01083	69	69	69	0	0	1	-360	360	19.8593	9.1422	-19.7920	-10.1788	0.0000	0.0000	0.0000	0.0000;
	2635	2650	0.034	0.10995	0.022559	69	69	69	0	0	1	-360	360	24.1397	8.0749	-23.9503	-10.1422	0.0000	0.0000	0.0000	0.0000;
	2503	2535	0.00562	0.018934	0.00189	32	32	32	0	0	1	-360	360	-16.3660	-4.0000	16.3787	3.8064	0.0000	0.0000	0.0000	0.0000;
	2504	2536	0.00562	0.018934	0.00189	32	32	32	0	0	1	-360	360	-7.8660	-2.0000	7.8689	1.7733	0.0000	0.0000	0.0000	0.0000;
	2718	2458	0.002149	0.00719	0.000721	57	57	57	0	0	1	-360	360	-2.0460	-1.0000	2.0461	0.9102	0.0000	0.0000	0.0000	0.0000;
	2647	2536	0.000909	0.003058	0.00031	46	46	46	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0388	0.0000	0.0000	0.0000	0.0000;
	2556	2558	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	3.2553	14.7919	-3.2421	-14.9186	0.0000	0.0000	0.0000	0.0000;
	2686	2474	0.020496	0.06876	0.00688	137	137	137	0	0	1	-360	360	-33.4747	-9.5139	33.6757	9.3347	0.0000	0.0000	0.0000	0.0000;
	2470	2477	0.037397	0.120661	0.01272	140	140	140	0	0	1	-360	360	-46.0280	-1.2000	46.8089	2.4040	0.0000	0.0000	0.0000	0.0000;
	2686	2635	0.019281	0.062364	0.006398	137	137	137	0	0	1	-360	360	27.3367	8.2139	-27.2077	-8.5749	0.0000	0.0000	0.0000	0.0000;
	2495	2711	0.005702	0.010174	0.000939	69	69	69	0	0	1	-360	360	-43.7717	-2.7378	43.8662	2.7971	0.0000	0.0000	0.0000	0.0000;
	2709	2495	0.009669	0.017017	0.0016	90	90	90	0	0	1	-360	360	-36.0935	-0.4308	36.2027	0.4378	0.0000	0.0000	0.0000	0.0000;
	2540	2710	0.057686	0.145446	0.014999	76	76	76	0	0	1	-360	360	-26.8725	5.1379	27.2522	-5.9188	0.0000	0.0000	0.0000	0.0000;
	2573	2711	0.031983	0.07876	0.00786	90	90	90	0	0	1	-360	360	-41.9708	11.5180	42.4973	-11.1348	0.0000	0.0000	0.0000	0.0000;
	2707	2710	0.01843	0.06	0.006149	137	137	137	0	0	1	-360	360	-20.6993	2.6513	20.7687	-3.1416	0.0000	0.0000	0.0000	0.0000;
	2691	2692	0.005537	0.017934	0.001839	137	137	137	0	0	1	-360	360	-4.7649	-0.1807	4.7660	-0.0281	0.0000	0.0000	0.0000	0.0000;
	2593	2464	0.036364	0.120661	0.01181	114	114	114	0	0	1	-360	360	-13.5733	2.4724	13.6339	-3.6498	0.0000	0.0000	0.0000	0.0000;
	2692	2688	0.003058	0.009917	0.001019	114	114	114	0	0	1	-360	360	-42.4201	-22.7881	42.4815	22.8690	0.0000	0.0000	0.0000	0.0000;
	2518	2573	0.067603	0.119008	0.0112	69	69	69	0	0	1	-360	360	-4.1187	6.4969	4.1581	-7.7300	0.0000	0.0000	0.0000	0.0000;
	2701	2518	0.038678	0.068099	0.006389	69	69	69	0	0	1	-360	360	4.6085	8.6039	-4.5753	-9.2969	0.0000	0.0000	0.0000	0.0000;
	2636	2573	0.050422	0.104868	0.0102	69	69	69	0	0	1	-360	360	-20.3180	7.4437	20.5267	-8.1880	0.0000	0.0000	0.0000	0.0000;
	2653	2636	0.01976	0.051397	0.00515	69	69	69	0	0	1	-360	360	-20.1369	7.1556	20.2160	-7.5437	0.0000	0.0000	0.0000	0.0000;
	2577	2529	0.02781	0.079678	0.008071	69	69	69	0	0	1	-360	360	-28.7052	-20.5132	28.9878	20.3301	0.0000	0.0000	0.0000	0.0000;
	2701	2577	0.014669	0.032388	0.003279	69	69	69	0	0	1	-360	360	-27.8432	-20.2827	27.9892	20.2132	0.0000	0.0000	0.0000	0.0000;
	2469	2533	0.022314	0.072314	0.014929	75	75	75	0	0	1	-360	360	-31.5459	-10.5756	31.7524	9.4667	0.0000	0.0000	0.0000	0.0000;
	2464	2469	0.013223	0.017769	0.001909	62	62	62	0	0	1	-360	360	-21.1573	-7.9222	21.2149	7.7756	0.0000	0.0000	0.0000	0.0000;
	2685	2529	0.008835	0.027917	0.003049	137	137	137	0	0	1	-360	360	-26.2586	-8.1813	26.3120	7.9692	0.0000	0.0000	0.0000	0.0000;
	2516	2685	0.006876	0.021579	0.002398	137	137	137	0	0	1	-360	360	-21.5255	-6.6911	21.5536	6.4813	0.0000	0.0000	0.0000	0.0000;
	2632	2694	0.015537	0.054554	0.005571	137	137	137	0	0	1	-360	360	-2.9339	5.7924	2.9401	-6.4030	0.0000	0.0000	0.0000	0.0000;
	2494	2648	0.008512	0.021744	0.0022	120	120	120	0	0	1	-360	360	18.1256	-8.1468	-18.0966	7.9676	0.0000	0.0000	0.0000	0.0000;
	2648	2692	0.00281	0.007017	0.00059	114	114	114	0	0	1	-360	360	-6.9624	-15.0676	6.9691	15.0162	0.0000	0.0000	0.0000	0.0000;
	2481	2706	0.027686	0.089504	0.009169	95	95	95	0	0	1	-360	360	-36.4534	-2.3099	36.7773	2.3016	0.0000	0.0000	0.0000	0.0000;
	2694	2481	0.021322	0.069421	0.007069	137	137	137	0	0	1	-360	360	-18.6921	1.2030	18.7584	-1.7901	0.0000	0.0000	0.0000	0.0000;
	2706	2712	0.015041	0.041322	0.004259	90	90	90	0	0	1	-360	360	5.4681	9.9518	-5.4508	-10.3974	0.0000	0.0000	0.0000	0.0000;
	2693	2691	0.017769	0.057364	0.005881	137	137	137	0	0	1	-360	360	-11.7053	-8.9952	11.7384	8.4273	0.0000	0.0000	0.0000	0.0000;
	2654	2527	0.007364	0.023802	0.00251	114	114	114	0	0	1	-360	360	-27.0572	-7.0917	27.1033	6.9268	0.0000	0.0000	0.0000	0.0000;
	2673	2586	0.004207	0.010744	0.00121	114	114	114	0	0	1	-360	360	-18.7285	-4.5888	18.7411	4.4708	0.0000	0.0000	0.0000	0.0000;
	2464	2653	0.023314	0.078934	0.007451	69	69	69	0	0	1	-360	360	-5.0703	11.0981	5.1019	-11.8556	0.0000	0.0000	0.0000	0.0000;
	2673	2526	0.002727	0.008256	0.000849	120	120	120	0	0	1	-360	360	2.4098	2.1519	-2.4096	-2.2564	0.0000	0.0000	0.0000	0.0000;
	2526	2516	0.001488	0.004959	0.000479	137	137	137	0	0	1	-360	360	-12.6254	-3.5436	12.6275	3.4911	0.0000	0.0000	0.0000	0.0000;
	2483	2529	0.028678	0.092562	0.009511	57	57	57	0	0	1	-360	360	-12.3029	-6.1083	12.3450	5.0598	0.0000	0.0000	0.0000	0.0000;
	2494	2540	0.013636	0.035537	0.0037	120	120	120	0	0	1	-360	360	-19.3536	7.7468	19.4055	-8.0379	0.0000	0.0000	0.0000	0.0000;
	2691	2688	0.004207	0.013554	0.001401	131	131	131	0	0	1	-360	360	-37.3590	-16.7075	37.4200	16.7416	0.0000	0.0000	0.0000	0.0000;
	2632	2693	0.005289	0.010744	0.001111	90	90	90	0	0	1	-360	360	-3.2174	-5.6179	3.2193	5.4952	0.0000	0.0000	0.0000	0.0000;
	2712	2709	0.009339	0.016529	0.00174	90	90	90	0	0	1	-360	360	-13.1652	5.1974	13.1815	-5.3692	0.0000	0.0000	0.0000	0.0000;
	2566	2528	0.02124	0.068603	0.00704	99	99	99	0	0	1	-360	360	-40.9864	-6.3176	41.2829	6.4014	0.0000	0.0000	0.0000	0.0000;
	2533	2527	0.031397	0.098843	0.01074	126	126	126	0	0	1	-360	360	-39.0144	-12.1667	39.4454	12.2028	0.0000	0.0000	0.0000	0.0000;
	2568	2688	0.008512	0.02686	0.002899	95	95	95	0	0	1	-360	360	0.8097	5.3240	-0.8074	-5.6542	0.0000	0.0000	0.0000	0.0000;
	2563	2568	0.018099	0.057016	0.0062	95	95	95	0	0	1	-360	360	1.8374	4.8144	-1.8327	-5.5240	0.0000	0.0000	0.0000	0.0000;
	2480	2688	0.01719	0.057769	0.005779	69	69	69	0	0	1	-360	360	-13.9049	-6.6991	13.9399	6.1487	0.0000	0.0000	0.0000	0.0000;
	2575	2710	0.015793	0.040174	0.00408	120	120	120	0	0	1	-360	360	60.6488	-3.4018	-60.1563	4.1753	0.0000	0.0000	0.0000	0.0000;
	2620	2566	0.033636	0.107438	0.010159	107	107	107	0	0	1	-360	360	-38.5820	-5.1843	39.0084	5.3176	0.0000	0.0000	0.0000	0.0000;
	2654	2586	0.008256	0.016529	0.001941	114	114	114	0	0	1	-360	360	21.0222	5.1917	-20.9911	-5.3708	0.0000	0.0000	0.0000	0.0000;
	2706	2721	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	31.2403	5.4337	-31.1974	-5.4542	0.0000	0.0000	0.0000	0.0000;
	2706	2721	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	31.2403	5.4337	-31.1974	-5.4542	0.0000	0.0000	0.0000	0.0000;
	2522	2688	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	1.4770	1.6000	-1.4768	-1.6846	0.0000	0.0000	0.0000	0.0000;
	2523	2689	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	-0.6140	-0.4000	0.6140	0.3151	0.0000	0.0000	0.0000	0.0000;
	2696	2691	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	-13.0780	-2.5826	13.0856	2.5098	0.0000	0.0000	0.0000	0.0000;
	2698	2632	0.025397	0.082157	0.008429	123	123	123	0	0	1	-360	360	1.5231	2.4203	-1.5207	-3.3745	0.0000	0.0000	0.0000	0.0000;
	2698	2480	0.016364	0.052893	0.005581	140	140	140	0	0	1	-360	360	-5.2051	-4.0203	5.2109	3.3991	0.0000	0.0000	0.0000	0.0000;
	2563	2701	0.020413	0.06843	0.006851	123	123	123	0	0	1	-360	360	-8.7924	-7.1144	8.8137	6.3788	0.0000	0.0000	0.0000	0.0000;
	2696	2691	0.009917	0.034876	0.00407	76	76	76	0	0	1	-360	360	-2.8780	-1.8174	2.8790	1.3512	0.0000	0.0000	0.0000	0.0000;
	2708	2673	0.020174	0.052231	0.00545	120	120	120	0	0	1	-360	360	-30.1611	-1.5780	30.3111	1.2948	0.0000	0.0000	0.0000	0.0000;
	2673	2528	0.009504	0.024554	0.00256	114	114	114	0	0	1	-360	360	-50.1517	-11.6145	50.3546	11.8197	0.0000	0.0000	0.0000	0.0000;
	2677	2662	0.01405	0.023141	0.00234	90	90	90	0	0	1	-360	360	-47.8697	15.2743	48.1605	-15.0820	0.0000	0.0000	0.0000	0.0000;
	2670	2672	0.03286	0.076678	0.00771	69	69	69	0	0	1	-360	360	38.8293	-11.3274	-38.3947	11.3971	0.0000	0.0000	0.0000	0.0000;
	2667	2669	0.042231	0.098959	0.00974	69	69	69	0	0	1	-360	360	-23.4568	4.2234	23.6557	-4.9490	0.0000	0.0000	0.0000	0.0000;
	2671	2729	0.073058	0.191901	0.018319	69	69	69	0	0	1	-360	360	15.7786	-12.2453	-15.5556	10.5752	0.0000	0.0000	0.0000	0.0000;
	2672	2597	0.030909	0.081066	0.007739	69	69	69	0	0	1	-360	360	17.5584	-11.9090	-17.4473	11.2524	0.0000	0.0000	0.0000	0.0000;
	2597	2729	0.042066	0.110744	0.010529	69	69	69	0	0	1	-360	360	14.3673	-11.7524	-14.2544	10.7487	0.0000	0.0000	0.0000	0.0000;
	2668	2671	0.016529	0.033058	0.00242	69	69	69	0	0	1	-360	360	-5.6827	-1.7566	5.6875	1.4710	0.0000	0.0000	0.0000	0.0000;
	2570	2490	0.040496	0.071066	0.00673	90	90	90	0	0	1	-360	360	5.2796	-1.8826	-5.2697	1.0799	0.0000	0.0000	0.0000	0.0000;
	2490	2668	0.046281	0.071066	0.007599	78	78	78	0	0	1	-360	360	1.4787	-1.6799	-1.4773	0.7566	0.0000	0.0000	0.0000	0.0000;
	2671	2677	0.004959	0.008256	0.000849	78	78	78	0	0	1	-360	360	-36.5536	16.2789	36.6187	-16.2743	0.0000	0.0000	0.0000	0.0000;
	2571	2570	0.004132	0.013719	0.001379	137	137	137	0	0	1	-360	360	2.2646	-0.7821	-2.2645	0.6145	0.0000	0.0000	0.0000	0.0000;
	2669	2699	0.022752	0.045	0.004593	78	78	78	0	0	1	-360	360	26.3318	-3.0733	-26.2020	2.7679	0.0000	0.0000	0.0000	0.0000;
	2662	2670	0.006347	0.021851	0.002877	78	78	78	0	0	1	-360	360	-68.9395	18.8820	69.2039	-18.3255	0.0000	0.0000	0.0000	0.0000;
	2582	2729	0.04438	0.078256	0.007391	46	46	46	0	0	1	-360	360	-10.5036	-5.5236	10.5529	4.6990	0.0000	0.0000	0.0000	0.0000;
	2612	2582	0.056612	0.099826	0.009431	46	46	46	0	0	1	-360	360	0.8709	-5.4541	-0.8594	4.3236	0.0000	0.0000	0.0000	0.0000;
	2475	2612	0.019752	0.062149	0.006749	90	90	90	0	0	1	-360	360	4.9705	-5.7458	-4.9619	4.9541	0.0000	0.0000	0.0000	0.0000;
	2505	2475	0.036686	0.064711	0.00611	90	90	90	0	0	1	-360	360	17.0394	-5.3202	-16.9445	4.7458	0.0000	0.0000	0.0000	0.0000;
	2491	2672	0.035868	0.071322	0.006241	38	38	38	0	0	1	-360	360	-13.3596	5.3550	13.4218	-5.9930	0.0000	0.0000	0.0000	0.0000;
	2704	2571	0.03438	0.060992	0.005689	137	137	137	0	0	1	-360	360	10.4787	-1.2228	-10.4476	0.5821	0.0000	0.0000	0.0000	0.0000;
	2505	2491	0.035868	0.071322	0.006241	90	90	90	0	0	1	-360	360	-13.6854	4.8202	13.7486	-5.4550	0.0000	0.0000	0.0000	0.0000;
	2489	2530	0.020397	0.06595	0.006771	90	90	90	0	0	1	-360	360	-3.8910	0.7000	3.8942	-1.3916	0.0000	0.0000	0.0000	0.0000;
	2486	2530	0.014554	0.047471	0.00483	120	120	120	0	0	1	-360	360	7.9943	-1.3628	-7.9852	0.8916	0.0000	0.0000	0.0000	0.0000;
	2509	2619	0.006612	0.015703	0.001689	103	103	103	0	0	1	-360	360	45.3110	-1.3519	-45.2022	1.3996	0.0000	0.0000	0.0000	0.0000;
	2514	2478	0.009826	0.017364	0.0016	137	137	137	0	0	1	-360	360	-74.5555	8.7077	75.0148	-8.0899	0.0000	0.0000	0.0000	0.0000;
	2478	2510	0.030248	0.097521	0.010019	86	86	86	0	0	1	-360	360	7.3084	-10.9266	-7.2686	9.8269	0.0000	0.0000	0.0000	0.0000;
	2546	2511	0.011488	0.034711	0.002931	120	120	120	0	0	1	-360	360	-16.1032	-20.7002	16.1672	20.5325	0.0000	0.0000	0.0000	0.0000;
	2705	2546	0.008256	0.028934	0.00363	120	120	120	0	0	1	-360	360	-2.8860	-18.4606	2.9092	18.1002	0.0000	0.0000	0.0000	0.0000;
	2574	2506	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-48.8072	-8.3589	48.8316	8.3921	0.0000	0.0000	0.0000	0.0000;
	2574	2602	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	6.5464	1.2531	-6.5460	-1.3000	0.0000	0.0000	0.0000	0.0000;
	2574	2602	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	6.5464	1.2531	-6.5460	-1.3000	0.0000	0.0000	0.0000	0.0000;
	2513	2705	0.010826	0.034711	0.003579	137	137	137	0	0	1	-360	360	19.2584	-14.4283	-19.2070	14.1606	0.0000	0.0000	0.0000	0.0000;
	2521	2513	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-12.9884	-3.6891	12.9903	3.6484	0.0000	0.0000	0.0000	0.0000;
	2680	2521	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	5.4239	-0.1351	-5.4236	0.0891	0.0000	0.0000	0.0000	0.0000;
	2514	2680	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	12.4835	1.2234	-12.4819	-1.2649	0.0000	0.0000	0.0000	0.0000;
	2478	2726	0.036686	0.118182	0.01217	95	95	95	0	0	1	-360	360	-46.9253	7.5812	47.6097	-6.8689	0.0000	0.0000	0.0000	0.0000;
	2703	2726	0.017364	0.05686	0.005779	137	137	137	0	0	1	-360	360	-59.7034	1.4262	60.2132	-0.4652	0.0000	0.0000	0.0000	0.0000;
	2687	2507	0.032479	0.108099	0.01445	137	137	137	0	0	1	-360	360	-26.7744	-4.1973	26.9685	3.0654	0.0000	0.0000	0.0000	0.0000;
	2676	2506	0.054554	0.180174	0.0242	99	99	99	0	0	1	-360	360	-42.7968	-8.4267	43.6774	8.4215	0.0000	0.0000	0.0000	0.0000;
	2508	2511	0.019174	0.02595	0.004671	69	69	69	0	0	1	-360	360	20.6517	-12.6601	-20.5622	12.2014	0.0000	0.0000	0.0000	0.0000;
	2619	2511	0.01405	0.036364	0.003991	103	103	103	0	0	1	-360	360	24.6432	-5.3996	-24.5716	5.0892	0.0000	0.0000	0.0000	0.0000;
	2644	2510	0.035868	0.090083	0.00924	114	114	114	0	0	1	-360	360	-13.8405	-11.1032	13.9307	10.2037	0.0000	0.0000	0.0000	0.0000;
	2716	2511	0.015	0.047141	0.004661	114	114	114	0	0	1	-360	360	-16.5780	-5.9457	16.6154	5.4874	0.0000	0.0000	0.0000	0.0000;
	2674	2716	0.005248	0.016504	0.001631	114	114	114	0	0	1	-360	360	-10.1286	-4.8377	10.1339	4.6541	0.0000	0.0000	0.0000	0.0000;
	2713	2716	0.000256	0.000661	7e-05	114	114	114	0	0	1	-360	360	-6.4440	-1.3000	6.4441	1.2916	0.0000	0.0000	0.0000	0.0000;
	2645	2702	0.041744	0.073223	0.006921	90	90	90	0	0	1	-360	360	-19.1962	5.8436	19.3367	-6.4379	0.0000	0.0000	0.0000	0.0000;
	2702	2727	0.023058	0.07438	0.00765	137	137	137	0	0	1	-360	360	-42.3497	1.9379	42.6902	-1.7777	0.0000	0.0000	0.0000	0.0000;
	2513	2690	0.000992	0.003471	0.000361	137	137	137	0	0	1	-360	360	-12.1212	1.2101	12.1224	-1.2493	0.0000	0.0000	0.0000	0.0000;
	2627	2674	0.003636	0.010744	0.00106	114	114	114	0	0	1	-360	360	13.0945	-0.4529	-13.0894	0.3377	0.0000	0.0000	0.0000	0.0000;
	2508	2631	0.004628	0.014876	0.00152	137	137	137	0	0	1	-360	360	60.6567	8.9993	-60.5166	-8.7369	0.0000	0.0000	0.0000	0.0000;
	2520	2644	0.003719	0.009339	0.000939	120	120	120	0	0	1	-360	360	7.8469	-7.0077	-7.8435	6.9032	0.0000	0.0000	0.0000	0.0000;
	2514	2520	0.004959	0.012727	0.00128	95	95	95	0	0	1	-360	360	29.8739	-2.7670	-29.8369	2.7077	0.0000	0.0000	0.0000	0.0000;
	2487	2574	0.011157	0.015289	0.002749	114	114	114	0	0	1	-360	360	-22.2704	-3.5301	22.3163	3.2526	0.0000	0.0000	0.0000	0.0000;
	2510	2487	0.011157	0.015289	0.002749	114	114	114	0	0	1	-360	360	-6.4117	-0.7642	6.4154	0.4301	0.0000	0.0000	0.0000	0.0000;
	2511	2675	0.014959	0.043802	0.00445	114	114	114	0	0	1	-360	360	0.4558	3.8629	-0.4537	-4.4081	0.0000	0.0000	0.0000	0.0000;
	2512	2507	0.007603	0.019826	0.002059	120	120	120	0	0	1	-360	360	-33.1625	-3.1790	33.2307	3.1014	0.0000	0.0000	0.0000	0.0000;
	2584	2511	0.034793	0.111901	0.011761	76	76	76	0	0	1	-360	360	-12.6469	-6.0765	12.7007	4.8028	0.0000	0.0000	0.0000	0.0000;
	2687	2584	0.007017	0.022397	0.002369	123	123	123	0	0	1	-360	360	-0.5770	-3.9625	0.5779	3.6765	0.0000	0.0000	0.0000	0.0000;
	2625	2682	0.00843	0.021488	0.002161	120	120	120	0	0	1	-360	360	2.6987	3.6157	-2.6972	-3.8743	0.0000	0.0000	0.0000	0.0000;
	2687	2625	0.00843	0.021488	0.002161	120	120	120	0	0	1	-360	360	4.9514	3.7598	-4.9487	-4.0157	0.0000	0.0000	0.0000	0.0000;
	2572	2578	0.019917	0.052446	0.005191	120	120	120	0	0	1	-360	360	-6.7180	2.4454	6.7267	-3.0523	0.0000	0.0000	0.0000	0.0000;
	2682	2572	0.011868	0.03176	0.003151	120	120	120	0	0	1	-360	360	-6.0998	2.1743	6.1040	-2.5454	0.0000	0.0000	0.0000	0.0000;
	2630	2508	0.005041	0.016859	0.00174	137	137	137	0	0	1	-360	360	6.4913	-3.7117	-6.4890	3.5031	0.0000	0.0000	0.0000	0.0000;
	2455	2508	0.003314	0.010909	0.001111	137	137	137	0	0	1	-360	360	21.2018	-9.4078	-21.1875	9.3170	0.0000	0.0000	0.0000	0.0000;
	2675	2637	0.007769	0.024793	0.00257	137	137	137	0	0	1	-360	360	-0.4673	4.2081	0.4685	-4.5218	0.0000	0.0000	0.0000	0.0000;
	2598	2479	0.007107	0.023141	0.00234	124	124	124	0	0	1	-360	360	-42.9385	-4.6471	43.0481	4.7201	0.0000	0.0000	0.0000	0.0000;
	2631	2599	0.003058	0.009917	0.001019	137	137	137	0	0	1	-360	360	45.9926	5.9369	-45.9392	-5.8895	0.0000	0.0000	0.0000	0.0000;
	2649	2645	0.006446	0.020661	0.00213	137	137	137	0	0	1	-360	360	-31.1396	16.4921	31.2057	-16.5382	0.0000	0.0000	0.0000	0.0000;
	2641	2506	0.00124	0.004132	0.000409	137	137	137	0	0	1	-360	360	-10.9091	0.8284	10.9103	-0.8752	0.0000	0.0000	0.0000	0.0000;
	2642	2507	0.00124	0.004132	0.000409	137	137	137	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0508	0.0000	0.0000	0.0000	0.0000;
	2507	2509	0.020744	0.067273	0.00682	137	137	137	0	0	1	-360	360	-2.6293	-4.1601	2.6328	3.3215	0.0000	0.0000	0.0000	0.0000;
	2641	2525	0.005446	0.017364	0.001769	137	137	137	0	0	1	-360	360	12.8541	-3.0284	-12.8465	2.8329	0.0000	0.0000	0.0000	0.0000;
	2507	2455	0.006124	0.015703	0.001571	120	120	120	0	0	1	-360	360	32.3208	-7.1646	-32.2668	7.1078	0.0000	0.0000	0.0000	0.0000;
	2606	2509	0.001322	0.004207	0.00044	137	137	137	0	0	1	-360	360	-23.4029	-12.6292	23.4103	12.5980	0.0000	0.0000	0.0000	0.0000;
	2506	2606	0.007934	0.022314	0.002149	123	123	123	0	0	1	-360	360	-4.4734	-9.1785	4.4799	8.9292	0.0000	0.0000	0.0000	0.0000;
	2525	2630	0.009091	0.028934	0.002899	137	137	137	0	0	1	-360	360	12.6415	-2.8329	-12.6293	2.5117	0.0000	0.0000	0.0000	0.0000;
	2637	2678	0.007364	0.023719	0.00242	137	137	137	0	0	1	-360	360	-12.9335	1.3218	12.9436	-1.5882	0.0000	0.0000	0.0000	0.0000;
	2479	2649	0.003314	0.010744	0.001089	137	137	137	0	0	1	-360	360	-14.5533	19.6126	14.5696	-19.6921	0.0000	0.0000	0.0000	0.0000;
	2690	2548	0.002066	0.006942	0.000699	137	137	137	0	0	1	-360	360	-18.5664	-0.0507	18.5723	-0.0138	0.0000	0.0000	0.0000	0.0000;
	2703	2645	0.011322	0.036364	0.003751	137	137	137	0	0	1	-360	360	37.2014	-5.8262	-37.0696	5.7946	0.0000	0.0000	0.0000	0.0000;
	2548	2598	0.002893	0.009256	0.000939	137	137	137	0	0	1	-360	360	-31.0503	-2.3862	31.0735	2.3471	0.0000	0.0000	0.0000	0.0000;
	2599	2627	0.002479	0.007438	0.000731	120	120	120	0	0	1	-360	360	23.0272	1.3895	-23.0165	-1.4471	0.0000	0.0000	0.0000	0.0000;
	2549	2512	0.004917	0.023016	0.00236	120	120	120	0	0	1	-360	360	-9.7356	1.1472	9.7395	-1.4210	0.0000	0.0000	0.0000	0.0000;
	2678	2549	0.004917	0.023016	0.00236	120	120	120	0	0	1	-360	360	-13.1486	1.5882	13.1556	-1.8472	0.0000	0.0000	0.0000	0.0000;
	2608	2727	0.001653	0.004959	0.00053	137	137	137	0	0	1	-360	360	-26.7559	1.4721	26.7655	-1.5087	0.0000	0.0000	0.0000	0.0000;
	2485	2676	0.039504	0.124554	0.011761	38	38	38	0	0	1	-360	360	-16.9907	-3.4538	17.0930	2.4183	0.0000	0.0000	0.0000	0.0000;
	2545	2511	0.039504	0.069587	0.00657	72	72	72	0	0	1	-360	360	-45.6626	-5.0460	46.3579	5.4700	0.0000	0.0000	0.0000	0.0000;
	2543	2545	0.053058	0.093554	0.00884	72	72	72	0	0	1	-360	360	-31.2028	-2.5979	31.6506	2.3460	0.0000	0.0000	0.0000	0.0000;
	2666	2543	0.032934	0.106504	0.010931	137	137	137	0	0	1	-360	360	-1.3888	0.9435	1.3900	-2.2076	0.0000	0.0000	0.0000	0.0000;
	2665	2543	0.058066	0.103058	0.00937	76	76	76	0	0	1	-360	360	-9.6150	-1.9000	9.6628	0.9055	0.0000	0.0000	0.0000	0.0000;
	2676	2666	0.024438	0.079017	0.008109	137	137	137	0	0	1	-360	360	3.2188	0.9084	-3.2162	-1.8435	0.0000	0.0000	0.0000	0.0000;
	2465	2726	0.021388	0.069537	0.007289	120	120	120	0	0	1	-360	360	-27.8328	0.8195	27.9684	-1.2751	0.0000	0.0000	0.0000	0.0000;
	2652	2510	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-12.3010	-2.6000	12.3026	2.5573	0.0000	0.0000	0.0000	0.0000;
	2508	2720	0.004628	0.014876	0.00152	120	120	120	0	0	1	-360	360	15.3521	2.8407	-15.3430	-3.0000	0.0000	0.0000	0.0000	0.0000;
	2509	2719	0.004628	0.014876	0.00152	120	120	120	0	0	1	-360	360	13.4059	2.4324	-13.3990	-2.6000	0.0000	0.0000	0.0000	0.0000;
	2626	2507	0.01281	0.021488	0.00212	78	78	78	0	0	1	-360	360	-45.6872	0.1195	45.9043	-0.0176	0.0000	0.0000	0.0000	0.0000;
	2476	2626	0.026198	0.043967	0.004339	78	78	78	0	0	1	-360	360	-40.1226	1.1746	40.4712	-1.1195	0.0000	0.0000	0.0000	0.0000;
	2588	2460	0.03905	0.126281	0.012971	95	95	95	0	0	1	-360	360	-28.8949	-4.3478	29.1785	3.7298	0.0000	0.0000	0.0000	0.0000;
	2714	2604	0.011653	0.037686	0.00387	137	137	137	0	0	1	-360	360	-46.3538	-8.2176	46.5640	8.4199	0.0000	0.0000	0.0000	0.0000;
	2460	2714	0.021397	0.069174	0.0071	137	137	137	0	0	1	-360	360	-40.4295	-6.2298	40.7270	6.3301	0.0000	0.0000	0.0000	0.0000;
	2468	2714	0.00281	0.009174	0.000939	123	123	123	0	0	1	-360	360	-5.6260	-2.0000	5.6268	1.8875	0.0000	0.0000	0.0000	0.0000;
	2679	2603	0.158017	0.182727	0.016429	46	46	46	0	0	1	-360	360	-14.3423	-5.1518	14.6408	3.5052	0.0000	0.0000	0.0000	0.0000;
	2616	2604	0.009826	0.017521	0.0016	80	80	80	0	0	1	-360	360	-25.9686	-2.0184	26.0225	1.9160	0.0000	0.0000	0.0000	0.0000;
	2515	2600	0.010388	0.050826	0.004939	133	133	133	0	0	1	-360	360	-33.9403	-13.8595	34.0533	13.8010	0.0000	0.0000	0.0000	0.0000;
	2576	2600	0.036033	0.128934	0.012509	69	69	69	0	0	1	-360	360	-39.1721	-4.8402	39.6349	4.9602	0.0000	0.0000	0.0000	0.0000;
	2492	2603	0.022339	0.074959	0.00748	69	69	69	0	0	1	-360	360	-20.5976	-8.4128	20.6867	7.7900	0.0000	0.0000	0.0000	0.0000;
	2456	2576	0.041397	0.069421	0.00711	69	69	69	0	0	1	-360	360	-26.4360	-2.6402	26.6825	2.2040	0.0000	0.0000	0.0000	0.0000;
	2524	2576	0.033141	0.061157	0.006389	69	69	69	0	0	1	-360	360	-3.5800	-1.0000	3.5836	0.2362	0.0000	0.0000	0.0000	0.0000;
	2557	2456	0.037686	0.121488	0.01249	69	69	69	0	0	1	-360	360	-14.0975	-1.9001	14.1620	0.6402	0.0000	0.0000	0.0000	0.0000;
	2559	2557	0.019422	0.06281	0.00649	69	69	69	0	0	1	-360	360	-7.9489	-0.6233	7.9595	-0.0999	0.0000	0.0000	0.0000	0.0000;
	2605	2600	0.035868	0.115702	0.012199	140	140	140	0	0	1	-360	360	-9.8799	-14.8261	9.9678	13.6107	0.0000	0.0000	0.0000	0.0000;
	2538	2601	0.030248	0.097521	0.01028	140	140	140	0	0	1	-360	360	-10.3569	-2.4109	10.3838	1.2196	0.0000	0.0000	0.0000	0.0000;
	2569	2532	0.009826	0.017273	0.001631	69	69	69	0	0	1	-360	360	-7.2118	6.9776	7.2203	-7.1552	0.0000	0.0000	0.0000	0.0000;
	2610	2569	0.053223	0.093471	0.008821	69	69	69	0	0	1	-360	360	4.0869	9.0101	-4.0392	-9.9776	0.0000	0.0000	0.0000	0.0000;
	2614	2607	0.006612	0.013719	0.001331	69	69	69	0	0	1	-360	360	13.5244	2.0979	-13.5144	-2.2411	0.0000	0.0000	0.0000	0.0000;
	2607	2615	0.005372	0.017364	0.001791	69	69	69	0	0	1	-360	360	-7.9646	-3.2589	7.9678	3.0486	0.0000	0.0000	0.0000	0.0000;
	2588	2559	0.023388	0.075868	0.007841	34	34	34	0	0	1	-360	360	5.9351	-0.8667	-5.9280	-0.0246	0.0000	0.0000	0.0000	0.0000;
	2615	2603	0.01157	0.037686	0.00387	69	69	69	0	0	1	-360	360	-21.8338	-6.7486	21.8825	6.4281	0.0000	0.0000	0.0000	0.0000;
	2589	2601	0.033099	0.111066	0.011059	114	114	114	0	0	1	-360	360	-26.6139	-10.9038	26.8368	10.2942	0.0000	0.0000	0.0000	0.0000;
	2592	2605	0.028182	0.091157	0.009341	69	69	69	0	0	1	-360	360	-0.6350	-13.3182	0.6739	12.3261	0.0000	0.0000	0.0000	0.0000;
	2610	2515	0.024463	0.043471	0.004039	69	69	69	0	0	1	-360	360	-28.1229	-12.5101	28.3143	12.3595	0.0000	0.0000	0.0000	0.0000;
	2609	2604	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	-10.2280	-2.0000	10.2338	1.8466	0.0000	0.0000	0.0000	0.0000;
	2616	2614	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	20.7082	3.9829	-20.6844	-4.0979	0.0000	0.0000	0.0000	0.0000;
	2589	2585	0.020496	0.06876	0.00688	69	69	69	0	0	1	-360	360	11.7829	7.4038	-11.7489	-8.1150	0.0000	0.0000	0.0000	0.0000;
	2646	2559	0.015678	0.050702	0.005201	84	84	84	0	0	1	-360	360	-6.1380	-1.5000	6.1433	0.9120	0.0000	0.0000	0.0000	0.0000;
	2600	2603	0.01281	0.042984	0.004281	114	114	114	0	0	1	-360	360	12.1536	2.4691	-12.1377	-2.9490	0.0000	0.0000	0.0000	0.0000;
	2601	2604	0.01281	0.042984	0.004281	114	114	114	0	0	1	-360	360	11.3013	2.3010	-11.2875	-2.7880	0.0000	0.0000	0.0000	0.0000;
	2538	2616	0.014463	0.055537	0.004479	69	69	69	0	0	1	-360	360	-0.8941	0.9109	0.8944	-1.4645	0.0000	0.0000	0.0000	0.0000;
	2461	2498	0.023554	0.062149	0.006389	82	82	82	0	0	1	-360	360	-32.5943	9.4974	32.8188	-9.6840	0.0000	0.0000	0.0000	0.0000;
	2539	2461	0.027603	0.049504	0.004479	69	69	69	0	0	1	-360	360	-2.9427	-1.5274	2.9450	0.9869	0.0000	0.0000	0.0000	0.0000;
	2519	2539	0.039669	0.07157	0.006411	69	69	69	0	0	1	-360	360	-2.9387	-2.2971	2.9427	1.5274	0.0000	0.0000	0.0000	0.0000;
	2550	2519	0.029826	0.057934	0.005469	69	69	69	0	0	1	-360	360	3.2025	-2.9500	-3.1983	2.2971	0.0000	0.0000	0.0000	0.0000;
	2555	2497	0.009256	0.030083	0.003071	119	119	119	0	0	1	-360	360	-30.7640	-3.2612	30.8369	3.1245	0.0000	0.0000	0.0000	0.0000;
	2664	2658	0.053141	0.093388	0.008901	69	69	69	0	0	1	-360	360	-18.4542	6.4317	18.6360	-7.1264	0.0000	0.0000	0.0000	0.0000;
	2552	2555	0.001322	0.004207	0.00044	99	99	99	0	0	1	-360	360	-15.1725	-1.7066	15.1750	1.6612	0.0000	0.0000	0.0000	0.0000;
	2554	2498	0.009091	0.029752	0.00302	137	137	137	0	0	1	-360	360	-22.8556	-2.7385	22.8952	2.5001	0.0000	0.0000	0.0000	0.0000;
	2496	2497	0.055041	0.164298	0.016819	69	69	69	0	0	1	-360	360	2.5065	-3.0830	-2.5018	1.0473	0.0000	0.0000	0.0000	0.0000;
	2723	2493	0.036529	0.064132	0.00605	69	69	69	0	0	1	-360	360	-0.1478	-5.6585	0.1570	4.9889	0.0000	0.0000	0.0000	0.0000;
	2565	2554	0.01595	0.05124	0.0053	137	137	137	0	0	1	-360	360	-4.4297	-1.9722	4.4326	1.3385	0.0000	0.0000	0.0000	0.0000;
	2565	2552	0.007438	0.023967	0.002461	126	126	126	0	0	1	-360	360	1.7049	-2.0037	-1.7045	1.7066	0.0000	0.0000	0.0000	0.0000;
	2629	2531	0.036686	0.116686	0.012509	69	69	69	0	0	1	-360	360	-20.4867	-2.5322	20.6168	1.4424	0.0000	0.0000	0.0000	0.0000;
	2723	2664	0.083141	0.146281	0.01392	69	69	69	0	0	1	-360	360	-14.6847	5.6881	14.8742	-6.9317	0.0000	0.0000	0.0000	0.0000;
	2700	2497	0.026612	0.089422	0.008949	137	137	137	0	0	1	-360	360	-17.0364	-0.0118	17.1002	-0.8627	0.0000	0.0000	0.0000	0.0000;
	2565	2663	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	-9.5493	3.4759	9.5785	-4.1379	0.0000	0.0000	0.0000	0.0000;
	2547	2550	0.005207	0.014132	0.001401	90	90	90	0	0	1	-360	360	-8.6940	-1.1000	8.6973	0.9397	0.0000	0.0000	0.0000	0.0000;
	2550	2700	0.01843	0.061901	0.0062	137	137	137	0	0	1	-360	360	-11.8998	-0.1897	11.9214	-0.4882	0.0000	0.0000	0.0000	0.0000;
	2488	2723	0.001818	0.003876	0.000271	76	76	76	0	0	1	-360	360	-5.6260	0.0000	5.6265	-0.0295	0.0000	0.0000	0.0000	0.0000;
	2657	2658	0.003471	0.012636	0.001191	123	123	123	0	0	1	-360	360	-33.7540	-3.6000	33.7891	3.5918	0.0000	0.0000	0.0000	0.0000;
	2502	2724	0.003314	0.010578	0.001089	137	137	137	0	0	1	-360	360	-22.5923	-4.8152	22.6074	4.7352	0.0000	0.0000	0.0000	0.0000;
	2643	2502	0.029752	0.095868	0.01007	137	137	137	0	0	1	-360	360	-10.2882	-3.9946	10.3183	2.9152	0.0000	0.0000	0.0000	0.0000;
	2581	2643	0.005124	0.016529	0.00174	137	137	137	0	0	1	-360	360	3.9296	-2.0940	-3.9288	1.8946	0.0000	0.0000	0.0000	0.0000;
	2560	2594	0.033471	0.065289	0.005929	21	21	21	0	0	1	-360	360	-4.9090	0.0000	4.9158	-0.6926	0.0000	0.0000	0.0000	0.0000;
	2467	2628	0.016529	0.031397	0.002899	48	48	48	0	0	1	-360	360	-3.5455	4.2815	3.5500	-4.6153	0.0000	0.0000	0.0000	0.0000;
	2634	2467	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	3.0473	4.6974	-3.0375	-5.3815	0.0000	0.0000	0.0000	0.0000;
	2628	2500	0.016529	0.031397	0.003151	48	48	48	0	0	1	-360	360	-5.6980	4.1153	5.7051	-4.4734	0.0000	0.0000	0.0000	0.0000;
	2611	2634	0.022884	0.074	0.007592	69	69	69	0	0	1	-360	360	5.6187	5.3297	-5.6063	-6.1974	0.0000	0.0000	0.0000	0.0000;
	2724	2499	0.001653	0.005289	0.00053	137	137	137	0	0	1	-360	360	-38.5634	-7.5352	38.5850	7.5421	0.0000	0.0000	0.0000	0.0000;
	2501	2500	0.009091	0.028099	0.00288	133	133	133	0	0	1	-360	360	-22.5381	2.7533	22.5780	-2.9692	0.0000	0.0000	0.0000	0.0000;
	2564	2562	0.00405	0.013314	0.001379	95	95	95	0	0	1	-360	360	-24.6038	1.3712	24.6248	-1.4638	0.0000	0.0000	0.0000	0.0000;
	2583	2564	0.020744	0.066281	0.006989	126	126	126	0	0	1	-360	360	-12.5058	2.3463	12.5348	-3.0712	0.0000	0.0000	0.0000	0.0000;
	2683	2583	0.028347	0.092231	0.009511	137	137	137	0	0	1	-360	360	-0.3327	1.5360	0.3338	-2.6463	0.0000	0.0000	0.0000	0.0000;
	2562	2581	0.040331	0.130413	0.013361	137	137	137	0	0	1	-360	360	17.5368	-1.8101	-17.4306	0.5940	0.0000	0.0000	0.0000	0.0000;
	2623	2501	0.020413	0.066124	0.006781	95	95	95	0	0	1	-360	360	-5.2442	3.8799	5.2521	-4.6533	0.0000	0.0000	0.0000	0.0000;
	2743	1955	0.057868	0.101322	0.00967	78	78	78	0	0	1	-360	360	-55.0000	-13.0000	56.6420	14.7463	0.0000	0.0000	0.0000	0.0000;
	2744	1956	0.057868	0.101322	0.00967	78	78	78	0	0	1	-360	360	-54.0000	-14.0000	55.6051	15.6854	0.0000	0.0000	0.0000	0.0000;
	2740	820	0.02562	0.084711	0.008477	123	123	123	0	0	1	-360	360	60.0000	-0.0000	-59.2647	1.3804	0.0000	0.0000	0.0000	0.0000;
	2740	820	0.02562	0.084711	0.008477	123	123	123	0	0	1	-360	360	60.0000	-0.0000	-59.2647	1.3804	0.0000	0.0000	0.0000	0.0000;
	2745	1430	0.010413	0.033554	0.003543	140	140	140	0	0	1	-360	360	-25.0000	-10.0000	25.0673	9.8197	0.0000	0.0000	0.0000	0.0000;
	2746	1876	0.009752	0.030496	0.003151	140	140	140	0	0	1	-360	360	-65.0000	-26.0000	65.4353	27.0114	0.0000	0.0000	0.0000	0.0000;
	2742	1524	0.005702	0.018264	0.001922	57	57	57	0	0	1	-360	360	-33.0000	-12.0000	33.0615	11.9770	0.0000	0.0000	0.0000	0.0000;
	2741	1525	0.005702	0.018264	0.001922	57	57	57	0	0	1	-360	360	-33.0000	-12.0000	33.0615	11.9770	0.0000	0.0000	0.0000	0.0000;
	5	4	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-23.4783	35.1206	23.4786	-35.1175	0.0000	0.0000	0.0000	0.0000;
	7	6	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	103.9045	64.8940	-103.9018	-64.8664	0.0000	0.0000	0.0000	0.0000;
	9	8	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	154.0782	10.7555	-154.0768	-10.7414	0.0000	0.0000	0.0000	0.0000;
	11	10	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	111.4308	-61.8283	-111.4277	61.8593	0.0000	0.0000	0.0000	0.0000;
	12	11	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	79.0662	9.1318	-79.0650	-9.1198	0.0000	0.0000	0.0000	0.0000;
	14	13	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	294.4718	44.1229	-294.4666	-44.0704	0.0000	0.0000	0.0000	0.0000;
	16	15	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	18	17	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	12.4547	10.2348	-12.4547	-10.2344	0.0000	0.0000	0.0000	0.0000;
	20	19	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	12.8725	17.8357	-12.8724	-17.8348	0.0000	0.0000	0.0000	0.0000;
	22	21	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-19.7819	-32.1051	19.7822	32.1077	0.0000	0.0000	0.0000	0.0000;
	29	28	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	179.6890	48.2778	-179.6870	-48.2581	0.0000	0.0000	0.0000	0.0000;
	38	37	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-44.6425	-0.2861	44.6429	0.2895	0.0000	0.0000	0.0000	0.0000;
	41	40	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	15.7292	-25.2795	-15.7291	25.2810	0.0000	0.0000	0.0000	0.0000;
	44	43	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	283.5714	-25.9937	-283.5578	26.1296	0.0000	0.0000	0.0000	0.0000;
	46	45	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-41.1280	52.5620	41.1282	-52.5594	0.0000	0.0000	0.0000	0.0000;
	49	48	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-269.2030	-24.4093	269.2073	24.4519	0.0000	0.0000	0.0000	0.0000;
	52	51	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	2.8398	-7.9705	-2.8397	7.9707	0.0000	0.0000	0.0000	0.0000;
	54	53	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	50.1862	-4.2608	-50.1861	4.2622	0.0000	0.0000	0.0000	0.0000;
	56	55	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	28.2063	-49.3526	-28.2058	49.3581	0.0000	0.0000	0.0000	0.0000;
	58	57	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-146.2917	51.2439	146.2930	-51.2302	0.0000	0.0000	0.0000	0.0000;
	60	59	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.2269	4.1248	0.2269	-4.1248	0.0000	0.0000	0.0000	0.0000;
	63	62	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-32.5542	2.1023	32.5544	-2.1005	0.0000	0.0000	0.0000	0.0000;
	65	64	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-366.3434	8.9649	366.3511	-8.8883	0.0000	0.0000	0.0000	0.0000;
	73	72	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	95.7915	18.1910	-95.7898	-18.1749	0.0000	0.0000	0.0000	0.0000;
	75	74	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-43.8713	-16.3421	43.8716	16.3459	0.0000	0.0000	0.0000	0.0000;
	77	76	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-83.5052	-8.3352	83.5064	8.3471	0.0000	0.0000	0.0000	0.0000;
	79	78	2.1e-05	0.000207	0	876	876	876	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	81	80	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	13.5853	7.2757	-13.5852	-7.2753	0.0000	0.0000	0.0000	0.0000;
	85	84	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-19.2935	3.4517	19.2935	-3.4511	0.0000	0.0000	0.0000	0.0000;
	87	86	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-61.9373	-10.8048	61.9380	10.8115	0.0000	0.0000	0.0000	0.0000;
	89	88	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-15.0286	-9.6939	15.0287	9.6944	0.0000	0.0000	0.0000	0.0000;
	91	90	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-57.4805	-5.9900	57.4811	5.9957	0.0000	0.0000	0.0000	0.0000;
	93	92	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-55.3458	13.1857	55.3460	-13.1839	0.0000	0.0000	0.0000	0.0000;
	95	94	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	8.9087	20.1520	-8.9086	-20.1511	0.0000	0.0000	0.0000	0.0000;
	97	96	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-45.9301	18.6153	45.9305	-18.6111	0.0000	0.0000	0.0000	0.0000;
	99	98	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-52.0083	-1.8436	52.0088	1.8481	0.0000	0.0000	0.0000	0.0000;
	101	100	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	1.8051	-9.9326	-1.8051	9.9327	0.0000	0.0000	0.0000	0.0000;
	103	102	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-106.2162	-24.9182	106.2183	24.9384	0.0000	0.0000	0.0000	0.0000;
	105	104	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-6.1039	-2.2539	6.1039	2.2539	0.0000	0.0000	0.0000	0.0000;
	107	106	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.6381	-40.9022	0.6384	40.9050	0.0000	0.0000	0.0000	0.0000;
	109	108	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-64.1519	28.9492	64.1528	-28.9408	0.0000	0.0000	0.0000	0.0000;
	112	111	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	3.2519	12.3242	-3.2518	-12.3240	0.0000	0.0000	0.0000	0.0000;
	114	113	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	104.0558	25.5243	-104.0538	-25.5046	0.0000	0.0000	0.0000	0.0000;
	117	116	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	71.0547	9.0345	-71.0538	-9.0258	0.0000	0.0000	0.0000	0.0000;
	119	118	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-124.6070	-7.7757	124.6096	7.8020	0.0000	0.0000	0.0000	0.0000;
	121	120	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	242.3359	40.6336	-242.3325	-40.5993	0.0000	0.0000	0.0000	0.0000;
	123	122	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	161.9094	-3.0108	-161.9079	3.0256	0.0000	0.0000	0.0000	0.0000;
	126	125	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-18.2822	-21.0651	18.2823	21.0664	0.0000	0.0000	0.0000	0.0000;
	128	127	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-69.9104	33.7774	69.9107	-33.7739	0.0000	0.0000	0.0000	0.0000;
	130	129	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	38.4314	9.7992	-38.4311	-9.7966	0.0000	0.0000	0.0000	0.0000;
	135	134	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-104.5345	-56.0427	104.5368	56.0663	0.0000	0.0000	0.0000	0.0000;
	139	138	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-40.2369	21.2287	40.2371	-21.2275	0.0000	0.0000	0.0000	0.0000;
	142	141	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	145	144	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	147	146	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-112.4154	0.2734	112.4175	-0.2521	0.0000	0.0000	0.0000	0.0000;
	149	148	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	53.9148	-7.6276	-53.9143	7.6325	0.0000	0.0000	0.0000	0.0000;
	151	150	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	130.2750	40.5509	-130.2739	-40.5400	0.0000	0.0000	0.0000	0.0000;
	154	153	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	65.1010	36.2772	-65.1000	-36.2673	0.0000	0.0000	0.0000	0.0000;
	157	155	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	159	158	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	167.0241	59.2743	-167.0222	-59.2559	0.0000	0.0000	0.0000	0.0000;
	161	160	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	164	163	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-60.7320	5.1644	60.7322	-5.1622	0.0000	0.0000	0.0000	0.0000;
	166	165	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-190.8367	17.9336	190.8428	-17.8720	0.0000	0.0000	0.0000	0.0000;
	167	165	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	171	170	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	58.8724	-56.8748	-58.8712	56.8866	0.0000	0.0000	0.0000	0.0000;
	173	172	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	175	174	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	63.5013	-0.2896	-63.5006	0.2972	0.0000	0.0000	0.0000	0.0000;
	178	177	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	63.9243	14.2072	-63.9235	-14.1997	0.0000	0.0000	0.0000	0.0000;
	180	179	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	185	184	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-128.7314	51.1782	128.7325	-51.1670	0.0000	0.0000	0.0000	0.0000;
	187	186	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-111.4618	43.0482	111.4627	-43.0396	0.0000	0.0000	0.0000	0.0000;
	189	188	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-8.8471	38.3702	8.8474	-38.3671	0.0000	0.0000	0.0000	0.0000;
	191	190	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-20.1934	-58.1998	20.1941	58.2066	0.0000	0.0000	0.0000	0.0000;
	194	193	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	39.8260	35.7344	-39.8255	-35.7291	0.0000	0.0000	0.0000	0.0000;
	196	195	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-144.5501	-61.8498	144.5516	61.8651	0.0000	0.0000	0.0000	0.0000;
	198	197	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	66.3126	17.0049	-66.3118	-16.9963	0.0000	0.0000	0.0000	0.0000;
	200	199	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	166.1745	24.6981	-166.1728	-24.6818	0.0000	0.0000	0.0000	0.0000;
	202	201	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	15.8663	-21.2967	-15.8661	21.2981	0.0000	0.0000	0.0000	0.0000;
	204	203	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-134.3020	-27.2439	134.3055	27.2791	0.0000	0.0000	0.0000	0.0000;
	206	205	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	9.0571	13.3015	-9.0571	-13.3014	0.0000	0.0000	0.0000	0.0000;
	208	207	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	59.5232	6.2586	-59.5225	-6.2523	0.0000	0.0000	0.0000	0.0000;
	214	213	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	222	221	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	243	242	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	62.7257	9.2742	-62.7230	-9.2476	0.0000	0.0000	0.0000	0.0000;
	249	248	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	258	257	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-41.1784	-5.1060	41.1797	5.1183	0.0000	0.0000	0.0000	0.0000;
	265	264	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	281	280	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	283	282	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	38.5762	-31.7491	-38.5745	31.7668	0.0000	0.0000	0.0000	0.0000;
	295	294	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	316	315	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	22.4950	-9.8156	-22.4946	9.8200	0.0000	0.0000	0.0000	0.0000;
	323	322	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	332	331	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	340	339	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	342	341	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.9135	22.0125	18.9141	-22.0065	0.0000	0.0000	0.0000	0.0000;
	352	351	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	359	358	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	152.9707	2.4942	-152.9543	-2.3294	0.0000	0.0000	0.0000	0.0000;
	377	376	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-48.3022	13.9779	48.3040	-13.9596	0.0000	0.0000	0.0000	0.0000;
	383	382	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	391	390	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	404	403	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	419	418	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.2770	-5.0740	22.2774	5.0778	0.0000	0.0000	0.0000	0.0000;
	427	426	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.2521	-1.1904	8.2521	1.1909	0.0000	0.0000	0.0000	0.0000;
	434	433	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	439	438	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-53.2957	1.0198	53.2977	-0.9997	0.0000	0.0000	0.0000	0.0000;
	462	461	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	72.0572	3.1889	-72.0536	-3.1528	0.0000	0.0000	0.0000	0.0000;
	473	472	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	483	482	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	485	484	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	487	486	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	489	488	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.8765	-1.4168	9.8766	1.4175	0.0000	0.0000	0.0000	0.0000;
	494	493	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	68.3551	21.9327	-68.3514	-21.8957	0.0000	0.0000	0.0000	0.0000;
	507	506	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	509	508	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.9264	-1.8822	33.9272	1.8900	0.0000	0.0000	0.0000	0.0000;
	515	514	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.3303	6.4216	-26.3298	-6.4164	0.0000	0.0000	0.0000	0.0000;
	517	516	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	520	519	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	529	528	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	531	530	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	535	534	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	537	536	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	540	539	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.4500	3.6956	-2.4500	-3.6954	0.0000	0.0000	0.0000	0.0000;
	546	545	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	550	549	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	555	554	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	571	570	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.4894	23.3294	-14.4889	-23.3243	0.0000	0.0000	0.0000	0.0000;
	574	573	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	584	583	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.5806	8.7325	-15.5804	-8.7303	0.0000	0.0000	0.0000	0.0000;
	590	589	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.4384	-1.5833	15.4385	1.5850	0.0000	0.0000	0.0000	0.0000;
	610	609	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	614	613	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-40.8814	-4.7864	40.8826	4.7984	0.0000	0.0000	0.0000	0.0000;
	661	660	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.4746	-34.6382	-36.4730	34.6549	0.0000	0.0000	0.0000	0.0000;
	682	681	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-52.7537	-1.1391	52.7556	1.1584	0.0000	0.0000	0.0000	0.0000;
	693	692	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-66.9324	-3.2593	66.9355	3.2906	0.0000	0.0000	0.0000	0.0000;
	711	710	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.6116	1.3561	-21.6113	-1.3528	0.0000	0.0000	0.0000	0.0000;
	727	726	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	66.5277	9.4137	-66.5245	-9.3818	0.0000	0.0000	0.0000	0.0000;
	737	736	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.0500	-0.9019	3.0501	0.9020	0.0000	0.0000	0.0000	0.0000;
	755	754	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.3156	-5.2613	-17.3154	5.2636	0.0000	0.0000	0.0000	0.0000;
	765	764	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.5840	2.3951	9.5841	-2.3944	0.0000	0.0000	0.0000	0.0000;
	775	774	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.0109	-1.5197	20.0112	1.5225	0.0000	0.0000	0.0000	0.0000;
	804	803	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	843	842	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.1757	-7.6849	-2.1757	7.6853	0.0000	0.0000	0.0000	0.0000;
	846	845	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	40.4085	-0.7065	-40.4073	0.7183	0.0000	0.0000	0.0000	0.0000;
	848	847	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.6382	3.5271	-13.6381	-3.5257	0.0000	0.0000	0.0000	0.0000;
	849	848	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.6283	3.5179	-10.6282	-3.5171	0.0000	0.0000	0.0000	0.0000;
	851	850	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-38.3710	-3.9193	38.3720	3.9296	0.0000	0.0000	0.0000	0.0000;
	853	852	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.7386	-1.9284	13.7387	1.9297	0.0000	0.0000	0.0000	0.0000;
	857	856	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.3611	5.9261	6.3611	-5.9256	0.0000	0.0000	0.0000	0.0000;
	860	859	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.0258	-2.1147	5.0258	2.1149	0.0000	0.0000	0.0000	0.0000;
	862	861	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	865	864	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.6369	-4.7038	23.6373	4.7080	0.0000	0.0000	0.0000	0.0000;
	867	866	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.5084	2.6543	-4.5084	-2.6541	0.0000	0.0000	0.0000	0.0000;
	869	868	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	872	871	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.5807	-12.4433	33.5816	12.4521	0.0000	0.0000	0.0000	0.0000;
	874	873	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	879	878	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.5996	-3.5475	17.5999	3.5499	0.0000	0.0000	0.0000	0.0000;
	881	880	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.7836	-2.1335	11.7837	2.1344	0.0000	0.0000	0.0000	0.0000;
	887	886	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	51.3972	-0.0175	-51.3955	0.0349	0.0000	0.0000	0.0000	0.0000;
	891	890	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.8669	5.5844	17.8672	-5.5818	0.0000	0.0000	0.0000	0.0000;
	893	892	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	896	895	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	897	896	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-38.8494	-36.0869	38.8513	36.1064	0.0000	0.0000	0.0000	0.0000;
	895	897	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	899	898	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.8833	-5.7234	16.8835	5.7256	0.0000	0.0000	0.0000	0.0000;
	901	900	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4738	-2.1748	3.4738	2.1749	0.0000	0.0000	0.0000	0.0000;
	903	902	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.7070	-0.6300	15.7072	0.6319	0.0000	0.0000	0.0000	0.0000;
	908	907	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	914	913	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.0526	-3.5779	33.0533	3.5857	0.0000	0.0000	0.0000	0.0000;
	916	915	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.2621	3.5364	3.2621	-3.5362	0.0000	0.0000	0.0000	0.0000;
	918	917	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	920	919	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	924	923	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.4547	-2.7416	30.4553	2.7482	0.0000	0.0000	0.0000	0.0000;
	926	925	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	928	927	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.2202	9.1494	-9.2201	-9.1481	0.0000	0.0000	0.0000	0.0000;
	930	929	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.6248	4.0719	-13.6246	-4.0704	0.0000	0.0000	0.0000	0.0000;
	932	931	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	42.8603	14.1422	-42.8589	-14.1280	0.0000	0.0000	0.0000	0.0000;
	936	935	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.1047	-8.1960	2.1048	8.1965	0.0000	0.0000	0.0000	0.0000;
	938	937	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	33.2203	7.1306	-33.2195	-7.1228	0.0000	0.0000	0.0000	0.0000;
	940	939	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	943	942	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	945	944	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.4928	1.2975	-7.4927	-1.2971	0.0000	0.0000	0.0000	0.0000;
	951	950	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	33.5483	12.4721	-33.5474	-12.4633	0.0000	0.0000	0.0000	0.0000;
	953	952	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	84.4089	3.4462	-84.4039	-3.3960	0.0000	0.0000	0.0000	0.0000;
	957	956	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.4705	-2.6897	25.4710	2.6945	0.0000	0.0000	0.0000	0.0000;
	959	958	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.1085	-0.7884	11.1086	0.7893	0.0000	0.0000	0.0000	0.0000;
	961	960	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.5381	1.8827	-14.5380	-1.8812	0.0000	0.0000	0.0000	0.0000;
	963	962	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	31.2625	3.6525	-31.2618	-3.6453	0.0000	0.0000	0.0000	0.0000;
	965	964	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.0116	7.3153	-10.0115	-7.3143	0.0000	0.0000	0.0000	0.0000;
	967	966	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.1317	2.2600	-11.1316	-2.2591	0.0000	0.0000	0.0000	0.0000;
	969	968	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.0611	-2.8360	29.0617	2.8420	0.0000	0.0000	0.0000	0.0000;
	971	970	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	23.6113	-2.3544	-23.6109	2.3583	0.0000	0.0000	0.0000	0.0000;
	973	972	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	975	974	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.6025	-0.7336	17.6027	0.7357	0.0000	0.0000	0.0000	0.0000;
	977	976	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	65.1011	15.4186	-65.0980	-15.3881	0.0000	0.0000	0.0000	0.0000;
	979	978	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.2504	14.0080	27.2511	-14.0015	0.0000	0.0000	0.0000	0.0000;
	983	982	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.7051	0.9305	-27.7045	-0.9252	0.0000	0.0000	0.0000	0.0000;
	985	984	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.5444	-7.3239	-0.5443	7.3243	0.0000	0.0000	0.0000	0.0000;
	987	986	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	31.0175	-0.8328	-31.0168	0.8394	0.0000	0.0000	0.0000	0.0000;
	991	990	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-36.9746	-3.1129	36.9755	3.1225	0.0000	0.0000	0.0000	0.0000;
	993	992	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	995	994	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	997	996	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	34.7032	9.3116	-34.7024	-9.3026	0.0000	0.0000	0.0000	0.0000;
	998	999	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1001	1000	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	30.3102	2.1389	-30.3095	-2.1324	0.0000	0.0000	0.0000	0.0000;
	1003	1002	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.6891	3.9072	0.6891	-3.9071	0.0000	0.0000	0.0000	0.0000;
	1005	1004	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-50.4633	-13.4543	50.4652	13.4726	0.0000	0.0000	0.0000	0.0000;
	1007	1006	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-47.5926	-6.8145	47.5942	6.8311	0.0000	0.0000	0.0000	0.0000;
	1009	1008	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.7684	11.0450	-19.7680	-11.0413	0.0000	0.0000	0.0000	0.0000;
	1011	1010	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1012	1011	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1010	1012	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1016	1015	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.9816	6.9086	12.9817	-6.9071	0.0000	0.0000	0.0000	0.0000;
	1022	1021	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	40.1906	-3.7186	-40.1895	3.7298	0.0000	0.0000	0.0000	0.0000;
	1023	1022	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.4172	-4.4696	20.4175	4.4726	0.0000	0.0000	0.0000	0.0000;
	1033	1032	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.4583	-9.4283	24.4587	9.4329	0.0000	0.0000	0.0000	0.0000;
	1037	1036	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.4689	4.5087	-12.4688	-4.5075	0.0000	0.0000	0.0000	0.0000;
	1039	1038	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.0277	-6.0920	2.0277	6.0923	0.0000	0.0000	0.0000	0.0000;
	1041	1040	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.1596	0.0454	4.1596	-0.0453	0.0000	0.0000	0.0000	0.0000;
	1043	1042	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1045	1044	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	52.5972	16.1441	-52.5951	-16.1231	0.0000	0.0000	0.0000	0.0000;
	1047	1046	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.4350	6.6026	-26.4345	-6.5976	0.0000	0.0000	0.0000	0.0000;
	1049	1048	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.8242	-10.9490	-12.8240	10.9510	0.0000	0.0000	0.0000	0.0000;
	1055	1054	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.4899	1.6859	22.4903	-1.6823	0.0000	0.0000	0.0000	0.0000;
	1057	1056	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1059	1058	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.6138	-3.9741	9.6139	3.9748	0.0000	0.0000	0.0000	0.0000;
	1062	1061	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.1710	-2.9727	-13.1708	2.9741	0.0000	0.0000	0.0000	0.0000;
	1065	1064	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-32.1740	0.6965	32.1747	-0.6894	0.0000	0.0000	0.0000	0.0000;
	1067	1066	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.1466	5.9109	-21.1463	-5.9076	0.0000	0.0000	0.0000	0.0000;
	1069	1068	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.8450	3.4033	-25.8445	-3.3986	0.0000	0.0000	0.0000	0.0000;
	1071	1070	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.4123	5.0603	24.4128	-5.0559	0.0000	0.0000	0.0000	0.0000;
	1073	1072	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	79.4859	6.9398	-79.4816	-6.8970	0.0000	0.0000	0.0000	0.0000;
	1075	1074	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	34.0251	4.7362	-34.0243	-4.7275	0.0000	0.0000	0.0000	0.0000;
	1077	1076	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.9900	0.4521	9.9901	-0.4514	0.0000	0.0000	0.0000	0.0000;
	1079	1078	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1083	1082	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-55.7535	-3.7509	55.7556	3.7721	0.0000	0.0000	0.0000	0.0000;
	1085	1084	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.7139	1.4120	26.7144	-1.4069	0.0000	0.0000	0.0000	0.0000;
	1089	1088	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1093	1092	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.7289	-0.8310	-0.7289	0.8311	0.0000	0.0000	0.0000	0.0000;
	1099	1098	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.0003	3.2071	-1.0003	-3.2070	0.0000	0.0000	0.0000	0.0000;
	1101	1100	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1105	1104	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.4122	-1.3696	10.4123	1.3704	0.0000	0.0000	0.0000	0.0000;
	1107	1106	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.3469	0.4589	29.3475	-0.4529	0.0000	0.0000	0.0000	0.0000;
	1109	1108	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1111	1110	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1112	1111	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1110	1112	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1114	1113	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-59.2210	-8.4782	59.2234	8.5021	0.0000	0.0000	0.0000	0.0000;
	1116	1115	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	44.8804	15.3985	-44.8788	-15.3821	0.0000	0.0000	0.0000	0.0000;
	1122	1121	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1132	1131	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.9108	1.5277	-4.9108	-1.5275	0.0000	0.0000	0.0000	0.0000;
	1134	1133	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.3479	-0.3200	26.3484	0.3250	0.0000	0.0000	0.0000	0.0000;
	1137	1136	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1138	1137	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1143	1142	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.5371	3.7816	-8.5370	-3.7810	0.0000	0.0000	0.0000	0.0000;
	1144	1143	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.1774	0.9478	-5.1773	-0.9476	0.0000	0.0000	0.0000	0.0000;
	1148	1147	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.8363	-3.8467	16.8365	3.8487	0.0000	0.0000	0.0000	0.0000;
	1150	1149	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.9866	5.5005	-14.9864	-5.4988	0.0000	0.0000	0.0000	0.0000;
	1155	1154	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.1417	-2.6347	-10.1417	2.6354	0.0000	0.0000	0.0000	0.0000;
	1164	1163	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.1661	6.5053	-0.1661	-6.5050	0.0000	0.0000	0.0000	0.0000;
	1166	1165	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1170	1169	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	80.5048	15.1778	-80.5003	-15.1322	0.0000	0.0000	0.0000	0.0000;
	1172	1171	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1177	1176	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1179	1178	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1181	1180	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.3342	-9.5481	-5.3341	9.5489	0.0000	0.0000	0.0000	0.0000;
	1185	1184	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-49.1526	-6.3273	49.1543	6.3442	0.0000	0.0000	0.0000	0.0000;
	1187	1186	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1194	1193	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.2103	9.7181	-25.2097	-9.7130	0.0000	0.0000	0.0000	0.0000;
	1201	1200	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.8867	1.3988	-11.8866	-1.3979	0.0000	0.0000	0.0000	0.0000;
	1204	1203	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.6445	2.6273	27.6451	-2.6219	0.0000	0.0000	0.0000	0.0000;
	1206	1205	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.3752	0.5444	34.3760	-0.5359	0.0000	0.0000	0.0000	0.0000;
	1208	1207	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.2565	2.1464	-11.2564	-2.1455	0.0000	0.0000	0.0000	0.0000;
	1210	1209	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.5037	3.5874	4.5038	-3.5872	0.0000	0.0000	0.0000	0.0000;
	1212	1211	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.0061	-1.4172	1.0061	1.4173	0.0000	0.0000	0.0000	0.0000;
	1214	1213	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.2837	-7.5233	-17.2834	7.5259	0.0000	0.0000	0.0000	0.0000;
	1218	1217	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1220	1219	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.8217	-0.2437	1.8217	0.2438	0.0000	0.0000	0.0000	0.0000;
	1222	1221	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1224	1223	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.7557	-10.0785	6.7558	10.0795	0.0000	0.0000	0.0000	0.0000;
	1230	1229	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.0653	-3.9123	14.0655	3.9138	0.0000	0.0000	0.0000	0.0000;
	1232	1231	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1234	1233	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.3769	-0.6224	7.3770	0.6228	0.0000	0.0000	0.0000	0.0000;
	1236	1235	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	34.6484	3.6685	-34.6476	-3.6601	0.0000	0.0000	0.0000	0.0000;
	1240	1239	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.2825	-3.8884	26.2830	3.8933	0.0000	0.0000	0.0000	0.0000;
	1242	1241	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.9142	-0.0377	-4.9142	0.0379	0.0000	0.0000	0.0000	0.0000;
	1244	1243	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-43.8887	4.7668	43.8902	-4.7523	0.0000	0.0000	0.0000	0.0000;
	1246	1245	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1248	1247	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	22.1774	5.1874	-22.1770	-5.1837	0.0000	0.0000	0.0000	0.0000;
	1254	1253	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1256	1255	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.5290	0.9323	-6.5290	-0.9320	0.0000	0.0000	0.0000	0.0000;
	1258	1257	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.9205	0.2153	-13.9204	-0.2140	0.0000	0.0000	0.0000	0.0000;
	1262	1261	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.0514	9.4277	-28.0508	-9.4217	0.0000	0.0000	0.0000	0.0000;
	1264	1263	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.6457	5.7484	-12.6455	-5.7470	0.0000	0.0000	0.0000	0.0000;
	1266	1265	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.0172	10.2576	28.0178	-10.2513	0.0000	0.0000	0.0000	0.0000;
	1268	1267	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1269	1268	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1276	1275	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	59.0560	16.4926	-59.0535	-16.4670	0.0000	0.0000	0.0000	0.0000;
	1278	1277	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.2550	-0.7722	-14.2549	0.7736	0.0000	0.0000	0.0000	0.0000;
	1282	1281	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.2439	-5.4997	20.2442	5.5028	0.0000	0.0000	0.0000	0.0000;
	1285	1284	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1287	1286	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1289	1288	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.3191	-6.7280	-6.3190	6.7286	0.0000	0.0000	0.0000	0.0000;
	1291	1290	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.9414	-2.9364	-13.9413	2.9379	0.0000	0.0000	0.0000	0.0000;
	1293	1292	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.7670	6.4369	33.7679	-6.4286	0.0000	0.0000	0.0000	0.0000;
	1295	1294	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.7135	4.4371	-7.7135	-4.4366	0.0000	0.0000	0.0000	0.0000;
	1297	1296	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.0744	1.6219	-11.0743	-1.6211	0.0000	0.0000	0.0000	0.0000;
	1299	1298	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0148	11.0571	-0.0147	-11.0562	0.0000	0.0000	0.0000	0.0000;
	1301	1300	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.4948	-1.3670	6.4948	1.3673	0.0000	0.0000	0.0000	0.0000;
	1303	1302	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.2043	-3.1138	27.2048	3.1192	0.0000	0.0000	0.0000	0.0000;
	1305	1304	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.0023	-1.1509	-15.0022	1.1525	0.0000	0.0000	0.0000	0.0000;
	1307	1306	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-31.2039	8.7554	31.2046	-8.7481	0.0000	0.0000	0.0000	0.0000;
	1311	1310	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.6841	-0.1070	3.6841	0.1071	0.0000	0.0000	0.0000	0.0000;
	1313	1312	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.7061	-2.7688	30.7068	2.7754	0.0000	0.0000	0.0000	0.0000;
	1315	1314	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.4059	2.9848	-16.4058	-2.9829	0.0000	0.0000	0.0000	0.0000;
	1319	1318	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1323	1322	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.1046	-0.8659	1.1046	0.8659	0.0000	0.0000	0.0000	0.0000;
	1329	1328	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	37.7845	0.4470	-37.7835	-0.4371	0.0000	0.0000	0.0000	0.0000;
	1331	1330	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.1074	0.8110	-25.1070	-0.8063	0.0000	0.0000	0.0000	0.0000;
	1333	1332	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.0002	2.5388	-27.9996	-2.5332	0.0000	0.0000	0.0000	0.0000;
	1335	1334	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.0821	1.8291	4.0821	-1.8289	0.0000	0.0000	0.0000	0.0000;
	1337	1336	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.1679	1.7550	9.1680	-1.7543	0.0000	0.0000	0.0000	0.0000;
	1342	1341	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.0335	-2.6614	-5.0335	2.6616	0.0000	0.0000	0.0000	0.0000;
	1344	1343	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1347	1346	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1349	1348	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-42.4908	-4.0553	42.4922	4.0686	0.0000	0.0000	0.0000	0.0000;
	1351	1350	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1352	1351	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1350	1352	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1354	1353	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.0063	-5.8715	-6.0062	5.8720	0.0000	0.0000	0.0000	0.0000;
	1356	1355	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1360	1359	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.3164	8.1554	15.3166	-8.1531	0.0000	0.0000	0.0000	0.0000;
	1362	1361	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1364	1363	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.1869	0.7997	-26.1864	-0.7947	0.0000	0.0000	0.0000	0.0000;
	1366	1365	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-50.4103	13.2474	50.4122	-13.2285	0.0000	0.0000	0.0000	0.0000;
	1368	1367	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.5225	-1.9765	-24.5221	1.9806	0.0000	0.0000	0.0000	0.0000;
	1374	1373	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4839	11.4083	3.4840	-11.4073	0.0000	0.0000	0.0000	0.0000;
	1375	1374	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1373	1375	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1377	1376	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.0275	-3.8538	10.0275	3.8546	0.0000	0.0000	0.0000	0.0000;
	1379	1378	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.4075	-6.8647	34.4084	6.8732	0.0000	0.0000	0.0000	0.0000;
	1381	1380	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.7397	-6.6137	25.7402	6.6184	0.0000	0.0000	0.0000	0.0000;
	1383	1382	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0485	1.5455	0.0485	-1.5455	0.0000	0.0000	0.0000	0.0000;
	1385	1384	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1387	1386	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	40.5943	3.2964	-40.5931	-3.2848	0.0000	0.0000	0.0000	0.0000;
	1389	1388	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.9859	0.9891	15.9861	-0.9873	0.0000	0.0000	0.0000	0.0000;
	1391	1390	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-35.8289	4.1390	35.8299	-4.1295	0.0000	0.0000	0.0000	0.0000;
	1393	1392	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1397	1396	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.7293	0.9942	-7.7293	-0.9938	0.0000	0.0000	0.0000	0.0000;
	1404	1403	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.5735	2.4396	-19.5732	-2.4369	0.0000	0.0000	0.0000	0.0000;
	1410	1409	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.0586	-1.4501	23.0590	1.4538	0.0000	0.0000	0.0000	0.0000;
	1412	1411	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	74.1820	22.2047	-74.1778	-22.1633	0.0000	0.0000	0.0000	0.0000;
	1414	1413	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1416	1415	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1418	1417	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.3049	3.1686	-15.3047	-3.1669	0.0000	0.0000	0.0000	0.0000;
	1420	1419	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.2259	-1.3695	-7.2259	1.3699	0.0000	0.0000	0.0000	0.0000;
	1422	1421	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.5127	4.4746	-13.5126	-4.4732	0.0000	0.0000	0.0000	0.0000;
	1424	1423	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	30.4523	2.2153	-30.4516	-2.2088	0.0000	0.0000	0.0000	0.0000;
	1428	1427	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	32.4716	15.4993	-32.4707	-15.4904	0.0000	0.0000	0.0000	0.0000;
	1430	1429	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-59.5514	-23.8209	59.5544	23.8510	0.0000	0.0000	0.0000	0.0000;
	1434	1433	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1439	1438	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-69.4050	-0.5536	69.4084	0.5879	0.0000	0.0000	0.0000	0.0000;
	1441	1440	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-84.6231	-13.1970	84.6282	13.2475	0.0000	0.0000	0.0000	0.0000;
	1445	1444	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1449	1448	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.7271	-0.6131	5.7271	0.6134	0.0000	0.0000	0.0000	0.0000;
	1451	1450	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.3359	-2.8474	15.3361	2.8491	0.0000	0.0000	0.0000	0.0000;
	1453	1452	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.4117	-1.7083	10.4118	1.7091	0.0000	0.0000	0.0000	0.0000;
	1455	1454	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-32.3524	2.8711	32.3532	-2.8637	0.0000	0.0000	0.0000	0.0000;
	1457	1456	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.1781	0.6737	-17.1779	-0.6716	0.0000	0.0000	0.0000	0.0000;
	1459	1458	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.2289	-4.1831	9.2290	4.1838	0.0000	0.0000	0.0000	0.0000;
	1461	1460	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.2667	-5.7442	-8.2666	5.7449	0.0000	0.0000	0.0000	0.0000;
	1463	1462	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-40.9972	-0.5132	40.9984	0.5252	0.0000	0.0000	0.0000	0.0000;
	1465	1464	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	38.1371	-1.6515	-38.1360	1.6621	0.0000	0.0000	0.0000	0.0000;
	1469	1468	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1473	1472	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.0964	-8.6087	27.0970	8.6143	0.0000	0.0000	0.0000	0.0000;
	1475	1474	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.4893	7.8799	7.4894	-7.8791	0.0000	0.0000	0.0000	0.0000;
	1477	1476	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	47.2809	4.2703	-47.2794	-4.2549	0.0000	0.0000	0.0000	0.0000;
	1479	1478	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.2708	-2.7367	5.2708	2.7370	0.0000	0.0000	0.0000	0.0000;
	1481	1480	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1483	1482	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-40.1566	-2.7176	40.1577	2.7287	0.0000	0.0000	0.0000	0.0000;
	1485	1484	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.1370	0.7181	-16.1369	-0.7162	0.0000	0.0000	0.0000	0.0000;
	1487	1486	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1489	1488	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	22.4048	-0.0257	-22.4045	0.0293	0.0000	0.0000	0.0000	0.0000;
	1491	1490	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1494	1493	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.7751	-1.1606	-6.7751	1.1609	0.0000	0.0000	0.0000	0.0000;
	1496	1495	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.7204	5.3771	-36.7194	-5.3676	0.0000	0.0000	0.0000	0.0000;
	1498	1497	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.3552	3.9479	-19.3549	-3.9452	0.0000	0.0000	0.0000	0.0000;
	1500	1499	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.4497	3.1443	-2.4496	-3.1442	0.0000	0.0000	0.0000	0.0000;
	1502	1501	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1504	1503	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	42.3276	0.1321	-42.3264	-0.1195	0.0000	0.0000	0.0000	0.0000;
	1506	1505	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1511	1510	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.7314	9.5272	-12.7312	-9.5254	0.0000	0.0000	0.0000	0.0000;
	1513	1512	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1519	1518	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	32.0226	0.6938	-32.0219	-0.6868	0.0000	0.0000	0.0000	0.0000;
	1521	1520	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.0110	-0.0100	2.0110	0.0100	0.0000	0.0000	0.0000	0.0000;
	1523	1522	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.7564	-1.8565	3.7564	1.8567	0.0000	0.0000	0.0000	0.0000;
	1525	1524	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.4078	3.8164	-0.4078	-3.8163	0.0000	0.0000	0.0000	0.0000;
	1527	1526	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.3942	5.9317	-17.3940	-5.9294	0.0000	0.0000	0.0000	0.0000;
	1529	1528	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.7362	1.1934	2.7362	-1.1933	0.0000	0.0000	0.0000	0.0000;
	1537	1536	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.8360	-2.0313	8.8361	2.0319	0.0000	0.0000	0.0000	0.0000;
	1539	1538	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1543	1542	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-60.8890	-3.5505	60.8916	3.5763	0.0000	0.0000	0.0000	0.0000;
	1545	1544	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.0495	2.8717	4.0495	-2.8715	0.0000	0.0000	0.0000	0.0000;
	1547	1546	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1549	1548	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.0948	13.0749	-1.0947	-13.0737	0.0000	0.0000	0.0000	0.0000;
	1551	1550	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.7397	-0.2827	-15.7396	0.2844	0.0000	0.0000	0.0000	0.0000;
	1557	1556	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.5061	2.5436	-24.5057	-2.5394	0.0000	0.0000	0.0000	0.0000;
	1559	1558	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-49.0310	1.0311	49.0326	-1.0148	0.0000	0.0000	0.0000	0.0000;
	1561	1560	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-47.2657	0.4150	47.2672	-0.3996	0.0000	0.0000	0.0000	0.0000;
	1565	1564	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.4666	8.3174	5.4666	-8.3167	0.0000	0.0000	0.0000	0.0000;
	1567	1566	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1571	1570	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.1610	-8.2528	-7.1609	8.2537	0.0000	0.0000	0.0000	0.0000;
	1573	1572	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-57.3714	-12.1347	57.3738	12.1584	0.0000	0.0000	0.0000	0.0000;
	1575	1574	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1577	1576	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.9889	2.7183	-26.9884	-2.7132	0.0000	0.0000	0.0000	0.0000;
	1579	1578	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	34.0041	-4.7593	-34.0032	4.7675	0.0000	0.0000	0.0000	0.0000;
	1581	1580	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.9054	4.5612	5.9054	-4.5608	0.0000	0.0000	0.0000	0.0000;
	1583	1582	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-41.3783	-8.5180	41.3796	8.5304	0.0000	0.0000	0.0000	0.0000;
	1585	1584	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-31.2768	-0.1211	31.2774	0.1280	0.0000	0.0000	0.0000	0.0000;
	1587	1586	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.1733	2.4966	-20.1731	-2.4938	0.0000	0.0000	0.0000	0.0000;
	1589	1588	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.6271	0.3320	-14.6269	-0.3305	0.0000	0.0000	0.0000	0.0000;
	1591	1590	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-45.1855	-7.6511	45.1869	7.6654	0.0000	0.0000	0.0000	0.0000;
	1593	1592	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-35.5216	9.2768	35.5225	-9.2677	0.0000	0.0000	0.0000	0.0000;
	1595	1594	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	59.0061	-1.7586	-59.0036	1.7839	0.0000	0.0000	0.0000	0.0000;
	1597	1596	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	59.3818	6.3902	-59.3792	-6.3645	0.0000	0.0000	0.0000	0.0000;
	1601	1600	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.6763	4.5203	-1.6762	-4.5201	0.0000	0.0000	0.0000	0.0000;
	1605	1604	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.6731	-1.2873	-26.6726	1.2924	0.0000	0.0000	0.0000	0.0000;
	1607	1606	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.4032	2.3757	24.4037	-2.3714	0.0000	0.0000	0.0000	0.0000;
	1609	1608	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.4488	-0.8224	8.4489	0.8229	0.0000	0.0000	0.0000	0.0000;
	1611	1610	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.7232	-4.1405	14.7234	4.1421	0.0000	0.0000	0.0000	0.0000;
	1615	1614	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.2232	-1.6112	-24.2227	1.6153	0.0000	0.0000	0.0000	0.0000;
	1617	1616	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.9556	-2.5150	12.9557	2.5162	0.0000	0.0000	0.0000	0.0000;
	1621	1620	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.5817	1.4860	26.5822	-1.4809	0.0000	0.0000	0.0000	0.0000;
	1623	1622	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	65.0538	11.3983	-65.0508	-11.3683	0.0000	0.0000	0.0000	0.0000;
	1627	1626	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.7630	0.7261	4.7630	-0.7259	0.0000	0.0000	0.0000	0.0000;
	1629	1628	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	59.9711	15.4060	-59.9685	-15.3798	0.0000	0.0000	0.0000	0.0000;
	1631	1630	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	59.0784	16.4903	-59.0757	-16.4639	0.0000	0.0000	0.0000	0.0000;
	1633	1632	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.6157	-22.8945	10.6162	22.8990	0.0000	0.0000	0.0000	0.0000;
	1634	1633	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1632	1634	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1636	1635	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-50.3039	-2.3060	50.3057	2.3241	0.0000	0.0000	0.0000	0.0000;
	1638	1637	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.1783	-2.4144	8.1784	2.4149	0.0000	0.0000	0.0000	0.0000;
	1640	1639	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.7624	-0.5914	-4.7624	0.5915	0.0000	0.0000	0.0000	0.0000;
	1644	1643	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1648	1647	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.9950	-1.1155	-10.9949	1.1164	0.0000	0.0000	0.0000	0.0000;
	1650	1649	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1653	1652	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.9834	4.8151	-16.9832	-4.8129	0.0000	0.0000	0.0000	0.0000;
	1657	1656	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.9700	3.2565	-11.9699	-3.2554	0.0000	0.0000	0.0000	0.0000;
	1663	1662	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.5522	2.9309	-11.5521	-2.9299	0.0000	0.0000	0.0000	0.0000;
	1666	1665	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.0437	-4.6882	21.0440	4.6915	0.0000	0.0000	0.0000	0.0000;
	1668	1667	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.8556	4.8550	-13.8554	-4.8535	0.0000	0.0000	0.0000	0.0000;
	1672	1671	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.5379	1.3939	-3.5378	-1.3938	0.0000	0.0000	0.0000	0.0000;
	1674	1673	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	44.5487	10.2370	-44.5472	-10.2226	0.0000	0.0000	0.0000	0.0000;
	1676	1675	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1677	1676	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1675	1677	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1679	1678	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	31.5369	4.9365	-31.5362	-4.9294	0.0000	0.0000	0.0000	0.0000;
	1681	1680	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-39.7633	-0.8844	39.7643	0.8950	0.0000	0.0000	0.0000	0.0000;
	1683	1682	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.8494	11.3041	12.8496	-11.3020	0.0000	0.0000	0.0000	0.0000;
	1686	1685	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-35.3208	-3.1841	35.3216	3.1928	0.0000	0.0000	0.0000	0.0000;
	1688	1687	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1690	1689	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.1405	-0.2212	-1.1405	0.2212	0.0000	0.0000	0.0000	0.0000;
	1692	1691	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	34.3540	-8.1690	-34.3531	8.1778	0.0000	0.0000	0.0000	0.0000;
	1694	1693	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1698	1697	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-31.3862	-8.2159	31.3869	8.2233	0.0000	0.0000	0.0000	0.0000;
	1700	1699	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	33.9806	-1.2263	-33.9798	1.2340	0.0000	0.0000	0.0000	0.0000;
	1702	1701	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1706	1705	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1709	1708	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.3396	-9.8118	10.3397	9.8133	0.0000	0.0000	0.0000	0.0000;
	1711	1710	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	31.7234	2.2632	-31.7227	-2.2562	0.0000	0.0000	0.0000	0.0000;
	1713	1712	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1717	1716	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.4560	4.2511	24.4564	-4.2469	0.0000	0.0000	0.0000	0.0000;
	1719	1718	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-32.0715	-6.0621	32.0723	6.0695	0.0000	0.0000	0.0000	0.0000;
	1721	1720	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.1135	4.8353	-24.1131	-4.8311	0.0000	0.0000	0.0000	0.0000;
	1723	1722	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.1700	-0.4448	16.1702	0.4467	0.0000	0.0000	0.0000	0.0000;
	1729	1728	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.2192	-0.5436	4.2193	0.5437	0.0000	0.0000	0.0000	0.0000;
	1731	1730	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.7562	1.9193	-3.7562	-1.9192	0.0000	0.0000	0.0000	0.0000;
	1733	1732	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.1925	-6.9355	-28.1919	6.9414	0.0000	0.0000	0.0000	0.0000;
	1735	1734	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1738	1737	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.9987	0.6874	-0.9987	-0.6874	0.0000	0.0000	0.0000	0.0000;
	1740	1739	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1742	1741	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.0303	-0.3006	-6.0303	0.3009	0.0000	0.0000	0.0000	0.0000;
	1748	1747	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.5285	-2.0479	14.5286	2.0493	0.0000	0.0000	0.0000	0.0000;
	1750	1749	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.6726	2.6564	20.6729	-2.6534	0.0000	0.0000	0.0000	0.0000;
	1752	1751	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	23.3405	3.6263	-23.3401	-3.6222	0.0000	0.0000	0.0000	0.0000;
	1754	1753	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	34.1113	0.2170	-34.1104	-0.2086	0.0000	0.0000	0.0000	0.0000;
	1756	1755	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	42.5639	8.2844	-42.5625	-8.2706	0.0000	0.0000	0.0000	0.0000;
	1758	1757	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-84.9594	-15.5859	84.9644	15.6362	0.0000	0.0000	0.0000	0.0000;
	1760	1759	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-71.8206	-16.3739	71.8242	16.4109	0.0000	0.0000	0.0000	0.0000;
	1764	1763	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.8359	9.5883	-16.8357	-9.5857	0.0000	0.0000	0.0000	0.0000;
	1766	1765	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-57.8718	-9.7211	57.8742	9.7453	0.0000	0.0000	0.0000	0.0000;
	1768	1767	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1770	1769	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.4695	6.5558	10.4696	-6.5547	0.0000	0.0000	0.0000	0.0000;
	1772	1771	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.4087	-8.6215	-16.4084	8.6239	0.0000	0.0000	0.0000	0.0000;
	1774	1773	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.7585	0.8352	-21.7582	-0.8319	0.0000	0.0000	0.0000	0.0000;
	1776	1775	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	29.8876	2.7259	-29.8869	-2.7197	0.0000	0.0000	0.0000	0.0000;
	1778	1777	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.8254	-17.0745	12.8257	17.0778	0.0000	0.0000	0.0000	0.0000;
	1780	1779	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	35.5746	8.6806	-35.5737	-8.6709	0.0000	0.0000	0.0000	0.0000;
	1782	1781	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.7451	0.9280	-21.7448	-0.9247	0.0000	0.0000	0.0000	0.0000;
	1786	1785	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.1939	1.0897	-20.1936	-1.0869	0.0000	0.0000	0.0000	0.0000;
	1792	1791	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.5683	1.9492	25.5688	-1.9445	0.0000	0.0000	0.0000	0.0000;
	1794	1793	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.1396	1.0170	-11.1396	-1.0161	0.0000	0.0000	0.0000	0.0000;
	1796	1795	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-35.3352	-37.1807	35.3371	37.1995	0.0000	0.0000	0.0000	0.0000;
	1797	1798	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1800	1799	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.9078	-15.6688	34.9088	15.6787	0.0000	0.0000	0.0000	0.0000;
	1802	1801	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.0700	-3.5514	27.0705	3.5564	0.0000	0.0000	0.0000	0.0000;
	1807	1806	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-40.5776	-11.6392	40.5788	11.6517	0.0000	0.0000	0.0000	0.0000;
	1809	1808	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1811	1810	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	37.6367	7.7310	-37.6356	-7.7203	0.0000	0.0000	0.0000	0.0000;
	1813	1812	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1815	1814	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-43.8795	-15.9597	43.8810	15.9746	0.0000	0.0000	0.0000	0.0000;
	1817	1816	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-41.3958	-15.2725	41.3972	15.2866	0.0000	0.0000	0.0000	0.0000;
	1823	1822	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1825	1824	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.1780	7.8552	2.1780	-7.8548	0.0000	0.0000	0.0000	0.0000;
	1827	1826	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.7851	10.0855	6.7852	-10.0844	0.0000	0.0000	0.0000	0.0000;
	1829	1828	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-46.5790	-5.1314	46.5805	5.1467	0.0000	0.0000	0.0000	0.0000;
	1831	1830	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.9783	-10.1332	-12.9781	10.1351	0.0000	0.0000	0.0000	0.0000;
	1833	1832	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1836	1835	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.2159	1.3217	-4.2159	-1.3215	0.0000	0.0000	0.0000	0.0000;
	1838	1837	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.3290	17.8788	37.3302	-17.8669	0.0000	0.0000	0.0000	0.0000;
	1840	1839	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.8542	-8.5322	18.8545	8.5351	0.0000	0.0000	0.0000	0.0000;
	1842	1841	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1843	1842	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1841	1843	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1845	1844	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.9011	8.9967	-28.9005	-8.9905	0.0000	0.0000	0.0000	0.0000;
	1849	1848	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-58.0072	0.9209	58.0096	-0.8968	0.0000	0.0000	0.0000	0.0000;
	1851	1850	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.9199	-1.9721	12.9200	1.9733	0.0000	0.0000	0.0000	0.0000;
	1853	1852	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.0689	-4.8381	17.0691	4.8402	0.0000	0.0000	0.0000	0.0000;
	1855	1854	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.6195	1.7010	7.6196	-1.7006	0.0000	0.0000	0.0000	0.0000;
	1857	1856	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-41.3710	9.6084	41.3722	-9.5958	0.0000	0.0000	0.0000	0.0000;
	1859	1858	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	41.7373	-5.7529	-41.7361	5.7655	0.0000	0.0000	0.0000	0.0000;
	1864	1863	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1866	1865	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.9028	0.0617	0.9028	-0.0617	0.0000	0.0000	0.0000	0.0000;
	1868	1867	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	46.3574	3.4951	-46.3558	-3.4792	0.0000	0.0000	0.0000	0.0000;
	1870	1869	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.2923	-6.2964	12.2924	6.2977	0.0000	0.0000	0.0000	0.0000;
	1872	1871	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1878	1877	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1884	1883	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.3980	0.0205	-17.3978	-0.0184	0.0000	0.0000	0.0000	0.0000;
	1886	1885	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-73.4818	-10.4334	73.4855	10.4700	0.0000	0.0000	0.0000	0.0000;
	1888	1887	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.5939	10.6817	-21.5935	-10.6776	0.0000	0.0000	0.0000	0.0000;
	1890	1889	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	56.6727	2.8238	-56.6704	-2.8010	0.0000	0.0000	0.0000	0.0000;
	1892	1891	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.0542	-8.8620	-25.0537	8.8669	0.0000	0.0000	0.0000	0.0000;
	1894	1893	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1896	1895	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-58.6579	-17.6522	58.6605	17.6777	0.0000	0.0000	0.0000	0.0000;
	1898	1897	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.4967	12.5292	28.4974	-12.5224	0.0000	0.0000	0.0000	0.0000;
	1900	1899	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.7355	9.0648	-0.7355	-9.0643	0.0000	0.0000	0.0000	0.0000;
	1902	1901	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.8523	8.9452	-3.8522	-8.9445	0.0000	0.0000	0.0000	0.0000;
	1906	1905	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.8895	-9.4638	28.8901	9.4702	0.0000	0.0000	0.0000	0.0000;
	1908	1907	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.1788	4.2576	-26.1784	-4.2527	0.0000	0.0000	0.0000	0.0000;
	1910	1909	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.3606	-5.8946	-6.3605	5.8951	0.0000	0.0000	0.0000	0.0000;
	1912	1911	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.8958	-3.9460	3.8958	3.9462	0.0000	0.0000	0.0000	0.0000;
	1916	1915	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1919	1918	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.3274	-7.5034	-21.3271	7.5069	0.0000	0.0000	0.0000	0.0000;
	1921	1920	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.2610	-3.2839	-3.2610	3.2840	0.0000	0.0000	0.0000	0.0000;
	1923	1922	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	31.3418	-6.6136	-31.3410	6.6208	0.0000	0.0000	0.0000	0.0000;
	1927	1926	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	45.3965	9.3277	-45.3950	-9.3133	0.0000	0.0000	0.0000	0.0000;
	1929	1928	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.1405	-6.6358	25.1410	6.6404	0.0000	0.0000	0.0000	0.0000;
	1931	1930	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1933	1932	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1942	1941	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.4200	-0.4870	10.4201	0.4877	0.0000	0.0000	0.0000	0.0000;
	1947	1946	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-32.0920	-0.5983	32.0928	0.6054	0.0000	0.0000	0.0000	0.0000;
	1950	1949	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.5282	4.8404	24.5287	-4.8362	0.0000	0.0000	0.0000	0.0000;
	1953	1952	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.1650	-0.8830	6.1650	0.8833	0.0000	0.0000	0.0000	0.0000;
	1956	1955	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1963	1962	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1968	1967	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.1710	2.2970	4.1710	-2.2968	0.0000	0.0000	0.0000	0.0000;
	1970	1969	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1980	1979	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1982	1981	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1988	1987	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-56.1709	10.3302	56.1732	-10.3078	0.0000	0.0000	0.0000	0.0000;
	1997	1996	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1999	1998	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.6470	1.3710	8.6471	-1.3705	0.0000	0.0000	0.0000	0.0000;
	2003	2002	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2005	2004	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2007	2006	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2011	2010	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2014	2013	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-54.1385	-9.9701	54.1406	9.9909	0.0000	0.0000	0.0000	0.0000;
	2017	2016	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.1905	9.2475	30.1912	-9.2404	0.0000	0.0000	0.0000	0.0000;
	2020	2019	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2023	2022	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.7836	-5.4892	-11.7835	5.4904	0.0000	0.0000	0.0000	0.0000;
	2029	2028	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.1690	0.5340	6.1690	-0.5337	0.0000	0.0000	0.0000	0.0000;
	2038	2037	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-47.0320	-1.5276	47.0335	1.5429	0.0000	0.0000	0.0000	0.0000;
	2043	2042	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2047	2046	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-87.1680	-57.0000	87.1753	57.0733	0.0000	0.0000	0.0000	0.0000;
	2049	2048	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2052	2051	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4120	-1.1840	3.4120	1.1841	0.0000	0.0000	0.0000	0.0000;
	2065	2064	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2069	2068	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2074	2073	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2076	2075	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.7815	0.2999	5.7815	-0.2996	0.0000	0.0000	0.0000	0.0000;
	2079	2078	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2082	2081	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2096	2095	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2107	2106	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.4382	1.4163	16.4384	-1.4144	0.0000	0.0000	0.0000	0.0000;
	2111	2110	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.9282	-2.1497	-28.9276	2.1554	0.0000	0.0000	0.0000	0.0000;
	2113	2112	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2116	2115	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2118	2117	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-46.7195	3.2257	46.7211	-3.2098	0.0000	0.0000	0.0000	0.0000;
	2125	2124	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-32.7206	17.9685	32.7216	-17.9584	0.0000	0.0000	0.0000	0.0000;
	2127	2126	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2133	2132	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.7490	-0.1060	4.7490	0.1062	0.0000	0.0000	0.0000	0.0000;
	2135	2134	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2137	2136	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2140	2139	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.7420	0.4530	4.7420	-0.4528	0.0000	0.0000	0.0000	0.0000;
	2143	2142	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2149	2148	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.2150	-0.5900	5.2150	0.5902	0.0000	0.0000	0.0000	0.0000;
	2151	2150	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.0710	-1.8490	8.0710	1.8495	0.0000	0.0000	0.0000	0.0000;
	2153	2152	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2159	2158	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2163	2162	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2176	2175	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2182	2181	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2188	2187	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2202	2201	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.5490	0.0160	8.5491	-0.0155	0.0000	0.0000	0.0000	0.0000;
	2211	2210	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2214	2213	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-92.7488	-21.7151	92.7550	21.7772	0.0000	0.0000	0.0000	0.0000;
	2217	2216	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2219	2218	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2221	2220	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.6725	-11.7208	-15.6723	11.7235	0.0000	0.0000	0.0000	0.0000;
	2223	2222	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2226	2225	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.1690	-0.6670	6.1690	0.6673	0.0000	0.0000	0.0000	0.0000;
	2229	2228	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.1893	-7.8493	27.1898	7.8546	0.0000	0.0000	0.0000	0.0000;
	2234	2233	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.7960	0.1920	12.7961	-0.1909	0.0000	0.0000	0.0000	0.0000;
	2238	2237	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2240	2239	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2242	2241	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2251	2250	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2256	2255	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2258	2257	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.8506	-1.2060	28.8511	1.2117	0.0000	0.0000	0.0000	0.0000;
	2262	2261	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2265	2264	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2267	2266	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2278	2277	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.3900	-0.9320	11.3901	0.9330	0.0000	0.0000	0.0000	0.0000;
	2282	2281	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2285	2284	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2293	2292	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.0414	5.5483	16.0416	-5.5464	0.0000	0.0000	0.0000	0.0000;
	2295	2294	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.5760	-2.1150	6.5760	2.1153	0.0000	0.0000	0.0000	0.0000;
	2298	2297	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2311	2310	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2318	2317	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2320	2319	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.1990	-2.8450	15.1992	2.8467	0.0000	0.0000	0.0000	0.0000;
	2326	2325	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2348	2347	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.6829	1.9808	-2.6828	-1.9808	0.0000	0.0000	0.0000	0.0000;
	2350	2349	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.5538	-19.9787	16.5542	19.9832	0.0000	0.0000	0.0000	0.0000;
	2354	2353	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.1640	-2.2470	6.1640	2.2473	0.0000	0.0000	0.0000	0.0000;
	2357	2356	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.9170	-9.7000	13.9172	9.7019	0.0000	0.0000	0.0000	0.0000;
	2361	2360	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2365	2364	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2367	2366	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2370	2369	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2373	2372	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4620	0.4130	3.4620	-0.4129	0.0000	0.0000	0.0000	0.0000;
	2375	2374	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2377	2376	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	33.3634	11.2275	-33.3625	-11.2192	0.0000	0.0000	0.0000	0.0000;
	2380	2379	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2382	2381	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2385	2384	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2391	2390	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2393	2392	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2396	2395	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2429	2428	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.6450	0.1210	6.6450	-0.1207	0.0000	0.0000	0.0000	0.0000;
	2431	2430	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-56.3084	1.6692	56.3106	-1.6476	0.0000	0.0000	0.0000	0.0000;
	2448	2447	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.3520	-1.5210	6.3520	1.5213	0.0000	0.0000	0.0000	0.0000;
	2450	2449	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2452	2451	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2462	2461	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.6711	1.2927	7.6711	-1.2923	0.0000	0.0000	0.0000	0.0000;
	2474	2473	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-31.9533	-33.3597	31.9547	33.3738	0.0000	0.0000	0.0000	0.0000;
	2479	2478	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.7651	-16.4326	-10.7649	16.4352	0.0000	0.0000	0.0000	0.0000;
	2498	2497	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-55.7140	7.1839	55.7161	-7.1625	0.0000	0.0000	0.0000	0.0000;
	2507	2506	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2509	2508	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2511	2510	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2514	2513	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.5951	-8.0642	-27.5945	8.0698	0.0000	0.0000	0.0000	0.0000;
	2528	2527	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	54.3669	7.7295	-54.3649	-7.7096	0.0000	0.0000	0.0000	0.0000;
	2529	2528	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.0677	-7.5228	-3.0677	7.5232	0.0000	0.0000	0.0000	0.0000;
	2536	2535	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.4964	-2.6662	-0.4964	2.6663	0.0000	0.0000	0.0000	0.0000;
	2542	2541	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.5340	0.5000	-1.5340	-0.5000	0.0000	0.0000	0.0000	0.0000;
	2580	2579	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.4056	-7.1470	-1.4056	7.1474	0.0000	0.0000	0.0000	0.0000;
	2596	2595	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2601	2600	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-48.5220	-13.8148	48.5237	13.8316	0.0000	0.0000	0.0000	0.0000;
	2604	2603	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.0076	3.5797	5.0076	-3.5794	0.0000	0.0000	0.0000	0.0000;
	2618	2617	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.0232	-5.3222	-18.0229	5.3248	0.0000	0.0000	0.0000	0.0000;
	2624	2623	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.1319	6.3805	-7.1318	-6.3799	0.0000	0.0000	0.0000	0.0000;
	2639	2638	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2660	2659	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2670	2669	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-108.0332	29.6529	108.0416	-29.5685	0.0000	0.0000	0.0000	0.0000;
	2672	2671	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.8365	6.0049	3.8366	-6.0046	0.0000	0.0000	0.0000	0.0000;
	2689	2688	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	45.7001	16.8324	-45.6984	-16.8155	0.0000	0.0000	0.0000	0.0000;
	2707	2706	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.3287	-32.8513	25.3299	32.8635	0.0000	0.0000	0.0000	0.0000;
	2711	2710	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-46.1548	-8.7695	46.1564	8.7851	0.0000	0.0000	0.0000	0.0000;
	2722	2721	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.7540	-5.7000	33.7548	5.7084	0.0000	0.0000	0.0000	0.0000;
	2727	2726	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	32.9743	-2.6781	-32.9736	2.6854	0.0000	0.0000	0.0000	0.0000;
	2730	2729	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-62.6756	15.3654	62.6784	-15.3377	0.0000	0.0000	0.0000	0.0000;
	2500	2499	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.6863	5.2396	14.6865	-5.2379	0.0000	0.0000	0.0000	0.0000;
	2459	2458	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.8831	2.3804	-10.8830	-2.3796	0.0000	0.0000	0.0000	0.0000;
];

%%-----  OPF Data  -----%%
%% area data
%	area	refbus
mpc.areas = [
	1	18;
];

%% generator cost data
%	1	startup	shutdown	n	x1	y1	...	xn	yn
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	111.63	0;
	2	0	0	3	0	111.63	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
];
