/*
 * Copyright 2018 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.quarkus.hibernate.orm.runtime.boot.registry;

import java.util.LinkedHashSet;

import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;

/**
 * Mirror replay of the state generated by
 * org.hibernate.integrator.internal.IntegratorServiceImpl
 *
 * N.B. 1 the original implementations sneaks in some non-explicit integrators;
 * in particular one might want to prevent JaccIntegrator to ever reach the
 * state being mirrored.
 *
 * N.B. 2 when generating the state of Integrators, it does search for
 * extensions over loadJavaServices. This implies the state needs to be recorded
 * when all extension points are discoverable.
 */
final class MirroringIntegratorService implements IntegratorService {

    private final LinkedHashSet<Integrator> integrators = new LinkedHashSet<Integrator>();

    void addIntegrator(Integrator integrator) {
        integrators.add(integrator);
    }

    @Override
    public Iterable<Integrator> getIntegrators() {
        return integrators;
    }

}
