//======================================================================================================================
// TEST SUITE FOR OFFICEGEN
// This generates small individual files that test specific aspects of the API
// and compares them to reference files.
//
// The comparison is based on string comparisons of specified XML subdocuments.
// Comparing PPTX files for exact-bytewise equality fails because the doc properties include the creation date.
// This method tests a defined set of XML subdocuments for string equality.
//======================================================================================================================

var assert = require('assert');
var officegen = require('../');
var fs = require('fs');
var path = require('path');

var IMAGEDIR = __dirname + "/../examples/";
var OUTDIR = __dirname + "/../tmp/";


var AdmZip = require('adm-zip');


var docxEquivalent = function (path1, path2, subdocs) {
  var left = new AdmZip(path1);
  var right = new AdmZip(path2);
  for (var i = 0; i < subdocs.length; i++) {
    if (left.readAsText(subdocs[i]) != right.readAsText(subdocs[i])) {
      return false;
    }
  }
  return true;
}

// Common error method
var onError = function (err) {
  console.log(err);
  assert(false);
  done()
};


describe("XLSX generator", function () {

  it("creates a spreadsheet with text and numbers", function (done) {

    var xlsx = officegen ( 'xlsx' );
	xlsx.on ( 'error', onError );

    sheet = xlsx.makeNewSheet ();
    sheet.name = 'Excel Test';

// The direct option - two-dimensional array:
    sheet.data[0] = [];
    sheet.data[0][0] = 1;
    sheet.data[1] = [];
    sheet.data[1][3] = 'abc';
    sheet.data[1][4] = 'More';
    sheet.data[1][5] = 'Text';
    sheet.data[1][6] = 'Here';
    sheet.data[2] = [];
    sheet.data[2][5] = 'abc';
    sheet.data[2][6] = 900;
    sheet.data[6] = [];
    sheet.data[6][2] = 1972;

// Using setCell:
    sheet.setCell ( 'E7', 340 );
    sheet.setCell ( 'I1', -3 );
    sheet.setCell ( 'I2', 31.12 );
    sheet.setCell ( 'G102', 'Hello World!' );

    var FILENAME = "test-xls-1.xlsx";
    var out = fs.createWriteStream(OUTDIR + FILENAME);
    xlsx.generate(out);
	out.on ( 'close', function () {
		done ();
	});
  });
});
