# Argo Documentation

### Getting Started

For set-up information and running your first Workflows, please see our [Getting Started](getting-started.md) guide.

### Examples

For detailed examples about what Argo can do, please see our [Argo Workflows: Documentation by Example](../examples/README.md) page.

### Fields

For a full list of all the fields available in for use in Argo, and a link to examples where each is used, please see [Argo Fields](fields.md).

### Features
Some use-case specific documentation is available:
* [Architecture](architecture.md)
* [Argo Server](argo-server.md)
* [Cluster Workflow Templates](cluster-workflow-templates.md)
* [Configuring Your Artifact Repository](configure-artifact-repository.md)
* [Cron Workflows](cron-workflows.md)
* [Default Workflow Specs](default-workflow-specs.md)
* [Links](links.md)
* [Managed Namespace](managed-namespace.md)
* [Metrics](metrics.md)
* [Offloading Large Workflows](offloading-large-workflows.md)
* [Resource Duration](resource-duration.md)
* [REST API](rest-api.md)
* [Service Accounts](service-accounts.md)
* [Variables](variables.md)
* [Workflow Archive](workflow-archive.md)
* [Controller Configuration](workflow-controller-configmap.md)
  * [Controller Configuration Example](workflow-controller-configmap.yaml)
* [Workflow Executors](workflow-executors.md)
* [Workflow RBAC](workflow-rbac.md)
* [Workflow Templates](workflow-templates.md)
* [Workflow Notifications](workflow-notifications.md)
