# Default Workflow Spec

![alpha](assets/alpha.svg)

> v2.7 and after

## Introduction

Default Workflow spec values can be set at the controller config map that will apply to all Workflows executed from said controller.
If a Workflow has a value that also has a default value set in the config map, thw Workflow's value will take precedence.

## Setting Default Workflow Values

Default Workflow values can be specified by adding them under the `workflowDefaults` key in the [`workflow-controller-configmap`](./workflow-controller-configmap.yaml).
Values can be added as the would under the `Workflow.spec` tag.

For example, to specify default values that would partially produce the following `Workflow`:

```yaml
apiVersion: argoproj.io/v1alpha1
kind: Workflow
metadata:
  generateName: gc-ttl-
  annotations:
    argo: workflows
  labels:
    foo: bar
spec:
  ttlStrategy:
    secondsAfterSuccess: 5     # Time to live after workflow is successful
  parallelism: 3
```

The following would be specified in the Config Map:

```yaml
# This file describes the config settings available in the workflow controller configmap
apiVersion: v1
kind: ConfigMap
metadata:
  name: workflow-controller-configmap
data:
  config: |

    # Default values that will apply to all Workflows from this controller, unless overridden on the Workflow-level
    workflowDefaults:
      metadata:
        annotations:
          argo: workflows
        labels:
          foo: bar
      spec:
        ttlStrategy:
          secondsAfterSuccess: 5
        parallelism: 3

```