# Argo Community

Welcome to the Argo community!

Argo is an open, community driven project to make it easy to use Kubernetes for getting useful work done.  This document describes the organizational structure of the Argo Community including the roles, responsibilities and processes that govern Argo projects and community.

Community meeting notes is available [here](https://docs.google.com/document/d/16aWGQ1Te5IRptFuAIFtg3rONRQqHC1Z3X9rdDHYhYfE/edit?usp=sharing).

## Projects

Argo is organized into a set of projects. Each project has at least one owner. The owner is responsible for publishing a roadmap and organizing community meetings for soliciting feedback, publishing meeting notes, and reporting on the current status of the project.

The projects are:

* Argo Workflows
* Argo CD
* Argo Events
* Argo CI

## Community Roles and Responsibilities

| Roles        | Responsibilities| Requirements  | Recognized by|
| -------------|:---------------:| -------------:|-------------:|
| Member       | Active contributor |Active contributor, sponsored by reviewers |Argo GitHub org member|
| Reviewer     | Review PRs and proposals     |   History of review and authorship | OWNERS file reviewer entry|
| Approver     | Approve and accept PRs     |   Highly experienced, active reviewer and contributor |OWNERS file approver entry|
| Owner        | Set priorities, approve proposals| Demonstrated responsibility and good judgement|Member of Argo TOC|


* Members may also review PRs and proposals.
* Reviewers have a responsibility to regularly review PRs and proposals in a timely
manner.
* Approvers may commit changes.
* Owners provide technical leadership and are responsible for making project-level decisions in consultation with other members.

## Contributing to Argo

Read and abide by the [Argo Code of Conduct](https://github.com/argoproj/argo/blob/master/CODE_OF_CONDUCT.md).

Contributors will be asked to read and sign a [CLA](https://github.com/argoproj/argo/blob/master/community/Argo%20Individual%20CLA.pdf). This agreement gives us permission to use and redistribute your contributions as part of the Argo Project and protects the users and contributors of the project.

## Community Meetings

Approvers and owners for each project are responsible for organizing regular community meetings to provide status updates and solicit feedback.

* Meeting agendas should be published at least one week prior to the meeting.
* Community members should be able to attend the meetings remotely.
* Meeting notes summarizing the meeting and any decisions made should be published
within 24 hours of the meeting.
* Meeting recordings should be published within one week of the meeting.

## Technical Oversight Committee

The Argo Technical Oversight Committee (TOC) is responsible for cross-cutting product and design decisions. The membership of the TOC consists of owners of the Argo projects and technical representatives from the steering committee.

## Steering Committee

The Argo Steering Committee provides high-level guidance regarding the overall direction of the project and relative priority of use cases. Committee members are selected to represent the interests of the major users and contributors of the Argo Project.
As custodian of the Argo project, Intuit will be responsible for the overall administration of  the argoproj organization on GitHub.
