# Argo Documentation

### Getting Started

For set-up information and running your first Workflows, please see our [Getting Started](getting-started.md) guide.

### Examples

For detailed examples about what Argo can do, please see our [Argo Workflows: Documentation by Example](../examples/README.md) page.

### Fields

For a full list of all the fields available in for use in Argo, and a link to examples where each is used, please see [Argo Fields](fields.md).

### Features
Some use-case specific documentation is available:

* [Contributing](CONTRIBUTING.md)
* [Argo Workflow Architecture](architecture.md)
* [Argo Server](argo-server.md)
* [CLI](cli.md)
* [Cluster Workflow Templates](cluster-workflow-templates.md)
* [Configuring Your Artifact Repository](configure-artifact-repository.md)
* [Core Concepts](core-concepts.md)
* [Cron Workflows](cron-workflows.md)
* [Default Workflow Spec](default-workflow-specs.md)
* [Argo Fields](fields.md)
* [Getting Started](getting-started.md)
* [Links](links.md)
* [Managed Namespace](managed-namespace.md)
* [Prometheus Metrics](metrics.md)
* [Offloading Large Workflows](offloading-large-workflows.md)
* [Public API](public-api.md)
* [Release Instructions](releasing.md)
* [Resource Duration](resource-duration.md)
* [REST API](rest-api.md)
* [Running Locally](running-locally.md)
* [Security](security.md)
* [Service Accounts](service-accounts.md)
* [Static Code Analysis](static-code-analysis.md)
* [Transport Layer Security](tls.md)
* [Workflow Variables](variables.md)
* [Versioning](versioning.md)
* [Workflow Archive](workflow-archive.md)
* [Workflow Controller Configmap](workflow-controller-configmap.md)
* [Workflow Creator](workflow-creator.md)
* [Workflow Events](workflow-events.md)
* [Workflow Executors](workflow-executors.md)
* [Workflow Notifications](workflow-notifications.md)
* [Workfow RBAC](workflow-rbac.md)
* [Workflow Templates](workflow-templates.md)
