// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/argoproj/argo/pkg/apis/workflow/v1alpha1"
	scheme "github.com/argoproj/argo/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CronWorkflowsGetter has a method to return a CronWorkflowInterface.
// A group's client should implement this interface.
type CronWorkflowsGetter interface {
	CronWorkflows(namespace string) CronWorkflowInterface
}

// CronWorkflowInterface has methods to work with CronWorkflow resources.
type CronWorkflowInterface interface {
	Create(*v1alpha1.CronWorkflow) (*v1alpha1.CronWorkflow, error)
	Update(*v1alpha1.CronWorkflow) (*v1alpha1.CronWorkflow, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.CronWorkflow, error)
	List(opts v1.ListOptions) (*v1alpha1.CronWorkflowList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.CronWorkflow, err error)
	CronWorkflowExpansion
}

// cronWorkflows implements CronWorkflowInterface
type cronWorkflows struct {
	client rest.Interface
	ns     string
}

// newCronWorkflows returns a CronWorkflows
func newCronWorkflows(c *ArgoprojV1alpha1Client, namespace string) *cronWorkflows {
	return &cronWorkflows{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the cronWorkflow, and returns the corresponding cronWorkflow object, and an error if there is any.
func (c *cronWorkflows) Get(name string, options v1.GetOptions) (result *v1alpha1.CronWorkflow, err error) {
	result = &v1alpha1.CronWorkflow{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cronworkflows").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CronWorkflows that match those selectors.
func (c *cronWorkflows) List(opts v1.ListOptions) (result *v1alpha1.CronWorkflowList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.CronWorkflowList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cronworkflows").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested cronWorkflows.
func (c *cronWorkflows) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("cronworkflows").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a cronWorkflow and creates it.  Returns the server's representation of the cronWorkflow, and an error, if there is any.
func (c *cronWorkflows) Create(cronWorkflow *v1alpha1.CronWorkflow) (result *v1alpha1.CronWorkflow, err error) {
	result = &v1alpha1.CronWorkflow{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("cronworkflows").
		Body(cronWorkflow).
		Do().
		Into(result)
	return
}

// Update takes the representation of a cronWorkflow and updates it. Returns the server's representation of the cronWorkflow, and an error, if there is any.
func (c *cronWorkflows) Update(cronWorkflow *v1alpha1.CronWorkflow) (result *v1alpha1.CronWorkflow, err error) {
	result = &v1alpha1.CronWorkflow{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("cronworkflows").
		Name(cronWorkflow.Name).
		Body(cronWorkflow).
		Do().
		Into(result)
	return
}

// Delete takes name of the cronWorkflow and deletes it. Returns an error if one occurs.
func (c *cronWorkflows) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cronworkflows").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *cronWorkflows) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cronworkflows").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched cronWorkflow.
func (c *cronWorkflows) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.CronWorkflow, err error) {
	result = &v1alpha1.CronWorkflow{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("cronworkflows").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
