package io.quarkus.reactive.pg.client;

import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;

public class LegacyReactivePgReloadTest {

    @RegisterExtension
    public static final QuarkusDevModeTest test = new QuarkusDevModeTest()
            .setArchiveProducer(() -> ShrinkWrap.create(JavaArchive.class)
                    .addClass(DevModeResource.class)
                    .add(new StringAsset("quarkus.datasource.url=vertx-reactive:postgres://localhost:2345/reload_test"),
                            "application.properties"));

    @Test
    public void testHotReplacement() {
        RestAssured
                .get("/dev/error")
                .then()
                .statusCode(200)
                .body(Matchers.allOf(Matchers.startsWith("Connection refused"), Matchers.endsWith(":2345")));

        test.modifyResourceFile("application.properties", s -> s.replace(":2345", ":5234"));

        RestAssured
                .get("/dev/error")
                .then()
                .statusCode(200)
                .body(Matchers.allOf(Matchers.startsWith("Connection refused"), Matchers.endsWith(":5234")));
    }
}
