/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.Nullable;

@BugPattern(name="EqualsNaN", summary="== NaN always returns false; use the isNaN methods instead", explanation="As per JLS 15.21.1, == NaN comparisons always return false, even NaN == NaN. Instead, use the isNaN methods to check for NaN.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class EqualsNaN
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        String prefix;
        switch (tree.getKind()) {
            case EQUAL_TO: {
                prefix = "";
                break;
            }
            case NOT_EQUAL_TO: {
                prefix = "!";
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        JCTree.JCExpression left = (JCTree.JCExpression)tree.getLeftOperand();
        JCTree.JCExpression right = (JCTree.JCExpression)tree.getRightOperand();
        String leftMatch = this.matchNaN(left);
        if (leftMatch != null) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)String.format("%s%s.isNaN(%s)", prefix, leftMatch, this.toString(right, state))));
        }
        String rightMatch = this.matchNaN(right);
        if (rightMatch != null) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)String.format("%s%s.isNaN(%s)", prefix, rightMatch, this.toString(left, state))));
        }
        return Description.NO_MATCH;
    }

    private CharSequence toString(JCTree tree, VisitorState state) {
        String source = state.getSourceForNode((Tree)tree);
        return source == null ? tree.toString() : source;
    }

    @Nullable
    private String matchNaN(ExpressionTree tree) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym != null && sym.owner != null && sym.owner.asType() != null && sym.getSimpleName().contentEquals("NaN")) {
            if (sym.owner.getQualifiedName().contentEquals("java.lang.Double")) {
                return "Double";
            }
            if (sym.owner.getQualifiedName().contentEquals("java.lang.Float")) {
                return "Float";
            }
        }
        return null;
    }
}

