/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.TrustingNullnessAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

@BugPattern(name="FieldMissingNullable", summary="Fields that can be null should be annotated @Nullable", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION)
public class FieldMissingNullable
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol assigned = ASTHelpers.getSymbol((VariableTree)tree);
        if (assigned == null || ((Symbol)assigned).getKind() != ElementKind.FIELD || assigned.type.isPrimitive()) {
            return Description.NO_MATCH;
        }
        ExpressionTree expression = tree.getInitializer();
        if (expression == null || ASTHelpers.constValue((Tree)expression) != null) {
            return Description.NO_MATCH;
        }
        if (TrustingNullnessAnalysis.hasNullableAnnotation((Element)assigned)) {
            return Description.NO_MATCH;
        }
        if (expression.getKind() == Tree.Kind.NULL_LITERAL) {
            return this.makeFix(tree, tree, "Initializing field with null literal");
        }
        Nullness nullness = TrustingNullnessAnalysis.instance((Context)state.context).getFieldInitializerNullness(state.getPath(), state.context);
        switch (nullness) {
            case BOTTOM: 
            case NONNULL: {
                return Description.NO_MATCH;
            }
            case NULL: {
                return this.makeFix(tree, tree, "Initializing field with null");
            }
            case NULLABLE: {
                return this.makeFix(tree, tree, "May initialize field with null");
            }
        }
        throw new AssertionError((Object)("Impossible: " + nullness));
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        Symbol assigned = ASTHelpers.getSymbol((Tree)tree.getVariable());
        if (assigned == null || assigned.getKind() != ElementKind.FIELD || assigned.type.isPrimitive()) {
            return Description.NO_MATCH;
        }
        ExpressionTree expression = tree.getExpression();
        if (ASTHelpers.constValue((Tree)expression) != null) {
            return Description.NO_MATCH;
        }
        if (TrustingNullnessAnalysis.hasNullableAnnotation((Element)assigned)) {
            return Description.NO_MATCH;
        }
        VariableTree fieldDecl = this.findDeclaration(state, assigned);
        if (fieldDecl == null) {
            return Description.NO_MATCH;
        }
        if (expression.getKind() == Tree.Kind.NULL_LITERAL) {
            return this.makeFix(fieldDecl, tree, "Assigning null literal to field");
        }
        Nullness nullness = TrustingNullnessAnalysis.instance((Context)state.context).getNullness(new TreePath(state.getPath(), expression), state.context);
        if (nullness == null) {
            return Description.NO_MATCH;
        }
        switch (nullness) {
            case BOTTOM: 
            case NONNULL: {
                return Description.NO_MATCH;
            }
            case NULL: {
                return this.makeFix(fieldDecl, tree, "Assigning null to field");
            }
            case NULLABLE: {
                return this.makeFix(fieldDecl, tree, "May assign null to field");
            }
        }
        throw new AssertionError((Object)("Impossible: " + nullness));
    }

    @Nullable
    private VariableTree findDeclaration(VisitorState state, Symbol field) {
        JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(state.context);
        TreePath fieldDeclPath = Trees.instance(javacEnv).getPath(field);
        if (fieldDeclPath != null && fieldDeclPath.getCompilationUnit() == state.getPath().getCompilationUnit() && fieldDeclPath.getLeaf() instanceof VariableTree) {
            return (VariableTree)fieldDeclPath.getLeaf();
        }
        return null;
    }

    private Description makeFix(VariableTree declaration, Tree matchedTree, String message) {
        return this.buildDescription(matchedTree).setMessage(message).addFix((Fix)SuggestedFix.builder().addImport("javax.annotation.Nullable").prefixWith((Tree)declaration, "@Nullable ").build()).build();
    }
}

