/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.AutoValue_UIf;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.ControlFlowVisitor;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UBlock;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import javax.annotation.Nullable;

abstract class UIf
implements UStatement,
IfTree {
    UIf() {
    }

    public static UIf create(UExpression condition, UStatement thenStatement, UStatement elseStatement) {
        return new AutoValue_UIf(condition, thenStatement, elseStatement);
    }

    @Override
    public abstract UExpression getCondition();

    @Override
    public abstract UStatement getThenStatement();

    @Override
    @Nullable
    public abstract UStatement getElseStatement();

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitIf(this, data);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IF;
    }

    private static Function<Unifier, Choice<Unifier>> unifyUStatementWithSingleStatement(final @Nullable UStatement toUnify, final @Nullable StatementTree target) {
        return new Function<Unifier, Choice<Unifier>>(){

            public Choice<Unifier> apply(Unifier unifier) {
                if (toUnify == null) {
                    return target == null ? Choice.of(unifier) : Choice.none();
                }
                List list = target == null ? List.nil() : List.of(target);
                return ((Choice)toUnify.apply(UStatement.UnifierWithUnconsumedStatements.create(unifier, list))).thenOption(new Function<UStatement.UnifierWithUnconsumedStatements, Optional<Unifier>>(){

                    public Optional<Unifier> apply(UStatement.UnifierWithUnconsumedStatements state) {
                        return state.unconsumedStatements().isEmpty() ? Optional.of((Object)state.unifier()) : Optional.absent();
                    }
                });
            }
        };
    }

    @Nullable
    public Choice<UStatement.UnifierWithUnconsumedStatements> apply(UStatement.UnifierWithUnconsumedStatements state) {
        java.util.List<? extends StatementTree> unconsumedStatements = state.unconsumedStatements();
        if (unconsumedStatements.isEmpty()) {
            return Choice.none();
        }
        final java.util.List<? extends StatementTree> unconsumedStatementsTail = unconsumedStatements.subList(1, unconsumedStatements.size());
        StatementTree firstStatement = unconsumedStatements.get(0);
        if (firstStatement.getKind() != Tree.Kind.IF) {
            return Choice.none();
        }
        final IfTree ifTree = (IfTree)firstStatement;
        Unifier unifier = state.unifier();
        Choice<UStatement.UnifierWithUnconsumedStatements> forwardMatch = this.getCondition().unify(ifTree.getCondition(), unifier.fork()).thenChoose(UIf.unifyUStatementWithSingleStatement(this.getThenStatement(), ifTree.getThenStatement())).thenChoose(new Function<Unifier, Choice<UStatement.UnifierWithUnconsumedStatements>>(){

            public Choice<UStatement.UnifierWithUnconsumedStatements> apply(Unifier unifier) {
                if (UIf.this.getElseStatement() != null && ifTree.getElseStatement() == null && ControlFlowVisitor.INSTANCE.visitStatement(ifTree.getThenStatement()) == ControlFlowVisitor.Result.ALWAYS_RETURNS) {
                    Choice<UStatement.UnifierWithUnconsumedStatements> result = (Choice<UStatement.UnifierWithUnconsumedStatements>)UIf.this.getElseStatement().apply(UStatement.UnifierWithUnconsumedStatements.create(unifier.fork(), unconsumedStatementsTail));
                    if (UIf.this.getElseStatement() instanceof UBlock) {
                        Choice<UStatement.UnifierWithUnconsumedStatements> alternative = Choice.of(UStatement.UnifierWithUnconsumedStatements.create(unifier.fork(), unconsumedStatementsTail));
                        for (UStatement stmt : ((UBlock)UIf.this.getElseStatement()).getStatements()) {
                            alternative = alternative.thenChoose(stmt);
                        }
                        result = result.or(alternative);
                    }
                    return result;
                }
                return ((Choice)UIf.unifyUStatementWithSingleStatement(UIf.this.getElseStatement(), ifTree.getElseStatement()).apply((Object)unifier)).transform(new Function<Unifier, UStatement.UnifierWithUnconsumedStatements>(){

                    public UStatement.UnifierWithUnconsumedStatements apply(Unifier unifier) {
                        return UStatement.UnifierWithUnconsumedStatements.create(unifier, unconsumedStatementsTail);
                    }
                });
            }
        });
        Choice<UStatement.UnifierWithUnconsumedStatements> backwardMatch = this.getCondition().negate().unify(ifTree.getCondition(), unifier.fork()).thenChoose(new Function<Unifier, Choice<Unifier>>(){

            public Choice<Unifier> apply(Unifier unifier) {
                if (UIf.this.getElseStatement() == null) {
                    return Choice.none();
                }
                return ((Choice)UIf.this.getElseStatement().apply(UStatement.UnifierWithUnconsumedStatements.create(unifier, List.of(ifTree.getThenStatement())))).thenOption(new Function<UStatement.UnifierWithUnconsumedStatements, Optional<Unifier>>(){

                    public Optional<Unifier> apply(UStatement.UnifierWithUnconsumedStatements state) {
                        return state.unconsumedStatements().isEmpty() ? Optional.of((Object)state.unifier()) : Optional.absent();
                    }
                });
            }
        }).thenChoose(new Function<Unifier, Choice<UStatement.UnifierWithUnconsumedStatements>>(){

            public Choice<UStatement.UnifierWithUnconsumedStatements> apply(Unifier unifier) {
                if (ifTree.getElseStatement() == null && ControlFlowVisitor.INSTANCE.visitStatement(ifTree.getThenStatement()) == ControlFlowVisitor.Result.ALWAYS_RETURNS) {
                    Choice<UStatement.UnifierWithUnconsumedStatements> result = (Choice<UStatement.UnifierWithUnconsumedStatements>)UIf.this.getThenStatement().apply(UStatement.UnifierWithUnconsumedStatements.create(unifier.fork(), unconsumedStatementsTail));
                    if (UIf.this.getThenStatement() instanceof UBlock) {
                        Choice<UStatement.UnifierWithUnconsumedStatements> alternative = Choice.of(UStatement.UnifierWithUnconsumedStatements.create(unifier.fork(), unconsumedStatementsTail));
                        for (UStatement stmt : ((UBlock)UIf.this.getThenStatement()).getStatements()) {
                            alternative = alternative.thenChoose(stmt);
                        }
                        result = result.or(alternative);
                    }
                    return result;
                }
                return ((Choice)UIf.unifyUStatementWithSingleStatement(UIf.this.getThenStatement(), ifTree.getElseStatement()).apply((Object)unifier)).transform(new Function<Unifier, UStatement.UnifierWithUnconsumedStatements>(){

                    public UStatement.UnifierWithUnconsumedStatements apply(Unifier unifier) {
                        return UStatement.UnifierWithUnconsumedStatements.create(unifier, unconsumedStatementsTail);
                    }
                });
            }
        });
        return forwardMatch.or(backwardMatch);
    }

    @Override
    public List<JCTree.JCStatement> inlineStatements(Inliner inliner) throws CouldNotResolveImportException {
        return List.of(inliner.maker().If((JCTree.JCExpression)this.getCondition().inline(inliner), (JCTree.JCStatement)Iterables.getOnlyElement(this.getThenStatement().inlineStatements(inliner)), this.getElseStatement() == null ? null : (JCTree.JCStatement)Iterables.getOnlyElement(this.getElseStatement().inlineStatements(inliner))));
    }
}

