/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="BoxedPrimitiveConstructor", category=BugPattern.Category.JDK, summary="valueOf or autoboxing provides better time and space performance", severity=BugPattern.SeverityLevel.WARNING)
public class BoxedPrimitiveConstructor
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<Tree> TO_STRING = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.instanceMethod().anyClass().named("toString").withParameters(new String[0]));
    private static final Matcher<Tree> HASH_CODE = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.instanceMethod().anyClass().named("hashCode").withParameters(new String[0]));
    private static final Matcher<Tree> COMPARE_TO = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.instanceMethod().onDescendantOf("java.lang.Comparable").named("compareTo"));

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree.getIdentifier());
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Types types = state.getTypes();
        Symtab symtab = state.getSymtab();
        if (sym.equals(types.boxedClass(symtab.byteType)) || sym.equals(types.boxedClass(symtab.charType)) || sym.equals(types.boxedClass(symtab.shortType)) || sym.equals(types.boxedClass(symtab.intType)) || sym.equals(types.boxedClass(symtab.longType)) || sym.equals(types.boxedClass(symtab.doubleType)) || sym.equals(types.boxedClass(symtab.floatType)) || sym.equals(types.boxedClass(symtab.booleanType))) {
            return this.describeMatch(tree, this.buildFix(tree, state));
        }
        return Description.NO_MATCH;
    }

    private Fix buildFix(NewClassTree tree, VisitorState state) {
        String prefixToArg;
        Type type;
        boolean autoboxFix = this.shouldAutoboxFix(state);
        Types types = state.getTypes();
        if (types.isSameType(type = types.unboxedTypeOrType(ASTHelpers.getType((Tree)tree)), state.getSymtab().booleanType)) {
            Object value = this.literalValue(tree.getArguments().iterator().next());
            if (value instanceof Boolean) {
                return SuggestedFix.replace((Tree)tree, (String)this.literalFix((Boolean)value, autoboxFix));
            }
            if (value instanceof String) {
                return SuggestedFix.replace((Tree)tree, (String)this.literalFix(Boolean.parseBoolean((String)value), autoboxFix));
            }
        }
        JCTree.JCExpression arg = (JCTree.JCExpression)Iterables.getOnlyElement(tree.getArguments());
        Type argType = ASTHelpers.getType((Tree)arg);
        if (autoboxFix && argType.isPrimitive()) {
            return SuggestedFix.builder().replace(((JCTree)((Object)tree)).getStartPosition(), arg.getStartPosition(), this.maybeCast(state, type, argType)).replace(state.getEndPosition((Tree)arg), state.getEndPosition((Tree)tree), "").build();
        }
        JCTree parent = (JCTree)state.getPath().getParentPath().getParentPath().getLeaf();
        if (TO_STRING.matches((Tree)parent, state)) {
            return SuggestedFix.builder().replace(parent.getStartPosition(), arg.getStartPosition(), "String.valueOf(").replace(state.getEndPosition((Tree)arg), state.getEndPosition((Tree)parent), ")").build();
        }
        String typeName = state.getSourceForNode((Tree)tree.getIdentifier());
        if (HASH_CODE.matches((Tree)parent, state)) {
            String replacement;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (types.isSameType(type, state.getSymtab().longType)) {
                fix.addImport(Longs.class.getName());
                replacement = "Longs.hashCode(";
            } else {
                replacement = String.format("%s.hashCode(", typeName);
            }
            return fix.replace(parent.getStartPosition(), arg.getStartPosition(), replacement).replace(state.getEndPosition((Tree)arg), state.getEndPosition((Tree)parent), ")").build();
        }
        DoubleAndFloatStatus doubleAndFloatStatus = this.doubleAndFloatStatus(state, type, argType);
        if (COMPARE_TO.matches((Tree)parent, state) && ASTHelpers.getReceiver((ExpressionTree)((ExpressionTree)((Object)parent))).equals(tree)) {
            JCTree.JCMethodInvocation compareTo = (JCTree.JCMethodInvocation)parent;
            JCTree.JCExpression rhs = (JCTree.JCExpression)Iterables.getOnlyElement((Iterable)compareTo.getArguments());
            String optionalCast = "";
            String optionalSuffix = "";
            switch (doubleAndFloatStatus) {
                case PRIMITIVE_DOUBLE_INTO_FLOAT: {
                    optionalCast = "(float) ";
                    break;
                }
                case BOXED_DOUBLE_INTO_FLOAT: {
                    optionalSuffix = ".floatValue()";
                    break;
                }
            }
            return SuggestedFix.builder().replace(compareTo.getStartPosition(), arg.getStartPosition(), String.format("%s.compare(%s", typeName, optionalCast)).replace(state.getEndPosition((Tree)arg), rhs.getStartPosition(), String.format("%s, ", optionalSuffix)).replace(state.getEndPosition((Tree)rhs), state.getEndPosition((Tree)compareTo), ")").build();
        }
        String suffix = "";
        switch (doubleAndFloatStatus) {
            case PRIMITIVE_DOUBLE_INTO_FLOAT: {
                prefixToArg = String.format("%s.valueOf(%s", typeName, "(float) ");
                break;
            }
            case BOXED_DOUBLE_INTO_FLOAT: {
                prefixToArg = "";
                suffix = ".floatValue(";
                break;
            }
            default: {
                prefixToArg = String.format("%s.valueOf(", typeName);
            }
        }
        return SuggestedFix.builder().replace(((JCTree)((Object)tree)).getStartPosition(), arg.getStartPosition(), prefixToArg).postfixWith((Tree)arg, suffix).build();
    }

    private String maybeCast(final VisitorState state, Type type, Type argType) {
        if (this.doubleAndFloatStatus(state, type, argType) == DoubleAndFloatStatus.PRIMITIVE_DOUBLE_INTO_FLOAT) {
            return "(float) ";
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        Type targetType = parent.accept(new TreeScanner<Type, Void>(){

            @Override
            public Type visitAssignment(AssignmentTree node, Void unused) {
                return ASTHelpers.getType((Tree)node.getVariable());
            }

            @Override
            public Type visitCompoundAssignment(CompoundAssignmentTree node, Void unused) {
                return ASTHelpers.getType((Tree)node.getVariable());
            }

            @Override
            public Type visitReturn(ReturnTree node, Void unused) {
                return ASTHelpers.getType((Tree)((MethodTree)state.findEnclosing(new Class[]{MethodTree.class})).getReturnType());
            }

            @Override
            public Type visitVariable(VariableTree node, Void unused) {
                return ASTHelpers.getType((Tree)node.getType());
            }
        }, null);
        if (!ASTHelpers.isSameType((Type)type, (Type)argType, (VisitorState)state) && !ASTHelpers.isSameType((Type)targetType, (Type)type, (VisitorState)state)) {
            return String.format("(%s) ", type);
        }
        return "";
    }

    private DoubleAndFloatStatus doubleAndFloatStatus(VisitorState state, Type recieverType, Type argType) {
        Types types = state.getTypes();
        if (!types.isSameType(recieverType, state.getSymtab().floatType)) {
            return DoubleAndFloatStatus.NONE;
        }
        if (types.isSameType(argType, types.boxedClass((Type)state.getSymtab().doubleType).type)) {
            return DoubleAndFloatStatus.BOXED_DOUBLE_INTO_FLOAT;
        }
        if (types.isSameType(argType, state.getSymtab().doubleType)) {
            return DoubleAndFloatStatus.PRIMITIVE_DOUBLE_INTO_FLOAT;
        }
        return DoubleAndFloatStatus.NONE;
    }

    private boolean shouldAutoboxFix(VisitorState state) {
        switch (state.getPath().getParentPath().getLeaf().getKind()) {
            case METHOD_INVOCATION: {
                return false;
            }
            case MEMBER_SELECT: {
                return false;
            }
        }
        return true;
    }

    private String literalFix(boolean value, boolean autoboxFix) {
        if (autoboxFix) {
            return value ? "true" : "false";
        }
        return value ? "Boolean.TRUE" : "Boolean.FALSE";
    }

    private Object literalValue(Tree arg) {
        if (!(arg instanceof LiteralTree)) {
            return null;
        }
        return ((LiteralTree)arg).getValue();
    }

    private static enum DoubleAndFloatStatus {
        NONE,
        PRIMITIVE_DOUBLE_INTO_FLOAT,
        BOXED_DOUBLE_INTO_FLOAT;

    }
}

