/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.CompressorRegistry;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.DecompressorRegistry;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.ResolvedServerInfoGroup;
import io.grpc.Status;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.CallCredentialsApplyingTransportFactory;
import io.grpc.internal.ChannelExecutor;
import io.grpc.internal.ClientCallImpl;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.DelayedClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InUseStateAggregator;
import io.grpc.internal.InternalSubchannel;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.OobChannel;
import io.grpc.internal.SubchannelImpl;
import io.grpc.internal.WithLogId;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ManagedChannelImpl
extends ManagedChannel
implements WithLogId {
    private static final Logger log = Logger.getLogger(ManagedChannelImpl.class.getName());
    @VisibleForTesting
    static final Pattern URI_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+.-]*:/.*");
    static final long IDLE_TIMEOUT_MILLIS_DISABLE = -1L;
    @VisibleForTesting
    static final long SUBCHANNEL_SHUTDOWN_DELAY_SECONDS = 5L;
    @VisibleForTesting
    static final Status SHUTDOWN_NOW_STATUS = Status.UNAVAILABLE.withDescription("Channel shutdownNow invoked");
    private final String target;
    private final NameResolver.Factory nameResolverFactory;
    private final Attributes nameResolverParams;
    private final LoadBalancer.Factory loadBalancerFactory;
    private final ClientTransportFactory transportFactory;
    private final Executor executor;
    private final ObjectPool<? extends Executor> executorPool;
    private final ObjectPool<? extends Executor> oobExecutorPool;
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final ChannelExecutor channelExecutor = new ChannelExecutor();
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final ObjectPool<ScheduledExecutorService> timerServicePool;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final long idleTimeoutMillis;
    private volatile ScheduledExecutorService scheduledExecutor;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Channel interceptorChannel;
    @Nullable
    private final String userAgent;
    private NameResolver nameResolver;
    @Nullable
    private LoadBalancer loadBalancer;
    @Nullable
    private volatile LoadBalancer.SubchannelPicker subchannelPicker;
    private final Set<InternalSubchannel> subchannels = new HashSet<InternalSubchannel>(16, 0.75f);
    private final Set<InternalSubchannel> oobChannels = new HashSet<InternalSubchannel>(1, 0.75f);
    private final DelayedClientTransport delayedTransport;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean shutdownNowed;
    private volatile boolean terminating;
    private volatile boolean terminated;
    private final CountDownLatch terminatedLatch = new CountDownLatch(1);
    private final ManagedClientTransport.Listener delayedTransportListener = new ManagedClientTransport.Listener(){

        @Override
        public void transportShutdown(Status s) {
            Preconditions.checkState((boolean)ManagedChannelImpl.this.shutdown.get(), (Object)"Channel must have been shut down");
        }

        @Override
        public void transportReady() {
        }

        @Override
        public void transportInUse(boolean inUse) {
            ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(ManagedChannelImpl.this.delayedTransport, inUse);
        }

        @Override
        public void transportTerminated() {
            Preconditions.checkState((boolean)ManagedChannelImpl.this.shutdown.get(), (Object)"Channel must have been shut down");
            ManagedChannelImpl.this.terminating = true;
            if (ManagedChannelImpl.this.loadBalancer != null) {
                ManagedChannelImpl.this.loadBalancer.shutdown();
                ManagedChannelImpl.this.loadBalancer = null;
            }
            if (ManagedChannelImpl.this.nameResolver != null) {
                ManagedChannelImpl.this.nameResolver.shutdown();
                ManagedChannelImpl.this.nameResolver = null;
            }
            ManagedChannelImpl.this.maybeShutdownNowSubchannels();
            ManagedChannelImpl.this.maybeTerminateChannel();
        }
    };
    @VisibleForTesting
    final InUseStateAggregator<Object> inUseStateAggregator = new InUseStateAggregator<Object>(){

        @Override
        void handleInUse() {
            ManagedChannelImpl.this.exitIdleMode();
        }

        @Override
        void handleNotInUse() {
            if (ManagedChannelImpl.this.shutdown.get()) {
                return;
            }
            ManagedChannelImpl.this.rescheduleIdleTimer();
        }
    };
    @Nullable
    private ScheduledFuture<?> idleModeTimerFuture;
    @Nullable
    private IdleModeTimer idleModeTimer;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get(LoadBalancer.PickSubchannelArgs args) {
            LoadBalancer.SubchannelPicker pickerCopy = ManagedChannelImpl.this.subchannelPicker;
            if (ManagedChannelImpl.this.shutdown.get()) {
                return ManagedChannelImpl.this.delayedTransport;
            }
            if (pickerCopy == null) {
                ManagedChannelImpl.this.channelExecutor.executeLater(new Runnable(){

                    @Override
                    public void run() {
                        ManagedChannelImpl.this.exitIdleMode();
                    }
                }).drain();
                return ManagedChannelImpl.this.delayedTransport;
            }
            LoadBalancer.PickResult pickResult = pickerCopy.pickSubchannel(args);
            ClientTransport transport = GrpcUtil.getTransportFromPickResult(pickResult, args.getCallOptions().isWaitForReady());
            if (transport != null) {
                return transport;
            }
            return ManagedChannelImpl.this.delayedTransport;
        }
    };

    private void maybeShutdownNowSubchannels() {
        if (this.shutdownNowed) {
            for (InternalSubchannel subchannel : this.subchannels) {
                subchannel.shutdownNow(SHUTDOWN_NOW_STATUS);
            }
            for (InternalSubchannel oobChannel : this.oobChannels) {
                oobChannel.shutdownNow(SHUTDOWN_NOW_STATUS);
            }
        }
    }

    @VisibleForTesting
    void exitIdleMode() {
        if (this.shutdown.get()) {
            return;
        }
        if (this.inUseStateAggregator.isInUse()) {
            this.cancelIdleTimer();
        } else {
            this.rescheduleIdleTimer();
        }
        if (this.loadBalancer != null) {
            return;
        }
        log.log(Level.FINE, "[{0}] Exiting idle mode", this.getLogId());
        LbHelperImpl helper = new LbHelperImpl(this.nameResolver);
        this.loadBalancer = helper.lb = this.loadBalancerFactory.newLoadBalancer(helper);
        NameResolverListenerImpl listener = new NameResolverListenerImpl(helper);
        try {
            this.nameResolver.start(listener);
        }
        catch (Throwable t) {
            listener.onError(Status.fromThrowable(t));
        }
    }

    private void cancelIdleTimer() {
        if (this.idleModeTimerFuture != null) {
            this.idleModeTimerFuture.cancel(false);
            this.idleModeTimer.cancelled = true;
            this.idleModeTimerFuture = null;
            this.idleModeTimer = null;
        }
    }

    private void rescheduleIdleTimer() {
        if (this.idleTimeoutMillis == -1L) {
            return;
        }
        this.cancelIdleTimer();
        this.idleModeTimer = new IdleModeTimer();
        this.idleModeTimerFuture = this.scheduledExecutor.schedule(new LogExceptionRunnable(new Runnable(){

            @Override
            public void run() {
                ManagedChannelImpl.this.channelExecutor.executeLater(ManagedChannelImpl.this.idleModeTimer).drain();
            }
        }), this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    ManagedChannelImpl(String target, BackoffPolicy.Provider backoffPolicyProvider, NameResolver.Factory nameResolverFactory, Attributes nameResolverParams, LoadBalancer.Factory loadBalancerFactory, ClientTransportFactory transportFactory, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, ObjectPool<ScheduledExecutorService> timerServicePool, ObjectPool<? extends Executor> executorPool, ObjectPool<? extends Executor> oobExecutorPool, Supplier<Stopwatch> stopwatchSupplier, long idleTimeoutMillis, @Nullable String userAgent, List<ClientInterceptor> interceptors) {
        this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
        this.nameResolverFactory = (NameResolver.Factory)Preconditions.checkNotNull((Object)nameResolverFactory, (Object)"nameResolverFactory");
        this.nameResolverParams = (Attributes)Preconditions.checkNotNull((Object)nameResolverParams, (Object)"nameResolverParams");
        this.nameResolver = ManagedChannelImpl.getNameResolver(target, nameResolverFactory, nameResolverParams);
        this.loadBalancerFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)loadBalancerFactory, (Object)"loadBalancerFactory");
        this.executorPool = (ObjectPool)Preconditions.checkNotNull(executorPool, (Object)"executorPool");
        this.oobExecutorPool = (ObjectPool)Preconditions.checkNotNull(oobExecutorPool, (Object)"oobExecutorPool");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executorPool.getObject(), (Object)"executor");
        this.delayedTransport = new DelayedClientTransport(this.executor, this.channelExecutor);
        this.delayedTransport.start(this.delayedTransportListener);
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.transportFactory = new CallCredentialsApplyingTransportFactory(transportFactory, this.executor);
        this.interceptorChannel = ClientInterceptors.intercept((Channel)new RealChannel(), interceptors);
        this.timerServicePool = (ObjectPool)Preconditions.checkNotNull(timerServicePool, (Object)"timerServicePool");
        this.scheduledExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timerServicePool.getObject(), (Object)"timerService");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        if (idleTimeoutMillis == -1L) {
            this.idleTimeoutMillis = idleTimeoutMillis;
        } else {
            Preconditions.checkArgument((idleTimeoutMillis >= AbstractManagedChannelImplBuilder.IDLE_MODE_MIN_TIMEOUT_MILLIS ? 1 : 0) != 0, (String)"invalid idleTimeoutMillis %s", (Object[])new Object[]{idleTimeoutMillis});
            this.idleTimeoutMillis = idleTimeoutMillis;
        }
        this.decompressorRegistry = (DecompressorRegistry)Preconditions.checkNotNull((Object)decompressorRegistry, (Object)"decompressorRegistry");
        this.compressorRegistry = (CompressorRegistry)Preconditions.checkNotNull((Object)compressorRegistry, (Object)"compressorRegistry");
        this.userAgent = userAgent;
        log.log(Level.FINE, "[{0}] Created with target {1}", new Object[]{this.getLogId(), target});
    }

    @VisibleForTesting
    static NameResolver getNameResolver(String target, NameResolver.Factory nameResolverFactory, Attributes nameResolverParams) {
        NameResolver resolver;
        URI targetUri = null;
        StringBuilder uriSyntaxErrors = new StringBuilder();
        try {
            targetUri = new URI(target);
        }
        catch (URISyntaxException e) {
            uriSyntaxErrors.append(e.getMessage());
        }
        if (targetUri != null && (resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverParams)) != null) {
            return resolver;
        }
        if (!URI_PATTERN.matcher(target).matches()) {
            try {
                targetUri = new URI(nameResolverFactory.getDefaultScheme(), "", "/" + target, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverParams);
            if (resolver != null) {
                return resolver;
            }
        }
        throw new IllegalArgumentException(String.format("cannot find a NameResolver for %s%s", target, uriSyntaxErrors.length() > 0 ? " (" + uriSyntaxErrors + ")" : ""));
    }

    @Override
    public ManagedChannelImpl shutdown() {
        log.log(Level.FINE, "[{0}] shutdown() called", this.getLogId());
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        this.delayedTransport.shutdown();
        this.channelExecutor.executeLater(new Runnable(){

            @Override
            public void run() {
                ManagedChannelImpl.this.cancelIdleTimer();
            }
        }).drain();
        log.log(Level.FINE, "[{0}] Shutting down", this.getLogId());
        return this;
    }

    @Override
    public ManagedChannelImpl shutdownNow() {
        log.log(Level.FINE, "[{0}] shutdownNow() called", this.getLogId());
        this.shutdown();
        this.delayedTransport.shutdownNow(SHUTDOWN_NOW_STATUS);
        this.channelExecutor.executeLater(new Runnable(){

            @Override
            public void run() {
                if (ManagedChannelImpl.this.shutdownNowed) {
                    return;
                }
                ManagedChannelImpl.this.shutdownNowed = true;
                ManagedChannelImpl.this.maybeShutdownNowSubchannels();
            }
        }).drain();
        return this;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminatedLatch.await(timeout, unit);
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
        return this.interceptorChannel.newCall(method, callOptions);
    }

    @Override
    public String authority() {
        return this.interceptorChannel.authority();
    }

    private void maybeTerminateChannel() {
        if (this.terminated) {
            return;
        }
        if (this.shutdown.get() && this.subchannels.isEmpty() && this.oobChannels.isEmpty()) {
            log.log(Level.FINE, "[{0}] Terminated", this.getLogId());
            this.terminated = true;
            this.terminatedLatch.countDown();
            this.executorPool.returnObject(this.executor);
            this.scheduledExecutor = this.timerServicePool.returnObject(this.scheduledExecutor);
            this.transportFactory.close();
        }
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    private final class SubchannelImplImpl
    extends SubchannelImpl {
        InternalSubchannel subchannel;
        final Object shutdownLock = new Object();
        final Attributes attrs;
        @GuardedBy(value="shutdownLock")
        boolean shutdownRequested;
        @GuardedBy(value="shutdownLock")
        ScheduledFuture<?> delayedShutdownTask;

        SubchannelImplImpl(Attributes attrs) {
            this.attrs = (Attributes)Preconditions.checkNotNull((Object)attrs, (Object)"attrs");
        }

        @Override
        ClientTransport obtainActiveTransport() {
            return this.subchannel.obtainActiveTransport();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void shutdown() {
            Object object = this.shutdownLock;
            synchronized (object) {
                block6: {
                    if (this.shutdownRequested) {
                        if (ManagedChannelImpl.this.terminating && this.delayedShutdownTask != null) {
                            this.delayedShutdownTask.cancel(false);
                            this.delayedShutdownTask = null;
                            break block6;
                        } else {
                            return;
                        }
                    }
                    this.shutdownRequested = true;
                }
                ScheduledExecutorService scheduledExecutorCopy = ManagedChannelImpl.this.scheduledExecutor;
                if (!ManagedChannelImpl.this.terminating && scheduledExecutorCopy != null) {
                    this.delayedShutdownTask = scheduledExecutorCopy.schedule(new LogExceptionRunnable(new Runnable(){

                        @Override
                        public void run() {
                            SubchannelImplImpl.this.subchannel.shutdown();
                        }
                    }), 5L, TimeUnit.SECONDS);
                    return;
                }
            }
            this.subchannel.shutdown();
        }

        @Override
        public void requestConnection() {
            this.subchannel.obtainActiveTransport();
        }

        @Override
        public EquivalentAddressGroup getAddresses() {
            return this.subchannel.getAddressGroup();
        }

        @Override
        public Attributes getAttributes() {
            return this.attrs;
        }
    }

    private class NameResolverListenerImpl
    implements NameResolver.Listener {
        final LoadBalancer balancer;
        final LoadBalancer.Helper helper;

        NameResolverListenerImpl(LbHelperImpl helperImpl) {
            this.balancer = helperImpl.lb;
            this.helper = helperImpl;
        }

        @Override
        @Deprecated
        public void onUpdate(List<ResolvedServerInfoGroup> servers, Attributes config) {
            ArrayList<EquivalentAddressGroup> eags = new ArrayList<EquivalentAddressGroup>(servers.size());
            for (ResolvedServerInfoGroup infoGroup : servers) {
                eags.add(infoGroup.toEquivalentAddressGroup());
            }
            this.onAddresses(eags, config);
        }

        @Override
        public void onAddresses(final List<EquivalentAddressGroup> servers, final Attributes config) {
            if (servers.isEmpty()) {
                this.onError(Status.UNAVAILABLE.withDescription("NameResolver returned an empty list"));
                return;
            }
            log.log(Level.FINE, "[{0}] resolved address: {1}, config={2}", new Object[]{ManagedChannelImpl.this.getLogId(), servers, config});
            this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    if (ManagedChannelImpl.this.terminated) {
                        return;
                    }
                    try {
                        NameResolverListenerImpl.this.balancer.handleResolvedAddressGroups(servers, config);
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, "[" + ManagedChannelImpl.this.getLogId() + "] Unexpected exception from LoadBalancer", e);
                        NameResolverListenerImpl.this.balancer.handleNameResolutionError(Status.INTERNAL.withCause(e).withDescription("Thrown from handleResolvedAddresses(): " + e));
                    }
                }
            });
        }

        @Override
        public void onError(final Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"the error status must not be OK");
            log.log(Level.WARNING, "[{0}] Failed to resolve name. status={1}", new Object[]{ManagedChannelImpl.this.getLogId(), error});
            ManagedChannelImpl.this.channelExecutor.executeLater(new Runnable(){

                @Override
                public void run() {
                    if (ManagedChannelImpl.this.terminated) {
                        return;
                    }
                    NameResolverListenerImpl.this.balancer.handleNameResolutionError(error);
                }
            }).drain();
        }
    }

    private class LbHelperImpl
    extends LoadBalancer.Helper {
        LoadBalancer lb;
        final NameResolver nr;

        LbHelperImpl(NameResolver nr) {
            this.nr = (NameResolver)Preconditions.checkNotNull((Object)nr, (Object)"NameResolver");
        }

        @Override
        public SubchannelImpl createSubchannel(EquivalentAddressGroup addressGroup, Attributes attrs) {
            InternalSubchannel internalSubchannel;
            Preconditions.checkNotNull((Object)addressGroup, (Object)"addressGroup");
            Preconditions.checkNotNull((Object)attrs, (Object)"attrs");
            ScheduledExecutorService scheduledExecutorCopy = ManagedChannelImpl.this.scheduledExecutor;
            Preconditions.checkState((scheduledExecutorCopy != null ? 1 : 0) != 0, (Object)"scheduledExecutor is already cleared. Looks like you are calling this method after you've already shut down");
            final SubchannelImplImpl subchannel = new SubchannelImplImpl(attrs);
            subchannel.subchannel = internalSubchannel = new InternalSubchannel(addressGroup, ManagedChannelImpl.this.authority(), ManagedChannelImpl.this.userAgent, ManagedChannelImpl.this.backoffPolicyProvider, ManagedChannelImpl.this.transportFactory, scheduledExecutorCopy, (Supplier<Stopwatch>)ManagedChannelImpl.this.stopwatchSupplier, ManagedChannelImpl.this.channelExecutor, new InternalSubchannel.Callback(){

                @Override
                void onTerminated(InternalSubchannel is) {
                    ManagedChannelImpl.this.subchannels.remove(is);
                    ManagedChannelImpl.this.maybeTerminateChannel();
                }

                @Override
                void onStateChange(InternalSubchannel is, ConnectivityStateInfo newState) {
                    if (newState.getState() == ConnectivityState.TRANSIENT_FAILURE || newState.getState() == ConnectivityState.IDLE) {
                        LbHelperImpl.this.nr.refresh();
                    }
                    LbHelperImpl.this.lb.handleSubchannelState(subchannel, newState);
                }

                @Override
                void onInUse(InternalSubchannel is) {
                    ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(is, true);
                }

                @Override
                void onNotInUse(InternalSubchannel is) {
                    ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(is, false);
                }
            });
            log.log(Level.FINE, "[{0}] {1} created for {2}", new Object[]{ManagedChannelImpl.this.getLogId(), internalSubchannel.getLogId(), addressGroup});
            this.runSerialized(new Runnable(){

                @Override
                public void run() {
                    if (ManagedChannelImpl.this.terminating) {
                        internalSubchannel.shutdown();
                    }
                    if (!ManagedChannelImpl.this.terminated) {
                        ManagedChannelImpl.this.subchannels.add(internalSubchannel);
                    }
                }
            });
            return subchannel;
        }

        @Override
        public ManagedChannel createOobChannel(EquivalentAddressGroup addressGroup, String authority) {
            ScheduledExecutorService scheduledExecutorCopy = ManagedChannelImpl.this.scheduledExecutor;
            Preconditions.checkState((scheduledExecutorCopy != null ? 1 : 0) != 0, (Object)"scheduledExecutor is already cleared. Looks like you are calling this method after you've already shut down");
            final OobChannel oobChannel = new OobChannel(authority, ManagedChannelImpl.this.oobExecutorPool, scheduledExecutorCopy, ManagedChannelImpl.this.channelExecutor);
            final InternalSubchannel internalSubchannel = new InternalSubchannel(addressGroup, authority, ManagedChannelImpl.this.userAgent, ManagedChannelImpl.this.backoffPolicyProvider, ManagedChannelImpl.this.transportFactory, scheduledExecutorCopy, (Supplier<Stopwatch>)ManagedChannelImpl.this.stopwatchSupplier, ManagedChannelImpl.this.channelExecutor, new InternalSubchannel.Callback(){

                @Override
                void onTerminated(InternalSubchannel is) {
                    ManagedChannelImpl.this.oobChannels.remove(is);
                    oobChannel.handleSubchannelTerminated();
                    ManagedChannelImpl.this.maybeTerminateChannel();
                }

                @Override
                void onStateChange(InternalSubchannel is, ConnectivityStateInfo newState) {
                    oobChannel.handleSubchannelStateChange(newState);
                }
            });
            oobChannel.setSubchannel(internalSubchannel);
            this.runSerialized(new Runnable(){

                @Override
                public void run() {
                    if (ManagedChannelImpl.this.terminating) {
                        oobChannel.shutdown();
                    }
                    if (!ManagedChannelImpl.this.terminated) {
                        ManagedChannelImpl.this.oobChannels.add(internalSubchannel);
                    }
                }
            });
            return oobChannel;
        }

        @Override
        public String getAuthority() {
            return ManagedChannelImpl.this.authority();
        }

        @Override
        public NameResolver.Factory getNameResolverFactory() {
            return ManagedChannelImpl.this.nameResolverFactory;
        }

        @Override
        public void runSerialized(Runnable task) {
            ManagedChannelImpl.this.channelExecutor.executeLater(task).drain();
        }

        @Override
        public void updatePicker(final LoadBalancer.SubchannelPicker picker) {
            this.runSerialized(new Runnable(){

                @Override
                public void run() {
                    ManagedChannelImpl.this.subchannelPicker = picker;
                    ManagedChannelImpl.this.delayedTransport.reprocess(picker);
                }
            });
        }
    }

    private class RealChannel
    extends Channel {
        private RealChannel() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
            Executor executor = callOptions.getExecutor();
            if (executor == null) {
                executor = ManagedChannelImpl.this.executor;
            }
            return new ClientCallImpl<ReqT, RespT>(method, executor, callOptions, ManagedChannelImpl.this.transportProvider, ManagedChannelImpl.this.scheduledExecutor).setDecompressorRegistry(ManagedChannelImpl.this.decompressorRegistry).setCompressorRegistry(ManagedChannelImpl.this.compressorRegistry);
        }

        @Override
        public String authority() {
            String authority = ManagedChannelImpl.this.nameResolver.getServiceAuthority();
            return (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
        }
    }

    private class IdleModeTimer
    implements Runnable {
        boolean cancelled;

        private IdleModeTimer() {
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            log.log(Level.FINE, "[{0}] Entering idle mode", ManagedChannelImpl.this.getLogId());
            ManagedChannelImpl.this.nameResolver.shutdown();
            ManagedChannelImpl.this.nameResolver = ManagedChannelImpl.getNameResolver(ManagedChannelImpl.this.target, ManagedChannelImpl.this.nameResolverFactory, ManagedChannelImpl.this.nameResolverParams);
            ManagedChannelImpl.this.loadBalancer.shutdown();
            ManagedChannelImpl.this.loadBalancer = null;
            ManagedChannelImpl.this.subchannelPicker = null;
        }
    }
}

