Data structure for manifest file generated by `docfx build`
===========================

After `docfx build`, `docfx` generates a manifest file in JSON format in the root output folder, listing some basic information about the set of files that `docfx build` handles.

Before *DocFX* version 1.7, the manifest file is an Array of items. Then *DocFX* realizes that there are also global properties manifest file consumers care about, for example, the list of TOC files that *DocFX* processed. However, it is hard to add properties to an Array model. So since version 1.8, *DocFX* introduces a new Object model for the manifest file.

For backward compatibility, in version 1.8, *DocFX* generates both Array model to-be-obsoleted and the new Object model. 

In version 1.9, manifest file in Array model is **removed**.

In version 2.24, `version` is obsolete and `group` is used instead.

Below table shows the difference between manifest file in Array model and manifest file in Object model.

---- | File Name | Data Model
-----|-----------|--------------
Old Array Model | `.manifest` | [Array model](#the-obsoleted-array-model)
New Object Model | `manifest.json` | [Object model](#the-new-object-model)

The obsoleted Array model
-------------------------
Array model contains a list of [Manifest Item](#manifestitem)s.

The new Object model
-----------------------
Current supported properties for the Object model is listed as below:

Property            | Type                  | Description
---                 | ---                   | ---
`source_base_path`  | string              | the directory path which contains `docfx.json`
`files`             | List<[ManifestItem](#manifestitem)> | contains the information of all the output files. (*doesn't include templates and themes*)
`incremental_info`  | List<[IncrementalInfo](#incrementalinfo)> | contains incremental infomation.
`groups`            | List<[ManifestGroupInfo](#manifestgroupinfo)> | contains information of groups.
`sitemap`           | object                | *contains options for generating site map for post processor use*
`xrefmap`           | object                | **deprecated, use `xrefmap` in `groups`**
`version_info`      | List\<VersionInfo\> | **deprecated, use `groups`**
`homepages`         | List\<string\>      | **deprecated**

### ManifestItem


|        Property        |                         Type                          |                                                                                                                             Description                                                                                                                              |
|------------------------|-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|         `type`         |                        string                         | The `documentType` is generated by plugins or specified to each file using [Yaml Header](docfx_flavored_markdown.md#yaml-header). Currently by default *DocFX* generates following *document type*s: `ManagedReference`, `Conceptual`, `RestApi`, `Resource`, `Toc`. |
| `source_relative_path` |                        string                         |                                                                                                            the input file path, relative to `docfx.json`                                                                                                             |
|        `output`        | Dictionary<string, [OutputFileInfo](#outputfileinfo)> |                                                                For each output file, the **key** is the extension of the transformed file, the extension is determined by the template it applies to.                                                                |
|    `is_incremental`    |                         bool                          |                                                                                                    indicates whether this file is incremtal or rebuilt this time                                                                                                     |
|       `version`        |                        string                         |                                                                                                                      **deprecated, use group**                                                                                                                       |
|        `group`         |                        string                         |                                                                                                                the group the current item belongs to                                                                                                                 |
|      `log_codes`       |                     List<string>                      |                                                                                                           the codes logged when building the current item                                                                                                            |

### OutputFileInfo

Property               | Type                  | Description
---                    | ---                   | ---
`relative_path`        | string                | the logical output file path relative to output root. If it doesn't exist physically, it can be found through `link_to_path`
`link_to_path`         | string                | the physical output file path
`hash`                 | string                | tha hash of the output file content

### IncrementalInfo

Property               | Type                  | Description
---                    | ---                   | ---
`status`               | [IncrementalStatus](#incrementalstatus) | current build's overall incremental information
`processors`           | Dictionary<string, [IncrementalStatus](#incrementalstatus)> | incremental information of each processor. Key is the name of the processor.

### IncrementalStatus

Property               | Type                  | Description
---                    | ---                   | ---
`can_incremental`      | bool                  | indicates whenther current build supports incremental build
`details`              | string                | detailed explanation of the build status
`incrementalPhase`     | string                | the phase of the status, can be `Build` or `PostProcessing`

### ManifestGroupInfo


| Property  |  Type  |                                          Description                                           |
|-----------|--------|------------------------------------------------------------------------------------------------|
|  `name`   | string |                       group name (*default group hasn't this property*)                        |
|  `dest`   | string | group output folder, relative to the root output folder (*default group hasn't this property*) |
| `xrefmap` | string |                             group xrefmap's path in output folder                              |

