DocFX Flavored Markdown
==========================================

DocFX supports `DocFX Flavored Markdown`, aka DFM. It supports all [GitHub Flavored Markdown](https://github.github.com/gfm/) syntax and compatible with CommonMark. Also, DFM adds new syntax to support additional functionalities, including cross reference and file inclusion.

> [!Note]
> The default markdown engine generated by `docfx init` has been switched to markdig engine, which is built on the top of [markdig](https://github.com/lunet-io/markdig). Previous markdown engine `dfm` and `dfm-latest` will be kept for compatibiilty.
>

## Yaml Header

Yaml header in DFM is considered as the metadata for the Markdown file. It will transform to `yamlheader` tag when processed.
Yaml header MUST be the first thing in the file and MUST take the form of valid YAML set between triple-dashed lines. Here is a basic example:

```md
---
uid: A.md
title: A
---
```

## Cross Reference

Cross reference allows you to link to another topic by using its unique identifier (called UID) instead of using its file path.

For conceptual Markdown files UID can be defined by adding a `uid` metadata in YAML header:

```md
---
uid: uid_of_the_file
---

This is a conceptual topic with `uid` specified.
```

For reference topics, UIDs are auto generated from source code and can be found in generated YAML files.

You can use one of the following syntax to cross reference a topic with UID defined:

1. Markdown link: `[link_text](xref:uid_of_the_topic)`
2. Auto link: `<xref:uid_of_the_topic>`
3. Shorthand form: `@"uid_of_the_topic"`

All will render to:

```html
<a href="url_of_the_topic">link_text</a>
```

If `link_text` is not specified, DocFX will extract the title from the target topic and use it as the link text.

Do not use the `@uid` link in brackets (like this: `(@uid)`). DocFX cannot parse this link. The `@uid` link should be separated with white spaces. If you need to add a link in brackets, use `[](xref:uid)`.

> [!Note]
> Hashtag in `xref` is always treated as separator between file name and anchor name. That means if you have `#` in UID, it has
> to be [encoded](https://en.wikipedia.org/wiki/Percent-encoding) to `%23`.
>
> Actually `xref` format follows URI standard so all [reserved characters](https://tools.ietf.org/html/rfc3986#section-2.2) should be encoded.

For more information, see [cross reference](../tutorial/links_and_cross_references.md#using-cross-reference).


## File Inclusion
DFM adds syntax to include other file parts into current file, the included file will also be considered as in DFM syntax.

There are two types of file inclusion: Inline and block, as similar to inline code span and block code.

> [!NOTE]
> YAML header is **NOT** supported when the file is an inclusion.

### Inline
Inline file inclusion is in the following syntax, in which `<title>` stands for the title of the included file, and `<filepath>` stands for the file path of the included file. The file path can be either absolute or relative.`<filepath>` can be wrapped by `'` or `"`.

> [!NOTE]
> For inline file inclusion, the file included will be considered as containing only inline tags, for example,
> `### header` inside the file will not transfer since `<h3>` is a block tag, while `[a](b)` will transform to
> `<a href='b'>a</a>` since `<a>` is an inline tag.
> Also, ending white spaces will be **trimmed**, considering ending white spaces in inline inclusion in most cases are typos.

```md
...Other inline contents... [!include[<title>](<filepath>)]
```
### Block
Block file inclusion must be in a single line and with no prefix characters before the start `[`. Content inside the included file will transform using DFM syntax.
```md
[!include[<title>](<filepath>)]
```

## Section definition
User may need to define section. Mostly used for code table.
Give an example below.

    > [!div class="tabbedCodeSnippets" data-resources="OutlookServices.Calendar"]
    > ```cs
    > <cs code text>
    > ```
    > ```javascript
    > <js code text>
    > ```

The above blockquote Markdown text will transform to section html as in the following:
```html
<div class="tabbedCodeSnippets" data-resources="OutlookServices.Calendar">
  <pre><code>cs code text</code></pre>
  <pre><code>js code text</code></pre>
</div>
```

## Code Snippet
Allows you to insert code with code language specified. The content of specified code path will expand.

```md
[!code-<language>[<name>](<codepath><queryoption><queryoptionvalue> "<title>")]
```

* __`<language>`__ can be made up of any number of character and '-'. However, the recommended value should follow [Highlight.js language names and aliases](http://highlightjs.readthedocs.org/en/latest/css-classes-reference.html#language-names-and-aliases).
* __`<codepath>`__ is the path relative to the file containing this markdown content in file system, which indicates the code snippet file that you want to expand.
* __`<queryoption>`__ and __`<queryoptionvalue>`__ are used together to retrieve part of the code snippet file in the line range or tag name way. We have 2 query string options to represent these two ways:


|                          |         query string using `#`         |             query string using `?`             |
|--------------------------|----------------------------------------|------------------------------------------------|
|      1. line range       | `#L{startlinenumber}-L{endlinenumber}` | `?start={startlinenumber}&end={endlinenumber}` |
|        2. tagname        |              `#{tagname}`              |               `?name={tagname}`                |
| 3. multiple region range |             *Unsupported*              |          `?range={rangequerystring}`           |
|    4. highlight lines    |             *Unsupported*              |        `?highlight={rangequerystring}`         |
|        5. dedent         |             *Unsupported*              |            `?dedent={dedentlength}`            |

* In `?` query string, the whole file will be included if none of the first three option is specified.
* If `dedent` isn't specified, the maximum common indent will be trimmed automatically.
* __`<title>`__ can be omitted as it doesn't affect the DocFX markup result, but it can beautify the result of other Markdown engine, like GitHub Preview.

### Code Snippet Sample
```md
[!code-csharp[Main](Program.cs)]

[!code[Main](Program.cs#L12-L16 "This is source file")]
[!code-vb[Main](../Application/Program.vb#testsnippet "This is source file")]

[!code[Main](index.xml?start=5&end=9)]
[!code-javascript[Main](../jquery.js?name=testsnippet)]
[!code[Main](index.xml?range=2,5-7,9-) "This includes the lines 2, 5, 6, 7 and lines 9 to the last line"]
[!code[Main](index.xml?highlight=2,5-7,9-) "This includes the whole file with lines 2,5-7,9- highlighted"]
```

### Tag Name Representation in Code Snippet Source File
DFM currently supports the following __`<language>`__ values to be able to retrieve by tag name:
* C family
  - Start with: `// <{name}>`
  - End with: `// </{name}>`
  - Languages:
    actionscript,
    arduino,
    assembly (alias: nasm),
    c (alias: cpp, c++, objective-c, obj-c, objc, objectivec),
    csharp (alias: cs),
    cshtml,
    cuda,
    d (alias: dlang),
    fsharp (alias: fs),
    go (alias: golang),
    java,
    javascript (alias: js, node),
    pascal,
    php,
    processing,
    rust,
    scala,
    smalltalk,
    swift,
    typescript (alias: ts)
  - File extensions:
    .as,
    .asm,
    .ino,
    .c,
    .cc,
    .cpp,
    .cs,
    .cshtml
    .cu,
    .cuh,
    .d,
    .fs,
    .fsi,
    .fsx,
    .go,
    .h,
    .hpp,
    .java,
    .js,
    .pas,
    .php,
    .pde,
    .rs,
    .scala,
    .st,
    .swift,
    .ts
* Basic family
  - Start with: `' <{name}>`
  - End with: `' </{name}>`
  - Languages:
    vb,
    vbhtml,
    vbnet,
    vbscript
  - File extensions:
    .bas,
    .vb,
    .vba,
    .vbhtml,
    .vbs
* Markup language family
  - Start with: `<!-- <{name}> -->`
  - End with: `<!-- </{name}> -->`
  - Languages:
    cshtml,
    html,
    vbhtml,
    wsdl,
    xml,
    xsl,
    xslt,
    xsd,
    xaml
  - File extensions:
    .asp,
    .aspx,
    .csdl,
    .cshtml,
    .edmx,
    .jsp,
    .vbhtml,
    .wsdl,
    .xaml,
    .xml,
    .xsd,
    .xsl,
    .xslt,
    .html
* Sql family
  - Start with: `-- <{name}>`
  - End with: `-- </{name}>`
  - Languages:
    sql
  - File extensions:
    .sql
* Script family
  - Start with: `# <{name}>`
  - End with: `# </{name}>`
  - Languages:
    perl,
    powershell (alias: posh),
    python,
    r,
    ruby (alias: ru),
    shell (alias: sh, bash)
  - File extensions:
    .bash,
    .pl,
    .ps1,
    .py,
    .r,
    .ru,
    .ruby,
    .sh
* Special language
  * batchfile
    - Start with: `rem <{name}>`
    - End with: `rem </{name}>`
    - Languages:
      batchfile
    - File extensions:
      .bat
      .cmd
  * csharp
    - Start with: `#region {name}`
    - End with: `#endregion`
    - Languages:
      csharp (alias: cs)
    - File extensions:
      .cs
      .cshtml
  * erlang
    - Start with: `% <{name}>`
    - End with: `% </{name}>`
    - Languages:
      erlang
    - File extensions:
      .erl
  * haskell
    - Start with: `-- <{name}>`
    - End with: `-- </{name}>`
    - Languages:
      haskell
    - File extensions:
      .hs
  * matlab
    - Start with: `% <{name}>`
    - End with: `% </{name}>`
    - Languages:
      matlab
    - File extensions:
      .matlab
  * lisp
    - Start with: `; <{name}>`
    - End with: `; </{name}>`
    - Languages:
      lisp
    - File extensions:
      .lisp,
      .lsp
  * lua
    - Start with: `-- <{name}>`
    - End with: `-- </{name}>`
    - Languages:
      lua
    - File extensions:
      .lua
  * vb
    - Start with: `#Region {name}`
    - End with: `#End Region`
    - Languages:
      vb (alias: vbnet)
    - File extensions:
      .vb
      .vbhtml

> [!Note]
> If dev-lang is not specified, file extension will be used to determine the language.

## Code Snippet for Jupyter Notebooks

Allows you to insert code from a code cell of a Jupyter Notebook. The `source` content in the specified code cell will expand. 

Steps to use this:

1.  In your Jupyter Notebook, add metadata to the code cell you will reference:
    ```json
      "metadata": {
        "name": "{tagname}"
       }
    ```
    
1. In your .md file, use  `name` to identify the cell.  
    ```md
    [!notebook-<language>[](<codepath>?name={tagname})]]
    ```
    
### Code Snippet for Jupyter Notebooks Sample

For this Jupyter Notebook cell:

```json
{
 "cells": [
  {
   "cell_type": "code",
   "execution_count": null,
   "metadata": {
    "name": "import"
   },
   "outputs": [],
   "source": [
    "import azureml.core\n",
    "print(azureml.core.VERSION)"
   ]
  },
 ```
 
Use the markup:

 ```md
[!notebook-python[](<codepath>?name={import})]]
```

to display the lines of code in the `source` part of the cell:

```python
import azureml.core
print(azureml.core.VERSION)
```

## Note (Warning/Tip/Important)
Using specific syntax inside block quote to indicate the following content is Note.

```
> [!NOTE]
> <note content>
> [!WARNING]
> <warning content>
```

The above content will be transformed to the following html:

```
<div class="NOTE">
  <h5>NOTE</h5>
  <p>note content</p>
</div>
<div class="WARNING">
  <h5>WARNING</h5>
  <p>WARNING content</p>
</div>
```

Here are all the supported note types with the styling of the default theme applied:

> [!NOTE]
> This is a note which needs your attention, but it's not super important.
>
> [!TIP]
> This is a note which needs your attention, but it's not super important.
>
> [!WARNING]
> This is a warning containing some important message.
>
> [!IMPORTANT]
> This is a warning containing some important message.
>
> [!CAUTION]
> This is a warning containing some important message.

## Tabbed content

### Syntax

* Start a tab by a special markdown title (any level).
  * Title content should be a markdown link.
  * Link target is `#tab/{tabid}` or `#tab/{tabid}/{condition}`
* Continue by any other content.
* End by a markdown hr.

### Example

```md
Tab group 1:

# [Tab Text 1](#tab/tabid-1)

Tab content-1-1.

# [Tab Text 2](#tab/tabid-2)

Tab content-2-1.

***

Tab group 2:

# [Tab Text A](#tab/tabid-a)

Tab content-a-1.

# [Tab Text B](#tab/tabid-b)

Tab content-b-1.

***

Tab group 3:

# [Tab Text 1](#tab/tabid-1)

Tab content-1-1.

# [Tab Text 2](#tab/tabid-2)

Tab content-2-1.

***

Tab group 4:

# [Tab Text A](#tab/tabid-a)

Tab content-a-2.

# [Tab Text B](#tab/tabid-b)

Tab content-b-2.

***
```
The result will be:

Tab group 1:

# [Tab Text 1](#tab/tabid-1)

Tab content-1-1.

# [Tab Text 2](#tab/tabid-2)

Tab content-2-1.

***

Tab group 2:

# [Tab Text A](#tab/tabid-a)

Tab content-a-1.

# [Tab Text B](#tab/tabid-b)

Tab content-b-1.

***

Tab group 3:

# [Tab Text 1](#tab/tabid-1)

Tab content-1-1.

# [Tab Text 2](#tab/tabid-2)

Tab content-2-1.

***

Tab group 4:

# [Tab Text A](#tab/tabid-a)

Tab content-a-2.

# [Tab Text B](#tab/tabid-b)

Tab content-b-2.

***

### Behavior

Tab groups with a same set of id are linkable in one page.

In example, tab group 1, 3 have same id set: `tabid-1`, `tabid-2`, tab group 2, 4 have same id set: `tabid-a`, `tabid-b`.

So tab group 1, 3 are linked, tab group 2, 4 are linked.
When tab `tabid-1` in tab group 1 is clicked, tab `tabid-1` in tab group 3 will be selected in same time.
But tab group 2, 4 do not have any changed.

### Condition

Condition is the tab id of other table groups.

e.g.:

```md
Tab Group 1:

# [**Tab Text 1**](#tab/tabid-1)

Tab content-1.

# [**Tab Text 2**](#tab/tabid-2)

Tab content-2.

***

Tab Group 2:

# [Tab Text A](#tab/tabid-a/tabid-1)

Tab content-a for 1.

# [Tab Text A](#tab/tabid-a/tabid-2)

Tab content-a for 2.

# [Tab Text B](#tab/tabid-b/tabid-1)

Tab content-b for 1.

# [Tab Text B](#tab/tabid-b/tabid-2)

Tab content-b for 2.

***
```

Result:

Tab Group 1:

# [**Tab Text 1**](#tab/tabid-1)

Tab content-1.

# [**Tab Text 2**](#tab/tabid-2)

Tab content-2.

***

Tab Group 2:

# [Tab Text A](#tab/tabid-a/tabid-1)

Tab content-a for 1.

# [Tab Text A](#tab/tabid-a/tabid-2)

Tab content-a for 2.

# [Tab Text B](#tab/tabid-b/tabid-1)

Tab content-b for 1.

# [Tab Text B](#tab/tabid-b/tabid-2)

Tab content-b for 2.

***

When select `tabid-1` in tab group 1, you can get content-a or content-b for 1 in group 2.\
When select `tabid-2` in tab group 1, you can get content-a or content-b for 2 in group 2.

## Video

Allows you to add videos to your topics.

Syntax:
```md
> [!Video embed_link]
```

> [!NOTE]
> You must provide the **embed** uri of the video you wish to add to your topic.

Example:
```md
> [!Video https://www.youtube.com/embed/TAaG0nUUy6A]
```

Result:

> [!Video https://www.youtube.com/embed/TAaG0nUUy6A]

## Differences introduced by DFM syntax

> [!Warning]
> DFM introduces more syntax to support more functionalities. When GFM does not support them, preview the
> Markdown file inside *GFM Preview* can lead to different results.

### YAML header

In GFM, YAML header must start at the very beginning of the Markdown file.
In DFM, YAML header contains more powerful meanings. Refer to [Yaml Header](#yaml-header) for details.

```md
...some text...

---
a: b
---
```

In GFM, it would be rendered as `<hr>a: b<hr>`.  
In DFM, it would be rendered as a YAML header.

If you want to get `<hr>` in html in DFM, use:
```md
- - -
***
* * *
```
or change content to make it not in YAML format:
```md
---
a\: b
---
```

### Text after block extension

Some block extension in DFM cannot be recognized in GFM.
In GFM, it would be treated as a part of paragraph.
Then, following content would be treated as a part of paragraph.

For example:
```md
> [!NOTE]
>     This is code.
```

In GFM, it will be rendered as a paragraph with content `[!NOTE] This is code.` in blockquote.  
In DFM, it will be rendered as a code in note.
