# Contributing to Stetho
We want to make contributing to this project as easy and transparent as
possible.

## Our Development Process
We work directly in the github project and provide versioned releases
appropriate for major milestones and minor bug fixes or improvements.  GitHub
is used directly for issues and pull requests and the developers actively
respond to requests.

## Pull Requests
We actively welcome your pull requests.  

1. Fork the repo and create your branch from `master`.  
2. If you've added code that should be tested, add tests  
3. If you've changed APIs, update the documentation.  
4. Ensure the test suite passes.  
5. Make sure your code lints.  
6. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Issues  
We use GitHub issues to track public bugs. Please ensure your description is
clear and has sufficient instructions to be able to reproduce the issue.

Facebook has a [bounty program](https://www.facebook.com/whitehat/) for the safe
disclosure of security bugs. In those cases, please go through the process
outlined on that page and do not file a public issue.

## Coding Style  
* 2 spaces for indentation rather than tabs
* Line wrapping indents 4 spaces
* 100 character line length
* One parameter per line when line wrapping is required
* Use the `m` member variable prefix for private fields
* Opening braces to appear on the same line as code

## License
By contributing to Stetho, you agree that your contributions will be licensed
under its BSD license.
