# 1.2.欢迎来到 FreeBSD！

FreeBSD 是一款开源、符合标准的类 Unix 操作系统，适用于 x86（32 位和 64 位）、ARM、AArch64、RISC-V、POWER 和 PowerPC 计算机。它提供了现今被视为理所当然的所有功能，例如抢占式多任务处理、内存保护、虚拟内存、多用户功能、SMP（对称多处理）支持，以及为不同语言和框架提供了所有的开源开发工具，以及基于 X Window 系统、KDE 和 GNOME 的桌面功能。FreeBSD 的独家优势包括：

* **自由的开源许可证**：你可以自由修改和扩展其源代码，并将其纳入开源项目和闭源产品中，而不受典型著佐权许可证的限制，同时规避了潜在的许可证不兼容问题。
* **强大的 TCP/IP 网络功能**：FreeBSD 实现了行业标准协议，性能和可扩展性日益增强。这使其在服务器、路由和防火墙角色中都非常适合，实际上许多公司和供应商正是出于这个目的而使用 FreeBSD。
* **完全集成的 OpenZFS 支持**，包括在根文件系统使用 ZFS、ZFS 启动环境、故障管理、管理权限委派、对 jail 的支持、FreeBSD 特定文档和系统安装程序的支持。
* **海量的安全功能**，包括强制访问控制框架、Capsicum 能力和沙箱机制。
* **三万余款预构建软件包**，适用于所有受支持的架构。Ports 还可使你可以轻松构建自己的定制软件包。
* **文档**：除了手册和由不同作者编写的书籍（涵盖系统管理到内核内部机制等主题）外，还有 [man(1)](https://man.freebsd.org/cgi/man.cgi?query=man&sektion=1&format=html) 页面，不仅包含用户空间守护进程、工具和配置文件的文档，还包括了内核驱动 API（第 9 节）和单个驱动程序（第 4 节）的文档。
* **简单一致的存储库结构和构建系统**：FreeBSD 使用单一的存储库管理所有组件——包括内核和用户空间。结合统一且易于定制的构建系统和精心设计的开发流程，使 FreeBSD 易于与你自己产品的构建基础设施集成。
* **恪守 Unix 哲学**，更倾向于可组合性，而非单一的“全能”守护进程及硬编码行为。
* **与 Linux 的二进制兼容性**，使 FreeBSD 能够在无需虚拟化的情况下运行许多 Linux 二进制文件。

FreeBSD 基于加州大学伯克利分校计算机系统研究小组（CSRG）发布的 4.4BSD-Lite，并延续了 BSD 系统开发的卓越传统。除了 CSRG 提供的出色工作外，FreeBSD 项目还投入了数千个小时用于扩展功能和优化系统，以实现最大性能和可靠性（尤其是在实际负载的情况下）。FreeBSD 在性能和可靠性方面能与其他开源和商业产品相媲美，并结合了独一无二的前沿特性。

## 1.2.1. FreeBSD 能做什么？

FreeBSD 的应用范围仅限于你的想象力。从软件开发到工厂自动化，从库存管理到远程卫星天线的方位校正；如果可以用商业 UNIX® 产品完成，那么很可能你也可以用 FreeBSD 来实现！FreeBSD 还明显受益于全球研究中心和大学开发的数千款高质量应用程序，他们通常以极低的成本甚至免费提供。

由于 FreeBSD 的源代码可自由获取，该系统也可以根据特定应用程序和项目进行几乎前所未有的定制，这在大多数主要商业供应商的操作系统中通常是不可能的。以下只是现在人们使用 FreeBSD 的一些应用示例：

* **互联网服务**：FreeBSD 内置的强大 TCP/IP 网络功能使其成为各种互联网服务的理想平台，例如：

  * Web 服务器
  * IPv4 和 IPv6 路由器
  * 防火墙和 NAT（“IP 伪装”）网关
  * FTP 服务器
  * 邮件服务器
  * 存储服务器
  * 虚拟化服务器
  * 及更多……

* **教育**：你是计算机科学或相关工程领域的学生吗？没有比通过 FreeBSD 提供的动手、深入体验来学习操作系统、计算机体系结构和网络的更好方法了。对那些使用计算机完成 *其他* 工作的用户，许多可自由获得的 CAD、数学和图形设计软件包也非常有帮助！

* **研究**：由于整个系统的源代码都是开源的，FreeBSD 是操作系统及计算机科学其他领域研究的优秀平台。FreeBSD 的自由特性使得远程团队可以在想法和共享开发上进行合作，而无需担心特殊许可协议或受公开论坛讨论内容的限制。

* **网络**：需要一台新的路由器？一台域名服务器（DNS）？一款防火墙来保护你的内部网络？FreeBSD 可以轻松将你角落里闲置的 PC 变成具备先进数据包过滤能力的高级路由器。

* **嵌入式**：FreeBSD 是构建嵌入式系统的绝佳平台。支持 ARM、AArch64 和 PowerPC 平台，结合强大的网络栈、前沿特性以及宽松的 [BSD 许可证](https://docs.freebsd.org/en/books/faq/#bsd-license-restrictions)，FreeBSD 为构建嵌入式路由器、防火墙和其他设备提供了良好的基石。

* **桌面**：FreeBSD 是廉价桌面解决方案的不错选择（使用免费可选的 X11 服务器及 Wayland 显示服务器）。FreeBSD 提供了多种开源桌面环境，包括标准的 GNOME 和 KDE 图形用户界面。FreeBSD 甚至可以从中央服务器以“无盘”方式启动，使得单个工作站更加经济且易于管理。

* **软件开发**：FreeBSD 基本系统配备了完整的开发工具套件，包括完整的 C/C++ 编译器和调试工具。通过 ports 和软件包，还可轻松获取更多其他语言支持。

FreeBSD 可以免费下载，及通过 CD-ROM 和 DVD 获取。更多有关获取 FreeBSD 的信息，请参见 [获取 FreeBSD](https://docs.freebsd.org/en/books/handbook/mirrors/#mirrors)。

## 1.2.2. 谁在使用 FreeBSD？

FreeBSD 以其强大的 web 服务器能力而闻名。可以在 FreeBSD 基金会的网站上找到基于 FreeBSD 的产品和服务的 [公司推荐信列表](https://freebsdfoundation.org/about-us/testimonials/) 。维基百科也维护了一份 [基于 FreeBSD 的产品列表](https://en.wikipedia.org/wiki/List_of_products_based_on_FreeBSD)。
