# 1.3.关于 FreeBSD 项目

以下部分提供了 FreeBSD 项目的相关背景信息，包括简史、项目宗旨和[开发模型](https://docs.freebsd.org/en/books/dev-model/)。

## 1.3.1 FreeBSD 简史

FreeBSD 项目始于 1993 年初，部分起因于 386BSD 非官方补丁包的最后三位协调人：Nate Williams、Rod Grimes 和 Jordan Hubbard 的构思。

最初的打算是为 386BSD 制作一个中间快照，来解决补丁包机制多个无法解决的问题。FreeBSD 项目的早期工作名称是 386BSD 0.5/386BSD Interim，就说明了这一事实。

386BSD 是 Bill Jolitz 开发的操作系统，在此之前已经被彻底无视了近一年。随着补丁包的不断膨胀，他们决定通过开发这个临时的“清理”快照来帮助 Bill。然而，当 Bill Jolitz 突然决定退出该项目，且没有明确的后续规划时，这一计划戛然而止。

三人认为，哪怕没有 Bill 的支持，这一想法仍然值得追求，因此他们采用了 David Greenman 创造的“FreeBSD”这个名字。在咨询了当前的系统用户后，初步目标确定了下来，在 FreeBSD 项目明显有望成为现实后，Jordan 便联系了 Walnut Creek CDROM，目的是为那些没有便捷互联网访问的用户改善 FreeBSD 的分发渠道。Walnut Creek CDROM 不仅帮助将 FreeBSD 分发到 CD 上，还提供了一台可供 FreeBSD 项目使用的机器和快速的互联网连接。若没有 Walnut Creek CDROM 对这个当时这个完全不为人知的项目几乎前所未有的信任，FreeBSD 不会取得今天如此迅速的发展。

第一张随 CD-ROM（以及一般的网络）分发的是 FreeBSD 1.0，发布于 1993 年 12 月。1.0 版本基于来自加州大学伯克利分校的 4.3BSD-Lite（“Net/2”）磁带，许多组件也由 386BSD 和自由软件基金会提供。作为初次发布，这一版本极为成功，并于 1994 年 5 月紧接着发布了备受好评的 FreeBSD 1.1。

在此期间，某些出乎意料的阴云浮现在地平线上，Novell 与加州大学伯克利分校就 Berkeley Net/2 磁带的法律地位达成了长期诉讼的和解。和解的一项条件是，加州大学伯克利分校承认 Net/2 的三个文件是“侵权”的代码，必须删除，因为它们是 Novell 的财产（Novell 此前就从 AT&T 那里获得了这些文件）。伯克利所获得的回报是 Novell 的“许可”，即在最终发布 4.4BSD-Lite 时，将被声明为是合规的，并强烈建议所有现有的 Net/2 用户进行切换。其中就有 FreeBSD，FreeBSD 项目被要求在 1994 年 7 月底之前停止分发自己基于 Net/2 的产品。根据协议，FreeBSD 项目被允许在截止日期前发布最后一个版本，该版本为 FreeBSD 1.1.5.1。

随后，FreeBSD 开始了一项艰苦的任务：从一个全新的、相对不完整的 4.4BSD-Lite 版本中重新创造自己。尽管仅有三个涉及 System V 共享内存和信号量的文件被移除，但已对 BSD 发行版进行了诸多其他更改和错误修复，因此将所有 FreeBSD 开发合并到 4.4BSD-Lite 中是一项艰巨的任务。直到 1994 年 11 月，FreeBSD 项目才实现这一过渡，并于 12 月向全世界发布了 FreeBSD 2.0。尽管该版本在某些方面仍显粗糙，但这是一个重要的里程碑，并于 1995 年 6 月发布了更为稳健、安装更简便的 FreeBSD 2.0.5 版本。

自那时起，FreeBSD 每次发布都在不断改善前一个版本的稳定性、速度和功能集。

目前，长期开发项目继续在 15.0-CURRENT（main）分支中进行，15.0 的快照版本持续在[快照服务器](https://download.freebsd.org/snapshots/)上发布，随着开发的进展而更新。

## 1.3.2 FreeBSD 项目宗旨

FreeBSD 的项目宗旨是提供可以用于一切目的且无附加条件的软件。我们中的许多人对代码（和项目）进行了大量投入，自然也希望能偶尔获得一些经济补偿，但我们绝对不打算一定如此。我们相信，我们的首要“使命”是向所有人提供代码，无论其目的如何，以便代码能得到尽可能普遍的使用，并产生尽可能大的利益。我们认为这是自由软件最基本的宗旨之一，也是我们热情拥护的宗旨。

在我们的源代码树中，属于 GNU 通用公共许可证（GPL）和 GNU 宽通用公共许可证（LGPL）的代码附带的条件略多，尽管这些条件是要求强制开源，而非通常的限制访问。由于在商业上使用 GPL 软件可能会产生的额外复杂性，当有合理选择时，我们更倾向于选择采用以更宽松的 BSD 许可证授权的软件。

## 1.3.3 FreeBSD 开发模型

FreeBSD 的开发过程[非常地开放灵活](https://docs.freebsd.org/en/books/dev-model/)，FreeBSD 实际上是由世界各地成千上万人的贡献构成的，你可以从我们的[贡献者名单](https://docs.freebsd.org/en/articles/contributors/)中看出。FreeBSD 的开发基础设施能让这些成千上万的贡献者通过互联网进行合作。我们不断寻找新的志愿者，想要更密切参与的人可以查阅文章[为 FreeBSD 贡献](https://docs.freebsd.org/en/articles/contributing/)。

无论是独立工作还是紧密合作，有关 FreeBSD 项目及其开发过程的一些有用信息：

**Git 存储库**  

多年来，FreeBSD 的中央源代码树由 [CVS](https://www.nongnu.org/cvs/)（Concurrent Versions System，并发版本系统）维护，这是一款可自由获取的源代码控制工具。2008 年 6 月，FreeBSD 项目切换至使用 [SVN](https://subversion.apache.org/)（Subversion）。之所以进行这次切换，是因为 CVS 施加的技术限制在源代码树的快速扩展和已存历史量面前变得愈加明显。文档项目和 Ports 的存储库分别于 2012 年 5 月、2012 年 7 月从 CVS 迁移到了 SVN。2020 年 12 月，FreeBSD 项目将源代码和文档存储库[迁移](https://www.freebsd.org/status/report-2020-10-2020-12.html#Git-Migration-Working-Group)至 [Git](https://git-scm.com/)，而 [Ports](https://www.freebsd.org/status/report-2021-04-2021-06/#_git_migration_working_group) 也于 2021 年 4 月进行了上述迁移。更多有关获取 FreeBSD `src/` 存储库的信息，请参阅[获取源代码](https://docs.freebsd.org/en/books/handbook/cutting-edge/#synching)部分，有关获取 FreeBSD Ports 的详细信息，请参阅[使用 Ports](https://docs.freebsd.org/en/books/handbook/ports/#ports-using)。

**提交者（committer）名单** 

*提交者* 是指具有 *推送* 权限的人员，他们被授权对 FreeBSD 源代码进行修改（“提交者”（committer）一词源于 `commit`，即用于将新更改引入仓库的源代码控制命令）。所有人都可以向 [Bug数据库](https://bugs.freebsd.org/submit/)提交错误。在提交错误报告之前，可以使用 FreeBSD 邮件列表、IRC 频道和论坛帮助验证某个问题是否的确是个 Bug。

**FreeBSD 核心团队**  

如果 FreeBSD 项目是一家公司，*FreeBSD 核心团队* 相当于公司的董事会。核心团队的主要任务是确保 FreeBSD 项目整体运行良好，并朝着正确的方向发展。招募专注且负责的开发者加入我们的提交者团队是核心团队的职能之一。此外，核心团队还负责招募新的核心团队成员，以替代离任的成员。当前核心团队于 2024 年 5 月和 6 月从提交者候选人中选举产生。选举每两年举行一次。

>**注意**
>
>同大多数开发者一样，在 FreeBSD 开发方面，核心团队的成员也大都是志愿者，并未从 FreeBSD 项目中获利，因此“承诺”也不应被误解为“有保障的支持”。上面提到的“董事会”类比并不十分准确，也许更恰当的说法是：这些人是在违背自己最佳利益的情况下，放弃了个人生活，投身于 FreeBSD 事业！

**FreeBSD 基金会**  

[FreeBSD 基金会](https://freebsdfoundation.org/)是美国的一家 501(c)(3) 的非营利组织，致力于支持和促进 FreeBSD 项目及其全球社区。基金会通过项目资助支持软件开发，并提供人员以实时响应紧急问题和实现新特性和功能。基金会购买硬件以改善和维护 FreeBSD 基础设施，并资助人员以提升测试覆盖率、持续集成和自动化。基金会通过在全球技术会议和活动中推广 FreeBSD 来推动 FreeBSD。基金会还提供研讨会、教育材料和演示，以吸引更多用户和贡献者加入 FreeBSD。基金会还代表 FreeBSD 项目执行合同、许可证协议及其他需要认可法律实体的法律事务。

**外部贡献者**  

最后但绝不是最不重要的，最大的开发者群体是用户本身，他们几乎不断地向我们提供反馈和错误修复。同 FreeBSD 基本系统开发保持联系的主要方式是订阅 [FreeBSD 技术讨论邮件列表](https://lists.freebsd.org/subscription/freebsd-hackers)，在这里讨论这些内容。对于移植第三方应用程序，你可以访问 [FreeBSD Ports 邮件列表](https://lists.freebsd.org/subscription/freebsd-ports)。关于文档的内容请参考 [FreeBSD 文档项目邮件列表](https://lists.freebsd.org/subscription/freebsd-doc)。有关各种 FreeBSD 邮件列表的更多信息，请参见[互联网上的资源](https://docs.freebsd.org/en/books/handbook/eresources/#eresources)。

[FreeBSD 贡献者名单](https://docs.freebsd.org/en/articles/contributors/)是一个漫长却又不断增长的名单，为什么不通过[为 FreeBSD 贡献一些东西](https://docs.freebsd.org/en/articles/contributing/)来加入其中呢？开发代码并非唯一的方式！

总之，我们的开发模型是一个松散的同心圆集。中心化模型旨在方便 FreeBSD *用户*，为他们提供一种轻松跟踪单个中心代码库的方式，而不是将潜在的贡献者排除在外！我们希望呈现一个稳定的操作系统，拥有大量协调的[应用程序](https://docs.freebsd.org/en/books/handbook/ports/#ports)，用户可以轻松安装和使用——这一模型在实现此目标方面非常有效。

我们对有志于加入 FreeBSD 开发者团队的人的唯一期望是，具备与当前成员相同的奉献精神，以确保 FreeBSD 项目的继续取得成功！

## 1.3.4 第三方程序

除了基础发行版，FreeBSD 还提供了一个移植的软件集，包含数千款常见程序。Port 列表涉及从 HTTP 服务器到游戏、语言、编辑器以及几乎所有其他类型的软件。大约有 36000 个 Port；整个 Ports 约占 3 GB 的空间。要编译一个 Port，只需切换到你希望安装的程序目录，输入 `make install`，然后让系统完成其余的工作。可动态检索构建每个 Port 所需的完整原始发行文件，因此你只需要有足够的磁盘空间来构建所需的 Port 就可以了。

每个 Port 几乎也同时提供了预编译的“软件包”，那些不想从源代码自己编译 Port 的人可以通过简单的命令（`pkg install`）进行安装。更多有关软件包和 Ports 的信息，请参见[安装应用程序：软件包和 Ports](https://docs.freebsd.org/en/books/handbook/ports/#ports)。

## 1.3.5 其他文档

所有受支持的 FreeBSD 版本在安装程序中提供了选项，可在初始系统设置期间安装位于 `/usr/local/share/doc/freebsd` 下的其他文档。也可以在后期通过软件包安装文档：

```sh
# pkg install en-freebsd-doc
```

对于本地化版本，请将“en”替换为所选语言的前缀。请注意，某些本地化版本可能已经过时，并可能包含不再正确或相关的信息。你可以使用以下链接通过网页浏览器查看本地安装的手册：

**FreeBSD 手册**

`/usr/local/share/doc/freebsd/en/books/handbook/handbook_en.pdf`

**FreeBSD 常见问题解答**

`/usr/local/share/doc/freebsd/en/books/faq/faq_en.pdf`

你可以随时在[文档网站](https://docs.freebsd.org/)找到最新的文档。

所有商标均为各自所有者的财产。
