# 10.2.为什么要构建定制内核

传统上，FreeBSD 使用一个单 olithic 内核。内核是一个庞大的程序，支持固定的设备列表，并且要更改内核的行为，必须编译然后重启到一个新的内核中。

今天，FreeBSD 内核中的大部分功能都包含在模块中，这些模块可以根据需要动态加载和卸载。这使运行中的内核可以立即适应新的硬件，并将新功能引入内核。这被称为模块化内核。

偶尔仍然需要执行静态内核配置。有时，所需的功能与内核紧密相关，无法动态加载。一些安全环境阻止加载和卸载内核模块，并要求只需将所需功能静态编译到内核中。

为高级 BSD 用户构建自定义内核通常是一种仪式性行为。虽然这个过程很耗时，但可以为 FreeBSD 系统带来好处。与必须支持各种硬件的 GENERIC 内核不同，自定义内核可以精简到仅支持该计算机的硬件。这有许多好处，例如:

* 引导时间更快。由于内核仅探测系统中的硬件，系统启动所需的时间可以减少。
* 更低的内存使用率。自定义内核通常通过省略未使用的功能和设备驱动程序，比 GENERIC 内核使用更少的内存。这一点非常重要，因为内核代码始终驻留在物理内存中，防止该内存被应用程序使用。因此，在具有少量 RAM 的系统上，自定义内核非常有用。
* 附加硬件支持。自定义内核可以为不存在于 GENERIC 内核中的设备添加支持。

构建自定义内核之前，请考虑这样做的原因。如果需要特定硬件支持，可能已存在为模块。

内核模块存在于 /boot/kernel 中，并可以使用 kldload(8) 动态加载到运行的内核中。大多数内核驱动程序均具有可加载模块和手册页。例如，ath(4) 无线网络驱动程序在其手册页中具有以下信息：

```
Alternatively, to load the driver as a module at boot time, place the
following line in loader.conf(5):

    if_ath_load="YES"
```

将 if_ath_load="YES" 添加到 /boot/loader.conf 将在启动时动态加载此模块。

在某些情况下，在/boot/kernel 中没有关联的模块。这在某些子系统中大多是真实的。
