# 10.3.浏览系统硬件


在编辑内核配置文件之前，建议对计算机的硬件进行清查。在双启动系统上，清查可以从其他操作系统中创建。例如，Microsoft®的设备管理器包含了安装设备的信息。

|  | 一些版本的 Microsoft® Windows® 具有可以用来访问设备管理器的系统图标。|
| -- | ------------------------------------------------------------------------- |

如果 FreeBSD 是唯一安装的操作系统，请使用 dmesg(8) 来确定在引导探测期间找到并列出的硬件。FreeBSD 上的大多数设备驱动程序都有一个手册页面，列出了该驱动程序支持的硬件。例如，以下行指示 psm(4) 驱动程序找到了鼠标。

```
psm0: <PS/2 Mouse> irq 12 on atkbdc0
psm0: [GIANT-LOCKED]
psm0: [ITHREAD]
psm0: model Generic PS/2 mouse, device ID 0
```

由于存在这些硬件，因此不应该从自定义内核配置文件中删除此驱动程序。

如果 dmesg 的输出未显示引导探测输出的结果，请读取/var/run/dmesg.boot 的内容。

查找硬件的另一种工具是 pciconf(8)，它提供更详细的输出。例如：

```
% pciconf -lv
ath0@pci0:3:0:0:        class=0x020000 card=0x058a1014 chip=0x1014168c rev=0x01 hdr=0x00
    vendor     = 'Atheros Communications Inc.'
    device     = 'AR5212 Atheros AR5212 802.11abg wireless'
    class      = network
    subclass   = ethernet
```

此输出显示 ath 驱动程序找到了一个无线以太网设备。

人(1)手册的 -k 标志可用于提供有用的信息。例如，它可以用于显示包含特定设备品牌或名称的手册页列表：

```
# man -k Atheros
ath(4)                   - Atheros IEEE 802.11 wireless network driver
ath_hal(4)               - Atheros Hardware Access Layer (HAL)
```

创建硬件清单后，参考它以确保在编辑自定义内核配置时不要删除已安装硬件的驱动程序。
