# 10.4.配置文件


为了创建自定义内核配置文件并构建自定义内核，必须首先安装完整的 FreeBSD 源代码树。

如果 /usr/src/ 不存在或为空，则源代码未安装。可以使用 Git 按照“使用 Git”中的说明安装源代码。

安装源代码后，请查看 /usr/src/sys 目录的内容。该目录包含许多子目录，包括代表以下支持的架构的目录：amd64、i386、powerpc 和 sparc64。每个支持的架构都有一个包含该架构的 GENERIC 内核配置文件的 conf 子目录。

请勿对 GENERIC 进行编辑。而是将文件复制到不同的名称并对副本进行编辑。约定使用全大写字母命名。在维护具有不同硬件的多个 FreeBSD 机器时，将其命名为主机名是个好主意。该示例创建了一个名为 MYKERNEL 的 GENERIC 配置文件的副本，该配置文件适用于 amd64 架构。

```
# cd /usr/src/sys/amd64/conf
# cp GENERIC MYKERNEL
```

MYKERNEL 现在可以使用任何 ASCII 文本编辑器进行自定义。默认编辑器是 vi，不过 FreeBSD 还安装了一款面向初学者更容易使用的编辑器，名为 ee。

内核配置文件的格式很简单。每行包含表示设备或子系统的关键字，一个参数，以及一个简短的说明。在 # 之后的任何文本都被视为注释并被忽略。要移除对设备或子系统的内核支持，请在代表该设备或子系统的行的开头放置 #。不要为你不理解的任何行添加或移除 #。

|  | 移除对设备或选项的支持并最终得到一个搞砸的内核很容易。例如，如果从内核配置文件中移除了 ata(4)驱动程序，那么使用 ATA 磁盘驱动程序的系统可能无法启动。如果有疑问，最好保留内核的支持。|
| -- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

除了本文件中提供的简要说明外，其他说明内容包含在 NOTES 中，可以在与该架构的 GENERIC 文件相同目录中找到。对于独立于架构的选项，请参考/usr/src/sys/conf/NOTES。

```
# cd /usr/src/sys/amd64/conf
# mkdir /root/kernels
# cp GENERIC /root/kernels/MYKERNEL
# ln -s /root/kernels/MYKERNEL
```

配置文件中可用 include 指令。这能让将另一个配置文件包含在当前文件中，从而便于维护相对于现有文件的小更改。如果只需要一小部分额外的选项或驱动程序，则可以保持与 GENERIC 的增量，就像这个示例中所示：

```
include GENERIC
ident MYKERNEL

options         IPFIREWALL
options         DUMMYNET
options         IPFIREWALL_DEFAULT_TO_ACCEPT
options         IPDIVERT
```

使用此方法，本地配置文件表达了与 GENERIC 内核的本地差异。随着升级的进行，将会向本地内核添加到 GENERIC 中添加的新功能，除非使用 nooptions 或 nodevice 明确阻止。可以在 config(5)中找到配置指令及其说明的详尽列表。

```
# cd /usr/src/sys/arch/conf && make LINT
```
