# 10.5.构建并安装定制内核

保存自定义配置文件的编辑后，就可以使用以下步骤编译内核的源代码：

**过程：构建内核**

1. 切换到这个目录：

    ```
    # cd /usr/src
    ```
2. 通过指定自定义内核配置文件的名称来编译新内核：

    ```
    # make buildkernel KERNCONF=MYKERNEL
    ```
3. 安装与指定内核配置文件相关联的新内核。此命令将新内核复制到/boot/kernel/kernel，并将旧内核保存到/boot/kernel.old/kernel。

    ```
    # make installkernel KERNCONF=MYKERNEL
    ```
4. 关闭系统并重启到新内核。如果出现问题，请参考内核无法启动。

默认情况下，编译自定义内核时，所有内核模块都将被重新构建。为了更快地更新内核或仅构建自定义模块，请在开始构建内核之前编辑/etc/make.conf。

例如，此变量指定要构建的模块列表，而不使用构建所有模块的默认设置：

```
MODULES_OVERRIDE = linux acpi
```

或者，此变量列出要从构建过程中排除的模块：

```
WITHOUT_MODULES = linux acpi sound
```

有其他可用的变量。有关详情，请参阅 make.conf(5)。
