# 10.6.如果发生了错误

构建自定义内核时可能出现的四种故障分类：

  config 失败

如果 config 失败，它将打印出不正确的行号。例如，对于以下消息，请确保第 17 行通过将其与 GENERIC 或 NOTES 进行比较而正确输入：

```
config: line 17: syntax error
```

  make 失败

如果 make 失败，通常是由于内核配置文件中的错误，这种错误不严重到足以被 config 捕捉到。检查配置，如果问题不明显，请发送电子邮件到 FreeBSD 常见问题邮件列表中，其中包含内核配置文件。

内核无法启动

如果新内核无法启动或无法识别设备，请不要惊慌！幸运的是，FreeBSD 有一个出色的机制来从不兼容的内核中恢复。只需在 FreeBSD 引导加载程序中选择要启动的内核即可。当系统引导菜单出现时，可以通过选择“转到加载程序提示”选项来访问这个功能。在提示符下，键入 boot<span> </span><em>kernel.old</em>，或任何其他已知可以正确启动的内核的名称。

启动后，使用良好的内核，检查配置文件并尝试重新构建。一个有用的资源是/var/log/messages，它记录了每次成功启动的内核消息。此外，dmesg(8)将打印当前启动的内核消息。

```
# mv /boot/kernel /boot/kernel.bad
# mv /boot/kernel.good /boot/kernel
```

**内核可以工作，但是 ps(1)不行**

如果内核版本与系统实用程序构建的版本不同，例如，在-RELEASE 系统上安装了从-CURRENT 源构建的内核，许多系统状态命令如 ps(1)和 vmstat(8)将无法工作。要解决此问题，请使用与内核相同版本的源树重新编译和安装 world。使用与操作系统的其余部分不同版本的内核绝非明智之举。
