# 11.2.连接打印机

打印机以各种方式连接到计算机系统。小型台式打印机通常直接连接到计算机的 USB port。较旧的打印机连接到并行或“打印机”port。一些打印机直接连接到网络，使多台计算机可以共享它们。少数打印机使用罕见的串行port连接。

FreeBSD 可以与所有这些类型的打印机通信。

`USB`

USB 打印机可以连接到计算机上的任何可用 USB port。

当 FreeBSD 检测到 USB 打印机时，将创建两个设备条目：/dev/ulpt0 和/dev/unlpt0。发送到任一设备的数据将中继到打印机。每次打印作业后，ulpt0 会重置 USB port。重置port可能会对某些打印机造成问题，因此通常使用 unlpt0 设备。unlpt0 根本不会重置 USB port。

 平行 ( IEEE -1284)

平行 port 设备是 /dev/lpt0。无论是否连接打印机，此设备都会出现，并不会自动检测。

各厂商在很大程度上已经放弃了这些 “传统” ports，许多计算机不再配备这些端口。可以使用适配器将并行打印机连接到一台 USB port。有了这样的适配器，可以将打印机视为实际上是 USB 打印机。打印服务器这样的设备也可以用于直接将并行打印机连接到网络。

 串行（RS-232）

串行 ports 是另一种遗留的 port，在打印机中很少使用，除非在某些特定的利基应用中。电缆、连接器和所需的布线差异很大。

对于集成在主板上的串行 ports，串行设备名称为 /dev/cuau0 或 /dev/cuau1。串行 USB 适配器也可以使用，这些将显示为 /dev/cuaU0。

与串行打印机通信必须了解几个通信参数。最重要的是波特率或 BPS （每秒位数）和奇偶校验。值有所变化，但典型的串行打印机使用波特率为 9600，无奇偶校验。

 网络

网络打印机直接连接到本地计算机网络。

打印机的 DNS 主机名必须是已知的。如果打印机由 DHCP 分配动态地址，则应动态更新，以便主机名始终具有正确的 IP 地址。网络打印机通常被分配静态 IP 地址以避免此问题。

大多数网络打印机都能理解使用 LPD 协议发送的打印作业。还可以指定打印队列名称。某些打印机根据使用的队列对数据进行不同处理。例如，raw 队列打印未更改的数据，而 text 队列向普通文本添加换行符。

许多网络打印机还可以打印直接发送到port 9100 的数据。

### 11.2.1. 总结

有线网络连接通常是最容易设置并具有最快的打印速度。对于直接连接到计算机，首选 USB 以实现速度和简单性。并行连接可以工作，但在电缆长度和速度上有限制。串行连接更难配置。不同型号间的电缆布线不同，通信参数如波特率和奇偶校验位必须增加复杂性。幸运的是，串行打印机较为罕见。
