# 11.3.常见的页面描述语言（PDL）

发送到打印机的数据必须是打印机能够理解的语言。这些语言被称为页面描述语言，或 PDL。

ASCII 普通 ASCII 文本是将数据发送到打印机的最简单方式。字符与将要打印的内容一一对应：数据中的 A 打印在页面上的 A 上。几乎没有可用的格式。无法选择字体或等宽间距。普通 ASCII 的强制简单性意味着文本可以直接从计算机打印出来，几乎不需要编码或翻译。打印输出直接对应于发送的内容。

一些廉价的打印机无法打印普通 ASCII 文本。这使得它们更难设置，但通常仍然可能。

PostScript®PostScript®几乎与 ASCII 完全相反。与简单文本不同，PostScript® 程序是绘制最终文档的一组指令。可以使用不同的字体和图形。然而，这种功能付出了代价。绘制页面的程序必须被编写。通常这个程序是由应用软件生成的，所以这个过程对用户来说是不可见的。

廉价的打印机有时会省略 PostScript®兼容性，以节省成本。

PCL （打印机命令语言） PCL 是 ASCII 的扩展，添加了用于格式化、字体选择和打印图形的转义序列。许多打印机提供 PCL5 支持。一些支持更新的 PCL6 或 PCLXL。这些较新的版本是 PCL5 的超集，可以提供更快速的打印。

基于主机制造商可以通过给打印机配备简单处理器和很少的内存来降低成本。这些打印机无法打印纯文本。相反，主机上的驱动程序会绘制文本和图形的位图，然后将其发送到打印机。这些被称为基于主机的打印机。

驱动程序和基于主机的打印机之间的通信通常通过专有或未记录的协议进行，使它们只能在最常见的操作系统上运行。

### 11.3.1. 将 PostScript®转换为其他 PDL

Ports 和 FreeBSD 实用程序中的许多应用程序生成 PostScript®输出。此表显示可用于将其转换为其他常见 PDL 的实用程序：

输出 PDLs

| 输出 PDL      | 由生成 | 笔记                                                   |
| --------------- | -------- | -------------------------------------------------------- |
| PCL 或 PCL5   | [ 打印/ghostscript9-base](https://cgit.freebsd.org/ports/tree/print/ghostscript9-base/)       | -sDEVICE=ljet4 对于单色，-sDEVICE=cljet5 对于彩色     |
| PCLXL 或 PCL6 | [ 打印/ghostscript9-base](https://cgit.freebsd.org/ports/tree/print/ghostscript9-base/)       | -sDEVICE=pxlmono 用于单色，-sDEVICE=pxlcolor 用于彩色 |
| `ESC/P2`              | [ 打印/ghostscript9-base](https://cgit.freebsd.org/ports/tree/print/ghostscript9-base/)       | `-sDEVICE=uniprint`                                                       |
| `XQX`              | [ 打印/foo2zjs](https://cgit.freebsd.org/ports/tree/print/foo2zjs/)       |                                                        |

### 11.3.2。摘要

为了实现最简单的打印，选择支持 PostScript® 的打印机。支持 PCL 的打印机是下一个首选项。使用 print/ghostscript9-base，这些打印机可以被用作如果它们本身就理解 PostScript® 一样。几乎所有支持 PostScript® 或 PCL 的打印机也几乎总是支持直接打印纯 ASCII 文本文件。

基于行的打印机，如典型的喷墨打印机通常不支持 PostScript® 或 PCL。它们通常可以打印纯 ASCII 文本文件。print/ghostscript9-base 支持一些这些打印机使用的 PDL。然而，在这些打印机上打印整个基于图形的页面通常非常慢，因为需要传输和打印大量数据。

基于主机的打印机通常更难设置。有些由于专有的 PDL 而根本无法使用。尽量避免使用这些打印机。可以在 http://www.openprinting.org/printers 找到各种型号打印机使用的特定 PDL。
