# 11.5.LPD（行式打印机程序）

在后台打印文件被称为做打印输出. 一个打印输出服务程序能让用户在电脑上继续进行其他程序而无需等待打印机慢慢地完成打印工作。

FreeBSD 包括一个名为 lpd（8）的打印机处理程序。使用 lpr（1）提交打印作业。

### 11.5.1. 初始设置

创建一个用于存储打印作业的目录，设置所有者，并设置权限以防止其他用户查看这些文件的内容：

```
# mkdir -p /var/spool/lpd/lp
# chown daemon:daemon /var/spool/lpd/lp
# chmod 770 /var/spool/lpd/lp
```

打印机定义在 /etc/printcap 中。每台打印机的条目包括名称、port 连接的位置以及各种其他设置。使用这些内容创建 /etc/printcap 文件：

```
lp:\
	:lp=/dev/unlpt0:\
	:sh:\
	:mx#0:\
	:sd=/var/spool/lpd/lp:\
	:lf=/var/log/lpd-errs:
```

|  | 此打印机的名称。lpr(1) 将打印任务发送到 lp 打印机，除非使用 -P 指定了其他打印机，因此默认打印机应命名为 lp。|
| -- | --------------------------------------------------------------------------------------------------------------- |
|  | 打印机连接的设备。将此行替换为适合连接类型的相应行。                                           |
|  | 在打印工作开始时不打印标题页。                                                                 |
|  | 不限制打印工作的最大大小。                                                                     |
|  | 为该打印机设置的暂存目录路径。每台打印机都使用自己的暂存目录。                                 |
|  | 此打印机上报错误的日志文件。                                                                   |

创建/etc/printcap 后，使用 chkprintcap(8)检查是否有错误：

```
# chkprintcap
```

在继续之前解决所有报告的问题。

启用在 /etc/rc.conf 中的 lpd(8)：

```
lpd_enable="YES"
```

 启动服务：

```
# service lpd start
```

### 11.5.2. 使用 lpr(1) 打印

将文件发送到打印机使用 lpr。要打印的文件可以在命令行上命名，也可以通过管道发送到 lpr。这两个命令是等效的，将 doc.txt 的内容发送到默认打印机:

```
% lpr doc.txt
% cat doc.txt | lpr
```

打印机可以使用 -P 选择。要打印到名为 laser 的打印机:

```
% lpr -Plaser doc.txt
```

### 11.5.3. 过滤器

到目前为止所展示的示例已经直接发送文本文件的内容到打印机。只要打印机理解这些文件的内容，输出就会正确打印。

一些打印机无法打印纯文本，输入文件甚至可能不是纯文本。

过滤器能让文件被翻译或处理。典型用途是把一种类型的输入，比如纯文本，翻译成打印机能理解的形式，比如 PostScript®或 PCL。过滤器还可以用来提供额外功能，比如添加页码或突出显示源代码，使其更易于阅读。

这里讨论的过滤器是输入过滤器或文本过滤器。这些过滤器将传入的文件转换为不同的形式。在创建文件之前，请使用 su(1)成为 root。

过滤器在/etc/printcap 中指定了 if= 标识符。要将/usr/local/libexec/lf2crlf 用作过滤器，请像这样修改/etc/printcap：

```
lp:\
	:lp=/dev/unlpt0:\
	:sh:\
	:mx#0:\
	:sd=/var/spool/lpd/lp:\
	:if=/usr/local/libexec/lf2crlf:\   
	:lf=/var/log/lpd-errs:
```

|  | if= 标识要在传入文本上使用的输入过滤器。|
| -- | ------------------------------------------ |

```
lp:lp=/dev/unlpt0:sh:mx#0:sd=/var/spool/lpd/lp:if=/usr/local/libexec/lf2crlf:lf=/var/log/lpd-errs:
```

#### 11.5.3.1. 在普通文本打印机上防止台阶效应

典型的 FreeBSD 文本文件每行仅包含一个换行符。这些行将在标准打印机上“台阶”：

```
A printed file looks
                    like the steps of a staircase
                                                 scattered by the wind
```

一个过滤器可以将换行符转换为回车和换行符。回车使打印机在每行结束后返回到左侧。创建/usr/local/libexec/lf2crlf，内容如下:

```
#!/bin/sh
CR=$'\r'
/usr/bin/sed -e "s/$/${CR}/g"
```

设置权限并将其设为可执行:

```
# chmod 555 /usr/local/libexec/lf2crlf
```

修改/etc/printcap 以使用新过滤器:

```
:if=/usr/local/libexec/lf2crlf:\
```

通过打印相同的纯文本文件来测试过滤器。回车将导致每行从页面的左侧开始。

#### 11.5.3.2. 在 PostScript® 打印机上使用漂亮的纯文本与 print/enscript

GNUEnscript 可将纯文本文件转换为格式良好的 PostScript®，以便在 PostScript® 打印机上打印。它会添加页码，换行长行，并提供许多其他功能，使打印的文本文件更容易阅读。根据本地纸张大小，从 Ports 安装 print/enscript-letter 或 print/enscript-a4。

使用以下内容创建 /usr/local/libexec/enscript:

```
#!/bin/sh
/usr/local/bin/enscript -o -
```

设置权限并使其可执行:

```
# chmod 555 /usr/local/libexec/enscript
```

修改 /etc/printcap 以使用新的过滤器:

```
:if=/usr/local/libexec/enscript:\
```

通过打印纯文本文件来测试过滤器。

#### 11.5.3.3. 打印 PostScript® 到 PCL 打印机

许多程序生成 PostScript® 文档。然而，廉价的打印机通常只能理解纯文本或 PCL。该过滤器在将 PostScript® 文件发送到打印机之前将其转换为 PCL。

从 Ports 安装 Ghostscript PostScript® 解释器，print/ghostscript9-base。

使用这些内容创建 /usr/local/libexec/ps2pcl：

```
#!/bin/sh
/usr/local/bin/gs -dSAFER -dNOPAUSE -dBATCH -q -sDEVICE=ljet4 -sOutputFile=- -
```

设置权限并使其可执行：

```
# chmod 555 /usr/local/libexec/ps2pcl
```

发送到此脚本的 PostScript®输入将在发送到打印机之前呈现并转换为 PCL。

修改 /etc/printcap 以使用此新输入过滤器：

```
:if=/usr/local/libexec/ps2pcl:\
```

通过向其发送一个小的 PostScript® 程序来测试该过滤器：

```
% printf "%%\!PS \n /Helvetica findfont 18 scalefont setfont \
72 432 moveto (PostScript printing successful.) show showpage \004" | lpr
```

#### 11.5.3.4. 智能过滤器

一个检测输入类型并自动将其转换为打印机正确格式的过滤器可能非常方便。PostScript®文件的前两个字符通常是 %!。过滤器可以检测这两个字符。可以将 PostScript®文件发送到 PostScript®打印机而不改变。文本文件可以使用之前显示的 Enscript 转换为 PostScript®。使用以下内容创建/usr/local/libexec/psif：

```
#!/bin/sh
#
#  psif - Print PostScript or plain text on a PostScript printer
#
IFS="" read -r first_line
first_two_chars=`expr "$first_line" : '\(..\)'`

case "$first_two_chars" in
%!)
    # %! : PostScript job, print it.
    echo "$first_line" && cat && exit 0
    exit 2
    ;;
*)
    # otherwise, format with enscript
    ( echo "$first_line"; cat ) | /usr/local/bin/enscript -o - && exit 0
    exit 2
    ;;
esac
```

设置权限并使其可执行：

```
# chmod 555 /usr/local/libexec/psif
```

修改/etc/printcap 以使用此新输入过滤器：

```
:if=/usr/local/libexec/psif:\
```

通过打印 PostScript® 和纯文本文件来测试过滤器。

### 11.5.4. 多个队列

/etc/printcap 中的条目实际上是队列的定义。对于单个打印机可以有多个队列。与过滤器结合使用时，多个队列让用户可以更好地控制其作业的打印方式。

作为一个例子，考虑办公室里的一个联网的 PostScript® 激光打印机。大多数用户想要打印纯文本，但是一些高级用户想要能够直接打印 PostScript® 文件。可以在 /etc/printcap 中为同一台打印机创建两个条目：

```
textprinter:\
	:lp=9100@officelaser:\
	:sh:\
	:mx#0:\
	:sd=/var/spool/lpd/textprinter:\
	:if=/usr/local/libexec/enscript:\
	:lf=/var/log/lpd-errs:

psprinter:\
	:lp=9100@officelaser:\
	:sh:\
	:mx#0:\
	:sd=/var/spool/lpd/psprinter:\
	:lf=/var/log/lpd-errs:
```

发送到 textprinter 的文档将由前面示例中显示的 /usr/local/libexec/enscript 过滤器格式化。高级用户可以在 psprinter 上打印 PostScript® 文件，那里不做任何过滤。

这种多队列技术可用于提供对各种打印机功能的直接访问。具有双面打印功能的打印机可以使用两个队列，一个用于普通单面打印，另一个带有一个过滤器，发送命令序列以启用双面打印，然后发送传入文件。

### 11.5.5. 监控和控制打印

有几个实用程序可用于监视打印作业并检查和控制打印机操作。

#### 11.5.5.1. [lpq(1)](https://man.freebsd.org/cgi/man.cgi?query=lpq&sektion=1&format=html)

lpq(1) 显示用户的打印作业状态。不显示其他用户的打印作业。

在单个打印机上显示当前用户的待处理作业：

```
% lpq -Plp
Rank   Owner      Job  Files                                 Total Size
1st    jsmith     0    (standard input)                      12792 bytes
```

在所有打印机上显示当前用户的待处理作业：

```
% lpq -a
lp:
Rank   Owner      Job  Files                                 Total Size
1st    jsmith     1    (standard input)                      27320 bytes

laser:
Rank   Owner      Job  Files                                 Total Size
1st    jsmith     287  (standard input)                      22443 bytes
```

#### 11.5.5.2. lprm(1) 是用于删除打印任务的。普通用户只能删除自己的任务。{{0}} 可以删除任何或所有任务。

lprm(1) 用于删除打印任务。普通用户只能删除自己的任务。root 可以删除任何或所有任务。

从打印机中删除所有待处理任务：

```
# lprm -Plp -
dfA002smithy dequeued
cfA002smithy dequeued
dfA003smithy dequeued
cfA003smithy dequeued
dfA004smithy dequeued
cfA004smithy dequeued
```

从打印机中删除单个作业。lpq(1) 用于查找作业编号。

```
% lpq
Rank   Owner      Job  Files                                 Total Size
1st    jsmith     5    (standard input)                      12188 bytes

% lprm -Plp 5
dfA005smithy dequeued
cfA005smithy dequeued
```

#### 11.5.5.3. [lpc(8)](https://man.freebsd.org/cgi/man.cgi?query=lpc&sektion=8&format=html)

lpc(8) 用于检查和修改打印机状态。lpc 后跟命令和可选的打印机名称。可以使用 all 而不是特定的打印机名称，并且命令将应用于所有打印机。普通用户可以使用 lpc(8) 查看状态。只有 root 可以使用修改打印机状态的命令。

显示所有打印机的状态：

```
% lpc status all
lp:
	queuing is enabled
	printing is enabled
	1 entry in spool area
	printer idle
laser:
	queuing is enabled
	printing is enabled
	1 entry in spool area
	waiting for laser to come up
```

阻止打印机接受新作业，然后再次开始接受新作业：

```
# lpc disable lp
lp:
	queuing disabled
# lpc enable lp
lp:
	queuing enabled
```

停止打印，但继续接受新作业。然后再次开始打印：

```
# lpc stop lp
lp:
	printing disabled
# lpc start lp
lp:
	printing enabled
	daemon started
```

在某些错误情况之后重启打印机：

```
# lpc restart lp
lp:
	no daemon to abort
	printing enabled
	daemon restarted
```

关闭打印队列并禁用打印，附带消息向用户解释问题：

```
# lpc down lp Repair parts will arrive on Monday
lp:
	printer and queuing disabled
	status message is now: Repair parts will arrive on Monday
```

重新启用处于停机状态的打印机：

```
# lpc up lp
lp:
	printing enabled
	daemon started
```

有关更多命令和选项，请参阅 lpc(8)。

### 11.5.6. 共享打印机

打印机通常由企业和学校的多个用户共享。提供了附加功能，使共享打印机更加方便。

#### 11.5.6.1. 别名

打印机名称设置在 /etc/printcap 条目的第一行。其他名称或别名可以在该名称之后添加。别名通过竖线分隔，与名称和其他别名区分开：

```
lp|repairsprinter|salesprinter:\
```

别名可用于代替打印机名称。例如，销售部门的用户可以通过以下方式打印到他们的打印机

```
% lpr -Psalesprinter sales-report.txt
```

维修部门的用户可以打印到他们的打印机上

```
% lpr -Prepairsprinter repairs-report.txt
```

所有文件都打印在那台单打印机上。当销售部门扩大到需要自己的打印机时，可以从共享打印机条目中移除别名，并用作新打印机的名称。两个部门的用户继续使用相同的命令，但销售部门的文件被发送到新的打印机。

#### 11.5.6.2. 页眉页面

用户在繁忙的共享打印机生成的页面堆栈中定位其文件可能很困难。页眉页面被创建来解决这个问题。每个打印作业之前打印一个带有用户姓名和文档名称的页眉页。有时也称这些页为横幅页或分隔页。

启用页眉页面的方法各不相同，具体取决于打印机是直接连接到计算机，使用 USB，并行线缆，串行线缆，还是通过网络远程连接。

直接连接打印机上的页眉页面是通过从 /etc/printcap 中的条目中删除 :sh:\ （Suppress Header）行来启用的。这些页眉页面只使用换行字符进行换行。一些打印机需要使用 /usr/share/examples/printing/hpif 过滤器来防止文本成阶梯状。该过滤器配置 PCL 打印机在接收到换行时同时打印回车和换行。

网络打印机的页眉页脚必须在打印机本身上配置。/etc/printcap 中的页眉页脚条目将被忽略。通常可以通过打印机前面板或使用 Web 浏览器访问的配置 Web 页面来设置。

### 11.5.7. 参考资料

示例文件：/usr/share/examples/printing/。

4.3BSD 线路打印机排队器手册，/usr/share/doc/smm/07.lpd/paper.ascii.gz。

手册页面：printcap(5)，lpd(8)，lpr(1)，lpc(8)，lprm(1)，lpq(1)。
