# 12.3.Linux 用户空间

Linux 软件需要的不仅仅是 ABI。要运行 Linux 软件，首先必须安装 Linux 用户空间。

```
# pkg install linux-sublime-text4
```

### 12.3.1. 从 FreeBSD 软件包安装 CentOS 基本系统

要安装 CentOS 用户环境，请执行以下命令：

```
# pkg install linux_base-c7
```

emulators/linux_base-c7 将在/compat/linux 中放置派生自 CentOS 7 的基本系统。

安装软件包后，可以通过运行以下命令来验证 /compat/linux 的内容，以检查是否已安装 CentOS 用户空间：

```
# ls -l /compat/linux/
```

输出应类似于以下内容：

```
total 30
lrwxr-xr-x   1 root  wheel    7 Apr 11  2018 bin -> usr/bin
drwxr-xr-x  13 root  wheel  512 Apr 11 21:10 dev
drwxr-xr-x  25 root  wheel   64 Apr 11 21:10 etc
lrwxr-xr-x   1 root  wheel    7 Apr 11  2018 lib -> usr/lib
lrwxr-xr-x   1 root  wheel    9 Apr 11  2018 lib64 -> usr/lib64
drwxr-xr-x   2 root  wheel    2 Apr 11 21:10 opt
dr-xr-xr-x   1 root  wheel    0 Apr 11 21:25 proc
lrwxr-xr-x   1 root  wheel    8 Feb 18 02:10 run -> /var/run
lrwxr-xr-x   1 root  wheel    8 Apr 11  2018 sbin -> usr/sbin
drwxr-xr-x   2 root  wheel    2 Apr 11 21:10 srv
dr-xr-xr-x   1 root  wheel    0 Apr 11 21:25 sys
drwxr-xr-x   8 root  wheel    9 Apr 11 21:10 usr
drwxr-xr-x  16 root  wheel   17 Apr 11 21:10 var
```

### 12.3.2. 使用 debootstrap 安装 Debian / Ubuntu 基本系统

通过使用 sysutils/debootstrap 以另一种方式提供 Linux 共享库。这样做的优点是提供完整的 Debian 或 Ubuntu 发行版。

要安装 debootstrap，请执行以下命令：

```
# pkg install debootstrap
```

debootstrap(8) 需要启用 Linux(4) ABI。启用后，执行以下命令将在 /compat/ubuntu 中安装 Ubuntu 或 Debian。

```
# debootstrap focal /compat/ubuntu
```

|  | 尽管在 /compat/linux 中安装技术上是可能的，但由于可能与基于 CentOS 的软件包发生冲突，不建议这样做。相反，从发行版或版本名称获取目录名称，例如，/compat/ubuntu。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------- |

输出应类似于以下内容：

```
I: Retrieving InRelease
I: Checking Release signature
I: Valid Release signature (key id F6ECB3762474EDA9D21B7022871920D1991BC93C)
I: Retrieving Packages
I: Validating Packages
I: Resolving dependencies of required packages...
I: Resolving dependencies of base packages...
I: Checking component main on http://archive.ubuntu.com/ubuntu...
[...]
I: Configuring console-setup...
I: Configuring kbd...
I: Configuring ubuntu-minimal...
I: Configuring libc-bin...
I: Configuring ca-certificates...
I: Base system installed successfully.
```

然后在 /etc/fstab 中设置挂载点。

```
# Device        Mountpoint              FStype          Options                      Dump    Pass#
devfs           /compat/ubuntu/dev      devfs           rw,late                      0       0
tmpfs           /compat/ubuntu/dev/shm  tmpfs           rw,late,size=1g,mode=1777    0       0
fdescfs         /compat/ubuntu/dev/fd   fdescfs         rw,late,linrdlnk             0       0
linprocfs       /compat/ubuntu/proc     linprocfs       rw,late                      0       0
linsysfs        /compat/ubuntu/sys      linsysfs        rw,late                      0       0
/tmp            /compat/ubuntu/tmp      nullfs          rw,late                      0       0
/home           /compat/ubuntu/home     nullfs          rw,late                      0       0
```

 然后执行 mount(8)：

```
# mount -al
```

要使用 chroot(8)访问系统，请执行以下命令：

```
# chroot /compat/ubuntu /bin/bash
```

然后可以执行 uname(1)来检查 Linux 环境：

```
# uname -s -r -m
```

输出应类似于以下内容：

```
Linux 3.17.0 x86_64
```

进入 chroot，系统的行为就像在正常的 Ubuntu 安装中一样。虽然 systemd 不起作用，service(8) 命令像往常一样工作。

```
deb http://archive.ubuntu.com/ubuntu focal main universe restricted multiverse
deb http://security.ubuntu.com/ubuntu/ focal-security universe multiverse restricted main
deb http://archive.ubuntu.com/ubuntu focal-backports universe multiverse restricted main
deb http://archive.ubuntu.com/ubuntu focal-updates universe multiverse restricted main
```

对于 arm64，可以使用另一个示例：

```
deb http://ports.ubuntu.com/ubuntu-ports bionic main universe restricted multiverse
```
