# 12.4.高级主题

所有与 Linux 相关的 sysctl(8)旋钮列表可以在 linux(4)中找到。

一些应用程序需要特定的文件系统被挂载。

通常由 /etc/rc.d/linux 脚本处理，但可以通过执行以下命令在启动时禁用它：

```
sysrc linux_mounts_enable="NO"
```

由 rc 脚本挂载的文件系统在 chroots 或 jail 中的 Linux 进程中将无法工作；如有需要，请在 /etc/fstab 中配置它们：

```
devfs      /compat/linux/dev      devfs      rw,late                    0  0
tmpfs      /compat/linux/dev/shm  tmpfs      rw,late,size=1g,mode=1777  0  0
fdescfs    /compat/linux/dev/fd   fdescfs    rw,late,linrdlnk           0  0
linprocfs  /compat/linux/proc     linprocfs  rw,late                    0  0
linsysfs   /compat/linux/sys      linsysfs   rw,late                    0  0
```

由于 Linux 二进制兼容层已支持运行 32 位和 64 位 Linux 二进制文件，因此不再可能将仿真功能静态地链接到自定义内核中。

### 12.4.1. 手动安装额外的库

|  | 对于使用 debootstrap(8)创建的基本系统子目录，请改用上述说明。|
| -- | --------------------------------------------------------------- |

如果 Linux 应用程序在配置 Linux 二进制兼容性后抱怨缺少共享库，请确定 Linux 二进制文件需要哪些共享库，并手动安装它们。

从使用相同 CPU 架构的 Linux 系统，ldd 可以用于确定应用程序需要哪些共享库。

例如，要检查 linuxdoom 需要哪些共享库，请从已安装 Doom 的 Linux 系统运行以下命令：

```
% ldd linuxdoom
```

输出应类似于以下内容：

```
libXt.so.3 (DLL Jump 3.1) => /usr/X11/lib/libXt.so.3.1.0
libX11.so.3 (DLL Jump 3.1) => /usr/X11/lib/libX11.so.3.1.0
libc.so.4 (DLL Jump 4.5pl26) => /lib/libc.so.4.6.29
```

然后，将 Linux 系统中输出的最后一列中的所有文件复制到 FreeBSD 系统上的 /compat/linux。复制完成后，创建到第一列中名称的符号链接。

此示例将在 FreeBSD 系统上产生以下文件：

```
/compat/linux/usr/X11/lib/libXt.so.3.1.0
/compat/linux/usr/X11/lib/libXt.so.3 -> libXt.so.3.1.0
/compat/linux/usr/X11/lib/libX11.so.3.1.0
/compat/linux/usr/X11/lib/libX11.so.3 -> libX11.so.3.1.0
/compat/linux/lib/libc.so.4.6.29
/compat/linux/lib/libc.so.4 -> libc.so.4.6.29
```

如果 Linux 共享库的主要修订号与 ldd 输出的第一列匹配，就不需要将其复制到最后一列中命名的文件中，因为现有库应该可以正常工作。然而，如果是一个更新版本的共享库，建议复制它。旧版本可以被移除，只要符号链接指向新版本。

例如，在 FreeBSD 系统上已经存在这些库：

```
/compat/linux/lib/libc.so.4.6.27
/compat/linux/lib/libc.so.4 -> libc.so.4.6.27
```

ldd 表示二进制需要更新的版本：

```
libc.so.4 (DLL Jump 4.5pl26) -> libc.so.4.6.29
```

由于现有库仅在最后一位数字上过时一到两个版本，程序应该仍能与稍旧版本一起工作。然而，用更新版本替换现有的 libc.so 是安全的：

```
/compat/linux/lib/libc.so.4.6.29
/compat/linux/lib/libc.so.4 -> libc.so.4.6.29
```

一般来说，当在 FreeBSD 上首次安装 Linux 程序时，只有在最初几次安装时才需要寻找 Linux 二进制文件所依赖的共享库。过一段时间后，系统上将拥有足够的 Linux 共享库，能够在不需要额外操作的情况下运行新安装的 Linux 二进制文件。

### 品牌 Linux ELF 二进制文件

FreeBSD 内核使用多种方法来确定要执行的二进制文件是否是 Linux 内核：它检查 ELF 文件头中的品牌，查找已知的 ELF 解释器路径并检查 ELF 注释；最后，默认情况下，未标记的 ELF 可执行文件被假定为 Linux 内核。

如果所有这些方法都失败，尝试执行二进制文件可能会导致错误消息：

```
% ./my-linux-elf-binary
```

输出应类似于以下内容：

```
ELF binary type not known
Abort
```

使用 brandelf(1)来帮助 FreeBSD 内核区分 FreeBSD ELF 二进制文件和 Linux 二进制文件：

```
% brandelf -t Linux my-linux-elf-binary
```

### 安装 Linux 基于 RPM 的应用程序 12.4.3。

要安装 Linux 基于 RPM 的应用程序，首先安装 archivers/rpm4 软件包或port。安装完成后，root 可以使用此命令来安装.rpm 文件。

```
# cd /compat/linux
# rpm2cpio < /path/to/linux.archive.rpm | cpio -id
```

如果必要，brandelf 安装的 ELF 二进制文件。请注意，这将阻止进行清洁卸载。

### 12.4.4. 配置主机名解析器

如果 DNS 不起作用或出现此错误：

```
resolv+: "bind" is an invalid keyword resolv+:
"hosts" is an invalid keyword
```

将 /compat/linux/etc/host.conf 配置如下：

```
order hosts, bind
multi on
```

这将指定首先搜索 /etc/hosts，其次搜索 DNS。当 /compat/linux/etc/host.conf 不存在时，Linux 应用程序将使用主机系统中的 /etc/host.conf，但它们会抱怨该文件在 FreeBSD 中不存在。如果未使用 /etc/resolv.conf 配置名称服务器，则移除 bind。

### 12.4.5. 其他

如何在 Linux® 上使用二进制兼容性的更多信息可以在文章《FreeBSD 中的 Linux 模拟》中找到。
