# 13.2.WINE 概述和概念

WINE 是一个复杂的系统，所以在 FreeBSD 系统上运行它之前，值得了解它是什么以及它的工作原理。

### 13.2.1. 什么是 WINE？

正如本章概要中所述，WINE 是一种兼容层，能让 Windows®应用程序在其他操作系统上运行。理论上，这意味着这些程序应该可以在类似 FreeBSD、macOS 和 Android 的系统上运行。

当 WINE 运行 Windows®可执行文件时，会发生两件事情：

* 首先，WINE 实现了一个模拟各个版本 Windows®的环境。例如，如果一个应用程序请求访问内存等资源，WINE 有一个内存接口，从应用程序的角度看，它看起来和行为像 Windows®一样。
* 然后，应用程序就能利用了该接口，WINE 将内存空间的传入请求转换为与主机系统兼容的内容。同样地，当应用程序检索数据时，WINE 促进从主机系统获取数据并将其传递回 Windows®应用程序。

### 13.2.2. WINE 和 FreeBSD 系统

在 FreeBSD 系统上安装 WINE 将涉及一些不同的组件：

* 为任务提供 FreeBSD 应用程序，例如运行 Windows®可执行文件、配置 WINE 子系统或使用 WINE 支持编译程序。
* 大量实现 Windows®核心功能的库（例如/lib/wine/api-ms-core-memory-l1-1-1.dll.so，它是前述内存接口的一部分）。
* 一些 Windows® 可执行文件，它们是常见实用程序（比如 /lib/wine/notepad.exe.so，提供标准的 Windows® 文本编辑器）。
* 额外的 Windows® 资源，特别是字体（比如 Tahoma 字体，存储在安装根目录的 share/wine/fonts/tahoma.ttf 中）。

### 13.2.3. WINE 中的图形模式与文本模式/终端程序。

作为一个以终端实用程序为“第一等公民”的操作系统，自然会认为 WINE 将包含对文本模式程序的广泛支持。然而，Windows® 的大多数应用程序，尤其是最流行的那些，都是以图形用户界面 (GUI) 为目标设计的。因此，默认情况下，WINE 的实用程序是设计用来启动图形程序的。

然而，有三种方法可以运行这些所谓的控制台用户界面 (CUI) 程序：

* 赤裸流方式将直接将输出显示到标准输出。
* 葡萄酒控制台实用程序可与用户或 curses 后端一起使用，以利用 WINE 系统为 CUI 应用程序提供的一些增强功能。

这些方法在 WINE Wiki 中有更详细的说明。

### 13.2.4. WINE 衍生项目

WINE 本身是一个成熟的开源项目，因此它被用作更复杂解决方案的基础。

#### 13.2.4.1. 商业 WINE 实现

许多公司已经采用 WINE 并将其作为他们自己专有产品的核心（WINE 的 LGPL 许可允许这样做）。其中最著名的两个如下：

* 'CodeWeavers CrossOver'

'该解决方案提供了简化的“一键”安装文件 WINE，其中包含额外的增强和优化（尽管公司会将这些大部分贡献回流到 WINE 项目中）。CodeWeavers 的一个重点是使最流行的应用程序安装和运行流畅。'

'虽然该公司曾经推出了适用于 FreeBSD 的 CrossOver 解决方案，但似乎已经被长久地放弃了。虽然一些资源（比如专门的论坛）仍然存在，但它们已经有一段时间没有活动了。'

* Steam Proton

游戏公司 Steam 也使用 WINE 来使 Windows®游戏能够在其他系统上安装和运行。它的主要目标是基于 Linux 的系统，尽管对 macOS 也有一些支持。

虽然 Steam 没有提供原生的 FreeBSD 客户端，但可以通过 FreeBSD 的 Linux 兼容层来使用 Linux®客户端的几种选项。

#### 13.2.4.2. WINE Companion Programs

除了专有产品之外，其他项目还发布了与标准开源版本的 WINE 配套使用的应用程序。这些应用程序的目标可以是使安装更容易，也可以是提供安装流行软件的简便方法。

这些解决方案将在后面关于图形用户界面前端的部分中详细介绍，并包括以下内容：

* winetricks
* Mizutamari

### 13.2.5. WINE 的替代方案

对于 FreeBSD 用户，使用 WINE 的一些替代方法如下：

* 双引导：一个直接的选择是在所需的 Windows®应用程序上在该操作系统上本地运行。当然，这意味着退出 FreeBSD 以引导 Windows®，因此如果需要同时访问两个系统中的程序，则这种方法是不可行的。
* 虚拟机：正如在本章前面提到的那样，虚拟机（VM）是模拟完整硬件集的软件进程，可以在上面安装和运行其他操作系统（包括 Windows®）。现代工具使得虚拟机易于创建和管理，但这种方法是有代价的。主机系统的大部分资源必须分配给每个虚拟机，只要虚拟机正在运行，这些资源就无法被主机回收。一些虚拟机管理器的示例包括开源解决方案 qemu，bhyve 和 VirtualBox。有关更多详细信息，请参阅有关虚拟化的章节。
* 远程访问：与许多其他类 UNIX®系统一样，FreeBSD 可以运行各种应用程序，使用户能够远程访问 Windows®计算机并使用其程序或数据。除了诸如 xrdp 之类的客户端连接到标准 Windows®远程桌面协议之外，还可以使用其他开放源标准，如 vnc（前提是另一端存在兼容的服务器）。
