# 13.3.在 FreeBSD 上安装 WINE

可以通过 pkg 工具安装 WINE，或者通过编译port（s）安装。

### 13.3.1. WINE 先决条件

在安装 WINE 本身之前，最好先安装以下先决条件。

* 一个图形用户界面

大多数 Windows®程序都希望有一个图形用户界面。如果安装了 WINE 但没有这样的界面，其依赖项将包括 Wayland 合成器，因此将会随 WINE 一起安装 GUI。但在安装 WINE 之前，最好安装、配置和确保所选 GUI 正常工作。

* wine-gecko

Windows®操作系统在一段时间内一直预装有默认的网页浏览器：Internet Explorer。因此，一些应用程序工作的前提是系统中始终存在能够显示网页的内容。为了提供这种功能，WINE 层包含使用 Mozilla 项目的 Gecko 引擎的网页浏览器组件。当首次启动 WINE 时，它将提供下载并安装此组件的选项，并且有一些原因使用户希望这样做（这些将在后面的章节中介绍）。但他们也可以在安装 WINE 之前或与 WINE 一起安装它。

使用以下命令安装此软件包：

```
# pkg install wine-gecko
```

或者，使用以下命令编译port：

```
# cd /usr/ports/emulator/wine-gecko
# make install
```

* wine-mono

这个 port 安装了 MONO 框架，这是 Microsoft .NET 的一个开源实现。将其与 WINE 安装一起使用，将使任何使用.NET 编写的应用程序更有可能在系统上安装和运行。

要安装软件包：

```
# pkg install wine-mono
```

要从 ports 中编译：

```
# cd /usr/ports/emulator/wine-mono
# make install
```

### 通过 FreeBSD 软件包存储库安装 WINE 13.3.2

在准备工作完成后，使用以下命令通过软件包安装 WINE：

```
# pkg install wine
```

或者使用以下命令从源代码编译 WINE 子系统：

```
# cd /usr/ports/emulator/wine
# make install
```

### 13.3.3. 32 64-Bit WINE 安装的担忧

像大多数软件一样，Windows® 应用程序从旧的 32 位架构升级到 64 位。大多数最近的软件都是为 64 位操作系统编写的，尽管现代操作系统有时也可以继续运行旧的 32 位程序。FreeBSD 也不例外，在 5.x 系列中就已经支持了 64 位。

然而，使用旧软件不再默认支持是模拟器的常见用法，用户通常转向 WINE 来玩游戏和使用其他在现代硬件上无法正确运行的程序。幸运的是，FreeBSD 可以支持这三种情况：

* 在现代的 64 位计算机上并且想要运行 64 位 Windows®软件，只需安装上述部分提到的ports。操作系统将会自动安装 64 位版本。
* 或者，用户可能有一台不想继续运行其原始、现在不再受支持软件的旧 32 位计算机。他们可以安装 32 位（i386）版本的 FreeBSD，然后在上述部分安装ports。
