# 13.5.配置 WINE 安装程序

对于 WINE 是什么以及在高层次上如何运作的理解，有效地在 FreeBSD 上使用它的下一步是熟悉它的配置。接下来的几节将说明 WINE 前缀的关键概念，并说明它是如何用来控制通过 WINE 运行的应用程序行为的。

### 13.5.1. WINE 前缀

WINE 前缀是一个目录，通常位于默认位置$HOME/.wine 下方，尽管它也可以位于其他位置。前缀是一组由 wine 使用的配置和支持文件，用于配置和运行 Windows®环境中给定应用程序所需的内容。默认情况下，新的 WINE 安装在用户首次启动时会创建以下结构：

* .update-timestamp：包含文件/usr/share/wine/wine.inf 的最后修改日期。WINE 使用它来确定前缀是否过时，并在需要时自动更新。
* dosdevices/: 包含有关将 Windows® 资源映射到主机 FreeBSD 系统上的资源的信息。例如，在新安装 WINE 后，这里应该至少包含两个条目，这些条目使得可以使用 Windows® 风格的驱动器字母访问 FreeBSD 文件系统：

  * c:@: 链接到下面说明的 drive_c。
  * z:@: 链接到系统根目录。
* 模拟主要（即 C:）Windows® 系统驱动器。它包含一个目录结构和相关文件，镜像标准 Windows®系统的结构。一个新的 WINE 前缀将包含 Windows® 10 目录，如 Users 和包含操作系统本身的 Windows。此外，在前缀中安装的应用程序将位于 Program Files 或 Program Files (x86) 中，取决于它们的体系结构。
* system.reg：此注册表文件包含有关 Windows® 安装的信息，在 WINE 中是驱动器 c 中的环境。
* user.reg：此注册表文件包含了当前用户的个人配置，通过各种软件或注册表编辑器进行的设置。
* 用户 def.reg：此注册表文件是新建用户的默认配置集。

### 13.5.2. 创建和使用 WINE 前缀

虽然 WINE 会在用户的$HOME/.wine/中创建一个默认前缀，但也可以设置多个前缀。这样做有几个原因：

* 最常见的原因是根据软件的兼容性需求来模拟不同版本的 Windows®。
* 此外，常常遇到在默认环境下无法正确运行的软件，需要特殊配置。将这些软件隔离在它们自己的自定义前缀下是很有用的，这样的改动就不会影响其他应用程序。
* 同样地，将默认或“主”前缀复制到一个单独的“测试”前缀中，以评估应用程序的兼容性，可以减少损坏的几率。

从终端创建前缀需要以下命令：

```
% WINEPREFIX="/home/username/.wine-new" winecfg
```

这将运行 winecfg 程序，该程序可用于配置 wine 前缀（更多内容请参阅后面的部分）。但是，通过为 WINEPREFIX 环境变量提供一个目录路径值，如果不存在，则会在该位置创建一个新前缀。

向 wine 程序提供相同的变量也会导致选择的程序以指定的前缀运行：

```
% WINEPREFIX="/home/username/.wine-new" wine program.exe
```

### 13.5.3. 使用 winecfg 配置 WINE 前缀

如上所述，WINE 包含一个名为 winecfg 的工具，可在图形用户界面中配置前缀。它包含各种功能，详细信息请参阅以下各节。当在前缀内运行 winecfg 或在 WINEPREFIX 变量中提供前缀的位置时，它将使所选前缀配置如下各节所述。

在应用程序选项卡上进行的选择将影响“库”和“图形”选项卡中所做更改的范围，范围将局限于所选应用程序。有关更多详细信息，请参阅 WINE Wiki 中有关使用 Winecfg 的部分。

#### 13.5.3.1. 应用程序

![wine config 1](https://docs.freebsd.org/images/books/handbook/wine/wine-config-1.png)

应用程序包含控件，可以将程序与特定版本的 Windows®关联起来。在首次启动时，应用程序设置部分将包含一个条目：默认设置。这对应于所有前缀的默认配置（如禁用的“删除应用程序”按钮所示），不能删除。

但是可以通过以下流程添加其他应用程序：

1. 单击“添加应用程序”按钮。
2. 使用提供的对话框来选择所需程序的可执行文件。
3. 选择要与选定程序一起使用的 Windows® 版本。

#### 13.5.3.2. 图书馆

![wine config 2](https://docs.freebsd.org/images/books/handbook/wine/wine-config-2.png)

WINE 提供一组开源库文件作为其发行的一部分，这些文件提供与它们的 Windows®对应物相同的功能。然而，正如本章前面所述，WINE 项目始终试图跟上这些库的新更新。因此，随同 WINE 发行的版本可能缺少最新 Windows®程序所期望的功能。

但是，winecfg 使得可能指定用于内置库的覆盖项，特别是在主机 FreeBSD 安装的同一机器上有一个 Windows®版本可用的情况。对于每个要覆盖的库，请执行以下操作：

1. 打开库下拉菜单的新覆盖，并选择要替换的库。
2. 点击添加按钮。
3. 新的覆盖将出现在现有覆盖列表中，请注意括号中的本机、内置指示。
4. 单击以选择库。
5. 单击编辑按钮。
6. 使用提供的对话框选择要用于替代内置库的相应库。

确保选择一个确实是内置版本对应的文件，否则可能会出现意外行为。

#### 13.5.3.3. 图形

![wine config 3](https://docs.freebsd.org/images/books/handbook/wine/wine-config-3.png)

图形选项卡提供了一些选项，可以使通过 WINE 运行的程序在 FreeBSD 上平稳运行。

* 当窗口全屏时自动捕获鼠标。
* 允许 FreeBSD 窗口管理器装饰窗口，如它们的标题栏，用于通过 WINE 运行的程序。
* 允许窗口管理器控制通过 WINE 运行的程序的窗口，例如在它们上运行调整大小功能。
* 创建一个模拟的虚拟桌面，所有 WINE 程序将在其中运行。如果选择此项目，则可以使用桌面大小输入框指定虚拟桌面的大小。
* 为通过 WINE 运行的程序设置屏幕分辨率。

#### 13.5.3.4. 桌面集成

![wine config 4](https://docs.freebsd.org/images/books/handbook/wine/wine-config-4.png)

此选项卡能让配置以下项目：

* 用于通过 WINE 运行的程序的主题和相关视觉设置。
* WINE 子系统是否应该内部管理 MIME 类型（用于确定哪个应用程序打开特定文件类型）。
* 在 Windows® 环境中，将主机 FreeBSD 系统中的目录映射到有用的文件夹中。要更改现有的关联，请选择所需项目，然后单击浏览，然后使用提供的对话框选择一个目录。

#### 13.5.3.5. 驱动器

![wine config 5](https://docs.freebsd.org/images/books/handbook/wine/wine-config-5.png)

驱动器选项卡能让在主机 FreeBSD 系统中将目录链接到 Windows® 环境中的驱动器号。此选项卡中的默认值应该看起来很熟悉，因为它们显示的是当前 WINE 前缀中 dosdevices/ 目录的内容。通过此对话框所做的更改将反映在 dosdevices 中，并且在该目录中创建的格式正确的链接将显示在此选项卡中。

创建新条目（例如 CD-ROM（挂载于 /mnt/cdrom），请执行以下步骤：

1. 单击“添加”按钮。
2. 在提供的对话框中选择一个空闲的驱动器号。
3. 单击确定。
4. 通过输入资源路径或单击“浏览”并使用提供的对话框来填写路径输入框。

WINE 默认会自动检测所链接资源的类型，但也可以手动覆盖。查看 WINE Wiki 中关于高级选项的部分以获取更多详细信息。

#### 13.5.3.6. 音频

![wine config 6](https://docs.freebsd.org/images/books/handbook/wine/wine-config-6.png)

此选项卡包含一些可配置的选项，用于将来自 Windows® 程序的声音路由到本机 FreeBSD 声音系统，包括：

* 驱动程序选择
* 默认设备选择
* 声音测试

#### 13.5.3.7. 关于

![wine config 7](https://docs.freebsd.org/images/books/handbook/wine/wine-config-7.png)

最后一个标签包含有关 WINE 项目的信息，包括指向网站的链接。它还允许输入（完全可选的）用户信息，尽管这些信息不会像其他操作系统那样发送到任何地方。
