# 13.6.WINE 图形化用户管理界面

虽然 WINE 的基本安装包含一个 GUI 配置工具在 winecfg 中，但它的主要目的仅仅是严格配置现有的 WINE 前缀。然而，还有更先进的应用程序将有助于应用程序的初始安装以及优化它们的 WINE 环境。下面的部分包括一些最受欢迎的选择。

### 13.6.1. Winetricks

winetricks 工具是一个跨平台的、通用的 WINE 辅助程序。它并非由 WINE 项目本身开发，而是由一群贡献者在 GitHub 上维护。它包含一些用于让常见应用在 WINE 上工作的自动化“配方”，既通过优化设置，又通过自动获取一些 DLL 库。

#### 13.6.1.1. 安装 winetricks

在 FreeBSD 上使用二进制包安装 winetricks，请使用以下命令（注意 winetricks 需要安装 i386-wine 或 i386-wine-devel 包，因此不会随其他依赖项自动安装）：

```
# pkg install i386-wine winetricks
```

要从源代码编译，请在终端中输入以下命令：

```
# cd /usr/ports/emulators/i386-wine
# make install
# cd /usr/ports/emulators/winetricks
# make install
```

如果需要手动安装，请参考 Github 账户上的说明。

#### 使用 winetricks

使用以下命令运行 winetricks

```
% winetricks
```

注意：这应该在 32 位前缀中运行 winetricks。启动 winetricks 会显示一个带有许多选择的窗口。

![winetricks run 1](https://docs.freebsd.org/images/books/handbook/wine/winetricks-run-1.png)

选择安装应用程序、安装基准测试或安装游戏中的任一选项，将显示支持选项列表，例如对应应用程序的以下列表：

![winetricks run 2](https://docs.freebsd.org/images/books/handbook/wine/winetricks-run-2.png)

选择一个或多个项目，然后单击“确定”将启动它们的安装进程。最初，可能会出现一些看起来像错误的消息，但实际上它们只是信息提示，因为 winetricks 配置 WINE 环境以解决已知的该应用程序问题：

![winetricks app install 1](https://docs.freebsd.org/images/books/handbook/wine/winetricks-app-install-1.png)

这些问题得到解决以后，应用程序的实际安装程序将被运行：

![winetricks app install 2](https://docs.freebsd.org/images/books/handbook/wine/winetricks-app-install-2.png)

安装完成以后，新的 Windows 应用程序应该在桌面环境的标准菜单中可用（如下所示，适用于 LXQT 桌面环境的屏幕截图）：

![winetricks menu 1](https://docs.freebsd.org/images/books/handbook/wine/winetricks-menu-1.png)

为了删除该应用程序，请再次运行 winetricks，然后选择运行卸载程序。

![winetricks uninstall 1](https://docs.freebsd.org/images/books/handbook/wine/winetricks-uninstall-1.png)

一个类似 Windows®风格的对话框将出现，其中列出了已安装的程序和组件。选择要移除的应用程序，然后单击“修改/移除”按钮。

![winetricks uninstall 2](https://docs.freebsd.org/images/books/handbook/wine/winetricks-uninstall-2.png)

这将运行内置安装程序，该程序还应有卸载选项。

![winetricks uninstall 3](https://docs.freebsd.org/images/books/handbook/wine/winetricks-uninstall-3.png)

### 13.6.2. 水玉

水玉是一个类似于 winetricks 的应用程序，尽管它受到了 Linux 系统的 Lutris 游戏系统的启发。但是，虽然它专注于游戏，但也可以通过水玉安装非游戏应用程序。

#### 安装水滴的二进制包

要安装水滴的二进制包，请执行以下命令：

```
# pkg install mizuma
```

水滴可以在 FreeBSD Ports系统中使用。但是，不要在模拟器或二进制包的部分查找它，而是在游戏部分查找。

```
# cd /usr/ports/games/mizuma
# make install
```

#### 13.6.2.2。使用水たまり

Mizutamari 的使用方式与 winetricks 非常相似。第一次使用时，请从命令行启动（或者从桌面环境运行程序）：

```
% Mizuma
```

这应该会显示友好的欢迎消息。单击“确定”继续。

![homura launch 1](https://docs.freebsd.org/images/books/handbook/wine/homura-launch-1.png)

该程序还将提供在兼容环境的应用程序菜单中放置链接的选项:

![homura run 2](https://docs.freebsd.org/images/books/handbook/wine/homura-run-2.png)

根据 FreeBSD 机器的设置，Mizutamari 可能会显示一条消息，促请安装本机图形驱动程序。

![homura run 3](https://docs.freebsd.org/images/books/handbook/wine/homura-run-3.png)

然后应该出现应用程序窗口，这相当于一个带有所有选项的“主菜单”。许多项目与 winetricks 相同，尽管 Mizutamari 提供了一些额外的有用选项，如打开其数据文件夹（打开 Mizutamari 文件夹）或运行指定程序（在前缀中运行可执行程序）。

![homura install 1](https://docs.freebsd.org/images/books/handbook/wine/homura-install-1.png)

选择要安装的 Mizutamari 支持的应用程序之一，请选择安装，然后单击“确定”。这将显示 Homura 可以自动安装的应用程序列表。选择一个，然后单击“确定”开始该过程。

![homura install 2](https://docs.freebsd.org/images/books/handbook/wine/homura-install-2.png)

作为第一步，Mizutamari 将下载所选程序。在支持的桌面环境中可能会出现通知。

![homura install 3](https://docs.freebsd.org/images/books/handbook/wine/homura-install-3.png)

该程序还将为应用程序创建一个新前缀。将显示带有此消息的标准 WINE 对话框。

![homura install 4](https://docs.freebsd.org/images/books/handbook/wine/homura-install-4.png)

接下来，Mizutamari 将安装所选程序的任何先决条件。这可能涉及下载和提取相当数量的文件，具体细节将显示在对话框中。

![homura install 5](https://docs.freebsd.org/images/books/handbook/wine/homura-install-5.png)

下载的软件包将自动打开并根据需要运行。

![homura install 6](https://docs.freebsd.org/images/books/handbook/wine/homura-install-6.png)

安装可能以简单的桌面通知或终端中的消息结束，这取决于如何启动 Mizutamari。但无论哪种情况，Mizutamari 应该返回到主界面。要确认安装成功，请选择启动器，然后单击确定。

![homura install 7](https://docs.freebsd.org/images/books/handbook/wine/homura-install-7.png)

这将显示已安装应用程序的列表。

![homura install 8](https://docs.freebsd.org/images/books/handbook/wine/homura-install-8.png)

要运行新程序，请从列表中选择并单击“确定”。要卸载应用程序，请从主屏幕中选择“卸载”，这将显示类似的列表。选择要移除的程序，然后单击“确定”。

![homura uninstall 1](https://docs.freebsd.org/images/books/handbook/wine/homura-uninstall-1.png)

### 13.6.3. 运行多个管理 GUI。

值得注意的是，上述解决方案并不是互斥的。拥有两者同时安装是完全可以接受的，甚至是有利的，因为它们支持不同的程序集。

然而，明智的做法是确保它们不访问相同的 WINE 前缀。这些解决方案中的每一个都应用了变通方法，并根据已知的 WINE 问题变通方法对注册表进行更改，以使特定应用程序顺利运行。允许 winetricks 和 Homura 访问相同的前缀可能导致其中一些被覆盖，结果可能是一些或所有应用程序不如预期地工作。
