# 13.7.多用户 FreeBSD 与 WINE


### 13.7.1. 使用共同的 WINE 前缀存在的问题

类似于大多数类 UNIX®的操作系统，FreeBSD 旨在支持多个用户同时登录并工作。另一方面，Windows®在多个用户方面是多用户的，可以在一个系统上设置多个用户账户。但预期情况是在任何给定时刻只有一个用户使用物理机器（台式机或笔记本电脑）。

更近期的 Windows®消费者版本在改善多用户场景方面已经采取了一些步骤。但它仍然主要围绕单用户体验构建。此外，WINE 项目已经采取了一些措施来创建兼容环境，这意味着，与 FreeBSD 应用程序（包括 WINE 本身）不同，它将类似于这种单用户环境。

因此，每个用户将必须维护自己的一组配置，这可能是好事。然而，安装应用程序，尤其是办公套件或游戏等大型应用程序，仅需一次。做到这一点的两个原因的示例是维护（只需应用软件更新一次）和在存储效率方面（没有重复文件）。

减少系统中多个 WINE 用户的影响有两个策略。

### 13.7.2. 将应用程序安装到共同驱动器

如 WINE 配置部分所示，WINE 提供了将附加驱动器连接到给定前缀的能力。这样，应用程序可以安装到一个共同位置，同时每个用户仍将拥有一个前缀，其中可以存储个别设置（取决于程序）。如果要在用户之间共享相对较少的应用程序，并且这些应用程序需要对前缀进行少量定制调整即可正常运行，那么这是一个很好的设置。

制作安装应用程序的步骤如下：

1. 首先，在系统上设置共享位置，这是文件存储的位置，比如/mnt/windows-drive_d/。创建新目录的方法在 mkdir(1)手册页中有说明。
2. 接下来，设置这个新目录的权限，只允许特定用户访问。一个方法是创建一个名为 "windows" 的新组，将所需用户添加到该组中 (请参阅用户和基本账户管理部分中的组子节)，并将目录权限设置为 770 (权限部分说明了这个过程)。
3. 最后，使用本章关于 WINE 配置中上述部分所说明的 winecfg，将位置作为驱动器添加到用户的前缀。

完成后，应用程序可以安装到此位置，并且随后可以使用分配的驱动器盘符（或标准的 UNIX®风格目录路径）运行。然而，如上所述，同一时间只有一个用户应该运行这些应用程序（可能正在访问其安装目录中的文件）。有些应用程序在被非所有者用户运行时可能会表现出意外行为，尽管该用户是应完整“读/写/执行”权限的组的成员。

### 使用通用的 WINE 安装

另一方面，如果有许多需要共享的应用程序，或者它们需要特定的调整才能正常工作，可能需要采用不同的方法。使用这种方法，专门为存储 WINE 前缀及其所有已安装应用程序的目的创建一个完全独立的用户。然后，通过 sudo(8)命令授予各个用户以该用户的身份运行程序的权限。结果是，这些用户可以像平常一样启动 WINE 应用程序，只是它们会表现得好像是由新创建的用户启动的，因此会使用包含设置和程序的中央维护的前缀。要实现这一点，请执行以下步骤：

使用以下命令创建一个新用户（如 root ），然后会引导你填写所需的详细信息：

```
# adduser
```

输入用户名（例如，windows）和全名（“Microsoft Windows”）。然后接受其余问题的默认设置。接下来，使用以下二进制包安装 sudo 实用程序：

```
# pkg install sudo
```

安裝後，編輯/etc/sudoers 如下：

```
# User alias specification

# define which users can run the wine/windows programs
User_Alias WINDOWS_USERS = user1,user2

# define which users can administrate (become root)
User_Alias ADMIN = user1

# Cmnd alias specification

# define which commands the WINDOWS_USERS may run
Cmnd_Alias WINDOWS = /usr/bin/wine,/usr/bin/winecfg

# Defaults
Defaults:WINDOWS_USERS env_reset
Defaults:WINDOWS_USERS env_keep += DISPLAY
Defaults:WINDOWS_USERS env_keep += XAUTHORITY
Defaults    !lecture,tty_tickets,!fqdn

# User privilege specification
root    ALL=(ALL) ALL

# Members of the admin user_alias, defined above, may gain root privileges
ADMIN ALL=(ALL) ALL

# The WINDOWS_USERS may run WINDOWS programs as user windows without a password
WINDOWS_USERS ALL = (windows) NOPASSWD: WINDOWS
```

这些更改的结果是，在 User_Alias 部分中列出的用户被允许使用 Defaults 部分中列出的资源（当前显示）来运行在 Cmnd Alias 部分中列出的程序，就好像他们是文件最后一行中列出的用户一样。换句话说，被指定为 WINDOWS_USERS 的用户可以作为用户 windows 运行 WINE 和 winecfg 应用程序。作为额外福利，这裡的配置意味著他们不需要为 Windows 用户输入密码。

接下来，将显示器权限授予 Windows 用户，作为运行 WINE 程序的用户：

```
% xhost +local:windows
```

这应该添加到登录时或默认图形环境启动时运行的命令列表中。若所有上述操作完成，则作为 sudoers 之一的用户可以使用以下命令使用共享前缀运行程序：

```
% sudo -u windows wine program.exe
```

值得注意的是，多个用户同时访问这个共享环境仍然存在风险。但是，还要考虑到共享环境本身可以包含多个前缀。通过这种方式，管理员可以创建一组经过测试和验证的程序，每个程序都有自己的前缀。同时，一个用户可以玩游戏，而另一个用户可以在没有冗余软件安装的情况下使用办公程序。
