# 13.8.FreeBSD 上的 WINE 常见问题


以下部分说明了在 FreeBSD 上运行 WINE 时经常被问到的问题、技巧/窍门或常见问题，以及它们各自的答案。

### 13.8.1. 基本安装和使用

#### 13.8.1.1. 如何在同一系统上安装 32 位和 64 位 WINE？

就像本节前面所述的那样，wine 和 i386-wine 软件包彼此冲突，因此不能以正常方式在同一系统上安装。但是，可以使用 chroot/jail等机制实现多个安装，也可以通过从源代码构建 WINE 来实现（请注意，这并不意味着构建port）。

#### 13.8.1.2。可以在 WINE 上运行 DOS 程序吗？

可以，在本节前面提到的“控制台用户界面”应用程序中。然而，对于运行 DOS 软件，有一种可以说更好的方法：DOSBox。另一方面，至少值得一试。只需创建一个新的前缀，安装软件，如果不起作用，则删除前缀。

#### 13.8.1.3。是否应安装 emulators/wine-devel 包/Port以使用 WINE 的开发版本而不是稳定版？

安装此版本将安装 WINE 的“开发”版本。与 32 位和 64 位版本一样，除非采取额外措施，否则它们无法与稳定版本一起安装。

请注意，WINE 还有一个“Staging”版本，其中包含最新更新。在某个时候，这个版本作为 FreeBSD port 可用；但是后来被移除了。但可以直接从源代码编译。

### 13.8.2. 安装优化

#### 13.8.2.1. Windows® 硬件（例如，图形）驱动程序应该怎么处理？

操作系统驱动程序在应用程序和硬件之间传输命令。WINE 模拟 Windows® 环境，包括驱动程序，这些驱动程序又使用 FreeBSD 的本地驱动程序进行传输。不建议安装 Windows® 驱动程序，因为 WINE 系统设计为使用主机系统的驱动程序。例如，如果有一款受益于专用驱动程序的显卡，请使用标准的 FreeBSD 方法安装它们，而不是使用 Windows® 安装程序。

#### 13.8.2.2. 如何让 Windows® 字体看起来更好？

一位在 FreeBSD 论坛上的用户建议此配置可修复 WINE 字体的开箱即用外观，可能会稍微有些像素化。

根据 FreeBSD 论坛上的一篇帖子，将以下内容添加到.config/fontconfig/fonts.conf 中将添加抗锯齿，并使文本更易读。

```
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "fonts.dtd>"

<fontconfig>

  <!-- antialias all fonts -->
  <match target="font">
    <edit name="antialias" mode="assign"><bool>true</bool></edit>>
    <edit name="hinting" mode="assign"><bool>true</bool></edit>>
    <edit name="hintstyle" mode="assign"><const>hintslight</const></edit>>
    <edit name="rgba" mode="assign"><const>rgb</const></edit>>
  </match>
</fontconfig>
```

#### 13.8.2.3. 在系统其他位置安装 Windows®是否有助于 WINE 的运行？

根据运行的应用程序而定。如 winecfg 所述，在说明某些内置 WINE DLL 和其他库时，可以通过提供替代版本的路径来覆盖它们。只要 Windows®分区或驱动器已挂载到 FreeBSD 系统并对用户可访问，配置这些覆盖项中的一些将使用本机 Windows®库，并可能降低出现意外行为的机会。

### 13.8.3. 应用程序特定

#### 13.8.3.1. 在哪里看应用程序 X 是否在 WINE 上运行？

确定兼容性的第一步应该是 WINE AppDB。这是一个有关程序在所有支持的平台上工作（或不工作）的报告的汇编，尽管（如前面提到的），一个平台的解决方案通常也适用于其他平台。

#### 13.8.3.2. 有什么能帮助游戏更流畅运行吗？

也许。许多 Windows®游戏依赖于 DirectX，这是微软的专有图形层。然而，在开源社区中有一些项目正在尝试实现对这项技术的支持。

dxvk 项目是一项试图使用兼容 FreeBSD 的 Vulkan 图形子系统来实现 DirectX 的项目之一。虽然它的主要目标是 Linux 上的 WINE，但一些 FreeBSD 用户报告编译并使用 dxvk。

此外，在 wine-proton port 上正在进行工作。这将把 Valve 的工作带到 FreeBSD，Valve 是 Steam 游戏平台的开发者。Proton 是 WINE 的一个发行版，旨在能让许多 Windows® 游戏在其他操作系统上运行，并提供最少的设置。

#### 13.8.3.3. 有没有地方让 FreeBSD 的 WINE 用户交流技巧？

有很多地方是 FreeBSD 用户讨论与 WINE 相关问题并可以搜索解决方案的：

* FreeBSD 论坛，特别是安装和维护 Ports 或软件包或模拟器和虚拟化论坛。
* FreeBSD IRC 频道，包括 #freebsd（用于一般支持）、#freebsd-games 等。
* BSD 世界 Discord 服务器的频道，包括 bsd-desktop、bsd-gaming、bsd-wine 等。

### 13.8.4. 其他操作系统资源

有许多专注于其他操作系统的资源，可能对 FreeBSD 用户有用：

* WINE 维基上有丰富的关于使用 WINE 的信息，其中大部分适用于 WINE 支持的许多操作系统。
* 同样，来自其他操作系统项目的文档也可能非常有价值。Arch Linux 维基上的 WINE 页面就是一个很好的例子，尽管部分"第三方应用程序"（即"伴侣应用程序"）显然在 FreeBSD 上不可用。
* 最后，Codeweavers（WINE 的商业版开发者）是一个积极的上游贡献者。通常来自他们支持论坛中的问题答案可以帮助解决开源版 WINE 的问题。
