# 14.2.配置文件

FreeBSD 保持基础系统和第三方应用程序之间的明确分离，因此这影响了这些应用程序的配置文件的位置。

FreeBSD 基础系统配置位于/etc 目录，/usr/local/etc 目录包含通过ports 和软件包在系统上安装的所有应用程序的配置文件。

内核状态配置位于/etc/sysctl.conf 文件中。在 sysctl 实用程序部分，将更详细地解释 sysctl(8)的操作。

有关 FreeBSD 文件系统结构的更多信息，请参考 hier(7)。

一般规则是，配置文件没有使用它们必须遵循的标准语法。虽然真实情况是，# 字符通常用于注释一行，并且每行都有一个配置变量。

|  | 一些应用程序如 pkg(8) 开始使用通用配置语言 (UCL)。|
| -- | ---------------------------------------------------- |

### 14.2.1. /etc 目录

/etc 目录包含了所有的 FreeBSD 基础系统配置文件，负责配置 FreeBSD。

|  | 在修改/etc 目录中的文件时必须极度谨慎；配置错误可能导致 FreeBSD 无法启动或出现故障。|
| -- | -------------------------------------------------------------------------------------- |

| /etc             | 系统配置文件和脚本。                                                                                                          |
| ------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------- |
| /etc/defaults    | 默认系统配置文件，请参阅 rc（8）获取更多信息。                                                                                |
| /etc/fstab       | fstab（5）包含有关各种文件系统的说明信息。                                                                                    |
| /etc/mail        | 额外的 sendmail（8）配置和其他 MTA 配置文件。                                                                                 |
| /etc/mtree       | mtree 配置文件，请参阅 mtree[8]手册了解更多信息。                                                                             |
| /etc/pam.d       | 可插拔身份验证模块（PAM）库的配置文件。                                                                                       |
| /etc/periodic    | 通过 cron(8)每天、每周和每月运行的脚本，请参阅 periodic(8)了解更多信息。                                                      |
| /etc/rc.d        | 系统和守护进程启动/控制脚本，请参阅 rc(8) 以获取更多信息。                                                                    |
| /etc/rc.conf     | 包含有关本地主机名的说明性信息，以及任何潜在网络接口的配置细节，以及在系统初始引导时应该启动哪些服务。有关更多信息，请参阅管理系统特定配置。|
| /etc/security    | OpenBSM 审计配置文件，请参阅 audit(8) 以获取更多信息。                                                                        |
| /etc/ppp         | ppp 配置文件，请参阅 ppp(8)获取更多信息。                                                                                     |
| /etc/ssh         | OpenSSH 配置文件，请参阅 ssh(1)获取更多信息。                                                                                 |
| /etc/ssl         | OpenSSL 配置文件。                                                                                                            |
| /etc/sysctl.conf | 包含内核设置。在 sysctl 实用程序中有更多信息                                                                                                 |

### 14.2.2.sysctl 实用程序

sysctl(8)实用程序用于对运行中的 FreeBSD 系统进行更改。

sysctl(8)实用程序检索内核状态，并能让具有适当特权的进程设置内核状态。要检索或设置的状态使用“管理信息库”（“MIB”）样式名称描述，描述为一组分量的点集。

表 1.管理信息库

|sysctl|幻数| 
| -----| -----------------|
|kern|内核功能和特性| 
|vm|虚拟内存|
|vfs|文件系统|
|net|网络| 
|debug|调试参数|
|hw|硬件|
|machdep|机器相关| 
|user|用户空间|
|p1003_1b|POSIX 1003.1B|

在其核心，sysctl(8)具有两个功能：读取和修改系统设置。

要查看所有可读变量：

```
% sysctl -a
```

输出应类似于以下内容：

```
kern.ostype: FreeBSD
...
vm.swap_enabled: 1
vm.overcommit: 0
vm.domain.0.pidctrl.kdd: 8
vm.domain.0.pidctrl.kid: 4
vm.domain.0.pidctrl.kpd: 3
...
vfs.zfs.sync_pass_rewrite: 2
vfs.zfs.sync_pass_dont_compress: 8
vfs.zfs.sync_pass_deferred_free: 2
```

要读取特定变量，请指定其名称：

```
% sysctl kern.maxproc
```

输出应类似如下：

```
kern.maxproc: 1044
```

管理信息库（MIB）是分层的，因此，指定前缀会打印下面的所有节点：

```
% sysctl net
```

输出应类似如下：

```
net.local.stream.recvspace: 8192
net.local.stream.sendspace: 8192
net.local.dgram.recvspace: 16384
net.local.dgram.maxdgram: 2048
net.local.seqpacket.recvspace: 8192
net.local.seqpacket.maxseqpacket: 8192
net.local.sockcount: 60
net.local.taskcount: 25
net.local.recycled: 0
net.local.deferred: 0
net.local.inflight: 0
net.inet.ip.portrange.randomtime: 1
net.inet.ip.portrange.randomcps: 9999
[...]
```

要设置特定变量，请使用变量=值的语法：

```
# sysctl kern.maxfiles=5000
```

输出应类似于以下内容：

```
kern.maxfiles: 2088 -> 5000
```

|  | 要在重启后保留配置，必须将这些变量添加到/etc/sysctl.conf 文件中，如下所述。|
| -- | --------------------------------------------------------------------------------- |

### 14.2.3. /etc/sysctl.conf 文件

sysctl(8) 的配置文件 /etc/sysctl.conf 看起来很像 /etc/rc.conf。

使用 variable=value 语法设置值。

|  | 指定的值在系统进入多用户模式后设置。并非所有变量都可以在此模式下设置。|
| -- | ------------------------------------------------------------------------ |

例如，要关闭致命信号退出的日志记录并防止用户看到其他用户启动的进程，可以在 /etc/sysctl.conf 中设置以下可调整项：

```
# Do not log fatal signal exits (e.g., sig 11)
kern.logsigexit=0

# Prevent users from seeing information about processes that
# are being run under another UID.
security.bsd.see_other_uids=0
```

要获取关于特定 sysctl 具有什么功能的更多信息，可以执行以下命令：

```
% sysctl -d kern.dfldsiz
```

输出应类似于以下内容:

```
kern.dfldsiz: Initial data size limit
```

### 14.2.4. 管理系统特定配置

系统配置信息的主要位置是 /etc/rc.conf.

此文件包含各种配置信息，并在系统启动时读取以配置系统。它为 rc*文件提供配置信息。

/etc/rc.conf 中的条目会覆盖/etc/defaults/rc.conf 中的默认设置。

|  | 不应编辑包含默认设置的文件/etc/defaults/rc.conf。应将所有特定于系统的更改都保存到/etc/rc.conf 中。|
| -- | ---------------------------------------------------------------------------------------------------- |

在聚集应用中，可以采用多种策略将站点范围配置与系统特定配置分离，以减少管理开销。

推荐的方法是将系统特定配置放入 /etc/rc.conf.local 中。

例如，/etc/rc.conf 中的这些条目适用于所有系统：

```
sshd_enable="YES"
keyrate="fast"
defaultrouter="10.1.1.254"
```

而这些在 /etc/rc.conf.local 中的条目仅适用于这个系统：

```
hostname="node1.example.org"
ifconfig_fxp0="inet 10.1.1.1/8"
```

使用诸如 rsync 或 puppet 之类的应用程序将 /etc/rc.conf 分发到每个系统，而 /etc/rc.conf.local 保持独特。

升级系统不会覆盖 /etc/rc.conf，因此系统配置信息不会丢失。

|  | /etc/rc.conf 和/etc/rc.conf.local 都由 sh(1)解析。这使系统运营商可以创建复杂的配置方案。请参考 rc.conf(5)获取有关此主题的进一步信息。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------- |
