# 14.3.管理 FreeBSD 中的服务

FreeBSD 在系统初始化期间和管理服务时使用 rc(8)启动脚本系统。

/etc/rc.d 中列出的脚本提供基本服务，可使用 service(8)中的 start 、 stop 和 restart 选项进行控制。

基本脚本可能类似于以下内容：

```
#!/bin/sh
#
# PROVIDE: utility
# REQUIRE: DAEMON
# KEYWORD: shutdown

. /etc/rc.subr

name=utility
rcvar=utility_enable

command="/usr/local/sbin/utility"

load_rc_config $name

#
# DO NOT CHANGE THESE DEFAULT VALUES HERE
# SET THEM IN THE /etc/rc.conf FILE
#
utility_enable=${utility_enable-"NO"}
pidfile=${utility_pidfile-"/var/run/utility.pid"}

run_rc_command "$1"
```

请参考本文以获取有关如何创建自定义 rc(8)脚本的说明。

### 启动服务

许多用户从 Ports 在 FreeBSD 上安装第三方软件，并要求安装的服务在系统初始化时启动。

服务，例如 security/openssh-portable 或 www/nginx，只是在系统初始化期间可能启动的许多软件包中的两个。本节解释了可用于启动服务的程序。

由此可见，rc(8)系统主要用于在系统启动和关机时启动和停止服务，仅当适当的/etc/rc.conf 变量设置后，start，stop 和 restart 选项才会执行其操作。

因此，启动服务的第一步，例如 www/nginx，是将其添加到/etc/rc.conf，方法是执行以下命令：

```
# sysrc nginx_enable="YES"
```

然后，可以执行以下命令启动 nginx：

```
# service nginx start
```

```
# service nginx onestart
```

它也可以自动将服务放入jail中，请参阅相应的服务Jails说明。

### 14.3.2. 服务的状态

要确定服务是否正在运行，请使用 status 子命令。

例如，要验证 www/nginx 是否正在运行：

```
# service nginx status
```

输出应该类似于以下内容：

```
nginx is running as pid 27871.
```

### 14.3.3. 重新加载服务

在某些情况下，也有可能重载服务。这尝试向单个服务发送信号，强制服务重新加载其配置文件。

在大多数情况下，这意味着发送服务一个信号。

**并非所有服务都支持这个功能。**

rc(8)系统用于网络服务，并且它也贡献于大部分系统初始化。例如，当执行/etc/rc.d/bgfsck 脚本时，它会输出以下信息：

```
Starting background file system checks in 60 seconds.
```

该脚本用于后台文件系统检查，这仅在系统初始化期间发生。

许多系统服务依赖于其他服务才能正常运行。例如，yp(8)和其他基于 RPC 的服务可能直到 rpcbind(8)服务启动后才能启动。

额外信息可以在 rc(8)和 rc.subr(8)中找到。

### 14.3.4. 使用服务启动服务

其他服务可以使用 inetd(8)启动。深入了解 inetd(8)及其配置在“inetd 超级服务器”中有详细说明。

在某些情况下，使用 cron(8) 启动系统服务可能更合理。这种方法有许多优点，因为 cron(8) 会将这些进程作为 crontab(5) 的所有者运行。这能让普通用户启动和维护自己的应用程序。

cron(8) 的 @reboot 特性可以代替时间规范。这会导致作业在 cron(8) 启动时运行，通常在系统初始化期间。
