# 14.4.Cron 和 Periodic


安排任务在特定的日期或时间运行是在 FreeBSD 上非常常见的任务。负责执行此任务的工具是 cron(8)。

除了用户可以通过 cron(8)进行调度的任务之外，FreeBSD 还执行由 periodic(8)管理的常规后台任务。

### 14.4.1. Cron

cron(8) 实用程序在后台运行，定期检查 /etc/crontab 以查找要执行的任务，并搜索 /var/cron/tabs 以查找自定义 crontab 文件。

这些文件用于安排任务，cron 在指定的时间运行这些任务。

crontab 中的每个条目定义要运行的任务，并称为 cron 作业。

使用两种不同类型的配置文件：系统 crontab 不应更改，用户 crontab 可以根据需要创建和编辑。这些文件的格式在 crontab(5)中有文档记录。系统 crontab 的格式，/etc/crontab 包含一个 who 列，在用户 crontab 中不存在。在系统 crontab 中，cron 以该列中指定的用户身份运行命令。在用户 crontab 中，所有命令都作为创建 crontab 的用户运行。

用户的 crontab 允许个别用户安排自己的任务。root 用户也可以有一个用户 crontab，用于安排系统 crontab 中不存在的任务。

这里是系统 crontab 中的一个示例条目，/etc/crontab：

```
# /etc/crontab - root's crontab for FreeBSD
#

#
SHELL=/bin/sh
PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/sbin:/usr/local/bin 
#
#minute hour    mday    month   wday    who     command 
#
# Save some entropy so that /dev/random can re-seed on boot.
*/11    *       *       *       *       operator /usr/libexec/save-entropy 
#
# Rotate log files every hour, if necessary.
0       *       *       *       *       root    newsyslog
#
# Perform daily/weekly/monthly maintenance.
1       3       *       *       *       root    periodic daily
15      4       *       *       6       root    periodic weekly
30      5       1       *       *       root    periodic monthly
#
# Adjust the time zone if the CMOS clock keeps local time, as opposed to
# UTC time.  See adjkerntz(8) for details.
1,31    0-5     *       *       *       root    adjkerntz -a
```

|  | 以 # 字符开头的行是注释。注释可以放在文件中作为对所执行操作的提醒。注释不能与命令在同一行上，否则它们将被解释为命令的一部分；它们必须在新的一行上。空行将被忽略。                                                                                                                                                                                                                               |
| -- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|  | 等号（ = ）字符用于定义任何环境设置。在这个例子中，它被用来定义 SHELL 和 PATH。如果省略 SHELL，cron 将使用默认的 Bourne shell。如果省略 PATH，必须提供命令或脚本的完整路径以运行。                                                                                                                                                                                                           |
|  | 这一行定义了系统 crontab 中使用的七个字段： minute，hour，mday，month，wday，who，和 command。minute 字段是指定命令运行的分钟时间，hour 是指定命令运行的小时时间，mday 是月中的某天，month 是月份，wday 是星期中的某天。这些字段必须是数字值，表示二十四小时制，或者是 *，表示该字段的所有值。who 字段只存在于系统 crontab 中，指定应以哪个用户身份运行该命令。最后一个字段是要执行的命令。|
|  | 这个条目定义了这个 cron 作业的值。*/11，后面跟着几个 * 字符，指定了 /usr/libexec/save-entropy 被 operator 每小时每天每周的每一天的每十一分钟调用。命令可以包括任意数量的开关。然而，跨多行延伸的命令需要使用反斜杠"\"续行字符进行分隔。                                                                                                                                                    |

### 创建用户定时任务

要创建用户定时任务，请在编辑模式中调用 crontab ：

```
% crontab -e
```

这将使用默认文本编辑器打开用户的定时任务。当用户第一次运行此命令时，它将打开一个空文件。用户创建了定时任务以后，这个命令将打开该文件进行编辑。

将这些行添加到 crontab 文件顶部是有用的，以设置环境变量并记住 crontab 字段的含义：

```
SHELL=/bin/sh
PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/sbin:/usr/local/bin
# Order of crontab fields
# minute hour mday month wday command
```

然后，为要运行的每个命令或脚本添加一行，指定运行命令的时间。此示例每天下午两点运行指定的自定义 Bourne shell脚本。由于 PATH 中未指定脚本的路径，因此给出了脚本的完整路径：

```
0 14 * * * /home/user/bin/mycustomscript.sh
```

```
env -i SHELL=/bin/sh PATH=/etc:/bin:/sbin:/usr/bin:/usr/sbin HOME=/home/user LOGNAME=user /home/user/bin/mycustomscript.sh
```

crontab(5)讨论了 cron 设置的环境。检查脚本在 cron 环境中是否正常运行特别重要，特别是如果它们包含使用通配符删除文件的任何命令。

完成编辑 crontab 后，保存文件。它将自动安装，并且 cron 将读取 crontab 并在指定时间运行其 cron 作业。要列出 crontab 中的 cron 作业，请使用此命令：

```
% crontab -l
```

输出应类似于以下内容：

```
0 14 * * * /home/user/bin/mycustomscript.sh
```

要删除用户 crontab 中的所有 cron 作业：

```
% crontab -r
```

输出应该类似于以下内容：

```
remove crontab for user? y
```

### 14.4.3. 周期性

FreeBSD 提供了一组系统管理脚本，用于检查各种子系统的状态，执行与安全相关的检查，轮转日志文件等。这些脚本定期运行：每天、每周或每月。这些任务的管理由 periodic(8) 执行，并且其配置位于 periodic.conf(5) 中。周期性任务由系统 crontab 中的条目启动，如上所示。

周期性执行的脚本存放在 /etc/periodic/ 用于基本实用程序，在 /usr/local/etc/periodic/ 用于第三方软件。

它们被组织在 4 个子目录中，分别是每天，每周，每月和安全性。

### 14.4.4. 启用或禁用定期任务

FreeBSD 默认启用了一些脚本以定期运行。

要启用或禁用任务，第一步是编辑 /etc/periodic.conf 并执行以下命令：

```
# ee /etc/periodic.conf
```

然后要启用，例如，daily_status_zfs_enable 将以下内容放入文件中：

```
daily_status_zfs_enable="YES"
```

禁用默认情况下处于活动状态的任务，只需将 YES 更改为 NO。

### 14.4.5. 配置周期性任务的输出

在 /etc/periodic.conf 中，变量 daily_output，weekly_output 和 monthly_output 指定了脚本执行结果的发送位置。

默认情况下，周期性脚本的输出会通过电子邮件发送至 root 用户，因此最好阅读 root 用户的邮件或将 root 用户设置为监控的邮箱。

要将结果发送到另一个电子邮件地址或其他电子邮件地址，请在/etc/periodic.conf 中添加以空格分隔的电子邮件地址。

```
daily_output="email1@example.com email2@example.com"
weekly_output="email1@example.com email2@example.com"
monthly_output="email1@example.com email2@example.com"
```

要将周期性输出记录到日志中而不是通过电子邮件接收，请在/etc/periodic.conf 中添加以下行。newsyslog(8)将在适当的时间轮转这些文件。

```
daily_output=/var/log/daily.log
weekly_output=/var/log/weekly.log
monthly_output=/var/log/monthly.log
```
