# 14.5.配置系统日志

生成和阅读系统日志是系统管理的重要方面。系统日志中的信息可用于检测硬件和软件问题以及应用程序和系统配置错误。这些信息在安全审计和事件响应中也起着重要作用。大多数系统守护程序和应用程序都会生成日志条目。

FreeBSD 提供了一个系统日志记录器 syslogd(8)，用于管理日志。默认情况下，系统引导时会启用并启动 syslogd。

本节说明了如何为 FreeBSD 系统日志记录器配置本地和远程日志记录，以及如何执行日志轮换和日志管理。

### 14.5.1. 配置本地日志记录

配置文件/etc/syslog.conf 控制 syslogd 接收到日志条目时的处理方式。有几个参数可以控制传入事件的处理。facility 说明生成消息的子系统，如内核或守护程序，level 说明发生事件的严重程度。这样可以根据 facility 和 level 配置日志消息是否以及何处记录日志。还可以根据发送消息的应用程序采取行动，在远程记录日志的情况下，还可以根据生成日志事件的主机名采取行动。

此配置文件每行包含一个操作，每行的语法是选择器字段后跟一个操作字段。选择器字段的语法是 facility.level，将匹配 facility 在 level 级别或更高级别的日志消息。还可以在级别之前添加可选的比较标志，以更精确地指定记录什么。可以为同一操作使用多个选择器字段，并用分号（ ; ）分隔。使用 * 将匹配所有内容。操作字段表示将日志消息发送至何处，例如文件或远程日志主机。

作为示例，这里是 FreeBSD 的默认/etc/syslog.conf 内容：

```
#       Spaces ARE valid field separators in this file. However,
#       other *nix-like systems still insist on using tabs as field
#       separators. If you are sharing this file between systems, you
#       may want to use only tabs as field separators here.
#       Consult the syslog.conf(5) manpage.
*.err;kern.warning;auth.notice;mail.crit                /dev/console 
*.notice;authpriv.none;kern.debug;lpr.info;mail.crit;news.err   /var/log/messages
security.*                                      /var/log/security
auth.info;authpriv.info                         /var/log/auth.log
mail.info                                       /var/log/maillog 
cron.*                                          /var/log/cron
!-devd
*.=debug                                        /var/log/debug.log 
*.emerg                                         *
daemon.info                                     /var/log/daemon.log
# uncomment this to log all writes to /dev/console to /var/log/console.log
# touch /var/log/console.log and chmod it to mode 600 before it will work
#console.info                                   /var/log/console.log
# uncomment this to enable logging of all log messages to /var/log/all.log
# touch /var/log/all.log and chmod it to mode 600 before it will work
#*.*                                            /var/log/all.log
# uncomment this to enable logging to a remote loghost named loghost
#*.*                                            @loghost
# uncomment these if you're running inn
# news.crit                                     /var/log/news/news.crit
# news.err                                      /var/log/news/news.err
# news.notice                                   /var/log/news/news.notice
# Uncomment this if you wish to see messages produced by devd
# !devd
# *.>=notice                                    /var/log/devd.log 
!*
include                                         /etc/syslog.d
include                                         /usr/local/etc/syslog.d
```

|  | 匹配所有等级为 err 或更高的消息，以及 kern.warning，auth.notice 和 mail.crit，并将这些日志消息发送到控制台（/dev/console）。|
| -- | --------------------------------------------------------------------------------------------------------------------------------- |
|  | 匹配 mail 设施上的所有消息，级别为 info 或更高，并将消息记录到/var/log/maillog 中。                              |
|  | 使用比较标志（ = ）仅匹配级别为 debug 的消息，并将其记录到/var/log/debug.log 中。                                |
|  | 是程序规范的示例用法。这使得后续的规则仅对指定的程序有效。在这种情况下，只有由 devd(8)生成的消息被记录到/var/log/devd.log 中。 |

有关/etc/syslog.conf，它的语法以及更高级的用法示例的更多信息，请参阅 syslog.conf(5)。

### 14.5.2. 记录设施

设施说明生成消息的系统部分。设施是一种分离不同消息的方式，使用户更容易查阅日志。

表 2。系统日志设施

| 名称            | 说明                                                                    |
| ----------------- | ------------------------------------------------------------------------- |
| 授权            | 授权系统: 登录(1), su(1), getty(8), 等。                 |
| 认证权限        | 与 auth 相同，但仅由 root 可读取的文件中记录。           |
| 控制台          | 内核控制台输出驱动程序写入/dev/console 的消息。          |
| 计划任务        | 由 cron(8)守护进程写入的消息。                           |
| 守护程序        | 系统守护程序，比如 routed(8)，这些守护程序不是由其他设施显式提供的。 |
| ftp             | 文件传输协议守护进程：ftpd（8），tftpd（8）。            |
| 核心            | 内核生成的消息。这些消息不能由任何用户进程生成。         |
| 线路打印机      | 线路打印机排队系统：lpr（1），lpc（8），lpd（8），等等。 |
| 邮件            | 邮件系统。                                               |
| 标记            | 此设施每 20 分钟添加一条记录。                           |
| 新闻            | 网络新闻系统。                                           |
| ntp             | 网络时间协议系统。                                       |
| 安全            | 安全子系统，如 ipfw(4)。                                 |
| 系统日志        | syslogd（8）内部生成的消息。                             |
| 用户            | 由随机用户进程生成的消息。如果未指定，则这是默认的设施标识符。|
| uucp            | Unix 到 Unix 复制系统。一个古老的协议。看到来自该设施的消息真的很奇怪。|
| 本地 0 到本地 7 | 保留供本地使用。                                         |

### 14.5.3. 日志级别

等级说明消息的严重程度，并且是以下有序列表中的关键字（从高到低）：

表 3. 系统日志级别

| 名称 | 说明                                             |
| ------ | -------------------------------------------------- |
| 紧急 | 一种恐慌情况。通常会广播给所有用户。   |
| 报警 | 应立即更正的情况，例如损坏的系统数据库。   |
| 危急 | 严重的条件，例如硬件设备错误。    |
| 错误 | 错误。                            |
| 警告 | 警告消息。                        |
| 注意 | 不是错误条件，但可能需要特殊处理。|
| 信息 | 信息性消息。                      |
| 调试 | 包含信息，通常仅在调试程序时使用时才有用的消息。|
| 无   | 这个特殊级别会禁用特定的设施。    |

### 14.5.4. 读取日志消息

默认情况下，FreeBSD 日志文件使用 rfc3164 格式，也被称为 The BSD syslog 协议。了解更多关于其他格式以及如何使用它们的信息，请查看 syslog(8)。

通常，日志具有以下语法：

```
date time hostname program[pid]: the message
```

将使用 /var/log/cron 文件的输出作为示例：

```
[...]
Jul 16 12:40:00 FreeBSD /usr/sbin/cron[81519]: (root) CMD (/usr/libexec/atrun)
Jul 16 12:44:00 FreeBSD /usr/sbin/cron[83072]: (operator) CMD (/usr/libexec/save-entropy)
[...]
```

可以通过运行以下命令在 syslog(8)中启用详细记录，因此将在每条消息上添加设施和级别

```
# sysrc syslogd_flags="-vv"
```

功能激活以后，设施和级别将如下例所示显示在日志中：

```
[...]
Jul 16 17:40:00 <cron.info> FreeBSD /usr/sbin/cron[1016]: (root) CMD (/usr/libexec/atrun)
Jul 16 17:44:00 <cron.info> FreeBSD /usr/sbin/cron[1030]: (operator) CMD (/usr/libexec/save-entropy)
[...]
```

### 14.5.5. 日志管理和旋转

日志文件可能会快速增长，占据磁盘空间，使得查找有用信息变得更加困难。

在 FreeBSD 中，newsyslog(8)用于管理日志文件并尝试减轻这种情况。

这个内置程序定期旋转和压缩日志文件，并可选择在日志文件丢失时创建缺失的日志文件并在日志文件移动时向程序发送信号。

|  | 由于 newsyslog 是从 cron(8)中运行的，所以它不能比从 cron(8)中运行的计划更频繁地旋转文件。在默认配置中，它每小时运行一次。|
| -- | --------------------------------------------------------------------------------------------------------------------------- |

这里是 FreeBSD 中的默认配置，在 newsyslog.conf(5)中有更多信息：

```
# configuration file for newsyslog
#
# Entries which do not specify the '/pid_file' field will cause the
# syslogd process to be signalled when that log file is rotated.  This
# action is only appropriate for log files which are written to by the
# syslogd process (ie, files listed in /etc/syslog.conf).  If there
# is no process which needs to be signalled when a given log file is
# rotated, then the entry for that file should include the 'N' flag.
#
# Note: some sites will want to select more restrictive protections than the
# defaults.  In particular, it may be desirable to switch many of the 644
# entries to 640 or 600.  For example, some sites will consider the
# contents of maillog, messages, and lpd-errs to be confidential.  In the
# future, these defaults may change to more conservative ones.
#
# logfilename          [owner:group]    mode count size when  flags [/pid_file] [sig_num]
/var/log/all.log                        600  7     *    @T00  J
/var/log/auth.log                       600  7     1000 @0101T JC
/var/log/console.log                    600  5     1000 *     J
/var/log/cron                           600  3     1000 *     JC
/var/log/daily.log                      640  7     *    @T00  JN
/var/log/debug.log                      600  7     1000 *     JC
/var/log/init.log                       644  3     1000 *     J
/var/log/kerberos.log                   600  7     1000 *     J
/var/log/maillog                        640  7     *    @T00  JC
/var/log/messages                       644  5     1000 @0101T JC
/var/log/monthly.log                    640  12    *    $M1D0 JN
/var/log/devd.log                       644  3     1000 *     JC
/var/log/security                       600  10    1000 *     JC
/var/log/utx.log                        644  3     *    @01T05 B
/var/log/weekly.log                     640  5     *    $W6D0 JN
/var/log/daemon.log                     644  5     1000 @0101T JC

<include> /etc/newsyslog.conf.d/[!.]*.conf
<include> /usr/local/etc/newsyslog.conf.d/[!.]*.conf
```

1. logfilename - 要归档的系统日志文件的名称。
2. [owner:group] - 此可选字段指定归档文件的所有者和组。
3. mode - 指定日志文件和归档文件的文件模式。有效的模式位为 0666。（也就是说，对于所有者、组和其他用户，可以指定旋转日志的读取和写入权限。）
4. count - 指定可能存在的归档文件的最大数量。
5. size - 当日志文件的大小达到千字节大小时，将会像上面说明的那样对日志文件进行修剪。如果此字段包含一个星号（'*'），则不会根据大小修剪日志文件。
6. `when` - Consist of an interval, a specific time, or both. Supported options in [newsyslog.conf(5)](https://man.freebsd.org/cgi/man.cgi?query=newsyslog.conf&sektion=5&format=html). 重试  错误原因
7. `flags` - Indicates the flags that newsyslog accepts, supported options in [newsyslog.conf(5)](https://man.freebsd.org/cgi/man.cgi?query=newsyslog.conf&sektion=5&format=html). 重试  错误原因
8. `[/pid_file]` - This optional field specifies the file name containing a daemon’s process ID or to find a group process ID. 重试  错误原因
9. [sig_num] - 这个可选的字段指定将发送给守护进程的信号。

|  | 最后两个字段是可选的，指定进程的进程 ID（PID）文件的名称，在文件轮换时发送到该进程的信号编号。|
| -- | ------------------------------------------------------------------------------------------------ |

### 14.5.6. 配置远程日志记录

监视多台主机的日志文件在系统数量增加时可能变得难以管理。配置集中日志记录可以减少日志文件管理的一些管理员负担。

在 FreeBSD 中，可以使用 syslogd 和 newsyslog 配置集中日志文件聚合、合并和旋转。

本节演示一个示例配置，在其中主机 A，名为 logserv.example.com，将收集本地网络的日志信息。

Host `B`, named `logclient.example.com`, will be configured to pass logging information to the logging server. 重试  错误原因

#### 14.5.6.1. Log Server Configuration 重试  错误原因

A log server is a system that has been configured to accept logging information from other hosts. 重试  错误原因

在配置日志服务器之前，请检查以下内容：

* 如果在日志服务器和任何日志客户机之间有防火墙，请确保防火墙规则集允许 UDP port 514 用于客户端和服务器。
* 日志服务器和所有客户机都必须在本地 DNS 中具有正向和反向条目。如果网络没有 DNS 服务器，请在每个系统的/etc/hosts 中创建条目。需要正确的名称解析，以便日志条目不被日志服务器拒收。

在日志服务器上，编辑/etc/syslog.conf 以指定接收日志条目的客户端名称，要使用的日志设施以及存储主机日志条目的日志名称。该示例添加了 B 的主机名，记录所有设施，并将日志条目存储在/var/log/logclient.log 中。

例 1. 示例日志服务器配置

```
+logclient.example.com
*.*     /var/log/logclient.log
```

当添加多个日志客户端时，为每个客户端添加类似的两行条目。有关可用设施的更多信息，请参阅 syslog.conf(5)。

接下来，执行以下命令：

```
# sysrc syslogd_enable="YES"
# sysrc syslogd_flags="-a logclient.example.com -v -v"
```

第一个条目在系统引导时启动 syslogd。第二个条目允许来自指定客户端的日志条目。-v -v 增加了日志消息的详细程度。对于调整设施而言，这是有用的，因为管理员可以看到在每个设施下记录了什么类型的消息。

可以指定多个 -a 选项以允许从多个客户端记录日志。也可以指定 IP 地址和整个网络块。有关可能选项的完整列表，请参阅 syslogd(8)。

最后创建日志文件：

```
# touch /var/log/logclient.log
```

此时，应重启并验证 syslogd：

```
# service syslogd restart
# pgrep syslog
```

如果返回 PID，则服务器成功重启，客户端配置可以开始。如果服务器没有重启，请查看错误的/var/log/messages。

#### 14.5.6.2. 日志客户端配置

日志客户端将日志条目发送到网络上的日志服务器。客户端还保留自己日志的本地副本。

配置了日志服务器以后，在日志客户端上执行以下命令：

```
# sysrc syslogd_enable="YES"
# sysrc syslogd_flags="-s -v -v"
```

第一个条目在启动时启用 syslogd。第二个条目防止其他主机（ -s ）向此客户端接受日志，并增加记录消息的详细程度。

接下来，在客户端的/etc/syslog.conf 中定义日志服务器。在此示例中，所有记录设施都将发送到远程系统，用指定的主机名表示为 @ 符号：

```
*.*  @logserv.example.com
```

保存编辑后，重启 syslogd 以使更改生效：

```
# service syslogd restart
```

为了测试日志消息是否通过网络发送，请在客户端上使用 logger(1)发送消息到 syslogd：

```
# logger "Test message from logclient"
```

现在，此消息应该同时存在于客户端的/var/log/messages 和日志服务器上的/var/log/logclient.log 中。

#### 14.5.6.3. 调试日志服务器

如果日志服务器上未收到任何消息，则原因很可能是网络连通性问题、主机名解析问题或配置文件中的拼写错误。为了确定原因，请确保日志服务器和日志客户端能够使用它们在 /etc/rc.conf 中指定的主机名互相 ping。如果失败，请检查网络布线、防火墙规则集和 DNS 服务器或日志服务器和客户端上的 /etc/hosts 中的主机名条目。重复此过程，直到来自两个主机的 ping 成功为止。

如果两个主机上的 ping 都成功了，但仍然没有接收到日志消息，请暂时增加日志详细程度以缩小配置问题的范围。在下面的示例中，日志服务器上的 /var/log/logclient.log 文件是空的，而日志客户端上的 /var/log/messages 文件没有指示失败原因。

要增加调试输出，请编辑日志服务器上的 syslogd_flags 条目并执行重启：

```
sysrc syslogd_flags="-d -a logclient.example.com -v -v"
```

```
# service syslogd restart
```

重启后，控制台上会立即闪现类似以下调试数据：

```
logmsg: pri 56, flags 4, from logserv.example.com, msg syslogd: restart
syslogd: restarted
logmsg: pri 6, flags 4, from logserv.example.com, msg syslogd: kernel boot file is /boot/kernel/kernel
Logging to FILE /var/log/messages
syslogd: kernel boot file is /boot/kernel/kernel
cvthname(192.168.1.10)
validate: dgram from IP 192.168.1.10, port 514, name logclient.example.com;
rejected in rule 0 due to name mismatch.
```

在本例中，由于拼写错误导致主机名不匹配，日志消息被拒绝。客户端的主机名应为 logclient，而不是 logclien。修复拼写错误，重启，并验证结果：

```
# service syslogd restart
```

输出应类似于以下内容：

```
logmsg: pri 56, flags 4, from logserv.example.com, msg syslogd: restart
syslogd: restarted
logmsg: pri 6, flags 4, from logserv.example.com, msg syslogd: kernel boot file is /boot/kernel/kernel
syslogd: kernel boot file is /boot/kernel/kernel
logmsg: pri 166, flags 17, from logserv.example.com,
msg Dec 10 20:55:02 <syslog.err> logserv.example.com syslogd: exiting on signal 2
cvthname(192.168.1.10)
validate: dgram from IP 192.168.1.10, port 514, name logclient.example.com;
accepted in rule 0.
logmsg: pri 15, flags 0, from logclient.example.com, msg Dec 11 02:01:28 trhodes: Test message 2
Logging to FILE /var/log/logclient.log
Logging to FILE /var/log/messages
```

在这一点上，消息已被正确接收并放置在正确的文件中。

#### 14.5.6.4. 安全注意事项

与任何网络服务一样，在实现日志服务器之前应考虑安全要求。日志文件可能包含有关本地主机上启用的服务、用户账户和配置数据的敏感数据。从客户端发送到服务器的网络数据将不会被加密或密码保护。如果需要加密，请考虑使用 security/stunnel，它将通过加密隧道传输日志数据。

本地安全性也是一个问题。日志文件在使用或日志轮换后没有加密。本地用户可以访问日志文件，以获得额外的系统配置洞察。在日志文件上设置适当的权限至关重要。内置的日志轮换器，newsyslog，支持对新创建和已轮换的日志文件设置权限。将日志文件设置为模式 600 应该可以防止本地用户访问。有关更多信息，请参考 newsyslog.conf(5)。
