# 14.6.电源和资源管理

在高效利用硬件资源方面非常重要。功耗和资源管理使操作系统能够监视系统限制，并可能根据与这些限制相关的事件运行一些动作。

### 14.6.1. ACPI 配置

在 FreeBSD 上，这些资源的管理由 acpi(4)内核设备管理。

|  | 在 FreeBSD 中，acpi(4)驱动程序默认在系统启动时加载。<br /><br />此驱动程序在启动后无法卸载，因为系统总线在各种硬件交互中使用它。|
| -- | -------------------------------------------------------------------------------------------------------------------------- |

除了 acpi(4)之外，FreeBSD 还有几个专用的内核模块用于各种 ACPI 供应商子系统。这些模块将增加一些额外功能，如风扇速度、键盘背光或屏幕亮度。

可通过运行以下命令获取列表：

```
% ls /boot/kernel | grep acpi
```

输出应类似于以下内容：

```
acpi_asus.ko
acpi_asus_wmi.ko
acpi_dock.ko
acpi_fujitsu.ko
acpi_hp.ko
acpi_ibm.ko
acpi_panasonic.ko
acpi_sony.ko
acpi_toshiba.ko
acpi_video.ko
acpi_wmi.ko
sdhci_acpi.ko
uacpi.ko
```

如果使用 IBM/Lenovo 笔记本电脑，将需要通过执行以下命令加载模块 acpi_ibm(4)：

```
# kldload acpi_ibm
```

并将此行添加到 /boot/loader.conf 以在启动时加载它：

```
acpi_ibm_load="YES"
```

ACPI_VIDEO(4)模块的替代品是背光(9)驱动程序。它提供了一种处理面板背光的通用方法。默认的 GENERIC 内核包含此驱动程序。背光(8)实用程序可用于查询和调整面板背光的亮度。在此示例中，亮度减少了 10%。

```
% backlight decr 10
```

### 14.6.2. CPU 功耗管理

CPU 是系统中功耗最大的部分。知道如何提高 CPU 效率是系统中省电的一个基本部分。

为了正确地利用机器的资源，FreeBSD 通过 powerd(8)和 cpufeq(4)支持诸如 Intel Turbo Boost、AMD Turbo Core、Intel Speed Shift 等技术。

第一步是通过执行以下命令获取 CPU 信息：

```
% sysctl dev.cpu.0 
```

|  | 在这种情况下，0 表示 CPU 的第一个核心。|
| -- | ------------------------------------------ |

输出应该类似于以下内容：

```
dev.cpu.0.cx_method: C1/mwait/hwc C2/mwait/hwc C3/mwait/hwc/bma
dev.cpu.0.cx_usage_counters: 3507294 0 0
dev.cpu.0.cx_usage: 100.00% 0.00% 0.00% last 3804us
dev.cpu.0.cx_lowest: C3 
dev.cpu.0.cx_supported: C1/1/1 C2/2/1 C3/3/57 
dev.cpu.0.freq_levels: 2267/35000 2266/35000 1600/15000 800/12000 
dev.cpu.0.freq: 1600 
dev.cpu.0.temperature: 40.0C 
dev.cpu.0.coretemp.throttle_log: 0
dev.cpu.0.coretemp.tjmax: 105.0C
dev.cpu.0.coretemp.resolution: 1
dev.cpu.0.coretemp.delta: 65
dev.cpu.0.%parent: acpi0
dev.cpu.0.%pnpinfo: _HID=none _UID=0 _CID=none
dev.cpu.0.%location: handle=\_PR_.CPU0
dev.cpu.0.%driver: cpu
dev.cpu.0.%desc: ACPI CPU
```

|  | 用于使 CPU 处于空闲状态的最低 Cx 状态。|
| -- | ----------------------------------------- |
|  | CPU 支持的 Cx 状态。     |
|  | 目前 CPU 的可用级别（频率/功耗）。|
|  | CPU 当前活跃频率（MHz）。|
|  | CPU 当前温度。           |

|  | 如果温度信息未显示，请加载 coretemp(4) 模块。如果使用 AMD CPU，请加载 amdtemp(4) 模块。|
| -- | ----------------------------------------------------------------------------------------- |

如 CPU 信息可用，配置节能的最简单方法就是让 powerd(8) 接管。

在 /etc/rc.conf 中启用 powerd(8) 服务以在系统启动时启动：

```
# sysrc powerd_enable=YES
```

需要指定一些参数给 powerd(8)，告诉它如何管理执行以下命令的 CPU 状态。

```
# sysrc powerd_flags="-a hiadaptive -i 25 -r 85 -N"
```

1. -a ：选择在交流电源下使用的模式。
2. hiadaptive ：操作模式。更多信息请参阅 powerd(8)。
3. -i ：指定自适应模式开始降低性能以节省电源的 CPU 负载百分比水平。
4. -r ：指定自适应模式应考虑 CPU 运行并增加性能的 CPU 负载百分比水平。
5. -N ：将“nice”时间视为负载计算中的空闲时间；即，如果 CPU 仅忙于“nice”进程，则不增加 CPU 频率。

然后执行以下命令启用服务：

```
# service powerd start
```

### 14.6.3. CPU 频率控制

FreeBSD 包括通用的 cpufreq(4) 驱动程序，能让管理员或软件（如 powerd(8) 和 sysutils/powerdxx）管理 CPU 的频率，以实现所需的性能和经济之间的平衡。较低的设置会节省电力，同时减少 CPU 产生的热量。较高的设置会增加性能，但会增加额外的功耗和产生更多的热量。

### 14.6.4. Intel® 提高速度步进™

Intel® 提高速度步进™ 驱动程序 est(4) 取代了为提供此功能的 CPU 提供的通用 cpufreq(4) 驱动程序。可以使用 sysctl(8) 静态调整 CPU 频率，或者使用 /etc/rc.d/power_profile 启动脚本。还可以使用附加软件，如 powerd(8) 或 sysutils/powerdxx，根据处理器利用率自动调整 CPU 频率。

通过检查 sysctl(3) 树，可以列出每个受支持的频率及其预期功耗。

```
# sysctl dev.cpufreq.0.freq_driver dev.cpu.0.freq_levels dev.cpu.0.freq
```

输出应与以下内容类似:

```
dev.cpufreq.0.freq_driver: est0
dev.cpu.0.freq_levels: 3001/53000 3000/53000 2900/50301 2700/46082 2600/43525 2400/39557 2300/37137 2100/33398 2000/31112 1800/27610 1700/25455 1500/22171 1400/20144 1200/17084 1100/15181 900/12329 800/10550
dev.cpu.0.freq: 800
```

CPU 的最大频率高于 1 MHz 表示 Intel® Turbo Boost™ 功能。

### 14.6.5. Intel Speed Shift™

运行更新的 Intel® CPU 的用户在升级到 FreeBSD 13 时可能会发现动态频率控制方面存在一些差异。适用于某些 SKU 的 Intel® Speed Shift™功能集的新驱动程序公开了硬件动态变化核心频率的能力，包括按核心的基础。FreeBSD 13 配备了 hwpstate_intel(4)驱动程序，可自动启用配备的 CPU 上的 Speed Shift™控制，取代了旧的 Enhanced Speed Step™ est(4)驱动程序。sysctl(8) dev.cpufreq.%d.freq_driver 将指示系统是否正在使用 Speed Shift。

要确定正在使用哪个频率控制驱动程序，请检查 dev.cpufreq.0.freq_driver oid。

```
# sysctl dev.cpufreq.0.freq_driver
```

输出应类似于以下内容:

```
dev.cpufreq.0.freq_driver: hwpstate_intel0
```

这表示新的 hwpstate_intel(4)驱动程序正在使用。在这种系统上，oid dev.cpu.%d.freq_levels 将只显示最大 CPU 频率，并指示功耗水平为 -1。

当前 CPU 频率可以通过检查 dev.cpu.%d.freq oid 来确定。

```
# sysctl dev.cpu.0.freq_levels dev.cpu.0.freq
```

输出应类似于以下内容：

```
dev.cpu.0.freq_levels: 3696/-1
dev.cpu.0.freq: 898
```

有关更多信息，请参阅 man 手册 hwpstate_intel(4)，包括如何平衡性能和能量使用以及如何禁用此驱动程序。

|  | 习惯使用 powerd(8) 或 sysutils/powerdxx 的用户会发现这些实用程序已被 hwpstateintel(4) 驱动程序取代，不再按预期工作。|
| -- | ---------------------------------------------------------------------------------------------------------------------- |

### 14.6.6. 显卡功耗管理

近年来，显卡已经成为计算中不可或缺的部分。一些显卡可能有过高的功耗。FreeBSD 能让通过某些配置来改善功耗。

如果使用 Intel®显卡与图形/drm-kmod 驱动程序，可以在/boot/loader.conf 中添加这些选项：

```
compat.linuxkpi.fastboot=1 
compat.linuxkpi.enable_dc=2 
compat.linuxkpi.enable_fbc=1 
```

|  | 尝试在启动时跳过不必要的模式设置。|
| -- | ------------------------------------ |
|  | 启用节能显示 C 状态。    |
|  | 启用帧缓冲压缩以节省电能           |

### 14.6.7. 暂停/恢复

暂停/恢复功能能让将计算机保持在能耗较低的状态，并且能让在不丢失运行程序状态的情况下恢复系统。

|  | 为了使暂停/恢复功能正常工作，必须在系统上加载图形驱动程序。在不支持 KMS 的图形卡中，必须使用 sc(4)以避免破坏暂停/恢复功能。<br /><br />关于使用哪个驱动程序以及如何配置它的更多信息，请参阅 X Window System 章节。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |

acpi(4)支持下一个睡眠状态列表:

支持的睡眠状态表

| S1             | 快速挂起到 RAM。CPU 进入较低的功率状态，但大多数外围设备仍在运行。                              |
| ---------------- | ---------------------------------------------------------------------------------------------------------------- |
| S2             | 比 S1 更低的电源状态，但具有相同的基本特征。许多系统不支持。                                    |
| S3（睡眠模式） | 休眠到 RAM。大多数设备已关闭电源，系统除了内存刷新外停止运行。                                  |
| S4（深度休眠） | 写磁盘以及电源关闭，所有的设备都被关闭，系统停止运行。在恢复时，系统将如同从冷启动一样启动。FreeBSD 尚不支持。|
| S5             | 系统将干净关机并关机。                                                                          |

#### 14.6.7.1. 配置挂起/恢复

第一步将是了解所用硬件支持的睡眠状态类型，执行以下命令：

```
% sysctl hw.acpi.supported_sleep_state
```

输出应类似于以下内容：

```
hw.acpi.supported_sleep_state: S3 S4 S5
```

|  | 正如上文所述，FreeBSD 尚不支持 S4 状态。|
| -- | ------------------------------------------ |

可以使用 acpiconf(8)来检查 S3 状态是否正常工作，运行以下命令，如果成功，屏幕应该变黑，机器将关闭：

```
# acpiconf -s 3
```

在绝大多数情况下，挂起/恢复功能是用于笔记本电脑的。

FreeBSD 可以通过将以下行添加到/etc/sysctl.conf 文件来配置在关闭盖子时进入 S3 状态。

```
hw.acpi.lid_switch_state=S3
```

#### 14.6.7.2. 在暂停/恢复中的故障排除

在 FreeBSD 上已经付出了大量的努力，使暂停和恢复功能能够在某些特定的笔记本电脑上正常工作。

有些检查可以在它不正常工作的情况下进行。

在某些情况下，关闭蓝牙就足够了。在其他情况下，加载正确的显卡驱动程序就足够了，等等。

如果它工作不正常，一些提示可以在 FreeBSD Wiki 的休眠/恢复部分找到。
