# 14.7.添加交换空间

有时候，FreeBSD 系统需要更多的交换空间。本节说明了两种增加交换空间的方法：向现有分区或新硬盘添加交换空间，以及在现有文件系统上创建交换文件。

对于如何加密交换空间、存在哪些选项以及为什么应该这样做的信息，请参阅“加密交换”。

### 14.7.1. 新硬盘或现有分区上的交换

为交换添加新驱动器比使用现有驱动器上的分区性能更好。在添加磁盘中解释了设置分区和驱动器，而在设计分区布局中讨论了分区布局和交换分区大小的注意事项。

|  | 可以使用任何当前未挂载的分区，即使它已经包含数据。在包含数据的分区上使用 swapon 将覆盖并销毁该数据。在运行 swapon 之前，请确保要添加为交换空间的分区确实是所需的分区。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |

可以使用 swapon(8) 将交换分区添加到执行以下命令的系统中：

```
# swapon /dev/ada1p2
```

要在启动时自动添加此交换分区，请向 /etc/fstab 添加条目：

```
/dev/ada1p2 none swap sw 0 0
```

查看 fstab（5）以了解/ etc / fstab 中条目的说明。

### 14.7.2. 创建交换文件

这些示例创建一个名为/ usr / swap0 的 512M 交换文件。

|  | ZFS 文件系统上强烈不建议使用交换文件，因为交换可能导致系统宕机。|
| -- | ------------------------------------------------------------------ |

第一步是创建交换文件：

```
# dd if=/dev/zero of=/usr/swap0 bs=1m count=512
```

第二步是为新文件设置适当的权限：

```
# chmod 0600 /usr/swap0
```

第三步是通过向/etc/fstab 添加一行来通知系统有关交换文件：

```
md none swap sw,file=/usr/swap0,late 0 0
```

交换空间将在系统启动时添加。要立即添加交换空间，请使用 swapon(8)：

```
# swapon -aL
```
