# 15.2.FreeBSD 的引导过程

打开计算机并启动操作系统会造成一个有趣的困境。根据定义，计算机在启动操作系统之前不知道如何做任何事情。这包括从磁盘运行程序。如果计算机没有操作系统就无法从磁盘运行程序，并且操作系统程序位于磁盘上，那么操作系统是如何启动的呢？

这个问题与《巴龙·门豪森的历险记》中的一个问题相似。一个角色部分掉进一个下水道中，靠着抓住自己的靴带并抬起来自己。在计算机的早期，引导程序一词被应用于加载操作系统的机制。自那时起，它已经被缩短为“引导”。

在 x86 硬件上，基本输入/输出系统（BIOS）负责加载操作系统。BIOS 在硬盘上查找主引导记录（MBR），这必须位于磁盘上的特定位置。BIOS 具有足够的知识来加载和运行 MBR，并假定 MBR 可以继续执行加载操作系统的其余任务，可能借助 BIOS 的帮助。

|  | FreeBSD 能让从较旧的 MBR 标准和较新的 GUID 分区表（GPT）引导。GPT 分区通常出现在具有统一可扩展固件接口（UEFI）的计算机上。但是，FreeBSD 即使在只有传统 BIOS 的计算机上也可以从 GPT 分区引导，还可以使用 gptboot(8)。正在进行直接 UEFI 引导的工作。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

MBR 中的代码通常被称为引导管理器，特别是当它与用户交互时。引导管理器通常在磁盘的第一个磁道或文件系统中有更多的代码。引导管理器的示例包括标准的 FreeBSD 引导管理器 boot0，也称为 Boot Easy，以及 GNU GRUB，许多 Linux®发行版使用它。

|  | 使用 GRUB 的用户应参考 GNU 提供的文档。|
| -- | ----------------------------------------- |

如果只安装了一个操作系统，MBR 将搜索磁盘上第一个可引导（活动的）分区，然后运行该分区上的代码以加载操作系统的其余部分。当存在多个操作系统时，可以安装不同的引导管理器以显示操作系统列表，因此用户可以选择要引导的操作系统。

FreeBSD 引导系统的剩余部分分为三个阶段。第一阶段仅了解足够的内容，使计算机进入特定状态并运行第二阶段。第二阶段可以做更多一些，在运行第三阶段之前。第三阶段完成加载操作系统的任务。将工作分成三个阶段是因为 MBR 对可以在第一和第二阶段运行的程序的大小设置了限制。链接这些任务能让 FreeBSD 提供更灵活的加载程序。

然后启动内核，并开始探测设备并初始化它们以供使用。内核引导过程完成之后，内核将控制权转移到用户进程 init(8)，init 确保磁盘处于可用状态，并启动挂载文件系统的用户级资源配置、设置网络卡以在网络上通信，并启动已配置为在启动时运行的进程。

本节更详细地说明了这些阶段，并演示了如何与 FreeBSD 引导过程进行交互。

### 15.2.1. 引导管理器

MBR 中的引导管理器代码有时被称为引导过程的零阶段。默认情况下，FreeBSD 使用 boot0 引导管理器。

FreeBSD 安装程序安装的 MBR 基于/boot/boot0。由于片表和 MBR 末尾的 0x55AA 标识符，boot0 的大小和功能受到限制，仅为 446 个字节。如果安装了 boot0 和多个操作系统，启动时会显示类似于这个示例的消息：

示例 1。boot0 截图

```
F1 Win
F2 FreeBSD

Default: F2
```

如果安装 FreeBSD 后安装其他操作系统，它们会覆盖现有的 MBR。如果发生这种情况，或者要用 FreeBSD MBR 替换现有的 MBR，请使用以下命令：

```
# fdisk -B -b /boot/boot0 device
```

其中设备是引导磁盘，比如第一个 IDE 磁盘的 ad0，第二个 IDE 控制器上的第一个 IDE 磁盘的 ad2，或者第一个 SCSI 磁盘的 da0。要创建自定义配置的 MBR，请参考 boot0cfg(8)。

### 第一阶段和第二阶段

从概念上讲，第一阶段和第二阶段是磁盘上同一个程序的一部分。由于空间限制，它们被分成两部分，但总是一起安装的。它们由 FreeBSD 安装程序或 bsdlabel 从组合的/boot/boot 复制。

这两个阶段位于文件系统之外，在引导切片的第一个磁道，从第一个扇区开始。这是 boot0 或任何其他引导管理器期望找到一个程序来运行，这个程序将继续引导过程。

第一阶段，boot1，非常简单，因为它的大小只能是 512 字节。它对存储有关分区信息的 FreeBSD bsdlabel 有足够的了解，从而找到并执行 boot2。

第二阶段，boot2 稍微复杂一些，对 FreeBSD 文件系统有足够的了解，以找到文件。它可以提供一个简单的界面来选择要运行的内核或加载程序。它运行 loader，loader 更加复杂，提供引导配置文件。如果在第二阶段中断引导过程，将显示以下交互屏幕：

示例 2. boot2 截图

```
>> FreeBSD/i386 BOOT
Default: 0:ad(0,a)/boot/loader
boot:
```

使用 bsdlabel 来替换安装的 boot1 和 boot2，其中 diskslice 是要引导的磁盘和分区，比如 ad0s1 表示第一个 IDE 磁盘上的第一个分区：

```
# bsdlabel -B diskslice
```

|  | 如果仅使用磁盘名称，比如 ad0，则 bsdlabel 将以"危险专用模式"创建磁盘，而不包含分区。这可能不是期望的操作，请在按回车键前再次检查 diskslice。|
| -- | ---------------------------------------------------------------------------------------------------------------------------------------------- |

### 15.2.3. 第三阶段

加载程序是三级引导过程的最后阶段。它位于文件系统上，通常是作为 /boot/loader。

加载程序旨在作为一种交互式配置方法，使用内置命令集进行支持，由更强大的解释器支持，其具有更复杂的命令集。

在初始化期间，加载程序将探测控制台和磁盘，并找出正在引导的磁盘。它将相应地设置变量，并启动一个解释器，用户命令可以从脚本或交互方式传递。

然后加载程序将读取 /boot/loader.rc 文件，默认读取 /boot/defaults/loader.conf 文件，其中设置了变量的合理默认值，并读取 /boot/loader.conf 文件以获取对这些变量的本地更改。loader.rc 然后根据这些变量的值进行操作，加载所选的模块和内核。

最后，默认情况下，加载程序会等待按键操作 10 秒钟，如果没有中断，则启动内核。如果被中断，则用户会看到一个提示符，其中包含理解命令集的命令，用户可以调整变量、卸载所有模块、加载模块，最后启动或重启。加载程序内置命令列出了最常用的加载程序命令。有关所有可用命令的完整讨论，请参考加载程序(8)。

表 1. 加载程序内置命令

| 变量                                                  | 说明                                                                                                                                                                                                  |
| ------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 自动启动秒数                                          | 如果在给定的时间跨度内没有被打断，它将继续引导内核。它显示一个倒计时，而默认的时间跨度是 10 秒。                                                                                       |
| 引导 [ -options ] [ kernelname ]                      | 立即继续引导内核，使用任何指定的选项或内核名称。在发出 unload 命令后才可以在命令行上提供内核名称。否则，将使用之前加载的内核。如果内核名称没有被资格化，它将在 /boot/kernel 和 /boot/modules 下搜索。|
| boot-conf                                             | 根据指定变量执行相同的自动模块配置，最常见的是 kernel。只有在先使用 unload，再更改一些变量的情况下才有意义。                                                                         |
| 帮助 [ <em>topic</em> ]                               | 从 /boot/loader.help 读取显示帮助消息。如果给定主题是 index，则显示可用主题列表。                                                                                                     |
| 包括 <em>filename</em> …                             | 读取指定的文件并逐行解释。错误会立即停止 include。                                                                                                                                    |
| 载入[-t <em>type</em> ] <em>filename</em>             | 加载内核，内核模块或指定文件类型，使用指定文件名。文件名后的任何参数都将传递给文件。如果文件名没有指定路径，将在/boot/kernel 和/boot/modules 下搜索。                                  |
| ls [-l] [ <em>path</em> ]                             | 在给定路径中显示文件列表，如果未指定路径，则显示根目录。如果指定 -l，还会显示文件大小。                                                                                               |
| lsdev [`-v`]                                              | 列出可能加载模块的所有设备。如果指定 -v，将打印更多详细信息。                                                                                                                         |
| lsmod [`-v`]                                              | 显示已加载的模块。如果指定了 -v，则显示更多详细信息。                                                                                                                                 |
| more `<em>filename</em>`                                                 | 显示指定的文件，并在每个显示 LINES 处暂停。                                                                                                                                            |
| 重启                                              | 立即重启系统。                                                                                                                                                                     |
| 设置 <em>variable</em>，设置 <em>variable=value</em> | 设置指定的环境变量。                                                                                                                                                                   |
| 卸载                                                  | 删除所有已加载的模块。                                                                                                                                                                 |

这里是加载器使用的一些实际示例。要将通常的内核引导到单用户模式：

```
 boot -s
```

卸载通常的内核和模块，然后加载以前的或另一个指定的内核：

```
 unload
 load /path/to/kernelfile
```

使用限定的/boot/GENERIC/kernel 来引用安装时自带的默认内核，或者使用/boot/kernel.old/kernel 来引用在系统升级之前或配置自定义内核之前先前安装的内核。

使用以下内容来加载另一个内核的常用模块。请注意，在这种情况下，不需要使用限定名称。

```
unload
set kernel="mykernel"
boot-conf
```

要加载自动化内核配置脚本：

```
 load -t userconfig_script /boot/kernel.conf
```

### 最后阶段 15.2.4。

内核被加载之后，可以是通过引导程序，也可以是通过绕过引导程序的 boot2，它会检查任何引导标志并根据需要调整其行为。引导过程中的内核交互列出了常用的引导标志。有关其他引导标志的更多信息，请参阅 boot（8）。

表 2。引导期间内核交互|选项|说明| | -----------------------| -------------| | -a |在内核初始化期间，要求提供要作为根文件系统挂载的设备。| | -C |从 CDROM 引导根文件系统。| | -s |启动为单用户模式。| | -v |内核启动期间更详细。|

内核完成引导后，将控制权交给位于/sbin/init 的用户进程 init(8)，或者交给 loader 中指定的程序路径。这是引导过程的最后阶段。

引导顺序确保系统上可用的文件系统是一致的。如果 UFS 文件系统不一致，且 fsck 无法修复不一致性，init 会将系统转换为单用户模式，以便系统管理员直接解决问题。否则，系统将启动为多用户模式。

#### 15.2.4.1. 单用户模式

通过使用 -s 启动或在 loader 中设置 boot_single 变量，用户可以指定此模式。也可以通过从多用户模式运行 shutdown now 来进入此模式。单用户模式从此消息开始：

```
Enter full pathname of shell or RETURN for /bin/sh:
```

如果用户按回车键，系统将进入默认的 Bourne shell。要指定不同的 shell，请输入到 shell 的完整路径。

单用户模式通常用于修复因文件系统不一致或引导配置文件中的错误而无法启动的系统。当不知道密码时，也可以用于重置 root 密码。由于单用户模式提示符可以完全访问系统及其配置文件，因此这些操作是可能的。此模式中没有网络。

单用户模式对于修复系统很有用，但除非系统处于物理安全位置，否则会带来安全风险。默认情况下，任何可以获得系统物理访问权限的用户在引导到单用户模式后将完全控制该系统。

如果在 /etc/ttys 中将系统 console 更改为 insecure，系统将在启动单用户模式之前首先提示输入 root 密码。这增加了一定程度的安全性，同时在不知道 root 密码时无法重置密码。

示例 3. 在 /etc/ttys 中配置一个不安全的控制台

```
# name  getty                           type    status          comments
#
# If console is marked "insecure", then init will ask for the root password
# when going to single-user mode.
console none                            unknown off insecure
```

单用户模式意味着控制台的物理安全被认为是不安全的，因此只有知道根密码的人才能使用单用户模式。

#### 15.2.4.2. 多用户模式

如果 init 发现文件系统没有问题，或者用户在单用户模式下完成命令并键入 exit 离开单用户模式，系统就会进入多用户模式，开始对系统进行资源配置。

资源配置系统从 /etc/defaults/rc.conf 中读取配置默认值，从 /etc/rc.conf 中读取系统特定的详细信息。然后它继续挂载 /etc/fstab 中列出的系统文件系统。它启动网络服务，各种系统守护程序，然后启动本地安装包的启动脚本。

要了解更多关于资源配置系统的信息，请参考 rc(8) 并查看位于 /etc/rc.d 中的脚本。
